/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.swing.table.TableModel;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.Handler;
import org.netbeans.modules.websvc.api.jaxws.project.config.HandlerChain;
import org.netbeans.modules.websvc.api.jaxws.project.config.HandlerChains;
import org.netbeans.modules.websvc.api.jaxws.project.config.HandlerChainsProvider;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.support.java.GenerationUtils;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.spi.support.MessageHandlerPanel;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class HandlerButtonListener
implements ActionListener {
    MessageHandlerPanel panel;
    HandlerChains handlerChains;
    HandlerChain chain;
    FileObject handlerFO;
    FileObject implBeanClass;
    Service service;
    boolean isNew;

    public HandlerButtonListener(MessageHandlerPanel panel, HandlerChains handlerChains, FileObject handlerFO, FileObject implBeanClass, Service service, boolean isNew) {
        this.panel = panel;
        this.handlerChains = handlerChains;
        this.handlerFO = handlerFO;
        this.implBeanClass = implBeanClass;
        this.service = service;
        this.isNew = isNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == NotifyDescriptor.OK_OPTION) {
            if (!this.panel.isChanged()) {
                return;
            }
            if (this.isNew) {
                String servicehandlerFileName = this.service.getName() + "_handler";
                FileObject parent = this.implBeanClass.getParent();
                final String handlerFileName = FileUtil.findFreeFileName((FileObject)parent, (String)servicehandlerFileName, (String)"xml");
                CancellableTask<WorkingCopy> modificationTask = new CancellableTask<WorkingCopy>(){

                    public void run(WorkingCopy workingCopy) throws IOException {
                        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                        ClassTree javaClass = SourceUtils.getPublicTopLevelTree((CompilationController)workingCopy);
                        if (javaClass != null) {
                            TreeMaker make = workingCopy.getTreeMaker();
                            ArrayList<AssignmentTree> attrs = new ArrayList<AssignmentTree>();
                            AssignmentTree attr1 = make.Assignment((ExpressionTree)make.Identifier((CharSequence)"file"), (ExpressionTree)make.Literal((Object)(handlerFileName + ".xml")));
                            attrs.add(attr1);
                            AnnotationTree chainAnnotation = make.Annotation((Tree)make.QualIdent("javax.jws.HandlerChain"), attrs);
                            GenerationUtils genUtils = GenerationUtils.newInstance((WorkingCopy)workingCopy);
                            ClassTree modifiedClass = genUtils.addAnnotation(javaClass, chainAnnotation);
                            workingCopy.rewrite((Tree)javaClass, (Tree)modifiedClass);
                        }
                    }

                    public void cancel() {
                    }
                };
                JavaSource targetSource = JavaSource.forFileObject((FileObject)this.implBeanClass);
                try {
                    targetSource.runModificationTask((Task)modificationTask).commit();
                }
                catch (IOException exp) {
                    ErrorManager.getDefault().notify((Throwable)exp);
                }
                this.handlerFO = parent.getFileObject(handlerFileName, "xml");
                if (this.handlerFO == null) {
                    try {
                        WSUtils.retrieveHandlerConfigFromResource((FileObject)parent, (String)(handlerFileName + ".xml"));
                        this.handlerFO = parent.getFileObject(handlerFileName, "xml");
                    }
                    catch (Exception exp) {
                        ErrorManager.getDefault().notify((Throwable)exp);
                    }
                }
                try {
                    this.handlerChains = HandlerChainsProvider.getDefault().getHandlerChains(this.handlerFO);
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                    return;
                }
            }
            this.chain = this.handlerChains.getHandlerChains()[0];
            Handler[] handlers = this.chain.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                this.chain.removeHandler(handlers[i].getHandlerClass());
            }
            TableModel tableModel = this.panel.getHandlerTableModel();
            if (tableModel.getRowCount() > 0) {
                for (int i = 0; i < tableModel.getRowCount(); ++i) {
                    String className = (String)tableModel.getValueAt(i, 0);
                    this.chain.addHandler(className, className);
                }
            }
            FileLock lock = null;
            OutputStream out = null;
            if (this.chain.getHandlers().length == 0) {
                CancellableTask<WorkingCopy> modificationTask = new CancellableTask<WorkingCopy>(){

                    public void run(WorkingCopy workingCopy) throws IOException {
                        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                        TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)workingCopy);
                        if (typeElement != null) {
                            TreeMaker make = workingCopy.getTreeMaker();
                            AnnotationMirror chainAnnotation = JaxWsUtils.getAnnotation(typeElement, "javax.jws.HandlerChain");
                            if (chainAnnotation != null) {
                                ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
                                AnnotationTree anotTree = (AnnotationTree)workingCopy.getTrees().getTree(typeElement, chainAnnotation);
                                ClassTree modifiedClass = make.Class(make.removeModifiersAnnotation(classTree.getModifiers(), anotTree), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), classTree.getExtendsClause(), classTree.getImplementsClause(), classTree.getPermitsClause(), classTree.getMembers());
                                workingCopy.rewrite((Tree)classTree, (Tree)modifiedClass);
                            }
                        }
                    }

                    public void cancel() {
                    }
                };
                JavaSource targetSource = JavaSource.forFileObject((FileObject)this.implBeanClass);
                try {
                    targetSource.runModificationTask((Task)modificationTask).commit();
                }
                catch (IOException exp) {
                    ErrorManager.getDefault().notify((Throwable)exp);
                }
                try {
                    lock = this.handlerFO.lock();
                    this.handlerFO.delete(lock);
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                finally {
                    if (lock != null) {
                        lock.releaseLock();
                    }
                }
            } else {
                try {
                    lock = this.handlerFO.lock();
                    out = this.handlerFO.getOutputStream(lock);
                    this.handlerChains.write(out);
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                finally {
                    if (lock != null) {
                        lock.releaseLock();
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().notify((Throwable)ioe);
                        }
                    }
                }
            }
        }
    }
}

