/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.options;

import java.util.EventListener;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.lexer.Language;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.openide.util.WeakListeners;

public final class OptionsUtils {
    private static final Map<Language<JsTokenId>, OptionsUtils> INSTANCES = new WeakHashMap<Language<JsTokenId>, OptionsUtils>();
    public static final String AUTO_COMPLETION_TYPE_RESOLUTION = "codeCompletionTypeResolution";
    public static final String AUTO_COMPLETION_SMART_QUOTES = "codeCompletionSmartQuotes";
    public static final String AUTO_STRING_CONCATINATION = "codeCompletionStringAutoConcatination";
    public static final String AUTO_COMPLETION_FULL = "autoCompletionFull";
    public static final String AUTO_COMPLETION_AFTER_DOT = "autoCompletionAfterDot";
    public static final String COMPETION_ITEM_SIGNATURE_WIDTH = "codeComletionItemDescriptionWith";
    public static final boolean AUTO_COMPLETION_TYPE_RESOLUTION_DEFAULT = false;
    public static final boolean AUTO_COMPLETION_SMART_QUOTES_DEFAULT = true;
    public static final boolean AUTO_STRING_CONCATINATION_DEFAULT = true;
    public static final boolean AUTO_COMPLETION_FULL_DEFAULT = false;
    public static final boolean AUTO_COMPLETION_AFTER_DOT_DEFAULT = true;
    public static final int COMPETION_ITEM_SIGNATURE_WIDTH_DEFAULT = 40;
    private boolean testDisableUpdater = false;
    private final PreferenceChangeListener asyncPreferencesUpdater = new PreferenceChangeListener(){

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            String settingName;
            if (OptionsUtils.this.testDisableUpdater && evt != null) {
                return;
            }
            String string = settingName = evt == null ? null : evt.getKey();
            if (settingName == null || OptionsUtils.AUTO_COMPLETION_TYPE_RESOLUTION.equals(settingName)) {
                OptionsUtils.this.autoCompletionTypeResolution = OptionsUtils.this.preferences.getBoolean(OptionsUtils.AUTO_COMPLETION_TYPE_RESOLUTION, false);
            }
            if (settingName == null || OptionsUtils.AUTO_COMPLETION_SMART_QUOTES.equals(settingName)) {
                OptionsUtils.this.autoCompletionSmartQuotes = OptionsUtils.this.preferences.getBoolean(OptionsUtils.AUTO_COMPLETION_SMART_QUOTES, true);
            }
            if (settingName == null || OptionsUtils.AUTO_STRING_CONCATINATION.equals(settingName)) {
                OptionsUtils.this.autoStringConcatination = OptionsUtils.this.preferences.getBoolean(OptionsUtils.AUTO_STRING_CONCATINATION, true);
            }
            if (settingName == null || OptionsUtils.AUTO_COMPLETION_FULL.equals(settingName)) {
                OptionsUtils.this.autoCompletionFull = OptionsUtils.this.preferences.getBoolean(OptionsUtils.AUTO_COMPLETION_FULL, false);
            }
            if (settingName == null || OptionsUtils.AUTO_COMPLETION_AFTER_DOT.equals(settingName)) {
                OptionsUtils.this.autoCompletionAfterDot = OptionsUtils.this.preferences.getBoolean(OptionsUtils.AUTO_COMPLETION_AFTER_DOT, true);
            }
            if (settingName == null || OptionsUtils.COMPETION_ITEM_SIGNATURE_WIDTH.equals(settingName)) {
                OptionsUtils.this.codeCompletionItemSignatureWidth = OptionsUtils.this.preferences.getInt(OptionsUtils.COMPETION_ITEM_SIGNATURE_WIDTH, 40);
            }
        }
    };
    private final String mimeType;
    private Preferences preferences;
    private volatile Boolean autoCompletionTypeResolution = null;
    private volatile Boolean autoCompletionSmartQuotes = null;
    private volatile Boolean autoStringConcatination = null;
    private volatile Boolean autoCompletionFull = null;
    private volatile Boolean autoCompletionAfterDot = null;
    private volatile Integer codeCompletionItemSignatureWidth = null;

    private OptionsUtils(Language<JsTokenId> language) {
        this.mimeType = language.mimeType();
    }

    public static synchronized OptionsUtils forLanguage(Language<JsTokenId> language) {
        return INSTANCES.computeIfAbsent(language, OptionsUtils::new);
    }

    public boolean autoCompletionTypeResolution() {
        this.lazyInit();
        assert (this.autoCompletionTypeResolution != null);
        return this.autoCompletionTypeResolution;
    }

    public boolean autoCompletionSmartQuotes() {
        this.lazyInit();
        assert (this.autoCompletionSmartQuotes != null);
        return this.autoCompletionSmartQuotes;
    }

    public boolean autoStringConcatination() {
        this.lazyInit();
        assert (this.autoStringConcatination != null);
        return this.autoStringConcatination;
    }

    public boolean autoCompletionFull() {
        this.lazyInit();
        assert (this.autoCompletionFull != null);
        return this.autoCompletionFull;
    }

    public int getCodeCompletionItemSignatureWidth() {
        this.lazyInit();
        assert (this.codeCompletionItemSignatureWidth != null);
        return this.codeCompletionItemSignatureWidth;
    }

    public boolean autoCompletionAfterDot() {
        this.lazyInit();
        assert (this.autoCompletionAfterDot != null);
        if (this.autoCompletionFull()) {
            return true;
        }
        return this.autoCompletionAfterDot;
    }

    private synchronized void lazyInit() {
        if (this.preferences == null) {
            this.preferences = (Preferences)MimeLookup.getLookup((String)this.mimeType).lookup(Preferences.class);
            this.preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.asyncPreferencesUpdater, (Object)this.preferences));
            this.asyncPreferencesUpdater.preferenceChange(null);
        }
    }

    public void setTestTypeResolution(boolean overwrite) {
        this.autoCompletionTypeResolution = overwrite;
    }

    public void setTestCompletionSmartQuotes(boolean overwrite) {
        this.autoCompletionSmartQuotes = overwrite;
    }

    public void setTestDisablePreferencesTracking() {
        this.testDisableUpdater = true;
    }
}

