/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.formatter;

import com.oracle.js.parser.TokenType;
import com.oracle.js.parser.ir.AccessNode;
import com.oracle.js.parser.ir.BinaryNode;
import com.oracle.js.parser.ir.Block;
import com.oracle.js.parser.ir.BlockStatement;
import com.oracle.js.parser.ir.CallNode;
import com.oracle.js.parser.ir.CaseNode;
import com.oracle.js.parser.ir.CatchNode;
import com.oracle.js.parser.ir.ClassElement;
import com.oracle.js.parser.ir.ClassNode;
import com.oracle.js.parser.ir.ExportNode;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.ExpressionStatement;
import com.oracle.js.parser.ir.ForNode;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.IdentNode;
import com.oracle.js.parser.ir.IfNode;
import com.oracle.js.parser.ir.ImportNode;
import com.oracle.js.parser.ir.JoinPredecessorExpression;
import com.oracle.js.parser.ir.JsxAttributeNode;
import com.oracle.js.parser.ir.JsxElementNode;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.LiteralNode;
import com.oracle.js.parser.ir.LoopNode;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.ObjectNode;
import com.oracle.js.parser.ir.PropertyNode;
import com.oracle.js.parser.ir.Statement;
import com.oracle.js.parser.ir.SwitchNode;
import com.oracle.js.parser.ir.TernaryNode;
import com.oracle.js.parser.ir.TryNode;
import com.oracle.js.parser.ir.UnaryNode;
import com.oracle.js.parser.ir.VarNode;
import com.oracle.js.parser.ir.WhileNode;
import com.oracle.js.parser.ir.WithNode;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.javascript2.editor.formatter.FormatToken;
import org.netbeans.modules.javascript2.editor.formatter.FormatTokenStream;
import org.netbeans.modules.javascript2.editor.formatter.TokenUtils;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;

public class JsFormatVisitor
extends NodeVisitor<LexicalContext> {
    private static final Set<TokenType> UNARY_TYPES = EnumSet.noneOf(TokenType.class);
    private final TokenSequence<? extends JsTokenId> ts;
    private final FormatTokenStream tokenStream;
    private final int formatFinish;
    private final TokenUtils tokenUtils;

    public JsFormatVisitor(FormatTokenStream tokenStream, TokenSequence<? extends JsTokenId> ts, int formatFinish) {
        super(new LexicalContext());
        this.ts = ts;
        this.tokenStream = tokenStream;
        this.formatFinish = formatFinish;
        this.tokenUtils = new TokenUtils(ts, tokenStream, formatFinish);
    }

    public boolean enterBlock(Block block) {
        if (this.isScript(block) || !this.isVirtual(block)) {
            if (this.isScript(block)) {
                this.handleBlockContent(block, true);
            } else {
                this.handleStandardBlock(block);
            }
        }
        if (this.isScript(block) || !this.isVirtual(block)) {
            return false;
        }
        return super.enterBlock(block);
    }

    public Node leaveBlock(Block block) {
        if (this.isScript(block) || !this.isVirtual(block)) {
            return null;
        }
        return super.leaveBlock(block);
    }

    public boolean enterCaseNode(CaseNode caseNode) {
        Statement node;
        List nodes = caseNode.getStatements();
        if (nodes.size() == 1 && (node = (Statement)nodes.get(0)) instanceof BlockStatement) {
            return super.enterCaseNode(caseNode);
        }
        if (nodes.size() >= 1) {
            FormatToken formatToken = this.tokenUtils.getPreviousToken(this.getStart((Node)nodes.get(0)), JsTokenId.OPERATOR_COLON, true);
            if (formatToken != null) {
                TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.INDENTATION_INC));
            }
            if ((formatToken = this.getCaseEndToken(this.getStart((Node)nodes.get(0)), this.getFinish((Node)nodes.get(nodes.size() - 1)))) != null) {
                TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.INDENTATION_DEC));
            }
            this.handleBlockContent(nodes, true);
        }
        return false;
    }

    public boolean enterJsxElementNode(JsxElementNode jsxElementNode) {
        FormatToken jsxToken = this.tokenStream.getToken(this.getStart((Node)jsxElementNode));
        if (jsxToken != null) {
            FormatToken jsxTokenPrev;
            assert (jsxToken.getId() == JsTokenId.JSX_TEXT) : jsxToken.toString() + " from " + jsxElementNode.toString();
            if (jsxToken.getText().toString().startsWith("<") && (jsxTokenPrev = jsxToken.previous()) != null) {
                TokenUtils.appendTokenAfterLastVirtual(jsxTokenPrev, FormatToken.forFormat(FormatToken.Kind.BEFORE_JSX_BLOCK_START), true);
            }
            if ((jsxToken = this.tokenUtils.getPreviousToken(this.getFinish((Node)jsxElementNode) - 1, JsTokenId.JSX_TEXT)) != null && jsxToken.getText().toString().endsWith(">")) {
                assert (jsxToken.getId() == JsTokenId.JSX_TEXT) : jsxToken;
                TokenUtils.appendTokenAfterLastVirtual(jsxToken, FormatToken.forFormat(FormatToken.Kind.AFTER_JSX_BLOCK_END), true);
            }
        }
        for (Expression e : jsxElementNode.getChildren()) {
            int finish;
            if (e instanceof LiteralNode || e instanceof JsxElementNode) continue;
            int start = this.getStart((Node)e);
            FormatToken token = this.tokenUtils.getPreviousToken(start, JsTokenId.JSX_EXP_BEGIN);
            if (token != null) {
                TokenUtils.appendToken(token, FormatToken.forFormat(FormatToken.Kind.INDENTATION_INC));
            }
            if ((token = this.tokenUtils.getNextToken(finish = this.getFinish((Node)e), JsTokenId.JSX_EXP_END)) == null || (token = this.tokenUtils.getPreviousNonWhiteToken(token.getOffset(), start, JsTokenId.JSX_EXP_END, true)) == null) continue;
            TokenUtils.appendToken(token, FormatToken.forFormat(FormatToken.Kind.INDENTATION_DEC));
        }
        return super.enterJsxElementNode(jsxElementNode);
    }

    public boolean enterJsxAttributeNode(JsxAttributeNode jsxAttributeNode) {
        Expression e = jsxAttributeNode.getValue();
        if (e != null && !(e instanceof LiteralNode) && !(e instanceof JsxElementNode)) {
            int finish;
            int start = this.getStart((Node)e);
            FormatToken token = this.tokenUtils.getPreviousToken(start, JsTokenId.JSX_EXP_BEGIN);
            if (token != null) {
                TokenUtils.appendToken(token, FormatToken.forFormat(FormatToken.Kind.INDENTATION_INC));
            }
            if ((token = this.tokenUtils.getNextToken(finish = this.getFinish((Node)e), JsTokenId.JSX_EXP_END)) != null && (token = this.tokenUtils.getPreviousNonWhiteToken(token.getOffset(), start, JsTokenId.JSX_EXP_END, true)) != null) {
                TokenUtils.appendToken(token, FormatToken.forFormat(FormatToken.Kind.INDENTATION_DEC));
            }
        }
        return super.enterJsxAttributeNode(jsxAttributeNode);
    }

    public boolean enterWhileNode(WhileNode whileNode) {
        if (whileNode.isDoWhile()) {
            FormatToken beforeWhile;
            int leftStart = this.getFinish((Node)whileNode.getBody());
            this.markSpacesWithinParentheses((Node)whileNode, leftStart, this.getFinish((Node)whileNode), FormatToken.Kind.AFTER_WHILE_PARENTHESIS, FormatToken.Kind.BEFORE_WHILE_PARENTHESIS);
            this.markSpacesBeforeBrace(whileNode.getBody(), FormatToken.Kind.BEFORE_DO_BRACE);
            FormatToken whileToken = this.tokenUtils.getPreviousToken(this.getFinish((Node)whileNode), JsTokenId.KEYWORD_WHILE);
            if (whileToken != null && (beforeWhile = whileToken.previous()) != null) {
                TokenUtils.appendToken(beforeWhile, FormatToken.forFormat(FormatToken.Kind.BEFORE_WHILE_KEYWORD));
            }
            if (this.handleLoop((LoopNode)whileNode, FormatToken.Kind.AFTER_DO_START)) {
                return false;
            }
            this.markEndCurlyBrace((Node)whileNode.getBody());
            return super.enterWhileNode(whileNode);
        }
        this.markSpacesWithinParentheses((Node)whileNode, this.getStart((Node)whileNode), this.getStart((Node)whileNode.getBody()), FormatToken.Kind.AFTER_WHILE_PARENTHESIS, FormatToken.Kind.BEFORE_WHILE_PARENTHESIS);
        this.markSpacesBeforeBrace(whileNode.getBody(), FormatToken.Kind.BEFORE_WHILE_BRACE);
        if (this.handleLoop((LoopNode)whileNode, FormatToken.Kind.AFTER_WHILE_START)) {
            return false;
        }
        this.markEndCurlyBrace((Node)whileNode.getBody());
        return super.enterWhileNode(whileNode);
    }

    public boolean enterForNode(ForNode forNode) {
        this.markSpacesWithinParentheses((Node)forNode, this.getStart((Node)forNode), this.getStart((Node)forNode.getBody()), FormatToken.Kind.AFTER_FOR_PARENTHESIS, FormatToken.Kind.BEFORE_FOR_PARENTHESIS);
        this.markSpacesBeforeBrace(forNode.getBody(), FormatToken.Kind.BEFORE_FOR_BRACE);
        if (!forNode.isForEach() && !forNode.isForIn()) {
            Expression init = forNode.getInit();
            JoinPredecessorExpression test = forNode.getTest();
            FormatToken formatToken = init != null ? this.tokenUtils.getNextToken(this.getFinish((Node)init), JsTokenId.OPERATOR_SEMICOLON) : this.tokenUtils.getNextToken(this.getStart((Node)forNode), JsTokenId.OPERATOR_SEMICOLON, this.getStart((Node)forNode.getBody()));
            if (formatToken != null && test != null) {
                TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.BEFORE_FOR_TEST));
            }
            if (test != null) {
                formatToken = this.tokenUtils.getNextToken(this.getFinish((Node)forNode.getTest()), JsTokenId.OPERATOR_SEMICOLON);
            } else {
                int start = formatToken != null ? formatToken.getOffset() + 1 : this.getStart((Node)forNode);
                formatToken = this.tokenUtils.getNextToken(start, JsTokenId.OPERATOR_SEMICOLON, this.getStart((Node)forNode.getBody()));
            }
            if (formatToken != null && forNode.getModify() != null) {
                TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.BEFORE_FOR_MODIFY));
            }
        }
        if (this.handleLoop((LoopNode)forNode, FormatToken.Kind.AFTER_FOR_START)) {
            return false;
        }
        this.markEndCurlyBrace((Node)forNode.getBody());
        return super.enterForNode(forNode);
    }

    public boolean enterIfNode(IfNode ifNode) {
        ifNode.getTest().accept((NodeVisitor)this);
        this.markSpacesWithinParentheses((Node)ifNode, this.getStart((Node)ifNode), this.getStart((Node)ifNode.getPass()), FormatToken.Kind.AFTER_IF_PARENTHESIS, FormatToken.Kind.BEFORE_IF_PARENTHESIS);
        Block body = ifNode.getPass();
        this.markSpacesBeforeBrace(body, FormatToken.Kind.BEFORE_IF_BRACE);
        if (this.isVirtual(body)) {
            this.handleVirtualBlock(body, FormatToken.Kind.AFTER_IF_START);
        } else {
            this.enterBlock(body);
            this.markEndCurlyBrace((Node)body);
        }
        body = ifNode.getFail();
        if (body != null) {
            if (this.isVirtual(body)) {
                List statements = body.getStatements();
                if (!statements.isEmpty() && statements.get(0) instanceof IfNode) {
                    this.handleVirtualBlock(body, FormatToken.Kind.ELSE_IF_INDENTATION_INC, FormatToken.Kind.ELSE_IF_INDENTATION_DEC, FormatToken.Kind.ELSE_IF_AFTER_BLOCK_START, true);
                } else {
                    this.markSpacesBeforeBrace(body, FormatToken.Kind.BEFORE_ELSE_BRACE);
                    this.handleVirtualBlock(body, FormatToken.Kind.AFTER_ELSE_START);
                }
            } else {
                this.markSpacesBeforeBrace(body, FormatToken.Kind.BEFORE_ELSE_BRACE);
                this.enterBlock(body);
                this.markEndCurlyBrace((Node)body);
            }
        }
        return false;
    }

    public Node leaveIfNode(IfNode ifNode) {
        return null;
    }

    public boolean enterWithNode(WithNode withNode) {
        this.markSpacesWithinParentheses((Node)withNode, this.getStart((Node)withNode), this.getStart((Node)withNode.getBody()), FormatToken.Kind.AFTER_WITH_PARENTHESIS, FormatToken.Kind.BEFORE_WITH_PARENTHESIS);
        Block body = withNode.getBody();
        this.markSpacesBeforeBrace(body, FormatToken.Kind.BEFORE_WITH_BRACE);
        if (this.isVirtual(body)) {
            this.handleVirtualBlock(body, FormatToken.Kind.AFTER_WITH_START);
            return false;
        }
        this.markEndCurlyBrace((Node)body);
        return super.enterWithNode(withNode);
    }

    public boolean enterFunctionNode(FunctionNode functionNode) {
        Statement last;
        List statements;
        Block body;
        if (functionNode.isModule()) {
            functionNode.visitImports((NodeVisitor)this);
            functionNode.visitExports((NodeVisitor)this);
        }
        if ((body = functionNode.getBody()).isParameterBlock() && !(statements = body.getStatements()).isEmpty() && (last = (Statement)statements.get(statements.size() - 1)) instanceof BlockStatement) {
            BlockStatement blockStatement = (BlockStatement)last;
            body = blockStatement.getBlock();
        }
        if (this.isVirtual(body) && functionNode.getKind() == FunctionNode.Kind.ARROW) {
            FormatToken token;
            Token<? extends JsTokenId> nonEmpty = this.tokenUtils.getPreviousNonEmptyToken(this.getStart((Node)body));
            if (nonEmpty != null && (token = this.tokenStream.getToken(this.ts.offset())) != null) {
                TokenUtils.appendTokenAfterLastVirtual(token, FormatToken.forFormat(FormatToken.Kind.BEFORE_ARROW_BLOCK));
            }
            this.handleVirtualBlock(body, FormatToken.Kind.INDENTATION_INC, FormatToken.Kind.INDENTATION_DEC, null, false);
            nonEmpty = this.tokenUtils.getPreviousNonEmptyToken(this.getFinish((Node)body));
            if (nonEmpty != null && (token = this.tokenStream.getToken(this.ts.offset())) != null) {
                TokenUtils.appendTokenAfterLastVirtual(token, FormatToken.forFormat(FormatToken.Kind.AFTER_ARROW_BLOCK));
            }
        } else {
            this.enterBlock(body);
        }
        if (functionNode.isProgram()) {
            return false;
        }
        int start = this.getStart((Node)functionNode);
        if (functionNode.getKind() == FunctionNode.Kind.ARROW) {
            FormatToken previous;
            FormatToken left;
            FormatToken leftParen = left = this.tokenUtils.getNextToken(start, JsTokenId.BRACKET_LEFT_PAREN, start);
            if (left == null) {
                left = this.tokenUtils.getNextToken(start, JsTokenId.IDENTIFIER, start);
            }
            if (left != null && (previous = left.previous()) != null) {
                TokenUtils.appendToken(previous, FormatToken.forFormat(FormatToken.Kind.BEFORE_ARROW_FUNCTION_DECLARATION));
            }
            this.handleFunctionParameters(functionNode, leftParen);
        } else {
            FormatToken leftParen;
            FormatToken star;
            if (functionNode.getKind() == FunctionNode.Kind.GENERATOR && (star = this.tokenUtils.getNextToken(start, JsTokenId.OPERATOR_MULTIPLICATION)) != null) {
                FormatToken next;
                FormatToken prev = star.previous();
                if (prev != null && (prev.getKind() == FormatToken.Kind.BEFORE_BINARY_OPERATOR || prev.getKind() == FormatToken.Kind.BEFORE_BINARY_OPERATOR_WRAP)) {
                    this.tokenStream.removeToken(prev);
                }
                if ((prev = star.previous()) != null && (prev.getKind() == FormatToken.Kind.BEFORE_BINARY_OPERATOR || prev.getKind() == FormatToken.Kind.BEFORE_BINARY_OPERATOR_WRAP)) {
                    this.tokenStream.removeToken(prev);
                }
                if ((next = star.next()) != null && (next.getKind() == FormatToken.Kind.AFTER_BINARY_OPERATOR || next.getKind() == FormatToken.Kind.AFTER_BINARY_OPERATOR_WRAP)) {
                    this.tokenStream.removeToken(next);
                }
                if ((next = star.next()) != null && (next.getKind() == FormatToken.Kind.AFTER_BINARY_OPERATOR || next.getKind() == FormatToken.Kind.AFTER_BINARY_OPERATOR_WRAP)) {
                    this.tokenStream.removeToken(next);
                }
            }
            if ((leftParen = this.tokenUtils.getNextToken(start, JsTokenId.BRACKET_LEFT_PAREN, this.getStart((Node)body))) != null) {
                FormatToken rightBrace;
                FormatToken previous = leftParen.previous();
                if (previous != null) {
                    TokenUtils.appendToken(previous, FormatToken.forFormat(functionNode.isAnonymous() ? FormatToken.Kind.BEFORE_ANONYMOUS_FUNCTION_DECLARATION : FormatToken.Kind.BEFORE_FUNCTION_DECLARATION));
                }
                this.handleFunctionParameters(functionNode, leftParen);
                FormatToken leftBrace = this.tokenUtils.getNextToken(this.getStart((Node)functionNode), JsTokenId.BRACKET_LEFT_CURLY, this.getFinish((Node)functionNode));
                if (leftBrace != null && (previous = leftBrace.previous()) != null) {
                    TokenUtils.appendToken(previous, FormatToken.forFormat(FormatToken.Kind.BEFORE_FUNCTION_DECLARATION_BRACE));
                }
                if (functionNode.isStatement() && !functionNode.isAnonymous() && (rightBrace = this.tokenUtils.getPreviousToken(this.getFinish((Node)functionNode), JsTokenId.BRACKET_RIGHT_CURLY, leftBrace != null ? leftBrace.getOffset() : start)) != null) {
                    TokenUtils.appendToken(rightBrace, FormatToken.forFormat(FormatToken.Kind.AFTER_STATEMENT));
                }
                this.markEndCurlyBrace((Node)functionNode);
            }
        }
        return false;
    }

    public Node leaveFunctionNode(FunctionNode functionNode) {
        this.leaveBlock(functionNode.getBody());
        return null;
    }

    public boolean enterImportNode(ImportNode importNode) {
        int finish = this.getFinish((Node)importNode);
        FormatToken token = this.tokenUtils.getNextToken(finish, JsTokenId.OPERATOR_SEMICOLON);
        if (token != null) {
            TokenUtils.appendTokenAfterLastVirtual(token, FormatToken.forFormat(FormatToken.Kind.AFTER_STATEMENT));
        }
        return false;
    }

    public boolean enterExportNode(ExportNode exportNode) {
        int finish = this.getFinish((Node)exportNode);
        FormatToken token = this.tokenUtils.getNextToken(finish, JsTokenId.OPERATOR_SEMICOLON);
        if (token != null) {
            TokenUtils.appendTokenAfterLastVirtual(token, FormatToken.forFormat(FormatToken.Kind.AFTER_STATEMENT));
        }
        if (exportNode.isDefault()) {
            return super.enterExportNode(exportNode);
        }
        return false;
    }

    public boolean enterCallNode(CallNode callNode) {
        FormatToken leftBrace = this.tokenUtils.getNextToken(this.getFinish((Node)callNode.getFunction()), JsTokenId.BRACKET_LEFT_PAREN, this.getFinish((Node)callNode));
        if (leftBrace != null) {
            FormatToken rightBrace;
            FormatToken previous = leftBrace.previous();
            if (previous != null) {
                TokenUtils.appendToken(previous, FormatToken.forFormat(FormatToken.Kind.BEFORE_FUNCTION_CALL));
            }
            FormatToken mark = leftBrace.next();
            assert (mark != null && mark.getKind() == FormatToken.Kind.AFTER_LEFT_PARENTHESIS) : mark;
            this.tokenStream.removeToken(mark);
            int stopMark = this.getStart((Node)callNode);
            List args = callNode.getArgs();
            if (!args.isEmpty()) {
                stopMark = this.getFinish((Node)args.get(args.size() - 1));
            }
            if ((rightBrace = this.tokenUtils.getPreviousToken(this.getFinish((Node)callNode) - 1, JsTokenId.BRACKET_RIGHT_PAREN, stopMark)) != null && (previous = TokenUtils.findVirtualToken(rightBrace, FormatToken.Kind.BEFORE_RIGHT_PARENTHESIS, true)) != null) {
                this.tokenStream.removeToken(previous);
            }
            if (!callNode.getArgs().isEmpty()) {
                TokenUtils.appendToken(leftBrace, FormatToken.forFormat(FormatToken.Kind.AFTER_FUNCTION_CALL_PARENTHESIS));
                if (rightBrace != null && (previous = rightBrace.previous()) != null) {
                    TokenUtils.appendToken(previous, FormatToken.forFormat(FormatToken.Kind.BEFORE_FUNCTION_CALL_PARENTHESIS));
                }
            }
            for (Node arg : callNode.getArgs()) {
                FormatToken beforeArg;
                FormatToken argToken = this.tokenUtils.getNextToken(this.getStart(arg), null);
                if (argToken == null || (beforeArg = argToken.previous()) == null) continue;
                TokenUtils.appendToken(beforeArg, FormatToken.forFormat(FormatToken.Kind.BEFORE_FUNCTION_CALL_ARGUMENT));
            }
        }
        this.handleFunctionCallChain(callNode);
        return super.enterCallNode(callNode);
    }

    public boolean enterClassNode(ClassNode classNode) {
        ClassElement constructor;
        FormatToken formatToken;
        this.handleDecorators(classNode.getDecorators());
        Expression heritage = classNode.getClassHeritage();
        if (heritage != null) {
            FormatToken token;
            heritage.accept((NodeVisitor)this);
            FormatToken extendsToken = this.tokenUtils.getPreviousToken(this.getStart((Node)heritage), JsTokenId.KEYWORD_EXTENDS, this.getStart((Node)classNode));
            if (extendsToken != null && (token = extendsToken.previous()) != null) {
                TokenUtils.appendToken(token, FormatToken.forFormat(FormatToken.Kind.BEFORE_CLASS_EXTENDS));
            }
        }
        if ((formatToken = this.tokenUtils.getNextToken(heritage != null ? this.getFinish((Node)heritage) : this.getStart((Node)classNode), JsTokenId.BRACKET_LEFT_CURLY, true)) != null) {
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.INDENTATION_INC));
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.AFTER_CLASS_START));
            FormatToken previous = formatToken.previous();
            if (previous != null) {
                TokenUtils.appendToken(previous, FormatToken.forFormat(FormatToken.Kind.BEFORE_CLASS_DECLARATION_BRACE));
            }
        }
        if ((constructor = classNode.getConstructor()) != null && (constructor.getStart() != classNode.getStart() || constructor.getFinish() != classNode.getFinish())) {
            this.handleDecorators(constructor.getDecorators());
            this.handleClassElement((PropertyNode)constructor, this.getStart((Node)constructor));
        }
        for (Node property : classNode.getClassElements()) {
            PropertyNode propertyNode = (PropertyNode)property;
            this.handleDecorators(propertyNode.getDecorators());
            this.handleClassElement(propertyNode, this.getStart((Node)propertyNode));
        }
        formatToken = this.tokenUtils.getPreviousNonWhiteToken(this.getFinish((Node)classNode) - 1, this.getStart((Node)classNode), JsTokenId.BRACKET_RIGHT_CURLY, true);
        if (formatToken != null) {
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.BEFORE_CLASS_END));
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.INDENTATION_DEC));
        }
        this.markEndCurlyBrace((Node)classNode);
        return false;
    }

    public boolean enterObjectNode(ObjectNode objectNode) {
        FormatToken formatToken = this.tokenUtils.getPreviousToken(this.getStart((Node)objectNode), JsTokenId.BRACKET_LEFT_CURLY, true);
        if (formatToken != null) {
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.INDENTATION_INC));
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.AFTER_LEFT_BRACE));
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.AFTER_OBJECT_START));
            FormatToken previous = formatToken.previous();
            if (previous != null) {
                TokenUtils.appendToken(previous, FormatToken.forFormat(FormatToken.Kind.BEFORE_OBJECT));
            }
        }
        int objectFinish = this.getFinish((Node)objectNode);
        for (Node property : objectNode.getElements()) {
            property.accept((NodeVisitor)this);
            PropertyNode propertyNode = (PropertyNode)property;
            if (propertyNode.getGetter() != null) {
                FunctionNode getter = propertyNode.getGetter();
                this.markPropertyFinish(this.getFinish((Node)getter), objectFinish, false);
            }
            if (propertyNode.getSetter() != null) {
                FunctionNode setter = propertyNode.getSetter();
                this.markPropertyFinish(this.getFinish((Node)setter), objectFinish, false);
            }
            this.markPropertyFinish(this.getFinish(property), objectFinish, true);
        }
        formatToken = this.tokenUtils.getPreviousNonWhiteToken(this.getFinish((Node)objectNode) - 1, this.getStart((Node)objectNode), JsTokenId.BRACKET_RIGHT_CURLY, true);
        if (formatToken != null) {
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.BEFORE_OBJECT_END));
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.BEFORE_RIGHT_BRACE));
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.INDENTATION_DEC));
        }
        return false;
    }

    public boolean enterPropertyNode(PropertyNode propertyNode) {
        FormatToken colon = this.tokenUtils.getNextToken(this.getFinish((Node)propertyNode.getKey()), JsTokenId.OPERATOR_COLON, this.getFinish((Node)propertyNode));
        if (colon != null) {
            TokenUtils.appendToken(colon, FormatToken.forFormat(FormatToken.Kind.AFTER_PROPERTY_OPERATOR));
            FormatToken before = colon.previous();
            if (before != null) {
                TokenUtils.appendTokenAfterLastVirtual(before, FormatToken.forFormat(FormatToken.Kind.BEFORE_PROPERTY_OPERATOR));
            }
        }
        return super.enterPropertyNode(propertyNode);
    }

    public boolean enterSwitchNode(SwitchNode switchNode) {
        this.markSpacesWithinParentheses(switchNode);
        this.markSpacesBeforeBrace(switchNode);
        FormatToken formatToken = this.tokenUtils.getNextToken(this.getStart((Node)switchNode), JsTokenId.BRACKET_LEFT_CURLY, true);
        if (formatToken != null) {
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.INDENTATION_INC));
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.AFTER_BLOCK_START));
        }
        ArrayList<CaseNode> nodes = new ArrayList<CaseNode>(switchNode.getCases());
        if (switchNode.getDefaultCase() != null) {
            nodes.add(switchNode.getDefaultCase());
        }
        for (CaseNode caseNode : nodes) {
            int index = this.getFinish((Node)caseNode);
            List statements = caseNode.getStatements();
            if (!statements.isEmpty()) {
                index = this.getStart((Node)statements.get(0));
            }
            if ((formatToken = this.tokenUtils.getPreviousToken(index, JsTokenId.OPERATOR_COLON)) == null) continue;
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.AFTER_CASE));
        }
        formatToken = this.tokenUtils.getPreviousNonWhiteToken(this.getFinish((Node)switchNode), this.getStart((Node)switchNode), JsTokenId.BRACKET_RIGHT_CURLY, true);
        if (formatToken != null) {
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.INDENTATION_DEC));
        }
        this.markEndCurlyBrace((Node)switchNode);
        return super.enterSwitchNode(switchNode);
    }

    public boolean enterUnaryNode(UnaryNode unaryNode) {
        TokenType type = unaryNode.tokenType();
        if (UNARY_TYPES.contains(type)) {
            if (TokenType.DECPOSTFIX.equals((Object)type) || TokenType.INCPOSTFIX.equals((Object)type)) {
                FormatToken formatToken = this.tokenUtils.getPreviousToken(this.getFinish((Node)unaryNode), TokenType.DECPOSTFIX.equals((Object)type) ? JsTokenId.OPERATOR_DECREMENT : JsTokenId.OPERATOR_INCREMENT);
                if (formatToken != null && (formatToken = formatToken.previous()) != null) {
                    TokenUtils.appendToken(formatToken, FormatToken.forFormat(FormatToken.Kind.BEFORE_UNARY_OPERATOR));
                }
            } else {
                FormatToken formatToken = this.tokenUtils.getNextToken(this.getStart((Node)unaryNode), null);
                if (formatToken != null) {
                    if (TokenType.ADD.equals((Object)type) || TokenType.SUB.equals((Object)type)) {
                        assert (formatToken.getId() == JsTokenId.OPERATOR_PLUS || formatToken.getId() == JsTokenId.OPERATOR_MINUS) : formatToken;
                        FormatToken toRemove = TokenUtils.findVirtualToken(formatToken, FormatToken.Kind.BEFORE_BINARY_OPERATOR, true);
                        assert (toRemove != null && toRemove.getKind() == FormatToken.Kind.BEFORE_BINARY_OPERATOR) : toRemove;
                        this.tokenStream.removeToken(toRemove);
                        toRemove = TokenUtils.findVirtualToken(formatToken, FormatToken.Kind.BEFORE_BINARY_OPERATOR_WRAP, true);
                        assert (toRemove != null && toRemove.getKind() == FormatToken.Kind.BEFORE_BINARY_OPERATOR_WRAP) : toRemove;
                        this.tokenStream.removeToken(toRemove);
                        toRemove = TokenUtils.findVirtualToken(formatToken, FormatToken.Kind.AFTER_BINARY_OPERATOR, false);
                        assert (toRemove != null && toRemove.getKind() == FormatToken.Kind.AFTER_BINARY_OPERATOR) : toRemove;
                        this.tokenStream.removeToken(toRemove);
                        toRemove = TokenUtils.findVirtualToken(formatToken, FormatToken.Kind.AFTER_BINARY_OPERATOR_WRAP, false);
                        assert (toRemove != null && toRemove.getKind() == FormatToken.Kind.AFTER_BINARY_OPERATOR_WRAP) : toRemove;
                        this.tokenStream.removeToken(toRemove);
                    }
                    TokenUtils.appendToken(formatToken, FormatToken.forFormat(FormatToken.Kind.AFTER_UNARY_OPERATOR));
                }
            }
        }
        return super.enterUnaryNode(unaryNode);
    }

    public boolean enterTernaryNode(TernaryNode ternaryNode) {
        int start = this.getFinish((Node)ternaryNode.getTest());
        FormatToken question = this.tokenUtils.getNextToken(start, JsTokenId.OPERATOR_TERNARY);
        if (question != null) {
            FormatToken previous = question.previous();
            if (previous != null) {
                TokenUtils.appendToken(previous, FormatToken.forFormat(FormatToken.Kind.BEFORE_TERNARY_OPERATOR));
                TokenUtils.appendToken(previous, FormatToken.forFormat(FormatToken.Kind.BEFORE_TERNARY_OPERATOR_WRAP));
            }
            TokenUtils.appendToken(question, FormatToken.forFormat(FormatToken.Kind.AFTER_TERNARY_OPERATOR));
            TokenUtils.appendToken(question, FormatToken.forFormat(FormatToken.Kind.AFTER_TERNARY_OPERATOR_WRAP));
            FormatToken colon = this.tokenUtils.getPreviousToken(this.getStart((Node)ternaryNode.getFalseExpression()), JsTokenId.OPERATOR_COLON);
            if (colon != null) {
                previous = colon.previous();
                if (previous != null) {
                    TokenUtils.appendToken(previous, FormatToken.forFormat(FormatToken.Kind.BEFORE_TERNARY_OPERATOR));
                    TokenUtils.appendToken(previous, FormatToken.forFormat(FormatToken.Kind.BEFORE_TERNARY_OPERATOR_WRAP));
                }
                TokenUtils.appendToken(colon, FormatToken.forFormat(FormatToken.Kind.AFTER_TERNARY_OPERATOR));
                TokenUtils.appendToken(colon, FormatToken.forFormat(FormatToken.Kind.AFTER_TERNARY_OPERATOR_WRAP));
            }
        }
        return super.enterTernaryNode(ternaryNode);
    }

    public boolean enterCatchNode(CatchNode catchNode) {
        this.markSpacesWithinParentheses((Node)catchNode, this.getStart((Node)catchNode), this.getStart((Node)catchNode.getBody()), FormatToken.Kind.AFTER_CATCH_PARENTHESIS, FormatToken.Kind.BEFORE_CATCH_PARENTHESIS);
        this.markSpacesBeforeBrace(catchNode.getBody(), FormatToken.Kind.BEFORE_CATCH_BRACE);
        this.markEndCurlyBrace((Node)catchNode.getBody());
        return super.enterCatchNode(catchNode);
    }

    public boolean enterTryNode(TryNode tryNode) {
        this.markSpacesBeforeBrace(tryNode.getBody(), FormatToken.Kind.BEFORE_TRY_BRACE);
        Block finallyBody = tryNode.getFinallyBody();
        if (finallyBody != null) {
            this.markSpacesBeforeBrace(tryNode.getFinallyBody(), FormatToken.Kind.BEFORE_FINALLY_BRACE);
        }
        this.markEndCurlyBrace((Node)tryNode.getBody());
        this.markEndCurlyBrace((Node)finallyBody);
        return super.enterTryNode(tryNode);
    }

    public boolean enterLiteralNode(LiteralNode<?> literalNode) {
        Object value = literalNode.getValue();
        if (value instanceof Node[]) {
            Node[] items;
            int finish;
            int start = this.getStart((Node)literalNode);
            FormatToken leftBracket = this.tokenUtils.getNextToken(start, JsTokenId.BRACKET_LEFT_BRACKET, finish = this.getFinish((Node)literalNode));
            if (leftBracket != null) {
                FormatToken previous;
                if (leftBracket.previous() != null) {
                    TokenUtils.appendToken(leftBracket.previous(), FormatToken.forFormat(FormatToken.Kind.BEFORE_ARRAY));
                }
                TokenUtils.appendToken(leftBracket, FormatToken.forFormat(FormatToken.Kind.AFTER_ARRAY_LITERAL_START));
                TokenUtils.appendToken(leftBracket, FormatToken.forFormat(FormatToken.Kind.AFTER_ARRAY_LITERAL_BRACKET));
                TokenUtils.appendToken(leftBracket, FormatToken.forFormat(FormatToken.Kind.INDENTATION_INC));
                FormatToken rightBracket = this.tokenUtils.getPreviousToken(finish - 1, JsTokenId.BRACKET_RIGHT_BRACKET, start + 1);
                if (rightBracket != null && (previous = rightBracket.previous()) != null) {
                    TokenUtils.appendToken(previous, FormatToken.forFormat(FormatToken.Kind.BEFORE_ARRAY_LITERAL_END));
                    TokenUtils.appendToken(previous, FormatToken.forFormat(FormatToken.Kind.BEFORE_ARRAY_LITERAL_BRACKET));
                    TokenUtils.appendToken(previous, FormatToken.forFormat(FormatToken.Kind.INDENTATION_DEC));
                }
            }
            if (literalNode.isArray() && (items = (Node[])((LiteralNode.ArrayLiteralNode)literalNode).getValue()) != null && items.length > 0) {
                int prevItemFinish = start;
                for (int i = 1; i < items.length; ++i) {
                    FormatToken comma;
                    Node prevItem = items[i - 1];
                    if (prevItem != null) {
                        prevItemFinish = this.getFinish(prevItem);
                    }
                    if ((comma = this.tokenUtils.getNextToken(prevItemFinish, JsTokenId.OPERATOR_COMMA, finish)) == null) continue;
                    prevItemFinish = comma.getOffset();
                    TokenUtils.appendTokenAfterLastVirtual(comma, FormatToken.forFormat(FormatToken.Kind.AFTER_ARRAY_LITERAL_ITEM));
                }
            }
        }
        return super.enterLiteralNode(literalNode);
    }

    public boolean enterVarNode(VarNode varNode) {
        FormatToken formatToken;
        if (varNode.isExport() || varNode.isDestructuring()) {
            return false;
        }
        int finish = this.getFinish((Node)varNode) - 1;
        Token<? extends JsTokenId> nextToken = this.tokenUtils.getNextNonEmptyToken(finish);
        if (nextToken != null && nextToken.id() == JsTokenId.OPERATOR_COMMA && (formatToken = this.tokenStream.getToken(this.ts.offset())) != null) {
            FormatToken next = formatToken.next();
            assert (next != null && next.getKind() == FormatToken.Kind.AFTER_COMMA) : next;
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.AFTER_VAR_DECLARATION));
        }
        return super.enterVarNode(varNode);
    }

    public boolean enterClassElement(ClassElement propertyNode) {
        FormatToken colon = this.tokenUtils.getNextToken(this.getFinish((Node)propertyNode.getKey()), JsTokenId.OPERATOR_COLON, this.getFinish((Node)propertyNode));
        if (colon != null) {
            TokenUtils.appendToken(colon, FormatToken.forFormat(FormatToken.Kind.AFTER_PROPERTY_OPERATOR));
            FormatToken before = colon.previous();
            if (before != null) {
                TokenUtils.appendTokenAfterLastVirtual(before, FormatToken.forFormat(FormatToken.Kind.BEFORE_PROPERTY_OPERATOR));
            }
        }
        return super.enterPropertyNode((PropertyNode)propertyNode);
    }

    private void handleFunctionParameters(FunctionNode functionNode, FormatToken leftParen) {
        if (leftParen != null) {
            FormatToken previous;
            FormatToken mark = leftParen.next();
            assert (mark != null && mark.getKind() == FormatToken.Kind.AFTER_LEFT_PARENTHESIS) : mark;
            this.tokenStream.removeToken(mark);
            FormatToken rightParen = this.tokenUtils.getPreviousToken(this.getStart((Node)functionNode.getBody()), JsTokenId.BRACKET_RIGHT_PAREN, leftParen.getOffset());
            if (rightParen != null) {
                previous = rightParen.previous();
                assert (previous != null && previous.getKind() == FormatToken.Kind.BEFORE_RIGHT_PARENTHESIS) : previous;
                this.tokenStream.removeToken(previous);
            }
            if (!functionNode.getParameters().isEmpty()) {
                TokenUtils.appendToken(leftParen, FormatToken.forFormat(FormatToken.Kind.AFTER_FUNCTION_DECLARATION_PARENTHESIS));
                if (rightParen != null && (previous = rightParen.previous()) != null) {
                    TokenUtils.appendToken(previous, FormatToken.forFormat(FormatToken.Kind.BEFORE_FUNCTION_DECLARATION_PARENTHESIS));
                }
            }
        }
        for (IdentNode param : functionNode.getParameters()) {
            FormatToken beforeIdent;
            FormatToken paramToken = this.tokenUtils.getNextToken(this.getStart((Node)param), JsTokenId.IDENTIFIER);
            if (paramToken == null) continue;
            Token<? extends JsTokenId> previousNonEmpty = this.tokenUtils.getPreviousNonEmptyToken(paramToken.getOffset());
            if (previousNonEmpty != null && previousNonEmpty.id() == JsTokenId.OPERATOR_REST) {
                paramToken = this.tokenStream.getToken(this.ts.offset());
            }
            if ((beforeIdent = paramToken.previous()) == null) continue;
            TokenUtils.appendToken(beforeIdent, FormatToken.forFormat(FormatToken.Kind.BEFORE_FUNCTION_DECLARATION_PARAMETER));
        }
    }

    private void handleFunctionCallChain(CallNode callNode) {
        CallNode chained;
        int finish;
        FormatToken formatToken;
        AccessNode accessNode;
        Expression base;
        Expression function = callNode.getFunction();
        if (function instanceof AccessNode && (base = (accessNode = (AccessNode)function).getBase()) instanceof CallNode && (formatToken = this.tokenUtils.getNextToken(finish = this.getFinish((Node)(chained = (CallNode)base)), JsTokenId.OPERATOR_DOT)) != null) {
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.AFTER_CHAIN_CALL_DOT));
            formatToken = formatToken.previous();
            if (formatToken != null) {
                TokenUtils.appendToken(formatToken, FormatToken.forFormat(FormatToken.Kind.BEFORE_CHAIN_CALL_DOT));
            }
        }
    }

    private boolean handleLoop(LoopNode loopNode, FormatToken.Kind afterStart) {
        Block body = loopNode.getBody();
        if (this.isVirtual(body)) {
            this.handleVirtualBlock(body, afterStart);
            return true;
        }
        return false;
    }

    private void handleStandardBlock(Block block) {
        this.handleBlockContent(block, true);
        FormatToken formatToken = this.tokenUtils.getPreviousToken(this.getStart((Node)block), JsTokenId.BRACKET_LEFT_CURLY, true);
        if (formatToken != null && !this.isScript(block)) {
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.INDENTATION_INC));
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.AFTER_BLOCK_START));
        }
        if ((formatToken = this.tokenUtils.getNextToken(this.getFinish((Node)block) - 1, JsTokenId.BRACKET_RIGHT_CURLY)) != null && (formatToken = this.tokenUtils.getPreviousNonWhiteToken(formatToken.getOffset(), this.getStart((Node)block), JsTokenId.BRACKET_RIGHT_CURLY, true)) != null && !this.isScript(block)) {
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.INDENTATION_DEC));
        }
    }

    private void handleVirtualBlock(Block block, FormatToken.Kind afterBlock) {
        this.handleVirtualBlock(block, FormatToken.Kind.INDENTATION_INC, FormatToken.Kind.INDENTATION_DEC, afterBlock, true);
    }

    private void handleVirtualBlock(Block block, FormatToken.Kind indentationInc, FormatToken.Kind indentationDec, FormatToken.Kind afterBlock, boolean markStatements) {
        assert (this.isVirtual(block)) : block;
        boolean assertsEnabled = false;
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertsEnabled && block.getStatements().size() > 1) {
            int count = 0;
            for (Node node : block.getStatements()) {
                if (node instanceof VarNode) continue;
                ++count;
            }
            assert (count <= 1);
        }
        if (block.getStart() >= block.getFinish()) {
            return;
        }
        this.handleBlockContent(block, markStatements);
        Token<? extends JsTokenId> token = this.tokenUtils.getPreviousNonEmptyToken(this.getStart((Node)block));
        if (token != null) {
            FormatToken formatToken = this.tokenStream.getToken(this.ts.offset());
            if (!this.isScript(block)) {
                if (formatToken == null && this.ts.offset() <= this.formatFinish) {
                    formatToken = this.tokenStream.getTokens().get(0);
                }
                if (formatToken != null) {
                    TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(indentationInc));
                    if (afterBlock != null) {
                        TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(afterBlock));
                    }
                }
            }
        }
        int finish = this.getFinish((Node)block);
        FormatToken formatToken = this.tokenUtils.getPreviousToken(block.getStart() < finish ? finish - 1 : finish, null, true);
        if (formatToken != null && !this.isScript(block)) {
            while (formatToken != null && (formatToken.getKind() == FormatToken.Kind.EOL || formatToken.getKind() == FormatToken.Kind.WHITESPACE || formatToken.getKind() == FormatToken.Kind.LINE_COMMENT || formatToken.getKind() == FormatToken.Kind.BLOCK_COMMENT || formatToken.getKind() == FormatToken.Kind.DOC_COMMENT)) {
                formatToken = formatToken.previous();
            }
            if (block.getStatementCount() == 0 && block.getStart() < block.getFinish()) {
                TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.AFTER_STATEMENT));
            }
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(indentationDec));
        }
    }

    private void handleBlockContent(Block block, boolean markStatements) {
        this.handleBlockContent(block.getStatements(), markStatements);
    }

    private void handleBlockContent(List<Statement> statements, boolean markStatements) {
        boolean destructuring = false;
        for (int i = 0; i < statements.size(); ++i) {
            FormatToken formatToken;
            int searchOffset;
            Node statement = (Node)statements.get(i);
            statement.accept((NodeVisitor)this);
            if (!markStatements) continue;
            int start = this.getStart(statement);
            int finish = this.getFinish(statement);
            if (statement instanceof VarNode) {
                VarNode varNode = (VarNode)statement;
                if (varNode.isDestructuring()) {
                    destructuring = true;
                    continue;
                }
                if (!this.isDeclaration(varNode)) {
                    int index = i + 1;
                    Node lastVarNode = statement;
                    while (i + 1 < statements.size()) {
                        Node next;
                        if (!((next = (Node)statements.get(++i)) instanceof VarNode) || this.isDeclaration((VarNode)next)) {
                            --i;
                            break;
                        }
                        Token<? extends JsTokenId> token = this.tokenUtils.getPreviousNonEmptyToken(this.getStart(next));
                        if (token != null && (JsTokenId.KEYWORD_VAR == token.id() || JsTokenId.KEYWORD_CONST == token.id() || JsTokenId.RESERVED_LET == token.id())) {
                            --i;
                            break;
                        }
                        lastVarNode = next;
                    }
                    for (int j = index; j < i + 1; ++j) {
                        Node skipped = (Node)statements.get(j);
                        skipped.accept((NodeVisitor)this);
                    }
                    finish = this.getFinish(lastVarNode);
                }
            }
            int n = searchOffset = start < finish ? finish - 1 : finish;
            if (statement instanceof ExpressionStatement && destructuring) {
                searchOffset = finish;
            }
            destructuring = false;
            for (formatToken = this.tokenUtils.getPreviousToken(searchOffset, null); formatToken != null && (formatToken.getKind() == FormatToken.Kind.EOL || formatToken.getKind() == FormatToken.Kind.WHITESPACE || formatToken.getKind() == FormatToken.Kind.LINE_COMMENT || formatToken.getKind() == FormatToken.Kind.BLOCK_COMMENT || formatToken.getKind() == FormatToken.Kind.DOC_COMMENT); formatToken = formatToken.previous()) {
            }
            if (formatToken == null) continue;
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.AFTER_STATEMENT), true);
        }
    }

    private void handleClassElement(PropertyNode propertyNode, int start) {
        propertyNode.accept((NodeVisitor)this);
        if (propertyNode.getGetter() != null) {
            FunctionNode getter = propertyNode.getGetter();
            this.markClassElementFinish(this.getStart((Node)getter), this.getFinish((Node)getter), start, false, (Expression)propertyNode.getGetter());
        }
        if (propertyNode.getSetter() != null) {
            FunctionNode setter = propertyNode.getSetter();
            this.markClassElementFinish(this.getStart((Node)setter), this.getFinish((Node)setter), start, false, (Expression)propertyNode.getSetter());
        }
        this.markClassElementFinish(this.getStart((Node)propertyNode), this.getFinish((Node)propertyNode), start, true, propertyNode.getValue());
    }

    private void handleDecorators(List<Expression> decorators) {
        for (Expression decorator : decorators) {
            FormatToken formatToken = this.tokenUtils.getPreviousNonWhiteToken(this.getFinish((Node)decorator) - 1, -1, null, true);
            if (formatToken == null) continue;
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.AFTER_DECORATOR));
        }
    }

    private void markSpacesWithinParentheses(SwitchNode node) {
        int leftStart = this.getStart((Node)node);
        FormatToken token = this.tokenUtils.getNextToken(leftStart, JsTokenId.BRACKET_LEFT_CURLY, this.getFinish((Node)node));
        if (token != null) {
            this.markSpacesWithinParentheses((Node)node, leftStart, token.getOffset(), FormatToken.Kind.AFTER_SWITCH_PARENTHESIS, FormatToken.Kind.BEFORE_SWITCH_PARENTHESIS);
        }
    }

    private void markSpacesBeforeBrace(SwitchNode node) {
        FormatToken previous;
        int leftStart = this.getStart((Node)node);
        FormatToken token = this.tokenUtils.getNextToken(leftStart, JsTokenId.BRACKET_LEFT_CURLY, this.getFinish((Node)node));
        if (token != null && (previous = token.previous()) != null) {
            TokenUtils.appendToken(previous, FormatToken.forFormat(FormatToken.Kind.BEFORE_SWITCH_BRACE));
        }
    }

    private void markSpacesWithinParentheses(Node outerNode, int leftStart, int rightStart, FormatToken.Kind leftMark, FormatToken.Kind rightMark) {
        FormatToken leftParen = this.tokenUtils.getNextToken(leftStart, JsTokenId.BRACKET_LEFT_PAREN, this.getFinish(outerNode));
        if (leftParen != null) {
            FormatToken mark = leftParen.next();
            assert (mark != null && mark.getKind() == FormatToken.Kind.AFTER_LEFT_PARENTHESIS) : mark;
            if (mark.getKind() == FormatToken.Kind.AFTER_LEFT_PARENTHESIS) {
                this.tokenStream.removeToken(mark);
            }
            TokenUtils.appendToken(leftParen, FormatToken.forFormat(leftMark));
            FormatToken rightParen = this.tokenUtils.getPreviousToken(rightStart, JsTokenId.BRACKET_RIGHT_PAREN, this.getStart(outerNode));
            if (rightParen != null) {
                FormatToken previous = rightParen.previous();
                assert (previous != null && previous.getKind() == FormatToken.Kind.BEFORE_RIGHT_PARENTHESIS) : previous;
                if (previous.getKind() == FormatToken.Kind.BEFORE_RIGHT_PARENTHESIS) {
                    this.tokenStream.removeToken(previous);
                }
                if ((previous = rightParen.previous()) != null) {
                    TokenUtils.appendToken(previous, FormatToken.forFormat(rightMark));
                }
            }
        }
    }

    private void markSpacesBeforeBrace(Block block, FormatToken.Kind mark) {
        FormatToken previous;
        FormatToken brace = this.tokenUtils.getPreviousToken(this.getStart((Node)block), null, this.getStart((Node)block) - 1);
        if (brace != null && (previous = brace.previous()) != null) {
            TokenUtils.appendToken(previous, FormatToken.forFormat(mark));
        }
    }

    private void markPropertyFinish(int finish, int objectFinish, boolean checkDuplicity) {
        FormatToken formatToken = this.tokenUtils.getNextToken(finish, JsTokenId.OPERATOR_COMMA, objectFinish - 1);
        if (formatToken != null) {
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.AFTER_PROPERTY), checkDuplicity);
        }
    }

    private void markClassElementFinish(int start, int finish, int classFinish, boolean checkDuplicity, Expression value) {
        FormatToken formatToken;
        if (value instanceof FunctionNode) {
            formatToken = this.tokenUtils.getPreviousToken(finish, JsTokenId.BRACKET_RIGHT_CURLY, classFinish);
        } else {
            for (formatToken = this.tokenUtils.getPreviousToken(start < finish ? finish - 1 : finish, null); formatToken != null && (formatToken.getKind() == FormatToken.Kind.EOL || formatToken.getKind() == FormatToken.Kind.WHITESPACE || formatToken.getKind() == FormatToken.Kind.LINE_COMMENT || formatToken.getKind() == FormatToken.Kind.BLOCK_COMMENT || formatToken.getKind() == FormatToken.Kind.DOC_COMMENT); formatToken = formatToken.previous()) {
            }
        }
        if (formatToken != null) {
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.AFTER_ELEMENT), checkDuplicity);
        }
    }

    private void markEndCurlyBrace(Node node) {
        FormatToken formatToken;
        if (node != null && (formatToken = this.tokenStream.getToken(this.getFinish(node) - 1)) != null) {
            while (formatToken.isVirtual()) {
                if ((formatToken = formatToken.previous()) != null) continue;
                return;
            }
            if (formatToken.getId() == JsTokenId.BRACKET_RIGHT_CURLY) {
                TokenUtils.appendToken(formatToken, FormatToken.forFormat(FormatToken.Kind.AFTER_END_BRACE));
            }
        }
    }

    private FormatToken getCaseEndToken(int start, int finish) {
        this.ts.move(finish);
        if (!this.ts.moveNext() && !this.ts.movePrevious()) {
            return null;
        }
        Token ret = null;
        while (this.ts.moveNext()) {
            Token token = this.ts.token();
            if (token.id() == JsTokenId.BLOCK_COMMENT || token.id() == JsTokenId.DOC_COMMENT || token.id() == JsTokenId.LINE_COMMENT || token.id() == JsTokenId.EOL || token.id() == JsTokenId.WHITESPACE) continue;
            ret = token;
            break;
        }
        if (ret != null) {
            while (this.ts.movePrevious() && this.ts.offset() >= start) {
                Token current = this.ts.token();
                if (current.id() == JsTokenId.WHITESPACE) continue;
                ret = current;
                break;
            }
            return this.tokenUtils.getFallback(this.ts.offset(), true);
        }
        return null;
    }

    private int getStart(Node node) {
        Objects.requireNonNull(node);
        if (node instanceof BinaryNode) {
            BinaryNode binaryNode = (BinaryNode)node;
            return this.getStart(binaryNode);
        }
        if (node instanceof FunctionNode) {
            FunctionNode functionNode = (FunctionNode)node;
            return JsFormatVisitor.getFunctionStart(functionNode);
        }
        int start = node.getStart();
        long firstToken = node.getToken();
        TokenType type = com.oracle.js.parser.Token.descType((long)firstToken);
        if (type.equals((Object)TokenType.STRING) || type.equals((Object)TokenType.ESCSTRING)) {
            Token token;
            this.ts.move(start - 1);
            if (this.ts.moveNext() && (token = this.ts.token()).id() == JsTokenId.STRING_BEGIN) {
                --start;
            }
        }
        return start;
    }

    private int getStart(BinaryNode node) {
        return this.getStart((Node)node.lhs());
    }

    private static int getFunctionStart(FunctionNode node) {
        return com.oracle.js.parser.Token.descPosition((long)node.getFirstToken());
    }

    private int getFinish(Node node) {
        if (node instanceof FunctionNode) {
            FunctionNode function = (FunctionNode)node;
            if (node.getStart() == node.getFinish()) {
                long lastToken = function.getLastToken();
                TokenType type = com.oracle.js.parser.Token.descType((long)lastToken);
                int finish = type == TokenType.EOL ? com.oracle.js.parser.Token.descPosition((long)lastToken) : com.oracle.js.parser.Token.descPosition((long)lastToken) + com.oracle.js.parser.Token.descLength((long)lastToken);
                if (com.oracle.js.parser.Token.descType((long)lastToken).equals((Object)TokenType.STRING)) {
                    ++finish;
                }
                return finish;
            }
            return node.getFinish();
        }
        if (node instanceof Block) {
            FunctionNode fn = this.lc.getCurrentFunction();
            if (fn != null && fn.getBody() == node) {
                return this.getFinish((Node)fn);
            }
        } else if (node instanceof VarNode) {
            VarNode var = (VarNode)node;
            if (var.getInit() instanceof ClassNode) {
                return this.getFinish((Node)var.getInit());
            }
            Token<? extends JsTokenId> token = this.tokenUtils.getNextNonEmptyToken(this.getFinishFixed(node) - 1);
            if (token != null && JsTokenId.OPERATOR_SEMICOLON == token.id()) {
                return this.ts.offset() + 1;
            }
            return this.getFinishFixed(node);
        }
        return this.getFinishFixed(node);
    }

    private int getFinishFixed(Node node) {
        int finish = node.getFinish();
        this.ts.move(finish);
        if (!this.ts.moveNext()) {
            return finish;
        }
        Token token = this.ts.token();
        if (token.id() == JsTokenId.STRING_END || token.id() == JsTokenId.TEMPLATE_END) {
            return finish + 1;
        }
        return finish;
    }

    private boolean isScript(Block node) {
        if (!node.isFunctionBody()) {
            return false;
        }
        FunctionNode functionNode = this.getLexicalContext().getCurrentFunction();
        return functionNode != null && functionNode.isProgram();
    }

    private boolean isVirtual(Block block) {
        return block.getStart() == block.getFinish() || com.oracle.js.parser.Token.descType((long)block.getToken()) != TokenType.LBRACE || block.isCatchBlock();
    }

    private boolean isDeclaration(VarNode varNode) {
        if (varNode.isFunctionDeclaration() || varNode.isExport() || varNode.isDestructuring()) {
            return true;
        }
        Expression expression = varNode.getInit();
        if (expression instanceof ClassNode) {
            ClassNode classNode = (ClassNode)expression;
            IdentNode cIdent = classNode.getIdent();
            IdentNode vIdent = varNode.getName();
            if (cIdent != null && cIdent.getStart() == vIdent.getStart() && cIdent.getFinish() == vIdent.getFinish()) {
                return true;
            }
        }
        return false;
    }

    static {
        Collections.addAll(UNARY_TYPES, TokenType.ADD, TokenType.SUB, TokenType.BIT_NOT, TokenType.NOT, TokenType.INCPOSTFIX, TokenType.INCPREFIX, TokenType.DECPOSTFIX, TokenType.DECPREFIX);
    }
}

