/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.meta.DBModel;
import org.netbeans.modules.db.dataview.meta.DBPrimaryKey;
import org.netbeans.modules.db.dataview.meta.DBTable;
import org.netbeans.modules.db.dataview.output.DataViewTableUIModel;
import org.netbeans.modules.db.dataview.output.SQLConstant;
import org.netbeans.modules.db.dataview.util.BinaryToStringConverter;
import org.netbeans.modules.db.dataview.util.DataViewUtils;
import org.openide.util.NbBundle;

class SQLStatementGenerator {
    private static final Logger LOG = Logger.getLogger(SQLStatementGenerator.class.getName());

    SQLStatementGenerator() {
    }

    String generateInsertStatement(DBTable table, Object[] insertedRow) throws DBException {
        List<DBColumn> columns = table.getColumnList();
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO ");
        StringBuilder colNames = new StringBuilder(" (");
        StringBuilder values = new StringBuilder();
        String commaStr = ", ";
        boolean comma = false;
        for (int i = 0; i < insertedRow.length; ++i) {
            DBColumn dbcol = columns.get(i);
            Object val = insertedRow[i];
            if (dbcol.isGenerated()) continue;
            if ((val == null || val.equals("<NULL>")) && !dbcol.isNullable()) {
                throw new DBException(NbBundle.getMessage(SQLStatementGenerator.class, (String)"MSG_nullable_check"));
            }
            if (comma) {
                values.append(commaStr);
                colNames.append(commaStr);
            } else {
                comma = true;
            }
            if (val instanceof SQLConstant) {
                values.append(((SQLConstant)((Object)val)).name());
            } else {
                values.append(val == null ? " NULL " : "?");
            }
            colNames.append(dbcol.getQualifiedName(true));
        }
        colNames.append(")");
        insertSql.append(table.getFullyQualifiedName(true));
        insertSql.append(colNames.toString());
        insertSql.append(" Values(");
        insertSql.append(values.toString());
        insertSql.append(")");
        return insertSql.toString();
    }

    String generateRawInsertStatement(DBTable table, Object[] insertedRow) throws DBException {
        List<DBColumn> columns = table.getColumnList();
        StringBuilder rawInsertSql = new StringBuilder();
        rawInsertSql.append("INSERT INTO ");
        String rawcolNames = " (";
        String rawvalues = "";
        String commaStr = ", ";
        boolean comma = false;
        for (int i = 0; i < insertedRow.length; ++i) {
            DBColumn dbcol = columns.get(i);
            Object val = insertedRow[i];
            if (dbcol.isGenerated()) continue;
            if ((val == null || val.equals("<NULL>")) && !dbcol.isNullable()) {
                throw new DBException(NbBundle.getMessage(SQLStatementGenerator.class, (String)"MSG_nullable_check"));
            }
            if (comma) {
                rawvalues = rawvalues + commaStr;
                rawcolNames = rawcolNames + commaStr;
            } else {
                comma = true;
            }
            rawvalues = val instanceof SQLConstant ? rawvalues + ((SQLConstant)((Object)val)).name() : rawvalues + this.getQualifiedValue(dbcol.getJdbcType(), insertedRow[i]);
            rawcolNames = rawcolNames + dbcol.getQualifiedName(false);
        }
        rawcolNames = rawcolNames + ")";
        rawInsertSql.append(table.getFullyQualifiedName(false));
        rawInsertSql.append(rawcolNames);
        rawInsertSql.append(" \n\tVALUES (");
        rawInsertSql.append(rawvalues);
        rawInsertSql.append(")");
        return rawInsertSql.toString();
    }

    String generateUpdateStatement(DBTable table, int row, Map<Integer, Object> changedRow, List<Object> values, List<Integer> types, DataViewTableUIModel tblModel) throws DBException {
        List<DBColumn> columns = table.getColumnList();
        StringBuilder updateStmt = new StringBuilder();
        updateStmt.append("UPDATE ").append(table.getFullyQualifiedName(true)).append(" SET ");
        String commaStr = ", ";
        boolean comma = false;
        for (Integer col : changedRow.keySet()) {
            DBColumn dbcol = columns.get(col);
            Object value = changedRow.get(col);
            int type = dbcol.getJdbcType();
            if ((value == null || value.equals("<NULL>")) && !dbcol.isNullable()) {
                throw new DBException(NbBundle.getMessage(SQLStatementGenerator.class, (String)"MSG_nullable_check"));
            }
            if (comma) {
                updateStmt.append(commaStr);
            } else {
                comma = true;
            }
            updateStmt.append(dbcol.getQualifiedName(true));
            if (value instanceof SQLConstant) {
                updateStmt.append(" = ").append(((SQLConstant)((Object)value)).name());
                continue;
            }
            if (value == null) {
                updateStmt.append(" = NULL");
                continue;
            }
            updateStmt.append(" = ?");
            values.add(value);
            types.add(type);
        }
        updateStmt.append(" WHERE ");
        this.generateWhereCondition(table, updateStmt, types, values, row, tblModel);
        return updateStmt.toString();
    }

    String generateUpdateStatement(DBTable table, int row, Map<Integer, Object> changedRow, DataViewTableUIModel tblModel) throws DBException {
        List<DBColumn> columns = table.getColumnList();
        StringBuilder rawUpdateStmt = new StringBuilder();
        rawUpdateStmt.append("UPDATE ").append(table.getFullyQualifiedName(false)).append(" SET ");
        String commaStr = ", ";
        boolean comma = false;
        for (Integer col : changedRow.keySet()) {
            DBColumn dbcol = columns.get(col);
            Object value = changedRow.get(col);
            int type = dbcol.getJdbcType();
            if ((value == null || value.equals("<NULL>")) && !dbcol.isNullable()) {
                throw new DBException(NbBundle.getMessage(SQLStatementGenerator.class, (String)"MSG_nullable_check"));
            }
            if (comma) {
                rawUpdateStmt.append(commaStr);
            } else {
                comma = true;
            }
            rawUpdateStmt.append(dbcol.getQualifiedName(true));
            if (value instanceof SQLConstant) {
                rawUpdateStmt.append(" = ").append(((SQLConstant)((Object)value)).name());
                continue;
            }
            rawUpdateStmt.append(" = ").append(this.getQualifiedValue(type, value).toString());
        }
        rawUpdateStmt.append(" WHERE ");
        this.generateWhereCondition(table, rawUpdateStmt, row, tblModel);
        return rawUpdateStmt.toString();
    }

    String generateDeleteStatement(DBTable table, List<Integer> types, List<Object> values, int rowNum, DataViewTableUIModel tblModel) {
        StringBuilder deleteStmt = new StringBuilder();
        deleteStmt.append("DELETE FROM ").append(table.getFullyQualifiedName(true)).append(" WHERE ");
        this.generateWhereCondition(table, deleteStmt, types, values, rowNum, tblModel);
        return deleteStmt.toString();
    }

    String generateDeleteStatement(DBTable table, int rowNum, DataViewTableUIModel tblModel) {
        StringBuilder rawDeleteStmt = new StringBuilder();
        rawDeleteStmt.append("DELETE FROM ").append(table.getFullyQualifiedName(false)).append(" WHERE ");
        this.generateWhereCondition(table, rawDeleteStmt, rowNum, tblModel);
        return rawDeleteStmt.toString();
    }

    String generateCreateStatement(DBTable table) throws DBException, Exception {
        boolean isdb2 = ((DBModel)table.getParentObject()).getDBType() == 0;
        StringBuilder sql = new StringBuilder();
        List<DBColumn> columns = table.getColumnList();
        sql.append("CREATE TABLE ").append(table.getQualifiedName(false)).append(" (");
        int count = 0;
        for (DBColumn col : columns) {
            if (count++ > 0) {
                sql.append(", ");
            }
            String typeName = col.getTypeName();
            sql.append(col.getQualifiedName(false)).append(" ");
            int scale = col.getScale();
            int precision = col.getPrecision();
            if (precision > 0 && DataViewUtils.isPrecisionRequired(col.getJdbcType(), isdb2)) {
                if (typeName.contains("(")) {
                    sql.append(typeName.replace("(", "(" + precision));
                } else {
                    sql.append(typeName).append("(").append(precision);
                    if (scale > 0 && DataViewUtils.isScaleRequired(col.getJdbcType())) {
                        sql.append(", ").append(scale).append(")");
                    } else {
                        sql.append(")");
                    }
                }
            } else {
                sql.append(typeName);
            }
            if (DataViewUtils.isBinary(col.getJdbcType()) && isdb2) {
                sql.append("  FOR BIT DATA ");
            }
            if (col.hasDefault()) {
                sql.append(" DEFAULT ").append(col.getDefaultValue()).append(" ");
            }
            if (!col.isNullable()) {
                sql.append(" NOT NULL");
            }
            if (!col.isGenerated()) continue;
            sql.append(" ").append(this.getAutoIncrementText(((DBModel)table.getParentObject()).getDBType()));
        }
        DBPrimaryKey pk = table.getPrimaryKey();
        if (pk != null) {
            count = 0;
            sql.append(", PRIMARY KEY (");
            for (String col : pk.getColumnNames()) {
                if (count++ > 0) {
                    sql.append(", ");
                }
                sql.append(table.getQuoter().quoteIfNeeded(col));
            }
            sql.append(")");
        }
        sql.append(")");
        return sql.toString();
    }

    private boolean addSeparator(boolean and, StringBuilder sql, String sep) {
        if (and) {
            sql.append(sep);
            return true;
        }
        return true;
    }

    private void generateNameValue(DBColumn column, StringBuilder sql, Object value, List<Object> values, List<Integer> types) {
        sql.append(column.getQualifiedName(true));
        if (value != null) {
            values.add(value);
            types.add(column.getJdbcType());
            sql.append(" = ? ");
        } else {
            sql.append(" IS NULL ");
        }
    }

    private void generateNameValue(DBColumn column, StringBuilder sql, Object value) {
        String columnName = column.getQualifiedName(false);
        int type = column.getJdbcType();
        sql.append(columnName);
        if (value != null) {
            sql.append(" = ").append(this.getQualifiedValue(type, value));
        } else {
            sql.append(" IS NULL");
        }
    }

    void generateWhereCondition(DBTable table, StringBuilder result, List<Integer> types, List<Object> values, int rowNum, DataViewTableUIModel model) {
        assert (SwingUtilities.isEventDispatchThread()) : "Needs to be called on the EDT";
        DBPrimaryKey key = table.getPrimaryKey();
        HashSet<String> columnsSelected = new HashSet<String>();
        boolean and = false;
        List<DBColumn> columns = table.getColumnList();
        StringBuilder pkSelect = new StringBuilder();
        ArrayList<Integer> pkTypes = new ArrayList<Integer>();
        ArrayList<Object> pkObject = new ArrayList<Object>();
        if (key != null) {
            block0: for (String keyName : key.getColumnNames()) {
                for (int i = 0; i < model.getColumnCount(); ++i) {
                    Object val;
                    DBColumn dbcol = columns.get(i);
                    String columnName = dbcol.getName();
                    if (!columnName.equals(keyName) || (val = model.getOriginalValueAt(rowNum, i)) == null) continue;
                    columnsSelected.add(columnName);
                    and = this.addSeparator(and, pkSelect, " AND ");
                    this.generateNameValue(dbcol, pkSelect, val, pkObject, pkTypes);
                    continue block0;
                }
            }
        }
        if (key != null && columnsSelected.equals(new HashSet<String>(key.getColumnNames()))) {
            result.append((CharSequence)pkSelect);
            types.addAll(pkTypes);
            values.addAll(pkObject);
        } else {
            and = false;
            for (int i = 0; i < model.getColumnCount(); ++i) {
                DBColumn dbcol = columns.get(i);
                Object val = model.getOriginalValueAt(rowNum, i);
                and = this.addSeparator(and, result, " AND ");
                this.generateNameValue(dbcol, result, val, values, types);
            }
        }
    }

    void generateWhereCondition(DBTable table, StringBuilder sql, int rowNum, DataViewTableUIModel model) {
        assert (SwingUtilities.isEventDispatchThread()) : "Needs to be called on the EDT";
        DBPrimaryKey key = table.getPrimaryKey();
        HashSet<String> columnsSelected = new HashSet<String>();
        boolean and = false;
        List<DBColumn> columns = table.getColumnList();
        StringBuilder pkSelect = new StringBuilder();
        if (key != null) {
            block0: for (String keyName : key.getColumnNames()) {
                for (int i = 0; i < model.getColumnCount(); ++i) {
                    Object val;
                    DBColumn dbcol = columns.get(i);
                    String columnName = dbcol.getName();
                    if (!columnName.equals(keyName) || (val = model.getOriginalValueAt(rowNum, i)) == null) continue;
                    columnsSelected.add(columnName);
                    and = this.addSeparator(and, pkSelect, " AND ");
                    this.generateNameValue(dbcol, pkSelect, val);
                    continue block0;
                }
            }
        }
        if (key != null && columnsSelected.equals(new HashSet<String>(key.getColumnNames()))) {
            sql.append((CharSequence)pkSelect);
        } else {
            and = false;
            for (int i = 0; i < model.getColumnCount(); ++i) {
                DBColumn dbcol = columns.get(i);
                Object val = model.getOriginalValueAt(rowNum, i);
                and = this.addSeparator(and, sql, " AND ");
                this.generateNameValue(dbcol, sql, val);
            }
        }
    }

    private Object getQualifiedValue(int type, Object val) {
        if (val == null) {
            return "NULL";
        }
        if (type == -7 && !(val instanceof Boolean)) {
            return "b'" + val + "'";
        }
        if (DataViewUtils.isNumeric(type)) {
            return val;
        }
        if (val instanceof Clob) {
            try {
                Clob lob = (Clob)val;
                String result = lob.getSubString(1L, (int)lob.length());
                return "'" + result.replace("'", "''") + "'";
            }
            catch (SQLException ex) {
                LOG.log(Level.INFO, "Failed to read CLOB", ex);
            }
        } else if (val instanceof Blob) {
            try {
                Blob lob = (Blob)val;
                byte[] result = lob.getBytes(1L, (int)lob.length());
                return "x'" + BinaryToStringConverter.convertToString(result, 16, false) + "'";
            }
            catch (SQLException ex) {
                LOG.log(Level.INFO, "Failed to read BLOB", ex);
            }
        }
        return "'" + val.toString().replace("'", "''") + "'";
    }

    private String getAutoIncrementText(int dbType) throws Exception {
        switch (dbType) {
            case 5: {
                return "AUTO_INCREMENT";
            }
            case 4: {
                return "SERIAL";
            }
            case 2: {
                return "IDENTITY";
            }
        }
        return "GENERATED ALWAYS AS IDENTITY";
    }
}

