; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes='instcombine<no-verify-fixpoint>' -S | FileCheck %s

declare void @use(i8)

define i1 @set_low_bit_mask_eq(i8 %x) {
; CHECK-LABEL: @set_low_bit_mask_eq(
; CHECK-NEXT:    [[TMP1:%.*]] = and i8 [[X:%.*]], -2
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[TMP1]], 18
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = or i8 %x, 1
  %cmp = icmp eq i8 %sub, 19
  ret i1 %cmp
}

define <2 x i1> @set_low_bit_mask_ne(<2 x i8> %x) {
; CHECK-LABEL: @set_low_bit_mask_ne(
; CHECK-NEXT:    [[TMP1:%.*]] = and <2 x i8> [[X:%.*]], <i8 -4, i8 -4>
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <2 x i8> [[TMP1]], <i8 16, i8 16>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %sub = or <2 x i8> %x, <i8 3, i8 3>
  %cmp = icmp ne <2 x i8> %sub, <i8 19, i8 19>
  ret <2 x i1> %cmp
}

define i1 @set_low_bit_mask_ugt(i8 %x) {
; CHECK-LABEL: @set_low_bit_mask_ugt(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i8 [[X:%.*]], 19
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = or i8 %x, 3
  %cmp = icmp ugt i8 %sub, 19
  ret i1 %cmp
}

define i1 @set_low_bit_mask_ult(i8 %x) {
; CHECK-LABEL: @set_low_bit_mask_ult(
; CHECK-NEXT:    [[SUB:%.*]] = or i8 [[X:%.*]], 3
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i8 [[SUB]], 19
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = or i8 %x, 3
  %cmp = icmp ult i8 %sub, 19
  ret i1 %cmp
}

define i1 @set_low_bit_mask_uge(i8 %x) {
; CHECK-LABEL: @set_low_bit_mask_uge(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i8 [[X:%.*]], 19
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = or i8 %x, 3
  %cmp = icmp uge i8 %sub, 20
  ret i1 %cmp
}

define i1 @set_low_bit_mask_ule(i8 %x) {
; CHECK-LABEL: @set_low_bit_mask_ule(
; CHECK-NEXT:    [[SUB:%.*]] = or i8 [[X:%.*]], 3
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i8 [[SUB]], 19
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = or i8 %x, 3
  %cmp = icmp ule i8 %sub, 18
  ret i1 %cmp
}

define i1 @set_low_bit_mask_sgt(i8 %x) {
; CHECK-LABEL: @set_low_bit_mask_sgt(
; CHECK-NEXT:    [[SUB:%.*]] = or i8 [[X:%.*]], 3
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i8 [[SUB]], 20
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = or i8 %x, 3
  %cmp = icmp sgt i8 %sub, 20
  ret i1 %cmp
}

define i1 @set_low_bit_mask_slt(i8 %x) {
; CHECK-LABEL: @set_low_bit_mask_slt(
; CHECK-NEXT:    [[SUB:%.*]] = or i8 [[X:%.*]], 15
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i8 [[SUB]], 19
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = or i8 %x, 15
  %cmp = icmp slt i8 %sub, 19
  ret i1 %cmp
}

define i1 @set_low_bit_mask_sge(i8 %x) {
; CHECK-LABEL: @set_low_bit_mask_sge(
; CHECK-NEXT:    [[SUB:%.*]] = or i8 [[X:%.*]], 31
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i8 [[SUB]], 50
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = or i8 %x, 31
  %cmp = icmp sge i8 %sub, 51
  ret i1 %cmp
}

define i1 @set_low_bit_mask_sle(i8 %x) {
; CHECK-LABEL: @set_low_bit_mask_sle(
; CHECK-NEXT:    [[SUB:%.*]] = or i8 [[X:%.*]], 63
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i8 [[SUB]], 69
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = or i8 %x, 63
  %cmp = icmp sle i8 %sub, 68
  ret i1 %cmp
}

define i1 @eq_const_mask(i8 %x, i8 %y) {
; CHECK-LABEL: @eq_const_mask(
; CHECK-NEXT:    [[TMP1:%.*]] = xor i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = and i8 [[TMP1]], -43
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[TMP2]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %b0 = or i8 %x, 42
  %b1 = or i8 %y, 42
  %cmp = icmp eq i8 %b0, %b1
  ret i1 %cmp
}

define <2 x i1> @ne_const_mask(<2 x i8> %x, <2 x i8> %y) {
; CHECK-LABEL: @ne_const_mask(
; CHECK-NEXT:    [[TMP1:%.*]] = xor <2 x i8> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = and <2 x i8> [[TMP1]], <i8 105, i8 -6>
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <2 x i8> [[TMP2]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %b0 = or <2 x i8> %x, <i8 150, i8 5>
  %b1 = or <2 x i8> %y, <i8 150, i8 5>
  %cmp = icmp ne <2 x i8> %b0, %b1
  ret <2 x i1> %cmp
}

; negative test - predicate

define i1 @eq_const_mask_not_equality(i8 %x, i8 %y) {
; CHECK-LABEL: @eq_const_mask_not_equality(
; CHECK-NEXT:    [[B0:%.*]] = or i8 [[X:%.*]], 5
; CHECK-NEXT:    [[B1:%.*]] = or i8 [[Y:%.*]], 5
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i8 [[B0]], [[B1]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %b0 = or i8 %x, 5
  %b1 = or i8 %y, 5
  %cmp = icmp sgt i8 %b0, %b1
  ret i1 %cmp
}

; negative test - mismatched constants

define i1 @eq_const_mask_not_same(i8 %x, i8 %y) {
; CHECK-LABEL: @eq_const_mask_not_same(
; CHECK-NEXT:    [[B0:%.*]] = or i8 [[X:%.*]], 5
; CHECK-NEXT:    [[B1:%.*]] = or i8 [[Y:%.*]], 6
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[B0]], [[B1]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %b0 = or i8 %x, 5
  %b1 = or i8 %y, 6
  %cmp = icmp eq i8 %b0, %b1
  ret i1 %cmp
}

; negative test - mismatched logic

define i1 @eq_const_mask_wrong_opcode(i8 %x, i8 %y) {
; CHECK-LABEL: @eq_const_mask_wrong_opcode(
; CHECK-NEXT:    [[B0:%.*]] = or i8 [[X:%.*]], 5
; CHECK-NEXT:    [[TMP1:%.*]] = xor i8 [[B0]], [[Y:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[TMP1]], 5
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %b0 = or i8 %x, 5
  %b1 = xor i8 %y, 5
  %cmp = icmp eq i8 %b0, %b1
  ret i1 %cmp
}

; negative test - no extra uses

define i1 @eq_const_mask_use1(i8 %x, i8 %y) {
; CHECK-LABEL: @eq_const_mask_use1(
; CHECK-NEXT:    [[B0:%.*]] = or i8 [[X:%.*]], 5
; CHECK-NEXT:    call void @use(i8 [[B0]])
; CHECK-NEXT:    [[B1:%.*]] = or i8 [[Y:%.*]], 5
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[B0]], [[B1]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %b0 = or i8 %x, 5
  call void @use(i8 %b0)
  %b1 = or i8 %y, 5
  %cmp = icmp eq i8 %b0, %b1
  ret i1 %cmp
}

; negative test - no extra uses

define i1 @eq_const_mask_use2(i8 %x, i8 %y) {
; CHECK-LABEL: @eq_const_mask_use2(
; CHECK-NEXT:    [[B0:%.*]] = or i8 [[X:%.*]], 5
; CHECK-NEXT:    [[B1:%.*]] = or i8 [[Y:%.*]], 5
; CHECK-NEXT:    call void @use(i8 [[B1]])
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[B0]], [[B1]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %b0 = or i8 %x, 5
  %b1 = or i8 %y, 5
  call void @use(i8 %b1)
  %cmp = icmp eq i8 %b0, %b1
  ret i1 %cmp
}

; (x | (x - 1)) s< 0

define <2 x i1> @decrement_slt_0(<2 x i8> %x) {
; CHECK-LABEL: @decrement_slt_0(
; CHECK-NEXT:    [[R:%.*]] = icmp slt <2 x i8> [[X:%.*]], <i8 1, i8 1>
; CHECK-NEXT:    ret <2 x i1> [[R]]
;
  %dec = add <2 x i8> %x, <i8 -1, i8 -1>
  %or = or <2 x i8> %dec, %x
  %r = icmp slt <2 x i8> %or, zeroinitializer
  ret <2 x i1> %r
}

define i1 @decrement_slt_0_commute_use1(i8 %px) {
; CHECK-LABEL: @decrement_slt_0_commute_use1(
; CHECK-NEXT:    [[X:%.*]] = mul i8 [[PX:%.*]], 42
; CHECK-NEXT:    [[DEC:%.*]] = add i8 [[X]], -1
; CHECK-NEXT:    call void @use(i8 [[DEC]])
; CHECK-NEXT:    [[R:%.*]] = icmp slt i8 [[X]], 1
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = mul i8 %px, 42 ; thwart complexity-based canonicalization
  %dec = add i8 %x, -1
  call void @use(i8 %dec)
  %or = or i8 %x, %dec
  %r = icmp slt i8 %or, 0
  ret i1 %r
}

define i1 @decrement_slt_0_use2(i8 %x) {
; CHECK-LABEL: @decrement_slt_0_use2(
; CHECK-NEXT:    [[DEC:%.*]] = add i8 [[X:%.*]], -1
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[DEC]], [[X]]
; CHECK-NEXT:    call void @use(i8 [[OR]])
; CHECK-NEXT:    [[R:%.*]] = icmp slt i8 [[X]], 1
; CHECK-NEXT:    ret i1 [[R]]
;
  %dec = add i8 %x, -1
  %or = or i8 %dec, %x
  call void @use(i8 %or)
  %r = icmp slt i8 %or, 0
  ret i1 %r
}

; negative test - wrong cmp constant

define i1 @decrement_slt_n1(i8 %x) {
; CHECK-LABEL: @decrement_slt_n1(
; CHECK-NEXT:    [[DEC:%.*]] = add i8 [[X:%.*]], -1
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[DEC]], [[X]]
; CHECK-NEXT:    [[R:%.*]] = icmp slt i8 [[OR]], -1
; CHECK-NEXT:    ret i1 [[R]]
;
  %dec = add i8 %x, -1
  %or = or i8 %dec, %x
  %r = icmp slt i8 %or, -1
  ret i1 %r
}

; negative test - wrong add constant

define i1 @not_decrement_slt_0(i8 %x) {
; CHECK-LABEL: @not_decrement_slt_0(
; CHECK-NEXT:    [[DEC:%.*]] = add i8 [[X:%.*]], -2
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[DEC]], [[X]]
; CHECK-NEXT:    [[R:%.*]] = icmp slt i8 [[OR]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %dec = add i8 %x, -2
  %or = or i8 %dec, %x
  %r = icmp slt i8 %or, 0
  ret i1 %r
}

; (x | (x - 1)) s> -1

define <2 x i1> @decrement_sgt_n1(<2 x i8> %x) {
; CHECK-LABEL: @decrement_sgt_n1(
; CHECK-NEXT:    [[R:%.*]] = icmp sgt <2 x i8> [[X:%.*]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[R]]
;
  %dec = add <2 x i8> %x, <i8 -1, i8 -1>
  %or = or <2 x i8> %dec, %x
  %r = icmp sgt <2 x i8> %or, <i8 -1, i8 -1>
  ret <2 x i1> %r
}

define i1 @decrement_sgt_n1_commute_use1(i8 %px) {
; CHECK-LABEL: @decrement_sgt_n1_commute_use1(
; CHECK-NEXT:    [[X:%.*]] = mul i8 [[PX:%.*]], 42
; CHECK-NEXT:    [[DEC:%.*]] = add i8 [[X]], -1
; CHECK-NEXT:    call void @use(i8 [[DEC]])
; CHECK-NEXT:    [[R:%.*]] = icmp sgt i8 [[X]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = mul i8 %px, 42 ; thwart complexity-based canonicalization
  %dec = add i8 %x, -1
  call void @use(i8 %dec)
  %or = or i8 %x, %dec
  %r = icmp sgt i8 %or, -1
  ret i1 %r
}

define i1 @decrement_sgt_n1_use2(i8 %x) {
; CHECK-LABEL: @decrement_sgt_n1_use2(
; CHECK-NEXT:    [[DEC:%.*]] = add i8 [[X:%.*]], -1
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[DEC]], [[X]]
; CHECK-NEXT:    call void @use(i8 [[OR]])
; CHECK-NEXT:    [[R:%.*]] = icmp sgt i8 [[X]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %dec = add i8 %x, -1
  %or = or i8 %dec, %x
  call void @use(i8 %or)
  %r = icmp sgt i8 %or, -1
  ret i1 %r
}

; negative test - wrong cmp constant

define i1 @decrement_sgt_0(i8 %x) {
; CHECK-LABEL: @decrement_sgt_0(
; CHECK-NEXT:    [[DEC:%.*]] = add i8 [[X:%.*]], -1
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[DEC]], [[X]]
; CHECK-NEXT:    [[R:%.*]] = icmp sgt i8 [[OR]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %dec = add i8 %x, -1
  %or = or i8 %dec, %x
  %r = icmp sgt i8 %or, 0
  ret i1 %r
}

; negative test - wrong add constant

define i1 @not_decrement_sgt_n1(i8 %x) {
; CHECK-LABEL: @not_decrement_sgt_n1(
; CHECK-NEXT:    [[DEC:%.*]] = add i8 [[X:%.*]], -2
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[DEC]], [[X]]
; CHECK-NEXT:    [[R:%.*]] = icmp sgt i8 [[OR]], -1
; CHECK-NEXT:    ret i1 [[R]]
;
  %dec = add i8 %x, -2
  %or = or i8 %dec, %x
  %r = icmp sgt i8 %or, -1
  ret i1 %r
}

define i1 @icmp_or_xor_2_eq(i64 %x1, i64 %y1, i64 %x2, i64 %y2) {
; CHECK-LABEL: @icmp_or_xor_2_eq(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = and i1 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %xor = xor i64 %x1, %y1
  %xor1 = xor i64 %x2, %y2
  %or = or i64 %xor, %xor1
  %cmp = icmp eq i64 %or, 0
  ret i1 %cmp
}

define i1 @icmp_or_xor_2_ne(i64 %x1, i64 %y1, i64 %x2, i64 %y2) {
; CHECK-LABEL: @icmp_or_xor_2_ne(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ne i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = or i1 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %xor = xor i64 %x1, %y1
  %xor1 = xor i64 %x2, %y2
  %or = or i64 %xor, %xor1
  %cmp = icmp ne i64 %or, 0
  ret i1 %cmp
}

; negative test - wrong cmp constant

define i1 @icmp_or_xor_2_eq_fail(i64 %x1, i64 %y1, i64 %x2, i64 %y2) {
; CHECK-LABEL: @icmp_or_xor_2_eq_fail(
; CHECK-NEXT:    [[XOR:%.*]] = xor i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[XOR1:%.*]] = xor i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = or i64 [[XOR]], [[XOR1]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i64 [[OR]], 1
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %xor = xor i64 %x1, %y1
  %xor1 = xor i64 %x2, %y2
  %or = or i64 %xor, %xor1
  %cmp = icmp eq i64 %or, 1
  ret i1 %cmp
}

; negative test - wrong cmp constant

define i1 @icmp_or_xor_2_ne_fail(i64 %x1, i64 %y1, i64 %x2, i64 %y2) {
; CHECK-LABEL: @icmp_or_xor_2_ne_fail(
; CHECK-NEXT:    [[XOR:%.*]] = xor i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[XOR1:%.*]] = xor i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = or i64 [[XOR]], [[XOR1]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i64 [[OR]], 1
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %xor = xor i64 %x1, %y1
  %xor1 = xor i64 %x2, %y2
  %or = or i64 %xor, %xor1
  %cmp = icmp ne i64 %or, 1
  ret i1 %cmp
}

; negative test - xor multiuse

; NB: This requires more than 1 iteration to simplify. After we
; simplify `%cmp_1 = icmp eq i64 %xor, 0`, `%xor = xor i64 %x1, %y1`
; has one use which allows for complete simplification (rooted on
; `%or1 = or i1 %cmp, %cmp_1` so we don't end up adding it back).
define i1 @icmp_or_xor_2_3_fail(i64 %x1, i64 %y1, i64 %x2, i64 %y2) {
; CHECK-LABEL: @icmp_or_xor_2_3_fail(
; CHECK-NEXT:    [[XOR:%.*]] = xor i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[XOR1:%.*]] = xor i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = or i64 [[XOR]], [[XOR1]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i64 [[OR]], 0
; CHECK-NEXT:    [[CMP_1:%.*]] = icmp eq i64 [[X1]], [[Y1]]
; CHECK-NEXT:    [[OR1:%.*]] = or i1 [[CMP]], [[CMP_1]]
; CHECK-NEXT:    ret i1 [[OR1]]
;
  %xor = xor i64 %x1, %y1
  %xor1 = xor i64 %x2, %y2
  %or = or i64 %xor, %xor1
  %cmp = icmp eq i64 %or, 0
  %cmp_1 = icmp eq i64 %xor, 0
  %or1 = or i1 %cmp, %cmp_1
  ret i1 %or1
}

; negative test - xor multiuse

define i1 @icmp_or_xor_2_4_fail(i64 %x1, i64 %y1, i64 %x2, i64 %y2) {
; CHECK-LABEL: @icmp_or_xor_2_4_fail(
; CHECK-NEXT:    [[XOR:%.*]] = xor i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[XOR1:%.*]] = xor i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = or i64 [[XOR]], [[XOR1]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i64 [[OR]], 0
; CHECK-NEXT:    [[CMP_1:%.*]] = icmp eq i64 [[X2]], [[Y2]]
; CHECK-NEXT:    [[OR1:%.*]] = or i1 [[CMP]], [[CMP_1]]
; CHECK-NEXT:    ret i1 [[OR1]]
;
  %xor = xor i64 %x1, %y1
  %xor1 = xor i64 %x2, %y2
  %or = or i64 %xor, %xor1
  %cmp = icmp eq i64 %or, 0
  %cmp_1 = icmp eq i64 %xor1, 0
  %or1 = or i1 %cmp, %cmp_1
  ret i1 %or1
}

define i1 @icmp_or_xor_3_1(i64 %x1, i64 %y1, i64 %x2, i64 %y2, i64 %x3, i64 %y3) {
; CHECK-LABEL: @icmp_or_xor_3_1(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[TMP3:%.*]] = and i1 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[TMP4:%.*]] = icmp eq i64 [[X3:%.*]], [[Y3:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = and i1 [[TMP3]], [[TMP4]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %xor = xor i64 %x1, %y1
  %xor1 = xor i64 %x2, %y2
  %or = or i64 %xor, %xor1
  %xor2 = xor i64 %x3, %y3
  %or1 = or i64 %or, %xor2
  %cmp = icmp eq i64 %or1, 0
  ret i1 %cmp
}

; negative test - and instead of or

define i1 @icmp_or_xor_3_2_fail(i64 %x1, i64 %y1, i64 %x2, i64 %y2, i64 %x3, i64 %y3) {
; CHECK-LABEL: @icmp_or_xor_3_2_fail(
; CHECK-NEXT:    [[XOR:%.*]] = xor i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[XOR1:%.*]] = xor i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[AND:%.*]] = and i64 [[XOR]], [[XOR1]]
; CHECK-NEXT:    [[XOR2:%.*]] = xor i64 [[X3:%.*]], [[Y3:%.*]]
; CHECK-NEXT:    [[OR1:%.*]] = or i64 [[AND]], [[XOR2]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i64 [[OR1]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %xor = xor i64 %x1, %y1
  %xor1 = xor i64 %x2, %y2
  %and = and i64 %xor, %xor1
  %xor2 = xor i64 %x3, %y3
  %or1 = or i64 %and, %xor2
  %cmp = icmp eq i64 %or1, 0
  ret i1 %cmp
}

define i1 @icmp_or_xor_3_3(i64 %x1, i64 %y1, i64 %x2, i64 %y2, i64 %x3, i64 %y3) {
; CHECK-LABEL: @icmp_or_xor_3_3(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[TMP3:%.*]] = and i1 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[TMP4:%.*]] = icmp eq i64 [[X3:%.*]], [[Y3:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = and i1 [[TMP3]], [[TMP4]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %xor = xor i64 %x1, %y1
  %xor1 = xor i64 %x2, %y2
  %or = or i64 %xor, %xor1
  %xor2 = xor i64 %x3, %y3
  %or1 = or i64 %xor2, %or
  %cmp = icmp eq i64 %or1, 0
  ret i1 %cmp
}

; negative test - and instead of or

define i1 @icmp_or_xor_3_4_fail(i64 %x1, i64 %y1, i64 %x2, i64 %y2, i64 %x3, i64 %y3) {
; CHECK-LABEL: @icmp_or_xor_3_4_fail(
; CHECK-NEXT:    [[XOR:%.*]] = xor i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[XOR1:%.*]] = xor i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[AND:%.*]] = and i64 [[XOR]], [[XOR1]]
; CHECK-NEXT:    [[XOR2:%.*]] = xor i64 [[X3:%.*]], [[Y3:%.*]]
; CHECK-NEXT:    [[OR1:%.*]] = or i64 [[XOR2]], [[AND]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i64 [[OR1]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %xor = xor i64 %x1, %y1
  %xor1 = xor i64 %x2, %y2
  %and = and i64 %xor, %xor1
  %xor2 = xor i64 %x3, %y3
  %or1 = or i64 %xor2, %and
  %cmp = icmp eq i64 %or1, 0
  ret i1 %cmp
}

define i1 @icmp_or_xor_4_1(i64 %x1, i64 %y1, i64 %x2, i64 %y2, i64 %x3, i64 %y3, i64 %x4, i64 %y4) {
; CHECK-LABEL: @icmp_or_xor_4_1(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i64 [[X3:%.*]], [[Y3:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[X4:%.*]], [[Y4:%.*]]
; CHECK-NEXT:    [[TMP3:%.*]] = and i1 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[TMP4:%.*]] = icmp eq i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[TMP5:%.*]] = and i1 [[TMP3]], [[TMP4]]
; CHECK-NEXT:    [[TMP6:%.*]] = icmp eq i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = and i1 [[TMP5]], [[TMP6]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %xor = xor i64 %x1, %y1
  %xor1 = xor i64 %x2, %y2
  %or = or i64 %xor, %xor1
  %xor2 = xor i64 %x3, %y3
  %xor3 = xor i64 %x4, %y4
  %or1 = or i64 %xor2, %xor3
  %or2 = or i64 %or, %or1
  %cmp = icmp eq i64 %or2, 0
  ret i1 %cmp
}

define i1 @icmp_or_xor_4_2(i64 %x1, i64 %y1, i64 %x2, i64 %y2, i64 %x3, i64 %y3, i64 %x4, i64 %y4) {
; CHECK-LABEL: @icmp_or_xor_4_2(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[TMP3:%.*]] = and i1 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[TMP4:%.*]] = icmp eq i64 [[X3:%.*]], [[Y3:%.*]]
; CHECK-NEXT:    [[TMP5:%.*]] = and i1 [[TMP3]], [[TMP4]]
; CHECK-NEXT:    [[TMP6:%.*]] = icmp eq i64 [[X4:%.*]], [[Y4:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = and i1 [[TMP5]], [[TMP6]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %xor = xor i64 %x1, %y1
  %xor1 = xor i64 %x2, %y2
  %or = or i64 %xor, %xor1
  %xor2 = xor i64 %x3, %y3
  %xor3 = xor i64 %x4, %y4
  %or1 = or i64 %xor2, %xor3
  %or2 = or i64 %or1, %or
  %cmp = icmp eq i64 %or2, 0
  ret i1 %cmp
}

define i1 @icmp_or_sub_2_eq(i64 %x1, i64 %y1, i64 %x2, i64 %y2) {
; CHECK-LABEL: @icmp_or_sub_2_eq(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = and i1 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = sub i64 %x1, %y1
  %sub1 = sub i64 %x2, %y2
  %or = or i64 %sub, %sub1
  %cmp = icmp eq i64 %or, 0
  ret i1 %cmp
}

define i1 @icmp_or_sub_2_ne(i64 %x1, i64 %y1, i64 %x2, i64 %y2) {
; CHECK-LABEL: @icmp_or_sub_2_ne(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ne i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = or i1 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = sub i64 %x1, %y1
  %sub1 = sub i64 %x2, %y2
  %or = or i64 %sub, %sub1
  %cmp = icmp ne i64 %or, 0
  ret i1 %cmp
}

; negative test - wrong cmp constant

define i1 @icmp_or_sub_2_eq_fail(i64 %x1, i64 %y1, i64 %x2, i64 %y2) {
; CHECK-LABEL: @icmp_or_sub_2_eq_fail(
; CHECK-NEXT:    [[SUB:%.*]] = sub i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[SUB1:%.*]] = sub i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = or i64 [[SUB]], [[SUB1]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i64 [[OR]], 1
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = sub i64 %x1, %y1
  %sub1 = sub i64 %x2, %y2
  %or = or i64 %sub, %sub1
  %cmp = icmp eq i64 %or, 1
  ret i1 %cmp
}

; negative test - wrong cmp constant

define i1 @icmp_or_sub_2_ne_fail(i64 %x1, i64 %y1, i64 %x2, i64 %y2) {
; CHECK-LABEL: @icmp_or_sub_2_ne_fail(
; CHECK-NEXT:    [[SUB:%.*]] = sub i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[SUB1:%.*]] = sub i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = or i64 [[SUB]], [[SUB1]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i64 [[OR]], 1
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = sub i64 %x1, %y1
  %sub1 = sub i64 %x2, %y2
  %or = or i64 %sub, %sub1
  %cmp = icmp ne i64 %or, 1
  ret i1 %cmp
}

; negative test - sub multiuse

define i1 @icmp_or_sub_2_3_fail(i64 %x1, i64 %y1, i64 %x2, i64 %y2) {
; CHECK-LABEL: @icmp_or_sub_2_3_fail(
; CHECK-NEXT:    [[SUB:%.*]] = sub i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[SUB1:%.*]] = sub i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = or i64 [[SUB]], [[SUB1]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i64 [[OR]], 0
; CHECK-NEXT:    [[CMP_1:%.*]] = icmp eq i64 [[SUB]], 1
; CHECK-NEXT:    [[OR1:%.*]] = or i1 [[CMP]], [[CMP_1]]
; CHECK-NEXT:    ret i1 [[OR1]]
;
  %sub = sub i64 %x1, %y1
  %sub1 = sub i64 %x2, %y2
  %or = or i64 %sub, %sub1
  %cmp = icmp eq i64 %or, 0
  %cmp_1 = icmp eq i64 %sub, 1
  %or1 = or i1 %cmp, %cmp_1
  ret i1 %or1
}

; negative test - sub multiuse

define i1 @icmp_or_sub_2_4_fail(i64 %x1, i64 %y1, i64 %x2, i64 %y2) {
; CHECK-LABEL: @icmp_or_sub_2_4_fail(
; CHECK-NEXT:    [[SUB:%.*]] = sub i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[SUB1:%.*]] = sub i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = or i64 [[SUB]], [[SUB1]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i64 [[OR]], 0
; CHECK-NEXT:    [[CMP_1:%.*]] = icmp eq i64 [[SUB1]], 1
; CHECK-NEXT:    [[OR1:%.*]] = or i1 [[CMP]], [[CMP_1]]
; CHECK-NEXT:    ret i1 [[OR1]]
;
  %sub = sub i64 %x1, %y1
  %sub1 = sub i64 %x2, %y2
  %or = or i64 %sub, %sub1
  %cmp = icmp eq i64 %or, 0
  %cmp_1 = icmp eq i64 %sub1, 1
  %or1 = or i1 %cmp, %cmp_1
  ret i1 %or1
}

define i1 @icmp_or_sub_3_1(i64 %x1, i64 %y1, i64 %x2, i64 %y2, i64 %x3, i64 %y3) {
; CHECK-LABEL: @icmp_or_sub_3_1(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[TMP3:%.*]] = and i1 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[TMP4:%.*]] = icmp eq i64 [[X3:%.*]], [[Y3:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = and i1 [[TMP3]], [[TMP4]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = sub i64 %x1, %y1
  %sub1 = sub i64 %x2, %y2
  %or = or i64 %sub, %sub1
  %sub2 = sub i64 %x3, %y3
  %or1 = or i64 %or, %sub2
  %cmp = icmp eq i64 %or1, 0
  ret i1 %cmp
}

; negative test - and instead of or

define i1 @icmp_or_sub_3_2_fail(i64 %x1, i64 %y1, i64 %x2, i64 %y2, i64 %x3, i64 %y3) {
; CHECK-LABEL: @icmp_or_sub_3_2_fail(
; CHECK-NEXT:    [[SUB:%.*]] = sub i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[SUB1:%.*]] = sub i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[AND:%.*]] = and i64 [[SUB]], [[SUB1]]
; CHECK-NEXT:    [[SUB2:%.*]] = sub i64 [[X3:%.*]], [[Y3:%.*]]
; CHECK-NEXT:    [[OR1:%.*]] = or i64 [[AND]], [[SUB2]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i64 [[OR1]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = sub i64 %x1, %y1
  %sub1 = sub i64 %x2, %y2
  %and = and i64 %sub, %sub1
  %sub2 = sub i64 %x3, %y3
  %or1 = or i64 %and, %sub2
  %cmp = icmp eq i64 %or1, 0
  ret i1 %cmp
}

define i1 @icmp_or_sub_3_3(i64 %x1, i64 %y1, i64 %x2, i64 %y2, i64 %x3, i64 %y3) {
; CHECK-LABEL: @icmp_or_sub_3_3(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[TMP3:%.*]] = and i1 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[TMP4:%.*]] = icmp eq i64 [[X3:%.*]], [[Y3:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = and i1 [[TMP3]], [[TMP4]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = sub i64 %x1, %y1
  %sub1 = sub i64 %x2, %y2
  %or = or i64 %sub, %sub1
  %sub2 = sub i64 %x3, %y3
  %or1 = or i64 %sub2, %or
  %cmp = icmp eq i64 %or1, 0
  ret i1 %cmp
}

; negative test - and instead of or

define i1 @icmp_or_sub_3_4_fail(i64 %x1, i64 %y1, i64 %x2, i64 %y2, i64 %x3, i64 %y3) {
; CHECK-LABEL: @icmp_or_sub_3_4_fail(
; CHECK-NEXT:    [[SUB:%.*]] = sub i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[SUB1:%.*]] = sub i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[AND:%.*]] = and i64 [[SUB]], [[SUB1]]
; CHECK-NEXT:    [[SUB2:%.*]] = sub i64 [[X3:%.*]], [[Y3:%.*]]
; CHECK-NEXT:    [[OR1:%.*]] = or i64 [[SUB2]], [[AND]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i64 [[OR1]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = sub i64 %x1, %y1
  %sub1 = sub i64 %x2, %y2
  %and = and i64 %sub, %sub1
  %sub2 = sub i64 %x3, %y3
  %or1 = or i64 %sub2, %and
  %cmp = icmp eq i64 %or1, 0
  ret i1 %cmp
}

define i1 @icmp_or_sub_4_1(i64 %x1, i64 %y1, i64 %x2, i64 %y2, i64 %x3, i64 %y3, i64 %x4, i64 %y4) {
; CHECK-LABEL: @icmp_or_sub_4_1(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i64 [[X3:%.*]], [[Y3:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[X4:%.*]], [[Y4:%.*]]
; CHECK-NEXT:    [[TMP3:%.*]] = and i1 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[TMP4:%.*]] = icmp eq i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[TMP5:%.*]] = and i1 [[TMP3]], [[TMP4]]
; CHECK-NEXT:    [[TMP6:%.*]] = icmp eq i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = and i1 [[TMP5]], [[TMP6]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = sub i64 %x1, %y1
  %sub1 = sub i64 %x2, %y2
  %or = or i64 %sub, %sub1
  %sub2 = sub i64 %x3, %y3
  %sub3 = sub i64 %x4, %y4
  %or1 = or i64 %sub2, %sub3
  %or2 = or i64 %or, %or1
  %cmp = icmp eq i64 %or2, 0
  ret i1 %cmp
}

define i1 @icmp_or_sub_4_2(i64 %x1, i64 %y1, i64 %x2, i64 %y2, i64 %x3, i64 %y3, i64 %x4, i64 %y4) {
; CHECK-LABEL: @icmp_or_sub_4_2(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[TMP3:%.*]] = and i1 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[TMP4:%.*]] = icmp eq i64 [[X3:%.*]], [[Y3:%.*]]
; CHECK-NEXT:    [[TMP5:%.*]] = and i1 [[TMP3]], [[TMP4]]
; CHECK-NEXT:    [[TMP6:%.*]] = icmp eq i64 [[X4:%.*]], [[Y4:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = and i1 [[TMP5]], [[TMP6]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = sub i64 %x1, %y1
  %sub1 = sub i64 %x2, %y2
  %or = or i64 %sub, %sub1
  %sub2 = sub i64 %x3, %y3
  %sub3 = sub i64 %x4, %y4
  %or1 = or i64 %sub2, %sub3
  %or2 = or i64 %or1, %or
  %cmp = icmp eq i64 %or2, 0
  ret i1 %cmp
}

define i1 @icmp_or_xor_with_sub_2_eq(i64 %x1, i64 %y1, i64 %x2, i64 %y2) {
; CHECK-LABEL: @icmp_or_xor_with_sub_2_eq(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = and i1 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %xor = xor i64 %x1, %y1
  %sub = sub i64 %x2, %y2
  %or = or i64 %xor, %sub
  %cmp = icmp eq i64 %or, 0
  ret i1 %cmp
}

define i1 @icmp_or_xor_with_sub_2_ne(i64 %x1, i64 %y1, i64 %x2, i64 %y2) {
; CHECK-LABEL: @icmp_or_xor_with_sub_2_ne(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ne i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = or i1 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %xor = xor i64 %x1, %y1
  %sub = sub i64 %x2, %y2
  %or = or i64 %xor, %sub
  %cmp = icmp ne i64 %or, 0
  ret i1 %cmp
}

define i1 @icmp_or_xor_with_sub_3_1(i64 %x1, i64 %y1, i64 %x2, i64 %y2, i64 %x3, i64 %y3) {
; CHECK-LABEL: @icmp_or_xor_with_sub_3_1(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[TMP3:%.*]] = and i1 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[TMP4:%.*]] = icmp eq i64 [[X3:%.*]], [[Y3:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = and i1 [[TMP3]], [[TMP4]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %xor = xor i64 %x1, %y1
  %xor1 = xor i64 %x2, %y2
  %or = or i64 %xor, %xor1
  %sub1 = sub i64 %x3, %y3
  %or1 = or i64 %or, %sub1
  %cmp = icmp eq i64 %or1, 0
  ret i1 %cmp
}

define i1 @icmp_or_xor_with_sub_3_2(i64 %x1, i64 %y1, i64 %x2, i64 %y2, i64 %x3, i64 %y3) {
; CHECK-LABEL: @icmp_or_xor_with_sub_3_2(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[TMP3:%.*]] = and i1 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[TMP4:%.*]] = icmp eq i64 [[X3:%.*]], [[Y3:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = and i1 [[TMP3]], [[TMP4]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %xor = xor i64 %x1, %y1
  %sub = sub i64 %x2, %y2
  %or = or i64 %xor, %sub
  %xor1 = xor i64 %x3, %y3
  %or1 = or i64 %or, %xor1
  %cmp = icmp eq i64 %or1, 0
  ret i1 %cmp
}

define i1 @icmp_or_xor_with_sub_3_3(i64 %x1, i64 %y1, i64 %x2, i64 %y2, i64 %x3, i64 %y3) {
; CHECK-LABEL: @icmp_or_xor_with_sub_3_3(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[TMP3:%.*]] = and i1 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[TMP4:%.*]] = icmp eq i64 [[X3:%.*]], [[Y3:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = and i1 [[TMP3]], [[TMP4]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %xor = xor i64 %x1, %y1
  %sub = sub i64 %x2, %y2
  %or = or i64 %xor, %sub
  %sub1 = sub i64 %x3, %y3
  %or1 = or i64 %or, %sub1
  %cmp = icmp eq i64 %or1, 0
  ret i1 %cmp
}

define i1 @icmp_or_xor_with_sub_3_4(i64 %x1, i64 %y1, i64 %x2, i64 %y2, i64 %x3, i64 %y3) {
; CHECK-LABEL: @icmp_or_xor_with_sub_3_4(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[TMP3:%.*]] = and i1 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[TMP4:%.*]] = icmp eq i64 [[X3:%.*]], [[Y3:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = and i1 [[TMP3]], [[TMP4]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = sub i64 %x1, %y1
  %xor = xor i64 %x2, %y2
  %or = or i64 %sub, %xor
  %xor1 = xor i64 %x3, %y3
  %or1 = or i64 %or, %xor1
  %cmp = icmp eq i64 %or1, 0
  ret i1 %cmp
}

define i1 @icmp_or_xor_with_sub_3_5(i64 %x1, i64 %y1, i64 %x2, i64 %y2, i64 %x3, i64 %y3) {
; CHECK-LABEL: @icmp_or_xor_with_sub_3_5(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[TMP3:%.*]] = and i1 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[TMP4:%.*]] = icmp eq i64 [[X3:%.*]], [[Y3:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = and i1 [[TMP3]], [[TMP4]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = sub i64 %x1, %y1
  %xor = xor i64 %x2, %y2
  %or = or i64 %sub, %xor
  %sub1 = sub i64 %x3, %y3
  %or1 = or i64 %or, %sub1
  %cmp = icmp eq i64 %or1, 0
  ret i1 %cmp
}

define i1 @icmp_or_xor_with_sub_3_6(i64 %x1, i64 %y1, i64 %x2, i64 %y2, i64 %x3, i64 %y3) {
; CHECK-LABEL: @icmp_or_xor_with_sub_3_6(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i64 [[X1:%.*]], [[Y1:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[X2:%.*]], [[Y2:%.*]]
; CHECK-NEXT:    [[TMP3:%.*]] = and i1 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[TMP4:%.*]] = icmp eq i64 [[X3:%.*]], [[Y3:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = and i1 [[TMP3]], [[TMP4]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = sub i64 %x1, %y1
  %sub1 = sub i64 %x2, %y2
  %or = or i64 %sub, %sub1
  %xor = xor i64 %x3, %y3
  %or1 = or i64 %or, %xor
  %cmp = icmp eq i64 %or1, 0
  ret i1 %cmp
}


define i1 @or_disjoint_with_constants(i8 %x) {
; CHECK-LABEL: @or_disjoint_with_constants(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[X:%.*]], 18
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %or = or disjoint i8 %x, 1
  %cmp = icmp eq i8 %or, 19
  ret i1 %cmp
}


define i1 @or_disjoint_with_constants2(i8 %x) {
; CHECK-LABEL: @or_disjoint_with_constants2(
; CHECK-NEXT:    [[OR:%.*]] = or disjoint i8 [[X:%.*]], 5
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i8 [[X]], 66
; CHECK-NEXT:    call void @use(i8 [[OR]])
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %or = or disjoint i8 %x, 5
  %cmp = icmp ne i8 %or, 71
  call void @use(i8 %or)
  ret i1 %cmp
}


define i1 @or_disjoint_with_constants_fail_missing_const1(i8 %x, i8 %y) {
; CHECK-LABEL: @or_disjoint_with_constants_fail_missing_const1(
; CHECK-NEXT:    [[OR:%.*]] = or disjoint i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[OR]], 19
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %or = or disjoint i8 %x, %y
  %cmp = icmp eq i8 %or, 19
  ret i1 %cmp
}

define i1 @or_disjoint_with_constants_fail_missing_const2(i8 %x, i8 %y) {
; CHECK-LABEL: @or_disjoint_with_constants_fail_missing_const2(
; CHECK-NEXT:    [[OR:%.*]] = or disjoint i8 [[X:%.*]], 19
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[OR]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %or = or disjoint i8 %x, 19
  %cmp = icmp eq i8 %or, %y
  ret i1 %cmp
}

