; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2-FP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl | FileCheck %s --check-prefixes=AVX512
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq | FileCheck %s --check-prefixes=AVX512DQ
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512DQ-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw | FileCheck %s --check-prefixes=AVX512BW
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512BW-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw | FileCheck %s --check-prefixes=AVX512DQ-BW
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512DQ-BW-FCP

; These patterns are produced by LoopVectorizer for interleaved stores.

define void @store_i32_stride7_vf2(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride7_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    movsd {{.*#+}} xmm2 = mem[0],zero
; SSE-NEXT:    movsd {{.*#+}} xmm3 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm4 = mem[0],zero
; SSE-NEXT:    movsd {{.*#+}} xmm5 = mem[0],zero
; SSE-NEXT:    movsd {{.*#+}} xmm6 = mem[0],zero
; SSE-NEXT:    movaps %xmm6, %xmm7
; SSE-NEXT:    movlhps {{.*#+}} xmm7 = xmm7[0],xmm5[0]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[1,1,1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm0[1,3]
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; SSE-NEXT:    unpcklps {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,3],xmm6[2,0]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm7[3,3,3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,2],xmm4[0,2]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm5[0],xmm2[1],xmm5[1]
; SSE-NEXT:    movaps %xmm1, 32(%rax)
; SSE-NEXT:    movaps %xmm7, 16(%rax)
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    movq %xmm2, 48(%rax)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i32_stride7_vf2:
; AVX:       # %bb.0:
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX-NEXT:    vmovq {{.*#+}} xmm5 = mem[0],zero
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm4 = xmm5[0],xmm4[0]
; AVX-NEXT:    vmovsd {{.*#+}} xmm6 = mem[0],zero
; AVX-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm0
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX-NEXT:    vshufps {{.*#+}} ymm6 = ymm1[3,0],ymm0[1,0],ymm1[7,4],ymm0[5,4]
; AVX-NEXT:    vshufps {{.*#+}} ymm6 = ymm6[0,2],ymm0[2,1],ymm6[4,6],ymm0[6,5]
; AVX-NEXT:    vpalignr {{.*#+}} xmm5 = xmm2[12,13,14,15],xmm5[0,1,2,3,4,5,6,7,8,9,10,11]
; AVX-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,2],xmm4[3,3]
; AVX-NEXT:    vblendps {{.*#+}} xmm5 = xmm5[0,1,2],xmm6[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[0,2],ymm0[0,3],ymm1[4,6],ymm0[4,7]
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm1
; AVX-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[u,u,0,2,u,u,u,5]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[0,2],ymm1[2,3],ymm2[4,6],ymm1[6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6],ymm1[7]
; AVX-NEXT:    vmovaps %ymm0, (%rax)
; AVX-NEXT:    vextractf128 $1, %ymm6, %xmm0
; AVX-NEXT:    vmovlps %xmm0, 48(%rax)
; AVX-NEXT:    vmovaps %xmm5, 32(%rax)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i32_stride7_vf2:
; AVX2:       # %bb.0:
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX2-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX2-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX2-NEXT:    vmovsd {{.*#+}} xmm3 = mem[0],zero
; AVX2-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX2-NEXT:    vmovsd {{.*#+}} xmm3 = mem[0],zero
; AVX2-NEXT:    vmovsd {{.*#+}} xmm4 = mem[0],zero
; AVX2-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX2-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX2-NEXT:    vmovsd {{.*#+}} xmm3 = mem[0],zero
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm3[0],ymm0[2],ymm3[2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[0,2,2,1,4,6,6,5]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,2,1]
; AVX2-NEXT:    vshufps {{.*#+}} ymm3 = ymm0[0,2,2,3,4,6,6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,1,0,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5,6],ymm1[7]
; AVX2-NEXT:    vmovaps {{.*#+}} xmm3 = [3,5,7,u]
; AVX2-NEXT:    vpermps %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vbroadcastf128 {{.*#+}} ymm3 = [3,5,0,1,3,5,0,1]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpermps %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0,1,2],xmm0[3]
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vmovlps %xmm0, 48(%rax)
; AVX2-NEXT:    vmovaps %xmm2, 32(%rax)
; AVX2-NEXT:    vmovaps %ymm1, (%rax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i32_stride7_vf2:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-FP-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX2-FP-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX2-FP-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX2-FP-NEXT:    vmovsd {{.*#+}} xmm3 = mem[0],zero
; AVX2-FP-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX2-FP-NEXT:    vmovsd {{.*#+}} xmm3 = mem[0],zero
; AVX2-FP-NEXT:    vmovsd {{.*#+}} xmm4 = mem[0],zero
; AVX2-FP-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX2-FP-NEXT:    vmovsd {{.*#+}} xmm3 = mem[0],zero
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm3[0],ymm0[2],ymm3[2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[0,2,2,1,4,6,6,5]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,2,1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm3 = ymm0[0,2,2,3,4,6,6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,1,0,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovaps {{.*#+}} xmm3 = [3,5,7,u]
; AVX2-FP-NEXT:    vpermps %ymm2, %ymm3, %ymm2
; AVX2-FP-NEXT:    vbroadcastf128 {{.*#+}} ymm3 = [3,5,0,1,3,5,0,1]
; AVX2-FP-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-FP-NEXT:    vpermps %ymm0, %ymm3, %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0,1,2],xmm0[3]
; AVX2-FP-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX2-FP-NEXT:    vmovlps %xmm0, 48(%rax)
; AVX2-FP-NEXT:    vmovaps %xmm2, 32(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm1, (%rax)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i32_stride7_vf2:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-FCP-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX2-FCP-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX2-FCP-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX2-FCP-NEXT:    vmovsd {{.*#+}} xmm3 = mem[0],zero
; AVX2-FCP-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX2-FCP-NEXT:    vmovsd {{.*#+}} xmm3 = mem[0],zero
; AVX2-FCP-NEXT:    vmovsd {{.*#+}} xmm4 = mem[0],zero
; AVX2-FCP-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX2-FCP-NEXT:    vmovsd {{.*#+}} xmm3 = mem[0],zero
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm3[0],ymm0[2],ymm3[2]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-FCP-NEXT:    vmovaps {{.*#+}} xmm1 = [3,5,7,u]
; AVX2-FCP-NEXT:    vpermps %ymm2, %ymm1, %ymm1
; AVX2-FCP-NEXT:    vbroadcastf128 {{.*#+}} ymm3 = [3,5,0,1,3,5,0,1]
; AVX2-FCP-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm3, %ymm3
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1,2],xmm3[3]
; AVX2-FCP-NEXT:    vmovaps {{.*#+}} ymm4 = [0,2,4,6,u,u,u,1]
; AVX2-FCP-NEXT:    vpermps %ymm2, %ymm4, %ymm2
; AVX2-FCP-NEXT:    vbroadcastf128 {{.*#+}} ymm4 = [0,2,4,0,0,2,4,0]
; AVX2-FCP-NEXT:    # ymm4 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm4, %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6],ymm2[7]
; AVX2-FCP-NEXT:    vextractf128 $1, %ymm3, %xmm2
; AVX2-FCP-NEXT:    vmovlps %xmm2, 48(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FCP-NEXT:    vmovaps %xmm1, 32(%rax)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride7_vf2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX512-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX512-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm3[0],ymm0[2],ymm3[2]
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,2,4,6,16,20,18,1,3,5,7,17,21,19,0,0]
; AVX512-NEXT:    vpermi2d %zmm0, %zmm2, %zmm1
; AVX512-NEXT:    vextracti32x4 $2, %zmm1, 32(%rax)
; AVX512-NEXT:    vextracti32x4 $3, %zmm1, %xmm0
; AVX512-NEXT:    vmovq %xmm0, 48(%rax)
; AVX512-NEXT:    vmovdqa %ymm1, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i32_stride7_vf2:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512-FCP-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512-FCP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512-FCP-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512-FCP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512-FCP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512-FCP-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX512-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX512-FCP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm1 = [0,2,4,0]
; AVX512-FCP-NEXT:    vpermi2q %ymm3, %ymm0, %ymm1
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,2,4,6,16,18,20,1,3,5,7,17,19,21,0,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm2, %zmm0
; AVX512-FCP-NEXT:    vextracti32x4 $2, %zmm0, 32(%rax)
; AVX512-FCP-NEXT:    vextracti32x4 $3, %zmm0, %xmm1
; AVX512-FCP-NEXT:    vmovq %xmm1, 48(%rax)
; AVX512-FCP-NEXT:    vmovdqa %ymm0, (%rax)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i32_stride7_vf2:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512DQ-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512DQ-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512DQ-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX512DQ-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512DQ-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm3[0],ymm0[2],ymm3[2]
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,2,4,6,16,20,18,1,3,5,7,17,21,19,0,0]
; AVX512DQ-NEXT:    vpermi2d %zmm0, %zmm2, %zmm1
; AVX512DQ-NEXT:    vextracti32x4 $2, %zmm1, 32(%rax)
; AVX512DQ-NEXT:    vextracti32x4 $3, %zmm1, %xmm0
; AVX512DQ-NEXT:    vmovq %xmm0, 48(%rax)
; AVX512DQ-NEXT:    vmovdqa %ymm1, (%rax)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i32_stride7_vf2:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-FCP-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512DQ-FCP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX512DQ-FCP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm1 = [0,2,4,0]
; AVX512DQ-FCP-NEXT:    vpermi2q %ymm3, %ymm0, %ymm1
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,2,4,6,16,18,20,1,3,5,7,17,19,21,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm2, %zmm0
; AVX512DQ-FCP-NEXT:    vextracti32x4 $2, %zmm0, 32(%rax)
; AVX512DQ-FCP-NEXT:    vextracti32x4 $3, %zmm0, %xmm1
; AVX512DQ-FCP-NEXT:    vmovq %xmm1, 48(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm0, (%rax)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride7_vf2:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX512BW-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512BW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm3[0],ymm0[2],ymm3[2]
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,2,4,6,16,20,18,1,3,5,7,17,21,19,0,0]
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm2, %zmm1
; AVX512BW-NEXT:    vextracti32x4 $2, %zmm1, 32(%rax)
; AVX512BW-NEXT:    vextracti32x4 $3, %zmm1, %xmm0
; AVX512BW-NEXT:    vmovq %xmm0, 48(%rax)
; AVX512BW-NEXT:    vmovdqa %ymm1, (%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i32_stride7_vf2:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-FCP-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512BW-FCP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512BW-FCP-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512BW-FCP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512BW-FCP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512BW-FCP-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX512BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX512BW-FCP-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX512BW-FCP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512BW-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm1 = [0,2,4,0]
; AVX512BW-FCP-NEXT:    vpermi2q %ymm3, %ymm0, %ymm1
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,2,4,6,16,18,20,1,3,5,7,17,19,21,0,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm1, %zmm2, %zmm0
; AVX512BW-FCP-NEXT:    vextracti32x4 $2, %zmm0, 32(%rax)
; AVX512BW-FCP-NEXT:    vextracti32x4 $3, %zmm0, %xmm1
; AVX512BW-FCP-NEXT:    vmovq %xmm1, 48(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa %ymm0, (%rax)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i32_stride7_vf2:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-BW-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-BW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-BW-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512DQ-BW-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512DQ-BW-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512DQ-BW-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512DQ-BW-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX512DQ-BW-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX512DQ-BW-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX512DQ-BW-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512DQ-BW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512DQ-BW-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm3[0],ymm0[2],ymm3[2]
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,2,4,6,16,20,18,1,3,5,7,17,21,19,0,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm0, %zmm2, %zmm1
; AVX512DQ-BW-NEXT:    vextracti32x4 $2, %zmm1, 32(%rax)
; AVX512DQ-BW-NEXT:    vextracti32x4 $3, %zmm1, %xmm0
; AVX512DQ-BW-NEXT:    vmovq %xmm0, 48(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa %ymm1, (%rax)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i32_stride7_vf2:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-BW-FCP-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512DQ-BW-FCP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX512DQ-BW-FCP-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm1 = [0,2,4,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %ymm3, %ymm0, %ymm1
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,2,4,6,16,18,20,1,3,5,7,17,19,21,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm1, %zmm2, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vextracti32x4 $2, %zmm0, 32(%rax)
; AVX512DQ-BW-FCP-NEXT:    vextracti32x4 $3, %zmm0, %xmm1
; AVX512DQ-BW-FCP-NEXT:    vmovq %xmm1, 48(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %ymm0, (%rax)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <2 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <2 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <2 x i32>, ptr %in.vecptr2, align 64
  %in.vec3 = load <2 x i32>, ptr %in.vecptr3, align 64
  %in.vec4 = load <2 x i32>, ptr %in.vecptr4, align 64
  %in.vec5 = load <2 x i32>, ptr %in.vecptr5, align 64
  %in.vec6 = load <2 x i32>, ptr %in.vecptr6, align 64
  %1 = shufflevector <2 x i32> %in.vec0, <2 x i32> %in.vec1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = shufflevector <2 x i32> %in.vec2, <2 x i32> %in.vec3, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = shufflevector <2 x i32> %in.vec4, <2 x i32> %in.vec5, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = shufflevector <4 x i32> %1, <4 x i32> %2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %5 = shufflevector <2 x i32> %in.vec6, <2 x i32> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %6 = shufflevector <4 x i32> %3, <4 x i32> %5, <6 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5>
  %7 = shufflevector <6 x i32> %6, <6 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 undef, i32 undef>
  %8 = shufflevector <8 x i32> %4, <8 x i32> %7, <14 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13>
  %interleaved.vec = shufflevector <14 x i32> %8, <14 x i32> poison, <14 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13>
  store <14 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride7_vf4(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride7_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    movaps (%rsi), %xmm6
; SSE-NEXT:    movaps (%rdx), %xmm5
; SSE-NEXT:    movaps (%rcx), %xmm1
; SSE-NEXT:    movaps (%r8), %xmm4
; SSE-NEXT:    movaps (%r9), %xmm2
; SSE-NEXT:    movaps (%r10), %xmm8
; SSE-NEXT:    movaps %xmm5, %xmm7
; SSE-NEXT:    unpcklps {{.*#+}} xmm7 = xmm7[0],xmm1[0],xmm7[1],xmm1[1]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm6[0],xmm3[1],xmm6[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm3 = xmm3[0],xmm7[0]
; SSE-NEXT:    movaps %xmm4, %xmm9
; SSE-NEXT:    unpckhps {{.*#+}} xmm9 = xmm9[2],xmm2[2],xmm9[3],xmm2[3]
; SSE-NEXT:    movaps %xmm5, %xmm7
; SSE-NEXT:    unpckhps {{.*#+}} xmm7 = xmm7[2],xmm1[2],xmm7[3],xmm1[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm7 = xmm7[0],xmm9[0]
; SSE-NEXT:    movaps %xmm8, %xmm9
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[3,3],xmm2[3,3]
; SSE-NEXT:    movaps %xmm4, %xmm10
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[1,1],xmm1[1,1]
; SSE-NEXT:    unpckhps {{.*#+}} xmm1 = xmm1[2],xmm4[2],xmm1[3],xmm4[3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,3],xmm9[2,0]
; SSE-NEXT:    movaps %xmm0, %xmm9
; SSE-NEXT:    unpckhps {{.*#+}} xmm9 = xmm9[2],xmm6[2],xmm9[3],xmm6[3]
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-NEXT:    unpcklps {{.*#+}} xmm2 = xmm2[0],xmm8[0],xmm2[1],xmm8[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,3],xmm9[0,1]
; SSE-NEXT:    movaps %xmm6, %xmm9
; SSE-NEXT:    unpcklps {{.*#+}} xmm9 = xmm9[0],xmm5[0],xmm9[1],xmm5[1]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[2,3],xmm10[2,0]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm8[2,3,2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,1],xmm0[1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm8[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[3,3],xmm6[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3],xmm5[2,0]
; SSE-NEXT:    movss {{.*#+}} xmm0 = xmm10[0],xmm0[1,2,3]
; SSE-NEXT:    movaps %xmm4, 16(%rax)
; SSE-NEXT:    movaps %xmm9, 32(%rax)
; SSE-NEXT:    movaps %xmm2, 48(%rax)
; SSE-NEXT:    movaps %xmm1, 96(%rax)
; SSE-NEXT:    movaps %xmm7, 64(%rax)
; SSE-NEXT:    movaps %xmm3, (%rax)
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i32_stride7_vf4:
; AVX:       # %bb.0:
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX-NEXT:    vmovaps (%rdi), %xmm5
; AVX-NEXT:    vmovaps (%rsi), %xmm6
; AVX-NEXT:    vmovaps (%rdx), %xmm3
; AVX-NEXT:    vmovaps (%rcx), %xmm4
; AVX-NEXT:    vmovaps (%r8), %xmm1
; AVX-NEXT:    vmovaps (%r9), %xmm2
; AVX-NEXT:    vmovaps (%r10), %xmm0
; AVX-NEXT:    vinsertf128 $1, %xmm6, %ymm5, %ymm7
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm8
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm9
; AVX-NEXT:    vshufps {{.*#+}} ymm10 = ymm9[1,0],ymm8[1,0],ymm9[5,4],ymm8[5,4]
; AVX-NEXT:    vshufps {{.*#+}} ymm10 = ymm10[2,0],ymm8[2,1],ymm10[6,4],ymm8[6,5]
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm6, %ymm5
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm6 = ymm7[1],ymm5[1],ymm7[3],ymm5[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm6 = ymm5[1,1],ymm6[2,0],ymm5[5,5],ymm6[6,4]
; AVX-NEXT:    vshufps {{.*#+}} xmm11 = xmm3[1,1],xmm4[1,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0],ymm11[1,2],ymm6[3,4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2],ymm10[3,4,5],ymm6[6,7]
; AVX-NEXT:    vshufps {{.*#+}} ymm10 = ymm5[3,3],ymm7[3,3],ymm5[7,7],ymm7[7,7]
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm11
; AVX-NEXT:    vunpckhps {{.*#+}} ymm11 = ymm3[2],ymm11[2],ymm3[3],ymm11[3],ymm3[6],ymm11[6],ymm3[7],ymm11[7]
; AVX-NEXT:    vblendps {{.*#+}} ymm10 = ymm11[0,1,2,3,4],ymm10[5,6],ymm11[7]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm11 = xmm2[1],xmm1[1]
; AVX-NEXT:    vshufps {{.*#+}} ymm9 = ymm9[2,1],ymm11[2,0],ymm9[6,5],ymm11[6,4]
; AVX-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0,1],ymm9[2,3,4],ymm10[5,6,7]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm10
; AVX-NEXT:    vunpcklps {{.*#+}} ymm8 = ymm10[0],ymm8[0],ymm10[1],ymm8[1],ymm10[4],ymm8[4],ymm10[5],ymm8[5]
; AVX-NEXT:    vbroadcastss (%r10), %ymm10
; AVX-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],ymm10[6,7]
; AVX-NEXT:    vunpcklps {{.*#+}} ymm5 = ymm7[0],ymm5[0],ymm7[1],ymm5[1],ymm7[4],ymm5[4],ymm7[5],ymm5[5]
; AVX-NEXT:    vshufps {{.*#+}} xmm3 = xmm4[0,0],xmm3[0,0]
; AVX-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[0,1,2,0]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm5[0,1],ymm3[2,3],ymm5[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm8[4,5,6],ymm3[7]
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[3,3],xmm2[3,3]
; AVX-NEXT:    vbroadcastss 12(%rcx), %xmm2
; AVX-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0],xmm1[1,2,3]
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[3]
; AVX-NEXT:    vmovaps %xmm0, 96(%rax)
; AVX-NEXT:    vmovaps %ymm3, (%rax)
; AVX-NEXT:    vmovaps %ymm9, 64(%rax)
; AVX-NEXT:    vmovaps %ymm6, 32(%rax)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i32_stride7_vf4:
; AVX2:       # %bb.0:
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-NEXT:    vmovaps (%rdi), %xmm4
; AVX2-NEXT:    vmovaps (%rdx), %xmm5
; AVX2-NEXT:    vmovaps (%rcx), %xmm0
; AVX2-NEXT:    vmovaps (%r8), %xmm2
; AVX2-NEXT:    vmovaps (%r9), %xmm3
; AVX2-NEXT:    vmovaps (%r10), %xmm1
; AVX2-NEXT:    vinsertf128 $1, (%rsi), %ymm4, %ymm4
; AVX2-NEXT:    vinsertf128 $1, %xmm0, %ymm5, %ymm6
; AVX2-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm7
; AVX2-NEXT:    vshufps {{.*#+}} ymm8 = ymm4[3,3,3,3,7,7,7,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm6[0],ymm8[1],ymm6[2,3],ymm8[4],ymm6[5,6,7]
; AVX2-NEXT:    vmovaps {{.*#+}} ymm9 = [2,6,u,u,u,1,4,3]
; AVX2-NEXT:    vpermps %ymm8, %ymm9, %ymm8
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm9
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm9 = ymm9[2],ymm3[2],ymm9[3],ymm3[3],ymm9[6],ymm3[6],ymm9[7],ymm3[7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm9 = ymm9[0,1,0,1,4,5,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1],ymm9[2,3,4],ymm8[5,6,7]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm9
; AVX2-NEXT:    vshufps {{.*#+}} ymm10 = ymm7[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0,1,2,3,4],ymm9[5],ymm10[6,7]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm5 = zero,xmm5[1],xmm0[1],zero
; AVX2-NEXT:    vbroadcastf128 {{.*#+}} ymm10 = [5,0,2,6,5,0,2,6]
; AVX2-NEXT:    # ymm10 = mem[0,1,0,1]
; AVX2-NEXT:    vpermps %ymm4, %ymm10, %ymm10
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm10[0],ymm5[1,2],ymm10[3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2],ymm9[3,4,5],ymm5[6,7]
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm9 = [0,4,0,4,0,4,0,4]
; AVX2-NEXT:    vpermps %ymm6, %ymm9, %ymm6
; AVX2-NEXT:    vbroadcastf128 {{.*#+}} ymm10 = [0,4,0,1,0,4,0,1]
; AVX2-NEXT:    # ymm10 = mem[0,1,0,1]
; AVX2-NEXT:    vpermps %ymm4, %ymm10, %ymm4
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm6[2,3],ymm4[4,5,6,7]
; AVX2-NEXT:    vpermps %ymm7, %ymm9, %ymm6
; AVX2-NEXT:    vbroadcastss (%r10), %ymm7
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],ymm7[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm6[4,5,6],ymm4[7]
; AVX2-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[3,3],xmm3[3,3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[3],xmm2[1,2],zero
; AVX2-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[3]
; AVX2-NEXT:    vmovaps %xmm0, 96(%rax)
; AVX2-NEXT:    vmovaps %ymm4, (%rax)
; AVX2-NEXT:    vmovaps %ymm5, 32(%rax)
; AVX2-NEXT:    vmovaps %ymm8, 64(%rax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i32_stride7_vf4:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-FP-NEXT:    vmovaps (%rdi), %xmm4
; AVX2-FP-NEXT:    vmovaps (%rdx), %xmm5
; AVX2-FP-NEXT:    vmovaps (%rcx), %xmm0
; AVX2-FP-NEXT:    vmovaps (%r8), %xmm2
; AVX2-FP-NEXT:    vmovaps (%r9), %xmm3
; AVX2-FP-NEXT:    vmovaps (%r10), %xmm1
; AVX2-FP-NEXT:    vinsertf128 $1, (%rsi), %ymm4, %ymm4
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm0, %ymm5, %ymm6
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm7
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm8 = ymm4[3,3,3,3,7,7,7,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm6[0],ymm8[1],ymm6[2,3],ymm8[4],ymm6[5,6,7]
; AVX2-FP-NEXT:    vmovaps {{.*#+}} ymm9 = [2,6,u,u,u,1,4,3]
; AVX2-FP-NEXT:    vpermps %ymm8, %ymm9, %ymm8
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm9
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm9 = ymm9[2],ymm3[2],ymm9[3],ymm3[3],ymm9[6],ymm3[6],ymm9[7],ymm3[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm9 = ymm9[0,1,0,1,4,5,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1],ymm9[2,3,4],ymm8[5,6,7]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm9
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm10 = ymm7[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0,1,2,3,4],ymm9[5],ymm10[6,7]
; AVX2-FP-NEXT:    vinsertps {{.*#+}} xmm5 = zero,xmm5[1],xmm0[1],zero
; AVX2-FP-NEXT:    vbroadcastf128 {{.*#+}} ymm10 = [5,0,2,6,5,0,2,6]
; AVX2-FP-NEXT:    # ymm10 = mem[0,1,0,1]
; AVX2-FP-NEXT:    vpermps %ymm4, %ymm10, %ymm10
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm10[0],ymm5[1,2],ymm10[3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2],ymm9[3,4,5],ymm5[6,7]
; AVX2-FP-NEXT:    vbroadcastsd {{.*#+}} ymm9 = [0,4,0,4,0,4,0,4]
; AVX2-FP-NEXT:    vpermps %ymm6, %ymm9, %ymm6
; AVX2-FP-NEXT:    vbroadcastf128 {{.*#+}} ymm10 = [0,4,0,1,0,4,0,1]
; AVX2-FP-NEXT:    # ymm10 = mem[0,1,0,1]
; AVX2-FP-NEXT:    vpermps %ymm4, %ymm10, %ymm4
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm6[2,3],ymm4[4,5,6,7]
; AVX2-FP-NEXT:    vpermps %ymm7, %ymm9, %ymm6
; AVX2-FP-NEXT:    vbroadcastss (%r10), %ymm7
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],ymm7[6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm6[4,5,6],ymm4[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[3,3],xmm3[3,3]
; AVX2-FP-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[3],xmm2[1,2],zero
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[3]
; AVX2-FP-NEXT:    vmovaps %xmm0, 96(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm4, (%rax)
; AVX2-FP-NEXT:    vmovaps %ymm5, 32(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm8, 64(%rax)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i32_stride7_vf4:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-FCP-NEXT:    vmovaps (%rdi), %xmm2
; AVX2-FCP-NEXT:    vmovaps (%rdx), %xmm3
; AVX2-FCP-NEXT:    vmovaps (%rcx), %xmm1
; AVX2-FCP-NEXT:    vmovaps (%r8), %xmm4
; AVX2-FCP-NEXT:    vmovaps (%r9), %xmm5
; AVX2-FCP-NEXT:    vmovaps (%r10), %xmm0
; AVX2-FCP-NEXT:    vinsertf128 $1, (%rsi), %ymm2, %ymm2
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm3
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm5, %ymm4, %ymm6
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm7
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm8 = ymm6[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0,1,2,3,4],ymm7[5],ymm8[6,7]
; AVX2-FCP-NEXT:    vbroadcastsd {{.*#+}} ymm8 = [5,1,5,1,5,1,5,1]
; AVX2-FCP-NEXT:    vpermps %ymm3, %ymm8, %ymm8
; AVX2-FCP-NEXT:    vbroadcastf128 {{.*#+}} ymm9 = [5,0,2,6,5,0,2,6]
; AVX2-FCP-NEXT:    # ymm9 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpermps %ymm2, %ymm9, %ymm9
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0],ymm8[1,2],ymm9[3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0,1,2],ymm7[3,4,5],ymm8[6,7]
; AVX2-FCP-NEXT:    vbroadcastsd {{.*#+}} ymm8 = [7,3,7,3,7,3,7,3]
; AVX2-FCP-NEXT:    vpermps %ymm2, %ymm8, %ymm8
; AVX2-FCP-NEXT:    vbroadcastf128 {{.*#+}} ymm9 = [2,6,0,3,2,6,0,3]
; AVX2-FCP-NEXT:    # ymm9 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpermps %ymm3, %ymm9, %ymm9
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0,1,2,3,4],ymm8[5,6],ymm9[7]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm4, %ymm4
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm4 = ymm4[2],ymm5[2],ymm4[3],ymm5[3],ymm4[6],ymm5[6],ymm4[7],ymm5[7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm4 = ymm4[0,1,0,1,4,5,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm8[0,1],ymm4[2,3,4],ymm8[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd {{.*#+}} ymm5 = [0,4,0,4,0,4,0,4]
; AVX2-FCP-NEXT:    vpermps %ymm3, %ymm5, %ymm3
; AVX2-FCP-NEXT:    vbroadcastf128 {{.*#+}} ymm8 = [0,4,0,1,0,4,0,1]
; AVX2-FCP-NEXT:    # ymm8 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpermps %ymm2, %ymm8, %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vpermps %ymm6, %ymm5, %ymm3
; AVX2-FCP-NEXT:    vbroadcastss (%r10), %ymm5
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm5[6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4,5,6],ymm2[7]
; AVX2-FCP-NEXT:    vbroadcastsd {{.*#+}} ymm3 = [7,3,7,3,7,3,7,3]
; AVX2-FCP-NEXT:    vpermps %ymm6, %ymm3, %ymm3
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[3,3,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],xmm3[1,2,3]
; AVX2-FCP-NEXT:    vmovaps %ymm2, (%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm4, 64(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm7, 32(%rax)
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[3]
; AVX2-FCP-NEXT:    vmovaps %xmm0, 96(%rax)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride7_vf4:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512-NEXT:    vmovdqa (%r8), %xmm2
; AVX512-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512-NEXT:    vinserti128 $1, (%r9), %ymm2, %ymm1
; AVX512-NEXT:    vinserti32x4 $2, (%r10), %zmm1, %zmm1
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,4,8,12,16,20,24,1,5,9,13,17,21,25,2,6]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [10,14,18,22,26,3,7,11,15,19,23,27,0,0,0,0]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512-NEXT:    vextracti32x4 $2, %zmm3, 96(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm2, (%rax)
; AVX512-NEXT:    vmovdqa %ymm3, 64(%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i32_stride7_vf4:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512-FCP-NEXT:    vmovdqa (%r8), %xmm2
; AVX512-FCP-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512-FCP-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512-FCP-NEXT:    vinserti128 $1, (%r9), %ymm2, %ymm1
; AVX512-FCP-NEXT:    vinserti32x4 $2, (%r10), %zmm1, %zmm1
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,4,8,12,16,20,24,1,5,9,13,17,21,25,2,6]
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [10,14,18,22,26,3,7,11,15,19,23,27,0,0,0,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512-FCP-NEXT:    vextracti32x4 $2, %zmm3, 96(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, (%rax)
; AVX512-FCP-NEXT:    vmovdqa %ymm3, 64(%rax)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i32_stride7_vf4:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-NEXT:    vmovdqa (%r8), %xmm2
; AVX512DQ-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512DQ-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vinserti128 $1, (%r9), %ymm2, %ymm1
; AVX512DQ-NEXT:    vinserti32x4 $2, (%r10), %zmm1, %zmm1
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,4,8,12,16,20,24,1,5,9,13,17,21,25,2,6]
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [10,14,18,22,26,3,7,11,15,19,23,27,0,0,0,0]
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512DQ-NEXT:    vextracti32x4 $2, %zmm3, 96(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, (%rax)
; AVX512DQ-NEXT:    vmovdqa %ymm3, 64(%rax)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i32_stride7_vf4:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-FCP-NEXT:    vmovdqa (%r8), %xmm2
; AVX512DQ-FCP-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512DQ-FCP-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-FCP-NEXT:    vinserti128 $1, (%r9), %ymm2, %ymm1
; AVX512DQ-FCP-NEXT:    vinserti32x4 $2, (%r10), %zmm1, %zmm1
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,4,8,12,16,20,24,1,5,9,13,17,21,25,2,6]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [10,14,18,22,26,3,7,11,15,19,23,27,0,0,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512DQ-FCP-NEXT:    vextracti32x4 $2, %zmm3, 96(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, (%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm3, 64(%rax)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride7_vf4:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512BW-NEXT:    vmovdqa (%r8), %xmm2
; AVX512BW-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512BW-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vinserti128 $1, (%r9), %ymm2, %ymm1
; AVX512BW-NEXT:    vinserti32x4 $2, (%r10), %zmm1, %zmm1
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,4,8,12,16,20,24,1,5,9,13,17,21,25,2,6]
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [10,14,18,22,26,3,7,11,15,19,23,27,0,0,0,0]
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    vextracti32x4 $2, %zmm3, 96(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm2, (%rax)
; AVX512BW-NEXT:    vmovdqa %ymm3, 64(%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i32_stride7_vf4:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512BW-FCP-NEXT:    vmovdqa (%r8), %xmm2
; AVX512BW-FCP-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512BW-FCP-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512BW-FCP-NEXT:    vinserti128 $1, (%r9), %ymm2, %ymm1
; AVX512BW-FCP-NEXT:    vinserti32x4 $2, (%r10), %zmm1, %zmm1
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,4,8,12,16,20,24,1,5,9,13,17,21,25,2,6]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [10,14,18,22,26,3,7,11,15,19,23,27,0,0,0,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512BW-FCP-NEXT:    vextracti32x4 $2, %zmm3, 96(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, (%rax)
; AVX512BW-FCP-NEXT:    vmovdqa %ymm3, 64(%rax)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i32_stride7_vf4:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-BW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-BW-NEXT:    vmovdqa (%r8), %xmm2
; AVX512DQ-BW-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512DQ-BW-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-BW-NEXT:    vinserti128 $1, (%r9), %ymm2, %ymm1
; AVX512DQ-BW-NEXT:    vinserti32x4 $2, (%r10), %zmm1, %zmm1
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,4,8,12,16,20,24,1,5,9,13,17,21,25,2,6]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [10,14,18,22,26,3,7,11,15,19,23,27,0,0,0,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512DQ-BW-NEXT:    vextracti32x4 $2, %zmm3, 96(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, (%rax)
; AVX512DQ-BW-NEXT:    vmovdqa %ymm3, 64(%rax)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i32_stride7_vf4:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%r8), %xmm2
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, (%r9), %ymm2, %ymm1
; AVX512DQ-BW-FCP-NEXT:    vinserti32x4 $2, (%r10), %zmm1, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,4,8,12,16,20,24,1,5,9,13,17,21,25,2,6]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [10,14,18,22,26,3,7,11,15,19,23,27,0,0,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vextracti32x4 $2, %zmm3, 96(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, (%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %ymm3, 64(%rax)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <4 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <4 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <4 x i32>, ptr %in.vecptr2, align 64
  %in.vec3 = load <4 x i32>, ptr %in.vecptr3, align 64
  %in.vec4 = load <4 x i32>, ptr %in.vecptr4, align 64
  %in.vec5 = load <4 x i32>, ptr %in.vecptr5, align 64
  %in.vec6 = load <4 x i32>, ptr %in.vecptr6, align 64
  %1 = shufflevector <4 x i32> %in.vec0, <4 x i32> %in.vec1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = shufflevector <4 x i32> %in.vec2, <4 x i32> %in.vec3, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %3 = shufflevector <4 x i32> %in.vec4, <4 x i32> %in.vec5, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = shufflevector <8 x i32> %1, <8 x i32> %2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %5 = shufflevector <4 x i32> %in.vec6, <4 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <8 x i32> %3, <8 x i32> %5, <12 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11>
  %7 = shufflevector <12 x i32> %6, <12 x i32> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 undef, i32 undef, i32 undef, i32 undef>
  %8 = shufflevector <16 x i32> %4, <16 x i32> %7, <28 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27>
  %interleaved.vec = shufflevector <28 x i32> %8, <28 x i32> poison, <28 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27>
  store <28 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride7_vf8(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride7_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $24, %rsp
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa (%rdi), %xmm3
; SSE-NEXT:    movdqa 16(%rdi), %xmm9
; SSE-NEXT:    movdqa (%rsi), %xmm1
; SSE-NEXT:    movdqa 16(%rsi), %xmm5
; SSE-NEXT:    movdqa 16(%rdx), %xmm6
; SSE-NEXT:    movdqa 16(%rcx), %xmm12
; SSE-NEXT:    movdqa 16(%r8), %xmm11
; SSE-NEXT:    movdqa (%r9), %xmm8
; SSE-NEXT:    movaps 16(%r9), %xmm0
; SSE-NEXT:    movdqa (%rax), %xmm10
; SSE-NEXT:    movaps 16(%rax), %xmm7
; SSE-NEXT:    movaps %xmm7, %xmm2
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm0[3,3]
; SSE-NEXT:    movaps %xmm0, %xmm13
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm11[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm12[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,0]
; SSE-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm11, %xmm2
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,1],xmm12[1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm6[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm5[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,0]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm9, %xmm2
; SSE-NEXT:    punpckhdq {{.*#+}} xmm2 = xmm2[2],xmm5[2],xmm2[3],xmm5[3]
; SSE-NEXT:    movdqa %xmm5, %xmm14
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm7[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm13[1,1,1,1]
; SSE-NEXT:    movdqa %xmm13, %xmm15
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm10[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm8[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm2 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rdx), %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm1[1,1,1,1]
; SSE-NEXT:    movaps %xmm2, %xmm13
; SSE-NEXT:    movss {{.*#+}} xmm13 = xmm5[0],xmm13[1,2,3]
; SSE-NEXT:    movaps (%rcx), %xmm0
; SSE-NEXT:    movaps (%r8), %xmm4
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[0,1],xmm5[2,0]
; SSE-NEXT:    movdqa %xmm6, %xmm5
; SSE-NEXT:    punpckhdq {{.*#+}} xmm5 = xmm5[2],xmm12[2],xmm5[3],xmm12[3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm12 = xmm12[0],xmm6[0]
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[3,3],xmm14[3,3]
; SSE-NEXT:    movdqa %xmm9, %xmm14
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[1,1],xmm7[0,3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,1],xmm9[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,2],xmm6[2,0]
; SSE-NEXT:    movdqa %xmm11, %xmm6
; SSE-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm15[0],xmm6[1],xmm15[1]
; SSE-NEXT:    movdqa %xmm15, %xmm12
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm14[2,0]
; SSE-NEXT:    movaps %xmm4, %xmm15
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm15 = xmm15[2],xmm8[2],xmm15[3],xmm8[3]
; SSE-NEXT:    movaps %xmm2, %xmm14
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm14 = xmm14[2],xmm0[2],xmm14[3],xmm0[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm14 = xmm14[0],xmm15[0]
; SSE-NEXT:    movdqa %xmm10, %xmm15
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[0,1],xmm3[1,3]
; SSE-NEXT:    movaps %xmm4, %xmm3
; SSE-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm8[0],xmm3[1],xmm8[1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm15[0,2]
; SSE-NEXT:    movaps %xmm2, %xmm15
; SSE-NEXT:    unpcklps {{.*#+}} xmm15 = xmm15[0],xmm0[0],xmm15[1],xmm0[1]
; SSE-NEXT:    movdqa %xmm1, %xmm8
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    punpckldq {{.*#+}} xmm8 = xmm8[0],xmm1[0],xmm8[1],xmm1[1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm8 = xmm8[0],xmm15[0]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm11 = xmm11[2],xmm12[2],xmm11[3],xmm12[3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm5 = xmm5[0],xmm11[0]
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Folded Reload
; SSE-NEXT:    # xmm9 = xmm9[0],mem[0],xmm9[1],mem[1]
; SSE-NEXT:    shufps $36, {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Folded Reload
; SSE-NEXT:    # xmm9 = xmm9[0,1],mem[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm1[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3],xmm2[2,0]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm10[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm0 = xmm2[0],xmm0[1,2,3]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Folded Reload
; SSE-NEXT:    # xmm10 = xmm10[3,3],mem[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,3],xmm10[2,0]
; SSE-NEXT:    pshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[3,3,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm4 = xmm2[0],xmm4[1,2,3]
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movaps %xmm9, 112(%rax)
; SSE-NEXT:    movdqa %xmm5, 176(%rax)
; SSE-NEXT:    movdqa %xmm8, (%rax)
; SSE-NEXT:    movaps %xmm3, 16(%rax)
; SSE-NEXT:    movaps %xmm14, 64(%rax)
; SSE-NEXT:    movaps %xmm6, 128(%rax)
; SSE-NEXT:    movaps %xmm7, 192(%rax)
; SSE-NEXT:    movaps %xmm13, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps %xmm4, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps %xmm1, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rax)
; SSE-NEXT:    addq $24, %rsp
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i32_stride7_vf8:
; AVX:       # %bb.0:
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX-NEXT:    vmovaps (%rdi), %ymm0
; AVX-NEXT:    vmovaps (%rsi), %ymm1
; AVX-NEXT:    vmovaps (%rdx), %ymm2
; AVX-NEXT:    vmovaps (%rcx), %ymm3
; AVX-NEXT:    vmovaps (%r8), %ymm7
; AVX-NEXT:    vmovaps (%r9), %ymm8
; AVX-NEXT:    vshufps {{.*#+}} ymm4 = ymm2[1,1],ymm3[1,1],ymm2[5,5],ymm3[5,5]
; AVX-NEXT:    vshufps {{.*#+}} ymm5 = ymm1[1,1],ymm0[1,1],ymm1[5,5],ymm0[5,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm5[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1,2,3,4],ymm4[5,6],ymm5[7]
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm8[0],ymm7[0],ymm8[2],ymm7[2]
; AVX-NEXT:    vshufps {{.*#+}} ymm5 = ymm5[2,0],ymm7[2,1],ymm5[6,4],ymm7[6,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm6 = mem[2,3],ymm5[2,3]
; AVX-NEXT:    vextractf128 $1, %ymm5, %xmm5
; AVX-NEXT:    vshufpd {{.*#+}} ymm5 = ymm5[0],ymm6[0],ymm5[2],ymm6[3]
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1,2],ymm4[3,4,5,6],ymm5[7]
; AVX-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps (%r8), %xmm5
; AVX-NEXT:    vmovaps (%r9), %xmm6
; AVX-NEXT:    vshufps {{.*#+}} xmm4 = xmm6[1,1],xmm5[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm4, %ymm4
; AVX-NEXT:    vmovaps (%rsi), %xmm11
; AVX-NEXT:    vmovaps (%rdi), %xmm12
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm9 = xmm12[1],xmm11[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm9 = xmm11[1,1],xmm9[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm9, %ymm9, %ymm9
; AVX-NEXT:    vmovaps (%rcx), %xmm15
; AVX-NEXT:    vmovaps (%rdx), %xmm14
; AVX-NEXT:    vinsertps {{.*#+}} xmm10 = zero,xmm14[1],xmm15[1],zero
; AVX-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm10[1,2],ymm9[3,4,5,6,7]
; AVX-NEXT:    vmovaps (%rax), %xmm10
; AVX-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm13
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4],ymm13[5],ymm4[6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm9[0,1,2],ymm4[3,4,5],ymm9[6,7]
; AVX-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpcklps {{.*#+}} xmm4 = xmm5[0],xmm6[0],xmm5[1],xmm6[1]
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm4
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm4[0],ymm13[0],ymm4[2],ymm13[2]
; AVX-NEXT:    vmovlhps {{.*#+}} xmm13 = xmm11[0],xmm12[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm13 = xmm13[2,0],xmm12[2,1]
; AVX-NEXT:    vinsertf128 $1, %xmm13, %ymm13, %ymm13
; AVX-NEXT:    vunpcklps {{.*#+}} xmm9 = xmm14[0],xmm15[0],xmm14[1],xmm15[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm9 = xmm9[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm9 = ymm13[0,1],ymm9[2,3],ymm13[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm9[0,1,2,3],ymm4[4,5,6],ymm9[7]
; AVX-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm4 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm4 = ymm4[0,1,2,0,4,5,6,4]
; AVX-NEXT:    vunpckhps {{.*#+}} ymm9 = ymm2[2],ymm3[2],ymm2[3],ymm3[3],ymm2[6],ymm3[6],ymm2[7],ymm3[7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],ymm9[2,3]
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm9 = ymm7[1],ymm8[1],ymm7[3],ymm8[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm9 = ymm8[1,1],ymm9[0,2],ymm8[5,5],ymm9[4,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm9[2,3,2,3]
; AVX-NEXT:    vmovaps 16(%rax), %xmm13
; AVX-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm13[1],ymm9[2,3,4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm9[0,1],ymm4[2,3,4,5],ymm9[6,7]
; AVX-NEXT:    vshufps {{.*#+}} ymm9 = ymm3[3,3],ymm2[3,3],ymm3[7,7],ymm2[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm9[2,3,2,3]
; AVX-NEXT:    vshufps {{.*#+}} ymm13 = ymm0[3,3],ymm1[3,3],ymm0[7,7],ymm1[7,7]
; AVX-NEXT:    vextractf128 $1, %ymm13, %xmm13
; AVX-NEXT:    vblendps {{.*#+}} ymm9 = ymm13[0,1,2],ymm9[3,4,5,6,7]
; AVX-NEXT:    vshufps {{.*#+}} ymm7 = ymm7[3,3],ymm8[3,3],ymm7[7,7],ymm8[7,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm9[0,1,2,3,4],ymm7[5,6],ymm9[7]
; AVX-NEXT:    vbroadcastsd 24(%rax), %ymm8
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0],ymm7[1,2,3,4,5,6],ymm8[7]
; AVX-NEXT:    vshufps {{.*#+}} xmm8 = xmm12[3,3],xmm11[3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm8, %ymm0, %ymm8
; AVX-NEXT:    vunpckhps {{.*#+}} xmm9 = xmm14[2],xmm15[2],xmm14[3],xmm15[3]
; AVX-NEXT:    vinsertf128 $1, %xmm14, %ymm9, %ymm9
; AVX-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0,1,2,3,4],ymm8[5,6],ymm9[7]
; AVX-NEXT:    vshufps {{.*#+}} xmm9 = xmm6[2,2,2,2]
; AVX-NEXT:    vblendps {{.*#+}} xmm9 = xmm5[0,1,2],xmm9[3]
; AVX-NEXT:    vbroadcastsd 8(%rax), %ymm11
; AVX-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3],ymm11[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1],ymm9[2,3,4],ymm8[5,6,7]
; AVX-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm3[3,1],ymm1[0,2],ymm3[7,5],ymm1[4,6]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5],ymm1[6,7]
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm5[3,3],xmm6[3,3]
; AVX-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1,2],xmm10[3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX-NEXT:    vmovaps %ymm8, 64(%rax)
; AVX-NEXT:    vmovaps %ymm4, 160(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, (%rax)
; AVX-NEXT:    vmovaps %ymm7, 192(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i32_stride7_vf8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vmovaps (%rsi), %ymm2
; AVX2-NEXT:    vmovaps (%rdx), %ymm9
; AVX2-NEXT:    vmovaps (%rcx), %ymm3
; AVX2-NEXT:    vmovaps (%r8), %ymm6
; AVX2-NEXT:    vmovaps (%r9), %ymm7
; AVX2-NEXT:    vmovaps (%rax), %xmm1
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm8
; AVX2-NEXT:    vmovaps (%r8), %xmm4
; AVX2-NEXT:    vmovaps (%r9), %xmm5
; AVX2-NEXT:    vshufps {{.*#+}} xmm10 = xmm5[1,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} xmm10 = xmm10[0],xmm4[1],xmm10[2,3]
; AVX2-NEXT:    vbroadcastsd %xmm10, %ymm10
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm10[0,1,2,3,4],ymm8[5],ymm10[6,7]
; AVX2-NEXT:    vmovaps (%rcx), %xmm12
; AVX2-NEXT:    vmovaps (%rdx), %xmm13
; AVX2-NEXT:    vinsertps {{.*#+}} xmm10 = zero,xmm13[1],xmm12[1],zero
; AVX2-NEXT:    vmovaps (%rdi), %xmm14
; AVX2-NEXT:    vmovaps (%rsi), %xmm15
; AVX2-NEXT:    vshufps {{.*#+}} xmm11 = xmm15[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm11 = xmm11[0,1],xmm14[2],xmm11[3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm10 = ymm11[0],ymm10[1,2],ymm11[3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm10[0,1,2],ymm8[3,4,5],ymm10[6,7]
; AVX2-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm10 = ymm9[2],ymm3[2],ymm9[3],ymm3[3],ymm9[6],ymm3[6],ymm9[7],ymm3[7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm11 = ymm0[2],ymm2[2],ymm0[3],ymm2[3],ymm0[6],ymm2[6],ymm0[7],ymm2[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[2,2,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm10 = ymm11[0,1,2,3],ymm10[4,5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm11 = ymm7[1,1,2,2,5,5,6,6]
; AVX2-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1],ymm6[2],ymm11[3,4,5],ymm6[6],ymm11[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[2,1,2,3]
; AVX2-NEXT:    vmovaps 16(%rax), %xmm8
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm11[0],ymm8[1],ymm11[2,3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1],ymm10[2,3,4,5],ymm8[6,7]
; AVX2-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm8 = xmm14[3,3],xmm15[3,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm8, %ymm0, %ymm8
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm11 = xmm13[2],xmm12[2],xmm13[3],xmm12[3]
; AVX2-NEXT:    vshufps {{.*#+}} xmm11 = xmm11[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm11[0,1,2,3,4],ymm8[5,6],ymm11[7]
; AVX2-NEXT:    vshufps {{.*#+}} xmm11 = xmm5[2,2,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm11 = xmm4[0,1,2],xmm11[3]
; AVX2-NEXT:    vbroadcastsd 8(%rax), %ymm10
; AVX2-NEXT:    vblendps {{.*#+}} ymm10 = ymm11[0,1,2,3],ymm10[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm11 = ymm8[0,1],ymm10[2,3,4],ymm8[5,6,7]
; AVX2-NEXT:    vbroadcastss %xmm12, %xmm8
; AVX2-NEXT:    vbroadcastss %xmm13, %xmm10
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm8 = xmm10[0],xmm8[0],xmm10[1],xmm8[1]
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm10 = xmm14[0],xmm15[0],xmm14[1],xmm15[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm10 = xmm10[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm10[0,1],ymm8[2,3],ymm10[4,5,6,7]
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm10 = xmm4[0],xmm5[0],xmm4[1],xmm5[1]
; AVX2-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm10
; AVX2-NEXT:    vbroadcastsd %xmm1, %ymm12
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm10 = ymm10[0],ymm12[0],ymm10[2],ymm12[2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm12 = ymm8[0,1,2,3],ymm10[4,5,6],ymm8[7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm8 = ymm9[1,1],ymm3[1,1],ymm9[5,5],ymm3[5,5]
; AVX2-NEXT:    vshufps {{.*#+}} ymm10 = ymm2[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0],ymm0[1],ymm10[2,3,4],ymm0[5],ymm10[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[2,2,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm10[0,1,2,3,4],ymm8[5,6],ymm10[7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm10 = ymm7[0,0,0,0,4,4,4,4]
; AVX2-NEXT:    vshufps {{.*#+}} ymm13 = ymm6[0,1,0,1,4,5,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm10 = ymm13[0],ymm10[1],ymm13[2,3,4],ymm10[5],ymm13[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[2,1,2,3]
; AVX2-NEXT:    vbroadcastsd 16(%rax), %ymm13
; AVX2-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1],ymm13[2,3],ymm10[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm10[0,1,2],ymm8[3,4,5,6],ymm10[7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm9 = ymm3[2],ymm9[2],ymm3[3],ymm9[3],ymm3[6],ymm9[6],ymm3[7],ymm9[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[3,3,3,3]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm10 = ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[6],ymm0[6],ymm2[7],ymm0[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[3,3,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0,1,2],ymm9[3,4,5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm6 = ymm6[3,3],ymm7[3,3],ymm6[7,7],ymm7[7,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm9[0,1,2,3,4],ymm6[5,6],ymm9[7]
; AVX2-NEXT:    vbroadcastsd 24(%rax), %ymm7
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0],ymm6[1,2,3,4,5,6],ymm7[7]
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm2[0],ymm0[1],ymm2[1],ymm0[4],ymm2[4],ymm0[5],ymm2[5]
; AVX2-NEXT:    vbroadcastss 16(%rdx), %ymm2
; AVX2-NEXT:    vshufps {{.*#+}} ymm3 = ymm3[3,1,2,0,7,5,6,4]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1,2,3,4,5],ymm2[6],ymm3[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5],ymm2[6,7]
; AVX2-NEXT:    vshufps {{.*#+}} xmm2 = xmm4[3,3],xmm5[3,3]
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1,2],xmm1[3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX2-NEXT:    vmovaps %ymm6, 192(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-NEXT:    vmovaps %ymm8, 128(%rax)
; AVX2-NEXT:    vmovaps %ymm12, (%rax)
; AVX2-NEXT:    vmovaps %ymm11, 64(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i32_stride7_vf8:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps (%rsi), %ymm2
; AVX2-FP-NEXT:    vmovaps (%rdx), %ymm9
; AVX2-FP-NEXT:    vmovaps (%rcx), %ymm3
; AVX2-FP-NEXT:    vmovaps (%r8), %ymm6
; AVX2-FP-NEXT:    vmovaps (%r9), %ymm7
; AVX2-FP-NEXT:    vmovaps (%rax), %xmm1
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm8
; AVX2-FP-NEXT:    vmovaps (%r8), %xmm4
; AVX2-FP-NEXT:    vmovaps (%r9), %xmm5
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm10 = xmm5[1,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm10 = xmm10[0],xmm4[1],xmm10[2,3]
; AVX2-FP-NEXT:    vbroadcastsd %xmm10, %ymm10
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm10[0,1,2,3,4],ymm8[5],ymm10[6,7]
; AVX2-FP-NEXT:    vmovaps (%rcx), %xmm12
; AVX2-FP-NEXT:    vmovaps (%rdx), %xmm13
; AVX2-FP-NEXT:    vinsertps {{.*#+}} xmm10 = zero,xmm13[1],xmm12[1],zero
; AVX2-FP-NEXT:    vmovaps (%rdi), %xmm14
; AVX2-FP-NEXT:    vmovaps (%rsi), %xmm15
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm11 = xmm15[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm11 = xmm11[0,1],xmm14[2],xmm11[3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm10 = ymm11[0],ymm10[1,2],ymm11[3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm10[0,1,2],ymm8[3,4,5],ymm10[6,7]
; AVX2-FP-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm10 = ymm9[2],ymm3[2],ymm9[3],ymm3[3],ymm9[6],ymm3[6],ymm9[7],ymm3[7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm11 = ymm0[2],ymm2[2],ymm0[3],ymm2[3],ymm0[6],ymm2[6],ymm0[7],ymm2[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[2,2,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm10 = ymm11[0,1,2,3],ymm10[4,5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm11 = ymm7[1,1,2,2,5,5,6,6]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1],ymm6[2],ymm11[3,4,5],ymm6[6],ymm11[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[2,1,2,3]
; AVX2-FP-NEXT:    vmovaps 16(%rax), %xmm8
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm11[0],ymm8[1],ymm11[2,3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1],ymm10[2,3,4,5],ymm8[6,7]
; AVX2-FP-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm8 = xmm14[3,3],xmm15[3,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm8, %ymm0, %ymm8
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm11 = xmm13[2],xmm12[2],xmm13[3],xmm12[3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm11 = xmm11[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm11[0,1,2,3,4],ymm8[5,6],ymm11[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm11 = xmm5[2,2,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm11 = xmm4[0,1,2],xmm11[3]
; AVX2-FP-NEXT:    vbroadcastsd 8(%rax), %ymm10
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm10 = ymm11[0,1,2,3],ymm10[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm11 = ymm8[0,1],ymm10[2,3,4],ymm8[5,6,7]
; AVX2-FP-NEXT:    vbroadcastss %xmm12, %xmm8
; AVX2-FP-NEXT:    vbroadcastss %xmm13, %xmm10
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm8 = xmm10[0],xmm8[0],xmm10[1],xmm8[1]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm10 = xmm14[0],xmm15[0],xmm14[1],xmm15[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm10 = xmm10[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm10[0,1],ymm8[2,3],ymm10[4,5,6,7]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm10 = xmm4[0],xmm5[0],xmm4[1],xmm5[1]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm10
; AVX2-FP-NEXT:    vbroadcastsd %xmm1, %ymm12
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm10 = ymm10[0],ymm12[0],ymm10[2],ymm12[2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm12 = ymm8[0,1,2,3],ymm10[4,5,6],ymm8[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm8 = ymm9[1,1],ymm3[1,1],ymm9[5,5],ymm3[5,5]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm10 = ymm2[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0],ymm0[1],ymm10[2,3,4],ymm0[5],ymm10[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[2,2,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm10[0,1,2,3,4],ymm8[5,6],ymm10[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm10 = ymm7[0,0,0,0,4,4,4,4]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm13 = ymm6[0,1,0,1,4,5,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm10 = ymm13[0],ymm10[1],ymm13[2,3,4],ymm10[5],ymm13[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[2,1,2,3]
; AVX2-FP-NEXT:    vbroadcastsd 16(%rax), %ymm13
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1],ymm13[2,3],ymm10[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm10[0,1,2],ymm8[3,4,5,6],ymm10[7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm9 = ymm3[2],ymm9[2],ymm3[3],ymm9[3],ymm3[6],ymm9[6],ymm3[7],ymm9[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[3,3,3,3]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm10 = ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[6],ymm0[6],ymm2[7],ymm0[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[3,3,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0,1,2],ymm9[3,4,5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm6 = ymm6[3,3],ymm7[3,3],ymm6[7,7],ymm7[7,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm9[0,1,2,3,4],ymm6[5,6],ymm9[7]
; AVX2-FP-NEXT:    vbroadcastsd 24(%rax), %ymm7
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0],ymm6[1,2,3,4,5,6],ymm7[7]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm2[0],ymm0[1],ymm2[1],ymm0[4],ymm2[4],ymm0[5],ymm2[5]
; AVX2-FP-NEXT:    vbroadcastss 16(%rdx), %ymm2
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm3 = ymm3[3,1,2,0,7,5,6,4]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1,2,3,4,5],ymm2[6],ymm3[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5],ymm2[6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm2 = xmm4[3,3],xmm5[3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1,2],xmm1[3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FP-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm6, 192(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm8, 128(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm12, (%rax)
; AVX2-FP-NEXT:    vmovaps %ymm11, 64(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i32_stride7_vf8:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovaps (%rsi), %ymm2
; AVX2-FCP-NEXT:    vmovaps (%rdx), %ymm10
; AVX2-FCP-NEXT:    vmovaps (%rcx), %ymm3
; AVX2-FCP-NEXT:    vmovaps (%r8), %ymm7
; AVX2-FCP-NEXT:    vmovaps (%r9), %ymm8
; AVX2-FCP-NEXT:    vmovaps (%rax), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm6
; AVX2-FCP-NEXT:    vmovaps (%r8), %xmm4
; AVX2-FCP-NEXT:    vmovaps (%r9), %xmm5
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm9 = xmm5[1,1,1,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm9 = xmm9[0],xmm4[1],xmm9[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd %xmm9, %ymm9
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm9[0,1,2,3,4],ymm6[5],ymm9[6,7]
; AVX2-FCP-NEXT:    vmovaps (%rcx), %xmm11
; AVX2-FCP-NEXT:    vmovaps (%rdx), %xmm12
; AVX2-FCP-NEXT:    vinsertps {{.*#+}} xmm9 = zero,xmm12[1],xmm11[1],zero
; AVX2-FCP-NEXT:    vmovaps (%rdi), %xmm13
; AVX2-FCP-NEXT:    vmovaps (%rsi), %xmm14
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm15 = xmm14[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm15 = xmm15[0,1],xmm13[2],xmm15[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm9 = ymm15[0],ymm9[1,2],ymm15[3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm9[0,1,2],ymm6[3,4,5],ymm9[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm6 = ymm10[2],ymm3[2],ymm10[3],ymm3[3],ymm10[6],ymm3[6],ymm10[7],ymm3[7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm9 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[2,2,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm9[0,1,2,3],ymm6[4,5,6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm9 = ymm8[1,1,2,2,5,5,6,6]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1],ymm7[2],ymm9[3,4,5],ymm7[6],ymm9[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[2,1,2,3]
; AVX2-FCP-NEXT:    vmovaps 16(%rax), %xmm15
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm15[1],ymm9[2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm9[0,1],ymm6[2,3,4,5],ymm9[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm6 = ymm2[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0],ymm1[1],ymm6[2,3,4],ymm1[5],ymm6[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[2,2,2,2]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm15 = ymm10[1,1],ymm3[1,1],ymm10[5,5],ymm3[5,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4],ymm15[5,6],ymm6[7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm15 = ymm8[0,0,0,0,4,4,4,4]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm9 = ymm7[0,1,0,1,4,5,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm15[1],ymm9[2,3,4],ymm15[5],ymm9[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[2,1,2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 16(%rax), %ymm15
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1],ymm15[2,3],ymm9[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm9[0,1,2],ymm6[3,4,5,6],ymm9[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm6 = xmm13[3,3],xmm14[3,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm9 = xmm12[2],xmm11[2],xmm12[3],xmm11[3]
; AVX2-FCP-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = [0,1,2,2,0,1,2,2]
; AVX2-FCP-NEXT:    # ymm0 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpermps %ymm9, %ymm0, %ymm9
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm9[0,1,2,3,4],ymm6[5,6],ymm9[7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm9 = xmm5[2,2,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm9 = xmm4[0,1,2],xmm9[3]
; AVX2-FCP-NEXT:    vbroadcastsd 8(%rax), %ymm15
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3],ymm15[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1],ymm9[2,3,4],ymm6[5,6,7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm9 = ymm3[2],ymm10[2],ymm3[3],ymm10[3],ymm3[6],ymm10[6],ymm3[7],ymm10[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[3,3,3,3]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm10 = ymm2[2],ymm1[2],ymm2[3],ymm1[3],ymm2[6],ymm1[6],ymm2[7],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[3,3,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0,1,2],ymm9[3,4,5,6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm7 = ymm7[3,3],ymm8[3,3],ymm7[7,7],ymm8[7,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm7 = ymm9[0,1,2,3,4],ymm7[5,6],ymm9[7]
; AVX2-FCP-NEXT:    vbroadcastsd 24(%rax), %ymm8
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0],ymm7[1,2,3,4,5,6],ymm8[7]
; AVX2-FCP-NEXT:    vbroadcastss %xmm11, %xmm8
; AVX2-FCP-NEXT:    vbroadcastss %xmm12, %xmm9
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm8 = xmm9[0],xmm8[0],xmm9[1],xmm8[1]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm9 = xmm13[0],xmm14[0],xmm13[1],xmm14[1]
; AVX2-FCP-NEXT:    vpermps %ymm9, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm8[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm8 = xmm4[0],xmm5[0],xmm4[1],xmm5[1]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm8, %ymm0, %ymm8
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-FCP-NEXT:    vbroadcastsd %xmm10, %ymm9
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm8 = ymm8[0],ymm9[0],ymm8[2],ymm9[2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm8[4,5,6],ymm0[7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[1],ymm2[1],ymm1[4],ymm2[4],ymm1[5],ymm2[5]
; AVX2-FCP-NEXT:    vbroadcastss 16(%rdx), %ymm2
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm3 = ymm3[3,1,2,0,7,5,6,4]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1,2,3,4,5],ymm2[6],ymm3[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5],ymm2[6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm2 = xmm4[3,3],xmm5[3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0,1,2],xmm10[3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FCP-NEXT:    vmovaps %ymm1, 96(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm7, 192(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm6, 64(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride7_vf8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512-NEXT:    vmovdqa (%r8), %ymm2
; AVX512-NEXT:    vmovdqa (%r10), %ymm3
; AVX512-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm4
; AVX512-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm5
; AVX512-NEXT:    vinserti64x4 $1, (%r9), %zmm2, %zmm2
; AVX512-NEXT:    vpmovsxbd {{.*#+}} ymm0 = [0,7,15,23,31,0,0,0]
; AVX512-NEXT:    vpermi2d %zmm5, %zmm4, %zmm0
; AVX512-NEXT:    vpmovsxbd {{.*#+}} ymm1 = [6,0,0,0,0,23,31,7]
; AVX512-NEXT:    vpermi2d %zmm2, %zmm3, %zmm1
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,0,0,0,8,16,0,0,0,0,1,9,17,0,0]
; AVX512-NEXT:    vpermi2d %zmm3, %zmm2, %zmm6
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,8,16,24,0,0,0,1,9,17,25,0,0,0,2,10]
; AVX512-NEXT:    vpermi2d %zmm5, %zmm4, %zmm7
; AVX512-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512-NEXT:    kmovw %ecx, %k1
; AVX512-NEXT:    vmovdqa32 %zmm6, %zmm7 {%k1}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,2,10,18,0,0,0,0,3,11,19,0,0,0,0]
; AVX512-NEXT:    vpermi2d %zmm3, %zmm2, %zmm6
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [2,10,0,0,0,19,27,3,11,0,0,0,20,28,4,12]
; AVX512-NEXT:    vpermi2d %zmm4, %zmm5, %zmm8
; AVX512-NEXT:    movw $3612, %cx # imm = 0xE1C
; AVX512-NEXT:    kmovw %ecx, %k1
; AVX512-NEXT:    vmovdqa32 %zmm6, %zmm8 {%k1}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,0,5,13,21,29,0,0,0,6,14,22,30,0,0]
; AVX512-NEXT:    vpermi2d %zmm5, %zmm4, %zmm6
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [4,12,20,0,0,0,0,5,13,21,0,0,0,0,6,14]
; AVX512-NEXT:    vpermi2d %zmm3, %zmm2, %zmm4
; AVX512-NEXT:    movw $15480, %cx # imm = 0x3C78
; AVX512-NEXT:    kmovw %ecx, %k1
; AVX512-NEXT:    vmovdqa32 %zmm6, %zmm4 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm4, 128(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm8, 64(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm7, (%rax)
; AVX512-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5,6,7]
; AVX512-NEXT:    vmovdqa %ymm0, 192(%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i32_stride7_vf8:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-FCP-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512-FCP-NEXT:    vmovdqa (%r8), %ymm2
; AVX512-FCP-NEXT:    vmovdqa (%r10), %ymm3
; AVX512-FCP-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm4
; AVX512-FCP-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm5
; AVX512-FCP-NEXT:    vinserti64x4 $1, (%r9), %zmm2, %zmm2
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm0 = [0,7,15,23,31,0,0,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm5, %zmm4, %zmm0
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm1 = [6,0,0,0,0,23,31,7]
; AVX512-FCP-NEXT:    vpermi2d %zmm2, %zmm3, %zmm1
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,0,0,0,8,16,0,0,0,0,1,9,17,0,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm6
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,8,16,24,0,0,0,1,9,17,25,0,0,0,2,10]
; AVX512-FCP-NEXT:    vpermi2d %zmm5, %zmm4, %zmm7
; AVX512-FCP-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512-FCP-NEXT:    kmovw %ecx, %k1
; AVX512-FCP-NEXT:    vmovdqa32 %zmm6, %zmm7 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,2,10,18,0,0,0,0,3,11,19,0,0,0,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm6
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [2,10,0,0,0,19,27,3,11,0,0,0,20,28,4,12]
; AVX512-FCP-NEXT:    vpermi2d %zmm4, %zmm5, %zmm8
; AVX512-FCP-NEXT:    movw $3612, %cx # imm = 0xE1C
; AVX512-FCP-NEXT:    kmovw %ecx, %k1
; AVX512-FCP-NEXT:    vmovdqa32 %zmm6, %zmm8 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,0,5,13,21,29,0,0,0,6,14,22,30,0,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm5, %zmm4, %zmm6
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [4,12,20,0,0,0,0,5,13,21,0,0,0,0,6,14]
; AVX512-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm4
; AVX512-FCP-NEXT:    movw $15480, %cx # imm = 0x3C78
; AVX512-FCP-NEXT:    kmovw %ecx, %k1
; AVX512-FCP-NEXT:    vmovdqa32 %zmm6, %zmm4 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, 128(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, 64(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, (%rax)
; AVX512-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5,6,7]
; AVX512-FCP-NEXT:    vmovdqa %ymm0, 192(%rax)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i32_stride7_vf8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512DQ-NEXT:    vmovdqa (%r8), %ymm2
; AVX512DQ-NEXT:    vmovdqa (%r10), %ymm3
; AVX512DQ-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm4
; AVX512DQ-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm5
; AVX512DQ-NEXT:    vinserti64x4 $1, (%r9), %zmm2, %zmm2
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} ymm0 = [0,7,15,23,31,0,0,0]
; AVX512DQ-NEXT:    vpermi2d %zmm5, %zmm4, %zmm0
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} ymm1 = [6,0,0,0,0,23,31,7]
; AVX512DQ-NEXT:    vpermi2d %zmm2, %zmm3, %zmm1
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,0,0,0,8,16,0,0,0,0,1,9,17,0,0]
; AVX512DQ-NEXT:    vpermi2d %zmm3, %zmm2, %zmm6
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,8,16,24,0,0,0,1,9,17,25,0,0,0,2,10]
; AVX512DQ-NEXT:    vpermi2d %zmm5, %zmm4, %zmm7
; AVX512DQ-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512DQ-NEXT:    kmovw %ecx, %k1
; AVX512DQ-NEXT:    vmovdqa32 %zmm6, %zmm7 {%k1}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,2,10,18,0,0,0,0,3,11,19,0,0,0,0]
; AVX512DQ-NEXT:    vpermi2d %zmm3, %zmm2, %zmm6
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [2,10,0,0,0,19,27,3,11,0,0,0,20,28,4,12]
; AVX512DQ-NEXT:    vpermi2d %zmm4, %zmm5, %zmm8
; AVX512DQ-NEXT:    movw $3612, %cx # imm = 0xE1C
; AVX512DQ-NEXT:    kmovw %ecx, %k1
; AVX512DQ-NEXT:    vmovdqa32 %zmm6, %zmm8 {%k1}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,0,5,13,21,29,0,0,0,6,14,22,30,0,0]
; AVX512DQ-NEXT:    vpermi2d %zmm5, %zmm4, %zmm6
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [4,12,20,0,0,0,0,5,13,21,0,0,0,0,6,14]
; AVX512DQ-NEXT:    vpermi2d %zmm3, %zmm2, %zmm4
; AVX512DQ-NEXT:    movw $15480, %cx # imm = 0x3C78
; AVX512DQ-NEXT:    kmovw %ecx, %k1
; AVX512DQ-NEXT:    vmovdqa32 %zmm6, %zmm4 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, 128(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, 64(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, (%rax)
; AVX512DQ-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5,6,7]
; AVX512DQ-NEXT:    vmovdqa %ymm0, 192(%rax)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i32_stride7_vf8:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512DQ-FCP-NEXT:    vmovdqa (%r8), %ymm2
; AVX512DQ-FCP-NEXT:    vmovdqa (%r10), %ymm3
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm4
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm5
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, (%r9), %zmm2, %zmm2
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm0 = [0,7,15,23,31,0,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm5, %zmm4, %zmm0
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm1 = [6,0,0,0,0,23,31,7]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm2, %zmm3, %zmm1
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,0,0,0,8,16,0,0,0,0,1,9,17,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm6
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,8,16,24,0,0,0,1,9,17,25,0,0,0,2,10]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm5, %zmm4, %zmm7
; AVX512DQ-FCP-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512DQ-FCP-NEXT:    kmovw %ecx, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm6, %zmm7 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,2,10,18,0,0,0,0,3,11,19,0,0,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm6
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [2,10,0,0,0,19,27,3,11,0,0,0,20,28,4,12]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm4, %zmm5, %zmm8
; AVX512DQ-FCP-NEXT:    movw $3612, %cx # imm = 0xE1C
; AVX512DQ-FCP-NEXT:    kmovw %ecx, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm6, %zmm8 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,0,5,13,21,29,0,0,0,6,14,22,30,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm5, %zmm4, %zmm6
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [4,12,20,0,0,0,0,5,13,21,0,0,0,0,6,14]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm4
; AVX512DQ-FCP-NEXT:    movw $15480, %cx # imm = 0x3C78
; AVX512DQ-FCP-NEXT:    kmovw %ecx, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm6, %zmm4 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, 128(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, 64(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, (%rax)
; AVX512DQ-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5,6,7]
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm0, 192(%rax)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride7_vf8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512BW-NEXT:    vmovdqa (%r8), %ymm2
; AVX512BW-NEXT:    vmovdqa (%r10), %ymm3
; AVX512BW-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm4
; AVX512BW-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm5
; AVX512BW-NEXT:    vinserti64x4 $1, (%r9), %zmm2, %zmm2
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} ymm0 = [0,7,15,23,31,0,0,0]
; AVX512BW-NEXT:    vpermi2d %zmm5, %zmm4, %zmm0
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} ymm1 = [6,0,0,0,0,23,31,7]
; AVX512BW-NEXT:    vpermi2d %zmm2, %zmm3, %zmm1
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,0,0,0,8,16,0,0,0,0,1,9,17,0,0]
; AVX512BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm6
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,8,16,24,0,0,0,1,9,17,25,0,0,0,2,10]
; AVX512BW-NEXT:    vpermi2d %zmm5, %zmm4, %zmm7
; AVX512BW-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqa32 %zmm6, %zmm7 {%k1}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,2,10,18,0,0,0,0,3,11,19,0,0,0,0]
; AVX512BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm6
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [2,10,0,0,0,19,27,3,11,0,0,0,20,28,4,12]
; AVX512BW-NEXT:    vpermi2d %zmm4, %zmm5, %zmm8
; AVX512BW-NEXT:    movw $3612, %cx # imm = 0xE1C
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqa32 %zmm6, %zmm8 {%k1}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,0,5,13,21,29,0,0,0,6,14,22,30,0,0]
; AVX512BW-NEXT:    vpermi2d %zmm5, %zmm4, %zmm6
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [4,12,20,0,0,0,0,5,13,21,0,0,0,0,6,14]
; AVX512BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm4
; AVX512BW-NEXT:    movw $15480, %cx # imm = 0x3C78
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqa32 %zmm6, %zmm4 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm4, 128(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm8, 64(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, (%rax)
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5,6,7]
; AVX512BW-NEXT:    vmovdqa %ymm0, 192(%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i32_stride7_vf8:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-FCP-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512BW-FCP-NEXT:    vmovdqa (%r8), %ymm2
; AVX512BW-FCP-NEXT:    vmovdqa (%r10), %ymm3
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm4
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm5
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, (%r9), %zmm2, %zmm2
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm0 = [0,7,15,23,31,0,0,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm5, %zmm4, %zmm0
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm1 = [6,0,0,0,0,23,31,7]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm2, %zmm3, %zmm1
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,0,0,0,8,16,0,0,0,0,1,9,17,0,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm6
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,8,16,24,0,0,0,1,9,17,25,0,0,0,2,10]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm5, %zmm4, %zmm7
; AVX512BW-FCP-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512BW-FCP-NEXT:    kmovd %ecx, %k1
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm6, %zmm7 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,2,10,18,0,0,0,0,3,11,19,0,0,0,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm6
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [2,10,0,0,0,19,27,3,11,0,0,0,20,28,4,12]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm4, %zmm5, %zmm8
; AVX512BW-FCP-NEXT:    movw $3612, %cx # imm = 0xE1C
; AVX512BW-FCP-NEXT:    kmovd %ecx, %k1
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm6, %zmm8 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,0,5,13,21,29,0,0,0,6,14,22,30,0,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm5, %zmm4, %zmm6
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [4,12,20,0,0,0,0,5,13,21,0,0,0,0,6,14]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm4
; AVX512BW-FCP-NEXT:    movw $15480, %cx # imm = 0x3C78
; AVX512BW-FCP-NEXT:    kmovd %ecx, %k1
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm6, %zmm4 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, 128(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, 64(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, (%rax)
; AVX512BW-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5,6,7]
; AVX512BW-FCP-NEXT:    vmovdqa %ymm0, 192(%rax)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i32_stride7_vf8:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-BW-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512DQ-BW-NEXT:    vmovdqa (%r8), %ymm2
; AVX512DQ-BW-NEXT:    vmovdqa (%r10), %ymm3
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm4
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm5
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, (%r9), %zmm2, %zmm2
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} ymm0 = [0,7,15,23,31,0,0,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm5, %zmm4, %zmm0
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} ymm1 = [6,0,0,0,0,23,31,7]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm2, %zmm3, %zmm1
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,0,0,0,8,16,0,0,0,0,1,9,17,0,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm6
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,8,16,24,0,0,0,1,9,17,25,0,0,0,2,10]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm5, %zmm4, %zmm7
; AVX512DQ-BW-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm6, %zmm7 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,2,10,18,0,0,0,0,3,11,19,0,0,0,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm6
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [2,10,0,0,0,19,27,3,11,0,0,0,20,28,4,12]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm4, %zmm5, %zmm8
; AVX512DQ-BW-NEXT:    movw $3612, %cx # imm = 0xE1C
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm6, %zmm8 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,0,5,13,21,29,0,0,0,6,14,22,30,0,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm5, %zmm4, %zmm6
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [4,12,20,0,0,0,0,5,13,21,0,0,0,0,6,14]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm4
; AVX512DQ-BW-NEXT:    movw $15480, %cx # imm = 0x3C78
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm6, %zmm4 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, 128(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, 64(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, (%rax)
; AVX512DQ-BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5,6,7]
; AVX512DQ-BW-NEXT:    vmovdqa %ymm0, 192(%rax)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i32_stride7_vf8:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%r8), %ymm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%r10), %ymm3
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, (%r9), %zmm2, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm0 = [0,7,15,23,31,0,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm5, %zmm4, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm1 = [6,0,0,0,0,23,31,7]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm2, %zmm3, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,0,0,0,8,16,0,0,0,0,1,9,17,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,8,16,24,0,0,0,1,9,17,25,0,0,0,2,10]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm5, %zmm4, %zmm7
; AVX512DQ-BW-FCP-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512DQ-BW-FCP-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm6, %zmm7 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,2,10,18,0,0,0,0,3,11,19,0,0,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [2,10,0,0,0,19,27,3,11,0,0,0,20,28,4,12]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm4, %zmm5, %zmm8
; AVX512DQ-BW-FCP-NEXT:    movw $3612, %cx # imm = 0xE1C
; AVX512DQ-BW-FCP-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm6, %zmm8 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,0,5,13,21,29,0,0,0,6,14,22,30,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm5, %zmm4, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [4,12,20,0,0,0,0,5,13,21,0,0,0,0,6,14]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm4
; AVX512DQ-BW-FCP-NEXT:    movw $15480, %cx # imm = 0x3C78
; AVX512DQ-BW-FCP-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm6, %zmm4 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, 128(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, 64(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, (%rax)
; AVX512DQ-BW-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %ymm0, 192(%rax)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <8 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <8 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <8 x i32>, ptr %in.vecptr2, align 64
  %in.vec3 = load <8 x i32>, ptr %in.vecptr3, align 64
  %in.vec4 = load <8 x i32>, ptr %in.vecptr4, align 64
  %in.vec5 = load <8 x i32>, ptr %in.vecptr5, align 64
  %in.vec6 = load <8 x i32>, ptr %in.vecptr6, align 64
  %1 = shufflevector <8 x i32> %in.vec0, <8 x i32> %in.vec1, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %2 = shufflevector <8 x i32> %in.vec2, <8 x i32> %in.vec3, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %3 = shufflevector <8 x i32> %in.vec4, <8 x i32> %in.vec5, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = shufflevector <16 x i32> %1, <16 x i32> %2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %5 = shufflevector <8 x i32> %in.vec6, <8 x i32> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <16 x i32> %3, <16 x i32> %5, <24 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %7 = shufflevector <24 x i32> %6, <24 x i32> poison, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %8 = shufflevector <32 x i32> %4, <32 x i32> %7, <56 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55>
  %interleaved.vec = shufflevector <56 x i32> %8, <56 x i32> poison, <56 x i32> <i32 0, i32 8, i32 16, i32 24, i32 32, i32 40, i32 48, i32 1, i32 9, i32 17, i32 25, i32 33, i32 41, i32 49, i32 2, i32 10, i32 18, i32 26, i32 34, i32 42, i32 50, i32 3, i32 11, i32 19, i32 27, i32 35, i32 43, i32 51, i32 4, i32 12, i32 20, i32 28, i32 36, i32 44, i32 52, i32 5, i32 13, i32 21, i32 29, i32 37, i32 45, i32 53, i32 6, i32 14, i32 22, i32 30, i32 38, i32 46, i32 54, i32 7, i32 15, i32 23, i32 31, i32 39, i32 47, i32 55>
  store <56 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride7_vf16(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride7_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $520, %rsp # imm = 0x208
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa (%rdi), %xmm10
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsi), %xmm4
; SSE-NEXT:    movdqa 16(%rsi), %xmm6
; SSE-NEXT:    movaps (%rdx), %xmm5
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 16(%rdx), %xmm9
; SSE-NEXT:    movdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rcx), %xmm8
; SSE-NEXT:    movaps 16(%rcx), %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%r8), %xmm15
; SSE-NEXT:    movaps 16(%r8), %xmm14
; SSE-NEXT:    movaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%r9), %xmm13
; SSE-NEXT:    movdqa 16(%r9), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rax), %xmm11
; SSE-NEXT:    movaps %xmm15, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm8[1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm4[1,1,1,1]
; SSE-NEXT:    movss {{.*#+}} xmm5 = xmm1[0],xmm5[1,2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm4[2],xmm0[3],xmm4[3]
; SSE-NEXT:    movdqa %xmm4, %xmm12
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm11[1,1,1,1]
; SSE-NEXT:    movdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm13[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm1[0],xmm5[1],xmm1[1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm5 = xmm5[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[1,1,1,1]
; SSE-NEXT:    movdqa %xmm6, %xmm9
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm6[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movaps %xmm14, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 16(%rax), %xmm10
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm10[1,1,1,1]
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa 16(%rdi), %xmm4
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm6[2],xmm0[3],xmm6[3]
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 32(%rsi), %xmm1
; SSE-NEXT:    movaps 32(%rdx), %xmm2
; SSE-NEXT:    movaps %xmm2, (%rsp) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; SSE-NEXT:    movdqa %xmm1, %xmm6
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE-NEXT:    movaps 32(%rcx), %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%r8), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 32(%r9), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 32(%rax), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa 32(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm6[2],xmm0[3],xmm6[3]
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 48(%rsi), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 48(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm1[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm0[0],xmm5[1],xmm0[1]
; SSE-NEXT:    movaps 48(%rcx), %xmm3
; SSE-NEXT:    movaps 48(%r8), %xmm0
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm3[1,1]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%rdi), %xmm2
; SSE-NEXT:    movaps 48(%rax), %xmm1
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm1[0,3]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%r9), %xmm7
; SSE-NEXT:    movaps %xmm7, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm1[1,1]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,1],xmm1[2,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm7[3,3]
; SSE-NEXT:    movaps %xmm0, %xmm2
; SSE-NEXT:    unpcklps {{.*#+}} xmm2 = xmm2[0],xmm7[0],xmm2[1],xmm7[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm0[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; SSE-NEXT:    movaps %xmm14, %xmm0
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm8[0],xmm0[1],xmm8[1]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm12[0],xmm3[1],xmm12[1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[0,1],xmm2[1,3]
; SSE-NEXT:    movaps %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm15, %xmm5
; SSE-NEXT:    movdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm13[0],xmm5[1],xmm13[1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm11[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm15 = xmm15[2],xmm13[2],xmm15[3],xmm13[3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm14 = xmm14[2],xmm8[2],xmm14[3],xmm8[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm14 = xmm14[0],xmm15[0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm5[0]
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm4, %xmm13
; SSE-NEXT:    punpckldq {{.*#+}} xmm13 = xmm13[0],xmm9[0],xmm13[1],xmm9[1]
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[0,1],xmm0[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm10[0,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; SSE-NEXT:    movaps %xmm12, %xmm11
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm11 = xmm11[0],xmm3[0],xmm11[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[0,1],xmm4[2,0]
; SSE-NEXT:    movaps %xmm5, %xmm10
; SSE-NEXT:    unpckhps {{.*#+}} xmm10 = xmm10[2],xmm2[2],xmm10[3],xmm2[3]
; SSE-NEXT:    movaps %xmm12, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm10 = xmm10[0],xmm0[0]
; SSE-NEXT:    movdqa (%rsp), %xmm5 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm9, %xmm15
; SSE-NEXT:    punpckldq {{.*#+}} xmm15 = xmm15[0],xmm6[0],xmm15[1],xmm6[1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm15 = xmm15[0],xmm0[0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm9[1,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    movaps %xmm8, %xmm6
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm6 = xmm6[0],xmm3[0],xmm6[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm8, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm5 = xmm5[2],xmm2[2],xmm5[3],xmm2[3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm5 = xmm5[0],xmm0[0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    unpckhps {{.*#+}} xmm3 = xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps $36, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[0,1],mem[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    unpckhps {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm1[0,1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm7[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Folded Reload
; SSE-NEXT:    # xmm7 = xmm7[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,3],xmm7[2,0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm0[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm7[0],xmm2[1,2,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm0, %xmm7
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Folded Reload
; SSE-NEXT:    # xmm7 = xmm7[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3],xmm7[2,0]
; SSE-NEXT:    pshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Folded Reload
; SSE-NEXT:    # xmm7 = mem[3,3,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm0 = xmm7[0],xmm0[1,2,3]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Folded Reload
; SSE-NEXT:    # xmm7 = xmm7[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,3],xmm7[2,0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm0[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm7[0],xmm2[1,2,3]
; SSE-NEXT:    movdqa %xmm0, %xmm7
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Folded Reload
; SSE-NEXT:    # xmm7 = xmm7[3,3],mem[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,3],xmm7[2,0]
; SSE-NEXT:    pshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Folded Reload
; SSE-NEXT:    # xmm7 = mem[3,3,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm12 = xmm7[0],xmm12[1,2,3]
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,3],xmm0[2,0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm0[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm9 = xmm7[0],xmm9[1,2,3]
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,3],xmm0[2,0]
; SSE-NEXT:    pshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Folded Reload
; SSE-NEXT:    # xmm7 = mem[3,3,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm8 = xmm7[0],xmm8[1,2,3]
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movaps %xmm1, 416(%rax)
; SSE-NEXT:    movaps %xmm3, 400(%rax)
; SSE-NEXT:    movaps %xmm4, 384(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%rax)
; SSE-NEXT:    movdqa %xmm5, 288(%rax)
; SSE-NEXT:    movaps %xmm6, 240(%rax)
; SSE-NEXT:    movdqa %xmm15, 224(%rax)
; SSE-NEXT:    movaps %xmm10, 176(%rax)
; SSE-NEXT:    movaps %xmm11, 128(%rax)
; SSE-NEXT:    movaps %xmm13, 112(%rax)
; SSE-NEXT:    movaps %xmm14, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%rax)
; SSE-NEXT:    movaps %xmm8, 320(%rax)
; SSE-NEXT:    movaps %xmm9, 304(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rax)
; SSE-NEXT:    movaps %xmm12, 208(%rax)
; SSE-NEXT:    movaps %xmm2, 192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    addq $520, %rsp # imm = 0x208
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i32_stride7_vf16:
; AVX:       # %bb.0:
; AVX-NEXT:    subq $456, %rsp # imm = 0x1C8
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX-NEXT:    vmovaps 32(%rdi), %ymm5
; AVX-NEXT:    vmovaps 32(%rsi), %ymm6
; AVX-NEXT:    vmovaps 32(%rdx), %ymm4
; AVX-NEXT:    vmovaps 32(%rcx), %ymm7
; AVX-NEXT:    vmovaps 32(%r8), %ymm0
; AVX-NEXT:    vmovaps 32(%r9), %ymm1
; AVX-NEXT:    vmovaps 32(%rax), %ymm2
; AVX-NEXT:    vunpckhps {{.*#+}} ymm3 = ymm4[2],ymm7[2],ymm4[3],ymm7[3],ymm4[6],ymm7[6],ymm4[7],ymm7[7]
; AVX-NEXT:    vmovaps %ymm7, %ymm8
; AVX-NEXT:    vmovaps %ymm4, %ymm7
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm4 = ymm6[1],ymm5[1],ymm6[3],ymm5[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm4 = ymm5[0,1],ymm4[2,0],ymm5[4,5],ymm4[6,4]
; AVX-NEXT:    vmovaps %ymm5, %ymm9
; AVX-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm4[2,3],ymm3[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm0[6,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm1[2,3,2,3]
; AVX-NEXT:    vshufps {{.*#+}} ymm4 = ymm4[1,1,2,2,5,5,6,6]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0],ymm3[1,2,3,4,5,6],ymm4[7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm2[2,3],ymm3[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2,3,4],ymm4[5],ymm3[6,7]
; AVX-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 32(%r9), %xmm10
; AVX-NEXT:    vmovaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 32(%r8), %xmm11
; AVX-NEXT:    vmovaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 32(%rdi), %xmm4
; AVX-NEXT:    vmovaps 32(%rsi), %xmm12
; AVX-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm12[0],xmm4[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[2,0],xmm4[2,1]
; AVX-NEXT:    vmovaps %xmm4, %xmm13
; AVX-NEXT:    vmovaps %xmm4, (%rsp) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm3, %ymm3
; AVX-NEXT:    vmovaps 32(%rcx), %xmm5
; AVX-NEXT:    vmovaps 32(%rdx), %xmm14
; AVX-NEXT:    vunpcklps {{.*#+}} xmm4 = xmm14[0],xmm5[0],xmm14[1],xmm5[1]
; AVX-NEXT:    vmovaps %xmm14, %xmm15
; AVX-NEXT:    vmovaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps %xmm5, %xmm14
; AVX-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} xmm4 = xmm4[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm4[2,3],ymm3[4,5,6,7]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm4 = xmm11[0],xmm10[0],xmm11[1],xmm10[1]
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm4
; AVX-NEXT:    vmovaps 32(%rax), %xmm5
; AVX-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm4[0],ymm5[0],ymm4[2],ymm5[2]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm4[4,5,6],ymm3[7]
; AVX-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} xmm3 = xmm10[1,1],xmm11[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm3, %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4],ymm5[5],ymm3[6,7]
; AVX-NEXT:    vmovaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm4 = xmm13[1],xmm12[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm4 = xmm12[1,1],xmm4[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm4, %ymm4
; AVX-NEXT:    vinsertps {{.*#+}} xmm5 = zero,xmm15[1],xmm14[1],zero
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm5[1,2],ymm4[3,4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1,2],ymm3[3,4,5],ymm4[6,7]
; AVX-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm3 = ymm6[1,1],ymm9[1,1],ymm6[5,5],ymm9[5,5]
; AVX-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3,2,3]
; AVX-NEXT:    vshufps {{.*#+}} ymm4 = ymm7[1,1],ymm8[1,1],ymm7[5,5],ymm8[5,5]
; AVX-NEXT:    vmovaps %ymm8, %ymm13
; AVX-NEXT:    vmovaps %ymm7, %ymm11
; AVX-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4],ymm4[5,6],ymm3[7]
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[2,0],ymm0[2,1],ymm1[6,4],ymm0[6,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm2[2,3],ymm0[2,3]
; AVX-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm3[3,4,5,6],ymm0[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps (%rdi), %xmm5
; AVX-NEXT:    vmovaps (%rsi), %xmm14
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm5[1],xmm14[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm14[1,1],xmm0[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovaps (%rcx), %xmm2
; AVX-NEXT:    vmovaps (%rdx), %xmm12
; AVX-NEXT:    vinsertps {{.*#+}} xmm1 = zero,xmm12[1],xmm2[1],zero
; AVX-NEXT:    vmovaps %xmm2, %xmm7
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2],ymm0[3,4,5,6,7]
; AVX-NEXT:    vmovaps (%r9), %xmm3
; AVX-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps (%r8), %xmm4
; AVX-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm3[1,1],xmm4[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm1, %ymm1
; AVX-NEXT:    vmovaps (%rax), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4],ymm2[5],ymm1[6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4,5],ymm0[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm2[0],ymm0[2],ymm2[2]
; AVX-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm14[0],xmm5[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[2,0],xmm5[2,1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm1, %ymm1
; AVX-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm12[0],xmm7[0],xmm12[1],xmm7[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6],ymm1[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps (%rdi), %ymm10
; AVX-NEXT:    vmovaps (%rsi), %ymm9
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm9[1,1],ymm10[1,1],ymm9[5,5],ymm10[5,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX-NEXT:    vmovaps (%rdx), %ymm8
; AVX-NEXT:    vmovaps (%rcx), %ymm7
; AVX-NEXT:    vshufps {{.*#+}} ymm2 = ymm8[1,1],ymm7[1,1],ymm8[5,5],ymm7[5,5]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm0[0,1,2,3,4],ymm2[5,6],ymm0[7]
; AVX-NEXT:    vmovaps (%r8), %ymm15
; AVX-NEXT:    vmovaps (%r9), %ymm1
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm15[0],ymm1[2],ymm15[2]
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm2[2,0],ymm15[2,1],ymm2[6,4],ymm15[6,5]
; AVX-NEXT:    vmovaps (%rax), %ymm5
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm5[2,3],ymm0[2,3]
; AVX-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm2[0],ymm0[2],ymm2[3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm3[3,4,5,6],ymm0[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm9[1],ymm10[1],ymm9[3],ymm10[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,1,2,0,4,5,6,4]
; AVX-NEXT:    vunpckhps {{.*#+}} ymm2 = ymm8[2],ymm7[2],ymm8[3],ymm7[3],ymm8[6],ymm7[6],ymm8[7],ymm7[7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm15[1],ymm1[1],ymm15[3],ymm1[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm2 = ymm1[1,1],ymm2[0,2],ymm1[5,5],ymm2[4,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3,2,3]
; AVX-NEXT:    vmovaps 16(%rax), %xmm3
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2,3,4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3,4,5],ymm2[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm13[3,3],ymm11[3,3],ymm13[7,7],ymm11[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX-NEXT:    vshufps {{.*#+}} ymm2 = ymm11[3,3],ymm6[3,3],ymm11[7,7],ymm6[7,7]
; AVX-NEXT:    vextractf128 $1, %ymm2, %xmm2
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2],ymm0[3,4,5,6,7]
; AVX-NEXT:    vbroadcastss 60(%r8), %ymm2
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm2[5],ymm0[6,7]
; AVX-NEXT:    vbroadcastss 60(%r9), %ymm2
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm2[6,7]
; AVX-NEXT:    vbroadcastsd 56(%rax), %ymm2
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0],ymm0[1,2,3,4,5,6],ymm2[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm7[3,3],ymm8[3,3],ymm7[7,7],ymm8[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX-NEXT:    vshufps {{.*#+}} ymm2 = ymm10[3,3],ymm9[3,3],ymm10[7,7],ymm9[7,7]
; AVX-NEXT:    vextractf128 $1, %ymm2, %xmm2
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2],ymm0[3,4,5,6,7]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm15[3,3],ymm1[3,3],ymm15[7,7],ymm1[7,7]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm5[2,3],ymm1[1,2],ymm5[6,7],ymm1[5,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,2,3,1,4,6,7,5]
; AVX-NEXT:    vblendps {{.*#+}} ymm15 = ymm1[0],ymm0[1,2,3,4],ymm1[5,6,7]
; AVX-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = xmm2[2],mem[2],xmm2[3],mem[3]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5,6],ymm1[7]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm6[2,2,2,2]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX-NEXT:    vblendps {{.*#+}} xmm1 = xmm4[0,1,2],xmm1[3]
; AVX-NEXT:    vbroadcastsd 40(%rax), %ymm2
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4],ymm0[5,6,7]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[3,3],xmm14[3,3]
; AVX-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm12, %xmm2 # 16-byte Folded Reload
; AVX-NEXT:    # xmm2 = xmm12[2],mem[2],xmm12[3],mem[3]
; AVX-NEXT:    vinsertf128 $1, %xmm12, %ymm2, %ymm2
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3,4],ymm1[5,6],ymm2[7]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX-NEXT:    vshufps {{.*#+}} xmm2 = xmm14[2,2,2,2]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; AVX-NEXT:    vblendps {{.*#+}} xmm2 = xmm12[0,1,2],xmm2[3]
; AVX-NEXT:    vbroadcastsd 8(%rax), %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3,4],ymm1[5,6,7]
; AVX-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm2 # 32-byte Folded Reload
; AVX-NEXT:    # ymm2 = ymm11[0],mem[0],ymm11[1],mem[1],ymm11[4],mem[4],ymm11[5],mem[5]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm3[0],ymm13[0],ymm3[2],ymm13[2]
; AVX-NEXT:    vshufps {{.*#+}} ymm3 = ymm13[3,1],ymm3[0,2],ymm13[7,5],ymm3[4,6]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1,2,3],ymm2[4,5],ymm3[6,7]
; AVX-NEXT:    vshufps {{.*#+}} xmm3 = xmm4[3,3],xmm6[3,3]
; AVX-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX-NEXT:    # xmm3 = xmm3[0,1,2],mem[3]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm3[1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vunpcklps {{.*#+}} ymm3 = ymm10[0],ymm9[0],ymm10[1],ymm9[1],ymm10[4],ymm9[4],ymm10[5],ymm9[5]
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm8[0],ymm7[0],ymm8[2],ymm7[2]
; AVX-NEXT:    vshufps {{.*#+}} ymm4 = ymm7[3,1],ymm5[0,2],ymm7[7,5],ymm5[4,6]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5],ymm4[6,7]
; AVX-NEXT:    vshufps {{.*#+}} xmm4 = xmm12[3,3],xmm14[3,3]
; AVX-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4, %xmm4 # 16-byte Folded Reload
; AVX-NEXT:    # xmm4 = xmm4[0,1,2],mem[3]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm4[1,2,3],ymm3[4,5,6,7]
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX-NEXT:    vmovaps %ymm3, 96(%rax)
; AVX-NEXT:    vmovaps %ymm2, 320(%rax)
; AVX-NEXT:    vmovaps %ymm1, 64(%rax)
; AVX-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX-NEXT:    vmovaps %ymm15, 192(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, (%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX-NEXT:    addq $456, %rsp # imm = 0x1C8
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i32_stride7_vf16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    subq $488, %rsp # imm = 0x1E8
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    vmovaps (%rax), %xmm6
; AVX2-NEXT:    vmovaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 32(%rax), %xmm0
; AVX2-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; AVX2-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-NEXT:    vmovaps (%r8), %xmm8
; AVX2-NEXT:    vmovaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 32(%r8), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps (%r9), %xmm9
; AVX2-NEXT:    vmovaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 32(%r9), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2,3]
; AVX2-NEXT:    vbroadcastsd %xmm1, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5],ymm1[6,7]
; AVX2-NEXT:    vmovaps (%rcx), %xmm3
; AVX2-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 32(%rcx), %xmm12
; AVX2-NEXT:    vmovaps 32(%rdx), %xmm10
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm10[1],xmm12[1],zero
; AVX2-NEXT:    vmovaps (%rdi), %xmm11
; AVX2-NEXT:    vmovaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 32(%rdi), %xmm7
; AVX2-NEXT:    vmovaps (%rsi), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 32(%rsi), %xmm5
; AVX2-NEXT:    vshufps {{.*#+}} xmm4 = xmm5[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm4 = xmm4[0,1],xmm7[2],xmm4[3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm4[0],ymm2[1,2],ymm4[3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2],ymm0[3,4,5],ymm2[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm0
; AVX2-NEXT:    vshufps {{.*#+}} xmm2 = xmm9[1,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0],xmm8[1],xmm2[2,3]
; AVX2-NEXT:    vbroadcastsd %xmm2, %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3,4],ymm0[5],ymm2[6,7]
; AVX2-NEXT:    vshufps {{.*#+}} xmm2 = xmm1[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0,1],xmm11[2],xmm2[3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-NEXT:    vmovaps (%rdx), %xmm13
; AVX2-NEXT:    vinsertps {{.*#+}} xmm4 = zero,xmm13[1],xmm3[1],zero
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm4[1,2],ymm2[3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2],ymm0[3,4,5],ymm2[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovaps (%rdx), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%rcx), %ymm14
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm2 = ymm1[2],ymm14[2],ymm1[3],ymm14[3],ymm1[6],ymm14[6],ymm1[7],ymm14[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vmovaps (%r8), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%r9), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[1,1,2,2,5,5,6,6]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm1[2],ymm2[3,4,5],ymm1[6],ymm2[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[2,1,2,3]
; AVX2-NEXT:    vmovaps 16(%rax), %xmm4
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm4[1],ymm2[2,3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3,4,5],ymm2[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm11
; AVX2-NEXT:    vmovaps 32(%rsi), %ymm6
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm11[2],ymm6[2],ymm11[3],ymm6[3],ymm11[6],ymm6[6],ymm11[7],ymm6[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm9 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovaps 32(%rdx), %ymm4
; AVX2-NEXT:    vmovaps 32(%rcx), %ymm8
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm4[2],ymm8[2],ymm4[3],ymm8[3],ymm4[6],ymm8[6],ymm4[7],ymm8[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovaps 32(%r8), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm9[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovaps 32(%r9), %ymm9
; AVX2-NEXT:    vshufps {{.*#+}} ymm15 = ymm9[1,2,2,3,5,6,6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[2,2,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm15[0],ymm1[1,2,3,4,5,6],ymm15[7]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = mem[2,3],ymm0[2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3,4],ymm0[5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm8[2],ymm4[2],ymm8[3],ymm4[3],ymm8[6],ymm4[6],ymm8[7],ymm4[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm6[2],ymm11[2],ymm6[3],ymm11[3],ymm6[6],ymm11[6],ymm6[7],ymm11[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX2-NEXT:    vbroadcastss 60(%r8), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vbroadcastss 60(%r9), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vbroadcastsd 56(%rax), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4,5,6],ymm1[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm7[3,3],xmm5[3,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm10[2],xmm12[2],xmm10[3],xmm12[3]
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm1[0,1,2,3,4],ymm0[5,6],ymm1[7]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm2[2,2,2,2]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm0[0,1,2],xmm1[3]
; AVX2-NEXT:    vbroadcastsd 40(%rax), %ymm15
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm15[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3,4],ymm3[5,6,7]
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vbroadcastss %xmm12, %xmm3
; AVX2-NEXT:    vbroadcastss %xmm10, %xmm1
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm1[0],xmm3[0],xmm1[1],xmm3[1]
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm7[0],xmm5[0],xmm7[1],xmm5[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm1[0,1],ymm3[2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vmovaps (%rsp), %xmm15 # 16-byte Reload
; AVX2-NEXT:    vbroadcastsd %xmm15, %ymm3
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm3[0],ymm1[2],ymm3[2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1,2,3],ymm1[4,5,6],ymm5[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm7[3,3],xmm12[3,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm13[2],xmm2[2],xmm13[3],xmm2[3]
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5,6],ymm1[7]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm5[2,2,2,2]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm10[0,1,2],xmm1[3]
; AVX2-NEXT:    vbroadcastsd 8(%rax), %ymm3
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4],ymm0[5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vbroadcastss %xmm2, %xmm0
; AVX2-NEXT:    vbroadcastss %xmm13, %xmm3
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm3[0],xmm0[0],xmm3[1],xmm0[1]
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm7[0],xmm12[0],xmm7[1],xmm12[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1],ymm0[2,3],ymm3[4,5,6,7]
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm10[0],xmm5[0],xmm10[1],xmm5[1]
; AVX2-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; AVX2-NEXT:    vbroadcastsd %xmm12, %ymm5
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm3[0],ymm5[0],ymm3[2],ymm5[2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5,6],ymm0[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm4[1,1],ymm8[1,1],ymm4[5,5],ymm8[5,5]
; AVX2-NEXT:    vshufps {{.*#+}} ymm2 = ymm6[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm11[1],ymm2[2,3,4],ymm11[5],ymm2[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[2,2,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3,4],ymm0[5,6],ymm2[7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm2 = ymm9[0,0,0,0,4,4,4,4]
; AVX2-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm5 = mem[0,1,0,1,4,5,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0],ymm2[1],ymm5[2,3,4],ymm2[5],ymm5[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[2,1,2,3]
; AVX2-NEXT:    vbroadcastsd 48(%rax), %ymm5
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm5[2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm10 = ymm2[0,1,2],ymm0[3,4,5,6],ymm2[7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-NEXT:    vshufps {{.*#+}} ymm2 = ymm4[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm9[1],ymm2[2,3,4],ymm9[5],ymm2[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[2,2,2,2]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vshufps {{.*#+}} ymm5 = ymm0[1,1],ymm14[1,1],ymm0[5,5],ymm14[5,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4],ymm5[5,6],ymm2[7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-NEXT:    vshufps {{.*#+}} ymm5 = ymm3[0,0,0,0,4,4,4,4]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vshufps {{.*#+}} ymm7 = ymm1[0,1,0,1,4,5,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm7[0],ymm5[1],ymm7[2,3,4],ymm5[5],ymm7[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[2,1,2,3]
; AVX2-NEXT:    vbroadcastsd 16(%rax), %ymm7
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1],ymm7[2,3],ymm5[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2],ymm2[3,4,5,6],ymm5[7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm2 = ymm14[2],ymm0[2],ymm14[3],ymm0[3],ymm14[6],ymm0[6],ymm14[7],ymm0[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[3,3,3,3]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm4[2],ymm9[2],ymm4[3],ymm9[3],ymm4[6],ymm9[6],ymm4[7],ymm9[7]
; AVX2-NEXT:    vmovaps %ymm9, %ymm0
; AVX2-NEXT:    vmovaps %ymm4, %ymm13
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[3,3,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm7[0,1,2],ymm2[3,4,5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm7 = ymm1[3,3],ymm3[3,3],ymm1[7,7],ymm3[7,7]
; AVX2-NEXT:    vpermilps {{.*#+}} ymm9 = mem[2,3,2,3,6,7,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm9[0],ymm7[1,2],ymm9[3,4],ymm7[5,6],ymm9[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[2,1,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm7[0],ymm2[1,2,3,4],ymm7[5,6,7]
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm6 = ymm11[0],ymm6[0],ymm11[1],ymm6[1],ymm11[4],ymm6[4],ymm11[5],ymm6[5]
; AVX2-NEXT:    vshufps {{.*#+}} ymm4 = ymm8[3,1,2,0,7,5,6,4]
; AVX2-NEXT:    vbroadcastss 48(%rdx), %ymm7
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm7[6],ymm4[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm6[4,5],ymm4[6,7]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm6 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm6 = xmm1[3,3],mem[3,3]
; AVX2-NEXT:    vblendps {{.*#+}} xmm6 = xmm6[0,1,2],xmm15[3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm6[1,2,3],ymm4[4,5,6,7]
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm6 = ymm0[0],ymm13[0],ymm0[1],ymm13[1],ymm0[4],ymm13[4],ymm0[5],ymm13[5]
; AVX2-NEXT:    vshufps {{.*#+}} ymm7 = ymm14[3,1,2,0,7,5,6,4]
; AVX2-NEXT:    vbroadcastss 16(%rdx), %ymm8
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3,4,5],ymm8[6],ymm7[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5],ymm7[6,7]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm7 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm7 = xmm0[3,3],mem[3,3]
; AVX2-NEXT:    vblendps {{.*#+}} xmm7 = xmm7[0,1,2],xmm12[3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0],ymm7[1,2,3],ymm6[4,5,6,7]
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    vmovaps %ymm6, 96(%rax)
; AVX2-NEXT:    vmovaps %ymm4, 320(%rax)
; AVX2-NEXT:    vmovaps %ymm2, 192(%rax)
; AVX2-NEXT:    vmovaps %ymm5, 128(%rax)
; AVX2-NEXT:    vmovaps %ymm10, 352(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-NEXT:    addq $488, %rsp # imm = 0x1E8
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i32_stride7_vf16:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    subq $488, %rsp # imm = 0x1E8
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FP-NEXT:    vmovaps (%rax), %xmm6
; AVX2-FP-NEXT:    vmovaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rax), %xmm0
; AVX2-FP-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovaps (%r8), %xmm8
; AVX2-FP-NEXT:    vmovaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%r8), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps (%r9), %xmm9
; AVX2-FP-NEXT:    vmovaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%r9), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2,3]
; AVX2-FP-NEXT:    vbroadcastsd %xmm1, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovaps (%rcx), %xmm3
; AVX2-FP-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rcx), %xmm12
; AVX2-FP-NEXT:    vmovaps 32(%rdx), %xmm10
; AVX2-FP-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm10[1],xmm12[1],zero
; AVX2-FP-NEXT:    vmovaps (%rdi), %xmm11
; AVX2-FP-NEXT:    vmovaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %xmm7
; AVX2-FP-NEXT:    vmovaps (%rsi), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %xmm5
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm4 = xmm5[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm4 = xmm4[0,1],xmm7[2],xmm4[3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm4[0],ymm2[1,2],ymm4[3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2],ymm0[3,4,5],ymm2[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm0
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm2 = xmm9[1,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0],xmm8[1],xmm2[2,3]
; AVX2-FP-NEXT:    vbroadcastsd %xmm2, %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3,4],ymm0[5],ymm2[6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm2 = xmm1[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0,1],xmm11[2],xmm2[3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-FP-NEXT:    vmovaps (%rdx), %xmm13
; AVX2-FP-NEXT:    vinsertps {{.*#+}} xmm4 = zero,xmm13[1],xmm3[1],zero
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm4[1,2],ymm2[3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2],ymm0[3,4,5],ymm2[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps (%rdx), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rcx), %ymm14
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm2 = ymm1[2],ymm14[2],ymm1[3],ymm14[3],ymm1[6],ymm14[6],ymm1[7],ymm14[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps (%r8), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%r9), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[1,1,2,2,5,5,6,6]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm1[2],ymm2[3,4,5],ymm1[6],ymm2[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[2,1,2,3]
; AVX2-FP-NEXT:    vmovaps 16(%rax), %xmm4
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm4[1],ymm2[2,3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3,4,5],ymm2[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %ymm11
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %ymm6
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm11[2],ymm6[2],ymm11[3],ymm6[3],ymm11[6],ymm6[6],ymm11[7],ymm6[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps 32(%rdx), %ymm4
; AVX2-FP-NEXT:    vmovaps 32(%rcx), %ymm8
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm4[2],ymm8[2],ymm4[3],ymm8[3],ymm4[6],ymm8[6],ymm4[7],ymm8[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps 32(%r8), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm9[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovaps 32(%r9), %ymm9
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm15 = ymm9[1,2,2,3,5,6,6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[2,2,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm15[0],ymm1[1,2,3,4,5,6],ymm15[7]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3,4],ymm0[5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm8[2],ymm4[2],ymm8[3],ymm4[3],ymm8[6],ymm4[6],ymm8[7],ymm4[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm6[2],ymm11[2],ymm6[3],ymm11[3],ymm6[6],ymm11[6],ymm6[7],ymm11[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX2-FP-NEXT:    vbroadcastss 60(%r8), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vbroadcastss 60(%r9), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vbroadcastsd 56(%rax), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4,5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm0 = xmm7[3,3],xmm5[3,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm10[2],xmm12[2],xmm10[3],xmm12[3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm1[0,1,2,3,4],ymm0[5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm1 = xmm2[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm0[0,1,2],xmm1[3]
; AVX2-FP-NEXT:    vbroadcastsd 40(%rax), %ymm15
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm15[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3,4],ymm3[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vbroadcastss %xmm12, %xmm3
; AVX2-FP-NEXT:    vbroadcastss %xmm10, %xmm1
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm1[0],xmm3[0],xmm1[1],xmm3[1]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm7[0],xmm5[0],xmm7[1],xmm5[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm1[0,1],ymm3[2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vmovaps (%rsp), %xmm15 # 16-byte Reload
; AVX2-FP-NEXT:    vbroadcastsd %xmm15, %ymm3
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm3[0],ymm1[2],ymm3[2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1,2,3],ymm1[4,5,6],ymm5[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm0 = xmm7[3,3],xmm12[3,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm13[2],xmm2[2],xmm13[3],xmm2[3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm1 = xmm5[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm10[0,1,2],xmm1[3]
; AVX2-FP-NEXT:    vbroadcastsd 8(%rax), %ymm3
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4],ymm0[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vbroadcastss %xmm2, %xmm0
; AVX2-FP-NEXT:    vbroadcastss %xmm13, %xmm3
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm3[0],xmm0[0],xmm3[1],xmm0[1]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm7[0],xmm12[0],xmm7[1],xmm12[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1],ymm0[2,3],ymm3[4,5,6,7]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm10[0],xmm5[0],xmm10[1],xmm5[1]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; AVX2-FP-NEXT:    vbroadcastsd %xmm12, %ymm5
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm3[0],ymm5[0],ymm3[2],ymm5[2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5,6],ymm0[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm4[1,1],ymm8[1,1],ymm4[5,5],ymm8[5,5]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm2 = ymm6[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm11[1],ymm2[2,3,4],ymm11[5],ymm2[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[2,2,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3,4],ymm0[5,6],ymm2[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm2 = ymm9[0,0,0,0,4,4,4,4]
; AVX2-FP-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm5 = mem[0,1,0,1,4,5,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0],ymm2[1],ymm5[2,3,4],ymm2[5],ymm5[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[2,1,2,3]
; AVX2-FP-NEXT:    vbroadcastsd 48(%rax), %ymm5
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm5[2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm10 = ymm2[0,1,2],ymm0[3,4,5,6],ymm2[7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm2 = ymm4[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm9[1],ymm2[2,3,4],ymm9[5],ymm2[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[2,2,2,2]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm5 = ymm0[1,1],ymm14[1,1],ymm0[5,5],ymm14[5,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4],ymm5[5,6],ymm2[7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm5 = ymm3[0,0,0,0,4,4,4,4]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm7 = ymm1[0,1,0,1,4,5,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm7[0],ymm5[1],ymm7[2,3,4],ymm5[5],ymm7[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[2,1,2,3]
; AVX2-FP-NEXT:    vbroadcastsd 16(%rax), %ymm7
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1],ymm7[2,3],ymm5[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2],ymm2[3,4,5,6],ymm5[7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm2 = ymm14[2],ymm0[2],ymm14[3],ymm0[3],ymm14[6],ymm0[6],ymm14[7],ymm0[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[3,3,3,3]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm4[2],ymm9[2],ymm4[3],ymm9[3],ymm4[6],ymm9[6],ymm4[7],ymm9[7]
; AVX2-FP-NEXT:    vmovaps %ymm9, %ymm0
; AVX2-FP-NEXT:    vmovaps %ymm4, %ymm13
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[3,3,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm7[0,1,2],ymm2[3,4,5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm7 = ymm1[3,3],ymm3[3,3],ymm1[7,7],ymm3[7,7]
; AVX2-FP-NEXT:    vpermilps {{.*#+}} ymm9 = mem[2,3,2,3,6,7,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm9[0],ymm7[1,2],ymm9[3,4],ymm7[5,6],ymm9[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[2,1,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm7[0],ymm2[1,2,3,4],ymm7[5,6,7]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm6 = ymm11[0],ymm6[0],ymm11[1],ymm6[1],ymm11[4],ymm6[4],ymm11[5],ymm6[5]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm4 = ymm8[3,1,2,0,7,5,6,4]
; AVX2-FP-NEXT:    vbroadcastss 48(%rdx), %ymm7
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm7[6],ymm4[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm6[4,5],ymm4[6,7]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm6 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm6 = xmm1[3,3],mem[3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm6 = xmm6[0,1,2],xmm15[3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm6[1,2,3],ymm4[4,5,6,7]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm6 = ymm0[0],ymm13[0],ymm0[1],ymm13[1],ymm0[4],ymm13[4],ymm0[5],ymm13[5]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm7 = ymm14[3,1,2,0,7,5,6,4]
; AVX2-FP-NEXT:    vbroadcastss 16(%rdx), %ymm8
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3,4,5],ymm8[6],ymm7[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5],ymm7[6,7]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm7 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm7 = xmm0[3,3],mem[3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm7 = xmm7[0,1,2],xmm12[3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0],ymm7[1,2,3],ymm6[4,5,6,7]
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FP-NEXT:    vmovaps %ymm6, 96(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm4, 320(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm2, 192(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm5, 128(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm10, 352(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-FP-NEXT:    addq $488, %rsp # imm = 0x1E8
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i32_stride7_vf16:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    subq $536, %rsp # imm = 0x218
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FCP-NEXT:    vmovaps (%rax), %xmm3
; AVX2-FCP-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rax), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps (%r8), %xmm5
; AVX2-FCP-NEXT:    vmovaps %xmm5, (%rsp) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%r8), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%r9), %xmm7
; AVX2-FCP-NEXT:    vmovaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%r9), %xmm4
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm4[1,1,1,1]
; AVX2-FCP-NEXT:    vmovaps %xmm4, %xmm14
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd %xmm1, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovaps (%rcx), %xmm8
; AVX2-FCP-NEXT:    vmovaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rcx), %xmm11
; AVX2-FCP-NEXT:    vmovaps 32(%rdx), %xmm10
; AVX2-FCP-NEXT:    vinsertps {{.*#+}} xmm1 = zero,xmm10[1],xmm11[1],zero
; AVX2-FCP-NEXT:    vmovaps (%rdi), %xmm12
; AVX2-FCP-NEXT:    vmovaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %xmm9
; AVX2-FCP-NEXT:    vmovaps (%rsi), %xmm4
; AVX2-FCP-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %xmm6
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm2 = xmm6[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0,1],xmm9[2],xmm2[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1,2],ymm2[3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm7[1,1,1,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],xmm5[1],xmm1[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd %xmm1, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5],ymm1[6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm4[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm12[2],xmm1[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FCP-NEXT:    vmovaps (%rdx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm2[1],xmm8[1],zero
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps (%rdx), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rcx), %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps (%r8), %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%r9), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FCP-NEXT:    vmovaps 16(%rax), %xmm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %ymm13
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %ymm12
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm13[2],ymm12[2],ymm13[3],ymm12[3],ymm13[6],ymm12[6],ymm13[7],ymm12[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps 32(%rdx), %ymm3
; AVX2-FCP-NEXT:    vmovaps 32(%rcx), %ymm8
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm3[2],ymm8[2],ymm3[3],ymm8[3],ymm3[6],ymm8[6],ymm3[7],ymm8[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps 32(%r8), %ymm7
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm7[6,7]
; AVX2-FCP-NEXT:    vmovaps 32(%r9), %ymm4
; AVX2-FCP-NEXT:    vbroadcastsd {{.*#+}} ymm15 = [5,6,5,6,5,6,5,6]
; AVX2-FCP-NEXT:    vpermps %ymm4, %ymm15, %ymm15
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm15[0],ymm1[1,2,3,4,5,6],ymm15[7]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3,4],ymm0[5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm8[2],ymm3[2],ymm8[3],ymm3[3],ymm8[6],ymm3[6],ymm8[7],ymm3[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm12[2],ymm13[2],ymm12[3],ymm13[3],ymm12[6],ymm13[6],ymm12[7],ymm13[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX2-FCP-NEXT:    vbroadcastss 60(%r8), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vbroadcastss 60(%r9), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 56(%rax), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4,5,6],ymm1[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm0 = xmm9[3,3],xmm6[3,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm15 = xmm10[2],xmm11[2],xmm10[3],xmm11[3]
; AVX2-FCP-NEXT:    vbroadcastf128 {{.*#+}} ymm5 = [0,1,2,2,0,1,2,2]
; AVX2-FCP-NEXT:    # ymm5 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpermps %ymm15, %ymm5, %ymm15
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm15[0,1,2,3,4],ymm1[5,6],ymm15[7]
; AVX2-FCP-NEXT:    vmovaps %xmm14, %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm15 = xmm14[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm15 = xmm0[0,1,2],xmm15[3]
; AVX2-FCP-NEXT:    vbroadcastsd 40(%rax), %ymm14
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0,1,2,3],ymm14[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm14[2,3,4],ymm2[5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vbroadcastss %xmm11, %xmm2
; AVX2-FCP-NEXT:    vbroadcastss %xmm10, %xmm10
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm10[0],xmm2[0],xmm10[1],xmm2[1]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm6 = xmm9[0],xmm6[0],xmm9[1],xmm6[1]
; AVX2-FCP-NEXT:    vpermps %ymm6, %ymm5, %ymm6
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm6[0,1],ymm2[2,3],ymm6[4,5,6,7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm6 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-FCP-NEXT:    vbroadcastsd %xmm14, %ymm9
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm6 = ymm6[0],ymm9[0],ymm6[2],ymm9[2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm6[4,5,6],ymm2[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm3[1,1],ymm8[1,1],ymm3[5,5],ymm8[5,5]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm3 = ymm12[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm13[1],ymm3[2,3,4],ymm13[5],ymm3[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[2,2,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1,2,3,4],ymm1[5,6],ymm3[7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm2 = ymm4[0,0,0,0,4,4,4,4]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm3 = ymm7[0,1,0,1,4,5,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0],ymm2[1],ymm3[2,3,4],ymm2[5],ymm3[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[2,1,2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 48(%rax), %ymm3
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2],ymm1[3,4,5,6],ymm2[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm2 = xmm1[3,3],xmm6[3,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm3 = xmm7[2],xmm0[2],xmm7[3],xmm0[3]
; AVX2-FCP-NEXT:    vpermps %ymm3, %ymm5, %ymm3
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1,2,3,4],ymm2[5,6],ymm3[7]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm3 = xmm9[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps (%rsp), %xmm15 # 16-byte Reload
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm3 = xmm15[0,1,2],xmm3[3]
; AVX2-FCP-NEXT:    vbroadcastsd 8(%rax), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm4[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2,3,4],ymm2[5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vbroadcastss %xmm0, %xmm3
; AVX2-FCP-NEXT:    vbroadcastss %xmm7, %xmm4
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm4 = xmm1[0],xmm6[0],xmm1[1],xmm6[1]
; AVX2-FCP-NEXT:    vpermps %ymm4, %ymm5, %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm3[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm15[0],xmm9[0],xmm15[1],xmm9[1]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX2-FCP-NEXT:    vbroadcastsd %xmm6, %ymm4
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm3[0],ymm4[0],ymm3[2],ymm4[2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5,6],ymm0[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm3 = ymm5[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm0[1],ymm3[2,3,4],ymm0[5],ymm3[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[2,2,2,2]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm4 = ymm7[1,1],ymm1[1,1],ymm7[5,5],ymm1[5,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4],ymm4[5,6],ymm3[7]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm4 = ymm10[0,0,0,0,4,4,4,4]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm9 = ymm2[0,1,0,1,4,5,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm9[0],ymm4[1],ymm9[2,3,4],ymm4[5],ymm9[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[2,1,2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 16(%rax), %ymm9
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm9[2,3],ymm4[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm11 = ymm4[0,1,2],ymm3[3,4,5,6],ymm4[7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm4 = ymm1[2],ymm7[2],ymm1[3],ymm7[3],ymm1[6],ymm7[6],ymm1[7],ymm7[7]
; AVX2-FCP-NEXT:    vmovaps %ymm1, %ymm3
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[3,3,3,3]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm9 = ymm5[2],ymm0[2],ymm5[3],ymm0[3],ymm5[6],ymm0[6],ymm5[7],ymm0[7]
; AVX2-FCP-NEXT:    vmovaps %ymm0, %ymm1
; AVX2-FCP-NEXT:    vmovaps %ymm5, %ymm0
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[3,3,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm9[0,1,2],ymm4[3,4,5,6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm9 = ymm2[3,3],ymm10[3,3],ymm2[7,7],ymm10[7,7]
; AVX2-FCP-NEXT:    vpermilps {{.*#+}} ymm10 = mem[2,3,2,3,6,7,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0],ymm9[1,2],ymm10[3,4],ymm9[5,6],ymm10[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[2,1,2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm9[0],ymm4[1,2,3,4],ymm9[5,6,7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm13[0],ymm12[0],ymm13[1],ymm12[1],ymm13[4],ymm12[4],ymm13[5],ymm12[5]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm5 = ymm8[3,1,2,0,7,5,6,4]
; AVX2-FCP-NEXT:    vbroadcastss 48(%rdx), %ymm8
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],ymm8[6],ymm5[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm7[4,5],ymm5[6,7]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX2-FCP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm7 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm7 = xmm2[3,3],mem[3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm7 = xmm7[0,1,2],xmm14[3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0],ymm7[1,2,3],ymm5[4,5,6,7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[4],ymm0[4],ymm1[5],ymm0[5]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm8 = ymm3[3,1,2,0,7,5,6,4]
; AVX2-FCP-NEXT:    vbroadcastss 16(%rdx), %ymm9
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],ymm9[6],ymm8[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0,1,2,3],ymm7[4,5],ymm8[6,7]
; AVX2-FCP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm8 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm8 = xmm15[3,3],mem[3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm8 = xmm8[0,1,2],xmm6[3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm8[1,2,3],ymm7[4,5,6,7]
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FCP-NEXT:    vmovaps %ymm7, 96(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm5, 320(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm4, 192(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm11, 128(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-FCP-NEXT:    addq $536, %rsp # imm = 0x218
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride7_vf16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm4
; AVX512-NEXT:    vmovdqa64 (%rsi), %zmm6
; AVX512-NEXT:    vmovdqa64 (%rdx), %zmm3
; AVX512-NEXT:    vmovdqa64 (%rcx), %zmm5
; AVX512-NEXT:    vmovdqa64 (%r8), %zmm1
; AVX512-NEXT:    vmovdqa64 (%r9), %zmm2
; AVX512-NEXT:    vmovdqa64 (%r10), %zmm0
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,0,0,0,14,30,0,0,0,0,0,15,31,0,0,0]
; AVX512-NEXT:    vpermi2d %zmm5, %zmm3, %zmm7
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,0,14,30,0,0,0,0,0,15,31,0,0,0,0,0]
; AVX512-NEXT:    vpermi2d %zmm6, %zmm4, %zmm8
; AVX512-NEXT:    movw $6192, %cx # imm = 0x1830
; AVX512-NEXT:    kmovw %ecx, %k1
; AVX512-NEXT:    vmovdqa32 %zmm7, %zmm8 {%k1}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [13,0,0,0,0,0,30,14,0,0,0,0,0,31,15,0]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm2, %zmm7
; AVX512-NEXT:    movw $24769, %cx # imm = 0x60C1
; AVX512-NEXT:    kmovw %ecx, %k2
; AVX512-NEXT:    vmovdqa32 %zmm7, %zmm8 {%k2}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,29,2,3,4,5,6,7,30,9,10,11,12,13,14,31]
; AVX512-NEXT:    vpermi2d %zmm0, %zmm8, %zmm7
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,0,0,16,0,0,0,0,0,1,17,0,0,0,0,0]
; AVX512-NEXT:    vpermi2d %zmm5, %zmm3, %zmm9
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,16,0,0,0,0,0,1,17,0,0,0,0,0,2,18]
; AVX512-NEXT:    vpermi2d %zmm6, %zmm4, %zmm8
; AVX512-NEXT:    movw $1548, %cx # imm = 0x60C
; AVX512-NEXT:    kmovw %ecx, %k2
; AVX512-NEXT:    vmovdqa32 %zmm9, %zmm8 {%k2}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512-NEXT:    vpermi2d %zmm2, %zmm1, %zmm9
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,0,0,4,5,16,0,0,0,0,11,12,17,0,0]
; AVX512-NEXT:    vpermi2d %zmm0, %zmm9, %zmm10
; AVX512-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512-NEXT:    kmovw %ecx, %k2
; AVX512-NEXT:    vmovdqa32 %zmm10, %zmm8 {%k2}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,0,0,0,3,19,0,0,0,0,0,4,20,0,0]
; AVX512-NEXT:    vpermi2d %zmm6, %zmm4, %zmm10
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [2,18,0,0,0,0,0,3,19,0,0,0,0,0,4,20]
; AVX512-NEXT:    vpermi2d %zmm5, %zmm3, %zmm9
; AVX512-NEXT:    movw $12384, %cx # imm = 0x3060
; AVX512-NEXT:    kmovw %ecx, %k2
; AVX512-NEXT:    vmovdqa32 %zmm10, %zmm9 {%k2}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,2,18,0,0,0,0,0,3,19,0,0,0,0,0]
; AVX512-NEXT:    vpermi2d %zmm2, %zmm1, %zmm10
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,2,3,18,0,0,0,0,9,10,19,0,0,0,0]
; AVX512-NEXT:    vpermi2d %zmm0, %zmm10, %zmm11
; AVX512-NEXT:    movw $3612, %cx # imm = 0xE1C
; AVX512-NEXT:    kmovw %ecx, %k3
; AVX512-NEXT:    vmovdqa32 %zmm11, %zmm9 {%k3}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,0,0,0,5,21,0,0,0,0,0,6,22,0,0]
; AVX512-NEXT:    vpermi2d %zmm5, %zmm3, %zmm10
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,5,21,0,0,0,0,0,6,22,0,0,0,0]
; AVX512-NEXT:    vpermi2d %zmm6, %zmm4, %zmm11
; AVX512-NEXT:    vmovdqa32 %zmm10, %zmm11 {%k2}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [4,20,0,0,0,0,0,5,21,0,0,0,0,0,6,22]
; AVX512-NEXT:    vpermi2d %zmm2, %zmm1, %zmm12
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,1,20,0,0,0,0,7,8,21,0,0,0,0,14,15]
; AVX512-NEXT:    vpermi2d %zmm0, %zmm12, %zmm10
; AVX512-NEXT:    movw $15480, %cx # imm = 0x3C78
; AVX512-NEXT:    kmovw %ecx, %k2
; AVX512-NEXT:    vmovdqa32 %zmm11, %zmm10 {%k2}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,7,23,0,0,0,0,0,8,24,0,0,0,0]
; AVX512-NEXT:    vpermi2d %zmm5, %zmm3, %zmm11
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [0,7,23,0,0,0,0,0,8,24,0,0,0,0,0,9]
; AVX512-NEXT:    vpermi2d %zmm6, %zmm4, %zmm12
; AVX512-NEXT:    movw $3096, %cx # imm = 0xC18
; AVX512-NEXT:    kmovw %ecx, %k2
; AVX512-NEXT:    vmovdqa32 %zmm11, %zmm12 {%k2}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,0,0,7,23,0,0,0,0,0,8,24,0,0]
; AVX512-NEXT:    vpermi2d %zmm2, %zmm1, %zmm11
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm13 = [22,0,0,0,0,5,6,23,0,0,0,0,12,13,24,0]
; AVX512-NEXT:    vpermi2d %zmm0, %zmm11, %zmm13
; AVX512-NEXT:    movw $28897, %cx # imm = 0x70E1
; AVX512-NEXT:    kmovw %ecx, %k2
; AVX512-NEXT:    vmovdqa32 %zmm13, %zmm12 {%k2}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,9,25,0,0,0,0,0,10,26,0,0,0,0,0,11]
; AVX512-NEXT:    vpermi2d %zmm5, %zmm3, %zmm11
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm13 = [9,0,0,0,0,0,26,10,0,0,0,0,0,27,11,0]
; AVX512-NEXT:    vpermi2d %zmm4, %zmm6, %zmm13
; AVX512-NEXT:    movw $-31994, %cx # imm = 0x8306
; AVX512-NEXT:    kmovw %ecx, %k2
; AVX512-NEXT:    vmovdqa32 %zmm11, %zmm13 {%k2}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,9,25,0,0,0,0,0,10,26,0,0,0,0]
; AVX512-NEXT:    vpermi2d %zmm2, %zmm1, %zmm11
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,0,0,3,4,25,0,0,0,0,10,11,26,0,0,0]
; AVX512-NEXT:    vpermi2d %zmm0, %zmm11, %zmm14
; AVX512-NEXT:    movw $7224, %cx # imm = 0x1C38
; AVX512-NEXT:    kmovw %ecx, %k2
; AVX512-NEXT:    vmovdqa32 %zmm14, %zmm13 {%k2}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,0,12,28,0,0,0,0,0,13,29,0,0,0]
; AVX512-NEXT:    vpermi2d %zmm6, %zmm4, %zmm11
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [11,0,0,0,0,0,28,12,0,0,0,0,0,29,13,0]
; AVX512-NEXT:    vpermi2d %zmm3, %zmm5, %zmm4
; AVX512-NEXT:    vmovdqa32 %zmm11, %zmm4 {%k1}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,11,27,0,0,0,0,0,12,28,0,0,0,0,0,13]
; AVX512-NEXT:    vpermi2d %zmm2, %zmm1, %zmm3
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,1,2,27,0,0,0,0,8,9,28,0,0,0,0,15]
; AVX512-NEXT:    vpermi2d %zmm0, %zmm3, %zmm1
; AVX512-NEXT:    movw $-30962, %cx # imm = 0x870E
; AVX512-NEXT:    kmovw %ecx, %k1
; AVX512-NEXT:    vmovdqa32 %zmm1, %zmm4 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm4, 320(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm13, 256(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm12, 192(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm10, 128(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm9, 64(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm8, (%rax)
; AVX512-NEXT:    vmovdqa64 %zmm7, 384(%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i32_stride7_vf16:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm4
; AVX512-FCP-NEXT:    vmovdqa64 (%rsi), %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 (%rdx), %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 (%rcx), %zmm5
; AVX512-FCP-NEXT:    vmovdqa64 (%r8), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 (%r9), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 (%r10), %zmm0
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,0,0,0,14,30,0,0,0,0,0,15,31,0,0,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm5, %zmm3, %zmm7
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,0,14,30,0,0,0,0,0,15,31,0,0,0,0,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm8
; AVX512-FCP-NEXT:    movw $6192, %cx # imm = 0x1830
; AVX512-FCP-NEXT:    kmovw %ecx, %k1
; AVX512-FCP-NEXT:    vmovdqa32 %zmm7, %zmm8 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [13,0,0,0,0,0,30,14,0,0,0,0,0,31,15,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm2, %zmm7
; AVX512-FCP-NEXT:    movw $24769, %cx # imm = 0x60C1
; AVX512-FCP-NEXT:    kmovw %ecx, %k2
; AVX512-FCP-NEXT:    vmovdqa32 %zmm7, %zmm8 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,29,2,3,4,5,6,7,30,9,10,11,12,13,14,31]
; AVX512-FCP-NEXT:    vpermi2d %zmm0, %zmm8, %zmm7
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,0,0,16,0,0,0,0,0,1,17,0,0,0,0,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm5, %zmm3, %zmm9
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,16,0,0,0,0,0,1,17,0,0,0,0,0,2,18]
; AVX512-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm8
; AVX512-FCP-NEXT:    movw $1548, %cx # imm = 0x60C
; AVX512-FCP-NEXT:    kmovw %ecx, %k2
; AVX512-FCP-NEXT:    vmovdqa32 %zmm9, %zmm8 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm9
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,0,0,4,5,16,0,0,0,0,11,12,17,0,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm0, %zmm9, %zmm10
; AVX512-FCP-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512-FCP-NEXT:    kmovw %ecx, %k2
; AVX512-FCP-NEXT:    vmovdqa32 %zmm10, %zmm8 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,0,0,0,3,19,0,0,0,0,0,4,20,0,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm10
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [2,18,0,0,0,0,0,3,19,0,0,0,0,0,4,20]
; AVX512-FCP-NEXT:    vpermi2d %zmm5, %zmm3, %zmm9
; AVX512-FCP-NEXT:    movw $12384, %cx # imm = 0x3060
; AVX512-FCP-NEXT:    kmovw %ecx, %k2
; AVX512-FCP-NEXT:    vmovdqa32 %zmm10, %zmm9 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,2,18,0,0,0,0,0,3,19,0,0,0,0,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm10
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,2,3,18,0,0,0,0,9,10,19,0,0,0,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm0, %zmm10, %zmm11
; AVX512-FCP-NEXT:    movw $3612, %cx # imm = 0xE1C
; AVX512-FCP-NEXT:    kmovw %ecx, %k3
; AVX512-FCP-NEXT:    vmovdqa32 %zmm11, %zmm9 {%k3}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,0,0,0,5,21,0,0,0,0,0,6,22,0,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm5, %zmm3, %zmm10
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,5,21,0,0,0,0,0,6,22,0,0,0,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm11
; AVX512-FCP-NEXT:    vmovdqa32 %zmm10, %zmm11 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [4,20,0,0,0,0,0,5,21,0,0,0,0,0,6,22]
; AVX512-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm12
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,1,20,0,0,0,0,7,8,21,0,0,0,0,14,15]
; AVX512-FCP-NEXT:    vpermi2d %zmm0, %zmm12, %zmm10
; AVX512-FCP-NEXT:    movw $15480, %cx # imm = 0x3C78
; AVX512-FCP-NEXT:    kmovw %ecx, %k2
; AVX512-FCP-NEXT:    vmovdqa32 %zmm11, %zmm10 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,7,23,0,0,0,0,0,8,24,0,0,0,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm5, %zmm3, %zmm11
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [0,7,23,0,0,0,0,0,8,24,0,0,0,0,0,9]
; AVX512-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm12
; AVX512-FCP-NEXT:    movw $3096, %cx # imm = 0xC18
; AVX512-FCP-NEXT:    kmovw %ecx, %k2
; AVX512-FCP-NEXT:    vmovdqa32 %zmm11, %zmm12 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,0,0,7,23,0,0,0,0,0,8,24,0,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm11
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm13 = [22,0,0,0,0,5,6,23,0,0,0,0,12,13,24,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm0, %zmm11, %zmm13
; AVX512-FCP-NEXT:    movw $28897, %cx # imm = 0x70E1
; AVX512-FCP-NEXT:    kmovw %ecx, %k2
; AVX512-FCP-NEXT:    vmovdqa32 %zmm13, %zmm12 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,9,25,0,0,0,0,0,10,26,0,0,0,0,0,11]
; AVX512-FCP-NEXT:    vpermi2d %zmm5, %zmm3, %zmm11
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm13 = [9,0,0,0,0,0,26,10,0,0,0,0,0,27,11,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm4, %zmm6, %zmm13
; AVX512-FCP-NEXT:    movw $-31994, %cx # imm = 0x8306
; AVX512-FCP-NEXT:    kmovw %ecx, %k2
; AVX512-FCP-NEXT:    vmovdqa32 %zmm11, %zmm13 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,9,25,0,0,0,0,0,10,26,0,0,0,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm11
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,0,0,3,4,25,0,0,0,0,10,11,26,0,0,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm0, %zmm11, %zmm14
; AVX512-FCP-NEXT:    movw $7224, %cx # imm = 0x1C38
; AVX512-FCP-NEXT:    kmovw %ecx, %k2
; AVX512-FCP-NEXT:    vmovdqa32 %zmm14, %zmm13 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,0,12,28,0,0,0,0,0,13,29,0,0,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm11
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [11,0,0,0,0,0,28,12,0,0,0,0,0,29,13,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm3, %zmm5, %zmm4
; AVX512-FCP-NEXT:    vmovdqa32 %zmm11, %zmm4 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,11,27,0,0,0,0,0,12,28,0,0,0,0,0,13]
; AVX512-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm3
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,1,2,27,0,0,0,0,8,9,28,0,0,0,0,15]
; AVX512-FCP-NEXT:    vpermi2d %zmm0, %zmm3, %zmm1
; AVX512-FCP-NEXT:    movw $-30962, %cx # imm = 0x870E
; AVX512-FCP-NEXT:    kmovw %ecx, %k1
; AVX512-FCP-NEXT:    vmovdqa32 %zmm1, %zmm4 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, 320(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm13, 256(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm12, 192(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm10, 128(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, 64(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, (%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, 384(%rax)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i32_stride7_vf16:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm4
; AVX512DQ-NEXT:    vmovdqa64 (%rsi), %zmm6
; AVX512DQ-NEXT:    vmovdqa64 (%rdx), %zmm3
; AVX512DQ-NEXT:    vmovdqa64 (%rcx), %zmm5
; AVX512DQ-NEXT:    vmovdqa64 (%r8), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 (%r9), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 (%r10), %zmm0
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,0,0,0,14,30,0,0,0,0,0,15,31,0,0,0]
; AVX512DQ-NEXT:    vpermi2d %zmm5, %zmm3, %zmm7
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,0,14,30,0,0,0,0,0,15,31,0,0,0,0,0]
; AVX512DQ-NEXT:    vpermi2d %zmm6, %zmm4, %zmm8
; AVX512DQ-NEXT:    movw $6192, %cx # imm = 0x1830
; AVX512DQ-NEXT:    kmovw %ecx, %k1
; AVX512DQ-NEXT:    vmovdqa32 %zmm7, %zmm8 {%k1}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [13,0,0,0,0,0,30,14,0,0,0,0,0,31,15,0]
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm2, %zmm7
; AVX512DQ-NEXT:    movw $24769, %cx # imm = 0x60C1
; AVX512DQ-NEXT:    kmovw %ecx, %k2
; AVX512DQ-NEXT:    vmovdqa32 %zmm7, %zmm8 {%k2}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,29,2,3,4,5,6,7,30,9,10,11,12,13,14,31]
; AVX512DQ-NEXT:    vpermi2d %zmm0, %zmm8, %zmm7
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,0,0,16,0,0,0,0,0,1,17,0,0,0,0,0]
; AVX512DQ-NEXT:    vpermi2d %zmm5, %zmm3, %zmm9
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,16,0,0,0,0,0,1,17,0,0,0,0,0,2,18]
; AVX512DQ-NEXT:    vpermi2d %zmm6, %zmm4, %zmm8
; AVX512DQ-NEXT:    movw $1548, %cx # imm = 0x60C
; AVX512DQ-NEXT:    kmovw %ecx, %k2
; AVX512DQ-NEXT:    vmovdqa32 %zmm9, %zmm8 {%k2}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512DQ-NEXT:    vpermi2d %zmm2, %zmm1, %zmm9
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,0,0,4,5,16,0,0,0,0,11,12,17,0,0]
; AVX512DQ-NEXT:    vpermi2d %zmm0, %zmm9, %zmm10
; AVX512DQ-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512DQ-NEXT:    kmovw %ecx, %k2
; AVX512DQ-NEXT:    vmovdqa32 %zmm10, %zmm8 {%k2}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,0,0,0,3,19,0,0,0,0,0,4,20,0,0]
; AVX512DQ-NEXT:    vpermi2d %zmm6, %zmm4, %zmm10
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [2,18,0,0,0,0,0,3,19,0,0,0,0,0,4,20]
; AVX512DQ-NEXT:    vpermi2d %zmm5, %zmm3, %zmm9
; AVX512DQ-NEXT:    movw $12384, %cx # imm = 0x3060
; AVX512DQ-NEXT:    kmovw %ecx, %k2
; AVX512DQ-NEXT:    vmovdqa32 %zmm10, %zmm9 {%k2}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,2,18,0,0,0,0,0,3,19,0,0,0,0,0]
; AVX512DQ-NEXT:    vpermi2d %zmm2, %zmm1, %zmm10
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,2,3,18,0,0,0,0,9,10,19,0,0,0,0]
; AVX512DQ-NEXT:    vpermi2d %zmm0, %zmm10, %zmm11
; AVX512DQ-NEXT:    movw $3612, %cx # imm = 0xE1C
; AVX512DQ-NEXT:    kmovw %ecx, %k3
; AVX512DQ-NEXT:    vmovdqa32 %zmm11, %zmm9 {%k3}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,0,0,0,5,21,0,0,0,0,0,6,22,0,0]
; AVX512DQ-NEXT:    vpermi2d %zmm5, %zmm3, %zmm10
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,5,21,0,0,0,0,0,6,22,0,0,0,0]
; AVX512DQ-NEXT:    vpermi2d %zmm6, %zmm4, %zmm11
; AVX512DQ-NEXT:    vmovdqa32 %zmm10, %zmm11 {%k2}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [4,20,0,0,0,0,0,5,21,0,0,0,0,0,6,22]
; AVX512DQ-NEXT:    vpermi2d %zmm2, %zmm1, %zmm12
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,1,20,0,0,0,0,7,8,21,0,0,0,0,14,15]
; AVX512DQ-NEXT:    vpermi2d %zmm0, %zmm12, %zmm10
; AVX512DQ-NEXT:    movw $15480, %cx # imm = 0x3C78
; AVX512DQ-NEXT:    kmovw %ecx, %k2
; AVX512DQ-NEXT:    vmovdqa32 %zmm11, %zmm10 {%k2}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,7,23,0,0,0,0,0,8,24,0,0,0,0]
; AVX512DQ-NEXT:    vpermi2d %zmm5, %zmm3, %zmm11
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [0,7,23,0,0,0,0,0,8,24,0,0,0,0,0,9]
; AVX512DQ-NEXT:    vpermi2d %zmm6, %zmm4, %zmm12
; AVX512DQ-NEXT:    movw $3096, %cx # imm = 0xC18
; AVX512DQ-NEXT:    kmovw %ecx, %k2
; AVX512DQ-NEXT:    vmovdqa32 %zmm11, %zmm12 {%k2}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,0,0,7,23,0,0,0,0,0,8,24,0,0]
; AVX512DQ-NEXT:    vpermi2d %zmm2, %zmm1, %zmm11
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm13 = [22,0,0,0,0,5,6,23,0,0,0,0,12,13,24,0]
; AVX512DQ-NEXT:    vpermi2d %zmm0, %zmm11, %zmm13
; AVX512DQ-NEXT:    movw $28897, %cx # imm = 0x70E1
; AVX512DQ-NEXT:    kmovw %ecx, %k2
; AVX512DQ-NEXT:    vmovdqa32 %zmm13, %zmm12 {%k2}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,9,25,0,0,0,0,0,10,26,0,0,0,0,0,11]
; AVX512DQ-NEXT:    vpermi2d %zmm5, %zmm3, %zmm11
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm13 = [9,0,0,0,0,0,26,10,0,0,0,0,0,27,11,0]
; AVX512DQ-NEXT:    vpermi2d %zmm4, %zmm6, %zmm13
; AVX512DQ-NEXT:    movw $-31994, %cx # imm = 0x8306
; AVX512DQ-NEXT:    kmovw %ecx, %k2
; AVX512DQ-NEXT:    vmovdqa32 %zmm11, %zmm13 {%k2}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,9,25,0,0,0,0,0,10,26,0,0,0,0]
; AVX512DQ-NEXT:    vpermi2d %zmm2, %zmm1, %zmm11
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,0,0,3,4,25,0,0,0,0,10,11,26,0,0,0]
; AVX512DQ-NEXT:    vpermi2d %zmm0, %zmm11, %zmm14
; AVX512DQ-NEXT:    movw $7224, %cx # imm = 0x1C38
; AVX512DQ-NEXT:    kmovw %ecx, %k2
; AVX512DQ-NEXT:    vmovdqa32 %zmm14, %zmm13 {%k2}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,0,12,28,0,0,0,0,0,13,29,0,0,0]
; AVX512DQ-NEXT:    vpermi2d %zmm6, %zmm4, %zmm11
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [11,0,0,0,0,0,28,12,0,0,0,0,0,29,13,0]
; AVX512DQ-NEXT:    vpermi2d %zmm3, %zmm5, %zmm4
; AVX512DQ-NEXT:    vmovdqa32 %zmm11, %zmm4 {%k1}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,11,27,0,0,0,0,0,12,28,0,0,0,0,0,13]
; AVX512DQ-NEXT:    vpermi2d %zmm2, %zmm1, %zmm3
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,1,2,27,0,0,0,0,8,9,28,0,0,0,0,15]
; AVX512DQ-NEXT:    vpermi2d %zmm0, %zmm3, %zmm1
; AVX512DQ-NEXT:    movw $-30962, %cx # imm = 0x870E
; AVX512DQ-NEXT:    kmovw %ecx, %k1
; AVX512DQ-NEXT:    vmovdqa32 %zmm1, %zmm4 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, 320(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm13, 256(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm12, 192(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm10, 128(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, 64(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, (%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, 384(%rax)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i32_stride7_vf16:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rsi), %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdx), %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rcx), %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%r8), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%r9), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%r10), %zmm0
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,0,0,0,14,30,0,0,0,0,0,15,31,0,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm5, %zmm3, %zmm7
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,0,14,30,0,0,0,0,0,15,31,0,0,0,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm8
; AVX512DQ-FCP-NEXT:    movw $6192, %cx # imm = 0x1830
; AVX512DQ-FCP-NEXT:    kmovw %ecx, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm7, %zmm8 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [13,0,0,0,0,0,30,14,0,0,0,0,0,31,15,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm2, %zmm7
; AVX512DQ-FCP-NEXT:    movw $24769, %cx # imm = 0x60C1
; AVX512DQ-FCP-NEXT:    kmovw %ecx, %k2
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm7, %zmm8 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,29,2,3,4,5,6,7,30,9,10,11,12,13,14,31]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm0, %zmm8, %zmm7
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,0,0,16,0,0,0,0,0,1,17,0,0,0,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm5, %zmm3, %zmm9
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,16,0,0,0,0,0,1,17,0,0,0,0,0,2,18]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm8
; AVX512DQ-FCP-NEXT:    movw $1548, %cx # imm = 0x60C
; AVX512DQ-FCP-NEXT:    kmovw %ecx, %k2
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm9, %zmm8 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm9
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,0,0,4,5,16,0,0,0,0,11,12,17,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm0, %zmm9, %zmm10
; AVX512DQ-FCP-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512DQ-FCP-NEXT:    kmovw %ecx, %k2
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm10, %zmm8 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,0,0,0,3,19,0,0,0,0,0,4,20,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm10
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [2,18,0,0,0,0,0,3,19,0,0,0,0,0,4,20]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm5, %zmm3, %zmm9
; AVX512DQ-FCP-NEXT:    movw $12384, %cx # imm = 0x3060
; AVX512DQ-FCP-NEXT:    kmovw %ecx, %k2
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm10, %zmm9 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,2,18,0,0,0,0,0,3,19,0,0,0,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm10
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,2,3,18,0,0,0,0,9,10,19,0,0,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm0, %zmm10, %zmm11
; AVX512DQ-FCP-NEXT:    movw $3612, %cx # imm = 0xE1C
; AVX512DQ-FCP-NEXT:    kmovw %ecx, %k3
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm11, %zmm9 {%k3}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,0,0,0,5,21,0,0,0,0,0,6,22,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm5, %zmm3, %zmm10
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,5,21,0,0,0,0,0,6,22,0,0,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm10, %zmm11 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [4,20,0,0,0,0,0,5,21,0,0,0,0,0,6,22]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm12
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,1,20,0,0,0,0,7,8,21,0,0,0,0,14,15]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm0, %zmm12, %zmm10
; AVX512DQ-FCP-NEXT:    movw $15480, %cx # imm = 0x3C78
; AVX512DQ-FCP-NEXT:    kmovw %ecx, %k2
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm11, %zmm10 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,7,23,0,0,0,0,0,8,24,0,0,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm5, %zmm3, %zmm11
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [0,7,23,0,0,0,0,0,8,24,0,0,0,0,0,9]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm12
; AVX512DQ-FCP-NEXT:    movw $3096, %cx # imm = 0xC18
; AVX512DQ-FCP-NEXT:    kmovw %ecx, %k2
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm11, %zmm12 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,0,0,7,23,0,0,0,0,0,8,24,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm11
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm13 = [22,0,0,0,0,5,6,23,0,0,0,0,12,13,24,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm0, %zmm11, %zmm13
; AVX512DQ-FCP-NEXT:    movw $28897, %cx # imm = 0x70E1
; AVX512DQ-FCP-NEXT:    kmovw %ecx, %k2
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm13, %zmm12 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,9,25,0,0,0,0,0,10,26,0,0,0,0,0,11]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm5, %zmm3, %zmm11
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm13 = [9,0,0,0,0,0,26,10,0,0,0,0,0,27,11,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm4, %zmm6, %zmm13
; AVX512DQ-FCP-NEXT:    movw $-31994, %cx # imm = 0x8306
; AVX512DQ-FCP-NEXT:    kmovw %ecx, %k2
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm11, %zmm13 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,9,25,0,0,0,0,0,10,26,0,0,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm11
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,0,0,3,4,25,0,0,0,0,10,11,26,0,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm0, %zmm11, %zmm14
; AVX512DQ-FCP-NEXT:    movw $7224, %cx # imm = 0x1C38
; AVX512DQ-FCP-NEXT:    kmovw %ecx, %k2
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm14, %zmm13 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,0,12,28,0,0,0,0,0,13,29,0,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm11
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [11,0,0,0,0,0,28,12,0,0,0,0,0,29,13,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm3, %zmm5, %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm11, %zmm4 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,11,27,0,0,0,0,0,12,28,0,0,0,0,0,13]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm3
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,1,2,27,0,0,0,0,8,9,28,0,0,0,0,15]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm0, %zmm3, %zmm1
; AVX512DQ-FCP-NEXT:    movw $-30962, %cx # imm = 0x870E
; AVX512DQ-FCP-NEXT:    kmovw %ecx, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm1, %zmm4 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, 320(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm13, 256(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm12, 192(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm10, 128(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, 64(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, (%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, 384(%rax)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride7_vf16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm4
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm6
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm3
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm5
; AVX512BW-NEXT:    vmovdqa64 (%r8), %zmm1
; AVX512BW-NEXT:    vmovdqa64 (%r9), %zmm2
; AVX512BW-NEXT:    vmovdqa64 (%r10), %zmm0
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,0,0,0,14,30,0,0,0,0,0,15,31,0,0,0]
; AVX512BW-NEXT:    vpermi2d %zmm5, %zmm3, %zmm7
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,0,14,30,0,0,0,0,0,15,31,0,0,0,0,0]
; AVX512BW-NEXT:    vpermi2d %zmm6, %zmm4, %zmm8
; AVX512BW-NEXT:    movw $6192, %cx # imm = 0x1830
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqa32 %zmm7, %zmm8 {%k1}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [13,0,0,0,0,0,30,14,0,0,0,0,0,31,15,0]
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm2, %zmm7
; AVX512BW-NEXT:    movw $24769, %cx # imm = 0x60C1
; AVX512BW-NEXT:    kmovd %ecx, %k2
; AVX512BW-NEXT:    vmovdqa32 %zmm7, %zmm8 {%k2}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,29,2,3,4,5,6,7,30,9,10,11,12,13,14,31]
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm8, %zmm7
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,0,0,16,0,0,0,0,0,1,17,0,0,0,0,0]
; AVX512BW-NEXT:    vpermi2d %zmm5, %zmm3, %zmm9
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,16,0,0,0,0,0,1,17,0,0,0,0,0,2,18]
; AVX512BW-NEXT:    vpermi2d %zmm6, %zmm4, %zmm8
; AVX512BW-NEXT:    movw $1548, %cx # imm = 0x60C
; AVX512BW-NEXT:    kmovd %ecx, %k2
; AVX512BW-NEXT:    vmovdqa32 %zmm9, %zmm8 {%k2}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512BW-NEXT:    vpermi2d %zmm2, %zmm1, %zmm9
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,0,0,4,5,16,0,0,0,0,11,12,17,0,0]
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm9, %zmm10
; AVX512BW-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512BW-NEXT:    kmovd %ecx, %k2
; AVX512BW-NEXT:    vmovdqa32 %zmm10, %zmm8 {%k2}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,0,0,0,3,19,0,0,0,0,0,4,20,0,0]
; AVX512BW-NEXT:    vpermi2d %zmm6, %zmm4, %zmm10
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [2,18,0,0,0,0,0,3,19,0,0,0,0,0,4,20]
; AVX512BW-NEXT:    vpermi2d %zmm5, %zmm3, %zmm9
; AVX512BW-NEXT:    movw $12384, %cx # imm = 0x3060
; AVX512BW-NEXT:    kmovd %ecx, %k2
; AVX512BW-NEXT:    vmovdqa32 %zmm10, %zmm9 {%k2}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,2,18,0,0,0,0,0,3,19,0,0,0,0,0]
; AVX512BW-NEXT:    vpermi2d %zmm2, %zmm1, %zmm10
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,2,3,18,0,0,0,0,9,10,19,0,0,0,0]
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm10, %zmm11
; AVX512BW-NEXT:    movw $3612, %cx # imm = 0xE1C
; AVX512BW-NEXT:    kmovd %ecx, %k3
; AVX512BW-NEXT:    vmovdqa32 %zmm11, %zmm9 {%k3}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,0,0,0,5,21,0,0,0,0,0,6,22,0,0]
; AVX512BW-NEXT:    vpermi2d %zmm5, %zmm3, %zmm10
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,5,21,0,0,0,0,0,6,22,0,0,0,0]
; AVX512BW-NEXT:    vpermi2d %zmm6, %zmm4, %zmm11
; AVX512BW-NEXT:    vmovdqa32 %zmm10, %zmm11 {%k2}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [4,20,0,0,0,0,0,5,21,0,0,0,0,0,6,22]
; AVX512BW-NEXT:    vpermi2d %zmm2, %zmm1, %zmm12
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,1,20,0,0,0,0,7,8,21,0,0,0,0,14,15]
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm12, %zmm10
; AVX512BW-NEXT:    movw $15480, %cx # imm = 0x3C78
; AVX512BW-NEXT:    kmovd %ecx, %k2
; AVX512BW-NEXT:    vmovdqa32 %zmm11, %zmm10 {%k2}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,7,23,0,0,0,0,0,8,24,0,0,0,0]
; AVX512BW-NEXT:    vpermi2d %zmm5, %zmm3, %zmm11
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [0,7,23,0,0,0,0,0,8,24,0,0,0,0,0,9]
; AVX512BW-NEXT:    vpermi2d %zmm6, %zmm4, %zmm12
; AVX512BW-NEXT:    movw $3096, %cx # imm = 0xC18
; AVX512BW-NEXT:    kmovd %ecx, %k2
; AVX512BW-NEXT:    vmovdqa32 %zmm11, %zmm12 {%k2}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,0,0,7,23,0,0,0,0,0,8,24,0,0]
; AVX512BW-NEXT:    vpermi2d %zmm2, %zmm1, %zmm11
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm13 = [22,0,0,0,0,5,6,23,0,0,0,0,12,13,24,0]
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm11, %zmm13
; AVX512BW-NEXT:    movw $28897, %cx # imm = 0x70E1
; AVX512BW-NEXT:    kmovd %ecx, %k2
; AVX512BW-NEXT:    vmovdqa32 %zmm13, %zmm12 {%k2}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,9,25,0,0,0,0,0,10,26,0,0,0,0,0,11]
; AVX512BW-NEXT:    vpermi2d %zmm5, %zmm3, %zmm11
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm13 = [9,0,0,0,0,0,26,10,0,0,0,0,0,27,11,0]
; AVX512BW-NEXT:    vpermi2d %zmm4, %zmm6, %zmm13
; AVX512BW-NEXT:    movw $-31994, %cx # imm = 0x8306
; AVX512BW-NEXT:    kmovd %ecx, %k2
; AVX512BW-NEXT:    vmovdqa32 %zmm11, %zmm13 {%k2}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,9,25,0,0,0,0,0,10,26,0,0,0,0]
; AVX512BW-NEXT:    vpermi2d %zmm2, %zmm1, %zmm11
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,0,0,3,4,25,0,0,0,0,10,11,26,0,0,0]
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm11, %zmm14
; AVX512BW-NEXT:    movw $7224, %cx # imm = 0x1C38
; AVX512BW-NEXT:    kmovd %ecx, %k2
; AVX512BW-NEXT:    vmovdqa32 %zmm14, %zmm13 {%k2}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,0,12,28,0,0,0,0,0,13,29,0,0,0]
; AVX512BW-NEXT:    vpermi2d %zmm6, %zmm4, %zmm11
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [11,0,0,0,0,0,28,12,0,0,0,0,0,29,13,0]
; AVX512BW-NEXT:    vpermi2d %zmm3, %zmm5, %zmm4
; AVX512BW-NEXT:    vmovdqa32 %zmm11, %zmm4 {%k1}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,11,27,0,0,0,0,0,12,28,0,0,0,0,0,13]
; AVX512BW-NEXT:    vpermi2d %zmm2, %zmm1, %zmm3
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,1,2,27,0,0,0,0,8,9,28,0,0,0,0,15]
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm3, %zmm1
; AVX512BW-NEXT:    movw $-30962, %cx # imm = 0x870E
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqa32 %zmm1, %zmm4 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm4, 320(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm13, 256(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm12, 192(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm10, 128(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm9, 64(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm8, (%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, 384(%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i32_stride7_vf16:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm4
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm5
; AVX512BW-FCP-NEXT:    vmovdqa64 (%r8), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 (%r9), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 (%r10), %zmm0
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,0,0,0,14,30,0,0,0,0,0,15,31,0,0,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm5, %zmm3, %zmm7
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,0,14,30,0,0,0,0,0,15,31,0,0,0,0,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm8
; AVX512BW-FCP-NEXT:    movw $6192, %cx # imm = 0x1830
; AVX512BW-FCP-NEXT:    kmovd %ecx, %k1
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm7, %zmm8 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [13,0,0,0,0,0,30,14,0,0,0,0,0,31,15,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm1, %zmm2, %zmm7
; AVX512BW-FCP-NEXT:    movw $24769, %cx # imm = 0x60C1
; AVX512BW-FCP-NEXT:    kmovd %ecx, %k2
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm7, %zmm8 {%k2}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,29,2,3,4,5,6,7,30,9,10,11,12,13,14,31]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm0, %zmm8, %zmm7
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,0,0,16,0,0,0,0,0,1,17,0,0,0,0,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm5, %zmm3, %zmm9
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,16,0,0,0,0,0,1,17,0,0,0,0,0,2,18]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm8
; AVX512BW-FCP-NEXT:    movw $1548, %cx # imm = 0x60C
; AVX512BW-FCP-NEXT:    kmovd %ecx, %k2
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm9, %zmm8 {%k2}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm9
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,0,0,4,5,16,0,0,0,0,11,12,17,0,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm0, %zmm9, %zmm10
; AVX512BW-FCP-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512BW-FCP-NEXT:    kmovd %ecx, %k2
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm10, %zmm8 {%k2}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,0,0,0,3,19,0,0,0,0,0,4,20,0,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm10
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [2,18,0,0,0,0,0,3,19,0,0,0,0,0,4,20]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm5, %zmm3, %zmm9
; AVX512BW-FCP-NEXT:    movw $12384, %cx # imm = 0x3060
; AVX512BW-FCP-NEXT:    kmovd %ecx, %k2
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm10, %zmm9 {%k2}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,2,18,0,0,0,0,0,3,19,0,0,0,0,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm10
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,2,3,18,0,0,0,0,9,10,19,0,0,0,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm0, %zmm10, %zmm11
; AVX512BW-FCP-NEXT:    movw $3612, %cx # imm = 0xE1C
; AVX512BW-FCP-NEXT:    kmovd %ecx, %k3
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm11, %zmm9 {%k3}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,0,0,0,5,21,0,0,0,0,0,6,22,0,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm5, %zmm3, %zmm10
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,5,21,0,0,0,0,0,6,22,0,0,0,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm11
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm10, %zmm11 {%k2}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [4,20,0,0,0,0,0,5,21,0,0,0,0,0,6,22]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm12
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,1,20,0,0,0,0,7,8,21,0,0,0,0,14,15]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm0, %zmm12, %zmm10
; AVX512BW-FCP-NEXT:    movw $15480, %cx # imm = 0x3C78
; AVX512BW-FCP-NEXT:    kmovd %ecx, %k2
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm11, %zmm10 {%k2}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,7,23,0,0,0,0,0,8,24,0,0,0,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm5, %zmm3, %zmm11
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [0,7,23,0,0,0,0,0,8,24,0,0,0,0,0,9]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm12
; AVX512BW-FCP-NEXT:    movw $3096, %cx # imm = 0xC18
; AVX512BW-FCP-NEXT:    kmovd %ecx, %k2
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm11, %zmm12 {%k2}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,0,0,7,23,0,0,0,0,0,8,24,0,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm11
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm13 = [22,0,0,0,0,5,6,23,0,0,0,0,12,13,24,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm0, %zmm11, %zmm13
; AVX512BW-FCP-NEXT:    movw $28897, %cx # imm = 0x70E1
; AVX512BW-FCP-NEXT:    kmovd %ecx, %k2
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm13, %zmm12 {%k2}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,9,25,0,0,0,0,0,10,26,0,0,0,0,0,11]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm5, %zmm3, %zmm11
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm13 = [9,0,0,0,0,0,26,10,0,0,0,0,0,27,11,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm4, %zmm6, %zmm13
; AVX512BW-FCP-NEXT:    movw $-31994, %cx # imm = 0x8306
; AVX512BW-FCP-NEXT:    kmovd %ecx, %k2
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm11, %zmm13 {%k2}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,9,25,0,0,0,0,0,10,26,0,0,0,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm11
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,0,0,3,4,25,0,0,0,0,10,11,26,0,0,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm0, %zmm11, %zmm14
; AVX512BW-FCP-NEXT:    movw $7224, %cx # imm = 0x1C38
; AVX512BW-FCP-NEXT:    kmovd %ecx, %k2
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm14, %zmm13 {%k2}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,0,12,28,0,0,0,0,0,13,29,0,0,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm11
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [11,0,0,0,0,0,28,12,0,0,0,0,0,29,13,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm3, %zmm5, %zmm4
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm11, %zmm4 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,11,27,0,0,0,0,0,12,28,0,0,0,0,0,13]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm3
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,1,2,27,0,0,0,0,8,9,28,0,0,0,0,15]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm0, %zmm3, %zmm1
; AVX512BW-FCP-NEXT:    movw $-30962, %cx # imm = 0x870E
; AVX512BW-FCP-NEXT:    kmovd %ecx, %k1
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm1, %zmm4 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, 320(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm13, 256(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm12, 192(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm10, 128(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, 64(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, (%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, 384(%rax)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i32_stride7_vf16:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm4
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rsi), %zmm6
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdx), %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rcx), %zmm5
; AVX512DQ-BW-NEXT:    vmovdqa64 (%r8), %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 (%r9), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 (%r10), %zmm0
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,0,0,0,14,30,0,0,0,0,0,15,31,0,0,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm5, %zmm3, %zmm7
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,0,14,30,0,0,0,0,0,15,31,0,0,0,0,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm6, %zmm4, %zmm8
; AVX512DQ-BW-NEXT:    movw $6192, %cx # imm = 0x1830
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm7, %zmm8 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [13,0,0,0,0,0,30,14,0,0,0,0,0,31,15,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm1, %zmm2, %zmm7
; AVX512DQ-BW-NEXT:    movw $24769, %cx # imm = 0x60C1
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k2
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm7, %zmm8 {%k2}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,29,2,3,4,5,6,7,30,9,10,11,12,13,14,31]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm0, %zmm8, %zmm7
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,0,0,16,0,0,0,0,0,1,17,0,0,0,0,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm5, %zmm3, %zmm9
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,16,0,0,0,0,0,1,17,0,0,0,0,0,2,18]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm6, %zmm4, %zmm8
; AVX512DQ-BW-NEXT:    movw $1548, %cx # imm = 0x60C
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k2
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm9, %zmm8 {%k2}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm2, %zmm1, %zmm9
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,0,0,4,5,16,0,0,0,0,11,12,17,0,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm0, %zmm9, %zmm10
; AVX512DQ-BW-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k2
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm10, %zmm8 {%k2}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,0,0,0,3,19,0,0,0,0,0,4,20,0,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm6, %zmm4, %zmm10
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [2,18,0,0,0,0,0,3,19,0,0,0,0,0,4,20]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm5, %zmm3, %zmm9
; AVX512DQ-BW-NEXT:    movw $12384, %cx # imm = 0x3060
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k2
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm10, %zmm9 {%k2}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,2,18,0,0,0,0,0,3,19,0,0,0,0,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm2, %zmm1, %zmm10
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,2,3,18,0,0,0,0,9,10,19,0,0,0,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm0, %zmm10, %zmm11
; AVX512DQ-BW-NEXT:    movw $3612, %cx # imm = 0xE1C
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k3
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm11, %zmm9 {%k3}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,0,0,0,5,21,0,0,0,0,0,6,22,0,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm5, %zmm3, %zmm10
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,5,21,0,0,0,0,0,6,22,0,0,0,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm6, %zmm4, %zmm11
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm10, %zmm11 {%k2}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [4,20,0,0,0,0,0,5,21,0,0,0,0,0,6,22]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm2, %zmm1, %zmm12
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,1,20,0,0,0,0,7,8,21,0,0,0,0,14,15]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm0, %zmm12, %zmm10
; AVX512DQ-BW-NEXT:    movw $15480, %cx # imm = 0x3C78
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k2
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm11, %zmm10 {%k2}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,7,23,0,0,0,0,0,8,24,0,0,0,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm5, %zmm3, %zmm11
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [0,7,23,0,0,0,0,0,8,24,0,0,0,0,0,9]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm6, %zmm4, %zmm12
; AVX512DQ-BW-NEXT:    movw $3096, %cx # imm = 0xC18
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k2
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm11, %zmm12 {%k2}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,0,0,7,23,0,0,0,0,0,8,24,0,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm2, %zmm1, %zmm11
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm13 = [22,0,0,0,0,5,6,23,0,0,0,0,12,13,24,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm0, %zmm11, %zmm13
; AVX512DQ-BW-NEXT:    movw $28897, %cx # imm = 0x70E1
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k2
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm13, %zmm12 {%k2}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,9,25,0,0,0,0,0,10,26,0,0,0,0,0,11]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm5, %zmm3, %zmm11
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm13 = [9,0,0,0,0,0,26,10,0,0,0,0,0,27,11,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm4, %zmm6, %zmm13
; AVX512DQ-BW-NEXT:    movw $-31994, %cx # imm = 0x8306
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k2
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm11, %zmm13 {%k2}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,9,25,0,0,0,0,0,10,26,0,0,0,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm2, %zmm1, %zmm11
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,0,0,3,4,25,0,0,0,0,10,11,26,0,0,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm0, %zmm11, %zmm14
; AVX512DQ-BW-NEXT:    movw $7224, %cx # imm = 0x1C38
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k2
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm14, %zmm13 {%k2}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,0,12,28,0,0,0,0,0,13,29,0,0,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm6, %zmm4, %zmm11
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [11,0,0,0,0,0,28,12,0,0,0,0,0,29,13,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm3, %zmm5, %zmm4
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm11, %zmm4 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,11,27,0,0,0,0,0,12,28,0,0,0,0,0,13]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm2, %zmm1, %zmm3
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,1,2,27,0,0,0,0,8,9,28,0,0,0,0,15]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm0, %zmm3, %zmm1
; AVX512DQ-BW-NEXT:    movw $-30962, %cx # imm = 0x870E
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm1, %zmm4 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, 320(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm13, 256(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm12, 192(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm10, 128(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm9, 64(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, (%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, 384(%rax)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i32_stride7_vf16:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%r8), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%r9), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%r10), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,0,0,0,14,30,0,0,0,0,0,15,31,0,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm5, %zmm3, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,0,14,30,0,0,0,0,0,15,31,0,0,0,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm8
; AVX512DQ-BW-FCP-NEXT:    movw $6192, %cx # imm = 0x1830
; AVX512DQ-BW-FCP-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm7, %zmm8 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [13,0,0,0,0,0,30,14,0,0,0,0,0,31,15,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm1, %zmm2, %zmm7
; AVX512DQ-BW-FCP-NEXT:    movw $24769, %cx # imm = 0x60C1
; AVX512DQ-BW-FCP-NEXT:    kmovd %ecx, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm7, %zmm8 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,29,2,3,4,5,6,7,30,9,10,11,12,13,14,31]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm0, %zmm8, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,0,0,16,0,0,0,0,0,1,17,0,0,0,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm5, %zmm3, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,16,0,0,0,0,0,1,17,0,0,0,0,0,2,18]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm8
; AVX512DQ-BW-FCP-NEXT:    movw $1548, %cx # imm = 0x60C
; AVX512DQ-BW-FCP-NEXT:    kmovd %ecx, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm9, %zmm8 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,0,0,4,5,16,0,0,0,0,11,12,17,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm0, %zmm9, %zmm10
; AVX512DQ-BW-FCP-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512DQ-BW-FCP-NEXT:    kmovd %ecx, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm10, %zmm8 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,0,0,0,3,19,0,0,0,0,0,4,20,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [2,18,0,0,0,0,0,3,19,0,0,0,0,0,4,20]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm5, %zmm3, %zmm9
; AVX512DQ-BW-FCP-NEXT:    movw $12384, %cx # imm = 0x3060
; AVX512DQ-BW-FCP-NEXT:    kmovd %ecx, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm10, %zmm9 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,2,18,0,0,0,0,0,3,19,0,0,0,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,2,3,18,0,0,0,0,9,10,19,0,0,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm0, %zmm10, %zmm11
; AVX512DQ-BW-FCP-NEXT:    movw $3612, %cx # imm = 0xE1C
; AVX512DQ-BW-FCP-NEXT:    kmovd %ecx, %k3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm11, %zmm9 {%k3}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,0,0,0,0,5,21,0,0,0,0,0,6,22,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm5, %zmm3, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,5,21,0,0,0,0,0,6,22,0,0,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm10, %zmm11 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [4,20,0,0,0,0,0,5,21,0,0,0,0,0,6,22]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,1,20,0,0,0,0,7,8,21,0,0,0,0,14,15]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm0, %zmm12, %zmm10
; AVX512DQ-BW-FCP-NEXT:    movw $15480, %cx # imm = 0x3C78
; AVX512DQ-BW-FCP-NEXT:    kmovd %ecx, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm11, %zmm10 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,7,23,0,0,0,0,0,8,24,0,0,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm5, %zmm3, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [0,7,23,0,0,0,0,0,8,24,0,0,0,0,0,9]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm12
; AVX512DQ-BW-FCP-NEXT:    movw $3096, %cx # imm = 0xC18
; AVX512DQ-BW-FCP-NEXT:    kmovd %ecx, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm11, %zmm12 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,0,0,7,23,0,0,0,0,0,8,24,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm13 = [22,0,0,0,0,5,6,23,0,0,0,0,12,13,24,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm0, %zmm11, %zmm13
; AVX512DQ-BW-FCP-NEXT:    movw $28897, %cx # imm = 0x70E1
; AVX512DQ-BW-FCP-NEXT:    kmovd %ecx, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm13, %zmm12 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,9,25,0,0,0,0,0,10,26,0,0,0,0,0,11]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm5, %zmm3, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm13 = [9,0,0,0,0,0,26,10,0,0,0,0,0,27,11,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm4, %zmm6, %zmm13
; AVX512DQ-BW-FCP-NEXT:    movw $-31994, %cx # imm = 0x8306
; AVX512DQ-BW-FCP-NEXT:    kmovd %ecx, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm11, %zmm13 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,9,25,0,0,0,0,0,10,26,0,0,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,0,0,3,4,25,0,0,0,0,10,11,26,0,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm0, %zmm11, %zmm14
; AVX512DQ-BW-FCP-NEXT:    movw $7224, %cx # imm = 0x1C38
; AVX512DQ-BW-FCP-NEXT:    kmovd %ecx, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm14, %zmm13 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,0,12,28,0,0,0,0,0,13,29,0,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [11,0,0,0,0,0,28,12,0,0,0,0,0,29,13,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm3, %zmm5, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm11, %zmm4 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,11,27,0,0,0,0,0,12,28,0,0,0,0,0,13]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,1,2,27,0,0,0,0,8,9,28,0,0,0,0,15]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm0, %zmm3, %zmm1
; AVX512DQ-BW-FCP-NEXT:    movw $-30962, %cx # imm = 0x870E
; AVX512DQ-BW-FCP-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm1, %zmm4 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, 320(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm13, 256(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm12, 192(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm10, 128(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm9, 64(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, (%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, 384(%rax)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <16 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <16 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <16 x i32>, ptr %in.vecptr2, align 64
  %in.vec3 = load <16 x i32>, ptr %in.vecptr3, align 64
  %in.vec4 = load <16 x i32>, ptr %in.vecptr4, align 64
  %in.vec5 = load <16 x i32>, ptr %in.vecptr5, align 64
  %in.vec6 = load <16 x i32>, ptr %in.vecptr6, align 64
  %1 = shufflevector <16 x i32> %in.vec0, <16 x i32> %in.vec1, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %2 = shufflevector <16 x i32> %in.vec2, <16 x i32> %in.vec3, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %3 = shufflevector <16 x i32> %in.vec4, <16 x i32> %in.vec5, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = shufflevector <32 x i32> %1, <32 x i32> %2, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %5 = shufflevector <16 x i32> %in.vec6, <16 x i32> poison, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <32 x i32> %3, <32 x i32> %5, <48 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47>
  %7 = shufflevector <48 x i32> %6, <48 x i32> poison, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %8 = shufflevector <64 x i32> %4, <64 x i32> %7, <112 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111>
  %interleaved.vec = shufflevector <112 x i32> %8, <112 x i32> poison, <112 x i32> <i32 0, i32 16, i32 32, i32 48, i32 64, i32 80, i32 96, i32 1, i32 17, i32 33, i32 49, i32 65, i32 81, i32 97, i32 2, i32 18, i32 34, i32 50, i32 66, i32 82, i32 98, i32 3, i32 19, i32 35, i32 51, i32 67, i32 83, i32 99, i32 4, i32 20, i32 36, i32 52, i32 68, i32 84, i32 100, i32 5, i32 21, i32 37, i32 53, i32 69, i32 85, i32 101, i32 6, i32 22, i32 38, i32 54, i32 70, i32 86, i32 102, i32 7, i32 23, i32 39, i32 55, i32 71, i32 87, i32 103, i32 8, i32 24, i32 40, i32 56, i32 72, i32 88, i32 104, i32 9, i32 25, i32 41, i32 57, i32 73, i32 89, i32 105, i32 10, i32 26, i32 42, i32 58, i32 74, i32 90, i32 106, i32 11, i32 27, i32 43, i32 59, i32 75, i32 91, i32 107, i32 12, i32 28, i32 44, i32 60, i32 76, i32 92, i32 108, i32 13, i32 29, i32 45, i32 61, i32 77, i32 93, i32 109, i32 14, i32 30, i32 46, i32 62, i32 78, i32 94, i32 110, i32 15, i32 31, i32 47, i32 63, i32 79, i32 95, i32 111>
  store <112 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride7_vf32(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride7_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $1256, %rsp # imm = 0x4E8
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa (%rdi), %xmm8
; SSE-NEXT:    movdqa (%rsi), %xmm10
; SSE-NEXT:    movdqa 16(%rsi), %xmm4
; SSE-NEXT:    movaps (%rdx), %xmm14
; SSE-NEXT:    movdqa 16(%rdx), %xmm7
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rcx), %xmm13
; SSE-NEXT:    movaps 16(%rcx), %xmm9
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%r8), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 16(%r8), %xmm11
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%r9), %xmm15
; SSE-NEXT:    movdqa %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 16(%r9), %xmm12
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rax), %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm13[1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm10[1,1,1,1]
; SSE-NEXT:    movaps %xmm14, %xmm3
; SSE-NEXT:    movss {{.*#+}} xmm3 = xmm1[0],xmm3[1,2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm8, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm10[2],xmm0[3],xmm10[3]
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm15[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[1,1,1,1]
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm4[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movaps %xmm11, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm9[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 16(%rax), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm12[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa 16(%rdi), %xmm15
; SSE-NEXT:    movdqa %xmm15, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm4[2],xmm0[3],xmm4[3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 32(%rsi), %xmm1
; SSE-NEXT:    movaps 32(%rdx), %xmm5
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm5, %xmm1
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE-NEXT:    movaps 32(%rcx), %xmm5
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%r8), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm5[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 32(%r9), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 32(%rax), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa 32(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 48(%rsi), %xmm3
; SSE-NEXT:    movdqa 48(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movaps 48(%rcx), %xmm7
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%r8), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm7[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 48(%r9), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 48(%rax), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa 48(%rdi), %xmm11
; SSE-NEXT:    movdqa %xmm11, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; SSE-NEXT:    movdqa %xmm3, %xmm7
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 64(%rsi), %xmm1
; SSE-NEXT:    movaps 64(%rdx), %xmm3
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; SSE-NEXT:    movdqa %xmm1, %xmm12
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm1
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE-NEXT:    movaps 64(%rcx), %xmm3
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%r8), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 64(%r9), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 64(%rax), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa 64(%rdi), %xmm9
; SSE-NEXT:    movdqa %xmm9, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm12[2],xmm0[3],xmm12[3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 80(%rsi), %xmm3
; SSE-NEXT:    movdqa 80(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[1,1,1,1]
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movaps 80(%rcx), %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%r8), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 80(%r9), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 80(%rax), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa 80(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 96(%rsi), %xmm6
; SSE-NEXT:    movaps 96(%rdx), %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[1,1,1,1]
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE-NEXT:    movaps 96(%rcx), %xmm3
; SSE-NEXT:    movaps 96(%r8), %xmm4
; SSE-NEXT:    movaps %xmm4, %xmm0
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm3[1,1]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 96(%r9), %xmm2
; SSE-NEXT:    movdqa 96(%rax), %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; SSE-NEXT:    movdqa %xmm1, %xmm12
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,1,1]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa 96(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm6[2],xmm0[3],xmm6[3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 112(%rsi), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 112(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm0[0],xmm3[1],xmm0[1]
; SSE-NEXT:    movaps 112(%rcx), %xmm2
; SSE-NEXT:    movaps 112(%r8), %xmm0
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    movaps 112(%r9), %xmm12
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm12[0]
; SSE-NEXT:    movaps %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    movaps %xmm12, %xmm1
; SSE-NEXT:    movaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm0[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    movaps %xmm2, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; SSE-NEXT:    movaps 112(%rax), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm0[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm1[0,2]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm14, %xmm0
; SSE-NEXT:    movaps %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm13[0],xmm0[1],xmm13[1]
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm8, %xmm1
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm10[0],xmm1[1],xmm10[1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm8[1,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm4[0],xmm1[1],xmm4[1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm4[2],xmm0[3],xmm4[3]
; SSE-NEXT:    movaps %xmm14, %xmm1
; SSE-NEXT:    unpckhps {{.*#+}} xmm1 = xmm1[2],xmm13[2],xmm1[3],xmm13[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm6[0]
; SSE-NEXT:    movdqa %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm15, %xmm2
; SSE-NEXT:    punpckldq {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = xmm2[0],mem[0],xmm2[1],mem[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps $197, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; SSE-NEXT:    # xmm15 = xmm15[1,1],mem[0,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm5[0],xmm4[1],xmm5[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm15[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm6, %xmm4
; SSE-NEXT:    unpckhps {{.*#+}} xmm4 = xmm4[2],xmm1[2],xmm4[3],xmm1[3]
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm5[2],xmm0[3],xmm5[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm0[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    movaps %xmm5, %xmm4
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = xmm4[0],mem[0],xmm4[1],mem[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm0[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm5[1,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    movaps %xmm5, %xmm6
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm6 = xmm6[0],xmm4[0],xmm6[1],xmm4[1]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm5, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm4[2],xmm0[3],xmm4[3]
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    unpckhps {{.*#+}} xmm4 = xmm4[2],xmm1[2],xmm4[3],xmm1[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm0[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm11, %xmm4
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm7[0],xmm4[1],xmm7[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm11, %xmm0
; SSE-NEXT:    shufps $197, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[0,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    movaps %xmm6, %xmm5
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    unpckhps {{.*#+}} xmm5 = xmm5[2],xmm1[2],xmm5[3],xmm1[3]
; SSE-NEXT:    movaps %xmm6, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm4[2],xmm0[3],xmm4[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm0[0]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm9, %xmm4
; SSE-NEXT:    punpckldq {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = xmm4[0],mem[0],xmm4[1],mem[1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm9[1,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    movaps %xmm6, %xmm5
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm6, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm4[2],xmm0[3],xmm4[3]
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    punpckhdq {{.*#+}} xmm4 = xmm4[2],xmm1[2],xmm4[3],xmm1[3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    movaps %xmm4, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm11[0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm15
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; SSE-NEXT:    # xmm15 = xmm15[0],mem[0],xmm15[1],mem[1]
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    shufps $197, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[0,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm13
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm13 = xmm13[0],xmm5[0],xmm13[1],xmm5[1]
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[0,1],xmm0[2,0]
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm4[2],xmm11[3],xmm4[3]
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm5[2],xmm0[3],xmm5[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm11 = xmm11[0],xmm0[0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    movaps %xmm8, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; SSE-NEXT:    movaps %xmm14, %xmm10
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Folded Reload
; SSE-NEXT:    # xmm10 = xmm10[0],mem[0],xmm10[1],mem[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm10 = xmm10[0],xmm0[0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm14[1,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm9
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm9 = xmm9[0],xmm5[0],xmm9[1],xmm5[1]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,1],xmm0[0,2]
; SSE-NEXT:    unpckhps {{.*#+}} xmm1 = xmm1[2],xmm5[2],xmm1[3],xmm5[3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm8 = xmm8[2],xmm4[2],xmm8[3],xmm4[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm1[0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    movaps %xmm4, %xmm7
; SSE-NEXT:    unpckhps {{.*#+}} xmm7 = xmm7[2],xmm3[2],xmm7[3],xmm3[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm3 = xmm3[0],xmm4[0]
; SSE-NEXT:    movaps 112(%rdi), %xmm5
; SSE-NEXT:    movaps %xmm5, %xmm6
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm6 = xmm6[0],xmm2[0],xmm6[1],xmm2[1]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm3[2,0]
; SSE-NEXT:    movaps %xmm5, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,3]
; SSE-NEXT:    movaps (%rsp), %xmm3 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,2],xmm0[2,0]
; SSE-NEXT:    movaps %xmm3, (%rsp) # 16-byte Spill
; SSE-NEXT:    movaps %xmm5, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,2],xmm0[0,1]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,1],xmm12[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[3,1],xmm1[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,0],xmm4[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],xmm0[2,0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm12[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Folded Reload
; SSE-NEXT:    # xmm12 = xmm12[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],xmm12[2,0]
; SSE-NEXT:    pshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[3,3,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,3],xmm0[2,0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm4 = xmm0[0],xmm4[1,2,3]
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,3],xmm1[2,0]
; SSE-NEXT:    pshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[3,3,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm0[0],xmm2[1,2,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,3],xmm0[2,0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm0[0],xmm2[1,2,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,3],xmm1[2,0]
; SSE-NEXT:    pshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[3,3,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm0[0],xmm2[1,2,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,3],xmm0[2,0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm0[0],xmm2[1,2,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,3],xmm1[2,0]
; SSE-NEXT:    pshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[3,3,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm0[0],xmm2[1,2,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,3],xmm0[2,0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm12 = xmm0[0],xmm12[1,2,3]
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,3],xmm1[2,0]
; SSE-NEXT:    pshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[3,3,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm3 = xmm0[0],xmm3[1,2,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,3],xmm0[2,0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm0[0],xmm2[1,2,3]
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[3,3],mem[3,3]
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],xmm0[2,0]
; SSE-NEXT:    pshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[3,3,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[0,3],xmm0[2,0]
; SSE-NEXT:    pshufd $238, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm14 = xmm0[0],xmm14[1,2,3]
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movaps %xmm5, 864(%rax)
; SSE-NEXT:    movaps %xmm7, 848(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 832(%rax)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 800(%rax)
; SSE-NEXT:    movaps %xmm6, 784(%rax)
; SSE-NEXT:    movaps %xmm8, 736(%rax)
; SSE-NEXT:    movaps %xmm9, 688(%rax)
; SSE-NEXT:    movaps %xmm10, 672(%rax)
; SSE-NEXT:    movaps %xmm11, 624(%rax)
; SSE-NEXT:    movaps %xmm13, 576(%rax)
; SSE-NEXT:    movaps %xmm15, 560(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 512(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 880(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 816(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 768(%rax)
; SSE-NEXT:    movaps %xmm14, 752(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 720(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 704(%rax)
; SSE-NEXT:    movaps %xmm1, 656(%rax)
; SSE-NEXT:    movaps %xmm2, 640(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 608(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 592(%rax)
; SSE-NEXT:    movaps %xmm3, 544(%rax)
; SSE-NEXT:    movaps %xmm12, 528(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 496(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rax)
; SSE-NEXT:    movaps %xmm4, 192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    addq $1256, %rsp # imm = 0x4E8
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i32_stride7_vf32:
; AVX:       # %bb.0:
; AVX-NEXT:    subq $1624, %rsp # imm = 0x658
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX-NEXT:    vmovaps 96(%rdi), %ymm4
; AVX-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 96(%rsi), %ymm3
; AVX-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 96(%rdx), %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 96(%rcx), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 96(%rax), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm3[1],ymm4[1],ymm3[3],ymm4[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm4[0,1],ymm1[2,0],ymm4[4,5],ymm1[6,4]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[2,3],ymm0[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = mem[2,3,2,3]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4,5,6],ymm1[7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm2[2,3],ymm0[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4],ymm1[5],ymm0[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps (%rax), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovaps (%r9), %xmm3
; AVX-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps (%r8), %xmm4
; AVX-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps (%rdi), %xmm2
; AVX-NEXT:    vmovaps (%rsi), %xmm5
; AVX-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm5[0],xmm2[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[2,0],xmm2[2,1]
; AVX-NEXT:    vmovaps %xmm2, %xmm6
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm1, %ymm1
; AVX-NEXT:    vmovaps (%rcx), %xmm8
; AVX-NEXT:    vmovaps (%rdx), %xmm9
; AVX-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm9[0],xmm8[0],xmm9[1],xmm8[1]
; AVX-NEXT:    vmovaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm2[0],ymm0[0],ymm2[2],ymm0[2]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6],ymm1[7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm3[1,1],xmm4[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5],ymm1[6,7]
; AVX-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm6[1],xmm5[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm5[1,1],xmm1[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm1, %ymm1
; AVX-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm9[1],xmm8[1],zero
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps (%rdi), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps (%rsi), %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,1],ymm1[1,1],ymm0[5,5],ymm1[5,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX-NEXT:    vmovaps (%rdx), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps (%rcx), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[1,1],ymm1[1,1],ymm2[5,5],ymm1[5,5]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX-NEXT:    vmovaps (%r8), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps (%r9), %ymm8
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm8[0],ymm2[0],ymm8[2],ymm2[2]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[2,0],ymm2[2,1],ymm1[6,4],ymm2[6,5]
; AVX-NEXT:    vmovaps (%rax), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],ymm1[2,3]
; AVX-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 32(%rdi), %xmm1
; AVX-NEXT:    vmovaps 32(%rsi), %xmm7
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm7[0],xmm1[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,1]
; AVX-NEXT:    vmovaps %xmm1, %xmm5
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovaps 32(%rcx), %xmm3
; AVX-NEXT:    vmovaps 32(%rdx), %xmm2
; AVX-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm2[0],xmm3[0],xmm2[1],xmm3[1]
; AVX-NEXT:    vmovaps %xmm3, %xmm6
; AVX-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps %xmm2, %xmm9
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovaps 32(%r9), %xmm3
; AVX-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 32(%r8), %xmm4
; AVX-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vmovaps 32(%rax), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6],ymm0[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm3[1,1],xmm4[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm2[5],ymm0[6,7]
; AVX-NEXT:    vmovaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm5[1],xmm7[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm7[1,1],xmm1[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm1, %ymm1
; AVX-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm9[1],xmm6[1],zero
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 32(%rsi), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[1,1],ymm0[1,1],ymm1[5,5],ymm0[5,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX-NEXT:    vmovaps 32(%rdx), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 32(%rcx), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[1,1],ymm1[1,1],ymm2[5,5],ymm1[5,5]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX-NEXT:    vmovaps 32(%r8), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 32(%r9), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[2,0],ymm2[2,1],ymm1[6,4],ymm2[6,5]
; AVX-NEXT:    vmovaps 32(%rax), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],ymm1[2,3]
; AVX-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 64(%rdi), %xmm1
; AVX-NEXT:    vmovaps 64(%rsi), %xmm7
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm7[0],xmm1[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,1]
; AVX-NEXT:    vmovaps %xmm1, %xmm6
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovaps 64(%rcx), %xmm4
; AVX-NEXT:    vmovaps 64(%rdx), %xmm2
; AVX-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm2[0],xmm4[0],xmm2[1],xmm4[1]
; AVX-NEXT:    vmovaps %xmm4, %xmm9
; AVX-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps %xmm2, %xmm10
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovaps 64(%r9), %xmm4
; AVX-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 64(%r8), %xmm5
; AVX-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vmovaps 64(%rax), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6],ymm0[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm4[1,1],xmm5[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm2[5],ymm0[6,7]
; AVX-NEXT:    vmovaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm6[1],xmm7[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm7[1,1],xmm1[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm1, %ymm1
; AVX-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm10[1],xmm9[1],zero
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 64(%rdi), %ymm14
; AVX-NEXT:    vmovaps 64(%rsi), %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,1],ymm14[1,1],ymm0[5,5],ymm14[5,5]
; AVX-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX-NEXT:    vmovaps 64(%rdx), %ymm2
; AVX-NEXT:    vmovaps 64(%rcx), %ymm9
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[1,1],ymm9[1,1],ymm2[5,5],ymm9[5,5]
; AVX-NEXT:    vmovups %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps %ymm2, %ymm13
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX-NEXT:    vmovaps 64(%r8), %ymm7
; AVX-NEXT:    vmovaps 64(%r9), %ymm10
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm10[0],ymm7[0],ymm10[2],ymm7[2]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[2,0],ymm7[2,1],ymm1[6,4],ymm7[6,5]
; AVX-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 64(%rax), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],ymm1[2,3]
; AVX-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 96(%rdi), %xmm6
; AVX-NEXT:    vmovaps 96(%rsi), %xmm2
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm2[0],xmm6[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,0],xmm6[2,1]
; AVX-NEXT:    vmovaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm11
; AVX-NEXT:    vmovaps 96(%rcx), %xmm4
; AVX-NEXT:    vmovaps 96(%rdx), %xmm3
; AVX-NEXT:    vunpcklps {{.*#+}} xmm12 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; AVX-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} xmm12 = xmm12[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm11[0,1],ymm12[2,3],ymm11[4,5,6,7]
; AVX-NEXT:    vmovaps 96(%r9), %xmm5
; AVX-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 96(%r8), %xmm11
; AVX-NEXT:    vmovaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpcklps {{.*#+}} xmm15 = xmm11[0],xmm5[0],xmm11[1],xmm5[1]
; AVX-NEXT:    vinsertf128 $1, %xmm15, %ymm0, %ymm15
; AVX-NEXT:    vinsertf128 $1, 96(%rax), %ymm0, %ymm0
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm15 = ymm15[0],ymm0[0],ymm15[2],ymm0[2]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm15[4,5,6],ymm1[7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm5[1,1],xmm11[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5],ymm1[6,7]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm6[1],xmm2[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm2[1,1],xmm1[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm1, %ymm1
; AVX-NEXT:    vinsertps {{.*#+}} xmm15 = zero,xmm3[1],xmm4[1],zero
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm15[1,2],ymm1[3,4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm5[1],ymm11[1],ymm5[3],ymm11[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,1,2,0,4,5,6,4]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm12[2],ymm4[2],ymm12[3],ymm4[3],ymm12[6],ymm4[6],ymm12[7],ymm4[7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm8[1],ymm1[3],ymm8[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm8[1,1],ymm1[0,2],ymm8[5,5],ymm1[4,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX-NEXT:    vmovaps 16(%rax), %xmm15
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm15[1],ymm1[2,3,4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = ymm1[1],mem[1],ymm1[3],mem[3]
; AVX-NEXT:    vmovaps %ymm1, %ymm6
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,1,2,0,4,5,6,4]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX-NEXT:    # ymm1 = ymm1[2],mem[2],ymm1[3],mem[3],ymm1[6],mem[6],ymm1[7],mem[7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[1,1],ymm1[0,2],ymm2[5,5],ymm1[4,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX-NEXT:    vmovaps 48(%rax), %xmm15
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm15[1],ymm1[2,3,4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm14[1],ymm0[3],ymm14[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,1,2,0,4,5,6,4]
; AVX-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm13[2],ymm9[2],ymm13[3],ymm9[3],ymm13[6],ymm9[6],ymm13[7],ymm9[7]
; AVX-NEXT:    vmovaps %ymm13, %ymm14
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX-NEXT:    vmovups %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm7[1],ymm10[1],ymm7[3],ymm10[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm10[1,1],ymm1[0,2],ymm10[5,5],ymm1[4,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX-NEXT:    vmovaps 80(%rax), %xmm15
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm15[1],ymm1[2,3,4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm3[3,3],ymm2[3,3],ymm3[7,7],ymm2[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Reload
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm8[3,3],ymm15[3,3],ymm8[7,7],ymm15[7,7]
; AVX-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX-NEXT:    vbroadcastss 124(%r8), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX-NEXT:    vbroadcastss 124(%r9), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX-NEXT:    vbroadcastsd 120(%rax), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4,5,6],ymm1[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps %ymm3, %ymm1
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX-NEXT:    vmovaps %ymm2, %ymm3
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[3,1],ymm0[0,2],ymm1[7,5],ymm0[4,6]
; AVX-NEXT:    vmovaps %ymm1, %ymm2
; AVX-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm8[0],ymm15[0],ymm8[1],ymm15[1],ymm8[4],ymm15[4],ymm8[5],ymm15[5]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX-NEXT:    vbroadcastss 108(%r8), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6,7]
; AVX-NEXT:    vbroadcastss 108(%r9), %xmm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = ymm0[0,1,2],mem[3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm3[1,1],ymm2[1,1],ymm3[5,5],ymm2[5,5]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm15[1,1],ymm8[1,1],ymm15[5,5],ymm8[5,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5,6],ymm1[7]
; AVX-NEXT:    vbroadcastsd 112(%r8), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4,5,6],ymm1[7]
; AVX-NEXT:    vbroadcastss 112(%r9), %xmm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6,7]
; AVX-NEXT:    vbroadcastss 112(%rax), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = xmm2[2],mem[2],xmm2[3],mem[3]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5,6],ymm1[7]
; AVX-NEXT:    vpermilps $170, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[2,2,2,2]
; AVX-NEXT:    vblendps $7, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[0,1,2],xmm1[3]
; AVX-NEXT:    vbroadcastsd 8(%rax), %ymm15
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm15[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4],ymm0[5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm4[3,3],ymm12[3,3],ymm4[7,7],ymm12[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm11[3,3],ymm5[3,3],ymm11[7,7],ymm5[7,7]
; AVX-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX-NEXT:    # ymm1 = ymm1[3,3],mem[3,3],ymm1[7,7],mem[7,7]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[2,3],ymm1[1,2],ymm2[6,7],ymm1[5,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,2,3,1,4,6,7,5]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = xmm2[2],mem[2],xmm2[3],mem[3]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5,6],ymm1[7]
; AVX-NEXT:    vpermilps $170, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[2,2,2,2]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX-NEXT:    vblendps {{.*#+}} xmm1 = xmm13[0,1,2],xmm1[3]
; AVX-NEXT:    vbroadcastsd 40(%rax), %ymm15
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm15[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4],ymm0[5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm11[3,3],ymm12[3,3],ymm11[7,7],ymm12[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm6, %ymm3
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm10[3,3],ymm6[3,3],ymm10[7,7],ymm6[7,7]
; AVX-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX-NEXT:    # ymm1 = ymm1[3,3],mem[3,3],ymm1[7,7],mem[7,7]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[2,3],ymm1[1,2],ymm2[6,7],ymm1[5,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,2,3,1,4,6,7,5]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = xmm2[2],mem[2],xmm2[3],mem[3]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5,6],ymm1[7]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm9[2,2,2,2]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX-NEXT:    vblendps {{.*#+}} xmm1 = xmm8[0,1,2],xmm1[3]
; AVX-NEXT:    vbroadcastsd 72(%rax), %ymm6
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm6[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4],ymm0[5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm14, %ymm7
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm6[3,3],ymm14[3,3],ymm6[7,7],ymm14[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm4[3,3],ymm14[3,3],ymm4[7,7],ymm14[7,7]
; AVX-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX-NEXT:    # ymm1 = ymm1[3,3],mem[3,3],ymm1[7,7],mem[7,7]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[2,3],ymm1[1,2],ymm2[6,7],ymm1[5,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,2,3,1,4,6,7,5]
; AVX-NEXT:    vblendps {{.*#+}} ymm15 = ymm1[0],ymm0[1,2,3,4],ymm1[5,6,7]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = xmm2[2],mem[2],xmm2[3],mem[3]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5,6],ymm1[7]
; AVX-NEXT:    vpermilps $170, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[2,2,2,2]
; AVX-NEXT:    vblendps $7, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[0,1,2],xmm1[3]
; AVX-NEXT:    vbroadcastsd 104(%rax), %ymm2
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4],ymm0[5,6,7]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm1[0],ymm5[0],ymm1[1],ymm5[1],ymm1[4],ymm5[4],ymm1[5],ymm5[5]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm2[0],ymm5[0],ymm2[2],ymm5[2]
; AVX-NEXT:    vshufps {{.*#+}} ymm2 = ymm5[3,1],ymm2[0,2],ymm5[7,5],ymm2[4,6]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5],ymm2[6,7]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm2 # 16-byte Folded Reload
; AVX-NEXT:    # xmm2 = xmm2[3,3],mem[3,3]
; AVX-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm2 # 16-byte Folded Reload
; AVX-NEXT:    # xmm2 = xmm2[0,1,2],mem[3]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vunpcklps {{.*#+}} ymm2 = ymm10[0],ymm3[0],ymm10[1],ymm3[1],ymm10[4],ymm3[4],ymm10[5],ymm3[5]
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm12[0],ymm11[0],ymm12[2],ymm11[2]
; AVX-NEXT:    vshufps {{.*#+}} ymm3 = ymm11[3,1],ymm3[0,2],ymm11[7,5],ymm3[4,6]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1,2,3],ymm2[4,5],ymm3[6,7]
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm13, %xmm3 # 16-byte Folded Reload
; AVX-NEXT:    # xmm3 = xmm13[3,3],mem[3,3]
; AVX-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX-NEXT:    # xmm3 = xmm3[0,1,2],mem[3]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm3[1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vunpcklps {{.*#+}} ymm3 = ymm4[0],ymm14[0],ymm4[1],ymm14[1],ymm4[4],ymm14[4],ymm4[5],ymm14[5]
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm7[0],ymm6[0],ymm7[2],ymm6[2]
; AVX-NEXT:    vshufps {{.*#+}} ymm5 = ymm6[3,1],ymm5[0,2],ymm6[7,5],ymm5[4,6]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm5[0,1,2,3],ymm3[4,5],ymm5[6,7]
; AVX-NEXT:    vshufps {{.*#+}} xmm5 = xmm8[3,3],xmm9[3,3]
; AVX-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm5 # 16-byte Folded Reload
; AVX-NEXT:    # xmm5 = xmm5[0,1,2],mem[3]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm5[1,2,3],ymm3[4,5,6,7]
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX-NEXT:    vmovaps %ymm3, 544(%rax)
; AVX-NEXT:    vmovaps %ymm2, 320(%rax)
; AVX-NEXT:    vmovaps %ymm1, 96(%rax)
; AVX-NEXT:    vmovaps %ymm0, 736(%rax)
; AVX-NEXT:    vmovaps %ymm15, 640(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 800(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 768(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, (%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 864(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 832(%rax)
; AVX-NEXT:    addq $1624, %rsp # imm = 0x658
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i32_stride7_vf32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    subq $1320, %rsp # imm = 0x528
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    vmovaps (%rax), %xmm0
; AVX2-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 32(%rax), %xmm3
; AVX2-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-NEXT:    vmovaps (%r8), %xmm14
; AVX2-NEXT:    vmovaps 32(%r8), %xmm7
; AVX2-NEXT:    vmovaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps (%r9), %xmm10
; AVX2-NEXT:    vmovaps 32(%r9), %xmm9
; AVX2-NEXT:    vmovaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm10[1,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],xmm14[1],xmm1[2,3]
; AVX2-NEXT:    vbroadcastsd %xmm1, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5],ymm1[6,7]
; AVX2-NEXT:    vmovaps (%rcx), %xmm12
; AVX2-NEXT:    vmovaps 32(%rcx), %xmm4
; AVX2-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps (%rdx), %xmm8
; AVX2-NEXT:    vinsertps {{.*#+}} xmm1 = zero,xmm8[1],xmm12[1],zero
; AVX2-NEXT:    vmovaps (%rdi), %xmm6
; AVX2-NEXT:    vmovaps 32(%rdi), %xmm11
; AVX2-NEXT:    vmovaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps (%rsi), %xmm5
; AVX2-NEXT:    vmovaps 32(%rsi), %xmm13
; AVX2-NEXT:    vmovaps %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm2 = xmm5[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0,1],xmm6[2],xmm2[3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1,2],ymm2[3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm9[1,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],xmm7[1],xmm1[2,3]
; AVX2-NEXT:    vbroadcastsd %xmm1, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5],ymm1[6,7]
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm13[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm11[2],xmm1[3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-NEXT:    vmovaps 32(%rdx), %xmm9
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm9[1],xmm4[1],zero
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%r8), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 64(%r9), %xmm0
; AVX2-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX2-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-NEXT:    vmovaps 64(%rax), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovaps 64(%rdi), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 64(%rsi), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm2[2],xmm1[3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-NEXT:    vmovaps 64(%rcx), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, (%rsp) # 16-byte Spill
; AVX2-NEXT:    vmovaps 64(%rdx), %xmm13
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm13[1],xmm2[1],zero
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 96(%r8), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 96(%r9), %xmm7
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm7[1,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX2-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-NEXT:    vmovaps 96(%rax), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovaps 96(%rdi), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 96(%rsi), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm2[2],xmm1[3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-NEXT:    vmovaps 96(%rcx), %xmm3
; AVX2-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 96(%rdx), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm2[1],xmm3[1],zero
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%rcx), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm2[2],ymm1[2],ymm2[3],ymm1[3],ymm2[6],ymm1[6],ymm2[7],ymm1[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vmovaps (%r8), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%r9), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-NEXT:    vmovaps 16(%rax), %xmm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%rsi), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovaps 32(%rdx), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%rcx), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vmovaps 32(%r8), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%r9), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-NEXT:    vmovaps 48(%rax), %xmm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%rdi), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%rsi), %ymm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovaps 64(%rdx), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%rcx), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vmovaps 64(%r8), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%r9), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-NEXT:    vmovaps 80(%rax), %xmm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 96(%rdi), %ymm3
; AVX2-NEXT:    vmovaps 96(%rsi), %ymm2
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm2[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm3[1],ymm0[2,3,4],ymm3[5],ymm0[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovaps 96(%rdx), %ymm4
; AVX2-NEXT:    vmovaps 96(%rcx), %ymm1
; AVX2-NEXT:    vshufps {{.*#+}} ymm15 = ymm4[1,1],ymm1[1,1],ymm4[5,5],ymm1[5,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm15[5,6],ymm0[7]
; AVX2-NEXT:    vbroadcastsd 112(%r8), %ymm15
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm15[0],ymm0[1,2,3,4,5,6],ymm15[7]
; AVX2-NEXT:    vbroadcastss 112(%r9), %xmm15
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm15[1],ymm0[2,3,4,5,6,7]
; AVX2-NEXT:    vbroadcastss 112(%rax), %ymm15
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm15[2],ymm0[3,4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vbroadcastss %xmm12, %xmm0
; AVX2-NEXT:    vbroadcastss %xmm8, %xmm15
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm15[0],xmm0[0],xmm15[1],xmm0[1]
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm15 = xmm6[0],xmm5[0],xmm6[1],xmm5[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm15 = xmm15[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm15[0,1],ymm0[2,3],ymm15[4,5,6,7]
; AVX2-NEXT:    vmovaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps %xmm14, %xmm11
; AVX2-NEXT:    vmovaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm15 = xmm14[0],xmm10[0],xmm14[1],xmm10[1]
; AVX2-NEXT:    vinsertf128 $1, %xmm15, %ymm0, %ymm15
; AVX2-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm14 = ymm15[0],ymm14[0],ymm15[2],ymm14[2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm14[4,5,6],ymm0[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm6[3,3],xmm5[3,3]
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm5 = xmm8[2],xmm12[2],xmm8[3],xmm12[3]
; AVX2-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1,2,3,4],ymm0[5,6],ymm5[7]
; AVX2-NEXT:    vshufps {{.*#+}} xmm5 = xmm10[2,2,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm5 = xmm11[0,1,2],xmm5[3]
; AVX2-NEXT:    vbroadcastsd 8(%rax), %ymm6
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm6[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm5[2,3,4],ymm0[5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX2-NEXT:    vbroadcastss %xmm8, %xmm0
; AVX2-NEXT:    vbroadcastss %xmm9, %xmm5
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm5[0],xmm0[0],xmm5[1],xmm0[1]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm10[0],xmm11[0],xmm10[1],xmm11[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1],ymm0[2,3],ymm5[4,5,6,7]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm14[0],xmm12[0],xmm14[1],xmm12[1]
; AVX2-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX2-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm5[0],ymm6[0],ymm5[2],ymm6[2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm5[4,5,6],ymm0[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm10[3,3],xmm11[3,3]
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm5 = xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX2-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1,2,3,4],ymm0[5,6],ymm5[7]
; AVX2-NEXT:    vshufps {{.*#+}} xmm5 = xmm12[2,2,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm5 = xmm14[0,1,2],xmm5[3]
; AVX2-NEXT:    vbroadcastsd 40(%rax), %ymm6
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm6[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm5[2,3,4],ymm0[5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%rsp), %xmm12 # 16-byte Reload
; AVX2-NEXT:    vbroadcastss %xmm12, %xmm0
; AVX2-NEXT:    vbroadcastss %xmm13, %xmm5
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm5[0],xmm0[0],xmm5[1],xmm0[1]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm11[0],xmm10[0],xmm11[1],xmm10[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1],ymm0[2,3],ymm5[4,5,6,7]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm9[0],xmm8[0],xmm9[1],xmm8[1]
; AVX2-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX2-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm5[0],ymm6[0],ymm5[2],ymm6[2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm5[4,5,6],ymm0[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm11[3,3],xmm10[3,3]
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm5 = xmm13[2],xmm12[2],xmm13[3],xmm12[3]
; AVX2-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1,2,3,4],ymm0[5,6],ymm5[7]
; AVX2-NEXT:    vshufps {{.*#+}} xmm5 = xmm8[2,2,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm5 = xmm9[0,1,2],xmm5[3]
; AVX2-NEXT:    vbroadcastsd 72(%rax), %ymm6
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm6[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm5[2,3,4],ymm0[5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; AVX2-NEXT:    vbroadcastss %xmm12, %xmm0
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; AVX2-NEXT:    vbroadcastss %xmm11, %xmm5
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm5[0],xmm0[0],xmm5[1],xmm0[1]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm10[0],xmm9[0],xmm10[1],xmm9[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1],ymm0[2,3],ymm5[4,5,6,7]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; AVX2-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX2-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm5[0],ymm6[0],ymm5[2],ymm6[2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm5[4,5,6],ymm0[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm10[3,3],xmm9[3,3]
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm5 = xmm11[2],xmm12[2],xmm11[3],xmm12[3]
; AVX2-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1,2,3,4],ymm0[5,6],ymm5[7]
; AVX2-NEXT:    vshufps {{.*#+}} xmm5 = xmm7[2,2,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm5 = xmm8[0,1,2],xmm5[3]
; AVX2-NEXT:    vbroadcastsd 104(%rax), %ymm6
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm6[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm5[2,3,4],ymm0[5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vbroadcastss 112(%rdx), %ymm0
; AVX2-NEXT:    vshufps {{.*#+}} ymm6 = ymm1[3,1,2,0,7,5,6,4]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1,2,3,4,5],ymm0[6],ymm6[7]
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm6 = ymm3[0],ymm2[0],ymm3[1],ymm2[1],ymm3[4],ymm2[4],ymm3[5],ymm2[5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm6[4,5],ymm0[6,7]
; AVX2-NEXT:    vbroadcastss 108(%r8), %ymm6
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm6[1],ymm0[2,3,4,5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} xmm6 = xmm7[2,2,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm6[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm6 = ymm3[2],ymm2[2],ymm3[3],ymm2[3],ymm3[6],ymm2[6],ymm3[7],ymm2[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[2,2,2,2]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm4[2],ymm1[2],ymm4[3],ymm1[3],ymm4[6],ymm1[6],ymm4[7],ymm1[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vpermilps {{.*#+}} ymm8 = mem[1,2,2,3,5,6,6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[2,2,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0],ymm6[1,2,3,4,5,6],ymm8[7]
; AVX2-NEXT:    vmovaps 96(%rax), %ymm9
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm9[3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm9[2,3],ymm7[2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm8[0],ymm0[1],ymm8[2,3,4],ymm0[5],ymm8[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm1[2],ymm4[2],ymm1[3],ymm4[3],ymm1[6],ymm4[6],ymm1[7],ymm4[7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm2[2],ymm3[2],ymm2[3],ymm3[3],ymm2[6],ymm3[6],ymm2[7],ymm3[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX2-NEXT:    vbroadcastss 124(%r8), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vbroadcastss 124(%r9), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vbroadcastsd 120(%rax), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4,5,6],ymm1[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm8[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm6[1],ymm1[2,3,4],ymm6[5],ymm1[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-NEXT:    vshufps {{.*#+}} ymm2 = ymm10[1,1],ymm5[1,1],ymm10[5,5],ymm5[5,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4],ymm2[5,6],ymm1[7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX2-NEXT:    vshufps {{.*#+}} ymm2 = ymm13[0,0,0,0,4,4,4,4]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-NEXT:    vshufps {{.*#+}} ymm3 = ymm11[0,1,0,1,4,5,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0],ymm2[1],ymm3[2,3,4],ymm2[5],ymm3[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[2,1,2,3]
; AVX2-NEXT:    vbroadcastsd 16(%rax), %ymm3
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2],ymm1[3,4,5,6],ymm2[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX2-NEXT:    vshufps {{.*#+}} ymm2 = ymm14[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm12[1],ymm2[2,3,4],ymm12[5],ymm2[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[2,2,2,2]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vshufps {{.*#+}} ymm3 = ymm0[1,1],ymm9[1,1],ymm0[5,5],ymm9[5,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4],ymm3[5,6],ymm2[7]
; AVX2-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm3 = mem[0,0,0,0,4,4,4,4]
; AVX2-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm4 = mem[0,1,0,1,4,5,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0],ymm3[1],ymm4[2,3,4],ymm3[5],ymm4[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[2,1,2,3]
; AVX2-NEXT:    vbroadcastsd 48(%rax), %ymm4
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm4[2,3],ymm3[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1,2],ymm2[3,4,5,6],ymm3[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermilps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm3 = mem[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vblendps $34, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm3 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm3 = ymm3[0],mem[1],ymm3[2,3,4],mem[5],ymm3[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[2,2,2,2]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Reload
; AVX2-NEXT:    vshufps {{.*#+}} ymm4 = ymm0[1,1],ymm15[1,1],ymm0[5,5],ymm15[5,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4],ymm4[5,6],ymm3[7]
; AVX2-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm4 = mem[0,0,0,0,4,4,4,4]
; AVX2-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm7 = mem[0,1,0,1,4,5,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm7[0],ymm4[1],ymm7[2,3,4],ymm4[5],ymm7[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[2,1,2,3]
; AVX2-NEXT:    vbroadcastsd 80(%rax), %ymm7
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm7[2,3],ymm4[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0,1,2],ymm3[3,4,5,6],ymm4[7]
; AVX2-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX2-NEXT:    vbroadcastss 16(%rdx), %ymm4
; AVX2-NEXT:    vshufps {{.*#+}} ymm7 = ymm5[3,1,2,0,7,5,6,4]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm7[0,1,2,3,4,5],ymm4[6],ymm7[7]
; AVX2-NEXT:    vmovaps %ymm6, %ymm1
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm6[0],ymm8[0],ymm6[1],ymm8[1],ymm6[4],ymm8[4],ymm6[5],ymm8[5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm7[4,5],ymm4[6,7]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX2-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm7 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm7 = xmm3[3,3],mem[3,3]
; AVX2-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm7 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm7 = xmm7[0,1,2],mem[3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm4[0],ymm7[1,2,3],ymm4[4,5,6,7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm4 = ymm5[2],ymm10[2],ymm5[3],ymm10[3],ymm5[6],ymm10[6],ymm5[7],ymm10[7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm8[2],ymm1[2],ymm8[3],ymm1[3],ymm8[6],ymm1[6],ymm8[7],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[3,3,3,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[3,3,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm7[0,1,2],ymm4[3,4,5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm7 = ymm11[3,3],ymm13[3,3],ymm11[7,7],ymm13[7,7]
; AVX2-NEXT:    vpermilps {{.*#+}} ymm10 = mem[2,3,2,3,6,7,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm10[0],ymm7[1,2],ymm10[3,4],ymm7[5,6],ymm10[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[2,1,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm10 = ymm7[0],ymm4[1,2,3,4],ymm7[5,6,7]
; AVX2-NEXT:    vbroadcastss 48(%rdx), %ymm4
; AVX2-NEXT:    vshufps {{.*#+}} ymm7 = ymm9[3,1,2,0,7,5,6,4]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm7[0,1,2,3,4,5],ymm4[6],ymm7[7]
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm12[0],ymm14[0],ymm12[1],ymm14[1],ymm12[4],ymm14[4],ymm12[5],ymm14[5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm7[4,5],ymm4[6,7]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX2-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm7 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm7 = xmm3[3,3],mem[3,3]
; AVX2-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm7 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm7 = xmm7[0,1,2],mem[3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0],ymm7[1,2,3],ymm4[4,5,6,7]
; AVX2-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm9, %ymm4 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm4 = ymm9[2],mem[2],ymm9[3],mem[3],ymm9[6],mem[6],ymm9[7],mem[7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm14[2],ymm12[2],ymm14[3],ymm12[3],ymm14[6],ymm12[6],ymm14[7],ymm12[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[3,3,3,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[3,3,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm7[0,1,2],ymm4[3,4,5,6,7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm7 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm7 = ymm0[3,3],mem[3,3],ymm0[7,7],mem[7,7]
; AVX2-NEXT:    vpermilps {{.*#+}} ymm12 = mem[2,3,2,3,6,7,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm12[0],ymm7[1,2],ymm12[3,4],ymm7[5,6],ymm12[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[2,1,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm7[0],ymm4[1,2,3,4],ymm7[5,6,7]
; AVX2-NEXT:    vbroadcastss 80(%rdx), %ymm7
; AVX2-NEXT:    vshufps {{.*#+}} ymm12 = ymm15[3,1,2,0,7,5,6,4]
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm12[0,1,2,3,4,5],ymm7[6],ymm12[7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm12 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm12[4,5],ymm7[6,7]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm12 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm12 = xmm5[3,3],mem[3,3]
; AVX2-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm12, %xmm12 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm12 = xmm12[0,1,2],mem[3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm12[1,2,3],ymm7[4,5,6,7]
; AVX2-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm15, %ymm12 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm12 = ymm15[2],mem[2],ymm15[3],mem[3],ymm15[6],mem[6],ymm15[7],mem[7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm13 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm12 = ymm12[3,3,3,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[3,3,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm12 = ymm13[0,1,2],ymm12[3,4,5,6,7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm13 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm13 = ymm0[3,3],mem[3,3],ymm0[7,7],mem[7,7]
; AVX2-NEXT:    vpermilps {{.*#+}} ymm15 = mem[2,3,2,3,6,7,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm13 = ymm15[0],ymm13[1,2],ymm15[3,4],ymm13[5,6],ymm15[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[2,1,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm12 = ymm13[0],ymm12[1,2,3,4],ymm13[5,6,7]
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    vmovaps %ymm12, 640(%rax)
; AVX2-NEXT:    vmovaps %ymm7, 544(%rax)
; AVX2-NEXT:    vmovaps %ymm4, 416(%rax)
; AVX2-NEXT:    vmovaps %ymm3, 320(%rax)
; AVX2-NEXT:    vmovaps %ymm10, 192(%rax)
; AVX2-NEXT:    vmovaps %ymm6, 96(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm4, 608(%rax)
; AVX2-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm3, 384(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm2, 160(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 864(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 832(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 768(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 736(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 800(%rax)
; AVX2-NEXT:    addq $1320, %rsp # imm = 0x528
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i32_stride7_vf32:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    subq $1320, %rsp # imm = 0x528
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FP-NEXT:    vmovaps (%rax), %xmm0
; AVX2-FP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rax), %xmm3
; AVX2-FP-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovaps (%r8), %xmm14
; AVX2-FP-NEXT:    vmovaps 32(%r8), %xmm7
; AVX2-FP-NEXT:    vmovaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps (%r9), %xmm10
; AVX2-FP-NEXT:    vmovaps 32(%r9), %xmm9
; AVX2-FP-NEXT:    vmovaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm1 = xmm10[1,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],xmm14[1],xmm1[2,3]
; AVX2-FP-NEXT:    vbroadcastsd %xmm1, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovaps (%rcx), %xmm12
; AVX2-FP-NEXT:    vmovaps 32(%rcx), %xmm4
; AVX2-FP-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rdx), %xmm8
; AVX2-FP-NEXT:    vinsertps {{.*#+}} xmm1 = zero,xmm8[1],xmm12[1],zero
; AVX2-FP-NEXT:    vmovaps (%rdi), %xmm6
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %xmm11
; AVX2-FP-NEXT:    vmovaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rsi), %xmm5
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %xmm13
; AVX2-FP-NEXT:    vmovaps %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm2 = xmm5[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0,1],xmm6[2],xmm2[3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1,2],ymm2[3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm1 = xmm9[1,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],xmm7[1],xmm1[2,3]
; AVX2-FP-NEXT:    vbroadcastsd %xmm1, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5],ymm1[6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm1 = xmm13[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm11[2],xmm1[3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FP-NEXT:    vmovaps 32(%rdx), %xmm9
; AVX2-FP-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm9[1],xmm4[1],zero
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%r8), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%r9), %xmm0
; AVX2-FP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-FP-NEXT:    vmovaps 64(%rax), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovaps 64(%rdi), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rsi), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm2[2],xmm1[3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FP-NEXT:    vmovaps 64(%rcx), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, (%rsp) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rdx), %xmm13
; AVX2-FP-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm13[1],xmm2[1],zero
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%r8), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%r9), %xmm7
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm0 = xmm7[1,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-FP-NEXT:    vmovaps 96(%rax), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%rsi), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm2[2],xmm1[3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FP-NEXT:    vmovaps 96(%rcx), %xmm3
; AVX2-FP-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%rdx), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm2[1],xmm3[1],zero
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rcx), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm2[2],ymm1[2],ymm2[3],ymm1[3],ymm2[6],ymm1[6],ymm2[7],ymm1[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps (%r8), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%r9), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FP-NEXT:    vmovaps 16(%rax), %xmm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps 32(%rdx), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rcx), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps 32(%r8), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%r9), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FP-NEXT:    vmovaps 48(%rax), %xmm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rsi), %ymm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps 64(%rdx), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rcx), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps 64(%r8), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%r9), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FP-NEXT:    vmovaps 80(%rax), %xmm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %ymm3
; AVX2-FP-NEXT:    vmovaps 96(%rsi), %ymm2
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm2[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm3[1],ymm0[2,3,4],ymm3[5],ymm0[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps 96(%rdx), %ymm4
; AVX2-FP-NEXT:    vmovaps 96(%rcx), %ymm1
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm15 = ymm4[1,1],ymm1[1,1],ymm4[5,5],ymm1[5,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm15[5,6],ymm0[7]
; AVX2-FP-NEXT:    vbroadcastsd 112(%r8), %ymm15
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm15[0],ymm0[1,2,3,4,5,6],ymm15[7]
; AVX2-FP-NEXT:    vbroadcastss 112(%r9), %xmm15
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm15[1],ymm0[2,3,4,5,6,7]
; AVX2-FP-NEXT:    vbroadcastss 112(%rax), %ymm15
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm15[2],ymm0[3,4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vbroadcastss %xmm12, %xmm0
; AVX2-FP-NEXT:    vbroadcastss %xmm8, %xmm15
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm15[0],xmm0[0],xmm15[1],xmm0[1]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm15 = xmm6[0],xmm5[0],xmm6[1],xmm5[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm15 = xmm15[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm15[0,1],ymm0[2,3],ymm15[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps %xmm14, %xmm11
; AVX2-FP-NEXT:    vmovaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm15 = xmm14[0],xmm10[0],xmm14[1],xmm10[1]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm15, %ymm0, %ymm15
; AVX2-FP-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm14 = ymm15[0],ymm14[0],ymm15[2],ymm14[2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm14[4,5,6],ymm0[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm0 = xmm6[3,3],xmm5[3,3]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm5 = xmm8[2],xmm12[2],xmm8[3],xmm12[3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1,2,3,4],ymm0[5,6],ymm5[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm5 = xmm10[2,2,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm5 = xmm11[0,1,2],xmm5[3]
; AVX2-FP-NEXT:    vbroadcastsd 8(%rax), %ymm6
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm6[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm5[2,3,4],ymm0[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX2-FP-NEXT:    vbroadcastss %xmm8, %xmm0
; AVX2-FP-NEXT:    vbroadcastss %xmm9, %xmm5
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm5[0],xmm0[0],xmm5[1],xmm0[1]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm10[0],xmm11[0],xmm10[1],xmm11[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1],ymm0[2,3],ymm5[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm14[0],xmm12[0],xmm14[1],xmm12[1]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX2-FP-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm5[0],ymm6[0],ymm5[2],ymm6[2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm5[4,5,6],ymm0[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm0 = xmm10[3,3],xmm11[3,3]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm5 = xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1,2,3,4],ymm0[5,6],ymm5[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm5 = xmm12[2,2,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm5 = xmm14[0,1,2],xmm5[3]
; AVX2-FP-NEXT:    vbroadcastsd 40(%rax), %ymm6
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm6[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm5[2,3,4],ymm0[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rsp), %xmm12 # 16-byte Reload
; AVX2-FP-NEXT:    vbroadcastss %xmm12, %xmm0
; AVX2-FP-NEXT:    vbroadcastss %xmm13, %xmm5
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm5[0],xmm0[0],xmm5[1],xmm0[1]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm11[0],xmm10[0],xmm11[1],xmm10[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1],ymm0[2,3],ymm5[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm9[0],xmm8[0],xmm9[1],xmm8[1]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX2-FP-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm5[0],ymm6[0],ymm5[2],ymm6[2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm5[4,5,6],ymm0[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm0 = xmm11[3,3],xmm10[3,3]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm5 = xmm13[2],xmm12[2],xmm13[3],xmm12[3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1,2,3,4],ymm0[5,6],ymm5[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm5 = xmm8[2,2,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm5 = xmm9[0,1,2],xmm5[3]
; AVX2-FP-NEXT:    vbroadcastsd 72(%rax), %ymm6
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm6[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm5[2,3,4],ymm0[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; AVX2-FP-NEXT:    vbroadcastss %xmm12, %xmm0
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; AVX2-FP-NEXT:    vbroadcastss %xmm11, %xmm5
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm5[0],xmm0[0],xmm5[1],xmm0[1]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm10[0],xmm9[0],xmm10[1],xmm9[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1],ymm0[2,3],ymm5[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX2-FP-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm5[0],ymm6[0],ymm5[2],ymm6[2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm5[4,5,6],ymm0[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm0 = xmm10[3,3],xmm9[3,3]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm5 = xmm11[2],xmm12[2],xmm11[3],xmm12[3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1,2,3,4],ymm0[5,6],ymm5[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm5 = xmm7[2,2,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm5 = xmm8[0,1,2],xmm5[3]
; AVX2-FP-NEXT:    vbroadcastsd 104(%rax), %ymm6
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm6[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm5[2,3,4],ymm0[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vbroadcastss 112(%rdx), %ymm0
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm6 = ymm1[3,1,2,0,7,5,6,4]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1,2,3,4,5],ymm0[6],ymm6[7]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm6 = ymm3[0],ymm2[0],ymm3[1],ymm2[1],ymm3[4],ymm2[4],ymm3[5],ymm2[5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm6[4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vbroadcastss 108(%r8), %ymm6
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm6[1],ymm0[2,3,4,5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm6 = xmm7[2,2,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm6[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm6 = ymm3[2],ymm2[2],ymm3[3],ymm2[3],ymm3[6],ymm2[6],ymm3[7],ymm2[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[2,2,2,2]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm4[2],ymm1[2],ymm4[3],ymm1[3],ymm4[6],ymm1[6],ymm4[7],ymm1[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vpermilps {{.*#+}} ymm8 = mem[1,2,2,3,5,6,6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[2,2,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0],ymm6[1,2,3,4,5,6],ymm8[7]
; AVX2-FP-NEXT:    vmovaps 96(%rax), %ymm9
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm9[3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm9[2,3],ymm7[2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm8[0],ymm0[1],ymm8[2,3,4],ymm0[5],ymm8[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm1[2],ymm4[2],ymm1[3],ymm4[3],ymm1[6],ymm4[6],ymm1[7],ymm4[7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm2[2],ymm3[2],ymm2[3],ymm3[3],ymm2[6],ymm3[6],ymm2[7],ymm3[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX2-FP-NEXT:    vbroadcastss 124(%r8), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vbroadcastss 124(%r9), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vbroadcastsd 120(%rax), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4,5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm8[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm6[1],ymm1[2,3,4],ymm6[5],ymm1[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm2 = ymm10[1,1],ymm5[1,1],ymm10[5,5],ymm5[5,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4],ymm2[5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm2 = ymm13[0,0,0,0,4,4,4,4]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm3 = ymm11[0,1,0,1,4,5,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0],ymm2[1],ymm3[2,3,4],ymm2[5],ymm3[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[2,1,2,3]
; AVX2-FP-NEXT:    vbroadcastsd 16(%rax), %ymm3
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2],ymm1[3,4,5,6],ymm2[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm2 = ymm14[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm12[1],ymm2[2,3,4],ymm12[5],ymm2[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[2,2,2,2]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm3 = ymm0[1,1],ymm9[1,1],ymm0[5,5],ymm9[5,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4],ymm3[5,6],ymm2[7]
; AVX2-FP-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm3 = mem[0,0,0,0,4,4,4,4]
; AVX2-FP-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm4 = mem[0,1,0,1,4,5,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0],ymm3[1],ymm4[2,3,4],ymm3[5],ymm4[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[2,1,2,3]
; AVX2-FP-NEXT:    vbroadcastsd 48(%rax), %ymm4
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm4[2,3],ymm3[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1,2],ymm2[3,4,5,6],ymm3[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermilps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm3 = mem[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vblendps $34, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm3 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm3 = ymm3[0],mem[1],ymm3[2,3,4],mem[5],ymm3[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[2,2,2,2]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm4 = ymm0[1,1],ymm15[1,1],ymm0[5,5],ymm15[5,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4],ymm4[5,6],ymm3[7]
; AVX2-FP-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm4 = mem[0,0,0,0,4,4,4,4]
; AVX2-FP-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm7 = mem[0,1,0,1,4,5,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm7[0],ymm4[1],ymm7[2,3,4],ymm4[5],ymm7[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[2,1,2,3]
; AVX2-FP-NEXT:    vbroadcastsd 80(%rax), %ymm7
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm7[2,3],ymm4[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0,1,2],ymm3[3,4,5,6],ymm4[7]
; AVX2-FP-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX2-FP-NEXT:    vbroadcastss 16(%rdx), %ymm4
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm7 = ymm5[3,1,2,0,7,5,6,4]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm7[0,1,2,3,4,5],ymm4[6],ymm7[7]
; AVX2-FP-NEXT:    vmovaps %ymm6, %ymm1
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm6[0],ymm8[0],ymm6[1],ymm8[1],ymm6[4],ymm8[4],ymm6[5],ymm8[5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm7[4,5],ymm4[6,7]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX2-FP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm7 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm7 = xmm3[3,3],mem[3,3]
; AVX2-FP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm7 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm7 = xmm7[0,1,2],mem[3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm4[0],ymm7[1,2,3],ymm4[4,5,6,7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm4 = ymm5[2],ymm10[2],ymm5[3],ymm10[3],ymm5[6],ymm10[6],ymm5[7],ymm10[7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm8[2],ymm1[2],ymm8[3],ymm1[3],ymm8[6],ymm1[6],ymm8[7],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[3,3,3,3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[3,3,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm7[0,1,2],ymm4[3,4,5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm7 = ymm11[3,3],ymm13[3,3],ymm11[7,7],ymm13[7,7]
; AVX2-FP-NEXT:    vpermilps {{.*#+}} ymm10 = mem[2,3,2,3,6,7,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm10[0],ymm7[1,2],ymm10[3,4],ymm7[5,6],ymm10[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[2,1,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm10 = ymm7[0],ymm4[1,2,3,4],ymm7[5,6,7]
; AVX2-FP-NEXT:    vbroadcastss 48(%rdx), %ymm4
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm7 = ymm9[3,1,2,0,7,5,6,4]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm7[0,1,2,3,4,5],ymm4[6],ymm7[7]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm12[0],ymm14[0],ymm12[1],ymm14[1],ymm12[4],ymm14[4],ymm12[5],ymm14[5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm7[4,5],ymm4[6,7]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX2-FP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm7 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm7 = xmm3[3,3],mem[3,3]
; AVX2-FP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm7 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm7 = xmm7[0,1,2],mem[3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0],ymm7[1,2,3],ymm4[4,5,6,7]
; AVX2-FP-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm9, %ymm4 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm4 = ymm9[2],mem[2],ymm9[3],mem[3],ymm9[6],mem[6],ymm9[7],mem[7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm14[2],ymm12[2],ymm14[3],ymm12[3],ymm14[6],ymm12[6],ymm14[7],ymm12[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[3,3,3,3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[3,3,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm7[0,1,2],ymm4[3,4,5,6,7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm7 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm7 = ymm0[3,3],mem[3,3],ymm0[7,7],mem[7,7]
; AVX2-FP-NEXT:    vpermilps {{.*#+}} ymm12 = mem[2,3,2,3,6,7,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm12[0],ymm7[1,2],ymm12[3,4],ymm7[5,6],ymm12[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[2,1,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm7[0],ymm4[1,2,3,4],ymm7[5,6,7]
; AVX2-FP-NEXT:    vbroadcastss 80(%rdx), %ymm7
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm12 = ymm15[3,1,2,0,7,5,6,4]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm12[0,1,2,3,4,5],ymm7[6],ymm12[7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm12 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm12[4,5],ymm7[6,7]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-FP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm12 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm12 = xmm5[3,3],mem[3,3]
; AVX2-FP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm12, %xmm12 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm12 = xmm12[0,1,2],mem[3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm12[1,2,3],ymm7[4,5,6,7]
; AVX2-FP-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm15, %ymm12 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm12 = ymm15[2],mem[2],ymm15[3],mem[3],ymm15[6],mem[6],ymm15[7],mem[7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm13 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm12 = ymm12[3,3,3,3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[3,3,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm12 = ymm13[0,1,2],ymm12[3,4,5,6,7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm13 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm13 = ymm0[3,3],mem[3,3],ymm0[7,7],mem[7,7]
; AVX2-FP-NEXT:    vpermilps {{.*#+}} ymm15 = mem[2,3,2,3,6,7,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm13 = ymm15[0],ymm13[1,2],ymm15[3,4],ymm13[5,6],ymm15[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[2,1,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm12 = ymm13[0],ymm12[1,2,3,4],ymm13[5,6,7]
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FP-NEXT:    vmovaps %ymm12, 640(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm7, 544(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm4, 416(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm3, 320(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm10, 192(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm6, 96(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm4, 608(%rax)
; AVX2-FP-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm3, 384(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm2, 160(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 864(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 832(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 768(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 736(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 800(%rax)
; AVX2-FP-NEXT:    addq $1320, %rsp # imm = 0x528
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i32_stride7_vf32:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    subq $1416, %rsp # imm = 0x588
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FCP-NEXT:    vmovaps (%rax), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rax), %xmm3
; AVX2-FCP-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps (%r8), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%r8), %xmm4
; AVX2-FCP-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%r9), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%r9), %xmm5
; AVX2-FCP-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1,1,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd %xmm1, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovaps (%rcx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rcx), %xmm6
; AVX2-FCP-NEXT:    vmovaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rdx), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vinsertps {{.*#+}} xmm1 = zero,xmm1[1],xmm2[1],zero
; AVX2-FCP-NEXT:    vmovaps (%rdi), %xmm9
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %xmm7
; AVX2-FCP-NEXT:    vmovaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rsi), %xmm11
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %xmm8
; AVX2-FCP-NEXT:    vmovaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm2 = xmm11[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0,1],xmm9[2],xmm2[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1,2],ymm2[3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm5[1,1,1,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],xmm4[1],xmm1[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd %xmm1, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5],ymm1[6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm8[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm7[2],xmm1[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FCP-NEXT:    vmovaps 32(%rdx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm2[1],xmm6[1],zero
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%r8), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%r9), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps 64(%rax), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps 64(%rdi), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%rsi), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm2[2],xmm1[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FCP-NEXT:    vmovaps 64(%rcx), %xmm3
; AVX2-FCP-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%rdx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm2[1],xmm3[1],zero
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%r8), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%r9), %xmm2
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm0 = xmm2[1,1,1,1]
; AVX2-FCP-NEXT:    vmovaps %xmm2, %xmm7
; AVX2-FCP-NEXT:    vmovaps %xmm2, (%rsp) # 16-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps 96(%rax), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rsi), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm2[2],xmm1[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FCP-NEXT:    vmovaps 96(%rcx), %xmm3
; AVX2-FCP-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rdx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm2[1],xmm3[1],zero
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rsi), %ymm13
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm13[2],ymm0[3],ymm13[3],ymm0[6],ymm13[6],ymm0[7],ymm13[7]
; AVX2-FCP-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps (%rdx), %ymm6
; AVX2-FCP-NEXT:    vmovaps (%rcx), %ymm10
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm6[2],ymm10[2],ymm6[3],ymm10[3],ymm6[6],ymm10[6],ymm6[7],ymm10[7]
; AVX2-FCP-NEXT:    vmovups %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps (%r8), %ymm2
; AVX2-FCP-NEXT:    vmovaps (%r9), %ymm3
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm3[1,1,2,2,5,5,6,6]
; AVX2-FCP-NEXT:    vmovaps %ymm3, %ymm14
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-FCP-NEXT:    vmovaps %ymm2, %ymm8
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FCP-NEXT:    vmovaps 16(%rax), %xmm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %ymm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps 32(%rdx), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rcx), %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps 32(%r8), %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%r9), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FCP-NEXT:    vmovaps 48(%rax), %xmm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps 64(%rdx), %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%rcx), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm2[2],ymm1[2],ymm2[3],ymm1[3],ymm2[6],ymm1[6],ymm2[7],ymm1[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps 64(%r8), %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%r9), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FCP-NEXT:    vmovaps 80(%rax), %xmm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %ymm4
; AVX2-FCP-NEXT:    vmovaps 96(%rsi), %ymm2
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm2[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm4[1],ymm0[2,3,4],ymm4[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps 96(%rdx), %ymm5
; AVX2-FCP-NEXT:    vmovaps 96(%rcx), %ymm1
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm15 = ymm5[1,1],ymm1[1,1],ymm5[5,5],ymm1[5,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4],ymm15[5,6],ymm3[7]
; AVX2-FCP-NEXT:    vbroadcastsd 112(%r8), %ymm15
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm15[0],ymm3[1,2,3,4,5,6],ymm15[7]
; AVX2-FCP-NEXT:    vbroadcastss 112(%r9), %xmm15
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm15[1],ymm3[2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vbroadcastss 112(%rax), %ymm15
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1],ymm15[2],ymm3[3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vbroadcastss 112(%rdx), %ymm3
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm15 = ymm1[3,1,2,0,7,5,6,4]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm15[0,1,2,3,4,5],ymm3[6],ymm15[7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm15 = ymm4[0],ymm2[0],ymm4[1],ymm2[1],ymm4[4],ymm2[4],ymm4[5],ymm2[5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm15[4,5],ymm3[6,7]
; AVX2-FCP-NEXT:    vbroadcastss 108(%r8), %ymm15
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm15[1],ymm3[2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm15 = xmm7[2,2,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm15[2,3],ymm3[4,5,6,7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm15 = ymm4[2],ymm2[2],ymm4[3],ymm2[3],ymm4[6],ymm2[6],ymm4[7],ymm2[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[2,2,2,2]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm5[2],ymm1[2],ymm5[3],ymm1[3],ymm5[6],ymm1[6],ymm5[7],ymm1[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm15 = ymm15[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm15 = ymm15[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vbroadcastsd {{.*#+}} ymm12 = [5,6,5,6,5,6,5,6]
; AVX2-FCP-NEXT:    vpermps 96(%r9), %ymm12, %ymm12
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0],ymm15[1,2,3,4,5,6],ymm12[7]
; AVX2-FCP-NEXT:    vmovaps 96(%rax), %ymm15
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2],ymm15[3],ymm3[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm15[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm12[0],ymm0[1],ymm12[2,3,4],ymm0[5],ymm12[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm1[2],ymm5[2],ymm1[3],ymm5[3],ymm1[6],ymm5[6],ymm1[7],ymm5[7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm2[2],ymm4[2],ymm2[3],ymm4[3],ymm2[6],ymm4[6],ymm2[7],ymm4[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX2-FCP-NEXT:    vbroadcastss 124(%r8), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vbroadcastss 124(%r9), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 120(%rax), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4,5,6],ymm1[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; AVX2-FCP-NEXT:    vbroadcastss %xmm12, %xmm0
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX2-FCP-NEXT:    vbroadcastss %xmm7, %xmm1
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-FCP-NEXT:    vmovaps %xmm11, %xmm15
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm9[0],xmm11[0],xmm9[1],xmm11[1]
; AVX2-FCP-NEXT:    vbroadcastf128 {{.*#+}} ymm11 = [0,1,2,2,0,1,2,2]
; AVX2-FCP-NEXT:    # ymm11 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpermps %ymm2, %ymm11, %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm4[0],xmm5[0],xmm4[1],xmm5[1]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX2-FCP-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm2[4,5,6],ymm1[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm9[3,3],xmm15[3,3]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm7[2],xmm12[2],xmm7[3],xmm12[3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vpermps %ymm2, %ymm11, %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3,4],ymm1[5,6],ymm2[7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm2 = xmm5[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps %xmm5, %xmm9
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm2 = xmm4[0,1,2],xmm2[3]
; AVX2-FCP-NEXT:    vbroadcastsd 8(%rax), %ymm3
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm2[2,3,4],ymm1[5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm13[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vblendps $34, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm1 = ymm1[0],mem[1],ymm1[2,3,4],mem[5],ymm1[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm2 = ymm6[1,1],ymm10[1,1],ymm6[5,5],ymm10[5,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4],ymm2[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm2 = ymm14[0,0,0,0,4,4,4,4]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm3 = ymm8[0,1,0,1,4,5,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0],ymm2[1],ymm3[2,3,4],ymm2[5],ymm3[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[2,1,2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 16(%rax), %ymm3
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2],ymm1[3,4,5,6],ymm2[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FCP-NEXT:    vbroadcastss %xmm0, %xmm1
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX2-FCP-NEXT:    vbroadcastss %xmm6, %xmm2
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm4[0],xmm5[0],xmm4[1],xmm5[1]
; AVX2-FCP-NEXT:    vpermps %ymm2, %ymm11, %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX2-FCP-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6],ymm1[7]
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm4[3,3],xmm5[3,3]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm6[2],xmm0[2],xmm6[3],xmm0[3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vpermps %ymm2, %ymm11, %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3,4],ymm1[5,6],ymm2[7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm2 = xmm7[2,2,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm2 = xmm8[0,1,2],xmm2[3]
; AVX2-FCP-NEXT:    vbroadcastsd 40(%rax), %ymm3
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm2[2,3,4],ymm1[5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermilps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm1 = mem[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vblendps $34, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm1 = ymm1[0],mem[1],ymm1[2,3,4],mem[5],ymm1[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm2 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm2 = ymm0[1,1],mem[1,1],ymm0[5,5],mem[5,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4],ymm2[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm2 = mem[0,0,0,0,4,4,4,4]
; AVX2-FCP-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm3 = mem[0,1,0,1,4,5,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0],ymm2[1],ymm3[2,3,4],ymm2[5],ymm3[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[2,1,2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 48(%rax), %ymm3
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2],ymm1[3,4,5,6],ymm2[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX2-FCP-NEXT:    vbroadcastss %xmm8, %xmm1
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX2-FCP-NEXT:    vbroadcastss %xmm7, %xmm2
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm4[0],xmm0[0],xmm4[1],xmm0[1]
; AVX2-FCP-NEXT:    vpermps %ymm2, %ymm11, %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm5[0],xmm6[0],xmm5[1],xmm6[1]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX2-FCP-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6],ymm1[7]
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm4[3,3],xmm0[3,3]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm7[2],xmm8[2],xmm7[3],xmm8[3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vpermps %ymm2, %ymm11, %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3,4],ymm1[5,6],ymm2[7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm2 = xmm6[2,2,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm2 = xmm5[0,1,2],xmm2[3]
; AVX2-FCP-NEXT:    vbroadcastsd 72(%rax), %ymm3
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm2[2,3,4],ymm1[5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm12[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm14[1],ymm1[2,3,4],ymm14[5],ymm1[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm2 = ymm13[1,1],ymm10[1,1],ymm13[5,5],ymm10[5,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4],ymm2[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm2 = mem[0,0,0,0,4,4,4,4]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm3 = ymm15[0,1,0,1,4,5,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0],ymm2[1],ymm3[2,3,4],ymm2[5],ymm3[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[2,1,2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 80(%rax), %ymm3
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2],ymm1[3,4,5,6],ymm2[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX2-FCP-NEXT:    vbroadcastss %xmm7, %xmm1
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX2-FCP-NEXT:    vbroadcastss %xmm6, %xmm3
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX2-FCP-NEXT:    vpermps %ymm3, %ymm11, %ymm3
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm3[0,1],ymm2[2,3],ymm3[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-FCP-NEXT:    vmovaps (%rsp), %xmm2 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm5[0],xmm2[0],xmm5[1],xmm2[1]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX2-FCP-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm3[0],ymm4[0],ymm3[2],ymm4[2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm8[0,1,2,3],ymm3[4,5,6],ymm8[7]
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm3 = xmm0[3,3],xmm1[3,3]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm4 = xmm6[2],xmm7[2],xmm6[3],xmm7[3]
; AVX2-FCP-NEXT:    vpermps %ymm4, %ymm11, %ymm4
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm7 = ymm4[0,1,2,3,4],ymm3[5,6],ymm4[7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm3 = xmm2[2,2,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm3 = xmm5[0,1,2],xmm3[3]
; AVX2-FCP-NEXT:    vbroadcastsd 104(%rax), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm4[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1],ymm3[2,3,4],ymm7[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastss 16(%rdx), %ymm3
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm4 = ymm0[3,1,2,0,7,5,6,4]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1,2,3,4,5],ymm3[6],ymm4[7]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm4 = ymm1[0],ymm7[0],ymm1[1],ymm7[1],ymm1[4],ymm7[4],ymm1[5],ymm7[5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm4[4,5],ymm3[6,7]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm4 = xmm2[3,3],xmm9[3,3]
; AVX2-FCP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4, %xmm4 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm4 = xmm4[0,1,2],mem[3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0],ymm4[1,2,3],ymm3[4,5,6,7]
; AVX2-FCP-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm3 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm3 = ymm0[2],mem[2],ymm0[3],mem[3],ymm0[6],mem[6],ymm0[7],mem[7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm4 = ymm7[2],ymm1[2],ymm7[3],ymm1[3],ymm7[6],ymm1[6],ymm7[7],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[3,3,3,3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[3,3,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1,2],ymm3[3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm4 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm4 = ymm0[3,3],mem[3,3],ymm0[7,7],mem[7,7]
; AVX2-FCP-NEXT:    vpermilps {{.*#+}} ymm7 = mem[2,3,2,3,6,7,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm7[0],ymm4[1,2],ymm7[3,4],ymm4[5,6],ymm7[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[2,1,2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0],ymm3[1,2,3,4],ymm4[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastss 48(%rdx), %ymm4
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm7 = ymm0[3,1,2,0,7,5,6,4]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm7[0,1,2,3,4,5],ymm4[6],ymm7[7]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm9[0],ymm1[0],ymm9[1],ymm1[1],ymm9[4],ymm1[4],ymm9[5],ymm1[5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm7[4,5],ymm4[6,7]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-FCP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm7 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm7 = xmm5[3,3],mem[3,3]
; AVX2-FCP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm7 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm7 = xmm7[0,1,2],mem[3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm7[1,2,3],ymm4[4,5,6,7]
; AVX2-FCP-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm7 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm7 = ymm0[2],mem[2],ymm0[3],mem[3],ymm0[6],mem[6],ymm0[7],mem[7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm8 = ymm1[2],ymm9[2],ymm1[3],ymm9[3],ymm1[6],ymm9[6],ymm1[7],ymm9[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[3,3,3,3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[3,3,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0,1,2],ymm7[3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm8 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm8 = ymm0[3,3],mem[3,3],ymm0[7,7],mem[7,7]
; AVX2-FCP-NEXT:    vpermilps {{.*#+}} ymm9 = mem[2,3,2,3,6,7,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0],ymm8[1,2],ymm9[3,4],ymm8[5,6],ymm9[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[2,1,2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0],ymm7[1,2,3,4],ymm8[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastss 80(%rdx), %ymm8
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm9 = ymm10[3,1,2,0,7,5,6,4]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0,1,2,3,4,5],ymm8[6],ymm9[7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm9 = ymm14[0],ymm12[0],ymm14[1],ymm12[1],ymm14[4],ymm12[4],ymm14[5],ymm12[5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm9[4,5],ymm8[6,7]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FCP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm9 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm9 = xmm0[3,3],mem[3,3]
; AVX2-FCP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm9, %xmm9 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm9 = xmm9[0,1,2],mem[3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0],ymm9[1,2,3],ymm8[4,5,6,7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm9 = ymm10[2],ymm13[2],ymm10[3],ymm13[3],ymm10[6],ymm13[6],ymm10[7],ymm13[7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm10 = ymm12[2],ymm14[2],ymm12[3],ymm14[3],ymm12[6],ymm14[6],ymm12[7],ymm14[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[3,3,3,3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[3,3,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0,1,2],ymm9[3,4,5,6,7]
; AVX2-FCP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15, %ymm10 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm10 = ymm15[3,3],mem[3,3],ymm15[7,7],mem[7,7]
; AVX2-FCP-NEXT:    vpermilps {{.*#+}} ymm11 = mem[2,3,2,3,6,7,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm10 = ymm11[0],ymm10[1,2],ymm11[3,4],ymm10[5,6],ymm11[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[2,1,2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0],ymm9[1,2,3,4],ymm10[5,6,7]
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FCP-NEXT:    vmovaps %ymm9, 640(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm8, 544(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm7, 416(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm4, 320(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm3, 192(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm2, 96(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm6, 736(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 864(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 832(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 768(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 800(%rax)
; AVX2-FCP-NEXT:    addq $1416, %rsp # imm = 0x588
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride7_vf32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    pushq %rax
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm14
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm18
; AVX512-NEXT:    vmovdqa64 (%rsi), %zmm8
; AVX512-NEXT:    vmovdqa64 64(%rsi), %zmm12
; AVX512-NEXT:    vmovdqa64 (%rdx), %zmm1
; AVX512-NEXT:    vmovdqa64 64(%rdx), %zmm23
; AVX512-NEXT:    vmovdqa64 (%rcx), %zmm9
; AVX512-NEXT:    vmovdqa64 64(%rcx), %zmm13
; AVX512-NEXT:    vmovdqa64 (%r8), %zmm4
; AVX512-NEXT:    vmovdqa64 64(%r8), %zmm22
; AVX512-NEXT:    vmovdqa64 (%r9), %zmm10
; AVX512-NEXT:    vmovdqa64 64(%r9), %zmm26
; AVX512-NEXT:    vmovdqa64 (%rax), %zmm15
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,0,0,0,14,30,0,0,0,0,0,15,31,0,0,0]
; AVX512-NEXT:    vmovdqa64 %zmm23, %zmm0
; AVX512-NEXT:    vpermt2d %zmm13, %zmm21, %zmm0
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,14,30,0,0,0,0,0,15,31,0,0,0,0,0]
; AVX512-NEXT:    vmovdqa64 %zmm18, %zmm3
; AVX512-NEXT:    vpermt2d %zmm12, %zmm6, %zmm3
; AVX512-NEXT:    movw $6192, %cx # imm = 0x1830
; AVX512-NEXT:    kmovw %ecx, %k1
; AVX512-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k1}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,3,4,5,30,0,0,9,10,11,12,31,0,0]
; AVX512-NEXT:    vpermi2d %zmm22, %zmm3, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,0,0,0,12,28,0,0,0,0,0,13,29,0,0,0]
; AVX512-NEXT:    vmovdqa64 %zmm18, %zmm0
; AVX512-NEXT:    vpermt2d %zmm12, %zmm20, %zmm0
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [11,0,0,0,0,0,28,12,0,0,0,0,0,29,13,0]
; AVX512-NEXT:    vmovdqa64 %zmm13, %zmm3
; AVX512-NEXT:    vpermt2d %zmm23, %zmm11, %zmm3
; AVX512-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k1}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,27,0,0,4,5,6,7,28,0,0,11,12,13,14,29]
; AVX512-NEXT:    vpermi2d %zmm22, %zmm3, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm28 = [0,0,0,16,0,0,0,0,0,1,17,0,0,0,0,0]
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512-NEXT:    vpermt2d %zmm9, %zmm28, %zmm0
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm25 = [0,16,0,0,0,0,0,1,17,0,0,0,0,0,2,18]
; AVX512-NEXT:    vmovdqa64 %zmm14, %zmm7
; AVX512-NEXT:    vpermt2d %zmm8, %zmm25, %zmm7
; AVX512-NEXT:    movw $1548, %cx # imm = 0x60C
; AVX512-NEXT:    kmovw %ecx, %k2
; AVX512-NEXT:    vmovdqa32 %zmm0, %zmm7 {%k2}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm5
; AVX512-NEXT:    vpermt2d %zmm10, %zmm0, %zmm5
; AVX512-NEXT:    vmovdqa64 %zmm23, %zmm30
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm17 = [9,0,0,0,0,0,26,10,0,0,0,0,0,27,11,0]
; AVX512-NEXT:    vmovdqa64 %zmm12, %zmm16
; AVX512-NEXT:    vpermt2d %zmm18, %zmm17, %zmm16
; AVX512-NEXT:    vmovdqa64 %zmm23, %zmm27
; AVX512-NEXT:    vmovdqa64 %zmm18, %zmm3
; AVX512-NEXT:    vmovdqa64 %zmm23, %zmm31
; AVX512-NEXT:    vmovdqa64 %zmm18, %zmm24
; AVX512-NEXT:    vmovdqa64 %zmm23, %zmm19
; AVX512-NEXT:    vpermt2d %zmm13, %zmm28, %zmm23
; AVX512-NEXT:    vmovdqa64 %zmm18, %zmm29
; AVX512-NEXT:    vpermt2d %zmm12, %zmm25, %zmm18
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,0,0,0,4,5,16,0,0,0,0,11,12,17,0,0]
; AVX512-NEXT:    vpermt2d %zmm15, %zmm2, %zmm5
; AVX512-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512-NEXT:    vmovdqa32 %zmm23, %zmm18 {%k2}
; AVX512-NEXT:    kmovw %ecx, %k2
; AVX512-NEXT:    vmovdqa32 %zmm5, %zmm7 {%k2}
; AVX512-NEXT:    vmovdqa64 %zmm22, %zmm5
; AVX512-NEXT:    vmovdqa64 %zmm22, %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm22, %zmm23
; AVX512-NEXT:    vmovdqa64 %zmm22, %zmm28
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm25 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512-NEXT:    vpermt2d %zmm26, %zmm25, %zmm22
; AVX512-NEXT:    vmovdqa64 64(%rax), %zmm25
; AVX512-NEXT:    vpermt2d %zmm25, %zmm2, %zmm22
; AVX512-NEXT:    vmovdqa32 %zmm22, %zmm18 {%k2}
; AVX512-NEXT:    vpermi2d %zmm9, %zmm1, %zmm21
; AVX512-NEXT:    vpermi2d %zmm8, %zmm14, %zmm6
; AVX512-NEXT:    vmovdqa32 %zmm21, %zmm6 {%k1}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [13,0,0,0,0,0,30,14,0,0,0,0,0,31,15,0]
; AVX512-NEXT:    vpermi2d %zmm4, %zmm10, %zmm2
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,29,0,0,0,0,6,7,30,0,0,0,0,13,14,31]
; AVX512-NEXT:    vpermi2d %zmm15, %zmm2, %zmm21
; AVX512-NEXT:    movw $-7741, %ax # imm = 0xE1C3
; AVX512-NEXT:    kmovw %eax, %k2
; AVX512-NEXT:    vmovdqa32 %zmm21, %zmm6 {%k2}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,9,25,0,0,0,0,0,10,26,0,0,0,0,0,11]
; AVX512-NEXT:    vpermt2d %zmm13, %zmm2, %zmm30
; AVX512-NEXT:    movw $-31994, %ax # imm = 0x8306
; AVX512-NEXT:    kmovw %eax, %k2
; AVX512-NEXT:    vmovdqa32 %zmm30, %zmm16 {%k2}
; AVX512-NEXT:    vpermi2d %zmm8, %zmm14, %zmm20
; AVX512-NEXT:    vpermi2d %zmm1, %zmm9, %zmm11
; AVX512-NEXT:    vmovdqa32 %zmm20, %zmm11 {%k1}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,11,27,0,0,0,0,0,12,28,0,0,0,0,0,13]
; AVX512-NEXT:    vpermi2d %zmm10, %zmm4, %zmm20
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,1,2,27,0,0,0,0,8,9,28,0,0,0,0,15]
; AVX512-NEXT:    vpermi2d %zmm15, %zmm20, %zmm21
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,0,0,9,25,0,0,0,0,0,10,26,0,0,0,0]
; AVX512-NEXT:    vpermt2d %zmm26, %zmm20, %zmm5
; AVX512-NEXT:    movw $-30962, %ax # imm = 0x870E
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovdqa32 %zmm21, %zmm11 {%k1}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,0,0,3,4,25,0,0,0,0,10,11,26,0,0,0]
; AVX512-NEXT:    vpermt2d %zmm25, %zmm21, %zmm5
; AVX512-NEXT:    movw $7224, %ax # imm = 0x1C38
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovdqa32 %zmm5, %zmm16 {%k1}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm22 = [0,0,0,7,23,0,0,0,0,0,8,24,0,0,0,0]
; AVX512-NEXT:    vpermt2d %zmm13, %zmm22, %zmm27
; AVX512-NEXT:    vpermi2d %zmm9, %zmm1, %zmm2
; AVX512-NEXT:    vpermi2d %zmm14, %zmm8, %zmm17
; AVX512-NEXT:    vmovdqa32 %zmm2, %zmm17 {%k2}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,7,23,0,0,0,0,0,8,24,0,0,0,0,0,9]
; AVX512-NEXT:    vpermt2d %zmm12, %zmm5, %zmm3
; AVX512-NEXT:    movw $3096, %ax # imm = 0xC18
; AVX512-NEXT:    kmovw %eax, %k2
; AVX512-NEXT:    vmovdqa32 %zmm27, %zmm3 {%k2}
; AVX512-NEXT:    vpermi2d %zmm10, %zmm4, %zmm20
; AVX512-NEXT:    vpermt2d %zmm15, %zmm21, %zmm20
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,0,0,0,0,7,23,0,0,0,0,0,8,24,0,0]
; AVX512-NEXT:    vpermt2d %zmm26, %zmm2, %zmm0
; AVX512-NEXT:    vmovdqa32 %zmm20, %zmm17 {%k1}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [22,0,0,0,0,5,6,23,0,0,0,0,12,13,24,0]
; AVX512-NEXT:    vpermt2d %zmm25, %zmm20, %zmm0
; AVX512-NEXT:    movw $28897, %ax # imm = 0x70E1
; AVX512-NEXT:    kmovw %eax, %k3
; AVX512-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k3}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,5,21,0,0,0,0,0,6,22,0,0]
; AVX512-NEXT:    vpermt2d %zmm13, %zmm0, %zmm31
; AVX512-NEXT:    vpermi2d %zmm9, %zmm1, %zmm22
; AVX512-NEXT:    vpermi2d %zmm8, %zmm14, %zmm5
; AVX512-NEXT:    vmovdqa32 %zmm22, %zmm5 {%k2}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,0,0,5,21,0,0,0,0,0,6,22,0,0,0,0]
; AVX512-NEXT:    vpermt2d %zmm12, %zmm21, %zmm24
; AVX512-NEXT:    movw $12384, %ax # imm = 0x3060
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovdqa32 %zmm31, %zmm24 {%k1}
; AVX512-NEXT:    vpermi2d %zmm10, %zmm4, %zmm2
; AVX512-NEXT:    vpermt2d %zmm15, %zmm20, %zmm2
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [4,20,0,0,0,0,0,5,21,0,0,0,0,0,6,22]
; AVX512-NEXT:    vpermt2d %zmm26, %zmm20, %zmm23
; AVX512-NEXT:    vmovdqa32 %zmm2, %zmm5 {%k3}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,1,20,0,0,0,0,7,8,21,0,0,0,0,14,15]
; AVX512-NEXT:    vpermt2d %zmm25, %zmm2, %zmm23
; AVX512-NEXT:    movw $15480, %ax # imm = 0x3C78
; AVX512-NEXT:    kmovw %eax, %k2
; AVX512-NEXT:    vmovdqa32 %zmm24, %zmm23 {%k2}
; AVX512-NEXT:    vpermi2d %zmm9, %zmm1, %zmm0
; AVX512-NEXT:    vpermi2d %zmm8, %zmm14, %zmm21
; AVX512-NEXT:    vmovdqa32 %zmm0, %zmm21 {%k1}
; AVX512-NEXT:    vpermi2d %zmm10, %zmm4, %zmm20
; AVX512-NEXT:    vpermt2d %zmm15, %zmm2, %zmm20
; AVX512-NEXT:    vmovdqa32 %zmm21, %zmm20 {%k2}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,3,19,0,0,0,0,0,4,20,0,0]
; AVX512-NEXT:    vpermt2d %zmm12, %zmm0, %zmm29
; AVX512-NEXT:    vpermt2d %zmm8, %zmm0, %zmm14
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [2,18,0,0,0,0,0,3,19,0,0,0,0,0,4,20]
; AVX512-NEXT:    vpermt2d %zmm13, %zmm0, %zmm19
; AVX512-NEXT:    vpermt2d %zmm9, %zmm0, %zmm1
; AVX512-NEXT:    vmovdqa32 %zmm29, %zmm19 {%k1}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,18,0,0,0,0,0,3,19,0,0,0,0,0]
; AVX512-NEXT:    vpermt2d %zmm10, %zmm0, %zmm4
; AVX512-NEXT:    vpermt2d %zmm26, %zmm0, %zmm28
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,3,18,0,0,0,0,9,10,19,0,0,0,0]
; AVX512-NEXT:    vpermt2d %zmm15, %zmm0, %zmm4
; AVX512-NEXT:    vpermt2d %zmm25, %zmm0, %zmm28
; AVX512-NEXT:    vmovdqa32 %zmm14, %zmm1 {%k1}
; AVX512-NEXT:    movw $3612, %ax # imm = 0xE1C
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovdqa32 %zmm28, %zmm19 {%k1}
; AVX512-NEXT:    vmovdqa32 %zmm4, %zmm1 {%k1}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [29,0,2,3,4,5,6,30,0,9,10,11,12,13,31,0]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vpermi2d %zmm26, %zmm2, %zmm0
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,1,27,0,4,5,6,7,8,28,0,11,12,13,14,15]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512-NEXT:    vpermi2d %zmm26, %zmm4, %zmm2
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,29,2,3,4,5,6,7,30,9,10,11,12,13,14,31]
; AVX512-NEXT:    vpermi2d %zmm25, %zmm0, %zmm4
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,27,4,5,6,7,8,9,28,11,12,13,14,15]
; AVX512-NEXT:    vpermi2d %zmm25, %zmm2, %zmm0
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqa64 %zmm1, 64(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm20, 128(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm5, 192(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm17, 256(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm11, 320(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm6, 384(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm18, 448(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm19, 512(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm23, 576(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm3, 640(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm16, 704(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm7, (%rax)
; AVX512-NEXT:    vmovdqa64 %zmm0, 768(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm4, 832(%rax)
; AVX512-NEXT:    popq %rax
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i32_stride7_vf32:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    pushq %rax
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm14
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm18
; AVX512-FCP-NEXT:    vmovdqa64 (%rsi), %zmm8
; AVX512-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm12
; AVX512-FCP-NEXT:    vmovdqa64 (%rdx), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm23
; AVX512-FCP-NEXT:    vmovdqa64 (%rcx), %zmm9
; AVX512-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm13
; AVX512-FCP-NEXT:    vmovdqa64 (%r8), %zmm4
; AVX512-FCP-NEXT:    vmovdqa64 64(%r8), %zmm22
; AVX512-FCP-NEXT:    vmovdqa64 (%r9), %zmm10
; AVX512-FCP-NEXT:    vmovdqa64 64(%r9), %zmm26
; AVX512-FCP-NEXT:    vmovdqa64 (%rax), %zmm15
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,0,0,0,14,30,0,0,0,0,0,15,31,0,0,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm23, %zmm0
; AVX512-FCP-NEXT:    vpermt2d %zmm13, %zmm21, %zmm0
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,14,30,0,0,0,0,0,15,31,0,0,0,0,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, %zmm3
; AVX512-FCP-NEXT:    vpermt2d %zmm12, %zmm6, %zmm3
; AVX512-FCP-NEXT:    movw $6192, %cx # imm = 0x1830
; AVX512-FCP-NEXT:    kmovw %ecx, %k1
; AVX512-FCP-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,3,4,5,30,0,0,9,10,11,12,31,0,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm22, %zmm3, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,0,0,0,12,28,0,0,0,0,0,13,29,0,0,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, %zmm0
; AVX512-FCP-NEXT:    vpermt2d %zmm12, %zmm20, %zmm0
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [11,0,0,0,0,0,28,12,0,0,0,0,0,29,13,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm13, %zmm3
; AVX512-FCP-NEXT:    vpermt2d %zmm23, %zmm11, %zmm3
; AVX512-FCP-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,27,0,0,4,5,6,7,28,0,0,11,12,13,14,29]
; AVX512-FCP-NEXT:    vpermi2d %zmm22, %zmm3, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm28 = [0,0,0,16,0,0,0,0,0,1,17,0,0,0,0,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512-FCP-NEXT:    vpermt2d %zmm9, %zmm28, %zmm0
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm25 = [0,16,0,0,0,0,0,1,17,0,0,0,0,0,2,18]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm14, %zmm7
; AVX512-FCP-NEXT:    vpermt2d %zmm8, %zmm25, %zmm7
; AVX512-FCP-NEXT:    movw $1548, %cx # imm = 0x60C
; AVX512-FCP-NEXT:    kmovw %ecx, %k2
; AVX512-FCP-NEXT:    vmovdqa32 %zmm0, %zmm7 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm5
; AVX512-FCP-NEXT:    vpermt2d %zmm10, %zmm0, %zmm5
; AVX512-FCP-NEXT:    vmovdqa64 %zmm23, %zmm30
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm17 = [9,0,0,0,0,0,26,10,0,0,0,0,0,27,11,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm12, %zmm16
; AVX512-FCP-NEXT:    vpermt2d %zmm18, %zmm17, %zmm16
; AVX512-FCP-NEXT:    vmovdqa64 %zmm23, %zmm27
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 %zmm23, %zmm31
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, %zmm24
; AVX512-FCP-NEXT:    vmovdqa64 %zmm23, %zmm19
; AVX512-FCP-NEXT:    vpermt2d %zmm13, %zmm28, %zmm23
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, %zmm29
; AVX512-FCP-NEXT:    vpermt2d %zmm12, %zmm25, %zmm18
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,0,0,0,4,5,16,0,0,0,0,11,12,17,0,0]
; AVX512-FCP-NEXT:    vpermt2d %zmm15, %zmm2, %zmm5
; AVX512-FCP-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512-FCP-NEXT:    vmovdqa32 %zmm23, %zmm18 {%k2}
; AVX512-FCP-NEXT:    kmovw %ecx, %k2
; AVX512-FCP-NEXT:    vmovdqa32 %zmm5, %zmm7 {%k2}
; AVX512-FCP-NEXT:    vmovdqa64 %zmm22, %zmm5
; AVX512-FCP-NEXT:    vmovdqa64 %zmm22, %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 %zmm22, %zmm23
; AVX512-FCP-NEXT:    vmovdqa64 %zmm22, %zmm28
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm25 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512-FCP-NEXT:    vpermt2d %zmm26, %zmm25, %zmm22
; AVX512-FCP-NEXT:    vmovdqa64 64(%rax), %zmm25
; AVX512-FCP-NEXT:    vpermt2d %zmm25, %zmm2, %zmm22
; AVX512-FCP-NEXT:    vmovdqa32 %zmm22, %zmm18 {%k2}
; AVX512-FCP-NEXT:    vpermi2d %zmm9, %zmm1, %zmm21
; AVX512-FCP-NEXT:    vpermi2d %zmm8, %zmm14, %zmm6
; AVX512-FCP-NEXT:    vmovdqa32 %zmm21, %zmm6 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [13,0,0,0,0,0,30,14,0,0,0,0,0,31,15,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm4, %zmm10, %zmm2
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,29,0,0,0,0,6,7,30,0,0,0,0,13,14,31]
; AVX512-FCP-NEXT:    vpermi2d %zmm15, %zmm2, %zmm21
; AVX512-FCP-NEXT:    movw $-7741, %ax # imm = 0xE1C3
; AVX512-FCP-NEXT:    kmovw %eax, %k2
; AVX512-FCP-NEXT:    vmovdqa32 %zmm21, %zmm6 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,9,25,0,0,0,0,0,10,26,0,0,0,0,0,11]
; AVX512-FCP-NEXT:    vpermt2d %zmm13, %zmm2, %zmm30
; AVX512-FCP-NEXT:    movw $-31994, %ax # imm = 0x8306
; AVX512-FCP-NEXT:    kmovw %eax, %k2
; AVX512-FCP-NEXT:    vmovdqa32 %zmm30, %zmm16 {%k2}
; AVX512-FCP-NEXT:    vpermi2d %zmm8, %zmm14, %zmm20
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm9, %zmm11
; AVX512-FCP-NEXT:    vmovdqa32 %zmm20, %zmm11 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,11,27,0,0,0,0,0,12,28,0,0,0,0,0,13]
; AVX512-FCP-NEXT:    vpermi2d %zmm10, %zmm4, %zmm20
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,1,2,27,0,0,0,0,8,9,28,0,0,0,0,15]
; AVX512-FCP-NEXT:    vpermi2d %zmm15, %zmm20, %zmm21
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,0,0,9,25,0,0,0,0,0,10,26,0,0,0,0]
; AVX512-FCP-NEXT:    vpermt2d %zmm26, %zmm20, %zmm5
; AVX512-FCP-NEXT:    movw $-30962, %ax # imm = 0x870E
; AVX512-FCP-NEXT:    kmovw %eax, %k1
; AVX512-FCP-NEXT:    vmovdqa32 %zmm21, %zmm11 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,0,0,3,4,25,0,0,0,0,10,11,26,0,0,0]
; AVX512-FCP-NEXT:    vpermt2d %zmm25, %zmm21, %zmm5
; AVX512-FCP-NEXT:    movw $7224, %ax # imm = 0x1C38
; AVX512-FCP-NEXT:    kmovw %eax, %k1
; AVX512-FCP-NEXT:    vmovdqa32 %zmm5, %zmm16 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm22 = [0,0,0,7,23,0,0,0,0,0,8,24,0,0,0,0]
; AVX512-FCP-NEXT:    vpermt2d %zmm13, %zmm22, %zmm27
; AVX512-FCP-NEXT:    vpermi2d %zmm9, %zmm1, %zmm2
; AVX512-FCP-NEXT:    vpermi2d %zmm14, %zmm8, %zmm17
; AVX512-FCP-NEXT:    vmovdqa32 %zmm2, %zmm17 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,7,23,0,0,0,0,0,8,24,0,0,0,0,0,9]
; AVX512-FCP-NEXT:    vpermt2d %zmm12, %zmm5, %zmm3
; AVX512-FCP-NEXT:    movw $3096, %ax # imm = 0xC18
; AVX512-FCP-NEXT:    kmovw %eax, %k2
; AVX512-FCP-NEXT:    vmovdqa32 %zmm27, %zmm3 {%k2}
; AVX512-FCP-NEXT:    vpermi2d %zmm10, %zmm4, %zmm20
; AVX512-FCP-NEXT:    vpermt2d %zmm15, %zmm21, %zmm20
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,0,0,0,0,7,23,0,0,0,0,0,8,24,0,0]
; AVX512-FCP-NEXT:    vpermt2d %zmm26, %zmm2, %zmm0
; AVX512-FCP-NEXT:    vmovdqa32 %zmm20, %zmm17 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [22,0,0,0,0,5,6,23,0,0,0,0,12,13,24,0]
; AVX512-FCP-NEXT:    vpermt2d %zmm25, %zmm20, %zmm0
; AVX512-FCP-NEXT:    movw $28897, %ax # imm = 0x70E1
; AVX512-FCP-NEXT:    kmovw %eax, %k3
; AVX512-FCP-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k3}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,5,21,0,0,0,0,0,6,22,0,0]
; AVX512-FCP-NEXT:    vpermt2d %zmm13, %zmm0, %zmm31
; AVX512-FCP-NEXT:    vpermi2d %zmm9, %zmm1, %zmm22
; AVX512-FCP-NEXT:    vpermi2d %zmm8, %zmm14, %zmm5
; AVX512-FCP-NEXT:    vmovdqa32 %zmm22, %zmm5 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,0,0,5,21,0,0,0,0,0,6,22,0,0,0,0]
; AVX512-FCP-NEXT:    vpermt2d %zmm12, %zmm21, %zmm24
; AVX512-FCP-NEXT:    movw $12384, %ax # imm = 0x3060
; AVX512-FCP-NEXT:    kmovw %eax, %k1
; AVX512-FCP-NEXT:    vmovdqa32 %zmm31, %zmm24 {%k1}
; AVX512-FCP-NEXT:    vpermi2d %zmm10, %zmm4, %zmm2
; AVX512-FCP-NEXT:    vpermt2d %zmm15, %zmm20, %zmm2
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [4,20,0,0,0,0,0,5,21,0,0,0,0,0,6,22]
; AVX512-FCP-NEXT:    vpermt2d %zmm26, %zmm20, %zmm23
; AVX512-FCP-NEXT:    vmovdqa32 %zmm2, %zmm5 {%k3}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,1,20,0,0,0,0,7,8,21,0,0,0,0,14,15]
; AVX512-FCP-NEXT:    vpermt2d %zmm25, %zmm2, %zmm23
; AVX512-FCP-NEXT:    movw $15480, %ax # imm = 0x3C78
; AVX512-FCP-NEXT:    kmovw %eax, %k2
; AVX512-FCP-NEXT:    vmovdqa32 %zmm24, %zmm23 {%k2}
; AVX512-FCP-NEXT:    vpermi2d %zmm9, %zmm1, %zmm0
; AVX512-FCP-NEXT:    vpermi2d %zmm8, %zmm14, %zmm21
; AVX512-FCP-NEXT:    vmovdqa32 %zmm0, %zmm21 {%k1}
; AVX512-FCP-NEXT:    vpermi2d %zmm10, %zmm4, %zmm20
; AVX512-FCP-NEXT:    vpermt2d %zmm15, %zmm2, %zmm20
; AVX512-FCP-NEXT:    vmovdqa32 %zmm21, %zmm20 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,3,19,0,0,0,0,0,4,20,0,0]
; AVX512-FCP-NEXT:    vpermt2d %zmm12, %zmm0, %zmm29
; AVX512-FCP-NEXT:    vpermt2d %zmm8, %zmm0, %zmm14
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [2,18,0,0,0,0,0,3,19,0,0,0,0,0,4,20]
; AVX512-FCP-NEXT:    vpermt2d %zmm13, %zmm0, %zmm19
; AVX512-FCP-NEXT:    vpermt2d %zmm9, %zmm0, %zmm1
; AVX512-FCP-NEXT:    vmovdqa32 %zmm29, %zmm19 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,18,0,0,0,0,0,3,19,0,0,0,0,0]
; AVX512-FCP-NEXT:    vpermt2d %zmm10, %zmm0, %zmm4
; AVX512-FCP-NEXT:    vpermt2d %zmm26, %zmm0, %zmm28
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,3,18,0,0,0,0,9,10,19,0,0,0,0]
; AVX512-FCP-NEXT:    vpermt2d %zmm15, %zmm0, %zmm4
; AVX512-FCP-NEXT:    vpermt2d %zmm25, %zmm0, %zmm28
; AVX512-FCP-NEXT:    vmovdqa32 %zmm14, %zmm1 {%k1}
; AVX512-FCP-NEXT:    movw $3612, %ax # imm = 0xE1C
; AVX512-FCP-NEXT:    kmovw %eax, %k1
; AVX512-FCP-NEXT:    vmovdqa32 %zmm28, %zmm19 {%k1}
; AVX512-FCP-NEXT:    vmovdqa32 %zmm4, %zmm1 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [29,0,2,3,4,5,6,30,0,9,10,11,12,13,31,0]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermi2d %zmm26, %zmm2, %zmm0
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,1,27,0,4,5,6,7,8,28,0,11,12,13,14,15]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermi2d %zmm26, %zmm4, %zmm2
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,29,2,3,4,5,6,7,30,9,10,11,12,13,14,31]
; AVX512-FCP-NEXT:    vpermi2d %zmm25, %zmm0, %zmm4
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,27,4,5,6,7,8,9,28,11,12,13,14,15]
; AVX512-FCP-NEXT:    vpermi2d %zmm25, %zmm2, %zmm0
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, 64(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm20, 128(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, 192(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm17, 256(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm11, 320(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, 384(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, 448(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm19, 512(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm23, 576(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, 640(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm16, 704(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, (%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, 768(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, 832(%rax)
; AVX512-FCP-NEXT:    popq %rax
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i32_stride7_vf32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    pushq %rax
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm14
; AVX512DQ-NEXT:    vmovdqa64 64(%rdi), %zmm18
; AVX512DQ-NEXT:    vmovdqa64 (%rsi), %zmm8
; AVX512DQ-NEXT:    vmovdqa64 64(%rsi), %zmm12
; AVX512DQ-NEXT:    vmovdqa64 (%rdx), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 64(%rdx), %zmm23
; AVX512DQ-NEXT:    vmovdqa64 (%rcx), %zmm9
; AVX512DQ-NEXT:    vmovdqa64 64(%rcx), %zmm13
; AVX512DQ-NEXT:    vmovdqa64 (%r8), %zmm4
; AVX512DQ-NEXT:    vmovdqa64 64(%r8), %zmm22
; AVX512DQ-NEXT:    vmovdqa64 (%r9), %zmm10
; AVX512DQ-NEXT:    vmovdqa64 64(%r9), %zmm26
; AVX512DQ-NEXT:    vmovdqa64 (%rax), %zmm15
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,0,0,0,14,30,0,0,0,0,0,15,31,0,0,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm23, %zmm0
; AVX512DQ-NEXT:    vpermt2d %zmm13, %zmm21, %zmm0
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,14,30,0,0,0,0,0,15,31,0,0,0,0,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, %zmm3
; AVX512DQ-NEXT:    vpermt2d %zmm12, %zmm6, %zmm3
; AVX512DQ-NEXT:    movw $6192, %cx # imm = 0x1830
; AVX512DQ-NEXT:    kmovw %ecx, %k1
; AVX512DQ-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k1}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,3,4,5,30,0,0,9,10,11,12,31,0,0]
; AVX512DQ-NEXT:    vpermi2d %zmm22, %zmm3, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,0,0,0,12,28,0,0,0,0,0,13,29,0,0,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, %zmm0
; AVX512DQ-NEXT:    vpermt2d %zmm12, %zmm20, %zmm0
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [11,0,0,0,0,0,28,12,0,0,0,0,0,29,13,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm13, %zmm3
; AVX512DQ-NEXT:    vpermt2d %zmm23, %zmm11, %zmm3
; AVX512DQ-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k1}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,27,0,0,4,5,6,7,28,0,0,11,12,13,14,29]
; AVX512DQ-NEXT:    vpermi2d %zmm22, %zmm3, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm28 = [0,0,0,16,0,0,0,0,0,1,17,0,0,0,0,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512DQ-NEXT:    vpermt2d %zmm9, %zmm28, %zmm0
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm25 = [0,16,0,0,0,0,0,1,17,0,0,0,0,0,2,18]
; AVX512DQ-NEXT:    vmovdqa64 %zmm14, %zmm7
; AVX512DQ-NEXT:    vpermt2d %zmm8, %zmm25, %zmm7
; AVX512DQ-NEXT:    movw $1548, %cx # imm = 0x60C
; AVX512DQ-NEXT:    kmovw %ecx, %k2
; AVX512DQ-NEXT:    vmovdqa32 %zmm0, %zmm7 {%k2}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm5
; AVX512DQ-NEXT:    vpermt2d %zmm10, %zmm0, %zmm5
; AVX512DQ-NEXT:    vmovdqa64 %zmm23, %zmm30
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm17 = [9,0,0,0,0,0,26,10,0,0,0,0,0,27,11,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm12, %zmm16
; AVX512DQ-NEXT:    vpermt2d %zmm18, %zmm17, %zmm16
; AVX512DQ-NEXT:    vmovdqa64 %zmm23, %zmm27
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, %zmm3
; AVX512DQ-NEXT:    vmovdqa64 %zmm23, %zmm31
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, %zmm24
; AVX512DQ-NEXT:    vmovdqa64 %zmm23, %zmm19
; AVX512DQ-NEXT:    vpermt2d %zmm13, %zmm28, %zmm23
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, %zmm29
; AVX512DQ-NEXT:    vpermt2d %zmm12, %zmm25, %zmm18
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,0,0,0,4,5,16,0,0,0,0,11,12,17,0,0]
; AVX512DQ-NEXT:    vpermt2d %zmm15, %zmm2, %zmm5
; AVX512DQ-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512DQ-NEXT:    vmovdqa32 %zmm23, %zmm18 {%k2}
; AVX512DQ-NEXT:    kmovw %ecx, %k2
; AVX512DQ-NEXT:    vmovdqa32 %zmm5, %zmm7 {%k2}
; AVX512DQ-NEXT:    vmovdqa64 %zmm22, %zmm5
; AVX512DQ-NEXT:    vmovdqa64 %zmm22, %zmm0
; AVX512DQ-NEXT:    vmovdqa64 %zmm22, %zmm23
; AVX512DQ-NEXT:    vmovdqa64 %zmm22, %zmm28
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm25 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512DQ-NEXT:    vpermt2d %zmm26, %zmm25, %zmm22
; AVX512DQ-NEXT:    vmovdqa64 64(%rax), %zmm25
; AVX512DQ-NEXT:    vpermt2d %zmm25, %zmm2, %zmm22
; AVX512DQ-NEXT:    vmovdqa32 %zmm22, %zmm18 {%k2}
; AVX512DQ-NEXT:    vpermi2d %zmm9, %zmm1, %zmm21
; AVX512DQ-NEXT:    vpermi2d %zmm8, %zmm14, %zmm6
; AVX512DQ-NEXT:    vmovdqa32 %zmm21, %zmm6 {%k1}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [13,0,0,0,0,0,30,14,0,0,0,0,0,31,15,0]
; AVX512DQ-NEXT:    vpermi2d %zmm4, %zmm10, %zmm2
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,29,0,0,0,0,6,7,30,0,0,0,0,13,14,31]
; AVX512DQ-NEXT:    vpermi2d %zmm15, %zmm2, %zmm21
; AVX512DQ-NEXT:    movw $-7741, %ax # imm = 0xE1C3
; AVX512DQ-NEXT:    kmovw %eax, %k2
; AVX512DQ-NEXT:    vmovdqa32 %zmm21, %zmm6 {%k2}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,9,25,0,0,0,0,0,10,26,0,0,0,0,0,11]
; AVX512DQ-NEXT:    vpermt2d %zmm13, %zmm2, %zmm30
; AVX512DQ-NEXT:    movw $-31994, %ax # imm = 0x8306
; AVX512DQ-NEXT:    kmovw %eax, %k2
; AVX512DQ-NEXT:    vmovdqa32 %zmm30, %zmm16 {%k2}
; AVX512DQ-NEXT:    vpermi2d %zmm8, %zmm14, %zmm20
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm9, %zmm11
; AVX512DQ-NEXT:    vmovdqa32 %zmm20, %zmm11 {%k1}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,11,27,0,0,0,0,0,12,28,0,0,0,0,0,13]
; AVX512DQ-NEXT:    vpermi2d %zmm10, %zmm4, %zmm20
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,1,2,27,0,0,0,0,8,9,28,0,0,0,0,15]
; AVX512DQ-NEXT:    vpermi2d %zmm15, %zmm20, %zmm21
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,0,0,9,25,0,0,0,0,0,10,26,0,0,0,0]
; AVX512DQ-NEXT:    vpermt2d %zmm26, %zmm20, %zmm5
; AVX512DQ-NEXT:    movw $-30962, %ax # imm = 0x870E
; AVX512DQ-NEXT:    kmovw %eax, %k1
; AVX512DQ-NEXT:    vmovdqa32 %zmm21, %zmm11 {%k1}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,0,0,3,4,25,0,0,0,0,10,11,26,0,0,0]
; AVX512DQ-NEXT:    vpermt2d %zmm25, %zmm21, %zmm5
; AVX512DQ-NEXT:    movw $7224, %ax # imm = 0x1C38
; AVX512DQ-NEXT:    kmovw %eax, %k1
; AVX512DQ-NEXT:    vmovdqa32 %zmm5, %zmm16 {%k1}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm22 = [0,0,0,7,23,0,0,0,0,0,8,24,0,0,0,0]
; AVX512DQ-NEXT:    vpermt2d %zmm13, %zmm22, %zmm27
; AVX512DQ-NEXT:    vpermi2d %zmm9, %zmm1, %zmm2
; AVX512DQ-NEXT:    vpermi2d %zmm14, %zmm8, %zmm17
; AVX512DQ-NEXT:    vmovdqa32 %zmm2, %zmm17 {%k2}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,7,23,0,0,0,0,0,8,24,0,0,0,0,0,9]
; AVX512DQ-NEXT:    vpermt2d %zmm12, %zmm5, %zmm3
; AVX512DQ-NEXT:    movw $3096, %ax # imm = 0xC18
; AVX512DQ-NEXT:    kmovw %eax, %k2
; AVX512DQ-NEXT:    vmovdqa32 %zmm27, %zmm3 {%k2}
; AVX512DQ-NEXT:    vpermi2d %zmm10, %zmm4, %zmm20
; AVX512DQ-NEXT:    vpermt2d %zmm15, %zmm21, %zmm20
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,0,0,0,0,7,23,0,0,0,0,0,8,24,0,0]
; AVX512DQ-NEXT:    vpermt2d %zmm26, %zmm2, %zmm0
; AVX512DQ-NEXT:    vmovdqa32 %zmm20, %zmm17 {%k1}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [22,0,0,0,0,5,6,23,0,0,0,0,12,13,24,0]
; AVX512DQ-NEXT:    vpermt2d %zmm25, %zmm20, %zmm0
; AVX512DQ-NEXT:    movw $28897, %ax # imm = 0x70E1
; AVX512DQ-NEXT:    kmovw %eax, %k3
; AVX512DQ-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k3}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,5,21,0,0,0,0,0,6,22,0,0]
; AVX512DQ-NEXT:    vpermt2d %zmm13, %zmm0, %zmm31
; AVX512DQ-NEXT:    vpermi2d %zmm9, %zmm1, %zmm22
; AVX512DQ-NEXT:    vpermi2d %zmm8, %zmm14, %zmm5
; AVX512DQ-NEXT:    vmovdqa32 %zmm22, %zmm5 {%k2}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,0,0,5,21,0,0,0,0,0,6,22,0,0,0,0]
; AVX512DQ-NEXT:    vpermt2d %zmm12, %zmm21, %zmm24
; AVX512DQ-NEXT:    movw $12384, %ax # imm = 0x3060
; AVX512DQ-NEXT:    kmovw %eax, %k1
; AVX512DQ-NEXT:    vmovdqa32 %zmm31, %zmm24 {%k1}
; AVX512DQ-NEXT:    vpermi2d %zmm10, %zmm4, %zmm2
; AVX512DQ-NEXT:    vpermt2d %zmm15, %zmm20, %zmm2
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [4,20,0,0,0,0,0,5,21,0,0,0,0,0,6,22]
; AVX512DQ-NEXT:    vpermt2d %zmm26, %zmm20, %zmm23
; AVX512DQ-NEXT:    vmovdqa32 %zmm2, %zmm5 {%k3}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,1,20,0,0,0,0,7,8,21,0,0,0,0,14,15]
; AVX512DQ-NEXT:    vpermt2d %zmm25, %zmm2, %zmm23
; AVX512DQ-NEXT:    movw $15480, %ax # imm = 0x3C78
; AVX512DQ-NEXT:    kmovw %eax, %k2
; AVX512DQ-NEXT:    vmovdqa32 %zmm24, %zmm23 {%k2}
; AVX512DQ-NEXT:    vpermi2d %zmm9, %zmm1, %zmm0
; AVX512DQ-NEXT:    vpermi2d %zmm8, %zmm14, %zmm21
; AVX512DQ-NEXT:    vmovdqa32 %zmm0, %zmm21 {%k1}
; AVX512DQ-NEXT:    vpermi2d %zmm10, %zmm4, %zmm20
; AVX512DQ-NEXT:    vpermt2d %zmm15, %zmm2, %zmm20
; AVX512DQ-NEXT:    vmovdqa32 %zmm21, %zmm20 {%k2}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,3,19,0,0,0,0,0,4,20,0,0]
; AVX512DQ-NEXT:    vpermt2d %zmm12, %zmm0, %zmm29
; AVX512DQ-NEXT:    vpermt2d %zmm8, %zmm0, %zmm14
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [2,18,0,0,0,0,0,3,19,0,0,0,0,0,4,20]
; AVX512DQ-NEXT:    vpermt2d %zmm13, %zmm0, %zmm19
; AVX512DQ-NEXT:    vpermt2d %zmm9, %zmm0, %zmm1
; AVX512DQ-NEXT:    vmovdqa32 %zmm29, %zmm19 {%k1}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,18,0,0,0,0,0,3,19,0,0,0,0,0]
; AVX512DQ-NEXT:    vpermt2d %zmm10, %zmm0, %zmm4
; AVX512DQ-NEXT:    vpermt2d %zmm26, %zmm0, %zmm28
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,3,18,0,0,0,0,9,10,19,0,0,0,0]
; AVX512DQ-NEXT:    vpermt2d %zmm15, %zmm0, %zmm4
; AVX512DQ-NEXT:    vpermt2d %zmm25, %zmm0, %zmm28
; AVX512DQ-NEXT:    vmovdqa32 %zmm14, %zmm1 {%k1}
; AVX512DQ-NEXT:    movw $3612, %ax # imm = 0xE1C
; AVX512DQ-NEXT:    kmovw %eax, %k1
; AVX512DQ-NEXT:    vmovdqa32 %zmm28, %zmm19 {%k1}
; AVX512DQ-NEXT:    vmovdqa32 %zmm4, %zmm1 {%k1}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [29,0,2,3,4,5,6,30,0,9,10,11,12,13,31,0]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vpermi2d %zmm26, %zmm2, %zmm0
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,1,27,0,4,5,6,7,8,28,0,11,12,13,14,15]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512DQ-NEXT:    vpermi2d %zmm26, %zmm4, %zmm2
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,29,2,3,4,5,6,7,30,9,10,11,12,13,14,31]
; AVX512DQ-NEXT:    vpermi2d %zmm25, %zmm0, %zmm4
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,27,4,5,6,7,8,9,28,11,12,13,14,15]
; AVX512DQ-NEXT:    vpermi2d %zmm25, %zmm2, %zmm0
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, 64(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm20, 128(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, 192(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm17, 256(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm11, 320(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, 384(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, 448(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm19, 512(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm23, 576(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, 640(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm16, 704(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, (%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, 768(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, 832(%rax)
; AVX512DQ-NEXT:    popq %rax
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i32_stride7_vf32:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    pushq %rax
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm14
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm18
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rsi), %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdx), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm23
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rcx), %zmm9
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm13
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%r8), %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%r8), %zmm22
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%r9), %zmm10
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%r9), %zmm26
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rax), %zmm15
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,0,0,0,14,30,0,0,0,0,0,15,31,0,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm23, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm13, %zmm21, %zmm0
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,14,30,0,0,0,0,0,15,31,0,0,0,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm12, %zmm6, %zmm3
; AVX512DQ-FCP-NEXT:    movw $6192, %cx # imm = 0x1830
; AVX512DQ-FCP-NEXT:    kmovw %ecx, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,3,4,5,30,0,0,9,10,11,12,31,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm22, %zmm3, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,0,0,0,12,28,0,0,0,0,0,13,29,0,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm12, %zmm20, %zmm0
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [11,0,0,0,0,0,28,12,0,0,0,0,0,29,13,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm13, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm23, %zmm11, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,27,0,0,4,5,6,7,28,0,0,11,12,13,14,29]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm22, %zmm3, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm28 = [0,0,0,16,0,0,0,0,0,1,17,0,0,0,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm9, %zmm28, %zmm0
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm25 = [0,16,0,0,0,0,0,1,17,0,0,0,0,0,2,18]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm14, %zmm7
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm8, %zmm25, %zmm7
; AVX512DQ-FCP-NEXT:    movw $1548, %cx # imm = 0x60C
; AVX512DQ-FCP-NEXT:    kmovw %ecx, %k2
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm0, %zmm7 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm5
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm10, %zmm0, %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm23, %zmm30
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm17 = [9,0,0,0,0,0,26,10,0,0,0,0,0,27,11,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm12, %zmm16
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm18, %zmm17, %zmm16
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm23, %zmm27
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm23, %zmm31
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, %zmm24
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm23, %zmm19
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm13, %zmm28, %zmm23
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, %zmm29
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm12, %zmm25, %zmm18
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,0,0,0,4,5,16,0,0,0,0,11,12,17,0,0]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm15, %zmm2, %zmm5
; AVX512DQ-FCP-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm23, %zmm18 {%k2}
; AVX512DQ-FCP-NEXT:    kmovw %ecx, %k2
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm5, %zmm7 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm22, %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm22, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm22, %zmm23
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm22, %zmm28
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm25 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm26, %zmm25, %zmm22
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rax), %zmm25
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm25, %zmm2, %zmm22
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm22, %zmm18 {%k2}
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm9, %zmm1, %zmm21
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm8, %zmm14, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm21, %zmm6 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [13,0,0,0,0,0,30,14,0,0,0,0,0,31,15,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm4, %zmm10, %zmm2
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,29,0,0,0,0,6,7,30,0,0,0,0,13,14,31]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm15, %zmm2, %zmm21
; AVX512DQ-FCP-NEXT:    movw $-7741, %ax # imm = 0xE1C3
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k2
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm21, %zmm6 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,9,25,0,0,0,0,0,10,26,0,0,0,0,0,11]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm13, %zmm2, %zmm30
; AVX512DQ-FCP-NEXT:    movw $-31994, %ax # imm = 0x8306
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k2
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm30, %zmm16 {%k2}
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm8, %zmm14, %zmm20
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm9, %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm20, %zmm11 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,11,27,0,0,0,0,0,12,28,0,0,0,0,0,13]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm10, %zmm4, %zmm20
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,1,2,27,0,0,0,0,8,9,28,0,0,0,0,15]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm15, %zmm20, %zmm21
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,0,0,9,25,0,0,0,0,0,10,26,0,0,0,0]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm26, %zmm20, %zmm5
; AVX512DQ-FCP-NEXT:    movw $-30962, %ax # imm = 0x870E
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm21, %zmm11 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,0,0,3,4,25,0,0,0,0,10,11,26,0,0,0]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm25, %zmm21, %zmm5
; AVX512DQ-FCP-NEXT:    movw $7224, %ax # imm = 0x1C38
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm5, %zmm16 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm22 = [0,0,0,7,23,0,0,0,0,0,8,24,0,0,0,0]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm13, %zmm22, %zmm27
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm9, %zmm1, %zmm2
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm14, %zmm8, %zmm17
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm2, %zmm17 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,7,23,0,0,0,0,0,8,24,0,0,0,0,0,9]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm12, %zmm5, %zmm3
; AVX512DQ-FCP-NEXT:    movw $3096, %ax # imm = 0xC18
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k2
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm27, %zmm3 {%k2}
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm10, %zmm4, %zmm20
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm15, %zmm21, %zmm20
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,0,0,0,0,7,23,0,0,0,0,0,8,24,0,0]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm26, %zmm2, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm20, %zmm17 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [22,0,0,0,0,5,6,23,0,0,0,0,12,13,24,0]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm25, %zmm20, %zmm0
; AVX512DQ-FCP-NEXT:    movw $28897, %ax # imm = 0x70E1
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k3
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k3}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,5,21,0,0,0,0,0,6,22,0,0]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm13, %zmm0, %zmm31
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm9, %zmm1, %zmm22
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm8, %zmm14, %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm22, %zmm5 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,0,0,5,21,0,0,0,0,0,6,22,0,0,0,0]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm12, %zmm21, %zmm24
; AVX512DQ-FCP-NEXT:    movw $12384, %ax # imm = 0x3060
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm31, %zmm24 {%k1}
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm10, %zmm4, %zmm2
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm15, %zmm20, %zmm2
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [4,20,0,0,0,0,0,5,21,0,0,0,0,0,6,22]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm26, %zmm20, %zmm23
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm2, %zmm5 {%k3}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,1,20,0,0,0,0,7,8,21,0,0,0,0,14,15]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm25, %zmm2, %zmm23
; AVX512DQ-FCP-NEXT:    movw $15480, %ax # imm = 0x3C78
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k2
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm24, %zmm23 {%k2}
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm9, %zmm1, %zmm0
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm8, %zmm14, %zmm21
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm0, %zmm21 {%k1}
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm10, %zmm4, %zmm20
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm15, %zmm2, %zmm20
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm21, %zmm20 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,3,19,0,0,0,0,0,4,20,0,0]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm12, %zmm0, %zmm29
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm8, %zmm0, %zmm14
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [2,18,0,0,0,0,0,3,19,0,0,0,0,0,4,20]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm13, %zmm0, %zmm19
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm9, %zmm0, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm29, %zmm19 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,18,0,0,0,0,0,3,19,0,0,0,0,0]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm10, %zmm0, %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm26, %zmm0, %zmm28
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,3,18,0,0,0,0,9,10,19,0,0,0,0]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm15, %zmm0, %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm25, %zmm0, %zmm28
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm14, %zmm1 {%k1}
; AVX512DQ-FCP-NEXT:    movw $3612, %ax # imm = 0xE1C
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm28, %zmm19 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm4, %zmm1 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [29,0,2,3,4,5,6,30,0,9,10,11,12,13,31,0]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm26, %zmm2, %zmm0
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,1,27,0,4,5,6,7,8,28,0,11,12,13,14,15]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm26, %zmm4, %zmm2
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,29,2,3,4,5,6,7,30,9,10,11,12,13,14,31]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm25, %zmm0, %zmm4
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,27,4,5,6,7,8,9,28,11,12,13,14,15]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm25, %zmm2, %zmm0
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, 64(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm20, 128(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, 192(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm17, 256(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm11, 320(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, 384(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, 448(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm19, 512(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm23, 576(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, 640(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm16, 704(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, (%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, 768(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, 832(%rax)
; AVX512DQ-FCP-NEXT:    popq %rax
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride7_vf32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    pushq %rax
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm14
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm18
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm8
; AVX512BW-NEXT:    vmovdqa64 64(%rsi), %zmm12
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm1
; AVX512BW-NEXT:    vmovdqa64 64(%rdx), %zmm23
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm9
; AVX512BW-NEXT:    vmovdqa64 64(%rcx), %zmm13
; AVX512BW-NEXT:    vmovdqa64 (%r8), %zmm4
; AVX512BW-NEXT:    vmovdqa64 64(%r8), %zmm22
; AVX512BW-NEXT:    vmovdqa64 (%r9), %zmm10
; AVX512BW-NEXT:    vmovdqa64 64(%r9), %zmm26
; AVX512BW-NEXT:    vmovdqa64 (%rax), %zmm15
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,0,0,0,14,30,0,0,0,0,0,15,31,0,0,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm21, %zmm0
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,14,30,0,0,0,0,0,15,31,0,0,0,0,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm3
; AVX512BW-NEXT:    vpermt2d %zmm12, %zmm6, %zmm3
; AVX512BW-NEXT:    movw $6192, %cx # imm = 0x1830
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k1}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,3,4,5,30,0,0,9,10,11,12,31,0,0]
; AVX512BW-NEXT:    vpermi2d %zmm22, %zmm3, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,0,0,0,12,28,0,0,0,0,0,13,29,0,0,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm12, %zmm20, %zmm0
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [11,0,0,0,0,0,28,12,0,0,0,0,0,29,13,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm3
; AVX512BW-NEXT:    vpermt2d %zmm23, %zmm11, %zmm3
; AVX512BW-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k1}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,27,0,0,4,5,6,7,28,0,0,11,12,13,14,29]
; AVX512BW-NEXT:    vpermi2d %zmm22, %zmm3, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm28 = [0,0,0,16,0,0,0,0,0,1,17,0,0,0,0,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm9, %zmm28, %zmm0
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm25 = [0,16,0,0,0,0,0,1,17,0,0,0,0,0,2,18]
; AVX512BW-NEXT:    vmovdqa64 %zmm14, %zmm7
; AVX512BW-NEXT:    vpermt2d %zmm8, %zmm25, %zmm7
; AVX512BW-NEXT:    movw $1548, %cx # imm = 0x60C
; AVX512BW-NEXT:    kmovd %ecx, %k2
; AVX512BW-NEXT:    vmovdqa32 %zmm0, %zmm7 {%k2}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm5
; AVX512BW-NEXT:    vpermt2d %zmm10, %zmm0, %zmm5
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm30
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm17 = [9,0,0,0,0,0,26,10,0,0,0,0,0,27,11,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm16
; AVX512BW-NEXT:    vpermt2d %zmm18, %zmm17, %zmm16
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm27
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm3
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm31
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm24
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm19
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm28, %zmm23
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm29
; AVX512BW-NEXT:    vpermt2d %zmm12, %zmm25, %zmm18
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,0,0,0,4,5,16,0,0,0,0,11,12,17,0,0]
; AVX512BW-NEXT:    vpermt2d %zmm15, %zmm2, %zmm5
; AVX512BW-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512BW-NEXT:    vmovdqa32 %zmm23, %zmm18 {%k2}
; AVX512BW-NEXT:    kmovd %ecx, %k2
; AVX512BW-NEXT:    vmovdqa32 %zmm5, %zmm7 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm22, %zmm5
; AVX512BW-NEXT:    vmovdqa64 %zmm22, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm22, %zmm23
; AVX512BW-NEXT:    vmovdqa64 %zmm22, %zmm28
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm25 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512BW-NEXT:    vpermt2d %zmm26, %zmm25, %zmm22
; AVX512BW-NEXT:    vmovdqa64 64(%rax), %zmm25
; AVX512BW-NEXT:    vpermt2d %zmm25, %zmm2, %zmm22
; AVX512BW-NEXT:    vmovdqa32 %zmm22, %zmm18 {%k2}
; AVX512BW-NEXT:    vpermi2d %zmm9, %zmm1, %zmm21
; AVX512BW-NEXT:    vpermi2d %zmm8, %zmm14, %zmm6
; AVX512BW-NEXT:    vmovdqa32 %zmm21, %zmm6 {%k1}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [13,0,0,0,0,0,30,14,0,0,0,0,0,31,15,0]
; AVX512BW-NEXT:    vpermi2d %zmm4, %zmm10, %zmm2
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,29,0,0,0,0,6,7,30,0,0,0,0,13,14,31]
; AVX512BW-NEXT:    vpermi2d %zmm15, %zmm2, %zmm21
; AVX512BW-NEXT:    movw $-7741, %ax # imm = 0xE1C3
; AVX512BW-NEXT:    kmovd %eax, %k2
; AVX512BW-NEXT:    vmovdqa32 %zmm21, %zmm6 {%k2}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,9,25,0,0,0,0,0,10,26,0,0,0,0,0,11]
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm2, %zmm30
; AVX512BW-NEXT:    movw $-31994, %ax # imm = 0x8306
; AVX512BW-NEXT:    kmovd %eax, %k2
; AVX512BW-NEXT:    vmovdqa32 %zmm30, %zmm16 {%k2}
; AVX512BW-NEXT:    vpermi2d %zmm8, %zmm14, %zmm20
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm9, %zmm11
; AVX512BW-NEXT:    vmovdqa32 %zmm20, %zmm11 {%k1}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,11,27,0,0,0,0,0,12,28,0,0,0,0,0,13]
; AVX512BW-NEXT:    vpermi2d %zmm10, %zmm4, %zmm20
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,1,2,27,0,0,0,0,8,9,28,0,0,0,0,15]
; AVX512BW-NEXT:    vpermi2d %zmm15, %zmm20, %zmm21
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,0,0,9,25,0,0,0,0,0,10,26,0,0,0,0]
; AVX512BW-NEXT:    vpermt2d %zmm26, %zmm20, %zmm5
; AVX512BW-NEXT:    movw $-30962, %ax # imm = 0x870E
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqa32 %zmm21, %zmm11 {%k1}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,0,0,3,4,25,0,0,0,0,10,11,26,0,0,0]
; AVX512BW-NEXT:    vpermt2d %zmm25, %zmm21, %zmm5
; AVX512BW-NEXT:    movw $7224, %ax # imm = 0x1C38
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqa32 %zmm5, %zmm16 {%k1}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm22 = [0,0,0,7,23,0,0,0,0,0,8,24,0,0,0,0]
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm22, %zmm27
; AVX512BW-NEXT:    vpermi2d %zmm9, %zmm1, %zmm2
; AVX512BW-NEXT:    vpermi2d %zmm14, %zmm8, %zmm17
; AVX512BW-NEXT:    vmovdqa32 %zmm2, %zmm17 {%k2}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,7,23,0,0,0,0,0,8,24,0,0,0,0,0,9]
; AVX512BW-NEXT:    vpermt2d %zmm12, %zmm5, %zmm3
; AVX512BW-NEXT:    movw $3096, %ax # imm = 0xC18
; AVX512BW-NEXT:    kmovd %eax, %k2
; AVX512BW-NEXT:    vmovdqa32 %zmm27, %zmm3 {%k2}
; AVX512BW-NEXT:    vpermi2d %zmm10, %zmm4, %zmm20
; AVX512BW-NEXT:    vpermt2d %zmm15, %zmm21, %zmm20
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,0,0,0,0,7,23,0,0,0,0,0,8,24,0,0]
; AVX512BW-NEXT:    vpermt2d %zmm26, %zmm2, %zmm0
; AVX512BW-NEXT:    vmovdqa32 %zmm20, %zmm17 {%k1}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [22,0,0,0,0,5,6,23,0,0,0,0,12,13,24,0]
; AVX512BW-NEXT:    vpermt2d %zmm25, %zmm20, %zmm0
; AVX512BW-NEXT:    movw $28897, %ax # imm = 0x70E1
; AVX512BW-NEXT:    kmovd %eax, %k3
; AVX512BW-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k3}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,5,21,0,0,0,0,0,6,22,0,0]
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm0, %zmm31
; AVX512BW-NEXT:    vpermi2d %zmm9, %zmm1, %zmm22
; AVX512BW-NEXT:    vpermi2d %zmm8, %zmm14, %zmm5
; AVX512BW-NEXT:    vmovdqa32 %zmm22, %zmm5 {%k2}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,0,0,5,21,0,0,0,0,0,6,22,0,0,0,0]
; AVX512BW-NEXT:    vpermt2d %zmm12, %zmm21, %zmm24
; AVX512BW-NEXT:    movw $12384, %ax # imm = 0x3060
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqa32 %zmm31, %zmm24 {%k1}
; AVX512BW-NEXT:    vpermi2d %zmm10, %zmm4, %zmm2
; AVX512BW-NEXT:    vpermt2d %zmm15, %zmm20, %zmm2
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [4,20,0,0,0,0,0,5,21,0,0,0,0,0,6,22]
; AVX512BW-NEXT:    vpermt2d %zmm26, %zmm20, %zmm23
; AVX512BW-NEXT:    vmovdqa32 %zmm2, %zmm5 {%k3}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,1,20,0,0,0,0,7,8,21,0,0,0,0,14,15]
; AVX512BW-NEXT:    vpermt2d %zmm25, %zmm2, %zmm23
; AVX512BW-NEXT:    movw $15480, %ax # imm = 0x3C78
; AVX512BW-NEXT:    kmovd %eax, %k2
; AVX512BW-NEXT:    vmovdqa32 %zmm24, %zmm23 {%k2}
; AVX512BW-NEXT:    vpermi2d %zmm9, %zmm1, %zmm0
; AVX512BW-NEXT:    vpermi2d %zmm8, %zmm14, %zmm21
; AVX512BW-NEXT:    vmovdqa32 %zmm0, %zmm21 {%k1}
; AVX512BW-NEXT:    vpermi2d %zmm10, %zmm4, %zmm20
; AVX512BW-NEXT:    vpermt2d %zmm15, %zmm2, %zmm20
; AVX512BW-NEXT:    vmovdqa32 %zmm21, %zmm20 {%k2}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,3,19,0,0,0,0,0,4,20,0,0]
; AVX512BW-NEXT:    vpermt2d %zmm12, %zmm0, %zmm29
; AVX512BW-NEXT:    vpermt2d %zmm8, %zmm0, %zmm14
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [2,18,0,0,0,0,0,3,19,0,0,0,0,0,4,20]
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm0, %zmm19
; AVX512BW-NEXT:    vpermt2d %zmm9, %zmm0, %zmm1
; AVX512BW-NEXT:    vmovdqa32 %zmm29, %zmm19 {%k1}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,18,0,0,0,0,0,3,19,0,0,0,0,0]
; AVX512BW-NEXT:    vpermt2d %zmm10, %zmm0, %zmm4
; AVX512BW-NEXT:    vpermt2d %zmm26, %zmm0, %zmm28
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,3,18,0,0,0,0,9,10,19,0,0,0,0]
; AVX512BW-NEXT:    vpermt2d %zmm15, %zmm0, %zmm4
; AVX512BW-NEXT:    vpermt2d %zmm25, %zmm0, %zmm28
; AVX512BW-NEXT:    vmovdqa32 %zmm14, %zmm1 {%k1}
; AVX512BW-NEXT:    movw $3612, %ax # imm = 0xE1C
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqa32 %zmm28, %zmm19 {%k1}
; AVX512BW-NEXT:    vmovdqa32 %zmm4, %zmm1 {%k1}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [29,0,2,3,4,5,6,30,0,9,10,11,12,13,31,0]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vpermi2d %zmm26, %zmm2, %zmm0
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,1,27,0,4,5,6,7,8,28,0,11,12,13,14,15]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vpermi2d %zmm26, %zmm4, %zmm2
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,29,2,3,4,5,6,7,30,9,10,11,12,13,14,31]
; AVX512BW-NEXT:    vpermi2d %zmm25, %zmm0, %zmm4
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,27,4,5,6,7,8,9,28,11,12,13,14,15]
; AVX512BW-NEXT:    vpermi2d %zmm25, %zmm2, %zmm0
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    vmovdqa64 %zmm1, 64(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm20, 128(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, 192(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm17, 256(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm11, 320(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm6, 384(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm18, 448(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm19, 512(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm23, 576(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm3, 640(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm16, 704(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, (%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 768(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm4, 832(%rax)
; AVX512BW-NEXT:    popq %rax
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i32_stride7_vf32:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    pushq %rax
; AVX512BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm14
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm18
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm8
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm12
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm23
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm9
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm13
; AVX512BW-FCP-NEXT:    vmovdqa64 (%r8), %zmm4
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%r8), %zmm22
; AVX512BW-FCP-NEXT:    vmovdqa64 (%r9), %zmm10
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%r9), %zmm26
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rax), %zmm15
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,0,0,0,14,30,0,0,0,0,0,15,31,0,0,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2d %zmm13, %zmm21, %zmm0
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,14,30,0,0,0,0,0,15,31,0,0,0,0,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm3
; AVX512BW-FCP-NEXT:    vpermt2d %zmm12, %zmm6, %zmm3
; AVX512BW-FCP-NEXT:    movw $6192, %cx # imm = 0x1830
; AVX512BW-FCP-NEXT:    kmovd %ecx, %k1
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,3,4,5,30,0,0,9,10,11,12,31,0,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm22, %zmm3, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,0,0,0,12,28,0,0,0,0,0,13,29,0,0,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2d %zmm12, %zmm20, %zmm0
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [11,0,0,0,0,0,28,12,0,0,0,0,0,29,13,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm13, %zmm3
; AVX512BW-FCP-NEXT:    vpermt2d %zmm23, %zmm11, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,27,0,0,4,5,6,7,28,0,0,11,12,13,14,29]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm22, %zmm3, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm28 = [0,0,0,16,0,0,0,0,0,1,17,0,0,0,0,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2d %zmm9, %zmm28, %zmm0
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm25 = [0,16,0,0,0,0,0,1,17,0,0,0,0,0,2,18]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm14, %zmm7
; AVX512BW-FCP-NEXT:    vpermt2d %zmm8, %zmm25, %zmm7
; AVX512BW-FCP-NEXT:    movw $1548, %cx # imm = 0x60C
; AVX512BW-FCP-NEXT:    kmovd %ecx, %k2
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm0, %zmm7 {%k2}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm5
; AVX512BW-FCP-NEXT:    vpermt2d %zmm10, %zmm0, %zmm5
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm30
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm17 = [9,0,0,0,0,0,26,10,0,0,0,0,0,27,11,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm12, %zmm16
; AVX512BW-FCP-NEXT:    vpermt2d %zmm18, %zmm17, %zmm16
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm27
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm31
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm24
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm19
; AVX512BW-FCP-NEXT:    vpermt2d %zmm13, %zmm28, %zmm23
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm29
; AVX512BW-FCP-NEXT:    vpermt2d %zmm12, %zmm25, %zmm18
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,0,0,0,4,5,16,0,0,0,0,11,12,17,0,0]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm15, %zmm2, %zmm5
; AVX512BW-FCP-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm23, %zmm18 {%k2}
; AVX512BW-FCP-NEXT:    kmovd %ecx, %k2
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm5, %zmm7 {%k2}
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm22, %zmm5
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm22, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm22, %zmm23
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm22, %zmm28
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm25 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm26, %zmm25, %zmm22
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rax), %zmm25
; AVX512BW-FCP-NEXT:    vpermt2d %zmm25, %zmm2, %zmm22
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm22, %zmm18 {%k2}
; AVX512BW-FCP-NEXT:    vpermi2d %zmm9, %zmm1, %zmm21
; AVX512BW-FCP-NEXT:    vpermi2d %zmm8, %zmm14, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm21, %zmm6 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [13,0,0,0,0,0,30,14,0,0,0,0,0,31,15,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm4, %zmm10, %zmm2
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,29,0,0,0,0,6,7,30,0,0,0,0,13,14,31]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm15, %zmm2, %zmm21
; AVX512BW-FCP-NEXT:    movw $-7741, %ax # imm = 0xE1C3
; AVX512BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm21, %zmm6 {%k2}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,9,25,0,0,0,0,0,10,26,0,0,0,0,0,11]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm13, %zmm2, %zmm30
; AVX512BW-FCP-NEXT:    movw $-31994, %ax # imm = 0x8306
; AVX512BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm30, %zmm16 {%k2}
; AVX512BW-FCP-NEXT:    vpermi2d %zmm8, %zmm14, %zmm20
; AVX512BW-FCP-NEXT:    vpermi2d %zmm1, %zmm9, %zmm11
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm20, %zmm11 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,11,27,0,0,0,0,0,12,28,0,0,0,0,0,13]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm10, %zmm4, %zmm20
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,1,2,27,0,0,0,0,8,9,28,0,0,0,0,15]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm15, %zmm20, %zmm21
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,0,0,9,25,0,0,0,0,0,10,26,0,0,0,0]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm26, %zmm20, %zmm5
; AVX512BW-FCP-NEXT:    movw $-30962, %ax # imm = 0x870E
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm21, %zmm11 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,0,0,3,4,25,0,0,0,0,10,11,26,0,0,0]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm25, %zmm21, %zmm5
; AVX512BW-FCP-NEXT:    movw $7224, %ax # imm = 0x1C38
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm5, %zmm16 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm22 = [0,0,0,7,23,0,0,0,0,0,8,24,0,0,0,0]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm13, %zmm22, %zmm27
; AVX512BW-FCP-NEXT:    vpermi2d %zmm9, %zmm1, %zmm2
; AVX512BW-FCP-NEXT:    vpermi2d %zmm14, %zmm8, %zmm17
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm2, %zmm17 {%k2}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,7,23,0,0,0,0,0,8,24,0,0,0,0,0,9]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm12, %zmm5, %zmm3
; AVX512BW-FCP-NEXT:    movw $3096, %ax # imm = 0xC18
; AVX512BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm27, %zmm3 {%k2}
; AVX512BW-FCP-NEXT:    vpermi2d %zmm10, %zmm4, %zmm20
; AVX512BW-FCP-NEXT:    vpermt2d %zmm15, %zmm21, %zmm20
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,0,0,0,0,7,23,0,0,0,0,0,8,24,0,0]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm26, %zmm2, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm20, %zmm17 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [22,0,0,0,0,5,6,23,0,0,0,0,12,13,24,0]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm25, %zmm20, %zmm0
; AVX512BW-FCP-NEXT:    movw $28897, %ax # imm = 0x70E1
; AVX512BW-FCP-NEXT:    kmovd %eax, %k3
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k3}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,5,21,0,0,0,0,0,6,22,0,0]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm13, %zmm0, %zmm31
; AVX512BW-FCP-NEXT:    vpermi2d %zmm9, %zmm1, %zmm22
; AVX512BW-FCP-NEXT:    vpermi2d %zmm8, %zmm14, %zmm5
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm22, %zmm5 {%k2}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,0,0,5,21,0,0,0,0,0,6,22,0,0,0,0]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm12, %zmm21, %zmm24
; AVX512BW-FCP-NEXT:    movw $12384, %ax # imm = 0x3060
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm31, %zmm24 {%k1}
; AVX512BW-FCP-NEXT:    vpermi2d %zmm10, %zmm4, %zmm2
; AVX512BW-FCP-NEXT:    vpermt2d %zmm15, %zmm20, %zmm2
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [4,20,0,0,0,0,0,5,21,0,0,0,0,0,6,22]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm26, %zmm20, %zmm23
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm2, %zmm5 {%k3}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,1,20,0,0,0,0,7,8,21,0,0,0,0,14,15]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm25, %zmm2, %zmm23
; AVX512BW-FCP-NEXT:    movw $15480, %ax # imm = 0x3C78
; AVX512BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm24, %zmm23 {%k2}
; AVX512BW-FCP-NEXT:    vpermi2d %zmm9, %zmm1, %zmm0
; AVX512BW-FCP-NEXT:    vpermi2d %zmm8, %zmm14, %zmm21
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm0, %zmm21 {%k1}
; AVX512BW-FCP-NEXT:    vpermi2d %zmm10, %zmm4, %zmm20
; AVX512BW-FCP-NEXT:    vpermt2d %zmm15, %zmm2, %zmm20
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm21, %zmm20 {%k2}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,3,19,0,0,0,0,0,4,20,0,0]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm12, %zmm0, %zmm29
; AVX512BW-FCP-NEXT:    vpermt2d %zmm8, %zmm0, %zmm14
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [2,18,0,0,0,0,0,3,19,0,0,0,0,0,4,20]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm13, %zmm0, %zmm19
; AVX512BW-FCP-NEXT:    vpermt2d %zmm9, %zmm0, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm29, %zmm19 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,18,0,0,0,0,0,3,19,0,0,0,0,0]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm10, %zmm0, %zmm4
; AVX512BW-FCP-NEXT:    vpermt2d %zmm26, %zmm0, %zmm28
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,3,18,0,0,0,0,9,10,19,0,0,0,0]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm15, %zmm0, %zmm4
; AVX512BW-FCP-NEXT:    vpermt2d %zmm25, %zmm0, %zmm28
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm14, %zmm1 {%k1}
; AVX512BW-FCP-NEXT:    movw $3612, %ax # imm = 0xE1C
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm28, %zmm19 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm4, %zmm1 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [29,0,2,3,4,5,6,30,0,9,10,11,12,13,31,0]
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vpermi2d %zmm26, %zmm2, %zmm0
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,1,27,0,4,5,6,7,8,28,0,11,12,13,14,15]
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vpermi2d %zmm26, %zmm4, %zmm2
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,29,2,3,4,5,6,7,30,9,10,11,12,13,14,31]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm25, %zmm0, %zmm4
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,27,4,5,6,7,8,9,28,11,12,13,14,15]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm25, %zmm2, %zmm0
; AVX512BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, 64(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm20, 128(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, 192(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm17, 256(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm11, 320(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, 384(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm18, 448(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm19, 512(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm23, 576(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, 640(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm16, 704(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, (%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, 768(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, 832(%rax)
; AVX512BW-FCP-NEXT:    popq %rax
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i32_stride7_vf32:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    pushq %rax
; AVX512DQ-BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm14
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdi), %zmm18
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rsi), %zmm8
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rsi), %zmm12
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdx), %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdx), %zmm23
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rcx), %zmm9
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rcx), %zmm13
; AVX512DQ-BW-NEXT:    vmovdqa64 (%r8), %zmm4
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%r8), %zmm22
; AVX512DQ-BW-NEXT:    vmovdqa64 (%r9), %zmm10
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%r9), %zmm26
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rax), %zmm15
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,0,0,0,14,30,0,0,0,0,0,15,31,0,0,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm23, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2d %zmm13, %zmm21, %zmm0
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,14,30,0,0,0,0,0,15,31,0,0,0,0,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm18, %zmm3
; AVX512DQ-BW-NEXT:    vpermt2d %zmm12, %zmm6, %zmm3
; AVX512DQ-BW-NEXT:    movw $6192, %cx # imm = 0x1830
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,3,4,5,30,0,0,9,10,11,12,31,0,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm22, %zmm3, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,0,0,0,12,28,0,0,0,0,0,13,29,0,0,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm18, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2d %zmm12, %zmm20, %zmm0
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [11,0,0,0,0,0,28,12,0,0,0,0,0,29,13,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm13, %zmm3
; AVX512DQ-BW-NEXT:    vpermt2d %zmm23, %zmm11, %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,27,0,0,4,5,6,7,28,0,0,11,12,13,14,29]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm22, %zmm3, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm28 = [0,0,0,16,0,0,0,0,0,1,17,0,0,0,0,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2d %zmm9, %zmm28, %zmm0
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm25 = [0,16,0,0,0,0,0,1,17,0,0,0,0,0,2,18]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm14, %zmm7
; AVX512DQ-BW-NEXT:    vpermt2d %zmm8, %zmm25, %zmm7
; AVX512DQ-BW-NEXT:    movw $1548, %cx # imm = 0x60C
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k2
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm0, %zmm7 {%k2}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm5
; AVX512DQ-BW-NEXT:    vpermt2d %zmm10, %zmm0, %zmm5
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm23, %zmm30
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm17 = [9,0,0,0,0,0,26,10,0,0,0,0,0,27,11,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm12, %zmm16
; AVX512DQ-BW-NEXT:    vpermt2d %zmm18, %zmm17, %zmm16
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm23, %zmm27
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm18, %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm23, %zmm31
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm18, %zmm24
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm23, %zmm19
; AVX512DQ-BW-NEXT:    vpermt2d %zmm13, %zmm28, %zmm23
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm18, %zmm29
; AVX512DQ-BW-NEXT:    vpermt2d %zmm12, %zmm25, %zmm18
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,0,0,0,4,5,16,0,0,0,0,11,12,17,0,0]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm15, %zmm2, %zmm5
; AVX512DQ-BW-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm23, %zmm18 {%k2}
; AVX512DQ-BW-NEXT:    kmovd %ecx, %k2
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm5, %zmm7 {%k2}
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm22, %zmm5
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm22, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm22, %zmm23
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm22, %zmm28
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm25 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm26, %zmm25, %zmm22
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rax), %zmm25
; AVX512DQ-BW-NEXT:    vpermt2d %zmm25, %zmm2, %zmm22
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm22, %zmm18 {%k2}
; AVX512DQ-BW-NEXT:    vpermi2d %zmm9, %zmm1, %zmm21
; AVX512DQ-BW-NEXT:    vpermi2d %zmm8, %zmm14, %zmm6
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm21, %zmm6 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [13,0,0,0,0,0,30,14,0,0,0,0,0,31,15,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm4, %zmm10, %zmm2
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,29,0,0,0,0,6,7,30,0,0,0,0,13,14,31]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm15, %zmm2, %zmm21
; AVX512DQ-BW-NEXT:    movw $-7741, %ax # imm = 0xE1C3
; AVX512DQ-BW-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm21, %zmm6 {%k2}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,9,25,0,0,0,0,0,10,26,0,0,0,0,0,11]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm13, %zmm2, %zmm30
; AVX512DQ-BW-NEXT:    movw $-31994, %ax # imm = 0x8306
; AVX512DQ-BW-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm30, %zmm16 {%k2}
; AVX512DQ-BW-NEXT:    vpermi2d %zmm8, %zmm14, %zmm20
; AVX512DQ-BW-NEXT:    vpermi2d %zmm1, %zmm9, %zmm11
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm20, %zmm11 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,11,27,0,0,0,0,0,12,28,0,0,0,0,0,13]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm10, %zmm4, %zmm20
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,1,2,27,0,0,0,0,8,9,28,0,0,0,0,15]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm15, %zmm20, %zmm21
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,0,0,9,25,0,0,0,0,0,10,26,0,0,0,0]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm26, %zmm20, %zmm5
; AVX512DQ-BW-NEXT:    movw $-30962, %ax # imm = 0x870E
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm21, %zmm11 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,0,0,3,4,25,0,0,0,0,10,11,26,0,0,0]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm25, %zmm21, %zmm5
; AVX512DQ-BW-NEXT:    movw $7224, %ax # imm = 0x1C38
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm5, %zmm16 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm22 = [0,0,0,7,23,0,0,0,0,0,8,24,0,0,0,0]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm13, %zmm22, %zmm27
; AVX512DQ-BW-NEXT:    vpermi2d %zmm9, %zmm1, %zmm2
; AVX512DQ-BW-NEXT:    vpermi2d %zmm14, %zmm8, %zmm17
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm2, %zmm17 {%k2}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,7,23,0,0,0,0,0,8,24,0,0,0,0,0,9]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm12, %zmm5, %zmm3
; AVX512DQ-BW-NEXT:    movw $3096, %ax # imm = 0xC18
; AVX512DQ-BW-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm27, %zmm3 {%k2}
; AVX512DQ-BW-NEXT:    vpermi2d %zmm10, %zmm4, %zmm20
; AVX512DQ-BW-NEXT:    vpermt2d %zmm15, %zmm21, %zmm20
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,0,0,0,0,7,23,0,0,0,0,0,8,24,0,0]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm26, %zmm2, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm20, %zmm17 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [22,0,0,0,0,5,6,23,0,0,0,0,12,13,24,0]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm25, %zmm20, %zmm0
; AVX512DQ-BW-NEXT:    movw $28897, %ax # imm = 0x70E1
; AVX512DQ-BW-NEXT:    kmovd %eax, %k3
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k3}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,5,21,0,0,0,0,0,6,22,0,0]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm13, %zmm0, %zmm31
; AVX512DQ-BW-NEXT:    vpermi2d %zmm9, %zmm1, %zmm22
; AVX512DQ-BW-NEXT:    vpermi2d %zmm8, %zmm14, %zmm5
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm22, %zmm5 {%k2}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,0,0,5,21,0,0,0,0,0,6,22,0,0,0,0]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm12, %zmm21, %zmm24
; AVX512DQ-BW-NEXT:    movw $12384, %ax # imm = 0x3060
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm31, %zmm24 {%k1}
; AVX512DQ-BW-NEXT:    vpermi2d %zmm10, %zmm4, %zmm2
; AVX512DQ-BW-NEXT:    vpermt2d %zmm15, %zmm20, %zmm2
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [4,20,0,0,0,0,0,5,21,0,0,0,0,0,6,22]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm26, %zmm20, %zmm23
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm2, %zmm5 {%k3}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,1,20,0,0,0,0,7,8,21,0,0,0,0,14,15]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm25, %zmm2, %zmm23
; AVX512DQ-BW-NEXT:    movw $15480, %ax # imm = 0x3C78
; AVX512DQ-BW-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm24, %zmm23 {%k2}
; AVX512DQ-BW-NEXT:    vpermi2d %zmm9, %zmm1, %zmm0
; AVX512DQ-BW-NEXT:    vpermi2d %zmm8, %zmm14, %zmm21
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm0, %zmm21 {%k1}
; AVX512DQ-BW-NEXT:    vpermi2d %zmm10, %zmm4, %zmm20
; AVX512DQ-BW-NEXT:    vpermt2d %zmm15, %zmm2, %zmm20
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm21, %zmm20 {%k2}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,3,19,0,0,0,0,0,4,20,0,0]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm12, %zmm0, %zmm29
; AVX512DQ-BW-NEXT:    vpermt2d %zmm8, %zmm0, %zmm14
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [2,18,0,0,0,0,0,3,19,0,0,0,0,0,4,20]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm13, %zmm0, %zmm19
; AVX512DQ-BW-NEXT:    vpermt2d %zmm9, %zmm0, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm29, %zmm19 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,18,0,0,0,0,0,3,19,0,0,0,0,0]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm10, %zmm0, %zmm4
; AVX512DQ-BW-NEXT:    vpermt2d %zmm26, %zmm0, %zmm28
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,3,18,0,0,0,0,9,10,19,0,0,0,0]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm15, %zmm0, %zmm4
; AVX512DQ-BW-NEXT:    vpermt2d %zmm25, %zmm0, %zmm28
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm14, %zmm1 {%k1}
; AVX512DQ-BW-NEXT:    movw $3612, %ax # imm = 0xE1C
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm28, %zmm19 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm4, %zmm1 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [29,0,2,3,4,5,6,30,0,9,10,11,12,13,31,0]
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vpermi2d %zmm26, %zmm2, %zmm0
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,1,27,0,4,5,6,7,8,28,0,11,12,13,14,15]
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vpermi2d %zmm26, %zmm4, %zmm2
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,29,2,3,4,5,6,7,30,9,10,11,12,13,14,31]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm25, %zmm0, %zmm4
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,27,4,5,6,7,8,9,28,11,12,13,14,15]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm25, %zmm2, %zmm0
; AVX512DQ-BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, 64(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm20, 128(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, 192(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm17, 256(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm11, 320(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm6, 384(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm18, 448(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm19, 512(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm23, 576(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, 640(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm16, 704(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, (%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, 768(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, 832(%rax)
; AVX512DQ-BW-NEXT:    popq %rax
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i32_stride7_vf32:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    pushq %rax
; AVX512DQ-BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm14
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm18
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm8
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm12
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm23
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm9
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm13
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%r8), %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%r8), %zmm22
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%r9), %zmm10
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%r9), %zmm26
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rax), %zmm15
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,0,0,0,14,30,0,0,0,0,0,15,31,0,0,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm13, %zmm21, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,0,14,30,0,0,0,0,0,15,31,0,0,0,0,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm12, %zmm6, %zmm3
; AVX512DQ-BW-FCP-NEXT:    movw $6192, %cx # imm = 0x1830
; AVX512DQ-BW-FCP-NEXT:    kmovd %ecx, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,3,4,5,30,0,0,9,10,11,12,31,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm22, %zmm3, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,0,0,0,12,28,0,0,0,0,0,13,29,0,0,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm12, %zmm20, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [11,0,0,0,0,0,28,12,0,0,0,0,0,29,13,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm13, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm23, %zmm11, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,27,0,0,4,5,6,7,28,0,0,11,12,13,14,29]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm22, %zmm3, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm28 = [0,0,0,16,0,0,0,0,0,1,17,0,0,0,0,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm9, %zmm28, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm25 = [0,16,0,0,0,0,0,1,17,0,0,0,0,0,2,18]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm14, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm8, %zmm25, %zmm7
; AVX512DQ-BW-FCP-NEXT:    movw $1548, %cx # imm = 0x60C
; AVX512DQ-BW-FCP-NEXT:    kmovd %ecx, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm0, %zmm7 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm10, %zmm0, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm30
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm17 = [9,0,0,0,0,0,26,10,0,0,0,0,0,27,11,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm12, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm18, %zmm17, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm27
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm31
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm24
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm19
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm13, %zmm28, %zmm23
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm29
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm12, %zmm25, %zmm18
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,0,0,0,4,5,16,0,0,0,0,11,12,17,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm15, %zmm2, %zmm5
; AVX512DQ-BW-FCP-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm23, %zmm18 {%k2}
; AVX512DQ-BW-FCP-NEXT:    kmovd %ecx, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm5, %zmm7 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm22, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm22, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm22, %zmm23
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm22, %zmm28
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm25 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm26, %zmm25, %zmm22
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rax), %zmm25
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm25, %zmm2, %zmm22
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm22, %zmm18 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm9, %zmm1, %zmm21
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm8, %zmm14, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm21, %zmm6 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [13,0,0,0,0,0,30,14,0,0,0,0,0,31,15,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm4, %zmm10, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,29,0,0,0,0,6,7,30,0,0,0,0,13,14,31]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm15, %zmm2, %zmm21
; AVX512DQ-BW-FCP-NEXT:    movw $-7741, %ax # imm = 0xE1C3
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm21, %zmm6 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,9,25,0,0,0,0,0,10,26,0,0,0,0,0,11]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm13, %zmm2, %zmm30
; AVX512DQ-BW-FCP-NEXT:    movw $-31994, %ax # imm = 0x8306
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm30, %zmm16 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm8, %zmm14, %zmm20
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm1, %zmm9, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm20, %zmm11 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,11,27,0,0,0,0,0,12,28,0,0,0,0,0,13]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm10, %zmm4, %zmm20
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,1,2,27,0,0,0,0,8,9,28,0,0,0,0,15]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm15, %zmm20, %zmm21
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,0,0,9,25,0,0,0,0,0,10,26,0,0,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm26, %zmm20, %zmm5
; AVX512DQ-BW-FCP-NEXT:    movw $-30962, %ax # imm = 0x870E
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm21, %zmm11 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,0,0,3,4,25,0,0,0,0,10,11,26,0,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm25, %zmm21, %zmm5
; AVX512DQ-BW-FCP-NEXT:    movw $7224, %ax # imm = 0x1C38
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm5, %zmm16 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm22 = [0,0,0,7,23,0,0,0,0,0,8,24,0,0,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm13, %zmm22, %zmm27
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm9, %zmm1, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm14, %zmm8, %zmm17
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm2, %zmm17 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,7,23,0,0,0,0,0,8,24,0,0,0,0,0,9]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm12, %zmm5, %zmm3
; AVX512DQ-BW-FCP-NEXT:    movw $3096, %ax # imm = 0xC18
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm27, %zmm3 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm10, %zmm4, %zmm20
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm15, %zmm21, %zmm20
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,0,0,0,0,7,23,0,0,0,0,0,8,24,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm26, %zmm2, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm20, %zmm17 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [22,0,0,0,0,5,6,23,0,0,0,0,12,13,24,0]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm25, %zmm20, %zmm0
; AVX512DQ-BW-FCP-NEXT:    movw $28897, %ax # imm = 0x70E1
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k3}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,5,21,0,0,0,0,0,6,22,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm13, %zmm0, %zmm31
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm9, %zmm1, %zmm22
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm8, %zmm14, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm22, %zmm5 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm21 = [0,0,0,5,21,0,0,0,0,0,6,22,0,0,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm12, %zmm21, %zmm24
; AVX512DQ-BW-FCP-NEXT:    movw $12384, %ax # imm = 0x3060
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm31, %zmm24 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm10, %zmm4, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm15, %zmm20, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [4,20,0,0,0,0,0,5,21,0,0,0,0,0,6,22]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm26, %zmm20, %zmm23
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm2, %zmm5 {%k3}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,1,20,0,0,0,0,7,8,21,0,0,0,0,14,15]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm25, %zmm2, %zmm23
; AVX512DQ-BW-FCP-NEXT:    movw $15480, %ax # imm = 0x3C78
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm24, %zmm23 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm9, %zmm1, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm8, %zmm14, %zmm21
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm0, %zmm21 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm10, %zmm4, %zmm20
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm15, %zmm2, %zmm20
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm21, %zmm20 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,3,19,0,0,0,0,0,4,20,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm12, %zmm0, %zmm29
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm8, %zmm0, %zmm14
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [2,18,0,0,0,0,0,3,19,0,0,0,0,0,4,20]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm13, %zmm0, %zmm19
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm9, %zmm0, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm29, %zmm19 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,18,0,0,0,0,0,3,19,0,0,0,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm10, %zmm0, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm26, %zmm0, %zmm28
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,3,18,0,0,0,0,9,10,19,0,0,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm15, %zmm0, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm25, %zmm0, %zmm28
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm14, %zmm1 {%k1}
; AVX512DQ-BW-FCP-NEXT:    movw $3612, %ax # imm = 0xE1C
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm28, %zmm19 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm4, %zmm1 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [29,0,2,3,4,5,6,30,0,9,10,11,12,13,31,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm26, %zmm2, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,1,27,0,4,5,6,7,8,28,0,11,12,13,14,15]
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm26, %zmm4, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,29,2,3,4,5,6,7,30,9,10,11,12,13,14,31]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm25, %zmm0, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,27,4,5,6,7,8,9,28,11,12,13,14,15]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm25, %zmm2, %zmm0
; AVX512DQ-BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, 64(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm20, 128(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, 192(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm17, 256(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm11, 320(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm6, 384(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm18, 448(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm19, 512(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm23, 576(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, 640(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm16, 704(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, (%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, 768(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, 832(%rax)
; AVX512DQ-BW-FCP-NEXT:    popq %rax
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <32 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <32 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <32 x i32>, ptr %in.vecptr2, align 64
  %in.vec3 = load <32 x i32>, ptr %in.vecptr3, align 64
  %in.vec4 = load <32 x i32>, ptr %in.vecptr4, align 64
  %in.vec5 = load <32 x i32>, ptr %in.vecptr5, align 64
  %in.vec6 = load <32 x i32>, ptr %in.vecptr6, align 64
  %1 = shufflevector <32 x i32> %in.vec0, <32 x i32> %in.vec1, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %2 = shufflevector <32 x i32> %in.vec2, <32 x i32> %in.vec3, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %3 = shufflevector <32 x i32> %in.vec4, <32 x i32> %in.vec5, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %4 = shufflevector <64 x i32> %1, <64 x i32> %2, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %5 = shufflevector <32 x i32> %in.vec6, <32 x i32> poison, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <64 x i32> %3, <64 x i32> %5, <96 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95>
  %7 = shufflevector <96 x i32> %6, <96 x i32> poison, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %8 = shufflevector <128 x i32> %4, <128 x i32> %7, <224 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223>
  %interleaved.vec = shufflevector <224 x i32> %8, <224 x i32> poison, <224 x i32> <i32 0, i32 32, i32 64, i32 96, i32 128, i32 160, i32 192, i32 1, i32 33, i32 65, i32 97, i32 129, i32 161, i32 193, i32 2, i32 34, i32 66, i32 98, i32 130, i32 162, i32 194, i32 3, i32 35, i32 67, i32 99, i32 131, i32 163, i32 195, i32 4, i32 36, i32 68, i32 100, i32 132, i32 164, i32 196, i32 5, i32 37, i32 69, i32 101, i32 133, i32 165, i32 197, i32 6, i32 38, i32 70, i32 102, i32 134, i32 166, i32 198, i32 7, i32 39, i32 71, i32 103, i32 135, i32 167, i32 199, i32 8, i32 40, i32 72, i32 104, i32 136, i32 168, i32 200, i32 9, i32 41, i32 73, i32 105, i32 137, i32 169, i32 201, i32 10, i32 42, i32 74, i32 106, i32 138, i32 170, i32 202, i32 11, i32 43, i32 75, i32 107, i32 139, i32 171, i32 203, i32 12, i32 44, i32 76, i32 108, i32 140, i32 172, i32 204, i32 13, i32 45, i32 77, i32 109, i32 141, i32 173, i32 205, i32 14, i32 46, i32 78, i32 110, i32 142, i32 174, i32 206, i32 15, i32 47, i32 79, i32 111, i32 143, i32 175, i32 207, i32 16, i32 48, i32 80, i32 112, i32 144, i32 176, i32 208, i32 17, i32 49, i32 81, i32 113, i32 145, i32 177, i32 209, i32 18, i32 50, i32 82, i32 114, i32 146, i32 178, i32 210, i32 19, i32 51, i32 83, i32 115, i32 147, i32 179, i32 211, i32 20, i32 52, i32 84, i32 116, i32 148, i32 180, i32 212, i32 21, i32 53, i32 85, i32 117, i32 149, i32 181, i32 213, i32 22, i32 54, i32 86, i32 118, i32 150, i32 182, i32 214, i32 23, i32 55, i32 87, i32 119, i32 151, i32 183, i32 215, i32 24, i32 56, i32 88, i32 120, i32 152, i32 184, i32 216, i32 25, i32 57, i32 89, i32 121, i32 153, i32 185, i32 217, i32 26, i32 58, i32 90, i32 122, i32 154, i32 186, i32 218, i32 27, i32 59, i32 91, i32 123, i32 155, i32 187, i32 219, i32 28, i32 60, i32 92, i32 124, i32 156, i32 188, i32 220, i32 29, i32 61, i32 93, i32 125, i32 157, i32 189, i32 221, i32 30, i32 62, i32 94, i32 126, i32 158, i32 190, i32 222, i32 31, i32 63, i32 95, i32 127, i32 159, i32 191, i32 223>
  store <224 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride7_vf64(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride7_vf64:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $2760, %rsp # imm = 0xAC8
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa (%rdi), %xmm6
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsi), %xmm4
; SSE-NEXT:    movdqa 16(%rsi), %xmm3
; SSE-NEXT:    movaps (%rdx), %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 16(%rdx), %xmm7
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rcx), %xmm13
; SSE-NEXT:    movaps 16(%rcx), %xmm9
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%r8), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 16(%r8), %xmm10
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%r9), %xmm12
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 16(%r9), %xmm8
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rax), %xmm15
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm13[1,1]
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm4[1,1,1,1]
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm1[0],xmm2[1,2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm4[2],xmm0[3],xmm4[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm15[1,1,1,1]
; SSE-NEXT:    movdqa %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm12[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[1,1,1,1]
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movaps %xmm10, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm9[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 16(%rax), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm8[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa 16(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 32(%rsi), %xmm1
; SSE-NEXT:    movaps 32(%rdx), %xmm3
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm1
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE-NEXT:    movaps 32(%rcx), %xmm3
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%r8), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 32(%r9), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 32(%rax), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa 32(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 48(%rsi), %xmm2
; SSE-NEXT:    movdqa 48(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,1,1]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movaps 48(%rcx), %xmm4
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%r8), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm4[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 48(%r9), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 48(%rax), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa 48(%rdi), %xmm5
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 64(%rsi), %xmm1
; SSE-NEXT:    movaps 64(%rdx), %xmm4
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm1
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE-NEXT:    movaps 64(%rcx), %xmm4
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%r8), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm4[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 64(%r9), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 64(%rax), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa 64(%rdi), %xmm8
; SSE-NEXT:    movdqa %xmm8, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 80(%rsi), %xmm2
; SSE-NEXT:    movdqa 80(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,1,1]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movaps 80(%rcx), %xmm4
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%r8), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm4[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 80(%r9), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 80(%rax), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa 80(%rdi), %xmm9
; SSE-NEXT:    movdqa %xmm9, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 96(%rsi), %xmm1
; SSE-NEXT:    movaps 96(%rdx), %xmm4
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm1
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE-NEXT:    movaps 96(%rcx), %xmm10
; SSE-NEXT:    movaps 96(%r8), %xmm0
; SSE-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm10[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 96(%r9), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 96(%rax), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa 96(%rdi), %xmm12
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 112(%rsi), %xmm2
; SSE-NEXT:    movdqa 112(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,1,1]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movaps 112(%rcx), %xmm4
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%r8), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm4[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 112(%r9), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 112(%rax), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa 112(%rdi), %xmm14
; SSE-NEXT:    movdqa %xmm14, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 128(%rsi), %xmm1
; SSE-NEXT:    movaps 128(%rdx), %xmm4
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm1
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE-NEXT:    movaps 128(%rcx), %xmm4
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 128(%r8), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm4[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 128(%r9), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 128(%rax), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa 128(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 144(%rsi), %xmm2
; SSE-NEXT:    movdqa 144(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,1,1]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movaps 144(%rcx), %xmm4
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 144(%r8), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm4[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 144(%r9), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 144(%rax), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa 144(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 160(%rsi), %xmm1
; SSE-NEXT:    movaps 160(%rdx), %xmm4
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm1
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE-NEXT:    movaps 160(%rcx), %xmm4
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 160(%r8), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm4[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 160(%r9), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 160(%rax), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa 160(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 176(%rsi), %xmm2
; SSE-NEXT:    movdqa 176(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,1,1]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movaps 176(%rcx), %xmm4
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 176(%r8), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm4[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 176(%r9), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 176(%rax), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa 176(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 192(%rsi), %xmm1
; SSE-NEXT:    movaps 192(%rdx), %xmm4
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm1
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE-NEXT:    movaps 192(%rcx), %xmm4
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 192(%r8), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm4[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 192(%r9), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 192(%rax), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa 192(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 208(%rsi), %xmm3
; SSE-NEXT:    movdqa 208(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[1,1,1,1]
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movaps 208(%rcx), %xmm6
; SSE-NEXT:    movaps 208(%r8), %xmm4
; SSE-NEXT:    movaps %xmm4, %xmm0
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm6[1,1]
; SSE-NEXT:    movaps %xmm6, %xmm2
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 208(%r9), %xmm6
; SSE-NEXT:    movdqa 208(%rax), %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; SSE-NEXT:    movdqa %xmm1, %xmm7
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm6[1,1,1,1]
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa 208(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa %xmm7, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm6[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 224(%rsi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 224(%rdx), %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm0[0],xmm2[1,2,3]
; SSE-NEXT:    movaps 224(%rcx), %xmm4
; SSE-NEXT:    movaps 224(%r8), %xmm0
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm4[1,1]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    movaps 224(%r9), %xmm7
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm7[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm7, %xmm1
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm0[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; SSE-NEXT:    movaps 224(%rax), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm0[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm1[0,2]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 240(%rsi), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 240(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; SSE-NEXT:    movaps 240(%rcx), %xmm6
; SSE-NEXT:    movaps 240(%r8), %xmm0
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm6[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    movaps 240(%r9), %xmm11
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm11[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm11, %xmm1
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm11 = xmm11[1],xmm0[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm6[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; SSE-NEXT:    movaps 240(%rax), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm0[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm1[0,2]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    movaps %xmm13, %xmm2
; SSE-NEXT:    movaps %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm13[0],xmm0[1],xmm13[1]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    movaps %xmm4, %xmm3
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = xmm3[0],mem[0],xmm3[1],mem[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm3 = xmm3[0],xmm0[0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[0,1],xmm4[1,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    movaps %xmm4, %xmm3
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm13[0],xmm3[1],xmm13[1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm15[0,2]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm13[2],xmm0[3],xmm13[3]
; SSE-NEXT:    movaps %xmm1, %xmm3
; SSE-NEXT:    unpckhps {{.*#+}} xmm3 = xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm3 = xmm3[0],xmm0[0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm13[0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, %xmm3
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = xmm3[0],mem[0],xmm3[1],mem[1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    shufps $197, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[0,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, %xmm3
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm13, %xmm3
; SSE-NEXT:    unpckhps {{.*#+}} xmm3 = xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm4[2],xmm0[3],xmm4[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm3 = xmm3[0],xmm0[0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    movaps %xmm4, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movaps %xmm3, %xmm2
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = xmm2[0],mem[0],xmm2[1],mem[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm0[0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm3[1,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, %xmm15
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm15 = xmm15[0],xmm3[0],xmm15[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; SSE-NEXT:    movaps %xmm4, %xmm2
; SSE-NEXT:    unpckhps {{.*#+}} xmm2 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm0[0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    punpckldq {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = xmm3[0],mem[0],xmm3[1],mem[1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    shufps $197, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[0,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movaps %xmm3, %xmm5
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    unpckhps {{.*#+}} xmm5 = xmm5[2],xmm1[2],xmm5[3],xmm1[3]
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm4[2],xmm0[3],xmm4[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm0[0]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm8, %xmm3
; SSE-NEXT:    punpckldq {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = xmm3[0],mem[0],xmm3[1],mem[1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm8[1,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    movaps %xmm4, %xmm8
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm8 = xmm8[0],xmm3[0],xmm8[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    punpckhdq {{.*#+}} xmm3 = xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    punpckldq {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = xmm3[0],mem[0],xmm3[1],mem[1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm9, %xmm0
; SSE-NEXT:    shufps $197, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[0,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movaps %xmm3, %xmm8
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm8 = xmm8[0],xmm4[0],xmm8[1],xmm4[1]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm8
; SSE-NEXT:    unpckhps {{.*#+}} xmm8 = xmm8[2],xmm1[2],xmm8[3],xmm1[3]
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm4[2],xmm0[3],xmm4[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm0[0]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm10[0],xmm0[1],xmm10[1]
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm12, %xmm3
; SSE-NEXT:    punpckldq {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = xmm3[0],mem[0],xmm3[1],mem[1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm12[1,3]
; SSE-NEXT:    movaps (%rsp), %xmm4 # 16-byte Reload
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm1[0],xmm5[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE-NEXT:    movaps %xmm2, %xmm3
; SSE-NEXT:    unpckhps {{.*#+}} xmm3 = xmm3[2],xmm10[2],xmm3[3],xmm10[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm3 = xmm3[0],xmm0[0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm14, %xmm3
; SSE-NEXT:    punpckldq {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = xmm3[0],mem[0],xmm3[1],mem[1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps $197, {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Folded Reload
; SSE-NEXT:    # xmm14 = xmm14[1,1],mem[0,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm14[2,0]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    unpckhps {{.*#+}} xmm5 = xmm5[2],xmm1[2],xmm5[3],xmm1[3]
; SSE-NEXT:    movaps %xmm4, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm0[0]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm5
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Folded Reload
; SSE-NEXT:    # xmm5 = xmm5[0],mem[0],xmm5[1],mem[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm0[0]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[1,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm8
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm8 = xmm8[0],xmm4[0],xmm8[1],xmm4[1]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm4[2],xmm0[3],xmm4[3]
; SSE-NEXT:    movaps %xmm3, %xmm1
; SSE-NEXT:    unpckhps {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm3[0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm5
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Folded Reload
; SSE-NEXT:    # xmm5 = xmm5[0],mem[0],xmm5[1],mem[1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    shufps $197, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[0,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm8
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm8 = xmm8[0],xmm4[0],xmm8[1],xmm4[1]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm8
; SSE-NEXT:    unpckhps {{.*#+}} xmm8 = xmm8[2],xmm2[2],xmm8[3],xmm2[3]
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm4[2],xmm0[3],xmm4[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm0[0]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm5
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Folded Reload
; SSE-NEXT:    # xmm5 = xmm5[0],mem[0],xmm5[1],mem[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm0[0]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[1,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm8
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm8 = xmm8[0],xmm4[0],xmm8[1],xmm4[1]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm4[2],xmm0[3],xmm4[3]
; SSE-NEXT:    movaps %xmm3, %xmm1
; SSE-NEXT:    unpckhps {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm3[0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm5
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Folded Reload
; SSE-NEXT:    # xmm5 = xmm5[0],mem[0],xmm5[1],mem[1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    shufps $197, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[0,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm4
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm5[0],xmm4[1],xmm5[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm4
; SSE-NEXT:    unpckhps {{.*#+}} xmm4 = xmm4[2],xmm2[2],xmm4[3],xmm2[3]
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm5[2],xmm0[3],xmm5[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm0[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; SSE-NEXT:    movaps %xmm15, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm4
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = xmm4[0],mem[0],xmm4[1],mem[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm0[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[1,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm4
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm5[0],xmm4[1],xmm5[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm5[2],xmm0[3],xmm5[3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm15 = xmm15[2],xmm2[2],xmm15[3],xmm2[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm15 = xmm15[0],xmm0[0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; SSE-NEXT:    movaps %xmm14, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,1],xmm14[3,3]
; SSE-NEXT:    movaps %xmm1, %xmm4
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm13
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    unpckhps {{.*#+}} xmm13 = xmm13[2],xmm2[2],xmm13[3],xmm2[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm1[0]
; SSE-NEXT:    movaps %xmm2, %xmm3
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm14 = xmm14[0],xmm2[0],xmm14[1],xmm2[1]
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[0,1],xmm3[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movaps %xmm3, %xmm12
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm12 = xmm12[0],xmm5[0],xmm12[1],xmm5[1]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,1],xmm0[2,0]
; SSE-NEXT:    unpckhps {{.*#+}} xmm3 = xmm3[2],xmm5[2],xmm3[3],xmm5[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm13 = xmm13[0],xmm3[0]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm1[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1]
; SSE-NEXT:    movaps 224(%rdi), %xmm8
; SSE-NEXT:    movaps %xmm8, %xmm10
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm10 = xmm10[0],xmm2[0],xmm10[1],xmm2[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm10 = xmm10[0],xmm0[0]
; SSE-NEXT:    movaps %xmm8, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,2],xmm0[2,0]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm8, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,2],xmm0[0,1]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm9
; SSE-NEXT:    unpckhps {{.*#+}} xmm9 = xmm9[2],xmm4[2],xmm9[3],xmm4[3]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,1],xmm7[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[3,1],xmm1[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,0],xmm3[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, %xmm7
; SSE-NEXT:    unpckhps {{.*#+}} xmm7 = xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; SSE-NEXT:    movlhps {{.*#+}} xmm6 = xmm6[0],xmm0[0]
; SSE-NEXT:    movaps %xmm0, %xmm4
; SSE-NEXT:    movaps 240(%rdi), %xmm3
; SSE-NEXT:    movaps %xmm3, %xmm5
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm2[0],xmm5[1],xmm2[1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm6[2,0]
; SSE-NEXT:    movaps %xmm3, %xmm6
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[1,1],xmm1[0,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm6[2,0]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm6
; SSE-NEXT:    unpckhps {{.*#+}} xmm6 = xmm6[2],xmm2[2],xmm6[3],xmm2[3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm6[0,1]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,1],xmm11[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[3,1],xmm1[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[2,0],xmm4[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = xmm4[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3],xmm4[2,0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm11[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm0 = xmm4[0],xmm0[1,2,3]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Folded Reload
; SSE-NEXT:    # xmm11 = xmm11[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3],xmm11[2,0]
; SSE-NEXT:    pshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = mem[3,3,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm0 = xmm4[0],xmm0[1,2,3]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3],xmm1[2,0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm6[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm0 = xmm4[0],xmm0[1,2,3]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Folded Reload
; SSE-NEXT:    # xmm6 = xmm6[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3],xmm6[2,0]
; SSE-NEXT:    pshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = mem[3,3,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm0 = xmm4[0],xmm0[1,2,3]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = xmm4[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3],xmm4[2,0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm6[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm0 = xmm4[0],xmm0[1,2,3]
; SSE-NEXT:    movaps %xmm0, %xmm2
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Folded Reload
; SSE-NEXT:    # xmm6 = xmm6[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3],xmm6[2,0]
; SSE-NEXT:    pshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = mem[3,3,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm0 = xmm4[0],xmm0[1,2,3]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],xmm0[2,0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm6[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm4[0],xmm1[1,2,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Folded Reload
; SSE-NEXT:    # xmm6 = xmm6[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3],xmm6[2,0]
; SSE-NEXT:    pshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = mem[3,3,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm0 = xmm4[0],xmm0[1,2,3]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = xmm4[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3],xmm4[2,0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm6[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm0 = xmm4[0],xmm0[1,2,3]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Folded Reload
; SSE-NEXT:    # xmm6 = xmm6[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3],xmm6[2,0]
; SSE-NEXT:    pshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = mem[3,3,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm0 = xmm4[0],xmm0[1,2,3]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],xmm0[2,0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm6[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm4[0],xmm1[1,2,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Folded Reload
; SSE-NEXT:    # xmm6 = xmm6[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3],xmm6[2,0]
; SSE-NEXT:    pshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = mem[3,3,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm0 = xmm4[0],xmm0[1,2,3]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = xmm4[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],xmm4[2,0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm4[0],xmm1[1,2,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; SSE-NEXT:    movaps (%rsp), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],xmm0[2,0]
; SSE-NEXT:    pshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = mem[3,3,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm4[0],xmm1[1,2,3]
; SSE-NEXT:    movaps %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],xmm0[2,0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm4[0],xmm1[1,2,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],xmm0[2,0]
; SSE-NEXT:    pshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = mem[3,3,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm4[0],xmm1[1,2,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],xmm0[2,0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm4[0],xmm1[1,2,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],xmm0[2,0]
; SSE-NEXT:    pshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = mem[3,3,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm4[0],xmm1[1,2,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],xmm0[2,0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm4[0],xmm1[1,2,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],xmm0[2,0]
; SSE-NEXT:    pshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = mem[3,3,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm4[0],xmm1[1,2,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],xmm0[2,0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm4[0],xmm1[1,2,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],xmm0[2,0]
; SSE-NEXT:    pshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = mem[3,3,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm4[0],xmm1[1,2,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],xmm0[2,0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm4[0],xmm1[1,2,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[0,3],xmm0[2,0]
; SSE-NEXT:    pshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = mem[3,3,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm11 = xmm4[0],xmm11[1,2,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = xmm4[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,3],xmm4[2,0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm1[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm6 = xmm4[0],xmm6[1,2,3]
; SSE-NEXT:    shufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[3,3],mem[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3],xmm1[2,0]
; SSE-NEXT:    pshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = mem[3,3,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm0 = xmm4[0],xmm0[1,2,3]
; SSE-NEXT:    movaps %xmm0, %xmm4
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movaps %xmm3, 1760(%rax)
; SSE-NEXT:    movaps %xmm7, 1744(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1728(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 1696(%rax)
; SSE-NEXT:    movaps %xmm5, 1680(%rax)
; SSE-NEXT:    movaps %xmm8, 1648(%rax)
; SSE-NEXT:    movaps %xmm9, 1632(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1616(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 1584(%rax)
; SSE-NEXT:    movaps %xmm10, 1568(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1536(%rax)
; SSE-NEXT:    movaps %xmm13, 1520(%rax)
; SSE-NEXT:    movaps %xmm12, 1472(%rax)
; SSE-NEXT:    movaps %xmm14, 1456(%rax)
; SSE-NEXT:    movaps %xmm15, 1408(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1360(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1344(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1296(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1248(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1232(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1184(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1136(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1120(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 1072(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 1024(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 1008(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 960(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 912(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 896(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 848(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 800(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 784(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 736(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 688(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 672(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 624(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 576(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 560(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 512(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 464(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 448(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 400(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 352(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 336(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 288(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 240(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 224(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 112(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, (%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 1776(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 1712(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 1664(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 1600(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 1552(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 1504(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 1488(%rax)
; SSE-NEXT:    movaps %xmm4, 1440(%rax)
; SSE-NEXT:    movaps %xmm6, 1424(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1392(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1376(%rax)
; SSE-NEXT:    movaps %xmm11, 1328(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1312(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1280(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1264(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1216(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1200(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1168(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1152(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1104(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1088(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1056(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1040(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 992(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 976(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 944(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 928(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 880(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 864(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 832(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 816(%rax)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 768(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 752(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 720(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 704(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 656(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 640(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 608(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 592(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 544(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 528(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 496(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%rax)
; SSE-NEXT:    movaps %xmm2, 304(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    addq $2760, %rsp # imm = 0xAC8
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i32_stride7_vf64:
; AVX:       # %bb.0:
; AVX-NEXT:    subq $3432, %rsp # imm = 0xD68
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX-NEXT:    vmovaps 224(%rdi), %ymm1
; AVX-NEXT:    vmovaps 224(%rsi), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 224(%rdx), %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 224(%rcx), %ymm5
; AVX-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 224(%r8), %ymm4
; AVX-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 224(%rax), %ymm3
; AVX-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm5[2],ymm0[3],ymm5[3],ymm0[6],ymm5[6],ymm0[7],ymm5[7]
; AVX-NEXT:    vmovaps %ymm1, %ymm5
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm2[1],ymm1[1],ymm2[3],ymm1[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm5[0,1],ymm1[2,0],ymm5[4,5],ymm1[6,4]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[2,3],ymm0[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm4[6,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = mem[2,3,2,3]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4,5,6],ymm1[7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm3[2,3],ymm0[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4],ymm1[5],ymm0[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps (%rax), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps (%r9), %xmm3
; AVX-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps (%r8), %xmm4
; AVX-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps (%rdi), %xmm1
; AVX-NEXT:    vmovaps (%rsi), %xmm5
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm5[0],xmm1[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,1]
; AVX-NEXT:    vmovaps %xmm1, %xmm6
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovaps (%rcx), %xmm7
; AVX-NEXT:    vmovaps (%rdx), %xmm8
; AVX-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; AVX-NEXT:    vmovaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6],ymm0[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm3[1,1],xmm4[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm2[5],ymm0[6,7]
; AVX-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm6[1],xmm5[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm5[1,1],xmm1[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm1, %ymm1
; AVX-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm8[1],xmm7[1],zero
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps (%rdi), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps (%rsi), %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,1],ymm1[1,1],ymm0[5,5],ymm1[5,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX-NEXT:    vmovaps (%rdx), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps (%rcx), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[1,1],ymm1[1,1],ymm2[5,5],ymm1[5,5]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX-NEXT:    vmovaps (%r8), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps (%r9), %ymm8
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm8[0],ymm2[0],ymm8[2],ymm2[2]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[2,0],ymm2[2,1],ymm1[6,4],ymm2[6,5]
; AVX-NEXT:    vmovaps (%rax), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],ymm1[2,3]
; AVX-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 32(%rdi), %xmm1
; AVX-NEXT:    vmovaps 32(%rsi), %xmm6
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm6[0],xmm1[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,1]
; AVX-NEXT:    vmovaps %xmm1, %xmm9
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovaps 32(%rcx), %xmm3
; AVX-NEXT:    vmovaps 32(%rdx), %xmm2
; AVX-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm2[0],xmm3[0],xmm2[1],xmm3[1]
; AVX-NEXT:    vmovaps %xmm3, %xmm10
; AVX-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps %xmm2, %xmm12
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovaps 32(%r9), %xmm3
; AVX-NEXT:    vmovaps %xmm3, (%rsp) # 16-byte Spill
; AVX-NEXT:    vmovaps 32(%r8), %xmm4
; AVX-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vmovaps 32(%rax), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6],ymm0[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm3[1,1],xmm4[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm2[5],ymm0[6,7]
; AVX-NEXT:    vmovaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm9[1],xmm6[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm6[1,1],xmm1[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm1, %ymm1
; AVX-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm12[1],xmm10[1],zero
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 32(%rsi), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[1,1],ymm0[1,1],ymm1[5,5],ymm0[5,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX-NEXT:    vmovaps 32(%rdx), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 32(%rcx), %ymm10
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1],ymm10[1,1],ymm1[5,5],ymm10[5,5]
; AVX-NEXT:    vmovups %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX-NEXT:    vmovaps 32(%r8), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 32(%r9), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[2,0],ymm2[2,1],ymm1[6,4],ymm2[6,5]
; AVX-NEXT:    vmovaps 32(%rax), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],ymm1[2,3]
; AVX-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 64(%rdi), %xmm1
; AVX-NEXT:    vmovaps 64(%rsi), %xmm6
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm6[0],xmm1[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,1]
; AVX-NEXT:    vmovaps %xmm1, %xmm7
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovaps 64(%rcx), %xmm3
; AVX-NEXT:    vmovaps 64(%rdx), %xmm5
; AVX-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; AVX-NEXT:    vmovaps %xmm3, %xmm9
; AVX-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovaps 64(%r9), %xmm3
; AVX-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 64(%r8), %xmm4
; AVX-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vmovaps 64(%rax), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6],ymm0[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm3[1,1],xmm4[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm2[5],ymm0[6,7]
; AVX-NEXT:    vmovaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm7[1],xmm6[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm6[1,1],xmm1[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm1, %ymm1
; AVX-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm5[1],xmm9[1],zero
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 64(%rdi), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 64(%rsi), %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,1],ymm1[1,1],ymm0[5,5],ymm1[5,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX-NEXT:    vmovaps 64(%rdx), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 64(%rcx), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[1,1],ymm1[1,1],ymm2[5,5],ymm1[5,5]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX-NEXT:    vmovaps 64(%r8), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 64(%r9), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[2,0],ymm2[2,1],ymm1[6,4],ymm2[6,5]
; AVX-NEXT:    vmovaps 64(%rax), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],ymm1[2,3]
; AVX-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 96(%rdi), %xmm1
; AVX-NEXT:    vmovaps 96(%rsi), %xmm3
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm3[0],xmm1[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,1]
; AVX-NEXT:    vmovaps %xmm1, %xmm5
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovaps 96(%rcx), %xmm4
; AVX-NEXT:    vmovaps 96(%rdx), %xmm2
; AVX-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm2[0],xmm4[0],xmm2[1],xmm4[1]
; AVX-NEXT:    vmovaps %xmm4, %xmm7
; AVX-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps %xmm2, %xmm9
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovaps 96(%r9), %xmm4
; AVX-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 96(%r8), %xmm6
; AVX-NEXT:    vmovaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm6[0],xmm4[0],xmm6[1],xmm4[1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vmovaps 96(%rax), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6],ymm0[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm4[1,1],xmm6[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm2[5],ymm0[6,7]
; AVX-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm5[1],xmm3[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm3[1,1],xmm1[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm1, %ymm1
; AVX-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm9[1],xmm7[1],zero
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 96(%rdi), %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 96(%rsi), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[1,1],ymm0[1,1],ymm1[5,5],ymm0[5,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX-NEXT:    vmovaps 96(%rdx), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 96(%rcx), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[1,1],ymm1[1,1],ymm2[5,5],ymm1[5,5]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX-NEXT:    vmovaps 96(%r8), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 96(%r9), %ymm14
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm14[0],ymm2[0],ymm14[2],ymm2[2]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[2,0],ymm2[2,1],ymm1[6,4],ymm2[6,5]
; AVX-NEXT:    vmovaps 96(%rax), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],ymm1[2,3]
; AVX-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 128(%rdi), %xmm1
; AVX-NEXT:    vmovaps 128(%rsi), %xmm4
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm4[0],xmm1[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,1]
; AVX-NEXT:    vmovaps %xmm1, %xmm5
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovaps 128(%rcx), %xmm3
; AVX-NEXT:    vmovaps 128(%rdx), %xmm2
; AVX-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm2[0],xmm3[0],xmm2[1],xmm3[1]
; AVX-NEXT:    vmovaps %xmm3, %xmm7
; AVX-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps %xmm2, %xmm9
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovaps 128(%r9), %xmm3
; AVX-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 128(%r8), %xmm6
; AVX-NEXT:    vmovaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm6[0],xmm3[0],xmm6[1],xmm3[1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vmovaps 128(%rax), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6],ymm0[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm3[1,1],xmm6[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm2[5],ymm0[6,7]
; AVX-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm5[1],xmm4[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm4[1,1],xmm1[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm1, %ymm1
; AVX-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm9[1],xmm7[1],zero
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 128(%rdi), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 128(%rsi), %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,1],ymm1[1,1],ymm0[5,5],ymm1[5,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX-NEXT:    vmovaps 128(%rdx), %ymm9
; AVX-NEXT:    vmovaps 128(%rcx), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm9[1,1],ymm1[1,1],ymm9[5,5],ymm1[5,5]
; AVX-NEXT:    vmovups %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX-NEXT:    vmovaps 128(%r8), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 128(%r9), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[2,0],ymm2[2,1],ymm1[6,4],ymm2[6,5]
; AVX-NEXT:    vmovaps 128(%rax), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],ymm1[2,3]
; AVX-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 160(%rdi), %xmm1
; AVX-NEXT:    vmovaps 160(%rsi), %xmm6
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm6[0],xmm1[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,1]
; AVX-NEXT:    vmovaps %xmm1, %xmm11
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovaps 160(%rcx), %xmm7
; AVX-NEXT:    vmovaps 160(%rdx), %xmm3
; AVX-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm3[0],xmm7[0],xmm3[1],xmm7[1]
; AVX-NEXT:    vmovaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovaps 160(%r9), %xmm4
; AVX-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 160(%r8), %xmm5
; AVX-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vmovaps 160(%rax), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6],ymm0[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm4[1,1],xmm5[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm2[5],ymm0[6,7]
; AVX-NEXT:    vmovaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm11[1],xmm6[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm6[1,1],xmm1[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm1, %ymm1
; AVX-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm3[1],xmm7[1],zero
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 160(%rdi), %ymm15
; AVX-NEXT:    vmovaps 160(%rsi), %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,1],ymm15[1,1],ymm0[5,5],ymm15[5,5]
; AVX-NEXT:    vmovups %ymm15, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX-NEXT:    vmovaps 160(%rdx), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 160(%rcx), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[1,1],ymm1[1,1],ymm2[5,5],ymm1[5,5]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX-NEXT:    vmovaps 160(%r8), %ymm11
; AVX-NEXT:    vmovaps 160(%r9), %ymm13
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm13[0],ymm11[0],ymm13[2],ymm11[2]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[2,0],ymm11[2,1],ymm1[6,4],ymm11[6,5]
; AVX-NEXT:    vmovups %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 160(%rax), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],ymm1[2,3]
; AVX-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 192(%rdi), %xmm1
; AVX-NEXT:    vmovaps 192(%rsi), %xmm3
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm3[0],xmm1[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,1]
; AVX-NEXT:    vmovaps %xmm1, %xmm12
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovaps 192(%rcx), %xmm7
; AVX-NEXT:    vmovaps 192(%rdx), %xmm6
; AVX-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm6[0],xmm7[0],xmm6[1],xmm7[1]
; AVX-NEXT:    vmovaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovaps 192(%r9), %xmm4
; AVX-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 192(%r8), %xmm5
; AVX-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vmovaps 192(%rax), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6],ymm0[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm4[1,1],xmm5[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm2[5],ymm0[6,7]
; AVX-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm12[1],xmm3[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm3[1,1],xmm1[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm1, %ymm1
; AVX-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm6[1],xmm7[1],zero
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 192(%rdi), %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 192(%rsi), %ymm7
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm7[1,1],ymm0[1,1],ymm7[5,5],ymm0[5,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX-NEXT:    vmovaps 192(%rdx), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 192(%rcx), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm2 = ymm1[1,1],ymm2[1,1],ymm1[5,5],ymm2[5,5]
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm0[0,1,2,3,4],ymm2[5,6],ymm0[7]
; AVX-NEXT:    vmovaps 192(%r8), %ymm1
; AVX-NEXT:    vmovaps 192(%r9), %ymm2
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm12 = ymm2[0],ymm1[0],ymm2[2],ymm1[2]
; AVX-NEXT:    vshufps {{.*#+}} ymm12 = ymm12[2,0],ymm1[2,1],ymm12[6,4],ymm1[6,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = mem[2,3],ymm12[2,3]
; AVX-NEXT:    vextractf128 $1, %ymm12, %xmm12
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm12[0],ymm0[0],ymm12[2],ymm0[3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm4[3,4,5,6],ymm0[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,1,2,0,4,5,6,4]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX-NEXT:    vunpckhps {{.*#+}} ymm4 = ymm3[2],ymm5[2],ymm3[3],ymm5[3],ymm3[6],ymm5[6],ymm3[7],ymm5[7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm4[2,3]
; AVX-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm4 = ymm4[1],ymm8[1],ymm4[3],ymm8[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm4 = ymm8[1,1],ymm4[0,2],ymm8[5,5],ymm4[4,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3,2,3]
; AVX-NEXT:    vmovaps 16(%rax), %xmm12
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm12[1],ymm4[2,3,4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0,1],ymm0[2,3,4,5],ymm4[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,1,2,0,4,5,6,4]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX-NEXT:    vunpckhps {{.*#+}} ymm4 = ymm3[2],ymm10[2],ymm3[3],ymm10[3],ymm3[6],ymm10[6],ymm3[7],ymm10[7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm4[2,3]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm4 = ymm4[1],ymm3[1],ymm4[3],ymm3[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm4 = ymm3[1,1],ymm4[0,2],ymm3[5,5],ymm4[4,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3,2,3]
; AVX-NEXT:    vmovaps 48(%rax), %xmm12
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm12[1],ymm4[2,3,4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0,1],ymm0[2,3,4,5],ymm4[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,1,2,0,4,5,6,4]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm4 # 32-byte Folded Reload
; AVX-NEXT:    # ymm4 = ymm3[2],mem[2],ymm3[3],mem[3],ymm3[6],mem[6],ymm3[7],mem[7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm4[2,3]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm4 = ymm4[1],ymm3[1],ymm4[3],ymm3[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm4 = ymm3[1,1],ymm4[0,2],ymm3[5,5],ymm4[4,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3,2,3]
; AVX-NEXT:    vmovaps 80(%rax), %xmm12
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm12[1],ymm4[2,3,4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0,1],ymm0[2,3,4,5],ymm4[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,1,2,0,4,5,6,4]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm4 # 32-byte Folded Reload
; AVX-NEXT:    # ymm4 = ymm10[2],mem[2],ymm10[3],mem[3],ymm10[6],mem[6],ymm10[7],mem[7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm4[2,3]
; AVX-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm4 = ymm4[1],ymm14[1],ymm4[3],ymm14[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm4 = ymm14[1,1],ymm4[0,2],ymm14[5,5],ymm4[4,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3,2,3]
; AVX-NEXT:    vmovaps 112(%rax), %xmm12
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm12[1],ymm4[2,3,4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0,1],ymm0[2,3,4,5],ymm4[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,1,2,0,4,5,6,4]
; AVX-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm9, %ymm4 # 32-byte Folded Reload
; AVX-NEXT:    # ymm4 = ymm9[2],mem[2],ymm9[3],mem[3],ymm9[6],mem[6],ymm9[7],mem[7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm4[2,3]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm4 = ymm3[1],ymm6[1],ymm3[3],ymm6[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm4 = ymm6[1,1],ymm4[0,2],ymm6[5,5],ymm4[4,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3,2,3]
; AVX-NEXT:    vmovaps 144(%rax), %xmm12
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm12[1],ymm4[2,3,4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0,1],ymm0[2,3,4,5],ymm4[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm15[1],ymm0[3],ymm15[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,1,2,0,4,5,6,4]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm9, %ymm4 # 32-byte Folded Reload
; AVX-NEXT:    # ymm4 = ymm9[2],mem[2],ymm9[3],mem[3],ymm9[6],mem[6],ymm9[7],mem[7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm4[2,3]
; AVX-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm4 = ymm11[1],ymm13[1],ymm11[3],ymm13[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm4 = ymm13[1,1],ymm4[0,2],ymm13[5,5],ymm4[4,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3,2,3]
; AVX-NEXT:    vmovaps 176(%rax), %xmm12
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm12[1],ymm4[2,3,4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0,1],ymm0[2,3,4,5],ymm4[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm7[1],ymm11[1],ymm7[3],ymm11[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,1,2,0,4,5,6,4]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX-NEXT:    vunpckhps {{.*#+}} ymm4 = ymm6[2],ymm8[2],ymm6[3],ymm8[3],ymm6[6],ymm8[6],ymm6[7],ymm8[7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm4[2,3]
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[1,1],ymm1[0,2],ymm2[5,5],ymm1[4,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX-NEXT:    vmovaps 208(%rax), %xmm2
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 224(%rsi), %xmm3
; AVX-NEXT:    vmovaps 224(%rdi), %xmm2
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm2[1],xmm3[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm3[1,1],xmm1[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm1, %ymm1
; AVX-NEXT:    vmovaps 224(%rcx), %xmm4
; AVX-NEXT:    vmovaps 224(%rdx), %xmm12
; AVX-NEXT:    vinsertps {{.*#+}} xmm0 = zero,xmm12[1],xmm4[1],zero
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm0[1,2],ymm1[3,4,5,6,7]
; AVX-NEXT:    vbroadcastss 228(%r8), %ymm14
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2],ymm14[3],ymm1[4,5,6,7]
; AVX-NEXT:    vbroadcastss 228(%r9), %ymm14
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm14[4,5],ymm1[6,7]
; AVX-NEXT:    vinsertf128 $1, 224(%rax), %ymm0, %ymm0
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3,4],ymm0[5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm4[1],xmm12[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,0],xmm12[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm2[3,3],xmm3[3,3]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vbroadcastss 232(%r9), %xmm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3],ymm0[4,5,6,7]
; AVX-NEXT:    vbroadcastss 232(%rax), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4],ymm0[5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm8[3,3],ymm6[3,3],ymm8[7,7],ymm6[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm11[3,3],ymm7[3,3],ymm11[7,7],ymm7[7,7]
; AVX-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX-NEXT:    vbroadcastss 220(%r8), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX-NEXT:    vbroadcastss 220(%r9), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX-NEXT:    vbroadcastsd 216(%rax), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4,5,6],ymm1[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm12[0],xmm4[0],xmm12[1],xmm4[1]
; AVX-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm3[0],xmm2[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[2,0],xmm2[2,1]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,1,0,1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm2
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, 224(%r8), %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX-NEXT:    vbroadcastss 224(%r9), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX-NEXT:    vbroadcastss 224(%rax), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6],ymm0[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm8[3,3],ymm3[3,3],ymm8[7,7],ymm3[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm4[3,3],ymm2[3,3],ymm4[7,7],ymm2[7,7]
; AVX-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX-NEXT:    vbroadcastss 252(%r8), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX-NEXT:    vbroadcastss 252(%r9), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX-NEXT:    vbroadcastsd 248(%rax), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4,5,6],ymm1[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm3[0],ymm8[0],ymm3[2],ymm8[2]
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm8[3,1],ymm0[0,2],ymm8[7,5],ymm0[4,6]
; AVX-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm4[0],ymm2[0],ymm4[1],ymm2[1],ymm4[4],ymm2[4],ymm4[5],ymm2[5]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX-NEXT:    vbroadcastss 236(%r8), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6,7]
; AVX-NEXT:    vbroadcastss 236(%r9), %xmm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = ymm0[0,1,2],mem[3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm3[1,1],ymm8[1,1],ymm3[5,5],ymm8[5,5]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[1,1],ymm4[1,1],ymm2[5,5],ymm4[5,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5,6],ymm1[7]
; AVX-NEXT:    vbroadcastsd 240(%r8), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4,5,6],ymm1[7]
; AVX-NEXT:    vbroadcastss 240(%r9), %xmm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5,6,7]
; AVX-NEXT:    vbroadcastss 240(%rax), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = xmm8[2],mem[2],xmm8[3],mem[3]
; AVX-NEXT:    vinsertf128 $1, %xmm8, %ymm1, %ymm1
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5,6],ymm1[7]
; AVX-NEXT:    vpermilps $170, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[2,2,2,2]
; AVX-NEXT:    vblendps $7, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[0,1,2],xmm1[3]
; AVX-NEXT:    vbroadcastsd 8(%rax), %ymm2
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4],ymm0[5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = ymm5[3,3],mem[3,3],ymm5[7,7],mem[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[3,3],ymm6[3,3],ymm1[7,7],ymm6[7,7]
; AVX-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX-NEXT:    # ymm1 = ymm1[3,3],mem[3,3],ymm1[7,7],mem[7,7]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[2,3],ymm1[1,2],ymm2[6,7],ymm1[5,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,2,3,1,4,6,7,5]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = xmm2[2],mem[2],xmm2[3],mem[3]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5,6],ymm1[7]
; AVX-NEXT:    vpermilps $170, (%rsp), %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[2,2,2,2]
; AVX-NEXT:    vblendps $7, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[0,1,2],xmm1[3]
; AVX-NEXT:    vbroadcastsd 40(%rax), %ymm2
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4],ymm0[5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = ymm0[3,3],mem[3,3],ymm0[7,7],mem[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm1 # 32-byte Folded Reload
; AVX-NEXT:    # ymm1 = ymm4[3,3],mem[3,3],ymm4[7,7],mem[7,7]
; AVX-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX-NEXT:    # ymm1 = ymm1[3,3],mem[3,3],ymm1[7,7],mem[7,7]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[2,3],ymm1[1,2],ymm2[6,7],ymm1[5,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,2,3,1,4,6,7,5]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = xmm2[2],mem[2],xmm2[3],mem[3]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5,6],ymm1[7]
; AVX-NEXT:    vpermilps $170, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[2,2,2,2]
; AVX-NEXT:    vblendps $7, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[0,1,2],xmm1[3]
; AVX-NEXT:    vbroadcastsd 72(%rax), %ymm2
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4],ymm0[5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = ymm0[3,3],mem[3,3],ymm0[7,7],mem[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX-NEXT:    # ymm1 = ymm1[3,3],mem[3,3],ymm1[7,7],mem[7,7]
; AVX-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX-NEXT:    # ymm1 = ymm1[3,3],mem[3,3],ymm1[7,7],mem[7,7]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[2,3],ymm1[1,2],ymm2[6,7],ymm1[5,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,2,3,1,4,6,7,5]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = xmm2[2],mem[2],xmm2[3],mem[3]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5,6],ymm1[7]
; AVX-NEXT:    vpermilps $170, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[2,2,2,2]
; AVX-NEXT:    vblendps $7, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[0,1,2],xmm1[3]
; AVX-NEXT:    vbroadcastsd 104(%rax), %ymm2
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4],ymm0[5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[3,3],ymm10[3,3],ymm0[7,7],ymm10[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX-NEXT:    # ymm1 = ymm1[3,3],mem[3,3],ymm1[7,7],mem[7,7]
; AVX-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX-NEXT:    # ymm1 = ymm1[3,3],mem[3,3],ymm1[7,7],mem[7,7]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[2,3],ymm1[1,2],ymm2[6,7],ymm1[5,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,2,3,1,4,6,7,5]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[3,3],mem[3,3]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = xmm2[2],mem[2],xmm2[3],mem[3]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5,6],ymm1[7]
; AVX-NEXT:    vpermilps $170, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[2,2,2,2]
; AVX-NEXT:    vblendps $7, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[0,1,2],xmm1[3]
; AVX-NEXT:    vbroadcastsd 136(%rax), %ymm2
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4],ymm0[5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Reload
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm12[3,3],ymm15[3,3],ymm12[7,7],ymm15[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[3,3],ymm11[3,3],ymm2[7,7],ymm11[7,7]
; AVX-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX-NEXT:    # ymm1 = ymm1[3,3],mem[3,3],ymm1[7,7],mem[7,7]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm3[2,3],ymm1[1,2],ymm3[6,7],ymm1[5,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,2,3,1,4,6,7,5]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = xmm0[3,3],mem[3,3]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm3 # 16-byte Folded Reload
; AVX-NEXT:    # xmm3 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm3
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1,2,3,4],ymm1[5,6],ymm3[7]
; AVX-NEXT:    vpermilps $170, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; AVX-NEXT:    # xmm3 = mem[2,2,2,2]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX-NEXT:    vblendps {{.*#+}} xmm3 = xmm13[0,1,2],xmm3[3]
; AVX-NEXT:    vbroadcastsd 168(%rax), %ymm14
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm14[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm3[2,3,4],ymm1[5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm10[3,3],ymm9[3,3],ymm10[7,7],ymm9[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vshufps {{.*#+}} ymm3 = ymm0[3,3],ymm9[3,3],ymm0[7,7],ymm9[7,7]
; AVX-NEXT:    vextractf128 $1, %ymm3, %xmm3
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1,2],ymm1[3,4,5,6,7]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm3 # 32-byte Folded Reload
; AVX-NEXT:    # ymm3 = ymm3[3,3],mem[3,3],ymm3[7,7],mem[7,7]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX-NEXT:    vshufps {{.*#+}} ymm3 = ymm5[2,3],ymm3[1,2],ymm5[6,7],ymm3[5,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3,2,3]
; AVX-NEXT:    vshufps {{.*#+}} ymm3 = ymm3[0,2,3,1,4,6,7,5]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0],ymm1[1,2,3,4],ymm3[5,6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = xmm1[3,3],mem[3,3]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm3 # 16-byte Folded Reload
; AVX-NEXT:    # xmm3 = xmm5[2],mem[2],xmm5[3],mem[3]
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm3, %ymm3
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1,2,3,4],ymm1[5,6],ymm3[7]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX-NEXT:    vshufps {{.*#+}} xmm3 = xmm8[2,2,2,2]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX-NEXT:    vblendps {{.*#+}} xmm3 = xmm7[0,1,2],xmm3[3]
; AVX-NEXT:    vbroadcastsd 200(%rax), %ymm5
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm5[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm3[2,3,4],ymm1[5,6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm1[0],ymm6[0],ymm1[1],ymm6[1],ymm1[4],ymm6[4],ymm1[5],ymm6[5]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm3[0],ymm6[0],ymm3[2],ymm6[2]
; AVX-NEXT:    vshufps {{.*#+}} ymm3 = ymm6[3,1],ymm3[0,2],ymm6[7,5],ymm3[4,6]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1,2,3],ymm1[4,5],ymm3[6,7]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX-NEXT:    # xmm3 = xmm3[3,3],mem[3,3]
; AVX-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX-NEXT:    # xmm3 = xmm3[0,1,2],mem[3]
; AVX-NEXT:    vblendps {{.*#+}} ymm14 = ymm1[0],ymm3[1,2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm1 # 32-byte Folded Reload
; AVX-NEXT:    # ymm1 = ymm4[0],mem[0],ymm4[1],mem[1],ymm4[4],mem[4],ymm4[5],mem[5]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm3[0],ymm4[0],ymm3[2],ymm4[2]
; AVX-NEXT:    vshufps {{.*#+}} ymm3 = ymm4[3,1],ymm3[0,2],ymm4[7,5],ymm3[4,6]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1,2,3],ymm1[4,5],ymm3[6,7]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX-NEXT:    vshufps $255, (%rsp), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX-NEXT:    # xmm3 = xmm3[3,3],mem[3,3]
; AVX-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX-NEXT:    # xmm3 = xmm3[0,1,2],mem[3]
; AVX-NEXT:    vblendps {{.*#+}} ymm6 = ymm1[0],ymm3[1,2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX-NEXT:    # ymm1 = ymm1[0],mem[0],ymm1[1],mem[1],ymm1[4],mem[4],ymm1[5],mem[5]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm3[0],ymm4[0],ymm3[2],ymm4[2]
; AVX-NEXT:    vshufps {{.*#+}} ymm3 = ymm4[3,1],ymm3[0,2],ymm4[7,5],ymm3[4,6]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1,2,3],ymm1[4,5],ymm3[6,7]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX-NEXT:    # xmm3 = xmm3[3,3],mem[3,3]
; AVX-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX-NEXT:    # xmm3 = xmm3[0,1,2],mem[3]
; AVX-NEXT:    vblendps {{.*#+}} ymm5 = ymm1[0],ymm3[1,2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX-NEXT:    # ymm1 = ymm1[0],mem[0],ymm1[1],mem[1],ymm1[4],mem[4],ymm1[5],mem[5]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm3[0],ymm4[0],ymm3[2],ymm4[2]
; AVX-NEXT:    vshufps {{.*#+}} ymm3 = ymm4[3,1],ymm3[0,2],ymm4[7,5],ymm3[4,6]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1,2,3],ymm1[4,5],ymm3[6,7]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX-NEXT:    # xmm3 = xmm3[3,3],mem[3,3]
; AVX-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX-NEXT:    # xmm3 = xmm3[0,1,2],mem[3]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm3[1,2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vunpcklps {{.*#+}} ymm3 = ymm2[0],ymm11[0],ymm2[1],ymm11[1],ymm2[4],ymm11[4],ymm2[5],ymm11[5]
; AVX-NEXT:    vmovaps %ymm12, %ymm2
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm12 = ymm15[0],ymm12[0],ymm15[2],ymm12[2]
; AVX-NEXT:    vshufps {{.*#+}} ymm12 = ymm2[3,1],ymm12[0,2],ymm2[7,5],ymm12[4,6]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm12[0,1,2,3],ymm3[4,5],ymm12[6,7]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm12 # 16-byte Folded Reload
; AVX-NEXT:    # xmm12 = xmm2[3,3],mem[3,3]
; AVX-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm12, %xmm12 # 16-byte Folded Reload
; AVX-NEXT:    # xmm12 = xmm12[0,1,2],mem[3]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm12[1,2,3],ymm3[4,5,6,7]
; AVX-NEXT:    vunpcklps {{.*#+}} ymm12 = ymm0[0],ymm9[0],ymm0[1],ymm9[1],ymm0[4],ymm9[4],ymm0[5],ymm9[5]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm15 = ymm2[0],ymm10[0],ymm2[2],ymm10[2]
; AVX-NEXT:    vshufps {{.*#+}} ymm11 = ymm10[3,1],ymm15[0,2],ymm10[7,5],ymm15[4,6]
; AVX-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3],ymm12[4,5],ymm11[6,7]
; AVX-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm13, %xmm12 # 16-byte Folded Reload
; AVX-NEXT:    # xmm12 = xmm13[3,3],mem[3,3]
; AVX-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm12, %xmm12 # 16-byte Folded Reload
; AVX-NEXT:    # xmm12 = xmm12[0,1,2],mem[3]
; AVX-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0],ymm12[1,2,3],ymm11[4,5,6,7]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm12 # 32-byte Folded Reload
; AVX-NEXT:    # ymm12 = ymm0[0],mem[0],ymm0[1],mem[1],ymm0[4],mem[4],ymm0[5],mem[5]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm13 = ymm2[0],ymm0[0],ymm2[2],ymm0[2]
; AVX-NEXT:    vshufps {{.*#+}} ymm10 = ymm0[3,1],ymm13[0,2],ymm0[7,5],ymm13[4,6]
; AVX-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm12[4,5],ymm10[6,7]
; AVX-NEXT:    vshufps {{.*#+}} xmm12 = xmm7[3,3],xmm8[3,3]
; AVX-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm12, %xmm12 # 16-byte Folded Reload
; AVX-NEXT:    # xmm12 = xmm12[0,1,2],mem[3]
; AVX-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0],ymm12[1,2,3],ymm10[4,5,6,7]
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX-NEXT:    vmovaps %ymm10, 1440(%rax)
; AVX-NEXT:    vmovaps %ymm11, 1216(%rax)
; AVX-NEXT:    vmovaps %ymm3, 992(%rax)
; AVX-NEXT:    vmovaps %ymm1, 768(%rax)
; AVX-NEXT:    vmovaps %ymm5, 544(%rax)
; AVX-NEXT:    vmovaps %ymm6, 320(%rax)
; AVX-NEXT:    vmovaps %ymm14, 96(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1504(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1408(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1312(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1280(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1184(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1088(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1056(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 960(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 864(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 832(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 736(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 640(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1696(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1664(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1472(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1376(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1344(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1248(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1152(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1120(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1024(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 928(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 896(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 800(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, (%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1760(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1728(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1568(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1536(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1632(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1600(%rax)
; AVX-NEXT:    addq $3432, %rsp # imm = 0xD68
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i32_stride7_vf64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    subq $2968, %rsp # imm = 0xB98
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    vmovaps (%rax), %xmm0
; AVX2-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-NEXT:    vmovaps (%r8), %xmm13
; AVX2-NEXT:    vmovaps 32(%r8), %xmm4
; AVX2-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps (%r9), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 32(%r9), %xmm5
; AVX2-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],xmm13[1],xmm1[2,3]
; AVX2-NEXT:    vbroadcastsd %xmm1, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5],ymm1[6,7]
; AVX2-NEXT:    vmovaps (%rcx), %xmm10
; AVX2-NEXT:    vmovaps 32(%rcx), %xmm3
; AVX2-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps (%rdx), %xmm9
; AVX2-NEXT:    vinsertps {{.*#+}} xmm1 = zero,xmm9[1],xmm10[1],zero
; AVX2-NEXT:    vmovaps (%rdi), %xmm7
; AVX2-NEXT:    vmovaps 32(%rdi), %xmm8
; AVX2-NEXT:    vmovaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps (%rsi), %xmm6
; AVX2-NEXT:    vmovaps 32(%rsi), %xmm11
; AVX2-NEXT:    vmovaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm2 = xmm6[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0,1],xmm7[2],xmm2[3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1,2],ymm2[3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%rax), %xmm0
; AVX2-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm5[1,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],xmm4[1],xmm1[2,3]
; AVX2-NEXT:    vbroadcastsd %xmm1, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5],ymm1[6,7]
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm11[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm8[2],xmm1[3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-NEXT:    vmovaps 32(%rdx), %xmm8
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm8[1],xmm3[1],zero
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%r8), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 64(%r9), %xmm0
; AVX2-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX2-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-NEXT:    vmovaps 64(%rax), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovaps 64(%rdi), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 64(%rsi), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm2[2],xmm1[3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-NEXT:    vmovaps 64(%rcx), %xmm3
; AVX2-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 64(%rdx), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm2[1],xmm3[1],zero
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 96(%r8), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 96(%r9), %xmm0
; AVX2-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX2-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-NEXT:    vmovaps 96(%rax), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovaps 96(%rdi), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 96(%rsi), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm2[2],xmm1[3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-NEXT:    vmovaps 96(%rcx), %xmm3
; AVX2-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 96(%rdx), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm2[1],xmm3[1],zero
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 128(%r8), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 128(%r9), %xmm0
; AVX2-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX2-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-NEXT:    vmovaps 128(%rax), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovaps 128(%rdi), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 128(%rsi), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm2[2],xmm1[3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-NEXT:    vmovaps 128(%rcx), %xmm3
; AVX2-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 128(%rdx), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm2[1],xmm3[1],zero
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 160(%r8), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 160(%r9), %xmm0
; AVX2-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX2-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-NEXT:    vmovaps 160(%rax), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovaps 160(%rdi), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 160(%rsi), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm2[2],xmm1[3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-NEXT:    vmovaps 160(%rcx), %xmm3
; AVX2-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 160(%rdx), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm2[1],xmm3[1],zero
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 192(%r9), %xmm0
; AVX2-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 192(%r8), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX2-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-NEXT:    vmovaps 192(%rax), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovaps 192(%rdi), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 192(%rsi), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm2[2],xmm1[3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-NEXT:    vmovaps 192(%rcx), %xmm3
; AVX2-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 192(%rdx), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm2[1],xmm3[1],zero
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%rcx), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm2[2],ymm1[2],ymm2[3],ymm1[3],ymm2[6],ymm1[6],ymm2[7],ymm1[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vmovaps (%r8), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%r9), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-NEXT:    vmovaps 16(%rax), %xmm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%rsi), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovaps 32(%rdx), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%rcx), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vmovaps 32(%r8), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%r9), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-NEXT:    vmovaps 48(%rax), %xmm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%rdi), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%rsi), %ymm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovaps 64(%rdx), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%rcx), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vmovaps 64(%r8), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%r9), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-NEXT:    vmovaps 80(%rax), %xmm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 96(%rdi), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 96(%rsi), %ymm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovaps 96(%rdx), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 96(%rcx), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vmovaps 96(%r8), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 96(%r9), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-NEXT:    vmovaps 112(%rax), %xmm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 128(%rdi), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 128(%rsi), %ymm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovaps 128(%rdx), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 128(%rcx), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vmovaps 128(%r8), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 128(%r9), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-NEXT:    vmovaps 144(%rax), %xmm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 160(%rdi), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 160(%rsi), %ymm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovaps 160(%rdx), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 160(%rcx), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vmovaps 160(%r8), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 160(%r9), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-NEXT:    vmovaps 176(%rax), %xmm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 192(%rdi), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 192(%rsi), %ymm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovaps 192(%rdx), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 192(%rcx), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vmovaps 192(%r8), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 192(%r9), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-NEXT:    vmovaps 208(%rax), %xmm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 224(%rcx), %xmm0
; AVX2-NEXT:    vbroadcastss %xmm0, %xmm2
; AVX2-NEXT:    vmovaps 224(%rdx), %xmm1
; AVX2-NEXT:    vbroadcastss %xmm1, %xmm3
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX2-NEXT:    vmovaps 224(%rsi), %xmm4
; AVX2-NEXT:    vmovaps 224(%rdi), %xmm5
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3],ymm3[4,5,6,7]
; AVX2-NEXT:    vbroadcastsd 224(%r8), %ymm3
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4,5],ymm2[6,7]
; AVX2-NEXT:    vmovaps 224(%r9), %xmm3
; AVX2-NEXT:    vbroadcastss %xmm3, %ymm15
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4],ymm15[5],ymm2[6,7]
; AVX2-NEXT:    vbroadcastss 224(%rax), %ymm15
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm15[6],ymm2[7]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm2 = xmm4[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0,1],xmm5[2],xmm2[3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm15 = zero,xmm1[1],xmm0[1],zero
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm15[1,2],ymm2[3,4,5,6,7]
; AVX2-NEXT:    vbroadcastss 228(%r8), %ymm14
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2],ymm14[3],ymm2[4,5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} xmm14 = xmm3[1,1,1,1]
; AVX2-NEXT:    vinsertf128 $1, %xmm14, %ymm0, %ymm14
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm14[4,5],ymm2[6,7]
; AVX2-NEXT:    vinsertf128 $1, 224(%rax), %ymm15, %ymm14
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm14[1],ymm2[2,3,4],ymm14[5],ymm2[6,7]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm2 = xmm5[3,3],xmm4[3,3]
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm1
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX2-NEXT:    vmovaps 224(%r8), %ymm5
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm5[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm3[2,2,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3],ymm0[4,5,6,7]
; AVX2-NEXT:    vbroadcastss 232(%rax), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4],ymm0[5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 224(%rdi), %ymm11
; AVX2-NEXT:    vmovaps 224(%rsi), %ymm4
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm4[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm11[1],ymm0[2,3,4],ymm11[5],ymm0[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm14 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovaps 224(%rdx), %ymm12
; AVX2-NEXT:    vmovaps 224(%rcx), %ymm2
; AVX2-NEXT:    vshufps {{.*#+}} ymm15 = ymm12[1,1],ymm2[1,1],ymm12[5,5],ymm2[5,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4],ymm15[5,6],ymm14[7]
; AVX2-NEXT:    vbroadcastsd 240(%r8), %ymm15
; AVX2-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0],ymm14[1,2,3,4,5,6],ymm15[7]
; AVX2-NEXT:    vbroadcastss 240(%r9), %xmm15
; AVX2-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0],ymm15[1],ymm14[2,3,4,5,6,7]
; AVX2-NEXT:    vbroadcastss 240(%rax), %ymm15
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm14[0,1],ymm15[2],ymm14[3,4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vbroadcastss %xmm10, %xmm14
; AVX2-NEXT:    vbroadcastss %xmm9, %xmm15
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm14 = xmm15[0],xmm14[0],xmm15[1],xmm14[1]
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm15 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm15 = xmm15[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0,1],ymm14[2,3],ymm15[4,5,6,7]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-NEXT:    vmovaps %xmm13, %xmm1
; AVX2-NEXT:    vmovaps %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm15 = xmm13[0],xmm0[0],xmm13[1],xmm0[1]
; AVX2-NEXT:    vinsertf128 $1, %xmm15, %ymm0, %ymm15
; AVX2-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm13 = ymm15[0],ymm13[0],ymm15[2],ymm13[2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm13 = ymm14[0,1,2,3],ymm13[4,5,6],ymm14[7]
; AVX2-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm6 = xmm7[3,3],xmm6[3,3]
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm7 = xmm9[2],xmm10[2],xmm9[3],xmm10[3]
; AVX2-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX2-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3,4],ymm6[5,6],ymm7[7]
; AVX2-NEXT:    vshufps {{.*#+}} xmm7 = xmm0[2,2,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm7 = xmm1[0,1,2],xmm7[3]
; AVX2-NEXT:    vbroadcastsd 8(%rax), %ymm9
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm9[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1],ymm7[2,3,4],ymm6[5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-NEXT:    vbroadcastss %xmm1, %xmm6
; AVX2-NEXT:    vbroadcastss %xmm8, %xmm7
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm14[0],xmm15[0],xmm14[1],xmm15[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,3],ymm7[4,5,6,7]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm10[0],xmm13[0],xmm10[1],xmm13[1]
; AVX2-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm7 = ymm7[0],ymm9[0],ymm7[2],ymm9[2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1,2,3],ymm7[4,5,6],ymm6[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm6 = xmm14[3,3],xmm15[3,3]
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm7 = xmm8[2],xmm1[2],xmm8[3],xmm1[3]
; AVX2-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX2-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3,4],ymm6[5,6],ymm7[7]
; AVX2-NEXT:    vshufps {{.*#+}} xmm7 = xmm13[2,2,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm7 = xmm10[0,1,2],xmm7[3]
; AVX2-NEXT:    vbroadcastsd 40(%rax), %ymm8
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm8[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1],ymm7[2,3,4],ymm6[5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX2-NEXT:    vbroadcastss %xmm15, %xmm6
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-NEXT:    vbroadcastss %xmm10, %xmm7
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm9[0],xmm1[0],xmm9[1],xmm1[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,3],ymm7[4,5,6,7]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm14[0],xmm13[0],xmm14[1],xmm13[1]
; AVX2-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm7 = ymm7[0],ymm8[0],ymm7[2],ymm8[2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1,2,3],ymm7[4,5,6],ymm6[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm6 = xmm9[3,3],xmm1[3,3]
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm7 = xmm10[2],xmm15[2],xmm10[3],xmm15[3]
; AVX2-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX2-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3,4],ymm6[5,6],ymm7[7]
; AVX2-NEXT:    vshufps {{.*#+}} xmm7 = xmm13[2,2,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm7 = xmm14[0,1,2],xmm7[3]
; AVX2-NEXT:    vbroadcastsd 72(%rax), %ymm8
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm8[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1],ymm7[2,3,4],ymm6[5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX2-NEXT:    vbroadcastss %xmm15, %xmm6
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-NEXT:    vbroadcastss %xmm14, %xmm7
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm10[0],xmm9[0],xmm10[1],xmm9[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,3],ymm7[4,5,6,7]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm0[0],xmm13[0],xmm0[1],xmm13[1]
; AVX2-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm7 = ymm7[0],ymm8[0],ymm7[2],ymm8[2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm6[0,1,2,3],ymm7[4,5,6],ymm6[7]
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm6 = xmm10[3,3],xmm9[3,3]
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm7 = xmm14[2],xmm15[2],xmm14[3],xmm15[3]
; AVX2-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX2-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3,4],ymm6[5,6],ymm7[7]
; AVX2-NEXT:    vshufps {{.*#+}} xmm7 = xmm13[2,2,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm7 = xmm0[0,1,2],xmm7[3]
; AVX2-NEXT:    vbroadcastsd 104(%rax), %ymm8
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm8[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1],ymm7[2,3,4],ymm6[5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX2-NEXT:    vbroadcastss %xmm15, %xmm6
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-NEXT:    vbroadcastss %xmm14, %xmm7
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm10[0],xmm9[0],xmm10[1],xmm9[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,3],ymm7[4,5,6,7]
; AVX2-NEXT:    vmovaps (%rsp), %xmm13 # 16-byte Reload
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm0[0],xmm13[0],xmm0[1],xmm13[1]
; AVX2-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm7 = ymm7[0],ymm8[0],ymm7[2],ymm8[2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm6[0,1,2,3],ymm7[4,5,6],ymm6[7]
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm6 = xmm10[3,3],xmm9[3,3]
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm7 = xmm14[2],xmm15[2],xmm14[3],xmm15[3]
; AVX2-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX2-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3,4],ymm6[5,6],ymm7[7]
; AVX2-NEXT:    vshufps {{.*#+}} xmm7 = xmm13[2,2,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm7 = xmm0[0,1,2],xmm7[3]
; AVX2-NEXT:    vbroadcastsd 136(%rax), %ymm8
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm8[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1],ymm7[2,3,4],ymm6[5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-NEXT:    vbroadcastss %xmm14, %xmm6
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-NEXT:    vbroadcastss %xmm10, %xmm7
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm9[0],xmm1[0],xmm9[1],xmm1[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,3],ymm7[4,5,6,7]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm0[0],xmm13[0],xmm0[1],xmm13[1]
; AVX2-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm7 = ymm7[0],ymm8[0],ymm7[2],ymm8[2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6],ymm6[7]
; AVX2-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm6 = xmm9[3,3],xmm1[3,3]
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm7 = xmm10[2],xmm14[2],xmm10[3],xmm14[3]
; AVX2-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX2-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3,4],ymm6[5,6],ymm7[7]
; AVX2-NEXT:    vshufps {{.*#+}} xmm7 = xmm13[2,2,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm7 = xmm0[0,1,2],xmm7[3]
; AVX2-NEXT:    vbroadcastsd 168(%rax), %ymm8
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm8[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1],ymm7[2,3,4],ymm6[5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-NEXT:    vbroadcastss %xmm14, %xmm6
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX2-NEXT:    vbroadcastss %xmm13, %xmm7
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm10[0],xmm9[0],xmm10[1],xmm9[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,3],ymm7[4,5,6,7]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm7 = ymm7[0],ymm8[0],ymm7[2],ymm8[2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6],ymm6[7]
; AVX2-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm6 = xmm10[3,3],xmm9[3,3]
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm7 = xmm13[2],xmm14[2],xmm13[3],xmm14[3]
; AVX2-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX2-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3,4],ymm6[5,6],ymm7[7]
; AVX2-NEXT:    vshufps {{.*#+}} xmm7 = xmm0[2,2,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm7 = xmm1[0,1,2],xmm7[3]
; AVX2-NEXT:    vbroadcastsd 200(%rax), %ymm8
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm8[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1],ymm7[2,3,4],ymm6[5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm6 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm6 = ymm10[2],mem[2],ymm10[3],mem[3],ymm10[6],mem[6],ymm10[7],mem[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[3,3,3,3]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm8[2],ymm9[2],ymm8[3],ymm9[3],ymm8[6],ymm9[6],ymm8[7],ymm9[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[3,3,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2],ymm6[3,4,5,6,7]
; AVX2-NEXT:    vbroadcastss 220(%r8), %ymm7
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4],ymm7[5],ymm6[6,7]
; AVX2-NEXT:    vbroadcastss 220(%r9), %ymm7
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],ymm7[6,7]
; AVX2-NEXT:    vbroadcastsd 216(%rax), %ymm7
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm7[0],ymm6[1,2,3,4,5,6],ymm7[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vbroadcastss 240(%rdx), %ymm6
; AVX2-NEXT:    vshufps {{.*#+}} ymm7 = ymm2[3,1,2,0,7,5,6,4]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3,4,5],ymm6[6],ymm7[7]
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm11[0],ymm4[0],ymm11[1],ymm4[1],ymm11[4],ymm4[4],ymm11[5],ymm4[5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5],ymm6[6,7]
; AVX2-NEXT:    vbroadcastss 236(%r8), %ymm7
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2,3,4,5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm6[0,1],ymm3[2,3],ymm6[4,5,6,7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm6 = ymm11[2],ymm4[2],ymm11[3],ymm4[3],ymm11[6],ymm4[6],ymm11[7],ymm4[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[2,2,2,2]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm12[2],ymm2[2],ymm12[3],ymm2[3],ymm12[6],ymm2[6],ymm12[7],ymm2[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0,1,2,3,4,5],ymm5[6,7]
; AVX2-NEXT:    vpermilps {{.*#+}} ymm6 = mem[1,2,2,3,5,6,6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[2,2,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0],ymm5[1,2,3,4,5,6],ymm6[7]
; AVX2-NEXT:    vmovaps 224(%rax), %ymm6
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1,2],ymm6[3],ymm3[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm6[2,3],ymm7[2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0],ymm3[1],ymm5[2,3,4],ymm3[5],ymm5[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm2[2],ymm12[2],ymm2[3],ymm12[3],ymm2[6],ymm12[6],ymm2[7],ymm12[7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm4[2],ymm11[2],ymm4[3],ymm11[3],ymm4[6],ymm11[6],ymm4[7],ymm11[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX2-NEXT:    vbroadcastss 252(%r8), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vbroadcastss 252(%r9), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vbroadcastsd 248(%rax), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4,5,6],ymm1[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm7[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm5[1],ymm0[2,3,4],ymm5[5],ymm0[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm12[1,1],ymm6[1,1],ymm12[5,5],ymm6[5,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm14[0,0,0,0,4,4,4,4]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX2-NEXT:    vshufps {{.*#+}} ymm2 = ymm13[0,1,0,1,4,5,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3,4],ymm1[5],ymm2[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-NEXT:    vbroadcastsd 16(%rax), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Reload
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm15[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm4[1],ymm0[2,3,4],ymm4[5],ymm0[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1],ymm11[1,1],ymm1[5,5],ymm11[5,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX2-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm1 = mem[0,0,0,0,4,4,4,4]
; AVX2-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm2 = mem[0,1,0,1,4,5,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3,4],ymm1[5],ymm2[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-NEXT:    vbroadcastsd 48(%rax), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermilps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vblendps $34, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = ymm0[0],mem[1],ymm0[2,3,4],mem[5],ymm0[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vshufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm1 = ymm1[1,1],mem[1,1],ymm1[5,5],mem[5,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX2-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm1 = mem[0,0,0,0,4,4,4,4]
; AVX2-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm2 = mem[0,1,0,1,4,5,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3,4],ymm1[5],ymm2[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-NEXT:    vbroadcastsd 80(%rax), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermilps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm3[1],ymm0[2,3,4],ymm3[5],ymm0[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vshufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm1 = ymm1[1,1],mem[1,1],ymm1[5,5],mem[5,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX2-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm1 = mem[0,0,0,0,4,4,4,4]
; AVX2-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm2 = mem[0,1,0,1,4,5,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3,4],ymm1[5],ymm2[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-NEXT:    vbroadcastsd 112(%rax), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermilps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vblendps $34, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = ymm0[0],mem[1],ymm0[2,3,4],mem[5],ymm0[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vshufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm1 = ymm1[1,1],mem[1,1],ymm1[5,5],mem[5,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX2-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm1 = mem[0,0,0,0,4,4,4,4]
; AVX2-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm2 = mem[0,1,0,1,4,5,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3,4],ymm1[5],ymm2[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-NEXT:    vbroadcastsd 144(%rax), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermilps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vblendps $34, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = ymm0[0],mem[1],ymm0[2,3,4],mem[5],ymm0[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vshufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm1 = ymm1[1,1],mem[1,1],ymm1[5,5],mem[5,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX2-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm1 = mem[0,0,0,0,4,4,4,4]
; AVX2-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm2 = mem[0,1,0,1,4,5,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3,4],ymm1[5],ymm2[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-NEXT:    vbroadcastsd 176(%rax), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,1],ymm10[1,1],ymm0[5,5],ymm10[5,5]
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm8[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm9[1],ymm1[2,3,4],ymm9[5],ymm1[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5,6],ymm1[7]
; AVX2-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm1 = mem[0,0,0,0,4,4,4,4]
; AVX2-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm2 = mem[0,1,0,1,4,5,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3,4],ymm1[5],ymm2[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-NEXT:    vbroadcastsd 208(%rax), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm9 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX2-NEXT:    vbroadcastss 16(%rdx), %ymm0
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm6[3,1,2,0,7,5,6,4]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6],ymm1[7]
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm5[0],ymm7[0],ymm5[1],ymm7[1],ymm5[4],ymm7[4],ymm5[5],ymm7[5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm1 = xmm1[3,3],mem[3,3]
; AVX2-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm1 = xmm1[0,1,2],mem[3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm10 = ymm0[0],ymm1[1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm6[2],ymm12[2],ymm6[3],ymm12[3],ymm6[6],ymm12[6],ymm6[7],ymm12[7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm7[2],ymm5[2],ymm7[3],ymm5[3],ymm7[6],ymm5[6],ymm7[7],ymm5[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm13[3,3],ymm14[3,3],ymm13[7,7],ymm14[7,7]
; AVX2-NEXT:    vpermilps {{.*#+}} ymm2 = mem[2,3,2,3,6,7,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1,2],ymm2[3,4],ymm1[5,6],ymm2[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm12 = ymm1[0],ymm0[1,2,3,4],ymm1[5,6,7]
; AVX2-NEXT:    vbroadcastss 48(%rdx), %ymm0
; AVX2-NEXT:    vmovaps %ymm11, %ymm6
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm11[3,1,2,0,7,5,6,4]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6],ymm1[7]
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm4[0],ymm15[0],ymm4[1],ymm15[1],ymm4[4],ymm15[4],ymm4[5],ymm15[5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm1 = xmm1[3,3],mem[3,3]
; AVX2-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm1 = xmm1[0,1,2],mem[3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm11 = ymm0[0],ymm1[1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm6, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = ymm6[2],mem[2],ymm6[3],mem[3],ymm6[6],mem[6],ymm6[7],mem[7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm15[2],ymm4[2],ymm15[3],ymm4[3],ymm15[6],ymm4[6],ymm15[7],ymm4[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm1 = ymm1[3,3],mem[3,3],ymm1[7,7],mem[7,7]
; AVX2-NEXT:    vpermilps {{.*#+}} ymm2 = mem[2,3,2,3,6,7,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1,2],ymm2[3,4],ymm1[5,6],ymm2[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vbroadcastss 80(%rdx), %ymm0
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm6[3,1,2,0,7,5,6,4]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6],ymm1[7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm4[0],ymm2[0],ymm4[1],ymm2[1],ymm4[4],ymm2[4],ymm4[5],ymm2[5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm1 = xmm1[3,3],mem[3,3]
; AVX2-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm1 = xmm1[0,1,2],mem[3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm6, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = ymm6[2],mem[2],ymm6[3],mem[3],ymm6[6],mem[6],ymm6[7],mem[7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm2[2],ymm4[2],ymm2[3],ymm4[3],ymm2[6],ymm4[6],ymm2[7],ymm4[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm1 = ymm1[3,3],mem[3,3],ymm1[7,7],mem[7,7]
; AVX2-NEXT:    vpermilps {{.*#+}} ymm2 = mem[2,3,2,3,6,7,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1,2],ymm2[3,4],ymm1[5,6],ymm2[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm1[0],ymm0[1,2,3,4],ymm1[5,6,7]
; AVX2-NEXT:    vbroadcastss 112(%rdx), %ymm0
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm4[3,1,2,0,7,5,6,4]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6],ymm1[7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm3[0],ymm2[0],ymm3[1],ymm2[1],ymm3[4],ymm2[4],ymm3[5],ymm2[5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm1 = xmm1[3,3],mem[3,3]
; AVX2-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm1 = xmm1[0,1,2],mem[3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm0[0],ymm1[1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = ymm4[2],mem[2],ymm4[3],mem[3],ymm4[6],mem[6],ymm4[7],mem[7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm2[2],ymm3[2],ymm2[3],ymm3[3],ymm2[6],ymm3[6],ymm2[7],ymm3[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm1 = ymm1[3,3],mem[3,3],ymm1[7,7],mem[7,7]
; AVX2-NEXT:    vpermilps {{.*#+}} ymm2 = mem[2,3,2,3,6,7,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1,2],ymm2[3,4],ymm1[5,6],ymm2[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm1[0],ymm0[1,2,3,4],ymm1[5,6,7]
; AVX2-NEXT:    vbroadcastss 144(%rdx), %ymm0
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm3[3,1,2,0,7,5,6,4]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6],ymm1[7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Reload
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm15[0],ymm2[0],ymm15[1],ymm2[1],ymm15[4],ymm2[4],ymm15[5],ymm2[5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-NEXT:    vshufps $255, (%rsp), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm1 = xmm1[3,3],mem[3,3]
; AVX2-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm1 = xmm1[0,1,2],mem[3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm0[0],ymm1[1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm1 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm1 = ymm3[2],mem[2],ymm3[3],mem[3],ymm3[6],mem[6],ymm3[7],mem[7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm2[2],ymm15[2],ymm2[3],ymm15[3],ymm2[6],ymm15[6],ymm2[7],ymm15[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4,5,6,7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm1 = ymm1[3,3],mem[3,3],ymm1[7,7],mem[7,7]
; AVX2-NEXT:    vpermilps {{.*#+}} ymm15 = mem[2,3,2,3,6,7,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm15[0],ymm1[1,2],ymm15[3,4],ymm1[5,6],ymm15[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm1[0],ymm0[1,2,3,4],ymm1[5,6,7]
; AVX2-NEXT:    vbroadcastss 176(%rdx), %ymm0
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vshufps {{.*#+}} ymm15 = ymm1[3,1,2,0,7,5,6,4]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm15[0,1,2,3,4,5],ymm0[6],ymm15[7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm15 = ymm14[0],ymm0[0],ymm14[1],ymm0[1],ymm14[4],ymm0[4],ymm14[5],ymm0[5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm15[4,5],ymm2[6,7]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX2-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm15 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm15 = xmm7[3,3],mem[3,3]
; AVX2-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm15 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm15 = xmm15[0,1,2],mem[3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm15[1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm15 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm15 = ymm1[2],mem[2],ymm1[3],mem[3],ymm1[6],mem[6],ymm1[7],mem[7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm14[2],ymm0[3],ymm14[3],ymm0[6],ymm14[6],ymm0[7],ymm14[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[3,3,3,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm15[3,4,5,6,7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm15 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm15 = ymm1[3,3],mem[3,3],ymm1[7,7],mem[7,7]
; AVX2-NEXT:    vpermilps {{.*#+}} ymm14 = mem[2,3,2,3,6,7,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0],ymm15[1,2],ymm14[3,4],ymm15[5,6],ymm14[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm14 = ymm14[2,1,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm14[0],ymm0[1,2,3,4],ymm14[5,6,7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm14 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm14 = ymm1[0],mem[0],ymm1[1],mem[1],ymm1[4],mem[4],ymm1[5],mem[5]
; AVX2-NEXT:    vpermilps $39, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm15 = mem[3,1,2,0,7,5,6,4]
; AVX2-NEXT:    vbroadcastss 208(%rdx), %ymm13
; AVX2-NEXT:    vblendps {{.*#+}} ymm13 = ymm15[0,1,2,3,4,5],ymm13[6],ymm15[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1,2,3],ymm14[4,5],ymm13[6,7]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm14 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm14 = xmm1[3,3],mem[3,3]
; AVX2-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm14 = xmm14[0,1,2],mem[3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0],ymm14[1,2,3],ymm13[4,5,6,7]
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    vmovaps %ymm13, 1440(%rax)
; AVX2-NEXT:    vmovaps %ymm0, 1312(%rax)
; AVX2-NEXT:    vmovaps %ymm2, 1216(%rax)
; AVX2-NEXT:    vmovaps %ymm3, 1088(%rax)
; AVX2-NEXT:    vmovaps %ymm4, 992(%rax)
; AVX2-NEXT:    vmovaps %ymm5, 864(%rax)
; AVX2-NEXT:    vmovaps %ymm6, 768(%rax)
; AVX2-NEXT:    vmovaps %ymm8, 640(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 544(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-NEXT:    vmovaps %ymm11, 320(%rax)
; AVX2-NEXT:    vmovaps %ymm12, 192(%rax)
; AVX2-NEXT:    vmovaps %ymm10, 96(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1504(%rax)
; AVX2-NEXT:    vmovaps %ymm9, 1472(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1280(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1248(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1056(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1024(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 832(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 800(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1760(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1728(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1664(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1536(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1408(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1376(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1344(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1184(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1152(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1120(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 960(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 928(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 896(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 736(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1696(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1632(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1600(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1568(%rax)
; AVX2-NEXT:    addq $2968, %rsp # imm = 0xB98
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i32_stride7_vf64:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    subq $2968, %rsp # imm = 0xB98
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FP-NEXT:    vmovaps (%rax), %xmm0
; AVX2-FP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovaps (%r8), %xmm13
; AVX2-FP-NEXT:    vmovaps 32(%r8), %xmm4
; AVX2-FP-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps (%r9), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%r9), %xmm5
; AVX2-FP-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],xmm13[1],xmm1[2,3]
; AVX2-FP-NEXT:    vbroadcastsd %xmm1, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovaps (%rcx), %xmm10
; AVX2-FP-NEXT:    vmovaps 32(%rcx), %xmm3
; AVX2-FP-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rdx), %xmm9
; AVX2-FP-NEXT:    vinsertps {{.*#+}} xmm1 = zero,xmm9[1],xmm10[1],zero
; AVX2-FP-NEXT:    vmovaps (%rdi), %xmm7
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %xmm8
; AVX2-FP-NEXT:    vmovaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rsi), %xmm6
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %xmm11
; AVX2-FP-NEXT:    vmovaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm2 = xmm6[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0,1],xmm7[2],xmm2[3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1,2],ymm2[3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rax), %xmm0
; AVX2-FP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm1 = xmm5[1,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],xmm4[1],xmm1[2,3]
; AVX2-FP-NEXT:    vbroadcastsd %xmm1, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5],ymm1[6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm1 = xmm11[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm8[2],xmm1[3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FP-NEXT:    vmovaps 32(%rdx), %xmm8
; AVX2-FP-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm8[1],xmm3[1],zero
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%r8), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%r9), %xmm0
; AVX2-FP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-FP-NEXT:    vmovaps 64(%rax), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovaps 64(%rdi), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rsi), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm2[2],xmm1[3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FP-NEXT:    vmovaps 64(%rcx), %xmm3
; AVX2-FP-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rdx), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm2[1],xmm3[1],zero
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%r8), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%r9), %xmm0
; AVX2-FP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-FP-NEXT:    vmovaps 96(%rax), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%rsi), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm2[2],xmm1[3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FP-NEXT:    vmovaps 96(%rcx), %xmm3
; AVX2-FP-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%rdx), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm2[1],xmm3[1],zero
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 128(%r8), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 128(%r9), %xmm0
; AVX2-FP-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-FP-NEXT:    vmovaps 128(%rax), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovaps 128(%rdi), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 128(%rsi), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm2[2],xmm1[3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FP-NEXT:    vmovaps 128(%rcx), %xmm3
; AVX2-FP-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 128(%rdx), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm2[1],xmm3[1],zero
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 160(%r8), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 160(%r9), %xmm0
; AVX2-FP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-FP-NEXT:    vmovaps 160(%rax), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovaps 160(%rdi), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 160(%rsi), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm2[2],xmm1[3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FP-NEXT:    vmovaps 160(%rcx), %xmm3
; AVX2-FP-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 160(%rdx), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm2[1],xmm3[1],zero
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 192(%r9), %xmm0
; AVX2-FP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 192(%r8), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-FP-NEXT:    vmovaps 192(%rax), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovaps 192(%rdi), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 192(%rsi), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm2[2],xmm1[3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FP-NEXT:    vmovaps 192(%rcx), %xmm3
; AVX2-FP-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 192(%rdx), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm2[1],xmm3[1],zero
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rcx), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm2[2],ymm1[2],ymm2[3],ymm1[3],ymm2[6],ymm1[6],ymm2[7],ymm1[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps (%r8), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%r9), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FP-NEXT:    vmovaps 16(%rax), %xmm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps 32(%rdx), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rcx), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps 32(%r8), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%r9), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FP-NEXT:    vmovaps 48(%rax), %xmm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rsi), %ymm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps 64(%rdx), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rcx), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps 64(%r8), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%r9), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FP-NEXT:    vmovaps 80(%rax), %xmm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%rsi), %ymm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps 96(%rdx), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%rcx), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps 96(%r8), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%r9), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FP-NEXT:    vmovaps 112(%rax), %xmm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 128(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 128(%rsi), %ymm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps 128(%rdx), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 128(%rcx), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps 128(%r8), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 128(%r9), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FP-NEXT:    vmovaps 144(%rax), %xmm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 160(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 160(%rsi), %ymm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps 160(%rdx), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 160(%rcx), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps 160(%r8), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 160(%r9), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FP-NEXT:    vmovaps 176(%rax), %xmm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 192(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 192(%rsi), %ymm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps 192(%rdx), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 192(%rcx), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps 192(%r8), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 192(%r9), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FP-NEXT:    vmovaps 208(%rax), %xmm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 224(%rcx), %xmm0
; AVX2-FP-NEXT:    vbroadcastss %xmm0, %xmm2
; AVX2-FP-NEXT:    vmovaps 224(%rdx), %xmm1
; AVX2-FP-NEXT:    vbroadcastss %xmm1, %xmm3
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX2-FP-NEXT:    vmovaps 224(%rsi), %xmm4
; AVX2-FP-NEXT:    vmovaps 224(%rdi), %xmm5
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3],ymm3[4,5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 224(%r8), %ymm3
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4,5],ymm2[6,7]
; AVX2-FP-NEXT:    vmovaps 224(%r9), %xmm3
; AVX2-FP-NEXT:    vbroadcastss %xmm3, %ymm15
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4],ymm15[5],ymm2[6,7]
; AVX2-FP-NEXT:    vbroadcastss 224(%rax), %ymm15
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm15[6],ymm2[7]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm2 = xmm4[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0,1],xmm5[2],xmm2[3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-FP-NEXT:    vinsertps {{.*#+}} xmm15 = zero,xmm1[1],xmm0[1],zero
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm15[1,2],ymm2[3,4,5,6,7]
; AVX2-FP-NEXT:    vbroadcastss 228(%r8), %ymm14
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2],ymm14[3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm14 = xmm3[1,1,1,1]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm14, %ymm0, %ymm14
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm14[4,5],ymm2[6,7]
; AVX2-FP-NEXT:    vinsertf128 $1, 224(%rax), %ymm15, %ymm14
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm14[1],ymm2[2,3,4],ymm14[5],ymm2[6,7]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm2 = xmm5[3,3],xmm4[3,3]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm1
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX2-FP-NEXT:    vmovaps 224(%r8), %ymm5
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm5[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm1 = xmm3[2,2,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vbroadcastss 232(%rax), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4],ymm0[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 224(%rdi), %ymm11
; AVX2-FP-NEXT:    vmovaps 224(%rsi), %ymm4
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm4[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm11[1],ymm0[2,3,4],ymm11[5],ymm0[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm14 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps 224(%rdx), %ymm12
; AVX2-FP-NEXT:    vmovaps 224(%rcx), %ymm2
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm15 = ymm12[1,1],ymm2[1,1],ymm12[5,5],ymm2[5,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4],ymm15[5,6],ymm14[7]
; AVX2-FP-NEXT:    vbroadcastsd 240(%r8), %ymm15
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0],ymm14[1,2,3,4,5,6],ymm15[7]
; AVX2-FP-NEXT:    vbroadcastss 240(%r9), %xmm15
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0],ymm15[1],ymm14[2,3,4,5,6,7]
; AVX2-FP-NEXT:    vbroadcastss 240(%rax), %ymm15
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm14[0,1],ymm15[2],ymm14[3,4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vbroadcastss %xmm10, %xmm14
; AVX2-FP-NEXT:    vbroadcastss %xmm9, %xmm15
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm14 = xmm15[0],xmm14[0],xmm15[1],xmm14[1]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm15 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm15 = xmm15[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0,1],ymm14[2,3],ymm15[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FP-NEXT:    vmovaps %xmm13, %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm15 = xmm13[0],xmm0[0],xmm13[1],xmm0[1]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm15, %ymm0, %ymm15
; AVX2-FP-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm13 = ymm15[0],ymm13[0],ymm15[2],ymm13[2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm13 = ymm14[0,1,2,3],ymm13[4,5,6],ymm14[7]
; AVX2-FP-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm6 = xmm7[3,3],xmm6[3,3]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm7 = xmm9[2],xmm10[2],xmm9[3],xmm10[3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3,4],ymm6[5,6],ymm7[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm7 = xmm0[2,2,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm7 = xmm1[0,1,2],xmm7[3]
; AVX2-FP-NEXT:    vbroadcastsd 8(%rax), %ymm9
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm9[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1],ymm7[2,3,4],ymm6[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FP-NEXT:    vbroadcastss %xmm1, %xmm6
; AVX2-FP-NEXT:    vbroadcastss %xmm8, %xmm7
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm14[0],xmm15[0],xmm14[1],xmm15[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,3],ymm7[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm10[0],xmm13[0],xmm10[1],xmm13[1]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-FP-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm7 = ymm7[0],ymm9[0],ymm7[2],ymm9[2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1,2,3],ymm7[4,5,6],ymm6[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm6 = xmm14[3,3],xmm15[3,3]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm7 = xmm8[2],xmm1[2],xmm8[3],xmm1[3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3,4],ymm6[5,6],ymm7[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm7 = xmm13[2,2,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm7 = xmm10[0,1,2],xmm7[3]
; AVX2-FP-NEXT:    vbroadcastsd 40(%rax), %ymm8
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm8[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1],ymm7[2,3,4],ymm6[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX2-FP-NEXT:    vbroadcastss %xmm15, %xmm6
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-FP-NEXT:    vbroadcastss %xmm10, %xmm7
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm9[0],xmm1[0],xmm9[1],xmm1[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,3],ymm7[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm14[0],xmm13[0],xmm14[1],xmm13[1]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-FP-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm7 = ymm7[0],ymm8[0],ymm7[2],ymm8[2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1,2,3],ymm7[4,5,6],ymm6[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm6 = xmm9[3,3],xmm1[3,3]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm7 = xmm10[2],xmm15[2],xmm10[3],xmm15[3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3,4],ymm6[5,6],ymm7[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm7 = xmm13[2,2,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm7 = xmm14[0,1,2],xmm7[3]
; AVX2-FP-NEXT:    vbroadcastsd 72(%rax), %ymm8
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm8[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1],ymm7[2,3,4],ymm6[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX2-FP-NEXT:    vbroadcastss %xmm15, %xmm6
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-FP-NEXT:    vbroadcastss %xmm14, %xmm7
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm10[0],xmm9[0],xmm10[1],xmm9[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,3],ymm7[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm0[0],xmm13[0],xmm0[1],xmm13[1]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-FP-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm7 = ymm7[0],ymm8[0],ymm7[2],ymm8[2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm6[0,1,2,3],ymm7[4,5,6],ymm6[7]
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm6 = xmm10[3,3],xmm9[3,3]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm7 = xmm14[2],xmm15[2],xmm14[3],xmm15[3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3,4],ymm6[5,6],ymm7[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm7 = xmm13[2,2,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm7 = xmm0[0,1,2],xmm7[3]
; AVX2-FP-NEXT:    vbroadcastsd 104(%rax), %ymm8
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm8[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1],ymm7[2,3,4],ymm6[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX2-FP-NEXT:    vbroadcastss %xmm15, %xmm6
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-FP-NEXT:    vbroadcastss %xmm14, %xmm7
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm10[0],xmm9[0],xmm10[1],xmm9[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,3],ymm7[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps (%rsp), %xmm13 # 16-byte Reload
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm0[0],xmm13[0],xmm0[1],xmm13[1]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-FP-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm7 = ymm7[0],ymm8[0],ymm7[2],ymm8[2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm6[0,1,2,3],ymm7[4,5,6],ymm6[7]
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm6 = xmm10[3,3],xmm9[3,3]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm7 = xmm14[2],xmm15[2],xmm14[3],xmm15[3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3,4],ymm6[5,6],ymm7[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm7 = xmm13[2,2,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm7 = xmm0[0,1,2],xmm7[3]
; AVX2-FP-NEXT:    vbroadcastsd 136(%rax), %ymm8
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm8[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1],ymm7[2,3,4],ymm6[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-FP-NEXT:    vbroadcastss %xmm14, %xmm6
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-FP-NEXT:    vbroadcastss %xmm10, %xmm7
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm9[0],xmm1[0],xmm9[1],xmm1[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,3],ymm7[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm0[0],xmm13[0],xmm0[1],xmm13[1]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-FP-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm7 = ymm7[0],ymm8[0],ymm7[2],ymm8[2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6],ymm6[7]
; AVX2-FP-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm6 = xmm9[3,3],xmm1[3,3]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm7 = xmm10[2],xmm14[2],xmm10[3],xmm14[3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3,4],ymm6[5,6],ymm7[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm7 = xmm13[2,2,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm7 = xmm0[0,1,2],xmm7[3]
; AVX2-FP-NEXT:    vbroadcastsd 168(%rax), %ymm8
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm8[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1],ymm7[2,3,4],ymm6[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-FP-NEXT:    vbroadcastss %xmm14, %xmm6
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX2-FP-NEXT:    vbroadcastss %xmm13, %xmm7
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm10[0],xmm9[0],xmm10[1],xmm9[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,3],ymm7[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-FP-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm7 = ymm7[0],ymm8[0],ymm7[2],ymm8[2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6],ymm6[7]
; AVX2-FP-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm6 = xmm10[3,3],xmm9[3,3]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm7 = xmm13[2],xmm14[2],xmm13[3],xmm14[3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3,4],ymm6[5,6],ymm7[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm7 = xmm0[2,2,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm7 = xmm1[0,1,2],xmm7[3]
; AVX2-FP-NEXT:    vbroadcastsd 200(%rax), %ymm8
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm8[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1],ymm7[2,3,4],ymm6[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FP-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm6 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm6 = ymm10[2],mem[2],ymm10[3],mem[3],ymm10[6],mem[6],ymm10[7],mem[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[3,3,3,3]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm8[2],ymm9[2],ymm8[3],ymm9[3],ymm8[6],ymm9[6],ymm8[7],ymm9[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[3,3,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2],ymm6[3,4,5,6,7]
; AVX2-FP-NEXT:    vbroadcastss 220(%r8), %ymm7
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4],ymm7[5],ymm6[6,7]
; AVX2-FP-NEXT:    vbroadcastss 220(%r9), %ymm7
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],ymm7[6,7]
; AVX2-FP-NEXT:    vbroadcastsd 216(%rax), %ymm7
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm7[0],ymm6[1,2,3,4,5,6],ymm7[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vbroadcastss 240(%rdx), %ymm6
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm7 = ymm2[3,1,2,0,7,5,6,4]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3,4,5],ymm6[6],ymm7[7]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm11[0],ymm4[0],ymm11[1],ymm4[1],ymm11[4],ymm4[4],ymm11[5],ymm4[5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5],ymm6[6,7]
; AVX2-FP-NEXT:    vbroadcastss 236(%r8), %ymm7
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2,3,4,5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm6[0,1],ymm3[2,3],ymm6[4,5,6,7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm6 = ymm11[2],ymm4[2],ymm11[3],ymm4[3],ymm11[6],ymm4[6],ymm11[7],ymm4[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[2,2,2,2]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm12[2],ymm2[2],ymm12[3],ymm2[3],ymm12[6],ymm2[6],ymm12[7],ymm2[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0,1,2,3,4,5],ymm5[6,7]
; AVX2-FP-NEXT:    vpermilps {{.*#+}} ymm6 = mem[1,2,2,3,5,6,6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[2,2,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0],ymm5[1,2,3,4,5,6],ymm6[7]
; AVX2-FP-NEXT:    vmovaps 224(%rax), %ymm6
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1,2],ymm6[3],ymm3[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm6[2,3],ymm7[2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0],ymm3[1],ymm5[2,3,4],ymm3[5],ymm5[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm2[2],ymm12[2],ymm2[3],ymm12[3],ymm2[6],ymm12[6],ymm2[7],ymm12[7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm4[2],ymm11[2],ymm4[3],ymm11[3],ymm4[6],ymm11[6],ymm4[7],ymm11[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX2-FP-NEXT:    vbroadcastss 252(%r8), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vbroadcastss 252(%r9), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vbroadcastsd 248(%rax), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4,5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm7[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm5[1],ymm0[2,3,4],ymm5[5],ymm0[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm12[1,1],ymm6[1,1],ymm12[5,5],ymm6[5,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm14[0,0,0,0,4,4,4,4]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm2 = ymm13[0,1,0,1,4,5,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3,4],ymm1[5],ymm2[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FP-NEXT:    vbroadcastsd 16(%rax), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm15[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm4[1],ymm0[2,3,4],ymm4[5],ymm0[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1],ymm11[1,1],ymm1[5,5],ymm11[5,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX2-FP-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm1 = mem[0,0,0,0,4,4,4,4]
; AVX2-FP-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm2 = mem[0,1,0,1,4,5,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3,4],ymm1[5],ymm2[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FP-NEXT:    vbroadcastsd 48(%rax), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermilps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vblendps $34, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = ymm0[0],mem[1],ymm0[2,3,4],mem[5],ymm0[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm1 = ymm1[1,1],mem[1,1],ymm1[5,5],mem[5,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX2-FP-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm1 = mem[0,0,0,0,4,4,4,4]
; AVX2-FP-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm2 = mem[0,1,0,1,4,5,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3,4],ymm1[5],ymm2[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FP-NEXT:    vbroadcastsd 80(%rax), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermilps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm3[1],ymm0[2,3,4],ymm3[5],ymm0[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm1 = ymm1[1,1],mem[1,1],ymm1[5,5],mem[5,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX2-FP-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm1 = mem[0,0,0,0,4,4,4,4]
; AVX2-FP-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm2 = mem[0,1,0,1,4,5,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3,4],ymm1[5],ymm2[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FP-NEXT:    vbroadcastsd 112(%rax), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermilps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vblendps $34, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = ymm0[0],mem[1],ymm0[2,3,4],mem[5],ymm0[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm1 = ymm1[1,1],mem[1,1],ymm1[5,5],mem[5,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX2-FP-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm1 = mem[0,0,0,0,4,4,4,4]
; AVX2-FP-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm2 = mem[0,1,0,1,4,5,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3,4],ymm1[5],ymm2[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FP-NEXT:    vbroadcastsd 144(%rax), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermilps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vblendps $34, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = ymm0[0],mem[1],ymm0[2,3,4],mem[5],ymm0[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm1 = ymm1[1,1],mem[1,1],ymm1[5,5],mem[5,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX2-FP-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm1 = mem[0,0,0,0,4,4,4,4]
; AVX2-FP-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm2 = mem[0,1,0,1,4,5,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3,4],ymm1[5],ymm2[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FP-NEXT:    vbroadcastsd 176(%rax), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,1],ymm10[1,1],ymm0[5,5],ymm10[5,5]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm8[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm9[1],ymm1[2,3,4],ymm9[5],ymm1[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5,6],ymm1[7]
; AVX2-FP-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm1 = mem[0,0,0,0,4,4,4,4]
; AVX2-FP-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm2 = mem[0,1,0,1,4,5,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3,4],ymm1[5],ymm2[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FP-NEXT:    vbroadcastsd 208(%rax), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm9 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FP-NEXT:    vbroadcastss 16(%rdx), %ymm0
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm6[3,1,2,0,7,5,6,4]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6],ymm1[7]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm5[0],ymm7[0],ymm5[1],ymm7[1],ymm5[4],ymm7[4],ymm5[5],ymm7[5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm1 = xmm1[3,3],mem[3,3]
; AVX2-FP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm1 = xmm1[0,1,2],mem[3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm10 = ymm0[0],ymm1[1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm6[2],ymm12[2],ymm6[3],ymm12[3],ymm6[6],ymm12[6],ymm6[7],ymm12[7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm7[2],ymm5[2],ymm7[3],ymm5[3],ymm7[6],ymm5[6],ymm7[7],ymm5[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm13[3,3],ymm14[3,3],ymm13[7,7],ymm14[7,7]
; AVX2-FP-NEXT:    vpermilps {{.*#+}} ymm2 = mem[2,3,2,3,6,7,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1,2],ymm2[3,4],ymm1[5,6],ymm2[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm12 = ymm1[0],ymm0[1,2,3,4],ymm1[5,6,7]
; AVX2-FP-NEXT:    vbroadcastss 48(%rdx), %ymm0
; AVX2-FP-NEXT:    vmovaps %ymm11, %ymm6
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm11[3,1,2,0,7,5,6,4]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6],ymm1[7]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm4[0],ymm15[0],ymm4[1],ymm15[1],ymm4[4],ymm15[4],ymm4[5],ymm15[5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm1 = xmm1[3,3],mem[3,3]
; AVX2-FP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm1 = xmm1[0,1,2],mem[3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm11 = ymm0[0],ymm1[1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm6, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = ymm6[2],mem[2],ymm6[3],mem[3],ymm6[6],mem[6],ymm6[7],mem[7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm15[2],ymm4[2],ymm15[3],ymm4[3],ymm15[6],ymm4[6],ymm15[7],ymm4[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm1 = ymm1[3,3],mem[3,3],ymm1[7,7],mem[7,7]
; AVX2-FP-NEXT:    vpermilps {{.*#+}} ymm2 = mem[2,3,2,3,6,7,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1,2],ymm2[3,4],ymm1[5,6],ymm2[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vbroadcastss 80(%rdx), %ymm0
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm6[3,1,2,0,7,5,6,4]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6],ymm1[7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm4[0],ymm2[0],ymm4[1],ymm2[1],ymm4[4],ymm2[4],ymm4[5],ymm2[5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm1 = xmm1[3,3],mem[3,3]
; AVX2-FP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm1 = xmm1[0,1,2],mem[3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm6, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = ymm6[2],mem[2],ymm6[3],mem[3],ymm6[6],mem[6],ymm6[7],mem[7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm2[2],ymm4[2],ymm2[3],ymm4[3],ymm2[6],ymm4[6],ymm2[7],ymm4[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm1 = ymm1[3,3],mem[3,3],ymm1[7,7],mem[7,7]
; AVX2-FP-NEXT:    vpermilps {{.*#+}} ymm2 = mem[2,3,2,3,6,7,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1,2],ymm2[3,4],ymm1[5,6],ymm2[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm1[0],ymm0[1,2,3,4],ymm1[5,6,7]
; AVX2-FP-NEXT:    vbroadcastss 112(%rdx), %ymm0
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm4[3,1,2,0,7,5,6,4]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6],ymm1[7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm3[0],ymm2[0],ymm3[1],ymm2[1],ymm3[4],ymm2[4],ymm3[5],ymm2[5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm1 = xmm1[3,3],mem[3,3]
; AVX2-FP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm1 = xmm1[0,1,2],mem[3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm0[0],ymm1[1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = ymm4[2],mem[2],ymm4[3],mem[3],ymm4[6],mem[6],ymm4[7],mem[7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm2[2],ymm3[2],ymm2[3],ymm3[3],ymm2[6],ymm3[6],ymm2[7],ymm3[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm1 = ymm1[3,3],mem[3,3],ymm1[7,7],mem[7,7]
; AVX2-FP-NEXT:    vpermilps {{.*#+}} ymm2 = mem[2,3,2,3,6,7,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1,2],ymm2[3,4],ymm1[5,6],ymm2[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm1[0],ymm0[1,2,3,4],ymm1[5,6,7]
; AVX2-FP-NEXT:    vbroadcastss 144(%rdx), %ymm0
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm3[3,1,2,0,7,5,6,4]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6],ymm1[7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Reload
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm15[0],ymm2[0],ymm15[1],ymm2[1],ymm15[4],ymm2[4],ymm15[5],ymm2[5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FP-NEXT:    vshufps $255, (%rsp), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm1 = xmm1[3,3],mem[3,3]
; AVX2-FP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm1 = xmm1[0,1,2],mem[3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm0[0],ymm1[1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm1 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm1 = ymm3[2],mem[2],ymm3[3],mem[3],ymm3[6],mem[6],ymm3[7],mem[7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm2[2],ymm15[2],ymm2[3],ymm15[3],ymm2[6],ymm15[6],ymm2[7],ymm15[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4,5,6,7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm1 = ymm1[3,3],mem[3,3],ymm1[7,7],mem[7,7]
; AVX2-FP-NEXT:    vpermilps {{.*#+}} ymm15 = mem[2,3,2,3,6,7,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm15[0],ymm1[1,2],ymm15[3,4],ymm1[5,6],ymm15[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm1[0],ymm0[1,2,3,4],ymm1[5,6,7]
; AVX2-FP-NEXT:    vbroadcastss 176(%rdx), %ymm0
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm15 = ymm1[3,1,2,0,7,5,6,4]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm15[0,1,2,3,4,5],ymm0[6],ymm15[7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm15 = ymm14[0],ymm0[0],ymm14[1],ymm0[1],ymm14[4],ymm0[4],ymm14[5],ymm0[5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm15[4,5],ymm2[6,7]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX2-FP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm15 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm15 = xmm7[3,3],mem[3,3]
; AVX2-FP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm15 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm15 = xmm15[0,1,2],mem[3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm15[1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm15 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm15 = ymm1[2],mem[2],ymm1[3],mem[3],ymm1[6],mem[6],ymm1[7],mem[7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm14[2],ymm0[3],ymm14[3],ymm0[6],ymm14[6],ymm0[7],ymm14[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[3,3,3,3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm15[3,4,5,6,7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm15 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm15 = ymm1[3,3],mem[3,3],ymm1[7,7],mem[7,7]
; AVX2-FP-NEXT:    vpermilps {{.*#+}} ymm14 = mem[2,3,2,3,6,7,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0],ymm15[1,2],ymm14[3,4],ymm15[5,6],ymm14[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm14 = ymm14[2,1,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm14[0],ymm0[1,2,3,4],ymm14[5,6,7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm14 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm14 = ymm1[0],mem[0],ymm1[1],mem[1],ymm1[4],mem[4],ymm1[5],mem[5]
; AVX2-FP-NEXT:    vpermilps $39, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm15 = mem[3,1,2,0,7,5,6,4]
; AVX2-FP-NEXT:    vbroadcastss 208(%rdx), %ymm13
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm13 = ymm15[0,1,2,3,4,5],ymm13[6],ymm15[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1,2,3],ymm14[4,5],ymm13[6,7]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm14 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm14 = xmm1[3,3],mem[3,3]
; AVX2-FP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm14 = xmm14[0,1,2],mem[3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0],ymm14[1,2,3],ymm13[4,5,6,7]
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FP-NEXT:    vmovaps %ymm13, 1440(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm0, 1312(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm2, 1216(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm3, 1088(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm4, 992(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm5, 864(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm6, 768(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm8, 640(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 544(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm11, 320(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm12, 192(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm10, 96(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1504(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm9, 1472(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1280(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1248(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1056(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1024(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 832(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 800(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1760(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1728(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1664(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1536(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1408(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1376(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1344(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1184(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1152(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1120(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 960(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 928(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 896(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 736(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1696(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1632(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1600(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1568(%rax)
; AVX2-FP-NEXT:    addq $2968, %rsp # imm = 0xB98
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i32_stride7_vf64:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    subq $3080, %rsp # imm = 0xC08
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FCP-NEXT:    vmovaps (%rax), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps (%r8), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%r8), %xmm3
; AVX2-FCP-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%r9), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%r9), %xmm4
; AVX2-FCP-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1,1,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd %xmm1, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovaps (%rcx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rcx), %xmm5
; AVX2-FCP-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rdx), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vinsertps {{.*#+}} xmm1 = zero,xmm1[1],xmm2[1],zero
; AVX2-FCP-NEXT:    vmovaps (%rdi), %xmm8
; AVX2-FCP-NEXT:    vmovaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %xmm6
; AVX2-FCP-NEXT:    vmovaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rsi), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %xmm7
; AVX2-FCP-NEXT:    vmovaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0,1],xmm8[2],xmm2[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1,2],ymm2[3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rax), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm4[1,1,1,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],xmm3[1],xmm1[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd %xmm1, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5],ymm1[6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm7[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm6[2],xmm1[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FCP-NEXT:    vmovaps 32(%rdx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm2[1],xmm5[1],zero
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%r8), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%r9), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps 64(%rax), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps 64(%rdi), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%rsi), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm2[2],xmm1[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FCP-NEXT:    vmovaps 64(%rcx), %xmm3
; AVX2-FCP-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%rdx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm2[1],xmm3[1],zero
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%r8), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%r9), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps 96(%rax), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rsi), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm2[2],xmm1[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FCP-NEXT:    vmovaps 96(%rcx), %xmm3
; AVX2-FCP-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rdx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm2[1],xmm3[1],zero
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 128(%r8), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, (%rsp) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 128(%r9), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps 128(%rax), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps 128(%rdi), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 128(%rsi), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm2[2],xmm1[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FCP-NEXT:    vmovaps 128(%rcx), %xmm3
; AVX2-FCP-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 128(%rdx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm2[1],xmm3[1],zero
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 160(%r8), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 160(%r9), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps 160(%rax), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps 160(%rdi), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 160(%rsi), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm2[2],xmm1[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FCP-NEXT:    vmovaps 160(%rcx), %xmm3
; AVX2-FCP-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 160(%rdx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm2[1],xmm3[1],zero
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 192(%r9), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 192(%r8), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps 192(%rax), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps 192(%rdi), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 192(%rsi), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm2[2],xmm1[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FCP-NEXT:    vmovaps 192(%rcx), %xmm3
; AVX2-FCP-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 192(%rdx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm2[1],xmm3[1],zero
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rcx), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm2[2],ymm1[2],ymm2[3],ymm1[3],ymm2[6],ymm1[6],ymm2[7],ymm1[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps (%r8), %ymm15
; AVX2-FCP-NEXT:    vmovaps (%r9), %ymm13
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm13[1,1,2,2,5,5,6,6]
; AVX2-FCP-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm15[2],ymm1[3,4,5],ymm15[6],ymm1[7]
; AVX2-FCP-NEXT:    vmovups %ymm15, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FCP-NEXT:    vmovaps 16(%rax), %xmm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps 32(%rdx), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rcx), %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps 32(%r8), %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%r9), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FCP-NEXT:    vmovaps 48(%rax), %xmm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%rsi), %ymm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps 64(%rdx), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%rcx), %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps 64(%r8), %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%r9), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FCP-NEXT:    vmovaps 80(%rax), %xmm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps 96(%rdx), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rcx), %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps 96(%r8), %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%r9), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FCP-NEXT:    vmovaps 112(%rax), %xmm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 128(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 128(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps 128(%rdx), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 128(%rcx), %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps 128(%r8), %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 128(%r9), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FCP-NEXT:    vmovaps 144(%rax), %xmm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 160(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 160(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps 160(%rdx), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 160(%rcx), %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps 160(%r8), %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 160(%r9), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FCP-NEXT:    vmovaps 176(%rax), %xmm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 192(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 192(%rsi), %ymm12
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm1[2],ymm12[2],ymm1[3],ymm12[3],ymm1[6],ymm12[6],ymm1[7],ymm12[7]
; AVX2-FCP-NEXT:    vmovups %ymm12, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps %ymm1, %ymm10
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps 192(%rdx), %ymm7
; AVX2-FCP-NEXT:    vmovaps 192(%rcx), %ymm8
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm7[2],ymm8[2],ymm7[3],ymm8[3],ymm7[6],ymm8[6],ymm7[7],ymm8[7]
; AVX2-FCP-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps 192(%r8), %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 192(%r9), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1,2,2,5,5,6,6]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FCP-NEXT:    vmovaps 208(%rax), %xmm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 224(%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovaps 224(%rsi), %xmm1
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm2 = xmm1[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0,1],xmm0[2],xmm2[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-FCP-NEXT:    vmovaps 224(%rcx), %xmm3
; AVX2-FCP-NEXT:    vmovaps 224(%rdx), %xmm6
; AVX2-FCP-NEXT:    vinsertps {{.*#+}} xmm5 = zero,xmm6[1],xmm3[1],zero
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm5[1,2],ymm2[3,4,5,6,7]
; AVX2-FCP-NEXT:    vbroadcastss 228(%r8), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2],ymm4[3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps 224(%r9), %xmm4
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm11 = xmm4[1,1,1,1]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm11, %ymm0, %ymm11
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm11[4,5],ymm2[6,7]
; AVX2-FCP-NEXT:    vinsertf128 $1, 224(%rax), %ymm5, %ymm5
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm5[1],ymm2[2,3,4],ymm5[5],ymm2[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vbroadcastss %xmm3, %xmm2
; AVX2-FCP-NEXT:    vbroadcastss %xmm6, %xmm5
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm5[0],xmm2[0],xmm5[1],xmm2[1]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm11 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX2-FCP-NEXT:    vbroadcastf128 {{.*#+}} ymm9 = [0,1,2,2,0,1,2,2]
; AVX2-FCP-NEXT:    # ymm9 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpermps %ymm11, %ymm9, %ymm11
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm11[0,1],ymm2[2,3],ymm11[4,5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 224(%r8), %ymm11
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm11[4,5],ymm2[6,7]
; AVX2-FCP-NEXT:    vbroadcastss %xmm4, %ymm11
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4],ymm11[5],ymm2[6,7]
; AVX2-FCP-NEXT:    vbroadcastss 224(%rax), %ymm11
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm11[6],ymm2[7]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[3,3],xmm1[3,3]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm6[2],xmm3[2],xmm6[3],xmm3[3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm9, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vmovaps 224(%r8), %ymm6
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm6[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm4[2,2,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vbroadcastss 232(%rax), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 224(%rdi), %ymm2
; AVX2-FCP-NEXT:    vmovaps 224(%rsi), %ymm1
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm2[1],ymm0[2,3,4],ymm2[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps 224(%rdx), %ymm3
; AVX2-FCP-NEXT:    vmovaps 224(%rcx), %ymm0
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm14 = ymm3[1,1],ymm0[1,1],ymm3[5,5],ymm0[5,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3,4],ymm14[5,6],ymm11[7]
; AVX2-FCP-NEXT:    vbroadcastsd 240(%r8), %ymm14
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm11 = ymm14[0],ymm11[1,2,3,4,5,6],ymm14[7]
; AVX2-FCP-NEXT:    vbroadcastss 240(%r9), %xmm14
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0],ymm14[1],ymm11[2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vbroadcastss 240(%rax), %ymm14
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1],ymm14[2],ymm11[3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm11 = ymm8[2],ymm7[2],ymm8[3],ymm7[3],ymm8[6],ymm7[6],ymm8[7],ymm7[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[3,3,3,3]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm14 = ymm12[2],ymm10[2],ymm12[3],ymm10[3],ymm12[6],ymm10[6],ymm12[7],ymm10[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm14 = ymm14[3,3,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm11 = ymm14[0,1,2],ymm11[3,4,5,6,7]
; AVX2-FCP-NEXT:    vbroadcastss 220(%r8), %ymm14
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3,4],ymm14[5],ymm11[6,7]
; AVX2-FCP-NEXT:    vbroadcastss 220(%r9), %ymm14
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3,4,5],ymm14[6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 216(%rax), %ymm14
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm5 = ymm14[0],ymm11[1,2,3,4,5,6],ymm14[7]
; AVX2-FCP-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vbroadcastss 240(%rdx), %ymm11
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm14 = ymm0[3,1,2,0,7,5,6,4]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm11 = ymm14[0,1,2,3,4,5],ymm11[6],ymm14[7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm14 = ymm2[0],ymm1[0],ymm2[1],ymm1[1],ymm2[4],ymm1[4],ymm2[5],ymm1[5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3],ymm14[4,5],ymm11[6,7]
; AVX2-FCP-NEXT:    vbroadcastss 236(%r8), %ymm14
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0],ymm14[1],ymm11[2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm11[0,1],ymm4[2,3],ymm11[4,5,6,7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm11 = ymm2[2],ymm1[2],ymm2[3],ymm1[3],ymm2[6],ymm1[6],ymm2[7],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[2,2,2,2]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm14 = ymm3[2],ymm0[2],ymm3[3],ymm0[3],ymm3[6],ymm0[6],ymm3[7],ymm0[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3],ymm14[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm11[0,1,2,3,4,5],ymm6[6,7]
; AVX2-FCP-NEXT:    vbroadcastsd {{.*#+}} ymm11 = [5,6,5,6,5,6,5,6]
; AVX2-FCP-NEXT:    vpermps 224(%r9), %ymm11, %ymm11
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm11[0],ymm6[1,2,3,4,5,6],ymm11[7]
; AVX2-FCP-NEXT:    vmovaps 224(%rax), %ymm11
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2],ymm11[3],ymm4[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm11[2,3],ymm14[2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm6[0],ymm4[1],ymm6[2,3,4],ymm4[5],ymm6[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm3[2],ymm0[3],ymm3[3],ymm0[6],ymm3[6],ymm0[7],ymm3[7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX2-FCP-NEXT:    vbroadcastss 252(%r8), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vbroadcastss 252(%r9), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 248(%rax), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4,5,6],ymm1[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-FCP-NEXT:    vbroadcastss %xmm5, %xmm0
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX2-FCP-NEXT:    vbroadcastss %xmm4, %xmm1
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm9, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm3[0],xmm8[0],xmm3[1],xmm8[1]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6],ymm0[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm0 = xmm7[3,3],xmm6[3,3]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm4[2],xmm5[2],xmm4[3],xmm5[3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm9, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm8[2,2,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm3[0,1,2],xmm1[3]
; AVX2-FCP-NEXT:    vbroadcastsd 8(%rax), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermilps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vblendps $34, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = ymm0[0],mem[1],ymm0[2,3,4],mem[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm1 = ymm1[1,1],mem[1,1],ymm1[5,5],mem[5,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm13[0,0,0,0,4,4,4,4]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm2 = ymm15[0,1,0,1,4,5,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3,4],ymm1[5],ymm2[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 16(%rax), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX2-FCP-NEXT:    vbroadcastss %xmm3, %xmm0
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX2-FCP-NEXT:    vbroadcastss %xmm7, %xmm1
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm5[0],xmm6[0],xmm5[1],xmm6[1]
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm9, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm4[0],xmm8[0],xmm4[1],xmm8[1]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6],ymm0[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm0 = xmm5[3,3],xmm6[3,3]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm7[2],xmm3[2],xmm7[3],xmm3[3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm9, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm8[2,2,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm4[0,1,2],xmm1[3]
; AVX2-FCP-NEXT:    vbroadcastsd 40(%rax), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermilps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vblendps $34, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = ymm0[0],mem[1],ymm0[2,3,4],mem[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm1 = ymm1[1,1],mem[1,1],ymm1[5,5],mem[5,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX2-FCP-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm1 = mem[0,0,0,0,4,4,4,4]
; AVX2-FCP-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm2 = mem[0,1,0,1,4,5,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3,4],ymm1[5],ymm2[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 48(%rax), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX2-FCP-NEXT:    vbroadcastss %xmm7, %xmm0
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX2-FCP-NEXT:    vbroadcastss %xmm6, %xmm1
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm9, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm8[0],xmm4[0],xmm8[1],xmm4[1]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6],ymm0[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm0 = xmm5[3,3],xmm3[3,3]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm6[2],xmm7[2],xmm6[3],xmm7[3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm9, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm4[2,2,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm8[0,1,2],xmm1[3]
; AVX2-FCP-NEXT:    vbroadcastsd 72(%rax), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermilps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vblendps $34, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = ymm0[0],mem[1],ymm0[2,3,4],mem[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm1 = ymm1[1,1],mem[1,1],ymm1[5,5],mem[5,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX2-FCP-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm1 = mem[0,0,0,0,4,4,4,4]
; AVX2-FCP-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm2 = mem[0,1,0,1,4,5,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3,4],ymm1[5],ymm2[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 80(%rax), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX2-FCP-NEXT:    vbroadcastss %xmm8, %xmm0
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX2-FCP-NEXT:    vbroadcastss %xmm7, %xmm1
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm6[0],xmm5[0],xmm6[1],xmm5[1]
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm9, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6],ymm0[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm0 = xmm6[3,3],xmm5[3,3]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm7[2],xmm8[2],xmm7[3],xmm8[3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm9, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm4[2,2,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm3[0,1,2],xmm1[3]
; AVX2-FCP-NEXT:    vbroadcastsd 104(%rax), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm13[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm10[1],ymm0[2,3,4],ymm10[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm1 = ymm1[1,1],mem[1,1],ymm1[5,5],mem[5,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX2-FCP-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm1 = mem[0,0,0,0,4,4,4,4]
; AVX2-FCP-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm2 = mem[0,1,0,1,4,5,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3,4],ymm1[5],ymm2[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 112(%rax), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX2-FCP-NEXT:    vbroadcastss %xmm8, %xmm0
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX2-FCP-NEXT:    vbroadcastss %xmm7, %xmm1
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm6[0],xmm5[0],xmm6[1],xmm5[1]
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm9, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX2-FCP-NEXT:    vmovaps (%rsp), %xmm3 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6],ymm0[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm0 = xmm6[3,3],xmm5[3,3]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm7[2],xmm8[2],xmm7[3],xmm8[3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm9, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm4[2,2,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm3[0,1,2],xmm1[3]
; AVX2-FCP-NEXT:    vbroadcastsd 136(%rax), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm15[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm14[1],ymm0[2,3,4],ymm14[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm1 = ymm1[1,1],mem[1,1],ymm1[5,5],mem[5,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX2-FCP-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm1 = mem[0,0,0,0,4,4,4,4]
; AVX2-FCP-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm2 = mem[0,1,0,1,4,5,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3,4],ymm1[5],ymm2[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 144(%rax), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX2-FCP-NEXT:    vbroadcastss %xmm8, %xmm0
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX2-FCP-NEXT:    vbroadcastss %xmm7, %xmm1
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm6[0],xmm5[0],xmm6[1],xmm5[1]
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm9, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6],ymm0[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm0 = xmm6[3,3],xmm5[3,3]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm7[2],xmm8[2],xmm7[3],xmm8[3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm9, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm4[2,2,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm3[0,1,2],xmm1[3]
; AVX2-FCP-NEXT:    vbroadcastsd 168(%rax), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermilps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vblendps $34, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = ymm0[0],mem[1],ymm0[2,3,4],mem[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm1 = ymm1[1,1],mem[1,1],ymm1[5,5],mem[5,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6],ymm0[7]
; AVX2-FCP-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm1 = mem[0,0,0,0,4,4,4,4]
; AVX2-FCP-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm2 = mem[0,1,0,1,4,5,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3,4],ymm1[5],ymm2[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 176(%rax), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX2-FCP-NEXT:    vbroadcastss %xmm7, %xmm0
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX2-FCP-NEXT:    vbroadcastss %xmm6, %xmm1
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm0[0],xmm5[0],xmm0[1],xmm5[1]
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm9, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm8[0,1,2,3],ymm1[4,5,6],ymm8[7]
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[3,3],xmm5[3,3]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm6[2],xmm7[2],xmm6[3],xmm7[3]
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm9, %ymm1
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm3[2,2,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm4[0,1,2],xmm1[3]
; AVX2-FCP-NEXT:    vbroadcastsd 200(%rax), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,1],ymm12[1,1],ymm0[5,5],ymm12[5,5]
; AVX2-FCP-NEXT:    vpermilps $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm1 = mem[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm11[1],ymm1[2,3,4],ymm11[5],ymm1[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm0[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vpermilps $0, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm1 = mem[0,0,0,0,4,4,4,4]
; AVX2-FCP-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm2 = mem[0,1,0,1,4,5,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3,4],ymm1[5],ymm2[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 208(%rax), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vbroadcastss 16(%rdx), %ymm0
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm4[3,1,2,0,7,5,6,4]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6],ymm1[7]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm3[0],ymm2[0],ymm3[1],ymm2[1],ymm3[4],ymm2[4],ymm3[5],ymm2[5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FCP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm1 = xmm1[3,3],mem[3,3]
; AVX2-FCP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm1 = xmm1[0,1,2],mem[3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = ymm4[2],mem[2],ymm4[3],mem[3],ymm4[6],mem[6],ymm4[7],mem[7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm5 = ymm2[2],ymm3[2],ymm2[3],ymm3[3],ymm2[6],ymm3[6],ymm2[7],ymm3[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[3,3,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1,2],ymm0[3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm5 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm5 = ymm1[3,3],mem[3,3],ymm1[7,7],mem[7,7]
; AVX2-FCP-NEXT:    vpermilps {{.*#+}} ymm6 = mem[2,3,2,3,6,7,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0],ymm5[1,2],ymm6[3,4],ymm5[5,6],ymm6[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[2,1,2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0],ymm0[1,2,3,4],ymm5[5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vbroadcastss 48(%rdx), %ymm0
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm6 = ymm4[3,1,2,0,7,5,6,4]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1,2,3,4,5],ymm0[6],ymm6[7]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm6 = ymm2[0],ymm1[0],ymm2[1],ymm1[1],ymm2[4],ymm1[4],ymm2[5],ymm1[5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm6[4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX2-FCP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm6 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm6 = xmm3[3,3],mem[3,3]
; AVX2-FCP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm6, %xmm6 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm6 = xmm6[0,1,2],mem[3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm5 = ymm0[0],ymm6[1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = ymm4[2],mem[2],ymm4[3],mem[3],ymm4[6],mem[6],ymm4[7],mem[7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm6 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[3,3,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1,2],ymm0[3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm6 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm6 = ymm1[3,3],mem[3,3],ymm1[7,7],mem[7,7]
; AVX2-FCP-NEXT:    vpermilps {{.*#+}} ymm7 = mem[2,3,2,3,6,7,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0],ymm6[1,2],ymm7[3,4],ymm6[5,6],ymm7[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[2,1,2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm7 = ymm6[0],ymm0[1,2,3,4],ymm6[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastss 80(%rdx), %ymm0
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm6 = ymm4[3,1,2,0,7,5,6,4]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1,2,3,4,5],ymm0[6],ymm6[7]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm6 = ymm2[0],ymm1[0],ymm2[1],ymm1[1],ymm2[4],ymm1[4],ymm2[5],ymm1[5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm6[4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX2-FCP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm6 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm6 = xmm3[3,3],mem[3,3]
; AVX2-FCP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm6, %xmm6 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm6 = xmm6[0,1,2],mem[3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm0[0],ymm6[1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = ymm4[2],mem[2],ymm4[3],mem[3],ymm4[6],mem[6],ymm4[7],mem[7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm6 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[3,3,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1,2],ymm0[3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm6 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm6 = ymm1[3,3],mem[3,3],ymm1[7,7],mem[7,7]
; AVX2-FCP-NEXT:    vpermilps {{.*#+}} ymm9 = mem[2,3,2,3,6,7,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm9[0],ymm6[1,2],ymm9[3,4],ymm6[5,6],ymm9[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[2,1,2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0],ymm0[1,2,3,4],ymm6[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastss 112(%rdx), %ymm1
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm9 = ymm0[3,1,2,0,7,5,6,4]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm9[0,1,2,3,4,5],ymm1[6],ymm9[7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm9 = ymm10[0],ymm13[0],ymm10[1],ymm13[1],ymm10[4],ymm13[4],ymm10[5],ymm13[5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm9[4,5],ymm2[6,7]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX2-FCP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8, %xmm9 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm9 = xmm8[3,3],mem[3,3]
; AVX2-FCP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm9, %xmm9 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm9 = xmm9[0,1,2],mem[3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm9[1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm9 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm9 = ymm0[2],mem[2],ymm0[3],mem[3],ymm0[6],mem[6],ymm0[7],mem[7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm10 = ymm13[2],ymm10[2],ymm13[3],ymm10[3],ymm13[6],ymm10[6],ymm13[7],ymm10[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[3,3,3,3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[3,3,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0,1,2],ymm9[3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm10 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm10 = ymm0[3,3],mem[3,3],ymm0[7,7],mem[7,7]
; AVX2-FCP-NEXT:    vpermilps {{.*#+}} ymm13 = mem[2,3,2,3,6,7,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm10 = ymm13[0],ymm10[1,2],ymm13[3,4],ymm10[5,6],ymm13[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[2,1,2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0],ymm9[1,2,3,4],ymm10[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastss 144(%rdx), %ymm10
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm13 = ymm1[3,1,2,0,7,5,6,4]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm10 = ymm13[0,1,2,3,4,5],ymm10[6],ymm13[7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm13 = ymm14[0],ymm15[0],ymm14[1],ymm15[1],ymm14[4],ymm15[4],ymm14[5],ymm15[5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm13[4,5],ymm10[6,7]
; AVX2-FCP-NEXT:    vmovaps (%rsp), %xmm8 # 16-byte Reload
; AVX2-FCP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8, %xmm13 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm13 = xmm8[3,3],mem[3,3]
; AVX2-FCP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm13, %xmm13 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm13 = xmm13[0,1,2],mem[3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0],ymm13[1,2,3],ymm10[4,5,6,7]
; AVX2-FCP-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm13 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm13 = ymm1[2],mem[2],ymm1[3],mem[3],ymm1[6],mem[6],ymm1[7],mem[7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm14 = ymm15[2],ymm14[2],ymm15[3],ymm14[3],ymm15[6],ymm14[6],ymm15[7],ymm14[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[3,3,3,3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm14 = ymm14[3,3,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm13 = ymm14[0,1,2],ymm13[3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm14 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm14 = ymm0[3,3],mem[3,3],ymm0[7,7],mem[7,7]
; AVX2-FCP-NEXT:    vpermilps {{.*#+}} ymm15 = mem[2,3,2,3,6,7,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0],ymm14[1,2],ymm15[3,4],ymm14[5,6],ymm15[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm14 = ymm14[2,1,2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm13 = ymm14[0],ymm13[1,2,3,4],ymm14[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastss 176(%rdx), %ymm14
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm15 = ymm1[3,1,2,0,7,5,6,4]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0,1,2,3,4,5],ymm14[6],ymm15[7]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm15 = ymm4[0],ymm0[0],ymm4[1],ymm0[1],ymm4[4],ymm0[4],ymm4[5],ymm0[5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm15[4,5],ymm14[6,7]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX2-FCP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8, %xmm15 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm15 = xmm8[3,3],mem[3,3]
; AVX2-FCP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm15 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm15 = xmm15[0,1,2],mem[3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0],ymm15[1,2,3],ymm14[4,5,6,7]
; AVX2-FCP-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm15 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm15 = ymm1[2],mem[2],ymm1[3],mem[3],ymm1[6],mem[6],ymm1[7],mem[7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm4[2],ymm0[3],ymm4[3],ymm0[6],ymm4[6],ymm0[7],ymm4[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[3,3,3,3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm15[3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm15 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm15 = ymm1[3,3],mem[3,3],ymm1[7,7],mem[7,7]
; AVX2-FCP-NEXT:    vpermilps {{.*#+}} ymm8 = mem[2,3,2,3,6,7,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0],ymm15[1,2],ymm8[3,4],ymm15[5,6],ymm8[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[2,1,2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm8[0],ymm0[1,2,3,4],ymm8[5,6,7]
; AVX2-FCP-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm8 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm8 = ymm11[0],mem[0],ymm11[1],mem[1],ymm11[4],mem[4],ymm11[5],mem[5]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm15 = ymm12[3,1,2,0,7,5,6,4]
; AVX2-FCP-NEXT:    vbroadcastss 208(%rdx), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm15[0,1,2,3,4,5],ymm4[6],ymm15[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm8[4,5],ymm4[6,7]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FCP-NEXT:    vshufps $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm8 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm8 = xmm1[3,3],mem[3,3]
; AVX2-FCP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8, %xmm8 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm8 = xmm8[0,1,2],mem[3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm8[1,2,3],ymm4[4,5,6,7]
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FCP-NEXT:    vmovaps %ymm4, 1440(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1312(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm14, 1216(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm13, 1088(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm10, 992(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm9, 864(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm2, 768(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm6, 640(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm3, 544(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm7, 416(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm5, 320(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1504(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1472(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1408(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1344(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1280(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1248(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1184(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1120(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1056(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1024(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 960(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 896(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 832(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 800(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 736(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1760(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1728(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1664(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1536(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1376(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1152(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 928(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1696(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1632(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1568(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1600(%rax)
; AVX2-FCP-NEXT:    addq $3080, %rsp # imm = 0xC08
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride7_vf64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    subq $3080, %rsp # imm = 0xC08
; AVX512-NEXT:    vmovdqa64 (%rdx), %zmm3
; AVX512-NEXT:    vmovdqa64 (%rcx), %zmm2
; AVX512-NEXT:    vmovdqa64 (%r8), %zmm0
; AVX512-NEXT:    vmovdqa64 64(%r8), %zmm25
; AVX512-NEXT:    vmovdqa64 128(%r8), %zmm22
; AVX512-NEXT:    vmovdqa64 (%r9), %zmm6
; AVX512-NEXT:    vmovdqa64 64(%r9), %zmm5
; AVX512-NEXT:    vmovdqa64 128(%r9), %zmm4
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,16,0,0,0,0,0,1,17,0,0,0,0,0]
; AVX512-NEXT:    vmovdqa64 %zmm3, %zmm7
; AVX512-NEXT:    vpermt2d %zmm2, %zmm1, %zmm7
; AVX512-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm8
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512-NEXT:    vpermt2d %zmm6, %zmm1, %zmm7
; AVX512-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm10
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [2,18,0,0,0,0,0,3,19,0,0,0,0,0,4,20]
; AVX512-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512-NEXT:    vpermt2d %zmm2, %zmm7, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm9
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,2,18,0,0,0,0,0,3,19,0,0,0,0,0]
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512-NEXT:    vpermt2d %zmm6, %zmm1, %zmm7
; AVX512-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm11
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [4,20,0,0,0,0,0,5,21,0,0,0,0,0,6,22]
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512-NEXT:    vpermt2d %zmm6, %zmm1, %zmm7
; AVX512-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,0,0,7,23,0,0,0,0,0,8,24,0,0]
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm12
; AVX512-NEXT:    vpermt2d %zmm6, %zmm1, %zmm12
; AVX512-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm12
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,9,25,0,0,0,0,0,10,26,0,0,0,0]
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm13
; AVX512-NEXT:    vpermt2d %zmm6, %zmm1, %zmm13
; AVX512-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm13
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,11,27,0,0,0,0,0,12,28,0,0,0,0,0,13]
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm14
; AVX512-NEXT:    vpermt2d %zmm6, %zmm1, %zmm14
; AVX512-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm14
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [13,0,0,0,0,0,30,14,0,0,0,0,0,31,15,0]
; AVX512-NEXT:    vpermt2d %zmm0, %zmm1, %zmm6
; AVX512-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512-NEXT:    vpermt2d %zmm5, %zmm10, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512-NEXT:    vpermt2d %zmm5, %zmm11, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512-NEXT:    vpermt2d %zmm5, %zmm7, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512-NEXT:    vpermt2d %zmm5, %zmm12, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512-NEXT:    vpermt2d %zmm5, %zmm13, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512-NEXT:    vpermt2d %zmm5, %zmm14, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2d %zmm25, %zmm1, %zmm5
; AVX512-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm22, %zmm0
; AVX512-NEXT:    vpermt2d %zmm4, %zmm10, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm22, %zmm0
; AVX512-NEXT:    vpermt2d %zmm4, %zmm11, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm22, %zmm0
; AVX512-NEXT:    vpermt2d %zmm4, %zmm7, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermi2d %zmm4, %zmm22, %zmm12
; AVX512-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermi2d %zmm4, %zmm22, %zmm13
; AVX512-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermi2d %zmm4, %zmm22, %zmm14
; AVX512-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2d %zmm22, %zmm1, %zmm4
; AVX512-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,5,21,0,0,0,0,0,6,22,0,0]
; AVX512-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512-NEXT:    vpermt2d %zmm2, %zmm0, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,7,23,0,0,0,0,0,8,24,0,0,0,0]
; AVX512-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512-NEXT:    vpermt2d %zmm2, %zmm11, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm30 = [0,9,25,0,0,0,0,0,10,26,0,0,0,0,0,11]
; AVX512-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512-NEXT:    vpermt2d %zmm2, %zmm30, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [11,0,0,0,0,0,28,12,0,0,0,0,0,29,13,0]
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm1
; AVX512-NEXT:    vpermt2d %zmm3, %zmm4, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,0,14,30,0,0,0,0,0,15,31,0,0,0]
; AVX512-NEXT:    vpermt2d %zmm2, %zmm1, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 64(%rdx), %zmm24
; AVX512-NEXT:    vmovdqa64 64(%rcx), %zmm2
; AVX512-NEXT:    vmovdqa64 %zmm24, %zmm3
; AVX512-NEXT:    vpermt2d %zmm2, %zmm8, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm24, %zmm3
; AVX512-NEXT:    vpermt2d %zmm2, %zmm9, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm24, %zmm3
; AVX512-NEXT:    vpermt2d %zmm2, %zmm0, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm24, %zmm3
; AVX512-NEXT:    vpermt2d %zmm2, %zmm11, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm24, %zmm3
; AVX512-NEXT:    vpermt2d %zmm2, %zmm30, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm3
; AVX512-NEXT:    vpermt2d %zmm24, %zmm4, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2d %zmm2, %zmm1, %zmm24
; AVX512-NEXT:    vmovdqa64 192(%rdx), %zmm29
; AVX512-NEXT:    vmovdqa64 192(%rcx), %zmm2
; AVX512-NEXT:    vmovdqa64 %zmm29, %zmm28
; AVX512-NEXT:    vpermt2d %zmm2, %zmm11, %zmm28
; AVX512-NEXT:    vmovdqa64 %zmm29, %zmm3
; AVX512-NEXT:    vpermt2d %zmm2, %zmm30, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm3
; AVX512-NEXT:    vpermt2d %zmm29, %zmm4, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm29, %zmm3
; AVX512-NEXT:    vpermt2d %zmm2, %zmm1, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 128(%rdx), %zmm21
; AVX512-NEXT:    vmovdqa64 128(%rcx), %zmm3
; AVX512-NEXT:    vpermi2d %zmm3, %zmm21, %zmm11
; AVX512-NEXT:    vpermi2d %zmm3, %zmm21, %zmm30
; AVX512-NEXT:    vpermi2d %zmm21, %zmm3, %zmm4
; AVX512-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm21, %zmm6
; AVX512-NEXT:    vmovdqa64 %zmm21, %zmm5
; AVX512-NEXT:    vmovdqa64 %zmm21, %zmm4
; AVX512-NEXT:    vpermt2d %zmm3, %zmm1, %zmm21
; AVX512-NEXT:    vpermt2d %zmm3, %zmm8, %zmm6
; AVX512-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2d %zmm3, %zmm9, %zmm5
; AVX512-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2d %zmm3, %zmm0, %zmm4
; AVX512-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermi2d %zmm2, %zmm29, %zmm8
; AVX512-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermi2d %zmm2, %zmm29, %zmm9
; AVX512-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2d %zmm2, %zmm0, %zmm29
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm22
; AVX512-NEXT:    vmovdqa64 (%rsi), %zmm0
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,16,0,0,0,0,0,1,17,0,0,0,0,0,2,18]
; AVX512-NEXT:    vmovdqa64 %zmm22, %zmm1
; AVX512-NEXT:    vpermt2d %zmm0, %zmm9, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,0,0,0,0,3,19,0,0,0,0,0,4,20,0,0]
; AVX512-NEXT:    vmovdqa64 %zmm22, %zmm1
; AVX512-NEXT:    vpermt2d %zmm0, %zmm20, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm27 = [0,0,0,5,21,0,0,0,0,0,6,22,0,0,0,0]
; AVX512-NEXT:    vmovdqa64 %zmm22, %zmm1
; AVX512-NEXT:    vpermt2d %zmm0, %zmm27, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,7,23,0,0,0,0,0,8,24,0,0,0,0,0,9]
; AVX512-NEXT:    vmovdqa64 %zmm22, %zmm1
; AVX512-NEXT:    vpermt2d %zmm0, %zmm7, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, (%rsp) # 64-byte Spill
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [9,0,0,0,0,0,26,10,0,0,0,0,0,27,11,0]
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm3
; AVX512-NEXT:    vpermt2d %zmm22, %zmm6, %zmm3
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,0,12,28,0,0,0,0,0,13,29,0,0,0]
; AVX512-NEXT:    vmovdqa64 %zmm22, %zmm18
; AVX512-NEXT:    vpermt2d %zmm0, %zmm1, %zmm18
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,0,14,30,0,0,0,0,0,15,31,0,0,0,0,0]
; AVX512-NEXT:    vpermt2d %zmm0, %zmm8, %zmm22
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm5
; AVX512-NEXT:    vmovdqa64 64(%rsi), %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm31
; AVX512-NEXT:    vpermt2d %zmm0, %zmm9, %zmm31
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm2
; AVX512-NEXT:    vpermt2d %zmm0, %zmm20, %zmm2
; AVX512-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm2
; AVX512-NEXT:    vpermt2d %zmm0, %zmm27, %zmm2
; AVX512-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm26
; AVX512-NEXT:    vpermt2d %zmm0, %zmm7, %zmm26
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm25
; AVX512-NEXT:    vpermt2d %zmm5, %zmm6, %zmm25
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512-NEXT:    vpermt2d %zmm0, %zmm1, %zmm10
; AVX512-NEXT:    vpermt2d %zmm0, %zmm8, %zmm5
; AVX512-NEXT:    vmovdqa64 192(%rdi), %zmm12
; AVX512-NEXT:    vmovdqa64 192(%rsi), %zmm13
; AVX512-NEXT:    vmovdqa64 %zmm12, %zmm16
; AVX512-NEXT:    vpermt2d %zmm13, %zmm7, %zmm16
; AVX512-NEXT:    vmovdqa64 %zmm13, %zmm14
; AVX512-NEXT:    vpermt2d %zmm12, %zmm6, %zmm14
; AVX512-NEXT:    vmovdqa64 %zmm12, %zmm2
; AVX512-NEXT:    vpermt2d %zmm13, %zmm1, %zmm2
; AVX512-NEXT:    vmovdqa64 %zmm12, %zmm15
; AVX512-NEXT:    vpermt2d %zmm13, %zmm8, %zmm15
; AVX512-NEXT:    vmovdqa64 128(%rdi), %zmm17
; AVX512-NEXT:    vmovdqa64 128(%rsi), %zmm0
; AVX512-NEXT:    vpermi2d %zmm0, %zmm17, %zmm7
; AVX512-NEXT:    vpermi2d %zmm17, %zmm0, %zmm6
; AVX512-NEXT:    vpermi2d %zmm0, %zmm17, %zmm1
; AVX512-NEXT:    vmovdqa64 %zmm17, %zmm19
; AVX512-NEXT:    vmovdqa64 %zmm17, %zmm4
; AVX512-NEXT:    vmovdqa64 %zmm17, %zmm23
; AVX512-NEXT:    vpermt2d %zmm0, %zmm8, %zmm17
; AVX512-NEXT:    vpermt2d %zmm0, %zmm9, %zmm19
; AVX512-NEXT:    vpermt2d %zmm0, %zmm20, %zmm4
; AVX512-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2d %zmm0, %zmm27, %zmm23
; AVX512-NEXT:    vpermi2d %zmm13, %zmm12, %zmm9
; AVX512-NEXT:    vpermi2d %zmm13, %zmm12, %zmm20
; AVX512-NEXT:    vpermt2d %zmm13, %zmm27, %zmm12
; AVX512-NEXT:    movw $3096, %ax # imm = 0xC18
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovdqa32 %zmm28, %zmm16 {%k1}
; AVX512-NEXT:    movw $-31994, %ax # imm = 0x8306
; AVX512-NEXT:    kmovw %eax, %k2
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm0, %zmm14 {%k2}
; AVX512-NEXT:    vmovdqu64 (%rsp), %zmm13 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm0, %zmm13 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm0, %zmm26 {%k1}
; AVX512-NEXT:    vmovdqa32 %zmm11, %zmm7 {%k1}
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqa64 (%rax), %zmm28
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [22,0,0,0,0,5,6,23,0,0,0,0,12,13,24,0]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512-NEXT:    vpermt2d %zmm28, %zmm0, %zmm8
; AVX512-NEXT:    movw $28897, %cx # imm = 0x70E1
; AVX512-NEXT:    kmovw %ecx, %k1
; AVX512-NEXT:    vmovdqa32 %zmm8, %zmm13 {%k1}
; AVX512-NEXT:    vmovdqu64 %zmm13, (%rsp) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 64(%rax), %zmm8
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512-NEXT:    vpermt2d %zmm8, %zmm0, %zmm11
; AVX512-NEXT:    vmovdqa32 %zmm11, %zmm26 {%k1}
; AVX512-NEXT:    vmovdqa64 128(%rax), %zmm27
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512-NEXT:    vpermt2d %zmm27, %zmm0, %zmm11
; AVX512-NEXT:    vmovdqa32 %zmm11, %zmm7 {%k1}
; AVX512-NEXT:    movw $6192, %cx # imm = 0x1830
; AVX512-NEXT:    kmovw %ecx, %k1
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1}
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm0, %zmm15 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k2}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm0, %zmm25 {%k2}
; AVX512-NEXT:    vmovdqa32 %zmm30, %zmm6 {%k2}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,3,4,25,0,0,0,0,10,11,26,0,0,0]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vpermt2d %zmm28, %zmm0, %zmm2
; AVX512-NEXT:    movw $7224, %cx # imm = 0x1C38
; AVX512-NEXT:    kmovw %ecx, %k2
; AVX512-NEXT:    vmovdqa32 %zmm2, %zmm3 {%k2}
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm18, %zmm11 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vpermt2d %zmm8, %zmm0, %zmm2
; AVX512-NEXT:    vmovdqa32 %zmm2, %zmm25 {%k2}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vpermt2d %zmm27, %zmm0, %zmm2
; AVX512-NEXT:    vmovdqa32 %zmm2, %zmm6 {%k2}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,27,0,0,0,0,8,9,28,0,0,0,0,15]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vpermt2d %zmm28, %zmm0, %zmm2
; AVX512-NEXT:    movw $-30962, %cx # imm = 0x870E
; AVX512-NEXT:    kmovw %ecx, %k2
; AVX512-NEXT:    vmovdqa32 %zmm2, %zmm11 {%k2}
; AVX512-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm10, %zmm11 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vpermt2d %zmm8, %zmm0, %zmm2
; AVX512-NEXT:    vmovdqa32 %zmm2, %zmm11 {%k2}
; AVX512-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm30 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm1, %zmm30 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vpermt2d %zmm27, %zmm0, %zmm1
; AVX512-NEXT:    vmovdqa32 %zmm1, %zmm30 {%k2}
; AVX512-NEXT:    movw $1548, %cx # imm = 0x60C
; AVX512-NEXT:    kmovw %ecx, %k2
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm0, %zmm2 {%k2}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm0, %zmm22 {%k1}
; AVX512-NEXT:    vmovdqa32 %zmm24, %zmm5 {%k1}
; AVX512-NEXT:    vmovdqa32 %zmm21, %zmm17 {%k1}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,29,0,0,0,0,6,7,30,0,0,0,0,13,14,31]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vpermt2d %zmm28, %zmm0, %zmm1
; AVX512-NEXT:    movw $-7741, %cx # imm = 0xE1C3
; AVX512-NEXT:    kmovw %ecx, %k1
; AVX512-NEXT:    vmovdqa32 %zmm1, %zmm22 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vpermt2d %zmm8, %zmm0, %zmm1
; AVX512-NEXT:    vmovdqa32 %zmm1, %zmm5 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vpermt2d %zmm27, %zmm0, %zmm1
; AVX512-NEXT:    vmovdqa32 %zmm1, %zmm17 {%k1}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,4,5,16,0,0,0,0,11,12,17,0,0]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vpermt2d %zmm28, %zmm0, %zmm1
; AVX512-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512-NEXT:    kmovw %ecx, %k3
; AVX512-NEXT:    vmovdqa32 %zmm1, %zmm2 {%k3}
; AVX512-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm1, %zmm31 {%k2}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm1, %zmm19 {%k2}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm1, %zmm9 {%k2}
; AVX512-NEXT:    movw $12384, %cx # imm = 0x3060
; AVX512-NEXT:    kmovw %ecx, %k1
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm1, %zmm3 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vpermt2d %zmm8, %zmm0, %zmm1
; AVX512-NEXT:    vmovdqa32 %zmm1, %zmm31 {%k3}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vpermt2d %zmm27, %zmm0, %zmm1
; AVX512-NEXT:    vmovdqa32 %zmm1, %zmm19 {%k3}
; AVX512-NEXT:    vmovdqa64 192(%r8), %zmm1
; AVX512-NEXT:    vmovdqa64 192(%r9), %zmm2
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512-NEXT:    vpermi2d %zmm2, %zmm1, %zmm11
; AVX512-NEXT:    vmovdqa64 192(%rax), %zmm10
; AVX512-NEXT:    vpermt2d %zmm10, %zmm0, %zmm11
; AVX512-NEXT:    vmovdqa32 %zmm11, %zmm9 {%k3}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,3,18,0,0,0,0,9,10,19,0,0,0,0]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512-NEXT:    vpermt2d %zmm28, %zmm0, %zmm11
; AVX512-NEXT:    movw $3612, %ax # imm = 0xE1C
; AVX512-NEXT:    kmovw %eax, %k2
; AVX512-NEXT:    vmovdqa32 %zmm11, %zmm3 {%k2}
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm11, %zmm4 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512-NEXT:    vpermt2d %zmm8, %zmm0, %zmm11
; AVX512-NEXT:    vmovdqa32 %zmm11, %zmm4 {%k2}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm24 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm3, %zmm24 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512-NEXT:    vpermt2d %zmm27, %zmm0, %zmm11
; AVX512-NEXT:    vmovdqa32 %zmm11, %zmm24 {%k2}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm18 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm20, %zmm18 {%k1}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm13 = [0,0,2,18,0,0,0,0,0,3,19,0,0,0,0,0]
; AVX512-NEXT:    vpermi2d %zmm2, %zmm1, %zmm13
; AVX512-NEXT:    vpermt2d %zmm10, %zmm0, %zmm13
; AVX512-NEXT:    vmovdqa32 %zmm13, %zmm18 {%k2}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,1,2,3,4,23,0,0,8,9,10,11,24,0,0,15]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm16, %zmm3
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,1,2,25,0,0,6,7,8,9,26,0,0,13,14,15]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm14, %zmm11
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm13 = [0,27,0,0,4,5,6,7,28,0,0,11,12,13,14,29]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512-NEXT:    vpermi2d %zmm1, %zmm14, %zmm13
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,0,2,3,4,5,30,0,0,9,10,11,12,31,0,0]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm15, %zmm14
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm15, %zmm0 {%k1}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm15 = [0,1,20,0,0,0,0,7,8,21,0,0,0,0,14,15]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm16 # 64-byte Reload
; AVX512-NEXT:    vpermt2d %zmm28, %zmm15, %zmm16
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm28 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm21, %zmm28 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm21, %zmm23 {%k1}
; AVX512-NEXT:    vmovdqa32 %zmm29, %zmm12 {%k1}
; AVX512-NEXT:    movw $15480, %ax # imm = 0x3C78
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovdqa32 %zmm0, %zmm16 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512-NEXT:    vpermt2d %zmm8, %zmm15, %zmm21
; AVX512-NEXT:    vmovdqa32 %zmm28, %zmm21 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512-NEXT:    vpermt2d %zmm27, %zmm15, %zmm8
; AVX512-NEXT:    vmovdqa32 %zmm23, %zmm8 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm8, %zmm20
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [4,20,0,0,0,0,0,5,21,0,0,0,0,0,6,22]
; AVX512-NEXT:    vpermt2d %zmm2, %zmm8, %zmm1
; AVX512-NEXT:    vpermt2d %zmm10, %zmm15, %zmm1
; AVX512-NEXT:    vmovdqa32 %zmm12, %zmm1 {%k1}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,1,2,3,4,5,23,0,8,9,10,11,12,24,0,15]
; AVX512-NEXT:    vpermi2d %zmm2, %zmm3, %zmm8
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,3,25,0,6,7,8,9,10,26,0,13,14,15]
; AVX512-NEXT:    vpermi2d %zmm2, %zmm11, %zmm0
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,1,27,0,4,5,6,7,8,28,0,11,12,13,14,15]
; AVX512-NEXT:    vpermi2d %zmm2, %zmm13, %zmm11
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [29,0,2,3,4,5,6,30,0,9,10,11,12,13,31,0]
; AVX512-NEXT:    vpermi2d %zmm2, %zmm14, %zmm12
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [22,1,2,3,4,5,6,23,8,9,10,11,12,13,24,15]
; AVX512-NEXT:    vpermi2d %zmm10, %zmm8, %zmm2
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,1,2,3,4,25,6,7,8,9,10,11,26,13,14,15]
; AVX512-NEXT:    vpermi2d %zmm10, %zmm0, %zmm8
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,27,4,5,6,7,8,9,28,11,12,13,14,15]
; AVX512-NEXT:    vpermi2d %zmm10, %zmm11, %zmm0
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,29,2,3,4,5,6,7,30,9,10,11,12,13,14,31]
; AVX512-NEXT:    vpermi2d %zmm10, %zmm12, %zmm11
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqa64 %zmm1, 1472(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm18, 1408(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm9, 1344(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm17, 1280(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm30, 1216(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm6, 1152(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm7, 1088(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm20, 1024(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm24, 960(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm19, 896(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm5, 832(%rax)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm1, 768(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm25, 704(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm26, 640(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm21, 576(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm4, 512(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm31, 448(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm22, 384(%rax)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm1, 320(%rax)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm1, 256(%rax)
; AVX512-NEXT:    vmovups (%rsp), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm1, 192(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm16, 128(%rax)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm1, 64(%rax)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm1, (%rax)
; AVX512-NEXT:    vmovdqa64 %zmm11, 1728(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm0, 1664(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm8, 1600(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm2, 1536(%rax)
; AVX512-NEXT:    addq $3080, %rsp # imm = 0xC08
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i32_stride7_vf64:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    subq $3080, %rsp # imm = 0xC08
; AVX512-FCP-NEXT:    vmovdqa64 (%rdx), %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 (%rcx), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 (%r8), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 64(%r8), %zmm25
; AVX512-FCP-NEXT:    vmovdqa64 128(%r8), %zmm22
; AVX512-FCP-NEXT:    vmovdqa64 (%r9), %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 64(%r9), %zmm5
; AVX512-FCP-NEXT:    vmovdqa64 128(%r9), %zmm4
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,16,0,0,0,0,0,1,17,0,0,0,0,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, %zmm7
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm1, %zmm7
; AVX512-FCP-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm8
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512-FCP-NEXT:    vpermt2d %zmm6, %zmm1, %zmm7
; AVX512-FCP-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm10
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [2,18,0,0,0,0,0,3,19,0,0,0,0,0,4,20]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm7, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm9
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,2,18,0,0,0,0,0,3,19,0,0,0,0,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512-FCP-NEXT:    vpermt2d %zmm6, %zmm1, %zmm7
; AVX512-FCP-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm11
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [4,20,0,0,0,0,0,5,21,0,0,0,0,0,6,22]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512-FCP-NEXT:    vpermt2d %zmm6, %zmm1, %zmm7
; AVX512-FCP-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,0,0,7,23,0,0,0,0,0,8,24,0,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm12
; AVX512-FCP-NEXT:    vpermt2d %zmm6, %zmm1, %zmm12
; AVX512-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm12
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,9,25,0,0,0,0,0,10,26,0,0,0,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm13
; AVX512-FCP-NEXT:    vpermt2d %zmm6, %zmm1, %zmm13
; AVX512-FCP-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm13
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,11,27,0,0,0,0,0,12,28,0,0,0,0,0,13]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm14
; AVX512-FCP-NEXT:    vpermt2d %zmm6, %zmm1, %zmm14
; AVX512-FCP-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm14
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [13,0,0,0,0,0,30,14,0,0,0,0,0,31,15,0]
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm1, %zmm6
; AVX512-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512-FCP-NEXT:    vpermt2d %zmm5, %zmm10, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512-FCP-NEXT:    vpermt2d %zmm5, %zmm11, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512-FCP-NEXT:    vpermt2d %zmm5, %zmm7, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512-FCP-NEXT:    vpermt2d %zmm5, %zmm12, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512-FCP-NEXT:    vpermt2d %zmm5, %zmm13, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512-FCP-NEXT:    vpermt2d %zmm5, %zmm14, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2d %zmm25, %zmm1, %zmm5
; AVX512-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm22, %zmm0
; AVX512-FCP-NEXT:    vpermt2d %zmm4, %zmm10, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm22, %zmm0
; AVX512-FCP-NEXT:    vpermt2d %zmm4, %zmm11, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm22, %zmm0
; AVX512-FCP-NEXT:    vpermt2d %zmm4, %zmm7, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermi2d %zmm4, %zmm22, %zmm12
; AVX512-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermi2d %zmm4, %zmm22, %zmm13
; AVX512-FCP-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermi2d %zmm4, %zmm22, %zmm14
; AVX512-FCP-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2d %zmm22, %zmm1, %zmm4
; AVX512-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,5,21,0,0,0,0,0,6,22,0,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm0, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,7,23,0,0,0,0,0,8,24,0,0,0,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm11, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm30 = [0,9,25,0,0,0,0,0,10,26,0,0,0,0,0,11]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm30, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [11,0,0,0,0,0,28,12,0,0,0,0,0,29,13,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm1
; AVX512-FCP-NEXT:    vpermt2d %zmm3, %zmm4, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,0,14,30,0,0,0,0,0,15,31,0,0,0]
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm1, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm24
; AVX512-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 %zmm24, %zmm3
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm8, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm24, %zmm3
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm9, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm24, %zmm3
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm0, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm24, %zmm3
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm11, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm24, %zmm3
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm30, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm3
; AVX512-FCP-NEXT:    vpermt2d %zmm24, %zmm4, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm1, %zmm24
; AVX512-FCP-NEXT:    vmovdqa64 192(%rdx), %zmm29
; AVX512-FCP-NEXT:    vmovdqa64 192(%rcx), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 %zmm29, %zmm28
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm11, %zmm28
; AVX512-FCP-NEXT:    vmovdqa64 %zmm29, %zmm3
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm30, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm3
; AVX512-FCP-NEXT:    vpermt2d %zmm29, %zmm4, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm29, %zmm3
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm1, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 128(%rdx), %zmm21
; AVX512-FCP-NEXT:    vmovdqa64 128(%rcx), %zmm3
; AVX512-FCP-NEXT:    vpermi2d %zmm3, %zmm21, %zmm11
; AVX512-FCP-NEXT:    vpermi2d %zmm3, %zmm21, %zmm30
; AVX512-FCP-NEXT:    vpermi2d %zmm21, %zmm3, %zmm4
; AVX512-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm21, %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 %zmm21, %zmm5
; AVX512-FCP-NEXT:    vmovdqa64 %zmm21, %zmm4
; AVX512-FCP-NEXT:    vpermt2d %zmm3, %zmm1, %zmm21
; AVX512-FCP-NEXT:    vpermt2d %zmm3, %zmm8, %zmm6
; AVX512-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2d %zmm3, %zmm9, %zmm5
; AVX512-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2d %zmm3, %zmm0, %zmm4
; AVX512-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermi2d %zmm2, %zmm29, %zmm8
; AVX512-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermi2d %zmm2, %zmm29, %zmm9
; AVX512-FCP-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm0, %zmm29
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm22
; AVX512-FCP-NEXT:    vmovdqa64 (%rsi), %zmm0
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,16,0,0,0,0,0,1,17,0,0,0,0,0,2,18]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm22, %zmm1
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm9, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,0,0,0,0,3,19,0,0,0,0,0,4,20,0,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm22, %zmm1
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm20, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm27 = [0,0,0,5,21,0,0,0,0,0,6,22,0,0,0,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm22, %zmm1
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm27, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,7,23,0,0,0,0,0,8,24,0,0,0,0,0,9]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm22, %zmm1
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm7, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, (%rsp) # 64-byte Spill
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [9,0,0,0,0,0,26,10,0,0,0,0,0,27,11,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm3
; AVX512-FCP-NEXT:    vpermt2d %zmm22, %zmm6, %zmm3
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,0,12,28,0,0,0,0,0,13,29,0,0,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm22, %zmm18
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm1, %zmm18
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,0,14,30,0,0,0,0,0,15,31,0,0,0,0,0]
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm8, %zmm22
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm5
; AVX512-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, %zmm31
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm9, %zmm31
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, %zmm2
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm20, %zmm2
; AVX512-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, %zmm2
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm27, %zmm2
; AVX512-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, %zmm26
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm7, %zmm26
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm25
; AVX512-FCP-NEXT:    vpermt2d %zmm5, %zmm6, %zmm25
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm1, %zmm10
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm8, %zmm5
; AVX512-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm12
; AVX512-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm13
; AVX512-FCP-NEXT:    vmovdqa64 %zmm12, %zmm16
; AVX512-FCP-NEXT:    vpermt2d %zmm13, %zmm7, %zmm16
; AVX512-FCP-NEXT:    vmovdqa64 %zmm13, %zmm14
; AVX512-FCP-NEXT:    vpermt2d %zmm12, %zmm6, %zmm14
; AVX512-FCP-NEXT:    vmovdqa64 %zmm12, %zmm2
; AVX512-FCP-NEXT:    vpermt2d %zmm13, %zmm1, %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 %zmm12, %zmm15
; AVX512-FCP-NEXT:    vpermt2d %zmm13, %zmm8, %zmm15
; AVX512-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm17
; AVX512-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm0
; AVX512-FCP-NEXT:    vpermi2d %zmm0, %zmm17, %zmm7
; AVX512-FCP-NEXT:    vpermi2d %zmm17, %zmm0, %zmm6
; AVX512-FCP-NEXT:    vpermi2d %zmm0, %zmm17, %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 %zmm17, %zmm19
; AVX512-FCP-NEXT:    vmovdqa64 %zmm17, %zmm4
; AVX512-FCP-NEXT:    vmovdqa64 %zmm17, %zmm23
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm8, %zmm17
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm9, %zmm19
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm20, %zmm4
; AVX512-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm27, %zmm23
; AVX512-FCP-NEXT:    vpermi2d %zmm13, %zmm12, %zmm9
; AVX512-FCP-NEXT:    vpermi2d %zmm13, %zmm12, %zmm20
; AVX512-FCP-NEXT:    vpermt2d %zmm13, %zmm27, %zmm12
; AVX512-FCP-NEXT:    movw $3096, %ax # imm = 0xC18
; AVX512-FCP-NEXT:    kmovw %eax, %k1
; AVX512-FCP-NEXT:    vmovdqa32 %zmm28, %zmm16 {%k1}
; AVX512-FCP-NEXT:    movw $-31994, %ax # imm = 0x8306
; AVX512-FCP-NEXT:    kmovw %eax, %k2
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm0, %zmm14 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 (%rsp), %zmm13 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm0, %zmm13 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm0, %zmm26 {%k1}
; AVX512-FCP-NEXT:    vmovdqa32 %zmm11, %zmm7 {%k1}
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-FCP-NEXT:    vmovdqa64 (%rax), %zmm28
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [22,0,0,0,0,5,6,23,0,0,0,0,12,13,24,0]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2d %zmm28, %zmm0, %zmm8
; AVX512-FCP-NEXT:    movw $28897, %cx # imm = 0x70E1
; AVX512-FCP-NEXT:    kmovw %ecx, %k1
; AVX512-FCP-NEXT:    vmovdqa32 %zmm8, %zmm13 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 %zmm13, (%rsp) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 64(%rax), %zmm8
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2d %zmm8, %zmm0, %zmm11
; AVX512-FCP-NEXT:    vmovdqa32 %zmm11, %zmm26 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 128(%rax), %zmm27
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2d %zmm27, %zmm0, %zmm11
; AVX512-FCP-NEXT:    vmovdqa32 %zmm11, %zmm7 {%k1}
; AVX512-FCP-NEXT:    movw $6192, %cx # imm = 0x1830
; AVX512-FCP-NEXT:    kmovw %ecx, %k1
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm0, %zmm15 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm0, %zmm25 {%k2}
; AVX512-FCP-NEXT:    vmovdqa32 %zmm30, %zmm6 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,3,4,25,0,0,0,0,10,11,26,0,0,0]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2d %zmm28, %zmm0, %zmm2
; AVX512-FCP-NEXT:    movw $7224, %cx # imm = 0x1C38
; AVX512-FCP-NEXT:    kmovw %ecx, %k2
; AVX512-FCP-NEXT:    vmovdqa32 %zmm2, %zmm3 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm18, %zmm11 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2d %zmm8, %zmm0, %zmm2
; AVX512-FCP-NEXT:    vmovdqa32 %zmm2, %zmm25 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2d %zmm27, %zmm0, %zmm2
; AVX512-FCP-NEXT:    vmovdqa32 %zmm2, %zmm6 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,27,0,0,0,0,8,9,28,0,0,0,0,15]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2d %zmm28, %zmm0, %zmm2
; AVX512-FCP-NEXT:    movw $-30962, %cx # imm = 0x870E
; AVX512-FCP-NEXT:    kmovw %ecx, %k2
; AVX512-FCP-NEXT:    vmovdqa32 %zmm2, %zmm11 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm10, %zmm11 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2d %zmm8, %zmm0, %zmm2
; AVX512-FCP-NEXT:    vmovdqa32 %zmm2, %zmm11 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm30 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm1, %zmm30 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2d %zmm27, %zmm0, %zmm1
; AVX512-FCP-NEXT:    vmovdqa32 %zmm1, %zmm30 {%k2}
; AVX512-FCP-NEXT:    movw $1548, %cx # imm = 0x60C
; AVX512-FCP-NEXT:    kmovw %ecx, %k2
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm0, %zmm2 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm0, %zmm22 {%k1}
; AVX512-FCP-NEXT:    vmovdqa32 %zmm24, %zmm5 {%k1}
; AVX512-FCP-NEXT:    vmovdqa32 %zmm21, %zmm17 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,29,0,0,0,0,6,7,30,0,0,0,0,13,14,31]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2d %zmm28, %zmm0, %zmm1
; AVX512-FCP-NEXT:    movw $-7741, %cx # imm = 0xE1C3
; AVX512-FCP-NEXT:    kmovw %ecx, %k1
; AVX512-FCP-NEXT:    vmovdqa32 %zmm1, %zmm22 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2d %zmm8, %zmm0, %zmm1
; AVX512-FCP-NEXT:    vmovdqa32 %zmm1, %zmm5 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2d %zmm27, %zmm0, %zmm1
; AVX512-FCP-NEXT:    vmovdqa32 %zmm1, %zmm17 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,4,5,16,0,0,0,0,11,12,17,0,0]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2d %zmm28, %zmm0, %zmm1
; AVX512-FCP-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512-FCP-NEXT:    kmovw %ecx, %k3
; AVX512-FCP-NEXT:    vmovdqa32 %zmm1, %zmm2 {%k3}
; AVX512-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm1, %zmm31 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm1, %zmm19 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm1, %zmm9 {%k2}
; AVX512-FCP-NEXT:    movw $12384, %cx # imm = 0x3060
; AVX512-FCP-NEXT:    kmovw %ecx, %k1
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm1, %zmm3 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2d %zmm8, %zmm0, %zmm1
; AVX512-FCP-NEXT:    vmovdqa32 %zmm1, %zmm31 {%k3}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2d %zmm27, %zmm0, %zmm1
; AVX512-FCP-NEXT:    vmovdqa32 %zmm1, %zmm19 {%k3}
; AVX512-FCP-NEXT:    vmovdqa64 192(%r8), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 192(%r9), %zmm2
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm11
; AVX512-FCP-NEXT:    vmovdqa64 192(%rax), %zmm10
; AVX512-FCP-NEXT:    vpermt2d %zmm10, %zmm0, %zmm11
; AVX512-FCP-NEXT:    vmovdqa32 %zmm11, %zmm9 {%k3}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,3,18,0,0,0,0,9,10,19,0,0,0,0]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2d %zmm28, %zmm0, %zmm11
; AVX512-FCP-NEXT:    movw $3612, %ax # imm = 0xE1C
; AVX512-FCP-NEXT:    kmovw %eax, %k2
; AVX512-FCP-NEXT:    vmovdqa32 %zmm11, %zmm3 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm11, %zmm4 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2d %zmm8, %zmm0, %zmm11
; AVX512-FCP-NEXT:    vmovdqa32 %zmm11, %zmm4 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm24 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm3, %zmm24 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2d %zmm27, %zmm0, %zmm11
; AVX512-FCP-NEXT:    vmovdqa32 %zmm11, %zmm24 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm18 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm20, %zmm18 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm13 = [0,0,2,18,0,0,0,0,0,3,19,0,0,0,0,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm13
; AVX512-FCP-NEXT:    vpermt2d %zmm10, %zmm0, %zmm13
; AVX512-FCP-NEXT:    vmovdqa32 %zmm13, %zmm18 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,1,2,3,4,23,0,0,8,9,10,11,24,0,0,15]
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm16, %zmm3
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,1,2,25,0,0,6,7,8,9,26,0,0,13,14,15]
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm14, %zmm11
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm13 = [0,27,0,0,4,5,6,7,28,0,0,11,12,13,14,29]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm14, %zmm13
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,0,2,3,4,5,30,0,0,9,10,11,12,31,0,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm15, %zmm14
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm15, %zmm0 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm15 = [0,1,20,0,0,0,0,7,8,21,0,0,0,0,14,15]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm16 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2d %zmm28, %zmm15, %zmm16
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm28 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm21, %zmm28 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm21, %zmm23 {%k1}
; AVX512-FCP-NEXT:    vmovdqa32 %zmm29, %zmm12 {%k1}
; AVX512-FCP-NEXT:    movw $15480, %ax # imm = 0x3C78
; AVX512-FCP-NEXT:    kmovw %eax, %k1
; AVX512-FCP-NEXT:    vmovdqa32 %zmm0, %zmm16 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2d %zmm8, %zmm15, %zmm21
; AVX512-FCP-NEXT:    vmovdqa32 %zmm28, %zmm21 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2d %zmm27, %zmm15, %zmm8
; AVX512-FCP-NEXT:    vmovdqa32 %zmm23, %zmm8 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, %zmm20
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [4,20,0,0,0,0,0,5,21,0,0,0,0,0,6,22]
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm8, %zmm1
; AVX512-FCP-NEXT:    vpermt2d %zmm10, %zmm15, %zmm1
; AVX512-FCP-NEXT:    vmovdqa32 %zmm12, %zmm1 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,1,2,3,4,5,23,0,8,9,10,11,12,24,0,15]
; AVX512-FCP-NEXT:    vpermi2d %zmm2, %zmm3, %zmm8
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,3,25,0,6,7,8,9,10,26,0,13,14,15]
; AVX512-FCP-NEXT:    vpermi2d %zmm2, %zmm11, %zmm0
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,1,27,0,4,5,6,7,8,28,0,11,12,13,14,15]
; AVX512-FCP-NEXT:    vpermi2d %zmm2, %zmm13, %zmm11
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [29,0,2,3,4,5,6,30,0,9,10,11,12,13,31,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm2, %zmm14, %zmm12
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [22,1,2,3,4,5,6,23,8,9,10,11,12,13,24,15]
; AVX512-FCP-NEXT:    vpermi2d %zmm10, %zmm8, %zmm2
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,1,2,3,4,25,6,7,8,9,10,11,26,13,14,15]
; AVX512-FCP-NEXT:    vpermi2d %zmm10, %zmm0, %zmm8
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,27,4,5,6,7,8,9,28,11,12,13,14,15]
; AVX512-FCP-NEXT:    vpermi2d %zmm10, %zmm11, %zmm0
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,29,2,3,4,5,6,7,30,9,10,11,12,13,14,31]
; AVX512-FCP-NEXT:    vpermi2d %zmm10, %zmm12, %zmm11
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, 1472(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, 1408(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, 1344(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm17, 1280(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm30, 1216(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, 1152(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, 1088(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm20, 1024(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm24, 960(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm19, 896(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, 832(%rax)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm1, 768(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm25, 704(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm26, 640(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm21, 576(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, 512(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm31, 448(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm22, 384(%rax)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm1, 320(%rax)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm1, 256(%rax)
; AVX512-FCP-NEXT:    vmovups (%rsp), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm1, 192(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm16, 128(%rax)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm1, 64(%rax)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm1, (%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm11, 1728(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, 1664(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, 1600(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, 1536(%rax)
; AVX512-FCP-NEXT:    addq $3080, %rsp # imm = 0xC08
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i32_stride7_vf64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    subq $3080, %rsp # imm = 0xC08
; AVX512DQ-NEXT:    vmovdqa64 (%rdx), %zmm3
; AVX512DQ-NEXT:    vmovdqa64 (%rcx), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 (%r8), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 64(%r8), %zmm25
; AVX512DQ-NEXT:    vmovdqa64 128(%r8), %zmm22
; AVX512DQ-NEXT:    vmovdqa64 (%r9), %zmm6
; AVX512DQ-NEXT:    vmovdqa64 64(%r9), %zmm5
; AVX512DQ-NEXT:    vmovdqa64 128(%r9), %zmm4
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,16,0,0,0,0,0,1,17,0,0,0,0,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, %zmm7
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm1, %zmm7
; AVX512DQ-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm8
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512DQ-NEXT:    vpermt2d %zmm6, %zmm1, %zmm7
; AVX512DQ-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm10
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [2,18,0,0,0,0,0,3,19,0,0,0,0,0,4,20]
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm7, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm9
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,2,18,0,0,0,0,0,3,19,0,0,0,0,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512DQ-NEXT:    vpermt2d %zmm6, %zmm1, %zmm7
; AVX512DQ-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm11
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [4,20,0,0,0,0,0,5,21,0,0,0,0,0,6,22]
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512DQ-NEXT:    vpermt2d %zmm6, %zmm1, %zmm7
; AVX512DQ-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,0,0,7,23,0,0,0,0,0,8,24,0,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm12
; AVX512DQ-NEXT:    vpermt2d %zmm6, %zmm1, %zmm12
; AVX512DQ-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm12
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,9,25,0,0,0,0,0,10,26,0,0,0,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm13
; AVX512DQ-NEXT:    vpermt2d %zmm6, %zmm1, %zmm13
; AVX512DQ-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm13
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,11,27,0,0,0,0,0,12,28,0,0,0,0,0,13]
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm14
; AVX512DQ-NEXT:    vpermt2d %zmm6, %zmm1, %zmm14
; AVX512DQ-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm14
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [13,0,0,0,0,0,30,14,0,0,0,0,0,31,15,0]
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm1, %zmm6
; AVX512DQ-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512DQ-NEXT:    vpermt2d %zmm5, %zmm10, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512DQ-NEXT:    vpermt2d %zmm5, %zmm11, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512DQ-NEXT:    vpermt2d %zmm5, %zmm7, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512DQ-NEXT:    vpermt2d %zmm5, %zmm12, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512DQ-NEXT:    vpermt2d %zmm5, %zmm13, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512DQ-NEXT:    vpermt2d %zmm5, %zmm14, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2d %zmm25, %zmm1, %zmm5
; AVX512DQ-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm22, %zmm0
; AVX512DQ-NEXT:    vpermt2d %zmm4, %zmm10, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm22, %zmm0
; AVX512DQ-NEXT:    vpermt2d %zmm4, %zmm11, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm22, %zmm0
; AVX512DQ-NEXT:    vpermt2d %zmm4, %zmm7, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermi2d %zmm4, %zmm22, %zmm12
; AVX512DQ-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermi2d %zmm4, %zmm22, %zmm13
; AVX512DQ-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermi2d %zmm4, %zmm22, %zmm14
; AVX512DQ-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2d %zmm22, %zmm1, %zmm4
; AVX512DQ-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,5,21,0,0,0,0,0,6,22,0,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm0, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,7,23,0,0,0,0,0,8,24,0,0,0,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm11, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm30 = [0,9,25,0,0,0,0,0,10,26,0,0,0,0,0,11]
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm30, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [11,0,0,0,0,0,28,12,0,0,0,0,0,29,13,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm1
; AVX512DQ-NEXT:    vpermt2d %zmm3, %zmm4, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,0,14,30,0,0,0,0,0,15,31,0,0,0]
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm1, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 64(%rdx), %zmm24
; AVX512DQ-NEXT:    vmovdqa64 64(%rcx), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 %zmm24, %zmm3
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm8, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm24, %zmm3
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm9, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm24, %zmm3
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm0, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm24, %zmm3
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm11, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm24, %zmm3
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm30, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm3
; AVX512DQ-NEXT:    vpermt2d %zmm24, %zmm4, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm1, %zmm24
; AVX512DQ-NEXT:    vmovdqa64 192(%rdx), %zmm29
; AVX512DQ-NEXT:    vmovdqa64 192(%rcx), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 %zmm29, %zmm28
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm11, %zmm28
; AVX512DQ-NEXT:    vmovdqa64 %zmm29, %zmm3
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm30, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm3
; AVX512DQ-NEXT:    vpermt2d %zmm29, %zmm4, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm29, %zmm3
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm1, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 128(%rdx), %zmm21
; AVX512DQ-NEXT:    vmovdqa64 128(%rcx), %zmm3
; AVX512DQ-NEXT:    vpermi2d %zmm3, %zmm21, %zmm11
; AVX512DQ-NEXT:    vpermi2d %zmm3, %zmm21, %zmm30
; AVX512DQ-NEXT:    vpermi2d %zmm21, %zmm3, %zmm4
; AVX512DQ-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm21, %zmm6
; AVX512DQ-NEXT:    vmovdqa64 %zmm21, %zmm5
; AVX512DQ-NEXT:    vmovdqa64 %zmm21, %zmm4
; AVX512DQ-NEXT:    vpermt2d %zmm3, %zmm1, %zmm21
; AVX512DQ-NEXT:    vpermt2d %zmm3, %zmm8, %zmm6
; AVX512DQ-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2d %zmm3, %zmm9, %zmm5
; AVX512DQ-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2d %zmm3, %zmm0, %zmm4
; AVX512DQ-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermi2d %zmm2, %zmm29, %zmm8
; AVX512DQ-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermi2d %zmm2, %zmm29, %zmm9
; AVX512DQ-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm0, %zmm29
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm22
; AVX512DQ-NEXT:    vmovdqa64 (%rsi), %zmm0
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,16,0,0,0,0,0,1,17,0,0,0,0,0,2,18]
; AVX512DQ-NEXT:    vmovdqa64 %zmm22, %zmm1
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm9, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,0,0,0,0,3,19,0,0,0,0,0,4,20,0,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm22, %zmm1
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm20, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm27 = [0,0,0,5,21,0,0,0,0,0,6,22,0,0,0,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm22, %zmm1
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm27, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,7,23,0,0,0,0,0,8,24,0,0,0,0,0,9]
; AVX512DQ-NEXT:    vmovdqa64 %zmm22, %zmm1
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm7, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, (%rsp) # 64-byte Spill
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [9,0,0,0,0,0,26,10,0,0,0,0,0,27,11,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm3
; AVX512DQ-NEXT:    vpermt2d %zmm22, %zmm6, %zmm3
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,0,12,28,0,0,0,0,0,13,29,0,0,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm22, %zmm18
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm1, %zmm18
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,0,14,30,0,0,0,0,0,15,31,0,0,0,0,0]
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm8, %zmm22
; AVX512DQ-NEXT:    vmovdqa64 64(%rdi), %zmm5
; AVX512DQ-NEXT:    vmovdqa64 64(%rsi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, %zmm31
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm9, %zmm31
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, %zmm2
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm20, %zmm2
; AVX512DQ-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, %zmm2
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm27, %zmm2
; AVX512DQ-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, %zmm26
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm7, %zmm26
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm25
; AVX512DQ-NEXT:    vpermt2d %zmm5, %zmm6, %zmm25
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm1, %zmm10
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm8, %zmm5
; AVX512DQ-NEXT:    vmovdqa64 192(%rdi), %zmm12
; AVX512DQ-NEXT:    vmovdqa64 192(%rsi), %zmm13
; AVX512DQ-NEXT:    vmovdqa64 %zmm12, %zmm16
; AVX512DQ-NEXT:    vpermt2d %zmm13, %zmm7, %zmm16
; AVX512DQ-NEXT:    vmovdqa64 %zmm13, %zmm14
; AVX512DQ-NEXT:    vpermt2d %zmm12, %zmm6, %zmm14
; AVX512DQ-NEXT:    vmovdqa64 %zmm12, %zmm2
; AVX512DQ-NEXT:    vpermt2d %zmm13, %zmm1, %zmm2
; AVX512DQ-NEXT:    vmovdqa64 %zmm12, %zmm15
; AVX512DQ-NEXT:    vpermt2d %zmm13, %zmm8, %zmm15
; AVX512DQ-NEXT:    vmovdqa64 128(%rdi), %zmm17
; AVX512DQ-NEXT:    vmovdqa64 128(%rsi), %zmm0
; AVX512DQ-NEXT:    vpermi2d %zmm0, %zmm17, %zmm7
; AVX512DQ-NEXT:    vpermi2d %zmm17, %zmm0, %zmm6
; AVX512DQ-NEXT:    vpermi2d %zmm0, %zmm17, %zmm1
; AVX512DQ-NEXT:    vmovdqa64 %zmm17, %zmm19
; AVX512DQ-NEXT:    vmovdqa64 %zmm17, %zmm4
; AVX512DQ-NEXT:    vmovdqa64 %zmm17, %zmm23
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm8, %zmm17
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm9, %zmm19
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm20, %zmm4
; AVX512DQ-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm27, %zmm23
; AVX512DQ-NEXT:    vpermi2d %zmm13, %zmm12, %zmm9
; AVX512DQ-NEXT:    vpermi2d %zmm13, %zmm12, %zmm20
; AVX512DQ-NEXT:    vpermt2d %zmm13, %zmm27, %zmm12
; AVX512DQ-NEXT:    movw $3096, %ax # imm = 0xC18
; AVX512DQ-NEXT:    kmovw %eax, %k1
; AVX512DQ-NEXT:    vmovdqa32 %zmm28, %zmm16 {%k1}
; AVX512DQ-NEXT:    movw $-31994, %ax # imm = 0x8306
; AVX512DQ-NEXT:    kmovw %eax, %k2
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm0, %zmm14 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 (%rsp), %zmm13 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm0, %zmm13 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm0, %zmm26 {%k1}
; AVX512DQ-NEXT:    vmovdqa32 %zmm11, %zmm7 {%k1}
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-NEXT:    vmovdqa64 (%rax), %zmm28
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [22,0,0,0,0,5,6,23,0,0,0,0,12,13,24,0]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2d %zmm28, %zmm0, %zmm8
; AVX512DQ-NEXT:    movw $28897, %cx # imm = 0x70E1
; AVX512DQ-NEXT:    kmovw %ecx, %k1
; AVX512DQ-NEXT:    vmovdqa32 %zmm8, %zmm13 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 %zmm13, (%rsp) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 64(%rax), %zmm8
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2d %zmm8, %zmm0, %zmm11
; AVX512DQ-NEXT:    vmovdqa32 %zmm11, %zmm26 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 128(%rax), %zmm27
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2d %zmm27, %zmm0, %zmm11
; AVX512DQ-NEXT:    vmovdqa32 %zmm11, %zmm7 {%k1}
; AVX512DQ-NEXT:    movw $6192, %cx # imm = 0x1830
; AVX512DQ-NEXT:    kmovw %ecx, %k1
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm0, %zmm15 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm0, %zmm25 {%k2}
; AVX512DQ-NEXT:    vmovdqa32 %zmm30, %zmm6 {%k2}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,3,4,25,0,0,0,0,10,11,26,0,0,0]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2d %zmm28, %zmm0, %zmm2
; AVX512DQ-NEXT:    movw $7224, %cx # imm = 0x1C38
; AVX512DQ-NEXT:    kmovw %ecx, %k2
; AVX512DQ-NEXT:    vmovdqa32 %zmm2, %zmm3 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm18, %zmm11 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2d %zmm8, %zmm0, %zmm2
; AVX512DQ-NEXT:    vmovdqa32 %zmm2, %zmm25 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2d %zmm27, %zmm0, %zmm2
; AVX512DQ-NEXT:    vmovdqa32 %zmm2, %zmm6 {%k2}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,27,0,0,0,0,8,9,28,0,0,0,0,15]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2d %zmm28, %zmm0, %zmm2
; AVX512DQ-NEXT:    movw $-30962, %cx # imm = 0x870E
; AVX512DQ-NEXT:    kmovw %ecx, %k2
; AVX512DQ-NEXT:    vmovdqa32 %zmm2, %zmm11 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm10, %zmm11 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2d %zmm8, %zmm0, %zmm2
; AVX512DQ-NEXT:    vmovdqa32 %zmm2, %zmm11 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm30 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm1, %zmm30 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2d %zmm27, %zmm0, %zmm1
; AVX512DQ-NEXT:    vmovdqa32 %zmm1, %zmm30 {%k2}
; AVX512DQ-NEXT:    movw $1548, %cx # imm = 0x60C
; AVX512DQ-NEXT:    kmovw %ecx, %k2
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm0, %zmm2 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm0, %zmm22 {%k1}
; AVX512DQ-NEXT:    vmovdqa32 %zmm24, %zmm5 {%k1}
; AVX512DQ-NEXT:    vmovdqa32 %zmm21, %zmm17 {%k1}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,29,0,0,0,0,6,7,30,0,0,0,0,13,14,31]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2d %zmm28, %zmm0, %zmm1
; AVX512DQ-NEXT:    movw $-7741, %cx # imm = 0xE1C3
; AVX512DQ-NEXT:    kmovw %ecx, %k1
; AVX512DQ-NEXT:    vmovdqa32 %zmm1, %zmm22 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2d %zmm8, %zmm0, %zmm1
; AVX512DQ-NEXT:    vmovdqa32 %zmm1, %zmm5 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2d %zmm27, %zmm0, %zmm1
; AVX512DQ-NEXT:    vmovdqa32 %zmm1, %zmm17 {%k1}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,4,5,16,0,0,0,0,11,12,17,0,0]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2d %zmm28, %zmm0, %zmm1
; AVX512DQ-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512DQ-NEXT:    kmovw %ecx, %k3
; AVX512DQ-NEXT:    vmovdqa32 %zmm1, %zmm2 {%k3}
; AVX512DQ-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm1, %zmm31 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm1, %zmm19 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm1, %zmm9 {%k2}
; AVX512DQ-NEXT:    movw $12384, %cx # imm = 0x3060
; AVX512DQ-NEXT:    kmovw %ecx, %k1
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm1, %zmm3 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2d %zmm8, %zmm0, %zmm1
; AVX512DQ-NEXT:    vmovdqa32 %zmm1, %zmm31 {%k3}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2d %zmm27, %zmm0, %zmm1
; AVX512DQ-NEXT:    vmovdqa32 %zmm1, %zmm19 {%k3}
; AVX512DQ-NEXT:    vmovdqa64 192(%r8), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 192(%r9), %zmm2
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512DQ-NEXT:    vpermi2d %zmm2, %zmm1, %zmm11
; AVX512DQ-NEXT:    vmovdqa64 192(%rax), %zmm10
; AVX512DQ-NEXT:    vpermt2d %zmm10, %zmm0, %zmm11
; AVX512DQ-NEXT:    vmovdqa32 %zmm11, %zmm9 {%k3}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,3,18,0,0,0,0,9,10,19,0,0,0,0]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2d %zmm28, %zmm0, %zmm11
; AVX512DQ-NEXT:    movw $3612, %ax # imm = 0xE1C
; AVX512DQ-NEXT:    kmovw %eax, %k2
; AVX512DQ-NEXT:    vmovdqa32 %zmm11, %zmm3 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm11, %zmm4 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2d %zmm8, %zmm0, %zmm11
; AVX512DQ-NEXT:    vmovdqa32 %zmm11, %zmm4 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm24 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm3, %zmm24 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2d %zmm27, %zmm0, %zmm11
; AVX512DQ-NEXT:    vmovdqa32 %zmm11, %zmm24 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm18 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm20, %zmm18 {%k1}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm13 = [0,0,2,18,0,0,0,0,0,3,19,0,0,0,0,0]
; AVX512DQ-NEXT:    vpermi2d %zmm2, %zmm1, %zmm13
; AVX512DQ-NEXT:    vpermt2d %zmm10, %zmm0, %zmm13
; AVX512DQ-NEXT:    vmovdqa32 %zmm13, %zmm18 {%k2}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,1,2,3,4,23,0,0,8,9,10,11,24,0,0,15]
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm16, %zmm3
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,1,2,25,0,0,6,7,8,9,26,0,0,13,14,15]
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm14, %zmm11
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm13 = [0,27,0,0,4,5,6,7,28,0,0,11,12,13,14,29]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm14, %zmm13
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,0,2,3,4,5,30,0,0,9,10,11,12,31,0,0]
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm15, %zmm14
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm15, %zmm0 {%k1}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm15 = [0,1,20,0,0,0,0,7,8,21,0,0,0,0,14,15]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm16 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2d %zmm28, %zmm15, %zmm16
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm28 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm21, %zmm28 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm21, %zmm23 {%k1}
; AVX512DQ-NEXT:    vmovdqa32 %zmm29, %zmm12 {%k1}
; AVX512DQ-NEXT:    movw $15480, %ax # imm = 0x3C78
; AVX512DQ-NEXT:    kmovw %eax, %k1
; AVX512DQ-NEXT:    vmovdqa32 %zmm0, %zmm16 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2d %zmm8, %zmm15, %zmm21
; AVX512DQ-NEXT:    vmovdqa32 %zmm28, %zmm21 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2d %zmm27, %zmm15, %zmm8
; AVX512DQ-NEXT:    vmovdqa32 %zmm23, %zmm8 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, %zmm20
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [4,20,0,0,0,0,0,5,21,0,0,0,0,0,6,22]
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm8, %zmm1
; AVX512DQ-NEXT:    vpermt2d %zmm10, %zmm15, %zmm1
; AVX512DQ-NEXT:    vmovdqa32 %zmm12, %zmm1 {%k1}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,1,2,3,4,5,23,0,8,9,10,11,12,24,0,15]
; AVX512DQ-NEXT:    vpermi2d %zmm2, %zmm3, %zmm8
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,3,25,0,6,7,8,9,10,26,0,13,14,15]
; AVX512DQ-NEXT:    vpermi2d %zmm2, %zmm11, %zmm0
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,1,27,0,4,5,6,7,8,28,0,11,12,13,14,15]
; AVX512DQ-NEXT:    vpermi2d %zmm2, %zmm13, %zmm11
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [29,0,2,3,4,5,6,30,0,9,10,11,12,13,31,0]
; AVX512DQ-NEXT:    vpermi2d %zmm2, %zmm14, %zmm12
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [22,1,2,3,4,5,6,23,8,9,10,11,12,13,24,15]
; AVX512DQ-NEXT:    vpermi2d %zmm10, %zmm8, %zmm2
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,1,2,3,4,25,6,7,8,9,10,11,26,13,14,15]
; AVX512DQ-NEXT:    vpermi2d %zmm10, %zmm0, %zmm8
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,27,4,5,6,7,8,9,28,11,12,13,14,15]
; AVX512DQ-NEXT:    vpermi2d %zmm10, %zmm11, %zmm0
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,29,2,3,4,5,6,7,30,9,10,11,12,13,14,31]
; AVX512DQ-NEXT:    vpermi2d %zmm10, %zmm12, %zmm11
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, 1472(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, 1408(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, 1344(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm17, 1280(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm30, 1216(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, 1152(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, 1088(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm20, 1024(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm24, 960(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm19, 896(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, 832(%rax)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm1, 768(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm25, 704(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm26, 640(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm21, 576(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, 512(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm31, 448(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm22, 384(%rax)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm1, 320(%rax)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm1, 256(%rax)
; AVX512DQ-NEXT:    vmovups (%rsp), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm1, 192(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm16, 128(%rax)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm1, 64(%rax)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm1, (%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm11, 1728(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, 1664(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, 1600(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, 1536(%rax)
; AVX512DQ-NEXT:    addq $3080, %rsp # imm = 0xC08
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i32_stride7_vf64:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    subq $3080, %rsp # imm = 0xC08
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdx), %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rcx), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%r8), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%r8), %zmm25
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%r8), %zmm22
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%r9), %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%r9), %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%r9), %zmm4
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,16,0,0,0,0,0,1,17,0,0,0,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, %zmm7
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm1, %zmm7
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm8
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm6, %zmm1, %zmm7
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm10
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [2,18,0,0,0,0,0,3,19,0,0,0,0,0,4,20]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm7, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm9
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,2,18,0,0,0,0,0,3,19,0,0,0,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm6, %zmm1, %zmm7
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm11
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [4,20,0,0,0,0,0,5,21,0,0,0,0,0,6,22]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm6, %zmm1, %zmm7
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,0,0,7,23,0,0,0,0,0,8,24,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm12
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm6, %zmm1, %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm12
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,9,25,0,0,0,0,0,10,26,0,0,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm13
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm6, %zmm1, %zmm13
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm13
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,11,27,0,0,0,0,0,12,28,0,0,0,0,0,13]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm14
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm6, %zmm1, %zmm14
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm14
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [13,0,0,0,0,0,30,14,0,0,0,0,0,31,15,0]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm1, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm5, %zmm10, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm5, %zmm11, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm5, %zmm7, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm5, %zmm12, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm5, %zmm13, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm5, %zmm14, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm25, %zmm1, %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm22, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm4, %zmm10, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm22, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm4, %zmm11, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm22, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm4, %zmm7, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm4, %zmm22, %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm4, %zmm22, %zmm13
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm4, %zmm22, %zmm14
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm22, %zmm1, %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,5,21,0,0,0,0,0,6,22,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm0, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,7,23,0,0,0,0,0,8,24,0,0,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm11, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm30 = [0,9,25,0,0,0,0,0,10,26,0,0,0,0,0,11]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm30, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [11,0,0,0,0,0,28,12,0,0,0,0,0,29,13,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm3, %zmm4, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,0,14,30,0,0,0,0,0,15,31,0,0,0]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm1, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm24
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm24, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm8, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm24, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm9, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm24, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm0, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm24, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm11, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm24, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm30, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm24, %zmm4, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm1, %zmm24
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rdx), %zmm29
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rcx), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm29, %zmm28
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm11, %zmm28
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm29, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm30, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm29, %zmm4, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm29, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm1, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rdx), %zmm21
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rcx), %zmm3
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm3, %zmm21, %zmm11
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm3, %zmm21, %zmm30
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm21, %zmm3, %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm21, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm21, %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm21, %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm3, %zmm1, %zmm21
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm3, %zmm8, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm3, %zmm9, %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm3, %zmm0, %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm2, %zmm29, %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm2, %zmm29, %zmm9
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm0, %zmm29
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm22
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rsi), %zmm0
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,16,0,0,0,0,0,1,17,0,0,0,0,0,2,18]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm22, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm9, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,0,0,0,0,3,19,0,0,0,0,0,4,20,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm22, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm20, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm27 = [0,0,0,5,21,0,0,0,0,0,6,22,0,0,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm22, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm27, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,7,23,0,0,0,0,0,8,24,0,0,0,0,0,9]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm22, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm7, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, (%rsp) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [9,0,0,0,0,0,26,10,0,0,0,0,0,27,11,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm22, %zmm6, %zmm3
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,0,12,28,0,0,0,0,0,13,29,0,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm22, %zmm18
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm1, %zmm18
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,0,14,30,0,0,0,0,0,15,31,0,0,0,0,0]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm8, %zmm22
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, %zmm31
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm9, %zmm31
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, %zmm2
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm20, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, %zmm2
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm27, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, %zmm26
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm7, %zmm26
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm25
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm5, %zmm6, %zmm25
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm1, %zmm10
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm8, %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm13
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm12, %zmm16
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm13, %zmm7, %zmm16
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm13, %zmm14
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm12, %zmm6, %zmm14
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm12, %zmm2
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm13, %zmm1, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm12, %zmm15
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm13, %zmm8, %zmm15
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm17
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm0
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm0, %zmm17, %zmm7
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm17, %zmm0, %zmm6
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm0, %zmm17, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm17, %zmm19
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm17, %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm17, %zmm23
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm8, %zmm17
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm9, %zmm19
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm20, %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm27, %zmm23
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm13, %zmm12, %zmm9
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm13, %zmm12, %zmm20
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm13, %zmm27, %zmm12
; AVX512DQ-FCP-NEXT:    movw $3096, %ax # imm = 0xC18
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm28, %zmm16 {%k1}
; AVX512DQ-FCP-NEXT:    movw $-31994, %ax # imm = 0x8306
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k2
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm0, %zmm14 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 (%rsp), %zmm13 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm0, %zmm13 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm0, %zmm26 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm11, %zmm7 {%k1}
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rax), %zmm28
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [22,0,0,0,0,5,6,23,0,0,0,0,12,13,24,0]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm28, %zmm0, %zmm8
; AVX512DQ-FCP-NEXT:    movw $28897, %cx # imm = 0x70E1
; AVX512DQ-FCP-NEXT:    kmovw %ecx, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm8, %zmm13 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm13, (%rsp) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rax), %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm8, %zmm0, %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm11, %zmm26 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rax), %zmm27
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm27, %zmm0, %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm11, %zmm7 {%k1}
; AVX512DQ-FCP-NEXT:    movw $6192, %cx # imm = 0x1830
; AVX512DQ-FCP-NEXT:    kmovw %ecx, %k1
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm0, %zmm15 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm0, %zmm25 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm30, %zmm6 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,3,4,25,0,0,0,0,10,11,26,0,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm28, %zmm0, %zmm2
; AVX512DQ-FCP-NEXT:    movw $7224, %cx # imm = 0x1C38
; AVX512DQ-FCP-NEXT:    kmovw %ecx, %k2
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm2, %zmm3 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm18, %zmm11 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm8, %zmm0, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm2, %zmm25 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm27, %zmm0, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm2, %zmm6 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,27,0,0,0,0,8,9,28,0,0,0,0,15]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm28, %zmm0, %zmm2
; AVX512DQ-FCP-NEXT:    movw $-30962, %cx # imm = 0x870E
; AVX512DQ-FCP-NEXT:    kmovw %ecx, %k2
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm2, %zmm11 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm10, %zmm11 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm8, %zmm0, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm2, %zmm11 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm30 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm1, %zmm30 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm27, %zmm0, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm1, %zmm30 {%k2}
; AVX512DQ-FCP-NEXT:    movw $1548, %cx # imm = 0x60C
; AVX512DQ-FCP-NEXT:    kmovw %ecx, %k2
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm0, %zmm2 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm0, %zmm22 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm24, %zmm5 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm21, %zmm17 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,29,0,0,0,0,6,7,30,0,0,0,0,13,14,31]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm28, %zmm0, %zmm1
; AVX512DQ-FCP-NEXT:    movw $-7741, %cx # imm = 0xE1C3
; AVX512DQ-FCP-NEXT:    kmovw %ecx, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm1, %zmm22 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm8, %zmm0, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm1, %zmm5 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm27, %zmm0, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm1, %zmm17 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,4,5,16,0,0,0,0,11,12,17,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm28, %zmm0, %zmm1
; AVX512DQ-FCP-NEXT:    movw $14448, %cx # imm = 0x3870
; AVX512DQ-FCP-NEXT:    kmovw %ecx, %k3
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm1, %zmm2 {%k3}
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm1, %zmm31 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm1, %zmm19 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm1, %zmm9 {%k2}
; AVX512DQ-FCP-NEXT:    movw $12384, %cx # imm = 0x3060
; AVX512DQ-FCP-NEXT:    kmovw %ecx, %k1
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm1, %zmm3 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm8, %zmm0, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm1, %zmm31 {%k3}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm27, %zmm0, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm1, %zmm19 {%k3}
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%r8), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%r9), %zmm2
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rax), %zmm10
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm10, %zmm0, %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm11, %zmm9 {%k3}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,2,3,18,0,0,0,0,9,10,19,0,0,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm28, %zmm0, %zmm11
; AVX512DQ-FCP-NEXT:    movw $3612, %ax # imm = 0xE1C
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k2
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm11, %zmm3 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm11, %zmm4 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm8, %zmm0, %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm11, %zmm4 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm24 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm3, %zmm24 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm27, %zmm0, %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm11, %zmm24 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm18 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm20, %zmm18 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm13 = [0,0,2,18,0,0,0,0,0,3,19,0,0,0,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm2, %zmm1, %zmm13
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm10, %zmm0, %zmm13
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm13, %zmm18 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,1,2,3,4,23,0,0,8,9,10,11,24,0,0,15]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm16, %zmm3
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,1,2,25,0,0,6,7,8,9,26,0,0,13,14,15]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm14, %zmm11
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm13 = [0,27,0,0,4,5,6,7,28,0,0,11,12,13,14,29]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm14, %zmm13
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,0,2,3,4,5,30,0,0,9,10,11,12,31,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm15, %zmm14
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm15, %zmm0 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm15 = [0,1,20,0,0,0,0,7,8,21,0,0,0,0,14,15]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm16 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm28, %zmm15, %zmm16
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm28 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm21, %zmm28 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm21, %zmm23 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm29, %zmm12 {%k1}
; AVX512DQ-FCP-NEXT:    movw $15480, %ax # imm = 0x3C78
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm0, %zmm16 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm8, %zmm15, %zmm21
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm28, %zmm21 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm27, %zmm15, %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm23, %zmm8 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, %zmm20
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [4,20,0,0,0,0,0,5,21,0,0,0,0,0,6,22]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm8, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm10, %zmm15, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm12, %zmm1 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,1,2,3,4,5,23,0,8,9,10,11,12,24,0,15]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm2, %zmm3, %zmm8
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,3,25,0,6,7,8,9,10,26,0,13,14,15]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm2, %zmm11, %zmm0
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,1,27,0,4,5,6,7,8,28,0,11,12,13,14,15]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm2, %zmm13, %zmm11
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [29,0,2,3,4,5,6,30,0,9,10,11,12,13,31,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm2, %zmm14, %zmm12
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [22,1,2,3,4,5,6,23,8,9,10,11,12,13,24,15]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm10, %zmm8, %zmm2
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,1,2,3,4,25,6,7,8,9,10,11,26,13,14,15]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm10, %zmm0, %zmm8
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,27,4,5,6,7,8,9,28,11,12,13,14,15]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm10, %zmm11, %zmm0
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,29,2,3,4,5,6,7,30,9,10,11,12,13,14,31]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm10, %zmm12, %zmm11
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, 1472(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, 1408(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, 1344(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm17, 1280(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm30, 1216(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, 1152(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, 1088(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm20, 1024(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm24, 960(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm19, 896(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, 832(%rax)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm1, 768(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm25, 704(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm26, 640(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm21, 576(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, 512(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm31, 448(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm22, 384(%rax)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm1, 320(%rax)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm1, 256(%rax)
; AVX512DQ-FCP-NEXT:    vmovups (%rsp), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm1, 192(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm16, 128(%rax)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm1, 64(%rax)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm1, (%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm11, 1728(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, 1664(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, 1600(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, 1536(%rax)
; AVX512DQ-FCP-NEXT:    addq $3080, %rsp # imm = 0xC08
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride7_vf64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    subq $3080, %rsp # imm = 0xC08
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm3
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm2
; AVX512BW-NEXT:    vmovdqa64 (%r8), %zmm0
; AVX512BW-NEXT:    vmovdqa64 64(%r8), %zmm25
; AVX512BW-NEXT:    vmovdqa64 128(%r8), %zmm22
; AVX512BW-NEXT:    vmovdqa64 (%r9), %zmm6
; AVX512BW-NEXT:    vmovdqa64 64(%r9), %zmm5
; AVX512BW-NEXT:    vmovdqa64 128(%r9), %zmm4
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,16,0,0,0,0,0,1,17,0,0,0,0,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm7
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm1, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm8
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,0,0,16,0,0,0,0,0,1,17,0,0,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512BW-NEXT:    vpermt2d %zmm6, %zmm1, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm10
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [2,18,0,0,0,0,0,3,19,0,0,0,0,0,4,20]
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm7, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm9
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,2,18,0,0,0,0,0,3,19,0,0,0,0,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512BW-NEXT:    vpermt2d %zmm6, %zmm1, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm11
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [4,20,0,0,0,0,0,5,21,0,0,0,0,0,6,22]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512BW-NEXT:    vpermt2d %zmm6, %zmm1, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,0,0,7,23,0,0,0,0,0,8,24,0,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm12
; AVX512BW-NEXT:    vpermt2d %zmm6, %zmm1, %zmm12
; AVX512BW-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm12
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,9,25,0,0,0,0,0,10,26,0,0,0,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm13
; AVX512BW-NEXT:    vpermt2d %zmm6, %zmm1, %zmm13
; AVX512BW-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm13
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,11,27,0,0,0,0,0,12,28,0,0,0,0,0,13]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm14
; AVX512BW-NEXT:    vpermt2d %zmm6, %zmm1, %zmm14
; AVX512BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm14
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [13,0,0,0,0,0,30,14,0,0,0,0,0,31,15,0]
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm1, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm5, %zmm10, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm5, %zmm11, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm5, %zmm7, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm5, %zmm12, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm5, %zmm13, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm5, %zmm14, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2d %zmm25, %zmm1, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm22, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm4, %zmm10, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm22, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm4, %zmm11, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm22, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm4, %zmm7, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm4, %zmm22, %zmm12
; AVX512BW-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm4, %zmm22, %zmm13
; AVX512BW-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm4, %zmm22, %zmm14
; AVX512BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2d %zmm22, %zmm1, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,0,0,5,21,0,0,0,0,0,6,22,0,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm0, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [0,0,0,7,23,0,0,0,0,0,8,24,0,0,0,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm11, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm30 = [0,9,25,0,0,0,0,0,10,26,0,0,0,0,0,11]
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm30, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [11,0,0,0,0,0,28,12,0,0,0,0,0,29,13,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm1
; AVX512BW-NEXT:    vpermt2d %zmm3, %zmm4, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,0,14,30,0,0,0,0,0,15,31,0,0,0]
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm1, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 64(%rdx), %zmm24
; AVX512BW-NEXT:    vmovdqa64 64(%rcx), %zmm2
; AVX512BW-NEXT:    vmovdqa64 %zmm24, %zmm3
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm8, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm24, %zmm3
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm9, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm24, %zmm3
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm0, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm24, %zmm3
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm11, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm24, %zmm3
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm30, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm3
; AVX512BW-NEXT:    vpermt2d %zmm24, %zmm4, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm1, %zmm24
; AVX512BW-NEXT:    vmovdqa64 192(%rdx), %zmm29
; AVX512BW-NEXT:    vmovdqa64 192(%rcx), %zmm2
; AVX512BW-NEXT:    vmovdqa64 %zmm29, %zmm28
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm11, %zmm28
; AVX512BW-NEXT:    vmovdqa64 %zmm29, %zmm3
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm30, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm3
; AVX512BW-NEXT:    vpermt2d %zmm29, %zmm4, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm29, %zmm3
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm1, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 128(%rdx), %zmm21
; AVX512BW-NEXT:    vmovdqa64 128(%rcx), %zmm3
; AVX512BW-NEXT:    vpermi2d %zmm3, %zmm21, %zmm11
; AVX512BW-NEXT:    vpermi2d %zmm3, %zmm21, %zmm30
; AVX512BW-NEXT:    vpermi2d %zmm21, %zmm3, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm21, %zmm6
; AVX512BW-NEXT:    vmovdqa64 %zmm21, %zmm5
; AVX512BW-NEXT:    vmovdqa64 %zmm21, %zmm4
; AVX512BW-NEXT:    vpermt2d %zmm3, %zmm1, %zmm21
; AVX512BW-NEXT:    vpermt2d %zmm3, %zmm8, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2d %zmm3, %zmm9, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2d %zmm3, %zmm0, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm2, %zmm29, %zmm8
; AVX512BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm2, %zmm29, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm0, %zmm29
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm22
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm0
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,16,0,0,0,0,0,1,17,0,0,0,0,0,2,18]
; AVX512BW-NEXT:    vmovdqa64 %zmm22, %zmm1
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm9, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,0,0,0,0,3,19,0,0,0,0,0,4,20,0,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm22, %zmm1
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm20, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm27 = [0,0,0,5,21,0,0,0,0,0,6,22,0,0,0,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm22, %zmm1
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm27, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,7,23,0,0,0,0,0,8,24,0,0,0,0,0,9]
; AVX512BW-NEXT:    vmovdqa64 %zmm22, %zmm1
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm7, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, (%rsp) # 64-byte Spill
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [9,0,0,0,0,0,26,10,0,0,0,0,0,27,11,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm3
; AVX512BW-NEXT:    vpermt2d %zmm22, %zmm6, %zmm3
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,0,0,0,12,28,0,0,0,0,0,13,29,0,0,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm22, %zmm18
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm1, %zmm18
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,0,14,30,0,0,0,0,0,15,31,0,0,0,0,0]
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm8, %zmm22
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm5
; AVX512BW-NEXT:    vmovdqa64 64(%rsi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm31
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm9, %zmm31
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm2
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm20, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm2
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm27, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm26
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm7, %zmm26
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm25
; AVX512BW-NEXT:    vpermt2d %zmm5, %zmm6, %zmm25
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm1, %zmm10
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm8, %zmm5
; AVX512BW-NEXT:    vmovdqa64 192(%rdi), %zmm12
; AVX512BW-NEXT:    vmovdqa64 192(%rsi), %zmm13
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm16
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm7, %zmm16
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm14
; AVX512BW-NEXT:    vpermt2d %zmm12, %zmm6, %zmm14
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm2
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm1, %zmm2
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm15
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm8, %zmm15
; AVX512BW-NEXT:    vmovdqa64 128(%rdi), %zmm17
; AVX512BW-NEXT:    vmovdqa64 128(%rsi), %zmm0
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm17, %zmm7
; AVX512BW-NEXT:    vpermi2d %zmm17, %zmm0, %zmm6
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm17, %zmm1
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm19
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm4
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm23
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm8, %zmm17
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm9, %zmm19
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm20, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm27, %zmm23
; AVX512BW-NEXT:    vpermi2d %zmm13, %zmm12, %zmm9
; AVX512BW-NEXT:    vpermi2d %zmm13, %zmm12, %zmm20
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm27, %zmm12
; AVX512BW-NEXT:    movw $3096, %ax # imm = 0xC18
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqa32 %zmm28, %zmm16 {%k1}
; AVX512BW-NEXT:    movw $-31994, %ax # imm = 0x8306
; AVX512BW-NEXT:    kmovd %eax, %k2
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa32 %zmm0, %zmm14 {%k2}
; AVX512BW-NEXT:    vmovdqu64 (%rsp), %zmm13 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa32 %zmm0, %zmm13 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa32 %zmm0, %zmm26 {%k1}
; AVX512BW-NEXT:    vmovdqa32 %zmm11, %zmm7 {%k1}
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    vmovdqa64 (%rax), %zmm28
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [22,0,0,0,0,5,6,23,0,0,0,0,12,13,24,0]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2d %zmm28, %zmm0, %zmm8
; AVX512BW-NEXT:    movw $28897, %cx # imm = 0x70E1
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqa32 %zmm8, %zmm13 {%k1}
; AVX512BW-NEXT:    vmovdqu64 %zmm13, (%rsp) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 64(%rax), %zmm8
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2d %zmm8, %zmm0, %zmm11
; AVX512BW-NEXT:    vmovdqa32 %zmm11, %zmm26 {%k1}
; AVX512BW-NEXT:    vmovdqa64 128(%rax), %zmm27
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2d %zmm27, %zmm0, %zmm11
; AVX512BW-NEXT:    vmovdqa32 %zmm11, %zmm7 {%k1}
; AVX512BW-NEXT:    movw $6192, %cx # imm = 0x1830
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1}
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa32 %zmm0, %zmm15 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa32 %zmm0, %zmm25 {%k2}
; AVX512BW-NEXT:    vmovdqa32 %zmm30, %zmm6 {%k2}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,0,0,3,4,25,0,0,0,0,10,11,26,0,0,0]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2d %zmm28, %zmm0, %zmm2
; AVX512BW-NEXT:    movw $7224, %cx # imm = 0x1C38
; AVX512BW-NEXT:    kmovd %ecx, %k2
; AVX512BW-NEXT:    vmovdqa32 %zmm2, %zmm3 {%k2}
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa32 %zmm18, %zmm11 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2d %zmm8, %zmm0, %zmm2
; AVX512BW-NEXT:    vmovdqa32 %zmm2, %zmm25 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2d %zmm27, %zmm0, %zmm2
; AVX512BW-NEXT:    vmovdqa32 %zmm2, %zmm6 {%k2}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,27,0,0,0,0,8,9,28,0,0,0,0,15]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2d %zmm28, %zmm0, %zmm2
; AVX512BW-NEXT:    movw $-30962, %cx # imm = 0x870E
; AVX512BW-NEXT:    kmovd %ecx, %k2
; AVX512BW-NEXT:    vmovdqa32 %zmm2, %zmm11 {%k2}
; AVX512BW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}