; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-none-elf -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,SDISEL
; RUN: llc -mtriple=aarch64-none-elf -global-isel -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,GISEL

define i32 @and_eq_eq(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_eq_eq:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, eq
; SDISEL-NEXT:    cset w0, eq
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_eq_eq:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, eq
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, eq
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp eq i32 %s0, %s1
  %c1 = icmp eq i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_eq_ne(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_eq_ne:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #4, eq
; SDISEL-NEXT:    cset w0, ne
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_eq_ne:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, eq
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ne
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp eq i32 %s0, %s1
  %c1 = icmp ne i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_eq_ult(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_eq_ult:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #2, eq
; SDISEL-NEXT:    cset w0, lo
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_eq_ult:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, eq
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, lo
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp eq i32 %s0, %s1
  %c1 = icmp ult i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_eq_ule(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_eq_ule:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #2, eq
; SDISEL-NEXT:    cset w0, ls
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_eq_ule:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, eq
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ls
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp eq i32 %s0, %s1
  %c1 = icmp ule i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_eq_ugt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_eq_ugt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, eq
; SDISEL-NEXT:    cset w0, hi
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_eq_ugt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, eq
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, hi
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp eq i32 %s0, %s1
  %c1 = icmp ugt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_eq_uge(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_eq_uge:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, eq
; SDISEL-NEXT:    cset w0, hs
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_eq_uge:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, eq
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, hs
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp eq i32 %s0, %s1
  %c1 = icmp uge i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_eq_slt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_eq_slt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, eq
; SDISEL-NEXT:    cset w0, lt
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_eq_slt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, eq
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, lt
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp eq i32 %s0, %s1
  %c1 = icmp slt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_eq_sle(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_eq_sle:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, eq
; SDISEL-NEXT:    cset w0, le
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_eq_sle:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, eq
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, le
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp eq i32 %s0, %s1
  %c1 = icmp sle i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_eq_sgt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_eq_sgt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #4, eq
; SDISEL-NEXT:    cset w0, gt
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_eq_sgt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, eq
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, gt
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp eq i32 %s0, %s1
  %c1 = icmp sgt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_eq_sge(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_eq_sge:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #8, eq
; SDISEL-NEXT:    cset w0, ge
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_eq_sge:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, eq
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ge
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp eq i32 %s0, %s1
  %c1 = icmp sge i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ne_eq(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ne_eq:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, ne
; SDISEL-NEXT:    cset w0, eq
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ne_eq:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ne
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, eq
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ne i32 %s0, %s1
  %c1 = icmp eq i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ne_ne(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ne_ne:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #4, ne
; SDISEL-NEXT:    cset w0, ne
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ne_ne:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ne
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ne
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ne i32 %s0, %s1
  %c1 = icmp ne i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ne_ult(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ne_ult:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #2, ne
; SDISEL-NEXT:    cset w0, lo
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ne_ult:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ne
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, lo
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ne i32 %s0, %s1
  %c1 = icmp ult i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ne_ule(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ne_ule:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #2, ne
; SDISEL-NEXT:    cset w0, ls
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ne_ule:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ne
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ls
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ne i32 %s0, %s1
  %c1 = icmp ule i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ne_ugt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ne_ugt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, ne
; SDISEL-NEXT:    cset w0, hi
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ne_ugt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ne
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, hi
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ne i32 %s0, %s1
  %c1 = icmp ugt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ne_uge(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ne_uge:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, ne
; SDISEL-NEXT:    cset w0, hs
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ne_uge:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ne
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, hs
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ne i32 %s0, %s1
  %c1 = icmp uge i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ne_slt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ne_slt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, ne
; SDISEL-NEXT:    cset w0, lt
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ne_slt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ne
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, lt
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ne i32 %s0, %s1
  %c1 = icmp slt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ne_sle(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ne_sle:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, ne
; SDISEL-NEXT:    cset w0, le
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ne_sle:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ne
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, le
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ne i32 %s0, %s1
  %c1 = icmp sle i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ne_sgt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ne_sgt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #4, ne
; SDISEL-NEXT:    cset w0, gt
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ne_sgt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ne
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, gt
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ne i32 %s0, %s1
  %c1 = icmp sgt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ne_sge(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ne_sge:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #8, ne
; SDISEL-NEXT:    cset w0, ge
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ne_sge:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ne
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ge
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ne i32 %s0, %s1
  %c1 = icmp sge i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ult_eq(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ult_eq:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, lo
; SDISEL-NEXT:    cset w0, eq
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ult_eq:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, lo
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, eq
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ult i32 %s0, %s1
  %c1 = icmp eq i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ult_ne(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ult_ne:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #4, lo
; SDISEL-NEXT:    cset w0, ne
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ult_ne:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, lo
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ne
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ult i32 %s0, %s1
  %c1 = icmp ne i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ult_ult(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ult_ult:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #2, lo
; SDISEL-NEXT:    cset w0, lo
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ult_ult:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, lo
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, lo
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ult i32 %s0, %s1
  %c1 = icmp ult i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ult_ule(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ult_ule:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #2, lo
; SDISEL-NEXT:    cset w0, ls
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ult_ule:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, lo
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ls
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ult i32 %s0, %s1
  %c1 = icmp ule i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ult_ugt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ult_ugt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, lo
; SDISEL-NEXT:    cset w0, hi
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ult_ugt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, lo
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, hi
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ult i32 %s0, %s1
  %c1 = icmp ugt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ult_uge(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ult_uge:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, lo
; SDISEL-NEXT:    cset w0, hs
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ult_uge:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, lo
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, hs
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ult i32 %s0, %s1
  %c1 = icmp uge i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ult_slt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ult_slt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, lo
; SDISEL-NEXT:    cset w0, lt
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ult_slt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, lo
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, lt
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ult i32 %s0, %s1
  %c1 = icmp slt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ult_sle(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ult_sle:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, lo
; SDISEL-NEXT:    cset w0, le
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ult_sle:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, lo
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, le
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ult i32 %s0, %s1
  %c1 = icmp sle i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ult_sgt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ult_sgt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #4, lo
; SDISEL-NEXT:    cset w0, gt
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ult_sgt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, lo
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, gt
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ult i32 %s0, %s1
  %c1 = icmp sgt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ult_sge(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ult_sge:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #8, lo
; SDISEL-NEXT:    cset w0, ge
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ult_sge:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, lo
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ge
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ult i32 %s0, %s1
  %c1 = icmp sge i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ule_eq(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ule_eq:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, ls
; SDISEL-NEXT:    cset w0, eq
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ule_eq:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ls
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, eq
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ule i32 %s0, %s1
  %c1 = icmp eq i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ule_ne(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ule_ne:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #4, ls
; SDISEL-NEXT:    cset w0, ne
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ule_ne:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ls
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ne
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ule i32 %s0, %s1
  %c1 = icmp ne i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ule_ult(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ule_ult:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #2, ls
; SDISEL-NEXT:    cset w0, lo
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ule_ult:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ls
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, lo
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ule i32 %s0, %s1
  %c1 = icmp ult i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ule_ule(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ule_ule:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #2, ls
; SDISEL-NEXT:    cset w0, ls
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ule_ule:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ls
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ls
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ule i32 %s0, %s1
  %c1 = icmp ule i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ule_ugt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ule_ugt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, ls
; SDISEL-NEXT:    cset w0, hi
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ule_ugt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ls
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, hi
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ule i32 %s0, %s1
  %c1 = icmp ugt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ule_uge(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ule_uge:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, ls
; SDISEL-NEXT:    cset w0, hs
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ule_uge:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ls
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, hs
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ule i32 %s0, %s1
  %c1 = icmp uge i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ule_slt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ule_slt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, ls
; SDISEL-NEXT:    cset w0, lt
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ule_slt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ls
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, lt
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ule i32 %s0, %s1
  %c1 = icmp slt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ule_sle(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ule_sle:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, ls
; SDISEL-NEXT:    cset w0, le
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ule_sle:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ls
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, le
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ule i32 %s0, %s1
  %c1 = icmp sle i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ule_sgt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ule_sgt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #4, ls
; SDISEL-NEXT:    cset w0, gt
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ule_sgt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ls
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, gt
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ule i32 %s0, %s1
  %c1 = icmp sgt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ule_sge(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ule_sge:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #8, ls
; SDISEL-NEXT:    cset w0, ge
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ule_sge:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ls
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ge
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ule i32 %s0, %s1
  %c1 = icmp sge i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ugt_eq(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ugt_eq:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, hi
; SDISEL-NEXT:    cset w0, eq
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ugt_eq:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, hi
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, eq
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ugt i32 %s0, %s1
  %c1 = icmp eq i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ugt_ne(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ugt_ne:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #4, hi
; SDISEL-NEXT:    cset w0, ne
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ugt_ne:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, hi
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ne
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ugt i32 %s0, %s1
  %c1 = icmp ne i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ugt_ult(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ugt_ult:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #2, hi
; SDISEL-NEXT:    cset w0, lo
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ugt_ult:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, hi
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, lo
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ugt i32 %s0, %s1
  %c1 = icmp ult i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ugt_ule(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ugt_ule:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #2, hi
; SDISEL-NEXT:    cset w0, ls
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ugt_ule:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, hi
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ls
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ugt i32 %s0, %s1
  %c1 = icmp ule i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ugt_ugt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ugt_ugt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, hi
; SDISEL-NEXT:    cset w0, hi
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ugt_ugt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, hi
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, hi
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ugt i32 %s0, %s1
  %c1 = icmp ugt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ugt_uge(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ugt_uge:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, hi
; SDISEL-NEXT:    cset w0, hs
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ugt_uge:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, hi
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, hs
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ugt i32 %s0, %s1
  %c1 = icmp uge i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ugt_slt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ugt_slt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, hi
; SDISEL-NEXT:    cset w0, lt
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ugt_slt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, hi
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, lt
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ugt i32 %s0, %s1
  %c1 = icmp slt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ugt_sle(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ugt_sle:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, hi
; SDISEL-NEXT:    cset w0, le
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ugt_sle:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, hi
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, le
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ugt i32 %s0, %s1
  %c1 = icmp sle i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ugt_sgt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ugt_sgt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #4, hi
; SDISEL-NEXT:    cset w0, gt
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ugt_sgt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, hi
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, gt
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ugt i32 %s0, %s1
  %c1 = icmp sgt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_ugt_sge(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_ugt_sge:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #8, hi
; SDISEL-NEXT:    cset w0, ge
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ugt_sge:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, hi
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ge
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ugt i32 %s0, %s1
  %c1 = icmp sge i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_uge_eq(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_uge_eq:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, hs
; SDISEL-NEXT:    cset w0, eq
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_uge_eq:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, hs
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, eq
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp uge i32 %s0, %s1
  %c1 = icmp eq i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_uge_ne(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_uge_ne:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #4, hs
; SDISEL-NEXT:    cset w0, ne
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_uge_ne:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, hs
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ne
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp uge i32 %s0, %s1
  %c1 = icmp ne i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_uge_ult(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_uge_ult:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #2, hs
; SDISEL-NEXT:    cset w0, lo
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_uge_ult:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, hs
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, lo
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp uge i32 %s0, %s1
  %c1 = icmp ult i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_uge_ule(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_uge_ule:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #2, hs
; SDISEL-NEXT:    cset w0, ls
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_uge_ule:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, hs
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ls
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp uge i32 %s0, %s1
  %c1 = icmp ule i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_uge_ugt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_uge_ugt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, hs
; SDISEL-NEXT:    cset w0, hi
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_uge_ugt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, hs
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, hi
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp uge i32 %s0, %s1
  %c1 = icmp ugt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_uge_uge(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_uge_uge:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, hs
; SDISEL-NEXT:    cset w0, hs
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_uge_uge:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, hs
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, hs
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp uge i32 %s0, %s1
  %c1 = icmp uge i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_uge_slt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_uge_slt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, hs
; SDISEL-NEXT:    cset w0, lt
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_uge_slt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, hs
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, lt
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp uge i32 %s0, %s1
  %c1 = icmp slt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_uge_sle(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_uge_sle:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, hs
; SDISEL-NEXT:    cset w0, le
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_uge_sle:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, hs
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, le
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp uge i32 %s0, %s1
  %c1 = icmp sle i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_uge_sgt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_uge_sgt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #4, hs
; SDISEL-NEXT:    cset w0, gt
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_uge_sgt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, hs
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, gt
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp uge i32 %s0, %s1
  %c1 = icmp sgt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_uge_sge(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_uge_sge:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #8, hs
; SDISEL-NEXT:    cset w0, ge
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_uge_sge:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, hs
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ge
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp uge i32 %s0, %s1
  %c1 = icmp sge i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_slt_eq(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_slt_eq:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, lt
; SDISEL-NEXT:    cset w0, eq
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_slt_eq:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, lt
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, eq
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp slt i32 %s0, %s1
  %c1 = icmp eq i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_slt_ne(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_slt_ne:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #4, lt
; SDISEL-NEXT:    cset w0, ne
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_slt_ne:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, lt
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ne
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp slt i32 %s0, %s1
  %c1 = icmp ne i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_slt_ult(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_slt_ult:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #2, lt
; SDISEL-NEXT:    cset w0, lo
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_slt_ult:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, lt
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, lo
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp slt i32 %s0, %s1
  %c1 = icmp ult i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_slt_ule(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_slt_ule:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #2, lt
; SDISEL-NEXT:    cset w0, ls
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_slt_ule:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, lt
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ls
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp slt i32 %s0, %s1
  %c1 = icmp ule i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_slt_ugt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_slt_ugt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, lt
; SDISEL-NEXT:    cset w0, hi
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_slt_ugt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, lt
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, hi
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp slt i32 %s0, %s1
  %c1 = icmp ugt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_slt_uge(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_slt_uge:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, lt
; SDISEL-NEXT:    cset w0, hs
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_slt_uge:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, lt
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, hs
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp slt i32 %s0, %s1
  %c1 = icmp uge i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_slt_slt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_slt_slt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, lt
; SDISEL-NEXT:    cset w0, lt
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_slt_slt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, lt
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, lt
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp slt i32 %s0, %s1
  %c1 = icmp slt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_slt_sle(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_slt_sle:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, lt
; SDISEL-NEXT:    cset w0, le
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_slt_sle:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, lt
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, le
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp slt i32 %s0, %s1
  %c1 = icmp sle i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_slt_sgt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_slt_sgt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #4, lt
; SDISEL-NEXT:    cset w0, gt
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_slt_sgt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, lt
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, gt
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp slt i32 %s0, %s1
  %c1 = icmp sgt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_slt_sge(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_slt_sge:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #8, lt
; SDISEL-NEXT:    cset w0, ge
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_slt_sge:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, lt
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ge
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp slt i32 %s0, %s1
  %c1 = icmp sge i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sle_eq(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sle_eq:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, le
; SDISEL-NEXT:    cset w0, eq
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sle_eq:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, le
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, eq
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sle i32 %s0, %s1
  %c1 = icmp eq i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sle_ne(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sle_ne:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #4, le
; SDISEL-NEXT:    cset w0, ne
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sle_ne:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, le
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ne
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sle i32 %s0, %s1
  %c1 = icmp ne i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sle_ult(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sle_ult:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #2, le
; SDISEL-NEXT:    cset w0, lo
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sle_ult:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, le
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, lo
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sle i32 %s0, %s1
  %c1 = icmp ult i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sle_ule(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sle_ule:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #2, le
; SDISEL-NEXT:    cset w0, ls
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sle_ule:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, le
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ls
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sle i32 %s0, %s1
  %c1 = icmp ule i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sle_ugt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sle_ugt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, le
; SDISEL-NEXT:    cset w0, hi
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sle_ugt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, le
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, hi
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sle i32 %s0, %s1
  %c1 = icmp ugt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sle_uge(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sle_uge:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, le
; SDISEL-NEXT:    cset w0, hs
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sle_uge:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, le
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, hs
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sle i32 %s0, %s1
  %c1 = icmp uge i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sle_slt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sle_slt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, le
; SDISEL-NEXT:    cset w0, lt
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sle_slt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, le
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, lt
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sle i32 %s0, %s1
  %c1 = icmp slt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sle_sle(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sle_sle:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, le
; SDISEL-NEXT:    cset w0, le
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sle_sle:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, le
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, le
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sle i32 %s0, %s1
  %c1 = icmp sle i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sle_sgt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sle_sgt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #4, le
; SDISEL-NEXT:    cset w0, gt
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sle_sgt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, le
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, gt
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sle i32 %s0, %s1
  %c1 = icmp sgt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sle_sge(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sle_sge:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #8, le
; SDISEL-NEXT:    cset w0, ge
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sle_sge:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, le
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ge
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sle i32 %s0, %s1
  %c1 = icmp sge i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sgt_eq(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sgt_eq:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, gt
; SDISEL-NEXT:    cset w0, eq
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sgt_eq:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, gt
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, eq
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sgt i32 %s0, %s1
  %c1 = icmp eq i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sgt_ne(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sgt_ne:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #4, gt
; SDISEL-NEXT:    cset w0, ne
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sgt_ne:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, gt
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ne
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sgt i32 %s0, %s1
  %c1 = icmp ne i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sgt_ult(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sgt_ult:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #2, gt
; SDISEL-NEXT:    cset w0, lo
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sgt_ult:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, gt
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, lo
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sgt i32 %s0, %s1
  %c1 = icmp ult i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sgt_ule(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sgt_ule:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #2, gt
; SDISEL-NEXT:    cset w0, ls
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sgt_ule:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, gt
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ls
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sgt i32 %s0, %s1
  %c1 = icmp ule i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sgt_ugt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sgt_ugt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, gt
; SDISEL-NEXT:    cset w0, hi
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sgt_ugt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, gt
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, hi
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sgt i32 %s0, %s1
  %c1 = icmp ugt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sgt_uge(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sgt_uge:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, gt
; SDISEL-NEXT:    cset w0, hs
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sgt_uge:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, gt
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, hs
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sgt i32 %s0, %s1
  %c1 = icmp uge i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sgt_slt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sgt_slt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, gt
; SDISEL-NEXT:    cset w0, lt
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sgt_slt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, gt
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, lt
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sgt i32 %s0, %s1
  %c1 = icmp slt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sgt_sle(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sgt_sle:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, gt
; SDISEL-NEXT:    cset w0, le
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sgt_sle:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, gt
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, le
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sgt i32 %s0, %s1
  %c1 = icmp sle i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sgt_sgt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sgt_sgt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #4, gt
; SDISEL-NEXT:    cset w0, gt
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sgt_sgt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, gt
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, gt
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sgt i32 %s0, %s1
  %c1 = icmp sgt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sgt_sge(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sgt_sge:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #8, gt
; SDISEL-NEXT:    cset w0, ge
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sgt_sge:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, gt
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ge
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sgt i32 %s0, %s1
  %c1 = icmp sge i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sge_eq(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sge_eq:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, ge
; SDISEL-NEXT:    cset w0, eq
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sge_eq:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ge
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, eq
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sge i32 %s0, %s1
  %c1 = icmp eq i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sge_ne(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sge_ne:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #4, ge
; SDISEL-NEXT:    cset w0, ne
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sge_ne:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ge
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ne
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sge i32 %s0, %s1
  %c1 = icmp ne i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sge_ult(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sge_ult:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #2, ge
; SDISEL-NEXT:    cset w0, lo
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sge_ult:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ge
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, lo
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sge i32 %s0, %s1
  %c1 = icmp ult i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sge_ule(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sge_ule:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #2, ge
; SDISEL-NEXT:    cset w0, ls
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sge_ule:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ge
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ls
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sge i32 %s0, %s1
  %c1 = icmp ule i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sge_ugt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sge_ugt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, ge
; SDISEL-NEXT:    cset w0, hi
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sge_ugt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ge
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, hi
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sge i32 %s0, %s1
  %c1 = icmp ugt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sge_uge(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sge_uge:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, ge
; SDISEL-NEXT:    cset w0, hs
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sge_uge:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ge
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, hs
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sge i32 %s0, %s1
  %c1 = icmp uge i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sge_slt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sge_slt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, ge
; SDISEL-NEXT:    cset w0, lt
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sge_slt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ge
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, lt
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sge i32 %s0, %s1
  %c1 = icmp slt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sge_sle(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sge_sle:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #0, ge
; SDISEL-NEXT:    cset w0, le
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sge_sle:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ge
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, le
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sge i32 %s0, %s1
  %c1 = icmp sle i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sge_sgt(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sge_sgt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #4, ge
; SDISEL-NEXT:    cset w0, gt
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sge_sgt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ge
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, gt
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sge i32 %s0, %s1
  %c1 = icmp sgt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @and_sge_sge(i32 %s0, i32 %s1, i32 %s2, i32 %s3) {
; SDISEL-LABEL: and_sge_sge:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w0, w1
; SDISEL-NEXT:    ccmp w2, w3, #8, ge
; SDISEL-NEXT:    cset w0, ge
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sge_sge:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ge
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ge
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sge i32 %s0, %s1
  %c1 = icmp sge i32 %s2, %s3
  %a = and i1 %c0, %c1
  %z = zext i1 %a to i32
  ret i32 %z
}

define i32 @cmp_to_ands1(i32 %num) {
; SDISEL-LABEL: cmp_to_ands1:
; SDISEL:       // %bb.0:
; SDISEL-NEXT:    and w8, w0, #0xff
; SDISEL-NEXT:    tst w0, #0xfe
; SDISEL-NEXT:    csel w0, w8, wzr, ne
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: cmp_to_ands1:
; GISEL:       // %bb.0:
; GISEL-NEXT:    and w8, w0, #0xff
; GISEL-NEXT:    cmp w8, #1
; GISEL-NEXT:    csel w0, w8, wzr, hi
; GISEL-NEXT:    ret
  %and = and i32 %num, 255
  %cmp = icmp ugt i32 %and, 1
  %r = select i1 %cmp, i32 %and, i32 0
  ret i32 %r
}

define i32 @cmp_to_ands2(i32 %num) {
; SDISEL-LABEL: cmp_to_ands2:
; SDISEL:       // %bb.0:
; SDISEL-NEXT:    and w8, w0, #0xfe
; SDISEL-NEXT:    tst w0, #0xc0
; SDISEL-NEXT:    csel w0, w8, wzr, ne
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: cmp_to_ands2:
; GISEL:       // %bb.0:
; GISEL-NEXT:    and w8, w0, #0xfe
; GISEL-NEXT:    cmp w8, #63
; GISEL-NEXT:    csel w0, w8, wzr, hi
; GISEL-NEXT:    ret
  %and = and i32 %num, 254
  %cmp = icmp ugt i32 %and, 63
  %r = select i1 %cmp, i32 %and, i32 0
  ret i32 %r
}

define i32 @cmp_to_ands3(i32 %num, i32 %a) {
; SDISEL-LABEL: cmp_to_ands3:
; SDISEL:       // %bb.0:
; SDISEL-NEXT:    tst w0, #0x10
; SDISEL-NEXT:    csel w0, w1, wzr, ne
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: cmp_to_ands3:
; GISEL:       // %bb.0:
; GISEL-NEXT:    mov w8, #23 // =0x17
; GISEL-NEXT:    and w8, w0, w8
; GISEL-NEXT:    cmp w8, #7
; GISEL-NEXT:    csel w0, w1, wzr, hi
; GISEL-NEXT:    ret
  %and = and i32 %num, 23
  %cmp = icmp ugt i32 %and, 7
  %r = select i1 %cmp, i32 %a, i32 0
  ret i32 %r
}

define i32 @cmp_to_ands4(i32 %num, i32 %a) {
; SDISEL-LABEL: cmp_to_ands4:
; SDISEL:       // %bb.0:
; SDISEL-NEXT:    and w8, w0, #0x30
; SDISEL-NEXT:    tst w0, #0x20
; SDISEL-NEXT:    csel w0, w8, w1, eq
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: cmp_to_ands4:
; GISEL:       // %bb.0:
; GISEL-NEXT:    and w8, w0, #0x30
; GISEL-NEXT:    cmp w8, #31
; GISEL-NEXT:    csel w0, w8, w1, ls
; GISEL-NEXT:    ret
  %and = and i32 %num, 48
  %cmp = icmp ule i32 %and, 31
  %r = select i1 %cmp, i32 %and, i32 %a
  ret i32 %r
}

define i32 @cmp_to_ands5(i32 %num, i32 %a) {
; SDISEL-LABEL: cmp_to_ands5:
; SDISEL:       // %bb.0:
; SDISEL-NEXT:    and w8, w0, #0xf8
; SDISEL-NEXT:    tst w0, #0xc0
; SDISEL-NEXT:    csel w0, w8, w1, eq
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: cmp_to_ands5:
; GISEL:       // %bb.0:
; GISEL-NEXT:    and w8, w0, #0xf8
; GISEL-NEXT:    cmp w8, #64
; GISEL-NEXT:    csel w0, w8, w1, lo
; GISEL-NEXT:    ret
  %and = and i32 %num, 248
  %cmp = icmp ult i32 %and, 64
  %r = select i1 %cmp, i32 %and, i32 %a
  ret i32 %r
}

define i32 @cmp_to_ands6(i32 %num) {
; SDISEL-LABEL: cmp_to_ands6:
; SDISEL:       // %bb.0:
; SDISEL-NEXT:    and w8, w0, #0xfe
; SDISEL-NEXT:    tst w0, #0xf0
; SDISEL-NEXT:    csel w0, w8, wzr, ne
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: cmp_to_ands6:
; GISEL:       // %bb.0:
; GISEL-NEXT:    and w8, w0, #0xfe
; GISEL-NEXT:    cmp w8, #16
; GISEL-NEXT:    csel w0, w8, wzr, hs
; GISEL-NEXT:    ret
  %and = and i32 %num, 254
  %cmp = icmp uge i32 %and, 16
  %r = select i1 %cmp, i32 %and, i32 0
  ret i32 %r
}

define i1 @and_fcmp(float %0, float %1) {
; SDISEL-LABEL: and_fcmp:
; SDISEL:       // %bb.0:
; SDISEL-NEXT:    fcmp s1, s1
; SDISEL-NEXT:    fccmp s0, s0, #0, vs
; SDISEL-NEXT:    cset w0, vs
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_fcmp:
; GISEL:       // %bb.0:
; GISEL-NEXT:    fcmp s0, #0.0
; GISEL-NEXT:    cset w8, vs
; GISEL-NEXT:    fcmp s1, #0.0
; GISEL-NEXT:    cset w9, vs
; GISEL-NEXT:    and w0, w8, w9
; GISEL-NEXT:    ret

  %3 = fcmp uno float %0, 0.000000e+00
  %4 = fcmp uno float %1, 0.000000e+00
  %5 = and i1 %3, %4
  ret i1 %5
}


;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK: {{.*}}
