/*
 * Subset of Influx API covered by Influx CLI
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * API version: 2.0.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package api

import (
	_context "context"
	_fmt "fmt"
	_io "io"
	_nethttp "net/http"
	_neturl "net/url"
	"strings"
)

// Linger please
var (
	_ _context.Context
)

type BucketSchemasApi interface {

	/*
			 * CreateMeasurementSchema Create a measurement schema for a bucket
			 * Creates an _explict_ measurement [schema]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#schema)
		for a bucket.

		_Explicit_ schemas are used to enforce column names, tags, fields, and data
		types for your data.

		By default, buckets have an _implicit_ schema-type (`"schemaType": "implicit"`)
		that conforms to your data.

		Use this endpoint to create schemas that prevent non-conforming write requests.

		#### Limitations

		- Buckets must be created with the "explict" `schemaType` in order to use
		schemas.

		#### Related guides

		- [Manage bucket schemas]({{% INFLUXDB_DOCS_URL %}}/organizations/buckets/bucket-schema/).
		- [Create a bucket with an explicit schema]({{% INFLUXDB_DOCS_URL %}}/organizations/buckets/create-bucket/#create-a-bucket-with-an-explicit-schema)

			 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @param bucketID A bucket ID. Adds a schema for the specified bucket.
			 * @return ApiCreateMeasurementSchemaRequest
	*/
	CreateMeasurementSchema(ctx _context.Context, bucketID string) ApiCreateMeasurementSchemaRequest

	/*
	 * CreateMeasurementSchemaExecute executes the request
	 * @return MeasurementSchema
	 */
	CreateMeasurementSchemaExecute(r ApiCreateMeasurementSchemaRequest) (MeasurementSchema, error)

	/*
	 * CreateMeasurementSchemaExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not
	 * available on the returned HTTP response as it will have already been read and closed; access to the response body
	 * content should be achieved through the returned response model if applicable.
	 * @return MeasurementSchema
	 */
	CreateMeasurementSchemaExecuteWithHttpInfo(r ApiCreateMeasurementSchemaRequest) (MeasurementSchema, *_nethttp.Response, error)

	/*
	 * GetMeasurementSchema Retrieve a measurement schema
	 * Retrieves an explicit measurement [schema]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#schema).

	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param bucketID A bucket ID. Retrieves schemas for the specified bucket.
	 * @param measurementID The measurement schema ID. Specifies the measurement schema to retrieve.
	 * @return ApiGetMeasurementSchemaRequest
	 */
	GetMeasurementSchema(ctx _context.Context, bucketID string, measurementID string) ApiGetMeasurementSchemaRequest

	/*
	 * GetMeasurementSchemaExecute executes the request
	 * @return MeasurementSchema
	 */
	GetMeasurementSchemaExecute(r ApiGetMeasurementSchemaRequest) (MeasurementSchema, error)

	/*
	 * GetMeasurementSchemaExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not
	 * available on the returned HTTP response as it will have already been read and closed; access to the response body
	 * content should be achieved through the returned response model if applicable.
	 * @return MeasurementSchema
	 */
	GetMeasurementSchemaExecuteWithHttpInfo(r ApiGetMeasurementSchemaRequest) (MeasurementSchema, *_nethttp.Response, error)

	/*
			 * GetMeasurementSchemas List measurement schemas of a bucket
			 * Lists _explicit_
		[schemas]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#schema)
		(`"schemaType": "explicit"`) for a bucket.

		_Explicit_ schemas are used to enforce column names, tags, fields, and data
		types for your data.

		By default, buckets have an _implicit_ schema-type (`"schemaType": "implicit"`)
		that conforms to your data.

		#### Related guides

		- [Using bucket schemas](https://www.influxdata.com/blog/new-bucket-schema-option-protect-from-unwanted-schema-changes/)

			 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @param bucketID A bucket ID. Lists measurement schemas for the specified bucket.
			 * @return ApiGetMeasurementSchemasRequest
	*/
	GetMeasurementSchemas(ctx _context.Context, bucketID string) ApiGetMeasurementSchemasRequest

	/*
	 * GetMeasurementSchemasExecute executes the request
	 * @return MeasurementSchemaList
	 */
	GetMeasurementSchemasExecute(r ApiGetMeasurementSchemasRequest) (MeasurementSchemaList, error)

	/*
	 * GetMeasurementSchemasExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not
	 * available on the returned HTTP response as it will have already been read and closed; access to the response body
	 * content should be achieved through the returned response model if applicable.
	 * @return MeasurementSchemaList
	 */
	GetMeasurementSchemasExecuteWithHttpInfo(r ApiGetMeasurementSchemasRequest) (MeasurementSchemaList, *_nethttp.Response, error)

	/*
			 * UpdateMeasurementSchema Update a measurement schema
			 * Updates a measurement [schema]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#schema).

		Use this endpoint to update the fields (`name`, `type`, and `dataType`) of a
		measurement schema.

		#### Limitations

		- You can't update the `name` of a measurement.

		#### Related guides

		- [Manage bucket schemas]({{% INFLUXDB_DOCS_URL %}}/organizations/buckets/bucket-schema/).
		- [Using bucket schemas](https://www.influxdata.com/blog/new-bucket-schema-option-protect-from-unwanted-schema-changes/).

			 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @param bucketID A bucket ID. Specifies the bucket to retrieve schemas for.
			 * @param measurementID A measurement schema ID. Retrieves the specified measurement schema.
			 * @return ApiUpdateMeasurementSchemaRequest
	*/
	UpdateMeasurementSchema(ctx _context.Context, bucketID string, measurementID string) ApiUpdateMeasurementSchemaRequest

	/*
	 * UpdateMeasurementSchemaExecute executes the request
	 * @return MeasurementSchema
	 */
	UpdateMeasurementSchemaExecute(r ApiUpdateMeasurementSchemaRequest) (MeasurementSchema, error)

	/*
	 * UpdateMeasurementSchemaExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not
	 * available on the returned HTTP response as it will have already been read and closed; access to the response body
	 * content should be achieved through the returned response model if applicable.
	 * @return MeasurementSchema
	 */
	UpdateMeasurementSchemaExecuteWithHttpInfo(r ApiUpdateMeasurementSchemaRequest) (MeasurementSchema, *_nethttp.Response, error)
}

// BucketSchemasApiService BucketSchemasApi service
type BucketSchemasApiService service

type ApiCreateMeasurementSchemaRequest struct {
	ctx                            _context.Context
	ApiService                     BucketSchemasApi
	bucketID                       string
	measurementSchemaCreateRequest *MeasurementSchemaCreateRequest
	org                            *string
	orgID                          *string
}

func (r ApiCreateMeasurementSchemaRequest) BucketID(bucketID string) ApiCreateMeasurementSchemaRequest {
	r.bucketID = bucketID
	return r
}
func (r ApiCreateMeasurementSchemaRequest) GetBucketID() string {
	return r.bucketID
}

func (r ApiCreateMeasurementSchemaRequest) MeasurementSchemaCreateRequest(measurementSchemaCreateRequest MeasurementSchemaCreateRequest) ApiCreateMeasurementSchemaRequest {
	r.measurementSchemaCreateRequest = &measurementSchemaCreateRequest
	return r
}
func (r ApiCreateMeasurementSchemaRequest) GetMeasurementSchemaCreateRequest() *MeasurementSchemaCreateRequest {
	return r.measurementSchemaCreateRequest
}

func (r ApiCreateMeasurementSchemaRequest) Org(org string) ApiCreateMeasurementSchemaRequest {
	r.org = &org
	return r
}
func (r ApiCreateMeasurementSchemaRequest) GetOrg() *string {
	return r.org
}

func (r ApiCreateMeasurementSchemaRequest) OrgID(orgID string) ApiCreateMeasurementSchemaRequest {
	r.orgID = &orgID
	return r
}
func (r ApiCreateMeasurementSchemaRequest) GetOrgID() *string {
	return r.orgID
}

func (r ApiCreateMeasurementSchemaRequest) Execute() (MeasurementSchema, error) {
	return r.ApiService.CreateMeasurementSchemaExecute(r)
}

func (r ApiCreateMeasurementSchemaRequest) ExecuteWithHttpInfo() (MeasurementSchema, *_nethttp.Response, error) {
	return r.ApiService.CreateMeasurementSchemaExecuteWithHttpInfo(r)
}

/*
  - CreateMeasurementSchema Create a measurement schema for a bucket
  - Creates an _explict_ measurement [schema]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#schema)

for a bucket.

_Explicit_ schemas are used to enforce column names, tags, fields, and data
types for your data.

By default, buckets have an _implicit_ schema-type (`"schemaType": "implicit"`)
that conforms to your data.

Use this endpoint to create schemas that prevent non-conforming write requests.

#### Limitations

- Buckets must be created with the "explict" `schemaType` in order to use
schemas.

#### Related guides

- [Manage bucket schemas]({{% INFLUXDB_DOCS_URL %}}/organizations/buckets/bucket-schema/).
- [Create a bucket with an explicit schema]({{% INFLUXDB_DOCS_URL %}}/organizations/buckets/create-bucket/#create-a-bucket-with-an-explicit-schema)

  - @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @param bucketID A bucket ID. Adds a schema for the specified bucket.
  - @return ApiCreateMeasurementSchemaRequest
*/
func (a *BucketSchemasApiService) CreateMeasurementSchema(ctx _context.Context, bucketID string) ApiCreateMeasurementSchemaRequest {
	return ApiCreateMeasurementSchemaRequest{
		ApiService: a,
		ctx:        ctx,
		bucketID:   bucketID,
	}
}

/*
 * Execute executes the request
 * @return MeasurementSchema
 */
func (a *BucketSchemasApiService) CreateMeasurementSchemaExecute(r ApiCreateMeasurementSchemaRequest) (MeasurementSchema, error) {
	returnVal, _, err := a.CreateMeasurementSchemaExecuteWithHttpInfo(r)
	return returnVal, err
}

/*
 * ExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not available on the
 * returned HTTP response as it will have already been read and closed; access to the response body content should be
 * achieved through the returned response model if applicable.
 * @return MeasurementSchema
 */
func (a *BucketSchemasApiService) CreateMeasurementSchemaExecuteWithHttpInfo(r ApiCreateMeasurementSchemaRequest) (MeasurementSchema, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  MeasurementSchema
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "BucketSchemasApiService.CreateMeasurementSchema")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v2/buckets/{bucketID}/schema/measurements"
	localVarPath = strings.Replace(localVarPath, "{"+"bucketID"+"}", _neturl.PathEscape(parameterToString(r.bucketID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.measurementSchemaCreateRequest == nil {
		return localVarReturnValue, nil, reportError("measurementSchemaCreateRequest is required and must be specified")
	}

	if r.org != nil {
		localVarQueryParams.Add("org", parameterToString(*r.org, ""))
	}
	if r.orgID != nil {
		localVarQueryParams.Add("orgID", parameterToString(*r.orgID, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.measurementSchemaCreateRequest
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	newErr := GenericOpenAPIError{
		buildHeader: localVarHTTPResponse.Header.Get("X-Influxdb-Build"),
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.body = localVarBody
		newErr.error = localVarHTTPResponse.Status
		if localVarHTTPResponse.StatusCode == 400 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v UnauthorizedRequestError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	newErr.body = localVarBody
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiGetMeasurementSchemaRequest struct {
	ctx           _context.Context
	ApiService    BucketSchemasApi
	bucketID      string
	measurementID string
	org           *string
	orgID         *string
}

func (r ApiGetMeasurementSchemaRequest) BucketID(bucketID string) ApiGetMeasurementSchemaRequest {
	r.bucketID = bucketID
	return r
}
func (r ApiGetMeasurementSchemaRequest) GetBucketID() string {
	return r.bucketID
}

func (r ApiGetMeasurementSchemaRequest) MeasurementID(measurementID string) ApiGetMeasurementSchemaRequest {
	r.measurementID = measurementID
	return r
}
func (r ApiGetMeasurementSchemaRequest) GetMeasurementID() string {
	return r.measurementID
}

func (r ApiGetMeasurementSchemaRequest) Org(org string) ApiGetMeasurementSchemaRequest {
	r.org = &org
	return r
}
func (r ApiGetMeasurementSchemaRequest) GetOrg() *string {
	return r.org
}

func (r ApiGetMeasurementSchemaRequest) OrgID(orgID string) ApiGetMeasurementSchemaRequest {
	r.orgID = &orgID
	return r
}
func (r ApiGetMeasurementSchemaRequest) GetOrgID() *string {
	return r.orgID
}

func (r ApiGetMeasurementSchemaRequest) Execute() (MeasurementSchema, error) {
	return r.ApiService.GetMeasurementSchemaExecute(r)
}

func (r ApiGetMeasurementSchemaRequest) ExecuteWithHttpInfo() (MeasurementSchema, *_nethttp.Response, error) {
	return r.ApiService.GetMeasurementSchemaExecuteWithHttpInfo(r)
}

/*
* GetMeasurementSchema Retrieve a measurement schema
* Retrieves an explicit measurement [schema]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#schema).

* @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
* @param bucketID A bucket ID. Retrieves schemas for the specified bucket.
* @param measurementID The measurement schema ID. Specifies the measurement schema to retrieve.
* @return ApiGetMeasurementSchemaRequest
 */
func (a *BucketSchemasApiService) GetMeasurementSchema(ctx _context.Context, bucketID string, measurementID string) ApiGetMeasurementSchemaRequest {
	return ApiGetMeasurementSchemaRequest{
		ApiService:    a,
		ctx:           ctx,
		bucketID:      bucketID,
		measurementID: measurementID,
	}
}

/*
 * Execute executes the request
 * @return MeasurementSchema
 */
func (a *BucketSchemasApiService) GetMeasurementSchemaExecute(r ApiGetMeasurementSchemaRequest) (MeasurementSchema, error) {
	returnVal, _, err := a.GetMeasurementSchemaExecuteWithHttpInfo(r)
	return returnVal, err
}

/*
 * ExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not available on the
 * returned HTTP response as it will have already been read and closed; access to the response body content should be
 * achieved through the returned response model if applicable.
 * @return MeasurementSchema
 */
func (a *BucketSchemasApiService) GetMeasurementSchemaExecuteWithHttpInfo(r ApiGetMeasurementSchemaRequest) (MeasurementSchema, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  MeasurementSchema
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "BucketSchemasApiService.GetMeasurementSchema")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v2/buckets/{bucketID}/schema/measurements/{measurementID}"
	localVarPath = strings.Replace(localVarPath, "{"+"bucketID"+"}", _neturl.PathEscape(parameterToString(r.bucketID, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"measurementID"+"}", _neturl.PathEscape(parameterToString(r.measurementID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.org != nil {
		localVarQueryParams.Add("org", parameterToString(*r.org, ""))
	}
	if r.orgID != nil {
		localVarQueryParams.Add("orgID", parameterToString(*r.orgID, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	newErr := GenericOpenAPIError{
		buildHeader: localVarHTTPResponse.Header.Get("X-Influxdb-Build"),
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.body = localVarBody
		newErr.error = localVarHTTPResponse.Status
		if localVarHTTPResponse.StatusCode == 401 {
			var v UnauthorizedRequestError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	newErr.body = localVarBody
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiGetMeasurementSchemasRequest struct {
	ctx        _context.Context
	ApiService BucketSchemasApi
	bucketID   string
	org        *string
	orgID      *string
	name       *string
}

func (r ApiGetMeasurementSchemasRequest) BucketID(bucketID string) ApiGetMeasurementSchemasRequest {
	r.bucketID = bucketID
	return r
}
func (r ApiGetMeasurementSchemasRequest) GetBucketID() string {
	return r.bucketID
}

func (r ApiGetMeasurementSchemasRequest) Org(org string) ApiGetMeasurementSchemasRequest {
	r.org = &org
	return r
}
func (r ApiGetMeasurementSchemasRequest) GetOrg() *string {
	return r.org
}

func (r ApiGetMeasurementSchemasRequest) OrgID(orgID string) ApiGetMeasurementSchemasRequest {
	r.orgID = &orgID
	return r
}
func (r ApiGetMeasurementSchemasRequest) GetOrgID() *string {
	return r.orgID
}

func (r ApiGetMeasurementSchemasRequest) Name(name string) ApiGetMeasurementSchemasRequest {
	r.name = &name
	return r
}
func (r ApiGetMeasurementSchemasRequest) GetName() *string {
	return r.name
}

func (r ApiGetMeasurementSchemasRequest) Execute() (MeasurementSchemaList, error) {
	return r.ApiService.GetMeasurementSchemasExecute(r)
}

func (r ApiGetMeasurementSchemasRequest) ExecuteWithHttpInfo() (MeasurementSchemaList, *_nethttp.Response, error) {
	return r.ApiService.GetMeasurementSchemasExecuteWithHttpInfo(r)
}

/*
  - GetMeasurementSchemas List measurement schemas of a bucket
  - Lists _explicit_

[schemas]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#schema)
(`"schemaType": "explicit"`) for a bucket.

_Explicit_ schemas are used to enforce column names, tags, fields, and data
types for your data.

By default, buckets have an _implicit_ schema-type (`"schemaType": "implicit"`)
that conforms to your data.

#### Related guides

- [Using bucket schemas](https://www.influxdata.com/blog/new-bucket-schema-option-protect-from-unwanted-schema-changes/)

  - @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @param bucketID A bucket ID. Lists measurement schemas for the specified bucket.
  - @return ApiGetMeasurementSchemasRequest
*/
func (a *BucketSchemasApiService) GetMeasurementSchemas(ctx _context.Context, bucketID string) ApiGetMeasurementSchemasRequest {
	return ApiGetMeasurementSchemasRequest{
		ApiService: a,
		ctx:        ctx,
		bucketID:   bucketID,
	}
}

/*
 * Execute executes the request
 * @return MeasurementSchemaList
 */
func (a *BucketSchemasApiService) GetMeasurementSchemasExecute(r ApiGetMeasurementSchemasRequest) (MeasurementSchemaList, error) {
	returnVal, _, err := a.GetMeasurementSchemasExecuteWithHttpInfo(r)
	return returnVal, err
}

/*
 * ExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not available on the
 * returned HTTP response as it will have already been read and closed; access to the response body content should be
 * achieved through the returned response model if applicable.
 * @return MeasurementSchemaList
 */
func (a *BucketSchemasApiService) GetMeasurementSchemasExecuteWithHttpInfo(r ApiGetMeasurementSchemasRequest) (MeasurementSchemaList, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  MeasurementSchemaList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "BucketSchemasApiService.GetMeasurementSchemas")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v2/buckets/{bucketID}/schema/measurements"
	localVarPath = strings.Replace(localVarPath, "{"+"bucketID"+"}", _neturl.PathEscape(parameterToString(r.bucketID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.org != nil {
		localVarQueryParams.Add("org", parameterToString(*r.org, ""))
	}
	if r.orgID != nil {
		localVarQueryParams.Add("orgID", parameterToString(*r.orgID, ""))
	}
	if r.name != nil {
		localVarQueryParams.Add("name", parameterToString(*r.name, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	newErr := GenericOpenAPIError{
		buildHeader: localVarHTTPResponse.Header.Get("X-Influxdb-Build"),
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.body = localVarBody
		newErr.error = localVarHTTPResponse.Status
		if localVarHTTPResponse.StatusCode == 400 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v UnauthorizedRequestError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	newErr.body = localVarBody
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiUpdateMeasurementSchemaRequest struct {
	ctx                            _context.Context
	ApiService                     BucketSchemasApi
	bucketID                       string
	measurementID                  string
	measurementSchemaUpdateRequest *MeasurementSchemaUpdateRequest
	org                            *string
	orgID                          *string
}

func (r ApiUpdateMeasurementSchemaRequest) BucketID(bucketID string) ApiUpdateMeasurementSchemaRequest {
	r.bucketID = bucketID
	return r
}
func (r ApiUpdateMeasurementSchemaRequest) GetBucketID() string {
	return r.bucketID
}

func (r ApiUpdateMeasurementSchemaRequest) MeasurementID(measurementID string) ApiUpdateMeasurementSchemaRequest {
	r.measurementID = measurementID
	return r
}
func (r ApiUpdateMeasurementSchemaRequest) GetMeasurementID() string {
	return r.measurementID
}

func (r ApiUpdateMeasurementSchemaRequest) MeasurementSchemaUpdateRequest(measurementSchemaUpdateRequest MeasurementSchemaUpdateRequest) ApiUpdateMeasurementSchemaRequest {
	r.measurementSchemaUpdateRequest = &measurementSchemaUpdateRequest
	return r
}
func (r ApiUpdateMeasurementSchemaRequest) GetMeasurementSchemaUpdateRequest() *MeasurementSchemaUpdateRequest {
	return r.measurementSchemaUpdateRequest
}

func (r ApiUpdateMeasurementSchemaRequest) Org(org string) ApiUpdateMeasurementSchemaRequest {
	r.org = &org
	return r
}
func (r ApiUpdateMeasurementSchemaRequest) GetOrg() *string {
	return r.org
}

func (r ApiUpdateMeasurementSchemaRequest) OrgID(orgID string) ApiUpdateMeasurementSchemaRequest {
	r.orgID = &orgID
	return r
}
func (r ApiUpdateMeasurementSchemaRequest) GetOrgID() *string {
	return r.orgID
}

func (r ApiUpdateMeasurementSchemaRequest) Execute() (MeasurementSchema, error) {
	return r.ApiService.UpdateMeasurementSchemaExecute(r)
}

func (r ApiUpdateMeasurementSchemaRequest) ExecuteWithHttpInfo() (MeasurementSchema, *_nethttp.Response, error) {
	return r.ApiService.UpdateMeasurementSchemaExecuteWithHttpInfo(r)
}

/*
  - UpdateMeasurementSchema Update a measurement schema
  - Updates a measurement [schema]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#schema).

Use this endpoint to update the fields (`name`, `type`, and `dataType`) of a
measurement schema.

#### Limitations

- You can't update the `name` of a measurement.

#### Related guides

- [Manage bucket schemas]({{% INFLUXDB_DOCS_URL %}}/organizations/buckets/bucket-schema/).
- [Using bucket schemas](https://www.influxdata.com/blog/new-bucket-schema-option-protect-from-unwanted-schema-changes/).

  - @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @param bucketID A bucket ID. Specifies the bucket to retrieve schemas for.
  - @param measurementID A measurement schema ID. Retrieves the specified measurement schema.
  - @return ApiUpdateMeasurementSchemaRequest
*/
func (a *BucketSchemasApiService) UpdateMeasurementSchema(ctx _context.Context, bucketID string, measurementID string) ApiUpdateMeasurementSchemaRequest {
	return ApiUpdateMeasurementSchemaRequest{
		ApiService:    a,
		ctx:           ctx,
		bucketID:      bucketID,
		measurementID: measurementID,
	}
}

/*
 * Execute executes the request
 * @return MeasurementSchema
 */
func (a *BucketSchemasApiService) UpdateMeasurementSchemaExecute(r ApiUpdateMeasurementSchemaRequest) (MeasurementSchema, error) {
	returnVal, _, err := a.UpdateMeasurementSchemaExecuteWithHttpInfo(r)
	return returnVal, err
}

/*
 * ExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not available on the
 * returned HTTP response as it will have already been read and closed; access to the response body content should be
 * achieved through the returned response model if applicable.
 * @return MeasurementSchema
 */
func (a *BucketSchemasApiService) UpdateMeasurementSchemaExecuteWithHttpInfo(r ApiUpdateMeasurementSchemaRequest) (MeasurementSchema, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPatch
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  MeasurementSchema
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "BucketSchemasApiService.UpdateMeasurementSchema")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v2/buckets/{bucketID}/schema/measurements/{measurementID}"
	localVarPath = strings.Replace(localVarPath, "{"+"bucketID"+"}", _neturl.PathEscape(parameterToString(r.bucketID, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"measurementID"+"}", _neturl.PathEscape(parameterToString(r.measurementID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.measurementSchemaUpdateRequest == nil {
		return localVarReturnValue, nil, reportError("measurementSchemaUpdateRequest is required and must be specified")
	}

	if r.org != nil {
		localVarQueryParams.Add("org", parameterToString(*r.org, ""))
	}
	if r.orgID != nil {
		localVarQueryParams.Add("orgID", parameterToString(*r.orgID, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.measurementSchemaUpdateRequest
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	newErr := GenericOpenAPIError{
		buildHeader: localVarHTTPResponse.Header.Get("X-Influxdb-Build"),
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.body = localVarBody
		newErr.error = localVarHTTPResponse.Status
		if localVarHTTPResponse.StatusCode == 400 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v UnauthorizedRequestError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	newErr.body = localVarBody
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
