#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 3408
#define LARGE_STATE_COUNT 576
#define SYMBOL_COUNT 326
#define ALIAS_COUNT 4
#define TOKEN_COUNT 111
#define EXTERNAL_TOKEN_COUNT 11
#define FIELD_COUNT 30
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 52

enum ts_symbol_identifiers {
  anon_sym_SEMI = 1,
  anon_sym_LBRACE = 2,
  anon_sym_RBRACE = 3,
  anon_sym_open = 4,
  anon_sym_BANG = 5,
  anon_sym_include = 6,
  anon_sym_LPAREN = 7,
  anon_sym_RPAREN = 8,
  anon_sym_COLON = 9,
  anon_sym_EQ = 10,
  anon_sym_await = 11,
  anon_sym_module = 12,
  anon_sym_rec = 13,
  anon_sym_type = 14,
  anon_sym_and = 15,
  anon_sym_unpack = 16,
  anon_sym_EQ_GT = 17,
  anon_sym_COMMA = 18,
  anon_sym_external = 19,
  anon_sym_exception = 20,
  anon_sym_export = 21,
  anon_sym_PLUS_EQ = 22,
  anon_sym_private = 23,
  anon_sym_LT = 24,
  anon_sym_PLUS = 25,
  anon_sym_DASH = 26,
  anon_sym_GT = 27,
  anon_sym_DOT = 28,
  anon_sym_constraint = 29,
  anon_sym_PIPE = 30,
  anon_sym_LBRACK = 31,
  anon_sym_LBRACK_GT = 32,
  anon_sym_LBRACK_LT = 33,
  anon_sym_RBRACK = 34,
  anon_sym_mutable = 35,
  anon_sym_QMARK = 36,
  anon_sym_DOT_DOT_DOT = 37,
  anon_sym_DOT_DOT = 38,
  anon_sym_let = 39,
  anon_sym_async = 40,
  anon_sym_if = 41,
  anon_sym_else = 42,
  anon_sym_switch = 43,
  anon_sym_when = 44,
  anon_sym_POUND = 45,
  anon_sym_try = 46,
  anon_sym_catch = 47,
  anon_sym_as = 48,
  anon_sym_assert = 49,
  anon_sym_DASH_GT = 50,
  anon_sym_PIPE_GT = 51,
  anon_sym_TILDE = 52,
  anon_sym_lazy = 53,
  anon_sym_SLASH = 54,
  anon_sym_COLON_EQ = 55,
  anon_sym_for = 56,
  anon_sym_in = 57,
  anon_sym_to = 58,
  anon_sym_downto = 59,
  anon_sym_while = 60,
  anon_sym_AMP_AMP = 61,
  anon_sym_PIPE_PIPE = 62,
  anon_sym_PLUS_PLUS = 63,
  anon_sym_PLUS_DOT = 64,
  anon_sym_DASH_DOT = 65,
  anon_sym_STAR = 66,
  anon_sym_STAR_DOT = 67,
  anon_sym_STAR_STAR = 68,
  anon_sym_SLASH_DOT = 69,
  anon_sym_LT_EQ = 70,
  anon_sym_EQ_EQ = 71,
  anon_sym_EQ_EQ_EQ = 72,
  anon_sym_BANG_EQ = 73,
  anon_sym_BANG_EQ_EQ = 74,
  anon_sym_GT_EQ = 75,
  anon_sym_COLON_GT = 76,
  anon_sym_PERCENT = 77,
  anon_sym_of = 78,
  anon_sym_with = 79,
  aux_sym_variant_identifier_token1 = 80,
  aux_sym_polyvar_identifier_token1 = 81,
  anon_sym_BSLASH = 82,
  aux_sym_type_identifier_token1 = 83,
  aux_sym_value_identifier_token1 = 84,
  sym__escape_identifier = 85,
  sym_extension_identifier = 86,
  sym_number = 87,
  sym_unit_type = 88,
  sym_true = 89,
  sym_false = 90,
  anon_sym_DQUOTE = 91,
  sym_unescaped_double_string_fragment = 92,
  sym_escape_sequence = 93,
  aux_sym_template_string_token1 = 94,
  anon_sym_BQUOTE = 95,
  aux_sym_template_string_content_token1 = 96,
  anon_sym_BSLASH_BQUOTE = 97,
  anon_sym_DOLLAR = 98,
  anon_sym_DOLLAR_LBRACE = 99,
  anon_sym_SQUOTE = 100,
  aux_sym_character_token1 = 101,
  sym__newline = 102,
  sym_comment = 103,
  sym__newline_and_comment = 104,
  sym__template_chars = 105,
  sym__lparen = 106,
  sym__rparen = 107,
  sym__list_constructor = 108,
  sym__decorator = 109,
  sym__decorator_inline = 110,
  sym_source_file = 111,
  sym__statement = 112,
  sym__statement_delimeter = 113,
  sym__one_or_more_statements = 114,
  sym_statement = 115,
  sym_block = 116,
  sym_open_statement = 117,
  sym_include_statement = 118,
  sym_declaration = 119,
  sym_module_binding = 120,
  sym_module_declaration = 121,
  sym__module_structure = 122,
  sym_module_unpack = 123,
  sym_functor = 124,
  sym_functor_parameters = 125,
  sym_functor_parameter = 126,
  sym_module_type_annotation = 127,
  sym_external_declaration = 128,
  sym_exception_declaration = 129,
  sym_type_declaration = 130,
  sym_type_binding = 131,
  sym_type_parameters = 132,
  sym_type_annotation = 133,
  sym__type = 134,
  sym__inline_type = 135,
  sym__non_function_inline_type = 136,
  sym_polymorphic_type = 137,
  sym_type_constraint = 138,
  sym_tuple_type = 139,
  sym_variant_type = 140,
  sym_variant_declaration = 141,
  sym_variant_parameters = 142,
  sym_polyvar_type = 143,
  sym_polyvar_declaration = 144,
  sym_polyvar_parameters = 145,
  sym_record_type = 146,
  sym_record_type_field = 147,
  sym_type_spread = 148,
  sym__record_type_member = 149,
  sym_object_type = 150,
  sym__object_type_member = 151,
  sym_object_type_field = 152,
  sym_generic_type = 153,
  sym_type_arguments = 154,
  sym_function_type = 155,
  sym_function_type_parameters = 156,
  sym__function_type_parameter_list = 157,
  sym_function_type_parameter = 158,
  sym_let_declaration = 159,
  sym_let_binding = 160,
  sym_expression_statement = 161,
  sym_expression = 162,
  sym_primary_expression = 163,
  sym_parenthesized_expression = 164,
  sym_value_identifier_path = 165,
  sym_function = 166,
  sym_record = 167,
  sym__record_element = 168,
  sym_record_field = 169,
  sym__record_pun_field = 170,
  sym__record_single_field = 171,
  sym__record_single_pun_field = 172,
  sym__record_field_name = 173,
  sym_object = 174,
  sym__object_field = 175,
  sym_object_field = 176,
  sym_tuple = 177,
  sym_array = 178,
  sym_list = 179,
  sym__list_element = 180,
  sym_if_expression = 181,
  sym_else_if_clause = 182,
  sym_else_clause = 183,
  sym_switch_expression = 184,
  sym_switch_match = 185,
  sym_guard = 186,
  sym_polyvar_type_pattern = 187,
  sym_try_expression = 188,
  sym_as_aliasing = 189,
  sym_as_aliasing_type = 190,
  sym__as_aliasing_non_function_inline_type = 191,
  sym_assert_expression = 192,
  sym_call_expression = 193,
  sym_pipe_expression = 194,
  sym_module_pack = 195,
  sym_call_arguments = 196,
  sym__call_argument = 197,
  sym_partial_application_spread = 198,
  sym_labeled_argument = 199,
  sym__definition_signature = 200,
  sym__return_type_annotation = 201,
  sym_formal_parameters = 202,
  sym_parameter = 203,
  sym_labeled_parameter = 204,
  sym_abstract_type = 205,
  sym__labeled_parameter_default_value = 206,
  sym__pattern = 207,
  sym_parenthesized_pattern = 208,
  sym_range_pattern = 209,
  sym_or_pattern = 210,
  sym_exception_pattern = 211,
  sym__destructuring_pattern = 212,
  sym__literal_pattern = 213,
  sym_variant_pattern = 214,
  sym__variant_pattern_parameters = 215,
  sym__variant_pattern_parameter = 216,
  sym_polyvar_pattern = 217,
  sym_record_pattern = 218,
  sym_tuple_item_pattern = 219,
  sym_tuple_pattern = 220,
  sym_array_pattern = 221,
  sym_list_pattern = 222,
  sym__collection_element_pattern = 223,
  sym_spread_pattern = 224,
  sym_lazy_pattern = 225,
  sym__jsx_element = 226,
  sym_jsx_element = 227,
  sym_jsx_fragment = 228,
  sym_jsx_expression = 229,
  sym__jsx_child = 230,
  sym_jsx_opening_element = 231,
  sym__jsx_identifier = 232,
  sym_nested_jsx_identifier = 233,
  sym__jsx_element_name = 234,
  sym_jsx_closing_element = 235,
  sym_jsx_self_closing_element = 236,
  sym__jsx_attribute_name = 237,
  sym__jsx_attribute = 238,
  sym_jsx_attribute = 239,
  sym__jsx_attribute_value = 240,
  sym_mutation_expression = 241,
  sym__mutation_lvalue = 242,
  sym_await_expression = 243,
  sym_decorator = 244,
  sym_decorator_arguments = 245,
  sym_subscript_expression = 246,
  sym_member_expression = 247,
  sym_spread_element = 248,
  sym_ternary_expression = 249,
  sym_for_expression = 250,
  sym_while_expression = 251,
  sym_lazy_expression = 252,
  sym_binary_expression = 253,
  sym_coercion_expression = 254,
  sym_unary_expression = 255,
  sym_extension_expression = 256,
  sym__extension_expression_payload = 257,
  sym_variant = 258,
  sym_nested_variant_identifier = 259,
  sym_variant_arguments = 260,
  sym_polyvar = 261,
  sym__type_identifier = 262,
  sym_type_identifier_path = 263,
  sym_module_expression = 264,
  sym_module_primary_expression = 265,
  sym_parenthesized_module_expression = 266,
  sym_module_identifier_path = 267,
  sym_module_type_of = 268,
  sym__module_type_constraint_with = 269,
  sym_module_type_constraint = 270,
  sym_constrain_module = 271,
  sym_constrain_type = 272,
  sym_functor_use = 273,
  sym_functor_arguments = 274,
  sym__functor_argument = 275,
  sym_variant_identifier = 276,
  sym_polyvar_identifier = 277,
  sym_type_identifier = 278,
  sym_value_identifier = 279,
  sym_module_identifier = 280,
  sym_unit = 281,
  sym_string = 282,
  sym_template_string = 283,
  sym_template_string_content = 284,
  sym_template_substitution = 285,
  sym_character = 286,
  sym_uncurry = 287,
  sym__reserved_identifier = 288,
  aux_sym_source_file_repeat1 = 289,
  aux_sym_source_file_repeat2 = 290,
  aux_sym_module_declaration_repeat1 = 291,
  aux_sym_functor_parameters_repeat1 = 292,
  aux_sym_type_declaration_repeat1 = 293,
  aux_sym_type_declaration_repeat2 = 294,
  aux_sym_type_binding_repeat1 = 295,
  aux_sym_type_parameters_repeat1 = 296,
  aux_sym_polymorphic_type_repeat1 = 297,
  aux_sym_tuple_type_repeat1 = 298,
  aux_sym_variant_type_repeat1 = 299,
  aux_sym_polyvar_type_repeat1 = 300,
  aux_sym_record_type_repeat1 = 301,
  aux_sym_object_type_repeat1 = 302,
  aux_sym__function_type_parameter_list_repeat1 = 303,
  aux_sym_let_declaration_repeat1 = 304,
  aux_sym_record_repeat1 = 305,
  aux_sym_object_repeat1 = 306,
  aux_sym_tuple_repeat1 = 307,
  aux_sym_list_repeat1 = 308,
  aux_sym_if_expression_repeat1 = 309,
  aux_sym_switch_expression_repeat1 = 310,
  aux_sym_call_arguments_repeat1 = 311,
  aux_sym_formal_parameters_repeat1 = 312,
  aux_sym__variant_pattern_parameters_repeat1 = 313,
  aux_sym_record_pattern_repeat1 = 314,
  aux_sym_tuple_pattern_repeat1 = 315,
  aux_sym_array_pattern_repeat1 = 316,
  aux_sym_jsx_element_repeat1 = 317,
  aux_sym_jsx_opening_element_repeat1 = 318,
  aux_sym_extension_expression_repeat1 = 319,
  aux_sym_variant_arguments_repeat1 = 320,
  aux_sym__module_type_constraint_with_repeat1 = 321,
  aux_sym_functor_arguments_repeat1 = 322,
  aux_sym_string_repeat1 = 323,
  aux_sym_template_string_content_repeat1 = 324,
  aux_sym_character_repeat1 = 325,
  alias_sym_jsx_identifier = 326,
  alias_sym_polyvar_string = 327,
  alias_sym_property_identifier = 328,
  alias_sym_sequence_expression = 329,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_SEMI] = ";",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_open] = "open",
  [anon_sym_BANG] = "!",
  [anon_sym_include] = "include",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_COLON] = ":",
  [anon_sym_EQ] = "=",
  [anon_sym_await] = "await",
  [anon_sym_module] = "module",
  [anon_sym_rec] = "rec",
  [anon_sym_type] = "type",
  [anon_sym_and] = "and",
  [anon_sym_unpack] = "unpack",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_COMMA] = ",",
  [anon_sym_external] = "external",
  [anon_sym_exception] = "exception",
  [anon_sym_export] = "export",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_private] = "private",
  [anon_sym_LT] = "<",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_GT] = ">",
  [anon_sym_DOT] = ".",
  [anon_sym_constraint] = "constraint",
  [anon_sym_PIPE] = "|",
  [anon_sym_LBRACK] = "[",
  [anon_sym_LBRACK_GT] = "[>",
  [anon_sym_LBRACK_LT] = "[<",
  [anon_sym_RBRACK] = "]",
  [anon_sym_mutable] = "mutable",
  [anon_sym_QMARK] = "\?",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_let] = "let",
  [anon_sym_async] = "async",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_switch] = "switch",
  [anon_sym_when] = "when",
  [anon_sym_POUND] = "#",
  [anon_sym_try] = "try",
  [anon_sym_catch] = "catch",
  [anon_sym_as] = "as",
  [anon_sym_assert] = "assert",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_PIPE_GT] = "|>",
  [anon_sym_TILDE] = "~",
  [anon_sym_lazy] = "lazy",
  [anon_sym_SLASH] = "/",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_to] = "to",
  [anon_sym_downto] = "downto",
  [anon_sym_while] = "while",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_PLUS_DOT] = "+.",
  [anon_sym_DASH_DOT] = "-.",
  [anon_sym_STAR] = "*",
  [anon_sym_STAR_DOT] = "*.",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_SLASH_DOT] = "/.",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_COLON_GT] = ":>",
  [anon_sym_PERCENT] = "%",
  [anon_sym_of] = "of",
  [anon_sym_with] = "with",
  [aux_sym_variant_identifier_token1] = "variant_identifier_token1",
  [aux_sym_polyvar_identifier_token1] = "polyvar_identifier_token1",
  [anon_sym_BSLASH] = "\\",
  [aux_sym_type_identifier_token1] = "type_identifier_token1",
  [aux_sym_value_identifier_token1] = "value_identifier_token1",
  [sym__escape_identifier] = "_escape_identifier",
  [sym_extension_identifier] = "extension_identifier",
  [sym_number] = "number",
  [sym_unit_type] = "unit_type",
  [sym_true] = "true",
  [sym_false] = "false",
  [anon_sym_DQUOTE] = "\"",
  [sym_unescaped_double_string_fragment] = "string_fragment",
  [sym_escape_sequence] = "escape_sequence",
  [aux_sym_template_string_token1] = "template_string_token1",
  [anon_sym_BQUOTE] = "`",
  [aux_sym_template_string_content_token1] = "template_string_content_token1",
  [anon_sym_BSLASH_BQUOTE] = "escape_sequence",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_character_token1] = "character_token1",
  [sym__newline] = "_newline",
  [sym_comment] = "comment",
  [sym__newline_and_comment] = "comment",
  [sym__template_chars] = "_template_chars",
  [sym__lparen] = "(",
  [sym__rparen] = ")",
  [sym__list_constructor] = "_list_constructor",
  [sym__decorator] = "decorator_identifier",
  [sym__decorator_inline] = "decorator_identifier",
  [sym_source_file] = "source_file",
  [sym__statement] = "_statement",
  [sym__statement_delimeter] = "_statement_delimeter",
  [sym__one_or_more_statements] = "_one_or_more_statements",
  [sym_statement] = "statement",
  [sym_block] = "block",
  [sym_open_statement] = "open_statement",
  [sym_include_statement] = "include_statement",
  [sym_declaration] = "declaration",
  [sym_module_binding] = "module_binding",
  [sym_module_declaration] = "module_declaration",
  [sym__module_structure] = "_module_structure",
  [sym_module_unpack] = "module_unpack",
  [sym_functor] = "functor",
  [sym_functor_parameters] = "functor_parameters",
  [sym_functor_parameter] = "functor_parameter",
  [sym_module_type_annotation] = "module_type_annotation",
  [sym_external_declaration] = "external_declaration",
  [sym_exception_declaration] = "exception_declaration",
  [sym_type_declaration] = "type_declaration",
  [sym_type_binding] = "type_binding",
  [sym_type_parameters] = "type_parameters",
  [sym_type_annotation] = "type_annotation",
  [sym__type] = "_type",
  [sym__inline_type] = "_inline_type",
  [sym__non_function_inline_type] = "_non_function_inline_type",
  [sym_polymorphic_type] = "polymorphic_type",
  [sym_type_constraint] = "type_constraint",
  [sym_tuple_type] = "tuple_type",
  [sym_variant_type] = "variant_type",
  [sym_variant_declaration] = "variant_declaration",
  [sym_variant_parameters] = "variant_parameters",
  [sym_polyvar_type] = "polyvar_type",
  [sym_polyvar_declaration] = "polyvar_declaration",
  [sym_polyvar_parameters] = "polyvar_parameters",
  [sym_record_type] = "record_type",
  [sym_record_type_field] = "record_type_field",
  [sym_type_spread] = "type_spread",
  [sym__record_type_member] = "_record_type_member",
  [sym_object_type] = "object_type",
  [sym__object_type_member] = "_object_type_member",
  [sym_object_type_field] = "field",
  [sym_generic_type] = "generic_type",
  [sym_type_arguments] = "type_arguments",
  [sym_function_type] = "function_type",
  [sym_function_type_parameters] = "function_type_parameters",
  [sym__function_type_parameter_list] = "_function_type_parameter_list",
  [sym_function_type_parameter] = "parameter",
  [sym_let_declaration] = "let_declaration",
  [sym_let_binding] = "let_binding",
  [sym_expression_statement] = "expression_statement",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_value_identifier_path] = "value_identifier_path",
  [sym_function] = "function",
  [sym_record] = "record",
  [sym__record_element] = "_record_element",
  [sym_record_field] = "record_field",
  [sym__record_pun_field] = "record_field",
  [sym__record_single_field] = "_record_single_field",
  [sym__record_single_pun_field] = "_record_single_pun_field",
  [sym__record_field_name] = "_record_field_name",
  [sym_object] = "object",
  [sym__object_field] = "_object_field",
  [sym_object_field] = "field",
  [sym_tuple] = "tuple",
  [sym_array] = "array",
  [sym_list] = "list",
  [sym__list_element] = "_list_element",
  [sym_if_expression] = "if_expression",
  [sym_else_if_clause] = "else_if_clause",
  [sym_else_clause] = "else_clause",
  [sym_switch_expression] = "switch_expression",
  [sym_switch_match] = "switch_match",
  [sym_guard] = "guard",
  [sym_polyvar_type_pattern] = "polyvar_type_pattern",
  [sym_try_expression] = "try_expression",
  [sym_as_aliasing] = "as_aliasing",
  [sym_as_aliasing_type] = "as_aliasing_type",
  [sym__as_aliasing_non_function_inline_type] = "as_aliasing_type",
  [sym_assert_expression] = "assert_expression",
  [sym_call_expression] = "call_expression",
  [sym_pipe_expression] = "pipe_expression",
  [sym_module_pack] = "module_pack",
  [sym_call_arguments] = "arguments",
  [sym__call_argument] = "_call_argument",
  [sym_partial_application_spread] = "partial_application_spread",
  [sym_labeled_argument] = "labeled_argument",
  [sym__definition_signature] = "_definition_signature",
  [sym__return_type_annotation] = "type_annotation",
  [sym_formal_parameters] = "formal_parameters",
  [sym_parameter] = "parameter",
  [sym_labeled_parameter] = "labeled_parameter",
  [sym_abstract_type] = "abstract_type",
  [sym__labeled_parameter_default_value] = "_labeled_parameter_default_value",
  [sym__pattern] = "_pattern",
  [sym_parenthesized_pattern] = "parenthesized_pattern",
  [sym_range_pattern] = "range_pattern",
  [sym_or_pattern] = "or_pattern",
  [sym_exception_pattern] = "exception_pattern",
  [sym__destructuring_pattern] = "_destructuring_pattern",
  [sym__literal_pattern] = "_literal_pattern",
  [sym_variant_pattern] = "variant_pattern",
  [sym__variant_pattern_parameters] = "formal_parameters",
  [sym__variant_pattern_parameter] = "_variant_pattern_parameter",
  [sym_polyvar_pattern] = "polyvar_pattern",
  [sym_record_pattern] = "record_pattern",
  [sym_tuple_item_pattern] = "tuple_item_pattern",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym_array_pattern] = "array_pattern",
  [sym_list_pattern] = "list_pattern",
  [sym__collection_element_pattern] = "_collection_element_pattern",
  [sym_spread_pattern] = "spread_pattern",
  [sym_lazy_pattern] = "lazy_pattern",
  [sym__jsx_element] = "_jsx_element",
  [sym_jsx_element] = "jsx_element",
  [sym_jsx_fragment] = "jsx_fragment",
  [sym_jsx_expression] = "jsx_expression",
  [sym__jsx_child] = "_jsx_child",
  [sym_jsx_opening_element] = "jsx_opening_element",
  [sym__jsx_identifier] = "_jsx_identifier",
  [sym_nested_jsx_identifier] = "nested_jsx_identifier",
  [sym__jsx_element_name] = "_jsx_element_name",
  [sym_jsx_closing_element] = "jsx_closing_element",
  [sym_jsx_self_closing_element] = "jsx_self_closing_element",
  [sym__jsx_attribute_name] = "_jsx_attribute_name",
  [sym__jsx_attribute] = "_jsx_attribute",
  [sym_jsx_attribute] = "jsx_attribute",
  [sym__jsx_attribute_value] = "_jsx_attribute_value",
  [sym_mutation_expression] = "mutation_expression",
  [sym__mutation_lvalue] = "_mutation_lvalue",
  [sym_await_expression] = "await_expression",
  [sym_decorator] = "decorator",
  [sym_decorator_arguments] = "decorator_arguments",
  [sym_subscript_expression] = "subscript_expression",
  [sym_member_expression] = "member_expression",
  [sym_spread_element] = "spread_element",
  [sym_ternary_expression] = "ternary_expression",
  [sym_for_expression] = "for_expression",
  [sym_while_expression] = "while_expression",
  [sym_lazy_expression] = "lazy_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_coercion_expression] = "coercion_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_extension_expression] = "extension_expression",
  [sym__extension_expression_payload] = "_extension_expression_payload",
  [sym_variant] = "variant",
  [sym_nested_variant_identifier] = "nested_variant_identifier",
  [sym_variant_arguments] = "arguments",
  [sym_polyvar] = "polyvar",
  [sym__type_identifier] = "_type_identifier",
  [sym_type_identifier_path] = "type_identifier_path",
  [sym_module_expression] = "module_expression",
  [sym_module_primary_expression] = "module_primary_expression",
  [sym_parenthesized_module_expression] = "parenthesized_module_expression",
  [sym_module_identifier_path] = "module_identifier_path",
  [sym_module_type_of] = "module_type_of",
  [sym__module_type_constraint_with] = "_module_type_constraint_with",
  [sym_module_type_constraint] = "module_type_constraint",
  [sym_constrain_module] = "constrain_module",
  [sym_constrain_type] = "constrain_type",
  [sym_functor_use] = "functor_use",
  [sym_functor_arguments] = "arguments",
  [sym__functor_argument] = "_functor_argument",
  [sym_variant_identifier] = "variant_identifier",
  [sym_polyvar_identifier] = "polyvar_identifier",
  [sym_type_identifier] = "type_identifier",
  [sym_value_identifier] = "value_identifier",
  [sym_module_identifier] = "module_identifier",
  [sym_unit] = "unit",
  [sym_string] = "string",
  [sym_template_string] = "template_string",
  [sym_template_string_content] = "template_string_content",
  [sym_template_substitution] = "template_substitution",
  [sym_character] = "character",
  [sym_uncurry] = "uncurry",
  [sym__reserved_identifier] = "_reserved_identifier",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_source_file_repeat2] = "source_file_repeat2",
  [aux_sym_module_declaration_repeat1] = "module_declaration_repeat1",
  [aux_sym_functor_parameters_repeat1] = "functor_parameters_repeat1",
  [aux_sym_type_declaration_repeat1] = "type_declaration_repeat1",
  [aux_sym_type_declaration_repeat2] = "type_declaration_repeat2",
  [aux_sym_type_binding_repeat1] = "type_binding_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_polymorphic_type_repeat1] = "polymorphic_type_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [aux_sym_variant_type_repeat1] = "variant_type_repeat1",
  [aux_sym_polyvar_type_repeat1] = "polyvar_type_repeat1",
  [aux_sym_record_type_repeat1] = "record_type_repeat1",
  [aux_sym_object_type_repeat1] = "object_type_repeat1",
  [aux_sym__function_type_parameter_list_repeat1] = "_function_type_parameter_list_repeat1",
  [aux_sym_let_declaration_repeat1] = "let_declaration_repeat1",
  [aux_sym_record_repeat1] = "record_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym_tuple_repeat1] = "tuple_repeat1",
  [aux_sym_list_repeat1] = "list_repeat1",
  [aux_sym_if_expression_repeat1] = "if_expression_repeat1",
  [aux_sym_switch_expression_repeat1] = "switch_expression_repeat1",
  [aux_sym_call_arguments_repeat1] = "call_arguments_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [aux_sym__variant_pattern_parameters_repeat1] = "_variant_pattern_parameters_repeat1",
  [aux_sym_record_pattern_repeat1] = "record_pattern_repeat1",
  [aux_sym_tuple_pattern_repeat1] = "tuple_pattern_repeat1",
  [aux_sym_array_pattern_repeat1] = "array_pattern_repeat1",
  [aux_sym_jsx_element_repeat1] = "jsx_element_repeat1",
  [aux_sym_jsx_opening_element_repeat1] = "jsx_opening_element_repeat1",
  [aux_sym_extension_expression_repeat1] = "extension_expression_repeat1",
  [aux_sym_variant_arguments_repeat1] = "variant_arguments_repeat1",
  [aux_sym__module_type_constraint_with_repeat1] = "_module_type_constraint_with_repeat1",
  [aux_sym_functor_arguments_repeat1] = "functor_arguments_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_template_string_content_repeat1] = "template_string_content_repeat1",
  [aux_sym_character_repeat1] = "character_repeat1",
  [alias_sym_jsx_identifier] = "jsx_identifier",
  [alias_sym_polyvar_string] = "polyvar_string",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_sequence_expression] = "sequence_expression",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_open] = anon_sym_open,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_include] = anon_sym_include,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_rec] = anon_sym_rec,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_unpack] = anon_sym_unpack,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_external] = anon_sym_external,
  [anon_sym_exception] = anon_sym_exception,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_constraint] = anon_sym_constraint,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_LBRACK_GT] = anon_sym_LBRACK_GT,
  [anon_sym_LBRACK_LT] = anon_sym_LBRACK_LT,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_mutable] = anon_sym_mutable,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_when] = anon_sym_when,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_PIPE_GT] = anon_sym_PIPE_GT,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_lazy] = anon_sym_lazy,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_to] = anon_sym_to,
  [anon_sym_downto] = anon_sym_downto,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_PLUS_DOT] = anon_sym_PLUS_DOT,
  [anon_sym_DASH_DOT] = anon_sym_DASH_DOT,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_STAR_DOT] = anon_sym_STAR_DOT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_SLASH_DOT] = anon_sym_SLASH_DOT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_COLON_GT] = anon_sym_COLON_GT,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_with] = anon_sym_with,
  [aux_sym_variant_identifier_token1] = aux_sym_variant_identifier_token1,
  [aux_sym_polyvar_identifier_token1] = aux_sym_polyvar_identifier_token1,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [aux_sym_type_identifier_token1] = aux_sym_type_identifier_token1,
  [aux_sym_value_identifier_token1] = aux_sym_value_identifier_token1,
  [sym__escape_identifier] = sym__escape_identifier,
  [sym_extension_identifier] = sym_extension_identifier,
  [sym_number] = sym_number,
  [sym_unit_type] = sym_unit_type,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [sym_unescaped_double_string_fragment] = sym_unescaped_double_string_fragment,
  [sym_escape_sequence] = sym_escape_sequence,
  [aux_sym_template_string_token1] = aux_sym_template_string_token1,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [aux_sym_template_string_content_token1] = aux_sym_template_string_content_token1,
  [anon_sym_BSLASH_BQUOTE] = sym_escape_sequence,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_character_token1] = aux_sym_character_token1,
  [sym__newline] = sym__newline,
  [sym_comment] = sym_comment,
  [sym__newline_and_comment] = sym_comment,
  [sym__template_chars] = sym__template_chars,
  [sym__lparen] = anon_sym_LPAREN,
  [sym__rparen] = anon_sym_RPAREN,
  [sym__list_constructor] = sym__list_constructor,
  [sym__decorator] = sym__decorator,
  [sym__decorator_inline] = sym__decorator,
  [sym_source_file] = sym_source_file,
  [sym__statement] = sym__statement,
  [sym__statement_delimeter] = sym__statement_delimeter,
  [sym__one_or_more_statements] = sym__one_or_more_statements,
  [sym_statement] = sym_statement,
  [sym_block] = sym_block,
  [sym_open_statement] = sym_open_statement,
  [sym_include_statement] = sym_include_statement,
  [sym_declaration] = sym_declaration,
  [sym_module_binding] = sym_module_binding,
  [sym_module_declaration] = sym_module_declaration,
  [sym__module_structure] = sym__module_structure,
  [sym_module_unpack] = sym_module_unpack,
  [sym_functor] = sym_functor,
  [sym_functor_parameters] = sym_functor_parameters,
  [sym_functor_parameter] = sym_functor_parameter,
  [sym_module_type_annotation] = sym_module_type_annotation,
  [sym_external_declaration] = sym_external_declaration,
  [sym_exception_declaration] = sym_exception_declaration,
  [sym_type_declaration] = sym_type_declaration,
  [sym_type_binding] = sym_type_binding,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_annotation] = sym_type_annotation,
  [sym__type] = sym__type,
  [sym__inline_type] = sym__inline_type,
  [sym__non_function_inline_type] = sym__non_function_inline_type,
  [sym_polymorphic_type] = sym_polymorphic_type,
  [sym_type_constraint] = sym_type_constraint,
  [sym_tuple_type] = sym_tuple_type,
  [sym_variant_type] = sym_variant_type,
  [sym_variant_declaration] = sym_variant_declaration,
  [sym_variant_parameters] = sym_variant_parameters,
  [sym_polyvar_type] = sym_polyvar_type,
  [sym_polyvar_declaration] = sym_polyvar_declaration,
  [sym_polyvar_parameters] = sym_polyvar_parameters,
  [sym_record_type] = sym_record_type,
  [sym_record_type_field] = sym_record_type_field,
  [sym_type_spread] = sym_type_spread,
  [sym__record_type_member] = sym__record_type_member,
  [sym_object_type] = sym_object_type,
  [sym__object_type_member] = sym__object_type_member,
  [sym_object_type_field] = sym_object_type_field,
  [sym_generic_type] = sym_generic_type,
  [sym_type_arguments] = sym_type_arguments,
  [sym_function_type] = sym_function_type,
  [sym_function_type_parameters] = sym_function_type_parameters,
  [sym__function_type_parameter_list] = sym__function_type_parameter_list,
  [sym_function_type_parameter] = sym_parameter,
  [sym_let_declaration] = sym_let_declaration,
  [sym_let_binding] = sym_let_binding,
  [sym_expression_statement] = sym_expression_statement,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_value_identifier_path] = sym_value_identifier_path,
  [sym_function] = sym_function,
  [sym_record] = sym_record,
  [sym__record_element] = sym__record_element,
  [sym_record_field] = sym_record_field,
  [sym__record_pun_field] = sym_record_field,
  [sym__record_single_field] = sym__record_single_field,
  [sym__record_single_pun_field] = sym__record_single_pun_field,
  [sym__record_field_name] = sym__record_field_name,
  [sym_object] = sym_object,
  [sym__object_field] = sym__object_field,
  [sym_object_field] = sym_object_type_field,
  [sym_tuple] = sym_tuple,
  [sym_array] = sym_array,
  [sym_list] = sym_list,
  [sym__list_element] = sym__list_element,
  [sym_if_expression] = sym_if_expression,
  [sym_else_if_clause] = sym_else_if_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_switch_expression] = sym_switch_expression,
  [sym_switch_match] = sym_switch_match,
  [sym_guard] = sym_guard,
  [sym_polyvar_type_pattern] = sym_polyvar_type_pattern,
  [sym_try_expression] = sym_try_expression,
  [sym_as_aliasing] = sym_as_aliasing,
  [sym_as_aliasing_type] = sym_as_aliasing_type,
  [sym__as_aliasing_non_function_inline_type] = sym_as_aliasing_type,
  [sym_assert_expression] = sym_assert_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_pipe_expression] = sym_pipe_expression,
  [sym_module_pack] = sym_module_pack,
  [sym_call_arguments] = sym_call_arguments,
  [sym__call_argument] = sym__call_argument,
  [sym_partial_application_spread] = sym_partial_application_spread,
  [sym_labeled_argument] = sym_labeled_argument,
  [sym__definition_signature] = sym__definition_signature,
  [sym__return_type_annotation] = sym_type_annotation,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_parameter] = sym_parameter,
  [sym_labeled_parameter] = sym_labeled_parameter,
  [sym_abstract_type] = sym_abstract_type,
  [sym__labeled_parameter_default_value] = sym__labeled_parameter_default_value,
  [sym__pattern] = sym__pattern,
  [sym_parenthesized_pattern] = sym_parenthesized_pattern,
  [sym_range_pattern] = sym_range_pattern,
  [sym_or_pattern] = sym_or_pattern,
  [sym_exception_pattern] = sym_exception_pattern,
  [sym__destructuring_pattern] = sym__destructuring_pattern,
  [sym__literal_pattern] = sym__literal_pattern,
  [sym_variant_pattern] = sym_variant_pattern,
  [sym__variant_pattern_parameters] = sym_formal_parameters,
  [sym__variant_pattern_parameter] = sym__variant_pattern_parameter,
  [sym_polyvar_pattern] = sym_polyvar_pattern,
  [sym_record_pattern] = sym_record_pattern,
  [sym_tuple_item_pattern] = sym_tuple_item_pattern,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym_array_pattern] = sym_array_pattern,
  [sym_list_pattern] = sym_list_pattern,
  [sym__collection_element_pattern] = sym__collection_element_pattern,
  [sym_spread_pattern] = sym_spread_pattern,
  [sym_lazy_pattern] = sym_lazy_pattern,
  [sym__jsx_element] = sym__jsx_element,
  [sym_jsx_element] = sym_jsx_element,
  [sym_jsx_fragment] = sym_jsx_fragment,
  [sym_jsx_expression] = sym_jsx_expression,
  [sym__jsx_child] = sym__jsx_child,
  [sym_jsx_opening_element] = sym_jsx_opening_element,
  [sym__jsx_identifier] = sym__jsx_identifier,
  [sym_nested_jsx_identifier] = sym_nested_jsx_identifier,
  [sym__jsx_element_name] = sym__jsx_element_name,
  [sym_jsx_closing_element] = sym_jsx_closing_element,
  [sym_jsx_self_closing_element] = sym_jsx_self_closing_element,
  [sym__jsx_attribute_name] = sym__jsx_attribute_name,
  [sym__jsx_attribute] = sym__jsx_attribute,
  [sym_jsx_attribute] = sym_jsx_attribute,
  [sym__jsx_attribute_value] = sym__jsx_attribute_value,
  [sym_mutation_expression] = sym_mutation_expression,
  [sym__mutation_lvalue] = sym__mutation_lvalue,
  [sym_await_expression] = sym_await_expression,
  [sym_decorator] = sym_decorator,
  [sym_decorator_arguments] = sym_decorator_arguments,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_spread_element] = sym_spread_element,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_for_expression] = sym_for_expression,
  [sym_while_expression] = sym_while_expression,
  [sym_lazy_expression] = sym_lazy_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_coercion_expression] = sym_coercion_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_extension_expression] = sym_extension_expression,
  [sym__extension_expression_payload] = sym__extension_expression_payload,
  [sym_variant] = sym_variant,
  [sym_nested_variant_identifier] = sym_nested_variant_identifier,
  [sym_variant_arguments] = sym_call_arguments,
  [sym_polyvar] = sym_polyvar,
  [sym__type_identifier] = sym__type_identifier,
  [sym_type_identifier_path] = sym_type_identifier_path,
  [sym_module_expression] = sym_module_expression,
  [sym_module_primary_expression] = sym_module_primary_expression,
  [sym_parenthesized_module_expression] = sym_parenthesized_module_expression,
  [sym_module_identifier_path] = sym_module_identifier_path,
  [sym_module_type_of] = sym_module_type_of,
  [sym__module_type_constraint_with] = sym__module_type_constraint_with,
  [sym_module_type_constraint] = sym_module_type_constraint,
  [sym_constrain_module] = sym_constrain_module,
  [sym_constrain_type] = sym_constrain_type,
  [sym_functor_use] = sym_functor_use,
  [sym_functor_arguments] = sym_call_arguments,
  [sym__functor_argument] = sym__functor_argument,
  [sym_variant_identifier] = sym_variant_identifier,
  [sym_polyvar_identifier] = sym_polyvar_identifier,
  [sym_type_identifier] = sym_type_identifier,
  [sym_value_identifier] = sym_value_identifier,
  [sym_module_identifier] = sym_module_identifier,
  [sym_unit] = sym_unit,
  [sym_string] = sym_string,
  [sym_template_string] = sym_template_string,
  [sym_template_string_content] = sym_template_string_content,
  [sym_template_substitution] = sym_template_substitution,
  [sym_character] = sym_character,
  [sym_uncurry] = sym_uncurry,
  [sym__reserved_identifier] = sym__reserved_identifier,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_source_file_repeat2] = aux_sym_source_file_repeat2,
  [aux_sym_module_declaration_repeat1] = aux_sym_module_declaration_repeat1,
  [aux_sym_functor_parameters_repeat1] = aux_sym_functor_parameters_repeat1,
  [aux_sym_type_declaration_repeat1] = aux_sym_type_declaration_repeat1,
  [aux_sym_type_declaration_repeat2] = aux_sym_type_declaration_repeat2,
  [aux_sym_type_binding_repeat1] = aux_sym_type_binding_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_polymorphic_type_repeat1] = aux_sym_polymorphic_type_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [aux_sym_variant_type_repeat1] = aux_sym_variant_type_repeat1,
  [aux_sym_polyvar_type_repeat1] = aux_sym_polyvar_type_repeat1,
  [aux_sym_record_type_repeat1] = aux_sym_record_type_repeat1,
  [aux_sym_object_type_repeat1] = aux_sym_object_type_repeat1,
  [aux_sym__function_type_parameter_list_repeat1] = aux_sym__function_type_parameter_list_repeat1,
  [aux_sym_let_declaration_repeat1] = aux_sym_let_declaration_repeat1,
  [aux_sym_record_repeat1] = aux_sym_record_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym_tuple_repeat1] = aux_sym_tuple_repeat1,
  [aux_sym_list_repeat1] = aux_sym_list_repeat1,
  [aux_sym_if_expression_repeat1] = aux_sym_if_expression_repeat1,
  [aux_sym_switch_expression_repeat1] = aux_sym_switch_expression_repeat1,
  [aux_sym_call_arguments_repeat1] = aux_sym_call_arguments_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [aux_sym__variant_pattern_parameters_repeat1] = aux_sym__variant_pattern_parameters_repeat1,
  [aux_sym_record_pattern_repeat1] = aux_sym_record_pattern_repeat1,
  [aux_sym_tuple_pattern_repeat1] = aux_sym_tuple_pattern_repeat1,
  [aux_sym_array_pattern_repeat1] = aux_sym_array_pattern_repeat1,
  [aux_sym_jsx_element_repeat1] = aux_sym_jsx_element_repeat1,
  [aux_sym_jsx_opening_element_repeat1] = aux_sym_jsx_opening_element_repeat1,
  [aux_sym_extension_expression_repeat1] = aux_sym_extension_expression_repeat1,
  [aux_sym_variant_arguments_repeat1] = aux_sym_variant_arguments_repeat1,
  [aux_sym__module_type_constraint_with_repeat1] = aux_sym__module_type_constraint_with_repeat1,
  [aux_sym_functor_arguments_repeat1] = aux_sym_functor_arguments_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_template_string_content_repeat1] = aux_sym_template_string_content_repeat1,
  [aux_sym_character_repeat1] = aux_sym_character_repeat1,
  [alias_sym_jsx_identifier] = alias_sym_jsx_identifier,
  [alias_sym_polyvar_string] = alias_sym_polyvar_string,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_sequence_expression] = alias_sym_sequence_expression,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_open] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_include] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unpack] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_external] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exception] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_constraint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mutable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_when] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lazy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_to] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_downto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_variant_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_polyvar_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_value_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__escape_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_extension_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_unit_type] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_template_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_template_string_content_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_BSLASH_BQUOTE] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_character_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__newline] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__newline_and_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__template_chars] = {
    .visible = false,
    .named = true,
  },
  [sym__lparen] = {
    .visible = true,
    .named = false,
  },
  [sym__rparen] = {
    .visible = true,
    .named = false,
  },
  [sym__list_constructor] = {
    .visible = false,
    .named = true,
  },
  [sym__decorator] = {
    .visible = true,
    .named = true,
  },
  [sym__decorator_inline] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym__statement_delimeter] = {
    .visible = false,
    .named = true,
  },
  [sym__one_or_more_statements] = {
    .visible = false,
    .named = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_open_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_include_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_module_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_module_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__module_structure] = {
    .visible = false,
    .named = true,
  },
  [sym_module_unpack] = {
    .visible = true,
    .named = true,
  },
  [sym_functor] = {
    .visible = true,
    .named = true,
  },
  [sym_functor_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_functor_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_module_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_external_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_exception_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__inline_type] = {
    .visible = false,
    .named = true,
  },
  [sym__non_function_inline_type] = {
    .visible = false,
    .named = true,
  },
  [sym_polymorphic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_variant_type] = {
    .visible = true,
    .named = true,
  },
  [sym_variant_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variant_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_polyvar_type] = {
    .visible = true,
    .named = true,
  },
  [sym_polyvar_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_polyvar_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_record_type] = {
    .visible = true,
    .named = true,
  },
  [sym_record_type_field] = {
    .visible = true,
    .named = true,
  },
  [sym_type_spread] = {
    .visible = true,
    .named = true,
  },
  [sym__record_type_member] = {
    .visible = false,
    .named = true,
  },
  [sym_object_type] = {
    .visible = true,
    .named = true,
  },
  [sym__object_type_member] = {
    .visible = false,
    .named = true,
  },
  [sym_object_type_field] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym__function_type_parameter_list] = {
    .visible = false,
    .named = true,
  },
  [sym_function_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_let_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_let_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_value_identifier_path] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_record] = {
    .visible = true,
    .named = true,
  },
  [sym__record_element] = {
    .visible = false,
    .named = true,
  },
  [sym_record_field] = {
    .visible = true,
    .named = true,
  },
  [sym__record_pun_field] = {
    .visible = true,
    .named = true,
  },
  [sym__record_single_field] = {
    .visible = false,
    .named = true,
  },
  [sym__record_single_pun_field] = {
    .visible = false,
    .named = true,
  },
  [sym__record_field_name] = {
    .visible = false,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym__object_field] = {
    .visible = false,
    .named = true,
  },
  [sym_object_field] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym__list_element] = {
    .visible = false,
    .named = true,
  },
  [sym_if_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_else_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_match] = {
    .visible = true,
    .named = true,
  },
  [sym_guard] = {
    .visible = true,
    .named = true,
  },
  [sym_polyvar_type_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_try_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_as_aliasing] = {
    .visible = true,
    .named = true,
  },
  [sym_as_aliasing_type] = {
    .visible = true,
    .named = true,
  },
  [sym__as_aliasing_non_function_inline_type] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_pipe_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_module_pack] = {
    .visible = true,
    .named = true,
  },
  [sym_call_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym__call_argument] = {
    .visible = false,
    .named = true,
  },
  [sym_partial_application_spread] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__definition_signature] = {
    .visible = false,
    .named = true,
  },
  [sym__return_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_type] = {
    .visible = true,
    .named = true,
  },
  [sym__labeled_parameter_default_value] = {
    .visible = false,
    .named = true,
  },
  [sym__pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesized_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_range_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_or_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_exception_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__destructuring_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym__literal_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_variant_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__variant_pattern_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym__variant_pattern_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym_polyvar_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_record_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_item_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_array_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__collection_element_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_spread_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_lazy_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__jsx_element] = {
    .visible = false,
    .named = true,
  },
  [sym_jsx_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__jsx_child] = {
    .visible = false,
    .named = true,
  },
  [sym_jsx_opening_element] = {
    .visible = true,
    .named = true,
  },
  [sym__jsx_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_nested_jsx_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__jsx_element_name] = {
    .visible = false,
    .named = true,
  },
  [sym_jsx_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_self_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym__jsx_attribute_name] = {
    .visible = false,
    .named = true,
  },
  [sym__jsx_attribute] = {
    .visible = false,
    .named = true,
  },
  [sym_jsx_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym__jsx_attribute_value] = {
    .visible = false,
    .named = true,
  },
  [sym_mutation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__mutation_lvalue] = {
    .visible = false,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_spread_element] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_for_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_while_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_lazy_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_coercion_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_extension_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__extension_expression_payload] = {
    .visible = false,
    .named = true,
  },
  [sym_variant] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_variant_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_variant_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_polyvar] = {
    .visible = true,
    .named = true,
  },
  [sym__type_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_type_identifier_path] = {
    .visible = true,
    .named = true,
  },
  [sym_module_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_module_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_parenthesized_module_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_module_identifier_path] = {
    .visible = true,
    .named = true,
  },
  [sym_module_type_of] = {
    .visible = true,
    .named = true,
  },
  [sym__module_type_constraint_with] = {
    .visible = false,
    .named = true,
  },
  [sym_module_type_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_constrain_module] = {
    .visible = true,
    .named = true,
  },
  [sym_constrain_type] = {
    .visible = true,
    .named = true,
  },
  [sym_functor_use] = {
    .visible = true,
    .named = true,
  },
  [sym_functor_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym__functor_argument] = {
    .visible = false,
    .named = true,
  },
  [sym_variant_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_polyvar_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_value_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_module_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_unit] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_string_content] = {
    .visible = true,
    .named = true,
  },
  [sym_template_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_character] = {
    .visible = true,
    .named = true,
  },
  [sym_uncurry] = {
    .visible = true,
    .named = true,
  },
  [sym__reserved_identifier] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_source_file_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_functor_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_declaration_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_binding_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_polymorphic_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variant_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_polyvar_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__function_type_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_let_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_call_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__variant_pattern_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_jsx_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_jsx_opening_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extension_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variant_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__module_type_constraint_with_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_functor_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_string_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_character_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_jsx_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_polyvar_string] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_sequence_expression] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alternative = 1,
  field_argument = 2,
  field_arguments = 3,
  field_attribute = 4,
  field_body = 5,
  field_close_tag = 6,
  field_condition = 7,
  field_consequence = 8,
  field_default_value = 9,
  field_definition = 10,
  field_function = 11,
  field_index = 12,
  field_label = 13,
  field_left = 14,
  field_module = 15,
  field_name = 16,
  field_object = 17,
  field_open_tag = 18,
  field_operator = 19,
  field_parameter = 20,
  field_parameters = 21,
  field_pattern = 22,
  field_property = 23,
  field_record = 24,
  field_return_module_type = 25,
  field_return_type = 26,
  field_right = 27,
  field_signature = 28,
  field_type = 29,
  field_value = 30,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_body] = "body",
  [field_close_tag] = "close_tag",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_default_value] = "default_value",
  [field_definition] = "definition",
  [field_function] = "function",
  [field_index] = "index",
  [field_label] = "label",
  [field_left] = "left",
  [field_module] = "module",
  [field_name] = "name",
  [field_object] = "object",
  [field_open_tag] = "open_tag",
  [field_operator] = "operator",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_property] = "property",
  [field_record] = "record",
  [field_return_module_type] = "return_module_type",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_signature] = "signature",
  [field_type] = "type",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 2},
  [4] = {.index = 3, .length = 1},
  [7] = {.index = 4, .length = 2},
  [8] = {.index = 6, .length = 2},
  [9] = {.index = 8, .length = 2},
  [10] = {.index = 10, .length = 1},
  [11] = {.index = 11, .length = 1},
  [12] = {.index = 12, .length = 1},
  [14] = {.index = 13, .length = 3},
  [15] = {.index = 16, .length = 2},
  [16] = {.index = 18, .length = 3},
  [17] = {.index = 21, .length = 2},
  [18] = {.index = 23, .length = 2},
  [19] = {.index = 25, .length = 2},
  [20] = {.index = 27, .length = 1},
  [21] = {.index = 28, .length = 2},
  [22] = {.index = 30, .length = 2},
  [23] = {.index = 32, .length = 2},
  [24] = {.index = 34, .length = 2},
  [25] = {.index = 36, .length = 2},
  [26] = {.index = 38, .length = 2},
  [27] = {.index = 40, .length = 3},
  [28] = {.index = 43, .length = 2},
  [29] = {.index = 45, .length = 1},
  [30] = {.index = 46, .length = 2},
  [31] = {.index = 48, .length = 3},
  [32] = {.index = 51, .length = 1},
  [33] = {.index = 52, .length = 2},
  [34] = {.index = 54, .length = 2},
  [35] = {.index = 56, .length = 2},
  [36] = {.index = 58, .length = 3},
  [37] = {.index = 61, .length = 3},
  [38] = {.index = 64, .length = 1},
  [39] = {.index = 65, .length = 1},
  [40] = {.index = 66, .length = 3},
  [41] = {.index = 69, .length = 2},
  [42] = {.index = 71, .length = 2},
  [43] = {.index = 73, .length = 3},
  [45] = {.index = 76, .length = 2},
  [46] = {.index = 78, .length = 2},
  [47] = {.index = 80, .length = 2},
  [48] = {.index = 82, .length = 3},
  [49] = {.index = 85, .length = 2},
  [50] = {.index = 87, .length = 2},
  [51] = {.index = 89, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_parameters, 0},
  [1] =
    {field_argument, 1},
    {field_operator, 0},
  [3] =
    {field_name, 0},
  [4] =
    {field_arguments, 1},
    {field_function, 0},
  [6] =
    {field_parameters, 0},
    {field_return_type, 1},
  [8] =
    {field_close_tag, 1},
    {field_open_tag, 0},
  [10] =
    {field_pattern, 0},
  [11] =
    {field_name, 1},
  [12] =
    {field_attribute, 0},
  [13] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [16] =
    {field_property, 2},
    {field_record, 0},
  [18] =
    {field_body, 2},
    {field_parameters, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
  [21] =
    {field_close_tag, 2},
    {field_open_tag, 0},
  [23] =
    {field_body, 2},
    {field_parameter, 0},
  [25] =
    {field_body, 2},
    {field_parameters, 0},
  [27] =
    {field_default_value, 2},
  [28] =
    {field_name, 0},
    {field_signature, 2},
  [30] =
    {field_definition, 2},
    {field_name, 0},
  [32] =
    {field_body, 2},
    {field_name, 0},
  [34] =
    {field_body, 2},
    {field_pattern, 0},
  [36] =
    {field_attribute, 2, .inherited = true},
    {field_name, 1},
  [38] =
    {field_attribute, 0, .inherited = true},
    {field_attribute, 1, .inherited = true},
  [40] =
    {field_body, 3},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
  [43] =
    {field_body, 3},
    {field_parameter, 1},
  [45] =
    {field_label, 1},
  [46] =
    {field_index, 2},
    {field_object, 0},
  [48] =
    {field_body, 3},
    {field_parameters, 0},
    {field_return_module_type, 1},
  [51] =
    {field_default_value, 3},
  [52] =
    {field_definition, 3},
    {field_name, 0},
  [54] =
    {field_body, 3},
    {field_name, 0},
  [56] =
    {field_body, 3},
    {field_pattern, 0},
  [58] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [61] =
    {field_module, 2},
    {field_property, 4},
    {field_record, 0},
  [64] =
    {field_name, 2},
  [65] =
    {field_default_value, 4},
  [66] =
    {field_definition, 4},
    {field_name, 0},
    {field_signature, 2},
  [69] =
    {field_body, 4},
    {field_name, 0},
  [71] =
    {field_label, 1},
    {field_value, 3},
  [73] =
    {field_definition, 5},
    {field_name, 0},
    {field_signature, 2},
  [76] =
    {field_body, 5},
    {field_name, 0},
  [78] =
    {field_body, 3},
    {field_pattern, 1},
  [80] =
    {field_label, 1},
    {field_value, 4},
  [82] =
    {field_label, 1},
    {field_type, 4},
    {field_value, 3},
  [85] =
    {field_body, 6},
    {field_name, 0},
  [87] =
    {field_body, 4},
    {field_pattern, 1},
  [89] =
    {field_label, 1},
    {field_type, 5},
    {field_value, 4},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [2] = {
    [0] = alias_sym_property_identifier,
  },
  [5] = {
    [0] = alias_sym_jsx_identifier,
  },
  [6] = {
    [1] = alias_sym_polyvar_string,
  },
  [13] = {
    [2] = alias_sym_polyvar_string,
  },
  [15] = {
    [2] = alias_sym_property_identifier,
  },
  [37] = {
    [4] = alias_sym_property_identifier,
  },
  [44] = {
    [1] = alias_sym_property_identifier,
  },
  [46] = {
    [3] = alias_sym_sequence_expression,
  },
  [50] = {
    [4] = alias_sym_sequence_expression,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__one_or_more_statements, 2,
    sym__one_or_more_statements,
    alias_sym_sequence_expression,
  sym_value_identifier_path, 2,
    sym_value_identifier_path,
    alias_sym_property_identifier,
  sym_value_identifier, 3,
    sym_value_identifier,
    alias_sym_jsx_identifier,
    alias_sym_property_identifier,
  sym_module_identifier, 2,
    sym_module_identifier,
    alias_sym_jsx_identifier,
  sym_string, 3,
    sym_string,
    alias_sym_polyvar_string,
    alias_sym_property_identifier,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 2,
  [5] = 2,
  [6] = 2,
  [7] = 2,
  [8] = 2,
  [9] = 9,
  [10] = 2,
  [11] = 11,
  [12] = 12,
  [13] = 12,
  [14] = 14,
  [15] = 14,
  [16] = 14,
  [17] = 14,
  [18] = 14,
  [19] = 14,
  [20] = 14,
  [21] = 14,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 25,
  [27] = 27,
  [28] = 25,
  [29] = 25,
  [30] = 25,
  [31] = 25,
  [32] = 25,
  [33] = 25,
  [34] = 25,
  [35] = 35,
  [36] = 36,
  [37] = 36,
  [38] = 38,
  [39] = 39,
  [40] = 36,
  [41] = 41,
  [42] = 42,
  [43] = 36,
  [44] = 36,
  [45] = 36,
  [46] = 46,
  [47] = 47,
  [48] = 46,
  [49] = 46,
  [50] = 50,
  [51] = 50,
  [52] = 52,
  [53] = 52,
  [54] = 52,
  [55] = 52,
  [56] = 52,
  [57] = 52,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 60,
  [62] = 59,
  [63] = 59,
  [64] = 59,
  [65] = 58,
  [66] = 66,
  [67] = 66,
  [68] = 66,
  [69] = 66,
  [70] = 58,
  [71] = 60,
  [72] = 59,
  [73] = 58,
  [74] = 60,
  [75] = 66,
  [76] = 58,
  [77] = 60,
  [78] = 60,
  [79] = 59,
  [80] = 58,
  [81] = 66,
  [82] = 82,
  [83] = 83,
  [84] = 82,
  [85] = 83,
  [86] = 83,
  [87] = 87,
  [88] = 82,
  [89] = 82,
  [90] = 83,
  [91] = 82,
  [92] = 87,
  [93] = 87,
  [94] = 83,
  [95] = 82,
  [96] = 83,
  [97] = 87,
  [98] = 87,
  [99] = 87,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 104,
  [111] = 105,
  [112] = 112,
  [113] = 113,
  [114] = 104,
  [115] = 107,
  [116] = 108,
  [117] = 108,
  [118] = 104,
  [119] = 119,
  [120] = 112,
  [121] = 121,
  [122] = 122,
  [123] = 122,
  [124] = 104,
  [125] = 122,
  [126] = 108,
  [127] = 109,
  [128] = 105,
  [129] = 105,
  [130] = 112,
  [131] = 131,
  [132] = 119,
  [133] = 107,
  [134] = 108,
  [135] = 119,
  [136] = 121,
  [137] = 107,
  [138] = 122,
  [139] = 109,
  [140] = 140,
  [141] = 109,
  [142] = 105,
  [143] = 112,
  [144] = 107,
  [145] = 121,
  [146] = 108,
  [147] = 104,
  [148] = 107,
  [149] = 119,
  [150] = 119,
  [151] = 121,
  [152] = 119,
  [153] = 122,
  [154] = 112,
  [155] = 121,
  [156] = 105,
  [157] = 109,
  [158] = 158,
  [159] = 122,
  [160] = 121,
  [161] = 109,
  [162] = 112,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 164,
  [168] = 168,
  [169] = 169,
  [170] = 163,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 168,
  [178] = 166,
  [179] = 179,
  [180] = 172,
  [181] = 169,
  [182] = 182,
  [183] = 183,
  [184] = 174,
  [185] = 185,
  [186] = 174,
  [187] = 187,
  [188] = 172,
  [189] = 179,
  [190] = 169,
  [191] = 172,
  [192] = 179,
  [193] = 193,
  [194] = 166,
  [195] = 168,
  [196] = 176,
  [197] = 175,
  [198] = 164,
  [199] = 166,
  [200] = 174,
  [201] = 201,
  [202] = 187,
  [203] = 173,
  [204] = 169,
  [205] = 174,
  [206] = 164,
  [207] = 207,
  [208] = 164,
  [209] = 172,
  [210] = 179,
  [211] = 179,
  [212] = 166,
  [213] = 207,
  [214] = 172,
  [215] = 171,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 174,
  [220] = 168,
  [221] = 163,
  [222] = 163,
  [223] = 165,
  [224] = 169,
  [225] = 176,
  [226] = 218,
  [227] = 171,
  [228] = 173,
  [229] = 175,
  [230] = 175,
  [231] = 176,
  [232] = 168,
  [233] = 164,
  [234] = 166,
  [235] = 179,
  [236] = 172,
  [237] = 193,
  [238] = 169,
  [239] = 174,
  [240] = 174,
  [241] = 169,
  [242] = 168,
  [243] = 166,
  [244] = 164,
  [245] = 169,
  [246] = 174,
  [247] = 174,
  [248] = 169,
  [249] = 176,
  [250] = 250,
  [251] = 165,
  [252] = 187,
  [253] = 187,
  [254] = 164,
  [255] = 193,
  [256] = 193,
  [257] = 193,
  [258] = 164,
  [259] = 193,
  [260] = 193,
  [261] = 193,
  [262] = 193,
  [263] = 193,
  [264] = 193,
  [265] = 171,
  [266] = 172,
  [267] = 193,
  [268] = 216,
  [269] = 207,
  [270] = 169,
  [271] = 216,
  [272] = 193,
  [273] = 193,
  [274] = 193,
  [275] = 193,
  [276] = 217,
  [277] = 175,
  [278] = 207,
  [279] = 163,
  [280] = 171,
  [281] = 216,
  [282] = 164,
  [283] = 173,
  [284] = 175,
  [285] = 172,
  [286] = 176,
  [287] = 168,
  [288] = 288,
  [289] = 166,
  [290] = 174,
  [291] = 179,
  [292] = 173,
  [293] = 174,
  [294] = 166,
  [295] = 207,
  [296] = 179,
  [297] = 288,
  [298] = 175,
  [299] = 173,
  [300] = 172,
  [301] = 201,
  [302] = 168,
  [303] = 193,
  [304] = 169,
  [305] = 174,
  [306] = 164,
  [307] = 176,
  [308] = 187,
  [309] = 164,
  [310] = 166,
  [311] = 175,
  [312] = 168,
  [313] = 176,
  [314] = 169,
  [315] = 175,
  [316] = 218,
  [317] = 171,
  [318] = 216,
  [319] = 187,
  [320] = 217,
  [321] = 171,
  [322] = 172,
  [323] = 169,
  [324] = 171,
  [325] = 169,
  [326] = 172,
  [327] = 171,
  [328] = 169,
  [329] = 288,
  [330] = 179,
  [331] = 201,
  [332] = 193,
  [333] = 166,
  [334] = 168,
  [335] = 216,
  [336] = 187,
  [337] = 207,
  [338] = 176,
  [339] = 174,
  [340] = 175,
  [341] = 171,
  [342] = 207,
  [343] = 343,
  [344] = 164,
  [345] = 207,
  [346] = 169,
  [347] = 347,
  [348] = 171,
  [349] = 349,
  [350] = 207,
  [351] = 217,
  [352] = 169,
  [353] = 163,
  [354] = 174,
  [355] = 165,
  [356] = 171,
  [357] = 175,
  [358] = 172,
  [359] = 174,
  [360] = 179,
  [361] = 183,
  [362] = 362,
  [363] = 182,
  [364] = 176,
  [365] = 174,
  [366] = 168,
  [367] = 217,
  [368] = 179,
  [369] = 166,
  [370] = 217,
  [371] = 216,
  [372] = 179,
  [373] = 343,
  [374] = 216,
  [375] = 288,
  [376] = 218,
  [377] = 217,
  [378] = 207,
  [379] = 172,
  [380] = 201,
  [381] = 187,
  [382] = 163,
  [383] = 193,
  [384] = 173,
  [385] = 171,
  [386] = 173,
  [387] = 166,
  [388] = 175,
  [389] = 176,
  [390] = 168,
  [391] = 166,
  [392] = 179,
  [393] = 172,
  [394] = 174,
  [395] = 168,
  [396] = 166,
  [397] = 207,
  [398] = 175,
  [399] = 163,
  [400] = 163,
  [401] = 187,
  [402] = 164,
  [403] = 176,
  [404] = 404,
  [405] = 362,
  [406] = 217,
  [407] = 404,
  [408] = 343,
  [409] = 207,
  [410] = 168,
  [411] = 216,
  [412] = 171,
  [413] = 362,
  [414] = 207,
  [415] = 343,
  [416] = 362,
  [417] = 343,
  [418] = 172,
  [419] = 168,
  [420] = 179,
  [421] = 169,
  [422] = 179,
  [423] = 347,
  [424] = 164,
  [425] = 187,
  [426] = 164,
  [427] = 166,
  [428] = 187,
  [429] = 173,
  [430] = 172,
  [431] = 175,
  [432] = 168,
  [433] = 176,
  [434] = 179,
  [435] = 176,
  [436] = 165,
  [437] = 176,
  [438] = 166,
  [439] = 175,
  [440] = 288,
  [441] = 168,
  [442] = 207,
  [443] = 201,
  [444] = 193,
  [445] = 175,
  [446] = 193,
  [447] = 176,
  [448] = 175,
  [449] = 171,
  [450] = 201,
  [451] = 451,
  [452] = 207,
  [453] = 207,
  [454] = 454,
  [455] = 455,
  [456] = 169,
  [457] = 207,
  [458] = 174,
  [459] = 459,
  [460] = 183,
  [461] = 182,
  [462] = 169,
  [463] = 455,
  [464] = 174,
  [465] = 176,
  [466] = 171,
  [467] = 173,
  [468] = 288,
  [469] = 469,
  [470] = 455,
  [471] = 471,
  [472] = 171,
  [473] = 163,
  [474] = 183,
  [475] = 175,
  [476] = 164,
  [477] = 168,
  [478] = 455,
  [479] = 207,
  [480] = 171,
  [481] = 455,
  [482] = 175,
  [483] = 217,
  [484] = 216,
  [485] = 183,
  [486] = 207,
  [487] = 182,
  [488] = 171,
  [489] = 172,
  [490] = 176,
  [491] = 174,
  [492] = 183,
  [493] = 175,
  [494] = 172,
  [495] = 171,
  [496] = 218,
  [497] = 343,
  [498] = 362,
  [499] = 182,
  [500] = 165,
  [501] = 176,
  [502] = 179,
  [503] = 166,
  [504] = 216,
  [505] = 169,
  [506] = 217,
  [507] = 455,
  [508] = 207,
  [509] = 176,
  [510] = 187,
  [511] = 171,
  [512] = 173,
  [513] = 175,
  [514] = 164,
  [515] = 176,
  [516] = 168,
  [517] = 166,
  [518] = 179,
  [519] = 172,
  [520] = 168,
  [521] = 166,
  [522] = 168,
  [523] = 164,
  [524] = 179,
  [525] = 164,
  [526] = 207,
  [527] = 217,
  [528] = 166,
  [529] = 187,
  [530] = 179,
  [531] = 179,
  [532] = 164,
  [533] = 172,
  [534] = 534,
  [535] = 535,
  [536] = 535,
  [537] = 534,
  [538] = 534,
  [539] = 534,
  [540] = 534,
  [541] = 535,
  [542] = 534,
  [543] = 535,
  [544] = 535,
  [545] = 535,
  [546] = 546,
  [547] = 547,
  [548] = 546,
  [549] = 547,
  [550] = 547,
  [551] = 546,
  [552] = 547,
  [553] = 546,
  [554] = 546,
  [555] = 555,
  [556] = 547,
  [557] = 557,
  [558] = 558,
  [559] = 559,
  [560] = 560,
  [561] = 561,
  [562] = 561,
  [563] = 561,
  [564] = 561,
  [565] = 561,
  [566] = 561,
  [567] = 561,
  [568] = 561,
  [569] = 561,
  [570] = 561,
  [571] = 561,
  [572] = 572,
  [573] = 572,
  [574] = 561,
  [575] = 561,
  [576] = 576,
  [577] = 577,
  [578] = 578,
  [579] = 579,
  [580] = 580,
  [581] = 581,
  [582] = 582,
  [583] = 583,
  [584] = 584,
  [585] = 585,
  [586] = 586,
  [587] = 587,
  [588] = 588,
  [589] = 589,
  [590] = 590,
  [591] = 591,
  [592] = 591,
  [593] = 593,
  [594] = 594,
  [595] = 595,
  [596] = 595,
  [597] = 597,
  [598] = 598,
  [599] = 599,
  [600] = 597,
  [601] = 601,
  [602] = 602,
  [603] = 603,
  [604] = 604,
  [605] = 605,
  [606] = 606,
  [607] = 604,
  [608] = 608,
  [609] = 609,
  [610] = 610,
  [611] = 611,
  [612] = 608,
  [613] = 603,
  [614] = 614,
  [615] = 615,
  [616] = 616,
  [617] = 617,
  [618] = 617,
  [619] = 619,
  [620] = 620,
  [621] = 614,
  [622] = 622,
  [623] = 617,
  [624] = 624,
  [625] = 614,
  [626] = 614,
  [627] = 614,
  [628] = 614,
  [629] = 616,
  [630] = 630,
  [631] = 624,
  [632] = 632,
  [633] = 614,
  [634] = 614,
  [635] = 624,
  [636] = 636,
  [637] = 616,
  [638] = 638,
  [639] = 639,
  [640] = 640,
  [641] = 641,
  [642] = 642,
  [643] = 643,
  [644] = 644,
  [645] = 645,
  [646] = 646,
  [647] = 647,
  [648] = 648,
  [649] = 649,
  [650] = 650,
  [651] = 651,
  [652] = 652,
  [653] = 653,
  [654] = 654,
  [655] = 655,
  [656] = 656,
  [657] = 657,
  [658] = 658,
  [659] = 659,
  [660] = 660,
  [661] = 648,
  [662] = 662,
  [663] = 663,
  [664] = 664,
  [665] = 665,
  [666] = 666,
  [667] = 667,
  [668] = 668,
  [669] = 655,
  [670] = 670,
  [671] = 671,
  [672] = 672,
  [673] = 673,
  [674] = 674,
  [675] = 675,
  [676] = 676,
  [677] = 677,
  [678] = 678,
  [679] = 679,
  [680] = 680,
  [681] = 681,
  [682] = 682,
  [683] = 683,
  [684] = 684,
  [685] = 685,
  [686] = 686,
  [687] = 687,
  [688] = 688,
  [689] = 689,
  [690] = 690,
  [691] = 691,
  [692] = 692,
  [693] = 693,
  [694] = 694,
  [695] = 695,
  [696] = 696,
  [697] = 697,
  [698] = 698,
  [699] = 699,
  [700] = 700,
  [701] = 701,
  [702] = 702,
  [703] = 703,
  [704] = 704,
  [705] = 705,
  [706] = 706,
  [707] = 707,
  [708] = 708,
  [709] = 709,
  [710] = 710,
  [711] = 711,
  [712] = 712,
  [713] = 713,
  [714] = 714,
  [715] = 715,
  [716] = 716,
  [717] = 717,
  [718] = 718,
  [719] = 719,
  [720] = 720,
  [721] = 721,
  [722] = 722,
  [723] = 723,
  [724] = 724,
  [725] = 725,
  [726] = 726,
  [727] = 727,
  [728] = 728,
  [729] = 729,
  [730] = 730,
  [731] = 731,
  [732] = 732,
  [733] = 733,
  [734] = 734,
  [735] = 735,
  [736] = 736,
  [737] = 737,
  [738] = 738,
  [739] = 672,
  [740] = 740,
  [741] = 741,
  [742] = 742,
  [743] = 743,
  [744] = 744,
  [745] = 745,
  [746] = 746,
  [747] = 747,
  [748] = 748,
  [749] = 749,
  [750] = 750,
  [751] = 751,
  [752] = 752,
  [753] = 753,
  [754] = 754,
  [755] = 755,
  [756] = 756,
  [757] = 589,
  [758] = 758,
  [759] = 759,
  [760] = 760,
  [761] = 761,
  [762] = 762,
  [763] = 763,
  [764] = 589,
  [765] = 674,
  [766] = 762,
  [767] = 767,
  [768] = 761,
  [769] = 769,
  [770] = 770,
  [771] = 688,
  [772] = 772,
  [773] = 773,
  [774] = 774,
  [775] = 775,
  [776] = 776,
  [777] = 769,
  [778] = 759,
  [779] = 774,
  [780] = 780,
  [781] = 721,
  [782] = 679,
  [783] = 783,
  [784] = 772,
  [785] = 675,
  [786] = 780,
  [787] = 667,
  [788] = 773,
  [789] = 750,
  [790] = 790,
  [791] = 791,
  [792] = 754,
  [793] = 763,
  [794] = 775,
  [795] = 791,
  [796] = 746,
  [797] = 770,
  [798] = 741,
  [799] = 799,
  [800] = 800,
  [801] = 800,
  [802] = 802,
  [803] = 803,
  [804] = 800,
  [805] = 805,
  [806] = 800,
  [807] = 805,
  [808] = 803,
  [809] = 800,
  [810] = 799,
  [811] = 805,
  [812] = 812,
  [813] = 800,
  [814] = 800,
  [815] = 800,
  [816] = 816,
  [817] = 817,
  [818] = 818,
  [819] = 800,
  [820] = 820,
  [821] = 821,
  [822] = 822,
  [823] = 800,
  [824] = 800,
  [825] = 800,
  [826] = 640,
  [827] = 800,
  [828] = 828,
  [829] = 803,
  [830] = 800,
  [831] = 800,
  [832] = 812,
  [833] = 816,
  [834] = 800,
  [835] = 803,
  [836] = 589,
  [837] = 818,
  [838] = 821,
  [839] = 800,
  [840] = 800,
  [841] = 800,
  [842] = 619,
  [843] = 800,
  [844] = 800,
  [845] = 845,
  [846] = 800,
  [847] = 845,
  [848] = 800,
  [849] = 800,
  [850] = 800,
  [851] = 800,
  [852] = 800,
  [853] = 800,
  [854] = 800,
  [855] = 800,
  [856] = 800,
  [857] = 817,
  [858] = 858,
  [859] = 859,
  [860] = 800,
  [861] = 800,
  [862] = 670,
  [863] = 863,
  [864] = 805,
  [865] = 800,
  [866] = 800,
  [867] = 822,
  [868] = 820,
  [869] = 859,
  [870] = 828,
  [871] = 589,
  [872] = 872,
  [873] = 589,
  [874] = 716,
  [875] = 692,
  [876] = 691,
  [877] = 695,
  [878] = 589,
  [879] = 670,
  [880] = 609,
  [881] = 611,
  [882] = 589,
  [883] = 630,
  [884] = 884,
  [885] = 884,
  [886] = 686,
  [887] = 887,
  [888] = 888,
  [889] = 888,
  [890] = 679,
  [891] = 721,
  [892] = 639,
  [893] = 893,
  [894] = 674,
  [895] = 589,
  [896] = 589,
  [897] = 619,
  [898] = 710,
  [899] = 678,
  [900] = 707,
  [901] = 589,
  [902] = 694,
  [903] = 693,
  [904] = 678,
  [905] = 655,
  [906] = 630,
  [907] = 648,
  [908] = 643,
  [909] = 642,
  [910] = 693,
  [911] = 644,
  [912] = 751,
  [913] = 589,
  [914] = 646,
  [915] = 647,
  [916] = 611,
  [917] = 650,
  [918] = 609,
  [919] = 652,
  [920] = 640,
  [921] = 654,
  [922] = 657,
  [923] = 658,
  [924] = 651,
  [925] = 589,
  [926] = 734,
  [927] = 927,
  [928] = 694,
  [929] = 929,
  [930] = 929,
  [931] = 929,
  [932] = 671,
  [933] = 929,
  [934] = 929,
  [935] = 929,
  [936] = 715,
  [937] = 706,
  [938] = 929,
  [939] = 677,
  [940] = 927,
  [941] = 703,
  [942] = 705,
  [943] = 756,
  [944] = 927,
  [945] = 929,
  [946] = 662,
  [947] = 685,
  [948] = 753,
  [949] = 673,
  [950] = 752,
  [951] = 713,
  [952] = 709,
  [953] = 676,
  [954] = 704,
  [955] = 749,
  [956] = 929,
  [957] = 648,
  [958] = 748,
  [959] = 929,
  [960] = 747,
  [961] = 684,
  [962] = 745,
  [963] = 927,
  [964] = 929,
  [965] = 744,
  [966] = 743,
  [967] = 742,
  [968] = 700,
  [969] = 740,
  [970] = 738,
  [971] = 699,
  [972] = 927,
  [973] = 683,
  [974] = 737,
  [975] = 736,
  [976] = 639,
  [977] = 927,
  [978] = 735,
  [979] = 929,
  [980] = 929,
  [981] = 698,
  [982] = 733,
  [983] = 732,
  [984] = 682,
  [985] = 681,
  [986] = 731,
  [987] = 730,
  [988] = 929,
  [989] = 729,
  [990] = 728,
  [991] = 711,
  [992] = 927,
  [993] = 927,
  [994] = 697,
  [995] = 927,
  [996] = 929,
  [997] = 622,
  [998] = 668,
  [999] = 687,
  [1000] = 727,
  [1001] = 696,
  [1002] = 707,
  [1003] = 712,
  [1004] = 672,
  [1005] = 708,
  [1006] = 929,
  [1007] = 927,
  [1008] = 927,
  [1009] = 929,
  [1010] = 726,
  [1011] = 927,
  [1012] = 725,
  [1013] = 1013,
  [1014] = 724,
  [1015] = 929,
  [1016] = 663,
  [1017] = 655,
  [1018] = 722,
  [1019] = 927,
  [1020] = 680,
  [1021] = 929,
  [1022] = 660,
  [1023] = 927,
  [1024] = 664,
  [1025] = 717,
  [1026] = 929,
  [1027] = 927,
  [1028] = 689,
  [1029] = 720,
  [1030] = 718,
  [1031] = 719,
  [1032] = 666,
  [1033] = 665,
  [1034] = 751,
  [1035] = 710,
  [1036] = 672,
  [1037] = 929,
  [1038] = 646,
  [1039] = 642,
  [1040] = 1040,
  [1041] = 654,
  [1042] = 670,
  [1043] = 1040,
  [1044] = 611,
  [1045] = 660,
  [1046] = 1046,
  [1047] = 622,
  [1048] = 643,
  [1049] = 1049,
  [1050] = 609,
  [1051] = 1040,
  [1052] = 1052,
  [1053] = 647,
  [1054] = 644,
  [1055] = 670,
  [1056] = 652,
  [1057] = 1057,
  [1058] = 651,
  [1059] = 693,
  [1060] = 609,
  [1061] = 657,
  [1062] = 650,
  [1063] = 740,
  [1064] = 630,
  [1065] = 656,
  [1066] = 619,
  [1067] = 658,
  [1068] = 611,
  [1069] = 622,
  [1070] = 1070,
  [1071] = 678,
  [1072] = 709,
  [1073] = 717,
  [1074] = 639,
  [1075] = 649,
  [1076] = 685,
  [1077] = 682,
  [1078] = 721,
  [1079] = 688,
  [1080] = 710,
  [1081] = 1081,
  [1082] = 639,
  [1083] = 751,
  [1084] = 748,
  [1085] = 686,
  [1086] = 642,
  [1087] = 671,
  [1088] = 704,
  [1089] = 730,
  [1090] = 687,
  [1091] = 701,
  [1092] = 702,
  [1093] = 747,
  [1094] = 659,
  [1095] = 695,
  [1096] = 714,
  [1097] = 729,
  [1098] = 1098,
  [1099] = 684,
  [1100] = 649,
  [1101] = 700,
  [1102] = 699,
  [1103] = 698,
  [1104] = 656,
  [1105] = 706,
  [1106] = 712,
  [1107] = 673,
  [1108] = 672,
  [1109] = 708,
  [1110] = 667,
  [1111] = 697,
  [1112] = 749,
  [1113] = 720,
  [1114] = 668,
  [1115] = 745,
  [1116] = 731,
  [1117] = 1117,
  [1118] = 1118,
  [1119] = 728,
  [1120] = 683,
  [1121] = 696,
  [1122] = 744,
  [1123] = 743,
  [1124] = 676,
  [1125] = 752,
  [1126] = 742,
  [1127] = 713,
  [1128] = 741,
  [1129] = 738,
  [1130] = 722,
  [1131] = 630,
  [1132] = 705,
  [1133] = 707,
  [1134] = 644,
  [1135] = 694,
  [1136] = 680,
  [1137] = 746,
  [1138] = 675,
  [1139] = 665,
  [1140] = 622,
  [1141] = 666,
  [1142] = 692,
  [1143] = 691,
  [1144] = 646,
  [1145] = 689,
  [1146] = 727,
  [1147] = 723,
  [1148] = 719,
  [1149] = 664,
  [1150] = 718,
  [1151] = 754,
  [1152] = 737,
  [1153] = 724,
  [1154] = 622,
  [1155] = 753,
  [1156] = 672,
  [1157] = 736,
  [1158] = 643,
  [1159] = 735,
  [1160] = 716,
  [1161] = 750,
  [1162] = 734,
  [1163] = 619,
  [1164] = 715,
  [1165] = 703,
  [1166] = 733,
  [1167] = 677,
  [1168] = 725,
  [1169] = 640,
  [1170] = 662,
  [1171] = 732,
  [1172] = 663,
  [1173] = 726,
  [1174] = 711,
  [1175] = 756,
  [1176] = 681,
  [1177] = 647,
  [1178] = 649,
  [1179] = 643,
  [1180] = 1180,
  [1181] = 667,
  [1182] = 655,
  [1183] = 648,
  [1184] = 652,
  [1185] = 675,
  [1186] = 723,
  [1187] = 750,
  [1188] = 622,
  [1189] = 647,
  [1190] = 640,
  [1191] = 688,
  [1192] = 1192,
  [1193] = 654,
  [1194] = 1194,
  [1195] = 1195,
  [1196] = 650,
  [1197] = 646,
  [1198] = 1192,
  [1199] = 642,
  [1200] = 656,
  [1201] = 741,
  [1202] = 754,
  [1203] = 702,
  [1204] = 746,
  [1205] = 1205,
  [1206] = 659,
  [1207] = 1192,
  [1208] = 701,
  [1209] = 714,
  [1210] = 644,
  [1211] = 651,
  [1212] = 658,
  [1213] = 657,
  [1214] = 732,
  [1215] = 748,
  [1216] = 691,
  [1217] = 689,
  [1218] = 718,
  [1219] = 719,
  [1220] = 708,
  [1221] = 720,
  [1222] = 680,
  [1223] = 687,
  [1224] = 722,
  [1225] = 741,
  [1226] = 746,
  [1227] = 754,
  [1228] = 750,
  [1229] = 667,
  [1230] = 714,
  [1231] = 622,
  [1232] = 675,
  [1233] = 659,
  [1234] = 702,
  [1235] = 701,
  [1236] = 688,
  [1237] = 724,
  [1238] = 725,
  [1239] = 726,
  [1240] = 727,
  [1241] = 670,
  [1242] = 686,
  [1243] = 656,
  [1244] = 728,
  [1245] = 729,
  [1246] = 657,
  [1247] = 658,
  [1248] = 730,
  [1249] = 731,
  [1250] = 682,
  [1251] = 677,
  [1252] = 713,
  [1253] = 733,
  [1254] = 734,
  [1255] = 735,
  [1256] = 717,
  [1257] = 665,
  [1258] = 736,
  [1259] = 737,
  [1260] = 683,
  [1261] = 656,
  [1262] = 655,
  [1263] = 738,
  [1264] = 740,
  [1265] = 742,
  [1266] = 743,
  [1267] = 744,
  [1268] = 745,
  [1269] = 651,
  [1270] = 747,
  [1271] = 692,
  [1272] = 589,
  [1273] = 660,
  [1274] = 685,
  [1275] = 749,
  [1276] = 709,
  [1277] = 752,
  [1278] = 684,
  [1279] = 1279,
  [1280] = 753,
  [1281] = 696,
  [1282] = 668,
  [1283] = 654,
  [1284] = 662,
  [1285] = 756,
  [1286] = 681,
  [1287] = 697,
  [1288] = 698,
  [1289] = 703,
  [1290] = 622,
  [1291] = 679,
  [1292] = 648,
  [1293] = 699,
  [1294] = 700,
  [1295] = 665,
  [1296] = 693,
  [1297] = 704,
  [1298] = 676,
  [1299] = 705,
  [1300] = 674,
  [1301] = 652,
  [1302] = 649,
  [1303] = 673,
  [1304] = 671,
  [1305] = 694,
  [1306] = 707,
  [1307] = 706,
  [1308] = 695,
  [1309] = 655,
  [1310] = 678,
  [1311] = 751,
  [1312] = 710,
  [1313] = 666,
  [1314] = 664,
  [1315] = 642,
  [1316] = 663,
  [1317] = 721,
  [1318] = 711,
  [1319] = 712,
  [1320] = 723,
  [1321] = 686,
  [1322] = 716,
  [1323] = 650,
  [1324] = 649,
  [1325] = 715,
  [1326] = 672,
  [1327] = 648,
  [1328] = 675,
  [1329] = 751,
  [1330] = 697,
  [1331] = 722,
  [1332] = 702,
  [1333] = 701,
  [1334] = 698,
  [1335] = 720,
  [1336] = 724,
  [1337] = 683,
  [1338] = 725,
  [1339] = 699,
  [1340] = 726,
  [1341] = 700,
  [1342] = 682,
  [1343] = 727,
  [1344] = 728,
  [1345] = 729,
  [1346] = 730,
  [1347] = 731,
  [1348] = 704,
  [1349] = 688,
  [1350] = 705,
  [1351] = 692,
  [1352] = 732,
  [1353] = 733,
  [1354] = 734,
  [1355] = 706,
  [1356] = 735,
  [1357] = 736,
  [1358] = 649,
  [1359] = 737,
  [1360] = 680,
  [1361] = 695,
  [1362] = 738,
  [1363] = 740,
  [1364] = 723,
  [1365] = 742,
  [1366] = 743,
  [1367] = 744,
  [1368] = 745,
  [1369] = 660,
  [1370] = 741,
  [1371] = 667,
  [1372] = 747,
  [1373] = 712,
  [1374] = 748,
  [1375] = 749,
  [1376] = 709,
  [1377] = 752,
  [1378] = 753,
  [1379] = 719,
  [1380] = 672,
  [1381] = 662,
  [1382] = 756,
  [1383] = 703,
  [1384] = 677,
  [1385] = 663,
  [1386] = 718,
  [1387] = 675,
  [1388] = 667,
  [1389] = 723,
  [1390] = 672,
  [1391] = 717,
  [1392] = 746,
  [1393] = 659,
  [1394] = 711,
  [1395] = 708,
  [1396] = 664,
  [1397] = 716,
  [1398] = 666,
  [1399] = 656,
  [1400] = 693,
  [1401] = 715,
  [1402] = 694,
  [1403] = 688,
  [1404] = 707,
  [1405] = 679,
  [1406] = 750,
  [1407] = 622,
  [1408] = 671,
  [1409] = 678,
  [1410] = 674,
  [1411] = 665,
  [1412] = 696,
  [1413] = 714,
  [1414] = 710,
  [1415] = 673,
  [1416] = 754,
  [1417] = 746,
  [1418] = 741,
  [1419] = 713,
  [1420] = 676,
  [1421] = 686,
  [1422] = 714,
  [1423] = 659,
  [1424] = 691,
  [1425] = 754,
  [1426] = 685,
  [1427] = 668,
  [1428] = 684,
  [1429] = 687,
  [1430] = 702,
  [1431] = 750,
  [1432] = 681,
  [1433] = 701,
  [1434] = 689,
  [1435] = 701,
  [1436] = 750,
  [1437] = 754,
  [1438] = 741,
  [1439] = 667,
  [1440] = 714,
  [1441] = 675,
  [1442] = 656,
  [1443] = 746,
  [1444] = 649,
  [1445] = 649,
  [1446] = 688,
  [1447] = 656,
  [1448] = 622,
  [1449] = 659,
  [1450] = 702,
  [1451] = 723,
  [1452] = 688,
  [1453] = 723,
  [1454] = 667,
  [1455] = 750,
  [1456] = 754,
  [1457] = 746,
  [1458] = 714,
  [1459] = 741,
  [1460] = 642,
  [1461] = 675,
  [1462] = 1462,
  [1463] = 659,
  [1464] = 741,
  [1465] = 746,
  [1466] = 754,
  [1467] = 750,
  [1468] = 667,
  [1469] = 675,
  [1470] = 701,
  [1471] = 649,
  [1472] = 688,
  [1473] = 723,
  [1474] = 688,
  [1475] = 714,
  [1476] = 659,
  [1477] = 702,
  [1478] = 656,
  [1479] = 741,
  [1480] = 746,
  [1481] = 675,
  [1482] = 656,
  [1483] = 754,
  [1484] = 667,
  [1485] = 702,
  [1486] = 750,
  [1487] = 701,
  [1488] = 1488,
  [1489] = 714,
  [1490] = 746,
  [1491] = 741,
  [1492] = 649,
  [1493] = 688,
  [1494] = 675,
  [1495] = 675,
  [1496] = 667,
  [1497] = 723,
  [1498] = 746,
  [1499] = 659,
  [1500] = 702,
  [1501] = 723,
  [1502] = 701,
  [1503] = 750,
  [1504] = 741,
  [1505] = 702,
  [1506] = 675,
  [1507] = 701,
  [1508] = 741,
  [1509] = 754,
  [1510] = 1510,
  [1511] = 688,
  [1512] = 667,
  [1513] = 688,
  [1514] = 754,
  [1515] = 714,
  [1516] = 750,
  [1517] = 746,
  [1518] = 1518,
  [1519] = 754,
  [1520] = 750,
  [1521] = 659,
  [1522] = 667,
  [1523] = 1523,
  [1524] = 1523,
  [1525] = 1525,
  [1526] = 1526,
  [1527] = 665,
  [1528] = 1528,
  [1529] = 1523,
  [1530] = 1523,
  [1531] = 1523,
  [1532] = 1523,
  [1533] = 1533,
  [1534] = 675,
  [1535] = 746,
  [1536] = 1536,
  [1537] = 1536,
  [1538] = 1536,
  [1539] = 1536,
  [1540] = 741,
  [1541] = 1541,
  [1542] = 746,
  [1543] = 1543,
  [1544] = 754,
  [1545] = 750,
  [1546] = 1536,
  [1547] = 741,
  [1548] = 667,
  [1549] = 750,
  [1550] = 1536,
  [1551] = 688,
  [1552] = 754,
  [1553] = 688,
  [1554] = 675,
  [1555] = 667,
  [1556] = 1556,
  [1557] = 1556,
  [1558] = 1556,
  [1559] = 741,
  [1560] = 1560,
  [1561] = 1561,
  [1562] = 675,
  [1563] = 1556,
  [1564] = 1556,
  [1565] = 667,
  [1566] = 1560,
  [1567] = 750,
  [1568] = 1556,
  [1569] = 754,
  [1570] = 1560,
  [1571] = 1560,
  [1572] = 1560,
  [1573] = 1560,
  [1574] = 746,
  [1575] = 688,
  [1576] = 1576,
  [1577] = 754,
  [1578] = 1578,
  [1579] = 1579,
  [1580] = 1580,
  [1581] = 688,
  [1582] = 1579,
  [1583] = 1583,
  [1584] = 746,
  [1585] = 767,
  [1586] = 1578,
  [1587] = 754,
  [1588] = 1588,
  [1589] = 1576,
  [1590] = 1588,
  [1591] = 741,
  [1592] = 1579,
  [1593] = 1576,
  [1594] = 1578,
  [1595] = 1595,
  [1596] = 1596,
  [1597] = 746,
  [1598] = 1579,
  [1599] = 1599,
  [1600] = 1578,
  [1601] = 1595,
  [1602] = 1602,
  [1603] = 741,
  [1604] = 750,
  [1605] = 750,
  [1606] = 667,
  [1607] = 1607,
  [1608] = 1578,
  [1609] = 1609,
  [1610] = 1610,
  [1611] = 1588,
  [1612] = 1595,
  [1613] = 1576,
  [1614] = 1576,
  [1615] = 1596,
  [1616] = 1579,
  [1617] = 675,
  [1618] = 1588,
  [1619] = 1576,
  [1620] = 667,
  [1621] = 1595,
  [1622] = 1622,
  [1623] = 675,
  [1624] = 1588,
  [1625] = 1625,
  [1626] = 688,
  [1627] = 1595,
  [1628] = 1578,
  [1629] = 1629,
  [1630] = 667,
  [1631] = 1631,
  [1632] = 741,
  [1633] = 1633,
  [1634] = 746,
  [1635] = 1635,
  [1636] = 1636,
  [1637] = 1633,
  [1638] = 1635,
  [1639] = 1635,
  [1640] = 1640,
  [1641] = 1631,
  [1642] = 1640,
  [1643] = 754,
  [1644] = 1631,
  [1645] = 1629,
  [1646] = 1640,
  [1647] = 1636,
  [1648] = 1629,
  [1649] = 1631,
  [1650] = 1640,
  [1651] = 1635,
  [1652] = 750,
  [1653] = 1631,
  [1654] = 688,
  [1655] = 1636,
  [1656] = 667,
  [1657] = 675,
  [1658] = 1635,
  [1659] = 1640,
  [1660] = 1635,
  [1661] = 1635,
  [1662] = 1635,
  [1663] = 1629,
  [1664] = 1635,
  [1665] = 1635,
  [1666] = 1666,
  [1667] = 1635,
  [1668] = 1635,
  [1669] = 754,
  [1670] = 1635,
  [1671] = 688,
  [1672] = 750,
  [1673] = 1631,
  [1674] = 1640,
  [1675] = 1636,
  [1676] = 1635,
  [1677] = 1635,
  [1678] = 1678,
  [1679] = 1636,
  [1680] = 1633,
  [1681] = 1633,
  [1682] = 1629,
  [1683] = 1633,
  [1684] = 746,
  [1685] = 741,
  [1686] = 1635,
  [1687] = 1635,
  [1688] = 1635,
  [1689] = 1689,
  [1690] = 1629,
  [1691] = 1635,
  [1692] = 1635,
  [1693] = 1636,
  [1694] = 1635,
  [1695] = 675,
  [1696] = 1633,
  [1697] = 1697,
  [1698] = 1698,
  [1699] = 1697,
  [1700] = 1697,
  [1701] = 1070,
  [1702] = 1698,
  [1703] = 1698,
  [1704] = 1697,
  [1705] = 1705,
  [1706] = 1697,
  [1707] = 1698,
  [1708] = 1698,
  [1709] = 1698,
  [1710] = 1697,
  [1711] = 1697,
  [1712] = 1712,
  [1713] = 1713,
  [1714] = 1712,
  [1715] = 1713,
  [1716] = 1716,
  [1717] = 1717,
  [1718] = 1718,
  [1719] = 1719,
  [1720] = 1717,
  [1721] = 1719,
  [1722] = 1722,
  [1723] = 1718,
  [1724] = 1722,
  [1725] = 1716,
  [1726] = 1717,
  [1727] = 1719,
  [1728] = 589,
  [1729] = 1729,
  [1730] = 1730,
  [1731] = 1730,
  [1732] = 1732,
  [1733] = 1733,
  [1734] = 1734,
  [1735] = 1735,
  [1736] = 686,
  [1737] = 1737,
  [1738] = 1738,
  [1739] = 1735,
  [1740] = 1740,
  [1741] = 1741,
  [1742] = 609,
  [1743] = 1743,
  [1744] = 1744,
  [1745] = 611,
  [1746] = 1743,
  [1747] = 1744,
  [1748] = 1734,
  [1749] = 1749,
  [1750] = 1750,
  [1751] = 1751,
  [1752] = 1070,
  [1753] = 639,
  [1754] = 1754,
  [1755] = 1755,
  [1756] = 1756,
  [1757] = 1757,
  [1758] = 1758,
  [1759] = 1759,
  [1760] = 1760,
  [1761] = 1761,
  [1762] = 1762,
  [1763] = 1763,
  [1764] = 1764,
  [1765] = 1765,
  [1766] = 1766,
  [1767] = 1767,
  [1768] = 1768,
  [1769] = 686,
  [1770] = 1770,
  [1771] = 1771,
  [1772] = 1772,
  [1773] = 1773,
  [1774] = 1774,
  [1775] = 1775,
  [1776] = 1776,
  [1777] = 1777,
  [1778] = 1778,
  [1779] = 1779,
  [1780] = 1780,
  [1781] = 1781,
  [1782] = 1782,
  [1783] = 1783,
  [1784] = 1784,
  [1785] = 1785,
  [1786] = 670,
  [1787] = 1787,
  [1788] = 1788,
  [1789] = 1789,
  [1790] = 1790,
  [1791] = 1791,
  [1792] = 1792,
  [1793] = 1793,
  [1794] = 1794,
  [1795] = 1795,
  [1796] = 1796,
  [1797] = 1797,
  [1798] = 670,
  [1799] = 670,
  [1800] = 1800,
  [1801] = 1800,
  [1802] = 1800,
  [1803] = 1796,
  [1804] = 1800,
  [1805] = 1794,
  [1806] = 1806,
  [1807] = 1807,
  [1808] = 1800,
  [1809] = 1809,
  [1810] = 1806,
  [1811] = 1797,
  [1812] = 1797,
  [1813] = 619,
  [1814] = 1814,
  [1815] = 1809,
  [1816] = 1806,
  [1817] = 1797,
  [1818] = 1818,
  [1819] = 1800,
  [1820] = 1806,
  [1821] = 1795,
  [1822] = 1729,
  [1823] = 1806,
  [1824] = 1824,
  [1825] = 1776,
  [1826] = 1797,
  [1827] = 1807,
  [1828] = 1828,
  [1829] = 1829,
  [1830] = 1776,
  [1831] = 1797,
  [1832] = 1814,
  [1833] = 1833,
  [1834] = 642,
  [1835] = 1737,
  [1836] = 1806,
  [1837] = 652,
  [1838] = 1767,
  [1839] = 1755,
  [1840] = 670,
  [1841] = 1794,
  [1842] = 658,
  [1843] = 1843,
  [1844] = 1844,
  [1845] = 1794,
  [1846] = 630,
  [1847] = 1847,
  [1848] = 649,
  [1849] = 1844,
  [1850] = 1847,
  [1851] = 650,
  [1852] = 1843,
  [1853] = 1776,
  [1854] = 655,
  [1855] = 1855,
  [1856] = 1856,
  [1857] = 640,
  [1858] = 1858,
  [1859] = 648,
  [1860] = 1860,
  [1861] = 1861,
  [1862] = 651,
  [1863] = 654,
  [1864] = 657,
  [1865] = 1858,
  [1866] = 1856,
  [1867] = 1789,
  [1868] = 1794,
  [1869] = 1749,
  [1870] = 1870,
  [1871] = 710,
  [1872] = 751,
  [1873] = 678,
  [1874] = 655,
  [1875] = 707,
  [1876] = 694,
  [1877] = 693,
  [1878] = 743,
  [1879] = 703,
  [1880] = 756,
  [1881] = 662,
  [1882] = 753,
  [1883] = 752,
  [1884] = 709,
  [1885] = 749,
  [1886] = 748,
  [1887] = 747,
  [1888] = 745,
  [1889] = 744,
  [1890] = 708,
  [1891] = 742,
  [1892] = 686,
  [1893] = 1870,
  [1894] = 740,
  [1895] = 738,
  [1896] = 683,
  [1897] = 646,
  [1898] = 737,
  [1899] = 736,
  [1900] = 735,
  [1901] = 734,
  [1902] = 733,
  [1903] = 732,
  [1904] = 682,
  [1905] = 731,
  [1906] = 730,
  [1907] = 729,
  [1908] = 728,
  [1909] = 727,
  [1910] = 643,
  [1911] = 726,
  [1912] = 725,
  [1913] = 724,
  [1914] = 722,
  [1915] = 680,
  [1916] = 721,
  [1917] = 720,
  [1918] = 719,
  [1919] = 718,
  [1920] = 717,
  [1921] = 660,
  [1922] = 716,
  [1923] = 715,
  [1924] = 677,
  [1925] = 647,
  [1926] = 713,
  [1927] = 711,
  [1928] = 695,
  [1929] = 706,
  [1930] = 705,
  [1931] = 704,
  [1932] = 700,
  [1933] = 1933,
  [1934] = 699,
  [1935] = 698,
  [1936] = 697,
  [1937] = 668,
  [1938] = 696,
  [1939] = 692,
  [1940] = 691,
  [1941] = 689,
  [1942] = 1861,
  [1943] = 687,
  [1944] = 1944,
  [1945] = 1945,
  [1946] = 1762,
  [1947] = 1756,
  [1948] = 1774,
  [1949] = 1778,
  [1950] = 1784,
  [1951] = 1775,
  [1952] = 1952,
  [1953] = 1771,
  [1954] = 1763,
  [1955] = 1758,
  [1956] = 1764,
  [1957] = 1773,
  [1958] = 1958,
  [1959] = 1780,
  [1960] = 1781,
  [1961] = 1779,
  [1962] = 1765,
  [1963] = 1766,
  [1964] = 1870,
  [1965] = 1783,
  [1966] = 1966,
  [1967] = 1759,
  [1968] = 1944,
  [1969] = 1933,
  [1970] = 1970,
  [1971] = 1751,
  [1972] = 1870,
  [1973] = 1757,
  [1974] = 1974,
  [1975] = 1975,
  [1976] = 1790,
  [1977] = 1952,
  [1978] = 1958,
  [1979] = 1966,
  [1980] = 1870,
  [1981] = 1870,
  [1982] = 1860,
  [1983] = 1983,
  [1984] = 1984,
  [1985] = 1761,
  [1986] = 1986,
  [1987] = 1794,
  [1988] = 1986,
  [1989] = 1768,
  [1990] = 1990,
  [1991] = 1991,
  [1992] = 1992,
  [1993] = 1984,
  [1994] = 1986,
  [1995] = 1750,
  [1996] = 1791,
  [1997] = 1793,
  [1998] = 1984,
  [1999] = 1788,
  [2000] = 1986,
  [2001] = 1991,
  [2002] = 1992,
  [2003] = 1782,
  [2004] = 2004,
  [2005] = 1984,
  [2006] = 2006,
  [2007] = 1794,
  [2008] = 648,
  [2009] = 1754,
  [2010] = 2004,
  [2011] = 1986,
  [2012] = 2006,
  [2013] = 1970,
  [2014] = 1945,
  [2015] = 1984,
  [2016] = 2016,
  [2017] = 1861,
  [2018] = 2016,
  [2019] = 1860,
  [2020] = 2020,
  [2021] = 2021,
  [2022] = 1952,
  [2023] = 1958,
  [2024] = 1952,
  [2025] = 1958,
  [2026] = 1776,
  [2027] = 670,
  [2028] = 630,
  [2029] = 1824,
  [2030] = 2021,
  [2031] = 2031,
  [2032] = 1991,
  [2033] = 1992,
  [2034] = 2034,
  [2035] = 2021,
  [2036] = 1794,
  [2037] = 1861,
  [2038] = 2038,
  [2039] = 2021,
  [2040] = 2040,
  [2041] = 2034,
  [2042] = 2021,
  [2043] = 1990,
  [2044] = 1991,
  [2045] = 2020,
  [2046] = 1992,
  [2047] = 1860,
  [2048] = 2048,
  [2049] = 1958,
  [2050] = 2050,
  [2051] = 2051,
  [2052] = 2052,
  [2053] = 2053,
  [2054] = 2054,
  [2055] = 2054,
  [2056] = 1992,
  [2057] = 1991,
  [2058] = 2058,
  [2059] = 1773,
  [2060] = 2054,
  [2061] = 2061,
  [2062] = 2062,
  [2063] = 2063,
  [2064] = 2064,
  [2065] = 2065,
  [2066] = 1992,
  [2067] = 1860,
  [2068] = 2068,
  [2069] = 1991,
  [2070] = 1990,
  [2071] = 2071,
  [2072] = 2072,
  [2073] = 2073,
  [2074] = 2074,
  [2075] = 2054,
  [2076] = 2076,
  [2077] = 2077,
  [2078] = 1992,
  [2079] = 1991,
  [2080] = 1990,
  [2081] = 1952,
  [2082] = 1794,
  [2083] = 2083,
  [2084] = 2084,
  [2085] = 2054,
  [2086] = 2086,
  [2087] = 2087,
  [2088] = 2088,
  [2089] = 2089,
  [2090] = 2090,
  [2091] = 1958,
  [2092] = 2092,
  [2093] = 2093,
  [2094] = 1952,
  [2095] = 2095,
  [2096] = 2096,
  [2097] = 2074,
  [2098] = 1952,
  [2099] = 2099,
  [2100] = 2100,
  [2101] = 1992,
  [2102] = 1991,
  [2103] = 2103,
  [2104] = 2104,
  [2105] = 2105,
  [2106] = 2106,
  [2107] = 1990,
  [2108] = 2074,
  [2109] = 2109,
  [2110] = 1860,
  [2111] = 1958,
  [2112] = 2112,
  [2113] = 1992,
  [2114] = 1991,
  [2115] = 2115,
  [2116] = 2116,
  [2117] = 2117,
  [2118] = 2118,
  [2119] = 2119,
  [2120] = 2074,
  [2121] = 2121,
  [2122] = 2122,
  [2123] = 2123,
  [2124] = 1958,
  [2125] = 1952,
  [2126] = 2126,
  [2127] = 1991,
  [2128] = 1860,
  [2129] = 2129,
  [2130] = 2054,
  [2131] = 2131,
  [2132] = 2132,
  [2133] = 2133,
  [2134] = 2074,
  [2135] = 1958,
  [2136] = 1952,
  [2137] = 1958,
  [2138] = 1952,
  [2139] = 2139,
  [2140] = 2074,
  [2141] = 2076,
  [2142] = 2142,
  [2143] = 2143,
  [2144] = 1992,
  [2145] = 2145,
  [2146] = 2146,
  [2147] = 2096,
  [2148] = 1794,
  [2149] = 1992,
  [2150] = 2100,
  [2151] = 2151,
  [2152] = 2152,
  [2153] = 2153,
  [2154] = 2119,
  [2155] = 2155,
  [2156] = 1952,
  [2157] = 2157,
  [2158] = 1958,
  [2159] = 2159,
  [2160] = 2160,
  [2161] = 2161,
  [2162] = 2162,
  [2163] = 1958,
  [2164] = 2164,
  [2165] = 1952,
  [2166] = 2166,
  [2167] = 2123,
  [2168] = 1992,
  [2169] = 1860,
  [2170] = 2170,
  [2171] = 1991,
  [2172] = 1990,
  [2173] = 2162,
  [2174] = 1952,
  [2175] = 2175,
  [2176] = 2132,
  [2177] = 1958,
  [2178] = 1952,
  [2179] = 1992,
  [2180] = 1991,
  [2181] = 2161,
  [2182] = 2162,
  [2183] = 1776,
  [2184] = 2184,
  [2185] = 1958,
  [2186] = 2162,
  [2187] = 1952,
  [2188] = 2117,
  [2189] = 1992,
  [2190] = 1991,
  [2191] = 2159,
  [2192] = 1776,
  [2193] = 2193,
  [2194] = 670,
  [2195] = 1991,
  [2196] = 1992,
  [2197] = 2162,
  [2198] = 2104,
  [2199] = 2105,
  [2200] = 1990,
  [2201] = 1958,
  [2202] = 2175,
  [2203] = 2164,
  [2204] = 1952,
  [2205] = 1991,
  [2206] = 1990,
  [2207] = 2162,
  [2208] = 2112,
  [2209] = 2122,
  [2210] = 2162,
  [2211] = 2090,
  [2212] = 1794,
  [2213] = 1958,
  [2214] = 2109,
  [2215] = 2155,
  [2216] = 1991,
  [2217] = 1992,
  [2218] = 2218,
  [2219] = 2219,
  [2220] = 1860,
  [2221] = 1958,
  [2222] = 2222,
  [2223] = 2223,
  [2224] = 1952,
  [2225] = 2225,
  [2226] = 1794,
  [2227] = 2227,
  [2228] = 2228,
  [2229] = 1990,
  [2230] = 2230,
  [2231] = 2231,
  [2232] = 2232,
  [2233] = 2233,
  [2234] = 2234,
  [2235] = 2235,
  [2236] = 1991,
  [2237] = 2237,
  [2238] = 2238,
  [2239] = 1794,
  [2240] = 2240,
  [2241] = 2238,
  [2242] = 2231,
  [2243] = 2223,
  [2244] = 2244,
  [2245] = 1992,
  [2246] = 2246,
  [2247] = 2247,
  [2248] = 1952,
  [2249] = 2225,
  [2250] = 2240,
  [2251] = 1958,
  [2252] = 2252,
  [2253] = 2230,
  [2254] = 2254,
  [2255] = 1991,
  [2256] = 1992,
  [2257] = 2257,
  [2258] = 2237,
  [2259] = 2228,
  [2260] = 2260,
  [2261] = 2261,
  [2262] = 2218,
  [2263] = 2040,
  [2264] = 2264,
  [2265] = 2254,
  [2266] = 2246,
  [2267] = 2232,
  [2268] = 2238,
  [2269] = 2233,
  [2270] = 2222,
  [2271] = 2271,
  [2272] = 2247,
  [2273] = 2238,
  [2274] = 2274,
  [2275] = 2275,
  [2276] = 2238,
  [2277] = 2244,
  [2278] = 2257,
  [2279] = 1773,
  [2280] = 2235,
  [2281] = 2227,
  [2282] = 2282,
  [2283] = 2283,
  [2284] = 2238,
  [2285] = 2238,
  [2286] = 2238,
  [2287] = 2287,
  [2288] = 2252,
  [2289] = 686,
  [2290] = 2290,
  [2291] = 2271,
  [2292] = 2292,
  [2293] = 2293,
  [2294] = 2294,
  [2295] = 2295,
  [2296] = 1794,
  [2297] = 2297,
  [2298] = 2298,
  [2299] = 2298,
  [2300] = 2300,
  [2301] = 2301,
  [2302] = 2302,
  [2303] = 2303,
  [2304] = 2304,
  [2305] = 2305,
  [2306] = 2306,
  [2307] = 2307,
  [2308] = 2308,
  [2309] = 1794,
  [2310] = 2310,
  [2311] = 2311,
  [2312] = 2312,
  [2313] = 2313,
  [2314] = 2314,
  [2315] = 2315,
  [2316] = 1958,
  [2317] = 1952,
  [2318] = 1952,
  [2319] = 1958,
  [2320] = 2320,
  [2321] = 670,
  [2322] = 1860,
  [2323] = 2323,
  [2324] = 2324,
  [2325] = 2031,
  [2326] = 686,
  [2327] = 2304,
  [2328] = 1991,
  [2329] = 1992,
  [2330] = 2330,
  [2331] = 2331,
  [2332] = 679,
  [2333] = 674,
  [2334] = 2334,
  [2335] = 2335,
  [2336] = 2308,
  [2337] = 2298,
  [2338] = 2313,
  [2339] = 2298,
  [2340] = 2314,
  [2341] = 686,
  [2342] = 2298,
  [2343] = 2343,
  [2344] = 2344,
  [2345] = 2345,
  [2346] = 2310,
  [2347] = 2347,
  [2348] = 2305,
  [2349] = 1990,
  [2350] = 1991,
  [2351] = 1860,
  [2352] = 2352,
  [2353] = 1992,
  [2354] = 2354,
  [2355] = 2355,
  [2356] = 2303,
  [2357] = 2315,
  [2358] = 2358,
  [2359] = 2302,
  [2360] = 2306,
  [2361] = 2343,
  [2362] = 2347,
  [2363] = 2330,
  [2364] = 2301,
  [2365] = 2311,
  [2366] = 2298,
  [2367] = 1824,
  [2368] = 2368,
  [2369] = 2345,
  [2370] = 2323,
  [2371] = 2371,
  [2372] = 2312,
  [2373] = 2373,
  [2374] = 2335,
  [2375] = 2375,
  [2376] = 2376,
  [2377] = 1958,
  [2378] = 2378,
  [2379] = 2375,
  [2380] = 2380,
  [2381] = 2381,
  [2382] = 640,
  [2383] = 1991,
  [2384] = 2384,
  [2385] = 2385,
  [2386] = 1966,
  [2387] = 2387,
  [2388] = 2388,
  [2389] = 2389,
  [2390] = 2381,
  [2391] = 2391,
  [2392] = 2384,
  [2393] = 2393,
  [2394] = 2394,
  [2395] = 2048,
  [2396] = 2396,
  [2397] = 2397,
  [2398] = 2398,
  [2399] = 2399,
  [2400] = 1992,
  [2401] = 2166,
  [2402] = 2402,
  [2403] = 2376,
  [2404] = 2404,
  [2405] = 2405,
  [2406] = 1991,
  [2407] = 2407,
  [2408] = 2393,
  [2409] = 1958,
  [2410] = 2410,
  [2411] = 2411,
  [2412] = 1952,
  [2413] = 2413,
  [2414] = 2398,
  [2415] = 2413,
  [2416] = 2387,
  [2417] = 2417,
  [2418] = 2418,
  [2419] = 1861,
  [2420] = 2407,
  [2421] = 2421,
  [2422] = 1952,
  [2423] = 619,
  [2424] = 2402,
  [2425] = 2425,
  [2426] = 2426,
  [2427] = 2378,
  [2428] = 2421,
  [2429] = 1952,
  [2430] = 1958,
  [2431] = 2431,
  [2432] = 2432,
  [2433] = 2433,
  [2434] = 2434,
  [2435] = 2399,
  [2436] = 1990,
  [2437] = 1991,
  [2438] = 2389,
  [2439] = 2439,
  [2440] = 1860,
  [2441] = 1966,
  [2442] = 1992,
  [2443] = 2443,
  [2444] = 1990,
  [2445] = 1860,
  [2446] = 2048,
  [2447] = 2431,
  [2448] = 2417,
  [2449] = 1966,
  [2450] = 1992,
  [2451] = 1861,
  [2452] = 1860,
  [2453] = 1952,
  [2454] = 1952,
  [2455] = 2455,
  [2456] = 2456,
  [2457] = 2457,
  [2458] = 2458,
  [2459] = 2426,
  [2460] = 1860,
  [2461] = 2048,
  [2462] = 2462,
  [2463] = 2463,
  [2464] = 2464,
  [2465] = 2464,
  [2466] = 2388,
  [2467] = 2467,
  [2468] = 2468,
  [2469] = 2464,
  [2470] = 2470,
  [2471] = 2464,
  [2472] = 2458,
  [2473] = 1958,
  [2474] = 1990,
  [2475] = 1991,
  [2476] = 1992,
  [2477] = 1966,
  [2478] = 2464,
  [2479] = 2479,
  [2480] = 2480,
  [2481] = 2481,
  [2482] = 2482,
  [2483] = 2483,
  [2484] = 2484,
  [2485] = 2485,
  [2486] = 2486,
  [2487] = 2034,
  [2488] = 2488,
  [2489] = 1952,
  [2490] = 2485,
  [2491] = 1958,
  [2492] = 2492,
  [2493] = 2486,
  [2494] = 1991,
  [2495] = 1992,
  [2496] = 2233,
  [2497] = 2463,
  [2498] = 2498,
  [2499] = 2462,
  [2500] = 2500,
  [2501] = 1958,
  [2502] = 1991,
  [2503] = 2503,
  [2504] = 2458,
  [2505] = 1992,
  [2506] = 2506,
  [2507] = 2458,
  [2508] = 1952,
  [2509] = 2184,
  [2510] = 2510,
  [2511] = 2034,
  [2512] = 2247,
  [2513] = 2483,
  [2514] = 2455,
  [2515] = 1958,
  [2516] = 2458,
  [2517] = 2517,
  [2518] = 2261,
  [2519] = 2519,
  [2520] = 2520,
  [2521] = 2521,
  [2522] = 2254,
  [2523] = 1992,
  [2524] = 1990,
  [2525] = 2048,
  [2526] = 2526,
  [2527] = 2458,
  [2528] = 2034,
  [2529] = 1991,
  [2530] = 2048,
  [2531] = 2531,
  [2532] = 2532,
  [2533] = 2260,
  [2534] = 1990,
  [2535] = 1992,
  [2536] = 2536,
  [2537] = 2537,
  [2538] = 2538,
  [2539] = 2538,
  [2540] = 2537,
  [2541] = 2537,
  [2542] = 2537,
  [2543] = 2532,
  [2544] = 2544,
  [2545] = 2545,
  [2546] = 2264,
  [2547] = 2547,
  [2548] = 2548,
  [2549] = 2549,
  [2550] = 721,
  [2551] = 2551,
  [2552] = 2552,
  [2553] = 2553,
  [2554] = 2545,
  [2555] = 2547,
  [2556] = 2556,
  [2557] = 2549,
  [2558] = 2538,
  [2559] = 2559,
  [2560] = 2547,
  [2561] = 2531,
  [2562] = 2562,
  [2563] = 1952,
  [2564] = 2564,
  [2565] = 2565,
  [2566] = 2549,
  [2567] = 1958,
  [2568] = 2545,
  [2569] = 2556,
  [2570] = 2564,
  [2571] = 2547,
  [2572] = 2547,
  [2573] = 2547,
  [2574] = 2559,
  [2575] = 2559,
  [2576] = 2556,
  [2577] = 2545,
  [2578] = 2547,
  [2579] = 2559,
  [2580] = 2531,
  [2581] = 2562,
  [2582] = 2582,
  [2583] = 2547,
  [2584] = 2562,
  [2585] = 2531,
  [2586] = 2556,
  [2587] = 2549,
  [2588] = 2531,
  [2589] = 2562,
  [2590] = 2547,
  [2591] = 2547,
  [2592] = 2547,
  [2593] = 1991,
  [2594] = 2556,
  [2595] = 1992,
  [2596] = 2596,
  [2597] = 2538,
  [2598] = 2537,
  [2599] = 2537,
  [2600] = 2600,
  [2601] = 2600,
  [2602] = 2034,
  [2603] = 2547,
  [2604] = 2596,
  [2605] = 2545,
  [2606] = 2562,
  [2607] = 2607,
  [2608] = 2274,
  [2609] = 2609,
  [2610] = 2559,
  [2611] = 2531,
  [2612] = 2058,
  [2613] = 1952,
  [2614] = 2556,
  [2615] = 1958,
  [2616] = 2532,
  [2617] = 2562,
  [2618] = 2549,
  [2619] = 2619,
  [2620] = 2234,
  [2621] = 1991,
  [2622] = 2547,
  [2623] = 2537,
  [2624] = 2624,
  [2625] = 2048,
  [2626] = 2626,
  [2627] = 2532,
  [2628] = 2537,
  [2629] = 2629,
  [2630] = 2538,
  [2631] = 2559,
  [2632] = 2532,
  [2633] = 2547,
  [2634] = 2549,
  [2635] = 2547,
  [2636] = 2058,
  [2637] = 2545,
  [2638] = 2544,
  [2639] = 2639,
  [2640] = 2537,
  [2641] = 2641,
  [2642] = 2538,
  [2643] = 2532,
  [2644] = 2644,
  [2645] = 2645,
  [2646] = 2646,
  [2647] = 2647,
  [2648] = 2646,
  [2649] = 2649,
  [2650] = 2650,
  [2651] = 2650,
  [2652] = 2652,
  [2653] = 2653,
  [2654] = 2654,
  [2655] = 2644,
  [2656] = 2656,
  [2657] = 2644,
  [2658] = 2653,
  [2659] = 2647,
  [2660] = 2233,
  [2661] = 2661,
  [2662] = 2644,
  [2663] = 2653,
  [2664] = 2247,
  [2665] = 2665,
  [2666] = 2665,
  [2667] = 2654,
  [2668] = 2668,
  [2669] = 2652,
  [2670] = 2670,
  [2671] = 2671,
  [2672] = 2254,
  [2673] = 2673,
  [2674] = 2647,
  [2675] = 2675,
  [2676] = 2232,
  [2677] = 2650,
  [2678] = 2678,
  [2679] = 2647,
  [2680] = 2652,
  [2681] = 2681,
  [2682] = 2665,
  [2683] = 2671,
  [2684] = 2665,
  [2685] = 2671,
  [2686] = 2686,
  [2687] = 2649,
  [2688] = 2228,
  [2689] = 2654,
  [2690] = 2671,
  [2691] = 2691,
  [2692] = 2692,
  [2693] = 2671,
  [2694] = 2665,
  [2695] = 1773,
  [2696] = 2696,
  [2697] = 2697,
  [2698] = 2698,
  [2699] = 2653,
  [2700] = 2700,
  [2701] = 2701,
  [2702] = 2644,
  [2703] = 2649,
  [2704] = 2681,
  [2705] = 2665,
  [2706] = 2671,
  [2707] = 2649,
  [2708] = 2661,
  [2709] = 2691,
  [2710] = 2710,
  [2711] = 2647,
  [2712] = 2653,
  [2713] = 2654,
  [2714] = 2650,
  [2715] = 2647,
  [2716] = 2691,
  [2717] = 2649,
  [2718] = 2691,
  [2719] = 2652,
  [2720] = 2720,
  [2721] = 2650,
  [2722] = 2722,
  [2723] = 2646,
  [2724] = 2724,
  [2725] = 2653,
  [2726] = 2654,
  [2727] = 2644,
  [2728] = 2728,
  [2729] = 2645,
  [2730] = 2646,
  [2731] = 2731,
  [2732] = 2654,
  [2733] = 2733,
  [2734] = 2734,
  [2735] = 2649,
  [2736] = 2650,
  [2737] = 2652,
  [2738] = 2652,
  [2739] = 2644,
  [2740] = 2653,
  [2741] = 2647,
  [2742] = 2652,
  [2743] = 2743,
  [2744] = 2692,
  [2745] = 2650,
  [2746] = 2746,
  [2747] = 2747,
  [2748] = 2748,
  [2749] = 2749,
  [2750] = 2750,
  [2751] = 2751,
  [2752] = 2752,
  [2753] = 2750,
  [2754] = 2754,
  [2755] = 2755,
  [2756] = 2756,
  [2757] = 2757,
  [2758] = 2758,
  [2759] = 2759,
  [2760] = 2760,
  [2761] = 2761,
  [2762] = 2762,
  [2763] = 2763,
  [2764] = 2764,
  [2765] = 2765,
  [2766] = 2766,
  [2767] = 2767,
  [2768] = 2768,
  [2769] = 2769,
  [2770] = 2770,
  [2771] = 2762,
  [2772] = 2748,
  [2773] = 2773,
  [2774] = 2774,
  [2775] = 2775,
  [2776] = 2776,
  [2777] = 2777,
  [2778] = 2778,
  [2779] = 2779,
  [2780] = 2780,
  [2781] = 2781,
  [2782] = 2782,
  [2783] = 2777,
  [2784] = 2784,
  [2785] = 2785,
  [2786] = 2786,
  [2787] = 2787,
  [2788] = 2788,
  [2789] = 2789,
  [2790] = 2790,
  [2791] = 2791,
  [2792] = 2792,
  [2793] = 2793,
  [2794] = 2794,
  [2795] = 2795,
  [2796] = 2796,
  [2797] = 2797,
  [2798] = 2757,
  [2799] = 2799,
  [2800] = 2800,
  [2801] = 2777,
  [2802] = 2749,
  [2803] = 2803,
  [2804] = 2777,
  [2805] = 2757,
  [2806] = 2755,
  [2807] = 2757,
  [2808] = 2808,
  [2809] = 2773,
  [2810] = 2777,
  [2811] = 2808,
  [2812] = 2777,
  [2813] = 2813,
  [2814] = 2777,
  [2815] = 2775,
  [2816] = 2816,
  [2817] = 2813,
  [2818] = 2763,
  [2819] = 2793,
  [2820] = 2820,
  [2821] = 2793,
  [2822] = 2777,
  [2823] = 2777,
  [2824] = 2766,
  [2825] = 2825,
  [2826] = 2826,
  [2827] = 2766,
  [2828] = 2813,
  [2829] = 2776,
  [2830] = 2777,
  [2831] = 2803,
  [2832] = 2778,
  [2833] = 2779,
  [2834] = 2749,
  [2835] = 2780,
  [2836] = 2836,
  [2837] = 2837,
  [2838] = 2781,
  [2839] = 2754,
  [2840] = 2748,
  [2841] = 2770,
  [2842] = 2777,
  [2843] = 2782,
  [2844] = 2797,
  [2845] = 2777,
  [2846] = 2791,
  [2847] = 2775,
  [2848] = 2769,
  [2849] = 2808,
  [2850] = 2757,
  [2851] = 2851,
  [2852] = 2778,
  [2853] = 2779,
  [2854] = 2777,
  [2855] = 2793,
  [2856] = 2786,
  [2857] = 2857,
  [2858] = 2785,
  [2859] = 2784,
  [2860] = 2777,
  [2861] = 2861,
  [2862] = 2779,
  [2863] = 2751,
  [2864] = 2864,
  [2865] = 2857,
  [2866] = 2866,
  [2867] = 2778,
  [2868] = 2777,
  [2869] = 2784,
  [2870] = 2785,
  [2871] = 2775,
  [2872] = 2786,
  [2873] = 2768,
  [2874] = 2773,
  [2875] = 2767,
  [2876] = 2748,
  [2877] = 2763,
  [2878] = 2764,
  [2879] = 2879,
  [2880] = 2751,
  [2881] = 2751,
  [2882] = 2791,
  [2883] = 2777,
  [2884] = 2750,
  [2885] = 2754,
  [2886] = 2751,
  [2887] = 2780,
  [2888] = 2763,
  [2889] = 2751,
  [2890] = 2777,
  [2891] = 2770,
  [2892] = 2749,
  [2893] = 2803,
  [2894] = 2894,
  [2895] = 2757,
  [2896] = 2896,
  [2897] = 2808,
  [2898] = 2813,
  [2899] = 2899,
  [2900] = 2864,
  [2901] = 2901,
  [2902] = 2777,
  [2903] = 2777,
  [2904] = 2773,
  [2905] = 2750,
  [2906] = 2793,
  [2907] = 2907,
  [2908] = 2908,
  [2909] = 2803,
  [2910] = 2910,
  [2911] = 2793,
  [2912] = 2749,
  [2913] = 2913,
  [2914] = 2914,
  [2915] = 2813,
  [2916] = 2916,
  [2917] = 2917,
  [2918] = 2918,
  [2919] = 2808,
  [2920] = 2757,
  [2921] = 2803,
  [2922] = 2922,
  [2923] = 2749,
  [2924] = 2770,
  [2925] = 2770,
  [2926] = 2791,
  [2927] = 2927,
  [2928] = 2928,
  [2929] = 2929,
  [2930] = 2930,
  [2931] = 2931,
  [2932] = 2932,
  [2933] = 2750,
  [2934] = 2786,
  [2935] = 2765,
  [2936] = 2785,
  [2937] = 2937,
  [2938] = 2938,
  [2939] = 2939,
  [2940] = 2940,
  [2941] = 2777,
  [2942] = 2942,
  [2943] = 2784,
  [2944] = 2944,
  [2945] = 2777,
  [2946] = 2946,
  [2947] = 2750,
  [2948] = 2948,
  [2949] = 2779,
  [2950] = 2656,
  [2951] = 2951,
  [2952] = 2777,
  [2953] = 2778,
  [2954] = 2954,
  [2955] = 2955,
  [2956] = 2956,
  [2957] = 2775,
  [2958] = 2750,
  [2959] = 2748,
  [2960] = 2777,
  [2961] = 2961,
  [2962] = 2750,
  [2963] = 2963,
  [2964] = 2964,
  [2965] = 2763,
  [2966] = 2966,
  [2967] = 2763,
  [2968] = 2968,
  [2969] = 2777,
  [2970] = 2756,
  [2971] = 2971,
  [2972] = 2750,
  [2973] = 2973,
  [2974] = 2974,
  [2975] = 2748,
  [2976] = 2760,
  [2977] = 2775,
  [2978] = 2750,
  [2979] = 2777,
  [2980] = 2980,
  [2981] = 2910,
  [2982] = 2777,
  [2983] = 2784,
  [2984] = 2750,
  [2985] = 2985,
  [2986] = 2986,
  [2987] = 2778,
  [2988] = 2779,
  [2989] = 2989,
  [2990] = 2990,
  [2991] = 2785,
  [2992] = 2992,
  [2993] = 2786,
  [2994] = 2994,
  [2995] = 2995,
  [2996] = 2996,
  [2997] = 2758,
  [2998] = 2998,
  [2999] = 2999,
  [3000] = 2794,
  [3001] = 2759,
  [3002] = 2789,
  [3003] = 2750,
  [3004] = 3004,
  [3005] = 2797,
  [3006] = 2784,
  [3007] = 2785,
  [3008] = 2750,
  [3009] = 2757,
  [3010] = 2808,
  [3011] = 2786,
  [3012] = 2777,
  [3013] = 3013,
  [3014] = 2750,
  [3015] = 2777,
  [3016] = 2813,
  [3017] = 3017,
  [3018] = 3018,
  [3019] = 2791,
  [3020] = 2793,
  [3021] = 2791,
  [3022] = 2913,
  [3023] = 2803,
  [3024] = 2777,
  [3025] = 2750,
  [3026] = 2914,
  [3027] = 2770,
  [3028] = 3028,
  [3029] = 3029,
  [3030] = 3030,
  [3031] = 3031,
  [3032] = 3032,
  [3033] = 3030,
  [3034] = 3034,
  [3035] = 3035,
  [3036] = 3036,
  [3037] = 3037,
  [3038] = 3038,
  [3039] = 3039,
  [3040] = 3040,
  [3041] = 3037,
  [3042] = 3030,
  [3043] = 3043,
  [3044] = 3044,
  [3045] = 3045,
  [3046] = 3030,
  [3047] = 3030,
  [3048] = 3048,
  [3049] = 3030,
  [3050] = 3050,
  [3051] = 3051,
  [3052] = 3052,
  [3053] = 3037,
  [3054] = 3030,
  [3055] = 3030,
  [3056] = 3030,
  [3057] = 3057,
  [3058] = 3030,
  [3059] = 3059,
  [3060] = 3060,
  [3061] = 3061,
  [3062] = 3062,
  [3063] = 3030,
  [3064] = 3064,
  [3065] = 3065,
  [3066] = 3066,
  [3067] = 3067,
  [3068] = 3068,
  [3069] = 3069,
  [3070] = 3037,
  [3071] = 3030,
  [3072] = 3072,
  [3073] = 3040,
  [3074] = 3048,
  [3075] = 3075,
  [3076] = 3030,
  [3077] = 3030,
  [3078] = 3078,
  [3079] = 3079,
  [3080] = 3080,
  [3081] = 3081,
  [3082] = 3030,
  [3083] = 3040,
  [3084] = 3040,
  [3085] = 3030,
  [3086] = 3086,
  [3087] = 3087,
  [3088] = 3088,
  [3089] = 3089,
  [3090] = 3090,
  [3091] = 3091,
  [3092] = 3092,
  [3093] = 3030,
  [3094] = 3094,
  [3095] = 3095,
  [3096] = 3096,
  [3097] = 3097,
  [3098] = 3098,
  [3099] = 3099,
  [3100] = 3037,
  [3101] = 3040,
  [3102] = 3102,
  [3103] = 3103,
  [3104] = 3030,
  [3105] = 3105,
  [3106] = 3106,
  [3107] = 3107,
  [3108] = 3108,
  [3109] = 2371,
  [3110] = 3110,
  [3111] = 3111,
  [3112] = 3112,
  [3113] = 2368,
  [3114] = 3030,
  [3115] = 3112,
  [3116] = 3030,
  [3117] = 3106,
  [3118] = 3037,
  [3119] = 3037,
  [3120] = 3120,
  [3121] = 3121,
  [3122] = 3122,
  [3123] = 3123,
  [3124] = 3124,
  [3125] = 3125,
  [3126] = 3040,
  [3127] = 3030,
  [3128] = 3128,
  [3129] = 3129,
  [3130] = 3130,
  [3131] = 3131,
  [3132] = 3132,
  [3133] = 3106,
  [3134] = 3134,
  [3135] = 3135,
  [3136] = 3136,
  [3137] = 3137,
  [3138] = 3138,
  [3139] = 3139,
  [3140] = 3140,
  [3141] = 3141,
  [3142] = 3142,
  [3143] = 3143,
  [3144] = 3144,
  [3145] = 3145,
  [3146] = 3146,
  [3147] = 3147,
  [3148] = 3146,
  [3149] = 3146,
  [3150] = 3150,
  [3151] = 3146,
  [3152] = 3152,
  [3153] = 3146,
  [3154] = 3154,
  [3155] = 3146,
  [3156] = 3156,
  [3157] = 3146,
  [3158] = 3146,
  [3159] = 3159,
  [3160] = 3146,
  [3161] = 3161,
  [3162] = 3146,
  [3163] = 3146,
  [3164] = 3146,
  [3165] = 3159,
  [3166] = 3146,
  [3167] = 3167,
  [3168] = 3146,
  [3169] = 3169,
  [3170] = 3146,
  [3171] = 3146,
  [3172] = 3172,
  [3173] = 3173,
  [3174] = 3174,
  [3175] = 3175,
  [3176] = 3176,
  [3177] = 3152,
  [3178] = 3178,
  [3179] = 3179,
  [3180] = 3146,
  [3181] = 3181,
  [3182] = 3182,
  [3183] = 3183,
  [3184] = 3184,
  [3185] = 3146,
  [3186] = 3186,
  [3187] = 3156,
  [3188] = 3188,
  [3189] = 3189,
  [3190] = 3190,
  [3191] = 3191,
  [3192] = 3192,
  [3193] = 3193,
  [3194] = 3175,
  [3195] = 3195,
  [3196] = 3182,
  [3197] = 3197,
  [3198] = 3198,
  [3199] = 3198,
  [3200] = 3197,
  [3201] = 3193,
  [3202] = 3202,
  [3203] = 3191,
  [3204] = 3189,
  [3205] = 3175,
  [3206] = 3172,
  [3207] = 3182,
  [3208] = 3208,
  [3209] = 3209,
  [3210] = 3182,
  [3211] = 3147,
  [3212] = 3175,
  [3213] = 3175,
  [3214] = 3146,
  [3215] = 3198,
  [3216] = 3146,
  [3217] = 3217,
  [3218] = 3172,
  [3219] = 3152,
  [3220] = 3197,
  [3221] = 3221,
  [3222] = 3152,
  [3223] = 3147,
  [3224] = 3169,
  [3225] = 3186,
  [3226] = 3193,
  [3227] = 3221,
  [3228] = 3208,
  [3229] = 3208,
  [3230] = 3191,
  [3231] = 3202,
  [3232] = 3232,
  [3233] = 3233,
  [3234] = 3146,
  [3235] = 3193,
  [3236] = 3145,
  [3237] = 3237,
  [3238] = 3238,
  [3239] = 3152,
  [3240] = 3238,
  [3241] = 3181,
  [3242] = 3167,
  [3243] = 3243,
  [3244] = 3174,
  [3245] = 3186,
  [3246] = 3152,
  [3247] = 3238,
  [3248] = 3152,
  [3249] = 3145,
  [3250] = 3197,
  [3251] = 3198,
  [3252] = 3176,
  [3253] = 3179,
  [3254] = 3169,
  [3255] = 3167,
  [3256] = 3181,
  [3257] = 3257,
  [3258] = 3146,
  [3259] = 3259,
  [3260] = 3182,
  [3261] = 3261,
  [3262] = 3147,
  [3263] = 3152,
  [3264] = 3202,
  [3265] = 3152,
  [3266] = 3233,
  [3267] = 3261,
  [3268] = 3159,
  [3269] = 3167,
  [3270] = 3152,
  [3271] = 3261,
  [3272] = 3172,
  [3273] = 3208,
  [3274] = 3181,
  [3275] = 3174,
  [3276] = 3238,
  [3277] = 3156,
  [3278] = 3278,
  [3279] = 3176,
  [3280] = 3179,
  [3281] = 3174,
  [3282] = 3174,
  [3283] = 3167,
  [3284] = 3261,
  [3285] = 3181,
  [3286] = 3189,
  [3287] = 3287,
  [3288] = 3152,
  [3289] = 3289,
  [3290] = 3208,
  [3291] = 3221,
  [3292] = 3146,
  [3293] = 3191,
  [3294] = 3294,
  [3295] = 3146,
  [3296] = 3197,
  [3297] = 3198,
  [3298] = 3179,
  [3299] = 3299,
  [3300] = 3147,
  [3301] = 3221,
  [3302] = 3176,
  [3303] = 3179,
  [3304] = 3178,
  [3305] = 3257,
  [3306] = 3152,
  [3307] = 3146,
  [3308] = 3238,
  [3309] = 3189,
  [3310] = 3261,
  [3311] = 3145,
  [3312] = 3146,
  [3313] = 3176,
  [3314] = 3198,
  [3315] = 3193,
  [3316] = 3189,
  [3317] = 3186,
  [3318] = 3156,
  [3319] = 3197,
  [3320] = 3156,
  [3321] = 3176,
  [3322] = 3179,
  [3323] = 3169,
  [3324] = 3156,
  [3325] = 3146,
  [3326] = 3147,
  [3327] = 3182,
  [3328] = 3202,
  [3329] = 3233,
  [3330] = 3146,
  [3331] = 3169,
  [3332] = 3172,
  [3333] = 3182,
  [3334] = 3191,
  [3335] = 3179,
  [3336] = 3233,
  [3337] = 3146,
  [3338] = 3182,
  [3339] = 3173,
  [3340] = 3154,
  [3341] = 3189,
  [3342] = 3182,
  [3343] = 3175,
  [3344] = 3232,
  [3345] = 3243,
  [3346] = 3174,
  [3347] = 3233,
  [3348] = 3348,
  [3349] = 3156,
  [3350] = 3152,
  [3351] = 3172,
  [3352] = 3146,
  [3353] = 3159,
  [3354] = 3233,
  [3355] = 3152,
  [3356] = 3159,
  [3357] = 3146,
  [3358] = 3198,
  [3359] = 3197,
  [3360] = 3146,
  [3361] = 3146,
  [3362] = 3217,
  [3363] = 3145,
  [3364] = 3238,
  [3365] = 3167,
  [3366] = 3159,
  [3367] = 3243,
  [3368] = 3197,
  [3369] = 3198,
  [3370] = 3243,
  [3371] = 3181,
  [3372] = 3243,
  [3373] = 3373,
  [3374] = 3186,
  [3375] = 3182,
  [3376] = 3152,
  [3377] = 3221,
  [3378] = 3198,
  [3379] = 3221,
  [3380] = 3146,
  [3381] = 3197,
  [3382] = 3191,
  [3383] = 3174,
  [3384] = 3191,
  [3385] = 3202,
  [3386] = 3208,
  [3387] = 3197,
  [3388] = 3198,
  [3389] = 3156,
  [3390] = 3261,
  [3391] = 3198,
  [3392] = 3392,
  [3393] = 3182,
  [3394] = 3154,
  [3395] = 3395,
  [3396] = 3156,
  [3397] = 3193,
  [3398] = 3146,
  [3399] = 3186,
  [3400] = 3169,
  [3401] = 3197,
  [3402] = 3402,
  [3403] = 3403,
  [3404] = 3404,
  [3405] = 3405,
  [3406] = 3406,
  [3407] = 3407,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(223);
      ADVANCE_MAP(
        '!', 230,
        '"', 565,
        '#', 320,
        '$', 575,
        '%', 366,
        '&', 38,
        '\'', 577,
        '(', 232,
        ')', 233,
        '*', 355,
        '+', 272,
        ',', 259,
        '-', 278,
        '.', 285,
        '/', 336,
        '0', 539,
        ':', 236,
        ';', 224,
        '<', 270,
        '=', 238,
        '>', 282,
        '?', 301,
        '[', 295,
        '\\', 373,
        ']', 298,
        '`', 572,
        'a', 140,
        'c', 84,
        'd', 155,
        'e', 134,
        'f', 85,
        'i', 117,
        'l', 86,
        'm', 158,
        'o', 118,
        'p', 164,
        'r', 102,
        's', 190,
        't', 153,
        'u', 142,
        'w', 119,
        '{', 225,
        '|', 293,
        '}', 226,
        '~', 332,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(543);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(0);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(370);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '!', 229,
        '"', 565,
        '#', 320,
        '%', 366,
        '\'', 577,
        '(', 232,
        ')', 233,
        '+', 276,
        '-', 279,
        '.', 289,
        '0', 539,
        '<', 269,
        '?', 301,
        '[', 294,
        '\\', 28,
        '`', 571,
        'a', 481,
        'e', 498,
        'f', 418,
        'i', 447,
        'l', 421,
        'm', 466,
        's', 496,
        't', 473,
        'u', 463,
        'w', 449,
        '{', 225,
        '~', 332,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(543);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(1);
      if (('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(370);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '!', 229,
        '"', 565,
        '#', 320,
        '%', 366,
        '\'', 577,
        '(', 232,
        ')', 233,
        '+', 276,
        '-', 279,
        '.', 55,
        '0', 539,
        '<', 269,
        '?', 301,
        '[', 294,
        '\\', 28,
        ']', 298,
        '`', 571,
        'a', 481,
        'e', 498,
        'f', 418,
        'i', 447,
        'l', 421,
        'm', 466,
        's', 496,
        't', 474,
        'u', 463,
        'w', 449,
        '{', 225,
        '}', 226,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(543);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(2);
      if (('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(370);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '!', 229,
        '"', 565,
        '#', 320,
        '%', 366,
        '\'', 577,
        '(', 232,
        ')', 233,
        '+', 276,
        '-', 279,
        '.', 287,
        '0', 539,
        ':', 234,
        '<', 269,
        '?', 301,
        '[', 294,
        '\\', 28,
        ']', 298,
        '`', 571,
        'a', 481,
        'f', 418,
        'i', 447,
        'l', 421,
        'm', 466,
        's', 496,
        't', 474,
        'u', 463,
        'w', 449,
        '{', 225,
        '}', 226,
        '~', 332,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(543);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(3);
      if (('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(370);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '!', 229,
        '"', 565,
        '(', 232,
        ')', 233,
        '+', 61,
        ',', 259,
        '.', 284,
        ':', 235,
        ';', 224,
        '<', 269,
        '=', 239,
        '>', 281,
        ']', 298,
        'a', 141,
        'c', 156,
        'i', 116,
        'm', 157,
        'u', 148,
        'w', 124,
        '|', 292,
        '}', 226,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(4);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(370);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '!', 60,
        '"', 565,
        '#', 320,
        '%', 366,
        '&', 38,
        '\'', 577,
        '(', 232,
        '*', 355,
        '+', 273,
        '-', 278,
        '.', 287,
        '/', 336,
        '0', 539,
        ':', 236,
        '<', 270,
        '=', 238,
        '>', 282,
        '?', 301,
        '[', 294,
        '\\', 28,
        '`', 571,
        'a', 483,
        'f', 419,
        'i', 447,
        'l', 421,
        'm', 466,
        's', 496,
        't', 474,
        'u', 463,
        '{', 225,
        '|', 69,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(543);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(5);
      if (('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(370);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '!', 60,
        '"', 565,
        '#', 320,
        '%', 366,
        '&', 38,
        '\'', 577,
        '(', 232,
        '*', 355,
        '+', 273,
        '-', 278,
        '.', 287,
        '/', 336,
        '0', 539,
        ':', 66,
        '<', 270,
        '=', 63,
        '>', 282,
        '?', 301,
        '[', 294,
        '\\', 28,
        '`', 571,
        'a', 483,
        'e', 460,
        'f', 419,
        'i', 447,
        'l', 421,
        'm', 466,
        's', 496,
        't', 474,
        'u', 463,
        '{', 225,
        '|', 69,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(543);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(6);
      if (('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(370);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '!', 60,
        '&', 38,
        '(', 232,
        ')', 233,
        '*', 355,
        '+', 274,
        ',', 259,
        '-', 280,
        '.', 288,
        '/', 336,
        ':', 237,
        '<', 270,
        '=', 238,
        '>', 282,
        '?', 301,
        '[', 294,
        ']', 298,
        'a', 169,
        'i', 116,
        'w', 123,
        '|', 293,
        '}', 226,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(7);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        '!', 60,
        '&', 38,
        '(', 232,
        ')', 233,
        '*', 355,
        '+', 274,
        ',', 259,
        '-', 280,
        '.', 283,
        '/', 336,
        ':', 236,
        ';', 224,
        '<', 270,
        '=', 238,
        '>', 282,
        '?', 301,
        '[', 294,
        '\\', 32,
        ']', 298,
        'a', 525,
        'u', 517,
        '{', 225,
        '|', 293,
        '}', 226,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(8);
      if (lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(370);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '!', 60,
        '&', 38,
        '(', 232,
        ')', 233,
        '*', 355,
        '+', 274,
        ',', 259,
        '-', 280,
        '.', 283,
        '/', 336,
        ':', 236,
        ';', 224,
        '<', 270,
        '=', 238,
        '>', 282,
        '?', 301,
        '[', 294,
        ']', 298,
        'a', 141,
        'c', 84,
        'd', 155,
        'e', 133,
        'i', 117,
        't', 152,
        'w', 124,
        '{', 225,
        '|', 293,
        '}', 226,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(9);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        '!', 60,
        '&', 38,
        '(', 232,
        ')', 233,
        '*', 355,
        '+', 274,
        ',', 259,
        '-', 280,
        '.', 283,
        '/', 336,
        ':', 236,
        '<', 270,
        '=', 238,
        '>', 282,
        '?', 301,
        '[', 294,
        '\\', 32,
        ']', 298,
        'a', 526,
        'u', 517,
        '|', 293,
        '}', 226,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(10);
      if (lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 11:
      ADVANCE_MAP(
        '!', 60,
        '&', 38,
        '(', 232,
        ')', 233,
        '*', 355,
        '+', 274,
        ',', 259,
        '-', 280,
        '.', 283,
        '/', 336,
        ':', 237,
        '<', 270,
        '=', 64,
        '>', 282,
        '?', 301,
        '[', 294,
        '\\', 32,
        ']', 298,
        '{', 225,
        '|', 69,
        '}', 226,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(11);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(370);
      if (lookahead == '\'' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 12:
      ADVANCE_MAP(
        '!', 60,
        '&', 38,
        '(', 232,
        ')', 233,
        '*', 355,
        '+', 274,
        ',', 259,
        '-', 280,
        '.', 286,
        '/', 336,
        ':', 236,
        '<', 270,
        '=', 238,
        '>', 282,
        '?', 301,
        '[', 294,
        '\\', 32,
        'a', 525,
        'u', 517,
        '|', 69,
        '}', 226,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(12);
      if (lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(370);
      END_STATE();
    case 13:
      ADVANCE_MAP(
        '!', 60,
        '&', 38,
        '(', 232,
        ')', 233,
        '*', 355,
        '+', 274,
        ',', 259,
        '-', 280,
        '.', 286,
        '/', 336,
        ':', 237,
        '<', 270,
        '=', 64,
        '>', 282,
        '?', 301,
        '[', 294,
        '\\', 32,
        'a', 407,
        '|', 293,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(13);
      if (lookahead == '\'' ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 14:
      ADVANCE_MAP(
        '!', 60,
        '&', 38,
        '(', 232,
        ')', 233,
        '*', 355,
        '+', 274,
        ',', 259,
        '-', 280,
        '.', 286,
        '/', 336,
        ':', 237,
        '<', 270,
        '=', 64,
        '>', 282,
        '?', 301,
        '[', 294,
        'a', 169,
        'e', 133,
        '|', 293,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(14);
      END_STATE();
    case 15:
      ADVANCE_MAP(
        '!', 60,
        '&', 38,
        '(', 232,
        ')', 233,
        '*', 355,
        '+', 274,
        '-', 280,
        '.', 283,
        '/', 336,
        ':', 62,
        ';', 224,
        '<', 270,
        '=', 238,
        '>', 282,
        '?', 301,
        '[', 294,
        '\\', 32,
        'a', 519,
        'u', 517,
        '|', 293,
        '}', 226,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(15);
      if (lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 16:
      ADVANCE_MAP(
        '!', 60,
        '&', 38,
        '(', 232,
        ')', 233,
        '*', 355,
        '+', 275,
        '-', 280,
        '.', 283,
        '/', 336,
        ':', 237,
        ';', 224,
        '<', 270,
        '=', 238,
        '>', 282,
        '?', 301,
        '[', 294,
        'a', 141,
        'c', 156,
        'w', 127,
        '|', 293,
        '}', 226,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(16);
      END_STATE();
    case 17:
      ADVANCE_MAP(
        '!', 60,
        '&', 38,
        '(', 232,
        '*', 355,
        '+', 274,
        '-', 280,
        '.', 283,
        '/', 336,
        ':', 66,
        '<', 270,
        '=', 63,
        '>', 282,
        '?', 301,
        '[', 294,
        '\\', 32,
        'a', 525,
        'e', 516,
        'u', 517,
        '{', 225,
        '|', 69,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(17);
      if (lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 18:
      ADVANCE_MAP(
        '!', 60,
        '&', 38,
        '(', 232,
        '*', 355,
        '+', 274,
        '-', 280,
        '.', 283,
        '/', 336,
        ':', 62,
        '<', 270,
        '=', 238,
        '>', 282,
        '?', 301,
        '[', 294,
        '\\', 32,
        'a', 525,
        'c', 505,
        'u', 517,
        '|', 69,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(18);
      if (lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 19:
      ADVANCE_MAP(
        '!', 60,
        '&', 38,
        '(', 232,
        '*', 355,
        '+', 274,
        '-', 280,
        '.', 283,
        '/', 336,
        ':', 62,
        '<', 270,
        '=', 238,
        '>', 282,
        '?', 301,
        '[', 294,
        '\\', 32,
        'a', 525,
        'd', 521,
        't', 522,
        'u', 517,
        '|', 69,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(19);
      if (lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 20:
      ADVANCE_MAP(
        '"', 565,
        '#', 320,
        '\'', 577,
        '(', 232,
        ')', 233,
        '.', 289,
        '0', 539,
        '?', 301,
        '[', 294,
        '\\', 28,
        '`', 571,
        'a', 483,
        'e', 498,
        'f', 419,
        'l', 421,
        'm', 466,
        't', 476,
        'u', 463,
        '{', 225,
        '~', 332,
        '+', 58,
        '-', 58,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(543);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(20);
      if (('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(370);
      END_STATE();
    case 21:
      ADVANCE_MAP(
        '"', 565,
        '#', 320,
        '\'', 577,
        '(', 232,
        ')', 233,
        '.', 55,
        '0', 539,
        '?', 301,
        '[', 294,
        '\\', 28,
        ']', 298,
        '`', 571,
        'a', 483,
        'e', 498,
        'f', 419,
        'l', 421,
        'm', 466,
        't', 477,
        'u', 463,
        '{', 225,
        '}', 226,
        '+', 58,
        '-', 58,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(543);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(21);
      if (('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(370);
      END_STATE();
    case 22:
      ADVANCE_MAP(
        '"', 565,
        '#', 320,
        '\'', 577,
        '(', 232,
        '.', 208,
        '0', 539,
        '?', 301,
        '[', 294,
        '\\', 28,
        '`', 571,
        'a', 483,
        'e', 498,
        'f', 419,
        'l', 421,
        'm', 466,
        'r', 445,
        't', 476,
        'u', 463,
        '{', 225,
        '+', 58,
        '-', 58,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(543);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(22);
      if (('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(370);
      END_STATE();
    case 23:
      ADVANCE_MAP(
        '"', 565,
        '#', 320,
        '\'', 577,
        '(', 232,
        '.', 208,
        '0', 539,
        '?', 301,
        '[', 294,
        '\\', 28,
        '`', 571,
        'a', 483,
        'e', 498,
        'f', 419,
        'l', 421,
        'm', 466,
        'r', 445,
        't', 477,
        'u', 463,
        '{', 225,
        '+', 58,
        '-', 58,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(543);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(23);
      if (('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(370);
      END_STATE();
    case 24:
      ADVANCE_MAP(
        '"', 565,
        '\'', 577,
        '.', 208,
        '0', 539,
        '\\', 33,
        '`', 571,
        'f', 76,
        't', 80,
        '+', 58,
        '-', 58,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(543);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(24);
      if (('_' <= lookahead && lookahead <= 'z')) ADVANCE(83);
      END_STATE();
    case 25:
      if (lookahead == '"') ADVANCE(565);
      if (lookahead == '.') ADVANCE(54);
      if (lookahead == '\\') ADVANCE(372);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(25);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(371);
      END_STATE();
    case 26:
      if (lookahead == '"') ADVANCE(565);
      if (lookahead == '.') ADVANCE(284);
      if (lookahead == '\\') ADVANCE(32);
      if (lookahead == 'a') ADVANCE(525);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'u') ADVANCE(517);
      if (lookahead == '}') ADVANCE(226);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(26);
      if (lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 27:
      if (lookahead == '"') ADVANCE(565);
      if (lookahead == '\\') ADVANCE(186);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) ADVANCE(566);
      if (lookahead != 0) ADVANCE(567);
      END_STATE();
    case 28:
      if (lookahead == '"') ADVANCE(219);
      END_STATE();
    case 29:
      if (lookahead == '"') ADVANCE(536);
      if (lookahead != 0) ADVANCE(29);
      END_STATE();
    case 30:
      if (lookahead == '"') ADVANCE(535);
      if (lookahead != 0) ADVANCE(30);
      END_STATE();
    case 31:
      if (lookahead == '"') ADVANCE(75);
      if (lookahead != 0) ADVANCE(31);
      END_STATE();
    case 32:
      if (lookahead == '"') ADVANCE(220);
      END_STATE();
    case 33:
      if (lookahead == '"') ADVANCE(221);
      END_STATE();
    case 34:
      ADVANCE_MAP(
        '#', 320,
        '(', 232,
        ')', 233,
        '.', 288,
        '>', 281,
        '[', 295,
        '\\', 32,
        'm', 401,
        't', 416,
        'u', 395,
        '{', 225,
        '|', 292,
        '~', 332,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(34);
      if (lookahead == '\'' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(370);
      END_STATE();
    case 35:
      if (lookahead == '$') ADVANCE(575);
      if (lookahead == '\\') ADVANCE(74);
      if (lookahead == '`') ADVANCE(572);
      if (lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(36);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(573);
      END_STATE();
    case 36:
      if (lookahead == '$') ADVANCE(575);
      if (lookahead == '\\') ADVANCE(73);
      if (lookahead == '`') ADVANCE(572);
      if (lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(36);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(573);
      END_STATE();
    case 37:
      if (lookahead == '%') ADVANCE(366);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(37);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(537);
      END_STATE();
    case 38:
      if (lookahead == '&') ADVANCE(347);
      END_STATE();
    case 39:
      if (lookahead == '\'') ADVANCE(577);
      if (lookahead == '\\') ADVANCE(186);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) ADVANCE(579);
      if (lookahead != 0) ADVANCE(578);
      END_STATE();
    case 40:
      ADVANCE_MAP(
        '(', 232,
        ')', 233,
        '+', 61,
        ',', 259,
        '.', 283,
        ':', 235,
        ';', 224,
        '=', 239,
        '>', 281,
        ']', 298,
        'a', 141,
        'c', 156,
        'i', 116,
        'w', 124,
        '|', 292,
        '}', 226,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(40);
      END_STATE();
    case 41:
      ADVANCE_MAP(
        '(', 232,
        ')', 233,
        ',', 259,
        '-', 65,
        '.', 283,
        '/', 335,
        ':', 235,
        '=', 239,
        '>', 281,
        '?', 301,
        '[', 294,
        '\\', 32,
        'a', 525,
        'u', 517,
        '{', 225,
        '|', 68,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(41);
      if (lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(370);
      END_STATE();
    case 42:
      ADVANCE_MAP(
        '(', 232,
        '-', 65,
        '.', 283,
        '/', 335,
        '>', 281,
        '?', 301,
        '[', 294,
        '\\', 32,
        'a', 525,
        'e', 516,
        'u', 517,
        '{', 225,
        '|', 68,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(42);
      if (lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 43:
      ADVANCE_MAP(
        '(', 232,
        '.', 56,
        '[', 295,
        '\\', 32,
        'm', 401,
        'p', 405,
        't', 416,
        'u', 395,
        '{', 225,
        '|', 292,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(43);
      if (lookahead == '\'' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(370);
      END_STATE();
    case 44:
      if (lookahead == '(') ADVANCE(232);
      if (lookahead == '.') ADVANCE(56);
      if (lookahead == '\\') ADVANCE(32);
      if (lookahead == 'u') ADVANCE(398);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(44);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(370);
      if (lookahead == '\'' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 45:
      if (lookahead == '(') ADVANCE(232);
      if (lookahead == '\\') ADVANCE(32);
      if (lookahead == 'r') ADVANCE(384);
      if (lookahead == 't') ADVANCE(416);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(45);
      if (lookahead == '\'' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(370);
      END_STATE();
    case 46:
      if (lookahead == '(') ADVANCE(232);
      if (lookahead == '\\') ADVANCE(32);
      if (lookahead == 'r') ADVANCE(384);
      if (lookahead == 'u') ADVANCE(398);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(46);
      if (lookahead == '\'' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(370);
      END_STATE();
    case 47:
      ADVANCE_MAP(
        ')', 233,
        '+', 61,
        '.', 283,
        ';', 224,
        '<', 269,
        '=', 239,
        '\\', 32,
        'a', 397,
        'c', 402,
        '|', 292,
        '}', 226,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(47);
      if (lookahead == '\'' ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 48:
      ADVANCE_MAP(
        ')', 233,
        ',', 259,
        '.', 283,
        ':', 234,
        ';', 224,
        '<', 269,
        '=', 239,
        '\\', 32,
        'a', 397,
        'w', 392,
        '|', 292,
        '}', 226,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(48);
      if (lookahead == '\'' ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 49:
      ADVANCE_MAP(
        ')', 233,
        ',', 259,
        '.', 283,
        ':', 235,
        '<', 269,
        '=', 239,
        '>', 281,
        '\\', 32,
        ']', 298,
        'a', 407,
        '|', 292,
        '}', 226,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(49);
      if (lookahead == '\'' ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 50:
      ADVANCE_MAP(
        ')', 233,
        '.', 283,
        ';', 224,
        '<', 269,
        '=', 239,
        '\\', 32,
        'a', 397,
        '|', 292,
        '}', 226,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(50);
      if (lookahead == '\'' ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 51:
      if (lookahead == '+') ADVANCE(271);
      if (lookahead == '-') ADVANCE(277);
      if (lookahead == '>') ADVANCE(281);
      if (lookahead == '\\') ADVANCE(32);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(51);
      if (lookahead == '\'' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 52:
      if (lookahead == '.') ADVANCE(302);
      END_STATE();
    case 53:
      if (lookahead == '.') ADVANCE(199);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(553);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(197);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(53);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(198);
      END_STATE();
    case 54:
      if (lookahead == '.') ADVANCE(52);
      END_STATE();
    case 55:
      if (lookahead == '.') ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(550);
      END_STATE();
    case 56:
      if (lookahead == '.') ADVANCE(303);
      END_STATE();
    case 57:
      ADVANCE_MAP(
        '.', 283,
        ':', 234,
        '<', 269,
        '=', 67,
        '\\', 32,
        'a', 407,
        'i', 386,
        'w', 388,
        '|', 292,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(57);
      if (lookahead == '\'' ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 58:
      if (lookahead == '.') ADVANCE(208);
      if (lookahead == '0') ADVANCE(541);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(59);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(544);
      END_STATE();
    case 59:
      if (lookahead == '0') ADVANCE(201);
      END_STATE();
    case 60:
      if (lookahead == '=') ADVANCE(362);
      END_STATE();
    case 61:
      if (lookahead == '=') ADVANCE(266);
      END_STATE();
    case 62:
      if (lookahead == '=') ADVANCE(337);
      if (lookahead == '>') ADVANCE(365);
      END_STATE();
    case 63:
      if (lookahead == '=') ADVANCE(360);
      END_STATE();
    case 64:
      if (lookahead == '=') ADVANCE(360);
      if (lookahead == '>') ADVANCE(258);
      END_STATE();
    case 65:
      if (lookahead == '>') ADVANCE(330);
      END_STATE();
    case 66:
      if (lookahead == '>') ADVANCE(365);
      END_STATE();
    case 67:
      if (lookahead == '>') ADVANCE(258);
      END_STATE();
    case 68:
      if (lookahead == '>') ADVANCE(331);
      END_STATE();
    case 69:
      if (lookahead == '>') ADVANCE(331);
      if (lookahead == '|') ADVANCE(348);
      END_STATE();
    case 70:
      if (lookahead == '\\') ADVANCE(32);
      if (lookahead == 't') ADVANCE(416);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(70);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(370);
      if (lookahead == '\'' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 71:
      if (lookahead == '_') ADVANCE(203);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(538);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(71);
      END_STATE();
    case 72:
      if (lookahead == '_') ADVANCE(205);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(538);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(72);
      END_STATE();
    case 73:
      if (lookahead == '`') ADVANCE(574);
      END_STATE();
    case 74:
      if (lookahead == '`') ADVANCE(574);
      if (lookahead == 'u') ADVANCE(194);
      if (lookahead == 'x') ADVANCE(218);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(570);
      if (lookahead != 0) ADVANCE(568);
      END_STATE();
    case 75:
      if (lookahead == '`') ADVANCE(571);
      END_STATE();
    case 76:
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'a') ADVANCE(79);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(83);
      END_STATE();
    case 77:
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'e') ADVANCE(561);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(83);
      END_STATE();
    case 78:
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'e') ADVANCE(564);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(83);
      END_STATE();
    case 79:
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'l') ADVANCE(81);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(83);
      END_STATE();
    case 80:
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'r') ADVANCE(82);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(83);
      END_STATE();
    case 81:
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 's') ADVANCE(78);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(83);
      END_STATE();
    case 82:
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(77);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(83);
      END_STATE();
    case 83:
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(83);
      END_STATE();
    case 84:
      if (lookahead == 'a') ADVANCE(180);
      if (lookahead == 'o') ADVANCE(146);
      END_STATE();
    case 85:
      if (lookahead == 'a') ADVANCE(139);
      if (lookahead == 'o') ADVANCE(165);
      END_STATE();
    case 86:
      if (lookahead == 'a') ADVANCE(193);
      if (lookahead == 'e') ADVANCE(173);
      END_STATE();
    case 87:
      if (lookahead == 'a') ADVANCE(93);
      END_STATE();
    case 88:
      if (lookahead == 'a') ADVANCE(135);
      END_STATE();
    case 89:
      if (lookahead == 'a') ADVANCE(129);
      END_STATE();
    case 90:
      if (lookahead == 'a') ADVANCE(96);
      END_STATE();
    case 91:
      if (lookahead == 'a') ADVANCE(130);
      END_STATE();
    case 92:
      if (lookahead == 'a') ADVANCE(184);
      END_STATE();
    case 93:
      if (lookahead == 'b') ADVANCE(138);
      END_STATE();
    case 94:
      if (lookahead == 'c') ADVANCE(245);
      END_STATE();
    case 95:
      if (lookahead == 'c') ADVANCE(307);
      END_STATE();
    case 96:
      if (lookahead == 'c') ADVANCE(132);
      END_STATE();
    case 97:
      if (lookahead == 'c') ADVANCE(121);
      END_STATE();
    case 98:
      if (lookahead == 'c') ADVANCE(122);
      END_STATE();
    case 99:
      if (lookahead == 'c') ADVANCE(111);
      if (lookahead == 'p') ADVANCE(159);
      if (lookahead == 't') ADVANCE(112);
      END_STATE();
    case 100:
      if (lookahead == 'd') ADVANCE(251);
      END_STATE();
    case 101:
      if (lookahead == 'd') ADVANCE(188);
      END_STATE();
    case 102:
      if (lookahead == 'e') ADVANCE(94);
      END_STATE();
    case 103:
      if (lookahead == 'e') ADVANCE(313);
      END_STATE();
    case 104:
      if (lookahead == 'e') ADVANCE(559);
      END_STATE();
    case 105:
      if (lookahead == 'e') ADVANCE(248);
      END_STATE();
    case 106:
      if (lookahead == 'e') ADVANCE(562);
      END_STATE();
    case 107:
      if (lookahead == 'e') ADVANCE(345);
      END_STATE();
    case 108:
      if (lookahead == 'e') ADVANCE(242);
      END_STATE();
    case 109:
      if (lookahead == 'e') ADVANCE(299);
      END_STATE();
    case 110:
      if (lookahead == 'e') ADVANCE(267);
      END_STATE();
    case 111:
      if (lookahead == 'e') ADVANCE(163);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(166);
      END_STATE();
    case 113:
      if (lookahead == 'e') ADVANCE(143);
      END_STATE();
    case 114:
      if (lookahead == 'e') ADVANCE(144);
      END_STATE();
    case 115:
      if (lookahead == 'e') ADVANCE(144);
      if (lookahead == 'i') ADVANCE(136);
      END_STATE();
    case 116:
      if (lookahead == 'f') ADVANCE(310);
      END_STATE();
    case 117:
      if (lookahead == 'f') ADVANCE(310);
      if (lookahead == 'n') ADVANCE(340);
      END_STATE();
    case 118:
      if (lookahead == 'f') ADVANCE(367);
      if (lookahead == 'p') ADVANCE(113);
      END_STATE();
    case 119:
      if (lookahead == 'h') ADVANCE(115);
      if (lookahead == 'i') ADVANCE(174);
      END_STATE();
    case 120:
      if (lookahead == 'h') ADVANCE(368);
      END_STATE();
    case 121:
      if (lookahead == 'h') ADVANCE(323);
      END_STATE();
    case 122:
      if (lookahead == 'h') ADVANCE(316);
      END_STATE();
    case 123:
      if (lookahead == 'h') ADVANCE(114);
      END_STATE();
    case 124:
      if (lookahead == 'h') ADVANCE(114);
      if (lookahead == 'i') ADVANCE(174);
      END_STATE();
    case 125:
      if (lookahead == 'i') ADVANCE(189);
      END_STATE();
    case 126:
      if (lookahead == 'i') ADVANCE(160);
      END_STATE();
    case 127:
      if (lookahead == 'i') ADVANCE(174);
      END_STATE();
    case 128:
      if (lookahead == 'i') ADVANCE(175);
      if (lookahead == 'p') ADVANCE(90);
      END_STATE();
    case 129:
      if (lookahead == 'i') ADVANCE(176);
      END_STATE();
    case 130:
      if (lookahead == 'i') ADVANCE(151);
      END_STATE();
    case 131:
      if (lookahead == 'i') ADVANCE(185);
      END_STATE();
    case 132:
      if (lookahead == 'k') ADVANCE(254);
      END_STATE();
    case 133:
      if (lookahead == 'l') ADVANCE(170);
      END_STATE();
    case 134:
      if (lookahead == 'l') ADVANCE(170);
      if (lookahead == 'x') ADVANCE(99);
      END_STATE();
    case 135:
      if (lookahead == 'l') ADVANCE(260);
      END_STATE();
    case 136:
      if (lookahead == 'l') ADVANCE(107);
      END_STATE();
    case 137:
      if (lookahead == 'l') ADVANCE(108);
      END_STATE();
    case 138:
      if (lookahead == 'l') ADVANCE(109);
      END_STATE();
    case 139:
      if (lookahead == 'l') ADVANCE(172);
      END_STATE();
    case 140:
      if (lookahead == 'n') ADVANCE(100);
      if (lookahead == 's') ADVANCE(327);
      if (lookahead == 'w') ADVANCE(89);
      END_STATE();
    case 141:
      if (lookahead == 'n') ADVANCE(100);
      if (lookahead == 's') ADVANCE(325);
      END_STATE();
    case 142:
      if (lookahead == 'n') ADVANCE(128);
      END_STATE();
    case 143:
      if (lookahead == 'n') ADVANCE(227);
      END_STATE();
    case 144:
      if (lookahead == 'n') ADVANCE(318);
      END_STATE();
    case 145:
      if (lookahead == 'n') ADVANCE(262);
      END_STATE();
    case 146:
      if (lookahead == 'n') ADVANCE(171);
      END_STATE();
    case 147:
      if (lookahead == 'n') ADVANCE(95);
      END_STATE();
    case 148:
      if (lookahead == 'n') ADVANCE(161);
      END_STATE();
    case 149:
      if (lookahead == 'n') ADVANCE(88);
      END_STATE();
    case 150:
      if (lookahead == 'n') ADVANCE(181);
      END_STATE();
    case 151:
      if (lookahead == 'n') ADVANCE(178);
      END_STATE();
    case 152:
      if (lookahead == 'o') ADVANCE(341);
      END_STATE();
    case 153:
      if (lookahead == 'o') ADVANCE(341);
      if (lookahead == 'r') ADVANCE(187);
      if (lookahead == 'y') ADVANCE(162);
      END_STATE();
    case 154:
      if (lookahead == 'o') ADVANCE(343);
      END_STATE();
    case 155:
      if (lookahead == 'o') ADVANCE(191);
      END_STATE();
    case 156:
      if (lookahead == 'o') ADVANCE(146);
      END_STATE();
    case 157:
      if (lookahead == 'o') ADVANCE(101);
      END_STATE();
    case 158:
      if (lookahead == 'o') ADVANCE(101);
      if (lookahead == 'u') ADVANCE(179);
      END_STATE();
    case 159:
      if (lookahead == 'o') ADVANCE(167);
      END_STATE();
    case 160:
      if (lookahead == 'o') ADVANCE(145);
      END_STATE();
    case 161:
      if (lookahead == 'p') ADVANCE(90);
      END_STATE();
    case 162:
      if (lookahead == 'p') ADVANCE(105);
      END_STATE();
    case 163:
      if (lookahead == 'p') ADVANCE(182);
      END_STATE();
    case 164:
      if (lookahead == 'r') ADVANCE(125);
      END_STATE();
    case 165:
      if (lookahead == 'r') ADVANCE(338);
      END_STATE();
    case 166:
      if (lookahead == 'r') ADVANCE(149);
      END_STATE();
    case 167:
      if (lookahead == 'r') ADVANCE(177);
      END_STATE();
    case 168:
      if (lookahead == 'r') ADVANCE(91);
      END_STATE();
    case 169:
      if (lookahead == 's') ADVANCE(325);
      END_STATE();
    case 170:
      if (lookahead == 's') ADVANCE(103);
      END_STATE();
    case 171:
      if (lookahead == 's') ADVANCE(183);
      END_STATE();
    case 172:
      if (lookahead == 's') ADVANCE(106);
      END_STATE();
    case 173:
      if (lookahead == 't') ADVANCE(305);
      END_STATE();
    case 174:
      if (lookahead == 't') ADVANCE(120);
      END_STATE();
    case 175:
      if (lookahead == 't') ADVANCE(557);
      END_STATE();
    case 176:
      if (lookahead == 't') ADVANCE(240);
      END_STATE();
    case 177:
      if (lookahead == 't') ADVANCE(264);
      END_STATE();
    case 178:
      if (lookahead == 't') ADVANCE(290);
      END_STATE();
    case 179:
      if (lookahead == 't') ADVANCE(87);
      END_STATE();
    case 180:
      if (lookahead == 't') ADVANCE(97);
      END_STATE();
    case 181:
      if (lookahead == 't') ADVANCE(154);
      END_STATE();
    case 182:
      if (lookahead == 't') ADVANCE(126);
      END_STATE();
    case 183:
      if (lookahead == 't') ADVANCE(168);
      END_STATE();
    case 184:
      if (lookahead == 't') ADVANCE(110);
      END_STATE();
    case 185:
      if (lookahead == 't') ADVANCE(98);
      END_STATE();
    case 186:
      if (lookahead == 'u') ADVANCE(194);
      if (lookahead == 'x') ADVANCE(218);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(570);
      if (lookahead != 0) ADVANCE(568);
      END_STATE();
    case 187:
      if (lookahead == 'u') ADVANCE(104);
      if (lookahead == 'y') ADVANCE(321);
      END_STATE();
    case 188:
      if (lookahead == 'u') ADVANCE(137);
      END_STATE();
    case 189:
      if (lookahead == 'v') ADVANCE(92);
      END_STATE();
    case 190:
      if (lookahead == 'w') ADVANCE(131);
      END_STATE();
    case 191:
      if (lookahead == 'w') ADVANCE(150);
      END_STATE();
    case 192:
      if (lookahead == 'y') ADVANCE(333);
      END_STATE();
    case 193:
      if (lookahead == 'z') ADVANCE(192);
      END_STATE();
    case 194:
      if (lookahead == '{') ADVANCE(216);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(217);
      END_STATE();
    case 195:
      if (lookahead == '}') ADVANCE(568);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(195);
      END_STATE();
    case 196:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(210);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(549);
      END_STATE();
    case 197:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(212);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(538);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(200);
      END_STATE();
    case 198:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(538);
      END_STATE();
    case 199:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(553);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(197);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(199);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(198);
      END_STATE();
    case 200:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(553);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(200);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(198);
      END_STATE();
    case 201:
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(214);
      END_STATE();
    case 202:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(547);
      END_STATE();
    case 203:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(71);
      END_STATE();
    case 204:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(548);
      END_STATE();
    case 205:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(72);
      END_STATE();
    case 206:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(543);
      END_STATE();
    case 207:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(544);
      END_STATE();
    case 208:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(550);
      END_STATE();
    case 209:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(546);
      END_STATE();
    case 210:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(549);
      END_STATE();
    case 211:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(556);
      END_STATE();
    case 212:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(200);
      END_STATE();
    case 213:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(545);
      END_STATE();
    case 214:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(53);
      END_STATE();
    case 215:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(568);
      END_STATE();
    case 216:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(195);
      END_STATE();
    case 217:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(218);
      END_STATE();
    case 218:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(215);
      END_STATE();
    case 219:
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(29);
      END_STATE();
    case 220:
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(30);
      END_STATE();
    case 221:
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(31);
      END_STATE();
    case 222:
      if (eof) ADVANCE(223);
      ADVANCE_MAP(
        '!', 229,
        '"', 565,
        '#', 320,
        '%', 366,
        '\'', 577,
        '(', 232,
        ')', 233,
        '+', 276,
        ',', 259,
        '-', 279,
        '.', 285,
        '0', 539,
        ';', 224,
        '<', 269,
        '>', 281,
        '?', 301,
        '[', 294,
        '\\', 28,
        '`', 571,
        'a', 481,
        'e', 497,
        'f', 418,
        'i', 446,
        'l', 420,
        'm', 466,
        'o', 469,
        's', 496,
        't', 473,
        'u', 463,
        'w', 449,
        '{', 225,
        '|', 292,
        '}', 226,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(543);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(222);
      if (('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(370);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_open);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_open);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(362);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_include);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(337);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(337);
      if (lookahead == '>') ADVANCE(365);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '>') ADVANCE(365);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(360);
      if (lookahead == '>') ADVANCE(258);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(258);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_await);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_module);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_module);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_rec);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_rec);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_rec);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_type);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_type);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_and);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_and);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_unpack);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_unpack);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_unpack);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_unpack);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_external);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_external);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_exception);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_exception);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_export);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_private);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(359);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(350);
      if (lookahead == '-') ADVANCE(59);
      if (lookahead == '.') ADVANCE(352);
      if (lookahead == '0') ADVANCE(541);
      if (lookahead == '=') ADVANCE(266);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(544);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(350);
      if (lookahead == '-') ADVANCE(59);
      if (lookahead == '.') ADVANCE(352);
      if (lookahead == '0') ADVANCE(541);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(544);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(349);
      if (lookahead == '.') ADVANCE(351);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(349);
      if (lookahead == '.') ADVANCE(351);
      if (lookahead == '=') ADVANCE(266);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '.') ADVANCE(352);
      if (lookahead == '0') ADVANCE(541);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(59);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(544);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(354);
      if (lookahead == '0') ADVANCE(541);
      if (lookahead == '>') ADVANCE(330);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(59);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(544);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(354);
      if (lookahead == '0') ADVANCE(541);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(59);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(544);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(353);
      if (lookahead == '>') ADVANCE(330);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(364);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(304);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(304);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(550);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(52);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(550);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(303);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(550);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_constraint);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_constraint);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '>') ADVANCE(331);
      if (lookahead == '|') ADVANCE(348);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '<') ADVANCE(297);
      if (lookahead == '>') ADVANCE(296);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_LBRACK_GT);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_LBRACK_LT);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_mutable);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_mutable);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      if (lookahead == '.') ADVANCE(302);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_let);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_async);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(anon_sym_async);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_if);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_if);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(anon_sym_switch);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(anon_sym_when);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(anon_sym_when);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(anon_sym_try);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(anon_sym_catch);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 'y') ADVANCE(518);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 'y') ADVANCE(147);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(anon_sym_assert);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(anon_sym_PIPE_GT);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(anon_sym_lazy);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(anon_sym_lazy);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '.') ADVANCE(358);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_for);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(anon_sym_to);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(anon_sym_to);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(anon_sym_downto);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(anon_sym_downto);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(anon_sym_while);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      if (lookahead == '0') ADVANCE(201);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(anon_sym_PLUS_DOT);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(anon_sym_PLUS_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(550);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(anon_sym_DASH_DOT);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(anon_sym_DASH_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(550);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(357);
      if (lookahead == '.') ADVANCE(356);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(anon_sym_STAR_DOT);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(anon_sym_SLASH_DOT);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(361);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(363);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym_COLON_GT);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(anon_sym_with);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(aux_sym_variant_identifier_token1);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(aux_sym_polyvar_identifier_token1);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(371);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      if (lookahead == '`') ADVANCE(574);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'a') ADVANCE(377);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'a') ADVANCE(413);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'a') ADVANCE(391);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'c') ADVANCE(393);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'c') ADVANCE(247);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'd') ADVANCE(414);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'd') ADVANCE(252);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'e') ADVANCE(250);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'e') ADVANCE(244);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'e') ADVANCE(268);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'e') ADVANCE(378);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'e') ADVANCE(396);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'f') ADVANCE(312);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'h') ADVANCE(369);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'h') ADVANCE(385);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'i') ADVANCE(409);
      if (lookahead == 'p') ADVANCE(374);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'i') ADVANCE(415);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'i') ADVANCE(400);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'i') ADVANCE(411);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'k') ADVANCE(256);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'l') ADVANCE(382);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'n') ADVANCE(389);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'n') ADVANCE(319);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'n') ADVANCE(380);
      if (lookahead == 's') ADVANCE(328);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'n') ADVANCE(404);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'n') ADVANCE(408);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'n') ADVANCE(410);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'o') ADVANCE(379);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'o') ADVANCE(399);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'p') ADVANCE(381);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'p') ADVANCE(374);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'r') ADVANCE(390);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'r') ADVANCE(376);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 's') ADVANCE(328);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 's') ADVANCE(412);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 't') ADVANCE(558);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 't') ADVANCE(291);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 't') ADVANCE(387);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 't') ADVANCE(406);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 't') ADVANCE(383);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'u') ADVANCE(394);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'v') ADVANCE(375);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == 'y') ADVANCE(403);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(aux_sym_type_identifier_token1);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'a') ADVANCE(455);
      if (lookahead == 'o') ADVANCE(475);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'a') ADVANCE(455);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'a') ADVANCE(501);
      if (lookahead == 'e') ADVANCE(486);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'a') ADVANCE(501);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'a') ADVANCE(456);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'a') ADVANCE(426);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'a') ADVANCE(453);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'c') ADVANCE(308);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'c') ADVANCE(454);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'c') ADVANCE(246);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'c') ADVANCE(448);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'c') ADVANCE(457);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'c') ADVANCE(442);
      if (lookahead == 'p') ADVANCE(468);
      if (lookahead == 't') ADVANCE(444);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'c') ADVANCE(442);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'd') ADVANCE(495);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'd') ADVANCE(439);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'e') ADVANCE(560);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'e') ADVANCE(249);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'e') ADVANCE(563);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'e') ADVANCE(346);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'e') ADVANCE(243);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'e') ADVANCE(231);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'e') ADVANCE(314);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'e') ADVANCE(479);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'e') ADVANCE(471);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'e') ADVANCE(461);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'e') ADVANCE(478);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'e') ADVANCE(427);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'f') ADVANCE(311);
      if (lookahead == 'n') ADVANCE(429);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'f') ADVANCE(311);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'h') ADVANCE(317);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'h') ADVANCE(452);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'i') ADVANCE(490);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'i') ADVANCE(467);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'i') ADVANCE(458);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'i') ADVANCE(487);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'k') ADVANCE(255);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'l') ADVANCE(484);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'l') ADVANCE(261);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'l') ADVANCE(492);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'l') ADVANCE(437);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'l') ADVANCE(438);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'l') ADVANCE(485);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'n') ADVANCE(228);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'n') ADVANCE(263);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'n') ADVANCE(470);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'n') ADVANCE(425);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'n') ADVANCE(422);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'o') ADVANCE(432);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'o') ADVANCE(462);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'o') ADVANCE(480);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'p') ADVANCE(443);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'p') ADVANCE(423);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'p') ADVANCE(491);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 472:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'p') ADVANCE(435);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'r') ADVANCE(493);
      if (lookahead == 'y') ADVANCE(472);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'r') ADVANCE(493);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'r') ADVANCE(339);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 476:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'r') ADVANCE(494);
      if (lookahead == 'y') ADVANCE(472);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'r') ADVANCE(494);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'r') ADVANCE(465);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 479:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'r') ADVANCE(488);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'r') ADVANCE(489);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 481:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 's') ADVANCE(482);
      if (lookahead == 'w') ADVANCE(424);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 's') ADVANCE(441);
      if (lookahead == 'y') ADVANCE(464);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 483:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 's') ADVANCE(500);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 484:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 's') ADVANCE(436);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 485:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 's') ADVANCE(440);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 486:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 't') ADVANCE(306);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 't') ADVANCE(241);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 't') ADVANCE(329);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 't') ADVANCE(265);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 't') ADVANCE(428);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 't') ADVANCE(451);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(433);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(434);
      if (lookahead == 'y') ADVANCE(322);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 494:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(434);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 495:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(459);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 496:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'w') ADVANCE(450);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'x') ADVANCE(430);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'x') ADVANCE(431);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 499:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'y') ADVANCE(334);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 500:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'y') ADVANCE(464);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 501:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == 'z') ADVANCE(499);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'y')) ADVANCE(502);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 'a') ADVANCE(506);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 504:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 'a') ADVANCE(508);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 505:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 'a') ADVANCE(529);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 506:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 'b') ADVANCE(515);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 'c') ADVANCE(309);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 508:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 'c') ADVANCE(514);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 509:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 'c') ADVANCE(513);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 510:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 'd') ADVANCE(253);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 511:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 'e') ADVANCE(315);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 512:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 'e') ADVANCE(300);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 513:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 'h') ADVANCE(324);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 514:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 'k') ADVANCE(257);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 515:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 'l') ADVANCE(512);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 516:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 'l') ADVANCE(527);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 'n') ADVANCE(524);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 518:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 'n') ADVANCE(507);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 'n') ADVANCE(510);
      if (lookahead == 's') ADVANCE(533);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 520:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 'n') ADVANCE(530);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 'o') ADVANCE(532);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 522:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 'o') ADVANCE(342);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 'o') ADVANCE(344);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 'p') ADVANCE(504);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 's') ADVANCE(533);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 's') ADVANCE(326);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 527:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 's') ADVANCE(511);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 528:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 't') ADVANCE(503);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 't') ADVANCE(509);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 530:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 't') ADVANCE(523);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 531:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 'u') ADVANCE(528);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 532:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 'w') ADVANCE(520);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 533:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == 'y') ADVANCE(518);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 534:
      ACCEPT_TOKEN(aux_sym_value_identifier_token1);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(534);
      END_STATE();
    case 535:
      ACCEPT_TOKEN(sym__escape_identifier);
      END_STATE();
    case 536:
      ACCEPT_TOKEN(sym__escape_identifier);
      if (lookahead == '`') ADVANCE(571);
      END_STATE();
    case 537:
      ACCEPT_TOKEN(sym_extension_identifier);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(537);
      END_STATE();
    case 538:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 539:
      ACCEPT_TOKEN(sym_number);
      ADVANCE_MAP(
        '.', 552,
        '0', 540,
        '_', 209,
        'B', 202,
        'b', 202,
        'E', 196,
        'e', 196,
        'O', 204,
        'o', 204,
        'X', 213,
        'x', 213,
        'L', 538,
        'l', 538,
        'n', 538,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(543);
      END_STATE();
    case 540:
      ACCEPT_TOKEN(sym_number);
      ADVANCE_MAP(
        '.', 552,
        '0', 540,
        '_', 209,
        'E', 196,
        'e', 196,
        'L', 538,
        'l', 538,
        'n', 538,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(543);
      END_STATE();
    case 541:
      ACCEPT_TOKEN(sym_number);
      ADVANCE_MAP(
        '.', 552,
        '0', 542,
        '_', 210,
        'B', 203,
        'b', 203,
        'E', 196,
        'e', 196,
        'L', 538,
        'l', 538,
        'O', 205,
        'o', 205,
        'X', 213,
        'x', 213,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(544);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(552);
      if (lookahead == '0') ADVANCE(542);
      if (lookahead == '_') ADVANCE(210);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(196);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(538);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(544);
      END_STATE();
    case 543:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(552);
      if (lookahead == '_') ADVANCE(206);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(196);
      if (lookahead == 'L' ||
          lookahead == 'l' ||
          lookahead == 'n') ADVANCE(538);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(543);
      END_STATE();
    case 544:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(552);
      if (lookahead == '_') ADVANCE(207);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(196);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(538);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(544);
      END_STATE();
    case 545:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(554);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(551);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(545);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(555);
      END_STATE();
    case 546:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(209);
      if (lookahead == 'n') ADVANCE(538);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(546);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(202);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(547);
      if (lookahead == 'L' ||
          lookahead == 'l' ||
          lookahead == 'n') ADVANCE(538);
      END_STATE();
    case 548:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(204);
      if (lookahead == 'L' ||
          lookahead == 'l' ||
          lookahead == 'n') ADVANCE(538);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(548);
      END_STATE();
    case 549:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(210);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(549);
      END_STATE();
    case 550:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(208);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(196);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(550);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(211);
      if (lookahead == 'L' ||
          lookahead == 'l' ||
          lookahead == 'n') ADVANCE(538);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(556);
      END_STATE();
    case 552:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(196);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(550);
      END_STATE();
    case 553:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(538);
      END_STATE();
    case 554:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(551);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(554);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(555);
      END_STATE();
    case 555:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'L' ||
          lookahead == 'l' ||
          lookahead == 'n') ADVANCE(538);
      END_STATE();
    case 556:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(556);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(555);
      END_STATE();
    case 557:
      ACCEPT_TOKEN(sym_unit_type);
      END_STATE();
    case 558:
      ACCEPT_TOKEN(sym_unit_type);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(417);
      END_STATE();
    case 559:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 560:
      ACCEPT_TOKEN(sym_true);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 561:
      ACCEPT_TOKEN(sym_true);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(83);
      END_STATE();
    case 562:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 563:
      ACCEPT_TOKEN(sym_false);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(502);
      END_STATE();
    case 564:
      ACCEPT_TOKEN(sym_false);
      if (lookahead == '`') ADVANCE(571);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(83);
      END_STATE();
    case 565:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 566:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) ADVANCE(566);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(567);
      END_STATE();
    case 567:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(567);
      END_STATE();
    case 568:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 569:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(568);
      END_STATE();
    case 570:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(569);
      END_STATE();
    case 571:
      ACCEPT_TOKEN(aux_sym_template_string_token1);
      END_STATE();
    case 572:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 573:
      ACCEPT_TOKEN(aux_sym_template_string_content_token1);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(573);
      END_STATE();
    case 574:
      ACCEPT_TOKEN(anon_sym_BSLASH_BQUOTE);
      END_STATE();
    case 575:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '{') ADVANCE(576);
      END_STATE();
    case 576:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 577:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 578:
      ACCEPT_TOKEN(aux_sym_character_token1);
      END_STATE();
    case 579:
      ACCEPT_TOKEN(aux_sym_character_token1);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) ADVANCE(579);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(578);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 222, .external_lex_state = 2},
  [2] = {.lex_state = 222, .external_lex_state = 3},
  [3] = {.lex_state = 222, .external_lex_state = 3},
  [4] = {.lex_state = 222, .external_lex_state = 3},
  [5] = {.lex_state = 222, .external_lex_state = 3},
  [6] = {.lex_state = 222, .external_lex_state = 3},
  [7] = {.lex_state = 222, .external_lex_state = 3},
  [8] = {.lex_state = 222, .external_lex_state = 3},
  [9] = {.lex_state = 222, .external_lex_state = 3},
  [10] = {.lex_state = 222, .external_lex_state = 3},
  [11] = {.lex_state = 1, .external_lex_state = 3},
  [12] = {.lex_state = 1, .external_lex_state = 3},
  [13] = {.lex_state = 1, .external_lex_state = 3},
  [14] = {.lex_state = 1, .external_lex_state = 3},
  [15] = {.lex_state = 1, .external_lex_state = 3},
  [16] = {.lex_state = 1, .external_lex_state = 3},
  [17] = {.lex_state = 1, .external_lex_state = 3},
  [18] = {.lex_state = 1, .external_lex_state = 3},
  [19] = {.lex_state = 1, .external_lex_state = 3},
  [20] = {.lex_state = 1, .external_lex_state = 3},
  [21] = {.lex_state = 1, .external_lex_state = 3},
  [22] = {.lex_state = 222, .external_lex_state = 2},
  [23] = {.lex_state = 2, .external_lex_state = 3},
  [24] = {.lex_state = 222, .external_lex_state = 3},
  [25] = {.lex_state = 222, .external_lex_state = 3},
  [26] = {.lex_state = 222, .external_lex_state = 3},
  [27] = {.lex_state = 2, .external_lex_state = 3},
  [28] = {.lex_state = 222, .external_lex_state = 3},
  [29] = {.lex_state = 222, .external_lex_state = 3},
  [30] = {.lex_state = 222, .external_lex_state = 3},
  [31] = {.lex_state = 222, .external_lex_state = 3},
  [32] = {.lex_state = 222, .external_lex_state = 3},
  [33] = {.lex_state = 222, .external_lex_state = 3},
  [34] = {.lex_state = 222, .external_lex_state = 3},
  [35] = {.lex_state = 222, .external_lex_state = 3},
  [36] = {.lex_state = 222, .external_lex_state = 3},
  [37] = {.lex_state = 222, .external_lex_state = 3},
  [38] = {.lex_state = 222, .external_lex_state = 3},
  [39] = {.lex_state = 222, .external_lex_state = 3},
  [40] = {.lex_state = 222, .external_lex_state = 3},
  [41] = {.lex_state = 222, .external_lex_state = 3},
  [42] = {.lex_state = 222, .external_lex_state = 3},
  [43] = {.lex_state = 222, .external_lex_state = 3},
  [44] = {.lex_state = 222, .external_lex_state = 3},
  [45] = {.lex_state = 222, .external_lex_state = 3},
  [46] = {.lex_state = 222, .external_lex_state = 3},
  [47] = {.lex_state = 2, .external_lex_state = 3},
  [48] = {.lex_state = 222, .external_lex_state = 3},
  [49] = {.lex_state = 222, .external_lex_state = 3},
  [50] = {.lex_state = 2, .external_lex_state = 3},
  [51] = {.lex_state = 2, .external_lex_state = 3},
  [52] = {.lex_state = 3, .external_lex_state = 3},
  [53] = {.lex_state = 3, .external_lex_state = 3},
  [54] = {.lex_state = 3, .external_lex_state = 3},
  [55] = {.lex_state = 3, .external_lex_state = 3},
  [56] = {.lex_state = 3, .external_lex_state = 3},
  [57] = {.lex_state = 3, .external_lex_state = 3},
  [58] = {.lex_state = 3, .external_lex_state = 3},
  [59] = {.lex_state = 3, .external_lex_state = 3},
  [60] = {.lex_state = 3, .external_lex_state = 3},
  [61] = {.lex_state = 3, .external_lex_state = 3},
  [62] = {.lex_state = 3, .external_lex_state = 3},
  [63] = {.lex_state = 3, .external_lex_state = 3},
  [64] = {.lex_state = 3, .external_lex_state = 3},
  [65] = {.lex_state = 3, .external_lex_state = 3},
  [66] = {.lex_state = 3, .external_lex_state = 3},
  [67] = {.lex_state = 3, .external_lex_state = 3},
  [68] = {.lex_state = 3, .external_lex_state = 3},
  [69] = {.lex_state = 3, .external_lex_state = 3},
  [70] = {.lex_state = 3, .external_lex_state = 3},
  [71] = {.lex_state = 3, .external_lex_state = 3},
  [72] = {.lex_state = 3, .external_lex_state = 3},
  [73] = {.lex_state = 3, .external_lex_state = 3},
  [74] = {.lex_state = 3, .external_lex_state = 3},
  [75] = {.lex_state = 3, .external_lex_state = 3},
  [76] = {.lex_state = 3, .external_lex_state = 3},
  [77] = {.lex_state = 3, .external_lex_state = 3},
  [78] = {.lex_state = 3, .external_lex_state = 3},
  [79] = {.lex_state = 3, .external_lex_state = 3},
  [80] = {.lex_state = 3, .external_lex_state = 3},
  [81] = {.lex_state = 3, .external_lex_state = 3},
  [82] = {.lex_state = 3, .external_lex_state = 3},
  [83] = {.lex_state = 3, .external_lex_state = 3},
  [84] = {.lex_state = 3, .external_lex_state = 3},
  [85] = {.lex_state = 3, .external_lex_state = 3},
  [86] = {.lex_state = 3, .external_lex_state = 3},
  [87] = {.lex_state = 3, .external_lex_state = 3},
  [88] = {.lex_state = 3, .external_lex_state = 3},
  [89] = {.lex_state = 3, .external_lex_state = 3},
  [90] = {.lex_state = 3, .external_lex_state = 3},
  [91] = {.lex_state = 3, .external_lex_state = 3},
  [92] = {.lex_state = 3, .external_lex_state = 3},
  [93] = {.lex_state = 3, .external_lex_state = 3},
  [94] = {.lex_state = 3, .external_lex_state = 3},
  [95] = {.lex_state = 3, .external_lex_state = 3},
  [96] = {.lex_state = 3, .external_lex_state = 3},
  [97] = {.lex_state = 3, .external_lex_state = 3},
  [98] = {.lex_state = 3, .external_lex_state = 3},
  [99] = {.lex_state = 3, .external_lex_state = 3},
  [100] = {.lex_state = 3, .external_lex_state = 3},
  [101] = {.lex_state = 3, .external_lex_state = 3},
  [102] = {.lex_state = 3, .external_lex_state = 3},
  [103] = {.lex_state = 3, .external_lex_state = 3},
  [104] = {.lex_state = 3, .external_lex_state = 3},
  [105] = {.lex_state = 3, .external_lex_state = 3},
  [106] = {.lex_state = 3, .external_lex_state = 3},
  [107] = {.lex_state = 3, .external_lex_state = 3},
  [108] = {.lex_state = 3, .external_lex_state = 3},
  [109] = {.lex_state = 3, .external_lex_state = 3},
  [110] = {.lex_state = 3, .external_lex_state = 3},
  [111] = {.lex_state = 3, .external_lex_state = 3},
  [112] = {.lex_state = 3, .external_lex_state = 3},
  [113] = {.lex_state = 3, .external_lex_state = 3},
  [114] = {.lex_state = 3, .external_lex_state = 3},
  [115] = {.lex_state = 3, .external_lex_state = 3},
  [116] = {.lex_state = 3, .external_lex_state = 3},
  [117] = {.lex_state = 3, .external_lex_state = 3},
  [118] = {.lex_state = 3, .external_lex_state = 3},
  [119] = {.lex_state = 3, .external_lex_state = 3},
  [120] = {.lex_state = 3, .external_lex_state = 3},
  [121] = {.lex_state = 3, .external_lex_state = 3},
  [122] = {.lex_state = 3, .external_lex_state = 3},
  [123] = {.lex_state = 3, .external_lex_state = 3},
  [124] = {.lex_state = 3, .external_lex_state = 3},
  [125] = {.lex_state = 3, .external_lex_state = 3},
  [126] = {.lex_state = 3, .external_lex_state = 3},
  [127] = {.lex_state = 3, .external_lex_state = 3},
  [128] = {.lex_state = 3, .external_lex_state = 3},
  [129] = {.lex_state = 3, .external_lex_state = 3},
  [130] = {.lex_state = 3, .external_lex_state = 3},
  [131] = {.lex_state = 3, .external_lex_state = 3},
  [132] = {.lex_state = 3, .external_lex_state = 3},
  [133] = {.lex_state = 3, .external_lex_state = 3},
  [134] = {.lex_state = 3, .external_lex_state = 3},
  [135] = {.lex_state = 3, .external_lex_state = 3},
  [136] = {.lex_state = 3, .external_lex_state = 3},
  [137] = {.lex_state = 3, .external_lex_state = 3},
  [138] = {.lex_state = 3, .external_lex_state = 3},
  [139] = {.lex_state = 3, .external_lex_state = 3},
  [140] = {.lex_state = 3, .external_lex_state = 3},
  [141] = {.lex_state = 3, .external_lex_state = 3},
  [142] = {.lex_state = 3, .external_lex_state = 3},
  [143] = {.lex_state = 3, .external_lex_state = 3},
  [144] = {.lex_state = 3, .external_lex_state = 3},
  [145] = {.lex_state = 3, .external_lex_state = 3},
  [146] = {.lex_state = 3, .external_lex_state = 3},
  [147] = {.lex_state = 3, .external_lex_state = 3},
  [148] = {.lex_state = 3, .external_lex_state = 3},
  [149] = {.lex_state = 3, .external_lex_state = 3},
  [150] = {.lex_state = 3, .external_lex_state = 3},
  [151] = {.lex_state = 3, .external_lex_state = 3},
  [152] = {.lex_state = 3, .external_lex_state = 3},
  [153] = {.lex_state = 3, .external_lex_state = 3},
  [154] = {.lex_state = 3, .external_lex_state = 3},
  [155] = {.lex_state = 3, .external_lex_state = 3},
  [156] = {.lex_state = 3, .external_lex_state = 3},
  [157] = {.lex_state = 3, .external_lex_state = 3},
  [158] = {.lex_state = 3, .external_lex_state = 3},
  [159] = {.lex_state = 3, .external_lex_state = 3},
  [160] = {.lex_state = 3, .external_lex_state = 3},
  [161] = {.lex_state = 3, .external_lex_state = 3},
  [162] = {.lex_state = 3, .external_lex_state = 3},
  [163] = {.lex_state = 3, .external_lex_state = 3},
  [164] = {.lex_state = 3, .external_lex_state = 3},
  [165] = {.lex_state = 3, .external_lex_state = 3},
  [166] = {.lex_state = 3, .external_lex_state = 3},
  [167] = {.lex_state = 3, .external_lex_state = 3},
  [168] = {.lex_state = 3, .external_lex_state = 3},
  [169] = {.lex_state = 3, .external_lex_state = 3},
  [170] = {.lex_state = 3, .external_lex_state = 3},
  [171] = {.lex_state = 3, .external_lex_state = 3},
  [172] = {.lex_state = 3, .external_lex_state = 3},
  [173] = {.lex_state = 3, .external_lex_state = 3},
  [174] = {.lex_state = 3, .external_lex_state = 3},
  [175] = {.lex_state = 3, .external_lex_state = 3},
  [176] = {.lex_state = 3, .external_lex_state = 3},
  [177] = {.lex_state = 3, .external_lex_state = 3},
  [178] = {.lex_state = 3, .external_lex_state = 3},
  [179] = {.lex_state = 3, .external_lex_state = 3},
  [180] = {.lex_state = 3, .external_lex_state = 3},
  [181] = {.lex_state = 3, .external_lex_state = 3},
  [182] = {.lex_state = 3, .external_lex_state = 3},
  [183] = {.lex_state = 3, .external_lex_state = 3},
  [184] = {.lex_state = 3, .external_lex_state = 3},
  [185] = {.lex_state = 3, .external_lex_state = 3},
  [186] = {.lex_state = 3, .external_lex_state = 3},
  [187] = {.lex_state = 3, .external_lex_state = 3},
  [188] = {.lex_state = 3, .external_lex_state = 3},
  [189] = {.lex_state = 3, .external_lex_state = 3},
  [190] = {.lex_state = 3, .external_lex_state = 3},
  [191] = {.lex_state = 3, .external_lex_state = 3},
  [192] = {.lex_state = 3, .external_lex_state = 3},
  [193] = {.lex_state = 3, .external_lex_state = 3},
  [194] = {.lex_state = 3, .external_lex_state = 3},
  [195] = {.lex_state = 3, .external_lex_state = 3},
  [196] = {.lex_state = 3, .external_lex_state = 3},
  [197] = {.lex_state = 3, .external_lex_state = 3},
  [198] = {.lex_state = 3, .external_lex_state = 3},
  [199] = {.lex_state = 3, .external_lex_state = 3},
  [200] = {.lex_state = 3, .external_lex_state = 3},
  [201] = {.lex_state = 3, .external_lex_state = 3},
  [202] = {.lex_state = 3, .external_lex_state = 3},
  [203] = {.lex_state = 3, .external_lex_state = 3},
  [204] = {.lex_state = 3, .external_lex_state = 3},
  [205] = {.lex_state = 3, .external_lex_state = 3},
  [206] = {.lex_state = 3, .external_lex_state = 3},
  [207] = {.lex_state = 3, .external_lex_state = 3},
  [208] = {.lex_state = 3, .external_lex_state = 3},
  [209] = {.lex_state = 3, .external_lex_state = 3},
  [210] = {.lex_state = 3, .external_lex_state = 3},
  [211] = {.lex_state = 3, .external_lex_state = 3},
  [212] = {.lex_state = 3, .external_lex_state = 3},
  [213] = {.lex_state = 3, .external_lex_state = 3},
  [214] = {.lex_state = 3, .external_lex_state = 3},
  [215] = {.lex_state = 3, .external_lex_state = 3},
  [216] = {.lex_state = 3, .external_lex_state = 3},
  [217] = {.lex_state = 3, .external_lex_state = 3},
  [218] = {.lex_state = 3, .external_lex_state = 3},
  [219] = {.lex_state = 3, .external_lex_state = 3},
  [220] = {.lex_state = 3, .external_lex_state = 3},
  [221] = {.lex_state = 3, .external_lex_state = 3},
  [222] = {.lex_state = 3, .external_lex_state = 3},
  [223] = {.lex_state = 3, .external_lex_state = 3},
  [224] = {.lex_state = 3, .external_lex_state = 3},
  [225] = {.lex_state = 3, .external_lex_state = 3},
  [226] = {.lex_state = 3, .external_lex_state = 3},
  [227] = {.lex_state = 3, .external_lex_state = 3},
  [228] = {.lex_state = 3, .external_lex_state = 3},
  [229] = {.lex_state = 3, .external_lex_state = 3},
  [230] = {.lex_state = 3, .external_lex_state = 3},
  [231] = {.lex_state = 3, .external_lex_state = 3},
  [232] = {.lex_state = 3, .external_lex_state = 3},
  [233] = {.lex_state = 3, .external_lex_state = 3},
  [234] = {.lex_state = 3, .external_lex_state = 3},
  [235] = {.lex_state = 3, .external_lex_state = 3},
  [236] = {.lex_state = 3, .external_lex_state = 3},
  [237] = {.lex_state = 3, .external_lex_state = 3},
  [238] = {.lex_state = 3, .external_lex_state = 3},
  [239] = {.lex_state = 3, .external_lex_state = 3},
  [240] = {.lex_state = 3, .external_lex_state = 3},
  [241] = {.lex_state = 3, .external_lex_state = 3},
  [242] = {.lex_state = 3, .external_lex_state = 3},
  [243] = {.lex_state = 3, .external_lex_state = 3},
  [244] = {.lex_state = 3, .external_lex_state = 3},
  [245] = {.lex_state = 3, .external_lex_state = 3},
  [246] = {.lex_state = 3, .external_lex_state = 3},
  [247] = {.lex_state = 3, .external_lex_state = 3},
  [248] = {.lex_state = 3, .external_lex_state = 3},
  [249] = {.lex_state = 3, .external_lex_state = 3},
  [250] = {.lex_state = 3, .external_lex_state = 3},
  [251] = {.lex_state = 3, .external_lex_state = 3},
  [252] = {.lex_state = 3, .external_lex_state = 3},
  [253] = {.lex_state = 3, .external_lex_state = 3},
  [254] = {.lex_state = 3, .external_lex_state = 3},
  [255] = {.lex_state = 3, .external_lex_state = 3},
  [256] = {.lex_state = 3, .external_lex_state = 3},
  [257] = {.lex_state = 3, .external_lex_state = 3},
  [258] = {.lex_state = 3, .external_lex_state = 3},
  [259] = {.lex_state = 3, .external_lex_state = 3},
  [260] = {.lex_state = 3, .external_lex_state = 3},
  [261] = {.lex_state = 3, .external_lex_state = 3},
  [262] = {.lex_state = 3, .external_lex_state = 3},
  [263] = {.lex_state = 3, .external_lex_state = 3},
  [264] = {.lex_state = 3, .external_lex_state = 3},
  [265] = {.lex_state = 3, .external_lex_state = 3},
  [266] = {.lex_state = 3, .external_lex_state = 3},
  [267] = {.lex_state = 3, .external_lex_state = 3},
  [268] = {.lex_state = 3, .external_lex_state = 3},
  [269] = {.lex_state = 3, .external_lex_state = 3},
  [270] = {.lex_state = 3, .external_lex_state = 3},
  [271] = {.lex_state = 3, .external_lex_state = 3},
  [272] = {.lex_state = 3, .external_lex_state = 3},
  [273] = {.lex_state = 3, .external_lex_state = 3},
  [274] = {.lex_state = 3, .external_lex_state = 3},
  [275] = {.lex_state = 3, .external_lex_state = 3},
  [276] = {.lex_state = 3, .external_lex_state = 3},
  [277] = {.lex_state = 3, .external_lex_state = 3},
  [278] = {.lex_state = 3, .external_lex_state = 3},
  [279] = {.lex_state = 3, .external_lex_state = 3},
  [280] = {.lex_state = 3, .external_lex_state = 3},
  [281] = {.lex_state = 3, .external_lex_state = 3},
  [282] = {.lex_state = 3, .external_lex_state = 3},
  [283] = {.lex_state = 3, .external_lex_state = 3},
  [284] = {.lex_state = 3, .external_lex_state = 3},
  [285] = {.lex_state = 3, .external_lex_state = 3},
  [286] = {.lex_state = 3, .external_lex_state = 3},
  [287] = {.lex_state = 3, .external_lex_state = 3},
  [288] = {.lex_state = 3, .external_lex_state = 3},
  [289] = {.lex_state = 3, .external_lex_state = 3},
  [290] = {.lex_state = 3, .external_lex_state = 3},
  [291] = {.lex_state = 3, .external_lex_state = 3},
  [292] = {.lex_state = 3, .external_lex_state = 3},
  [293] = {.lex_state = 3, .external_lex_state = 3},
  [294] = {.lex_state = 3, .external_lex_state = 3},
  [295] = {.lex_state = 3, .external_lex_state = 3},
  [296] = {.lex_state = 3, .external_lex_state = 3},
  [297] = {.lex_state = 3, .external_lex_state = 3},
  [298] = {.lex_state = 3, .external_lex_state = 3},
  [299] = {.lex_state = 3, .external_lex_state = 3},
  [300] = {.lex_state = 3, .external_lex_state = 3},
  [301] = {.lex_state = 3, .external_lex_state = 3},
  [302] = {.lex_state = 3, .external_lex_state = 3},
  [303] = {.lex_state = 3, .external_lex_state = 3},
  [304] = {.lex_state = 3, .external_lex_state = 3},
  [305] = {.lex_state = 3, .external_lex_state = 3},
  [306] = {.lex_state = 3, .external_lex_state = 3},
  [307] = {.lex_state = 3, .external_lex_state = 3},
  [308] = {.lex_state = 3, .external_lex_state = 3},
  [309] = {.lex_state = 3, .external_lex_state = 3},
  [310] = {.lex_state = 3, .external_lex_state = 3},
  [311] = {.lex_state = 3, .external_lex_state = 3},
  [312] = {.lex_state = 3, .external_lex_state = 3},
  [313] = {.lex_state = 3, .external_lex_state = 3},
  [314] = {.lex_state = 3, .external_lex_state = 3},
  [315] = {.lex_state = 3, .external_lex_state = 3},
  [316] = {.lex_state = 3, .external_lex_state = 3},
  [317] = {.lex_state = 3, .external_lex_state = 3},
  [318] = {.lex_state = 3, .external_lex_state = 3},
  [319] = {.lex_state = 3, .external_lex_state = 3},
  [320] = {.lex_state = 3, .external_lex_state = 3},
  [321] = {.lex_state = 3, .external_lex_state = 3},
  [322] = {.lex_state = 3, .external_lex_state = 3},
  [323] = {.lex_state = 3, .external_lex_state = 3},
  [324] = {.lex_state = 3, .external_lex_state = 3},
  [325] = {.lex_state = 3, .external_lex_state = 3},
  [326] = {.lex_state = 3, .external_lex_state = 3},
  [327] = {.lex_state = 3, .external_lex_state = 3},
  [328] = {.lex_state = 3, .external_lex_state = 3},
  [329] = {.lex_state = 3, .external_lex_state = 3},
  [330] = {.lex_state = 3, .external_lex_state = 3},
  [331] = {.lex_state = 3, .external_lex_state = 3},
  [332] = {.lex_state = 3, .external_lex_state = 3},
  [333] = {.lex_state = 3, .external_lex_state = 3},
  [334] = {.lex_state = 3, .external_lex_state = 3},
  [335] = {.lex_state = 3, .external_lex_state = 3},
  [336] = {.lex_state = 3, .external_lex_state = 3},
  [337] = {.lex_state = 3, .external_lex_state = 3},
  [338] = {.lex_state = 3, .external_lex_state = 3},
  [339] = {.lex_state = 3, .external_lex_state = 3},
  [340] = {.lex_state = 3, .external_lex_state = 3},
  [341] = {.lex_state = 3, .external_lex_state = 3},
  [342] = {.lex_state = 3, .external_lex_state = 3},
  [343] = {.lex_state = 3, .external_lex_state = 3},
  [344] = {.lex_state = 3, .external_lex_state = 3},
  [345] = {.lex_state = 3, .external_lex_state = 3},
  [346] = {.lex_state = 3, .external_lex_state = 3},
  [347] = {.lex_state = 3, .external_lex_state = 3},
  [348] = {.lex_state = 3, .external_lex_state = 3},
  [349] = {.lex_state = 3, .external_lex_state = 3},
  [350] = {.lex_state = 3, .external_lex_state = 3},
  [351] = {.lex_state = 3, .external_lex_state = 3},
  [352] = {.lex_state = 3, .external_lex_state = 3},
  [353] = {.lex_state = 3, .external_lex_state = 3},
  [354] = {.lex_state = 3, .external_lex_state = 3},
  [355] = {.lex_state = 3, .external_lex_state = 3},
  [356] = {.lex_state = 3, .external_lex_state = 3},
  [357] = {.lex_state = 3, .external_lex_state = 3},
  [358] = {.lex_state = 3, .external_lex_state = 3},
  [359] = {.lex_state = 3, .external_lex_state = 3},
  [360] = {.lex_state = 3, .external_lex_state = 3},
  [361] = {.lex_state = 3, .external_lex_state = 3},
  [362] = {.lex_state = 3, .external_lex_state = 3},
  [363] = {.lex_state = 3, .external_lex_state = 3},
  [364] = {.lex_state = 3, .external_lex_state = 3},
  [365] = {.lex_state = 3, .external_lex_state = 3},
  [366] = {.lex_state = 3, .external_lex_state = 3},
  [367] = {.lex_state = 3, .external_lex_state = 3},
  [368] = {.lex_state = 3, .external_lex_state = 3},
  [369] = {.lex_state = 3, .external_lex_state = 3},
  [370] = {.lex_state = 3, .external_lex_state = 3},
  [371] = {.lex_state = 3, .external_lex_state = 3},
  [372] = {.lex_state = 3, .external_lex_state = 3},
  [373] = {.lex_state = 3, .external_lex_state = 3},
  [374] = {.lex_state = 3, .external_lex_state = 3},
  [375] = {.lex_state = 3, .external_lex_state = 3},
  [376] = {.lex_state = 3, .external_lex_state = 3},
  [377] = {.lex_state = 3, .external_lex_state = 3},
  [378] = {.lex_state = 3, .external_lex_state = 3},
  [379] = {.lex_state = 3, .external_lex_state = 3},
  [380] = {.lex_state = 3, .external_lex_state = 3},
  [381] = {.lex_state = 3, .external_lex_state = 3},
  [382] = {.lex_state = 3, .external_lex_state = 3},
  [383] = {.lex_state = 3, .external_lex_state = 3},
  [384] = {.lex_state = 3, .external_lex_state = 3},
  [385] = {.lex_state = 3, .external_lex_state = 3},
  [386] = {.lex_state = 3, .external_lex_state = 3},
  [387] = {.lex_state = 3, .external_lex_state = 3},
  [388] = {.lex_state = 3, .external_lex_state = 3},
  [389] = {.lex_state = 3, .external_lex_state = 3},
  [390] = {.lex_state = 3, .external_lex_state = 3},
  [391] = {.lex_state = 3, .external_lex_state = 3},
  [392] = {.lex_state = 3, .external_lex_state = 3},
  [393] = {.lex_state = 3, .external_lex_state = 3},
  [394] = {.lex_state = 3, .external_lex_state = 3},
  [395] = {.lex_state = 3, .external_lex_state = 3},
  [396] = {.lex_state = 3, .external_lex_state = 3},
  [397] = {.lex_state = 3, .external_lex_state = 3},
  [398] = {.lex_state = 3, .external_lex_state = 3},
  [399] = {.lex_state = 3, .external_lex_state = 3},
  [400] = {.lex_state = 3, .external_lex_state = 3},
  [401] = {.lex_state = 3, .external_lex_state = 3},
  [402] = {.lex_state = 3, .external_lex_state = 3},
  [403] = {.lex_state = 3, .external_lex_state = 3},
  [404] = {.lex_state = 3, .external_lex_state = 3},
  [405] = {.lex_state = 3, .external_lex_state = 3},
  [406] = {.lex_state = 3, .external_lex_state = 3},
  [407] = {.lex_state = 3, .external_lex_state = 3},
  [408] = {.lex_state = 3, .external_lex_state = 3},
  [409] = {.lex_state = 3, .external_lex_state = 3},
  [410] = {.lex_state = 3, .external_lex_state = 3},
  [411] = {.lex_state = 3, .external_lex_state = 3},
  [412] = {.lex_state = 3, .external_lex_state = 3},
  [413] = {.lex_state = 3, .external_lex_state = 3},
  [414] = {.lex_state = 3, .external_lex_state = 3},
  [415] = {.lex_state = 3, .external_lex_state = 3},
  [416] = {.lex_state = 3, .external_lex_state = 3},
  [417] = {.lex_state = 3, .external_lex_state = 3},
  [418] = {.lex_state = 3, .external_lex_state = 3},
  [419] = {.lex_state = 3, .external_lex_state = 3},
  [420] = {.lex_state = 3, .external_lex_state = 3},
  [421] = {.lex_state = 3, .external_lex_state = 3},
  [422] = {.lex_state = 3, .external_lex_state = 3},
  [423] = {.lex_state = 3, .external_lex_state = 3},
  [424] = {.lex_state = 3, .external_lex_state = 3},
  [425] = {.lex_state = 3, .external_lex_state = 3},
  [426] = {.lex_state = 3, .external_lex_state = 3},
  [427] = {.lex_state = 3, .external_lex_state = 3},
  [428] = {.lex_state = 3, .external_lex_state = 3},
  [429] = {.lex_state = 3, .external_lex_state = 3},
  [430] = {.lex_state = 3, .external_lex_state = 3},
  [431] = {.lex_state = 3, .external_lex_state = 3},
  [432] = {.lex_state = 3, .external_lex_state = 3},
  [433] = {.lex_state = 3, .external_lex_state = 3},
  [434] = {.lex_state = 3, .external_lex_state = 3},
  [435] = {.lex_state = 3, .external_lex_state = 3},
  [436] = {.lex_state = 3, .external_lex_state = 3},
  [437] = {.lex_state = 3, .external_lex_state = 3},
  [438] = {.lex_state = 3, .external_lex_state = 3},
  [439] = {.lex_state = 3, .external_lex_state = 3},
  [440] = {.lex_state = 3, .external_lex_state = 3},
  [441] = {.lex_state = 3, .external_lex_state = 3},
  [442] = {.lex_state = 3, .external_lex_state = 3},
  [443] = {.lex_state = 3, .external_lex_state = 3},
  [444] = {.lex_state = 3, .external_lex_state = 3},
  [445] = {.lex_state = 3, .external_lex_state = 3},
  [446] = {.lex_state = 3, .external_lex_state = 3},
  [447] = {.lex_state = 3, .external_lex_state = 3},
  [448] = {.lex_state = 3, .external_lex_state = 3},
  [449] = {.lex_state = 3, .external_lex_state = 3},
  [450] = {.lex_state = 3, .external_lex_state = 3},
  [451] = {.lex_state = 3, .external_lex_state = 3},
  [452] = {.lex_state = 3, .external_lex_state = 3},
  [453] = {.lex_state = 3, .external_lex_state = 3},
  [454] = {.lex_state = 3, .external_lex_state = 3},
  [455] = {.lex_state = 3, .external_lex_state = 3},
  [456] = {.lex_state = 3, .external_lex_state = 3},
  [457] = {.lex_state = 3, .external_lex_state = 3},
  [458] = {.lex_state = 3, .external_lex_state = 3},
  [459] = {.lex_state = 3, .external_lex_state = 3},
  [460] = {.lex_state = 3, .external_lex_state = 3},
  [461] = {.lex_state = 3, .external_lex_state = 3},
  [462] = {.lex_state = 3, .external_lex_state = 3},
  [463] = {.lex_state = 3, .external_lex_state = 3},
  [464] = {.lex_state = 3, .external_lex_state = 3},
  [465] = {.lex_state = 3, .external_lex_state = 3},
  [466] = {.lex_state = 3, .external_lex_state = 3},
  [467] = {.lex_state = 3, .external_lex_state = 3},
  [468] = {.lex_state = 3, .external_lex_state = 3},
  [469] = {.lex_state = 3, .external_lex_state = 3},
  [470] = {.lex_state = 3, .external_lex_state = 3},
  [471] = {.lex_state = 3, .external_lex_state = 3},
  [472] = {.lex_state = 3, .external_lex_state = 3},
  [473] = {.lex_state = 3, .external_lex_state = 3},
  [474] = {.lex_state = 3, .external_lex_state = 3},
  [475] = {.lex_state = 3, .external_lex_state = 3},
  [476] = {.lex_state = 3, .external_lex_state = 3},
  [477] = {.lex_state = 3, .external_lex_state = 3},
  [478] = {.lex_state = 3, .external_lex_state = 3},
  [479] = {.lex_state = 3, .external_lex_state = 3},
  [480] = {.lex_state = 3, .external_lex_state = 3},
  [481] = {.lex_state = 3, .external_lex_state = 3},
  [482] = {.lex_state = 3, .external_lex_state = 3},
  [483] = {.lex_state = 3, .external_lex_state = 3},
  [484] = {.lex_state = 3, .external_lex_state = 3},
  [485] = {.lex_state = 3, .external_lex_state = 3},
  [486] = {.lex_state = 3, .external_lex_state = 3},
  [487] = {.lex_state = 3, .external_lex_state = 3},
  [488] = {.lex_state = 3, .external_lex_state = 3},
  [489] = {.lex_state = 3, .external_lex_state = 3},
  [490] = {.lex_state = 3, .external_lex_state = 3},
  [491] = {.lex_state = 3, .external_lex_state = 3},
  [492] = {.lex_state = 3, .external_lex_state = 3},
  [493] = {.lex_state = 3, .external_lex_state = 3},
  [494] = {.lex_state = 3, .external_lex_state = 3},
  [495] = {.lex_state = 3, .external_lex_state = 3},
  [496] = {.lex_state = 3, .external_lex_state = 3},
  [497] = {.lex_state = 3, .external_lex_state = 3},
  [498] = {.lex_state = 3, .external_lex_state = 3},
  [499] = {.lex_state = 3, .external_lex_state = 3},
  [500] = {.lex_state = 3, .external_lex_state = 3},
  [501] = {.lex_state = 3, .external_lex_state = 3},
  [502] = {.lex_state = 3, .external_lex_state = 3},
  [503] = {.lex_state = 3, .external_lex_state = 3},
  [504] = {.lex_state = 3, .external_lex_state = 3},
  [505] = {.lex_state = 3, .external_lex_state = 3},
  [506] = {.lex_state = 3, .external_lex_state = 3},
  [507] = {.lex_state = 3, .external_lex_state = 3},
  [508] = {.lex_state = 3, .external_lex_state = 3},
  [509] = {.lex_state = 3, .external_lex_state = 3},
  [510] = {.lex_state = 3, .external_lex_state = 3},
  [511] = {.lex_state = 3, .external_lex_state = 3},
  [512] = {.lex_state = 3, .external_lex_state = 3},
  [513] = {.lex_state = 3, .external_lex_state = 3},
  [514] = {.lex_state = 3, .external_lex_state = 3},
  [515] = {.lex_state = 3, .external_lex_state = 3},
  [516] = {.lex_state = 3, .external_lex_state = 3},
  [517] = {.lex_state = 3, .external_lex_state = 3},
  [518] = {.lex_state = 3, .external_lex_state = 3},
  [519] = {.lex_state = 3, .external_lex_state = 3},
  [520] = {.lex_state = 3, .external_lex_state = 3},
  [521] = {.lex_state = 3, .external_lex_state = 3},
  [522] = {.lex_state = 3, .external_lex_state = 3},
  [523] = {.lex_state = 3, .external_lex_state = 3},
  [524] = {.lex_state = 3, .external_lex_state = 3},
  [525] = {.lex_state = 3, .external_lex_state = 3},
  [526] = {.lex_state = 3, .external_lex_state = 3},
  [527] = {.lex_state = 3, .external_lex_state = 3},
  [528] = {.lex_state = 3, .external_lex_state = 3},
  [529] = {.lex_state = 3, .external_lex_state = 3},
  [530] = {.lex_state = 3, .external_lex_state = 3},
  [531] = {.lex_state = 3, .external_lex_state = 3},
  [532] = {.lex_state = 3, .external_lex_state = 3},
  [533] = {.lex_state = 3, .external_lex_state = 3},
  [534] = {.lex_state = 5, .external_lex_state = 3},
  [535] = {.lex_state = 5, .external_lex_state = 3},
  [536] = {.lex_state = 5, .external_lex_state = 3},
  [537] = {.lex_state = 5, .external_lex_state = 3},
  [538] = {.lex_state = 5, .external_lex_state = 3},
  [539] = {.lex_state = 5, .external_lex_state = 3},
  [540] = {.lex_state = 5, .external_lex_state = 3},
  [541] = {.lex_state = 5, .external_lex_state = 3},
  [542] = {.lex_state = 5, .external_lex_state = 3},
  [543] = {.lex_state = 5, .external_lex_state = 3},
  [544] = {.lex_state = 5, .external_lex_state = 3},
  [545] = {.lex_state = 5, .external_lex_state = 3},
  [546] = {.lex_state = 5, .external_lex_state = 3},
  [547] = {.lex_state = 5, .external_lex_state = 3},
  [548] = {.lex_state = 5, .external_lex_state = 3},
  [549] = {.lex_state = 5, .external_lex_state = 3},
  [550] = {.lex_state = 5, .external_lex_state = 3},
  [551] = {.lex_state = 5, .external_lex_state = 3},
  [552] = {.lex_state = 5, .external_lex_state = 3},
  [553] = {.lex_state = 5, .external_lex_state = 3},
  [554] = {.lex_state = 5, .external_lex_state = 3},
  [555] = {.lex_state = 5, .external_lex_state = 3},
  [556] = {.lex_state = 5, .external_lex_state = 3},
  [557] = {.lex_state = 5, .external_lex_state = 3},
  [558] = {.lex_state = 5, .external_lex_state = 3},
  [559] = {.lex_state = 5, .external_lex_state = 3},
  [560] = {.lex_state = 5, .external_lex_state = 3},
  [561] = {.lex_state = 5, .external_lex_state = 3},
  [562] = {.lex_state = 5, .external_lex_state = 3},
  [563] = {.lex_state = 5, .external_lex_state = 3},
  [564] = {.lex_state = 5, .external_lex_state = 3},
  [565] = {.lex_state = 5, .external_lex_state = 3},
  [566] = {.lex_state = 5, .external_lex_state = 3},
  [567] = {.lex_state = 5, .external_lex_state = 3},
  [568] = {.lex_state = 5, .external_lex_state = 3},
  [569] = {.lex_state = 5, .external_lex_state = 3},
  [570] = {.lex_state = 5, .external_lex_state = 3},
  [571] = {.lex_state = 5, .external_lex_state = 3},
  [572] = {.lex_state = 5, .external_lex_state = 3},
  [573] = {.lex_state = 5, .external_lex_state = 3},
  [574] = {.lex_state = 5, .external_lex_state = 3},
  [575] = {.lex_state = 5, .external_lex_state = 3},
  [576] = {.lex_state = 20, .external_lex_state = 3},
  [577] = {.lex_state = 20, .external_lex_state = 3},
  [578] = {.lex_state = 20, .external_lex_state = 3},
  [579] = {.lex_state = 20, .external_lex_state = 3},
  [580] = {.lex_state = 21, .external_lex_state = 3},
  [581] = {.lex_state = 21, .external_lex_state = 3},
  [582] = {.lex_state = 20, .external_lex_state = 3},
  [583] = {.lex_state = 21, .external_lex_state = 3},
  [584] = {.lex_state = 21, .external_lex_state = 3},
  [585] = {.lex_state = 21, .external_lex_state = 3},
  [586] = {.lex_state = 21, .external_lex_state = 3},
  [587] = {.lex_state = 21, .external_lex_state = 3},
  [588] = {.lex_state = 21, .external_lex_state = 3},
  [589] = {.lex_state = 5, .external_lex_state = 3},
  [590] = {.lex_state = 21, .external_lex_state = 3},
  [591] = {.lex_state = 22, .external_lex_state = 3},
  [592] = {.lex_state = 22, .external_lex_state = 3},
  [593] = {.lex_state = 34, .external_lex_state = 4},
  [594] = {.lex_state = 21, .external_lex_state = 3},
  [595] = {.lex_state = 23, .external_lex_state = 3},
  [596] = {.lex_state = 23, .external_lex_state = 3},
  [597] = {.lex_state = 34, .external_lex_state = 4},
  [598] = {.lex_state = 21, .external_lex_state = 3},
  [599] = {.lex_state = 21, .external_lex_state = 3},
  [600] = {.lex_state = 34, .external_lex_state = 4},
  [601] = {.lex_state = 21, .external_lex_state = 3},
  [602] = {.lex_state = 21, .external_lex_state = 3},
  [603] = {.lex_state = 21, .external_lex_state = 3},
  [604] = {.lex_state = 21, .external_lex_state = 3},
  [605] = {.lex_state = 21, .external_lex_state = 3},
  [606] = {.lex_state = 21, .external_lex_state = 3},
  [607] = {.lex_state = 21, .external_lex_state = 3},
  [608] = {.lex_state = 21, .external_lex_state = 3},
  [609] = {.lex_state = 6, .external_lex_state = 3},
  [610] = {.lex_state = 21, .external_lex_state = 3},
  [611] = {.lex_state = 6, .external_lex_state = 3},
  [612] = {.lex_state = 21, .external_lex_state = 3},
  [613] = {.lex_state = 21, .external_lex_state = 3},
  [614] = {.lex_state = 21, .external_lex_state = 3},
  [615] = {.lex_state = 21, .external_lex_state = 3},
  [616] = {.lex_state = 21, .external_lex_state = 3},
  [617] = {.lex_state = 21, .external_lex_state = 3},
  [618] = {.lex_state = 21, .external_lex_state = 3},
  [619] = {.lex_state = 5, .external_lex_state = 3},
  [620] = {.lex_state = 21, .external_lex_state = 3},
  [621] = {.lex_state = 21, .external_lex_state = 3},
  [622] = {.lex_state = 5, .external_lex_state = 3},
  [623] = {.lex_state = 21, .external_lex_state = 3},
  [624] = {.lex_state = 21, .external_lex_state = 3},
  [625] = {.lex_state = 21, .external_lex_state = 3},
  [626] = {.lex_state = 21, .external_lex_state = 3},
  [627] = {.lex_state = 21, .external_lex_state = 3},
  [628] = {.lex_state = 21, .external_lex_state = 3},
  [629] = {.lex_state = 21, .external_lex_state = 3},
  [630] = {.lex_state = 5, .external_lex_state = 3},
  [631] = {.lex_state = 21, .external_lex_state = 3},
  [632] = {.lex_state = 21, .external_lex_state = 3},
  [633] = {.lex_state = 21, .external_lex_state = 3},
  [634] = {.lex_state = 21, .external_lex_state = 3},
  [635] = {.lex_state = 21, .external_lex_state = 3},
  [636] = {.lex_state = 21, .external_lex_state = 3},
  [637] = {.lex_state = 21, .external_lex_state = 3},
  [638] = {.lex_state = 21, .external_lex_state = 3},
  [639] = {.lex_state = 6, .external_lex_state = 3},
  [640] = {.lex_state = 5, .external_lex_state = 3},
  [641] = {.lex_state = 34, .external_lex_state = 4},
  [642] = {.lex_state = 5, .external_lex_state = 3},
  [643] = {.lex_state = 5, .external_lex_state = 3},
  [644] = {.lex_state = 5, .external_lex_state = 3},
  [645] = {.lex_state = 34, .external_lex_state = 4},
  [646] = {.lex_state = 5, .external_lex_state = 3},
  [647] = {.lex_state = 5, .external_lex_state = 3},
  [648] = {.lex_state = 6, .external_lex_state = 3},
  [649] = {.lex_state = 5, .external_lex_state = 3},
  [650] = {.lex_state = 6, .external_lex_state = 3},
  [651] = {.lex_state = 6, .external_lex_state = 3},
  [652] = {.lex_state = 5, .external_lex_state = 3},
  [653] = {.lex_state = 34, .external_lex_state = 4},
  [654] = {.lex_state = 5, .external_lex_state = 3},
  [655] = {.lex_state = 6, .external_lex_state = 3},
  [656] = {.lex_state = 5, .external_lex_state = 3},
  [657] = {.lex_state = 5, .external_lex_state = 3},
  [658] = {.lex_state = 5, .external_lex_state = 3},
  [659] = {.lex_state = 5, .external_lex_state = 3},
  [660] = {.lex_state = 5, .external_lex_state = 3},
  [661] = {.lex_state = 5, .external_lex_state = 3},
  [662] = {.lex_state = 5, .external_lex_state = 3},
  [663] = {.lex_state = 5, .external_lex_state = 3},
  [664] = {.lex_state = 5, .external_lex_state = 3},
  [665] = {.lex_state = 5, .external_lex_state = 3},
  [666] = {.lex_state = 5, .external_lex_state = 3},
  [667] = {.lex_state = 5, .external_lex_state = 3},
  [668] = {.lex_state = 5, .external_lex_state = 3},
  [669] = {.lex_state = 5, .external_lex_state = 3},
  [670] = {.lex_state = 5, .external_lex_state = 3},
  [671] = {.lex_state = 5, .external_lex_state = 3},
  [672] = {.lex_state = 5, .external_lex_state = 3},
  [673] = {.lex_state = 5, .external_lex_state = 3},
  [674] = {.lex_state = 5, .external_lex_state = 3},
  [675] = {.lex_state = 5, .external_lex_state = 3},
  [676] = {.lex_state = 5, .external_lex_state = 3},
  [677] = {.lex_state = 5, .external_lex_state = 3},
  [678] = {.lex_state = 5, .external_lex_state = 3},
  [679] = {.lex_state = 5, .external_lex_state = 3},
  [680] = {.lex_state = 5, .external_lex_state = 3},
  [681] = {.lex_state = 5, .external_lex_state = 3},
  [682] = {.lex_state = 5, .external_lex_state = 3},
  [683] = {.lex_state = 5, .external_lex_state = 3},
  [684] = {.lex_state = 5, .external_lex_state = 3},
  [685] = {.lex_state = 5, .external_lex_state = 3},
  [686] = {.lex_state = 5, .external_lex_state = 3},
  [687] = {.lex_state = 5, .external_lex_state = 3},
  [688] = {.lex_state = 5, .external_lex_state = 3},
  [689] = {.lex_state = 5, .external_lex_state = 3},
  [690] = {.lex_state = 34, .external_lex_state = 4},
  [691] = {.lex_state = 5, .external_lex_state = 3},
  [692] = {.lex_state = 5, .external_lex_state = 3},
  [693] = {.lex_state = 5, .external_lex_state = 3},
  [694] = {.lex_state = 5, .external_lex_state = 3},
  [695] = {.lex_state = 5, .external_lex_state = 3},
  [696] = {.lex_state = 5, .external_lex_state = 3},
  [697] = {.lex_state = 5, .external_lex_state = 3},
  [698] = {.lex_state = 5, .external_lex_state = 3},
  [699] = {.lex_state = 5, .external_lex_state = 3},
  [700] = {.lex_state = 5, .external_lex_state = 3},
  [701] = {.lex_state = 5, .external_lex_state = 3},
  [702] = {.lex_state = 5, .external_lex_state = 3},
  [703] = {.lex_state = 5, .external_lex_state = 3},
  [704] = {.lex_state = 5, .external_lex_state = 3},
  [705] = {.lex_state = 5, .external_lex_state = 3},
  [706] = {.lex_state = 5, .external_lex_state = 3},
  [707] = {.lex_state = 5, .external_lex_state = 3},
  [708] = {.lex_state = 5, .external_lex_state = 3},
  [709] = {.lex_state = 5, .external_lex_state = 3},
  [710] = {.lex_state = 5, .external_lex_state = 3},
  [711] = {.lex_state = 5, .external_lex_state = 3},
  [712] = {.lex_state = 5, .external_lex_state = 3},
  [713] = {.lex_state = 5, .external_lex_state = 3},
  [714] = {.lex_state = 5, .external_lex_state = 3},
  [715] = {.lex_state = 5, .external_lex_state = 3},
  [716] = {.lex_state = 5, .external_lex_state = 3},
  [717] = {.lex_state = 5, .external_lex_state = 3},
  [718] = {.lex_state = 5, .external_lex_state = 3},
  [719] = {.lex_state = 5, .external_lex_state = 3},
  [720] = {.lex_state = 5, .external_lex_state = 3},
  [721] = {.lex_state = 5, .external_lex_state = 3},
  [722] = {.lex_state = 5, .external_lex_state = 3},
  [723] = {.lex_state = 5, .external_lex_state = 3},
  [724] = {.lex_state = 5, .external_lex_state = 3},
  [725] = {.lex_state = 5, .external_lex_state = 3},
  [726] = {.lex_state = 5, .external_lex_state = 3},
  [727] = {.lex_state = 5, .external_lex_state = 3},
  [728] = {.lex_state = 5, .external_lex_state = 3},
  [729] = {.lex_state = 5, .external_lex_state = 3},
  [730] = {.lex_state = 5, .external_lex_state = 3},
  [731] = {.lex_state = 5, .external_lex_state = 3},
  [732] = {.lex_state = 5, .external_lex_state = 3},
  [733] = {.lex_state = 5, .external_lex_state = 3},
  [734] = {.lex_state = 5, .external_lex_state = 3},
  [735] = {.lex_state = 5, .external_lex_state = 3},
  [736] = {.lex_state = 5, .external_lex_state = 3},
  [737] = {.lex_state = 5, .external_lex_state = 3},
  [738] = {.lex_state = 5, .external_lex_state = 3},
  [739] = {.lex_state = 5, .external_lex_state = 3},
  [740] = {.lex_state = 5, .external_lex_state = 3},
  [741] = {.lex_state = 5, .external_lex_state = 3},
  [742] = {.lex_state = 5, .external_lex_state = 3},
  [743] = {.lex_state = 5, .external_lex_state = 3},
  [744] = {.lex_state = 5, .external_lex_state = 3},
  [745] = {.lex_state = 5, .external_lex_state = 3},
  [746] = {.lex_state = 5, .external_lex_state = 3},
  [747] = {.lex_state = 5, .external_lex_state = 3},
  [748] = {.lex_state = 5, .external_lex_state = 3},
  [749] = {.lex_state = 5, .external_lex_state = 3},
  [750] = {.lex_state = 5, .external_lex_state = 3},
  [751] = {.lex_state = 5, .external_lex_state = 3},
  [752] = {.lex_state = 5, .external_lex_state = 3},
  [753] = {.lex_state = 5, .external_lex_state = 3},
  [754] = {.lex_state = 5, .external_lex_state = 3},
  [755] = {.lex_state = 34, .external_lex_state = 4},
  [756] = {.lex_state = 5, .external_lex_state = 3},
  [757] = {.lex_state = 8, .external_lex_state = 5},
  [758] = {.lex_state = 222, .external_lex_state = 2},
  [759] = {.lex_state = 34, .external_lex_state = 4},
  [760] = {.lex_state = 34, .external_lex_state = 4},
  [761] = {.lex_state = 34, .external_lex_state = 4},
  [762] = {.lex_state = 34, .external_lex_state = 4},
  [763] = {.lex_state = 43, .external_lex_state = 4},
  [764] = {.lex_state = 15, .external_lex_state = 5},
  [765] = {.lex_state = 9, .external_lex_state = 4},
  [766] = {.lex_state = 34, .external_lex_state = 4},
  [767] = {.lex_state = 5, .external_lex_state = 3},
  [768] = {.lex_state = 34, .external_lex_state = 4},
  [769] = {.lex_state = 34, .external_lex_state = 4},
  [770] = {.lex_state = 43, .external_lex_state = 4},
  [771] = {.lex_state = 5, .external_lex_state = 3},
  [772] = {.lex_state = 34, .external_lex_state = 4},
  [773] = {.lex_state = 43, .external_lex_state = 4},
  [774] = {.lex_state = 43, .external_lex_state = 4},
  [775] = {.lex_state = 43, .external_lex_state = 4},
  [776] = {.lex_state = 222, .external_lex_state = 2},
  [777] = {.lex_state = 34, .external_lex_state = 4},
  [778] = {.lex_state = 34, .external_lex_state = 4},
  [779] = {.lex_state = 43, .external_lex_state = 4},
  [780] = {.lex_state = 43, .external_lex_state = 4},
  [781] = {.lex_state = 9, .external_lex_state = 4},
  [782] = {.lex_state = 9, .external_lex_state = 4},
  [783] = {.lex_state = 222, .external_lex_state = 2},
  [784] = {.lex_state = 34, .external_lex_state = 4},
  [785] = {.lex_state = 5, .external_lex_state = 3},
  [786] = {.lex_state = 43, .external_lex_state = 4},
  [787] = {.lex_state = 5, .external_lex_state = 3},
  [788] = {.lex_state = 43, .external_lex_state = 4},
  [789] = {.lex_state = 5, .external_lex_state = 3},
  [790] = {.lex_state = 34, .external_lex_state = 4},
  [791] = {.lex_state = 34, .external_lex_state = 4},
  [792] = {.lex_state = 5, .external_lex_state = 3},
  [793] = {.lex_state = 43, .external_lex_state = 4},
  [794] = {.lex_state = 43, .external_lex_state = 4},
  [795] = {.lex_state = 34, .external_lex_state = 4},
  [796] = {.lex_state = 5, .external_lex_state = 3},
  [797] = {.lex_state = 43, .external_lex_state = 4},
  [798] = {.lex_state = 5, .external_lex_state = 3},
  [799] = {.lex_state = 34, .external_lex_state = 4},
  [800] = {.lex_state = 34, .external_lex_state = 4},
  [801] = {.lex_state = 34, .external_lex_state = 4},
  [802] = {.lex_state = 34, .external_lex_state = 4},
  [803] = {.lex_state = 34, .external_lex_state = 4},
  [804] = {.lex_state = 34, .external_lex_state = 4},
  [805] = {.lex_state = 34, .external_lex_state = 4},
  [806] = {.lex_state = 34, .external_lex_state = 4},
  [807] = {.lex_state = 34, .external_lex_state = 4},
  [808] = {.lex_state = 34, .external_lex_state = 4},
  [809] = {.lex_state = 34, .external_lex_state = 4},
  [810] = {.lex_state = 34, .external_lex_state = 4},
  [811] = {.lex_state = 34, .external_lex_state = 4},
  [812] = {.lex_state = 34, .external_lex_state = 4},
  [813] = {.lex_state = 34, .external_lex_state = 4},
  [814] = {.lex_state = 34, .external_lex_state = 4},
  [815] = {.lex_state = 34, .external_lex_state = 4},
  [816] = {.lex_state = 34, .external_lex_state = 4},
  [817] = {.lex_state = 34, .external_lex_state = 4},
  [818] = {.lex_state = 34, .external_lex_state = 4},
  [819] = {.lex_state = 34, .external_lex_state = 4},
  [820] = {.lex_state = 34, .external_lex_state = 4},
  [821] = {.lex_state = 34, .external_lex_state = 4},
  [822] = {.lex_state = 34, .external_lex_state = 4},
  [823] = {.lex_state = 34, .external_lex_state = 4},
  [824] = {.lex_state = 34, .external_lex_state = 4},
  [825] = {.lex_state = 34, .external_lex_state = 4},
  [826] = {.lex_state = 9, .external_lex_state = 4},
  [827] = {.lex_state = 34, .external_lex_state = 4},
  [828] = {.lex_state = 222, .external_lex_state = 2},
  [829] = {.lex_state = 34, .external_lex_state = 4},
  [830] = {.lex_state = 34, .external_lex_state = 4},
  [831] = {.lex_state = 34, .external_lex_state = 4},
  [832] = {.lex_state = 34, .external_lex_state = 4},
  [833] = {.lex_state = 34, .external_lex_state = 4},
  [834] = {.lex_state = 34, .external_lex_state = 4},
  [835] = {.lex_state = 34, .external_lex_state = 4},
  [836] = {.lex_state = 8, .external_lex_state = 4},
  [837] = {.lex_state = 34, .external_lex_state = 4},
  [838] = {.lex_state = 34, .external_lex_state = 4},
  [839] = {.lex_state = 34, .external_lex_state = 4},
  [840] = {.lex_state = 34, .external_lex_state = 4},
  [841] = {.lex_state = 34, .external_lex_state = 4},
  [842] = {.lex_state = 9, .external_lex_state = 4},
  [843] = {.lex_state = 34, .external_lex_state = 4},
  [844] = {.lex_state = 34, .external_lex_state = 4},
  [845] = {.lex_state = 34, .external_lex_state = 4},
  [846] = {.lex_state = 34, .external_lex_state = 4},
  [847] = {.lex_state = 34, .external_lex_state = 4},
  [848] = {.lex_state = 34, .external_lex_state = 4},
  [849] = {.lex_state = 34, .external_lex_state = 4},
  [850] = {.lex_state = 34, .external_lex_state = 4},
  [851] = {.lex_state = 34, .external_lex_state = 4},
  [852] = {.lex_state = 34, .external_lex_state = 4},
  [853] = {.lex_state = 34, .external_lex_state = 4},
  [854] = {.lex_state = 34, .external_lex_state = 4},
  [855] = {.lex_state = 34, .external_lex_state = 4},
  [856] = {.lex_state = 34, .external_lex_state = 4},
  [857] = {.lex_state = 34, .external_lex_state = 4},
  [858] = {.lex_state = 34, .external_lex_state = 4},
  [859] = {.lex_state = 222, .external_lex_state = 2},
  [860] = {.lex_state = 34, .external_lex_state = 4},
  [861] = {.lex_state = 34, .external_lex_state = 4},
  [862] = {.lex_state = 9, .external_lex_state = 4},
  [863] = {.lex_state = 34, .external_lex_state = 4},
  [864] = {.lex_state = 34, .external_lex_state = 4},
  [865] = {.lex_state = 34, .external_lex_state = 4},
  [866] = {.lex_state = 34, .external_lex_state = 4},
  [867] = {.lex_state = 34, .external_lex_state = 4},
  [868] = {.lex_state = 34, .external_lex_state = 4},
  [869] = {.lex_state = 222, .external_lex_state = 2},
  [870] = {.lex_state = 222, .external_lex_state = 2},
  [871] = {.lex_state = 10, .external_lex_state = 4},
  [872] = {.lex_state = 222, .external_lex_state = 2},
  [873] = {.lex_state = 10, .external_lex_state = 4},
  [874] = {.lex_state = 9, .external_lex_state = 4},
  [875] = {.lex_state = 9, .external_lex_state = 4},
  [876] = {.lex_state = 9, .external_lex_state = 4},
  [877] = {.lex_state = 9, .external_lex_state = 4},
  [878] = {.lex_state = 12, .external_lex_state = 4},
  [879] = {.lex_state = 16, .external_lex_state = 5},
  [880] = {.lex_state = 9, .external_lex_state = 4},
  [881] = {.lex_state = 9, .external_lex_state = 4},
  [882] = {.lex_state = 8, .external_lex_state = 4},
  [883] = {.lex_state = 9, .external_lex_state = 4},
  [884] = {.lex_state = 34, .external_lex_state = 4},
  [885] = {.lex_state = 34, .external_lex_state = 4},
  [886] = {.lex_state = 9, .external_lex_state = 4},
  [887] = {.lex_state = 34, .external_lex_state = 4},
  [888] = {.lex_state = 34, .external_lex_state = 4},
  [889] = {.lex_state = 34, .external_lex_state = 4},
  [890] = {.lex_state = 16, .external_lex_state = 5},
  [891] = {.lex_state = 16, .external_lex_state = 5},
  [892] = {.lex_state = 9, .external_lex_state = 4},
  [893] = {.lex_state = 222, .external_lex_state = 3},
  [894] = {.lex_state = 16, .external_lex_state = 5},
  [895] = {.lex_state = 8, .external_lex_state = 4},
  [896] = {.lex_state = 19, .external_lex_state = 4},
  [897] = {.lex_state = 9, .external_lex_state = 5},
  [898] = {.lex_state = 7, .external_lex_state = 4},
  [899] = {.lex_state = 7, .external_lex_state = 4},
  [900] = {.lex_state = 7, .external_lex_state = 4},
  [901] = {.lex_state = 18, .external_lex_state = 4},
  [902] = {.lex_state = 7, .external_lex_state = 4},
  [903] = {.lex_state = 7, .external_lex_state = 4},
  [904] = {.lex_state = 9, .external_lex_state = 4},
  [905] = {.lex_state = 9, .external_lex_state = 4},
  [906] = {.lex_state = 9, .external_lex_state = 5},
  [907] = {.lex_state = 9, .external_lex_state = 4},
  [908] = {.lex_state = 9, .external_lex_state = 4},
  [909] = {.lex_state = 9, .external_lex_state = 4},
  [910] = {.lex_state = 9, .external_lex_state = 4},
  [911] = {.lex_state = 9, .external_lex_state = 4},
  [912] = {.lex_state = 7, .external_lex_state = 4},
  [913] = {.lex_state = 8, .external_lex_state = 4},
  [914] = {.lex_state = 9, .external_lex_state = 4},
  [915] = {.lex_state = 9, .external_lex_state = 4},
  [916] = {.lex_state = 9, .external_lex_state = 5},
  [917] = {.lex_state = 9, .external_lex_state = 4},
  [918] = {.lex_state = 9, .external_lex_state = 5},
  [919] = {.lex_state = 9, .external_lex_state = 4},
  [920] = {.lex_state = 9, .external_lex_state = 5},
  [921] = {.lex_state = 9, .external_lex_state = 4},
  [922] = {.lex_state = 9, .external_lex_state = 4},
  [923] = {.lex_state = 9, .external_lex_state = 4},
  [924] = {.lex_state = 9, .external_lex_state = 4},
  [925] = {.lex_state = 8, .external_lex_state = 4},
  [926] = {.lex_state = 9, .external_lex_state = 4},
  [927] = {.lex_state = 34, .external_lex_state = 4},
  [928] = {.lex_state = 9, .external_lex_state = 4},
  [929] = {.lex_state = 34, .external_lex_state = 4},
  [930] = {.lex_state = 34, .external_lex_state = 4},
  [931] = {.lex_state = 34, .external_lex_state = 4},
  [932] = {.lex_state = 9, .external_lex_state = 4},
  [933] = {.lex_state = 34, .external_lex_state = 4},
  [934] = {.lex_state = 34, .external_lex_state = 4},
  [935] = {.lex_state = 34, .external_lex_state = 4},
  [936] = {.lex_state = 9, .external_lex_state = 4},
  [937] = {.lex_state = 9, .external_lex_state = 4},
  [938] = {.lex_state = 34, .external_lex_state = 4},
  [939] = {.lex_state = 9, .external_lex_state = 4},
  [940] = {.lex_state = 34, .external_lex_state = 4},
  [941] = {.lex_state = 9, .external_lex_state = 4},
  [942] = {.lex_state = 9, .external_lex_state = 4},
  [943] = {.lex_state = 9, .external_lex_state = 4},
  [944] = {.lex_state = 34, .external_lex_state = 4},
  [945] = {.lex_state = 34, .external_lex_state = 4},
  [946] = {.lex_state = 9, .external_lex_state = 4},
  [947] = {.lex_state = 9, .external_lex_state = 4},
  [948] = {.lex_state = 9, .external_lex_state = 4},
  [949] = {.lex_state = 9, .external_lex_state = 4},
  [950] = {.lex_state = 9, .external_lex_state = 4},
  [951] = {.lex_state = 9, .external_lex_state = 4},
  [952] = {.lex_state = 9, .external_lex_state = 4},
  [953] = {.lex_state = 9, .external_lex_state = 4},
  [954] = {.lex_state = 9, .external_lex_state = 4},
  [955] = {.lex_state = 9, .external_lex_state = 4},
  [956] = {.lex_state = 34, .external_lex_state = 4},
  [957] = {.lex_state = 9, .external_lex_state = 5},
  [958] = {.lex_state = 9, .external_lex_state = 4},
  [959] = {.lex_state = 34, .external_lex_state = 4},
  [960] = {.lex_state = 9, .external_lex_state = 4},
  [961] = {.lex_state = 9, .external_lex_state = 4},
  [962] = {.lex_state = 9, .external_lex_state = 4},
  [963] = {.lex_state = 34, .external_lex_state = 4},
  [964] = {.lex_state = 34, .external_lex_state = 4},
  [965] = {.lex_state = 9, .external_lex_state = 4},
  [966] = {.lex_state = 9, .external_lex_state = 4},
  [967] = {.lex_state = 9, .external_lex_state = 4},
  [968] = {.lex_state = 9, .external_lex_state = 4},
  [969] = {.lex_state = 9, .external_lex_state = 4},
  [970] = {.lex_state = 9, .external_lex_state = 4},
  [971] = {.lex_state = 9, .external_lex_state = 4},
  [972] = {.lex_state = 34, .external_lex_state = 4},
  [973] = {.lex_state = 9, .external_lex_state = 4},
  [974] = {.lex_state = 9, .external_lex_state = 4},
  [975] = {.lex_state = 9, .external_lex_state = 4},
  [976] = {.lex_state = 9, .external_lex_state = 5},
  [977] = {.lex_state = 34, .external_lex_state = 4},
  [978] = {.lex_state = 9, .external_lex_state = 4},
  [979] = {.lex_state = 34, .external_lex_state = 4},
  [980] = {.lex_state = 34, .external_lex_state = 4},
  [981] = {.lex_state = 9, .external_lex_state = 4},
  [982] = {.lex_state = 9, .external_lex_state = 4},
  [983] = {.lex_state = 9, .external_lex_state = 4},
  [984] = {.lex_state = 9, .external_lex_state = 4},
  [985] = {.lex_state = 9, .external_lex_state = 4},
  [986] = {.lex_state = 9, .external_lex_state = 4},
  [987] = {.lex_state = 9, .external_lex_state = 4},
  [988] = {.lex_state = 34, .external_lex_state = 4},
  [989] = {.lex_state = 9, .external_lex_state = 4},
  [990] = {.lex_state = 9, .external_lex_state = 4},
  [991] = {.lex_state = 9, .external_lex_state = 4},
  [992] = {.lex_state = 34, .external_lex_state = 4},
  [993] = {.lex_state = 34, .external_lex_state = 4},
  [994] = {.lex_state = 9, .external_lex_state = 4},
  [995] = {.lex_state = 34, .external_lex_state = 4},
  [996] = {.lex_state = 34, .external_lex_state = 4},
  [997] = {.lex_state = 9, .external_lex_state = 5},
  [998] = {.lex_state = 9, .external_lex_state = 4},
  [999] = {.lex_state = 9, .external_lex_state = 4},
  [1000] = {.lex_state = 9, .external_lex_state = 4},
  [1001] = {.lex_state = 9, .external_lex_state = 4},
  [1002] = {.lex_state = 9, .external_lex_state = 4},
  [1003] = {.lex_state = 9, .external_lex_state = 4},
  [1004] = {.lex_state = 9, .external_lex_state = 4},
  [1005] = {.lex_state = 9, .external_lex_state = 4},
  [1006] = {.lex_state = 34, .external_lex_state = 4},
  [1007] = {.lex_state = 34, .external_lex_state = 4},
  [1008] = {.lex_state = 34, .external_lex_state = 4},
  [1009] = {.lex_state = 34, .external_lex_state = 4},
  [1010] = {.lex_state = 9, .external_lex_state = 4},
  [1011] = {.lex_state = 34, .external_lex_state = 4},
  [1012] = {.lex_state = 9, .external_lex_state = 4},
  [1013] = {.lex_state = 8, .external_lex_state = 5},
  [1014] = {.lex_state = 9, .external_lex_state = 4},
  [1015] = {.lex_state = 34, .external_lex_state = 4},
  [1016] = {.lex_state = 9, .external_lex_state = 4},
  [1017] = {.lex_state = 9, .external_lex_state = 5},
  [1018] = {.lex_state = 9, .external_lex_state = 4},
  [1019] = {.lex_state = 34, .external_lex_state = 4},
  [1020] = {.lex_state = 9, .external_lex_state = 4},
  [1021] = {.lex_state = 34, .external_lex_state = 4},
  [1022] = {.lex_state = 9, .external_lex_state = 4},
  [1023] = {.lex_state = 34, .external_lex_state = 4},
  [1024] = {.lex_state = 9, .external_lex_state = 4},
  [1025] = {.lex_state = 9, .external_lex_state = 4},
  [1026] = {.lex_state = 34, .external_lex_state = 4},
  [1027] = {.lex_state = 34, .external_lex_state = 4},
  [1028] = {.lex_state = 9, .external_lex_state = 4},
  [1029] = {.lex_state = 9, .external_lex_state = 4},
  [1030] = {.lex_state = 9, .external_lex_state = 4},
  [1031] = {.lex_state = 9, .external_lex_state = 4},
  [1032] = {.lex_state = 9, .external_lex_state = 4},
  [1033] = {.lex_state = 9, .external_lex_state = 4},
  [1034] = {.lex_state = 9, .external_lex_state = 4},
  [1035] = {.lex_state = 9, .external_lex_state = 4},
  [1036] = {.lex_state = 9, .external_lex_state = 4},
  [1037] = {.lex_state = 34, .external_lex_state = 4},
  [1038] = {.lex_state = 9, .external_lex_state = 5},
  [1039] = {.lex_state = 9, .external_lex_state = 5},
  [1040] = {.lex_state = 9, .external_lex_state = 4},
  [1041] = {.lex_state = 9, .external_lex_state = 5},
  [1042] = {.lex_state = 11, .external_lex_state = 4},
  [1043] = {.lex_state = 9, .external_lex_state = 4},
  [1044] = {.lex_state = 17, .external_lex_state = 4},
  [1045] = {.lex_state = 9, .external_lex_state = 5},
  [1046] = {.lex_state = 9, .external_lex_state = 4},
  [1047] = {.lex_state = 8, .external_lex_state = 5},
  [1048] = {.lex_state = 9, .external_lex_state = 5},
  [1049] = {.lex_state = 9, .external_lex_state = 4},
  [1050] = {.lex_state = 17, .external_lex_state = 4},
  [1051] = {.lex_state = 9, .external_lex_state = 4},
  [1052] = {.lex_state = 8, .external_lex_state = 5},
  [1053] = {.lex_state = 9, .external_lex_state = 5},
  [1054] = {.lex_state = 9, .external_lex_state = 5},
  [1055] = {.lex_state = 13, .external_lex_state = 4},
  [1056] = {.lex_state = 9, .external_lex_state = 5},
  [1057] = {.lex_state = 7, .external_lex_state = 4},
  [1058] = {.lex_state = 9, .external_lex_state = 5},
  [1059] = {.lex_state = 9, .external_lex_state = 5},
  [1060] = {.lex_state = 14, .external_lex_state = 4},
  [1061] = {.lex_state = 9, .external_lex_state = 5},
  [1062] = {.lex_state = 9, .external_lex_state = 5},
  [1063] = {.lex_state = 9, .external_lex_state = 5},
  [1064] = {.lex_state = 8, .external_lex_state = 4},
  [1065] = {.lex_state = 9, .external_lex_state = 5},
  [1066] = {.lex_state = 8, .external_lex_state = 4},
  [1067] = {.lex_state = 9, .external_lex_state = 5},
  [1068] = {.lex_state = 14, .external_lex_state = 4},
  [1069] = {.lex_state = 8, .external_lex_state = 4},
  [1070] = {.lex_state = 3, .external_lex_state = 3},
  [1071] = {.lex_state = 9, .external_lex_state = 5},
  [1072] = {.lex_state = 9, .external_lex_state = 5},
  [1073] = {.lex_state = 9, .external_lex_state = 5},
  [1074] = {.lex_state = 17, .external_lex_state = 4},
  [1075] = {.lex_state = 9, .external_lex_state = 5},
  [1076] = {.lex_state = 9, .external_lex_state = 5},
  [1077] = {.lex_state = 9, .external_lex_state = 5},
  [1078] = {.lex_state = 14, .external_lex_state = 4},
  [1079] = {.lex_state = 9, .external_lex_state = 5},
  [1080] = {.lex_state = 9, .external_lex_state = 5},
  [1081] = {.lex_state = 8, .external_lex_state = 5},
  [1082] = {.lex_state = 14, .external_lex_state = 4},
  [1083] = {.lex_state = 9, .external_lex_state = 5},
  [1084] = {.lex_state = 9, .external_lex_state = 5},
  [1085] = {.lex_state = 9, .external_lex_state = 5},
  [1086] = {.lex_state = 8, .external_lex_state = 4},
  [1087] = {.lex_state = 9, .external_lex_state = 5},
  [1088] = {.lex_state = 9, .external_lex_state = 5},
  [1089] = {.lex_state = 9, .external_lex_state = 5},
  [1090] = {.lex_state = 9, .external_lex_state = 5},
  [1091] = {.lex_state = 9, .external_lex_state = 5},
  [1092] = {.lex_state = 9, .external_lex_state = 5},
  [1093] = {.lex_state = 9, .external_lex_state = 5},
  [1094] = {.lex_state = 9, .external_lex_state = 5},
  [1095] = {.lex_state = 9, .external_lex_state = 5},
  [1096] = {.lex_state = 9, .external_lex_state = 5},
  [1097] = {.lex_state = 9, .external_lex_state = 5},
  [1098] = {.lex_state = 9, .external_lex_state = 4},
  [1099] = {.lex_state = 9, .external_lex_state = 5},
  [1100] = {.lex_state = 8, .external_lex_state = 5},
  [1101] = {.lex_state = 9, .external_lex_state = 5},
  [1102] = {.lex_state = 9, .external_lex_state = 5},
  [1103] = {.lex_state = 9, .external_lex_state = 5},
  [1104] = {.lex_state = 8, .external_lex_state = 5},
  [1105] = {.lex_state = 9, .external_lex_state = 5},
  [1106] = {.lex_state = 9, .external_lex_state = 5},
  [1107] = {.lex_state = 9, .external_lex_state = 5},
  [1108] = {.lex_state = 9, .external_lex_state = 5},
  [1109] = {.lex_state = 9, .external_lex_state = 5},
  [1110] = {.lex_state = 9, .external_lex_state = 5},
  [1111] = {.lex_state = 9, .external_lex_state = 5},
  [1112] = {.lex_state = 9, .external_lex_state = 5},
  [1113] = {.lex_state = 9, .external_lex_state = 5},
  [1114] = {.lex_state = 9, .external_lex_state = 5},
  [1115] = {.lex_state = 9, .external_lex_state = 5},
  [1116] = {.lex_state = 9, .external_lex_state = 5},
  [1117] = {.lex_state = 9, .external_lex_state = 4},
  [1118] = {.lex_state = 9, .external_lex_state = 4},
  [1119] = {.lex_state = 9, .external_lex_state = 5},
  [1120] = {.lex_state = 9, .external_lex_state = 5},
  [1121] = {.lex_state = 9, .external_lex_state = 5},
  [1122] = {.lex_state = 9, .external_lex_state = 5},
  [1123] = {.lex_state = 9, .external_lex_state = 5},
  [1124] = {.lex_state = 9, .external_lex_state = 5},
  [1125] = {.lex_state = 9, .external_lex_state = 5},
  [1126] = {.lex_state = 9, .external_lex_state = 5},
  [1127] = {.lex_state = 9, .external_lex_state = 5},
  [1128] = {.lex_state = 9, .external_lex_state = 5},
  [1129] = {.lex_state = 9, .external_lex_state = 5},
  [1130] = {.lex_state = 9, .external_lex_state = 5},
  [1131] = {.lex_state = 12, .external_lex_state = 4},
  [1132] = {.lex_state = 9, .external_lex_state = 5},
  [1133] = {.lex_state = 9, .external_lex_state = 5},
  [1134] = {.lex_state = 8, .external_lex_state = 4},
  [1135] = {.lex_state = 9, .external_lex_state = 5},
  [1136] = {.lex_state = 9, .external_lex_state = 5},
  [1137] = {.lex_state = 9, .external_lex_state = 5},
  [1138] = {.lex_state = 9, .external_lex_state = 5},
  [1139] = {.lex_state = 9, .external_lex_state = 5},
  [1140] = {.lex_state = 8, .external_lex_state = 4},
  [1141] = {.lex_state = 9, .external_lex_state = 5},
  [1142] = {.lex_state = 9, .external_lex_state = 5},
  [1143] = {.lex_state = 9, .external_lex_state = 5},
  [1144] = {.lex_state = 8, .external_lex_state = 4},
  [1145] = {.lex_state = 9, .external_lex_state = 5},
  [1146] = {.lex_state = 9, .external_lex_state = 5},
  [1147] = {.lex_state = 9, .external_lex_state = 5},
  [1148] = {.lex_state = 9, .external_lex_state = 5},
  [1149] = {.lex_state = 9, .external_lex_state = 5},
  [1150] = {.lex_state = 9, .external_lex_state = 5},
  [1151] = {.lex_state = 9, .external_lex_state = 5},
  [1152] = {.lex_state = 9, .external_lex_state = 5},
  [1153] = {.lex_state = 9, .external_lex_state = 5},
  [1154] = {.lex_state = 12, .external_lex_state = 4},
  [1155] = {.lex_state = 9, .external_lex_state = 5},
  [1156] = {.lex_state = 9, .external_lex_state = 5},
  [1157] = {.lex_state = 9, .external_lex_state = 5},
  [1158] = {.lex_state = 8, .external_lex_state = 4},
  [1159] = {.lex_state = 9, .external_lex_state = 5},
  [1160] = {.lex_state = 9, .external_lex_state = 5},
  [1161] = {.lex_state = 9, .external_lex_state = 5},
  [1162] = {.lex_state = 9, .external_lex_state = 5},
  [1163] = {.lex_state = 12, .external_lex_state = 4},
  [1164] = {.lex_state = 9, .external_lex_state = 5},
  [1165] = {.lex_state = 9, .external_lex_state = 5},
  [1166] = {.lex_state = 9, .external_lex_state = 5},
  [1167] = {.lex_state = 9, .external_lex_state = 5},
  [1168] = {.lex_state = 9, .external_lex_state = 5},
  [1169] = {.lex_state = 8, .external_lex_state = 4},
  [1170] = {.lex_state = 9, .external_lex_state = 5},
  [1171] = {.lex_state = 9, .external_lex_state = 5},
  [1172] = {.lex_state = 9, .external_lex_state = 5},
  [1173] = {.lex_state = 9, .external_lex_state = 5},
  [1174] = {.lex_state = 9, .external_lex_state = 5},
  [1175] = {.lex_state = 9, .external_lex_state = 5},
  [1176] = {.lex_state = 9, .external_lex_state = 5},
  [1177] = {.lex_state = 8, .external_lex_state = 4},
  [1178] = {.lex_state = 8, .external_lex_state = 4},
  [1179] = {.lex_state = 12, .external_lex_state = 4},
  [1180] = {.lex_state = 9, .external_lex_state = 4},
  [1181] = {.lex_state = 8, .external_lex_state = 5},
  [1182] = {.lex_state = 17, .external_lex_state = 4},
  [1183] = {.lex_state = 17, .external_lex_state = 4},
  [1184] = {.lex_state = 8, .external_lex_state = 4},
  [1185] = {.lex_state = 8, .external_lex_state = 5},
  [1186] = {.lex_state = 8, .external_lex_state = 5},
  [1187] = {.lex_state = 8, .external_lex_state = 5},
  [1188] = {.lex_state = 8, .external_lex_state = 4},
  [1189] = {.lex_state = 12, .external_lex_state = 4},
  [1190] = {.lex_state = 12, .external_lex_state = 4},
  [1191] = {.lex_state = 8, .external_lex_state = 5},
  [1192] = {.lex_state = 9, .external_lex_state = 4},
  [1193] = {.lex_state = 8, .external_lex_state = 4},
  [1194] = {.lex_state = 34, .external_lex_state = 4},
  [1195] = {.lex_state = 8, .external_lex_state = 5},
  [1196] = {.lex_state = 17, .external_lex_state = 4},
  [1197] = {.lex_state = 12, .external_lex_state = 4},
  [1198] = {.lex_state = 9, .external_lex_state = 4},
  [1199] = {.lex_state = 9, .external_lex_state = 4},
  [1200] = {.lex_state = 8, .external_lex_state = 4},
  [1201] = {.lex_state = 8, .external_lex_state = 5},
  [1202] = {.lex_state = 8, .external_lex_state = 5},
  [1203] = {.lex_state = 8, .external_lex_state = 5},
  [1204] = {.lex_state = 8, .external_lex_state = 5},
  [1205] = {.lex_state = 9, .external_lex_state = 4},
  [1206] = {.lex_state = 8, .external_lex_state = 5},
  [1207] = {.lex_state = 9, .external_lex_state = 4},
  [1208] = {.lex_state = 8, .external_lex_state = 5},
  [1209] = {.lex_state = 8, .external_lex_state = 5},
  [1210] = {.lex_state = 12, .external_lex_state = 4},
  [1211] = {.lex_state = 17, .external_lex_state = 4},
  [1212] = {.lex_state = 8, .external_lex_state = 4},
  [1213] = {.lex_state = 8, .external_lex_state = 4},
  [1214] = {.lex_state = 8, .external_lex_state = 4},
  [1215] = {.lex_state = 8, .external_lex_state = 4},
  [1216] = {.lex_state = 8, .external_lex_state = 4},
  [1217] = {.lex_state = 8, .external_lex_state = 4},
  [1218] = {.lex_state = 8, .external_lex_state = 4},
  [1219] = {.lex_state = 8, .external_lex_state = 4},
  [1220] = {.lex_state = 8, .external_lex_state = 4},
  [1221] = {.lex_state = 8, .external_lex_state = 4},
  [1222] = {.lex_state = 8, .external_lex_state = 4},
  [1223] = {.lex_state = 8, .external_lex_state = 4},
  [1224] = {.lex_state = 8, .external_lex_state = 4},
  [1225] = {.lex_state = 8, .external_lex_state = 4},
  [1226] = {.lex_state = 8, .external_lex_state = 4},
  [1227] = {.lex_state = 8, .external_lex_state = 4},
  [1228] = {.lex_state = 8, .external_lex_state = 4},
  [1229] = {.lex_state = 8, .external_lex_state = 4},
  [1230] = {.lex_state = 8, .external_lex_state = 4},
  [1231] = {.lex_state = 9, .external_lex_state = 4},
  [1232] = {.lex_state = 8, .external_lex_state = 4},
  [1233] = {.lex_state = 8, .external_lex_state = 4},
  [1234] = {.lex_state = 8, .external_lex_state = 4},
  [1235] = {.lex_state = 8, .external_lex_state = 4},
  [1236] = {.lex_state = 8, .external_lex_state = 4},
  [1237] = {.lex_state = 8, .external_lex_state = 4},
  [1238] = {.lex_state = 8, .external_lex_state = 4},
  [1239] = {.lex_state = 8, .external_lex_state = 4},
  [1240] = {.lex_state = 8, .external_lex_state = 4},
  [1241] = {.lex_state = 8, .external_lex_state = 4},
  [1242] = {.lex_state = 8, .external_lex_state = 4},
  [1243] = {.lex_state = 12, .external_lex_state = 4},
  [1244] = {.lex_state = 8, .external_lex_state = 4},
  [1245] = {.lex_state = 8, .external_lex_state = 4},
  [1246] = {.lex_state = 12, .external_lex_state = 4},
  [1247] = {.lex_state = 12, .external_lex_state = 4},
  [1248] = {.lex_state = 8, .external_lex_state = 4},
  [1249] = {.lex_state = 8, .external_lex_state = 4},
  [1250] = {.lex_state = 8, .external_lex_state = 4},
  [1251] = {.lex_state = 8, .external_lex_state = 4},
  [1252] = {.lex_state = 8, .external_lex_state = 4},
  [1253] = {.lex_state = 8, .external_lex_state = 4},
  [1254] = {.lex_state = 8, .external_lex_state = 4},
  [1255] = {.lex_state = 8, .external_lex_state = 4},
  [1256] = {.lex_state = 8, .external_lex_state = 4},
  [1257] = {.lex_state = 8, .external_lex_state = 4},
  [1258] = {.lex_state = 8, .external_lex_state = 4},
  [1259] = {.lex_state = 8, .external_lex_state = 4},
  [1260] = {.lex_state = 8, .external_lex_state = 4},
  [1261] = {.lex_state = 8, .external_lex_state = 4},
  [1262] = {.lex_state = 14, .external_lex_state = 4},
  [1263] = {.lex_state = 8, .external_lex_state = 4},
  [1264] = {.lex_state = 8, .external_lex_state = 4},
  [1265] = {.lex_state = 8, .external_lex_state = 4},
  [1266] = {.lex_state = 8, .external_lex_state = 4},
  [1267] = {.lex_state = 8, .external_lex_state = 4},
  [1268] = {.lex_state = 8, .external_lex_state = 4},
  [1269] = {.lex_state = 14, .external_lex_state = 4},
  [1270] = {.lex_state = 8, .external_lex_state = 4},
  [1271] = {.lex_state = 8, .external_lex_state = 4},
  [1272] = {.lex_state = 5, .external_lex_state = 3},
  [1273] = {.lex_state = 8, .external_lex_state = 4},
  [1274] = {.lex_state = 8, .external_lex_state = 4},
  [1275] = {.lex_state = 8, .external_lex_state = 4},
  [1276] = {.lex_state = 8, .external_lex_state = 4},
  [1277] = {.lex_state = 8, .external_lex_state = 4},
  [1278] = {.lex_state = 8, .external_lex_state = 4},
  [1279] = {.lex_state = 8, .external_lex_state = 5},
  [1280] = {.lex_state = 8, .external_lex_state = 4},
  [1281] = {.lex_state = 8, .external_lex_state = 4},
  [1282] = {.lex_state = 8, .external_lex_state = 4},
  [1283] = {.lex_state = 12, .external_lex_state = 4},
  [1284] = {.lex_state = 8, .external_lex_state = 4},
  [1285] = {.lex_state = 8, .external_lex_state = 4},
  [1286] = {.lex_state = 8, .external_lex_state = 4},
  [1287] = {.lex_state = 8, .external_lex_state = 4},
  [1288] = {.lex_state = 8, .external_lex_state = 4},
  [1289] = {.lex_state = 8, .external_lex_state = 4},
  [1290] = {.lex_state = 8, .external_lex_state = 4},
  [1291] = {.lex_state = 8, .external_lex_state = 4},
  [1292] = {.lex_state = 8, .external_lex_state = 4},
  [1293] = {.lex_state = 8, .external_lex_state = 4},
  [1294] = {.lex_state = 8, .external_lex_state = 4},
  [1295] = {.lex_state = 8, .external_lex_state = 4},
  [1296] = {.lex_state = 8, .external_lex_state = 4},
  [1297] = {.lex_state = 8, .external_lex_state = 4},
  [1298] = {.lex_state = 8, .external_lex_state = 4},
  [1299] = {.lex_state = 8, .external_lex_state = 4},
  [1300] = {.lex_state = 8, .external_lex_state = 4},
  [1301] = {.lex_state = 12, .external_lex_state = 4},
  [1302] = {.lex_state = 8, .external_lex_state = 4},
  [1303] = {.lex_state = 8, .external_lex_state = 4},
  [1304] = {.lex_state = 8, .external_lex_state = 4},
  [1305] = {.lex_state = 8, .external_lex_state = 4},
  [1306] = {.lex_state = 8, .external_lex_state = 4},
  [1307] = {.lex_state = 8, .external_lex_state = 4},
  [1308] = {.lex_state = 8, .external_lex_state = 4},
  [1309] = {.lex_state = 8, .external_lex_state = 4},
  [1310] = {.lex_state = 8, .external_lex_state = 4},
  [1311] = {.lex_state = 8, .external_lex_state = 4},
  [1312] = {.lex_state = 8, .external_lex_state = 4},
  [1313] = {.lex_state = 8, .external_lex_state = 4},
  [1314] = {.lex_state = 8, .external_lex_state = 4},
  [1315] = {.lex_state = 12, .external_lex_state = 4},
  [1316] = {.lex_state = 8, .external_lex_state = 4},
  [1317] = {.lex_state = 8, .external_lex_state = 4},
  [1318] = {.lex_state = 8, .external_lex_state = 4},
  [1319] = {.lex_state = 8, .external_lex_state = 4},
  [1320] = {.lex_state = 8, .external_lex_state = 4},
  [1321] = {.lex_state = 9, .external_lex_state = 4},
  [1322] = {.lex_state = 8, .external_lex_state = 4},
  [1323] = {.lex_state = 14, .external_lex_state = 4},
  [1324] = {.lex_state = 12, .external_lex_state = 4},
  [1325] = {.lex_state = 8, .external_lex_state = 4},
  [1326] = {.lex_state = 8, .external_lex_state = 4},
  [1327] = {.lex_state = 14, .external_lex_state = 4},
  [1328] = {.lex_state = 12, .external_lex_state = 4},
  [1329] = {.lex_state = 12, .external_lex_state = 4},
  [1330] = {.lex_state = 12, .external_lex_state = 4},
  [1331] = {.lex_state = 12, .external_lex_state = 4},
  [1332] = {.lex_state = 8, .external_lex_state = 4},
  [1333] = {.lex_state = 8, .external_lex_state = 4},
  [1334] = {.lex_state = 12, .external_lex_state = 4},
  [1335] = {.lex_state = 12, .external_lex_state = 4},
  [1336] = {.lex_state = 12, .external_lex_state = 4},
  [1337] = {.lex_state = 12, .external_lex_state = 4},
  [1338] = {.lex_state = 12, .external_lex_state = 4},
  [1339] = {.lex_state = 12, .external_lex_state = 4},
  [1340] = {.lex_state = 12, .external_lex_state = 4},
  [1341] = {.lex_state = 12, .external_lex_state = 4},
  [1342] = {.lex_state = 12, .external_lex_state = 4},
  [1343] = {.lex_state = 12, .external_lex_state = 4},
  [1344] = {.lex_state = 12, .external_lex_state = 4},
  [1345] = {.lex_state = 12, .external_lex_state = 4},
  [1346] = {.lex_state = 12, .external_lex_state = 4},
  [1347] = {.lex_state = 12, .external_lex_state = 4},
  [1348] = {.lex_state = 12, .external_lex_state = 4},
  [1349] = {.lex_state = 12, .external_lex_state = 4},
  [1350] = {.lex_state = 12, .external_lex_state = 4},
  [1351] = {.lex_state = 12, .external_lex_state = 4},
  [1352] = {.lex_state = 12, .external_lex_state = 4},
  [1353] = {.lex_state = 12, .external_lex_state = 4},
  [1354] = {.lex_state = 12, .external_lex_state = 4},
  [1355] = {.lex_state = 12, .external_lex_state = 4},
  [1356] = {.lex_state = 12, .external_lex_state = 4},
  [1357] = {.lex_state = 12, .external_lex_state = 4},
  [1358] = {.lex_state = 8, .external_lex_state = 4},
  [1359] = {.lex_state = 12, .external_lex_state = 4},
  [1360] = {.lex_state = 12, .external_lex_state = 4},
  [1361] = {.lex_state = 12, .external_lex_state = 4},
  [1362] = {.lex_state = 12, .external_lex_state = 4},
  [1363] = {.lex_state = 12, .external_lex_state = 4},
  [1364] = {.lex_state = 12, .external_lex_state = 4},
  [1365] = {.lex_state = 12, .external_lex_state = 4},
  [1366] = {.lex_state = 12, .external_lex_state = 4},
  [1367] = {.lex_state = 12, .external_lex_state = 4},
  [1368] = {.lex_state = 12, .external_lex_state = 4},
  [1369] = {.lex_state = 12, .external_lex_state = 4},
  [1370] = {.lex_state = 12, .external_lex_state = 4},
  [1371] = {.lex_state = 12, .external_lex_state = 4},
  [1372] = {.lex_state = 12, .external_lex_state = 4},
  [1373] = {.lex_state = 12, .external_lex_state = 4},
  [1374] = {.lex_state = 12, .external_lex_state = 4},
  [1375] = {.lex_state = 12, .external_lex_state = 4},
  [1376] = {.lex_state = 12, .external_lex_state = 4},
  [1377] = {.lex_state = 12, .external_lex_state = 4},
  [1378] = {.lex_state = 12, .external_lex_state = 4},
  [1379] = {.lex_state = 12, .external_lex_state = 4},
  [1380] = {.lex_state = 12, .external_lex_state = 4},
  [1381] = {.lex_state = 12, .external_lex_state = 4},
  [1382] = {.lex_state = 12, .external_lex_state = 4},
  [1383] = {.lex_state = 12, .external_lex_state = 4},
  [1384] = {.lex_state = 12, .external_lex_state = 4},
  [1385] = {.lex_state = 12, .external_lex_state = 4},
  [1386] = {.lex_state = 12, .external_lex_state = 4},
  [1387] = {.lex_state = 8, .external_lex_state = 4},
  [1388] = {.lex_state = 8, .external_lex_state = 4},
  [1389] = {.lex_state = 8, .external_lex_state = 4},
  [1390] = {.lex_state = 12, .external_lex_state = 4},
  [1391] = {.lex_state = 12, .external_lex_state = 4},
  [1392] = {.lex_state = 12, .external_lex_state = 4},
  [1393] = {.lex_state = 8, .external_lex_state = 4},
  [1394] = {.lex_state = 12, .external_lex_state = 4},
  [1395] = {.lex_state = 12, .external_lex_state = 4},
  [1396] = {.lex_state = 12, .external_lex_state = 4},
  [1397] = {.lex_state = 12, .external_lex_state = 4},
  [1398] = {.lex_state = 12, .external_lex_state = 4},
  [1399] = {.lex_state = 8, .external_lex_state = 4},
  [1400] = {.lex_state = 12, .external_lex_state = 4},
  [1401] = {.lex_state = 12, .external_lex_state = 4},
  [1402] = {.lex_state = 12, .external_lex_state = 4},
  [1403] = {.lex_state = 8, .external_lex_state = 4},
  [1404] = {.lex_state = 12, .external_lex_state = 4},
  [1405] = {.lex_state = 12, .external_lex_state = 4},
  [1406] = {.lex_state = 8, .external_lex_state = 4},
  [1407] = {.lex_state = 9, .external_lex_state = 4},
  [1408] = {.lex_state = 12, .external_lex_state = 4},
  [1409] = {.lex_state = 12, .external_lex_state = 4},
  [1410] = {.lex_state = 12, .external_lex_state = 4},
  [1411] = {.lex_state = 12, .external_lex_state = 4},
  [1412] = {.lex_state = 12, .external_lex_state = 4},
  [1413] = {.lex_state = 8, .external_lex_state = 4},
  [1414] = {.lex_state = 12, .external_lex_state = 4},
  [1415] = {.lex_state = 12, .external_lex_state = 4},
  [1416] = {.lex_state = 8, .external_lex_state = 4},
  [1417] = {.lex_state = 8, .external_lex_state = 4},
  [1418] = {.lex_state = 8, .external_lex_state = 4},
  [1419] = {.lex_state = 12, .external_lex_state = 4},
  [1420] = {.lex_state = 12, .external_lex_state = 4},
  [1421] = {.lex_state = 12, .external_lex_state = 4},
  [1422] = {.lex_state = 12, .external_lex_state = 4},
  [1423] = {.lex_state = 12, .external_lex_state = 4},
  [1424] = {.lex_state = 12, .external_lex_state = 4},
  [1425] = {.lex_state = 12, .external_lex_state = 4},
  [1426] = {.lex_state = 12, .external_lex_state = 4},
  [1427] = {.lex_state = 12, .external_lex_state = 4},
  [1428] = {.lex_state = 12, .external_lex_state = 4},
  [1429] = {.lex_state = 12, .external_lex_state = 4},
  [1430] = {.lex_state = 12, .external_lex_state = 4},
  [1431] = {.lex_state = 12, .external_lex_state = 4},
  [1432] = {.lex_state = 12, .external_lex_state = 4},
  [1433] = {.lex_state = 12, .external_lex_state = 4},
  [1434] = {.lex_state = 12, .external_lex_state = 4},
  [1435] = {.lex_state = 8, .external_lex_state = 4},
  [1436] = {.lex_state = 8, .external_lex_state = 4},
  [1437] = {.lex_state = 8, .external_lex_state = 4},
  [1438] = {.lex_state = 8, .external_lex_state = 4},
  [1439] = {.lex_state = 8, .external_lex_state = 4},
  [1440] = {.lex_state = 8, .external_lex_state = 4},
  [1441] = {.lex_state = 8, .external_lex_state = 4},
  [1442] = {.lex_state = 9, .external_lex_state = 4},
  [1443] = {.lex_state = 8, .external_lex_state = 4},
  [1444] = {.lex_state = 8, .external_lex_state = 4},
  [1445] = {.lex_state = 9, .external_lex_state = 4},
  [1446] = {.lex_state = 8, .external_lex_state = 4},
  [1447] = {.lex_state = 8, .external_lex_state = 4},
  [1448] = {.lex_state = 8, .external_lex_state = 4},
  [1449] = {.lex_state = 8, .external_lex_state = 4},
  [1450] = {.lex_state = 8, .external_lex_state = 4},
  [1451] = {.lex_state = 8, .external_lex_state = 4},
  [1452] = {.lex_state = 9, .external_lex_state = 4},
  [1453] = {.lex_state = 8, .external_lex_state = 4},
  [1454] = {.lex_state = 9, .external_lex_state = 4},
  [1455] = {.lex_state = 9, .external_lex_state = 4},
  [1456] = {.lex_state = 9, .external_lex_state = 4},
  [1457] = {.lex_state = 9, .external_lex_state = 4},
  [1458] = {.lex_state = 8, .external_lex_state = 4},
  [1459] = {.lex_state = 9, .external_lex_state = 4},
  [1460] = {.lex_state = 8, .external_lex_state = 4},
  [1461] = {.lex_state = 9, .external_lex_state = 4},
  [1462] = {.lex_state = 9, .external_lex_state = 5},
  [1463] = {.lex_state = 8, .external_lex_state = 4},
  [1464] = {.lex_state = 9, .external_lex_state = 5},
  [1465] = {.lex_state = 9, .external_lex_state = 5},
  [1466] = {.lex_state = 9, .external_lex_state = 5},
  [1467] = {.lex_state = 9, .external_lex_state = 5},
  [1468] = {.lex_state = 9, .external_lex_state = 5},
  [1469] = {.lex_state = 9, .external_lex_state = 5},
  [1470] = {.lex_state = 8, .external_lex_state = 4},
  [1471] = {.lex_state = 9, .external_lex_state = 4},
  [1472] = {.lex_state = 8, .external_lex_state = 4},
  [1473] = {.lex_state = 9, .external_lex_state = 4},
  [1474] = {.lex_state = 9, .external_lex_state = 5},
  [1475] = {.lex_state = 9, .external_lex_state = 4},
  [1476] = {.lex_state = 9, .external_lex_state = 4},
  [1477] = {.lex_state = 8, .external_lex_state = 4},
  [1478] = {.lex_state = 9, .external_lex_state = 4},
  [1479] = {.lex_state = 8, .external_lex_state = 4},
  [1480] = {.lex_state = 8, .external_lex_state = 4},
  [1481] = {.lex_state = 8, .external_lex_state = 4},
  [1482] = {.lex_state = 8, .external_lex_state = 4},
  [1483] = {.lex_state = 8, .external_lex_state = 4},
  [1484] = {.lex_state = 8, .external_lex_state = 4},
  [1485] = {.lex_state = 9, .external_lex_state = 4},
  [1486] = {.lex_state = 8, .external_lex_state = 4},
  [1487] = {.lex_state = 9, .external_lex_state = 4},
  [1488] = {.lex_state = 9, .external_lex_state = 5},
  [1489] = {.lex_state = 9, .external_lex_state = 4},
  [1490] = {.lex_state = 9, .external_lex_state = 4},
  [1491] = {.lex_state = 8, .external_lex_state = 5},
  [1492] = {.lex_state = 8, .external_lex_state = 4},
  [1493] = {.lex_state = 8, .external_lex_state = 5},
  [1494] = {.lex_state = 8, .external_lex_state = 4},
  [1495] = {.lex_state = 9, .external_lex_state = 4},
  [1496] = {.lex_state = 8, .external_lex_state = 5},
  [1497] = {.lex_state = 9, .external_lex_state = 4},
  [1498] = {.lex_state = 8, .external_lex_state = 4},
  [1499] = {.lex_state = 8, .external_lex_state = 4},
  [1500] = {.lex_state = 9, .external_lex_state = 4},
  [1501] = {.lex_state = 8, .external_lex_state = 4},
  [1502] = {.lex_state = 9, .external_lex_state = 4},
  [1503] = {.lex_state = 8, .external_lex_state = 4},
  [1504] = {.lex_state = 8, .external_lex_state = 4},
  [1505] = {.lex_state = 8, .external_lex_state = 4},
  [1506] = {.lex_state = 8, .external_lex_state = 5},
  [1507] = {.lex_state = 8, .external_lex_state = 4},
  [1508] = {.lex_state = 9, .external_lex_state = 4},
  [1509] = {.lex_state = 8, .external_lex_state = 4},
  [1510] = {.lex_state = 5, .external_lex_state = 3},
  [1511] = {.lex_state = 9, .external_lex_state = 4},
  [1512] = {.lex_state = 9, .external_lex_state = 4},
  [1513] = {.lex_state = 8, .external_lex_state = 4},
  [1514] = {.lex_state = 9, .external_lex_state = 4},
  [1515] = {.lex_state = 8, .external_lex_state = 4},
  [1516] = {.lex_state = 9, .external_lex_state = 4},
  [1517] = {.lex_state = 8, .external_lex_state = 5},
  [1518] = {.lex_state = 8, .external_lex_state = 5},
  [1519] = {.lex_state = 8, .external_lex_state = 5},
  [1520] = {.lex_state = 8, .external_lex_state = 5},
  [1521] = {.lex_state = 9, .external_lex_state = 4},
  [1522] = {.lex_state = 8, .external_lex_state = 4},
  [1523] = {.lex_state = 8, .external_lex_state = 4},
  [1524] = {.lex_state = 8, .external_lex_state = 4},
  [1525] = {.lex_state = 12, .external_lex_state = 4},
  [1526] = {.lex_state = 12, .external_lex_state = 4},
  [1527] = {.lex_state = 8, .external_lex_state = 4},
  [1528] = {.lex_state = 12, .external_lex_state = 4},
  [1529] = {.lex_state = 8, .external_lex_state = 4},
  [1530] = {.lex_state = 8, .external_lex_state = 4},
  [1531] = {.lex_state = 8, .external_lex_state = 4},
  [1532] = {.lex_state = 8, .external_lex_state = 4},
  [1533] = {.lex_state = 5, .external_lex_state = 3},
  [1534] = {.lex_state = 8, .external_lex_state = 4},
  [1535] = {.lex_state = 8, .external_lex_state = 4},
  [1536] = {.lex_state = 8, .external_lex_state = 4},
  [1537] = {.lex_state = 8, .external_lex_state = 4},
  [1538] = {.lex_state = 8, .external_lex_state = 4},
  [1539] = {.lex_state = 8, .external_lex_state = 4},
  [1540] = {.lex_state = 12, .external_lex_state = 4},
  [1541] = {.lex_state = 5, .external_lex_state = 3},
  [1542] = {.lex_state = 12, .external_lex_state = 4},
  [1543] = {.lex_state = 8, .external_lex_state = 4},
  [1544] = {.lex_state = 12, .external_lex_state = 4},
  [1545] = {.lex_state = 12, .external_lex_state = 4},
  [1546] = {.lex_state = 8, .external_lex_state = 4},
  [1547] = {.lex_state = 8, .external_lex_state = 4},
  [1548] = {.lex_state = 8, .external_lex_state = 4},
  [1549] = {.lex_state = 8, .external_lex_state = 4},
  [1550] = {.lex_state = 8, .external_lex_state = 4},
  [1551] = {.lex_state = 8, .external_lex_state = 4},
  [1552] = {.lex_state = 8, .external_lex_state = 4},
  [1553] = {.lex_state = 12, .external_lex_state = 4},
  [1554] = {.lex_state = 12, .external_lex_state = 4},
  [1555] = {.lex_state = 12, .external_lex_state = 4},
  [1556] = {.lex_state = 8, .external_lex_state = 4},
  [1557] = {.lex_state = 8, .external_lex_state = 4},
  [1558] = {.lex_state = 8, .external_lex_state = 4},
  [1559] = {.lex_state = 8, .external_lex_state = 4},
  [1560] = {.lex_state = 8, .external_lex_state = 4},
  [1561] = {.lex_state = 8, .external_lex_state = 4},
  [1562] = {.lex_state = 8, .external_lex_state = 4},
  [1563] = {.lex_state = 8, .external_lex_state = 4},
  [1564] = {.lex_state = 8, .external_lex_state = 4},
  [1565] = {.lex_state = 8, .external_lex_state = 4},
  [1566] = {.lex_state = 8, .external_lex_state = 4},
  [1567] = {.lex_state = 8, .external_lex_state = 4},
  [1568] = {.lex_state = 8, .external_lex_state = 4},
  [1569] = {.lex_state = 8, .external_lex_state = 4},
  [1570] = {.lex_state = 8, .external_lex_state = 4},
  [1571] = {.lex_state = 8, .external_lex_state = 4},
  [1572] = {.lex_state = 8, .external_lex_state = 4},
  [1573] = {.lex_state = 8, .external_lex_state = 4},
  [1574] = {.lex_state = 8, .external_lex_state = 4},
  [1575] = {.lex_state = 8, .external_lex_state = 4},
  [1576] = {.lex_state = 8, .external_lex_state = 4},
  [1577] = {.lex_state = 8, .external_lex_state = 4},
  [1578] = {.lex_state = 8, .external_lex_state = 4},
  [1579] = {.lex_state = 8, .external_lex_state = 4},
  [1580] = {.lex_state = 5, .external_lex_state = 3},
  [1581] = {.lex_state = 8, .external_lex_state = 4},
  [1582] = {.lex_state = 8, .external_lex_state = 4},
  [1583] = {.lex_state = 5, .external_lex_state = 3},
  [1584] = {.lex_state = 9, .external_lex_state = 4},
  [1585] = {.lex_state = 8, .external_lex_state = 4},
  [1586] = {.lex_state = 8, .external_lex_state = 4},
  [1587] = {.lex_state = 9, .external_lex_state = 4},
  [1588] = {.lex_state = 9, .external_lex_state = 4},
  [1589] = {.lex_state = 8, .external_lex_state = 4},
  [1590] = {.lex_state = 9, .external_lex_state = 4},
  [1591] = {.lex_state = 8, .external_lex_state = 4},
  [1592] = {.lex_state = 8, .external_lex_state = 4},
  [1593] = {.lex_state = 8, .external_lex_state = 4},
  [1594] = {.lex_state = 8, .external_lex_state = 4},
  [1595] = {.lex_state = 8, .external_lex_state = 4},
  [1596] = {.lex_state = 8, .external_lex_state = 4},
  [1597] = {.lex_state = 8, .external_lex_state = 4},
  [1598] = {.lex_state = 8, .external_lex_state = 4},
  [1599] = {.lex_state = 8, .external_lex_state = 4},
  [1600] = {.lex_state = 8, .external_lex_state = 4},
  [1601] = {.lex_state = 8, .external_lex_state = 4},
  [1602] = {.lex_state = 8, .external_lex_state = 4},
  [1603] = {.lex_state = 9, .external_lex_state = 4},
  [1604] = {.lex_state = 9, .external_lex_state = 4},
  [1605] = {.lex_state = 8, .external_lex_state = 4},
  [1606] = {.lex_state = 9, .external_lex_state = 4},
  [1607] = {.lex_state = 5, .external_lex_state = 3},
  [1608] = {.lex_state = 8, .external_lex_state = 4},
  [1609] = {.lex_state = 8, .external_lex_state = 4},
  [1610] = {.lex_state = 5, .external_lex_state = 3},
  [1611] = {.lex_state = 9, .external_lex_state = 4},
  [1612] = {.lex_state = 8, .external_lex_state = 4},
  [1613] = {.lex_state = 8, .external_lex_state = 4},
  [1614] = {.lex_state = 8, .external_lex_state = 4},
  [1615] = {.lex_state = 8, .external_lex_state = 4},
  [1616] = {.lex_state = 8, .external_lex_state = 4},
  [1617] = {.lex_state = 9, .external_lex_state = 4},
  [1618] = {.lex_state = 9, .external_lex_state = 4},
  [1619] = {.lex_state = 8, .external_lex_state = 4},
  [1620] = {.lex_state = 8, .external_lex_state = 4},
  [1621] = {.lex_state = 8, .external_lex_state = 4},
  [1622] = {.lex_state = 8, .external_lex_state = 4},
  [1623] = {.lex_state = 8, .external_lex_state = 4},
  [1624] = {.lex_state = 9, .external_lex_state = 4},
  [1625] = {.lex_state = 8, .external_lex_state = 4},
  [1626] = {.lex_state = 9, .external_lex_state = 4},
  [1627] = {.lex_state = 8, .external_lex_state = 4},
  [1628] = {.lex_state = 8, .external_lex_state = 4},
  [1629] = {.lex_state = 8, .external_lex_state = 4},
  [1630] = {.lex_state = 9, .external_lex_state = 4},
  [1631] = {.lex_state = 8, .external_lex_state = 4},
  [1632] = {.lex_state = 8, .external_lex_state = 4},
  [1633] = {.lex_state = 9, .external_lex_state = 4},
  [1634] = {.lex_state = 8, .external_lex_state = 4},
  [1635] = {.lex_state = 8, .external_lex_state = 4},
  [1636] = {.lex_state = 12, .external_lex_state = 4},
  [1637] = {.lex_state = 9, .external_lex_state = 4},
  [1638] = {.lex_state = 8, .external_lex_state = 4},
  [1639] = {.lex_state = 8, .external_lex_state = 4},
  [1640] = {.lex_state = 12, .external_lex_state = 4},
  [1641] = {.lex_state = 8, .external_lex_state = 4},
  [1642] = {.lex_state = 12, .external_lex_state = 4},
  [1643] = {.lex_state = 8, .external_lex_state = 4},
  [1644] = {.lex_state = 8, .external_lex_state = 4},
  [1645] = {.lex_state = 8, .external_lex_state = 4},
  [1646] = {.lex_state = 12, .external_lex_state = 4},
  [1647] = {.lex_state = 12, .external_lex_state = 4},
  [1648] = {.lex_state = 8, .external_lex_state = 4},
  [1649] = {.lex_state = 8, .external_lex_state = 4},
  [1650] = {.lex_state = 12, .external_lex_state = 4},
  [1651] = {.lex_state = 8, .external_lex_state = 4},
  [1652] = {.lex_state = 8, .external_lex_state = 4},
  [1653] = {.lex_state = 8, .external_lex_state = 4},
  [1654] = {.lex_state = 9, .external_lex_state = 4},
  [1655] = {.lex_state = 12, .external_lex_state = 4},
  [1656] = {.lex_state = 8, .external_lex_state = 4},
  [1657] = {.lex_state = 8, .external_lex_state = 4},
  [1658] = {.lex_state = 8, .external_lex_state = 4},
  [1659] = {.lex_state = 12, .external_lex_state = 4},
  [1660] = {.lex_state = 8, .external_lex_state = 4},
  [1661] = {.lex_state = 8, .external_lex_state = 4},
  [1662] = {.lex_state = 8, .external_lex_state = 4},
  [1663] = {.lex_state = 8, .external_lex_state = 4},
  [1664] = {.lex_state = 8, .external_lex_state = 4},
  [1665] = {.lex_state = 8, .external_lex_state = 4},
  [1666] = {.lex_state = 8, .external_lex_state = 4},
  [1667] = {.lex_state = 8, .external_lex_state = 4},
  [1668] = {.lex_state = 8, .external_lex_state = 4},
  [1669] = {.lex_state = 9, .external_lex_state = 4},
  [1670] = {.lex_state = 8, .external_lex_state = 4},
  [1671] = {.lex_state = 8, .external_lex_state = 4},
  [1672] = {.lex_state = 9, .external_lex_state = 4},
  [1673] = {.lex_state = 8, .external_lex_state = 4},
  [1674] = {.lex_state = 12, .external_lex_state = 4},
  [1675] = {.lex_state = 12, .external_lex_state = 4},
  [1676] = {.lex_state = 8, .external_lex_state = 4},
  [1677] = {.lex_state = 8, .external_lex_state = 4},
  [1678] = {.lex_state = 8, .external_lex_state = 4},
  [1679] = {.lex_state = 12, .external_lex_state = 4},
  [1680] = {.lex_state = 9, .external_lex_state = 4},
  [1681] = {.lex_state = 9, .external_lex_state = 4},
  [1682] = {.lex_state = 8, .external_lex_state = 4},
  [1683] = {.lex_state = 9, .external_lex_state = 4},
  [1684] = {.lex_state = 9, .external_lex_state = 4},
  [1685] = {.lex_state = 9, .external_lex_state = 4},
  [1686] = {.lex_state = 8, .external_lex_state = 4},
  [1687] = {.lex_state = 8, .external_lex_state = 4},
  [1688] = {.lex_state = 8, .external_lex_state = 4},
  [1689] = {.lex_state = 0, .external_lex_state = 4},
  [1690] = {.lex_state = 8, .external_lex_state = 4},
  [1691] = {.lex_state = 8, .external_lex_state = 4},
  [1692] = {.lex_state = 8, .external_lex_state = 4},
  [1693] = {.lex_state = 12, .external_lex_state = 4},
  [1694] = {.lex_state = 8, .external_lex_state = 4},
  [1695] = {.lex_state = 9, .external_lex_state = 4},
  [1696] = {.lex_state = 9, .external_lex_state = 4},
  [1697] = {.lex_state = 0, .external_lex_state = 4},
  [1698] = {.lex_state = 12, .external_lex_state = 4},
  [1699] = {.lex_state = 0, .external_lex_state = 4},
  [1700] = {.lex_state = 0, .external_lex_state = 4},
  [1701] = {.lex_state = 20, .external_lex_state = 3},
  [1702] = {.lex_state = 12, .external_lex_state = 4},
  [1703] = {.lex_state = 12, .external_lex_state = 4},
  [1704] = {.lex_state = 0, .external_lex_state = 4},
  [1705] = {.lex_state = 12, .external_lex_state = 4},
  [1706] = {.lex_state = 0, .external_lex_state = 4},
  [1707] = {.lex_state = 12, .external_lex_state = 4},
  [1708] = {.lex_state = 12, .external_lex_state = 4},
  [1709] = {.lex_state = 12, .external_lex_state = 4},
  [1710] = {.lex_state = 0, .external_lex_state = 4},
  [1711] = {.lex_state = 0, .external_lex_state = 4},
  [1712] = {.lex_state = 0, .external_lex_state = 4},
  [1713] = {.lex_state = 0, .external_lex_state = 4},
  [1714] = {.lex_state = 0, .external_lex_state = 4},
  [1715] = {.lex_state = 0, .external_lex_state = 4},
  [1716] = {.lex_state = 0, .external_lex_state = 4},
  [1717] = {.lex_state = 0, .external_lex_state = 4},
  [1718] = {.lex_state = 0, .external_lex_state = 4},
  [1719] = {.lex_state = 0, .external_lex_state = 4},
  [1720] = {.lex_state = 0, .external_lex_state = 4},
  [1721] = {.lex_state = 0, .external_lex_state = 4},
  [1722] = {.lex_state = 0, .external_lex_state = 4},
  [1723] = {.lex_state = 0, .external_lex_state = 4},
  [1724] = {.lex_state = 0, .external_lex_state = 4},
  [1725] = {.lex_state = 0, .external_lex_state = 4},
  [1726] = {.lex_state = 0, .external_lex_state = 4},
  [1727] = {.lex_state = 0, .external_lex_state = 4},
  [1728] = {.lex_state = 41, .external_lex_state = 4},
  [1729] = {.lex_state = 4, .external_lex_state = 4},
  [1730] = {.lex_state = 26, .external_lex_state = 6},
  [1731] = {.lex_state = 26, .external_lex_state = 6},
  [1732] = {.lex_state = 8, .external_lex_state = 4},
  [1733] = {.lex_state = 8, .external_lex_state = 4},
  [1734] = {.lex_state = 0, .external_lex_state = 4},
  [1735] = {.lex_state = 0, .external_lex_state = 4},
  [1736] = {.lex_state = 40, .external_lex_state = 4},
  [1737] = {.lex_state = 4, .external_lex_state = 4},
  [1738] = {.lex_state = 8, .external_lex_state = 4},
  [1739] = {.lex_state = 0, .external_lex_state = 4},
  [1740] = {.lex_state = 8, .external_lex_state = 4},
  [1741] = {.lex_state = 8, .external_lex_state = 4},
  [1742] = {.lex_state = 42, .external_lex_state = 4},
  [1743] = {.lex_state = 0, .external_lex_state = 4},
  [1744] = {.lex_state = 0, .external_lex_state = 4},
  [1745] = {.lex_state = 42, .external_lex_state = 4},
  [1746] = {.lex_state = 0, .external_lex_state = 4},
  [1747] = {.lex_state = 0, .external_lex_state = 4},
  [1748] = {.lex_state = 0, .external_lex_state = 4},
  [1749] = {.lex_state = 4, .external_lex_state = 4},
  [1750] = {.lex_state = 4, .external_lex_state = 4},
  [1751] = {.lex_state = 4, .external_lex_state = 4},
  [1752] = {.lex_state = 34, .external_lex_state = 4},
  [1753] = {.lex_state = 42, .external_lex_state = 4},
  [1754] = {.lex_state = 4, .external_lex_state = 4},
  [1755] = {.lex_state = 4, .external_lex_state = 4},
  [1756] = {.lex_state = 4, .external_lex_state = 4},
  [1757] = {.lex_state = 4, .external_lex_state = 4},
  [1758] = {.lex_state = 4, .external_lex_state = 4},
  [1759] = {.lex_state = 4, .external_lex_state = 4},
  [1760] = {.lex_state = 8, .external_lex_state = 4},
  [1761] = {.lex_state = 4, .external_lex_state = 4},
  [1762] = {.lex_state = 4, .external_lex_state = 4},
  [1763] = {.lex_state = 4, .external_lex_state = 4},
  [1764] = {.lex_state = 4, .external_lex_state = 4},
  [1765] = {.lex_state = 4, .external_lex_state = 4},
  [1766] = {.lex_state = 4, .external_lex_state = 4},
  [1767] = {.lex_state = 4, .external_lex_state = 4},
  [1768] = {.lex_state = 4, .external_lex_state = 4},
  [1769] = {.lex_state = 40, .external_lex_state = 5},
  [1770] = {.lex_state = 44, .external_lex_state = 4},
  [1771] = {.lex_state = 4, .external_lex_state = 4},
  [1772] = {.lex_state = 8, .external_lex_state = 4},
  [1773] = {.lex_state = 4, .external_lex_state = 4},
  [1774] = {.lex_state = 4, .external_lex_state = 4},
  [1775] = {.lex_state = 4, .external_lex_state = 4},
  [1776] = {.lex_state = 47, .external_lex_state = 5},
  [1777] = {.lex_state = 8, .external_lex_state = 4},
  [1778] = {.lex_state = 4, .external_lex_state = 4},
  [1779] = {.lex_state = 4, .external_lex_state = 4},
  [1780] = {.lex_state = 4, .external_lex_state = 4},
  [1781] = {.lex_state = 4, .external_lex_state = 4},
  [1782] = {.lex_state = 4, .external_lex_state = 4},
  [1783] = {.lex_state = 4, .external_lex_state = 4},
  [1784] = {.lex_state = 4, .external_lex_state = 4},
  [1785] = {.lex_state = 8, .external_lex_state = 4},
  [1786] = {.lex_state = 47, .external_lex_state = 5},
  [1787] = {.lex_state = 8, .external_lex_state = 4},
  [1788] = {.lex_state = 4, .external_lex_state = 4},
  [1789] = {.lex_state = 4, .external_lex_state = 4},
  [1790] = {.lex_state = 4, .external_lex_state = 4},
  [1791] = {.lex_state = 4, .external_lex_state = 4},
  [1792] = {.lex_state = 0, .external_lex_state = 4},
  [1793] = {.lex_state = 4, .external_lex_state = 4},
  [1794] = {.lex_state = 4, .external_lex_state = 5},
  [1795] = {.lex_state = 46, .external_lex_state = 4},
  [1796] = {.lex_state = 0, .external_lex_state = 4},
  [1797] = {.lex_state = 44, .external_lex_state = 4},
  [1798] = {.lex_state = 48, .external_lex_state = 5},
  [1799] = {.lex_state = 49, .external_lex_state = 4},
  [1800] = {.lex_state = 41, .external_lex_state = 4},
  [1801] = {.lex_state = 41, .external_lex_state = 4},
  [1802] = {.lex_state = 41, .external_lex_state = 4},
  [1803] = {.lex_state = 0, .external_lex_state = 4},
  [1804] = {.lex_state = 41, .external_lex_state = 4},
  [1805] = {.lex_state = 9, .external_lex_state = 5},
  [1806] = {.lex_state = 41, .external_lex_state = 4},
  [1807] = {.lex_state = 46, .external_lex_state = 4},
  [1808] = {.lex_state = 41, .external_lex_state = 4},
  [1809] = {.lex_state = 0, .external_lex_state = 4},
  [1810] = {.lex_state = 41, .external_lex_state = 4},
  [1811] = {.lex_state = 44, .external_lex_state = 4},
  [1812] = {.lex_state = 44, .external_lex_state = 4},
  [1813] = {.lex_state = 41, .external_lex_state = 4},
  [1814] = {.lex_state = 0, .external_lex_state = 4},
  [1815] = {.lex_state = 0, .external_lex_state = 4},
  [1816] = {.lex_state = 41, .external_lex_state = 4},
  [1817] = {.lex_state = 44, .external_lex_state = 4},
  [1818] = {.lex_state = 44, .external_lex_state = 4},
  [1819] = {.lex_state = 41, .external_lex_state = 4},
  [1820] = {.lex_state = 41, .external_lex_state = 4},
  [1821] = {.lex_state = 46, .external_lex_state = 4},
  [1822] = {.lex_state = 4, .external_lex_state = 5},
  [1823] = {.lex_state = 41, .external_lex_state = 4},
  [1824] = {.lex_state = 41, .external_lex_state = 4},
  [1825] = {.lex_state = 49, .external_lex_state = 4},
  [1826] = {.lex_state = 44, .external_lex_state = 4},
  [1827] = {.lex_state = 46, .external_lex_state = 4},
  [1828] = {.lex_state = 41, .external_lex_state = 4},
  [1829] = {.lex_state = 8, .external_lex_state = 4},
  [1830] = {.lex_state = 48, .external_lex_state = 5},
  [1831] = {.lex_state = 44, .external_lex_state = 4},
  [1832] = {.lex_state = 0, .external_lex_state = 4},
  [1833] = {.lex_state = 8, .external_lex_state = 4},
  [1834] = {.lex_state = 41, .external_lex_state = 4},
  [1835] = {.lex_state = 4, .external_lex_state = 5},
  [1836] = {.lex_state = 41, .external_lex_state = 4},
  [1837] = {.lex_state = 41, .external_lex_state = 4},
  [1838] = {.lex_state = 4, .external_lex_state = 5},
  [1839] = {.lex_state = 4, .external_lex_state = 5},
  [1840] = {.lex_state = 50, .external_lex_state = 5},
  [1841] = {.lex_state = 9, .external_lex_state = 5},
  [1842] = {.lex_state = 41, .external_lex_state = 4},
  [1843] = {.lex_state = 44, .external_lex_state = 4},
  [1844] = {.lex_state = 44, .external_lex_state = 4},
  [1845] = {.lex_state = 9, .external_lex_state = 5},
  [1846] = {.lex_state = 41, .external_lex_state = 4},
  [1847] = {.lex_state = 44, .external_lex_state = 4},
  [1848] = {.lex_state = 41, .external_lex_state = 4},
  [1849] = {.lex_state = 44, .external_lex_state = 4},
  [1850] = {.lex_state = 44, .external_lex_state = 4},
  [1851] = {.lex_state = 42, .external_lex_state = 4},
  [1852] = {.lex_state = 44, .external_lex_state = 4},
  [1853] = {.lex_state = 50, .external_lex_state = 5},
  [1854] = {.lex_state = 42, .external_lex_state = 4},
  [1855] = {.lex_state = 41, .external_lex_state = 4},
  [1856] = {.lex_state = 44, .external_lex_state = 4},
  [1857] = {.lex_state = 41, .external_lex_state = 4},
  [1858] = {.lex_state = 4, .external_lex_state = 4},
  [1859] = {.lex_state = 42, .external_lex_state = 4},
  [1860] = {.lex_state = 4, .external_lex_state = 5},
  [1861] = {.lex_state = 9, .external_lex_state = 4},
  [1862] = {.lex_state = 42, .external_lex_state = 4},
  [1863] = {.lex_state = 41, .external_lex_state = 4},
  [1864] = {.lex_state = 41, .external_lex_state = 4},
  [1865] = {.lex_state = 4, .external_lex_state = 4},
  [1866] = {.lex_state = 44, .external_lex_state = 4},
  [1867] = {.lex_state = 4, .external_lex_state = 5},
  [1868] = {.lex_state = 9, .external_lex_state = 5},
  [1869] = {.lex_state = 4, .external_lex_state = 5},
  [1870] = {.lex_state = 41, .external_lex_state = 4},
  [1871] = {.lex_state = 41, .external_lex_state = 4},
  [1872] = {.lex_state = 41, .external_lex_state = 4},
  [1873] = {.lex_state = 41, .external_lex_state = 4},
  [1874] = {.lex_state = 41, .external_lex_state = 4},
  [1875] = {.lex_state = 41, .external_lex_state = 4},
  [1876] = {.lex_state = 41, .external_lex_state = 4},
  [1877] = {.lex_state = 41, .external_lex_state = 4},
  [1878] = {.lex_state = 41, .external_lex_state = 4},
  [1879] = {.lex_state = 41, .external_lex_state = 4},
  [1880] = {.lex_state = 41, .external_lex_state = 4},
  [1881] = {.lex_state = 41, .external_lex_state = 4},
  [1882] = {.lex_state = 41, .external_lex_state = 4},
  [1883] = {.lex_state = 41, .external_lex_state = 4},
  [1884] = {.lex_state = 41, .external_lex_state = 4},
  [1885] = {.lex_state = 41, .external_lex_state = 4},
  [1886] = {.lex_state = 41, .external_lex_state = 4},
  [1887] = {.lex_state = 41, .external_lex_state = 4},
  [1888] = {.lex_state = 41, .external_lex_state = 4},
  [1889] = {.lex_state = 41, .external_lex_state = 4},
  [1890] = {.lex_state = 41, .external_lex_state = 4},
  [1891] = {.lex_state = 41, .external_lex_state = 4},
  [1892] = {.lex_state = 41, .external_lex_state = 4},
  [1893] = {.lex_state = 41, .external_lex_state = 4},
  [1894] = {.lex_state = 41, .external_lex_state = 4},
  [1895] = {.lex_state = 41, .external_lex_state = 4},
  [1896] = {.lex_state = 41, .external_lex_state = 4},
  [1897] = {.lex_state = 41, .external_lex_state = 4},
  [1898] = {.lex_state = 41, .external_lex_state = 4},
  [1899] = {.lex_state = 41, .external_lex_state = 4},
  [1900] = {.lex_state = 41, .external_lex_state = 4},
  [1901] = {.lex_state = 41, .external_lex_state = 4},
  [1902] = {.lex_state = 41, .external_lex_state = 4},
  [1903] = {.lex_state = 41, .external_lex_state = 4},
  [1904] = {.lex_state = 41, .external_lex_state = 4},
  [1905] = {.lex_state = 41, .external_lex_state = 4},
  [1906] = {.lex_state = 41, .external_lex_state = 4},
  [1907] = {.lex_state = 41, .external_lex_state = 4},
  [1908] = {.lex_state = 41, .external_lex_state = 4},
  [1909] = {.lex_state = 41, .external_lex_state = 4},
  [1910] = {.lex_state = 41, .external_lex_state = 4},
  [1911] = {.lex_state = 41, .external_lex_state = 4},
  [1912] = {.lex_state = 41, .external_lex_state = 4},
  [1913] = {.lex_state = 41, .external_lex_state = 4},
  [1914] = {.lex_state = 41, .external_lex_state = 4},
  [1915] = {.lex_state = 41, .external_lex_state = 4},
  [1916] = {.lex_state = 41, .external_lex_state = 4},
  [1917] = {.lex_state = 41, .external_lex_state = 4},
  [1918] = {.lex_state = 41, .external_lex_state = 4},
  [1919] = {.lex_state = 41, .external_lex_state = 4},
  [1920] = {.lex_state = 41, .external_lex_state = 4},
  [1921] = {.lex_state = 41, .external_lex_state = 4},
  [1922] = {.lex_state = 41, .external_lex_state = 4},
  [1923] = {.lex_state = 41, .external_lex_state = 4},
  [1924] = {.lex_state = 41, .external_lex_state = 4},
  [1925] = {.lex_state = 41, .external_lex_state = 4},
  [1926] = {.lex_state = 41, .external_lex_state = 4},
  [1927] = {.lex_state = 41, .external_lex_state = 4},
  [1928] = {.lex_state = 41, .external_lex_state = 4},
  [1929] = {.lex_state = 41, .external_lex_state = 4},
  [1930] = {.lex_state = 41, .external_lex_state = 4},
  [1931] = {.lex_state = 41, .external_lex_state = 4},
  [1932] = {.lex_state = 41, .external_lex_state = 4},
  [1933] = {.lex_state = 0, .external_lex_state = 4},
  [1934] = {.lex_state = 41, .external_lex_state = 4},
  [1935] = {.lex_state = 41, .external_lex_state = 4},
  [1936] = {.lex_state = 41, .external_lex_state = 4},
  [1937] = {.lex_state = 41, .external_lex_state = 4},
  [1938] = {.lex_state = 41, .external_lex_state = 4},
  [1939] = {.lex_state = 41, .external_lex_state = 4},
  [1940] = {.lex_state = 41, .external_lex_state = 4},
  [1941] = {.lex_state = 41, .external_lex_state = 4},
  [1942] = {.lex_state = 4, .external_lex_state = 5},
  [1943] = {.lex_state = 41, .external_lex_state = 4},
  [1944] = {.lex_state = 0, .external_lex_state = 4},
  [1945] = {.lex_state = 0, .external_lex_state = 4},
  [1946] = {.lex_state = 4, .external_lex_state = 5},
  [1947] = {.lex_state = 4, .external_lex_state = 5},
  [1948] = {.lex_state = 4, .external_lex_state = 5},
  [1949] = {.lex_state = 4, .external_lex_state = 5},
  [1950] = {.lex_state = 4, .external_lex_state = 5},
  [1951] = {.lex_state = 4, .external_lex_state = 5},
  [1952] = {.lex_state = 4, .external_lex_state = 5},
  [1953] = {.lex_state = 4, .external_lex_state = 5},
  [1954] = {.lex_state = 4, .external_lex_state = 5},
  [1955] = {.lex_state = 4, .external_lex_state = 5},
  [1956] = {.lex_state = 4, .external_lex_state = 5},
  [1957] = {.lex_state = 4, .external_lex_state = 5},
  [1958] = {.lex_state = 4, .external_lex_state = 5},
  [1959] = {.lex_state = 4, .external_lex_state = 5},
  [1960] = {.lex_state = 4, .external_lex_state = 5},
  [1961] = {.lex_state = 4, .external_lex_state = 5},
  [1962] = {.lex_state = 4, .external_lex_state = 5},
  [1963] = {.lex_state = 4, .external_lex_state = 5},
  [1964] = {.lex_state = 41, .external_lex_state = 4},
  [1965] = {.lex_state = 4, .external_lex_state = 5},
  [1966] = {.lex_state = 7, .external_lex_state = 4},
  [1967] = {.lex_state = 4, .external_lex_state = 5},
  [1968] = {.lex_state = 0, .external_lex_state = 4},
  [1969] = {.lex_state = 0, .external_lex_state = 4},
  [1970] = {.lex_state = 4, .external_lex_state = 5},
  [1971] = {.lex_state = 4, .external_lex_state = 5},
  [1972] = {.lex_state = 41, .external_lex_state = 4},
  [1973] = {.lex_state = 4, .external_lex_state = 5},
  [1974] = {.lex_state = 9, .external_lex_state = 4},
  [1975] = {.lex_state = 9, .external_lex_state = 4},
  [1976] = {.lex_state = 4, .external_lex_state = 5},
  [1977] = {.lex_state = 4, .external_lex_state = 5},
  [1978] = {.lex_state = 4, .external_lex_state = 5},
  [1979] = {.lex_state = 7, .external_lex_state = 4},
  [1980] = {.lex_state = 41, .external_lex_state = 4},
  [1981] = {.lex_state = 41, .external_lex_state = 4},
  [1982] = {.lex_state = 9, .external_lex_state = 5},
  [1983] = {.lex_state = 9, .external_lex_state = 4},
  [1984] = {.lex_state = 41, .external_lex_state = 4},
  [1985] = {.lex_state = 4, .external_lex_state = 5},
  [1986] = {.lex_state = 41, .external_lex_state = 4},
  [1987] = {.lex_state = 9, .external_lex_state = 4},
  [1988] = {.lex_state = 41, .external_lex_state = 4},
  [1989] = {.lex_state = 4, .external_lex_state = 5},
  [1990] = {.lex_state = 4, .external_lex_state = 5},
  [1991] = {.lex_state = 4, .external_lex_state = 5},
  [1992] = {.lex_state = 4, .external_lex_state = 5},
  [1993] = {.lex_state = 41, .external_lex_state = 4},
  [1994] = {.lex_state = 41, .external_lex_state = 4},
  [1995] = {.lex_state = 4, .external_lex_state = 5},
  [1996] = {.lex_state = 4, .external_lex_state = 5},
  [1997] = {.lex_state = 4, .external_lex_state = 5},
  [1998] = {.lex_state = 41, .external_lex_state = 4},
  [1999] = {.lex_state = 4, .external_lex_state = 5},
  [2000] = {.lex_state = 41, .external_lex_state = 4},
  [2001] = {.lex_state = 4, .external_lex_state = 5},
  [2002] = {.lex_state = 4, .external_lex_state = 5},
  [2003] = {.lex_state = 4, .external_lex_state = 5},
  [2004] = {.lex_state = 4, .external_lex_state = 5},
  [2005] = {.lex_state = 41, .external_lex_state = 4},
  [2006] = {.lex_state = 4, .external_lex_state = 5},
  [2007] = {.lex_state = 9, .external_lex_state = 5},
  [2008] = {.lex_state = 41, .external_lex_state = 4},
  [2009] = {.lex_state = 4, .external_lex_state = 5},
  [2010] = {.lex_state = 4, .external_lex_state = 5},
  [2011] = {.lex_state = 41, .external_lex_state = 4},
  [2012] = {.lex_state = 4, .external_lex_state = 5},
  [2013] = {.lex_state = 4, .external_lex_state = 5},
  [2014] = {.lex_state = 0, .external_lex_state = 4},
  [2015] = {.lex_state = 41, .external_lex_state = 4},
  [2016] = {.lex_state = 26, .external_lex_state = 4},
  [2017] = {.lex_state = 9, .external_lex_state = 4},
  [2018] = {.lex_state = 26, .external_lex_state = 4},
  [2019] = {.lex_state = 9, .external_lex_state = 5},
  [2020] = {.lex_state = 26, .external_lex_state = 4},
  [2021] = {.lex_state = 41, .external_lex_state = 4},
  [2022] = {.lex_state = 9, .external_lex_state = 5},
  [2023] = {.lex_state = 9, .external_lex_state = 5},
  [2024] = {.lex_state = 9, .external_lex_state = 5},
  [2025] = {.lex_state = 9, .external_lex_state = 5},
  [2026] = {.lex_state = 48, .external_lex_state = 4},
  [2027] = {.lex_state = 48, .external_lex_state = 4},
  [2028] = {.lex_state = 9, .external_lex_state = 4},
  [2029] = {.lex_state = 9, .external_lex_state = 5},
  [2030] = {.lex_state = 41, .external_lex_state = 4},
  [2031] = {.lex_state = 9, .external_lex_state = 5},
  [2032] = {.lex_state = 9, .external_lex_state = 5},
  [2033] = {.lex_state = 9, .external_lex_state = 5},
  [2034] = {.lex_state = 9, .external_lex_state = 4},
  [2035] = {.lex_state = 41, .external_lex_state = 4},
  [2036] = {.lex_state = 9, .external_lex_state = 4},
  [2037] = {.lex_state = 9, .external_lex_state = 5},
  [2038] = {.lex_state = 7, .external_lex_state = 4},
  [2039] = {.lex_state = 41, .external_lex_state = 4},
  [2040] = {.lex_state = 9, .external_lex_state = 5},
  [2041] = {.lex_state = 9, .external_lex_state = 4},
  [2042] = {.lex_state = 41, .external_lex_state = 4},
  [2043] = {.lex_state = 9, .external_lex_state = 5},
  [2044] = {.lex_state = 9, .external_lex_state = 5},
  [2045] = {.lex_state = 26, .external_lex_state = 4},
  [2046] = {.lex_state = 9, .external_lex_state = 5},
  [2047] = {.lex_state = 9, .external_lex_state = 5},
  [2048] = {.lex_state = 9, .external_lex_state = 4},
  [2049] = {.lex_state = 9, .external_lex_state = 4},
  [2050] = {.lex_state = 9, .external_lex_state = 4},
  [2051] = {.lex_state = 9, .external_lex_state = 4},
  [2052] = {.lex_state = 9, .external_lex_state = 4},
  [2053] = {.lex_state = 9, .external_lex_state = 4},
  [2054] = {.lex_state = 8, .external_lex_state = 4},
  [2055] = {.lex_state = 8, .external_lex_state = 4},
  [2056] = {.lex_state = 9, .external_lex_state = 5},
  [2057] = {.lex_state = 9, .external_lex_state = 5},
  [2058] = {.lex_state = 9, .external_lex_state = 4},
  [2059] = {.lex_state = 9, .external_lex_state = 4},
  [2060] = {.lex_state = 8, .external_lex_state = 4},
  [2061] = {.lex_state = 9, .external_lex_state = 4},
  [2062] = {.lex_state = 9, .external_lex_state = 4},
  [2063] = {.lex_state = 9, .external_lex_state = 4},
  [2064] = {.lex_state = 9, .external_lex_state = 4},
  [2065] = {.lex_state = 9, .external_lex_state = 4},
  [2066] = {.lex_state = 9, .external_lex_state = 4},
  [2067] = {.lex_state = 9, .external_lex_state = 4},
  [2068] = {.lex_state = 9, .external_lex_state = 4},
  [2069] = {.lex_state = 9, .external_lex_state = 4},
  [2070] = {.lex_state = 9, .external_lex_state = 4},
  [2071] = {.lex_state = 9, .external_lex_state = 4},
  [2072] = {.lex_state = 0, .external_lex_state = 4},
  [2073] = {.lex_state = 9, .external_lex_state = 4},
  [2074] = {.lex_state = 8, .external_lex_state = 4},
  [2075] = {.lex_state = 8, .external_lex_state = 4},
  [2076] = {.lex_state = 4, .external_lex_state = 5},
  [2077] = {.lex_state = 26, .external_lex_state = 4},
  [2078] = {.lex_state = 9, .external_lex_state = 5},
  [2079] = {.lex_state = 9, .external_lex_state = 5},
  [2080] = {.lex_state = 9, .external_lex_state = 5},
  [2081] = {.lex_state = 9, .external_lex_state = 4},
  [2082] = {.lex_state = 9, .external_lex_state = 4},
  [2083] = {.lex_state = 9, .external_lex_state = 4},
  [2084] = {.lex_state = 9, .external_lex_state = 4},
  [2085] = {.lex_state = 8, .external_lex_state = 4},
  [2086] = {.lex_state = 9, .external_lex_state = 4},
  [2087] = {.lex_state = 9, .external_lex_state = 4},
  [2088] = {.lex_state = 9, .external_lex_state = 4},
  [2089] = {.lex_state = 9, .external_lex_state = 4},
  [2090] = {.lex_state = 9, .external_lex_state = 5},
  [2091] = {.lex_state = 9, .external_lex_state = 4},
  [2092] = {.lex_state = 9, .external_lex_state = 4},
  [2093] = {.lex_state = 9, .external_lex_state = 4},
  [2094] = {.lex_state = 9, .external_lex_state = 5},
  [2095] = {.lex_state = 9, .external_lex_state = 4},
  [2096] = {.lex_state = 9, .external_lex_state = 5},
  [2097] = {.lex_state = 8, .external_lex_state = 4},
  [2098] = {.lex_state = 9, .external_lex_state = 4},
  [2099] = {.lex_state = 9, .external_lex_state = 4},
  [2100] = {.lex_state = 9, .external_lex_state = 5},
  [2101] = {.lex_state = 9, .external_lex_state = 5},
  [2102] = {.lex_state = 9, .external_lex_state = 5},
  [2103] = {.lex_state = 9, .external_lex_state = 4},
  [2104] = {.lex_state = 9, .external_lex_state = 5},
  [2105] = {.lex_state = 9, .external_lex_state = 5},
  [2106] = {.lex_state = 9, .external_lex_state = 4},
  [2107] = {.lex_state = 9, .external_lex_state = 5},
  [2108] = {.lex_state = 8, .external_lex_state = 4},
  [2109] = {.lex_state = 9, .external_lex_state = 5},
  [2110] = {.lex_state = 9, .external_lex_state = 5},
  [2111] = {.lex_state = 9, .external_lex_state = 5},
  [2112] = {.lex_state = 9, .external_lex_state = 5},
  [2113] = {.lex_state = 9, .external_lex_state = 5},
  [2114] = {.lex_state = 9, .external_lex_state = 5},
  [2115] = {.lex_state = 9, .external_lex_state = 4},
  [2116] = {.lex_state = 9, .external_lex_state = 4},
  [2117] = {.lex_state = 9, .external_lex_state = 5},
  [2118] = {.lex_state = 9, .external_lex_state = 4},
  [2119] = {.lex_state = 9, .external_lex_state = 5},
  [2120] = {.lex_state = 8, .external_lex_state = 4},
  [2121] = {.lex_state = 0, .external_lex_state = 4},
  [2122] = {.lex_state = 9, .external_lex_state = 5},
  [2123] = {.lex_state = 9, .external_lex_state = 5},
  [2124] = {.lex_state = 9, .external_lex_state = 5},
  [2125] = {.lex_state = 9, .external_lex_state = 5},
  [2126] = {.lex_state = 9, .external_lex_state = 4},
  [2127] = {.lex_state = 9, .external_lex_state = 4},
  [2128] = {.lex_state = 9, .external_lex_state = 5},
  [2129] = {.lex_state = 9, .external_lex_state = 4},
  [2130] = {.lex_state = 8, .external_lex_state = 4},
  [2131] = {.lex_state = 9, .external_lex_state = 4},
  [2132] = {.lex_state = 9, .external_lex_state = 5},
  [2133] = {.lex_state = 0, .external_lex_state = 4},
  [2134] = {.lex_state = 8, .external_lex_state = 4},
  [2135] = {.lex_state = 9, .external_lex_state = 5},
  [2136] = {.lex_state = 9, .external_lex_state = 5},
  [2137] = {.lex_state = 9, .external_lex_state = 5},
  [2138] = {.lex_state = 9, .external_lex_state = 5},
  [2139] = {.lex_state = 9, .external_lex_state = 4},
  [2140] = {.lex_state = 8, .external_lex_state = 4},
  [2141] = {.lex_state = 4, .external_lex_state = 5},
  [2142] = {.lex_state = 9, .external_lex_state = 4},
  [2143] = {.lex_state = 9, .external_lex_state = 4},
  [2144] = {.lex_state = 9, .external_lex_state = 4},
  [2145] = {.lex_state = 9, .external_lex_state = 4},
  [2146] = {.lex_state = 4, .external_lex_state = 5},
  [2147] = {.lex_state = 9, .external_lex_state = 4},
  [2148] = {.lex_state = 14, .external_lex_state = 4},
  [2149] = {.lex_state = 9, .external_lex_state = 5},
  [2150] = {.lex_state = 9, .external_lex_state = 4},
  [2151] = {.lex_state = 8, .external_lex_state = 7},
  [2152] = {.lex_state = 24, .external_lex_state = 6},
  [2153] = {.lex_state = 4, .external_lex_state = 5},
  [2154] = {.lex_state = 9, .external_lex_state = 4},
  [2155] = {.lex_state = 9, .external_lex_state = 5},
  [2156] = {.lex_state = 9, .external_lex_state = 5},
  [2157] = {.lex_state = 4, .external_lex_state = 5},
  [2158] = {.lex_state = 9, .external_lex_state = 5},
  [2159] = {.lex_state = 9, .external_lex_state = 5},
  [2160] = {.lex_state = 4, .external_lex_state = 5},
  [2161] = {.lex_state = 9, .external_lex_state = 5},
  [2162] = {.lex_state = 35, .external_lex_state = 8},
  [2163] = {.lex_state = 9, .external_lex_state = 4},
  [2164] = {.lex_state = 9, .external_lex_state = 5},
  [2165] = {.lex_state = 9, .external_lex_state = 5},
  [2166] = {.lex_state = 9, .external_lex_state = 5},
  [2167] = {.lex_state = 9, .external_lex_state = 4},
  [2168] = {.lex_state = 9, .external_lex_state = 4},
  [2169] = {.lex_state = 9, .external_lex_state = 4},
  [2170] = {.lex_state = 41, .external_lex_state = 4},
  [2171] = {.lex_state = 9, .external_lex_state = 4},
  [2172] = {.lex_state = 9, .external_lex_state = 4},
  [2173] = {.lex_state = 35, .external_lex_state = 8},
  [2174] = {.lex_state = 9, .external_lex_state = 4},
  [2175] = {.lex_state = 9, .external_lex_state = 5},
  [2176] = {.lex_state = 9, .external_lex_state = 4},
  [2177] = {.lex_state = 9, .external_lex_state = 4},
  [2178] = {.lex_state = 9, .external_lex_state = 4},
  [2179] = {.lex_state = 9, .external_lex_state = 4},
  [2180] = {.lex_state = 9, .external_lex_state = 4},
  [2181] = {.lex_state = 9, .external_lex_state = 5},
  [2182] = {.lex_state = 35, .external_lex_state = 8},
  [2183] = {.lex_state = 13, .external_lex_state = 4},
  [2184] = {.lex_state = 0, .external_lex_state = 5},
  [2185] = {.lex_state = 9, .external_lex_state = 5},
  [2186] = {.lex_state = 35, .external_lex_state = 8},
  [2187] = {.lex_state = 9, .external_lex_state = 5},
  [2188] = {.lex_state = 9, .external_lex_state = 4},
  [2189] = {.lex_state = 9, .external_lex_state = 5},
  [2190] = {.lex_state = 9, .external_lex_state = 5},
  [2191] = {.lex_state = 9, .external_lex_state = 5},
  [2192] = {.lex_state = 57, .external_lex_state = 4},
  [2193] = {.lex_state = 41, .external_lex_state = 4},
  [2194] = {.lex_state = 57, .external_lex_state = 4},
  [2195] = {.lex_state = 9, .external_lex_state = 5},
  [2196] = {.lex_state = 9, .external_lex_state = 5},
  [2197] = {.lex_state = 35, .external_lex_state = 8},
  [2198] = {.lex_state = 9, .external_lex_state = 4},
  [2199] = {.lex_state = 9, .external_lex_state = 4},
  [2200] = {.lex_state = 9, .external_lex_state = 5},
  [2201] = {.lex_state = 9, .external_lex_state = 5},
  [2202] = {.lex_state = 9, .external_lex_state = 5},
  [2203] = {.lex_state = 9, .external_lex_state = 5},
  [2204] = {.lex_state = 9, .external_lex_state = 5},
  [2205] = {.lex_state = 9, .external_lex_state = 5},
  [2206] = {.lex_state = 9, .external_lex_state = 5},
  [2207] = {.lex_state = 35, .external_lex_state = 8},
  [2208] = {.lex_state = 9, .external_lex_state = 4},
  [2209] = {.lex_state = 9, .external_lex_state = 4},
  [2210] = {.lex_state = 35, .external_lex_state = 8},
  [2211] = {.lex_state = 9, .external_lex_state = 4},
  [2212] = {.lex_state = 9, .external_lex_state = 4},
  [2213] = {.lex_state = 9, .external_lex_state = 5},
  [2214] = {.lex_state = 9, .external_lex_state = 4},
  [2215] = {.lex_state = 9, .external_lex_state = 5},
  [2216] = {.lex_state = 9, .external_lex_state = 5},
  [2217] = {.lex_state = 9, .external_lex_state = 5},
  [2218] = {.lex_state = 0, .external_lex_state = 4},
  [2219] = {.lex_state = 41, .external_lex_state = 4},
  [2220] = {.lex_state = 9, .external_lex_state = 4},
  [2221] = {.lex_state = 9, .external_lex_state = 4},
  [2222] = {.lex_state = 0, .external_lex_state = 4},
  [2223] = {.lex_state = 0, .external_lex_state = 5},
  [2224] = {.lex_state = 9, .external_lex_state = 4},
  [2225] = {.lex_state = 0, .external_lex_state = 5},
  [2226] = {.lex_state = 9, .external_lex_state = 4},
  [2227] = {.lex_state = 0, .external_lex_state = 5},
  [2228] = {.lex_state = 0, .external_lex_state = 5},
  [2229] = {.lex_state = 9, .external_lex_state = 4},
  [2230] = {.lex_state = 0, .external_lex_state = 5},
  [2231] = {.lex_state = 0, .external_lex_state = 5},
  [2232] = {.lex_state = 0, .external_lex_state = 5},
  [2233] = {.lex_state = 0, .external_lex_state = 5},
  [2234] = {.lex_state = 0, .external_lex_state = 5},
  [2235] = {.lex_state = 0, .external_lex_state = 5},
  [2236] = {.lex_state = 9, .external_lex_state = 4},
  [2237] = {.lex_state = 8, .external_lex_state = 4},
  [2238] = {.lex_state = 8, .external_lex_state = 4},
  [2239] = {.lex_state = 4, .external_lex_state = 4},
  [2240] = {.lex_state = 0, .external_lex_state = 5},
  [2241] = {.lex_state = 8, .external_lex_state = 4},
  [2242] = {.lex_state = 0, .external_lex_state = 5},
  [2243] = {.lex_state = 0, .external_lex_state = 5},
  [2244] = {.lex_state = 0, .external_lex_state = 5},
  [2245] = {.lex_state = 9, .external_lex_state = 4},
  [2246] = {.lex_state = 45, .external_lex_state = 4},
  [2247] = {.lex_state = 0, .external_lex_state = 5},
  [2248] = {.lex_state = 9, .external_lex_state = 4},
  [2249] = {.lex_state = 0, .external_lex_state = 5},
  [2250] = {.lex_state = 0, .external_lex_state = 5},
  [2251] = {.lex_state = 9, .external_lex_state = 4},
  [2252] = {.lex_state = 0, .external_lex_state = 5},
  [2253] = {.lex_state = 0, .external_lex_state = 5},
  [2254] = {.lex_state = 0, .external_lex_state = 5},
  [2255] = {.lex_state = 9, .external_lex_state = 4},
  [2256] = {.lex_state = 9, .external_lex_state = 4},
  [2257] = {.lex_state = 0, .external_lex_state = 5},
  [2258] = {.lex_state = 8, .external_lex_state = 4},
  [2259] = {.lex_state = 0, .external_lex_state = 5},
  [2260] = {.lex_state = 0, .external_lex_state = 5},
  [2261] = {.lex_state = 0, .external_lex_state = 5},
  [2262] = {.lex_state = 0, .external_lex_state = 4},
  [2263] = {.lex_state = 9, .external_lex_state = 4},
  [2264] = {.lex_state = 0, .external_lex_state = 5},
  [2265] = {.lex_state = 0, .external_lex_state = 5},
  [2266] = {.lex_state = 45, .external_lex_state = 4},
  [2267] = {.lex_state = 0, .external_lex_state = 5},
  [2268] = {.lex_state = 8, .external_lex_state = 4},
  [2269] = {.lex_state = 0, .external_lex_state = 5},
  [2270] = {.lex_state = 0, .external_lex_state = 4},
  [2271] = {.lex_state = 0, .external_lex_state = 5},
  [2272] = {.lex_state = 0, .external_lex_state = 5},
  [2273] = {.lex_state = 8, .external_lex_state = 4},
  [2274] = {.lex_state = 0, .external_lex_state = 5},
  [2275] = {.lex_state = 8, .external_lex_state = 4},
  [2276] = {.lex_state = 8, .external_lex_state = 4},
  [2277] = {.lex_state = 0, .external_lex_state = 5},
  [2278] = {.lex_state = 0, .external_lex_state = 5},
  [2279] = {.lex_state = 9, .external_lex_state = 5},
  [2280] = {.lex_state = 0, .external_lex_state = 5},
  [2281] = {.lex_state = 0, .external_lex_state = 5},
  [2282] = {.lex_state = 41, .external_lex_state = 4},
  [2283] = {.lex_state = 41, .external_lex_state = 4},
  [2284] = {.lex_state = 8, .external_lex_state = 4},
  [2285] = {.lex_state = 8, .external_lex_state = 4},
  [2286] = {.lex_state = 8, .external_lex_state = 4},
  [2287] = {.lex_state = 35, .external_lex_state = 8},
  [2288] = {.lex_state = 0, .external_lex_state = 5},
  [2289] = {.lex_state = 14, .external_lex_state = 4},
  [2290] = {.lex_state = 9, .external_lex_state = 5},
  [2291] = {.lex_state = 0, .external_lex_state = 5},
  [2292] = {.lex_state = 41, .external_lex_state = 4},
  [2293] = {.lex_state = 0, .external_lex_state = 5},
  [2294] = {.lex_state = 35, .external_lex_state = 8},
  [2295] = {.lex_state = 41, .external_lex_state = 4},
  [2296] = {.lex_state = 14, .external_lex_state = 4},
  [2297] = {.lex_state = 41, .external_lex_state = 4},
  [2298] = {.lex_state = 8, .external_lex_state = 4},
  [2299] = {.lex_state = 8, .external_lex_state = 4},
  [2300] = {.lex_state = 41, .external_lex_state = 4},
  [2301] = {.lex_state = 0, .external_lex_state = 5},
  [2302] = {.lex_state = 0, .external_lex_state = 5},
  [2303] = {.lex_state = 0, .external_lex_state = 5},
  [2304] = {.lex_state = 0, .external_lex_state = 5},
  [2305] = {.lex_state = 0, .external_lex_state = 5},
  [2306] = {.lex_state = 0, .external_lex_state = 5},
  [2307] = {.lex_state = 8, .external_lex_state = 4},
  [2308] = {.lex_state = 0, .external_lex_state = 5},
  [2309] = {.lex_state = 4, .external_lex_state = 4},
  [2310] = {.lex_state = 0, .external_lex_state = 5},
  [2311] = {.lex_state = 0, .external_lex_state = 5},
  [2312] = {.lex_state = 0, .external_lex_state = 5},
  [2313] = {.lex_state = 4, .external_lex_state = 6},
  [2314] = {.lex_state = 0, .external_lex_state = 5},
  [2315] = {.lex_state = 0, .external_lex_state = 5},
  [2316] = {.lex_state = 9, .external_lex_state = 4},
  [2317] = {.lex_state = 9, .external_lex_state = 4},
  [2318] = {.lex_state = 9, .external_lex_state = 4},
  [2319] = {.lex_state = 9, .external_lex_state = 4},
  [2320] = {.lex_state = 41, .external_lex_state = 4},
  [2321] = {.lex_state = 4, .external_lex_state = 4},
  [2322] = {.lex_state = 14, .external_lex_state = 4},
  [2323] = {.lex_state = 0, .external_lex_state = 5},
  [2324] = {.lex_state = 41, .external_lex_state = 4},
  [2325] = {.lex_state = 9, .external_lex_state = 4},
  [2326] = {.lex_state = 8, .external_lex_state = 5},
  [2327] = {.lex_state = 0, .external_lex_state = 5},
  [2328] = {.lex_state = 9, .external_lex_state = 4},
  [2329] = {.lex_state = 9, .external_lex_state = 4},
  [2330] = {.lex_state = 0, .external_lex_state = 5},
  [2331] = {.lex_state = 41, .external_lex_state = 4},
  [2332] = {.lex_state = 4, .external_lex_state = 4},
  [2333] = {.lex_state = 4, .external_lex_state = 4},
  [2334] = {.lex_state = 41, .external_lex_state = 4},
  [2335] = {.lex_state = 8, .external_lex_state = 4},
  [2336] = {.lex_state = 0, .external_lex_state = 5},
  [2337] = {.lex_state = 8, .external_lex_state = 4},
  [2338] = {.lex_state = 4, .external_lex_state = 6},
  [2339] = {.lex_state = 8, .external_lex_state = 4},
  [2340] = {.lex_state = 0, .external_lex_state = 5},
  [2341] = {.lex_state = 9, .external_lex_state = 4},
  [2342] = {.lex_state = 8, .external_lex_state = 4},
  [2343] = {.lex_state = 0, .external_lex_state = 5},
  [2344] = {.lex_state = 9, .external_lex_state = 4},
  [2345] = {.lex_state = 0, .external_lex_state = 5},
  [2346] = {.lex_state = 0, .external_lex_state = 5},
  [2347] = {.lex_state = 0, .external_lex_state = 5},
  [2348] = {.lex_state = 0, .external_lex_state = 5},
  [2349] = {.lex_state = 9, .external_lex_state = 4},
  [2350] = {.lex_state = 9, .external_lex_state = 4},
  [2351] = {.lex_state = 9, .external_lex_state = 4},
  [2352] = {.lex_state = 41, .external_lex_state = 4},
  [2353] = {.lex_state = 9, .external_lex_state = 4},
  [2354] = {.lex_state = 41, .external_lex_state = 4},
  [2355] = {.lex_state = 41, .external_lex_state = 4},
  [2356] = {.lex_state = 0, .external_lex_state = 5},
  [2357] = {.lex_state = 0, .external_lex_state = 5},
  [2358] = {.lex_state = 0, .external_lex_state = 5},
  [2359] = {.lex_state = 0, .external_lex_state = 5},
  [2360] = {.lex_state = 0, .external_lex_state = 5},
  [2361] = {.lex_state = 0, .external_lex_state = 5},
  [2362] = {.lex_state = 0, .external_lex_state = 5},
  [2363] = {.lex_state = 0, .external_lex_state = 5},
  [2364] = {.lex_state = 0, .external_lex_state = 5},
  [2365] = {.lex_state = 0, .external_lex_state = 5},
  [2366] = {.lex_state = 8, .external_lex_state = 4},
  [2367] = {.lex_state = 9, .external_lex_state = 4},
  [2368] = {.lex_state = 0, .external_lex_state = 5},
  [2369] = {.lex_state = 0, .external_lex_state = 5},
  [2370] = {.lex_state = 0, .external_lex_state = 5},
  [2371] = {.lex_state = 0, .external_lex_state = 5},
  [2372] = {.lex_state = 0, .external_lex_state = 5},
  [2373] = {.lex_state = 0, .external_lex_state = 5},
  [2374] = {.lex_state = 8, .external_lex_state = 4},
  [2375] = {.lex_state = 0, .external_lex_state = 5},
  [2376] = {.lex_state = 0, .external_lex_state = 6},
  [2377] = {.lex_state = 9, .external_lex_state = 4},
  [2378] = {.lex_state = 0, .external_lex_state = 5},
  [2379] = {.lex_state = 0, .external_lex_state = 5},
  [2380] = {.lex_state = 0, .external_lex_state = 5},
  [2381] = {.lex_state = 0, .external_lex_state = 5},
  [2382] = {.lex_state = 35, .external_lex_state = 8},
  [2383] = {.lex_state = 9, .external_lex_state = 4},
  [2384] = {.lex_state = 0, .external_lex_state = 5},
  [2385] = {.lex_state = 0, .external_lex_state = 5},
  [2386] = {.lex_state = 7, .external_lex_state = 4},
  [2387] = {.lex_state = 0, .external_lex_state = 6},
  [2388] = {.lex_state = 0, .external_lex_state = 5},
  [2389] = {.lex_state = 0, .external_lex_state = 5},
  [2390] = {.lex_state = 0, .external_lex_state = 5},
  [2391] = {.lex_state = 0, .external_lex_state = 5},
  [2392] = {.lex_state = 0, .external_lex_state = 5},
  [2393] = {.lex_state = 0, .external_lex_state = 5},
  [2394] = {.lex_state = 11, .external_lex_state = 4},
  [2395] = {.lex_state = 9, .external_lex_state = 4},
  [2396] = {.lex_state = 0, .external_lex_state = 5},
  [2397] = {.lex_state = 0, .external_lex_state = 5},
  [2398] = {.lex_state = 0, .external_lex_state = 5},
  [2399] = {.lex_state = 0, .external_lex_state = 5},
  [2400] = {.lex_state = 14, .external_lex_state = 4},
  [2401] = {.lex_state = 9, .external_lex_state = 4},
  [2402] = {.lex_state = 0, .external_lex_state = 6},
  [2403] = {.lex_state = 0, .external_lex_state = 6},
  [2404] = {.lex_state = 0, .external_lex_state = 5},
  [2405] = {.lex_state = 0, .external_lex_state = 5},
  [2406] = {.lex_state = 14, .external_lex_state = 4},
  [2407] = {.lex_state = 70, .external_lex_state = 4},
  [2408] = {.lex_state = 0, .external_lex_state = 5},
  [2409] = {.lex_state = 14, .external_lex_state = 4},
  [2410] = {.lex_state = 0, .external_lex_state = 5},
  [2411] = {.lex_state = 0, .external_lex_state = 5},
  [2412] = {.lex_state = 14, .external_lex_state = 4},
  [2413] = {.lex_state = 0, .external_lex_state = 5},
  [2414] = {.lex_state = 0, .external_lex_state = 5},
  [2415] = {.lex_state = 0, .external_lex_state = 5},
  [2416] = {.lex_state = 0, .external_lex_state = 6},
  [2417] = {.lex_state = 0, .external_lex_state = 6},
  [2418] = {.lex_state = 35, .external_lex_state = 8},
  [2419] = {.lex_state = 4, .external_lex_state = 4},
  [2420] = {.lex_state = 70, .external_lex_state = 4},
  [2421] = {.lex_state = 0, .external_lex_state = 5},
  [2422] = {.lex_state = 9, .external_lex_state = 4},
  [2423] = {.lex_state = 35, .external_lex_state = 8},
  [2424] = {.lex_state = 0, .external_lex_state = 6},
  [2425] = {.lex_state = 8, .external_lex_state = 4},
  [2426] = {.lex_state = 0, .external_lex_state = 5},
  [2427] = {.lex_state = 0, .external_lex_state = 5},
  [2428] = {.lex_state = 0, .external_lex_state = 5},
  [2429] = {.lex_state = 14, .external_lex_state = 4},
  [2430] = {.lex_state = 14, .external_lex_state = 4},
  [2431] = {.lex_state = 0, .external_lex_state = 5},
  [2432] = {.lex_state = 35, .external_lex_state = 8},
  [2433] = {.lex_state = 11, .external_lex_state = 4},
  [2434] = {.lex_state = 35, .external_lex_state = 8},
  [2435] = {.lex_state = 0, .external_lex_state = 5},
  [2436] = {.lex_state = 14, .external_lex_state = 4},
  [2437] = {.lex_state = 14, .external_lex_state = 4},
  [2438] = {.lex_state = 0, .external_lex_state = 5},
  [2439] = {.lex_state = 9, .external_lex_state = 4},
  [2440] = {.lex_state = 14, .external_lex_state = 4},
  [2441] = {.lex_state = 7, .external_lex_state = 4},
  [2442] = {.lex_state = 14, .external_lex_state = 4},
  [2443] = {.lex_state = 0, .external_lex_state = 5},
  [2444] = {.lex_state = 9, .external_lex_state = 4},
  [2445] = {.lex_state = 9, .external_lex_state = 4},
  [2446] = {.lex_state = 9, .external_lex_state = 4},
  [2447] = {.lex_state = 0, .external_lex_state = 5},
  [2448] = {.lex_state = 0, .external_lex_state = 6},
  [2449] = {.lex_state = 7, .external_lex_state = 4},
  [2450] = {.lex_state = 9, .external_lex_state = 4},
  [2451] = {.lex_state = 4, .external_lex_state = 4},
  [2452] = {.lex_state = 4, .external_lex_state = 4},
  [2453] = {.lex_state = 4, .external_lex_state = 4},
  [2454] = {.lex_state = 14, .external_lex_state = 4},
  [2455] = {.lex_state = 11, .external_lex_state = 4},
  [2456] = {.lex_state = 8, .external_lex_state = 4},
  [2457] = {.lex_state = 51, .external_lex_state = 4},
  [2458] = {.lex_state = 8, .external_lex_state = 4},
  [2459] = {.lex_state = 0, .external_lex_state = 5},
  [2460] = {.lex_state = 4, .external_lex_state = 4},
  [2461] = {.lex_state = 0, .external_lex_state = 4},
  [2462] = {.lex_state = 11, .external_lex_state = 4},
  [2463] = {.lex_state = 11, .external_lex_state = 4},
  [2464] = {.lex_state = 8, .external_lex_state = 4},
  [2465] = {.lex_state = 8, .external_lex_state = 4},
  [2466] = {.lex_state = 0, .external_lex_state = 5},
  [2467] = {.lex_state = 0, .external_lex_state = 5},
  [2468] = {.lex_state = 0, .external_lex_state = 5},
  [2469] = {.lex_state = 8, .external_lex_state = 4},
  [2470] = {.lex_state = 8, .external_lex_state = 4},
  [2471] = {.lex_state = 8, .external_lex_state = 4},
  [2472] = {.lex_state = 8, .external_lex_state = 4},
  [2473] = {.lex_state = 4, .external_lex_state = 4},
  [2474] = {.lex_state = 4, .external_lex_state = 4},
  [2475] = {.lex_state = 4, .external_lex_state = 4},
  [2476] = {.lex_state = 4, .external_lex_state = 4},
  [2477] = {.lex_state = 7, .external_lex_state = 4},
  [2478] = {.lex_state = 8, .external_lex_state = 4},
  [2479] = {.lex_state = 0, .external_lex_state = 5},
  [2480] = {.lex_state = 0, .external_lex_state = 5},
  [2481] = {.lex_state = 9, .external_lex_state = 4},
  [2482] = {.lex_state = 0, .external_lex_state = 5},
  [2483] = {.lex_state = 8, .external_lex_state = 4},
  [2484] = {.lex_state = 0, .external_lex_state = 6},
  [2485] = {.lex_state = 9, .external_lex_state = 4},
  [2486] = {.lex_state = 8, .external_lex_state = 4},
  [2487] = {.lex_state = 9, .external_lex_state = 4},
  [2488] = {.lex_state = 9, .external_lex_state = 4},
  [2489] = {.lex_state = 4, .external_lex_state = 4},
  [2490] = {.lex_state = 9, .external_lex_state = 4},
  [2491] = {.lex_state = 4, .external_lex_state = 4},
  [2492] = {.lex_state = 51, .external_lex_state = 4},
  [2493] = {.lex_state = 8, .external_lex_state = 4},
  [2494] = {.lex_state = 4, .external_lex_state = 4},
  [2495] = {.lex_state = 4, .external_lex_state = 4},
  [2496] = {.lex_state = 0, .external_lex_state = 4},
  [2497] = {.lex_state = 11, .external_lex_state = 4},
  [2498] = {.lex_state = 0, .external_lex_state = 5},
  [2499] = {.lex_state = 11, .external_lex_state = 4},
  [2500] = {.lex_state = 0, .external_lex_state = 4},
  [2501] = {.lex_state = 14, .external_lex_state = 4},
  [2502] = {.lex_state = 14, .external_lex_state = 4},
  [2503] = {.lex_state = 0, .external_lex_state = 5},
  [2504] = {.lex_state = 8, .external_lex_state = 4},
  [2505] = {.lex_state = 14, .external_lex_state = 4},
  [2506] = {.lex_state = 8, .external_lex_state = 4},
  [2507] = {.lex_state = 8, .external_lex_state = 4},
  [2508] = {.lex_state = 14, .external_lex_state = 4},
  [2509] = {.lex_state = 0, .external_lex_state = 4},
  [2510] = {.lex_state = 9, .external_lex_state = 4},
  [2511] = {.lex_state = 9, .external_lex_state = 4},
  [2512] = {.lex_state = 0, .external_lex_state = 4},
  [2513] = {.lex_state = 8, .external_lex_state = 4},
  [2514] = {.lex_state = 11, .external_lex_state = 4},
  [2515] = {.lex_state = 14, .external_lex_state = 4},
  [2516] = {.lex_state = 8, .external_lex_state = 4},
  [2517] = {.lex_state = 8, .external_lex_state = 4},
  [2518] = {.lex_state = 0, .external_lex_state = 4},
  [2519] = {.lex_state = 51, .external_lex_state = 4},
  [2520] = {.lex_state = 8, .external_lex_state = 4},
  [2521] = {.lex_state = 9, .external_lex_state = 4},
  [2522] = {.lex_state = 0, .external_lex_state = 4},
  [2523] = {.lex_state = 14, .external_lex_state = 4},
  [2524] = {.lex_state = 14, .external_lex_state = 4},
  [2525] = {.lex_state = 0, .external_lex_state = 4},
  [2526] = {.lex_state = 9, .external_lex_state = 4},
  [2527] = {.lex_state = 8, .external_lex_state = 4},
  [2528] = {.lex_state = 9, .external_lex_state = 4},
  [2529] = {.lex_state = 14, .external_lex_state = 4},
  [2530] = {.lex_state = 0, .external_lex_state = 4},
  [2531] = {.lex_state = 0, .external_lex_state = 4},
  [2532] = {.lex_state = 0, .external_lex_state = 6},
  [2533] = {.lex_state = 0, .external_lex_state = 4},
  [2534] = {.lex_state = 4, .external_lex_state = 4},
  [2535] = {.lex_state = 4, .external_lex_state = 4},
  [2536] = {.lex_state = 0, .external_lex_state = 4},
  [2537] = {.lex_state = 11, .external_lex_state = 4},
  [2538] = {.lex_state = 0, .external_lex_state = 6},
  [2539] = {.lex_state = 0, .external_lex_state = 6},
  [2540] = {.lex_state = 11, .external_lex_state = 4},
  [2541] = {.lex_state = 11, .external_lex_state = 4},
  [2542] = {.lex_state = 11, .external_lex_state = 4},
  [2543] = {.lex_state = 0, .external_lex_state = 6},
  [2544] = {.lex_state = 0, .external_lex_state = 4},
  [2545] = {.lex_state = 0, .external_lex_state = 4},
  [2546] = {.lex_state = 0, .external_lex_state = 4},
  [2547] = {.lex_state = 11, .external_lex_state = 4},
  [2548] = {.lex_state = 0, .external_lex_state = 4},
  [2549] = {.lex_state = 0, .external_lex_state = 4},
  [2550] = {.lex_state = 4, .external_lex_state = 4},
  [2551] = {.lex_state = 0, .external_lex_state = 4},
  [2552] = {.lex_state = 0, .external_lex_state = 4},
  [2553] = {.lex_state = 11, .external_lex_state = 4},
  [2554] = {.lex_state = 0, .external_lex_state = 4},
  [2555] = {.lex_state = 11, .external_lex_state = 4},
  [2556] = {.lex_state = 0, .external_lex_state = 6},
  [2557] = {.lex_state = 0, .external_lex_state = 4},
  [2558] = {.lex_state = 0, .external_lex_state = 6},
  [2559] = {.lex_state = 0, .external_lex_state = 6},
  [2560] = {.lex_state = 11, .external_lex_state = 4},
  [2561] = {.lex_state = 0, .external_lex_state = 4},
  [2562] = {.lex_state = 0, .external_lex_state = 4},
  [2563] = {.lex_state = 4, .external_lex_state = 4},
  [2564] = {.lex_state = 8, .external_lex_state = 4},
  [2565] = {.lex_state = 0, .external_lex_state = 4},
  [2566] = {.lex_state = 0, .external_lex_state = 4},
  [2567] = {.lex_state = 4, .external_lex_state = 4},
  [2568] = {.lex_state = 0, .external_lex_state = 4},
  [2569] = {.lex_state = 0, .external_lex_state = 6},
  [2570] = {.lex_state = 8, .external_lex_state = 4},
  [2571] = {.lex_state = 11, .external_lex_state = 4},
  [2572] = {.lex_state = 11, .external_lex_state = 4},
  [2573] = {.lex_state = 11, .external_lex_state = 4},
  [2574] = {.lex_state = 0, .external_lex_state = 6},
  [2575] = {.lex_state = 0, .external_lex_state = 6},
  [2576] = {.lex_state = 0, .external_lex_state = 6},
  [2577] = {.lex_state = 0, .external_lex_state = 4},
  [2578] = {.lex_state = 11, .external_lex_state = 4},
  [2579] = {.lex_state = 0, .external_lex_state = 6},
  [2580] = {.lex_state = 0, .external_lex_state = 4},
  [2581] = {.lex_state = 0, .external_lex_state = 4},
  [2582] = {.lex_state = 0, .external_lex_state = 4},
  [2583] = {.lex_state = 11, .external_lex_state = 4},
  [2584] = {.lex_state = 0, .external_lex_state = 4},
  [2585] = {.lex_state = 0, .external_lex_state = 4},
  [2586] = {.lex_state = 0, .external_lex_state = 6},
  [2587] = {.lex_state = 0, .external_lex_state = 4},
  [2588] = {.lex_state = 0, .external_lex_state = 4},
  [2589] = {.lex_state = 0, .external_lex_state = 4},
  [2590] = {.lex_state = 11, .external_lex_state = 4},
  [2591] = {.lex_state = 11, .external_lex_state = 4},
  [2592] = {.lex_state = 11, .external_lex_state = 4},
  [2593] = {.lex_state = 4, .external_lex_state = 4},
  [2594] = {.lex_state = 0, .external_lex_state = 6},
  [2595] = {.lex_state = 4, .external_lex_state = 4},
  [2596] = {.lex_state = 0, .external_lex_state = 4},
  [2597] = {.lex_state = 0, .external_lex_state = 6},
  [2598] = {.lex_state = 11, .external_lex_state = 4},
  [2599] = {.lex_state = 11, .external_lex_state = 4},
  [2600] = {.lex_state = 25, .external_lex_state = 6},
  [2601] = {.lex_state = 25, .external_lex_state = 6},
  [2602] = {.lex_state = 9, .external_lex_state = 4},
  [2603] = {.lex_state = 11, .external_lex_state = 4},
  [2604] = {.lex_state = 0, .external_lex_state = 4},
  [2605] = {.lex_state = 0, .external_lex_state = 4},
  [2606] = {.lex_state = 0, .external_lex_state = 4},
  [2607] = {.lex_state = 0, .external_lex_state = 5},
  [2608] = {.lex_state = 0, .external_lex_state = 4},
  [2609] = {.lex_state = 51, .external_lex_state = 4},
  [2610] = {.lex_state = 0, .external_lex_state = 6},
  [2611] = {.lex_state = 0, .external_lex_state = 4},
  [2612] = {.lex_state = 9, .external_lex_state = 4},
  [2613] = {.lex_state = 4, .external_lex_state = 4},
  [2614] = {.lex_state = 0, .external_lex_state = 6},
  [2615] = {.lex_state = 4, .external_lex_state = 4},
  [2616] = {.lex_state = 0, .external_lex_state = 6},
  [2617] = {.lex_state = 0, .external_lex_state = 4},
  [2618] = {.lex_state = 0, .external_lex_state = 4},
  [2619] = {.lex_state = 9, .external_lex_state = 4},
  [2620] = {.lex_state = 0, .external_lex_state = 4},
  [2621] = {.lex_state = 4, .external_lex_state = 4},
  [2622] = {.lex_state = 11, .external_lex_state = 4},
  [2623] = {.lex_state = 11, .external_lex_state = 4},
  [2624] = {.lex_state = 0, .external_lex_state = 4},
  [2625] = {.lex_state = 0, .external_lex_state = 4},
  [2626] = {.lex_state = 0, .external_lex_state = 4},
  [2627] = {.lex_state = 0, .external_lex_state = 6},
  [2628] = {.lex_state = 11, .external_lex_state = 4},
  [2629] = {.lex_state = 51, .external_lex_state = 4},
  [2630] = {.lex_state = 0, .external_lex_state = 6},
  [2631] = {.lex_state = 0, .external_lex_state = 6},
  [2632] = {.lex_state = 0, .external_lex_state = 6},
  [2633] = {.lex_state = 11, .external_lex_state = 4},
  [2634] = {.lex_state = 0, .external_lex_state = 4},
  [2635] = {.lex_state = 11, .external_lex_state = 4},
  [2636] = {.lex_state = 9, .external_lex_state = 4},
  [2637] = {.lex_state = 0, .external_lex_state = 4},
  [2638] = {.lex_state = 0, .external_lex_state = 4},
  [2639] = {.lex_state = 0, .external_lex_state = 4},
  [2640] = {.lex_state = 11, .external_lex_state = 4},
  [2641] = {.lex_state = 0, .external_lex_state = 4},
  [2642] = {.lex_state = 0, .external_lex_state = 6},
  [2643] = {.lex_state = 0, .external_lex_state = 6},
  [2644] = {.lex_state = 39, .external_lex_state = 4},
  [2645] = {.lex_state = 4, .external_lex_state = 4},
  [2646] = {.lex_state = 0, .external_lex_state = 4},
  [2647] = {.lex_state = 25, .external_lex_state = 6},
  [2648] = {.lex_state = 0, .external_lex_state = 4},
  [2649] = {.lex_state = 0, .external_lex_state = 4},
  [2650] = {.lex_state = 27, .external_lex_state = 6},
  [2651] = {.lex_state = 27, .external_lex_state = 6},
  [2652] = {.lex_state = 39, .external_lex_state = 4},
  [2653] = {.lex_state = 27, .external_lex_state = 6},
  [2654] = {.lex_state = 0, .external_lex_state = 4},
  [2655] = {.lex_state = 39, .external_lex_state = 4},
  [2656] = {.lex_state = 0, .external_lex_state = 4},
  [2657] = {.lex_state = 39, .external_lex_state = 4},
  [2658] = {.lex_state = 27, .external_lex_state = 6},
  [2659] = {.lex_state = 25, .external_lex_state = 6},
  [2660] = {.lex_state = 0, .external_lex_state = 4},
  [2661] = {.lex_state = 9, .external_lex_state = 4},
  [2662] = {.lex_state = 39, .external_lex_state = 4},
  [2663] = {.lex_state = 27, .external_lex_state = 6},
  [2664] = {.lex_state = 0, .external_lex_state = 4},
  [2665] = {.lex_state = 0, .external_lex_state = 4},
  [2666] = {.lex_state = 0, .external_lex_state = 4},
  [2667] = {.lex_state = 0, .external_lex_state = 4},
  [2668] = {.lex_state = 0, .external_lex_state = 4},
  [2669] = {.lex_state = 39, .external_lex_state = 4},
  [2670] = {.lex_state = 0, .external_lex_state = 4},
  [2671] = {.lex_state = 0, .external_lex_state = 4},
  [2672] = {.lex_state = 0, .external_lex_state = 4},
  [2673] = {.lex_state = 9, .external_lex_state = 4},
  [2674] = {.lex_state = 25, .external_lex_state = 6},
  [2675] = {.lex_state = 0, .external_lex_state = 4},
  [2676] = {.lex_state = 0, .external_lex_state = 4},
  [2677] = {.lex_state = 27, .external_lex_state = 6},
  [2678] = {.lex_state = 0, .external_lex_state = 4},
  [2679] = {.lex_state = 25, .external_lex_state = 6},
  [2680] = {.lex_state = 39, .external_lex_state = 4},
  [2681] = {.lex_state = 9, .external_lex_state = 4},
  [2682] = {.lex_state = 0, .external_lex_state = 4},
  [2683] = {.lex_state = 0, .external_lex_state = 4},
  [2684] = {.lex_state = 0, .external_lex_state = 4},
  [2685] = {.lex_state = 0, .external_lex_state = 4},
  [2686] = {.lex_state = 11, .external_lex_state = 4},
  [2687] = {.lex_state = 0, .external_lex_state = 4},
  [2688] = {.lex_state = 0, .external_lex_state = 4},
  [2689] = {.lex_state = 0, .external_lex_state = 4},
  [2690] = {.lex_state = 0, .external_lex_state = 4},
  [2691] = {.lex_state = 0, .external_lex_state = 4},
  [2692] = {.lex_state = 0, .external_lex_state = 4},
  [2693] = {.lex_state = 0, .external_lex_state = 4},
  [2694] = {.lex_state = 0, .external_lex_state = 4},
  [2695] = {.lex_state = 14, .external_lex_state = 4},
  [2696] = {.lex_state = 0, .external_lex_state = 4},
  [2697] = {.lex_state = 0, .external_lex_state = 4},
  [2698] = {.lex_state = 0, .external_lex_state = 4},
  [2699] = {.lex_state = 27, .external_lex_state = 6},
  [2700] = {.lex_state = 9, .external_lex_state = 4},
  [2701] = {.lex_state = 0, .external_lex_state = 4},
  [2702] = {.lex_state = 39, .external_lex_state = 4},
  [2703] = {.lex_state = 0, .external_lex_state = 4},
  [2704] = {.lex_state = 9, .external_lex_state = 4},
  [2705] = {.lex_state = 0, .external_lex_state = 4},
  [2706] = {.lex_state = 0, .external_lex_state = 4},
  [2707] = {.lex_state = 0, .external_lex_state = 4},
  [2708] = {.lex_state = 9, .external_lex_state = 4},
  [2709] = {.lex_state = 0, .external_lex_state = 4},
  [2710] = {.lex_state = 0, .external_lex_state = 4},
  [2711] = {.lex_state = 25, .external_lex_state = 6},
  [2712] = {.lex_state = 27, .external_lex_state = 6},
  [2713] = {.lex_state = 0, .external_lex_state = 4},
  [2714] = {.lex_state = 27, .external_lex_state = 6},
  [2715] = {.lex_state = 25, .external_lex_state = 6},
  [2716] = {.lex_state = 0, .external_lex_state = 4},
  [2717] = {.lex_state = 0, .external_lex_state = 4},
  [2718] = {.lex_state = 0, .external_lex_state = 4},
  [2719] = {.lex_state = 39, .external_lex_state = 4},
  [2720] = {.lex_state = 39, .external_lex_state = 4},
  [2721] = {.lex_state = 27, .external_lex_state = 6},
  [2722] = {.lex_state = 0, .external_lex_state = 4},
  [2723] = {.lex_state = 0, .external_lex_state = 4},
  [2724] = {.lex_state = 27, .external_lex_state = 6},
  [2725] = {.lex_state = 27, .external_lex_state = 6},
  [2726] = {.lex_state = 0, .external_lex_state = 4},
  [2727] = {.lex_state = 39, .external_lex_state = 4},
  [2728] = {.lex_state = 0, .external_lex_state = 4},
  [2729] = {.lex_state = 4, .external_lex_state = 4},
  [2730] = {.lex_state = 0, .external_lex_state = 4},
  [2731] = {.lex_state = 0, .external_lex_state = 4},
  [2732] = {.lex_state = 0, .external_lex_state = 4},
  [2733] = {.lex_state = 0, .external_lex_state = 4},
  [2734] = {.lex_state = 0, .external_lex_state = 4},
  [2735] = {.lex_state = 0, .external_lex_state = 4},
  [2736] = {.lex_state = 27, .external_lex_state = 6},
  [2737] = {.lex_state = 39, .external_lex_state = 4},
  [2738] = {.lex_state = 39, .external_lex_state = 4},
  [2739] = {.lex_state = 39, .external_lex_state = 4},
  [2740] = {.lex_state = 27, .external_lex_state = 6},
  [2741] = {.lex_state = 25, .external_lex_state = 6},
  [2742] = {.lex_state = 39, .external_lex_state = 4},
  [2743] = {.lex_state = 0, .external_lex_state = 4},
  [2744] = {.lex_state = 0, .external_lex_state = 4},
  [2745] = {.lex_state = 27, .external_lex_state = 6},
  [2746] = {.lex_state = 0, .external_lex_state = 6},
  [2747] = {.lex_state = 9, .external_lex_state = 4},
  [2748] = {.lex_state = 0, .external_lex_state = 4},
  [2749] = {.lex_state = 0, .external_lex_state = 4},
  [2750] = {.lex_state = 0, .external_lex_state = 4},
  [2751] = {.lex_state = 0, .external_lex_state = 4},
  [2752] = {.lex_state = 222, .external_lex_state = 4},
  [2753] = {.lex_state = 0, .external_lex_state = 4},
  [2754] = {.lex_state = 11, .external_lex_state = 4},
  [2755] = {.lex_state = 0, .external_lex_state = 4},
  [2756] = {.lex_state = 222, .external_lex_state = 4},
  [2757] = {.lex_state = 8, .external_lex_state = 4},
  [2758] = {.lex_state = 0, .external_lex_state = 4},
  [2759] = {.lex_state = 0, .external_lex_state = 4},
  [2760] = {.lex_state = 0, .external_lex_state = 4},
  [2761] = {.lex_state = 0, .external_lex_state = 4},
  [2762] = {.lex_state = 0, .external_lex_state = 4},
  [2763] = {.lex_state = 0, .external_lex_state = 4},
  [2764] = {.lex_state = 0, .external_lex_state = 4},
  [2765] = {.lex_state = 0, .external_lex_state = 4},
  [2766] = {.lex_state = 0, .external_lex_state = 4},
  [2767] = {.lex_state = 0, .external_lex_state = 4},
  [2768] = {.lex_state = 0, .external_lex_state = 4},
  [2769] = {.lex_state = 0, .external_lex_state = 4},
  [2770] = {.lex_state = 0, .external_lex_state = 4},
  [2771] = {.lex_state = 0, .external_lex_state = 4},
  [2772] = {.lex_state = 0, .external_lex_state = 4},
  [2773] = {.lex_state = 9, .external_lex_state = 4},
  [2774] = {.lex_state = 0, .external_lex_state = 4},
  [2775] = {.lex_state = 0, .external_lex_state = 4},
  [2776] = {.lex_state = 0, .external_lex_state = 4},
  [2777] = {.lex_state = 0, .external_lex_state = 4},
  [2778] = {.lex_state = 0, .external_lex_state = 4},
  [2779] = {.lex_state = 0, .external_lex_state = 4},
  [2780] = {.lex_state = 11, .external_lex_state = 4},
  [2781] = {.lex_state = 0, .external_lex_state = 4},
  [2782] = {.lex_state = 0, .external_lex_state = 4},
  [2783] = {.lex_state = 0, .external_lex_state = 4},
  [2784] = {.lex_state = 0, .external_lex_state = 4},
  [2785] = {.lex_state = 0, .external_lex_state = 4},
  [2786] = {.lex_state = 0, .external_lex_state = 4},
  [2787] = {.lex_state = 0, .external_lex_state = 4},
  [2788] = {.lex_state = 0, .external_lex_state = 4},
  [2789] = {.lex_state = 0, .external_lex_state = 4},
  [2790] = {.lex_state = 0, .external_lex_state = 4},
  [2791] = {.lex_state = 0, .external_lex_state = 4},
  [2792] = {.lex_state = 0, .external_lex_state = 4},
  [2793] = {.lex_state = 8, .external_lex_state = 4},
  [2794] = {.lex_state = 0, .external_lex_state = 9},
  [2795] = {.lex_state = 0, .external_lex_state = 4},
  [2796] = {.lex_state = 0, .external_lex_state = 4},
  [2797] = {.lex_state = 0, .external_lex_state = 4},
  [2798] = {.lex_state = 8, .external_lex_state = 4},
  [2799] = {.lex_state = 0, .external_lex_state = 4},
  [2800] = {.lex_state = 0, .external_lex_state = 4},
  [2801] = {.lex_state = 0, .external_lex_state = 4},
  [2802] = {.lex_state = 0, .external_lex_state = 4},
  [2803] = {.lex_state = 0, .external_lex_state = 4},
  [2804] = {.lex_state = 0, .external_lex_state = 4},
  [2805] = {.lex_state = 8, .external_lex_state = 4},
  [2806] = {.lex_state = 0, .external_lex_state = 4},
  [2807] = {.lex_state = 8, .external_lex_state = 4},
  [2808] = {.lex_state = 37, .external_lex_state = 4},
  [2809] = {.lex_state = 9, .external_lex_state = 4},
  [2810] = {.lex_state = 0, .external_lex_state = 4},
  [2811] = {.lex_state = 37, .external_lex_state = 4},
  [2812] = {.lex_state = 0, .external_lex_state = 4},
  [2813] = {.lex_state = 0, .external_lex_state = 4},
  [2814] = {.lex_state = 0, .external_lex_state = 4},
  [2815] = {.lex_state = 0, .external_lex_state = 4},
  [2816] = {.lex_state = 0, .external_lex_state = 4},
  [2817] = {.lex_state = 0, .external_lex_state = 4},
  [2818] = {.lex_state = 0, .external_lex_state = 4},
  [2819] = {.lex_state = 8, .external_lex_state = 4},
  [2820] = {.lex_state = 0, .external_lex_state = 4},
  [2821] = {.lex_state = 8, .external_lex_state = 4},
  [2822] = {.lex_state = 0, .external_lex_state = 4},
  [2823] = {.lex_state = 0, .external_lex_state = 4},
  [2824] = {.lex_state = 0, .external_lex_state = 4},
  [2825] = {.lex_state = 0, .external_lex_state = 4},
  [2826] = {.lex_state = 0, .external_lex_state = 4},
  [2827] = {.lex_state = 0, .external_lex_state = 4},
  [2828] = {.lex_state = 0, .external_lex_state = 4},
  [2829] = {.lex_state = 0, .external_lex_state = 4},
  [2830] = {.lex_state = 0, .external_lex_state = 4},
  [2831] = {.lex_state = 0, .external_lex_state = 4},
  [2832] = {.lex_state = 0, .external_lex_state = 4},
  [2833] = {.lex_state = 0, .external_lex_state = 4},
  [2834] = {.lex_state = 0, .external_lex_state = 4},
  [2835] = {.lex_state = 11, .external_lex_state = 4},
  [2836] = {.lex_state = 0, .external_lex_state = 4},
  [2837] = {.lex_state = 0, .external_lex_state = 4},
  [2838] = {.lex_state = 0, .external_lex_state = 4},
  [2839] = {.lex_state = 11, .external_lex_state = 4},
  [2840] = {.lex_state = 0, .external_lex_state = 4},
  [2841] = {.lex_state = 0, .external_lex_state = 4},
  [2842] = {.lex_state = 0, .external_lex_state = 4},
  [2843] = {.lex_state = 0, .external_lex_state = 4},
  [2844] = {.lex_state = 0, .external_lex_state = 4},
  [2845] = {.lex_state = 0, .external_lex_state = 4},
  [2846] = {.lex_state = 0, .external_lex_state = 4},
  [2847] = {.lex_state = 0, .external_lex_state = 4},
  [2848] = {.lex_state = 0, .external_lex_state = 4},
  [2849] = {.lex_state = 37, .external_lex_state = 4},
  [2850] = {.lex_state = 8, .external_lex_state = 4},
  [2851] = {.lex_state = 0, .external_lex_state = 4},
  [2852] = {.lex_state = 0, .external_lex_state = 4},
  [2853] = {.lex_state = 0, .external_lex_state = 4},
  [2854] = {.lex_state = 0, .external_lex_state = 4},
  [2855] = {.lex_state = 8, .external_lex_state = 4},
  [2856] = {.lex_state = 0, .external_lex_state = 4},
  [2857] = {.lex_state = 8, .external_lex_state = 4},
  [2858] = {.lex_state = 0, .external_lex_state = 4},
  [2859] = {.lex_state = 0, .external_lex_state = 4},
  [2860] = {.lex_state = 0, .external_lex_state = 4},
  [2861] = {.lex_state = 0, .external_lex_state = 4},
  [2862] = {.lex_state = 0, .external_lex_state = 4},
  [2863] = {.lex_state = 0, .external_lex_state = 4},
  [2864] = {.lex_state = 0, .external_lex_state = 4},
  [2865] = {.lex_state = 8, .external_lex_state = 4},
  [2866] = {.lex_state = 27, .external_lex_state = 6},
  [2867] = {.lex_state = 0, .external_lex_state = 4},
  [2868] = {.lex_state = 0, .external_lex_state = 4},
  [2869] = {.lex_state = 0, .external_lex_state = 4},
  [2870] = {.lex_state = 0, .external_lex_state = 4},
  [2871] = {.lex_state = 0, .external_lex_state = 4},
  [2872] = {.lex_state = 0, .external_lex_state = 4},
  [2873] = {.lex_state = 0, .external_lex_state = 4},
  [2874] = {.lex_state = 9, .external_lex_state = 4},
  [2875] = {.lex_state = 0, .external_lex_state = 4},
  [2876] = {.lex_state = 0, .external_lex_state = 4},
  [2877] = {.lex_state = 0, .external_lex_state = 4},
  [2878] = {.lex_state = 0, .external_lex_state = 4},
  [2879] = {.lex_state = 39, .external_lex_state = 4},
  [2880] = {.lex_state = 0, .external_lex_state = 4},
  [2881] = {.lex_state = 0, .external_lex_state = 4},
  [2882] = {.lex_state = 0, .external_lex_state = 4},
  [2883] = {.lex_state = 0, .external_lex_state = 4},
  [2884] = {.lex_state = 0, .external_lex_state = 4},
  [2885] = {.lex_state = 11, .external_lex_state = 4},
  [2886] = {.lex_state = 0, .external_lex_state = 4},
  [2887] = {.lex_state = 11, .external_lex_state = 4},
  [2888] = {.lex_state = 0, .external_lex_state = 4},
  [2889] = {.lex_state = 0, .external_lex_state = 4},
  [2890] = {.lex_state = 0, .external_lex_state = 4},
  [2891] = {.lex_state = 0, .external_lex_state = 4},
  [2892] = {.lex_state = 0, .external_lex_state = 4},
  [2893] = {.lex_state = 0, .external_lex_state = 4},
  [2894] = {.lex_state = 0, .external_lex_state = 4},
  [2895] = {.lex_state = 8, .external_lex_state = 4},
  [2896] = {.lex_state = 222, .external_lex_state = 4},
  [2897] = {.lex_state = 37, .external_lex_state = 4},
  [2898] = {.lex_state = 0, .external_lex_state = 4},
  [2899] = {.lex_state = 11, .external_lex_state = 4},
  [2900] = {.lex_state = 0, .external_lex_state = 4},
  [2901] = {.lex_state = 0, .external_lex_state = 4},
  [2902] = {.lex_state = 0, .external_lex_state = 4},
  [2903] = {.lex_state = 0, .external_lex_state = 4},
  [2904] = {.lex_state = 9, .external_lex_state = 4},
  [2905] = {.lex_state = 0, .external_lex_state = 4},
  [2906] = {.lex_state = 8, .external_lex_state = 4},
  [2907] = {.lex_state = 37, .external_lex_state = 4},
  [2908] = {.lex_state = 0, .external_lex_state = 9},
  [2909] = {.lex_state = 0, .external_lex_state = 4},
  [2910] = {.lex_state = 0, .external_lex_state = 9},
  [2911] = {.lex_state = 8, .external_lex_state = 4},
  [2912] = {.lex_state = 0, .external_lex_state = 4},
  [2913] = {.lex_state = 4, .external_lex_state = 4},
  [2914] = {.lex_state = 222, .external_lex_state = 4},
  [2915] = {.lex_state = 0, .external_lex_state = 4},
  [2916] = {.lex_state = 0, .external_lex_state = 4},
  [2917] = {.lex_state = 8, .external_lex_state = 4},
  [2918] = {.lex_state = 0, .external_lex_state = 4},
  [2919] = {.lex_state = 37, .external_lex_state = 4},
  [2920] = {.lex_state = 8, .external_lex_state = 4},
  [2921] = {.lex_state = 0, .external_lex_state = 4},
  [2922] = {.lex_state = 9, .external_lex_state = 4},
  [2923] = {.lex_state = 0, .external_lex_state = 4},
  [2924] = {.lex_state = 0, .external_lex_state = 4},
  [2925] = {.lex_state = 0, .external_lex_state = 4},
  [2926] = {.lex_state = 0, .external_lex_state = 4},
  [2927] = {.lex_state = 0, .external_lex_state = 4},
  [2928] = {.lex_state = 0, .external_lex_state = 4},
  [2929] = {.lex_state = 0, .external_lex_state = 4},
  [2930] = {.lex_state = 0, .external_lex_state = 4},
  [2931] = {.lex_state = 0, .external_lex_state = 4},
  [2932] = {.lex_state = 0, .external_lex_state = 4},
  [2933] = {.lex_state = 0, .external_lex_state = 4},
  [2934] = {.lex_state = 0, .external_lex_state = 4},
  [2935] = {.lex_state = 0, .external_lex_state = 4},
  [2936] = {.lex_state = 0, .external_lex_state = 4},
  [2937] = {.lex_state = 0, .external_lex_state = 4},
  [2938] = {.lex_state = 0, .external_lex_state = 4},
  [2939] = {.lex_state = 0, .external_lex_state = 4},
  [2940] = {.lex_state = 0, .external_lex_state = 4},
  [2941] = {.lex_state = 0, .external_lex_state = 4},
  [2942] = {.lex_state = 0, .external_lex_state = 4},
  [2943] = {.lex_state = 0, .external_lex_state = 4},
  [2944] = {.lex_state = 0, .external_lex_state = 4},
  [2945] = {.lex_state = 0, .external_lex_state = 4},
  [2946] = {.lex_state = 0, .external_lex_state = 4},
  [2947] = {.lex_state = 0, .external_lex_state = 4},
  [2948] = {.lex_state = 0, .external_lex_state = 4},
  [2949] = {.lex_state = 0, .external_lex_state = 4},
  [2950] = {.lex_state = 0, .external_lex_state = 4},
  [2951] = {.lex_state = 0, .external_lex_state = 4},
  [2952] = {.lex_state = 0, .external_lex_state = 4},
  [2953] = {.lex_state = 0, .external_lex_state = 4},
  [2954] = {.lex_state = 0, .external_lex_state = 4},
  [2955] = {.lex_state = 0, .external_lex_state = 4},
  [2956] = {.lex_state = 0, .external_lex_state = 4},
  [2957] = {.lex_state = 0, .external_lex_state = 4},
  [2958] = {.lex_state = 0, .external_lex_state = 4},
  [2959] = {.lex_state = 0, .external_lex_state = 4},
  [2960] = {.lex_state = 0, .external_lex_state = 4},
  [2961] = {.lex_state = 0, .external_lex_state = 4},
  [2962] = {.lex_state = 0, .external_lex_state = 4},
  [2963] = {.lex_state = 0, .external_lex_state = 4},
  [2964] = {.lex_state = 0, .external_lex_state = 4},
  [2965] = {.lex_state = 0, .external_lex_state = 4},
  [2966] = {.lex_state = 0, .external_lex_state = 4},
  [2967] = {.lex_state = 0, .external_lex_state = 4},
  [2968] = {.lex_state = 0, .external_lex_state = 4},
  [2969] = {.lex_state = 0, .external_lex_state = 4},
  [2970] = {.lex_state = 222, .external_lex_state = 4},
  [2971] = {.lex_state = 0, .external_lex_state = 4},
  [2972] = {.lex_state = 0, .external_lex_state = 4},
  [2973] = {.lex_state = 0, .external_lex_state = 4},
  [2974] = {.lex_state = 0, .external_lex_state = 4},
  [2975] = {.lex_state = 0, .external_lex_state = 4},
  [2976] = {.lex_state = 0, .external_lex_state = 4},
  [2977] = {.lex_state = 0, .external_lex_state = 4},
  [2978] = {.lex_state = 0, .external_lex_state = 4},
  [2979] = {.lex_state = 0, .external_lex_state = 4},
  [2980] = {.lex_state = 0, .external_lex_state = 4},
  [2981] = {.lex_state = 0, .external_lex_state = 9},
  [2982] = {.lex_state = 0, .external_lex_state = 4},
  [2983] = {.lex_state = 0, .external_lex_state = 4},
  [2984] = {.lex_state = 0, .external_lex_state = 4},
  [2985] = {.lex_state = 0, .external_lex_state = 4},
  [2986] = {.lex_state = 0, .external_lex_state = 4},
  [2987] = {.lex_state = 0, .external_lex_state = 4},
  [2988] = {.lex_state = 0, .external_lex_state = 4},
  [2989] = {.lex_state = 9, .external_lex_state = 4},
  [2990] = {.lex_state = 0, .external_lex_state = 4},
  [2991] = {.lex_state = 0, .external_lex_state = 4},
  [2992] = {.lex_state = 222, .external_lex_state = 4},
  [2993] = {.lex_state = 0, .external_lex_state = 4},
  [2994] = {.lex_state = 0, .external_lex_state = 4},
  [2995] = {.lex_state = 9, .external_lex_state = 4},
  [2996] = {.lex_state = 0, .external_lex_state = 4},
  [2997] = {.lex_state = 0, .external_lex_state = 4},
  [2998] = {.lex_state = 9, .external_lex_state = 4},
  [2999] = {.lex_state = 0, .external_lex_state = 4},
  [3000] = {.lex_state = 0, .external_lex_state = 9},
  [3001] = {.lex_state = 0, .external_lex_state = 4},
  [3002] = {.lex_state = 0, .external_lex_state = 4},
  [3003] = {.lex_state = 0, .external_lex_state = 4},
  [3004] = {.lex_state = 222, .external_lex_state = 4},
  [3005] = {.lex_state = 0, .external_lex_state = 4},
  [3006] = {.lex_state = 0, .external_lex_state = 4},
  [3007] = {.lex_state = 0, .external_lex_state = 4},
  [3008] = {.lex_state = 0, .external_lex_state = 4},
  [3009] = {.lex_state = 8, .external_lex_state = 4},
  [3010] = {.lex_state = 37, .external_lex_state = 4},
  [3011] = {.lex_state = 0, .external_lex_state = 4},
  [3012] = {.lex_state = 0, .external_lex_state = 4},
  [3013] = {.lex_state = 11, .external_lex_state = 4},
  [3014] = {.lex_state = 0, .external_lex_state = 4},
  [3015] = {.lex_state = 0, .external_lex_state = 4},
  [3016] = {.lex_state = 0, .external_lex_state = 4},
  [3017] = {.lex_state = 222, .external_lex_state = 4},
  [3018] = {.lex_state = 0, .external_lex_state = 4},
  [3019] = {.lex_state = 0, .external_lex_state = 4},
  [3020] = {.lex_state = 8, .external_lex_state = 4},
  [3021] = {.lex_state = 0, .external_lex_state = 4},
  [3022] = {.lex_state = 9, .external_lex_state = 4},
  [3023] = {.lex_state = 0, .external_lex_state = 4},
  [3024] = {.lex_state = 0, .external_lex_state = 4},
  [3025] = {.lex_state = 0, .external_lex_state = 4},
  [3026] = {.lex_state = 0, .external_lex_state = 4},
  [3027] = {.lex_state = 0, .external_lex_state = 4},
  [3028] = {.lex_state = 0, .external_lex_state = 4},
  [3029] = {.lex_state = 0, .external_lex_state = 4},
  [3030] = {.lex_state = 0, .external_lex_state = 4},
  [3031] = {.lex_state = 0, .external_lex_state = 4},
  [3032] = {.lex_state = 0, .external_lex_state = 4},
  [3033] = {.lex_state = 0, .external_lex_state = 4},
  [3034] = {.lex_state = 0, .external_lex_state = 4},
  [3035] = {.lex_state = 0, .external_lex_state = 4},
  [3036] = {.lex_state = 37, .external_lex_state = 4},
  [3037] = {.lex_state = 0, .external_lex_state = 6},
  [3038] = {.lex_state = 0, .external_lex_state = 4},
  [3039] = {.lex_state = 0, .external_lex_state = 4},
  [3040] = {.lex_state = 0, .external_lex_state = 9},
  [3041] = {.lex_state = 0, .external_lex_state = 6},
  [3042] = {.lex_state = 0, .external_lex_state = 4},
  [3043] = {.lex_state = 0, .external_lex_state = 4},
  [3044] = {.lex_state = 0, .external_lex_state = 4},
  [3045] = {.lex_state = 0, .external_lex_state = 4},
  [3046] = {.lex_state = 0, .external_lex_state = 4},
  [3047] = {.lex_state = 0, .external_lex_state = 4},
  [3048] = {.lex_state = 0, .external_lex_state = 4},
  [3049] = {.lex_state = 0, .external_lex_state = 4},
  [3050] = {.lex_state = 222, .external_lex_state = 4},
  [3051] = {.lex_state = 0, .external_lex_state = 4},
  [3052] = {.lex_state = 0, .external_lex_state = 4},
  [3053] = {.lex_state = 0, .external_lex_state = 6},
  [3054] = {.lex_state = 0, .external_lex_state = 4},
  [3055] = {.lex_state = 0, .external_lex_state = 4},
  [3056] = {.lex_state = 0, .external_lex_state = 4},
  [3057] = {.lex_state = 9, .external_lex_state = 4},
  [3058] = {.lex_state = 0, .external_lex_state = 4},
  [3059] = {.lex_state = 0, .external_lex_state = 4},
  [3060] = {.lex_state = 0, .external_lex_state = 4},
  [3061] = {.lex_state = 0, .external_lex_state = 4},
  [3062] = {.lex_state = 0, .external_lex_state = 4},
  [3063] = {.lex_state = 0, .external_lex_state = 4},
  [3064] = {.lex_state = 0, .external_lex_state = 4},
  [3065] = {.lex_state = 0, .external_lex_state = 4},
  [3066] = {.lex_state = 0, .external_lex_state = 4},
  [3067] = {.lex_state = 0, .external_lex_state = 4},
  [3068] = {.lex_state = 0, .external_lex_state = 4},
  [3069] = {.lex_state = 0, .external_lex_state = 4},
  [3070] = {.lex_state = 0, .external_lex_state = 6},
  [3071] = {.lex_state = 0, .external_lex_state = 4},
  [3072] = {.lex_state = 0, .external_lex_state = 4},
  [3073] = {.lex_state = 0, .external_lex_state = 9},
  [3074] = {.lex_state = 0, .external_lex_state = 4},
  [3075] = {.lex_state = 0, .external_lex_state = 4},
  [3076] = {.lex_state = 0, .external_lex_state = 4},
  [3077] = {.lex_state = 0, .external_lex_state = 4},
  [3078] = {.lex_state = 0, .external_lex_state = 4},
  [3079] = {.lex_state = 0, .external_lex_state = 4},
  [3080] = {.lex_state = 0, .external_lex_state = 4},
  [3081] = {.lex_state = 0, .external_lex_state = 4},
  [3082] = {.lex_state = 0, .external_lex_state = 4},
  [3083] = {.lex_state = 0, .external_lex_state = 9},
  [3084] = {.lex_state = 0, .external_lex_state = 9},
  [3085] = {.lex_state = 0, .external_lex_state = 4},
  [3086] = {.lex_state = 0, .external_lex_state = 9},
  [3087] = {.lex_state = 0, .external_lex_state = 4},
  [3088] = {.lex_state = 0, .external_lex_state = 4},
  [3089] = {.lex_state = 0, .external_lex_state = 4},
  [3090] = {.lex_state = 0, .external_lex_state = 4},
  [3091] = {.lex_state = 0, .external_lex_state = 4},
  [3092] = {.lex_state = 0, .external_lex_state = 4},
  [3093] = {.lex_state = 0, .external_lex_state = 4},
  [3094] = {.lex_state = 0, .external_lex_state = 4},
  [3095] = {.lex_state = 0, .external_lex_state = 4},
  [3096] = {.lex_state = 222, .external_lex_state = 4},
  [3097] = {.lex_state = 0, .external_lex_state = 4},
  [3098] = {.lex_state = 0, .external_lex_state = 4},
  [3099] = {.lex_state = 0, .external_lex_state = 4},
  [3100] = {.lex_state = 0, .external_lex_state = 6},
  [3101] = {.lex_state = 0, .external_lex_state = 9},
  [3102] = {.lex_state = 0, .external_lex_state = 4},
  [3103] = {.lex_state = 0, .external_lex_state = 4},
  [3104] = {.lex_state = 0, .external_lex_state = 4},
  [3105] = {.lex_state = 0, .external_lex_state = 4},
  [3106] = {.lex_state = 0, .external_lex_state = 4},
  [3107] = {.lex_state = 0, .external_lex_state = 6},
  [3108] = {.lex_state = 0, .external_lex_state = 4},
  [3109] = {.lex_state = 0, .external_lex_state = 4},
  [3110] = {.lex_state = 0, .external_lex_state = 4},
  [3111] = {.lex_state = 0, .external_lex_state = 4},
  [3112] = {.lex_state = 9, .external_lex_state = 4},
  [3113] = {.lex_state = 0, .external_lex_state = 4},
  [3114] = {.lex_state = 0, .external_lex_state = 4},
  [3115] = {.lex_state = 9, .external_lex_state = 4},
  [3116] = {.lex_state = 0, .external_lex_state = 4},
  [3117] = {.lex_state = 0, .external_lex_state = 4},
  [3118] = {.lex_state = 0, .external_lex_state = 6},
  [3119] = {.lex_state = 0, .external_lex_state = 6},
  [3120] = {.lex_state = 0, .external_lex_state = 4},
  [3121] = {.lex_state = 0, .external_lex_state = 4},
  [3122] = {.lex_state = 0, .external_lex_state = 4},
  [3123] = {.lex_state = 0, .external_lex_state = 4},
  [3124] = {.lex_state = 0, .external_lex_state = 4},
  [3125] = {.lex_state = 0, .external_lex_state = 4},
  [3126] = {.lex_state = 0, .external_lex_state = 9},
  [3127] = {.lex_state = 0, .external_lex_state = 4},
  [3128] = {.lex_state = 0, .external_lex_state = 4},
  [3129] = {.lex_state = 0, .external_lex_state = 4},
  [3130] = {.lex_state = 0, .external_lex_state = 4},
  [3131] = {.lex_state = 0, .external_lex_state = 4},
  [3132] = {.lex_state = 0, .external_lex_state = 4},
  [3133] = {.lex_state = 0, .external_lex_state = 4},
  [3134] = {.lex_state = 0, .external_lex_state = 4},
  [3135] = {.lex_state = 0, .external_lex_state = 4},
  [3136] = {.lex_state = 0, .external_lex_state = 4},
  [3137] = {.lex_state = 0, .external_lex_state = 4},
  [3138] = {.lex_state = 0, .external_lex_state = 4},
  [3139] = {.lex_state = 0, .external_lex_state = 4},
  [3140] = {.lex_state = 0, .external_lex_state = 4},
  [3141] = {.lex_state = 0, .external_lex_state = 4},
  [3142] = {.lex_state = 0, .external_lex_state = 4},
  [3143] = {.lex_state = 0, .external_lex_state = 4},
  [3144] = {.lex_state = 0, .external_lex_state = 4},
  [3145] = {.lex_state = 222, .external_lex_state = 4},
  [3146] = {.lex_state = 0, .external_lex_state = 4},
  [3147] = {.lex_state = 0, .external_lex_state = 4},
  [3148] = {.lex_state = 0, .external_lex_state = 4},
  [3149] = {.lex_state = 0, .external_lex_state = 4},
  [3150] = {.lex_state = 0, .external_lex_state = 4},
  [3151] = {.lex_state = 0, .external_lex_state = 4},
  [3152] = {.lex_state = 8, .external_lex_state = 4},
  [3153] = {.lex_state = 0, .external_lex_state = 4},
  [3154] = {.lex_state = 0, .external_lex_state = 4},
  [3155] = {.lex_state = 0, .external_lex_state = 4},
  [3156] = {.lex_state = 0, .external_lex_state = 4},
  [3157] = {.lex_state = 0, .external_lex_state = 4},
  [3158] = {.lex_state = 0, .external_lex_state = 4},
  [3159] = {.lex_state = 0, .external_lex_state = 4},
  [3160] = {.lex_state = 0, .external_lex_state = 4},
  [3161] = {.lex_state = 0, .external_lex_state = 4},
  [3162] = {.lex_state = 0, .external_lex_state = 4},
  [3163] = {.lex_state = 0, .external_lex_state = 4},
  [3164] = {.lex_state = 0, .external_lex_state = 4},
  [3165] = {.lex_state = 0, .external_lex_state = 4},
  [3166] = {.lex_state = 0, .external_lex_state = 4},
  [3167] = {.lex_state = 0, .external_lex_state = 4},
  [3168] = {.lex_state = 0, .external_lex_state = 4},
  [3169] = {.lex_state = 0, .external_lex_state = 4},
  [3170] = {.lex_state = 0, .external_lex_state = 4},
  [3171] = {.lex_state = 0, .external_lex_state = 4},
  [3172] = {.lex_state = 222, .external_lex_state = 4},
  [3173] = {.lex_state = 0, .external_lex_state = 4},
  [3174] = {.lex_state = 0, .external_lex_state = 4},
  [3175] = {.lex_state = 0, .external_lex_state = 4},
  [3176] = {.lex_state = 0, .external_lex_state = 4},
  [3177] = {.lex_state = 8, .external_lex_state = 4},
  [3178] = {.lex_state = 0, .external_lex_state = 4},
  [3179] = {.lex_state = 0, .external_lex_state = 4},
  [3180] = {.lex_state = 0, .external_lex_state = 4},
  [3181] = {.lex_state = 222, .external_lex_state = 4},
  [3182] = {.lex_state = 0, .external_lex_state = 4},
  [3183] = {.lex_state = 0, .external_lex_state = 4},
  [3184] = {.lex_state = 0, .external_lex_state = 4},
  [3185] = {.lex_state = 0, .external_lex_state = 4},
  [3186] = {.lex_state = 0, .external_lex_state = 4},
  [3187] = {.lex_state = 0, .external_lex_state = 4},
  [3188] = {.lex_state = 0, .external_lex_state = 4},
  [3189] = {.lex_state = 0, .external_lex_state = 4},
  [3190] = {.lex_state = 0, .external_lex_state = 4},
  [3191] = {.lex_state = 0, .external_lex_state = 10},
  [3192] = {.lex_state = 0, .external_lex_state = 4},
  [3193] = {.lex_state = 0, .external_lex_state = 4},
  [3194] = {.lex_state = 0, .external_lex_state = 4},
  [3195] = {.lex_state = 0, .external_lex_state = 4},
  [3196] = {.lex_state = 0, .external_lex_state = 4},
  [3197] = {.lex_state = 0, .external_lex_state = 4},
  [3198] = {.lex_state = 0, .external_lex_state = 4},
  [3199] = {.lex_state = 0, .external_lex_state = 4},
  [3200] = {.lex_state = 0, .external_lex_state = 4},
  [3201] = {.lex_state = 0, .external_lex_state = 4},
  [3202] = {.lex_state = 222, .external_lex_state = 4},
  [3203] = {.lex_state = 0, .external_lex_state = 10},
  [3204] = {.lex_state = 0, .external_lex_state = 4},
  [3205] = {.lex_state = 0, .external_lex_state = 4},
  [3206] = {.lex_state = 222, .external_lex_state = 4},
  [3207] = {.lex_state = 0, .external_lex_state = 4},
  [3208] = {.lex_state = 0, .external_lex_state = 4},
  [3209] = {.lex_state = 0, .external_lex_state = 4},
  [3210] = {.lex_state = 0, .external_lex_state = 4},
  [3211] = {.lex_state = 0, .external_lex_state = 4},
  [3212] = {.lex_state = 0, .external_lex_state = 4},
  [3213] = {.lex_state = 0, .external_lex_state = 4},
  [3214] = {.lex_state = 0, .external_lex_state = 4},
  [3215] = {.lex_state = 0, .external_lex_state = 4},
  [3216] = {.lex_state = 0, .external_lex_state = 4},
  [3217] = {.lex_state = 0, .external_lex_state = 4},
  [3218] = {.lex_state = 222, .external_lex_state = 4},
  [3219] = {.lex_state = 8, .external_lex_state = 4},
  [3220] = {.lex_state = 0, .external_lex_state = 4},
  [3221] = {.lex_state = 0, .external_lex_state = 4},
  [3222] = {.lex_state = 8, .external_lex_state = 4},
  [3223] = {.lex_state = 0, .external_lex_state = 4},
  [3224] = {.lex_state = 0, .external_lex_state = 4},
  [3225] = {.lex_state = 0, .external_lex_state = 4},
  [3226] = {.lex_state = 0, .external_lex_state = 4},
  [3227] = {.lex_state = 0, .external_lex_state = 4},
  [3228] = {.lex_state = 0, .external_lex_state = 4},
  [3229] = {.lex_state = 0, .external_lex_state = 4},
  [3230] = {.lex_state = 0, .external_lex_state = 10},
  [3231] = {.lex_state = 222, .external_lex_state = 4},
  [3232] = {.lex_state = 0, .external_lex_state = 4},
  [3233] = {.lex_state = 8, .external_lex_state = 4},
  [3234] = {.lex_state = 0, .external_lex_state = 4},
  [3235] = {.lex_state = 0, .external_lex_state = 4},
  [3236] = {.lex_state = 222, .external_lex_state = 4},
  [3237] = {.lex_state = 0, .external_lex_state = 4},
  [3238] = {.lex_state = 222, .external_lex_state = 4},
  [3239] = {.lex_state = 8, .external_lex_state = 4},
  [3240] = {.lex_state = 222, .external_lex_state = 4},
  [3241] = {.lex_state = 222, .external_lex_state = 4},
  [3242] = {.lex_state = 0, .external_lex_state = 4},
  [3243] = {.lex_state = 0, .external_lex_state = 4},
  [3244] = {.lex_state = 0, .external_lex_state = 4},
  [3245] = {.lex_state = 0, .external_lex_state = 4},
  [3246] = {.lex_state = 8, .external_lex_state = 4},
  [3247] = {.lex_state = 222, .external_lex_state = 4},
  [3248] = {.lex_state = 8, .external_lex_state = 4},
  [3249] = {.lex_state = 222, .external_lex_state = 4},
  [3250] = {.lex_state = 0, .external_lex_state = 4},
  [3251] = {.lex_state = 0, .external_lex_state = 4},
  [3252] = {.lex_state = 0, .external_lex_state = 4},
  [3253] = {.lex_state = 0, .external_lex_state = 4},
  [3254] = {.lex_state = 0, .external_lex_state = 4},
  [3255] = {.lex_state = 0, .external_lex_state = 4},
  [3256] = {.lex_state = 222, .external_lex_state = 4},
  [3257] = {.lex_state = 0, .external_lex_state = 4},
  [3258] = {.lex_state = 0, .external_lex_state = 4},
  [3259] = {.lex_state = 0, .external_lex_state = 4},
  [3260] = {.lex_state = 0, .external_lex_state = 4},
  [3261] = {.lex_state = 0, .external_lex_state = 4},
  [3262] = {.lex_state = 0, .external_lex_state = 4},
  [3263] = {.lex_state = 8, .external_lex_state = 4},
  [3264] = {.lex_state = 222, .external_lex_state = 4},
  [3265] = {.lex_state = 8, .external_lex_state = 4},
  [3266] = {.lex_state = 8, .external_lex_state = 4},
  [3267] = {.lex_state = 0, .external_lex_state = 4},
  [3268] = {.lex_state = 0, .external_lex_state = 4},
  [3269] = {.lex_state = 0, .external_lex_state = 4},
  [3270] = {.lex_state = 8, .external_lex_state = 4},
  [3271] = {.lex_state = 0, .external_lex_state = 4},
  [3272] = {.lex_state = 222, .external_lex_state = 4},
  [3273] = {.lex_state = 0, .external_lex_state = 4},
  [3274] = {.lex_state = 222, .external_lex_state = 4},
  [3275] = {.lex_state = 0, .external_lex_state = 4},
  [3276] = {.lex_state = 222, .external_lex_state = 4},
  [3277] = {.lex_state = 0, .external_lex_state = 4},
  [3278] = {.lex_state = 0, .external_lex_state = 4},
  [3279] = {.lex_state = 0, .external_lex_state = 4},
  [3280] = {.lex_state = 0, .external_lex_state = 4},
  [3281] = {.lex_state = 0, .external_lex_state = 4},
  [3282] = {.lex_state = 0, .external_lex_state = 4},
  [3283] = {.lex_state = 0, .external_lex_state = 4},
  [3284] = {.lex_state = 0, .external_lex_state = 4},
  [3285] = {.lex_state = 222, .external_lex_state = 4},
  [3286] = {.lex_state = 0, .external_lex_state = 4},
  [3287] = {.lex_state = 0, .external_lex_state = 4},
  [3288] = {.lex_state = 8, .external_lex_state = 4},
  [3289] = {.lex_state = 0, .external_lex_state = 4},
  [3290] = {.lex_state = 0, .external_lex_state = 4},
  [3291] = {.lex_state = 0, .external_lex_state = 4},
  [3292] = {.lex_state = 0, .external_lex_state = 4},
  [3293] = {.lex_state = 0, .external_lex_state = 10},
  [3294] = {.lex_state = 0, .external_lex_state = 4},
  [3295] = {.lex_state = 0, .external_lex_state = 4},
  [3296] = {.lex_state = 0, .external_lex_state = 4},
  [3297] = {.lex_state = 0, .external_lex_state = 4},
  [3298] = {.lex_state = 0, .external_lex_state = 4},
  [3299] = {.lex_state = 0, .external_lex_state = 4},
  [3300] = {.lex_state = 0, .external_lex_state = 4},
  [3301] = {.lex_state = 0, .external_lex_state = 4},
  [3302] = {.lex_state = 0, .external_lex_state = 4},
  [3303] = {.lex_state = 0, .external_lex_state = 4},
  [3304] = {.lex_state = 0, .external_lex_state = 4},
  [3305] = {.lex_state = 0, .external_lex_state = 4},
  [3306] = {.lex_state = 8, .external_lex_state = 4},
  [3307] = {.lex_state = 0, .external_lex_state = 4},
  [3308] = {.lex_state = 222, .external_lex_state = 4},
  [3309] = {.lex_state = 0, .external_lex_state = 4},
  [3310] = {.lex_state = 0, .external_lex_state = 4},
  [3311] = {.lex_state = 222, .external_lex_state = 4},
  [3312] = {.lex_state = 0, .external_lex_state = 4},
  [3313] = {.lex_state = 0, .external_lex_state = 4},
  [3314] = {.lex_state = 0, .external_lex_state = 4},
  [3315] = {.lex_state = 0, .external_lex_state = 4},
  [3316] = {.lex_state = 0, .external_lex_state = 4},
  [3317] = {.lex_state = 0, .external_lex_state = 4},
  [3318] = {.lex_state = 0, .external_lex_state = 4},
  [3319] = {.lex_state = 0, .external_lex_state = 4},
  [3320] = {.lex_state = 0, .external_lex_state = 4},
  [3321] = {.lex_state = 0, .external_lex_state = 4},
  [3322] = {.lex_state = 0, .external_lex_state = 4},
  [3323] = {.lex_state = 0, .external_lex_state = 4},
  [3324] = {.lex_state = 0, .external_lex_state = 4},
  [3325] = {.lex_state = 0, .external_lex_state = 4},
  [3326] = {.lex_state = 0, .external_lex_state = 4},
  [3327] = {.lex_state = 0, .external_lex_state = 4},
  [3328] = {.lex_state = 222, .external_lex_state = 4},
  [3329] = {.lex_state = 8, .external_lex_state = 4},
  [3330] = {.lex_state = 0, .external_lex_state = 4},
  [3331] = {.lex_state = 0, .external_lex_state = 4},
  [3332] = {.lex_state = 222, .external_lex_state = 4},
  [3333] = {.lex_state = 0, .external_lex_state = 4},
  [3334] = {.lex_state = 0, .external_lex_state = 10},
  [3335] = {.lex_state = 0, .external_lex_state = 4},
  [3336] = {.lex_state = 8, .external_lex_state = 4},
  [3337] = {.lex_state = 0, .external_lex_state = 4},
  [3338] = {.lex_state = 0, .external_lex_state = 4},
  [3339] = {.lex_state = 0, .external_lex_state = 4},
  [3340] = {.lex_state = 0, .external_lex_state = 4},
  [3341] = {.lex_state = 0, .external_lex_state = 4},
  [3342] = {.lex_state = 0, .external_lex_state = 4},
  [3343] = {.lex_state = 0, .external_lex_state = 4},
  [3344] = {.lex_state = 0, .external_lex_state = 4},
  [3345] = {.lex_state = 0, .external_lex_state = 4},
  [3346] = {.lex_state = 0, .external_lex_state = 4},
  [3347] = {.lex_state = 8, .external_lex_state = 4},
  [3348] = {.lex_state = 0, .external_lex_state = 4},
  [3349] = {.lex_state = 0, .external_lex_state = 4},
  [3350] = {.lex_state = 8, .external_lex_state = 4},
  [3351] = {.lex_state = 222, .external_lex_state = 4},
  [3352] = {.lex_state = 0, .external_lex_state = 4},
  [3353] = {.lex_state = 0, .external_lex_state = 4},
  [3354] = {.lex_state = 8, .external_lex_state = 4},
  [3355] = {.lex_state = 8, .external_lex_state = 4},
  [3356] = {.lex_state = 0, .external_lex_state = 4},
  [3357] = {.lex_state = 0, .external_lex_state = 4},
  [3358] = {.lex_state = 0, .external_lex_state = 4},
  [3359] = {.lex_state = 0, .external_lex_state = 4},
  [3360] = {.lex_state = 0, .external_lex_state = 4},
  [3361] = {.lex_state = 0, .external_lex_state = 4},
  [3362] = {.lex_state = 0, .external_lex_state = 4},
  [3363] = {.lex_state = 222, .external_lex_state = 4},
  [3364] = {.lex_state = 222, .external_lex_state = 4},
  [3365] = {.lex_state = 0, .external_lex_state = 4},
  [3366] = {.lex_state = 0, .external_lex_state = 4},
  [3367] = {.lex_state = 0, .external_lex_state = 4},
  [3368] = {.lex_state = 0, .external_lex_state = 4},
  [3369] = {.lex_state = 0, .external_lex_state = 4},
  [3370] = {.lex_state = 0, .external_lex_state = 4},
  [3371] = {.lex_state = 222, .external_lex_state = 4},
  [3372] = {.lex_state = 0, .external_lex_state = 4},
  [3373] = {.lex_state = 0, .external_lex_state = 4},
  [3374] = {.lex_state = 0, .external_lex_state = 4},
  [3375] = {.lex_state = 0, .external_lex_state = 4},
  [3376] = {.lex_state = 8, .external_lex_state = 4},
  [3377] = {.lex_state = 0, .external_lex_state = 4},
  [3378] = {.lex_state = 0, .external_lex_state = 4},
  [3379] = {.lex_state = 0, .external_lex_state = 4},
  [3380] = {.lex_state = 0, .external_lex_state = 4},
  [3381] = {.lex_state = 0, .external_lex_state = 4},
  [3382] = {.lex_state = 0, .external_lex_state = 10},
  [3383] = {.lex_state = 0, .external_lex_state = 4},
  [3384] = {.lex_state = 0, .external_lex_state = 10},
  [3385] = {.lex_state = 222, .external_lex_state = 4},
  [3386] = {.lex_state = 0, .external_lex_state = 4},
  [3387] = {.lex_state = 0, .external_lex_state = 4},
  [3388] = {.lex_state = 0, .external_lex_state = 4},
  [3389] = {.lex_state = 0, .external_lex_state = 4},
  [3390] = {.lex_state = 0, .external_lex_state = 4},
  [3391] = {.lex_state = 0, .external_lex_state = 4},
  [3392] = {.lex_state = 0, .external_lex_state = 4},
  [3393] = {.lex_state = 0, .external_lex_state = 4},
  [3394] = {.lex_state = 0, .external_lex_state = 4},
  [3395] = {.lex_state = 0, .external_lex_state = 4},
  [3396] = {.lex_state = 0, .external_lex_state = 4},
  [3397] = {.lex_state = 0, .external_lex_state = 4},
  [3398] = {.lex_state = 0, .external_lex_state = 4},
  [3399] = {.lex_state = 0, .external_lex_state = 4},
  [3400] = {.lex_state = 0, .external_lex_state = 4},
  [3401] = {.lex_state = 0, .external_lex_state = 4},
  [3402] = {(TSStateId)(-1)},
  [3403] = {(TSStateId)(-1)},
  [3404] = {(TSStateId)(-1)},
  [3405] = {(TSStateId)(-1)},
  [3406] = {(TSStateId)(-1)},
  [3407] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_decorator] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_open] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_rec] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_unpack] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_external] = ACTIONS(1),
    [anon_sym_exception] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_constraint] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_LBRACK_GT] = ACTIONS(1),
    [anon_sym_LBRACK_LT] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_mutable] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_when] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_PIPE_GT] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_lazy] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_to] = ACTIONS(1),
    [anon_sym_downto] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_PLUS_DOT] = ACTIONS(1),
    [anon_sym_DASH_DOT] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_STAR_DOT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_SLASH_DOT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_COLON_GT] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [aux_sym_variant_identifier_token1] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_unit_type] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_BSLASH_BQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym__newline] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym__newline_and_comment] = ACTIONS(1),
    [sym__template_chars] = ACTIONS(1),
    [sym__lparen] = ACTIONS(1),
    [sym__rparen] = ACTIONS(1),
    [sym__list_constructor] = ACTIONS(1),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [1] = {
    [sym_source_file] = STATE(3373),
    [sym__statement] = STATE(893),
    [sym__statement_delimeter] = STATE(872),
    [sym_statement] = STATE(2607),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1090),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym_object] = STATE(1090),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(1),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1047),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1090),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat1] = STATE(22),
    [aux_sym_source_file_repeat2] = STATE(39),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [ts_builtin_sym_end] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym__newline] = ACTIONS(11),
    [sym_comment] = ACTIONS(3),
    [sym__newline_and_comment] = ACTIONS(11),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [2] = {
    [sym__statement] = STATE(893),
    [sym__one_or_more_statements] = STATE(3318),
    [sym_statement] = STATE(2388),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1195),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym__record_element] = STATE(3279),
    [sym_record_field] = STATE(3061),
    [sym__record_pun_field] = STATE(3062),
    [sym__record_single_field] = STATE(3204),
    [sym__record_single_pun_field] = STATE(3204),
    [sym__record_field_name] = STATE(2816),
    [sym_object] = STATE(1090),
    [sym__object_field] = STATE(2898),
    [sym_object_field] = STATE(3066),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(2),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_spread_element] = STATE(3062),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1052),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1279),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(49),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(81),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_DOT] = ACTIONS(83),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(85),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_DOT_DOT] = ACTIONS(83),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [3] = {
    [sym__statement] = STATE(893),
    [sym__one_or_more_statements] = STATE(3392),
    [sym_statement] = STATE(2388),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1195),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym__record_element] = STATE(3302),
    [sym_record_field] = STATE(3061),
    [sym__record_pun_field] = STATE(3062),
    [sym__record_single_field] = STATE(3341),
    [sym__record_single_pun_field] = STATE(3341),
    [sym__record_field_name] = STATE(2816),
    [sym_object] = STATE(1090),
    [sym__object_field] = STATE(3016),
    [sym_object_field] = STATE(3066),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(3),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_spread_element] = STATE(3035),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1052),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1279),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(49),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(89),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_DOT] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(85),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_DOT_DOT] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [4] = {
    [sym__statement] = STATE(893),
    [sym__one_or_more_statements] = STATE(3187),
    [sym_statement] = STATE(2388),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1195),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym__record_element] = STATE(3321),
    [sym_record_field] = STATE(3061),
    [sym__record_pun_field] = STATE(3062),
    [sym__record_single_field] = STATE(3189),
    [sym__record_single_pun_field] = STATE(3189),
    [sym__record_field_name] = STATE(2816),
    [sym_object] = STATE(1090),
    [sym__object_field] = STATE(2915),
    [sym_object_field] = STATE(3066),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(4),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_spread_element] = STATE(3062),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1052),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1279),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(49),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(93),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_DOT] = ACTIONS(95),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(85),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_DOT_DOT] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [5] = {
    [sym__statement] = STATE(893),
    [sym__one_or_more_statements] = STATE(3324),
    [sym_statement] = STATE(2388),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1195),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym__record_element] = STATE(3302),
    [sym_record_field] = STATE(3061),
    [sym__record_pun_field] = STATE(3062),
    [sym__record_single_field] = STATE(3341),
    [sym__record_single_pun_field] = STATE(3341),
    [sym__record_field_name] = STATE(2816),
    [sym_object] = STATE(1090),
    [sym__object_field] = STATE(3016),
    [sym_object_field] = STATE(3066),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(5),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_spread_element] = STATE(3062),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1052),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1279),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(49),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(97),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_DOT] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(85),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_DOT_DOT] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [6] = {
    [sym__statement] = STATE(893),
    [sym__one_or_more_statements] = STATE(3320),
    [sym_statement] = STATE(2388),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1195),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym__record_element] = STATE(3313),
    [sym_record_field] = STATE(3061),
    [sym__record_pun_field] = STATE(3062),
    [sym__record_single_field] = STATE(3309),
    [sym__record_single_pun_field] = STATE(3309),
    [sym__record_field_name] = STATE(2816),
    [sym_object] = STATE(1090),
    [sym__object_field] = STATE(2817),
    [sym_object_field] = STATE(3066),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(6),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_spread_element] = STATE(3062),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1052),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1279),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(49),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(99),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_DOT] = ACTIONS(101),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(85),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_DOT_DOT] = ACTIONS(101),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [7] = {
    [sym__statement] = STATE(893),
    [sym__one_or_more_statements] = STATE(3277),
    [sym_statement] = STATE(2388),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1195),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym__record_element] = STATE(3176),
    [sym_record_field] = STATE(3061),
    [sym__record_pun_field] = STATE(3062),
    [sym__record_single_field] = STATE(3286),
    [sym__record_single_pun_field] = STATE(3286),
    [sym__record_field_name] = STATE(2816),
    [sym_object] = STATE(1090),
    [sym__object_field] = STATE(2828),
    [sym_object_field] = STATE(3066),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(7),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_spread_element] = STATE(3062),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1052),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1279),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(49),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(103),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_DOT] = ACTIONS(105),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(85),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_DOT_DOT] = ACTIONS(105),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [8] = {
    [sym__statement] = STATE(893),
    [sym__one_or_more_statements] = STATE(3318),
    [sym_statement] = STATE(2388),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1195),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym__record_element] = STATE(3176),
    [sym_record_field] = STATE(3061),
    [sym__record_pun_field] = STATE(3062),
    [sym__record_single_field] = STATE(3286),
    [sym__record_single_pun_field] = STATE(3286),
    [sym__record_field_name] = STATE(2816),
    [sym_object] = STATE(1090),
    [sym__object_field] = STATE(2828),
    [sym_object_field] = STATE(3066),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(8),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_spread_element] = STATE(3062),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1052),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1279),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(49),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(81),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_DOT] = ACTIONS(105),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(85),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_DOT_DOT] = ACTIONS(105),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [9] = {
    [sym__statement] = STATE(893),
    [sym__one_or_more_statements] = STATE(3277),
    [sym_statement] = STATE(2388),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1081),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym__record_element] = STATE(3176),
    [sym_record_field] = STATE(3061),
    [sym__record_pun_field] = STATE(3062),
    [sym__record_single_field] = STATE(3286),
    [sym__record_single_pun_field] = STATE(3286),
    [sym__record_field_name] = STATE(2816),
    [sym_object] = STATE(1090),
    [sym__object_field] = STATE(2828),
    [sym_object_field] = STATE(3066),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(9),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_spread_element] = STATE(3062),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1013),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1279),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(49),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(103),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_DOT] = ACTIONS(105),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(107),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_DOT_DOT] = ACTIONS(105),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [10] = {
    [sym__statement] = STATE(893),
    [sym__one_or_more_statements] = STATE(3156),
    [sym_statement] = STATE(2388),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1195),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym__record_element] = STATE(3252),
    [sym_record_field] = STATE(3061),
    [sym__record_pun_field] = STATE(3062),
    [sym__record_single_field] = STATE(3316),
    [sym__record_single_pun_field] = STATE(3316),
    [sym__record_field_name] = STATE(2816),
    [sym_object] = STATE(1090),
    [sym__object_field] = STATE(2813),
    [sym_object_field] = STATE(3066),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(10),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_spread_element] = STATE(3062),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1052),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1279),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(49),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(109),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_DOT] = ACTIONS(111),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(85),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_DOT_DOT] = ACTIONS(111),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [11] = {
    [sym_block] = STATE(1451),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1537),
    [sym_primary_expression] = STATE(1399),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_polyvar_type_pattern] = STATE(2034),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(1207),
    [sym__definition_signature] = STATE(3260),
    [sym_formal_parameters] = STATE(2800),
    [sym_parameter] = STATE(2836),
    [sym_labeled_parameter] = STATE(3079),
    [sym_abstract_type] = STATE(3079),
    [sym__pattern] = STATE(2552),
    [sym_parenthesized_pattern] = STATE(2034),
    [sym_range_pattern] = STATE(2034),
    [sym_or_pattern] = STATE(2034),
    [sym_exception_pattern] = STATE(2034),
    [sym__destructuring_pattern] = STATE(2034),
    [sym__literal_pattern] = STATE(1966),
    [sym_variant_pattern] = STATE(2116),
    [sym_polyvar_pattern] = STATE(2116),
    [sym_record_pattern] = STATE(2116),
    [sym_tuple_item_pattern] = STATE(3150),
    [sym_tuple_pattern] = STATE(2116),
    [sym_array_pattern] = STATE(2116),
    [sym_list_pattern] = STATE(2116),
    [sym_lazy_pattern] = STATE(2034),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3085),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(11),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(1049),
    [sym_polyvar] = STATE(999),
    [sym_module_expression] = STATE(2638),
    [sym_module_primary_expression] = STATE(2510),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_module_type_of] = STATE(2546),
    [sym_module_type_constraint] = STATE(2546),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1049),
    [sym_polyvar_identifier] = STATE(1046),
    [sym_value_identifier] = STATE(1040),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1205),
    [sym_string] = STATE(1057),
    [sym_template_string] = STATE(1057),
    [sym_character] = STATE(1057),
    [sym_uncurry] = STATE(582),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LPAREN] = ACTIONS(117),
    [anon_sym_RPAREN] = ACTIONS(119),
    [anon_sym_await] = ACTIONS(121),
    [anon_sym_module] = ACTIONS(123),
    [anon_sym_type] = ACTIONS(125),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_exception] = ACTIONS(129),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(133),
    [anon_sym_DASH] = ACTIONS(133),
    [anon_sym_DOT] = ACTIONS(135),
    [anon_sym_LBRACK] = ACTIONS(137),
    [anon_sym_QMARK] = ACTIONS(139),
    [anon_sym_async] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_lazy] = ACTIONS(155),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(133),
    [anon_sym_DASH_DOT] = ACTIONS(133),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(165),
    [sym_true] = ACTIONS(167),
    [sym_false] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [aux_sym_template_string_token1] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(175),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [12] = {
    [sym_block] = STATE(1451),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1537),
    [sym_primary_expression] = STATE(1399),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_polyvar_type_pattern] = STATE(2034),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(1207),
    [sym__definition_signature] = STATE(3260),
    [sym_formal_parameters] = STATE(2800),
    [sym_parameter] = STATE(2836),
    [sym_labeled_parameter] = STATE(3079),
    [sym_abstract_type] = STATE(3079),
    [sym__pattern] = STATE(2552),
    [sym_parenthesized_pattern] = STATE(2034),
    [sym_range_pattern] = STATE(2034),
    [sym_or_pattern] = STATE(2034),
    [sym_exception_pattern] = STATE(2034),
    [sym__destructuring_pattern] = STATE(2034),
    [sym__literal_pattern] = STATE(1966),
    [sym_variant_pattern] = STATE(2116),
    [sym_polyvar_pattern] = STATE(2116),
    [sym_record_pattern] = STATE(2116),
    [sym_tuple_item_pattern] = STATE(3150),
    [sym_tuple_pattern] = STATE(2116),
    [sym_array_pattern] = STATE(2116),
    [sym_list_pattern] = STATE(2116),
    [sym_lazy_pattern] = STATE(2034),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3085),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(12),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(1049),
    [sym_polyvar] = STATE(999),
    [sym_module_expression] = STATE(2596),
    [sym_module_primary_expression] = STATE(2510),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_module_type_of] = STATE(2546),
    [sym_module_type_constraint] = STATE(2546),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1049),
    [sym_polyvar_identifier] = STATE(1046),
    [sym_value_identifier] = STATE(1040),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1205),
    [sym_string] = STATE(1057),
    [sym_template_string] = STATE(1057),
    [sym_character] = STATE(1057),
    [sym_uncurry] = STATE(582),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LPAREN] = ACTIONS(117),
    [anon_sym_RPAREN] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(121),
    [anon_sym_module] = ACTIONS(123),
    [anon_sym_type] = ACTIONS(125),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_exception] = ACTIONS(129),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(133),
    [anon_sym_DASH] = ACTIONS(133),
    [anon_sym_DOT] = ACTIONS(135),
    [anon_sym_LBRACK] = ACTIONS(137),
    [anon_sym_QMARK] = ACTIONS(139),
    [anon_sym_async] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_lazy] = ACTIONS(155),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(133),
    [anon_sym_DASH_DOT] = ACTIONS(133),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(165),
    [sym_true] = ACTIONS(167),
    [sym_false] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [aux_sym_template_string_token1] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(175),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [13] = {
    [sym_block] = STATE(1451),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1537),
    [sym_primary_expression] = STATE(1399),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_polyvar_type_pattern] = STATE(2034),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(1207),
    [sym__definition_signature] = STATE(3260),
    [sym_formal_parameters] = STATE(2800),
    [sym_parameter] = STATE(2836),
    [sym_labeled_parameter] = STATE(3079),
    [sym_abstract_type] = STATE(3079),
    [sym__pattern] = STATE(2552),
    [sym_parenthesized_pattern] = STATE(2034),
    [sym_range_pattern] = STATE(2034),
    [sym_or_pattern] = STATE(2034),
    [sym_exception_pattern] = STATE(2034),
    [sym__destructuring_pattern] = STATE(2034),
    [sym__literal_pattern] = STATE(1966),
    [sym_variant_pattern] = STATE(2116),
    [sym_polyvar_pattern] = STATE(2116),
    [sym_record_pattern] = STATE(2116),
    [sym_tuple_item_pattern] = STATE(3150),
    [sym_tuple_pattern] = STATE(2116),
    [sym_array_pattern] = STATE(2116),
    [sym_list_pattern] = STATE(2116),
    [sym_lazy_pattern] = STATE(2034),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3085),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(13),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(1049),
    [sym_polyvar] = STATE(999),
    [sym_module_expression] = STATE(2596),
    [sym_module_primary_expression] = STATE(2510),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_module_type_of] = STATE(2546),
    [sym_module_type_constraint] = STATE(2546),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1049),
    [sym_polyvar_identifier] = STATE(1046),
    [sym_value_identifier] = STATE(1040),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1205),
    [sym_string] = STATE(1057),
    [sym_template_string] = STATE(1057),
    [sym_character] = STATE(1057),
    [sym_uncurry] = STATE(582),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LPAREN] = ACTIONS(117),
    [anon_sym_RPAREN] = ACTIONS(119),
    [anon_sym_await] = ACTIONS(121),
    [anon_sym_module] = ACTIONS(123),
    [anon_sym_type] = ACTIONS(125),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_exception] = ACTIONS(129),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(133),
    [anon_sym_DASH] = ACTIONS(133),
    [anon_sym_DOT] = ACTIONS(135),
    [anon_sym_LBRACK] = ACTIONS(137),
    [anon_sym_QMARK] = ACTIONS(139),
    [anon_sym_async] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_lazy] = ACTIONS(155),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(133),
    [anon_sym_DASH_DOT] = ACTIONS(133),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(165),
    [sym_true] = ACTIONS(167),
    [sym_false] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [aux_sym_template_string_token1] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(175),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [14] = {
    [sym_block] = STATE(1451),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1550),
    [sym_primary_expression] = STATE(1399),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_polyvar_type_pattern] = STATE(2034),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(1207),
    [sym__definition_signature] = STATE(3260),
    [sym_formal_parameters] = STATE(2800),
    [sym_parameter] = STATE(2836),
    [sym_labeled_parameter] = STATE(3079),
    [sym_abstract_type] = STATE(3079),
    [sym__pattern] = STATE(2626),
    [sym_parenthesized_pattern] = STATE(2034),
    [sym_range_pattern] = STATE(2034),
    [sym_or_pattern] = STATE(2034),
    [sym_exception_pattern] = STATE(2034),
    [sym__destructuring_pattern] = STATE(2034),
    [sym__literal_pattern] = STATE(1966),
    [sym_variant_pattern] = STATE(2116),
    [sym_polyvar_pattern] = STATE(2116),
    [sym_record_pattern] = STATE(2116),
    [sym_tuple_pattern] = STATE(2116),
    [sym_array_pattern] = STATE(2116),
    [sym_list_pattern] = STATE(2116),
    [sym_lazy_pattern] = STATE(2034),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3085),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(14),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(1049),
    [sym_polyvar] = STATE(999),
    [sym_module_expression] = STATE(2596),
    [sym_module_primary_expression] = STATE(2510),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_module_type_of] = STATE(2546),
    [sym_module_type_constraint] = STATE(2546),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1049),
    [sym_polyvar_identifier] = STATE(1046),
    [sym_value_identifier] = STATE(1040),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1205),
    [sym_string] = STATE(1057),
    [sym_template_string] = STATE(1057),
    [sym_character] = STATE(1057),
    [sym_uncurry] = STATE(582),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LPAREN] = ACTIONS(117),
    [anon_sym_RPAREN] = ACTIONS(179),
    [anon_sym_await] = ACTIONS(121),
    [anon_sym_module] = ACTIONS(123),
    [anon_sym_type] = ACTIONS(125),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_exception] = ACTIONS(129),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(133),
    [anon_sym_DASH] = ACTIONS(133),
    [anon_sym_DOT] = ACTIONS(135),
    [anon_sym_LBRACK] = ACTIONS(137),
    [anon_sym_QMARK] = ACTIONS(139),
    [anon_sym_async] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_lazy] = ACTIONS(155),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(133),
    [anon_sym_DASH_DOT] = ACTIONS(133),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(165),
    [sym_true] = ACTIONS(167),
    [sym_false] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [aux_sym_template_string_token1] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(175),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [15] = {
    [sym_block] = STATE(1451),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1546),
    [sym_primary_expression] = STATE(1399),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_polyvar_type_pattern] = STATE(2034),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(1207),
    [sym__definition_signature] = STATE(3260),
    [sym_formal_parameters] = STATE(2800),
    [sym_parameter] = STATE(2836),
    [sym_labeled_parameter] = STATE(3079),
    [sym_abstract_type] = STATE(3079),
    [sym__pattern] = STATE(2626),
    [sym_parenthesized_pattern] = STATE(2034),
    [sym_range_pattern] = STATE(2034),
    [sym_or_pattern] = STATE(2034),
    [sym_exception_pattern] = STATE(2034),
    [sym__destructuring_pattern] = STATE(2034),
    [sym__literal_pattern] = STATE(1966),
    [sym_variant_pattern] = STATE(2116),
    [sym_polyvar_pattern] = STATE(2116),
    [sym_record_pattern] = STATE(2116),
    [sym_tuple_pattern] = STATE(2116),
    [sym_array_pattern] = STATE(2116),
    [sym_list_pattern] = STATE(2116),
    [sym_lazy_pattern] = STATE(2034),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3085),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(15),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(1049),
    [sym_polyvar] = STATE(999),
    [sym_module_expression] = STATE(2596),
    [sym_module_primary_expression] = STATE(2510),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_module_type_of] = STATE(2546),
    [sym_module_type_constraint] = STATE(2546),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1049),
    [sym_polyvar_identifier] = STATE(1046),
    [sym_value_identifier] = STATE(1040),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1205),
    [sym_string] = STATE(1057),
    [sym_template_string] = STATE(1057),
    [sym_character] = STATE(1057),
    [sym_uncurry] = STATE(582),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LPAREN] = ACTIONS(117),
    [anon_sym_RPAREN] = ACTIONS(181),
    [anon_sym_await] = ACTIONS(121),
    [anon_sym_module] = ACTIONS(123),
    [anon_sym_type] = ACTIONS(125),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_exception] = ACTIONS(129),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(133),
    [anon_sym_DASH] = ACTIONS(133),
    [anon_sym_DOT] = ACTIONS(135),
    [anon_sym_LBRACK] = ACTIONS(137),
    [anon_sym_QMARK] = ACTIONS(139),
    [anon_sym_async] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_lazy] = ACTIONS(155),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(133),
    [anon_sym_DASH_DOT] = ACTIONS(133),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(165),
    [sym_true] = ACTIONS(167),
    [sym_false] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [aux_sym_template_string_token1] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(175),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [16] = {
    [sym_block] = STATE(1451),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1536),
    [sym_primary_expression] = STATE(1399),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_polyvar_type_pattern] = STATE(2034),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(1207),
    [sym__definition_signature] = STATE(3260),
    [sym_formal_parameters] = STATE(2800),
    [sym_parameter] = STATE(2836),
    [sym_labeled_parameter] = STATE(3079),
    [sym_abstract_type] = STATE(3079),
    [sym__pattern] = STATE(2626),
    [sym_parenthesized_pattern] = STATE(2034),
    [sym_range_pattern] = STATE(2034),
    [sym_or_pattern] = STATE(2034),
    [sym_exception_pattern] = STATE(2034),
    [sym__destructuring_pattern] = STATE(2034),
    [sym__literal_pattern] = STATE(1966),
    [sym_variant_pattern] = STATE(2116),
    [sym_polyvar_pattern] = STATE(2116),
    [sym_record_pattern] = STATE(2116),
    [sym_tuple_pattern] = STATE(2116),
    [sym_array_pattern] = STATE(2116),
    [sym_list_pattern] = STATE(2116),
    [sym_lazy_pattern] = STATE(2034),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3085),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(16),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(1049),
    [sym_polyvar] = STATE(999),
    [sym_module_expression] = STATE(2596),
    [sym_module_primary_expression] = STATE(2510),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_module_type_of] = STATE(2546),
    [sym_module_type_constraint] = STATE(2546),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1049),
    [sym_polyvar_identifier] = STATE(1046),
    [sym_value_identifier] = STATE(1040),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1205),
    [sym_string] = STATE(1057),
    [sym_template_string] = STATE(1057),
    [sym_character] = STATE(1057),
    [sym_uncurry] = STATE(582),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LPAREN] = ACTIONS(117),
    [anon_sym_RPAREN] = ACTIONS(183),
    [anon_sym_await] = ACTIONS(121),
    [anon_sym_module] = ACTIONS(123),
    [anon_sym_type] = ACTIONS(125),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_exception] = ACTIONS(129),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(133),
    [anon_sym_DASH] = ACTIONS(133),
    [anon_sym_DOT] = ACTIONS(135),
    [anon_sym_LBRACK] = ACTIONS(137),
    [anon_sym_QMARK] = ACTIONS(139),
    [anon_sym_async] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_lazy] = ACTIONS(155),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(133),
    [anon_sym_DASH_DOT] = ACTIONS(133),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(165),
    [sym_true] = ACTIONS(167),
    [sym_false] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [aux_sym_template_string_token1] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(175),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [17] = {
    [sym_block] = STATE(1451),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1537),
    [sym_primary_expression] = STATE(1399),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_polyvar_type_pattern] = STATE(2034),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(1207),
    [sym__definition_signature] = STATE(3260),
    [sym_formal_parameters] = STATE(2800),
    [sym_parameter] = STATE(2836),
    [sym_labeled_parameter] = STATE(3079),
    [sym_abstract_type] = STATE(3079),
    [sym__pattern] = STATE(2626),
    [sym_parenthesized_pattern] = STATE(2034),
    [sym_range_pattern] = STATE(2034),
    [sym_or_pattern] = STATE(2034),
    [sym_exception_pattern] = STATE(2034),
    [sym__destructuring_pattern] = STATE(2034),
    [sym__literal_pattern] = STATE(1966),
    [sym_variant_pattern] = STATE(2116),
    [sym_polyvar_pattern] = STATE(2116),
    [sym_record_pattern] = STATE(2116),
    [sym_tuple_pattern] = STATE(2116),
    [sym_array_pattern] = STATE(2116),
    [sym_list_pattern] = STATE(2116),
    [sym_lazy_pattern] = STATE(2034),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3085),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(17),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(1049),
    [sym_polyvar] = STATE(999),
    [sym_module_expression] = STATE(2596),
    [sym_module_primary_expression] = STATE(2510),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_module_type_of] = STATE(2546),
    [sym_module_type_constraint] = STATE(2546),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1049),
    [sym_polyvar_identifier] = STATE(1046),
    [sym_value_identifier] = STATE(1040),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1205),
    [sym_string] = STATE(1057),
    [sym_template_string] = STATE(1057),
    [sym_character] = STATE(1057),
    [sym_uncurry] = STATE(582),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LPAREN] = ACTIONS(117),
    [anon_sym_RPAREN] = ACTIONS(185),
    [anon_sym_await] = ACTIONS(121),
    [anon_sym_module] = ACTIONS(123),
    [anon_sym_type] = ACTIONS(125),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_exception] = ACTIONS(129),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(133),
    [anon_sym_DASH] = ACTIONS(133),
    [anon_sym_DOT] = ACTIONS(135),
    [anon_sym_LBRACK] = ACTIONS(137),
    [anon_sym_QMARK] = ACTIONS(139),
    [anon_sym_async] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_lazy] = ACTIONS(155),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(133),
    [anon_sym_DASH_DOT] = ACTIONS(133),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(165),
    [sym_true] = ACTIONS(167),
    [sym_false] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [aux_sym_template_string_token1] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(175),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [18] = {
    [sym_block] = STATE(1451),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1539),
    [sym_primary_expression] = STATE(1399),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_polyvar_type_pattern] = STATE(2034),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(1207),
    [sym__definition_signature] = STATE(3260),
    [sym_formal_parameters] = STATE(2800),
    [sym_parameter] = STATE(2836),
    [sym_labeled_parameter] = STATE(3079),
    [sym_abstract_type] = STATE(3079),
    [sym__pattern] = STATE(2626),
    [sym_parenthesized_pattern] = STATE(2034),
    [sym_range_pattern] = STATE(2034),
    [sym_or_pattern] = STATE(2034),
    [sym_exception_pattern] = STATE(2034),
    [sym__destructuring_pattern] = STATE(2034),
    [sym__literal_pattern] = STATE(1966),
    [sym_variant_pattern] = STATE(2116),
    [sym_polyvar_pattern] = STATE(2116),
    [sym_record_pattern] = STATE(2116),
    [sym_tuple_pattern] = STATE(2116),
    [sym_array_pattern] = STATE(2116),
    [sym_list_pattern] = STATE(2116),
    [sym_lazy_pattern] = STATE(2034),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3085),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(18),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(1049),
    [sym_polyvar] = STATE(999),
    [sym_module_expression] = STATE(2596),
    [sym_module_primary_expression] = STATE(2510),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_module_type_of] = STATE(2546),
    [sym_module_type_constraint] = STATE(2546),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1049),
    [sym_polyvar_identifier] = STATE(1046),
    [sym_value_identifier] = STATE(1040),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1205),
    [sym_string] = STATE(1057),
    [sym_template_string] = STATE(1057),
    [sym_character] = STATE(1057),
    [sym_uncurry] = STATE(582),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LPAREN] = ACTIONS(117),
    [anon_sym_RPAREN] = ACTIONS(187),
    [anon_sym_await] = ACTIONS(121),
    [anon_sym_module] = ACTIONS(123),
    [anon_sym_type] = ACTIONS(125),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_exception] = ACTIONS(129),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(133),
    [anon_sym_DASH] = ACTIONS(133),
    [anon_sym_DOT] = ACTIONS(135),
    [anon_sym_LBRACK] = ACTIONS(137),
    [anon_sym_QMARK] = ACTIONS(139),
    [anon_sym_async] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_lazy] = ACTIONS(155),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(133),
    [anon_sym_DASH_DOT] = ACTIONS(133),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(165),
    [sym_true] = ACTIONS(167),
    [sym_false] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [aux_sym_template_string_token1] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(175),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [19] = {
    [sym_block] = STATE(1451),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1537),
    [sym_primary_expression] = STATE(1399),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_polyvar_type_pattern] = STATE(2034),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(1207),
    [sym__definition_signature] = STATE(3260),
    [sym_formal_parameters] = STATE(2800),
    [sym_parameter] = STATE(2836),
    [sym_labeled_parameter] = STATE(3079),
    [sym_abstract_type] = STATE(3079),
    [sym__pattern] = STATE(2626),
    [sym_parenthesized_pattern] = STATE(2034),
    [sym_range_pattern] = STATE(2034),
    [sym_or_pattern] = STATE(2034),
    [sym_exception_pattern] = STATE(2034),
    [sym__destructuring_pattern] = STATE(2034),
    [sym__literal_pattern] = STATE(1966),
    [sym_variant_pattern] = STATE(2116),
    [sym_polyvar_pattern] = STATE(2116),
    [sym_record_pattern] = STATE(2116),
    [sym_tuple_pattern] = STATE(2116),
    [sym_array_pattern] = STATE(2116),
    [sym_list_pattern] = STATE(2116),
    [sym_lazy_pattern] = STATE(2034),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3085),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(19),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(1049),
    [sym_polyvar] = STATE(999),
    [sym_module_expression] = STATE(2596),
    [sym_module_primary_expression] = STATE(2510),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_module_type_of] = STATE(2546),
    [sym_module_type_constraint] = STATE(2546),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1049),
    [sym_polyvar_identifier] = STATE(1046),
    [sym_value_identifier] = STATE(1040),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1205),
    [sym_string] = STATE(1057),
    [sym_template_string] = STATE(1057),
    [sym_character] = STATE(1057),
    [sym_uncurry] = STATE(582),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LPAREN] = ACTIONS(117),
    [anon_sym_RPAREN] = ACTIONS(119),
    [anon_sym_await] = ACTIONS(121),
    [anon_sym_module] = ACTIONS(123),
    [anon_sym_type] = ACTIONS(125),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_exception] = ACTIONS(129),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(133),
    [anon_sym_DASH] = ACTIONS(133),
    [anon_sym_DOT] = ACTIONS(135),
    [anon_sym_LBRACK] = ACTIONS(137),
    [anon_sym_QMARK] = ACTIONS(139),
    [anon_sym_async] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_lazy] = ACTIONS(155),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(133),
    [anon_sym_DASH_DOT] = ACTIONS(133),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(165),
    [sym_true] = ACTIONS(167),
    [sym_false] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [aux_sym_template_string_token1] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(175),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [20] = {
    [sym_block] = STATE(1451),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1537),
    [sym_primary_expression] = STATE(1399),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_polyvar_type_pattern] = STATE(2034),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(1207),
    [sym__definition_signature] = STATE(3260),
    [sym_formal_parameters] = STATE(2800),
    [sym_parameter] = STATE(2836),
    [sym_labeled_parameter] = STATE(3079),
    [sym_abstract_type] = STATE(3079),
    [sym__pattern] = STATE(2626),
    [sym_parenthesized_pattern] = STATE(2034),
    [sym_range_pattern] = STATE(2034),
    [sym_or_pattern] = STATE(2034),
    [sym_exception_pattern] = STATE(2034),
    [sym__destructuring_pattern] = STATE(2034),
    [sym__literal_pattern] = STATE(1966),
    [sym_variant_pattern] = STATE(2116),
    [sym_polyvar_pattern] = STATE(2116),
    [sym_record_pattern] = STATE(2116),
    [sym_tuple_pattern] = STATE(2116),
    [sym_array_pattern] = STATE(2116),
    [sym_list_pattern] = STATE(2116),
    [sym_lazy_pattern] = STATE(2034),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3085),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(20),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(1049),
    [sym_polyvar] = STATE(999),
    [sym_module_expression] = STATE(2596),
    [sym_module_primary_expression] = STATE(2510),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_module_type_of] = STATE(2546),
    [sym_module_type_constraint] = STATE(2546),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1049),
    [sym_polyvar_identifier] = STATE(1046),
    [sym_value_identifier] = STATE(1040),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1205),
    [sym_string] = STATE(1057),
    [sym_template_string] = STATE(1057),
    [sym_character] = STATE(1057),
    [sym_uncurry] = STATE(582),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LPAREN] = ACTIONS(117),
    [anon_sym_RPAREN] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(121),
    [anon_sym_module] = ACTIONS(123),
    [anon_sym_type] = ACTIONS(125),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_exception] = ACTIONS(129),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(133),
    [anon_sym_DASH] = ACTIONS(133),
    [anon_sym_DOT] = ACTIONS(135),
    [anon_sym_LBRACK] = ACTIONS(137),
    [anon_sym_QMARK] = ACTIONS(139),
    [anon_sym_async] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_lazy] = ACTIONS(155),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(133),
    [anon_sym_DASH_DOT] = ACTIONS(133),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(165),
    [sym_true] = ACTIONS(167),
    [sym_false] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [aux_sym_template_string_token1] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(175),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [21] = {
    [sym_block] = STATE(1451),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1538),
    [sym_primary_expression] = STATE(1399),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_polyvar_type_pattern] = STATE(2034),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(1207),
    [sym__definition_signature] = STATE(3260),
    [sym_formal_parameters] = STATE(2800),
    [sym_parameter] = STATE(2836),
    [sym_labeled_parameter] = STATE(3079),
    [sym_abstract_type] = STATE(3079),
    [sym__pattern] = STATE(2626),
    [sym_parenthesized_pattern] = STATE(2034),
    [sym_range_pattern] = STATE(2034),
    [sym_or_pattern] = STATE(2034),
    [sym_exception_pattern] = STATE(2034),
    [sym__destructuring_pattern] = STATE(2034),
    [sym__literal_pattern] = STATE(1966),
    [sym_variant_pattern] = STATE(2116),
    [sym_polyvar_pattern] = STATE(2116),
    [sym_record_pattern] = STATE(2116),
    [sym_tuple_pattern] = STATE(2116),
    [sym_array_pattern] = STATE(2116),
    [sym_list_pattern] = STATE(2116),
    [sym_lazy_pattern] = STATE(2034),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3085),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(21),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(1049),
    [sym_polyvar] = STATE(999),
    [sym_module_expression] = STATE(2596),
    [sym_module_primary_expression] = STATE(2510),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_module_type_of] = STATE(2546),
    [sym_module_type_constraint] = STATE(2546),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1049),
    [sym_polyvar_identifier] = STATE(1046),
    [sym_value_identifier] = STATE(1040),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1205),
    [sym_string] = STATE(1057),
    [sym_template_string] = STATE(1057),
    [sym_character] = STATE(1057),
    [sym_uncurry] = STATE(582),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LPAREN] = ACTIONS(117),
    [anon_sym_RPAREN] = ACTIONS(189),
    [anon_sym_await] = ACTIONS(121),
    [anon_sym_module] = ACTIONS(123),
    [anon_sym_type] = ACTIONS(125),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_exception] = ACTIONS(129),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(133),
    [anon_sym_DASH] = ACTIONS(133),
    [anon_sym_DOT] = ACTIONS(135),
    [anon_sym_LBRACK] = ACTIONS(137),
    [anon_sym_QMARK] = ACTIONS(139),
    [anon_sym_async] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_lazy] = ACTIONS(155),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(133),
    [anon_sym_DASH_DOT] = ACTIONS(133),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(165),
    [sym_true] = ACTIONS(167),
    [sym_false] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [aux_sym_template_string_token1] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(175),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [22] = {
    [sym__statement] = STATE(893),
    [sym__statement_delimeter] = STATE(872),
    [sym_statement] = STATE(2607),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1090),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym_object] = STATE(1090),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(22),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1047),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1090),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat1] = STATE(783),
    [aux_sym_source_file_repeat2] = STATE(42),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [ts_builtin_sym_end] = ACTIONS(191),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym__newline] = ACTIONS(11),
    [sym_comment] = ACTIONS(3),
    [sym__newline_and_comment] = ACTIONS(11),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [23] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1602),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym__list_element] = STATE(2803),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_polyvar_type_pattern] = STATE(2487),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(1198),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__pattern] = STATE(2481),
    [sym_parenthesized_pattern] = STATE(2487),
    [sym_range_pattern] = STATE(2487),
    [sym_or_pattern] = STATE(2487),
    [sym_exception_pattern] = STATE(2487),
    [sym__destructuring_pattern] = STATE(2487),
    [sym__literal_pattern] = STATE(2386),
    [sym_variant_pattern] = STATE(2116),
    [sym_polyvar_pattern] = STATE(2116),
    [sym_record_pattern] = STATE(2116),
    [sym_tuple_pattern] = STATE(2116),
    [sym_array_pattern] = STATE(2116),
    [sym_list_pattern] = STATE(2116),
    [sym__collection_element_pattern] = STATE(2946),
    [sym_spread_pattern] = STATE(2619),
    [sym_lazy_pattern] = STATE(2487),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(23),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_spread_element] = STATE(3122),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(1049),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1049),
    [sym_polyvar_identifier] = STATE(1046),
    [sym_value_identifier] = STATE(1043),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1198),
    [sym_string] = STATE(1057),
    [sym_template_string] = STATE(1057),
    [sym_character] = STATE(1057),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_RBRACE] = ACTIONS(193),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(197),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_exception] = ACTIONS(203),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(137),
    [anon_sym_QMARK] = ACTIONS(139),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_async] = ACTIONS(209),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(165),
    [sym_true] = ACTIONS(167),
    [sym_false] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [aux_sym_template_string_token1] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(175),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [24] = {
    [sym__statement] = STATE(893),
    [sym__one_or_more_statements] = STATE(3237),
    [sym_statement] = STATE(2388),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1090),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym_object] = STATE(1090),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(24),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_spread_element] = STATE(3237),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1047),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1090),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(49),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(215),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [25] = {
    [sym__statement] = STATE(893),
    [sym__one_or_more_statements] = STATE(3396),
    [sym_statement] = STATE(2388),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1090),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym_object] = STATE(1090),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(25),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1047),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1090),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(49),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(217),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [26] = {
    [sym__statement] = STATE(893),
    [sym__one_or_more_statements] = STATE(3156),
    [sym_statement] = STATE(2388),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1090),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym_object] = STATE(1090),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(26),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1047),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1090),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(49),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(109),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [27] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1572),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_polyvar_type_pattern] = STATE(2487),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(1198),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__pattern] = STATE(2481),
    [sym_parenthesized_pattern] = STATE(2487),
    [sym_range_pattern] = STATE(2487),
    [sym_or_pattern] = STATE(2487),
    [sym_exception_pattern] = STATE(2487),
    [sym__destructuring_pattern] = STATE(2487),
    [sym__literal_pattern] = STATE(2386),
    [sym_variant_pattern] = STATE(2116),
    [sym_polyvar_pattern] = STATE(2116),
    [sym_record_pattern] = STATE(2116),
    [sym_tuple_pattern] = STATE(2116),
    [sym_array_pattern] = STATE(2116),
    [sym_list_pattern] = STATE(2116),
    [sym__collection_element_pattern] = STATE(2961),
    [sym_spread_pattern] = STATE(2619),
    [sym_lazy_pattern] = STATE(2487),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(27),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(1049),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1049),
    [sym_polyvar_identifier] = STATE(1046),
    [sym_value_identifier] = STATE(1043),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1198),
    [sym_string] = STATE(1057),
    [sym_template_string] = STATE(1057),
    [sym_character] = STATE(1057),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(197),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_exception] = ACTIONS(203),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(137),
    [anon_sym_RBRACK] = ACTIONS(219),
    [anon_sym_QMARK] = ACTIONS(139),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_async] = ACTIONS(209),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(165),
    [sym_true] = ACTIONS(167),
    [sym_false] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [aux_sym_template_string_token1] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(175),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [28] = {
    [sym__statement] = STATE(893),
    [sym__one_or_more_statements] = STATE(3318),
    [sym_statement] = STATE(2388),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1090),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym_object] = STATE(1090),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(28),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1047),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1090),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(49),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(81),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [29] = {
    [sym__statement] = STATE(893),
    [sym__one_or_more_statements] = STATE(3277),
    [sym_statement] = STATE(2388),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1090),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym_object] = STATE(1090),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(29),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1047),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1090),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(49),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(103),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [30] = {
    [sym__statement] = STATE(893),
    [sym__one_or_more_statements] = STATE(3320),
    [sym_statement] = STATE(2388),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1090),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym_object] = STATE(1090),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(30),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1047),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1090),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(49),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(99),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [31] = {
    [sym__statement] = STATE(893),
    [sym__one_or_more_statements] = STATE(3324),
    [sym_statement] = STATE(2388),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1090),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym_object] = STATE(1090),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(31),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1047),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1090),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(49),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(97),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [32] = {
    [sym__statement] = STATE(893),
    [sym__one_or_more_statements] = STATE(3187),
    [sym_statement] = STATE(2388),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1090),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym_object] = STATE(1090),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(32),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1047),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1090),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(49),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(93),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [33] = {
    [sym__statement] = STATE(893),
    [sym__one_or_more_statements] = STATE(3389),
    [sym_statement] = STATE(2388),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1090),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym_object] = STATE(1090),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(33),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1047),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1090),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(49),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(223),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [34] = {
    [sym__statement] = STATE(893),
    [sym__one_or_more_statements] = STATE(3349),
    [sym_statement] = STATE(2388),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1090),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym_object] = STATE(1090),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(34),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1047),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1090),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(49),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(225),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [35] = {
    [sym__statement] = STATE(893),
    [sym__one_or_more_statements] = STATE(3137),
    [sym_statement] = STATE(2388),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1090),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym_object] = STATE(1090),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(35),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1047),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1090),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(48),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_open] = ACTIONS(227),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(229),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(231),
    [anon_sym_type] = ACTIONS(233),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(235),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_let] = ACTIONS(237),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [36] = {
    [sym__statement] = STATE(893),
    [sym__one_or_more_statements] = STATE(3083),
    [sym_statement] = STATE(2466),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1090),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym_object] = STATE(1090),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(36),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1047),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1090),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(46),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [37] = {
    [sym__statement] = STATE(893),
    [sym__one_or_more_statements] = STATE(3126),
    [sym_statement] = STATE(2466),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1090),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym_object] = STATE(1090),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(37),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1047),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1090),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(46),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [38] = {
    [sym__statement] = STATE(893),
    [sym__one_or_more_statements] = STATE(3102),
    [sym_statement] = STATE(2388),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1090),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym_object] = STATE(1090),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(38),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1047),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1090),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(48),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_open] = ACTIONS(227),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(229),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(231),
    [anon_sym_type] = ACTIONS(233),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(235),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_let] = ACTIONS(237),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [39] = {
    [sym__statement] = STATE(893),
    [sym_statement] = STATE(2607),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1090),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym_object] = STATE(1090),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(39),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1047),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1090),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(41),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [ts_builtin_sym_end] = ACTIONS(191),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [40] = {
    [sym__statement] = STATE(893),
    [sym__one_or_more_statements] = STATE(3040),
    [sym_statement] = STATE(2466),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1090),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym_object] = STATE(1090),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(40),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1047),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1090),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(46),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [41] = {
    [sym__statement] = STATE(893),
    [sym_statement] = STATE(2607),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1090),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym_object] = STATE(1090),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(41),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1047),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1090),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(41),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [ts_builtin_sym_end] = ACTIONS(239),
    [anon_sym_LBRACE] = ACTIONS(241),
    [anon_sym_open] = ACTIONS(244),
    [anon_sym_BANG] = ACTIONS(247),
    [anon_sym_include] = ACTIONS(250),
    [anon_sym_LPAREN] = ACTIONS(253),
    [anon_sym_await] = ACTIONS(256),
    [anon_sym_module] = ACTIONS(259),
    [anon_sym_type] = ACTIONS(262),
    [anon_sym_unpack] = ACTIONS(265),
    [anon_sym_external] = ACTIONS(268),
    [anon_sym_exception] = ACTIONS(271),
    [anon_sym_export] = ACTIONS(274),
    [anon_sym_LT] = ACTIONS(277),
    [anon_sym_PLUS] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_LBRACK] = ACTIONS(283),
    [anon_sym_let] = ACTIONS(286),
    [anon_sym_async] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(292),
    [anon_sym_switch] = ACTIONS(295),
    [anon_sym_POUND] = ACTIONS(298),
    [anon_sym_try] = ACTIONS(301),
    [anon_sym_assert] = ACTIONS(304),
    [anon_sym_lazy] = ACTIONS(307),
    [anon_sym_for] = ACTIONS(310),
    [anon_sym_while] = ACTIONS(313),
    [anon_sym_PLUS_DOT] = ACTIONS(280),
    [anon_sym_DASH_DOT] = ACTIONS(280),
    [anon_sym_PERCENT] = ACTIONS(316),
    [aux_sym_variant_identifier_token1] = ACTIONS(319),
    [aux_sym_value_identifier_token1] = ACTIONS(322),
    [sym__escape_identifier] = ACTIONS(322),
    [sym_number] = ACTIONS(325),
    [sym_true] = ACTIONS(328),
    [sym_false] = ACTIONS(328),
    [anon_sym_DQUOTE] = ACTIONS(331),
    [aux_sym_template_string_token1] = ACTIONS(334),
    [anon_sym_SQUOTE] = ACTIONS(337),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(340),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [42] = {
    [sym__statement] = STATE(893),
    [sym_statement] = STATE(2607),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1090),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym_object] = STATE(1090),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(42),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1047),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1090),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(41),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [ts_builtin_sym_end] = ACTIONS(343),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [43] = {
    [sym__statement] = STATE(893),
    [sym__one_or_more_statements] = STATE(3101),
    [sym_statement] = STATE(2466),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1090),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym_object] = STATE(1090),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(43),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1047),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1090),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(46),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [44] = {
    [sym__statement] = STATE(893),
    [sym__one_or_more_statements] = STATE(3084),
    [sym_statement] = STATE(2466),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1090),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym_object] = STATE(1090),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(44),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1047),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1090),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(46),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [45] = {
    [sym__statement] = STATE(893),
    [sym__one_or_more_statements] = STATE(3073),
    [sym_statement] = STATE(2466),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1090),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym_object] = STATE(1090),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(45),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1047),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1090),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(46),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [46] = {
    [sym__statement] = STATE(893),
    [sym_statement] = STATE(2459),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1090),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym_object] = STATE(1090),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(46),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1047),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1090),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(41),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [47] = {
    [sym_block] = STATE(1451),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1532),
    [sym_primary_expression] = STATE(1399),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_polyvar_type_pattern] = STATE(2034),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(1207),
    [sym__definition_signature] = STATE(3260),
    [sym_formal_parameters] = STATE(2800),
    [sym__pattern] = STATE(2624),
    [sym_parenthesized_pattern] = STATE(2034),
    [sym_range_pattern] = STATE(2034),
    [sym_or_pattern] = STATE(2034),
    [sym_exception_pattern] = STATE(2034),
    [sym__destructuring_pattern] = STATE(2034),
    [sym__literal_pattern] = STATE(1966),
    [sym_variant_pattern] = STATE(2116),
    [sym__variant_pattern_parameter] = STATE(2929),
    [sym_polyvar_pattern] = STATE(2116),
    [sym_record_pattern] = STATE(2116),
    [sym_tuple_pattern] = STATE(2116),
    [sym_array_pattern] = STATE(2116),
    [sym_list_pattern] = STATE(2116),
    [sym_lazy_pattern] = STATE(2034),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3085),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(47),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(1049),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2895),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1049),
    [sym_polyvar_identifier] = STATE(1046),
    [sym_value_identifier] = STATE(1040),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1207),
    [sym_string] = STATE(1057),
    [sym_template_string] = STATE(1057),
    [sym_character] = STATE(1057),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LPAREN] = ACTIONS(345),
    [anon_sym_RPAREN] = ACTIONS(347),
    [anon_sym_await] = ACTIONS(121),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_exception] = ACTIONS(129),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(133),
    [anon_sym_DASH] = ACTIONS(133),
    [anon_sym_LBRACK] = ACTIONS(137),
    [anon_sym_QMARK] = ACTIONS(139),
    [anon_sym_async] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(151),
    [anon_sym_lazy] = ACTIONS(155),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(133),
    [anon_sym_DASH_DOT] = ACTIONS(133),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(349),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(165),
    [sym_true] = ACTIONS(167),
    [sym_false] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [aux_sym_template_string_token1] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(175),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [48] = {
    [sym__statement] = STATE(893),
    [sym_statement] = STATE(2426),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1090),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym_object] = STATE(1090),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(48),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1047),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1090),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(41),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_open] = ACTIONS(227),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(229),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(231),
    [anon_sym_type] = ACTIONS(233),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(235),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_let] = ACTIONS(237),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [49] = {
    [sym__statement] = STATE(893),
    [sym_statement] = STATE(2426),
    [sym_block] = STATE(1186),
    [sym_open_statement] = STATE(2479),
    [sym_include_statement] = STATE(2479),
    [sym_declaration] = STATE(2479),
    [sym_module_declaration] = STATE(2480),
    [sym_module_unpack] = STATE(2211),
    [sym_external_declaration] = STATE(2480),
    [sym_exception_declaration] = STATE(2480),
    [sym_type_declaration] = STATE(2480),
    [sym_let_declaration] = STATE(2480),
    [sym_expression_statement] = STATE(2479),
    [sym_expression] = STATE(1518),
    [sym_primary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1090),
    [sym_value_identifier_path] = STATE(1090),
    [sym_function] = STATE(1090),
    [sym_record] = STATE(1090),
    [sym_object] = STATE(1090),
    [sym_tuple] = STATE(1090),
    [sym_array] = STATE(1090),
    [sym_list] = STATE(1090),
    [sym_if_expression] = STATE(1090),
    [sym_switch_expression] = STATE(1090),
    [sym_try_expression] = STATE(1090),
    [sym_assert_expression] = STATE(1106),
    [sym_call_expression] = STATE(1090),
    [sym_pipe_expression] = STATE(1090),
    [sym_module_pack] = STATE(1090),
    [sym__definition_signature] = STATE(3342),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1108),
    [sym_jsx_element] = STATE(1109),
    [sym_jsx_fragment] = STATE(1106),
    [sym_jsx_opening_element] = STATE(536),
    [sym_jsx_self_closing_element] = STATE(1109),
    [sym_mutation_expression] = STATE(1106),
    [sym__mutation_lvalue] = STATE(3055),
    [sym_await_expression] = STATE(1106),
    [sym_decorator] = STATE(49),
    [sym_subscript_expression] = STATE(1054),
    [sym_member_expression] = STATE(1054),
    [sym_ternary_expression] = STATE(1106),
    [sym_for_expression] = STATE(1106),
    [sym_while_expression] = STATE(1106),
    [sym_lazy_expression] = STATE(1090),
    [sym_binary_expression] = STATE(1106),
    [sym_coercion_expression] = STATE(1106),
    [sym_unary_expression] = STATE(1106),
    [sym_extension_expression] = STATE(1090),
    [sym_variant] = STATE(1090),
    [sym_nested_variant_identifier] = STATE(1061),
    [sym_polyvar] = STATE(1090),
    [sym_module_primary_expression] = STATE(2805),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1061),
    [sym_polyvar_identifier] = STATE(1067),
    [sym_value_identifier] = STATE(1047),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1090),
    [sym_string] = STATE(1090),
    [sym_template_string] = STATE(1090),
    [sym_character] = STATE(1090),
    [sym__reserved_identifier] = STATE(897),
    [aux_sym_source_file_repeat2] = STATE(41),
    [aux_sym_extension_expression_repeat1] = STATE(2808),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_open] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_await] = ACTIONS(23),
    [anon_sym_module] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_unpack] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_exception] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_let] = ACTIONS(43),
    [anon_sym_async] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_switch] = ACTIONS(49),
    [anon_sym_POUND] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_lazy] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_PLUS_DOT] = ACTIONS(39),
    [anon_sym_DASH_DOT] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(65),
    [aux_sym_value_identifier_token1] = ACTIONS(67),
    [sym__escape_identifier] = ACTIONS(67),
    [sym_number] = ACTIONS(69),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [aux_sym_template_string_token1] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(79),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [50] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1033),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_polyvar_type_pattern] = STATE(2487),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(1198),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__pattern] = STATE(2087),
    [sym_parenthesized_pattern] = STATE(2487),
    [sym_range_pattern] = STATE(2487),
    [sym_or_pattern] = STATE(2487),
    [sym_exception_pattern] = STATE(2487),
    [sym__destructuring_pattern] = STATE(2487),
    [sym__literal_pattern] = STATE(2386),
    [sym_variant_pattern] = STATE(2116),
    [sym_polyvar_pattern] = STATE(2116),
    [sym_record_pattern] = STATE(2116),
    [sym_tuple_pattern] = STATE(2116),
    [sym_array_pattern] = STATE(2116),
    [sym_list_pattern] = STATE(2116),
    [sym_lazy_pattern] = STATE(2487),
    [sym__jsx_element] = STATE(1036),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3127),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(50),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(1049),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1049),
    [sym_polyvar_identifier] = STATE(1046),
    [sym_value_identifier] = STATE(1043),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1198),
    [sym_string] = STATE(1057),
    [sym_template_string] = STATE(1057),
    [sym_character] = STATE(1057),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(197),
    [anon_sym_await] = ACTIONS(353),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_exception] = ACTIONS(203),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_LBRACK] = ACTIONS(137),
    [anon_sym_QMARK] = ACTIONS(139),
    [anon_sym_async] = ACTIONS(209),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(357),
    [anon_sym_lazy] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(355),
    [anon_sym_DASH_DOT] = ACTIONS(355),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(165),
    [sym_true] = ACTIONS(167),
    [sym_false] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [aux_sym_template_string_token1] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(175),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [51] = {
    [sym_block] = STATE(1451),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1033),
    [sym_primary_expression] = STATE(1399),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_polyvar_type_pattern] = STATE(2041),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(1192),
    [sym__definition_signature] = STATE(3260),
    [sym_formal_parameters] = STATE(2800),
    [sym__pattern] = STATE(2087),
    [sym_parenthesized_pattern] = STATE(2041),
    [sym_range_pattern] = STATE(2041),
    [sym_or_pattern] = STATE(2041),
    [sym_exception_pattern] = STATE(2041),
    [sym__destructuring_pattern] = STATE(2041),
    [sym__literal_pattern] = STATE(1979),
    [sym_variant_pattern] = STATE(2116),
    [sym_polyvar_pattern] = STATE(2116),
    [sym_record_pattern] = STATE(2116),
    [sym_tuple_pattern] = STATE(2116),
    [sym_array_pattern] = STATE(2116),
    [sym_list_pattern] = STATE(2116),
    [sym_lazy_pattern] = STATE(2041),
    [sym__jsx_element] = STATE(1036),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3058),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(51),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(1049),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2895),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1049),
    [sym_polyvar_identifier] = STATE(1046),
    [sym_value_identifier] = STATE(1051),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1192),
    [sym_string] = STATE(1057),
    [sym_template_string] = STATE(1057),
    [sym_character] = STATE(1057),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_LPAREN] = ACTIONS(345),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_exception] = ACTIONS(129),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(363),
    [anon_sym_DASH] = ACTIONS(363),
    [anon_sym_LBRACK] = ACTIONS(137),
    [anon_sym_QMARK] = ACTIONS(139),
    [anon_sym_async] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(365),
    [anon_sym_lazy] = ACTIONS(155),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(363),
    [anon_sym_DASH_DOT] = ACTIONS(363),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(349),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(165),
    [sym_true] = ACTIONS(167),
    [sym_false] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [aux_sym_template_string_token1] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(175),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [52] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2566),
    [sym_partial_application_spread] = STATE(3356),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(52),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym_uncurry] = STATE(78),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(373),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_DOT] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [53] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2587),
    [sym_partial_application_spread] = STATE(3268),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(53),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym_uncurry] = STATE(74),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(427),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_DOT] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [54] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2618),
    [sym_partial_application_spread] = STATE(3159),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(54),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym_uncurry] = STATE(77),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(429),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_DOT] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [55] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2549),
    [sym_partial_application_spread] = STATE(3165),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(55),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym_uncurry] = STATE(61),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(431),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_DOT] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [56] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2557),
    [sym_partial_application_spread] = STATE(3366),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(56),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym_uncurry] = STATE(60),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(433),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_DOT] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [57] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2634),
    [sym_partial_application_spread] = STATE(3353),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(57),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym_uncurry] = STATE(71),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(435),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_DOT] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [58] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2837),
    [sym_partial_application_spread] = STATE(3147),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(58),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(437),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [59] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2837),
    [sym_partial_application_spread] = STATE(3228),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(59),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(439),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [60] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2580),
    [sym_partial_application_spread] = STATE(3269),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(60),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(441),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [61] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2611),
    [sym_partial_application_spread] = STATE(3167),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(61),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(443),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [62] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2837),
    [sym_partial_application_spread] = STATE(3208),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(62),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(445),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [63] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2837),
    [sym_partial_application_spread] = STATE(3273),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(63),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(447),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [64] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2837),
    [sym_partial_application_spread] = STATE(3229),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(64),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(449),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [65] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2837),
    [sym_partial_application_spread] = STATE(3326),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(65),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(451),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [66] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2837),
    [sym_partial_application_spread] = STATE(3400),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(66),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(453),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [67] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2837),
    [sym_partial_application_spread] = STATE(3323),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(67),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(455),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [68] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2837),
    [sym_partial_application_spread] = STATE(3331),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(68),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(457),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [69] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2837),
    [sym_partial_application_spread] = STATE(3254),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(69),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(459),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [70] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2837),
    [sym_partial_application_spread] = STATE(3262),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(70),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(461),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [71] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2531),
    [sym_partial_application_spread] = STATE(3365),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(71),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(463),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [72] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2837),
    [sym_partial_application_spread] = STATE(3290),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(72),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(465),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [73] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2837),
    [sym_partial_application_spread] = STATE(3211),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(73),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(467),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [74] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2561),
    [sym_partial_application_spread] = STATE(3242),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(74),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(469),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [75] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2837),
    [sym_partial_application_spread] = STATE(3224),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(75),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(471),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [76] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2837),
    [sym_partial_application_spread] = STATE(3300),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(76),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(473),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [77] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2588),
    [sym_partial_application_spread] = STATE(3255),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(77),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(475),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [78] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2585),
    [sym_partial_application_spread] = STATE(3283),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(78),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(477),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [79] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2837),
    [sym_partial_application_spread] = STATE(3386),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(79),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(479),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [80] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2837),
    [sym_partial_application_spread] = STATE(3223),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(80),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(481),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [81] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2837),
    [sym_partial_application_spread] = STATE(3169),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(81),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(483),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [82] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1602),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym__list_element] = STATE(3023),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(82),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_spread_element] = STATE(3122),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(487),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [83] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1602),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym__list_element] = STATE(3067),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(83),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_spread_element] = STATE(3122),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(511),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [84] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1602),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym__list_element] = STATE(2921),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(84),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_spread_element] = STATE(3122),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(513),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [85] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1602),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym__list_element] = STATE(3067),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(85),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_spread_element] = STATE(3122),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(515),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [86] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1602),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym__list_element] = STATE(3067),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(86),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_spread_element] = STATE(3122),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(517),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [87] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1602),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym__list_element] = STATE(3067),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(87),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_spread_element] = STATE(3122),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(519),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [88] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1602),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym__list_element] = STATE(2831),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(88),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_spread_element] = STATE(3122),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(521),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [89] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1602),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym__list_element] = STATE(2893),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(89),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_spread_element] = STATE(3122),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(523),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [90] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1602),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym__list_element] = STATE(3067),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(90),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_spread_element] = STATE(3122),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(525),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [91] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1602),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym__list_element] = STATE(2803),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(91),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_spread_element] = STATE(3122),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(527),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [92] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1602),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym__list_element] = STATE(3067),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(92),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_spread_element] = STATE(3122),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(529),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [93] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1602),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym__list_element] = STATE(3067),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(93),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_spread_element] = STATE(3122),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(531),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [94] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1602),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym__list_element] = STATE(3067),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(94),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_spread_element] = STATE(3122),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(533),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [95] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1602),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym__list_element] = STATE(2909),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(95),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_spread_element] = STATE(3122),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(535),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [96] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1602),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym__list_element] = STATE(3067),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(96),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_spread_element] = STATE(3122),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(537),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [97] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1602),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym__list_element] = STATE(3067),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(97),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_spread_element] = STATE(3122),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(539),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [98] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1602),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym__list_element] = STATE(3067),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(98),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_spread_element] = STATE(3122),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(541),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [99] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1602),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym__list_element] = STATE(3067),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(99),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_spread_element] = STATE(3122),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [100] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1525),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__call_argument] = STATE(2837),
    [sym_labeled_argument] = STATE(3018),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(100),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [101] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1602),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym__list_element] = STATE(3067),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(101),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_spread_element] = STATE(3122),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [102] = {
    [sym_block] = STATE(1453),
    [sym_module_unpack] = STATE(2211),
    [sym_type_annotation] = STATE(3195),
    [sym_expression] = STATE(1561),
    [sym_primary_expression] = STATE(1447),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3207),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3116),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(102),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2895),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1290),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_RPAREN] = ACTIONS(547),
    [anon_sym_COLON] = ACTIONS(549),
    [anon_sym_await] = ACTIONS(551),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(553),
    [anon_sym_DASH] = ACTIONS(553),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_async] = ACTIONS(555),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(557),
    [anon_sym_lazy] = ACTIONS(559),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(553),
    [anon_sym_DASH_DOT] = ACTIONS(553),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(349),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [103] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1585),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym_array_pattern] = STATE(2673),
    [sym_list_pattern] = STATE(2673),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(103),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1180),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(137),
    [anon_sym_async] = ACTIONS(209),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(175),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [104] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1615),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(104),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_RBRACK] = ACTIONS(561),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [105] = {
    [sym_block] = STATE(1453),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1596),
    [sym_primary_expression] = STATE(1447),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3207),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3116),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(105),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2895),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1290),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_RPAREN] = ACTIONS(563),
    [anon_sym_await] = ACTIONS(551),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(553),
    [anon_sym_DASH] = ACTIONS(553),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_async] = ACTIONS(555),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(557),
    [anon_sym_lazy] = ACTIONS(559),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(553),
    [anon_sym_DASH_DOT] = ACTIONS(553),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(349),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [106] = {
    [sym_block] = STATE(1453),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1596),
    [sym_primary_expression] = STATE(1447),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3207),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3116),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(106),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2895),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1290),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_RPAREN] = ACTIONS(565),
    [anon_sym_await] = ACTIONS(551),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(553),
    [anon_sym_DASH] = ACTIONS(553),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_async] = ACTIONS(555),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(557),
    [anon_sym_lazy] = ACTIONS(559),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(553),
    [anon_sym_DASH_DOT] = ACTIONS(553),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(349),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [107] = {
    [sym_block] = STATE(1453),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1596),
    [sym_primary_expression] = STATE(1447),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3207),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3116),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(107),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2895),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1290),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_RPAREN] = ACTIONS(567),
    [anon_sym_await] = ACTIONS(551),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(553),
    [anon_sym_DASH] = ACTIONS(553),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_async] = ACTIONS(555),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(557),
    [anon_sym_lazy] = ACTIONS(559),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(553),
    [anon_sym_DASH_DOT] = ACTIONS(553),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(349),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [108] = {
    [sym_block] = STATE(1451),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1543),
    [sym_primary_expression] = STATE(1399),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3260),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3085),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(108),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2895),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1188),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LPAREN] = ACTIONS(569),
    [anon_sym_RPAREN] = ACTIONS(571),
    [anon_sym_await] = ACTIONS(121),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(133),
    [anon_sym_DASH] = ACTIONS(133),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_async] = ACTIONS(573),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(151),
    [anon_sym_lazy] = ACTIONS(575),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(133),
    [anon_sym_DASH_DOT] = ACTIONS(133),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(349),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [109] = {
    [sym_block] = STATE(1451),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1543),
    [sym_primary_expression] = STATE(1399),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3260),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3085),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(109),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2895),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1188),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LPAREN] = ACTIONS(569),
    [anon_sym_RPAREN] = ACTIONS(577),
    [anon_sym_await] = ACTIONS(121),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(133),
    [anon_sym_DASH] = ACTIONS(133),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_async] = ACTIONS(573),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(151),
    [anon_sym_lazy] = ACTIONS(575),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(133),
    [anon_sym_DASH_DOT] = ACTIONS(133),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(349),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [110] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1615),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(110),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_RBRACK] = ACTIONS(579),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [111] = {
    [sym_block] = STATE(1453),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1596),
    [sym_primary_expression] = STATE(1447),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3207),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3116),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(111),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2895),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1290),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_RPAREN] = ACTIONS(581),
    [anon_sym_await] = ACTIONS(551),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(553),
    [anon_sym_DASH] = ACTIONS(553),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_async] = ACTIONS(555),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(557),
    [anon_sym_lazy] = ACTIONS(559),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(553),
    [anon_sym_DASH_DOT] = ACTIONS(553),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(349),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [112] = {
    [sym_block] = STATE(1451),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1543),
    [sym_primary_expression] = STATE(1399),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3260),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3085),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(112),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2895),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1188),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LPAREN] = ACTIONS(569),
    [anon_sym_RPAREN] = ACTIONS(583),
    [anon_sym_await] = ACTIONS(121),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(133),
    [anon_sym_DASH] = ACTIONS(133),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_async] = ACTIONS(573),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(151),
    [anon_sym_lazy] = ACTIONS(575),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(133),
    [anon_sym_DASH_DOT] = ACTIONS(133),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(349),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [113] = {
    [sym_block] = STATE(1364),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1526),
    [sym_primary_expression] = STATE(1243),
    [sym_parenthesized_expression] = STATE(1429),
    [sym_value_identifier_path] = STATE(1429),
    [sym_function] = STATE(1429),
    [sym_record] = STATE(1429),
    [sym_object] = STATE(1429),
    [sym_tuple] = STATE(1429),
    [sym_array] = STATE(1429),
    [sym_list] = STATE(1429),
    [sym_if_expression] = STATE(1429),
    [sym_switch_expression] = STATE(1429),
    [sym_try_expression] = STATE(1429),
    [sym_assert_expression] = STATE(1373),
    [sym_call_expression] = STATE(1429),
    [sym_pipe_expression] = STATE(1429),
    [sym_module_pack] = STATE(1429),
    [sym__definition_signature] = STATE(3327),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1380),
    [sym_jsx_element] = STATE(1395),
    [sym_jsx_fragment] = STATE(1373),
    [sym_jsx_opening_element] = STATE(544),
    [sym_jsx_self_closing_element] = STATE(1395),
    [sym_mutation_expression] = STATE(1373),
    [sym__mutation_lvalue] = STATE(3030),
    [sym_await_expression] = STATE(1373),
    [sym_decorator] = STATE(113),
    [sym_subscript_expression] = STATE(1210),
    [sym_member_expression] = STATE(1210),
    [sym_ternary_expression] = STATE(1373),
    [sym_for_expression] = STATE(1373),
    [sym_while_expression] = STATE(1373),
    [sym_lazy_expression] = STATE(1429),
    [sym_binary_expression] = STATE(1373),
    [sym_coercion_expression] = STATE(1373),
    [sym_unary_expression] = STATE(1373),
    [sym_extension_expression] = STATE(1429),
    [sym_variant] = STATE(1429),
    [sym_nested_variant_identifier] = STATE(1246),
    [sym_polyvar] = STATE(1429),
    [sym_module_primary_expression] = STATE(3009),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(1246),
    [sym_polyvar_identifier] = STATE(1247),
    [sym_value_identifier] = STATE(1154),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(1429),
    [sym_string] = STATE(1429),
    [sym_template_string] = STATE(1429),
    [sym_character] = STATE(1429),
    [sym__reserved_identifier] = STATE(1163),
    [aux_sym_extension_expression_repeat1] = STATE(2811),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_await] = ACTIONS(375),
    [anon_sym_module] = ACTIONS(377),
    [anon_sym_unpack] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_QMARK] = ACTIONS(585),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_POUND] = ACTIONS(397),
    [anon_sym_try] = ACTIONS(399),
    [anon_sym_assert] = ACTIONS(401),
    [anon_sym_lazy] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_PLUS_DOT] = ACTIONS(383),
    [anon_sym_DASH_DOT] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(411),
    [aux_sym_value_identifier_token1] = ACTIONS(413),
    [sym__escape_identifier] = ACTIONS(413),
    [sym_number] = ACTIONS(415),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [aux_sym_template_string_token1] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(425),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [114] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1615),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(114),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_RBRACK] = ACTIONS(587),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [115] = {
    [sym_block] = STATE(1453),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1596),
    [sym_primary_expression] = STATE(1447),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3207),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3116),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(115),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2895),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1290),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_RPAREN] = ACTIONS(589),
    [anon_sym_await] = ACTIONS(551),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(553),
    [anon_sym_DASH] = ACTIONS(553),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_async] = ACTIONS(555),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(557),
    [anon_sym_lazy] = ACTIONS(559),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(553),
    [anon_sym_DASH_DOT] = ACTIONS(553),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(349),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [116] = {
    [sym_block] = STATE(1451),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1543),
    [sym_primary_expression] = STATE(1399),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3260),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3085),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(116),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2895),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1188),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LPAREN] = ACTIONS(569),
    [anon_sym_RPAREN] = ACTIONS(591),
    [anon_sym_await] = ACTIONS(121),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(133),
    [anon_sym_DASH] = ACTIONS(133),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_async] = ACTIONS(573),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(151),
    [anon_sym_lazy] = ACTIONS(575),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(133),
    [anon_sym_DASH_DOT] = ACTIONS(133),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(349),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [117] = {
    [sym_block] = STATE(1451),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1543),
    [sym_primary_expression] = STATE(1399),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3260),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3085),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(117),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2895),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1188),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LPAREN] = ACTIONS(569),
    [anon_sym_RPAREN] = ACTIONS(593),
    [anon_sym_await] = ACTIONS(121),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(133),
    [anon_sym_DASH] = ACTIONS(133),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_async] = ACTIONS(573),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(151),
    [anon_sym_lazy] = ACTIONS(575),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(133),
    [anon_sym_DASH_DOT] = ACTIONS(133),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(349),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [118] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1615),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(118),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_RBRACK] = ACTIONS(595),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [119] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1615),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(119),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_RBRACK] = ACTIONS(597),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [120] = {
    [sym_block] = STATE(1451),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1543),
    [sym_primary_expression] = STATE(1399),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3260),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3085),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(120),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2895),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1188),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LPAREN] = ACTIONS(569),
    [anon_sym_RPAREN] = ACTIONS(599),
    [anon_sym_await] = ACTIONS(121),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(133),
    [anon_sym_DASH] = ACTIONS(133),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_async] = ACTIONS(573),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(151),
    [anon_sym_lazy] = ACTIONS(575),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(133),
    [anon_sym_DASH_DOT] = ACTIONS(133),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(349),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [121] = {
    [sym_block] = STATE(1451),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1523),
    [sym_primary_expression] = STATE(1399),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3260),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3085),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(121),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2895),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1188),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LPAREN] = ACTIONS(569),
    [anon_sym_RPAREN] = ACTIONS(601),
    [anon_sym_await] = ACTIONS(121),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(133),
    [anon_sym_DASH] = ACTIONS(133),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_async] = ACTIONS(573),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(151),
    [anon_sym_lazy] = ACTIONS(575),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(133),
    [anon_sym_DASH_DOT] = ACTIONS(133),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(349),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [122] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1572),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(122),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_RBRACK] = ACTIONS(603),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [123] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1570),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(123),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_RBRACK] = ACTIONS(605),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [124] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1615),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(124),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_RBRACK] = ACTIONS(607),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [125] = {
    [sym_block] = STATE(1389),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1571),
    [sym_primary_expression] = STATE(1261),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3333),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3054),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(125),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2850),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1140),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(199),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_RBRACK] = ACTIONS(609),
    [anon_sym_async] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(211),
    [anon_sym_lazy] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(205),
    [anon_sym_DASH_DOT] = ACTIONS(205),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(161),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [126] = {
    [sym_block] = STATE(1451),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1543),
    [sym_primary_expression] = STATE(1399),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3260),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3085),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(126),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2895),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1188),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LPAREN] = ACTIONS(569),
    [anon_sym_RPAREN] = ACTIONS(611),
    [anon_sym_await] = ACTIONS(121),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(133),
    [anon_sym_DASH] = ACTIONS(133),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_async] = ACTIONS(573),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(151),
    [anon_sym_lazy] = ACTIONS(575),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(133),
    [anon_sym_DASH_DOT] = ACTIONS(133),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(349),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [127] = {
    [sym_block] = STATE(1451),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1543),
    [sym_primary_expression] = STATE(1399),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3260),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3085),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(127),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2895),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1188),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LPAREN] = ACTIONS(569),
    [anon_sym_RPAREN] = ACTIONS(613),
    [anon_sym_await] = ACTIONS(121),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(133),
    [anon_sym_DASH] = ACTIONS(133),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_async] = ACTIONS(573),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(151),
    [anon_sym_lazy] = ACTIONS(575),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(133),
    [anon_sym_DASH_DOT] = ACTIONS(133),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(349),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [128] = {
    [sym_block] = STATE(1453),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1596),
    [sym_primary_expression] = STATE(1447),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3207),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3116),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(128),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2895),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1290),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_RPAREN] = ACTIONS(615),
    [anon_sym_await] = ACTIONS(551),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(553),
    [anon_sym_DASH] = ACTIONS(553),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_async] = ACTIONS(555),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(557),
    [anon_sym_lazy] = ACTIONS(559),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(553),
    [anon_sym_DASH_DOT] = ACTIONS(553),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(349),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [129] = {
    [sym_block] = STATE(1453),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1596),
    [sym_primary_expression] = STATE(1447),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
    [sym_if_expression] = STATE(999),
    [sym_switch_expression] = STATE(999),
    [sym_try_expression] = STATE(999),
    [sym_assert_expression] = STATE(1003),
    [sym_call_expression] = STATE(999),
    [sym_pipe_expression] = STATE(999),
    [sym_module_pack] = STATE(999),
    [sym__definition_signature] = STATE(3207),
    [sym_formal_parameters] = STATE(2800),
    [sym__jsx_element] = STATE(1004),
    [sym_jsx_element] = STATE(1005),
    [sym_jsx_fragment] = STATE(1003),
    [sym_jsx_opening_element] = STATE(541),
    [sym_jsx_self_closing_element] = STATE(1005),
    [sym_mutation_expression] = STATE(1003),
    [sym__mutation_lvalue] = STATE(3116),
    [sym_await_expression] = STATE(1003),
    [sym_decorator] = STATE(129),
    [sym_subscript_expression] = STATE(911),
    [sym_member_expression] = STATE(911),
    [sym_ternary_expression] = STATE(1003),
    [sym_for_expression] = STATE(1003),
    [sym_while_expression] = STATE(1003),
    [sym_lazy_expression] = STATE(999),
    [sym_binary_expression] = STATE(1003),
    [sym_coercion_expression] = STATE(1003),
    [sym_unary_expression] = STATE(1003),
    [sym_extension_expression] = STATE(999),
    [sym_variant] = STATE(999),
    [sym_nested_variant_identifier] = STATE(922),
    [sym_polyvar] = STATE(999),
    [sym_module_primary_expression] = STATE(2895),
    [sym_parenthesized_module_expression] = STATE(2211),
    [sym_module_identifier_path] = STATE(2211),
    [sym_functor_use] = STATE(2211),
    [sym_variant_identifier] = STATE(922),
    [sym_polyvar_identifier] = STATE(923),
    [sym_value_identifier] = STATE(1290),
    [sym_module_identifier] = STATE(2147),
    [sym_unit] = STATE(999),
    [sym_string] = STATE(999),
    [sym_template_string] = STATE(999),
    [sym_character] = STATE(999),
    [sym__reserved_identifier] = STATE(842),
    [aux_sym_extension_expression_repeat1] = STATE(2849),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_RPAREN] = ACTIONS(617),
    [anon_sym_await] = ACTIONS(551),
    [anon_sym_module] = ACTIONS(201),
    [anon_sym_unpack] = ACTIONS(127),
    [anon_sym_LT] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(553),
    [anon_sym_DASH] = ACTIONS(553),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_async] = ACTIONS(555),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(557),
    [anon_sym_lazy] = ACTIONS(559),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_PLUS_DOT] = ACTIONS(553),
    [anon_sym_DASH_DOT] = ACTIONS(553),
    [anon_sym_PERCENT] = ACTIONS(63),
    [aux_sym_variant_identifier_token1] = ACTIONS(349),
    [aux_sym_value_identifier_token1] = ACTIONS(163),
    [sym__escape_identifier] = ACTIONS(163),
    [sym_number] = ACTIONS(499),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [aux_sym_template_string_token1] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__list_constructor] = ACTIONS(509),
    [sym__decorator] = ACTIONS(5),
    [sym__decorator_inline] = ACTIONS(7),
  },
  [130] = {
    [sym_block] = STATE(1451),
    [sym_module_unpack] = STATE(2211),
    [sym_expression] = STATE(1543),
    [sym_primary_expression] = STATE(1399),
    [sym_parenthesized_expression] = STATE(999),
    [sym_value_identifier_path] = STATE(999),
    [sym_function] = STATE(999),
    [sym_record] = STATE(999),
    [sym_object] = STATE(999),
    [sym_tuple] = STATE(999),
    [sym_array] = STATE(999),
    [sym_list] = STATE(999),
   