/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.capability.CapabilitySelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.capability.DefaultSpecificCapabilitySelector;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParseException;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DefaultExcludeRuleConverter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.ExcludeRuleConverter;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenAttributesFactory;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.capabilities.CapabilityInternal;
import org.gradle.api.internal.capabilities.ImmutableCapability;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;
import org.gradle.internal.component.external.model.MutableComponentVariant;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ShadowedImmutableCapability;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.snapshot.impl.CoercingStringValueSnapshot;

public class GradleModuleMetadataParser {
    private static final Logger LOGGER = Logging.getLogger(GradleModuleMetadataParser.class);
    public static final String FORMAT_VERSION = "1.1";
    private final AttributesFactory attributesFactory;
    private final NamedObjectInstantiator instantiator;
    private final ExcludeRuleConverter excludeRuleConverter;

    public GradleModuleMetadataParser(AttributesFactory attributesFactory, ImmutableModuleIdentifierFactory moduleIdentifierFactory, NamedObjectInstantiator instantiator) {
        this.attributesFactory = attributesFactory;
        this.instantiator = instantiator;
        this.excludeRuleConverter = new DefaultExcludeRuleConverter(moduleIdentifierFactory);
    }

    public AttributesFactory getAttributesFactory() {
        return this.attributesFactory;
    }

    public NamedObjectInstantiator getInstantiator() {
        return this.instantiator;
    }

    public void parse(LocallyAvailableExternalResource resource, MutableModuleComponentResolveMetadata metadata) {
        resource.withContent(inputStream -> {
            String version = null;
            try {
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                reader.beginObject();
                if (reader.peek() != JsonToken.NAME) {
                    throw new RuntimeException("Module metadata should contain a 'formatVersion' value.");
                }
                String name = reader.nextName();
                if (!name.equals("formatVersion")) {
                    throw new RuntimeException(String.format("The 'formatVersion' value should be the first value in a module metadata. Found '%s' instead.", name));
                }
                if (reader.peek() != JsonToken.STRING) {
                    throw new RuntimeException("The 'formatVersion' value should have a string value.");
                }
                version = reader.nextString();
                this.consumeTopLevelElements(reader, metadata);
                File file = resource.getFile();
                if (!FORMAT_VERSION.equals(version)) {
                    LOGGER.debug("Unrecognized metadata format version '{}' found in '{}'. Parsing succeeded but it may lead to unexpected resolution results. Try upgrading to a newer version of Gradle", (Object)version, (Object)file);
                }
                return null;
            }
            catch (Exception e) {
                if (version != null && !FORMAT_VERSION.equals(version)) {
                    throw new MetaDataParseException("module metadata", (ExternalResource)resource, String.format("unsupported format version '%s' specified in module metadata. This version of Gradle supports format version %s.", version, FORMAT_VERSION), e);
                }
                throw new MetaDataParseException("module metadata", (ExternalResource)resource, e);
            }
        });
        this.maybeAddEnforcedPlatformVariant(metadata);
    }

    private void maybeAddEnforcedPlatformVariant(MutableModuleComponentResolveMetadata metadata) {
        List<? extends MutableComponentVariant> variants = metadata.getMutableVariants();
        if (variants == null || variants.isEmpty()) {
            return;
        }
        for (MutableComponentVariant variant : ImmutableList.copyOf(variants)) {
            AttributeValue entry = variant.getAttributes().findEntry(MavenAttributesFactory.CATEGORY_ATTRIBUTE);
            if (!entry.isPresent() || !"platform".equals(entry.get()) || !variant.getCapabilities().isEmpty()) continue;
            ImmutableAttributes enforcedAttributes = this.attributesFactory.concat(variant.getAttributes(), MavenAttributesFactory.CATEGORY_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot("enforced-platform", this.instantiator));
            Capability enforcedCapability = this.buildShadowPlatformCapability(metadata.getId());
            metadata.addVariant(variant.copy("enforced" + StringUtils.capitalize((String)variant.getName()), enforcedAttributes, enforcedCapability));
        }
    }

    private Capability buildShadowPlatformCapability(ModuleComponentIdentifier componentId) {
        return new ShadowedImmutableCapability((CapabilityInternal)new DefaultImmutableCapability(componentId.getGroup(), componentId.getModule(), componentId.getVersion()), "-derived-enforced-platform");
    }

    private void consumeTopLevelElements(JsonReader reader, MutableModuleComponentResolveMetadata metadata) throws IOException {
        block8: while (reader.peek() != JsonToken.END_OBJECT) {
            String name;
            switch (name = reader.nextName()) {
                case "variants": {
                    this.consumeVariants(reader, metadata);
                    continue block8;
                }
                case "component": {
                    this.consumeComponent(reader, metadata);
                    continue block8;
                }
            }
            this.consumeAny(reader);
        }
    }

    private void consumeComponent(JsonReader reader, MutableModuleComponentResolveMetadata metadata) throws IOException {
        reader.beginObject();
        block6: while (reader.peek() != JsonToken.END_OBJECT) {
            String name;
            switch (name = reader.nextName()) {
                case "attributes": {
                    metadata.setAttributes((AttributeContainer)this.consumeAttributes(reader));
                    continue block6;
                }
            }
            this.consumeAny(reader);
        }
        reader.endObject();
    }

    private void consumeVariants(JsonReader reader, MutableModuleComponentResolveMetadata metadata) throws IOException {
        reader.beginArray();
        while (reader.peek() != JsonToken.END_ARRAY) {
            this.consumeVariant(reader, metadata);
        }
        reader.endArray();
    }

    private void consumeVariant(JsonReader reader, MutableModuleComponentResolveMetadata metadata) throws IOException {
        String variantName = null;
        ImmutableAttributes attributes = ImmutableAttributes.EMPTY;
        List<Object> files = Collections.emptyList();
        List<ModuleDependency> dependencies = Collections.emptyList();
        List<Object> dependencyConstraints = Collections.emptyList();
        List<ImmutableCapability> capabilities = Collections.emptyList();
        boolean availableExternally = false;
        reader.beginObject();
        block18: while (reader.peek() != JsonToken.END_OBJECT) {
            String name;
            switch (name = reader.nextName()) {
                case "name": {
                    variantName = reader.nextString();
                    continue block18;
                }
                case "attributes": {
                    attributes = this.consumeAttributes(reader);
                    continue block18;
                }
                case "files": {
                    files = this.consumeFiles(reader);
                    continue block18;
                }
                case "dependencies": {
                    dependencies = this.consumeDependencies(reader);
                    continue block18;
                }
                case "dependencyConstraints": {
                    dependencyConstraints = this.consumeDependencyConstraints(reader);
                    continue block18;
                }
                case "capabilities": {
                    capabilities = this.consumeCapabilities(reader, true);
                    continue block18;
                }
                case "available-at": {
                    availableExternally = true;
                    dependencies = this.consumeVariantLocation(reader);
                    continue block18;
                }
            }
            this.consumeAny(reader);
        }
        this.assertDefined(reader, "name", variantName);
        reader.endObject();
        MutableComponentVariant variant = metadata.addVariant(variantName, attributes);
        variant.setAvailableExternally(availableExternally);
        if (availableExternally) {
            if (!dependencyConstraints.isEmpty()) {
                throw new RuntimeException("A variant declared with available-at cannot declare dependency constraints");
            }
            if (!files.isEmpty()) {
                throw new RuntimeException("A variant declared with available-at cannot declare files");
            }
        }
        this.populateVariant(files, dependencies, dependencyConstraints, capabilities, variant);
    }

    private void populateVariant(List<ModuleFile> files, List<ModuleDependency> dependencies, List<ModuleDependencyConstraint> dependencyConstraints, List<ImmutableCapability> capabilities, MutableComponentVariant variant) {
        for (ModuleFile file : files) {
            variant.addFile(file.name, file.uri);
        }
        for (ModuleDependency dependency : dependencies) {
            ImmutableSet.Builder capabilitySelectors = ImmutableSet.builderWithExpectedSize((int)dependency.requestedCapabilities.size());
            for (ImmutableCapability requestedCapability : dependency.requestedCapabilities) {
                capabilitySelectors.add((Object)new DefaultSpecificCapabilitySelector(requestedCapability));
            }
            variant.addDependency(dependency.group, dependency.module, dependency.versionConstraint, (List<ExcludeMetadata>)dependency.excludes, dependency.reason, dependency.attributes, (Set<CapabilitySelector>)capabilitySelectors.build(), dependency.endorsing, dependency.artifact);
        }
        for (ModuleDependencyConstraint dependencyConstraint : dependencyConstraints) {
            variant.addDependencyConstraint(dependencyConstraint.group, dependencyConstraint.module, dependencyConstraint.versionConstraint, dependencyConstraint.reason, dependencyConstraint.attributes);
        }
        for (ImmutableCapability capability : capabilities) {
            variant.addCapability(capability.getGroup(), capability.getName(), capability.getVersion());
        }
    }

    private List<ModuleDependency> consumeVariantLocation(JsonReader reader) throws IOException {
        String url = null;
        String group = null;
        String module = null;
        String version = null;
        reader.beginObject();
        block12: while (reader.peek() != JsonToken.END_OBJECT) {
            String name;
            switch (name = reader.nextName()) {
                case "url": {
                    url = reader.nextString();
                    continue block12;
                }
                case "group": {
                    group = reader.nextString();
                    continue block12;
                }
                case "module": {
                    module = reader.nextString();
                    continue block12;
                }
                case "version": {
                    version = reader.nextString();
                    continue block12;
                }
            }
            this.consumeAny(reader);
        }
        this.assertDefined(reader, "url", url);
        this.assertDefined(reader, "group", group);
        this.assertDefined(reader, "module", module);
        this.assertDefined(reader, "version", version);
        reader.endObject();
        return ImmutableList.of((Object)new ModuleDependency(group, module, new DefaultImmutableVersionConstraint(version), (ImmutableList<ExcludeMetadata>)ImmutableList.of(), null, ImmutableAttributes.EMPTY, Collections.emptyList(), false, null));
    }

    private List<ModuleDependency> consumeDependencies(JsonReader reader) throws IOException {
        LinkedHashSet<ModuleDependency> dependencies = new LinkedHashSet<ModuleDependency>();
        reader.beginArray();
        while (reader.peek() != JsonToken.END_ARRAY) {
            String group = null;
            String module = null;
            String reason = null;
            ImmutableAttributes attributes = ImmutableAttributes.EMPTY;
            ImmutableVersionConstraint version = DefaultImmutableVersionConstraint.of();
            ImmutableList<ExcludeMetadata> excludes = ImmutableList.of();
            Object requestedCapabilities = ImmutableList.of();
            IvyArtifactName artifactSelector = null;
            boolean endorseStrictVersions = false;
            reader.beginObject();
            block23: while (reader.peek() != JsonToken.END_OBJECT) {
                String name;
                switch (name = reader.nextName()) {
                    case "group": {
                        group = reader.nextString();
                        continue block23;
                    }
                    case "module": {
                        module = reader.nextString();
                        continue block23;
                    }
                    case "version": {
                        version = this.consumeVersion(reader);
                        continue block23;
                    }
                    case "excludes": {
                        excludes = this.consumeExcludes(reader);
                        continue block23;
                    }
                    case "reason": {
                        reason = reader.nextString();
                        continue block23;
                    }
                    case "attributes": {
                        attributes = this.consumeAttributes(reader);
                        continue block23;
                    }
                    case "requestedCapabilities": {
                        requestedCapabilities = this.consumeCapabilities(reader, false);
                        continue block23;
                    }
                    case "endorseStrictVersions": {
                        endorseStrictVersions = reader.nextBoolean();
                        continue block23;
                    }
                    case "thirdPartyCompatibility": {
                        reader.beginObject();
                        while (reader.peek() != JsonToken.END_OBJECT) {
                            String compatibilityFeatureName = reader.nextName();
                            if (compatibilityFeatureName.equals("artifactSelector")) {
                                artifactSelector = this.consumeArtifactSelector(reader);
                                continue;
                            }
                            this.consumeAny(reader);
                        }
                        reader.endObject();
                        continue block23;
                    }
                }
                this.consumeAny(reader);
            }
            this.assertDefined(reader, "group", group);
            this.assertDefined(reader, "module", module);
            reader.endObject();
            dependencies.add(new ModuleDependency(group, module, version, excludes, reason, attributes, (List<ImmutableCapability>)requestedCapabilities, endorseStrictVersions, artifactSelector));
        }
        reader.endArray();
        return new ArrayList<ModuleDependency>(dependencies);
    }

    private IvyArtifactName consumeArtifactSelector(JsonReader reader) throws IOException {
        reader.beginObject();
        String artifactName = null;
        String type = null;
        String extension = null;
        String classifier = null;
        block12: while (reader.peek() != JsonToken.END_OBJECT) {
            String name;
            switch (name = reader.nextName()) {
                case "name": {
                    artifactName = reader.nextString();
                    continue block12;
                }
                case "type": {
                    type = reader.nextString();
                    continue block12;
                }
                case "extension": {
                    extension = reader.nextString();
                    continue block12;
                }
                case "classifier": {
                    classifier = reader.nextString();
                    continue block12;
                }
            }
            this.consumeAny(reader);
        }
        this.assertDefined(reader, "name", artifactName);
        this.assertDefined(reader, "type", type);
        if (extension == null) {
            extension = type;
        }
        reader.endObject();
        return new DefaultIvyArtifactName(artifactName, type, extension, classifier);
    }

    private List<ImmutableCapability> consumeCapabilities(JsonReader reader, boolean versionRequired) throws IOException {
        ImmutableList.Builder capabilities = ImmutableList.builder();
        reader.beginArray();
        while (reader.peek() != JsonToken.END_ARRAY) {
            String group = null;
            String name = null;
            String version = null;
            reader.beginObject();
            while (reader.peek() != JsonToken.END_OBJECT) {
                String val;
                switch (val = reader.nextName()) {
                    case "group": {
                        group = reader.nextString();
                        break;
                    }
                    case "name": {
                        name = reader.nextString();
                        break;
                    }
                    case "version": {
                        if (reader.peek() == JsonToken.NULL) {
                            reader.nextNull();
                            break;
                        }
                        version = reader.nextString();
                    }
                }
            }
            this.assertDefined(reader, "group", group);
            this.assertDefined(reader, "name", name);
            if (versionRequired) {
                this.assertDefined(reader, "version", version);
            }
            reader.endObject();
            capabilities.add((Object)new DefaultImmutableCapability(group, name, version));
        }
        reader.endArray();
        return capabilities.build();
    }

    private List<ModuleDependencyConstraint> consumeDependencyConstraints(JsonReader reader) throws IOException {
        LinkedHashSet<ModuleDependencyConstraint> dependencies = new LinkedHashSet<ModuleDependencyConstraint>();
        reader.beginArray();
        while (reader.peek() != JsonToken.END_ARRAY) {
            String group = null;
            String module = null;
            String reason = null;
            ImmutableVersionConstraint version = DefaultImmutableVersionConstraint.of();
            ImmutableAttributes attributes = ImmutableAttributes.EMPTY;
            reader.beginObject();
            block15: while (reader.peek() != JsonToken.END_OBJECT) {
                String name;
                switch (name = reader.nextName()) {
                    case "group": {
                        group = reader.nextString();
                        continue block15;
                    }
                    case "module": {
                        module = reader.nextString();
                        continue block15;
                    }
                    case "version": {
                        version = this.consumeVersion(reader);
                        continue block15;
                    }
                    case "reason": {
                        reason = reader.nextString();
                        continue block15;
                    }
                    case "attributes": {
                        attributes = this.consumeAttributes(reader);
                        continue block15;
                    }
                }
                this.consumeAny(reader);
            }
            this.assertDefined(reader, "group", group);
            this.assertDefined(reader, "module", module);
            reader.endObject();
            dependencies.add(new ModuleDependencyConstraint(group, module, version, reason, attributes));
        }
        reader.endArray();
        return new ArrayList<ModuleDependencyConstraint>(dependencies);
    }

    private ImmutableVersionConstraint consumeVersion(JsonReader reader) throws IOException {
        String requiredVersion = "";
        String preferredVersion = "";
        String strictVersion = "";
        ArrayList<String> rejects = new ArrayList<String>();
        reader.beginObject();
        block12: while (reader.peek() != JsonToken.END_OBJECT) {
            String cst;
            switch (cst = reader.nextName()) {
                case "prefers": {
                    preferredVersion = reader.nextString();
                    continue block12;
                }
                case "requires": {
                    requiredVersion = reader.nextString();
                    continue block12;
                }
                case "strictly": {
                    strictVersion = reader.nextString();
                    continue block12;
                }
                case "rejects": {
                    reader.beginArray();
                    while (reader.peek() != JsonToken.END_ARRAY) {
                        rejects.add(reader.nextString());
                    }
                    reader.endArray();
                    continue block12;
                }
            }
            this.consumeAny(reader);
        }
        reader.endObject();
        return DefaultImmutableVersionConstraint.of(preferredVersion, requiredVersion, strictVersion, rejects);
    }

    private ImmutableList<ExcludeMetadata> consumeExcludes(JsonReader reader) throws IOException {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        reader.beginArray();
        while (reader.peek() != JsonToken.END_ARRAY) {
            String group = null;
            String module = null;
            reader.beginObject();
            block9: while (reader.peek() != JsonToken.END_OBJECT) {
                String name;
                switch (name = reader.nextName()) {
                    case "group": {
                        group = reader.nextString();
                        continue block9;
                    }
                    case "module": {
                        module = reader.nextString();
                        continue block9;
                    }
                }
                this.consumeAny(reader);
            }
            reader.endObject();
            ExcludeMetadata exclude = this.excludeRuleConverter.createExcludeRule(group, module);
            builder.add((Object)exclude);
        }
        reader.endArray();
        return builder.build();
    }

    private List<ModuleFile> consumeFiles(JsonReader reader) throws IOException {
        ArrayList<ModuleFile> files = new ArrayList<ModuleFile>();
        reader.beginArray();
        while (reader.peek() != JsonToken.END_ARRAY) {
            String fileName = null;
            String fileUrl = null;
            reader.beginObject();
            block9: while (reader.peek() != JsonToken.END_OBJECT) {
                String name;
                switch (name = reader.nextName()) {
                    case "name": {
                        fileName = reader.nextString();
                        continue block9;
                    }
                    case "url": {
                        fileUrl = reader.nextString();
                        continue block9;
                    }
                }
                this.consumeAny(reader);
            }
            this.assertDefined(reader, "name", fileName);
            this.assertDefined(reader, "url", fileUrl);
            reader.endObject();
            files.add(new ModuleFile(fileName, fileUrl));
        }
        reader.endArray();
        return files;
    }

    private ImmutableAttributes consumeAttributes(JsonReader reader) throws IOException {
        ImmutableAttributes attributes = ImmutableAttributes.EMPTY;
        reader.beginObject();
        while (reader.peek() != JsonToken.END_OBJECT) {
            String attrName = reader.nextName();
            if (reader.peek() == JsonToken.BOOLEAN) {
                boolean attrValue = reader.nextBoolean();
                attributes = this.attributesFactory.concat(attributes, Attribute.of((String)attrName, Boolean.class), (Object)attrValue);
                continue;
            }
            if (reader.peek() == JsonToken.NUMBER) {
                Integer attrValue = reader.nextInt();
                attributes = this.attributesFactory.concat(attributes, Attribute.of((String)attrName, Integer.class), (Object)attrValue);
                continue;
            }
            String attrValue = reader.nextString();
            attributes = this.attributesFactory.concat(attributes, Attribute.of((String)attrName, String.class), (Isolatable)new CoercingStringValueSnapshot(attrValue, this.instantiator));
        }
        reader.endObject();
        return attributes;
    }

    private void consumeAny(JsonReader reader) throws IOException {
        reader.skipValue();
    }

    private void assertDefined(JsonReader reader, String attribute, String value) {
        if (StringUtils.isEmpty((String)value)) {
            String path = reader.getPath();
            throw new RuntimeException("missing '" + attribute + "' at " + path.substring(1, path.lastIndexOf(46)).replace('.', '/'));
        }
    }

    private static class ModuleFile {
        final String name;
        final String uri;

        ModuleFile(String name, String uri) {
            this.name = name;
            this.uri = uri;
        }
    }

    private static class ModuleDependency {
        final String group;
        final String module;
        final VersionConstraint versionConstraint;
        final ImmutableList<ExcludeMetadata> excludes;
        final String reason;
        final ImmutableAttributes attributes;
        final List<ImmutableCapability> requestedCapabilities;
        final boolean endorsing;
        final IvyArtifactName artifact;

        ModuleDependency(String group, String module, VersionConstraint versionConstraint, ImmutableList<ExcludeMetadata> excludes, String reason, ImmutableAttributes attributes, List<ImmutableCapability> requestedCapabilities, boolean endorsing, IvyArtifactName artifact) {
            this.group = group;
            this.module = module;
            this.versionConstraint = versionConstraint;
            this.excludes = excludes;
            this.reason = reason;
            this.attributes = attributes;
            this.requestedCapabilities = requestedCapabilities;
            this.endorsing = endorsing;
            this.artifact = artifact;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModuleDependency that = (ModuleDependency)o;
            return Objects.equal((Object)this.group, (Object)that.group) && Objects.equal((Object)this.module, (Object)that.module) && Objects.equal((Object)this.versionConstraint, (Object)that.versionConstraint) && Objects.equal(this.excludes, that.excludes) && Objects.equal((Object)this.reason, (Object)that.reason) && Objects.equal((Object)this.attributes, (Object)that.attributes) && Objects.equal(this.requestedCapabilities, that.requestedCapabilities) && this.endorsing == that.endorsing && Objects.equal((Object)this.artifact, (Object)that.artifact);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.group, this.module, this.versionConstraint, this.excludes, this.reason, this.attributes, this.endorsing, this.artifact});
        }
    }

    private static class ModuleDependencyConstraint {
        final String group;
        final String module;
        final VersionConstraint versionConstraint;
        final String reason;
        final ImmutableAttributes attributes;

        ModuleDependencyConstraint(String group, String module, VersionConstraint versionConstraint, String reason, ImmutableAttributes attributes) {
            this.group = group;
            this.module = module;
            this.versionConstraint = versionConstraint;
            this.reason = reason;
            this.attributes = attributes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModuleDependencyConstraint that = (ModuleDependencyConstraint)o;
            return Objects.equal((Object)this.group, (Object)that.group) && Objects.equal((Object)this.module, (Object)that.module) && Objects.equal((Object)this.versionConstraint, (Object)that.versionConstraint) && Objects.equal((Object)this.reason, (Object)that.reason) && Objects.equal((Object)this.attributes, (Object)that.attributes);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.group, this.module, this.versionConstraint, this.reason, this.attributes});
        }
    }
}

