---
date: 2025-04-29
slug: goreleaser-v2.9
categories: [announcements]
authors: [caarlos0]
---

# Announcing GoReleaser v2.9

This release introduces support to Python builds through [Poetry][] and [UV][]!

<!-- more -->

## Python builds

You can no build Python packages with [UV][] or [Poetry][].
You can run `goreleaser init` in your Python project, and it should generate the
appropriate `.goreleaser.yml` for you, but, basically, all you need is this:

```yaml title=".goreleaser.yaml"
builds:
  - builder: uv
    buildmode: wheel
```

You can also change `uv` to `poetry` if you want that instead, and you can also
add another build instance with `buildmode: sdist` if you need it.

You can see a full example [here](https://github.com/goreleaser/example-uv),
as well as docs for both [UV][] and [Poetry][].

## Other smaller changes

Python builds are the biggest news of this release, but we still put another
couple of good improvements in there:

- **pro**: license checks now properly handle canceled subscriptions;
- **pro**: custom publishers can now publish MSIs, DMGs, and SBOMs;
- **templates**: many [checksum functions][templates], so you can do things like
  `{{ sha256 .ArtifactPath }}`;
- **ko**: you can now pass `sbomDir` to your Ko configurations;
- **winget**: you can now set `privacy_url` and `installation_notes`;
- **fix**: GoReleaser will now issue better warnings when your configuration
  produces many artifacts with the same file path;

## Gophercon LATAM

I'll be speaking at [Gophercon LATAM 2025](https://gopherconlatam.org/) next
week!
Come chat if you go, I'll have stickers! :)

## Other news

- GoReleaser now has ~14.4k stars and 423 contributors! Thanks, everyone!
- We eventually discuss new features in our Discord server. 
  [Join the conversation][discord]!
- nFPM had new releases as well, 
  [check it out](https://github.com/goreleaser/nfpm/releases).

## Download

You can install or upgrade using your favorite package manager, or see the
full release notes and download the pre-compiled binaries from GitHub:

[:fontawesome-solid-download: Install][install]{ .md-button .md-button--primary }
[:fontawesome-brands-github: v2.9.0 (OSS)][oss-rel]{ .md-button }
[:fontawesome-brands-github: v2.9.0 (Pro)][pro-rel]{ .md-button }

## Helping out

You can help by reporting issues, contributing features, documentation
improvements, and bug fixes.
You can also sponsor the project, or get a GoReleaser Pro license.

[:material-professional-hexagon: Get the Pro license][pro]{ .md-button .md-button--primary }
[:simple-githubsponsors: Sponsor the project][sponsor]{ .md-button }

[sponsor]: https://goreleaser.com/sponsors
[pro]: https://goreleaser.com/pro
[install]: https://goreleaser.com/install
[pro-rel]: https://github.com/goreleaser/goreleaser-pro/releases/tag/v2.9.0
[oss-rel]: https://github.com/goreleaser/goreleaser/releases/tag/v2.9.0
[discord]: https://goreleaser.com/discord
[npm]: https://goreleaser.com/customization/npm
[ko]: https://goreleaser.com/customization/ko
[poetry]: https://goreleaser.com/customization/builds/poetry
[uv]: https://goreleaser.com/customization/builds/uv
[aur]: https://goreleaser.com/customization/aur
[aursources]: https://goreleaser.com/customization/aursources
[cloudsmith]: https://goreleaser.com/customization/cloudsmith
[notary]: https://goreleaser.com/customization/notarize/
[changelog]: https://goreleaser.com/customization/changelog
[deprecations]: https://goreleaser.com/deprecations
[partial]: https://goreleaser.com/customization/partial/
[nightly]: https://goreleaser.com/customization/nightlies/
[snapshot]: https://goreleaser.com/customization/snapshots/
[templates]: https://goreleaser.com/customization/templates/
