// Code generated by 'ccgo -lmodernc.org/z/lib -o internal\example_windows_arm64.go -trace-translation-units C:\Users\jnml\AppData\Local\Temp\go-generate-2743941486\cdb.json example.exe', DO NOT EDIT.

package main

import (
	"math"
	"reflect"
	"sync/atomic"
	"unsafe"

	"modernc.org/libc"
	"modernc.org/libc/sys/types"
	"modernc.org/z/lib"
)

var _ = math.Pi
var _ reflect.Kind
var _ atomic.Value
var _ unsafe.Pointer
var _ *libc.TLS
var _ types.Size_t

func main() { libc.Start(main1) }

type ptrdiff_t = int64 /* <builtin>:3:26 */

type size_t = uint64 /* <builtin>:9:23 */

type wchar_t = uint16 /* <builtin>:15:24 */

type va_list = uintptr /* <builtin>:50:27 */

// ===---- __stddef_max_align_t.h - Definition of max_align_t for modules ---===
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===-----------------------------------------------------------------------===

// Define 'max_align_t' to match the GCC definition.
type max_align_t = struct {
	__clang_max_align_nonce1 int64
	__clang_max_align_nonce2 float64
} /* __stddef_max_align_t.h:24:3 */

// Some C libraries expect to see a wint_t here. Others (notably MinGW) will use
// __WINT_TYPE__ directly; accommodate both by requiring __need_wint_t

type z_size_t = size_t /* zconf.h:248:21 */

// Maximum value for memLevel in deflateInit2

// Maximum value for windowBits in deflateInit2 and inflateInit2.
// WARNING: reducing MAX_WBITS makes minigzip unable to extract .gz files
// created by gzip. (Files created by minigzip can still be extracted by
// gzip.)

// The memory requirements for deflate are (in bytes):
//             (1 << (windowBits+2)) +  (1 << (memLevel+9))
//  that is: 128K for windowBits=15  +  128K for memLevel = 8  (default values)
//  plus a few kilobytes for small objects. For example, if you want to reduce
//  the default memory requirements from 256K to 128K, compile with
//      make CFLAGS="-O -DMAX_WBITS=14 -DMAX_MEM_LEVEL=7"
//  Of course this will generally degrade compression (there's no free lunch).
//
//    The memory requirements for inflate are (in bytes) 1 << windowBits
//  that is, 32K for windowBits=15 (default value) plus about 7 kilobytes
//  for small objects.

// Type declarations

// The following definitions for FAR are needed only for MSDOS mixed
// model programming (small or medium model with some far allocations).
// This was tested only with MSC; for other MSDOS compilers you may have
// to define NO_MEMCPY in zutil.h.  If you don't need the mixed model,
// just define FAR to be empty.

// If building or using zlib as a DLL, define ZLIB_DLL.
// This is not mandatory, but it offers a little performance increase.
// If building or using zlib with the WINAPI/WINAPIV calling convention,
// define ZLIB_WINAPI.
// Caution: the standard ZLIB1.DLL is NOT compiled using ZLIB_WINAPI.

type Byte = uint8   /* zconf.h:391:24 */ // 8 bits
type uInt = uint32  /* zconf.h:393:24 */ // 16 bits or more
type uLong = uint32 /* zconf.h:394:24 */ // 32 bits or more

type Bytef = Byte   /* zconf.h:400:22 */
type charf = int8   /* zconf.h:402:19 */
type intf = int32   /* zconf.h:403:19 */
type uIntf = uInt   /* zconf.h:404:19 */
type uLongf = uLong /* zconf.h:405:19 */

type voidpc = uintptr /* zconf.h:408:23 */
type voidpf = uintptr /* zconf.h:409:23 */
type voidp = uintptr  /* zconf.h:410:23 */

//===---- limits.h - Standard header for integer sizes --------------------===* *
//  Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
//  See https://llvm.org/LICENSE.txt for license information.
//  SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
// \*===----------------------------------------------------------------------===

// The system's limits.h may, in turn, try to #include_next GCC's limits.h.
//    Avert this #include_next madness.

// System headers include a number of constants from POSIX in <limits.h>.
//    Include it if we're hosted.

// Many system headers try to "help us out" by defining these.  No really, we
//    know how big each datatype is.

// C90/99 5.2.4.2.1

// C2x 5.2.4.2.1
// FIXME: This is using the placeholder dates Clang produces for these macros
//    in C2x mode; switch to the correct values once they've been published.

// C99 5.2.4.2.1: Added long long.
//    C++11 18.3.3.2: same contents as the Standard C Library header <limits.h>.
//

// LONG_LONG_MIN/LONG_LONG_MAX/ULONG_LONG_MAX are a GNU extension.  It's too bad
//    that we don't have something like #pragma poison that could be used to
//    deprecate a macro - the code should just use LLONG_MAX and friends.
//

type z_crc_t = uint32 /* zconf.h:429:17 */

type ssize_t = int64 /* corecrt.h:45:35 */

type rsize_t = size_t /* corecrt.h:52:16 */

type intptr_t = int64 /* corecrt.h:62:35 */

type uintptr_t = uint64 /* corecrt.h:75:44 */

type wint_t = uint16   /* corecrt.h:106:24 */
type wctype_t = uint16 /* corecrt.h:107:24 */

type errno_t = int32 /* corecrt.h:113:13 */

type time_t = int64 /* corecrt.h:138:20 */

type threadlocaleinfostruct = struct {
	_locale_pctype      uintptr
	_locale_mb_cur_max  int32
	_locale_lc_codepage uint32
} /* corecrt.h:430:1 */

type pthreadlocinfo = uintptr /* corecrt.h:432:39 */
type pthreadmbcinfo = uintptr /* corecrt.h:433:36 */

type localeinfo_struct = struct {
	locinfo pthreadlocinfo
	mbcinfo pthreadmbcinfo
} /* corecrt.h:436:9 */

type _locale_tstruct = localeinfo_struct /* corecrt.h:439:3 */
type _locale_t = uintptr                 /* corecrt.h:439:19 */

type tagLC_ID = struct {
	wLanguage uint16
	wCountry  uint16
	wCodePage uint16
} /* corecrt.h:443:9 */

type LC_ID = tagLC_ID  /* corecrt.h:447:3 */
type LPLC_ID = uintptr /* corecrt.h:447:9 */

type threadlocinfo = threadlocaleinfostruct /* corecrt.h:482:3 */

type _ino_t = uint16 /* types.h:43:24 */
type ino_t = uint16  /* types.h:45:24 */

type _dev_t = uint32 /* types.h:51:22 */
type dev_t = uint32  /* types.h:53:22 */

type _pid_t = int64 /* types.h:63:17 */

type pid_t = _pid_t /* types.h:68:16 */

type _mode_t = uint16 /* types.h:74:24 */

type mode_t = _mode_t /* types.h:77:17 */

type _off_t = int32  /* _mingw_off_t.h:5:16 */
type off32_t = int32 /* _mingw_off_t.h:7:16 */

type _off64_t = int64 /* _mingw_off_t.h:13:39 */
type off64_t = int64  /* _mingw_off_t.h:15:39 */

type off_t = off64_t /* _mingw_off_t.h:24:17 */

type useconds_t = uint32 /* types.h:84:22 */

type timespec = struct {
	tv_sec  time_t
	tv_nsec int32
	_       [4]byte
} /* types.h:89:1 */

type itimerspec = struct {
	it_interval struct {
		tv_sec  time_t
		tv_nsec int32
		_       [4]byte
	}
	it_value struct {
		tv_sec  time_t
		tv_nsec int32
		_       [4]byte
	}
} /* types.h:94:1 */

type _sigset_t = uint64 /* types.h:104:28 */

// GCC always defines __va_copy, but does not define va_copy unless in c99 mode
// or -ansi is not specified, since it was not part of C90.

// ===---- stddef.h - Basic type definitions --------------------------------===
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===-----------------------------------------------------------------------===

// a little trick to accommodate both "#define _LARGEFILE64_SOURCE" and
// "#define _LARGEFILE64_SOURCE 1" as requesting 64-bit operations, (even
// though the former does not conform to the LFS document), but considering
// both "#undef _LARGEFILE64_SOURCE" and "#define _LARGEFILE64_SOURCE 0" as
// equivalently requesting no 64-bit operations

// MVS linker does not support external names larger than 8 bytes

//
//     The 'zlib' compression library provides in-memory compression and
//   decompression functions, including integrity checks of the uncompressed data.
//   This version of the library supports only one compression method (deflation)
//   but other algorithms will be added later and will have the same stream
//   interface.
//
//     Compression can be done in a single step if the buffers are large enough,
//   or can be done by repeated calls of the compression function.  In the latter
//   case, the application must provide more input and/or consume the output
//   (providing more output space) before each call.
//
//     The compressed data format used by default by the in-memory functions is
//   the zlib format, which is a zlib wrapper documented in RFC 1950, wrapped
//   around a deflate stream, which is itself documented in RFC 1951.
//
//     The library also supports reading and writing files in gzip (.gz) format
//   with an interface similar to that of stdio using the functions that start
//   with "gz".  The gzip format is different from the zlib format.  gzip is a
//   gzip wrapper, documented in RFC 1952, wrapped around a deflate stream.
//
//     This library can optionally read and write gzip and raw deflate streams in
//   memory as well.
//
//     The zlib format was designed to be compact and fast for use in memory
//   and on communications channels.  The gzip format was designed for single-
//   file compression on file systems, has a larger header than zlib to maintain
//   directory information, and uses a different, slower check method than zlib.
//
//     The library does not install any signal handler.  The decoder checks
//   the consistency of the compressed data, so the library should never crash
//   even in the case of corrupted input.

type alloc_func = uintptr /* zlib.h:81:16 */
type free_func = uintptr  /* zlib.h:82:16 */

type z_stream_s = struct {
	next_in   uintptr
	avail_in  uInt
	total_in  uLong
	next_out  uintptr
	avail_out uInt
	total_out uLong
	msg       uintptr
	state     uintptr
	zalloc    alloc_func
	zfree     free_func
	opaque    voidpf
	data_type int32
	adler     uLong
	reserved  uLong
	_         [4]byte
} /* zlib.h:86:9 */

type z_stream = z_stream_s /* zlib.h:106:3 */

type z_streamp = uintptr /* zlib.h:108:22 */

//
//      gzip header information passed to and from zlib routines.  See RFC 1952
//   for more details on the meanings of these fields.
type gz_header_s = struct {
	text      int32
	time      uLong
	xflags    int32
	os        int32
	extra     uintptr
	extra_len uInt
	extra_max uInt
	name      uintptr
	name_max  uInt
	_         [4]byte
	comment   uintptr
	comm_max  uInt
	hcrc      int32
	done      int32
	_         [4]byte
} /* zlib.h:114:9 */

//
//      gzip header information passed to and from zlib routines.  See RFC 1952
//   for more details on the meanings of these fields.
type gz_header = gz_header_s /* zlib.h:129:3 */

type gz_headerp = uintptr /* zlib.h:131:23 */
//
//      inflateGetHeader() requests that gzip header information be stored in the
//    provided gz_header structure.  inflateGetHeader() may be called after
//    inflateInit2() or inflateReset(), and before the first call of inflate().
//    As inflate() processes the gzip stream, head->done is zero until the header
//    is completed, at which time head->done is set to one.  If a zlib stream is
//    being decoded, then head->done is set to -1 to indicate that there will be
//    no gzip header information forthcoming.  Note that Z_BLOCK or Z_TREES can be
//    used to force inflate() to return immediately after header processing is
//    complete and before any actual data is decompressed.
//
//      The text, time, xflags, and os fields are filled in with the gzip header
//    contents.  hcrc is set to true if there is a header CRC.  (The header CRC
//    was valid if done is set to one.) If extra is not Z_NULL, then extra_max
//    contains the maximum number of bytes to write to extra.  Once done is true,
//    extra_len contains the actual extra field length, and extra contains the
//    extra field, or that field truncated if extra_max is less than extra_len.
//    If name is not Z_NULL, then up to name_max characters are written there,
//    terminated with a zero unless the length is greater than name_max.  If
//    comment is not Z_NULL, then up to comm_max characters are written there,
//    terminated with a zero unless the length is greater than comm_max.  When any
//    of extra, name, or comment are not Z_NULL and the respective field is not
//    present in the header, then that field is set to Z_NULL to signal its
//    absence.  This allows the use of deflateSetHeader() with the returned
//    structure to duplicate the header.  However if those fields are set to
//    allocated memory, then the application will need to save those pointers
//    elsewhere so that they can be eventually freed.
//
//      If inflateGetHeader is not used, then the header information is simply
//    discarded.  The header is always checked for validity, including the header
//    CRC if present.  inflateReset() will reset the process to discard the header
//    information.  The application would need to call inflateGetHeader() again to
//    retrieve the header from the next gzip stream.
//
//      inflateGetHeader returns Z_OK if success, or Z_STREAM_ERROR if the source
//    stream state was inconsistent.

//
// ZEXTERN int ZEXPORT inflateBackInit OF((z_streamp strm, int windowBits,
//                                         unsigned char FAR *window));
//
//      Initialize the internal stream state for decompression using inflateBack()
//    calls.  The fields zalloc, zfree and opaque in strm must be initialized
//    before the call.  If zalloc and zfree are Z_NULL, then the default library-
//    derived memory allocation routines are used.  windowBits is the base two
//    logarithm of the window size, in the range 8..15.  window is a caller
//    supplied buffer of that size.  Except for special applications where it is
//    assured that deflate was used with small window sizes, windowBits must be 15
//    and a 32K byte window must be supplied to be able to decompress general
//    deflate streams.
//
//      See inflateBack() for the usage of these routines.
//
//      inflateBackInit will return Z_OK on success, Z_STREAM_ERROR if any of
//    the parameters are invalid, Z_MEM_ERROR if the internal state could not be
//    allocated, or Z_VERSION_ERROR if the version of the library does not match
//    the version of the header file.

type in_func = uintptr  /* zlib.h:1092:18 */
type out_func = uintptr /* zlib.h:1094:13 */
//
//      Same as uncompress, except that sourceLen is a pointer, where the
//    length of the source is *sourceLen.  On return, *sourceLen is the number of
//    source bytes consumed.

// gzip file access functions

//
//      This library supports reading and writing files in gzip (.gz) format with
//    an interface similar to that of stdio, using the functions that start with
//    "gz".  The gzip format is different from the zlib format.  gzip is a gzip
//    wrapper, documented in RFC 1952, wrapped around a deflate stream.

type gzFile_s = struct {
	have uint32
	_    [4]byte
	next uintptr
	pos  int32
	_    [4]byte
} /* zlib.h:1300:9 */

//
//      Same as uncompress, except that sourceLen is a pointer, where the
//    length of the source is *sourceLen.  On return, *sourceLen is the number of
//    source bytes consumed.

// gzip file access functions

//
//      This library supports reading and writing files in gzip (.gz) format with
//    an interface similar to that of stdio, using the functions that start with
//    "gz".  The gzip format is different from the zlib format.  gzip is a gzip
//    wrapper, documented in RFC 1952, wrapped around a deflate stream.

type gzFile = uintptr /* zlib.h:1300:25 */

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the Wine project.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

type _iobuf = struct{ _Placeholder uintptr } /* stdio.h:33:3 */

type FILE = _iobuf /* stdio.h:47:25 */

type fpos_t = int64 /* stdio.h:115:37 */

func vsnwprintf(tls *libc.TLS, s uintptr, n size_t, format uintptr, arg va_list) int32 { /* stdio.h:1321:15: */
	var __ret int32 = libc.X__stdio_common_vswprintf(tls, 0x0004, s, n, format, uintptr(0), arg)
	if __ret < 0 {
		return -1
	}
	return __ret

}

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// ===-------- vadefs.h ---------------------------------------------------===
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===-----------------------------------------------------------------------===

// Only include this if we are aiming for MSVC compatibility.
// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

func vswprintf(tls *libc.TLS, __stream uintptr, __count size_t, __format uintptr, __local_argv uintptr) int32 { /* swprintf.inl:27:5: */
	return vsnwprintf(tls, __stream, __count, __format, __local_argv)
}

func _vfscanf_s_l(tls *libc.TLS, _File uintptr, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:40:27: */
	return libc.X__stdio_common_vfscanf(tls, 0x0001, _File, _Format, _Locale, _ArgList)

}

func _vfscanf_l(tls *libc.TLS, _File uintptr, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:85:27: */
	return libc.X__stdio_common_vfscanf(tls, uint64(0), _File, _Format, _Locale, _ArgList)

}

func _vsscanf_s_l(tls *libc.TLS, _Src uintptr, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:108:27: */
	return libc.X__stdio_common_vsscanf(tls, 0x0001, _Src, libc.Uint64(libc.Uint64FromInt32(-1)), _Format, _Locale, _ArgList)

}

func _vsscanf_l(tls *libc.TLS, _Src uintptr, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:135:27: */
	return libc.X__stdio_common_vsscanf(tls, uint64(0), _Src, libc.Uint64(libc.Uint64FromInt32(-1)), _Format, _Locale, _ArgList)

}

func _vfprintf_s_l(tls *libc.TLS, _File uintptr, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:181:27: */
	return libc.X__stdio_common_vfprintf_s(tls, uint64(0), _File, _Format, _Locale, _ArgList)

}

func _vsnprintf_c_l(tls *libc.TLS, _DstBuf uintptr, _MaxCount size_t, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:234:27: */
	return libc.X__stdio_common_vsprintf(tls, uint64(0), _DstBuf, _MaxCount, _Format, _Locale, _ArgList)

}

func _vsnprintf_s_l(tls *libc.TLS, _DstBuf uintptr, _DstSize size_t, _MaxCount size_t, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:261:27: */
	return libc.X__stdio_common_vsnprintf_s(tls, uint64(0), _DstBuf, _DstSize, _MaxCount, _Format, _Locale, _ArgList)

}

func _vsprintf_s_l(tls *libc.TLS, _DstBuf uintptr, _DstSize size_t, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:292:27: */
	return libc.X__stdio_common_vsprintf_s(tls, uint64(0), _DstBuf, _DstSize, _Format, _Locale, _ArgList)

}

func _vfprintf_p_l(tls *libc.TLS, _File uintptr, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:319:27: */
	return libc.X__stdio_common_vfprintf_p(tls, uint64(0), _File, _Format, _Locale, _ArgList)

}

func _vsprintf_p_l(tls *libc.TLS, _DstBuf uintptr, _MaxCount size_t, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:372:27: */
	return libc.X__stdio_common_vsprintf_p(tls, uint64(0), _DstBuf, _MaxCount, _Format, _Locale, _ArgList)

}

func _vscprintf_p_l(tls *libc.TLS, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:399:27: */
	return libc.X__stdio_common_vsprintf_p(tls, 0x0002, uintptr(0), uint64(0), _Format, _Locale, _ArgList)

}

func _vfprintf_l(tls *libc.TLS, _File uintptr, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:426:27: */
	return libc.X__stdio_common_vfprintf(tls, uint64(0), _File, _Format, _Locale, _ArgList)

}

func _vsnprintf_l(tls *libc.TLS, _DstBuf uintptr, _MaxCount size_t, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:453:27: */
	return libc.X__stdio_common_vsprintf(tls, 0x0001, _DstBuf, _MaxCount, _Format, _Locale, _ArgList)

}

func _vsprintf_l(tls *libc.TLS, _DstBuf uintptr, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:466:27: */
	return _vsnprintf_l(tls, _DstBuf, libc.Uint64(libc.Uint64FromInt32(-1)), _Format, _Locale, _ArgList)

}

func _vscprintf_l(tls *libc.TLS, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:480:27: */
	return libc.X__stdio_common_vsprintf(tls, 0x0002, uintptr(0), uint64(0), _Format, _Locale, _ArgList)

}

func _vfwscanf_s_l(tls *libc.TLS, _File uintptr, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:588:27: */
	return libc.X__stdio_common_vfwscanf(tls, 0x0002|0x0001, _File, _Format, _Locale, _ArgList)

}

func _vswscanf_s_l(tls *libc.TLS, _Src uintptr, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:633:27: */
	return libc.X__stdio_common_vswscanf(tls, 0x0002|0x0001, _Src, libc.Uint64(libc.Uint64FromInt32(-1)), _Format, _Locale, _ArgList)

}

func _vsnwscanf_s_l(tls *libc.TLS, _Src uintptr, _MaxCount size_t, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:656:27: */
	return libc.X__stdio_common_vswscanf(tls, 0x0002|0x0001, _Src, _MaxCount, _Format, _Locale, _ArgList)

}

func _vfwprintf_s_l(tls *libc.TLS, _File uintptr, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:679:27: */
	return libc.X__stdio_common_vfwprintf_s(tls, 0x0004, _File, _Format, _Locale, _ArgList)

}

func _vswprintf_s_l(tls *libc.TLS, _DstBuf uintptr, _DstSize size_t, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:732:27: */
	return libc.X__stdio_common_vswprintf_s(tls, 0x0004, _DstBuf, _DstSize, _Format, _Locale, _ArgList)

}

func _vsnwprintf_s_l(tls *libc.TLS, _DstBuf uintptr, _DstSize size_t, _MaxCount size_t, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:759:27: */
	return libc.X__stdio_common_vsnwprintf_s(tls, 0x0004, _DstBuf, _DstSize, _MaxCount, _Format, _Locale, _ArgList)

}

//===---- limits.h - Standard header for integer sizes --------------------===* *
//  Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
//  See https://llvm.org/LICENSE.txt for license information.
//  SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
// \*===----------------------------------------------------------------------===

type _onexit_t = uintptr /* stdlib.h:50:15 */

type _div_t = struct {
	quot int32
	rem  int32
} /* stdlib.h:60:11 */

type div_t = _div_t /* stdlib.h:63:5 */

type _ldiv_t = struct {
	quot int32
	rem  int32
} /* stdlib.h:65:11 */

type ldiv_t = _ldiv_t /* stdlib.h:68:5 */

type _LDOUBLE = struct{ ld [10]uint8 } /* stdlib.h:77:5 */

type _CRT_DOUBLE = struct{ x float64 } /* stdlib.h:84:5 */

type _CRT_FLOAT = struct{ f float32 } /* stdlib.h:88:5 */

type _LONGDOUBLE = struct{ x float64 } /* stdlib.h:95:5 */

type _LDBL12 = struct{ ld12 [12]uint8 } /* stdlib.h:102:5 */

type _purecall_handler = uintptr /* stdlib.h:143:16 */

type _invalid_parameter_handler = uintptr /* stdlib.h:148:16 */

type lldiv_t = struct {
	quot int64
	rem  int64
} /* stdlib.h:724:61 */

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// Return codes for _heapwalk()

// Values for _heapinfo.useflag

// The structure used to walk through the heap with _heapwalk.
type _heapinfo = struct {
	_pentry  uintptr
	_size    size_t
	_useflag int32
	_        [4]byte
} /* malloc.h:46:11 */

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// Return codes for _heapwalk()

// Values for _heapinfo.useflag

// The structure used to walk through the heap with _heapwalk.
type _HEAPINFO = _heapinfo /* malloc.h:50:5 */

var hello = *(*[14]int8)(unsafe.Pointer(ts)) /* example.c:29:21 */
// "hello world" would be more standard, but the repeated "hello"
// stresses the compression code better, sorry...

var dictionary = *(*[6]int8)(unsafe.Pointer(ts + 14)) /* example.c:34:19 */
var dictId uLong                                      /* example.c:35:14: */

var zalloc alloc_func = uintptr(0) /* example.c:77:19 */
var zfree free_func = uintptr(0)   /* example.c:78:18 */

// ===========================================================================
// Test compress() and uncompress()
func test_compress(tls *libc.TLS, compr uintptr, comprLen uLong, uncompr uintptr, uncomprLen uLong) { /* example.c:88:6: */
	bp := tls.Alloc(48)
	defer tls.Free(48)
	*(*uLong)(unsafe.Pointer(bp + 40)) = comprLen
	*(*uLong)(unsafe.Pointer(bp + 44)) = uncomprLen

	var err int32
	var len uLong = uLong(libc.Xstrlen(tls, uintptr(unsafe.Pointer(&hello)))) + uLong(1)

	err = z.Xcompress(tls, compr, bp+40, uintptr(uintptr(unsafe.Pointer(&hello))), len)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp, ts+34, err))
			libc.Xexit(tls, 1)
		}
	}

	libc.Xstrcpy(tls, uncompr, ts+43)

	err = z.Xuncompress(tls, uncompr, bp+44, compr, *(*uLong)(unsafe.Pointer(bp + 40 /* comprLen */)))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp+16, ts+51, err))
			libc.Xexit(tls, 1)
		}
	}

	if libc.Xstrcmp(tls, uncompr, uintptr(unsafe.Pointer(&hello))) != 0 {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+62, 0)
		libc.Xexit(tls, 1)
	} else {
		libc.Xprintf(tls, ts+78, libc.VaList(bp+32, uncompr))
	}
}

// ===========================================================================
// Test read/write of .gz files
func test_gzio(tls *libc.TLS, fname uintptr, uncompr uintptr, uncomprLen uLong) { /* example.c:114:6: */
	bp := tls.Alloc(84)
	defer tls.Free(84)

	// var err int32 at bp+80, 4

	var len int32 = int32(libc.Xstrlen(tls, uintptr(unsafe.Pointer(&hello)))) + 1
	var file gzFile
	var pos int32

	file = z.Xgzopen(tls, fname, ts+96)
	if file == uintptr(0) {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+99, 0)
		libc.Xexit(tls, 1)
	}
	z.Xgzputc(tls, file, 'h')
	if z.Xgzputs(tls, file, ts+113) != 4 {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+118, libc.VaList(bp, z.Xgzerror(tls, file, bp+80)))
		libc.Xexit(tls, 1)
	}
	if z.Xgzprintf(tls, file, ts+134, libc.VaList(bp+8, ts+14)) != 8 {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+140, libc.VaList(bp+16, z.Xgzerror(tls, file, bp+80)))
		libc.Xexit(tls, 1)
	}
	z.Xgzseek(tls, file, 1, 1) // add one zero byte
	z.Xgzclose(tls, file)

	file = z.Xgzopen(tls, fname, ts+158)
	if file == uintptr(0) {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+99, 0)
		libc.Xexit(tls, 1)
	}
	libc.Xstrcpy(tls, uncompr, ts+43)

	if z.Xgzread(tls, file, uncompr, uint32(uncomprLen)) != len {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+161, libc.VaList(bp+24, z.Xgzerror(tls, file, bp+80)))
		libc.Xexit(tls, 1)
	}
	if libc.Xstrcmp(tls, uncompr, uintptr(unsafe.Pointer(&hello))) != 0 {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+177, libc.VaList(bp+32, uncompr))
		libc.Xexit(tls, 1)
	} else {
		libc.Xprintf(tls, ts+193, libc.VaList(bp+40, uncompr))
	}

	pos = z.Xgzseek(tls, file, -8, 1)
	if pos != 6 || z.Xgztell(tls, file) != pos {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+207,
			libc.VaList(bp+48, pos, z.Xgztell(tls, file)))
		libc.Xexit(tls, 1)
	}

	if func() int32 {
		if (*gzFile_s)(unsafe.Pointer(file)).have != 0 {
			return int32(func() uint8 {
				(*gzFile_s)(unsafe.Pointer(file)).have--
				(*gzFile_s)(unsafe.Pointer(file)).pos++
				return *(*uint8)(unsafe.Pointer(libc.PostIncUintptr(&(*gzFile_s)(unsafe.Pointer(file)).next, 1)))
			}())
		}
		return z.Xgzgetc(tls, file)
	}() != ' ' {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+242, 0)
		libc.Xexit(tls, 1)
	}

	if z.Xgzungetc(tls, ' ', file) != ' ' {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+256, 0)
		libc.Xexit(tls, 1)
	}

	z.Xgzgets(tls, file, uncompr, int32(uncomprLen))
	if libc.Xstrlen(tls, uncompr) != uint64(7) { // " hello!"
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+272, libc.VaList(bp+64, z.Xgzerror(tls, file, bp+80)))
		libc.Xexit(tls, 1)
	}
	if libc.Xstrcmp(tls, uncompr, uintptr(unsafe.Pointer(&hello))+uintptr(6)) != 0 {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+301, 0)
		libc.Xexit(tls, 1)
	} else {
		libc.Xprintf(tls, ts+326, libc.VaList(bp+72, uncompr))
	}

	z.Xgzclose(tls, file)
}

// ===========================================================================
// Test deflate() with small buffers
func test_deflate(tls *libc.TLS, compr uintptr, comprLen uLong) { /* example.c:200:6: */
	bp := tls.Alloc(152)
	defer tls.Free(152)

	// var c_stream z_stream at bp+64, 88
	// compression stream
	var err int32
	var len uLong = uLong(libc.Xstrlen(tls, uintptr(unsafe.Pointer(&hello)))) + uLong(1)

	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).opaque = uintptr(0)

	err = z.XdeflateInit_(tls, bp+64, -1, ts+353, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp, ts+360, err))
			libc.Xexit(tls, 1)
		}
	}

	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).next_in = uintptr(uintptr(unsafe.Pointer(&hello)))
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).next_out = compr

	for (*z_stream)(unsafe.Pointer(bp+64)).total_in != len && (*z_stream)(unsafe.Pointer(bp+64)).total_out < comprLen {
		(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).avail_in = libc.AssignPtrUint32(bp+64+24, uInt(1)) // force small buffers
		err = z.Xdeflate(tls, bp+64, 0)
		{
			if err != 0 {
				libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp+16, ts+372, err))
				libc.Xexit(tls, 1)
			}
		}

	}
	// Finish the stream, still forcing small buffers:
	for {
		(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).avail_out = uInt(1)
		err = z.Xdeflate(tls, bp+64, 4)
		if err == 1 {
			break
		}
		{
			if err != 0 {
				libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp+32, ts+372, err))
				libc.Xexit(tls, 1)
			}
		}

	}

	err = z.XdeflateEnd(tls, bp+64)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp+48, ts+380, err))
			libc.Xexit(tls, 1)
		}
	}

}

// ===========================================================================
// Test inflate() with small buffers
func test_inflate(tls *libc.TLS, compr uintptr, comprLen uLong, uncompr uintptr, uncomprLen uLong) { /* example.c:238:6: */
	bp := tls.Alloc(144)
	defer tls.Free(144)

	var err int32
	// var d_stream z_stream at bp+56, 88
	// decompression stream

	libc.Xstrcpy(tls, uncompr, ts+43)

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).opaque = uintptr(0)

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).next_in = compr
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).avail_in = uInt(0)
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).next_out = uncompr

	err = z.XinflateInit_(tls, bp+56, ts+353, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp, ts+391, err))
			libc.Xexit(tls, 1)
		}
	}

	for (*z_stream)(unsafe.Pointer(bp+56)).total_out < uncomprLen && (*z_stream)(unsafe.Pointer(bp+56)).total_in < comprLen {
		(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).avail_in = libc.AssignPtrUint32(bp+56+24, uInt(1)) // force small buffers
		err = z.Xinflate(tls, bp+56, 0)
		if err == 1 {
			break
		}
		{
			if err != 0 {
				libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp+16, ts+403, err))
				libc.Xexit(tls, 1)
			}
		}

	}

	err = z.XinflateEnd(tls, bp+56)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp+32, ts+411, err))
			libc.Xexit(tls, 1)
		}
	}

	if libc.Xstrcmp(tls, uncompr, uintptr(unsafe.Pointer(&hello))) != 0 {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+422, 0)
		libc.Xexit(tls, 1)
	} else {
		libc.Xprintf(tls, ts+435, libc.VaList(bp+48, uncompr))
	}
}

// ===========================================================================
// Test deflate() with large buffers and dynamic change of compression level
func test_large_deflate(tls *libc.TLS, compr uintptr, comprLen uLong, uncompr uintptr, uncomprLen uLong) { /* example.c:279:6: */
	bp := tls.Alloc(168)
	defer tls.Free(168)

	// var c_stream z_stream at bp+80, 88
	// compression stream
	var err int32

	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).opaque = uintptr(0)

	err = z.XdeflateInit_(tls, bp+80, 1, ts+353, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp, ts+360, err))
			libc.Xexit(tls, 1)
		}
	}

	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).next_out = compr
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).avail_out = uInt(comprLen)

	// At this point, uncompr is still mostly zeroes, so it should compress
	// very well:
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).next_in = uncompr
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).avail_in = uInt(uncomprLen)
	err = z.Xdeflate(tls, bp+80, 0)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp+16, ts+372, err))
			libc.Xexit(tls, 1)
		}
	}

	if (*z_stream)(unsafe.Pointer(bp+80)).avail_in != uInt(0) {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+450, 0)
		libc.Xexit(tls, 1)
	}

	// Feed in already compressed data and switch to no compression:
	z.XdeflateParams(tls, bp+80, 0, 0)
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).next_in = compr
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).avail_in = uInt(comprLen) / uInt(2)
	err = z.Xdeflate(tls, bp+80, 0)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp+32, ts+372, err))
			libc.Xexit(tls, 1)
		}
	}

	// Switch back to compressing mode:
	z.XdeflateParams(tls, bp+80, 9, 1)
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).next_in = uncompr
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).avail_in = uInt(uncomprLen)
	err = z.Xdeflate(tls, bp+80, 0)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp+48, ts+372, err))
			libc.Xexit(tls, 1)
		}
	}

	err = z.Xdeflate(tls, bp+80, 4)
	if err != 1 {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+470, 0)
		libc.Xexit(tls, 1)
	}
	err = z.XdeflateEnd(tls, bp+80)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp+64, ts+380, err))
			libc.Xexit(tls, 1)
		}
	}

}

// ===========================================================================
// Test inflate() with large buffers
func test_large_inflate(tls *libc.TLS, compr uintptr, comprLen uLong, uncompr uintptr, uncomprLen uLong) { /* example.c:334:6: */
	bp := tls.Alloc(144)
	defer tls.Free(144)

	var err int32
	// var d_stream z_stream at bp+56, 88
	// decompression stream

	libc.Xstrcpy(tls, uncompr, ts+43)

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).opaque = uintptr(0)

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).next_in = compr
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).avail_in = uInt(comprLen)

	err = z.XinflateInit_(tls, bp+56, ts+353, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp, ts+391, err))
			libc.Xexit(tls, 1)
		}
	}

	for {
		(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).next_out = uncompr // discard the output
		(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).avail_out = uInt(uncomprLen)
		err = z.Xinflate(tls, bp+56, 0)
		if err == 1 {
			break
		}
		{
			if err != 0 {
				libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp+16, ts+506, err))
				libc.Xexit(tls, 1)
			}
		}

	}

	err = z.XinflateEnd(tls, bp+56)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp+32, ts+411, err))
			libc.Xexit(tls, 1)
		}
	}

	if (*z_stream)(unsafe.Pointer(bp+56)).total_out != uLong(2)*uncomprLen+comprLen/uLong(2) {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+520, libc.VaList(bp+48, (*z_stream)(unsafe.Pointer(bp+56 /* &d_stream */)).total_out))
		libc.Xexit(tls, 1)
	} else {
		libc.Xprintf(tls, ts+544, 0)
	}
}

// ===========================================================================
// Test deflate() with full flush
func test_flush(tls *libc.TLS, compr uintptr, comprLen uintptr) { /* example.c:375:6: */
	bp := tls.Alloc(152)
	defer tls.Free(152)

	// var c_stream z_stream at bp+64, 88
	// compression stream
	var err int32
	var len uInt = uInt(libc.Xstrlen(tls, uintptr(unsafe.Pointer(&hello)))) + uInt(1)

	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).opaque = uintptr(0)

	err = z.XdeflateInit_(tls, bp+64, -1, ts+353, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp, ts+360, err))
			libc.Xexit(tls, 1)
		}
	}

	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).next_in = uintptr(uintptr(unsafe.Pointer(&hello)))
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).next_out = compr
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).avail_in = uInt(3)
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).avail_out = uInt(*(*uLong)(unsafe.Pointer(comprLen)))
	err = z.Xdeflate(tls, bp+64, 3)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp+16, ts+372, err))
			libc.Xexit(tls, 1)
		}
	}

	*(*Byte)(unsafe.Pointer(compr + 3))++ // force an error in first compressed block
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).avail_in = len - uInt(3)

	err = z.Xdeflate(tls, bp+64, 4)
	if err != 1 {
		{
			if err != 0 {
				libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp+32, ts+372, err))
				libc.Xexit(tls, 1)
			}
		}

	}
	err = z.XdeflateEnd(tls, bp+64)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp+48, ts+380, err))
			libc.Xexit(tls, 1)
		}
	}

	*(*uLong)(unsafe.Pointer(comprLen)) = (*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).total_out
}

// ===========================================================================
// Test inflateSync()
func test_sync(tls *libc.TLS, compr uintptr, comprLen uLong, uncompr uintptr, uncomprLen uLong) { /* example.c:413:6: */
	bp := tls.Alloc(160)
	defer tls.Free(160)

	var err int32
	// var d_stream z_stream at bp+72, 88
	// decompression stream

	libc.Xstrcpy(tls, uncompr, ts+43)

	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).opaque = uintptr(0)

	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).next_in = compr
	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).avail_in = uInt(2) // just read the zlib header

	err = z.XinflateInit_(tls, bp+72, ts+353, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp, ts+391, err))
			libc.Xexit(tls, 1)
		}
	}

	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).next_out = uncompr
	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).avail_out = uInt(uncomprLen)

	err = z.Xinflate(tls, bp+72, 0)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp+16, ts+403, err))
			libc.Xexit(tls, 1)
		}
	}

	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).avail_in = uInt(comprLen) - uInt(2) // read all compressed data
	err = z.XinflateSync(tls, bp+72)                                                         /* but skip the damaged part */
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp+32, ts+565, err))
			libc.Xexit(tls, 1)
		}
	}

	err = z.Xinflate(tls, bp+72, 4)
	if err != -3 {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+577, 0)
		// Because of incorrect adler32
		libc.Xexit(tls, 1)
	}
	err = z.XinflateEnd(tls, bp+72)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp+48, ts+411, err))
			libc.Xexit(tls, 1)
		}
	}

	libc.Xprintf(tls, ts+611, libc.VaList(bp+64, uncompr))
}

// ===========================================================================
// Test deflate() with preset dictionary
func test_dict_deflate(tls *libc.TLS, compr uintptr, comprLen uLong) { /* example.c:457:6: */
	bp := tls.Alloc(136)
	defer tls.Free(136)

	// var c_stream z_stream at bp+48, 88
	// compression stream
	var err int32

	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).opaque = uintptr(0)

	err = z.XdeflateInit_(tls, bp+48, 9, ts+353, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp, ts+360, err))
			libc.Xexit(tls, 1)
		}
	}

	err = z.XdeflateSetDictionary(tls, bp+48,
		uintptr(uintptr(unsafe.Pointer(&dictionary))), uint32(int32(unsafe.Sizeof(dictionary))))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp+16, ts+639, err))
			libc.Xexit(tls, 1)
		}
	}

	dictId = (*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).adler
	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).next_out = compr
	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).avail_out = uInt(comprLen)

	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).next_in = uintptr(uintptr(unsafe.Pointer(&hello)))
	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).avail_in = uInt(libc.Xstrlen(tls, uintptr(unsafe.Pointer(&hello)))) + uInt(1)

	err = z.Xdeflate(tls, bp+48, 4)
	if err != 1 {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+470, 0)
		libc.Xexit(tls, 1)
	}
	err = z.XdeflateEnd(tls, bp+48)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp+32, ts+380, err))
			libc.Xexit(tls, 1)
		}
	}

}

// ===========================================================================
// Test inflate() with a preset dictionary
func test_dict_inflate(tls *libc.TLS, compr uintptr, comprLen uLong, uncompr uintptr, uncomprLen uLong) { /* example.c:494:6: */
	bp := tls.Alloc(144)
	defer tls.Free(144)

	var err int32
	// var d_stream z_stream at bp+56, 88
	// decompression stream

	libc.Xstrcpy(tls, uncompr, ts+43)

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).opaque = uintptr(0)

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).next_in = compr
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).avail_in = uInt(comprLen)

	err = z.XinflateInit_(tls, bp+56, ts+353, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp, ts+391, err))
			libc.Xexit(tls, 1)
		}
	}

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).next_out = uncompr
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).avail_out = uInt(uncomprLen)

	for {
		err = z.Xinflate(tls, bp+56, 0)
		if err == 1 {
			break
		}
		if err == 2 {
			if (*z_stream)(unsafe.Pointer(bp+56)).adler != dictId {
				libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+660, 0)
				libc.Xexit(tls, 1)
			}
			err = z.XinflateSetDictionary(tls, bp+56, uintptr(uintptr(unsafe.Pointer(&dictionary))),
				uint32(int32(unsafe.Sizeof(dictionary))))
		}
		{
			if err != 0 {
				libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp+16, ts+682, err))
				libc.Xexit(tls, 1)
			}
		}

	}

	err = z.XinflateEnd(tls, bp+56)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20, libc.VaList(bp+32, ts+411, err))
			libc.Xexit(tls, 1)
		}
	}

	if libc.Xstrcmp(tls, uncompr, uintptr(unsafe.Pointer(&hello))) != 0 {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+700, 0)
		libc.Xexit(tls, 1)
	} else {
		libc.Xprintf(tls, ts+723, libc.VaList(bp+48, uncompr))
	}
}

// ===========================================================================
// Usage:  example [output.gz  [input.gz]]

func main1(tls *libc.TLS, argc int32, argv uintptr) int32 { /* example.c:545:5: */
	bp := tls.Alloc(28)
	defer tls.Free(28)

	var compr uintptr
	var uncompr uintptr
	*(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)) = uint32(uint64(10000) * uint64(unsafe.Sizeof(int32(0)))) // don't overflow on MSDOS
	var uncomprLen uLong = *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */))

	if int32(*(*int8)(unsafe.Pointer(z.XzlibVersion(tls)))) != int32(*(*int8)(unsafe.Pointer(myVersion))) {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+752, 0)
		libc.Xexit(tls, 1)

	} else if libc.Xstrcmp(tls, z.XzlibVersion(tls), ts+353) != 0 {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+779, 0)
	}

	libc.Xprintf(tls, ts+812,
		libc.VaList(bp, ts+353, 0x12b0, z.XzlibCompileFlags(tls)))

	compr = libc.Xcalloc(tls, uint64(uInt(*(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)))), uint64(1))
	uncompr = libc.Xcalloc(tls, uint64(uInt(uncomprLen)), uint64(1))
	// compr and uncompr are cleared to avoid reading uninitialized
	// data and to ensure that uncompr compresses well.
	if compr == uintptr(0) || uncompr == uintptr(0) {
		libc.Xprintf(tls, ts+861, 0)
		libc.Xexit(tls, 1)
	}

	test_compress(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)), uncompr, uncomprLen)

	test_gzio(tls, func() uintptr {
		if argc > 1 {
			return *(*uintptr)(unsafe.Pointer(argv + 1*8))
		}
		return ts + 876
	}(),
		uncompr, uncomprLen)

	test_deflate(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)))
	test_inflate(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)), uncompr, uncomprLen)

	test_large_deflate(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)), uncompr, uncomprLen)
	test_large_inflate(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)), uncompr, uncomprLen)

	test_flush(tls, compr, bp+24)
	test_sync(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)), uncompr, uncomprLen)
	*(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)) = uncomprLen

	test_dict_deflate(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)))
	test_dict_inflate(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)), uncompr, uncomprLen)

	libc.Xfree(tls, compr)
	libc.Xfree(tls, uncompr)

	return 0
}

var myVersion uintptr = ts + 353 /* "1.2.11" */ /* example.c:552:22 */

var ts1 = "hello, hello!\x00hello\x00%s error: %d\n\x00compress\x00garbage\x00uncompress\x00bad uncompress\n\x00uncompress(): %s\n\x00wb\x00gzopen error\n\x00ello\x00gzputs err: %s\n\x00, %s!\x00gzprintf err: %s\n\x00rb\x00gzread err: %s\n\x00bad gzread: %s\n\x00gzread(): %s\n\x00gzseek error, pos=%ld, gztell=%ld\n\x00gzgetc error\n\x00gzungetc error\n\x00gzgets err after gzseek: %s\n\x00bad gzgets after gzseek\n\x00gzgets() after gzseek: %s\n\x001.2.11\x00deflateInit\x00deflate\x00deflateEnd\x00inflateInit\x00inflate\x00inflateEnd\x00bad inflate\n\x00inflate(): %s\n\x00deflate not greedy\n\x00deflate should report Z_STREAM_END\n\x00large inflate\x00bad large inflate: %ld\n\x00large_inflate(): OK\n\x00inflateSync\x00inflate should report DATA_ERROR\n\x00after inflateSync(): hel%s\n\x00deflateSetDictionary\x00unexpected dictionary\x00inflate with dict\x00bad inflate with dict\n\x00inflate with dictionary: %s\n\x00incompatible zlib version\n\x00warning: different zlib version\n\x00zlib version %s = 0x%04x, compile flags = 0x%lx\n\x00out of memory\n\x00foo.gz\x00"
var ts = (*reflect.StringHeader)(unsafe.Pointer(&ts1)).Data
