// Code generated by yy. DO NOT EDIT.

// Copyright 2019 The CC Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package cc

import (
	"fmt"
)

func ExampleAbstractDeclarator_ptr() {
	fmt.Println(exampleAST(193, "void f(int*);"))
	// Output:
	// &cc.AbstractDeclarator{
	// · Case: AbstractDeclaratorPtr,
	// · Pointer: &cc.Pointer{
	// · · Case: PointerTypeQual,
	// · · Token: example.c:1:11: '*' "*",
	// · },
	// }
}

func ExampleAbstractDeclarator_decl() {
	fmt.Println(exampleAST(194, "void f(int());"))
	// Output:
	// &cc.AbstractDeclarator{
	// · Case: AbstractDeclaratorDecl,
	// · DirectAbstractDeclarator: &cc.DirectAbstractDeclarator{
	// · · Case: DirectAbstractDeclaratorFunc,
	// · · Token: example.c:1:11: '(' "(",
	// · · Token2: example.c:1:12: ')' ")",
	// · },
	// }
}

func ExampleAdditiveExpression_mul() {
	fmt.Println(exampleAST(45, "int i = x;"))
	// Output:
	// &cc.AdditiveExpression{
	// · Case: AdditiveExpressionMul,
	// · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · Case: MultiplicativeExpressionCast,
	// · · CastExpression: &cc.CastExpression{
	// · · · Case: CastExpressionUnary,
	// · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · Case: UnaryExpressionPostfix,
	// · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · Case: PostfixExpressionPrimary,
	// · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleAdditiveExpression_add() {
	fmt.Println(exampleAST(46, "int i = x+y;"))
	// Output:
	// &cc.AdditiveExpression{
	// · AdditiveExpression: &cc.AdditiveExpression{
	// · · Case: AdditiveExpressionMul,
	// · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · Case: MultiplicativeExpressionCast,
	// · · · CastExpression: &cc.CastExpression{
	// · · · · Case: CastExpressionUnary,
	// · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · Case: UnaryExpressionPostfix,
	// · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: AdditiveExpressionAdd,
	// · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · Case: MultiplicativeExpressionCast,
	// · · CastExpression: &cc.CastExpression{
	// · · · Case: CastExpressionUnary,
	// · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · Case: UnaryExpressionPostfix,
	// · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · Case: PostfixExpressionPrimary,
	// · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · Token: example.c:1:11: IDENTIFIER "y",
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: example.c:1:10: '+' "+",
	// }
}

func ExampleAdditiveExpression_sub() {
	fmt.Println(exampleAST(47, "int i = x-y;"))
	// Output:
	// &cc.AdditiveExpression{
	// · AdditiveExpression: &cc.AdditiveExpression{
	// · · Case: AdditiveExpressionMul,
	// · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · Case: MultiplicativeExpressionCast,
	// · · · CastExpression: &cc.CastExpression{
	// · · · · Case: CastExpressionUnary,
	// · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · Case: UnaryExpressionPostfix,
	// · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: AdditiveExpressionSub,
	// · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · Case: MultiplicativeExpressionCast,
	// · · CastExpression: &cc.CastExpression{
	// · · · Case: CastExpressionUnary,
	// · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · Case: UnaryExpressionPostfix,
	// · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · Case: PostfixExpressionPrimary,
	// · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · Token: example.c:1:11: IDENTIFIER "y",
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: example.c:1:10: '-' "-",
	// }
}

func ExampleAlignmentSpecifier_alignasType() {
	fmt.Println(exampleAST(167, "_Alignas(double) char c;"))
	// Output:
	// &cc.AlignmentSpecifier{
	// · Case: AlignmentSpecifierAlignasType,
	// · Token: example.c:1:1: ALIGNAS "_Alignas",
	// · Token2: example.c:1:9: '(' "(",
	// · Token3: example.c:1:16: ')' ")",
	// · TypeName: &cc.TypeName{
	// · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · Case: SpecifierQualifierListTypeSpec,
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Case: TypeSpecifierDouble,
	// · · · · Token: example.c:1:10: DOUBLE "double",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleAlignmentSpecifier_alignasExpr() {
	fmt.Println(exampleAST(168, "_Alignas(0ll) char c;"))
	// Output:
	// &cc.AlignmentSpecifier{
	// · Case: AlignmentSpecifierAlignasExpr,
	// · ConstantExpression: &cc.ConstantExpression{
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:10: INTCONST "0ll",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: example.c:1:1: ALIGNAS "_Alignas",
	// · Token2: example.c:1:9: '(' "(",
	// · Token3: example.c:1:13: ')' ")",
	// }
}

func ExampleAndExpression_eq() {
	fmt.Println(exampleAST(59, "int i = x;"))
	// Output:
	// &cc.AndExpression{
	// · Case: AndExpressionEq,
	// · EqualityExpression: &cc.EqualityExpression{
	// · · Case: EqualityExpressionRel,
	// · · RelationalExpression: &cc.RelationalExpression{
	// · · · Case: RelationalExpressionShift,
	// · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · Case: AdditiveExpressionMul,
	// · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · · Case: ShiftExpressionAdd,
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleAndExpression_and() {
	fmt.Println(exampleAST(60, "int i = x & y;"))
	// Output:
	// &cc.AndExpression{
	// · AndExpression: &cc.AndExpression{
	// · · Case: AndExpressionEq,
	// · · EqualityExpression: &cc.EqualityExpression{
	// · · · Case: EqualityExpressionRel,
	// · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · Case: RelationalExpressionShift,
	// · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · · Case: ShiftExpressionAdd,
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: AndExpressionAnd,
	// · EqualityExpression: &cc.EqualityExpression{
	// · · Case: EqualityExpressionRel,
	// · · RelationalExpression: &cc.RelationalExpression{
	// · · · Case: RelationalExpressionShift,
	// · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · Case: AdditiveExpressionMul,
	// · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · Token: example.c:1:13: IDENTIFIER "y",
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · · Case: ShiftExpressionAdd,
	// · · · },
	// · · },
	// · },
	// · Token: example.c:1:11: '&' "&",
	// }
}

func ExampleArgumentExpressionList_case0() {
	fmt.Println(exampleAST(21, "int i = f(x);"))
	// Output:
	// &cc.ArgumentExpressionList{
	// · AssignmentExpression: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:11: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleArgumentExpressionList_case1() {
	fmt.Println(exampleAST(22, "int i = f(x, y);"))
	// Output:
	// &cc.ArgumentExpressionList{
	// · ArgumentExpressionList: &cc.ArgumentExpressionList{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:14: IDENTIFIER "y",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Token: example.c:1:12: ',' ",",
	// · },
	// · AssignmentExpression: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:11: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleAsm_case0() {
	fmt.Println(exampleAST(259, "__asm__(\"nop\");"))
	// Output:
	// &cc.Asm{
	// · Token: example.c:1:1: ASM "__asm__",
	// · Token2: example.c:1:8: '(' "(",
	// · Token3: example.c:1:9: STRINGLITERAL "nop",
	// · Token4: example.c:1:14: ')' ")",
	// }
}

func ExampleAsmArgList_case0() {
	fmt.Println(exampleAST(257, "__asm__(\"nop\": a);"))
	// Output:
	// &cc.AsmArgList{
	// · AsmExpressionList: &cc.AsmExpressionList{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:16: IDENTIFIER "a",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: example.c:1:14: ':' ":",
	// }
}

func ExampleAsmArgList_case1() {
	fmt.Println(exampleAST(258, "__asm__(\"nop\": a : b);"))
	// Output:
	// &cc.AsmArgList{
	// · AsmArgList: &cc.AsmArgList{
	// · · AsmExpressionList: &cc.AsmExpressionList{
	// · · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · · Case: AssignmentExpressionCond,
	// · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · Case: ConditionalExpressionLOr,
	// · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · Token: example.c:1:20: IDENTIFIER "b",
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Token: example.c:1:18: ':' ":",
	// · },
	// · AsmExpressionList: &cc.AsmExpressionList{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:16: IDENTIFIER "a",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: example.c:1:14: ':' ":",
	// }
}

func ExampleAsmExpressionList_case0() {
	fmt.Println(exampleAST(255, "__asm__(\"nop\": a);"))
	// Output:
	// &cc.AsmExpressionList{
	// · AssignmentExpression: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:16: IDENTIFIER "a",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleAsmExpressionList_case1() {
	fmt.Println(exampleAST(256, "__asm__(\"nop\": a, b);"))
	// Output:
	// &cc.AsmExpressionList{
	// · AsmExpressionList: &cc.AsmExpressionList{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:19: IDENTIFIER "b",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Token: example.c:1:17: ',' ",",
	// · },
	// · AssignmentExpression: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:16: IDENTIFIER "a",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleAsmFunctionDefinition_case0() {
	fmt.Println(exampleAST(261, "int f() __asm__(\"nop\");"))
	// Output:
	// &cc.AsmFunctionDefinition{
	// · AsmStatement: &cc.AsmStatement{
	// · · Asm: &cc.Asm{
	// · · · Token: example.c:1:9: ASM "__asm__",
	// · · · Token2: example.c:1:16: '(' "(",
	// · · · Token3: example.c:1:17: STRINGLITERAL "nop",
	// · · · Token4: example.c:1:22: ')' ")",
	// · · },
	// · · Token: example.c:1:23: ';' ";",
	// · },
	// · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · Case: DeclarationSpecifiersTypeSpec,
	// · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · Case: TypeSpecifierInt,
	// · · · Token: example.c:1:1: INT "int",
	// · · },
	// · },
	// · Declarator: &cc.Declarator{
	// · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · Case: DirectDeclaratorFuncIdent,
	// · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · Case: DirectDeclaratorIdent,
	// · · · · Token: example.c:1:5: IDENTIFIER "f",
	// · · · },
	// · · · Token: example.c:1:6: '(' "(",
	// · · · Token2: example.c:1:7: ')' ")",
	// · · },
	// · },
	// }
}

func ExampleAsmIndex_case0() {
	fmt.Println(exampleAST(254, "__asm__(\"nop\": [a] b);"))
	// Output:
	// &cc.AsmIndex{
	// · Expression: &cc.Expression{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:17: IDENTIFIER "a",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ExpressionAssign,
	// · },
	// · Token: example.c:1:16: '[' "[",
	// · Token2: example.c:1:18: ']' "]",
	// }
}

func ExampleAsmQualifier_volatile() {
	fmt.Println(exampleAST(262, "__asm__ volatile (\"nop\");"))
	// Output:
	// &cc.AsmQualifier{
	// · Case: AsmQualifierVolatile,
	// · Token: example.c:1:9: VOLATILE "volatile",
	// }
}

func ExampleAsmQualifier_inline() {
	fmt.Println(exampleAST(263, "__asm__ inline (\"nop\");"))
	// Output:
	// &cc.AsmQualifier{
	// · Case: AsmQualifierInline,
	// · Token: example.c:1:9: INLINE "inline",
	// }
}

func ExampleAsmQualifier_goto() {
	fmt.Println(exampleAST(264, "__asm__ goto (\"nop\");"))
	// Output:
	// &cc.AsmQualifier{
	// · Case: AsmQualifierGoto,
	// · Token: example.c:1:9: GOTO "goto",
	// }
}

func ExampleAsmQualifierList_case0() {
	fmt.Println(exampleAST(265, "__asm__ inline (\"nop\");"))
	// Output:
	// &cc.AsmQualifierList{
	// · AsmQualifier: &cc.AsmQualifier{
	// · · Case: AsmQualifierInline,
	// · · Token: example.c:1:9: INLINE "inline",
	// · },
	// }
}

func ExampleAsmQualifierList_case1() {
	fmt.Println(exampleAST(266, "__asm__ inline volatile (\"nop\");"))
	// Output:
	// &cc.AsmQualifierList{
	// · AsmQualifier: &cc.AsmQualifier{
	// · · Case: AsmQualifierInline,
	// · · Token: example.c:1:9: INLINE "inline",
	// · },
	// · AsmQualifierList: &cc.AsmQualifierList{
	// · · AsmQualifier: &cc.AsmQualifier{
	// · · · Case: AsmQualifierVolatile,
	// · · · Token: example.c:1:16: VOLATILE "volatile",
	// · · },
	// · },
	// }
}

func ExampleAsmStatement_case0() {
	fmt.Println(exampleAST(260, "void f() { __asm__(\"nop\"); }"))
	// Output:
	// &cc.AsmStatement{
	// · Asm: &cc.Asm{
	// · · Token: example.c:1:12: ASM "__asm__",
	// · · Token2: example.c:1:19: '(' "(",
	// · · Token3: example.c:1:20: STRINGLITERAL "nop",
	// · · Token4: example.c:1:25: ')' ")",
	// · },
	// · Token: example.c:1:26: ';' ";",
	// }
}

func ExampleAssignmentExpression_cond() {
	fmt.Println(exampleAST(71, "int i = x; }"))
	// Output:
	// &cc.AssignmentExpression{
	// · Case: AssignmentExpressionCond,
	// · ConditionalExpression: &cc.ConditionalExpression{
	// · · Case: ConditionalExpressionLOr,
	// · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · Case: LogicalOrExpressionLAnd,
	// · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · Case: LogicalAndExpressionOr,
	// · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · Case: AndExpressionEq,
	// · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleAssignmentExpression_assign() {
	fmt.Println(exampleAST(72, "int f() { x = y; }"))
	// Output:
	// &cc.AssignmentExpression{
	// · AssignmentExpression: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:15: IDENTIFIER "y",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: AssignmentExpressionAssign,
	// · Token: example.c:1:13: '=' "=",
	// · UnaryExpression: &cc.UnaryExpression{
	// · · Case: UnaryExpressionPostfix,
	// · · PostfixExpression: &cc.PostfixExpression{
	// · · · Case: PostfixExpressionPrimary,
	// · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · Case: PrimaryExpressionIdent,
	// · · · · Token: example.c:1:11: IDENTIFIER "x",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleAssignmentExpression_mul() {
	fmt.Println(exampleAST(73, "int f() { x *= y; }"))
	// Output:
	// &cc.AssignmentExpression{
	// · AssignmentExpression: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:16: IDENTIFIER "y",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: AssignmentExpressionMul,
	// · Token: example.c:1:13: MULASSIGN "*=",
	// · UnaryExpression: &cc.UnaryExpression{
	// · · Case: UnaryExpressionPostfix,
	// · · PostfixExpression: &cc.PostfixExpression{
	// · · · Case: PostfixExpressionPrimary,
	// · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · Case: PrimaryExpressionIdent,
	// · · · · Token: example.c:1:11: IDENTIFIER "x",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleAssignmentExpression_div() {
	fmt.Println(exampleAST(74, "int f() { x /= y; }"))
	// Output:
	// &cc.AssignmentExpression{
	// · AssignmentExpression: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:16: IDENTIFIER "y",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: AssignmentExpressionDiv,
	// · Token: example.c:1:13: DIVASSIGN "/=",
	// · UnaryExpression: &cc.UnaryExpression{
	// · · Case: UnaryExpressionPostfix,
	// · · PostfixExpression: &cc.PostfixExpression{
	// · · · Case: PostfixExpressionPrimary,
	// · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · Case: PrimaryExpressionIdent,
	// · · · · Token: example.c:1:11: IDENTIFIER "x",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleAssignmentExpression_mod() {
	fmt.Println(exampleAST(75, "int f() { x %= y; }"))
	// Output:
	// &cc.AssignmentExpression{
	// · AssignmentExpression: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:16: IDENTIFIER "y",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: AssignmentExpressionMod,
	// · Token: example.c:1:13: MODASSIGN "%=",
	// · UnaryExpression: &cc.UnaryExpression{
	// · · Case: UnaryExpressionPostfix,
	// · · PostfixExpression: &cc.PostfixExpression{
	// · · · Case: PostfixExpressionPrimary,
	// · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · Case: PrimaryExpressionIdent,
	// · · · · Token: example.c:1:11: IDENTIFIER "x",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleAssignmentExpression_add() {
	fmt.Println(exampleAST(76, "int f() { x += y; }"))
	// Output:
	// &cc.AssignmentExpression{
	// · AssignmentExpression: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:16: IDENTIFIER "y",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: AssignmentExpressionAdd,
	// · Token: example.c:1:13: ADDASSIGN "+=",
	// · UnaryExpression: &cc.UnaryExpression{
	// · · Case: UnaryExpressionPostfix,
	// · · PostfixExpression: &cc.PostfixExpression{
	// · · · Case: PostfixExpressionPrimary,
	// · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · Case: PrimaryExpressionIdent,
	// · · · · Token: example.c:1:11: IDENTIFIER "x",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleAssignmentExpression_sub() {
	fmt.Println(exampleAST(77, "int f() { x -= y; }"))
	// Output:
	// &cc.AssignmentExpression{
	// · AssignmentExpression: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:16: IDENTIFIER "y",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: AssignmentExpressionSub,
	// · Token: example.c:1:13: SUBASSIGN "-=",
	// · UnaryExpression: &cc.UnaryExpression{
	// · · Case: UnaryExpressionPostfix,
	// · · PostfixExpression: &cc.PostfixExpression{
	// · · · Case: PostfixExpressionPrimary,
	// · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · Case: PrimaryExpressionIdent,
	// · · · · Token: example.c:1:11: IDENTIFIER "x",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleAssignmentExpression_lsh() {
	fmt.Println(exampleAST(78, "int f() { x <<= y; }"))
	// Output:
	// &cc.AssignmentExpression{
	// · AssignmentExpression: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:17: IDENTIFIER "y",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: AssignmentExpressionLsh,
	// · Token: example.c:1:13: LSHASSIGN "<<=",
	// · UnaryExpression: &cc.UnaryExpression{
	// · · Case: UnaryExpressionPostfix,
	// · · PostfixExpression: &cc.PostfixExpression{
	// · · · Case: PostfixExpressionPrimary,
	// · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · Case: PrimaryExpressionIdent,
	// · · · · Token: example.c:1:11: IDENTIFIER "x",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleAssignmentExpression_rsh() {
	fmt.Println(exampleAST(79, "int f() { x >>= y; }"))
	// Output:
	// &cc.AssignmentExpression{
	// · AssignmentExpression: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:17: IDENTIFIER "y",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: AssignmentExpressionRsh,
	// · Token: example.c:1:13: RSHASSIGN ">>=",
	// · UnaryExpression: &cc.UnaryExpression{
	// · · Case: UnaryExpressionPostfix,
	// · · PostfixExpression: &cc.PostfixExpression{
	// · · · Case: PostfixExpressionPrimary,
	// · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · Case: PrimaryExpressionIdent,
	// · · · · Token: example.c:1:11: IDENTIFIER "x",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleAssignmentExpression_and() {
	fmt.Println(exampleAST(80, "int f() { x &= y; }"))
	// Output:
	// &cc.AssignmentExpression{
	// · AssignmentExpression: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:16: IDENTIFIER "y",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: AssignmentExpressionAnd,
	// · Token: example.c:1:13: ANDASSIGN "&=",
	// · UnaryExpression: &cc.UnaryExpression{
	// · · Case: UnaryExpressionPostfix,
	// · · PostfixExpression: &cc.PostfixExpression{
	// · · · Case: PostfixExpressionPrimary,
	// · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · Case: PrimaryExpressionIdent,
	// · · · · Token: example.c:1:11: IDENTIFIER "x",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleAssignmentExpression_xor() {
	fmt.Println(exampleAST(81, "int f() { x ^= y; }"))
	// Output:
	// &cc.AssignmentExpression{
	// · AssignmentExpression: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:16: IDENTIFIER "y",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: AssignmentExpressionXor,
	// · Token: example.c:1:13: XORASSIGN "^=",
	// · UnaryExpression: &cc.UnaryExpression{
	// · · Case: UnaryExpressionPostfix,
	// · · PostfixExpression: &cc.PostfixExpression{
	// · · · Case: PostfixExpressionPrimary,
	// · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · Case: PrimaryExpressionIdent,
	// · · · · Token: example.c:1:11: IDENTIFIER "x",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleAssignmentExpression_or() {
	fmt.Println(exampleAST(82, "int f() { x |= y; }"))
	// Output:
	// &cc.AssignmentExpression{
	// · AssignmentExpression: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:16: IDENTIFIER "y",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: AssignmentExpressionOr,
	// · Token: example.c:1:13: ORASSIGN "|=",
	// · UnaryExpression: &cc.UnaryExpression{
	// · · Case: UnaryExpressionPostfix,
	// · · PostfixExpression: &cc.PostfixExpression{
	// · · · Case: PostfixExpressionPrimary,
	// · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · Case: PrimaryExpressionIdent,
	// · · · · Token: example.c:1:11: IDENTIFIER "x",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleAtomicTypeSpecifier_case0() {
	fmt.Println(exampleAST(159, "_Atomic(int) i;"))
	// Output:
	// &cc.AtomicTypeSpecifier{
	// · Token: example.c:1:1: ATOMIC "_Atomic",
	// · Token2: example.c:1:8: '(' "(",
	// · Token3: example.c:1:12: ')' ")",
	// · TypeName: &cc.TypeName{
	// · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · Case: SpecifierQualifierListTypeSpec,
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Case: TypeSpecifierInt,
	// · · · · Token: example.c:1:9: INT "int",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleAttributeSpecifier_case0() {
	fmt.Println(exampleAST(274, "int i __attribute__((a));"))
	// Output:
	// &cc.AttributeSpecifier{
	// · AttributeValueList: &cc.AttributeValueList{
	// · · AttributeValue: &cc.AttributeValue{
	// · · · Case: AttributeValueIdent,
	// · · · Token: example.c:1:22: IDENTIFIER "a",
	// · · },
	// · },
	// · Token: example.c:1:7: ATTRIBUTE "__attribute__",
	// · Token2: example.c:1:20: '(' "(",
	// · Token3: example.c:1:21: '(' "(",
	// · Token4: example.c:1:23: ')' ")",
	// · Token5: example.c:1:24: ')' ")",
	// }
}

func ExampleAttributeSpecifierList_case0() {
	fmt.Println(exampleAST(275, "int i __attribute__((a));"))
	// Output:
	// &cc.AttributeSpecifierList{
	// · AttributeSpecifier: &cc.AttributeSpecifier{
	// · · AttributeValueList: &cc.AttributeValueList{
	// · · · AttributeValue: &cc.AttributeValue{
	// · · · · Case: AttributeValueIdent,
	// · · · · Token: example.c:1:22: IDENTIFIER "a",
	// · · · },
	// · · },
	// · · Token: example.c:1:7: ATTRIBUTE "__attribute__",
	// · · Token2: example.c:1:20: '(' "(",
	// · · Token3: example.c:1:21: '(' "(",
	// · · Token4: example.c:1:23: ')' ")",
	// · · Token5: example.c:1:24: ')' ")",
	// · },
	// }
}

func ExampleAttributeSpecifierList_case1() {
	fmt.Println(exampleAST(276, "int i __attribute__((a)) __attribute((b));"))
	// Output:
	// &cc.AttributeSpecifierList{
	// · AttributeSpecifier: &cc.AttributeSpecifier{
	// · · AttributeValueList: &cc.AttributeValueList{
	// · · · AttributeValue: &cc.AttributeValue{
	// · · · · Case: AttributeValueIdent,
	// · · · · Token: example.c:1:22: IDENTIFIER "a",
	// · · · },
	// · · },
	// · · Token: example.c:1:7: ATTRIBUTE "__attribute__",
	// · · Token2: example.c:1:20: '(' "(",
	// · · Token3: example.c:1:21: '(' "(",
	// · · Token4: example.c:1:23: ')' ")",
	// · · Token5: example.c:1:24: ')' ")",
	// · },
	// · AttributeSpecifierList: &cc.AttributeSpecifierList{
	// · · AttributeSpecifier: &cc.AttributeSpecifier{
	// · · · AttributeValueList: &cc.AttributeValueList{
	// · · · · AttributeValue: &cc.AttributeValue{
	// · · · · · Case: AttributeValueIdent,
	// · · · · · Token: example.c:1:39: IDENTIFIER "b",
	// · · · · },
	// · · · },
	// · · · Token: example.c:1:26: ATTRIBUTE "__attribute",
	// · · · Token2: example.c:1:37: '(' "(",
	// · · · Token3: example.c:1:38: '(' "(",
	// · · · Token4: example.c:1:40: ')' ")",
	// · · · Token5: example.c:1:41: ')' ")",
	// · · },
	// · },
	// }
}

func ExampleAttributeValue_ident() {
	fmt.Println(exampleAST(270, "int i __attribute__((a));"))
	// Output:
	// &cc.AttributeValue{
	// · Case: AttributeValueIdent,
	// · Token: example.c:1:22: IDENTIFIER "a",
	// }
}

func ExampleAttributeValue_expr() {
	fmt.Println(exampleAST(271, "int i __attribute__((a(b)));"))
	// Output:
	// &cc.AttributeValue{
	// · Case: AttributeValueExpr,
	// · ExpressionList: &cc.ExpressionList{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:24: IDENTIFIER "b",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: example.c:1:22: IDENTIFIER "a",
	// · Token2: example.c:1:23: '(' "(",
	// · Token3: example.c:1:25: ')' ")",
	// }
}

func ExampleAttributeValueList_case0() {
	fmt.Println(exampleAST(272, "int i __attribute__((a));"))
	// Output:
	// &cc.AttributeValueList{
	// · AttributeValue: &cc.AttributeValue{
	// · · Case: AttributeValueIdent,
	// · · Token: example.c:1:22: IDENTIFIER "a",
	// · },
	// }
}

func ExampleAttributeValueList_case1() {
	fmt.Println(exampleAST(273, "int i __attribute__((a, b));"))
	// Output:
	// &cc.AttributeValueList{
	// · AttributeValue: &cc.AttributeValue{
	// · · Case: AttributeValueIdent,
	// · · Token: example.c:1:22: IDENTIFIER "a",
	// · },
	// · AttributeValueList: &cc.AttributeValueList{
	// · · AttributeValue: &cc.AttributeValue{
	// · · · Case: AttributeValueIdent,
	// · · · Token: example.c:1:25: IDENTIFIER "b",
	// · · },
	// · · Token: example.c:1:23: ',' ",",
	// · },
	// }
}

func ExampleBlockItem_decl() {
	fmt.Println(exampleAST(225, "int f() { int i; }"))
	// Output:
	// &cc.BlockItem{
	// · Case: BlockItemDecl,
	// · Declaration: &cc.Declaration{
	// · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · Case: DeclarationSpecifiersTypeSpec,
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Case: TypeSpecifierInt,
	// · · · · Token: example.c:1:11: INT "int",
	// · · · },
	// · · },
	// · · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · · InitDeclarator: &cc.InitDeclarator{
	// · · · · Case: InitDeclaratorDecl,
	// · · · · Declarator: &cc.Declarator{
	// · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · Token: example.c:1:15: IDENTIFIER "i",
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Token: example.c:1:16: ';' ";",
	// · },
	// }
}

func ExampleBlockItem_stmt() {
	fmt.Println(exampleAST(226, "int f() { g(); }"))
	// Output:
	// &cc.BlockItem{
	// · Case: BlockItemStmt,
	// · Statement: &cc.Statement{
	// · · Case: StatementExpr,
	// · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · Expression: &cc.Expression{
	// · · · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · · · Case: AssignmentExpressionCond,
	// · · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · · Case: ConditionalExpressionLOr,
	// · · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionCall,
	// · · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · · · Token: example.c:1:11: IDENTIFIER "g",
	// · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · Token: example.c:1:12: '(' "(",
	// · · · · · · · · · · · · · · · · · · · Token2: example.c:1:13: ')' ")",
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · · Case: ExpressionAssign,
	// · · · },
	// · · · Token: example.c:1:14: ';' ";",
	// · · },
	// · },
	// }
}

func ExampleBlockItem_label() {
	fmt.Println(exampleAST(227, "int f() { __label__ L; }"))
	// Output:
	// &cc.BlockItem{
	// · Case: BlockItemLabel,
	// · LabelDeclaration: &cc.LabelDeclaration{
	// · · IdentifierList: &cc.IdentifierList{
	// · · · Token: example.c:1:21: IDENTIFIER "L",
	// · · },
	// · · Token: example.c:1:11: LABEL "__label__",
	// · · Token2: example.c:1:22: ';' ";",
	// · },
	// }
}

func ExampleBlockItem_funcDef() {
	fmt.Println(exampleAST(228, "int f() { int g() {} }"))
	// Output:
	// &cc.BlockItem{
	// · Case: BlockItemFuncDef,
	// · CompoundStatement: &cc.CompoundStatement{
	// · · Token: example.c:1:19: '{' "{",
	// · · Token2: example.c:1:20: '}' "}",
	// · },
	// · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · Case: DeclarationSpecifiersTypeSpec,
	// · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · Case: TypeSpecifierInt,
	// · · · Token: example.c:1:11: INT "int",
	// · · },
	// · },
	// · Declarator: &cc.Declarator{
	// · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · Case: DirectDeclaratorFuncIdent,
	// · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · Case: DirectDeclaratorIdent,
	// · · · · Token: example.c:1:15: IDENTIFIER "g",
	// · · · },
	// · · · Token: example.c:1:16: '(' "(",
	// · · · Token2: example.c:1:17: ')' ")",
	// · · },
	// · },
	// }
}

func ExampleBlockItem_pragma() {
	fmt.Println(exampleAST(229, "int f() {\\n#pragma STDC FENV_ACCESS OFF\\n}"))
	// Output:
	// &cc.BlockItem{
	// · Case: BlockItemPragma,
	// · PragmaSTDC: &cc.PragmaSTDC{
	// · · Token: example.c:2:9: PPPRAGMASTDC "__pragma_stdc",
	// · · Token2: example.c:2:9: IDENTIFIER "STDC",
	// · · Token3: example.c:2:14: IDENTIFIER "FENV_ACCESS",
	// · · Token4: example.c:2:26: IDENTIFIER "OFF",
	// · },
	// }
}

func ExampleBlockItemList_case0() {
	fmt.Println(exampleAST(223, "int f() { int i; }"))
	// Output:
	// &cc.BlockItemList{
	// · BlockItem: &cc.BlockItem{
	// · · Case: BlockItemDecl,
	// · · Declaration: &cc.Declaration{
	// · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · Case: DeclarationSpecifiersTypeSpec,
	// · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · Case: TypeSpecifierInt,
	// · · · · · Token: example.c:1:11: INT "int",
	// · · · · },
	// · · · },
	// · · · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · · · InitDeclarator: &cc.InitDeclarator{
	// · · · · · Case: InitDeclaratorDecl,
	// · · · · · Declarator: &cc.Declarator{
	// · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · · Token: example.c:1:15: IDENTIFIER "i",
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Token: example.c:1:16: ';' ";",
	// · · },
	// · },
	// }
}

func ExampleBlockItemList_case1() {
	fmt.Println(exampleAST(224, "int f() { int i; double j; }"))
	// Output:
	// &cc.BlockItemList{
	// · BlockItem: &cc.BlockItem{
	// · · Case: BlockItemDecl,
	// · · Declaration: &cc.Declaration{
	// · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · Case: DeclarationSpecifiersTypeSpec,
	// · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · Case: TypeSpecifierInt,
	// · · · · · Token: example.c:1:11: INT "int",
	// · · · · },
	// · · · },
	// · · · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · · · InitDeclarator: &cc.InitDeclarator{
	// · · · · · Case: InitDeclaratorDecl,
	// · · · · · Declarator: &cc.Declarator{
	// · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · · Token: example.c:1:15: IDENTIFIER "i",
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Token: example.c:1:16: ';' ";",
	// · · },
	// · },
	// · BlockItemList: &cc.BlockItemList{
	// · · BlockItem: &cc.BlockItem{
	// · · · Case: BlockItemDecl,
	// · · · Declaration: &cc.Declaration{
	// · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · Case: DeclarationSpecifiersTypeSpec,
	// · · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · · Case: TypeSpecifierDouble,
	// · · · · · · Token: example.c:1:18: DOUBLE "double",
	// · · · · · },
	// · · · · },
	// · · · · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · · · · InitDeclarator: &cc.InitDeclarator{
	// · · · · · · Case: InitDeclaratorDecl,
	// · · · · · · Declarator: &cc.Declarator{
	// · · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · · · Token: example.c:1:25: IDENTIFIER "j",
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · · Token: example.c:1:26: ';' ";",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleCastExpression_unary() {
	fmt.Println(exampleAST(39, "int i = 42;"))
	// Output:
	// &cc.CastExpression{
	// · Case: CastExpressionUnary,
	// · UnaryExpression: &cc.UnaryExpression{
	// · · Case: UnaryExpressionPostfix,
	// · · PostfixExpression: &cc.PostfixExpression{
	// · · · Case: PostfixExpressionPrimary,
	// · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · Case: PrimaryExpressionInt,
	// · · · · Token: example.c:1:9: INTCONST "42",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleCastExpression_cast() {
	fmt.Println(exampleAST(40, "int i = (int)3.14;"))
	// Output:
	// &cc.CastExpression{
	// · Case: CastExpressionCast,
	// · CastExpression: &cc.CastExpression{
	// · · Case: CastExpressionUnary,
	// · · UnaryExpression: &cc.UnaryExpression{
	// · · · Case: UnaryExpressionPostfix,
	// · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · Case: PostfixExpressionPrimary,
	// · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · Case: PrimaryExpressionFloat,
	// · · · · · Token: example.c:1:14: FLOATCONST "3.14",
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: example.c:1:9: '(' "(",
	// · Token2: example.c:1:13: ')' ")",
	// · TypeName: &cc.TypeName{
	// · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · Case: SpecifierQualifierListTypeSpec,
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Case: TypeSpecifierInt,
	// · · · · Token: example.c:1:10: INT "int",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleCompoundStatement_case0() {
	fmt.Println(exampleAST(222, "int f() { int i; }"))
	// Output:
	// &cc.CompoundStatement{
	// · BlockItemList: &cc.BlockItemList{
	// · · BlockItem: &cc.BlockItem{
	// · · · Case: BlockItemDecl,
	// · · · Declaration: &cc.Declaration{
	// · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · Case: DeclarationSpecifiersTypeSpec,
	// · · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · · Case: TypeSpecifierInt,
	// · · · · · · Token: example.c:1:11: INT "int",
	// · · · · · },
	// · · · · },
	// · · · · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · · · · InitDeclarator: &cc.InitDeclarator{
	// · · · · · · Case: InitDeclaratorDecl,
	// · · · · · · Declarator: &cc.Declarator{
	// · · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · · · Token: example.c:1:15: IDENTIFIER "i",
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · · Token: example.c:1:16: ';' ";",
	// · · · },
	// · · },
	// · },
	// · Token: example.c:1:9: '{' "{",
	// · Token2: example.c:1:18: '}' "}",
	// }
}

func ExampleConditionalExpression_lOr() {
	fmt.Println(exampleAST(69, "int i = x;"))
	// Output:
	// &cc.ConditionalExpression{
	// · Case: ConditionalExpressionLOr,
	// · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · Case: LogicalOrExpressionLAnd,
	// · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · Case: LogicalAndExpressionOr,
	// · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · Case: InclusiveOrExpressionXor,
	// · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · Case: AndExpressionEq,
	// · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · },
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleConditionalExpression_cond() {
	fmt.Println(exampleAST(70, "int i = x ? y : z;"))
	// Output:
	// &cc.ConditionalExpression{
	// · Case: ConditionalExpressionCond,
	// · ConditionalExpression: &cc.ConditionalExpression{
	// · · Case: ConditionalExpressionLOr,
	// · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · Case: LogicalOrExpressionLAnd,
	// · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · Case: LogicalAndExpressionOr,
	// · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · Case: AndExpressionEq,
	// · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · Token: example.c:1:17: IDENTIFIER "z",
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Expression: &cc.Expression{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:13: IDENTIFIER "y",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ExpressionAssign,
	// · },
	// · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · Case: LogicalOrExpressionLAnd,
	// · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · Case: LogicalAndExpressionOr,
	// · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · Case: InclusiveOrExpressionXor,
	// · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · Case: AndExpressionEq,
	// · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: example.c:1:11: '?' "?",
	// · Token2: example.c:1:15: ':' ":",
	// }
}

func ExampleConstantExpression_case0() {
	fmt.Println(exampleAST(85, "struct { int i:3; };"))
	// Output:
	// &cc.ConstantExpression{
	// · ConditionalExpression: &cc.ConditionalExpression{
	// · · Case: ConditionalExpressionLOr,
	// · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · Case: LogicalOrExpressionLAnd,
	// · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · Case: LogicalAndExpressionOr,
	// · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · Case: AndExpressionEq,
	// · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · Token: example.c:1:16: INTCONST "3",
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleDeclaration_case0() {
	fmt.Println(exampleAST(86, "int i, j;"))
	// Output:
	// &cc.Declaration{
	// · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · Case: DeclarationSpecifiersTypeSpec,
	// · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · Case: TypeSpecifierInt,
	// · · · Token: example.c:1:1: INT "int",
	// · · },
	// · },
	// · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · InitDeclarator: &cc.InitDeclarator{
	// · · · Case: InitDeclaratorDecl,
	// · · · Declarator: &cc.Declarator{
	// · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · Case: DirectDeclaratorIdent,
	// · · · · · Token: example.c:1:5: IDENTIFIER "i",
	// · · · · },
	// · · · },
	// · · },
	// · · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · · InitDeclarator: &cc.InitDeclarator{
	// · · · · Case: InitDeclaratorDecl,
	// · · · · Declarator: &cc.Declarator{
	// · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · Token: example.c:1:8: IDENTIFIER "j",
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Token: example.c:1:6: ',' ",",
	// · · },
	// · },
	// · Token: example.c:1:9: ';' ";",
	// }
}

func ExampleDeclarationList_case0() {
	fmt.Println(exampleAST(252, "int f(i) int i; {}"))
	// Output:
	// &cc.DeclarationList{
	// · Declaration: &cc.Declaration{
	// · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · Case: DeclarationSpecifiersTypeSpec,
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Case: TypeSpecifierInt,
	// · · · · Token: example.c:1:10: INT "int",
	// · · · },
	// · · },
	// · · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · · InitDeclarator: &cc.InitDeclarator{
	// · · · · Case: InitDeclaratorDecl,
	// · · · · Declarator: &cc.Declarator{
	// · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · Token: example.c:1:14: IDENTIFIER "i",
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Token: example.c:1:15: ';' ";",
	// · },
	// }
}

func ExampleDeclarationList_case1() {
	fmt.Println(exampleAST(253, "int f(i, j) int i; int j; {}"))
	// Output:
	// &cc.DeclarationList{
	// · Declaration: &cc.Declaration{
	// · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · Case: DeclarationSpecifiersTypeSpec,
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Case: TypeSpecifierInt,
	// · · · · Token: example.c:1:13: INT "int",
	// · · · },
	// · · },
	// · · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · · InitDeclarator: &cc.InitDeclarator{
	// · · · · Case: InitDeclaratorDecl,
	// · · · · Declarator: &cc.Declarator{
	// · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · Token: example.c:1:17: IDENTIFIER "i",
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Token: example.c:1:18: ';' ";",
	// · },
	// · DeclarationList: &cc.DeclarationList{
	// · · Declaration: &cc.Declaration{
	// · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · Case: DeclarationSpecifiersTypeSpec,
	// · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · Case: TypeSpecifierInt,
	// · · · · · Token: example.c:1:20: INT "int",
	// · · · · },
	// · · · },
	// · · · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · · · InitDeclarator: &cc.InitDeclarator{
	// · · · · · Case: InitDeclaratorDecl,
	// · · · · · Declarator: &cc.Declarator{
	// · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · · Token: example.c:1:24: IDENTIFIER "j",
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Token: example.c:1:25: ';' ";",
	// · · },
	// · },
	// }
}

func ExampleDeclarationSpecifiers_storage() {
	fmt.Println(exampleAST(87, "static int i;"))
	// Output:
	// &cc.DeclarationSpecifiers{
	// · Case: DeclarationSpecifiersStorage,
	// · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · Case: DeclarationSpecifiersTypeSpec,
	// · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · Case: TypeSpecifierInt,
	// · · · Token: example.c:1:8: INT "int",
	// · · },
	// · },
	// · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · Case: StorageClassSpecifierStatic,
	// · · Token: example.c:1:1: STATIC "static",
	// · },
	// }
}

func ExampleDeclarationSpecifiers_typeSpec() {
	fmt.Println(exampleAST(88, "int i;"))
	// Output:
	// &cc.DeclarationSpecifiers{
	// · Case: DeclarationSpecifiersTypeSpec,
	// · TypeSpecifier: &cc.TypeSpecifier{
	// · · Case: TypeSpecifierInt,
	// · · Token: example.c:1:1: INT "int",
	// · },
	// }
}

func ExampleDeclarationSpecifiers_typeQual() {
	fmt.Println(exampleAST(89, "volatile int i;"))
	// Output:
	// &cc.DeclarationSpecifiers{
	// · Case: DeclarationSpecifiersTypeQual,
	// · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · Case: DeclarationSpecifiersTypeSpec,
	// · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · Case: TypeSpecifierInt,
	// · · · Token: example.c:1:10: INT "int",
	// · · },
	// · },
	// · TypeQualifier: &cc.TypeQualifier{
	// · · Case: TypeQualifierVolatile,
	// · · Token: example.c:1:1: VOLATILE "volatile",
	// · },
	// }
}

func ExampleDeclarationSpecifiers_func() {
	fmt.Println(exampleAST(90, "inline int f() {}"))
	// Output:
	// &cc.DeclarationSpecifiers{
	// · Case: DeclarationSpecifiersFunc,
	// · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · Case: DeclarationSpecifiersTypeSpec,
	// · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · Case: TypeSpecifierInt,
	// · · · Token: example.c:1:8: INT "int",
	// · · },
	// · },
	// · FunctionSpecifier: &cc.FunctionSpecifier{
	// · · Case: FunctionSpecifierInline,
	// · · Token: example.c:1:1: INLINE "inline",
	// · },
	// }
}

func ExampleDeclarationSpecifiers_alignSpec() {
	fmt.Println(exampleAST(91, "_Alignas(double) int i;"))
	// Output:
	// &cc.DeclarationSpecifiers{
	// · AlignmentSpecifier: &cc.AlignmentSpecifier{
	// · · Case: AlignmentSpecifierAlignasType,
	// · · Token: example.c:1:1: ALIGNAS "_Alignas",
	// · · Token2: example.c:1:9: '(' "(",
	// · · Token3: example.c:1:16: ')' ")",
	// · · TypeName: &cc.TypeName{
	// · · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · · Case: SpecifierQualifierListTypeSpec,
	// · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · Case: TypeSpecifierDouble,
	// · · · · · Token: example.c:1:10: DOUBLE "double",
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: DeclarationSpecifiersAlignSpec,
	// · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · Case: DeclarationSpecifiersTypeSpec,
	// · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · Case: TypeSpecifierInt,
	// · · · Token: example.c:1:18: INT "int",
	// · · },
	// · },
	// }
}

func ExampleDeclarationSpecifiers_attribute() {
	fmt.Println(exampleAST(92, "int __attribute__((a)) i;"))
	// Output:
	// &cc.DeclarationSpecifiers{
	// · Case: DeclarationSpecifiersTypeSpec,
	// · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · AttributeSpecifier: &cc.AttributeSpecifier{
	// · · · AttributeValueList: &cc.AttributeValueList{
	// · · · · AttributeValue: &cc.AttributeValue{
	// · · · · · Case: AttributeValueIdent,
	// · · · · · Token: example.c:1:20: IDENTIFIER "a",
	// · · · · },
	// · · · },
	// · · · Token: example.c:1:5: ATTRIBUTE "__attribute__",
	// · · · Token2: example.c:1:18: '(' "(",
	// · · · Token3: example.c:1:19: '(' "(",
	// · · · Token4: example.c:1:21: ')' ")",
	// · · · Token5: example.c:1:22: ')' ")",
	// · · },
	// · · Case: DeclarationSpecifiersAttribute,
	// · },
	// · TypeSpecifier: &cc.TypeSpecifier{
	// · · Case: TypeSpecifierInt,
	// · · Token: example.c:1:1: INT "int",
	// · },
	// }
}

func ExampleDeclarator_case0() {
	fmt.Println(exampleAST(166, "int *p __attribute__ ((foo));"))
	// Output:
	// &cc.Declarator{
	// · AttributeSpecifierList: &cc.AttributeSpecifierList{
	// · · AttributeSpecifier: &cc.AttributeSpecifier{
	// · · · AttributeValueList: &cc.AttributeValueList{
	// · · · · AttributeValue: &cc.AttributeValue{
	// · · · · · Case: AttributeValueIdent,
	// · · · · · Token: example.c:1:24: IDENTIFIER "foo",
	// · · · · },
	// · · · },
	// · · · Token: example.c:1:8: ATTRIBUTE "__attribute__",
	// · · · Token2: example.c:1:22: '(' "(",
	// · · · Token3: example.c:1:23: '(' "(",
	// · · · Token4: example.c:1:27: ')' ")",
	// · · · Token5: example.c:1:28: ')' ")",
	// · · },
	// · },
	// · DirectDeclarator: &cc.DirectDeclarator{
	// · · Case: DirectDeclaratorIdent,
	// · · Token: example.c:1:6: IDENTIFIER "p",
	// · },
	// · Pointer: &cc.Pointer{
	// · · Case: PointerTypeQual,
	// · · Token: example.c:1:5: '*' "*",
	// · },
	// }
}

func ExampleDesignation_case0() {
	fmt.Println(exampleAST(205, "int a[] = { [42] = 314 };"))
	// Output:
	// &cc.Designation{
	// · DesignatorList: &cc.DesignatorList{
	// · · Designator: &cc.Designator{
	// · · · Case: DesignatorIndex,
	// · · · ConstantExpression: &cc.ConstantExpression{
	// · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · Case: ConditionalExpressionLOr,
	// · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · · · Token: example.c:1:14: INTCONST "42",
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Token: example.c:1:13: '[' "[",
	// · · · Token2: example.c:1:16: ']' "]",
	// · · },
	// · },
	// · Token: example.c:1:18: '=' "=",
	// }
}

func ExampleDesignator_index() {
	fmt.Println(exampleAST(208, "int a[] = { [42] = 314 };"))
	// Output:
	// &cc.Designator{
	// · Case: DesignatorIndex,
	// · ConstantExpression: &cc.ConstantExpression{
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:14: INTCONST "42",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: example.c:1:13: '[' "[",
	// · Token2: example.c:1:16: ']' "]",
	// }
}

func ExampleDesignator_field() {
	fmt.Println(exampleAST(209, "struct t s = { .fld = 314 };"))
	// Output:
	// &cc.Designator{
	// · Case: DesignatorField,
	// · Token: example.c:1:16: '.' ".",
	// · Token2: example.c:1:17: IDENTIFIER "fld",
	// }
}

func ExampleDesignator_field2() {
	fmt.Println(exampleAST(210, "struct t s = { fld: 314 };"))
	// Output:
	// &cc.Designator{
	// · Case: DesignatorField2,
	// · Token: example.c:1:16: IDENTIFIER "fld",
	// · Token2: example.c:1:19: ':' ":",
	// }
}

func ExampleDesignatorList_case0() {
	fmt.Println(exampleAST(206, "int a[] = { [42] = 314 };"))
	// Output:
	// &cc.DesignatorList{
	// · Designator: &cc.Designator{
	// · · Case: DesignatorIndex,
	// · · ConstantExpression: &cc.ConstantExpression{
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:14: INTCONST "42",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Token: example.c:1:13: '[' "[",
	// · · Token2: example.c:1:16: ']' "]",
	// · },
	// }
}

func ExampleDesignatorList_case1() {
	fmt.Println(exampleAST(207, "int a[100][] = { [42][12] = 314 };"))
	// Output:
	// &cc.DesignatorList{
	// · Designator: &cc.Designator{
	// · · Case: DesignatorIndex,
	// · · ConstantExpression: &cc.ConstantExpression{
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:19: INTCONST "42",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Token: example.c:1:18: '[' "[",
	// · · Token2: example.c:1:21: ']' "]",
	// · },
	// · DesignatorList: &cc.DesignatorList{
	// · · Designator: &cc.Designator{
	// · · · Case: DesignatorIndex,
	// · · · ConstantExpression: &cc.ConstantExpression{
	// · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · Case: ConditionalExpressionLOr,
	// · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · · · Token: example.c:1:23: INTCONST "12",
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Token: example.c:1:22: '[' "[",
	// · · · Token2: example.c:1:25: ']' "]",
	// · · },
	// · },
	// }
}

func ExampleDirectAbstractDeclarator_decl() {
	fmt.Println(exampleAST(195, "void f(int());"))
	// Output:
	// &cc.DirectAbstractDeclarator{
	// · Case: DirectAbstractDeclaratorFunc,
	// · Token: example.c:1:11: '(' "(",
	// · Token2: example.c:1:12: ')' ")",
	// }
}

func ExampleDirectAbstractDeclarator_arr() {
	fmt.Println(exampleAST(196, "void f(int[const 42]);"))
	// Output:
	// &cc.DirectAbstractDeclarator{
	// · AssignmentExpression: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:18: INTCONST "42",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: DirectAbstractDeclaratorArr,
	// · Token: example.c:1:11: '[' "[",
	// · Token2: example.c:1:20: ']' "]",
	// · TypeQualifiers: &cc.TypeQualifiers{
	// · · Case: TypeQualifiersTypeQual,
	// · · TypeQualifier: &cc.TypeQualifier{
	// · · · Case: TypeQualifierConst,
	// · · · Token: example.c:1:12: CONST "const",
	// · · },
	// · },
	// }
}

func ExampleDirectAbstractDeclarator_staticArr() {
	fmt.Println(exampleAST(197, "void f(int[static const 42]);"))
	// Output:
	// &cc.DirectAbstractDeclarator{
	// · AssignmentExpression: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:25: INTCONST "42",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: DirectAbstractDeclaratorStaticArr,
	// · Token: example.c:1:11: '[' "[",
	// · Token2: example.c:1:12: STATIC "static",
	// · Token3: example.c:1:27: ']' "]",
	// · TypeQualifiers: &cc.TypeQualifiers{
	// · · Case: TypeQualifiersTypeQual,
	// · · TypeQualifier: &cc.TypeQualifier{
	// · · · Case: TypeQualifierConst,
	// · · · Token: example.c:1:19: CONST "const",
	// · · },
	// · },
	// }
}

func ExampleDirectAbstractDeclarator_arrStatic() {
	fmt.Println(exampleAST(198, "void f(int[const static 42]);"))
	// Output:
	// &cc.DirectAbstractDeclarator{
	// · AssignmentExpression: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:25: INTCONST "42",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: DirectAbstractDeclaratorArrStatic,
	// · Token: example.c:1:11: '[' "[",
	// · Token2: example.c:1:18: STATIC "static",
	// · Token3: example.c:1:27: ']' "]",
	// · TypeQualifiers: &cc.TypeQualifiers{
	// · · Case: TypeQualifiersTypeQual,
	// · · TypeQualifier: &cc.TypeQualifier{
	// · · · Case: TypeQualifierConst,
	// · · · Token: example.c:1:12: CONST "const",
	// · · },
	// · },
	// }
}

func ExampleDirectAbstractDeclarator_arrStar() {
	fmt.Println(exampleAST(199, "void f(int[*]);"))
	// Output:
	// &cc.DirectAbstractDeclarator{
	// · Case: DirectAbstractDeclaratorArrStar,
	// · Token: example.c:1:11: '[' "[",
	// · Token2: example.c:1:12: '*' "*",
	// · Token3: example.c:1:13: ']' "]",
	// }
}

func ExampleDirectAbstractDeclarator_func() {
	fmt.Println(exampleAST(200, "void f(int(char));"))
	// Output:
	// &cc.DirectAbstractDeclarator{
	// · Case: DirectAbstractDeclaratorFunc,
	// · ParameterTypeList: &cc.ParameterTypeList{
	// · · Case: ParameterTypeListList,
	// · · ParameterList: &cc.ParameterList{
	// · · · ParameterDeclaration: &cc.ParameterDeclaration{
	// · · · · Case: ParameterDeclarationAbstract,
	// · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · Case: DeclarationSpecifiersTypeSpec,
	// · · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · · Case: TypeSpecifierChar,
	// · · · · · · Token: example.c:1:12: CHAR "char",
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: example.c:1:11: '(' "(",
	// · Token2: example.c:1:16: ')' ")",
	// }
}

func ExampleDirectDeclarator_ident() {
	fmt.Println(exampleAST(169, "int i;"))
	// Output:
	// &cc.DirectDeclarator{
	// · Case: DirectDeclaratorIdent,
	// · Token: example.c:1:5: IDENTIFIER "i",
	// }
}

func ExampleDirectDeclarator_decl() {
	fmt.Println(exampleAST(170, "int (f);"))
	// Output:
	// &cc.DirectDeclarator{
	// · Case: DirectDeclaratorDecl,
	// · Declarator: &cc.Declarator{
	// · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · Case: DirectDeclaratorIdent,
	// · · · Token: example.c:1:6: IDENTIFIER "f",
	// · · },
	// · },
	// · Token: example.c:1:5: '(' "(",
	// · Token2: example.c:1:7: ')' ")",
	// }
}

func ExampleDirectDeclarator_arr() {
	fmt.Println(exampleAST(171, "int i[const 42];"))
	// Output:
	// &cc.DirectDeclarator{
	// · AssignmentExpression: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:13: INTCONST "42",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: DirectDeclaratorArr,
	// · DirectDeclarator: &cc.DirectDeclarator{
	// · · Case: DirectDeclaratorIdent,
	// · · Token: example.c:1:5: IDENTIFIER "i",
	// · },
	// · Token: example.c:1:6: '[' "[",
	// · Token2: example.c:1:15: ']' "]",
	// · TypeQualifiers: &cc.TypeQualifiers{
	// · · Case: TypeQualifiersTypeQual,
	// · · TypeQualifier: &cc.TypeQualifier{
	// · · · Case: TypeQualifierConst,
	// · · · Token: example.c:1:7: CONST "const",
	// · · },
	// · },
	// }
}

func ExampleDirectDeclarator_staticArr() {
	fmt.Println(exampleAST(172, "int i[static const 42];"))
	// Output:
	// &cc.DirectDeclarator{
	// · AssignmentExpression: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:20: INTCONST "42",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: DirectDeclaratorStaticArr,
	// · DirectDeclarator: &cc.DirectDeclarator{
	// · · Case: DirectDeclaratorIdent,
	// · · Token: example.c:1:5: IDENTIFIER "i",
	// · },
	// · Token: example.c:1:6: '[' "[",
	// · Token2: example.c:1:7: STATIC "static",
	// · Token3: example.c:1:22: ']' "]",
	// · TypeQualifiers: &cc.TypeQualifiers{
	// · · Case: TypeQualifiersTypeQual,
	// · · TypeQualifier: &cc.TypeQualifier{
	// · · · Case: TypeQualifierConst,
	// · · · Token: example.c:1:14: CONST "const",
	// · · },
	// · },
	// }
}

func ExampleDirectDeclarator_arrStatic() {
	fmt.Println(exampleAST(173, "int i[const static 42];"))
	// Output:
	// &cc.DirectDeclarator{
	// · AssignmentExpression: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:20: INTCONST "42",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: DirectDeclaratorArrStatic,
	// · DirectDeclarator: &cc.DirectDeclarator{
	// · · Case: DirectDeclaratorIdent,
	// · · Token: example.c:1:5: IDENTIFIER "i",
	// · },
	// · Token: example.c:1:6: '[' "[",
	// · Token2: example.c:1:13: STATIC "static",
	// · Token3: example.c:1:22: ']' "]",
	// · TypeQualifiers: &cc.TypeQualifiers{
	// · · Case: TypeQualifiersTypeQual,
	// · · TypeQualifier: &cc.TypeQualifier{
	// · · · Case: TypeQualifierConst,
	// · · · Token: example.c:1:7: CONST "const",
	// · · },
	// · },
	// }
}

func ExampleDirectDeclarator_star() {
	fmt.Println(exampleAST(174, "int i[const *];"))
	// Output:
	// &cc.DirectDeclarator{
	// · Case: DirectDeclaratorStar,
	// · DirectDeclarator: &cc.DirectDeclarator{
	// · · Case: DirectDeclaratorIdent,
	// · · Token: example.c:1:5: IDENTIFIER "i",
	// · },
	// · Token: example.c:1:6: '[' "[",
	// · Token2: example.c:1:13: '*' "*",
	// · Token3: example.c:1:14: ']' "]",
	// · TypeQualifiers: &cc.TypeQualifiers{
	// · · Case: TypeQualifiersTypeQual,
	// · · TypeQualifier: &cc.TypeQualifier{
	// · · · Case: TypeQualifierConst,
	// · · · Token: example.c:1:7: CONST "const",
	// · · },
	// · },
	// }
}

func ExampleDirectDeclarator_funcParam() {
	fmt.Println(exampleAST(175, "int f(int i);"))
	// Output:
	// &cc.DirectDeclarator{
	// · Case: DirectDeclaratorFuncParam,
	// · DirectDeclarator: &cc.DirectDeclarator{
	// · · Case: DirectDeclaratorIdent,
	// · · Token: example.c:1:5: IDENTIFIER "f",
	// · },
	// · ParameterTypeList: &cc.ParameterTypeList{
	// · · Case: ParameterTypeListList,
	// · · ParameterList: &cc.ParameterList{
	// · · · ParameterDeclaration: &cc.ParameterDeclaration{
	// · · · · Case: ParameterDeclarationDecl,
	// · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · Case: DeclarationSpecifiersTypeSpec,
	// · · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · · Case: TypeSpecifierInt,
	// · · · · · · Token: example.c:1:7: INT "int",
	// · · · · · },
	// · · · · },
	// · · · · Declarator: &cc.Declarator{
	// · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · Token: example.c:1:11: IDENTIFIER "i",
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: example.c:1:6: '(' "(",
	// · Token2: example.c:1:12: ')' ")",
	// }
}

func ExampleDirectDeclarator_funcIdent() {
	fmt.Println(exampleAST(176, "int f(a);"))
	// Output:
	// &cc.DirectDeclarator{
	// · Case: DirectDeclaratorFuncIdent,
	// · DirectDeclarator: &cc.DirectDeclarator{
	// · · Case: DirectDeclaratorIdent,
	// · · Token: example.c:1:5: IDENTIFIER "f",
	// · },
	// · IdentifierList: &cc.IdentifierList{
	// · · Token: example.c:1:7: IDENTIFIER "a",
	// · },
	// · Token: example.c:1:6: '(' "(",
	// · Token2: example.c:1:8: ')' ")",
	// }
}

func ExampleEnumSpecifier_def() {
	fmt.Println(exampleAST(153, "enum e {a};"))
	// Output:
	// &cc.EnumSpecifier{
	// · Case: EnumSpecifierDef,
	// · EnumeratorList: &cc.EnumeratorList{
	// · · Enumerator: &cc.Enumerator{
	// · · · Case: EnumeratorIdent,
	// · · · Token: example.c:1:9: IDENTIFIER "a",
	// · · },
	// · },
	// · Token: example.c:1:1: ENUM "enum",
	// · Token2: example.c:1:6: IDENTIFIER "e",
	// · Token3: example.c:1:8: '{' "{",
	// · Token5: example.c:1:10: '}' "}",
	// }
}

func ExampleEnumSpecifier_tag() {
	fmt.Println(exampleAST(154, "enum e i;"))
	// Output:
	// &cc.EnumSpecifier{
	// · Case: EnumSpecifierTag,
	// · Token: example.c:1:1: ENUM "enum",
	// · Token2: example.c:1:6: IDENTIFIER "e",
	// }
}

func ExampleEnumerator_ident() {
	fmt.Println(exampleAST(157, "enum e {a};"))
	// Output:
	// &cc.Enumerator{
	// · Case: EnumeratorIdent,
	// · Token: example.c:1:9: IDENTIFIER "a",
	// }
}

func ExampleEnumerator_expr() {
	fmt.Println(exampleAST(158, "enum e {a = 42};"))
	// Output:
	// &cc.Enumerator{
	// · Case: EnumeratorExpr,
	// · ConstantExpression: &cc.ConstantExpression{
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:13: INTCONST "42",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: example.c:1:9: IDENTIFIER "a",
	// · Token2: example.c:1:11: '=' "=",
	// }
}

func ExampleEnumeratorList_case0() {
	fmt.Println(exampleAST(155, "enum e {a};"))
	// Output:
	// &cc.EnumeratorList{
	// · Enumerator: &cc.Enumerator{
	// · · Case: EnumeratorIdent,
	// · · Token: example.c:1:9: IDENTIFIER "a",
	// · },
	// }
}

func ExampleEnumeratorList_case1() {
	fmt.Println(exampleAST(156, "enum e {a, b};"))
	// Output:
	// &cc.EnumeratorList{
	// · Enumerator: &cc.Enumerator{
	// · · Case: EnumeratorIdent,
	// · · Token: example.c:1:9: IDENTIFIER "a",
	// · },
	// · EnumeratorList: &cc.EnumeratorList{
	// · · Enumerator: &cc.Enumerator{
	// · · · Case: EnumeratorIdent,
	// · · · Token: example.c:1:12: IDENTIFIER "b",
	// · · },
	// · · Token: example.c:1:10: ',' ",",
	// · },
	// }
}

func ExampleEqualityExpression_rel() {
	fmt.Println(exampleAST(56, "int i = x;"))
	// Output:
	// &cc.EqualityExpression{
	// · Case: EqualityExpressionRel,
	// · RelationalExpression: &cc.RelationalExpression{
	// · · Case: RelationalExpressionShift,
	// · · ShiftExpression: &cc.ShiftExpression{
	// · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · Case: AdditiveExpressionMul,
	// · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · Case: CastExpressionUnary,
	// · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Case: ShiftExpressionAdd,
	// · · },
	// · },
	// }
}

func ExampleEqualityExpression_eq() {
	fmt.Println(exampleAST(57, "int i = x == y;"))
	// Output:
	// &cc.EqualityExpression{
	// · Case: EqualityExpressionEq,
	// · EqualityExpression: &cc.EqualityExpression{
	// · · Case: EqualityExpressionRel,
	// · · RelationalExpression: &cc.RelationalExpression{
	// · · · Case: RelationalExpressionShift,
	// · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · Case: AdditiveExpressionMul,
	// · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · · Case: ShiftExpressionAdd,
	// · · · },
	// · · },
	// · },
	// · RelationalExpression: &cc.RelationalExpression{
	// · · Case: RelationalExpressionShift,
	// · · ShiftExpression: &cc.ShiftExpression{
	// · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · Case: AdditiveExpressionMul,
	// · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · Case: CastExpressionUnary,
	// · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · Token: example.c:1:14: IDENTIFIER "y",
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Case: ShiftExpressionAdd,
	// · · },
	// · },
	// · Token: example.c:1:11: EQ "==",
	// }
}

func ExampleEqualityExpression_neq() {
	fmt.Println(exampleAST(58, "int i = x != y;"))
	// Output:
	// &cc.EqualityExpression{
	// · Case: EqualityExpressionNeq,
	// · EqualityExpression: &cc.EqualityExpression{
	// · · Case: EqualityExpressionRel,
	// · · RelationalExpression: &cc.RelationalExpression{
	// · · · Case: RelationalExpressionShift,
	// · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · Case: AdditiveExpressionMul,
	// · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · · Case: ShiftExpressionAdd,
	// · · · },
	// · · },
	// · },
	// · RelationalExpression: &cc.RelationalExpression{
	// · · Case: RelationalExpressionShift,
	// · · ShiftExpression: &cc.ShiftExpression{
	// · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · Case: AdditiveExpressionMul,
	// · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · Case: CastExpressionUnary,
	// · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · Token: example.c:1:14: IDENTIFIER "y",
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Case: ShiftExpressionAdd,
	// · · },
	// · },
	// · Token: example.c:1:11: NEQ "!=",
	// }
}

func ExampleExclusiveOrExpression_and() {
	fmt.Println(exampleAST(61, "int i = x;"))
	// Output:
	// &cc.ExclusiveOrExpression{
	// · AndExpression: &cc.AndExpression{
	// · · Case: AndExpressionEq,
	// · · EqualityExpression: &cc.EqualityExpression{
	// · · · Case: EqualityExpressionRel,
	// · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · Case: RelationalExpressionShift,
	// · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · · Case: ShiftExpressionAdd,
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: ExclusiveOrExpressionAnd,
	// }
}

func ExampleExclusiveOrExpression_xor() {
	fmt.Println(exampleAST(62, "int i = x^y;"))
	// Output:
	// &cc.ExclusiveOrExpression{
	// · AndExpression: &cc.AndExpression{
	// · · Case: AndExpressionEq,
	// · · EqualityExpression: &cc.EqualityExpression{
	// · · · Case: EqualityExpressionRel,
	// · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · Case: RelationalExpressionShift,
	// · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · Token: example.c:1:11: IDENTIFIER "y",
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · · Case: ShiftExpressionAdd,
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: ExclusiveOrExpressionXor,
	// · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · AndExpression: &cc.AndExpression{
	// · · · Case: AndExpressionEq,
	// · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · Case: EqualityExpressionRel,
	// · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · Case: RelationalExpressionShift,
	// · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · · Case: ShiftExpressionAdd,
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ExclusiveOrExpressionAnd,
	// · },
	// · Token: example.c:1:10: '^' "^",
	// }
}

func ExampleExpression_assign() {
	fmt.Println(exampleAST(83, "int f() { i = x; };"))
	// Output:
	// &cc.Expression{
	// · AssignmentExpression: &cc.AssignmentExpression{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:15: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: AssignmentExpressionAssign,
	// · · Token: example.c:1:13: '=' "=",
	// · · UnaryExpression: &cc.UnaryExpression{
	// · · · Case: UnaryExpressionPostfix,
	// · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · Case: PostfixExpressionPrimary,
	// · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · Case: PrimaryExpressionIdent,
	// · · · · · Token: example.c:1:11: IDENTIFIER "i",
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: ExpressionAssign,
	// }
}

func ExampleExpression_comma() {
	fmt.Println(exampleAST(84, "int f() { x, y; };"))
	// Output:
	// &cc.Expression{
	// · AssignmentExpression: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:14: IDENTIFIER "y",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: ExpressionComma,
	// · Expression: &cc.Expression{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:11: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ExpressionAssign,
	// · },
	// · Token: example.c:1:12: ',' ",",
	// }
}

func ExampleExpressionList_case0() {
	fmt.Println(exampleAST(268, "int i __attribute__((a(b)));"))
	// Output:
	// &cc.ExpressionList{
	// · AssignmentExpression: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:24: IDENTIFIER "b",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleExpressionList_case1() {
	fmt.Println(exampleAST(269, "int i __attribute__((a(b, c)));"))
	// Output:
	// &cc.ExpressionList{
	// · AssignmentExpression: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:24: IDENTIFIER "b",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · ExpressionList: &cc.ExpressionList{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:27: IDENTIFIER "c",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Token: example.c:1:25: ',' ",",
	// · },
	// }
}

func ExampleExpressionStatement_case0() {
	fmt.Println(exampleAST(230, "int f() { g(); }"))
	// Output:
	// &cc.ExpressionStatement{
	// · Expression: &cc.Expression{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionCall,
	// · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · Token: example.c:1:11: IDENTIFIER "g",
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · Token: example.c:1:12: '(' "(",
	// · · · · · · · · · · · · · · · · · Token2: example.c:1:13: ')' ")",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ExpressionAssign,
	// · },
	// · Token: example.c:1:14: ';' ";",
	// }
}

func ExampleExternalDeclaration_funcDef() {
	fmt.Println(exampleAST(245, "int f() {}"))
	// Output:
	// &cc.ExternalDeclaration{
	// · Case: ExternalDeclarationFuncDef,
	// · FunctionDefinition: &cc.FunctionDefinition{
	// · · CompoundStatement: &cc.CompoundStatement{
	// · · · Token: example.c:1:9: '{' "{",
	// · · · Token2: example.c:1:10: '}' "}",
	// · · },
	// · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · Case: DeclarationSpecifiersTypeSpec,
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Case: TypeSpecifierInt,
	// · · · · Token: example.c:1:1: INT "int",
	// · · · },
	// · · },
	// · · Declarator: &cc.Declarator{
	// · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · Case: DirectDeclaratorFuncIdent,
	// · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · Case: DirectDeclaratorIdent,
	// · · · · · Token: example.c:1:5: IDENTIFIER "f",
	// · · · · },
	// · · · · Token: example.c:1:6: '(' "(",
	// · · · · Token2: example.c:1:7: ')' ")",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleExternalDeclaration_decl() {
	fmt.Println(exampleAST(246, "int i;"))
	// Output:
	// &cc.ExternalDeclaration{
	// · Case: ExternalDeclarationDecl,
	// · Declaration: &cc.Declaration{
	// · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · Case: DeclarationSpecifiersTypeSpec,
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Case: TypeSpecifierInt,
	// · · · · Token: example.c:1:1: INT "int",
	// · · · },
	// · · },
	// · · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · · InitDeclarator: &cc.InitDeclarator{
	// · · · · Case: InitDeclaratorDecl,
	// · · · · Declarator: &cc.Declarator{
	// · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · Token: example.c:1:5: IDENTIFIER "i",
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Token: example.c:1:6: ';' ";",
	// · },
	// }
}

func ExampleExternalDeclaration_asm() {
	fmt.Println(exampleAST(247, "int f() __asm__(\"nop\");"))
	// Output:
	// &cc.ExternalDeclaration{
	// · AsmFunctionDefinition: &cc.AsmFunctionDefinition{
	// · · AsmStatement: &cc.AsmStatement{
	// · · · Asm: &cc.Asm{
	// · · · · Token: example.c:1:9: ASM "__asm__",
	// · · · · Token2: example.c:1:16: '(' "(",
	// · · · · Token3: example.c:1:17: STRINGLITERAL "nop",
	// · · · · Token4: example.c:1:22: ')' ")",
	// · · · },
	// · · · Token: example.c:1:23: ';' ";",
	// · · },
	// · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · Case: DeclarationSpecifiersTypeSpec,
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Case: TypeSpecifierInt,
	// · · · · Token: example.c:1:1: INT "int",
	// · · · },
	// · · },
	// · · Declarator: &cc.Declarator{
	// · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · Case: DirectDeclaratorFuncIdent,
	// · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · Case: DirectDeclaratorIdent,
	// · · · · · Token: example.c:1:5: IDENTIFIER "f",
	// · · · · },
	// · · · · Token: example.c:1:6: '(' "(",
	// · · · · Token2: example.c:1:7: ')' ")",
	// · · · },
	// · · },
	// · },
	// · Case: ExternalDeclarationAsm,
	// }
}

func ExampleExternalDeclaration_asmStmt() {
	fmt.Println(exampleAST(248, "__asm__(\"nop\");"))
	// Output:
	// &cc.ExternalDeclaration{
	// · AsmStatement: &cc.AsmStatement{
	// · · Asm: &cc.Asm{
	// · · · Token: example.c:1:1: ASM "__asm__",
	// · · · Token2: example.c:1:8: '(' "(",
	// · · · Token3: example.c:1:9: STRINGLITERAL "nop",
	// · · · Token4: example.c:1:14: ')' ")",
	// · · },
	// · · Token: example.c:1:15: ';' ";",
	// · },
	// · Case: ExternalDeclarationAsmStmt,
	// }
}

func ExampleExternalDeclaration_empty() {
	fmt.Println(exampleAST(249, ";"))
	// Output:
	// &cc.ExternalDeclaration{
	// · Case: ExternalDeclarationEmpty,
	// · Token: example.c:1:1: ';' ";",
	// }
}

func ExampleExternalDeclaration_pragma() {
	fmt.Println(exampleAST(250, "#pragma STDC CX_LIMITED_RANGE DEFAULT"))
	// Output:
	// &cc.ExternalDeclaration{
	// · Case: ExternalDeclarationPragma,
	// · PragmaSTDC: &cc.PragmaSTDC{
	// · · Token: example.c:1:9: PPPRAGMASTDC "__pragma_stdc",
	// · · Token2: example.c:1:9: IDENTIFIER "STDC",
	// · · Token3: example.c:1:14: IDENTIFIER "CX_LIMITED_RANGE",
	// · · Token4: example.c:1:31: IDENTIFIER "DEFAULT",
	// · },
	// }
}

func ExampleFunctionDefinition_case0() {
	fmt.Println(exampleAST(251, "int f() {}"))
	// Output:
	// &cc.FunctionDefinition{
	// · CompoundStatement: &cc.CompoundStatement{
	// · · Token: example.c:1:9: '{' "{",
	// · · Token2: example.c:1:10: '}' "}",
	// · },
	// · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · Case: DeclarationSpecifiersTypeSpec,
	// · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · Case: TypeSpecifierInt,
	// · · · Token: example.c:1:1: INT "int",
	// · · },
	// · },
	// · Declarator: &cc.Declarator{
	// · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · Case: DirectDeclaratorFuncIdent,
	// · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · Case: DirectDeclaratorIdent,
	// · · · · Token: example.c:1:5: IDENTIFIER "f",
	// · · · },
	// · · · Token: example.c:1:6: '(' "(",
	// · · · Token2: example.c:1:7: ')' ")",
	// · · },
	// · },
	// }
}

func ExampleFunctionSpecifier_inline() {
	fmt.Println(exampleAST(164, "inline int f() {}"))
	// Output:
	// &cc.FunctionSpecifier{
	// · Case: FunctionSpecifierInline,
	// · Token: example.c:1:1: INLINE "inline",
	// }
}

func ExampleFunctionSpecifier_noreturn() {
	fmt.Println(exampleAST(165, "_Noreturn int f() {}"))
	// Output:
	// &cc.FunctionSpecifier{
	// · Case: FunctionSpecifierNoreturn,
	// · Token: example.c:1:1: NORETURN "_Noreturn",
	// }
}

func ExampleIdentifierList_case0() {
	fmt.Println(exampleAST(190, "int f(i) int i; {}"))
	// Output:
	// &cc.IdentifierList{
	// · Token: example.c:1:7: IDENTIFIER "i",
	// }
}

func ExampleIdentifierList_case1() {
	fmt.Println(exampleAST(191, "int f(i, j) int i, j; {}"))
	// Output:
	// &cc.IdentifierList{
	// · IdentifierList: &cc.IdentifierList{
	// · · Token: example.c:1:8: ',' ",",
	// · · Token2: example.c:1:10: IDENTIFIER "j",
	// · },
	// · Token: example.c:1:7: IDENTIFIER "i",
	// }
}

func ExampleInclusiveOrExpression_xor() {
	fmt.Println(exampleAST(63, "int i = x;"))
	// Output:
	// &cc.InclusiveOrExpression{
	// · Case: InclusiveOrExpressionXor,
	// · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · AndExpression: &cc.AndExpression{
	// · · · Case: AndExpressionEq,
	// · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · Case: EqualityExpressionRel,
	// · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · Case: RelationalExpressionShift,
	// · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · · Case: ShiftExpressionAdd,
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ExclusiveOrExpressionAnd,
	// · },
	// }
}

func ExampleInclusiveOrExpression_or() {
	fmt.Println(exampleAST(64, "int i = x|y;"))
	// Output:
	// &cc.InclusiveOrExpression{
	// · Case: InclusiveOrExpressionOr,
	// · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · AndExpression: &cc.AndExpression{
	// · · · Case: AndExpressionEq,
	// · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · Case: EqualityExpressionRel,
	// · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · Case: RelationalExpressionShift,
	// · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · Token: example.c:1:11: IDENTIFIER "y",
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · · Case: ShiftExpressionAdd,
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ExclusiveOrExpressionAnd,
	// · },
	// · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · Case: InclusiveOrExpressionXor,
	// · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · AndExpression: &cc.AndExpression{
	// · · · · Case: AndExpressionEq,
	// · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · Case: EqualityExpressionRel,
	// · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · Case: RelationalExpressionShift,
	// · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Case: ExclusiveOrExpressionAnd,
	// · · },
	// · },
	// · Token: example.c:1:10: '|' "|",
	// }
}

func ExampleInitDeclarator_decl() {
	fmt.Println(exampleAST(95, "int i;"))
	// Output:
	// &cc.InitDeclarator{
	// · Case: InitDeclaratorDecl,
	// · Declarator: &cc.Declarator{
	// · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · Case: DirectDeclaratorIdent,
	// · · · Token: example.c:1:5: IDENTIFIER "i",
	// · · },
	// · },
	// }
}

func ExampleInitDeclarator_init() {
	fmt.Println(exampleAST(96, "int i = x;"))
	// Output:
	// &cc.InitDeclarator{
	// · Case: InitDeclaratorInit,
	// · Declarator: &cc.Declarator{
	// · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · Case: DirectDeclaratorIdent,
	// · · · Token: example.c:1:5: IDENTIFIER "i",
	// · · },
	// · },
	// · Initializer: &cc.Initializer{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: InitializerExpr,
	// · },
	// · Token: example.c:1:7: '=' "=",
	// }
}

func ExampleInitDeclaratorList_case0() {
	fmt.Println(exampleAST(93, "int i;"))
	// Output:
	// &cc.InitDeclaratorList{
	// · InitDeclarator: &cc.InitDeclarator{
	// · · Case: InitDeclaratorDecl,
	// · · Declarator: &cc.Declarator{
	// · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · Case: DirectDeclaratorIdent,
	// · · · · Token: example.c:1:5: IDENTIFIER "i",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleInitDeclaratorList_case1() {
	fmt.Println(exampleAST(94, "int i, j;"))
	// Output:
	// &cc.InitDeclaratorList{
	// · InitDeclarator: &cc.InitDeclarator{
	// · · Case: InitDeclaratorDecl,
	// · · Declarator: &cc.Declarator{
	// · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · Case: DirectDeclaratorIdent,
	// · · · · Token: example.c:1:5: IDENTIFIER "i",
	// · · · },
	// · · },
	// · },
	// · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · InitDeclarator: &cc.InitDeclarator{
	// · · · Case: InitDeclaratorDecl,
	// · · · Declarator: &cc.Declarator{
	// · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · Case: DirectDeclaratorIdent,
	// · · · · · Token: example.c:1:8: IDENTIFIER "j",
	// · · · · },
	// · · · },
	// · · },
	// · · Token: example.c:1:6: ',' ",",
	// · },
	// }
}

func ExampleInitializer_expr() {
	fmt.Println(exampleAST(201, "int i = x;"))
	// Output:
	// &cc.Initializer{
	// · AssignmentExpression: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: InitializerExpr,
	// }
}

func ExampleInitializer_initList() {
	fmt.Println(exampleAST(202, "int i[] = { x };"))
	// Output:
	// &cc.Initializer{
	// · Case: InitializerInitList,
	// · InitializerList: &cc.InitializerList{
	// · · Initializer: &cc.Initializer{
	// · · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · · Case: AssignmentExpressionCond,
	// · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · Case: ConditionalExpressionLOr,
	// · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · Token: example.c:1:13: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Case: InitializerExpr,
	// · · },
	// · },
	// · Token: example.c:1:11: '{' "{",
	// · Token3: example.c:1:15: '}' "}",
	// }
}

func ExampleInitializerList_case0() {
	fmt.Println(exampleAST(203, "int i[] = { [10] = x };"))
	// Output:
	// &cc.InitializerList{
	// · Designation: &cc.Designation{
	// · · DesignatorList: &cc.DesignatorList{
	// · · · Designator: &cc.Designator{
	// · · · · Case: DesignatorIndex,
	// · · · · ConstantExpression: &cc.ConstantExpression{
	// · · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · · Case: ConditionalExpressionLOr,
	// · · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · · · · Token: example.c:1:14: INTCONST "10",
	// · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · · Token: example.c:1:13: '[' "[",
	// · · · · Token2: example.c:1:16: ']' "]",
	// · · · },
	// · · },
	// · · Token: example.c:1:18: '=' "=",
	// · },
	// · Initializer: &cc.Initializer{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:20: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: InitializerExpr,
	// · },
	// }
}

func ExampleInitializerList_case1() {
	fmt.Println(exampleAST(204, "int i[] = { [10] = x, [20] = y };"))
	// Output:
	// &cc.InitializerList{
	// · Designation: &cc.Designation{
	// · · DesignatorList: &cc.DesignatorList{
	// · · · Designator: &cc.Designator{
	// · · · · Case: DesignatorIndex,
	// · · · · ConstantExpression: &cc.ConstantExpression{
	// · · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · · Case: ConditionalExpressionLOr,
	// · · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · · · · Token: example.c:1:14: INTCONST "10",
	// · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · · Token: example.c:1:13: '[' "[",
	// · · · · Token2: example.c:1:16: ']' "]",
	// · · · },
	// · · },
	// · · Token: example.c:1:18: '=' "=",
	// · },
	// · Initializer: &cc.Initializer{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:20: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: InitializerExpr,
	// · },
	// · InitializerList: &cc.InitializerList{
	// · · Designation: &cc.Designation{
	// · · · DesignatorList: &cc.DesignatorList{
	// · · · · Designator: &cc.Designator{
	// · · · · · Case: DesignatorIndex,
	// · · · · · ConstantExpression: &cc.ConstantExpression{
	// · · · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · · · Case: ConditionalExpressionLOr,
	// · · · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · · · · · Token: example.c:1:24: INTCONST "20",
	// · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · · Token: example.c:1:23: '[' "[",
	// · · · · · Token2: example.c:1:26: ']' "]",
	// · · · · },
	// · · · },
	// · · · Token: example.c:1:28: '=' "=",
	// · · },
	// · · Initializer: &cc.Initializer{
	// · · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · · Case: AssignmentExpressionCond,
	// · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · Case: ConditionalExpressionLOr,
	// · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · Token: example.c:1:30: IDENTIFIER "y",
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Case: InitializerExpr,
	// · · },
	// · · Token: example.c:1:21: ',' ",",
	// · },
	// }
}

func ExampleIterationStatement_while() {
	fmt.Println(exampleAST(234, "int f() { while(x) y(); }"))
	// Output:
	// &cc.IterationStatement{
	// · Case: IterationStatementWhile,
	// · Expression: &cc.Expression{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:17: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ExpressionAssign,
	// · },
	// · Statement: &cc.Statement{
	// · · Case: StatementExpr,
	// · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · Expression: &cc.Expression{
	// · · · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · · · Case: AssignmentExpressionCond,
	// · · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · · Case: ConditionalExpressionLOr,
	// · · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionCall,
	// · · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · · · Token: example.c:1:20: IDENTIFIER "y",
	// · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · Token: example.c:1:21: '(' "(",
	// · · · · · · · · · · · · · · · · · · · Token2: example.c:1:22: ')' ")",
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · · Case: ExpressionAssign,
	// · · · },
	// · · · Token: example.c:1:23: ';' ";",
	// · · },
	// · },
	// · Token: example.c:1:11: WHILE "while",
	// · Token2: example.c:1:16: '(' "(",
	// · Token3: example.c:1:18: ')' ")",
	// }
}

func ExampleIterationStatement_do() {
	fmt.Println(exampleAST(235, "int f() { do x(); while(y); }"))
	// Output:
	// &cc.IterationStatement{
	// · Case: IterationStatementDo,
	// · Expression: &cc.Expression{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:25: IDENTIFIER "y",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ExpressionAssign,
	// · },
	// · Statement: &cc.Statement{
	// · · Case: StatementExpr,
	// · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · Expression: &cc.Expression{
	// · · · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · · · Case: AssignmentExpressionCond,
	// · · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · · Case: ConditionalExpressionLOr,
	// · · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionCall,
	// · · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · · · Token: example.c:1:14: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · Token: example.c:1:15: '(' "(",
	// · · · · · · · · · · · · · · · · · · · Token2: example.c:1:16: ')' ")",
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · · Case: ExpressionAssign,
	// · · · },
	// · · · Token: example.c:1:17: ';' ";",
	// · · },
	// · },
	// · Token: example.c:1:11: DO "do",
	// · Token2: example.c:1:19: WHILE "while",
	// · Token3: example.c:1:24: '(' "(",
	// · Token4: example.c:1:26: ')' ")",
	// · Token5: example.c:1:27: ';' ";",
	// }
}

func ExampleIterationStatement_for() {
	fmt.Println(exampleAST(236, "int f() { for( i = 0; i < 10; i++) x(); }"))
	// Output:
	// &cc.IterationStatement{
	// · Case: IterationStatementFor,
	// · Expression: &cc.Expression{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · · Case: AssignmentExpressionCond,
	// · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · Case: ConditionalExpressionLOr,
	// · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · · · Token: example.c:1:20: INTCONST "0",
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Case: AssignmentExpressionAssign,
	// · · · Token: example.c:1:18: '=' "=",
	// · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · Case: UnaryExpressionPostfix,
	// · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · Case: PostfixExpressionPrimary,
	// · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · Token: example.c:1:16: IDENTIFIER "i",
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ExpressionAssign,
	// · },
	// · Expression2: &cc.Expression{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionLt,
	// · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · Token: example.c:1:23: IDENTIFIER "i",
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:27: INTCONST "10",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Token: example.c:1:25: '<' "<",
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ExpressionAssign,
	// · },
	// · Expression3: &cc.Expression{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionInc,
	// · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · Token: example.c:1:31: IDENTIFIER "i",
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · Token: example.c:1:32: INC "++",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ExpressionAssign,
	// · },
	// · Statement: &cc.Statement{
	// · · Case: StatementExpr,
	// · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · Expression: &cc.Expression{
	// · · · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · · · Case: AssignmentExpressionCond,
	// · · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · · Case: ConditionalExpressionLOr,
	// · · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionCall,
	// · · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · · · Token: example.c:1:36: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · Token: example.c:1:37: '(' "(",
	// · · · · · · · · · · · · · · · · · · · Token2: example.c:1:38: ')' ")",
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · · Case: ExpressionAssign,
	// · · · },
	// · · · Token: example.c:1:39: ';' ";",
	// · · },
	// · },
	// · Token: example.c:1:11: FOR "for",
	// · Token2: example.c:1:14: '(' "(",
	// · Token3: example.c:1:21: ';' ";",
	// · Token4: example.c:1:29: ';' ";",
	// · Token5: example.c:1:34: ')' ")",
	// }
}

func ExampleIterationStatement_forDecl() {
	fmt.Println(exampleAST(237, "int f() { for( int i = 0; i < 10; i++) x(); }"))
	// Output:
	// &cc.IterationStatement{
	// · Case: IterationStatementForDecl,
	// · Declaration: &cc.Declaration{
	// · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · Case: DeclarationSpecifiersTypeSpec,
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Case: TypeSpecifierInt,
	// · · · · Token: example.c:1:16: INT "int",
	// · · · },
	// · · },
	// · · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · · InitDeclarator: &cc.InitDeclarator{
	// · · · · Case: InitDeclaratorInit,
	// · · · · Declarator: &cc.Declarator{
	// · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · Token: example.c:1:20: IDENTIFIER "i",
	// · · · · · },
	// · · · · },
	// · · · · Initializer: &cc.Initializer{
	// · · · · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · · · · Case: AssignmentExpressionCond,
	// · · · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · · · Case: ConditionalExpressionLOr,
	// · · · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · · · · · Token: example.c:1:24: INTCONST "0",
	// · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · · Case: InitializerExpr,
	// · · · · },
	// · · · · Token: example.c:1:22: '=' "=",
	// · · · },
	// · · },
	// · · Token: example.c:1:25: ';' ";",
	// · },
	// · Expression: &cc.Expression{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionLt,
	// · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · Token: example.c:1:27: IDENTIFIER "i",
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:31: INTCONST "10",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Token: example.c:1:29: '<' "<",
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ExpressionAssign,
	// · },
	// · Expression2: &cc.Expression{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionInc,
	// · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · Token: example.c:1:35: IDENTIFIER "i",
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · Token: example.c:1:36: INC "++",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ExpressionAssign,
	// · },
	// · Statement: &cc.Statement{
	// · · Case: StatementExpr,
	// · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · Expression: &cc.Expression{
	// · · · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · · · Case: AssignmentExpressionCond,
	// · · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · · Case: ConditionalExpressionLOr,
	// · · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionCall,
	// · · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · · · Token: example.c:1:40: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · Token: example.c:1:41: '(' "(",
	// · · · · · · · · · · · · · · · · · · · Token2: example.c:1:42: ')' ")",
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · · Case: ExpressionAssign,
	// · · · },
	// · · · Token: example.c:1:43: ';' ";",
	// · · },
	// · },
	// · Token: example.c:1:11: FOR "for",
	// · Token2: example.c:1:14: '(' "(",
	// · Token3: example.c:1:33: ';' ";",
	// · Token4: example.c:1:38: ')' ")",
	// }
}

func ExampleJumpStatement_goto() {
	fmt.Println(exampleAST(238, "int f() { L: goto L; }"))
	// Output:
	// &cc.JumpStatement{
	// · Case: JumpStatementGoto,
	// · Token: example.c:1:14: GOTO "goto",
	// · Token2: example.c:1:19: IDENTIFIER "L",
	// · Token3: example.c:1:20: ';' ";",
	// }
}

func ExampleJumpStatement_gotoExpr() {
	fmt.Println(exampleAST(239, "int f() { L: x(); void *p = &&L; goto *p; }"))
	// Output:
	// &cc.JumpStatement{
	// · Case: JumpStatementGotoExpr,
	// · Expression: &cc.Expression{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:40: IDENTIFIER "p",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ExpressionAssign,
	// · },
	// · Token: example.c:1:34: GOTO "goto",
	// · Token2: example.c:1:39: '*' "*",
	// · Token3: example.c:1:41: ';' ";",
	// }
}

func ExampleJumpStatement_continue() {
	fmt.Println(exampleAST(240, "int f() { for(;;) if (i) continue; }"))
	// Output:
	// &cc.JumpStatement{
	// · Case: JumpStatementContinue,
	// · Token: example.c:1:26: CONTINUE "continue",
	// · Token2: example.c:1:34: ';' ";",
	// }
}

func ExampleJumpStatement_break() {
	fmt.Println(exampleAST(241, "int f() { for(;;) if (i) break; }"))
	// Output:
	// &cc.JumpStatement{
	// · Case: JumpStatementBreak,
	// · Token: example.c:1:26: BREAK "break",
	// · Token2: example.c:1:31: ';' ";",
	// }
}

func ExampleJumpStatement_return() {
	fmt.Println(exampleAST(242, "int f() { if (i) return x; }"))
	// Output:
	// &cc.JumpStatement{
	// · Case: JumpStatementReturn,
	// · Expression: &cc.Expression{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:25: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ExpressionAssign,
	// · },
	// · Token: example.c:1:18: RETURN "return",
	// · Token2: example.c:1:26: ';' ";",
	// }
}

func ExampleLabelDeclaration_case0() {
	fmt.Println(exampleAST(267, "int f() { __label__ L; L: x(); }"))
	// Output:
	// &cc.LabelDeclaration{
	// · IdentifierList: &cc.IdentifierList{
	// · · Token: example.c:1:21: IDENTIFIER "L",
	// · },
	// · Token: example.c:1:11: LABEL "__label__",
	// · Token2: example.c:1:22: ';' ";",
	// }
}

func ExampleLabeledStatement_label() {
	fmt.Println(exampleAST(218, "int f() { L: goto L; }"))
	// Output:
	// &cc.LabeledStatement{
	// · Case: LabeledStatementLabel,
	// · Statement: &cc.Statement{
	// · · Case: StatementJump,
	// · · JumpStatement: &cc.JumpStatement{
	// · · · Case: JumpStatementGoto,
	// · · · Token: example.c:1:14: GOTO "goto",
	// · · · Token2: example.c:1:19: IDENTIFIER "L",
	// · · · Token3: example.c:1:20: ';' ";",
	// · · },
	// · },
	// · Token: example.c:1:11: IDENTIFIER "L",
	// · Token2: example.c:1:12: ':' ":",
	// }
}

func ExampleLabeledStatement_caseLabel() {
	fmt.Println(exampleAST(219, "int f() { switch(i) case 42: x(); }"))
	// Output:
	// &cc.LabeledStatement{
	// · Case: LabeledStatementCaseLabel,
	// · ConstantExpression: &cc.ConstantExpression{
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:26: INTCONST "42",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Statement: &cc.Statement{
	// · · Case: StatementExpr,
	// · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · Expression: &cc.Expression{
	// · · · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · · · Case: AssignmentExpressionCond,
	// · · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · · Case: ConditionalExpressionLOr,
	// · · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionCall,
	// · · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · · · Token: example.c:1:30: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · Token: example.c:1:31: '(' "(",
	// · · · · · · · · · · · · · · · · · · · Token2: example.c:1:32: ')' ")",
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · · Case: ExpressionAssign,
	// · · · },
	// · · · Token: example.c:1:33: ';' ";",
	// · · },
	// · },
	// · Token: example.c:1:21: CASE "case",
	// · Token2: example.c:1:28: ':' ":",
	// }
}

func ExampleLabeledStatement_range() {
	fmt.Println(exampleAST(220, "int f() { switch(i) case 42 ... 56: x(); }"))
	// Output:
	// &cc.LabeledStatement{
	// · Case: LabeledStatementRange,
	// · ConstantExpression: &cc.ConstantExpression{
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:26: INTCONST "42",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · ConstantExpression2: &cc.ConstantExpression{
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:33: INTCONST "56",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Statement: &cc.Statement{
	// · · Case: StatementExpr,
	// · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · Expression: &cc.Expression{
	// · · · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · · · Case: AssignmentExpressionCond,
	// · · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · · Case: ConditionalExpressionLOr,
	// · · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionCall,
	// · · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · · · Token: example.c:1:37: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · Token: example.c:1:38: '(' "(",
	// · · · · · · · · · · · · · · · · · · · Token2: example.c:1:39: ')' ")",
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · · Case: ExpressionAssign,
	// · · · },
	// · · · Token: example.c:1:40: ';' ";",
	// · · },
	// · },
	// · Token: example.c:1:21: CASE "case",
	// · Token2: example.c:1:29: DDD "...",
	// · Token3: example.c:1:35: ':' ":",
	// }
}

func ExampleLabeledStatement_default() {
	fmt.Println(exampleAST(221, "int f() { switch(i) default: x(); }"))
	// Output:
	// &cc.LabeledStatement{
	// · Case: LabeledStatementDefault,
	// · Statement: &cc.Statement{
	// · · Case: StatementExpr,
	// · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · Expression: &cc.Expression{
	// · · · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · · · Case: AssignmentExpressionCond,
	// · · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · · Case: ConditionalExpressionLOr,
	// · · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionCall,
	// · · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · · · Token: example.c:1:30: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · Token: example.c:1:31: '(' "(",
	// · · · · · · · · · · · · · · · · · · · Token2: example.c:1:32: ')' ")",
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · · Case: ExpressionAssign,
	// · · · },
	// · · · Token: example.c:1:33: ';' ";",
	// · · },
	// · },
	// · Token: example.c:1:21: DEFAULT "default",
	// · Token2: example.c:1:28: ':' ":",
	// }
}

func ExampleLogicalAndExpression_or() {
	fmt.Println(exampleAST(65, "int i = x;"))
	// Output:
	// &cc.LogicalAndExpression{
	// · Case: LogicalAndExpressionOr,
	// · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · Case: InclusiveOrExpressionXor,
	// · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · AndExpression: &cc.AndExpression{
	// · · · · Case: AndExpressionEq,
	// · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · Case: EqualityExpressionRel,
	// · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · Case: RelationalExpressionShift,
	// · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Case: ExclusiveOrExpressionAnd,
	// · · },
	// · },
	// }
}

func ExampleLogicalAndExpression_lAnd() {
	fmt.Println(exampleAST(66, "int i = x && y;"))
	// Output:
	// &cc.LogicalAndExpression{
	// · Case: LogicalAndExpressionLAnd,
	// · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · Case: InclusiveOrExpressionXor,
	// · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · AndExpression: &cc.AndExpression{
	// · · · · Case: AndExpressionEq,
	// · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · Case: EqualityExpressionRel,
	// · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · Case: RelationalExpressionShift,
	// · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · Token: example.c:1:14: IDENTIFIER "y",
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Case: ExclusiveOrExpressionAnd,
	// · · },
	// · },
	// · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · Case: LogicalAndExpressionOr,
	// · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · Case: InclusiveOrExpressionXor,
	// · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · AndExpression: &cc.AndExpression{
	// · · · · · Case: AndExpressionEq,
	// · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · Case: EqualityExpressionRel,
	// · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · · Case: ExclusiveOrExpressionAnd,
	// · · · },
	// · · },
	// · },
	// · Token: example.c:1:11: ANDAND "&&",
	// }
}

func ExampleLogicalOrExpression_lAnd() {
	fmt.Println(exampleAST(67, "int i = x;"))
	// Output:
	// &cc.LogicalOrExpression{
	// · Case: LogicalOrExpressionLAnd,
	// · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · Case: LogicalAndExpressionOr,
	// · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · Case: InclusiveOrExpressionXor,
	// · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · AndExpression: &cc.AndExpression{
	// · · · · · Case: AndExpressionEq,
	// · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · Case: EqualityExpressionRel,
	// · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · · Case: ExclusiveOrExpressionAnd,
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleLogicalOrExpression_lOr() {
	fmt.Println(exampleAST(68, "int i = x || y;"))
	// Output:
	// &cc.LogicalOrExpression{
	// · Case: LogicalOrExpressionLOr,
	// · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · Case: LogicalAndExpressionOr,
	// · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · Case: InclusiveOrExpressionXor,
	// · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · AndExpression: &cc.AndExpression{
	// · · · · · Case: AndExpressionEq,
	// · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · Case: EqualityExpressionRel,
	// · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · Token: example.c:1:14: IDENTIFIER "y",
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · · Case: ExclusiveOrExpressionAnd,
	// · · · },
	// · · },
	// · },
	// · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · Case: LogicalOrExpressionLAnd,
	// · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · Case: LogicalAndExpressionOr,
	// · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · Case: InclusiveOrExpressionXor,
	// · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · Case: AndExpressionEq,
	// · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: example.c:1:11: OROR "||",
	// }
}

func ExampleMultiplicativeExpression_cast() {
	fmt.Println(exampleAST(41, "int i = x;"))
	// Output:
	// &cc.MultiplicativeExpression{
	// · Case: MultiplicativeExpressionCast,
	// · CastExpression: &cc.CastExpression{
	// · · Case: CastExpressionUnary,
	// · · UnaryExpression: &cc.UnaryExpression{
	// · · · Case: UnaryExpressionPostfix,
	// · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · Case: PostfixExpressionPrimary,
	// · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · Case: PrimaryExpressionIdent,
	// · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · },
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleMultiplicativeExpression_mul() {
	fmt.Println(exampleAST(42, "int i = x * y;"))
	// Output:
	// &cc.MultiplicativeExpression{
	// · Case: MultiplicativeExpressionMul,
	// · CastExpression: &cc.CastExpression{
	// · · Case: CastExpressionUnary,
	// · · UnaryExpression: &cc.UnaryExpression{
	// · · · Case: UnaryExpressionPostfix,
	// · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · Case: PostfixExpressionPrimary,
	// · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · Case: PrimaryExpressionIdent,
	// · · · · · Token: example.c:1:13: IDENTIFIER "y",
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · Case: MultiplicativeExpressionCast,
	// · · CastExpression: &cc.CastExpression{
	// · · · Case: CastExpressionUnary,
	// · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · Case: UnaryExpressionPostfix,
	// · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · Case: PostfixExpressionPrimary,
	// · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: example.c:1:11: '*' "*",
	// }
}

func ExampleMultiplicativeExpression_div() {
	fmt.Println(exampleAST(43, "int i = x / y;"))
	// Output:
	// &cc.MultiplicativeExpression{
	// · Case: MultiplicativeExpressionDiv,
	// · CastExpression: &cc.CastExpression{
	// · · Case: CastExpressionUnary,
	// · · UnaryExpression: &cc.UnaryExpression{
	// · · · Case: UnaryExpressionPostfix,
	// · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · Case: PostfixExpressionPrimary,
	// · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · Case: PrimaryExpressionIdent,
	// · · · · · Token: example.c:1:13: IDENTIFIER "y",
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · Case: MultiplicativeExpressionCast,
	// · · CastExpression: &cc.CastExpression{
	// · · · Case: CastExpressionUnary,
	// · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · Case: UnaryExpressionPostfix,
	// · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · Case: PostfixExpressionPrimary,
	// · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: example.c:1:11: '/' "/",
	// }
}

func ExampleMultiplicativeExpression_mod() {
	fmt.Println(exampleAST(44, "int i = x % y;"))
	// Output:
	// &cc.MultiplicativeExpression{
	// · Case: MultiplicativeExpressionMod,
	// · CastExpression: &cc.CastExpression{
	// · · Case: CastExpressionUnary,
	// · · UnaryExpression: &cc.UnaryExpression{
	// · · · Case: UnaryExpressionPostfix,
	// · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · Case: PostfixExpressionPrimary,
	// · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · Case: PrimaryExpressionIdent,
	// · · · · · Token: example.c:1:13: IDENTIFIER "y",
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · Case: MultiplicativeExpressionCast,
	// · · CastExpression: &cc.CastExpression{
	// · · · Case: CastExpressionUnary,
	// · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · Case: UnaryExpressionPostfix,
	// · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · Case: PostfixExpressionPrimary,
	// · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: example.c:1:11: '%' "%",
	// }
}

func ExampleParameterDeclaration_decl() {
	fmt.Println(exampleAST(188, "int f(int i) {}"))
	// Output:
	// &cc.ParameterDeclaration{
	// · Case: ParameterDeclarationDecl,
	// · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · Case: DeclarationSpecifiersTypeSpec,
	// · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · Case: TypeSpecifierInt,
	// · · · Token: example.c:1:7: INT "int",
	// · · },
	// · },
	// · Declarator: &cc.Declarator{
	// · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · Case: DirectDeclaratorIdent,
	// · · · Token: example.c:1:11: IDENTIFIER "i",
	// · · },
	// · },
	// }
}

func ExampleParameterDeclaration_abstract() {
	fmt.Println(exampleAST(189, "int f(int*) {}"))
	// Output:
	// &cc.ParameterDeclaration{
	// · AbstractDeclarator: &cc.AbstractDeclarator{
	// · · Case: AbstractDeclaratorPtr,
	// · · Pointer: &cc.Pointer{
	// · · · Case: PointerTypeQual,
	// · · · Token: example.c:1:10: '*' "*",
	// · · },
	// · },
	// · Case: ParameterDeclarationAbstract,
	// · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · Case: DeclarationSpecifiersTypeSpec,
	// · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · Case: TypeSpecifierInt,
	// · · · Token: example.c:1:7: INT "int",
	// · · },
	// · },
	// }
}

func ExampleParameterList_case0() {
	fmt.Println(exampleAST(186, "int f(int i) {}"))
	// Output:
	// &cc.ParameterList{
	// · ParameterDeclaration: &cc.ParameterDeclaration{
	// · · Case: ParameterDeclarationDecl,
	// · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · Case: DeclarationSpecifiersTypeSpec,
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Case: TypeSpecifierInt,
	// · · · · Token: example.c:1:7: INT "int",
	// · · · },
	// · · },
	// · · Declarator: &cc.Declarator{
	// · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · Case: DirectDeclaratorIdent,
	// · · · · Token: example.c:1:11: IDENTIFIER "i",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleParameterList_case1() {
	fmt.Println(exampleAST(187, "int f(int i, int j) {}"))
	// Output:
	// &cc.ParameterList{
	// · ParameterDeclaration: &cc.ParameterDeclaration{
	// · · Case: ParameterDeclarationDecl,
	// · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · Case: DeclarationSpecifiersTypeSpec,
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Case: TypeSpecifierInt,
	// · · · · Token: example.c:1:7: INT "int",
	// · · · },
	// · · },
	// · · Declarator: &cc.Declarator{
	// · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · Case: DirectDeclaratorIdent,
	// · · · · Token: example.c:1:11: IDENTIFIER "i",
	// · · · },
	// · · },
	// · },
	// · ParameterList: &cc.ParameterList{
	// · · ParameterDeclaration: &cc.ParameterDeclaration{
	// · · · Case: ParameterDeclarationDecl,
	// · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · Case: DeclarationSpecifiersTypeSpec,
	// · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · Case: TypeSpecifierInt,
	// · · · · · Token: example.c:1:14: INT "int",
	// · · · · },
	// · · · },
	// · · · Declarator: &cc.Declarator{
	// · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · Case: DirectDeclaratorIdent,
	// · · · · · Token: example.c:1:18: IDENTIFIER "j",
	// · · · · },
	// · · · },
	// · · },
	// · · Token: example.c:1:12: ',' ",",
	// · },
	// }
}

func ExampleParameterTypeList_list() {
	fmt.Println(exampleAST(184, "int f(int i) {}"))
	// Output:
	// &cc.ParameterTypeList{
	// · Case: ParameterTypeListList,
	// · ParameterList: &cc.ParameterList{
	// · · ParameterDeclaration: &cc.ParameterDeclaration{
	// · · · Case: ParameterDeclarationDecl,
	// · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · Case: DeclarationSpecifiersTypeSpec,
	// · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · Case: TypeSpecifierInt,
	// · · · · · Token: example.c:1:7: INT "int",
	// · · · · },
	// · · · },
	// · · · Declarator: &cc.Declarator{
	// · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · Case: DirectDeclaratorIdent,
	// · · · · · Token: example.c:1:11: IDENTIFIER "i",
	// · · · · },
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleParameterTypeList_var() {
	fmt.Println(exampleAST(185, "int f(int i, ...) {}"))
	// Output:
	// &cc.ParameterTypeList{
	// · Case: ParameterTypeListVar,
	// · ParameterList: &cc.ParameterList{
	// · · ParameterDeclaration: &cc.ParameterDeclaration{
	// · · · Case: ParameterDeclarationDecl,
	// · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · Case: DeclarationSpecifiersTypeSpec,
	// · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · Case: TypeSpecifierInt,
	// · · · · · Token: example.c:1:7: INT "int",
	// · · · · },
	// · · · },
	// · · · Declarator: &cc.Declarator{
	// · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · Case: DirectDeclaratorIdent,
	// · · · · · Token: example.c:1:11: IDENTIFIER "i",
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: example.c:1:12: ',' ",",
	// · Token2: example.c:1:14: DDD "...",
	// }
}

func ExamplePointer_typeQual() {
	fmt.Println(exampleAST(177, "int *p;"))
	// Output:
	// &cc.Pointer{
	// · Case: PointerTypeQual,
	// · Token: example.c:1:5: '*' "*",
	// }
}

func ExamplePointer_ptr() {
	fmt.Println(exampleAST(178, "int **p;"))
	// Output:
	// &cc.Pointer{
	// · Case: PointerPtr,
	// · Pointer: &cc.Pointer{
	// · · Case: PointerTypeQual,
	// · · Token: example.c:1:6: '*' "*",
	// · },
	// · Token: example.c:1:5: '*' "*",
	// }
}

func ExamplePointer_block() {
	fmt.Println(exampleAST(179, "int atexit_b(void (^ _Nonnull)(void));"))
	// Output:
	// &cc.Pointer{
	// · Case: PointerBlock,
	// · Token: example.c:1:20: '^' "^",
	// }
}

func ExamplePostfixExpression_primary() {
	fmt.Println(exampleAST(11, "int i = x;"))
	// Output:
	// &cc.PostfixExpression{
	// · Case: PostfixExpressionPrimary,
	// · PrimaryExpression: &cc.PrimaryExpression{
	// · · Case: PrimaryExpressionIdent,
	// · · Token: example.c:1:9: IDENTIFIER "x",
	// · },
	// }
}

func ExamplePostfixExpression_index() {
	fmt.Println(exampleAST(12, "int i = x[y];"))
	// Output:
	// &cc.PostfixExpression{
	// · Case: PostfixExpressionIndex,
	// · Expression: &cc.Expression{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:11: IDENTIFIER "y",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ExpressionAssign,
	// · },
	// · PostfixExpression: &cc.PostfixExpression{
	// · · Case: PostfixExpressionPrimary,
	// · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · Case: PrimaryExpressionIdent,
	// · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · },
	// · },
	// · Token: example.c:1:10: '[' "[",
	// · Token2: example.c:1:12: ']' "]",
	// }
}

func ExamplePostfixExpression_call() {
	fmt.Println(exampleAST(13, "int i = x(y);"))
	// Output:
	// &cc.PostfixExpression{
	// · ArgumentExpressionList: &cc.ArgumentExpressionList{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:11: IDENTIFIER "y",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: PostfixExpressionCall,
	// · PostfixExpression: &cc.PostfixExpression{
	// · · Case: PostfixExpressionPrimary,
	// · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · Case: PrimaryExpressionIdent,
	// · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · },
	// · },
	// · Token: example.c:1:10: '(' "(",
	// · Token2: example.c:1:12: ')' ")",
	// }
}

func ExamplePostfixExpression_select() {
	fmt.Println(exampleAST(14, "int i = x.y;"))
	// Output:
	// &cc.PostfixExpression{
	// · Case: PostfixExpressionSelect,
	// · PostfixExpression: &cc.PostfixExpression{
	// · · Case: PostfixExpressionPrimary,
	// · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · Case: PrimaryExpressionIdent,
	// · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · },
	// · },
	// · Token: example.c:1:10: '.' ".",
	// · Token2: example.c:1:11: IDENTIFIER "y",
	// }
}

func ExamplePostfixExpression_pSelect() {
	fmt.Println(exampleAST(15, "int i = x->y;"))
	// Output:
	// &cc.PostfixExpression{
	// · Case: PostfixExpressionPSelect,
	// · PostfixExpression: &cc.PostfixExpression{
	// · · Case: PostfixExpressionPrimary,
	// · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · Case: PrimaryExpressionIdent,
	// · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · },
	// · },
	// · Token: example.c:1:10: ARROW "->",
	// · Token2: example.c:1:12: IDENTIFIER "y",
	// }
}

func ExamplePostfixExpression_inc() {
	fmt.Println(exampleAST(16, "int i = x++;"))
	// Output:
	// &cc.PostfixExpression{
	// · Case: PostfixExpressionInc,
	// · PostfixExpression: &cc.PostfixExpression{
	// · · Case: PostfixExpressionPrimary,
	// · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · Case: PrimaryExpressionIdent,
	// · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · },
	// · },
	// · Token: example.c:1:10: INC "++",
	// }
}

func ExamplePostfixExpression_dec() {
	fmt.Println(exampleAST(17, "int i = x--;"))
	// Output:
	// &cc.PostfixExpression{
	// · Case: PostfixExpressionDec,
	// · PostfixExpression: &cc.PostfixExpression{
	// · · Case: PostfixExpressionPrimary,
	// · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · Case: PrimaryExpressionIdent,
	// · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · },
	// · },
	// · Token: example.c:1:10: DEC "--",
	// }
}

func ExamplePostfixExpression_complit() {
	fmt.Println(exampleAST(18, "int i = (int[]){y};"))
	// Output:
	// &cc.PostfixExpression{
	// · Case: PostfixExpressionComplit,
	// · InitializerList: &cc.InitializerList{
	// · · Initializer: &cc.Initializer{
	// · · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · · Case: AssignmentExpressionCond,
	// · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · Case: ConditionalExpressionLOr,
	// · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · Token: example.c:1:17: IDENTIFIER "y",
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Case: InitializerExpr,
	// · · },
	// · },
	// · Token3: example.c:1:16: '{' "{",
	// · Token5: example.c:1:18: '}' "}",
	// · TypeName: &cc.TypeName{
	// · · AbstractDeclarator: &cc.AbstractDeclarator{
	// · · · Case: AbstractDeclaratorDecl,
	// · · · DirectAbstractDeclarator: &cc.DirectAbstractDeclarator{
	// · · · · Case: DirectAbstractDeclaratorArr,
	// · · · · Token: example.c:1:13: '[' "[",
	// · · · · Token2: example.c:1:14: ']' "]",
	// · · · },
	// · · },
	// · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · Case: SpecifierQualifierListTypeSpec,
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Case: TypeSpecifierInt,
	// · · · · Token: example.c:1:10: INT "int",
	// · · · },
	// · · },
	// · },
	// }
}

func ExamplePostfixExpression_typeCmp() {
	fmt.Println(exampleAST(19, "int i = __builtin_types_compatible_p(int, double);"))
	// Output:
	// &cc.PostfixExpression{
	// · Case: PostfixExpressionTypeCmp,
	// · Token: example.c:1:9: BUILTINTYPESCOMPATIBLE "__builtin_types_compatible_p",
	// · Token2: example.c:1:37: '(' "(",
	// · Token3: example.c:1:41: ',' ",",
	// · Token4: example.c:1:49: ')' ")",
	// · TypeName: &cc.TypeName{
	// · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · Case: SpecifierQualifierListTypeSpec,
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Case: TypeSpecifierInt,
	// · · · · Token: example.c:1:38: INT "int",
	// · · · },
	// · · },
	// · },
	// · TypeName2: &cc.TypeName{
	// · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · Case: SpecifierQualifierListTypeSpec,
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Case: TypeSpecifierDouble,
	// · · · · Token: example.c:1:43: DOUBLE "double",
	// · · · },
	// · · },
	// · },
	// }
}

func ExamplePostfixExpression_chooseExpr() {
	fmt.Println(exampleAST(20, "int i = __builtin_choose_expr(1, 2, \"foo\");"))
	// Output:
	// &cc.PostfixExpression{
	// · AssignmentExpression: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:31: INTCONST "1",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · AssignmentExpression2: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:34: INTCONST "2",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · AssignmentExpression3: &cc.AssignmentExpression{
	// · · Case: AssignmentExpressionCond,
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionString,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:37: STRINGLITERAL "foo",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: PostfixExpressionChooseExpr,
	// · Token: example.c:1:9: BUILTINCHOOSEEXPR "__builtin_choose_expr",
	// · Token2: example.c:1:30: '(' "(",
	// · Token3: example.c:1:32: ',' ",",
	// · Token4: example.c:1:35: ',' ",",
	// · Token5: example.c:1:42: ')' ")",
	// }
}

func ExamplePragmaSTDC_case0() {
	fmt.Println(exampleAST(277, "_Pragma(\"STDC FP_CONTRACT ON\")"))
	// Output:
	// &cc.PragmaSTDC{
	// · Token: example.c:1:9: PPPRAGMASTDC "__pragma_stdc",
	// · Token2: example.c:1:9: IDENTIFIER "STDC",
	// · Token3: example.c:1:9: IDENTIFIER "FP_CONTRACT",
	// · Token4: example.c:1:9: IDENTIFIER "ON",
	// }
}

func ExamplePrimaryExpression_ident() {
	fmt.Println(exampleAST(1, "int i = x;"))
	// Output:
	// &cc.PrimaryExpression{
	// · Case: PrimaryExpressionIdent,
	// · Token: example.c:1:9: IDENTIFIER "x",
	// }
}

func ExamplePrimaryExpression_int() {
	fmt.Println(exampleAST(2, "int i = 42;"))
	// Output:
	// &cc.PrimaryExpression{
	// · Case: PrimaryExpressionInt,
	// · Token: example.c:1:9: INTCONST "42",
	// }
}

func ExamplePrimaryExpression_float() {
	fmt.Println(exampleAST(3, "int i = 3.14;"))
	// Output:
	// &cc.PrimaryExpression{
	// · Case: PrimaryExpressionFloat,
	// · Token: example.c:1:9: FLOATCONST "3.14",
	// }
}

func ExamplePrimaryExpression_enum() {
	fmt.Println(exampleAST(4, "enum e {a}; int i = a;"))
	// Output:
	// &cc.PrimaryExpression{
	// · Case: PrimaryExpressionEnum,
	// · Token: example.c:1:21: ENUMCONST "a",
	// }
}

func ExamplePrimaryExpression_char() {
	fmt.Println(exampleAST(5, "int i = 'x';"))
	// Output:
	// &cc.PrimaryExpression{
	// · Case: PrimaryExpressionChar,
	// · Token: example.c:1:9: CHARCONST "x",
	// }
}

func ExamplePrimaryExpression_lChar() {
	fmt.Println(exampleAST(6, "int i = L'x';"))
	// Output:
	// &cc.PrimaryExpression{
	// · Case: PrimaryExpressionLChar,
	// · Token: example.c:1:9: LONGCHARCONST "x",
	// }
}

func ExamplePrimaryExpression_string() {
	fmt.Println(exampleAST(7, "char *c = \"x\";"))
	// Output:
	// &cc.PrimaryExpression{
	// · Case: PrimaryExpressionString,
	// · Token: example.c:1:11: STRINGLITERAL "x",
	// }
}

func ExamplePrimaryExpression_lString() {
	fmt.Println(exampleAST(8, "char *c = L\"x\";"))
	// Output:
	// &cc.PrimaryExpression{
	// · Case: PrimaryExpressionLString,
	// · Token: example.c:1:11: LONGSTRINGLITERAL "x",
	// }
}

func ExamplePrimaryExpression_expr() {
	fmt.Println(exampleAST(9, "int i = (x+y);"))
	// Output:
	// &cc.PrimaryExpression{
	// · Case: PrimaryExpressionExpr,
	// · Expression: &cc.Expression{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · Token: example.c:1:10: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · Case: AdditiveExpressionAdd,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:12: IDENTIFIER "y",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · Token: example.c:1:11: '+' "+",
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ExpressionAssign,
	// · },
	// · Token: example.c:1:9: '(' "(",
	// · Token2: example.c:1:13: ')' ")",
	// }
}

func ExamplePrimaryExpression_stmt() {
	fmt.Println(exampleAST(10, "int i = ({x();});"))
	// Output:
	// &cc.PrimaryExpression{
	// · Case: PrimaryExpressionStmt,
	// · CompoundStatement: &cc.CompoundStatement{
	// · · BlockItemList: &cc.BlockItemList{
	// · · · BlockItem: &cc.BlockItem{
	// · · · · Case: BlockItemStmt,
	// · · · · Statement: &cc.Statement{
	// · · · · · Case: StatementExpr,
	// · · · · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · · · · Expression: &cc.Expression{
	// · · · · · · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · · · · · · Case: AssignmentExpressionCond,
	// · · · · · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · · · · · Case: ConditionalExpressionLOr,
	// · · · · · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionCall,
	// · · · · · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · · · · · · Token: example.c:1:11: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · · · · Token: example.c:1:12: '(' "(",
	// · · · · · · · · · · · · · · · · · · · · · · Token2: example.c:1:13: ')' ")",
	// · · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExpressionAssign,
	// · · · · · · },
	// · · · · · · Token: example.c:1:14: ';' ";",
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Token: example.c:1:10: '{' "{",
	// · · Token2: example.c:1:15: '}' "}",
	// · },
	// · Token: example.c:1:9: '(' "(",
	// · Token2: example.c:1:16: ')' ")",
	// }
}

func ExampleRelationalExpression_shift() {
	fmt.Println(exampleAST(51, "int i = x;"))
	// Output:
	// &cc.RelationalExpression{
	// · Case: RelationalExpressionShift,
	// · ShiftExpression: &cc.ShiftExpression{
	// · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · Case: AdditiveExpressionMul,
	// · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · Case: MultiplicativeExpressionCast,
	// · · · · CastExpression: &cc.CastExpression{
	// · · · · · Case: CastExpressionUnary,
	// · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ShiftExpressionAdd,
	// · },
	// }
}

func ExampleRelationalExpression_lt() {
	fmt.Println(exampleAST(52, "int i = x < y;"))
	// Output:
	// &cc.RelationalExpression{
	// · Case: RelationalExpressionLt,
	// · RelationalExpression: &cc.RelationalExpression{
	// · · Case: RelationalExpressionShift,
	// · · ShiftExpression: &cc.ShiftExpression{
	// · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · Case: AdditiveExpressionMul,
	// · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · Case: CastExpressionUnary,
	// · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Case: ShiftExpressionAdd,
	// · · },
	// · },
	// · ShiftExpression: &cc.ShiftExpression{
	// · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · Case: AdditiveExpressionMul,
	// · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · Case: MultiplicativeExpressionCast,
	// · · · · CastExpression: &cc.CastExpression{
	// · · · · · Case: CastExpressionUnary,
	// · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · Token: example.c:1:13: IDENTIFIER "y",
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ShiftExpressionAdd,
	// · },
	// · Token: example.c:1:11: '<' "<",
	// }
}

func ExampleRelationalExpression_gt() {
	fmt.Println(exampleAST(53, "int i = x > y;"))
	// Output:
	// &cc.RelationalExpression{
	// · Case: RelationalExpressionGt,
	// · RelationalExpression: &cc.RelationalExpression{
	// · · Case: RelationalExpressionShift,
	// · · ShiftExpression: &cc.ShiftExpression{
	// · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · Case: AdditiveExpressionMul,
	// · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · Case: CastExpressionUnary,
	// · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Case: ShiftExpressionAdd,
	// · · },
	// · },
	// · ShiftExpression: &cc.ShiftExpression{
	// · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · Case: AdditiveExpressionMul,
	// · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · Case: MultiplicativeExpressionCast,
	// · · · · CastExpression: &cc.CastExpression{
	// · · · · · Case: CastExpressionUnary,
	// · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · Token: example.c:1:13: IDENTIFIER "y",
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ShiftExpressionAdd,
	// · },
	// · Token: example.c:1:11: '>' ">",
	// }
}

func ExampleRelationalExpression_leq() {
	fmt.Println(exampleAST(54, "int i = x <= y;"))
	// Output:
	// &cc.RelationalExpression{
	// · Case: RelationalExpressionLeq,
	// · RelationalExpression: &cc.RelationalExpression{
	// · · Case: RelationalExpressionShift,
	// · · ShiftExpression: &cc.ShiftExpression{
	// · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · Case: AdditiveExpressionMul,
	// · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · Case: CastExpressionUnary,
	// · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Case: ShiftExpressionAdd,
	// · · },
	// · },
	// · ShiftExpression: &cc.ShiftExpression{
	// · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · Case: AdditiveExpressionMul,
	// · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · Case: MultiplicativeExpressionCast,
	// · · · · CastExpression: &cc.CastExpression{
	// · · · · · Case: CastExpressionUnary,
	// · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · Token: example.c:1:14: IDENTIFIER "y",
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ShiftExpressionAdd,
	// · },
	// · Token: example.c:1:11: LEQ "<=",
	// }
}

func ExampleRelationalExpression_geq() {
	fmt.Println(exampleAST(55, "int i = x >= y;"))
	// Output:
	// &cc.RelationalExpression{
	// · Case: RelationalExpressionGeq,
	// · RelationalExpression: &cc.RelationalExpression{
	// · · Case: RelationalExpressionShift,
	// · · ShiftExpression: &cc.ShiftExpression{
	// · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · Case: AdditiveExpressionMul,
	// · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · Case: CastExpressionUnary,
	// · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Case: ShiftExpressionAdd,
	// · · },
	// · },
	// · ShiftExpression: &cc.ShiftExpression{
	// · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · Case: AdditiveExpressionMul,
	// · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · Case: MultiplicativeExpressionCast,
	// · · · · CastExpression: &cc.CastExpression{
	// · · · · · Case: CastExpressionUnary,
	// · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · Token: example.c:1:14: IDENTIFIER "y",
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ShiftExpressionAdd,
	// · },
	// · Token: example.c:1:11: GEQ ">=",
	// }
}

func ExampleSelectionStatement_if() {
	fmt.Println(exampleAST(231, "int f() { if(x) y(); }"))
	// Output:
	// &cc.SelectionStatement{
	// · Case: SelectionStatementIf,
	// · Expression: &cc.Expression{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:14: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ExpressionAssign,
	// · },
	// · Statement: &cc.Statement{
	// · · Case: StatementExpr,
	// · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · Expression: &cc.Expression{
	// · · · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · · · Case: AssignmentExpressionCond,
	// · · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · · Case: ConditionalExpressionLOr,
	// · · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionCall,
	// · · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · · · Token: example.c:1:17: IDENTIFIER "y",
	// · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · Token: example.c:1:18: '(' "(",
	// · · · · · · · · · · · · · · · · · · · Token2: example.c:1:19: ')' ")",
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · · Case: ExpressionAssign,
	// · · · },
	// · · · Token: example.c:1:20: ';' ";",
	// · · },
	// · },
	// · Token: example.c:1:11: IF "if",
	// · Token2: example.c:1:13: '(' "(",
	// · Token3: example.c:1:15: ')' ")",
	// }
}

func ExampleSelectionStatement_ifElse() {
	fmt.Println(exampleAST(232, "int f() { if(x) y(); else z(); }"))
	// Output:
	// &cc.SelectionStatement{
	// · Case: SelectionStatementIfElse,
	// · Expression: &cc.Expression{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:14: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ExpressionAssign,
	// · },
	// · Statement: &cc.Statement{
	// · · Case: StatementExpr,
	// · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · Expression: &cc.Expression{
	// · · · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · · · Case: AssignmentExpressionCond,
	// · · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · · Case: ConditionalExpressionLOr,
	// · · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionCall,
	// · · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · · · Token: example.c:1:17: IDENTIFIER "y",
	// · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · Token: example.c:1:18: '(' "(",
	// · · · · · · · · · · · · · · · · · · · Token2: example.c:1:19: ')' ")",
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · · Case: ExpressionAssign,
	// · · · },
	// · · · Token: example.c:1:20: ';' ";",
	// · · },
	// · },
	// · Statement2: &cc.Statement{
	// · · Case: StatementExpr,
	// · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · Expression: &cc.Expression{
	// · · · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · · · Case: AssignmentExpressionCond,
	// · · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · · Case: ConditionalExpressionLOr,
	// · · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionCall,
	// · · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · · · Token: example.c:1:27: IDENTIFIER "z",
	// · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · Token: example.c:1:28: '(' "(",
	// · · · · · · · · · · · · · · · · · · · Token2: example.c:1:29: ')' ")",
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · · Case: ExpressionAssign,
	// · · · },
	// · · · Token: example.c:1:30: ';' ";",
	// · · },
	// · },
	// · Token: example.c:1:11: IF "if",
	// · Token2: example.c:1:13: '(' "(",
	// · Token3: example.c:1:15: ')' ")",
	// · Token4: example.c:1:22: ELSE "else",
	// }
}

func ExampleSelectionStatement_switch() {
	fmt.Println(exampleAST(233, "int f() { switch(i) case 42: x(); }"))
	// Output:
	// &cc.SelectionStatement{
	// · Case: SelectionStatementSwitch,
	// · Expression: &cc.Expression{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:18: IDENTIFIER "i",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ExpressionAssign,
	// · },
	// · Statement: &cc.Statement{
	// · · Case: StatementLabeled,
	// · · LabeledStatement: &cc.LabeledStatement{
	// · · · Case: LabeledStatementCaseLabel,
	// · · · ConstantExpression: &cc.ConstantExpression{
	// · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · Case: ConditionalExpressionLOr,
	// · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · · · Token: example.c:1:26: INTCONST "42",
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Statement: &cc.Statement{
	// · · · · Case: StatementExpr,
	// · · · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · · · Expression: &cc.Expression{
	// · · · · · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · · · · · Case: AssignmentExpressionCond,
	// · · · · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · · · · Case: ConditionalExpressionLOr,
	// · · · · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionCall,
	// · · · · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · · · · · Token: example.c:1:30: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · · · Token: example.c:1:31: '(' "(",
	// · · · · · · · · · · · · · · · · · · · · · Token2: example.c:1:32: ')' ")",
	// · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · · Case: ExpressionAssign,
	// · · · · · },
	// · · · · · Token: example.c:1:33: ';' ";",
	// · · · · },
	// · · · },
	// · · · Token: example.c:1:21: CASE "case",
	// · · · Token2: example.c:1:28: ':' ":",
	// · · },
	// · },
	// · Token: example.c:1:11: SWITCH "switch",
	// · Token2: example.c:1:17: '(' "(",
	// · Token3: example.c:1:19: ')' ")",
	// }
}

func ExampleShiftExpression_add() {
	fmt.Println(exampleAST(48, "int i = x;"))
	// Output:
	// &cc.ShiftExpression{
	// · AdditiveExpression: &cc.AdditiveExpression{
	// · · Case: AdditiveExpressionMul,
	// · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · Case: MultiplicativeExpressionCast,
	// · · · CastExpression: &cc.CastExpression{
	// · · · · Case: CastExpressionUnary,
	// · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · Case: UnaryExpressionPostfix,
	// · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: ShiftExpressionAdd,
	// }
}

func ExampleShiftExpression_lsh() {
	fmt.Println(exampleAST(49, "int i = x << y;"))
	// Output:
	// &cc.ShiftExpression{
	// · AdditiveExpression: &cc.AdditiveExpression{
	// · · Case: AdditiveExpressionMul,
	// · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · Case: MultiplicativeExpressionCast,
	// · · · CastExpression: &cc.CastExpression{
	// · · · · Case: CastExpressionUnary,
	// · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · Case: UnaryExpressionPostfix,
	// · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · Token: example.c:1:14: IDENTIFIER "y",
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: ShiftExpressionLsh,
	// · ShiftExpression: &cc.ShiftExpression{
	// · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · Case: AdditiveExpressionMul,
	// · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · Case: MultiplicativeExpressionCast,
	// · · · · CastExpression: &cc.CastExpression{
	// · · · · · Case: CastExpressionUnary,
	// · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ShiftExpressionAdd,
	// · },
	// · Token: example.c:1:11: LSH "<<",
	// }
}

func ExampleShiftExpression_rsh() {
	fmt.Println(exampleAST(50, "int i = x >> y;"))
	// Output:
	// &cc.ShiftExpression{
	// · AdditiveExpression: &cc.AdditiveExpression{
	// · · Case: AdditiveExpressionMul,
	// · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · Case: MultiplicativeExpressionCast,
	// · · · CastExpression: &cc.CastExpression{
	// · · · · Case: CastExpressionUnary,
	// · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · Case: UnaryExpressionPostfix,
	// · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · Token: example.c:1:14: IDENTIFIER "y",
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: ShiftExpressionRsh,
	// · ShiftExpression: &cc.ShiftExpression{
	// · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · Case: AdditiveExpressionMul,
	// · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · Case: MultiplicativeExpressionCast,
	// · · · · CastExpression: &cc.CastExpression{
	// · · · · · Case: CastExpressionUnary,
	// · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ShiftExpressionAdd,
	// · },
	// · Token: example.c:1:11: RSH ">>",
	// }
}

func ExampleSpecifierQualifierList_typeSpec() {
	fmt.Println(exampleAST(145, "struct {int i;};"))
	// Output:
	// &cc.SpecifierQualifierList{
	// · Case: SpecifierQualifierListTypeSpec,
	// · TypeSpecifier: &cc.TypeSpecifier{
	// · · Case: TypeSpecifierInt,
	// · · Token: example.c:1:9: INT "int",
	// · },
	// }
}

func ExampleSpecifierQualifierList_typeQual() {
	fmt.Println(exampleAST(146, "struct {const int i;};"))
	// Output:
	// &cc.SpecifierQualifierList{
	// · Case: SpecifierQualifierListTypeQual,
	// · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · Case: SpecifierQualifierListTypeSpec,
	// · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · Case: TypeSpecifierInt,
	// · · · Token: example.c:1:15: INT "int",
	// · · },
	// · },
	// · TypeQualifier: &cc.TypeQualifier{
	// · · Case: TypeQualifierConst,
	// · · Token: example.c:1:9: CONST "const",
	// · },
	// }
}

func ExampleSpecifierQualifierList_alignSpec() {
	fmt.Println(exampleAST(147, "struct {_Alignas(double) int i;};"))
	// Output:
	// &cc.SpecifierQualifierList{
	// · AlignmentSpecifier: &cc.AlignmentSpecifier{
	// · · Case: AlignmentSpecifierAlignasType,
	// · · Token: example.c:1:9: ALIGNAS "_Alignas",
	// · · Token2: example.c:1:17: '(' "(",
	// · · Token3: example.c:1:24: ')' ")",
	// · · TypeName: &cc.TypeName{
	// · · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · · Case: SpecifierQualifierListTypeSpec,
	// · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · Case: TypeSpecifierDouble,
	// · · · · · Token: example.c:1:18: DOUBLE "double",
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: SpecifierQualifierListAlignSpec,
	// · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · Case: SpecifierQualifierListTypeSpec,
	// · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · Case: TypeSpecifierInt,
	// · · · Token: example.c:1:26: INT "int",
	// · · },
	// · },
	// }
}

func ExampleSpecifierQualifierList_attribute() {
	fmt.Println(exampleAST(148, "struct {__attribute__((a)) int i;};"))
	// Output:
	// &cc.SpecifierQualifierList{
	// · AttributeSpecifier: &cc.AttributeSpecifier{
	// · · AttributeValueList: &cc.AttributeValueList{
	// · · · AttributeValue: &cc.AttributeValue{
	// · · · · Case: AttributeValueIdent,
	// · · · · Token: example.c:1:24: IDENTIFIER "a",
	// · · · },
	// · · },
	// · · Token: example.c:1:9: ATTRIBUTE "__attribute__",
	// · · Token2: example.c:1:22: '(' "(",
	// · · Token3: example.c:1:23: '(' "(",
	// · · Token4: example.c:1:25: ')' ")",
	// · · Token5: example.c:1:26: ')' ")",
	// · },
	// · Case: SpecifierQualifierListAttribute,
	// · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · Case: SpecifierQualifierListTypeSpec,
	// · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · Case: TypeSpecifierInt,
	// · · · Token: example.c:1:28: INT "int",
	// · · },
	// · },
	// }
}

func ExampleStatement_labeled() {
	fmt.Println(exampleAST(211, "int f() { L: x(); }"))
	// Output:
	// &cc.Statement{
	// · Case: StatementLabeled,
	// · LabeledStatement: &cc.LabeledStatement{
	// · · Case: LabeledStatementLabel,
	// · · Statement: &cc.Statement{
	// · · · Case: StatementExpr,
	// · · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · · Expression: &cc.Expression{
	// · · · · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · · · · Case: AssignmentExpressionCond,
	// · · · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · · · Case: ConditionalExpressionLOr,
	// · · · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionCall,
	// · · · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · · · · Token: example.c:1:14: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · · Token: example.c:1:15: '(' "(",
	// · · · · · · · · · · · · · · · · · · · · Token2: example.c:1:16: ')' ")",
	// · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · · Case: ExpressionAssign,
	// · · · · },
	// · · · · Token: example.c:1:17: ';' ";",
	// · · · },
	// · · },
	// · · Token: example.c:1:11: IDENTIFIER "L",
	// · · Token2: example.c:1:12: ':' ":",
	// · },
	// }
}

func ExampleStatement_compound() {
	fmt.Println(exampleAST(212, "int f() { { y(); } }"))
	// Output:
	// &cc.Statement{
	// · Case: StatementCompound,
	// · CompoundStatement: &cc.CompoundStatement{
	// · · BlockItemList: &cc.BlockItemList{
	// · · · BlockItem: &cc.BlockItem{
	// · · · · Case: BlockItemStmt,
	// · · · · Statement: &cc.Statement{
	// · · · · · Case: StatementExpr,
	// · · · · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · · · · Expression: &cc.Expression{
	// · · · · · · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · · · · · · Case: AssignmentExpressionCond,
	// · · · · · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · · · · · Case: ConditionalExpressionLOr,
	// · · · · · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionCall,
	// · · · · · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · · · · · · Token: example.c:1:13: IDENTIFIER "y",
	// · · · · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · · · · Token: example.c:1:14: '(' "(",
	// · · · · · · · · · · · · · · · · · · · · · · Token2: example.c:1:15: ')' ")",
	// · · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExpressionAssign,
	// · · · · · · },
	// · · · · · · Token: example.c:1:16: ';' ";",
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Token: example.c:1:11: '{' "{",
	// · · Token2: example.c:1:18: '}' "}",
	// · },
	// }
}

func ExampleStatement_expr() {
	fmt.Println(exampleAST(213, "int f() { x(); }"))
	// Output:
	// &cc.Statement{
	// · Case: StatementExpr,
	// · ExpressionStatement: &cc.ExpressionStatement{
	// · · Expression: &cc.Expression{
	// · · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · · Case: AssignmentExpressionCond,
	// · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · Case: ConditionalExpressionLOr,
	// · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · Case: PostfixExpressionCall,
	// · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · · Token: example.c:1:11: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:12: '(' "(",
	// · · · · · · · · · · · · · · · · · · Token2: example.c:1:13: ')' ")",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Case: ExpressionAssign,
	// · · },
	// · · Token: example.c:1:14: ';' ";",
	// · },
	// }
}

func ExampleStatement_selection() {
	fmt.Println(exampleAST(214, "int f() { if(x) y(); }"))
	// Output:
	// &cc.Statement{
	// · Case: StatementSelection,
	// · SelectionStatement: &cc.SelectionStatement{
	// · · Case: SelectionStatementIf,
	// · · Expression: &cc.Expression{
	// · · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · · Case: AssignmentExpressionCond,
	// · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · Case: ConditionalExpressionLOr,
	// · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · Token: example.c:1:14: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Case: ExpressionAssign,
	// · · },
	// · · Statement: &cc.Statement{
	// · · · Case: StatementExpr,
	// · · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · · Expression: &cc.Expression{
	// · · · · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · · · · Case: AssignmentExpressionCond,
	// · · · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · · · Case: ConditionalExpressionLOr,
	// · · · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionCall,
	// · · · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · · · · Token: example.c:1:17: IDENTIFIER "y",
	// · · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · · Token: example.c:1:18: '(' "(",
	// · · · · · · · · · · · · · · · · · · · · Token2: example.c:1:19: ')' ")",
	// · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · · Case: ExpressionAssign,
	// · · · · },
	// · · · · Token: example.c:1:20: ';' ";",
	// · · · },
	// · · },
	// · · Token: example.c:1:11: IF "if",
	// · · Token2: example.c:1:13: '(' "(",
	// · · Token3: example.c:1:15: ')' ")",
	// · },
	// }
}

func ExampleStatement_iteration() {
	fmt.Println(exampleAST(215, "int f() { for(;;) x(); }"))
	// Output:
	// &cc.Statement{
	// · Case: StatementIteration,
	// · IterationStatement: &cc.IterationStatement{
	// · · Case: IterationStatementFor,
	// · · Statement: &cc.Statement{
	// · · · Case: StatementExpr,
	// · · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · · Expression: &cc.Expression{
	// · · · · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · · · · Case: AssignmentExpressionCond,
	// · · · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · · · Case: ConditionalExpressionLOr,
	// · · · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionCall,
	// · · · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · · · · Token: example.c:1:19: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · · Token: example.c:1:20: '(' "(",
	// · · · · · · · · · · · · · · · · · · · · Token2: example.c:1:21: ')' ")",
	// · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · · Case: ExpressionAssign,
	// · · · · },
	// · · · · Token: example.c:1:22: ';' ";",
	// · · · },
	// · · },
	// · · Token: example.c:1:11: FOR "for",
	// · · Token2: example.c:1:14: '(' "(",
	// · · Token3: example.c:1:15: ';' ";",
	// · · Token4: example.c:1:16: ';' ";",
	// · · Token5: example.c:1:17: ')' ")",
	// · },
	// }
}

func ExampleStatement_jump() {
	fmt.Println(exampleAST(216, "int f() { return x; }"))
	// Output:
	// &cc.Statement{
	// · Case: StatementJump,
	// · JumpStatement: &cc.JumpStatement{
	// · · Case: JumpStatementReturn,
	// · · Expression: &cc.Expression{
	// · · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · · Case: AssignmentExpressionCond,
	// · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · Case: ConditionalExpressionLOr,
	// · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · Token: example.c:1:18: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Case: ExpressionAssign,
	// · · },
	// · · Token: example.c:1:11: RETURN "return",
	// · · Token2: example.c:1:19: ';' ";",
	// · },
	// }
}

func ExampleStatement_asm() {
	fmt.Println(exampleAST(217, "int f() { __asm__(\"nop\"); }"))
	// Output:
	// &cc.Statement{
	// · AsmStatement: &cc.AsmStatement{
	// · · Asm: &cc.Asm{
	// · · · Token: example.c:1:11: ASM "__asm__",
	// · · · Token2: example.c:1:18: '(' "(",
	// · · · Token3: example.c:1:19: STRINGLITERAL "nop",
	// · · · Token4: example.c:1:24: ')' ")",
	// · · },
	// · · Token: example.c:1:25: ';' ";",
	// · },
	// · Case: StatementAsm,
	// }
}

func ExampleStorageClassSpecifier_typedef() {
	fmt.Println(exampleAST(97, "typedef int int_t;"))
	// Output:
	// &cc.StorageClassSpecifier{
	// · Case: StorageClassSpecifierTypedef,
	// · Token: example.c:1:1: TYPEDEF "typedef",
	// }
}

func ExampleStorageClassSpecifier_extern() {
	fmt.Println(exampleAST(98, "extern int i;"))
	// Output:
	// &cc.StorageClassSpecifier{
	// · Case: StorageClassSpecifierExtern,
	// · Token: example.c:1:1: EXTERN "extern",
	// }
}

func ExampleStorageClassSpecifier_static() {
	fmt.Println(exampleAST(99, "static int i;"))
	// Output:
	// &cc.StorageClassSpecifier{
	// · Case: StorageClassSpecifierStatic,
	// · Token: example.c:1:1: STATIC "static",
	// }
}

func ExampleStorageClassSpecifier_auto() {
	fmt.Println(exampleAST(100, "auto int i;"))
	// Output:
	// &cc.StorageClassSpecifier{
	// · Case: StorageClassSpecifierAuto,
	// · Token: example.c:1:1: AUTO "auto",
	// }
}

func ExampleStorageClassSpecifier_register() {
	fmt.Println(exampleAST(101, "register int i;"))
	// Output:
	// &cc.StorageClassSpecifier{
	// · Case: StorageClassSpecifierRegister,
	// · Token: example.c:1:1: REGISTER "register",
	// }
}

func ExampleStorageClassSpecifier_threadLocal() {
	fmt.Println(exampleAST(102, "_Thread_local int i;"))
	// Output:
	// &cc.StorageClassSpecifier{
	// · Case: StorageClassSpecifierThreadLocal,
	// · Token: example.c:1:1: THREADLOCAL "_Thread_local",
	// }
}

func ExampleStructDeclaration_case0() {
	fmt.Println(exampleAST(144, "struct{ int i; }"))
	// Output:
	// &cc.StructDeclaration{
	// · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · Case: SpecifierQualifierListTypeSpec,
	// · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · Case: TypeSpecifierInt,
	// · · · Token: example.c:1:9: INT "int",
	// · · },
	// · },
	// · StructDeclaratorList: &cc.StructDeclaratorList{
	// · · StructDeclarator: &cc.StructDeclarator{
	// · · · Case: StructDeclaratorDecl,
	// · · · Declarator: &cc.Declarator{
	// · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · Case: DirectDeclaratorIdent,
	// · · · · · Token: example.c:1:13: IDENTIFIER "i",
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: example.c:1:14: ';' ";",
	// }
}

func ExampleStructDeclarationList_case0() {
	fmt.Println(exampleAST(142, "struct{ int i; }"))
	// Output:
	// &cc.StructDeclarationList{
	// · StructDeclaration: &cc.StructDeclaration{
	// · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · Case: SpecifierQualifierListTypeSpec,
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Case: TypeSpecifierInt,
	// · · · · Token: example.c:1:9: INT "int",
	// · · · },
	// · · },
	// · · StructDeclaratorList: &cc.StructDeclaratorList{
	// · · · StructDeclarator: &cc.StructDeclarator{
	// · · · · Case: StructDeclaratorDecl,
	// · · · · Declarator: &cc.Declarator{
	// · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · Token: example.c:1:13: IDENTIFIER "i",
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Token: example.c:1:14: ';' ";",
	// · },
	// }
}

func ExampleStructDeclarationList_case1() {
	fmt.Println(exampleAST(143, "struct{ int i; double d; }"))
	// Output:
	// &cc.StructDeclarationList{
	// · StructDeclaration: &cc.StructDeclaration{
	// · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · Case: SpecifierQualifierListTypeSpec,
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Case: TypeSpecifierInt,
	// · · · · Token: example.c:1:9: INT "int",
	// · · · },
	// · · },
	// · · StructDeclaratorList: &cc.StructDeclaratorList{
	// · · · StructDeclarator: &cc.StructDeclarator{
	// · · · · Case: StructDeclaratorDecl,
	// · · · · Declarator: &cc.Declarator{
	// · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · Token: example.c:1:13: IDENTIFIER "i",
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Token: example.c:1:14: ';' ";",
	// · },
	// · StructDeclarationList: &cc.StructDeclarationList{
	// · · StructDeclaration: &cc.StructDeclaration{
	// · · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · · Case: SpecifierQualifierListTypeSpec,
	// · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · Case: TypeSpecifierDouble,
	// · · · · · Token: example.c:1:16: DOUBLE "double",
	// · · · · },
	// · · · },
	// · · · StructDeclaratorList: &cc.StructDeclaratorList{
	// · · · · StructDeclarator: &cc.StructDeclarator{
	// · · · · · Case: StructDeclaratorDecl,
	// · · · · · Declarator: &cc.Declarator{
	// · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · · Token: example.c:1:23: IDENTIFIER "d",
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Token: example.c:1:24: ';' ";",
	// · · },
	// · },
	// }
}

func ExampleStructDeclarator_decl() {
	fmt.Println(exampleAST(151, "struct{ int i; }"))
	// Output:
	// &cc.StructDeclarator{
	// · Case: StructDeclaratorDecl,
	// · Declarator: &cc.Declarator{
	// · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · Case: DirectDeclaratorIdent,
	// · · · Token: example.c:1:13: IDENTIFIER "i",
	// · · },
	// · },
	// }
}

func ExampleStructDeclarator_bitField() {
	fmt.Println(exampleAST(152, "struct{ int i:3; }"))
	// Output:
	// &cc.StructDeclarator{
	// · Case: StructDeclaratorBitField,
	// · ConstantExpression: &cc.ConstantExpression{
	// · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · Case: ConditionalExpressionLOr,
	// · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · Case: LogicalOrExpressionLAnd,
	// · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · Case: LogicalAndExpressionOr,
	// · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · Token: example.c:1:15: INTCONST "3",
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Declarator: &cc.Declarator{
	// · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · Case: DirectDeclaratorIdent,
	// · · · Token: example.c:1:13: IDENTIFIER "i",
	// · · },
	// · },
	// · Token: example.c:1:14: ':' ":",
	// }
}

func ExampleStructDeclaratorList_case0() {
	fmt.Println(exampleAST(149, "struct{ int i; }"))
	// Output:
	// &cc.StructDeclaratorList{
	// · StructDeclarator: &cc.StructDeclarator{
	// · · Case: StructDeclaratorDecl,
	// · · Declarator: &cc.Declarator{
	// · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · Case: DirectDeclaratorIdent,
	// · · · · Token: example.c:1:13: IDENTIFIER "i",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleStructDeclaratorList_case1() {
	fmt.Println(exampleAST(150, "struct{ int i, j; }"))
	// Output:
	// &cc.StructDeclaratorList{
	// · StructDeclarator: &cc.StructDeclarator{
	// · · Case: StructDeclaratorDecl,
	// · · Declarator: &cc.Declarator{
	// · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · Case: DirectDeclaratorIdent,
	// · · · · Token: example.c:1:13: IDENTIFIER "i",
	// · · · },
	// · · },
	// · },
	// · StructDeclaratorList: &cc.StructDeclaratorList{
	// · · StructDeclarator: &cc.StructDeclarator{
	// · · · Case: StructDeclaratorDecl,
	// · · · Declarator: &cc.Declarator{
	// · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · Case: DirectDeclaratorIdent,
	// · · · · · Token: example.c:1:16: IDENTIFIER "j",
	// · · · · },
	// · · · },
	// · · },
	// · · Token: example.c:1:14: ',' ",",
	// · },
	// }
}

func ExampleStructOrUnion_struct() {
	fmt.Println(exampleAST(140, "struct { int i; } s;"))
	// Output:
	// &cc.StructOrUnion{
	// · Case: StructOrUnionStruct,
	// · Token: example.c:1:1: STRUCT "struct",
	// }
}

func ExampleStructOrUnion_union() {
	fmt.Println(exampleAST(141, "union { int i; double d; } u;"))
	// Output:
	// &cc.StructOrUnion{
	// · Case: StructOrUnionUnion,
	// · Token: example.c:1:1: UNION "union",
	// }
}

func ExampleStructOrUnionSpecifier_def() {
	fmt.Println(exampleAST(138, "struct s { int i; };"))
	// Output:
	// &cc.StructOrUnionSpecifier{
	// · Case: StructOrUnionSpecifierDef,
	// · StructDeclarationList: &cc.StructDeclarationList{
	// · · StructDeclaration: &cc.StructDeclaration{
	// · · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · · Case: SpecifierQualifierListTypeSpec,
	// · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · Case: TypeSpecifierInt,
	// · · · · · Token: example.c:1:12: INT "int",
	// · · · · },
	// · · · },
	// · · · StructDeclaratorList: &cc.StructDeclaratorList{
	// · · · · StructDeclarator: &cc.StructDeclarator{
	// · · · · · Case: StructDeclaratorDecl,
	// · · · · · Declarator: &cc.Declarator{
	// · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · · Token: example.c:1:16: IDENTIFIER "i",
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Token: example.c:1:17: ';' ";",
	// · · },
	// · },
	// · StructOrUnion: &cc.StructOrUnion{
	// · · Case: StructOrUnionStruct,
	// · · Token: example.c:1:1: STRUCT "struct",
	// · },
	// · Token: example.c:1:8: IDENTIFIER "s",
	// · Token2: example.c:1:10: '{' "{",
	// · Token3: example.c:1:19: '}' "}",
	// }
}

func ExampleStructOrUnionSpecifier_tag() {
	fmt.Println(exampleAST(139, "struct s v;"))
	// Output:
	// &cc.StructOrUnionSpecifier{
	// · Case: StructOrUnionSpecifierTag,
	// · StructOrUnion: &cc.StructOrUnion{
	// · · Case: StructOrUnionStruct,
	// · · Token: example.c:1:1: STRUCT "struct",
	// · },
	// · Token: example.c:1:8: IDENTIFIER "s",
	// }
}

func ExampleTranslationUnit_case0() {
	fmt.Println(exampleAST(243, "int i;"))
	// Output:
	// &cc.TranslationUnit{
	// · ExternalDeclaration: &cc.ExternalDeclaration{
	// · · Case: ExternalDeclarationDecl,
	// · · Declaration: &cc.Declaration{
	// · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · Case: DeclarationSpecifiersTypeSpec,
	// · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · Case: TypeSpecifierInt,
	// · · · · · Token: example.c:1:1: INT "int",
	// · · · · },
	// · · · },
	// · · · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · · · InitDeclarator: &cc.InitDeclarator{
	// · · · · · Case: InitDeclaratorDecl,
	// · · · · · Declarator: &cc.Declarator{
	// · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · · Token: example.c:1:5: IDENTIFIER "i",
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Token: example.c:1:6: ';' ";",
	// · · },
	// · },
	// }
}

func ExampleTranslationUnit_case1() {
	fmt.Println(exampleAST(244, "int i; int j;"))
	// Output:
	// &cc.TranslationUnit{
	// · ExternalDeclaration: &cc.ExternalDeclaration{
	// · · Case: ExternalDeclarationDecl,
	// · · Declaration: &cc.Declaration{
	// · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · Case: DeclarationSpecifiersTypeSpec,
	// · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · Case: TypeSpecifierInt,
	// · · · · · Token: example.c:1:1: INT "int",
	// · · · · },
	// · · · },
	// · · · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · · · InitDeclarator: &cc.InitDeclarator{
	// · · · · · Case: InitDeclaratorDecl,
	// · · · · · Declarator: &cc.Declarator{
	// · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · · Token: example.c:1:5: IDENTIFIER "i",
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Token: example.c:1:6: ';' ";",
	// · · },
	// · },
	// · TranslationUnit: &cc.TranslationUnit{
	// · · ExternalDeclaration: &cc.ExternalDeclaration{
	// · · · Case: ExternalDeclarationDecl,
	// · · · Declaration: &cc.Declaration{
	// · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · Case: DeclarationSpecifiersTypeSpec,
	// · · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · · Case: TypeSpecifierInt,
	// · · · · · · Token: example.c:1:8: INT "int",
	// · · · · · },
	// · · · · },
	// · · · · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · · · · InitDeclarator: &cc.InitDeclarator{
	// · · · · · · Case: InitDeclaratorDecl,
	// · · · · · · Declarator: &cc.Declarator{
	// · · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · · · Token: example.c:1:12: IDENTIFIER "j",
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · · Token: example.c:1:13: ';' ";",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleTypeName_case0() {
	fmt.Println(exampleAST(192, "int i = (int)x;"))
	// Output:
	// &cc.TypeName{
	// · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · Case: SpecifierQualifierListTypeSpec,
	// · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · Case: TypeSpecifierInt,
	// · · · Token: example.c:1:10: INT "int",
	// · · },
	// · },
	// }
}

func ExampleTypeQualifier_const() {
	fmt.Println(exampleAST(160, "const int i;"))
	// Output:
	// &cc.TypeQualifier{
	// · Case: TypeQualifierConst,
	// · Token: example.c:1:1: CONST "const",
	// }
}

func ExampleTypeQualifier_restrict() {
	fmt.Println(exampleAST(161, "restrict int i;"))
	// Output:
	// &cc.TypeQualifier{
	// · Case: TypeQualifierRestrict,
	// · Token: example.c:1:1: RESTRICT "restrict",
	// }
}

func ExampleTypeQualifier_volatile() {
	fmt.Println(exampleAST(162, "volatile int i;"))
	// Output:
	// &cc.TypeQualifier{
	// · Case: TypeQualifierVolatile,
	// · Token: example.c:1:1: VOLATILE "volatile",
	// }
}

func ExampleTypeQualifier_atomic() {
	fmt.Println(exampleAST(163, "_Atomic int i;"))
	// Output:
	// &cc.TypeQualifier{
	// · Case: TypeQualifierAtomic,
	// · Token: example.c:1:1: ATOMIC "_Atomic",
	// }
}

func ExampleTypeQualifiers_typeQual() {
	fmt.Println(exampleAST(180, "int * const i;"))
	// Output:
	// &cc.TypeQualifiers{
	// · Case: TypeQualifiersTypeQual,
	// · TypeQualifier: &cc.TypeQualifier{
	// · · Case: TypeQualifierConst,
	// · · Token: example.c:1:7: CONST "const",
	// · },
	// }
}

func ExampleTypeQualifiers_attribute() {
	fmt.Println(exampleAST(181, "int * __attribute__((a)) i;"))
	// Output:
	// &cc.TypeQualifiers{
	// · AttributeSpecifier: &cc.AttributeSpecifier{
	// · · AttributeValueList: &cc.AttributeValueList{
	// · · · AttributeValue: &cc.AttributeValue{
	// · · · · Case: AttributeValueIdent,
	// · · · · Token: example.c:1:22: IDENTIFIER "a",
	// · · · },
	// · · },
	// · · Token: example.c:1:7: ATTRIBUTE "__attribute__",
	// · · Token2: example.c:1:20: '(' "(",
	// · · Token3: example.c:1:21: '(' "(",
	// · · Token4: example.c:1:23: ')' ")",
	// · · Token5: example.c:1:24: ')' ")",
	// · },
	// · Case: TypeQualifiersAttribute,
	// }
}

func ExampleTypeQualifiers_case2() {
	fmt.Println(exampleAST(182, "int * const volatile i;"))
	// Output:
	// &cc.TypeQualifiers{
	// · Case: TypeQualifiersTypeQual,
	// · TypeQualifier: &cc.TypeQualifier{
	// · · Case: TypeQualifierConst,
	// · · Token: example.c:1:7: CONST "const",
	// · },
	// · TypeQualifiers: &cc.TypeQualifiers{
	// · · Case: TypeQualifiersTypeQual,
	// · · TypeQualifier: &cc.TypeQualifier{
	// · · · Case: TypeQualifierVolatile,
	// · · · Token: example.c:1:13: VOLATILE "volatile",
	// · · },
	// · },
	// }
}

func ExampleTypeQualifiers_case3() {
	fmt.Println(exampleAST(183, "int * __attribute__((a)) __attribute__((b)) i;"))
	// Output:
	// &cc.TypeQualifiers{
	// · AttributeSpecifier: &cc.AttributeSpecifier{
	// · · AttributeValueList: &cc.AttributeValueList{
	// · · · AttributeValue: &cc.AttributeValue{
	// · · · · Case: AttributeValueIdent,
	// · · · · Token: example.c:1:22: IDENTIFIER "a",
	// · · · },
	// · · },
	// · · Token: example.c:1:7: ATTRIBUTE "__attribute__",
	// · · Token2: example.c:1:20: '(' "(",
	// · · Token3: example.c:1:21: '(' "(",
	// · · Token4: example.c:1:23: ')' ")",
	// · · Token5: example.c:1:24: ')' ")",
	// · },
	// · Case: TypeQualifiersAttribute,
	// · TypeQualifiers: &cc.TypeQualifiers{
	// · · AttributeSpecifier: &cc.AttributeSpecifier{
	// · · · AttributeValueList: &cc.AttributeValueList{
	// · · · · AttributeValue: &cc.AttributeValue{
	// · · · · · Case: AttributeValueIdent,
	// · · · · · Token: example.c:1:41: IDENTIFIER "b",
	// · · · · },
	// · · · },
	// · · · Token: example.c:1:26: ATTRIBUTE "__attribute__",
	// · · · Token2: example.c:1:39: '(' "(",
	// · · · Token3: example.c:1:40: '(' "(",
	// · · · Token4: example.c:1:42: ')' ")",
	// · · · Token5: example.c:1:43: ')' ")",
	// · · },
	// · · Case: TypeQualifiersAttribute,
	// · },
	// }
}

func ExampleTypeSpecifier_void() {
	fmt.Println(exampleAST(103, "void i();"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierVoid,
	// · Token: example.c:1:1: VOID "void",
	// }
}

func ExampleTypeSpecifier_char() {
	fmt.Println(exampleAST(104, "char i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierChar,
	// · Token: example.c:1:1: CHAR "char",
	// }
}

func ExampleTypeSpecifier_short() {
	fmt.Println(exampleAST(105, "short i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierShort,
	// · Token: example.c:1:1: SHORT "short",
	// }
}

func ExampleTypeSpecifier_int() {
	fmt.Println(exampleAST(106, "int i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierInt,
	// · Token: example.c:1:1: INT "int",
	// }
}

func ExampleTypeSpecifier_int8() {
	fmt.Println(exampleAST(107, "__int8 i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierInt8,
	// · Token: example.c:1:1: INT8 "__int8",
	// }
}

func ExampleTypeSpecifier_int16() {
	fmt.Println(exampleAST(108, "__int16 i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierInt16,
	// · Token: example.c:1:1: INT16 "__int16",
	// }
}

func ExampleTypeSpecifier_int32() {
	fmt.Println(exampleAST(109, "__int32 i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierInt32,
	// · Token: example.c:1:1: INT32 "__int32",
	// }
}

func ExampleTypeSpecifier_int64() {
	fmt.Println(exampleAST(110, "__int64 i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierInt64,
	// · Token: example.c:1:1: INT64 "__int64",
	// }
}

func ExampleTypeSpecifier_int128() {
	fmt.Println(exampleAST(111, "__int128 i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierInt128,
	// · Token: example.c:1:1: INT128 "__int128",
	// }
}

func ExampleTypeSpecifier_long() {
	fmt.Println(exampleAST(112, "long i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierLong,
	// · Token: example.c:1:1: LONG "long",
	// }
}

func ExampleTypeSpecifier_float() {
	fmt.Println(exampleAST(113, "float i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierFloat,
	// · Token: example.c:1:1: FLOAT "float",
	// }
}

func ExampleTypeSpecifier_float16() {
	fmt.Println(exampleAST(114, "__fp16 i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierFloat16,
	// · Token: example.c:1:1: FLOAT16 "__fp16",
	// }
}

func ExampleTypeSpecifier_decimal32() {
	fmt.Println(exampleAST(115, "_Decimal32 i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierDecimal32,
	// · Token: example.c:1:1: DECIMAL32 "_Decimal32",
	// }
}

func ExampleTypeSpecifier_decimal64() {
	fmt.Println(exampleAST(116, "_Decimal64 i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierDecimal64,
	// · Token: example.c:1:1: DECIMAL64 "_Decimal64",
	// }
}

func ExampleTypeSpecifier_decimal128() {
	fmt.Println(exampleAST(117, "_Decimal128 i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierDecimal128,
	// · Token: example.c:1:1: DECIMAL128 "_Decimal128",
	// }
}

func ExampleTypeSpecifier_float128() {
	fmt.Println(exampleAST(118, "_Float128 i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierFloat128,
	// · Token: example.c:1:1: FLOAT128 "_Float128",
	// }
}

func ExampleTypeSpecifier_float80() {
	fmt.Println(exampleAST(119, "__float80 i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierFloat80,
	// · Token: example.c:1:1: FLOAT80 "__float80",
	// }
}

func ExampleTypeSpecifier_double() {
	fmt.Println(exampleAST(120, "double i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierDouble,
	// · Token: example.c:1:1: DOUBLE "double",
	// }
}

func ExampleTypeSpecifier_signed() {
	fmt.Println(exampleAST(121, "signed i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierSigned,
	// · Token: example.c:1:1: SIGNED "signed",
	// }
}

func ExampleTypeSpecifier_unsigned() {
	fmt.Println(exampleAST(122, "unsigned i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierUnsigned,
	// · Token: example.c:1:1: UNSIGNED "unsigned",
	// }
}

func ExampleTypeSpecifier_bool() {
	fmt.Println(exampleAST(123, "_Bool i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierBool,
	// · Token: example.c:1:1: BOOL "_Bool",
	// }
}

func ExampleTypeSpecifier_complex() {
	fmt.Println(exampleAST(124, "_Complex i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierComplex,
	// · Token: example.c:1:1: COMPLEX "_Complex",
	// }
}

func ExampleTypeSpecifier_structOrUnion() {
	fmt.Println(exampleAST(125, "struct s i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierStructOrUnion,
	// · StructOrUnionSpecifier: &cc.StructOrUnionSpecifier{
	// · · Case: StructOrUnionSpecifierTag,
	// · · StructOrUnion: &cc.StructOrUnion{
	// · · · Case: StructOrUnionStruct,
	// · · · Token: example.c:1:1: STRUCT "struct",
	// · · },
	// · · Token: example.c:1:8: IDENTIFIER "s",
	// · },
	// }
}

func ExampleTypeSpecifier_enum() {
	fmt.Println(exampleAST(126, "enum e i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierEnum,
	// · EnumSpecifier: &cc.EnumSpecifier{
	// · · Case: EnumSpecifierTag,
	// · · Token: example.c:1:1: ENUM "enum",
	// · · Token2: example.c:1:6: IDENTIFIER "e",
	// · },
	// }
}

func ExampleTypeSpecifier_typedefName() {
	fmt.Println(exampleAST(127, "typedef const T; T i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierTypedefName,
	// · Token: example.c:1:18: TYPEDEFNAME "T",
	// }
}

func ExampleTypeSpecifier_typeofExpr() {
	fmt.Println(exampleAST(128, "typeof(42) i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierTypeofExpr,
	// · Expression: &cc.Expression{
	// · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · Case: AssignmentExpressionCond,
	// · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · Case: ConditionalExpressionLOr,
	// · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionInt,
	// · · · · · · · · · · · · · · · · · · Token: example.c:1:8: INTCONST "42",
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Case: ExpressionAssign,
	// · },
	// · Token: example.c:1:1: TYPEOF "typeof",
	// · Token2: example.c:1:7: '(' "(",
	// · Token3: example.c:1:10: ')' ")",
	// }
}

func ExampleTypeSpecifier_typeofType() {
	fmt.Println(exampleAST(129, "typedef const T; typeof(T) i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierTypeofType,
	// · Token: example.c:1:18: TYPEOF "typeof",
	// · Token2: example.c:1:24: '(' "(",
	// · Token3: example.c:1:26: ')' ")",
	// · TypeName: &cc.TypeName{
	// · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · Case: SpecifierQualifierListTypeSpec,
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Case: TypeSpecifierTypedefName,
	// · · · · Token: example.c:1:25: TYPEDEFNAME "T",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleTypeSpecifier_atomic() {
	fmt.Println(exampleAST(130, "_Atomic(int) i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · AtomicTypeSpecifier: &cc.AtomicTypeSpecifier{
	// · · Token: example.c:1:1: ATOMIC "_Atomic",
	// · · Token2: example.c:1:8: '(' "(",
	// · · Token3: example.c:1:12: ')' ")",
	// · · TypeName: &cc.TypeName{
	// · · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · · Case: SpecifierQualifierListTypeSpec,
	// · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · Case: TypeSpecifierInt,
	// · · · · · Token: example.c:1:9: INT "int",
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Case: TypeSpecifierAtomic,
	// }
}

func ExampleTypeSpecifier_fract() {
	fmt.Println(exampleAST(131, "_Fract i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierFract,
	// · Token: example.c:1:1: FRACT "_Fract",
	// }
}

func ExampleTypeSpecifier_sat() {
	fmt.Println(exampleAST(132, "_Sat i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierSat,
	// · Token: example.c:1:1: SAT "_Sat",
	// }
}

func ExampleTypeSpecifier_accum() {
	fmt.Println(exampleAST(133, "_Accum i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierAccum,
	// · Token: example.c:1:1: ACCUM "_Accum",
	// }
}

func ExampleTypeSpecifier_float32() {
	fmt.Println(exampleAST(134, "_Float32 i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierFloat32,
	// · Token: example.c:1:1: FLOAT32 "_Float32",
	// }
}

func ExampleTypeSpecifier_float64() {
	fmt.Println(exampleAST(135, "_Float64 i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierFloat64,
	// · Token: example.c:1:1: FLOAT64 "_Float64",
	// }
}

func ExampleTypeSpecifier_float32x() {
	fmt.Println(exampleAST(136, "_Float32x i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierFloat32x,
	// · Token: example.c:1:1: FLOAT32X "_Float32x",
	// }
}

func ExampleTypeSpecifier_float64x() {
	fmt.Println(exampleAST(137, "_Float64x i;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: TypeSpecifierFloat64x,
	// · Token: example.c:1:1: FLOAT64X "_Float64x",
	// }
}

func ExampleUnaryExpression_postfix() {
	fmt.Println(exampleAST(23, "int i = x;"))
	// Output:
	// &cc.UnaryExpression{
	// · Case: UnaryExpressionPostfix,
	// · PostfixExpression: &cc.PostfixExpression{
	// · · Case: PostfixExpressionPrimary,
	// · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · Case: PrimaryExpressionIdent,
	// · · · Token: example.c:1:9: IDENTIFIER "x",
	// · · },
	// · },
	// }
}

func ExampleUnaryExpression_inc() {
	fmt.Println(exampleAST(24, "int i = ++x;"))
	// Output:
	// &cc.UnaryExpression{
	// · Case: UnaryExpressionInc,
	// · Token: example.c:1:9: INC "++",
	// · UnaryExpression: &cc.UnaryExpression{
	// · · Case: UnaryExpressionPostfix,
	// · · PostfixExpression: &cc.PostfixExpression{
	// · · · Case: PostfixExpressionPrimary,
	// · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · Case: PrimaryExpressionIdent,
	// · · · · Token: example.c:1:11: IDENTIFIER "x",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleUnaryExpression_dec() {
	fmt.Println(exampleAST(25, "int i = --x;"))
	// Output:
	// &cc.UnaryExpression{
	// · Case: UnaryExpressionDec,
	// · Token: example.c:1:9: DEC "--",
	// · UnaryExpression: &cc.UnaryExpression{
	// · · Case: UnaryExpressionPostfix,
	// · · PostfixExpression: &cc.PostfixExpression{
	// · · · Case: PostfixExpressionPrimary,
	// · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · Case: PrimaryExpressionIdent,
	// · · · · Token: example.c:1:11: IDENTIFIER "x",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleUnaryExpression_addrof() {
	fmt.Println(exampleAST(26, "int *i = &x;"))
	// Output:
	// &cc.UnaryExpression{
	// · Case: UnaryExpressionAddrof,
	// · CastExpression: &cc.CastExpression{
	// · · Case: CastExpressionUnary,
	// · · UnaryExpression: &cc.UnaryExpression{
	// · · · Case: UnaryExpressionPostfix,
	// · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · Case: PostfixExpressionPrimary,
	// · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · Case: PrimaryExpressionIdent,
	// · · · · · Token: example.c:1:11: IDENTIFIER "x",
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: example.c:1:10: '&' "&",
	// }
}

func ExampleUnaryExpression_deref() {
	fmt.Println(exampleAST(27, "int i = *x;"))
	// Output:
	// &cc.UnaryExpression{
	// · Case: UnaryExpressionDeref,
	// · CastExpression: &cc.CastExpression{
	// · · Case: CastExpressionUnary,
	// · · UnaryExpression: &cc.UnaryExpression{
	// · · · Case: UnaryExpressionPostfix,
	// · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · Case: PostfixExpressionPrimary,
	// · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · Case: PrimaryExpressionIdent,
	// · · · · · Token: example.c:1:10: IDENTIFIER "x",
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: example.c:1:9: '*' "*",
	// }
}

func ExampleUnaryExpression_plus() {
	fmt.Println(exampleAST(28, "int i = +x;"))
	// Output:
	// &cc.UnaryExpression{
	// · Case: UnaryExpressionPlus,
	// · CastExpression: &cc.CastExpression{
	// · · Case: CastExpressionUnary,
	// · · UnaryExpression: &cc.UnaryExpression{
	// · · · Case: UnaryExpressionPostfix,
	// · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · Case: PostfixExpressionPrimary,
	// · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · Case: PrimaryExpressionIdent,
	// · · · · · Token: example.c:1:10: IDENTIFIER "x",
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: example.c:1:9: '+' "+",
	// }
}

func ExampleUnaryExpression_minus() {
	fmt.Println(exampleAST(29, "int i = -x;"))
	// Output:
	// &cc.UnaryExpression{
	// · Case: UnaryExpressionMinus,
	// · CastExpression: &cc.CastExpression{
	// · · Case: CastExpressionUnary,
	// · · UnaryExpression: &cc.UnaryExpression{
	// · · · Case: UnaryExpressionPostfix,
	// · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · Case: PostfixExpressionPrimary,
	// · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · Case: PrimaryExpressionIdent,
	// · · · · · Token: example.c:1:10: IDENTIFIER "x",
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: example.c:1:9: '-' "-",
	// }
}

func ExampleUnaryExpression_cpl() {
	fmt.Println(exampleAST(30, "int i = ~x;"))
	// Output:
	// &cc.UnaryExpression{
	// · Case: UnaryExpressionCpl,
	// · CastExpression: &cc.CastExpression{
	// · · Case: CastExpressionUnary,
	// · · UnaryExpression: &cc.UnaryExpression{
	// · · · Case: UnaryExpressionPostfix,
	// · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · Case: PostfixExpressionPrimary,
	// · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · Case: PrimaryExpressionIdent,
	// · · · · · Token: example.c:1:10: IDENTIFIER "x",
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: example.c:1:9: '~' "~",
	// }
}

func ExampleUnaryExpression_not() {
	fmt.Println(exampleAST(31, "int i = !x;"))
	// Output:
	// &cc.UnaryExpression{
	// · Case: UnaryExpressionNot,
	// · CastExpression: &cc.CastExpression{
	// · · Case: CastExpressionUnary,
	// · · UnaryExpression: &cc.UnaryExpression{
	// · · · Case: UnaryExpressionPostfix,
	// · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · Case: PostfixExpressionPrimary,
	// · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · Case: PrimaryExpressionIdent,
	// · · · · · Token: example.c:1:10: IDENTIFIER "x",
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: example.c:1:9: '!' "!",
	// }
}

func ExampleUnaryExpression_sizeofExpr() {
	fmt.Println(exampleAST(32, "int i = sizeof x;"))
	// Output:
	// &cc.UnaryExpression{
	// · Case: UnaryExpressionSizeofExpr,
	// · Token: example.c:1:9: SIZEOF "sizeof",
	// · UnaryExpression: &cc.UnaryExpression{
	// · · Case: UnaryExpressionPostfix,
	// · · PostfixExpression: &cc.PostfixExpression{
	// · · · Case: PostfixExpressionPrimary,
	// · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · Case: PrimaryExpressionIdent,
	// · · · · Token: example.c:1:16: IDENTIFIER "x",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleUnaryExpression_sizeofType() {
	fmt.Println(exampleAST(33, "int i = sizeof(int);"))
	// Output:
	// &cc.UnaryExpression{
	// · Case: UnaryExpressionSizeofType,
	// · Token: example.c:1:9: SIZEOF "sizeof",
	// · Token2: example.c:1:15: '(' "(",
	// · Token3: example.c:1:19: ')' ")",
	// · TypeName: &cc.TypeName{
	// · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · Case: SpecifierQualifierListTypeSpec,
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Case: TypeSpecifierInt,
	// · · · · Token: example.c:1:16: INT "int",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleUnaryExpression_labelAddr() {
	fmt.Println(exampleAST(34, "int f() { L: &&L; }"))
	// Output:
	// &cc.UnaryExpression{
	// · Case: UnaryExpressionLabelAddr,
	// · Token: example.c:1:14: ANDAND "&&",
	// · Token2: example.c:1:16: IDENTIFIER "L",
	// }
}

func ExampleUnaryExpression_alignofExpr() {
	fmt.Println(exampleAST(35, "int i = _Alignof(x);"))
	// Output:
	// &cc.UnaryExpression{
	// · Case: UnaryExpressionAlignofExpr,
	// · Token: example.c:1:9: ALIGNOF "_Alignof",
	// · UnaryExpression: &cc.UnaryExpression{
	// · · Case: UnaryExpressionPostfix,
	// · · PostfixExpression: &cc.PostfixExpression{
	// · · · Case: PostfixExpressionPrimary,
	// · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · Case: PrimaryExpressionExpr,
	// · · · · Expression: &cc.Expression{
	// · · · · · AssignmentExpression: &cc.AssignmentExpression{
	// · · · · · · Case: AssignmentExpressionCond,
	// · · · · · · ConditionalExpression: &cc.ConditionalExpression{
	// · · · · · · · Case: ConditionalExpressionLOr,
	// · · · · · · · LogicalOrExpression: &cc.LogicalOrExpression{
	// · · · · · · · · Case: LogicalOrExpressionLAnd,
	// · · · · · · · · LogicalAndExpression: &cc.LogicalAndExpression{
	// · · · · · · · · · Case: LogicalAndExpressionOr,
	// · · · · · · · · · InclusiveOrExpression: &cc.InclusiveOrExpression{
	// · · · · · · · · · · Case: InclusiveOrExpressionXor,
	// · · · · · · · · · · ExclusiveOrExpression: &cc.ExclusiveOrExpression{
	// · · · · · · · · · · · AndExpression: &cc.AndExpression{
	// · · · · · · · · · · · · Case: AndExpressionEq,
	// · · · · · · · · · · · · EqualityExpression: &cc.EqualityExpression{
	// · · · · · · · · · · · · · Case: EqualityExpressionRel,
	// · · · · · · · · · · · · · RelationalExpression: &cc.RelationalExpression{
	// · · · · · · · · · · · · · · Case: RelationalExpressionShift,
	// · · · · · · · · · · · · · · ShiftExpression: &cc.ShiftExpression{
	// · · · · · · · · · · · · · · · AdditiveExpression: &cc.AdditiveExpression{
	// · · · · · · · · · · · · · · · · Case: AdditiveExpressionMul,
	// · · · · · · · · · · · · · · · · MultiplicativeExpression: &cc.MultiplicativeExpression{
	// · · · · · · · · · · · · · · · · · Case: MultiplicativeExpressionCast,
	// · · · · · · · · · · · · · · · · · CastExpression: &cc.CastExpression{
	// · · · · · · · · · · · · · · · · · · Case: CastExpressionUnary,
	// · · · · · · · · · · · · · · · · · · UnaryExpression: &cc.UnaryExpression{
	// · · · · · · · · · · · · · · · · · · · Case: UnaryExpressionPostfix,
	// · · · · · · · · · · · · · · · · · · · PostfixExpression: &cc.PostfixExpression{
	// · · · · · · · · · · · · · · · · · · · · Case: PostfixExpressionPrimary,
	// · · · · · · · · · · · · · · · · · · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · · · · · · · · · · · · · · · · · · Case: PrimaryExpressionIdent,
	// · · · · · · · · · · · · · · · · · · · · · Token: example.c:1:18: IDENTIFIER "x",
	// · · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · · · Case: ShiftExpressionAdd,
	// · · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Case: ExclusiveOrExpressionAnd,
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · · Case: ExpressionAssign,
	// · · · · },
	// · · · · Token: example.c:1:17: '(' "(",
	// · · · · Token2: example.c:1:19: ')' ")",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleUnaryExpression_alignofType() {
	fmt.Println(exampleAST(36, "int i = _Alignof(int);"))
	// Output:
	// &cc.UnaryExpression{
	// · Case: UnaryExpressionAlignofType,
	// · Token: example.c:1:9: ALIGNOF "_Alignof",
	// · Token2: example.c:1:17: '(' "(",
	// · Token3: example.c:1:17: '(' "(",
	// · TypeName: &cc.TypeName{
	// · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · Case: SpecifierQualifierListTypeSpec,
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Case: TypeSpecifierInt,
	// · · · · Token: example.c:1:18: INT "int",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleUnaryExpression_imag() {
	fmt.Println(exampleAST(37, "double i = __imag__ x;"))
	// Output:
	// &cc.UnaryExpression{
	// · Case: UnaryExpressionImag,
	// · Token: example.c:1:12: IMAG "__imag__",
	// · UnaryExpression: &cc.UnaryExpression{
	// · · Case: UnaryExpressionPostfix,
	// · · PostfixExpression: &cc.PostfixExpression{
	// · · · Case: PostfixExpressionPrimary,
	// · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · Case: PrimaryExpressionIdent,
	// · · · · Token: example.c:1:21: IDENTIFIER "x",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleUnaryExpression_real() {
	fmt.Println(exampleAST(38, "double i = __real__ x;"))
	// Output:
	// &cc.UnaryExpression{
	// · Case: UnaryExpressionReal,
	// · Token: example.c:1:12: REAL "__real__",
	// · UnaryExpression: &cc.UnaryExpression{
	// · · Case: UnaryExpressionPostfix,
	// · · PostfixExpression: &cc.PostfixExpression{
	// · · · Case: PostfixExpressionPrimary,
	// · · · PrimaryExpression: &cc.PrimaryExpression{
	// · · · · Case: PrimaryExpressionIdent,
	// · · · · Token: example.c:1:21: IDENTIFIER "x",
	// · · · },
	// · · },
	// · },
	// }
}
