// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/connectors/v1/connection.proto

package connectors

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// All possible data types of a entity or action field.
type DataType int32

const (
	// Data type is not specified.
	DataType_DATA_TYPE_UNSPECIFIED DataType = 0
	// DEPRECATED! Use DATA_TYPE_INTEGER.
	//
	// Deprecated: Do not use.
	DataType_DATA_TYPE_INT DataType = 1
	// Short integer(int16) data type.
	DataType_DATA_TYPE_SMALLINT DataType = 2
	// Double data type.
	DataType_DATA_TYPE_DOUBLE DataType = 3
	// Date data type.
	DataType_DATA_TYPE_DATE DataType = 4
	// DEPRECATED! Use DATA_TYPE_TIMESTAMP.
	//
	// Deprecated: Do not use.
	DataType_DATA_TYPE_DATETIME DataType = 5
	// Time data type.
	DataType_DATA_TYPE_TIME DataType = 6
	// DEPRECATED! Use DATA_TYPE_VARCHAR.
	//
	// Deprecated: Do not use.
	DataType_DATA_TYPE_STRING DataType = 7
	// DEPRECATED! Use DATA_TYPE_BIGINT.
	//
	// Deprecated: Do not use.
	DataType_DATA_TYPE_LONG DataType = 8
	// Boolean data type.
	DataType_DATA_TYPE_BOOLEAN DataType = 9
	// Decimal data type.
	DataType_DATA_TYPE_DECIMAL DataType = 10
	// DEPRECATED! Use DATA_TYPE_VARCHAR.
	//
	// Deprecated: Do not use.
	DataType_DATA_TYPE_UUID DataType = 11
	// UNSUPPORTED! Binary data type.
	DataType_DATA_TYPE_BLOB DataType = 12
	// Bit data type.
	DataType_DATA_TYPE_BIT DataType = 13
	// Small integer(int8) data type.
	DataType_DATA_TYPE_TINYINT DataType = 14
	// Integer(int32) data type.
	DataType_DATA_TYPE_INTEGER DataType = 15
	// Long integer(int64) data type.
	DataType_DATA_TYPE_BIGINT DataType = 16
	// Float data type.
	DataType_DATA_TYPE_FLOAT DataType = 17
	// Real data type.
	DataType_DATA_TYPE_REAL DataType = 18
	// Numeric data type.
	DataType_DATA_TYPE_NUMERIC DataType = 19
	// Char data type.
	DataType_DATA_TYPE_CHAR DataType = 20
	// Varchar data type.
	DataType_DATA_TYPE_VARCHAR DataType = 21
	// Longvarchar data type.
	DataType_DATA_TYPE_LONGVARCHAR DataType = 22
	// Timestamp data type.
	DataType_DATA_TYPE_TIMESTAMP DataType = 23
	// Nchar data type.
	DataType_DATA_TYPE_NCHAR DataType = 24
	// Nvarchar data type.
	DataType_DATA_TYPE_NVARCHAR DataType = 25
	// Longnvarchar data type.
	DataType_DATA_TYPE_LONGNVARCHAR DataType = 26
	// Null data type.
	DataType_DATA_TYPE_NULL DataType = 27
	// UNSUPPORTED! Binary data type.
	DataType_DATA_TYPE_OTHER DataType = 28
	// UNSUPPORTED! Binary data type.
	DataType_DATA_TYPE_JAVA_OBJECT DataType = 29
	// UNSUPPORTED! Binary data type.
	DataType_DATA_TYPE_DISTINCT DataType = 30
	// UNSUPPORTED! Binary data type.
	DataType_DATA_TYPE_STRUCT DataType = 31
	// UNSUPPORTED! Binary data type.
	DataType_DATA_TYPE_ARRAY DataType = 32
	// UNSUPPORTED! Binary data type.
	DataType_DATA_TYPE_CLOB DataType = 33
	// UNSUPPORTED! Binary data type.
	DataType_DATA_TYPE_REF DataType = 34
	// UNSUPPORTED! Binary data type.
	DataType_DATA_TYPE_DATALINK DataType = 35
	// UNSUPPORTED! Row id data type.
	DataType_DATA_TYPE_ROWID DataType = 36
	// UNSUPPORTED! Binary data type.
	DataType_DATA_TYPE_BINARY DataType = 37
	// UNSUPPORTED! Variable binary data type.
	DataType_DATA_TYPE_VARBINARY DataType = 38
	// UNSUPPORTED! Long variable binary data type.
	DataType_DATA_TYPE_LONGVARBINARY DataType = 39
	// UNSUPPORTED! NCLOB data type.
	DataType_DATA_TYPE_NCLOB DataType = 40
	// UNSUPPORTED! SQL XML data type is not supported.
	DataType_DATA_TYPE_SQLXML DataType = 41
	// UNSUPPORTED! Cursor reference type is not supported.
	DataType_DATA_TYPE_REF_CURSOR DataType = 42
	// UNSUPPORTED! Use TIME or TIMESTAMP instead.
	DataType_DATA_TYPE_TIME_WITH_TIMEZONE DataType = 43
	// UNSUPPORTED! Use TIMESTAMP instead.
	DataType_DATA_TYPE_TIMESTAMP_WITH_TIMEZONE DataType = 44
)

// Enum value maps for DataType.
var (
	DataType_name = map[int32]string{
		0:  "DATA_TYPE_UNSPECIFIED",
		1:  "DATA_TYPE_INT",
		2:  "DATA_TYPE_SMALLINT",
		3:  "DATA_TYPE_DOUBLE",
		4:  "DATA_TYPE_DATE",
		5:  "DATA_TYPE_DATETIME",
		6:  "DATA_TYPE_TIME",
		7:  "DATA_TYPE_STRING",
		8:  "DATA_TYPE_LONG",
		9:  "DATA_TYPE_BOOLEAN",
		10: "DATA_TYPE_DECIMAL",
		11: "DATA_TYPE_UUID",
		12: "DATA_TYPE_BLOB",
		13: "DATA_TYPE_BIT",
		14: "DATA_TYPE_TINYINT",
		15: "DATA_TYPE_INTEGER",
		16: "DATA_TYPE_BIGINT",
		17: "DATA_TYPE_FLOAT",
		18: "DATA_TYPE_REAL",
		19: "DATA_TYPE_NUMERIC",
		20: "DATA_TYPE_CHAR",
		21: "DATA_TYPE_VARCHAR",
		22: "DATA_TYPE_LONGVARCHAR",
		23: "DATA_TYPE_TIMESTAMP",
		24: "DATA_TYPE_NCHAR",
		25: "DATA_TYPE_NVARCHAR",
		26: "DATA_TYPE_LONGNVARCHAR",
		27: "DATA_TYPE_NULL",
		28: "DATA_TYPE_OTHER",
		29: "DATA_TYPE_JAVA_OBJECT",
		30: "DATA_TYPE_DISTINCT",
		31: "DATA_TYPE_STRUCT",
		32: "DATA_TYPE_ARRAY",
		33: "DATA_TYPE_CLOB",
		34: "DATA_TYPE_REF",
		35: "DATA_TYPE_DATALINK",
		36: "DATA_TYPE_ROWID",
		37: "DATA_TYPE_BINARY",
		38: "DATA_TYPE_VARBINARY",
		39: "DATA_TYPE_LONGVARBINARY",
		40: "DATA_TYPE_NCLOB",
		41: "DATA_TYPE_SQLXML",
		42: "DATA_TYPE_REF_CURSOR",
		43: "DATA_TYPE_TIME_WITH_TIMEZONE",
		44: "DATA_TYPE_TIMESTAMP_WITH_TIMEZONE",
	}
	DataType_value = map[string]int32{
		"DATA_TYPE_UNSPECIFIED":             0,
		"DATA_TYPE_INT":                     1,
		"DATA_TYPE_SMALLINT":                2,
		"DATA_TYPE_DOUBLE":                  3,
		"DATA_TYPE_DATE":                    4,
		"DATA_TYPE_DATETIME":                5,
		"DATA_TYPE_TIME":                    6,
		"DATA_TYPE_STRING":                  7,
		"DATA_TYPE_LONG":                    8,
		"DATA_TYPE_BOOLEAN":                 9,
		"DATA_TYPE_DECIMAL":                 10,
		"DATA_TYPE_UUID":                    11,
		"DATA_TYPE_BLOB":                    12,
		"DATA_TYPE_BIT":                     13,
		"DATA_TYPE_TINYINT":                 14,
		"DATA_TYPE_INTEGER":                 15,
		"DATA_TYPE_BIGINT":                  16,
		"DATA_TYPE_FLOAT":                   17,
		"DATA_TYPE_REAL":                    18,
		"DATA_TYPE_NUMERIC":                 19,
		"DATA_TYPE_CHAR":                    20,
		"DATA_TYPE_VARCHAR":                 21,
		"DATA_TYPE_LONGVARCHAR":             22,
		"DATA_TYPE_TIMESTAMP":               23,
		"DATA_TYPE_NCHAR":                   24,
		"DATA_TYPE_NVARCHAR":                25,
		"DATA_TYPE_LONGNVARCHAR":            26,
		"DATA_TYPE_NULL":                    27,
		"DATA_TYPE_OTHER":                   28,
		"DATA_TYPE_JAVA_OBJECT":             29,
		"DATA_TYPE_DISTINCT":                30,
		"DATA_TYPE_STRUCT":                  31,
		"DATA_TYPE_ARRAY":                   32,
		"DATA_TYPE_CLOB":                    33,
		"DATA_TYPE_REF":                     34,
		"DATA_TYPE_DATALINK":                35,
		"DATA_TYPE_ROWID":                   36,
		"DATA_TYPE_BINARY":                  37,
		"DATA_TYPE_VARBINARY":               38,
		"DATA_TYPE_LONGVARBINARY":           39,
		"DATA_TYPE_NCLOB":                   40,
		"DATA_TYPE_SQLXML":                  41,
		"DATA_TYPE_REF_CURSOR":              42,
		"DATA_TYPE_TIME_WITH_TIMEZONE":      43,
		"DATA_TYPE_TIMESTAMP_WITH_TIMEZONE": 44,
	}
)

func (x DataType) Enum() *DataType {
	p := new(DataType)
	*p = x
	return p
}

func (x DataType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_connectors_v1_connection_proto_enumTypes[0].Descriptor()
}

func (DataType) Type() protoreflect.EnumType {
	return &file_google_cloud_connectors_v1_connection_proto_enumTypes[0]
}

func (x DataType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataType.Descriptor instead.
func (DataType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connection_proto_rawDescGZIP(), []int{0}
}

// Enum to control which fields should be included in the response.
type ConnectionView int32

const (
	// CONNECTION_UNSPECIFIED.
	ConnectionView_CONNECTION_VIEW_UNSPECIFIED ConnectionView = 0
	// Do not include runtime required configs.
	ConnectionView_BASIC ConnectionView = 1
	// Include runtime required configs.
	ConnectionView_FULL ConnectionView = 2
)

// Enum value maps for ConnectionView.
var (
	ConnectionView_name = map[int32]string{
		0: "CONNECTION_VIEW_UNSPECIFIED",
		1: "BASIC",
		2: "FULL",
	}
	ConnectionView_value = map[string]int32{
		"CONNECTION_VIEW_UNSPECIFIED": 0,
		"BASIC":                       1,
		"FULL":                        2,
	}
)

func (x ConnectionView) Enum() *ConnectionView {
	p := new(ConnectionView)
	*p = x
	return p
}

func (x ConnectionView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConnectionView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_connectors_v1_connection_proto_enumTypes[1].Descriptor()
}

func (ConnectionView) Type() protoreflect.EnumType {
	return &file_google_cloud_connectors_v1_connection_proto_enumTypes[1]
}

func (x ConnectionView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConnectionView.Descriptor instead.
func (ConnectionView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connection_proto_rawDescGZIP(), []int{1}
}

// All the possible Connection State.
type ConnectionStatus_State int32

const (
	// Connection does not have a state yet.
	ConnectionStatus_STATE_UNSPECIFIED ConnectionStatus_State = 0
	// Connection is being created.
	ConnectionStatus_CREATING ConnectionStatus_State = 1
	// Connection is running and ready for requests.
	ConnectionStatus_ACTIVE ConnectionStatus_State = 2
	// Connection is stopped.
	ConnectionStatus_INACTIVE ConnectionStatus_State = 3
	// Connection is being deleted.
	ConnectionStatus_DELETING ConnectionStatus_State = 4
	// Connection is being updated.
	ConnectionStatus_UPDATING ConnectionStatus_State = 5
	// Connection is not running due to an error.
	ConnectionStatus_ERROR ConnectionStatus_State = 6
)

// Enum value maps for ConnectionStatus_State.
var (
	ConnectionStatus_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "INACTIVE",
		4: "DELETING",
		5: "UPDATING",
		6: "ERROR",
	}
	ConnectionStatus_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
		"INACTIVE":          3,
		"DELETING":          4,
		"UPDATING":          5,
		"ERROR":             6,
	}
)

func (x ConnectionStatus_State) Enum() *ConnectionStatus_State {
	p := new(ConnectionStatus_State)
	*p = x
	return p
}

func (x ConnectionStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConnectionStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_connectors_v1_connection_proto_enumTypes[2].Descriptor()
}

func (ConnectionStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_connectors_v1_connection_proto_enumTypes[2]
}

func (x ConnectionStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConnectionStatus_State.Descriptor instead.
func (ConnectionStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connection_proto_rawDescGZIP(), []int{17, 0}
}

// Connection represents an instance of connector.
type Connection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of the Connection.
	// Format: projects/{project}/locations/{location}/connections/{connection}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Created time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Updated time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Resource labels to represent user-provided metadata.
	// Refer to cloud documentation on labels for more details.
	// https://cloud.google.com/compute/docs/labeling-resources
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Description of the resource.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Required. Connector version on which the connection is created.
	// The format is:
	// projects/*/locations/*/providers/*/connectors/*/versions/*
	// Only global location is supported for ConnectorVersion resource.
	ConnectorVersion string `protobuf:"bytes,6,opt,name=connector_version,json=connectorVersion,proto3" json:"connector_version,omitempty"`
	// Output only. Current status of the connection.
	Status *ConnectionStatus `protobuf:"bytes,7,opt,name=status,proto3" json:"status,omitempty"`
	// Optional. Configuration for configuring the connection with an external system.
	ConfigVariables []*ConfigVariable `protobuf:"bytes,8,rep,name=config_variables,json=configVariables,proto3" json:"config_variables,omitempty"`
	// Optional. Configuration for establishing the connection's authentication with an
	// external system.
	AuthConfig *AuthConfig `protobuf:"bytes,9,opt,name=auth_config,json=authConfig,proto3" json:"auth_config,omitempty"`
	// Optional. Configuration that indicates whether or not the Connection can be edited.
	LockConfig *LockConfig `protobuf:"bytes,10,opt,name=lock_config,json=lockConfig,proto3" json:"lock_config,omitempty"`
	// Optional. Configuration of the Connector's destination. Only accepted for Connectors
	// that accepts user defined destination(s).
	DestinationConfigs []*DestinationConfig `protobuf:"bytes,18,rep,name=destination_configs,json=destinationConfigs,proto3" json:"destination_configs,omitempty"`
	// Output only. GCR location where the runtime image is stored.
	// formatted like: gcr.io/{bucketName}/{imageName}
	ImageLocation string `protobuf:"bytes,11,opt,name=image_location,json=imageLocation,proto3" json:"image_location,omitempty"`
	// Optional. Service account needed for runtime plane to access GCP resources.
	ServiceAccount string `protobuf:"bytes,12,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Output only. The name of the Service Directory service name. Used for
	// Private Harpoon to resolve the ILB address.
	// e.g.
	// "projects/cloud-connectors-e2e-testing/locations/us-central1/namespaces/istio-system/services/istio-ingressgateway-connectors"
	ServiceDirectory string `protobuf:"bytes,13,opt,name=service_directory,json=serviceDirectory,proto3" json:"service_directory,omitempty"`
	// Output only. GCR location where the envoy image is stored.
	// formatted like: gcr.io/{bucketName}/{imageName}
	EnvoyImageLocation string `protobuf:"bytes,15,opt,name=envoy_image_location,json=envoyImageLocation,proto3" json:"envoy_image_location,omitempty"`
	// Optional. Suspended indicates if a user has suspended a connection or not.
	Suspended bool `protobuf:"varint,17,opt,name=suspended,proto3" json:"suspended,omitempty"`
	// Optional. Configuration for the connection.
	NodeConfig *NodeConfig `protobuf:"bytes,19,opt,name=node_config,json=nodeConfig,proto3" json:"node_config,omitempty"`
}

func (x *Connection) Reset() {
	*x = Connection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Connection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Connection) ProtoMessage() {}

func (x *Connection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Connection.ProtoReflect.Descriptor instead.
func (*Connection) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connection_proto_rawDescGZIP(), []int{0}
}

func (x *Connection) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Connection) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Connection) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Connection) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Connection) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Connection) GetConnectorVersion() string {
	if x != nil {
		return x.ConnectorVersion
	}
	return ""
}

func (x *Connection) GetStatus() *ConnectionStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *Connection) GetConfigVariables() []*ConfigVariable {
	if x != nil {
		return x.ConfigVariables
	}
	return nil
}

func (x *Connection) GetAuthConfig() *AuthConfig {
	if x != nil {
		return x.AuthConfig
	}
	return nil
}

func (x *Connection) GetLockConfig() *LockConfig {
	if x != nil {
		return x.LockConfig
	}
	return nil
}

func (x *Connection) GetDestinationConfigs() []*DestinationConfig {
	if x != nil {
		return x.DestinationConfigs
	}
	return nil
}

func (x *Connection) GetImageLocation() string {
	if x != nil {
		return x.ImageLocation
	}
	return ""
}

func (x *Connection) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *Connection) GetServiceDirectory() string {
	if x != nil {
		return x.ServiceDirectory
	}
	return ""
}

func (x *Connection) GetEnvoyImageLocation() string {
	if x != nil {
		return x.EnvoyImageLocation
	}
	return ""
}

func (x *Connection) GetSuspended() bool {
	if x != nil {
		return x.Suspended
	}
	return false
}

func (x *Connection) GetNodeConfig() *NodeConfig {
	if x != nil {
		return x.NodeConfig
	}
	return nil
}

// Configuration for the connection.
type NodeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Minimum number of nodes in the runtime nodes.
	MinNodeCount int32 `protobuf:"varint,1,opt,name=min_node_count,json=minNodeCount,proto3" json:"min_node_count,omitempty"`
	// Maximum number of nodes in the runtime nodes.
	MaxNodeCount int32 `protobuf:"varint,2,opt,name=max_node_count,json=maxNodeCount,proto3" json:"max_node_count,omitempty"`
}

func (x *NodeConfig) Reset() {
	*x = NodeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeConfig) ProtoMessage() {}

func (x *NodeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeConfig.ProtoReflect.Descriptor instead.
func (*NodeConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connection_proto_rawDescGZIP(), []int{1}
}

func (x *NodeConfig) GetMinNodeCount() int32 {
	if x != nil {
		return x.MinNodeCount
	}
	return 0
}

func (x *NodeConfig) GetMaxNodeCount() int32 {
	if x != nil {
		return x.MaxNodeCount
	}
	return 0
}

// Metadata of connection schema.
type ConnectionSchemaMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. List of entity names.
	Entities []string `protobuf:"bytes,1,rep,name=entities,proto3" json:"entities,omitempty"`
	// Output only. List of actions.
	Actions []string `protobuf:"bytes,2,rep,name=actions,proto3" json:"actions,omitempty"`
}

func (x *ConnectionSchemaMetadata) Reset() {
	*x = ConnectionSchemaMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConnectionSchemaMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionSchemaMetadata) ProtoMessage() {}

func (x *ConnectionSchemaMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectionSchemaMetadata.ProtoReflect.Descriptor instead.
func (*ConnectionSchemaMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connection_proto_rawDescGZIP(), []int{2}
}

func (x *ConnectionSchemaMetadata) GetEntities() []string {
	if x != nil {
		return x.Entities
	}
	return nil
}

func (x *ConnectionSchemaMetadata) GetActions() []string {
	if x != nil {
		return x.Actions
	}
	return nil
}

// Schema of a runtime entity.
type RuntimeEntitySchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Name of the entity.
	Entity string `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// Output only. List of fields in the entity.
	Fields []*RuntimeEntitySchema_Field `protobuf:"bytes,2,rep,name=fields,proto3" json:"fields,omitempty"`
}

func (x *RuntimeEntitySchema) Reset() {
	*x = RuntimeEntitySchema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuntimeEntitySchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeEntitySchema) ProtoMessage() {}

func (x *RuntimeEntitySchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeEntitySchema.ProtoReflect.Descriptor instead.
func (*RuntimeEntitySchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connection_proto_rawDescGZIP(), []int{3}
}

func (x *RuntimeEntitySchema) GetEntity() string {
	if x != nil {
		return x.Entity
	}
	return ""
}

func (x *RuntimeEntitySchema) GetFields() []*RuntimeEntitySchema_Field {
	if x != nil {
		return x.Fields
	}
	return nil
}

// Schema of a runtime action.
type RuntimeActionSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Name of the action.
	Action string `protobuf:"bytes,1,opt,name=action,proto3" json:"action,omitempty"`
	// Output only. List of input parameter metadata for the action.
	InputParameters []*RuntimeActionSchema_InputParameter `protobuf:"bytes,2,rep,name=input_parameters,json=inputParameters,proto3" json:"input_parameters,omitempty"`
	// Output only. List of result field metadata.
	ResultMetadata []*RuntimeActionSchema_ResultMetadata `protobuf:"bytes,3,rep,name=result_metadata,json=resultMetadata,proto3" json:"result_metadata,omitempty"`
}

func (x *RuntimeActionSchema) Reset() {
	*x = RuntimeActionSchema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuntimeActionSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeActionSchema) ProtoMessage() {}

func (x *RuntimeActionSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeActionSchema.ProtoReflect.Descriptor instead.
func (*RuntimeActionSchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connection_proto_rawDescGZIP(), []int{4}
}

func (x *RuntimeActionSchema) GetAction() string {
	if x != nil {
		return x.Action
	}
	return ""
}

func (x *RuntimeActionSchema) GetInputParameters() []*RuntimeActionSchema_InputParameter {
	if x != nil {
		return x.InputParameters
	}
	return nil
}

func (x *RuntimeActionSchema) GetResultMetadata() []*RuntimeActionSchema_ResultMetadata {
	if x != nil {
		return x.ResultMetadata
	}
	return nil
}

// Determines whether or no a connection is locked. If locked, a reason must be
// specified.
type LockConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates whether or not the connection is locked.
	Locked bool `protobuf:"varint,1,opt,name=locked,proto3" json:"locked,omitempty"`
	// Describes why a connection is locked.
	Reason string `protobuf:"bytes,2,opt,name=reason,proto3" json:"reason,omitempty"`
}

func (x *LockConfig) Reset() {
	*x = LockConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LockConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LockConfig) ProtoMessage() {}

func (x *LockConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LockConfig.ProtoReflect.Descriptor instead.
func (*LockConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connection_proto_rawDescGZIP(), []int{5}
}

func (x *LockConfig) GetLocked() bool {
	if x != nil {
		return x.Locked
	}
	return false
}

func (x *LockConfig) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

// Request message for ConnectorsService.ListConnections
type ListConnectionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource of the Connection, of the form:
	// `projects/*/locations/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filter.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Order by parameters.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Specifies which fields of the Connection are returned in the response.
	// Defaults to `BASIC` view.
	View ConnectionView `protobuf:"varint,6,opt,name=view,proto3,enum=google.cloud.connectors.v1.ConnectionView" json:"view,omitempty"`
}

func (x *ListConnectionsRequest) Reset() {
	*x = ListConnectionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConnectionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConnectionsRequest) ProtoMessage() {}

func (x *ListConnectionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConnectionsRequest.ProtoReflect.Descriptor instead.
func (*ListConnectionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connection_proto_rawDescGZIP(), []int{6}
}

func (x *ListConnectionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConnectionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConnectionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListConnectionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListConnectionsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListConnectionsRequest) GetView() ConnectionView {
	if x != nil {
		return x.View
	}
	return ConnectionView_CONNECTION_VIEW_UNSPECIFIED
}

// Response message for ConnectorsService.ListConnections
type ListConnectionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Connections.
	Connections []*Connection `protobuf:"bytes,1,rep,name=connections,proto3" json:"connections,omitempty"`
	// Next page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListConnectionsResponse) Reset() {
	*x = ListConnectionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConnectionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConnectionsResponse) ProtoMessage() {}

func (x *ListConnectionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConnectionsResponse.ProtoReflect.Descriptor instead.
func (*ListConnectionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connection_proto_rawDescGZIP(), []int{7}
}

func (x *ListConnectionsResponse) GetConnections() []*Connection {
	if x != nil {
		return x.Connections
	}
	return nil
}

func (x *ListConnectionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListConnectionsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for ConnectorsService.GetConnection
type GetConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the form:
	// `projects/*/locations/*/connections/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Specifies which fields of the Connection are returned in the response.
	// Defaults to `BASIC` view.
	View ConnectionView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.connectors.v1.ConnectionView" json:"view,omitempty"`
}

func (x *GetConnectionRequest) Reset() {
	*x = GetConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConnectionRequest) ProtoMessage() {}

func (x *GetConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConnectionRequest.ProtoReflect.Descriptor instead.
func (*GetConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connection_proto_rawDescGZIP(), []int{8}
}

func (x *GetConnectionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetConnectionRequest) GetView() ConnectionView {
	if x != nil {
		return x.View
	}
	return ConnectionView_CONNECTION_VIEW_UNSPECIFIED
}

// Request message for ConnectorsService.CreateConnection
type CreateConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource of the Connection, of the form:
	// `projects/*/locations/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Identifier to assign to the Connection. Must be unique within scope of
	// the parent resource.
	ConnectionId string `protobuf:"bytes,2,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
	// Required. Connection resource.
	Connection *Connection `protobuf:"bytes,3,opt,name=connection,proto3" json:"connection,omitempty"`
}

func (x *CreateConnectionRequest) Reset() {
	*x = CreateConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConnectionRequest) ProtoMessage() {}

func (x *CreateConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConnectionRequest.ProtoReflect.Descriptor instead.
func (*CreateConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connection_proto_rawDescGZIP(), []int{9}
}

func (x *CreateConnectionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateConnectionRequest) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

func (x *CreateConnectionRequest) GetConnection() *Connection {
	if x != nil {
		return x.Connection
	}
	return nil
}

// Request message for ConnectorsService.UpdateConnection
type UpdateConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Connection resource.
	Connection *Connection `protobuf:"bytes,1,opt,name=connection,proto3" json:"connection,omitempty"`
	// Required. Field mask is used to specify the fields to be overwritten in the
	// Connection resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateConnectionRequest) Reset() {
	*x = UpdateConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateConnectionRequest) ProtoMessage() {}

func (x *UpdateConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateConnectionRequest.ProtoReflect.Descriptor instead.
func (*UpdateConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connection_proto_rawDescGZIP(), []int{10}
}

func (x *UpdateConnectionRequest) GetConnection() *Connection {
	if x != nil {
		return x.Connection
	}
	return nil
}

func (x *UpdateConnectionRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ConnectorsService.DeleteConnection.
type DeleteConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the form:
	// `projects/*/locations/*/connections/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteConnectionRequest) Reset() {
	*x = DeleteConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteConnectionRequest) ProtoMessage() {}

func (x *DeleteConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteConnectionRequest.ProtoReflect.Descriptor instead.
func (*DeleteConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connection_proto_rawDescGZIP(), []int{11}
}

func (x *DeleteConnectionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ConnectorsService.GetConnectionSchemaMetadata.
type GetConnectionSchemaMetadataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Connection name
	// Format:
	// projects/{project}/locations/{location}/connections/{connection}/connectionSchemaMetadata
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetConnectionSchemaMetadataRequest) Reset() {
	*x = GetConnectionSchemaMetadataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConnectionSchemaMetadataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConnectionSchemaMetadataRequest) ProtoMessage() {}

func (x *GetConnectionSchemaMetadataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConnectionSchemaMetadataRequest.ProtoReflect.Descriptor instead.
func (*GetConnectionSchemaMetadataRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connection_proto_rawDescGZIP(), []int{12}
}

func (x *GetConnectionSchemaMetadataRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ConnectorsService.ListRuntimeEntitySchemas.
// For filter, only entity field is supported with literal equality operator.
// Accepted filter example: entity="Order"
// Wildcards are not supported in the filter currently.
type ListRuntimeEntitySchemasRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource of RuntimeEntitySchema
	// Format:
	// projects/{project}/locations/{location}/connections/{connection}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Required. Filter
	// Format:
	// entity="{entityId}"
	// Only entity field is supported with literal equality operator.
	// Accepted filter example: entity="Order"
	// Wildcards are not supported in the filter currently.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListRuntimeEntitySchemasRequest) Reset() {
	*x = ListRuntimeEntitySchemasRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRuntimeEntitySchemasRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRuntimeEntitySchemasRequest) ProtoMessage() {}

func (x *ListRuntimeEntitySchemasRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRuntimeEntitySchemasRequest.ProtoReflect.Descriptor instead.
func (*ListRuntimeEntitySchemasRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connection_proto_rawDescGZIP(), []int{13}
}

func (x *ListRuntimeEntitySchemasRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRuntimeEntitySchemasRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRuntimeEntitySchemasRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListRuntimeEntitySchemasRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for ConnectorsService.ListRuntimeEntitySchemas.
type ListRuntimeEntitySchemasResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Runtime entity schemas.
	RuntimeEntitySchemas []*RuntimeEntitySchema `protobuf:"bytes,1,rep,name=runtime_entity_schemas,json=runtimeEntitySchemas,proto3" json:"runtime_entity_schemas,omitempty"`
	// Next page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListRuntimeEntitySchemasResponse) Reset() {
	*x = ListRuntimeEntitySchemasResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRuntimeEntitySchemasResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRuntimeEntitySchemasResponse) ProtoMessage() {}

func (x *ListRuntimeEntitySchemasResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRuntimeEntitySchemasResponse.ProtoReflect.Descriptor instead.
func (*ListRuntimeEntitySchemasResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connection_proto_rawDescGZIP(), []int{14}
}

func (x *ListRuntimeEntitySchemasResponse) GetRuntimeEntitySchemas() []*RuntimeEntitySchema {
	if x != nil {
		return x.RuntimeEntitySchemas
	}
	return nil
}

func (x *ListRuntimeEntitySchemasResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for ConnectorsService.ListRuntimeActionSchemas.
// For filter, only action field is supported with literal equality operator.
// Accepted filter example: action="approveOrder"
// Wildcards are not supported in the filter currently.
type ListRuntimeActionSchemasRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource of RuntimeActionSchema
	// Format:
	// projects/{project}/locations/{location}/connections/{connection}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Required. Filter
	// Format:
	// action="{actionId}"
	// Only action field is supported with literal equality operator.
	// Accepted filter example: action="CancelOrder"
	// Wildcards are not supported in the filter currently.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListRuntimeActionSchemasRequest) Reset() {
	*x = ListRuntimeActionSchemasRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRuntimeActionSchemasRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRuntimeActionSchemasRequest) ProtoMessage() {}

func (x *ListRuntimeActionSchemasRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRuntimeActionSchemasRequest.ProtoReflect.Descriptor instead.
func (*ListRuntimeActionSchemasRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connection_proto_rawDescGZIP(), []int{15}
}

func (x *ListRuntimeActionSchemasRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRuntimeActionSchemasRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRuntimeActionSchemasRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListRuntimeActionSchemasRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for ConnectorsService.ListRuntimeActionSchemas.
type ListRuntimeActionSchemasResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Runtime action schemas.
	RuntimeActionSchemas []*RuntimeActionSchema `protobuf:"bytes,1,rep,name=runtime_action_schemas,json=runtimeActionSchemas,proto3" json:"runtime_action_schemas,omitempty"`
	// Next page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListRuntimeActionSchemasResponse) Reset() {
	*x = ListRuntimeActionSchemasResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRuntimeActionSchemasResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRuntimeActionSchemasResponse) ProtoMessage() {}

func (x *ListRuntimeActionSchemasResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRuntimeActionSchemasResponse.ProtoReflect.Descriptor instead.
func (*ListRuntimeActionSchemasResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connection_proto_rawDescGZIP(), []int{16}
}

func (x *ListRuntimeActionSchemasResponse) GetRuntimeActionSchemas() []*RuntimeActionSchema {
	if x != nil {
		return x.RuntimeActionSchemas
	}
	return nil
}

func (x *ListRuntimeActionSchemasResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// ConnectionStatus indicates the state of the connection.
type ConnectionStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// State.
	State ConnectionStatus_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.connectors.v1.ConnectionStatus_State" json:"state,omitempty"`
	// Description.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Status provides detailed information for the state.
	Status string `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *ConnectionStatus) Reset() {
	*x = ConnectionStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConnectionStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionStatus) ProtoMessage() {}

func (x *ConnectionStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectionStatus.ProtoReflect.Descriptor instead.
func (*ConnectionStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connection_proto_rawDescGZIP(), []int{17}
}

func (x *ConnectionStatus) GetState() ConnectionStatus_State {
	if x != nil {
		return x.State
	}
	return ConnectionStatus_STATE_UNSPECIFIED
}

func (x *ConnectionStatus) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ConnectionStatus) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

// Metadata of an entity field.
type RuntimeEntitySchema_Field struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the Field.
	Field string `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	// A brief description of the Field.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The data type of the Field.
	DataType DataType `protobuf:"varint,3,opt,name=data_type,json=dataType,proto3,enum=google.cloud.connectors.v1.DataType" json:"data_type,omitempty"`
	// The following boolean field specifies if the current Field acts
	// as a primary key or id if the parent is of type entity.
	Key bool `protobuf:"varint,4,opt,name=key,proto3" json:"key,omitempty"`
	// Specifies if the Field is readonly.
	Readonly bool `protobuf:"varint,5,opt,name=readonly,proto3" json:"readonly,omitempty"`
	// Specifies whether a null value is allowed.
	Nullable bool `protobuf:"varint,6,opt,name=nullable,proto3" json:"nullable,omitempty"`
	// The following field specifies the default value of the Field provided
	// by the external system if a value is not provided.
	DefaultValue *structpb.Value `protobuf:"bytes,7,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
	// The following map contains fields that are not explicitly mentioned
	// above,this give connectors the flexibility to add new metadata
	// fields.
	AdditionalDetails *structpb.Struct `protobuf:"bytes,8,opt,name=additional_details,json=additionalDetails,proto3" json:"additional_details,omitempty"`
}

func (x *RuntimeEntitySchema_Field) Reset() {
	*x = RuntimeEntitySchema_Field{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuntimeEntitySchema_Field) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeEntitySchema_Field) ProtoMessage() {}

func (x *RuntimeEntitySchema_Field) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeEntitySchema_Field.ProtoReflect.Descriptor instead.
func (*RuntimeEntitySchema_Field) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connection_proto_rawDescGZIP(), []int{3, 0}
}

func (x *RuntimeEntitySchema_Field) GetField() string {
	if x != nil {
		return x.Field
	}
	return ""
}

func (x *RuntimeEntitySchema_Field) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *RuntimeEntitySchema_Field) GetDataType() DataType {
	if x != nil {
		return x.DataType
	}
	return DataType_DATA_TYPE_UNSPECIFIED
}

func (x *RuntimeEntitySchema_Field) GetKey() bool {
	if x != nil {
		return x.Key
	}
	return false
}

func (x *RuntimeEntitySchema_Field) GetReadonly() bool {
	if x != nil {
		return x.Readonly
	}
	return false
}

func (x *RuntimeEntitySchema_Field) GetNullable() bool {
	if x != nil {
		return x.Nullable
	}
	return false
}

func (x *RuntimeEntitySchema_Field) GetDefaultValue() *structpb.Value {
	if x != nil {
		return x.DefaultValue
	}
	return nil
}

func (x *RuntimeEntitySchema_Field) GetAdditionalDetails() *structpb.Struct {
	if x != nil {
		return x.AdditionalDetails
	}
	return nil
}

// Metadata of an input parameter.
type RuntimeActionSchema_InputParameter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the Parameter.
	Parameter string `protobuf:"bytes,1,opt,name=parameter,proto3" json:"parameter,omitempty"`
	// A brief description of the Parameter.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The data type of the Parameter.
	DataType DataType `protobuf:"varint,3,opt,name=data_type,json=dataType,proto3,enum=google.cloud.connectors.v1.DataType" json:"data_type,omitempty"`
	// Specifies whether a null value is allowed.
	Nullable bool `protobuf:"varint,4,opt,name=nullable,proto3" json:"nullable,omitempty"`
	// The following field specifies the default value of the Parameter
	// provided by the external system if a value is not provided.
	DefaultValue *structpb.Value `protobuf:"bytes,5,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
}

func (x *RuntimeActionSchema_InputParameter) Reset() {
	*x = RuntimeActionSchema_InputParameter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuntimeActionSchema_InputParameter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeActionSchema_InputParameter) ProtoMessage() {}

func (x *RuntimeActionSchema_InputParameter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeActionSchema_InputParameter.ProtoReflect.Descriptor instead.
func (*RuntimeActionSchema_InputParameter) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connection_proto_rawDescGZIP(), []int{4, 0}
}

func (x *RuntimeActionSchema_InputParameter) GetParameter() string {
	if x != nil {
		return x.Parameter
	}
	return ""
}

func (x *RuntimeActionSchema_InputParameter) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *RuntimeActionSchema_InputParameter) GetDataType() DataType {
	if x != nil {
		return x.DataType
	}
	return DataType_DATA_TYPE_UNSPECIFIED
}

func (x *RuntimeActionSchema_InputParameter) GetNullable() bool {
	if x != nil {
		return x.Nullable
	}
	return false
}

func (x *RuntimeActionSchema_InputParameter) GetDefaultValue() *structpb.Value {
	if x != nil {
		return x.DefaultValue
	}
	return nil
}

// Metadata of result field.
type RuntimeActionSchema_ResultMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the result field.
	Field string `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	// A brief description of the field.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The data type of the field.
	DataType DataType `protobuf:"varint,3,opt,name=data_type,json=dataType,proto3,enum=google.cloud.connectors.v1.DataType" json:"data_type,omitempty"`
}

func (x *RuntimeActionSchema_ResultMetadata) Reset() {
	*x = RuntimeActionSchema_ResultMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuntimeActionSchema_ResultMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeActionSchema_ResultMetadata) ProtoMessage() {}

func (x *RuntimeActionSchema_ResultMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connection_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeActionSchema_ResultMetadata.ProtoReflect.Descriptor instead.
func (*RuntimeActionSchema_ResultMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connection_proto_rawDescGZIP(), []int{4, 1}
}

func (x *RuntimeActionSchema_ResultMetadata) GetField() string {
	if x != nil {
		return x.Field
	}
	return ""
}

func (x *RuntimeActionSchema_ResultMetadata) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *RuntimeActionSchema_ResultMetadata) GetDataType() DataType {
	if x != nil {
		return x.DataType
	}
	return DataType_DATA_TYPE_UNSPECIFIED
}

var File_google_cloud_connectors_v1_connection_proto protoreflect.FileDescriptor

var file_google_cloud_connectors_v1_connection_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x76,
	0x31, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x86, 0x0a, 0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4f, 0x0a,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x25,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5f, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x5a, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x76, 0x61, 0x72, 0x69,
	0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x56,
	0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x4c, 0x0a,
	0x0b, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0a, 0x61, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4c, 0x0a, 0x0b, 0x6c,
	0x6f, 0x63, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f,
	0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x6c,
	0x6f, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x63, 0x0a, 0x13, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x18, 0x12, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x64, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x2a,
	0x0a, 0x0e, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x30, 0x0a, 0x11, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x35, 0x0a, 0x14, 0x65, 0x6e,
	0x76, 0x6f, 0x79, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x65,
	0x6e, 0x76, 0x6f, 0x79, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x21, 0x0a, 0x09, 0x73, 0x75, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x18, 0x11,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x73, 0x75, 0x73, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x64, 0x12, 0x4c, 0x0a, 0x0b, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x6b, 0xea,
	0x41, 0x68, 0x0a, 0x24, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x22, 0x58, 0x0a, 0x0a, 0x4e, 0x6f,
	0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x24, 0x0a, 0x0e, 0x6d, 0x69, 0x6e, 0x5f,
	0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0c, 0x6d, 0x69, 0x6e, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x24,
	0x0a, 0x0e, 0x6d, 0x61, 0x78, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x6d, 0x61, 0x78, 0x4e, 0x6f, 0x64, 0x65, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x22, 0x5a, 0x0a, 0x18, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x1f, 0x0a, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x12, 0x1d, 0x0a, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0xda, 0x03, 0x0a, 0x13, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x1b, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x52, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x1a, 0xd1, 0x02, 0x0a, 0x05, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a, 0x09, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x12, 0x1a, 0x0a, 0x08,
	0x6e, 0x75, 0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08,
	0x6e, 0x75, 0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x3b, 0x0a, 0x0d, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x46, 0x0a, 0x12, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x11, 0x61, 0x64, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x8d, 0x05,
	0x0a, 0x13, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x1b, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x6e, 0x0a, 0x10, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x12, 0x6c, 0x0a, 0x0f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x1a, 0xec, 0x01, 0x0a, 0x0e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x64, 0x61,
	0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x6e, 0x75, 0x6c, 0x6c, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x6e, 0x75, 0x6c, 0x6c, 0x61, 0x62,
	0x6c, 0x65, 0x12, 0x3b, 0x0a, 0x0d, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x0c, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x1a,
	0x8b, 0x01, 0x0a, 0x0e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a, 0x09, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x22, 0x3c, 0x0a,
	0x0a, 0x4c, 0x6f, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x16, 0x0a, 0x06, 0x6c,
	0x6f, 0x63, 0x6b, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x6c, 0x6f, 0x63,
	0x6b, 0x65, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x22, 0x8d, 0x02, 0x0a, 0x16,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x12, 0x24,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x3e, 0x0a, 0x04, 0x76,
	0x69, 0x65, 0x77, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0xad, 0x01, 0x0a, 0x17,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72,
	0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x98, 0x01, 0x0a, 0x14,
	0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x69, 0x65, 0x77,
	0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0xd6, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x12, 0x24, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x64, 0x12, 0x4b, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xa8, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x0a, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x5b, 0x0a, 0x17, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x66, 0x0a, 0x22, 0x47, 0x65, 0x74, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xc0, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x22, 0xb1, 0x01, 0x0a, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x65, 0x0a, 0x16, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x14, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xc0, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x26, 0x0a, 0x24, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xb1, 0x01, 0x0a, 0x20, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x65,
	0x0a, 0x16, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52,
	0x14, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x85, 0x02,
	0x0a, 0x10, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x48, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x20, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16,
	0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x6d, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02,
	0x12, 0x0c, 0x0a, 0x08, 0x49, 0x4e, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x03, 0x12, 0x0c,
	0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08,
	0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52,
	0x52, 0x4f, 0x52, 0x10, 0x06, 0x2a, 0xae, 0x08, 0x0a, 0x08, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a,
	0x0d, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x49, 0x4e, 0x54, 0x10, 0x01,
	0x1a, 0x02, 0x08, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x53, 0x4d, 0x41, 0x4c, 0x4c, 0x49, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10,
	0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x4f, 0x55, 0x42, 0x4c, 0x45,
	0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x44, 0x41, 0x54, 0x45, 0x10, 0x04, 0x12, 0x1a, 0x0a, 0x12, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x44, 0x41, 0x54, 0x45, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x05, 0x1a, 0x02,
	0x08, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x54, 0x49, 0x4d, 0x45, 0x10, 0x06, 0x12, 0x18, 0x0a, 0x10, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x1a, 0x02, 0x08, 0x01,
	0x12, 0x16, 0x0a, 0x0e, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4c, 0x4f,
	0x4e, 0x47, 0x10, 0x08, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x44, 0x41, 0x54, 0x41,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x42, 0x4f, 0x4f, 0x4c, 0x45, 0x41, 0x4e, 0x10, 0x09, 0x12,
	0x15, 0x0a, 0x11, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x45, 0x43,
	0x49, 0x4d, 0x41, 0x4c, 0x10, 0x0a, 0x12, 0x16, 0x0a, 0x0e, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x55, 0x49, 0x44, 0x10, 0x0b, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x12,
	0x0a, 0x0e, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x42, 0x4c, 0x4f, 0x42,
	0x10, 0x0c, 0x12, 0x11, 0x0a, 0x0d, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x42, 0x49, 0x54, 0x10, 0x0d, 0x12, 0x15, 0x0a, 0x11, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x54, 0x49, 0x4e, 0x59, 0x49, 0x4e, 0x54, 0x10, 0x0e, 0x12, 0x15, 0x0a, 0x11,
	0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x47, 0x45,
	0x52, 0x10, 0x0f, 0x12, 0x14, 0x0a, 0x10, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x42, 0x49, 0x47, 0x49, 0x4e, 0x54, 0x10, 0x10, 0x12, 0x13, 0x0a, 0x0f, 0x44, 0x41, 0x54,
	0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x46, 0x4c, 0x4f, 0x41, 0x54, 0x10, 0x11, 0x12, 0x12,
	0x0a, 0x0e, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x41, 0x4c,
	0x10, 0x12, 0x12, 0x15, 0x0a, 0x11, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x4e, 0x55, 0x4d, 0x45, 0x52, 0x49, 0x43, 0x10, 0x13, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x41, 0x54,
	0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x10, 0x14, 0x12, 0x15, 0x0a,
	0x11, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x56, 0x41, 0x52, 0x43, 0x48,
	0x41, 0x52, 0x10, 0x15, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x4c, 0x4f, 0x4e, 0x47, 0x56, 0x41, 0x52, 0x43, 0x48, 0x41, 0x52, 0x10, 0x16, 0x12,
	0x17, 0x0a, 0x13, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x54, 0x49, 0x4d,
	0x45, 0x53, 0x54, 0x41, 0x4d, 0x50, 0x10, 0x17, 0x12, 0x13, 0x0a, 0x0f, 0x44, 0x41, 0x54, 0x41,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4e, 0x43, 0x48, 0x41, 0x52, 0x10, 0x18, 0x12, 0x16, 0x0a,
	0x12, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4e, 0x56, 0x41, 0x52, 0x43,
	0x48, 0x41, 0x52, 0x10, 0x19, 0x12, 0x1a, 0x0a, 0x16, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x4c, 0x4f, 0x4e, 0x47, 0x4e, 0x56, 0x41, 0x52, 0x43, 0x48, 0x41, 0x52, 0x10,
	0x1a, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4e,
	0x55, 0x4c, 0x4c, 0x10, 0x1b, 0x12, 0x13, 0x0a, 0x0f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x10, 0x1c, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x41,
	0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4a, 0x41, 0x56, 0x41, 0x5f, 0x4f, 0x42, 0x4a,
	0x45, 0x43, 0x54, 0x10, 0x1d, 0x12, 0x16, 0x0a, 0x12, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x49, 0x4e, 0x43, 0x54, 0x10, 0x1e, 0x12, 0x14, 0x0a,
	0x10, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x54, 0x52, 0x55, 0x43,
	0x54, 0x10, 0x1f, 0x12, 0x13, 0x0a, 0x0f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x41, 0x52, 0x52, 0x41, 0x59, 0x10, 0x20, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x41, 0x54, 0x41,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x4c, 0x4f, 0x42, 0x10, 0x21, 0x12, 0x11, 0x0a, 0x0d,
	0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x46, 0x10, 0x22, 0x12,
	0x16, 0x0a, 0x12, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x41, 0x54,
	0x41, 0x4c, 0x49, 0x4e, 0x4b, 0x10, 0x23, 0x12, 0x13, 0x0a, 0x0f, 0x44, 0x41, 0x54, 0x41, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x4f, 0x57, 0x49, 0x44, 0x10, 0x24, 0x12, 0x14, 0x0a, 0x10,
	0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x42, 0x49, 0x4e, 0x41, 0x52, 0x59,
	0x10, 0x25, 0x12, 0x17, 0x0a, 0x13, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x56, 0x41, 0x52, 0x42, 0x49, 0x4e, 0x41, 0x52, 0x59, 0x10, 0x26, 0x12, 0x1b, 0x0a, 0x17, 0x44,
	0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4c, 0x4f, 0x4e, 0x47, 0x56, 0x41, 0x52,
	0x42, 0x49, 0x4e, 0x41, 0x52, 0x59, 0x10, 0x27, 0x12, 0x13, 0x0a, 0x0f, 0x44, 0x41, 0x54, 0x41,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4e, 0x43, 0x4c, 0x4f, 0x42, 0x10, 0x28, 0x12, 0x14, 0x0a,
	0x10, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x51, 0x4c, 0x58, 0x4d,
	0x4c, 0x10, 0x29, 0x12, 0x18, 0x0a, 0x14, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x52, 0x45, 0x46, 0x5f, 0x43, 0x55, 0x52, 0x53, 0x4f, 0x52, 0x10, 0x2a, 0x12, 0x20, 0x0a,
	0x1c, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5f,
	0x57, 0x49, 0x54, 0x48, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5a, 0x4f, 0x4e, 0x45, 0x10, 0x2b, 0x12,
	0x25, 0x0a, 0x21, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x54, 0x49, 0x4d,
	0x45, 0x53, 0x54, 0x41, 0x4d, 0x50, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x54, 0x49, 0x4d, 0x45,
	0x5a, 0x4f, 0x4e, 0x45, 0x10, 0x2c, 0x2a, 0x46, 0x0a, 0x0e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x56, 0x69, 0x65, 0x77, 0x12, 0x1f, 0x0a, 0x1b, 0x43, 0x4f, 0x4e, 0x4e,
	0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x41, 0x53,
	0x49, 0x43, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x02, 0x42, 0x79,
	0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31,
	0x42, 0x0f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x76, 0x31, 0x3b, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_connectors_v1_connection_proto_rawDescOnce sync.Once
	file_google_cloud_connectors_v1_connection_proto_rawDescData = file_google_cloud_connectors_v1_connection_proto_rawDesc
)

func file_google_cloud_connectors_v1_connection_proto_rawDescGZIP() []byte {
	file_google_cloud_connectors_v1_connection_proto_rawDescOnce.Do(func() {
		file_google_cloud_connectors_v1_connection_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_connectors_v1_connection_proto_rawDescData)
	})
	return file_google_cloud_connectors_v1_connection_proto_rawDescData
}

var file_google_cloud_connectors_v1_connection_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_connectors_v1_connection_proto_msgTypes = make([]protoimpl.MessageInfo, 22)
var file_google_cloud_connectors_v1_connection_proto_goTypes = []interface{}{
	(DataType)(0),                              // 0: google.cloud.connectors.v1.DataType
	(ConnectionView)(0),                        // 1: google.cloud.connectors.v1.ConnectionView
	(ConnectionStatus_State)(0),                // 2: google.cloud.connectors.v1.ConnectionStatus.State
	(*Connection)(nil),                         // 3: google.cloud.connectors.v1.Connection
	(*NodeConfig)(nil),                         // 4: google.cloud.connectors.v1.NodeConfig
	(*ConnectionSchemaMetadata)(nil),           // 5: google.cloud.connectors.v1.ConnectionSchemaMetadata
	(*RuntimeEntitySchema)(nil),                // 6: google.cloud.connectors.v1.RuntimeEntitySchema
	(*RuntimeActionSchema)(nil),                // 7: google.cloud.connectors.v1.RuntimeActionSchema
	(*LockConfig)(nil),                         // 8: google.cloud.connectors.v1.LockConfig
	(*ListConnectionsRequest)(nil),             // 9: google.cloud.connectors.v1.ListConnectionsRequest
	(*ListConnectionsResponse)(nil),            // 10: google.cloud.connectors.v1.ListConnectionsResponse
	(*GetConnectionRequest)(nil),               // 11: google.cloud.connectors.v1.GetConnectionRequest
	(*CreateConnectionRequest)(nil),            // 12: google.cloud.connectors.v1.CreateConnectionRequest
	(*UpdateConnectionRequest)(nil),            // 13: google.cloud.connectors.v1.UpdateConnectionRequest
	(*DeleteConnectionRequest)(nil),            // 14: google.cloud.connectors.v1.DeleteConnectionRequest
	(*GetConnectionSchemaMetadataRequest)(nil), // 15: google.cloud.connectors.v1.GetConnectionSchemaMetadataRequest
	(*ListRuntimeEntitySchemasRequest)(nil),    // 16: google.cloud.connectors.v1.ListRuntimeEntitySchemasRequest
	(*ListRuntimeEntitySchemasResponse)(nil),   // 17: google.cloud.connectors.v1.ListRuntimeEntitySchemasResponse
	(*ListRuntimeActionSchemasRequest)(nil),    // 18: google.cloud.connectors.v1.ListRuntimeActionSchemasRequest
	(*ListRuntimeActionSchemasResponse)(nil),   // 19: google.cloud.connectors.v1.ListRuntimeActionSchemasResponse
	(*ConnectionStatus)(nil),                   // 20: google.cloud.connectors.v1.ConnectionStatus
	nil,                                        // 21: google.cloud.connectors.v1.Connection.LabelsEntry
	(*RuntimeEntitySchema_Field)(nil),          // 22: google.cloud.connectors.v1.RuntimeEntitySchema.Field
	(*RuntimeActionSchema_InputParameter)(nil), // 23: google.cloud.connectors.v1.RuntimeActionSchema.InputParameter
	(*RuntimeActionSchema_ResultMetadata)(nil), // 24: google.cloud.connectors.v1.RuntimeActionSchema.ResultMetadata
	(*timestamppb.Timestamp)(nil),              // 25: google.protobuf.Timestamp
	(*ConfigVariable)(nil),                     // 26: google.cloud.connectors.v1.ConfigVariable
	(*AuthConfig)(nil),                         // 27: google.cloud.connectors.v1.AuthConfig
	(*DestinationConfig)(nil),                  // 28: google.cloud.connectors.v1.DestinationConfig
	(*fieldmaskpb.FieldMask)(nil),              // 29: google.protobuf.FieldMask
	(*structpb.Value)(nil),                     // 30: google.protobuf.Value
	(*structpb.Struct)(nil),                    // 31: google.protobuf.Struct
}
var file_google_cloud_connectors_v1_connection_proto_depIdxs = []int32{
	25, // 0: google.cloud.connectors.v1.Connection.create_time:type_name -> google.protobuf.Timestamp
	25, // 1: google.cloud.connectors.v1.Connection.update_time:type_name -> google.protobuf.Timestamp
	21, // 2: google.cloud.connectors.v1.Connection.labels:type_name -> google.cloud.connectors.v1.Connection.LabelsEntry
	20, // 3: google.cloud.connectors.v1.Connection.status:type_name -> google.cloud.connectors.v1.ConnectionStatus
	26, // 4: google.cloud.connectors.v1.Connection.config_variables:type_name -> google.cloud.connectors.v1.ConfigVariable
	27, // 5: google.cloud.connectors.v1.Connection.auth_config:type_name -> google.cloud.connectors.v1.AuthConfig
	8,  // 6: google.cloud.connectors.v1.Connection.lock_config:type_name -> google.cloud.connectors.v1.LockConfig
	28, // 7: google.cloud.connectors.v1.Connection.destination_configs:type_name -> google.cloud.connectors.v1.DestinationConfig
	4,  // 8: google.cloud.connectors.v1.Connection.node_config:type_name -> google.cloud.connectors.v1.NodeConfig
	22, // 9: google.cloud.connectors.v1.RuntimeEntitySchema.fields:type_name -> google.cloud.connectors.v1.RuntimeEntitySchema.Field
	23, // 10: google.cloud.connectors.v1.RuntimeActionSchema.input_parameters:type_name -> google.cloud.connectors.v1.RuntimeActionSchema.InputParameter
	24, // 11: google.cloud.connectors.v1.RuntimeActionSchema.result_metadata:type_name -> google.cloud.connectors.v1.RuntimeActionSchema.ResultMetadata
	1,  // 12: google.cloud.connectors.v1.ListConnectionsRequest.view:type_name -> google.cloud.connectors.v1.ConnectionView
	3,  // 13: google.cloud.connectors.v1.ListConnectionsResponse.connections:type_name -> google.cloud.connectors.v1.Connection
	1,  // 14: google.cloud.connectors.v1.GetConnectionRequest.view:type_name -> google.cloud.connectors.v1.ConnectionView
	3,  // 15: google.cloud.connectors.v1.CreateConnectionRequest.connection:type_name -> google.cloud.connectors.v1.Connection
	3,  // 16: google.cloud.connectors.v1.UpdateConnectionRequest.connection:type_name -> google.cloud.connectors.v1.Connection
	29, // 17: google.cloud.connectors.v1.UpdateConnectionRequest.update_mask:type_name -> google.protobuf.FieldMask
	6,  // 18: google.cloud.connectors.v1.ListRuntimeEntitySchemasResponse.runtime_entity_schemas:type_name -> google.cloud.connectors.v1.RuntimeEntitySchema
	7,  // 19: google.cloud.connectors.v1.ListRuntimeActionSchemasResponse.runtime_action_schemas:type_name -> google.cloud.connectors.v1.RuntimeActionSchema
	2,  // 20: google.cloud.connectors.v1.ConnectionStatus.state:type_name -> google.cloud.connectors.v1.ConnectionStatus.State
	0,  // 21: google.cloud.connectors.v1.RuntimeEntitySchema.Field.data_type:type_name -> google.cloud.connectors.v1.DataType
	30, // 22: google.cloud.connectors.v1.RuntimeEntitySchema.Field.default_value:type_name -> google.protobuf.Value
	31, // 23: google.cloud.connectors.v1.RuntimeEntitySchema.Field.additional_details:type_name -> google.protobuf.Struct
	0,  // 24: google.cloud.connectors.v1.RuntimeActionSchema.InputParameter.data_type:type_name -> google.cloud.connectors.v1.DataType
	30, // 25: google.cloud.connectors.v1.RuntimeActionSchema.InputParameter.default_value:type_name -> google.protobuf.Value
	0,  // 26: google.cloud.connectors.v1.RuntimeActionSchema.ResultMetadata.data_type:type_name -> google.cloud.connectors.v1.DataType
	27, // [27:27] is the sub-list for method output_type
	27, // [27:27] is the sub-list for method input_type
	27, // [27:27] is the sub-list for extension type_name
	27, // [27:27] is the sub-list for extension extendee
	0,  // [0:27] is the sub-list for field type_name
}

func init() { file_google_cloud_connectors_v1_connection_proto_init() }
func file_google_cloud_connectors_v1_connection_proto_init() {
	if File_google_cloud_connectors_v1_connection_proto != nil {
		return
	}
	file_google_cloud_connectors_v1_authconfig_proto_init()
	file_google_cloud_connectors_v1_common_proto_init()
	file_google_cloud_connectors_v1_destination_config_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_connectors_v1_connection_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Connection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connection_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connection_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConnectionSchemaMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connection_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuntimeEntitySchema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connection_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuntimeActionSchema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connection_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LockConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connection_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConnectionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connection_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConnectionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connection_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connection_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connection_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connection_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connection_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetConnectionSchemaMetadataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connection_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRuntimeEntitySchemasRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connection_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRuntimeEntitySchemasResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connection_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRuntimeActionSchemasRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connection_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRuntimeActionSchemasResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connection_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConnectionStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connection_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuntimeEntitySchema_Field); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connection_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuntimeActionSchema_InputParameter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connection_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuntimeActionSchema_ResultMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_connectors_v1_connection_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   22,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_connectors_v1_connection_proto_goTypes,
		DependencyIndexes: file_google_cloud_connectors_v1_connection_proto_depIdxs,
		EnumInfos:         file_google_cloud_connectors_v1_connection_proto_enumTypes,
		MessageInfos:      file_google_cloud_connectors_v1_connection_proto_msgTypes,
	}.Build()
	File_google_cloud_connectors_v1_connection_proto = out.File
	file_google_cloud_connectors_v1_connection_proto_rawDesc = nil
	file_google_cloud_connectors_v1_connection_proto_goTypes = nil
	file_google_cloud_connectors_v1_connection_proto_depIdxs = nil
}
