// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/bigquery/dataexchange/v1beta1/dataexchange.proto

package dataexchange

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	common "google.golang.org/genproto/googleapis/cloud/bigquery/dataexchange/common"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// State of the Listing
type Listing_State int32

const (
	// Default value. This value is unused.
	Listing_STATE_UNSPECIFIED Listing_State = 0
	// Subscribable state. Users with dataexchange.listings.subscribe permission
	// can subscribe to this Listing.
	Listing_ACTIVE Listing_State = 1
)

// Enum value maps for Listing_State.
var (
	Listing_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
	}
	Listing_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
	}
)

func (x Listing_State) Enum() *Listing_State {
	p := new(Listing_State)
	*p = x
	return p
}

func (x Listing_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Listing_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_enumTypes[0].Descriptor()
}

func (Listing_State) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_enumTypes[0]
}

func (x Listing_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Listing_State.Descriptor instead.
func (Listing_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescGZIP(), []int{5, 0}
}

// A data exchange is a container that enables data sharing.
// It contains a set of listings of the data sources along with descriptive
// information of the data exchange.
type DataExchange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the data exchange.
	// e.g. `projects/myproject/locations/US/dataExchanges/123`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Human-readable display name of the data exchange. The display name must
	// contain only Unicode letters, numbers (0-9), underscores (_), dashes (-),
	// spaces ( ), and can't start or end with spaces.
	// Default value is an empty string.
	// Max length: 63 bytes.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Short description of the data exchange that can consist of sentences
	// or paragraphs. The description must not contain Unicode non-characters as
	// well as C0 and C1 control codes except tabs (HT), new lines (LF), carriage
	// returns (CR), and page breaks (FF).
	// Default value is an empty string.
	// Max length: 2000 bytes.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Email, URL or other reference of the primary point of contact of the data
	// exchange
	// Max Length: 1000 bytes.
	PrimaryContact string `protobuf:"bytes,4,opt,name=primary_contact,json=primaryContact,proto3" json:"primary_contact,omitempty"`
	// Optional. Documentation describing the data exchange.
	Documentation string `protobuf:"bytes,5,opt,name=documentation,proto3" json:"documentation,omitempty"`
	// Output only. Number of listings contained in the data exchange.
	ListingCount int32 `protobuf:"varint,6,opt,name=listing_count,json=listingCount,proto3" json:"listing_count,omitempty"`
	// Optional. Base64 encoded image representing the data exchange. Max Size: 3.0MiB
	// Expected image dimensions are 512x512 pixels, however the API only
	// performs validation on size of the encoded data.
	// Note: For byte fields, the contents of the field are base64-encoded (which
	// increases the size of the data by 33-36%) when using JSON on the wire.
	Icon []byte `protobuf:"bytes,7,opt,name=icon,proto3" json:"icon,omitempty"`
}

func (x *DataExchange) Reset() {
	*x = DataExchange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataExchange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataExchange) ProtoMessage() {}

func (x *DataExchange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataExchange.ProtoReflect.Descriptor instead.
func (*DataExchange) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescGZIP(), []int{0}
}

func (x *DataExchange) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataExchange) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *DataExchange) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *DataExchange) GetPrimaryContact() string {
	if x != nil {
		return x.PrimaryContact
	}
	return ""
}

func (x *DataExchange) GetDocumentation() string {
	if x != nil {
		return x.Documentation
	}
	return ""
}

func (x *DataExchange) GetListingCount() int32 {
	if x != nil {
		return x.ListingCount
	}
	return 0
}

func (x *DataExchange) GetIcon() []byte {
	if x != nil {
		return x.Icon
	}
	return nil
}

// Contains details of the Data Provider.
type DataProvider struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Name of the Data Provider.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Email or URL of the Data Provider.
	// Max Length: 1000 bytes.
	PrimaryContact string `protobuf:"bytes,2,opt,name=primary_contact,json=primaryContact,proto3" json:"primary_contact,omitempty"`
}

func (x *DataProvider) Reset() {
	*x = DataProvider{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProvider) ProtoMessage() {}

func (x *DataProvider) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProvider.ProtoReflect.Descriptor instead.
func (*DataProvider) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescGZIP(), []int{1}
}

func (x *DataProvider) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataProvider) GetPrimaryContact() string {
	if x != nil {
		return x.PrimaryContact
	}
	return ""
}

// Contains details of the Publisher.
type Publisher struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Name of the listing Publisher.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Email or URL of the listing Publisher.
	// Max Length: 1000 bytes.
	PrimaryContact string `protobuf:"bytes,2,opt,name=primary_contact,json=primaryContact,proto3" json:"primary_contact,omitempty"`
}

func (x *Publisher) Reset() {
	*x = Publisher{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Publisher) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Publisher) ProtoMessage() {}

func (x *Publisher) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Publisher.ProtoReflect.Descriptor instead.
func (*Publisher) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescGZIP(), []int{2}
}

func (x *Publisher) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Publisher) GetPrimaryContact() string {
	if x != nil {
		return x.PrimaryContact
	}
	return ""
}

// Defines the Destination BigQuery Dataset Reference.
type DestinationDatasetReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A unique ID for this dataset, without the project name. The ID
	// must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_).
	// The maximum length is 1,024 characters.
	DatasetId string `protobuf:"bytes,1,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// Required. The ID of the project containing this dataset.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *DestinationDatasetReference) Reset() {
	*x = DestinationDatasetReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DestinationDatasetReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DestinationDatasetReference) ProtoMessage() {}

func (x *DestinationDatasetReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DestinationDatasetReference.ProtoReflect.Descriptor instead.
func (*DestinationDatasetReference) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescGZIP(), []int{3}
}

func (x *DestinationDatasetReference) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *DestinationDatasetReference) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Defines the Destination BigQuery Dataset.
type DestinationDataset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A reference that identifies the destination dataset.
	DatasetReference *DestinationDatasetReference `protobuf:"bytes,1,opt,name=dataset_reference,json=datasetReference,proto3" json:"dataset_reference,omitempty"`
	// Optional. A descriptive name for the dataset.
	FriendlyName *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=friendly_name,json=friendlyName,proto3" json:"friendly_name,omitempty"`
	// Optional. A user-friendly description of the dataset.
	Description *wrapperspb.StringValue `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. The labels associated with this dataset. You can use these
	// to organize and group your datasets.
	// You can set this property when inserting or updating a dataset.
	// See https://cloud.google.com/resource-manager/docs/creating-managing-labels
	// for more information.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. The geographic location where the dataset should reside. See
	// https://cloud.google.com/bigquery/docs/locations for supported
	// locations.
	Location string `protobuf:"bytes,5,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *DestinationDataset) Reset() {
	*x = DestinationDataset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DestinationDataset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DestinationDataset) ProtoMessage() {}

func (x *DestinationDataset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DestinationDataset.ProtoReflect.Descriptor instead.
func (*DestinationDataset) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescGZIP(), []int{4}
}

func (x *DestinationDataset) GetDatasetReference() *DestinationDatasetReference {
	if x != nil {
		return x.DatasetReference
	}
	return nil
}

func (x *DestinationDataset) GetFriendlyName() *wrapperspb.StringValue {
	if x != nil {
		return x.FriendlyName
	}
	return nil
}

func (x *DestinationDataset) GetDescription() *wrapperspb.StringValue {
	if x != nil {
		return x.Description
	}
	return nil
}

func (x *DestinationDataset) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *DestinationDataset) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

// A listing is what gets published into a data exchange that a subscriber can
// subscribe to. It contains a reference to the data source along with
// descriptive information that will help subscribers find and subscribe the
// data.
type Listing struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the listing.
	// e.g. `projects/myproject/locations/US/dataExchanges/123/listings/456`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Human-readable display name of the listing. The display name must contain
	// only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces
	// ( ), and can't start or end with spaces.
	// Default value is an empty string.
	// Max length: 63 bytes.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Short description of the listing that can consist of sentences or
	// paragraphs. The description must not contain Unicode non-characters as
	// well as C0 and C1 control codes except tabs (HT), new lines (LF), carriage
	// returns (CR), and page breaks (FF).
	// Default value is an empty string.
	// Max length: 2000 bytes.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Email or URL of the primary point of contact of the listing.
	// Max Length: 1000 bytes.
	PrimaryContact string `protobuf:"bytes,4,opt,name=primary_contact,json=primaryContact,proto3" json:"primary_contact,omitempty"`
	// Optional. Documentation describing the listing.
	Documentation string `protobuf:"bytes,5,opt,name=documentation,proto3" json:"documentation,omitempty"`
	// Listing source.
	//
	// Types that are assignable to Source:
	//	*Listing_BigqueryDataset
	Source isListing_Source `protobuf_oneof:"source"`
	// Output only. Current state of the Listing.
	State Listing_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.bigquery.dataexchange.v1beta1.Listing_State" json:"state,omitempty"`
	// Optional. Base64 encoded image representing the listing. Max Size: 3.0MiB
	// Expected image dimensions are 512x512 pixels, however the API only
	// performs validation on size of the encoded data.
	// Note: For byte fields, the contents of the field are base64-encoded (which
	// increases the size of the data by 33-36%) when using JSON on the wire.
	Icon []byte `protobuf:"bytes,8,opt,name=icon,proto3" json:"icon,omitempty"`
	// Optional. The details of the Data Provider who owns the source data.
	DataProvider *DataProvider `protobuf:"bytes,9,opt,name=data_provider,json=dataProvider,proto3" json:"data_provider,omitempty"`
	// Optional. Categories of the Listing. Up to two categories are allowed.
	Categories []common.Category `protobuf:"varint,10,rep,packed,name=categories,proto3,enum=google.cloud.bigquery.dataexchange.common.Category" json:"categories,omitempty"`
	// Optional. The details of the Publisher who owns the listing and has rights to share
	// the source data.
	Publisher *Publisher `protobuf:"bytes,11,opt,name=publisher,proto3" json:"publisher,omitempty"`
	// Optional. Email or URL of the request access of the listing.
	// Subscribers can use this reference to request access.
	// Max Length: 1000 bytes.
	RequestAccess string `protobuf:"bytes,12,opt,name=request_access,json=requestAccess,proto3" json:"request_access,omitempty"`
}

func (x *Listing) Reset() {
	*x = Listing{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Listing) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Listing) ProtoMessage() {}

func (x *Listing) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Listing.ProtoReflect.Descriptor instead.
func (*Listing) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescGZIP(), []int{5}
}

func (x *Listing) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Listing) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Listing) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Listing) GetPrimaryContact() string {
	if x != nil {
		return x.PrimaryContact
	}
	return ""
}

func (x *Listing) GetDocumentation() string {
	if x != nil {
		return x.Documentation
	}
	return ""
}

func (m *Listing) GetSource() isListing_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *Listing) GetBigqueryDataset() *Listing_BigQueryDatasetSource {
	if x, ok := x.GetSource().(*Listing_BigqueryDataset); ok {
		return x.BigqueryDataset
	}
	return nil
}

func (x *Listing) GetState() Listing_State {
	if x != nil {
		return x.State
	}
	return Listing_STATE_UNSPECIFIED
}

func (x *Listing) GetIcon() []byte {
	if x != nil {
		return x.Icon
	}
	return nil
}

func (x *Listing) GetDataProvider() *DataProvider {
	if x != nil {
		return x.DataProvider
	}
	return nil
}

func (x *Listing) GetCategories() []common.Category {
	if x != nil {
		return x.Categories
	}
	return nil
}

func (x *Listing) GetPublisher() *Publisher {
	if x != nil {
		return x.Publisher
	}
	return nil
}

func (x *Listing) GetRequestAccess() string {
	if x != nil {
		return x.RequestAccess
	}
	return ""
}

type isListing_Source interface {
	isListing_Source()
}

type Listing_BigqueryDataset struct {
	// Required. Shared dataset i.e. BigQuery dataset source.
	BigqueryDataset *Listing_BigQueryDatasetSource `protobuf:"bytes,6,opt,name=bigquery_dataset,json=bigqueryDataset,proto3,oneof"`
}

func (*Listing_BigqueryDataset) isListing_Source() {}

// Message for requesting list of DataExchanges.
type ListDataExchangesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource path of the DataExchanges.
	// e.g. `projects/myproject/locations/US`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of results to return in a single response page. Leverage
	// the page tokens to iterate through the entire collection.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token, returned by a previous call, to request the next page of
	// results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDataExchangesRequest) Reset() {
	*x = ListDataExchangesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDataExchangesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataExchangesRequest) ProtoMessage() {}

func (x *ListDataExchangesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataExchangesRequest.ProtoReflect.Descriptor instead.
func (*ListDataExchangesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescGZIP(), []int{6}
}

func (x *ListDataExchangesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDataExchangesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDataExchangesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Message for response to listing DataExchanges.
type ListDataExchangesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of DataExchange.
	DataExchanges []*DataExchange `protobuf:"bytes,1,rep,name=data_exchanges,json=dataExchanges,proto3" json:"data_exchanges,omitempty"`
	// A token to request the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDataExchangesResponse) Reset() {
	*x = ListDataExchangesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDataExchangesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataExchangesResponse) ProtoMessage() {}

func (x *ListDataExchangesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataExchangesResponse.ProtoReflect.Descriptor instead.
func (*ListDataExchangesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescGZIP(), []int{7}
}

func (x *ListDataExchangesResponse) GetDataExchanges() []*DataExchange {
	if x != nil {
		return x.DataExchanges
	}
	return nil
}

func (x *ListDataExchangesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Message for requesting list of DataExchanges from projects in an organization
// and location.
type ListOrgDataExchangesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The organization resource path of the projects containing DataExchanges.
	// e.g. `organizations/myorg/locations/US`.
	Organization string `protobuf:"bytes,1,opt,name=organization,proto3" json:"organization,omitempty"`
	// The maximum number of results to return in a single response page. Leverage
	// the page tokens to iterate through the entire collection.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token, returned by a previous call, to request the next page of
	// results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListOrgDataExchangesRequest) Reset() {
	*x = ListOrgDataExchangesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOrgDataExchangesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOrgDataExchangesRequest) ProtoMessage() {}

func (x *ListOrgDataExchangesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOrgDataExchangesRequest.ProtoReflect.Descriptor instead.
func (*ListOrgDataExchangesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescGZIP(), []int{8}
}

func (x *ListOrgDataExchangesRequest) GetOrganization() string {
	if x != nil {
		return x.Organization
	}
	return ""
}

func (x *ListOrgDataExchangesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListOrgDataExchangesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Message for response to listing DataExchanges in an organization and
// location.
type ListOrgDataExchangesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of DataExchange.
	DataExchanges []*DataExchange `protobuf:"bytes,1,rep,name=data_exchanges,json=dataExchanges,proto3" json:"data_exchanges,omitempty"`
	// A token to request the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListOrgDataExchangesResponse) Reset() {
	*x = ListOrgDataExchangesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOrgDataExchangesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOrgDataExchangesResponse) ProtoMessage() {}

func (x *ListOrgDataExchangesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOrgDataExchangesResponse.ProtoReflect.Descriptor instead.
func (*ListOrgDataExchangesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescGZIP(), []int{9}
}

func (x *ListOrgDataExchangesResponse) GetDataExchanges() []*DataExchange {
	if x != nil {
		return x.DataExchanges
	}
	return nil
}

func (x *ListOrgDataExchangesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Message for getting a DataExchange.
type GetDataExchangeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the DataExchange.
	// e.g. `projects/myproject/locations/US/dataExchanges/123`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDataExchangeRequest) Reset() {
	*x = GetDataExchangeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDataExchangeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDataExchangeRequest) ProtoMessage() {}

func (x *GetDataExchangeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDataExchangeRequest.ProtoReflect.Descriptor instead.
func (*GetDataExchangeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescGZIP(), []int{10}
}

func (x *GetDataExchangeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for creating a DataExchange.
type CreateDataExchangeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource path of the DataExchange.
	// e.g. `projects/myproject/locations/US`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the DataExchange to create.
	// Must contain only Unicode letters, numbers (0-9), underscores (_).
	// Should not use characters that require URL-escaping, or characters
	// outside of ASCII, spaces.
	// Max length: 100 bytes.
	DataExchangeId string `protobuf:"bytes,2,opt,name=data_exchange_id,json=dataExchangeId,proto3" json:"data_exchange_id,omitempty"`
	// Required. The DataExchange to create.
	DataExchange *DataExchange `protobuf:"bytes,3,opt,name=data_exchange,json=dataExchange,proto3" json:"data_exchange,omitempty"`
}

func (x *CreateDataExchangeRequest) Reset() {
	*x = CreateDataExchangeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDataExchangeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDataExchangeRequest) ProtoMessage() {}

func (x *CreateDataExchangeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDataExchangeRequest.ProtoReflect.Descriptor instead.
func (*CreateDataExchangeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescGZIP(), []int{11}
}

func (x *CreateDataExchangeRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDataExchangeRequest) GetDataExchangeId() string {
	if x != nil {
		return x.DataExchangeId
	}
	return ""
}

func (x *CreateDataExchangeRequest) GetDataExchange() *DataExchange {
	if x != nil {
		return x.DataExchange
	}
	return nil
}

// Message for updating a DataExchange.
type UpdateDataExchangeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// DataExchange resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The DataExchange to update.
	DataExchange *DataExchange `protobuf:"bytes,2,opt,name=data_exchange,json=dataExchange,proto3" json:"data_exchange,omitempty"`
}

func (x *UpdateDataExchangeRequest) Reset() {
	*x = UpdateDataExchangeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDataExchangeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDataExchangeRequest) ProtoMessage() {}

func (x *UpdateDataExchangeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDataExchangeRequest.ProtoReflect.Descriptor instead.
func (*UpdateDataExchangeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescGZIP(), []int{12}
}

func (x *UpdateDataExchangeRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateDataExchangeRequest) GetDataExchange() *DataExchange {
	if x != nil {
		return x.DataExchange
	}
	return nil
}

// Message for deleting a DataExchange.
type DeleteDataExchangeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the DataExchange to delete.
	// e.g. `projects/myproject/locations/US/dataExchanges/123`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDataExchangeRequest) Reset() {
	*x = DeleteDataExchangeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDataExchangeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDataExchangeRequest) ProtoMessage() {}

func (x *DeleteDataExchangeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDataExchangeRequest.ProtoReflect.Descriptor instead.
func (*DeleteDataExchangeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescGZIP(), []int{13}
}

func (x *DeleteDataExchangeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for requesting list of Listings.
type ListListingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource path of the listing.
	// e.g. `projects/myproject/locations/US/dataExchanges/123`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of results to return in a single response page. Leverage
	// the page tokens to iterate through the entire collection.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token, returned by a previous call, to request the next page of
	// results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListListingsRequest) Reset() {
	*x = ListListingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListListingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListListingsRequest) ProtoMessage() {}

func (x *ListListingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListListingsRequest.ProtoReflect.Descriptor instead.
func (*ListListingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescGZIP(), []int{14}
}

func (x *ListListingsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListListingsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListListingsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Message for response to listing Listings.
type ListListingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Listing.
	Listings []*Listing `protobuf:"bytes,1,rep,name=listings,proto3" json:"listings,omitempty"`
	// A token to request the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListListingsResponse) Reset() {
	*x = ListListingsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListListingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListListingsResponse) ProtoMessage() {}

func (x *ListListingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListListingsResponse.ProtoReflect.Descriptor instead.
func (*ListListingsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescGZIP(), []int{15}
}

func (x *ListListingsResponse) GetListings() []*Listing {
	if x != nil {
		return x.Listings
	}
	return nil
}

func (x *ListListingsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Message for getting a Listing.
type GetListingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the listing.
	// e.g. `projects/myproject/locations/US/dataExchanges/123/listings/456`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetListingRequest) Reset() {
	*x = GetListingRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetListingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetListingRequest) ProtoMessage() {}

func (x *GetListingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetListingRequest.ProtoReflect.Descriptor instead.
func (*GetListingRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescGZIP(), []int{16}
}

func (x *GetListingRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for creating a Listing.
type CreateListingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource path of the listing.
	// e.g. `projects/myproject/locations/US/dataExchanges/123`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the Listing to create.
	// Must contain only Unicode letters, numbers (0-9), underscores (_).
	// Should not use characters that require URL-escaping, or characters
	// outside of ASCII, spaces.
	// Max length: 100 bytes.
	ListingId string `protobuf:"bytes,2,opt,name=listing_id,json=listingId,proto3" json:"listing_id,omitempty"`
	// Required. The listing to create.
	Listing *Listing `protobuf:"bytes,3,opt,name=listing,proto3" json:"listing,omitempty"`
}

func (x *CreateListingRequest) Reset() {
	*x = CreateListingRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateListingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateListingRequest) ProtoMessage() {}

func (x *CreateListingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateListingRequest.ProtoReflect.Descriptor instead.
func (*CreateListingRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescGZIP(), []int{17}
}

func (x *CreateListingRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateListingRequest) GetListingId() string {
	if x != nil {
		return x.ListingId
	}
	return ""
}

func (x *CreateListingRequest) GetListing() *Listing {
	if x != nil {
		return x.Listing
	}
	return nil
}

// Message for updating a Listing.
type UpdateListingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// Listing resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The listing to update.
	Listing *Listing `protobuf:"bytes,2,opt,name=listing,proto3" json:"listing,omitempty"`
}

func (x *UpdateListingRequest) Reset() {
	*x = UpdateListingRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateListingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateListingRequest) ProtoMessage() {}

func (x *UpdateListingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateListingRequest.ProtoReflect.Descriptor instead.
func (*UpdateListingRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescGZIP(), []int{18}
}

func (x *UpdateListingRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateListingRequest) GetListing() *Listing {
	if x != nil {
		return x.Listing
	}
	return nil
}

// Message for deleting a Listing.
type DeleteListingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the listing to delete.
	// e.g. `projects/myproject/locations/US/dataExchanges/123/listings/456`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteListingRequest) Reset() {
	*x = DeleteListingRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteListingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteListingRequest) ProtoMessage() {}

func (x *DeleteListingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteListingRequest.ProtoReflect.Descriptor instead.
func (*DeleteListingRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescGZIP(), []int{19}
}

func (x *DeleteListingRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for subscribing a Listing.
type SubscribeListingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the listing to subscribe to.
	// e.g. `projects/myproject/locations/US/dataExchanges/123/listings/456`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Resulting destination of the listing subscribed to.
	//
	// Types that are assignable to Destination:
	//	*SubscribeListingRequest_DestinationDataset
	Destination isSubscribeListingRequest_Destination `protobuf_oneof:"destination"`
}

func (x *SubscribeListingRequest) Reset() {
	*x = SubscribeListingRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubscribeListingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubscribeListingRequest) ProtoMessage() {}

func (x *SubscribeListingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubscribeListingRequest.ProtoReflect.Descriptor instead.
func (*SubscribeListingRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescGZIP(), []int{20}
}

func (x *SubscribeListingRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *SubscribeListingRequest) GetDestination() isSubscribeListingRequest_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *SubscribeListingRequest) GetDestinationDataset() *DestinationDataset {
	if x, ok := x.GetDestination().(*SubscribeListingRequest_DestinationDataset); ok {
		return x.DestinationDataset
	}
	return nil
}

type isSubscribeListingRequest_Destination interface {
	isSubscribeListingRequest_Destination()
}

type SubscribeListingRequest_DestinationDataset struct {
	// BigQuery destination dataset to create for the subscriber.
	DestinationDataset *DestinationDataset `protobuf:"bytes,3,opt,name=destination_dataset,json=destinationDataset,proto3,oneof"`
}

func (*SubscribeListingRequest_DestinationDataset) isSubscribeListingRequest_Destination() {}

// Message for response to subscribing a Listing.
// Empty for now.
type SubscribeListingResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SubscribeListingResponse) Reset() {
	*x = SubscribeListingResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubscribeListingResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubscribeListingResponse) ProtoMessage() {}

func (x *SubscribeListingResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubscribeListingResponse.ProtoReflect.Descriptor instead.
func (*SubscribeListingResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescGZIP(), []int{21}
}

// A reference to a Shared dataset. It's an existing BigQuery dataset with a
// collection of objects, such as tables and views, that you want to share
// with subscribers.
// Upon subscription to a Listing, Data Exchange creates a Linked dataset in
// the subscriber's project. A Linked dataset is an opaque, read-only BigQuery
// dataset that serves as a "symbolic link" to a shared dataset.
type Listing_BigQueryDatasetSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the dataset source for this listing.
	// e.g. `projects/myproject/datasets/123`
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
}

func (x *Listing_BigQueryDatasetSource) Reset() {
	*x = Listing_BigQueryDatasetSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Listing_BigQueryDatasetSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Listing_BigQueryDatasetSource) ProtoMessage() {}

func (x *Listing_BigQueryDatasetSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Listing_BigQueryDatasetSource.ProtoReflect.Descriptor instead.
func (*Listing_BigQueryDatasetSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescGZIP(), []int{5, 0}
}

func (x *Listing_BigQueryDatasetSource) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

var File_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto protoreflect.FileDescriptor

var file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDesc = []byte{
	0x0a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x65, 0x78, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x65, 0x78, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69,
	0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x61, 0x6d, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69,
	0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x88, 0x03, 0x0a, 0x0c, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x0f, 0x70, 0x72,
	0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72,
	0x79, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x12, 0x29, 0x0a, 0x0d, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0c, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x17, 0x0a,
	0x04, 0x69, 0x63, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x04, 0x69, 0x63, 0x6f, 0x6e, 0x3a, 0x74, 0xea, 0x41, 0x71, 0x0a, 0x28, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x45, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x7d, 0x22, 0x55, 0x0a, 0x0c,
	0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0e, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x22, 0x52, 0x0a, 0x09, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x70, 0x72, 0x69,
	0x6d, 0x61, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79,
	0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x22, 0x65, 0x0a, 0x1b, 0x44, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x09, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x22, 0xe1,
	0x03, 0x0a, 0x12, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x79, 0x0a, 0x11, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x65, 0x78, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x12, 0x46, 0x0a, 0x0d, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x6c, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x66, 0x72, 0x69, 0x65,
	0x6e, 0x64, 0x6c, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x43, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x67, 0x0a,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x2e, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x1f, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x8e, 0x08, 0x0a, 0x07, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x0f, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72,
	0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x12, 0x29, 0x0a, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x7b, 0x0a, 0x10, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x42,
	0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0f, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x54, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x69, 0x63, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0c,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x69, 0x63, 0x6f, 0x6e, 0x12, 0x62, 0x0a, 0x0d, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x65,
	0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12,
	0x58, 0x0a, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x0a, 0x20,
	0x03, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x63,
	0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x58, 0x0a, 0x09, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x65, 0x72, 0x12, 0x2a, 0x0a, 0x0e, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0d, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x1a,
	0x57, 0x0a, 0x15, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x3e, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xfa, 0x41, 0x21, 0x0a, 0x1f,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52,
	0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x22, 0x2a, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49,
	0x56, 0x45, 0x10, 0x01, 0x3a, 0x82, 0x01, 0xea, 0x41, 0x7f, 0x0a, 0x23, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x12,
	0x58, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x65, 0x78, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x7d, 0x2f, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f,
	0x7b, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x7d, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x22, 0x99, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0xa4, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5f, 0x0a,
	0x0e, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52,
	0x0d, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x82, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x4f,
	0x72, 0x67, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x27, 0x0a, 0x0c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa7, 0x01, 0x0a, 0x1c,
	0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72, 0x67, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5f, 0x0a, 0x0e,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x0d,
	0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5e, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xf1, 0x01, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2d, 0x0a, 0x10, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x65,
	0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x49, 0x64, 0x12, 0x62, 0x0a, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x65, 0x78,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x64, 0x61, 0x74,
	0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x22, 0xc1, 0x01, 0x0a, 0x19, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x62, 0x0a, 0x0d, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x65, 0x78, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0c, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x22, 0x61, 0x0a,
	0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a,
	0x0a, 0x28, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61,
	0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x9b, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a,
	0x0a, 0x28, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61,
	0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8f,
	0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4f, 0x0a, 0x08, 0x6c, 0x69, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x08,
	0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x54, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd8, 0x01, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x6c, 0x69, 0x73,
	0x74, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x09, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x64, 0x12, 0x52, 0x0a,
	0x07, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x65, 0x78, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x22, 0xac, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x52, 0x0a, 0x07,
	0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67,
	0x22, 0x57, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x69, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xdc, 0x01, 0x0a, 0x17, 0x53, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x71, 0x0a, 0x13, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x48, 0x00, 0x52, 0x12, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x1a, 0x0a, 0x18, 0x53, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x62, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x32, 0xa6, 0x1d, 0x0a, 0x13, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x48, 0x75, 0x62, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xe9, 0x01, 0x0a,
	0x11, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x73, 0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x65,
	0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x47, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x83, 0x02, 0x0a, 0x14, 0x4c, 0x69, 0x73,
	0x74, 0x4f, 0x72, 0x67, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x73, 0x12, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x65, 0x78,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x4f, 0x72, 0x67, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x48, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72, 0x67, 0x44,
	0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x58, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x12, 0x41, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0xda,
	0x41, 0x0c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xd6,
	0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x65,
	0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x22, 0x45, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xfb, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x45,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x65, 0x78, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x22,
	0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x3a,
	0x0d, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0xda, 0x41,
	0x14, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x65, 0x78, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x8e, 0x02, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x45, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x22, 0x77, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x55, 0x32, 0x44, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x45,
	0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0d, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0xda, 0x41, 0x19, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xba, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x45, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x45, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x38, 0x2a, 0x36, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0xe5, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x52, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x12,
	0x41, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xd2, 0x01, 0x0a, 0x0a,
	0x47, 0x65, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x22, 0x50,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x12, 0x41, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x69,
	0x73, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0xeb, 0x01, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x65,
	0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x22, 0x63, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x4c, 0x22, 0x41, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x45,
	0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6c, 0x69, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x3a, 0x07, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0xda, 0x41, 0x0e,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x12, 0xf8,
	0x01, 0x0a, 0x0d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67,
	0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x65, 0x78, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x65,
	0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x22, 0x70, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x54, 0x32,
	0x49, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6c, 0x69, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x07, 0x6c, 0x69, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0xda, 0x41, 0x13, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2c, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xbb, 0x01, 0x0a, 0x0d, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x40, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4c,
	0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x50, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x2a, 0x41, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xfc, 0x01, 0x0a, 0x10, 0x53, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x62, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x43, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x62, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x65, 0x78,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x22,
	0x4b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x3a, 0x01, 0x2a, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xf8, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x49, 0x61,
	0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x22, 0xac, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xa5, 0x01, 0x22, 0x47, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3a, 0x01, 0x2a, 0x5a, 0x57, 0x22, 0x52, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x67, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3a, 0x01,
	0x2a, 0x12, 0xf8, 0x01, 0x0a, 0x0c, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0xac, 0x01,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0xa5, 0x01, 0x22, 0x47, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x3a, 0x01, 0x2a, 0x5a, 0x57, 0x22, 0x52, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74,
	0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3a, 0x01, 0x2a, 0x12, 0xa4, 0x02, 0x0a,
	0x12, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65,
	0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xb8, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0xb1, 0x01, 0x22, 0x4d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x74,
	0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x3a, 0x01, 0x2a, 0x5a, 0x5d, 0x22, 0x58, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x65,
	0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x3a, 0x01, 0x2a, 0x1a, 0x78, 0xca, 0x41, 0x1b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x57, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2c, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xf3, 0x02,
	0x0a, 0x2e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x42, 0x11, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x56, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f,
	0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x3b, 0x64, 0x61, 0x74, 0x61, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0xaa, 0x02, 0x2a,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x69, 0x67,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x2a, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x5c, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5c,
	0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x42, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x3a, 0x3a, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x3a,
	0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x41, 0x48, 0x0a, 0x1f, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x25, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x7d, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescOnce sync.Once
	file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescData = file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDesc
)

func file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescGZIP() []byte {
	file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescOnce.Do(func() {
		file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescData)
	})
	return file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDescData
}

var file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes = make([]protoimpl.MessageInfo, 24)
var file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_goTypes = []interface{}{
	(Listing_State)(0),                    // 0: google.cloud.bigquery.dataexchange.v1beta1.Listing.State
	(*DataExchange)(nil),                  // 1: google.cloud.bigquery.dataexchange.v1beta1.DataExchange
	(*DataProvider)(nil),                  // 2: google.cloud.bigquery.dataexchange.v1beta1.DataProvider
	(*Publisher)(nil),                     // 3: google.cloud.bigquery.dataexchange.v1beta1.Publisher
	(*DestinationDatasetReference)(nil),   // 4: google.cloud.bigquery.dataexchange.v1beta1.DestinationDatasetReference
	(*DestinationDataset)(nil),            // 5: google.cloud.bigquery.dataexchange.v1beta1.DestinationDataset
	(*Listing)(nil),                       // 6: google.cloud.bigquery.dataexchange.v1beta1.Listing
	(*ListDataExchangesRequest)(nil),      // 7: google.cloud.bigquery.dataexchange.v1beta1.ListDataExchangesRequest
	(*ListDataExchangesResponse)(nil),     // 8: google.cloud.bigquery.dataexchange.v1beta1.ListDataExchangesResponse
	(*ListOrgDataExchangesRequest)(nil),   // 9: google.cloud.bigquery.dataexchange.v1beta1.ListOrgDataExchangesRequest
	(*ListOrgDataExchangesResponse)(nil),  // 10: google.cloud.bigquery.dataexchange.v1beta1.ListOrgDataExchangesResponse
	(*GetDataExchangeRequest)(nil),        // 11: google.cloud.bigquery.dataexchange.v1beta1.GetDataExchangeRequest
	(*CreateDataExchangeRequest)(nil),     // 12: google.cloud.bigquery.dataexchange.v1beta1.CreateDataExchangeRequest
	(*UpdateDataExchangeRequest)(nil),     // 13: google.cloud.bigquery.dataexchange.v1beta1.UpdateDataExchangeRequest
	(*DeleteDataExchangeRequest)(nil),     // 14: google.cloud.bigquery.dataexchange.v1beta1.DeleteDataExchangeRequest
	(*ListListingsRequest)(nil),           // 15: google.cloud.bigquery.dataexchange.v1beta1.ListListingsRequest
	(*ListListingsResponse)(nil),          // 16: google.cloud.bigquery.dataexchange.v1beta1.ListListingsResponse
	(*GetListingRequest)(nil),             // 17: google.cloud.bigquery.dataexchange.v1beta1.GetListingRequest
	(*CreateListingRequest)(nil),          // 18: google.cloud.bigquery.dataexchange.v1beta1.CreateListingRequest
	(*UpdateListingRequest)(nil),          // 19: google.cloud.bigquery.dataexchange.v1beta1.UpdateListingRequest
	(*DeleteListingRequest)(nil),          // 20: google.cloud.bigquery.dataexchange.v1beta1.DeleteListingRequest
	(*SubscribeListingRequest)(nil),       // 21: google.cloud.bigquery.dataexchange.v1beta1.SubscribeListingRequest
	(*SubscribeListingResponse)(nil),      // 22: google.cloud.bigquery.dataexchange.v1beta1.SubscribeListingResponse
	nil,                                   // 23: google.cloud.bigquery.dataexchange.v1beta1.DestinationDataset.LabelsEntry
	(*Listing_BigQueryDatasetSource)(nil), // 24: google.cloud.bigquery.dataexchange.v1beta1.Listing.BigQueryDatasetSource
	(*wrapperspb.StringValue)(nil),        // 25: google.protobuf.StringValue
	(common.Category)(0),                  // 26: google.cloud.bigquery.dataexchange.common.Category
	(*fieldmaskpb.FieldMask)(nil),         // 27: google.protobuf.FieldMask
	(*v1.GetIamPolicyRequest)(nil),        // 28: google.iam.v1.GetIamPolicyRequest
	(*v1.SetIamPolicyRequest)(nil),        // 29: google.iam.v1.SetIamPolicyRequest
	(*v1.TestIamPermissionsRequest)(nil),  // 30: google.iam.v1.TestIamPermissionsRequest
	(*emptypb.Empty)(nil),                 // 31: google.protobuf.Empty
	(*v1.Policy)(nil),                     // 32: google.iam.v1.Policy
	(*v1.TestIamPermissionsResponse)(nil), // 33: google.iam.v1.TestIamPermissionsResponse
}
var file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_depIdxs = []int32{
	4,  // 0: google.cloud.bigquery.dataexchange.v1beta1.DestinationDataset.dataset_reference:type_name -> google.cloud.bigquery.dataexchange.v1beta1.DestinationDatasetReference
	25, // 1: google.cloud.bigquery.dataexchange.v1beta1.DestinationDataset.friendly_name:type_name -> google.protobuf.StringValue
	25, // 2: google.cloud.bigquery.dataexchange.v1beta1.DestinationDataset.description:type_name -> google.protobuf.StringValue
	23, // 3: google.cloud.bigquery.dataexchange.v1beta1.DestinationDataset.labels:type_name -> google.cloud.bigquery.dataexchange.v1beta1.DestinationDataset.LabelsEntry
	24, // 4: google.cloud.bigquery.dataexchange.v1beta1.Listing.bigquery_dataset:type_name -> google.cloud.bigquery.dataexchange.v1beta1.Listing.BigQueryDatasetSource
	0,  // 5: google.cloud.bigquery.dataexchange.v1beta1.Listing.state:type_name -> google.cloud.bigquery.dataexchange.v1beta1.Listing.State
	2,  // 6: google.cloud.bigquery.dataexchange.v1beta1.Listing.data_provider:type_name -> google.cloud.bigquery.dataexchange.v1beta1.DataProvider
	26, // 7: google.cloud.bigquery.dataexchange.v1beta1.Listing.categories:type_name -> google.cloud.bigquery.dataexchange.common.Category
	3,  // 8: google.cloud.bigquery.dataexchange.v1beta1.Listing.publisher:type_name -> google.cloud.bigquery.dataexchange.v1beta1.Publisher
	1,  // 9: google.cloud.bigquery.dataexchange.v1beta1.ListDataExchangesResponse.data_exchanges:type_name -> google.cloud.bigquery.dataexchange.v1beta1.DataExchange
	1,  // 10: google.cloud.bigquery.dataexchange.v1beta1.ListOrgDataExchangesResponse.data_exchanges:type_name -> google.cloud.bigquery.dataexchange.v1beta1.DataExchange
	1,  // 11: google.cloud.bigquery.dataexchange.v1beta1.CreateDataExchangeRequest.data_exchange:type_name -> google.cloud.bigquery.dataexchange.v1beta1.DataExchange
	27, // 12: google.cloud.bigquery.dataexchange.v1beta1.UpdateDataExchangeRequest.update_mask:type_name -> google.protobuf.FieldMask
	1,  // 13: google.cloud.bigquery.dataexchange.v1beta1.UpdateDataExchangeRequest.data_exchange:type_name -> google.cloud.bigquery.dataexchange.v1beta1.DataExchange
	6,  // 14: google.cloud.bigquery.dataexchange.v1beta1.ListListingsResponse.listings:type_name -> google.cloud.bigquery.dataexchange.v1beta1.Listing
	6,  // 15: google.cloud.bigquery.dataexchange.v1beta1.CreateListingRequest.listing:type_name -> google.cloud.bigquery.dataexchange.v1beta1.Listing
	27, // 16: google.cloud.bigquery.dataexchange.v1beta1.UpdateListingRequest.update_mask:type_name -> google.protobuf.FieldMask
	6,  // 17: google.cloud.bigquery.dataexchange.v1beta1.UpdateListingRequest.listing:type_name -> google.cloud.bigquery.dataexchange.v1beta1.Listing
	5,  // 18: google.cloud.bigquery.dataexchange.v1beta1.SubscribeListingRequest.destination_dataset:type_name -> google.cloud.bigquery.dataexchange.v1beta1.DestinationDataset
	7,  // 19: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.ListDataExchanges:input_type -> google.cloud.bigquery.dataexchange.v1beta1.ListDataExchangesRequest
	9,  // 20: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.ListOrgDataExchanges:input_type -> google.cloud.bigquery.dataexchange.v1beta1.ListOrgDataExchangesRequest
	11, // 21: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.GetDataExchange:input_type -> google.cloud.bigquery.dataexchange.v1beta1.GetDataExchangeRequest
	12, // 22: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.CreateDataExchange:input_type -> google.cloud.bigquery.dataexchange.v1beta1.CreateDataExchangeRequest
	13, // 23: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.UpdateDataExchange:input_type -> google.cloud.bigquery.dataexchange.v1beta1.UpdateDataExchangeRequest
	14, // 24: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.DeleteDataExchange:input_type -> google.cloud.bigquery.dataexchange.v1beta1.DeleteDataExchangeRequest
	15, // 25: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.ListListings:input_type -> google.cloud.bigquery.dataexchange.v1beta1.ListListingsRequest
	17, // 26: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.GetListing:input_type -> google.cloud.bigquery.dataexchange.v1beta1.GetListingRequest
	18, // 27: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.CreateListing:input_type -> google.cloud.bigquery.dataexchange.v1beta1.CreateListingRequest
	19, // 28: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.UpdateListing:input_type -> google.cloud.bigquery.dataexchange.v1beta1.UpdateListingRequest
	20, // 29: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.DeleteListing:input_type -> google.cloud.bigquery.dataexchange.v1beta1.DeleteListingRequest
	21, // 30: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.SubscribeListing:input_type -> google.cloud.bigquery.dataexchange.v1beta1.SubscribeListingRequest
	28, // 31: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.GetIamPolicy:input_type -> google.iam.v1.GetIamPolicyRequest
	29, // 32: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.SetIamPolicy:input_type -> google.iam.v1.SetIamPolicyRequest
	30, // 33: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.TestIamPermissions:input_type -> google.iam.v1.TestIamPermissionsRequest
	8,  // 34: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.ListDataExchanges:output_type -> google.cloud.bigquery.dataexchange.v1beta1.ListDataExchangesResponse
	10, // 35: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.ListOrgDataExchanges:output_type -> google.cloud.bigquery.dataexchange.v1beta1.ListOrgDataExchangesResponse
	1,  // 36: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.GetDataExchange:output_type -> google.cloud.bigquery.dataexchange.v1beta1.DataExchange
	1,  // 37: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.CreateDataExchange:output_type -> google.cloud.bigquery.dataexchange.v1beta1.DataExchange
	1,  // 38: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.UpdateDataExchange:output_type -> google.cloud.bigquery.dataexchange.v1beta1.DataExchange
	31, // 39: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.DeleteDataExchange:output_type -> google.protobuf.Empty
	16, // 40: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.ListListings:output_type -> google.cloud.bigquery.dataexchange.v1beta1.ListListingsResponse
	6,  // 41: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.GetListing:output_type -> google.cloud.bigquery.dataexchange.v1beta1.Listing
	6,  // 42: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.CreateListing:output_type -> google.cloud.bigquery.dataexchange.v1beta1.Listing
	6,  // 43: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.UpdateListing:output_type -> google.cloud.bigquery.dataexchange.v1beta1.Listing
	31, // 44: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.DeleteListing:output_type -> google.protobuf.Empty
	22, // 45: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.SubscribeListing:output_type -> google.cloud.bigquery.dataexchange.v1beta1.SubscribeListingResponse
	32, // 46: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.GetIamPolicy:output_type -> google.iam.v1.Policy
	32, // 47: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.SetIamPolicy:output_type -> google.iam.v1.Policy
	33, // 48: google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService.TestIamPermissions:output_type -> google.iam.v1.TestIamPermissionsResponse
	34, // [34:49] is the sub-list for method output_type
	19, // [19:34] is the sub-list for method input_type
	19, // [19:19] is the sub-list for extension type_name
	19, // [19:19] is the sub-list for extension extendee
	0,  // [0:19] is the sub-list for field type_name
}

func init() { file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_init() }
func file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_init() {
	if File_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataExchange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataProvider); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Publisher); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DestinationDatasetReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DestinationDataset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Listing); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDataExchangesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDataExchangesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListOrgDataExchangesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListOrgDataExchangesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDataExchangeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDataExchangeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateDataExchangeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDataExchangeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListListingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListListingsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetListingRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateListingRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateListingRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteListingRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubscribeListingRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubscribeListingResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Listing_BigQueryDatasetSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*Listing_BigqueryDataset)(nil),
	}
	file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes[20].OneofWrappers = []interface{}{
		(*SubscribeListingRequest_DestinationDataset)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   24,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_goTypes,
		DependencyIndexes: file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_depIdxs,
		EnumInfos:         file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_enumTypes,
		MessageInfos:      file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_msgTypes,
	}.Build()
	File_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto = out.File
	file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_rawDesc = nil
	file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_goTypes = nil
	file_google_cloud_bigquery_dataexchange_v1beta1_dataexchange_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AnalyticsHubServiceClient is the client API for AnalyticsHubService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AnalyticsHubServiceClient interface {
	// Lists DataExchanges in a given project and location.
	ListDataExchanges(ctx context.Context, in *ListDataExchangesRequest, opts ...grpc.CallOption) (*ListDataExchangesResponse, error)
	// Lists DataExchanges from projects in a given organization and location.
	ListOrgDataExchanges(ctx context.Context, in *ListOrgDataExchangesRequest, opts ...grpc.CallOption) (*ListOrgDataExchangesResponse, error)
	// Gets details of a single DataExchange.
	GetDataExchange(ctx context.Context, in *GetDataExchangeRequest, opts ...grpc.CallOption) (*DataExchange, error)
	// Creates a new DataExchange in a given project and location.
	CreateDataExchange(ctx context.Context, in *CreateDataExchangeRequest, opts ...grpc.CallOption) (*DataExchange, error)
	// Updates the parameters of a single DataExchange.
	UpdateDataExchange(ctx context.Context, in *UpdateDataExchangeRequest, opts ...grpc.CallOption) (*DataExchange, error)
	// Deletes a single DataExchange.
	DeleteDataExchange(ctx context.Context, in *DeleteDataExchangeRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists Listings in a given project and location.
	ListListings(ctx context.Context, in *ListListingsRequest, opts ...grpc.CallOption) (*ListListingsResponse, error)
	// Gets details of a single Listing.
	GetListing(ctx context.Context, in *GetListingRequest, opts ...grpc.CallOption) (*Listing, error)
	// Creates a new Listing in a given project and location.
	CreateListing(ctx context.Context, in *CreateListingRequest, opts ...grpc.CallOption) (*Listing, error)
	// Updates the parameters of a single Listing.
	UpdateListing(ctx context.Context, in *UpdateListingRequest, opts ...grpc.CallOption) (*Listing, error)
	// Deletes a single Listing, as long as there are no subscriptions
	// associated with the source of this Listing.
	DeleteListing(ctx context.Context, in *DeleteListingRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Subscribes to a single Listing.
	//
	// Data Exchange currently supports one type of Listing: a BigQuery dataset.
	// Upon subscription to a Listing for a BigQuery dataset, Data Exchange
	// creates a linked dataset in the subscriber's project.
	SubscribeListing(ctx context.Context, in *SubscribeListingRequest, opts ...grpc.CallOption) (*SubscribeListingResponse, error)
	// Gets the IAM policy for a dataExchange or a listing.
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Sets the IAM policy for a dataExchange or a listing.
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Returns the permissions that a caller has on a specified dataExchange or
	// listing.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
}

type analyticsHubServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAnalyticsHubServiceClient(cc grpc.ClientConnInterface) AnalyticsHubServiceClient {
	return &analyticsHubServiceClient{cc}
}

func (c *analyticsHubServiceClient) ListDataExchanges(ctx context.Context, in *ListDataExchangesRequest, opts ...grpc.CallOption) (*ListDataExchangesResponse, error) {
	out := new(ListDataExchangesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/ListDataExchanges", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) ListOrgDataExchanges(ctx context.Context, in *ListOrgDataExchangesRequest, opts ...grpc.CallOption) (*ListOrgDataExchangesResponse, error) {
	out := new(ListOrgDataExchangesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/ListOrgDataExchanges", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) GetDataExchange(ctx context.Context, in *GetDataExchangeRequest, opts ...grpc.CallOption) (*DataExchange, error) {
	out := new(DataExchange)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/GetDataExchange", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) CreateDataExchange(ctx context.Context, in *CreateDataExchangeRequest, opts ...grpc.CallOption) (*DataExchange, error) {
	out := new(DataExchange)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/CreateDataExchange", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) UpdateDataExchange(ctx context.Context, in *UpdateDataExchangeRequest, opts ...grpc.CallOption) (*DataExchange, error) {
	out := new(DataExchange)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/UpdateDataExchange", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) DeleteDataExchange(ctx context.Context, in *DeleteDataExchangeRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/DeleteDataExchange", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) ListListings(ctx context.Context, in *ListListingsRequest, opts ...grpc.CallOption) (*ListListingsResponse, error) {
	out := new(ListListingsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/ListListings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) GetListing(ctx context.Context, in *GetListingRequest, opts ...grpc.CallOption) (*Listing, error) {
	out := new(Listing)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/GetListing", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) CreateListing(ctx context.Context, in *CreateListingRequest, opts ...grpc.CallOption) (*Listing, error) {
	out := new(Listing)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/CreateListing", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) UpdateListing(ctx context.Context, in *UpdateListingRequest, opts ...grpc.CallOption) (*Listing, error) {
	out := new(Listing)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/UpdateListing", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) DeleteListing(ctx context.Context, in *DeleteListingRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/DeleteListing", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) SubscribeListing(ctx context.Context, in *SubscribeListingRequest, opts ...grpc.CallOption) (*SubscribeListingResponse, error) {
	out := new(SubscribeListingResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/SubscribeListing", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AnalyticsHubServiceServer is the server API for AnalyticsHubService service.
type AnalyticsHubServiceServer interface {
	// Lists DataExchanges in a given project and location.
	ListDataExchanges(context.Context, *ListDataExchangesRequest) (*ListDataExchangesResponse, error)
	// Lists DataExchanges from projects in a given organization and location.
	ListOrgDataExchanges(context.Context, *ListOrgDataExchangesRequest) (*ListOrgDataExchangesResponse, error)
	// Gets details of a single DataExchange.
	GetDataExchange(context.Context, *GetDataExchangeRequest) (*DataExchange, error)
	// Creates a new DataExchange in a given project and location.
	CreateDataExchange(context.Context, *CreateDataExchangeRequest) (*DataExchange, error)
	// Updates the parameters of a single DataExchange.
	UpdateDataExchange(context.Context, *UpdateDataExchangeRequest) (*DataExchange, error)
	// Deletes a single DataExchange.
	DeleteDataExchange(context.Context, *DeleteDataExchangeRequest) (*emptypb.Empty, error)
	// Lists Listings in a given project and location.
	ListListings(context.Context, *ListListingsRequest) (*ListListingsResponse, error)
	// Gets details of a single Listing.
	GetListing(context.Context, *GetListingRequest) (*Listing, error)
	// Creates a new Listing in a given project and location.
	CreateListing(context.Context, *CreateListingRequest) (*Listing, error)
	// Updates the parameters of a single Listing.
	UpdateListing(context.Context, *UpdateListingRequest) (*Listing, error)
	// Deletes a single Listing, as long as there are no subscriptions
	// associated with the source of this Listing.
	DeleteListing(context.Context, *DeleteListingRequest) (*emptypb.Empty, error)
	// Subscribes to a single Listing.
	//
	// Data Exchange currently supports one type of Listing: a BigQuery dataset.
	// Upon subscription to a Listing for a BigQuery dataset, Data Exchange
	// creates a linked dataset in the subscriber's project.
	SubscribeListing(context.Context, *SubscribeListingRequest) (*SubscribeListingResponse, error)
	// Gets the IAM policy for a dataExchange or a listing.
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Sets the IAM policy for a dataExchange or a listing.
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Returns the permissions that a caller has on a specified dataExchange or
	// listing.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
}

// UnimplementedAnalyticsHubServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAnalyticsHubServiceServer struct {
}

func (*UnimplementedAnalyticsHubServiceServer) ListDataExchanges(context.Context, *ListDataExchangesRequest) (*ListDataExchangesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDataExchanges not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) ListOrgDataExchanges(context.Context, *ListOrgDataExchangesRequest) (*ListOrgDataExchangesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOrgDataExchanges not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) GetDataExchange(context.Context, *GetDataExchangeRequest) (*DataExchange, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataExchange not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) CreateDataExchange(context.Context, *CreateDataExchangeRequest) (*DataExchange, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDataExchange not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) UpdateDataExchange(context.Context, *UpdateDataExchangeRequest) (*DataExchange, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDataExchange not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) DeleteDataExchange(context.Context, *DeleteDataExchangeRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDataExchange not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) ListListings(context.Context, *ListListingsRequest) (*ListListingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListListings not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) GetListing(context.Context, *GetListingRequest) (*Listing, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetListing not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) CreateListing(context.Context, *CreateListingRequest) (*Listing, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateListing not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) UpdateListing(context.Context, *UpdateListingRequest) (*Listing, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateListing not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) DeleteListing(context.Context, *DeleteListingRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteListing not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) SubscribeListing(context.Context, *SubscribeListingRequest) (*SubscribeListingResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SubscribeListing not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

func RegisterAnalyticsHubServiceServer(s *grpc.Server, srv AnalyticsHubServiceServer) {
	s.RegisterService(&_AnalyticsHubService_serviceDesc, srv)
}

func _AnalyticsHubService_ListDataExchanges_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDataExchangesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).ListDataExchanges(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/ListDataExchanges",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).ListDataExchanges(ctx, req.(*ListDataExchangesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_ListOrgDataExchanges_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOrgDataExchangesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).ListOrgDataExchanges(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/ListOrgDataExchanges",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).ListOrgDataExchanges(ctx, req.(*ListOrgDataExchangesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_GetDataExchange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataExchangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).GetDataExchange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/GetDataExchange",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).GetDataExchange(ctx, req.(*GetDataExchangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_CreateDataExchange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDataExchangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).CreateDataExchange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/CreateDataExchange",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).CreateDataExchange(ctx, req.(*CreateDataExchangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_UpdateDataExchange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDataExchangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).UpdateDataExchange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/UpdateDataExchange",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).UpdateDataExchange(ctx, req.(*UpdateDataExchangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_DeleteDataExchange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDataExchangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).DeleteDataExchange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/DeleteDataExchange",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).DeleteDataExchange(ctx, req.(*DeleteDataExchangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_ListListings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListListingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).ListListings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/ListListings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).ListListings(ctx, req.(*ListListingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_GetListing_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetListingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).GetListing(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/GetListing",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).GetListing(ctx, req.(*GetListingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_CreateListing_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateListingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).CreateListing(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/CreateListing",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).CreateListing(ctx, req.(*CreateListingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_UpdateListing_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateListingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).UpdateListing(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/UpdateListing",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).UpdateListing(ctx, req.(*UpdateListingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_DeleteListing_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteListingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).DeleteListing(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/DeleteListing",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).DeleteListing(ctx, req.(*DeleteListingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_SubscribeListing_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SubscribeListingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).SubscribeListing(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/SubscribeListing",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).SubscribeListing(ctx, req.(*SubscribeListingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AnalyticsHubService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubService",
	HandlerType: (*AnalyticsHubServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListDataExchanges",
			Handler:    _AnalyticsHubService_ListDataExchanges_Handler,
		},
		{
			MethodName: "ListOrgDataExchanges",
			Handler:    _AnalyticsHubService_ListOrgDataExchanges_Handler,
		},
		{
			MethodName: "GetDataExchange",
			Handler:    _AnalyticsHubService_GetDataExchange_Handler,
		},
		{
			MethodName: "CreateDataExchange",
			Handler:    _AnalyticsHubService_CreateDataExchange_Handler,
		},
		{
			MethodName: "UpdateDataExchange",
			Handler:    _AnalyticsHubService_UpdateDataExchange_Handler,
		},
		{
			MethodName: "DeleteDataExchange",
			Handler:    _AnalyticsHubService_DeleteDataExchange_Handler,
		},
		{
			MethodName: "ListListings",
			Handler:    _AnalyticsHubService_ListListings_Handler,
		},
		{
			MethodName: "GetListing",
			Handler:    _AnalyticsHubService_GetListing_Handler,
		},
		{
			MethodName: "CreateListing",
			Handler:    _AnalyticsHubService_CreateListing_Handler,
		},
		{
			MethodName: "UpdateListing",
			Handler:    _AnalyticsHubService_UpdateListing_Handler,
		},
		{
			MethodName: "DeleteListing",
			Handler:    _AnalyticsHubService_DeleteListing_Handler,
		},
		{
			MethodName: "SubscribeListing",
			Handler:    _AnalyticsHubService_SubscribeListing_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _AnalyticsHubService_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _AnalyticsHubService_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _AnalyticsHubService_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/bigquery/dataexchange/v1beta1/dataexchange.proto",
}
