// Copyright 2023 Google Inc. All rights reserved.
// Use of this source code is governed by the Apache 2.0
// license that can be found in the LICENSE file.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.12
// source: search.proto

package search

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoiface "google.golang.org/protobuf/runtime/protoiface"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Scope_Type int32

const (
	Scope_USER_BY_CANONICAL_ID    Scope_Type = 1
	Scope_USER_BY_EMAIL           Scope_Type = 2
	Scope_GROUP_BY_CANONICAL_ID   Scope_Type = 3
	Scope_GROUP_BY_EMAIL          Scope_Type = 4
	Scope_GROUP_BY_DOMAIN         Scope_Type = 5
	Scope_ALL_USERS               Scope_Type = 6
	Scope_ALL_AUTHENTICATED_USERS Scope_Type = 7
)

// Enum value maps for Scope_Type.
var (
	Scope_Type_name = map[int32]string{
		1: "USER_BY_CANONICAL_ID",
		2: "USER_BY_EMAIL",
		3: "GROUP_BY_CANONICAL_ID",
		4: "GROUP_BY_EMAIL",
		5: "GROUP_BY_DOMAIN",
		6: "ALL_USERS",
		7: "ALL_AUTHENTICATED_USERS",
	}
	Scope_Type_value = map[string]int32{
		"USER_BY_CANONICAL_ID":    1,
		"USER_BY_EMAIL":           2,
		"GROUP_BY_CANONICAL_ID":   3,
		"GROUP_BY_EMAIL":          4,
		"GROUP_BY_DOMAIN":         5,
		"ALL_USERS":               6,
		"ALL_AUTHENTICATED_USERS": 7,
	}
)

func (x Scope_Type) Enum() *Scope_Type {
	p := new(Scope_Type)
	*p = x
	return p
}

func (x Scope_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Scope_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_search_proto_enumTypes[0].Descriptor()
}

func (Scope_Type) Type() protoreflect.EnumType {
	return &file_search_proto_enumTypes[0]
}

func (x Scope_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *Scope_Type) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = Scope_Type(num)
	return nil
}

// Deprecated: Use Scope_Type.Descriptor instead.
func (Scope_Type) EnumDescriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{0, 0}
}

type Entry_Permission int32

const (
	Entry_READ         Entry_Permission = 1
	Entry_WRITE        Entry_Permission = 2
	Entry_FULL_CONTROL Entry_Permission = 3
)

// Enum value maps for Entry_Permission.
var (
	Entry_Permission_name = map[int32]string{
		1: "READ",
		2: "WRITE",
		3: "FULL_CONTROL",
	}
	Entry_Permission_value = map[string]int32{
		"READ":         1,
		"WRITE":        2,
		"FULL_CONTROL": 3,
	}
)

func (x Entry_Permission) Enum() *Entry_Permission {
	p := new(Entry_Permission)
	*p = x
	return p
}

func (x Entry_Permission) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Entry_Permission) Descriptor() protoreflect.EnumDescriptor {
	return file_search_proto_enumTypes[1].Descriptor()
}

func (Entry_Permission) Type() protoreflect.EnumType {
	return &file_search_proto_enumTypes[1]
}

func (x Entry_Permission) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *Entry_Permission) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = Entry_Permission(num)
	return nil
}

// Deprecated: Use Entry_Permission.Descriptor instead.
func (Entry_Permission) EnumDescriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{1, 0}
}

type FieldValue_ContentType int32

const (
	FieldValue_TEXT   FieldValue_ContentType = 0
	FieldValue_HTML   FieldValue_ContentType = 1
	FieldValue_ATOM   FieldValue_ContentType = 2
	FieldValue_DATE   FieldValue_ContentType = 3
	FieldValue_NUMBER FieldValue_ContentType = 4
	FieldValue_GEO    FieldValue_ContentType = 5
)

// Enum value maps for FieldValue_ContentType.
var (
	FieldValue_ContentType_name = map[int32]string{
		0: "TEXT",
		1: "HTML",
		2: "ATOM",
		3: "DATE",
		4: "NUMBER",
		5: "GEO",
	}
	FieldValue_ContentType_value = map[string]int32{
		"TEXT":   0,
		"HTML":   1,
		"ATOM":   2,
		"DATE":   3,
		"NUMBER": 4,
		"GEO":    5,
	}
)

func (x FieldValue_ContentType) Enum() *FieldValue_ContentType {
	p := new(FieldValue_ContentType)
	*p = x
	return p
}

func (x FieldValue_ContentType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FieldValue_ContentType) Descriptor() protoreflect.EnumDescriptor {
	return file_search_proto_enumTypes[2].Descriptor()
}

func (FieldValue_ContentType) Type() protoreflect.EnumType {
	return &file_search_proto_enumTypes[2]
}

func (x FieldValue_ContentType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *FieldValue_ContentType) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = FieldValue_ContentType(num)
	return nil
}

// Deprecated: Use FieldValue_ContentType.Descriptor instead.
func (FieldValue_ContentType) EnumDescriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{3, 0}
}

type FacetValue_ContentType int32

const (
	FacetValue_ATOM   FacetValue_ContentType = 2
	FacetValue_NUMBER FacetValue_ContentType = 4
)

// Enum value maps for FacetValue_ContentType.
var (
	FacetValue_ContentType_name = map[int32]string{
		2: "ATOM",
		4: "NUMBER",
	}
	FacetValue_ContentType_value = map[string]int32{
		"ATOM":   2,
		"NUMBER": 4,
	}
)

func (x FacetValue_ContentType) Enum() *FacetValue_ContentType {
	p := new(FacetValue_ContentType)
	*p = x
	return p
}

func (x FacetValue_ContentType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FacetValue_ContentType) Descriptor() protoreflect.EnumDescriptor {
	return file_search_proto_enumTypes[3].Descriptor()
}

func (FacetValue_ContentType) Type() protoreflect.EnumType {
	return &file_search_proto_enumTypes[3]
}

func (x FacetValue_ContentType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *FacetValue_ContentType) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = FacetValue_ContentType(num)
	return nil
}

// Deprecated: Use FacetValue_ContentType.Descriptor instead.
func (FacetValue_ContentType) EnumDescriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{7, 0}
}

type Document_OrderIdSource int32

const (
	Document_DEFAULTED Document_OrderIdSource = 0
	Document_SUPPLIED  Document_OrderIdSource = 1
)

// Enum value maps for Document_OrderIdSource.
var (
	Document_OrderIdSource_name = map[int32]string{
		0: "DEFAULTED",
		1: "SUPPLIED",
	}
	Document_OrderIdSource_value = map[string]int32{
		"DEFAULTED": 0,
		"SUPPLIED":  1,
	}
)

func (x Document_OrderIdSource) Enum() *Document_OrderIdSource {
	p := new(Document_OrderIdSource)
	*p = x
	return p
}

func (x Document_OrderIdSource) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Document_OrderIdSource) Descriptor() protoreflect.EnumDescriptor {
	return file_search_proto_enumTypes[4].Descriptor()
}

func (Document_OrderIdSource) Type() protoreflect.EnumType {
	return &file_search_proto_enumTypes[4]
}

func (x Document_OrderIdSource) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *Document_OrderIdSource) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = Document_OrderIdSource(num)
	return nil
}

// Deprecated: Use Document_OrderIdSource.Descriptor instead.
func (Document_OrderIdSource) EnumDescriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{10, 0}
}

type Document_Storage int32

const (
	Document_DISK Document_Storage = 0
)

// Enum value maps for Document_Storage.
var (
	Document_Storage_name = map[int32]string{
		0: "DISK",
	}
	Document_Storage_value = map[string]int32{
		"DISK": 0,
	}
)

func (x Document_Storage) Enum() *Document_Storage {
	p := new(Document_Storage)
	*p = x
	return p
}

func (x Document_Storage) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Document_Storage) Descriptor() protoreflect.EnumDescriptor {
	return file_search_proto_enumTypes[5].Descriptor()
}

func (Document_Storage) Type() protoreflect.EnumType {
	return &file_search_proto_enumTypes[5]
}

func (x Document_Storage) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *Document_Storage) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = Document_Storage(num)
	return nil
}

// Deprecated: Use Document_Storage.Descriptor instead.
func (Document_Storage) EnumDescriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{10, 1}
}

type SearchServiceError_ErrorCode int32

const (
	SearchServiceError_OK                     SearchServiceError_ErrorCode = 0
	SearchServiceError_INVALID_REQUEST        SearchServiceError_ErrorCode = 1
	SearchServiceError_TRANSIENT_ERROR        SearchServiceError_ErrorCode = 2
	SearchServiceError_INTERNAL_ERROR         SearchServiceError_ErrorCode = 3
	SearchServiceError_PERMISSION_DENIED      SearchServiceError_ErrorCode = 4
	SearchServiceError_TIMEOUT                SearchServiceError_ErrorCode = 5
	SearchServiceError_CONCURRENT_TRANSACTION SearchServiceError_ErrorCode = 6
)

// Enum value maps for SearchServiceError_ErrorCode.
var (
	SearchServiceError_ErrorCode_name = map[int32]string{
		0: "OK",
		1: "INVALID_REQUEST",
		2: "TRANSIENT_ERROR",
		3: "INTERNAL_ERROR",
		4: "PERMISSION_DENIED",
		5: "TIMEOUT",
		6: "CONCURRENT_TRANSACTION",
	}
	SearchServiceError_ErrorCode_value = map[string]int32{
		"OK":                     0,
		"INVALID_REQUEST":        1,
		"TRANSIENT_ERROR":        2,
		"INTERNAL_ERROR":         3,
		"PERMISSION_DENIED":      4,
		"TIMEOUT":                5,
		"CONCURRENT_TRANSACTION": 6,
	}
)

func (x SearchServiceError_ErrorCode) Enum() *SearchServiceError_ErrorCode {
	p := new(SearchServiceError_ErrorCode)
	*p = x
	return p
}

func (x SearchServiceError_ErrorCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchServiceError_ErrorCode) Descriptor() protoreflect.EnumDescriptor {
	return file_search_proto_enumTypes[6].Descriptor()
}

func (SearchServiceError_ErrorCode) Type() protoreflect.EnumType {
	return &file_search_proto_enumTypes[6]
}

func (x SearchServiceError_ErrorCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *SearchServiceError_ErrorCode) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = SearchServiceError_ErrorCode(num)
	return nil
}

// Deprecated: Use SearchServiceError_ErrorCode.Descriptor instead.
func (SearchServiceError_ErrorCode) EnumDescriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{11, 0}
}

type IndexSpec_Consistency int32

const (
	IndexSpec_GLOBAL       IndexSpec_Consistency = 0
	IndexSpec_PER_DOCUMENT IndexSpec_Consistency = 1
)

// Enum value maps for IndexSpec_Consistency.
var (
	IndexSpec_Consistency_name = map[int32]string{
		0: "GLOBAL",
		1: "PER_DOCUMENT",
	}
	IndexSpec_Consistency_value = map[string]int32{
		"GLOBAL":       0,
		"PER_DOCUMENT": 1,
	}
)

func (x IndexSpec_Consistency) Enum() *IndexSpec_Consistency {
	p := new(IndexSpec_Consistency)
	*p = x
	return p
}

func (x IndexSpec_Consistency) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IndexSpec_Consistency) Descriptor() protoreflect.EnumDescriptor {
	return file_search_proto_enumTypes[7].Descriptor()
}

func (IndexSpec_Consistency) Type() protoreflect.EnumType {
	return &file_search_proto_enumTypes[7]
}

func (x IndexSpec_Consistency) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *IndexSpec_Consistency) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = IndexSpec_Consistency(num)
	return nil
}

// Deprecated: Use IndexSpec_Consistency.Descriptor instead.
func (IndexSpec_Consistency) EnumDescriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{13, 0}
}

type IndexSpec_Source int32

const (
	IndexSpec_SEARCH        IndexSpec_Source = 0
	IndexSpec_DATASTORE     IndexSpec_Source = 1
	IndexSpec_CLOUD_STORAGE IndexSpec_Source = 2
)

// Enum value maps for IndexSpec_Source.
var (
	IndexSpec_Source_name = map[int32]string{
		0: "SEARCH",
		1: "DATASTORE",
		2: "CLOUD_STORAGE",
	}
	IndexSpec_Source_value = map[string]int32{
		"SEARCH":        0,
		"DATASTORE":     1,
		"CLOUD_STORAGE": 2,
	}
)

func (x IndexSpec_Source) Enum() *IndexSpec_Source {
	p := new(IndexSpec_Source)
	*p = x
	return p
}

func (x IndexSpec_Source) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IndexSpec_Source) Descriptor() protoreflect.EnumDescriptor {
	return file_search_proto_enumTypes[8].Descriptor()
}

func (IndexSpec_Source) Type() protoreflect.EnumType {
	return &file_search_proto_enumTypes[8]
}

func (x IndexSpec_Source) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *IndexSpec_Source) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = IndexSpec_Source(num)
	return nil
}

// Deprecated: Use IndexSpec_Source.Descriptor instead.
func (IndexSpec_Source) EnumDescriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{13, 1}
}

type IndexSpec_Mode int32

const (
	IndexSpec_PRIORITY   IndexSpec_Mode = 0
	IndexSpec_BACKGROUND IndexSpec_Mode = 1
)

// Enum value maps for IndexSpec_Mode.
var (
	IndexSpec_Mode_name = map[int32]string{
		0: "PRIORITY",
		1: "BACKGROUND",
	}
	IndexSpec_Mode_value = map[string]int32{
		"PRIORITY":   0,
		"BACKGROUND": 1,
	}
)

func (x IndexSpec_Mode) Enum() *IndexSpec_Mode {
	p := new(IndexSpec_Mode)
	*p = x
	return p
}

func (x IndexSpec_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IndexSpec_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_search_proto_enumTypes[9].Descriptor()
}

func (IndexSpec_Mode) Type() protoreflect.EnumType {
	return &file_search_proto_enumTypes[9]
}

func (x IndexSpec_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *IndexSpec_Mode) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = IndexSpec_Mode(num)
	return nil
}

// Deprecated: Use IndexSpec_Mode.Descriptor instead.
func (IndexSpec_Mode) EnumDescriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{13, 2}
}

type IndexDocumentParams_Freshness int32

const (
	IndexDocumentParams_SYNCHRONOUSLY   IndexDocumentParams_Freshness = 0
	IndexDocumentParams_WHEN_CONVENIENT IndexDocumentParams_Freshness = 1
)

// Enum value maps for IndexDocumentParams_Freshness.
var (
	IndexDocumentParams_Freshness_name = map[int32]string{
		0: "SYNCHRONOUSLY",
		1: "WHEN_CONVENIENT",
	}
	IndexDocumentParams_Freshness_value = map[string]int32{
		"SYNCHRONOUSLY":   0,
		"WHEN_CONVENIENT": 1,
	}
)

func (x IndexDocumentParams_Freshness) Enum() *IndexDocumentParams_Freshness {
	p := new(IndexDocumentParams_Freshness)
	*p = x
	return p
}

func (x IndexDocumentParams_Freshness) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IndexDocumentParams_Freshness) Descriptor() protoreflect.EnumDescriptor {
	return file_search_proto_enumTypes[10].Descriptor()
}

func (IndexDocumentParams_Freshness) Type() protoreflect.EnumType {
	return &file_search_proto_enumTypes[10]
}

func (x IndexDocumentParams_Freshness) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *IndexDocumentParams_Freshness) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = IndexDocumentParams_Freshness(num)
	return nil
}

// Deprecated: Use IndexDocumentParams_Freshness.Descriptor instead.
func (IndexDocumentParams_Freshness) EnumDescriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{15, 0}
}

type ScorerSpec_Scorer int32

const (
	ScorerSpec_RESCORING_MATCH_SCORER ScorerSpec_Scorer = 0
	ScorerSpec_MATCH_SCORER           ScorerSpec_Scorer = 2
)

// Enum value maps for ScorerSpec_Scorer.
var (
	ScorerSpec_Scorer_name = map[int32]string{
		0: "RESCORING_MATCH_SCORER",
		2: "MATCH_SCORER",
	}
	ScorerSpec_Scorer_value = map[string]int32{
		"RESCORING_MATCH_SCORER": 0,
		"MATCH_SCORER":           2,
	}
)

func (x ScorerSpec_Scorer) Enum() *ScorerSpec_Scorer {
	p := new(ScorerSpec_Scorer)
	*p = x
	return p
}

func (x ScorerSpec_Scorer) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ScorerSpec_Scorer) Descriptor() protoreflect.EnumDescriptor {
	return file_search_proto_enumTypes[11].Descriptor()
}

func (ScorerSpec_Scorer) Type() protoreflect.EnumType {
	return &file_search_proto_enumTypes[11]
}

func (x ScorerSpec_Scorer) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *ScorerSpec_Scorer) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = ScorerSpec_Scorer(num)
	return nil
}

// Deprecated: Use ScorerSpec_Scorer.Descriptor instead.
func (ScorerSpec_Scorer) EnumDescriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{31, 0}
}

type SearchParams_CursorType int32

const (
	SearchParams_NONE       SearchParams_CursorType = 0
	SearchParams_SINGLE     SearchParams_CursorType = 1
	SearchParams_PER_RESULT SearchParams_CursorType = 2
)

// Enum value maps for SearchParams_CursorType.
var (
	SearchParams_CursorType_name = map[int32]string{
		0: "NONE",
		1: "SINGLE",
		2: "PER_RESULT",
	}
	SearchParams_CursorType_value = map[string]int32{
		"NONE":       0,
		"SINGLE":     1,
		"PER_RESULT": 2,
	}
)

func (x SearchParams_CursorType) Enum() *SearchParams_CursorType {
	p := new(SearchParams_CursorType)
	*p = x
	return p
}

func (x SearchParams_CursorType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchParams_CursorType) Descriptor() protoreflect.EnumDescriptor {
	return file_search_proto_enumTypes[12].Descriptor()
}

func (SearchParams_CursorType) Type() protoreflect.EnumType {
	return &file_search_proto_enumTypes[12]
}

func (x SearchParams_CursorType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *SearchParams_CursorType) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = SearchParams_CursorType(num)
	return nil
}

// Deprecated: Use SearchParams_CursorType.Descriptor instead.
func (SearchParams_CursorType) EnumDescriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{38, 0}
}

type SearchParams_ParsingMode int32

const (
	SearchParams_STRICT  SearchParams_ParsingMode = 0
	SearchParams_RELAXED SearchParams_ParsingMode = 1
)

// Enum value maps for SearchParams_ParsingMode.
var (
	SearchParams_ParsingMode_name = map[int32]string{
		0: "STRICT",
		1: "RELAXED",
	}
	SearchParams_ParsingMode_value = map[string]int32{
		"STRICT":  0,
		"RELAXED": 1,
	}
)

func (x SearchParams_ParsingMode) Enum() *SearchParams_ParsingMode {
	p := new(SearchParams_ParsingMode)
	*p = x
	return p
}

func (x SearchParams_ParsingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchParams_ParsingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_search_proto_enumTypes[13].Descriptor()
}

func (SearchParams_ParsingMode) Type() protoreflect.EnumType {
	return &file_search_proto_enumTypes[13]
}

func (x SearchParams_ParsingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *SearchParams_ParsingMode) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = SearchParams_ParsingMode(num)
	return nil
}

// Deprecated: Use SearchParams_ParsingMode.Descriptor instead.
func (SearchParams_ParsingMode) EnumDescriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{38, 1}
}

type Scope struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type  *Scope_Type `protobuf:"varint,1,opt,name=type,enum=search.v2.Scope_Type" json:"type,omitempty"`
	Value *string     `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
}

func (x *Scope) Reset() {
	*x = Scope{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Scope) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Scope) ProtoMessage() {}

func (x *Scope) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Scope.ProtoReflect.Descriptor instead.
func (*Scope) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{0}
}

func (x *Scope) GetType() Scope_Type {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return Scope_USER_BY_CANONICAL_ID
}

func (x *Scope) GetValue() string {
	if x != nil && x.Value != nil {
		return *x.Value
	}
	return ""
}

type Entry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Scope       *Scope            `protobuf:"bytes,1,opt,name=scope" json:"scope,omitempty"`
	Permission  *Entry_Permission `protobuf:"varint,2,opt,name=permission,enum=search.v2.Entry_Permission" json:"permission,omitempty"`
	DisplayName *string           `protobuf:"bytes,3,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
}

func (x *Entry) Reset() {
	*x = Entry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Entry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Entry) ProtoMessage() {}

func (x *Entry) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Entry.ProtoReflect.Descriptor instead.
func (*Entry) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{1}
}

func (x *Entry) GetScope() *Scope {
	if x != nil {
		return x.Scope
	}
	return nil
}

func (x *Entry) GetPermission() Entry_Permission {
	if x != nil && x.Permission != nil {
		return *x.Permission
	}
	return Entry_READ
}

func (x *Entry) GetDisplayName() string {
	if x != nil && x.DisplayName != nil {
		return *x.DisplayName
	}
	return ""
}

type AccessControlList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Owner   *string  `protobuf:"bytes,1,opt,name=owner" json:"owner,omitempty"`
	Entries []*Entry `protobuf:"bytes,2,rep,name=entries" json:"entries,omitempty"`
}

func (x *AccessControlList) Reset() {
	*x = AccessControlList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessControlList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessControlList) ProtoMessage() {}

func (x *AccessControlList) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessControlList.ProtoReflect.Descriptor instead.
func (*AccessControlList) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{2}
}

func (x *AccessControlList) GetOwner() string {
	if x != nil && x.Owner != nil {
		return *x.Owner
	}
	return ""
}

func (x *AccessControlList) GetEntries() []*Entry {
	if x != nil {
		return x.Entries
	}
	return nil
}

type FieldValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type        *FieldValue_ContentType `protobuf:"varint,1,opt,name=type,enum=search.v2.FieldValue_ContentType,def=0" json:"type,omitempty"`
	Language    *string                 `protobuf:"bytes,2,opt,name=language,def=en" json:"language,omitempty"`
	StringValue *string                 `protobuf:"bytes,3,opt,name=string_value,json=stringValue" json:"string_value,omitempty"`
	Geo         *FieldValue_Geo         `protobuf:"group,4,opt,name=Geo,json=geo" json:"geo,omitempty"`
}

// Default values for FieldValue fields.
const (
	Default_FieldValue_Type     = FieldValue_TEXT
	Default_FieldValue_Language = string("en")
)

func (x *FieldValue) Reset() {
	*x = FieldValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FieldValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldValue) ProtoMessage() {}

func (x *FieldValue) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldValue.ProtoReflect.Descriptor instead.
func (*FieldValue) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{3}
}

func (x *FieldValue) GetType() FieldValue_ContentType {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return Default_FieldValue_Type
}

func (x *FieldValue) GetLanguage() string {
	if x != nil && x.Language != nil {
		return *x.Language
	}
	return Default_FieldValue_Language
}

func (x *FieldValue) GetStringValue() string {
	if x != nil && x.StringValue != nil {
		return *x.StringValue
	}
	return ""
}

func (x *FieldValue) GetGeo() *FieldValue_Geo {
	if x != nil {
		return x.Geo
	}
	return nil
}

type Field struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name  *string     `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Value *FieldValue `protobuf:"bytes,2,req,name=value" json:"value,omitempty"`
}

func (x *Field) Reset() {
	*x = Field{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Field) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Field) ProtoMessage() {}

func (x *Field) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Field.ProtoReflect.Descriptor instead.
func (*Field) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{4}
}

func (x *Field) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *Field) GetValue() *FieldValue {
	if x != nil {
		return x.Value
	}
	return nil
}

type FieldTypes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name *string                  `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Type []FieldValue_ContentType `protobuf:"varint,2,rep,name=type,enum=search.v2.FieldValue_ContentType" json:"type,omitempty"`
}

func (x *FieldTypes) Reset() {
	*x = FieldTypes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FieldTypes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldTypes) ProtoMessage() {}

func (x *FieldTypes) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldTypes.ProtoReflect.Descriptor instead.
func (*FieldTypes) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{5}
}

func (x *FieldTypes) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *FieldTypes) GetType() []FieldValue_ContentType {
	if x != nil {
		return x.Type
	}
	return nil
}

type IndexShardSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PrevNumShards            []int32 `protobuf:"varint,1,rep,name=prev_num_shards,json=prevNumShards" json:"prev_num_shards,omitempty"`
	NumShards                *int32  `protobuf:"varint,2,req,name=num_shards,json=numShards,def=1" json:"num_shards,omitempty"`
	PrevNumShardsSearchFalse []int32 `protobuf:"varint,3,rep,name=prev_num_shards_search_false,json=prevNumShardsSearchFalse" json:"prev_num_shards_search_false,omitempty"`
	LocalReplica             *string `protobuf:"bytes,4,opt,name=local_replica,json=localReplica,def=" json:"local_replica,omitempty"`
}

// Default values for IndexShardSettings fields.
const (
	Default_IndexShardSettings_NumShards    = int32(1)
	Default_IndexShardSettings_LocalReplica = string("")
)

func (x *IndexShardSettings) Reset() {
	*x = IndexShardSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IndexShardSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IndexShardSettings) ProtoMessage() {}

func (x *IndexShardSettings) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IndexShardSettings.ProtoReflect.Descriptor instead.
func (*IndexShardSettings) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{6}
}

func (x *IndexShardSettings) GetPrevNumShards() []int32 {
	if x != nil {
		return x.PrevNumShards
	}
	return nil
}

func (x *IndexShardSettings) GetNumShards() int32 {
	if x != nil && x.NumShards != nil {
		return *x.NumShards
	}
	return Default_IndexShardSettings_NumShards
}

func (x *IndexShardSettings) GetPrevNumShardsSearchFalse() []int32 {
	if x != nil {
		return x.PrevNumShardsSearchFalse
	}
	return nil
}

func (x *IndexShardSettings) GetLocalReplica() string {
	if x != nil && x.LocalReplica != nil {
		return *x.LocalReplica
	}
	return Default_IndexShardSettings_LocalReplica
}

type FacetValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type        *FacetValue_ContentType `protobuf:"varint,1,opt,name=type,enum=search.v2.FacetValue_ContentType,def=2" json:"type,omitempty"`
	StringValue *string                 `protobuf:"bytes,3,opt,name=string_value,json=stringValue" json:"string_value,omitempty"`
}

// Default values for FacetValue fields.
const (
	Default_FacetValue_Type = FacetValue_ATOM
)

func (x *FacetValue) Reset() {
	*x = FacetValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FacetValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FacetValue) ProtoMessage() {}

func (x *FacetValue) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FacetValue.ProtoReflect.Descriptor instead.
func (*FacetValue) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{7}
}

func (x *FacetValue) GetType() FacetValue_ContentType {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return Default_FacetValue_Type
}

func (x *FacetValue) GetStringValue() string {
	if x != nil && x.StringValue != nil {
		return *x.StringValue
	}
	return ""
}

type Facet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name  *string     `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Value *FacetValue `protobuf:"bytes,2,req,name=value" json:"value,omitempty"`
}

func (x *Facet) Reset() {
	*x = Facet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Facet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Facet) ProtoMessage() {}

func (x *Facet) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Facet.ProtoReflect.Descriptor instead.
func (*Facet) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{8}
}

func (x *Facet) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *Facet) GetValue() *FacetValue {
	if x != nil {
		return x.Value
	}
	return nil
}

type DocumentMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version            *int64 `protobuf:"varint,1,opt,name=version" json:"version,omitempty"`
	CommittedStVersion *int64 `protobuf:"varint,2,opt,name=committed_st_version,json=committedStVersion" json:"committed_st_version,omitempty"`
}

func (x *DocumentMetadata) Reset() {
	*x = DocumentMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DocumentMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DocumentMetadata) ProtoMessage() {}

func (x *DocumentMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DocumentMetadata.ProtoReflect.Descriptor instead.
func (*DocumentMetadata) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{9}
}

func (x *DocumentMetadata) GetVersion() int64 {
	if x != nil && x.Version != nil {
		return *x.Version
	}
	return 0
}

func (x *DocumentMetadata) GetCommittedStVersion() int64 {
	if x != nil && x.CommittedStVersion != nil {
		return *x.CommittedStVersion
	}
	return 0
}

type Document struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id            *string                 `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Language      *string                 `protobuf:"bytes,2,opt,name=language,def=en" json:"language,omitempty"`
	Field         []*Field                `protobuf:"bytes,3,rep,name=field" json:"field,omitempty"`
	OrderId       *int32                  `protobuf:"varint,4,opt,name=order_id,json=orderId" json:"order_id,omitempty"`
	OrderIdSource *Document_OrderIdSource `protobuf:"varint,6,opt,name=order_id_source,json=orderIdSource,enum=search.v2.Document_OrderIdSource,def=1" json:"order_id_source,omitempty"`
	Storage       *Document_Storage       `protobuf:"varint,5,opt,name=storage,enum=search.v2.Document_Storage,def=0" json:"storage,omitempty"`
	Facet         []*Facet                `protobuf:"bytes,8,rep,name=facet" json:"facet,omitempty"`
}

// Default values for Document fields.
const (
	Default_Document_Language      = string("en")
	Default_Document_OrderIdSource = Document_SUPPLIED
	Default_Document_Storage       = Document_DISK
)

func (x *Document) Reset() {
	*x = Document{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document) ProtoMessage() {}

func (x *Document) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document.ProtoReflect.Descriptor instead.
func (*Document) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{10}
}

func (x *Document) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *Document) GetLanguage() string {
	if x != nil && x.Language != nil {
		return *x.Language
	}
	return Default_Document_Language
}

func (x *Document) GetField() []*Field {
	if x != nil {
		return x.Field
	}
	return nil
}

func (x *Document) GetOrderId() int32 {
	if x != nil && x.OrderId != nil {
		return *x.OrderId
	}
	return 0
}

func (x *Document) GetOrderIdSource() Document_OrderIdSource {
	if x != nil && x.OrderIdSource != nil {
		return *x.OrderIdSource
	}
	return Default_Document_OrderIdSource
}

func (x *Document) GetStorage() Document_Storage {
	if x != nil && x.Storage != nil {
		return *x.Storage
	}
	return Default_Document_Storage
}

func (x *Document) GetFacet() []*Facet {
	if x != nil {
		return x.Facet
	}
	return nil
}

type SearchServiceError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SearchServiceError) Reset() {
	*x = SearchServiceError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchServiceError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchServiceError) ProtoMessage() {}

func (x *SearchServiceError) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchServiceError.ProtoReflect.Descriptor instead.
func (*SearchServiceError) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{11}
}

type RequestStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Code          *SearchServiceError_ErrorCode `protobuf:"varint,1,req,name=code,enum=search.v2.SearchServiceError_ErrorCode" json:"code,omitempty"`
	ErrorDetail   *string                       `protobuf:"bytes,2,opt,name=error_detail,json=errorDetail" json:"error_detail,omitempty"`
	CanonicalCode *int32                        `protobuf:"varint,3,opt,name=canonical_code,json=canonicalCode" json:"canonical_code,omitempty"`
}

func (x *RequestStatus) Reset() {
	*x = RequestStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RequestStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RequestStatus) ProtoMessage() {}

func (x *RequestStatus) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RequestStatus.ProtoReflect.Descriptor instead.
func (*RequestStatus) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{12}
}

func (x *RequestStatus) GetCode() SearchServiceError_ErrorCode {
	if x != nil && x.Code != nil {
		return *x.Code
	}
	return SearchServiceError_OK
}

func (x *RequestStatus) GetErrorDetail() string {
	if x != nil && x.ErrorDetail != nil {
		return *x.ErrorDetail
	}
	return ""
}

func (x *RequestStatus) GetCanonicalCode() int32 {
	if x != nil && x.CanonicalCode != nil {
		return *x.CanonicalCode
	}
	return 0
}

type IndexSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name        *string                `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Consistency *IndexSpec_Consistency `protobuf:"varint,2,opt,name=consistency,enum=search.v2.IndexSpec_Consistency,def=1" json:"consistency,omitempty"`
	Namespace   *string                `protobuf:"bytes,3,opt,name=namespace" json:"namespace,omitempty"`
	Version     *int32                 `protobuf:"varint,4,opt,name=version" json:"version,omitempty"`
	Source      *IndexSpec_Source      `protobuf:"varint,5,opt,name=source,enum=search.v2.IndexSpec_Source,def=0" json:"source,omitempty"`
	Mode        *IndexSpec_Mode        `protobuf:"varint,6,opt,name=mode,enum=search.v2.IndexSpec_Mode,def=0" json:"mode,omitempty"`
}

// Default values for IndexSpec fields.
const (
	Default_IndexSpec_Consistency = IndexSpec_PER_DOCUMENT
	Default_IndexSpec_Source      = IndexSpec_SEARCH
	Default_IndexSpec_Mode        = IndexSpec_PRIORITY
)

func (x *IndexSpec) Reset() {
	*x = IndexSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IndexSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IndexSpec) ProtoMessage() {}

func (x *IndexSpec) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IndexSpec.ProtoReflect.Descriptor instead.
func (*IndexSpec) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{13}
}

func (x *IndexSpec) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *IndexSpec) GetConsistency() IndexSpec_Consistency {
	if x != nil && x.Consistency != nil {
		return *x.Consistency
	}
	return Default_IndexSpec_Consistency
}

func (x *IndexSpec) GetNamespace() string {
	if x != nil && x.Namespace != nil {
		return *x.Namespace
	}
	return ""
}

func (x *IndexSpec) GetVersion() int32 {
	if x != nil && x.Version != nil {
		return *x.Version
	}
	return 0
}

func (x *IndexSpec) GetSource() IndexSpec_Source {
	if x != nil && x.Source != nil {
		return *x.Source
	}
	return Default_IndexSpec_Source
}

func (x *IndexSpec) GetMode() IndexSpec_Mode {
	if x != nil && x.Mode != nil {
		return *x.Mode
	}
	return Default_IndexSpec_Mode
}

type IndexMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	IndexSpec *IndexSpec             `protobuf:"bytes,1,req,name=index_spec,json=indexSpec" json:"index_spec,omitempty"`
	Field     []*FieldTypes          `protobuf:"bytes,2,rep,name=field" json:"field,omitempty"`
	Storage   *IndexMetadata_Storage `protobuf:"bytes,3,opt,name=storage" json:"storage,omitempty"`
}

func (x *IndexMetadata) Reset() {
	*x = IndexMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IndexMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IndexMetadata) ProtoMessage() {}

func (x *IndexMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IndexMetadata.ProtoReflect.Descriptor instead.
func (*IndexMetadata) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{14}
}

func (x *IndexMetadata) GetIndexSpec() *IndexSpec {
	if x != nil {
		return x.IndexSpec
	}
	return nil
}

func (x *IndexMetadata) GetField() []*FieldTypes {
	if x != nil {
		return x.Field
	}
	return nil
}

func (x *IndexMetadata) GetStorage() *IndexMetadata_Storage {
	if x != nil {
		return x.Storage
	}
	return nil
}

type IndexDocumentParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Document []*Document `protobuf:"bytes,1,rep,name=document" json:"document,omitempty"`
	// Deprecated: Do not use.
	Freshness *IndexDocumentParams_Freshness `protobuf:"varint,2,opt,name=freshness,enum=search.v2.IndexDocumentParams_Freshness,def=0" json:"freshness,omitempty"`
	IndexSpec *IndexSpec                     `protobuf:"bytes,3,req,name=index_spec,json=indexSpec" json:"index_spec,omitempty"`
}

// Default values for IndexDocumentParams fields.
const (
	Default_IndexDocumentParams_Freshness = IndexDocumentParams_SYNCHRONOUSLY
)

func (x *IndexDocumentParams) Reset() {
	*x = IndexDocumentParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IndexDocumentParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IndexDocumentParams) ProtoMessage() {}

func (x *IndexDocumentParams) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IndexDocumentParams.ProtoReflect.Descriptor instead.
func (*IndexDocumentParams) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{15}
}

func (x *IndexDocumentParams) GetDocument() []*Document {
	if x != nil {
		return x.Document
	}
	return nil
}

// Deprecated: Do not use.
func (x *IndexDocumentParams) GetFreshness() IndexDocumentParams_Freshness {
	if x != nil && x.Freshness != nil {
		return *x.Freshness
	}
	return Default_IndexDocumentParams_Freshness
}

func (x *IndexDocumentParams) GetIndexSpec() *IndexSpec {
	if x != nil {
		return x.IndexSpec
	}
	return nil
}

type IndexDocumentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Params *IndexDocumentParams `protobuf:"bytes,1,req,name=params" json:"params,omitempty"`
	AppId  []byte               `protobuf:"bytes,3,opt,name=app_id,json=appId" json:"app_id,omitempty"`
}

func (x *IndexDocumentRequest) Reset() {
	*x = IndexDocumentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IndexDocumentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IndexDocumentRequest) ProtoMessage() {}

func (x *IndexDocumentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IndexDocumentRequest.ProtoReflect.Descriptor instead.
func (*IndexDocumentRequest) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{16}
}

func (x *IndexDocumentRequest) GetParams() *IndexDocumentParams {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *IndexDocumentRequest) GetAppId() []byte {
	if x != nil {
		return x.AppId
	}
	return nil
}

type IndexDocumentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status []*RequestStatus `protobuf:"bytes,1,rep,name=status" json:"status,omitempty"`
	DocId  []string         `protobuf:"bytes,2,rep,name=doc_id,json=docId" json:"doc_id,omitempty"`
}

func (x *IndexDocumentResponse) Reset() {
	*x = IndexDocumentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IndexDocumentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IndexDocumentResponse) ProtoMessage() {}

func (x *IndexDocumentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IndexDocumentResponse.ProtoReflect.Descriptor instead.
func (*IndexDocumentResponse) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{17}
}

func (x *IndexDocumentResponse) GetStatus() []*RequestStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *IndexDocumentResponse) GetDocId() []string {
	if x != nil {
		return x.DocId
	}
	return nil
}

type DeleteDocumentParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DocId     []string   `protobuf:"bytes,1,rep,name=doc_id,json=docId" json:"doc_id,omitempty"`
	IndexSpec *IndexSpec `protobuf:"bytes,2,req,name=index_spec,json=indexSpec" json:"index_spec,omitempty"`
}

func (x *DeleteDocumentParams) Reset() {
	*x = DeleteDocumentParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDocumentParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDocumentParams) ProtoMessage() {}

func (x *DeleteDocumentParams) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDocumentParams.ProtoReflect.Descriptor instead.
func (*DeleteDocumentParams) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{18}
}

func (x *DeleteDocumentParams) GetDocId() []string {
	if x != nil {
		return x.DocId
	}
	return nil
}

func (x *DeleteDocumentParams) GetIndexSpec() *IndexSpec {
	if x != nil {
		return x.IndexSpec
	}
	return nil
}

type DeleteDocumentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Params *DeleteDocumentParams `protobuf:"bytes,1,req,name=params" json:"params,omitempty"`
	AppId  []byte                `protobuf:"bytes,3,opt,name=app_id,json=appId" json:"app_id,omitempty"`
}

func (x *DeleteDocumentRequest) Reset() {
	*x = DeleteDocumentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDocumentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDocumentRequest) ProtoMessage() {}

func (x *DeleteDocumentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDocumentRequest.ProtoReflect.Descriptor instead.
func (*DeleteDocumentRequest) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{19}
}

func (x *DeleteDocumentRequest) GetParams() *DeleteDocumentParams {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *DeleteDocumentRequest) GetAppId() []byte {
	if x != nil {
		return x.AppId
	}
	return nil
}

type DeleteDocumentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status []*RequestStatus `protobuf:"bytes,1,rep,name=status" json:"status,omitempty"`
}

func (x *DeleteDocumentResponse) Reset() {
	*x = DeleteDocumentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDocumentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDocumentResponse) ProtoMessage() {}

func (x *DeleteDocumentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDocumentResponse.ProtoReflect.Descriptor instead.
func (*DeleteDocumentResponse) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{20}
}

func (x *DeleteDocumentResponse) GetStatus() []*RequestStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

type ListDocumentsParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	IndexSpec       *IndexSpec `protobuf:"bytes,1,req,name=index_spec,json=indexSpec" json:"index_spec,omitempty"`
	StartDocId      *string    `protobuf:"bytes,2,opt,name=start_doc_id,json=startDocId" json:"start_doc_id,omitempty"`
	IncludeStartDoc *bool      `protobuf:"varint,3,opt,name=include_start_doc,json=includeStartDoc,def=1" json:"include_start_doc,omitempty"`
	Limit           *int32     `protobuf:"varint,4,opt,name=limit,def=100" json:"limit,omitempty"`
	KeysOnly        *bool      `protobuf:"varint,5,opt,name=keys_only,json=keysOnly" json:"keys_only,omitempty"`
}

// Default values for ListDocumentsParams fields.
const (
	Default_ListDocumentsParams_IncludeStartDoc = bool(true)
	Default_ListDocumentsParams_Limit           = int32(100)
)

func (x *ListDocumentsParams) Reset() {
	*x = ListDocumentsParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDocumentsParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDocumentsParams) ProtoMessage() {}

func (x *ListDocumentsParams) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDocumentsParams.ProtoReflect.Descriptor instead.
func (*ListDocumentsParams) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{21}
}

func (x *ListDocumentsParams) GetIndexSpec() *IndexSpec {
	if x != nil {
		return x.IndexSpec
	}
	return nil
}

func (x *ListDocumentsParams) GetStartDocId() string {
	if x != nil && x.StartDocId != nil {
		return *x.StartDocId
	}
	return ""
}

func (x *ListDocumentsParams) GetIncludeStartDoc() bool {
	if x != nil && x.IncludeStartDoc != nil {
		return *x.IncludeStartDoc
	}
	return Default_ListDocumentsParams_IncludeStartDoc
}

func (x *ListDocumentsParams) GetLimit() int32 {
	if x != nil && x.Limit != nil {
		return *x.Limit
	}
	return Default_ListDocumentsParams_Limit
}

func (x *ListDocumentsParams) GetKeysOnly() bool {
	if x != nil && x.KeysOnly != nil {
		return *x.KeysOnly
	}
	return false
}

type ListDocumentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Params *ListDocumentsParams `protobuf:"bytes,1,req,name=params" json:"params,omitempty"`
	AppId  []byte               `protobuf:"bytes,2,opt,name=app_id,json=appId" json:"app_id,omitempty"`
}

func (x *ListDocumentsRequest) Reset() {
	*x = ListDocumentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDocumentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDocumentsRequest) ProtoMessage() {}

func (x *ListDocumentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDocumentsRequest.ProtoReflect.Descriptor instead.
func (*ListDocumentsRequest) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{22}
}

func (x *ListDocumentsRequest) GetParams() *ListDocumentsParams {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *ListDocumentsRequest) GetAppId() []byte {
	if x != nil {
		return x.AppId
	}
	return nil
}

type ListDocumentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status   *RequestStatus `protobuf:"bytes,1,req,name=status" json:"status,omitempty"`
	Document []*Document    `protobuf:"bytes,2,rep,name=document" json:"document,omitempty"`
}

func (x *ListDocumentsResponse) Reset() {
	*x = ListDocumentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDocumentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDocumentsResponse) ProtoMessage() {}

func (x *ListDocumentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDocumentsResponse.ProtoReflect.Descriptor instead.
func (*ListDocumentsResponse) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{23}
}

func (x *ListDocumentsResponse) GetStatus() *RequestStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *ListDocumentsResponse) GetDocument() []*Document {
	if x != nil {
		return x.Document
	}
	return nil
}

type ListIndexesParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	FetchSchema       *bool             `protobuf:"varint,1,opt,name=fetch_schema,json=fetchSchema" json:"fetch_schema,omitempty"`
	Limit             *int32            `protobuf:"varint,2,opt,name=limit,def=20" json:"limit,omitempty"`
	Namespace         *string           `protobuf:"bytes,3,opt,name=namespace" json:"namespace,omitempty"`
	StartIndexName    *string           `protobuf:"bytes,4,opt,name=start_index_name,json=startIndexName" json:"start_index_name,omitempty"`
	IncludeStartIndex *bool             `protobuf:"varint,5,opt,name=include_start_index,json=includeStartIndex,def=1" json:"include_start_index,omitempty"`
	IndexNamePrefix   *string           `protobuf:"bytes,6,opt,name=index_name_prefix,json=indexNamePrefix" json:"index_name_prefix,omitempty"`
	Offset            *int32            `protobuf:"varint,7,opt,name=offset" json:"offset,omitempty"`
	Source            *IndexSpec_Source `protobuf:"varint,8,opt,name=source,enum=search.v2.IndexSpec_Source,def=0" json:"source,omitempty"`
}

// Default values for ListIndexesParams fields.
const (
	Default_ListIndexesParams_Limit             = int32(20)
	Default_ListIndexesParams_IncludeStartIndex = bool(true)
	Default_ListIndexesParams_Source            = IndexSpec_SEARCH
)

func (x *ListIndexesParams) Reset() {
	*x = ListIndexesParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIndexesParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIndexesParams) ProtoMessage() {}

func (x *ListIndexesParams) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIndexesParams.ProtoReflect.Descriptor instead.
func (*ListIndexesParams) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{24}
}

func (x *ListIndexesParams) GetFetchSchema() bool {
	if x != nil && x.FetchSchema != nil {
		return *x.FetchSchema
	}
	return false
}

func (x *ListIndexesParams) GetLimit() int32 {
	if x != nil && x.Limit != nil {
		return *x.Limit
	}
	return Default_ListIndexesParams_Limit
}

func (x *ListIndexesParams) GetNamespace() string {
	if x != nil && x.Namespace != nil {
		return *x.Namespace
	}
	return ""
}

func (x *ListIndexesParams) GetStartIndexName() string {
	if x != nil && x.StartIndexName != nil {
		return *x.StartIndexName
	}
	return ""
}

func (x *ListIndexesParams) GetIncludeStartIndex() bool {
	if x != nil && x.IncludeStartIndex != nil {
		return *x.IncludeStartIndex
	}
	return Default_ListIndexesParams_IncludeStartIndex
}

func (x *ListIndexesParams) GetIndexNamePrefix() string {
	if x != nil && x.IndexNamePrefix != nil {
		return *x.IndexNamePrefix
	}
	return ""
}

func (x *ListIndexesParams) GetOffset() int32 {
	if x != nil && x.Offset != nil {
		return *x.Offset
	}
	return 0
}

func (x *ListIndexesParams) GetSource() IndexSpec_Source {
	if x != nil && x.Source != nil {
		return *x.Source
	}
	return Default_ListIndexesParams_Source
}

type ListIndexesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Params *ListIndexesParams `protobuf:"bytes,1,req,name=params" json:"params,omitempty"`
	AppId  []byte             `protobuf:"bytes,3,opt,name=app_id,json=appId" json:"app_id,omitempty"`
}

func (x *ListIndexesRequest) Reset() {
	*x = ListIndexesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIndexesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIndexesRequest) ProtoMessage() {}

func (x *ListIndexesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIndexesRequest.ProtoReflect.Descriptor instead.
func (*ListIndexesRequest) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{25}
}

func (x *ListIndexesRequest) GetParams() *ListIndexesParams {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *ListIndexesRequest) GetAppId() []byte {
	if x != nil {
		return x.AppId
	}
	return nil
}

type ListIndexesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status        *RequestStatus   `protobuf:"bytes,1,req,name=status" json:"status,omitempty"`
	IndexMetadata []*IndexMetadata `protobuf:"bytes,2,rep,name=index_metadata,json=indexMetadata" json:"index_metadata,omitempty"`
}

func (x *ListIndexesResponse) Reset() {
	*x = ListIndexesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIndexesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIndexesResponse) ProtoMessage() {}

func (x *ListIndexesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIndexesResponse.ProtoReflect.Descriptor instead.
func (*ListIndexesResponse) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{26}
}

func (x *ListIndexesResponse) GetStatus() *RequestStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *ListIndexesResponse) GetIndexMetadata() []*IndexMetadata {
	if x != nil {
		return x.IndexMetadata
	}
	return nil
}

type DeleteSchemaParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Source    *IndexSpec_Source `protobuf:"varint,1,opt,name=source,enum=search.v2.IndexSpec_Source,def=0" json:"source,omitempty"`
	IndexSpec []*IndexSpec      `protobuf:"bytes,2,rep,name=index_spec,json=indexSpec" json:"index_spec,omitempty"`
}

// Default values for DeleteSchemaParams fields.
const (
	Default_DeleteSchemaParams_Source = IndexSpec_SEARCH
)

func (x *DeleteSchemaParams) Reset() {
	*x = DeleteSchemaParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSchemaParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSchemaParams) ProtoMessage() {}

func (x *DeleteSchemaParams) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSchemaParams.ProtoReflect.Descriptor instead.
func (*DeleteSchemaParams) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{27}
}

func (x *DeleteSchemaParams) GetSource() IndexSpec_Source {
	if x != nil && x.Source != nil {
		return *x.Source
	}
	return Default_DeleteSchemaParams_Source
}

func (x *DeleteSchemaParams) GetIndexSpec() []*IndexSpec {
	if x != nil {
		return x.IndexSpec
	}
	return nil
}

type DeleteSchemaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Params *DeleteSchemaParams `protobuf:"bytes,1,req,name=params" json:"params,omitempty"`
	AppId  []byte              `protobuf:"bytes,3,opt,name=app_id,json=appId" json:"app_id,omitempty"`
}

func (x *DeleteSchemaRequest) Reset() {
	*x = DeleteSchemaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSchemaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSchemaRequest) ProtoMessage() {}

func (x *DeleteSchemaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSchemaRequest.ProtoReflect.Descriptor instead.
func (*DeleteSchemaRequest) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{28}
}

func (x *DeleteSchemaRequest) GetParams() *DeleteSchemaParams {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *DeleteSchemaRequest) GetAppId() []byte {
	if x != nil {
		return x.AppId
	}
	return nil
}

type DeleteSchemaResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status []*RequestStatus `protobuf:"bytes,1,rep,name=status" json:"status,omitempty"`
}

func (x *DeleteSchemaResponse) Reset() {
	*x = DeleteSchemaResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSchemaResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSchemaResponse) ProtoMessage() {}

func (x *DeleteSchemaResponse) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSchemaResponse.ProtoReflect.Descriptor instead.
func (*DeleteSchemaResponse) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{29}
}

func (x *DeleteSchemaResponse) GetStatus() []*RequestStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

type SortSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SortExpression      *string  `protobuf:"bytes,1,req,name=sort_expression,json=sortExpression" json:"sort_expression,omitempty"`
	SortDescending      *bool    `protobuf:"varint,2,opt,name=sort_descending,json=sortDescending,def=1" json:"sort_descending,omitempty"`
	DefaultValueText    *string  `protobuf:"bytes,4,opt,name=default_value_text,json=defaultValueText" json:"default_value_text,omitempty"`
	DefaultValueNumeric *float64 `protobuf:"fixed64,5,opt,name=default_value_numeric,json=defaultValueNumeric" json:"default_value_numeric,omitempty"`
}

// Default values for SortSpec fields.
const (
	Default_SortSpec_SortDescending = bool(true)
)

func (x *SortSpec) Reset() {
	*x = SortSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SortSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SortSpec) ProtoMessage() {}

func (x *SortSpec) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SortSpec.ProtoReflect.Descriptor instead.
func (*SortSpec) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{30}
}

func (x *SortSpec) GetSortExpression() string {
	if x != nil && x.SortExpression != nil {
		return *x.SortExpression
	}
	return ""
}

func (x *SortSpec) GetSortDescending() bool {
	if x != nil && x.SortDescending != nil {
		return *x.SortDescending
	}
	return Default_SortSpec_SortDescending
}

func (x *SortSpec) GetDefaultValueText() string {
	if x != nil && x.DefaultValueText != nil {
		return *x.DefaultValueText
	}
	return ""
}

func (x *SortSpec) GetDefaultValueNumeric() float64 {
	if x != nil && x.DefaultValueNumeric != nil {
		return *x.DefaultValueNumeric
	}
	return 0
}

type ScorerSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Scorer                *ScorerSpec_Scorer `protobuf:"varint,1,opt,name=scorer,enum=search.v2.ScorerSpec_Scorer,def=2" json:"scorer,omitempty"`
	Limit                 *int32             `protobuf:"varint,2,opt,name=limit,def=1000" json:"limit,omitempty"`
	MatchScorerParameters *string            `protobuf:"bytes,9,opt,name=match_scorer_parameters,json=matchScorerParameters" json:"match_scorer_parameters,omitempty"`
}

// Default values for ScorerSpec fields.
const (
	Default_ScorerSpec_Scorer = ScorerSpec_MATCH_SCORER
	Default_ScorerSpec_Limit  = int32(1000)
)

func (x *ScorerSpec) Reset() {
	*x = ScorerSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ScorerSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScorerSpec) ProtoMessage() {}

func (x *ScorerSpec) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScorerSpec.ProtoReflect.Descriptor instead.
func (*ScorerSpec) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{31}
}

func (x *ScorerSpec) GetScorer() ScorerSpec_Scorer {
	if x != nil && x.Scorer != nil {
		return *x.Scorer
	}
	return Default_ScorerSpec_Scorer
}

func (x *ScorerSpec) GetLimit() int32 {
	if x != nil && x.Limit != nil {
		return *x.Limit
	}
	return Default_ScorerSpec_Limit
}

func (x *ScorerSpec) GetMatchScorerParameters() string {
	if x != nil && x.MatchScorerParameters != nil {
		return *x.MatchScorerParameters
	}
	return ""
}

type FieldSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name       []string                `protobuf:"bytes,1,rep,name=name" json:"name,omitempty"`
	Expression []*FieldSpec_Expression `protobuf:"group,2,rep,name=Expression,json=expression" json:"expression,omitempty"`
}

func (x *FieldSpec) Reset() {
	*x = FieldSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FieldSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldSpec) ProtoMessage() {}

func (x *FieldSpec) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldSpec.ProtoReflect.Descriptor instead.
func (*FieldSpec) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{32}
}

func (x *FieldSpec) GetName() []string {
	if x != nil {
		return x.Name
	}
	return nil
}

func (x *FieldSpec) GetExpression() []*FieldSpec_Expression {
	if x != nil {
		return x.Expression
	}
	return nil
}

type FacetRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name  *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Start *string `protobuf:"bytes,2,opt,name=start" json:"start,omitempty"`
	End   *string `protobuf:"bytes,3,opt,name=end" json:"end,omitempty"`
}

func (x *FacetRange) Reset() {
	*x = FacetRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FacetRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FacetRange) ProtoMessage() {}

func (x *FacetRange) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FacetRange.ProtoReflect.Descriptor instead.
func (*FacetRange) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{33}
}

func (x *FacetRange) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *FacetRange) GetStart() string {
	if x != nil && x.Start != nil {
		return *x.Start
	}
	return ""
}

func (x *FacetRange) GetEnd() string {
	if x != nil && x.End != nil {
		return *x.End
	}
	return ""
}

type FacetRequestParam struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ValueLimit      *int32        `protobuf:"varint,1,opt,name=value_limit,json=valueLimit" json:"value_limit,omitempty"`
	Range           []*FacetRange `protobuf:"bytes,2,rep,name=range" json:"range,omitempty"`
	ValueConstraint []string      `protobuf:"bytes,3,rep,name=value_constraint,json=valueConstraint" json:"value_constraint,omitempty"`
}

func (x *FacetRequestParam) Reset() {
	*x = FacetRequestParam{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FacetRequestParam) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FacetRequestParam) ProtoMessage() {}

func (x *FacetRequestParam) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FacetRequestParam.ProtoReflect.Descriptor instead.
func (*FacetRequestParam) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{34}
}

func (x *FacetRequestParam) GetValueLimit() int32 {
	if x != nil && x.ValueLimit != nil {
		return *x.ValueLimit
	}
	return 0
}

func (x *FacetRequestParam) GetRange() []*FacetRange {
	if x != nil {
		return x.Range
	}
	return nil
}

func (x *FacetRequestParam) GetValueConstraint() []string {
	if x != nil {
		return x.ValueConstraint
	}
	return nil
}

type FacetAutoDetectParam struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ValueLimit *int32 `protobuf:"varint,1,opt,name=value_limit,json=valueLimit,def=10" json:"value_limit,omitempty"`
}

// Default values for FacetAutoDetectParam fields.
const (
	Default_FacetAutoDetectParam_ValueLimit = int32(10)
)

func (x *FacetAutoDetectParam) Reset() {
	*x = FacetAutoDetectParam{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FacetAutoDetectParam) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FacetAutoDetectParam) ProtoMessage() {}

func (x *FacetAutoDetectParam) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FacetAutoDetectParam.ProtoReflect.Descriptor instead.
func (*FacetAutoDetectParam) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{35}
}

func (x *FacetAutoDetectParam) GetValueLimit() int32 {
	if x != nil && x.ValueLimit != nil {
		return *x.ValueLimit
	}
	return Default_FacetAutoDetectParam_ValueLimit
}

type FacetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name   *string            `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Params *FacetRequestParam `protobuf:"bytes,2,opt,name=params" json:"params,omitempty"`
}

func (x *FacetRequest) Reset() {
	*x = FacetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FacetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FacetRequest) ProtoMessage() {}

func (x *FacetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FacetRequest.ProtoReflect.Descriptor instead.
func (*FacetRequest) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{36}
}

func (x *FacetRequest) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *FacetRequest) GetParams() *FacetRequestParam {
	if x != nil {
		return x.Params
	}
	return nil
}

type FacetRefinement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name  *string                `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Value *string                `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	Range *FacetRefinement_Range `protobuf:"bytes,3,opt,name=range" json:"range,omitempty"`
}

func (x *FacetRefinement) Reset() {
	*x = FacetRefinement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FacetRefinement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FacetRefinement) ProtoMessage() {}

func (x *FacetRefinement) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FacetRefinement.ProtoReflect.Descriptor instead.
func (*FacetRefinement) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{37}
}

func (x *FacetRefinement) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *FacetRefinement) GetValue() string {
	if x != nil && x.Value != nil {
		return *x.Value
	}
	return ""
}

func (x *FacetRefinement) GetRange() *FacetRefinement_Range {
	if x != nil {
		return x.Range
	}
	return nil
}

type SearchParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	IndexSpec              *IndexSpec                `protobuf:"bytes,1,req,name=index_spec,json=indexSpec" json:"index_spec,omitempty"`
	Query                  *string                   `protobuf:"bytes,2,req,name=query" json:"query,omitempty"`
	Cursor                 *string                   `protobuf:"bytes,4,opt,name=cursor" json:"cursor,omitempty"`
	Offset                 *int32                    `protobuf:"varint,11,opt,name=offset" json:"offset,omitempty"`
	CursorType             *SearchParams_CursorType  `protobuf:"varint,5,opt,name=cursor_type,json=cursorType,enum=search.v2.SearchParams_CursorType,def=0" json:"cursor_type,omitempty"`
	Limit                  *int32                    `protobuf:"varint,6,opt,name=limit,def=20" json:"limit,omitempty"`
	MatchedCountAccuracy   *int32                    `protobuf:"varint,7,opt,name=matched_count_accuracy,json=matchedCountAccuracy" json:"matched_count_accuracy,omitempty"`
	SortSpec               []*SortSpec               `protobuf:"bytes,8,rep,name=sort_spec,json=sortSpec" json:"sort_spec,omitempty"`
	ScorerSpec             *ScorerSpec               `protobuf:"bytes,9,opt,name=scorer_spec,json=scorerSpec" json:"scorer_spec,omitempty"`
	FieldSpec              *FieldSpec                `protobuf:"bytes,10,opt,name=field_spec,json=fieldSpec" json:"field_spec,omitempty"`
	KeysOnly               *bool                     `protobuf:"varint,12,opt,name=keys_only,json=keysOnly" json:"keys_only,omitempty"`
	ParsingMode            *SearchParams_ParsingMode `protobuf:"varint,13,opt,name=parsing_mode,json=parsingMode,enum=search.v2.SearchParams_ParsingMode,def=0" json:"parsing_mode,omitempty"`
	AutoDiscoverFacetCount *int32                    `protobuf:"varint,15,opt,name=auto_discover_facet_count,json=autoDiscoverFacetCount,def=0" json:"auto_discover_facet_count,omitempty"`
	IncludeFacet           []*FacetRequest           `protobuf:"bytes,16,rep,name=include_facet,json=includeFacet" json:"include_facet,omitempty"`
	FacetRefinement        []*FacetRefinement        `protobuf:"bytes,17,rep,name=facet_refinement,json=facetRefinement" json:"facet_refinement,omitempty"`
	FacetAutoDetectParam   *FacetAutoDetectParam     `protobuf:"bytes,18,opt,name=facet_auto_detect_param,json=facetAutoDetectParam" json:"facet_auto_detect_param,omitempty"`
	FacetDepth             *int32                    `protobuf:"varint,19,opt,name=facet_depth,json=facetDepth,def=1000" json:"facet_depth,omitempty"`
}

// Default values for SearchParams fields.
const (
	Default_SearchParams_CursorType             = SearchParams_NONE
	Default_SearchParams_Limit                  = int32(20)
	Default_SearchParams_ParsingMode            = SearchParams_STRICT
	Default_SearchParams_AutoDiscoverFacetCount = int32(0)
	Default_SearchParams_FacetDepth             = int32(1000)
)

func (x *SearchParams) Reset() {
	*x = SearchParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchParams) ProtoMessage() {}

func (x *SearchParams) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchParams.ProtoReflect.Descriptor instead.
func (*SearchParams) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{38}
}

func (x *SearchParams) GetIndexSpec() *IndexSpec {
	if x != nil {
		return x.IndexSpec
	}
	return nil
}

func (x *SearchParams) GetQuery() string {
	if x != nil && x.Query != nil {
		return *x.Query
	}
	return ""
}

func (x *SearchParams) GetCursor() string {
	if x != nil && x.Cursor != nil {
		return *x.Cursor
	}
	return ""
}

func (x *SearchParams) GetOffset() int32 {
	if x != nil && x.Offset != nil {
		return *x.Offset
	}
	return 0
}

func (x *SearchParams) GetCursorType() SearchParams_CursorType {
	if x != nil && x.CursorType != nil {
		return *x.CursorType
	}
	return Default_SearchParams_CursorType
}

func (x *SearchParams) GetLimit() int32 {
	if x != nil && x.Limit != nil {
		return *x.Limit
	}
	return Default_SearchParams_Limit
}

func (x *SearchParams) GetMatchedCountAccuracy() int32 {
	if x != nil && x.MatchedCountAccuracy != nil {
		return *x.MatchedCountAccuracy
	}
	return 0
}

func (x *SearchParams) GetSortSpec() []*SortSpec {
	if x != nil {
		return x.SortSpec
	}
	return nil
}

func (x *SearchParams) GetScorerSpec() *ScorerSpec {
	if x != nil {
		return x.ScorerSpec
	}
	return nil
}

func (x *SearchParams) GetFieldSpec() *FieldSpec {
	if x != nil {
		return x.FieldSpec
	}
	return nil
}

func (x *SearchParams) GetKeysOnly() bool {
	if x != nil && x.KeysOnly != nil {
		return *x.KeysOnly
	}
	return false
}

func (x *SearchParams) GetParsingMode() SearchParams_ParsingMode {
	if x != nil && x.ParsingMode != nil {
		return *x.ParsingMode
	}
	return Default_SearchParams_ParsingMode
}

func (x *SearchParams) GetAutoDiscoverFacetCount() int32 {
	if x != nil && x.AutoDiscoverFacetCount != nil {
		return *x.AutoDiscoverFacetCount
	}
	return Default_SearchParams_AutoDiscoverFacetCount
}

func (x *SearchParams) GetIncludeFacet() []*FacetRequest {
	if x != nil {
		return x.IncludeFacet
	}
	return nil
}

func (x *SearchParams) GetFacetRefinement() []*FacetRefinement {
	if x != nil {
		return x.FacetRefinement
	}
	return nil
}

func (x *SearchParams) GetFacetAutoDetectParam() *FacetAutoDetectParam {
	if x != nil {
		return x.FacetAutoDetectParam
	}
	return nil
}

func (x *SearchParams) GetFacetDepth() int32 {
	if x != nil && x.FacetDepth != nil {
		return *x.FacetDepth
	}
	return Default_SearchParams_FacetDepth
}

type SearchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Params *SearchParams `protobuf:"bytes,1,req,name=params" json:"params,omitempty"`
	AppId  []byte        `protobuf:"bytes,3,opt,name=app_id,json=appId" json:"app_id,omitempty"`
}

func (x *SearchRequest) Reset() {
	*x = SearchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest) ProtoMessage() {}

func (x *SearchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest.ProtoReflect.Descriptor instead.
func (*SearchRequest) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{39}
}

func (x *SearchRequest) GetParams() *SearchParams {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *SearchRequest) GetAppId() []byte {
	if x != nil {
		return x.AppId
	}
	return nil
}

type FacetResultValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name       *string          `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Count      *int32           `protobuf:"varint,2,req,name=count" json:"count,omitempty"`
	Refinement *FacetRefinement `protobuf:"bytes,3,req,name=refinement" json:"refinement,omitempty"`
}

func (x *FacetResultValue) Reset() {
	*x = FacetResultValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FacetResultValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FacetResultValue) ProtoMessage() {}

func (x *FacetResultValue) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FacetResultValue.ProtoReflect.Descriptor instead.
func (*FacetResultValue) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{40}
}

func (x *FacetResultValue) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *FacetResultValue) GetCount() int32 {
	if x != nil && x.Count != nil {
		return *x.Count
	}
	return 0
}

func (x *FacetResultValue) GetRefinement() *FacetRefinement {
	if x != nil {
		return x.Refinement
	}
	return nil
}

type FacetResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name  *string             `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Value []*FacetResultValue `protobuf:"bytes,2,rep,name=value" json:"value,omitempty"`
}

func (x *FacetResult) Reset() {
	*x = FacetResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FacetResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FacetResult) ProtoMessage() {}

func (x *FacetResult) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FacetResult.ProtoReflect.Descriptor instead.
func (*FacetResult) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{41}
}

func (x *FacetResult) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *FacetResult) GetValue() []*FacetResultValue {
	if x != nil {
		return x.Value
	}
	return nil
}

type SearchResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Document   *Document `protobuf:"bytes,1,req,name=document" json:"document,omitempty"`
	Expression []*Field  `protobuf:"bytes,4,rep,name=expression" json:"expression,omitempty"`
	Score      []float64 `protobuf:"fixed64,2,rep,name=score" json:"score,omitempty"`
	Cursor     *string   `protobuf:"bytes,3,opt,name=cursor" json:"cursor,omitempty"`
}

func (x *SearchResult) Reset() {
	*x = SearchResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResult) ProtoMessage() {}

func (x *SearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResult.ProtoReflect.Descriptor instead.
func (*SearchResult) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{42}
}

func (x *SearchResult) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

func (x *SearchResult) GetExpression() []*Field {
	if x != nil {
		return x.Expression
	}
	return nil
}

func (x *SearchResult) GetScore() []float64 {
	if x != nil {
		return x.Score
	}
	return nil
}

func (x *SearchResult) GetCursor() string {
	if x != nil && x.Cursor != nil {
		return *x.Cursor
	}
	return ""
}

type SearchResponse struct {
	state           protoimpl.MessageState
	sizeCache       protoimpl.SizeCache
	unknownFields   protoimpl.UnknownFields
	extensionFields protoimpl.ExtensionFields

	Result       []*SearchResult `protobuf:"bytes,1,rep,name=result" json:"result,omitempty"`
	MatchedCount *int64          `protobuf:"varint,2,req,name=matched_count,json=matchedCount" json:"matched_count,omitempty"`
	Status       *RequestStatus  `protobuf:"bytes,3,req,name=status" json:"status,omitempty"`
	Cursor       *string         `protobuf:"bytes,4,opt,name=cursor" json:"cursor,omitempty"`
	FacetResult  []*FacetResult  `protobuf:"bytes,5,rep,name=facet_result,json=facetResult" json:"facet_result,omitempty"`
}

func (x *SearchResponse) Reset() {
	*x = SearchResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse) ProtoMessage() {}

func (x *SearchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse.ProtoReflect.Descriptor instead.
func (*SearchResponse) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{43}
}

var extRange_SearchResponse = []protoiface.ExtensionRangeV1{
	{Start: 1000, End: 9999},
}

// Deprecated: Use SearchResponse.ProtoReflect.Descriptor.ExtensionRanges instead.
func (*SearchResponse) ExtensionRangeArray() []protoiface.ExtensionRangeV1 {
	return extRange_SearchResponse
}

func (x *SearchResponse) GetResult() []*SearchResult {
	if x != nil {
		return x.Result
	}
	return nil
}

func (x *SearchResponse) GetMatchedCount() int64 {
	if x != nil && x.MatchedCount != nil {
		return *x.MatchedCount
	}
	return 0
}

func (x *SearchResponse) GetStatus() *RequestStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *SearchResponse) GetCursor() string {
	if x != nil && x.Cursor != nil {
		return *x.Cursor
	}
	return ""
}

func (x *SearchResponse) GetFacetResult() []*FacetResult {
	if x != nil {
		return x.FacetResult
	}
	return nil
}

type FieldValue_Geo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Lat *float64 `protobuf:"fixed64,5,req,name=lat" json:"lat,omitempty"`
	Lng *float64 `protobuf:"fixed64,6,req,name=lng" json:"lng,omitempty"`
}

func (x *FieldValue_Geo) Reset() {
	*x = FieldValue_Geo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FieldValue_Geo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldValue_Geo) ProtoMessage() {}

func (x *FieldValue_Geo) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldValue_Geo.ProtoReflect.Descriptor instead.
func (*FieldValue_Geo) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{3, 0}
}

func (x *FieldValue_Geo) GetLat() float64 {
	if x != nil && x.Lat != nil {
		return *x.Lat
	}
	return 0
}

func (x *FieldValue_Geo) GetLng() float64 {
	if x != nil && x.Lng != nil {
		return *x.Lng
	}
	return 0
}

type IndexMetadata_Storage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AmountUsed *int64 `protobuf:"varint,1,opt,name=amount_used,json=amountUsed" json:"amount_used,omitempty"`
	Limit      *int64 `protobuf:"varint,2,opt,name=limit" json:"limit,omitempty"`
}

func (x *IndexMetadata_Storage) Reset() {
	*x = IndexMetadata_Storage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IndexMetadata_Storage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IndexMetadata_Storage) ProtoMessage() {}

func (x *IndexMetadata_Storage) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IndexMetadata_Storage.ProtoReflect.Descriptor instead.
func (*IndexMetadata_Storage) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{14, 0}
}

func (x *IndexMetadata_Storage) GetAmountUsed() int64 {
	if x != nil && x.AmountUsed != nil {
		return *x.AmountUsed
	}
	return 0
}

func (x *IndexMetadata_Storage) GetLimit() int64 {
	if x != nil && x.Limit != nil {
		return *x.Limit
	}
	return 0
}

type FieldSpec_Expression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name       *string `protobuf:"bytes,3,req,name=name" json:"name,omitempty"`
	Expression *string `protobuf:"bytes,4,req,name=expression" json:"expression,omitempty"`
}

func (x *FieldSpec_Expression) Reset() {
	*x = FieldSpec_Expression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FieldSpec_Expression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldSpec_Expression) ProtoMessage() {}

func (x *FieldSpec_Expression) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldSpec_Expression.ProtoReflect.Descriptor instead.
func (*FieldSpec_Expression) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{32, 0}
}

func (x *FieldSpec_Expression) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *FieldSpec_Expression) GetExpression() string {
	if x != nil && x.Expression != nil {
		return *x.Expression
	}
	return ""
}

type FacetRefinement_Range struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Start *string `protobuf:"bytes,1,opt,name=start" json:"start,omitempty"`
	End   *string `protobuf:"bytes,2,opt,name=end" json:"end,omitempty"`
}

func (x *FacetRefinement_Range) Reset() {
	*x = FacetRefinement_Range{}
	if protoimpl.UnsafeEnabled {
		mi := &file_search_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FacetRefinement_Range) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FacetRefinement_Range) ProtoMessage() {}

func (x *FacetRefinement_Range) ProtoReflect() protoreflect.Message {
	mi := &file_search_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FacetRefinement_Range.ProtoReflect.Descriptor instead.
func (*FacetRefinement_Range) Descriptor() ([]byte, []int) {
	return file_search_proto_rawDescGZIP(), []int{37, 0}
}

func (x *FacetRefinement_Range) GetStart() string {
	if x != nil && x.Start != nil {
		return *x.Start
	}
	return ""
}

func (x *FacetRefinement_Range) GetEnd() string {
	if x != nil && x.End != nil {
		return *x.End
	}
	return ""
}

var File_search_proto protoreflect.FileDescriptor

var file_search_proto_rawDesc = []byte{
	0x0a, 0x0c, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x09,
	0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x22, 0xee, 0x01, 0x0a, 0x05, 0x53, 0x63,
	0x6f, 0x70, 0x65, 0x12, 0x29, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x15, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x63,
	0x6f, 0x70, 0x65, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x22, 0xa3, 0x01, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a,
	0x14, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x42, 0x59, 0x5f, 0x43, 0x41, 0x4e, 0x4f, 0x4e, 0x49, 0x43,
	0x41, 0x4c, 0x5f, 0x49, 0x44, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x55, 0x53, 0x45, 0x52, 0x5f,
	0x42, 0x59, 0x5f, 0x45, 0x4d, 0x41, 0x49, 0x4c, 0x10, 0x02, 0x12, 0x19, 0x0a, 0x15, 0x47, 0x52,
	0x4f, 0x55, 0x50, 0x5f, 0x42, 0x59, 0x5f, 0x43, 0x41, 0x4e, 0x4f, 0x4e, 0x49, 0x43, 0x41, 0x4c,
	0x5f, 0x49, 0x44, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x5f, 0x42,
	0x59, 0x5f, 0x45, 0x4d, 0x41, 0x49, 0x4c, 0x10, 0x04, 0x12, 0x13, 0x0a, 0x0f, 0x47, 0x52, 0x4f,
	0x55, 0x50, 0x5f, 0x42, 0x59, 0x5f, 0x44, 0x4f, 0x4d, 0x41, 0x49, 0x4e, 0x10, 0x05, 0x12, 0x0d,
	0x0a, 0x09, 0x41, 0x4c, 0x4c, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x53, 0x10, 0x06, 0x12, 0x1b, 0x0a,
	0x17, 0x41, 0x4c, 0x4c, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x45, 0x4e, 0x54, 0x49, 0x43, 0x41, 0x54,
	0x45, 0x44, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x53, 0x10, 0x07, 0x22, 0xc4, 0x01, 0x0a, 0x05, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x26, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e,
	0x53, 0x63, 0x6f, 0x70, 0x65, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x3b, 0x0a, 0x0a,
	0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x1b, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x33, 0x0a, 0x0a,
	0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x08, 0x0a, 0x04, 0x52, 0x45,
	0x41, 0x44, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x57, 0x52, 0x49, 0x54, 0x45, 0x10, 0x02, 0x12,
	0x10, 0x0a, 0x0c, 0x46, 0x55, 0x4c, 0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x52, 0x4f, 0x4c, 0x10,
	0x03, 0x22, 0x55, 0x0a, 0x11, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x2a, 0x0a, 0x07,
	0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e,
	0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x22, 0xb0, 0x02, 0x0a, 0x0a, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x3b, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76,
	0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x3a, 0x04, 0x54, 0x45, 0x58, 0x54, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x3a, 0x02, 0x65, 0x6e, 0x52, 0x08, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2b, 0x0a, 0x03, 0x67, 0x65, 0x6f, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0a, 0x32, 0x19, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x47, 0x65, 0x6f, 0x52,
	0x03, 0x67, 0x65, 0x6f, 0x1a, 0x29, 0x0a, 0x03, 0x47, 0x65, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x6c,
	0x61, 0x74, 0x18, 0x05, 0x20, 0x02, 0x28, 0x01, 0x52, 0x03, 0x6c, 0x61, 0x74, 0x12, 0x10, 0x0a,
	0x03, 0x6c, 0x6e, 0x67, 0x18, 0x06, 0x20, 0x02, 0x28, 0x01, 0x52, 0x03, 0x6c, 0x6e, 0x67, 0x22,
	0x4a, 0x0a, 0x0b, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x08,
	0x0a, 0x04, 0x54, 0x45, 0x58, 0x54, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x54, 0x4d, 0x4c,
	0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x41, 0x54, 0x4f, 0x4d, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04,
	0x44, 0x41, 0x54, 0x45, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x55, 0x4d, 0x42, 0x45, 0x52,
	0x10, 0x04, 0x12, 0x07, 0x0a, 0x03, 0x47, 0x45, 0x4f, 0x10, 0x05, 0x22, 0x48, 0x0a, 0x05, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x02,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x57, 0x0a, 0x0a, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76,
	0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0xc5,
	0x01, 0x0a, 0x12, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x53, 0x68, 0x61, 0x72, 0x64, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x70, 0x72, 0x65, 0x76, 0x5f, 0x6e, 0x75,
	0x6d, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x05, 0x52, 0x0d,
	0x70, 0x72, 0x65, 0x76, 0x4e, 0x75, 0x6d, 0x53, 0x68, 0x61, 0x72, 0x64, 0x73, 0x12, 0x20, 0x0a,
	0x0a, 0x6e, 0x75, 0x6d, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x73, 0x18, 0x02, 0x20, 0x02, 0x28,
	0x05, 0x3a, 0x01, 0x31, 0x52, 0x09, 0x6e, 0x75, 0x6d, 0x53, 0x68, 0x61, 0x72, 0x64, 0x73, 0x12,
	0x3e, 0x0a, 0x1c, 0x70, 0x72, 0x65, 0x76, 0x5f, 0x6e, 0x75, 0x6d, 0x5f, 0x73, 0x68, 0x61, 0x72,
	0x64, 0x73, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x05, 0x52, 0x18, 0x70, 0x72, 0x65, 0x76, 0x4e, 0x75, 0x6d, 0x53, 0x68,
	0x61, 0x72, 0x64, 0x73, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x46, 0x61, 0x6c, 0x73, 0x65, 0x12,
	0x25, 0x0a, 0x0d, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x3a, 0x00, 0x52, 0x0c, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x52,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x22, 0x91, 0x01, 0x0a, 0x0a, 0x46, 0x61, 0x63, 0x65, 0x74,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x3b, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e,
	0x46, 0x61, 0x63, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x3a, 0x04, 0x41, 0x54, 0x4f, 0x4d, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x23, 0x0a, 0x0b, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x08, 0x0a, 0x04, 0x41, 0x54, 0x4f, 0x4d, 0x10, 0x02, 0x12, 0x0a,
	0x0a, 0x06, 0x4e, 0x55, 0x4d, 0x42, 0x45, 0x52, 0x10, 0x04, 0x22, 0x48, 0x0a, 0x05, 0x46, 0x61,
	0x63, 0x65, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e,
	0x76, 0x32, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x22, 0x5e, 0x0a, 0x10, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x30, 0x0a, 0x14, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x5f,
	0x73, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x12, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x53, 0x74, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x22, 0xfa, 0x02, 0x0a, 0x08, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x1e, 0x0a, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x3a, 0x02, 0x65, 0x6e, 0x52, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x12, 0x26, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x10, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x49, 0x64, 0x12, 0x53, 0x0a, 0x0f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e,
	0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x49, 0x64, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x3a, 0x08, 0x53, 0x55, 0x50, 0x50, 0x4c, 0x49, 0x45, 0x44, 0x52, 0x0d, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x49, 0x64, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x3b, 0x0a, 0x07, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1b, 0x2e, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x3a, 0x04, 0x44, 0x49, 0x53, 0x4b, 0x52, 0x07, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x12, 0x26, 0x0a, 0x05, 0x66, 0x61, 0x63, 0x65, 0x74, 0x18,
	0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76,
	0x32, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x52, 0x05, 0x66, 0x61, 0x63, 0x65, 0x74, 0x22, 0x2c,
	0x0a, 0x0d, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x49, 0x64, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x0d, 0x0a, 0x09, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c,
	0x0a, 0x08, 0x53, 0x55, 0x50, 0x50, 0x4c, 0x49, 0x45, 0x44, 0x10, 0x01, 0x22, 0x13, 0x0a, 0x07,
	0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x49, 0x53, 0x4b, 0x10,
	0x00, 0x22, 0xa8, 0x01, 0x0a, 0x12, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x91, 0x01, 0x0a, 0x09, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x06, 0x0a, 0x02, 0x4f, 0x4b, 0x10, 0x00, 0x12, 0x13,
	0x0a, 0x0f, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53,
	0x54, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x49, 0x45, 0x4e, 0x54,
	0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x49, 0x4e, 0x54, 0x45,
	0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x03, 0x12, 0x15, 0x0a, 0x11,
	0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45,
	0x44, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54, 0x10, 0x05,
	0x12, 0x1a, 0x0a, 0x16, 0x43, 0x4f, 0x4e, 0x43, 0x55, 0x52, 0x52, 0x45, 0x4e, 0x54, 0x5f, 0x54,
	0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x06, 0x22, 0x96, 0x01, 0x0a,
	0x0d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x3b,
	0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x2e, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x25,
	0x0a, 0x0e, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61,
	0x6c, 0x43, 0x6f, 0x64, 0x65, 0x22, 0xaa, 0x03, 0x0a, 0x09, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x50, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x69,
	0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x20, 0x2e, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x53, 0x70,
	0x65, 0x63, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x3a, 0x0c,
	0x50, 0x45, 0x52, 0x5f, 0x44, 0x4f, 0x43, 0x55, 0x4d, 0x45, 0x4e, 0x54, 0x52, 0x0b, 0x63, 0x6f,
	0x6e, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x1c, 0x0a, 0x09, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x61,
	0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x3b, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x1b, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3a, 0x06,
	0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x37,
	0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x53, 0x70,
	0x65, 0x63, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x3a, 0x08, 0x50, 0x52, 0x49, 0x4f, 0x52, 0x49, 0x54,
	0x59, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x22, 0x2b, 0x0a, 0x0b, 0x43, 0x6f, 0x6e, 0x73, 0x69,
	0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x0a, 0x0a, 0x06, 0x47, 0x4c, 0x4f, 0x42, 0x41, 0x4c,
	0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x45, 0x52, 0x5f, 0x44, 0x4f, 0x43, 0x55, 0x4d, 0x45,
	0x4e, 0x54, 0x10, 0x01, 0x22, 0x36, 0x0a, 0x06, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x0a,
	0x0a, 0x06, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x44, 0x41,
	0x54, 0x41, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x43, 0x4c, 0x4f,
	0x55, 0x44, 0x5f, 0x53, 0x54, 0x4f, 0x52, 0x41, 0x47, 0x45, 0x10, 0x02, 0x22, 0x24, 0x0a, 0x04,
	0x4d, 0x6f, 0x64, 0x65, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x52, 0x49, 0x4f, 0x52, 0x49, 0x54, 0x59,
	0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x42, 0x41, 0x43, 0x4b, 0x47, 0x52, 0x4f, 0x55, 0x4e, 0x44,
	0x10, 0x01, 0x22, 0xef, 0x01, 0x0a, 0x0d, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x33, 0x0a, 0x0a, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x73, 0x70,
	0x65, 0x63, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x53, 0x70, 0x65, 0x63, 0x52, 0x09,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x53, 0x70, 0x65, 0x63, 0x12, 0x2b, 0x0a, 0x05, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52,
	0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x3a, 0x0a, 0x07, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x52, 0x07, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x1a, 0x40, 0x0a, 0x07, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x12, 0x1f, 0x0a,
	0x0b, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x75, 0x73, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0a, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x55, 0x73, 0x65, 0x64, 0x12, 0x14,
	0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x22, 0x8b, 0x02, 0x0a, 0x13, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x2f, 0x0a, 0x08,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13,
	0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x59, 0x0a,
	0x09, 0x66, 0x72, 0x65, 0x73, 0x68, 0x6e, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x28, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x2e, 0x46, 0x72, 0x65, 0x73, 0x68, 0x6e, 0x65, 0x73, 0x73, 0x3a, 0x0d, 0x53, 0x59, 0x4e, 0x43,
	0x48, 0x52, 0x4f, 0x4e, 0x4f, 0x55, 0x53, 0x4c, 0x59, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x66,
	0x72, 0x65, 0x73, 0x68, 0x6e, 0x65, 0x73, 0x73, 0x12, 0x33, 0x0a, 0x0a, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x03, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x53, 0x70,
	0x65, 0x63, 0x52, 0x09, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x53, 0x70, 0x65, 0x63, 0x22, 0x33, 0x0a,
	0x09, 0x46, 0x72, 0x65, 0x73, 0x68, 0x6e, 0x65, 0x73, 0x73, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x59,
	0x4e, 0x43, 0x48, 0x52, 0x4f, 0x4e, 0x4f, 0x55, 0x53, 0x4c, 0x59, 0x10, 0x00, 0x12, 0x13, 0x0a,
	0x0f, 0x57, 0x48, 0x45, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x4e, 0x49, 0x45, 0x4e, 0x54,
	0x10, 0x01, 0x22, 0x65, 0x0a, 0x14, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x36, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x06, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x12, 0x15, 0x0a, 0x06, 0x61, 0x70, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x05, 0x61, 0x70, 0x70, 0x49, 0x64, 0x22, 0x60, 0x0a, 0x15, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x30, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x18, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x15, 0x0a, 0x06, 0x64, 0x6f, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x64, 0x6f, 0x63, 0x49, 0x64, 0x22, 0x62, 0x0a, 0x14, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x12, 0x15, 0x0a, 0x06, 0x64, 0x6f, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x05, 0x64, 0x6f, 0x63, 0x49, 0x64, 0x12, 0x33, 0x0a, 0x0a, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x14,
	0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x53, 0x70, 0x65, 0x63, 0x52, 0x09, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x53, 0x70, 0x65, 0x63, 0x22,
	0x67, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x12, 0x15, 0x0a, 0x06, 0x61, 0x70, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x05, 0x61, 0x70, 0x70, 0x49, 0x64, 0x22, 0x4a, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x30, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x18, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x22, 0xd6, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x33, 0x0a, 0x0a,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b,
	0x32, 0x14, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x53, 0x70, 0x65, 0x63, 0x52, 0x09, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x53, 0x70, 0x65,
	0x63, 0x12, 0x20, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x64, 0x6f, 0x63, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x44, 0x6f,
	0x63, 0x49, 0x64, 0x12, 0x30, 0x0a, 0x11, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x5f, 0x64, 0x6f, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x04,
	0x74, 0x72, 0x75, 0x65, 0x52, 0x0f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x53, 0x74, 0x61,
	0x72, 0x74, 0x44, 0x6f, 0x63, 0x12, 0x19, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x05, 0x3a, 0x03, 0x31, 0x30, 0x30, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x6b, 0x65, 0x79, 0x73, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x65, 0x0a,
	0x14, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x36, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18,
	0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76,
	0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x15, 0x0a,
	0x06, 0x61, 0x70, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x61,
	0x70, 0x70, 0x49, 0x64, 0x22, 0x7a, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x18, 0x2e,
	0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x2f, 0x0a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x13, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x22, 0xcf, 0x02, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x66, 0x65, 0x74, 0x63, 0x68, 0x5f,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x66, 0x65,
	0x74, 0x63, 0x68, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x18, 0x0a, 0x05, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x3a, 0x02, 0x32, 0x30, 0x52, 0x05, 0x6c, 0x69,
	0x6d, 0x69, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x12, 0x28, 0x0a, 0x10, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x13, 0x69,
	0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x04, 0x74, 0x72, 0x75, 0x65, 0x52, 0x11,
	0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x53, 0x74, 0x61, 0x72, 0x74, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x12, 0x2a, 0x0a, 0x11, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f,
	0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x4e, 0x61, 0x6d, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x16, 0x0a,
	0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x3b, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1b, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76,
	0x32, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x3a, 0x06, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x22, 0x61, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x34, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x15,
	0x0a, 0x06, 0x61, 0x70, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05,
	0x61, 0x70, 0x70, 0x49, 0x64, 0x22, 0x88, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x18, 0x2e,
	0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x3f, 0x0a, 0x0e, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x0d, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x22, 0x86, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x3b, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1b, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x3a, 0x06, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x52, 0x06, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x33, 0x0a, 0x0a, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x73, 0x70,
	0x65, 0x63, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x53, 0x70, 0x65, 0x63, 0x52, 0x09,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x53, 0x70, 0x65, 0x63, 0x22, 0x63, 0x0a, 0x13, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x35, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b,
	0x32, 0x1d, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x15, 0x0a, 0x06, 0x61, 0x70, 0x70, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x61, 0x70, 0x70, 0x49, 0x64, 0x22, 0x48,
	0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e,
	0x76, 0x32, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0xc4, 0x01, 0x0a, 0x08, 0x53, 0x6f, 0x72,
	0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x6f, 0x72, 0x74, 0x5f, 0x65, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0e,
	0x73, 0x6f, 0x72, 0x74, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2d,
	0x0a, 0x0f, 0x73, 0x6f, 0x72, 0x74, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x04, 0x74, 0x72, 0x75, 0x65, 0x52, 0x0e, 0x73,
	0x6f, 0x72, 0x74, 0x44, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x2c, 0x0a,
	0x12, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x74,
	0x65, 0x78, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x64, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x54, 0x65, 0x78, 0x74, 0x12, 0x32, 0x0a, 0x15, 0x64,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x6e, 0x75, 0x6d,
	0x65, 0x72, 0x69, 0x63, 0x18, 0x05, 0x20, 0x01, 0x28, 0x01, 0x52, 0x13, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x22,
	0xdc, 0x01, 0x0a, 0x0a, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x12, 0x42,
	0x0a, 0x06, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1c,
	0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x63, 0x6f, 0x72, 0x65,
	0x72, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x72, 0x3a, 0x0c, 0x4d, 0x41,
	0x54, 0x43, 0x48, 0x5f, 0x53, 0x43, 0x4f, 0x52, 0x45, 0x52, 0x52, 0x06, 0x73, 0x63, 0x6f, 0x72,
	0x65, 0x72, 0x12, 0x1a, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x3a, 0x04, 0x31, 0x30, 0x30, 0x30, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x36,
	0x0a, 0x17, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x72, 0x5f, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x15, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x72, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0x36, 0x0a, 0x06, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x72,
	0x12, 0x1a, 0x0a, 0x16, 0x52, 0x45, 0x53, 0x43, 0x4f, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x4d, 0x41,
	0x54, 0x43, 0x48, 0x5f, 0x53, 0x43, 0x4f, 0x52, 0x45, 0x52, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c,
	0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x53, 0x43, 0x4f, 0x52, 0x45, 0x52, 0x10, 0x02, 0x22, 0xa2,
	0x01, 0x0a, 0x09, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x53, 0x70, 0x65, 0x63, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x3f, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0a, 0x32, 0x1f, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x1a, 0x40, 0x0a, 0x0a, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x04, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x22, 0x48, 0x0a, 0x0a, 0x46, 0x61, 0x63, 0x65, 0x74, 0x52, 0x61, 0x6e, 0x67,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x65,
	0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x65, 0x6e, 0x64, 0x22, 0x8c, 0x01,
	0x0a, 0x11, 0x46, 0x61, 0x63, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x12, 0x1f, 0x0a, 0x0b, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x4c,
	0x69, 0x6d, 0x69, 0x74, 0x12, 0x2b, 0x0a, 0x05, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e,
	0x46, 0x61, 0x63, 0x65, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x05, 0x72, 0x61, 0x6e, 0x67,
	0x65, 0x12, 0x29, 0x0a, 0x10, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x22, 0x3b, 0x0a, 0x14,
	0x46, 0x61, 0x63, 0x65, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x12, 0x23, 0x0a, 0x0b, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x6c, 0x69,
	0x6d, 0x69, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x3a, 0x02, 0x31, 0x30, 0x52, 0x0a, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x22, 0x58, 0x0a, 0x0c, 0x46, 0x61, 0x63,
	0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x34, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x22, 0xa4, 0x01, 0x0a, 0x0f, 0x46, 0x61, 0x63, 0x65, 0x74, 0x52, 0x65, 0x66,
	0x69, 0x6e, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x36, 0x0a, 0x05, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x20, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x61, 0x63,
	0x65, 0x74, 0x52, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x52, 0x05, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x1a, 0x2f, 0x0a, 0x05, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x65, 0x6e, 0x64, 0x22, 0xce, 0x07, 0x0a, 0x0c, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x33, 0x0a, 0x0a, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32,
	0x14, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x53, 0x70, 0x65, 0x63, 0x52, 0x09, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52,
	0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x12, 0x16,
	0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x49, 0x0a, 0x0b, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x2e, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x3a,
	0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x52, 0x0a, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x18, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05,
	0x3a, 0x02, 0x32, 0x30, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x34, 0x0a, 0x16, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x61, 0x63, 0x63,
	0x75, 0x72, 0x61, 0x63, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x14, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x41, 0x63, 0x63, 0x75, 0x72, 0x61, 0x63,
	0x79, 0x12, 0x30, 0x0a, 0x09, 0x73, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x08,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32,
	0x2e, 0x53, 0x6f, 0x72, 0x74, 0x53, 0x70, 0x65, 0x63, 0x52, 0x08, 0x73, 0x6f, 0x72, 0x74, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x36, 0x0a, 0x0b, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x72, 0x5f, 0x73, 0x70,
	0x65, 0x63, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x52,
	0x0a, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x12, 0x33, 0x0a, 0x0a, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x14, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x53, 0x70, 0x65, 0x63, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x1b, 0x0a, 0x09, 0x6b, 0x65, 0x79, 0x73, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x4e, 0x0a,
	0x0c, 0x70, 0x61, 0x72, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x2e, 0x50, 0x61, 0x72,
	0x73, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x3a, 0x06, 0x53, 0x54, 0x52, 0x49, 0x43, 0x54,
	0x52, 0x0b, 0x70, 0x61, 0x72, 0x73, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x3c, 0x0a,
	0x19, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x66,
	0x61, 0x63, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x05,
	0x3a, 0x01, 0x30, 0x52, 0x16, 0x61, 0x75, 0x74, 0x6f, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x46, 0x61, 0x63, 0x65, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3c, 0x0a, 0x0d, 0x69,
	0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x66, 0x61, 0x63, 0x65, 0x74, 0x18, 0x10, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x46,
	0x61, 0x63, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x0c, 0x69, 0x6e, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x46, 0x61, 0x63, 0x65, 0x74, 0x12, 0x45, 0x0a, 0x10, 0x66, 0x61, 0x63,
	0x65, 0x74, 0x5f, 0x72, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x11, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e,
	0x46, 0x61, 0x63, 0x65, 0x74, 0x52, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x0f, 0x66, 0x61, 0x63, 0x65, 0x74, 0x52, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x56, 0x0a, 0x17, 0x66, 0x61, 0x63, 0x65, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x64,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x18, 0x12, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1f, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x61,
	0x63, 0x65, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x52, 0x14, 0x66, 0x61, 0x63, 0x65, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x12, 0x25, 0x0a, 0x0b, 0x66, 0x61, 0x63, 0x65,
	0x74, 0x5f, 0x64, 0x65, 0x70, 0x74, 0x68, 0x18, 0x13, 0x20, 0x01, 0x28, 0x05, 0x3a, 0x04, 0x31,
	0x30, 0x30, 0x30, 0x52, 0x0a, 0x66, 0x61, 0x63, 0x65, 0x74, 0x44, 0x65, 0x70, 0x74, 0x68, 0x22,
	0x32, 0x0a, 0x0a, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x08, 0x0a,
	0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x49, 0x4e, 0x47, 0x4c,
	0x45, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x45, 0x52, 0x5f, 0x52, 0x45, 0x53, 0x55, 0x4c,
	0x54, 0x10, 0x02, 0x22, 0x26, 0x0a, 0x0b, 0x50, 0x61, 0x72, 0x73, 0x69, 0x6e, 0x67, 0x4d, 0x6f,
	0x64, 0x65, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x52, 0x49, 0x43, 0x54, 0x10, 0x00, 0x12, 0x0b,
	0x0a, 0x07, 0x52, 0x45, 0x4c, 0x41, 0x58, 0x45, 0x44, 0x10, 0x01, 0x22, 0x57, 0x0a, 0x0d, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2f, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x15, 0x0a,
	0x06, 0x61, 0x70, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x61,
	0x70, 0x70, 0x49, 0x64, 0x22, 0x78, 0x0a, 0x10, 0x46, 0x61, 0x63, 0x65, 0x74, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x02, 0x28, 0x05, 0x52, 0x05, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x3a, 0x0a, 0x0a, 0x72, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x18, 0x03, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e,
	0x76, 0x32, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x52, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x0a, 0x72, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x54,
	0x0a, 0x0b, 0x46, 0x61, 0x63, 0x65, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x31, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1b, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x61, 0x63,
	0x65, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x22, 0x9f, 0x01, 0x0a, 0x0c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x2f, 0x0a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x2e, 0x76, 0x32, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x08, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x30, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x0a, 0x65, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72,
	0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x01, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x16,
	0x0a, 0x06, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x63, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x22, 0xf3, 0x01, 0x0a, 0x0e, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2f, 0x0a, 0x06, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x02, 0x28,
	0x03, 0x52, 0x0c, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x30, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x02, 0x28, 0x0b, 0x32,
	0x18, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x12, 0x39, 0x0a, 0x0c, 0x66, 0x61, 0x63,
	0x65, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x16, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x61, 0x63, 0x65,
	0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x0b, 0x66, 0x61, 0x63, 0x65, 0x74, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x2a, 0x06, 0x08, 0xe8, 0x07, 0x10, 0x90, 0x4e, 0x42, 0x30, 0x5a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72,
	0x67, 0x2f, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x32, 0x2f, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
}

var (
	file_search_proto_rawDescOnce sync.Once
	file_search_proto_rawDescData = file_search_proto_rawDesc
)

func file_search_proto_rawDescGZIP() []byte {
	file_search_proto_rawDescOnce.Do(func() {
		file_search_proto_rawDescData = protoimpl.X.CompressGZIP(file_search_proto_rawDescData)
	})
	return file_search_proto_rawDescData
}

var file_search_proto_enumTypes = make([]protoimpl.EnumInfo, 14)
var file_search_proto_msgTypes = make([]protoimpl.MessageInfo, 48)
var file_search_proto_goTypes = []interface{}{
	(Scope_Type)(0),                    // 0: search.v2.Scope.Type
	(Entry_Permission)(0),              // 1: search.v2.Entry.Permission
	(FieldValue_ContentType)(0),        // 2: search.v2.FieldValue.ContentType
	(FacetValue_ContentType)(0),        // 3: search.v2.FacetValue.ContentType
	(Document_OrderIdSource)(0),        // 4: search.v2.Document.OrderIdSource
	(Document_Storage)(0),              // 5: search.v2.Document.Storage
	(SearchServiceError_ErrorCode)(0),  // 6: search.v2.SearchServiceError.ErrorCode
	(IndexSpec_Consistency)(0),         // 7: search.v2.IndexSpec.Consistency
	(IndexSpec_Source)(0),              // 8: search.v2.IndexSpec.Source
	(IndexSpec_Mode)(0),                // 9: search.v2.IndexSpec.Mode
	(IndexDocumentParams_Freshness)(0), // 10: search.v2.IndexDocumentParams.Freshness
	(ScorerSpec_Scorer)(0),             // 11: search.v2.ScorerSpec.Scorer
	(SearchParams_CursorType)(0),       // 12: search.v2.SearchParams.CursorType
	(SearchParams_ParsingMode)(0),      // 13: search.v2.SearchParams.ParsingMode
	(*Scope)(nil),                      // 14: search.v2.Scope
	(*Entry)(nil),                      // 15: search.v2.Entry
	(*AccessControlList)(nil),          // 16: search.v2.AccessControlList
	(*FieldValue)(nil),                 // 17: search.v2.FieldValue
	(*Field)(nil),                      // 18: search.v2.Field
	(*FieldTypes)(nil),                 // 19: search.v2.FieldTypes
	(*IndexShardSettings)(nil),         // 20: search.v2.IndexShardSettings
	(*FacetValue)(nil),                 // 21: search.v2.FacetValue
	(*Facet)(nil),                      // 22: search.v2.Facet
	(*DocumentMetadata)(nil),           // 23: search.v2.DocumentMetadata
	(*Document)(nil),                   // 24: search.v2.Document
	(*SearchServiceError)(nil),         // 25: search.v2.SearchServiceError
	(*RequestStatus)(nil),              // 26: search.v2.RequestStatus
	(*IndexSpec)(nil),                  // 27: search.v2.IndexSpec
	(*IndexMetadata)(nil),              // 28: search.v2.IndexMetadata
	(*IndexDocumentParams)(nil),        // 29: search.v2.IndexDocumentParams
	(*IndexDocumentRequest)(nil),       // 30: search.v2.IndexDocumentRequest
	(*IndexDocumentResponse)(nil),      // 31: search.v2.IndexDocumentResponse
	(*DeleteDocumentParams)(nil),       // 32: search.v2.DeleteDocumentParams
	(*DeleteDocumentRequest)(nil),      // 33: search.v2.DeleteDocumentRequest
	(*DeleteDocumentResponse)(nil),     // 34: search.v2.DeleteDocumentResponse
	(*ListDocumentsParams)(nil),        // 35: search.v2.ListDocumentsParams
	(*ListDocumentsRequest)(nil),       // 36: search.v2.ListDocumentsRequest
	(*ListDocumentsResponse)(nil),      // 37: search.v2.ListDocumentsResponse
	(*ListIndexesParams)(nil),          // 38: search.v2.ListIndexesParams
	(*ListIndexesRequest)(nil),         // 39: search.v2.ListIndexesRequest
	(*ListIndexesResponse)(nil),        // 40: search.v2.ListIndexesResponse
	(*DeleteSchemaParams)(nil),         // 41: search.v2.DeleteSchemaParams
	(*DeleteSchemaRequest)(nil),        // 42: search.v2.DeleteSchemaRequest
	(*DeleteSchemaResponse)(nil),       // 43: search.v2.DeleteSchemaResponse
	(*SortSpec)(nil),                   // 44: search.v2.SortSpec
	(*ScorerSpec)(nil),                 // 45: search.v2.ScorerSpec
	(*FieldSpec)(nil),                  // 46: search.v2.FieldSpec
	(*FacetRange)(nil),                 // 47: search.v2.FacetRange
	(*FacetRequestParam)(nil),          // 48: search.v2.FacetRequestParam
	(*FacetAutoDetectParam)(nil),       // 49: search.v2.FacetAutoDetectParam
	(*FacetRequest)(nil),               // 50: search.v2.FacetRequest
	(*FacetRefinement)(nil),            // 51: search.v2.FacetRefinement
	(*SearchParams)(nil),               // 52: search.v2.SearchParams
	(*SearchRequest)(nil),              // 53: search.v2.SearchRequest
	(*FacetResultValue)(nil),           // 54: search.v2.FacetResultValue
	(*FacetResult)(nil),                // 55: search.v2.FacetResult
	(*SearchResult)(nil),               // 56: search.v2.SearchResult
	(*SearchResponse)(nil),             // 57: search.v2.SearchResponse
	(*FieldValue_Geo)(nil),             // 58: search.v2.FieldValue.Geo
	(*IndexMetadata_Storage)(nil),      // 59: search.v2.IndexMetadata.Storage
	(*FieldSpec_Expression)(nil),       // 60: search.v2.FieldSpec.Expression
	(*FacetRefinement_Range)(nil),      // 61: search.v2.FacetRefinement.Range
}
var file_search_proto_depIdxs = []int32{
	0,  // 0: search.v2.Scope.type:type_name -> search.v2.Scope.Type
	14, // 1: search.v2.Entry.scope:type_name -> search.v2.Scope
	1,  // 2: search.v2.Entry.permission:type_name -> search.v2.Entry.Permission
	15, // 3: search.v2.AccessControlList.entries:type_name -> search.v2.Entry
	2,  // 4: search.v2.FieldValue.type:type_name -> search.v2.FieldValue.ContentType
	58, // 5: search.v2.FieldValue.geo:type_name -> search.v2.FieldValue.Geo
	17, // 6: search.v2.Field.value:type_name -> search.v2.FieldValue
	2,  // 7: search.v2.FieldTypes.type:type_name -> search.v2.FieldValue.ContentType
	3,  // 8: search.v2.FacetValue.type:type_name -> search.v2.FacetValue.ContentType
	21, // 9: search.v2.Facet.value:type_name -> search.v2.FacetValue
	18, // 10: search.v2.Document.field:type_name -> search.v2.Field
	4,  // 11: search.v2.Document.order_id_source:type_name -> search.v2.Document.OrderIdSource
	5,  // 12: search.v2.Document.storage:type_name -> search.v2.Document.Storage
	22, // 13: search.v2.Document.facet:type_name -> search.v2.Facet
	6,  // 14: search.v2.RequestStatus.code:type_name -> search.v2.SearchServiceError.ErrorCode
	7,  // 15: search.v2.IndexSpec.consistency:type_name -> search.v2.IndexSpec.Consistency
	8,  // 16: search.v2.IndexSpec.source:type_name -> search.v2.IndexSpec.Source
	9,  // 17: search.v2.IndexSpec.mode:type_name -> search.v2.IndexSpec.Mode
	27, // 18: search.v2.IndexMetadata.index_spec:type_name -> search.v2.IndexSpec
	19, // 19: search.v2.IndexMetadata.field:type_name -> search.v2.FieldTypes
	59, // 20: search.v2.IndexMetadata.storage:type_name -> search.v2.IndexMetadata.Storage
	24, // 21: search.v2.IndexDocumentParams.document:type_name -> search.v2.Document
	10, // 22: search.v2.IndexDocumentParams.freshness:type_name -> search.v2.IndexDocumentParams.Freshness
	27, // 23: search.v2.IndexDocumentParams.index_spec:type_name -> search.v2.IndexSpec
	29, // 24: search.v2.IndexDocumentRequest.params:type_name -> search.v2.IndexDocumentParams
	26, // 25: search.v2.IndexDocumentResponse.status:type_name -> search.v2.RequestStatus
	27, // 26: search.v2.DeleteDocumentParams.index_spec:type_name -> search.v2.IndexSpec
	32, // 27: search.v2.DeleteDocumentRequest.params:type_name -> search.v2.DeleteDocumentParams
	26, // 28: search.v2.DeleteDocumentResponse.status:type_name -> search.v2.RequestStatus
	27, // 29: search.v2.ListDocumentsParams.index_spec:type_name -> search.v2.IndexSpec
	35, // 30: search.v2.ListDocumentsRequest.params:type_name -> search.v2.ListDocumentsParams
	26, // 31: search.v2.ListDocumentsResponse.status:type_name -> search.v2.RequestStatus
	24, // 32: search.v2.ListDocumentsResponse.document:type_name -> search.v2.Document
	8,  // 33: search.v2.ListIndexesParams.source:type_name -> search.v2.IndexSpec.Source
	38, // 34: search.v2.ListIndexesRequest.params:type_name -> search.v2.ListIndexesParams
	26, // 35: search.v2.ListIndexesResponse.status:type_name -> search.v2.RequestStatus
	28, // 36: search.v2.ListIndexesResponse.index_metadata:type_name -> search.v2.IndexMetadata
	8,  // 37: search.v2.DeleteSchemaParams.source:type_name -> search.v2.IndexSpec.Source
	27, // 38: search.v2.DeleteSchemaParams.index_spec:type_name -> search.v2.IndexSpec
	41, // 39: search.v2.DeleteSchemaRequest.params:type_name -> search.v2.DeleteSchemaParams
	26, // 40: search.v2.DeleteSchemaResponse.status:type_name -> search.v2.RequestStatus
	11, // 41: search.v2.ScorerSpec.scorer:type_name -> search.v2.ScorerSpec.Scorer
	60, // 42: search.v2.FieldSpec.expression:type_name -> search.v2.FieldSpec.Expression
	47, // 43: search.v2.FacetRequestParam.range:type_name -> search.v2.FacetRange
	48, // 44: search.v2.FacetRequest.params:type_name -> search.v2.FacetRequestParam
	61, // 45: search.v2.FacetRefinement.range:type_name -> search.v2.FacetRefinement.Range
	27, // 46: search.v2.SearchParams.index_spec:type_name -> search.v2.IndexSpec
	12, // 47: search.v2.SearchParams.cursor_type:type_name -> search.v2.SearchParams.CursorType
	44, // 48: search.v2.SearchParams.sort_spec:type_name -> search.v2.SortSpec
	45, // 49: search.v2.SearchParams.scorer_spec:type_name -> search.v2.ScorerSpec
	46, // 50: search.v2.SearchParams.field_spec:type_name -> search.v2.FieldSpec
	13, // 51: search.v2.SearchParams.parsing_mode:type_name -> search.v2.SearchParams.ParsingMode
	50, // 52: search.v2.SearchParams.include_facet:type_name -> search.v2.FacetRequest
	51, // 53: search.v2.SearchParams.facet_refinement:type_name -> search.v2.FacetRefinement
	49, // 54: search.v2.SearchParams.facet_auto_detect_param:type_name -> search.v2.FacetAutoDetectParam
	52, // 55: search.v2.SearchRequest.params:type_name -> search.v2.SearchParams
	51, // 56: search.v2.FacetResultValue.refinement:type_name -> search.v2.FacetRefinement
	54, // 57: search.v2.FacetResult.value:type_name -> search.v2.FacetResultValue
	24, // 58: search.v2.SearchResult.document:type_name -> search.v2.Document
	18, // 59: search.v2.SearchResult.expression:type_name -> search.v2.Field
	56, // 60: search.v2.SearchResponse.result:type_name -> search.v2.SearchResult
	26, // 61: search.v2.SearchResponse.status:type_name -> search.v2.RequestStatus
	55, // 62: search.v2.SearchResponse.facet_result:type_name -> search.v2.FacetResult
	63, // [63:63] is the sub-list for method output_type
	63, // [63:63] is the sub-list for method input_type
	63, // [63:63] is the sub-list for extension type_name
	63, // [63:63] is the sub-list for extension extendee
	0,  // [0:63] is the sub-list for field type_name
}

func init() { file_search_proto_init() }
func file_search_proto_init() {
	if File_search_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_search_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Scope); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Entry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessControlList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FieldValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Field); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FieldTypes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IndexShardSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FacetValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Facet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DocumentMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchServiceError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RequestStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IndexSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IndexMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IndexDocumentParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IndexDocumentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IndexDocumentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDocumentParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDocumentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDocumentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDocumentsParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDocumentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDocumentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIndexesParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIndexesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIndexesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSchemaParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSchemaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSchemaResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SortSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ScorerSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FieldSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FacetRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FacetRequestParam); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FacetAutoDetectParam); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FacetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FacetRefinement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FacetResultValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FacetResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			case 3:
				return &v.extensionFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FieldValue_Geo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IndexMetadata_Storage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FieldSpec_Expression); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_search_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FacetRefinement_Range); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_search_proto_rawDesc,
			NumEnums:      14,
			NumMessages:   48,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_search_proto_goTypes,
		DependencyIndexes: file_search_proto_depIdxs,
		EnumInfos:         file_search_proto_enumTypes,
		MessageInfos:      file_search_proto_msgTypes,
	}.Build()
	File_search_proto = out.File
	file_search_proto_rawDesc = nil
	file_search_proto_goTypes = nil
	file_search_proto_depIdxs = nil
}
