// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package chromepolicy provides access to the Chrome Policy API.
//
// For product documentation, see: http://developers.google.com/chrome/policy
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/chromepolicy/v1"
//	...
//	ctx := context.Background()
//	chromepolicyService, err := chromepolicy.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	chromepolicyService, err := chromepolicy.NewService(ctx, option.WithScopes(chromepolicy.ChromeManagementPolicyReadonlyScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	chromepolicyService, err := chromepolicy.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	chromepolicyService, err := chromepolicy.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package chromepolicy // import "google.golang.org/api/chromepolicy/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "chromepolicy:v1"
const apiName = "chromepolicy"
const apiVersion = "v1"
const basePath = "https://chromepolicy.googleapis.com/"
const basePathTemplate = "https://chromepolicy.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://chromepolicy.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, create or delete policies applied to ChromeOS and Chrome Browsers
	// managed within your organization
	ChromeManagementPolicyScope = "https://www.googleapis.com/auth/chrome.management.policy"

	// See policies applied to ChromeOS and Chrome Browsers managed within your
	// organization
	ChromeManagementPolicyReadonlyScope = "https://www.googleapis.com/auth/chrome.management.policy.readonly"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/chrome.management.policy",
		"https://www.googleapis.com/auth/chrome.management.policy.readonly",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Customers = NewCustomersService(s)
	s.Media = NewMediaService(s)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Customers *CustomersService

	Media *MediaService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewCustomersService(s *Service) *CustomersService {
	rs := &CustomersService{s: s}
	rs.Policies = NewCustomersPoliciesService(s)
	rs.PolicySchemas = NewCustomersPolicySchemasService(s)
	return rs
}

type CustomersService struct {
	s *Service

	Policies *CustomersPoliciesService

	PolicySchemas *CustomersPolicySchemasService
}

func NewCustomersPoliciesService(s *Service) *CustomersPoliciesService {
	rs := &CustomersPoliciesService{s: s}
	rs.Groups = NewCustomersPoliciesGroupsService(s)
	rs.Networks = NewCustomersPoliciesNetworksService(s)
	rs.Orgunits = NewCustomersPoliciesOrgunitsService(s)
	return rs
}

type CustomersPoliciesService struct {
	s *Service

	Groups *CustomersPoliciesGroupsService

	Networks *CustomersPoliciesNetworksService

	Orgunits *CustomersPoliciesOrgunitsService
}

func NewCustomersPoliciesGroupsService(s *Service) *CustomersPoliciesGroupsService {
	rs := &CustomersPoliciesGroupsService{s: s}
	return rs
}

type CustomersPoliciesGroupsService struct {
	s *Service
}

func NewCustomersPoliciesNetworksService(s *Service) *CustomersPoliciesNetworksService {
	rs := &CustomersPoliciesNetworksService{s: s}
	return rs
}

type CustomersPoliciesNetworksService struct {
	s *Service
}

func NewCustomersPoliciesOrgunitsService(s *Service) *CustomersPoliciesOrgunitsService {
	rs := &CustomersPoliciesOrgunitsService{s: s}
	return rs
}

type CustomersPoliciesOrgunitsService struct {
	s *Service
}

func NewCustomersPolicySchemasService(s *Service) *CustomersPolicySchemasService {
	rs := &CustomersPolicySchemasService{s: s}
	return rs
}

type CustomersPolicySchemasService struct {
	s *Service
}

func NewMediaService(s *Service) *MediaService {
	rs := &MediaService{s: s}
	return rs
}

type MediaService struct {
	s *Service
}

// GoogleChromePolicyVersionsV1AdditionalTargetKeyName: Additional key names
// that will be used to identify the target of the policy value.
type GoogleChromePolicyVersionsV1AdditionalTargetKeyName struct {
	// Key: Key name.
	Key string `json:"key,omitempty"`
	// KeyDescription: Key description.
	KeyDescription string `json:"keyDescription,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1AdditionalTargetKeyName) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1AdditionalTargetKeyName
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1BatchDeleteGroupPoliciesRequest: Request message
// for specifying that multiple policy values will be deleted.
type GoogleChromePolicyVersionsV1BatchDeleteGroupPoliciesRequest struct {
	// Requests: List of policies that will be deleted as defined by the
	// `requests`. All requests in the list must follow these restrictions: 1. All
	// schemas in the list must have the same root namespace. 2. All
	// `policyTargetKey.targetResource` values must point to a group resource. 3.
	// All `policyTargetKey` values must have the same `app_id` key name in the
	// `additionalTargetKeys`. 4. No two modification requests can reference the
	// same `policySchema` + ` policyTargetKey` pair.
	Requests []*GoogleChromePolicyVersionsV1DeleteGroupPolicyRequest `json:"requests,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Requests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1BatchDeleteGroupPoliciesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1BatchDeleteGroupPoliciesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1BatchInheritOrgUnitPoliciesRequest: Request
// message for specifying that multiple policy values inherit their value from
// their parents.
type GoogleChromePolicyVersionsV1BatchInheritOrgUnitPoliciesRequest struct {
	// Requests: List of policies that have to inherit their values as defined by
	// the `requests`. All requests in the list must follow these restrictions: 1.
	// All schemas in the list must have the same root namespace. 2. All
	// `policyTargetKey.targetResource` values must point to an org unit resource.
	// 3. All `policyTargetKey` values must have the same key names in the `
	// additionalTargetKeys`. This also means if one of the targets has an empty
	// `additionalTargetKeys` map, all of the targets must have an empty
	// `additionalTargetKeys` map. 4. No two modification requests can reference
	// the same `policySchema` + ` policyTargetKey` pair.
	Requests []*GoogleChromePolicyVersionsV1InheritOrgUnitPolicyRequest `json:"requests,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Requests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1BatchInheritOrgUnitPoliciesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1BatchInheritOrgUnitPoliciesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1BatchModifyGroupPoliciesRequest: Request message
// for modifying multiple policy values for a specific group-based target.
type GoogleChromePolicyVersionsV1BatchModifyGroupPoliciesRequest struct {
	// Requests: List of policies to modify as defined by the `requests`. All
	// requests in the list must follow these restrictions: 1. All schemas in the
	// list must have the same root namespace. 2. All
	// `policyTargetKey.targetResource` values must point to a group resource. 3.
	// All `policyTargetKey` values must have the same `app_id` key name in the
	// `additionalTargetKeys`. 4. No two modification requests can reference the
	// same `policySchema` + ` policyTargetKey` pair.
	Requests []*GoogleChromePolicyVersionsV1ModifyGroupPolicyRequest `json:"requests,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Requests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1BatchModifyGroupPoliciesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1BatchModifyGroupPoliciesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1BatchModifyOrgUnitPoliciesRequest: Request
// message for modifying multiple policy values for a specific target.
type GoogleChromePolicyVersionsV1BatchModifyOrgUnitPoliciesRequest struct {
	// Requests: List of policies to modify as defined by the `requests`. All
	// requests in the list must follow these restrictions: 1. All schemas in the
	// list must have the same root namespace. 2. All
	// `policyTargetKey.targetResource` values must point to an org unit resource.
	// 3. All `policyTargetKey` values must have the same key names in the `
	// additionalTargetKeys`. This also means if one of the targets has an empty
	// `additionalTargetKeys` map, all of the targets must have an empty
	// `additionalTargetKeys` map. 4. No two modification requests can reference
	// the same `policySchema` + ` policyTargetKey` pair.
	Requests []*GoogleChromePolicyVersionsV1ModifyOrgUnitPolicyRequest `json:"requests,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Requests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1BatchModifyOrgUnitPoliciesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1BatchModifyOrgUnitPoliciesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1CertificateReference: Error information for
// removing of a specific certificate on a specific target. A reference to a
// certificate.
type GoogleChromePolicyVersionsV1CertificateReference struct {
	// Network: Output only. The name of the referencing network.
	Network string `json:"network,omitempty"`
	// OrgUnitId: Output only. The obfuscated id of the org unit the referencing
	// network is in.
	OrgUnitId string `json:"orgUnitId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Network") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Network") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1CertificateReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1CertificateReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1DefineCertificateRequest: Request object for
// creating a certificate.
type GoogleChromePolicyVersionsV1DefineCertificateRequest struct {
	// CeritificateName: Optional. The optional name of the certificate. If not
	// specified, the certificate issuer will be used as the name.
	CeritificateName string `json:"ceritificateName,omitempty"`
	// Certificate: Required. The raw contents of the .PEM, .CRT, or .CER file.
	Certificate string `json:"certificate,omitempty"`
	// Settings: Optional. Certificate settings within the
	// chrome.networks.certificates namespace.
	Settings []*GoogleChromePolicyVersionsV1NetworkSetting `json:"settings,omitempty"`
	// TargetResource: Required. The target resource on which this certificate is
	// applied. The following resources are supported: * Organizational Unit
	// ("orgunits/{orgunit_id}")
	TargetResource string `json:"targetResource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CeritificateName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CeritificateName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1DefineCertificateRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1DefineCertificateRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1DefineCertificateResponse: Response object for
// creating a certificate.
type GoogleChromePolicyVersionsV1DefineCertificateResponse struct {
	// NetworkId: The guid of the certificate created by the action.
	NetworkId string `json:"networkId,omitempty"`
	// Settings: the affiliated settings of the certificate (NOT IMPLEMENTED)
	Settings []*GoogleChromePolicyVersionsV1NetworkSetting `json:"settings,omitempty"`
	// TargetResource: the resource at which the certificate is defined.
	TargetResource string `json:"targetResource,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NetworkId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NetworkId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1DefineCertificateResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1DefineCertificateResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1DefineNetworkRequest: Request object for
// creating a new network.
type GoogleChromePolicyVersionsV1DefineNetworkRequest struct {
	// Name: Required. Name of the new created network.
	Name string `json:"name,omitempty"`
	// Settings: Required. Detailed network settings.
	Settings []*GoogleChromePolicyVersionsV1NetworkSetting `json:"settings,omitempty"`
	// TargetResource: Required. The target resource on which this new network will
	// be defined. The following resources are supported: * Organizational Unit
	// ("orgunits/{orgunit_id}")
	TargetResource string `json:"targetResource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1DefineNetworkRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1DefineNetworkRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1DefineNetworkResponse: Response object for
// creating a network.
type GoogleChromePolicyVersionsV1DefineNetworkResponse struct {
	// NetworkId: Network ID of the new created network.
	NetworkId string `json:"networkId,omitempty"`
	// Settings: Detailed network settings of the new created network
	Settings []*GoogleChromePolicyVersionsV1NetworkSetting `json:"settings,omitempty"`
	// TargetResource: The target resource on which this new network will be
	// defined. The following resources are supported: * Organizational Unit
	// ("orgunits/{orgunit_id}")
	TargetResource string `json:"targetResource,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NetworkId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NetworkId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1DefineNetworkResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1DefineNetworkResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1DeleteGroupPolicyRequest: Request parameters for
// deleting the policy value of a specific group target.
type GoogleChromePolicyVersionsV1DeleteGroupPolicyRequest struct {
	// PolicySchema: The fully qualified name of the policy schema that is being
	// inherited.
	PolicySchema string `json:"policySchema,omitempty"`
	// PolicyTargetKey: Required. The key of the target for which we want to modify
	// a policy. The target resource must point to a Group.
	PolicyTargetKey *GoogleChromePolicyVersionsV1PolicyTargetKey `json:"policyTargetKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PolicySchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PolicySchema") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1DeleteGroupPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1DeleteGroupPolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1FieldConstraints: Information about any range
// constraints.
type GoogleChromePolicyVersionsV1FieldConstraints struct {
	// NumericRangeConstraint: The allowed range for numeric fields.
	NumericRangeConstraint *GoogleChromePolicyVersionsV1NumericRangeConstraint `json:"numericRangeConstraint,omitempty"`
	// UploadedFileConstraints: Constraints on the uploaded file of a file policy.
	// If present, this policy requires a URL that can be fetched by uploading a
	// file with the constraints specified in this proto.
	UploadedFileConstraints *GoogleChromePolicyVersionsV1UploadedFileConstraints `json:"uploadedFileConstraints,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NumericRangeConstraint") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NumericRangeConstraint") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1FieldConstraints) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1FieldConstraints
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1InheritOrgUnitPolicyRequest: Request parameters
// for inheriting policy value of a specific org unit target from the policy
// value of its parent org unit.
type GoogleChromePolicyVersionsV1InheritOrgUnitPolicyRequest struct {
	// PolicySchema: The fully qualified name of the policy schema that is being
	// inherited.
	PolicySchema string `json:"policySchema,omitempty"`
	// PolicyTargetKey: Required. The key of the target for which we want to modify
	// a policy. The target resource must point to an Org Unit.
	PolicyTargetKey *GoogleChromePolicyVersionsV1PolicyTargetKey `json:"policyTargetKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PolicySchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PolicySchema") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1InheritOrgUnitPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1InheritOrgUnitPolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1ListGroupPriorityOrderingRequest: Request
// message for listing the group priority ordering of an app.
type GoogleChromePolicyVersionsV1ListGroupPriorityOrderingRequest struct {
	// PolicyNamespace: The namespace of the policy type for the request.
	PolicyNamespace string `json:"policyNamespace,omitempty"`
	// PolicySchema: The schema name of the policy for the request.
	PolicySchema string `json:"policySchema,omitempty"`
	// PolicyTargetKey: Required. The key of the target for which we want to
	// retrieve the group priority ordering. The target resource must point to an
	// app.
	PolicyTargetKey *GoogleChromePolicyVersionsV1PolicyTargetKey `json:"policyTargetKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PolicyNamespace") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PolicyNamespace") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1ListGroupPriorityOrderingRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1ListGroupPriorityOrderingRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1ListGroupPriorityOrderingResponse: Response
// message for listing the group priority ordering of an app.
type GoogleChromePolicyVersionsV1ListGroupPriorityOrderingResponse struct {
	// GroupIds: Output only. The group IDs, in priority ordering.
	GroupIds []string `json:"groupIds,omitempty"`
	// PolicyNamespace: Output only. The namespace of the policy type of the group
	// IDs.
	PolicyNamespace string `json:"policyNamespace,omitempty"`
	// PolicySchema: Output only. The schema name of the policy for the group IDs.
	PolicySchema string `json:"policySchema,omitempty"`
	// PolicyTargetKey: Output only. The target resource for which the group
	// priority ordering has been retrieved.
	PolicyTargetKey *GoogleChromePolicyVersionsV1PolicyTargetKey `json:"policyTargetKey,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "GroupIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GroupIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1ListGroupPriorityOrderingResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1ListGroupPriorityOrderingResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1ListPolicySchemasResponse: Response message for
// listing policy schemas that match a filter.
type GoogleChromePolicyVersionsV1ListPolicySchemasResponse struct {
	// NextPageToken: The page token used to get the next page of policy schemas.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// PolicySchemas: The list of policy schemas that match the query.
	PolicySchemas []*GoogleChromePolicyVersionsV1PolicySchema `json:"policySchemas,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1ListPolicySchemasResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1ListPolicySchemasResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1ModifyGroupPolicyRequest: Request parameters for
// modifying a policy value for a specific group target.
type GoogleChromePolicyVersionsV1ModifyGroupPolicyRequest struct {
	// PolicyTargetKey: Required. The key of the target for which we want to modify
	// a policy. The target resource must point to a Group.
	PolicyTargetKey *GoogleChromePolicyVersionsV1PolicyTargetKey `json:"policyTargetKey,omitempty"`
	// PolicyValue: The new value for the policy.
	PolicyValue *GoogleChromePolicyVersionsV1PolicyValue `json:"policyValue,omitempty"`
	// UpdateMask: Required. Policy fields to update. Only fields in this mask will
	// be updated; other fields in `policy_value` will be ignored (even if they
	// have values). If a field is in this list it must have a value in
	// 'policy_value'.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PolicyTargetKey") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PolicyTargetKey") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1ModifyGroupPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1ModifyGroupPolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1ModifyOrgUnitPolicyRequest: Request parameters
// for modifying a policy value for a specific org unit target.
type GoogleChromePolicyVersionsV1ModifyOrgUnitPolicyRequest struct {
	// PolicyTargetKey: Required. The key of the target for which we want to modify
	// a policy. The target resource must point to an Org Unit.
	PolicyTargetKey *GoogleChromePolicyVersionsV1PolicyTargetKey `json:"policyTargetKey,omitempty"`
	// PolicyValue: The new value for the policy.
	PolicyValue *GoogleChromePolicyVersionsV1PolicyValue `json:"policyValue,omitempty"`
	// UpdateMask: Required. Policy fields to update. Only fields in this mask will
	// be updated; other fields in `policy_value` will be ignored (even if they
	// have values). If a field is in this list it must have a value in
	// 'policy_value'.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PolicyTargetKey") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PolicyTargetKey") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1ModifyOrgUnitPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1ModifyOrgUnitPolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1NetworkSetting: A network setting contains
// network configurations. It adheres to the PolicyAPI formats defined under
// the namespace chrome.networks.{wifi/ethernet/cellular/vpn}.Details
type GoogleChromePolicyVersionsV1NetworkSetting struct {
	// PolicySchema: The fully qualified name of the network setting.
	PolicySchema string `json:"policySchema,omitempty"`
	// Value: The value of the network setting.
	Value googleapi.RawMessage `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PolicySchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PolicySchema") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1NetworkSetting) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1NetworkSetting
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1NumericRangeConstraint: A constraint on upper
// and/or lower bounds, with at least one being set.
type GoogleChromePolicyVersionsV1NumericRangeConstraint struct {
	// Maximum: Maximum value.
	Maximum int64 `json:"maximum,omitempty,string"`
	// Minimum: Minimum value.
	Minimum int64 `json:"minimum,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Maximum") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Maximum") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1NumericRangeConstraint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1NumericRangeConstraint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1PolicyApiLifecycle: Lifecycle information.
type GoogleChromePolicyVersionsV1PolicyApiLifecycle struct {
	// DeprecatedInFavorOf: In the event that this policy was deprecated in favor
	// of another policy, the fully qualified namespace(s) of the new policies as
	// they will show in PolicyAPI. Could only be set if policy_api_lifecycle_stage
	// is API_DEPRECATED.
	DeprecatedInFavorOf []string `json:"deprecatedInFavorOf,omitempty"`
	// Description: Description about current life cycle.
	Description string `json:"description,omitempty"`
	// EndSupport: End supporting date for current policy. Attempting to modify a
	// policy after its end support date will result in a Bad Request (400 error).
	// Could only be set if policy_api_lifecycle_stage is API_DEPRECATED.
	EndSupport *GoogleTypeDate `json:"endSupport,omitempty"`
	// PolicyApiLifecycleStage: Indicates current life cycle stage of the policy
	// API.
	//
	// Possible values:
	//   "API_UNSPECIFIED" - Policy Api Lifecycle is Unspecified.
	//   "API_PREVIEW" - Policy is not working yet, but giving developers heads up
	// on format. This stage can transfer to API_DEVELOPEMNT or API_CURRENT.
	//   "API_DEVELOPMENT" - Policy can change format in backward incompatible way
	// (breaking change). This stage can transfer to API_CURRENT or API_DEPRECATED.
	// This could be used for policies launched only to TTs or launched to selected
	// customers for emergency usage.
	//   "API_CURRENT" - Policy in official format. Policy can change format in
	// backward compatible way (non-breaking change). Example: this policy can
	// introduce a new field, which is considered non-breaking change, when field
	// masks are properly utilized. This stage can transfer to API_DEPRECATED.
	//   "API_DEPRECATED" - Please stop using this policy. This policy is
	// deprecated and may/will be removed in the future. Most likely a new policy
	// was introduced to replace this one.
	PolicyApiLifecycleStage string `json:"policyApiLifecycleStage,omitempty"`
	// ScheduledToDeprecatePolicies: Corresponding to deprecated_in_favor_of, the
	// fully qualified namespace(s) of the old policies that will be deprecated
	// because of introduction of this policy.
	ScheduledToDeprecatePolicies []string `json:"scheduledToDeprecatePolicies,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeprecatedInFavorOf") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeprecatedInFavorOf") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1PolicyApiLifecycle) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1PolicyApiLifecycle
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1PolicyModificationError: Error information for a
// modification request of a specific policy on a specific target.
type GoogleChromePolicyVersionsV1PolicyModificationError struct {
	// Errors: Output only. The non-field errors related to the modification.
	Errors []string `json:"errors,omitempty"`
	// FieldErrors: Output only. The error messages related to the modification.
	FieldErrors []*GoogleChromePolicyVersionsV1PolicyModificationFieldError `json:"fieldErrors,omitempty"`
	// PolicySchema: Output only. The specific policy schema modification that had
	// an error.
	PolicySchema string `json:"policySchema,omitempty"`
	// PolicyTargetKey: Output only. The specific policy target modification that
	// had error.
	PolicyTargetKey *GoogleChromePolicyVersionsV1PolicyTargetKey `json:"policyTargetKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1PolicyModificationError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1PolicyModificationError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1PolicyModificationErrorDetails: Details of the
// errors encountered during a policy modification request. This message will
// be returned as part of the details of a google.rpc.Status returned to the
// user when there is an error in their request.
type GoogleChromePolicyVersionsV1PolicyModificationErrorDetails struct {
	// ModificationErrors: Output only. List of specific policy modifications
	// errors that may have occurred during a modifying request.
	ModificationErrors []*GoogleChromePolicyVersionsV1PolicyModificationError `json:"modificationErrors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModificationErrors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModificationErrors") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1PolicyModificationErrorDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1PolicyModificationErrorDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1PolicyModificationFieldError: Error information
// for a modification request of a specific field on a specific policy.
type GoogleChromePolicyVersionsV1PolicyModificationFieldError struct {
	// Error: Output only. The error message related to the field.
	Error string `json:"error,omitempty"`
	// Field: Output only. The name of the field with the error.
	Field string `json:"field,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Error") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Error") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1PolicyModificationFieldError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1PolicyModificationFieldError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1PolicySchema: Resource representing a policy
// schema.
type GoogleChromePolicyVersionsV1PolicySchema struct {
	// AccessRestrictions: Output only. Specific access restrictions related to
	// this policy.
	AccessRestrictions []string `json:"accessRestrictions,omitempty"`
	// AdditionalTargetKeyNames: Output only. Additional key names that will be
	// used to identify the target of the policy value. When specifying a
	// `policyTargetKey`, each of the additional keys specified here will have to
	// be included in the `additionalTargetKeys` map.
	AdditionalTargetKeyNames []*GoogleChromePolicyVersionsV1AdditionalTargetKeyName `json:"additionalTargetKeyNames,omitempty"`
	// CategoryTitle: Title of the category in which a setting belongs.
	CategoryTitle string `json:"categoryTitle,omitempty"`
	// Definition: Schema definition using proto descriptor.
	Definition *Proto2FileDescriptorProto `json:"definition,omitempty"`
	// FieldDescriptions: Output only. Detailed description of each field that is
	// part of the schema. Fields are suggested to be displayed by the ordering in
	// this list, not by field number.
	FieldDescriptions []*GoogleChromePolicyVersionsV1PolicySchemaFieldDescription `json:"fieldDescriptions,omitempty"`
	// Name: Format: name=customers/{customer}/policySchemas/{schema_namespace}
	Name string `json:"name,omitempty"`
	// Notices: Output only. Special notice messages related to setting certain
	// values in certain fields in the schema.
	Notices []*GoogleChromePolicyVersionsV1PolicySchemaNoticeDescription `json:"notices,omitempty"`
	// PolicyApiLifecycle: Output only. Current lifecycle information.
	PolicyApiLifecycle *GoogleChromePolicyVersionsV1PolicyApiLifecycle `json:"policyApiLifecycle,omitempty"`
	// PolicyDescription: Output only. Description about the policy schema for user
	// consumption.
	PolicyDescription string `json:"policyDescription,omitempty"`
	// SchemaName: Output only. The fully qualified name of the policy schema. This
	// value is used to fill the field `policy_schema` in PolicyValue when calling
	// BatchInheritOrgUnitPolicies BatchModifyOrgUnitPolicies
	// BatchModifyGroupPolicies or BatchDeleteGroupPolicies.
	SchemaName string `json:"schemaName,omitempty"`
	// SupportUri: Output only. URI to related support article for this schema.
	SupportUri string `json:"supportUri,omitempty"`
	// SupportedPlatforms: Output only. List indicates that the policy will only
	// apply to devices/users on these platforms.
	//
	// Possible values:
	//   "PLATFORM_UNSPECIFIED" - Unspecified platform.
	//   "CHROME_OS" - ChromeOS.
	//   "CHROME_BROWSER" - Chrome Browser for OSX/Windows/Linux.
	//   "CHROME_BROWSER_FOR_ANDROID" - Chrome Browser for Android.
	//   "CHROME_BROWSER_FOR_IOS" - Chrome Browser for iOS.
	SupportedPlatforms []string `json:"supportedPlatforms,omitempty"`
	// ValidTargetResources: Output only. Information about applicable target
	// resources for the policy.
	//
	// Possible values:
	//   "TARGET_RESOURCE_UNSPECIFIED" - Unspecified target resource.
	//   "ORG_UNIT" - Organizational Unit target resource.
	//   "GROUP" - Group target resource.
	ValidTargetResources []string `json:"validTargetResources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccessRestrictions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessRestrictions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1PolicySchema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1PolicySchema
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1PolicySchemaFieldDependencies: The field and the
// value it must have for another field to be allowed to be set.
type GoogleChromePolicyVersionsV1PolicySchemaFieldDependencies struct {
	// SourceField: The source field which this field depends on.
	SourceField string `json:"sourceField,omitempty"`
	// SourceFieldValue: The value which the source field must have for this field
	// to be allowed to be set.
	SourceFieldValue string `json:"sourceFieldValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SourceField") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SourceField") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1PolicySchemaFieldDependencies) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1PolicySchemaFieldDependencies
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1PolicySchemaFieldDescription: Provides detailed
// information for a particular field that is part of a PolicySchema.
type GoogleChromePolicyVersionsV1PolicySchemaFieldDescription struct {
	// DefaultValue: Output only. Client default if the policy is unset.
	DefaultValue interface{} `json:"defaultValue,omitempty"`
	// Description: Deprecated. Use name and field_description instead. The
	// description for the field.
	Description string `json:"description,omitempty"`
	// Field: Output only. The name of the field for associated with this
	// description.
	Field string `json:"field,omitempty"`
	// FieldConstraints: Output only. Information on any input constraints
	// associated on the values for the field.
	FieldConstraints *GoogleChromePolicyVersionsV1FieldConstraints `json:"fieldConstraints,omitempty"`
	// FieldDependencies: Output only. Provides a list of fields and values. At
	// least one of the fields must have the corresponding value in order for this
	// field to be allowed to be set.
	FieldDependencies []*GoogleChromePolicyVersionsV1PolicySchemaFieldDependencies `json:"fieldDependencies,omitempty"`
	// FieldDescription: Output only. The description of the field.
	FieldDescription string `json:"fieldDescription,omitempty"`
	// InputConstraint: Output only. Any input constraints associated on the values
	// for the field.
	InputConstraint string `json:"inputConstraint,omitempty"`
	// KnownValueDescriptions: Output only. If the field has a set of known values,
	// this field will provide a description for these values.
	KnownValueDescriptions []*GoogleChromePolicyVersionsV1PolicySchemaFieldKnownValueDescription `json:"knownValueDescriptions,omitempty"`
	// Name: Output only. The name of the field.
	Name string `json:"name,omitempty"`
	// NestedFieldDescriptions: Output only. Provides the description of the fields
	// nested in this field, if the field is a message type that defines multiple
	// fields. Fields are suggested to be displayed by the ordering in this list,
	// not by field number.
	NestedFieldDescriptions []*GoogleChromePolicyVersionsV1PolicySchemaFieldDescription `json:"nestedFieldDescriptions,omitempty"`
	// RequiredItems: Output only. Provides a list of fields that are required to
	// be set if this field has a certain value.
	RequiredItems []*GoogleChromePolicyVersionsV1PolicySchemaRequiredItems `json:"requiredItems,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1PolicySchemaFieldDescription) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1PolicySchemaFieldDescription
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1PolicySchemaFieldKnownValueDescription: Provides
// detailed information about a known value that is allowed for a particular
// field in a PolicySchema.
type GoogleChromePolicyVersionsV1PolicySchemaFieldKnownValueDescription struct {
	// Description: Output only. Additional description for this value.
	Description string `json:"description,omitempty"`
	// FieldDependencies: Output only. Field conditions required for this value to
	// be valid.
	FieldDependencies []*GoogleChromePolicyVersionsV1PolicySchemaFieldDependencies `json:"fieldDependencies,omitempty"`
	// Value: Output only. The string represenstation of the value that can be set
	// for the field.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1PolicySchemaFieldKnownValueDescription) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1PolicySchemaFieldKnownValueDescription
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1PolicySchemaNoticeDescription: Provides special
// notice messages related to a particular value in a field that is part of a
// PolicySchema.
type GoogleChromePolicyVersionsV1PolicySchemaNoticeDescription struct {
	// AcknowledgementRequired: Output only. Whether the user needs to acknowledge
	// the notice message before the value can be set.
	AcknowledgementRequired bool `json:"acknowledgementRequired,omitempty"`
	// Field: Output only. The field name associated with the notice.
	Field string `json:"field,omitempty"`
	// NoticeMessage: Output only. The notice message associate with the value of
	// the field.
	NoticeMessage string `json:"noticeMessage,omitempty"`
	// NoticeValue: Output only. The value of the field that has a notice. When
	// setting the field to this value, the user may be required to acknowledge the
	// notice message in order for the value to be set.
	NoticeValue string `json:"noticeValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AcknowledgementRequired") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcknowledgementRequired") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1PolicySchemaNoticeDescription) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1PolicySchemaNoticeDescription
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1PolicySchemaRequiredItems: The fields that will
// become required based on the value of this field.
type GoogleChromePolicyVersionsV1PolicySchemaRequiredItems struct {
	// FieldConditions: The value(s) of the field that provoke required field
	// enforcement. An empty field_conditions implies that any value assigned to
	// this field will provoke required field enforcement.
	FieldConditions []string `json:"fieldConditions,omitempty"`
	// RequiredFields: The fields that are required as a consequence of the field
	// conditions.
	RequiredFields []string `json:"requiredFields,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FieldConditions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FieldConditions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1PolicySchemaRequiredItems) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1PolicySchemaRequiredItems
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1PolicyTargetKey: The key used to identify the
// target on which the policy will be applied.
type GoogleChromePolicyVersionsV1PolicyTargetKey struct {
	// AdditionalTargetKeys: Map containing the additional target key name and
	// value pairs used to further identify the target of the policy.
	AdditionalTargetKeys map[string]string `json:"additionalTargetKeys,omitempty"`
	// TargetResource: The target resource on which this policy is applied. The
	// following resources are supported: * Organizational Unit
	// ("orgunits/{orgunit_id}") * Group ("groups/{group_id}")
	TargetResource string `json:"targetResource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalTargetKeys") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalTargetKeys") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1PolicyTargetKey) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1PolicyTargetKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1PolicyValue: A particular value for a policy
// managed by the service.
type GoogleChromePolicyVersionsV1PolicyValue struct {
	// PolicySchema: The fully qualified name of the policy schema associated with
	// this policy.
	PolicySchema string `json:"policySchema,omitempty"`
	// Value: The value of the policy that is compatible with the schema that it is
	// associated with.
	Value googleapi.RawMessage `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PolicySchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PolicySchema") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1PolicyValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1PolicyValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1RemoveCertificateErrorDetails: Details of the
// errors encountered during a remove certificate request. This message will be
// returned as part of the details of a google.rpc.Status returned to the user
// when there is an error in their request.
type GoogleChromePolicyVersionsV1RemoveCertificateErrorDetails struct {
	// CertificateReferences: Output only. If the certificate was not removed, a
	// list of references to the certificate that prevented it from being removed.
	// Only unreferenced certificates can be removed.
	CertificateReferences []*GoogleChromePolicyVersionsV1CertificateReference `json:"certificateReferences,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CertificateReferences") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CertificateReferences") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1RemoveCertificateErrorDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1RemoveCertificateErrorDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1RemoveCertificateRequest: Request object for
// removing a certificate.
type GoogleChromePolicyVersionsV1RemoveCertificateRequest struct {
	// NetworkId: Required. The GUID of the certificate to remove.
	NetworkId string `json:"networkId,omitempty"`
	// TargetResource: Required. The target resource on which this certificate will
	// be removed. The following resources are supported: * Organizational Unit
	// ("orgunits/{orgunit_id}")
	TargetResource string `json:"targetResource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NetworkId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NetworkId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1RemoveCertificateRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1RemoveCertificateRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1RemoveCertificateResponse: Response object for
// removing a certificate.
type GoogleChromePolicyVersionsV1RemoveCertificateResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleChromePolicyVersionsV1RemoveNetworkRequest: Request object for
// removing a network
type GoogleChromePolicyVersionsV1RemoveNetworkRequest struct {
	// NetworkId: Required. The GUID of the network to remove.
	NetworkId string `json:"networkId,omitempty"`
	// TargetResource: Required. The target resource on which this network will be
	// removed. The following resources are supported: * Organizational Unit
	// ("orgunits/{orgunit_id}")
	TargetResource string `json:"targetResource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NetworkId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NetworkId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1RemoveNetworkRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1RemoveNetworkRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1RemoveNetworkResponse: Response object for
// removing a network.
type GoogleChromePolicyVersionsV1RemoveNetworkResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleChromePolicyVersionsV1ResolveRequest: Request message for getting the
// resolved policy value for a specific target.
type GoogleChromePolicyVersionsV1ResolveRequest struct {
	// PageSize: The maximum number of policies to return, defaults to 100 and has
	// a maximum of 1000.
	PageSize int64 `json:"pageSize,omitempty"`
	// PageToken: The page token used to retrieve a specific page of the request.
	PageToken string `json:"pageToken,omitempty"`
	// PolicySchemaFilter: Required. The schema filter to apply to the resolve
	// request. Specify a schema name to view a particular schema, for example:
	// chrome.users.ShowLogoutButton Wildcards are supported, but only in the leaf
	// portion of the schema name. Wildcards cannot be used in namespace directly.
	// Please read
	// https://developers.google.com/chrome/policy/guides/policy-schemas for
	// details on schema namespaces. For example: Valid: "chrome.users.*",
	// "chrome.users.apps.*", "chrome.printers.*" Invalid: "*", "*.users",
	// "chrome.*", "chrome.*.apps.*"
	PolicySchemaFilter string `json:"policySchemaFilter,omitempty"`
	// PolicyTargetKey: Required. The key of the target resource on which the
	// policies should be resolved.
	PolicyTargetKey *GoogleChromePolicyVersionsV1PolicyTargetKey `json:"policyTargetKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1ResolveRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1ResolveRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1ResolveResponse: Response message for getting
// the resolved policy value for a specific target.
type GoogleChromePolicyVersionsV1ResolveResponse struct {
	// NextPageToken: The page token used to get the next set of resolved policies
	// found by the request.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ResolvedPolicies: The list of resolved policies found by the resolve
	// request.
	ResolvedPolicies []*GoogleChromePolicyVersionsV1ResolvedPolicy `json:"resolvedPolicies,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1ResolveResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1ResolveResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1ResolvedPolicy: The resolved value of a policy
// for a given target.
type GoogleChromePolicyVersionsV1ResolvedPolicy struct {
	// AddedSourceKey: Output only. The added source key establishes at which level
	// an entity was explicitly added for management. This is useful for certain
	// type of policies that are only applied if they are explicitly added for
	// management. For example: apps and networks. An entity can only be deleted
	// from management in an Organizational Unit that it was explicitly added to.
	// If this is not present it means that the policy is managed without the need
	// to explicitly add an entity, for example: standard user or device policies.
	AddedSourceKey *GoogleChromePolicyVersionsV1PolicyTargetKey `json:"addedSourceKey,omitempty"`
	// SourceKey: Output only. The source resource from which this policy value is
	// obtained. May be the same as `targetKey` if the policy is directly modified
	// on the target, otherwise it would be another resource from which the policy
	// gets its value (if applicable). If not present, the source is the default
	// value for the customer.
	SourceKey *GoogleChromePolicyVersionsV1PolicyTargetKey `json:"sourceKey,omitempty"`
	// TargetKey: Output only. The target resource for which the resolved policy
	// value applies.
	TargetKey *GoogleChromePolicyVersionsV1PolicyTargetKey `json:"targetKey,omitempty"`
	// Value: Output only. The resolved value of the policy.
	Value *GoogleChromePolicyVersionsV1PolicyValue `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AddedSourceKey") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddedSourceKey") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1ResolvedPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1ResolvedPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1UpdateGroupPriorityOrderingRequest: Request
// message for updating the group priority ordering of an app.
type GoogleChromePolicyVersionsV1UpdateGroupPriorityOrderingRequest struct {
	// GroupIds: Required. The group IDs, in desired priority ordering.
	GroupIds []string `json:"groupIds,omitempty"`
	// PolicyNamespace: The namespace of the policy type for the request.
	PolicyNamespace string `json:"policyNamespace,omitempty"`
	// PolicySchema: The schema name of the policy for the request.
	PolicySchema string `json:"policySchema,omitempty"`
	// PolicyTargetKey: Required. The key of the target for which we want to update
	// the group priority ordering. The target resource must point to an app.
	PolicyTargetKey *GoogleChromePolicyVersionsV1PolicyTargetKey `json:"policyTargetKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GroupIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GroupIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1UpdateGroupPriorityOrderingRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1UpdateGroupPriorityOrderingRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1UploadPolicyFileRequest: Request message for
// uploading a file for a policy.
type GoogleChromePolicyVersionsV1UploadPolicyFileRequest struct {
	// PolicyField: Required. The fully qualified policy schema and field name this
	// file is uploaded for. This information will be used to validate the content
	// type of the file.
	PolicyField string `json:"policyField,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PolicyField") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PolicyField") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1UploadPolicyFileRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1UploadPolicyFileRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1UploadPolicyFileResponse: Response message for
// downloading an uploaded file.
type GoogleChromePolicyVersionsV1UploadPolicyFileResponse struct {
	// DownloadUri: The uri for end user to download the file.
	DownloadUri string `json:"downloadUri,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DownloadUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DownloadUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1UploadPolicyFileResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1UploadPolicyFileResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromePolicyVersionsV1UploadedFileConstraints: Constraints on the
// uploaded file of a file policy.
type GoogleChromePolicyVersionsV1UploadedFileConstraints struct {
	// SizeLimitBytes: The size limit of uploaded files for a setting, in bytes.
	SizeLimitBytes int64 `json:"sizeLimitBytes,omitempty,string"`
	// SupportedContentTypes: File types that can be uploaded for a setting.
	//
	// Possible values:
	//   "CONTENT_TYPE_UNSPECIFIED" - Unspecified content type.
	//   "CONTENT_TYPE_PLAIN_TEXT" - Plain text.
	//   "CONTENT_TYPE_HTML" - HTML.
	//   "CONTENT_TYPE_IMAGE_JPEG" - JPEG.
	//   "CONTENT_TYPE_IMAGE_GIF" - GIF.
	//   "CONTENT_TYPE_IMAGE_PNG" - PNG.
	//   "CONTENT_TYPE_JSON" - JSON.
	//   "CONTENT_TYPE_ZIP" - ZIP.
	//   "CONTENT_TYPE_GZIP" - GZIP.
	//   "CONTENT_TYPE_CSV" - CSV.
	//   "CONTENT_TYPE_YAML" - YAML.
	//   "CONTENT_TYPE_IMAGE_WEBP" - WEBP.
	SupportedContentTypes []string `json:"supportedContentTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SizeLimitBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SizeLimitBytes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromePolicyVersionsV1UploadedFileConstraints) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromePolicyVersionsV1UploadedFileConstraints
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to avoid
// defining duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For instance:
// service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); }
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleTypeDate: Represents a whole or partial calendar date, such as a
// birthday. The time of day and time zone are either specified elsewhere or
// are insignificant. The date is relative to the Gregorian Calendar. This can
// represent one of the following: * A full date, with non-zero year, month,
// and day values. * A month and day, with a zero year (for example, an
// anniversary). * A year on its own, with a zero month and a zero day. * A
// year and month, with a zero day (for example, a credit card expiration
// date). Related types: * google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type GoogleTypeDate struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and month,
	// or 0 to specify a year by itself or a year and month where the day isn't
	// significant.
	Day int64 `json:"day,omitempty"`
	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year without
	// a month and day.
	Month int64 `json:"month,omitempty"`
	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
	// without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeDate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeDate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Proto2DescriptorProto: Describes a message type.
type Proto2DescriptorProto struct {
	EnumType   []*Proto2EnumDescriptorProto  `json:"enumType,omitempty"`
	Field      []*Proto2FieldDescriptorProto `json:"field,omitempty"`
	Name       string                        `json:"name,omitempty"`
	NestedType []*Proto2DescriptorProto      `json:"nestedType,omitempty"`
	OneofDecl  []*Proto2OneofDescriptorProto `json:"oneofDecl,omitempty"`
	// Visibility: Support for `export` and `local` keywords on enums.
	//
	// Possible values:
	//   "VISIBILITY_UNSET"
	//   "VISIBILITY_LOCAL"
	//   "VISIBILITY_EXPORT"
	Visibility string `json:"visibility,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnumType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnumType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Proto2DescriptorProto) MarshalJSON() ([]byte, error) {
	type NoMethod Proto2DescriptorProto
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Proto2EnumDescriptorProto: Describes an enum type.
type Proto2EnumDescriptorProto struct {
	Name  string                            `json:"name,omitempty"`
	Value []*Proto2EnumValueDescriptorProto `json:"value,omitempty"`
	// Visibility: Support for `export` and `local` keywords on enums.
	//
	// Possible values:
	//   "VISIBILITY_UNSET"
	//   "VISIBILITY_LOCAL"
	//   "VISIBILITY_EXPORT"
	Visibility string `json:"visibility,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Proto2EnumDescriptorProto) MarshalJSON() ([]byte, error) {
	type NoMethod Proto2EnumDescriptorProto
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Proto2EnumValueDescriptorProto: Describes a value within an enum.
type Proto2EnumValueDescriptorProto struct {
	Name   string `json:"name,omitempty"`
	Number int64  `json:"number,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Proto2EnumValueDescriptorProto) MarshalJSON() ([]byte, error) {
	type NoMethod Proto2EnumValueDescriptorProto
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Proto2FieldDescriptorProto: Describes a field within a message.
type Proto2FieldDescriptorProto struct {
	// DefaultValue: For numeric types, contains the original text representation
	// of the value. For booleans, "true" or "false". For strings, contains the
	// default text contents (not escaped in any way). For bytes, contains the C
	// escaped value. All bytes >= 128 are escaped.
	DefaultValue string `json:"defaultValue,omitempty"`
	// JsonName: JSON name of this field. The value is set by protocol compiler. If
	// the user has set a "json_name" option on this field, that option's value
	// will be used. Otherwise, it's deduced from the field's name by converting it
	// to camelCase.
	JsonName string `json:"jsonName,omitempty"`
	// Possible values:
	//   "LABEL_OPTIONAL" - 0 is reserved for errors
	//   "LABEL_REPEATED"
	//   "LABEL_REQUIRED" - The required label is only allowed in proto2. In proto3
	// and Editions it's explicitly prohibited. In Editions, the `field_presence`
	// feature can be used to get this behavior.
	Label  string `json:"label,omitempty"`
	Name   string `json:"name,omitempty"`
	Number int64  `json:"number,omitempty"`
	// OneofIndex: If set, gives the index of a oneof in the containing type's
	// oneof_decl list. This field is a member of that oneof.
	OneofIndex int64 `json:"oneofIndex,omitempty"`
	// Proto3Optional: If true, this is a proto3 "optional". When a proto3 field is
	// optional, it tracks presence regardless of field type. When proto3_optional
	// is true, this field must belong to a oneof to signal to old proto3 clients
	// that presence is tracked for this field. This oneof is known as a
	// "synthetic" oneof, and this field must be its sole member (each proto3
	// optional field gets its own synthetic oneof). Synthetic oneofs exist in the
	// descriptor only, and do not generate any API. Synthetic oneofs must be
	// ordered after all "real" oneofs. For message fields, proto3_optional doesn't
	// create any semantic change, since non-repeated message fields always track
	// presence. However it still indicates the semantic detail of whether the user
	// wrote "optional" or not. This can be useful for round-tripping the .proto
	// file. For consistency we give message fields a synthetic oneof also, even
	// though it is not required to track presence. This is especially important
	// because the parser can't tell if a field is a message or an enum, so it must
	// always create a synthetic oneof. Proto2 optional fields do not set this
	// flag, because they already indicate optional with `LABEL_OPTIONAL`.
	Proto3Optional bool `json:"proto3Optional,omitempty"`
	// Type: If type_name is set, this need not be set. If both this and type_name
	// are set, this must be one of TYPE_ENUM, TYPE_MESSAGE or TYPE_GROUP.
	//
	// Possible values:
	//   "TYPE_DOUBLE" - 0 is reserved for errors. Order is weird for historical
	// reasons.
	//   "TYPE_FLOAT"
	//   "TYPE_INT64" - Not ZigZag encoded. Negative numbers take 10 bytes. Use
	// TYPE_SINT64 if negative values are likely.
	//   "TYPE_UINT64"
	//   "TYPE_INT32" - Not ZigZag encoded. Negative numbers take 10 bytes. Use
	// TYPE_SINT32 if negative values are likely.
	//   "TYPE_FIXED64"
	//   "TYPE_FIXED32"
	//   "TYPE_BOOL"
	//   "TYPE_STRING"
	//   "TYPE_GROUP" - Tag-delimited aggregate. Group type is deprecated and not
	// supported after proto2. However, Proto3 implementations should still be able
	// to parse the group wire format and treat group fields as unknown fields. In
	// Editions, the group wire format can be enabled via the `message_encoding`
	// feature.
	//   "TYPE_MESSAGE" - Length-delimited aggregate.
	//   "TYPE_BYTES" - New in version 2.
	//   "TYPE_UINT32"
	//   "TYPE_ENUM"
	//   "TYPE_SFIXED32"
	//   "TYPE_SFIXED64"
	//   "TYPE_SINT32" - Uses ZigZag encoding.
	//   "TYPE_SINT64" - Uses ZigZag encoding.
	Type string `json:"type,omitempty"`
	// TypeName: For message and enum types, this is the name of the type. If the
	// name starts with a '.', it is fully-qualified. Otherwise, C++-like scoping
	// rules are used to find the type (i.e. first the nested types within this
	// message are searched, then within the parent, on up to the root namespace).
	TypeName string `json:"typeName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Proto2FieldDescriptorProto) MarshalJSON() ([]byte, error) {
	type NoMethod Proto2FieldDescriptorProto
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Proto2FileDescriptorProto: Describes a complete .proto file.
type Proto2FileDescriptorProto struct {
	// EditionDeprecated: BEGIN GOOGLE-INTERNAL TODO(b/297898292) Deprecate and
	// remove this field in favor of enums. END GOOGLE-INTERNAL
	EditionDeprecated string                       `json:"editionDeprecated,omitempty"`
	EnumType          []*Proto2EnumDescriptorProto `json:"enumType,omitempty"`
	// MessageType: All top-level definitions in this file.
	MessageType []*Proto2DescriptorProto `json:"messageType,omitempty"`
	// Name: file name, relative to root of source tree
	Name string `json:"name,omitempty"`
	// OptionDependency: Names of files imported by this file purely for the
	// purpose of providing option extensions. These are excluded from the
	// dependency list above.
	OptionDependency []string `json:"optionDependency,omitempty"`
	// Package: e.g. "foo", "foo.bar", etc.
	Package string `json:"package,omitempty"`
	// Syntax: The syntax of the proto file. The supported values are "proto2",
	// "proto3", and "editions". If `edition` is present, this value must be
	// "editions". WARNING: This field should only be used by protobuf plugins or
	// special cases like the proto compiler. Other uses are discouraged and
	// developers should rely on the protoreflect APIs for their client language.
	Syntax string `json:"syntax,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EditionDeprecated") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EditionDeprecated") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Proto2FileDescriptorProto) MarshalJSON() ([]byte, error) {
	type NoMethod Proto2FileDescriptorProto
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Proto2OneofDescriptorProto: Describes a oneof.
type Proto2OneofDescriptorProto struct {
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Proto2OneofDescriptorProto) MarshalJSON() ([]byte, error) {
	type NoMethod Proto2OneofDescriptorProto
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CustomersPoliciesResolveCall struct {
	s                                          *Service
	customer                                   string
	googlechromepolicyversionsv1resolverequest *GoogleChromePolicyVersionsV1ResolveRequest
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// Resolve: Gets the resolved policy values for a list of policies that match a
// search query.
//
//   - customer: ID of the G Suite account or literal "my_customer" for the
//     customer associated to the request.
func (r *CustomersPoliciesService) Resolve(customer string, googlechromepolicyversionsv1resolverequest *GoogleChromePolicyVersionsV1ResolveRequest) *CustomersPoliciesResolveCall {
	c := &CustomersPoliciesResolveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.googlechromepolicyversionsv1resolverequest = googlechromepolicyversionsv1resolverequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersPoliciesResolveCall) Fields(s ...googleapi.Field) *CustomersPoliciesResolveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersPoliciesResolveCall) Context(ctx context.Context) *CustomersPoliciesResolveCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersPoliciesResolveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersPoliciesResolveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlechromepolicyversionsv1resolverequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/policies:resolve")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromepolicy.customers.policies.resolve", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromepolicy.customers.policies.resolve" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromePolicyVersionsV1ResolveResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersPoliciesResolveCall) Do(opts ...googleapi.CallOption) (*GoogleChromePolicyVersionsV1ResolveResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromePolicyVersionsV1ResolveResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromepolicy.customers.policies.resolve", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersPoliciesResolveCall) Pages(ctx context.Context, f func(*GoogleChromePolicyVersionsV1ResolveResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.googlechromepolicyversionsv1resolverequest.PageToken = pt }(c.googlechromepolicyversionsv1resolverequest.PageToken)
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googlechromepolicyversionsv1resolverequest.PageToken = x.NextPageToken
	}
}

type CustomersPoliciesGroupsBatchDeleteCall struct {
	s                                                           *Service
	customer                                                    string
	googlechromepolicyversionsv1batchdeletegrouppoliciesrequest *GoogleChromePolicyVersionsV1BatchDeleteGroupPoliciesRequest
	urlParams_                                                  gensupport.URLParams
	ctx_                                                        context.Context
	header_                                                     http.Header
}

// BatchDelete: Delete multiple policy values that are applied to a specific
// group. All targets must have the same target format. That is to say that
// they must point to the same target resource and must have the same keys
// specified in `additionalTargetKeyNames`, though the values for those keys
// may be different. On failure the request will return the error details as
// part of the google.rpc.Status.
//
//   - customer: ID of the Google Workspace account or literal "my_customer" for
//     the customer associated to the request.
func (r *CustomersPoliciesGroupsService) BatchDelete(customer string, googlechromepolicyversionsv1batchdeletegrouppoliciesrequest *GoogleChromePolicyVersionsV1BatchDeleteGroupPoliciesRequest) *CustomersPoliciesGroupsBatchDeleteCall {
	c := &CustomersPoliciesGroupsBatchDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.googlechromepolicyversionsv1batchdeletegrouppoliciesrequest = googlechromepolicyversionsv1batchdeletegrouppoliciesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersPoliciesGroupsBatchDeleteCall) Fields(s ...googleapi.Field) *CustomersPoliciesGroupsBatchDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersPoliciesGroupsBatchDeleteCall) Context(ctx context.Context) *CustomersPoliciesGroupsBatchDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersPoliciesGroupsBatchDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersPoliciesGroupsBatchDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlechromepolicyversionsv1batchdeletegrouppoliciesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/policies/groups:batchDelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromepolicy.customers.policies.groups.batchDelete", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromepolicy.customers.policies.groups.batchDelete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CustomersPoliciesGroupsBatchDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromepolicy.customers.policies.groups.batchDelete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersPoliciesGroupsBatchModifyCall struct {
	s                                                           *Service
	customer                                                    string
	googlechromepolicyversionsv1batchmodifygrouppoliciesrequest *GoogleChromePolicyVersionsV1BatchModifyGroupPoliciesRequest
	urlParams_                                                  gensupport.URLParams
	ctx_                                                        context.Context
	header_                                                     http.Header
}

// BatchModify: Modify multiple policy values that are applied to a specific
// group. All targets must have the same target format. That is to say that
// they must point to the same target resource and must have the same keys
// specified in `additionalTargetKeyNames`, though the values for those keys
// may be different. On failure the request will return the error details as
// part of the google.rpc.Status.
//
//   - customer: ID of the Google Workspace account or literal "my_customer" for
//     the customer associated to the request.
func (r *CustomersPoliciesGroupsService) BatchModify(customer string, googlechromepolicyversionsv1batchmodifygrouppoliciesrequest *GoogleChromePolicyVersionsV1BatchModifyGroupPoliciesRequest) *CustomersPoliciesGroupsBatchModifyCall {
	c := &CustomersPoliciesGroupsBatchModifyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.googlechromepolicyversionsv1batchmodifygrouppoliciesrequest = googlechromepolicyversionsv1batchmodifygrouppoliciesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersPoliciesGroupsBatchModifyCall) Fields(s ...googleapi.Field) *CustomersPoliciesGroupsBatchModifyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersPoliciesGroupsBatchModifyCall) Context(ctx context.Context) *CustomersPoliciesGroupsBatchModifyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersPoliciesGroupsBatchModifyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersPoliciesGroupsBatchModifyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlechromepolicyversionsv1batchmodifygrouppoliciesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/policies/groups:batchModify")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromepolicy.customers.policies.groups.batchModify", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromepolicy.customers.policies.groups.batchModify" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CustomersPoliciesGroupsBatchModifyCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromepolicy.customers.policies.groups.batchModify", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersPoliciesGroupsListGroupPriorityOrderingCall struct {
	s                                                            *Service
	customer                                                     string
	googlechromepolicyversionsv1listgrouppriorityorderingrequest *GoogleChromePolicyVersionsV1ListGroupPriorityOrderingRequest
	urlParams_                                                   gensupport.URLParams
	ctx_                                                         context.Context
	header_                                                      http.Header
}

// ListGroupPriorityOrdering: Retrieve a group priority ordering for an app.
// The target app must be supplied in `additionalTargetKeyNames` in the
// PolicyTargetKey. On failure the request will return the error details as
// part of the google.rpc.Status.
//
//   - customer: ID of the Google Workspace account or literal "my_customer" for
//     the customer associated to the request.
func (r *CustomersPoliciesGroupsService) ListGroupPriorityOrdering(customer string, googlechromepolicyversionsv1listgrouppriorityorderingrequest *GoogleChromePolicyVersionsV1ListGroupPriorityOrderingRequest) *CustomersPoliciesGroupsListGroupPriorityOrderingCall {
	c := &CustomersPoliciesGroupsListGroupPriorityOrderingCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.googlechromepolicyversionsv1listgrouppriorityorderingrequest = googlechromepolicyversionsv1listgrouppriorityorderingrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersPoliciesGroupsListGroupPriorityOrderingCall) Fields(s ...googleapi.Field) *CustomersPoliciesGroupsListGroupPriorityOrderingCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersPoliciesGroupsListGroupPriorityOrderingCall) Context(ctx context.Context) *CustomersPoliciesGroupsListGroupPriorityOrderingCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersPoliciesGroupsListGroupPriorityOrderingCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersPoliciesGroupsListGroupPriorityOrderingCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlechromepolicyversionsv1listgrouppriorityorderingrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/policies/groups:listGroupPriorityOrdering")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromepolicy.customers.policies.groups.listGroupPriorityOrdering", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromepolicy.customers.policies.groups.listGroupPriorityOrdering" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromePolicyVersionsV1ListGroupPriorityOrderingResponse.ServerResponse
// .Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomersPoliciesGroupsListGroupPriorityOrderingCall) Do(opts ...googleapi.CallOption) (*GoogleChromePolicyVersionsV1ListGroupPriorityOrderingResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromePolicyVersionsV1ListGroupPriorityOrderingResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromepolicy.customers.policies.groups.listGroupPriorityOrdering", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersPoliciesGroupsUpdateGroupPriorityOrderingCall struct {
	s                                                              *Service
	customer                                                       string
	googlechromepolicyversionsv1updategrouppriorityorderingrequest *GoogleChromePolicyVersionsV1UpdateGroupPriorityOrderingRequest
	urlParams_                                                     gensupport.URLParams
	ctx_                                                           context.Context
	header_                                                        http.Header
}

// UpdateGroupPriorityOrdering: Update a group priority ordering for an app.
// The target app must be supplied in `additionalTargetKeyNames` in the
// PolicyTargetKey. On failure the request will return the error details as
// part of the google.rpc.Status.
//
//   - customer: ID of the Google Workspace account or literal "my_customer" for
//     the customer associated to the request.
func (r *CustomersPoliciesGroupsService) UpdateGroupPriorityOrdering(customer string, googlechromepolicyversionsv1updategrouppriorityorderingrequest *GoogleChromePolicyVersionsV1UpdateGroupPriorityOrderingRequest) *CustomersPoliciesGroupsUpdateGroupPriorityOrderingCall {
	c := &CustomersPoliciesGroupsUpdateGroupPriorityOrderingCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.googlechromepolicyversionsv1updategrouppriorityorderingrequest = googlechromepolicyversionsv1updategrouppriorityorderingrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersPoliciesGroupsUpdateGroupPriorityOrderingCall) Fields(s ...googleapi.Field) *CustomersPoliciesGroupsUpdateGroupPriorityOrderingCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersPoliciesGroupsUpdateGroupPriorityOrderingCall) Context(ctx context.Context) *CustomersPoliciesGroupsUpdateGroupPriorityOrderingCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersPoliciesGroupsUpdateGroupPriorityOrderingCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersPoliciesGroupsUpdateGroupPriorityOrderingCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlechromepolicyversionsv1updategrouppriorityorderingrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/policies/groups:updateGroupPriorityOrdering")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromepolicy.customers.policies.groups.updateGroupPriorityOrdering", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromepolicy.customers.policies.groups.updateGroupPriorityOrdering" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CustomersPoliciesGroupsUpdateGroupPriorityOrderingCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromepolicy.customers.policies.groups.updateGroupPriorityOrdering", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersPoliciesNetworksDefineCertificateCall struct {
	s                                                    *Service
	customer                                             string
	googlechromepolicyversionsv1definecertificaterequest *GoogleChromePolicyVersionsV1DefineCertificateRequest
	urlParams_                                           gensupport.URLParams
	ctx_                                                 context.Context
	header_                                              http.Header
}

// DefineCertificate: Creates a certificate at a specified OU for a customer.
//
// - customer: The customer for which the certificate will apply.
func (r *CustomersPoliciesNetworksService) DefineCertificate(customer string, googlechromepolicyversionsv1definecertificaterequest *GoogleChromePolicyVersionsV1DefineCertificateRequest) *CustomersPoliciesNetworksDefineCertificateCall {
	c := &CustomersPoliciesNetworksDefineCertificateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.googlechromepolicyversionsv1definecertificaterequest = googlechromepolicyversionsv1definecertificaterequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersPoliciesNetworksDefineCertificateCall) Fields(s ...googleapi.Field) *CustomersPoliciesNetworksDefineCertificateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersPoliciesNetworksDefineCertificateCall) Context(ctx context.Context) *CustomersPoliciesNetworksDefineCertificateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersPoliciesNetworksDefineCertificateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersPoliciesNetworksDefineCertificateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlechromepolicyversionsv1definecertificaterequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/policies/networks:defineCertificate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromepolicy.customers.policies.networks.defineCertificate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromepolicy.customers.policies.networks.defineCertificate" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromePolicyVersionsV1DefineCertificateResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersPoliciesNetworksDefineCertificateCall) Do(opts ...googleapi.CallOption) (*GoogleChromePolicyVersionsV1DefineCertificateResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromePolicyVersionsV1DefineCertificateResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromepolicy.customers.policies.networks.defineCertificate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersPoliciesNetworksDefineNetworkCall struct {
	s                                                *Service
	customer                                         string
	googlechromepolicyversionsv1definenetworkrequest *GoogleChromePolicyVersionsV1DefineNetworkRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// DefineNetwork: Define a new network.
//
// - customer: The customer who will own this new network.
func (r *CustomersPoliciesNetworksService) DefineNetwork(customer string, googlechromepolicyversionsv1definenetworkrequest *GoogleChromePolicyVersionsV1DefineNetworkRequest) *CustomersPoliciesNetworksDefineNetworkCall {
	c := &CustomersPoliciesNetworksDefineNetworkCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.googlechromepolicyversionsv1definenetworkrequest = googlechromepolicyversionsv1definenetworkrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersPoliciesNetworksDefineNetworkCall) Fields(s ...googleapi.Field) *CustomersPoliciesNetworksDefineNetworkCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersPoliciesNetworksDefineNetworkCall) Context(ctx context.Context) *CustomersPoliciesNetworksDefineNetworkCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersPoliciesNetworksDefineNetworkCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersPoliciesNetworksDefineNetworkCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlechromepolicyversionsv1definenetworkrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/policies/networks:defineNetwork")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromepolicy.customers.policies.networks.defineNetwork", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromepolicy.customers.policies.networks.defineNetwork" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromePolicyVersionsV1DefineNetworkResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersPoliciesNetworksDefineNetworkCall) Do(opts ...googleapi.CallOption) (*GoogleChromePolicyVersionsV1DefineNetworkResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromePolicyVersionsV1DefineNetworkResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromepolicy.customers.policies.networks.defineNetwork", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersPoliciesNetworksRemoveCertificateCall struct {
	s                                                    *Service
	customer                                             string
	googlechromepolicyversionsv1removecertificaterequest *GoogleChromePolicyVersionsV1RemoveCertificateRequest
	urlParams_                                           gensupport.URLParams
	ctx_                                                 context.Context
	header_                                              http.Header
}

// RemoveCertificate: Remove an existing certificate by guid.
//
// - customer: The customer whose certificate will be removed.
func (r *CustomersPoliciesNetworksService) RemoveCertificate(customer string, googlechromepolicyversionsv1removecertificaterequest *GoogleChromePolicyVersionsV1RemoveCertificateRequest) *CustomersPoliciesNetworksRemoveCertificateCall {
	c := &CustomersPoliciesNetworksRemoveCertificateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.googlechromepolicyversionsv1removecertificaterequest = googlechromepolicyversionsv1removecertificaterequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersPoliciesNetworksRemoveCertificateCall) Fields(s ...googleapi.Field) *CustomersPoliciesNetworksRemoveCertificateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersPoliciesNetworksRemoveCertificateCall) Context(ctx context.Context) *CustomersPoliciesNetworksRemoveCertificateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersPoliciesNetworksRemoveCertificateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersPoliciesNetworksRemoveCertificateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlechromepolicyversionsv1removecertificaterequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/policies/networks:removeCertificate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromepolicy.customers.policies.networks.removeCertificate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromepolicy.customers.policies.networks.removeCertificate" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromePolicyVersionsV1RemoveCertificateResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersPoliciesNetworksRemoveCertificateCall) Do(opts ...googleapi.CallOption) (*GoogleChromePolicyVersionsV1RemoveCertificateResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromePolicyVersionsV1RemoveCertificateResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromepolicy.customers.policies.networks.removeCertificate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersPoliciesNetworksRemoveNetworkCall struct {
	s                                                *Service
	customer                                         string
	googlechromepolicyversionsv1removenetworkrequest *GoogleChromePolicyVersionsV1RemoveNetworkRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// RemoveNetwork: Remove an existing network by guid.
//
// - customer: The customer whose network will be removed.
func (r *CustomersPoliciesNetworksService) RemoveNetwork(customer string, googlechromepolicyversionsv1removenetworkrequest *GoogleChromePolicyVersionsV1RemoveNetworkRequest) *CustomersPoliciesNetworksRemoveNetworkCall {
	c := &CustomersPoliciesNetworksRemoveNetworkCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.googlechromepolicyversionsv1removenetworkrequest = googlechromepolicyversionsv1removenetworkrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersPoliciesNetworksRemoveNetworkCall) Fields(s ...googleapi.Field) *CustomersPoliciesNetworksRemoveNetworkCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersPoliciesNetworksRemoveNetworkCall) Context(ctx context.Context) *CustomersPoliciesNetworksRemoveNetworkCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersPoliciesNetworksRemoveNetworkCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersPoliciesNetworksRemoveNetworkCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlechromepolicyversionsv1removenetworkrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/policies/networks:removeNetwork")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromepolicy.customers.policies.networks.removeNetwork", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromepolicy.customers.policies.networks.removeNetwork" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromePolicyVersionsV1RemoveNetworkResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersPoliciesNetworksRemoveNetworkCall) Do(opts ...googleapi.CallOption) (*GoogleChromePolicyVersionsV1RemoveNetworkResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromePolicyVersionsV1RemoveNetworkResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromepolicy.customers.policies.networks.removeNetwork", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersPoliciesOrgunitsBatchInheritCall struct {
	s                                                              *Service
	customer                                                       string
	googlechromepolicyversionsv1batchinheritorgunitpoliciesrequest *GoogleChromePolicyVersionsV1BatchInheritOrgUnitPoliciesRequest
	urlParams_                                                     gensupport.URLParams
	ctx_                                                           context.Context
	header_                                                        http.Header
}

// BatchInherit: Modify multiple policy values that are applied to a specific
// org unit so that they now inherit the value from a parent (if applicable).
// All targets must have the same target format. That is to say that they must
// point to the same target resource and must have the same keys specified in
// `additionalTargetKeyNames`, though the values for those keys may be
// different. On failure the request will return the error details as part of
// the google.rpc.Status.
//
//   - customer: ID of the G Suite account or literal "my_customer" for the
//     customer associated to the request.
func (r *CustomersPoliciesOrgunitsService) BatchInherit(customer string, googlechromepolicyversionsv1batchinheritorgunitpoliciesrequest *GoogleChromePolicyVersionsV1BatchInheritOrgUnitPoliciesRequest) *CustomersPoliciesOrgunitsBatchInheritCall {
	c := &CustomersPoliciesOrgunitsBatchInheritCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.googlechromepolicyversionsv1batchinheritorgunitpoliciesrequest = googlechromepolicyversionsv1batchinheritorgunitpoliciesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersPoliciesOrgunitsBatchInheritCall) Fields(s ...googleapi.Field) *CustomersPoliciesOrgunitsBatchInheritCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersPoliciesOrgunitsBatchInheritCall) Context(ctx context.Context) *CustomersPoliciesOrgunitsBatchInheritCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersPoliciesOrgunitsBatchInheritCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersPoliciesOrgunitsBatchInheritCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlechromepolicyversionsv1batchinheritorgunitpoliciesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/policies/orgunits:batchInherit")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromepolicy.customers.policies.orgunits.batchInherit", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromepolicy.customers.policies.orgunits.batchInherit" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CustomersPoliciesOrgunitsBatchInheritCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromepolicy.customers.policies.orgunits.batchInherit", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersPoliciesOrgunitsBatchModifyCall struct {
	s                                                             *Service
	customer                                                      string
	googlechromepolicyversionsv1batchmodifyorgunitpoliciesrequest *GoogleChromePolicyVersionsV1BatchModifyOrgUnitPoliciesRequest
	urlParams_                                                    gensupport.URLParams
	ctx_                                                          context.Context
	header_                                                       http.Header
}

// BatchModify: Modify multiple policy values that are applied to a specific
// org unit. All targets must have the same target format. That is to say that
// they must point to the same target resource and must have the same keys
// specified in `additionalTargetKeyNames`, though the values for those keys
// may be different. On failure the request will return the error details as
// part of the google.rpc.Status.
//
//   - customer: ID of the G Suite account or literal "my_customer" for the
//     customer associated to the request.
func (r *CustomersPoliciesOrgunitsService) BatchModify(customer string, googlechromepolicyversionsv1batchmodifyorgunitpoliciesrequest *GoogleChromePolicyVersionsV1BatchModifyOrgUnitPoliciesRequest) *CustomersPoliciesOrgunitsBatchModifyCall {
	c := &CustomersPoliciesOrgunitsBatchModifyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.googlechromepolicyversionsv1batchmodifyorgunitpoliciesrequest = googlechromepolicyversionsv1batchmodifyorgunitpoliciesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersPoliciesOrgunitsBatchModifyCall) Fields(s ...googleapi.Field) *CustomersPoliciesOrgunitsBatchModifyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersPoliciesOrgunitsBatchModifyCall) Context(ctx context.Context) *CustomersPoliciesOrgunitsBatchModifyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersPoliciesOrgunitsBatchModifyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersPoliciesOrgunitsBatchModifyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlechromepolicyversionsv1batchmodifyorgunitpoliciesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/policies/orgunits:batchModify")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromepolicy.customers.policies.orgunits.batchModify", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromepolicy.customers.policies.orgunits.batchModify" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CustomersPoliciesOrgunitsBatchModifyCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromepolicy.customers.policies.orgunits.batchModify", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersPolicySchemasGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get a specific policy schema for a customer by its resource name.
//
// - name: The policy schema resource name to query.
func (r *CustomersPolicySchemasService) Get(name string) *CustomersPolicySchemasGetCall {
	c := &CustomersPolicySchemasGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersPolicySchemasGetCall) Fields(s ...googleapi.Field) *CustomersPolicySchemasGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersPolicySchemasGetCall) IfNoneMatch(entityTag string) *CustomersPolicySchemasGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersPolicySchemasGetCall) Context(ctx context.Context) *CustomersPolicySchemasGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersPolicySchemasGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersPolicySchemasGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromepolicy.customers.policySchemas.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromepolicy.customers.policySchemas.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromePolicyVersionsV1PolicySchema.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersPolicySchemasGetCall) Do(opts ...googleapi.CallOption) (*GoogleChromePolicyVersionsV1PolicySchema, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromePolicyVersionsV1PolicySchema{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromepolicy.customers.policySchemas.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersPolicySchemasListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Gets a list of policy schemas that match a specified filter value for
// a given customer.
//
// - parent: The customer for which the listing request will apply.
func (r *CustomersPolicySchemasService) List(parent string) *CustomersPolicySchemasListCall {
	c := &CustomersPolicySchemasListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": The schema filter used to find
// a particular schema based on fields like its resource name, description and
// `additionalTargetKeyNames`.
func (c *CustomersPolicySchemasListCall) Filter(filter string) *CustomersPolicySchemasListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// policy schemas to return, defaults to 100 and has a maximum of 1000.
func (c *CustomersPolicySchemasListCall) PageSize(pageSize int64) *CustomersPolicySchemasListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The page token used to
// retrieve a specific page of the listing request.
func (c *CustomersPolicySchemasListCall) PageToken(pageToken string) *CustomersPolicySchemasListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersPolicySchemasListCall) Fields(s ...googleapi.Field) *CustomersPolicySchemasListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersPolicySchemasListCall) IfNoneMatch(entityTag string) *CustomersPolicySchemasListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersPolicySchemasListCall) Context(ctx context.Context) *CustomersPolicySchemasListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersPolicySchemasListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersPolicySchemasListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/policySchemas")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromepolicy.customers.policySchemas.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromepolicy.customers.policySchemas.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromePolicyVersionsV1ListPolicySchemasResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersPolicySchemasListCall) Do(opts ...googleapi.CallOption) (*GoogleChromePolicyVersionsV1ListPolicySchemasResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromePolicyVersionsV1ListPolicySchemasResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromepolicy.customers.policySchemas.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersPolicySchemasListCall) Pages(ctx context.Context, f func(*GoogleChromePolicyVersionsV1ListPolicySchemasResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type MediaUploadCall struct {
	s                                                   *Service
	customer                                            string
	googlechromepolicyversionsv1uploadpolicyfilerequest *GoogleChromePolicyVersionsV1UploadPolicyFileRequest
	urlParams_                                          gensupport.URLParams
	mediaInfo_                                          *gensupport.MediaInfo
	ctx_                                                context.Context
	header_                                             http.Header
}

// Upload: Creates an enterprise file from the content provided by user.
// Returns a public download url for end user.
//
// - customer: The customer for which the file upload will apply.
func (r *MediaService) Upload(customer string, googlechromepolicyversionsv1uploadpolicyfilerequest *GoogleChromePolicyVersionsV1UploadPolicyFileRequest) *MediaUploadCall {
	c := &MediaUploadCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.googlechromepolicyversionsv1uploadpolicyfilerequest = googlechromepolicyversionsv1uploadpolicyfilerequest
	return c
}

// Media specifies the media to upload in one or more chunks. The chunk size
// may be controlled by supplying a MediaOption generated by
// googleapi.ChunkSize. The chunk size defaults to
// googleapi.DefaultUploadChunkSize.The Content-Type header used in the upload
// request will be determined by sniffing the contents of r, unless a
// MediaOption generated by googleapi.ContentType is supplied.
// At most one of Media and ResumableMedia may be set.
func (c *MediaUploadCall) Media(r io.Reader, options ...googleapi.MediaOption) *MediaUploadCall {
	c.mediaInfo_ = gensupport.NewInfoFromMedia(r, options)
	return c
}

// ResumableMedia specifies the media to upload in chunks and can be canceled
// with ctx.
//
// Deprecated: use Media instead.
//
// At most one of Media and ResumableMedia may be set. mediaType identifies the
// MIME media type of the upload, such as "image/png". If mediaType is "", it
// will be auto-detected. The provided ctx will supersede any context
// previously provided to the Context method.
func (c *MediaUploadCall) ResumableMedia(ctx context.Context, r io.ReaderAt, size int64, mediaType string) *MediaUploadCall {
	c.ctx_ = ctx
	c.mediaInfo_ = gensupport.NewInfoFromResumableMedia(r, size, mediaType)
	return c
}

// ProgressUpdater provides a callback function that will be called after every
// chunk. It should be a low-latency function in order to not slow down the
// upload operation. This should only be called when using ResumableMedia (as
// opposed to Media).
func (c *MediaUploadCall) ProgressUpdater(pu googleapi.ProgressUpdater) *MediaUploadCall {
	c.mediaInfo_.SetProgressUpdater(pu)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *MediaUploadCall) Fields(s ...googleapi.Field) *MediaUploadCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
// This context will supersede any context previously provided to the
// ResumableMedia method.
func (c *MediaUploadCall) Context(ctx context.Context) *MediaUploadCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *MediaUploadCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MediaUploadCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlechromepolicyversionsv1uploadpolicyfilerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/policies/files:uploadPolicyFile")
	if c.mediaInfo_ != nil {
		urls = googleapi.ResolveRelative(c.s.BasePath, "/upload/v1/{+customer}/policies/files:uploadPolicyFile")
		c.urlParams_.Set("uploadType", c.mediaInfo_.UploadType())
	}
	newBody, getBody, cleanup := c.mediaInfo_.UploadRequest(reqHeaders, body)
	defer cleanup()
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, newBody)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	req.GetBody = getBody
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromepolicy.media.upload", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromepolicy.media.upload" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromePolicyVersionsV1UploadPolicyFileResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *MediaUploadCall) Do(opts ...googleapi.CallOption) (*GoogleChromePolicyVersionsV1UploadPolicyFileResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	rx := c.mediaInfo_.ResumableUpload(res.Header.Get("Location"))
	if rx != nil {
		rx.Client = c.s.client
		rx.UserAgent = c.s.userAgent()
		ctx := c.ctx_
		if ctx == nil {
			ctx = context.TODO()
		}
		res, err = rx.Upload(ctx)
		if err != nil {
			return nil, err
		}
		defer res.Body.Close()
		if err := googleapi.CheckResponse(res); err != nil {
			return nil, gensupport.WrapError(err)
		}
	}
	ret := &GoogleChromePolicyVersionsV1UploadPolicyFileResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromepolicy.media.upload", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
