// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package healthcare provides access to the Cloud Healthcare API.
//
// For product documentation, see: https://cloud.google.com/healthcare
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/healthcare/v1beta1"
//	...
//	ctx := context.Background()
//	healthcareService, err := healthcare.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	healthcareService, err := healthcare.NewService(ctx, option.WithScopes(healthcare.CloudPlatformScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	healthcareService, err := healthcare.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	healthcareService, err := healthcare.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package healthcare // import "google.golang.org/api/healthcare/v1beta1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "healthcare:v1beta1"
const apiName = "healthcare"
const apiVersion = "v1beta1"
const basePath = "https://healthcare.googleapis.com/"
const basePathTemplate = "https://healthcare.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://healthcare.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// Read, write and manage healthcare data
	CloudHealthcareScope = "https://www.googleapis.com/auth/cloud-healthcare"

	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-healthcare",
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Datasets = NewProjectsLocationsDatasetsService(s)
	rs.Services = NewProjectsLocationsServicesService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Datasets *ProjectsLocationsDatasetsService

	Services *ProjectsLocationsServicesService
}

func NewProjectsLocationsDatasetsService(s *Service) *ProjectsLocationsDatasetsService {
	rs := &ProjectsLocationsDatasetsService{s: s}
	rs.AnnotationStores = NewProjectsLocationsDatasetsAnnotationStoresService(s)
	rs.ConsentStores = NewProjectsLocationsDatasetsConsentStoresService(s)
	rs.DataMapperWorkspaces = NewProjectsLocationsDatasetsDataMapperWorkspacesService(s)
	rs.DicomStores = NewProjectsLocationsDatasetsDicomStoresService(s)
	rs.FhirStores = NewProjectsLocationsDatasetsFhirStoresService(s)
	rs.Hl7V2Stores = NewProjectsLocationsDatasetsHl7V2StoresService(s)
	rs.Operations = NewProjectsLocationsDatasetsOperationsService(s)
	return rs
}

type ProjectsLocationsDatasetsService struct {
	s *Service

	AnnotationStores *ProjectsLocationsDatasetsAnnotationStoresService

	ConsentStores *ProjectsLocationsDatasetsConsentStoresService

	DataMapperWorkspaces *ProjectsLocationsDatasetsDataMapperWorkspacesService

	DicomStores *ProjectsLocationsDatasetsDicomStoresService

	FhirStores *ProjectsLocationsDatasetsFhirStoresService

	Hl7V2Stores *ProjectsLocationsDatasetsHl7V2StoresService

	Operations *ProjectsLocationsDatasetsOperationsService
}

func NewProjectsLocationsDatasetsAnnotationStoresService(s *Service) *ProjectsLocationsDatasetsAnnotationStoresService {
	rs := &ProjectsLocationsDatasetsAnnotationStoresService{s: s}
	rs.Annotations = NewProjectsLocationsDatasetsAnnotationStoresAnnotationsService(s)
	return rs
}

type ProjectsLocationsDatasetsAnnotationStoresService struct {
	s *Service

	Annotations *ProjectsLocationsDatasetsAnnotationStoresAnnotationsService
}

func NewProjectsLocationsDatasetsAnnotationStoresAnnotationsService(s *Service) *ProjectsLocationsDatasetsAnnotationStoresAnnotationsService {
	rs := &ProjectsLocationsDatasetsAnnotationStoresAnnotationsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsAnnotationStoresAnnotationsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsConsentStoresService(s *Service) *ProjectsLocationsDatasetsConsentStoresService {
	rs := &ProjectsLocationsDatasetsConsentStoresService{s: s}
	rs.AttributeDefinitions = NewProjectsLocationsDatasetsConsentStoresAttributeDefinitionsService(s)
	rs.ConsentArtifacts = NewProjectsLocationsDatasetsConsentStoresConsentArtifactsService(s)
	rs.Consents = NewProjectsLocationsDatasetsConsentStoresConsentsService(s)
	rs.UserDataMappings = NewProjectsLocationsDatasetsConsentStoresUserDataMappingsService(s)
	return rs
}

type ProjectsLocationsDatasetsConsentStoresService struct {
	s *Service

	AttributeDefinitions *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsService

	ConsentArtifacts *ProjectsLocationsDatasetsConsentStoresConsentArtifactsService

	Consents *ProjectsLocationsDatasetsConsentStoresConsentsService

	UserDataMappings *ProjectsLocationsDatasetsConsentStoresUserDataMappingsService
}

func NewProjectsLocationsDatasetsConsentStoresAttributeDefinitionsService(s *Service) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsService {
	rs := &ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsConsentStoresConsentArtifactsService(s *Service) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsService {
	rs := &ProjectsLocationsDatasetsConsentStoresConsentArtifactsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsConsentStoresConsentArtifactsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsConsentStoresConsentsService(s *Service) *ProjectsLocationsDatasetsConsentStoresConsentsService {
	rs := &ProjectsLocationsDatasetsConsentStoresConsentsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsConsentStoresConsentsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsConsentStoresUserDataMappingsService(s *Service) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsService {
	rs := &ProjectsLocationsDatasetsConsentStoresUserDataMappingsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsConsentStoresUserDataMappingsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsDataMapperWorkspacesService(s *Service) *ProjectsLocationsDatasetsDataMapperWorkspacesService {
	rs := &ProjectsLocationsDatasetsDataMapperWorkspacesService{s: s}
	return rs
}

type ProjectsLocationsDatasetsDataMapperWorkspacesService struct {
	s *Service
}

func NewProjectsLocationsDatasetsDicomStoresService(s *Service) *ProjectsLocationsDatasetsDicomStoresService {
	rs := &ProjectsLocationsDatasetsDicomStoresService{s: s}
	rs.DicomWeb = NewProjectsLocationsDatasetsDicomStoresDicomWebService(s)
	rs.Studies = NewProjectsLocationsDatasetsDicomStoresStudiesService(s)
	return rs
}

type ProjectsLocationsDatasetsDicomStoresService struct {
	s *Service

	DicomWeb *ProjectsLocationsDatasetsDicomStoresDicomWebService

	Studies *ProjectsLocationsDatasetsDicomStoresStudiesService
}

func NewProjectsLocationsDatasetsDicomStoresDicomWebService(s *Service) *ProjectsLocationsDatasetsDicomStoresDicomWebService {
	rs := &ProjectsLocationsDatasetsDicomStoresDicomWebService{s: s}
	rs.Studies = NewProjectsLocationsDatasetsDicomStoresDicomWebStudiesService(s)
	return rs
}

type ProjectsLocationsDatasetsDicomStoresDicomWebService struct {
	s *Service

	Studies *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesService
}

func NewProjectsLocationsDatasetsDicomStoresDicomWebStudiesService(s *Service) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesService {
	rs := &ProjectsLocationsDatasetsDicomStoresDicomWebStudiesService{s: s}
	rs.Series = NewProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesService(s)
	return rs
}

type ProjectsLocationsDatasetsDicomStoresDicomWebStudiesService struct {
	s *Service

	Series *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesService
}

func NewProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesService(s *Service) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesService {
	rs := &ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesService{s: s}
	rs.Instances = NewProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesService(s)
	return rs
}

type ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesService struct {
	s *Service

	Instances *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesService
}

func NewProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesService(s *Service) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesService {
	rs := &ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesService{s: s}
	return rs
}

type ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesService struct {
	s *Service
}

func NewProjectsLocationsDatasetsDicomStoresStudiesService(s *Service) *ProjectsLocationsDatasetsDicomStoresStudiesService {
	rs := &ProjectsLocationsDatasetsDicomStoresStudiesService{s: s}
	rs.Series = NewProjectsLocationsDatasetsDicomStoresStudiesSeriesService(s)
	return rs
}

type ProjectsLocationsDatasetsDicomStoresStudiesService struct {
	s *Service

	Series *ProjectsLocationsDatasetsDicomStoresStudiesSeriesService
}

func NewProjectsLocationsDatasetsDicomStoresStudiesSeriesService(s *Service) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesService {
	rs := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesService{s: s}
	rs.Instances = NewProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesService(s)
	return rs
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesService struct {
	s *Service

	Instances *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesService
}

func NewProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesService(s *Service) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesService {
	rs := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesService{s: s}
	rs.Bulkdata = NewProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataService(s)
	rs.Frames = NewProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesService(s)
	return rs
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesService struct {
	s *Service

	Bulkdata *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataService

	Frames *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesService
}

func NewProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataService(s *Service) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataService {
	rs := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataService{s: s}
	return rs
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataService struct {
	s *Service
}

func NewProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesService(s *Service) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesService {
	rs := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesService{s: s}
	return rs
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesService struct {
	s *Service
}

func NewProjectsLocationsDatasetsFhirStoresService(s *Service) *ProjectsLocationsDatasetsFhirStoresService {
	rs := &ProjectsLocationsDatasetsFhirStoresService{s: s}
	rs.Fhir = NewProjectsLocationsDatasetsFhirStoresFhirService(s)
	return rs
}

type ProjectsLocationsDatasetsFhirStoresService struct {
	s *Service

	Fhir *ProjectsLocationsDatasetsFhirStoresFhirService
}

func NewProjectsLocationsDatasetsFhirStoresFhirService(s *Service) *ProjectsLocationsDatasetsFhirStoresFhirService {
	rs := &ProjectsLocationsDatasetsFhirStoresFhirService{s: s}
	return rs
}

type ProjectsLocationsDatasetsFhirStoresFhirService struct {
	s *Service
}

func NewProjectsLocationsDatasetsHl7V2StoresService(s *Service) *ProjectsLocationsDatasetsHl7V2StoresService {
	rs := &ProjectsLocationsDatasetsHl7V2StoresService{s: s}
	rs.Messages = NewProjectsLocationsDatasetsHl7V2StoresMessagesService(s)
	return rs
}

type ProjectsLocationsDatasetsHl7V2StoresService struct {
	s *Service

	Messages *ProjectsLocationsDatasetsHl7V2StoresMessagesService
}

func NewProjectsLocationsDatasetsHl7V2StoresMessagesService(s *Service) *ProjectsLocationsDatasetsHl7V2StoresMessagesService {
	rs := &ProjectsLocationsDatasetsHl7V2StoresMessagesService{s: s}
	return rs
}

type ProjectsLocationsDatasetsHl7V2StoresMessagesService struct {
	s *Service
}

func NewProjectsLocationsDatasetsOperationsService(s *Service) *ProjectsLocationsDatasetsOperationsService {
	rs := &ProjectsLocationsDatasetsOperationsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsOperationsService struct {
	s *Service
}

func NewProjectsLocationsServicesService(s *Service) *ProjectsLocationsServicesService {
	rs := &ProjectsLocationsServicesService{s: s}
	rs.Nlp = NewProjectsLocationsServicesNlpService(s)
	return rs
}

type ProjectsLocationsServicesService struct {
	s *Service

	Nlp *ProjectsLocationsServicesNlpService
}

func NewProjectsLocationsServicesNlpService(s *Service) *ProjectsLocationsServicesNlpService {
	rs := &ProjectsLocationsServicesNlpService{s: s}
	return rs
}

type ProjectsLocationsServicesNlpService struct {
	s *Service
}

// AccessDeterminationLogConfig: Configures consent audit log config for FHIR
// create, read, update, and delete (CRUD) operations. Cloud audit log for
// healthcare API must be enabled
// (https://cloud.google.com/logging/docs/audit/configure-data-access#config-console-enable).
// The consent-related logs are included as part of `protoPayload.metadata`.
type AccessDeterminationLogConfig struct {
	// LogLevel: Optional. Controls the amount of detail to include as part of the
	// audit logs.
	//
	// Possible values:
	//   "LOG_LEVEL_UNSPECIFIED" - No log level specified. This value is unused.
	//   "DISABLED" - No additional consent-related logging is added to audit logs.
	//   "MINIMUM" - The following information is included: * One of the following
	// [`consentMode`](https://cloud.google.com/healthcare-api/docs/fhir-consent#aud
	// it_logs) fields: (`off`|`emptyScope`|`enforced`|`btg`|`bypass`). * The
	// accessor's request headers * The `log_level` of the
	// AccessDeterminationLogConfig * The final consent evaluation (`PERMIT`,
	// `DENY`, or `NO_CONSENT`) * A human-readable summary of the evaluation
	//   "VERBOSE" - Includes `MINIMUM` and, for each resource owner, returns: *
	// The resource owner's name * Most specific part of the `X-Consent-Scope`
	// resulting in consensual determination * Timestamp of the applied enforcement
	// leading to the decision * Enforcement version at the time the applicable
	// consents were applied * The Consent resource name * The timestamp of the
	// Consent resource used for enforcement * Policy type (`PATIENT` or `ADMIN`)
	// Note that this mode adds some overhead to CRUD operations.
	LogLevel string `json:"logLevel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LogLevel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LogLevel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccessDeterminationLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AccessDeterminationLogConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Action: Specifies a selection of tags and an `Action` to apply to each one.
type Action struct {
	// CleanImageTag: Inspect image and transform sensitive burnt-in text. Doesn't
	// apply to elements nested in a sequence, which revert to `Keep`. Supported
	// tags
	// (http://dicom.nema.org/medical/dicom/2018e/output/chtml/part06/chapter_6.html):
	// PixelData
	CleanImageTag *ImageConfig `json:"cleanImageTag,omitempty"`
	// CleanTextTag: Inspect text and transform sensitive text. Configurable via
	// TextConfig. Supported Value Representations: AE, LO, LT, PN, SH, ST, UC, UT,
	// DA, DT, AS
	CleanTextTag *CleanTextTag `json:"cleanTextTag,omitempty"`
	// DeleteTag: Delete tag.
	DeleteTag *DeleteTag `json:"deleteTag,omitempty"`
	// KeepTag: Keep tag unchanged.
	KeepTag *KeepTag `json:"keepTag,omitempty"`
	// Queries: Select all tags with the listed tag IDs, names, or Value
	// Representations (VRs). Examples: ID: "00100010" Keyword: "PatientName" VR:
	// "PN"
	Queries []string `json:"queries,omitempty"`
	// RecurseTag: Recursively apply DICOM de-id to tags nested in a sequence.
	// Supported [Value Representation]
	// (http://dicom.nema.org/medical/dicom/2018e/output/chtml/part05/sect_6.2.html#table_6.2-1):
	// SQ
	RecurseTag *RecurseTag `json:"recurseTag,omitempty"`
	// RegenUidTag: Replace UID with a new generated UID. Supported [Value
	// Representation]
	// (http://dicom.nema.org/medical/dicom/2018e/output/chtml/part05/sect_6.2.html#table_6.2-1):
	// UI
	RegenUidTag *RegenUidTag `json:"regenUidTag,omitempty"`
	// RemoveTag: Replace with empty tag.
	RemoveTag *RemoveTag `json:"removeTag,omitempty"`
	// ResetTag: Reset tag to a placeholder value.
	ResetTag *ResetTag `json:"resetTag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CleanImageTag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CleanImageTag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Action) MarshalJSON() ([]byte, error) {
	type NoMethod Action
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ActivateConsentRequest: Activates the latest revision of the specified
// Consent by committing a new revision with `state` updated to `ACTIVE`. If
// the latest revision of the given Consent is in the `ACTIVE` state, no new
// revision is committed. A FAILED_PRECONDITION error occurs if the latest
// revision of the given consent is in the `REJECTED` or `REVOKED` state.
type ActivateConsentRequest struct {
	// ConsentArtifact: Required. The resource name of the Consent artifact that
	// contains documentation of the user's consent, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentS
	// tores/{consent_store_id}/consentArtifacts/{consent_artifact_id}`. If the
	// draft Consent had a Consent artifact, this Consent artifact overwrites it.
	ConsentArtifact string `json:"consentArtifact,omitempty"`
	// ExpireTime: Timestamp in UTC of when this Consent is considered expired.
	ExpireTime string `json:"expireTime,omitempty"`
	// Ttl: The time to live for this Consent from when it is marked as active.
	Ttl string `json:"ttl,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConsentArtifact") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsentArtifact") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ActivateConsentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ActivateConsentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AdminConsents: List of admin Consent resources to be applied.
type AdminConsents struct {
	// Names: The versioned names of the admin Consent resource(s), in the format
	// `projects/{project_id}/locations/{location}/datasets/{dataset_id}/fhirStores/
	// {fhir_store_id}/fhir/Consent/{resource_id}/_history/{version_id}`. For FHIR
	// stores with `disable_resource_versioning=true`, the format is
	// `projects/{project_id}/locations/{location}/datasets/{dataset_id}/fhirStores/
	// {fhir_store_id}/fhir/Consent/{resource_id}`.
	Names []string `json:"names,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Names") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Names") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AdminConsents) MarshalJSON() ([]byte, error) {
	type NoMethod AdminConsents
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AnalyzeEntitiesRequest: The request to analyze healthcare entities in a
// document.
type AnalyzeEntitiesRequest struct {
	// AlternativeOutputFormat: Optional. Alternative output format to be generated
	// based on the results of analysis.
	//
	// Possible values:
	//   "ALTERNATIVE_OUTPUT_FORMAT_UNSPECIFIED" - No alternative output format is
	// specified.
	//   "FHIR_BUNDLE" - FHIR bundle output.
	AlternativeOutputFormat string `json:"alternativeOutputFormat,omitempty"`
	// DocumentContent: document_content is a document to be annotated.
	DocumentContent string `json:"documentContent,omitempty"`
	// LicensedVocabularies: A list of licensed vocabularies to use in the request,
	// in addition to the default unlicensed vocabularies.
	//
	// Possible values:
	//   "LICENSED_VOCABULARY_UNSPECIFIED" - No licensed vocabulary specified.
	//   "ICD10CM" - ICD-10-CM vocabulary
	//   "SNOMEDCT_US" - SNOMED CT (US version) vocabulary
	LicensedVocabularies []string `json:"licensedVocabularies,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AlternativeOutputFormat") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlternativeOutputFormat") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AnalyzeEntitiesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AnalyzeEntitiesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AnalyzeEntitiesResponse: Includes recognized entity mentions and
// relationships between them.
type AnalyzeEntitiesResponse struct {
	// Entities: The union of all the candidate entities that the entity_mentions
	// in this response could link to. These are UMLS concepts or normalized
	// mention content.
	Entities []*Entity `json:"entities,omitempty"`
	// EntityMentions: The `entity_mentions` field contains all the annotated
	// medical entities that were mentioned in the provided document.
	EntityMentions []*EntityMention `json:"entityMentions,omitempty"`
	// FhirBundle: The FHIR bundle (`R4` (http://hl7.org/fhir/R4/bundle.html)) that
	// includes all the entities, the entity mentions, and the relationships in
	// JSON format.
	FhirBundle string `json:"fhirBundle,omitempty"`
	// Relationships: relationships contains all the binary relationships that were
	// identified between entity mentions within the provided document.
	Relationships []*EntityMentionRelationship `json:"relationships,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Entities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entities") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AnalyzeEntitiesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AnalyzeEntitiesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Annotation: An annotation record.
type Annotation struct {
	// AnnotationSource: Required. Details of the source.
	AnnotationSource *AnnotationSource `json:"annotationSource,omitempty"`
	// CustomData: Additional information for this annotation record, such as
	// annotator and verifier information or study campaign.
	CustomData map[string]string `json:"customData,omitempty"`
	// ImageAnnotation: Annotations for images. For example, bounding polygons.
	ImageAnnotation *ImageAnnotation `json:"imageAnnotation,omitempty"`
	// Name: Identifier. Resource name of the Annotation, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/annotati
	// onStores/{annotation_store_id}/annotations/{annotation_id}`.
	Name string `json:"name,omitempty"`
	// ResourceAnnotation: Annotations for resource. For example, classification
	// tags.
	ResourceAnnotation *ResourceAnnotation `json:"resourceAnnotation,omitempty"`
	// TextAnnotation: Annotations for sensitive texts. For example, a range that
	// describes the location of sensitive text.
	TextAnnotation *SensitiveTextAnnotation `json:"textAnnotation,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Annotation) MarshalJSON() ([]byte, error) {
	type NoMethod Annotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AnnotationConfig: Specifies how to store annotations during
// de-identification operation.
type AnnotationConfig struct {
	// AnnotationStoreName: The name of the annotation store, in the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/annotati
	// onStores/{annotation_store_id}`). * The destination annotation store must be
	// in the same project as the source data. De-identifying data across multiple
	// projects is not supported. * The destination annotation store must exist
	// when using DeidentifyDicomStore or DeidentifyFhirStore. DeidentifyDataset
	// automatically creates the destination annotation store.
	AnnotationStoreName string `json:"annotationStoreName,omitempty"`
	// StoreQuote: If set to true, the sensitive texts are included in
	// SensitiveTextAnnotation of Annotation.
	StoreQuote bool `json:"storeQuote,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationStoreName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationStoreName") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AnnotationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AnnotationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AnnotationSource: AnnotationSource holds the source information of the
// annotation.
type AnnotationSource struct {
	// CloudHealthcareSource: Cloud Healthcare API resource.
	CloudHealthcareSource *CloudHealthcareSource `json:"cloudHealthcareSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CloudHealthcareSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudHealthcareSource") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AnnotationSource) MarshalJSON() ([]byte, error) {
	type NoMethod AnnotationSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AnnotationStore: An Annotation store that can store annotation resources
// such as labels and tags for text, image and audio.
type AnnotationStore struct {
	// Labels: Optional. User-supplied key-value pairs used to organize Annotation
	// stores. Label keys must be between 1 and 63 characters long, have a UTF-8
	// encoding of maximum 128 bytes, and must conform to the following PCRE
	// regular expression: \p{Ll}\p{Lo}{0,62} Label values must be between 1 and 63
	// characters long, have a UTF-8 encoding of maximum 128 bytes, and must
	// conform to the following PCRE regular expression:
	// [\p{Ll}\p{Lo}\p{N}_-]{0,63} No more than 64 labels can be associated with a
	// given store.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. Resource name of the Annotation store, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/annotati
	// onStores/{annotation_store_id}`.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Labels") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Labels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AnnotationStore) MarshalJSON() ([]byte, error) {
	type NoMethod AnnotationStore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApplyAdminConsentsErrorDetail: Contains the error details of the unsupported
// admin Consent resources for when the ApplyAdminConsents method fails to
// apply one or more Consent resources.
type ApplyAdminConsentsErrorDetail struct {
	// ConsentErrors: The list of Consent resources that are unsupported or cannot
	// be applied and the error associated with each of them.
	ConsentErrors []*ConsentErrors `json:"consentErrors,omitempty"`
	// ExistingOperationId: The currently in progress non-validate-only
	// ApplyAdminConsents operation ID if exist.
	ExistingOperationId uint64 `json:"existingOperationId,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ConsentErrors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsentErrors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApplyAdminConsentsErrorDetail) MarshalJSON() ([]byte, error) {
	type NoMethod ApplyAdminConsentsErrorDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApplyAdminConsentsRequest: Request to apply the admin Consent resources for
// the specified FHIR store.
type ApplyAdminConsentsRequest struct {
	// NewConsentsList: A new list of admin Consent resources to be applied. Any
	// existing enforced Consents, which are specified in
	// `consent_config.enforced_admin_consents` of the FhirStore, that are not part
	// of this list will be disabled. An empty list is equivalent to clearing or
	// disabling all Consents enforced on the FHIR store. When a FHIR store has
	// `disable_resource_versioning=true` and this list contains a Consent resource
	// that exists in `consent_config.enforced_admin_consents`, the method enforces
	// any updates to the existing resource since the last enforcement. If the
	// existing resource hasn't been updated since the last enforcement, the
	// resource is unaffected. After the method finishes, the resulting consent
	// enforcement model is determined by the contents of the Consent resource(s)
	// when the method was called: * When `disable_resource_versioning=true`, the
	// result is identical to the current resource(s) in the FHIR store. * When
	// `disable_resource_versioning=false`, the result is based on the historical
	// version(s) of the Consent resource(s) at the point in time when the method
	// was called. At most 200 Consents can be specified.
	NewConsentsList *AdminConsents `json:"newConsentsList,omitempty"`
	// ValidateOnly: If true, the method only validates Consent resources to make
	// sure they are supported. Otherwise, the method applies the aggregate consent
	// information to update the enforcement model and reindex the FHIR resources.
	// If all Consent resources can be applied successfully, the
	// ApplyAdminConsentsResponse is returned containing the following fields: *
	// `consent_apply_success` to indicate the number of Consent resources applied.
	// * `affected_resources` to indicate the number of resources that might have
	// had their consent access changed. If, however, one or more Consent resources
	// are unsupported or cannot be applied, the method fails and
	// ApplyAdminConsentsErrorDetail is is returned with details about the
	// unsupported Consent resources.
	ValidateOnly bool `json:"validateOnly,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NewConsentsList") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NewConsentsList") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApplyAdminConsentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ApplyAdminConsentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApplyAdminConsentsResponse: Response when all admin Consent resources in
// scope were processed and all affected resources were reindexed successfully.
// This structure will be included in the response when the operation finishes
// successfully.
type ApplyAdminConsentsResponse struct {
	// AffectedResources: The number of resources (including the Consent resources)
	// that may have consent access change.
	AffectedResources int64 `json:"affectedResources,omitempty,string"`
	// ConsentApplySuccess: If `validate_only=false` in ApplyAdminConsentsRequest,
	// this counter contains the number of Consent resources that were successfully
	// applied. Otherwise, it is the number of Consent resources that are
	// supported.
	ConsentApplySuccess int64 `json:"consentApplySuccess,omitempty,string"`
	// FailedResources: The number of resources (including the Consent resources)
	// that ApplyAdminConsents failed to re-index.
	FailedResources int64 `json:"failedResources,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "AffectedResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AffectedResources") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApplyAdminConsentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ApplyAdminConsentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApplyConsentsRequest: Request to apply the Consent resources for the
// specified FHIR store.
type ApplyConsentsRequest struct {
	// PatientScope: Optional. Scope down to a list of patients.
	PatientScope *PatientScope `json:"patientScope,omitempty"`
	// TimeRange: Optional. Scope down to patients whose most recent consent
	// changes are in the time range. Can only be used with a versioning store
	// (i.e. when disable_resource_versioning is set to false).
	TimeRange *TimeRange `json:"timeRange,omitempty"`
	// ValidateOnly: Optional. If true, the method only validates Consent resources
	// to make sure they are supported. When the operation completes,
	// ApplyConsentsResponse is returned where `consent_apply_success` and
	// `consent_apply_failure` indicate supported and unsupported (or invalid)
	// Consent resources, respectively. Otherwise, the method propagates the
	// aggregate consensual information to the patient's resources. Upon success,
	// `affected_resources` in the ApplyConsentsResponse indicates the number of
	// resources that may have consensual access changed.
	ValidateOnly bool `json:"validateOnly,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PatientScope") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PatientScope") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApplyConsentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ApplyConsentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApplyConsentsResponse: Response when all Consent resources in scope were
// processed and all affected resources were reindexed successfully. This
// structure is included in the response when the operation finishes
// successfully.
type ApplyConsentsResponse struct {
	// AffectedResources: The number of resources (including the Consent resources)
	// that may have consensual access change.
	AffectedResources int64 `json:"affectedResources,omitempty,string"`
	// ConsentApplyFailure: If `validate_only = false` in ApplyConsentsRequest,
	// this counter is the number of Consent resources that were failed to apply.
	// Otherwise, it is the number of Consent resources that are not supported or
	// invalid.
	ConsentApplyFailure int64 `json:"consentApplyFailure,omitempty,string"`
	// ConsentApplySuccess: If `validate_only = false` in ApplyConsentsRequest,
	// this counter is the number of Consent resources that were successfully
	// applied. Otherwise, it is the number of Consent resources that are
	// supported.
	ConsentApplySuccess int64 `json:"consentApplySuccess,omitempty,string"`
	// FailedResources: The number of resources (including the Consent resources)
	// that ApplyConsents failed to re-index.
	FailedResources int64 `json:"failedResources,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "AffectedResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AffectedResources") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApplyConsentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ApplyConsentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ArchiveUserDataMappingRequest: Archives the specified User data mapping.
type ArchiveUserDataMappingRequest struct {
}

// ArchiveUserDataMappingResponse: Archives the specified User data mapping.
type ArchiveUserDataMappingResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// Attribute: An attribute value for a Consent or User data mapping. Each
// Attribute must have a corresponding AttributeDefinition in the consent store
// that defines the default and allowed values.
type Attribute struct {
	// AttributeDefinitionId: Indicates the name of an attribute defined in the
	// consent store.
	AttributeDefinitionId string `json:"attributeDefinitionId,omitempty"`
	// Values: The value of the attribute. Must be an acceptable value as defined
	// in the consent store. For example, if the consent store defines "data type"
	// with acceptable values "questionnaire" and "step-count", when the attribute
	// name is data type, this field must contain one of those values.
	Values []string `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributeDefinitionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeDefinitionId") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Attribute) MarshalJSON() ([]byte, error) {
	type NoMethod Attribute
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AttributeDefinition: A client-defined consent attribute.
type AttributeDefinition struct {
	// AllowedValues: Required. Possible values for the attribute. The number of
	// allowed values must not exceed 500. An empty list is invalid. The list can
	// only be expanded after creation.
	AllowedValues []string `json:"allowedValues,omitempty"`
	// Category: Required. The category of the attribute. The value of this field
	// cannot be changed after creation.
	//
	// Possible values:
	//   "CATEGORY_UNSPECIFIED" - No category specified. This option is invalid.
	//   "RESOURCE" - Specify this category when this attribute describes the
	// properties of resources. For example, data anonymity or data type.
	//   "REQUEST" - Specify this category when this attribute describes the
	// properties of requests. For example, requester's role or requester's
	// organization.
	Category string `json:"category,omitempty"`
	// ConsentDefaultValues: Optional. Default values of the attribute in Consents.
	// If no default values are specified, it defaults to an empty value.
	ConsentDefaultValues []string `json:"consentDefaultValues,omitempty"`
	// DataMappingDefaultValue: Optional. Default value of the attribute in User
	// data mappings. If no default value is specified, it defaults to an empty
	// value. This field is only applicable to attributes of the category
	// `RESOURCE`.
	DataMappingDefaultValue string `json:"dataMappingDefaultValue,omitempty"`
	// Description: Optional. A description of the attribute.
	Description string `json:"description,omitempty"`
	// Name: Identifier. Resource name of the Attribute definition, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentS
	// tores/{consent_store_id}/attributeDefinitions/{attribute_definition_id}`.
	// Cannot be changed after creation.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AllowedValues") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedValues") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AttributeDefinition) MarshalJSON() ([]byte, error) {
	type NoMethod AttributeDefinition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuditConfig: Specifies the audit configuration for a service. The
// configuration determines which permission types are logged, and what
// identities, if any, are exempted from logging. An AuditConfig must have one
// or more AuditLogConfigs. If there are AuditConfigs for both `allServices`
// and a specific service, the union of the two AuditConfigs is used for that
// service: the log_types specified in each AuditConfig are enabled, and the
// exempted_members in each AuditLogConfig are exempted. Example Policy with
// multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
// "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
// "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
// "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
// "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
// "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
// sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
// logging. It also exempts `jose@example.com` from DATA_READ logging, and
// `aliya@example.com` from DATA_WRITE logging.
type AuditConfig struct {
	// AuditLogConfigs: The configuration for logging of each type of permission.
	AuditLogConfigs []*AuditLogConfig `json:"auditLogConfigs,omitempty"`
	// Service: Specifies a service that will be enabled for audit logging. For
	// example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices`
	// is a special value that covers all services.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuditLogConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditLogConfigs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuditConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuditLogConfig: Provides the configuration for logging a type of
// permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ",
// "exempted_members": [ "user:jose@example.com" ] }, { "log_type":
// "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while
// exempting jose@example.com from DATA_READ logging.
type AuditLogConfig struct {
	// ExemptedMembers: Specifies the identities that do not cause logging for this
	// type of permission. Follows the same format of Binding.members.
	ExemptedMembers []string `json:"exemptedMembers,omitempty"`
	// LogType: The log type that this config enables.
	//
	// Possible values:
	//   "LOG_TYPE_UNSPECIFIED" - Default case. Should never be this.
	//   "ADMIN_READ" - Admin reads. Example: CloudIAM getIamPolicy
	//   "DATA_WRITE" - Data writes. Example: CloudSQL Users create
	//   "DATA_READ" - Data reads. Example: CloudSQL Users list
	LogType string `json:"logType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExemptedMembers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExemptedMembers") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuditLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditLogConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchGetMessagesResponse: Gets multiple messages in a specified HL7v2 store.
type BatchGetMessagesResponse struct {
	// Messages: The returned Messages. See `MessageView` for populated fields.
	Messages []*Message `json:"messages,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Messages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Messages") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchGetMessagesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchGetMessagesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Binding: Associates `members`, or principals, with a `role`.
type Binding struct {
	// Condition: The condition that is associated with this binding. If the
	// condition evaluates to `true`, then this binding applies to the current
	// request. If the condition evaluates to `false`, then this binding does not
	// apply to the current request. However, a different role binding might grant
	// the same role to one or more of the principals in this binding. To learn
	// which resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *Expr `json:"condition,omitempty"`
	// Members: Specifies the principals requesting access for a Google Cloud
	// resource. `members` can have the following values: * `allUsers`: A special
	// identifier that represents anyone who is on the internet; with or without a
	// Google account. * `allAuthenticatedUsers`: A special identifier that
	// represents anyone who is authenticated with a Google account or a service
	// account. Does not include identities that come from external identity
	// providers (IdPs) through identity federation. * `user:{emailid}`: An email
	// address that represents a specific Google account. For example,
	// `alice@example.com` . * `serviceAccount:{emailid}`: An email address that
	// represents a Google service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`. *
	// `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An
	// identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
	// `group:{emailid}`: An email address that represents a Google group. For
	// example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
	// (primary) that represents all the users of that domain. For example,
	// `google.com` or `example.com`. *
	// `principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/sub
	// ject/{subject_attribute_value}`: A single identity in a workforce identity
	// pool. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// group/{group_id}`: All workforce identities in a group. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// attribute.{attribute_name}/{attribute_value}`: All workforce identities with
	// a specific attribute value. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// *`: All identities in a workforce identity pool. *
	// `principal://iam.googleapis.com/projects/{project_number}/locations/global/wo
	// rkloadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
	// identity in a workload identity pool. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/group/{group_id}`: A workload identity pool
	// group. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}
	// `: All identities in a workload identity pool with a certain attribute. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/*`: All identities in a workload identity
	// pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a user that has been recently deleted. For
	// example, `alice@example.com?uid=123456789012345678901`. If the user is
	// recovered, this value reverts to `user:{emailid}` and the recovered user
	// retains the role in the binding. *
	// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a service account that has been recently
	// deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
	// service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains the
	// role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email
	// address (plus unique identifier) representing a Google group that has been
	// recently deleted. For example,
	// `admins@example.com?uid=123456789012345678901`. If the group is recovered,
	// this value reverts to `group:{emailid}` and the recovered group retains the
	// role in the binding. *
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool
	// _id}/subject/{subject_attribute_value}`: Deleted single identity in a
	// workforce identity pool. For example,
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-po
	// ol-id/subject/my-subject-attribute-value`.
	Members []string `json:"members,omitempty"`
	// Role: Role that is assigned to the list of `members`, or principals. For
	// example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an overview
	// of the IAM roles and permissions, see the IAM documentation
	// (https://cloud.google.com/iam/docs/roles-overview). For a list of the
	// available pre-defined roles, see here
	// (https://cloud.google.com/iam/docs/understanding-roles).
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Binding) MarshalJSON() ([]byte, error) {
	type NoMethod Binding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BlobStorageInfo: BlobStorageInfo contains details about the data stored in
// Blob Storage for the referenced resource. Note: Storage class is only valid
// for DICOM and hence will only be populated for DICOM resources.
type BlobStorageInfo struct {
	// SizeBytes: Size in bytes of data stored in Blob Storage.
	SizeBytes int64 `json:"sizeBytes,omitempty,string"`
	// StorageClass: The storage class in which the Blob data is stored.
	//
	// Possible values:
	//   "BLOB_STORAGE_CLASS_UNSPECIFIED" - If unspecified in CreateDataset, the
	// StorageClass defaults to STANDARD. If unspecified in UpdateDataset and the
	// StorageClass is set in the field mask, an InvalidRequest error is thrown.
	//   "STANDARD" - This stores the Object in Blob Standard Storage:
	// https://cloud.google.com/storage/docs/storage-classes#standard
	//   "NEARLINE" - This stores the Object in Blob Nearline Storage:
	// https://cloud.google.com/storage/docs/storage-classes#nearline
	//   "COLDLINE" - This stores the Object in Blob Coldline Storage:
	// https://cloud.google.com/storage/docs/storage-classes#coldline
	//   "ARCHIVE" - This stores the Object in Blob Archive Storage:
	// https://cloud.google.com/storage/docs/storage-classes#archive
	StorageClass string `json:"storageClass,omitempty"`
	// StorageClassUpdateTime: The time at which the storage class was updated.
	// This is used to compute early deletion fees of the resource.
	StorageClassUpdateTime string `json:"storageClassUpdateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SizeBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SizeBytes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BlobStorageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod BlobStorageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BlobStorageSettings: Settings for data stored in Blob storage.
type BlobStorageSettings struct {
	// BlobStorageClass: The Storage class in which the Blob data is stored.
	//
	// Possible values:
	//   "BLOB_STORAGE_CLASS_UNSPECIFIED" - If unspecified in CreateDataset, the
	// StorageClass defaults to STANDARD. If unspecified in UpdateDataset and the
	// StorageClass is set in the field mask, an InvalidRequest error is thrown.
	//   "STANDARD" - This stores the Object in Blob Standard Storage:
	// https://cloud.google.com/storage/docs/storage-classes#standard
	//   "NEARLINE" - This stores the Object in Blob Nearline Storage:
	// https://cloud.google.com/storage/docs/storage-classes#nearline
	//   "COLDLINE" - This stores the Object in Blob Coldline Storage:
	// https://cloud.google.com/storage/docs/storage-classes#coldline
	//   "ARCHIVE" - This stores the Object in Blob Archive Storage:
	// https://cloud.google.com/storage/docs/storage-classes#archive
	BlobStorageClass string `json:"blobStorageClass,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlobStorageClass") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlobStorageClass") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BlobStorageSettings) MarshalJSON() ([]byte, error) {
	type NoMethod BlobStorageSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BoundingPoly: A bounding polygon for the detected image annotation.
type BoundingPoly struct {
	// Label: A description of this polygon.
	Label string `json:"label,omitempty"`
	// Vertices: List of the vertices of this polygon.
	Vertices []*Vertex `json:"vertices,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Label") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Label") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BoundingPoly) MarshalJSON() ([]byte, error) {
	type NoMethod BoundingPoly
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CancelOperationRequest: The request message for Operations.CancelOperation.
type CancelOperationRequest struct {
}

// CharacterMaskConfig: Mask a string by replacing its characters with a fixed
// character.
type CharacterMaskConfig struct {
	// MaskingCharacter: Character to mask the sensitive values. If not supplied,
	// defaults to "*".
	MaskingCharacter string `json:"maskingCharacter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaskingCharacter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaskingCharacter") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CharacterMaskConfig) MarshalJSON() ([]byte, error) {
	type NoMethod CharacterMaskConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CharacterMaskField: Replace field value with masking character. Supported
// types (https://www.hl7.org/fhir/datatypes.html): Code, Decimal, HumanName,
// Id, LanguageCode, Markdown, Oid, String, Uri, Uuid, Xhtml.
type CharacterMaskField struct {
}

// CheckDataAccessRequest: Checks if a particular data_id of a User data
// mapping in the given consent store is consented for a given use.
type CheckDataAccessRequest struct {
	// ConsentList: Optional. Specific Consents to evaluate the access request
	// against. These Consents must have the same `user_id` as the evaluated User
	// data mapping, must exist in the current `consent_store`, and have a `state`
	// of either `ACTIVE` or `DRAFT`. A maximum of 100 Consents can be provided
	// here. If no selection is specified, the access request is evaluated against
	// all `ACTIVE` unexpired Consents with the same `user_id` as the evaluated
	// User data mapping.
	ConsentList *ConsentList `json:"consentList,omitempty"`
	// DataId: Required. The unique identifier of the resource to check access for.
	// This identifier must correspond to a User data mapping in the given consent
	// store.
	DataId string `json:"dataId,omitempty"`
	// RequestAttributes: The values of request attributes associated with this
	// access request.
	RequestAttributes map[string]string `json:"requestAttributes,omitempty"`
	// ResponseView: Optional. The view for CheckDataAccessResponse. If
	// unspecified, defaults to `BASIC` and returns `consented` as `TRUE` or
	// `FALSE`.
	//
	// Possible values:
	//   "RESPONSE_VIEW_UNSPECIFIED" - No response view specified. The API will
	// default to the BASIC view.
	//   "BASIC" - Only the `consented` field is populated in
	// CheckDataAccessResponse.
	//   "FULL" - All fields within CheckDataAccessResponse are populated. When set
	// to `FULL`, all `ACTIVE` Consents are evaluated even if a matching policy is
	// found during evaluation.
	ResponseView string `json:"responseView,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConsentList") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsentList") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CheckDataAccessRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CheckDataAccessRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CheckDataAccessResponse: Checks if a particular data_id of a User data
// mapping in the given consent store is consented for a given use.
type CheckDataAccessResponse struct {
	// ConsentDetails: The resource names of all evaluated Consents mapped to their
	// evaluation.
	ConsentDetails map[string]ConsentEvaluation `json:"consentDetails,omitempty"`
	// Consented: Whether the requested resource is consented for the given use.
	Consented bool `json:"consented,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConsentDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsentDetails") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CheckDataAccessResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CheckDataAccessResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CleanDescriptorsOption: This option is based on the DICOM Standard's Clean
// Descriptors Option
// (http://dicom.nema.org/medical/dicom/2018e/output/chtml/part15/sect_E.3.5.html),
// and the `CleanText` `Action` is applied to all the specified fields. When
// cleaning text, the process attempts to transform phrases matching any of the
// tags marked for removal (action codes D, Z, X, and U) in the Basic Profile
// (http://dicom.nema.org/medical/dicom/2018e/output/chtml/part15/chapter_E.html).
// These contextual phrases are replaced with the token "[CTX]". This option
// uses an additional infoType during inspection.
type CleanDescriptorsOption struct {
}

// CleanTextField: Inspect text and transform sensitive text. Configure using
// TextConfig. Supported types (https://www.hl7.org/fhir/datatypes.html): Code,
// Date, DateTime, Decimal, HumanName, Id, LanguageCode, Markdown, Oid, String,
// Uri, Uuid, Xhtml.
type CleanTextField struct {
}

// CleanTextTag: Inspect text and transform sensitive text. Configurable using
// TextConfig. Supported [Value Representations]
// (http://dicom.nema.org/medical/dicom/2018e/output/chtml/part05/sect_6.2.html#table_6.2-1):
// AE, LO, LT, PN, SH, ST, UC, UT, DA, DT, AS
type CleanTextTag struct {
}

// CloudHealthcareSource: Cloud Healthcare API resource.
type CloudHealthcareSource struct {
	// Name: Full path of a Cloud Healthcare API resource.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudHealthcareSource) MarshalJSON() ([]byte, error) {
	type NoMethod CloudHealthcareSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigureSearchRequest: Request to configure the search parameters for the
// specified FHIR store.
type ConfigureSearchRequest struct {
	// CanonicalUrls: The canonical URLs of the search parameters that are intended
	// to be used for the FHIR store. See
	// https://www.hl7.org/fhir/references.html#canonical for explanation on FHIR
	// canonical urls
	CanonicalUrls []string `json:"canonicalUrls,omitempty"`
	// ValidateOnly: If `validate_only` is set to true, the method will compile all
	// the search parameters without actually setting the search config for the
	// store and triggering the reindex.
	ValidateOnly bool `json:"validateOnly,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CanonicalUrls") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CanonicalUrls") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigureSearchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigureSearchRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Consent: Represents a user's consent.
type Consent struct {
	// ConsentArtifact: Required. The resource name of the Consent artifact that
	// contains proof of the end user's consent, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentS
	// tores/{consent_store_id}/consentArtifacts/{consent_artifact_id}`.
	ConsentArtifact string `json:"consentArtifact,omitempty"`
	// ExpireTime: Timestamp in UTC of when this Consent is considered expired.
	ExpireTime string `json:"expireTime,omitempty"`
	// Metadata: Optional. User-supplied key-value pairs used to organize Consent
	// resources. Metadata keys must: - be between 1 and 63 characters long - have
	// a UTF-8 encoding of maximum 128 bytes - begin with a letter - consist of up
	// to 63 characters including lowercase letters, numeric characters,
	// underscores, and dashes Metadata values must be: - be between 1 and 63
	// characters long - have a UTF-8 encoding of maximum 128 bytes - consist of up
	// to 63 characters including lowercase letters, numeric characters,
	// underscores, and dashes No more than 64 metadata entries can be associated
	// with a given consent.
	Metadata map[string]string `json:"metadata,omitempty"`
	// Name: Identifier. Resource name of the Consent, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentS
	// tores/{consent_store_id}/consents/{consent_id}`. Cannot be changed after
	// creation.
	Name string `json:"name,omitempty"`
	// Policies: Optional. Represents a user's consent in terms of the resources
	// that can be accessed and under what conditions.
	Policies []*GoogleCloudHealthcareV1beta1ConsentPolicy `json:"policies,omitempty"`
	// RevisionCreateTime: Output only. The timestamp that the revision was
	// created.
	RevisionCreateTime string `json:"revisionCreateTime,omitempty"`
	// RevisionId: Output only. The revision ID of the Consent. The format is an
	// 8-character hexadecimal string. Refer to a specific revision of a Consent by
	// appending `@{revision_id}` to the Consent's resource name.
	RevisionId string `json:"revisionId,omitempty"`
	// State: Required. Indicates the current state of this Consent.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - No state specified. Treated as ACTIVE only at the
	// time of resource creation.
	//   "ACTIVE" - The Consent is active and is considered when evaluating a
	// user's consent on resources.
	//   "ARCHIVED" - The archived state is currently not being used.
	//   "REVOKED" - A revoked Consent is not considered when evaluating a user's
	// consent on resources.
	//   "DRAFT" - A draft Consent is not considered when evaluating a user's
	// consent on resources unless explicitly specified.
	//   "REJECTED" - When a draft Consent is rejected by a user, it is set to a
	// rejected state. A rejected Consent is not considered when evaluating a
	// user's consent on resources.
	State string `json:"state,omitempty"`
	// Ttl: Input only. The time to live for this Consent from when it is created.
	Ttl string `json:"ttl,omitempty"`
	// UserId: Required. User's UUID provided by the client.
	UserId string `json:"userId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConsentArtifact") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsentArtifact") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Consent) MarshalJSON() ([]byte, error) {
	type NoMethod Consent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConsentAccessorScope: The accessor scope that describes who can access, for
// what purpose, in which environment.
type ConsentAccessorScope struct {
	// Actor: An individual, group, or access role that identifies the accessor or
	// a characteristic of the accessor. This can be a resource ID (such as
	// `{resourceType}/{id}`) or an external URI. This value must be present.
	Actor string `json:"actor,omitempty"`
	// Environment: An abstract identifier that describes the environment or
	// conditions under which the accessor is acting. Can be "*" if it applies to
	// all environments.
	Environment string `json:"environment,omitempty"`
	// Purpose: The intent of data use. Can be "*" if it applies to all purposes.
	Purpose string `json:"purpose,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Actor") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Actor") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConsentAccessorScope) MarshalJSON() ([]byte, error) {
	type NoMethod ConsentAccessorScope
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConsentArtifact: Documentation of a user's consent.
type ConsentArtifact struct {
	// ConsentContentScreenshots: Optional. Screenshots, PDFs, or other binary
	// information documenting the user's consent.
	ConsentContentScreenshots []*Image `json:"consentContentScreenshots,omitempty"`
	// ConsentContentVersion: Optional. An string indicating the version of the
	// consent information shown to the user.
	ConsentContentVersion string `json:"consentContentVersion,omitempty"`
	// GuardianSignature: Optional. A signature from a guardian.
	GuardianSignature *Signature `json:"guardianSignature,omitempty"`
	// Metadata: Optional. Metadata associated with the Consent artifact. For
	// example, the consent locale or user agent version.
	Metadata map[string]string `json:"metadata,omitempty"`
	// Name: Identifier. Resource name of the Consent artifact, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentS
	// tores/{consent_store_id}/consentArtifacts/{consent_artifact_id}`. Cannot be
	// changed after creation.
	Name string `json:"name,omitempty"`
	// UserId: Required. User's UUID provided by the client.
	UserId string `json:"userId,omitempty"`
	// UserSignature: Optional. User's signature.
	UserSignature *Signature `json:"userSignature,omitempty"`
	// WitnessSignature: Optional. A signature from a witness.
	WitnessSignature *Signature `json:"witnessSignature,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConsentContentScreenshots")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsentContentScreenshots") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConsentArtifact) MarshalJSON() ([]byte, error) {
	type NoMethod ConsentArtifact
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConsentConfig: Configures whether to enforce consent for the FHIR store and
// which consent enforcement version is being used.
type ConsentConfig struct {
	// AccessDeterminationLogConfig: Optional. Specifies how the server logs the
	// consent-aware requests. If not specified, the
	// `AccessDeterminationLogConfig.LogLevel.MINIMUM` option is used.
	AccessDeterminationLogConfig *AccessDeterminationLogConfig `json:"accessDeterminationLogConfig,omitempty"`
	// AccessEnforced: Optional. The default value is false. If set to true, when
	// accessing FHIR resources, the consent headers will be verified against
	// consents given by patients. See the ConsentEnforcementVersion for the
	// supported consent headers.
	AccessEnforced bool `json:"accessEnforced,omitempty"`
	// ConsentHeaderHandling: Optional. Different options to configure the
	// behaviour of the server when handling the `X-Consent-Scope` header.
	ConsentHeaderHandling *ConsentHeaderHandling `json:"consentHeaderHandling,omitempty"`
	// EnforcedAdminConsents: The versioned names of the enforced admin Consent
	// resource(s), in the format
	// `projects/{project_id}/locations/{location}/datasets/{dataset_id}/fhirStores/
	// {fhir_store_id}/fhir/Consent/{resource_id}/_history/{version_id}`. For FHIR
	// stores with `disable_resource_versioning=true`, the format is
	// `projects/{project_id}/locations/{location}/datasets/{dataset_id}/fhirStores/
	// {fhir_store_id}/fhir/Consent/{resource_id}`. This field can only be updated
	// using ApplyAdminConsents.
	EnforcedAdminConsents []string `json:"enforcedAdminConsents,omitempty"`
	// Version: Required. Specifies which consent enforcement version is being used
	// for this FHIR store. This field can only be set once by either
	// CreateFhirStore or UpdateFhirStore. After that, you must call ApplyConsents
	// to change the version.
	//
	// Possible values:
	//   "CONSENT_ENFORCEMENT_VERSION_UNSPECIFIED" - Users must specify an
	// enforcement version or an error is returned.
	//   "V1" - Enforcement version 1. See the [FHIR Consent resources in the Cloud
	// Healthcare API](https://cloud.google.com/healthcare-api/docs/fhir-consent)
	// guide for more details.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AccessDeterminationLogConfig") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessDeterminationLogConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConsentConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ConsentConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConsentErrors: The Consent resource name and error.
type ConsentErrors struct {
	// Error: The error code and message.
	Error *Status `json:"error,omitempty"`
	// Name: The versioned name of the admin Consent resource, in the format
	// `projects/{project_id}/locations/{location}/datasets/{dataset_id}/fhirStores/
	// {fhir_store_id}/fhir/Consent/{resource_id}/_history/{version_id}`. For FHIR
	// stores with `disable_resource_versioning=true`, the format is
	// `projects/{project_id}/locations/{location}/datasets/{dataset_id}/fhirStores/
	// {fhir_store_id}/fhir/Consent/{resource_id}`.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Error") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Error") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConsentErrors) MarshalJSON() ([]byte, error) {
	type NoMethod ConsentErrors
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConsentEvaluation: The detailed evaluation of a particular Consent.
type ConsentEvaluation struct {
	// EvaluationResult: The evaluation result.
	//
	// Possible values:
	//   "EVALUATION_RESULT_UNSPECIFIED" - No evaluation result specified. This
	// option is invalid.
	//   "NOT_APPLICABLE" - The Consent is not applicable to the requested access
	// determination. For example, the Consent does not apply to the user for which
	// the access determination is requested, or it has a `state` of `REVOKED`, or
	// it has expired.
	//   "NO_MATCHING_POLICY" - The Consent does not have a policy that matches the
	// `resource_attributes` of the evaluated resource.
	//   "NO_SATISFIED_POLICY" - The Consent has at least one policy that matches
	// the `resource_attributes` of the evaluated resource, but no
	// `authorization_rule` was satisfied.
	//   "HAS_SATISFIED_POLICY" - The Consent has at least one policy that matches
	// the `resource_attributes` of the evaluated resource, and at least one
	// `authorization_rule` was satisfied.
	EvaluationResult string `json:"evaluationResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EvaluationResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EvaluationResult") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConsentEvaluation) MarshalJSON() ([]byte, error) {
	type NoMethod ConsentEvaluation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConsentHeaderHandling: How the server handles the consent header.
type ConsentHeaderHandling struct {
	// Profile: Optional. Specifies the default server behavior when the header is
	// empty. If not specified, the `ScopeProfile.PERMIT_EMPTY_SCOPE` option is
	// used.
	//
	// Possible values:
	//   "SCOPE_PROFILE_UNSPECIFIED" - If not specified, the default value
	// `PERMIT_EMPTY_SCOPE` is used.
	//   "PERMIT_EMPTY_SCOPE" - When no consent scopes are provided (for example,
	// if there's an empty or missing header), then consent check is disabled,
	// similar to when `access_enforced` is `false`. You can use audit logs to
	// differentiate these two cases by looking at the value of
	// `protopayload.metadata.consentMode`. If consents scopes are present, they
	// must be valid and within the allowed limits, otherwise the request will be
	// rejected with a `4xx` code.
	//   "REQUIRED_ON_READ" - The consent header must be non-empty when performing
	// read and search operations, otherwise the request is rejected with a `4xx`
	// code. Additionally, invalid consent scopes or scopes exceeding the allowed
	// limits are rejected.
	Profile string `json:"profile,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Profile") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Profile") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConsentHeaderHandling) MarshalJSON() ([]byte, error) {
	type NoMethod ConsentHeaderHandling
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConsentList: List of resource names of Consent resources.
type ConsentList struct {
	// Consents: The resource names of the Consents to evaluate against, of the
	// form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentS
	// tores/{consent_store_id}/consents/{consent_id}`.
	Consents []string `json:"consents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Consents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Consents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConsentList) MarshalJSON() ([]byte, error) {
	type NoMethod ConsentList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConsentStore: Represents a consent store.
type ConsentStore struct {
	// DefaultConsentTtl: Optional. Default time to live for Consents created in
	// this store. Must be at least 24 hours. Updating this field will not affect
	// the expiration time of existing consents.
	DefaultConsentTtl string `json:"defaultConsentTtl,omitempty"`
	// EnableConsentCreateOnUpdate: Optional. If `true`, UpdateConsent creates the
	// Consent if it does not already exist. If unspecified, defaults to `false`.
	EnableConsentCreateOnUpdate bool `json:"enableConsentCreateOnUpdate,omitempty"`
	// Labels: Optional. User-supplied key-value pairs used to organize consent
	// stores. Label keys must be between 1 and 63 characters long, have a UTF-8
	// encoding of maximum 128 bytes, and must conform to the following PCRE
	// regular expression: \p{Ll}\p{Lo}{0,62}. Label values must be between 1 and
	// 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
	// conform to the following PCRE regular expression:
	// [\p{Ll}\p{Lo}\p{N}_-]{0,63}. No more than 64 labels can be associated with a
	// given store. For more information:
	// https://cloud.google.com/healthcare/docs/how-tos/labeling-resources
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Resource name of the consent store, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentS
	// tores/{consent_store_id}`. Cannot be changed after creation.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DefaultConsentTtl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultConsentTtl") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConsentStore) MarshalJSON() ([]byte, error) {
	type NoMethod ConsentStore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ContextualDeidConfig: Fields that don't match a KeepField or CleanTextField
// `action` in the BASIC profile are collected into a contextual phrase list.
// For fields that match a CleanTextField `action` in FieldMetadata or
// ProfileType, the process attempts to transform phrases matching these
// contextual entries. These contextual phrases are replaced with the token
// "[CTX]". This feature uses an additional InfoType during inspection.
type ContextualDeidConfig struct {
}

// CreateMessageRequest: Creates a new message.
type CreateMessageRequest struct {
	// Message: Required. HL7v2 message.
	Message *Message `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Message") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Message") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreateMessageRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CreateMessageRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CryptoHashConfig: Pseudonymization method that generates surrogates via
// cryptographic hashing. Uses SHA-256. Outputs a base64-encoded representation
// of the hashed output. For example,
// `L7k0BHmF1ha5U3NfGykjro4xWi1MPVQPjhMAZbSV9mM=`.
type CryptoHashConfig struct {
	// CryptoKey: An AES 128/192/256 bit key. Causes the hash to be computed based
	// on this key. A default key is generated for each Deidentify operation and is
	// used when neither crypto_key nor kms_wrapped is specified. Must not be set
	// if kms_wrapped is set.
	CryptoKey string `json:"cryptoKey,omitempty"`
	// KmsWrapped: KMS wrapped key. Must not be set if crypto_key is set.
	KmsWrapped *KmsWrappedCryptoKey `json:"kmsWrapped,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CryptoKey") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CryptoKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CryptoHashConfig) MarshalJSON() ([]byte, error) {
	type NoMethod CryptoHashConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CryptoHashField: Replace field value with a hash of that value. Supported
// types (https://www.hl7.org/fhir/datatypes.html): Code, Decimal, HumanName,
// Id, LanguageCode, Markdown, Oid, String, Uri, Uuid, Xhtml.
type CryptoHashField struct {
}

// Dataset: A message representing a health dataset. A health dataset
// represents a collection of healthcare data pertaining to one or more
// patients. This may include multiple modalities of healthcare data, such as
// electronic medical records or medical imaging data.
type Dataset struct {
	// EncryptionSpec: Customer-managed encryption key spec for a Dataset. If set,
	// this Dataset and all of its sub-resources will be secured by this key. If
	// empty, the Dataset is secured by the default Google encryption key.
	EncryptionSpec *EncryptionSpec `json:"encryptionSpec,omitempty"`
	// Name: Identifier. Resource name of the dataset, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
	Name string `json:"name,omitempty"`
	// TimeZone: The default timezone used by this dataset. Must be a either a
	// valid IANA time zone name such as "America/New_York" or empty, which
	// defaults to UTC. This is used for parsing times in resources, such as HL7
	// messages, where no explicit timezone is specified.
	TimeZone string `json:"timeZone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EncryptionSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EncryptionSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Dataset) MarshalJSON() ([]byte, error) {
	type NoMethod Dataset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DateShiftConfig: Shift a date forward or backward in time by a random amount
// which is consistent for a given patient and crypto key combination.
type DateShiftConfig struct {
	// CryptoKey: An AES 128/192/256 bit key. The date shift is computed based on
	// this key and the patient ID. If the patient ID is empty for a DICOM
	// resource, the date shift is computed based on this key and the study
	// instance UID. If crypto_key is not set, then kms_wrapped is used to
	// calculate the date shift. If neither is set, a default key is generated for
	// each de-identify operation. Must not be set if kms_wrapped is set.
	CryptoKey string `json:"cryptoKey,omitempty"`
	// KmsWrapped: KMS wrapped key. If kms_wrapped is not set, then crypto_key is
	// used to calculate the date shift. If neither is set, a default key is
	// generated for each de-identify operation. Must not be set if crypto_key is
	// set.
	KmsWrapped *KmsWrappedCryptoKey `json:"kmsWrapped,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CryptoKey") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CryptoKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DateShiftConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DateShiftConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DateShiftField: Shift the date by a randomized number of days. See date
// shifting (https://cloud.google.com/dlp/docs/concepts-date-shifting) for more
// information. Supported types (https://www.hl7.org/fhir/datatypes.html):
// Date, DateTime.
type DateShiftField struct {
}

// DeidentifiedStoreDestination: Contains configuration for streaming
// de-identified FHIR export.
type DeidentifiedStoreDestination struct {
	// Config: The configuration to use when de-identifying resources that are
	// added to this store.
	Config *DeidentifyConfig `json:"config,omitempty"`
	// Store: The full resource name of a Cloud Healthcare FHIR store, for example,
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirStor
	// es/{fhir_store_id}`.
	Store string `json:"store,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Config") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeidentifiedStoreDestination) MarshalJSON() ([]byte, error) {
	type NoMethod DeidentifiedStoreDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeidentifyConfig: Configures de-id options specific to different types of
// content. Each submessage customizes the handling of an
// https://tools.ietf.org/html/rfc6838 media type or subtype. Configs are
// applied in a nested manner at runtime.
type DeidentifyConfig struct {
	// Annotation: Configures how annotations, meaning that the location and
	// infoType of sensitive information findings, are created during
	// de-identification. If unspecified, no annotations are created.
	Annotation *AnnotationConfig `json:"annotation,omitempty"`
	// Dicom: Configures de-id of application/DICOM content. Deprecated. Use
	// `dicom_tag_config` instead.
	Dicom *DicomConfig `json:"dicom,omitempty"`
	// DicomTagConfig: Configures de-id of application/DICOM content.
	DicomTagConfig *DicomTagConfig `json:"dicomTagConfig,omitempty"`
	// Fhir: Configures de-id of application/FHIR content. Deprecated. Use
	// `fhir_field_config` instead.
	Fhir *FhirConfig `json:"fhir,omitempty"`
	// FhirFieldConfig: Configures de-id of application/FHIR content.
	FhirFieldConfig *FhirFieldConfig `json:"fhirFieldConfig,omitempty"`
	// Image: Configures the de-identification of image pixels in the
	// source_dataset. Deprecated. Use `dicom_tag_config.options.clean_image`
	// instead.
	Image *ImageConfig `json:"image,omitempty"`
	// OperationMetadata: Details about the work the de-identify operation
	// performed.
	OperationMetadata *DeidentifyOperationMetadata `json:"operationMetadata,omitempty"`
	// Text: Configures de-identification of text wherever it is found in the
	// source_dataset.
	Text *TextConfig `json:"text,omitempty"`
	// UseRegionalDataProcessing: Ensures in-flight data remains in the region of
	// origin during de-identification. The default value is false. Using this
	// option results in a significant reduction of throughput, and is not
	// compatible with `LOCATION` or `ORGANIZATION_NAME` infoTypes. If the
	// deprecated DicomConfig or FhirConfig are used, then `LOCATION` must be
	// excluded within TextConfig, and must also be excluded within ImageConfig if
	// image redaction is required.
	UseRegionalDataProcessing bool `json:"useRegionalDataProcessing,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Annotation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeidentifyConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DeidentifyConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeidentifyDatasetRequest: Redacts identifying information from the specified
// dataset.
type DeidentifyDatasetRequest struct {
	// Config: Deidentify configuration. Only one of `config` and `gcs_config_uri`
	// can be specified.
	Config *DeidentifyConfig `json:"config,omitempty"`
	// DestinationDataset: Required. The name of the dataset resource to create and
	// write the redacted data to. * The destination dataset must not exist. * The
	// destination dataset must be in the same location as the source dataset.
	// De-identifying data across multiple locations is not supported.
	DestinationDataset string `json:"destinationDataset,omitempty"`
	// GcsConfigUri: Cloud Storage location to read the JSON
	// cloud.healthcare.deidentify.DeidentifyConfig from, overriding the default
	// config. Must be of the form `gs://{bucket_id}/path/to/object`. The Cloud
	// Storage location must grant the Cloud IAM role `roles/storage.objectViewer`
	// to the project's Cloud Healthcare Service Agent service account. Only one of
	// `config` and `gcs_config_uri` can be specified.
	GcsConfigUri string `json:"gcsConfigUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Config") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeidentifyDatasetRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DeidentifyDatasetRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeidentifyDicomStoreRequest: Creates a new DICOM store with sensitive
// information de-identified.
type DeidentifyDicomStoreRequest struct {
	// Config: Deidentify configuration. Only one of `config` and `gcs_config_uri`
	// can be specified.
	Config *DeidentifyConfig `json:"config,omitempty"`
	// DestinationStore: Required. The name of the DICOM store to create and write
	// the redacted data to. For example,
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomSto
	// res/{dicom_store_id}`. * The destination dataset must exist. * The source
	// dataset and destination dataset must both reside in the same location.
	// De-identifying data across multiple locations is not supported. * The
	// destination DICOM store must not exist. * The caller must have the necessary
	// permissions to create the destination DICOM store.
	DestinationStore string `json:"destinationStore,omitempty"`
	// FilterConfig: Filter configuration.
	FilterConfig *DicomFilterConfig `json:"filterConfig,omitempty"`
	// GcsConfigUri: Cloud Storage location to read the JSON
	// cloud.healthcare.deidentify.DeidentifyConfig from, overriding the default
	// config. Must be of the form `gs://{bucket_id}/path/to/object`. The Cloud
	// Storage location must grant the Cloud IAM role `roles/storage.objectViewer`
	// to the project's Cloud Healthcare Service Agent service account. Only one of
	// `config` and `gcs_config_uri` can be specified.
	GcsConfigUri string `json:"gcsConfigUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Config") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeidentifyDicomStoreRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DeidentifyDicomStoreRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeidentifyFhirStoreRequest: Creates a new FHIR store with sensitive
// information de-identified.
type DeidentifyFhirStoreRequest struct {
	// Config: Deidentify configuration. Only one of `config` and `gcs_config_uri`
	// can be specified.
	Config *DeidentifyConfig `json:"config,omitempty"`
	// DestinationStore: Required. The name of the FHIR store to create and write
	// the redacted data to. For example,
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirStor
	// es/{fhir_store_id}`. * The destination dataset must exist. * The source
	// dataset and destination dataset must both reside in the same location.
	// De-identifying data across multiple locations is not supported. * The
	// destination FHIR store must exist. * The caller must have the
	// healthcare.fhirResources.update permission to write to the destination FHIR
	// store.
	DestinationStore string `json:"destinationStore,omitempty"`
	// GcsConfigUri: Cloud Storage location to read the JSON
	// cloud.healthcare.deidentify.DeidentifyConfig from, overriding the default
	// config. Must be of the form `gs://{bucket_id}/path/to/object`. The Cloud
	// Storage location must grant the Cloud IAM role `roles/storage.objectViewer`
	// to the project's Cloud Healthcare Service Agent service account. Only one of
	// `config` and `gcs_config_uri` can be specified.
	GcsConfigUri string `json:"gcsConfigUri,omitempty"`
	// ResourceFilter: A filter specifying the resources to include in the output.
	// If not specified, all resources are included in the output.
	ResourceFilter *FhirFilter `json:"resourceFilter,omitempty"`
	// SkipModifiedResources: If true, skips resources that are created or modified
	// after the de-identify operation is created.
	SkipModifiedResources bool `json:"skipModifiedResources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Config") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeidentifyFhirStoreRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DeidentifyFhirStoreRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeidentifyOperationMetadata: Details about the work the de-identify
// operation performed.
type DeidentifyOperationMetadata struct {
	// FhirOutput: Details about the FHIR store to write the output to.
	FhirOutput *FhirOutput `json:"fhirOutput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FhirOutput") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FhirOutput") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeidentifyOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod DeidentifyOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeidentifySummary: Contains a detailed summary of the Deidentify operation.
type DeidentifySummary struct {
}

// DeleteTag: Delete tag.
type DeleteTag struct {
}

// Detail: Contains multiple sensitive information findings for each resource
// slice.
type Detail struct {
	Findings []*Finding `json:"findings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Findings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Findings") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Detail) MarshalJSON() ([]byte, error) {
	type NoMethod Detail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DicomConfig: Specifies the parameters needed for de-identification of DICOM
// stores.
type DicomConfig struct {
	// FilterProfile: Tag filtering profile that determines which tags to
	// keep/remove.
	//
	// Possible values:
	//   "TAG_FILTER_PROFILE_UNSPECIFIED" - No tag filtration profile provided.
	// Same as KEEP_ALL_PROFILE.
	//   "MINIMAL_KEEP_LIST_PROFILE" - Keep only the tags required to produce valid
	// DICOM objects.
	//   "ATTRIBUTE_CONFIDENTIALITY_BASIC_PROFILE" - Remove tags based on DICOM
	// Standard's Attribute Confidentiality Basic Profile (DICOM Standard Edition
	// 2018e)
	// http://dicom.nema.org/medical/dicom/2018e/output/chtml/part15/chapter_E.html.
	//   "KEEP_ALL_PROFILE" - Keep all tags.
	//   "DEIDENTIFY_TAG_CONTENTS" - Inspect within tag contents and replace
	// sensitive text. The process can be configured using the TextConfig. Applies
	// to all tags with the following Value Representation names: AE, LO, LT, PN,
	// SH, ST, UC, UT, DA, DT, AS
	FilterProfile string `json:"filterProfile,omitempty"`
	// KeepList: List of tags to keep. Remove all other tags.
	KeepList *TagFilterList `json:"keepList,omitempty"`
	// RemoveList: List of tags to remove. Keep all other tags.
	RemoveList *TagFilterList `json:"removeList,omitempty"`
	// SkipIdRedaction: If true, skip replacing StudyInstanceUID,
	// SeriesInstanceUID, SOPInstanceUID, and MediaStorageSOPInstanceUID and leave
	// them untouched. The Cloud Healthcare API regenerates these UIDs by default
	// based on the DICOM Standard's reasoning: "Whilst these UIDs cannot be mapped
	// directly to an individual out of context, given access to the original
	// images, or to a database of the original images containing the UIDs, it
	// would be possible to recover the individual's identity."
	// http://dicom.nema.org/medical/dicom/current/output/chtml/part15/sect_E.3.9.html
	SkipIdRedaction bool `json:"skipIdRedaction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FilterProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FilterProfile") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DicomConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DicomConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DicomFilterConfig: Specifies the filter configuration for DICOM resources.
type DicomFilterConfig struct {
	// ResourcePathsGcsUri: The Cloud Storage location of the filter configuration
	// file. The `gcs_uri` must be in the format `gs://bucket/path/to/object`. The
	// filter configuration file must contain a list of resource paths separated by
	// newline characters (\n or \r\n). Each resource path must be in the format
	// "/studies/{studyUID}[/series/{seriesUID}[/instances/{instanceUID}]]" The
	// Cloud Healthcare API service account must have the
	// `roles/storage.objectViewer` Cloud IAM role for this Cloud Storage location.
	ResourcePathsGcsUri string `json:"resourcePathsGcsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResourcePathsGcsUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResourcePathsGcsUri") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DicomFilterConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DicomFilterConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DicomStore: Represents a DICOM store.
type DicomStore struct {
	// Labels: User-supplied key-value pairs used to organize DICOM stores. Label
	// keys must be between 1 and 63 characters long, have a UTF-8 encoding of
	// maximum 128 bytes, and must conform to the following PCRE regular
	// expression: \p{Ll}\p{Lo}{0,62} Label values are optional, must be between 1
	// and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
	// conform to the following PCRE regular expression:
	// [\p{Ll}\p{Lo}\p{N}_-]{0,63} No more than 64 labels can be associated with a
	// given store.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. Resource name of the DICOM store, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomSto
	// res/{dicom_store_id}`.
	Name string `json:"name,omitempty"`
	// NotificationConfig: Notification destination for new DICOM instances.
	// Supplied by the client.
	NotificationConfig *NotificationConfig `json:"notificationConfig,omitempty"`
	// StreamConfigs: Optional. A list of streaming configs used to configure the
	// destination of streaming exports for every DICOM instance insertion in this
	// DICOM store. After a new config is added to `stream_configs`, DICOM instance
	// insertions are streamed to the new destination. When a config is removed
	// from `stream_configs`, the server stops streaming to that destination. Each
	// config must contain a unique destination.
	StreamConfigs []*GoogleCloudHealthcareV1beta1DicomStreamConfig `json:"streamConfigs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Labels") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Labels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DicomStore) MarshalJSON() ([]byte, error) {
	type NoMethod DicomStore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DicomStoreMetrics: DicomStoreMetrics contains metrics describing a DICOM
// store.
type DicomStoreMetrics struct {
	// BlobStorageSizeBytes: Total blob storage bytes for all instances in the
	// store.
	BlobStorageSizeBytes int64 `json:"blobStorageSizeBytes,omitempty,string"`
	// InstanceCount: Number of instances in the store.
	InstanceCount int64 `json:"instanceCount,omitempty,string"`
	// Name: Resource name of the DICOM store, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomSto
	// res/{dicom_store_id}`.
	Name string `json:"name,omitempty"`
	// SeriesCount: Number of series in the store.
	SeriesCount int64 `json:"seriesCount,omitempty,string"`
	// StructuredStorageSizeBytes: Total structured storage bytes for all instances
	// in the store.
	StructuredStorageSizeBytes int64 `json:"structuredStorageSizeBytes,omitempty,string"`
	// StudyCount: Number of studies in the store.
	StudyCount int64 `json:"studyCount,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BlobStorageSizeBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlobStorageSizeBytes") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DicomStoreMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod DicomStoreMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DicomTagConfig: Specifies the parameters needed for the de-identification of
// DICOM stores.
type DicomTagConfig struct {
	// Actions: Specifies custom tag selections and `Actions` to apply to them.
	// Overrides `options` and `profile`. Conflicting `Actions` are applied in the
	// order given.
	Actions []*Action `json:"actions,omitempty"`
	// Options: Specifies additional options to apply, overriding the base
	// `profile`.
	Options *Options `json:"options,omitempty"`
	// ProfileType: Base profile type for handling DICOM tags.
	//
	// Possible values:
	//   "PROFILE_TYPE_UNSPECIFIED" - No profile provided. Same as
	// `ATTRIBUTE_CONFIDENTIALITY_BASIC_PROFILE`.
	//   "MINIMAL_KEEP_LIST_PROFILE" - Keep only the tags required to produce valid
	// DICOM objects.
	//   "ATTRIBUTE_CONFIDENTIALITY_BASIC_PROFILE" - Remove tags based on DICOM
	// Standard's [Attribute Confidentiality Basic Profile (DICOM Standard Edition
	// 2018e)](http://dicom.nema.org/medical/dicom/2018e/output/chtml/part15/chapter
	// _E.html).
	//   "KEEP_ALL_PROFILE" - Keep all tags.
	//   "DEIDENTIFY_TAG_CONTENTS" - Inspect tag contents and replace sensitive
	// text. The process can be configured using the TextConfig. Applies to all
	// tags with the following [Value Representations]
	// (http://dicom.nema.org/medical/dicom/2018e/output/chtml/part05/sect_6.2.html#table_6.2-1):
	// AE, LO, LT, PN, SH, ST, UC, UT, DA, DT, AS
	ProfileType string `json:"profileType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Actions") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Actions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DicomTagConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DicomTagConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// EncryptionSpec: Represents a customer-managed encryption key spec that can
// be applied to a resource.
type EncryptionSpec struct {
	// KmsKeyName: Required. The resource name of customer-managed encryption key
	// that is used to secure a resource and its sub-resources. Only the key in the
	// same location as this dataset is allowed to be used for encryption. Format
	// is:
	// `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{key}`
	KmsKeyName string `json:"kmsKeyName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KmsKeyName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsKeyName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EncryptionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod EncryptionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Entity: The candidate entities that an entity mention could link to.
type Entity struct {
	// EntityId: entity_id is a first class field entity_id uniquely identifies
	// this concept and its meta-vocabulary. For example, "UMLS/C0000970".
	EntityId string `json:"entityId,omitempty"`
	// PreferredTerm: preferred_term is the preferred term for this concept. For
	// example, "Acetaminophen". For ad hoc entities formed by normalization, this
	// is the most popular unnormalized string.
	PreferredTerm string `json:"preferredTerm,omitempty"`
	// VocabularyCodes: Vocabulary codes are first-class fields and differentiated
	// from the concept unique identifier (entity_id). vocabulary_codes contains
	// the representation of this concept in particular vocabularies, such as
	// ICD-10, SNOMED-CT and RxNORM. These are prefixed by the name of the
	// vocabulary, followed by the unique code within that vocabulary. For example,
	// "RXNORM/A10334543".
	VocabularyCodes []string `json:"vocabularyCodes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Entity) MarshalJSON() ([]byte, error) {
	type NoMethod Entity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EntityMention: An entity mention in the document.
type EntityMention struct {
	// AdditionalInfo: Additional information about the entity mention. For
	// example, for an entity mention of type `DATE` this can be its more specific
	// date types from the following list: `ADMISSION_DATE`, `CONSULTATION_DATE`,
	// `DISCHARGE_DATE`, `SERVICE_DATE`, `VISIT_DATE`, `DIAGNOSIS_DATE`,
	// `MED_STARTED_DATE`, `MED_ENDED_DATE`, `NOTE_DATE`, `PROCEDURE_DATE`,
	// `RADIATION_STARTED_DATE`, `RADIATION_ENDED_DATE`, `STAGE_DATE`
	AdditionalInfo []*Feature `json:"additionalInfo,omitempty"`
	// CertaintyAssessment: The certainty assessment of the entity mention. Its
	// value is one of: LIKELY, SOMEWHAT_LIKELY, UNCERTAIN, SOMEWHAT_UNLIKELY,
	// UNLIKELY, CONDITIONAL
	CertaintyAssessment *Feature `json:"certaintyAssessment,omitempty"`
	// Confidence: The model's confidence in this entity mention annotation. A
	// number between 0 and 1.
	Confidence float64 `json:"confidence,omitempty"`
	// LinkedEntities: linked_entities are candidate ontological concepts that this
	// entity mention may refer to. They are sorted by decreasing confidence.
	LinkedEntities []*LinkedEntity `json:"linkedEntities,omitempty"`
	// MentionId: mention_id uniquely identifies each entity mention in a single
	// response.
	MentionId string `json:"mentionId,omitempty"`
	// Subject: The subject this entity mention relates to. Its value is one of:
	// PATIENT, FAMILY_MEMBER, OTHER
	Subject *Feature `json:"subject,omitempty"`
	// TemporalAssessment: How this entity mention relates to the subject
	// temporally. Its value is one of: CURRENT, CLINICAL_HISTORY, FAMILY_HISTORY,
	// UPCOMING, ALLERGY
	TemporalAssessment *Feature `json:"temporalAssessment,omitempty"`
	// Text: text is the location of the entity mention in the document.
	Text *TextSpan `json:"text,omitempty"`
	// Type: The semantic type of the entity: UNKNOWN_ENTITY_TYPE, ALONE,
	// ANATOMICAL_STRUCTURE, ASSISTED_LIVING, BF_RESULT, BM_RESULT, BM_UNIT,
	// BM_VALUE, BODY_FUNCTION, BODY_MEASUREMENT, COMPLIANT, DOESNOT_FOLLOWUP,
	// FAMILY, FOLLOWSUP, LABORATORY_DATA, LAB_RESULT, LAB_UNIT, LAB_VALUE,
	// MEDICAL_DEVICE, MEDICINE, MED_DOSE, MED_DURATION, MED_FORM, MED_FREQUENCY,
	// MED_ROUTE, MED_STATUS, MED_STRENGTH, MED_TOTALDOSE, MED_UNIT, NON_COMPLIANT,
	// OTHER_LIVINGSTATUS, PROBLEM, PROCEDURE, PROCEDURE_RESULT, PROC_METHOD,
	// REASON_FOR_NONCOMPLIANCE, SEVERITY, SUBSTANCE_ABUSE, UNCLEAR_FOLLOWUP.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalInfo") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EntityMention) MarshalJSON() ([]byte, error) {
	type NoMethod EntityMention
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *EntityMention) UnmarshalJSON(data []byte) error {
	type NoMethod EntityMention
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// EntityMentionRelationship: Defines directed relationship from one entity
// mention to another.
type EntityMentionRelationship struct {
	// Confidence: The model's confidence in this annotation. A number between 0
	// and 1.
	Confidence float64 `json:"confidence,omitempty"`
	// ObjectId: object_id is the id of the object entity mention.
	ObjectId string `json:"objectId,omitempty"`
	// SubjectId: subject_id is the id of the subject entity mention.
	SubjectId string `json:"subjectId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EntityMentionRelationship) MarshalJSON() ([]byte, error) {
	type NoMethod EntityMentionRelationship
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *EntityMentionRelationship) UnmarshalJSON(data []byte) error {
	type NoMethod EntityMentionRelationship
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// EvaluateAnnotationStoreRequest: Request to evaluate an Annotation store
// against a ground truth [Annotation store].
type EvaluateAnnotationStoreRequest struct {
	// BigqueryDestination: The BigQuery table where the server writes the output.
	// BigQueryDestination requires the `roles/bigquery.dataEditor` and
	// `roles/bigquery.jobUser` Cloud IAM roles.
	BigqueryDestination *GoogleCloudHealthcareV1beta1AnnotationBigQueryDestination `json:"bigqueryDestination,omitempty"`
	// EvalInfoTypeMapping: Optional. InfoType mapping for `eval_store`. Different
	// resources can map to the same infoType. For example, `PERSON_NAME`,
	// `PERSON`, `NAME`, and `HUMAN` are different. To map all of these into a
	// single infoType (such as `PERSON_NAME`), specify the following mapping: ```
	// info_type_mapping["PERSON"] = "PERSON_NAME" info_type_mapping["NAME"] =
	// "PERSON_NAME" info_type_mapping["HUMAN"] = "PERSON_NAME" ``` Unmentioned
	// infoTypes, such as `DATE`, are treated as identity mapping. For example: ```
	// info_type_mapping["DATE"] = "DATE" ``` InfoTypes are case-insensitive.
	EvalInfoTypeMapping map[string]string `json:"evalInfoTypeMapping,omitempty"`
	// GoldenInfoTypeMapping: Optional. Similar to `eval_info_type_mapping`,
	// infoType mapping for `golden_store`.
	GoldenInfoTypeMapping map[string]string `json:"goldenInfoTypeMapping,omitempty"`
	// GoldenStore: Required. The Annotation store to use as ground truth, in the
	// format of
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/annotati
	// onStores/{annotation_store_id}`.
	GoldenStore    string          `json:"goldenStore,omitempty"`
	InfoTypeConfig *InfoTypeConfig `json:"infoTypeConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigqueryDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigqueryDestination") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EvaluateAnnotationStoreRequest) MarshalJSON() ([]byte, error) {
	type NoMethod EvaluateAnnotationStoreRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EvaluateAnnotationStoreResponse: Response for successful Annotation store
// evaluation operations. This structure is included in the response upon
// operation completion.
type EvaluateAnnotationStoreResponse struct {
}

// EvaluateUserConsentsRequest: Evaluate a user's Consents for all matching
// User data mappings. Note: User data mappings are indexed asynchronously,
// causing slight delays between the time mappings are created or updated and
// when they are included in EvaluateUserConsents results.
type EvaluateUserConsentsRequest struct {
	// ConsentList: Optional. Specific Consents to evaluate the access request
	// against. These Consents must have the same `user_id` as the User data
	// mappings being evalauted, must exist in the current `consent_store`, and
	// must have a `state` of either `ACTIVE` or `DRAFT`. A maximum of 100 Consents
	// can be provided here. If unspecified, all `ACTIVE` unexpired Consents in the
	// current `consent_store` will be evaluated.
	ConsentList *ConsentList `json:"consentList,omitempty"`
	// PageSize: Optional. Limit on the number of User data mappings to return in a
	// single response. If not specified, 100 is used. May not be larger than 1000.
	PageSize int64 `json:"pageSize,omitempty"`
	// PageToken: Optional. Token to retrieve the next page of results, or empty to
	// get the first page.
	PageToken string `json:"pageToken,omitempty"`
	// RequestAttributes: Required. The values of request attributes associated
	// with this access request.
	RequestAttributes map[string]string `json:"requestAttributes,omitempty"`
	// ResourceAttributes: Optional. The values of resource attributes associated
	// with the resources being requested. If no values are specified, then all
	// resources are queried.
	ResourceAttributes map[string]string `json:"resourceAttributes,omitempty"`
	// ResponseView: Optional. The view for EvaluateUserConsentsResponse. If
	// unspecified, defaults to `BASIC` and returns `consented` as `TRUE` or
	// `FALSE`.
	//
	// Possible values:
	//   "RESPONSE_VIEW_UNSPECIFIED" - No response view specified. The API will
	// default to the BASIC view.
	//   "BASIC" - Only the `data_id` and `consented` fields are populated in the
	// response.
	//   "FULL" - All fields within the response are populated. When set to `FULL`,
	// all `ACTIVE` Consents are evaluated even if a matching policy is found
	// during evaluation.
	ResponseView string `json:"responseView,omitempty"`
	// UserId: Required. User ID to evaluate consents for.
	UserId string `json:"userId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConsentList") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsentList") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EvaluateUserConsentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod EvaluateUserConsentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type EvaluateUserConsentsResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list. This token is valid for 72 hours after it
	// is created.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Results: The consent evaluation result for each `data_id`.
	Results []*Result `json:"results,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EvaluateUserConsentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod EvaluateUserConsentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExplainDataAccessConsentInfo: The enforcing consent's metadata.
type ExplainDataAccessConsentInfo struct {
	// CascadeOrigins: The compartment base resources that matched a cascading
	// policy. Each resource has the following format:
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirStor
	// es/{fhir_store_id}/fhir/{resource_type}/{resource_id}`
	CascadeOrigins []string `json:"cascadeOrigins,omitempty"`
	// ConsentResource: The resource name of this consent resource, in the format:
	// `projects/{project_id}/locations/{location}/datasets/{dataset_id}/fhirStores/
	// {fhir_store_id}/fhir/Consent/{resource_id}`.
	ConsentResource string `json:"consentResource,omitempty"`
	// EnforcementTime: Last enforcement timestamp of this consent resource.
	EnforcementTime string `json:"enforcementTime,omitempty"`
	// MatchingAccessorScopes: A list of all the matching accessor scopes of this
	// consent policy that enforced ExplainDataAccessConsentScope.accessor_scope.
	MatchingAccessorScopes []*ConsentAccessorScope `json:"matchingAccessorScopes,omitempty"`
	// PatientConsentOwner: The patient owning the consent (only applicable for
	// patient consents), in the format:
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirStor
	// es/{fhir_store_id}/fhir/Patient/{patient_id}`
	PatientConsentOwner string `json:"patientConsentOwner,omitempty"`
	// Type: The policy type of consent resource (e.g. PATIENT, ADMIN).
	//
	// Possible values:
	//   "CONSENT_POLICY_TYPE_UNSPECIFIED" - Unspecified policy type.
	//   "CONSENT_POLICY_TYPE_PATIENT" - Consent represent a patient consent.
	//   "CONSENT_POLICY_TYPE_ADMIN" - Consent represent an admin consent.
	Type string `json:"type,omitempty"`
	// Variants: The consent's variant combinations. A single consent may have
	// multiple variants.
	//
	// Possible values:
	//   "CONSENT_VARIANT_UNSPECIFIED" - Consent variant unspecified.
	//   "CONSENT_VARIANT_STANDARD" - Consent is a standard patient or admin
	// consent.
	//   "CONSENT_VARIANT_CASCADE" - Consent is a cascading consent.
	Variants []string `json:"variants,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CascadeOrigins") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CascadeOrigins") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExplainDataAccessConsentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ExplainDataAccessConsentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExplainDataAccessConsentScope: A single consent scope that provides info on
// who has access to the requested resource scope for a particular purpose and
// environment, enforced by which consent.
type ExplainDataAccessConsentScope struct {
	// AccessorScope: The accessor scope that describes who can access, for what
	// purpose, and in which environment.
	AccessorScope *ConsentAccessorScope `json:"accessorScope,omitempty"`
	// Decision: Whether the current consent scope is permitted or denied access on
	// the requested resource.
	//
	// Possible values:
	//   "CONSENT_DECISION_TYPE_UNSPECIFIED" - Unspecified consent decision type.
	//   "CONSENT_DECISION_TYPE_PERMIT" - Consent permitted access.
	//   "CONSENT_DECISION_TYPE_DENY" - Consent denied access.
	Decision string `json:"decision,omitempty"`
	// EnforcingConsents: Metadata of the consent resources that enforce the
	// consent scope's access.
	EnforcingConsents []*ExplainDataAccessConsentInfo `json:"enforcingConsents,omitempty"`
	// Exceptions: Other consent scopes that created exceptions within this scope.
	Exceptions []*ExplainDataAccessConsentScope `json:"exceptions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessorScope") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessorScope") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExplainDataAccessConsentScope) MarshalJSON() ([]byte, error) {
	type NoMethod ExplainDataAccessConsentScope
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExplainDataAccessResponse: List of consent scopes that are applicable to the
// explained access on a given resource.
type ExplainDataAccessResponse struct {
	// ConsentScopes: List of applicable consent scopes. Sorted in order of actor
	// such that scopes belonging to the same actor will be adjacent to each other
	// in the list.
	ConsentScopes []*ExplainDataAccessConsentScope `json:"consentScopes,omitempty"`
	// Warning: Warnings associated with this response. It inform user with
	// exceeded scope limit errors.
	Warning string `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConsentScopes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsentScopes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExplainDataAccessResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ExplainDataAccessResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExportAnnotationsRequest: Request to export Annotations. The export
// operation is not atomic. If a failure occurs, any annotations already
// exported are not removed.
type ExportAnnotationsRequest struct {
	// BigqueryDestination: The BigQuery output destination, which requires two IAM
	// roles: `roles/bigquery.dataEditor` and `roles/bigquery.jobUser`.
	BigqueryDestination *GoogleCloudHealthcareV1beta1AnnotationBigQueryDestination `json:"bigqueryDestination,omitempty"`
	// GcsDestination: The Cloud Storage destination, which requires the
	// `roles/storage.objectAdmin` Cloud IAM role.
	GcsDestination *GoogleCloudHealthcareV1beta1AnnotationGcsDestination `json:"gcsDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigqueryDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigqueryDestination") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExportAnnotationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ExportAnnotationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExportAnnotationsResponse: Response for successful annotation export
// operations. This structure is included in response upon operation
// completion.
type ExportAnnotationsResponse struct {
}

// ExportDicomDataRequest: Exports data from the specified DICOM store. If a
// given resource, such as a DICOM object with the same SOPInstance UID,
// already exists in the output, it is overwritten with the version in the
// source dataset. Exported DICOM data persists when the DICOM store from which
// it was exported is deleted.
type ExportDicomDataRequest struct {
	// BigqueryDestination: The BigQuery output destination. You can only export to
	// a BigQuery dataset that's in the same project as the DICOM store you're
	// exporting from. The Cloud Healthcare Service Agent requires two IAM roles on
	// the BigQuery location: `roles/bigquery.dataEditor` and
	// `roles/bigquery.jobUser`.
	BigqueryDestination *GoogleCloudHealthcareV1beta1DicomBigQueryDestination `json:"bigqueryDestination,omitempty"`
	// FilterConfig: Specifies the filter configuration.
	FilterConfig *DicomFilterConfig `json:"filterConfig,omitempty"`
	// GcsDestination: The Cloud Storage output destination. The Cloud Healthcare
	// Service Agent requires the `roles/storage.objectAdmin` Cloud IAM roles on
	// the Cloud Storage location.
	GcsDestination *GoogleCloudHealthcareV1beta1DicomGcsDestination `json:"gcsDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigqueryDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigqueryDestination") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExportDicomDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ExportDicomDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExportDicomDataResponse: Returns additional information in regards to a
// completed DICOM store export.
type ExportDicomDataResponse struct {
}

// ExportMessagesRequest: Request to schedule an export.
type ExportMessagesRequest struct {
	// EndTime: The end of the range in `send_time` (MSH.7,
	// https://www.hl7.org/documentcenter/public_temp_2E58C1F9-1C23-BA17-0C6126475344DA9D/wg/conf/HL7MSH.htm)
	// to process. If not specified, the time when the export is scheduled is used.
	// This value has to come after the `start_time` defined below. Only messages
	// whose `send_time` lies in the range `start_time` (inclusive) to `end_time`
	// (exclusive) are exported.
	EndTime string `json:"endTime,omitempty"`
	// Filter: Restricts messages exported to those matching a filter, only
	// applicable to PubsubDestination and GcsDestination. The following syntax is
	// available: * A string field value can be written as text inside quotation
	// marks, for example "query text". The only valid relational operation for
	// text fields is equality (`=`), where text is searched within the field,
	// rather than having the field be equal to the text. For example, "Comment =
	// great" returns messages with `great` in the comment field. * A number field
	// value can be written as an integer, a decimal, or an exponential. The valid
	// relational operators for number fields are the equality operator (`=`),
	// along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note
	// that there is no inequality (`!=`) operator. You can prepend the `NOT`
	// operator to an expression to negate it. * A date field value must be written
	// in the `yyyy-mm-dd` format. Fields with date and time use the RFC3339 time
	// format. Leading zeros are required for one-digit months and days. The valid
	// relational operators for date fields are the equality operator (`=`) , along
	// with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that
	// there is no inequality (`!=`) operator. You can prepend the `NOT` operator
	// to an expression to negate it. * Multiple field query expressions can be
	// combined in one query by adding `AND` or `OR` operators between the
	// expressions. If a boolean operator appears within a quoted string, it is not
	// treated as special, and is just another part of the character string to be
	// matched. You can prepend the `NOT` operator to an expression to negate it.
	// The following fields and functions are available for filtering: *
	// `message_type`, from the MSH-9.1 field. For example, `NOT message_type =
	// "ADT". * `send_date` or `sendDate`, the YYYY-MM-DD date the message was
	// sent in the dataset's time_zone, from the MSH-7 segment. For example,
	// `send_date < "2017-01-02". * `send_time`, the timestamp when the message
	// was sent, using the RFC3339 time format for comparisons, from the MSH-7
	// segment. For example, `send_time < "2017-01-02T00:00:00-05:00". *
	// `create_time`, the timestamp when the message was created in the HL7v2
	// store. Use the RFC3339 time format for comparisons. For example,
	// `create_time < "2017-01-02T00:00:00-05:00". * `send_facility`, the care
	// center that the message came from, from the MSH-4 segment. For example,
	// `send_facility = "ABC". Note: The filter will be applied to every message
	// in the HL7v2 store whose `send_time` lies in the range defined by the
	// `start_time` and the `end_time`. Even if the filter only matches a small set
	// of messages, the export operation can still take a long time to finish when
	// a lot of messages are between the specified `start_time` and `end_time`
	// range.
	Filter string `json:"filter,omitempty"`
	// GcsDestination: Export to a Cloud Storage destination.
	GcsDestination *GcsDestination `json:"gcsDestination,omitempty"`
	// PubsubDestination: Export messages to a Pub/Sub topic.
	PubsubDestination *PubsubDestination `json:"pubsubDestination,omitempty"`
	// StartTime: The start of the range in `send_time` (MSH.7,
	// https://www.hl7.org/documentcenter/public_temp_2E58C1F9-1C23-BA17-0C6126475344DA9D/wg/conf/HL7MSH.htm)
	// to process. If not specified, the UNIX epoch (1970-01-01T00:00:00Z) is used.
	// This value has to come before the `end_time` defined below. Only messages
	// whose `send_time` lies in the range `start_time` (inclusive) to `end_time`
	// (exclusive) are exported.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExportMessagesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ExportMessagesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExportMessagesResponse: Final response for the export operation. This
// structure is included in the response to describe the detailed outcome.
type ExportMessagesResponse struct {
}

// ExportResourcesHistoryRequest: Request to export the history of resources.
type ExportResourcesHistoryRequest struct {
	// Since: If provided, only resources versions updated after this time are
	// exported. The time uses the format YYYY-MM-DDThh:mm:ss.sss+zz:zz. For
	// example, `2015-02-07T13:28:17.239+02:00` or `2017-01-01T00:00:00Z`. The time
	// must be specified to the second and include a time zone.
	Since string `json:"_since,omitempty"`
	// Type: String of comma-delimited FHIR resource types. If provided, only
	// resources of the specified resource type(s) are exported.
	Type string `json:"_type,omitempty"`
	// GcsDestination: The Cloud Storage output destination. The Healthcare Service
	// Agent account requires the `roles/storage.objectAdmin` role on the Cloud
	// Storage location. The exported outputs are organized by FHIR resource types.
	// The server creates one or more objects per resource type depending on the
	// volume of the resources exported. When there is only one object per resource
	// type, the object name is in the form of
	// `{operation_id})_history_{resource_type}`. When there are multiple objects
	// for a given resource type, the object names are in the form of
	// `{operation_id}_history_{resource_type}-{index}-of-{total}`. Each object
	// contains newline delimited JSON, and each line is a FHIR history bundle
	// containing the history for a single resource.
	GcsDestination *GoogleCloudHealthcareV1beta1FhirGcsDestination `json:"gcsDestination,omitempty"`
	// MaxResourceVersions: If provided and non-zero, places a limit on the number
	// of resource versions that are returned for a given resource. For example, if
	// the limit is `100` and a resource has over 100 versions, only the 100 most
	// recent versions will be returned. Must be positive.
	MaxResourceVersions int64 `json:"maxResourceVersions,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Since") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Since") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExportResourcesHistoryRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ExportResourcesHistoryRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExportResourcesRequest: Request to export resources.
type ExportResourcesRequest struct {
	// Since: If provided, only resources updated after this time are exported. The
	// time uses the format YYYY-MM-DDThh:mm:ss.sss+zz:zz. For example,
	// `2015-02-07T13:28:17.239+02:00` or `2017-01-01T00:00:00Z`. The time must be
	// specified to the second and include a time zone.
	Since string `json:"_since,omitempty"`
	// Type: String of comma-delimited FHIR resource types. If provided, only
	// resources of the specified resource type(s) are exported.
	Type string `json:"_type,omitempty"`
	// BigqueryDestination: The BigQuery output destination. The Cloud Healthcare
	// Service Agent requires two IAM roles on the BigQuery location:
	// `roles/bigquery.dataEditor` and `roles/bigquery.jobUser`. The output is one
	// BigQuery table per resource type. Unlike when setting `BigQueryDestination`
	// for `StreamConfig`, `ExportResources` does not create BigQuery views.
	BigqueryDestination *GoogleCloudHealthcareV1beta1FhirBigQueryDestination `json:"bigqueryDestination,omitempty"`
	// GcsDestination: The Cloud Storage output destination. The Cloud Healthcare
	// Service Agent requires the `roles/storage.objectAdmin` Cloud IAM roles on
	// the Cloud Storage location. The exported outputs are organized by FHIR
	// resource types. The server creates one object per resource type. Each object
	// contains newline delimited JSON, and each line is a FHIR resource.
	GcsDestination *GoogleCloudHealthcareV1beta1FhirGcsDestination `json:"gcsDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Since") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Since") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExportResourcesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ExportResourcesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Expr: Represents a textual expression in the Common Expression Language
// (CEL) syntax. CEL is a C-like expression language. The syntax and semantics
// of CEL are documented at https://github.com/google/cel-spec. Example
// (Comparison): title: "Summary size limit" description: "Determines if a
// summary is less than 100 chars" expression: "document.summary.size() < 100"
// Example (Equality): title: "Requestor is owner" description: "Determines if
// requestor is the document owner" expression: "document.owner ==
// request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly visible"
// expression: "document.type != 'private' && document.type != 'internal'"
// Example (Data Manipulation): title: "Notification string" description:
// "Create a notification string with a timestamp." expression: "'New message
// received at ' + string(document.create_time)" The exact variables and
// functions that may be referenced within an expression are determined by the
// service that evaluates it. See the service documentation for additional
// information.
type Expr struct {
	// Description: Optional. Description of the expression. This is a longer text
	// which describes the expression, e.g. when hovered over it in a UI.
	Description string `json:"description,omitempty"`
	// Expression: Textual representation of an expression in Common Expression
	// Language syntax.
	Expression string `json:"expression,omitempty"`
	// Location: Optional. String indicating the location of the expression for
	// error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`
	// Title: Optional. Title for the expression, i.e. a short string describing
	// its purpose. This can be used e.g. in UIs which allow to enter the
	// expression.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Expr) MarshalJSON() ([]byte, error) {
	type NoMethod Expr
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Feature: A feature of an entity mention.
type Feature struct {
	// Confidence: The model's confidence in this feature annotation. A number
	// between 0 and 1.
	Confidence float64 `json:"confidence,omitempty"`
	// Value: The value of this feature annotation. Its range depends on the type
	// of the feature.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Feature) MarshalJSON() ([]byte, error) {
	type NoMethod Feature
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *Feature) UnmarshalJSON(data []byte) error {
	type NoMethod Feature
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// FhirConfig: Specifies how to handle de-identification of a FHIR store.
type FhirConfig struct {
	// DefaultKeepExtensions: The behaviour for handling FHIR extensions that
	// aren't otherwise specified for de-identification. If true, all extensions
	// are preserved during de-identification by default. If false or unspecified,
	// all extensions are removed during de-identification by default.
	DefaultKeepExtensions bool `json:"defaultKeepExtensions,omitempty"`
	// FieldMetadataList: Specifies FHIR paths to match and how to transform them.
	// Any field that is not matched by a FieldMetadata is passed through to the
	// output dataset unmodified. All extensions will be processed according to
	// `default_keep_extensions`. If a field can be matched by more than one
	// FieldMetadata, the first FieldMetadata.Action is applied.
	FieldMetadataList []*FieldMetadata `json:"fieldMetadataList,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultKeepExtensions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultKeepExtensions") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FhirConfig) MarshalJSON() ([]byte, error) {
	type NoMethod FhirConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FhirFieldConfig: Specifies how to handle the de-identification of a FHIR
// store.
type FhirFieldConfig struct {
	// FieldMetadataList: Specifies FHIR paths to match and how to transform them.
	// Any field that is not matched by a FieldMetadata `action` is passed through
	// to the output dataset unmodified. All extensions will be processed according
	// to keep_extensions. If a field can be matched by more than one FieldMetadata
	// `action`, the first `action` option is applied. Overrides options and the
	// union field `profile` in FhirFieldConfig.
	FieldMetadataList []*GoogleCloudHealthcareV1beta1DeidentifyFieldMetadata `json:"fieldMetadataList,omitempty"`
	// Options: Specifies additional options, overriding the base ProfileType.
	Options *GoogleCloudHealthcareV1beta1DeidentifyOptions `json:"options,omitempty"`
	// ProfileType: Base profile type for handling FHIR fields.
	//
	// Possible values:
	//   "PROFILE_TYPE_UNSPECIFIED" - No profile provided. Same as `BASIC`.
	//   "KEEP_ALL" - Keep all fields.
	//   "BASIC" - Transforms known [HIPAA
	// 18](https://www.hhs.gov/hipaa/for-professionals/privacy/special-topics/de-ide
	// ntification/index.html#standard) fields and cleans known unstructured text
	// fields.
	//   "CLEAN_ALL" - Cleans all supported tags. Applies to types: Code, Date,
	// DateTime, Decimal, HumanName, Id, LanguageCode, Markdown, Oid, String, Uri,
	// Uuid, Xhtml.
	ProfileType string `json:"profileType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FieldMetadataList") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FieldMetadataList") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FhirFieldConfig) MarshalJSON() ([]byte, error) {
	type NoMethod FhirFieldConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FhirFilter: Filter configuration.
type FhirFilter struct {
	// Resources: List of resources to include in the output. If this list is empty
	// or not specified, all resources are included in the output.
	Resources *Resources `json:"resources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Resources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Resources") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FhirFilter) MarshalJSON() ([]byte, error) {
	type NoMethod FhirFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FhirNotificationConfig: Contains the configuration for FHIR notifications.
type FhirNotificationConfig struct {
	// PubsubTopic: The Pub/Sub (https://cloud.google.com/pubsub/docs/) topic that
	// notifications of changes are published on. Supplied by the client. The
	// notification is a `PubsubMessage` with the following fields: *
	// `PubsubMessage.Data` contains the resource name. * `PubsubMessage.MessageId`
	// is the ID of this notification. It is guaranteed to be unique within the
	// topic. * `PubsubMessage.PublishTime` is the time when the message was
	// published. Note that notifications are only sent if the topic is non-empty.
	// Topic names (https://cloud.google.com/pubsub/docs/overview#names) must be
	// scoped to a project. The Cloud Healthcare API service account,
	// service-@gcp-sa-healthcare.iam.gserviceaccount.com, must have publisher
	// permissions on the given Pub/Sub topic. Not having adequate permissions
	// causes the calls that send notifications to fail
	// (https://cloud.google.com/healthcare-api/docs/permissions-healthcare-api-gcp-products#dicom_fhir_and_hl7v2_store_cloud_pubsub_permissions).
	// If a notification can't be published to Pub/Sub, errors are logged to Cloud
	// Logging. For more information, see Viewing error logs in Cloud Logging
	// (https://cloud.google.com/healthcare-api/docs/how-tos/logging).
	PubsubTopic string `json:"pubsubTopic,omitempty"`
	// SendFullResource: Whether to send full FHIR resource to this Pub/Sub topic
	// for Create and Update operation. The default value is false. Note that
	// setting this to true does not guarantee that all resources will be sent in
	// the format of full FHIR resource. When a resource change is too large or
	// during heavy traffic, only the resource name will be sent. Clients should
	// always check the "payloadType" label from a Pub/Sub message to determine
	// whether it needs to fetch the full resource as a separate operation.
	SendFullResource bool `json:"sendFullResource,omitempty"`
	// SendPreviousResourceOnDelete: Whether to send full FHIR resource to this
	// Pub/Sub topic for deleting FHIR resource. The default value is false. Note
	// that setting this to true does not guarantee that all previous resources
	// will be sent in the format of full FHIR resource. When a resource change is
	// too large or during heavy traffic, only the resource name will be sent.
	// Clients should always check the "payloadType" label from a Pub/Sub message
	// to determine whether it needs to fetch the full previous resource as a
	// separate operation.
	SendPreviousResourceOnDelete bool `json:"sendPreviousResourceOnDelete,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PubsubTopic") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PubsubTopic") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FhirNotificationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod FhirNotificationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FhirOutput: Details about the FHIR store to write the output to.
type FhirOutput struct {
	// FhirStore: Name of the output FHIR store, which must already exist. You must
	// grant the healthcare.fhirResources.update permission on the destination
	// store to your project's **Cloud Healthcare Service Agent** service account
	// (https://cloud.google.com/healthcare/docs/how-tos/permissions-healthcare-api-gcp-products#the_cloud_healthcare_service_agent).
	// The destination store must set enableUpdateCreate to true. The destination
	// store must use FHIR version R4. Writing these resources will consume FHIR
	// operations quota from the project containing the source data. De-identify
	// operation metadata is only generated for DICOM de-identification operations.
	FhirStore string `json:"fhirStore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FhirStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FhirStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FhirOutput) MarshalJSON() ([]byte, error) {
	type NoMethod FhirOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FhirStore: Represents a FHIR store.
type FhirStore struct {
	// ComplexDataTypeReferenceParsing: Enable parsing of references within complex
	// FHIR data types such as Extensions. If this value is set to ENABLED, then
	// features like referential integrity and Bundle reference rewriting apply to
	// all references. If this flag has not been specified the behavior of the FHIR
	// store will not change, references in complex data types will not be parsed.
	// New stores will have this value set to ENABLED after a notification period.
	// Warning: turning on this flag causes processing existing resources to fail
	// if they contain references to non-existent resources.
	//
	// Possible values:
	//   "COMPLEX_DATA_TYPE_REFERENCE_PARSING_UNSPECIFIED" - No parsing behavior
	// specified. This is the same as DISABLED for backwards compatibility.
	//   "DISABLED" - References in complex data types are ignored.
	//   "ENABLED" - References in complex data types are parsed.
	ComplexDataTypeReferenceParsing string `json:"complexDataTypeReferenceParsing,omitempty"`
	// ConsentConfig: Optional. Specifies whether this store has consent
	// enforcement. Not available for DSTU2 FHIR version due to absence of Consent
	// resources.
	ConsentConfig *ConsentConfig `json:"consentConfig,omitempty"`
	// DefaultSearchHandlingStrict: If true, overrides the default search behavior
	// for this FHIR store to `handling=strict` which returns an error for
	// unrecognized search parameters. If false, uses the FHIR specification
	// default `handling=lenient` which ignores unrecognized search parameters. The
	// handling can always be changed from the default on an individual API call by
	// setting the HTTP header `Prefer: handling=strict` or `Prefer:
	// handling=lenient`. Defaults to false.
	DefaultSearchHandlingStrict bool `json:"defaultSearchHandlingStrict,omitempty"`
	// DisableReferentialIntegrity: Immutable. Whether to disable referential
	// integrity in this FHIR store. This field is immutable after FHIR store
	// creation. The default value is false, meaning that the API enforces
	// referential integrity and fails the requests that result in inconsistent
	// state in the FHIR store. When this field is set to true, the API skips
	// referential integrity checks. Consequently, operations that rely on
	// references, such as GetPatientEverything, do not return all the results if
	// broken references exist.
	DisableReferentialIntegrity bool `json:"disableReferentialIntegrity,omitempty"`
	// DisableResourceVersioning: Immutable. Whether to disable resource versioning
	// for this FHIR store. This field can not be changed after the creation of
	// FHIR store. If set to false, all write operations cause historical versions
	// to be recorded automatically. The historical versions can be fetched through
	// the history APIs, but cannot be updated. If set to true, no historical
	// versions are kept. The server sends errors for attempts to read the
	// historical versions. Defaults to false.
	DisableResourceVersioning bool `json:"disableResourceVersioning,omitempty"`
	// EnableHistoryModifications: Optional. Whether to allow ExecuteBundle to
	// accept history bundles, and directly insert and overwrite historical
	// resource versions into the FHIR store. If set to false, using history
	// bundles fails with an error. Defaults to false.
	EnableHistoryModifications bool `json:"enableHistoryModifications,omitempty"`
	// EnableUpdateCreate: Whether this FHIR store has the updateCreate capability
	// (https://www.hl7.org/fhir/capabilitystatement-definitions.html#CapabilityStatement.rest.resource.updateCreate).
	// This determines if the client can use an Update operation to create a new
	// resource with a client-specified ID. If false, all IDs are server-assigned
	// through the Create operation and attempts to update a non-existent resource
	// return errors. It is strongly advised not to include or encode any sensitive
	// data such as patient identifiers in client-specified resource IDs. Those IDs
	// are part of the FHIR resource path recorded in Cloud audit logs and Pub/Sub
	// notifications. Those IDs can also be contained in reference fields within
	// other resources. Defaults to false.
	EnableUpdateCreate bool `json:"enableUpdateCreate,omitempty"`
	// Labels: User-supplied key-value pairs used to organize FHIR stores. Label
	// keys must be between 1 and 63 characters long, have a UTF-8 encoding of
	// maximum 128 bytes, and must conform to the following PCRE regular
	// expression: \p{Ll}\p{Lo}{0,62} Label values are optional, must be between 1
	// and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
	// conform to the following PCRE regular expression:
	// [\p{Ll}\p{Lo}\p{N}_-]{0,63} No more than 64 labels can be associated with a
	// given store.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Output only. Identifier. Resource name of the FHIR store, of the form
	// `projects/{project_id}/locations/{location}/datasets/{dataset_id}/fhirStores/
	// {fhir_store_id}`.
	Name string `json:"name,omitempty"`
	// NotificationConfig: Deprecated. Use `notification_configs` instead. If
	// non-empty, publish all resource modifications of this FHIR store to this
	// destination. The Pub/Sub message attributes contain a map with a string
	// describing the action that has triggered the notification. For example,
	// "action":"CreateResource".
	NotificationConfig *NotificationConfig `json:"notificationConfig,omitempty"`
	// NotificationConfigs: Specifies where and whether to send notifications upon
	// changes to a Fhir store.
	NotificationConfigs []*FhirNotificationConfig `json:"notificationConfigs,omitempty"`
	// SearchConfig: Configuration for how FHIR resources can be searched.
	SearchConfig *SearchConfig `json:"searchConfig,omitempty"`
	// StreamConfigs: A list of streaming configs that configure the destinations
	// of streaming export for every resource mutation in this FHIR store. Each
	// store is allowed to have up to 10 streaming configs. After a new config is
	// added, the next resource mutation is streamed to the new location in
	// addition to the existing ones. When a location is removed from the list, the
	// server stops streaming to that location. Before adding a new config, you
	// must add the required `bigquery.dataEditor`
	// (https://cloud.google.com/bigquery/docs/access-control#bigquery.dataEditor)
	// role to your project's **Cloud Healthcare Service Agent** service account
	// (https://cloud.google.com/iam/docs/service-accounts). Some lag (typically on
	// the order of dozens of seconds) is expected before the results show up in
	// the streaming destination.
	StreamConfigs []*StreamConfig `json:"streamConfigs,omitempty"`
	// ValidationConfig: Configuration for how to validate incoming FHIR resources
	// against configured profiles.
	ValidationConfig *ValidationConfig `json:"validationConfig,omitempty"`
	// Version: Required. Immutable. The FHIR specification version that this FHIR
	// store supports natively. This field is immutable after store creation.
	// Requests are rejected if they contain FHIR resources of a different version.
	// Version is required for every FHIR store.
	//
	// Possible values:
	//   "VERSION_UNSPECIFIED" - VERSION_UNSPECIFIED is treated as STU3 to
	// accommodate the existing FHIR stores.
	//   "DSTU2" - Draft Standard for Trial Use, [Release
	// 2](https://www.hl7.org/fhir/DSTU2)
	//   "STU3" - Standard for Trial Use, [Release
	// 3](https://www.hl7.org/fhir/STU3)
	//   "R4" - [Release 4](https://www.hl7.org/fhir/R4)
	Version string `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g.
	// "ComplexDataTypeReferenceParsing") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ComplexDataTypeReferenceParsing")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FhirStore) MarshalJSON() ([]byte, error) {
	type NoMethod FhirStore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FhirStoreMetric: Count of resources and total storage size by type for a
// given FHIR store.
type FhirStoreMetric struct {
	// Count: The total count of FHIR resources in the store of this resource type.
	Count int64 `json:"count,omitempty,string"`
	// ResourceType: The FHIR resource type this metric applies to.
	ResourceType string `json:"resourceType,omitempty"`
	// StructuredStorageSizeBytes: The total amount of structured storage used by
	// FHIR resources of this resource type in the store.
	StructuredStorageSizeBytes int64 `json:"structuredStorageSizeBytes,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Count") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FhirStoreMetric) MarshalJSON() ([]byte, error) {
	type NoMethod FhirStoreMetric
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FhirStoreMetrics: List of metrics for a given FHIR store.
type FhirStoreMetrics struct {
	// Metrics: List of FhirStoreMetric by resource type.
	Metrics []*FhirStoreMetric `json:"metrics,omitempty"`
	// Name: The resource name of the FHIR store to get metrics for, in the format
	// `projects/{project_id}/datasets/{dataset_id}/fhirStores/{fhir_store_id}`.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Metrics") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metrics") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FhirStoreMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod FhirStoreMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Field: A (sub) field of a type.
type Field struct {
	// MaxOccurs: The maximum number of times this field can be repeated. 0 or -1
	// means unbounded.
	MaxOccurs int64 `json:"maxOccurs,omitempty"`
	// MinOccurs: The minimum number of times this field must be present/repeated.
	MinOccurs int64 `json:"minOccurs,omitempty"`
	// Name: The name of the field. For example, "PID-1" or just "1".
	Name string `json:"name,omitempty"`
	// Table: The HL7v2 table this field refers to. For example, PID-15 (Patient's
	// Primary Language) usually refers to table "0296".
	Table string `json:"table,omitempty"`
	// Type: The type of this field. A Type with this name must be defined in an
	// Hl7TypesConfig.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxOccurs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxOccurs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Field) MarshalJSON() ([]byte, error) {
	type NoMethod Field
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FieldMetadata: Specifies FHIR paths to match, and how to handle
// de-identification of matching fields.
type FieldMetadata struct {
	// Action: Deidentify action for one field.
	//
	// Possible values:
	//   "ACTION_UNSPECIFIED" - No action specified.
	//   "TRANSFORM" - Transform the entire field based on transformations
	// specified in TextConfig. When the specified transformation cannot be applied
	// to a field, RedactConfig is used. For example, a Crypto Hash transformation
	// can't be applied to a FHIR Date field.
	//   "INSPECT_AND_TRANSFORM" - Inspect and transform any found PHI. When
	// `AnnotationConfig` is provided, annotations of PHI will be generated, except
	// for Date and Datetime.
	//   "DO_NOT_TRANSFORM" - Do not transform.
	Action string `json:"action,omitempty"`
	// Paths: List of paths to FHIR fields to redact. Each path is a
	// period-separated list where each component is either a field name or FHIR
	// type name. All types begin with an upper case letter. For example, the
	// resource field "Patient.Address.city", which uses a string type, can be
	// matched by "Patient.Address.String". Path also supports partial matching.
	// For example, "Patient.Address.city" can be matched by "Address.city"
	// (Patient omitted). Partial matching and type matching can be combined. For
	// example, "Patient.Address.city" can be matched by "Address.String". For
	// "choice" types (those defined in the FHIR spec with the form: field[x]), use
	// two separate components. For example, "deceasedAge.unit" is matched by
	// "Deceased.Age.unit". Supported types are: AdministrativeGenderCode,
	// Base64Binary, Boolean, Code, Date, DateTime, Decimal, HumanName, Id,
	// Instant, Integer, LanguageCode, Markdown, Oid, PositiveInt, String,
	// UnsignedInt, Uri, Uuid, Xhtml. The sub-type for HumanName(for example
	// HumanName.given, HumanName.family) can be omitted.
	Paths []string `json:"paths,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FieldMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod FieldMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FilterList: List of infoTypes to be filtered.
type FilterList struct {
	// InfoTypes: These infoTypes are based on after the `eval_info_type_mapping`
	// and `golden_info_type_mapping`.
	InfoTypes []string `json:"infoTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InfoTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InfoTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FilterList) MarshalJSON() ([]byte, error) {
	type NoMethod FilterList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Finding struct {
	// End: Zero-based ending index of the found text, exclusively.
	End int64 `json:"end,omitempty,string"`
	// InfoType: The type of information stored in this text range. For example,
	// HumanName, BirthDate, or Address.
	InfoType string `json:"infoType,omitempty"`
	// Quote: The snippet of the sensitive text. This field is only populated
	// during deidentification if `store_quote` is set to true in DeidentifyConfig.
	Quote string `json:"quote,omitempty"`
	// Start: Zero-based starting index of the found text, inclusively.
	Start int64 `json:"start,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "End") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "End") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Finding) MarshalJSON() ([]byte, error) {
	type NoMethod Finding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GcsDestination: The Cloud Storage output destination. The Cloud Healthcare
// Service Agent requires the `roles/storage.objectAdmin` Cloud IAM roles on
// the Cloud Storage location.
type GcsDestination struct {
	// ContentStructure: The format of the exported HL7v2 message files.
	//
	// Possible values:
	//   "CONTENT_STRUCTURE_UNSPECIFIED" - If the content structure is not
	// specified, the default value `MESSAGE_JSON` will be used.
	//   "MESSAGE_JSON" - Messages are printed using the JSON format returned from
	// the `GetMessage` API. Messages are delimited with newlines.
	ContentStructure string `json:"contentStructure,omitempty"`
	// MessageView: Specifies the parts of the Message resource to include in the
	// export. If not specified, FULL is used.
	//
	// Possible values:
	//   "MESSAGE_VIEW_UNSPECIFIED" - Not specified, equivalent to FULL for
	// getMessage, equivalent to BASIC for listMessages.
	//   "RAW_ONLY" - Server responses include all the message fields except
	// parsed_data, and schematized_data fields.
	//   "PARSED_ONLY" - Server responses include all the message fields except
	// data and schematized_data fields.
	//   "FULL" - Server responses include all the message fields.
	//   "SCHEMATIZED_ONLY" - Server responses include all the message fields
	// except data and parsed_data fields.
	//   "BASIC" - Server responses include only the name field.
	MessageView string `json:"messageView,omitempty"`
	// UriPrefix: URI of an existing Cloud Storage directory where the server
	// writes result files, in the format
	// `gs://{bucket-id}/{path/to/destination/dir}`. If there is no trailing slash,
	// the service appends one when composing the object path.
	UriPrefix string `json:"uriPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentStructure") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentStructure") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GcsSource: Specifies the configuration for importing data from Cloud
// Storage.
type GcsSource struct {
	// Uri: Points to a Cloud Storage URI containing file(s) to import. The URI
	// must be in the following format: `gs://{bucket_id}/{object_id}`. The URI can
	// include wildcards in `object_id` and thus identify multiple files. Supported
	// wildcards: * `*` to match 0 or more non-separator characters * `**` to match
	// 0 or more characters (including separators). Must be used at the end of a
	// path and with no other wildcards in the path. Can also be used with a file
	// extension (such as .ndjson), which imports all files with the extension in
	// the specified directory and its sub-directories. For example,
	// `gs://my-bucket/my-directory/**.ndjson` imports all files with `.ndjson`
	// extensions in `my-directory/` and its sub-directories. * `?` to match 1
	// character Files matching the wildcard are expected to contain content only,
	// no metadata.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudHealthcareV1beta1AnnotationBigQueryDestination: The BigQuery
// table for export.
type GoogleCloudHealthcareV1beta1AnnotationBigQueryDestination struct {
	// Force: Use `write_disposition` instead. If `write_disposition` is specified,
	// this parameter is ignored. force=false is equivalent to
	// write_disposition=WRITE_EMPTY and force=true is equivalent to
	// write_disposition=WRITE_TRUNCATE.
	Force bool `json:"force,omitempty"`
	// SchemaType: Specifies the schema format to export.
	//
	// Possible values:
	//   "SCHEMA_TYPE_UNSPECIFIED" - Same as SIMPLE.
	//   "SIMPLE" - A flatterned version of Annotation.
	SchemaType string `json:"schemaType,omitempty"`
	// TableUri: BigQuery URI to a table, up to 2000 characters long, must be of
	// the form bq://projectId.bqDatasetId.tableId.
	TableUri string `json:"tableUri,omitempty"`
	// WriteDisposition: Determines if existing data in the destination dataset is
	// overwritten, appended to, or not written if the tables contain data. If a
	// write_disposition is specified, the `force` parameter is ignored.
	//
	// Possible values:
	//   "WRITE_DISPOSITION_UNSPECIFIED" - Default behavior is the same as
	// WRITE_EMPTY.
	//   "WRITE_EMPTY" - Only export data if the destination table is empty.
	//   "WRITE_TRUNCATE" - Erase all existing data in a table before writing the
	// instances.
	//   "WRITE_APPEND" - Append data to the existing table.
	WriteDisposition string `json:"writeDisposition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Force") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Force") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudHealthcareV1beta1AnnotationBigQueryDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudHealthcareV1beta1AnnotationBigQueryDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudHealthcareV1beta1AnnotationGcsDestination: The Cloud Storage
// location for export.
type GoogleCloudHealthcareV1beta1AnnotationGcsDestination struct {
	// UriPrefix: The Cloud Storage destination to export to. URI for a Cloud
	// Storage directory where the server writes result files, in the format
	// `gs://{bucket-id}/{path/to/destination/dir}`. If there is no trailing slash,
	// the service appends one when composing the object path. The user is
	// responsible for creating the Cloud Storage bucket referenced in
	// `uri_prefix`.
	UriPrefix string `json:"uriPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UriPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UriPrefix") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudHealthcareV1beta1AnnotationGcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudHealthcareV1beta1AnnotationGcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudHealthcareV1beta1AnnotationGcsSource: Specifies the configuration
// for importing data from Cloud Storage.
type GoogleCloudHealthcareV1beta1AnnotationGcsSource struct {
	// Uri: Points to a Cloud Storage URI containing file(s) with content only. The
	// URI must be in the following format: `gs://{bucket_id}/{object_id}`. The URI
	// can include wildcards in `object_id` and thus identify multiple files.
	// Supported wildcards: '*' to match 0 or more non-separator characters '**' to
	// match 0 or more characters (including separators). Must be used at the end
	// of a path and with no other wildcards in the path. Can also be used with a
	// file extension (such as .dcm), which imports all files with the extension in
	// the specified directory and its sub-directories. For example,
	// `gs://my-bucket/my-directory/**.json` imports all files with .json
	// extensions in `my-directory/` and its sub-directories. '?' to match 1
	// character All other URI formats are invalid. Files matching the wildcard are
	// expected to contain content only, no metadata.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudHealthcareV1beta1AnnotationGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudHealthcareV1beta1AnnotationGcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudHealthcareV1beta1ConsentGcsDestination: The Cloud Storage
// location for export.
type GoogleCloudHealthcareV1beta1ConsentGcsDestination struct {
	// UriPrefix: URI for a Cloud Storage directory where the server writes result
	// files, in the format `gs://{bucket-id}/{path/to/destination/dir}`. If there
	// is no trailing slash, the service appends one when composing the object
	// path. The user is responsible for creating the Cloud Storage bucket and
	// directory referenced in `uri_prefix`.
	UriPrefix string `json:"uriPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UriPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UriPrefix") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudHealthcareV1beta1ConsentGcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudHealthcareV1beta1ConsentGcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudHealthcareV1beta1ConsentPolicy: Represents a user's consent in
// terms of the resources that can be accessed and under what conditions.
type GoogleCloudHealthcareV1beta1ConsentPolicy struct {
	// AuthorizationRule: Required. The request conditions to meet to grant access.
	// In addition to any supported comparison operators, authorization rules may
	// have `IN` operator as well as at most 10 logical operators that are limited
	// to `AND` (`&&`), `OR` (`||`).
	AuthorizationRule *Expr `json:"authorizationRule,omitempty"`
	// ResourceAttributes: The resources that this policy applies to. A resource is
	// a match if it matches all the attributes listed here. If empty, this policy
	// applies to all User data mappings for the given user.
	ResourceAttributes []*Attribute `json:"resourceAttributes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuthorizationRule") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuthorizationRule") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudHealthcareV1beta1ConsentPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudHealthcareV1beta1ConsentPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudHealthcareV1beta1DeidentifyDeidentifyDicomStoreSummary: Contains
// a summary of the DeidentifyDicomStore operation.
type GoogleCloudHealthcareV1beta1DeidentifyDeidentifyDicomStoreSummary struct {
}

// GoogleCloudHealthcareV1beta1DeidentifyDeidentifyFhirStoreSummary: Contains a
// summary of the DeidentifyFhirStore operation.
type GoogleCloudHealthcareV1beta1DeidentifyDeidentifyFhirStoreSummary struct {
}

// GoogleCloudHealthcareV1beta1DeidentifyFieldMetadata: Specifies the FHIR
// paths to match and how to handle the de-identification of matching fields.
type GoogleCloudHealthcareV1beta1DeidentifyFieldMetadata struct {
	// CharacterMaskField: Replace the field's value with a masking character.
	// Supported types (https://www.hl7.org/fhir/datatypes.html): Code, Decimal,
	// HumanName, Id, LanguageCode, Markdown, Oid, String, Uri, Uuid, Xhtml.
	CharacterMaskField *CharacterMaskField `json:"characterMaskField,omitempty"`
	// CleanTextField: Inspect the field's text and transform sensitive text.
	// Configure using TextConfig. Supported types
	// (https://www.hl7.org/fhir/datatypes.html): Code, Date, DateTime, Decimal,
	// HumanName, Id, LanguageCode, Markdown, Oid, String, Uri, Uuid, Xhtml.
	CleanTextField *CleanTextField `json:"cleanTextField,omitempty"`
	// CryptoHashField: Replace field value with a hash of that value. Supported
	// types (https://www.hl7.org/fhir/datatypes.html): Code, Decimal, HumanName,
	// Id, LanguageCode, Markdown, Oid, String, Uri, Uuid, Xhtml.
	CryptoHashField *CryptoHashField `json:"cryptoHashField,omitempty"`
	// DateShiftField: Shift the date by a randomized number of days. See date
	// shifting (https://cloud.google.com/dlp/docs/concepts-date-shifting) for more
	// information. Supported types (https://www.hl7.org/fhir/datatypes.html):
	// Date, DateTime.
	DateShiftField *DateShiftField `json:"dateShiftField,omitempty"`
	// KeepField: Keep the field unchanged.
	KeepField *KeepField `json:"keepField,omitempty"`
	// Paths: List of paths to FHIR fields to redact. Each path is a
	// period-separated list where each component is either a field name or FHIR
	// type (https://www.hl7.org/fhir/datatypes.html) name. All types begin with an
	// upper case letter. For example, the resource field `Patient.Address.city`,
	// which uses a string
	// (https://www.hl7.org/fhir/datatypes-definitions.html#Address.city) type, can
	// be matched by `Patient.Address.String`. Partial matching is supported. For
	// example, `Patient.Address.city` can be matched by `Address.city` (with
	// `Patient` omitted). Partial matching and type matching can be combined, for
	// example `Patient.Address.city` can be matched by `Address.String`. For
	// "choice" types (those defined in the FHIR spec with the format `field[x]`),
	// use two separate components. For example, `deceasedAge.unit` is matched by
	// `Deceased.Age.unit`. The following types are supported:
	// AdministrativeGenderCode, Base64Binary, Boolean, Code, Date, DateTime,
	// Decimal, HumanName, Id, Instant, Integer, LanguageCode, Markdown, Oid,
	// PositiveInt, String, UnsignedInt, Uri, Uuid, Xhtml. The sub-type for
	// HumanName (for example `HumanName.given`, `HumanName.family`) can be
	// omitted.
	Paths []string `json:"paths,omitempty"`
	// RemoveField: Remove the field.
	RemoveField *RemoveField `json:"removeField,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CharacterMaskField") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CharacterMaskField") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudHealthcareV1beta1DeidentifyFieldMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudHealthcareV1beta1DeidentifyFieldMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudHealthcareV1beta1DeidentifyOptions: Specifies additional options
// to apply to the base ProfileType.
type GoogleCloudHealthcareV1beta1DeidentifyOptions struct {
	// CharacterMaskConfig: Character mask config for CharacterMaskField.
	CharacterMaskConfig *CharacterMaskConfig `json:"characterMaskConfig,omitempty"`
	// ContextualDeid: Configure contextual de-id.
	ContextualDeid *ContextualDeidConfig `json:"contextualDeid,omitempty"`
	// CryptoHashConfig: Crypto hash config for CharacterMaskField.
	CryptoHashConfig *CryptoHashConfig `json:"cryptoHashConfig,omitempty"`
	// DateShiftConfig: Date shifting config for CharacterMaskField.
	DateShiftConfig *DateShiftConfig `json:"dateShiftConfig,omitempty"`
	// KeepExtensions: Configure keeping extensions by default.
	KeepExtensions *KeepExtensionsConfig `json:"keepExtensions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CharacterMaskConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CharacterMaskConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudHealthcareV1beta1DeidentifyOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudHealthcareV1beta1DeidentifyOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudHealthcareV1beta1DicomBigQueryDestination: The BigQuery table
// where the server writes output.
type GoogleCloudHealthcareV1beta1DicomBigQueryDestination struct {
	// Force: Use `write_disposition` instead. If `write_disposition` is specified,
	// this parameter is ignored. force=false is equivalent to
	// write_disposition=WRITE_EMPTY and force=true is equivalent to
	// write_disposition=WRITE_TRUNCATE.
	Force bool `json:"force,omitempty"`
	// TableUri: BigQuery URI to a table, up to 2000 characters long, in the format
	// `bq://projectId.bqDatasetId.tableId`
	TableUri string `json:"tableUri,omitempty"`
	// WriteDisposition: Determines whether the existing table in the destination
	// is to be overwritten or appended to. If a write_disposition is specified,
	// the `force` parameter is ignored.
	//
	// Possible values:
	//   "WRITE_DISPOSITION_UNSPECIFIED" - Default behavior is the same as
	// WRITE_EMPTY.
	//   "WRITE_EMPTY" - Only export data if the destination table is empty.
	//   "WRITE_TRUNCATE" - Erase all existing data in the destination table before
	// writing the instances.
	//   "WRITE_APPEND" - Append data to the destination table.
	WriteDisposition string `json:"writeDisposition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Force") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Force") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudHealthcareV1beta1DicomBigQueryDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudHealthcareV1beta1DicomBigQueryDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudHealthcareV1beta1DicomGcsDestination: The Cloud Storage location
// where the server writes the output and the export configuration.
type GoogleCloudHealthcareV1beta1DicomGcsDestination struct {
	// MimeType: MIME types supported by DICOM spec. Each file is written in the
	// following format:
	// `.../{study_id}/{series_id}/{instance_id}[/{frame_number}].{extension}` The
	// frame_number component exists only for multi-frame instances. Supported MIME
	// types are consistent with supported formats in DICOMweb:
	// https://cloud.google.com/healthcare/docs/dicom#retrieve_transaction.
	// Specifically, the following are supported: - application/dicom;
	// transfer-syntax=1.2.840.10008.1.2.1 (uncompressed DICOM) -
	// application/dicom; transfer-syntax=1.2.840.10008.1.2.4.50 (DICOM with
	// embedded JPEG Baseline) - application/dicom;
	// transfer-syntax=1.2.840.10008.1.2.4.90 (DICOM with embedded JPEG 2000
	// Lossless Only) - application/dicom; transfer-syntax=1.2.840.10008.1.2.4.91
	// (DICOM with embedded JPEG 2000)h - application/dicom; transfer-syntax=*
	// (DICOM with no transcoding) - application/octet-stream;
	// transfer-syntax=1.2.840.10008.1.2.1 (raw uncompressed PixelData) -
	// application/octet-stream; transfer-syntax=* (raw PixelData in whatever
	// format it was uploaded in) - image/jpeg;
	// transfer-syntax=1.2.840.10008.1.2.4.50 (Consumer JPEG) - image/png The
	// following extensions are used for output files: - application/dicom -> .dcm
	// - image/jpeg -> .jpg - image/png -> .png - application/octet-stream -> no
	// extension If unspecified, the instances are exported in the original DICOM
	// format they were uploaded in.
	MimeType string `json:"mimeType,omitempty"`
	// UriPrefix: The Cloud Storage destination to export to. URI for a Cloud
	// Storage directory where the server writes the result files, in the format
	// `gs://{bucket-id}/{path/to/destination/dir}`). If there is no trailing
	// slash, the service appends one when composing the object path. The user is
	// responsible for creating the Cloud Storage bucket referenced in
	// `uri_prefix`.
	UriPrefix string `json:"uriPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MimeType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MimeType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudHealthcareV1beta1DicomGcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudHealthcareV1beta1DicomGcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudHealthcareV1beta1DicomGcsSource: Specifies the configuration for
// importing data from Cloud Storage.
type GoogleCloudHealthcareV1beta1DicomGcsSource struct {
	// Uri: Points to a Cloud Storage URI containing file(s) with content only. The
	// URI must be in the following format: `gs://{bucket_id}/{object_id}`. The URI
	// can include wildcards in `object_id` and thus identify multiple files.
	// Supported wildcards: * '*' to match 0 or more non-separator characters *
	// '**' to match 0 or more characters (including separators). Must be used at
	// the end of a path and with no other wildcards in the path. Can also be used
	// with a file extension (such as .dcm), which imports all files with the
	// extension in the specified directory and its sub-directories. For example,
	// `gs://my-bucket/my-directory/**.dcm` imports all files with .dcm extensions
	// in `my-directory/` and its sub-directories. * '?' to match 1 character. All
	// other URI formats are invalid. Files matching the wildcard are expected to
	// contain content only, no metadata.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudHealthcareV1beta1DicomGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudHealthcareV1beta1DicomGcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudHealthcareV1beta1DicomStreamConfig: StreamConfig specifies
// configuration for a streaming DICOM export.
type GoogleCloudHealthcareV1beta1DicomStreamConfig struct {
	// BigqueryDestination: Results are appended to this table. The server creates
	// a new table in the given BigQuery dataset if the specified table does not
	// exist. To enable the Cloud Healthcare API to write to your BigQuery table,
	// you must give the Cloud Healthcare API service account the
	// bigquery.dataEditor role. The service account is:
	// `service-{PROJECT_NUMBER}@gcp-sa-healthcare.iam.gserviceaccount.com`. The
	// PROJECT_NUMBER identifies the project that the DICOM store resides in. To
	// get the project number, go to the Cloud Console Dashboard. It is recommended
	// to not have a custom schema in the destination table which could conflict
	// with the schema created by the Cloud Healthcare API. Instance deletions are
	// not applied to the destination table. The destination's table schema will be
	// automatically updated in case a new instance's data is incompatible with the
	// current schema. The schema should not be updated manually as this can cause
	// incompatibilies that cannot be resolved automatically. One resolution in
	// this case is to delete the incompatible table and let the server recreate
	// one, though the newly created table only contains data after the table
	// recreation. BigQuery imposes a 1 MB limit on streaming insert row size,
	// therefore any instance that generates more than 1 MB of BigQuery data will
	// not be streamed. If an instance cannot be streamed to BigQuery, errors will
	// be logged to Cloud Logging (see Viewing error logs in Cloud Logging
	// (https://cloud.google.com/healthcare/docs/how-tos/logging)).
	BigqueryDestination *GoogleCloudHealthcareV1beta1DicomBigQueryDestination `json:"bigqueryDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigqueryDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigqueryDestination") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudHealthcareV1beta1DicomStreamConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudHealthcareV1beta1DicomStreamConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudHealthcareV1beta1FhirBigQueryDestination: The configuration for
// exporting to BigQuery.
type GoogleCloudHealthcareV1beta1FhirBigQueryDestination struct {
	// DatasetUri: BigQuery URI to an existing dataset, up to 2000 characters long,
	// in the format `bq://projectId.bqDatasetId`.
	DatasetUri string `json:"datasetUri,omitempty"`
	// Force: Use `write_disposition` instead. If `write_disposition` is specified,
	// this parameter is ignored. force=false is equivalent to
	// write_disposition=WRITE_EMPTY and force=true is equivalent to
	// write_disposition=WRITE_TRUNCATE.
	Force bool `json:"force,omitempty"`
	// SchemaConfig: The configuration for the exported BigQuery schema.
	SchemaConfig *SchemaConfig `json:"schemaConfig,omitempty"`
	// WriteDisposition: Determines if existing data in the destination dataset is
	// overwritten, appended to, or not written if the tables contain data. If a
	// write_disposition is specified, the `force` parameter is ignored.
	//
	// Possible values:
	//   "WRITE_DISPOSITION_UNSPECIFIED" - Default behavior is the same as
	// WRITE_EMPTY.
	//   "WRITE_EMPTY" - Only export data if the destination tables are empty.
	//   "WRITE_TRUNCATE" - Erase all existing data in the destination tables
	// before writing the FHIR resources.
	//   "WRITE_APPEND" - Append data to the destination tables.
	WriteDisposition string `json:"writeDisposition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudHealthcareV1beta1FhirBigQueryDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudHealthcareV1beta1FhirBigQueryDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudHealthcareV1beta1FhirExportResourcesResponse: Response when all
// resources export successfully. This structure is included in the response to
// describe the detailed outcome after the operation finishes successfully.
type GoogleCloudHealthcareV1beta1FhirExportResourcesResponse struct {
}

// GoogleCloudHealthcareV1beta1FhirGcsDestination: The configuration for
// exporting to Cloud Storage.
type GoogleCloudHealthcareV1beta1FhirGcsDestination struct {
	// UriPrefix: URI for a Cloud Storage directory where result files should be
	// written (in the format `gs://{bucket-id}/{path/to/destination/dir}`). If
	// there is no trailing slash, the service appends one when composing the
	// object path. The Cloud Storage bucket referenced in `uri_prefix` must exist
	// or an error occurs.
	UriPrefix string `json:"uriPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UriPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UriPrefix") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudHealthcareV1beta1FhirGcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudHealthcareV1beta1FhirGcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudHealthcareV1beta1FhirGcsSource: Specifies the configuration for
// importing data from Cloud Storage.
type GoogleCloudHealthcareV1beta1FhirGcsSource struct {
	// Uri: Points to a Cloud Storage URI containing file(s) to import. The URI
	// must be in the following format: `gs://{bucket_id}/{object_id}`. The URI can
	// include wildcards in `object_id` and thus identify multiple files. Supported
	// wildcards: * `*` to match 0 or more non-separator characters * `**` to match
	// 0 or more characters (including separators). Must be used at the end of a
	// path and with no other wildcards in the path. Can also be used with a file
	// extension (such as .ndjson), which imports all files with the extension in
	// the specified directory and its sub-directories. For example,
	// `gs://my-bucket/my-directory/**.ndjson` imports all files with `.ndjson`
	// extensions in `my-directory/` and its sub-directories. * `?` to match 1
	// character Files matching the wildcard are expected to contain content only,
	// no metadata.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudHealthcareV1beta1FhirGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudHealthcareV1beta1FhirGcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudHealthcareV1beta1FhirImportResourcesResponse: Final response of
// importing resources. This structure is included in the response to describe
// the detailed outcome after the operation finishes successfully.
type GoogleCloudHealthcareV1beta1FhirImportResourcesResponse struct {
}

// GroupOrSegment: Construct representing a logical group or a segment.
type GroupOrSegment struct {
	Group   *SchemaGroup   `json:"group,omitempty"`
	Segment *SchemaSegment `json:"segment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Group") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Group") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GroupOrSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GroupOrSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Hl7SchemaConfig: Root config message for HL7v2 schema. This contains a
// schema structure of groups and segments, and filters that determine which
// messages to apply the schema structure to.
type Hl7SchemaConfig struct {
	// MessageSchemaConfigs: Map from each HL7v2 message type and trigger event
	// pair, such as ADT_A04, to its schema configuration root group.
	MessageSchemaConfigs map[string]SchemaGroup `json:"messageSchemaConfigs,omitempty"`
	// Version: Each VersionSource is tested and only if they all match is the
	// schema used for the message.
	Version []*VersionSource `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MessageSchemaConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MessageSchemaConfigs") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Hl7SchemaConfig) MarshalJSON() ([]byte, error) {
	type NoMethod Hl7SchemaConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Hl7TypesConfig: Root config for HL7v2 datatype definitions for a specific
// HL7v2 version.
type Hl7TypesConfig struct {
	// Type: The HL7v2 type definitions.
	Type []*Type `json:"type,omitempty"`
	// Version: The version selectors that this config applies to. A message must
	// match ALL version sources to apply.
	Version []*VersionSource `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Hl7TypesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod Hl7TypesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Hl7V2NotificationConfig: Specifies where and whether to send notifications
// upon changes to a data store.
type Hl7V2NotificationConfig struct {
	// Filter: Restricts notifications sent for messages matching a filter. If this
	// is empty, all messages are matched. The following syntax is available: * A
	// string field value can be written as text inside quotation marks, for
	// example "query text". The only valid relational operation for text fields
	// is equality (`=`), where text is searched within the field, rather than
	// having the field be equal to the text. For example, "Comment = great"
	// returns messages with `great` in the comment field. * A number field value
	// can be written as an integer, a decimal, or an exponential. The valid
	// relational operators for number fields are the equality operator (`=`),
	// along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note
	// that there is no inequality (`!=`) operator. You can prepend the `NOT`
	// operator to an expression to negate it. * A date field value must be written
	// in `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format.
	// Leading zeros are required for one-digit months and days. The valid
	// relational operators for date fields are the equality operator (`=`) , along
	// with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that
	// there is no inequality (`!=`) operator. You can prepend the `NOT` operator
	// to an expression to negate it. * Multiple field query expressions can be
	// combined in one query by adding `AND` or `OR` operators between the
	// expressions. If a boolean operator appears within a quoted string, it is not
	// treated as special, it's just another part of the character string to be
	// matched. You can prepend the `NOT` operator to an expression to negate it.
	// Fields/functions available for filtering are: * `message_type`, from the
	// MSH-9.1 field. For example, `NOT message_type = "ADT". * `send_date` or
	// `sendDate`, the YYYY-MM-DD date the message was sent in the dataset's
	// time_zone, from the MSH-7 segment. For example, `send_date < "2017-01-02".
	// * `send_time`, the timestamp when the message was sent, using the RFC3339
	// time format for comparisons, from the MSH-7 segment. For example, `send_time
	// < "2017-01-02T00:00:00-05:00". * `create_time`, the timestamp when the
	// message was created in the HL7v2 store. Use the RFC3339 time format for
	// comparisons. For example, `create_time < "2017-01-02T00:00:00-05:00". *
	// `send_facility`, the care center that the message came from, from the MSH-4
	// segment. For example, `send_facility = "ABC". * `PatientId(value, type)`,
	// which matches if the message lists a patient having an ID of the given value
	// and type in the PID-2, PID-3, or PID-4 segments. For example,
	// `PatientId("123456", "MRN")`. * `labels.x`, a string value of the label with
	// key `x` as set using the Message.labels map. For example,
	// `labels."priority"="high". The operator `:*` can be used to assert the
	// existence of a label. For example, `labels."priority":*`.
	Filter string `json:"filter,omitempty"`
	// PubsubTopic: The Pub/Sub (https://cloud.google.com/pubsub/docs/) topic that
	// notifications of changes are published on. Supplied by the client. The
	// notification is a `PubsubMessage` with the following fields: *
	// `PubsubMessage.Data` contains the resource name. * `PubsubMessage.MessageId`
	// is the ID of this notification. It is guaranteed to be unique within the
	// topic. * `PubsubMessage.PublishTime` is the time when the message was
	// published. Note that notifications are only sent if the topic is non-empty.
	// Topic names (https://cloud.google.com/pubsub/docs/overview#names) must be
	// scoped to a project. Cloud Healthcare API service account must have
	// publisher permissions on the given Pub/Sub topic. Not having adequate
	// permissions causes the calls that send notifications to fail. If a
	// notification can't be published to Pub/Sub, errors are logged to Cloud
	// Logging. For more information, see Viewing error logs in Cloud Logging
	// (https://cloud.google.com/healthcare/docs/how-tos/logging).
	PubsubTopic string `json:"pubsubTopic,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Hl7V2NotificationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod Hl7V2NotificationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Hl7V2Store: Represents an HL7v2 store.
type Hl7V2Store struct {
	// Labels: User-supplied key-value pairs used to organize HL7v2 stores. Label
	// keys must be between 1 and 63 characters long, have a UTF-8 encoding of
	// maximum 128 bytes, and must conform to the following PCRE regular
	// expression: \p{Ll}\p{Lo}{0,62} Label values are optional, must be between 1
	// and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
	// conform to the following PCRE regular expression:
	// [\p{Ll}\p{Lo}\p{N}_-]{0,63} No more than 64 labels can be associated with a
	// given store.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. Resource name of the HL7v2 store, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/hl7V2Sto
	// res/{hl7v2_store_id}`.
	Name string `json:"name,omitempty"`
	// NotificationConfig: The notification destination all messages (both Ingest &
	// Create) are published on. Only the message name is sent as part of the
	// notification. If this is unset, no notifications are sent. Supplied by the
	// client.
	NotificationConfig *NotificationConfig `json:"notificationConfig,omitempty"`
	// NotificationConfigs: A list of notification configs. Each configuration uses
	// a filter to determine whether to publish a message (both Ingest & Create) on
	// the corresponding notification destination. Only the message name is sent as
	// part of the notification. Supplied by the client.
	NotificationConfigs []*Hl7V2NotificationConfig `json:"notificationConfigs,omitempty"`
	// ParserConfig: The configuration for the parser. It determines how the server
	// parses the messages.
	ParserConfig *ParserConfig `json:"parserConfig,omitempty"`
	// RejectDuplicateMessage: Determines whether to reject duplicate messages. A
	// duplicate message is a message with the same raw bytes as a message that has
	// already been ingested/created in this HL7v2 store. The default value is
	// false, meaning that the store accepts the duplicate messages and it also
	// returns the same ACK message in the IngestMessageResponse as has been
	// returned previously. Note that only one resource is created in the store.
	// When this field is set to true, CreateMessage/IngestMessage requests with a
	// duplicate message will be rejected by the store, and
	// IngestMessageErrorDetail returns a NACK message upon rejection.
	RejectDuplicateMessage bool `json:"rejectDuplicateMessage,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Labels") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Labels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Hl7V2Store) MarshalJSON() ([]byte, error) {
	type NoMethod Hl7V2Store
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Hl7V2StoreMetric: Count of messages and total storage size by type for a
// given HL7 store.
type Hl7V2StoreMetric struct {
	// Count: The total count of HL7v2 messages in the store for the given message
	// type.
	Count int64 `json:"count,omitempty,string"`
	// MessageType: The Hl7v2 message type this metric applies to, such as `ADT` or
	// `ORU`.
	MessageType string `json:"messageType,omitempty"`
	// StructuredStorageSizeBytes: The total amount of structured storage used by
	// HL7v2 messages of this message type in the store.
	StructuredStorageSizeBytes int64 `json:"structuredStorageSizeBytes,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Count") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Hl7V2StoreMetric) MarshalJSON() ([]byte, error) {
	type NoMethod Hl7V2StoreMetric
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Hl7V2StoreMetrics: List of metrics for a given HL7v2 store.
type Hl7V2StoreMetrics struct {
	// Metrics: List of HL7v2 store metrics by message type.
	Metrics []*Hl7V2StoreMetric `json:"metrics,omitempty"`
	// Name: The resource name of the HL7v2 store to get metrics for, in the format
	// `projects/{project_id}/datasets/{dataset_id}/hl7V2Stores/{hl7v2_store_id}`.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Metrics") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metrics") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Hl7V2StoreMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod Hl7V2StoreMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HttpBody: Message that represents an arbitrary HTTP body. It should only be
// used for payload formats that can't be represented as JSON, such as raw
// binary or an HTML page. This message can be used both in streaming and
// non-streaming API methods in the request as well as the response. It can be
// used as a top-level request field, which is convenient if one wants to
// extract parameters from either the URL or HTTP template into the request
// fields and also want access to the raw HTTP body. Example: message
// GetResourceRequest { // A unique request id. string request_id = 1; // The
// raw HTTP body is bound to this field. google.api.HttpBody http_body = 2; }
// service ResourceService { rpc GetResource(GetResourceRequest) returns
// (google.api.HttpBody); rpc UpdateResource(google.api.HttpBody) returns
// (google.protobuf.Empty); } Example with streaming methods: service
// CaldavService { rpc GetCalendar(stream google.api.HttpBody) returns (stream
// google.api.HttpBody); rpc UpdateCalendar(stream google.api.HttpBody) returns
// (stream google.api.HttpBody); } Use of this type only changes how the
// request and response bodies are handled, all other features will continue to
// work unchanged.
type HttpBody struct {
	// ContentType: The HTTP Content-Type header value specifying the content type
	// of the body.
	ContentType string `json:"contentType,omitempty"`
	// Data: The HTTP request/response body as raw binary.
	Data string `json:"data,omitempty"`
	// Extensions: Application specific response metadata. Must be set in the first
	// response for streaming APIs.
	Extensions []googleapi.RawMessage `json:"extensions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ContentType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HttpBody) MarshalJSON() ([]byte, error) {
	type NoMethod HttpBody
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Image: Raw bytes representing consent artifact content.
type Image struct {
	// GcsUri: Input only. Points to a Cloud Storage URI containing the consent
	// artifact content. The URI must be in the following format:
	// `gs://{bucket_id}/{object_id}`. The Cloud Healthcare API service account
	// must have the `roles/storage.objectViewer` Cloud IAM role for this Cloud
	// Storage location. The consent artifact content at this URI is copied to a
	// Cloud Storage location managed by the Cloud Healthcare API. Responses to
	// fetching requests return the consent artifact content in raw_bytes.
	GcsUri string `json:"gcsUri,omitempty"`
	// RawBytes: Consent artifact content represented as a stream of bytes. This
	// field is populated when returned in GetConsentArtifact response, but not
	// included in CreateConsentArtifact and ListConsentArtifact response.
	RawBytes string `json:"rawBytes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsUri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Image) MarshalJSON() ([]byte, error) {
	type NoMethod Image
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImageAnnotation: Image annotation.
type ImageAnnotation struct {
	// BoundingPolys: The list of polygons outlining the sensitive regions in the
	// image.
	BoundingPolys []*BoundingPoly `json:"boundingPolys,omitempty"`
	// FrameIndex: 0-based index of the image frame. For example, an image frame in
	// a DICOM instance.
	FrameIndex int64 `json:"frameIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoundingPolys") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoundingPolys") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImageAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod ImageAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImageConfig: Specifies how to handle de-identification of image pixels.
type ImageConfig struct {
	// AdditionalInfoTypes: Additional InfoTypes to redact in the images in
	// addition to those used by `text_redaction_mode`. Can only be used when
	// `text_redaction_mode` is set to `REDACT_SENSITIVE_TEXT`,
	// `REDACT_SENSITIVE_TEXT_CLEAN_DESCRIPTORS` or
	// `TEXT_REDACTION_MODE_UNSPECIFIED`.
	AdditionalInfoTypes []string `json:"additionalInfoTypes,omitempty"`
	// ExcludeInfoTypes: InfoTypes to skip redacting, overriding those used by
	// `text_redaction_mode`. Can only be used when `text_redaction_mode` is set to
	// `REDACT_SENSITIVE_TEXT` or `REDACT_SENSITIVE_TEXT_CLEAN_DESCRIPTORS`.
	ExcludeInfoTypes []string `json:"excludeInfoTypes,omitempty"`
	// TextRedactionMode: Determines how to redact text from image.
	//
	// Possible values:
	//   "TEXT_REDACTION_MODE_UNSPECIFIED" - No text redaction specified. Same as
	// REDACT_NO_TEXT.
	//   "REDACT_ALL_TEXT" - Redact all text.
	//   "REDACT_SENSITIVE_TEXT" - Redact sensitive text. Uses the set of [Default
	// DICOM
	// InfoTypes](https://cloud.google.com/healthcare-api/docs/how-tos/dicom-deident
	// ify#default_dicom_infotypes).
	//   "REDACT_NO_TEXT" - Do not redact text.
	//   "REDACT_SENSITIVE_TEXT_CLEAN_DESCRIPTORS" - This mode is like
	// `REDACT_SENSITIVE_TEXT` with the addition of the [Clean Descriptors Option]
	// (https://dicom.nema.org/medical/dicom/2018e/output/chtml/part15/sect_E.3.5.html)
	// enabled: When cleaning text, the process attempts to transform phrases
	// matching any of the tags marked for removal (action codes D, Z, X, and U) in
	// the [Basic Profile]
	// (https://dicom.nema.org/medical/dicom/2018e/output/chtml/part15/chapter_E.html).
	// These contextual phrases are replaced with the token "[CTX]". This mode uses
	// an additional InfoType during inspection.
	TextRedactionMode string `json:"textRedactionMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalInfoTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalInfoTypes") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImageConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ImageConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportAnnotationsRequest: Request to import Annotations. The Annotations to
// be imported must have client-supplied resource names which indicate the
// annotation resource. The import operation is not atomic. If a failure
// occurs, any annotations already imported are not removed.
type ImportAnnotationsRequest struct {
	GcsSource *GoogleCloudHealthcareV1beta1AnnotationGcsSource `json:"gcsSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportAnnotationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ImportAnnotationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportAnnotationsResponse: Final response of importing Annotations in
// successful case. This structure is included in the response. It is only
// included when the operation finishes.
type ImportAnnotationsResponse struct {
}

// ImportDicomDataRequest: Imports data into the specified DICOM store. Returns
// an error if any of the files to import are not DICOM files. This API accepts
// duplicate DICOM instances by ignoring the newly-pushed instance. It does not
// overwrite.
type ImportDicomDataRequest struct {
	// BlobStorageSettings: Optional. The blob storage settings for the data
	// imported by this operation.
	BlobStorageSettings *BlobStorageSettings `json:"blobStorageSettings,omitempty"`
	// GcsSource: Cloud Storage source data location and import configuration. The
	// Cloud Healthcare Service Agent requires the `roles/storage.objectViewer`
	// Cloud IAM roles on the Cloud Storage location.
	GcsSource *GoogleCloudHealthcareV1beta1DicomGcsSource `json:"gcsSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlobStorageSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlobStorageSettings") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportDicomDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ImportDicomDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportDicomDataResponse: Returns additional information in regards to a
// completed DICOM store import.
type ImportDicomDataResponse struct {
}

// ImportMessagesRequest: Request to import messages.
type ImportMessagesRequest struct {
	// GcsSource: Cloud Storage source data location and import configuration. The
	// Cloud Healthcare Service Agent requires the `roles/storage.objectViewer`
	// Cloud IAM roles on the Cloud Storage location.
	GcsSource *GcsSource `json:"gcsSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportMessagesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ImportMessagesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportMessagesResponse: Final response of importing messages. This structure
// is included in the response to describe the detailed outcome. It is only
// included when the operation finishes successfully.
type ImportMessagesResponse struct {
}

// ImportResourcesHistoryRequest: Request to import the history of resources.
type ImportResourcesHistoryRequest struct {
	// ContentStructure: The content structure in the source location. If not
	// specified, the server treats the input source files as BUNDLE.
	//
	// Possible values:
	//   "CONTENT_STRUCTURE_UNSPECIFIED" - If the content structure is not
	// specified, the default value `BUNDLE` is used.
	//   "BUNDLE" - The source file contains one or more lines of newline-delimited
	// JSON (ndjson). Each line is a bundle that contains one or more resources.
	//   "RESOURCE" - The source file contains one or more lines of
	// newline-delimited JSON (ndjson). Each line is a single resource.
	//   "BUNDLE_PRETTY" - The entire file is one JSON bundle. The JSON can span
	// multiple lines.
	//   "RESOURCE_PRETTY" - The entire file is one JSON resource. The JSON can
	// span multiple lines.
	ContentStructure string `json:"contentStructure,omitempty"`
	// GcsSource: Cloud Storage source data location and import configuration. The
	// Cloud Healthcare Service Agent requires the `roles/storage.objectAdmin`
	// Cloud IAM roles on the Cloud Storage location. The Healthcare Service Agent
	// Each Cloud Storage object should be a text file that contains the format
	// specified in ContentStructure.
	GcsSource *GoogleCloudHealthcareV1beta1FhirGcsSource `json:"gcsSource,omitempty"`
	// MaxErrorCount: The maximum number of errors before the server cancels the
	// operation. If not specified or set to 0, defaults to 100. -1 means no
	// maximum, the server tries to process all input. Since the server executes
	// the operation in parallel, it might not stop the operation after exactly
	// this number of errors occur.
	MaxErrorCount int64 `json:"maxErrorCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ContentStructure") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentStructure") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportResourcesHistoryRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ImportResourcesHistoryRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportResourcesRequest: Request to import resources.
type ImportResourcesRequest struct {
	// ContentStructure: The content structure in the source location. If not
	// specified, the server treats the input source files as BUNDLE.
	//
	// Possible values:
	//   "CONTENT_STRUCTURE_UNSPECIFIED" - If the content structure is not
	// specified, the default value `BUNDLE` is used.
	//   "BUNDLE" - The source file contains one or more lines of newline-delimited
	// JSON (ndjson). Each line is a bundle that contains one or more resources.
	//   "RESOURCE" - The source file contains one or more lines of
	// newline-delimited JSON (ndjson). Each line is a single resource.
	//   "BUNDLE_PRETTY" - The entire file is one JSON bundle. The JSON can span
	// multiple lines.
	//   "RESOURCE_PRETTY" - The entire file is one JSON resource. The JSON can
	// span multiple lines.
	ContentStructure string `json:"contentStructure,omitempty"`
	// GcsSource: Cloud Storage source data location and import configuration. The
	// Cloud Healthcare Service Agent requires the `roles/storage.objectViewer`
	// Cloud IAM roles on the Cloud Storage location. The Healthcare Service Agent
	// Each Cloud Storage object should be a text file that contains the format
	// specified in ContentStructure.
	GcsSource *GoogleCloudHealthcareV1beta1FhirGcsSource `json:"gcsSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentStructure") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentStructure") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportResourcesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ImportResourcesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InfoTypeConfig: Specifies how to use infoTypes for evaluation. For example,
// a user might only want to evaluate `PERSON`, `LOCATION`, and `AGE`.
type InfoTypeConfig struct {
	EvaluateList *FilterList `json:"evaluateList,omitempty"`
	IgnoreList   *FilterList `json:"ignoreList,omitempty"`
	// StrictMatching: If `TRUE`, infoTypes described by `filter` are used for
	// evaluation. Otherwise, infoTypes are not considered for evaluation. For
	// example: * Annotated text: "Toronto is a location" * Finding 1:
	// `{"infoType": "PERSON", "quote": "Toronto", "start": 0, "end": 7}` * Finding
	// 2: `{"infoType": "CITY", "quote": "Toronto", "start": 0, "end": 7}` *
	// Finding 3: `{}` * Ground truth: `{"infoType": "LOCATION", "quote":
	// "Toronto", "start": 0, "end": 7}` When `strict_matching` is `TRUE`: *
	// Finding 1: 1 false positive * Finding 2: 1 false positive * Finding 3: 1
	// false negative When `strict_matching` is `FALSE`: * Finding 1: 1 true
	// positive * Finding 2: 1 true positive * Finding 3: 1 false negative
	StrictMatching bool `json:"strictMatching,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EvaluateList") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EvaluateList") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InfoTypeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod InfoTypeConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InfoTypeTransformation: A transformation to apply to text that is identified
// as a specific info_type.
type InfoTypeTransformation struct {
	// CharacterMaskConfig: Config for character mask.
	CharacterMaskConfig *CharacterMaskConfig `json:"characterMaskConfig,omitempty"`
	// CryptoHashConfig: Config for crypto hash.
	CryptoHashConfig *CryptoHashConfig `json:"cryptoHashConfig,omitempty"`
	// DateShiftConfig: Config for date shift.
	DateShiftConfig *DateShiftConfig `json:"dateShiftConfig,omitempty"`
	// InfoTypes: `InfoTypes` to apply this transformation to. If this is not
	// specified, this transformation becomes the default transformation, and is
	// used for any `info_type` that is not specified in another transformation.
	InfoTypes []string `json:"infoTypes,omitempty"`
	// RedactConfig: Config for text redaction.
	RedactConfig *RedactConfig `json:"redactConfig,omitempty"`
	// ReplaceWithInfoTypeConfig: Config for replace with InfoType.
	ReplaceWithInfoTypeConfig *ReplaceWithInfoTypeConfig `json:"replaceWithInfoTypeConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CharacterMaskConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CharacterMaskConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InfoTypeTransformation) MarshalJSON() ([]byte, error) {
	type NoMethod InfoTypeTransformation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IngestMessageRequest: Ingests a message into the specified HL7v2 store.
type IngestMessageRequest struct {
	// Message: Required. HL7v2 message to ingest.
	Message *Message `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Message") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Message") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IngestMessageRequest) MarshalJSON() ([]byte, error) {
	type NoMethod IngestMessageRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IngestMessageResponse: Acknowledges that a message has been ingested into
// the specified HL7v2 store.
type IngestMessageResponse struct {
	// Hl7Ack: HL7v2 ACK message.
	Hl7Ack string `json:"hl7Ack,omitempty"`
	// Message: Created message resource.
	Message *Message `json:"message,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Hl7Ack") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hl7Ack") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IngestMessageResponse) MarshalJSON() ([]byte, error) {
	type NoMethod IngestMessageResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// KeepExtensionsConfig: The behavior for handling FHIR extensions that aren't
// otherwise specified for de-identification. If provided, all extensions are
// preserved during de-identification by default. If unspecified, all
// extensions are removed during de-identification by default.
type KeepExtensionsConfig struct {
}

// KeepField: Keep field unchanged.
type KeepField struct {
}

// KeepTag: Keep tag unchanged.
type KeepTag struct {
}

// KmsWrappedCryptoKey: Include to use an existing data crypto key wrapped by
// KMS. The wrapped key must be a 128-, 192-, or 256-bit key. The key must
// grant the Cloud IAM permission `cloudkms.cryptoKeyVersions.useToDecrypt` to
// the project's Cloud Healthcare Service Agent service account. For more
// information, see [Creating a wrapped key]
// (https://cloud.google.com/dlp/docs/create-wrapped-key).
type KmsWrappedCryptoKey struct {
	// CryptoKey: Required. The resource name of the KMS CryptoKey to use for
	// unwrapping. For example,
	// `projects/{project_id}/locations/{location_id}/keyRings/{keyring}/cryptoKeys/
	// {key}`.
	CryptoKey string `json:"cryptoKey,omitempty"`
	// WrappedKey: Required. The wrapped data crypto key.
	WrappedKey string `json:"wrappedKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CryptoKey") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CryptoKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s KmsWrappedCryptoKey) MarshalJSON() ([]byte, error) {
	type NoMethod KmsWrappedCryptoKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LinkedEntity: EntityMentions can be linked to multiple entities using a
// LinkedEntity message lets us add other fields, e.g. confidence.
type LinkedEntity struct {
	// EntityId: entity_id is a concept unique identifier. These are prefixed by a
	// string that identifies the entity coding system, followed by the unique
	// identifier within that system. For example, "UMLS/C0000970". This also
	// supports ad hoc entities, which are formed by normalizing entity mention
	// content.
	EntityId string `json:"entityId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LinkedEntity) MarshalJSON() ([]byte, error) {
	type NoMethod LinkedEntity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAnnotationStoresResponse: Lists the Annotation stores in the given
// dataset.
type ListAnnotationStoresResponse struct {
	// AnnotationStores: The returned Annotation stores. Won't be more Annotation
	// stores than the value of page_size in the request.
	AnnotationStores []*AnnotationStore `json:"annotationStores,omitempty"`
	// NextPageToken: Token to retrieve the next page of results or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AnnotationStores") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationStores") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAnnotationStoresResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAnnotationStoresResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAnnotationsResponse: Lists the Annotations in the specified Annotation
// store.
type ListAnnotationsResponse struct {
	// Annotations: The returned Annotations. Won't be more values than the value
	// of page_size in the request. See `AnnotationView` in the request for
	// populated fields.
	Annotations []*Annotation `json:"annotations,omitempty"`
	// NextPageToken: Token to retrieve the next page of results or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAnnotationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAnnotationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ListAttributeDefinitionsResponse struct {
	// AttributeDefinitions: The returned Attribute definitions. The maximum number
	// of attributes returned is determined by the value of page_size in the
	// ListAttributeDefinitionsRequest.
	AttributeDefinitions []*AttributeDefinition `json:"attributeDefinitions,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AttributeDefinitions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeDefinitions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAttributeDefinitionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAttributeDefinitionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ListConsentArtifactsResponse struct {
	// ConsentArtifacts: The returned Consent artifacts. The maximum number of
	// artifacts returned is determined by the value of page_size in the
	// ListConsentArtifactsRequest.
	ConsentArtifacts []*ConsentArtifact `json:"consentArtifacts,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConsentArtifacts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsentArtifacts") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListConsentArtifactsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListConsentArtifactsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ListConsentRevisionsResponse struct {
	// Consents: The returned Consent revisions. The maximum number of revisions
	// returned is determined by the value of `page_size` in the
	// ListConsentRevisionsRequest.
	Consents []*Consent `json:"consents,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Consents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Consents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListConsentRevisionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListConsentRevisionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ListConsentStoresResponse struct {
	// ConsentStores: The returned consent stores. The maximum number of stores
	// returned is determined by the value of page_size in the
	// ListConsentStoresRequest.
	ConsentStores []*ConsentStore `json:"consentStores,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConsentStores") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsentStores") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListConsentStoresResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListConsentStoresResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ListConsentsResponse struct {
	// Consents: The returned Consents. The maximum number of Consents returned is
	// determined by the value of page_size in the ListConsentsRequest.
	Consents []*Consent `json:"consents,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Consents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Consents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListConsentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListConsentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListDatasetsResponse: Lists the available datasets.
type ListDatasetsResponse struct {
	// Datasets: The first page of datasets.
	Datasets []*Dataset `json:"datasets,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Datasets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Datasets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListDatasetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDatasetsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListDicomStoresResponse: Lists the DICOM stores in the given dataset.
type ListDicomStoresResponse struct {
	// DicomStores: The returned DICOM stores. Won't be more DICOM stores than the
	// value of page_size in the request.
	DicomStores []*DicomStore `json:"dicomStores,omitempty"`
	// NextPageToken: Token to retrieve the next page of results or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DicomStores") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DicomStores") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListDicomStoresResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDicomStoresResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListFhirStoresResponse: Lists the FHIR stores in the given dataset.
type ListFhirStoresResponse struct {
	// FhirStores: The returned FHIR stores. Won't be more FHIR stores than the
	// value of page_size in the request.
	FhirStores []*FhirStore `json:"fhirStores,omitempty"`
	// NextPageToken: Token to retrieve the next page of results or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FhirStores") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FhirStores") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListFhirStoresResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListFhirStoresResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListHl7V2StoresResponse: Lists the HL7v2 stores in the given dataset.
type ListHl7V2StoresResponse struct {
	// Hl7V2Stores: The returned HL7v2 stores. Won't be more HL7v2 stores than the
	// value of page_size in the request.
	Hl7V2Stores []*Hl7V2Store `json:"hl7V2Stores,omitempty"`
	// NextPageToken: Token to retrieve the next page of results or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Hl7V2Stores") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hl7V2Stores") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListHl7V2StoresResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListHl7V2StoresResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLocationsResponse: The response message for Locations.ListLocations.
type ListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in the
	// request.
	Locations []*Location `json:"locations,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLocationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListMessagesResponse: Lists the messages in the specified HL7v2 store.
type ListMessagesResponse struct {
	// Hl7V2Messages: The returned Messages. Won't be more Messages than the value
	// of page_size in the request. See view for populated fields.
	Hl7V2Messages []*Message `json:"hl7V2Messages,omitempty"`
	// NextPageToken: Token to retrieve the next page of results or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Hl7V2Messages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hl7V2Messages") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListMessagesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListMessagesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: The response message for Operations.ListOperations.
type ListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*Operation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ListUserDataMappingsResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// UserDataMappings: The returned User data mappings. The maximum number of
	// User data mappings returned is determined by the value of page_size in the
	// ListUserDataMappingsRequest.
	UserDataMappings []*UserDataMapping `json:"userDataMappings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListUserDataMappingsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListUserDataMappingsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Location: A resource that represents a Google Cloud location.
type Location struct {
	// DisplayName: The friendly name for this location, typically a nearby city
	// name. For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`
	// Labels: Cross-service attributes for the location. For example
	// {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`
	// LocationId: The canonical id for this location. For example: "us-east1".
	LocationId string `json:"locationId,omitempty"`
	// Metadata: Service-specific metadata. For example the available capacity at
	// the given location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Resource name for the location, which may vary between
	// implementations. For example:
	// "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Message: A complete HL7v2 message. See [Introduction to HL7 Standards]
// (https://www.hl7.org/implement/standards/index.cfm?ref=common) for details
// on the standard.
type Message struct {
	// CreateTime: Output only. The datetime when the message was created. Set by
	// the server.
	CreateTime string `json:"createTime,omitempty"`
	// Data: Required. Raw message bytes.
	Data string `json:"data,omitempty"`
	// Labels: User-supplied key-value pairs used to organize HL7v2 stores. Label
	// keys must be between 1 and 63 characters long, have a UTF-8 encoding of
	// maximum 128 bytes, and must conform to the following PCRE regular
	// expression: \p{Ll}\p{Lo}{0,62} Label values are optional, must be between 1
	// and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
	// conform to the following PCRE regular expression:
	// [\p{Ll}\p{Lo}\p{N}_-]{0,63} No more than 64 labels can be associated with a
	// given store.
	Labels map[string]string `json:"labels,omitempty"`
	// MessageType: The message type for this message. MSH-9.1.
	MessageType string `json:"messageType,omitempty"`
	// Name: Output only. Resource name of the Message, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/hl7V2Sto
	// res/{hl7_v2_store_id}/messages/{message_id}`. Assigned by the server.
	Name string `json:"name,omitempty"`
	// ParsedData: Output only. The parsed version of the raw message data.
	ParsedData *ParsedData `json:"parsedData,omitempty"`
	// PatientIds: All patient IDs listed in the PID-2, PID-3, and PID-4 segments
	// of this message.
	PatientIds []*PatientId `json:"patientIds,omitempty"`
	// SchematizedData: The parsed version of the raw message data schematized
	// according to this store's schemas and type definitions.
	SchematizedData *SchematizedData `json:"schematizedData,omitempty"`
	// SendFacility: The hospital that this message came from. MSH-4.
	SendFacility string `json:"sendFacility,omitempty"`
	// SendTime: The datetime the sending application sent this message. MSH-7.
	SendTime string `json:"sendTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Message) MarshalJSON() ([]byte, error) {
	type NoMethod Message
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NotificationConfig: Specifies where to send notifications upon changes to a
// data store.
type NotificationConfig struct {
	// PubsubTopic: The Pub/Sub (https://cloud.google.com/pubsub/docs/) topic that
	// notifications of changes are published on. Supplied by the client.
	// PubsubMessage.Data contains the resource name. PubsubMessage.MessageId is
	// the ID of this message. It is guaranteed to be unique within the topic.
	// PubsubMessage.PublishTime is the time at which the message was published.
	// Notifications are only sent if the topic is non-empty. Topic names
	// (https://cloud.google.com/pubsub/docs/overview#names) must be scoped to a
	// project. Cloud Healthcare API service account must have publisher
	// permissions on the given Pub/Sub topic. Not having adequate permissions
	// causes the calls that send notifications to fail. If a notification can't be
	// published to Pub/Sub, errors are logged to Cloud Logging (see Viewing error
	// logs in Cloud Logging
	// (https://cloud.google.com/healthcare/docs/how-tos/logging)). If the number
	// of errors exceeds a certain rate, some aren't submitted. Note that not all
	// operations trigger notifications, see Configuring Pub/Sub notifications
	// (https://cloud.google.com/healthcare/docs/how-tos/pubsub) for specific
	// details.
	PubsubTopic string `json:"pubsubTopic,omitempty"`
	// SendForBulkImport: Indicates whether or not to send Pub/Sub notifications on
	// bulk import. Only supported for DICOM imports.
	SendForBulkImport bool `json:"sendForBulkImport,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PubsubTopic") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PubsubTopic") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NotificationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod NotificationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is the
// result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *Status `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationMetadata: OperationMetadata provides information about the
// operation execution. Returned in the long-running operation's metadata
// field.
type OperationMetadata struct {
	// ApiMethodName: The name of the API method that initiated the operation.
	ApiMethodName string `json:"apiMethodName,omitempty"`
	// CancelRequested: Specifies if cancellation was requested for the operation.
	CancelRequested bool             `json:"cancelRequested,omitempty"`
	Counter         *ProgressCounter `json:"counter,omitempty"`
	// CreateTime: The time at which the operation was created by the API.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time at which execution workloads were completed. Some tasks
	// will complete after this time such as logging audit logs.
	EndTime string `json:"endTime,omitempty"`
	// LogsUrl: A link to audit and error logs in the log viewer. Error logs are
	// generated only by some operations, listed at Viewing error logs in Cloud
	// Logging (https://cloud.google.com/healthcare/docs/how-tos/logging). The
	// `end_time` specified in this URL may not match the end time on the metadata
	// because logs are written asynchronously from execution.
	LogsUrl string `json:"logsUrl,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiMethodName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiMethodName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod OperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Options: Specifies additional options to apply to the base profile.
type Options struct {
	// CleanDescriptors: Set Clean Descriptors Option.
	CleanDescriptors *CleanDescriptorsOption `json:"cleanDescriptors,omitempty"`
	// CleanImage: Apply `Action.clean_image` to `PixelData`
	// (http://dicom.nema.org/medical/dicom/2018e/output/chtml/part06/chapter_6.html)
	// as configured.
	CleanImage *ImageConfig `json:"cleanImage,omitempty"`
	// PrimaryIds: Set `Action` for `StudyInstanceUID`, `SeriesInstanceUID`,
	// `SOPInstanceUID`, and `MediaStorageSOPInstanceUID`
	// (http://dicom.nema.org/medical/dicom/2018e/output/chtml/part06/chapter_6.html).
	//
	// Possible values:
	//   "PRIMARY_IDS_OPTION_UNSPECIFIED" - No value provided. Default to the
	// behavior specified by the base profile.
	//   "KEEP" - Keep primary IDs.
	//   "REGEN" - Regenerate primary IDs.
	PrimaryIds string `json:"primaryIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CleanDescriptors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CleanDescriptors") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Options) MarshalJSON() ([]byte, error) {
	type NoMethod Options
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ParsedData: The content of an HL7v2 message in a structured format.
type ParsedData struct {
	Segments []*Segment `json:"segments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Segments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Segments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ParsedData) MarshalJSON() ([]byte, error) {
	type NoMethod ParsedData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ParserConfig: The configuration for the parser. It determines how the server
// parses the messages.
type ParserConfig struct {
	// AllowNullHeader: Determines whether messages with no header are allowed.
	AllowNullHeader bool `json:"allowNullHeader,omitempty"`
	// Schema: Schemas used to parse messages in this store, if schematized parsing
	// is desired.
	Schema *SchemaPackage `json:"schema,omitempty"`
	// SegmentTerminator: Byte(s) to use as the segment terminator. If this is
	// unset, '\r' is used as segment terminator, matching the HL7 version 2
	// specification.
	SegmentTerminator string `json:"segmentTerminator,omitempty"`
	// Version: Immutable. Determines the version of both the default parser to be
	// used when `schema` is not given, as well as the schematized parser used when
	// `schema` is specified. This field is immutable after HL7v2 store creation.
	//
	// Possible values:
	//   "PARSER_VERSION_UNSPECIFIED" - Unspecified parser version, equivalent to
	// V1.
	//   "V1" - The `parsed_data` includes every given non-empty message field
	// except the Field Separator (MSH-1) field. As a result, the parsed MSH
	// segment starts with the MSH-2 field and the field numbers are off-by-one
	// with respect to the HL7 standard.
	//   "V2" - The `parsed_data` includes every given non-empty message field.
	//   "V3" - This version is the same as V2, with the following change. The
	// `parsed_data` contains unescaped escaped field separators, component
	// separators, sub-component separators, repetition separators, escape
	// characters, and truncation characters. If `schema` is specified, the
	// schematized parser uses improved parsing heuristics compared to previous
	// versions.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowNullHeader") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowNullHeader") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ParserConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ParserConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PatientId: A patient identifier and associated type.
type PatientId struct {
	// Type: ID type. For example, MRN or NHS.
	Type string `json:"type,omitempty"`
	// Value: The patient's unique identifier.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PatientId) MarshalJSON() ([]byte, error) {
	type NoMethod PatientId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PatientScope: Apply consents given by a list of patients.
type PatientScope struct {
	// PatientIds: Optional. The list of patient IDs whose Consent resources will
	// be enforced. At most 10,000 patients can be specified. An empty list is
	// equivalent to all patients (meaning the entire FHIR store).
	PatientIds []string `json:"patientIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PatientIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PatientIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PatientScope) MarshalJSON() ([]byte, error) {
	type NoMethod PatientScope
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Policy: An Identity and Access Management (IAM) policy, which specifies
// access controls for Google Cloud resources. A `Policy` is a collection of
// `bindings`. A `binding` binds one or more `members`, or principals, to a
// single `role`. Principals can be user accounts, service accounts, Google
// groups, and domains (such as G Suite). A `role` is a named list of
// permissions; each `role` can be an IAM predefined role or a user-created
// custom role. For some types of Google Cloud resources, a `binding` can also
// specify a `condition`, which is a logical expression that allows access to a
// resource only if the expression evaluates to `true`. A condition can add
// constraints based on attributes of the request, the resource, or both. To
// learn which resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies). **JSON
// example:** ``` { "bindings": [ { "role":
// "roles/resourcemanager.organizationAdmin", "members": [
// "user:mike@example.com", "group:admins@example.com", "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
// "roles/resourcemanager.organizationViewer", "members": [
// "user:eve@example.com" ], "condition": { "title": "expirable access",
// "description": "Does not grant access after Sep 2020", "expression":
// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
// "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
// members: - user:mike@example.com - group:admins@example.com -
// domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
// role: roles/resourcemanager.organizationAdmin - members: -
// user:eve@example.com role: roles/resourcemanager.organizationViewer
// condition: title: expirable access description: Does not grant access after
// Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
// etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
// see the IAM documentation (https://cloud.google.com/iam/docs/).
type Policy struct {
	// AuditConfigs: Specifies cloud audit logging configuration for this policy.
	AuditConfigs []*AuditConfig `json:"auditConfigs,omitempty"`
	// Bindings: Associates a list of `members`, or principals, with a `role`.
	// Optionally, may specify a `condition` that determines how and when the
	// `bindings` are applied. Each of the `bindings` must contain at least one
	// principal. The `bindings` in a `Policy` can refer to up to 1,500 principals;
	// up to 250 of these principals can be Google groups. Each occurrence of a
	// principal counts towards these limits. For example, if the `bindings` grant
	// 50 different roles to `user:alice@example.com`, and not to any other
	// principal, then you can add another 1,450 principals to the `bindings` in
	// the `Policy`.
	Bindings []*Binding `json:"bindings,omitempty"`
	// Etag: `etag` is used for optimistic concurrency control as a way to help
	// prevent simultaneous updates of a policy from overwriting each other. It is
	// strongly suggested that systems make use of the `etag` in the
	// read-modify-write cycle to perform policy updates in order to avoid race
	// conditions: An `etag` is returned in the response to `getIamPolicy`, and
	// systems are expected to put that etag in the request to `setIamPolicy` to
	// ensure that their change will be applied to the same version of the policy.
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost.
	Etag string `json:"etag,omitempty"`
	// Version: Specifies the format of the policy. Valid values are `0`, `1`, and
	// `3`. Requests that specify an invalid value are rejected. Any operation that
	// affects conditional role bindings must specify version `3`. This requirement
	// applies to the following operations: * Getting a policy that includes a
	// conditional role binding * Adding a conditional role binding to a policy *
	// Changing a conditional role binding in a policy * Removing any role binding,
	// with or without a condition, from a policy that includes conditions
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost. If a policy does not
	// include any conditions, operations on that policy may specify any valid
	// version or leave the field unset. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Version int64 `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AuditConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditConfigs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Policy) MarshalJSON() ([]byte, error) {
	type NoMethod Policy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProgressCounter: ProgressCounter provides counters to describe an
// operation's progress.
type ProgressCounter struct {
	// Failure: The number of units that failed in the operation.
	Failure int64 `json:"failure,omitempty,string"`
	// Pending: The number of units that are pending in the operation.
	Pending int64 `json:"pending,omitempty,string"`
	// SecondaryFailure: The number of secondary units that failed in the
	// operation.
	SecondaryFailure int64 `json:"secondaryFailure,omitempty,string"`
	// SecondarySuccess: The number of secondary units that succeeded in the
	// operation.
	SecondarySuccess int64 `json:"secondarySuccess,omitempty,string"`
	// Success: The number of units that succeeded in the operation.
	Success int64 `json:"success,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Failure") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Failure") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProgressCounter) MarshalJSON() ([]byte, error) {
	type NoMethod ProgressCounter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PubsubDestination: The Pub/Sub output destination. The Cloud Healthcare
// Service Agent requires the `roles/pubsub.publisher` Cloud IAM role on the
// Pub/Sub topic.
type PubsubDestination struct {
	// PubsubTopic: The Pub/Sub (https://cloud.google.com/pubsub/docs/) topic that
	// Pub/Sub messages are published on. Supplied by the client. The
	// `PubsubMessage` contains the following fields: * `PubsubMessage.Data`
	// contains the resource name. * `PubsubMessage.MessageId` is the ID of this
	// notification. It is guaranteed to be unique within the topic. *
	// `PubsubMessage.PublishTime` is the time when the message was published.
	// Topic names (https://cloud.google.com/pubsub/docs/overview#names) must be
	// scoped to a project. The Cloud Healthcare API service account,
	// service-PROJECT_NUMBER@gcp-sa-healthcare.iam.gserviceaccount.com, must have
	// publisher permissions on the given Pub/Sub topic. Not having adequate
	// permissions causes the calls that send notifications to fail.
	PubsubTopic string `json:"pubsubTopic,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PubsubTopic") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PubsubTopic") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PubsubDestination) MarshalJSON() ([]byte, error) {
	type NoMethod PubsubDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// QueryAccessibleDataRequest: Queries all data_ids that are consented for a
// given use in the given consent store and writes them to a specified
// destination. The returned Operation includes a progress counter for the
// number of User data mappings processed. Errors are logged to Cloud Logging
// (see [Viewing error logs in Cloud Logging]
// (https://cloud.google.com/healthcare/docs/how-tos/logging) and
// [QueryAccessibleData] for a sample log entry).
type QueryAccessibleDataRequest struct {
	// GcsDestination: The Cloud Storage destination. The Cloud Healthcare API
	// service account must have the `roles/storage.objectAdmin` Cloud IAM role for
	// this Cloud Storage location. The object name is in the following format:
	// query-accessible-data-result-{operation_id}.txt where each line contains a
	// single data_id.
	GcsDestination *GoogleCloudHealthcareV1beta1ConsentGcsDestination `json:"gcsDestination,omitempty"`
	// RequestAttributes: The values of request attributes associated with this
	// access request.
	RequestAttributes map[string]string `json:"requestAttributes,omitempty"`
	// ResourceAttributes: Optional. The values of resource attributes associated
	// with the type of resources being requested. If no values are specified, then
	// all resource types are included in the output.
	ResourceAttributes map[string]string `json:"resourceAttributes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsDestination") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QueryAccessibleDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod QueryAccessibleDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// QueryAccessibleDataResponse: Response for successful QueryAccessibleData
// operations. This structure is included in the response upon operation
// completion.
type QueryAccessibleDataResponse struct {
	// GcsUris: List of files, each of which contains a list of data_id(s) that are
	// consented for a specified use in the request.
	GcsUris []string `json:"gcsUris,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsUris") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsUris") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QueryAccessibleDataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod QueryAccessibleDataResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RecurseTag: Recursively apply DICOM de-id to tags nested in a sequence.
// Supported [Value Representation]
// (http://dicom.nema.org/medical/dicom/2018e/output/chtml/part05/sect_6.2.html#table_6.2-1):
// SQ
type RecurseTag struct {
}

// RedactConfig: Define how to redact sensitive values. Default behaviour is
// erase. For example, "My name is Jane." becomes "My name is ."
type RedactConfig struct {
}

// RegenUidTag: Replace UID with a new generated UID. Supported [Value
// Representation]
// (http://dicom.nema.org/medical/dicom/2018e/output/chtml/part05/sect_6.2.html#table_6.2-1):
// UI
type RegenUidTag struct {
}

// RejectConsentRequest: Rejects the latest revision of the specified Consent
// by committing a new revision with `state` updated to `REJECTED`. If the
// latest revision of the given Consent is in the `REJECTED` state, no new
// revision is committed.
type RejectConsentRequest struct {
	// ConsentArtifact: Optional. The resource name of the Consent artifact that
	// contains documentation of the user's rejection of the draft Consent, of the
	// form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentS
	// tores/{consent_store_id}/consentArtifacts/{consent_artifact_id}`. If the
	// draft Consent had a Consent artifact, this Consent artifact overwrites it.
	ConsentArtifact string `json:"consentArtifact,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConsentArtifact") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsentArtifact") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RejectConsentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RejectConsentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RemoveField: Remove field.
type RemoveField struct {
}

// RemoveTag: Replace with empty tag.
type RemoveTag struct {
}

// ReplaceWithInfoTypeConfig: When using the INSPECT_AND_TRANSFORM action, each
// match is replaced with the name of the info_type. For example, "My name is
// Jane" becomes "My name is [PERSON_NAME]." The TRANSFORM action is equivalent
// to redacting.
type ReplaceWithInfoTypeConfig struct {
}

// ResetTag: Reset tag to a placeholder value.
type ResetTag struct {
}

// ResourceAnnotation: Resource level annotation.
type ResourceAnnotation struct {
	// Label: A description of the annotation record.
	Label string `json:"label,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Label") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Label") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResourceAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Resources: A list of FHIR resources.
type Resources struct {
	// Resources: List of resources IDs. For example, "Patient/1234".
	Resources []string `json:"resources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Resources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Resources") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Resources) MarshalJSON() ([]byte, error) {
	type NoMethod Resources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Result: The consent evaluation result for a single `data_id`.
type Result struct {
	// ConsentDetails: The resource names of all evaluated Consents mapped to their
	// evaluation.
	ConsentDetails map[string]ConsentEvaluation `json:"consentDetails,omitempty"`
	// Consented: Whether the resource is consented for the given use.
	Consented bool `json:"consented,omitempty"`
	// DataId: The unique identifier of the evaluated resource.
	DataId string `json:"dataId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConsentDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsentDetails") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Result) MarshalJSON() ([]byte, error) {
	type NoMethod Result
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RevokeConsentRequest: Revokes the latest revision of the specified Consent
// by committing a new revision with `state` updated to `REVOKED`. If the
// latest revision of the given Consent is in the `REVOKED` state, no new
// revision is committed.
type RevokeConsentRequest struct {
	// ConsentArtifact: Optional. The resource name of the Consent artifact that
	// contains proof of the user's revocation of the Consent, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentS
	// tores/{consent_store_id}/consentArtifacts/{consent_artifact_id}`.
	ConsentArtifact string `json:"consentArtifact,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConsentArtifact") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsentArtifact") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RevokeConsentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RevokeConsentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RollbackFhirResourceFilteringFields: Filters to select resources that need
// to be rolled back.
type RollbackFhirResourceFilteringFields struct {
	// MetadataFilter: Optional. A filter expression that matches data in the
	// `Resource.meta` element. Supports all filters in AIP-160
	// (https://google.aip.dev/160) except the "has" (`:`) operator. Supports the
	// following custom functions: * `tag("") = "" for tag filtering. *
	// `extension_value_ts("") = ` for filtering extensions with a timestamp, where
	// `` is a Unix timestamp. Supports the `>`, `<`, `<=`, `>=`, and `!=`
	// comparison operators.
	MetadataFilter string `json:"metadataFilter,omitempty"`
	// OperationIds: Optional. A list of operation IDs to roll back. Only changes
	// made by these operations will be rolled back.
	OperationIds googleapi.Uint64s `json:"operationIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MetadataFilter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MetadataFilter") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RollbackFhirResourceFilteringFields) MarshalJSON() ([]byte, error) {
	type NoMethod RollbackFhirResourceFilteringFields
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RollbackFhirResourcesRequest: Request to roll back resources.
type RollbackFhirResourcesRequest struct {
	// ChangeType: Optional. CREATE/UPDATE/DELETE/ALL for reverting all txns of a
	// certain type.
	//
	// Possible values:
	//   "CHANGE_TYPE_UNSPECIFIED" - When unspecified, revert all transactions
	//   "ALL" - All transactions
	//   "CREATE" - Revert only CREATE transactions
	//   "UPDATE" - Revert only Update transactions
	//   "DELETE" - Revert only Delete transactions
	ChangeType string `json:"changeType,omitempty"`
	// ExcludeRollbacks: Optional. Specifies whether to exclude earlier rollbacks.
	ExcludeRollbacks bool `json:"excludeRollbacks,omitempty"`
	// FilteringFields: Optional. Tag represents fields that HDE needs to identify
	// resources that will be reverted. Parameters for filtering resources
	FilteringFields *RollbackFhirResourceFilteringFields `json:"filteringFields,omitempty"`
	// Force: Optional. When enabled, changes will be reverted without explicit
	// confirmation
	Force bool `json:"force,omitempty"`
	// InputGcsObject: Optional. Cloud Storage object containing list of
	// {resourceType}/{resourceId} lines, identifying resources to be reverted
	InputGcsObject string `json:"inputGcsObject,omitempty"`
	// ResultGcsBucket: Required. Bucket to deposit result
	ResultGcsBucket string `json:"resultGcsBucket,omitempty"`
	// RollbackTime: Required. Time point to rollback to.
	RollbackTime string `json:"rollbackTime,omitempty"`
	// Type: Optional. If specified, revert only resources of these types
	Type []string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChangeType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChangeType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RollbackFhirResourcesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RollbackFhirResourcesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RollbackFhirResourcesResponse: Final response of rollback FHIR resources
// request.
type RollbackFhirResourcesResponse struct {
	// FhirStore: The name of the FHIR store to rollback, in the format of
	// "projects/{project_id}/locations/{location_id}/datasets/{dataset_id}
	// /fhirStores/{fhir_store_id}".
	FhirStore string `json:"fhirStore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FhirStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FhirStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RollbackFhirResourcesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod RollbackFhirResourcesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RollbackHL7MessagesFilteringFields: Filtering fields for an HL7v2 rollback.
// Currently only supports a list of operation ids to roll back.
type RollbackHL7MessagesFilteringFields struct {
	// OperationIds: Optional. A list of operation IDs to roll back.
	OperationIds googleapi.Uint64s `json:"operationIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OperationIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OperationIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RollbackHL7MessagesFilteringFields) MarshalJSON() ([]byte, error) {
	type NoMethod RollbackHL7MessagesFilteringFields
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RollbackHl7V2MessagesRequest: Point in time recovery rollback request.
type RollbackHl7V2MessagesRequest struct {
	// ChangeType: Optional. CREATE/UPDATE/DELETE/ALL for reverting all txns of a
	// certain type.
	//
	// Possible values:
	//   "CHANGE_TYPE_UNSPECIFIED" - When unspecified, revert all transactions
	//   "ALL" - All transactions
	//   "CREATE" - Revert only CREATE transactions
	//   "UPDATE" - Revert only Update transactions
	//   "DELETE" - Revert only Delete transactions
	ChangeType string `json:"changeType,omitempty"`
	// ExcludeRollbacks: Optional. Specifies whether to exclude earlier rollbacks.
	ExcludeRollbacks bool `json:"excludeRollbacks,omitempty"`
	// FilteringFields: Optional. Parameters for filtering.
	FilteringFields *RollbackHL7MessagesFilteringFields `json:"filteringFields,omitempty"`
	// Force: Optional. When enabled, changes will be reverted without explicit
	// confirmation.
	Force bool `json:"force,omitempty"`
	// InputGcsObject: Optional. Cloud storage object containing list of
	// {resourceId} lines, identifying resources to be reverted
	InputGcsObject string `json:"inputGcsObject,omitempty"`
	// ResultGcsBucket: Required. Bucket to deposit result
	ResultGcsBucket string `json:"resultGcsBucket,omitempty"`
	// RollbackTime: Required. Times point to rollback to.
	RollbackTime string `json:"rollbackTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChangeType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChangeType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RollbackHl7V2MessagesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RollbackHl7V2MessagesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RollbackHl7V2MessagesResponse: Final response of rollback FHIR resources
// request.
type RollbackHl7V2MessagesResponse struct {
	// Hl7v2Store: The name of the HL7v2 store to rollback, in the format of
	// "projects/{project_id}/locations/{location_id}/datasets/{dataset_id}
	// /hl7v2Stores/{fhir_store_id}".
	Hl7v2Store string `json:"hl7v2Store,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Hl7v2Store") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hl7v2Store") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RollbackHl7V2MessagesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod RollbackHl7V2MessagesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SchemaConfig: Configuration for the FHIR BigQuery schema. Determines how the
// server generates the schema.
type SchemaConfig struct {
	// LastUpdatedPartitionConfig: The configuration for exported BigQuery tables
	// to be partitioned by FHIR resource's last updated time column.
	LastUpdatedPartitionConfig *TimePartitioning `json:"lastUpdatedPartitionConfig,omitempty"`
	// RecursiveStructureDepth: The depth for all recursive structures in the
	// output analytics schema. For example, `concept` in the CodeSystem resource
	// is a recursive structure; when the depth is 2, the CodeSystem table will
	// have a column called `concept.concept` but not `concept.concept.concept`. If
	// not specified or set to 0, the server will use the default value 2. The
	// maximum depth allowed is 5.
	RecursiveStructureDepth int64 `json:"recursiveStructureDepth,omitempty,string"`
	// SchemaType: Specifies the output schema type. Schema type is required.
	//
	// Possible values:
	//   "SCHEMA_TYPE_UNSPECIFIED" - No schema type specified. This type is
	// unsupported.
	//   "LOSSLESS" - A data-driven schema generated from the fields present in the
	// FHIR data being exported, with no additional simplification. This type
	// cannot be used for streaming to BigQuery.
	//   "ANALYTICS" - Analytics schema defined by the FHIR community. See
	// https://github.com/FHIR/sql-on-fhir/blob/master/sql-on-fhir.md. BigQuery
	// only allows a maximum of 10,000 columns per table. Due to this limitation,
	// the server will not generate schemas for fields of type `Resource`, which
	// can hold any resource type. The affected fields are
	// `Parameters.parameter.resource`, `Bundle.entry.resource`, and
	// `Bundle.entry.response.outcome`. Analytics schema does not gracefully handle
	// extensions with one or more occurrences, anaytics schema also does not
	// handle contained resource. Additionally, extensions with a URL ending in
	// "/{existing_resource_field_name}" may cause undefined behavior.
	//   "ANALYTICS_V2" - Analytics V2, similar to schema defined by the FHIR
	// community, with added support for extensions with one or more occurrences
	// and contained resources in stringified JSON. Extensions with a URL ending in
	// "/{existing_resource_field_name}" will cause conflict and prevent the
	// resource from being sent to BigQuery. Analytics V2 uses more space in the
	// destination table than Analytics V1. It is generally recommended to use
	// Analytics V2 over Analytics.
	SchemaType string `json:"schemaType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LastUpdatedPartitionConfig")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LastUpdatedPartitionConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SchemaConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SchemaConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SchemaGroup: An HL7v2 logical group construct.
type SchemaGroup struct {
	// Choice: True indicates that this is a choice group, meaning that only one of
	// its segments can exist in a given message.
	Choice bool `json:"choice,omitempty"`
	// MaxOccurs: The maximum number of times this group can be repeated. 0 or -1
	// means unbounded.
	MaxOccurs int64 `json:"maxOccurs,omitempty"`
	// Members: Nested groups and/or segments.
	Members []*GroupOrSegment `json:"members,omitempty"`
	// MinOccurs: The minimum number of times this group must be present/repeated.
	MinOccurs int64 `json:"minOccurs,omitempty"`
	// Name: The name of this group. For example, "ORDER_DETAIL".
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Choice") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Choice") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SchemaGroup) MarshalJSON() ([]byte, error) {
	type NoMethod SchemaGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SchemaPackage: A schema package contains a set of schemas and type
// definitions.
type SchemaPackage struct {
	// IgnoreMinOccurs: Flag to ignore all min_occurs restrictions in the schema.
	// This means that incoming messages can omit any group, segment, field,
	// component, or subcomponent.
	IgnoreMinOccurs bool `json:"ignoreMinOccurs,omitempty"`
	// Schemas: Schema configs that are layered based on their VersionSources that
	// match the incoming message. Schema configs present in higher indices
	// override those in lower indices with the same message type and trigger event
	// if their VersionSources all match an incoming message.
	Schemas []*Hl7SchemaConfig `json:"schemas,omitempty"`
	// SchematizedParsingType: Determines how messages that fail to parse are
	// handled.
	//
	// Possible values:
	//   "SCHEMATIZED_PARSING_TYPE_UNSPECIFIED" - Unspecified schematized parsing
	// type, equivalent to `SOFT_FAIL`.
	//   "SOFT_FAIL" - Messages that fail to parse are still stored and ACKed but a
	// parser error is stored in place of the schematized data.
	//   "HARD_FAIL" - Messages that fail to parse are rejected from
	// ingestion/insertion and return an error code.
	SchematizedParsingType string `json:"schematizedParsingType,omitempty"`
	// Types: Schema type definitions that are layered based on their
	// VersionSources that match the incoming message. Type definitions present in
	// higher indices override those in lower indices with the same type name if
	// their VersionSources all match an incoming message.
	Types []*Hl7TypesConfig `json:"types,omitempty"`
	// UnexpectedSegmentHandling: Determines how unexpected segments (segments not
	// matched to the schema) are handled.
	//
	// Possible values:
	//   "UNEXPECTED_SEGMENT_HANDLING_MODE_UNSPECIFIED" - Unspecified handling
	// mode, equivalent to FAIL.
	//   "FAIL" - Unexpected segments fail to parse and return an error.
	//   "SKIP" - Unexpected segments do not fail, but are omitted from the output.
	//   "PARSE" - Unexpected segments do not fail, but are parsed in place and
	// added to the current group. If a segment has a type definition, it is used,
	// otherwise it is parsed as VARIES.
	UnexpectedSegmentHandling string `json:"unexpectedSegmentHandling,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IgnoreMinOccurs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IgnoreMinOccurs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SchemaPackage) MarshalJSON() ([]byte, error) {
	type NoMethod SchemaPackage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SchemaSegment: An HL7v2 Segment.
type SchemaSegment struct {
	// MaxOccurs: The maximum number of times this segment can be present in this
	// group. 0 or -1 means unbounded.
	MaxOccurs int64 `json:"maxOccurs,omitempty"`
	// MinOccurs: The minimum number of times this segment can be present in this
	// group.
	MinOccurs int64 `json:"minOccurs,omitempty"`
	// Type: The Segment type. For example, "PID".
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxOccurs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxOccurs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SchemaSegment) MarshalJSON() ([]byte, error) {
	type NoMethod SchemaSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SchematizedData: The content of an HL7v2 message in a structured format as
// specified by a schema.
type SchematizedData struct {
	// Data: JSON output of the parser.
	Data string `json:"data,omitempty"`
	// Error: The error output of the parser.
	Error string `json:"error,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Data") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Data") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SchematizedData) MarshalJSON() ([]byte, error) {
	type NoMethod SchematizedData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchConfig: Contains the configuration for FHIR search.
type SearchConfig struct {
	// SearchParameters: A list of search parameters in this FHIR store that are
	// used to configure this FHIR store.
	SearchParameters []*SearchParameter `json:"searchParameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SearchParameters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SearchParameters") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SearchConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchParameter: Contains the versioned name and the URL for one
// SearchParameter.
type SearchParameter struct {
	// CanonicalUrl: The canonical url of the search parameter resource.
	CanonicalUrl string `json:"canonicalUrl,omitempty"`
	// Parameter: The versioned name of the search parameter resource. The format
	// is
	// projects/{project-id}/locations/{location}/datasets/{dataset-id}/fhirStores/{
	// fhirStore-id}/fhir/SearchParameter/{resource-id}/_history/{version-id} For
	// fhir stores with disable_resource_versioning=true, the format is
	// projects/{project-id}/locations/{location}/datasets/{dataset-id}/fhirStores/{
	// fhirStore-id}/fhir/SearchParameter/{resource-id}/
	Parameter string `json:"parameter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CanonicalUrl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CanonicalUrl") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchParameter) MarshalJSON() ([]byte, error) {
	type NoMethod SearchParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchResourcesRequest: Request to search the resources in the specified
// FHIR store.
type SearchResourcesRequest struct {
	// ResourceType: Required. The FHIR resource type to search, such as Patient or
	// Observation. For a complete list, see the FHIR Resource Index (DSTU2
	// (https://hl7.org/implement/standards/fhir/DSTU2/resourcelist.html), STU3
	// (https://hl7.org/implement/standards/fhir/STU3/resourcelist.html), R4
	// (https://hl7.org/implement/standards/fhir/R4/resourcelist.html)).
	ResourceType string `json:"resourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResourceType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResourceType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchResourcesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SearchResourcesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Segment: A segment in a structured format.
type Segment struct {
	// Fields: A mapping from the positional location to the value. The key string
	// uses zero-based indexes separated by dots to identify Fields, components and
	// sub-components. A bracket notation is also used to identify different
	// instances of a repeated field. Regex for key: (\d+)(\[\d+\])?(.\d+)?(.\d+)?
	// Examples of (key, value) pairs: * (0.1, "hemoglobin") denotes that the first
	// component of Field 0 has the value "hemoglobin". * (1.1.2, "CBC") denotes
	// that the second sub-component of the first component of Field 1 has the
	// value "CBC". * (1[0].1, "HbA1c") denotes that the first component of the
	// first Instance of Field 1, which is repeated, has the value "HbA1c".
	Fields map[string]string `json:"fields,omitempty"`
	// SegmentId: A string that indicates the type of segment. For example, EVN or
	// PID.
	SegmentId string `json:"segmentId,omitempty"`
	// SetId: Set ID for segments that can be in a set. This can be empty if it's
	// missing or isn't applicable.
	SetId string `json:"setId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Fields") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Fields") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Segment) MarshalJSON() ([]byte, error) {
	type NoMethod Segment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SensitiveTextAnnotation: A TextAnnotation specifies a text range that
// includes sensitive information.
type SensitiveTextAnnotation struct {
	// Details: Maps from a resource slice. For example, FHIR resource field path
	// to a set of sensitive text findings. For example, Appointment.Narrative
	// text1 --> {findings_1, findings_2, findings_3}
	Details map[string]Detail `json:"details,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Details") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Details") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SensitiveTextAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod SensitiveTextAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SeriesMetrics: SeriesMetrics contains metrics describing a DICOM series.
type SeriesMetrics struct {
	// BlobStorageSizeBytes: Total blob storage bytes for all instances in the
	// series.
	BlobStorageSizeBytes int64 `json:"blobStorageSizeBytes,omitempty,string"`
	// InstanceCount: Number of instances in the series.
	InstanceCount int64 `json:"instanceCount,omitempty,string"`
	// Series: The series resource path. For example,
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomSto
	// res/{dicom_store_id}/dicomWeb/studies/{study_uid}/series/{series_uid}`.
	Series string `json:"series,omitempty"`
	// StructuredStorageSizeBytes: Total structured storage bytes for all instances
	// in the series.
	StructuredStorageSizeBytes int64 `json:"structuredStorageSizeBytes,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BlobStorageSizeBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlobStorageSizeBytes") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SeriesMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod SeriesMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetBlobStorageSettingsRequest: Request message for `SetBlobStorageSettings`
// method.
type SetBlobStorageSettingsRequest struct {
	// BlobStorageSettings: The blob storage settings to update for the specified
	// resources. Only fields listed in `update_mask` are applied.
	BlobStorageSettings *BlobStorageSettings `json:"blobStorageSettings,omitempty"`
	// FilterConfig: Optional. A filter configuration. If `filter_config` is
	// specified, set the value of `resource` to the resource name of a DICOM store
	// in the format
	// `projects/{projectID}/locations/{locationID}/datasets/{datasetID}/dicomStores
	// /{dicomStoreID}`.
	FilterConfig *DicomFilterConfig `json:"filterConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlobStorageSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlobStorageSettings") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetBlobStorageSettingsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetBlobStorageSettingsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetBlobStorageSettingsResponse: Returns additional info in regards to a
// completed set blob storage settings API.
type SetBlobStorageSettingsResponse struct {
}

// SetIamPolicyRequest: Request message for `SetIamPolicy` method.
type SetIamPolicyRequest struct {
	// Policy: REQUIRED: The complete policy to be applied to the `resource`. The
	// size of the policy is limited to a few 10s of KB. An empty policy is a valid
	// policy but certain Google Cloud services (such as Projects) might reject
	// them.
	Policy *Policy `json:"policy,omitempty"`
	// UpdateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
	// modify. Only the fields in the mask will be modified. If no mask is
	// provided, the following default mask is used: `paths: "bindings, etag"
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Policy") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetIamPolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Signature: User signature.
type Signature struct {
	// Image: Optional. An image of the user's signature.
	Image *Image `json:"image,omitempty"`
	// Metadata: Optional. Metadata associated with the user's signature. For
	// example, the user's name or the user's title.
	Metadata map[string]string `json:"metadata,omitempty"`
	// SignatureTime: Optional. Timestamp of the signature.
	SignatureTime string `json:"signatureTime,omitempty"`
	// UserId: Required. User's UUID provided by the client.
	UserId string `json:"userId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Image") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Image") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Signature) MarshalJSON() ([]byte, error) {
	type NoMethod Signature
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StorageInfo: StorageInfo encapsulates all the storage info of a resource.
type StorageInfo struct {
	// BlobStorageInfo: Info about the data stored in blob storage for the
	// resource.
	BlobStorageInfo *BlobStorageInfo `json:"blobStorageInfo,omitempty"`
	// ReferencedResource: The resource whose storage info is returned. For
	// example:
	// `projects/{projectID}/locations/{locationID}/datasets/{datasetID}/dicomStores
	// /{dicomStoreID}/dicomWeb/studies/{studyUID}/series/{seriesUID}/instances/{ins
	// tanceUID}`
	ReferencedResource string `json:"referencedResource,omitempty"`
	// StructuredStorageInfo: Info about the data stored in structured storage for
	// the resource.
	StructuredStorageInfo *StructuredStorageInfo `json:"structuredStorageInfo,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BlobStorageInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlobStorageInfo") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StorageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod StorageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StreamConfig: Contains configuration for streaming FHIR export.
type StreamConfig struct {
	// BigqueryDestination: The destination BigQuery structure that contains both
	// the dataset location and corresponding schema config. The output is
	// organized in one table per resource type. The server reuses the existing
	// tables (if any) that are named after the resource types, e.g. "Patient",
	// "Observation". When there is no existing table for a given resource type,
	// the server attempts to create one. When a table schema doesn't align with
	// the schema config, either because of existing incompatible schema or out of
	// band incompatible modification, the server does not stream in new data. One
	// resolution in this case is to delete the incompatible table and let the
	// server recreate one, though the newly created table only contains data after
	// the table recreation. BigQuery imposes a 1 MB limit on streaming insert row
	// size, therefore any resource mutation that generates more than 1 MB of
	// BigQuery data will not be streamed. Results are written to BigQuery tables
	// according to the parameters in BigQueryDestination.WriteDisposition.
	// Different versions of the same resource are distinguishable by the
	// meta.versionId and meta.lastUpdated columns. The operation
	// (CREATE/UPDATE/DELETE) that results in the new version is recorded in the
	// meta.tag. The tables contain all historical resource versions since
	// streaming was enabled. For query convenience, the server also creates one
	// view per table of the same name containing only the current resource
	// version. The streamed data in the BigQuery dataset is not guaranteed to be
	// completely unique. The combination of the id and meta.versionId columns
	// should ideally identify a single unique row. But in rare cases, duplicates
	// may exist. At query time, users may use the SQL select statement to keep
	// only one of the duplicate rows given an id and meta.versionId pair.
	// Alternatively, the server created view mentioned above also filters out
	// duplicates. If a resource mutation cannot be streamed to BigQuery, errors
	// will be logged to Cloud Logging (see Viewing error logs in Cloud Logging
	// (https://cloud.google.com/healthcare/docs/how-tos/logging)).
	BigqueryDestination *GoogleCloudHealthcareV1beta1FhirBigQueryDestination `json:"bigqueryDestination,omitempty"`
	// DeidentifiedStoreDestination: The destination FHIR store for de-identified
	// resources. After this field is added, all subsequent creates/updates/patches
	// to the source store will be de-identified using the provided configuration
	// and applied to the destination store. Resources deleted from the source
	// store will be deleted from the destination store. Importing resources to the
	// source store will not trigger the streaming. If the source store already
	// contains resources when this option is enabled, those resources will not be
	// copied to the destination store unless they are subsequently updated. This
	// may result in invalid references in the destination store. Before adding
	// this config, you must grant the healthcare.fhirResources.update permission
	// on the destination store to your project's **Cloud Healthcare Service
	// Agent** service account
	// (https://cloud.google.com/healthcare/docs/how-tos/permissions-healthcare-api-gcp-products#the_cloud_healthcare_service_agent).
	// The destination store must set enable_update_create to true. The destination
	// store must have disable_referential_integrity set to true. If a resource
	// cannot be de-identified, errors will be logged to Cloud Logging (see Viewing
	// error logs in Cloud Logging
	// (https://cloud.google.com/healthcare/docs/how-tos/logging)).
	DeidentifiedStoreDestination *DeidentifiedStoreDestination `json:"deidentifiedStoreDestination,omitempty"`
	// ResourceTypes: Supply a FHIR resource type (such as "Patient" or
	// "Observation"). See https://www.hl7.org/fhir/valueset-resource-types.html
	// for a list of all FHIR resource types. The server treats an empty list as an
	// intent to stream all the supported resource types in this FHIR store.
	ResourceTypes []string `json:"resourceTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigqueryDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigqueryDestination") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StreamConfig) MarshalJSON() ([]byte, error) {
	type NoMethod StreamConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StructuredStorageInfo: StructuredStorageInfo contains details about the data
// stored in Structured Storage for the referenced resource.
type StructuredStorageInfo struct {
	// SizeBytes: Size in bytes of data stored in structured storage.
	SizeBytes int64 `json:"sizeBytes,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "SizeBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SizeBytes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StructuredStorageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod StructuredStorageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StudyMetrics: StudyMetrics contains metrics describing a DICOM study.
type StudyMetrics struct {
	// BlobStorageSizeBytes: Total blob storage bytes for all instances in the
	// study.
	BlobStorageSizeBytes int64 `json:"blobStorageSizeBytes,omitempty,string"`
	// InstanceCount: Number of instances in the study.
	InstanceCount int64 `json:"instanceCount,omitempty,string"`
	// SeriesCount: Number of series in the study.
	SeriesCount int64 `json:"seriesCount,omitempty,string"`
	// StructuredStorageSizeBytes: Total structured storage bytes for all instances
	// in the study.
	StructuredStorageSizeBytes int64 `json:"structuredStorageSizeBytes,omitempty,string"`
	// Study: The study resource path. For example,
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomSto
	// res/{dicom_store_id}/dicomWeb/studies/{study_uid}`.
	Study string `json:"study,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BlobStorageSizeBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlobStorageSizeBytes") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StudyMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod StudyMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TagFilterList: List of tags to be filtered.
type TagFilterList struct {
	// Tags: Tags to be filtered. Tags must be DICOM Data Elements, File Meta
	// Elements, or Directory Structuring Elements, as defined at:
	// http://dicom.nema.org/medical/dicom/current/output/html/part06.html#table_6-1,.
	// They may be provided by "Keyword" or "Tag". For example, "PatientID",
	// "00100010".
	Tags []string `json:"tags,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Tags") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Tags") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TagFilterList) MarshalJSON() ([]byte, error) {
	type NoMethod TagFilterList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsRequest: Request message for `TestIamPermissions` method.
type TestIamPermissionsRequest struct {
	// Permissions: The set of permissions to check for the `resource`. Permissions
	// with wildcards (such as `*` or `storage.*`) are not allowed. For more
	// information see IAM Overview
	// (https://cloud.google.com/iam/docs/overview#permissions).
	Permissions []string `json:"permissions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestIamPermissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsResponse: Response message for `TestIamPermissions`
// method.
type TestIamPermissionsResponse struct {
	// Permissions: A subset of `TestPermissionsRequest.permissions` that the
	// caller is allowed.
	Permissions []string `json:"permissions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestIamPermissionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TextConfig: Configures how to transform sensitive text `InfoTypes`.
type TextConfig struct {
	// AdditionalTransformations: Additional transformations to apply to the
	// detected data, overriding `profile`.
	AdditionalTransformations []*InfoTypeTransformation `json:"additionalTransformations,omitempty"`
	// ExcludeInfoTypes: InfoTypes to skip transforming, overriding `profile`.
	ExcludeInfoTypes []string `json:"excludeInfoTypes,omitempty"`
	// ProfileType: Base profile type for text transformation.
	//
	// Possible values:
	//   "PROFILE_TYPE_UNSPECIFIED" - No profile provided. Same as BASIC.
	//   "EMPTY" - Empty profile which does not perform any transformations.
	//   "BASIC" - Automatically converts "DATE" infoTypes using a DateShiftConfig,
	// and all other infoTypes using a ReplaceWithInfoTypeConfig.
	ProfileType string `json:"profileType,omitempty"`
	// Transformations: The transformations to apply to the detected data.
	// Deprecated. Use `additional_transformations` instead.
	Transformations []*InfoTypeTransformation `json:"transformations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalTransformations")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalTransformations") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TextConfig) MarshalJSON() ([]byte, error) {
	type NoMethod TextConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TextSpan: A span of text in the provided document.
type TextSpan struct {
	// BeginOffset: The unicode codepoint index of the beginning of this span.
	BeginOffset int64 `json:"beginOffset,omitempty"`
	// Content: The original text contained in this span.
	Content string `json:"content,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BeginOffset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BeginOffset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TextSpan) MarshalJSON() ([]byte, error) {
	type NoMethod TextSpan
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TimePartitioning: Configuration for FHIR BigQuery time-partitioned tables.
type TimePartitioning struct {
	// ExpirationMs: Number of milliseconds for which to keep the storage for a
	// partition.
	ExpirationMs int64 `json:"expirationMs,omitempty,string"`
	// Type: Type of partitioning.
	//
	// Possible values:
	//   "PARTITION_TYPE_UNSPECIFIED" - Default unknown time.
	//   "HOUR" - Data partitioned by hour.
	//   "DAY" - Data partitioned by day.
	//   "MONTH" - Data partitioned by month.
	//   "YEAR" - Data partitioned by year.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExpirationMs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExpirationMs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TimePartitioning) MarshalJSON() ([]byte, error) {
	type NoMethod TimePartitioning
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TimeRange: Apply consents given by patients whose most recent consent
// changes are in the time range. Note that after identifying these patients,
// the server applies all Consent resources given by those patients, not just
// the Consent resources within the timestamp in the range.
type TimeRange struct {
	// End: Optional. The latest consent change time, in format
	// YYYY-MM-DDThh:mm:ss.sss+zz:zz If not specified, the system uses the time
	// when ApplyConsents was called.
	End string `json:"end,omitempty"`
	// Start: Optional. The earliest consent change time, in format
	// YYYY-MM-DDThh:mm:ss.sss+zz:zz If not specified, the system uses the FHIR
	// store creation time.
	Start string `json:"start,omitempty"`
	// ForceSendFields is a list of field names (e.g. "End") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "End") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TimeRange) MarshalJSON() ([]byte, error) {
	type NoMethod TimeRange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Type: A type definition for some HL7v2 type (incl. Segments and Datatypes).
type Type struct {
	// Fields: The (sub) fields this type has (if not primitive).
	Fields []*Field `json:"fields,omitempty"`
	// Name: The name of this type. This would be the segment or datatype name. For
	// example, "PID" or "XPN".
	Name string `json:"name,omitempty"`
	// Primitive: If this is a primitive type then this field is the type of the
	// primitive For example, STRING. Leave unspecified for composite types.
	//
	// Possible values:
	//   "PRIMITIVE_UNSPECIFIED" - Not a primitive.
	//   "STRING" - String primitive.
	//   "VARIES" - Element that can have unschematized children.
	//   "UNESCAPED_STRING" - Like STRING, but all delimiters below this element
	// are ignored.
	Primitive string `json:"primitive,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Fields") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Fields") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Type) MarshalJSON() ([]byte, error) {
	type NoMethod Type
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UserDataMapping: Maps a resource to the associated user and Attributes.
type UserDataMapping struct {
	// ArchiveTime: Output only. Indicates the time when this mapping was archived.
	ArchiveTime string `json:"archiveTime,omitempty"`
	// Archived: Output only. Indicates whether this mapping is archived.
	Archived bool `json:"archived,omitempty"`
	// DataId: Required. A unique identifier for the mapped resource.
	DataId string `json:"dataId,omitempty"`
	// Name: Resource name of the User data mapping, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentS
	// tores/{consent_store_id}/userDataMappings/{user_data_mapping_id}`.
	Name string `json:"name,omitempty"`
	// ResourceAttributes: Attributes of the resource. Only explicitly set
	// attributes are displayed here. Attribute definitions with defaults set
	// implicitly apply to these User data mappings. Attributes listed here must be
	// single valued, that is, exactly one value is specified for the field
	// "values" in each Attribute.
	ResourceAttributes []*Attribute `json:"resourceAttributes,omitempty"`
	// UserId: Required. User's UUID provided by the client.
	UserId string `json:"userId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ArchiveTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArchiveTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserDataMapping) MarshalJSON() ([]byte, error) {
	type NoMethod UserDataMapping
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ValidationConfig: Contains the configuration for FHIR profiles and
// validation.
type ValidationConfig struct {
	// DisableFhirpathValidation: Whether to disable FHIRPath validation for
	// incoming resources. The default value is false. Set this to true to disable
	// checking incoming resources for conformance against FHIRPath requirement
	// defined in the FHIR specification. This property only affects resource types
	// that do not have profiles configured for them, any rules in enabled
	// implementation guides will still be enforced.
	DisableFhirpathValidation bool `json:"disableFhirpathValidation,omitempty"`
	// DisableProfileValidation: Whether to disable profile validation for this
	// FHIR store. The default value is false. Set this to true to disable checking
	// incoming resources for conformance against StructureDefinitions in this FHIR
	// store.
	DisableProfileValidation bool `json:"disableProfileValidation,omitempty"`
	// DisableReferenceTypeValidation: Whether to disable reference type validation
	// for incoming resources. The default value is false. Set this to true to
	// disable checking incoming resources for conformance against reference type
	// requirement defined in the FHIR specification. This property only affects
	// resource types that do not have profiles configured for them, any rules in
	// enabled implementation guides will still be enforced.
	DisableReferenceTypeValidation bool `json:"disableReferenceTypeValidation,omitempty"`
	// DisableRequiredFieldValidation: Whether to disable required fields
	// validation for incoming resources. The default value is false. Set this to
	// true to disable checking incoming resources for conformance against required
	// fields requirement defined in the FHIR specification. This property only
	// affects resource types that do not have profiles configured for them, any
	// rules in enabled implementation guides will still be enforced.
	DisableRequiredFieldValidation bool `json:"disableRequiredFieldValidation,omitempty"`
	// EnabledImplementationGuides: A list of ImplementationGuide URLs in this FHIR
	// store that are used to configure the profiles to use for validation. For
	// example, to use the US Core profiles for validation, set
	// `enabled_implementation_guides` to
	// `["http://hl7.org/fhir/us/core/ImplementationGuide/ig"]`. If
	// `enabled_implementation_guides` is empty or omitted, then incoming resources
	// are only required to conform to the base FHIR profiles. Otherwise, a
	// resource must conform to at least one profile listed in the `global`
	// property of one of the enabled ImplementationGuides. The Cloud Healthcare
	// API does not currently enforce all of the rules in a StructureDefinition.
	// The following rules are supported: - min/max - minValue/maxValue - maxLength
	// - type - fixed[x] - pattern[x] on simple types - slicing, when using "value"
	// as the discriminator type When a URL cannot be resolved (for example, in a
	// type assertion), the server does not return an error.
	EnabledImplementationGuides []string `json:"enabledImplementationGuides,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisableFhirpathValidation")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisableFhirpathValidation") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ValidationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ValidationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VersionSource: Describes a selector for extracting and matching an MSH field
// to a value.
type VersionSource struct {
	// MshField: The field to extract from the MSH segment. For example, "3.1" or
	// "18[1].1".
	MshField string `json:"mshField,omitempty"`
	// Value: The value to match with the field. For example, "My Application Name"
	// or "2.3".
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MshField") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MshField") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VersionSource) MarshalJSON() ([]byte, error) {
	type NoMethod VersionSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Vertex: A 2D coordinate in an image. The origin is the top-left.
type Vertex struct {
	// X: X coordinate.
	X float64 `json:"x,omitempty"`
	// Y: Y coordinate.
	Y float64 `json:"y,omitempty"`
	// ForceSendFields is a list of field names (e.g. "X") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "X") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Vertex) MarshalJSON() ([]byte, error) {
	type NoMethod Vertex
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *Vertex) UnmarshalJSON(data []byte) error {
	type NoMethod Vertex
	var s1 struct {
		X gensupport.JSONFloat64 `json:"x"`
		Y gensupport.JSONFloat64 `json:"y"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.X = float64(s1.X)
	s.Y = float64(s1.Y)
	return nil
}

type ProjectsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *ProjectsLocationsService) Get(name string) *ProjectsLocationsGetCall {
	c := &ProjectsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetCall) Context(ctx context.Context) *ProjectsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Location.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGetCall) Do(opts ...googleapi.CallOption) (*Location, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Location{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this service.
//
// - name: The resource that owns the locations collection, if applicable.
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. The filtering language accepts strings like
// "displayName=tokyo", and is documented in more detail in AIP-160
// (https://google.aip.dev/160).
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the `next_page_token` field in the response. Send that page token to
// receive the subsequent page.
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLocationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*ListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*ListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDatasetsCreateCall struct {
	s          *Service
	parent     string
	dataset    *Dataset
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new health dataset. Results are returned through the
// Operation interface which returns either an `Operation.response` which
// contains a Dataset or `Operation.error`. The metadata field type is
// OperationMetadata.
//
//   - parent: The name of the project where the server creates the dataset. For
//     example, `projects/{project_id}/locations/{location_id}`.
func (r *ProjectsLocationsDatasetsService) Create(parent string, dataset *Dataset) *ProjectsLocationsDatasetsCreateCall {
	c := &ProjectsLocationsDatasetsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dataset = dataset
	return c
}

// DatasetId sets the optional parameter "datasetId": Required. The ID of the
// dataset that is being created. The string must match the following regex:
// `[\p{L}\p{N}_\-\.]{1,256}`.
func (c *ProjectsLocationsDatasetsCreateCall) DatasetId(datasetId string) *ProjectsLocationsDatasetsCreateCall {
	c.urlParams_.Set("datasetId", datasetId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsCreateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.dataset)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/datasets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsDeidentifyCall struct {
	s                        *Service
	sourceDataset            string
	deidentifydatasetrequest *DeidentifyDatasetRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// Deidentify: Creates a new dataset containing de-identified data from the
// source dataset. The metadata field type is OperationMetadata. If the request
// is successful, the response field type is DeidentifySummary. The LRO result
// may still be successful if de-identification fails for some resources. The
// new de-identified dataset will not contain these failed resources. The
// number of resources processed are tracked in Operation.metadata. Error
// details are logged to Cloud Logging. For more information, see Viewing error
// logs in Cloud Logging
// (https://cloud.google.com/healthcare/docs/how-tos/logging).
//
//   - sourceDataset: Source dataset resource name. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
func (r *ProjectsLocationsDatasetsService) Deidentify(sourceDataset string, deidentifydatasetrequest *DeidentifyDatasetRequest) *ProjectsLocationsDatasetsDeidentifyCall {
	c := &ProjectsLocationsDatasetsDeidentifyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.sourceDataset = sourceDataset
	c.deidentifydatasetrequest = deidentifydatasetrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDeidentifyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDeidentifyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDeidentifyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDeidentifyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDeidentifyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDeidentifyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.deidentifydatasetrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+sourceDataset}:deidentify")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"sourceDataset": c.sourceDataset,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.deidentify" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDeidentifyCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified health dataset and all data contained in the
// dataset. Deleting a dataset does not affect the sources from which the
// dataset was imported (if any).
//
//   - name: The name of the dataset to delete. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
func (r *ProjectsLocationsDatasetsService) Delete(name string) *ProjectsLocationsDatasetsDeleteCall {
	c := &ProjectsLocationsDatasetsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets any metadata associated with a dataset.
//
//   - name: The name of the dataset to read. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
func (r *ProjectsLocationsDatasetsService) Get(name string) *ProjectsLocationsDatasetsGetCall {
	c := &ProjectsLocationsDatasetsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsGetCall) Context(ctx context.Context) *ProjectsLocationsDatasetsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Dataset.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsGetCall) Do(opts ...googleapi.CallOption) (*Dataset, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Dataset{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsDatasetsService) GetIamPolicy(resource string) *ProjectsLocationsDatasetsGetIamPolicyCall {
	c := &ProjectsLocationsDatasetsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsDatasetsGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsDatasetsGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the health datasets in the current project.
//
//   - parent: The name of the project whose datasets should be listed. For
//     example, `projects/{project_id}/locations/{location_id}`.
func (r *ProjectsLocationsDatasetsService) List(parent string) *ProjectsLocationsDatasetsListCall {
	c := &ProjectsLocationsDatasetsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return. If not specified, 100 is used. May not be larger than 1000.
func (c *ProjectsLocationsDatasetsListCall) PageSize(pageSize int64) *ProjectsLocationsDatasetsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from a previous List request, if any.
func (c *ProjectsLocationsDatasetsListCall) PageToken(pageToken string) *ProjectsLocationsDatasetsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsListCall) Context(ctx context.Context) *ProjectsLocationsDatasetsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/datasets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDatasetsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsListCall) Do(opts ...googleapi.CallOption) (*ListDatasetsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDatasetsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDatasetsListCall) Pages(ctx context.Context, f func(*ListDatasetsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDatasetsPatchCall struct {
	s          *Service
	name       string
	dataset    *Dataset
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates dataset metadata.
//
//   - name: Identifier. Resource name of the dataset, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
func (r *ProjectsLocationsDatasetsService) Patch(name string, dataset *Dataset) *ProjectsLocationsDatasetsPatchCall {
	c := &ProjectsLocationsDatasetsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.dataset = dataset
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The update
// mask applies to the resource. For the `FieldMask` definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
func (c *ProjectsLocationsDatasetsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsDatasetsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsPatchCall) Context(ctx context.Context) *ProjectsLocationsDatasetsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.dataset)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Dataset.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsPatchCall) Do(opts ...googleapi.CallOption) (*Dataset, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Dataset{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsDatasetsService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsDatasetsSetIamPolicyCall {
	c := &ProjectsLocationsDatasetsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsDatasetsService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsDatasetsTestIamPermissionsCall {
	c := &ProjectsLocationsDatasetsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsAnnotationStoresCreateCall struct {
	s               *Service
	parent          string
	annotationstore *AnnotationStore
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Create: Creates a new Annotation store within the parent dataset.
//
// - parent: The name of the dataset this Annotation store belongs to.
func (r *ProjectsLocationsDatasetsAnnotationStoresService) Create(parent string, annotationstore *AnnotationStore) *ProjectsLocationsDatasetsAnnotationStoresCreateCall {
	c := &ProjectsLocationsDatasetsAnnotationStoresCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.annotationstore = annotationstore
	return c
}

// AnnotationStoreId sets the optional parameter "annotationStoreId": Required.
// The ID of the Annotation store that is being created. The string must match
// the following regex: `[\p{L}\p{N}_\-\.]{1,256}`.
func (c *ProjectsLocationsDatasetsAnnotationStoresCreateCall) AnnotationStoreId(annotationStoreId string) *ProjectsLocationsDatasetsAnnotationStoresCreateCall {
	c.urlParams_.Set("annotationStoreId", annotationStoreId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsAnnotationStoresCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsAnnotationStoresCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsAnnotationStoresCreateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsAnnotationStoresCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsAnnotationStoresCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsAnnotationStoresCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.annotationstore)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/annotationStores")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.annotationStores.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *AnnotationStore.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsAnnotationStoresCreateCall) Do(opts ...googleapi.CallOption) (*AnnotationStore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AnnotationStore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsAnnotationStoresDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified Annotation store and removes all annotations
// that are contained within it.
//
// - name: The resource name of the Annotation store to delete.
func (r *ProjectsLocationsDatasetsAnnotationStoresService) Delete(name string) *ProjectsLocationsDatasetsAnnotationStoresDeleteCall {
	c := &ProjectsLocationsDatasetsAnnotationStoresDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsAnnotationStoresDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsAnnotationStoresDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsAnnotationStoresDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsAnnotationStoresDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsAnnotationStoresDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsAnnotationStoresDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.annotationStores.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsAnnotationStoresDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsAnnotationStoresEvaluateCall struct {
	s                              *Service
	name                           string
	evaluateannotationstorerequest *EvaluateAnnotationStoreRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// Evaluate: Evaluate an Annotation store against a ground truth Annotation
// store. When the operation finishes successfully, a detailed response is
// returned of type EvaluateAnnotationStoreResponse, contained in the response.
// The metadata field type is OperationMetadata. Errors are logged to Cloud
// Logging (see Viewing error logs in Cloud Logging
// (https://cloud.google.com/healthcare/docs/how-tos/logging)).
//
//   - name: The Annotation store to compare against `golden_store`, in the
//     format of
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/annota
//     tionStores/{annotation_store_id}`.
func (r *ProjectsLocationsDatasetsAnnotationStoresService) Evaluate(name string, evaluateannotationstorerequest *EvaluateAnnotationStoreRequest) *ProjectsLocationsDatasetsAnnotationStoresEvaluateCall {
	c := &ProjectsLocationsDatasetsAnnotationStoresEvaluateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.evaluateannotationstorerequest = evaluateannotationstorerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsAnnotationStoresEvaluateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsAnnotationStoresEvaluateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsAnnotationStoresEvaluateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsAnnotationStoresEvaluateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsAnnotationStoresEvaluateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsAnnotationStoresEvaluateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.evaluateannotationstorerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:evaluate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.annotationStores.evaluate" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsAnnotationStoresEvaluateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsAnnotationStoresExportCall struct {
	s                        *Service
	name                     string
	exportannotationsrequest *ExportAnnotationsRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// Export: Export Annotations from the Annotation store. If the request is
// successful, a detailed response is returned of type
// ExportAnnotationsResponse, contained in the response field when the
// operation finishes. The metadata field type is OperationMetadata. Errors are
// logged to Cloud Logging (see Viewing error logs in Cloud Logging
// (https://cloud.google.com/healthcare/docs/how-tos/logging)).
//
//   - name: The name of the Annotation store to export annotations to, in the
//     format of
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/annota
//     tionStores/{annotation_store_id}`.
func (r *ProjectsLocationsDatasetsAnnotationStoresService) Export(name string, exportannotationsrequest *ExportAnnotationsRequest) *ProjectsLocationsDatasetsAnnotationStoresExportCall {
	c := &ProjectsLocationsDatasetsAnnotationStoresExportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.exportannotationsrequest = exportannotationsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsAnnotationStoresExportCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsAnnotationStoresExportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsAnnotationStoresExportCall) Context(ctx context.Context) *ProjectsLocationsDatasetsAnnotationStoresExportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsAnnotationStoresExportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsAnnotationStoresExportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.exportannotationsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:export")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.annotationStores.export" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsAnnotationStoresExportCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsAnnotationStoresGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified Annotation store or returns NOT_FOUND if it does not
// exist.
//
// - name: The resource name of the Annotation store to get.
func (r *ProjectsLocationsDatasetsAnnotationStoresService) Get(name string) *ProjectsLocationsDatasetsAnnotationStoresGetCall {
	c := &ProjectsLocationsDatasetsAnnotationStoresGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsAnnotationStoresGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsAnnotationStoresGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsAnnotationStoresGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsAnnotationStoresGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsAnnotationStoresGetCall) Context(ctx context.Context) *ProjectsLocationsDatasetsAnnotationStoresGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsAnnotationStoresGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsAnnotationStoresGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.annotationStores.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *AnnotationStore.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsAnnotationStoresGetCall) Do(opts ...googleapi.CallOption) (*AnnotationStore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AnnotationStore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsAnnotationStoresGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsDatasetsAnnotationStoresService) GetIamPolicy(resource string) *ProjectsLocationsDatasetsAnnotationStoresGetIamPolicyCall {
	c := &ProjectsLocationsDatasetsAnnotationStoresGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsDatasetsAnnotationStoresGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsDatasetsAnnotationStoresGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsAnnotationStoresGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsAnnotationStoresGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsAnnotationStoresGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsAnnotationStoresGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsAnnotationStoresGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsAnnotationStoresGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsAnnotationStoresGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsAnnotationStoresGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.annotationStores.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsAnnotationStoresGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsAnnotationStoresImportCall struct {
	s                        *Service
	name                     string
	importannotationsrequest *ImportAnnotationsRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// Import: Import Annotations to the Annotation store by loading data from the
// specified sources. If the request is successful, a detailed response is
// returned as of type ImportAnnotationsResponse, contained in the response
// field when the operation finishes. The metadata field type is
// OperationMetadata. Errors are logged to Cloud Logging (see Viewing error
// logs in Cloud Logging
// (https://cloud.google.com/healthcare/docs/how-tos/logging)).
//
//   - name: The name of the Annotation store to which the server imports
//     annotations, in the format
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/annota
//     tionStores/{annotation_store_id}`.
func (r *ProjectsLocationsDatasetsAnnotationStoresService) Import(name string, importannotationsrequest *ImportAnnotationsRequest) *ProjectsLocationsDatasetsAnnotationStoresImportCall {
	c := &ProjectsLocationsDatasetsAnnotationStoresImportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.importannotationsrequest = importannotationsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsAnnotationStoresImportCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsAnnotationStoresImportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsAnnotationStoresImportCall) Context(ctx context.Context) *ProjectsLocationsDatasetsAnnotationStoresImportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsAnnotationStoresImportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsAnnotationStoresImportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.importannotationsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:import")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.annotationStores.import" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsAnnotationStoresImportCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsAnnotationStoresListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the Annotation stores in the given dataset for a source store.
//
// - parent: Name of the dataset.
func (r *ProjectsLocationsDatasetsAnnotationStoresService) List(parent string) *ProjectsLocationsDatasetsAnnotationStoresListCall {
	c := &ProjectsLocationsDatasetsAnnotationStoresListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Restricts stores returned to
// those matching a filter. The following syntax is available: * A string field
// value can be written as text inside quotation marks, for example "query
// text". The only valid relational operation for text fields is equality
// (`=`), where text is searched within the field, rather than having the field
// be equal to the text. For example, "Comment = great" returns messages with
// `great` in the comment field. * A number field value can be written as an
// integer, a decimal, or an exponential. The valid relational operators for
// number fields are the equality operator (`=`), along with the less
// than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no
// inequality (`!=`) operator. You can prepend the `NOT` operator to an
// expression to negate it. * A date field value must be written in
// `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format.
// Leading zeros are required for one-digit months and days. The valid
// relational operators for date fields are the equality operator (`=`) , along
// with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that
// there is no inequality (`!=`) operator. You can prepend the `NOT` operator
// to an expression to negate it. * Multiple field query expressions can be
// combined in one query by adding `AND` or `OR` operators between the
// expressions. If a boolean operator appears within a quoted string, it is not
// treated as special, it's just another part of the character string to be
// matched. You can prepend the `NOT` operator to an expression to negate it.
// Only filtering on labels is supported, for example `labels.key=value`.
func (c *ProjectsLocationsDatasetsAnnotationStoresListCall) Filter(filter string) *ProjectsLocationsDatasetsAnnotationStoresListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Limit on the number of
// Annotation stores to return in a single response. If not specified, 100 is
// used. May not be larger than 1000.
func (c *ProjectsLocationsDatasetsAnnotationStoresListCall) PageSize(pageSize int64) *ProjectsLocationsDatasetsAnnotationStoresListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from the previous List request, if any.
func (c *ProjectsLocationsDatasetsAnnotationStoresListCall) PageToken(pageToken string) *ProjectsLocationsDatasetsAnnotationStoresListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsAnnotationStoresListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsAnnotationStoresListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsAnnotationStoresListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsAnnotationStoresListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsAnnotationStoresListCall) Context(ctx context.Context) *ProjectsLocationsDatasetsAnnotationStoresListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsAnnotationStoresListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsAnnotationStoresListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/annotationStores")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.annotationStores.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAnnotationStoresResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsAnnotationStoresListCall) Do(opts ...googleapi.CallOption) (*ListAnnotationStoresResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAnnotationStoresResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDatasetsAnnotationStoresListCall) Pages(ctx context.Context, f func(*ListAnnotationStoresResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDatasetsAnnotationStoresPatchCall struct {
	s               *Service
	name            string
	annotationstore *AnnotationStore
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Patch: Updates the specified Annotation store.
//
//   - name: Identifier. Resource name of the Annotation store, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/annota
//     tionStores/{annotation_store_id}`.
func (r *ProjectsLocationsDatasetsAnnotationStoresService) Patch(name string, annotationstore *AnnotationStore) *ProjectsLocationsDatasetsAnnotationStoresPatchCall {
	c := &ProjectsLocationsDatasetsAnnotationStoresPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.annotationstore = annotationstore
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The update
// mask applies to the resource. For the `FieldMask` definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
func (c *ProjectsLocationsDatasetsAnnotationStoresPatchCall) UpdateMask(updateMask string) *ProjectsLocationsDatasetsAnnotationStoresPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsAnnotationStoresPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsAnnotationStoresPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsAnnotationStoresPatchCall) Context(ctx context.Context) *ProjectsLocationsDatasetsAnnotationStoresPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsAnnotationStoresPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsAnnotationStoresPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.annotationstore)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.annotationStores.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *AnnotationStore.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsAnnotationStoresPatchCall) Do(opts ...googleapi.CallOption) (*AnnotationStore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AnnotationStore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsAnnotationStoresSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsDatasetsAnnotationStoresService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsDatasetsAnnotationStoresSetIamPolicyCall {
	c := &ProjectsLocationsDatasetsAnnotationStoresSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsAnnotationStoresSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsAnnotationStoresSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsAnnotationStoresSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsAnnotationStoresSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsAnnotationStoresSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsAnnotationStoresSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.annotationStores.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsAnnotationStoresSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsAnnotationStoresTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsDatasetsAnnotationStoresService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsDatasetsAnnotationStoresTestIamPermissionsCall {
	c := &ProjectsLocationsDatasetsAnnotationStoresTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsAnnotationStoresTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsAnnotationStoresTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsAnnotationStoresTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsAnnotationStoresTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsAnnotationStoresTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsAnnotationStoresTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.annotationStores.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsAnnotationStoresTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsAnnotationStoresAnnotationsCreateCall struct {
	s          *Service
	parent     string
	annotation *Annotation
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new Annotation record. It is valid to create Annotation
// objects for the same source more than once since a unique ID is assigned to
// each record by this service.
//
//   - parent: The name of the Annotation store this annotation belongs to. For
//     example,
//     `projects/my-project/locations/us-central1/datasets/mydataset/annotationSto
//     res/myannotationstore`.
func (r *ProjectsLocationsDatasetsAnnotationStoresAnnotationsService) Create(parent string, annotation *Annotation) *ProjectsLocationsDatasetsAnnotationStoresAnnotationsCreateCall {
	c := &ProjectsLocationsDatasetsAnnotationStoresAnnotationsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.annotation = annotation
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsAnnotationStoresAnnotationsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsCreateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsAnnotationStoresAnnotationsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.annotation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/annotations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.annotationStores.annotations.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Annotation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsCreateCall) Do(opts ...googleapi.CallOption) (*Annotation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Annotation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsAnnotationStoresAnnotationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an Annotation or returns NOT_FOUND if it does not exist.
//
// - name: The resource name of the Annotation to delete.
func (r *ProjectsLocationsDatasetsAnnotationStoresAnnotationsService) Delete(name string) *ProjectsLocationsDatasetsAnnotationStoresAnnotationsDeleteCall {
	c := &ProjectsLocationsDatasetsAnnotationStoresAnnotationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsAnnotationStoresAnnotationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsAnnotationStoresAnnotationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.annotationStores.annotations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsAnnotationStoresAnnotationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an Annotation.
//
// - name: The resource name of the Annotation to retrieve.
func (r *ProjectsLocationsDatasetsAnnotationStoresAnnotationsService) Get(name string) *ProjectsLocationsDatasetsAnnotationStoresAnnotationsGetCall {
	c := &ProjectsLocationsDatasetsAnnotationStoresAnnotationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsAnnotationStoresAnnotationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsAnnotationStoresAnnotationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsGetCall) Context(ctx context.Context) *ProjectsLocationsDatasetsAnnotationStoresAnnotationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.annotationStores.annotations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Annotation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsGetCall) Do(opts ...googleapi.CallOption) (*Annotation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Annotation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsAnnotationStoresAnnotationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the Annotations in the given Annotation store for a source
// resource.
//
// - parent: Name of the Annotation store to retrieve Annotations from.
func (r *ProjectsLocationsDatasetsAnnotationStoresAnnotationsService) List(parent string) *ProjectsLocationsDatasetsAnnotationStoresAnnotationsListCall {
	c := &ProjectsLocationsDatasetsAnnotationStoresAnnotationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Restricts Annotations returned
// to those matching a filter. Functions available for filtering are: -
// `matches("annotation_source.cloud_healthcare_source.name", substring)`.
// Filter on `cloud_healthcare_source.name`. For example:
// `matches("annotation_source.cloud_healthcare_source.name", "some source")`.
// - `matches("annotation", substring)`. Filter on all fields of annotation.
// For example: `matches("annotation", "some-content")`. - `type("text")`,
// `type("image")`, `type("resource")`. Filter on the type of annotation
// `data`.
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsListCall) Filter(filter string) *ProjectsLocationsDatasetsAnnotationStoresAnnotationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Limit on the number of
// Annotations to return in a single response. If not specified, 100 is used.
// May not be larger than 1000.
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsListCall) PageSize(pageSize int64) *ProjectsLocationsDatasetsAnnotationStoresAnnotationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from the previous List request, if any.
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsListCall) PageToken(pageToken string) *ProjectsLocationsDatasetsAnnotationStoresAnnotationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": Controls which fields are populated
// in the response.
//
// Possible values:
//
//	"ANNOTATION_VIEW_UNSPECIFIED" - Same as BASIC.
//	"ANNOTATION_VIEW_BASIC" - Only `name`, `annotation_source` and
//
// `custom_data` fields are populated.
//
//	"ANNOTATION_VIEW_FULL" - All fields are populated.
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsListCall) View(view string) *ProjectsLocationsDatasetsAnnotationStoresAnnotationsListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsAnnotationStoresAnnotationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsAnnotationStoresAnnotationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsListCall) Context(ctx context.Context) *ProjectsLocationsDatasetsAnnotationStoresAnnotationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/annotations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.annotationStores.annotations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAnnotationsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsListCall) Do(opts ...googleapi.CallOption) (*ListAnnotationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAnnotationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsListCall) Pages(ctx context.Context, f func(*ListAnnotationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDatasetsAnnotationStoresAnnotationsPatchCall struct {
	s          *Service
	name       string
	annotation *Annotation
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the Annotation.
//
//   - name: Identifier. Resource name of the Annotation, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/annota
//     tionStores/{annotation_store_id}/annotations/{annotation_id}`.
func (r *ProjectsLocationsDatasetsAnnotationStoresAnnotationsService) Patch(name string, annotation *Annotation) *ProjectsLocationsDatasetsAnnotationStoresAnnotationsPatchCall {
	c := &ProjectsLocationsDatasetsAnnotationStoresAnnotationsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.annotation = annotation
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The update
// mask applies to the resource. For the `FieldMask` definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsDatasetsAnnotationStoresAnnotationsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsAnnotationStoresAnnotationsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsPatchCall) Context(ctx context.Context) *ProjectsLocationsDatasetsAnnotationStoresAnnotationsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.annotation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.annotationStores.annotations.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Annotation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsAnnotationStoresAnnotationsPatchCall) Do(opts ...googleapi.CallOption) (*Annotation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Annotation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresCheckDataAccessCall struct {
	s                      *Service
	consentStore           string
	checkdataaccessrequest *CheckDataAccessRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// CheckDataAccess: Checks if a particular data_id of a User data mapping in
// the specified consent store is consented for the specified use.
//
//   - consentStore: Name of the consent store where the requested data_id is
//     stored, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consen
//     tStores/{consent_store_id}`.
func (r *ProjectsLocationsDatasetsConsentStoresService) CheckDataAccess(consentStore string, checkdataaccessrequest *CheckDataAccessRequest) *ProjectsLocationsDatasetsConsentStoresCheckDataAccessCall {
	c := &ProjectsLocationsDatasetsConsentStoresCheckDataAccessCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.consentStore = consentStore
	c.checkdataaccessrequest = checkdataaccessrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresCheckDataAccessCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresCheckDataAccessCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresCheckDataAccessCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresCheckDataAccessCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresCheckDataAccessCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresCheckDataAccessCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.checkdataaccessrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+consentStore}:checkDataAccess")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"consentStore": c.consentStore,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.checkDataAccess" call.
// Any non-2xx status code is an error. Response headers are in either
// *CheckDataAccessResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresCheckDataAccessCall) Do(opts ...googleapi.CallOption) (*CheckDataAccessResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CheckDataAccessResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresCreateCall struct {
	s            *Service
	parent       string
	consentstore *ConsentStore
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Create: Creates a new consent store in the parent dataset. Attempting to
// create a consent store with the same ID as an existing store fails with an
// ALREADY_EXISTS error.
//
// - parent: The name of the dataset this consent store belongs to.
func (r *ProjectsLocationsDatasetsConsentStoresService) Create(parent string, consentstore *ConsentStore) *ProjectsLocationsDatasetsConsentStoresCreateCall {
	c := &ProjectsLocationsDatasetsConsentStoresCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.consentstore = consentstore
	return c
}

// ConsentStoreId sets the optional parameter "consentStoreId": Required. The
// ID of the consent store to create. The string must match the following
// regex: `[\p{L}\p{N}_\-\.]{1,256}`. Cannot be changed after creation.
func (c *ProjectsLocationsDatasetsConsentStoresCreateCall) ConsentStoreId(consentStoreId string) *ProjectsLocationsDatasetsConsentStoresCreateCall {
	c.urlParams_.Set("consentStoreId", consentStoreId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresCreateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.consentstore)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/consentStores")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *ConsentStore.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresCreateCall) Do(opts ...googleapi.CallOption) (*ConsentStore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ConsentStore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified consent store and removes all the consent
// store's data.
//
// - name: The resource name of the consent store to delete.
func (r *ProjectsLocationsDatasetsConsentStoresService) Delete(name string) *ProjectsLocationsDatasetsConsentStoresDeleteCall {
	c := &ProjectsLocationsDatasetsConsentStoresDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresEvaluateUserConsentsCall struct {
	s                           *Service
	consentStore                string
	evaluateuserconsentsrequest *EvaluateUserConsentsRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// EvaluateUserConsents: Evaluates the user's Consents for all matching User
// data mappings. Note: User data mappings are indexed asynchronously, which
// can cause a slight delay between the time mappings are created or updated
// and when they are included in EvaluateUserConsents results.
//
//   - consentStore: Name of the consent store to retrieve User data mappings
//     from.
func (r *ProjectsLocationsDatasetsConsentStoresService) EvaluateUserConsents(consentStore string, evaluateuserconsentsrequest *EvaluateUserConsentsRequest) *ProjectsLocationsDatasetsConsentStoresEvaluateUserConsentsCall {
	c := &ProjectsLocationsDatasetsConsentStoresEvaluateUserConsentsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.consentStore = consentStore
	c.evaluateuserconsentsrequest = evaluateuserconsentsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresEvaluateUserConsentsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresEvaluateUserConsentsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresEvaluateUserConsentsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresEvaluateUserConsentsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresEvaluateUserConsentsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresEvaluateUserConsentsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.evaluateuserconsentsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+consentStore}:evaluateUserConsents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"consentStore": c.consentStore,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.evaluateUserConsents" call.
// Any non-2xx status code is an error. Response headers are in either
// *EvaluateUserConsentsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresEvaluateUserConsentsCall) Do(opts ...googleapi.CallOption) (*EvaluateUserConsentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EvaluateUserConsentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDatasetsConsentStoresEvaluateUserConsentsCall) Pages(ctx context.Context, f func(*EvaluateUserConsentsResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.evaluateuserconsentsrequest.PageToken = pt }(c.evaluateuserconsentsrequest.PageToken)
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.evaluateuserconsentsrequest.PageToken = x.NextPageToken
	}
}

type ProjectsLocationsDatasetsConsentStoresGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified consent store.
//
// - name: The resource name of the consent store to get.
func (r *ProjectsLocationsDatasetsConsentStoresService) Get(name string) *ProjectsLocationsDatasetsConsentStoresGetCall {
	c := &ProjectsLocationsDatasetsConsentStoresGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsConsentStoresGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsConsentStoresGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresGetCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *ConsentStore.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresGetCall) Do(opts ...googleapi.CallOption) (*ConsentStore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ConsentStore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsDatasetsConsentStoresService) GetIamPolicy(resource string) *ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall {
	c := &ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the consent stores in the specified dataset.
//
// - parent: Name of the dataset.
func (r *ProjectsLocationsDatasetsConsentStoresService) List(parent string) *ProjectsLocationsDatasetsConsentStoresListCall {
	c := &ProjectsLocationsDatasetsConsentStoresListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Restricts the stores returned
// to those matching a filter. The following syntax is available: * A string
// field value can be written as text inside quotation marks, for example
// "query text". The only valid relational operation for text fields is
// equality (`=`), where text is searched within the field, rather than having
// the field be equal to the text. For example, "Comment = great" returns
// messages with `great` in the comment field. * A number field value can be
// written as an integer, a decimal, or an exponential. The valid relational
// operators for number fields are the equality operator (`=`), along with the
// less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is
// no inequality (`!=`) operator. You can prepend the `NOT` operator to an
// expression to negate it. * A date field value must be written in
// `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format.
// Leading zeros are required for one-digit months and days. The valid
// relational operators for date fields are the equality operator (`=`) , along
// with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that
// there is no inequality (`!=`) operator. You can prepend the `NOT` operator
// to an expression to negate it. * Multiple field query expressions can be
// combined in one query by adding `AND` or `OR` operators between the
// expressions. If a boolean operator appears within a quoted string, it is not
// treated as special, it's just another part of the character string to be
// matched. You can prepend the `NOT` operator to an expression to negate it.
// Only filtering on labels is supported. For example,
// `filter=labels.key=value`.
func (c *ProjectsLocationsDatasetsConsentStoresListCall) Filter(filter string) *ProjectsLocationsDatasetsConsentStoresListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Limit on the number of
// consent stores to return in a single response. If not specified, 100 is
// used. May not be larger than 1000.
func (c *ProjectsLocationsDatasetsConsentStoresListCall) PageSize(pageSize int64) *ProjectsLocationsDatasetsConsentStoresListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to retrieve the
// next page of results, or empty to get the first page.
func (c *ProjectsLocationsDatasetsConsentStoresListCall) PageToken(pageToken string) *ProjectsLocationsDatasetsConsentStoresListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsConsentStoresListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsConsentStoresListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresListCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/consentStores")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListConsentStoresResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresListCall) Do(opts ...googleapi.CallOption) (*ListConsentStoresResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListConsentStoresResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDatasetsConsentStoresListCall) Pages(ctx context.Context, f func(*ListConsentStoresResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDatasetsConsentStoresPatchCall struct {
	s            *Service
	name         string
	consentstore *ConsentStore
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Patch: Updates the specified consent store.
//
//   - name: Resource name of the consent store, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consen
//     tStores/{consent_store_id}`. Cannot be changed after creation.
func (r *ProjectsLocationsDatasetsConsentStoresService) Patch(name string, consentstore *ConsentStore) *ProjectsLocationsDatasetsConsentStoresPatchCall {
	c := &ProjectsLocationsDatasetsConsentStoresPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.consentstore = consentstore
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The update
// mask that applies to the resource. For the `FieldMask` definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
// Only the `labels`, `default_consent_ttl`, and
// `enable_consent_create_on_update` fields are allowed to be updated.
func (c *ProjectsLocationsDatasetsConsentStoresPatchCall) UpdateMask(updateMask string) *ProjectsLocationsDatasetsConsentStoresPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresPatchCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.consentstore)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *ConsentStore.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresPatchCall) Do(opts ...googleapi.CallOption) (*ConsentStore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ConsentStore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresQueryAccessibleDataCall struct {
	s                          *Service
	consentStore               string
	queryaccessibledatarequest *QueryAccessibleDataRequest
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// QueryAccessibleData: Queries all data_ids that are consented for a specified
// use in the given consent store and writes them to a specified destination.
// The returned Operation includes a progress counter for the number of User
// data mappings processed. If the request is successful, a detailed response
// is returned of type QueryAccessibleDataResponse, contained in the response
// field when the operation finishes. The metadata field type is
// OperationMetadata. Errors are logged to Cloud Logging (see Viewing error
// logs in Cloud Logging
// (https://cloud.google.com/healthcare/docs/how-tos/logging)). For example,
// the following sample log entry shows a `failed to evaluate consent policy`
// error that occurred during a QueryAccessibleData call to consent store
// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentS
// tores/{consent_store_id}`. ```json jsonPayload: { @type:
// "type.googleapis.com/google.cloud.healthcare.logging.QueryAccessibleDataLogEn
// try" error: { code: 9 message: "failed to evaluate consent policy" }
// resourceName:
// "projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentS
// tores/{consent_store_id}/consents/{consent_id}" } logName:
// "projects/{project_id}/logs/healthcare.googleapis.com%2Fquery_accessible_data
// " operation: { id:
// "projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/operatio
// ns/{operation_id}" producer: "healthcare.googleapis.com/QueryAccessibleData"
// } receiveTimestamp: "TIMESTAMP" resource: { labels: { consent_store_id:
// "{consent_store_id}" dataset_id: "{dataset_id}" location: "{location_id}"
// project_id: "{project_id}" } type: "healthcare_consent_store" } severity:
// "ERROR" timestamp: "TIMESTAMP" ```
//
//   - consentStore: Name of the consent store to retrieve User data mappings
//     from.
func (r *ProjectsLocationsDatasetsConsentStoresService) QueryAccessibleData(consentStore string, queryaccessibledatarequest *QueryAccessibleDataRequest) *ProjectsLocationsDatasetsConsentStoresQueryAccessibleDataCall {
	c := &ProjectsLocationsDatasetsConsentStoresQueryAccessibleDataCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.consentStore = consentStore
	c.queryaccessibledatarequest = queryaccessibledatarequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresQueryAccessibleDataCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresQueryAccessibleDataCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresQueryAccessibleDataCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresQueryAccessibleDataCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresQueryAccessibleDataCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresQueryAccessibleDataCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.queryaccessibledatarequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+consentStore}:queryAccessibleData")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"consentStore": c.consentStore,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.queryAccessibleData" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresQueryAccessibleDataCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsDatasetsConsentStoresService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsDatasetsConsentStoresSetIamPolicyCall {
	c := &ProjectsLocationsDatasetsConsentStoresSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsDatasetsConsentStoresService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsDatasetsConsentStoresTestIamPermissionsCall {
	c := &ProjectsLocationsDatasetsConsentStoresTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsCreateCall struct {
	s                   *Service
	parent              string
	attributedefinition *AttributeDefinition
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Create: Creates a new Attribute definition in the parent consent store.
//
//   - parent: The name of the consent store that this Attribute definition
//     belongs to.
func (r *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsService) Create(parent string, attributedefinition *AttributeDefinition) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsCreateCall {
	c := &ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.attributedefinition = attributedefinition
	return c
}

// AttributeDefinitionId sets the optional parameter "attributeDefinitionId":
// Required. The ID of the Attribute definition to create. The string must
// match the following regex: `_a-zA-Z{0,255}` and must not be a reserved
// keyword within the Common Expression Language as listed on
// https://github.com/google/cel-spec/blob/master/doc/langdef.md.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsCreateCall) AttributeDefinitionId(attributeDefinitionId string) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsCreateCall {
	c.urlParams_.Set("attributeDefinitionId", attributeDefinitionId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsCreateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.attributedefinition)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/attributeDefinitions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.attributeDefinitions.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *AttributeDefinition.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsCreateCall) Do(opts ...googleapi.CallOption) (*AttributeDefinition, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AttributeDefinition{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified Attribute definition. Fails if the Attribute
// definition is referenced by any User data mapping, or the latest revision of
// any Consent.
//
//   - name: The resource name of the Attribute definition to delete. To preserve
//     referential integrity, Attribute definitions referenced by a User data
//     mapping or the latest revision of a Consent cannot be deleted.
func (r *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsService) Delete(name string) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsDeleteCall {
	c := &ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.attributeDefinitions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified Attribute definition.
//
// - name: The resource name of the Attribute definition to get.
func (r *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsService) Get(name string) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsGetCall {
	c := &ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsGetCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.attributeDefinitions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *AttributeDefinition.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsGetCall) Do(opts ...googleapi.CallOption) (*AttributeDefinition, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AttributeDefinition{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the Attribute definitions in the specified consent store.
//
// - parent: Name of the consent store to retrieve Attribute definitions from.
func (r *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsService) List(parent string) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall {
	c := &ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Restricts the attributes
// returned to those matching a filter. The following syntax is available: * A
// string field value can be written as text inside quotation marks, for
// example "query text". The only valid relational operation for text fields
// is equality (`=`), where text is searched within the field, rather than
// having the field be equal to the text. For example, "Comment = great"
// returns messages with `great` in the comment field. * A number field value
// can be written as an integer, a decimal, or an exponential. The valid
// relational operators for number fields are the equality operator (`=`),
// along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note
// that there is no inequality (`!=`) operator. You can prepend the `NOT`
// operator to an expression to negate it. * A date field value must be written
// in `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format.
// Leading zeros are required for one-digit months and days. The valid
// relational operators for date fields are the equality operator (`=`) , along
// with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that
// there is no inequality (`!=`) operator. You can prepend the `NOT` operator
// to an expression to negate it. * Multiple field query expressions can be
// combined in one query by adding `AND` or `OR` operators between the
// expressions. If a boolean operator appears within a quoted string, it is not
// treated as special, it's just another part of the character string to be
// matched. You can prepend the `NOT` operator to an expression to negate it.
// The only field available for filtering is `category`. For example,
// `filter=category=\"REQUEST\".
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall) Filter(filter string) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Limit on the number of
// Attribute definitions to return in a single response. If not specified, 100
// is used. May not be larger than 1000.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall) PageSize(pageSize int64) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to retrieve the
// next page of results or empty to get the first page.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall) PageToken(pageToken string) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/attributeDefinitions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.attributeDefinitions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAttributeDefinitionsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall) Do(opts ...googleapi.CallOption) (*ListAttributeDefinitionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAttributeDefinitionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall) Pages(ctx context.Context, f func(*ListAttributeDefinitionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsPatchCall struct {
	s                   *Service
	name                string
	attributedefinition *AttributeDefinition
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Patch: Updates the specified Attribute definition.
//
//   - name: Identifier. Resource name of the Attribute definition, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consen
//     tStores/{consent_store_id}/attributeDefinitions/{attribute_definition_id}`.
//     Cannot be changed after creation.
func (r *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsService) Patch(name string, attributedefinition *AttributeDefinition) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsPatchCall {
	c := &ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.attributedefinition = attributedefinition
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The update
// mask that applies to the resource. For the `FieldMask` definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
// Only the `description`, `allowed_values`, `consent_default_values` and
// `data_mapping_default_value` fields can be updated. The updated
// `allowed_values` must contain all values from the previous `allowed_values`.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsPatchCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.attributedefinition)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.attributeDefinitions.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *AttributeDefinition.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsPatchCall) Do(opts ...googleapi.CallOption) (*AttributeDefinition, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AttributeDefinition{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresConsentArtifactsCreateCall struct {
	s               *Service
	parent          string
	consentartifact *ConsentArtifact
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Create: Creates a new Consent artifact in the parent consent store.
//
// - parent: The name of the consent store this Consent artifact belongs to.
func (r *ProjectsLocationsDatasetsConsentStoresConsentArtifactsService) Create(parent string, consentartifact *ConsentArtifact) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsCreateCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentArtifactsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.consentartifact = consentartifact
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsCreateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.consentartifact)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/consentArtifacts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consentArtifacts.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *ConsentArtifact.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsCreateCall) Do(opts ...googleapi.CallOption) (*ConsentArtifact, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ConsentArtifact{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresConsentArtifactsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified Consent artifact. Fails if the artifact is
// referenced by the latest revision of any Consent.
//
//   - name: The resource name of the Consent artifact to delete. To preserve
//     referential integrity, Consent artifacts referenced by the latest revision
//     of a Consent cannot be deleted.
func (r *ProjectsLocationsDatasetsConsentStoresConsentArtifactsService) Delete(name string) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsDeleteCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentArtifactsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consentArtifacts.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresConsentArtifactsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified Consent artifact.
//
// - name: The resource name of the Consent artifact to retrieve.
func (r *ProjectsLocationsDatasetsConsentStoresConsentArtifactsService) Get(name string) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsGetCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentArtifactsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsGetCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consentArtifacts.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *ConsentArtifact.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsGetCall) Do(opts ...googleapi.CallOption) (*ConsentArtifact, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ConsentArtifact{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the Consent artifacts in the specified consent store.
//
// - parent: Name of the consent store to retrieve consent artifacts from.
func (r *ProjectsLocationsDatasetsConsentStoresConsentArtifactsService) List(parent string) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Restricts the artifacts
// returned to those matching a filter. The following syntax is available: * A
// string field value can be written as text inside quotation marks, for
// example "query text". The only valid relational operation for text fields
// is equality (`=`), where text is searched within the field, rather than
// having the field be equal to the text. For example, "Comment = great"
// returns messages with `great` in the comment field. * A number field value
// can be written as an integer, a decimal, or an exponential. The valid
// relational operators for number fields are the equality operator (`=`),
// along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note
// that there is no inequality (`!=`) operator. You can prepend the `NOT`
// operator to an expression to negate it. * A date field value must be written
// in `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format.
// Leading zeros are required for one-digit months and days. The valid
// relational operators for date fields are the equality operator (`=`) , along
// with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that
// there is no inequality (`!=`) operator. You can prepend the `NOT` operator
// to an expression to negate it. * Multiple field query expressions can be
// combined in one query by adding `AND` or `OR` operators between the
// expressions. If a boolean operator appears within a quoted string, it is not
// treated as special, it's just another part of the character string to be
// matched. You can prepend the `NOT` operator to an expression to negate it.
// The fields available for filtering are: - user_id. For example,
// `filter=user_id=\"user123\". - consent_content_version - metadata. For
// example, `filter=Metadata(\"testkey\")=\"value\" or
// `filter=HasMetadata(\"testkey\")`.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall) Filter(filter string) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Limit on the number of
// consent artifacts to return in a single response. If not specified, 100 is
// used. May not be larger than 1000.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall) PageSize(pageSize int64) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from the previous List request, if any.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall) PageToken(pageToken string) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/consentArtifacts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consentArtifacts.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListConsentArtifactsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall) Do(opts ...googleapi.CallOption) (*ListConsentArtifactsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListConsentArtifactsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall) Pages(ctx context.Context, f func(*ListConsentArtifactsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDatasetsConsentStoresConsentsActivateCall struct {
	s                      *Service
	name                   string
	activateconsentrequest *ActivateConsentRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Activate: Activates the latest revision of the specified Consent by
// committing a new revision with `state` updated to `ACTIVE`. If the latest
// revision of the specified Consent is in the `ACTIVE` state, no new revision
// is committed. A FAILED_PRECONDITION error occurs if the latest revision of
// the specified consent is in the `REJECTED` or `REVOKED` state.
//
//   - name: The resource name of the Consent to activate, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consen
//     tStores/{consent_store_id}/consents/{consent_id}`. An INVALID_ARGUMENT
//     error occurs if `revision_id` is specified in the name.
func (r *ProjectsLocationsDatasetsConsentStoresConsentsService) Activate(name string, activateconsentrequest *ActivateConsentRequest) *ProjectsLocationsDatasetsConsentStoresConsentsActivateCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentsActivateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.activateconsentrequest = activateconsentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsActivateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentsActivateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsActivateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentsActivateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsActivateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentsActivateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.activateconsentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:activate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consents.activate" call.
// Any non-2xx status code is an error. Response headers are in either
// *Consent.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsActivateCall) Do(opts ...googleapi.CallOption) (*Consent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Consent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresConsentsCreateCall struct {
	s          *Service
	parent     string
	consent    *Consent
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new Consent in the parent consent store.
//
// - parent: Name of the consent store.
func (r *ProjectsLocationsDatasetsConsentStoresConsentsService) Create(parent string, consent *Consent) *ProjectsLocationsDatasetsConsentStoresConsentsCreateCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.consent = consent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsCreateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.consent)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/consents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consents.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Consent.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsCreateCall) Do(opts ...googleapi.CallOption) (*Consent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Consent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresConsentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the Consent and its revisions. To keep a record of the
// Consent but mark it inactive, see [RevokeConsent]. To delete a revision of a
// Consent, see [DeleteConsentRevision]. This operation does not delete the
// related Consent artifact.
//
//   - name: The resource name of the Consent to delete, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consen
//     tStores/{consent_store_id}/consents/{consent_id}`. An INVALID_ARGUMENT
//     error occurs if `revision_id` is specified in the name.
func (r *ProjectsLocationsDatasetsConsentStoresConsentsService) Delete(name string) *ProjectsLocationsDatasetsConsentStoresConsentsDeleteCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consents.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresConsentsDeleteRevisionCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// DeleteRevision: Deletes the specified revision of a Consent. An
// INVALID_ARGUMENT error occurs if the specified revision is the latest
// revision.
//
//   - name: The resource name of the Consent revision to delete, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consen
//     tStores/{consent_store_id}/consents/{consent_id}@{revision_id}`. An
//     INVALID_ARGUMENT error occurs if `revision_id` is not specified in the
//     name.
func (r *ProjectsLocationsDatasetsConsentStoresConsentsService) DeleteRevision(name string) *ProjectsLocationsDatasetsConsentStoresConsentsDeleteRevisionCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentsDeleteRevisionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsDeleteRevisionCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentsDeleteRevisionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsDeleteRevisionCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentsDeleteRevisionCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsDeleteRevisionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentsDeleteRevisionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:deleteRevision")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consents.deleteRevision" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsDeleteRevisionCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresConsentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified revision of a Consent, or the latest revision if
// `revision_id` is not specified in the resource name.
//
//   - name: The resource name of the Consent to retrieve, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consen
//     tStores/{consent_store_id}/consents/{consent_id}`. In order to retrieve a
//     previous revision of the Consent, also provide the revision ID:
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consen
//     tStores/{consent_store_id}/consents/{consent_id}@{revision_id}`.
func (r *ProjectsLocationsDatasetsConsentStoresConsentsService) Get(name string) *ProjectsLocationsDatasetsConsentStoresConsentsGetCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsConsentStoresConsentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsGetCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consents.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Consent.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsGetCall) Do(opts ...googleapi.CallOption) (*Consent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Consent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresConsentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the Consent in the given consent store, returning each Consent's
// latest revision.
//
// - parent: Name of the consent store to retrieve Consents from.
func (r *ProjectsLocationsDatasetsConsentStoresConsentsService) List(parent string) *ProjectsLocationsDatasetsConsentStoresConsentsListCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Restricts the consents returned
// to those matching a filter. The following syntax is available: * A string
// field value can be written as text inside quotation marks, for example
// "query text". The only valid relational operation for text fields is
// equality (`=`), where text is searched within the field, rather than having
// the field be equal to the text. For example, "Comment = great" returns
// messages with `great` in the comment field. * A number field value can be
// written as an integer, a decimal, or an exponential. The valid relational
// operators for number fields are the equality operator (`=`), along with the
// less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is
// no inequality (`!=`) operator. You can prepend the `NOT` operator to an
// expression to negate it. * A date field value must be written in
// `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format.
// Leading zeros are required for one-digit months and days. The valid
// relational operators for date fields are the equality operator (`=`) , along
// with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that
// there is no inequality (`!=`) operator. You can prepend the `NOT` operator
// to an expression to negate it. * Multiple field query expressions can be
// combined in one query by adding `AND` or `OR` operators between the
// expressions. If a boolean operator appears within a quoted string, it is not
// treated as special, it's just another part of the character string to be
// matched. You can prepend the `NOT` operator to an expression to negate it.
// The fields available for filtering are: - user_id. For example,
// `filter='user_id="user123"'`. - consent_artifact - state -
// revision_create_time - metadata. For example,
// `filter=Metadata(\"testkey\")=\"value\" or
// `filter=HasMetadata(\"testkey\")`.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListCall) Filter(filter string) *ProjectsLocationsDatasetsConsentStoresConsentsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Limit on the number of
// Consents to return in a single response. If not specified, 100 is used. May
// not be larger than 1000.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListCall) PageSize(pageSize int64) *ProjectsLocationsDatasetsConsentStoresConsentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from the previous List request, if any.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListCall) PageToken(pageToken string) *ProjectsLocationsDatasetsConsentStoresConsentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsConsentStoresConsentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/consents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consents.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListConsentsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListCall) Do(opts ...googleapi.CallOption) (*ListConsentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListConsentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListCall) Pages(ctx context.Context, f func(*ListConsentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListRevisions: Lists the revisions of the specified Consent in reverse
// chronological order.
//
// - name: The resource name of the Consent to retrieve revisions for.
func (r *ProjectsLocationsDatasetsConsentStoresConsentsService) ListRevisions(name string) *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": Restricts the revisions
// returned to those matching a filter. The following syntax is available: * A
// string field value can be written as text inside quotation marks, for
// example "query text". The only valid relational operation for text fields
// is equality (`=`), where text is searched within the field, rather than
// having the field be equal to the text. For example, "Comment = great"
// returns messages with `great` in the comment field. * A number field value
// can be written as an integer, a decimal, or an exponential. The valid
// relational operators for number fields are the equality operator (`=`),
// along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note
// that there is no inequality (`!=`) operator. You can prepend the `NOT`
// operator to an expression to negate it. * A date field value must be written
// in `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format.
// Leading zeros are required for one-digit months and days. The valid
// relational operators for date fields are the equality operator (`=`) , along
// with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that
// there is no inequality (`!=`) operator. You can prepend the `NOT` operator
// to an expression to negate it. * Multiple field query expressions can be
// combined in one query by adding `AND` or `OR` operators between the
// expressions. If a boolean operator appears within a quoted string, it is not
// treated as special, it's just another part of the character string to be
// matched. You can prepend the `NOT` operator to an expression to negate it.
// Fields/functions available for filtering are: - user_id. For example,
// `filter='user_id="user123"'`. - consent_artifact - state -
// revision_create_time - metadata. For example,
// `filter=Metadata(\"testkey\")=\"value\" or
// `filter=HasMetadata(\"testkey\")`.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall) Filter(filter string) *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Limit on the number of
// revisions to return in a single response. If not specified, 100 is used. May
// not be larger than 1000.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall) PageSize(pageSize int64) *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to retrieve the
// next page of results or empty if there are no more results in the list.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall) PageToken(pageToken string) *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:listRevisions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consents.listRevisions" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListConsentRevisionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall) Do(opts ...googleapi.CallOption) (*ListConsentRevisionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListConsentRevisionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall) Pages(ctx context.Context, f func(*ListConsentRevisionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDatasetsConsentStoresConsentsPatchCall struct {
	s          *Service
	name       string
	consent    *Consent
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the latest revision of the specified Consent by committing a
// new revision with the changes. A FAILED_PRECONDITION error occurs if the
// latest revision of the specified Consent is in the `REJECTED` or `REVOKED`
// state.
//
//   - name: Identifier. Resource name of the Consent, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consen
//     tStores/{consent_store_id}/consents/{consent_id}`. Cannot be changed after
//     creation.
func (r *ProjectsLocationsDatasetsConsentStoresConsentsService) Patch(name string, consent *Consent) *ProjectsLocationsDatasetsConsentStoresConsentsPatchCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.consent = consent
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The update
// mask to apply to the resource. For the `FieldMask` definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
// Only the `user_id`, `policies`, `consent_artifact`, and `metadata` fields
// can be updated.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsDatasetsConsentStoresConsentsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsPatchCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.consent)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consents.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Consent.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsPatchCall) Do(opts ...googleapi.CallOption) (*Consent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Consent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresConsentsRejectCall struct {
	s                    *Service
	name                 string
	rejectconsentrequest *RejectConsentRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Reject: Rejects the latest revision of the specified Consent by committing a
// new revision with `state` updated to `REJECTED`. If the latest revision of
// the specified Consent is in the `REJECTED` state, no new revision is
// committed. A FAILED_PRECONDITION error occurs if the latest revision of the
// specified Consent is in the `ACTIVE` or `REVOKED` state.
//
//   - name: The resource name of the Consent to reject, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consen
//     tStores/{consent_store_id}/consents/{consent_id}`. An INVALID_ARGUMENT
//     error occurs if `revision_id` is specified in the name.
func (r *ProjectsLocationsDatasetsConsentStoresConsentsService) Reject(name string, rejectconsentrequest *RejectConsentRequest) *ProjectsLocationsDatasetsConsentStoresConsentsRejectCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentsRejectCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.rejectconsentrequest = rejectconsentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsRejectCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentsRejectCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsRejectCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentsRejectCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsRejectCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentsRejectCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.rejectconsentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:reject")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consents.reject" call.
// Any non-2xx status code is an error. Response headers are in either
// *Consent.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsRejectCall) Do(opts ...googleapi.CallOption) (*Consent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Consent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresConsentsRevokeCall struct {
	s                    *Service
	name                 string
	revokeconsentrequest *RevokeConsentRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Revoke: Revokes the latest revision of the specified Consent by committing a
// new revision with `state` updated to `REVOKED`. If the latest revision of
// the specified Consent is in the `REVOKED` state, no new revision is
// committed. A FAILED_PRECONDITION error occurs if the latest revision of the
// given consent is in `DRAFT` or `REJECTED` state.
//
//   - name: The resource name of the Consent to revoke, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consen
//     tStores/{consent_store_id}/consents/{consent_id}`. An INVALID_ARGUMENT
//     error occurs if `revision_id` is specified in the name.
func (r *ProjectsLocationsDatasetsConsentStoresConsentsService) Revoke(name string, revokeconsentrequest *RevokeConsentRequest) *ProjectsLocationsDatasetsConsentStoresConsentsRevokeCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentsRevokeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.revokeconsentrequest = revokeconsentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsRevokeCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentsRevokeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsRevokeCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentsRevokeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsRevokeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentsRevokeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.revokeconsentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:revoke")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consents.revoke" call.
// Any non-2xx status code is an error. Response headers are in either
// *Consent.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsRevokeCall) Do(opts ...googleapi.CallOption) (*Consent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Consent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresUserDataMappingsArchiveCall struct {
	s                             *Service
	name                          string
	archiveuserdatamappingrequest *ArchiveUserDataMappingRequest
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// Archive: Archives the specified User data mapping.
//
// - name: The resource name of the User data mapping to archive.
func (r *ProjectsLocationsDatasetsConsentStoresUserDataMappingsService) Archive(name string, archiveuserdatamappingrequest *ArchiveUserDataMappingRequest) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsArchiveCall {
	c := &ProjectsLocationsDatasetsConsentStoresUserDataMappingsArchiveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.archiveuserdatamappingrequest = archiveuserdatamappingrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsArchiveCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsArchiveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsArchiveCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsArchiveCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsArchiveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsArchiveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.archiveuserdatamappingrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:archive")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.userDataMappings.archive" call.
// Any non-2xx status code is an error. Response headers are in either
// *ArchiveUserDataMappingResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsArchiveCall) Do(opts ...googleapi.CallOption) (*ArchiveUserDataMappingResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ArchiveUserDataMappingResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresUserDataMappingsCreateCall struct {
	s               *Service
	parent          string
	userdatamapping *UserDataMapping
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Create: Creates a new User data mapping in the parent consent store.
//
// - parent: Name of the consent store.
func (r *ProjectsLocationsDatasetsConsentStoresUserDataMappingsService) Create(parent string, userdatamapping *UserDataMapping) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsCreateCall {
	c := &ProjectsLocationsDatasetsConsentStoresUserDataMappingsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.userdatamapping = userdatamapping
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsCreateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.userdatamapping)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/userDataMappings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.userDataMappings.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *UserDataMapping.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsCreateCall) Do(opts ...googleapi.CallOption) (*UserDataMapping, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UserDataMapping{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresUserDataMappingsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified User data mapping.
//
// - name: The resource name of the User data mapping to delete.
func (r *ProjectsLocationsDatasetsConsentStoresUserDataMappingsService) Delete(name string) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsDeleteCall {
	c := &ProjectsLocationsDatasetsConsentStoresUserDataMappingsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.userDataMappings.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresUserDataMappingsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified User data mapping.
//
// - name: The resource name of the User data mapping to retrieve.
func (r *ProjectsLocationsDatasetsConsentStoresUserDataMappingsService) Get(name string) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsGetCall {
	c := &ProjectsLocationsDatasetsConsentStoresUserDataMappingsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsGetCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.userDataMappings.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *UserDataMapping.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsGetCall) Do(opts ...googleapi.CallOption) (*UserDataMapping, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UserDataMapping{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the User data mappings in the specified consent store.
//
// - parent: Name of the consent store to retrieve User data mappings from.
func (r *ProjectsLocationsDatasetsConsentStoresUserDataMappingsService) List(parent string) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall {
	c := &ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Restricts the user data
// mappings returned to those matching a filter. The following syntax is
// available: * A string field value can be written as text inside quotation
// marks, for example "query text". The only valid relational operation for
// text fields is equality (`=`), where text is searched within the field,
// rather than having the field be equal to the text. For example, "Comment =
// great" returns messages with `great` in the comment field. * A number field
// value can be written as an integer, a decimal, or an exponential. The valid
// relational operators for number fields are the equality operator (`=`),
// along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note
// that there is no inequality (`!=`) operator. You can prepend the `NOT`
// operator to an expression to negate it. * A date field value must be written
// in `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format.
// Leading zeros are required for one-digit months and days. The valid
// relational operators for date fields are the equality operator (`=`) , along
// with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that
// there is no inequality (`!=`) operator. You can prepend the `NOT` operator
// to an expression to negate it. * Multiple field query expressions can be
// combined in one query by adding `AND` or `OR` operators between the
// expressions. If a boolean operator appears within a quoted string, it is not
// treated as special, it's just another part of the character string to be
// matched. You can prepend the `NOT` operator to an expression to negate it.
// The fields available for filtering are: - data_id - user_id. For example,
// `filter=user_id=\"user123\". - archived - archive_time
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall) Filter(filter string) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Limit on the number of User
// data mappings to return in a single response. If not specified, 100 is used.
// May not be larger than 1000.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall) PageSize(pageSize int64) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to retrieve the
// next page of results, or empty to get the first page.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall) PageToken(pageToken string) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/userDataMappings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.userDataMappings.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListUserDataMappingsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall) Do(opts ...googleapi.CallOption) (*ListUserDataMappingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListUserDataMappingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall) Pages(ctx context.Context, f func(*ListUserDataMappingsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDatasetsConsentStoresUserDataMappingsPatchCall struct {
	s               *Service
	name            string
	userdatamapping *UserDataMapping
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Patch: Updates the specified User data mapping.
//
//   - name: Resource name of the User data mapping, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consen
//     tStores/{consent_store_id}/userDataMappings/{user_data_mapping_id}`.
func (r *ProjectsLocationsDatasetsConsentStoresUserDataMappingsService) Patch(name string, userdatamapping *UserDataMapping) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsPatchCall {
	c := &ProjectsLocationsDatasetsConsentStoresUserDataMappingsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.userdatamapping = userdatamapping
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The update
// mask that applies to the resource. For the `FieldMask` definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
// Only the `data_id`, `user_id` and `resource_attributes` fields can be
// updated.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsPatchCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.userdatamapping)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.userDataMappings.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *UserDataMapping.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsPatchCall) Do(opts ...googleapi.CallOption) (*UserDataMapping, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UserDataMapping{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsDatasetsDataMapperWorkspacesService) GetIamPolicy(resource string) *ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall {
	c := &ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dataMapperWorkspaces.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsDataMapperWorkspacesSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsDatasetsDataMapperWorkspacesService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsDatasetsDataMapperWorkspacesSetIamPolicyCall {
	c := &ProjectsLocationsDatasetsDataMapperWorkspacesSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDataMapperWorkspacesSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDataMapperWorkspacesSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDataMapperWorkspacesSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dataMapperWorkspaces.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsDataMapperWorkspacesTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsDatasetsDataMapperWorkspacesService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsDatasetsDataMapperWorkspacesTestIamPermissionsCall {
	c := &ProjectsLocationsDatasetsDataMapperWorkspacesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDataMapperWorkspacesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDataMapperWorkspacesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDataMapperWorkspacesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dataMapperWorkspaces.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresCreateCall struct {
	s          *Service
	parent     string
	dicomstore *DicomStore
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new DICOM store within the parent dataset.
//
// - parent: The name of the dataset this DICOM store belongs to.
func (r *ProjectsLocationsDatasetsDicomStoresService) Create(parent string, dicomstore *DicomStore) *ProjectsLocationsDatasetsDicomStoresCreateCall {
	c := &ProjectsLocationsDatasetsDicomStoresCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomstore = dicomstore
	return c
}

// DicomStoreId sets the optional parameter "dicomStoreId": Required. The ID of
// the DICOM store that is being created. Any string value up to 256 characters
// in length.
func (c *ProjectsLocationsDatasetsDicomStoresCreateCall) DicomStoreId(dicomStoreId string) *ProjectsLocationsDatasetsDicomStoresCreateCall {
	c.urlParams_.Set("dicomStoreId", dicomStoreId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresCreateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.dicomstore)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/dicomStores")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *DicomStore.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresCreateCall) Do(opts ...googleapi.CallOption) (*DicomStore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DicomStore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresDeidentifyCall struct {
	s                           *Service
	sourceStore                 string
	deidentifydicomstorerequest *DeidentifyDicomStoreRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// Deidentify: De-identifies data from the source store and writes it to the
// destination store. The metadata field type is OperationMetadata. If the
// request is successful, the response field type is
// DeidentifyDicomStoreSummary. The LRO result may still be successful if
// de-identification fails for some DICOM instances. The output DICOM store
// will not contain these failed resources. The number of resources processed
// are tracked in Operation.metadata. Error details are logged to Cloud
// Logging. For more information, see Viewing error logs in Cloud Logging
// (https://cloud.google.com/healthcare/docs/how-tos/logging).
//
//   - sourceStore: Source DICOM store resource name. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresService) Deidentify(sourceStore string, deidentifydicomstorerequest *DeidentifyDicomStoreRequest) *ProjectsLocationsDatasetsDicomStoresDeidentifyCall {
	c := &ProjectsLocationsDatasetsDicomStoresDeidentifyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.sourceStore = sourceStore
	c.deidentifydicomstorerequest = deidentifydicomstorerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresDeidentifyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresDeidentifyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresDeidentifyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresDeidentifyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresDeidentifyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresDeidentifyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.deidentifydicomstorerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+sourceStore}:deidentify")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"sourceStore": c.sourceStore,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.deidentify" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresDeidentifyCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified DICOM store and removes all images that are
// contained within it.
//
// - name: The resource name of the DICOM store to delete.
func (r *ProjectsLocationsDatasetsDicomStoresService) Delete(name string) *ProjectsLocationsDatasetsDicomStoresDeleteCall {
	c := &ProjectsLocationsDatasetsDicomStoresDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresExportCall struct {
	s                      *Service
	name                   string
	exportdicomdatarequest *ExportDicomDataRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Export: Exports data to the specified destination by copying it from the
// DICOM store. Errors are also logged to Cloud Logging. For more information,
// see Viewing errors in Cloud Logging
// (https://cloud.google.com/healthcare/docs/how-tos/logging). The metadata
// field type is OperationMetadata.
//
//   - name: The DICOM store resource name from which to export the data. For
//     example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresService) Export(name string, exportdicomdatarequest *ExportDicomDataRequest) *ProjectsLocationsDatasetsDicomStoresExportCall {
	c := &ProjectsLocationsDatasetsDicomStoresExportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.exportdicomdatarequest = exportdicomdatarequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresExportCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresExportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresExportCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresExportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresExportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresExportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.exportdicomdatarequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:export")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.export" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresExportCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified DICOM store.
//
// - name: The resource name of the DICOM store to get.
func (r *ProjectsLocationsDatasetsDicomStoresService) Get(name string) *ProjectsLocationsDatasetsDicomStoresGetCall {
	c := &ProjectsLocationsDatasetsDicomStoresGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresGetCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *DicomStore.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresGetCall) Do(opts ...googleapi.CallOption) (*DicomStore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DicomStore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresGetDICOMStoreMetricsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetDICOMStoreMetrics: Gets metrics associated with the DICOM store.
//
// - name: The resource name of the DICOM store to get metrics for.
func (r *ProjectsLocationsDatasetsDicomStoresService) GetDICOMStoreMetrics(name string) *ProjectsLocationsDatasetsDicomStoresGetDICOMStoreMetricsCall {
	c := &ProjectsLocationsDatasetsDicomStoresGetDICOMStoreMetricsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresGetDICOMStoreMetricsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresGetDICOMStoreMetricsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresGetDICOMStoreMetricsCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresGetDICOMStoreMetricsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresGetDICOMStoreMetricsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresGetDICOMStoreMetricsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresGetDICOMStoreMetricsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresGetDICOMStoreMetricsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:getDICOMStoreMetrics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.getDICOMStoreMetrics" call.
// Any non-2xx status code is an error. Response headers are in either
// *DicomStoreMetrics.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsDicomStoresGetDICOMStoreMetricsCall) Do(opts ...googleapi.CallOption) (*DicomStoreMetrics, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DicomStoreMetrics{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsDatasetsDicomStoresService) GetIamPolicy(resource string) *ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall {
	c := &ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresImportCall struct {
	s                      *Service
	name                   string
	importdicomdatarequest *ImportDicomDataRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Import: Imports data into the DICOM store by copying it from the specified
// source. Errors are logged to Cloud Logging. For more information, see
// Viewing error logs in Cloud Logging
// (https://cloud.google.com/healthcare/docs/how-tos/logging). The metadata
// field type is OperationMetadata.
//
//   - name: The name of the DICOM store resource into which the data is
//     imported. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresService) Import(name string, importdicomdatarequest *ImportDicomDataRequest) *ProjectsLocationsDatasetsDicomStoresImportCall {
	c := &ProjectsLocationsDatasetsDicomStoresImportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.importdicomdatarequest = importdicomdatarequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresImportCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresImportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresImportCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresImportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresImportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresImportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.importdicomdatarequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:import")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.import" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresImportCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the DICOM stores in the given dataset.
//
// - parent: Name of the dataset.
func (r *ProjectsLocationsDatasetsDicomStoresService) List(parent string) *ProjectsLocationsDatasetsDicomStoresListCall {
	c := &ProjectsLocationsDatasetsDicomStoresListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Restricts stores returned to
// those matching a filter. The following syntax is available: * A string field
// value can be written as text inside quotation marks, for example "query
// text". The only valid relational operation for text fields is equality
// (`=`), where text is searched within the field, rather than having the field
// be equal to the text. For example, "Comment = great" returns messages with
// `great` in the comment field. * A number field value can be written as an
// integer, a decimal, or an exponential. The valid relational operators for
// number fields are the equality operator (`=`), along with the less
// than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no
// inequality (`!=`) operator. You can prepend the `NOT` operator to an
// expression to negate it. * A date field value must be written in
// `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format.
// Leading zeros are required for one-digit months and days. The valid
// relational operators for date fields are the equality operator (`=`) , along
// with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that
// there is no inequality (`!=`) operator. You can prepend the `NOT` operator
// to an expression to negate it. * Multiple field query expressions can be
// combined in one query by adding `AND` or `OR` operators between the
// expressions. If a boolean operator appears within a quoted string, it is not
// treated as special, it's just another part of the character string to be
// matched. You can prepend the `NOT` operator to an expression to negate it.
// Only filtering on labels is supported. For example, `labels.key=value`.
func (c *ProjectsLocationsDatasetsDicomStoresListCall) Filter(filter string) *ProjectsLocationsDatasetsDicomStoresListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Limit on the number of
// DICOM stores to return in a single response. If not specified, 100 is used.
// May not be larger than 1000.
func (c *ProjectsLocationsDatasetsDicomStoresListCall) PageSize(pageSize int64) *ProjectsLocationsDatasetsDicomStoresListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from the previous List request, if any.
func (c *ProjectsLocationsDatasetsDicomStoresListCall) PageToken(pageToken string) *ProjectsLocationsDatasetsDicomStoresListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresListCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/dicomStores")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDicomStoresResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresListCall) Do(opts ...googleapi.CallOption) (*ListDicomStoresResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDicomStoresResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDatasetsDicomStoresListCall) Pages(ctx context.Context, f func(*ListDicomStoresResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDatasetsDicomStoresPatchCall struct {
	s          *Service
	name       string
	dicomstore *DicomStore
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the specified DICOM store.
//
//   - name: Identifier. Resource name of the DICOM store, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresService) Patch(name string, dicomstore *DicomStore) *ProjectsLocationsDatasetsDicomStoresPatchCall {
	c := &ProjectsLocationsDatasetsDicomStoresPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.dicomstore = dicomstore
	return c
}

// UpdateMask sets the optional parameter "updateMask": The update mask applies
// to the resource. For the `FieldMask` definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
func (c *ProjectsLocationsDatasetsDicomStoresPatchCall) UpdateMask(updateMask string) *ProjectsLocationsDatasetsDicomStoresPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresPatchCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.dicomstore)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *DicomStore.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresPatchCall) Do(opts ...googleapi.CallOption) (*DicomStore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DicomStore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresSearchForInstancesCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchForInstances: SearchForInstances returns a list of matching instances.
// See RetrieveTransaction
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4).
// For details on the implementation of SearchForInstances, see Search
// transaction
// (https://cloud.google.com/healthcare/docs/dicom#search_transaction) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call SearchForInstances, see Search for DICOM data
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#search-dicom).
//
//   - dicomWebPath: The path of the SearchForInstancesRequest DICOMweb request.
//     For example, `instances`, `series/{series_uid}/instances`, or
//     `studies/{study_uid}/instances`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresService) SearchForInstances(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresSearchForInstancesCall {
	c := &ProjectsLocationsDatasetsDicomStoresSearchForInstancesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForInstancesCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresSearchForInstancesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForInstancesCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresSearchForInstancesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForInstancesCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresSearchForInstancesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForInstancesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresSearchForInstancesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.searchForInstances" call.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForInstancesCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresSearchForSeriesCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchForSeries: SearchForSeries returns a list of matching series. See
// RetrieveTransaction
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4).
// For details on the implementation of SearchForSeries, see Search transaction
// (https://cloud.google.com/healthcare/docs/dicom#search_transaction) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call SearchForSeries, see Search for DICOM data
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#search-dicom).
//
//   - dicomWebPath: The path of the SearchForSeries DICOMweb request. For
//     example, `series` or `studies/{study_uid}/series`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresService) SearchForSeries(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresSearchForSeriesCall {
	c := &ProjectsLocationsDatasetsDicomStoresSearchForSeriesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForSeriesCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresSearchForSeriesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForSeriesCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresSearchForSeriesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForSeriesCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresSearchForSeriesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForSeriesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresSearchForSeriesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.searchForSeries" call.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForSeriesCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresSearchForStudiesCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchForStudies: SearchForStudies returns a list of matching studies. See
// RetrieveTransaction
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4).
// For details on the implementation of SearchForStudies, see Search
// transaction
// (https://cloud.google.com/healthcare/docs/dicom#search_transaction) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call SearchForStudies, see Search for DICOM data
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#search-dicom).
//
//   - dicomWebPath: The path of the SearchForStudies DICOMweb request. For
//     example, `studies`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresService) SearchForStudies(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresSearchForStudiesCall {
	c := &ProjectsLocationsDatasetsDicomStoresSearchForStudiesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForStudiesCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresSearchForStudiesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForStudiesCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresSearchForStudiesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForStudiesCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresSearchForStudiesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForStudiesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresSearchForStudiesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.searchForStudies" call.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForStudiesCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresSetBlobStorageSettingsCall struct {
	s                             *Service
	resource                      string
	setblobstoragesettingsrequest *SetBlobStorageSettingsRequest
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// SetBlobStorageSettings: SetBlobStorageSettings sets the blob storage
// settings of the specified resources.
//
//   - resource: The path of the resource to update the blob storage settings in
//     the format of
//     `projects/{projectID}/locations/{locationID}/datasets/{datasetID}/dicomStor
//     es/{dicomStoreID}/dicomWeb/studies/{studyUID}`,
//     `projects/{projectID}/locations/{locationID}/datasets/{datasetID}/dicomStor
//     es/{dicomStoreID}/dicomWeb/studies/{studyUID}/series/{seriesUID}/`, or
//     `projects/{projectID}/locations/{locationID}/datasets/{datasetID}/dicomStor
//     es/{dicomStoreID}/dicomWeb/studies/{studyUID}/series/{seriesUID}/instances/
//     {instanceUID}`. If `filter_config` is specified, set the value of
//     `resource` to the resource name of a DICOM store in the format
//     `projects/{projectID}/locations/{locationID}/datasets/{datasetID}/dicomStor
//     es/{dicomStoreID}`.
func (r *ProjectsLocationsDatasetsDicomStoresService) SetBlobStorageSettings(resource string, setblobstoragesettingsrequest *SetBlobStorageSettingsRequest) *ProjectsLocationsDatasetsDicomStoresSetBlobStorageSettingsCall {
	c := &ProjectsLocationsDatasetsDicomStoresSetBlobStorageSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setblobstoragesettingsrequest = setblobstoragesettingsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresSetBlobStorageSettingsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresSetBlobStorageSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresSetBlobStorageSettingsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresSetBlobStorageSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresSetBlobStorageSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresSetBlobStorageSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.setblobstoragesettingsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+resource}:setBlobStorageSettings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.setBlobStorageSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresSetBlobStorageSettingsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsDatasetsDicomStoresService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsDatasetsDicomStoresSetIamPolicyCall {
	c := &ProjectsLocationsDatasetsDicomStoresSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresStoreInstancesCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	body_        io.Reader
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// StoreInstances: StoreInstances stores DICOM instances associated with study
// instance unique identifiers (SUID). See Store Transaction
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.5).
// For details on the implementation of StoreInstances, see Store transaction
// (https://cloud.google.com/healthcare/docs/dicom#store_transaction) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call StoreInstances, see Store DICOM data
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#store-dicom).
//
//   - dicomWebPath: The path of the StoreInstances DICOMweb request. For
//     example, `studies/[{study_uid}]`. Note that the `study_uid` is optional.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresService) StoreInstances(parent string, dicomWebPath string, body_ io.Reader) *ProjectsLocationsDatasetsDicomStoresStoreInstancesCall {
	c := &ProjectsLocationsDatasetsDicomStoresStoreInstancesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	c.body_ = body_
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStoreInstancesCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStoreInstancesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStoreInstancesCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStoreInstancesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStoreInstancesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStoreInstancesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	body = c.body_
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.storeInstances" call.
func (c *ProjectsLocationsDatasetsDicomStoresStoreInstancesCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsDatasetsDicomStoresService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsDatasetsDicomStoresTestIamPermissionsCall {
	c := &ProjectsLocationsDatasetsDicomStoresTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresDicomWebStudiesGetStudyMetricsCall struct {
	s            *Service
	study        string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetStudyMetrics: GetStudyMetrics returns metrics for a study.
//
//   - study: The study resource path. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}/dicomWeb/studies/{study_uid}`.
func (r *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesService) GetStudyMetrics(study string) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesGetStudyMetricsCall {
	c := &ProjectsLocationsDatasetsDicomStoresDicomWebStudiesGetStudyMetricsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.study = study
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesGetStudyMetricsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesGetStudyMetricsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesGetStudyMetricsCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesGetStudyMetricsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesGetStudyMetricsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesGetStudyMetricsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesGetStudyMetricsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesGetStudyMetricsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+study}:getStudyMetrics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"study": c.study,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.getStudyMetrics" call.
// Any non-2xx status code is an error. Response headers are in either
// *StudyMetrics.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesGetStudyMetricsCall) Do(opts ...googleapi.CallOption) (*StudyMetrics, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &StudyMetrics{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSetBlobStorageSettingsCall struct {
	s                             *Service
	resource                      string
	setblobstoragesettingsrequest *SetBlobStorageSettingsRequest
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// SetBlobStorageSettings: SetBlobStorageSettings sets the blob storage
// settings of the specified resources.
//
//   - resource: The path of the resource to update the blob storage settings in
//     the format of
//     `projects/{projectID}/locations/{locationID}/datasets/{datasetID}/dicomStor
//     es/{dicomStoreID}/dicomWeb/studies/{studyUID}`,
//     `projects/{projectID}/locations/{locationID}/datasets/{datasetID}/dicomStor
//     es/{dicomStoreID}/dicomWeb/studies/{studyUID}/series/{seriesUID}/`, or
//     `projects/{projectID}/locations/{locationID}/datasets/{datasetID}/dicomStor
//     es/{dicomStoreID}/dicomWeb/studies/{studyUID}/series/{seriesUID}/instances/
//     {instanceUID}`. If `filter_config` is specified, set the value of
//     `resource` to the resource name of a DICOM store in the format
//     `projects/{projectID}/locations/{locationID}/datasets/{datasetID}/dicomStor
//     es/{dicomStoreID}`.
func (r *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesService) SetBlobStorageSettings(resource string, setblobstoragesettingsrequest *SetBlobStorageSettingsRequest) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSetBlobStorageSettingsCall {
	c := &ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSetBlobStorageSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setblobstoragesettingsrequest = setblobstoragesettingsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSetBlobStorageSettingsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSetBlobStorageSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSetBlobStorageSettingsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSetBlobStorageSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSetBlobStorageSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSetBlobStorageSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.setblobstoragesettingsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+resource}:setBlobStorageSettings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.setBlobStorageSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSetBlobStorageSettingsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesGetSeriesMetricsCall struct {
	s            *Service
	series       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetSeriesMetrics: GetSeriesMetrics returns metrics for a series.
//
//   - series: The series resource path. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}/dicomWeb/studies/{study_uid}/series/{series_uid}`.
func (r *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesService) GetSeriesMetrics(series string) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesGetSeriesMetricsCall {
	c := &ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesGetSeriesMetricsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.series = series
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesGetSeriesMetricsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesGetSeriesMetricsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesGetSeriesMetricsCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesGetSeriesMetricsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesGetSeriesMetricsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesGetSeriesMetricsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesGetSeriesMetricsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesGetSeriesMetricsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+series}:getSeriesMetrics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"series": c.series,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.series.getSeriesMetrics" call.
// Any non-2xx status code is an error. Response headers are in either
// *SeriesMetrics.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesGetSeriesMetricsCall) Do(opts ...googleapi.CallOption) (*SeriesMetrics, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SeriesMetrics{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesGetStorageInfoCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetStorageInfo: GetStorageInfo returns the storage info of the specified
// resource.
//
//   - resource: The path of the instance to return storage info for, in the
//     form:
//     `projects/{projectID}/locations/{locationID}/datasets/{datasetID}/dicomStor
//     es/{dicomStoreID}/dicomWeb/studies/{studyUID}/series/{seriesUID}/instances/
//     {instanceUID}`.
func (r *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesService) GetStorageInfo(resource string) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesGetStorageInfoCall {
	c := &ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesGetStorageInfoCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesGetStorageInfoCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesGetStorageInfoCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesGetStorageInfoCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesGetStorageInfoCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesGetStorageInfoCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesGetStorageInfoCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesGetStorageInfoCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesGetStorageInfoCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+resource}:getStorageInfo")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.series.instances.getStorageInfo" call.
// Any non-2xx status code is an error. Response headers are in either
// *StorageInfo.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesGetStorageInfoCall) Do(opts ...googleapi.CallOption) (*StorageInfo, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &StorageInfo{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresStudiesDeleteCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Delete: DeleteStudy deletes all instances within the given study using a
// long running operation. The method returns an Operation which will be marked
// successful when the deletion is complete. Warning: Instances cannot be
// inserted into a study that is being deleted by an operation until the
// operation completes. For samples that show how to call DeleteStudy, see
// Delete a study, series, or instance
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#delete-dicom).
//
//   - dicomWebPath: The path of the DeleteStudy request. For example,
//     `studies/{study_uid}`.
//   - parent: .
func (r *ProjectsLocationsDatasetsDicomStoresStudiesService) Delete(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesDeleteCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// RetrieveMetadata: RetrieveStudyMetadata returns instance associated with the
// given study presented as metadata with the bulk data removed. See
// RetrieveTransaction
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4).
// For details on the implementation of RetrieveStudyMetadata, see Metadata
// resources
// (https://cloud.google.com/healthcare/docs/dicom#metadata_resources) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call RetrieveStudyMetadata, see Retrieve metadata
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#retrieve-metadata).
//
//   - dicomWebPath: The path of the RetrieveStudyMetadata DICOMweb request. For
//     example, `studies/{study_uid}/metadata`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesService) RetrieveMetadata(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.retrieveMetadata" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// RetrieveStudy: RetrieveStudy returns all instances within the given study.
// See RetrieveTransaction
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4).
// For details on the implementation of RetrieveStudy, see DICOM
// study/series/instances
// (https://cloud.google.com/healthcare/docs/dicom#dicom_studyseriesinstances)
// in the Cloud Healthcare API conformance statement. For samples that show how
// to call RetrieveStudy, see Retrieve DICOM data
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#retrieve-dicom).
//
//   - dicomWebPath: The path of the RetrieveStudy DICOMweb request. For example,
//     `studies/{study_uid}`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesService) RetrieveStudy(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.retrieveStudy" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresStudiesSearchForInstancesCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchForInstances: SearchForInstances returns a list of matching instances.
// See RetrieveTransaction
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4).
// For details on the implementation of SearchForInstances, see Search
// transaction
// (https://cloud.google.com/healthcare/docs/dicom#search_transaction) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call SearchForInstances, see Search for DICOM data
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#search-dicom).
//
//   - dicomWebPath: The path of the SearchForInstancesRequest DICOMweb request.
//     For example, `instances`, `series/{series_uid}/instances`, or
//     `studies/{study_uid}/instances`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesService) SearchForInstances(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesSearchForInstancesCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesSearchForInstancesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSearchForInstancesCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesSearchForInstancesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSearchForInstancesCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresStudiesSearchForInstancesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSearchForInstancesCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesSearchForInstancesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSearchForInstancesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesSearchForInstancesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.searchForInstances" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSearchForInstancesCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchForSeries: SearchForSeries returns a list of matching series. See
// RetrieveTransaction
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4).
// For details on the implementation of SearchForSeries, see Search transaction
// (https://cloud.google.com/healthcare/docs/dicom#search_transaction) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call SearchForSeries, see Search for DICOM data
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#search-dicom).
//
//   - dicomWebPath: The path of the SearchForSeries DICOMweb request. For
//     example, `series` or `studies/{study_uid}/series`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesService) SearchForSeries(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.searchForSeries" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresStudiesStoreInstancesCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	body_        io.Reader
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// StoreInstances: StoreInstances stores DICOM instances associated with study
// instance unique identifiers (SUID). See Store Transaction
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.5).
// For details on the implementation of StoreInstances, see Store transaction
// (https://cloud.google.com/healthcare/docs/dicom#store_transaction) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call StoreInstances, see Store DICOM data
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#store-dicom).
//
//   - dicomWebPath: The path of the StoreInstances DICOMweb request. For
//     example, `studies/[{study_uid}]`. Note that the `study_uid` is optional.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesService) StoreInstances(parent string, dicomWebPath string, body_ io.Reader) *ProjectsLocationsDatasetsDicomStoresStudiesStoreInstancesCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesStoreInstancesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	c.body_ = body_
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesStoreInstancesCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesStoreInstancesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesStoreInstancesCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesStoreInstancesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesStoreInstancesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesStoreInstancesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	body = c.body_
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.storeInstances" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesStoreInstancesCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesDeleteCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Delete: DeleteSeries deletes all instances within the given study and series
// using a long running operation. The method returns an Operation which will
// be marked successful when the deletion is complete. Warning: Instances
// cannot be inserted into a series that is being deleted by an operation until
// the operation completes. For samples that show how to call DeleteSeries, see
// Delete a study, series, or instance
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#delete-dicom).
//
//   - dicomWebPath: The path of the DeleteSeries request. For example,
//     `studies/{study_uid}/series/{series_uid}`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesSeriesService) Delete(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesDeleteCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.series.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMetadataCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// RetrieveMetadata: RetrieveSeriesMetadata returns instance associated with
// the given study and series, presented as metadata with the bulk data
// removed. See RetrieveTransaction
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4).
// For details on the implementation of RetrieveSeriesMetadata, see Metadata
// resources
// (https://cloud.google.com/healthcare/docs/dicom#metadata_resources) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call RetrieveSeriesMetadata, see Retrieve metadata
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#retrieve-metadata).
//
//   - dicomWebPath: The path of the RetrieveSeriesMetadata DICOMweb request. For
//     example, `studies/{study_uid}/series/{series_uid}/metadata`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesSeriesService) RetrieveMetadata(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMetadataCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMetadataCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMetadataCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMetadataCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMetadataCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMetadataCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMetadataCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMetadataCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMetadataCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMetadataCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.series.retrieveMetadata" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMetadataCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSeriesCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// RetrieveSeries: RetrieveSeries returns all instances within the given study
// and series. See RetrieveTransaction
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4).
// For details on the implementation of RetrieveSeries, see DICOM
// study/series/instances
// (https://cloud.google.com/healthcare/docs/dicom#dicom_studyseriesinstances)
// in the Cloud Healthcare API conformance statement. For samples that show how
// to call RetrieveSeries, see Retrieve DICOM data
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#retrieve-dicom).
//
//   - dicomWebPath: The path of the RetrieveSeries DICOMweb request. For
//     example, `studies/{study_uid}/series/{series_uid}`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesSeriesService) RetrieveSeries(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSeriesCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSeriesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSeriesCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSeriesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSeriesCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSeriesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSeriesCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSeriesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSeriesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSeriesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.series.retrieveSeries" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSeriesCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForInstancesCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchForInstances: SearchForInstances returns a list of matching instances.
// See RetrieveTransaction
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4).
// For details on the implementation of SearchForInstances, see Search
// transaction
// (https://cloud.google.com/healthcare/docs/dicom#search_transaction) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call SearchForInstances, see Search for DICOM data
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#search-dicom).
//
//   - dicomWebPath: The path of the SearchForInstancesRequest DICOMweb request.
//     For example, `instances`, `series/{series_uid}/instances`, or
//     `studies/{study_uid}/instances`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesSeriesService) SearchForInstances(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForInstancesCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForInstancesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForInstancesCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForInstancesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForInstancesCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForInstancesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForInstancesCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForInstancesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForInstancesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForInstancesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.series.searchForInstances" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForInstancesCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesDeleteCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Delete: DeleteInstance deletes an instance associated with the given study,
// series, and SOP Instance UID. Delete requests are equivalent to the GET
// requests specified in the Retrieve transaction. Study and series search
// results can take a few seconds to be updated after an instance is deleted
// using DeleteInstance. For samples that show how to call DeleteInstance, see
// Delete a study, series, or instance
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#delete-dicom).
//
//   - dicomWebPath: The path of the DeleteInstance request. For example,
//     `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesService) Delete(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesDeleteCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.series.instances.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveInstanceCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// RetrieveInstance: RetrieveInstance returns instance associated with the
// given study, series, and SOP Instance UID. See RetrieveTransaction
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4).
// For details on the implementation of RetrieveInstance, see DICOM
// study/series/instances
// (https://cloud.google.com/healthcare/docs/dicom#dicom_studyseriesinstances)
// and DICOM instances
// (https://cloud.google.com/healthcare/docs/dicom#dicom_instances) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call RetrieveInstance, see Retrieve an instance
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#retrieve-instance).
//
//   - dicomWebPath: The path of the RetrieveInstance DICOMweb request. For
//     example,
//     `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesService) RetrieveInstance(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveInstanceCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveInstanceCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveInstanceCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveInstanceCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveInstanceCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveInstanceCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveInstanceCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveInstanceCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveInstanceCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveInstanceCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.series.instances.retrieveInstance" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveInstanceCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveMetadataCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// RetrieveMetadata: RetrieveInstanceMetadata returns instance associated with
// the given study, series, and SOP Instance UID presented as metadata with the
// bulk data removed. See RetrieveTransaction
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4).
// For details on the implementation of RetrieveInstanceMetadata, see Metadata
// resources
// (https://cloud.google.com/healthcare/docs/dicom#metadata_resources) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call RetrieveInstanceMetadata, see Retrieve metadata
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#retrieve-metadata).
//
//   - dicomWebPath: The path of the RetrieveInstanceMetadata DICOMweb request.
//     For example,
//     `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}/metadata`
//     .
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesService) RetrieveMetadata(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveMetadataCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveMetadataCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveMetadataCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveMetadataCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveMetadataCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveMetadataCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveMetadataCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveMetadataCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveMetadataCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveMetadataCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.series.instances.retrieveMetadata" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveMetadataCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// RetrieveRendered: RetrieveRenderedInstance returns instance associated with
// the given study, series, and SOP Instance UID in an acceptable Rendered
// Media Type. See RetrieveTransaction
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4).
// For details on the implementation of RetrieveRenderedInstance, see Rendered
// resources
// (https://cloud.google.com/healthcare/docs/dicom#rendered_resources) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call RetrieveRenderedInstance, see Retrieve consumer image formats
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#retrieve-consumer).
//
//   - dicomWebPath: The path of the RetrieveRenderedInstance DICOMweb request.
//     For example,
//     `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}/rendered`
//     .
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesService) RetrieveRendered(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.series.instances.retrieveRendered" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataRetrieveBulkdataCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// RetrieveBulkdata: Returns uncompressed, unencoded bytes representing the
// referenced bulkdata tag from an instance. See [Retrieve Transaction]
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4){:
// .external}. For details on the implementation of RetrieveBulkdata, see
// Bulkdata resources
// (https://cloud.google.com/healthcare/docs/dicom#bulkdata-resources) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call RetrieveBulkdata, see Retrieve bulkdata
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#retrieve-bulkdata).
//
//   - dicomWebPath: The path for the `RetrieveBulkdata` DICOMweb request. For
//     example,
//     `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}/bukdata/{
//     bulkdata_uri}`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataService) RetrieveBulkdata(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataRetrieveBulkdataCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataRetrieveBulkdataCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataRetrieveBulkdataCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataRetrieveBulkdataCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataRetrieveBulkdataCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataRetrieveBulkdataCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataRetrieveBulkdataCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataRetrieveBulkdataCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataRetrieveBulkdataCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataRetrieveBulkdataCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.series.instances.bulkdata.retrieveBulkdata" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataRetrieveBulkdataCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveFramesCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// RetrieveFrames: RetrieveFrames returns instances associated with the given
// study, series, SOP Instance UID and frame numbers. See RetrieveTransaction
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4).
// For details on the implementation of RetrieveFrames, see DICOM frames
// (https://cloud.google.com/healthcare/docs/dicom#dicom_frames) in the Cloud
// Healthcare API conformance statement. For samples that show how to call
// RetrieveFrames, see Retrieve DICOM data
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#retrieve-dicom).
//
//   - dicomWebPath: The path of the RetrieveFrames DICOMweb request. For
//     example,
//     `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}/frames/{f
//     rame_list}`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesService) RetrieveFrames(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveFramesCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveFramesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveFramesCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveFramesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveFramesCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveFramesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveFramesCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveFramesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveFramesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveFramesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.series.instances.frames.retrieveFrames" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveFramesCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// RetrieveRendered: RetrieveRenderedFrames returns instances associated with
// the given study, series, SOP Instance UID and frame numbers in an acceptable
// Rendered Media Type. See RetrieveTransaction
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4).
// For details on the implementation of RetrieveRenderedFrames, see Rendered
// resources
// (https://cloud.google.com/healthcare/docs/dicom#rendered_resources) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call RetrieveRenderedFrames, see Retrieve consumer image formats
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#retrieve-consumer).
//
//   - dicomWebPath: The path of the RetrieveRenderedFrames DICOMweb request. For
//     example,
//     `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}/frames/{f
//     rame_list}/rendered`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesService) RetrieveRendered(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.series.instances.frames.retrieveRendered" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresApplyAdminConsentsCall struct {
	s                         *Service
	name                      string
	applyadminconsentsrequest *ApplyAdminConsentsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// ApplyAdminConsents: Applies the admin Consent resources for the FHIR store
// and reindexes the underlying resources in the FHIR store according to the
// aggregate consents. This method also updates the
// `consent_config.enforced_admin_consents` field of the FhirStore unless
// `validate_only=true` in ApplyAdminConsentsRequest. Any admin Consent
// resource change after this operation execution (including deletion) requires
// you to call ApplyAdminConsents again for the change to take effect. This
// method returns an Operation that can be used to track the progress of the
// resources that were reindexed, by calling GetOperation. Upon completion, the
// ApplyAdminConsentsResponse additionally contains the number of resources
// that were reindexed. If at least one Consent resource contains an error or
// fails be be enforced for any reason, the method returns an error instead of
// an Operation. No resources will be reindexed and the
// `consent_config.enforced_admin_consents` field will be unchanged. To enforce
// a consent check for data access, `consent_config.access_enforced` must be
// set to true for the FhirStore.
//
//   - name: The name of the FHIR store to enforce, in the format
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirSt
//     ores/{fhir_store_id}`.
func (r *ProjectsLocationsDatasetsFhirStoresService) ApplyAdminConsents(name string, applyadminconsentsrequest *ApplyAdminConsentsRequest) *ProjectsLocationsDatasetsFhirStoresApplyAdminConsentsCall {
	c := &ProjectsLocationsDatasetsFhirStoresApplyAdminConsentsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.applyadminconsentsrequest = applyadminconsentsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresApplyAdminConsentsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresApplyAdminConsentsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresApplyAdminConsentsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresApplyAdminConsentsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresApplyAdminConsentsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresApplyAdminConsentsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.applyadminconsentsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:applyAdminConsents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.applyAdminConsents" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresApplyAdminConsentsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresApplyConsentsCall struct {
	s                    *Service
	name                 string
	applyconsentsrequest *ApplyConsentsRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// ApplyConsents: Apply the Consent resources for the FHIR store and reindex
// the underlying resources in the FHIR store according to the aggregate
// consent. The aggregate consent of the patient in scope in this request
// replaces any previous call of this method. Any Consent resource change after
// this operation execution (including deletion) requires you to call
// ApplyConsents again to have effect. This method returns an Operation that
// can be used to track the progress of the consent resources that were
// processed by calling GetOperation. Upon completion, the
// ApplyConsentsResponse additionally contains the number of resources that was
// reindexed. Errors are logged to Cloud Logging (see Viewing error logs in
// Cloud Logging (https://cloud.google.com/healthcare/docs/how-tos/logging)).
// To enforce consent check for data access, `consent_config.access_enforced`
// must be set to true for the FhirStore.
//
//   - name: The name of the FHIR store to enforce, in the format
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirSt
//     ores/{fhir_store_id}`.
func (r *ProjectsLocationsDatasetsFhirStoresService) ApplyConsents(name string, applyconsentsrequest *ApplyConsentsRequest) *ProjectsLocationsDatasetsFhirStoresApplyConsentsCall {
	c := &ProjectsLocationsDatasetsFhirStoresApplyConsentsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.applyconsentsrequest = applyconsentsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresApplyConsentsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresApplyConsentsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresApplyConsentsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresApplyConsentsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresApplyConsentsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresApplyConsentsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.applyconsentsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:applyConsents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.applyConsents" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresApplyConsentsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresConfigureSearchCall struct {
	s                      *Service
	name                   string
	configuresearchrequest *ConfigureSearchRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// ConfigureSearch: Configure the search parameters for the FHIR store and
// reindex resources in the FHIR store according to the defined search
// parameters. The search parameters provided in this request will replace any
// previous search configuration. The target SearchParameter resources need to
// exist in the store before calling ConfigureSearch, otherwise an error will
// occur. This method returns an Operation that can be used to track the
// progress of the reindexing by calling GetOperation.
//
//   - name: The name of the FHIR store to configure, in the format
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirSt
//     ores/{fhir_store_id}`.
func (r *ProjectsLocationsDatasetsFhirStoresService) ConfigureSearch(name string, configuresearchrequest *ConfigureSearchRequest) *ProjectsLocationsDatasetsFhirStoresConfigureSearchCall {
	c := &ProjectsLocationsDatasetsFhirStoresConfigureSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.configuresearchrequest = configuresearchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresConfigureSearchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresConfigureSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresConfigureSearchCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresConfigureSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresConfigureSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresConfigureSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.configuresearchrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:configureSearch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.configureSearch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresConfigureSearchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresCreateCall struct {
	s          *Service
	parent     string
	fhirstore  *FhirStore
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new FHIR store within the parent dataset.
//
// - parent: The name of the dataset this FHIR store belongs to.
func (r *ProjectsLocationsDatasetsFhirStoresService) Create(parent string, fhirstore *FhirStore) *ProjectsLocationsDatasetsFhirStoresCreateCall {
	c := &ProjectsLocationsDatasetsFhirStoresCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.fhirstore = fhirstore
	return c
}

// FhirStoreId sets the optional parameter "fhirStoreId": Required. The ID of
// the FHIR store that is being created. The string must match the following
// regex: `[\p{L}\p{N}_\-\.]{1,256}`.
func (c *ProjectsLocationsDatasetsFhirStoresCreateCall) FhirStoreId(fhirStoreId string) *ProjectsLocationsDatasetsFhirStoresCreateCall {
	c.urlParams_.Set("fhirStoreId", fhirStoreId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresCreateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.fhirstore)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/fhirStores")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *FhirStore.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresCreateCall) Do(opts ...googleapi.CallOption) (*FhirStore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FhirStore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresDeidentifyCall struct {
	s                          *Service
	sourceStore                string
	deidentifyfhirstorerequest *DeidentifyFhirStoreRequest
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// Deidentify: De-identifies data from the source store and writes it to the
// destination store. The metadata field type is OperationMetadata. If the
// request is successful, the response field type is
// DeidentifyFhirStoreSummary. The number of resources processed are tracked in
// Operation.metadata. Error details are logged to Cloud Logging. For more
// information, see Viewing error logs in Cloud Logging
// (https://cloud.google.com/healthcare/docs/how-tos/logging).
//
//   - sourceStore: Source FHIR store resource name. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirSt
//     ores/{fhir_store_id}`.
func (r *ProjectsLocationsDatasetsFhirStoresService) Deidentify(sourceStore string, deidentifyfhirstorerequest *DeidentifyFhirStoreRequest) *ProjectsLocationsDatasetsFhirStoresDeidentifyCall {
	c := &ProjectsLocationsDatasetsFhirStoresDeidentifyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.sourceStore = sourceStore
	c.deidentifyfhirstorerequest = deidentifyfhirstorerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresDeidentifyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresDeidentifyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresDeidentifyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresDeidentifyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresDeidentifyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresDeidentifyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.deidentifyfhirstorerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+sourceStore}:deidentify")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"sourceStore": c.sourceStore,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.deidentify" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresDeidentifyCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified FHIR store and removes all resources within
// it.
//
// - name: The resource name of the FHIR store to delete.
func (r *ProjectsLocationsDatasetsFhirStoresService) Delete(name string) *ProjectsLocationsDatasetsFhirStoresDeleteCall {
	c := &ProjectsLocationsDatasetsFhirStoresDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ExplainDataAccess: Explains all the permitted/denied actor, purpose and
// environment for a given resource.
//
//   - name: The name of the FHIR store to enforce, in the format
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirSt
//     ores/{fhir_store_id}`.
func (r *ProjectsLocationsDatasetsFhirStoresService) ExplainDataAccess(name string) *ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall {
	c := &ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ResourceId sets the optional parameter "resourceId": Required. The ID
// (`{resourceType}/{id}`) of the resource to explain data access on.
func (c *ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall) ResourceId(resourceId string) *ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall {
	c.urlParams_.Set("resourceId", resourceId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:explainDataAccess")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.explainDataAccess" call.
// Any non-2xx status code is an error. Response headers are in either
// *ExplainDataAccessResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall) Do(opts ...googleapi.CallOption) (*ExplainDataAccessResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ExplainDataAccessResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresExportCall struct {
	s                      *Service
	name                   string
	exportresourcesrequest *ExportResourcesRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Export: Export resources from the FHIR store to the specified destination.
// This method returns an Operation that can be used to track the status of the
// export by calling GetOperation. Immediate fatal errors appear in the error
// field, errors are also logged to Cloud Logging (see Viewing error logs in
// Cloud Logging (https://cloud.google.com/healthcare/docs/how-tos/logging)).
// Otherwise, when the operation finishes, a detailed response of type
// ExportResourcesResponse is returned in the response field. The metadata
// field type for this operation is OperationMetadata.
//
//   - name: The name of the FHIR store to export resource from, in the format of
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirSt
//     ores/{fhir_store_id}`.
func (r *ProjectsLocationsDatasetsFhirStoresService) Export(name string, exportresourcesrequest *ExportResourcesRequest) *ProjectsLocationsDatasetsFhirStoresExportCall {
	c := &ProjectsLocationsDatasetsFhirStoresExportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.exportresourcesrequest = exportresourcesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresExportCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresExportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresExportCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresExportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresExportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresExportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.exportresourcesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:export")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.export" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresExportCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresExportHistoryCall struct {
	s                             *Service
	name                          string
	exportresourceshistoryrequest *ExportResourcesHistoryRequest
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// ExportHistory: Export resources including historical versions from the FHIR
// store to the specified destination. The exported resource, along with
// previous versions, will be exported in one or more FHIR history bundles.
// This method returns an Operation that can be used to track the status of the
// export by calling GetOperation. Immediate fatal errors appear in the error
// field, errors are also logged to Cloud Logging (see Viewing error logs in
// Cloud Logging (https://cloud.google.com/healthcare/docs/how-tos/logging)).
// Otherwise, when the operation finishes, a detailed response of type
// ExportResourcesResponse is returned in the response field. The metadata
// field type for this operation is OperationMetadata.
//
//   - name: The name of the FHIR store to export resource from, in the format
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirSt
//     ores/{fhir_store_id}`.
func (r *ProjectsLocationsDatasetsFhirStoresService) ExportHistory(name string, exportresourceshistoryrequest *ExportResourcesHistoryRequest) *ProjectsLocationsDatasetsFhirStoresExportHistoryCall {
	c := &ProjectsLocationsDatasetsFhirStoresExportHistoryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.exportresourceshistoryrequest = exportresourceshistoryrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresExportHistoryCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresExportHistoryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresExportHistoryCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresExportHistoryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresExportHistoryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresExportHistoryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.exportresourceshistoryrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:exportHistory")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.exportHistory" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresExportHistoryCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the configuration of the specified FHIR store.
//
// - name: The resource name of the FHIR store to get.
func (r *ProjectsLocationsDatasetsFhirStoresService) Get(name string) *ProjectsLocationsDatasetsFhirStoresGetCall {
	c := &ProjectsLocationsDatasetsFhirStoresGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresGetCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *FhirStore.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresGetCall) Do(opts ...googleapi.CallOption) (*FhirStore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FhirStore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresGetFHIRStoreMetricsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetFHIRStoreMetrics: Gets metrics associated with the FHIR store.
//
// - name: The resource name of the FHIR store to get metrics for.
func (r *ProjectsLocationsDatasetsFhirStoresService) GetFHIRStoreMetrics(name string) *ProjectsLocationsDatasetsFhirStoresGetFHIRStoreMetricsCall {
	c := &ProjectsLocationsDatasetsFhirStoresGetFHIRStoreMetricsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresGetFHIRStoreMetricsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresGetFHIRStoreMetricsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresGetFHIRStoreMetricsCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresGetFHIRStoreMetricsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresGetFHIRStoreMetricsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresGetFHIRStoreMetricsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresGetFHIRStoreMetricsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresGetFHIRStoreMetricsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:getFHIRStoreMetrics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.getFHIRStoreMetrics" call.
// Any non-2xx status code is an error. Response headers are in either
// *FhirStoreMetrics.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsFhirStoresGetFHIRStoreMetricsCall) Do(opts ...googleapi.CallOption) (*FhirStoreMetrics, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FhirStoreMetrics{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsDatasetsFhirStoresService) GetIamPolicy(resource string) *ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall {
	c := &ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresImportCall struct {
	s                      *Service
	name                   string
	importresourcesrequest *ImportResourcesRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Import: Import resources to the FHIR store by loading data from the
// specified sources. This method is optimized to load large quantities of data
// using import semantics that ignore some FHIR store configuration options and
// are not suitable for all use cases. It is primarily intended to load data
// into an empty FHIR store that is not being used by other clients. In cases
// where this method is not appropriate, consider using ExecuteBundle to load
// data. Every resource in the input must contain a client-supplied ID. Each
// resource is stored using the supplied ID regardless of the
// enable_update_create setting on the FHIR store. It is strongly advised not
// to include or encode any sensitive data such as patient identifiers in
// client-specified resource IDs. Those IDs are part of the FHIR resource path
// recorded in Cloud Audit Logs and Cloud Pub/Sub notifications. Those IDs can
// also be contained in reference fields within other resources. The import
// process does not enforce referential integrity, regardless of the
// disable_referential_integrity setting on the FHIR store. This allows the
// import of resources with arbitrary interdependencies without considering
// grouping or ordering, but if the input data contains invalid references or
// if some resources fail to be imported, the FHIR store might be left in a
// state that violates referential integrity. The import process does not
// trigger Pub/Sub notification or BigQuery streaming update, regardless of how
// those are configured on the FHIR store. If a resource with the specified ID
// already exists, the most recent version of the resource is overwritten
// without creating a new historical version, regardless of the
// disable_resource_versioning setting on the FHIR store. If transient failures
// occur during the import, it is possible that successfully imported resources
// will be overwritten more than once. The import operation is idempotent
// unless the input data contains multiple valid resources with the same ID but
// different contents. In that case, after the import completes, the store
// contains exactly one resource with that ID but there is no ordering
// guarantee on which version of the contents it will have. The operation
// result counters do not count duplicate IDs as an error and count one success
// for each resource in the input, which might result in a success count larger
// than the number of resources in the FHIR store. This often occurs when
// importing data organized in bundles produced by Patient-everything where
// each bundle contains its own copy of a resource such as Practitioner that
// might be referred to by many patients. If some resources fail to import, for
// example due to parsing errors, successfully imported resources are not
// rolled back. The location and format of the input data are specified by the
// parameters in ImportResourcesRequest. Note that if no format is specified,
// this method assumes the `BUNDLE` format. When using the `BUNDLE` format this
// method ignores the `Bundle.type` field, except that `history` bundles are
// rejected, and does not apply any of the bundle processing semantics for
// batch or transaction bundles. Unlike in ExecuteBundle, transaction bundles
// are not executed as a single transaction and bundle-internal references are
// not rewritten. The bundle is treated as a collection of resources to be
// written as provided in `Bundle.entry.resource`, ignoring
// `Bundle.entry.request`. As an example, this allows the import of `searchset`
// bundles produced by a FHIR search or Patient-everything operation. This
// method returns an Operation that can be used to track the status of the
// import by calling GetOperation. Immediate fatal errors appear in the error
// field, errors are also logged to Cloud Logging (see Viewing error logs in
// Cloud Logging (https://cloud.google.com/healthcare/docs/how-tos/logging)).
// Otherwise, when the operation finishes, a detailed response of type
// ImportResourcesResponse is returned in the response field. The metadata
// field type for this operation is OperationMetadata.
//
//   - name: The name of the FHIR store to import FHIR resources to, in the
//     format of
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirSt
//     ores/{fhir_store_id}`.
func (r *ProjectsLocationsDatasetsFhirStoresService) Import(name string, importresourcesrequest *ImportResourcesRequest) *ProjectsLocationsDatasetsFhirStoresImportCall {
	c := &ProjectsLocationsDatasetsFhirStoresImportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.importresourcesrequest = importresourcesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresImportCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresImportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresImportCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresImportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresImportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresImportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.importresourcesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:import")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.import" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresImportCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresImportHistoryCall struct {
	s                             *Service
	name                          string
	importresourceshistoryrequest *ImportResourcesHistoryRequest
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// ImportHistory: Import resource historical versions from Cloud Storage source
// to destination fhir store. The exported resource, along with previous
// versions, will be exported in one or more FHIR history bundles. This method
// returns an Operation that can be used to track the status of the export by
// calling GetOperation. Immediate fatal errors appear in the error field,
// errors are also logged to Cloud Logging (see Viewing error logs in Cloud
// Logging (https://cloud.google.com/healthcare/docs/how-tos/logging)).
// Otherwise, when the operation finishes, a detailed response of type
// ImportResourcesResponse is returned in the response field. The metadata
// field type for this operation is OperationMetadata.
//
//   - name: The name of the FHIR store to import FHIR resources to, in the
//     format of
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirSt
//     ores/{fhir_store_id}`.
func (r *ProjectsLocationsDatasetsFhirStoresService) ImportHistory(name string, importresourceshistoryrequest *ImportResourcesHistoryRequest) *ProjectsLocationsDatasetsFhirStoresImportHistoryCall {
	c := &ProjectsLocationsDatasetsFhirStoresImportHistoryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.importresourceshistoryrequest = importresourceshistoryrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresImportHistoryCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresImportHistoryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresImportHistoryCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresImportHistoryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresImportHistoryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresImportHistoryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.importresourceshistoryrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:importHistory")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.importHistory" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresImportHistoryCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the FHIR stores in the given dataset.
//
// - parent: Name of the dataset.
func (r *ProjectsLocationsDatasetsFhirStoresService) List(parent string) *ProjectsLocationsDatasetsFhirStoresListCall {
	c := &ProjectsLocationsDatasetsFhirStoresListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Restricts stores returned to
// those matching a filter. The following syntax is available: * A string field
// value can be written as text inside quotation marks, for example "query
// text". The only valid relational operation for text fields is equality
// (`=`), where text is searched within the field, rather than having the field
// be equal to the text. For example, "Comment = great" returns messages with
// `great` in the comment field. * A number field value can be written as an
// integer, a decimal, or an exponential. The valid relational operators for
// number fields are the equality operator (`=`), along with the less
// than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no
// inequality (`!=`) operator. You can prepend the `NOT` operator to an
// expression to negate it. * A date field value must be written in
// `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format.
// Leading zeros are required for one-digit months and days. The valid
// relational operators for date fields are the equality operator (`=`) , along
// with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that
// there is no inequality (`!=`) operator. You can prepend the `NOT` operator
// to an expression to negate it. * Multiple field query expressions can be
// combined in one query by adding `AND` or `OR` operators between the
// expressions. If a boolean operator appears within a quoted string, it is not
// treated as special, it's just another part of the character string to be
// matched. You can prepend the `NOT` operator to an expression to negate it.
// Only filtering on labels is supported, for example `labels.key=value`.
func (c *ProjectsLocationsDatasetsFhirStoresListCall) Filter(filter string) *ProjectsLocationsDatasetsFhirStoresListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Limit on the number of FHIR
// stores to return in a single response. If not specified, 100 is used. May
// not be larger than 1000.
func (c *ProjectsLocationsDatasetsFhirStoresListCall) PageSize(pageSize int64) *ProjectsLocationsDatasetsFhirStoresListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from the previous List request, if any.
func (c *ProjectsLocationsDatasetsFhirStoresListCall) PageToken(pageToken string) *ProjectsLocationsDatasetsFhirStoresListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresListCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/fhirStores")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListFhirStoresResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsFhirStoresListCall) Do(opts ...googleapi.CallOption) (*ListFhirStoresResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListFhirStoresResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDatasetsFhirStoresListCall) Pages(ctx context.Context, f func(*ListFhirStoresResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDatasetsFhirStoresPatchCall struct {
	s          *Service
	name       string
	fhirstore  *FhirStore
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the configuration of the specified FHIR store.
//
//   - name: Output only. Identifier. Resource name of the FHIR store, of the
//     form
//     `projects/{project_id}/locations/{location}/datasets/{dataset_id}/fhirStore
//     s/{fhir_store_id}`.
func (r *ProjectsLocationsDatasetsFhirStoresService) Patch(name string, fhirstore *FhirStore) *ProjectsLocationsDatasetsFhirStoresPatchCall {
	c := &ProjectsLocationsDatasetsFhirStoresPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.fhirstore = fhirstore
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The update
// mask applies to the resource. For the `FieldMask` definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
func (c *ProjectsLocationsDatasetsFhirStoresPatchCall) UpdateMask(updateMask string) *ProjectsLocationsDatasetsFhirStoresPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresPatchCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.fhirstore)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *FhirStore.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresPatchCall) Do(opts ...googleapi.CallOption) (*FhirStore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FhirStore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresRollbackCall struct {
	s                            *Service
	name                         string
	rollbackfhirresourcesrequest *RollbackFhirResourcesRequest
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// Rollback: Rolls back resources from the FHIR store to the specified time.
// This method returns an Operation that can be used to track the status of the
// rollback by calling GetOperation. Immediate fatal errors appear in the error
// field, errors are also logged to Cloud Logging (see Viewing error logs in
// Cloud Logging (https://cloud.google.com/healthcare/docs/how-tos/logging)).
// Otherwise, when the operation finishes, a detailed response of type
// RollbackFhirResourcesResponse is returned in the response field. The
// metadata field type for this operation is OperationMetadata.
//
//   - name: The name of the FHIR store to rollback, in the format of
//     "projects/{project_id}/locations/{location_id}/datasets/{dataset_id}
//     /fhirStores/{fhir_store_id}".
func (r *ProjectsLocationsDatasetsFhirStoresService) Rollback(name string, rollbackfhirresourcesrequest *RollbackFhirResourcesRequest) *ProjectsLocationsDatasetsFhirStoresRollbackCall {
	c := &ProjectsLocationsDatasetsFhirStoresRollbackCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.rollbackfhirresourcesrequest = rollbackfhirresourcesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresRollbackCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresRollbackCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresRollbackCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresRollbackCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresRollbackCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresRollbackCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.rollbackfhirresourcesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:rollback")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.rollback" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresRollbackCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsDatasetsFhirStoresService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsDatasetsFhirStoresSetIamPolicyCall {
	c := &ProjectsLocationsDatasetsFhirStoresSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsDatasetsFhirStoresService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsDatasetsFhirStoresTestIamPermissionsCall {
	c := &ProjectsLocationsDatasetsFhirStoresTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresFhirBinaryCreateCall struct {
	s          *Service
	parent     string
	body_      io.Reader
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// BinaryCreate: Creates a FHIR Binary resource. This method can be used to
// create a Binary resource either by using one of the accepted FHIR JSON
// content types, or as a raw data stream. If a resource is created with this
// method using the FHIR content type this method's behavior is the same as
// `fhir.create`
// (https://cloud.google.com/healthcare-api/docs/reference/rest/v1/projects.locations.datasets.fhirStores.fhir/create).
// If a resource type other than Binary is used in the request it's treated in
// the same way as non-FHIR data (e.g., images, zip archives, pdf files,
// documents). When a non-FHIR content type is used in the request, a Binary
// resource will be generated, and the uploaded data will be stored in the
// `content` field (`DSTU2` and `STU3`), or the `data` field (`R4`). The Binary
// resource's `contentType` will be filled in using the value of the
// `Content-Type` header, and the `securityContext` field (not present in
// `DSTU2`) will be populated from the `X-Security-Context` header if it
// exists. At this time `securityContext` has no special behavior in the Cloud
// Healthcare API. Note: the limit on data ingested through this method is 2
// GB. For best performance, use a non-FHIR data type instead of wrapping the
// data in a Binary resource. Some of the Healthcare API features, such as
// exporting to BigQuery
// (https://cloud.google.com/healthcare-api/docs/how-tos/fhir-export-bigquery)
// or Pub/Sub notifications
// (https://cloud.google.com/healthcare-api/docs/fhir-pubsub#behavior_when_a_fhir_resource_is_too_large_or_traffic_is_high)
// with full resource content, do not support Binary resources that are larger
// than 10 MB. In these cases the resource's `data` field will be omitted.
// Instead, the "http://hl7.org/fhir/StructureDefinition/data-absent-reason"
// extension will be present to indicate that including the data is
// `unsupported`. On success, an empty `201 Created` response is returned. The
// newly created resource's ID and version are returned in the Location header.
// Using `Prefer: representation=resource` is not allowed for this method. The
// definition of the Binary REST API can be found at
// https://hl7.org/fhir/binary.html#rest.
//
// - parent: The name of the FHIR store this resource belongs to.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) BinaryCreate(parent string, body_ io.Reader) *ProjectsLocationsDatasetsFhirStoresFhirBinaryCreateCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirBinaryCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.body_ = body_
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirBinaryCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryCreateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirBinaryCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	body = c.body_
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/fhir/Binary")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.Binary-create" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryCreateCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirBinaryReadCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// BinaryRead: Gets the contents of a FHIR Binary resource. This method can be
// used to retrieve a Binary resource either by using the FHIR JSON mimetype as
// the value for the Accept header, or as a raw data stream. If the FHIR Accept
// type is used this method will return a Binary resource with the data
// base64-encoded, regardless of how the resource was created. The resource
// data can be retrieved in base64-decoded form if the Accept type of the
// request matches the value of the resource's `contentType` field. The
// definition of the Binary REST API can be found at
// https://hl7.org/fhir/binary.html#rest.
//
// - name: The name of the Binary resource to retrieve.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) BinaryRead(name string) *ProjectsLocationsDatasetsFhirStoresFhirBinaryReadCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirBinaryReadCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryReadCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirBinaryReadCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryReadCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresFhirBinaryReadCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryReadCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirBinaryReadCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryReadCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryReadCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.Binary-read" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryReadCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirBinaryUpdateCall struct {
	s          *Service
	name       string
	body_      io.Reader
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// BinaryUpdate: Updates the entire contents of a Binary resource. If the
// specified resource does not exist and the FHIR store has
// enable_update_create set, creates the resource with the client-specified ID.
// It is strongly advised not to include or encode any sensitive data such as
// patient identifiers in client-specified resource IDs. Those IDs are part of
// the FHIR resource path recorded in Cloud Audit Logs and Pub/Sub
// notifications. Those IDs can also be contained in reference fields within
// other resources. This method can be used to update a Binary resource either
// by using one of the accepted FHIR JSON content types, or as a raw data
// stream. If a resource is updated with this method using the FHIR content
// type this method's behavior is the same as `update`. If a resource type
// other than Binary is used in the request it will be treated in the same way
// as non-FHIR data. When a non-FHIR content type is used in the request, a
// Binary resource will be generated using the ID from the resource path, and
// the uploaded data will be stored in the `content` field (`DSTU2` and
// `STU3`), or the `data` field (`R4`). The Binary resource's `contentType`
// will be filled in using the value of the `Content-Type` header, and the
// `securityContext` field (not present in `DSTU2`) will be populated from the
// `X-Security-Context` header if it exists. At this time `securityContext` has
// no special behavior in the Cloud Healthcare API. Note: the limit on data
// ingested through this method is 2 GB. For best performance, use a non-FHIR
// data type instead of wrapping the data in a Binary resource. Some of the
// Healthcare API features, such as exporting to BigQuery
// (https://cloud.google.com/healthcare-api/docs/how-tos/fhir-export-bigquery)
// or Pub/Sub notifications
// (https://cloud.google.com/healthcare-api/docs/fhir-pubsub#behavior_when_a_fhir_resource_is_too_large_or_traffic_is_high)
// with full resource content, do not support Binary resources that are larger
// than 10 MB. In these cases the resource's `data` field will be omitted.
// Instead, the "http://hl7.org/fhir/StructureDefinition/data-absent-reason"
// extension will be present to indicate that including the data is
// `unsupported`. On success, an empty 200 OK response will be returned, or a
// 201 Created if the resource did not exit. The resource's ID and version are
// returned in the Location header. Using `Prefer: representation=resource` is
// not allowed for this method. The definition of the Binary REST API can be
// found at https://hl7.org/fhir/binary.html#rest.
//
// - name: The name of the resource to update.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) BinaryUpdate(name string, body_ io.Reader) *ProjectsLocationsDatasetsFhirStoresFhirBinaryUpdateCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirBinaryUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.body_ = body_
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryUpdateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirBinaryUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryUpdateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirBinaryUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	body = c.body_
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.Binary-update" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryUpdateCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirBinaryVreadCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// BinaryVread: Gets the contents of a version (current or historical) of a
// FHIR Binary resource by version ID. This method can be used to retrieve a
// Binary resource version either by using the FHIR JSON mimetype as the value
// for the Accept header, or as a raw data stream. If the FHIR Accept type is
// used this method will return a Binary resource with the data base64-encoded,
// regardless of how the resource version was created. The resource data can be
// retrieved in base64-decoded form if the Accept type of the request matches
// the value of the resource version's `contentType` field. The definition of
// the Binary REST API can be found at https://hl7.org/fhir/binary.html#rest.
//
// - name: The name of the Binary resource version to retrieve.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) BinaryVread(name string) *ProjectsLocationsDatasetsFhirStoresFhirBinaryVreadCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirBinaryVreadCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryVreadCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirBinaryVreadCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryVreadCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresFhirBinaryVreadCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryVreadCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirBinaryVreadCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryVreadCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryVreadCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.Binary-vread" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryVreadCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirConceptMapSearchTranslateCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ConceptMapSearchTranslate: Translates a code from one value set to another
// by searching for appropriate concept maps. Implements the FHIR standard
// $translate operation (DSTU2
// (https://www.hl7.org/fhir/DSTU2/operation-conceptmap-translate.html), STU3
// (https://www.hl7.org/fhir/STU3/operation-conceptmap-translate.html), R4
// (https://www.hl7.org/fhir/R4/operation-conceptmap-translate.html)). On
// success, the response body contains a JSON-encoded representation of a FHIR
// Parameters resource, which includes the translation result. Errors generated
// by the FHIR store contain a JSON-encoded `OperationOutcome` resource
// describing the reason for the error. If the request cannot be mapped to a
// valid API method on a FHIR store, a generic GCP error might be returned
// instead.
//
//   - parent: The name for the FHIR store containing the concept map(s) to use
//     for the translation.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) ConceptMapSearchTranslate(parent string) *ProjectsLocationsDatasetsFhirStoresFhirConceptMapSearchTranslateCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirConceptMapSearchTranslateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Code sets the optional parameter "code": Required. The code to translate.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConceptMapSearchTranslateCall) Code(code string) *ProjectsLocationsDatasetsFhirStoresFhirConceptMapSearchTranslateCall {
	c.urlParams_.Set("code", code)
	return c
}

// ConceptMapVersion sets the optional parameter "conceptMapVersion": The
// version of the concept map to use. If unset, the most current version is
// used.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConceptMapSearchTranslateCall) ConceptMapVersion(conceptMapVersion string) *ProjectsLocationsDatasetsFhirStoresFhirConceptMapSearchTranslateCall {
	c.urlParams_.Set("conceptMapVersion", conceptMapVersion)
	return c
}

// Source sets the optional parameter "source": The source value set of the
// concept map to be used. If unset, target is used to search for concept maps.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConceptMapSearchTranslateCall) Source(source string) *ProjectsLocationsDatasetsFhirStoresFhirConceptMapSearchTranslateCall {
	c.urlParams_.Set("source", source)
	return c
}

// System sets the optional parameter "system": Required. The system for the
// code to be translated.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConceptMapSearchTranslateCall) System(system string) *ProjectsLocationsDatasetsFhirStoresFhirConceptMapSearchTranslateCall {
	c.urlParams_.Set("system", system)
	return c
}

// Target sets the optional parameter "target": The target value set of the
// concept map to be used. If unset, source is used to search for concept maps.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConceptMapSearchTranslateCall) Target(target string) *ProjectsLocationsDatasetsFhirStoresFhirConceptMapSearchTranslateCall {
	c.urlParams_.Set("target", target)
	return c
}

// Url sets the optional parameter "url": The canonical url of the concept map
// to use. If unset, the source and target is used to search for concept maps.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConceptMapSearchTranslateCall) Url(url string) *ProjectsLocationsDatasetsFhirStoresFhirConceptMapSearchTranslateCall {
	c.urlParams_.Set("url", url)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConceptMapSearchTranslateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirConceptMapSearchTranslateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConceptMapSearchTranslateCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresFhirConceptMapSearchTranslateCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConceptMapSearchTranslateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirConceptMapSearchTranslateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConceptMapSearchTranslateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirConceptMapSearchTranslateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/fhir/ConceptMap/$translate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.ConceptMap-search-translate" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConceptMapSearchTranslateCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirConceptMapTranslateCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ConceptMapTranslate: Translates a code from one value set to another using a
// concept map. You can provide your own concept maps to translate any code
// system to another code system. Implements the FHIR standard $translate
// operation (DSTU2
// (https://www.hl7.org/fhir/DSTU2/operation-conceptmap-translate.html), STU3
// (https://www.hl7.org/fhir/STU3/operation-conceptmap-translate.html), R4
// (https://www.hl7.org/fhir/R4/operation-conceptmap-translate.html)). On
// success, the response body contains a JSON-encoded representation of a FHIR
// Parameters resource, which includes the translation result. Errors generated
// by the FHIR store contain a JSON-encoded `OperationOutcome` resource
// describing the reason for the error. If the request cannot be mapped to a
// valid API method on a FHIR store, a generic GCP error might be returned
// instead.
//
// - name: The URL for the concept map to use for the translation.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) ConceptMapTranslate(name string) *ProjectsLocationsDatasetsFhirStoresFhirConceptMapTranslateCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirConceptMapTranslateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Code sets the optional parameter "code": Required. The code to translate.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConceptMapTranslateCall) Code(code string) *ProjectsLocationsDatasetsFhirStoresFhirConceptMapTranslateCall {
	c.urlParams_.Set("code", code)
	return c
}

// ConceptMapVersion sets the optional parameter "conceptMapVersion": The
// version of the concept map to use. If unset, the most current version is
// used.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConceptMapTranslateCall) ConceptMapVersion(conceptMapVersion string) *ProjectsLocationsDatasetsFhirStoresFhirConceptMapTranslateCall {
	c.urlParams_.Set("conceptMapVersion", conceptMapVersion)
	return c
}

// System sets the optional parameter "system": Required. The system for the
// code to be translated.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConceptMapTranslateCall) System(system string) *ProjectsLocationsDatasetsFhirStoresFhirConceptMapTranslateCall {
	c.urlParams_.Set("system", system)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConceptMapTranslateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirConceptMapTranslateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConceptMapTranslateCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresFhirConceptMapTranslateCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConceptMapTranslateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirConceptMapTranslateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConceptMapTranslateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirConceptMapTranslateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}/$translate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.ConceptMap-translate" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConceptMapTranslateCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirConsentEnforcementStatusCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ConsentEnforcementStatus: Returns the consent enforcement status of a single
// consent resource. On success, the response body contains a JSON-encoded
// representation of a `Parameters` (http://hl7.org/fhir/parameters.html) FHIR
// resource, containing the current enforcement status. Does not support DSTU2.
//
//   - name: The name of the consent resource to find enforcement status, in the
//     format
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirSt
//     ores/{fhir_store_id}/fhir/Consent/{consent_id}`.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) ConsentEnforcementStatus(name string) *ProjectsLocationsDatasetsFhirStoresFhirConsentEnforcementStatusCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirConsentEnforcementStatusCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConsentEnforcementStatusCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirConsentEnforcementStatusCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConsentEnforcementStatusCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresFhirConsentEnforcementStatusCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConsentEnforcementStatusCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirConsentEnforcementStatusCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConsentEnforcementStatusCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirConsentEnforcementStatusCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}/$consent-enforcement-status")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.Consent-enforcement-status" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConsentEnforcementStatusCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirEncounterEverythingCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// EncounterEverything: Retrieves an Encounter resource and resources related
// to that Encounter. Implements the FHIR extended operation
// Encounter-everything (DSTU2
// (http://hl7.org/implement/standards/fhir/DSTU2/encounter-operations.html#everything),
// STU3
// (http://hl7.org/implement/standards/fhir/STU3/encounter-operations.html#everything),
// or R4
// (https://hl7.org/implement/standards/fhir/R4/encounter-operation-everything.html).
// On success, the response body contains a JSON-encoded representation of a
// `Bundle` resource of type `searchset`, containing the results of the
// operation. Errors generated by the FHIR store contain a JSON-encoded
// `OperationOutcome` resource describing the reason for the error. If the
// request cannot be mapped to a valid API method on a FHIR store, a generic
// GCP error might be returned instead. The resources in scope for the response
// are: * The Encounter resource itself. * All the resources directly
// referenced by the Encounter resource, including attachments and binaries. *
// Resources directly referencing the Encounter resource that meet the
// inclusion criteria. The inclusion criteria are based on the membership rules
// in the Encounter Compartment definition (DSTU2
// (http://hl7.org/fhir/DSTU2/compartment-encounter.html), STU3
// (http://www.hl7.org/fhir/stu3/compartmentdefinition-encounter.html), R4
// (http://hl7.org/fhir/R4/compartmentdefinition-encounter.html)), which
// details the eligible resource types and referencing search parameters. *
// Resources referencing to the Encounter resource through the
// "http://hl7.org/fhir/StructureDefinition/encounter-associatedEncounter"
// extension.
//
//   - name: Name of the Encounter resource for which the information is
//     required.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) EncounterEverything(name string) *ProjectsLocationsDatasetsFhirStoresFhirEncounterEverythingCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirEncounterEverythingCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Count sets the optional parameter "_count": Maximum number of resources in a
// page. If not specified, 100 is used. May not be larger than 1000.
func (c *ProjectsLocationsDatasetsFhirStoresFhirEncounterEverythingCall) Count(Count int64) *ProjectsLocationsDatasetsFhirStoresFhirEncounterEverythingCall {
	c.urlParams_.Set("_count", fmt.Sprint(Count))
	return c
}

// PageToken sets the optional parameter "_page_token": Used to retrieve the
// next or previous page of results when using pagination. Set `_page_token` to
// the value of _page_token set in next or previous page links' url. Next and
// previous page are returned in the response bundle's links field, where
// `link.relation` is "previous" or "next". Omit `_page_token` if no previous
// request has been made.
func (c *ProjectsLocationsDatasetsFhirStoresFhirEncounterEverythingCall) PageToken(PageToken string) *ProjectsLocationsDatasetsFhirStoresFhirEncounterEverythingCall {
	c.urlParams_.Set("_page_token", PageToken)
	return c
}

// Since sets the optional parameter "_since": If provided, only resources
// updated after this time are returned. The time uses the format
// YYYY-MM-DDThh:mm:ss.sss+zz:zz. For example, `2015-02-07T13:28:17.239+02:00`
// or `2017-01-01T00:00:00Z`. The time must be specified to the second and
// include a time zone.
func (c *ProjectsLocationsDatasetsFhirStoresFhirEncounterEverythingCall) Since(Since string) *ProjectsLocationsDatasetsFhirStoresFhirEncounterEverythingCall {
	c.urlParams_.Set("_since", Since)
	return c
}

// Type sets the optional parameter "_type": String of comma-delimited FHIR
// resource types. If provided, only resources of the specified resource
// type(s) are returned. Specifying multiple `_type` parameters isn't
// supported. For example, the result of `_type=Observation&_type=Encounter` is
// undefined. Use `_type=Observation,Encounter` instead.
func (c *ProjectsLocationsDatasetsFhirStoresFhirEncounterEverythingCall) Type(Type string) *ProjectsLocationsDatasetsFhirStoresFhirEncounterEverythingCall {
	c.urlParams_.Set("_type", Type)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirEncounterEverythingCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirEncounterEverythingCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirEncounterEverythingCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresFhirEncounterEverythingCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirEncounterEverythingCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirEncounterEverythingCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirEncounterEverythingCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirEncounterEverythingCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}/$everything")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.Encounter-everything" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirEncounterEverythingCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirObservationLastnCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ObservationLastn: Retrieves the N most recent `Observation` resources for a
// subject matching search criteria specified as query parameters, grouped by
// `Observation.code`, sorted from most recent to oldest. Implements the FHIR
// extended operation Observation-lastn (STU3
// (https://hl7.org/implement/standards/fhir/STU3/observation-operations.html#lastn),
// R4
// (https://hl7.org/implement/standards/fhir/R4/observation-operations.html#lastn)).
// DSTU2 doesn't define the Observation-lastn method, but the server supports
// it the same way it supports STU3. Search terms are provided as query
// parameters following the same pattern as the search method. The following
// search parameters must be provided: - `subject` or `patient` to specify a
// subject for the Observation. - `code`, `category` or any of the composite
// parameters that include `code`. Any other valid Observation search
// parameters can also be provided. This operation accepts an additional query
// parameter `max`, which specifies N, the maximum number of Observations to
// return from each group, with a default of 1. Searches with over 1000 results
// are rejected. Results are counted before grouping and limiting the results
// with `max`. To stay within the limit, constrain these searches using
// Observation search parameters such as `_lastUpdated` or `date`. On success,
// the response body contains a JSON-encoded representation of a `Bundle`
// resource of type `searchset`, containing the results of the operation.
// Errors generated by the FHIR store contain a JSON-encoded `OperationOutcome`
// resource describing the reason for the error. If the request cannot be
// mapped to a valid API method on a FHIR store, a generic GCP error might be
// returned instead.
//
// - parent: Name of the FHIR store to retrieve resources from.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) ObservationLastn(parent string) *ProjectsLocationsDatasetsFhirStoresFhirObservationLastnCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirObservationLastnCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirObservationLastnCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirObservationLastnCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirObservationLastnCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresFhirObservationLastnCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirObservationLastnCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirObservationLastnCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirObservationLastnCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirObservationLastnCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/fhir/Observation/$lastn")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.Observation-lastn" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirObservationLastnCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// PatientConsentEnforcementStatus: Returns the consent enforcement status of
// all consent resources for a patient. On success, the response body contains
// a JSON-encoded representation of a bundle of `Parameters`
// (http://hl7.org/fhir/parameters.html) FHIR resources, containing the current
// enforcement status for each consent resource of the patient. Does not
// support DSTU2.
//
//   - name: The name of the patient to find enforcement statuses, in the format
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirSt
//     ores/{fhir_store_id}/fhir/Patient/{patient_id}`.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) PatientConsentEnforcementStatus(name string) *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Count sets the optional parameter "_count": The maximum number of results on
// a page. If not specified, 100 is used. May not be larger than 1000.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall) Count(Count int64) *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall {
	c.urlParams_.Set("_count", fmt.Sprint(Count))
	return c
}

// PageToken sets the optional parameter "_page_token": Used to retrieve the
// first, previous, next, or last page of consent enforcement statuses when
// using pagination. Value should be set to the value of `_page_token` set in
// next or previous page links' URLs. Next and previous page are returned in
// the response bundle's links field, where `link.relation` is "previous" or
// "next". Omit `_page_token` if no previous request has been made.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall) PageToken(PageToken string) *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall {
	c.urlParams_.Set("_page_token", PageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}/$consent-enforcement-status")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.Patient-consent-enforcement-status" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// PatientEverything: Retrieves a Patient resource and resources related to
// that patient. Implements the FHIR extended operation Patient-everything
// (DSTU2
// (https://hl7.org/implement/standards/fhir/DSTU2/patient-operations.html#everything),
// STU3
// (https://hl7.org/implement/standards/fhir/STU3/patient-operations.html#everything),
// R4
// (https://hl7.org/implement/standards/fhir/R4/patient-operations.html#everything)).
// On success, the response body contains a JSON-encoded representation of a
// `Bundle` resource of type `searchset`, containing the results of the
// operation. Errors generated by the FHIR store contain a JSON-encoded
// `OperationOutcome` resource describing the reason for the error. If the
// request cannot be mapped to a valid API method on a FHIR store, a generic
// GCP error might be returned instead. The resources in scope for the response
// are: * The patient resource itself. * All the resources directly referenced
// by the patient resource. * Resources directly referencing the patient
// resource that meet the inclusion criteria. The inclusion criteria are based
// on the membership rules in the patient compartment definition (DSTU2
// (https://hl7.org/fhir/DSTU2/compartment-patient.html), STU3
// (http://www.hl7.org/fhir/stu3/compartmentdefinition-patient.html), R4
// (https://hl7.org/fhir/R4/compartmentdefinition-patient.html)), which details
// the eligible resource types and referencing search parameters. For samples
// that show how to call `Patient-everything`, see Getting all patient
// compartment resources
// (https://cloud.google.com/healthcare/docs/how-tos/fhir-resources#getting_all_patient_compartment_resources).
//
//   - name: Name of the `Patient` resource for which the information is
//     required.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) PatientEverything(name string) *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Count sets the optional parameter "_count": Maximum number of resources in a
// page. If not specified, 100 is used. May not be larger than 1000.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall) Count(Count int64) *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall {
	c.urlParams_.Set("_count", fmt.Sprint(Count))
	return c
}

// PageToken sets the optional parameter "_page_token": Used to retrieve the
// next or previous page of results when using pagination. Set `_page_token` to
// the value of _page_token set in next or previous page links' url. Next and
// previous page are returned in the response bundle's links field, where
// `link.relation` is "previous" or "next". Omit `_page_token` if no previous
// request has been made.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall) PageToken(PageToken string) *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall {
	c.urlParams_.Set("_page_token", PageToken)
	return c
}

// Since sets the optional parameter "_since": If provided, only resources
// updated after this time are returned. The time uses the format
// YYYY-MM-DDThh:mm:ss.sss+zz:zz. For example, `2015-02-07T13:28:17.239+02:00`
// or `2017-01-01T00:00:00Z`. The time must be specified to the second and
// include a time zone.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall) Since(Since string) *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall {
	c.urlParams_.Set("_since", Since)
	return c
}

// Type sets the optional parameter "_type": String of comma-delimited FHIR
// resource types. If provided, only resources of the specified resource
// type(s) are returned. Specifying multiple `_type` parameters isn't
// supported. For example, the result of `_type=Observation&_type=Encounter` is
// undefined. Use `_type=Observation,Encounter` instead.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall) Type(Type string) *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall {
	c.urlParams_.Set("_type", Type)
	return c
}

// End sets the optional parameter "end": The response includes records prior
// to the end date. The date uses the format YYYY-MM-DD. If no end date is
// provided, all records subsequent to the start date are in scope.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall) End(end string) *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall {
	c.urlParams_.Set("end", end)
	return c
}

// Start sets the optional parameter "start": The response includes records
// subsequent to the start date. The date uses the format YYYY-MM-DD. If no
// start date is provided, all records prior to the end date are in scope.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall) Start(start string) *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall {
	c.urlParams_.Set("start", start)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall {
	c.ifNoneMatch_ = entityTag
	re