// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package deploymentmanager provides access to the Cloud Deployment Manager V2 API.
//
// For product documentation, see: https://cloud.google.com/deployment-manager
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/deploymentmanager/v2beta"
//	...
//	ctx := context.Background()
//	deploymentmanagerService, err := deploymentmanager.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	deploymentmanagerService, err := deploymentmanager.NewService(ctx, option.WithScopes(deploymentmanager.NdevCloudmanReadonlyScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	deploymentmanagerService, err := deploymentmanager.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	deploymentmanagerService, err := deploymentmanager.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package deploymentmanager // import "google.golang.org/api/deploymentmanager/v2beta"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "deploymentmanager:v2beta"
const apiName = "deploymentmanager"
const apiVersion = "v2beta"
const basePath = "https://deploymentmanager.googleapis.com/"
const basePathTemplate = "https://deploymentmanager.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://deploymentmanager.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"

	// View your data across Google Cloud services and see the email address of
	// your Google Account
	CloudPlatformReadOnlyScope = "https://www.googleapis.com/auth/cloud-platform.read-only"

	// View and manage your Google Cloud Platform management resources and
	// deployment status information
	NdevCloudmanScope = "https://www.googleapis.com/auth/ndev.cloudman"

	// View your Google Cloud Platform management resources and deployment status
	// information
	NdevCloudmanReadonlyScope = "https://www.googleapis.com/auth/ndev.cloudman.readonly"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
		"https://www.googleapis.com/auth/cloud-platform.read-only",
		"https://www.googleapis.com/auth/ndev.cloudman",
		"https://www.googleapis.com/auth/ndev.cloudman.readonly",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.CompositeTypes = NewCompositeTypesService(s)
	s.Deployments = NewDeploymentsService(s)
	s.Manifests = NewManifestsService(s)
	s.Operations = NewOperationsService(s)
	s.Resources = NewResourcesService(s)
	s.TypeProviders = NewTypeProvidersService(s)
	s.Types = NewTypesService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	CompositeTypes *CompositeTypesService

	Deployments *DeploymentsService

	Manifests *ManifestsService

	Operations *OperationsService

	Resources *ResourcesService

	TypeProviders *TypeProvidersService

	Types *TypesService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewCompositeTypesService(s *Service) *CompositeTypesService {
	rs := &CompositeTypesService{s: s}
	return rs
}

type CompositeTypesService struct {
	s *Service
}

func NewDeploymentsService(s *Service) *DeploymentsService {
	rs := &DeploymentsService{s: s}
	return rs
}

type DeploymentsService struct {
	s *Service
}

func NewManifestsService(s *Service) *ManifestsService {
	rs := &ManifestsService{s: s}
	return rs
}

type ManifestsService struct {
	s *Service
}

func NewOperationsService(s *Service) *OperationsService {
	rs := &OperationsService{s: s}
	return rs
}

type OperationsService struct {
	s *Service
}

func NewResourcesService(s *Service) *ResourcesService {
	rs := &ResourcesService{s: s}
	return rs
}

type ResourcesService struct {
	s *Service
}

func NewTypeProvidersService(s *Service) *TypeProvidersService {
	rs := &TypeProvidersService{s: s}
	return rs
}

type TypeProvidersService struct {
	s *Service
}

func NewTypesService(s *Service) *TypesService {
	rs := &TypesService{s: s}
	return rs
}

type TypesService struct {
	s *Service
}

// AsyncOptions: Async options that determine when a resource should finish.
type AsyncOptions struct {
	// MethodMatch: Method regex where this policy will apply.
	MethodMatch string `json:"methodMatch,omitempty"`
	// PollingOptions: Deployment manager will poll instances for this API resource
	// setting a RUNNING state, and blocking until polling conditions tell whether
	// the resource is completed or failed.
	PollingOptions *PollingOptions `json:"pollingOptions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MethodMatch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MethodMatch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AsyncOptions) MarshalJSON() ([]byte, error) {
	type NoMethod AsyncOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuditConfig: Specifies the audit configuration for a service. The
// configuration determines which permission types are logged, and what
// identities, if any, are exempted from logging. An AuditConfig must have one
// or more AuditLogConfigs. If there are AuditConfigs for both `allServices`
// and a specific service, the union of the two AuditConfigs is used for that
// service: the log_types specified in each AuditConfig are enabled, and the
// exempted_members in each AuditLogConfig are exempted. Example Policy with
// multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
// "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
// "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
// "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
// "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
// "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
// sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
// logging. It also exempts `jose@example.com` from DATA_READ logging, and
// `aliya@example.com` from DATA_WRITE logging.
type AuditConfig struct {
	// AuditLogConfigs: The configuration for logging of each type of permission.
	AuditLogConfigs []*AuditLogConfig `json:"auditLogConfigs,omitempty"`
	// Service: Specifies a service that will be enabled for audit logging. For
	// example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices`
	// is a special value that covers all services.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuditLogConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditLogConfigs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuditConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuditLogConfig: Provides the configuration for logging a type of
// permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ",
// "exempted_members": [ "user:jose@example.com" ] }, { "log_type":
// "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while
// exempting jose@example.com from DATA_READ logging.
type AuditLogConfig struct {
	// ExemptedMembers: Specifies the identities that do not cause logging for this
	// type of permission. Follows the same format of Binding.members.
	ExemptedMembers []string `json:"exemptedMembers,omitempty"`
	// LogType: The log type that this config enables.
	//
	// Possible values:
	//   "LOG_TYPE_UNSPECIFIED" - Default case. Should never be this.
	//   "ADMIN_READ" - Admin reads. Example: CloudIAM getIamPolicy
	//   "DATA_WRITE" - Data writes. Example: CloudSQL Users create
	//   "DATA_READ" - Data reads. Example: CloudSQL Users list
	LogType string `json:"logType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExemptedMembers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExemptedMembers") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuditLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditLogConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BaseType: BaseType that describes a service-backed Type.
type BaseType struct {
	// CollectionOverrides: Allows resource handling overrides for specific
	// collections
	CollectionOverrides []*CollectionOverride `json:"collectionOverrides,omitempty"`
	// Credential: Credential used when interacting with this type.
	Credential *Credential `json:"credential,omitempty"`
	// DescriptorUrl: Descriptor Url for the this type.
	DescriptorUrl string `json:"descriptorUrl,omitempty"`
	// Options: Options to apply when handling any resources in this service.
	Options *Options `json:"options,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CollectionOverrides") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CollectionOverrides") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BaseType) MarshalJSON() ([]byte, error) {
	type NoMethod BaseType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BasicAuth: Basic Auth used as a credential.
type BasicAuth struct {
	Password string `json:"password,omitempty"`
	User     string `json:"user,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Password") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Password") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BasicAuth) MarshalJSON() ([]byte, error) {
	type NoMethod BasicAuth
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Binding: Associates `members`, or principals, with a `role`.
type Binding struct {
	// Condition: The condition that is associated with this binding. If the
	// condition evaluates to `true`, then this binding applies to the current
	// request. If the condition evaluates to `false`, then this binding does not
	// apply to the current request. However, a different role binding might grant
	// the same role to one or more of the principals in this binding. To learn
	// which resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *Expr `json:"condition,omitempty"`
	// Members: Specifies the principals requesting access for a Google Cloud
	// resource. `members` can have the following values: * `allUsers`: A special
	// identifier that represents anyone who is on the internet; with or without a
	// Google account. * `allAuthenticatedUsers`: A special identifier that
	// represents anyone who is authenticated with a Google account or a service
	// account. Does not include identities that come from external identity
	// providers (IdPs) through identity federation. * `user:{emailid}`: An email
	// address that represents a specific Google account. For example,
	// `alice@example.com` . * `serviceAccount:{emailid}`: An email address that
	// represents a Google service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`. *
	// `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An
	// identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
	// `group:{emailid}`: An email address that represents a Google group. For
	// example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
	// (primary) that represents all the users of that domain. For example,
	// `google.com` or `example.com`. *
	// `principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/sub
	// ject/{subject_attribute_value}`: A single identity in a workforce identity
	// pool. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// group/{group_id}`: All workforce identities in a group. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// attribute.{attribute_name}/{attribute_value}`: All workforce identities with
	// a specific attribute value. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// *`: All identities in a workforce identity pool. *
	// `principal://iam.googleapis.com/projects/{project_number}/locations/global/wo
	// rkloadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
	// identity in a workload identity pool. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/group/{group_id}`: A workload identity pool
	// group. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}
	// `: All identities in a workload identity pool with a certain attribute. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/*`: All identities in a workload identity
	// pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a user that has been recently deleted. For
	// example, `alice@example.com?uid=123456789012345678901`. If the user is
	// recovered, this value reverts to `user:{emailid}` and the recovered user
	// retains the role in the binding. *
	// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a service account that has been recently
	// deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
	// service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains the
	// role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email
	// address (plus unique identifier) representing a Google group that has been
	// recently deleted. For example,
	// `admins@example.com?uid=123456789012345678901`. If the group is recovered,
	// this value reverts to `group:{emailid}` and the recovered group retains the
	// role in the binding. *
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool
	// _id}/subject/{subject_attribute_value}`: Deleted single identity in a
	// workforce identity pool. For example,
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-po
	// ol-id/subject/my-subject-attribute-value`.
	Members []string `json:"members,omitempty"`
	// Role: Role that is assigned to the list of `members`, or principals. For
	// example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an overview
	// of the IAM roles and permissions, see the IAM documentation
	// (https://cloud.google.com/iam/docs/roles-overview). For a list of the
	// available pre-defined roles, see here
	// (https://cloud.google.com/iam/docs/understanding-roles).
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Binding) MarshalJSON() ([]byte, error) {
	type NoMethod Binding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type BulkInsertOperationStatus struct {
	// CreatedVmCount: [Output Only] Count of VMs successfully created so far.
	CreatedVmCount int64 `json:"createdVmCount,omitempty"`
	// DeletedVmCount: [Output Only] Count of VMs that got deleted during rollback.
	DeletedVmCount int64 `json:"deletedVmCount,omitempty"`
	// FailedToCreateVmCount: [Output Only] Count of VMs that started creating but
	// encountered an error.
	FailedToCreateVmCount int64 `json:"failedToCreateVmCount,omitempty"`
	// Status: [Output Only] Creation status of BulkInsert operation - information
	// if the flow is rolling forward or rolling back.
	//
	// Possible values:
	//   "STATUS_UNSPECIFIED"
	//   "CREATING" - Rolling forward - creating VMs.
	//   "ROLLING_BACK" - Rolling back - cleaning up after an error.
	//   "DONE" - Done
	Status string `json:"status,omitempty"`
	// TargetVmCount: [Output Only] Count of VMs originally planned to be created.
	TargetVmCount int64 `json:"targetVmCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreatedVmCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreatedVmCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BulkInsertOperationStatus) MarshalJSON() ([]byte, error) {
	type NoMethod BulkInsertOperationStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CollectionOverride: CollectionOverride allows resource handling overrides
// for specific resources within a BaseType
type CollectionOverride struct {
	// Collection: The collection that identifies this resource within its service.
	Collection string `json:"collection,omitempty"`
	// Options: The options to apply to this resource-level override
	Options *Options `json:"options,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Collection") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Collection") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CollectionOverride) MarshalJSON() ([]byte, error) {
	type NoMethod CollectionOverride
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CompositeType: Holds the composite type.
type CompositeType struct {
	// Description: An optional textual description of the resource; provided by
	// the client when the resource is created.
	Description string `json:"description,omitempty"`
	Id          uint64 `json:"id,omitempty,string"`
	// InsertTime: Output only. Creation timestamp in RFC3339 text format.
	InsertTime string `json:"insertTime,omitempty"`
	// Labels: Map of labels; provided by the client when the resource is created
	// or updated. Specifically: Label keys must be between 1 and 63 characters
	// long and must conform to the following regular expression: `a-z
	// ([-a-z0-9]*[a-z0-9])?` Label values must be between 0 and 63 characters long
	// and must conform to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
	Labels []*CompositeTypeLabelEntry `json:"labels,omitempty"`
	// Name: Name of the composite type, must follow the expression:
	// `[a-z]([-a-z0-9_.]{0,61}[a-z0-9])?`.
	Name string `json:"name,omitempty"`
	// Operation: Output only. The Operation that most recently ran, or is
	// currently running, on this composite type.
	Operation *Operation `json:"operation,omitempty"`
	// SelfLink: Output only. Server defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`
	// Possible values:
	//   "UNKNOWN_STATUS"
	//   "DEPRECATED"
	//   "EXPERIMENTAL"
	//   "SUPPORTED"
	Status string `json:"status,omitempty"`
	// TemplateContents: Files for the template type.
	TemplateContents *TemplateContents `json:"templateContents,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CompositeType) MarshalJSON() ([]byte, error) {
	type NoMethod CompositeType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CompositeTypeLabelEntry: Label object for CompositeTypes
type CompositeTypeLabelEntry struct {
	// Key: Key of the label
	Key string `json:"key,omitempty"`
	// Value: Value of the label
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CompositeTypeLabelEntry) MarshalJSON() ([]byte, error) {
	type NoMethod CompositeTypeLabelEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CompositeTypesListResponse: A response that returns all Composite Types
// supported by Deployment Manager
type CompositeTypesListResponse struct {
	// CompositeTypes: Output only. A list of resource composite types supported by
	// Deployment Manager.
	CompositeTypes []*CompositeType `json:"compositeTypes,omitempty"`
	// NextPageToken: A token used to continue a truncated list request.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CompositeTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompositeTypes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CompositeTypesListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CompositeTypesListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ConfigFile struct {
	// Content: The contents of the file.
	Content string `json:"content,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigFile) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigFile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Credential: The credential used by Deployment Manager and TypeProvider. Only
// one of the options is permitted.
type Credential struct {
	// BasicAuth: Basic Auth Credential, only used by TypeProvider.
	BasicAuth *BasicAuth `json:"basicAuth,omitempty"`
	// ServiceAccount: Service Account Credential, only used by Deployment.
	ServiceAccount *ServiceAccount `json:"serviceAccount,omitempty"`
	// UseProjectDefault: Specify to use the project default credential, only
	// supported by Deployment.
	UseProjectDefault bool `json:"useProjectDefault,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicAuth") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicAuth") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Credential) MarshalJSON() ([]byte, error) {
	type NoMethod Credential
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DebugInfo: Describes additional debugging info.
type DebugInfo struct {
	// Detail: Additional debugging information provided by the server.
	Detail string `json:"detail,omitempty"`
	// StackEntries: The stack trace entries indicating where the error occurred.
	StackEntries []string `json:"stackEntries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Detail") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Detail") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DebugInfo) MarshalJSON() ([]byte, error) {
	type NoMethod DebugInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Deployment struct {
	// Description: An optional user-provided description of the deployment.
	Description string `json:"description,omitempty"`
	// Fingerprint: Provides a fingerprint to use in requests to modify a
	// deployment, such as `update()`, `stop()`, and `cancelPreview()` requests. A
	// fingerprint is a randomly generated value that must be provided with
	// `update()`, `stop()`, and `cancelPreview()` requests to perform optimistic
	// locking. This ensures optimistic concurrency so that only one request
	// happens at a time. The fingerprint is initially generated by Deployment
	// Manager and changes after every request to modify data. To get the latest
	// fingerprint value, perform a `get()` request to a deployment.
	Fingerprint string `json:"fingerprint,omitempty"`
	Id          uint64 `json:"id,omitempty,string"`
	// InsertTime: Output only. Creation timestamp in RFC3339 text format.
	InsertTime string `json:"insertTime,omitempty"`
	// Labels: Map of One Platform labels; provided by the client when the resource
	// is created or updated. Specifically: Label keys must be between 1 and 63
	// characters long and must conform to the following regular expression: `a-z
	// ([-a-z0-9]*[a-z0-9])?` Label values must be between 0 and 63 characters long
	// and must conform to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
	Labels []*DeploymentLabelEntry `json:"labels,omitempty"`
	// Manifest: Output only. URL of the manifest representing the last manifest
	// that was successfully deployed. If no manifest has been successfully
	// deployed, this field will be absent.
	Manifest string `json:"manifest,omitempty"`
	// Name: Name of the resource; provided by the client when the resource is
	// created. The name must be 1-63 characters long, and comply with RFC1035.
	// Specifically, the name must be 1-63 characters long and match the regular
	// expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must
	// be a lowercase letter, and all following characters must be a dash,
	// lowercase letter, or digit, except the last character, which cannot be a
	// dash.
	Name string `json:"name,omitempty"`
	// Operation: Output only. The Operation that most recently ran, or is
	// currently running, on this deployment.
	Operation *Operation `json:"operation,omitempty"`
	// SelfLink: Output only. Server defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`
	// Target: [Input Only] The parameters that define your deployment, including
	// the deployment configuration and relevant templates.
	Target *TargetConfiguration `json:"target,omitempty"`
	// Update: Output only. If Deployment Manager is currently updating or
	// previewing an update to this deployment, the updated configuration appears
	// here.
	Update *DeploymentUpdate `json:"update,omitempty"`
	// UpdateTime: Output only. Update timestamp in RFC3339 text format.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Deployment) MarshalJSON() ([]byte, error) {
	type NoMethod Deployment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeploymentLabelEntry: Label object for Deployments
type DeploymentLabelEntry struct {
	// Key: Key of the label
	Key string `json:"key,omitempty"`
	// Value: Value of the label
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeploymentLabelEntry) MarshalJSON() ([]byte, error) {
	type NoMethod DeploymentLabelEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type DeploymentUpdate struct {
	// Description: Output only. An optional user-provided description of the
	// deployment after the current update has been applied.
	Description string `json:"description,omitempty"`
	// Labels: Map of One Platform labels; provided by the client when the resource
	// is created or updated. Specifically: Label keys must be between 1 and 63
	// characters long and must conform to the following regular expression: `a-z
	// ([-a-z0-9]*[a-z0-9])?` Label values must be between 0 and 63 characters long
	// and must conform to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
	Labels []*DeploymentUpdateLabelEntry `json:"labels,omitempty"`
	// Manifest: Output only. URL of the manifest representing the update
	// configuration of this deployment.
	Manifest string `json:"manifest,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeploymentUpdate) MarshalJSON() ([]byte, error) {
	type NoMethod DeploymentUpdate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeploymentUpdateLabelEntry: Label object for DeploymentUpdate
type DeploymentUpdateLabelEntry struct {
	// Key: Key of the label
	Key string `json:"key,omitempty"`
	// Value: Value of the label
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeploymentUpdateLabelEntry) MarshalJSON() ([]byte, error) {
	type NoMethod DeploymentUpdateLabelEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type DeploymentsCancelPreviewRequest struct {
	// Fingerprint: Specifies a fingerprint for `cancelPreview()` requests. A
	// fingerprint is a randomly generated value that must be provided in
	// `cancelPreview()` requests to perform optimistic locking. This ensures
	// optimistic concurrency so that the deployment does not have conflicting
	// requests (e.g. if someone attempts to make a new update request while
	// another user attempts to cancel a preview, this would prevent one of the
	// requests). The fingerprint is initially generated by Deployment Manager and
	// changes after every request to modify a deployment. To get the latest
	// fingerprint value, perform a `get()` request on the deployment.
	Fingerprint string `json:"fingerprint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Fingerprint") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Fingerprint") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeploymentsCancelPreviewRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DeploymentsCancelPreviewRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeploymentsListResponse: A response containing a partial list of deployments
// and a page token used to build the next request if the request has been
// truncated.
type DeploymentsListResponse struct {
	// Deployments: Output only. The deployments contained in this response.
	Deployments []*Deployment `json:"deployments,omitempty"`
	// NextPageToken: Output only. A token used to continue a truncated list
	// request.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Deployments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Deployments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeploymentsListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod DeploymentsListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type DeploymentsStopRequest struct {
	// Fingerprint: Specifies a fingerprint for `stop()` requests. A fingerprint is
	// a randomly generated value that must be provided in `stop()` requests to
	// perform optimistic locking. This ensures optimistic concurrency so that the
	// deployment does not have conflicting requests (e.g. if someone attempts to
	// make a new update request while another user attempts to stop an ongoing
	// update request, this would prevent a collision). The fingerprint is
	// initially generated by Deployment Manager and changes after every request to
	// modify a deployment. To get the latest fingerprint value, perform a `get()`
	// request on the deployment.
	Fingerprint string `json:"fingerprint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Fingerprint") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Fingerprint") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeploymentsStopRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DeploymentsStopRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Diagnostic struct {
	// Field: JsonPath expression on the resource that if non empty, indicates that
	// this field needs to be extracted as a diagnostic.
	Field string `json:"field,omitempty"`
	// Level: Level to record this diagnostic.
	//
	// Possible values:
	//   "UNKNOWN"
	//   "INFORMATION" - If level is informational, it only gets displayed as part
	// of the resource.
	//   "WARNING" - If level is warning, will end up in the resource as a warning.
	//   "ERROR" - If level is error, it will indicate an error occurred after
	// finishCondition is set, and this field will populate resource errors and
	// operation errors.
	Level string `json:"level,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Field") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Field") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Diagnostic) MarshalJSON() ([]byte, error) {
	type NoMethod Diagnostic
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ErrorInfo: Describes the cause of the error with structured details. Example
// of an error when contacting the "pubsub.googleapis.com" API when it is not
// enabled: { "reason": "API_DISABLED" "domain": "googleapis.com" "metadata": {
// "resource": "projects/123", "service": "pubsub.googleapis.com" } } This
// response indicates that the pubsub.googleapis.com API is not enabled.
// Example of an error that is returned when attempting to create a Spanner
// instance in a region that is out of stock: { "reason": "STOCKOUT" "domain":
// "spanner.googleapis.com", "metadata": { "availableRegions":
// "us-central1,us-east2" } }
type ErrorInfo struct {
	// Domain: The logical grouping to which the "reason" belongs. The error domain
	// is typically the registered service name of the tool or product that
	// generates the error. Example: "pubsub.googleapis.com". If the error is
	// generated by some common infrastructure, the error domain must be a globally
	// unique value that identifies the infrastructure. For Google API
	// infrastructure, the error domain is "googleapis.com".
	Domain string `json:"domain,omitempty"`
	// Metadatas: Additional structured details about this error. Keys must match
	// /a-z+/ but should ideally be lowerCamelCase. Also they must be limited to 64
	// characters in length. When identifying the current value of an exceeded
	// limit, the units should be contained in the key, not the value. For example,
	// rather than {"instanceLimit": "100/request"}, should be returned as,
	// {"instanceLimitPerRequest": "100"}, if the client exceeds the number of
	// instances that can be created in a single (batch) request.
	Metadatas map[string]string `json:"metadatas,omitempty"`
	// Reason: The reason of the error. This is a constant value that identifies
	// the proximate cause of the error. Error reasons are unique within a
	// particular domain of errors. This should be at most 63 characters and match
	// a regular expression of `A-Z+[A-Z0-9]`, which represents UPPER_SNAKE_CASE.
	Reason string `json:"reason,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Domain") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Domain") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ErrorInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ErrorInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Expr: Represents a textual expression in the Common Expression Language
// (CEL) syntax. CEL is a C-like expression language. The syntax and semantics
// of CEL are documented at https://github.com/google/cel-spec. Example
// (Comparison): title: "Summary size limit" description: "Determines if a
// summary is less than 100 chars" expression: "document.summary.size() < 100"
// Example (Equality): title: "Requestor is owner" description: "Determines if
// requestor is the document owner" expression: "document.owner ==
// request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly visible"
// expression: "document.type != 'private' && document.type != 'internal'"
// Example (Data Manipulation): title: "Notification string" description:
// "Create a notification string with a timestamp." expression: "'New message
// received at ' + string(document.create_time)" The exact variables and
// functions that may be referenced within an expression are determined by the
// service that evaluates it. See the service documentation for additional
// information.
type Expr struct {
	// Description: Optional. Description of the expression. This is a longer text
	// which describes the expression, e.g. when hovered over it in a UI.
	Description string `json:"description,omitempty"`
	// Expression: Textual representation of an expression in Common Expression
	// Language syntax.
	Expression string `json:"expression,omitempty"`
	// Location: Optional. String indicating the location of the expression for
	// error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`
	// Title: Optional. Title for the expression, i.e. a short string describing
	// its purpose. This can be used e.g. in UIs which allow to enter the
	// expression.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Expr) MarshalJSON() ([]byte, error) {
	type NoMethod Expr
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GlobalSetPolicyRequest struct {
	// Bindings: Flatten Policy to create a backward compatible wire-format.
	// Deprecated. Use 'policy' to specify bindings.
	Bindings []*Binding `json:"bindings,omitempty"`
	// Etag: Flatten Policy to create a backward compatible wire-format.
	// Deprecated. Use 'policy' to specify the etag.
	Etag string `json:"etag,omitempty"`
	// Policy: REQUIRED: The complete policy to be applied to the 'resource'. The
	// size of the policy is limited to a few 10s of KB. An empty policy is in
	// general a valid policy but certain services (like Projects) might reject
	// them.
	Policy     *Policy `json:"policy,omitempty"`
	UpdateMask string  `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bindings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bindings") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GlobalSetPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GlobalSetPolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Help: Provides links to documentation or for performing an out of band
// action. For example, if a quota check failed with an error indicating the
// calling project hasn't enabled the accessed service, this can contain a URL
// pointing directly to the right place in the developer console to flip the
// bit.
type Help struct {
	// Links: URL(s) pointing to additional information on handling the current
	// error.
	Links []*HelpLink `json:"links,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Links") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Links") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Help) MarshalJSON() ([]byte, error) {
	type NoMethod Help
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HelpLink: Describes a URL link.
type HelpLink struct {
	// Description: Describes what the link offers.
	Description string `json:"description,omitempty"`
	// Url: The URL of the link.
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HelpLink) MarshalJSON() ([]byte, error) {
	type NoMethod HelpLink
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ImportFile struct {
	// Content: The contents of the file.
	Content string `json:"content,omitempty"`
	// Name: The name of the file.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportFile) MarshalJSON() ([]byte, error) {
	type NoMethod ImportFile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InputMapping: InputMapping creates a 'virtual' property that will be
// injected into the properties before sending the request to the underlying
// API.
type InputMapping struct {
	// FieldName: The name of the field that is going to be injected.
	FieldName string `json:"fieldName,omitempty"`
	// Location: The location where this mapping applies.
	//
	// Possible values:
	//   "UNKNOWN"
	//   "PATH"
	//   "QUERY"
	//   "BODY"
	//   "HEADER"
	Location string `json:"location,omitempty"`
	// MethodMatch: Regex to evaluate on method to decide if input applies.
	MethodMatch string `json:"methodMatch,omitempty"`
	// Value: A jsonPath expression to select an element.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FieldName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FieldName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InputMapping) MarshalJSON() ([]byte, error) {
	type NoMethod InputMapping
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type InstancesBulkInsertOperationMetadata struct {
	// PerLocationStatus: Status information per location (location name is key).
	// Example key: zones/us-central1-a
	PerLocationStatus map[string]BulkInsertOperationStatus `json:"perLocationStatus,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PerLocationStatus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PerLocationStatus") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstancesBulkInsertOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesBulkInsertOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LocalizedMessage: Provides a localized error message that is safe to return
// to the user which can be attached to an RPC error.
type LocalizedMessage struct {
	// Locale: The locale used following the specification defined at
	// https://www.rfc-editor.org/rfc/bcp/bcp47.txt. Examples are: "en-US",
	// "fr-CH", "es-MX"
	Locale string `json:"locale,omitempty"`
	// Message: The localized error message in the above locale.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Locale") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locale") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LocalizedMessage) MarshalJSON() ([]byte, error) {
	type NoMethod LocalizedMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Manifest struct {
	// Config: Output only. The YAML configuration for this manifest.
	Config *ConfigFile `json:"config,omitempty"`
	// ExpandedConfig: Output only. The fully-expanded configuration file,
	// including any templates and references.
	ExpandedConfig string `json:"expandedConfig,omitempty"`
	Id             uint64 `json:"id,omitempty,string"`
	// Imports: Output only. The imported files for this manifest.
	Imports []*ImportFile `json:"imports,omitempty"`
	// InsertTime: Output only. Creation timestamp in RFC3339 text format.
	InsertTime string `json:"insertTime,omitempty"`
	// Layout: Output only. The YAML layout for this manifest.
	Layout string `json:"layout,omitempty"`
	// ManifestSizeBytes: Output only. The computed size of the fully expanded
	// manifest.
	ManifestSizeBytes int64 `json:"manifestSizeBytes,omitempty,string"`
	// ManifestSizeLimitBytes: Output only. The size limit for expanded manifests
	// in the project.
	ManifestSizeLimitBytes int64 `json:"manifestSizeLimitBytes,omitempty,string"`
	// Name: Output only. The name of the manifest.
	Name string `json:"name,omitempty"`
	// SelfLink: Output only. Self link for the manifest.
	SelfLink string `json:"selfLink,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Config") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Manifest) MarshalJSON() ([]byte, error) {
	type NoMethod Manifest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ManifestsListResponse: A response containing a partial list of manifests and
// a page token used to build the next request if the request has been
// truncated.
type ManifestsListResponse struct {
	// Manifests: Output only. Manifests contained in this list response.
	Manifests []*Manifest `json:"manifests,omitempty"`
	// NextPageToken: Output only. A token used to continue a truncated list
	// request.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Manifests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Manifests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ManifestsListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ManifestsListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Operation: Represents an Operation resource. Google Compute Engine has three
// Operation resources: * Global
// (/compute/docs/reference/rest/{$api_version}/globalOperations) * Regional
// (/compute/docs/reference/rest/{$api_version}/regionOperations) * Zonal
// (/compute/docs/reference/rest/{$api_version}/zoneOperations) You can use an
// operation resource to manage asynchronous API requests. For more
// information, read Handling API responses. Operations can be global, regional
// or zonal. - For global operations, use the `globalOperations` resource. -
// For regional operations, use the `regionOperations` resource. - For zonal
// operations, use the `zoneOperations` resource. For more information, read
// Global, Regional, and Zonal Resources. Note that completed Operation
// resources have a limited retention period.
type Operation struct {
	// ClientOperationId: [Output Only] The value of `requestId` if you provided it
	// in the request. Not present otherwise.
	ClientOperationId string `json:"clientOperationId,omitempty"`
	// CreationTimestamp: [Deprecated] This field is deprecated.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`
	// Description: [Output Only] A textual description of the operation, which is
	// set when the operation is created.
	Description string `json:"description,omitempty"`
	// EndTime: [Output Only] The time that this operation was completed. This
	// value is in RFC3339 text format.
	EndTime string `json:"endTime,omitempty"`
	// Error: [Output Only] If errors are generated during processing of the
	// operation, this field will be populated.
	Error *OperationError `json:"error,omitempty"`
	// HttpErrorMessage: [Output Only] If the operation fails, this field contains
	// the HTTP error message that was returned, such as `NOT FOUND`.
	HttpErrorMessage string `json:"httpErrorMessage,omitempty"`
	// HttpErrorStatusCode: [Output Only] If the operation fails, this field
	// contains the HTTP error status code that was returned. For example, a `404`
	// means the resource was not found.
	HttpErrorStatusCode int64 `json:"httpErrorStatusCode,omitempty"`
	// Id: [Output Only] The unique identifier for the operation. This identifier
	// is defined by the server.
	Id uint64 `json:"id,omitempty,string"`
	// InsertTime: [Output Only] The time that this operation was requested. This
	// value is in RFC3339 text format.
	InsertTime                           string                                `json:"insertTime,omitempty"`
	InstancesBulkInsertOperationMetadata *InstancesBulkInsertOperationMetadata `json:"instancesBulkInsertOperationMetadata,omitempty"`
	// Kind: [Output Only] Type of the resource. Always `compute#operation` for
	// Operation resources.
	Kind string `json:"kind,omitempty"`
	// Name: [Output Only] Name of the operation.
	Name string `json:"name,omitempty"`
	// OperationGroupId: [Output Only] An ID that represents a group of operations,
	// such as when a group of operations results from a `bulkInsert` API request.
	OperationGroupId string `json:"operationGroupId,omitempty"`
	// OperationType: [Output Only] The type of operation, such as `insert`,
	// `update`, or `delete`, and so on.
	OperationType string `json:"operationType,omitempty"`
	// Progress: [Output Only] An optional progress indicator that ranges from 0 to
	// 100. There is no requirement that this be linear or support any granularity
	// of operations. This should not be used to guess when the operation will be
	// complete. This number should monotonically increase as the operation
	// progresses.
	Progress int64 `json:"progress,omitempty"`
	// Region: [Output Only] The URL of the region where the operation resides.
	// Only applicable when performing regional operations.
	Region string `json:"region,omitempty"`
	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`
	// SelfLinkWithId: [Output Only] Server-defined URL for this resource with the
	// resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`
	// SetCommonInstanceMetadataOperationMetadata: [Output Only] If the operation
	// is for projects.setCommonInstanceMetadata, this field will contain
	// information on all underlying zonal actions and their state.
	SetCommonInstanceMetadataOperationMetadata *SetCommonInstanceMetadataOperationMetadata `json:"setCommonInstanceMetadataOperationMetadata,omitempty"`
	// StartTime: [Output Only] The time that this operation was started by the
	// server. This value is in RFC3339 text format.
	StartTime string `json:"startTime,omitempty"`
	// Status: [Output Only] The status of the operation, which can be one of the
	// following: `PENDING`, `RUNNING`, or `DONE`.
	//
	// Possible values:
	//   "PENDING"
	//   "RUNNING"
	//   "DONE"
	Status string `json:"status,omitempty"`
	// StatusMessage: [Output Only] An optional textual description of the current
	// status of the operation.
	StatusMessage string `json:"statusMessage,omitempty"`
	// TargetId: [Output Only] The unique target ID, which identifies a specific
	// incarnation of the target resource.
	TargetId uint64 `json:"targetId,omitempty,string"`
	// TargetLink: [Output Only] The URL of the resource that the operation
	// modifies. For operations related to creating a snapshot, this points to the
	// disk that the snapshot was created from.
	TargetLink string `json:"targetLink,omitempty"`
	// User: [Output Only] User who requested the operation, for example:
	// `user@example.com` or `alice_smith_identifier
	// (global/workforcePools/example-com-us-employees)`.
	User string `json:"user,omitempty"`
	// Warnings: [Output Only] If warning messages are generated during processing
	// of the operation, this field will be populated.
	Warnings []*OperationWarnings `json:"warnings,omitempty"`
	// Zone: [Output Only] The URL of the zone where the operation resides. Only
	// applicable when performing per-zone operations.
	Zone string `json:"zone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ClientOperationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientOperationId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationError: [Output Only] If errors are generated during processing of
// the operation, this field will be populated.
type OperationError struct {
	// Errors: [Output Only] The array of errors encountered while processing this
	// operation.
	Errors []*OperationErrorErrors `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationError) MarshalJSON() ([]byte, error) {
	type NoMethod OperationError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type OperationErrorErrors struct {
	// Arguments: [Output Only] Optional error details WARNING: DO NOT MAKE VISIBLE
	// This is for internal use-only (like componentization) (thus the visibility
	// "none") and in case of public exposure it is strongly recommended to follow
	// pattern of: https://aip.dev/193 and expose as details field.
	Arguments []string `json:"arguments,omitempty"`
	// Code: [Output Only] The error type identifier for this error.
	Code      string     `json:"code,omitempty"`
	DebugInfo *DebugInfo `json:"debugInfo,omitempty"`
	// ErrorDetails: [Output Only] An optional list of messages that contain the
	// error details. There is a set of defined message types to use for providing
	// details.The syntax depends on the error code. For example, QuotaExceededInfo
	// will have details when the error code is QUOTA_EXCEEDED.
	ErrorDetails []*OperationErrorErrorsErrorDetails `json:"errorDetails,omitempty"`
	// Location: [Output Only] Indicates the field in the request that caused the
	// error. This property is optional.
	Location string `json:"location,omitempty"`
	// Message: [Output Only] An optional, human-readable error message.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Arguments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Arguments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationErrorErrors) MarshalJSON() ([]byte, error) {
	type NoMethod OperationErrorErrors
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type OperationErrorErrorsErrorDetails struct {
	ErrorInfo        *ErrorInfo         `json:"errorInfo,omitempty"`
	Help             *Help              `json:"help,omitempty"`
	LocalizedMessage *LocalizedMessage  `json:"localizedMessage,omitempty"`
	QuotaInfo        *QuotaExceededInfo `json:"quotaInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationErrorErrorsErrorDetails) MarshalJSON() ([]byte, error) {
	type NoMethod OperationErrorErrorsErrorDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type OperationWarnings struct {
	// Code: [Output Only] A warning code, if applicable. For example, Compute
	// Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.
	//
	// Possible values:
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was created.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list page.
	//   "UNREACHABLE" - A given scope cannot be reached.
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is not
	// assigned to an instance on the network.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL refers to
	// an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance URL
	// refers to an instance that is not on the same network as the route.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot ip
	// forward.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not have a
	// status of RUNNING.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an injected
	// kernel, which is deprecated.
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource that
	// requires a TOS they have not accepted.
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk that is
	// larger than image size.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to auto-delete
	// could not be deleted because they were in use.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in instance
	// group manager is valid as such, but its application does not make a lot of
	// sense, because it allows only single instance in instance group.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to continue
	// the process despite the mentioned error.
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient changes made
	// by a failed operation.
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a resource is
	// in use.
	//   "NETWORK_ENDPOINT_NOT_DETACHED" - Warning that network endpoint was not
	// detached.
	//   "PAGE_MISSING_RESULTS" - Current page contains less results than requested
	// but a next page token exists.
	//   "SSL_POLICY_ENABLED_FEATURES_NOT_FETCHED" - Warning that SSL policy
	// resource in the response does not contain information about the list of
	// enabled features.
	//   "RESOURCE_NOT_FOUND_WARNING" - Warning that a resource is not found.
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api call
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema are
	// present
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the resources
	// has a type marked as deprecated
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be missing
	// due to errors
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's nextHopInstance
	// URL refers to an instance that does not have an ipv6 interface on the same
	// network as the route.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV backend
	// service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LIST_OVERHEAD_QUOTA_EXCEED" - Resource can't be retrieved due to list
	// overhead quota exceed which captures the amount of resources filtered out by
	// user-defined list filter.
	//   "QUOTA_INFO_UNAVAILABLE" - Quota information is not available to client
	// requests (e.g: regions.list).
	//   "RESOURCE_USES_GLOBAL_DNS" - Indicates that a VM is using global DNS. Can
	// also be used to indicate that a resource has attributes that could result in
	// the creation of a VM that uses global DNS.
	//   "RESERVED_ENTRY_134" - Reserved entries for quickly adding new warnings
	// without breaking dependent clients.
	//   "RESERVED_ENTRY_135"
	//   "RESERVED_ENTRY_136"
	//   "RESERVED_ENTRY_139"
	//   "RESERVED_ENTRY_141"
	Code string `json:"code,omitempty"`
	// Data: [Output Only] Metadata about this warning in key: value format. For
	// example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*OperationWarningsData `json:"data,omitempty"`
	// Message: [Output Only] A human-readable description of the warning code.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationWarnings) MarshalJSON() ([]byte, error) {
	type NoMethod OperationWarnings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type OperationWarningsData struct {
	// Key: [Output Only] A key that provides more detail on the warning being
	// returned. For example, for warnings where there are no results in a list
	// request for a particular zone, this key might be scope and the key value
	// might be the zone name. Other examples might be a key indicating a
	// deprecated resource and a suggested replacement, or a warning about invalid
	// network settings (for example, if an instance attempts to perform IP
	// forwarding but is not enabled for IP forwarding).
	Key string `json:"key,omitempty"`
	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationWarningsData) MarshalJSON() ([]byte, error) {
	type NoMethod OperationWarningsData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationsListResponse: A response containing a partial list of operations
// and a page token used to build the next request if the request has been
// truncated.
type OperationsListResponse struct {
	// NextPageToken: Output only. A token used to continue a truncated list
	// request.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: Output only. Operations contained in this list response.
	Operations []*Operation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationsListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OperationsListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Options: Options allows customized resource handling by Deployment Manager.
type Options struct {
	// AsyncOptions: Options regarding how to thread async requests.
	AsyncOptions []*AsyncOptions `json:"asyncOptions,omitempty"`
	// InputMappings: The mappings that apply for requests.
	InputMappings []*InputMapping `json:"inputMappings,omitempty"`
	// ValidationOptions: Options for how to validate and process properties on a
	// resource.
	ValidationOptions *ValidationOptions `json:"validationOptions,omitempty"`
	// VirtualProperties: Additional properties block described as a jsonSchema,
	// these properties will never be part of the json payload, but they can be
	// consumed by InputMappings, this must be a valid json schema draft-04. The
	// properties specified here will be decouple in a different section. This
	// schema will be merged to the schema validation, and properties here will be
	// extracted From the payload and consumed explicitly by InputMappings. ex:
	// field1: type: string field2: type: number
	VirtualProperties string `json:"virtualProperties,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AsyncOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AsyncOptions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Options) MarshalJSON() ([]byte, error) {
	type NoMethod Options
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Policy: An Identity and Access Management (IAM) policy, which specifies
// access controls for Google Cloud resources. A `Policy` is a collection of
// `bindings`. A `binding` binds one or more `members`, or principals, to a
// single `role`. Principals can be user accounts, service accounts, Google
// groups, and domains (such as G Suite). A `role` is a named list of
// permissions; each `role` can be an IAM predefined role or a user-created
// custom role. For some types of Google Cloud resources, a `binding` can also
// specify a `condition`, which is a logical expression that allows access to a
// resource only if the expression evaluates to `true`. A condition can add
// constraints based on attributes of the request, the resource, or both. To
// learn which resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies). **JSON
// example:** ``` { "bindings": [ { "role":
// "roles/resourcemanager.organizationAdmin", "members": [
// "user:mike@example.com", "group:admins@example.com", "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
// "roles/resourcemanager.organizationViewer", "members": [
// "user:eve@example.com" ], "condition": { "title": "expirable access",
// "description": "Does not grant access after Sep 2020", "expression":
// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
// "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
// members: - user:mike@example.com - group:admins@example.com -
// domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
// role: roles/resourcemanager.organizationAdmin - members: -
// user:eve@example.com role: roles/resourcemanager.organizationViewer
// condition: title: expirable access description: Does not grant access after
// Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
// etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
// see the IAM documentation (https://cloud.google.com/iam/docs/).
type Policy struct {
	// AuditConfigs: Specifies cloud audit logging configuration for this policy.
	AuditConfigs []*AuditConfig `json:"auditConfigs,omitempty"`
	// Bindings: Associates a list of `members`, or principals, with a `role`.
	// Optionally, may specify a `condition` that determines how and when the
	// `bindings` are applied. Each of the `bindings` must contain at least one
	// principal. The `bindings` in a `Policy` can refer to up to 1,500 principals;
	// up to 250 of these principals can be Google groups. Each occurrence of a
	// principal counts towards these limits. For example, if the `bindings` grant
	// 50 different roles to `user:alice@example.com`, and not to any other
	// principal, then you can add another 1,450 principals to the `bindings` in
	// the `Policy`.
	Bindings []*Binding `json:"bindings,omitempty"`
	// Etag: `etag` is used for optimistic concurrency control as a way to help
	// prevent simultaneous updates of a policy from overwriting each other. It is
	// strongly suggested that systems make use of the `etag` in the
	// read-modify-write cycle to perform policy updates in order to avoid race
	// conditions: An `etag` is returned in the response to `getIamPolicy`, and
	// systems are expected to put that etag in the request to `setIamPolicy` to
	// ensure that their change will be applied to the same version of the policy.
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost.
	Etag string `json:"etag,omitempty"`
	// Version: Specifies the format of the policy. Valid values are `0`, `1`, and
	// `3`. Requests that specify an invalid value are rejected. Any operation that
	// affects conditional role bindings must specify version `3`. This requirement
	// applies to the following operations: * Getting a policy that includes a
	// conditional role binding * Adding a conditional role binding to a policy *
	// Changing a conditional role binding in a policy * Removing any role binding,
	// with or without a condition, from a policy that includes conditions
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost. If a policy does not
	// include any conditions, operations on that policy may specify any valid
	// version or leave the field unset. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Version int64 `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AuditConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditConfigs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Policy) MarshalJSON() ([]byte, error) {
	type NoMethod Policy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type PollingOptions struct {
	// Diagnostics: An array of diagnostics to be collected by Deployment Manager,
	// these diagnostics will be displayed to the user.
	Diagnostics []*Diagnostic `json:"diagnostics,omitempty"`
	// FailCondition: JsonPath expression that determines if the request failed.
	FailCondition string `json:"failCondition,omitempty"`
	// FinishCondition: JsonPath expression that determines if the request is
	// completed.
	FinishCondition string `json:"finishCondition,omitempty"`
	// PollingLink: JsonPath expression that evaluates to string, it indicates
	// where to poll.
	PollingLink string `json:"pollingLink,omitempty"`
	// TargetLink: JsonPath expression, after polling is completed, indicates where
	// to fetch the resource.
	TargetLink string `json:"targetLink,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Diagnostics") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Diagnostics") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PollingOptions) MarshalJSON() ([]byte, error) {
	type NoMethod PollingOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// QuotaExceededInfo: Additional details for quota exceeded error for resource
// quota.
type QuotaExceededInfo struct {
	// Dimensions: The map holding related quota dimensions.
	Dimensions map[string]string `json:"dimensions,omitempty"`
	// FutureLimit: Future quota limit being rolled out. The limit's unit depends
	// on the quota type or metric.
	FutureLimit float64 `json:"futureLimit,omitempty"`
	// Limit: Current effective quota limit. The limit's unit depends on the quota
	// type or metric.
	Limit float64 `json:"limit,omitempty"`
	// LimitName: The name of the quota limit.
	LimitName string `json:"limitName,omitempty"`
	// MetricName: The Compute Engine quota metric name.
	MetricName string `json:"metricName,omitempty"`
	// RolloutStatus: Rollout status of the future quota limit.
	//
	// Possible values:
	//   "ROLLOUT_STATUS_UNSPECIFIED" - ROLLOUT_STATUS_UNSPECIFIED - Rollout status
	// is not specified. The default value.
	//   "IN_PROGRESS" - IN_PROGRESS - A rollout is in process which will change
	// the limit value to future limit.
	RolloutStatus string `json:"rolloutStatus,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dimensions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QuotaExceededInfo) MarshalJSON() ([]byte, error) {
	type NoMethod QuotaExceededInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *QuotaExceededInfo) UnmarshalJSON(data []byte) error {
	type NoMethod QuotaExceededInfo
	var s1 struct {
		FutureLimit gensupport.JSONFloat64 `json:"futureLimit"`
		Limit       gensupport.JSONFloat64 `json:"limit"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FutureLimit = float64(s1.FutureLimit)
	s.Limit = float64(s1.Limit)
	return nil
}

type Resource struct {
	// AccessControl: The Access Control Policy set on this resource.
	AccessControl *ResourceAccessControl `json:"accessControl,omitempty"`
	// FinalProperties: Output only. The evaluated properties of the resource with
	// references expanded. Returned as serialized YAML.
	FinalProperties string `json:"finalProperties,omitempty"`
	Id              uint64 `json:"id,omitempty,string"`
	// InsertTime: Output only. Creation timestamp in RFC3339 text format.
	InsertTime string `json:"insertTime,omitempty"`
	// Manifest: Output only. URL of the manifest representing the current
	// configuration of this resource.
	Manifest string `json:"manifest,omitempty"`
	// Name: Output only. The name of the resource as it appears in the YAML
	// config.
	Name string `json:"name,omitempty"`
	// Properties: Output only. The current properties of the resource before any
	// references have been filled in. Returned as serialized YAML.
	Properties string `json:"properties,omitempty"`
	// Type: Output only. The type of the resource, for example
	// `compute.v1.instance`, or `cloudfunctions.v1beta1.function`.
	Type string `json:"type,omitempty"`
	// Update: Output only. If Deployment Manager is currently updating or
	// previewing an update to this resource, the updated configuration appears
	// here.
	Update *ResourceUpdate `json:"update,omitempty"`
	// UpdateTime: Output only. Update timestamp in RFC3339 text format.
	UpdateTime string `json:"updateTime,omitempty"`
	// Url: Output only. The URL of the actual resource.
	Url string `json:"url,omitempty"`
	// Warnings: Output only. If warning messages are generated during processing
	// of this resource, this field will be populated.
	Warnings []*ResourceWarnings `json:"warnings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccessControl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessControl") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Resource) MarshalJSON() ([]byte, error) {
	type NoMethod Resource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ResourceWarnings struct {
	// Code: [Output Only] A warning code, if applicable. For example, Compute
	// Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.
	//
	// Possible values:
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was created.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list page.
	//   "UNREACHABLE" - A given scope cannot be reached.
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is not
	// assigned to an instance on the network.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL refers to
	// an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance URL
	// refers to an instance that is not on the same network as the route.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot ip
	// forward.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not have a
	// status of RUNNING.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an injected
	// kernel, which is deprecated.
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource that
	// requires a TOS they have not accepted.
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk that is
	// larger than image size.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to auto-delete
	// could not be deleted because they were in use.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in instance
	// group manager is valid as such, but its application does not make a lot of
	// sense, because it allows only single instance in instance group.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to continue
	// the process despite the mentioned error.
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient changes made
	// by a failed operation.
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a resource is
	// in use.
	//   "NETWORK_ENDPOINT_NOT_DETACHED" - Warning that network endpoint was not
	// detached.
	//   "PAGE_MISSING_RESULTS" - Current page contains less results than requested
	// but a next page token exists.
	//   "SSL_POLICY_ENABLED_FEATURES_NOT_FETCHED" - Warning that SSL policy
	// resource in the response does not contain information about the list of
	// enabled features.
	//   "RESOURCE_NOT_FOUND_WARNING" - Warning that a resource is not found.
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api call
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema are
	// present
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the resources
	// has a type marked as deprecated
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be missing
	// due to errors
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's nextHopInstance
	// URL refers to an instance that does not have an ipv6 interface on the same
	// network as the route.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV backend
	// service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LIST_OVERHEAD_QUOTA_EXCEED" - Resource can't be retrieved due to list
	// overhead quota exceed which captures the amount of resources filtered out by
	// user-defined list filter.
	//   "QUOTA_INFO_UNAVAILABLE" - Quota information is not available to client
	// requests (e.g: regions.list).
	//   "RESOURCE_USES_GLOBAL_DNS" - Indicates that a VM is using global DNS. Can
	// also be used to indicate that a resource has attributes that could result in
	// the creation of a VM that uses global DNS.
	//   "RESERVED_ENTRY_134" - Reserved entries for quickly adding new warnings
	// without breaking dependent clients.
	//   "RESERVED_ENTRY_135"
	//   "RESERVED_ENTRY_136"
	//   "RESERVED_ENTRY_139"
	//   "RESERVED_ENTRY_141"
	Code string `json:"code,omitempty"`
	// Data: [Output Only] Metadata about this warning in key: value format. For
	// example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*ResourceWarningsData `json:"data,omitempty"`
	// Message: [Output Only] A human-readable description of the warning code.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResourceWarnings) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceWarnings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ResourceWarningsData struct {
	// Key: [Output Only] A key that provides more detail on the warning being
	// returned. For example, for warnings where there are no results in a list
	// request for a particular zone, this key might be scope and the key value
	// might be the zone name. Other examples might be a key indicating a
	// deprecated resource and a suggested replacement, or a warning about invalid
	// network settings (for example, if an instance attempts to perform IP
	// forwarding but is not enabled for IP forwarding).
	Key string `json:"key,omitempty"`
	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResourceWarningsData) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceWarningsData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ResourceAccessControl: The access controls set on the resource.
type ResourceAccessControl struct {
	// GcpIamPolicy: The GCP IAM Policy to set on the resource.
	GcpIamPolicy string `json:"gcpIamPolicy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcpIamPolicy") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcpIamPolicy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResourceAccessControl) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceAccessControl
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ResourceUpdate struct {
	// AccessControl: The Access Control Policy to set on this resource after
	// updating the resource itself.
	AccessControl *ResourceAccessControl `json:"accessControl,omitempty"`
	// Error: Output only. If errors are generated during update of the resource,
	// this field will be populated.
	Error *ResourceUpdateError `json:"error,omitempty"`
	// FinalProperties: Output only. The expanded properties of the resource with
	// reference values expanded. Returned as serialized YAML.
	FinalProperties string `json:"finalProperties,omitempty"`
	// Intent: Output only. The intent of the resource: `PREVIEW`, `UPDATE`, or
	// `CANCEL`.
	//
	// Possible values:
	//   "CREATE_OR_ACQUIRE" - The resource is scheduled to be created, or if it
	// already exists, acquired.
	//   "DELETE" - The resource is scheduled to be deleted.
	//   "ACQUIRE" - The resource is scheduled to be acquired.
	//   "UPDATE" - The resource is scheduled to be updated via the UPDATE method.
	//   "ABANDON" - The resource is scheduled to be abandoned.
	//   "CREATE" - The resource is scheduled to be created.
	Intent string `json:"intent,omitempty"`
	// Manifest: Output only. URL of the manifest representing the update
	// configuration of this resource.
	Manifest string `json:"manifest,omitempty"`
	// Properties: Output only. The set of updated properties for this resource,
	// before references are expanded. Returned as serialized YAML.
	Properties string `json:"properties,omitempty"`
	// State: Output only. The state of the resource.
	//
	// Possible values:
	//   "PENDING" - There are changes pending for this resource.
	//   "IN_PROGRESS" - The service is executing changes on the resource.
	//   "IN_PREVIEW" - The service is previewing changes on the resource.
	//   "FAILED" - The service has failed to change the resource.
	//   "ABORTED" - The service has aborted trying to change the resource.
	State string `json:"state,omitempty"`
	// Warnings: Output only. If warning messages are generated during processing
	// of this resource, this field will be populated.
	Warnings []*ResourceUpdateWarnings `json:"warnings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessControl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessControl") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResourceUpdate) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceUpdate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ResourceUpdateError: Output only. If errors are generated during update of
// the resource, this field will be populated.
type ResourceUpdateError struct {
	// Errors: [Output Only] The array of errors encountered while processing this
	// operation.
	Errors []*ResourceUpdateErrorErrors `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResourceUpdateError) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceUpdateError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ResourceUpdateErrorErrors struct {
	// Arguments: [Output Only] Optional error details WARNING: DO NOT MAKE VISIBLE
	// This is for internal use-only (like componentization) (thus the visibility
	// "none") and in case of public exposure it is strongly recommended to follow
	// pattern of: https://aip.dev/193 and expose as details field.
	Arguments []string `json:"arguments,omitempty"`
	// Code: [Output Only] The error type identifier for this error.
	Code      string     `json:"code,omitempty"`
	DebugInfo *DebugInfo `json:"debugInfo,omitempty"`
	// ErrorDetails: [Output Only] An optional list of messages that contain the
	// error details. There is a set of defined message types to use for providing
	// details.The syntax depends on the error code. For example, QuotaExceededInfo
	// will have details when the error code is QUOTA_EXCEEDED.
	ErrorDetails []*ResourceUpdateErrorErrorsErrorDetails `json:"errorDetails,omitempty"`
	// Location: [Output Only] Indicates the field in the request that caused the
	// error. This property is optional.
	Location string `json:"location,omitempty"`
	// Message: [Output Only] An optional, human-readable error message.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Arguments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Arguments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResourceUpdateErrorErrors) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceUpdateErrorErrors
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ResourceUpdateErrorErrorsErrorDetails struct {
	ErrorInfo        *ErrorInfo         `json:"errorInfo,omitempty"`
	Help             *Help              `json:"help,omitempty"`
	LocalizedMessage *LocalizedMessage  `json:"localizedMessage,omitempty"`
	QuotaInfo        *QuotaExceededInfo `json:"quotaInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResourceUpdateErrorErrorsErrorDetails) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceUpdateErrorErrorsErrorDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ResourceUpdateWarnings struct {
	// Code: [Output Only] A warning code, if applicable. For example, Compute
	// Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.
	//
	// Possible values:
	//   "DEPRECATED_RESOURCE_USED" - A link to a deprecated resource was created.
	//   "NO_RESULTS_ON_PAGE" - No results are present on a particular list page.
	//   "UNREACHABLE" - A given scope cannot be reached.
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED" - The route's nextHopIp address is not
	// assigned to an instance on the network.
	//   "NEXT_HOP_INSTANCE_NOT_FOUND" - The route's nextHopInstance URL refers to
	// an instance that does not exist.
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK" - The route's nextHopInstance URL
	// refers to an instance that is not on the same network as the route.
	//   "NEXT_HOP_CANNOT_IP_FORWARD" - The route's next hop instance cannot ip
	// forward.
	//   "NEXT_HOP_NOT_RUNNING" - The route's next hop instance does not have a
	// status of RUNNING.
	//   "INJECTED_KERNELS_DEPRECATED" - The operation involved use of an injected
	// kernel, which is deprecated.
	//   "REQUIRED_TOS_AGREEMENT" - The user attempted to use a resource that
	// requires a TOS they have not accepted.
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE" - The user created a boot disk that is
	// larger than image size.
	//   "RESOURCE_NOT_DELETED" - One or more of the resources set to auto-delete
	// could not be deleted because they were in use.
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE" - Instance template used in instance
	// group manager is valid as such, but its application does not make a lot of
	// sense, because it allows only single instance in instance group.
	//   "NOT_CRITICAL_ERROR" - Error which is not critical. We decided to continue
	// the process despite the mentioned error.
	//   "CLEANUP_FAILED" - Warning about failed cleanup of transient changes made
	// by a failed operation.
	//   "FIELD_VALUE_OVERRIDEN" - Warning that value of a field has been
	// overridden. Deprecated unused field.
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING" - Warning that a resource is
	// in use.
	//   "NETWORK_ENDPOINT_NOT_DETACHED" - Warning that network endpoint was not
	// detached.
	//   "PAGE_MISSING_RESULTS" - Current page contains less results than requested
	// but a next page token exists.
	//   "SSL_POLICY_ENABLED_FEATURES_NOT_FETCHED" - Warning that SSL policy
	// resource in the response does not contain information about the list of
	// enabled features.
	//   "RESOURCE_NOT_FOUND_WARNING" - Warning that a resource is not found.
	//   "MISSING_TYPE_DEPENDENCY" - A resource depends on a missing type
	//   "EXTERNAL_API_WARNING" - Warning that is present in an external api call
	//   "SCHEMA_VALIDATION_IGNORED" - When a resource schema validation is
	// ignored.
	//   "UNDECLARED_PROPERTIES" - When undeclared properties in the schema are
	// present
	//   "EXPERIMENTAL_TYPE_USED" - When deploying and at least one of the
	// resources has a type marked as experimental
	//   "DEPRECATED_TYPE_USED" - When deploying and at least one of the resources
	// has a type marked as deprecated
	//   "PARTIAL_SUCCESS" - Success is reported, but some results may be missing
	// due to errors
	//   "LARGE_DEPLOYMENT_WARNING" - When deploying a deployment with a
	// exceedingly large number of resources
	//   "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE" - The route's nextHopInstance
	// URL refers to an instance that does not have an ipv6 interface on the same
	// network as the route.
	//   "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB" - A WEIGHTED_MAGLEV backend
	// service is associated with a health check that is not of type
	// HTTP/HTTPS/HTTP2.
	//   "LIST_OVERHEAD_QUOTA_EXCEED" - Resource can't be retrieved due to list
	// overhead quota exceed which captures the amount of resources filtered out by
	// user-defined list filter.
	//   "QUOTA_INFO_UNAVAILABLE" - Quota information is not available to client
	// requests (e.g: regions.list).
	//   "RESOURCE_USES_GLOBAL_DNS" - Indicates that a VM is using global DNS. Can
	// also be used to indicate that a resource has attributes that could result in
	// the creation of a VM that uses global DNS.
	//   "RESERVED_ENTRY_134" - Reserved entries for quickly adding new warnings
	// without breaking dependent clients.
	//   "RESERVED_ENTRY_135"
	//   "RESERVED_ENTRY_136"
	//   "RESERVED_ENTRY_139"
	//   "RESERVED_ENTRY_141"
	Code string `json:"code,omitempty"`
	// Data: [Output Only] Metadata about this warning in key: value format. For
	// example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*ResourceUpdateWarningsData `json:"data,omitempty"`
	// Message: [Output Only] A human-readable description of the warning code.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResourceUpdateWarnings) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceUpdateWarnings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ResourceUpdateWarningsData struct {
	// Key: [Output Only] A key that provides more detail on the warning being
	// returned. For example, for warnings where there are no results in a list
	// request for a particular zone, this key might be scope and the key value
	// might be the zone name. Other examples might be a key indicating a
	// deprecated resource and a suggested replacement, or a warning about invalid
	// network settings (for example, if an instance attempts to perform IP
	// forwarding but is not enabled for IP forwarding).
	Key string `json:"key,omitempty"`
	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResourceUpdateWarningsData) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceUpdateWarningsData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ResourcesListResponse: A response containing a partial list of resources and
// a page token used to build the next request if the request has been
// truncated.
type ResourcesListResponse struct {
	// NextPageToken: A token used to continue a truncated list request.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Resources: Resources contained in this list response.
	Resources []*Resource `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResourcesListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ResourcesListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServiceAccount: Service Account used as a credential.
type ServiceAccount struct {
	// Email: The IAM service account email address like
	// test@myproject.iam.gserviceaccount.com
	Email string `json:"email,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Email") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServiceAccount) MarshalJSON() ([]byte, error) {
	type NoMethod ServiceAccount
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type SetCommonInstanceMetadataOperationMetadata struct {
	// ClientOperationId: [Output Only] The client operation id.
	ClientOperationId string `json:"clientOperationId,omitempty"`
	// PerLocationOperations: [Output Only] Status information per location
	// (location name is key). Example key: zones/us-central1-a
	PerLocationOperations map[string]SetCommonInstanceMetadataOperationMetadataPerLocationOperationInfo `json:"perLocationOperations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClientOperationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientOperationId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetCommonInstanceMetadataOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod SetCommonInstanceMetadataOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type SetCommonInstanceMetadataOperationMetadataPerLocationOperationInfo struct {
	// Error: [Output Only] If state is `ABANDONED` or `FAILED`, this field is
	// populated.
	Error *Status `json:"error,omitempty"`
	// State: [Output Only] Status of the action, which can be one of the
	// following: `PROPAGATING`, `PROPAGATED`, `ABANDONED`, `FAILED`, or `DONE`.
	//
	// Possible values:
	//   "UNSPECIFIED"
	//   "PROPAGATING" - Operation is not yet confirmed to have been created in the
	// location.
	//   "PROPAGATED" - Operation is confirmed to be in the location.
	//   "ABANDONED" - Operation not tracked in this location e.g. zone is marked
	// as DOWN.
	//   "FAILED" - Operation is in an error state.
	//   "DONE" - Operation has completed successfully.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Error") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Error") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetCommonInstanceMetadataOperationMetadataPerLocationOperationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod SetCommonInstanceMetadataOperationMetadataPerLocationOperationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TargetConfiguration struct {
	// Config: The configuration to use for this deployment.
	Config *ConfigFile `json:"config,omitempty"`
	// Imports: Specifies any files to import for this configuration. This can be
	// used to import templates or other files. For example, you might import a
	// text file in order to use the file in a template.
	Imports []*ImportFile `json:"imports,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Config") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TargetConfiguration) MarshalJSON() ([]byte, error) {
	type NoMethod TargetConfiguration
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TemplateContents: Files that make up the template contents of a template
// type.
type TemplateContents struct {
	// Imports: Import files referenced by the main template.
	Imports []*ImportFile `json:"imports,omitempty"`
	// Interpreter: Which interpreter (python or jinja) should be used during
	// expansion.
	//
	// Possible values:
	//   "UNKNOWN_INTERPRETER"
	//   "PYTHON"
	//   "JINJA"
	Interpreter string `json:"interpreter,omitempty"`
	// MainTemplate: The filename of the mainTemplate
	MainTemplate string `json:"mainTemplate,omitempty"`
	// Schema: The contents of the template schema.
	Schema string `json:"schema,omitempty"`
	// Template: The contents of the main template file.
	Template string `json:"template,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Imports") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Imports") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TemplateContents) MarshalJSON() ([]byte, error) {
	type NoMethod TemplateContents
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TestPermissionsRequest struct {
	// Permissions: The set of permissions to check for the 'resource'. Permissions
	// with wildcards (such as '*' or 'storage.*') are not allowed.
	Permissions []string `json:"permissions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestPermissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod TestPermissionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TestPermissionsResponse struct {
	// Permissions: A subset of `TestPermissionsRequest.permissions` that the
	// caller is allowed.
	Permissions []string `json:"permissions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestPermissionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TestPermissionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Type: A resource type supported by Deployment Manager.
type Type struct {
	// Base: Base Type (configurable service) that backs this Type.
	Base *BaseType `json:"base,omitempty"`
	// Description: An optional textual description of the resource; provided by
	// the client when the resource is created.
	Description string `json:"description,omitempty"`
	Id          uint64 `json:"id,omitempty,string"`
	// InsertTime: Output only. Creation timestamp in RFC3339 text format.
	InsertTime string `json:"insertTime,omitempty"`
	// Labels: Map of One Platform labels; provided by the client when the resource
	// is created or updated. Specifically: Label keys must be between 1 and 63
	// characters long and must conform to the following regular expression: `a-z
	// ([-a-z0-9]*[a-z0-9])?` Label values must be between 0 and 63 characters long
	// and must conform to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
	Labels []*TypeLabelEntry `json:"labels,omitempty"`
	// Name: Name of the type.
	Name string `json:"name,omitempty"`
	// Operation: Output only. The Operation that most recently ran, or is
	// currently running, on this type.
	Operation *Operation `json:"operation,omitempty"`
	// SelfLink: Output only. Server defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Base") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Base") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Type) MarshalJSON() ([]byte, error) {
	type NoMethod Type
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TypeInfo: Type Information. Contains detailed information about a composite
// type, base type, or base type with specific collection.
type TypeInfo struct {
	// Description: The description of the type.
	Description string `json:"description,omitempty"`
	// DocumentationLink: For swagger 2.0 externalDocs field will be used. For
	// swagger 1.2 this field will be empty.
	DocumentationLink string `json:"documentationLink,omitempty"`
	// Kind: Output only. Type of the output. Always `deploymentManager#TypeInfo`
	// for TypeInfo.
	Kind string `json:"kind,omitempty"`
	// Name: The base type or composite type name.
	Name string `json:"name,omitempty"`
	// Schema: For base types with a collection, we return a schema and
	// documentation link For template types, we return only a schema
	Schema *TypeInfoSchemaInfo `json:"schema,omitempty"`
	// SelfLink: Output only. Self link for the type provider.
	SelfLink string `json:"selfLink,omitempty"`
	// Title: The title on the API descriptor URL provided.
	Title string `json:"title,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TypeInfo) MarshalJSON() ([]byte, error) {
	type NoMethod TypeInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TypeInfoSchemaInfo struct {
	// Input: The properties that this composite type or base type collection
	// accept as input, represented as a json blob, format is: JSON Schema Draft V4
	Input string `json:"input,omitempty"`
	// Output: The properties that this composite type or base type collection
	// exposes as output, these properties can be used for references, represented
	// as json blob, format is: JSON Schema Draft V4
	Output string `json:"output,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Input") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Input") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TypeInfoSchemaInfo) MarshalJSON() ([]byte, error) {
	type NoMethod TypeInfoSchemaInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TypeLabelEntry: Label object for Types
type TypeLabelEntry struct {
	// Key: Key of the label
	Key string `json:"key,omitempty"`
	// Value: Value of the label
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TypeLabelEntry) MarshalJSON() ([]byte, error) {
	type NoMethod TypeLabelEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TypeProvider: A type provider that describes a service-backed Type.
type TypeProvider struct {
	// CollectionOverrides: Allows resource handling overrides for specific
	// collections
	CollectionOverrides []*CollectionOverride `json:"collectionOverrides,omitempty"`
	// Credential: Credential used when interacting with this type.
	Credential *Credential `json:"credential,omitempty"`
	// CustomCertificateAuthorityRoots: List of up to 2 custom certificate
	// authority roots to use for TLS authentication when making calls on behalf of
	// this type provider. If set, TLS authentication will exclusively use these
	// roots instead of relying on publicly trusted certificate authorities when
	// validating TLS certificate authenticity. The certificates must be in
	// base64-encoded PEM format. The maximum size of each certificate must not
	// exceed 10KB.
	CustomCertificateAuthorityRoots []string `json:"customCertificateAuthorityRoots,omitempty"`
	// Description: An optional textual description of the resource; provided by
	// the client when the resource is created.
	Description string `json:"description,omitempty"`
	// DescriptorUrl: Descriptor Url for the this type provider.
	DescriptorUrl string `json:"descriptorUrl,omitempty"`
	// Id: Output only. Unique identifier for the resource defined by the server.
	Id uint64 `json:"id,omitempty,string"`
	// InsertTime: Output only. Creation timestamp in RFC3339 text format.
	InsertTime string `json:"insertTime,omitempty"`
	// Labels: Map of One Platform labels; provided by the client when the resource
	// is created or updated. Specifically: Label keys must be between 1 and 63
	// characters long and must conform to the following regular expression: `a-z
	// ([-a-z0-9]*[a-z0-9])?` Label values must be between 0 and 63 characters long
	// and must conform to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`
	Labels []*TypeProviderLabelEntry `json:"labels,omitempty"`
	// Name: Name of the resource; provided by the client when the resource is
	// created. The name must be 1-63 characters long, and comply with RFC1035.
	// Specifically, the name must be 1-63 characters long and match the regular
	// expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must
	// be a lowercase letter, and all following characters must be a dash,
	// lowercase letter, or digit, except the last character, which cannot be a
	// dash.
	Name string `json:"name,omitempty"`
	// Operation: Output only. The Operation that most recently ran, or is
	// currently running, on this type provider.
	Operation *Operation `json:"operation,omitempty"`
	// Options: Options to apply when handling any resources in this service.
	Options *Options `json:"options,omitempty"`
	// SelfLink: Output only. Self link for the type provider.
	SelfLink string `json:"selfLink,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CollectionOverrides") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CollectionOverrides") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TypeProvider) MarshalJSON() ([]byte, error) {
	type NoMethod TypeProvider
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TypeProviderLabelEntry: Label object for TypeProviders
type TypeProviderLabelEntry struct {
	// Key: Key of the label
	Key string `json:"key,omitempty"`
	// Value: Value of the label
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TypeProviderLabelEntry) MarshalJSON() ([]byte, error) {
	type NoMethod TypeProviderLabelEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TypeProvidersListResponse: A response that returns all Type Providers
// supported by Deployment Manager
type TypeProvidersListResponse struct {
	// NextPageToken: A token used to continue a truncated list request.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TypeProviders: Output only. A list of resource type providers supported by
	// Deployment Manager.
	TypeProviders []*TypeProvider `json:"typeProviders,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TypeProvidersListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TypeProvidersListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TypeProvidersListTypesResponse struct {
	// NextPageToken: A token used to continue a truncated list request.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Types: Output only. A list of resource type info.
	Types []*TypeInfo `json:"types,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TypeProvidersListTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TypeProvidersListTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TypesListResponse: A response that returns all Types supported by Deployment
// Manager
type TypesListResponse struct {
	// NextPageToken: A token used to continue a truncated list request.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Types: Output only. A list of resource types supported by Deployment
	// Manager.
	Types []*Type `json:"types,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TypesListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TypesListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ValidationOptions: Options for how to validate and process properties on a
// resource.
type ValidationOptions struct {
	// SchemaValidation: Customize how deployment manager will validate the
	// resource against schema errors.
	//
	// Possible values:
	//   "UNKNOWN"
	//   "IGNORE" - Ignore schema failures.
	//   "IGNORE_WITH_WARNINGS" - Ignore schema failures but display them as
	// warnings.
	//   "FAIL" - Fail the resource if the schema is not valid, this is the default
	// behavior.
	SchemaValidation string `json:"schemaValidation,omitempty"`
	// UndeclaredProperties: Specify what to do with extra properties when
	// executing a request.
	//
	// Possible values:
	//   "UNKNOWN"
	//   "INCLUDE" - Always include even if not present on discovery doc.
	//   "IGNORE" - Always ignore if not present on discovery doc.
	//   "INCLUDE_WITH_WARNINGS" - Include on request, but emit a warning.
	//   "IGNORE_WITH_WARNINGS" - Ignore properties, but emit a warning.
	//   "FAIL" - Always fail if undeclared properties are present.
	UndeclaredProperties string `json:"undeclaredProperties,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SchemaValidation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SchemaValidation") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ValidationOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ValidationOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CompositeTypesDeleteCall struct {
	s             *Service
	project       string
	compositeType string
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Delete: Deletes a composite type.
//
// - compositeType: The name of the type for this request.
// - project: The project ID for this request.
func (r *CompositeTypesService) Delete(project string, compositeType string) *CompositeTypesDeleteCall {
	c := &CompositeTypesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.compositeType = compositeType
	return c
}

// HeaderBypassBillingFilter sets the optional parameter
// "header.bypassBillingFilter":
func (c *CompositeTypesDeleteCall) HeaderBypassBillingFilter(headerBypassBillingFilter bool) *CompositeTypesDeleteCall {
	c.urlParams_.Set("header.bypassBillingFilter", fmt.Sprint(headerBypassBillingFilter))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CompositeTypesDeleteCall) Fields(s ...googleapi.Field) *CompositeTypesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CompositeTypesDeleteCall) Context(ctx context.Context) *CompositeTypesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CompositeTypesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CompositeTypesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/compositeTypes/{compositeType}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":       c.project,
		"compositeType": c.compositeType,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.compositeTypes.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CompositeTypesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CompositeTypesGetCall struct {
	s             *Service
	project       string
	compositeType string
	urlParams_    gensupport.URLParams
	ifNoneMatch_  string
	ctx_          context.Context
	header_       http.Header
}

// Get: Gets information about a specific composite type.
//
// - compositeType: The name of the composite type for this request.
// - project: The project ID for this request.
func (r *CompositeTypesService) Get(project string, compositeType string) *CompositeTypesGetCall {
	c := &CompositeTypesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.compositeType = compositeType
	return c
}

// HeaderBypassBillingFilter sets the optional parameter
// "header.bypassBillingFilter":
func (c *CompositeTypesGetCall) HeaderBypassBillingFilter(headerBypassBillingFilter bool) *CompositeTypesGetCall {
	c.urlParams_.Set("header.bypassBillingFilter", fmt.Sprint(headerBypassBillingFilter))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CompositeTypesGetCall) Fields(s ...googleapi.Field) *CompositeTypesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CompositeTypesGetCall) IfNoneMatch(entityTag string) *CompositeTypesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CompositeTypesGetCall) Context(ctx context.Context) *CompositeTypesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CompositeTypesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CompositeTypesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/compositeTypes/{compositeType}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":       c.project,
		"compositeType": c.compositeType,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.compositeTypes.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *CompositeType.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CompositeTypesGetCall) Do(opts ...googleapi.CallOption) (*CompositeType, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CompositeType{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CompositeTypesInsertCall struct {
	s             *Service
	project       string
	compositetype *CompositeType
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Insert: Creates a composite type.
//
// - project: The project ID for this request.
func (r *CompositeTypesService) Insert(project string, compositetype *CompositeType) *CompositeTypesInsertCall {
	c := &CompositeTypesInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.compositetype = compositetype
	return c
}

// HeaderBypassBillingFilter sets the optional parameter
// "header.bypassBillingFilter":
func (c *CompositeTypesInsertCall) HeaderBypassBillingFilter(headerBypassBillingFilter bool) *CompositeTypesInsertCall {
	c.urlParams_.Set("header.bypassBillingFilter", fmt.Sprint(headerBypassBillingFilter))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CompositeTypesInsertCall) Fields(s ...googleapi.Field) *CompositeTypesInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CompositeTypesInsertCall) Context(ctx context.Context) *CompositeTypesInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CompositeTypesInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CompositeTypesInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.compositetype)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/compositeTypes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.compositeTypes.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CompositeTypesInsertCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CompositeTypesListCall struct {
	s            *Service
	project      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all composite types for Deployment Manager.
//
// - project: The project ID for this request.
func (r *CompositeTypesService) List(project string) *CompositeTypesListCall {
	c := &CompositeTypesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most Compute resources support two
// types of filter expressions: expressions that support regular expressions
// and expressions that follow API improvement proposal AIP-160. These two
// types of filter expressions cannot be mixed in one request. If you want to
// use AIP-160, your expression must specify the field name, an operator, and
// the value that you want to use for filtering. The value must be a string, a
// number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`,
// `>=` or `:`. For example, if you are filtering Compute Engine instances, you
// can exclude instances named `example-instance` by specifying `name !=
// example-instance`. The `:*` comparison can be used to test whether a key has
// been defined. For example, to find all objects with `owner` label use: ```
// labels.owner:* ``` You can also filter nested fields. For example, you could
// specify `scheduling.automaticRestart = false` to include instances only if
// they are not scheduled for automatic restarts. You can use filtering on
// nested fields to filter based on resource labels. To filter on multiple
// expressions, provide each separate expression within parentheses. For
// example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
// Skylake") ``` By default, each expression is an `AND` expression. However,
// you can include `AND` and `OR` expressions explicitly. For example: ```
// (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true) ``` If you want to use a regular
// expression, use the `eq` (equal) or `ne` (not equal) operator against a
// single un-parenthesized expression with or without quotes or against
// multiple parenthesized expressions. Examples: `fieldname eq unquoted
// literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted
// literal" `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal
// value is interpreted as a regular expression using Google RE2 library
// syntax. The literal value must match the entire field. For example, to
// filter for instances that do not end with name "instance", you would use
// `name ne .*instance`. You cannot combine constraints on multiple fields
// using regular expressions.
func (c *CompositeTypesListCall) Filter(filter string) *CompositeTypesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned. If the number of available results
// is larger than `maxResults`, Compute Engine returns a `nextPageToken` that
// can be used to get the next page of results in subsequent list requests.
// Acceptable values are `0` to `500`, inclusive. (Default: `500`)
func (c *CompositeTypesListCall) MaxResults(maxResults int64) *CompositeTypesListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results are returned in alphanumerical order
// based on the resource name. You can also sort results in descending order
// based on the creation timestamp using `orderBy="creationTimestamp desc".
// This sorts results based on the `creationTimestamp` field in reverse
// chronological order (newest result first). Use this to sort resources like
// operations so that the newest operation is returned first. Currently, only
// sorting by `name` or `creationTimestamp desc` is supported.
func (c *CompositeTypesListCall) OrderBy(orderBy string) *CompositeTypesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the `nextPageToken` returned by a previous list
// request to get the next page of results.
func (c *CompositeTypesListCall) PageToken(pageToken string) *CompositeTypesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CompositeTypesListCall) Fields(s ...googleapi.Field) *CompositeTypesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CompositeTypesListCall) IfNoneMatch(entityTag string) *CompositeTypesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CompositeTypesListCall) Context(ctx context.Context) *CompositeTypesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CompositeTypesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CompositeTypesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/compositeTypes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.compositeTypes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *CompositeTypesListResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CompositeTypesListCall) Do(opts ...googleapi.CallOption) (*CompositeTypesListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CompositeTypesListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CompositeTypesListCall) Pages(ctx context.Context, f func(*CompositeTypesListResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CompositeTypesPatchCall struct {
	s             *Service
	project       string
	compositeType string
	compositetype *CompositeType
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Patch: Patches a composite type.
//
// - compositeType: The name of the composite type for this request.
// - project: The project ID for this request.
func (r *CompositeTypesService) Patch(project string, compositeType string, compositetype *CompositeType) *CompositeTypesPatchCall {
	c := &CompositeTypesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.compositeType = compositeType
	c.compositetype = compositetype
	return c
}

// HeaderBypassBillingFilter sets the optional parameter
// "header.bypassBillingFilter":
func (c *CompositeTypesPatchCall) HeaderBypassBillingFilter(headerBypassBillingFilter bool) *CompositeTypesPatchCall {
	c.urlParams_.Set("header.bypassBillingFilter", fmt.Sprint(headerBypassBillingFilter))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CompositeTypesPatchCall) Fields(s ...googleapi.Field) *CompositeTypesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CompositeTypesPatchCall) Context(ctx context.Context) *CompositeTypesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CompositeTypesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CompositeTypesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.compositetype)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/compositeTypes/{compositeType}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":       c.project,
		"compositeType": c.compositeType,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.compositeTypes.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CompositeTypesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CompositeTypesUpdateCall struct {
	s             *Service
	project       string
	compositeType string
	compositetype *CompositeType
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Update: Updates a composite type.
//
// - compositeType: The name of the composite type for this request.
// - project: The project ID for this request.
func (r *CompositeTypesService) Update(project string, compositeType string, compositetype *CompositeType) *CompositeTypesUpdateCall {
	c := &CompositeTypesUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.compositeType = compositeType
	c.compositetype = compositetype
	return c
}

// HeaderBypassBillingFilter sets the optional parameter
// "header.bypassBillingFilter":
func (c *CompositeTypesUpdateCall) HeaderBypassBillingFilter(headerBypassBillingFilter bool) *CompositeTypesUpdateCall {
	c.urlParams_.Set("header.bypassBillingFilter", fmt.Sprint(headerBypassBillingFilter))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CompositeTypesUpdateCall) Fields(s ...googleapi.Field) *CompositeTypesUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CompositeTypesUpdateCall) Context(ctx context.Context) *CompositeTypesUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CompositeTypesUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CompositeTypesUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.compositetype)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/compositeTypes/{compositeType}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":       c.project,
		"compositeType": c.compositeType,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.compositeTypes.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CompositeTypesUpdateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type DeploymentsCancelPreviewCall struct {
	s                               *Service
	project                         string
	deployment                      string
	deploymentscancelpreviewrequest *DeploymentsCancelPreviewRequest
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// CancelPreview: Cancels and removes the preview currently associated with the
// deployment.
//
// - deployment: The name of the deployment for this request.
// - project: The project ID for this request.
func (r *DeploymentsService) CancelPreview(project string, deployment string, deploymentscancelpreviewrequest *DeploymentsCancelPreviewRequest) *DeploymentsCancelPreviewCall {
	c := &DeploymentsCancelPreviewCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.deployment = deployment
	c.deploymentscancelpreviewrequest = deploymentscancelpreviewrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DeploymentsCancelPreviewCall) Fields(s ...googleapi.Field) *DeploymentsCancelPreviewCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DeploymentsCancelPreviewCall) Context(ctx context.Context) *DeploymentsCancelPreviewCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DeploymentsCancelPreviewCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DeploymentsCancelPreviewCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.deploymentscancelpreviewrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/deployments/{deployment}/cancelPreview")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":    c.project,
		"deployment": c.deployment,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.deployments.cancelPreview" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DeploymentsCancelPreviewCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type DeploymentsDeleteCall struct {
	s          *Service
	project    string
	deployment string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a deployment and all of the resources in the deployment.
//
// - deployment: The name of the deployment for this request.
// - project: The project ID for this request.
func (r *DeploymentsService) Delete(project string, deployment string) *DeploymentsDeleteCall {
	c := &DeploymentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.deployment = deployment
	return c
}

// DeletePolicy sets the optional parameter "deletePolicy": Sets the policy to
// use for deleting resources.
//
// Possible values:
//
//	"DELETE" (default)
//	"ABANDON"
func (c *DeploymentsDeleteCall) DeletePolicy(deletePolicy string) *DeploymentsDeleteCall {
	c.urlParams_.Set("deletePolicy", deletePolicy)
	return c
}

// HeaderBypassBillingFilter sets the optional parameter
// "header.bypassBillingFilter":
func (c *DeploymentsDeleteCall) HeaderBypassBillingFilter(headerBypassBillingFilter bool) *DeploymentsDeleteCall {
	c.urlParams_.Set("header.bypassBillingFilter", fmt.Sprint(headerBypassBillingFilter))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DeploymentsDeleteCall) Fields(s ...googleapi.Field) *DeploymentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DeploymentsDeleteCall) Context(ctx context.Context) *DeploymentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DeploymentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DeploymentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/deployments/{deployment}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":    c.project,
		"deployment": c.deployment,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.deployments.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DeploymentsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type DeploymentsGetCall struct {
	s            *Service
	project      string
	deployment   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a specific deployment.
//
// - deployment: The name of the deployment for this request.
// - project: The project ID for this request.
func (r *DeploymentsService) Get(project string, deployment string) *DeploymentsGetCall {
	c := &DeploymentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.deployment = deployment
	return c
}

// HeaderBypassBillingFilter sets the optional parameter
// "header.bypassBillingFilter":
func (c *DeploymentsGetCall) HeaderBypassBillingFilter(headerBypassBillingFilter bool) *DeploymentsGetCall {
	c.urlParams_.Set("header.bypassBillingFilter", fmt.Sprint(headerBypassBillingFilter))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DeploymentsGetCall) Fields(s ...googleapi.Field) *DeploymentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *DeploymentsGetCall) IfNoneMatch(entityTag string) *DeploymentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DeploymentsGetCall) Context(ctx context.Context) *DeploymentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DeploymentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DeploymentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/deployments/{deployment}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":    c.project,
		"deployment": c.deployment,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.deployments.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Deployment.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DeploymentsGetCall) Do(opts ...googleapi.CallOption) (*Deployment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Deployment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type DeploymentsGetIamPolicyCall struct {
	s            *Service
	project      string
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. May be empty if
// no such policy or resource exists.
//
// - project: Project ID for this request.
// - resource: Name or id of the resource for this request.
func (r *DeploymentsService) GetIamPolicy(project string, resource string) *DeploymentsGetIamPolicyCall {
	c := &DeploymentsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.resource = resource
	return c
}

// HeaderBypassBillingFilter sets the optional parameter
// "header.bypassBillingFilter":
func (c *DeploymentsGetIamPolicyCall) HeaderBypassBillingFilter(headerBypassBillingFilter bool) *DeploymentsGetIamPolicyCall {
	c.urlParams_.Set("header.bypassBillingFilter", fmt.Sprint(headerBypassBillingFilter))
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "optionsRequestedPolicyVersion": Requested IAM Policy version.
func (c *DeploymentsGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *DeploymentsGetIamPolicyCall {
	c.urlParams_.Set("optionsRequestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DeploymentsGetIamPolicyCall) Fields(s ...googleapi.Field) *DeploymentsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *DeploymentsGetIamPolicyCall) IfNoneMatch(entityTag string) *DeploymentsGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DeploymentsGetIamPolicyCall) Context(ctx context.Context) *DeploymentsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DeploymentsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DeploymentsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/deployments/{resource}/getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.deployments.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DeploymentsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type DeploymentsInsertCall struct {
	s          *Service
	project    string
	deployment *Deployment
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Insert: Creates a deployment and all of the resources described by the
// deployment manifest.
//
// - project: The project ID for this request.
func (r *DeploymentsService) Insert(project string, deployment *Deployment) *DeploymentsInsertCall {
	c := &DeploymentsInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.deployment = deployment
	return c
}

// CreatePolicy sets the optional parameter "createPolicy": Sets the policy to
// use for creating new resources.
//
// Possible values:
//
//	"CREATE_OR_ACQUIRE" (default)
//	"ACQUIRE"
//	"CREATE"
func (c *DeploymentsInsertCall) CreatePolicy(createPolicy string) *DeploymentsInsertCall {
	c.urlParams_.Set("createPolicy", createPolicy)
	return c
}

// HeaderBypassBillingFilter sets the optional parameter
// "header.bypassBillingFilter":
func (c *DeploymentsInsertCall) HeaderBypassBillingFilter(headerBypassBillingFilter bool) *DeploymentsInsertCall {
	c.urlParams_.Set("header.bypassBillingFilter", fmt.Sprint(headerBypassBillingFilter))
	return c
}

// Preview sets the optional parameter "preview": If set to true, creates a
// deployment and creates "shell" resources but does not actually instantiate
// these resources. This allows you to preview what your deployment looks like.
// After previewing a deployment, you can deploy your resources by making a
// request with the `update()` method or you can use the `cancelPreview()`
// method to cancel the preview altogether. Note that the deployment will still
// exist after you cancel the preview and you must separately delete this
// deployment if you want to remove it.
func (c *DeploymentsInsertCall) Preview(preview bool) *DeploymentsInsertCall {
	c.urlParams_.Set("preview", fmt.Sprint(preview))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DeploymentsInsertCall) Fields(s ...googleapi.Field) *DeploymentsInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DeploymentsInsertCall) Context(ctx context.Context) *DeploymentsInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DeploymentsInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DeploymentsInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.deployment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/deployments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.deployments.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DeploymentsInsertCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type DeploymentsListCall struct {
	s            *Service
	project      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all deployments for a given project.
//
// - project: The project ID for this request.
func (r *DeploymentsService) List(project string) *DeploymentsListCall {
	c := &DeploymentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most Compute resources support two
// types of filter expressions: expressions that support regular expressions
// and expressions that follow API improvement proposal AIP-160. These two
// types of filter expressions cannot be mixed in one request. If you want to
// use AIP-160, your expression must specify the field name, an operator, and
// the value that you want to use for filtering. The value must be a string, a
// number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`,
// `>=` or `:`. For example, if you are filtering Compute Engine instances, you
// can exclude instances named `example-instance` by specifying `name !=
// example-instance`. The `:*` comparison can be used to test whether a key has
// been defined. For example, to find all objects with `owner` label use: ```
// labels.owner:* ``` You can also filter nested fields. For example, you could
// specify `scheduling.automaticRestart = false` to include instances only if
// they are not scheduled for automatic restarts. You can use filtering on
// nested fields to filter based on resource labels. To filter on multiple
// expressions, provide each separate expression within parentheses. For
// example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
// Skylake") ``` By default, each expression is an `AND` expression. However,
// you can include `AND` and `OR` expressions explicitly. For example: ```
// (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true) ``` If you want to use a regular
// expression, use the `eq` (equal) or `ne` (not equal) operator against a
// single un-parenthesized expression with or without quotes or against
// multiple parenthesized expressions. Examples: `fieldname eq unquoted
// literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted
// literal" `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal
// value is interpreted as a regular expression using Google RE2 library
// syntax. The literal value must match the entire field. For example, to
// filter for instances that do not end with name "instance", you would use
// `name ne .*instance`. You cannot combine constraints on multiple fields
// using regular expressions.
func (c *DeploymentsListCall) Filter(filter string) *DeploymentsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned. If the number of available results
// is larger than `maxResults`, Compute Engine returns a `nextPageToken` that
// can be used to get the next page of results in subsequent list requests.
// Acceptable values are `0` to `500`, inclusive. (Default: `500`)
func (c *DeploymentsListCall) MaxResults(maxResults int64) *DeploymentsListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results are returned in alphanumerical order
// based on the resource name. You can also sort results in descending order
// based on the creation timestamp using `orderBy="creationTimestamp desc".
// This sorts results based on the `creationTimestamp` field in reverse
// chronological order (newest result first). Use this to sort resources like
// operations so that the newest operation is returned first. Currently, only
// sorting by `name` or `creationTimestamp desc` is supported.
func (c *DeploymentsListCall) OrderBy(orderBy string) *DeploymentsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the `nextPageToken` returned by a previous list
// request to get the next page of results.
func (c *DeploymentsListCall) PageToken(pageToken string) *DeploymentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DeploymentsListCall) Fields(s ...googleapi.Field) *DeploymentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *DeploymentsListCall) IfNoneMatch(entityTag string) *DeploymentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DeploymentsListCall) Context(ctx context.Context) *DeploymentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DeploymentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DeploymentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/deployments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.deployments.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *DeploymentsListResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *DeploymentsListCall) Do(opts ...googleapi.CallOption) (*DeploymentsListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DeploymentsListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *DeploymentsListCall) Pages(ctx context.Context, f func(*DeploymentsListResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type DeploymentsPatchCall struct {
	s           *Service
	project     string
	deployment  string
	deployment2 *Deployment
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Patch: Patches a deployment and all of the resources described by the
// deployment manifest.
//
// - deployment: The name of the deployment for this request.
// - project: The project ID for this request.
func (r *DeploymentsService) Patch(project string, deployment string, deployment2 *Deployment) *DeploymentsPatchCall {
	c := &DeploymentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.deployment = deployment
	c.deployment2 = deployment2
	return c
}

// CreatePolicy sets the optional parameter "createPolicy": Sets the policy to
// use for creating new resources.
//
// Possible values:
//
//	"CREATE_OR_ACQUIRE" (default)
//	"ACQUIRE"
//	"CREATE"
func (c *DeploymentsPatchCall) CreatePolicy(createPolicy string) *DeploymentsPatchCall {
	c.urlParams_.Set("createPolicy", createPolicy)
	return c
}

// DeletePolicy sets the optional parameter "deletePolicy": Sets the policy to
// use for deleting resources.
//
// Possible values:
//
//	"DELETE" (default)
//	"ABANDON"
func (c *DeploymentsPatchCall) DeletePolicy(deletePolicy string) *DeploymentsPatchCall {
	c.urlParams_.Set("deletePolicy", deletePolicy)
	return c
}

// HeaderBypassBillingFilter sets the optional parameter
// "header.bypassBillingFilter":
func (c *DeploymentsPatchCall) HeaderBypassBillingFilter(headerBypassBillingFilter bool) *DeploymentsPatchCall {
	c.urlParams_.Set("header.bypassBillingFilter", fmt.Sprint(headerBypassBillingFilter))
	return c
}

// Preview sets the optional parameter "preview": If set to true, updates the
// deployment and creates and updates the "shell" resources but does not
// actually alter or instantiate these resources. This allows you to preview
// what your deployment will look like. You can use this intent to preview how
// an update would affect your deployment. You must provide a `target.config`
// with a configuration if this is set to true. After previewing a deployment,
// you can deploy your resources by making a request with the `update()` or you
// can `cancelPreview()` to remove the preview altogether. Note that the
// deployment will still exist after you cancel the preview and you must
// separately delete this deployment if you want to remove it.
func (c *DeploymentsPatchCall) Preview(preview bool) *DeploymentsPatchCall {
	c.urlParams_.Set("preview", fmt.Sprint(preview))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DeploymentsPatchCall) Fields(s ...googleapi.Field) *DeploymentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DeploymentsPatchCall) Context(ctx context.Context) *DeploymentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DeploymentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DeploymentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.deployment2)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/deployments/{deployment}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":    c.project,
		"deployment": c.deployment,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.deployments.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DeploymentsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type DeploymentsSetIamPolicyCall struct {
	s                      *Service
	project                string
	resource               string
	globalsetpolicyrequest *GlobalSetPolicyRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy.
//
// - project: Project ID for this request.
// - resource: Name or id of the resource for this request.
func (r *DeploymentsService) SetIamPolicy(project string, resource string, globalsetpolicyrequest *GlobalSetPolicyRequest) *DeploymentsSetIamPolicyCall {
	c := &DeploymentsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.resource = resource
	c.globalsetpolicyrequest = globalsetpolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DeploymentsSetIamPolicyCall) Fields(s ...googleapi.Field) *DeploymentsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DeploymentsSetIamPolicyCall) Context(ctx context.Context) *DeploymentsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DeploymentsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DeploymentsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.globalsetpolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/deployments/{resource}/setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.deployments.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DeploymentsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type DeploymentsStopCall struct {
	s                      *Service
	project                string
	deployment             string
	deploymentsstoprequest *DeploymentsStopRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Stop: Stops an ongoing operation. This does not roll back any work that has
// already been completed, but prevents any new work from being started.
//
// - deployment: The name of the deployment for this request.
// - project: The project ID for this request.
func (r *DeploymentsService) Stop(project string, deployment string, deploymentsstoprequest *DeploymentsStopRequest) *DeploymentsStopCall {
	c := &DeploymentsStopCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.deployment = deployment
	c.deploymentsstoprequest = deploymentsstoprequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DeploymentsStopCall) Fields(s ...googleapi.Field) *DeploymentsStopCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DeploymentsStopCall) Context(ctx context.Context) *DeploymentsStopCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DeploymentsStopCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DeploymentsStopCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.deploymentsstoprequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/deployments/{deployment}/stop")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":    c.project,
		"deployment": c.deployment,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.deployments.stop" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DeploymentsStopCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type DeploymentsTestIamPermissionsCall struct {
	s                      *Service
	project                string
	resource               string
	testpermissionsrequest *TestPermissionsRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource.
//
// - project: Project ID for this request.
// - resource: Name or id of the resource for this request.
func (r *DeploymentsService) TestIamPermissions(project string, resource string, testpermissionsrequest *TestPermissionsRequest) *DeploymentsTestIamPermissionsCall {
	c := &DeploymentsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.resource = resource
	c.testpermissionsrequest = testpermissionsrequest
	return c
}

// HeaderBypassBillingFilter sets the optional parameter
// "header.bypassBillingFilter":
func (c *DeploymentsTestIamPermissionsCall) HeaderBypassBillingFilter(headerBypassBillingFilter bool) *DeploymentsTestIamPermissionsCall {
	c.urlParams_.Set("header.bypassBillingFilter", fmt.Sprint(headerBypassBillingFilter))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DeploymentsTestIamPermissionsCall) Fields(s ...googleapi.Field) *DeploymentsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DeploymentsTestIamPermissionsCall) Context(ctx context.Context) *DeploymentsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DeploymentsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DeploymentsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.testpermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/deployments/{resource}/testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.deployments.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *DeploymentsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type DeploymentsUpdateCall struct {
	s           *Service
	project     string
	deployment  string
	deployment2 *Deployment
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Update: Updates a deployment and all of the resources described by the
// deployment manifest.
//
// - deployment: The name of the deployment for this request.
// - project: The project ID for this request.
func (r *DeploymentsService) Update(project string, deployment string, deployment2 *Deployment) *DeploymentsUpdateCall {
	c := &DeploymentsUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.deployment = deployment
	c.deployment2 = deployment2
	return c
}

// CreatePolicy sets the optional parameter "createPolicy": Sets the policy to
// use for creating new resources.
//
// Possible values:
//
//	"CREATE_OR_ACQUIRE" (default)
//	"ACQUIRE"
//	"CREATE"
func (c *DeploymentsUpdateCall) CreatePolicy(createPolicy string) *DeploymentsUpdateCall {
	c.urlParams_.Set("createPolicy", createPolicy)
	return c
}

// DeletePolicy sets the optional parameter "deletePolicy": Sets the policy to
// use for deleting resources.
//
// Possible values:
//
//	"DELETE" (default)
//	"ABANDON"
func (c *DeploymentsUpdateCall) DeletePolicy(deletePolicy string) *DeploymentsUpdateCall {
	c.urlParams_.Set("deletePolicy", deletePolicy)
	return c
}

// HeaderBypassBillingFilter sets the optional parameter
// "header.bypassBillingFilter":
func (c *DeploymentsUpdateCall) HeaderBypassBillingFilter(headerBypassBillingFilter bool) *DeploymentsUpdateCall {
	c.urlParams_.Set("header.bypassBillingFilter", fmt.Sprint(headerBypassBillingFilter))
	return c
}

// Preview sets the optional parameter "preview": If set to true, updates the
// deployment and creates and updates the "shell" resources but does not
// actually alter or instantiate these resources. This allows you to preview
// what your deployment will look like. You can use this intent to preview how
// an update would affect your deployment. You must provide a `target.config`
// with a configuration if this is set to true. After previewing a deployment,
// you can deploy your resources by making a request with the `update()` or you
// can `cancelPreview()` to remove the preview altogether. Note that the
// deployment will still exist after you cancel the preview and you must
// separately delete this deployment if you want to remove it.
func (c *DeploymentsUpdateCall) Preview(preview bool) *DeploymentsUpdateCall {
	c.urlParams_.Set("preview", fmt.Sprint(preview))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DeploymentsUpdateCall) Fields(s ...googleapi.Field) *DeploymentsUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DeploymentsUpdateCall) Context(ctx context.Context) *DeploymentsUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DeploymentsUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DeploymentsUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.deployment2)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/deployments/{deployment}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":    c.project,
		"deployment": c.deployment,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.deployments.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DeploymentsUpdateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ManifestsGetCall struct {
	s            *Service
	project      string
	deployment   string
	manifest     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a specific manifest.
//
// - deployment: The name of the deployment for this request.
// - manifest: The name of the manifest for this request.
// - project: The project ID for this request.
func (r *ManifestsService) Get(project string, deployment string, manifest string) *ManifestsGetCall {
	c := &ManifestsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.deployment = deployment
	c.manifest = manifest
	return c
}

// HeaderBypassBillingFilter sets the optional parameter
// "header.bypassBillingFilter":
func (c *ManifestsGetCall) HeaderBypassBillingFilter(headerBypassBillingFilter bool) *ManifestsGetCall {
	c.urlParams_.Set("header.bypassBillingFilter", fmt.Sprint(headerBypassBillingFilter))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ManifestsGetCall) Fields(s ...googleapi.Field) *ManifestsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ManifestsGetCall) IfNoneMatch(entityTag string) *ManifestsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ManifestsGetCall) Context(ctx context.Context) *ManifestsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ManifestsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ManifestsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/deployments/{deployment}/manifests/{manifest}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":    c.project,
		"deployment": c.deployment,
		"manifest":   c.manifest,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.manifests.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Manifest.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ManifestsGetCall) Do(opts ...googleapi.CallOption) (*Manifest, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Manifest{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ManifestsListCall struct {
	s            *Service
	project      string
	deployment   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all manifests for a given deployment.
//
// - deployment: The name of the deployment for this request.
// - project: The project ID for this request.
func (r *ManifestsService) List(project string, deployment string) *ManifestsListCall {
	c := &ManifestsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.deployment = deployment
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most Compute resources support two
// types of filter expressions: expressions that support regular expressions
// and expressions that follow API improvement proposal AIP-160. These two
// types of filter expressions cannot be mixed in one request. If you want to
// use AIP-160, your expression must specify the field name, an operator, and
// the value that you want to use for filtering. The value must be a string, a
// number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`,
// `>=` or `:`. For example, if you are filtering Compute Engine instances, you
// can exclude instances named `example-instance` by specifying `name !=
// example-instance`. The `:*` comparison can be used to test whether a key has
// been defined. For example, to find all objects with `owner` label use: ```
// labels.owner:* ``` You can also filter nested fields. For example, you could
// specify `scheduling.automaticRestart = false` to include instances only if
// they are not scheduled for automatic restarts. You can use filtering on
// nested fields to filter based on resource labels. To filter on multiple
// expressions, provide each separate expression within parentheses. For
// example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
// Skylake") ``` By default, each expression is an `AND` expression. However,
// you can include `AND` and `OR` expressions explicitly. For example: ```
// (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true) ``` If you want to use a regular
// expression, use the `eq` (equal) or `ne` (not equal) operator against a
// single un-parenthesized expression with or without quotes or against
// multiple parenthesized expressions. Examples: `fieldname eq unquoted
// literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted
// literal" `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal
// value is interpreted as a regular expression using Google RE2 library
// syntax. The literal value must match the entire field. For example, to
// filter for instances that do not end with name "instance", you would use
// `name ne .*instance`. You cannot combine constraints on multiple fields
// using regular expressions.
func (c *ManifestsListCall) Filter(filter string) *ManifestsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned. If the number of available results
// is larger than `maxResults`, Compute Engine returns a `nextPageToken` that
// can be used to get the next page of results in subsequent list requests.
// Acceptable values are `0` to `500`, inclusive. (Default: `500`)
func (c *ManifestsListCall) MaxResults(maxResults int64) *ManifestsListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results are returned in alphanumerical order
// based on the resource name. You can also sort results in descending order
// based on the creation timestamp using `orderBy="creationTimestamp desc".
// This sorts results based on the `creationTimestamp` field in reverse
// chronological order (newest result first). Use this to sort resources like
// operations so that the newest operation is returned first. Currently, only
// sorting by `name` or `creationTimestamp desc` is supported.
func (c *ManifestsListCall) OrderBy(orderBy string) *ManifestsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the `nextPageToken` returned by a previous list
// request to get the next page of results.
func (c *ManifestsListCall) PageToken(pageToken string) *ManifestsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ManifestsListCall) Fields(s ...googleapi.Field) *ManifestsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ManifestsListCall) IfNoneMatch(entityTag string) *ManifestsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ManifestsListCall) Context(ctx context.Context) *ManifestsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ManifestsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ManifestsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/deployments/{deployment}/manifests")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":    c.project,
		"deployment": c.deployment,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.manifests.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ManifestsListResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ManifestsListCall) Do(opts ...googleapi.CallOption) (*ManifestsListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ManifestsListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ManifestsListCall) Pages(ctx context.Context, f func(*ManifestsListResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OperationsGetCall struct {
	s            *Service
	project      string
	operation    string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a specific operation.
//
// - operation: The name of the operation for this request.
// - project: The project ID for this request.
func (r *OperationsService) Get(project string, operation string) *OperationsGetCall {
	c := &OperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.operation = operation
	return c
}

// HeaderBypassBillingFilter sets the optional parameter
// "header.bypassBillingFilter":
func (c *OperationsGetCall) HeaderBypassBillingFilter(headerBypassBillingFilter bool) *OperationsGetCall {
	c.urlParams_.Set("header.bypassBillingFilter", fmt.Sprint(headerBypassBillingFilter))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OperationsGetCall) Fields(s ...googleapi.Field) *OperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OperationsGetCall) IfNoneMatch(entityTag string) *OperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OperationsGetCall) Context(ctx context.Context) *OperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/operations/{operation}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":   c.project,
		"operation": c.operation,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type OperationsListCall struct {
	s            *Service
	project      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all operations for a project.
//
// - project: The project ID for this request.
func (r *OperationsService) List(project string) *OperationsListCall {
	c := &OperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most Compute resources support two
// types of filter expressions: expressions that support regular expressions
// and expressions that follow API improvement proposal AIP-160. These two
// types of filter expressions cannot be mixed in one request. If you want to
// use AIP-160, your expression must specify the field name, an operator, and
// the value that you want to use for filtering. The value must be a string, a
// number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`,
// `>=` or `:`. For example, if you are filtering Compute Engine instances, you
// can exclude instances named `example-instance` by specifying `name !=
// example-instance`. The `:*` comparison can be used to test whether a key has
// been defined. For example, to find all objects with `owner` label use: ```
// labels.owner:* ``` You can also filter nested fields. For example, you could
// specify `scheduling.automaticRestart = false` to include instances only if
// they are not scheduled for automatic restarts. You can use filtering on
// nested fields to filter based on resource labels. To filter on multiple
// expressions, provide each separate expression within parentheses. For
// example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
// Skylake") ``` By default, each expression is an `AND` expression. However,
// you can include `AND` and `OR` expressions explicitly. For example: ```
// (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true) ``` If you want to use a regular
// expression, use the `eq` (equal) or `ne` (not equal) operator against a
// single un-parenthesized expression with or without quotes or against
// multiple parenthesized expressions. Examples: `fieldname eq unquoted
// literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted
// literal" `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal
// value is interpreted as a regular expression using Google RE2 library
// syntax. The literal value must match the entire field. For example, to
// filter for instances that do not end with name "instance", you would use
// `name ne .*instance`. You cannot combine constraints on multiple fields
// using regular expressions.
func (c *OperationsListCall) Filter(filter string) *OperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned. If the number of available results
// is larger than `maxResults`, Compute Engine returns a `nextPageToken` that
// can be used to get the next page of results in subsequent list requests.
// Acceptable values are `0` to `500`, inclusive. (Default: `500`)
func (c *OperationsListCall) MaxResults(maxResults int64) *OperationsListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results are returned in alphanumerical order
// based on the resource name. You can also sort results in descending order
// based on the creation timestamp using `orderBy="creationTimestamp desc".
// This sorts results based on the `creationTimestamp` field in reverse
// chronological order (newest result first). Use this to sort resources like
// operations so that the newest operation is returned first. Currently, only
// sorting by `name` or `creationTimestamp desc` is supported.
func (c *OperationsListCall) OrderBy(orderBy string) *OperationsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the `nextPageToken` returned by a previous list
// request to get the next page of results.
func (c *OperationsListCall) PageToken(pageToken string) *OperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OperationsListCall) Fields(s ...googleapi.Field) *OperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OperationsListCall) IfNoneMatch(entityTag string) *OperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OperationsListCall) Context(ctx context.Context) *OperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *OperationsListResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OperationsListCall) Do(opts ...googleapi.CallOption) (*OperationsListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OperationsListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OperationsListCall) Pages(ctx context.Context, f func(*OperationsListResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ResourcesGetCall struct {
	s            *Service
	project      string
	deployment   string
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a single resource.
//
// - deployment: The name of the deployment for this request.
// - project: The project ID for this request.
// - resource: The name of the resource for this request.
func (r *ResourcesService) Get(project string, deployment string, resource string) *ResourcesGetCall {
	c := &ResourcesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.deployment = deployment
	c.resource = resource
	return c
}

// HeaderBypassBillingFilter sets the optional parameter
// "header.bypassBillingFilter":
func (c *ResourcesGetCall) HeaderBypassBillingFilter(headerBypassBillingFilter bool) *ResourcesGetCall {
	c.urlParams_.Set("header.bypassBillingFilter", fmt.Sprint(headerBypassBillingFilter))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ResourcesGetCall) Fields(s ...googleapi.Field) *ResourcesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ResourcesGetCall) IfNoneMatch(entityTag string) *ResourcesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ResourcesGetCall) Context(ctx context.Context) *ResourcesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ResourcesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ResourcesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/deployments/{deployment}/resources/{resource}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":    c.project,
		"deployment": c.deployment,
		"resource":   c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.resources.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Resource.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ResourcesGetCall) Do(opts ...googleapi.CallOption) (*Resource, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Resource{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ResourcesListCall struct {
	s            *Service
	project      string
	deployment   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all resources in a given deployment.
//
// - deployment: The name of the deployment for this request.
// - project: The project ID for this request.
func (r *ResourcesService) List(project string, deployment string) *ResourcesListCall {
	c := &ResourcesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.deployment = deployment
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most Compute resources support two
// types of filter expressions: expressions that support regular expressions
// and expressions that follow API improvement proposal AIP-160. These two
// types of filter expressions cannot be mixed in one request. If you want to
// use AIP-160, your expression must specify the field name, an operator, and
// the value that you want to use for filtering. The value must be a string, a
// number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`,
// `>=` or `:`. For example, if you are filtering Compute Engine instances, you
// can exclude instances named `example-instance` by specifying `name !=
// example-instance`. The `:*` comparison can be used to test whether a key has
// been defined. For example, to find all objects with `owner` label use: ```
// labels.owner:* ``` You can also filter nested fields. For example, you could
// specify `scheduling.automaticRestart = false` to include instances only if
// they are not scheduled for automatic restarts. You can use filtering on
// nested fields to filter based on resource labels. To filter on multiple
// expressions, provide each separate expression within parentheses. For
// example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
// Skylake") ``` By default, each expression is an `AND` expression. However,
// you can include `AND` and `OR` expressions explicitly. For example: ```
// (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true) ``` If you want to use a regular
// expression, use the `eq` (equal) or `ne` (not equal) operator against a
// single un-parenthesized expression with or without quotes or against
// multiple parenthesized expressions. Examples: `fieldname eq unquoted
// literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted
// literal" `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal
// value is interpreted as a regular expression using Google RE2 library
// syntax. The literal value must match the entire field. For example, to
// filter for instances that do not end with name "instance", you would use
// `name ne .*instance`. You cannot combine constraints on multiple fields
// using regular expressions.
func (c *ResourcesListCall) Filter(filter string) *ResourcesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned. If the number of available results
// is larger than `maxResults`, Compute Engine returns a `nextPageToken` that
// can be used to get the next page of results in subsequent list requests.
// Acceptable values are `0` to `500`, inclusive. (Default: `500`)
func (c *ResourcesListCall) MaxResults(maxResults int64) *ResourcesListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results are returned in alphanumerical order
// based on the resource name. You can also sort results in descending order
// based on the creation timestamp using `orderBy="creationTimestamp desc".
// This sorts results based on the `creationTimestamp` field in reverse
// chronological order (newest result first). Use this to sort resources like
// operations so that the newest operation is returned first. Currently, only
// sorting by `name` or `creationTimestamp desc` is supported.
func (c *ResourcesListCall) OrderBy(orderBy string) *ResourcesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the `nextPageToken` returned by a previous list
// request to get the next page of results.
func (c *ResourcesListCall) PageToken(pageToken string) *ResourcesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ResourcesListCall) Fields(s ...googleapi.Field) *ResourcesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ResourcesListCall) IfNoneMatch(entityTag string) *ResourcesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ResourcesListCall) Context(ctx context.Context) *ResourcesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ResourcesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ResourcesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/deployments/{deployment}/resources")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":    c.project,
		"deployment": c.deployment,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.resources.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ResourcesListResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ResourcesListCall) Do(opts ...googleapi.CallOption) (*ResourcesListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ResourcesListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ResourcesListCall) Pages(ctx context.Context, f func(*ResourcesListResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type TypeProvidersDeleteCall struct {
	s            *Service
	project      string
	typeProvider string
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Delete: Deletes a type provider.
//
// - project: The project ID for this request.
// - typeProvider: The name of the type provider for this request.
func (r *TypeProvidersService) Delete(project string, typeProvider string) *TypeProvidersDeleteCall {
	c := &TypeProvidersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.typeProvider = typeProvider
	return c
}

// HeaderBypassBillingFilter sets the optional parameter
// "header.bypassBillingFilter":
func (c *TypeProvidersDeleteCall) HeaderBypassBillingFilter(headerBypassBillingFilter bool) *TypeProvidersDeleteCall {
	c.urlParams_.Set("header.bypassBillingFilter", fmt.Sprint(headerBypassBillingFilter))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TypeProvidersDeleteCall) Fields(s ...googleapi.Field) *TypeProvidersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TypeProvidersDeleteCall) Context(ctx context.Context) *TypeProvidersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TypeProvidersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TypeProvidersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/typeProviders/{typeProvider}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":      c.project,
		"typeProvider": c.typeProvider,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.typeProviders.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TypeProvidersDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TypeProvidersGetCall struct {
	s            *Service
	project      string
	typeProvider string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a specific type provider.
//
// - project: The project ID for this request.
// - typeProvider: The name of the type provider for this request.
func (r *TypeProvidersService) Get(project string, typeProvider string) *TypeProvidersGetCall {
	c := &TypeProvidersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.typeProvider = typeProvider
	return c
}

// HeaderBypassBillingFilter sets the optional parameter
// "header.bypassBillingFilter":
func (c *TypeProvidersGetCall) HeaderBypassBillingFilter(headerBypassBillingFilter bool) *TypeProvidersGetCall {
	c.urlParams_.Set("header.bypassBillingFilter", fmt.Sprint(headerBypassBillingFilter))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TypeProvidersGetCall) Fields(s ...googleapi.Field) *TypeProvidersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *TypeProvidersGetCall) IfNoneMatch(entityTag string) *TypeProvidersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TypeProvidersGetCall) Context(ctx context.Context) *TypeProvidersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TypeProvidersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TypeProvidersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/typeProviders/{typeProvider}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":      c.project,
		"typeProvider": c.typeProvider,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.typeProviders.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *TypeProvider.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TypeProvidersGetCall) Do(opts ...googleapi.CallOption) (*TypeProvider, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TypeProvider{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TypeProvidersGetTypeCall struct {
	s            *Service
	project      string
	typeProvider string
	type_        string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetType: Gets a type info for a type provided by a TypeProvider.
//
// - project: The project ID for this request.
// - type: The name of the type provider type for this request.
// - typeProvider: The name of the type provider for this request.
func (r *TypeProvidersService) GetType(project string, typeProvider string, type_ string) *TypeProvidersGetTypeCall {
	c := &TypeProvidersGetTypeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.typeProvider = typeProvider
	c.type_ = type_
	return c
}

// HeaderBypassBillingFilter sets the optional parameter
// "header.bypassBillingFilter":
func (c *TypeProvidersGetTypeCall) HeaderBypassBillingFilter(headerBypassBillingFilter bool) *TypeProvidersGetTypeCall {
	c.urlParams_.Set("header.bypassBillingFilter", fmt.Sprint(headerBypassBillingFilter))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TypeProvidersGetTypeCall) Fields(s ...googleapi.Field) *TypeProvidersGetTypeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *TypeProvidersGetTypeCall) IfNoneMatch(entityTag string) *TypeProvidersGetTypeCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TypeProvidersGetTypeCall) Context(ctx context.Context) *TypeProvidersGetTypeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TypeProvidersGetTypeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TypeProvidersGetTypeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/typeProviders/{typeProvider}/types/{type}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":      c.project,
		"typeProvider": c.typeProvider,
		"type":         c.type_,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.typeProviders.getType" call.
// Any non-2xx status code is an error. Response headers are in either
// *TypeInfo.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TypeProvidersGetTypeCall) Do(opts ...googleapi.CallOption) (*TypeInfo, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TypeInfo{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TypeProvidersInsertCall struct {
	s            *Service
	project      string
	typeprovider *TypeProvider
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Insert: Creates a type provider.
//
// - project: The project ID for this request.
func (r *TypeProvidersService) Insert(project string, typeprovider *TypeProvider) *TypeProvidersInsertCall {
	c := &TypeProvidersInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.typeprovider = typeprovider
	return c
}

// HeaderBypassBillingFilter sets the optional parameter
// "header.bypassBillingFilter":
func (c *TypeProvidersInsertCall) HeaderBypassBillingFilter(headerBypassBillingFilter bool) *TypeProvidersInsertCall {
	c.urlParams_.Set("header.bypassBillingFilter", fmt.Sprint(headerBypassBillingFilter))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TypeProvidersInsertCall) Fields(s ...googleapi.Field) *TypeProvidersInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TypeProvidersInsertCall) Context(ctx context.Context) *TypeProvidersInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TypeProvidersInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TypeProvidersInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.typeprovider)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/typeProviders")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.typeProviders.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TypeProvidersInsertCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TypeProvidersListCall struct {
	s            *Service
	project      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all resource type providers for Deployment Manager.
//
// - project: The project ID for this request.
func (r *TypeProvidersService) List(project string) *TypeProvidersListCall {
	c := &TypeProvidersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most Compute resources support two
// types of filter expressions: expressions that support regular expressions
// and expressions that follow API improvement proposal AIP-160. These two
// types of filter expressions cannot be mixed in one request. If you want to
// use AIP-160, your expression must specify the field name, an operator, and
// the value that you want to use for filtering. The value must be a string, a
// number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`,
// `>=` or `:`. For example, if you are filtering Compute Engine instances, you
// can exclude instances named `example-instance` by specifying `name !=
// example-instance`. The `:*` comparison can be used to test whether a key has
// been defined. For example, to find all objects with `owner` label use: ```
// labels.owner:* ``` You can also filter nested fields. For example, you could
// specify `scheduling.automaticRestart = false` to include instances only if
// they are not scheduled for automatic restarts. You can use filtering on
// nested fields to filter based on resource labels. To filter on multiple
// expressions, provide each separate expression within parentheses. For
// example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
// Skylake") ``` By default, each expression is an `AND` expression. However,
// you can include `AND` and `OR` expressions explicitly. For example: ```
// (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true) ``` If you want to use a regular
// expression, use the `eq` (equal) or `ne` (not equal) operator against a
// single un-parenthesized expression with or without quotes or against
// multiple parenthesized expressions. Examples: `fieldname eq unquoted
// literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted
// literal" `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal
// value is interpreted as a regular expression using Google RE2 library
// syntax. The literal value must match the entire field. For example, to
// filter for instances that do not end with name "instance", you would use
// `name ne .*instance`. You cannot combine constraints on multiple fields
// using regular expressions.
func (c *TypeProvidersListCall) Filter(filter string) *TypeProvidersListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned. If the number of available results
// is larger than `maxResults`, Compute Engine returns a `nextPageToken` that
// can be used to get the next page of results in subsequent list requests.
// Acceptable values are `0` to `500`, inclusive. (Default: `500`)
func (c *TypeProvidersListCall) MaxResults(maxResults int64) *TypeProvidersListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results are returned in alphanumerical order
// based on the resource name. You can also sort results in descending order
// based on the creation timestamp using `orderBy="creationTimestamp desc".
// This sorts results based on the `creationTimestamp` field in reverse
// chronological order (newest result first). Use this to sort resources like
// operations so that the newest operation is returned first. Currently, only
// sorting by `name` or `creationTimestamp desc` is supported.
func (c *TypeProvidersListCall) OrderBy(orderBy string) *TypeProvidersListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the `nextPageToken` returned by a previous list
// request to get the next page of results.
func (c *TypeProvidersListCall) PageToken(pageToken string) *TypeProvidersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TypeProvidersListCall) Fields(s ...googleapi.Field) *TypeProvidersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *TypeProvidersListCall) IfNoneMatch(entityTag string) *TypeProvidersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TypeProvidersListCall) Context(ctx context.Context) *TypeProvidersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TypeProvidersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TypeProvidersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/typeProviders")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.typeProviders.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *TypeProvidersListResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *TypeProvidersListCall) Do(opts ...googleapi.CallOption) (*TypeProvidersListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TypeProvidersListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *TypeProvidersListCall) Pages(ctx context.Context, f func(*TypeProvidersListResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type TypeProvidersListTypesCall struct {
	s            *Service
	project      string
	typeProvider string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListTypes: Lists all the type info for a TypeProvider.
//
// - project: The project ID for this request.
// - typeProvider: The name of the type provider for this request.
func (r *TypeProvidersService) ListTypes(project string, typeProvider string) *TypeProvidersListTypesCall {
	c := &TypeProvidersListTypesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.typeProvider = typeProvider
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most Compute resources support two
// types of filter expressions: expressions that support regular expressions
// and expressions that follow API improvement proposal AIP-160. These two
// types of filter expressions cannot be mixed in one request. If you want to
// use AIP-160, your expression must specify the field name, an operator, and
// the value that you want to use for filtering. The value must be a string, a
// number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`,
// `>=` or `:`. For example, if you are filtering Compute Engine instances, you
// can exclude instances named `example-instance` by specifying `name !=
// example-instance`. The `:*` comparison can be used to test whether a key has
// been defined. For example, to find all objects with `owner` label use: ```
// labels.owner:* ``` You can also filter nested fields. For example, you could
// specify `scheduling.automaticRestart = false` to include instances only if
// they are not scheduled for automatic restarts. You can use filtering on
// nested fields to filter based on resource labels. To filter on multiple
// expressions, provide each separate expression within parentheses. For
// example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
// Skylake") ``` By default, each expression is an `AND` expression. However,
// you can include `AND` and `OR` expressions explicitly. For example: ```
// (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true) ``` If you want to use a regular
// expression, use the `eq` (equal) or `ne` (not equal) operator against a
// single un-parenthesized expression with or without quotes or against
// multiple parenthesized expressions. Examples: `fieldname eq unquoted
// literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted
// literal" `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal
// value is interpreted as a regular expression using Google RE2 library
// syntax. The literal value must match the entire field. For example, to
// filter for instances that do not end with name "instance", you would use
// `name ne .*instance`. You cannot combine constraints on multiple fields
// using regular expressions.
func (c *TypeProvidersListTypesCall) Filter(filter string) *TypeProvidersListTypesCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned. If the number of available results
// is larger than `maxResults`, Compute Engine returns a `nextPageToken` that
// can be used to get the next page of results in subsequent list requests.
// Acceptable values are `0` to `500`, inclusive. (Default: `500`)
func (c *TypeProvidersListTypesCall) MaxResults(maxResults int64) *TypeProvidersListTypesCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results are returned in alphanumerical order
// based on the resource name. You can also sort results in descending order
// based on the creation timestamp using `orderBy="creationTimestamp desc".
// This sorts results based on the `creationTimestamp` field in reverse
// chronological order (newest result first). Use this to sort resources like
// operations so that the newest operation is returned first. Currently, only
// sorting by `name` or `creationTimestamp desc` is supported.
func (c *TypeProvidersListTypesCall) OrderBy(orderBy string) *TypeProvidersListTypesCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the `nextPageToken` returned by a previous list
// request to get the next page of results.
func (c *TypeProvidersListTypesCall) PageToken(pageToken string) *TypeProvidersListTypesCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TypeProvidersListTypesCall) Fields(s ...googleapi.Field) *TypeProvidersListTypesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *TypeProvidersListTypesCall) IfNoneMatch(entityTag string) *TypeProvidersListTypesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TypeProvidersListTypesCall) Context(ctx context.Context) *TypeProvidersListTypesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TypeProvidersListTypesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TypeProvidersListTypesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/typeProviders/{typeProvider}/types")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":      c.project,
		"typeProvider": c.typeProvider,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.typeProviders.listTypes" call.
// Any non-2xx status code is an error. Response headers are in either
// *TypeProvidersListTypesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *TypeProvidersListTypesCall) Do(opts ...googleapi.CallOption) (*TypeProvidersListTypesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TypeProvidersListTypesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *TypeProvidersListTypesCall) Pages(ctx context.Context, f func(*TypeProvidersListTypesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type TypeProvidersPatchCall struct {
	s            *Service
	project      string
	typeProvider string
	typeprovider *TypeProvider
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Patch: Patches a type provider.
//
// - project: The project ID for this request.
// - typeProvider: The name of the type provider for this request.
func (r *TypeProvidersService) Patch(project string, typeProvider string, typeprovider *TypeProvider) *TypeProvidersPatchCall {
	c := &TypeProvidersPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.typeProvider = typeProvider
	c.typeprovider = typeprovider
	return c
}

// HeaderBypassBillingFilter sets the optional parameter
// "header.bypassBillingFilter":
func (c *TypeProvidersPatchCall) HeaderBypassBillingFilter(headerBypassBillingFilter bool) *TypeProvidersPatchCall {
	c.urlParams_.Set("header.bypassBillingFilter", fmt.Sprint(headerBypassBillingFilter))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TypeProvidersPatchCall) Fields(s ...googleapi.Field) *TypeProvidersPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TypeProvidersPatchCall) Context(ctx context.Context) *TypeProvidersPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TypeProvidersPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TypeProvidersPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.typeprovider)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/typeProviders/{typeProvider}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":      c.project,
		"typeProvider": c.typeProvider,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.typeProviders.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TypeProvidersPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TypeProvidersUpdateCall struct {
	s            *Service
	project      string
	typeProvider string
	typeprovider *TypeProvider
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Update: Updates a type provider.
//
// - project: The project ID for this request.
// - typeProvider: The name of the type provider for this request.
func (r *TypeProvidersService) Update(project string, typeProvider string, typeprovider *TypeProvider) *TypeProvidersUpdateCall {
	c := &TypeProvidersUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.typeProvider = typeProvider
	c.typeprovider = typeprovider
	return c
}

// HeaderBypassBillingFilter sets the optional parameter
// "header.bypassBillingFilter":
func (c *TypeProvidersUpdateCall) HeaderBypassBillingFilter(headerBypassBillingFilter bool) *TypeProvidersUpdateCall {
	c.urlParams_.Set("header.bypassBillingFilter", fmt.Sprint(headerBypassBillingFilter))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TypeProvidersUpdateCall) Fields(s ...googleapi.Field) *TypeProvidersUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TypeProvidersUpdateCall) Context(ctx context.Context) *TypeProvidersUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TypeProvidersUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TypeProvidersUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.typeprovider)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/typeProviders/{typeProvider}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":      c.project,
		"typeProvider": c.typeProvider,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.typeProviders.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TypeProvidersUpdateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TypesListCall struct {
	s            *Service
	project      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all resource types for Deployment Manager.
//
// - project: The project ID for this request.
func (r *TypesService) List(project string) *TypesListCall {
	c := &TypesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most Compute resources support two
// types of filter expressions: expressions that support regular expressions
// and expressions that follow API improvement proposal AIP-160. These two
// types of filter expressions cannot be mixed in one request. If you want to
// use AIP-160, your expression must specify the field name, an operator, and
// the value that you want to use for filtering. The value must be a string, a
// number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`,
// `>=` or `:`. For example, if you are filtering Compute Engine instances, you
// can exclude instances named `example-instance` by specifying `name !=
// example-instance`. The `:*` comparison can be used to test whether a key has
// been defined. For example, to find all objects with `owner` label use: ```
// labels.owner:* ``` You can also filter nested fields. For example, you could
// specify `scheduling.automaticRestart = false` to include instances only if
// they are not scheduled for automatic restarts. You can use filtering on
// nested fields to filter based on resource labels. To filter on multiple
// expressions, provide each separate expression within parentheses. For
// example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
// Skylake") ``` By default, each expression is an `AND` expression. However,
// you can include `AND` and `OR` expressions explicitly. For example: ```
// (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true) ``` If you want to use a regular
// expression, use the `eq` (equal) or `ne` (not equal) operator against a
// single un-parenthesized expression with or without quotes or against
// multiple parenthesized expressions. Examples: `fieldname eq unquoted
// literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted
// literal" `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal
// value is interpreted as a regular expression using Google RE2 library
// syntax. The literal value must match the entire field. For example, to
// filter for instances that do not end with name "instance", you would use
// `name ne .*instance`. You cannot combine constraints on multiple fields
// using regular expressions.
func (c *TypesListCall) Filter(filter string) *TypesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned. If the number of available results
// is larger than `maxResults`, Compute Engine returns a `nextPageToken` that
// can be used to get the next page of results in subsequent list requests.
// Acceptable values are `0` to `500`, inclusive. (Default: `500`)
func (c *TypesListCall) MaxResults(maxResults int64) *TypesListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results are returned in alphanumerical order
// based on the resource name. You can also sort results in descending order
// based on the creation timestamp using `orderBy="creationTimestamp desc".
// This sorts results based on the `creationTimestamp` field in reverse
// chronological order (newest result first). Use this to sort resources like
// operations so that the newest operation is returned first. Currently, only
// sorting by `name` or `creationTimestamp desc` is supported.
func (c *TypesListCall) OrderBy(orderBy string) *TypesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the `nextPageToken` returned by a previous list
// request to get the next page of results.
func (c *TypesListCall) PageToken(pageToken string) *TypesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TypesListCall) Fields(s ...googleapi.Field) *TypesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *TypesListCall) IfNoneMatch(entityTag string) *TypesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TypesListCall) Context(ctx context.Context) *TypesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TypesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TypesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "deploymentmanager/v2beta/projects/{project}/global/types")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "deploymentmanager.types.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *TypesListResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *TypesListCall) Do(opts ...googleapi.CallOption) (*TypesListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TypesListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *TypesListCall) Pages(ctx context.Context, f func(*TypesListResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
