// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcommon "go.opentelemetry.io/proto/slim/otlp/common/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyKeyValueList(t *testing.T) {
	for name, src := range genTestEncodingValuesKeyValueList() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewKeyValueList()
				CopyKeyValueList(dest, src)
				assert.Equal(t, src, dest)
				CopyKeyValueList(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyKeyValueListSlice(t *testing.T) {
	src := []KeyValueList{}
	dest := []KeyValueList{}
	// Test CopyTo empty
	dest = CopyKeyValueListSlice(dest, src)
	assert.Equal(t, []KeyValueList{}, dest)

	// Test CopyTo larger slice
	src = GenTestKeyValueListSlice()
	dest = CopyKeyValueListSlice(dest, src)
	assert.Equal(t, GenTestKeyValueListSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyKeyValueListSlice(dest, src)
	assert.Equal(t, GenTestKeyValueListSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyKeyValueListSlice(dest, []KeyValueList{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyKeyValueListSlice(dest, src)
	assert.Equal(t, GenTestKeyValueListSlice(), dest)
}

func TestCopyKeyValueListPtrSlice(t *testing.T) {
	src := []*KeyValueList{}
	dest := []*KeyValueList{}
	// Test CopyTo empty
	dest = CopyKeyValueListPtrSlice(dest, src)
	assert.Equal(t, []*KeyValueList{}, dest)

	// Test CopyTo larger slice
	src = GenTestKeyValueListPtrSlice()
	dest = CopyKeyValueListPtrSlice(dest, src)
	assert.Equal(t, GenTestKeyValueListPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyKeyValueListPtrSlice(dest, src)
	assert.Equal(t, GenTestKeyValueListPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyKeyValueListPtrSlice(dest, []*KeyValueList{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyKeyValueListPtrSlice(dest, src)
	assert.Equal(t, GenTestKeyValueListPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONKeyValueListUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewKeyValueList()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewKeyValueList(), dest)
}

func TestMarshalAndUnmarshalJSONKeyValueList(t *testing.T) {
	for name, src := range genTestEncodingValuesKeyValueList() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewKeyValueList()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteKeyValueList(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoKeyValueListFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesKeyValueList() {
		t.Run(name, func(t *testing.T) {
			dest := NewKeyValueList()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoKeyValueListUnknown(t *testing.T) {
	dest := NewKeyValueList()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewKeyValueList(), dest)
}

func TestMarshalAndUnmarshalProtoKeyValueList(t *testing.T) {
	for name, src := range genTestEncodingValuesKeyValueList() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewKeyValueList()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteKeyValueList(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufKeyValueList(t *testing.T) {
	for name, src := range genTestEncodingValuesKeyValueList() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcommon.KeyValueList{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewKeyValueList()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesKeyValueList() map[string][]byte {
	return map[string][]byte{
		"invalid_field":          {0x02},
		"Values/wrong_wire_type": {0xc},
		"Values/missing_value":   {0xa},
	}
}

func genTestEncodingValuesKeyValueList() map[string]*KeyValueList {
	return map[string]*KeyValueList{
		"empty":       NewKeyValueList(),
		"Values/test": {Values: []KeyValue{{}, *GenTestKeyValue()}},
	}
}
