// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package vulnerabilityscanning

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListHostScanRecipesRequest wrapper for the ListHostScanRecipes operation
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListHostScanRecipes.go.html to see an example of how to use ListHostScanRecipesRequest.
type ListHostScanRecipesRequest struct {

	// The ID of the compartment in which to list resources.
	CompartmentId *string `mandatory:"true" contributesTo:"query" name:"compartmentId"`

	// A filter to return only resources whose lifecycleState matches the given lifecycleState.
	LifecycleState ListHostScanRecipesLifecycleStateEnum `mandatory:"false" contributesTo:"query" name:"lifecycleState" omitEmpty:"true"`

	// A filter to return only resources that match the entire display name given.
	DisplayName *string `mandatory:"false" contributesTo:"query" name:"displayName"`

	// The maximum number of items to return.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// The sort order to use, either 'ASC' or 'DESC'.
	SortOrder ListHostScanRecipesSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending. If no value is specified timeCreated is default.
	SortBy ListHostScanRecipesSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// The client request ID for tracing.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListHostScanRecipesRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListHostScanRecipesRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListHostScanRecipesRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListHostScanRecipesRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListHostScanRecipesRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingListHostScanRecipesLifecycleStateEnum(string(request.LifecycleState)); !ok && request.LifecycleState != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleState: %s. Supported values are: %s.", request.LifecycleState, strings.Join(GetListHostScanRecipesLifecycleStateEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListHostScanRecipesSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListHostScanRecipesSortOrderEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListHostScanRecipesSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListHostScanRecipesSortByEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListHostScanRecipesResponse wrapper for the ListHostScanRecipes operation
type ListHostScanRecipesResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of HostScanRecipeSummaryCollection instances
	HostScanRecipeSummaryCollection `presentIn:"body"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then a partial list might have been returned. Include this value as the `page` parameter for the
	// subsequent GET request to get the next batch of items.
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`
}

func (response ListHostScanRecipesResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListHostScanRecipesResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListHostScanRecipesLifecycleStateEnum Enum with underlying type: string
type ListHostScanRecipesLifecycleStateEnum string

// Set of constants representing the allowable values for ListHostScanRecipesLifecycleStateEnum
const (
	ListHostScanRecipesLifecycleStateCreating ListHostScanRecipesLifecycleStateEnum = "CREATING"
	ListHostScanRecipesLifecycleStateUpdating ListHostScanRecipesLifecycleStateEnum = "UPDATING"
	ListHostScanRecipesLifecycleStateActive   ListHostScanRecipesLifecycleStateEnum = "ACTIVE"
	ListHostScanRecipesLifecycleStateDeleting ListHostScanRecipesLifecycleStateEnum = "DELETING"
	ListHostScanRecipesLifecycleStateDeleted  ListHostScanRecipesLifecycleStateEnum = "DELETED"
	ListHostScanRecipesLifecycleStateFailed   ListHostScanRecipesLifecycleStateEnum = "FAILED"
)

var mappingListHostScanRecipesLifecycleStateEnum = map[string]ListHostScanRecipesLifecycleStateEnum{
	"CREATING": ListHostScanRecipesLifecycleStateCreating,
	"UPDATING": ListHostScanRecipesLifecycleStateUpdating,
	"ACTIVE":   ListHostScanRecipesLifecycleStateActive,
	"DELETING": ListHostScanRecipesLifecycleStateDeleting,
	"DELETED":  ListHostScanRecipesLifecycleStateDeleted,
	"FAILED":   ListHostScanRecipesLifecycleStateFailed,
}

var mappingListHostScanRecipesLifecycleStateEnumLowerCase = map[string]ListHostScanRecipesLifecycleStateEnum{
	"creating": ListHostScanRecipesLifecycleStateCreating,
	"updating": ListHostScanRecipesLifecycleStateUpdating,
	"active":   ListHostScanRecipesLifecycleStateActive,
	"deleting": ListHostScanRecipesLifecycleStateDeleting,
	"deleted":  ListHostScanRecipesLifecycleStateDeleted,
	"failed":   ListHostScanRecipesLifecycleStateFailed,
}

// GetListHostScanRecipesLifecycleStateEnumValues Enumerates the set of values for ListHostScanRecipesLifecycleStateEnum
func GetListHostScanRecipesLifecycleStateEnumValues() []ListHostScanRecipesLifecycleStateEnum {
	values := make([]ListHostScanRecipesLifecycleStateEnum, 0)
	for _, v := range mappingListHostScanRecipesLifecycleStateEnum {
		values = append(values, v)
	}
	return values
}

// GetListHostScanRecipesLifecycleStateEnumStringValues Enumerates the set of values in String for ListHostScanRecipesLifecycleStateEnum
func GetListHostScanRecipesLifecycleStateEnumStringValues() []string {
	return []string{
		"CREATING",
		"UPDATING",
		"ACTIVE",
		"DELETING",
		"DELETED",
		"FAILED",
	}
}

// GetMappingListHostScanRecipesLifecycleStateEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHostScanRecipesLifecycleStateEnum(val string) (ListHostScanRecipesLifecycleStateEnum, bool) {
	enum, ok := mappingListHostScanRecipesLifecycleStateEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListHostScanRecipesSortOrderEnum Enum with underlying type: string
type ListHostScanRecipesSortOrderEnum string

// Set of constants representing the allowable values for ListHostScanRecipesSortOrderEnum
const (
	ListHostScanRecipesSortOrderAsc  ListHostScanRecipesSortOrderEnum = "ASC"
	ListHostScanRecipesSortOrderDesc ListHostScanRecipesSortOrderEnum = "DESC"
)

var mappingListHostScanRecipesSortOrderEnum = map[string]ListHostScanRecipesSortOrderEnum{
	"ASC":  ListHostScanRecipesSortOrderAsc,
	"DESC": ListHostScanRecipesSortOrderDesc,
}

var mappingListHostScanRecipesSortOrderEnumLowerCase = map[string]ListHostScanRecipesSortOrderEnum{
	"asc":  ListHostScanRecipesSortOrderAsc,
	"desc": ListHostScanRecipesSortOrderDesc,
}

// GetListHostScanRecipesSortOrderEnumValues Enumerates the set of values for ListHostScanRecipesSortOrderEnum
func GetListHostScanRecipesSortOrderEnumValues() []ListHostScanRecipesSortOrderEnum {
	values := make([]ListHostScanRecipesSortOrderEnum, 0)
	for _, v := range mappingListHostScanRecipesSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListHostScanRecipesSortOrderEnumStringValues Enumerates the set of values in String for ListHostScanRecipesSortOrderEnum
func GetListHostScanRecipesSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListHostScanRecipesSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHostScanRecipesSortOrderEnum(val string) (ListHostScanRecipesSortOrderEnum, bool) {
	enum, ok := mappingListHostScanRecipesSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListHostScanRecipesSortByEnum Enum with underlying type: string
type ListHostScanRecipesSortByEnum string

// Set of constants representing the allowable values for ListHostScanRecipesSortByEnum
const (
	ListHostScanRecipesSortByTimecreated ListHostScanRecipesSortByEnum = "timeCreated"
	ListHostScanRecipesSortByDisplayname ListHostScanRecipesSortByEnum = "displayName"
)

var mappingListHostScanRecipesSortByEnum = map[string]ListHostScanRecipesSortByEnum{
	"timeCreated": ListHostScanRecipesSortByTimecreated,
	"displayName": ListHostScanRecipesSortByDisplayname,
}

var mappingListHostScanRecipesSortByEnumLowerCase = map[string]ListHostScanRecipesSortByEnum{
	"timecreated": ListHostScanRecipesSortByTimecreated,
	"displayname": ListHostScanRecipesSortByDisplayname,
}

// GetListHostScanRecipesSortByEnumValues Enumerates the set of values for ListHostScanRecipesSortByEnum
func GetListHostScanRecipesSortByEnumValues() []ListHostScanRecipesSortByEnum {
	values := make([]ListHostScanRecipesSortByEnum, 0)
	for _, v := range mappingListHostScanRecipesSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListHostScanRecipesSortByEnumStringValues Enumerates the set of values in String for ListHostScanRecipesSortByEnum
func GetListHostScanRecipesSortByEnumStringValues() []string {
	return []string{
		"timeCreated",
		"displayName",
	}
}

// GetMappingListHostScanRecipesSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHostScanRecipesSortByEnum(val string) (ListHostScanRecipesSortByEnum, bool) {
	enum, ok := mappingListHostScanRecipesSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
