package ipparser

import (
	"strconv"

	"github.com/coredns/coredns/plugin"
	"github.com/miekg/dns"
	"github.com/prometheus/client_golang/prometheus"
	"github.com/prometheus/client_golang/prometheus/promauto"
)

var (
	dynamicResponseCount = promauto.NewCounterVec(prometheus.CounterOpts{
		Namespace: plugin.Namespace,
		Subsystem: "forge_" + pluginName,
		Name:      "responses_total",
		Help:      "The count of dynamic A/AAAA DNS responses generated by p2p-forge.",
	}, []string{"type"})
)

func dnsToString(dnsType uint16) string {
	if str, ok := dns.TypeToString[dnsType]; ok {
		return str
	}
	return strconv.Itoa(int(dnsType))
}
