// Code generated by cmd/lexgen (see Makefile's lexgen); DO NOT EDIT.

package bsky

// schema: app.bsky.unspecced.getPostThreadOtherV2

import (
	"context"
	"encoding/json"
	"fmt"

	"github.com/bluesky-social/indigo/lex/util"
)

// UnspeccedGetPostThreadOtherV2_Output is the output of a app.bsky.unspecced.getPostThreadOtherV2 call.
type UnspeccedGetPostThreadOtherV2_Output struct {
	// thread: A flat list of other thread items. The depth of each item is indicated by the depth property inside the item.
	Thread []*UnspeccedGetPostThreadOtherV2_ThreadItem `json:"thread" cborgen:"thread"`
}

// UnspeccedGetPostThreadOtherV2_ThreadItem is a "threadItem" in the app.bsky.unspecced.getPostThreadOtherV2 schema.
type UnspeccedGetPostThreadOtherV2_ThreadItem struct {
	// depth: The nesting level of this item in the thread. Depth 0 means the anchor item. Items above have negative depths, items below have positive depths.
	Depth int64                                           `json:"depth" cborgen:"depth"`
	Uri   string                                          `json:"uri" cborgen:"uri"`
	Value *UnspeccedGetPostThreadOtherV2_ThreadItem_Value `json:"value" cborgen:"value"`
}

type UnspeccedGetPostThreadOtherV2_ThreadItem_Value struct {
	UnspeccedDefs_ThreadItemPost *UnspeccedDefs_ThreadItemPost
}

func (t *UnspeccedGetPostThreadOtherV2_ThreadItem_Value) MarshalJSON() ([]byte, error) {
	if t.UnspeccedDefs_ThreadItemPost != nil {
		t.UnspeccedDefs_ThreadItemPost.LexiconTypeID = "app.bsky.unspecced.defs#threadItemPost"
		return json.Marshal(t.UnspeccedDefs_ThreadItemPost)
	}
	return nil, fmt.Errorf("cannot marshal empty enum")
}
func (t *UnspeccedGetPostThreadOtherV2_ThreadItem_Value) UnmarshalJSON(b []byte) error {
	typ, err := util.TypeExtract(b)
	if err != nil {
		return err
	}

	switch typ {
	case "app.bsky.unspecced.defs#threadItemPost":
		t.UnspeccedDefs_ThreadItemPost = new(UnspeccedDefs_ThreadItemPost)
		return json.Unmarshal(b, t.UnspeccedDefs_ThreadItemPost)

	default:
		return nil
	}
}

// UnspeccedGetPostThreadOtherV2 calls the XRPC method "app.bsky.unspecced.getPostThreadOtherV2".
//
// anchor: Reference (AT-URI) to post record. This is the anchor post.
// prioritizeFollowedUsers: Whether to prioritize posts from followed users. It only has effect when the user is authenticated.
func UnspeccedGetPostThreadOtherV2(ctx context.Context, c util.LexClient, anchor string, prioritizeFollowedUsers bool) (*UnspeccedGetPostThreadOtherV2_Output, error) {
	var out UnspeccedGetPostThreadOtherV2_Output

	params := map[string]interface{}{}
	params["anchor"] = anchor
	if prioritizeFollowedUsers {
		params["prioritizeFollowedUsers"] = prioritizeFollowedUsers
	}
	if err := c.LexDo(ctx, util.Query, "", "app.bsky.unspecced.getPostThreadOtherV2", params, nil, &out); err != nil {
		return nil, err
	}

	return &out, nil
}
