//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package marsh

import (
	"fmt"
	"strconv"
)

// Component types for different nodes of the simulator network (flight model, controls, visualisation etc.). Components will always receive messages from the Manager relevant for their type. Only the first component in a network with a given system ID and type will have its messages forwarded by the Manager, all other ones will only be treated as output (will be shadowed). This enum is an extension of MAV_TYPE documented at https://mavlink.io/en/messages/minimal.html#MAV_TYPE
type MARSH_TYPE uint64

const (
	// The simulation manager responsible for routing packets between different nodes. Typically MARSH Manager, see https://marsh-sim.github.io/manager.html
	MARSH_TYPE_MANAGER MARSH_TYPE = 100
	// Component simulating flight dynamics of the aircraft.
	MARSH_TYPE_FLIGHT_MODEL MARSH_TYPE = 101
	// Component providing pilot control inputs.
	MARSH_TYPE_CONTROLS MARSH_TYPE = 102
	// Component showing the visual situation to the pilot.
	MARSH_TYPE_VISUALISATION MARSH_TYPE = 103
	// Component implementing pilot instrument panel.
	MARSH_TYPE_INSTRUMENTS MARSH_TYPE = 104
	// Component that moves the entire cockpit for motion cueing.
	MARSH_TYPE_MOTION_PLATFORM MARSH_TYPE = 105
	// Component for in-seat motion cueing.
	MARSH_TYPE_GSEAT MARSH_TYPE = 106
	// Component providing gaze data of pilot eyes.
	MARSH_TYPE_EYE_TRACKER MARSH_TYPE = 107
	// Component measuring and actuating forces on pilot control inputs.
	MARSH_TYPE_CONTROL_LOADING MARSH_TYPE = 108
	// Component providing vibrations for system identification, road rumble, gusts, etc.
	MARSH_TYPE_VIBRATION_SOURCE MARSH_TYPE = 109
	// Component providing target for the pilot to follow like controls positions, aircraft state, ILS path etc.
	MARSH_TYPE_PILOT_TARGET MARSH_TYPE = 110
	// Principal component controlling the main scenario of a given test, (unlike lower level MARSH_TYPE_PILOT_TARGET or MARSH_TYPE_MANAGER for overall communication).
	MARSH_TYPE_EXPERIMENT_DIRECTOR MARSH_TYPE = 111
)

var value_to_label_MARSH_TYPE = map[MARSH_TYPE]string{
	MARSH_TYPE_MANAGER:             "MARSH_TYPE_MANAGER",
	MARSH_TYPE_FLIGHT_MODEL:        "MARSH_TYPE_FLIGHT_MODEL",
	MARSH_TYPE_CONTROLS:            "MARSH_TYPE_CONTROLS",
	MARSH_TYPE_VISUALISATION:       "MARSH_TYPE_VISUALISATION",
	MARSH_TYPE_INSTRUMENTS:         "MARSH_TYPE_INSTRUMENTS",
	MARSH_TYPE_MOTION_PLATFORM:     "MARSH_TYPE_MOTION_PLATFORM",
	MARSH_TYPE_GSEAT:               "MARSH_TYPE_GSEAT",
	MARSH_TYPE_EYE_TRACKER:         "MARSH_TYPE_EYE_TRACKER",
	MARSH_TYPE_CONTROL_LOADING:     "MARSH_TYPE_CONTROL_LOADING",
	MARSH_TYPE_VIBRATION_SOURCE:    "MARSH_TYPE_VIBRATION_SOURCE",
	MARSH_TYPE_PILOT_TARGET:        "MARSH_TYPE_PILOT_TARGET",
	MARSH_TYPE_EXPERIMENT_DIRECTOR: "MARSH_TYPE_EXPERIMENT_DIRECTOR",
}

var label_to_value_MARSH_TYPE = map[string]MARSH_TYPE{
	"MARSH_TYPE_MANAGER":             MARSH_TYPE_MANAGER,
	"MARSH_TYPE_FLIGHT_MODEL":        MARSH_TYPE_FLIGHT_MODEL,
	"MARSH_TYPE_CONTROLS":            MARSH_TYPE_CONTROLS,
	"MARSH_TYPE_VISUALISATION":       MARSH_TYPE_VISUALISATION,
	"MARSH_TYPE_INSTRUMENTS":         MARSH_TYPE_INSTRUMENTS,
	"MARSH_TYPE_MOTION_PLATFORM":     MARSH_TYPE_MOTION_PLATFORM,
	"MARSH_TYPE_GSEAT":               MARSH_TYPE_GSEAT,
	"MARSH_TYPE_EYE_TRACKER":         MARSH_TYPE_EYE_TRACKER,
	"MARSH_TYPE_CONTROL_LOADING":     MARSH_TYPE_CONTROL_LOADING,
	"MARSH_TYPE_VIBRATION_SOURCE":    MARSH_TYPE_VIBRATION_SOURCE,
	"MARSH_TYPE_PILOT_TARGET":        MARSH_TYPE_PILOT_TARGET,
	"MARSH_TYPE_EXPERIMENT_DIRECTOR": MARSH_TYPE_EXPERIMENT_DIRECTOR,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MARSH_TYPE) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_MARSH_TYPE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MARSH_TYPE) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_MARSH_TYPE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MARSH_TYPE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MARSH_TYPE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
