//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

type MAV_ODID_DESC_TYPE uint64

const (
	// Optional free-form text description of the purpose of the flight.
	MAV_ODID_DESC_TYPE_TEXT MAV_ODID_DESC_TYPE = 0
	// Optional additional clarification when status == MAV_ODID_STATUS_EMERGENCY.
	MAV_ODID_DESC_TYPE_EMERGENCY MAV_ODID_DESC_TYPE = 1
	// Optional additional clarification when status != MAV_ODID_STATUS_EMERGENCY.
	MAV_ODID_DESC_TYPE_EXTENDED_STATUS MAV_ODID_DESC_TYPE = 2
)

var value_to_label_MAV_ODID_DESC_TYPE = map[MAV_ODID_DESC_TYPE]string{
	MAV_ODID_DESC_TYPE_TEXT:            "MAV_ODID_DESC_TYPE_TEXT",
	MAV_ODID_DESC_TYPE_EMERGENCY:       "MAV_ODID_DESC_TYPE_EMERGENCY",
	MAV_ODID_DESC_TYPE_EXTENDED_STATUS: "MAV_ODID_DESC_TYPE_EXTENDED_STATUS",
}

var label_to_value_MAV_ODID_DESC_TYPE = map[string]MAV_ODID_DESC_TYPE{
	"MAV_ODID_DESC_TYPE_TEXT":            MAV_ODID_DESC_TYPE_TEXT,
	"MAV_ODID_DESC_TYPE_EMERGENCY":       MAV_ODID_DESC_TYPE_EMERGENCY,
	"MAV_ODID_DESC_TYPE_EXTENDED_STATUS": MAV_ODID_DESC_TYPE_EXTENDED_STATUS,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAV_ODID_DESC_TYPE) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_MAV_ODID_DESC_TYPE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAV_ODID_DESC_TYPE) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_MAV_ODID_DESC_TYPE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MAV_ODID_DESC_TYPE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAV_ODID_DESC_TYPE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
