/*
Data Streaming - OpenAPI

The Data Streaming API allows you to manage your existing data streamings and templates. Data Streaming allows you to feed your stream processing, SIEM, and big data platforms with the event logs from your applications on Azion in real time. 

API version: 1.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package data_streaming

import (
	"encoding/json"
	"fmt"
)

// PostDataStreamingResponseEndpointInner - struct for PostDataStreamingResponseEndpointInner
type PostDataStreamingResponseEndpointInner struct {
	EndpoinrtS3 *EndpoinrtS3
	EndpointAWSKinesisFirehose *EndpointAWSKinesisFirehose
	EndpointAzureBlobStorage *EndpointAzureBlobStorage
	EndpointAzureMonitor *EndpointAzureMonitor
	EndpointDatadog *EndpointDatadog
	EndpointDefault *EndpointDefault
	EndpointElasticsearch *EndpointElasticsearch
	EndpointGoogleBigQuery *EndpointGoogleBigQuery
	EndpointIBMQRadar *EndpointIBMQRadar
	EndpointKafka *EndpointKafka
	EndpointSplunk *EndpointSplunk
}

// EndpoinrtS3AsPostDataStreamingResponseEndpointInner is a convenience function that returns EndpoinrtS3 wrapped in PostDataStreamingResponseEndpointInner
func EndpoinrtS3AsPostDataStreamingResponseEndpointInner(v *EndpoinrtS3) PostDataStreamingResponseEndpointInner {
	return PostDataStreamingResponseEndpointInner{
		EndpoinrtS3: v,
	}
}

// EndpointAWSKinesisFirehoseAsPostDataStreamingResponseEndpointInner is a convenience function that returns EndpointAWSKinesisFirehose wrapped in PostDataStreamingResponseEndpointInner
func EndpointAWSKinesisFirehoseAsPostDataStreamingResponseEndpointInner(v *EndpointAWSKinesisFirehose) PostDataStreamingResponseEndpointInner {
	return PostDataStreamingResponseEndpointInner{
		EndpointAWSKinesisFirehose: v,
	}
}

// EndpointAzureBlobStorageAsPostDataStreamingResponseEndpointInner is a convenience function that returns EndpointAzureBlobStorage wrapped in PostDataStreamingResponseEndpointInner
func EndpointAzureBlobStorageAsPostDataStreamingResponseEndpointInner(v *EndpointAzureBlobStorage) PostDataStreamingResponseEndpointInner {
	return PostDataStreamingResponseEndpointInner{
		EndpointAzureBlobStorage: v,
	}
}

// EndpointAzureMonitorAsPostDataStreamingResponseEndpointInner is a convenience function that returns EndpointAzureMonitor wrapped in PostDataStreamingResponseEndpointInner
func EndpointAzureMonitorAsPostDataStreamingResponseEndpointInner(v *EndpointAzureMonitor) PostDataStreamingResponseEndpointInner {
	return PostDataStreamingResponseEndpointInner{
		EndpointAzureMonitor: v,
	}
}

// EndpointDatadogAsPostDataStreamingResponseEndpointInner is a convenience function that returns EndpointDatadog wrapped in PostDataStreamingResponseEndpointInner
func EndpointDatadogAsPostDataStreamingResponseEndpointInner(v *EndpointDatadog) PostDataStreamingResponseEndpointInner {
	return PostDataStreamingResponseEndpointInner{
		EndpointDatadog: v,
	}
}

// EndpointDefaultAsPostDataStreamingResponseEndpointInner is a convenience function that returns EndpointDefault wrapped in PostDataStreamingResponseEndpointInner
func EndpointDefaultAsPostDataStreamingResponseEndpointInner(v *EndpointDefault) PostDataStreamingResponseEndpointInner {
	return PostDataStreamingResponseEndpointInner{
		EndpointDefault: v,
	}
}

// EndpointElasticsearchAsPostDataStreamingResponseEndpointInner is a convenience function that returns EndpointElasticsearch wrapped in PostDataStreamingResponseEndpointInner
func EndpointElasticsearchAsPostDataStreamingResponseEndpointInner(v *EndpointElasticsearch) PostDataStreamingResponseEndpointInner {
	return PostDataStreamingResponseEndpointInner{
		EndpointElasticsearch: v,
	}
}

// EndpointGoogleBigQueryAsPostDataStreamingResponseEndpointInner is a convenience function that returns EndpointGoogleBigQuery wrapped in PostDataStreamingResponseEndpointInner
func EndpointGoogleBigQueryAsPostDataStreamingResponseEndpointInner(v *EndpointGoogleBigQuery) PostDataStreamingResponseEndpointInner {
	return PostDataStreamingResponseEndpointInner{
		EndpointGoogleBigQuery: v,
	}
}

// EndpointIBMQRadarAsPostDataStreamingResponseEndpointInner is a convenience function that returns EndpointIBMQRadar wrapped in PostDataStreamingResponseEndpointInner
func EndpointIBMQRadarAsPostDataStreamingResponseEndpointInner(v *EndpointIBMQRadar) PostDataStreamingResponseEndpointInner {
	return PostDataStreamingResponseEndpointInner{
		EndpointIBMQRadar: v,
	}
}

// EndpointKafkaAsPostDataStreamingResponseEndpointInner is a convenience function that returns EndpointKafka wrapped in PostDataStreamingResponseEndpointInner
func EndpointKafkaAsPostDataStreamingResponseEndpointInner(v *EndpointKafka) PostDataStreamingResponseEndpointInner {
	return PostDataStreamingResponseEndpointInner{
		EndpointKafka: v,
	}
}

// EndpointSplunkAsPostDataStreamingResponseEndpointInner is a convenience function that returns EndpointSplunk wrapped in PostDataStreamingResponseEndpointInner
func EndpointSplunkAsPostDataStreamingResponseEndpointInner(v *EndpointSplunk) PostDataStreamingResponseEndpointInner {
	return PostDataStreamingResponseEndpointInner{
		EndpointSplunk: v,
	}
}


// Unmarshal JSON data into one of the pointers in the struct
func (dst *PostDataStreamingResponseEndpointInner) UnmarshalJSON(data []byte) error {
	var err error
	match := 0
	// try to unmarshal data into EndpoinrtS3
	err = newStrictDecoder(data).Decode(&dst.EndpoinrtS3)
	if err == nil {
		jsonEndpoinrtS3, _ := json.Marshal(dst.EndpoinrtS3)
		if string(jsonEndpoinrtS3) == "{}" { // empty struct
			dst.EndpoinrtS3 = nil
		} else {
			match++
		}
	} else {
		dst.EndpoinrtS3 = nil
	}

	// try to unmarshal data into EndpointAWSKinesisFirehose
	err = newStrictDecoder(data).Decode(&dst.EndpointAWSKinesisFirehose)
	if err == nil {
		jsonEndpointAWSKinesisFirehose, _ := json.Marshal(dst.EndpointAWSKinesisFirehose)
		if string(jsonEndpointAWSKinesisFirehose) == "{}" { // empty struct
			dst.EndpointAWSKinesisFirehose = nil
		} else {
			match++
		}
	} else {
		dst.EndpointAWSKinesisFirehose = nil
	}

	// try to unmarshal data into EndpointAzureBlobStorage
	err = newStrictDecoder(data).Decode(&dst.EndpointAzureBlobStorage)
	if err == nil {
		jsonEndpointAzureBlobStorage, _ := json.Marshal(dst.EndpointAzureBlobStorage)
		if string(jsonEndpointAzureBlobStorage) == "{}" { // empty struct
			dst.EndpointAzureBlobStorage = nil
		} else {
			match++
		}
	} else {
		dst.EndpointAzureBlobStorage = nil
	}

	// try to unmarshal data into EndpointAzureMonitor
	err = newStrictDecoder(data).Decode(&dst.EndpointAzureMonitor)
	if err == nil {
		jsonEndpointAzureMonitor, _ := json.Marshal(dst.EndpointAzureMonitor)
		if string(jsonEndpointAzureMonitor) == "{}" { // empty struct
			dst.EndpointAzureMonitor = nil
		} else {
			match++
		}
	} else {
		dst.EndpointAzureMonitor = nil
	}

	// try to unmarshal data into EndpointDatadog
	err = newStrictDecoder(data).Decode(&dst.EndpointDatadog)
	if err == nil {
		jsonEndpointDatadog, _ := json.Marshal(dst.EndpointDatadog)
		if string(jsonEndpointDatadog) == "{}" { // empty struct
			dst.EndpointDatadog = nil
		} else {
			match++
		}
	} else {
		dst.EndpointDatadog = nil
	}

	// try to unmarshal data into EndpointDefault
	err = newStrictDecoder(data).Decode(&dst.EndpointDefault)
	if err == nil {
		jsonEndpointDefault, _ := json.Marshal(dst.EndpointDefault)
		if string(jsonEndpointDefault) == "{}" { // empty struct
			dst.EndpointDefault = nil
		} else {
			match++
		}
	} else {
		dst.EndpointDefault = nil
	}

	// try to unmarshal data into EndpointElasticsearch
	err = newStrictDecoder(data).Decode(&dst.EndpointElasticsearch)
	if err == nil {
		jsonEndpointElasticsearch, _ := json.Marshal(dst.EndpointElasticsearch)
		if string(jsonEndpointElasticsearch) == "{}" { // empty struct
			dst.EndpointElasticsearch = nil
		} else {
			match++
		}
	} else {
		dst.EndpointElasticsearch = nil
	}

	// try to unmarshal data into EndpointGoogleBigQuery
	err = newStrictDecoder(data).Decode(&dst.EndpointGoogleBigQuery)
	if err == nil {
		jsonEndpointGoogleBigQuery, _ := json.Marshal(dst.EndpointGoogleBigQuery)
		if string(jsonEndpointGoogleBigQuery) == "{}" { // empty struct
			dst.EndpointGoogleBigQuery = nil
		} else {
			match++
		}
	} else {
		dst.EndpointGoogleBigQuery = nil
	}

	// try to unmarshal data into EndpointIBMQRadar
	err = newStrictDecoder(data).Decode(&dst.EndpointIBMQRadar)
	if err == nil {
		jsonEndpointIBMQRadar, _ := json.Marshal(dst.EndpointIBMQRadar)
		if string(jsonEndpointIBMQRadar) == "{}" { // empty struct
			dst.EndpointIBMQRadar = nil
		} else {
			match++
		}
	} else {
		dst.EndpointIBMQRadar = nil
	}

	// try to unmarshal data into EndpointKafka
	err = newStrictDecoder(data).Decode(&dst.EndpointKafka)
	if err == nil {
		jsonEndpointKafka, _ := json.Marshal(dst.EndpointKafka)
		if string(jsonEndpointKafka) == "{}" { // empty struct
			dst.EndpointKafka = nil
		} else {
			match++
		}
	} else {
		dst.EndpointKafka = nil
	}

	// try to unmarshal data into EndpointSplunk
	err = newStrictDecoder(data).Decode(&dst.EndpointSplunk)
	if err == nil {
		jsonEndpointSplunk, _ := json.Marshal(dst.EndpointSplunk)
		if string(jsonEndpointSplunk) == "{}" { // empty struct
			dst.EndpointSplunk = nil
		} else {
			match++
		}
	} else {
		dst.EndpointSplunk = nil
	}

	if match > 1 { // more than 1 match
		// reset to nil
		dst.EndpoinrtS3 = nil
		dst.EndpointAWSKinesisFirehose = nil
		dst.EndpointAzureBlobStorage = nil
		dst.EndpointAzureMonitor = nil
		dst.EndpointDatadog = nil
		dst.EndpointDefault = nil
		dst.EndpointElasticsearch = nil
		dst.EndpointGoogleBigQuery = nil
		dst.EndpointIBMQRadar = nil
		dst.EndpointKafka = nil
		dst.EndpointSplunk = nil

		return fmt.Errorf("data matches more than one schema in oneOf(PostDataStreamingResponseEndpointInner)")
	} else if match == 1 {
		return nil // exactly one match
	} else { // no match
		return fmt.Errorf("data failed to match schemas in oneOf(PostDataStreamingResponseEndpointInner)")
	}
}

// Marshal data from the first non-nil pointers in the struct to JSON
func (src PostDataStreamingResponseEndpointInner) MarshalJSON() ([]byte, error) {
	if src.EndpoinrtS3 != nil {
		return json.Marshal(&src.EndpoinrtS3)
	}

	if src.EndpointAWSKinesisFirehose != nil {
		return json.Marshal(&src.EndpointAWSKinesisFirehose)
	}

	if src.EndpointAzureBlobStorage != nil {
		return json.Marshal(&src.EndpointAzureBlobStorage)
	}

	if src.EndpointAzureMonitor != nil {
		return json.Marshal(&src.EndpointAzureMonitor)
	}

	if src.EndpointDatadog != nil {
		return json.Marshal(&src.EndpointDatadog)
	}

	if src.EndpointDefault != nil {
		return json.Marshal(&src.EndpointDefault)
	}

	if src.EndpointElasticsearch != nil {
		return json.Marshal(&src.EndpointElasticsearch)
	}

	if src.EndpointGoogleBigQuery != nil {
		return json.Marshal(&src.EndpointGoogleBigQuery)
	}

	if src.EndpointIBMQRadar != nil {
		return json.Marshal(&src.EndpointIBMQRadar)
	}

	if src.EndpointKafka != nil {
		return json.Marshal(&src.EndpointKafka)
	}

	if src.EndpointSplunk != nil {
		return json.Marshal(&src.EndpointSplunk)
	}

	return nil, nil // no data in oneOf schemas
}

// Get the actual instance
func (obj *PostDataStreamingResponseEndpointInner) GetActualInstance() (interface{}) {
	if obj == nil {
		return nil
	}
	if obj.EndpoinrtS3 != nil {
		return obj.EndpoinrtS3
	}

	if obj.EndpointAWSKinesisFirehose != nil {
		return obj.EndpointAWSKinesisFirehose
	}

	if obj.EndpointAzureBlobStorage != nil {
		return obj.EndpointAzureBlobStorage
	}

	if obj.EndpointAzureMonitor != nil {
		return obj.EndpointAzureMonitor
	}

	if obj.EndpointDatadog != nil {
		return obj.EndpointDatadog
	}

	if obj.EndpointDefault != nil {
		return obj.EndpointDefault
	}

	if obj.EndpointElasticsearch != nil {
		return obj.EndpointElasticsearch
	}

	if obj.EndpointGoogleBigQuery != nil {
		return obj.EndpointGoogleBigQuery
	}

	if obj.EndpointIBMQRadar != nil {
		return obj.EndpointIBMQRadar
	}

	if obj.EndpointKafka != nil {
		return obj.EndpointKafka
	}

	if obj.EndpointSplunk != nil {
		return obj.EndpointSplunk
	}

	// all schemas are nil
	return nil
}

type NullablePostDataStreamingResponseEndpointInner struct {
	value *PostDataStreamingResponseEndpointInner
	isSet bool
}

func (v NullablePostDataStreamingResponseEndpointInner) Get() *PostDataStreamingResponseEndpointInner {
	return v.value
}

func (v *NullablePostDataStreamingResponseEndpointInner) Set(val *PostDataStreamingResponseEndpointInner) {
	v.value = val
	v.isSet = true
}

func (v NullablePostDataStreamingResponseEndpointInner) IsSet() bool {
	return v.isSet
}

func (v *NullablePostDataStreamingResponseEndpointInner) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullablePostDataStreamingResponseEndpointInner(val *PostDataStreamingResponseEndpointInner) *NullablePostDataStreamingResponseEndpointInner {
	return &NullablePostDataStreamingResponseEndpointInner{value: val, isSet: true}
}

func (v NullablePostDataStreamingResponseEndpointInner) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullablePostDataStreamingResponseEndpointInner) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


