// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package identitystore

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateGroup = "CreateGroup"

// CreateGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGroup for more information on using the CreateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateGroupRequest method.
//	req, resp := client.CreateGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/CreateGroup
func (c *IdentityStore) CreateGroupRequest(input *CreateGroupInput) (req *request.Request, output *CreateGroupOutput) {
	op := &request.Operation{
		Name:       opCreateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGroupInput{}
	}

	output = &CreateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGroup API operation for AWS SSO Identity Store.
//
// Creates a group within the specified identity store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SSO Identity Store's
// API operation CreateGroup for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ConflictException
//     This request cannot be completed for one of the following reasons:
//
//   - Performing the requested operation would violate an existing uniqueness
//     claim in the identity store. Resolve the conflict before retrying this
//     request.
//
//   - The requested resource was being concurrently modified by another request.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ServiceQuotaExceededException
//     The request would cause the number of users or groups in the identity store
//     to exceed the maximum allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/CreateGroup
func (c *IdentityStore) CreateGroup(input *CreateGroupInput) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	return out, req.Send()
}

// CreateGroupWithContext is the same as CreateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IdentityStore) CreateGroupWithContext(ctx aws.Context, input *CreateGroupInput, opts ...request.Option) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGroupMembership = "CreateGroupMembership"

// CreateGroupMembershipRequest generates a "aws/request.Request" representing the
// client's request for the CreateGroupMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGroupMembership for more information on using the CreateGroupMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateGroupMembershipRequest method.
//	req, resp := client.CreateGroupMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/CreateGroupMembership
func (c *IdentityStore) CreateGroupMembershipRequest(input *CreateGroupMembershipInput) (req *request.Request, output *CreateGroupMembershipOutput) {
	op := &request.Operation{
		Name:       opCreateGroupMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGroupMembershipInput{}
	}

	output = &CreateGroupMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGroupMembership API operation for AWS SSO Identity Store.
//
// Creates a relationship between a member and a group. The following identifiers
// must be specified: GroupId, IdentityStoreId, and MemberId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SSO Identity Store's
// API operation CreateGroupMembership for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ConflictException
//     This request cannot be completed for one of the following reasons:
//
//   - Performing the requested operation would violate an existing uniqueness
//     claim in the identity store. Resolve the conflict before retrying this
//     request.
//
//   - The requested resource was being concurrently modified by another request.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ServiceQuotaExceededException
//     The request would cause the number of users or groups in the identity store
//     to exceed the maximum allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/CreateGroupMembership
func (c *IdentityStore) CreateGroupMembership(input *CreateGroupMembershipInput) (*CreateGroupMembershipOutput, error) {
	req, out := c.CreateGroupMembershipRequest(input)
	return out, req.Send()
}

// CreateGroupMembershipWithContext is the same as CreateGroupMembership with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroupMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IdentityStore) CreateGroupMembershipWithContext(ctx aws.Context, input *CreateGroupMembershipInput, opts ...request.Option) (*CreateGroupMembershipOutput, error) {
	req, out := c.CreateGroupMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUser = "CreateUser"

// CreateUserRequest generates a "aws/request.Request" representing the
// client's request for the CreateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUser for more information on using the CreateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateUserRequest method.
//	req, resp := client.CreateUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/CreateUser
func (c *IdentityStore) CreateUserRequest(input *CreateUserInput) (req *request.Request, output *CreateUserOutput) {
	op := &request.Operation{
		Name:       opCreateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserInput{}
	}

	output = &CreateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUser API operation for AWS SSO Identity Store.
//
// Creates a user within the specified identity store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SSO Identity Store's
// API operation CreateUser for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ConflictException
//     This request cannot be completed for one of the following reasons:
//
//   - Performing the requested operation would violate an existing uniqueness
//     claim in the identity store. Resolve the conflict before retrying this
//     request.
//
//   - The requested resource was being concurrently modified by another request.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ServiceQuotaExceededException
//     The request would cause the number of users or groups in the identity store
//     to exceed the maximum allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/CreateUser
func (c *IdentityStore) CreateUser(input *CreateUserInput) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	return out, req.Send()
}

// CreateUserWithContext is the same as CreateUser with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IdentityStore) CreateUserWithContext(ctx aws.Context, input *CreateUserInput, opts ...request.Option) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGroup = "DeleteGroup"

// DeleteGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGroup for more information on using the DeleteGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteGroupRequest method.
//	req, resp := client.DeleteGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/DeleteGroup
func (c *IdentityStore) DeleteGroupRequest(input *DeleteGroupInput) (req *request.Request, output *DeleteGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGroupInput{}
	}

	output = &DeleteGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteGroup API operation for AWS SSO Identity Store.
//
// Delete a group within an identity store given GroupId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SSO Identity Store's
// API operation DeleteGroup for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ConflictException
//     This request cannot be completed for one of the following reasons:
//
//   - Performing the requested operation would violate an existing uniqueness
//     claim in the identity store. Resolve the conflict before retrying this
//     request.
//
//   - The requested resource was being concurrently modified by another request.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/DeleteGroup
func (c *IdentityStore) DeleteGroup(input *DeleteGroupInput) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	return out, req.Send()
}

// DeleteGroupWithContext is the same as DeleteGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IdentityStore) DeleteGroupWithContext(ctx aws.Context, input *DeleteGroupInput, opts ...request.Option) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGroupMembership = "DeleteGroupMembership"

// DeleteGroupMembershipRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGroupMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGroupMembership for more information on using the DeleteGroupMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteGroupMembershipRequest method.
//	req, resp := client.DeleteGroupMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/DeleteGroupMembership
func (c *IdentityStore) DeleteGroupMembershipRequest(input *DeleteGroupMembershipInput) (req *request.Request, output *DeleteGroupMembershipOutput) {
	op := &request.Operation{
		Name:       opDeleteGroupMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGroupMembershipInput{}
	}

	output = &DeleteGroupMembershipOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteGroupMembership API operation for AWS SSO Identity Store.
//
// Delete a membership within a group given MembershipId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SSO Identity Store's
// API operation DeleteGroupMembership for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ConflictException
//     This request cannot be completed for one of the following reasons:
//
//   - Performing the requested operation would violate an existing uniqueness
//     claim in the identity store. Resolve the conflict before retrying this
//     request.
//
//   - The requested resource was being concurrently modified by another request.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/DeleteGroupMembership
func (c *IdentityStore) DeleteGroupMembership(input *DeleteGroupMembershipInput) (*DeleteGroupMembershipOutput, error) {
	req, out := c.DeleteGroupMembershipRequest(input)
	return out, req.Send()
}

// DeleteGroupMembershipWithContext is the same as DeleteGroupMembership with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGroupMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IdentityStore) DeleteGroupMembershipWithContext(ctx aws.Context, input *DeleteGroupMembershipInput, opts ...request.Option) (*DeleteGroupMembershipOutput, error) {
	req, out := c.DeleteGroupMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUser = "DeleteUser"

// DeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUser for more information on using the DeleteUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteUserRequest method.
//	req, resp := client.DeleteUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/DeleteUser
func (c *IdentityStore) DeleteUserRequest(input *DeleteUserInput) (req *request.Request, output *DeleteUserOutput) {
	op := &request.Operation{
		Name:       opDeleteUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserInput{}
	}

	output = &DeleteUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUser API operation for AWS SSO Identity Store.
//
// Deletes a user within an identity store given UserId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SSO Identity Store's
// API operation DeleteUser for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ConflictException
//     This request cannot be completed for one of the following reasons:
//
//   - Performing the requested operation would violate an existing uniqueness
//     claim in the identity store. Resolve the conflict before retrying this
//     request.
//
//   - The requested resource was being concurrently modified by another request.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/DeleteUser
func (c *IdentityStore) DeleteUser(input *DeleteUserInput) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	return out, req.Send()
}

// DeleteUserWithContext is the same as DeleteUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IdentityStore) DeleteUserWithContext(ctx aws.Context, input *DeleteUserInput, opts ...request.Option) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGroup = "DescribeGroup"

// DescribeGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGroup for more information on using the DescribeGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeGroupRequest method.
//	req, resp := client.DescribeGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/DescribeGroup
func (c *IdentityStore) DescribeGroupRequest(input *DescribeGroupInput) (req *request.Request, output *DescribeGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGroupInput{}
	}

	output = &DescribeGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGroup API operation for AWS SSO Identity Store.
//
// Retrieves the group metadata and attributes from GroupId in an identity store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SSO Identity Store's
// API operation DescribeGroup for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/DescribeGroup
func (c *IdentityStore) DescribeGroup(input *DescribeGroupInput) (*DescribeGroupOutput, error) {
	req, out := c.DescribeGroupRequest(input)
	return out, req.Send()
}

// DescribeGroupWithContext is the same as DescribeGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IdentityStore) DescribeGroupWithContext(ctx aws.Context, input *DescribeGroupInput, opts ...request.Option) (*DescribeGroupOutput, error) {
	req, out := c.DescribeGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGroupMembership = "DescribeGroupMembership"

// DescribeGroupMembershipRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGroupMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGroupMembership for more information on using the DescribeGroupMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeGroupMembershipRequest method.
//	req, resp := client.DescribeGroupMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/DescribeGroupMembership
func (c *IdentityStore) DescribeGroupMembershipRequest(input *DescribeGroupMembershipInput) (req *request.Request, output *DescribeGroupMembershipOutput) {
	op := &request.Operation{
		Name:       opDescribeGroupMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGroupMembershipInput{}
	}

	output = &DescribeGroupMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGroupMembership API operation for AWS SSO Identity Store.
//
// Retrieves membership metadata and attributes from MembershipId in an identity
// store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SSO Identity Store's
// API operation DescribeGroupMembership for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/DescribeGroupMembership
func (c *IdentityStore) DescribeGroupMembership(input *DescribeGroupMembershipInput) (*DescribeGroupMembershipOutput, error) {
	req, out := c.DescribeGroupMembershipRequest(input)
	return out, req.Send()
}

// DescribeGroupMembershipWithContext is the same as DescribeGroupMembership with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGroupMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IdentityStore) DescribeGroupMembershipWithContext(ctx aws.Context, input *DescribeGroupMembershipInput, opts ...request.Option) (*DescribeGroupMembershipOutput, error) {
	req, out := c.DescribeGroupMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUser = "DescribeUser"

// DescribeUserRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUser for more information on using the DescribeUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeUserRequest method.
//	req, resp := client.DescribeUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/DescribeUser
func (c *IdentityStore) DescribeUserRequest(input *DescribeUserInput) (req *request.Request, output *DescribeUserOutput) {
	op := &request.Operation{
		Name:       opDescribeUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserInput{}
	}

	output = &DescribeUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUser API operation for AWS SSO Identity Store.
//
// Retrieves the user metadata and attributes from the UserId in an identity
// store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SSO Identity Store's
// API operation DescribeUser for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/DescribeUser
func (c *IdentityStore) DescribeUser(input *DescribeUserInput) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	return out, req.Send()
}

// DescribeUserWithContext is the same as DescribeUser with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IdentityStore) DescribeUserWithContext(ctx aws.Context, input *DescribeUserInput, opts ...request.Option) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGroupId = "GetGroupId"

// GetGroupIdRequest generates a "aws/request.Request" representing the
// client's request for the GetGroupId operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGroupId for more information on using the GetGroupId
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetGroupIdRequest method.
//	req, resp := client.GetGroupIdRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/GetGroupId
func (c *IdentityStore) GetGroupIdRequest(input *GetGroupIdInput) (req *request.Request, output *GetGroupIdOutput) {
	op := &request.Operation{
		Name:       opGetGroupId,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetGroupIdInput{}
	}

	output = &GetGroupIdOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGroupId API operation for AWS SSO Identity Store.
//
// Retrieves GroupId in an identity store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SSO Identity Store's
// API operation GetGroupId for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/GetGroupId
func (c *IdentityStore) GetGroupId(input *GetGroupIdInput) (*GetGroupIdOutput, error) {
	req, out := c.GetGroupIdRequest(input)
	return out, req.Send()
}

// GetGroupIdWithContext is the same as GetGroupId with the addition of
// the ability to pass a context and additional request options.
//
// See GetGroupId for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IdentityStore) GetGroupIdWithContext(ctx aws.Context, input *GetGroupIdInput, opts ...request.Option) (*GetGroupIdOutput, error) {
	req, out := c.GetGroupIdRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGroupMembershipId = "GetGroupMembershipId"

// GetGroupMembershipIdRequest generates a "aws/request.Request" representing the
// client's request for the GetGroupMembershipId operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGroupMembershipId for more information on using the GetGroupMembershipId
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetGroupMembershipIdRequest method.
//	req, resp := client.GetGroupMembershipIdRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/GetGroupMembershipId
func (c *IdentityStore) GetGroupMembershipIdRequest(input *GetGroupMembershipIdInput) (req *request.Request, output *GetGroupMembershipIdOutput) {
	op := &request.Operation{
		Name:       opGetGroupMembershipId,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetGroupMembershipIdInput{}
	}

	output = &GetGroupMembershipIdOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGroupMembershipId API operation for AWS SSO Identity Store.
//
// Retrieves the MembershipId in an identity store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SSO Identity Store's
// API operation GetGroupMembershipId for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/GetGroupMembershipId
func (c *IdentityStore) GetGroupMembershipId(input *GetGroupMembershipIdInput) (*GetGroupMembershipIdOutput, error) {
	req, out := c.GetGroupMembershipIdRequest(input)
	return out, req.Send()
}

// GetGroupMembershipIdWithContext is the same as GetGroupMembershipId with the addition of
// the ability to pass a context and additional request options.
//
// See GetGroupMembershipId for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IdentityStore) GetGroupMembershipIdWithContext(ctx aws.Context, input *GetGroupMembershipIdInput, opts ...request.Option) (*GetGroupMembershipIdOutput, error) {
	req, out := c.GetGroupMembershipIdRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUserId = "GetUserId"

// GetUserIdRequest generates a "aws/request.Request" representing the
// client's request for the GetUserId operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUserId for more information on using the GetUserId
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetUserIdRequest method.
//	req, resp := client.GetUserIdRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/GetUserId
func (c *IdentityStore) GetUserIdRequest(input *GetUserIdInput) (req *request.Request, output *GetUserIdOutput) {
	op := &request.Operation{
		Name:       opGetUserId,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUserIdInput{}
	}

	output = &GetUserIdOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUserId API operation for AWS SSO Identity Store.
//
// Retrieves the UserId in an identity store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SSO Identity Store's
// API operation GetUserId for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/GetUserId
func (c *IdentityStore) GetUserId(input *GetUserIdInput) (*GetUserIdOutput, error) {
	req, out := c.GetUserIdRequest(input)
	return out, req.Send()
}

// GetUserIdWithContext is the same as GetUserId with the addition of
// the ability to pass a context and additional request options.
//
// See GetUserId for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IdentityStore) GetUserIdWithContext(ctx aws.Context, input *GetUserIdInput, opts ...request.Option) (*GetUserIdOutput, error) {
	req, out := c.GetUserIdRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opIsMemberInGroups = "IsMemberInGroups"

// IsMemberInGroupsRequest generates a "aws/request.Request" representing the
// client's request for the IsMemberInGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See IsMemberInGroups for more information on using the IsMemberInGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the IsMemberInGroupsRequest method.
//	req, resp := client.IsMemberInGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/IsMemberInGroups
func (c *IdentityStore) IsMemberInGroupsRequest(input *IsMemberInGroupsInput) (req *request.Request, output *IsMemberInGroupsOutput) {
	op := &request.Operation{
		Name:       opIsMemberInGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &IsMemberInGroupsInput{}
	}

	output = &IsMemberInGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// IsMemberInGroups API operation for AWS SSO Identity Store.
//
// Checks the user's membership in all requested groups and returns if the member
// exists in all queried groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SSO Identity Store's
// API operation IsMemberInGroups for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/IsMemberInGroups
func (c *IdentityStore) IsMemberInGroups(input *IsMemberInGroupsInput) (*IsMemberInGroupsOutput, error) {
	req, out := c.IsMemberInGroupsRequest(input)
	return out, req.Send()
}

// IsMemberInGroupsWithContext is the same as IsMemberInGroups with the addition of
// the ability to pass a context and additional request options.
//
// See IsMemberInGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IdentityStore) IsMemberInGroupsWithContext(ctx aws.Context, input *IsMemberInGroupsInput, opts ...request.Option) (*IsMemberInGroupsOutput, error) {
	req, out := c.IsMemberInGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGroupMemberships = "ListGroupMemberships"

// ListGroupMembershipsRequest generates a "aws/request.Request" representing the
// client's request for the ListGroupMemberships operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroupMemberships for more information on using the ListGroupMemberships
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListGroupMembershipsRequest method.
//	req, resp := client.ListGroupMembershipsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ListGroupMemberships
func (c *IdentityStore) ListGroupMembershipsRequest(input *ListGroupMembershipsInput) (req *request.Request, output *ListGroupMembershipsOutput) {
	op := &request.Operation{
		Name:       opListGroupMemberships,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGroupMembershipsInput{}
	}

	output = &ListGroupMembershipsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroupMemberships API operation for AWS SSO Identity Store.
//
// For the specified group in the specified identity store, returns the list
// of all GroupMembership objects and returns results in paginated form.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SSO Identity Store's
// API operation ListGroupMemberships for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ListGroupMemberships
func (c *IdentityStore) ListGroupMemberships(input *ListGroupMembershipsInput) (*ListGroupMembershipsOutput, error) {
	req, out := c.ListGroupMembershipsRequest(input)
	return out, req.Send()
}

// ListGroupMembershipsWithContext is the same as ListGroupMemberships with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroupMemberships for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IdentityStore) ListGroupMembershipsWithContext(ctx aws.Context, input *ListGroupMembershipsInput, opts ...request.Option) (*ListGroupMembershipsOutput, error) {
	req, out := c.ListGroupMembershipsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGroupMembershipsPages iterates over the pages of a ListGroupMemberships operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGroupMemberships method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListGroupMemberships operation.
//	pageNum := 0
//	err := client.ListGroupMembershipsPages(params,
//	    func(page *identitystore.ListGroupMembershipsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IdentityStore) ListGroupMembershipsPages(input *ListGroupMembershipsInput, fn func(*ListGroupMembershipsOutput, bool) bool) error {
	return c.ListGroupMembershipsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGroupMembershipsPagesWithContext same as ListGroupMembershipsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IdentityStore) ListGroupMembershipsPagesWithContext(ctx aws.Context, input *ListGroupMembershipsInput, fn func(*ListGroupMembershipsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGroupMembershipsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGroupMembershipsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGroupMembershipsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGroupMembershipsForMember = "ListGroupMembershipsForMember"

// ListGroupMembershipsForMemberRequest generates a "aws/request.Request" representing the
// client's request for the ListGroupMembershipsForMember operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroupMembershipsForMember for more information on using the ListGroupMembershipsForMember
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListGroupMembershipsForMemberRequest method.
//	req, resp := client.ListGroupMembershipsForMemberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ListGroupMembershipsForMember
func (c *IdentityStore) ListGroupMembershipsForMemberRequest(input *ListGroupMembershipsForMemberInput) (req *request.Request, output *ListGroupMembershipsForMemberOutput) {
	op := &request.Operation{
		Name:       opListGroupMembershipsForMember,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGroupMembershipsForMemberInput{}
	}

	output = &ListGroupMembershipsForMemberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroupMembershipsForMember API operation for AWS SSO Identity Store.
//
// For the specified member in the specified identity store, returns the list
// of all GroupMembership objects and returns results in paginated form.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SSO Identity Store's
// API operation ListGroupMembershipsForMember for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ListGroupMembershipsForMember
func (c *IdentityStore) ListGroupMembershipsForMember(input *ListGroupMembershipsForMemberInput) (*ListGroupMembershipsForMemberOutput, error) {
	req, out := c.ListGroupMembershipsForMemberRequest(input)
	return out, req.Send()
}

// ListGroupMembershipsForMemberWithContext is the same as ListGroupMembershipsForMember with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroupMembershipsForMember for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IdentityStore) ListGroupMembershipsForMemberWithContext(ctx aws.Context, input *ListGroupMembershipsForMemberInput, opts ...request.Option) (*ListGroupMembershipsForMemberOutput, error) {
	req, out := c.ListGroupMembershipsForMemberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGroupMembershipsForMemberPages iterates over the pages of a ListGroupMembershipsForMember operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGroupMembershipsForMember method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListGroupMembershipsForMember operation.
//	pageNum := 0
//	err := client.ListGroupMembershipsForMemberPages(params,
//	    func(page *identitystore.ListGroupMembershipsForMemberOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IdentityStore) ListGroupMembershipsForMemberPages(input *ListGroupMembershipsForMemberInput, fn func(*ListGroupMembershipsForMemberOutput, bool) bool) error {
	return c.ListGroupMembershipsForMemberPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGroupMembershipsForMemberPagesWithContext same as ListGroupMembershipsForMemberPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IdentityStore) ListGroupMembershipsForMemberPagesWithContext(ctx aws.Context, input *ListGroupMembershipsForMemberInput, fn func(*ListGroupMembershipsForMemberOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGroupMembershipsForMemberInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGroupMembershipsForMemberRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGroupMembershipsForMemberOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGroups = "ListGroups"

// ListGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroups for more information on using the ListGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListGroupsRequest method.
//	req, resp := client.ListGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ListGroups
func (c *IdentityStore) ListGroupsRequest(input *ListGroupsInput) (req *request.Request, output *ListGroupsOutput) {
	op := &request.Operation{
		Name:       opListGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGroupsInput{}
	}

	output = &ListGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroups API operation for AWS SSO Identity Store.
//
// Lists all groups in the identity store. Returns a paginated list of complete
// Group objects. Filtering for a Group by the DisplayName attribute is deprecated.
// Instead, use the GetGroupId API action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SSO Identity Store's
// API operation ListGroups for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ListGroups
func (c *IdentityStore) ListGroups(input *ListGroupsInput) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	return out, req.Send()
}

// ListGroupsWithContext is the same as ListGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IdentityStore) ListGroupsWithContext(ctx aws.Context, input *ListGroupsInput, opts ...request.Option) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGroupsPages iterates over the pages of a ListGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListGroups operation.
//	pageNum := 0
//	err := client.ListGroupsPages(params,
//	    func(page *identitystore.ListGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IdentityStore) ListGroupsPages(input *ListGroupsInput, fn func(*ListGroupsOutput, bool) bool) error {
	return c.ListGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGroupsPagesWithContext same as ListGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IdentityStore) ListGroupsPagesWithContext(ctx aws.Context, input *ListGroupsInput, fn func(*ListGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListUsers = "ListUsers"

// ListUsersRequest generates a "aws/request.Request" representing the
// client's request for the ListUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUsers for more information on using the ListUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListUsersRequest method.
//	req, resp := client.ListUsersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ListUsers
func (c *IdentityStore) ListUsersRequest(input *ListUsersInput) (req *request.Request, output *ListUsersOutput) {
	op := &request.Operation{
		Name:       opListUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUsersInput{}
	}

	output = &ListUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUsers API operation for AWS SSO Identity Store.
//
// Lists all users in the identity store. Returns a paginated list of complete
// User objects. Filtering for a User by the UserName attribute is deprecated.
// Instead, use the GetUserId API action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SSO Identity Store's
// API operation ListUsers for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ListUsers
func (c *IdentityStore) ListUsers(input *ListUsersInput) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	return out, req.Send()
}

// ListUsersWithContext is the same as ListUsers with the addition of
// the ability to pass a context and additional request options.
//
// See ListUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IdentityStore) ListUsersWithContext(ctx aws.Context, input *ListUsersInput, opts ...request.Option) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUsersPages iterates over the pages of a ListUsers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUsers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListUsers operation.
//	pageNum := 0
//	err := client.ListUsersPages(params,
//	    func(page *identitystore.ListUsersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IdentityStore) ListUsersPages(input *ListUsersInput, fn func(*ListUsersOutput, bool) bool) error {
	return c.ListUsersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUsersPagesWithContext same as ListUsersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IdentityStore) ListUsersPagesWithContext(ctx aws.Context, input *ListUsersInput, fn func(*ListUsersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUsersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUsersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUsersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opUpdateGroup = "UpdateGroup"

// UpdateGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGroup for more information on using the UpdateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateGroupRequest method.
//	req, resp := client.UpdateGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/UpdateGroup
func (c *IdentityStore) UpdateGroupRequest(input *UpdateGroupInput) (req *request.Request, output *UpdateGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGroupInput{}
	}

	output = &UpdateGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateGroup API operation for AWS SSO Identity Store.
//
// For the specified group in the specified identity store, updates the group
// metadata and attributes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SSO Identity Store's
// API operation UpdateGroup for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ConflictException
//     This request cannot be completed for one of the following reasons:
//
//   - Performing the requested operation would violate an existing uniqueness
//     claim in the identity store. Resolve the conflict before retrying this
//     request.
//
//   - The requested resource was being concurrently modified by another request.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ServiceQuotaExceededException
//     The request would cause the number of users or groups in the identity store
//     to exceed the maximum allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/UpdateGroup
func (c *IdentityStore) UpdateGroup(input *UpdateGroupInput) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	return out, req.Send()
}

// UpdateGroupWithContext is the same as UpdateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IdentityStore) UpdateGroupWithContext(ctx aws.Context, input *UpdateGroupInput, opts ...request.Option) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUser = "UpdateUser"

// UpdateUserRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUser for more information on using the UpdateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateUserRequest method.
//	req, resp := client.UpdateUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/UpdateUser
func (c *IdentityStore) UpdateUserRequest(input *UpdateUserInput) (req *request.Request, output *UpdateUserOutput) {
	op := &request.Operation{
		Name:       opUpdateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserInput{}
	}

	output = &UpdateUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateUser API operation for AWS SSO Identity Store.
//
// For the specified user in the specified identity store, updates the user
// metadata and attributes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SSO Identity Store's
// API operation UpdateUser for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ConflictException
//     This request cannot be completed for one of the following reasons:
//
//   - Performing the requested operation would violate an existing uniqueness
//     claim in the identity store. Resolve the conflict before retrying this
//     request.
//
//   - The requested resource was being concurrently modified by another request.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ServiceQuotaExceededException
//     The request would cause the number of users or groups in the identity store
//     to exceed the maximum allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/UpdateUser
func (c *IdentityStore) UpdateUser(input *UpdateUserInput) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	return out, req.Send()
}

// UpdateUserWithContext is the same as UpdateUser with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IdentityStore) UpdateUserWithContext(ctx aws.Context, input *UpdateUserInput, opts ...request.Option) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The identifier for each request. This value is a globally unique ID that
	// is generated by the identity store service for each sent request, and is
	// then returned inside the exception if the request fails.
	RequestId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The address associated with the specified user.
type Address struct {
	_ struct{} `type:"structure"`

	// The country of the address.
	//
	// Country is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	Country *string `min:"1" type:"string" sensitive:"true"`

	// A string containing a formatted version of the address for display.
	//
	// Formatted is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	Formatted *string `min:"1" type:"string" sensitive:"true"`

	// A string of the address locality.
	//
	// Locality is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	Locality *string `min:"1" type:"string" sensitive:"true"`

	// The postal code of the address.
	//
	// PostalCode is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	PostalCode *string `min:"1" type:"string" sensitive:"true"`

	// A Boolean value representing whether this is the primary address for the
	// associated resource.
	//
	// Primary is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	Primary *bool `type:"boolean" sensitive:"true"`

	// The region of the address.
	//
	// Region is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	Region *string `min:"1" type:"string" sensitive:"true"`

	// The street of the address.
	//
	// StreetAddress is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	StreetAddress *string `min:"1" type:"string" sensitive:"true"`

	// A string representing the type of address. For example, "Home."
	//
	// Type is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	Type *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Address) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Address) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Address) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Address"}
	if s.Country != nil && len(*s.Country) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Country", 1))
	}
	if s.Formatted != nil && len(*s.Formatted) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Formatted", 1))
	}
	if s.Locality != nil && len(*s.Locality) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Locality", 1))
	}
	if s.PostalCode != nil && len(*s.PostalCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PostalCode", 1))
	}
	if s.Region != nil && len(*s.Region) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Region", 1))
	}
	if s.StreetAddress != nil && len(*s.StreetAddress) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreetAddress", 1))
	}
	if s.Type != nil && len(*s.Type) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Type", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCountry sets the Country field's value.
func (s *Address) SetCountry(v string) *Address {
	s.Country = &v
	return s
}

// SetFormatted sets the Formatted field's value.
func (s *Address) SetFormatted(v string) *Address {
	s.Formatted = &v
	return s
}

// SetLocality sets the Locality field's value.
func (s *Address) SetLocality(v string) *Address {
	s.Locality = &v
	return s
}

// SetPostalCode sets the PostalCode field's value.
func (s *Address) SetPostalCode(v string) *Address {
	s.PostalCode = &v
	return s
}

// SetPrimary sets the Primary field's value.
func (s *Address) SetPrimary(v bool) *Address {
	s.Primary = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Address) SetRegion(v string) *Address {
	s.Region = &v
	return s
}

// SetStreetAddress sets the StreetAddress field's value.
func (s *Address) SetStreetAddress(v string) *Address {
	s.StreetAddress = &v
	return s
}

// SetType sets the Type field's value.
func (s *Address) SetType(v string) *Address {
	s.Type = &v
	return s
}

// A unique identifier for a user or group that is not the primary identifier.
// This value can be an identifier from an external identity provider (IdP)
// that is associated with the user, the group, or a unique attribute.
type AlternateIdentifier struct {
	_ struct{} `type:"structure"`

	// The identifier issued to this resource by an external identity provider.
	ExternalId *ExternalId `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlternateIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlternateIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AlternateIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AlternateIdentifier"}
	if s.ExternalId != nil {
		if err := s.ExternalId.Validate(); err != nil {
			invalidParams.AddNested("ExternalId", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExternalId sets the ExternalId field's value.
func (s *AlternateIdentifier) SetExternalId(v *ExternalId) *AlternateIdentifier {
	s.ExternalId = v
	return s
}

// An operation that applies to the requested group. This operation might add,
// replace, or remove an attribute.
type AttributeOperation struct {
	_ struct{} `type:"structure"`

	// A string representation of the path to a given attribute or sub-attribute.
	// Supports JMESPath.
	//
	// AttributePath is a required field
	AttributePath *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttributeOperation"}
	if s.AttributePath == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributePath"))
	}
	if s.AttributePath != nil && len(*s.AttributePath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributePath", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributePath sets the AttributePath field's value.
func (s *AttributeOperation) SetAttributePath(v string) *AttributeOperation {
	s.AttributePath = &v
	return s
}

// This request cannot be completed for one of the following reasons:
//
//   - Performing the requested operation would violate an existing uniqueness
//     claim in the identity store. Resolve the conflict before retrying this
//     request.
//
//   - The requested resource was being concurrently modified by another request.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// This request cannot be completed for one of the following reasons:
	//
	//    * Performing the requested operation would violate an existing uniqueness
	//    claim in the identity store. Resolve the conflict before retrying this
	//    request.
	//
	//    * The requested resource was being concurrently modified by another request.
	Reason *string `type:"string" enum:"ConflictExceptionReason"`

	// The identifier for each request. This value is a globally unique ID that
	// is generated by the identity store service for each sent request, and is
	// then returned inside the exception if the request fails.
	RequestId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateGroupInput struct {
	_ struct{} `type:"structure"`

	// A string containing the description of the group.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateGroupInput's
	// String and GoString methods.
	Description *string `min:"1" type:"string" sensitive:"true"`

	// A string containing the name of the group. This value is commonly displayed
	// when the group is referenced. "Administrator" and "AWSAdministrators" are
	// reserved names and can't be used for users or groups.
	//
	// DisplayName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateGroupInput's
	// String and GoString methods.
	DisplayName *string `min:"1" type:"string" sensitive:"true"`

	// The globally unique identifier for the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGroupInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.IdentityStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStoreId"))
	}
	if s.IdentityStoreId != nil && len(*s.IdentityStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityStoreId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateGroupInput) SetDescription(v string) *CreateGroupInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateGroupInput) SetDisplayName(v string) *CreateGroupInput {
	s.DisplayName = &v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *CreateGroupInput) SetIdentityStoreId(v string) *CreateGroupInput {
	s.IdentityStoreId = &v
	return s
}

type CreateGroupMembershipInput struct {
	_ struct{} `type:"structure"`

	// The identifier for a group in the identity store.
	//
	// GroupId is a required field
	GroupId *string `min:"1" type:"string" required:"true"`

	// The globally unique identifier for the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`

	// An object that contains the identifier of a group member. Setting the UserID
	// field to the specific identifier for a user indicates that the user is a
	// member of the group.
	//
	// MemberId is a required field
	MemberId *MemberId `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGroupMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGroupMembershipInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}
	if s.IdentityStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStoreId"))
	}
	if s.IdentityStoreId != nil && len(*s.IdentityStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityStoreId", 1))
	}
	if s.MemberId == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberId"))
	}
	if s.MemberId != nil {
		if err := s.MemberId.Validate(); err != nil {
			invalidParams.AddNested("MemberId", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *CreateGroupMembershipInput) SetGroupId(v string) *CreateGroupMembershipInput {
	s.GroupId = &v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *CreateGroupMembershipInput) SetIdentityStoreId(v string) *CreateGroupMembershipInput {
	s.IdentityStoreId = &v
	return s
}

// SetMemberId sets the MemberId field's value.
func (s *CreateGroupMembershipInput) SetMemberId(v *MemberId) *CreateGroupMembershipInput {
	s.MemberId = v
	return s
}

type CreateGroupMembershipOutput struct {
	_ struct{} `type:"structure"`

	// The globally unique identifier for the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`

	// The identifier for a newly created GroupMembership in an identity store.
	//
	// MembershipId is a required field
	MembershipId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupMembershipOutput) GoString() string {
	return s.String()
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *CreateGroupMembershipOutput) SetIdentityStoreId(v string) *CreateGroupMembershipOutput {
	s.IdentityStoreId = &v
	return s
}

// SetMembershipId sets the MembershipId field's value.
func (s *CreateGroupMembershipOutput) SetMembershipId(v string) *CreateGroupMembershipOutput {
	s.MembershipId = &v
	return s
}

type CreateGroupOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the newly created group in the identity store.
	//
	// GroupId is a required field
	GroupId *string `min:"1" type:"string" required:"true"`

	// The globally unique identifier for the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupOutput) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *CreateGroupOutput) SetGroupId(v string) *CreateGroupOutput {
	s.GroupId = &v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *CreateGroupOutput) SetIdentityStoreId(v string) *CreateGroupOutput {
	s.IdentityStoreId = &v
	return s
}

type CreateUserInput struct {
	_ struct{} `type:"structure"`

	// A list of Address objects containing addresses associated with the user.
	Addresses []*Address `min:"1" type:"list"`

	// A string containing the name of the user. This value is typically formatted
	// for display when the user is referenced. For example, "John Doe."
	//
	// DisplayName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateUserInput's
	// String and GoString methods.
	DisplayName *string `min:"1" type:"string" sensitive:"true"`

	// A list of Email objects containing email addresses associated with the user.
	Emails []*Email `min:"1" type:"list"`

	// The globally unique identifier for the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`

	// A string containing the geographical region or location of the user.
	//
	// Locale is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateUserInput's
	// String and GoString methods.
	Locale *string `min:"1" type:"string" sensitive:"true"`

	// An object containing the name of the user.
	Name *Name `type:"structure"`

	// A string containing an alternate name for the user.
	//
	// NickName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateUserInput's
	// String and GoString methods.
	NickName *string `min:"1" type:"string" sensitive:"true"`

	// A list of PhoneNumber objects containing phone numbers associated with the
	// user.
	PhoneNumbers []*PhoneNumber `min:"1" type:"list"`

	// A string containing the preferred language of the user. For example, "American
	// English" or "en-us."
	//
	// PreferredLanguage is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateUserInput's
	// String and GoString methods.
	PreferredLanguage *string `min:"1" type:"string" sensitive:"true"`

	// A string containing a URL that might be associated with the user.
	//
	// ProfileUrl is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateUserInput's
	// String and GoString methods.
	ProfileUrl *string `min:"1" type:"string" sensitive:"true"`

	// A string containing the time zone of the user.
	//
	// Timezone is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateUserInput's
	// String and GoString methods.
	Timezone *string `min:"1" type:"string" sensitive:"true"`

	// A string containing the title of the user. Possible values are left unspecified.
	// The value can vary based on your specific use case.
	//
	// Title is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateUserInput's
	// String and GoString methods.
	Title *string `min:"1" type:"string" sensitive:"true"`

	// A unique string used to identify the user. The length limit is 128 characters.
	// This value can consist of letters, accented characters, symbols, numbers,
	// and punctuation. This value is specified at the time the user is created
	// and stored as an attribute of the user object in the identity store. "Administrator"
	// and "AWSAdministrators" are reserved names and can't be used for users or
	// groups.
	//
	// UserName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateUserInput's
	// String and GoString methods.
	UserName *string `min:"1" type:"string" sensitive:"true"`

	// A string indicating the type of user. Possible values are left unspecified.
	// The value can vary based on your specific use case.
	//
	// UserType is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateUserInput's
	// String and GoString methods.
	UserType *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserInput"}
	if s.Addresses != nil && len(s.Addresses) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Addresses", 1))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.Emails != nil && len(s.Emails) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Emails", 1))
	}
	if s.IdentityStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStoreId"))
	}
	if s.IdentityStoreId != nil && len(*s.IdentityStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityStoreId", 1))
	}
	if s.Locale != nil && len(*s.Locale) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Locale", 1))
	}
	if s.NickName != nil && len(*s.NickName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NickName", 1))
	}
	if s.PhoneNumbers != nil && len(s.PhoneNumbers) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhoneNumbers", 1))
	}
	if s.PreferredLanguage != nil && len(*s.PreferredLanguage) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PreferredLanguage", 1))
	}
	if s.ProfileUrl != nil && len(*s.ProfileUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileUrl", 1))
	}
	if s.Timezone != nil && len(*s.Timezone) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Timezone", 1))
	}
	if s.Title != nil && len(*s.Title) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Title", 1))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}
	if s.UserType != nil && len(*s.UserType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserType", 1))
	}
	if s.Addresses != nil {
		for i, v := range s.Addresses {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Addresses", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Emails != nil {
		for i, v := range s.Emails {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Emails", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Name != nil {
		if err := s.Name.Validate(); err != nil {
			invalidParams.AddNested("Name", err.(request.ErrInvalidParams))
		}
	}
	if s.PhoneNumbers != nil {
		for i, v := range s.PhoneNumbers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PhoneNumbers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddresses sets the Addresses field's value.
func (s *CreateUserInput) SetAddresses(v []*Address) *CreateUserInput {
	s.Addresses = v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateUserInput) SetDisplayName(v string) *CreateUserInput {
	s.DisplayName = &v
	return s
}

// SetEmails sets the Emails field's value.
func (s *CreateUserInput) SetEmails(v []*Email) *CreateUserInput {
	s.Emails = v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *CreateUserInput) SetIdentityStoreId(v string) *CreateUserInput {
	s.IdentityStoreId = &v
	return s
}

// SetLocale sets the Locale field's value.
func (s *CreateUserInput) SetLocale(v string) *CreateUserInput {
	s.Locale = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateUserInput) SetName(v *Name) *CreateUserInput {
	s.Name = v
	return s
}

// SetNickName sets the NickName field's value.
func (s *CreateUserInput) SetNickName(v string) *CreateUserInput {
	s.NickName = &v
	return s
}

// SetPhoneNumbers sets the PhoneNumbers field's value.
func (s *CreateUserInput) SetPhoneNumbers(v []*PhoneNumber) *CreateUserInput {
	s.PhoneNumbers = v
	return s
}

// SetPreferredLanguage sets the PreferredLanguage field's value.
func (s *CreateUserInput) SetPreferredLanguage(v string) *CreateUserInput {
	s.PreferredLanguage = &v
	return s
}

// SetProfileUrl sets the ProfileUrl field's value.
func (s *CreateUserInput) SetProfileUrl(v string) *CreateUserInput {
	s.ProfileUrl = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *CreateUserInput) SetTimezone(v string) *CreateUserInput {
	s.Timezone = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *CreateUserInput) SetTitle(v string) *CreateUserInput {
	s.Title = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *CreateUserInput) SetUserName(v string) *CreateUserInput {
	s.UserName = &v
	return s
}

// SetUserType sets the UserType field's value.
func (s *CreateUserInput) SetUserType(v string) *CreateUserInput {
	s.UserType = &v
	return s
}

type CreateUserOutput struct {
	_ struct{} `type:"structure"`

	// The globally unique identifier for the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`

	// The identifier of the newly created user in the identity store.
	//
	// UserId is a required field
	UserId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserOutput) GoString() string {
	return s.String()
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *CreateUserOutput) SetIdentityStoreId(v string) *CreateUserOutput {
	s.IdentityStoreId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *CreateUserOutput) SetUserId(v string) *CreateUserOutput {
	s.UserId = &v
	return s
}

type DeleteGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier for a group in the identity store.
	//
	// GroupId is a required field
	GroupId *string `min:"1" type:"string" required:"true"`

	// The globally unique identifier for the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}
	if s.IdentityStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStoreId"))
	}
	if s.IdentityStoreId != nil && len(*s.IdentityStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityStoreId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *DeleteGroupInput) SetGroupId(v string) *DeleteGroupInput {
	s.GroupId = &v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *DeleteGroupInput) SetIdentityStoreId(v string) *DeleteGroupInput {
	s.IdentityStoreId = &v
	return s
}

type DeleteGroupMembershipInput struct {
	_ struct{} `type:"structure"`

	// The globally unique identifier for the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`

	// The identifier for a GroupMembership in an identity store.
	//
	// MembershipId is a required field
	MembershipId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGroupMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGroupMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGroupMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGroupMembershipInput"}
	if s.IdentityStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStoreId"))
	}
	if s.IdentityStoreId != nil && len(*s.IdentityStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityStoreId", 1))
	}
	if s.MembershipId == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipId"))
	}
	if s.MembershipId != nil && len(*s.MembershipId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *DeleteGroupMembershipInput) SetIdentityStoreId(v string) *DeleteGroupMembershipInput {
	s.IdentityStoreId = &v
	return s
}

// SetMembershipId sets the MembershipId field's value.
func (s *DeleteGroupMembershipInput) SetMembershipId(v string) *DeleteGroupMembershipInput {
	s.MembershipId = &v
	return s
}

type DeleteGroupMembershipOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGroupMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGroupMembershipOutput) GoString() string {
	return s.String()
}

type DeleteGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGroupOutput) GoString() string {
	return s.String()
}

type DeleteUserInput struct {
	_ struct{} `type:"structure"`

	// The globally unique identifier for the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`

	// The identifier for a user in the identity store.
	//
	// UserId is a required field
	UserId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserInput"}
	if s.IdentityStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStoreId"))
	}
	if s.IdentityStoreId != nil && len(*s.IdentityStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityStoreId", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *DeleteUserInput) SetIdentityStoreId(v string) *DeleteUserInput {
	s.IdentityStoreId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DeleteUserInput) SetUserId(v string) *DeleteUserInput {
	s.UserId = &v
	return s
}

type DeleteUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserOutput) GoString() string {
	return s.String()
}

type DescribeGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier for a group in the identity store.
	//
	// GroupId is a required field
	GroupId *string `min:"1" type:"string" required:"true"`

	// The globally unique identifier for the identity store, such as d-1234567890.
	// In this example, d- is a fixed prefix, and 1234567890 is a randomly generated
	// string that contains numbers and lower case letters. This value is generated
	// at the time that a new identity store is created.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}
	if s.IdentityStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStoreId"))
	}
	if s.IdentityStoreId != nil && len(*s.IdentityStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityStoreId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *DescribeGroupInput) SetGroupId(v string) *DescribeGroupInput {
	s.GroupId = &v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *DescribeGroupInput) SetIdentityStoreId(v string) *DescribeGroupInput {
	s.IdentityStoreId = &v
	return s
}

type DescribeGroupMembershipInput struct {
	_ struct{} `type:"structure"`

	// The globally unique identifier for the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`

	// The identifier for a GroupMembership in an identity store.
	//
	// MembershipId is a required field
	MembershipId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGroupMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGroupMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGroupMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGroupMembershipInput"}
	if s.IdentityStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStoreId"))
	}
	if s.IdentityStoreId != nil && len(*s.IdentityStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityStoreId", 1))
	}
	if s.MembershipId == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipId"))
	}
	if s.MembershipId != nil && len(*s.MembershipId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *DescribeGroupMembershipInput) SetIdentityStoreId(v string) *DescribeGroupMembershipInput {
	s.IdentityStoreId = &v
	return s
}

// SetMembershipId sets the MembershipId field's value.
func (s *DescribeGroupMembershipInput) SetMembershipId(v string) *DescribeGroupMembershipInput {
	s.MembershipId = &v
	return s
}

type DescribeGroupMembershipOutput struct {
	_ struct{} `type:"structure"`

	// The identifier for a group in the identity store.
	//
	// GroupId is a required field
	GroupId *string `min:"1" type:"string" required:"true"`

	// The globally unique identifier for the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`

	// An object containing the identifier of a group member.
	//
	// MemberId is a required field
	MemberId *MemberId `type:"structure" required:"true"`

	// The identifier for a GroupMembership in an identity store.
	//
	// MembershipId is a required field
	MembershipId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGroupMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGroupMembershipOutput) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *DescribeGroupMembershipOutput) SetGroupId(v string) *DescribeGroupMembershipOutput {
	s.GroupId = &v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *DescribeGroupMembershipOutput) SetIdentityStoreId(v string) *DescribeGroupMembershipOutput {
	s.IdentityStoreId = &v
	return s
}

// SetMemberId sets the MemberId field's value.
func (s *DescribeGroupMembershipOutput) SetMemberId(v *MemberId) *DescribeGroupMembershipOutput {
	s.MemberId = v
	return s
}

// SetMembershipId sets the MembershipId field's value.
func (s *DescribeGroupMembershipOutput) SetMembershipId(v string) *DescribeGroupMembershipOutput {
	s.MembershipId = &v
	return s
}

type DescribeGroupOutput struct {
	_ struct{} `type:"structure"`

	// A string containing a description of the group.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DescribeGroupOutput's
	// String and GoString methods.
	Description *string `min:"1" type:"string" sensitive:"true"`

	// The group’s display name value. The length limit is 1,024 characters. This
	// value can consist of letters, accented characters, symbols, numbers, punctuation,
	// tab, new line, carriage return, space, and nonbreaking space in this attribute.
	// This value is specified at the time that the group is created and stored
	// as an attribute of the group object in the identity store.
	//
	// DisplayName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DescribeGroupOutput's
	// String and GoString methods.
	DisplayName *string `min:"1" type:"string" sensitive:"true"`

	// A list of ExternalId objects that contains the identifiers issued to this
	// resource by an external identity provider.
	ExternalIds []*ExternalId `min:"1" type:"list"`

	// The identifier for a group in the identity store.
	//
	// GroupId is a required field
	GroupId *string `min:"1" type:"string" required:"true"`

	// The globally unique identifier for the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGroupOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *DescribeGroupOutput) SetDescription(v string) *DescribeGroupOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *DescribeGroupOutput) SetDisplayName(v string) *DescribeGroupOutput {
	s.DisplayName = &v
	return s
}

// SetExternalIds sets the ExternalIds field's value.
func (s *DescribeGroupOutput) SetExternalIds(v []*ExternalId) *DescribeGroupOutput {
	s.ExternalIds = v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *DescribeGroupOutput) SetGroupId(v string) *DescribeGroupOutput {
	s.GroupId = &v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *DescribeGroupOutput) SetIdentityStoreId(v string) *DescribeGroupOutput {
	s.IdentityStoreId = &v
	return s
}

type DescribeUserInput struct {
	_ struct{} `type:"structure"`

	// The globally unique identifier for the identity store, such as d-1234567890.
	// In this example, d- is a fixed prefix, and 1234567890 is a randomly generated
	// string that contains numbers and lower case letters. This value is generated
	// at the time that a new identity store is created.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`

	// The identifier for a user in the identity store.
	//
	// UserId is a required field
	UserId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserInput"}
	if s.IdentityStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStoreId"))
	}
	if s.IdentityStoreId != nil && len(*s.IdentityStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityStoreId", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *DescribeUserInput) SetIdentityStoreId(v string) *DescribeUserInput {
	s.IdentityStoreId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DescribeUserInput) SetUserId(v string) *DescribeUserInput {
	s.UserId = &v
	return s
}

type DescribeUserOutput struct {
	_ struct{} `type:"structure"`

	// The physical address of the user.
	Addresses []*Address `min:"1" type:"list"`

	// The display name of the user.
	//
	// DisplayName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DescribeUserOutput's
	// String and GoString methods.
	DisplayName *string `min:"1" type:"string" sensitive:"true"`

	// The email address of the user.
	Emails []*Email `min:"1" type:"list"`

	// A list of ExternalId objects that contains the identifiers issued to this
	// resource by an external identity provider.
	ExternalIds []*ExternalId `min:"1" type:"list"`

	// The globally unique identifier for the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`

	// A string containing the geographical region or location of the user.
	//
	// Locale is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DescribeUserOutput's
	// String and GoString methods.
	Locale *string `min:"1" type:"string" sensitive:"true"`

	// The name of the user.
	Name *Name `type:"structure"`

	// An alternative descriptive name for the user.
	//
	// NickName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DescribeUserOutput's
	// String and GoString methods.
	NickName *string `min:"1" type:"string" sensitive:"true"`

	// A list of PhoneNumber objects associated with a user.
	PhoneNumbers []*PhoneNumber `min:"1" type:"list"`

	// The preferred language of the user.
	//
	// PreferredLanguage is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DescribeUserOutput's
	// String and GoString methods.
	PreferredLanguage *string `min:"1" type:"string" sensitive:"true"`

	// A URL link for the user's profile.
	//
	// ProfileUrl is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DescribeUserOutput's
	// String and GoString methods.
	ProfileUrl *string `min:"1" type:"string" sensitive:"true"`

	// The time zone for a user.
	//
	// Timezone is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DescribeUserOutput's
	// String and GoString methods.
	Timezone *string `min:"1" type:"string" sensitive:"true"`

	// A string containing the title of the user.
	//
	// Title is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DescribeUserOutput's
	// String and GoString methods.
	Title *string `min:"1" type:"string" sensitive:"true"`

	// The identifier for a user in the identity store.
	//
	// UserId is a required field
	UserId *string `min:"1" type:"string" required:"true"`

	// A unique string used to identify the user. The length limit is 128 characters.
	// This value can consist of letters, accented characters, symbols, numbers,
	// and punctuation. This value is specified at the time the user is created
	// and stored as an attribute of the user object in the identity store.
	//
	// UserName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DescribeUserOutput's
	// String and GoString methods.
	UserName *string `min:"1" type:"string" sensitive:"true"`

	// A string indicating the type of user.
	//
	// UserType is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DescribeUserOutput's
	// String and GoString methods.
	UserType *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserOutput) GoString() string {
	return s.String()
}

// SetAddresses sets the Addresses field's value.
func (s *DescribeUserOutput) SetAddresses(v []*Address) *DescribeUserOutput {
	s.Addresses = v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *DescribeUserOutput) SetDisplayName(v string) *DescribeUserOutput {
	s.DisplayName = &v
	return s
}

// SetEmails sets the Emails field's value.
func (s *DescribeUserOutput) SetEmails(v []*Email) *DescribeUserOutput {
	s.Emails = v
	return s
}

// SetExternalIds sets the ExternalIds field's value.
func (s *DescribeUserOutput) SetExternalIds(v []*ExternalId) *DescribeUserOutput {
	s.ExternalIds = v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *DescribeUserOutput) SetIdentityStoreId(v string) *DescribeUserOutput {
	s.IdentityStoreId = &v
	return s
}

// SetLocale sets the Locale field's value.
func (s *DescribeUserOutput) SetLocale(v string) *DescribeUserOutput {
	s.Locale = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeUserOutput) SetName(v *Name) *DescribeUserOutput {
	s.Name = v
	return s
}

// SetNickName sets the NickName field's value.
func (s *DescribeUserOutput) SetNickName(v string) *DescribeUserOutput {
	s.NickName = &v
	return s
}

// SetPhoneNumbers sets the PhoneNumbers field's value.
func (s *DescribeUserOutput) SetPhoneNumbers(v []*PhoneNumber) *DescribeUserOutput {
	s.PhoneNumbers = v
	return s
}

// SetPreferredLanguage sets the PreferredLanguage field's value.
func (s *DescribeUserOutput) SetPreferredLanguage(v string) *DescribeUserOutput {
	s.PreferredLanguage = &v
	return s
}

// SetProfileUrl sets the ProfileUrl field's value.
func (s *DescribeUserOutput) SetProfileUrl(v string) *DescribeUserOutput {
	s.ProfileUrl = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *DescribeUserOutput) SetTimezone(v string) *DescribeUserOutput {
	s.Timezone = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *DescribeUserOutput) SetTitle(v string) *DescribeUserOutput {
	s.Title = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DescribeUserOutput) SetUserId(v string) *DescribeUserOutput {
	s.UserId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DescribeUserOutput) SetUserName(v string) *DescribeUserOutput {
	s.UserName = &v
	return s
}

// SetUserType sets the UserType field's value.
func (s *DescribeUserOutput) SetUserType(v string) *DescribeUserOutput {
	s.UserType = &v
	return s
}

// The email address associated with the user.
type Email struct {
	_ struct{} `type:"structure"`

	// A Boolean value representing whether this is the primary email address for
	// the associated resource.
	//
	// Primary is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Email's
	// String and GoString methods.
	Primary *bool `type:"boolean" sensitive:"true"`

	// A string representing the type of address. For example, "Work."
	//
	// Type is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Email's
	// String and GoString methods.
	Type *string `min:"1" type:"string" sensitive:"true"`

	// A string containing an email address. For example, "johndoe@amazon.com."
	//
	// Value is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Email's
	// String and GoString methods.
	Value *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Email) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Email) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Email) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Email"}
	if s.Type != nil && len(*s.Type) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Type", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrimary sets the Primary field's value.
func (s *Email) SetPrimary(v bool) *Email {
	s.Primary = &v
	return s
}

// SetType sets the Type field's value.
func (s *Email) SetType(v string) *Email {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Email) SetValue(v string) *Email {
	s.Value = &v
	return s
}

// The identifier issued to this resource by an external identity provider.
type ExternalId struct {
	_ struct{} `type:"structure"`

	// The identifier issued to this resource by an external identity provider.
	//
	// Id is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ExternalId's
	// String and GoString methods.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The issuer for an external identifier.
	//
	// Issuer is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ExternalId's
	// String and GoString methods.
	//
	// Issuer is a required field
	Issuer *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExternalId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExternalId) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExternalId) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExternalId"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Issuer == nil {
		invalidParams.Add(request.NewErrParamRequired("Issuer"))
	}
	if s.Issuer != nil && len(*s.Issuer) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Issuer", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *ExternalId) SetId(v string) *ExternalId {
	s.Id = &v
	return s
}

// SetIssuer sets the Issuer field's value.
func (s *ExternalId) SetIssuer(v string) *ExternalId {
	s.Issuer = &v
	return s
}

// A query filter used by ListUsers and ListGroups. This filter object provides
// the attribute name and attribute value to search users or groups.
type Filter struct {
	_ struct{} `type:"structure"`

	// The attribute path that is used to specify which attribute name to search.
	// Length limit is 255 characters. For example, UserName is a valid attribute
	// path for the ListUsers API, and DisplayName is a valid attribute path for
	// the ListGroups API.
	//
	// AttributePath is a required field
	AttributePath *string `min:"1" type:"string" required:"true"`

	// Represents the data for an attribute. Each attribute value is described as
	// a name-value pair.
	//
	// AttributeValue is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Filter's
	// String and GoString methods.
	//
	// AttributeValue is a required field
	AttributeValue *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.AttributePath == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributePath"))
	}
	if s.AttributePath != nil && len(*s.AttributePath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributePath", 1))
	}
	if s.AttributeValue == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeValue"))
	}
	if s.AttributeValue != nil && len(*s.AttributeValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributePath sets the AttributePath field's value.
func (s *Filter) SetAttributePath(v string) *Filter {
	s.AttributePath = &v
	return s
}

// SetAttributeValue sets the AttributeValue field's value.
func (s *Filter) SetAttributeValue(v string) *Filter {
	s.AttributeValue = &v
	return s
}

type GetGroupIdInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for a user or group that is not the primary identifier.
	// This value can be an identifier from an external identity provider (IdP)
	// that is associated with the user, the group, or a unique attribute. For the
	// unique attribute, the only valid path is displayName.
	//
	// AlternateIdentifier is a required field
	AlternateIdentifier *AlternateIdentifier `type:"structure" required:"true"`

	// The globally unique identifier for the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGroupIdInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGroupIdInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGroupIdInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGroupIdInput"}
	if s.AlternateIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AlternateIdentifier"))
	}
	if s.IdentityStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStoreId"))
	}
	if s.IdentityStoreId != nil && len(*s.IdentityStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityStoreId", 1))
	}
	if s.AlternateIdentifier != nil {
		if err := s.AlternateIdentifier.Validate(); err != nil {
			invalidParams.AddNested("AlternateIdentifier", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlternateIdentifier sets the AlternateIdentifier field's value.
func (s *GetGroupIdInput) SetAlternateIdentifier(v *AlternateIdentifier) *GetGroupIdInput {
	s.AlternateIdentifier = v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *GetGroupIdInput) SetIdentityStoreId(v string) *GetGroupIdInput {
	s.IdentityStoreId = &v
	return s
}

type GetGroupIdOutput struct {
	_ struct{} `type:"structure"`

	// The identifier for a group in the identity store.
	//
	// GroupId is a required field
	GroupId *string `min:"1" type:"string" required:"true"`

	// The globally unique identifier for the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGroupIdOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGroupIdOutput) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *GetGroupIdOutput) SetGroupId(v string) *GetGroupIdOutput {
	s.GroupId = &v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *GetGroupIdOutput) SetIdentityStoreId(v string) *GetGroupIdOutput {
	s.IdentityStoreId = &v
	return s
}

type GetGroupMembershipIdInput struct {
	_ struct{} `type:"structure"`

	// The identifier for a group in the identity store.
	//
	// GroupId is a required field
	GroupId *string `min:"1" type:"string" required:"true"`

	// The globally unique identifier for the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`

	// An object that contains the identifier of a group member. Setting the UserID
	// field to the specific identifier for a user indicates that the user is a
	// member of the group.
	//
	// MemberId is a required field
	MemberId *MemberId `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGroupMembershipIdInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGroupMembershipIdInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGroupMembershipIdInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGroupMembershipIdInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}
	if s.IdentityStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStoreId"))
	}
	if s.IdentityStoreId != nil && len(*s.IdentityStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityStoreId", 1))
	}
	if s.MemberId == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberId"))
	}
	if s.MemberId != nil {
		if err := s.MemberId.Validate(); err != nil {
			invalidParams.AddNested("MemberId", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *GetGroupMembershipIdInput) SetGroupId(v string) *GetGroupMembershipIdInput {
	s.GroupId = &v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *GetGroupMembershipIdInput) SetIdentityStoreId(v string) *GetGroupMembershipIdInput {
	s.IdentityStoreId = &v
	return s
}

// SetMemberId sets the MemberId field's value.
func (s *GetGroupMembershipIdInput) SetMemberId(v *MemberId) *GetGroupMembershipIdInput {
	s.MemberId = v
	return s
}

type GetGroupMembershipIdOutput struct {
	_ struct{} `type:"structure"`

	// The globally unique identifier for the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`

	// The identifier for a GroupMembership in an identity store.
	//
	// MembershipId is a required field
	MembershipId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGroupMembershipIdOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGroupMembershipIdOutput) GoString() string {
	return s.String()
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *GetGroupMembershipIdOutput) SetIdentityStoreId(v string) *GetGroupMembershipIdOutput {
	s.IdentityStoreId = &v
	return s
}

// SetMembershipId sets the MembershipId field's value.
func (s *GetGroupMembershipIdOutput) SetMembershipId(v string) *GetGroupMembershipIdOutput {
	s.MembershipId = &v
	return s
}

type GetUserIdInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for a user or group that is not the primary identifier.
	// This value can be an identifier from an external identity provider (IdP)
	// that is associated with the user, the group, or a unique attribute. For the
	// unique attribute, the only valid paths are userName and emails.value.
	//
	// AlternateIdentifier is a required field
	AlternateIdentifier *AlternateIdentifier `type:"structure" required:"true"`

	// The globally unique identifier for the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserIdInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserIdInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUserIdInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUserIdInput"}
	if s.AlternateIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AlternateIdentifier"))
	}
	if s.IdentityStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStoreId"))
	}
	if s.IdentityStoreId != nil && len(*s.IdentityStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityStoreId", 1))
	}
	if s.AlternateIdentifier != nil {
		if err := s.AlternateIdentifier.Validate(); err != nil {
			invalidParams.AddNested("AlternateIdentifier", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlternateIdentifier sets the AlternateIdentifier field's value.
func (s *GetUserIdInput) SetAlternateIdentifier(v *AlternateIdentifier) *GetUserIdInput {
	s.AlternateIdentifier = v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *GetUserIdInput) SetIdentityStoreId(v string) *GetUserIdInput {
	s.IdentityStoreId = &v
	return s
}

type GetUserIdOutput struct {
	_ struct{} `type:"structure"`

	// The globally unique identifier for the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`

	// The identifier for a user in the identity store.
	//
	// UserId is a required field
	UserId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserIdOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserIdOutput) GoString() string {
	return s.String()
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *GetUserIdOutput) SetIdentityStoreId(v string) *GetUserIdOutput {
	s.IdentityStoreId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *GetUserIdOutput) SetUserId(v string) *GetUserIdOutput {
	s.UserId = &v
	return s
}

// A group object that contains the metadata and attributes for a specified
// group.
type Group struct {
	_ struct{} `type:"structure"`

	// A string containing a description of the specified group.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Group's
	// String and GoString methods.
	Description *string `min:"1" type:"string" sensitive:"true"`

	// The display name value for the group. The length limit is 1,024 characters.
	// This value can consist of letters, accented characters, symbols, numbers,
	// punctuation, tab, new line, carriage return, space, and nonbreaking space
	// in this attribute. This value is specified at the time the group is created
	// and stored as an attribute of the group object in the identity store.
	//
	// DisplayName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Group's
	// String and GoString methods.
	DisplayName *string `min:"1" type:"string" sensitive:"true"`

	// A list of ExternalId objects that contains the identifiers issued to this
	// resource by an external identity provider.
	ExternalIds []*ExternalId `min:"1" type:"list"`

	// The identifier for a group in the identity store.
	//
	// GroupId is a required field
	GroupId *string `min:"1" type:"string" required:"true"`

	// The globally unique identifier for the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Group) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Group) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *Group) SetDescription(v string) *Group {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *Group) SetDisplayName(v string) *Group {
	s.DisplayName = &v
	return s
}

// SetExternalIds sets the ExternalIds field's value.
func (s *Group) SetExternalIds(v []*ExternalId) *Group {
	s.ExternalIds = v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *Group) SetGroupId(v string) *Group {
	s.GroupId = &v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *Group) SetIdentityStoreId(v string) *Group {
	s.IdentityStoreId = &v
	return s
}

// Contains the identifiers for a group, a group member, and a GroupMembership
// object in the identity store.
type GroupMembership struct {
	_ struct{} `type:"structure"`

	// The identifier for a group in the identity store.
	GroupId *string `min:"1" type:"string"`

	// The globally unique identifier for the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`

	// An object that contains the identifier of a group member. Setting the UserID
	// field to the specific identifier for a user indicates that the user is a
	// member of the group.
	MemberId *MemberId `type:"structure"`

	// The identifier for a GroupMembership object in an identity store.
	MembershipId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupMembership) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *GroupMembership) SetGroupId(v string) *GroupMembership {
	s.GroupId = &v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *GroupMembership) SetIdentityStoreId(v string) *GroupMembership {
	s.IdentityStoreId = &v
	return s
}

// SetMemberId sets the MemberId field's value.
func (s *GroupMembership) SetMemberId(v *MemberId) *GroupMembership {
	s.MemberId = v
	return s
}

// SetMembershipId sets the MembershipId field's value.
func (s *GroupMembership) SetMembershipId(v string) *GroupMembership {
	s.MembershipId = &v
	return s
}

// Indicates whether a resource is a member of a group in the identity store.
type GroupMembershipExistenceResult struct {
	_ struct{} `type:"structure"`

	// The identifier for a group in the identity store.
	GroupId *string `min:"1" type:"string"`

	// An object that contains the identifier of a group member. Setting the UserID
	// field to the specific identifier for a user indicates that the user is a
	// member of the group.
	MemberId *MemberId `type:"structure"`

	// Indicates whether a membership relation exists or not.
	//
	// MembershipExists is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GroupMembershipExistenceResult's
	// String and GoString methods.
	MembershipExists *bool `type:"boolean" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupMembershipExistenceResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupMembershipExistenceResult) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *GroupMembershipExistenceResult) SetGroupId(v string) *GroupMembershipExistenceResult {
	s.GroupId = &v
	return s
}

// SetMemberId sets the MemberId field's value.
func (s *GroupMembershipExistenceResult) SetMemberId(v *MemberId) *GroupMembershipExistenceResult {
	s.MemberId = v
	return s
}

// SetMembershipExists sets the MembershipExists field's value.
func (s *GroupMembershipExistenceResult) SetMembershipExists(v bool) *GroupMembershipExistenceResult {
	s.MembershipExists = &v
	return s
}

// The request processing has failed because of an unknown error, exception
// or failure with an internal server.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The identifier for each request. This value is a globally unique ID that
	// is generated by the identity store service for each sent request, and is
	// then returned inside the exception if the request fails.
	RequestId *string `min:"1" type:"string"`

	// The number of seconds to wait before retrying the next request.
	RetryAfterSeconds *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type IsMemberInGroupsInput struct {
	_ struct{} `type:"structure"`

	// A list of identifiers for groups in the identity store.
	//
	// GroupIds is a required field
	GroupIds []*string `min:"1" type:"list" required:"true"`

	// The globally unique identifier for the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`

	// An object containing the identifier of a group member.
	//
	// MemberId is a required field
	MemberId *MemberId `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IsMemberInGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IsMemberInGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IsMemberInGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IsMemberInGroupsInput"}
	if s.GroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupIds"))
	}
	if s.GroupIds != nil && len(s.GroupIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupIds", 1))
	}
	if s.IdentityStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStoreId"))
	}
	if s.IdentityStoreId != nil && len(*s.IdentityStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityStoreId", 1))
	}
	if s.MemberId == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberId"))
	}
	if s.MemberId != nil {
		if err := s.MemberId.Validate(); err != nil {
			invalidParams.AddNested("MemberId", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupIds sets the GroupIds field's value.
func (s *IsMemberInGroupsInput) SetGroupIds(v []*string) *IsMemberInGroupsInput {
	s.GroupIds = v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *IsMemberInGroupsInput) SetIdentityStoreId(v string) *IsMemberInGroupsInput {
	s.IdentityStoreId = &v
	return s
}

// SetMemberId sets the MemberId field's value.
func (s *IsMemberInGroupsInput) SetMemberId(v *MemberId) *IsMemberInGroupsInput {
	s.MemberId = v
	return s
}

type IsMemberInGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing the results of membership existence checks.
	//
	// Results is a required field
	Results []*GroupMembershipExistenceResult `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IsMemberInGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IsMemberInGroupsOutput) GoString() string {
	return s.String()
}

// SetResults sets the Results field's value.
func (s *IsMemberInGroupsOutput) SetResults(v []*GroupMembershipExistenceResult) *IsMemberInGroupsOutput {
	s.Results = v
	return s
}

type ListGroupMembershipsForMemberInput struct {
	_ struct{} `type:"structure"`

	// The globally unique identifier for the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`

	// The maximum number of results to be returned per request. This parameter
	// is used in the ListUsers and ListGroups requests to specify how many results
	// to return in one page. The length limit is 50 characters.
	MaxResults *int64 `min:"1" type:"integer"`

	// An object that contains the identifier of a group member. Setting the UserID
	// field to the specific identifier for a user indicates that the user is a
	// member of the group.
	//
	// MemberId is a required field
	MemberId *MemberId `type:"structure" required:"true"`

	// The pagination token used for the ListUsers, ListGroups, and ListGroupMemberships
	// API operations. This value is generated by the identity store service. It
	// is returned in the API response if the total results are more than the size
	// of one page. This token is also returned when it is used in the API request
	// to search for the next page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGroupMembershipsForMemberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGroupMembershipsForMemberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGroupMembershipsForMemberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGroupMembershipsForMemberInput"}
	if s.IdentityStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStoreId"))
	}
	if s.IdentityStoreId != nil && len(*s.IdentityStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityStoreId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MemberId == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberId"))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.MemberId != nil {
		if err := s.MemberId.Validate(); err != nil {
			invalidParams.AddNested("MemberId", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *ListGroupMembershipsForMemberInput) SetIdentityStoreId(v string) *ListGroupMembershipsForMemberInput {
	s.IdentityStoreId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGroupMembershipsForMemberInput) SetMaxResults(v int64) *ListGroupMembershipsForMemberInput {
	s.MaxResults = &v
	return s
}

// SetMemberId sets the MemberId field's value.
func (s *ListGroupMembershipsForMemberInput) SetMemberId(v *MemberId) *ListGroupMembershipsForMemberInput {
	s.MemberId = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupMembershipsForMemberInput) SetNextToken(v string) *ListGroupMembershipsForMemberInput {
	s.NextToken = &v
	return s
}

type ListGroupMembershipsForMemberOutput struct {
	_ struct{} `type:"structure"`

	// A list of GroupMembership objects in the group for a specified member.
	//
	// GroupMemberships is a required field
	GroupMemberships []*GroupMembership `type:"list" required:"true"`

	// The pagination token used for the ListUsers, ListGroups, and ListGroupMemberships
	// API operations. This value is generated by the identity store service. It
	// is returned in the API response if the total results are more than the size
	// of one page. This token is also returned when it is used in the API request
	// to search for the next page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGroupMembershipsForMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGroupMembershipsForMemberOutput) GoString() string {
	return s.String()
}

// SetGroupMemberships sets the GroupMemberships field's value.
func (s *ListGroupMembershipsForMemberOutput) SetGroupMemberships(v []*GroupMembership) *ListGroupMembershipsForMemberOutput {
	s.GroupMemberships = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupMembershipsForMemberOutput) SetNextToken(v string) *ListGroupMembershipsForMemberOutput {
	s.NextToken = &v
	return s
}

type ListGroupMembershipsInput struct {
	_ struct{} `type:"structure"`

	// The identifier for a group in the identity store.
	//
	// GroupId is a required field
	GroupId *string `min:"1" type:"string" required:"true"`

	// The globally unique identifier for the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`

	// The maximum number of results to be returned per request. This parameter
	// is used in all List requests to specify how many results to return in one
	// page.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token used for the ListUsers, ListGroups and ListGroupMemberships
	// API operations. This value is generated by the identity store service. It
	// is returned in the API response if the total results are more than the size
	// of one page. This token is also returned when it is used in the API request
	// to search for the next page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGroupMembershipsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGroupMembershipsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGroupMembershipsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGroupMembershipsInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}
	if s.IdentityStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStoreId"))
	}
	if s.IdentityStoreId != nil && len(*s.IdentityStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityStoreId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *ListGroupMembershipsInput) SetGroupId(v string) *ListGroupMembershipsInput {
	s.GroupId = &v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *ListGroupMembershipsInput) SetIdentityStoreId(v string) *ListGroupMembershipsInput {
	s.IdentityStoreId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGroupMembershipsInput) SetMaxResults(v int64) *ListGroupMembershipsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupMembershipsInput) SetNextToken(v string) *ListGroupMembershipsInput {
	s.NextToken = &v
	return s
}

type ListGroupMembershipsOutput struct {
	_ struct{} `type:"structure"`

	// A list of GroupMembership objects in the group.
	//
	// GroupMemberships is a required field
	GroupMemberships []*GroupMembership `type:"list" required:"true"`

	// The pagination token used for the ListUsers, ListGroups, and ListGroupMemberships
	// API operations. This value is generated by the identity store service. It
	// is returned in the API response if the total results are more than the size
	// of one page. This token is also returned when it is used in the API request
	// to search for the next page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGroupMembershipsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGroupMembershipsOutput) GoString() string {
	return s.String()
}

// SetGroupMemberships sets the GroupMemberships field's value.
func (s *ListGroupMembershipsOutput) SetGroupMemberships(v []*GroupMembership) *ListGroupMembershipsOutput {
	s.GroupMemberships = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupMembershipsOutput) SetNextToken(v string) *ListGroupMembershipsOutput {
	s.NextToken = &v
	return s
}

type ListGroupsInput struct {
	_ struct{} `type:"structure"`

	// A list of Filter objects, which is used in the ListUsers and ListGroups requests.
	//
	// Deprecated: Using filters with ListGroups API is deprecated, please use GetGroupId API instead.
	Filters []*Filter `deprecated:"true" type:"list"`

	// The globally unique identifier for the identity store, such as d-1234567890.
	// In this example, d- is a fixed prefix, and 1234567890 is a randomly generated
	// string that contains numbers and lower case letters. This value is generated
	// at the time that a new identity store is created.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`

	// The maximum number of results to be returned per request. This parameter
	// is used in the ListUsers and ListGroups requests to specify how many results
	// to return in one page. The length limit is 50 characters.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token used for the ListUsers and ListGroups API operations.
	// This value is generated by the identity store service. It is returned in
	// the API response if the total results are more than the size of one page.
	// This token is also returned when it is used in the API request to search
	// for the next page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGroupsInput"}
	if s.IdentityStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStoreId"))
	}
	if s.IdentityStoreId != nil && len(*s.IdentityStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityStoreId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListGroupsInput) SetFilters(v []*Filter) *ListGroupsInput {
	s.Filters = v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *ListGroupsInput) SetIdentityStoreId(v string) *ListGroupsInput {
	s.IdentityStoreId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGroupsInput) SetMaxResults(v int64) *ListGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupsInput) SetNextToken(v string) *ListGroupsInput {
	s.NextToken = &v
	return s
}

type ListGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of Group objects in the identity store.
	//
	// Groups is a required field
	Groups []*Group `type:"list" required:"true"`

	// The pagination token used for the ListUsers and ListGroups API operations.
	// This value is generated by the identity store service. It is returned in
	// the API response if the total results are more than the size of one page.
	// This token is also returned when it1 is used in the API request to search
	// for the next page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGroupsOutput) GoString() string {
	return s.String()
}

// SetGroups sets the Groups field's value.
func (s *ListGroupsOutput) SetGroups(v []*Group) *ListGroupsOutput {
	s.Groups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupsOutput) SetNextToken(v string) *ListGroupsOutput {
	s.NextToken = &v
	return s
}

type ListUsersInput struct {
	_ struct{} `type:"structure"`

	// A list of Filter objects, which is used in the ListUsers and ListGroups requests.
	//
	// Deprecated: Using filters with ListUsers API is deprecated, please use GetGroupId API instead.
	Filters []*Filter `deprecated:"true" type:"list"`

	// The globally unique identifier for the identity store, such as d-1234567890.
	// In this example, d- is a fixed prefix, and 1234567890 is a randomly generated
	// string that contains numbers and lower case letters. This value is generated
	// at the time that a new identity store is created.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`

	// The maximum number of results to be returned per request. This parameter
	// is used in the ListUsers and ListGroups requests to specify how many results
	// to return in one page. The length limit is 50 characters.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token used for the ListUsers and ListGroups API operations.
	// This value is generated by the identity store service. It is returned in
	// the API response if the total results are more than the size of one page.
	// This token is also returned when it is used in the API request to search
	// for the next page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUsersInput"}
	if s.IdentityStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStoreId"))
	}
	if s.IdentityStoreId != nil && len(*s.IdentityStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityStoreId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListUsersInput) SetFilters(v []*Filter) *ListUsersInput {
	s.Filters = v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *ListUsersInput) SetIdentityStoreId(v string) *ListUsersInput {
	s.IdentityStoreId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUsersInput) SetMaxResults(v int64) *ListUsersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersInput) SetNextToken(v string) *ListUsersInput {
	s.NextToken = &v
	return s
}

type ListUsersOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token used for the ListUsers and ListGroups API operations.
	// This value is generated by the identity store service. It is returned in
	// the API response if the total results are more than the size of one page.
	// This token is also returned when it is used in the API request to search
	// for the next page.
	NextToken *string `min:"1" type:"string"`

	// A list of User objects in the identity store.
	//
	// Users is a required field
	Users []*User `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUsersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersOutput) SetNextToken(v string) *ListUsersOutput {
	s.NextToken = &v
	return s
}

// SetUsers sets the Users field's value.
func (s *ListUsersOutput) SetUsers(v []*User) *ListUsersOutput {
	s.Users = v
	return s
}

// An object containing the identifier of a group member.
type MemberId struct {
	_ struct{} `type:"structure"`

	// An object containing the identifiers of resources that can be members.
	UserId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemberId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemberId) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MemberId) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MemberId"}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserId sets the UserId field's value.
func (s *MemberId) SetUserId(v string) *MemberId {
	s.UserId = &v
	return s
}

// The full name of the user.
type Name struct {
	_ struct{} `type:"structure"`

	// The family name of the user.
	//
	// FamilyName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Name's
	// String and GoString methods.
	FamilyName *string `min:"1" type:"string" sensitive:"true"`

	// A string containing a formatted version of the name for display.
	//
	// Formatted is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Name's
	// String and GoString methods.
	Formatted *string `min:"1" type:"string" sensitive:"true"`

	// The given name of the user.
	//
	// GivenName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Name's
	// String and GoString methods.
	GivenName *string `min:"1" type:"string" sensitive:"true"`

	// The honorific prefix of the user. For example, "Dr."
	//
	// HonorificPrefix is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Name's
	// String and GoString methods.
	HonorificPrefix *string `min:"1" type:"string" sensitive:"true"`

	// The honorific suffix of the user. For example, "M.D."
	//
	// HonorificSuffix is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Name's
	// String and GoString methods.
	HonorificSuffix *string `min:"1" type:"string" sensitive:"true"`

	// The middle name of the user.
	//
	// MiddleName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Name's
	// String and GoString methods.
	MiddleName *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Name) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Name) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Name) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Name"}
	if s.FamilyName != nil && len(*s.FamilyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FamilyName", 1))
	}
	if s.Formatted != nil && len(*s.Formatted) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Formatted", 1))
	}
	if s.GivenName != nil && len(*s.GivenName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GivenName", 1))
	}
	if s.HonorificPrefix != nil && len(*s.HonorificPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HonorificPrefix", 1))
	}
	if s.HonorificSuffix != nil && len(*s.HonorificSuffix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HonorificSuffix", 1))
	}
	if s.MiddleName != nil && len(*s.MiddleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MiddleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFamilyName sets the FamilyName field's value.
func (s *Name) SetFamilyName(v string) *Name {
	s.FamilyName = &v
	return s
}

// SetFormatted sets the Formatted field's value.
func (s *Name) SetFormatted(v string) *Name {
	s.Formatted = &v
	return s
}

// SetGivenName sets the GivenName field's value.
func (s *Name) SetGivenName(v string) *Name {
	s.GivenName = &v
	return s
}

// SetHonorificPrefix sets the HonorificPrefix field's value.
func (s *Name) SetHonorificPrefix(v string) *Name {
	s.HonorificPrefix = &v
	return s
}

// SetHonorificSuffix sets the HonorificSuffix field's value.
func (s *Name) SetHonorificSuffix(v string) *Name {
	s.HonorificSuffix = &v
	return s
}

// SetMiddleName sets the MiddleName field's value.
func (s *Name) SetMiddleName(v string) *Name {
	s.MiddleName = &v
	return s
}

// The phone number associated with the user.
type PhoneNumber struct {
	_ struct{} `type:"structure"`

	// A Boolean value representing whether this is the primary phone number for
	// the associated resource.
	//
	// Primary is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PhoneNumber's
	// String and GoString methods.
	Primary *bool `type:"boolean" sensitive:"true"`

	// A string representing the type of a phone number. For example, "Mobile."
	//
	// Type is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PhoneNumber's
	// String and GoString methods.
	Type *string `min:"1" type:"string" sensitive:"true"`

	// A string containing a phone number. For example, "8675309" or "+1 (800) 123-4567".
	//
	// Value is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PhoneNumber's
	// String and GoString methods.
	Value *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhoneNumber) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhoneNumber) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PhoneNumber) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PhoneNumber"}
	if s.Type != nil && len(*s.Type) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Type", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrimary sets the Primary field's value.
func (s *PhoneNumber) SetPrimary(v bool) *PhoneNumber {
	s.Primary = &v
	return s
}

// SetType sets the Type field's value.
func (s *PhoneNumber) SetType(v string) *PhoneNumber {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *PhoneNumber) SetValue(v string) *PhoneNumber {
	s.Value = &v
	return s
}

// Indicates that a requested resource is not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The identifier for each request. This value is a globally unique ID that
	// is generated by the identity store service for each sent request, and is
	// then returned inside the exception if the request fails.
	RequestId *string `min:"1" type:"string"`

	// The identifier for a resource in the identity store that can be used as UserId
	// or GroupId. The format for ResourceId is either UUID or 1234567890-UUID,
	// where UUID is a randomly generated value for each resource when it is created
	// and 1234567890 represents the IdentityStoreId string value. In the case that
	// the identity store is migrated from a legacy SSO identity store, the ResourceId
	// for that identity store will be in the format of UUID. Otherwise, it will
	// be in the 1234567890-UUID format.
	ResourceId *string `min:"1" type:"string"`

	// An enum object indicating the type of resource in the identity store service.
	// Valid values include USER, GROUP, and IDENTITY_STORE.
	ResourceType *string `type:"string" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request would cause the number of users or groups in the identity store
// to exceed the maximum allowed.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The identifier for each request. This value is a globally unique ID that
	// is generated by the identity store service for each sent request, and is
	// then returned inside the exception if the request fails.
	RequestId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Indicates that the principal has crossed the throttling limits of the API
// operations.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The identifier for each request. This value is a globally unique ID that
	// is generated by the identity store service for each sent request, and is
	// then returned inside the exception if the request fails.
	RequestId *string `min:"1" type:"string"`

	// The number of seconds to wait before retrying the next request.
	RetryAfterSeconds *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier for a group in the identity store.
	//
	// GroupId is a required field
	GroupId *string `min:"1" type:"string" required:"true"`

	// The globally unique identifier for the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`

	// A list of AttributeOperation objects to apply to the requested group. These
	// operations might add, replace, or remove an attribute.
	//
	// Operations is a required field
	Operations []*AttributeOperation `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}
	if s.IdentityStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStoreId"))
	}
	if s.IdentityStoreId != nil && len(*s.IdentityStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityStoreId", 1))
	}
	if s.Operations == nil {
		invalidParams.Add(request.NewErrParamRequired("Operations"))
	}
	if s.Operations != nil && len(s.Operations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Operations", 1))
	}
	if s.Operations != nil {
		for i, v := range s.Operations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Operations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *UpdateGroupInput) SetGroupId(v string) *UpdateGroupInput {
	s.GroupId = &v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *UpdateGroupInput) SetIdentityStoreId(v string) *UpdateGroupInput {
	s.IdentityStoreId = &v
	return s
}

// SetOperations sets the Operations field's value.
func (s *UpdateGroupInput) SetOperations(v []*AttributeOperation) *UpdateGroupInput {
	s.Operations = v
	return s
}

type UpdateGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGroupOutput) GoString() string {
	return s.String()
}

type UpdateUserInput struct {
	_ struct{} `type:"structure"`

	// The globally unique identifier for the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`

	// A list of AttributeOperation objects to apply to the requested user. These
	// operations might add, replace, or remove an attribute.
	//
	// Operations is a required field
	Operations []*AttributeOperation `min:"1" type:"list" required:"true"`

	// The identifier for a user in the identity store.
	//
	// UserId is a required field
	UserId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserInput"}
	if s.IdentityStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStoreId"))
	}
	if s.IdentityStoreId != nil && len(*s.IdentityStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityStoreId", 1))
	}
	if s.Operations == nil {
		invalidParams.Add(request.NewErrParamRequired("Operations"))
	}
	if s.Operations != nil && len(s.Operations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Operations", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}
	if s.Operations != nil {
		for i, v := range s.Operations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Operations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *UpdateUserInput) SetIdentityStoreId(v string) *UpdateUserInput {
	s.IdentityStoreId = &v
	return s
}

// SetOperations sets the Operations field's value.
func (s *UpdateUserInput) SetOperations(v []*AttributeOperation) *UpdateUserInput {
	s.Operations = v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UpdateUserInput) SetUserId(v string) *UpdateUserInput {
	s.UserId = &v
	return s
}

type UpdateUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUserOutput) GoString() string {
	return s.String()
}

// A user object that contains the metadata and attributes for a specified user.
type User struct {
	_ struct{} `type:"structure"`

	// A list of Address objects containing addresses associated with the user.
	Addresses []*Address `min:"1" type:"list"`

	// A string containing the name of the user that is formatted for display when
	// the user is referenced. For example, "John Doe."
	//
	// DisplayName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by User's
	// String and GoString methods.
	DisplayName *string `min:"1" type:"string" sensitive:"true"`

	// A list of Email objects containing email addresses associated with the user.
	Emails []*Email `min:"1" type:"list"`

	// A list of ExternalId objects that contains the identifiers issued to this
	// resource by an external identity provider.
	ExternalIds []*ExternalId `min:"1" type:"list"`

	// The globally unique identifier for the identity store.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `min:"1" type:"string" required:"true"`

	// A string containing the geographical region or location of the user.
	//
	// Locale is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by User's
	// String and GoString methods.
	Locale *string `min:"1" type:"string" sensitive:"true"`

	// An object containing the name of the user.
	Name *Name `type:"structure"`

	// A string containing an alternate name for the user.
	//
	// NickName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by User's
	// String and GoString methods.
	NickName *string `min:"1" type:"string" sensitive:"true"`

	// A list of PhoneNumber objects containing phone numbers associated with the
	// user.
	PhoneNumbers []*PhoneNumber `min:"1" type:"list"`

	// A string containing the preferred language of the user. For example, "American
	// English" or "en-us."
	//
	// PreferredLanguage is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by User's
	// String and GoString methods.
	PreferredLanguage *string `min:"1" type:"string" sensitive:"true"`

	// A string containing a URL that might be associated with the user.
	//
	// ProfileUrl is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by User's
	// String and GoString methods.
	ProfileUrl *string `min:"1" type:"string" sensitive:"true"`

	// A string containing the time zone of the user.
	//
	// Timezone is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by User's
	// String and GoString methods.
	Timezone *string `min:"1" type:"string" sensitive:"true"`

	// A string containing the title of the user. Possible values are left unspecified.
	// The value can vary based on your specific use case.
	//
	// Title is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by User's
	// String and GoString methods.
	Title *string `min:"1" type:"string" sensitive:"true"`

	// The identifier for a user in the identity store.
	//
	// UserId is a required field
	UserId *string `min:"1" type:"string" required:"true"`

	// A unique string used to identify the user. The length limit is 128 characters.
	// This value can consist of letters, accented characters, symbols, numbers,
	// and punctuation. This value is specified at the time the user is created
	// and stored as an attribute of the user object in the identity store.
	//
	// UserName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by User's
	// String and GoString methods.
	UserName *string `min:"1" type:"string" sensitive:"true"`

	// A string indicating the type of user. Possible values are left unspecified.
	// The value can vary based on your specific use case.
	//
	// UserType is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by User's
	// String and GoString methods.
	UserType *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s User) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s User) GoString() string {
	return s.String()
}

// SetAddresses sets the Addresses field's value.
func (s *User) SetAddresses(v []*Address) *User {
	s.Addresses = v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *User) SetDisplayName(v string) *User {
	s.DisplayName = &v
	return s
}

// SetEmails sets the Emails field's value.
func (s *User) SetEmails(v []*Email) *User {
	s.Emails = v
	return s
}

// SetExternalIds sets the ExternalIds field's value.
func (s *User) SetExternalIds(v []*ExternalId) *User {
	s.ExternalIds = v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *User) SetIdentityStoreId(v string) *User {
	s.IdentityStoreId = &v
	return s
}

// SetLocale sets the Locale field's value.
func (s *User) SetLocale(v string) *User {
	s.Locale = &v
	return s
}

// SetName sets the Name field's value.
func (s *User) SetName(v *Name) *User {
	s.Name = v
	return s
}

// SetNickName sets the NickName field's value.
func (s *User) SetNickName(v string) *User {
	s.NickName = &v
	return s
}

// SetPhoneNumbers sets the PhoneNumbers field's value.
func (s *User) SetPhoneNumbers(v []*PhoneNumber) *User {
	s.PhoneNumbers = v
	return s
}

// SetPreferredLanguage sets the PreferredLanguage field's value.
func (s *User) SetPreferredLanguage(v string) *User {
	s.PreferredLanguage = &v
	return s
}

// SetProfileUrl sets the ProfileUrl field's value.
func (s *User) SetProfileUrl(v string) *User {
	s.ProfileUrl = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *User) SetTimezone(v string) *User {
	s.Timezone = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *User) SetTitle(v string) *User {
	s.Title = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *User) SetUserId(v string) *User {
	s.UserId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *User) SetUserName(v string) *User {
	s.UserName = &v
	return s
}

// SetUserType sets the UserType field's value.
func (s *User) SetUserType(v string) *User {
	s.UserType = &v
	return s
}

// The request failed because it contains a syntax error.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The identifier for each request. This value is a globally unique ID that
	// is generated by the identity store service for each sent request, and is
	// then returned inside the exception if the request fails.
	RequestId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// ConflictExceptionReasonUniquenessConstraintViolation is a ConflictExceptionReason enum value
	ConflictExceptionReasonUniquenessConstraintViolation = "UNIQUENESS_CONSTRAINT_VIOLATION"

	// ConflictExceptionReasonConcurrentModification is a ConflictExceptionReason enum value
	ConflictExceptionReasonConcurrentModification = "CONCURRENT_MODIFICATION"
)

// ConflictExceptionReason_Values returns all elements of the ConflictExceptionReason enum
func ConflictExceptionReason_Values() []string {
	return []string{
		ConflictExceptionReasonUniquenessConstraintViolation,
		ConflictExceptionReasonConcurrentModification,
	}
}

const (
	// ResourceTypeGroup is a ResourceType enum value
	ResourceTypeGroup = "GROUP"

	// ResourceTypeUser is a ResourceType enum value
	ResourceTypeUser = "USER"

	// ResourceTypeIdentityStore is a ResourceType enum value
	ResourceTypeIdentityStore = "IDENTITY_STORE"

	// ResourceTypeGroupMembership is a ResourceType enum value
	ResourceTypeGroupMembership = "GROUP_MEMBERSHIP"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeGroup,
		ResourceTypeUser,
		ResourceTypeIdentityStore,
		ResourceTypeGroupMembership,
	}
}
