package util

import "testing"

func TestValidURL(t *testing.T) {
	var m = map[string]bool{
		"https://mycorrhiza.wiki": true,
		"mycorrhiza.wiki":         false,
		// These two don't really make much sense, but are valid nevertheless:
		"https://": true,
		"https:":   true,
		// We support more protocols:
		"gemini://mycorrhiza.wiki": true,
		// We actually support all of them:
		"madeupprotocol://mycorrhiza.wiki": true,
		// Some protocols are not valid per spec:
		"хвастовство://mycorrhiza.wiki": false,
		// There are protocols without //:
		"mailto:wikimind@mycorrhiza.wiki": true,
		// Not here:
		"/горемыка": false,
		// Definitely not here:
		"горемыка": false,
		// I found this special treatment of * in Go's source code, but didn't find any mention of it in URL spec. I guess that's some special Go trickity tricksy tricks? One can cope.
		"*": false,
	}
	for url, expectedResult := range m {
		actualResult := ValidURL(url)
		if expectedResult != actualResult {
			t.Errorf("Re: %s. Expected %t, got %t\n", url, expectedResult, actualResult)
		}
	}
}
