// Code generated by go-bindata.
// sources:
// test-certs/CA.crl
// test-certs/CA.crt
// test-certs/CA.key
// test-certs/client.crt
// test-certs/client.key
// test-certs/invalid-ca.crt
// test-certs/metron.csr
// test-certs/reverselogproxy.csr
// test-certs/server.crt
// test-certs/server.key
// DO NOT EDIT!

package loggregator_test

import (
	"fmt"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)
type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _caCrl = []byte(`-----BEGIN X509 CRL-----
MIIChzBxAgEBMA0GCSqGSIb3DQEBCwUAMBgxFjAUBgNVBAMTDWxvZ2dyZWdhdG9y
Q0EXDTE5MDQyNDE3MDc0OVoXDTQ0MDQyNDE3MDc0NlowAKAjMCEwHwYDVR0jBBgw
FoAUg4B/qbFpBcOBFH5w/mh7PU8PATAwDQYJKoZIhvcNAQELBQADggIBABVW9PBN
RkZN4gn0zBQAgeCbF5/gyUjYgzSFmXGELGKjxuHWh2mhywHAhCCKXRzautSAG6WD
FGOlr6zN0uaD9wneNDySsa1oXnfDsXBd8G4TpCracijWcqVfA0P9Jh+ZNlmwk7uK
DdlBBg/SYfBZ32oIzYQSdw5jqedXD8u9y9On4Ll6CvHdfh0Eev55bWiJjXezvxM7
5+bPeH6N5ddJdDa62OwDg/LA0VWdja+F3ZJEJyjn4ysHMNGM8vsoa5C8qGPPX/bu
rZd4NGV250py4C8dQea1kYrz1LFFIQ9hE6NBfLReQk4/Hcfdk1DPR7JJ4LyIcHbB
FUIAvALnaPkGxIzxwmgVRrbFnjjh2rXoQzFnqA3gaxfIJHbnjPBQ1Ee7cniA9rnU
9Nwfz+rxOpbYWa7YOJeSf7JELhfR5w5x58KzfMCAQ+bizcwZaxOxNGxjbhYdleJt
+C7v22bArAgt3VzFSUY3BWtV4RRelBUlyx9R+bm6yZBSC0z02JFMecOYnFt38CMa
GBPCFDBEskdMH8gIx276tzenrxxamCPWUOk+lOeEiRkm12sYkAberQ9ZfmKFAK1n
/SO5dgWwsLjsVBhGuAYTy4rfP2rTEri5ohLEdYXa7orsL9Pb9Xd6DGhwh+7bbV1W
RsIFc77oMBrqCeJjbHBuz/X6HTwKUsfsRhby
-----END X509 CRL-----
`)

func caCrlBytes() ([]byte, error) {
	return _caCrl, nil
}

func caCrl() (*asset, error) {
	bytes, err := caCrlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "CA.crl", size: 930, mode: os.FileMode(292), modTime: time.Unix(1556125669, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _caCrt = []byte(`-----BEGIN CERTIFICATE-----
MIIE8DCCAtigAwIBAgIBATANBgkqhkiG9w0BAQsFADAYMRYwFAYDVQQDEw1sb2dn
cmVnYXRvckNBMB4XDTE5MDQyNDE3MDc0NloXDTQ0MDQyNDE3MDc0NlowGDEWMBQG
A1UEAxMNbG9nZ3JlZ2F0b3JDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoC
ggIBALmMn9KzSdbraAR5aySufPKPk/dEVVNPCDit2PZvhODf6M5w3cPYTytJ106J
5BFivTlcFZmrvN/KPRcMxFG8Zqt39GaDA9fa6MzrGZDhR1pUlyl8NZ5xhBdxlO+x
e9iXpc6jG5X2HyZSPQy5CBzUD0EX3Y/pRFwaD9h7GUce0aM5Oe6uAndgxSeO6Tn9
0vyf34aSPCGxvFEhyimJp9cC5uM9xlISlVN98jdPS24TjRtoDGqorTN4jCOPbYw1
y6U8ddSr5k3aK3Ritt2IAEp7lzfWJ+vdnnJJTQbqHsUlz9ojAt/6H0R1T8ek4g1/
qTlaIz7THeDfgwX+aBSrIf7j5o0ypSAR0vWZ6VgvtrsUKjYhEjfBfLoUIzj9eqSr
O+iMU+TtYvz0WYXJxNP//+s/QIWSblFbQP/YwMqLYkR2tQIQOTE75AKBz9/EeTHG
yGMCkazwh4cHAE5R2PqZfLZmklMd5sf8LDYnyF2DkrcckSrZerRs/YwxLjV8QJM8
9RQ1kFkl64eNdqTm0COPN8Edn1KmiYvBt4pGUSZgLk2DoOwAKRQb96PFn8jLwlf9
aokOYI7OHVR+WQJ02F/W9qw8YDvh2Ob++azzORvGESDq3Jz8wm0X5eWgLBb2xVdU
GolEYt2mG87N1V9Wfq2EepFC/5Zoz5eFx87uIUdL7etacv6hAgMBAAGjRTBDMA4G
A1UdDwEB/wQEAwIBBjASBgNVHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBSDgH+p
sWkFw4EUfnD+aHs9Tw8BMDANBgkqhkiG9w0BAQsFAAOCAgEAKvLYIh2NlHVTI2aa
CrEvUaZB0um/dOPFRErwS7R4WrNVHABiilL0YlNX99WQjbvM8zT6N+DvGGTLOmk0
TEnPFr6k8/OBROeznYCaft8K7JxDyc7PD6uDvfIjt2AHq/Wj9CT8F+8AyUxohwsl
lWrJIh/bckccpek5m0XcxhxTNlUStZG9Kf/xaijYawSeq7NLNPSeME9RIQzPztOu
7wpBURFku8L2s2Jx1Eq2QrMOBSD23kVtaE0+HgTXi3p+PrW/WIut0Y0v7qHg6aTE
0gRXvdHMlJiYY+nB41/NjUWsBL/vi9q+kqFX30E/ncfCwV9L4kSPe0mOvl214fQV
aIjSaUTAqXU42qICuQAbq4klC7IPfTOkDZN5biZawXHJCRRl8WYMGl5sRugGO8u8
RHd6rjE576j9EUTnjCLp/H7fgADvDoWw+vFwbSMhiw7S0Oj1gj1SQNa0T5FdUY4y
hOtvcAL7AK+CNJXvcYmVtjQ1HSmzHVd4H1RCXIoQvluD0tQ+VbeXp7Ln7Pu2OAZw
0X/S/ZZjkRzavLj3IevTk6PamjOjnbe6cVtICzHR5jfA3JS2rawguZglG6mibRg2
eIH4W9klZpNOS9924b7KUBNb3be7hjLbqOQWuyLY5ZMW1SZCAeGDZG5evRg0ox8A
ZciArRrk4q/arclpS32gPrnxTGY=
-----END CERTIFICATE-----
`)

func caCrtBytes() ([]byte, error) {
	return _caCrt, nil
}

func caCrt() (*asset, error) {
	bytes, err := caCrtBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "CA.crt", size: 1773, mode: os.FileMode(292), modTime: time.Unix(1556125669, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _caKey = []byte(`-----BEGIN RSA PRIVATE KEY-----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-----END RSA PRIVATE KEY-----
`)

func caKeyBytes() ([]byte, error) {
	return _caKey, nil
}

func caKey() (*asset, error) {
	bytes, err := caKeyBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "CA.key", size: 3243, mode: os.FileMode(288), modTime: time.Unix(1556125669, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _clientCrt = []byte(`-----BEGIN CERTIFICATE-----
MIIELjCCAhagAwIBAgIRALJVcrTiNDuQFTCyRNfNdI4wDQYJKoZIhvcNAQELBQAw
GDEWMBQGA1UEAxMNbG9nZ3JlZ2F0b3JDQTAeFw0xOTA0MjQxNzA3NTBaFw00NDA0
MjQxNzA3NDZaMBoxGDAWBgNVBAMTD3JldmVyc2Vsb2dwcm94eTCCASIwDQYJKoZI
hvcNAQEBBQADggEPADCCAQoCggEBAMJW+b8+F3ExJN9Lyk45x4cN1zJwPdjVFmQF
1Haf+j3mIRWXnPNXRwpEFenUnmkAO0mzk6kRss55LDywmbL5J5Mg8WKBO5ZMAdtq
EUVwO8zr6v99gOdpGNzyoY1keSfzQqf4OgLtdtYY3CaSOgt462/ARszyUD6DGkjr
iWEf3nAElaHXtqDGeOHhpcqLMcpuCmyNpruMf6elWBDpcSyDmOHOkJS4xEajNVNh
KKG69A1ha2+swO+yfn4aNXWN8pFksXBBR7cgZ516RIjYJ77jIcclVJAn75nsFQlt
LlEVOj9pzwQD653XJNg7KDTeb6zrMi4DtXNHIyuwey9IgU2Jo+MCAwEAAaNxMG8w
DgYDVR0PAQH/BAQDAgO4MB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAd
BgNVHQ4EFgQUslmYGO+0U+sGURmnvbWNBfm0JMcwHwYDVR0jBBgwFoAUg4B/qbFp
BcOBFH5w/mh7PU8PATAwDQYJKoZIhvcNAQELBQADggIBAE9EMasvURfExkwWOoeC
stVnONG/8rXPe0rFIpxCv3961yhe6fm9XbGwTAU7uzUAVBE+dvrNJR44ulxFl5LN
3HyywOLtiJdV8cY913PPMBfJAvUmqM9i9Sdh+dIhof6CKD6oGiWP2+bUXJ0iMgGK
vIWMMxzV7nrTXXteGIIPIJ4pdMoiBZBu+yVXTbPTMGyIZsaT95cRIi/CR15Lz07n
MoMbmYrU/7TsSu2h0Ztzd36XOkk4F0M1WrrOV5326uCtdlG5aDUUhkvGihux7pzr
tXtqbHgaqG/HcxjqmD4iDqktgRQMBibzQ+V0UcjJOASk64nZz+2YdPGesVEZ7xUQ
LwCoDfLgIizRfC3YPHn2H8dKl4qMaNMgx2aAsrf6jBzAOgt7MoCjB9SoNkVTAqjV
SpDAtpJGBuX0lt/Yqy4nNdKS4mdcOIb852Hvje1/Y9NqrVYxrbnKrUUggVK2ohtP
7JzfVhZCWPQEfkVjN75R60kKszjywMZk38o7Bh/msOCFFccUcxd4ZhFYWq/nqI/g
MpNgds7GtmrQnkegkNMdiZqwqKFEoi9sknk0LSO6QwO7J7+Uv/80GoD+iitIx1gm
hgJFCf74oFX0Xj2HuILrkZQd0QPXJyQS5O+iRMOZZ8P2W5ka2QoiblA48/w0Tf0I
+Bv7klNvMyhAiXii4/ykhtKL
-----END CERTIFICATE-----
`)

func clientCrtBytes() ([]byte, error) {
	return _clientCrt, nil
}

func clientCrt() (*asset, error) {
	bytes, err := clientCrtBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "client.crt", size: 1509, mode: os.FileMode(292), modTime: time.Unix(1556125670, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _clientKey = []byte(`-----BEGIN RSA PRIVATE KEY-----
MIIEogIBAAKCAQEAwlb5vz4XcTEk30vKTjnHhw3XMnA92NUWZAXUdp/6PeYhFZec
81dHCkQV6dSeaQA7SbOTqRGyznksPLCZsvknkyDxYoE7lkwB22oRRXA7zOvq/32A
52kY3PKhjWR5J/NCp/g6Au121hjcJpI6C3jrb8BGzPJQPoMaSOuJYR/ecASVode2
oMZ44eGlyosxym4KbI2mu4x/p6VYEOlxLIOY4c6QlLjERqM1U2Eoobr0DWFrb6zA
77J+fho1dY3ykWSxcEFHtyBnnXpEiNgnvuMhxyVUkCfvmewVCW0uURU6P2nPBAPr
ndck2DsoNN5vrOsyLgO1c0cjK7B7L0iBTYmj4wIDAQABAoIBAGAuUY5vuYRg0SHe
TbKnb/OMSwwAduuAkoNQS1WmWWAXLBqWnavlbxhKmBnRC9FltvID+Tl8s+TyHY2v
zXHBU+/CJxUcZpQ869JezUtzf3Us8XIe+BQPdKmtP31N05SNFVkyReu7AMx3I0XH
qwiQgN0e6St3ZXV6xyB9ydESx7DiBhbipLGsRoMLhkAWfYw7ulCyLH2DTXpEEFCv
c+bXlUddlIAMIUEkrztvOBwVNAZO2FptjmOIJX6ogbAEQJs+dhI1iRjUIHEw/aIp
J48IhfdkbHUY6ITQrylkmR/XLEqyynebAyHkobog38fJRFsNxrcMdYDqUZh6vQTI
EX2vkckCgYEAyeM5BsRBG+RTA60DDrtAy8acG1IMa5KUDRnAplJ+le3h1mYXUuly
Y5FC+Ekz/o4EaZ/B6ROuqNMgbr8aZyKdo/8YW+3ZoXyBhn+hKW3Ohe3k7c8rP0RE
Yv2KpCOLoQZnxv5Ql8OhPYwcfplJf3luF7+6cFUjNPSW/7ePAR6cxMcCgYEA9m3Z
FqNEec/lxjpBYba6l0WoEeP7IjzBdh3sGcjHL97iRT8pL+ha/LWexcas4/a5y+MU
4ZcnnrZlfDukKq4Tl/AgBAGOvtNV5r7R389W6lmlpnWuCn7EPlzFc3eTnwhhW7CS
6AflOiw0bmxJznUPbZDrBNAZQWv4XE2bwkNT1AUCgYBe09LSYdZvQnTXsilQfxX1
YUmr74MT+BqAeMsrlG4PAFhmuzdTY4GuUOnS85dvhsd90WNkljEg7WI7gpnlPbYr
9MM9UuA5YOD6CvLpIcGy2MYCCaA3rFou4QaBCI0qSnbuWkACuQoAfdJYiKmkLaZP
k2gAIY1S71wJqu+JyBY8uwKBgFIpv/bvStZ+fbMBG2mT/lSPkgEdDU+WCD70rRLP
wbHxU2oZLAdgJm4ZtC1nF6AOVFZpiT3KIxik4eNxE0Rzs+61zkbnqgtv9TUxLFK+
E9GhQDznAbdYGuBcGC1ukha1OZjTn7ejYkdqE7U5f8ZJe3JhniqFo9YPRMipy6QS
xLFtAoGALdHfgdUMLrK2Psg2SZa+67sAZLQv23AIfpYKM20zc6a6C2zaYQrKl7j/
Ix446j2jgwEyX/JyGZgSphp7BP40mkAvjORJW0nom75FD7+IzNFJOb25CHmM6wt8
qIORz97P72wrhzfXmildu5tGU+qawb45baAwu6Pt9kthUvS9wMY=
-----END RSA PRIVATE KEY-----
`)

func clientKeyBytes() ([]byte, error) {
	return _clientKey, nil
}

func clientKey() (*asset, error) {
	bytes, err := clientKeyBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "client.key", size: 1675, mode: os.FileMode(288), modTime: time.Unix(1556125670, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _invalidCaCrt = []byte(`foobar
`)

func invalidCaCrtBytes() ([]byte, error) {
	return _invalidCaCrt, nil
}

func invalidCaCrt() (*asset, error) {
	bytes, err := invalidCaCrtBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "invalid-ca.crt", size: 7, mode: os.FileMode(420), modTime: time.Unix(1556125670, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _metronCsr = []byte(`-----BEGIN CERTIFICATE REQUEST-----
MIICVjCCAT4CAQAwETEPMA0GA1UEAxMGbWV0cm9uMIIBIjANBgkqhkiG9w0BAQEF
AAOCAQ8AMIIBCgKCAQEA3cv/7Gm5JD7iuGMH8x4vueekg9nuF+gJLlmqJQcVA5nv
5O0bsWrA1biq4cXyogMmj2nzV1zizRXTHmCnTKPapnrFAqPq8lK3ldu4nVxHX/r0
vw6lFKeD9DuOSWBrXdS1Qm6v57BK+czxeOKtRdGMFxDhj5zBYUdmUutJA3Kc6rZl
VZ//t88YTL8cGcmRD9nC2lXLKMI70i7Mhz2EiHlJ9Nt3yX/o2uKoxRR4CTrO1TWe
12EMSAJ//+rzlMaqMD3oGZEGq0Sk9CSw3mFSLzSQCDIqAwSt7PYjvGOZlB1aL6JE
nCvK1JACEKV8QLAPB56+3R3PpH46hKsnmmxzE6lv2wIDAQABoAAwDQYJKoZIhvcN
AQELBQADggEBAEDfhw370hYfmGsifrVe6f8TYjPcybLfcrEqTDKGp/rcunHoWRW/
xqtCnK9WCMP9O1d10llkHP2pJwaEcr+S6p8yVZACn3oHwSAL4t4HAIVBjTdm4k8o
27uE1HncnenJLhu29ZQaG+3h/ELCipri2E5XPs5VsgBUJc1dpQfXtLyY6jdhVVYm
ThIohhBpg0Gw9jS8JcdKCtIKi3P6wBs4PO+JfUK9aoyiVC0aFVWyWUy1y+hKxngK
+ZcR7ATbPrJ03OsJIqoM3PcMk0q+lRP5yuteGY/SHCiOanLg7rmuPcY1izKeAR0O
PgE90cjp0K0vYOaKYRCAoJ/eky5PaZACZZU=
-----END CERTIFICATE REQUEST-----
`)

func metronCsrBytes() ([]byte, error) {
	return _metronCsr, nil
}

func metronCsr() (*asset, error) {
	bytes, err := metronCsrBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "metron.csr", size: 887, mode: os.FileMode(292), modTime: time.Unix(1556125670, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _reverselogproxyCsr = []byte(`-----BEGIN CERTIFICATE REQUEST-----
MIICXzCCAUcCAQAwGjEYMBYGA1UEAxMPcmV2ZXJzZWxvZ3Byb3h5MIIBIjANBgkq
hkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwlb5vz4XcTEk30vKTjnHhw3XMnA92NUW
ZAXUdp/6PeYhFZec81dHCkQV6dSeaQA7SbOTqRGyznksPLCZsvknkyDxYoE7lkwB
22oRRXA7zOvq/32A52kY3PKhjWR5J/NCp/g6Au121hjcJpI6C3jrb8BGzPJQPoMa
SOuJYR/ecASVode2oMZ44eGlyosxym4KbI2mu4x/p6VYEOlxLIOY4c6QlLjERqM1
U2Eoobr0DWFrb6zA77J+fho1dY3ykWSxcEFHtyBnnXpEiNgnvuMhxyVUkCfvmewV
CW0uURU6P2nPBAPrndck2DsoNN5vrOsyLgO1c0cjK7B7L0iBTYmj4wIDAQABoAAw
DQYJKoZIhvcNAQELBQADggEBACp92IYxsorYHf4XvhqCc9rkeTxmC6RiDSRqFd9t
oYcXJ1nj8DxV7+Sl0MJ28UJyTf/uo39DL6vmc7Rq99y6KBzIKbOZK2HANH8PPU5X
e3yHgy52oWJ5ZXumttU9zPXiMzjcYMtE1MXCyaDd938bnLRIS/dURryNGcTY8Isc
uIarHvLm1GJDva7hudLCw1+WfTla0twsFsJJwsefoesaGCfhsvQHvOsyoaYk4jyq
W43rIHAGWZfsKFXvwGVXuh8fhXVetEXXxk1A2JhdNCkCxqhji/euRVokJbBWlAhV
n7r8Tq9OhWhKwkBt6tdwvIUdriHrz0mmn7Srx4MEFqEDqmE=
-----END CERTIFICATE REQUEST-----
`)

func reverselogproxyCsrBytes() ([]byte, error) {
	return _reverselogproxyCsr, nil
}

func reverselogproxyCsr() (*asset, error) {
	bytes, err := reverselogproxyCsrBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "reverselogproxy.csr", size: 899, mode: os.FileMode(292), modTime: time.Unix(1556125670, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _serverCrt = []byte(`-----BEGIN CERTIFICATE-----
MIIEJDCCAgygAwIBAgIQAOorgilT+jEkqJfy6t5qSjANBgkqhkiG9w0BAQsFADAY
MRYwFAYDVQQDEw1sb2dncmVnYXRvckNBMB4XDTE5MDQyNDE3MDc1MFoXDTQ0MDQy
NDE3MDc0NVowETEPMA0GA1UEAxMGbWV0cm9uMIIBIjANBgkqhkiG9w0BAQEFAAOC
AQ8AMIIBCgKCAQEA3cv/7Gm5JD7iuGMH8x4vueekg9nuF+gJLlmqJQcVA5nv5O0b
sWrA1biq4cXyogMmj2nzV1zizRXTHmCnTKPapnrFAqPq8lK3ldu4nVxHX/r0vw6l
FKeD9DuOSWBrXdS1Qm6v57BK+czxeOKtRdGMFxDhj5zBYUdmUutJA3Kc6rZlVZ//
t88YTL8cGcmRD9nC2lXLKMI70i7Mhz2EiHlJ9Nt3yX/o2uKoxRR4CTrO1TWe12EM
SAJ//+rzlMaqMD3oGZEGq0Sk9CSw3mFSLzSQCDIqAwSt7PYjvGOZlB1aL6JEnCvK
1JACEKV8QLAPB56+3R3PpH46hKsnmmxzE6lv2wIDAQABo3EwbzAOBgNVHQ8BAf8E
BAMCA7gwHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBSY
styJQKs3/UwvbxY+0xsft6ry/zAfBgNVHSMEGDAWgBSDgH+psWkFw4EUfnD+aHs9
Tw8BMDANBgkqhkiG9w0BAQsFAAOCAgEAadpAsLpy5Q4W1bzCtWL3/JP5JyvWf8tK
7PB/BCQtXSi8CcNrbEcR3ViPMM8QNtFSgROYp/HddYFQlDgHTTFPdY2iTtX4wWeO
hbjZvKTt/jDo2r+2ebWBIkYD0Dq8G/qu6gG8eUQUb7Bq17oIZU98ZtMAium1jXln
ODUQHtTbvlB8/7KWb8zTZT/Rzg0tHfm3sc7NSY3ASCzj+ZgjQk4h/i+VNdcQHDP2
bZ6ESepo3VGqsvVBliqjbwpDMrUSQMmcdxEnnSwHE3DVpEGMBHByRnmKZzbAuovG
7oM7a50QXiKFiMEdlrl7d+wtcqdzxmupTK5rdx/EbJNsONU5Ac3/GrFe1kXgay3s
OaFesp31cDGiZ9xfK+A8QFcokwvcHicQT2LpSas3iPbX31/GPdQ1itHctfrVn7el
1eey1JwkeYGGP225gC/IJDUsJtVmu6/FuhoU5Wcl71xyzjBzprVuskQd+bJmKQDd
VCm15KpXE5n2f1EJ3aJOCKE2mAzJKv0wr5NecgUFDIXs+aM4BcSzpUHqIoqxAQK4
0Szh4COHU6rm9dJDU9iYtKnuhk2KkdvxTBKIice3lYw+76Q0cADPjnDFoY+RLaQl
9xRLhVq9Lcc1GXU56zCHd+TWvZac8M+zUPuBUVNWTofm1t+5Dzhn64w4F7ap8Cyz
sLuOor6z9UE=
-----END CERTIFICATE-----
`)

func serverCrtBytes() ([]byte, error) {
	return _serverCrt, nil
}

func serverCrt() (*asset, error) {
	bytes, err := serverCrtBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "server.crt", size: 1497, mode: os.FileMode(292), modTime: time.Unix(1556125670, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _serverKey = []byte(`-----BEGIN RSA PRIVATE KEY-----
MIIEowIBAAKCAQEA3cv/7Gm5JD7iuGMH8x4vueekg9nuF+gJLlmqJQcVA5nv5O0b
sWrA1biq4cXyogMmj2nzV1zizRXTHmCnTKPapnrFAqPq8lK3ldu4nVxHX/r0vw6l
FKeD9DuOSWBrXdS1Qm6v57BK+czxeOKtRdGMFxDhj5zBYUdmUutJA3Kc6rZlVZ//
t88YTL8cGcmRD9nC2lXLKMI70i7Mhz2EiHlJ9Nt3yX/o2uKoxRR4CTrO1TWe12EM
SAJ//+rzlMaqMD3oGZEGq0Sk9CSw3mFSLzSQCDIqAwSt7PYjvGOZlB1aL6JEnCvK
1JACEKV8QLAPB56+3R3PpH46hKsnmmxzE6lv2wIDAQABAoIBADtfyPr4sl9JllfV
6uLiSdRydk/1nw83Rn3p8upGoxF7vASElM1Bzq1n6hbWbsWAImpx6nqQmwZbuVCA
f0i89GNsqiCy0Mpd6ldrolg9w72l6K7ctMR6s5BGASkTbqqHrp5CE0TqpKeKfXnm
9IukNORX2IohZIMuIe5AniMWI3uRKJBc6iVIO/W17IODzlPSDkZurl87IiG4P/6X
NSDT0fSjP2WtlpPkbxRekO2nLnrMzdFmssrrEpN2fDm8gm3fgoPkGzFXzQFL2EzN
KBsxyyjF+pwxZ1u1xm8xZnoqLhNFYrHrh3lUNtRRc0j2tWYOANrDBIa57tkrg0Ca
hVMXdYECgYEA+C6YrN9+2ADO27vhogmFbBRqTEup8QcCyogYdo2u7RdioaQxxiX5
Eq5nwo0umM56Zot8xhln6Igd8FMBWYQykbC8xxxcHBg4R/fMqXAtVRgpny5Yl2Yq
nbyEgfbFQC4hKZ9t4MBFWqScwgNj3bF06HWvG1sp/qq6Z+eZWe/HIxMCgYEA5Mig
cYOlVTjiGBJ9j6haJSdSROB1T2RpCQSGtSTNH7Bz/dJ3oZN7djVLKGgzfY5UXgcv
gc9hE+3N836UOcHYb3U5HujeDXRAFeSEPqD/5mJM5lHA7odNxLsAC6fXOPpVPiJ5
IxeBokckSGM1GmMSRd/2mCC6S66Y5kccUkIqURkCgYBuVNC88bLDNkDAANuDHLZ6
4OyMtIp9Q3+jKDOv6LbeYioP8B3MmC8NdglcvUT827YghlxW+Q5vmqusnkoYUKPm
juqtndb5Cm9i1y/eF6efj9lZEdKCpAHIE/nYiSsRqDBH/79qTi/G5y1lNvqboPt3
KHJLOBEITUAHVzeeevFNjwKBgAVujgCj84T2eMfBiKGkiZ9gM5/XBHICHExOgzRB
z2z1L4vTN2vqqH/B/CrVboOIoZAp84LNfayPdNhXJQXKCG19BwIo3TzMicj7R/iE
sg6yPskpH7+KDtqg5ftg3MdJikSTZPTkVfuYXNArKtOZjpGCI8Sw4jtxxceR4KZD
U+XhAoGBAON2SwwCxUspNbh4xHIAkuKuixbO+/JyZoLKxiYho4eHoIGLDGi7dJmJ
Oo2zpaNRVgWoESpeEjQZfHnOAIAU8YGNr87fluxbWYTKLSo+h3lN+5xnPA0Pfuv2
uqSpgv14yoDfgPkYzv6ymJswGU0dtdm++oMGOps6ebLPpVbKnNp0
-----END RSA PRIVATE KEY-----
`)

func serverKeyBytes() ([]byte, error) {
	return _serverKey, nil
}

func serverKey() (*asset, error) {
	bytes, err := serverKeyBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "server.key", size: 1675, mode: os.FileMode(288), modTime: time.Unix(1556125670, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"CA.crl": caCrl,
	"CA.crt": caCrt,
	"CA.key": caKey,
	"client.crt": clientCrt,
	"client.key": clientKey,
	"invalid-ca.crt": invalidCaCrt,
	"metron.csr": metronCsr,
	"reverselogproxy.csr": reverselogproxyCsr,
	"server.crt": serverCrt,
	"server.key": serverKey,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"}
// AssetDir("data/img") would return []string{"a.png", "b.png"}
// AssetDir("foo.txt") and AssetDir("notexist") would return an error
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		cannonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(cannonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}
var _bintree = &bintree{nil, map[string]*bintree{
	"CA.crl": &bintree{caCrl, map[string]*bintree{}},
	"CA.crt": &bintree{caCrt, map[string]*bintree{}},
	"CA.key": &bintree{caKey, map[string]*bintree{}},
	"client.crt": &bintree{clientCrt, map[string]*bintree{}},
	"client.key": &bintree{clientKey, map[string]*bintree{}},
	"invalid-ca.crt": &bintree{invalidCaCrt, map[string]*bintree{}},
	"metron.csr": &bintree{metronCsr, map[string]*bintree{}},
	"reverselogproxy.csr": &bintree{reverselogproxyCsr, map[string]*bintree{}},
	"server.crt": &bintree{serverCrt, map[string]*bintree{}},
	"server.key": &bintree{serverKey, map[string]*bintree{}},
}}

// RestoreAsset restores an asset under the given directory
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	err = os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
	if err != nil {
		return err
	}
	return nil
}

// RestoreAssets restores an asset under the given directory recursively
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(cannonicalName, "/")...)...)
}

