// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/vpcaccess/v1/vpc_access.proto

package vpcaccesspb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	VpcAccessService_CreateConnector_FullMethodName = "/google.cloud.vpcaccess.v1.VpcAccessService/CreateConnector"
	VpcAccessService_GetConnector_FullMethodName    = "/google.cloud.vpcaccess.v1.VpcAccessService/GetConnector"
	VpcAccessService_ListConnectors_FullMethodName  = "/google.cloud.vpcaccess.v1.VpcAccessService/ListConnectors"
	VpcAccessService_DeleteConnector_FullMethodName = "/google.cloud.vpcaccess.v1.VpcAccessService/DeleteConnector"
)

// VpcAccessServiceClient is the client API for VpcAccessService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type VpcAccessServiceClient interface {
	// Creates a Serverless VPC Access connector, returns an operation.
	CreateConnector(ctx context.Context, in *CreateConnectorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a Serverless VPC Access connector. Returns NOT_FOUND if the resource
	// does not exist.
	GetConnector(ctx context.Context, in *GetConnectorRequest, opts ...grpc.CallOption) (*Connector, error)
	// Lists Serverless VPC Access connectors.
	ListConnectors(ctx context.Context, in *ListConnectorsRequest, opts ...grpc.CallOption) (*ListConnectorsResponse, error)
	// Deletes a Serverless VPC Access connector. Returns NOT_FOUND if the
	// resource does not exist.
	DeleteConnector(ctx context.Context, in *DeleteConnectorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type vpcAccessServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewVpcAccessServiceClient(cc grpc.ClientConnInterface) VpcAccessServiceClient {
	return &vpcAccessServiceClient{cc}
}

func (c *vpcAccessServiceClient) CreateConnector(ctx context.Context, in *CreateConnectorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VpcAccessService_CreateConnector_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vpcAccessServiceClient) GetConnector(ctx context.Context, in *GetConnectorRequest, opts ...grpc.CallOption) (*Connector, error) {
	out := new(Connector)
	err := c.cc.Invoke(ctx, VpcAccessService_GetConnector_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vpcAccessServiceClient) ListConnectors(ctx context.Context, in *ListConnectorsRequest, opts ...grpc.CallOption) (*ListConnectorsResponse, error) {
	out := new(ListConnectorsResponse)
	err := c.cc.Invoke(ctx, VpcAccessService_ListConnectors_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vpcAccessServiceClient) DeleteConnector(ctx context.Context, in *DeleteConnectorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VpcAccessService_DeleteConnector_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VpcAccessServiceServer is the server API for VpcAccessService service.
// All implementations should embed UnimplementedVpcAccessServiceServer
// for forward compatibility
type VpcAccessServiceServer interface {
	// Creates a Serverless VPC Access connector, returns an operation.
	CreateConnector(context.Context, *CreateConnectorRequest) (*longrunningpb.Operation, error)
	// Gets a Serverless VPC Access connector. Returns NOT_FOUND if the resource
	// does not exist.
	GetConnector(context.Context, *GetConnectorRequest) (*Connector, error)
	// Lists Serverless VPC Access connectors.
	ListConnectors(context.Context, *ListConnectorsRequest) (*ListConnectorsResponse, error)
	// Deletes a Serverless VPC Access connector. Returns NOT_FOUND if the
	// resource does not exist.
	DeleteConnector(context.Context, *DeleteConnectorRequest) (*longrunningpb.Operation, error)
}

// UnimplementedVpcAccessServiceServer should be embedded to have forward compatible implementations.
type UnimplementedVpcAccessServiceServer struct {
}

func (UnimplementedVpcAccessServiceServer) CreateConnector(context.Context, *CreateConnectorRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConnector not implemented")
}
func (UnimplementedVpcAccessServiceServer) GetConnector(context.Context, *GetConnectorRequest) (*Connector, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConnector not implemented")
}
func (UnimplementedVpcAccessServiceServer) ListConnectors(context.Context, *ListConnectorsRequest) (*ListConnectorsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConnectors not implemented")
}
func (UnimplementedVpcAccessServiceServer) DeleteConnector(context.Context, *DeleteConnectorRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConnector not implemented")
}

// UnsafeVpcAccessServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to VpcAccessServiceServer will
// result in compilation errors.
type UnsafeVpcAccessServiceServer interface {
	mustEmbedUnimplementedVpcAccessServiceServer()
}

func RegisterVpcAccessServiceServer(s grpc.ServiceRegistrar, srv VpcAccessServiceServer) {
	s.RegisterService(&VpcAccessService_ServiceDesc, srv)
}

func _VpcAccessService_CreateConnector_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConnectorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VpcAccessServiceServer).CreateConnector(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VpcAccessService_CreateConnector_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VpcAccessServiceServer).CreateConnector(ctx, req.(*CreateConnectorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VpcAccessService_GetConnector_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConnectorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VpcAccessServiceServer).GetConnector(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VpcAccessService_GetConnector_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VpcAccessServiceServer).GetConnector(ctx, req.(*GetConnectorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VpcAccessService_ListConnectors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConnectorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VpcAccessServiceServer).ListConnectors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VpcAccessService_ListConnectors_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VpcAccessServiceServer).ListConnectors(ctx, req.(*ListConnectorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VpcAccessService_DeleteConnector_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConnectorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VpcAccessServiceServer).DeleteConnector(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VpcAccessService_DeleteConnector_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VpcAccessServiceServer).DeleteConnector(ctx, req.(*DeleteConnectorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// VpcAccessService_ServiceDesc is the grpc.ServiceDesc for VpcAccessService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var VpcAccessService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.vpcaccess.v1.VpcAccessService",
	HandlerType: (*VpcAccessServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateConnector",
			Handler:    _VpcAccessService_CreateConnector_Handler,
		},
		{
			MethodName: "GetConnector",
			Handler:    _VpcAccessService_GetConnector_Handler,
		},
		{
			MethodName: "ListConnectors",
			Handler:    _VpcAccessService_ListConnectors_Handler,
		},
		{
			MethodName: "DeleteConnector",
			Handler:    _VpcAccessService_DeleteConnector_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/vpcaccess/v1/vpc_access.proto",
}
