// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/securitycenter/v1/securitycenter_service.proto

package securitycenterpb

import (
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	SecurityCenter_BulkMuteFindings_FullMethodName                                   = "/google.cloud.securitycenter.v1.SecurityCenter/BulkMuteFindings"
	SecurityCenter_CreateSecurityHealthAnalyticsCustomModule_FullMethodName          = "/google.cloud.securitycenter.v1.SecurityCenter/CreateSecurityHealthAnalyticsCustomModule"
	SecurityCenter_CreateSource_FullMethodName                                       = "/google.cloud.securitycenter.v1.SecurityCenter/CreateSource"
	SecurityCenter_CreateFinding_FullMethodName                                      = "/google.cloud.securitycenter.v1.SecurityCenter/CreateFinding"
	SecurityCenter_CreateMuteConfig_FullMethodName                                   = "/google.cloud.securitycenter.v1.SecurityCenter/CreateMuteConfig"
	SecurityCenter_CreateNotificationConfig_FullMethodName                           = "/google.cloud.securitycenter.v1.SecurityCenter/CreateNotificationConfig"
	SecurityCenter_DeleteMuteConfig_FullMethodName                                   = "/google.cloud.securitycenter.v1.SecurityCenter/DeleteMuteConfig"
	SecurityCenter_DeleteNotificationConfig_FullMethodName                           = "/google.cloud.securitycenter.v1.SecurityCenter/DeleteNotificationConfig"
	SecurityCenter_DeleteSecurityHealthAnalyticsCustomModule_FullMethodName          = "/google.cloud.securitycenter.v1.SecurityCenter/DeleteSecurityHealthAnalyticsCustomModule"
	SecurityCenter_GetSimulation_FullMethodName                                      = "/google.cloud.securitycenter.v1.SecurityCenter/GetSimulation"
	SecurityCenter_GetValuedResource_FullMethodName                                  = "/google.cloud.securitycenter.v1.SecurityCenter/GetValuedResource"
	SecurityCenter_GetBigQueryExport_FullMethodName                                  = "/google.cloud.securitycenter.v1.SecurityCenter/GetBigQueryExport"
	SecurityCenter_GetIamPolicy_FullMethodName                                       = "/google.cloud.securitycenter.v1.SecurityCenter/GetIamPolicy"
	SecurityCenter_GetMuteConfig_FullMethodName                                      = "/google.cloud.securitycenter.v1.SecurityCenter/GetMuteConfig"
	SecurityCenter_GetNotificationConfig_FullMethodName                              = "/google.cloud.securitycenter.v1.SecurityCenter/GetNotificationConfig"
	SecurityCenter_GetOrganizationSettings_FullMethodName                            = "/google.cloud.securitycenter.v1.SecurityCenter/GetOrganizationSettings"
	SecurityCenter_GetEffectiveSecurityHealthAnalyticsCustomModule_FullMethodName    = "/google.cloud.securitycenter.v1.SecurityCenter/GetEffectiveSecurityHealthAnalyticsCustomModule"
	SecurityCenter_GetSecurityHealthAnalyticsCustomModule_FullMethodName             = "/google.cloud.securitycenter.v1.SecurityCenter/GetSecurityHealthAnalyticsCustomModule"
	SecurityCenter_GetSource_FullMethodName                                          = "/google.cloud.securitycenter.v1.SecurityCenter/GetSource"
	SecurityCenter_GroupAssets_FullMethodName                                        = "/google.cloud.securitycenter.v1.SecurityCenter/GroupAssets"
	SecurityCenter_GroupFindings_FullMethodName                                      = "/google.cloud.securitycenter.v1.SecurityCenter/GroupFindings"
	SecurityCenter_ListAssets_FullMethodName                                         = "/google.cloud.securitycenter.v1.SecurityCenter/ListAssets"
	SecurityCenter_ListDescendantSecurityHealthAnalyticsCustomModules_FullMethodName = "/google.cloud.securitycenter.v1.SecurityCenter/ListDescendantSecurityHealthAnalyticsCustomModules"
	SecurityCenter_ListFindings_FullMethodName                                       = "/google.cloud.securitycenter.v1.SecurityCenter/ListFindings"
	SecurityCenter_ListMuteConfigs_FullMethodName                                    = "/google.cloud.securitycenter.v1.SecurityCenter/ListMuteConfigs"
	SecurityCenter_ListNotificationConfigs_FullMethodName                            = "/google.cloud.securitycenter.v1.SecurityCenter/ListNotificationConfigs"
	SecurityCenter_ListEffectiveSecurityHealthAnalyticsCustomModules_FullMethodName  = "/google.cloud.securitycenter.v1.SecurityCenter/ListEffectiveSecurityHealthAnalyticsCustomModules"
	SecurityCenter_ListSecurityHealthAnalyticsCustomModules_FullMethodName           = "/google.cloud.securitycenter.v1.SecurityCenter/ListSecurityHealthAnalyticsCustomModules"
	SecurityCenter_ListSources_FullMethodName                                        = "/google.cloud.securitycenter.v1.SecurityCenter/ListSources"
	SecurityCenter_RunAssetDiscovery_FullMethodName                                  = "/google.cloud.securitycenter.v1.SecurityCenter/RunAssetDiscovery"
	SecurityCenter_SetFindingState_FullMethodName                                    = "/google.cloud.securitycenter.v1.SecurityCenter/SetFindingState"
	SecurityCenter_SetMute_FullMethodName                                            = "/google.cloud.securitycenter.v1.SecurityCenter/SetMute"
	SecurityCenter_SetIamPolicy_FullMethodName                                       = "/google.cloud.securitycenter.v1.SecurityCenter/SetIamPolicy"
	SecurityCenter_TestIamPermissions_FullMethodName                                 = "/google.cloud.securitycenter.v1.SecurityCenter/TestIamPermissions"
	SecurityCenter_SimulateSecurityHealthAnalyticsCustomModule_FullMethodName        = "/google.cloud.securitycenter.v1.SecurityCenter/SimulateSecurityHealthAnalyticsCustomModule"
	SecurityCenter_UpdateExternalSystem_FullMethodName                               = "/google.cloud.securitycenter.v1.SecurityCenter/UpdateExternalSystem"
	SecurityCenter_UpdateFinding_FullMethodName                                      = "/google.cloud.securitycenter.v1.SecurityCenter/UpdateFinding"
	SecurityCenter_UpdateMuteConfig_FullMethodName                                   = "/google.cloud.securitycenter.v1.SecurityCenter/UpdateMuteConfig"
	SecurityCenter_UpdateNotificationConfig_FullMethodName                           = "/google.cloud.securitycenter.v1.SecurityCenter/UpdateNotificationConfig"
	SecurityCenter_UpdateOrganizationSettings_FullMethodName                         = "/google.cloud.securitycenter.v1.SecurityCenter/UpdateOrganizationSettings"
	SecurityCenter_UpdateSecurityHealthAnalyticsCustomModule_FullMethodName          = "/google.cloud.securitycenter.v1.SecurityCenter/UpdateSecurityHealthAnalyticsCustomModule"
	SecurityCenter_UpdateSource_FullMethodName                                       = "/google.cloud.securitycenter.v1.SecurityCenter/UpdateSource"
	SecurityCenter_UpdateSecurityMarks_FullMethodName                                = "/google.cloud.securitycenter.v1.SecurityCenter/UpdateSecurityMarks"
	SecurityCenter_CreateBigQueryExport_FullMethodName                               = "/google.cloud.securitycenter.v1.SecurityCenter/CreateBigQueryExport"
	SecurityCenter_DeleteBigQueryExport_FullMethodName                               = "/google.cloud.securitycenter.v1.SecurityCenter/DeleteBigQueryExport"
	SecurityCenter_UpdateBigQueryExport_FullMethodName                               = "/google.cloud.securitycenter.v1.SecurityCenter/UpdateBigQueryExport"
	SecurityCenter_ListBigQueryExports_FullMethodName                                = "/google.cloud.securitycenter.v1.SecurityCenter/ListBigQueryExports"
	SecurityCenter_CreateEventThreatDetectionCustomModule_FullMethodName             = "/google.cloud.securitycenter.v1.SecurityCenter/CreateEventThreatDetectionCustomModule"
	SecurityCenter_DeleteEventThreatDetectionCustomModule_FullMethodName             = "/google.cloud.securitycenter.v1.SecurityCenter/DeleteEventThreatDetectionCustomModule"
	SecurityCenter_GetEventThreatDetectionCustomModule_FullMethodName                = "/google.cloud.securitycenter.v1.SecurityCenter/GetEventThreatDetectionCustomModule"
	SecurityCenter_ListDescendantEventThreatDetectionCustomModules_FullMethodName    = "/google.cloud.securitycenter.v1.SecurityCenter/ListDescendantEventThreatDetectionCustomModules"
	SecurityCenter_ListEventThreatDetectionCustomModules_FullMethodName              = "/google.cloud.securitycenter.v1.SecurityCenter/ListEventThreatDetectionCustomModules"
	SecurityCenter_UpdateEventThreatDetectionCustomModule_FullMethodName             = "/google.cloud.securitycenter.v1.SecurityCenter/UpdateEventThreatDetectionCustomModule"
	SecurityCenter_ValidateEventThreatDetectionCustomModule_FullMethodName           = "/google.cloud.securitycenter.v1.SecurityCenter/ValidateEventThreatDetectionCustomModule"
	SecurityCenter_GetEffectiveEventThreatDetectionCustomModule_FullMethodName       = "/google.cloud.securitycenter.v1.SecurityCenter/GetEffectiveEventThreatDetectionCustomModule"
	SecurityCenter_ListEffectiveEventThreatDetectionCustomModules_FullMethodName     = "/google.cloud.securitycenter.v1.SecurityCenter/ListEffectiveEventThreatDetectionCustomModules"
	SecurityCenter_BatchCreateResourceValueConfigs_FullMethodName                    = "/google.cloud.securitycenter.v1.SecurityCenter/BatchCreateResourceValueConfigs"
	SecurityCenter_DeleteResourceValueConfig_FullMethodName                          = "/google.cloud.securitycenter.v1.SecurityCenter/DeleteResourceValueConfig"
	SecurityCenter_GetResourceValueConfig_FullMethodName                             = "/google.cloud.securitycenter.v1.SecurityCenter/GetResourceValueConfig"
	SecurityCenter_ListResourceValueConfigs_FullMethodName                           = "/google.cloud.securitycenter.v1.SecurityCenter/ListResourceValueConfigs"
	SecurityCenter_UpdateResourceValueConfig_FullMethodName                          = "/google.cloud.securitycenter.v1.SecurityCenter/UpdateResourceValueConfig"
	SecurityCenter_ListValuedResources_FullMethodName                                = "/google.cloud.securitycenter.v1.SecurityCenter/ListValuedResources"
	SecurityCenter_ListAttackPaths_FullMethodName                                    = "/google.cloud.securitycenter.v1.SecurityCenter/ListAttackPaths"
)

// SecurityCenterClient is the client API for SecurityCenter service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SecurityCenterClient interface {
	// Kicks off an LRO to bulk mute findings for a parent based on a filter. The
	// parent can be either an organization, folder or project. The findings
	// matched by the filter will be muted after the LRO is done.
	BulkMuteFindings(ctx context.Context, in *BulkMuteFindingsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a resident SecurityHealthAnalyticsCustomModule at the scope of the
	// given CRM parent, and also creates inherited
	// SecurityHealthAnalyticsCustomModules for all CRM descendants of the given
	// parent. These modules are enabled by default.
	CreateSecurityHealthAnalyticsCustomModule(ctx context.Context, in *CreateSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*SecurityHealthAnalyticsCustomModule, error)
	// Creates a source.
	CreateSource(ctx context.Context, in *CreateSourceRequest, opts ...grpc.CallOption) (*Source, error)
	// Creates a finding. The corresponding source must exist for finding creation
	// to succeed.
	CreateFinding(ctx context.Context, in *CreateFindingRequest, opts ...grpc.CallOption) (*Finding, error)
	// Creates a mute config.
	CreateMuteConfig(ctx context.Context, in *CreateMuteConfigRequest, opts ...grpc.CallOption) (*MuteConfig, error)
	// Creates a notification config.
	CreateNotificationConfig(ctx context.Context, in *CreateNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error)
	// Deletes an existing mute config.
	DeleteMuteConfig(ctx context.Context, in *DeleteMuteConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deletes a notification config.
	DeleteNotificationConfig(ctx context.Context, in *DeleteNotificationConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deletes the specified SecurityHealthAnalyticsCustomModule and all of its
	// descendants in the CRM hierarchy. This method is only supported for
	// resident custom modules.
	DeleteSecurityHealthAnalyticsCustomModule(ctx context.Context, in *DeleteSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Get the simulation by name or the latest simulation for the given
	// organization.
	GetSimulation(ctx context.Context, in *GetSimulationRequest, opts ...grpc.CallOption) (*Simulation, error)
	// Get the valued resource by name
	GetValuedResource(ctx context.Context, in *GetValuedResourceRequest, opts ...grpc.CallOption) (*ValuedResource, error)
	// Gets a BigQuery export.
	GetBigQueryExport(ctx context.Context, in *GetBigQueryExportRequest, opts ...grpc.CallOption) (*BigQueryExport, error)
	// Gets the access control policy on the specified Source.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Gets a mute config.
	GetMuteConfig(ctx context.Context, in *GetMuteConfigRequest, opts ...grpc.CallOption) (*MuteConfig, error)
	// Gets a notification config.
	GetNotificationConfig(ctx context.Context, in *GetNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error)
	// Gets the settings for an organization.
	GetOrganizationSettings(ctx context.Context, in *GetOrganizationSettingsRequest, opts ...grpc.CallOption) (*OrganizationSettings, error)
	// Retrieves an EffectiveSecurityHealthAnalyticsCustomModule.
	GetEffectiveSecurityHealthAnalyticsCustomModule(ctx context.Context, in *GetEffectiveSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*EffectiveSecurityHealthAnalyticsCustomModule, error)
	// Retrieves a SecurityHealthAnalyticsCustomModule.
	GetSecurityHealthAnalyticsCustomModule(ctx context.Context, in *GetSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*SecurityHealthAnalyticsCustomModule, error)
	// Gets a source.
	GetSource(ctx context.Context, in *GetSourceRequest, opts ...grpc.CallOption) (*Source, error)
	// Deprecated: Do not use.
	// Filters an organization's assets and  groups them by their specified
	// properties.
	GroupAssets(ctx context.Context, in *GroupAssetsRequest, opts ...grpc.CallOption) (*GroupAssetsResponse, error)
	// Filters an organization or source's findings and  groups them by their
	// specified properties.
	//
	// To group across all sources provide a `-` as the source id.
	// Example: /v1/organizations/{organization_id}/sources/-/findings,
	// /v1/folders/{folder_id}/sources/-/findings,
	// /v1/projects/{project_id}/sources/-/findings
	GroupFindings(ctx context.Context, in *GroupFindingsRequest, opts ...grpc.CallOption) (*GroupFindingsResponse, error)
	// Deprecated: Do not use.
	// Lists an organization's assets.
	ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error)
	// Returns a list of all resident SecurityHealthAnalyticsCustomModules under
	// the given CRM parent and all of the parent’s CRM descendants.
	ListDescendantSecurityHealthAnalyticsCustomModules(ctx context.Context, in *ListDescendantSecurityHealthAnalyticsCustomModulesRequest, opts ...grpc.CallOption) (*ListDescendantSecurityHealthAnalyticsCustomModulesResponse, error)
	// Lists an organization or source's findings.
	//
	// To list across all sources provide a `-` as the source id.
	// Example: /v1/organizations/{organization_id}/sources/-/findings
	ListFindings(ctx context.Context, in *ListFindingsRequest, opts ...grpc.CallOption) (*ListFindingsResponse, error)
	// Lists mute configs.
	ListMuteConfigs(ctx context.Context, in *ListMuteConfigsRequest, opts ...grpc.CallOption) (*ListMuteConfigsResponse, error)
	// Lists notification configs.
	ListNotificationConfigs(ctx context.Context, in *ListNotificationConfigsRequest, opts ...grpc.CallOption) (*ListNotificationConfigsResponse, error)
	// Returns a list of all EffectiveSecurityHealthAnalyticsCustomModules for the
	// given parent. This includes resident modules defined at the scope of the
	// parent, and inherited modules, inherited from CRM ancestors.
	ListEffectiveSecurityHealthAnalyticsCustomModules(ctx context.Context, in *ListEffectiveSecurityHealthAnalyticsCustomModulesRequest, opts ...grpc.CallOption) (*ListEffectiveSecurityHealthAnalyticsCustomModulesResponse, error)
	// Returns a list of all SecurityHealthAnalyticsCustomModules for the given
	// parent. This includes resident modules defined at the scope of the parent,
	// and inherited modules, inherited from CRM ancestors.
	ListSecurityHealthAnalyticsCustomModules(ctx context.Context, in *ListSecurityHealthAnalyticsCustomModulesRequest, opts ...grpc.CallOption) (*ListSecurityHealthAnalyticsCustomModulesResponse, error)
	// Lists all sources belonging to an organization.
	ListSources(ctx context.Context, in *ListSourcesRequest, opts ...grpc.CallOption) (*ListSourcesResponse, error)
	// Deprecated: Do not use.
	// Runs asset discovery. The discovery is tracked with a long-running
	// operation.
	//
	// This API can only be called with limited frequency for an organization. If
	// it is called too frequently the caller will receive a TOO_MANY_REQUESTS
	// error.
	RunAssetDiscovery(ctx context.Context, in *RunAssetDiscoveryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the state of a finding.
	SetFindingState(ctx context.Context, in *SetFindingStateRequest, opts ...grpc.CallOption) (*Finding, error)
	// Updates the mute state of a finding.
	SetMute(ctx context.Context, in *SetMuteRequest, opts ...grpc.CallOption) (*Finding, error)
	// Sets the access control policy on the specified Source.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Returns the permissions that a caller has on the specified source.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
	// Simulates a given SecurityHealthAnalyticsCustomModule and Resource.
	SimulateSecurityHealthAnalyticsCustomModule(ctx context.Context, in *SimulateSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*SimulateSecurityHealthAnalyticsCustomModuleResponse, error)
	// Updates external system. This is for a given finding.
	UpdateExternalSystem(ctx context.Context, in *UpdateExternalSystemRequest, opts ...grpc.CallOption) (*ExternalSystem, error)
	// Creates or updates a finding. The corresponding source must exist for a
	// finding creation to succeed.
	UpdateFinding(ctx context.Context, in *UpdateFindingRequest, opts ...grpc.CallOption) (*Finding, error)
	// Updates a mute config.
	UpdateMuteConfig(ctx context.Context, in *UpdateMuteConfigRequest, opts ...grpc.CallOption) (*MuteConfig, error)
	// Updates a notification config. The following update
	// fields are allowed: description, pubsub_topic, streaming_config.filter
	UpdateNotificationConfig(ctx context.Context, in *UpdateNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error)
	// Updates an organization's settings.
	UpdateOrganizationSettings(ctx context.Context, in *UpdateOrganizationSettingsRequest, opts ...grpc.CallOption) (*OrganizationSettings, error)
	// Updates the SecurityHealthAnalyticsCustomModule under the given name based
	// on the given update mask. Updating the enablement state is supported on
	// both resident and inherited modules (though resident modules cannot have an
	// enablement state of "inherited"). Updating the display name and custom
	// config of a module is supported on resident modules only.
	UpdateSecurityHealthAnalyticsCustomModule(ctx context.Context, in *UpdateSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*SecurityHealthAnalyticsCustomModule, error)
	// Updates a source.
	UpdateSource(ctx context.Context, in *UpdateSourceRequest, opts ...grpc.CallOption) (*Source, error)
	// Updates security marks.
	UpdateSecurityMarks(ctx context.Context, in *UpdateSecurityMarksRequest, opts ...grpc.CallOption) (*SecurityMarks, error)
	// Creates a BigQuery export.
	CreateBigQueryExport(ctx context.Context, in *CreateBigQueryExportRequest, opts ...grpc.CallOption) (*BigQueryExport, error)
	// Deletes an existing BigQuery export.
	DeleteBigQueryExport(ctx context.Context, in *DeleteBigQueryExportRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a BigQuery export.
	UpdateBigQueryExport(ctx context.Context, in *UpdateBigQueryExportRequest, opts ...grpc.CallOption) (*BigQueryExport, error)
	// Lists BigQuery exports. Note that when requesting BigQuery exports at a
	// given level all exports under that level are also returned e.g. if
	// requesting BigQuery exports under a folder, then all BigQuery exports
	// immediately under the folder plus the ones created under the projects
	// within the folder are returned.
	ListBigQueryExports(ctx context.Context, in *ListBigQueryExportsRequest, opts ...grpc.CallOption) (*ListBigQueryExportsResponse, error)
	// Creates a resident Event Threat Detection custom module at the scope of the
	// given Resource Manager parent, and also creates inherited custom modules
	// for all descendants of the given parent. These modules are enabled by
	// default.
	CreateEventThreatDetectionCustomModule(ctx context.Context, in *CreateEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*EventThreatDetectionCustomModule, error)
	// Deletes the specified Event Threat Detection custom module and all of its
	// descendants in the Resource Manager hierarchy. This method is only
	// supported for resident custom modules.
	DeleteEventThreatDetectionCustomModule(ctx context.Context, in *DeleteEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets an Event Threat Detection custom module.
	GetEventThreatDetectionCustomModule(ctx context.Context, in *GetEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*EventThreatDetectionCustomModule, error)
	// Lists all resident Event Threat Detection custom modules under the
	// given Resource Manager parent and its descendants.
	ListDescendantEventThreatDetectionCustomModules(ctx context.Context, in *ListDescendantEventThreatDetectionCustomModulesRequest, opts ...grpc.CallOption) (*ListDescendantEventThreatDetectionCustomModulesResponse, error)
	// Lists all Event Threat Detection custom modules for the given
	// Resource Manager parent. This includes resident modules defined at the
	// scope of the parent along with modules inherited from ancestors.
	ListEventThreatDetectionCustomModules(ctx context.Context, in *ListEventThreatDetectionCustomModulesRequest, opts ...grpc.CallOption) (*ListEventThreatDetectionCustomModulesResponse, error)
	// Updates the Event Threat Detection custom module with the given name based
	// on the given update mask. Updating the enablement state is supported for
	// both resident and inherited modules (though resident modules cannot have an
	// enablement state of "inherited"). Updating the display name or
	// configuration of a module is supported for resident modules only. The type
	// of a module cannot be changed.
	UpdateEventThreatDetectionCustomModule(ctx context.Context, in *UpdateEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*EventThreatDetectionCustomModule, error)
	// Validates the given Event Threat Detection custom module.
	ValidateEventThreatDetectionCustomModule(ctx context.Context, in *ValidateEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*ValidateEventThreatDetectionCustomModuleResponse, error)
	// Gets an effective Event Threat Detection custom module at the given level.
	GetEffectiveEventThreatDetectionCustomModule(ctx context.Context, in *GetEffectiveEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*EffectiveEventThreatDetectionCustomModule, error)
	// Lists all effective Event Threat Detection custom modules for the
	// given parent. This includes resident modules defined at the scope of the
	// parent along with modules inherited from its ancestors.
	ListEffectiveEventThreatDetectionCustomModules(ctx context.Context, in *ListEffectiveEventThreatDetectionCustomModulesRequest, opts ...grpc.CallOption) (*ListEffectiveEventThreatDetectionCustomModulesResponse, error)
	// Creates a ResourceValueConfig for an organization. Maps user's tags to
	// difference resource values for use by the attack path simulation.
	BatchCreateResourceValueConfigs(ctx context.Context, in *BatchCreateResourceValueConfigsRequest, opts ...grpc.CallOption) (*BatchCreateResourceValueConfigsResponse, error)
	// Deletes a ResourceValueConfig.
	DeleteResourceValueConfig(ctx context.Context, in *DeleteResourceValueConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets a ResourceValueConfig.
	GetResourceValueConfig(ctx context.Context, in *GetResourceValueConfigRequest, opts ...grpc.CallOption) (*ResourceValueConfig, error)
	// Lists all ResourceValueConfigs.
	ListResourceValueConfigs(ctx context.Context, in *ListResourceValueConfigsRequest, opts ...grpc.CallOption) (*ListResourceValueConfigsResponse, error)
	// Updates an existing ResourceValueConfigs with new rules.
	UpdateResourceValueConfig(ctx context.Context, in *UpdateResourceValueConfigRequest, opts ...grpc.CallOption) (*ResourceValueConfig, error)
	// Lists the valued resources for a set of simulation results and filter.
	ListValuedResources(ctx context.Context, in *ListValuedResourcesRequest, opts ...grpc.CallOption) (*ListValuedResourcesResponse, error)
	// Lists the attack paths for a set of simulation results or valued resources
	// and filter.
	ListAttackPaths(ctx context.Context, in *ListAttackPathsRequest, opts ...grpc.CallOption) (*ListAttackPathsResponse, error)
}

type securityCenterClient struct {
	cc grpc.ClientConnInterface
}

func NewSecurityCenterClient(cc grpc.ClientConnInterface) SecurityCenterClient {
	return &securityCenterClient{cc}
}

func (c *securityCenterClient) BulkMuteFindings(ctx context.Context, in *BulkMuteFindingsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, SecurityCenter_BulkMuteFindings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) CreateSecurityHealthAnalyticsCustomModule(ctx context.Context, in *CreateSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*SecurityHealthAnalyticsCustomModule, error) {
	out := new(SecurityHealthAnalyticsCustomModule)
	err := c.cc.Invoke(ctx, SecurityCenter_CreateSecurityHealthAnalyticsCustomModule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) CreateSource(ctx context.Context, in *CreateSourceRequest, opts ...grpc.CallOption) (*Source, error) {
	out := new(Source)
	err := c.cc.Invoke(ctx, SecurityCenter_CreateSource_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) CreateFinding(ctx context.Context, in *CreateFindingRequest, opts ...grpc.CallOption) (*Finding, error) {
	out := new(Finding)
	err := c.cc.Invoke(ctx, SecurityCenter_CreateFinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) CreateMuteConfig(ctx context.Context, in *CreateMuteConfigRequest, opts ...grpc.CallOption) (*MuteConfig, error) {
	out := new(MuteConfig)
	err := c.cc.Invoke(ctx, SecurityCenter_CreateMuteConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) CreateNotificationConfig(ctx context.Context, in *CreateNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error) {
	out := new(NotificationConfig)
	err := c.cc.Invoke(ctx, SecurityCenter_CreateNotificationConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) DeleteMuteConfig(ctx context.Context, in *DeleteMuteConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, SecurityCenter_DeleteMuteConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) DeleteNotificationConfig(ctx context.Context, in *DeleteNotificationConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, SecurityCenter_DeleteNotificationConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) DeleteSecurityHealthAnalyticsCustomModule(ctx context.Context, in *DeleteSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, SecurityCenter_DeleteSecurityHealthAnalyticsCustomModule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetSimulation(ctx context.Context, in *GetSimulationRequest, opts ...grpc.CallOption) (*Simulation, error) {
	out := new(Simulation)
	err := c.cc.Invoke(ctx, SecurityCenter_GetSimulation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetValuedResource(ctx context.Context, in *GetValuedResourceRequest, opts ...grpc.CallOption) (*ValuedResource, error) {
	out := new(ValuedResource)
	err := c.cc.Invoke(ctx, SecurityCenter_GetValuedResource_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetBigQueryExport(ctx context.Context, in *GetBigQueryExportRequest, opts ...grpc.CallOption) (*BigQueryExport, error) {
	out := new(BigQueryExport)
	err := c.cc.Invoke(ctx, SecurityCenter_GetBigQueryExport_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, SecurityCenter_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetMuteConfig(ctx context.Context, in *GetMuteConfigRequest, opts ...grpc.CallOption) (*MuteConfig, error) {
	out := new(MuteConfig)
	err := c.cc.Invoke(ctx, SecurityCenter_GetMuteConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetNotificationConfig(ctx context.Context, in *GetNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error) {
	out := new(NotificationConfig)
	err := c.cc.Invoke(ctx, SecurityCenter_GetNotificationConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetOrganizationSettings(ctx context.Context, in *GetOrganizationSettingsRequest, opts ...grpc.CallOption) (*OrganizationSettings, error) {
	out := new(OrganizationSettings)
	err := c.cc.Invoke(ctx, SecurityCenter_GetOrganizationSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetEffectiveSecurityHealthAnalyticsCustomModule(ctx context.Context, in *GetEffectiveSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*EffectiveSecurityHealthAnalyticsCustomModule, error) {
	out := new(EffectiveSecurityHealthAnalyticsCustomModule)
	err := c.cc.Invoke(ctx, SecurityCenter_GetEffectiveSecurityHealthAnalyticsCustomModule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetSecurityHealthAnalyticsCustomModule(ctx context.Context, in *GetSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*SecurityHealthAnalyticsCustomModule, error) {
	out := new(SecurityHealthAnalyticsCustomModule)
	err := c.cc.Invoke(ctx, SecurityCenter_GetSecurityHealthAnalyticsCustomModule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetSource(ctx context.Context, in *GetSourceRequest, opts ...grpc.CallOption) (*Source, error) {
	out := new(Source)
	err := c.cc.Invoke(ctx, SecurityCenter_GetSource_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *securityCenterClient) GroupAssets(ctx context.Context, in *GroupAssetsRequest, opts ...grpc.CallOption) (*GroupAssetsResponse, error) {
	out := new(GroupAssetsResponse)
	err := c.cc.Invoke(ctx, SecurityCenter_GroupAssets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GroupFindings(ctx context.Context, in *GroupFindingsRequest, opts ...grpc.CallOption) (*GroupFindingsResponse, error) {
	out := new(GroupFindingsResponse)
	err := c.cc.Invoke(ctx, SecurityCenter_GroupFindings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *securityCenterClient) ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error) {
	out := new(ListAssetsResponse)
	err := c.cc.Invoke(ctx, SecurityCenter_ListAssets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListDescendantSecurityHealthAnalyticsCustomModules(ctx context.Context, in *ListDescendantSecurityHealthAnalyticsCustomModulesRequest, opts ...grpc.CallOption) (*ListDescendantSecurityHealthAnalyticsCustomModulesResponse, error) {
	out := new(ListDescendantSecurityHealthAnalyticsCustomModulesResponse)
	err := c.cc.Invoke(ctx, SecurityCenter_ListDescendantSecurityHealthAnalyticsCustomModules_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListFindings(ctx context.Context, in *ListFindingsRequest, opts ...grpc.CallOption) (*ListFindingsResponse, error) {
	out := new(ListFindingsResponse)
	err := c.cc.Invoke(ctx, SecurityCenter_ListFindings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListMuteConfigs(ctx context.Context, in *ListMuteConfigsRequest, opts ...grpc.CallOption) (*ListMuteConfigsResponse, error) {
	out := new(ListMuteConfigsResponse)
	err := c.cc.Invoke(ctx, SecurityCenter_ListMuteConfigs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListNotificationConfigs(ctx context.Context, in *ListNotificationConfigsRequest, opts ...grpc.CallOption) (*ListNotificationConfigsResponse, error) {
	out := new(ListNotificationConfigsResponse)
	err := c.cc.Invoke(ctx, SecurityCenter_ListNotificationConfigs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListEffectiveSecurityHealthAnalyticsCustomModules(ctx context.Context, in *ListEffectiveSecurityHealthAnalyticsCustomModulesRequest, opts ...grpc.CallOption) (*ListEffectiveSecurityHealthAnalyticsCustomModulesResponse, error) {
	out := new(ListEffectiveSecurityHealthAnalyticsCustomModulesResponse)
	err := c.cc.Invoke(ctx, SecurityCenter_ListEffectiveSecurityHealthAnalyticsCustomModules_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListSecurityHealthAnalyticsCustomModules(ctx context.Context, in *ListSecurityHealthAnalyticsCustomModulesRequest, opts ...grpc.CallOption) (*ListSecurityHealthAnalyticsCustomModulesResponse, error) {
	out := new(ListSecurityHealthAnalyticsCustomModulesResponse)
	err := c.cc.Invoke(ctx, SecurityCenter_ListSecurityHealthAnalyticsCustomModules_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListSources(ctx context.Context, in *ListSourcesRequest, opts ...grpc.CallOption) (*ListSourcesResponse, error) {
	out := new(ListSourcesResponse)
	err := c.cc.Invoke(ctx, SecurityCenter_ListSources_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *securityCenterClient) RunAssetDiscovery(ctx context.Context, in *RunAssetDiscoveryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, SecurityCenter_RunAssetDiscovery_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) SetFindingState(ctx context.Context, in *SetFindingStateRequest, opts ...grpc.CallOption) (*Finding, error) {
	out := new(Finding)
	err := c.cc.Invoke(ctx, SecurityCenter_SetFindingState_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) SetMute(ctx context.Context, in *SetMuteRequest, opts ...grpc.CallOption) (*Finding, error) {
	out := new(Finding)
	err := c.cc.Invoke(ctx, SecurityCenter_SetMute_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, SecurityCenter_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, SecurityCenter_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) SimulateSecurityHealthAnalyticsCustomModule(ctx context.Context, in *SimulateSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*SimulateSecurityHealthAnalyticsCustomModuleResponse, error) {
	out := new(SimulateSecurityHealthAnalyticsCustomModuleResponse)
	err := c.cc.Invoke(ctx, SecurityCenter_SimulateSecurityHealthAnalyticsCustomModule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateExternalSystem(ctx context.Context, in *UpdateExternalSystemRequest, opts ...grpc.CallOption) (*ExternalSystem, error) {
	out := new(ExternalSystem)
	err := c.cc.Invoke(ctx, SecurityCenter_UpdateExternalSystem_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateFinding(ctx context.Context, in *UpdateFindingRequest, opts ...grpc.CallOption) (*Finding, error) {
	out := new(Finding)
	err := c.cc.Invoke(ctx, SecurityCenter_UpdateFinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateMuteConfig(ctx context.Context, in *UpdateMuteConfigRequest, opts ...grpc.CallOption) (*MuteConfig, error) {
	out := new(MuteConfig)
	err := c.cc.Invoke(ctx, SecurityCenter_UpdateMuteConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateNotificationConfig(ctx context.Context, in *UpdateNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error) {
	out := new(NotificationConfig)
	err := c.cc.Invoke(ctx, SecurityCenter_UpdateNotificationConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateOrganizationSettings(ctx context.Context, in *UpdateOrganizationSettingsRequest, opts ...grpc.CallOption) (*OrganizationSettings, error) {
	out := new(OrganizationSettings)
	err := c.cc.Invoke(ctx, SecurityCenter_UpdateOrganizationSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateSecurityHealthAnalyticsCustomModule(ctx context.Context, in *UpdateSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*SecurityHealthAnalyticsCustomModule, error) {
	out := new(SecurityHealthAnalyticsCustomModule)
	err := c.cc.Invoke(ctx, SecurityCenter_UpdateSecurityHealthAnalyticsCustomModule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateSource(ctx context.Context, in *UpdateSourceRequest, opts ...grpc.CallOption) (*Source, error) {
	out := new(Source)
	err := c.cc.Invoke(ctx, SecurityCenter_UpdateSource_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateSecurityMarks(ctx context.Context, in *UpdateSecurityMarksRequest, opts ...grpc.CallOption) (*SecurityMarks, error) {
	out := new(SecurityMarks)
	err := c.cc.Invoke(ctx, SecurityCenter_UpdateSecurityMarks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) CreateBigQueryExport(ctx context.Context, in *CreateBigQueryExportRequest, opts ...grpc.CallOption) (*BigQueryExport, error) {
	out := new(BigQueryExport)
	err := c.cc.Invoke(ctx, SecurityCenter_CreateBigQueryExport_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) DeleteBigQueryExport(ctx context.Context, in *DeleteBigQueryExportRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, SecurityCenter_DeleteBigQueryExport_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateBigQueryExport(ctx context.Context, in *UpdateBigQueryExportRequest, opts ...grpc.CallOption) (*BigQueryExport, error) {
	out := new(BigQueryExport)
	err := c.cc.Invoke(ctx, SecurityCenter_UpdateBigQueryExport_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListBigQueryExports(ctx context.Context, in *ListBigQueryExportsRequest, opts ...grpc.CallOption) (*ListBigQueryExportsResponse, error) {
	out := new(ListBigQueryExportsResponse)
	err := c.cc.Invoke(ctx, SecurityCenter_ListBigQueryExports_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) CreateEventThreatDetectionCustomModule(ctx context.Context, in *CreateEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*EventThreatDetectionCustomModule, error) {
	out := new(EventThreatDetectionCustomModule)
	err := c.cc.Invoke(ctx, SecurityCenter_CreateEventThreatDetectionCustomModule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) DeleteEventThreatDetectionCustomModule(ctx context.Context, in *DeleteEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, SecurityCenter_DeleteEventThreatDetectionCustomModule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetEventThreatDetectionCustomModule(ctx context.Context, in *GetEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*EventThreatDetectionCustomModule, error) {
	out := new(EventThreatDetectionCustomModule)
	err := c.cc.Invoke(ctx, SecurityCenter_GetEventThreatDetectionCustomModule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListDescendantEventThreatDetectionCustomModules(ctx context.Context, in *ListDescendantEventThreatDetectionCustomModulesRequest, opts ...grpc.CallOption) (*ListDescendantEventThreatDetectionCustomModulesResponse, error) {
	out := new(ListDescendantEventThreatDetectionCustomModulesResponse)
	err := c.cc.Invoke(ctx, SecurityCenter_ListDescendantEventThreatDetectionCustomModules_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListEventThreatDetectionCustomModules(ctx context.Context, in *ListEventThreatDetectionCustomModulesRequest, opts ...grpc.CallOption) (*ListEventThreatDetectionCustomModulesResponse, error) {
	out := new(ListEventThreatDetectionCustomModulesResponse)
	err := c.cc.Invoke(ctx, SecurityCenter_ListEventThreatDetectionCustomModules_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateEventThreatDetectionCustomModule(ctx context.Context, in *UpdateEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*EventThreatDetectionCustomModule, error) {
	out := new(EventThreatDetectionCustomModule)
	err := c.cc.Invoke(ctx, SecurityCenter_UpdateEventThreatDetectionCustomModule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ValidateEventThreatDetectionCustomModule(ctx context.Context, in *ValidateEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*ValidateEventThreatDetectionCustomModuleResponse, error) {
	out := new(ValidateEventThreatDetectionCustomModuleResponse)
	err := c.cc.Invoke(ctx, SecurityCenter_ValidateEventThreatDetectionCustomModule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetEffectiveEventThreatDetectionCustomModule(ctx context.Context, in *GetEffectiveEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*EffectiveEventThreatDetectionCustomModule, error) {
	out := new(EffectiveEventThreatDetectionCustomModule)
	err := c.cc.Invoke(ctx, SecurityCenter_GetEffectiveEventThreatDetectionCustomModule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListEffectiveEventThreatDetectionCustomModules(ctx context.Context, in *ListEffectiveEventThreatDetectionCustomModulesRequest, opts ...grpc.CallOption) (*ListEffectiveEventThreatDetectionCustomModulesResponse, error) {
	out := new(ListEffectiveEventThreatDetectionCustomModulesResponse)
	err := c.cc.Invoke(ctx, SecurityCenter_ListEffectiveEventThreatDetectionCustomModules_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) BatchCreateResourceValueConfigs(ctx context.Context, in *BatchCreateResourceValueConfigsRequest, opts ...grpc.CallOption) (*BatchCreateResourceValueConfigsResponse, error) {
	out := new(BatchCreateResourceValueConfigsResponse)
	err := c.cc.Invoke(ctx, SecurityCenter_BatchCreateResourceValueConfigs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) DeleteResourceValueConfig(ctx context.Context, in *DeleteResourceValueConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, SecurityCenter_DeleteResourceValueConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetResourceValueConfig(ctx context.Context, in *GetResourceValueConfigRequest, opts ...grpc.CallOption) (*ResourceValueConfig, error) {
	out := new(ResourceValueConfig)
	err := c.cc.Invoke(ctx, SecurityCenter_GetResourceValueConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListResourceValueConfigs(ctx context.Context, in *ListResourceValueConfigsRequest, opts ...grpc.CallOption) (*ListResourceValueConfigsResponse, error) {
	out := new(ListResourceValueConfigsResponse)
	err := c.cc.Invoke(ctx, SecurityCenter_ListResourceValueConfigs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateResourceValueConfig(ctx context.Context, in *UpdateResourceValueConfigRequest, opts ...grpc.CallOption) (*ResourceValueConfig, error) {
	out := new(ResourceValueConfig)
	err := c.cc.Invoke(ctx, SecurityCenter_UpdateResourceValueConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListValuedResources(ctx context.Context, in *ListValuedResourcesRequest, opts ...grpc.CallOption) (*ListValuedResourcesResponse, error) {
	out := new(ListValuedResourcesResponse)
	err := c.cc.Invoke(ctx, SecurityCenter_ListValuedResources_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListAttackPaths(ctx context.Context, in *ListAttackPathsRequest, opts ...grpc.CallOption) (*ListAttackPathsResponse, error) {
	out := new(ListAttackPathsResponse)
	err := c.cc.Invoke(ctx, SecurityCenter_ListAttackPaths_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SecurityCenterServer is the server API for SecurityCenter service.
// All implementations should embed UnimplementedSecurityCenterServer
// for forward compatibility
type SecurityCenterServer interface {
	// Kicks off an LRO to bulk mute findings for a parent based on a filter. The
	// parent can be either an organization, folder or project. The findings
	// matched by the filter will be muted after the LRO is done.
	BulkMuteFindings(context.Context, *BulkMuteFindingsRequest) (*longrunningpb.Operation, error)
	// Creates a resident SecurityHealthAnalyticsCustomModule at the scope of the
	// given CRM parent, and also creates inherited
	// SecurityHealthAnalyticsCustomModules for all CRM descendants of the given
	// parent. These modules are enabled by default.
	CreateSecurityHealthAnalyticsCustomModule(context.Context, *CreateSecurityHealthAnalyticsCustomModuleRequest) (*SecurityHealthAnalyticsCustomModule, error)
	// Creates a source.
	CreateSource(context.Context, *CreateSourceRequest) (*Source, error)
	// Creates a finding. The corresponding source must exist for finding creation
	// to succeed.
	CreateFinding(context.Context, *CreateFindingRequest) (*Finding, error)
	// Creates a mute config.
	CreateMuteConfig(context.Context, *CreateMuteConfigRequest) (*MuteConfig, error)
	// Creates a notification config.
	CreateNotificationConfig(context.Context, *CreateNotificationConfigRequest) (*NotificationConfig, error)
	// Deletes an existing mute config.
	DeleteMuteConfig(context.Context, *DeleteMuteConfigRequest) (*emptypb.Empty, error)
	// Deletes a notification config.
	DeleteNotificationConfig(context.Context, *DeleteNotificationConfigRequest) (*emptypb.Empty, error)
	// Deletes the specified SecurityHealthAnalyticsCustomModule and all of its
	// descendants in the CRM hierarchy. This method is only supported for
	// resident custom modules.
	DeleteSecurityHealthAnalyticsCustomModule(context.Context, *DeleteSecurityHealthAnalyticsCustomModuleRequest) (*emptypb.Empty, error)
	// Get the simulation by name or the latest simulation for the given
	// organization.
	GetSimulation(context.Context, *GetSimulationRequest) (*Simulation, error)
	// Get the valued resource by name
	GetValuedResource(context.Context, *GetValuedResourceRequest) (*ValuedResource, error)
	// Gets a BigQuery export.
	GetBigQueryExport(context.Context, *GetBigQueryExportRequest) (*BigQueryExport, error)
	// Gets the access control policy on the specified Source.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Gets a mute config.
	GetMuteConfig(context.Context, *GetMuteConfigRequest) (*MuteConfig, error)
	// Gets a notification config.
	GetNotificationConfig(context.Context, *GetNotificationConfigRequest) (*NotificationConfig, error)
	// Gets the settings for an organization.
	GetOrganizationSettings(context.Context, *GetOrganizationSettingsRequest) (*OrganizationSettings, error)
	// Retrieves an EffectiveSecurityHealthAnalyticsCustomModule.
	GetEffectiveSecurityHealthAnalyticsCustomModule(context.Context, *GetEffectiveSecurityHealthAnalyticsCustomModuleRequest) (*EffectiveSecurityHealthAnalyticsCustomModule, error)
	// Retrieves a SecurityHealthAnalyticsCustomModule.
	GetSecurityHealthAnalyticsCustomModule(context.Context, *GetSecurityHealthAnalyticsCustomModuleRequest) (*SecurityHealthAnalyticsCustomModule, error)
	// Gets a source.
	GetSource(context.Context, *GetSourceRequest) (*Source, error)
	// Deprecated: Do not use.
	// Filters an organization's assets and  groups them by their specified
	// properties.
	GroupAssets(context.Context, *GroupAssetsRequest) (*GroupAssetsResponse, error)
	// Filters an organization or source's findings and  groups them by their
	// specified properties.
	//
	// To group across all sources provide a `-` as the source id.
	// Example: /v1/organizations/{organization_id}/sources/-/findings,
	// /v1/folders/{folder_id}/sources/-/findings,
	// /v1/projects/{project_id}/sources/-/findings
	GroupFindings(context.Context, *GroupFindingsRequest) (*GroupFindingsResponse, error)
	// Deprecated: Do not use.
	// Lists an organization's assets.
	ListAssets(context.Context, *ListAssetsRequest) (*ListAssetsResponse, error)
	// Returns a list of all resident SecurityHealthAnalyticsCustomModules under
	// the given CRM parent and all of the parent’s CRM descendants.
	ListDescendantSecurityHealthAnalyticsCustomModules(context.Context, *ListDescendantSecurityHealthAnalyticsCustomModulesRequest) (*ListDescendantSecurityHealthAnalyticsCustomModulesResponse, error)
	// Lists an organization or source's findings.
	//
	// To list across all sources provide a `-` as the source id.
	// Example: /v1/organizations/{organization_id}/sources/-/findings
	ListFindings(context.Context, *ListFindingsRequest) (*ListFindingsResponse, error)
	// Lists mute configs.
	ListMuteConfigs(context.Context, *ListMuteConfigsRequest) (*ListMuteConfigsResponse, error)
	// Lists notification configs.
	ListNotificationConfigs(context.Context, *ListNotificationConfigsRequest) (*ListNotificationConfigsResponse, error)
	// Returns a list of all EffectiveSecurityHealthAnalyticsCustomModules for the
	// given parent. This includes resident modules defined at the scope of the
	// parent, and inherited modules, inherited from CRM ancestors.
	ListEffectiveSecurityHealthAnalyticsCustomModules(context.Context, *ListEffectiveSecurityHealthAnalyticsCustomModulesRequest) (*ListEffectiveSecurityHealthAnalyticsCustomModulesResponse, error)
	// Returns a list of all SecurityHealthAnalyticsCustomModules for the given
	// parent. This includes resident modules defined at the scope of the parent,
	// and inherited modules, inherited from CRM ancestors.
	ListSecurityHealthAnalyticsCustomModules(context.Context, *ListSecurityHealthAnalyticsCustomModulesRequest) (*ListSecurityHealthAnalyticsCustomModulesResponse, error)
	// Lists all sources belonging to an organization.
	ListSources(context.Context, *ListSourcesRequest) (*ListSourcesResponse, error)
	// Deprecated: Do not use.
	// Runs asset discovery. The discovery is tracked with a long-running
	// operation.
	//
	// This API can only be called with limited frequency for an organization. If
	// it is called too frequently the caller will receive a TOO_MANY_REQUESTS
	// error.
	RunAssetDiscovery(context.Context, *RunAssetDiscoveryRequest) (*longrunningpb.Operation, error)
	// Updates the state of a finding.
	SetFindingState(context.Context, *SetFindingStateRequest) (*Finding, error)
	// Updates the mute state of a finding.
	SetMute(context.Context, *SetMuteRequest) (*Finding, error)
	// Sets the access control policy on the specified Source.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Returns the permissions that a caller has on the specified source.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
	// Simulates a given SecurityHealthAnalyticsCustomModule and Resource.
	SimulateSecurityHealthAnalyticsCustomModule(context.Context, *SimulateSecurityHealthAnalyticsCustomModuleRequest) (*SimulateSecurityHealthAnalyticsCustomModuleResponse, error)
	// Updates external system. This is for a given finding.
	UpdateExternalSystem(context.Context, *UpdateExternalSystemRequest) (*ExternalSystem, error)
	// Creates or updates a finding. The corresponding source must exist for a
	// finding creation to succeed.
	UpdateFinding(context.Context, *UpdateFindingRequest) (*Finding, error)
	// Updates a mute config.
	UpdateMuteConfig(context.Context, *UpdateMuteConfigRequest) (*MuteConfig, error)
	// Updates a notification config. The following update
	// fields are allowed: description, pubsub_topic, streaming_config.filter
	UpdateNotificationConfig(context.Context, *UpdateNotificationConfigRequest) (*NotificationConfig, error)
	// Updates an organization's settings.
	UpdateOrganizationSettings(context.Context, *UpdateOrganizationSettingsRequest) (*OrganizationSettings, error)
	// Updates the SecurityHealthAnalyticsCustomModule under the given name based
	// on the given update mask. Updating the enablement state is supported on
	// both resident and inherited modules (though resident modules cannot have an
	// enablement state of "inherited"). Updating the display name and custom
	// config of a module is supported on resident modules only.
	UpdateSecurityHealthAnalyticsCustomModule(context.Context, *UpdateSecurityHealthAnalyticsCustomModuleRequest) (*SecurityHealthAnalyticsCustomModule, error)
	// Updates a source.
	UpdateSource(context.Context, *UpdateSourceRequest) (*Source, error)
	// Updates security marks.
	UpdateSecurityMarks(context.Context, *UpdateSecurityMarksRequest) (*SecurityMarks, error)
	// Creates a BigQuery export.
	CreateBigQueryExport(context.Context, *CreateBigQueryExportRequest) (*BigQueryExport, error)
	// Deletes an existing BigQuery export.
	DeleteBigQueryExport(context.Context, *DeleteBigQueryExportRequest) (*emptypb.Empty, error)
	// Updates a BigQuery export.
	UpdateBigQueryExport(context.Context, *UpdateBigQueryExportRequest) (*BigQueryExport, error)
	// Lists BigQuery exports. Note that when requesting BigQuery exports at a
	// given level all exports under that level are also returned e.g. if
	// requesting BigQuery exports under a folder, then all BigQuery exports
	// immediately under the folder plus the ones created under the projects
	// within the folder are returned.
	ListBigQueryExports(context.Context, *ListBigQueryExportsRequest) (*ListBigQueryExportsResponse, error)
	// Creates a resident Event Threat Detection custom module at the scope of the
	// given Resource Manager parent, and also creates inherited custom modules
	// for all descendants of the given parent. These modules are enabled by
	// default.
	CreateEventThreatDetectionCustomModule(context.Context, *CreateEventThreatDetectionCustomModuleRequest) (*EventThreatDetectionCustomModule, error)
	// Deletes the specified Event Threat Detection custom module and all of its
	// descendants in the Resource Manager hierarchy. This method is only
	// supported for resident custom modules.
	DeleteEventThreatDetectionCustomModule(context.Context, *DeleteEventThreatDetectionCustomModuleRequest) (*emptypb.Empty, error)
	// Gets an Event Threat Detection custom module.
	GetEventThreatDetectionCustomModule(context.Context, *GetEventThreatDetectionCustomModuleRequest) (*EventThreatDetectionCustomModule, error)
	// Lists all resident Event Threat Detection custom modules under the
	// given Resource Manager parent and its descendants.
	ListDescendantEventThreatDetectionCustomModules(context.Context, *ListDescendantEventThreatDetectionCustomModulesRequest) (*ListDescendantEventThreatDetectionCustomModulesResponse, error)
	// Lists all Event Threat Detection custom modules for the given
	// Resource Manager parent. This includes resident modules defined at the
	// scope of the parent along with modules inherited from ancestors.
	ListEventThreatDetectionCustomModules(context.Context, *ListEventThreatDetectionCustomModulesRequest) (*ListEventThreatDetectionCustomModulesResponse, error)
	// Updates the Event Threat Detection custom module with the given name based
	// on the given update mask. Updating the enablement state is supported for
	// both resident and inherited modules (though resident modules cannot have an
	// enablement state of "inherited"). Updating the display name or
	// configuration of a module is supported for resident modules only. The type
	// of a module cannot be changed.
	UpdateEventThreatDetectionCustomModule(context.Context, *UpdateEventThreatDetectionCustomModuleRequest) (*EventThreatDetectionCustomModule, error)
	// Validates the given Event Threat Detection custom module.
	ValidateEventThreatDetectionCustomModule(context.Context, *ValidateEventThreatDetectionCustomModuleRequest) (*ValidateEventThreatDetectionCustomModuleResponse, error)
	// Gets an effective Event Threat Detection custom module at the given level.
	GetEffectiveEventThreatDetectionCustomModule(context.Context, *GetEffectiveEventThreatDetectionCustomModuleRequest) (*EffectiveEventThreatDetectionCustomModule, error)
	// Lists all effective Event Threat Detection custom modules for the
	// given parent. This includes resident modules defined at the scope of the
	// parent along with modules inherited from its ancestors.
	ListEffectiveEventThreatDetectionCustomModules(context.Context, *ListEffectiveEventThreatDetectionCustomModulesRequest) (*ListEffectiveEventThreatDetectionCustomModulesResponse, error)
	// Creates a ResourceValueConfig for an organization. Maps user's tags to
	// difference resource values for use by the attack path simulation.
	BatchCreateResourceValueConfigs(context.Context, *BatchCreateResourceValueConfigsRequest) (*BatchCreateResourceValueConfigsResponse, error)
	// Deletes a ResourceValueConfig.
	DeleteResourceValueConfig(context.Context, *DeleteResourceValueConfigRequest) (*emptypb.Empty, error)
	// Gets a ResourceValueConfig.
	GetResourceValueConfig(context.Context, *GetResourceValueConfigRequest) (*ResourceValueConfig, error)
	// Lists all ResourceValueConfigs.
	ListResourceValueConfigs(context.Context, *ListResourceValueConfigsRequest) (*ListResourceValueConfigsResponse, error)
	// Updates an existing ResourceValueConfigs with new rules.
	UpdateResourceValueConfig(context.Context, *UpdateResourceValueConfigRequest) (*ResourceValueConfig, error)
	// Lists the valued resources for a set of simulation results and filter.
	ListValuedResources(context.Context, *ListValuedResourcesRequest) (*ListValuedResourcesResponse, error)
	// Lists the attack paths for a set of simulation results or valued resources
	// and filter.
	ListAttackPaths(context.Context, *ListAttackPathsRequest) (*ListAttackPathsResponse, error)
}

// UnimplementedSecurityCenterServer should be embedded to have forward compatible implementations.
type UnimplementedSecurityCenterServer struct {
}

func (UnimplementedSecurityCenterServer) BulkMuteFindings(context.Context, *BulkMuteFindingsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BulkMuteFindings not implemented")
}
func (UnimplementedSecurityCenterServer) CreateSecurityHealthAnalyticsCustomModule(context.Context, *CreateSecurityHealthAnalyticsCustomModuleRequest) (*SecurityHealthAnalyticsCustomModule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSecurityHealthAnalyticsCustomModule not implemented")
}
func (UnimplementedSecurityCenterServer) CreateSource(context.Context, *CreateSourceRequest) (*Source, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSource not implemented")
}
func (UnimplementedSecurityCenterServer) CreateFinding(context.Context, *CreateFindingRequest) (*Finding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFinding not implemented")
}
func (UnimplementedSecurityCenterServer) CreateMuteConfig(context.Context, *CreateMuteConfigRequest) (*MuteConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMuteConfig not implemented")
}
func (UnimplementedSecurityCenterServer) CreateNotificationConfig(context.Context, *CreateNotificationConfigRequest) (*NotificationConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateNotificationConfig not implemented")
}
func (UnimplementedSecurityCenterServer) DeleteMuteConfig(context.Context, *DeleteMuteConfigRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMuteConfig not implemented")
}
func (UnimplementedSecurityCenterServer) DeleteNotificationConfig(context.Context, *DeleteNotificationConfigRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNotificationConfig not implemented")
}
func (UnimplementedSecurityCenterServer) DeleteSecurityHealthAnalyticsCustomModule(context.Context, *DeleteSecurityHealthAnalyticsCustomModuleRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSecurityHealthAnalyticsCustomModule not implemented")
}
func (UnimplementedSecurityCenterServer) GetSimulation(context.Context, *GetSimulationRequest) (*Simulation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSimulation not implemented")
}
func (UnimplementedSecurityCenterServer) GetValuedResource(context.Context, *GetValuedResourceRequest) (*ValuedResource, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetValuedResource not implemented")
}
func (UnimplementedSecurityCenterServer) GetBigQueryExport(context.Context, *GetBigQueryExportRequest) (*BigQueryExport, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBigQueryExport not implemented")
}
func (UnimplementedSecurityCenterServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedSecurityCenterServer) GetMuteConfig(context.Context, *GetMuteConfigRequest) (*MuteConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMuteConfig not implemented")
}
func (UnimplementedSecurityCenterServer) GetNotificationConfig(context.Context, *GetNotificationConfigRequest) (*NotificationConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNotificationConfig not implemented")
}
func (UnimplementedSecurityCenterServer) GetOrganizationSettings(context.Context, *GetOrganizationSettingsRequest) (*OrganizationSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOrganizationSettings not implemented")
}
func (UnimplementedSecurityCenterServer) GetEffectiveSecurityHealthAnalyticsCustomModule(context.Context, *GetEffectiveSecurityHealthAnalyticsCustomModuleRequest) (*EffectiveSecurityHealthAnalyticsCustomModule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEffectiveSecurityHealthAnalyticsCustomModule not implemented")
}
func (UnimplementedSecurityCenterServer) GetSecurityHealthAnalyticsCustomModule(context.Context, *GetSecurityHealthAnalyticsCustomModuleRequest) (*SecurityHealthAnalyticsCustomModule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSecurityHealthAnalyticsCustomModule not implemented")
}
func (UnimplementedSecurityCenterServer) GetSource(context.Context, *GetSourceRequest) (*Source, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSource not implemented")
}
func (UnimplementedSecurityCenterServer) GroupAssets(context.Context, *GroupAssetsRequest) (*GroupAssetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GroupAssets not implemented")
}
func (UnimplementedSecurityCenterServer) GroupFindings(context.Context, *GroupFindingsRequest) (*GroupFindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GroupFindings not implemented")
}
func (UnimplementedSecurityCenterServer) ListAssets(context.Context, *ListAssetsRequest) (*ListAssetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAssets not implemented")
}
func (UnimplementedSecurityCenterServer) ListDescendantSecurityHealthAnalyticsCustomModules(context.Context, *ListDescendantSecurityHealthAnalyticsCustomModulesRequest) (*ListDescendantSecurityHealthAnalyticsCustomModulesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDescendantSecurityHealthAnalyticsCustomModules not implemented")
}
func (UnimplementedSecurityCenterServer) ListFindings(context.Context, *ListFindingsRequest) (*ListFindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFindings not implemented")
}
func (UnimplementedSecurityCenterServer) ListMuteConfigs(context.Context, *ListMuteConfigsRequest) (*ListMuteConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMuteConfigs not implemented")
}
func (UnimplementedSecurityCenterServer) ListNotificationConfigs(context.Context, *ListNotificationConfigsRequest) (*ListNotificationConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNotificationConfigs not implemented")
}
func (UnimplementedSecurityCenterServer) ListEffectiveSecurityHealthAnalyticsCustomModules(context.Context, *ListEffectiveSecurityHealthAnalyticsCustomModulesRequest) (*ListEffectiveSecurityHealthAnalyticsCustomModulesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEffectiveSecurityHealthAnalyticsCustomModules not implemented")
}
func (UnimplementedSecurityCenterServer) ListSecurityHealthAnalyticsCustomModules(context.Context, *ListSecurityHealthAnalyticsCustomModulesRequest) (*ListSecurityHealthAnalyticsCustomModulesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSecurityHealthAnalyticsCustomModules not implemented")
}
func (UnimplementedSecurityCenterServer) ListSources(context.Context, *ListSourcesRequest) (*ListSourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSources not implemented")
}
func (UnimplementedSecurityCenterServer) RunAssetDiscovery(context.Context, *RunAssetDiscoveryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunAssetDiscovery not implemented")
}
func (UnimplementedSecurityCenterServer) SetFindingState(context.Context, *SetFindingStateRequest) (*Finding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetFindingState not implemented")
}
func (UnimplementedSecurityCenterServer) SetMute(context.Context, *SetMuteRequest) (*Finding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetMute not implemented")
}
func (UnimplementedSecurityCenterServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedSecurityCenterServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (UnimplementedSecurityCenterServer) SimulateSecurityHealthAnalyticsCustomModule(context.Context, *SimulateSecurityHealthAnalyticsCustomModuleRequest) (*SimulateSecurityHealthAnalyticsCustomModuleResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SimulateSecurityHealthAnalyticsCustomModule not implemented")
}
func (UnimplementedSecurityCenterServer) UpdateExternalSystem(context.Context, *UpdateExternalSystemRequest) (*ExternalSystem, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateExternalSystem not implemented")
}
func (UnimplementedSecurityCenterServer) UpdateFinding(context.Context, *UpdateFindingRequest) (*Finding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFinding not implemented")
}
func (UnimplementedSecurityCenterServer) UpdateMuteConfig(context.Context, *UpdateMuteConfigRequest) (*MuteConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateMuteConfig not implemented")
}
func (UnimplementedSecurityCenterServer) UpdateNotificationConfig(context.Context, *UpdateNotificationConfigRequest) (*NotificationConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateNotificationConfig not implemented")
}
func (UnimplementedSecurityCenterServer) UpdateOrganizationSettings(context.Context, *UpdateOrganizationSettingsRequest) (*OrganizationSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateOrganizationSettings not implemented")
}
func (UnimplementedSecurityCenterServer) UpdateSecurityHealthAnalyticsCustomModule(context.Context, *UpdateSecurityHealthAnalyticsCustomModuleRequest) (*SecurityHealthAnalyticsCustomModule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSecurityHealthAnalyticsCustomModule not implemented")
}
func (UnimplementedSecurityCenterServer) UpdateSource(context.Context, *UpdateSourceRequest) (*Source, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSource not implemented")
}
func (UnimplementedSecurityCenterServer) UpdateSecurityMarks(context.Context, *UpdateSecurityMarksRequest) (*SecurityMarks, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSecurityMarks not implemented")
}
func (UnimplementedSecurityCenterServer) CreateBigQueryExport(context.Context, *CreateBigQueryExportRequest) (*BigQueryExport, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBigQueryExport not implemented")
}
func (UnimplementedSecurityCenterServer) DeleteBigQueryExport(context.Context, *DeleteBigQueryExportRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBigQueryExport not implemented")
}
func (UnimplementedSecurityCenterServer) UpdateBigQueryExport(context.Context, *UpdateBigQueryExportRequest) (*BigQueryExport, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBigQueryExport not implemented")
}
func (UnimplementedSecurityCenterServer) ListBigQueryExports(context.Context, *ListBigQueryExportsRequest) (*ListBigQueryExportsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBigQueryExports not implemented")
}
func (UnimplementedSecurityCenterServer) CreateEventThreatDetectionCustomModule(context.Context, *CreateEventThreatDetectionCustomModuleRequest) (*EventThreatDetectionCustomModule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEventThreatDetectionCustomModule not implemented")
}
func (UnimplementedSecurityCenterServer) DeleteEventThreatDetectionCustomModule(context.Context, *DeleteEventThreatDetectionCustomModuleRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEventThreatDetectionCustomModule not implemented")
}
func (UnimplementedSecurityCenterServer) GetEventThreatDetectionCustomModule(context.Context, *GetEventThreatDetectionCustomModuleRequest) (*EventThreatDetectionCustomModule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEventThreatDetectionCustomModule not implemented")
}
func (UnimplementedSecurityCenterServer) ListDescendantEventThreatDetectionCustomModules(context.Context, *ListDescendantEventThreatDetectionCustomModulesRequest) (*ListDescendantEventThreatDetectionCustomModulesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDescendantEventThreatDetectionCustomModules not implemented")
}
func (UnimplementedSecurityCenterServer) ListEventThreatDetectionCustomModules(context.Context, *ListEventThreatDetectionCustomModulesRequest) (*ListEventThreatDetectionCustomModulesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEventThreatDetectionCustomModules not implemented")
}
func (UnimplementedSecurityCenterServer) UpdateEventThreatDetectionCustomModule(context.Context, *UpdateEventThreatDetectionCustomModuleRequest) (*EventThreatDetectionCustomModule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEventThreatDetectionCustomModule not implemented")
}
func (UnimplementedSecurityCenterServer) ValidateEventThreatDetectionCustomModule(context.Context, *ValidateEventThreatDetectionCustomModuleRequest) (*ValidateEventThreatDetectionCustomModuleResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateEventThreatDetectionCustomModule not implemented")
}
func (UnimplementedSecurityCenterServer) GetEffectiveEventThreatDetectionCustomModule(context.Context, *GetEffectiveEventThreatDetectionCustomModuleRequest) (*EffectiveEventThreatDetectionCustomModule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEffectiveEventThreatDetectionCustomModule not implemented")
}
func (UnimplementedSecurityCenterServer) ListEffectiveEventThreatDetectionCustomModules(context.Context, *ListEffectiveEventThreatDetectionCustomModulesRequest) (*ListEffectiveEventThreatDetectionCustomModulesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEffectiveEventThreatDetectionCustomModules not implemented")
}
func (UnimplementedSecurityCenterServer) BatchCreateResourceValueConfigs(context.Context, *BatchCreateResourceValueConfigsRequest) (*BatchCreateResourceValueConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateResourceValueConfigs not implemented")
}
func (UnimplementedSecurityCenterServer) DeleteResourceValueConfig(context.Context, *DeleteResourceValueConfigRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteResourceValueConfig not implemented")
}
func (UnimplementedSecurityCenterServer) GetResourceValueConfig(context.Context, *GetResourceValueConfigRequest) (*ResourceValueConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetResourceValueConfig not implemented")
}
func (UnimplementedSecurityCenterServer) ListResourceValueConfigs(context.Context, *ListResourceValueConfigsRequest) (*ListResourceValueConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListResourceValueConfigs not implemented")
}
func (UnimplementedSecurityCenterServer) UpdateResourceValueConfig(context.Context, *UpdateResourceValueConfigRequest) (*ResourceValueConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateResourceValueConfig not implemented")
}
func (UnimplementedSecurityCenterServer) ListValuedResources(context.Context, *ListValuedResourcesRequest) (*ListValuedResourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListValuedResources not implemented")
}
func (UnimplementedSecurityCenterServer) ListAttackPaths(context.Context, *ListAttackPathsRequest) (*ListAttackPathsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAttackPaths not implemented")
}

// UnsafeSecurityCenterServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SecurityCenterServer will
// result in compilation errors.
type UnsafeSecurityCenterServer interface {
	mustEmbedUnimplementedSecurityCenterServer()
}

func RegisterSecurityCenterServer(s grpc.ServiceRegistrar, srv SecurityCenterServer) {
	s.RegisterService(&SecurityCenter_ServiceDesc, srv)
}

func _SecurityCenter_BulkMuteFindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BulkMuteFindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).BulkMuteFindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_BulkMuteFindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).BulkMuteFindings(ctx, req.(*BulkMuteFindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_CreateSecurityHealthAnalyticsCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSecurityHealthAnalyticsCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateSecurityHealthAnalyticsCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_CreateSecurityHealthAnalyticsCustomModule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateSecurityHealthAnalyticsCustomModule(ctx, req.(*CreateSecurityHealthAnalyticsCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_CreateSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_CreateSource_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateSource(ctx, req.(*CreateSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_CreateFinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateFinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_CreateFinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateFinding(ctx, req.(*CreateFindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_CreateMuteConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMuteConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateMuteConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_CreateMuteConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateMuteConfig(ctx, req.(*CreateMuteConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_CreateNotificationConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNotificationConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateNotificationConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_CreateNotificationConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateNotificationConfig(ctx, req.(*CreateNotificationConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_DeleteMuteConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMuteConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).DeleteMuteConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_DeleteMuteConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).DeleteMuteConfig(ctx, req.(*DeleteMuteConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_DeleteNotificationConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNotificationConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).DeleteNotificationConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_DeleteNotificationConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).DeleteNotificationConfig(ctx, req.(*DeleteNotificationConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_DeleteSecurityHealthAnalyticsCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSecurityHealthAnalyticsCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).DeleteSecurityHealthAnalyticsCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_DeleteSecurityHealthAnalyticsCustomModule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).DeleteSecurityHealthAnalyticsCustomModule(ctx, req.(*DeleteSecurityHealthAnalyticsCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetSimulation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSimulationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetSimulation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_GetSimulation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetSimulation(ctx, req.(*GetSimulationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetValuedResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetValuedResourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetValuedResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_GetValuedResource_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetValuedResource(ctx, req.(*GetValuedResourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetBigQueryExport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBigQueryExportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetBigQueryExport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_GetBigQueryExport_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetBigQueryExport(ctx, req.(*GetBigQueryExportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetMuteConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMuteConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetMuteConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_GetMuteConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetMuteConfig(ctx, req.(*GetMuteConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetNotificationConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNotificationConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetNotificationConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_GetNotificationConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetNotificationConfig(ctx, req.(*GetNotificationConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetOrganizationSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOrganizationSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetOrganizationSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_GetOrganizationSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetOrganizationSettings(ctx, req.(*GetOrganizationSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetEffectiveSecurityHealthAnalyticsCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEffectiveSecurityHealthAnalyticsCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetEffectiveSecurityHealthAnalyticsCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_GetEffectiveSecurityHealthAnalyticsCustomModule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetEffectiveSecurityHealthAnalyticsCustomModule(ctx, req.(*GetEffectiveSecurityHealthAnalyticsCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetSecurityHealthAnalyticsCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSecurityHealthAnalyticsCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetSecurityHealthAnalyticsCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_GetSecurityHealthAnalyticsCustomModule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetSecurityHealthAnalyticsCustomModule(ctx, req.(*GetSecurityHealthAnalyticsCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_GetSource_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetSource(ctx, req.(*GetSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GroupAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GroupAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GroupAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_GroupAssets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GroupAssets(ctx, req.(*GroupAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GroupFindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GroupFindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GroupFindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_GroupFindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GroupFindings(ctx, req.(*GroupFindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_ListAssets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListAssets(ctx, req.(*ListAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListDescendantSecurityHealthAnalyticsCustomModules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDescendantSecurityHealthAnalyticsCustomModulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListDescendantSecurityHealthAnalyticsCustomModules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_ListDescendantSecurityHealthAnalyticsCustomModules_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListDescendantSecurityHealthAnalyticsCustomModules(ctx, req.(*ListDescendantSecurityHealthAnalyticsCustomModulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListFindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListFindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_ListFindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListFindings(ctx, req.(*ListFindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListMuteConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMuteConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListMuteConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_ListMuteConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListMuteConfigs(ctx, req.(*ListMuteConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListNotificationConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNotificationConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListNotificationConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_ListNotificationConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListNotificationConfigs(ctx, req.(*ListNotificationConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListEffectiveSecurityHealthAnalyticsCustomModules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEffectiveSecurityHealthAnalyticsCustomModulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListEffectiveSecurityHealthAnalyticsCustomModules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_ListEffectiveSecurityHealthAnalyticsCustomModules_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListEffectiveSecurityHealthAnalyticsCustomModules(ctx, req.(*ListEffectiveSecurityHealthAnalyticsCustomModulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListSecurityHealthAnalyticsCustomModules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSecurityHealthAnalyticsCustomModulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListSecurityHealthAnalyticsCustomModules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_ListSecurityHealthAnalyticsCustomModules_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListSecurityHealthAnalyticsCustomModules(ctx, req.(*ListSecurityHealthAnalyticsCustomModulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListSources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListSources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_ListSources_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListSources(ctx, req.(*ListSourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_RunAssetDiscovery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunAssetDiscoveryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).RunAssetDiscovery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_RunAssetDiscovery_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).RunAssetDiscovery(ctx, req.(*RunAssetDiscoveryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_SetFindingState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetFindingStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).SetFindingState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_SetFindingState_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).SetFindingState(ctx, req.(*SetFindingStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_SetMute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetMuteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).SetMute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_SetMute_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).SetMute(ctx, req.(*SetMuteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_SimulateSecurityHealthAnalyticsCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SimulateSecurityHealthAnalyticsCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).SimulateSecurityHealthAnalyticsCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_SimulateSecurityHealthAnalyticsCustomModule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).SimulateSecurityHealthAnalyticsCustomModule(ctx, req.(*SimulateSecurityHealthAnalyticsCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateExternalSystem_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateExternalSystemRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateExternalSystem(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_UpdateExternalSystem_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateExternalSystem(ctx, req.(*UpdateExternalSystemRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateFinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateFinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_UpdateFinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateFinding(ctx, req.(*UpdateFindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateMuteConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMuteConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateMuteConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_UpdateMuteConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateMuteConfig(ctx, req.(*UpdateMuteConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateNotificationConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNotificationConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateNotificationConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_UpdateNotificationConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateNotificationConfig(ctx, req.(*UpdateNotificationConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateOrganizationSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateOrganizationSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateOrganizationSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_UpdateOrganizationSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateOrganizationSettings(ctx, req.(*UpdateOrganizationSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateSecurityHealthAnalyticsCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSecurityHealthAnalyticsCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateSecurityHealthAnalyticsCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_UpdateSecurityHealthAnalyticsCustomModule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateSecurityHealthAnalyticsCustomModule(ctx, req.(*UpdateSecurityHealthAnalyticsCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_UpdateSource_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateSource(ctx, req.(*UpdateSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateSecurityMarks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSecurityMarksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateSecurityMarks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_UpdateSecurityMarks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateSecurityMarks(ctx, req.(*UpdateSecurityMarksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_CreateBigQueryExport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBigQueryExportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateBigQueryExport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_CreateBigQueryExport_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateBigQueryExport(ctx, req.(*CreateBigQueryExportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_DeleteBigQueryExport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBigQueryExportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).DeleteBigQueryExport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_DeleteBigQueryExport_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).DeleteBigQueryExport(ctx, req.(*DeleteBigQueryExportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateBigQueryExport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBigQueryExportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateBigQueryExport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_UpdateBigQueryExport_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateBigQueryExport(ctx, req.(*UpdateBigQueryExportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListBigQueryExports_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBigQueryExportsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListBigQueryExports(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_ListBigQueryExports_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListBigQueryExports(ctx, req.(*ListBigQueryExportsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_CreateEventThreatDetectionCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEventThreatDetectionCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateEventThreatDetectionCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_CreateEventThreatDetectionCustomModule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateEventThreatDetectionCustomModule(ctx, req.(*CreateEventThreatDetectionCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_DeleteEventThreatDetectionCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEventThreatDetectionCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).DeleteEventThreatDetectionCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_DeleteEventThreatDetectionCustomModule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).DeleteEventThreatDetectionCustomModule(ctx, req.(*DeleteEventThreatDetectionCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetEventThreatDetectionCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEventThreatDetectionCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetEventThreatDetectionCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_GetEventThreatDetectionCustomModule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetEventThreatDetectionCustomModule(ctx, req.(*GetEventThreatDetectionCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListDescendantEventThreatDetectionCustomModules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDescendantEventThreatDetectionCustomModulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListDescendantEventThreatDetectionCustomModules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_ListDescendantEventThreatDetectionCustomModules_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListDescendantEventThreatDetectionCustomModules(ctx, req.(*ListDescendantEventThreatDetectionCustomModulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListEventThreatDetectionCustomModules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEventThreatDetectionCustomModulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListEventThreatDetectionCustomModules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_ListEventThreatDetectionCustomModules_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListEventThreatDetectionCustomModules(ctx, req.(*ListEventThreatDetectionCustomModulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateEventThreatDetectionCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEventThreatDetectionCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateEventThreatDetectionCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_UpdateEventThreatDetectionCustomModule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateEventThreatDetectionCustomModule(ctx, req.(*UpdateEventThreatDetectionCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ValidateEventThreatDetectionCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateEventThreatDetectionCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ValidateEventThreatDetectionCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_ValidateEventThreatDetectionCustomModule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ValidateEventThreatDetectionCustomModule(ctx, req.(*ValidateEventThreatDetectionCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetEffectiveEventThreatDetectionCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEffectiveEventThreatDetectionCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetEffectiveEventThreatDetectionCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_GetEffectiveEventThreatDetectionCustomModule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetEffectiveEventThreatDetectionCustomModule(ctx, req.(*GetEffectiveEventThreatDetectionCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListEffectiveEventThreatDetectionCustomModules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEffectiveEventThreatDetectionCustomModulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListEffectiveEventThreatDetectionCustomModules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_ListEffectiveEventThreatDetectionCustomModules_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListEffectiveEventThreatDetectionCustomModules(ctx, req.(*ListEffectiveEventThreatDetectionCustomModulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_BatchCreateResourceValueConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateResourceValueConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).BatchCreateResourceValueConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_BatchCreateResourceValueConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).BatchCreateResourceValueConfigs(ctx, req.(*BatchCreateResourceValueConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_DeleteResourceValueConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteResourceValueConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).DeleteResourceValueConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_DeleteResourceValueConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).DeleteResourceValueConfig(ctx, req.(*DeleteResourceValueConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetResourceValueConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetResourceValueConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetResourceValueConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_GetResourceValueConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetResourceValueConfig(ctx, req.(*GetResourceValueConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListResourceValueConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListResourceValueConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListResourceValueConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_ListResourceValueConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListResourceValueConfigs(ctx, req.(*ListResourceValueConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateResourceValueConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateResourceValueConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateResourceValueConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_UpdateResourceValueConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateResourceValueConfig(ctx, req.(*UpdateResourceValueConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListValuedResources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListValuedResourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListValuedResources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_ListValuedResources_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListValuedResources(ctx, req.(*ListValuedResourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListAttackPaths_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAttackPathsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListAttackPaths(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_ListAttackPaths_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListAttackPaths(ctx, req.(*ListAttackPathsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// SecurityCenter_ServiceDesc is the grpc.ServiceDesc for SecurityCenter service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var SecurityCenter_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.securitycenter.v1.SecurityCenter",
	HandlerType: (*SecurityCenterServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "BulkMuteFindings",
			Handler:    _SecurityCenter_BulkMuteFindings_Handler,
		},
		{
			MethodName: "CreateSecurityHealthAnalyticsCustomModule",
			Handler:    _SecurityCenter_CreateSecurityHealthAnalyticsCustomModule_Handler,
		},
		{
			MethodName: "CreateSource",
			Handler:    _SecurityCenter_CreateSource_Handler,
		},
		{
			MethodName: "CreateFinding",
			Handler:    _SecurityCenter_CreateFinding_Handler,
		},
		{
			MethodName: "CreateMuteConfig",
			Handler:    _SecurityCenter_CreateMuteConfig_Handler,
		},
		{
			MethodName: "CreateNotificationConfig",
			Handler:    _SecurityCenter_CreateNotificationConfig_Handler,
		},
		{
			MethodName: "DeleteMuteConfig",
			Handler:    _SecurityCenter_DeleteMuteConfig_Handler,
		},
		{
			MethodName: "DeleteNotificationConfig",
			Handler:    _SecurityCenter_DeleteNotificationConfig_Handler,
		},
		{
			MethodName: "DeleteSecurityHealthAnalyticsCustomModule",
			Handler:    _SecurityCenter_DeleteSecurityHealthAnalyticsCustomModule_Handler,
		},
		{
			MethodName: "GetSimulation",
			Handler:    _SecurityCenter_GetSimulation_Handler,
		},
		{
			MethodName: "GetValuedResource",
			Handler:    _SecurityCenter_GetValuedResource_Handler,
		},
		{
			MethodName: "GetBigQueryExport",
			Handler:    _SecurityCenter_GetBigQueryExport_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _SecurityCenter_GetIamPolicy_Handler,
		},
		{
			MethodName: "GetMuteConfig",
			Handler:    _SecurityCenter_GetMuteConfig_Handler,
		},
		{
			MethodName: "GetNotificationConfig",
			Handler:    _SecurityCenter_GetNotificationConfig_Handler,
		},
		{
			MethodName: "GetOrganizationSettings",
			Handler:    _SecurityCenter_GetOrganizationSettings_Handler,
		},
		{
			MethodName: "GetEffectiveSecurityHealthAnalyticsCustomModule",
			Handler:    _SecurityCenter_GetEffectiveSecurityHealthAnalyticsCustomModule_Handler,
		},
		{
			MethodName: "GetSecurityHealthAnalyticsCustomModule",
			Handler:    _SecurityCenter_GetSecurityHealthAnalyticsCustomModule_Handler,
		},
		{
			MethodName: "GetSource",
			Handler:    _SecurityCenter_GetSource_Handler,
		},
		{
			MethodName: "GroupAssets",
			Handler:    _SecurityCenter_GroupAssets_Handler,
		},
		{
			MethodName: "GroupFindings",
			Handler:    _SecurityCenter_GroupFindings_Handler,
		},
		{
			MethodName: "ListAssets",
			Handler:    _SecurityCenter_ListAssets_Handler,
		},
		{
			MethodName: "ListDescendantSecurityHealthAnalyticsCustomModules",
			Handler:    _SecurityCenter_ListDescendantSecurityHealthAnalyticsCustomModules_Handler,
		},
		{
			MethodName: "ListFindings",
			Handler:    _SecurityCenter_ListFindings_Handler,
		},
		{
			MethodName: "ListMuteConfigs",
			Handler:    _SecurityCenter_ListMuteConfigs_Handler,
		},
		{
			MethodName: "ListNotificationConfigs",
			Handler:    _SecurityCenter_ListNotificationConfigs_Handler,
		},
		{
			MethodName: "ListEffectiveSecurityHealthAnalyticsCustomModules",
			Handler:    _SecurityCenter_ListEffectiveSecurityHealthAnalyticsCustomModules_Handler,
		},
		{
			MethodName: "ListSecurityHealthAnalyticsCustomModules",
			Handler:    _SecurityCenter_ListSecurityHealthAnalyticsCustomModules_Handler,
		},
		{
			MethodName: "ListSources",
			Handler:    _SecurityCenter_ListSources_Handler,
		},
		{
			MethodName: "RunAssetDiscovery",
			Handler:    _SecurityCenter_RunAssetDiscovery_Handler,
		},
		{
			MethodName: "SetFindingState",
			Handler:    _SecurityCenter_SetFindingState_Handler,
		},
		{
			MethodName: "SetMute",
			Handler:    _SecurityCenter_SetMute_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _SecurityCenter_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _SecurityCenter_TestIamPermissions_Handler,
		},
		{
			MethodName: "SimulateSecurityHealthAnalyticsCustomModule",
			Handler:    _SecurityCenter_SimulateSecurityHealthAnalyticsCustomModule_Handler,
		},
		{
			MethodName: "UpdateExternalSystem",
			Handler:    _SecurityCenter_UpdateExternalSystem_Handler,
		},
		{
			MethodName: "UpdateFinding",
			Handler:    _SecurityCenter_UpdateFinding_Handler,
		},
		{
			MethodName: "UpdateMuteConfig",
			Handler:    _SecurityCenter_UpdateMuteConfig_Handler,
		},
		{
			MethodName: "UpdateNotificationConfig",
			Handler:    _SecurityCenter_UpdateNotificationConfig_Handler,
		},
		{
			MethodName: "UpdateOrganizationSettings",
			Handler:    _SecurityCenter_UpdateOrganizationSettings_Handler,
		},
		{
			MethodName: "UpdateSecurityHealthAnalyticsCustomModule",
			Handler:    _SecurityCenter_UpdateSecurityHealthAnalyticsCustomModule_Handler,
		},
		{
			MethodName: "UpdateSource",
			Handler:    _SecurityCenter_UpdateSource_Handler,
		},
		{
			MethodName: "UpdateSecurityMarks",
			Handler:    _SecurityCenter_UpdateSecurityMarks_Handler,
		},
		{
			MethodName: "CreateBigQueryExport",
			Handler:    _SecurityCenter_CreateBigQueryExport_Handler,
		},
		{
			MethodName: "DeleteBigQueryExport",
			Handler:    _SecurityCenter_DeleteBigQueryExport_Handler,
		},
		{
			MethodName: "UpdateBigQueryExport",
			Handler:    _SecurityCenter_UpdateBigQueryExport_Handler,
		},
		{
			MethodName: "ListBigQueryExports",
			Handler:    _SecurityCenter_ListBigQueryExports_Handler,
		},
		{
			MethodName: "CreateEventThreatDetectionCustomModule",
			Handler:    _SecurityCenter_CreateEventThreatDetectionCustomModule_Handler,
		},
		{
			MethodName: "DeleteEventThreatDetectionCustomModule",
			Handler:    _SecurityCenter_DeleteEventThreatDetectionCustomModule_Handler,
		},
		{
			MethodName: "GetEventThreatDetectionCustomModule",
			Handler:    _SecurityCenter_GetEventThreatDetectionCustomModule_Handler,
		},
		{
			MethodName: "ListDescendantEventThreatDetectionCustomModules",
			Handler:    _SecurityCenter_ListDescendantEventThreatDetectionCustomModules_Handler,
		},
		{
			MethodName: "ListEventThreatDetectionCustomModules",
			Handler:    _SecurityCenter_ListEventThreatDetectionCustomModules_Handler,
		},
		{
			MethodName: "UpdateEventThreatDetectionCustomModule",
			Handler:    _SecurityCenter_UpdateEventThreatDetectionCustomModule_Handler,
		},
		{
			MethodName: "ValidateEventThreatDetectionCustomModule",
			Handler:    _SecurityCenter_ValidateEventThreatDetectionCustomModule_Handler,
		},
		{
			MethodName: "GetEffectiveEventThreatDetectionCustomModule",
			Handler:    _SecurityCenter_GetEffectiveEventThreatDetectionCustomModule_Handler,
		},
		{
			MethodName: "ListEffectiveEventThreatDetectionCustomModules",
			Handler:    _SecurityCenter_ListEffectiveEventThreatDetectionCustomModules_Handler,
		},
		{
			MethodName: "BatchCreateResourceValueConfigs",
			Handler:    _SecurityCenter_BatchCreateResourceValueConfigs_Handler,
		},
		{
			MethodName: "DeleteResourceValueConfig",
			Handler:    _SecurityCenter_DeleteResourceValueConfig_Handler,
		},
		{
			MethodName: "GetResourceValueConfig",
			Handler:    _SecurityCenter_GetResourceValueConfig_Handler,
		},
		{
			MethodName: "ListResourceValueConfigs",
			Handler:    _SecurityCenter_ListResourceValueConfigs_Handler,
		},
		{
			MethodName: "UpdateResourceValueConfig",
			Handler:    _SecurityCenter_UpdateResourceValueConfig_Handler,
		},
		{
			MethodName: "ListValuedResources",
			Handler:    _SecurityCenter_ListValuedResources_Handler,
		},
		{
			MethodName: "ListAttackPaths",
			Handler:    _SecurityCenter_ListAttackPaths_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/securitycenter/v1/securitycenter_service.proto",
}
