// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/run/v2/build.proto

package runpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Builds_SubmitBuild_FullMethodName = "/google.cloud.run.v2.Builds/SubmitBuild"
)

// BuildsClient is the client API for Builds service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type BuildsClient interface {
	// Submits a build in a given project.
	SubmitBuild(ctx context.Context, in *SubmitBuildRequest, opts ...grpc.CallOption) (*SubmitBuildResponse, error)
}

type buildsClient struct {
	cc grpc.ClientConnInterface
}

func NewBuildsClient(cc grpc.ClientConnInterface) BuildsClient {
	return &buildsClient{cc}
}

func (c *buildsClient) SubmitBuild(ctx context.Context, in *SubmitBuildRequest, opts ...grpc.CallOption) (*SubmitBuildResponse, error) {
	out := new(SubmitBuildResponse)
	err := c.cc.Invoke(ctx, Builds_SubmitBuild_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BuildsServer is the server API for Builds service.
// All implementations should embed UnimplementedBuildsServer
// for forward compatibility
type BuildsServer interface {
	// Submits a build in a given project.
	SubmitBuild(context.Context, *SubmitBuildRequest) (*SubmitBuildResponse, error)
}

// UnimplementedBuildsServer should be embedded to have forward compatible implementations.
type UnimplementedBuildsServer struct {
}

func (UnimplementedBuildsServer) SubmitBuild(context.Context, *SubmitBuildRequest) (*SubmitBuildResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SubmitBuild not implemented")
}

// UnsafeBuildsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BuildsServer will
// result in compilation errors.
type UnsafeBuildsServer interface {
	mustEmbedUnimplementedBuildsServer()
}

func RegisterBuildsServer(s grpc.ServiceRegistrar, srv BuildsServer) {
	s.RegisterService(&Builds_ServiceDesc, srv)
}

func _Builds_SubmitBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SubmitBuildRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BuildsServer).SubmitBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Builds_SubmitBuild_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BuildsServer).SubmitBuild(ctx, req.(*SubmitBuildRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Builds_ServiceDesc is the grpc.ServiceDesc for Builds service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Builds_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.run.v2.Builds",
	HandlerType: (*BuildsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SubmitBuild",
			Handler:    _Builds_SubmitBuild_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/run/v2/build.proto",
}
