// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/recommendationengine/v1beta1/user_event_service.proto

package recommendationenginepb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	httpbody "google.golang.org/genproto/googleapis/api/httpbody"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	UserEventService_WriteUserEvent_FullMethodName   = "/google.cloud.recommendationengine.v1beta1.UserEventService/WriteUserEvent"
	UserEventService_CollectUserEvent_FullMethodName = "/google.cloud.recommendationengine.v1beta1.UserEventService/CollectUserEvent"
	UserEventService_ListUserEvents_FullMethodName   = "/google.cloud.recommendationengine.v1beta1.UserEventService/ListUserEvents"
	UserEventService_PurgeUserEvents_FullMethodName  = "/google.cloud.recommendationengine.v1beta1.UserEventService/PurgeUserEvents"
	UserEventService_ImportUserEvents_FullMethodName = "/google.cloud.recommendationengine.v1beta1.UserEventService/ImportUserEvents"
)

// UserEventServiceClient is the client API for UserEventService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type UserEventServiceClient interface {
	// Writes a single user event.
	WriteUserEvent(ctx context.Context, in *WriteUserEventRequest, opts ...grpc.CallOption) (*UserEvent, error)
	// Writes a single user event from the browser. This uses a GET request to
	// due to browser restriction of POST-ing to a 3rd party domain.
	//
	// This method is used only by the Recommendations AI JavaScript pixel.
	// Users should not call this method directly.
	CollectUserEvent(ctx context.Context, in *CollectUserEventRequest, opts ...grpc.CallOption) (*httpbody.HttpBody, error)
	// Gets a list of user events within a time range, with potential filtering.
	ListUserEvents(ctx context.Context, in *ListUserEventsRequest, opts ...grpc.CallOption) (*ListUserEventsResponse, error)
	// Deletes permanently all user events specified by the filter provided.
	// Depending on the number of events specified by the filter, this operation
	// could take hours or days to complete. To test a filter, use the list
	// command first.
	PurgeUserEvents(ctx context.Context, in *PurgeUserEventsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Bulk import of User events. Request processing might be
	// synchronous. Events that already exist are skipped.
	// Use this method for backfilling historical user events.
	//
	// Operation.response is of type ImportResponse. Note that it is
	// possible for a subset of the items to be successfully inserted.
	// Operation.metadata is of type ImportMetadata.
	ImportUserEvents(ctx context.Context, in *ImportUserEventsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type userEventServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewUserEventServiceClient(cc grpc.ClientConnInterface) UserEventServiceClient {
	return &userEventServiceClient{cc}
}

func (c *userEventServiceClient) WriteUserEvent(ctx context.Context, in *WriteUserEventRequest, opts ...grpc.CallOption) (*UserEvent, error) {
	out := new(UserEvent)
	err := c.cc.Invoke(ctx, UserEventService_WriteUserEvent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userEventServiceClient) CollectUserEvent(ctx context.Context, in *CollectUserEventRequest, opts ...grpc.CallOption) (*httpbody.HttpBody, error) {
	out := new(httpbody.HttpBody)
	err := c.cc.Invoke(ctx, UserEventService_CollectUserEvent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userEventServiceClient) ListUserEvents(ctx context.Context, in *ListUserEventsRequest, opts ...grpc.CallOption) (*ListUserEventsResponse, error) {
	out := new(ListUserEventsResponse)
	err := c.cc.Invoke(ctx, UserEventService_ListUserEvents_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userEventServiceClient) PurgeUserEvents(ctx context.Context, in *PurgeUserEventsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, UserEventService_PurgeUserEvents_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userEventServiceClient) ImportUserEvents(ctx context.Context, in *ImportUserEventsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, UserEventService_ImportUserEvents_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// UserEventServiceServer is the server API for UserEventService service.
// All implementations should embed UnimplementedUserEventServiceServer
// for forward compatibility
type UserEventServiceServer interface {
	// Writes a single user event.
	WriteUserEvent(context.Context, *WriteUserEventRequest) (*UserEvent, error)
	// Writes a single user event from the browser. This uses a GET request to
	// due to browser restriction of POST-ing to a 3rd party domain.
	//
	// This method is used only by the Recommendations AI JavaScript pixel.
	// Users should not call this method directly.
	CollectUserEvent(context.Context, *CollectUserEventRequest) (*httpbody.HttpBody, error)
	// Gets a list of user events within a time range, with potential filtering.
	ListUserEvents(context.Context, *ListUserEventsRequest) (*ListUserEventsResponse, error)
	// Deletes permanently all user events specified by the filter provided.
	// Depending on the number of events specified by the filter, this operation
	// could take hours or days to complete. To test a filter, use the list
	// command first.
	PurgeUserEvents(context.Context, *PurgeUserEventsRequest) (*longrunningpb.Operation, error)
	// Bulk import of User events. Request processing might be
	// synchronous. Events that already exist are skipped.
	// Use this method for backfilling historical user events.
	//
	// Operation.response is of type ImportResponse. Note that it is
	// possible for a subset of the items to be successfully inserted.
	// Operation.metadata is of type ImportMetadata.
	ImportUserEvents(context.Context, *ImportUserEventsRequest) (*longrunningpb.Operation, error)
}

// UnimplementedUserEventServiceServer should be embedded to have forward compatible implementations.
type UnimplementedUserEventServiceServer struct {
}

func (UnimplementedUserEventServiceServer) WriteUserEvent(context.Context, *WriteUserEventRequest) (*UserEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WriteUserEvent not implemented")
}
func (UnimplementedUserEventServiceServer) CollectUserEvent(context.Context, *CollectUserEventRequest) (*httpbody.HttpBody, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CollectUserEvent not implemented")
}
func (UnimplementedUserEventServiceServer) ListUserEvents(context.Context, *ListUserEventsRequest) (*ListUserEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListUserEvents not implemented")
}
func (UnimplementedUserEventServiceServer) PurgeUserEvents(context.Context, *PurgeUserEventsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PurgeUserEvents not implemented")
}
func (UnimplementedUserEventServiceServer) ImportUserEvents(context.Context, *ImportUserEventsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportUserEvents not implemented")
}

// UnsafeUserEventServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to UserEventServiceServer will
// result in compilation errors.
type UnsafeUserEventServiceServer interface {
	mustEmbedUnimplementedUserEventServiceServer()
}

func RegisterUserEventServiceServer(s grpc.ServiceRegistrar, srv UserEventServiceServer) {
	s.RegisterService(&UserEventService_ServiceDesc, srv)
}

func _UserEventService_WriteUserEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WriteUserEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserEventServiceServer).WriteUserEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserEventService_WriteUserEvent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserEventServiceServer).WriteUserEvent(ctx, req.(*WriteUserEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserEventService_CollectUserEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CollectUserEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserEventServiceServer).CollectUserEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserEventService_CollectUserEvent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserEventServiceServer).CollectUserEvent(ctx, req.(*CollectUserEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserEventService_ListUserEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUserEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserEventServiceServer).ListUserEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserEventService_ListUserEvents_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserEventServiceServer).ListUserEvents(ctx, req.(*ListUserEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserEventService_PurgeUserEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PurgeUserEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserEventServiceServer).PurgeUserEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserEventService_PurgeUserEvents_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserEventServiceServer).PurgeUserEvents(ctx, req.(*PurgeUserEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserEventService_ImportUserEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportUserEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserEventServiceServer).ImportUserEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserEventService_ImportUserEvents_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserEventServiceServer).ImportUserEvents(ctx, req.(*ImportUserEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// UserEventService_ServiceDesc is the grpc.ServiceDesc for UserEventService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var UserEventService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.recommendationengine.v1beta1.UserEventService",
	HandlerType: (*UserEventServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "WriteUserEvent",
			Handler:    _UserEventService_WriteUserEvent_Handler,
		},
		{
			MethodName: "CollectUserEvent",
			Handler:    _UserEventService_CollectUserEvent_Handler,
		},
		{
			MethodName: "ListUserEvents",
			Handler:    _UserEventService_ListUserEvents_Handler,
		},
		{
			MethodName: "PurgeUserEvents",
			Handler:    _UserEventService_PurgeUserEvents_Handler,
		},
		{
			MethodName: "ImportUserEvents",
			Handler:    _UserEventService_ImportUserEvents_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/recommendationengine/v1beta1/user_event_service.proto",
}
