// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package recommendationengine

import (
	"bytes"
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/http"
	"net/url"
	"time"

	recommendationenginepb "cloud.google.com/go/recommendationengine/apiv1beta1/recommendationenginepb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newPredictionApiKeyRegistryClientHook clientHook

// PredictionApiKeyRegistryCallOptions contains the retry settings for each method of PredictionApiKeyRegistryClient.
type PredictionApiKeyRegistryCallOptions struct {
	CreatePredictionApiKeyRegistration []gax.CallOption
	ListPredictionApiKeyRegistrations  []gax.CallOption
	DeletePredictionApiKeyRegistration []gax.CallOption
}

func defaultPredictionApiKeyRegistryGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("recommendationengine.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("recommendationengine.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("recommendationengine.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://recommendationengine.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultPredictionApiKeyRegistryCallOptions() *PredictionApiKeyRegistryCallOptions {
	return &PredictionApiKeyRegistryCallOptions{
		CreatePredictionApiKeyRegistration: []gax.CallOption{
			gax.WithTimeout(600000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.DeadlineExceeded,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListPredictionApiKeyRegistrations: []gax.CallOption{
			gax.WithTimeout(600000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.DeadlineExceeded,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeletePredictionApiKeyRegistration: []gax.CallOption{
			gax.WithTimeout(600000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.DeadlineExceeded,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
	}
}

func defaultPredictionApiKeyRegistryRESTCallOptions() *PredictionApiKeyRegistryCallOptions {
	return &PredictionApiKeyRegistryCallOptions{
		CreatePredictionApiKeyRegistration: []gax.CallOption{
			gax.WithTimeout(600000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable,
					http.StatusGatewayTimeout)
			}),
		},
		ListPredictionApiKeyRegistrations: []gax.CallOption{
			gax.WithTimeout(600000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable,
					http.StatusGatewayTimeout)
			}),
		},
		DeletePredictionApiKeyRegistration: []gax.CallOption{
			gax.WithTimeout(600000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable,
					http.StatusGatewayTimeout)
			}),
		},
	}
}

// internalPredictionApiKeyRegistryClient is an interface that defines the methods available from Recommendations AI.
type internalPredictionApiKeyRegistryClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	CreatePredictionApiKeyRegistration(context.Context, *recommendationenginepb.CreatePredictionApiKeyRegistrationRequest, ...gax.CallOption) (*recommendationenginepb.PredictionApiKeyRegistration, error)
	ListPredictionApiKeyRegistrations(context.Context, *recommendationenginepb.ListPredictionApiKeyRegistrationsRequest, ...gax.CallOption) *PredictionApiKeyRegistrationIterator
	DeletePredictionApiKeyRegistration(context.Context, *recommendationenginepb.DeletePredictionApiKeyRegistrationRequest, ...gax.CallOption) error
}

// PredictionApiKeyRegistryClient is a client for interacting with Recommendations AI.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Service for registering API keys for use with the predict method. If you
// use an API key to request predictions, you must first register the API key.
// Otherwise, your prediction request is rejected. If you use OAuth to
// authenticate your predict method call, you do not need to register an API
// key. You can register up to 20 API keys per project.
type PredictionApiKeyRegistryClient struct {
	// The internal transport-dependent client.
	internalClient internalPredictionApiKeyRegistryClient

	// The call options for this service.
	CallOptions *PredictionApiKeyRegistryCallOptions
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *PredictionApiKeyRegistryClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *PredictionApiKeyRegistryClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *PredictionApiKeyRegistryClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// CreatePredictionApiKeyRegistration register an API key for use with predict method.
func (c *PredictionApiKeyRegistryClient) CreatePredictionApiKeyRegistration(ctx context.Context, req *recommendationenginepb.CreatePredictionApiKeyRegistrationRequest, opts ...gax.CallOption) (*recommendationenginepb.PredictionApiKeyRegistration, error) {
	return c.internalClient.CreatePredictionApiKeyRegistration(ctx, req, opts...)
}

// ListPredictionApiKeyRegistrations list the registered apiKeys for use with predict method.
func (c *PredictionApiKeyRegistryClient) ListPredictionApiKeyRegistrations(ctx context.Context, req *recommendationenginepb.ListPredictionApiKeyRegistrationsRequest, opts ...gax.CallOption) *PredictionApiKeyRegistrationIterator {
	return c.internalClient.ListPredictionApiKeyRegistrations(ctx, req, opts...)
}

// DeletePredictionApiKeyRegistration unregister an apiKey from using for predict method.
func (c *PredictionApiKeyRegistryClient) DeletePredictionApiKeyRegistration(ctx context.Context, req *recommendationenginepb.DeletePredictionApiKeyRegistrationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeletePredictionApiKeyRegistration(ctx, req, opts...)
}

// predictionApiKeyRegistryGRPCClient is a client for interacting with Recommendations AI over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type predictionApiKeyRegistryGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing PredictionApiKeyRegistryClient
	CallOptions **PredictionApiKeyRegistryCallOptions

	// The gRPC API client.
	predictionApiKeyRegistryClient recommendationenginepb.PredictionApiKeyRegistryClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewPredictionApiKeyRegistryClient creates a new prediction api key registry client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Service for registering API keys for use with the predict method. If you
// use an API key to request predictions, you must first register the API key.
// Otherwise, your prediction request is rejected. If you use OAuth to
// authenticate your predict method call, you do not need to register an API
// key. You can register up to 20 API keys per project.
func NewPredictionApiKeyRegistryClient(ctx context.Context, opts ...option.ClientOption) (*PredictionApiKeyRegistryClient, error) {
	clientOpts := defaultPredictionApiKeyRegistryGRPCClientOptions()
	if newPredictionApiKeyRegistryClientHook != nil {
		hookOpts, err := newPredictionApiKeyRegistryClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := PredictionApiKeyRegistryClient{CallOptions: defaultPredictionApiKeyRegistryCallOptions()}

	c := &predictionApiKeyRegistryGRPCClient{
		connPool:                       connPool,
		predictionApiKeyRegistryClient: recommendationenginepb.NewPredictionApiKeyRegistryClient(connPool),
		CallOptions:                    &client.CallOptions,
		logger:                         internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *predictionApiKeyRegistryGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *predictionApiKeyRegistryGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version, "pb", protoVersion)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *predictionApiKeyRegistryGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type predictionApiKeyRegistryRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing PredictionApiKeyRegistryClient
	CallOptions **PredictionApiKeyRegistryCallOptions

	logger *slog.Logger
}

// NewPredictionApiKeyRegistryRESTClient creates a new prediction api key registry rest client.
//
// Service for registering API keys for use with the predict method. If you
// use an API key to request predictions, you must first register the API key.
// Otherwise, your prediction request is rejected. If you use OAuth to
// authenticate your predict method call, you do not need to register an API
// key. You can register up to 20 API keys per project.
func NewPredictionApiKeyRegistryRESTClient(ctx context.Context, opts ...option.ClientOption) (*PredictionApiKeyRegistryClient, error) {
	clientOpts := append(defaultPredictionApiKeyRegistryRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultPredictionApiKeyRegistryRESTCallOptions()
	c := &predictionApiKeyRegistryRESTClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
		logger:      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	return &PredictionApiKeyRegistryClient{internalClient: c, CallOptions: callOpts}, nil
}

func defaultPredictionApiKeyRegistryRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://recommendationengine.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://recommendationengine.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://recommendationengine.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://recommendationengine.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableNewAuthLibrary(),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *predictionApiKeyRegistryRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN", "pb", protoVersion)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *predictionApiKeyRegistryRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *predictionApiKeyRegistryRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *predictionApiKeyRegistryGRPCClient) CreatePredictionApiKeyRegistration(ctx context.Context, req *recommendationenginepb.CreatePredictionApiKeyRegistrationRequest, opts ...gax.CallOption) (*recommendationenginepb.PredictionApiKeyRegistration, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreatePredictionApiKeyRegistration[0:len((*c.CallOptions).CreatePredictionApiKeyRegistration):len((*c.CallOptions).CreatePredictionApiKeyRegistration)], opts...)
	var resp *recommendationenginepb.PredictionApiKeyRegistration
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.predictionApiKeyRegistryClient.CreatePredictionApiKeyRegistration, req, settings.GRPC, c.logger, "CreatePredictionApiKeyRegistration")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *predictionApiKeyRegistryGRPCClient) ListPredictionApiKeyRegistrations(ctx context.Context, req *recommendationenginepb.ListPredictionApiKeyRegistrationsRequest, opts ...gax.CallOption) *PredictionApiKeyRegistrationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListPredictionApiKeyRegistrations[0:len((*c.CallOptions).ListPredictionApiKeyRegistrations):len((*c.CallOptions).ListPredictionApiKeyRegistrations)], opts...)
	it := &PredictionApiKeyRegistrationIterator{}
	req = proto.Clone(req).(*recommendationenginepb.ListPredictionApiKeyRegistrationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*recommendationenginepb.PredictionApiKeyRegistration, string, error) {
		resp := &recommendationenginepb.ListPredictionApiKeyRegistrationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.predictionApiKeyRegistryClient.ListPredictionApiKeyRegistrations, req, settings.GRPC, c.logger, "ListPredictionApiKeyRegistrations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetPredictionApiKeyRegistrations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *predictionApiKeyRegistryGRPCClient) DeletePredictionApiKeyRegistration(ctx context.Context, req *recommendationenginepb.DeletePredictionApiKeyRegistrationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeletePredictionApiKeyRegistration[0:len((*c.CallOptions).DeletePredictionApiKeyRegistration):len((*c.CallOptions).DeletePredictionApiKeyRegistration)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.predictionApiKeyRegistryClient.DeletePredictionApiKeyRegistration, req, settings.GRPC, c.logger, "DeletePredictionApiKeyRegistration")
		return err
	}, opts...)
	return err
}

// CreatePredictionApiKeyRegistration register an API key for use with predict method.
func (c *predictionApiKeyRegistryRESTClient) CreatePredictionApiKeyRegistration(ctx context.Context, req *recommendationenginepb.CreatePredictionApiKeyRegistrationRequest, opts ...gax.CallOption) (*recommendationenginepb.PredictionApiKeyRegistration, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta1/%v/predictionApiKeyRegistrations", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreatePredictionApiKeyRegistration[0:len((*c.CallOptions).CreatePredictionApiKeyRegistration):len((*c.CallOptions).CreatePredictionApiKeyRegistration)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &recommendationenginepb.PredictionApiKeyRegistration{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreatePredictionApiKeyRegistration")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListPredictionApiKeyRegistrations list the registered apiKeys for use with predict method.
func (c *predictionApiKeyRegistryRESTClient) ListPredictionApiKeyRegistrations(ctx context.Context, req *recommendationenginepb.ListPredictionApiKeyRegistrationsRequest, opts ...gax.CallOption) *PredictionApiKeyRegistrationIterator {
	it := &PredictionApiKeyRegistrationIterator{}
	req = proto.Clone(req).(*recommendationenginepb.ListPredictionApiKeyRegistrationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*recommendationenginepb.PredictionApiKeyRegistration, string, error) {
		resp := &recommendationenginepb.ListPredictionApiKeyRegistrationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1beta1/%v/predictionApiKeyRegistrations", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListPredictionApiKeyRegistrations")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetPredictionApiKeyRegistrations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// DeletePredictionApiKeyRegistration unregister an apiKey from using for predict method.
func (c *predictionApiKeyRegistryRESTClient) DeletePredictionApiKeyRegistration(ctx context.Context, req *recommendationenginepb.DeletePredictionApiKeyRegistrationRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeletePredictionApiKeyRegistration")
		return err
	}, opts...)
}
