// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/orchestration/airflow/service/v1/image_versions.proto

package servicepb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ImageVersions_ListImageVersions_FullMethodName = "/google.cloud.orchestration.airflow.service.v1.ImageVersions/ListImageVersions"
)

// ImageVersionsClient is the client API for ImageVersions service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ImageVersionsClient interface {
	// List ImageVersions for provided location.
	ListImageVersions(ctx context.Context, in *ListImageVersionsRequest, opts ...grpc.CallOption) (*ListImageVersionsResponse, error)
}

type imageVersionsClient struct {
	cc grpc.ClientConnInterface
}

func NewImageVersionsClient(cc grpc.ClientConnInterface) ImageVersionsClient {
	return &imageVersionsClient{cc}
}

func (c *imageVersionsClient) ListImageVersions(ctx context.Context, in *ListImageVersionsRequest, opts ...grpc.CallOption) (*ListImageVersionsResponse, error) {
	out := new(ListImageVersionsResponse)
	err := c.cc.Invoke(ctx, ImageVersions_ListImageVersions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ImageVersionsServer is the server API for ImageVersions service.
// All implementations should embed UnimplementedImageVersionsServer
// for forward compatibility
type ImageVersionsServer interface {
	// List ImageVersions for provided location.
	ListImageVersions(context.Context, *ListImageVersionsRequest) (*ListImageVersionsResponse, error)
}

// UnimplementedImageVersionsServer should be embedded to have forward compatible implementations.
type UnimplementedImageVersionsServer struct {
}

func (UnimplementedImageVersionsServer) ListImageVersions(context.Context, *ListImageVersionsRequest) (*ListImageVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListImageVersions not implemented")
}

// UnsafeImageVersionsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ImageVersionsServer will
// result in compilation errors.
type UnsafeImageVersionsServer interface {
	mustEmbedUnimplementedImageVersionsServer()
}

func RegisterImageVersionsServer(s grpc.ServiceRegistrar, srv ImageVersionsServer) {
	s.RegisterService(&ImageVersions_ServiceDesc, srv)
}

func _ImageVersions_ListImageVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListImageVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageVersionsServer).ListImageVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ImageVersions_ListImageVersions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageVersionsServer).ListImageVersions(ctx, req.(*ListImageVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ImageVersions_ServiceDesc is the grpc.ServiceDesc for ImageVersions service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ImageVersions_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.orchestration.airflow.service.v1.ImageVersions",
	HandlerType: (*ImageVersionsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListImageVersions",
			Handler:    _ImageVersions_ListImageVersions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/orchestration/airflow/service/v1/image_versions.proto",
}
