// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/notebooks/v1/runtime.proto

package notebookspb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The definition of the states of this runtime.
type Runtime_State int32

const (
	// State is not specified.
	Runtime_STATE_UNSPECIFIED Runtime_State = 0
	// The compute layer is starting the runtime. It is not ready for use.
	Runtime_STARTING Runtime_State = 1
	// The compute layer is installing required frameworks and registering the
	// runtime with notebook proxy. It cannot be used.
	Runtime_PROVISIONING Runtime_State = 2
	// The runtime is currently running. It is ready for use.
	Runtime_ACTIVE Runtime_State = 3
	// The control logic is stopping the runtime. It cannot be used.
	Runtime_STOPPING Runtime_State = 4
	// The runtime is stopped. It cannot be used.
	Runtime_STOPPED Runtime_State = 5
	// The runtime is being deleted. It cannot be used.
	Runtime_DELETING Runtime_State = 6
	// The runtime is upgrading. It cannot be used.
	Runtime_UPGRADING Runtime_State = 7
	// The runtime is being created and set up. It is not ready for use.
	Runtime_INITIALIZING Runtime_State = 8
)

// Enum value maps for Runtime_State.
var (
	Runtime_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "STARTING",
		2: "PROVISIONING",
		3: "ACTIVE",
		4: "STOPPING",
		5: "STOPPED",
		6: "DELETING",
		7: "UPGRADING",
		8: "INITIALIZING",
	}
	Runtime_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"STARTING":          1,
		"PROVISIONING":      2,
		"ACTIVE":            3,
		"STOPPING":          4,
		"STOPPED":           5,
		"DELETING":          6,
		"UPGRADING":         7,
		"INITIALIZING":      8,
	}
)

func (x Runtime_State) Enum() *Runtime_State {
	p := new(Runtime_State)
	*p = x
	return p
}

func (x Runtime_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Runtime_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_notebooks_v1_runtime_proto_enumTypes[0].Descriptor()
}

func (Runtime_State) Type() protoreflect.EnumType {
	return &file_google_cloud_notebooks_v1_runtime_proto_enumTypes[0]
}

func (x Runtime_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Runtime_State.Descriptor instead.
func (Runtime_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_runtime_proto_rawDescGZIP(), []int{0, 0}
}

// The runtime substate.
type Runtime_HealthState int32

const (
	// The runtime substate is unknown.
	Runtime_HEALTH_STATE_UNSPECIFIED Runtime_HealthState = 0
	// The runtime is known to be in an healthy state
	// (for example, critical daemons are running)
	// Applies to ACTIVE state.
	Runtime_HEALTHY Runtime_HealthState = 1
	// The runtime is known to be in an unhealthy state
	// (for example, critical daemons are not running)
	// Applies to ACTIVE state.
	Runtime_UNHEALTHY Runtime_HealthState = 2
	// The runtime has not installed health monitoring agent.
	// Applies to ACTIVE state.
	Runtime_AGENT_NOT_INSTALLED Runtime_HealthState = 3
	// The runtime health monitoring agent is not running.
	// Applies to ACTIVE state.
	Runtime_AGENT_NOT_RUNNING Runtime_HealthState = 4
)

// Enum value maps for Runtime_HealthState.
var (
	Runtime_HealthState_name = map[int32]string{
		0: "HEALTH_STATE_UNSPECIFIED",
		1: "HEALTHY",
		2: "UNHEALTHY",
		3: "AGENT_NOT_INSTALLED",
		4: "AGENT_NOT_RUNNING",
	}
	Runtime_HealthState_value = map[string]int32{
		"HEALTH_STATE_UNSPECIFIED": 0,
		"HEALTHY":                  1,
		"UNHEALTHY":                2,
		"AGENT_NOT_INSTALLED":      3,
		"AGENT_NOT_RUNNING":        4,
	}
)

func (x Runtime_HealthState) Enum() *Runtime_HealthState {
	p := new(Runtime_HealthState)
	*p = x
	return p
}

func (x Runtime_HealthState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Runtime_HealthState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_notebooks_v1_runtime_proto_enumTypes[1].Descriptor()
}

func (Runtime_HealthState) Type() protoreflect.EnumType {
	return &file_google_cloud_notebooks_v1_runtime_proto_enumTypes[1]
}

func (x Runtime_HealthState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Runtime_HealthState.Descriptor instead.
func (Runtime_HealthState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_runtime_proto_rawDescGZIP(), []int{0, 1}
}

// Type of this accelerator.
type RuntimeAcceleratorConfig_AcceleratorType int32

const (
	// Accelerator type is not specified.
	RuntimeAcceleratorConfig_ACCELERATOR_TYPE_UNSPECIFIED RuntimeAcceleratorConfig_AcceleratorType = 0
	// Accelerator type is Nvidia Tesla K80.
	//
	// Deprecated: Marked as deprecated in google/cloud/notebooks/v1/runtime.proto.
	RuntimeAcceleratorConfig_NVIDIA_TESLA_K80 RuntimeAcceleratorConfig_AcceleratorType = 1
	// Accelerator type is Nvidia Tesla P100.
	RuntimeAcceleratorConfig_NVIDIA_TESLA_P100 RuntimeAcceleratorConfig_AcceleratorType = 2
	// Accelerator type is Nvidia Tesla V100.
	RuntimeAcceleratorConfig_NVIDIA_TESLA_V100 RuntimeAcceleratorConfig_AcceleratorType = 3
	// Accelerator type is Nvidia Tesla P4.
	RuntimeAcceleratorConfig_NVIDIA_TESLA_P4 RuntimeAcceleratorConfig_AcceleratorType = 4
	// Accelerator type is Nvidia Tesla T4.
	RuntimeAcceleratorConfig_NVIDIA_TESLA_T4 RuntimeAcceleratorConfig_AcceleratorType = 5
	// Accelerator type is Nvidia Tesla A100.
	RuntimeAcceleratorConfig_NVIDIA_TESLA_A100 RuntimeAcceleratorConfig_AcceleratorType = 6
	// (Coming soon) Accelerator type is TPU V2.
	RuntimeAcceleratorConfig_TPU_V2 RuntimeAcceleratorConfig_AcceleratorType = 7
	// (Coming soon) Accelerator type is TPU V3.
	RuntimeAcceleratorConfig_TPU_V3 RuntimeAcceleratorConfig_AcceleratorType = 8
	// Accelerator type is NVIDIA Tesla T4 Virtual Workstations.
	RuntimeAcceleratorConfig_NVIDIA_TESLA_T4_VWS RuntimeAcceleratorConfig_AcceleratorType = 9
	// Accelerator type is NVIDIA Tesla P100 Virtual Workstations.
	RuntimeAcceleratorConfig_NVIDIA_TESLA_P100_VWS RuntimeAcceleratorConfig_AcceleratorType = 10
	// Accelerator type is NVIDIA Tesla P4 Virtual Workstations.
	RuntimeAcceleratorConfig_NVIDIA_TESLA_P4_VWS RuntimeAcceleratorConfig_AcceleratorType = 11
)

// Enum value maps for RuntimeAcceleratorConfig_AcceleratorType.
var (
	RuntimeAcceleratorConfig_AcceleratorType_name = map[int32]string{
		0:  "ACCELERATOR_TYPE_UNSPECIFIED",
		1:  "NVIDIA_TESLA_K80",
		2:  "NVIDIA_TESLA_P100",
		3:  "NVIDIA_TESLA_V100",
		4:  "NVIDIA_TESLA_P4",
		5:  "NVIDIA_TESLA_T4",
		6:  "NVIDIA_TESLA_A100",
		7:  "TPU_V2",
		8:  "TPU_V3",
		9:  "NVIDIA_TESLA_T4_VWS",
		10: "NVIDIA_TESLA_P100_VWS",
		11: "NVIDIA_TESLA_P4_VWS",
	}
	RuntimeAcceleratorConfig_AcceleratorType_value = map[string]int32{
		"ACCELERATOR_TYPE_UNSPECIFIED": 0,
		"NVIDIA_TESLA_K80":             1,
		"NVIDIA_TESLA_P100":            2,
		"NVIDIA_TESLA_V100":            3,
		"NVIDIA_TESLA_P4":              4,
		"NVIDIA_TESLA_T4":              5,
		"NVIDIA_TESLA_A100":            6,
		"TPU_V2":                       7,
		"TPU_V3":                       8,
		"NVIDIA_TESLA_T4_VWS":          9,
		"NVIDIA_TESLA_P100_VWS":        10,
		"NVIDIA_TESLA_P4_VWS":          11,
	}
)

func (x RuntimeAcceleratorConfig_AcceleratorType) Enum() *RuntimeAcceleratorConfig_AcceleratorType {
	p := new(RuntimeAcceleratorConfig_AcceleratorType)
	*p = x
	return p
}

func (x RuntimeAcceleratorConfig_AcceleratorType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RuntimeAcceleratorConfig_AcceleratorType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_notebooks_v1_runtime_proto_enumTypes[2].Descriptor()
}

func (RuntimeAcceleratorConfig_AcceleratorType) Type() protoreflect.EnumType {
	return &file_google_cloud_notebooks_v1_runtime_proto_enumTypes[2]
}

func (x RuntimeAcceleratorConfig_AcceleratorType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RuntimeAcceleratorConfig_AcceleratorType.Descriptor instead.
func (RuntimeAcceleratorConfig_AcceleratorType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_runtime_proto_rawDescGZIP(), []int{1, 0}
}

// Possible disk types.
type LocalDiskInitializeParams_DiskType int32

const (
	// Disk type not set.
	LocalDiskInitializeParams_DISK_TYPE_UNSPECIFIED LocalDiskInitializeParams_DiskType = 0
	// Standard persistent disk type.
	LocalDiskInitializeParams_PD_STANDARD LocalDiskInitializeParams_DiskType = 1
	// SSD persistent disk type.
	LocalDiskInitializeParams_PD_SSD LocalDiskInitializeParams_DiskType = 2
	// Balanced persistent disk type.
	LocalDiskInitializeParams_PD_BALANCED LocalDiskInitializeParams_DiskType = 3
	// Extreme persistent disk type.
	LocalDiskInitializeParams_PD_EXTREME LocalDiskInitializeParams_DiskType = 4
)

// Enum value maps for LocalDiskInitializeParams_DiskType.
var (
	LocalDiskInitializeParams_DiskType_name = map[int32]string{
		0: "DISK_TYPE_UNSPECIFIED",
		1: "PD_STANDARD",
		2: "PD_SSD",
		3: "PD_BALANCED",
		4: "PD_EXTREME",
	}
	LocalDiskInitializeParams_DiskType_value = map[string]int32{
		"DISK_TYPE_UNSPECIFIED": 0,
		"PD_STANDARD":           1,
		"PD_SSD":                2,
		"PD_BALANCED":           3,
		"PD_EXTREME":            4,
	}
)

func (x LocalDiskInitializeParams_DiskType) Enum() *LocalDiskInitializeParams_DiskType {
	p := new(LocalDiskInitializeParams_DiskType)
	*p = x
	return p
}

func (x LocalDiskInitializeParams_DiskType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LocalDiskInitializeParams_DiskType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_notebooks_v1_runtime_proto_enumTypes[3].Descriptor()
}

func (LocalDiskInitializeParams_DiskType) Type() protoreflect.EnumType {
	return &file_google_cloud_notebooks_v1_runtime_proto_enumTypes[3]
}

func (x LocalDiskInitializeParams_DiskType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LocalDiskInitializeParams_DiskType.Descriptor instead.
func (LocalDiskInitializeParams_DiskType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_runtime_proto_rawDescGZIP(), []int{4, 0}
}

// Possible ways to access runtime. Authentication mode.
// Currently supports: Single User only.
type RuntimeAccessConfig_RuntimeAccessType int32

const (
	// Unspecified access.
	RuntimeAccessConfig_RUNTIME_ACCESS_TYPE_UNSPECIFIED RuntimeAccessConfig_RuntimeAccessType = 0
	// Single user login.
	RuntimeAccessConfig_SINGLE_USER RuntimeAccessConfig_RuntimeAccessType = 1
	// Service Account mode.
	// In Service Account mode, Runtime creator will specify a SA that exists
	// in the consumer project. Using Runtime Service Account field.
	// Users accessing the Runtime need ActAs (Service Account User) permission.
	RuntimeAccessConfig_SERVICE_ACCOUNT RuntimeAccessConfig_RuntimeAccessType = 2
)

// Enum value maps for RuntimeAccessConfig_RuntimeAccessType.
var (
	RuntimeAccessConfig_RuntimeAccessType_name = map[int32]string{
		0: "RUNTIME_ACCESS_TYPE_UNSPECIFIED",
		1: "SINGLE_USER",
		2: "SERVICE_ACCOUNT",
	}
	RuntimeAccessConfig_RuntimeAccessType_value = map[string]int32{
		"RUNTIME_ACCESS_TYPE_UNSPECIFIED": 0,
		"SINGLE_USER":                     1,
		"SERVICE_ACCOUNT":                 2,
	}
)

func (x RuntimeAccessConfig_RuntimeAccessType) Enum() *RuntimeAccessConfig_RuntimeAccessType {
	p := new(RuntimeAccessConfig_RuntimeAccessType)
	*p = x
	return p
}

func (x RuntimeAccessConfig_RuntimeAccessType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RuntimeAccessConfig_RuntimeAccessType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_notebooks_v1_runtime_proto_enumTypes[4].Descriptor()
}

func (RuntimeAccessConfig_RuntimeAccessType) Type() protoreflect.EnumType {
	return &file_google_cloud_notebooks_v1_runtime_proto_enumTypes[4]
}

func (x RuntimeAccessConfig_RuntimeAccessType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RuntimeAccessConfig_RuntimeAccessType.Descriptor instead.
func (RuntimeAccessConfig_RuntimeAccessType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_runtime_proto_rawDescGZIP(), []int{5, 0}
}

// Behavior for the post startup script.
type RuntimeSoftwareConfig_PostStartupScriptBehavior int32

const (
	// Unspecified post startup script behavior. Will run only once at creation.
	RuntimeSoftwareConfig_POST_STARTUP_SCRIPT_BEHAVIOR_UNSPECIFIED RuntimeSoftwareConfig_PostStartupScriptBehavior = 0
	// Runs the post startup script provided during creation at every start.
	RuntimeSoftwareConfig_RUN_EVERY_START RuntimeSoftwareConfig_PostStartupScriptBehavior = 1
	// Downloads and runs the provided post startup script at every start.
	RuntimeSoftwareConfig_DOWNLOAD_AND_RUN_EVERY_START RuntimeSoftwareConfig_PostStartupScriptBehavior = 2
)

// Enum value maps for RuntimeSoftwareConfig_PostStartupScriptBehavior.
var (
	RuntimeSoftwareConfig_PostStartupScriptBehavior_name = map[int32]string{
		0: "POST_STARTUP_SCRIPT_BEHAVIOR_UNSPECIFIED",
		1: "RUN_EVERY_START",
		2: "DOWNLOAD_AND_RUN_EVERY_START",
	}
	RuntimeSoftwareConfig_PostStartupScriptBehavior_value = map[string]int32{
		"POST_STARTUP_SCRIPT_BEHAVIOR_UNSPECIFIED": 0,
		"RUN_EVERY_START":                          1,
		"DOWNLOAD_AND_RUN_EVERY_START":             2,
	}
)

func (x RuntimeSoftwareConfig_PostStartupScriptBehavior) Enum() *RuntimeSoftwareConfig_PostStartupScriptBehavior {
	p := new(RuntimeSoftwareConfig_PostStartupScriptBehavior)
	*p = x
	return p
}

func (x RuntimeSoftwareConfig_PostStartupScriptBehavior) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RuntimeSoftwareConfig_PostStartupScriptBehavior) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_notebooks_v1_runtime_proto_enumTypes[5].Descriptor()
}

func (RuntimeSoftwareConfig_PostStartupScriptBehavior) Type() protoreflect.EnumType {
	return &file_google_cloud_notebooks_v1_runtime_proto_enumTypes[5]
}

func (x RuntimeSoftwareConfig_PostStartupScriptBehavior) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RuntimeSoftwareConfig_PostStartupScriptBehavior.Descriptor instead.
func (RuntimeSoftwareConfig_PostStartupScriptBehavior) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_runtime_proto_rawDescGZIP(), []int{6, 0}
}

// The type of vNIC driver.
// Default should be UNSPECIFIED_NIC_TYPE.
type VirtualMachineConfig_NicType int32

const (
	// No type specified.
	VirtualMachineConfig_UNSPECIFIED_NIC_TYPE VirtualMachineConfig_NicType = 0
	// VIRTIO
	VirtualMachineConfig_VIRTIO_NET VirtualMachineConfig_NicType = 1
	// GVNIC
	VirtualMachineConfig_GVNIC VirtualMachineConfig_NicType = 2
)

// Enum value maps for VirtualMachineConfig_NicType.
var (
	VirtualMachineConfig_NicType_name = map[int32]string{
		0: "UNSPECIFIED_NIC_TYPE",
		1: "VIRTIO_NET",
		2: "GVNIC",
	}
	VirtualMachineConfig_NicType_value = map[string]int32{
		"UNSPECIFIED_NIC_TYPE": 0,
		"VIRTIO_NET":           1,
		"GVNIC":                2,
	}
)

func (x VirtualMachineConfig_NicType) Enum() *VirtualMachineConfig_NicType {
	p := new(VirtualMachineConfig_NicType)
	*p = x
	return p
}

func (x VirtualMachineConfig_NicType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VirtualMachineConfig_NicType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_notebooks_v1_runtime_proto_enumTypes[6].Descriptor()
}

func (VirtualMachineConfig_NicType) Type() protoreflect.EnumType {
	return &file_google_cloud_notebooks_v1_runtime_proto_enumTypes[6]
}

func (x VirtualMachineConfig_NicType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VirtualMachineConfig_NicType.Descriptor instead.
func (VirtualMachineConfig_NicType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_runtime_proto_rawDescGZIP(), []int{10, 0}
}

// The definition of a Runtime for a managed notebook instance.
type Runtime struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the runtime.
	// Format:
	// `projects/{project}/locations/{location}/runtimes/{runtimeId}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Type of the runtime; currently only supports Compute Engine VM.
	//
	// Types that are assignable to RuntimeType:
	//
	//	*Runtime_VirtualMachine
	RuntimeType isRuntime_RuntimeType `protobuf_oneof:"runtime_type"`
	// Output only. Runtime state.
	State Runtime_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.notebooks.v1.Runtime_State" json:"state,omitempty"`
	// Output only. Runtime health_state.
	HealthState Runtime_HealthState `protobuf:"varint,4,opt,name=health_state,json=healthState,proto3,enum=google.cloud.notebooks.v1.Runtime_HealthState" json:"health_state,omitempty"`
	// The config settings for accessing runtime.
	AccessConfig *RuntimeAccessConfig `protobuf:"bytes,5,opt,name=access_config,json=accessConfig,proto3" json:"access_config,omitempty"`
	// The config settings for software inside the runtime.
	SoftwareConfig *RuntimeSoftwareConfig `protobuf:"bytes,6,opt,name=software_config,json=softwareConfig,proto3" json:"software_config,omitempty"`
	// Output only. Contains Runtime daemon metrics such as Service status and JupyterLab
	// stats.
	Metrics *RuntimeMetrics `protobuf:"bytes,7,opt,name=metrics,proto3" json:"metrics,omitempty"`
	// Output only. Runtime creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,20,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Runtime update time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,21,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *Runtime) Reset() {
	*x = Runtime{}
	mi := &file_google_cloud_notebooks_v1_runtime_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Runtime) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Runtime) ProtoMessage() {}

func (x *Runtime) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_runtime_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Runtime.ProtoReflect.Descriptor instead.
func (*Runtime) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_runtime_proto_rawDescGZIP(), []int{0}
}

func (x *Runtime) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *Runtime) GetRuntimeType() isRuntime_RuntimeType {
	if m != nil {
		return m.RuntimeType
	}
	return nil
}

func (x *Runtime) GetVirtualMachine() *VirtualMachine {
	if x, ok := x.GetRuntimeType().(*Runtime_VirtualMachine); ok {
		return x.VirtualMachine
	}
	return nil
}

func (x *Runtime) GetState() Runtime_State {
	if x != nil {
		return x.State
	}
	return Runtime_STATE_UNSPECIFIED
}

func (x *Runtime) GetHealthState() Runtime_HealthState {
	if x != nil {
		return x.HealthState
	}
	return Runtime_HEALTH_STATE_UNSPECIFIED
}

func (x *Runtime) GetAccessConfig() *RuntimeAccessConfig {
	if x != nil {
		return x.AccessConfig
	}
	return nil
}

func (x *Runtime) GetSoftwareConfig() *RuntimeSoftwareConfig {
	if x != nil {
		return x.SoftwareConfig
	}
	return nil
}

func (x *Runtime) GetMetrics() *RuntimeMetrics {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *Runtime) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Runtime) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

type isRuntime_RuntimeType interface {
	isRuntime_RuntimeType()
}

type Runtime_VirtualMachine struct {
	// Use a Compute Engine VM image to start the managed notebook instance.
	VirtualMachine *VirtualMachine `protobuf:"bytes,2,opt,name=virtual_machine,json=virtualMachine,proto3,oneof"`
}

func (*Runtime_VirtualMachine) isRuntime_RuntimeType() {}

// Definition of the types of hardware accelerators that can be used.
// Definition of the types of hardware accelerators that can be used.
// See [Compute Engine
// AcceleratorTypes](https://cloud.google.com/compute/docs/reference/beta/acceleratorTypes).
// Examples:
//
// * `nvidia-tesla-k80`
// * `nvidia-tesla-p100`
// * `nvidia-tesla-v100`
// * `nvidia-tesla-p4`
// * `nvidia-tesla-t4`
// * `nvidia-tesla-a100`
type RuntimeAcceleratorConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Accelerator model.
	Type RuntimeAcceleratorConfig_AcceleratorType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.notebooks.v1.RuntimeAcceleratorConfig_AcceleratorType" json:"type,omitempty"`
	// Count of cores of this accelerator.
	CoreCount int64 `protobuf:"varint,2,opt,name=core_count,json=coreCount,proto3" json:"core_count,omitempty"`
}

func (x *RuntimeAcceleratorConfig) Reset() {
	*x = RuntimeAcceleratorConfig{}
	mi := &file_google_cloud_notebooks_v1_runtime_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RuntimeAcceleratorConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeAcceleratorConfig) ProtoMessage() {}

func (x *RuntimeAcceleratorConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_runtime_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeAcceleratorConfig.ProtoReflect.Descriptor instead.
func (*RuntimeAcceleratorConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_runtime_proto_rawDescGZIP(), []int{1}
}

func (x *RuntimeAcceleratorConfig) GetType() RuntimeAcceleratorConfig_AcceleratorType {
	if x != nil {
		return x.Type
	}
	return RuntimeAcceleratorConfig_ACCELERATOR_TYPE_UNSPECIFIED
}

func (x *RuntimeAcceleratorConfig) GetCoreCount() int64 {
	if x != nil {
		return x.CoreCount
	}
	return 0
}

// Represents a custom encryption key configuration that can be applied to
// a resource. This will encrypt all disks in Virtual Machine.
type EncryptionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Cloud KMS resource identifier of the customer-managed encryption key
	// used to protect a resource, such as a disks. It has the following
	// format:
	// `projects/{PROJECT_ID}/locations/{REGION}/keyRings/{KEY_RING_NAME}/cryptoKeys/{KEY_NAME}`
	KmsKey string `protobuf:"bytes,1,opt,name=kms_key,json=kmsKey,proto3" json:"kms_key,omitempty"`
}

func (x *EncryptionConfig) Reset() {
	*x = EncryptionConfig{}
	mi := &file_google_cloud_notebooks_v1_runtime_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EncryptionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EncryptionConfig) ProtoMessage() {}

func (x *EncryptionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_runtime_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EncryptionConfig.ProtoReflect.Descriptor instead.
func (*EncryptionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_runtime_proto_rawDescGZIP(), []int{2}
}

func (x *EncryptionConfig) GetKmsKey() string {
	if x != nil {
		return x.KmsKey
	}
	return ""
}

// A Local attached disk resource.
type LocalDisk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Output only. Specifies whether the disk will be auto-deleted when the
	// instance is deleted (but not when the disk is detached from the instance).
	AutoDelete bool `protobuf:"varint,1,opt,name=auto_delete,json=autoDelete,proto3" json:"auto_delete,omitempty"`
	// Optional. Output only. Indicates that this is a boot disk. The virtual machine
	// will use the first partition of the disk for its root filesystem.
	Boot bool `protobuf:"varint,2,opt,name=boot,proto3" json:"boot,omitempty"`
	// Optional. Output only. Specifies a unique device name
	// of your choice that is reflected into the
	// `/dev/disk/by-id/google-*` tree of a Linux operating system running within
	// the instance. This name can be used to reference the device for mounting,
	// resizing, and so on, from within the instance.
	//
	// If not specified, the server chooses a default device name to apply to this
	// disk, in the form persistent-disk-x, where x is a number assigned by Google
	// Compute Engine. This field is only applicable for persistent disks.
	DeviceName string `protobuf:"bytes,3,opt,name=device_name,json=deviceName,proto3" json:"device_name,omitempty"`
	// Output only. Indicates a list of features to enable on the guest operating system.
	// Applicable only for bootable images. Read  Enabling guest operating
	// system features to see a list of available options.
	GuestOsFeatures []*LocalDisk_RuntimeGuestOsFeature `protobuf:"bytes,4,rep,name=guest_os_features,json=guestOsFeatures,proto3" json:"guest_os_features,omitempty"`
	// Output only. A zero-based index to this disk, where 0 is reserved for the
	// boot disk. If you have many disks attached to an instance, each disk would
	// have a unique index number.
	Index int32 `protobuf:"varint,5,opt,name=index,proto3" json:"index,omitempty"`
	// Input only. Specifies the parameters for a new disk that will be created
	// alongside the new instance. Use initialization parameters to create boot
	// disks or local SSDs attached to the new instance.
	//
	// This property is mutually exclusive with the source property; you can only
	// define one or the other, but not both.
	InitializeParams *LocalDiskInitializeParams `protobuf:"bytes,6,opt,name=initialize_params,json=initializeParams,proto3" json:"initialize_params,omitempty"`
	// Specifies the disk interface to use for attaching this disk, which is
	// either SCSI or NVME. The default is SCSI. Persistent disks must always use
	// SCSI and the request will fail if you attempt to attach a persistent disk
	// in any other format than SCSI. Local SSDs can use either NVME or SCSI. For
	// performance characteristics of SCSI over NVMe, see Local SSD performance.
	// Valid values:
	//
	// * `NVME`
	// * `SCSI`
	Interface string `protobuf:"bytes,7,opt,name=interface,proto3" json:"interface,omitempty"`
	// Output only. Type of the resource. Always compute#attachedDisk for attached disks.
	Kind string `protobuf:"bytes,8,opt,name=kind,proto3" json:"kind,omitempty"`
	// Output only. Any valid publicly visible licenses.
	Licenses []string `protobuf:"bytes,9,rep,name=licenses,proto3" json:"licenses,omitempty"`
	// The mode in which to attach this disk, either `READ_WRITE` or `READ_ONLY`.
	// If not specified, the default is to attach the disk in `READ_WRITE` mode.
	// Valid values:
	//
	// * `READ_ONLY`
	// * `READ_WRITE`
	Mode string `protobuf:"bytes,10,opt,name=mode,proto3" json:"mode,omitempty"`
	// Specifies a valid partial or full URL to an existing Persistent Disk
	// resource.
	Source string `protobuf:"bytes,11,opt,name=source,proto3" json:"source,omitempty"`
	// Specifies the type of the disk, either `SCRATCH` or `PERSISTENT`. If not
	// specified, the default is `PERSISTENT`.
	// Valid values:
	//
	// * `PERSISTENT`
	// * `SCRATCH`
	Type string `protobuf:"bytes,12,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *LocalDisk) Reset() {
	*x = LocalDisk{}
	mi := &file_google_cloud_notebooks_v1_runtime_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LocalDisk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocalDisk) ProtoMessage() {}

func (x *LocalDisk) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_runtime_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocalDisk.ProtoReflect.Descriptor instead.
func (*LocalDisk) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_runtime_proto_rawDescGZIP(), []int{3}
}

func (x *LocalDisk) GetAutoDelete() bool {
	if x != nil {
		return x.AutoDelete
	}
	return false
}

func (x *LocalDisk) GetBoot() bool {
	if x != nil {
		return x.Boot
	}
	return false
}

func (x *LocalDisk) GetDeviceName() string {
	if x != nil {
		return x.DeviceName
	}
	return ""
}

func (x *LocalDisk) GetGuestOsFeatures() []*LocalDisk_RuntimeGuestOsFeature {
	if x != nil {
		return x.GuestOsFeatures
	}
	return nil
}

func (x *LocalDisk) GetIndex() int32 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *LocalDisk) GetInitializeParams() *LocalDiskInitializeParams {
	if x != nil {
		return x.InitializeParams
	}
	return nil
}

func (x *LocalDisk) GetInterface() string {
	if x != nil {
		return x.Interface
	}
	return ""
}

func (x *LocalDisk) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *LocalDisk) GetLicenses() []string {
	if x != nil {
		return x.Licenses
	}
	return nil
}

func (x *LocalDisk) GetMode() string {
	if x != nil {
		return x.Mode
	}
	return ""
}

func (x *LocalDisk) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *LocalDisk) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

// Input only. Specifies the parameters for a new disk that will be created
// alongside the new instance. Use initialization parameters to create boot
// disks or local SSDs attached to the new runtime.
// This property is mutually exclusive with the source property; you can only
// define one or the other, but not both.
type LocalDiskInitializeParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Provide this property when creating the disk.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Specifies the disk name. If not specified, the default is to use the name
	// of the instance. If the disk with the instance name exists already in the
	// given zone/region, a new name will be automatically generated.
	DiskName string `protobuf:"bytes,2,opt,name=disk_name,json=diskName,proto3" json:"disk_name,omitempty"`
	// Optional. Specifies the size of the disk in base-2 GB. If not specified, the disk
	// will be the same size as the image (usually 10GB). If specified, the size
	// must be equal to or larger than 10GB. Default 100 GB.
	DiskSizeGb int64 `protobuf:"varint,3,opt,name=disk_size_gb,json=diskSizeGb,proto3" json:"disk_size_gb,omitempty"`
	// Input only. The type of the boot disk attached to this instance, defaults to
	// standard persistent disk (`PD_STANDARD`).
	DiskType LocalDiskInitializeParams_DiskType `protobuf:"varint,4,opt,name=disk_type,json=diskType,proto3,enum=google.cloud.notebooks.v1.LocalDiskInitializeParams_DiskType" json:"disk_type,omitempty"`
	// Optional. Labels to apply to this disk. These can be later modified by the
	// disks.setLabels method. This field is only applicable for persistent disks.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *LocalDiskInitializeParams) Reset() {
	*x = LocalDiskInitializeParams{}
	mi := &file_google_cloud_notebooks_v1_runtime_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LocalDiskInitializeParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocalDiskInitializeParams) ProtoMessage() {}

func (x *LocalDiskInitializeParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_runtime_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocalDiskInitializeParams.ProtoReflect.Descriptor instead.
func (*LocalDiskInitializeParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_runtime_proto_rawDescGZIP(), []int{4}
}

func (x *LocalDiskInitializeParams) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *LocalDiskInitializeParams) GetDiskName() string {
	if x != nil {
		return x.DiskName
	}
	return ""
}

func (x *LocalDiskInitializeParams) GetDiskSizeGb() int64 {
	if x != nil {
		return x.DiskSizeGb
	}
	return 0
}

func (x *LocalDiskInitializeParams) GetDiskType() LocalDiskInitializeParams_DiskType {
	if x != nil {
		return x.DiskType
	}
	return LocalDiskInitializeParams_DISK_TYPE_UNSPECIFIED
}

func (x *LocalDiskInitializeParams) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Specifies the login configuration for Runtime
type RuntimeAccessConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of access mode this instance.
	AccessType RuntimeAccessConfig_RuntimeAccessType `protobuf:"varint,1,opt,name=access_type,json=accessType,proto3,enum=google.cloud.notebooks.v1.RuntimeAccessConfig_RuntimeAccessType" json:"access_type,omitempty"`
	// The owner of this runtime after creation. Format: `alias@example.com`
	// Currently supports one owner only.
	RuntimeOwner string `protobuf:"bytes,2,opt,name=runtime_owner,json=runtimeOwner,proto3" json:"runtime_owner,omitempty"`
	// Output only. The proxy endpoint that is used to access the runtime.
	ProxyUri string `protobuf:"bytes,3,opt,name=proxy_uri,json=proxyUri,proto3" json:"proxy_uri,omitempty"`
}

func (x *RuntimeAccessConfig) Reset() {
	*x = RuntimeAccessConfig{}
	mi := &file_google_cloud_notebooks_v1_runtime_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RuntimeAccessConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeAccessConfig) ProtoMessage() {}

func (x *RuntimeAccessConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_runtime_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeAccessConfig.ProtoReflect.Descriptor instead.
func (*RuntimeAccessConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_runtime_proto_rawDescGZIP(), []int{5}
}

func (x *RuntimeAccessConfig) GetAccessType() RuntimeAccessConfig_RuntimeAccessType {
	if x != nil {
		return x.AccessType
	}
	return RuntimeAccessConfig_RUNTIME_ACCESS_TYPE_UNSPECIFIED
}

func (x *RuntimeAccessConfig) GetRuntimeOwner() string {
	if x != nil {
		return x.RuntimeOwner
	}
	return ""
}

func (x *RuntimeAccessConfig) GetProxyUri() string {
	if x != nil {
		return x.ProxyUri
	}
	return ""
}

// Specifies the selection and configuration of software inside the runtime.
// The properties to set on runtime.
// Properties keys are specified in `key:value` format, for example:
//
// * `idle_shutdown: true`
// * `idle_shutdown_timeout: 180`
// * `enable_health_monitoring: true`
type RuntimeSoftwareConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cron expression in UTC timezone, used to schedule instance auto upgrade.
	// Please follow the [cron format](https://en.wikipedia.org/wiki/Cron).
	NotebookUpgradeSchedule string `protobuf:"bytes,1,opt,name=notebook_upgrade_schedule,json=notebookUpgradeSchedule,proto3" json:"notebook_upgrade_schedule,omitempty"`
	// Verifies core internal services are running.
	// Default: True
	EnableHealthMonitoring *bool `protobuf:"varint,2,opt,name=enable_health_monitoring,json=enableHealthMonitoring,proto3,oneof" json:"enable_health_monitoring,omitempty"`
	// Runtime will automatically shutdown after idle_shutdown_time.
	// Default: True
	IdleShutdown *bool `protobuf:"varint,3,opt,name=idle_shutdown,json=idleShutdown,proto3,oneof" json:"idle_shutdown,omitempty"`
	// Time in minutes to wait before shutting down runtime. Default: 180 minutes
	IdleShutdownTimeout int32 `protobuf:"varint,4,opt,name=idle_shutdown_timeout,json=idleShutdownTimeout,proto3" json:"idle_shutdown_timeout,omitempty"`
	// Install Nvidia Driver automatically.
	// Default: True
	InstallGpuDriver bool `protobuf:"varint,5,opt,name=install_gpu_driver,json=installGpuDriver,proto3" json:"install_gpu_driver,omitempty"`
	// Specify a custom Cloud Storage path where the GPU driver is stored.
	// If not specified, we'll automatically choose from official GPU drivers.
	CustomGpuDriverPath string `protobuf:"bytes,6,opt,name=custom_gpu_driver_path,json=customGpuDriverPath,proto3" json:"custom_gpu_driver_path,omitempty"`
	// Path to a Bash script that automatically runs after a notebook instance
	// fully boots up. The path must be a URL or
	// Cloud Storage path (`gs://path-to-file/file-name`).
	PostStartupScript string `protobuf:"bytes,7,opt,name=post_startup_script,json=postStartupScript,proto3" json:"post_startup_script,omitempty"`
	// Optional. Use a list of container images to use as Kernels in the notebook instance.
	Kernels []*ContainerImage `protobuf:"bytes,8,rep,name=kernels,proto3" json:"kernels,omitempty"`
	// Output only. Bool indicating whether an newer image is available in an image family.
	Upgradeable *bool `protobuf:"varint,9,opt,name=upgradeable,proto3,oneof" json:"upgradeable,omitempty"`
	// Behavior for the post startup script.
	PostStartupScriptBehavior RuntimeSoftwareConfig_PostStartupScriptBehavior `protobuf:"varint,10,opt,name=post_startup_script_behavior,json=postStartupScriptBehavior,proto3,enum=google.cloud.notebooks.v1.RuntimeSoftwareConfig_PostStartupScriptBehavior" json:"post_startup_script_behavior,omitempty"`
	// Bool indicating whether JupyterLab terminal will be available or not.
	// Default: False
	DisableTerminal *bool `protobuf:"varint,11,opt,name=disable_terminal,json=disableTerminal,proto3,oneof" json:"disable_terminal,omitempty"`
	// Output only. version of boot image such as M100, from release label of the image.
	Version *string `protobuf:"bytes,12,opt,name=version,proto3,oneof" json:"version,omitempty"`
}

func (x *RuntimeSoftwareConfig) Reset() {
	*x = RuntimeSoftwareConfig{}
	mi := &file_google_cloud_notebooks_v1_runtime_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RuntimeSoftwareConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeSoftwareConfig) ProtoMessage() {}

func (x *RuntimeSoftwareConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_runtime_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeSoftwareConfig.ProtoReflect.Descriptor instead.
func (*RuntimeSoftwareConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_runtime_proto_rawDescGZIP(), []int{6}
}

func (x *RuntimeSoftwareConfig) GetNotebookUpgradeSchedule() string {
	if x != nil {
		return x.NotebookUpgradeSchedule
	}
	return ""
}

func (x *RuntimeSoftwareConfig) GetEnableHealthMonitoring() bool {
	if x != nil && x.EnableHealthMonitoring != nil {
		return *x.EnableHealthMonitoring
	}
	return false
}

func (x *RuntimeSoftwareConfig) GetIdleShutdown() bool {
	if x != nil && x.IdleShutdown != nil {
		return *x.IdleShutdown
	}
	return false
}

func (x *RuntimeSoftwareConfig) GetIdleShutdownTimeout() int32 {
	if x != nil {
		return x.IdleShutdownTimeout
	}
	return 0
}

func (x *RuntimeSoftwareConfig) GetInstallGpuDriver() bool {
	if x != nil {
		return x.InstallGpuDriver
	}
	return false
}

func (x *RuntimeSoftwareConfig) GetCustomGpuDriverPath() string {
	if x != nil {
		return x.CustomGpuDriverPath
	}
	return ""
}

func (x *RuntimeSoftwareConfig) GetPostStartupScript() string {
	if x != nil {
		return x.PostStartupScript
	}
	return ""
}

func (x *RuntimeSoftwareConfig) GetKernels() []*ContainerImage {
	if x != nil {
		return x.Kernels
	}
	return nil
}

func (x *RuntimeSoftwareConfig) GetUpgradeable() bool {
	if x != nil && x.Upgradeable != nil {
		return *x.Upgradeable
	}
	return false
}

func (x *RuntimeSoftwareConfig) GetPostStartupScriptBehavior() RuntimeSoftwareConfig_PostStartupScriptBehavior {
	if x != nil {
		return x.PostStartupScriptBehavior
	}
	return RuntimeSoftwareConfig_POST_STARTUP_SCRIPT_BEHAVIOR_UNSPECIFIED
}

func (x *RuntimeSoftwareConfig) GetDisableTerminal() bool {
	if x != nil && x.DisableTerminal != nil {
		return *x.DisableTerminal
	}
	return false
}

func (x *RuntimeSoftwareConfig) GetVersion() string {
	if x != nil && x.Version != nil {
		return *x.Version
	}
	return ""
}

// Contains runtime daemon metrics, such as OS and kernels and sessions stats.
type RuntimeMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The system metrics.
	SystemMetrics map[string]string `protobuf:"bytes,1,rep,name=system_metrics,json=systemMetrics,proto3" json:"system_metrics,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *RuntimeMetrics) Reset() {
	*x = RuntimeMetrics{}
	mi := &file_google_cloud_notebooks_v1_runtime_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RuntimeMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeMetrics) ProtoMessage() {}

func (x *RuntimeMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_runtime_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeMetrics.ProtoReflect.Descriptor instead.
func (*RuntimeMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_runtime_proto_rawDescGZIP(), []int{7}
}

func (x *RuntimeMetrics) GetSystemMetrics() map[string]string {
	if x != nil {
		return x.SystemMetrics
	}
	return nil
}

// A set of Shielded Instance options.
// Check [Images using supported Shielded VM
// features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
// Not all combinations are valid.
type RuntimeShieldedInstanceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines whether the instance has Secure Boot enabled.
	//
	// Secure Boot helps ensure that the system only runs authentic software by
	// verifying the digital signature of all boot components, and halting the
	// boot process if signature verification fails. Disabled by default.
	EnableSecureBoot bool `protobuf:"varint,1,opt,name=enable_secure_boot,json=enableSecureBoot,proto3" json:"enable_secure_boot,omitempty"`
	// Defines whether the instance has the vTPM enabled. Enabled by default.
	EnableVtpm bool `protobuf:"varint,2,opt,name=enable_vtpm,json=enableVtpm,proto3" json:"enable_vtpm,omitempty"`
	// Defines whether the instance has integrity monitoring enabled.
	//
	// Enables monitoring and attestation of the boot integrity of the instance.
	// The attestation is performed against the integrity policy baseline. This
	// baseline is initially derived from the implicitly trusted boot image when
	// the instance is created. Enabled by default.
	EnableIntegrityMonitoring bool `protobuf:"varint,3,opt,name=enable_integrity_monitoring,json=enableIntegrityMonitoring,proto3" json:"enable_integrity_monitoring,omitempty"`
}

func (x *RuntimeShieldedInstanceConfig) Reset() {
	*x = RuntimeShieldedInstanceConfig{}
	mi := &file_google_cloud_notebooks_v1_runtime_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RuntimeShieldedInstanceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeShieldedInstanceConfig) ProtoMessage() {}

func (x *RuntimeShieldedInstanceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_runtime_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeShieldedInstanceConfig.ProtoReflect.Descriptor instead.
func (*RuntimeShieldedInstanceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_runtime_proto_rawDescGZIP(), []int{8}
}

func (x *RuntimeShieldedInstanceConfig) GetEnableSecureBoot() bool {
	if x != nil {
		return x.EnableSecureBoot
	}
	return false
}

func (x *RuntimeShieldedInstanceConfig) GetEnableVtpm() bool {
	if x != nil {
		return x.EnableVtpm
	}
	return false
}

func (x *RuntimeShieldedInstanceConfig) GetEnableIntegrityMonitoring() bool {
	if x != nil {
		return x.EnableIntegrityMonitoring
	}
	return false
}

// Runtime using Virtual Machine for computing.
type VirtualMachine struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The user-friendly name of the Managed Compute Engine instance.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	// Output only. The unique identifier of the Managed Compute Engine instance.
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Virtual Machine configuration settings.
	VirtualMachineConfig *VirtualMachineConfig `protobuf:"bytes,3,opt,name=virtual_machine_config,json=virtualMachineConfig,proto3" json:"virtual_machine_config,omitempty"`
}

func (x *VirtualMachine) Reset() {
	*x = VirtualMachine{}
	mi := &file_google_cloud_notebooks_v1_runtime_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VirtualMachine) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VirtualMachine) ProtoMessage() {}

func (x *VirtualMachine) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_runtime_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VirtualMachine.ProtoReflect.Descriptor instead.
func (*VirtualMachine) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_runtime_proto_rawDescGZIP(), []int{9}
}

func (x *VirtualMachine) GetInstanceName() string {
	if x != nil {
		return x.InstanceName
	}
	return ""
}

func (x *VirtualMachine) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *VirtualMachine) GetVirtualMachineConfig() *VirtualMachineConfig {
	if x != nil {
		return x.VirtualMachineConfig
	}
	return nil
}

// The config settings for virtual machine.
type VirtualMachineConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The zone where the virtual machine is located.
	// If using regional request, the notebooks service will pick a location
	// in the corresponding runtime region.
	// On a get request, zone will always be present. Example:
	// * `us-central1-b`
	Zone string `protobuf:"bytes,1,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. The Compute Engine machine type used for runtimes.
	// Short name is valid. Examples:
	// * `n1-standard-2`
	// * `e2-standard-8`
	MachineType string `protobuf:"bytes,2,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// Optional. Use a list of container images to use as Kernels in the notebook instance.
	ContainerImages []*ContainerImage `protobuf:"bytes,3,rep,name=container_images,json=containerImages,proto3" json:"container_images,omitempty"`
	// Required. Data disk option configuration settings.
	DataDisk *LocalDisk `protobuf:"bytes,4,opt,name=data_disk,json=dataDisk,proto3" json:"data_disk,omitempty"`
	// Optional. Encryption settings for virtual machine data disk.
	EncryptionConfig *EncryptionConfig `protobuf:"bytes,5,opt,name=encryption_config,json=encryptionConfig,proto3" json:"encryption_config,omitempty"`
	// Optional. Shielded VM Instance configuration settings.
	ShieldedInstanceConfig *RuntimeShieldedInstanceConfig `protobuf:"bytes,6,opt,name=shielded_instance_config,json=shieldedInstanceConfig,proto3" json:"shielded_instance_config,omitempty"`
	// Optional. The Compute Engine accelerator configuration for this runtime.
	AcceleratorConfig *RuntimeAcceleratorConfig `protobuf:"bytes,7,opt,name=accelerator_config,json=acceleratorConfig,proto3" json:"accelerator_config,omitempty"`
	// Optional. The Compute Engine network to be used for machine
	// communications. Cannot be specified with subnetwork. If neither
	// `network` nor `subnet` is specified, the "default" network of
	// the project is used, if it exists.
	//
	// A full URL or partial URI. Examples:
	//
	// * `https://www.googleapis.com/compute/v1/projects/[project_id]/global/networks/default`
	// * `projects/[project_id]/global/networks/default`
	//
	// Runtimes are managed resources inside Google Infrastructure.
	// Runtimes support the following network configurations:
	//
	// * Google Managed Network (Network & subnet are empty)
	// * Consumer Project VPC (network & subnet are required). Requires
	// configuring Private Service Access.
	// * Shared VPC (network & subnet are required). Requires configuring Private
	// Service Access.
	Network string `protobuf:"bytes,8,opt,name=network,proto3" json:"network,omitempty"`
	// Optional. The Compute Engine subnetwork to be used for machine
	// communications. Cannot be specified with network.
	//
	// A full URL or partial URI are valid. Examples:
	//
	// * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/us-east1/subnetworks/sub0`
	// * `projects/[project_id]/regions/us-east1/subnetworks/sub0`
	Subnet string `protobuf:"bytes,9,opt,name=subnet,proto3" json:"subnet,omitempty"`
	// Optional. If true, runtime will only have internal IP
	// addresses. By default, runtimes are not restricted to internal IP
	// addresses, and will have ephemeral external IP addresses assigned to each
	// vm. This `internal_ip_only` restriction can only be enabled for
	// subnetwork enabled networks, and all dependencies must be
	// configured to be accessible without external IP addresses.
	InternalIpOnly bool `protobuf:"varint,10,opt,name=internal_ip_only,json=internalIpOnly,proto3" json:"internal_ip_only,omitempty"`
	// Optional. The Compute Engine tags to add to runtime (see [Tagging
	// instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
	Tags []string `protobuf:"bytes,13,rep,name=tags,proto3" json:"tags,omitempty"`
	// Output only. The Compute Engine guest attributes. (see
	// [Project and instance
	// guest
	// attributes](https://cloud.google.com/compute/docs/storing-retrieving-metadata#guest_attributes)).
	GuestAttributes map[string]string `protobuf:"bytes,14,rep,name=guest_attributes,json=guestAttributes,proto3" json:"guest_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The Compute Engine metadata entries to add to virtual machine. (see
	// [Project and instance
	// metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
	Metadata map[string]string `protobuf:"bytes,15,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The labels to associate with this runtime.
	// Label **keys** must contain 1 to 63 characters, and must conform to
	// [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
	// Label **values** may be empty, but, if present, must contain 1 to 63
	// characters, and must conform to [RFC
	// 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
	// associated with a cluster.
	Labels map[string]string `protobuf:"bytes,16,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The type of vNIC to be used on this interface. This may be gVNIC or
	// VirtioNet.
	NicType VirtualMachineConfig_NicType `protobuf:"varint,17,opt,name=nic_type,json=nicType,proto3,enum=google.cloud.notebooks.v1.VirtualMachineConfig_NicType" json:"nic_type,omitempty"`
	// Optional. Reserved IP Range name is used for VPC Peering.
	// The subnetwork allocation will use the range *name* if it's assigned.
	//
	// Example: managed-notebooks-range-c
	//
	//	PEERING_RANGE_NAME_3=managed-notebooks-range-c
	//	gcloud compute addresses create $PEERING_RANGE_NAME_3 \
	//	  --global \
	//	  --prefix-length=24 \
	//	  --description="Google Cloud Managed Notebooks Range 24 c" \
	//	  --network=$NETWORK \
	//	  --addresses=192.168.0.0 \
	//	  --purpose=VPC_PEERING
	//
	// Field value will be: `managed-notebooks-range-c`
	ReservedIpRange string `protobuf:"bytes,18,opt,name=reserved_ip_range,json=reservedIpRange,proto3" json:"reserved_ip_range,omitempty"`
	// Optional. Boot image metadata used for runtime upgradeability.
	BootImage *VirtualMachineConfig_BootImage `protobuf:"bytes,19,opt,name=boot_image,json=bootImage,proto3" json:"boot_image,omitempty"`
}

func (x *VirtualMachineConfig) Reset() {
	*x = VirtualMachineConfig{}
	mi := &file_google_cloud_notebooks_v1_runtime_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VirtualMachineConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VirtualMachineConfig) ProtoMessage() {}

func (x *VirtualMachineConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_runtime_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VirtualMachineConfig.ProtoReflect.Descriptor instead.
func (*VirtualMachineConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_runtime_proto_rawDescGZIP(), []int{10}
}

func (x *VirtualMachineConfig) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *VirtualMachineConfig) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *VirtualMachineConfig) GetContainerImages() []*ContainerImage {
	if x != nil {
		return x.ContainerImages
	}
	return nil
}

func (x *VirtualMachineConfig) GetDataDisk() *LocalDisk {
	if x != nil {
		return x.DataDisk
	}
	return nil
}

func (x *VirtualMachineConfig) GetEncryptionConfig() *EncryptionConfig {
	if x != nil {
		return x.EncryptionConfig
	}
	return nil
}

func (x *VirtualMachineConfig) GetShieldedInstanceConfig() *RuntimeShieldedInstanceConfig {
	if x != nil {
		return x.ShieldedInstanceConfig
	}
	return nil
}

func (x *VirtualMachineConfig) GetAcceleratorConfig() *RuntimeAcceleratorConfig {
	if x != nil {
		return x.AcceleratorConfig
	}
	return nil
}

func (x *VirtualMachineConfig) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *VirtualMachineConfig) GetSubnet() string {
	if x != nil {
		return x.Subnet
	}
	return ""
}

func (x *VirtualMachineConfig) GetInternalIpOnly() bool {
	if x != nil {
		return x.InternalIpOnly
	}
	return false
}

func (x *VirtualMachineConfig) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *VirtualMachineConfig) GetGuestAttributes() map[string]string {
	if x != nil {
		return x.GuestAttributes
	}
	return nil
}

func (x *VirtualMachineConfig) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *VirtualMachineConfig) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *VirtualMachineConfig) GetNicType() VirtualMachineConfig_NicType {
	if x != nil {
		return x.NicType
	}
	return VirtualMachineConfig_UNSPECIFIED_NIC_TYPE
}

func (x *VirtualMachineConfig) GetReservedIpRange() string {
	if x != nil {
		return x.ReservedIpRange
	}
	return ""
}

func (x *VirtualMachineConfig) GetBootImage() *VirtualMachineConfig_BootImage {
	if x != nil {
		return x.BootImage
	}
	return nil
}

// Optional. A list of features to enable on the guest operating system.
// Applicable only for bootable images.
// Read [Enabling guest operating system
// features](https://cloud.google.com/compute/docs/images/create-delete-deprecate-private-images#guest-os-features)
// to see a list of available options.
// Guest OS features for boot disk.
type LocalDisk_RuntimeGuestOsFeature struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of a supported feature. Read [Enabling guest operating system
	// features](https://cloud.google.com/compute/docs/images/create-delete-deprecate-private-images#guest-os-features)
	// to see a list of available options.
	//
	// Valid values:
	//
	// * `FEATURE_TYPE_UNSPECIFIED`
	// * `MULTI_IP_SUBNET`
	// * `SECURE_BOOT`
	// * `UEFI_COMPATIBLE`
	// * `VIRTIO_SCSI_MULTIQUEUE`
	// * `WINDOWS`
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *LocalDisk_RuntimeGuestOsFeature) Reset() {
	*x = LocalDisk_RuntimeGuestOsFeature{}
	mi := &file_google_cloud_notebooks_v1_runtime_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LocalDisk_RuntimeGuestOsFeature) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocalDisk_RuntimeGuestOsFeature) ProtoMessage() {}

func (x *LocalDisk_RuntimeGuestOsFeature) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_runtime_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocalDisk_RuntimeGuestOsFeature.ProtoReflect.Descriptor instead.
func (*LocalDisk_RuntimeGuestOsFeature) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_runtime_proto_rawDescGZIP(), []int{3, 0}
}

func (x *LocalDisk_RuntimeGuestOsFeature) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

// Definition of the boot image used by the Runtime.
// Used to facilitate runtime upgradeability.
type VirtualMachineConfig_BootImage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *VirtualMachineConfig_BootImage) Reset() {
	*x = VirtualMachineConfig_BootImage{}
	mi := &file_google_cloud_notebooks_v1_runtime_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VirtualMachineConfig_BootImage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VirtualMachineConfig_BootImage) ProtoMessage() {}

func (x *VirtualMachineConfig_BootImage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_runtime_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VirtualMachineConfig_BootImage.ProtoReflect.Descriptor instead.
func (*VirtualMachineConfig_BootImage) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_runtime_proto_rawDescGZIP(), []int{10, 0}
}

var File_google_cloud_notebooks_v1_runtime_proto protoreflect.FileDescriptor

var file_google_cloud_notebooks_v1_runtime_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b,
	0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x96,
	0x08, 0x0a, 0x07, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x54, 0x0a, 0x0f, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x5f, 0x6d,
	0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65,
	0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c,
	0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x48, 0x00, 0x52, 0x0e, 0x76, 0x69, 0x72, 0x74, 0x75,
	0x61, 0x6c, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x12, 0x43, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x56,
	0x0a, 0x0c, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x68, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x53, 0x0a, 0x0d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74,
	0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x59, 0x0a, 0x0f, 0x73,
	0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x73, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x48, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x22, 0x94, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15,
	0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41, 0x52, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e,
	0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10,
	0x03, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12,
	0x0b, 0x0a, 0x07, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08,
	0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x06, 0x12, 0x0d, 0x0a, 0x09, 0x55, 0x50,
	0x47, 0x52, 0x41, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x12, 0x10, 0x0a, 0x0c, 0x49, 0x4e, 0x49,
	0x54, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x49, 0x4e, 0x47, 0x10, 0x08, 0x22, 0x77, 0x0a, 0x0b, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x48, 0x45,
	0x41, 0x4c, 0x54, 0x48, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x48, 0x45, 0x41, 0x4c,
	0x54, 0x48, 0x59, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x55, 0x4e, 0x48, 0x45, 0x41, 0x4c, 0x54,
	0x48, 0x59, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x5f, 0x4e, 0x4f,
	0x54, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x15, 0x0a,
	0x11, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x52, 0x55, 0x4e, 0x4e, 0x49,
	0x4e, 0x47, 0x10, 0x04, 0x3a, 0x61, 0xea, 0x41, 0x5e, 0x0a, 0x20, 0x6e, 0x6f, 0x74, 0x65, 0x62,
	0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x2f, 0x7b, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x7d, 0x42, 0x0e, 0x0a, 0x0c, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0xb6, 0x03, 0x0a, 0x18, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x57, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x09, 0x63, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xa1, 0x02, 0x0a,
	0x0f, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x20, 0x0a, 0x1c, 0x41, 0x43, 0x43, 0x45, 0x4c, 0x45, 0x52, 0x41, 0x54, 0x4f, 0x52, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x18, 0x0a, 0x10, 0x4e, 0x56, 0x49, 0x44, 0x49, 0x41, 0x5f, 0x54, 0x45, 0x53,
	0x4c, 0x41, 0x5f, 0x4b, 0x38, 0x30, 0x10, 0x01, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x15, 0x0a, 0x11,
	0x4e, 0x56, 0x49, 0x44, 0x49, 0x41, 0x5f, 0x54, 0x45, 0x53, 0x4c, 0x41, 0x5f, 0x50, 0x31, 0x30,
	0x30, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x4e, 0x56, 0x49, 0x44, 0x49, 0x41, 0x5f, 0x54, 0x45,
	0x53, 0x4c, 0x41, 0x5f, 0x56, 0x31, 0x30, 0x30, 0x10, 0x03, 0x12, 0x13, 0x0a, 0x0f, 0x4e, 0x56,
	0x49, 0x44, 0x49, 0x41, 0x5f, 0x54, 0x45, 0x53, 0x4c, 0x41, 0x5f, 0x50, 0x34, 0x10, 0x04, 0x12,
	0x13, 0x0a, 0x0f, 0x4e, 0x56, 0x49, 0x44, 0x49, 0x41, 0x5f, 0x54, 0x45, 0x53, 0x4c, 0x41, 0x5f,
	0x54, 0x34, 0x10, 0x05, 0x12, 0x15, 0x0a, 0x11, 0x4e, 0x56, 0x49, 0x44, 0x49, 0x41, 0x5f, 0x54,
	0x45, 0x53, 0x4c, 0x41, 0x5f, 0x41, 0x31, 0x30, 0x30, 0x10, 0x06, 0x12, 0x0a, 0x0a, 0x06, 0x54,
	0x50, 0x55, 0x5f, 0x56, 0x32, 0x10, 0x07, 0x12, 0x0a, 0x0a, 0x06, 0x54, 0x50, 0x55, 0x5f, 0x56,
	0x33, 0x10, 0x08, 0x12, 0x17, 0x0a, 0x13, 0x4e, 0x56, 0x49, 0x44, 0x49, 0x41, 0x5f, 0x54, 0x45,
	0x53, 0x4c, 0x41, 0x5f, 0x54, 0x34, 0x5f, 0x56, 0x57, 0x53, 0x10, 0x09, 0x12, 0x19, 0x0a, 0x15,
	0x4e, 0x56, 0x49, 0x44, 0x49, 0x41, 0x5f, 0x54, 0x45, 0x53, 0x4c, 0x41, 0x5f, 0x50, 0x31, 0x30,
	0x30, 0x5f, 0x56, 0x57, 0x53, 0x10, 0x0a, 0x12, 0x17, 0x0a, 0x13, 0x4e, 0x56, 0x49, 0x44, 0x49,
	0x41, 0x5f, 0x54, 0x45, 0x53, 0x4c, 0x41, 0x5f, 0x50, 0x34, 0x5f, 0x56, 0x57, 0x53, 0x10, 0x0b,
	0x22, 0x2b, 0x0a, 0x10, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x17, 0x0a, 0x07, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x22, 0xa5, 0x04,
	0x0a, 0x09, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x44, 0x69, 0x73, 0x6b, 0x12, 0x24, 0x0a, 0x0b, 0x61,
	0x75, 0x74, 0x6f, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x75, 0x74, 0x6f, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x12, 0x17, 0x0a, 0x04, 0x62, 0x6f, 0x6f, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x62, 0x6f, 0x6f, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x6b, 0x0a, 0x11, 0x67, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x6f, 0x73, 0x5f, 0x66, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62,
	0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x44, 0x69, 0x73,
	0x6b, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x47, 0x75, 0x65, 0x73, 0x74, 0x4f, 0x73,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x67, 0x75,
	0x65, 0x73, 0x74, 0x4f, 0x73, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x19, 0x0a,
	0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x66, 0x0a, 0x11, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x44, 0x69, 0x73, 0x6b, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c,
	0x69, 0x7a, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x10,
	0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x12, 0x1c, 0x0a, 0x09, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x12, 0x17,
	0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x1f, 0x0a, 0x08, 0x6c, 0x69, 0x63, 0x65, 0x6e,
	0x73, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08,
	0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12, 0x16, 0x0a, 0x06,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x1a, 0x2b, 0x0a, 0x15, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x47, 0x75, 0x65, 0x73, 0x74, 0x4f, 0x73, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0xeb, 0x03, 0x0a, 0x19, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x44,
	0x69, 0x73, 0x6b, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x09, 0x64, 0x69,
	0x73, 0x6b, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x08, 0x64, 0x69, 0x73, 0x6b, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a,
	0x65, 0x47, 0x62, 0x12, 0x5f, 0x0a, 0x09, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x44, 0x69, 0x73, 0x6b, 0x49, 0x6e, 0x69, 0x74,
	0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x2e, 0x44, 0x69, 0x73,
	0x6b, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x08, 0x64, 0x69, 0x73, 0x6b,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x5d, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x05,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x44, 0x69, 0x73, 0x6b, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x63,
	0x0a, 0x08, 0x44, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x49,
	0x53, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x44, 0x5f, 0x53, 0x54, 0x41, 0x4e,
	0x44, 0x41, 0x52, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x44, 0x5f, 0x53, 0x53, 0x44,
	0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x44, 0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45,
	0x44, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x44, 0x5f, 0x45, 0x58, 0x54, 0x52, 0x45, 0x4d,
	0x45, 0x10, 0x04, 0x22, 0x9f, 0x02, 0x0a, 0x13, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x61, 0x0a, 0x0b, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x0a, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23,
	0x0a, 0x0d, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4f, 0x77,
	0x6e, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x70, 0x72, 0x6f,
	0x78, 0x79, 0x55, 0x72, 0x69, 0x22, 0x5e, 0x0a, 0x11, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x52, 0x55,
	0x4e, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0f, 0x0a, 0x0b, 0x53, 0x49, 0x4e, 0x47, 0x4c, 0x45, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x10, 0x01,
	0x12, 0x13, 0x0a, 0x0f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x41, 0x43, 0x43, 0x4f,
	0x55, 0x4e, 0x54, 0x10, 0x02, 0x22, 0xbe, 0x07, 0x0a, 0x15, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x3a, 0x0a, 0x19, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x75, 0x70, 0x67, 0x72,
	0x61, 0x64, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x17, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x55, 0x70, 0x67, 0x72,
	0x61, 0x64, 0x65, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x3d, 0x0a, 0x18, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x6d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52,
	0x16, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x4d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x69, 0x64,
	0x6c, 0x65, 0x5f, 0x73, 0x68, 0x75, 0x74, 0x64, 0x6f, 0x77, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x48, 0x01, 0x52, 0x0c, 0x69, 0x64, 0x6c, 0x65, 0x53, 0x68, 0x75, 0x74, 0x64, 0x6f, 0x77,
	0x6e, 0x88, 0x01, 0x01, 0x12, 0x32, 0x0a, 0x15, 0x69, 0x64, 0x6c, 0x65, 0x5f, 0x73, 0x68, 0x75,
	0x74, 0x64, 0x6f, 0x77, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x13, 0x69, 0x64, 0x6c, 0x65, 0x53, 0x68, 0x75, 0x74, 0x64, 0x6f, 0x77,
	0x6e, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x2c, 0x0a, 0x12, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6c, 0x6c, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x47, 0x70, 0x75,
	0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x12, 0x33, 0x0a, 0x16, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x5f, 0x67, 0x70, 0x75, 0x5f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x47, 0x70,
	0x75, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x50, 0x61, 0x74, 0x68, 0x12, 0x2e, 0x0a, 0x13, 0x70,
	0x6f, 0x73, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x75, 0x70, 0x5f, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x70, 0x6f, 0x73, 0x74, 0x53, 0x74,
	0x61, 0x72, 0x74, 0x75, 0x70, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x48, 0x0a, 0x07, 0x6b,
	0x65, 0x72, 0x6e, 0x65, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65,
	0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6b, 0x65,
	0x72, 0x6e, 0x65, 0x6c, 0x73, 0x12, 0x2a, 0x0a, 0x0b, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48,
	0x02, 0x52, 0x0b, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x61, 0x62, 0x6c, 0x65, 0x88, 0x01,
	0x01, 0x12, 0x8b, 0x01, 0x0a, 0x1c, 0x70, 0x6f, 0x73, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x75, 0x70, 0x5f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x6f, 0x66, 0x74,
	0x77, 0x61, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x53,
	0x74, 0x61, 0x72, 0x74, 0x75, 0x70, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x42, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x52, 0x19, 0x70, 0x6f, 0x73, 0x74, 0x53, 0x74, 0x61, 0x72, 0x74, 0x75,
	0x70, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x12,
	0x2e, 0x0a, 0x10, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x69,
	0x6e, 0x61, 0x6c, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x48, 0x03, 0x52, 0x0f, 0x64, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x54, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x88, 0x01, 0x01, 0x12,
	0x22, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x04, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x88, 0x01, 0x01, 0x22, 0x80, 0x01, 0x0a, 0x19, 0x50, 0x6f, 0x73, 0x74, 0x53, 0x74, 0x61, 0x72,
	0x74, 0x75, 0x70, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x12, 0x2c, 0x0a, 0x28, 0x50, 0x4f, 0x53, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x55,
	0x50, 0x5f, 0x53, 0x43, 0x52, 0x49, 0x50, 0x54, 0x5f, 0x42, 0x45, 0x48, 0x41, 0x56, 0x49, 0x4f,
	0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x13, 0x0a, 0x0f, 0x52, 0x55, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x52, 0x59, 0x5f, 0x53, 0x54, 0x41,
	0x52, 0x54, 0x10, 0x01, 0x12, 0x20, 0x0a, 0x1c, 0x44, 0x4f, 0x57, 0x4e, 0x4c, 0x4f, 0x41, 0x44,
	0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x52, 0x55, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x52, 0x59, 0x5f, 0x53,
	0x54, 0x41, 0x52, 0x54, 0x10, 0x02, 0x42, 0x1b, 0x0a, 0x19, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x69, 0x64, 0x6c, 0x65, 0x5f, 0x73, 0x68, 0x75,
	0x74, 0x64, 0x6f, 0x77, 0x6e, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64,
	0x65, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xbc, 0x01, 0x0a, 0x0e, 0x52, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x68, 0x0a, 0x0e, 0x73, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x53, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x1a, 0x40, 0x0a, 0x12, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xae, 0x01, 0x0a, 0x1d, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x53, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2c, 0x0a, 0x12, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x5f, 0x62, 0x6f, 0x6f, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x10, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x65, 0x42, 0x6f, 0x6f, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x76, 0x74, 0x70, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x56, 0x74, 0x70, 0x6d, 0x12, 0x3e, 0x0a, 0x1b, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74,
	0x6f, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x19, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x22, 0xc7, 0x01, 0x0a, 0x0e, 0x56, 0x69, 0x72, 0x74, 0x75,
	0x61, 0x6c, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x65, 0x0a, 0x16, 0x76, 0x69, 0x72,
	0x74, 0x75, 0x61, 0x6c, 0x5f, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f,
	0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x4d, 0x61, 0x63,
	0x68, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x14, 0x76, 0x69, 0x72, 0x74,
	0x75, 0x61, 0x6c, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0xe1, 0x0b, 0x0a, 0x14, 0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x4d, 0x61, 0x63, 0x68,
	0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x17, 0x0a, 0x04, 0x7a, 0x6f, 0x6e,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x7a, 0x6f,
	0x6e, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6d,
	0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x59, 0x0a, 0x10, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x73, 0x12, 0x46, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x64, 0x69,
	0x73, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x44, 0x69, 0x73, 0x6b, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x6b, 0x12, 0x5d, 0x0a,
	0x11, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x65, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x77, 0x0a, 0x18,
	0x73, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f,
	0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x53, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x73,
	0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x67, 0x0a, 0x12, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x61, 0x63, 0x63,
	0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d,
	0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x1b, 0x0a,
	0x06, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x06, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x12, 0x2d, 0x0a, 0x10, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x49, 0x70, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x61, 0x67,
	0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x74, 0x61,
	0x67, 0x73, 0x12, 0x74, 0x0a, 0x10, 0x67, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65,
	0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c,
	0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x47, 0x75,
	0x65, 0x73, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x67, 0x75, 0x65, 0x73, 0x74, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x5e, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f,
	0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x4d, 0x61,
	0x63, 0x68, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x58, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x4d, 0x61, 0x63, 0x68,
	0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x57, 0x0a, 0x08, 0x6e, 0x69, 0x63, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x11,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4e, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x07, 0x6e, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2f, 0x0a, 0x11, 0x72,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x5f, 0x69, 0x70, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65,
	0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x72, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x64, 0x49, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x5d, 0x0a, 0x0a,
	0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x72,
	0x74, 0x75, 0x61, 0x6c, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x42, 0x6f, 0x6f, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x62, 0x6f, 0x6f, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x1a, 0x0b, 0x0a, 0x09, 0x42,
	0x6f, 0x6f, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x1a, 0x42, 0x0a, 0x14, 0x47, 0x75, 0x65, 0x73,
	0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3b, 0x0a, 0x0d,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x3e, 0x0a, 0x07, 0x4e, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x18, 0x0a, 0x14, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x5f, 0x4e,
	0x49, 0x43, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x56, 0x49, 0x52,
	0x54, 0x49, 0x4f, 0x5f, 0x4e, 0x45, 0x54, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x47, 0x56, 0x4e,
	0x49, 0x43, 0x10, 0x02, 0x42, 0xc3, 0x01, 0x0a, 0x1d, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f,
	0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x0c, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6e, 0x6f, 0x74, 0x65,
	0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x6e, 0x6f, 0x74, 0x65,
	0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x70, 0x62, 0x3b, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b,
	0x73, 0x70, 0x62, 0xaa, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x56, 0x31, 0xca,
	0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4e,
	0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1c, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4e, 0x6f, 0x74,
	0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_notebooks_v1_runtime_proto_rawDescOnce sync.Once
	file_google_cloud_notebooks_v1_runtime_proto_rawDescData = file_google_cloud_notebooks_v1_runtime_proto_rawDesc
)

func file_google_cloud_notebooks_v1_runtime_proto_rawDescGZIP() []byte {
	file_google_cloud_notebooks_v1_runtime_proto_rawDescOnce.Do(func() {
		file_google_cloud_notebooks_v1_runtime_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_notebooks_v1_runtime_proto_rawDescData)
	})
	return file_google_cloud_notebooks_v1_runtime_proto_rawDescData
}

var file_google_cloud_notebooks_v1_runtime_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_google_cloud_notebooks_v1_runtime_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_google_cloud_notebooks_v1_runtime_proto_goTypes = []any{
	(Runtime_State)(0),                                   // 0: google.cloud.notebooks.v1.Runtime.State
	(Runtime_HealthState)(0),                             // 1: google.cloud.notebooks.v1.Runtime.HealthState
	(RuntimeAcceleratorConfig_AcceleratorType)(0),        // 2: google.cloud.notebooks.v1.RuntimeAcceleratorConfig.AcceleratorType
	(LocalDiskInitializeParams_DiskType)(0),              // 3: google.cloud.notebooks.v1.LocalDiskInitializeParams.DiskType
	(RuntimeAccessConfig_RuntimeAccessType)(0),           // 4: google.cloud.notebooks.v1.RuntimeAccessConfig.RuntimeAccessType
	(RuntimeSoftwareConfig_PostStartupScriptBehavior)(0), // 5: google.cloud.notebooks.v1.RuntimeSoftwareConfig.PostStartupScriptBehavior
	(VirtualMachineConfig_NicType)(0),                    // 6: google.cloud.notebooks.v1.VirtualMachineConfig.NicType
	(*Runtime)(nil),                                      // 7: google.cloud.notebooks.v1.Runtime
	(*RuntimeAcceleratorConfig)(nil),                     // 8: google.cloud.notebooks.v1.RuntimeAcceleratorConfig
	(*EncryptionConfig)(nil),                             // 9: google.cloud.notebooks.v1.EncryptionConfig
	(*LocalDisk)(nil),                                    // 10: google.cloud.notebooks.v1.LocalDisk
	(*LocalDiskInitializeParams)(nil),                    // 11: google.cloud.notebooks.v1.LocalDiskInitializeParams
	(*RuntimeAccessConfig)(nil),                          // 12: google.cloud.notebooks.v1.RuntimeAccessConfig
	(*RuntimeSoftwareConfig)(nil),                        // 13: google.cloud.notebooks.v1.RuntimeSoftwareConfig
	(*RuntimeMetrics)(nil),                               // 14: google.cloud.notebooks.v1.RuntimeMetrics
	(*RuntimeShieldedInstanceConfig)(nil),                // 15: google.cloud.notebooks.v1.RuntimeShieldedInstanceConfig
	(*VirtualMachine)(nil),                               // 16: google.cloud.notebooks.v1.VirtualMachine
	(*VirtualMachineConfig)(nil),                         // 17: google.cloud.notebooks.v1.VirtualMachineConfig
	(*LocalDisk_RuntimeGuestOsFeature)(nil),              // 18: google.cloud.notebooks.v1.LocalDisk.RuntimeGuestOsFeature
	nil,                                                  // 19: google.cloud.notebooks.v1.LocalDiskInitializeParams.LabelsEntry
	nil,                                                  // 20: google.cloud.notebooks.v1.RuntimeMetrics.SystemMetricsEntry
	(*VirtualMachineConfig_BootImage)(nil),               // 21: google.cloud.notebooks.v1.VirtualMachineConfig.BootImage
	nil,                                                  // 22: google.cloud.notebooks.v1.VirtualMachineConfig.GuestAttributesEntry
	nil,                                                  // 23: google.cloud.notebooks.v1.VirtualMachineConfig.MetadataEntry
	nil,                                                  // 24: google.cloud.notebooks.v1.VirtualMachineConfig.LabelsEntry
	(*timestamppb.Timestamp)(nil),                        // 25: google.protobuf.Timestamp
	(*ContainerImage)(nil),                               // 26: google.cloud.notebooks.v1.ContainerImage
}
var file_google_cloud_notebooks_v1_runtime_proto_depIdxs = []int32{
	16, // 0: google.cloud.notebooks.v1.Runtime.virtual_machine:type_name -> google.cloud.notebooks.v1.VirtualMachine
	0,  // 1: google.cloud.notebooks.v1.Runtime.state:type_name -> google.cloud.notebooks.v1.Runtime.State
	1,  // 2: google.cloud.notebooks.v1.Runtime.health_state:type_name -> google.cloud.notebooks.v1.Runtime.HealthState
	12, // 3: google.cloud.notebooks.v1.Runtime.access_config:type_name -> google.cloud.notebooks.v1.RuntimeAccessConfig
	13, // 4: google.cloud.notebooks.v1.Runtime.software_config:type_name -> google.cloud.notebooks.v1.RuntimeSoftwareConfig
	14, // 5: google.cloud.notebooks.v1.Runtime.metrics:type_name -> google.cloud.notebooks.v1.RuntimeMetrics
	25, // 6: google.cloud.notebooks.v1.Runtime.create_time:type_name -> google.protobuf.Timestamp
	25, // 7: google.cloud.notebooks.v1.Runtime.update_time:type_name -> google.protobuf.Timestamp
	2,  // 8: google.cloud.notebooks.v1.RuntimeAcceleratorConfig.type:type_name -> google.cloud.notebooks.v1.RuntimeAcceleratorConfig.AcceleratorType
	18, // 9: google.cloud.notebooks.v1.LocalDisk.guest_os_features:type_name -> google.cloud.notebooks.v1.LocalDisk.RuntimeGuestOsFeature
	11, // 10: google.cloud.notebooks.v1.LocalDisk.initialize_params:type_name -> google.cloud.notebooks.v1.LocalDiskInitializeParams
	3,  // 11: google.cloud.notebooks.v1.LocalDiskInitializeParams.disk_type:type_name -> google.cloud.notebooks.v1.LocalDiskInitializeParams.DiskType
	19, // 12: google.cloud.notebooks.v1.LocalDiskInitializeParams.labels:type_name -> google.cloud.notebooks.v1.LocalDiskInitializeParams.LabelsEntry
	4,  // 13: google.cloud.notebooks.v1.RuntimeAccessConfig.access_type:type_name -> google.cloud.notebooks.v1.RuntimeAccessConfig.RuntimeAccessType
	26, // 14: google.cloud.notebooks.v1.RuntimeSoftwareConfig.kernels:type_name -> google.cloud.notebooks.v1.ContainerImage
	5,  // 15: google.cloud.notebooks.v1.RuntimeSoftwareConfig.post_startup_script_behavior:type_name -> google.cloud.notebooks.v1.RuntimeSoftwareConfig.PostStartupScriptBehavior
	20, // 16: google.cloud.notebooks.v1.RuntimeMetrics.system_metrics:type_name -> google.cloud.notebooks.v1.RuntimeMetrics.SystemMetricsEntry
	17, // 17: google.cloud.notebooks.v1.VirtualMachine.virtual_machine_config:type_name -> google.cloud.notebooks.v1.VirtualMachineConfig
	26, // 18: google.cloud.notebooks.v1.VirtualMachineConfig.container_images:type_name -> google.cloud.notebooks.v1.ContainerImage
	10, // 19: google.cloud.notebooks.v1.VirtualMachineConfig.data_disk:type_name -> google.cloud.notebooks.v1.LocalDisk
	9,  // 20: google.cloud.notebooks.v1.VirtualMachineConfig.encryption_config:type_name -> google.cloud.notebooks.v1.EncryptionConfig
	15, // 21: google.cloud.notebooks.v1.VirtualMachineConfig.shielded_instance_config:type_name -> google.cloud.notebooks.v1.RuntimeShieldedInstanceConfig
	8,  // 22: google.cloud.notebooks.v1.VirtualMachineConfig.accelerator_config:type_name -> google.cloud.notebooks.v1.RuntimeAcceleratorConfig
	22, // 23: google.cloud.notebooks.v1.VirtualMachineConfig.guest_attributes:type_name -> google.cloud.notebooks.v1.VirtualMachineConfig.GuestAttributesEntry
	23, // 24: google.cloud.notebooks.v1.VirtualMachineConfig.metadata:type_name -> google.cloud.notebooks.v1.VirtualMachineConfig.MetadataEntry
	24, // 25: google.cloud.notebooks.v1.VirtualMachineConfig.labels:type_name -> google.cloud.notebooks.v1.VirtualMachineConfig.LabelsEntry
	6,  // 26: google.cloud.notebooks.v1.VirtualMachineConfig.nic_type:type_name -> google.cloud.notebooks.v1.VirtualMachineConfig.NicType
	21, // 27: google.cloud.notebooks.v1.VirtualMachineConfig.boot_image:type_name -> google.cloud.notebooks.v1.VirtualMachineConfig.BootImage
	28, // [28:28] is the sub-list for method output_type
	28, // [28:28] is the sub-list for method input_type
	28, // [28:28] is the sub-list for extension type_name
	28, // [28:28] is the sub-list for extension extendee
	0,  // [0:28] is the sub-list for field type_name
}

func init() { file_google_cloud_notebooks_v1_runtime_proto_init() }
func file_google_cloud_notebooks_v1_runtime_proto_init() {
	if File_google_cloud_notebooks_v1_runtime_proto != nil {
		return
	}
	file_google_cloud_notebooks_v1_environment_proto_init()
	file_google_cloud_notebooks_v1_runtime_proto_msgTypes[0].OneofWrappers = []any{
		(*Runtime_VirtualMachine)(nil),
	}
	file_google_cloud_notebooks_v1_runtime_proto_msgTypes[6].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_notebooks_v1_runtime_proto_rawDesc,
			NumEnums:      7,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_notebooks_v1_runtime_proto_goTypes,
		DependencyIndexes: file_google_cloud_notebooks_v1_runtime_proto_depIdxs,
		EnumInfos:         file_google_cloud_notebooks_v1_runtime_proto_enumTypes,
		MessageInfos:      file_google_cloud_notebooks_v1_runtime_proto_msgTypes,
	}.Build()
	File_google_cloud_notebooks_v1_runtime_proto = out.File
	file_google_cloud_notebooks_v1_runtime_proto_rawDesc = nil
	file_google_cloud_notebooks_v1_runtime_proto_goTypes = nil
	file_google_cloud_notebooks_v1_runtime_proto_depIdxs = nil
}
