// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/networkmanagement/v1/vpc_flow_logs.proto

package networkmanagementpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request for the `ListVpcFlowLogsConfigs` method.
type ListVpcFlowLogsConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the VpcFlowLogsConfig:
	//
	//	`projects/{project_id}/locations/global`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Number of `VpcFlowLogsConfigs` to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token from an earlier query, as returned in
	// `next_page_token`.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Lists the `VpcFlowLogsConfigs` that match the filter expression.
	// A filter expression must use the supported [CEL logic operators]
	// (https://cloud.google.com/vpc/docs/about-flow-logs-records#supported_cel_logic_operators).
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Field to use to sort the list.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListVpcFlowLogsConfigsRequest) Reset() {
	*x = ListVpcFlowLogsConfigsRequest{}
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListVpcFlowLogsConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVpcFlowLogsConfigsRequest) ProtoMessage() {}

func (x *ListVpcFlowLogsConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVpcFlowLogsConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListVpcFlowLogsConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescGZIP(), []int{0}
}

func (x *ListVpcFlowLogsConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListVpcFlowLogsConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListVpcFlowLogsConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListVpcFlowLogsConfigsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListVpcFlowLogsConfigsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response for the `ListVpcFlowLogsConfigs` method.
type ListVpcFlowLogsConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of VPC Flow Log configurations.
	VpcFlowLogsConfigs []*VpcFlowLogsConfig `protobuf:"bytes,1,rep,name=vpc_flow_logs_configs,json=vpcFlowLogsConfigs,proto3" json:"vpc_flow_logs_configs,omitempty"`
	// Page token to fetch the next set of configurations.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached (when querying all locations with `-`).
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListVpcFlowLogsConfigsResponse) Reset() {
	*x = ListVpcFlowLogsConfigsResponse{}
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListVpcFlowLogsConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVpcFlowLogsConfigsResponse) ProtoMessage() {}

func (x *ListVpcFlowLogsConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVpcFlowLogsConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListVpcFlowLogsConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescGZIP(), []int{1}
}

func (x *ListVpcFlowLogsConfigsResponse) GetVpcFlowLogsConfigs() []*VpcFlowLogsConfig {
	if x != nil {
		return x.VpcFlowLogsConfigs
	}
	return nil
}

func (x *ListVpcFlowLogsConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListVpcFlowLogsConfigsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for the `GetVpcFlowLogsConfig` method.
type GetVpcFlowLogsConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. `VpcFlowLogsConfig` resource name using the form:
	//
	//	`projects/{project_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetVpcFlowLogsConfigRequest) Reset() {
	*x = GetVpcFlowLogsConfigRequest{}
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetVpcFlowLogsConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVpcFlowLogsConfigRequest) ProtoMessage() {}

func (x *GetVpcFlowLogsConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVpcFlowLogsConfigRequest.ProtoReflect.Descriptor instead.
func (*GetVpcFlowLogsConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescGZIP(), []int{2}
}

func (x *GetVpcFlowLogsConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for the `CreateVpcFlowLogsConfig` method.
type CreateVpcFlowLogsConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the VPC Flow Logs configuration to create:
	//
	//	`projects/{project_id}/locations/global`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. ID of the `VpcFlowLogsConfig`.
	VpcFlowLogsConfigId string `protobuf:"bytes,2,opt,name=vpc_flow_logs_config_id,json=vpcFlowLogsConfigId,proto3" json:"vpc_flow_logs_config_id,omitempty"`
	// Required. A `VpcFlowLogsConfig` resource
	VpcFlowLogsConfig *VpcFlowLogsConfig `protobuf:"bytes,3,opt,name=vpc_flow_logs_config,json=vpcFlowLogsConfig,proto3" json:"vpc_flow_logs_config,omitempty"`
}

func (x *CreateVpcFlowLogsConfigRequest) Reset() {
	*x = CreateVpcFlowLogsConfigRequest{}
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateVpcFlowLogsConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateVpcFlowLogsConfigRequest) ProtoMessage() {}

func (x *CreateVpcFlowLogsConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateVpcFlowLogsConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateVpcFlowLogsConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescGZIP(), []int{3}
}

func (x *CreateVpcFlowLogsConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateVpcFlowLogsConfigRequest) GetVpcFlowLogsConfigId() string {
	if x != nil {
		return x.VpcFlowLogsConfigId
	}
	return ""
}

func (x *CreateVpcFlowLogsConfigRequest) GetVpcFlowLogsConfig() *VpcFlowLogsConfig {
	if x != nil {
		return x.VpcFlowLogsConfig
	}
	return nil
}

// Request for the `UpdateVpcFlowLogsConfig` method.
type UpdateVpcFlowLogsConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Mask of fields to update. At least one path must be supplied in
	// this field.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. Only fields specified in update_mask are updated.
	VpcFlowLogsConfig *VpcFlowLogsConfig `protobuf:"bytes,2,opt,name=vpc_flow_logs_config,json=vpcFlowLogsConfig,proto3" json:"vpc_flow_logs_config,omitempty"`
}

func (x *UpdateVpcFlowLogsConfigRequest) Reset() {
	*x = UpdateVpcFlowLogsConfigRequest{}
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateVpcFlowLogsConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateVpcFlowLogsConfigRequest) ProtoMessage() {}

func (x *UpdateVpcFlowLogsConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateVpcFlowLogsConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateVpcFlowLogsConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateVpcFlowLogsConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateVpcFlowLogsConfigRequest) GetVpcFlowLogsConfig() *VpcFlowLogsConfig {
	if x != nil {
		return x.VpcFlowLogsConfig
	}
	return nil
}

// Request for the `DeleteVpcFlowLogsConfig` method.
type DeleteVpcFlowLogsConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. `VpcFlowLogsConfig` resource name using the form:
	//
	//	`projects/{project_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteVpcFlowLogsConfigRequest) Reset() {
	*x = DeleteVpcFlowLogsConfigRequest{}
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteVpcFlowLogsConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteVpcFlowLogsConfigRequest) ProtoMessage() {}

func (x *DeleteVpcFlowLogsConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteVpcFlowLogsConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteVpcFlowLogsConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteVpcFlowLogsConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_cloud_networkmanagement_v1_vpc_flow_logs_proto protoreflect.FileDescriptor

var file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2f, 0x76, 0x31, 0x2f, 0x76, 0x70, 0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x6f, 0x67,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x31,
	0x2f, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x76, 0x70, 0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f,
	0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf6, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x70,
	0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x52, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x34, 0x12,
	0x32, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e,
	0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xd3,
	0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f,
	0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x67, 0x0a, 0x15, 0x76, 0x70, 0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x6f,
	0x67, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x12, 0x76, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c,
	0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68,
	0x61, 0x62, 0x6c, 0x65, 0x22, 0x6d, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x56, 0x70, 0x63, 0x46, 0x6c,
	0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x34, 0x0a, 0x32, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x70, 0x63, 0x46,
	0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xd2, 0x02, 0x0a, 0x1e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x70,
	0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x52, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x34, 0x12, 0x32,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x70, 0x0a, 0x17, 0x76, 0x70,
	0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x34, 0x0a, 0x32, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x13, 0x76, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77,
	0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x12, 0x6a, 0x0a, 0x14,
	0x76, 0x70, 0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x56,
	0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x76, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f,
	0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xce, 0x01, 0x0a, 0x1e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x6a, 0x0a,
	0x14, 0x76, 0x70, 0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x76, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c,
	0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x70, 0x0a, 0x1e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x34, 0x0a, 0x32, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0xec, 0x0b, 0x0a, 0x12,
	0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x12, 0xe6, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x70, 0x63, 0x46, 0x6c,
	0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x40, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c,
	0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x47, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77,
	0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0xd3, 0x01, 0x0a, 0x14,
	0x47, 0x65, 0x74, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x56, 0x70, 0x63, 0x46,
	0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77,
	0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x45, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x70, 0x63, 0x46,
	0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xd3, 0x02, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x70, 0x63, 0x46,
	0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x41, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c,
	0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xd5, 0x01, 0xca, 0x41, 0x48, 0x0a, 0x11, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f,
	0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x33,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x76, 0x70, 0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f,
	0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x76, 0x70, 0x63, 0x5f,
	0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x3a, 0x14, 0x76, 0x70, 0x63, 0x5f, 0x66,
	0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22,
	0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0xd5, 0x02, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x70,
	0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xd7, 0x01, 0xca, 0x41, 0x48, 0x0a, 0x11, 0x56, 0x70, 0x63,
	0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x33,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x20, 0x76, 0x70, 0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c,
	0x6f, 0x67, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x63, 0x3a, 0x14, 0x76, 0x70,
	0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x32, 0x4b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x76, 0x70, 0x63, 0x5f, 0x66, 0x6c, 0x6f,
	0x77, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x70, 0x63, 0x46, 0x6c, 0x6f,
	0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0x92, 0x02, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f,
	0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x94, 0x01,
	0xca, 0x41, 0x4c, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x33, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x2a, 0x36, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76,
	0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x54, 0xca, 0x41, 0x20, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xff, 0x01, 0x0a, 0x25, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x42, 0x10, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67,
	0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x53, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x70, 0x62, 0x3b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x70, 0x62, 0xaa, 0x02, 0x21,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x56,
	0x31, 0xca, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x4d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescOnce sync.Once
	file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescData = file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDesc
)

func file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescGZIP() []byte {
	file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescOnce.Do(func() {
		file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescData)
	})
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescData
}

var file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_goTypes = []any{
	(*ListVpcFlowLogsConfigsRequest)(nil),  // 0: google.cloud.networkmanagement.v1.ListVpcFlowLogsConfigsRequest
	(*ListVpcFlowLogsConfigsResponse)(nil), // 1: google.cloud.networkmanagement.v1.ListVpcFlowLogsConfigsResponse
	(*GetVpcFlowLogsConfigRequest)(nil),    // 2: google.cloud.networkmanagement.v1.GetVpcFlowLogsConfigRequest
	(*CreateVpcFlowLogsConfigRequest)(nil), // 3: google.cloud.networkmanagement.v1.CreateVpcFlowLogsConfigRequest
	(*UpdateVpcFlowLogsConfigRequest)(nil), // 4: google.cloud.networkmanagement.v1.UpdateVpcFlowLogsConfigRequest
	(*DeleteVpcFlowLogsConfigRequest)(nil), // 5: google.cloud.networkmanagement.v1.DeleteVpcFlowLogsConfigRequest
	(*VpcFlowLogsConfig)(nil),              // 6: google.cloud.networkmanagement.v1.VpcFlowLogsConfig
	(*fieldmaskpb.FieldMask)(nil),          // 7: google.protobuf.FieldMask
	(*longrunningpb.Operation)(nil),        // 8: google.longrunning.Operation
}
var file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_depIdxs = []int32{
	6, // 0: google.cloud.networkmanagement.v1.ListVpcFlowLogsConfigsResponse.vpc_flow_logs_configs:type_name -> google.cloud.networkmanagement.v1.VpcFlowLogsConfig
	6, // 1: google.cloud.networkmanagement.v1.CreateVpcFlowLogsConfigRequest.vpc_flow_logs_config:type_name -> google.cloud.networkmanagement.v1.VpcFlowLogsConfig
	7, // 2: google.cloud.networkmanagement.v1.UpdateVpcFlowLogsConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	6, // 3: google.cloud.networkmanagement.v1.UpdateVpcFlowLogsConfigRequest.vpc_flow_logs_config:type_name -> google.cloud.networkmanagement.v1.VpcFlowLogsConfig
	0, // 4: google.cloud.networkmanagement.v1.VpcFlowLogsService.ListVpcFlowLogsConfigs:input_type -> google.cloud.networkmanagement.v1.ListVpcFlowLogsConfigsRequest
	2, // 5: google.cloud.networkmanagement.v1.VpcFlowLogsService.GetVpcFlowLogsConfig:input_type -> google.cloud.networkmanagement.v1.GetVpcFlowLogsConfigRequest
	3, // 6: google.cloud.networkmanagement.v1.VpcFlowLogsService.CreateVpcFlowLogsConfig:input_type -> google.cloud.networkmanagement.v1.CreateVpcFlowLogsConfigRequest
	4, // 7: google.cloud.networkmanagement.v1.VpcFlowLogsService.UpdateVpcFlowLogsConfig:input_type -> google.cloud.networkmanagement.v1.UpdateVpcFlowLogsConfigRequest
	5, // 8: google.cloud.networkmanagement.v1.VpcFlowLogsService.DeleteVpcFlowLogsConfig:input_type -> google.cloud.networkmanagement.v1.DeleteVpcFlowLogsConfigRequest
	1, // 9: google.cloud.networkmanagement.v1.VpcFlowLogsService.ListVpcFlowLogsConfigs:output_type -> google.cloud.networkmanagement.v1.ListVpcFlowLogsConfigsResponse
	6, // 10: google.cloud.networkmanagement.v1.VpcFlowLogsService.GetVpcFlowLogsConfig:output_type -> google.cloud.networkmanagement.v1.VpcFlowLogsConfig
	8, // 11: google.cloud.networkmanagement.v1.VpcFlowLogsService.CreateVpcFlowLogsConfig:output_type -> google.longrunning.Operation
	8, // 12: google.cloud.networkmanagement.v1.VpcFlowLogsService.UpdateVpcFlowLogsConfig:output_type -> google.longrunning.Operation
	8, // 13: google.cloud.networkmanagement.v1.VpcFlowLogsService.DeleteVpcFlowLogsConfig:output_type -> google.longrunning.Operation
	9, // [9:14] is the sub-list for method output_type
	4, // [4:9] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_init() }
func file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_init() {
	if File_google_cloud_networkmanagement_v1_vpc_flow_logs_proto != nil {
		return
	}
	file_google_cloud_networkmanagement_v1_reachability_proto_init()
	file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_goTypes,
		DependencyIndexes: file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_depIdxs,
		MessageInfos:      file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes,
	}.Build()
	File_google_cloud_networkmanagement_v1_vpc_flow_logs_proto = out.File
	file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDesc = nil
	file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_goTypes = nil
	file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// VpcFlowLogsServiceClient is the client API for VpcFlowLogsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VpcFlowLogsServiceClient interface {
	// Lists all `VpcFlowLogsConfigs` in a given project.
	ListVpcFlowLogsConfigs(ctx context.Context, in *ListVpcFlowLogsConfigsRequest, opts ...grpc.CallOption) (*ListVpcFlowLogsConfigsResponse, error)
	// Gets the details of a specific `VpcFlowLogsConfig`.
	GetVpcFlowLogsConfig(ctx context.Context, in *GetVpcFlowLogsConfigRequest, opts ...grpc.CallOption) (*VpcFlowLogsConfig, error)
	// Creates a new `VpcFlowLogsConfig`.
	// If a configuration with the exact same settings already exists (even if the
	// ID is different), the creation fails.
	// Notes:
	//
	//  1. Creating a configuration with state=DISABLED will fail
	//  2. The following fields are not considered as `settings` for the purpose
	//     of the check mentioned above, therefore - creating another configuration
	//     with the same fields but different values for the following fields will
	//     fail as well:
	//     * name
	//     * create_time
	//     * update_time
	//     * labels
	//     * description
	CreateVpcFlowLogsConfig(ctx context.Context, in *CreateVpcFlowLogsConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an existing `VpcFlowLogsConfig`.
	// If a configuration with the exact same settings already exists (even if the
	// ID is different), the creation fails.
	// Notes:
	//
	//  1. Updating a configuration with state=DISABLED will fail.
	//  2. The following fields are not considered as `settings` for the purpose
	//     of the check mentioned above, therefore - updating another configuration
	//     with the same fields but different values for the following fields will
	//     fail as well:
	//     * name
	//     * create_time
	//     * update_time
	//     * labels
	//     * description
	UpdateVpcFlowLogsConfig(ctx context.Context, in *UpdateVpcFlowLogsConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a specific `VpcFlowLogsConfig`.
	DeleteVpcFlowLogsConfig(ctx context.Context, in *DeleteVpcFlowLogsConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type vpcFlowLogsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewVpcFlowLogsServiceClient(cc grpc.ClientConnInterface) VpcFlowLogsServiceClient {
	return &vpcFlowLogsServiceClient{cc}
}

func (c *vpcFlowLogsServiceClient) ListVpcFlowLogsConfigs(ctx context.Context, in *ListVpcFlowLogsConfigsRequest, opts ...grpc.CallOption) (*ListVpcFlowLogsConfigsResponse, error) {
	out := new(ListVpcFlowLogsConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.networkmanagement.v1.VpcFlowLogsService/ListVpcFlowLogsConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vpcFlowLogsServiceClient) GetVpcFlowLogsConfig(ctx context.Context, in *GetVpcFlowLogsConfigRequest, opts ...grpc.CallOption) (*VpcFlowLogsConfig, error) {
	out := new(VpcFlowLogsConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.networkmanagement.v1.VpcFlowLogsService/GetVpcFlowLogsConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vpcFlowLogsServiceClient) CreateVpcFlowLogsConfig(ctx context.Context, in *CreateVpcFlowLogsConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkmanagement.v1.VpcFlowLogsService/CreateVpcFlowLogsConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vpcFlowLogsServiceClient) UpdateVpcFlowLogsConfig(ctx context.Context, in *UpdateVpcFlowLogsConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkmanagement.v1.VpcFlowLogsService/UpdateVpcFlowLogsConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vpcFlowLogsServiceClient) DeleteVpcFlowLogsConfig(ctx context.Context, in *DeleteVpcFlowLogsConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkmanagement.v1.VpcFlowLogsService/DeleteVpcFlowLogsConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VpcFlowLogsServiceServer is the server API for VpcFlowLogsService service.
type VpcFlowLogsServiceServer interface {
	// Lists all `VpcFlowLogsConfigs` in a given project.
	ListVpcFlowLogsConfigs(context.Context, *ListVpcFlowLogsConfigsRequest) (*ListVpcFlowLogsConfigsResponse, error)
	// Gets the details of a specific `VpcFlowLogsConfig`.
	GetVpcFlowLogsConfig(context.Context, *GetVpcFlowLogsConfigRequest) (*VpcFlowLogsConfig, error)
	// Creates a new `VpcFlowLogsConfig`.
	// If a configuration with the exact same settings already exists (even if the
	// ID is different), the creation fails.
	// Notes:
	//
	//  1. Creating a configuration with state=DISABLED will fail
	//  2. The following fields are not considered as `settings` for the purpose
	//     of the check mentioned above, therefore - creating another configuration
	//     with the same fields but different values for the following fields will
	//     fail as well:
	//     * name
	//     * create_time
	//     * update_time
	//     * labels
	//     * description
	CreateVpcFlowLogsConfig(context.Context, *CreateVpcFlowLogsConfigRequest) (*longrunningpb.Operation, error)
	// Updates an existing `VpcFlowLogsConfig`.
	// If a configuration with the exact same settings already exists (even if the
	// ID is different), the creation fails.
	// Notes:
	//
	//  1. Updating a configuration with state=DISABLED will fail.
	//  2. The following fields are not considered as `settings` for the purpose
	//     of the check mentioned above, therefore - updating another configuration
	//     with the same fields but different values for the following fields will
	//     fail as well:
	//     * name
	//     * create_time
	//     * update_time
	//     * labels
	//     * description
	UpdateVpcFlowLogsConfig(context.Context, *UpdateVpcFlowLogsConfigRequest) (*longrunningpb.Operation, error)
	// Deletes a specific `VpcFlowLogsConfig`.
	DeleteVpcFlowLogsConfig(context.Context, *DeleteVpcFlowLogsConfigRequest) (*longrunningpb.Operation, error)
}

// UnimplementedVpcFlowLogsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedVpcFlowLogsServiceServer struct {
}

func (*UnimplementedVpcFlowLogsServiceServer) ListVpcFlowLogsConfigs(context.Context, *ListVpcFlowLogsConfigsRequest) (*ListVpcFlowLogsConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVpcFlowLogsConfigs not implemented")
}
func (*UnimplementedVpcFlowLogsServiceServer) GetVpcFlowLogsConfig(context.Context, *GetVpcFlowLogsConfigRequest) (*VpcFlowLogsConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVpcFlowLogsConfig not implemented")
}
func (*UnimplementedVpcFlowLogsServiceServer) CreateVpcFlowLogsConfig(context.Context, *CreateVpcFlowLogsConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateVpcFlowLogsConfig not implemented")
}
func (*UnimplementedVpcFlowLogsServiceServer) UpdateVpcFlowLogsConfig(context.Context, *UpdateVpcFlowLogsConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateVpcFlowLogsConfig not implemented")
}
func (*UnimplementedVpcFlowLogsServiceServer) DeleteVpcFlowLogsConfig(context.Context, *DeleteVpcFlowLogsConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteVpcFlowLogsConfig not implemented")
}

func RegisterVpcFlowLogsServiceServer(s *grpc.Server, srv VpcFlowLogsServiceServer) {
	s.RegisterService(&_VpcFlowLogsService_serviceDesc, srv)
}

func _VpcFlowLogsService_ListVpcFlowLogsConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVpcFlowLogsConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VpcFlowLogsServiceServer).ListVpcFlowLogsConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkmanagement.v1.VpcFlowLogsService/ListVpcFlowLogsConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VpcFlowLogsServiceServer).ListVpcFlowLogsConfigs(ctx, req.(*ListVpcFlowLogsConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VpcFlowLogsService_GetVpcFlowLogsConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVpcFlowLogsConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VpcFlowLogsServiceServer).GetVpcFlowLogsConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkmanagement.v1.VpcFlowLogsService/GetVpcFlowLogsConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VpcFlowLogsServiceServer).GetVpcFlowLogsConfig(ctx, req.(*GetVpcFlowLogsConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VpcFlowLogsService_CreateVpcFlowLogsConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVpcFlowLogsConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VpcFlowLogsServiceServer).CreateVpcFlowLogsConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkmanagement.v1.VpcFlowLogsService/CreateVpcFlowLogsConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VpcFlowLogsServiceServer).CreateVpcFlowLogsConfig(ctx, req.(*CreateVpcFlowLogsConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VpcFlowLogsService_UpdateVpcFlowLogsConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVpcFlowLogsConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VpcFlowLogsServiceServer).UpdateVpcFlowLogsConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkmanagement.v1.VpcFlowLogsService/UpdateVpcFlowLogsConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VpcFlowLogsServiceServer).UpdateVpcFlowLogsConfig(ctx, req.(*UpdateVpcFlowLogsConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VpcFlowLogsService_DeleteVpcFlowLogsConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVpcFlowLogsConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VpcFlowLogsServiceServer).DeleteVpcFlowLogsConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkmanagement.v1.VpcFlowLogsService/DeleteVpcFlowLogsConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VpcFlowLogsServiceServer).DeleteVpcFlowLogsConfig(ctx, req.(*DeleteVpcFlowLogsConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VpcFlowLogsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.networkmanagement.v1.VpcFlowLogsService",
	HandlerType: (*VpcFlowLogsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListVpcFlowLogsConfigs",
			Handler:    _VpcFlowLogsService_ListVpcFlowLogsConfigs_Handler,
		},
		{
			MethodName: "GetVpcFlowLogsConfig",
			Handler:    _VpcFlowLogsService_GetVpcFlowLogsConfig_Handler,
		},
		{
			MethodName: "CreateVpcFlowLogsConfig",
			Handler:    _VpcFlowLogsService_CreateVpcFlowLogsConfig_Handler,
		},
		{
			MethodName: "UpdateVpcFlowLogsConfig",
			Handler:    _VpcFlowLogsService_UpdateVpcFlowLogsConfig_Handler,
		},
		{
			MethodName: "DeleteVpcFlowLogsConfig",
			Handler:    _VpcFlowLogsService_DeleteVpcFlowLogsConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/networkmanagement/v1/vpc_flow_logs.proto",
}
