// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package networkconnectivity

import (
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/url"

	iampb "cloud.google.com/go/iam/apiv1/iampb"
	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	networkconnectivitypb "cloud.google.com/go/networkconnectivity/apiv1/networkconnectivitypb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	locationpb "google.golang.org/genproto/googleapis/cloud/location"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/proto"
)

var newCrossNetworkAutomationClientHook clientHook

// CrossNetworkAutomationCallOptions contains the retry settings for each method of CrossNetworkAutomationClient.
type CrossNetworkAutomationCallOptions struct {
	ListServiceConnectionMaps     []gax.CallOption
	GetServiceConnectionMap       []gax.CallOption
	CreateServiceConnectionMap    []gax.CallOption
	UpdateServiceConnectionMap    []gax.CallOption
	DeleteServiceConnectionMap    []gax.CallOption
	ListServiceConnectionPolicies []gax.CallOption
	GetServiceConnectionPolicy    []gax.CallOption
	CreateServiceConnectionPolicy []gax.CallOption
	UpdateServiceConnectionPolicy []gax.CallOption
	DeleteServiceConnectionPolicy []gax.CallOption
	ListServiceClasses            []gax.CallOption
	GetServiceClass               []gax.CallOption
	UpdateServiceClass            []gax.CallOption
	DeleteServiceClass            []gax.CallOption
	GetServiceConnectionToken     []gax.CallOption
	ListServiceConnectionTokens   []gax.CallOption
	CreateServiceConnectionToken  []gax.CallOption
	DeleteServiceConnectionToken  []gax.CallOption
	GetLocation                   []gax.CallOption
	ListLocations                 []gax.CallOption
	GetIamPolicy                  []gax.CallOption
	SetIamPolicy                  []gax.CallOption
	TestIamPermissions            []gax.CallOption
	CancelOperation               []gax.CallOption
	DeleteOperation               []gax.CallOption
	GetOperation                  []gax.CallOption
	ListOperations                []gax.CallOption
}

func defaultCrossNetworkAutomationGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("networkconnectivity.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("networkconnectivity.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("networkconnectivity.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://networkconnectivity.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultCrossNetworkAutomationCallOptions() *CrossNetworkAutomationCallOptions {
	return &CrossNetworkAutomationCallOptions{
		ListServiceConnectionMaps:     []gax.CallOption{},
		GetServiceConnectionMap:       []gax.CallOption{},
		CreateServiceConnectionMap:    []gax.CallOption{},
		UpdateServiceConnectionMap:    []gax.CallOption{},
		DeleteServiceConnectionMap:    []gax.CallOption{},
		ListServiceConnectionPolicies: []gax.CallOption{},
		GetServiceConnectionPolicy:    []gax.CallOption{},
		CreateServiceConnectionPolicy: []gax.CallOption{},
		UpdateServiceConnectionPolicy: []gax.CallOption{},
		DeleteServiceConnectionPolicy: []gax.CallOption{},
		ListServiceClasses:            []gax.CallOption{},
		GetServiceClass:               []gax.CallOption{},
		UpdateServiceClass:            []gax.CallOption{},
		DeleteServiceClass:            []gax.CallOption{},
		GetServiceConnectionToken:     []gax.CallOption{},
		ListServiceConnectionTokens:   []gax.CallOption{},
		CreateServiceConnectionToken:  []gax.CallOption{},
		DeleteServiceConnectionToken:  []gax.CallOption{},
		GetLocation:                   []gax.CallOption{},
		ListLocations:                 []gax.CallOption{},
		GetIamPolicy:                  []gax.CallOption{},
		SetIamPolicy:                  []gax.CallOption{},
		TestIamPermissions:            []gax.CallOption{},
		CancelOperation:               []gax.CallOption{},
		DeleteOperation:               []gax.CallOption{},
		GetOperation:                  []gax.CallOption{},
		ListOperations:                []gax.CallOption{},
	}
}

// internalCrossNetworkAutomationClient is an interface that defines the methods available from Network Connectivity API.
type internalCrossNetworkAutomationClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListServiceConnectionMaps(context.Context, *networkconnectivitypb.ListServiceConnectionMapsRequest, ...gax.CallOption) *ServiceConnectionMapIterator
	GetServiceConnectionMap(context.Context, *networkconnectivitypb.GetServiceConnectionMapRequest, ...gax.CallOption) (*networkconnectivitypb.ServiceConnectionMap, error)
	CreateServiceConnectionMap(context.Context, *networkconnectivitypb.CreateServiceConnectionMapRequest, ...gax.CallOption) (*CreateServiceConnectionMapOperation, error)
	CreateServiceConnectionMapOperation(name string) *CreateServiceConnectionMapOperation
	UpdateServiceConnectionMap(context.Context, *networkconnectivitypb.UpdateServiceConnectionMapRequest, ...gax.CallOption) (*UpdateServiceConnectionMapOperation, error)
	UpdateServiceConnectionMapOperation(name string) *UpdateServiceConnectionMapOperation
	DeleteServiceConnectionMap(context.Context, *networkconnectivitypb.DeleteServiceConnectionMapRequest, ...gax.CallOption) (*DeleteServiceConnectionMapOperation, error)
	DeleteServiceConnectionMapOperation(name string) *DeleteServiceConnectionMapOperation
	ListServiceConnectionPolicies(context.Context, *networkconnectivitypb.ListServiceConnectionPoliciesRequest, ...gax.CallOption) *ServiceConnectionPolicyIterator
	GetServiceConnectionPolicy(context.Context, *networkconnectivitypb.GetServiceConnectionPolicyRequest, ...gax.CallOption) (*networkconnectivitypb.ServiceConnectionPolicy, error)
	CreateServiceConnectionPolicy(context.Context, *networkconnectivitypb.CreateServiceConnectionPolicyRequest, ...gax.CallOption) (*CreateServiceConnectionPolicyOperation, error)
	CreateServiceConnectionPolicyOperation(name string) *CreateServiceConnectionPolicyOperation
	UpdateServiceConnectionPolicy(context.Context, *networkconnectivitypb.UpdateServiceConnectionPolicyRequest, ...gax.CallOption) (*UpdateServiceConnectionPolicyOperation, error)
	UpdateServiceConnectionPolicyOperation(name string) *UpdateServiceConnectionPolicyOperation
	DeleteServiceConnectionPolicy(context.Context, *networkconnectivitypb.DeleteServiceConnectionPolicyRequest, ...gax.CallOption) (*DeleteServiceConnectionPolicyOperation, error)
	DeleteServiceConnectionPolicyOperation(name string) *DeleteServiceConnectionPolicyOperation
	ListServiceClasses(context.Context, *networkconnectivitypb.ListServiceClassesRequest, ...gax.CallOption) *ServiceClassIterator
	GetServiceClass(context.Context, *networkconnectivitypb.GetServiceClassRequest, ...gax.CallOption) (*networkconnectivitypb.ServiceClass, error)
	UpdateServiceClass(context.Context, *networkconnectivitypb.UpdateServiceClassRequest, ...gax.CallOption) (*UpdateServiceClassOperation, error)
	UpdateServiceClassOperation(name string) *UpdateServiceClassOperation
	DeleteServiceClass(context.Context, *networkconnectivitypb.DeleteServiceClassRequest, ...gax.CallOption) (*DeleteServiceClassOperation, error)
	DeleteServiceClassOperation(name string) *DeleteServiceClassOperation
	GetServiceConnectionToken(context.Context, *networkconnectivitypb.GetServiceConnectionTokenRequest, ...gax.CallOption) (*networkconnectivitypb.ServiceConnectionToken, error)
	ListServiceConnectionTokens(context.Context, *networkconnectivitypb.ListServiceConnectionTokensRequest, ...gax.CallOption) *ServiceConnectionTokenIterator
	CreateServiceConnectionToken(context.Context, *networkconnectivitypb.CreateServiceConnectionTokenRequest, ...gax.CallOption) (*CreateServiceConnectionTokenOperation, error)
	CreateServiceConnectionTokenOperation(name string) *CreateServiceConnectionTokenOperation
	DeleteServiceConnectionToken(context.Context, *networkconnectivitypb.DeleteServiceConnectionTokenRequest, ...gax.CallOption) (*DeleteServiceConnectionTokenOperation, error)
	DeleteServiceConnectionTokenOperation(name string) *DeleteServiceConnectionTokenOperation
	GetLocation(context.Context, *locationpb.GetLocationRequest, ...gax.CallOption) (*locationpb.Location, error)
	ListLocations(context.Context, *locationpb.ListLocationsRequest, ...gax.CallOption) *LocationIterator
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest, ...gax.CallOption) (*iampb.Policy, error)
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest, ...gax.CallOption) (*iampb.Policy, error)
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest, ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error)
	CancelOperation(context.Context, *longrunningpb.CancelOperationRequest, ...gax.CallOption) error
	DeleteOperation(context.Context, *longrunningpb.DeleteOperationRequest, ...gax.CallOption) error
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
	ListOperations(context.Context, *longrunningpb.ListOperationsRequest, ...gax.CallOption) *OperationIterator
}

// CrossNetworkAutomationClient is a client for interacting with Network Connectivity API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// The service for CrossNetworkAutomation resources.
type CrossNetworkAutomationClient struct {
	// The internal transport-dependent client.
	internalClient internalCrossNetworkAutomationClient

	// The call options for this service.
	CallOptions *CrossNetworkAutomationCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *CrossNetworkAutomationClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *CrossNetworkAutomationClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *CrossNetworkAutomationClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListServiceConnectionMaps lists ServiceConnectionMaps in a given project and location.
func (c *CrossNetworkAutomationClient) ListServiceConnectionMaps(ctx context.Context, req *networkconnectivitypb.ListServiceConnectionMapsRequest, opts ...gax.CallOption) *ServiceConnectionMapIterator {
	return c.internalClient.ListServiceConnectionMaps(ctx, req, opts...)
}

// GetServiceConnectionMap gets details of a single ServiceConnectionMap.
func (c *CrossNetworkAutomationClient) GetServiceConnectionMap(ctx context.Context, req *networkconnectivitypb.GetServiceConnectionMapRequest, opts ...gax.CallOption) (*networkconnectivitypb.ServiceConnectionMap, error) {
	return c.internalClient.GetServiceConnectionMap(ctx, req, opts...)
}

// CreateServiceConnectionMap creates a new ServiceConnectionMap in a given project and location.
func (c *CrossNetworkAutomationClient) CreateServiceConnectionMap(ctx context.Context, req *networkconnectivitypb.CreateServiceConnectionMapRequest, opts ...gax.CallOption) (*CreateServiceConnectionMapOperation, error) {
	return c.internalClient.CreateServiceConnectionMap(ctx, req, opts...)
}

// CreateServiceConnectionMapOperation returns a new CreateServiceConnectionMapOperation from a given name.
// The name must be that of a previously created CreateServiceConnectionMapOperation, possibly from a different process.
func (c *CrossNetworkAutomationClient) CreateServiceConnectionMapOperation(name string) *CreateServiceConnectionMapOperation {
	return c.internalClient.CreateServiceConnectionMapOperation(name)
}

// UpdateServiceConnectionMap updates the parameters of a single ServiceConnectionMap.
func (c *CrossNetworkAutomationClient) UpdateServiceConnectionMap(ctx context.Context, req *networkconnectivitypb.UpdateServiceConnectionMapRequest, opts ...gax.CallOption) (*UpdateServiceConnectionMapOperation, error) {
	return c.internalClient.UpdateServiceConnectionMap(ctx, req, opts...)
}

// UpdateServiceConnectionMapOperation returns a new UpdateServiceConnectionMapOperation from a given name.
// The name must be that of a previously created UpdateServiceConnectionMapOperation, possibly from a different process.
func (c *CrossNetworkAutomationClient) UpdateServiceConnectionMapOperation(name string) *UpdateServiceConnectionMapOperation {
	return c.internalClient.UpdateServiceConnectionMapOperation(name)
}

// DeleteServiceConnectionMap deletes a single ServiceConnectionMap.
func (c *CrossNetworkAutomationClient) DeleteServiceConnectionMap(ctx context.Context, req *networkconnectivitypb.DeleteServiceConnectionMapRequest, opts ...gax.CallOption) (*DeleteServiceConnectionMapOperation, error) {
	return c.internalClient.DeleteServiceConnectionMap(ctx, req, opts...)
}

// DeleteServiceConnectionMapOperation returns a new DeleteServiceConnectionMapOperation from a given name.
// The name must be that of a previously created DeleteServiceConnectionMapOperation, possibly from a different process.
func (c *CrossNetworkAutomationClient) DeleteServiceConnectionMapOperation(name string) *DeleteServiceConnectionMapOperation {
	return c.internalClient.DeleteServiceConnectionMapOperation(name)
}

// ListServiceConnectionPolicies lists ServiceConnectionPolicies in a given project and location.
func (c *CrossNetworkAutomationClient) ListServiceConnectionPolicies(ctx context.Context, req *networkconnectivitypb.ListServiceConnectionPoliciesRequest, opts ...gax.CallOption) *ServiceConnectionPolicyIterator {
	return c.internalClient.ListServiceConnectionPolicies(ctx, req, opts...)
}

// GetServiceConnectionPolicy gets details of a single ServiceConnectionPolicy.
func (c *CrossNetworkAutomationClient) GetServiceConnectionPolicy(ctx context.Context, req *networkconnectivitypb.GetServiceConnectionPolicyRequest, opts ...gax.CallOption) (*networkconnectivitypb.ServiceConnectionPolicy, error) {
	return c.internalClient.GetServiceConnectionPolicy(ctx, req, opts...)
}

// CreateServiceConnectionPolicy creates a new ServiceConnectionPolicy in a given project and location.
func (c *CrossNetworkAutomationClient) CreateServiceConnectionPolicy(ctx context.Context, req *networkconnectivitypb.CreateServiceConnectionPolicyRequest, opts ...gax.CallOption) (*CreateServiceConnectionPolicyOperation, error) {
	return c.internalClient.CreateServiceConnectionPolicy(ctx, req, opts...)
}

// CreateServiceConnectionPolicyOperation returns a new CreateServiceConnectionPolicyOperation from a given name.
// The name must be that of a previously created CreateServiceConnectionPolicyOperation, possibly from a different process.
func (c *CrossNetworkAutomationClient) CreateServiceConnectionPolicyOperation(name string) *CreateServiceConnectionPolicyOperation {
	return c.internalClient.CreateServiceConnectionPolicyOperation(name)
}

// UpdateServiceConnectionPolicy updates the parameters of a single ServiceConnectionPolicy.
func (c *CrossNetworkAutomationClient) UpdateServiceConnectionPolicy(ctx context.Context, req *networkconnectivitypb.UpdateServiceConnectionPolicyRequest, opts ...gax.CallOption) (*UpdateServiceConnectionPolicyOperation, error) {
	return c.internalClient.UpdateServiceConnectionPolicy(ctx, req, opts...)
}

// UpdateServiceConnectionPolicyOperation returns a new UpdateServiceConnectionPolicyOperation from a given name.
// The name must be that of a previously created UpdateServiceConnectionPolicyOperation, possibly from a different process.
func (c *CrossNetworkAutomationClient) UpdateServiceConnectionPolicyOperation(name string) *UpdateServiceConnectionPolicyOperation {
	return c.internalClient.UpdateServiceConnectionPolicyOperation(name)
}

// DeleteServiceConnectionPolicy deletes a single ServiceConnectionPolicy.
func (c *CrossNetworkAutomationClient) DeleteServiceConnectionPolicy(ctx context.Context, req *networkconnectivitypb.DeleteServiceConnectionPolicyRequest, opts ...gax.CallOption) (*DeleteServiceConnectionPolicyOperation, error) {
	return c.internalClient.DeleteServiceConnectionPolicy(ctx, req, opts...)
}

// DeleteServiceConnectionPolicyOperation returns a new DeleteServiceConnectionPolicyOperation from a given name.
// The name must be that of a previously created DeleteServiceConnectionPolicyOperation, possibly from a different process.
func (c *CrossNetworkAutomationClient) DeleteServiceConnectionPolicyOperation(name string) *DeleteServiceConnectionPolicyOperation {
	return c.internalClient.DeleteServiceConnectionPolicyOperation(name)
}

// ListServiceClasses lists ServiceClasses in a given project and location.
func (c *CrossNetworkAutomationClient) ListServiceClasses(ctx context.Context, req *networkconnectivitypb.ListServiceClassesRequest, opts ...gax.CallOption) *ServiceClassIterator {
	return c.internalClient.ListServiceClasses(ctx, req, opts...)
}

// GetServiceClass gets details of a single ServiceClass.
func (c *CrossNetworkAutomationClient) GetServiceClass(ctx context.Context, req *networkconnectivitypb.GetServiceClassRequest, opts ...gax.CallOption) (*networkconnectivitypb.ServiceClass, error) {
	return c.internalClient.GetServiceClass(ctx, req, opts...)
}

// UpdateServiceClass updates the parameters of a single ServiceClass.
func (c *CrossNetworkAutomationClient) UpdateServiceClass(ctx context.Context, req *networkconnectivitypb.UpdateServiceClassRequest, opts ...gax.CallOption) (*UpdateServiceClassOperation, error) {
	return c.internalClient.UpdateServiceClass(ctx, req, opts...)
}

// UpdateServiceClassOperation returns a new UpdateServiceClassOperation from a given name.
// The name must be that of a previously created UpdateServiceClassOperation, possibly from a different process.
func (c *CrossNetworkAutomationClient) UpdateServiceClassOperation(name string) *UpdateServiceClassOperation {
	return c.internalClient.UpdateServiceClassOperation(name)
}

// DeleteServiceClass deletes a single ServiceClass.
func (c *CrossNetworkAutomationClient) DeleteServiceClass(ctx context.Context, req *networkconnectivitypb.DeleteServiceClassRequest, opts ...gax.CallOption) (*DeleteServiceClassOperation, error) {
	return c.internalClient.DeleteServiceClass(ctx, req, opts...)
}

// DeleteServiceClassOperation returns a new DeleteServiceClassOperation from a given name.
// The name must be that of a previously created DeleteServiceClassOperation, possibly from a different process.
func (c *CrossNetworkAutomationClient) DeleteServiceClassOperation(name string) *DeleteServiceClassOperation {
	return c.internalClient.DeleteServiceClassOperation(name)
}

// GetServiceConnectionToken gets details of a single ServiceConnectionToken.
func (c *CrossNetworkAutomationClient) GetServiceConnectionToken(ctx context.Context, req *networkconnectivitypb.GetServiceConnectionTokenRequest, opts ...gax.CallOption) (*networkconnectivitypb.ServiceConnectionToken, error) {
	return c.internalClient.GetServiceConnectionToken(ctx, req, opts...)
}

// ListServiceConnectionTokens lists ServiceConnectionTokens in a given project and location.
func (c *CrossNetworkAutomationClient) ListServiceConnectionTokens(ctx context.Context, req *networkconnectivitypb.ListServiceConnectionTokensRequest, opts ...gax.CallOption) *ServiceConnectionTokenIterator {
	return c.internalClient.ListServiceConnectionTokens(ctx, req, opts...)
}

// CreateServiceConnectionToken creates a new ServiceConnectionToken in a given project and location.
func (c *CrossNetworkAutomationClient) CreateServiceConnectionToken(ctx context.Context, req *networkconnectivitypb.CreateServiceConnectionTokenRequest, opts ...gax.CallOption) (*CreateServiceConnectionTokenOperation, error) {
	return c.internalClient.CreateServiceConnectionToken(ctx, req, opts...)
}

// CreateServiceConnectionTokenOperation returns a new CreateServiceConnectionTokenOperation from a given name.
// The name must be that of a previously created CreateServiceConnectionTokenOperation, possibly from a different process.
func (c *CrossNetworkAutomationClient) CreateServiceConnectionTokenOperation(name string) *CreateServiceConnectionTokenOperation {
	return c.internalClient.CreateServiceConnectionTokenOperation(name)
}

// DeleteServiceConnectionToken deletes a single ServiceConnectionToken.
func (c *CrossNetworkAutomationClient) DeleteServiceConnectionToken(ctx context.Context, req *networkconnectivitypb.DeleteServiceConnectionTokenRequest, opts ...gax.CallOption) (*DeleteServiceConnectionTokenOperation, error) {
	return c.internalClient.DeleteServiceConnectionToken(ctx, req, opts...)
}

// DeleteServiceConnectionTokenOperation returns a new DeleteServiceConnectionTokenOperation from a given name.
// The name must be that of a previously created DeleteServiceConnectionTokenOperation, possibly from a different process.
func (c *CrossNetworkAutomationClient) DeleteServiceConnectionTokenOperation(name string) *DeleteServiceConnectionTokenOperation {
	return c.internalClient.DeleteServiceConnectionTokenOperation(name)
}

// GetLocation gets information about a location.
func (c *CrossNetworkAutomationClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	return c.internalClient.GetLocation(ctx, req, opts...)
}

// ListLocations lists information about the supported locations for this service.
func (c *CrossNetworkAutomationClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	return c.internalClient.ListLocations(ctx, req, opts...)
}

// GetIamPolicy gets the access control policy for a resource. Returns an empty policy
// if the resource exists and does not have a policy set.
func (c *CrossNetworkAutomationClient) GetIamPolicy(ctx context.Context, req *iampb.GetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	return c.internalClient.GetIamPolicy(ctx, req, opts...)
}

// SetIamPolicy sets the access control policy on the specified resource. Replaces
// any existing policy.
//
// Can return NOT_FOUND, INVALID_ARGUMENT, and PERMISSION_DENIED
// errors.
func (c *CrossNetworkAutomationClient) SetIamPolicy(ctx context.Context, req *iampb.SetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	return c.internalClient.SetIamPolicy(ctx, req, opts...)
}

// TestIamPermissions returns permissions that a caller has on the specified resource. If the
// resource does not exist, this will return an empty set of
// permissions, not a NOT_FOUND error.
//
// Note: This operation is designed to be used for building
// permission-aware UIs and command-line tools, not for authorization
// checking. This operation may “fail open” without warning.
func (c *CrossNetworkAutomationClient) TestIamPermissions(ctx context.Context, req *iampb.TestIamPermissionsRequest, opts ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	return c.internalClient.TestIamPermissions(ctx, req, opts...)
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *CrossNetworkAutomationClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.CancelOperation(ctx, req, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *CrossNetworkAutomationClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteOperation(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *CrossNetworkAutomationClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *CrossNetworkAutomationClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	return c.internalClient.ListOperations(ctx, req, opts...)
}

// crossNetworkAutomationGRPCClient is a client for interacting with Network Connectivity API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type crossNetworkAutomationGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing CrossNetworkAutomationClient
	CallOptions **CrossNetworkAutomationCallOptions

	// The gRPC API client.
	crossNetworkAutomationClient networkconnectivitypb.CrossNetworkAutomationServiceClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	iamPolicyClient iampb.IAMPolicyClient

	locationsClient locationpb.LocationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewCrossNetworkAutomationClient creates a new cross network automation service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// The service for CrossNetworkAutomation resources.
func NewCrossNetworkAutomationClient(ctx context.Context, opts ...option.ClientOption) (*CrossNetworkAutomationClient, error) {
	clientOpts := defaultCrossNetworkAutomationGRPCClientOptions()
	if newCrossNetworkAutomationClientHook != nil {
		hookOpts, err := newCrossNetworkAutomationClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := CrossNetworkAutomationClient{CallOptions: defaultCrossNetworkAutomationCallOptions()}

	c := &crossNetworkAutomationGRPCClient{
		connPool:                     connPool,
		crossNetworkAutomationClient: networkconnectivitypb.NewCrossNetworkAutomationServiceClient(connPool),
		CallOptions:                  &client.CallOptions,
		logger:                       internaloption.GetLogger(opts),
		operationsClient:             longrunningpb.NewOperationsClient(connPool),
		iamPolicyClient:              iampb.NewIAMPolicyClient(connPool),
		locationsClient:              locationpb.NewLocationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *crossNetworkAutomationGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *crossNetworkAutomationGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *crossNetworkAutomationGRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *crossNetworkAutomationGRPCClient) ListServiceConnectionMaps(ctx context.Context, req *networkconnectivitypb.ListServiceConnectionMapsRequest, opts ...gax.CallOption) *ServiceConnectionMapIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListServiceConnectionMaps[0:len((*c.CallOptions).ListServiceConnectionMaps):len((*c.CallOptions).ListServiceConnectionMaps)], opts...)
	it := &ServiceConnectionMapIterator{}
	req = proto.Clone(req).(*networkconnectivitypb.ListServiceConnectionMapsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networkconnectivitypb.ServiceConnectionMap, string, error) {
		resp := &networkconnectivitypb.ListServiceConnectionMapsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.crossNetworkAutomationClient.ListServiceConnectionMaps, req, settings.GRPC, c.logger, "ListServiceConnectionMaps")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetServiceConnectionMaps(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *crossNetworkAutomationGRPCClient) GetServiceConnectionMap(ctx context.Context, req *networkconnectivitypb.GetServiceConnectionMapRequest, opts ...gax.CallOption) (*networkconnectivitypb.ServiceConnectionMap, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetServiceConnectionMap[0:len((*c.CallOptions).GetServiceConnectionMap):len((*c.CallOptions).GetServiceConnectionMap)], opts...)
	var resp *networkconnectivitypb.ServiceConnectionMap
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.crossNetworkAutomationClient.GetServiceConnectionMap, req, settings.GRPC, c.logger, "GetServiceConnectionMap")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *crossNetworkAutomationGRPCClient) CreateServiceConnectionMap(ctx context.Context, req *networkconnectivitypb.CreateServiceConnectionMapRequest, opts ...gax.CallOption) (*CreateServiceConnectionMapOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateServiceConnectionMap[0:len((*c.CallOptions).CreateServiceConnectionMap):len((*c.CallOptions).CreateServiceConnectionMap)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.crossNetworkAutomationClient.CreateServiceConnectionMap, req, settings.GRPC, c.logger, "CreateServiceConnectionMap")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateServiceConnectionMapOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *crossNetworkAutomationGRPCClient) UpdateServiceConnectionMap(ctx context.Context, req *networkconnectivitypb.UpdateServiceConnectionMapRequest, opts ...gax.CallOption) (*UpdateServiceConnectionMapOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "service_connection_map.name", url.QueryEscape(req.GetServiceConnectionMap().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateServiceConnectionMap[0:len((*c.CallOptions).UpdateServiceConnectionMap):len((*c.CallOptions).UpdateServiceConnectionMap)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.crossNetworkAutomationClient.UpdateServiceConnectionMap, req, settings.GRPC, c.logger, "UpdateServiceConnectionMap")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateServiceConnectionMapOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *crossNetworkAutomationGRPCClient) DeleteServiceConnectionMap(ctx context.Context, req *networkconnectivitypb.DeleteServiceConnectionMapRequest, opts ...gax.CallOption) (*DeleteServiceConnectionMapOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteServiceConnectionMap[0:len((*c.CallOptions).DeleteServiceConnectionMap):len((*c.CallOptions).DeleteServiceConnectionMap)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.crossNetworkAutomationClient.DeleteServiceConnectionMap, req, settings.GRPC, c.logger, "DeleteServiceConnectionMap")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteServiceConnectionMapOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *crossNetworkAutomationGRPCClient) ListServiceConnectionPolicies(ctx context.Context, req *networkconnectivitypb.ListServiceConnectionPoliciesRequest, opts ...gax.CallOption) *ServiceConnectionPolicyIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListServiceConnectionPolicies[0:len((*c.CallOptions).ListServiceConnectionPolicies):len((*c.CallOptions).ListServiceConnectionPolicies)], opts...)
	it := &ServiceConnectionPolicyIterator{}
	req = proto.Clone(req).(*networkconnectivitypb.ListServiceConnectionPoliciesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networkconnectivitypb.ServiceConnectionPolicy, string, error) {
		resp := &networkconnectivitypb.ListServiceConnectionPoliciesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.crossNetworkAutomationClient.ListServiceConnectionPolicies, req, settings.GRPC, c.logger, "ListServiceConnectionPolicies")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetServiceConnectionPolicies(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *crossNetworkAutomationGRPCClient) GetServiceConnectionPolicy(ctx context.Context, req *networkconnectivitypb.GetServiceConnectionPolicyRequest, opts ...gax.CallOption) (*networkconnectivitypb.ServiceConnectionPolicy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetServiceConnectionPolicy[0:len((*c.CallOptions).GetServiceConnectionPolicy):len((*c.CallOptions).GetServiceConnectionPolicy)], opts...)
	var resp *networkconnectivitypb.ServiceConnectionPolicy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.crossNetworkAutomationClient.GetServiceConnectionPolicy, req, settings.GRPC, c.logger, "GetServiceConnectionPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *crossNetworkAutomationGRPCClient) CreateServiceConnectionPolicy(ctx context.Context, req *networkconnectivitypb.CreateServiceConnectionPolicyRequest, opts ...gax.CallOption) (*CreateServiceConnectionPolicyOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateServiceConnectionPolicy[0:len((*c.CallOptions).CreateServiceConnectionPolicy):len((*c.CallOptions).CreateServiceConnectionPolicy)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.crossNetworkAutomationClient.CreateServiceConnectionPolicy, req, settings.GRPC, c.logger, "CreateServiceConnectionPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateServiceConnectionPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *crossNetworkAutomationGRPCClient) UpdateServiceConnectionPolicy(ctx context.Context, req *networkconnectivitypb.UpdateServiceConnectionPolicyRequest, opts ...gax.CallOption) (*UpdateServiceConnectionPolicyOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "service_connection_policy.name", url.QueryEscape(req.GetServiceConnectionPolicy().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateServiceConnectionPolicy[0:len((*c.CallOptions).UpdateServiceConnectionPolicy):len((*c.CallOptions).UpdateServiceConnectionPolicy)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.crossNetworkAutomationClient.UpdateServiceConnectionPolicy, req, settings.GRPC, c.logger, "UpdateServiceConnectionPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateServiceConnectionPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *crossNetworkAutomationGRPCClient) DeleteServiceConnectionPolicy(ctx context.Context, req *networkconnectivitypb.DeleteServiceConnectionPolicyRequest, opts ...gax.CallOption) (*DeleteServiceConnectionPolicyOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteServiceConnectionPolicy[0:len((*c.CallOptions).DeleteServiceConnectionPolicy):len((*c.CallOptions).DeleteServiceConnectionPolicy)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.crossNetworkAutomationClient.DeleteServiceConnectionPolicy, req, settings.GRPC, c.logger, "DeleteServiceConnectionPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteServiceConnectionPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *crossNetworkAutomationGRPCClient) ListServiceClasses(ctx context.Context, req *networkconnectivitypb.ListServiceClassesRequest, opts ...gax.CallOption) *ServiceClassIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListServiceClasses[0:len((*c.CallOptions).ListServiceClasses):len((*c.CallOptions).ListServiceClasses)], opts...)
	it := &ServiceClassIterator{}
	req = proto.Clone(req).(*networkconnectivitypb.ListServiceClassesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networkconnectivitypb.ServiceClass, string, error) {
		resp := &networkconnectivitypb.ListServiceClassesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.crossNetworkAutomationClient.ListServiceClasses, req, settings.GRPC, c.logger, "ListServiceClasses")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetServiceClasses(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *crossNetworkAutomationGRPCClient) GetServiceClass(ctx context.Context, req *networkconnectivitypb.GetServiceClassRequest, opts ...gax.CallOption) (*networkconnectivitypb.ServiceClass, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetServiceClass[0:len((*c.CallOptions).GetServiceClass):len((*c.CallOptions).GetServiceClass)], opts...)
	var resp *networkconnectivitypb.ServiceClass
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.crossNetworkAutomationClient.GetServiceClass, req, settings.GRPC, c.logger, "GetServiceClass")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *crossNetworkAutomationGRPCClient) UpdateServiceClass(ctx context.Context, req *networkconnectivitypb.UpdateServiceClassRequest, opts ...gax.CallOption) (*UpdateServiceClassOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "service_class.name", url.QueryEscape(req.GetServiceClass().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateServiceClass[0:len((*c.CallOptions).UpdateServiceClass):len((*c.CallOptions).UpdateServiceClass)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.crossNetworkAutomationClient.UpdateServiceClass, req, settings.GRPC, c.logger, "UpdateServiceClass")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateServiceClassOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *crossNetworkAutomationGRPCClient) DeleteServiceClass(ctx context.Context, req *networkconnectivitypb.DeleteServiceClassRequest, opts ...gax.CallOption) (*DeleteServiceClassOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteServiceClass[0:len((*c.CallOptions).DeleteServiceClass):len((*c.CallOptions).DeleteServiceClass)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.crossNetworkAutomationClient.DeleteServiceClass, req, settings.GRPC, c.logger, "DeleteServiceClass")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteServiceClassOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *crossNetworkAutomationGRPCClient) GetServiceConnectionToken(ctx context.Context, req *networkconnectivitypb.GetServiceConnectionTokenRequest, opts ...gax.CallOption) (*networkconnectivitypb.ServiceConnectionToken, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetServiceConnectionToken[0:len((*c.CallOptions).GetServiceConnectionToken):len((*c.CallOptions).GetServiceConnectionToken)], opts...)
	var resp *networkconnectivitypb.ServiceConnectionToken
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.crossNetworkAutomationClient.GetServiceConnectionToken, req, settings.GRPC, c.logger, "GetServiceConnectionToken")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *crossNetworkAutomationGRPCClient) ListServiceConnectionTokens(ctx context.Context, req *networkconnectivitypb.ListServiceConnectionTokensRequest, opts ...gax.CallOption) *ServiceConnectionTokenIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListServiceConnectionTokens[0:len((*c.CallOptions).ListServiceConnectionTokens):len((*c.CallOptions).ListServiceConnectionTokens)], opts...)
	it := &ServiceConnectionTokenIterator{}
	req = proto.Clone(req).(*networkconnectivitypb.ListServiceConnectionTokensRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networkconnectivitypb.ServiceConnectionToken, string, error) {
		resp := &networkconnectivitypb.ListServiceConnectionTokensResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.crossNetworkAutomationClient.ListServiceConnectionTokens, req, settings.GRPC, c.logger, "ListServiceConnectionTokens")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetServiceConnectionTokens(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *crossNetworkAutomationGRPCClient) CreateServiceConnectionToken(ctx context.Context, req *networkconnectivitypb.CreateServiceConnectionTokenRequest, opts ...gax.CallOption) (*CreateServiceConnectionTokenOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateServiceConnectionToken[0:len((*c.CallOptions).CreateServiceConnectionToken):len((*c.CallOptions).CreateServiceConnectionToken)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.crossNetworkAutomationClient.CreateServiceConnectionToken, req, settings.GRPC, c.logger, "CreateServiceConnectionToken")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateServiceConnectionTokenOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *crossNetworkAutomationGRPCClient) DeleteServiceConnectionToken(ctx context.Context, req *networkconnectivitypb.DeleteServiceConnectionTokenRequest, opts ...gax.CallOption) (*DeleteServiceConnectionTokenOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteServiceConnectionToken[0:len((*c.CallOptions).DeleteServiceConnectionToken):len((*c.CallOptions).DeleteServiceConnectionToken)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.crossNetworkAutomationClient.DeleteServiceConnectionToken, req, settings.GRPC, c.logger, "DeleteServiceConnectionToken")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteServiceConnectionTokenOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *crossNetworkAutomationGRPCClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	var resp *locationpb.Location
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.locationsClient.GetLocation, req, settings.GRPC, c.logger, "GetLocation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *crossNetworkAutomationGRPCClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListLocations[0:len((*c.CallOptions).ListLocations):len((*c.CallOptions).ListLocations)], opts...)
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.locationsClient.ListLocations, req, settings.GRPC, c.logger, "ListLocations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *crossNetworkAutomationGRPCClient) GetIamPolicy(ctx context.Context, req *iampb.GetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetIamPolicy[0:len((*c.CallOptions).GetIamPolicy):len((*c.CallOptions).GetIamPolicy)], opts...)
	var resp *iampb.Policy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamPolicyClient.GetIamPolicy, req, settings.GRPC, c.logger, "GetIamPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *crossNetworkAutomationGRPCClient) SetIamPolicy(ctx context.Context, req *iampb.SetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SetIamPolicy[0:len((*c.CallOptions).SetIamPolicy):len((*c.CallOptions).SetIamPolicy)], opts...)
	var resp *iampb.Policy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamPolicyClient.SetIamPolicy, req, settings.GRPC, c.logger, "SetIamPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *crossNetworkAutomationGRPCClient) TestIamPermissions(ctx context.Context, req *iampb.TestIamPermissionsRequest, opts ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).TestIamPermissions[0:len((*c.CallOptions).TestIamPermissions):len((*c.CallOptions).TestIamPermissions)], opts...)
	var resp *iampb.TestIamPermissionsResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamPolicyClient.TestIamPermissions, req, settings.GRPC, c.logger, "TestIamPermissions")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *crossNetworkAutomationGRPCClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CancelOperation[0:len((*c.CallOptions).CancelOperation):len((*c.CallOptions).CancelOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.CancelOperation, req, settings.GRPC, c.logger, "CancelOperation")
		return err
	}, opts...)
	return err
}

func (c *crossNetworkAutomationGRPCClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteOperation[0:len((*c.CallOptions).DeleteOperation):len((*c.CallOptions).DeleteOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.DeleteOperation, req, settings.GRPC, c.logger, "DeleteOperation")
		return err
	}, opts...)
	return err
}

func (c *crossNetworkAutomationGRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.operationsClient.GetOperation, req, settings.GRPC, c.logger, "GetOperation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *crossNetworkAutomationGRPCClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListOperations[0:len((*c.CallOptions).ListOperations):len((*c.CallOptions).ListOperations)], opts...)
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.operationsClient.ListOperations, req, settings.GRPC, c.logger, "ListOperations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateServiceConnectionMapOperation returns a new CreateServiceConnectionMapOperation from a given name.
// The name must be that of a previously created CreateServiceConnectionMapOperation, possibly from a different process.
func (c *crossNetworkAutomationGRPCClient) CreateServiceConnectionMapOperation(name string) *CreateServiceConnectionMapOperation {
	return &CreateServiceConnectionMapOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateServiceConnectionPolicyOperation returns a new CreateServiceConnectionPolicyOperation from a given name.
// The name must be that of a previously created CreateServiceConnectionPolicyOperation, possibly from a different process.
func (c *crossNetworkAutomationGRPCClient) CreateServiceConnectionPolicyOperation(name string) *CreateServiceConnectionPolicyOperation {
	return &CreateServiceConnectionPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateServiceConnectionTokenOperation returns a new CreateServiceConnectionTokenOperation from a given name.
// The name must be that of a previously created CreateServiceConnectionTokenOperation, possibly from a different process.
func (c *crossNetworkAutomationGRPCClient) CreateServiceConnectionTokenOperation(name string) *CreateServiceConnectionTokenOperation {
	return &CreateServiceConnectionTokenOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteServiceClassOperation returns a new DeleteServiceClassOperation from a given name.
// The name must be that of a previously created DeleteServiceClassOperation, possibly from a different process.
func (c *crossNetworkAutomationGRPCClient) DeleteServiceClassOperation(name string) *DeleteServiceClassOperation {
	return &DeleteServiceClassOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteServiceConnectionMapOperation returns a new DeleteServiceConnectionMapOperation from a given name.
// The name must be that of a previously created DeleteServiceConnectionMapOperation, possibly from a different process.
func (c *crossNetworkAutomationGRPCClient) DeleteServiceConnectionMapOperation(name string) *DeleteServiceConnectionMapOperation {
	return &DeleteServiceConnectionMapOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteServiceConnectionPolicyOperation returns a new DeleteServiceConnectionPolicyOperation from a given name.
// The name must be that of a previously created DeleteServiceConnectionPolicyOperation, possibly from a different process.
func (c *crossNetworkAutomationGRPCClient) DeleteServiceConnectionPolicyOperation(name string) *DeleteServiceConnectionPolicyOperation {
	return &DeleteServiceConnectionPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteServiceConnectionTokenOperation returns a new DeleteServiceConnectionTokenOperation from a given name.
// The name must be that of a previously created DeleteServiceConnectionTokenOperation, possibly from a different process.
func (c *crossNetworkAutomationGRPCClient) DeleteServiceConnectionTokenOperation(name string) *DeleteServiceConnectionTokenOperation {
	return &DeleteServiceConnectionTokenOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateServiceClassOperation returns a new UpdateServiceClassOperation from a given name.
// The name must be that of a previously created UpdateServiceClassOperation, possibly from a different process.
func (c *crossNetworkAutomationGRPCClient) UpdateServiceClassOperation(name string) *UpdateServiceClassOperation {
	return &UpdateServiceClassOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateServiceConnectionMapOperation returns a new UpdateServiceConnectionMapOperation from a given name.
// The name must be that of a previously created UpdateServiceConnectionMapOperation, possibly from a different process.
func (c *crossNetworkAutomationGRPCClient) UpdateServiceConnectionMapOperation(name string) *UpdateServiceConnectionMapOperation {
	return &UpdateServiceConnectionMapOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateServiceConnectionPolicyOperation returns a new UpdateServiceConnectionPolicyOperation from a given name.
// The name must be that of a previously created UpdateServiceConnectionPolicyOperation, possibly from a different process.
func (c *crossNetworkAutomationGRPCClient) UpdateServiceConnectionPolicyOperation(name string) *UpdateServiceConnectionPolicyOperation {
	return &UpdateServiceConnectionPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}
