// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/networkconnectivity/v1/cross_network_automation.proto

package networkconnectivitypb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	errdetails "google.golang.org/genproto/googleapis/rpc/errdetails"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The infrastructure used for connections between consumers/producers.
type Infrastructure int32

const (
	// An invalid infrastructure as the default case.
	Infrastructure_INFRASTRUCTURE_UNSPECIFIED Infrastructure = 0
	// Private Service Connect is used for connections.
	Infrastructure_PSC Infrastructure = 1
)

// Enum value maps for Infrastructure.
var (
	Infrastructure_name = map[int32]string{
		0: "INFRASTRUCTURE_UNSPECIFIED",
		1: "PSC",
	}
	Infrastructure_value = map[string]int32{
		"INFRASTRUCTURE_UNSPECIFIED": 0,
		"PSC":                        1,
	}
)

func (x Infrastructure) Enum() *Infrastructure {
	p := new(Infrastructure)
	*p = x
	return p
}

func (x Infrastructure) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Infrastructure) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_enumTypes[0].Descriptor()
}

func (Infrastructure) Type() protoreflect.EnumType {
	return &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_enumTypes[0]
}

func (x Infrastructure) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Infrastructure.Descriptor instead.
func (Infrastructure) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{0}
}

// The error type indicates whether a connection error is consumer facing,
// producer facing or system internal.
type ConnectionErrorType int32

const (
	// An invalid error type as the default case.
	ConnectionErrorType_CONNECTION_ERROR_TYPE_UNSPECIFIED ConnectionErrorType = 0
	// The error is due to Service Automation system internal.
	ConnectionErrorType_ERROR_INTERNAL ConnectionErrorType = 1
	// The error is due to the setup on consumer side.
	ConnectionErrorType_ERROR_CONSUMER_SIDE ConnectionErrorType = 2
	// The error is due to the setup on producer side.
	ConnectionErrorType_ERROR_PRODUCER_SIDE ConnectionErrorType = 3
)

// Enum value maps for ConnectionErrorType.
var (
	ConnectionErrorType_name = map[int32]string{
		0: "CONNECTION_ERROR_TYPE_UNSPECIFIED",
		1: "ERROR_INTERNAL",
		2: "ERROR_CONSUMER_SIDE",
		3: "ERROR_PRODUCER_SIDE",
	}
	ConnectionErrorType_value = map[string]int32{
		"CONNECTION_ERROR_TYPE_UNSPECIFIED": 0,
		"ERROR_INTERNAL":                    1,
		"ERROR_CONSUMER_SIDE":               2,
		"ERROR_PRODUCER_SIDE":               3,
	}
)

func (x ConnectionErrorType) Enum() *ConnectionErrorType {
	p := new(ConnectionErrorType)
	*p = x
	return p
}

func (x ConnectionErrorType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConnectionErrorType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_enumTypes[1].Descriptor()
}

func (ConnectionErrorType) Type() protoreflect.EnumType {
	return &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_enumTypes[1]
}

func (x ConnectionErrorType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConnectionErrorType.Descriptor instead.
func (ConnectionErrorType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{1}
}

// The requested IP version for the PSC connection.
type IPVersion int32

const (
	// Default value. We will use IPv4 or IPv6 depending on the IP version of
	// first available subnetwork.
	IPVersion_IP_VERSION_UNSPECIFIED IPVersion = 0
	// Will use IPv4 only.
	IPVersion_IPV4 IPVersion = 1
	// Will use IPv6 only.
	IPVersion_IPV6 IPVersion = 2
)

// Enum value maps for IPVersion.
var (
	IPVersion_name = map[int32]string{
		0: "IP_VERSION_UNSPECIFIED",
		1: "IPV4",
		2: "IPV6",
	}
	IPVersion_value = map[string]int32{
		"IP_VERSION_UNSPECIFIED": 0,
		"IPV4":                   1,
		"IPV6":                   2,
	}
)

func (x IPVersion) Enum() *IPVersion {
	p := new(IPVersion)
	*p = x
	return p
}

func (x IPVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IPVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_enumTypes[2].Descriptor()
}

func (IPVersion) Type() protoreflect.EnumType {
	return &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_enumTypes[2]
}

func (x IPVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IPVersion.Descriptor instead.
func (IPVersion) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{2}
}

// PSC Consumer Config State.
type ServiceConnectionMap_ConsumerPscConfig_State int32

const (
	// Default state, when Connection Map is created initially.
	ServiceConnectionMap_ConsumerPscConfig_STATE_UNSPECIFIED ServiceConnectionMap_ConsumerPscConfig_State = 0
	// Set when policy and map configuration is valid,
	// and their matching can lead to allowing creation of PSC Connections
	// subject to other constraints like connections limit.
	ServiceConnectionMap_ConsumerPscConfig_VALID ServiceConnectionMap_ConsumerPscConfig_State = 1
	// No Service Connection Policy found for this network and Service
	// Class
	ServiceConnectionMap_ConsumerPscConfig_CONNECTION_POLICY_MISSING ServiceConnectionMap_ConsumerPscConfig_State = 2
	// Service Connection Policy limit reached for this network and Service
	// Class
	ServiceConnectionMap_ConsumerPscConfig_POLICY_LIMIT_REACHED ServiceConnectionMap_ConsumerPscConfig_State = 3
	// The consumer instance project is not in
	// AllowedGoogleProducersResourceHierarchyLevels of the matching
	// ServiceConnectionPolicy.
	ServiceConnectionMap_ConsumerPscConfig_CONSUMER_INSTANCE_PROJECT_NOT_ALLOWLISTED ServiceConnectionMap_ConsumerPscConfig_State = 4
)

// Enum value maps for ServiceConnectionMap_ConsumerPscConfig_State.
var (
	ServiceConnectionMap_ConsumerPscConfig_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "VALID",
		2: "CONNECTION_POLICY_MISSING",
		3: "POLICY_LIMIT_REACHED",
		4: "CONSUMER_INSTANCE_PROJECT_NOT_ALLOWLISTED",
	}
	ServiceConnectionMap_ConsumerPscConfig_State_value = map[string]int32{
		"STATE_UNSPECIFIED":         0,
		"VALID":                     1,
		"CONNECTION_POLICY_MISSING": 2,
		"POLICY_LIMIT_REACHED":      3,
		"CONSUMER_INSTANCE_PROJECT_NOT_ALLOWLISTED": 4,
	}
)

func (x ServiceConnectionMap_ConsumerPscConfig_State) Enum() *ServiceConnectionMap_ConsumerPscConfig_State {
	p := new(ServiceConnectionMap_ConsumerPscConfig_State)
	*p = x
	return p
}

func (x ServiceConnectionMap_ConsumerPscConfig_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServiceConnectionMap_ConsumerPscConfig_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_enumTypes[3].Descriptor()
}

func (ServiceConnectionMap_ConsumerPscConfig_State) Type() protoreflect.EnumType {
	return &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_enumTypes[3]
}

func (x ServiceConnectionMap_ConsumerPscConfig_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServiceConnectionMap_ConsumerPscConfig_State.Descriptor instead.
func (ServiceConnectionMap_ConsumerPscConfig_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{0, 1, 0}
}

// The state of the PSC connection.
// We reserve the right to add more states without notice in the future.
// Users should not use exhaustive switch statements on this enum.
// See https://google.aip.dev/216.
type ServiceConnectionMap_ConsumerPscConnection_State int32

const (
	// An invalid state as the default case.
	ServiceConnectionMap_ConsumerPscConnection_STATE_UNSPECIFIED ServiceConnectionMap_ConsumerPscConnection_State = 0
	// The connection has been created successfully. However, for the
	// up-to-date connection status, please use the service attachment's
	// "ConnectedEndpoint.status" as the source of truth.
	ServiceConnectionMap_ConsumerPscConnection_ACTIVE ServiceConnectionMap_ConsumerPscConnection_State = 1
	// The connection is not functional since some resources on the connection
	// fail to be created.
	ServiceConnectionMap_ConsumerPscConnection_FAILED ServiceConnectionMap_ConsumerPscConnection_State = 2
	// The connection is being created.
	ServiceConnectionMap_ConsumerPscConnection_CREATING ServiceConnectionMap_ConsumerPscConnection_State = 3
	// The connection is being deleted.
	ServiceConnectionMap_ConsumerPscConnection_DELETING ServiceConnectionMap_ConsumerPscConnection_State = 4
	// The connection is being repaired to complete creation.
	ServiceConnectionMap_ConsumerPscConnection_CREATE_REPAIRING ServiceConnectionMap_ConsumerPscConnection_State = 5
	// The connection is being repaired to complete deletion.
	ServiceConnectionMap_ConsumerPscConnection_DELETE_REPAIRING ServiceConnectionMap_ConsumerPscConnection_State = 6
)

// Enum value maps for ServiceConnectionMap_ConsumerPscConnection_State.
var (
	ServiceConnectionMap_ConsumerPscConnection_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "FAILED",
		3: "CREATING",
		4: "DELETING",
		5: "CREATE_REPAIRING",
		6: "DELETE_REPAIRING",
	}
	ServiceConnectionMap_ConsumerPscConnection_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"FAILED":            2,
		"CREATING":          3,
		"DELETING":          4,
		"CREATE_REPAIRING":  5,
		"DELETE_REPAIRING":  6,
	}
)

func (x ServiceConnectionMap_ConsumerPscConnection_State) Enum() *ServiceConnectionMap_ConsumerPscConnection_State {
	p := new(ServiceConnectionMap_ConsumerPscConnection_State)
	*p = x
	return p
}

func (x ServiceConnectionMap_ConsumerPscConnection_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServiceConnectionMap_ConsumerPscConnection_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_enumTypes[4].Descriptor()
}

func (ServiceConnectionMap_ConsumerPscConnection_State) Type() protoreflect.EnumType {
	return &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_enumTypes[4]
}

func (x ServiceConnectionMap_ConsumerPscConnection_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServiceConnectionMap_ConsumerPscConnection_State.Descriptor instead.
func (ServiceConnectionMap_ConsumerPscConnection_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{0, 2, 0}
}

// The state of the PSC connection.
// We reserve the right to add more states without notice in the future.
// Users should not use exhaustive switch statements on this enum.
// See https://google.aip.dev/216.
type ServiceConnectionPolicy_State int32

const (
	// An invalid state as the default case.
	ServiceConnectionPolicy_STATE_UNSPECIFIED ServiceConnectionPolicy_State = 0
	// The connection has been created successfully. However, for the
	// up-to-date connection status, please use the created forwarding rule's
	// "PscConnectionStatus" as the source of truth.
	ServiceConnectionPolicy_ACTIVE ServiceConnectionPolicy_State = 1
	// The connection is not functional since some resources on the connection
	// fail to be created.
	ServiceConnectionPolicy_FAILED ServiceConnectionPolicy_State = 2
	// The connection is being created.
	ServiceConnectionPolicy_CREATING ServiceConnectionPolicy_State = 3
	// The connection is being deleted.
	ServiceConnectionPolicy_DELETING ServiceConnectionPolicy_State = 4
	// The connection is being repaired to complete creation.
	ServiceConnectionPolicy_CREATE_REPAIRING ServiceConnectionPolicy_State = 5
	// The connection is being repaired to complete deletion.
	ServiceConnectionPolicy_DELETE_REPAIRING ServiceConnectionPolicy_State = 6
)

// Enum value maps for ServiceConnectionPolicy_State.
var (
	ServiceConnectionPolicy_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "FAILED",
		3: "CREATING",
		4: "DELETING",
		5: "CREATE_REPAIRING",
		6: "DELETE_REPAIRING",
	}
	ServiceConnectionPolicy_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"FAILED":            2,
		"CREATING":          3,
		"DELETING":          4,
		"CREATE_REPAIRING":  5,
		"DELETE_REPAIRING":  6,
	}
)

func (x ServiceConnectionPolicy_State) Enum() *ServiceConnectionPolicy_State {
	p := new(ServiceConnectionPolicy_State)
	*p = x
	return p
}

func (x ServiceConnectionPolicy_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServiceConnectionPolicy_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_enumTypes[5].Descriptor()
}

func (ServiceConnectionPolicy_State) Type() protoreflect.EnumType {
	return &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_enumTypes[5]
}

func (x ServiceConnectionPolicy_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServiceConnectionPolicy_State.Descriptor instead.
func (ServiceConnectionPolicy_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{7, 0}
}

// ProducerInstanceLocation is used to specify which authorization mechanism
// to use to determine which projects the Producer instance can be within.
type ServiceConnectionPolicy_PscConfig_ProducerInstanceLocation int32

const (
	// Producer instance location is not specified. When this option is
	// chosen, then the PSC connections created by this
	// ServiceConnectionPolicy must be within the same project as the Producer
	// instance. This is the default ProducerInstanceLocation value.
	// To allow for PSC connections from this network to other networks, use
	// the CUSTOM_RESOURCE_HIERARCHY_LEVELS option.
	ServiceConnectionPolicy_PscConfig_PRODUCER_INSTANCE_LOCATION_UNSPECIFIED ServiceConnectionPolicy_PscConfig_ProducerInstanceLocation = 0
	// Producer instance must be within one of the values provided in
	// allowed_google_producers_resource_hierarchy_level.
	ServiceConnectionPolicy_PscConfig_CUSTOM_RESOURCE_HIERARCHY_LEVELS ServiceConnectionPolicy_PscConfig_ProducerInstanceLocation = 1
)

// Enum value maps for ServiceConnectionPolicy_PscConfig_ProducerInstanceLocation.
var (
	ServiceConnectionPolicy_PscConfig_ProducerInstanceLocation_name = map[int32]string{
		0: "PRODUCER_INSTANCE_LOCATION_UNSPECIFIED",
		1: "CUSTOM_RESOURCE_HIERARCHY_LEVELS",
	}
	ServiceConnectionPolicy_PscConfig_ProducerInstanceLocation_value = map[string]int32{
		"PRODUCER_INSTANCE_LOCATION_UNSPECIFIED": 0,
		"CUSTOM_RESOURCE_HIERARCHY_LEVELS":       1,
	}
)

func (x ServiceConnectionPolicy_PscConfig_ProducerInstanceLocation) Enum() *ServiceConnectionPolicy_PscConfig_ProducerInstanceLocation {
	p := new(ServiceConnectionPolicy_PscConfig_ProducerInstanceLocation)
	*p = x
	return p
}

func (x ServiceConnectionPolicy_PscConfig_ProducerInstanceLocation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServiceConnectionPolicy_PscConfig_ProducerInstanceLocation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_enumTypes[6].Descriptor()
}

func (ServiceConnectionPolicy_PscConfig_ProducerInstanceLocation) Type() protoreflect.EnumType {
	return &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_enumTypes[6]
}

func (x ServiceConnectionPolicy_PscConfig_ProducerInstanceLocation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServiceConnectionPolicy_PscConfig_ProducerInstanceLocation.Descriptor instead.
func (ServiceConnectionPolicy_PscConfig_ProducerInstanceLocation) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{7, 0, 0}
}

// The ServiceConnectionMap resource.
type ServiceConnectionMap struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The name of a ServiceConnectionMap.
	// Format:
	// projects/{project}/locations/{location}/serviceConnectionMaps/{service_connection_map}
	// See: https://google.aip.dev/122#fields-representing-resource-names
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Time when the ServiceConnectionMap was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when the ServiceConnectionMap was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User-defined labels.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A description of this resource.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// The service class identifier this ServiceConnectionMap is for.
	// The user of ServiceConnectionMap create API needs to have
	// networkconnecitivty.serviceclasses.use iam permission for the service
	// class.
	ServiceClass string `protobuf:"bytes,7,opt,name=service_class,json=serviceClass,proto3" json:"service_class,omitempty"`
	// Output only. The service class uri this ServiceConnectionMap is for.
	ServiceClassUri string `protobuf:"bytes,12,opt,name=service_class_uri,json=serviceClassUri,proto3" json:"service_class_uri,omitempty"`
	// Output only. The infrastructure used for connections between
	// consumers/producers.
	Infrastructure Infrastructure `protobuf:"varint,8,opt,name=infrastructure,proto3,enum=google.cloud.networkconnectivity.v1.Infrastructure" json:"infrastructure,omitempty"`
	// The PSC configurations on producer side.
	ProducerPscConfigs []*ServiceConnectionMap_ProducerPscConfig `protobuf:"bytes,9,rep,name=producer_psc_configs,json=producerPscConfigs,proto3" json:"producer_psc_configs,omitempty"`
	// The PSC configurations on consumer side.
	ConsumerPscConfigs []*ServiceConnectionMap_ConsumerPscConfig `protobuf:"bytes,10,rep,name=consumer_psc_configs,json=consumerPscConfigs,proto3" json:"consumer_psc_configs,omitempty"`
	// Output only. PSC connection details on consumer side.
	ConsumerPscConnections []*ServiceConnectionMap_ConsumerPscConnection `protobuf:"bytes,11,rep,name=consumer_psc_connections,json=consumerPscConnections,proto3" json:"consumer_psc_connections,omitempty"`
	// The token provided by the consumer. This token authenticates that the
	// consumer can create a connection within the specified project and network.
	Token string `protobuf:"bytes,13,opt,name=token,proto3" json:"token,omitempty"`
	// Optional. The etag is computed by the server, and may be sent on update and
	// delete requests to ensure the client has an up-to-date value before
	// proceeding.
	Etag *string `protobuf:"bytes,14,opt,name=etag,proto3,oneof" json:"etag,omitempty"`
}

func (x *ServiceConnectionMap) Reset() {
	*x = ServiceConnectionMap{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceConnectionMap) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceConnectionMap) ProtoMessage() {}

func (x *ServiceConnectionMap) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceConnectionMap.ProtoReflect.Descriptor instead.
func (*ServiceConnectionMap) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{0}
}

func (x *ServiceConnectionMap) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ServiceConnectionMap) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ServiceConnectionMap) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ServiceConnectionMap) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ServiceConnectionMap) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ServiceConnectionMap) GetServiceClass() string {
	if x != nil {
		return x.ServiceClass
	}
	return ""
}

func (x *ServiceConnectionMap) GetServiceClassUri() string {
	if x != nil {
		return x.ServiceClassUri
	}
	return ""
}

func (x *ServiceConnectionMap) GetInfrastructure() Infrastructure {
	if x != nil {
		return x.Infrastructure
	}
	return Infrastructure_INFRASTRUCTURE_UNSPECIFIED
}

func (x *ServiceConnectionMap) GetProducerPscConfigs() []*ServiceConnectionMap_ProducerPscConfig {
	if x != nil {
		return x.ProducerPscConfigs
	}
	return nil
}

func (x *ServiceConnectionMap) GetConsumerPscConfigs() []*ServiceConnectionMap_ConsumerPscConfig {
	if x != nil {
		return x.ConsumerPscConfigs
	}
	return nil
}

func (x *ServiceConnectionMap) GetConsumerPscConnections() []*ServiceConnectionMap_ConsumerPscConnection {
	if x != nil {
		return x.ConsumerPscConnections
	}
	return nil
}

func (x *ServiceConnectionMap) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *ServiceConnectionMap) GetEtag() string {
	if x != nil && x.Etag != nil {
		return *x.Etag
	}
	return ""
}

// Request for ListServiceConnectionMaps.
type ListServiceConnectionMapsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource's name. ex. projects/123/locations/us-east1
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of results per page that should be returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters the results listed in the response.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sort the results by a certain order.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListServiceConnectionMapsRequest) Reset() {
	*x = ListServiceConnectionMapsRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListServiceConnectionMapsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServiceConnectionMapsRequest) ProtoMessage() {}

func (x *ListServiceConnectionMapsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListServiceConnectionMapsRequest.ProtoReflect.Descriptor instead.
func (*ListServiceConnectionMapsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{1}
}

func (x *ListServiceConnectionMapsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListServiceConnectionMapsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListServiceConnectionMapsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListServiceConnectionMapsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListServiceConnectionMapsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response for ListServiceConnectionMaps.
type ListServiceConnectionMapsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ServiceConnectionMaps to be returned.
	ServiceConnectionMaps []*ServiceConnectionMap `protobuf:"bytes,1,rep,name=service_connection_maps,json=serviceConnectionMaps,proto3" json:"service_connection_maps,omitempty"`
	// The next pagination token in the List response. It should be used as
	// page_token for the following request. An empty value means no more result.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListServiceConnectionMapsResponse) Reset() {
	*x = ListServiceConnectionMapsResponse{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListServiceConnectionMapsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServiceConnectionMapsResponse) ProtoMessage() {}

func (x *ListServiceConnectionMapsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListServiceConnectionMapsResponse.ProtoReflect.Descriptor instead.
func (*ListServiceConnectionMapsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{2}
}

func (x *ListServiceConnectionMapsResponse) GetServiceConnectionMaps() []*ServiceConnectionMap {
	if x != nil {
		return x.ServiceConnectionMaps
	}
	return nil
}

func (x *ListServiceConnectionMapsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListServiceConnectionMapsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for GetServiceConnectionMap.
type GetServiceConnectionMapRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the ServiceConnectionMap to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetServiceConnectionMapRequest) Reset() {
	*x = GetServiceConnectionMapRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetServiceConnectionMapRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetServiceConnectionMapRequest) ProtoMessage() {}

func (x *GetServiceConnectionMapRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetServiceConnectionMapRequest.ProtoReflect.Descriptor instead.
func (*GetServiceConnectionMapRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{3}
}

func (x *GetServiceConnectionMapRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for CreateServiceConnectionMap.
type CreateServiceConnectionMapRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource's name of the ServiceConnectionMap. ex.
	// projects/123/locations/us-east1
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Resource ID
	// (i.e. 'foo' in '[...]/projects/p/locations/l/serviceConnectionMaps/foo')
	// See https://google.aip.dev/122#resource-id-segments
	// Unique per location.
	// If one is not provided, one will be generated.
	ServiceConnectionMapId string `protobuf:"bytes,2,opt,name=service_connection_map_id,json=serviceConnectionMapId,proto3" json:"service_connection_map_id,omitempty"`
	// Required. Initial values for a new ServiceConnectionMaps
	ServiceConnectionMap *ServiceConnectionMap `protobuf:"bytes,3,opt,name=service_connection_map,json=serviceConnectionMap,proto3" json:"service_connection_map,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateServiceConnectionMapRequest) Reset() {
	*x = CreateServiceConnectionMapRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateServiceConnectionMapRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateServiceConnectionMapRequest) ProtoMessage() {}

func (x *CreateServiceConnectionMapRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateServiceConnectionMapRequest.ProtoReflect.Descriptor instead.
func (*CreateServiceConnectionMapRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{4}
}

func (x *CreateServiceConnectionMapRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateServiceConnectionMapRequest) GetServiceConnectionMapId() string {
	if x != nil {
		return x.ServiceConnectionMapId
	}
	return ""
}

func (x *CreateServiceConnectionMapRequest) GetServiceConnectionMap() *ServiceConnectionMap {
	if x != nil {
		return x.ServiceConnectionMap
	}
	return nil
}

func (x *CreateServiceConnectionMapRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for UpdateServiceConnectionMap.
type UpdateServiceConnectionMapRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Field mask is used to specify the fields to be overwritten in the
	// ServiceConnectionMap resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. New values to be patched into the resource.
	ServiceConnectionMap *ServiceConnectionMap `protobuf:"bytes,2,opt,name=service_connection_map,json=serviceConnectionMap,proto3" json:"service_connection_map,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateServiceConnectionMapRequest) Reset() {
	*x = UpdateServiceConnectionMapRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateServiceConnectionMapRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateServiceConnectionMapRequest) ProtoMessage() {}

func (x *UpdateServiceConnectionMapRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateServiceConnectionMapRequest.ProtoReflect.Descriptor instead.
func (*UpdateServiceConnectionMapRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateServiceConnectionMapRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateServiceConnectionMapRequest) GetServiceConnectionMap() *ServiceConnectionMap {
	if x != nil {
		return x.ServiceConnectionMap
	}
	return nil
}

func (x *UpdateServiceConnectionMapRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for DeleteServiceConnectionMap.
type DeleteServiceConnectionMapRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the ServiceConnectionMap to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. The etag is computed by the server, and may be sent on update and
	// delete requests to ensure the client has an up-to-date value before
	// proceeding.
	Etag *string `protobuf:"bytes,3,opt,name=etag,proto3,oneof" json:"etag,omitempty"`
}

func (x *DeleteServiceConnectionMapRequest) Reset() {
	*x = DeleteServiceConnectionMapRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteServiceConnectionMapRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteServiceConnectionMapRequest) ProtoMessage() {}

func (x *DeleteServiceConnectionMapRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteServiceConnectionMapRequest.ProtoReflect.Descriptor instead.
func (*DeleteServiceConnectionMapRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteServiceConnectionMapRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteServiceConnectionMapRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteServiceConnectionMapRequest) GetEtag() string {
	if x != nil && x.Etag != nil {
		return *x.Etag
	}
	return ""
}

// The ServiceConnectionPolicy resource.
type ServiceConnectionPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The name of a ServiceConnectionPolicy.
	// Format:
	// projects/{project}/locations/{location}/serviceConnectionPolicies/{service_connection_policy}
	// See: https://google.aip.dev/122#fields-representing-resource-names
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Time when the ServiceConnectionPolicy was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when the ServiceConnectionPolicy was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User-defined labels.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A description of this resource.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// The resource path of the consumer network.
	// Example:
	// - projects/{projectNumOrId}/global/networks/{resourceId}.
	Network string `protobuf:"bytes,6,opt,name=network,proto3" json:"network,omitempty"`
	// The service class identifier for which this ServiceConnectionPolicy is for.
	// The service class identifier is a unique, symbolic representation of a
	// ServiceClass. It is provided by the Service Producer. Google services have
	// a prefix of gcp or google-cloud. For example, gcp-memorystore-redis or
	// google-cloud-sql. 3rd party services do not. For example,
	// test-service-a3dfcx.
	ServiceClass string `protobuf:"bytes,7,opt,name=service_class,json=serviceClass,proto3" json:"service_class,omitempty"`
	// Output only. The type of underlying resources used to create the
	// connection.
	Infrastructure Infrastructure `protobuf:"varint,8,opt,name=infrastructure,proto3,enum=google.cloud.networkconnectivity.v1.Infrastructure" json:"infrastructure,omitempty"`
	// Configuration used for Private Service Connect connections. Used when
	// Infrastructure is PSC.
	PscConfig *ServiceConnectionPolicy_PscConfig `protobuf:"bytes,9,opt,name=psc_config,json=pscConfig,proto3" json:"psc_config,omitempty"`
	// Output only. [Output only] Information about each Private Service Connect
	// connection.
	PscConnections []*ServiceConnectionPolicy_PscConnection `protobuf:"bytes,10,rep,name=psc_connections,json=pscConnections,proto3" json:"psc_connections,omitempty"`
	// Optional. The etag is computed by the server, and may be sent on update and
	// delete requests to ensure the client has an up-to-date value before
	// proceeding.
	Etag *string `protobuf:"bytes,11,opt,name=etag,proto3,oneof" json:"etag,omitempty"`
}

func (x *ServiceConnectionPolicy) Reset() {
	*x = ServiceConnectionPolicy{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceConnectionPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceConnectionPolicy) ProtoMessage() {}

func (x *ServiceConnectionPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceConnectionPolicy.ProtoReflect.Descriptor instead.
func (*ServiceConnectionPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{7}
}

func (x *ServiceConnectionPolicy) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ServiceConnectionPolicy) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ServiceConnectionPolicy) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ServiceConnectionPolicy) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ServiceConnectionPolicy) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ServiceConnectionPolicy) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *ServiceConnectionPolicy) GetServiceClass() string {
	if x != nil {
		return x.ServiceClass
	}
	return ""
}

func (x *ServiceConnectionPolicy) GetInfrastructure() Infrastructure {
	if x != nil {
		return x.Infrastructure
	}
	return Infrastructure_INFRASTRUCTURE_UNSPECIFIED
}

func (x *ServiceConnectionPolicy) GetPscConfig() *ServiceConnectionPolicy_PscConfig {
	if x != nil {
		return x.PscConfig
	}
	return nil
}

func (x *ServiceConnectionPolicy) GetPscConnections() []*ServiceConnectionPolicy_PscConnection {
	if x != nil {
		return x.PscConnections
	}
	return nil
}

func (x *ServiceConnectionPolicy) GetEtag() string {
	if x != nil && x.Etag != nil {
		return *x.Etag
	}
	return ""
}

// Request for ListServiceConnectionPolicies.
type ListServiceConnectionPoliciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource's name. ex. projects/123/locations/us-east1
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of results per page that should be returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters the results listed in the response.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sort the results by a certain order.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListServiceConnectionPoliciesRequest) Reset() {
	*x = ListServiceConnectionPoliciesRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListServiceConnectionPoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServiceConnectionPoliciesRequest) ProtoMessage() {}

func (x *ListServiceConnectionPoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListServiceConnectionPoliciesRequest.ProtoReflect.Descriptor instead.
func (*ListServiceConnectionPoliciesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{8}
}

func (x *ListServiceConnectionPoliciesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListServiceConnectionPoliciesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListServiceConnectionPoliciesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListServiceConnectionPoliciesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListServiceConnectionPoliciesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response for ListServiceConnectionPolicies.
type ListServiceConnectionPoliciesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ServiceConnectionPolicies to be returned.
	ServiceConnectionPolicies []*ServiceConnectionPolicy `protobuf:"bytes,1,rep,name=service_connection_policies,json=serviceConnectionPolicies,proto3" json:"service_connection_policies,omitempty"`
	// The next pagination token in the List response. It should be used as
	// page_token for the following request. An empty value means no more result.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListServiceConnectionPoliciesResponse) Reset() {
	*x = ListServiceConnectionPoliciesResponse{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListServiceConnectionPoliciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServiceConnectionPoliciesResponse) ProtoMessage() {}

func (x *ListServiceConnectionPoliciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListServiceConnectionPoliciesResponse.ProtoReflect.Descriptor instead.
func (*ListServiceConnectionPoliciesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{9}
}

func (x *ListServiceConnectionPoliciesResponse) GetServiceConnectionPolicies() []*ServiceConnectionPolicy {
	if x != nil {
		return x.ServiceConnectionPolicies
	}
	return nil
}

func (x *ListServiceConnectionPoliciesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListServiceConnectionPoliciesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for GetServiceConnectionPolicy.
type GetServiceConnectionPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the ServiceConnectionPolicy to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetServiceConnectionPolicyRequest) Reset() {
	*x = GetServiceConnectionPolicyRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetServiceConnectionPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetServiceConnectionPolicyRequest) ProtoMessage() {}

func (x *GetServiceConnectionPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetServiceConnectionPolicyRequest.ProtoReflect.Descriptor instead.
func (*GetServiceConnectionPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{10}
}

func (x *GetServiceConnectionPolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for CreateServiceConnectionPolicy.
type CreateServiceConnectionPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource's name of the ServiceConnectionPolicy. ex.
	// projects/123/locations/us-east1
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Resource ID
	// (i.e. 'foo' in
	// '[...]/projects/p/locations/l/serviceConnectionPolicies/foo') See
	// https://google.aip.dev/122#resource-id-segments Unique per location.
	ServiceConnectionPolicyId string `protobuf:"bytes,2,opt,name=service_connection_policy_id,json=serviceConnectionPolicyId,proto3" json:"service_connection_policy_id,omitempty"`
	// Required. Initial values for a new ServiceConnectionPolicies
	ServiceConnectionPolicy *ServiceConnectionPolicy `protobuf:"bytes,3,opt,name=service_connection_policy,json=serviceConnectionPolicy,proto3" json:"service_connection_policy,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateServiceConnectionPolicyRequest) Reset() {
	*x = CreateServiceConnectionPolicyRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateServiceConnectionPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateServiceConnectionPolicyRequest) ProtoMessage() {}

func (x *CreateServiceConnectionPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateServiceConnectionPolicyRequest.ProtoReflect.Descriptor instead.
func (*CreateServiceConnectionPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{11}
}

func (x *CreateServiceConnectionPolicyRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateServiceConnectionPolicyRequest) GetServiceConnectionPolicyId() string {
	if x != nil {
		return x.ServiceConnectionPolicyId
	}
	return ""
}

func (x *CreateServiceConnectionPolicyRequest) GetServiceConnectionPolicy() *ServiceConnectionPolicy {
	if x != nil {
		return x.ServiceConnectionPolicy
	}
	return nil
}

func (x *CreateServiceConnectionPolicyRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for UpdateServiceConnectionPolicy.
type UpdateServiceConnectionPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Field mask is used to specify the fields to be overwritten in the
	// ServiceConnectionPolicy resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. New values to be patched into the resource.
	ServiceConnectionPolicy *ServiceConnectionPolicy `protobuf:"bytes,2,opt,name=service_connection_policy,json=serviceConnectionPolicy,proto3" json:"service_connection_policy,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateServiceConnectionPolicyRequest) Reset() {
	*x = UpdateServiceConnectionPolicyRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateServiceConnectionPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateServiceConnectionPolicyRequest) ProtoMessage() {}

func (x *UpdateServiceConnectionPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateServiceConnectionPolicyRequest.ProtoReflect.Descriptor instead.
func (*UpdateServiceConnectionPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{12}
}

func (x *UpdateServiceConnectionPolicyRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateServiceConnectionPolicyRequest) GetServiceConnectionPolicy() *ServiceConnectionPolicy {
	if x != nil {
		return x.ServiceConnectionPolicy
	}
	return nil
}

func (x *UpdateServiceConnectionPolicyRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for DeleteServiceConnectionPolicy.
type DeleteServiceConnectionPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the ServiceConnectionPolicy to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. The etag is computed by the server, and may be sent on update and
	// delete requests to ensure the client has an up-to-date value before
	// proceeding.
	Etag *string `protobuf:"bytes,3,opt,name=etag,proto3,oneof" json:"etag,omitempty"`
}

func (x *DeleteServiceConnectionPolicyRequest) Reset() {
	*x = DeleteServiceConnectionPolicyRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteServiceConnectionPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteServiceConnectionPolicyRequest) ProtoMessage() {}

func (x *DeleteServiceConnectionPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteServiceConnectionPolicyRequest.ProtoReflect.Descriptor instead.
func (*DeleteServiceConnectionPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{13}
}

func (x *DeleteServiceConnectionPolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteServiceConnectionPolicyRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteServiceConnectionPolicyRequest) GetEtag() string {
	if x != nil && x.Etag != nil {
		return *x.Etag
	}
	return ""
}

// The ServiceClass resource.
type ServiceClass struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The name of a ServiceClass resource.
	// Format:
	// projects/{project}/locations/{location}/serviceClasses/{service_class}
	// See: https://google.aip.dev/122#fields-representing-resource-names
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The generated service class name. Use this name to refer to
	// the Service class in Service Connection Maps and Service Connection
	// Policies.
	ServiceClass string `protobuf:"bytes,7,opt,name=service_class,json=serviceClass,proto3" json:"service_class,omitempty"`
	// Output only. Time when the ServiceClass was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when the ServiceClass was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User-defined labels.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A description of this resource.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. The etag is computed by the server, and may be sent on update and
	// delete requests to ensure the client has an up-to-date value before
	// proceeding.
	Etag *string `protobuf:"bytes,8,opt,name=etag,proto3,oneof" json:"etag,omitempty"`
}

func (x *ServiceClass) Reset() {
	*x = ServiceClass{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceClass) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceClass) ProtoMessage() {}

func (x *ServiceClass) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceClass.ProtoReflect.Descriptor instead.
func (*ServiceClass) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{14}
}

func (x *ServiceClass) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ServiceClass) GetServiceClass() string {
	if x != nil {
		return x.ServiceClass
	}
	return ""
}

func (x *ServiceClass) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ServiceClass) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ServiceClass) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ServiceClass) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ServiceClass) GetEtag() string {
	if x != nil && x.Etag != nil {
		return *x.Etag
	}
	return ""
}

// Request for ListServiceClasses.
type ListServiceClassesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource's name. ex. projects/123/locations/us-east1
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of results per page that should be returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters the results listed in the response.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sort the results by a certain order.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListServiceClassesRequest) Reset() {
	*x = ListServiceClassesRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListServiceClassesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServiceClassesRequest) ProtoMessage() {}

func (x *ListServiceClassesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListServiceClassesRequest.ProtoReflect.Descriptor instead.
func (*ListServiceClassesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{15}
}

func (x *ListServiceClassesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListServiceClassesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListServiceClassesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListServiceClassesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListServiceClassesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response for ListServiceClasses.
type ListServiceClassesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ServiceClasses to be returned.
	ServiceClasses []*ServiceClass `protobuf:"bytes,1,rep,name=service_classes,json=serviceClasses,proto3" json:"service_classes,omitempty"`
	// The next pagination token in the List response. It should be used as
	// page_token for the following request. An empty value means no more result.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListServiceClassesResponse) Reset() {
	*x = ListServiceClassesResponse{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListServiceClassesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServiceClassesResponse) ProtoMessage() {}

func (x *ListServiceClassesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListServiceClassesResponse.ProtoReflect.Descriptor instead.
func (*ListServiceClassesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{16}
}

func (x *ListServiceClassesResponse) GetServiceClasses() []*ServiceClass {
	if x != nil {
		return x.ServiceClasses
	}
	return nil
}

func (x *ListServiceClassesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListServiceClassesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for GetServiceClass.
type GetServiceClassRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the ServiceClass to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetServiceClassRequest) Reset() {
	*x = GetServiceClassRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetServiceClassRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetServiceClassRequest) ProtoMessage() {}

func (x *GetServiceClassRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetServiceClassRequest.ProtoReflect.Descriptor instead.
func (*GetServiceClassRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{17}
}

func (x *GetServiceClassRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for UpdateServiceClass.
type UpdateServiceClassRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Field mask is used to specify the fields to be overwritten in the
	// ServiceClass resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. New values to be patched into the resource.
	ServiceClass *ServiceClass `protobuf:"bytes,2,opt,name=service_class,json=serviceClass,proto3" json:"service_class,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateServiceClassRequest) Reset() {
	*x = UpdateServiceClassRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateServiceClassRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateServiceClassRequest) ProtoMessage() {}

func (x *UpdateServiceClassRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateServiceClassRequest.ProtoReflect.Descriptor instead.
func (*UpdateServiceClassRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{18}
}

func (x *UpdateServiceClassRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateServiceClassRequest) GetServiceClass() *ServiceClass {
	if x != nil {
		return x.ServiceClass
	}
	return nil
}

func (x *UpdateServiceClassRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for DeleteServiceClass.
type DeleteServiceClassRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the ServiceClass to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. The etag is computed by the server, and may be sent on update and
	// delete requests to ensure the client has an up-to-date value before
	// proceeding.
	Etag *string `protobuf:"bytes,3,opt,name=etag,proto3,oneof" json:"etag,omitempty"`
}

func (x *DeleteServiceClassRequest) Reset() {
	*x = DeleteServiceClassRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteServiceClassRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteServiceClassRequest) ProtoMessage() {}

func (x *DeleteServiceClassRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteServiceClassRequest.ProtoReflect.Descriptor instead.
func (*DeleteServiceClassRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{19}
}

func (x *DeleteServiceClassRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteServiceClassRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteServiceClassRequest) GetEtag() string {
	if x != nil && x.Etag != nil {
		return *x.Etag
	}
	return ""
}

// The ServiceConnectionToken resource.
type ServiceConnectionToken struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The name of a ServiceConnectionToken.
	// Format:
	// projects/{project}/locations/{location}/ServiceConnectionTokens/{service_connection_token}
	// See: https://google.aip.dev/122#fields-representing-resource-names
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Time when the ServiceConnectionToken was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when the ServiceConnectionToken was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User-defined labels.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A description of this resource.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// The resource path of the network associated with this token.
	// Example:
	// projects/{projectNumOrId}/global/networks/{resourceId}.
	Network string `protobuf:"bytes,6,opt,name=network,proto3" json:"network,omitempty"`
	// Output only. The token generated by Automation.
	Token string `protobuf:"bytes,7,opt,name=token,proto3" json:"token,omitempty"`
	// Output only. The time to which this token is valid.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Optional. The etag is computed by the server, and may be sent on update and
	// delete requests to ensure the client has an up-to-date value before
	// proceeding.
	Etag *string `protobuf:"bytes,9,opt,name=etag,proto3,oneof" json:"etag,omitempty"`
}

func (x *ServiceConnectionToken) Reset() {
	*x = ServiceConnectionToken{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceConnectionToken) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceConnectionToken) ProtoMessage() {}

func (x *ServiceConnectionToken) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceConnectionToken.ProtoReflect.Descriptor instead.
func (*ServiceConnectionToken) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{20}
}

func (x *ServiceConnectionToken) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ServiceConnectionToken) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ServiceConnectionToken) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ServiceConnectionToken) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ServiceConnectionToken) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ServiceConnectionToken) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *ServiceConnectionToken) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *ServiceConnectionToken) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *ServiceConnectionToken) GetEtag() string {
	if x != nil && x.Etag != nil {
		return *x.Etag
	}
	return ""
}

// Request for ListServiceConnectionTokens.
type ListServiceConnectionTokensRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource's name. ex. projects/123/locations/us-east1
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of results per page that should be returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters the results listed in the response.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sort the results by a certain order.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListServiceConnectionTokensRequest) Reset() {
	*x = ListServiceConnectionTokensRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListServiceConnectionTokensRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServiceConnectionTokensRequest) ProtoMessage() {}

func (x *ListServiceConnectionTokensRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListServiceConnectionTokensRequest.ProtoReflect.Descriptor instead.
func (*ListServiceConnectionTokensRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{21}
}

func (x *ListServiceConnectionTokensRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListServiceConnectionTokensRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListServiceConnectionTokensRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListServiceConnectionTokensRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListServiceConnectionTokensRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response for ListServiceConnectionTokens.
type ListServiceConnectionTokensResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ServiceConnectionTokens to be returned.
	ServiceConnectionTokens []*ServiceConnectionToken `protobuf:"bytes,1,rep,name=service_connection_tokens,json=serviceConnectionTokens,proto3" json:"service_connection_tokens,omitempty"`
	// The next pagination token in the List response. It should be used as
	// page_token for the following request. An empty value means no more result.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListServiceConnectionTokensResponse) Reset() {
	*x = ListServiceConnectionTokensResponse{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListServiceConnectionTokensResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServiceConnectionTokensResponse) ProtoMessage() {}

func (x *ListServiceConnectionTokensResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListServiceConnectionTokensResponse.ProtoReflect.Descriptor instead.
func (*ListServiceConnectionTokensResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{22}
}

func (x *ListServiceConnectionTokensResponse) GetServiceConnectionTokens() []*ServiceConnectionToken {
	if x != nil {
		return x.ServiceConnectionTokens
	}
	return nil
}

func (x *ListServiceConnectionTokensResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListServiceConnectionTokensResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for GetServiceConnectionToken.
type GetServiceConnectionTokenRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the ServiceConnectionToken to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetServiceConnectionTokenRequest) Reset() {
	*x = GetServiceConnectionTokenRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetServiceConnectionTokenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetServiceConnectionTokenRequest) ProtoMessage() {}

func (x *GetServiceConnectionTokenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetServiceConnectionTokenRequest.ProtoReflect.Descriptor instead.
func (*GetServiceConnectionTokenRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{23}
}

func (x *GetServiceConnectionTokenRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for CreateServiceConnectionToken.
type CreateServiceConnectionTokenRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource's name of the ServiceConnectionToken. ex.
	// projects/123/locations/us-east1
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Resource ID
	// (i.e. 'foo' in '[...]/projects/p/locations/l/ServiceConnectionTokens/foo')
	// See https://google.aip.dev/122#resource-id-segments
	// Unique per location.
	// If one is not provided, one will be generated.
	ServiceConnectionTokenId string `protobuf:"bytes,2,opt,name=service_connection_token_id,json=serviceConnectionTokenId,proto3" json:"service_connection_token_id,omitempty"`
	// Required. Initial values for a new ServiceConnectionTokens
	ServiceConnectionToken *ServiceConnectionToken `protobuf:"bytes,3,opt,name=service_connection_token,json=serviceConnectionToken,proto3" json:"service_connection_token,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateServiceConnectionTokenRequest) Reset() {
	*x = CreateServiceConnectionTokenRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateServiceConnectionTokenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateServiceConnectionTokenRequest) ProtoMessage() {}

func (x *CreateServiceConnectionTokenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateServiceConnectionTokenRequest.ProtoReflect.Descriptor instead.
func (*CreateServiceConnectionTokenRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{24}
}

func (x *CreateServiceConnectionTokenRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateServiceConnectionTokenRequest) GetServiceConnectionTokenId() string {
	if x != nil {
		return x.ServiceConnectionTokenId
	}
	return ""
}

func (x *CreateServiceConnectionTokenRequest) GetServiceConnectionToken() *ServiceConnectionToken {
	if x != nil {
		return x.ServiceConnectionToken
	}
	return nil
}

func (x *CreateServiceConnectionTokenRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for DeleteServiceConnectionToken.
type DeleteServiceConnectionTokenRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the ServiceConnectionToken to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. The etag is computed by the server, and may be sent on update and
	// delete requests to ensure the client has an up-to-date value before
	// proceeding.
	Etag *string `protobuf:"bytes,3,opt,name=etag,proto3,oneof" json:"etag,omitempty"`
}

func (x *DeleteServiceConnectionTokenRequest) Reset() {
	*x = DeleteServiceConnectionTokenRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteServiceConnectionTokenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteServiceConnectionTokenRequest) ProtoMessage() {}

func (x *DeleteServiceConnectionTokenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteServiceConnectionTokenRequest.ProtoReflect.Descriptor instead.
func (*DeleteServiceConnectionTokenRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{25}
}

func (x *DeleteServiceConnectionTokenRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteServiceConnectionTokenRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteServiceConnectionTokenRequest) GetEtag() string {
	if x != nil && x.Etag != nil {
		return *x.Etag
	}
	return ""
}

// The PSC configurations on producer side.
type ServiceConnectionMap_ProducerPscConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource path of a service attachment.
	// Example:
	// projects/{projectNumOrId}/regions/{region}/serviceAttachments/{resourceId}.
	ServiceAttachmentUri string `protobuf:"bytes,1,opt,name=service_attachment_uri,json=serviceAttachmentUri,proto3" json:"service_attachment_uri,omitempty"`
}

func (x *ServiceConnectionMap_ProducerPscConfig) Reset() {
	*x = ServiceConnectionMap_ProducerPscConfig{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceConnectionMap_ProducerPscConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceConnectionMap_ProducerPscConfig) ProtoMessage() {}

func (x *ServiceConnectionMap_ProducerPscConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceConnectionMap_ProducerPscConfig.ProtoReflect.Descriptor instead.
func (*ServiceConnectionMap_ProducerPscConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{0, 0}
}

func (x *ServiceConnectionMap_ProducerPscConfig) GetServiceAttachmentUri() string {
	if x != nil {
		return x.ServiceAttachmentUri
	}
	return ""
}

// Allow the producer to specify which consumers can connect to it.
type ServiceConnectionMap_ConsumerPscConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The consumer project where PSC connections are allowed to be created in.
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// The resource path of the consumer network where PSC connections are
	// allowed to be created in. Note, this network does not need be in the
	// ConsumerPscConfig.project in the case of SharedVPC.
	// Example:
	// projects/{projectNumOrId}/global/networks/{networkId}.
	Network string `protobuf:"bytes,2,opt,name=network,proto3" json:"network,omitempty"`
	// This is used in PSC consumer ForwardingRule to control whether the PSC
	// endpoint can be accessed from another region.
	DisableGlobalAccess bool `protobuf:"varint,3,opt,name=disable_global_access,json=disableGlobalAccess,proto3" json:"disable_global_access,omitempty"`
	// Output only. Overall state of PSC Connections management for this
	// consumer psc config.
	State ServiceConnectionMap_ConsumerPscConfig_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.networkconnectivity.v1.ServiceConnectionMap_ConsumerPscConfig_State" json:"state,omitempty"`
	// Immutable. Deprecated. Use producer_instance_metadata instead.
	// An immutable identifier for the producer instance.
	//
	// Deprecated: Marked as deprecated in google/cloud/networkconnectivity/v1/cross_network_automation.proto.
	ProducerInstanceId string `protobuf:"bytes,5,opt,name=producer_instance_id,json=producerInstanceId,proto3" json:"producer_instance_id,omitempty"`
	// Output only. A map to store mapping between customer vip and target
	// service attachment. Only service attachment with producer specified ip
	// addresses are stored here.
	ServiceAttachmentIpAddressMap map[string]string `protobuf:"bytes,6,rep,name=service_attachment_ip_address_map,json=serviceAttachmentIpAddressMap,proto3" json:"service_attachment_ip_address_map,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. The project ID or project number of the consumer project. This
	// project is the one that the consumer uses to interact with the producer
	// instance. From the perspective of a consumer who's created a producer
	// instance, this is the project of the producer instance. Format:
	// 'projects/<project_id_or_number>' Eg. 'projects/consumer-project' or
	// 'projects/1234'
	ConsumerInstanceProject string `protobuf:"bytes,7,opt,name=consumer_instance_project,json=consumerInstanceProject,proto3" json:"consumer_instance_project,omitempty"`
	// Immutable. An immutable map for the producer instance metadata.
	ProducerInstanceMetadata map[string]string `protobuf:"bytes,8,rep,name=producer_instance_metadata,json=producerInstanceMetadata,proto3" json:"producer_instance_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The requested IP version for the PSC connection.
	IpVersion *IPVersion `protobuf:"varint,9,opt,name=ip_version,json=ipVersion,proto3,enum=google.cloud.networkconnectivity.v1.IPVersion,oneof" json:"ip_version,omitempty"`
}

func (x *ServiceConnectionMap_ConsumerPscConfig) Reset() {
	*x = ServiceConnectionMap_ConsumerPscConfig{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceConnectionMap_ConsumerPscConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceConnectionMap_ConsumerPscConfig) ProtoMessage() {}

func (x *ServiceConnectionMap_ConsumerPscConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceConnectionMap_ConsumerPscConfig.ProtoReflect.Descriptor instead.
func (*ServiceConnectionMap_ConsumerPscConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{0, 1}
}

func (x *ServiceConnectionMap_ConsumerPscConfig) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *ServiceConnectionMap_ConsumerPscConfig) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *ServiceConnectionMap_ConsumerPscConfig) GetDisableGlobalAccess() bool {
	if x != nil {
		return x.DisableGlobalAccess
	}
	return false
}

func (x *ServiceConnectionMap_ConsumerPscConfig) GetState() ServiceConnectionMap_ConsumerPscConfig_State {
	if x != nil {
		return x.State
	}
	return ServiceConnectionMap_ConsumerPscConfig_STATE_UNSPECIFIED
}

// Deprecated: Marked as deprecated in google/cloud/networkconnectivity/v1/cross_network_automation.proto.
func (x *ServiceConnectionMap_ConsumerPscConfig) GetProducerInstanceId() string {
	if x != nil {
		return x.ProducerInstanceId
	}
	return ""
}

func (x *ServiceConnectionMap_ConsumerPscConfig) GetServiceAttachmentIpAddressMap() map[string]string {
	if x != nil {
		return x.ServiceAttachmentIpAddressMap
	}
	return nil
}

func (x *ServiceConnectionMap_ConsumerPscConfig) GetConsumerInstanceProject() string {
	if x != nil {
		return x.ConsumerInstanceProject
	}
	return ""
}

func (x *ServiceConnectionMap_ConsumerPscConfig) GetProducerInstanceMetadata() map[string]string {
	if x != nil {
		return x.ProducerInstanceMetadata
	}
	return nil
}

func (x *ServiceConnectionMap_ConsumerPscConfig) GetIpVersion() IPVersion {
	if x != nil && x.IpVersion != nil {
		return *x.IpVersion
	}
	return IPVersion_IP_VERSION_UNSPECIFIED
}

// PSC connection details on consumer side.
type ServiceConnectionMap_ConsumerPscConnection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URI of a service attachment which is the target of the PSC
	// connection.
	ServiceAttachmentUri string `protobuf:"bytes,1,opt,name=service_attachment_uri,json=serviceAttachmentUri,proto3" json:"service_attachment_uri,omitempty"`
	// The state of the PSC connection.
	State ServiceConnectionMap_ConsumerPscConnection_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.networkconnectivity.v1.ServiceConnectionMap_ConsumerPscConnection_State" json:"state,omitempty"`
	// The consumer project whose PSC forwarding rule is connected to the
	// service attachments in this service connection map.
	Project string `protobuf:"bytes,3,opt,name=project,proto3" json:"project,omitempty"`
	// The consumer network whose PSC forwarding rule is connected to the
	// service attachments in this service connection map.
	// Note that the network could be on a different project (shared VPC).
	Network string `protobuf:"bytes,4,opt,name=network,proto3" json:"network,omitempty"`
	// The PSC connection id of the PSC forwarding rule connected
	// to the service attachments in this service connection map.
	PscConnectionId string `protobuf:"bytes,5,opt,name=psc_connection_id,json=pscConnectionId,proto3" json:"psc_connection_id,omitempty"`
	// The IP literal allocated on the consumer network for the PSC forwarding
	// rule that is created to connect to the producer service attachment in
	// this service connection map.
	Ip string `protobuf:"bytes,6,opt,name=ip,proto3" json:"ip,omitempty"`
	// The error type indicates whether the error is consumer facing, producer
	// facing or system internal.
	//
	// Deprecated: Marked as deprecated in google/cloud/networkconnectivity/v1/cross_network_automation.proto.
	ErrorType ConnectionErrorType `protobuf:"varint,7,opt,name=error_type,json=errorType,proto3,enum=google.cloud.networkconnectivity.v1.ConnectionErrorType" json:"error_type,omitempty"`
	// The most recent error during operating this connection.
	//
	// Deprecated: Marked as deprecated in google/cloud/networkconnectivity/v1/cross_network_automation.proto.
	Error *status.Status `protobuf:"bytes,8,opt,name=error,proto3" json:"error,omitempty"`
	// The last Compute Engine operation to setup PSC connection.
	GceOperation string `protobuf:"bytes,9,opt,name=gce_operation,json=gceOperation,proto3" json:"gce_operation,omitempty"`
	// The URI of the consumer forwarding rule created.
	// Example:
	// projects/{projectNumOrId}/regions/us-east1/networks/{resourceId}.
	ForwardingRule string `protobuf:"bytes,10,opt,name=forwarding_rule,json=forwardingRule,proto3" json:"forwarding_rule,omitempty"`
	// Output only. The error info for the latest error during operating this
	// connection.
	ErrorInfo *errdetails.ErrorInfo `protobuf:"bytes,11,opt,name=error_info,json=errorInfo,proto3" json:"error_info,omitempty"`
	// Output only. The URI of the selected subnetwork selected to allocate IP
	// address for this connection.
	SelectedSubnetwork string `protobuf:"bytes,12,opt,name=selected_subnetwork,json=selectedSubnetwork,proto3" json:"selected_subnetwork,omitempty"`
	// Immutable. Deprecated. Use producer_instance_metadata instead.
	// An immutable identifier for the producer instance.
	//
	// Deprecated: Marked as deprecated in google/cloud/networkconnectivity/v1/cross_network_automation.proto.
	ProducerInstanceId string `protobuf:"bytes,13,opt,name=producer_instance_id,json=producerInstanceId,proto3" json:"producer_instance_id,omitempty"`
	// Immutable. An immutable map for the producer instance metadata.
	ProducerInstanceMetadata map[string]string `protobuf:"bytes,14,rep,name=producer_instance_metadata,json=producerInstanceMetadata,proto3" json:"producer_instance_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The requested IP version for the PSC connection.
	IpVersion *IPVersion `protobuf:"varint,15,opt,name=ip_version,json=ipVersion,proto3,enum=google.cloud.networkconnectivity.v1.IPVersion,oneof" json:"ip_version,omitempty"`
}

func (x *ServiceConnectionMap_ConsumerPscConnection) Reset() {
	*x = ServiceConnectionMap_ConsumerPscConnection{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceConnectionMap_ConsumerPscConnection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceConnectionMap_ConsumerPscConnection) ProtoMessage() {}

func (x *ServiceConnectionMap_ConsumerPscConnection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceConnectionMap_ConsumerPscConnection.ProtoReflect.Descriptor instead.
func (*ServiceConnectionMap_ConsumerPscConnection) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{0, 2}
}

func (x *ServiceConnectionMap_ConsumerPscConnection) GetServiceAttachmentUri() string {
	if x != nil {
		return x.ServiceAttachmentUri
	}
	return ""
}

func (x *ServiceConnectionMap_ConsumerPscConnection) GetState() ServiceConnectionMap_ConsumerPscConnection_State {
	if x != nil {
		return x.State
	}
	return ServiceConnectionMap_ConsumerPscConnection_STATE_UNSPECIFIED
}

func (x *ServiceConnectionMap_ConsumerPscConnection) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *ServiceConnectionMap_ConsumerPscConnection) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *ServiceConnectionMap_ConsumerPscConnection) GetPscConnectionId() string {
	if x != nil {
		return x.PscConnectionId
	}
	return ""
}

func (x *ServiceConnectionMap_ConsumerPscConnection) GetIp() string {
	if x != nil {
		return x.Ip
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/networkconnectivity/v1/cross_network_automation.proto.
func (x *ServiceConnectionMap_ConsumerPscConnection) GetErrorType() ConnectionErrorType {
	if x != nil {
		return x.ErrorType
	}
	return ConnectionErrorType_CONNECTION_ERROR_TYPE_UNSPECIFIED
}

// Deprecated: Marked as deprecated in google/cloud/networkconnectivity/v1/cross_network_automation.proto.
func (x *ServiceConnectionMap_ConsumerPscConnection) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *ServiceConnectionMap_ConsumerPscConnection) GetGceOperation() string {
	if x != nil {
		return x.GceOperation
	}
	return ""
}

func (x *ServiceConnectionMap_ConsumerPscConnection) GetForwardingRule() string {
	if x != nil {
		return x.ForwardingRule
	}
	return ""
}

func (x *ServiceConnectionMap_ConsumerPscConnection) GetErrorInfo() *errdetails.ErrorInfo {
	if x != nil {
		return x.ErrorInfo
	}
	return nil
}

func (x *ServiceConnectionMap_ConsumerPscConnection) GetSelectedSubnetwork() string {
	if x != nil {
		return x.SelectedSubnetwork
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/networkconnectivity/v1/cross_network_automation.proto.
func (x *ServiceConnectionMap_ConsumerPscConnection) GetProducerInstanceId() string {
	if x != nil {
		return x.ProducerInstanceId
	}
	return ""
}

func (x *ServiceConnectionMap_ConsumerPscConnection) GetProducerInstanceMetadata() map[string]string {
	if x != nil {
		return x.ProducerInstanceMetadata
	}
	return nil
}

func (x *ServiceConnectionMap_ConsumerPscConnection) GetIpVersion() IPVersion {
	if x != nil && x.IpVersion != nil {
		return *x.IpVersion
	}
	return IPVersion_IP_VERSION_UNSPECIFIED
}

// Configuration used for Private Service Connect connections. Used when
// Infrastructure is PSC.
type ServiceConnectionPolicy_PscConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource paths of subnetworks to use for IP address management.
	// Example:
	// projects/{projectNumOrId}/regions/{region}/subnetworks/{resourceId}.
	Subnetworks []string `protobuf:"bytes,1,rep,name=subnetworks,proto3" json:"subnetworks,omitempty"`
	// Optional. Max number of PSC connections for this policy.
	Limit *int64 `protobuf:"varint,2,opt,name=limit,proto3,oneof" json:"limit,omitempty"`
	// Required. ProducerInstanceLocation is used to specify which authorization
	// mechanism to use to determine which projects the Producer instance can be
	// within.
	ProducerInstanceLocation ServiceConnectionPolicy_PscConfig_ProducerInstanceLocation `protobuf:"varint,3,opt,name=producer_instance_location,json=producerInstanceLocation,proto3,enum=google.cloud.networkconnectivity.v1.ServiceConnectionPolicy_PscConfig_ProducerInstanceLocation" json:"producer_instance_location,omitempty"`
	// Optional. List of Projects, Folders, or Organizations from where the
	// Producer instance can be within. For example, a network administrator can
	// provide both 'organizations/foo' and 'projects/bar' as
	// allowed_google_producers_resource_hierarchy_levels. This allowlists this
	// network to connect with any Producer instance within the 'foo'
	// organization or the 'bar' project. By default,
	// allowed_google_producers_resource_hierarchy_level is empty. The format
	// for each allowed_google_producers_resource_hierarchy_level is <resource
	// type>/<id> where <resource type> is one of 'projects', 'folders', or
	// 'organizations' and <id> is either the ID or the number of the resource
	// type. Format for each allowed_google_producers_resource_hierarchy_level
	// value: 'projects/<project_id_or_number>' or 'folders/<folder_id>' or
	// 'organizations/<organization_id>'
	// Eg. [projects/my-project-id, projects/567, folders/891,
	// organizations/123]
	AllowedGoogleProducersResourceHierarchyLevel []string `protobuf:"bytes,4,rep,name=allowed_google_producers_resource_hierarchy_level,json=allowedGoogleProducersResourceHierarchyLevel,proto3" json:"allowed_google_producers_resource_hierarchy_level,omitempty"`
}

func (x *ServiceConnectionPolicy_PscConfig) Reset() {
	*x = ServiceConnectionPolicy_PscConfig{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceConnectionPolicy_PscConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceConnectionPolicy_PscConfig) ProtoMessage() {}

func (x *ServiceConnectionPolicy_PscConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceConnectionPolicy_PscConfig.ProtoReflect.Descriptor instead.
func (*ServiceConnectionPolicy_PscConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{7, 0}
}

func (x *ServiceConnectionPolicy_PscConfig) GetSubnetworks() []string {
	if x != nil {
		return x.Subnetworks
	}
	return nil
}

func (x *ServiceConnectionPolicy_PscConfig) GetLimit() int64 {
	if x != nil && x.Limit != nil {
		return *x.Limit
	}
	return 0
}

func (x *ServiceConnectionPolicy_PscConfig) GetProducerInstanceLocation() ServiceConnectionPolicy_PscConfig_ProducerInstanceLocation {
	if x != nil {
		return x.ProducerInstanceLocation
	}
	return ServiceConnectionPolicy_PscConfig_PRODUCER_INSTANCE_LOCATION_UNSPECIFIED
}

func (x *ServiceConnectionPolicy_PscConfig) GetAllowedGoogleProducersResourceHierarchyLevel() []string {
	if x != nil {
		return x.AllowedGoogleProducersResourceHierarchyLevel
	}
	return nil
}

// Information about a specific Private Service Connect connection.
type ServiceConnectionPolicy_PscConnection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// State of the PSC Connection
	State ServiceConnectionPolicy_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.networkconnectivity.v1.ServiceConnectionPolicy_State" json:"state,omitempty"`
	// The resource reference of the PSC Forwarding Rule within the consumer
	// VPC.
	ConsumerForwardingRule string `protobuf:"bytes,2,opt,name=consumer_forwarding_rule,json=consumerForwardingRule,proto3" json:"consumer_forwarding_rule,omitempty"`
	// The resource reference of the consumer address.
	ConsumerAddress string `protobuf:"bytes,3,opt,name=consumer_address,json=consumerAddress,proto3" json:"consumer_address,omitempty"`
	// The error type indicates whether the error is consumer facing, producer
	// facing or system internal.
	//
	// Deprecated: Marked as deprecated in google/cloud/networkconnectivity/v1/cross_network_automation.proto.
	ErrorType ConnectionErrorType `protobuf:"varint,4,opt,name=error_type,json=errorType,proto3,enum=google.cloud.networkconnectivity.v1.ConnectionErrorType" json:"error_type,omitempty"`
	// The most recent error during operating this connection.
	// Deprecated, please use error_info instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/networkconnectivity/v1/cross_network_automation.proto.
	Error *status.Status `protobuf:"bytes,5,opt,name=error,proto3" json:"error,omitempty"`
	// The last Compute Engine operation to setup PSC connection.
	GceOperation string `protobuf:"bytes,6,opt,name=gce_operation,json=gceOperation,proto3" json:"gce_operation,omitempty"`
	// The project where the PSC connection is created.
	ConsumerTargetProject string `protobuf:"bytes,7,opt,name=consumer_target_project,json=consumerTargetProject,proto3" json:"consumer_target_project,omitempty"`
	// The PSC connection id of the PSC forwarding rule.
	PscConnectionId string `protobuf:"bytes,8,opt,name=psc_connection_id,json=pscConnectionId,proto3" json:"psc_connection_id,omitempty"`
	// Output only. The error info for the latest error during operating this
	// connection.
	ErrorInfo *errdetails.ErrorInfo `protobuf:"bytes,9,opt,name=error_info,json=errorInfo,proto3" json:"error_info,omitempty"`
	// Output only. The URI of the subnetwork selected to allocate IP address
	// for this connection.
	SelectedSubnetwork string `protobuf:"bytes,10,opt,name=selected_subnetwork,json=selectedSubnetwork,proto3" json:"selected_subnetwork,omitempty"`
	// Immutable. Deprecated. Use producer_instance_metadata instead.
	// An immutable identifier for the producer instance.
	//
	// Deprecated: Marked as deprecated in google/cloud/networkconnectivity/v1/cross_network_automation.proto.
	ProducerInstanceId string `protobuf:"bytes,11,opt,name=producer_instance_id,json=producerInstanceId,proto3" json:"producer_instance_id,omitempty"`
	// Immutable. An immutable map for the producer instance metadata.
	ProducerInstanceMetadata map[string]string `protobuf:"bytes,12,rep,name=producer_instance_metadata,json=producerInstanceMetadata,proto3" json:"producer_instance_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. [Output only] The service class associated with this PSC
	// Connection. The value is derived from the SCPolicy and matches the
	// service class name provided by the customer.
	ServiceClass string `protobuf:"bytes,13,opt,name=service_class,json=serviceClass,proto3" json:"service_class,omitempty"`
	// The requested IP version for the PSC connection.
	IpVersion *IPVersion `protobuf:"varint,14,opt,name=ip_version,json=ipVersion,proto3,enum=google.cloud.networkconnectivity.v1.IPVersion,oneof" json:"ip_version,omitempty"`
}

func (x *ServiceConnectionPolicy_PscConnection) Reset() {
	*x = ServiceConnectionPolicy_PscConnection{}
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceConnectionPolicy_PscConnection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceConnectionPolicy_PscConnection) ProtoMessage() {}

func (x *ServiceConnectionPolicy_PscConnection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceConnectionPolicy_PscConnection.ProtoReflect.Descriptor instead.
func (*ServiceConnectionPolicy_PscConnection) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP(), []int{7, 1}
}

func (x *ServiceConnectionPolicy_PscConnection) GetState() ServiceConnectionPolicy_State {
	if x != nil {
		return x.State
	}
	return ServiceConnectionPolicy_STATE_UNSPECIFIED
}

func (x *ServiceConnectionPolicy_PscConnection) GetConsumerForwardingRule() string {
	if x != nil {
		return x.ConsumerForwardingRule
	}
	return ""
}

func (x *ServiceConnectionPolicy_PscConnection) GetConsumerAddress() string {
	if x != nil {
		return x.ConsumerAddress
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/networkconnectivity/v1/cross_network_automation.proto.
func (x *ServiceConnectionPolicy_PscConnection) GetErrorType() ConnectionErrorType {
	if x != nil {
		return x.ErrorType
	}
	return ConnectionErrorType_CONNECTION_ERROR_TYPE_UNSPECIFIED
}

// Deprecated: Marked as deprecated in google/cloud/networkconnectivity/v1/cross_network_automation.proto.
func (x *ServiceConnectionPolicy_PscConnection) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *ServiceConnectionPolicy_PscConnection) GetGceOperation() string {
	if x != nil {
		return x.GceOperation
	}
	return ""
}

func (x *ServiceConnectionPolicy_PscConnection) GetConsumerTargetProject() string {
	if x != nil {
		return x.ConsumerTargetProject
	}
	return ""
}

func (x *ServiceConnectionPolicy_PscConnection) GetPscConnectionId() string {
	if x != nil {
		return x.PscConnectionId
	}
	return ""
}

func (x *ServiceConnectionPolicy_PscConnection) GetErrorInfo() *errdetails.ErrorInfo {
	if x != nil {
		return x.ErrorInfo
	}
	return nil
}

func (x *ServiceConnectionPolicy_PscConnection) GetSelectedSubnetwork() string {
	if x != nil {
		return x.SelectedSubnetwork
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/networkconnectivity/v1/cross_network_automation.proto.
func (x *ServiceConnectionPolicy_PscConnection) GetProducerInstanceId() string {
	if x != nil {
		return x.ProducerInstanceId
	}
	return ""
}

func (x *ServiceConnectionPolicy_PscConnection) GetProducerInstanceMetadata() map[string]string {
	if x != nil {
		return x.ProducerInstanceMetadata
	}
	return nil
}

func (x *ServiceConnectionPolicy_PscConnection) GetServiceClass() string {
	if x != nil {
		return x.ServiceClass
	}
	return ""
}

func (x *ServiceConnectionPolicy_PscConnection) GetIpVersion() IPVersion {
	if x != nil && x.IpVersion != nil {
		return *x.IpVersion
	}
	return IPVersion_IP_VERSION_UNSPECIFIED
}

var File_google_cloud_networkconnectivity_v1_cross_network_automation_proto protoreflect.FileDescriptor

var file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDesc = []byte{
	0x0a, 0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x5f, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2f, 0x76,
	0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xcb, 0x1c, 0x0a,
	0x14, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x5d, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x2e, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63,
	0x6c, 0x61, 0x73, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x2f, 0x0a, 0x11, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x55, 0x72, 0x69, 0x12, 0x60, 0x0a, 0x0e, 0x69, 0x6e, 0x66,
	0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x69, 0x6e, 0x66,
	0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x7d, 0x0a, 0x14, 0x70,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x5f, 0x70, 0x73, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x61, 0x70, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x50, 0x73, 0x63,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x12, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72,
	0x50, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x7d, 0x0a, 0x14, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5f, 0x70, 0x73, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x61, 0x70, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x50, 0x73, 0x63, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x50,
	0x73, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x8e, 0x01, 0x0a, 0x18, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5f, 0x70, 0x73, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72,
	0x50, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x16, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x50, 0x73, 0x63, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x1c, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x88, 0x01, 0x01, 0x1a, 0x78,
	0x0a, 0x11, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x50, 0x73, 0x63, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x63, 0x0a, 0x16, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61,
	0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2d, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x14, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63,
	0x68, 0x6d, 0x65, 0x6e, 0x74, 0x55, 0x72, 0x69, 0x1a, 0xb0, 0x09, 0x0a, 0x11, 0x43, 0x6f, 0x6e,
	0x73, 0x75, 0x6d, 0x65, 0x72, 0x50, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18,
	0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x3d, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xfa, 0x41, 0x20, 0x0a, 0x1e,
	0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x07,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x32, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x47,
	0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x6c, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x50, 0x73,
	0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x37, 0x0a, 0x14, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0xe0, 0x41, 0x05, 0x18, 0x01, 0x52, 0x12,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x49, 0x64, 0x12, 0xbd, 0x01, 0x0a, 0x21, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61,
	0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x5f, 0x6d, 0x61, 0x70, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d,
	0x65, 0x72, 0x50, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x70, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x1d, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x74, 0x74, 0x61,
	0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x4d,
	0x61, 0x70, 0x12, 0x62, 0x0a, 0x19, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x17, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0xac, 0x01, 0x0a, 0x1a, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x69, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x50,
	0x73, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65,
	0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x18, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x52, 0x0a, 0x0a, 0x69, 0x70, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x50, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x09, 0x69, 0x70, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x1a, 0x50, 0x0a, 0x22, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x70,
	0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x4b, 0x0a, 0x1d, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x91, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x56, 0x41, 0x4c,
	0x49, 0x44, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4e,
	0x47, 0x10, 0x02, 0x12, 0x18, 0x0a, 0x14, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x4c, 0x49,
	0x4d, 0x49, 0x54, 0x5f, 0x52, 0x45, 0x41, 0x43, 0x48, 0x45, 0x44, 0x10, 0x03, 0x12, 0x2d, 0x0a,
	0x29, 0x43, 0x4f, 0x4e, 0x53, 0x55, 0x4d, 0x45, 0x52, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e,
	0x43, 0x45, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x41,
	0x4c, 0x4c, 0x4f, 0x57, 0x4c, 0x49, 0x53, 0x54, 0x45, 0x44, 0x10, 0x04, 0x42, 0x0d, 0x0a, 0x0b,
	0x5f, 0x69, 0x70, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x90, 0x09, 0x0a, 0x15,
	0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x50, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x16, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x55, 0x72, 0x69, 0x12, 0x6b, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x50, 0x73,
	0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x2a, 0x0a, 0x11,
	0x70, 0x73, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x70, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x70, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x70, 0x12, 0x5b, 0x0a, 0x0a, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2c, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70,
	0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x02, 0x18, 0x01, 0x52, 0x05, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x12, 0x23, 0x0a, 0x0d, 0x67, 0x63, 0x65, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x67, 0x63, 0x65, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x66, 0x6f, 0x72, 0x77,
	0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c,
	0x65, 0x12, 0x39, 0x0a, 0x0a, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72,
	0x70, 0x63, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x34, 0x0a, 0x13,
	0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12,
	0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x12, 0x37, 0x0a, 0x14, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x5f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x05, 0xe0, 0x41, 0x05, 0x18, 0x01, 0x52, 0x12, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65,
	0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0xb0, 0x01, 0x0a, 0x1a,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x2e, 0x43, 0x6f, 0x6e, 0x73,
	0x75, 0x6d, 0x65, 0x72, 0x50, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x05, 0x52, 0x18, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x52,
	0x0a, 0x0a, 0x69, 0x70, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x50, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x09, 0x69, 0x70, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x88,
	0x01, 0x01, 0x1a, 0x4b, 0x0a, 0x1d, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x7e, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46,
	0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x04, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x52, 0x45,
	0x50, 0x41, 0x49, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x14, 0x0a, 0x10, 0x44, 0x45, 0x4c,
	0x45, 0x54, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x41, 0x49, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x06, 0x42,
	0x0d, 0x0a, 0x0b, 0x5f, 0x69, 0x70, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x39,
	0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x95, 0x01, 0xea, 0x41, 0x91, 0x01,
	0x0a, 0x37, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x12, 0x56, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x70,
	0x7d, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x65, 0x74, 0x61, 0x67, 0x22, 0xd4, 0x01, 0x0a, 0x20, 0x4c,
	0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f,
	0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42,
	0x79, 0x22, 0xe0, 0x01, 0x0a, 0x21, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x71, 0x0a, 0x17, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61,
	0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x61, 0x70, 0x52, 0x15, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68,
	0x61, 0x62, 0x6c, 0x65, 0x22, 0x75, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x3f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x39, 0x0a, 0x37, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd6, 0x02, 0x0a, 0x21,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x57, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x3f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x39, 0x12, 0x37, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x61, 0x70, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3e, 0x0a, 0x19, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6d, 0x61, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x16, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x49, 0x64, 0x12, 0x74, 0x0a, 0x16, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6d, 0x61, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70,
	0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x49, 0x64, 0x22, 0xff, 0x01, 0x0a, 0x21, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x61, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x74, 0x0a, 0x16,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x61, 0x70, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xc3, 0x01, 0x0a, 0x21, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3f, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x39, 0x0a, 0x37, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67,
	0x88, 0x01, 0x01, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x65, 0x74, 0x61, 0x67, 0x22, 0xff, 0x14, 0x0a,
	0x17, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x60, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x07, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xfa, 0x41, 0x20, 0x0a,
	0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52,
	0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x60, 0x0a,
	0x0e, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x66, 0x72,
	0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0e, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12,
	0x65, 0x0a, 0x0a, 0x70, 0x73, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x2e, 0x50, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x09, 0x70, 0x73, 0x63,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x78, 0x0a, 0x0f, 0x70, 0x73, 0x63, 0x5f, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x50, 0x73,
	0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0e, 0x70, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x1c, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x88, 0x01, 0x01, 0x1a, 0x80,
	0x04, 0x0a, 0x09, 0x50, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x48, 0x0a, 0x0b,
	0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x0b, 0x73, 0x75, 0x62, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x12, 0x1e, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x05, 0x6c, 0x69,
	0x6d, 0x69, 0x74, 0x88, 0x01, 0x01, 0x12, 0xa2, 0x01, 0x0a, 0x1a, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x50, 0x73, 0x63, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x18, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6c, 0x0a, 0x31, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x68, 0x69, 0x65, 0x72, 0x61, 0x72, 0x63, 0x68, 0x79, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x2c, 0x61, 0x6c, 0x6c,
	0x6f, 0x77, 0x65, 0x64, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x69, 0x65, 0x72, 0x61,
	0x72, 0x63, 0x68, 0x79, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x22, 0x6c, 0x0a, 0x18, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x26, 0x50, 0x52, 0x4f, 0x44, 0x55, 0x43, 0x45,
	0x52, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x24, 0x0a, 0x20, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x5f, 0x52, 0x45, 0x53, 0x4f,
	0x55, 0x52, 0x43, 0x45, 0x5f, 0x48, 0x49, 0x45, 0x52, 0x41, 0x52, 0x43, 0x48, 0x59, 0x5f, 0x4c,
	0x45, 0x56, 0x45, 0x4c, 0x53, 0x10, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x6c, 0x69, 0x6d, 0x69,
	0x74, 0x1a, 0x94, 0x08, 0x0a, 0x0d, 0x50, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x38, 0x0a,
	0x18, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5f, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72,
	0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x16, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64,
	0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6d, 0x65, 0x72, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x41, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x12, 0x5b, 0x0a, 0x0a, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x2c, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x42, 0x02, 0x18, 0x01, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x23, 0x0a,
	0x0d, 0x67, 0x63, 0x65, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x67, 0x63, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x36, 0x0a, 0x17, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5f, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x15, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x2a, 0x0a, 0x11, 0x70, 0x73,
	0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x70, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x39, 0x0a, 0x0a, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f,
	0x69, 0x6e, 0x66, 0x6f, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x49, 0x6e, 0x66,
	0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x34, 0x0a, 0x13, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x75,
	0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x12, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x75, 0x62,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x37, 0x0a, 0x14, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0xe0, 0x41, 0x05, 0x18, 0x01, 0x52, 0x12, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64,
	0x12, 0xab, 0x01, 0x0a, 0x1a, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x5f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x2e, 0x50, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x05, 0x52, 0x18, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x28,
	0x0a, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18,
	0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x52, 0x0a, 0x0a, 0x69, 0x70, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x50, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x09,
	0x69, 0x70, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x1a, 0x4b, 0x0a, 0x1d,
	0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x69, 0x70,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x7e, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12,
	0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x43,
	0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c,
	0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x45, 0x5f, 0x52, 0x45, 0x50, 0x41, 0x49, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x14, 0x0a,
	0x10, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x41, 0x49, 0x52, 0x49, 0x4e,
	0x47, 0x10, 0x06, 0x3a, 0x9f, 0x01, 0xea, 0x41, 0x9b, 0x01, 0x0a, 0x3a, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x5d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x7d, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x65, 0x74, 0x61, 0x67, 0x22, 0xd8,
	0x01, 0x0a, 0x24, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19,
	0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xef, 0x01, 0x0a, 0x25, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x7c, 0x0a, 0x1b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x19, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72,
	0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x7b, 0x0a, 0x21, 0x47,
	0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x56, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x42,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3c, 0x0a, 0x3a, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xeb, 0x02, 0x0a, 0x24, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x5a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x42, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3c, 0x12, 0x3a, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x44, 0x0a,
	0x1c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x19, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x49, 0x64, 0x12, 0x7d, 0x0a, 0x19, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x17, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x8b, 0x02, 0x0a, 0x24, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x6b, 0x12, 0x7d, 0x0a, 0x19, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x17, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x49, 0x64, 0x22, 0xc9, 0x01, 0x0a, 0x24, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x56, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x42, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x3c, 0x0a, 0x3a, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x04, 0x65, 0x74, 0x61,
	0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x04,
	0x65, 0x74, 0x61, 0x67, 0x88, 0x01, 0x01, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x65, 0x74, 0x61, 0x67,
	0x22, 0xae, 0x04, 0x0a, 0x0c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x55, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x2e, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12,
	0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x1c, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x88, 0x01, 0x01, 0x1a,
	0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x7c, 0xea, 0x41, 0x79, 0x0a,
	0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73,
	0x12, 0x46, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x7d, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x65, 0x74, 0x61,
	0x67, 0x22, 0xcd, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f,
	0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42,
	0x79, 0x22, 0xc2, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x5a, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73,
	0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x0e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61,
	0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x65, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xde, 0x01,
	0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x5b, 0x0a,
	0x0d, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xb3,
	0x01, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x31, 0x0a, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6c,
	0x61, 0x73, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x1c, 0x0a,
	0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x00, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x88, 0x01, 0x01, 0x42, 0x07, 0x0a, 0x05, 0x5f,
	0x65, 0x74, 0x61, 0x67, 0x22, 0xd4, 0x05, 0x0a, 0x16, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5f, 0x0a, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x20, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x3d, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x23, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x19,
	0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x65, 0x78, 0x70,
	0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x04, 0x65,
	0x74, 0x61, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00,
	0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x88, 0x01, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x3a, 0x9b, 0x01, 0xea, 0x41, 0x97, 0x01, 0x0a, 0x39, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x5a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x7d, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x65, 0x74, 0x61, 0x67, 0x22, 0xd6, 0x01, 0x0a, 0x22,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x42, 0x79, 0x22, 0xe8, 0x01, 0x0a, 0x23, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x77, 0x0a, 0x19,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x17, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a,
	0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22,
	0x79, 0x0a, 0x20, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x41, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3b, 0x0a, 0x39, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe4, 0x02, 0x0a, 0x23, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x59, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x41, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3b, 0x12, 0x39, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x42, 0x0a,
	0x1b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x49,
	0x64, 0x12, 0x7a, 0x0a, 0x18, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x16, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x22, 0x0a,
	0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49,
	0x64, 0x22, 0xc7, 0x01, 0x0a, 0x23, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x41, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3b, 0x0a,
	0x39, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x88,
	0x01, 0x01, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x65, 0x74, 0x61, 0x67, 0x2a, 0x39, 0x0a, 0x0e, 0x49,
	0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x1e, 0x0a,
	0x1a, 0x49, 0x4e, 0x46, 0x52, 0x41, 0x53, 0x54, 0x52, 0x55, 0x43, 0x54, 0x55, 0x52, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a,
	0x03, 0x50, 0x53, 0x43, 0x10, 0x01, 0x2a, 0x82, 0x01, 0x0a, 0x13, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x25,
	0x0a, 0x21, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x52, 0x52,
	0x4f, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x49,
	0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x45, 0x52, 0x52,
	0x4f, 0x52, 0x5f, 0x43, 0x4f, 0x4e, 0x53, 0x55, 0x4d, 0x45, 0x52, 0x5f, 0x53, 0x49, 0x44, 0x45,
	0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x50, 0x52, 0x4f, 0x44,
	0x55, 0x43, 0x45, 0x52, 0x5f, 0x53, 0x49, 0x44, 0x45, 0x10, 0x03, 0x2a, 0x3b, 0x0a, 0x09, 0x49,
	0x50, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x16, 0x49, 0x50, 0x5f, 0x56,
	0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x49, 0x50, 0x56, 0x34, 0x10, 0x01, 0x12, 0x08,
	0x0a, 0x04, 0x49, 0x50, 0x56, 0x36, 0x10, 0x02, 0x32, 0x88, 0x27, 0x0a, 0x1d, 0x43, 0x72, 0x6f,
	0x73, 0x73, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xf6, 0x01, 0x0a, 0x19, 0x4c,
	0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x73, 0x12, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x61, 0x70, 0x73, 0x12, 0xe3, 0x01, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x12,
	0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x22,
	0x48, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12, 0x39,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc5, 0x02, 0x0a, 0x1a, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xbf, 0x01, 0xca, 0x41, 0x29, 0x0a, 0x14, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x37, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x70, 0x2c, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6d, 0x61, 0x70, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x53, 0x3a, 0x16,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x70, 0x22, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70,
	0x73, 0x12, 0xc7, 0x02, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70,
	0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61,
	0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc1, 0x01, 0xca, 0x41, 0x29, 0x0a, 0x14, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x61, 0x70, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x22, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x70, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x6a, 0x3a, 0x16, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x70, 0x32, 0x50, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x70, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xfa, 0x01, 0x0a, 0x1a,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x75, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x2a, 0x39, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x61, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x86, 0x02, 0x0a, 0x1d, 0x4c, 0x69, 0x73,
	0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x49, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x4e, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3f, 0x12, 0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65,
	0x73, 0x12, 0xf0, 0x01, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x4c, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x12, 0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xdb, 0x02, 0x0a, 0x1d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0xcf, 0x01, 0xca, 0x41, 0x2c, 0x0a, 0x17, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x3d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f,
	0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5a, 0x3a, 0x19, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x22, 0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x12, 0xdd, 0x02, 0x0a, 0x1d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xd1,
	0x01, 0xca, 0x41, 0x2c, 0x0a, 0x17, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x25, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2c, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x74, 0x3a, 0x19,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x32, 0x57, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0x84, 0x02, 0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x79,
	0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x2a, 0x3d, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xda, 0x01, 0x0a, 0x12, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73,
	0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x43, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x12, 0xc4, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x22, 0x41, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x8d, 0x02,
	0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x97, 0x01, 0xca, 0x41, 0x21, 0x0a, 0x0c, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x19, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x51, 0x3a, 0x0d, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x32, 0x40, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe3, 0x01,
	0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x6e, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x2a,
	0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xeb, 0x01, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x4a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xfe, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x73, 0x12, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x48, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4c, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x73, 0x12, 0xd3, 0x02, 0x0a, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc9, 0x01, 0xca,
	0x41, 0x2b, 0x0a, 0x16, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x3b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x2c,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x57, 0x3a, 0x18, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x3b, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x12, 0x80, 0x02, 0x0a, 0x1c, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x77, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x2a, 0x3b,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x56, 0xca, 0x41, 0x22,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x42, 0xcf, 0x02, 0xea, 0x41, 0x34, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x12, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x0a, 0x27, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x42, 0x1b, 0x43, 0x72, 0x6f, 0x73, 0x73, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x59, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x31, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x70, 0x62, 0x3b, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x70, 0x62,
	0xaa, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x26, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescOnce sync.Once
	file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescData = file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDesc
)

func file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescGZIP() []byte {
	file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescOnce.Do(func() {
		file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescData)
	})
	return file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDescData
}

var file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes = make([]protoimpl.MessageInfo, 39)
var file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_goTypes = []any{
	(Infrastructure)(0),      // 0: google.cloud.networkconnectivity.v1.Infrastructure
	(ConnectionErrorType)(0), // 1: google.cloud.networkconnectivity.v1.ConnectionErrorType
	(IPVersion)(0),           // 2: google.cloud.networkconnectivity.v1.IPVersion
	(ServiceConnectionMap_ConsumerPscConfig_State)(0),               // 3: google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConfig.State
	(ServiceConnectionMap_ConsumerPscConnection_State)(0),           // 4: google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConnection.State
	(ServiceConnectionPolicy_State)(0),                              // 5: google.cloud.networkconnectivity.v1.ServiceConnectionPolicy.State
	(ServiceConnectionPolicy_PscConfig_ProducerInstanceLocation)(0), // 6: google.cloud.networkconnectivity.v1.ServiceConnectionPolicy.PscConfig.ProducerInstanceLocation
	(*ServiceConnectionMap)(nil),                                    // 7: google.cloud.networkconnectivity.v1.ServiceConnectionMap
	(*ListServiceConnectionMapsRequest)(nil),                        // 8: google.cloud.networkconnectivity.v1.ListServiceConnectionMapsRequest
	(*ListServiceConnectionMapsResponse)(nil),                       // 9: google.cloud.networkconnectivity.v1.ListServiceConnectionMapsResponse
	(*GetServiceConnectionMapRequest)(nil),                          // 10: google.cloud.networkconnectivity.v1.GetServiceConnectionMapRequest
	(*CreateServiceConnectionMapRequest)(nil),                       // 11: google.cloud.networkconnectivity.v1.CreateServiceConnectionMapRequest
	(*UpdateServiceConnectionMapRequest)(nil),                       // 12: google.cloud.networkconnectivity.v1.UpdateServiceConnectionMapRequest
	(*DeleteServiceConnectionMapRequest)(nil),                       // 13: google.cloud.networkconnectivity.v1.DeleteServiceConnectionMapRequest
	(*ServiceConnectionPolicy)(nil),                                 // 14: google.cloud.networkconnectivity.v1.ServiceConnectionPolicy
	(*ListServiceConnectionPoliciesRequest)(nil),                    // 15: google.cloud.networkconnectivity.v1.ListServiceConnectionPoliciesRequest
	(*ListServiceConnectionPoliciesResponse)(nil),                   // 16: google.cloud.networkconnectivity.v1.ListServiceConnectionPoliciesResponse
	(*GetServiceConnectionPolicyRequest)(nil),                       // 17: google.cloud.networkconnectivity.v1.GetServiceConnectionPolicyRequest
	(*CreateServiceConnectionPolicyRequest)(nil),                    // 18: google.cloud.networkconnectivity.v1.CreateServiceConnectionPolicyRequest
	(*UpdateServiceConnectionPolicyRequest)(nil),                    // 19: google.cloud.networkconnectivity.v1.UpdateServiceConnectionPolicyRequest
	(*DeleteServiceConnectionPolicyRequest)(nil),                    // 20: google.cloud.networkconnectivity.v1.DeleteServiceConnectionPolicyRequest
	(*ServiceClass)(nil),                                            // 21: google.cloud.networkconnectivity.v1.ServiceClass
	(*ListServiceClassesRequest)(nil),                               // 22: google.cloud.networkconnectivity.v1.ListServiceClassesRequest
	(*ListServiceClassesResponse)(nil),                              // 23: google.cloud.networkconnectivity.v1.ListServiceClassesResponse
	(*GetServiceClassRequest)(nil),                                  // 24: google.cloud.networkconnectivity.v1.GetServiceClassRequest
	(*UpdateServiceClassRequest)(nil),                               // 25: google.cloud.networkconnectivity.v1.UpdateServiceClassRequest
	(*DeleteServiceClassRequest)(nil),                               // 26: google.cloud.networkconnectivity.v1.DeleteServiceClassRequest
	(*ServiceConnectionToken)(nil),                                  // 27: google.cloud.networkconnectivity.v1.ServiceConnectionToken
	(*ListServiceConnectionTokensRequest)(nil),                      // 28: google.cloud.networkconnectivity.v1.ListServiceConnectionTokensRequest
	(*ListServiceConnectionTokensResponse)(nil),                     // 29: google.cloud.networkconnectivity.v1.ListServiceConnectionTokensResponse
	(*GetServiceConnectionTokenRequest)(nil),                        // 30: google.cloud.networkconnectivity.v1.GetServiceConnectionTokenRequest
	(*CreateServiceConnectionTokenRequest)(nil),                     // 31: google.cloud.networkconnectivity.v1.CreateServiceConnectionTokenRequest
	(*DeleteServiceConnectionTokenRequest)(nil),                     // 32: google.cloud.networkconnectivity.v1.DeleteServiceConnectionTokenRequest
	(*ServiceConnectionMap_ProducerPscConfig)(nil),                  // 33: google.cloud.networkconnectivity.v1.ServiceConnectionMap.ProducerPscConfig
	(*ServiceConnectionMap_ConsumerPscConfig)(nil),                  // 34: google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConfig
	(*ServiceConnectionMap_ConsumerPscConnection)(nil),              // 35: google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConnection
	nil, // 36: google.cloud.networkconnectivity.v1.ServiceConnectionMap.LabelsEntry
	nil, // 37: google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConfig.ServiceAttachmentIpAddressMapEntry
	nil, // 38: google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConfig.ProducerInstanceMetadataEntry
	nil, // 39: google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConnection.ProducerInstanceMetadataEntry
	(*ServiceConnectionPolicy_PscConfig)(nil),     // 40: google.cloud.networkconnectivity.v1.ServiceConnectionPolicy.PscConfig
	(*ServiceConnectionPolicy_PscConnection)(nil), // 41: google.cloud.networkconnectivity.v1.ServiceConnectionPolicy.PscConnection
	nil,                             // 42: google.cloud.networkconnectivity.v1.ServiceConnectionPolicy.LabelsEntry
	nil,                             // 43: google.cloud.networkconnectivity.v1.ServiceConnectionPolicy.PscConnection.ProducerInstanceMetadataEntry
	nil,                             // 44: google.cloud.networkconnectivity.v1.ServiceClass.LabelsEntry
	nil,                             // 45: google.cloud.networkconnectivity.v1.ServiceConnectionToken.LabelsEntry
	(*timestamppb.Timestamp)(nil),   // 46: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),   // 47: google.protobuf.FieldMask
	(*status.Status)(nil),           // 48: google.rpc.Status
	(*errdetails.ErrorInfo)(nil),    // 49: google.rpc.ErrorInfo
	(*longrunningpb.Operation)(nil), // 50: google.longrunning.Operation
}
var file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_depIdxs = []int32{
	46, // 0: google.cloud.networkconnectivity.v1.ServiceConnectionMap.create_time:type_name -> google.protobuf.Timestamp
	46, // 1: google.cloud.networkconnectivity.v1.ServiceConnectionMap.update_time:type_name -> google.protobuf.Timestamp
	36, // 2: google.cloud.networkconnectivity.v1.ServiceConnectionMap.labels:type_name -> google.cloud.networkconnectivity.v1.ServiceConnectionMap.LabelsEntry
	0,  // 3: google.cloud.networkconnectivity.v1.ServiceConnectionMap.infrastructure:type_name -> google.cloud.networkconnectivity.v1.Infrastructure
	33, // 4: google.cloud.networkconnectivity.v1.ServiceConnectionMap.producer_psc_configs:type_name -> google.cloud.networkconnectivity.v1.ServiceConnectionMap.ProducerPscConfig
	34, // 5: google.cloud.networkconnectivity.v1.ServiceConnectionMap.consumer_psc_configs:type_name -> google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConfig
	35, // 6: google.cloud.networkconnectivity.v1.ServiceConnectionMap.consumer_psc_connections:type_name -> google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConnection
	7,  // 7: google.cloud.networkconnectivity.v1.ListServiceConnectionMapsResponse.service_connection_maps:type_name -> google.cloud.networkconnectivity.v1.ServiceConnectionMap
	7,  // 8: google.cloud.networkconnectivity.v1.CreateServiceConnectionMapRequest.service_connection_map:type_name -> google.cloud.networkconnectivity.v1.ServiceConnectionMap
	47, // 9: google.cloud.networkconnectivity.v1.UpdateServiceConnectionMapRequest.update_mask:type_name -> google.protobuf.FieldMask
	7,  // 10: google.cloud.networkconnectivity.v1.UpdateServiceConnectionMapRequest.service_connection_map:type_name -> google.cloud.networkconnectivity.v1.ServiceConnectionMap
	46, // 11: google.cloud.networkconnectivity.v1.ServiceConnectionPolicy.create_time:type_name -> google.protobuf.Timestamp
	46, // 12: google.cloud.networkconnectivity.v1.ServiceConnectionPolicy.update_time:type_name -> google.protobuf.Timestamp
	42, // 13: google.cloud.networkconnectivity.v1.ServiceConnectionPolicy.labels:type_name -> google.cloud.networkconnectivity.v1.ServiceConnectionPolicy.LabelsEntry
	0,  // 14: google.cloud.networkconnectivity.v1.ServiceConnectionPolicy.infrastructure:type_name -> google.cloud.networkconnectivity.v1.Infrastructure
	40, // 15: google.cloud.networkconnectivity.v1.ServiceConnectionPolicy.psc_config:type_name -> google.cloud.networkconnectivity.v1.ServiceConnectionPolicy.PscConfig
	41, // 16: google.cloud.networkconnectivity.v1.ServiceConnectionPolicy.psc_connections:type_name -> google.cloud.networkconnectivity.v1.ServiceConnectionPolicy.PscConnection
	14, // 17: google.cloud.networkconnectivity.v1.ListServiceConnectionPoliciesResponse.service_connection_policies:type_name -> google.cloud.networkconnectivity.v1.ServiceConnectionPolicy
	14, // 18: google.cloud.networkconnectivity.v1.CreateServiceConnectionPolicyRequest.service_connection_policy:type_name -> google.cloud.networkconnectivity.v1.ServiceConnectionPolicy
	47, // 19: google.cloud.networkconnectivity.v1.UpdateServiceConnectionPolicyRequest.update_mask:type_name -> google.protobuf.FieldMask
	14, // 20: google.cloud.networkconnectivity.v1.UpdateServiceConnectionPolicyRequest.service_connection_policy:type_name -> google.cloud.networkconnectivity.v1.ServiceConnectionPolicy
	46, // 21: google.cloud.networkconnectivity.v1.ServiceClass.create_time:type_name -> google.protobuf.Timestamp
	46, // 22: google.cloud.networkconnectivity.v1.ServiceClass.update_time:type_name -> google.protobuf.Timestamp
	44, // 23: google.cloud.networkconnectivity.v1.ServiceClass.labels:type_name -> google.cloud.networkconnectivity.v1.ServiceClass.LabelsEntry
	21, // 24: google.cloud.networkconnectivity.v1.ListServiceClassesResponse.service_classes:type_name -> google.cloud.networkconnectivity.v1.ServiceClass
	47, // 25: google.cloud.networkconnectivity.v1.UpdateServiceClassRequest.update_mask:type_name -> google.protobuf.FieldMask
	21, // 26: google.cloud.networkconnectivity.v1.UpdateServiceClassRequest.service_class:type_name -> google.cloud.networkconnectivity.v1.ServiceClass
	46, // 27: google.cloud.networkconnectivity.v1.ServiceConnectionToken.create_time:type_name -> google.protobuf.Timestamp
	46, // 28: google.cloud.networkconnectivity.v1.ServiceConnectionToken.update_time:type_name -> google.protobuf.Timestamp
	45, // 29: google.cloud.networkconnectivity.v1.ServiceConnectionToken.labels:type_name -> google.cloud.networkconnectivity.v1.ServiceConnectionToken.LabelsEntry
	46, // 30: google.cloud.networkconnectivity.v1.ServiceConnectionToken.expire_time:type_name -> google.protobuf.Timestamp
	27, // 31: google.cloud.networkconnectivity.v1.ListServiceConnectionTokensResponse.service_connection_tokens:type_name -> google.cloud.networkconnectivity.v1.ServiceConnectionToken
	27, // 32: google.cloud.networkconnectivity.v1.CreateServiceConnectionTokenRequest.service_connection_token:type_name -> google.cloud.networkconnectivity.v1.ServiceConnectionToken
	3,  // 33: google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConfig.state:type_name -> google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConfig.State
	37, // 34: google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConfig.service_attachment_ip_address_map:type_name -> google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConfig.ServiceAttachmentIpAddressMapEntry
	38, // 35: google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConfig.producer_instance_metadata:type_name -> google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConfig.ProducerInstanceMetadataEntry
	2,  // 36: google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConfig.ip_version:type_name -> google.cloud.networkconnectivity.v1.IPVersion
	4,  // 37: google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConnection.state:type_name -> google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConnection.State
	1,  // 38: google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConnection.error_type:type_name -> google.cloud.networkconnectivity.v1.ConnectionErrorType
	48, // 39: google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConnection.error:type_name -> google.rpc.Status
	49, // 40: google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConnection.error_info:type_name -> google.rpc.ErrorInfo
	39, // 41: google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConnection.producer_instance_metadata:type_name -> google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConnection.ProducerInstanceMetadataEntry
	2,  // 42: google.cloud.networkconnectivity.v1.ServiceConnectionMap.ConsumerPscConnection.ip_version:type_name -> google.cloud.networkconnectivity.v1.IPVersion
	6,  // 43: google.cloud.networkconnectivity.v1.ServiceConnectionPolicy.PscConfig.producer_instance_location:type_name -> google.cloud.networkconnectivity.v1.ServiceConnectionPolicy.PscConfig.ProducerInstanceLocation
	5,  // 44: google.cloud.networkconnectivity.v1.ServiceConnectionPolicy.PscConnection.state:type_name -> google.cloud.networkconnectivity.v1.ServiceConnectionPolicy.State
	1,  // 45: google.cloud.networkconnectivity.v1.ServiceConnectionPolicy.PscConnection.error_type:type_name -> google.cloud.networkconnectivity.v1.ConnectionErrorType
	48, // 46: google.cloud.networkconnectivity.v1.ServiceConnectionPolicy.PscConnection.error:type_name -> google.rpc.Status
	49, // 47: google.cloud.networkconnectivity.v1.ServiceConnectionPolicy.PscConnection.error_info:type_name -> google.rpc.ErrorInfo
	43, // 48: google.cloud.networkconnectivity.v1.ServiceConnectionPolicy.PscConnection.producer_instance_metadata:type_name -> google.cloud.networkconnectivity.v1.ServiceConnectionPolicy.PscConnection.ProducerInstanceMetadataEntry
	2,  // 49: google.cloud.networkconnectivity.v1.ServiceConnectionPolicy.PscConnection.ip_version:type_name -> google.cloud.networkconnectivity.v1.IPVersion
	8,  // 50: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.ListServiceConnectionMaps:input_type -> google.cloud.networkconnectivity.v1.ListServiceConnectionMapsRequest
	10, // 51: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.GetServiceConnectionMap:input_type -> google.cloud.networkconnectivity.v1.GetServiceConnectionMapRequest
	11, // 52: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.CreateServiceConnectionMap:input_type -> google.cloud.networkconnectivity.v1.CreateServiceConnectionMapRequest
	12, // 53: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.UpdateServiceConnectionMap:input_type -> google.cloud.networkconnectivity.v1.UpdateServiceConnectionMapRequest
	13, // 54: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.DeleteServiceConnectionMap:input_type -> google.cloud.networkconnectivity.v1.DeleteServiceConnectionMapRequest
	15, // 55: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.ListServiceConnectionPolicies:input_type -> google.cloud.networkconnectivity.v1.ListServiceConnectionPoliciesRequest
	17, // 56: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.GetServiceConnectionPolicy:input_type -> google.cloud.networkconnectivity.v1.GetServiceConnectionPolicyRequest
	18, // 57: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.CreateServiceConnectionPolicy:input_type -> google.cloud.networkconnectivity.v1.CreateServiceConnectionPolicyRequest
	19, // 58: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.UpdateServiceConnectionPolicy:input_type -> google.cloud.networkconnectivity.v1.UpdateServiceConnectionPolicyRequest
	20, // 59: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.DeleteServiceConnectionPolicy:input_type -> google.cloud.networkconnectivity.v1.DeleteServiceConnectionPolicyRequest
	22, // 60: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.ListServiceClasses:input_type -> google.cloud.networkconnectivity.v1.ListServiceClassesRequest
	24, // 61: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.GetServiceClass:input_type -> google.cloud.networkconnectivity.v1.GetServiceClassRequest
	25, // 62: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.UpdateServiceClass:input_type -> google.cloud.networkconnectivity.v1.UpdateServiceClassRequest
	26, // 63: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.DeleteServiceClass:input_type -> google.cloud.networkconnectivity.v1.DeleteServiceClassRequest
	30, // 64: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.GetServiceConnectionToken:input_type -> google.cloud.networkconnectivity.v1.GetServiceConnectionTokenRequest
	28, // 65: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.ListServiceConnectionTokens:input_type -> google.cloud.networkconnectivity.v1.ListServiceConnectionTokensRequest
	31, // 66: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.CreateServiceConnectionToken:input_type -> google.cloud.networkconnectivity.v1.CreateServiceConnectionTokenRequest
	32, // 67: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.DeleteServiceConnectionToken:input_type -> google.cloud.networkconnectivity.v1.DeleteServiceConnectionTokenRequest
	9,  // 68: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.ListServiceConnectionMaps:output_type -> google.cloud.networkconnectivity.v1.ListServiceConnectionMapsResponse
	7,  // 69: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.GetServiceConnectionMap:output_type -> google.cloud.networkconnectivity.v1.ServiceConnectionMap
	50, // 70: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.CreateServiceConnectionMap:output_type -> google.longrunning.Operation
	50, // 71: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.UpdateServiceConnectionMap:output_type -> google.longrunning.Operation
	50, // 72: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.DeleteServiceConnectionMap:output_type -> google.longrunning.Operation
	16, // 73: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.ListServiceConnectionPolicies:output_type -> google.cloud.networkconnectivity.v1.ListServiceConnectionPoliciesResponse
	14, // 74: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.GetServiceConnectionPolicy:output_type -> google.cloud.networkconnectivity.v1.ServiceConnectionPolicy
	50, // 75: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.CreateServiceConnectionPolicy:output_type -> google.longrunning.Operation
	50, // 76: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.UpdateServiceConnectionPolicy:output_type -> google.longrunning.Operation
	50, // 77: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.DeleteServiceConnectionPolicy:output_type -> google.longrunning.Operation
	23, // 78: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.ListServiceClasses:output_type -> google.cloud.networkconnectivity.v1.ListServiceClassesResponse
	21, // 79: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.GetServiceClass:output_type -> google.cloud.networkconnectivity.v1.ServiceClass
	50, // 80: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.UpdateServiceClass:output_type -> google.longrunning.Operation
	50, // 81: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.DeleteServiceClass:output_type -> google.longrunning.Operation
	27, // 82: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.GetServiceConnectionToken:output_type -> google.cloud.networkconnectivity.v1.ServiceConnectionToken
	29, // 83: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.ListServiceConnectionTokens:output_type -> google.cloud.networkconnectivity.v1.ListServiceConnectionTokensResponse
	50, // 84: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.CreateServiceConnectionToken:output_type -> google.longrunning.Operation
	50, // 85: google.cloud.networkconnectivity.v1.CrossNetworkAutomationService.DeleteServiceConnectionToken:output_type -> google.longrunning.Operation
	68, // [68:86] is the sub-list for method output_type
	50, // [50:68] is the sub-list for method input_type
	50, // [50:50] is the sub-list for extension type_name
	50, // [50:50] is the sub-list for extension extendee
	0,  // [0:50] is the sub-list for field type_name
}

func init() { file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_init() }
func file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_init() {
	if File_google_cloud_networkconnectivity_v1_cross_network_automation_proto != nil {
		return
	}
	file_google_cloud_networkconnectivity_v1_common_proto_init()
	file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[0].OneofWrappers = []any{}
	file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[6].OneofWrappers = []any{}
	file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[7].OneofWrappers = []any{}
	file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[13].OneofWrappers = []any{}
	file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[14].OneofWrappers = []any{}
	file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[19].OneofWrappers = []any{}
	file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[20].OneofWrappers = []any{}
	file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[25].OneofWrappers = []any{}
	file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[27].OneofWrappers = []any{}
	file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[28].OneofWrappers = []any{}
	file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[33].OneofWrappers = []any{}
	file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes[34].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDesc,
			NumEnums:      7,
			NumMessages:   39,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_goTypes,
		DependencyIndexes: file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_depIdxs,
		EnumInfos:         file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_enumTypes,
		MessageInfos:      file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_msgTypes,
	}.Build()
	File_google_cloud_networkconnectivity_v1_cross_network_automation_proto = out.File
	file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_rawDesc = nil
	file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_goTypes = nil
	file_google_cloud_networkconnectivity_v1_cross_network_automation_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CrossNetworkAutomationServiceClient is the client API for CrossNetworkAutomationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CrossNetworkAutomationServiceClient interface {
	// Lists ServiceConnectionMaps in a given project and location.
	ListServiceConnectionMaps(ctx context.Context, in *ListServiceConnectionMapsRequest, opts ...grpc.CallOption) (*ListServiceConnectionMapsResponse, error)
	// Gets details of a single ServiceConnectionMap.
	GetServiceConnectionMap(ctx context.Context, in *GetServiceConnectionMapRequest, opts ...grpc.CallOption) (*ServiceConnectionMap, error)
	// Creates a new ServiceConnectionMap in a given project and location.
	CreateServiceConnectionMap(ctx context.Context, in *CreateServiceConnectionMapRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single ServiceConnectionMap.
	UpdateServiceConnectionMap(ctx context.Context, in *UpdateServiceConnectionMapRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single ServiceConnectionMap.
	DeleteServiceConnectionMap(ctx context.Context, in *DeleteServiceConnectionMapRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists ServiceConnectionPolicies in a given project and location.
	ListServiceConnectionPolicies(ctx context.Context, in *ListServiceConnectionPoliciesRequest, opts ...grpc.CallOption) (*ListServiceConnectionPoliciesResponse, error)
	// Gets details of a single ServiceConnectionPolicy.
	GetServiceConnectionPolicy(ctx context.Context, in *GetServiceConnectionPolicyRequest, opts ...grpc.CallOption) (*ServiceConnectionPolicy, error)
	// Creates a new ServiceConnectionPolicy in a given project and location.
	CreateServiceConnectionPolicy(ctx context.Context, in *CreateServiceConnectionPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single ServiceConnectionPolicy.
	UpdateServiceConnectionPolicy(ctx context.Context, in *UpdateServiceConnectionPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single ServiceConnectionPolicy.
	DeleteServiceConnectionPolicy(ctx context.Context, in *DeleteServiceConnectionPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists ServiceClasses in a given project and location.
	ListServiceClasses(ctx context.Context, in *ListServiceClassesRequest, opts ...grpc.CallOption) (*ListServiceClassesResponse, error)
	// Gets details of a single ServiceClass.
	GetServiceClass(ctx context.Context, in *GetServiceClassRequest, opts ...grpc.CallOption) (*ServiceClass, error)
	// Updates the parameters of a single ServiceClass.
	UpdateServiceClass(ctx context.Context, in *UpdateServiceClassRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single ServiceClass.
	DeleteServiceClass(ctx context.Context, in *DeleteServiceClassRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details of a single ServiceConnectionToken.
	GetServiceConnectionToken(ctx context.Context, in *GetServiceConnectionTokenRequest, opts ...grpc.CallOption) (*ServiceConnectionToken, error)
	// Lists ServiceConnectionTokens in a given project and location.
	ListServiceConnectionTokens(ctx context.Context, in *ListServiceConnectionTokensRequest, opts ...grpc.CallOption) (*ListServiceConnectionTokensResponse, error)
	// Creates a new ServiceConnectionToken in a given project and location.
	CreateServiceConnectionToken(ctx context.Context, in *CreateServiceConnectionTokenRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single ServiceConnectionToken.
	DeleteServiceConnectionToken(ctx context.Context, in *DeleteServiceConnectionTokenRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type crossNetworkAutomationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCrossNetworkAutomationServiceClient(cc grpc.ClientConnInterface) CrossNetworkAutomationServiceClient {
	return &crossNetworkAutomationServiceClient{cc}
}

func (c *crossNetworkAutomationServiceClient) ListServiceConnectionMaps(ctx context.Context, in *ListServiceConnectionMapsRequest, opts ...grpc.CallOption) (*ListServiceConnectionMapsResponse, error) {
	out := new(ListServiceConnectionMapsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/ListServiceConnectionMaps", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) GetServiceConnectionMap(ctx context.Context, in *GetServiceConnectionMapRequest, opts ...grpc.CallOption) (*ServiceConnectionMap, error) {
	out := new(ServiceConnectionMap)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/GetServiceConnectionMap", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) CreateServiceConnectionMap(ctx context.Context, in *CreateServiceConnectionMapRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/CreateServiceConnectionMap", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) UpdateServiceConnectionMap(ctx context.Context, in *UpdateServiceConnectionMapRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/UpdateServiceConnectionMap", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) DeleteServiceConnectionMap(ctx context.Context, in *DeleteServiceConnectionMapRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/DeleteServiceConnectionMap", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) ListServiceConnectionPolicies(ctx context.Context, in *ListServiceConnectionPoliciesRequest, opts ...grpc.CallOption) (*ListServiceConnectionPoliciesResponse, error) {
	out := new(ListServiceConnectionPoliciesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/ListServiceConnectionPolicies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) GetServiceConnectionPolicy(ctx context.Context, in *GetServiceConnectionPolicyRequest, opts ...grpc.CallOption) (*ServiceConnectionPolicy, error) {
	out := new(ServiceConnectionPolicy)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/GetServiceConnectionPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) CreateServiceConnectionPolicy(ctx context.Context, in *CreateServiceConnectionPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/CreateServiceConnectionPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) UpdateServiceConnectionPolicy(ctx context.Context, in *UpdateServiceConnectionPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/UpdateServiceConnectionPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) DeleteServiceConnectionPolicy(ctx context.Context, in *DeleteServiceConnectionPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/DeleteServiceConnectionPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) ListServiceClasses(ctx context.Context, in *ListServiceClassesRequest, opts ...grpc.CallOption) (*ListServiceClassesResponse, error) {
	out := new(ListServiceClassesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/ListServiceClasses", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) GetServiceClass(ctx context.Context, in *GetServiceClassRequest, opts ...grpc.CallOption) (*ServiceClass, error) {
	out := new(ServiceClass)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/GetServiceClass", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) UpdateServiceClass(ctx context.Context, in *UpdateServiceClassRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/UpdateServiceClass", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) DeleteServiceClass(ctx context.Context, in *DeleteServiceClassRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/DeleteServiceClass", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) GetServiceConnectionToken(ctx context.Context, in *GetServiceConnectionTokenRequest, opts ...grpc.CallOption) (*ServiceConnectionToken, error) {
	out := new(ServiceConnectionToken)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/GetServiceConnectionToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) ListServiceConnectionTokens(ctx context.Context, in *ListServiceConnectionTokensRequest, opts ...grpc.CallOption) (*ListServiceConnectionTokensResponse, error) {
	out := new(ListServiceConnectionTokensResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/ListServiceConnectionTokens", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) CreateServiceConnectionToken(ctx context.Context, in *CreateServiceConnectionTokenRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/CreateServiceConnectionToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) DeleteServiceConnectionToken(ctx context.Context, in *DeleteServiceConnectionTokenRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/DeleteServiceConnectionToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CrossNetworkAutomationServiceServer is the server API for CrossNetworkAutomationService service.
type CrossNetworkAutomationServiceServer interface {
	// Lists ServiceConnectionMaps in a given project and location.
	ListServiceConnectionMaps(context.Context, *ListServiceConnectionMapsRequest) (*ListServiceConnectionMapsResponse, error)
	// Gets details of a single ServiceConnectionMap.
	GetServiceConnectionMap(context.Context, *GetServiceConnectionMapRequest) (*ServiceConnectionMap, error)
	// Creates a new ServiceConnectionMap in a given project and location.
	CreateServiceConnectionMap(context.Context, *CreateServiceConnectionMapRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single ServiceConnectionMap.
	UpdateServiceConnectionMap(context.Context, *UpdateServiceConnectionMapRequest) (*longrunningpb.Operation, error)
	// Deletes a single ServiceConnectionMap.
	DeleteServiceConnectionMap(context.Context, *DeleteServiceConnectionMapRequest) (*longrunningpb.Operation, error)
	// Lists ServiceConnectionPolicies in a given project and location.
	ListServiceConnectionPolicies(context.Context, *ListServiceConnectionPoliciesRequest) (*ListServiceConnectionPoliciesResponse, error)
	// Gets details of a single ServiceConnectionPolicy.
	GetServiceConnectionPolicy(context.Context, *GetServiceConnectionPolicyRequest) (*ServiceConnectionPolicy, error)
	// Creates a new ServiceConnectionPolicy in a given project and location.
	CreateServiceConnectionPolicy(context.Context, *CreateServiceConnectionPolicyRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single ServiceConnectionPolicy.
	UpdateServiceConnectionPolicy(context.Context, *UpdateServiceConnectionPolicyRequest) (*longrunningpb.Operation, error)
	// Deletes a single ServiceConnectionPolicy.
	DeleteServiceConnectionPolicy(context.Context, *DeleteServiceConnectionPolicyRequest) (*longrunningpb.Operation, error)
	// Lists ServiceClasses in a given project and location.
	ListServiceClasses(context.Context, *ListServiceClassesRequest) (*ListServiceClassesResponse, error)
	// Gets details of a single ServiceClass.
	GetServiceClass(context.Context, *GetServiceClassRequest) (*ServiceClass, error)
	// Updates the parameters of a single ServiceClass.
	UpdateServiceClass(context.Context, *UpdateServiceClassRequest) (*longrunningpb.Operation, error)
	// Deletes a single ServiceClass.
	DeleteServiceClass(context.Context, *DeleteServiceClassRequest) (*longrunningpb.Operation, error)
	// Gets details of a single ServiceConnectionToken.
	GetServiceConnectionToken(context.Context, *GetServiceConnectionTokenRequest) (*ServiceConnectionToken, error)
	// Lists ServiceConnectionTokens in a given project and location.
	ListServiceConnectionTokens(context.Context, *ListServiceConnectionTokensRequest) (*ListServiceConnectionTokensResponse, error)
	// Creates a new ServiceConnectionToken in a given project and location.
	CreateServiceConnectionToken(context.Context, *CreateServiceConnectionTokenRequest) (*longrunningpb.Operation, error)
	// Deletes a single ServiceConnectionToken.
	DeleteServiceConnectionToken(context.Context, *DeleteServiceConnectionTokenRequest) (*longrunningpb.Operation, error)
}

// UnimplementedCrossNetworkAutomationServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCrossNetworkAutomationServiceServer struct {
}

func (*UnimplementedCrossNetworkAutomationServiceServer) ListServiceConnectionMaps(context.Context, *ListServiceConnectionMapsRequest) (*ListServiceConnectionMapsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListServiceConnectionMaps not implemented")
}
func (*UnimplementedCrossNetworkAutomationServiceServer) GetServiceConnectionMap(context.Context, *GetServiceConnectionMapRequest) (*ServiceConnectionMap, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetServiceConnectionMap not implemented")
}
func (*UnimplementedCrossNetworkAutomationServiceServer) CreateServiceConnectionMap(context.Context, *CreateServiceConnectionMapRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateServiceConnectionMap not implemented")
}
func (*UnimplementedCrossNetworkAutomationServiceServer) UpdateServiceConnectionMap(context.Context, *UpdateServiceConnectionMapRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateServiceConnectionMap not implemented")
}
func (*UnimplementedCrossNetworkAutomationServiceServer) DeleteServiceConnectionMap(context.Context, *DeleteServiceConnectionMapRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteServiceConnectionMap not implemented")
}
func (*UnimplementedCrossNetworkAutomationServiceServer) ListServiceConnectionPolicies(context.Context, *ListServiceConnectionPoliciesRequest) (*ListServiceConnectionPoliciesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListServiceConnectionPolicies not implemented")
}
func (*UnimplementedCrossNetworkAutomationServiceServer) GetServiceConnectionPolicy(context.Context, *GetServiceConnectionPolicyRequest) (*ServiceConnectionPolicy, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetServiceConnectionPolicy not implemented")
}
func (*UnimplementedCrossNetworkAutomationServiceServer) CreateServiceConnectionPolicy(context.Context, *CreateServiceConnectionPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateServiceConnectionPolicy not implemented")
}
func (*UnimplementedCrossNetworkAutomationServiceServer) UpdateServiceConnectionPolicy(context.Context, *UpdateServiceConnectionPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateServiceConnectionPolicy not implemented")
}
func (*UnimplementedCrossNetworkAutomationServiceServer) DeleteServiceConnectionPolicy(context.Context, *DeleteServiceConnectionPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteServiceConnectionPolicy not implemented")
}
func (*UnimplementedCrossNetworkAutomationServiceServer) ListServiceClasses(context.Context, *ListServiceClassesRequest) (*ListServiceClassesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListServiceClasses not implemented")
}
func (*UnimplementedCrossNetworkAutomationServiceServer) GetServiceClass(context.Context, *GetServiceClassRequest) (*ServiceClass, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetServiceClass not implemented")
}
func (*UnimplementedCrossNetworkAutomationServiceServer) UpdateServiceClass(context.Context, *UpdateServiceClassRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateServiceClass not implemented")
}
func (*UnimplementedCrossNetworkAutomationServiceServer) DeleteServiceClass(context.Context, *DeleteServiceClassRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteServiceClass not implemented")
}
func (*UnimplementedCrossNetworkAutomationServiceServer) GetServiceConnectionToken(context.Context, *GetServiceConnectionTokenRequest) (*ServiceConnectionToken, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetServiceConnectionToken not implemented")
}
func (*UnimplementedCrossNetworkAutomationServiceServer) ListServiceConnectionTokens(context.Context, *ListServiceConnectionTokensRequest) (*ListServiceConnectionTokensResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListServiceConnectionTokens not implemented")
}
func (*UnimplementedCrossNetworkAutomationServiceServer) CreateServiceConnectionToken(context.Context, *CreateServiceConnectionTokenRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateServiceConnectionToken not implemented")
}
func (*UnimplementedCrossNetworkAutomationServiceServer) DeleteServiceConnectionToken(context.Context, *DeleteServiceConnectionTokenRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteServiceConnectionToken not implemented")
}

func RegisterCrossNetworkAutomationServiceServer(s *grpc.Server, srv CrossNetworkAutomationServiceServer) {
	s.RegisterService(&_CrossNetworkAutomationService_serviceDesc, srv)
}

func _CrossNetworkAutomationService_ListServiceConnectionMaps_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServiceConnectionMapsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).ListServiceConnectionMaps(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/ListServiceConnectionMaps",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).ListServiceConnectionMaps(ctx, req.(*ListServiceConnectionMapsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_GetServiceConnectionMap_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceConnectionMapRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).GetServiceConnectionMap(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/GetServiceConnectionMap",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).GetServiceConnectionMap(ctx, req.(*GetServiceConnectionMapRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_CreateServiceConnectionMap_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceConnectionMapRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).CreateServiceConnectionMap(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/CreateServiceConnectionMap",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).CreateServiceConnectionMap(ctx, req.(*CreateServiceConnectionMapRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_UpdateServiceConnectionMap_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateServiceConnectionMapRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).UpdateServiceConnectionMap(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/UpdateServiceConnectionMap",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).UpdateServiceConnectionMap(ctx, req.(*UpdateServiceConnectionMapRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_DeleteServiceConnectionMap_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceConnectionMapRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).DeleteServiceConnectionMap(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/DeleteServiceConnectionMap",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).DeleteServiceConnectionMap(ctx, req.(*DeleteServiceConnectionMapRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_ListServiceConnectionPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServiceConnectionPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).ListServiceConnectionPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/ListServiceConnectionPolicies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).ListServiceConnectionPolicies(ctx, req.(*ListServiceConnectionPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_GetServiceConnectionPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceConnectionPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).GetServiceConnectionPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/GetServiceConnectionPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).GetServiceConnectionPolicy(ctx, req.(*GetServiceConnectionPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_CreateServiceConnectionPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceConnectionPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).CreateServiceConnectionPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/CreateServiceConnectionPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).CreateServiceConnectionPolicy(ctx, req.(*CreateServiceConnectionPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_UpdateServiceConnectionPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateServiceConnectionPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).UpdateServiceConnectionPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/UpdateServiceConnectionPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).UpdateServiceConnectionPolicy(ctx, req.(*UpdateServiceConnectionPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_DeleteServiceConnectionPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceConnectionPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).DeleteServiceConnectionPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/DeleteServiceConnectionPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).DeleteServiceConnectionPolicy(ctx, req.(*DeleteServiceConnectionPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_ListServiceClasses_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServiceClassesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).ListServiceClasses(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/ListServiceClasses",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).ListServiceClasses(ctx, req.(*ListServiceClassesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_GetServiceClass_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceClassRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).GetServiceClass(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/GetServiceClass",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).GetServiceClass(ctx, req.(*GetServiceClassRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_UpdateServiceClass_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateServiceClassRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).UpdateServiceClass(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/UpdateServiceClass",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).UpdateServiceClass(ctx, req.(*UpdateServiceClassRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_DeleteServiceClass_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceClassRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).DeleteServiceClass(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/DeleteServiceClass",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).DeleteServiceClass(ctx, req.(*DeleteServiceClassRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_GetServiceConnectionToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceConnectionTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).GetServiceConnectionToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/GetServiceConnectionToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).GetServiceConnectionToken(ctx, req.(*GetServiceConnectionTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_ListServiceConnectionTokens_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServiceConnectionTokensRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).ListServiceConnectionTokens(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/ListServiceConnectionTokens",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).ListServiceConnectionTokens(ctx, req.(*ListServiceConnectionTokensRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_CreateServiceConnectionToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceConnectionTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).CreateServiceConnectionToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/CreateServiceConnectionToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).CreateServiceConnectionToken(ctx, req.(*CreateServiceConnectionTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_DeleteServiceConnectionToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceConnectionTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).DeleteServiceConnectionToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/DeleteServiceConnectionToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).DeleteServiceConnectionToken(ctx, req.(*DeleteServiceConnectionTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CrossNetworkAutomationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.networkconnectivity.v1.CrossNetworkAutomationService",
	HandlerType: (*CrossNetworkAutomationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListServiceConnectionMaps",
			Handler:    _CrossNetworkAutomationService_ListServiceConnectionMaps_Handler,
		},
		{
			MethodName: "GetServiceConnectionMap",
			Handler:    _CrossNetworkAutomationService_GetServiceConnectionMap_Handler,
		},
		{
			MethodName: "CreateServiceConnectionMap",
			Handler:    _CrossNetworkAutomationService_CreateServiceConnectionMap_Handler,
		},
		{
			MethodName: "UpdateServiceConnectionMap",
			Handler:    _CrossNetworkAutomationService_UpdateServiceConnectionMap_Handler,
		},
		{
			MethodName: "DeleteServiceConnectionMap",
			Handler:    _CrossNetworkAutomationService_DeleteServiceConnectionMap_Handler,
		},
		{
			MethodName: "ListServiceConnectionPolicies",
			Handler:    _CrossNetworkAutomationService_ListServiceConnectionPolicies_Handler,
		},
		{
			MethodName: "GetServiceConnectionPolicy",
			Handler:    _CrossNetworkAutomationService_GetServiceConnectionPolicy_Handler,
		},
		{
			MethodName: "CreateServiceConnectionPolicy",
			Handler:    _CrossNetworkAutomationService_CreateServiceConnectionPolicy_Handler,
		},
		{
			MethodName: "UpdateServiceConnectionPolicy",
			Handler:    _CrossNetworkAutomationService_UpdateServiceConnectionPolicy_Handler,
		},
		{
			MethodName: "DeleteServiceConnectionPolicy",
			Handler:    _CrossNetworkAutomationService_DeleteServiceConnectionPolicy_Handler,
		},
		{
			MethodName: "ListServiceClasses",
			Handler:    _CrossNetworkAutomationService_ListServiceClasses_Handler,
		},
		{
			MethodName: "GetServiceClass",
			Handler:    _CrossNetworkAutomationService_GetServiceClass_Handler,
		},
		{
			MethodName: "UpdateServiceClass",
			Handler:    _CrossNetworkAutomationService_UpdateServiceClass_Handler,
		},
		{
			MethodName: "DeleteServiceClass",
			Handler:    _CrossNetworkAutomationService_DeleteServiceClass_Handler,
		},
		{
			MethodName: "GetServiceConnectionToken",
			Handler:    _CrossNetworkAutomationService_GetServiceConnectionToken_Handler,
		},
		{
			MethodName: "ListServiceConnectionTokens",
			Handler:    _CrossNetworkAutomationService_ListServiceConnectionTokens_Handler,
		},
		{
			MethodName: "CreateServiceConnectionToken",
			Handler:    _CrossNetworkAutomationService_CreateServiceConnectionToken_Handler,
		},
		{
			MethodName: "DeleteServiceConnectionToken",
			Handler:    _CrossNetworkAutomationService_DeleteServiceConnectionToken_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/networkconnectivity/v1/cross_network_automation.proto",
}
