// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/maps/places/v1/places_service.proto

package placespb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	viewport "google.golang.org/genproto/googleapis/geo/type/viewport"
	latlng "google.golang.org/genproto/googleapis/type/latlng"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// How results will be ranked in the response.
type SearchNearbyRequest_RankPreference int32

const (
	// RankPreference value not set. Will use rank by POPULARITY by default.
	SearchNearbyRequest_RANK_PREFERENCE_UNSPECIFIED SearchNearbyRequest_RankPreference = 0
	// Ranks results by distance.
	SearchNearbyRequest_DISTANCE SearchNearbyRequest_RankPreference = 1
	// Ranks results by popularity.
	SearchNearbyRequest_POPULARITY SearchNearbyRequest_RankPreference = 2
)

// Enum value maps for SearchNearbyRequest_RankPreference.
var (
	SearchNearbyRequest_RankPreference_name = map[int32]string{
		0: "RANK_PREFERENCE_UNSPECIFIED",
		1: "DISTANCE",
		2: "POPULARITY",
	}
	SearchNearbyRequest_RankPreference_value = map[string]int32{
		"RANK_PREFERENCE_UNSPECIFIED": 0,
		"DISTANCE":                    1,
		"POPULARITY":                  2,
	}
)

func (x SearchNearbyRequest_RankPreference) Enum() *SearchNearbyRequest_RankPreference {
	p := new(SearchNearbyRequest_RankPreference)
	*p = x
	return p
}

func (x SearchNearbyRequest_RankPreference) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchNearbyRequest_RankPreference) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_places_v1_places_service_proto_enumTypes[0].Descriptor()
}

func (SearchNearbyRequest_RankPreference) Type() protoreflect.EnumType {
	return &file_google_maps_places_v1_places_service_proto_enumTypes[0]
}

func (x SearchNearbyRequest_RankPreference) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchNearbyRequest_RankPreference.Descriptor instead.
func (SearchNearbyRequest_RankPreference) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{1, 0}
}

// How results will be ranked in the response.
type SearchTextRequest_RankPreference int32

const (
	// For a categorical query such as "Restaurants in New York City", RELEVANCE
	// is the default. For non-categorical queries such as "Mountain View, CA"
	// we recommend that you leave rankPreference unset.
	SearchTextRequest_RANK_PREFERENCE_UNSPECIFIED SearchTextRequest_RankPreference = 0
	// Ranks results by distance.
	SearchTextRequest_DISTANCE SearchTextRequest_RankPreference = 1
	// Ranks results by relevance. Sort order determined by normal ranking
	// stack.
	SearchTextRequest_RELEVANCE SearchTextRequest_RankPreference = 2
)

// Enum value maps for SearchTextRequest_RankPreference.
var (
	SearchTextRequest_RankPreference_name = map[int32]string{
		0: "RANK_PREFERENCE_UNSPECIFIED",
		1: "DISTANCE",
		2: "RELEVANCE",
	}
	SearchTextRequest_RankPreference_value = map[string]int32{
		"RANK_PREFERENCE_UNSPECIFIED": 0,
		"DISTANCE":                    1,
		"RELEVANCE":                   2,
	}
)

func (x SearchTextRequest_RankPreference) Enum() *SearchTextRequest_RankPreference {
	p := new(SearchTextRequest_RankPreference)
	*p = x
	return p
}

func (x SearchTextRequest_RankPreference) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchTextRequest_RankPreference) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_places_v1_places_service_proto_enumTypes[1].Descriptor()
}

func (SearchTextRequest_RankPreference) Type() protoreflect.EnumType {
	return &file_google_maps_places_v1_places_service_proto_enumTypes[1]
}

func (x SearchTextRequest_RankPreference) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchTextRequest_RankPreference.Descriptor instead.
func (SearchTextRequest_RankPreference) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{3, 0}
}

// Parameters to configure the routing calculations to the places in the
// response, both along a route (where result ranking will be influenced) and
// for calculating travel times on results.
type RoutingParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. An explicit routing origin that overrides the origin defined in
	// the polyline. By default, the polyline origin is used.
	Origin *latlng.LatLng `protobuf:"bytes,1,opt,name=origin,proto3" json:"origin,omitempty"`
	// Optional. The travel mode.
	TravelMode TravelMode `protobuf:"varint,2,opt,name=travel_mode,json=travelMode,proto3,enum=google.maps.places.v1.TravelMode" json:"travel_mode,omitempty"`
	// Optional. The route modifiers.
	RouteModifiers *RouteModifiers `protobuf:"bytes,3,opt,name=route_modifiers,json=routeModifiers,proto3" json:"route_modifiers,omitempty"`
	// Optional. Specifies how to compute the routing summaries. The server
	// attempts to use the selected routing preference to compute the route. The
	// traffic aware routing preference is only available for the `DRIVE` or
	// `TWO_WHEELER` `travelMode`.
	RoutingPreference RoutingPreference `protobuf:"varint,4,opt,name=routing_preference,json=routingPreference,proto3,enum=google.maps.places.v1.RoutingPreference" json:"routing_preference,omitempty"`
}

func (x *RoutingParameters) Reset() {
	*x = RoutingParameters{}
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RoutingParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RoutingParameters) ProtoMessage() {}

func (x *RoutingParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RoutingParameters.ProtoReflect.Descriptor instead.
func (*RoutingParameters) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{0}
}

func (x *RoutingParameters) GetOrigin() *latlng.LatLng {
	if x != nil {
		return x.Origin
	}
	return nil
}

func (x *RoutingParameters) GetTravelMode() TravelMode {
	if x != nil {
		return x.TravelMode
	}
	return TravelMode_TRAVEL_MODE_UNSPECIFIED
}

func (x *RoutingParameters) GetRouteModifiers() *RouteModifiers {
	if x != nil {
		return x.RouteModifiers
	}
	return nil
}

func (x *RoutingParameters) GetRoutingPreference() RoutingPreference {
	if x != nil {
		return x.RoutingPreference
	}
	return RoutingPreference_ROUTING_PREFERENCE_UNSPECIFIED
}

// Request proto for Search Nearby.
type SearchNearbyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Place details will be displayed with the preferred language if available.
	// If the language code is unspecified or unrecognized, place details of any
	// language may be returned, with a preference for English if such details
	// exist.
	//
	// Current list of supported languages:
	// https://developers.google.com/maps/faq#languagesupport.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The Unicode country/region code (CLDR) of the location where the
	// request is coming from. This parameter is used to display the place
	// details, like region-specific place name, if available. The parameter can
	// affect results based on applicable law.
	//
	// For more information, see
	// https://www.unicode.org/cldr/charts/latest/supplemental/territory_language_information.html.
	//
	// Note that 3-digit region codes are not currently supported.
	RegionCode string `protobuf:"bytes,2,opt,name=region_code,json=regionCode,proto3" json:"region_code,omitempty"`
	// Included Place type (eg, "restaurant" or "gas_station") from
	// https://developers.google.com/maps/documentation/places/web-service/place-types.
	//
	// Up to 50 types from [Table
	// A](https://developers.google.com/maps/documentation/places/web-service/place-types#table-a)
	// may be specified.
	//
	// If there are any conflicting types, i.e. a type appears in both
	// included_types and excluded_types, an INVALID_ARGUMENT error is
	// returned.
	//
	// If a Place type is specified with multiple type restrictions, only places
	// that satisfy all of the restrictions are returned. For example, if we
	// have {included_types = ["restaurant"], excluded_primary_types =
	// ["restaurant"]}, the returned places provide "restaurant"
	// related services but do not operate primarily as "restaurants".
	IncludedTypes []string `protobuf:"bytes,3,rep,name=included_types,json=includedTypes,proto3" json:"included_types,omitempty"`
	// Excluded Place type (eg, "restaurant" or "gas_station") from
	// https://developers.google.com/maps/documentation/places/web-service/place-types.
	//
	// Up to 50 types from [Table
	// A](https://developers.google.com/maps/documentation/places/web-service/place-types#table-a)
	// may be specified.
	//
	// If the client provides both included_types (e.g. restaurant) and
	// excluded_types (e.g. cafe), then the response should include places that
	// are restaurant but not cafe. The response includes places that match at
	// least one of the included_types and none of the excluded_types.
	//
	// If there are any conflicting types, i.e. a type appears in both
	// included_types and excluded_types, an INVALID_ARGUMENT error is returned.
	//
	// If a Place type is specified with multiple type restrictions, only places
	// that satisfy all of the restrictions are returned. For example, if we
	// have {included_types = ["restaurant"], excluded_primary_types =
	// ["restaurant"]}, the returned places provide "restaurant"
	// related services but do not operate primarily as "restaurants".
	ExcludedTypes []string `protobuf:"bytes,4,rep,name=excluded_types,json=excludedTypes,proto3" json:"excluded_types,omitempty"`
	// Included primary Place type (e.g. "restaurant" or "gas_station") from
	// https://developers.google.com/maps/documentation/places/web-service/place-types.
	// A place can only have a single primary type from the supported types table
	// associated with it.
	//
	// Up to 50 types from [Table
	// A](https://developers.google.com/maps/documentation/places/web-service/place-types#table-a)
	// may be specified.
	//
	// If there are any conflicting primary types, i.e. a type appears in both
	// included_primary_types and excluded_primary_types, an INVALID_ARGUMENT
	// error is returned.
	//
	// If a Place type is specified with multiple type restrictions, only places
	// that satisfy all of the restrictions are returned. For example, if we
	// have {included_types = ["restaurant"], excluded_primary_types =
	// ["restaurant"]}, the returned places provide "restaurant"
	// related services but do not operate primarily as "restaurants".
	IncludedPrimaryTypes []string `protobuf:"bytes,5,rep,name=included_primary_types,json=includedPrimaryTypes,proto3" json:"included_primary_types,omitempty"`
	// Excluded primary Place type (e.g. "restaurant" or "gas_station") from
	// https://developers.google.com/maps/documentation/places/web-service/place-types.
	//
	// Up to 50 types from [Table
	// A](https://developers.google.com/maps/documentation/places/web-service/place-types#table-a)
	// may be specified.
	//
	// If there are any conflicting primary types, i.e. a type appears in both
	// included_primary_types and excluded_primary_types, an INVALID_ARGUMENT
	// error is returned.
	//
	// If a Place type is specified with multiple type restrictions, only places
	// that satisfy all of the restrictions are returned. For example, if we
	// have {included_types = ["restaurant"], excluded_primary_types =
	// ["restaurant"]}, the returned places provide "restaurant"
	// related services but do not operate primarily as "restaurants".
	ExcludedPrimaryTypes []string `protobuf:"bytes,6,rep,name=excluded_primary_types,json=excludedPrimaryTypes,proto3" json:"excluded_primary_types,omitempty"`
	// Maximum number of results to return. It must be between 1 and 20 (default),
	// inclusively. If the number is unset, it falls back to the upper limit. If
	// the number is set to negative or exceeds the upper limit, an
	// INVALID_ARGUMENT error is returned.
	MaxResultCount int32 `protobuf:"varint,7,opt,name=max_result_count,json=maxResultCount,proto3" json:"max_result_count,omitempty"`
	// Required. The region to search.
	LocationRestriction *SearchNearbyRequest_LocationRestriction `protobuf:"bytes,8,opt,name=location_restriction,json=locationRestriction,proto3" json:"location_restriction,omitempty"`
	// How results will be ranked in the response.
	RankPreference SearchNearbyRequest_RankPreference `protobuf:"varint,9,opt,name=rank_preference,json=rankPreference,proto3,enum=google.maps.places.v1.SearchNearbyRequest_RankPreference" json:"rank_preference,omitempty"`
	// Optional. Parameters that affect the routing to the search results.
	RoutingParameters *RoutingParameters `protobuf:"bytes,10,opt,name=routing_parameters,json=routingParameters,proto3" json:"routing_parameters,omitempty"`
}

func (x *SearchNearbyRequest) Reset() {
	*x = SearchNearbyRequest{}
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchNearbyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchNearbyRequest) ProtoMessage() {}

func (x *SearchNearbyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchNearbyRequest.ProtoReflect.Descriptor instead.
func (*SearchNearbyRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{1}
}

func (x *SearchNearbyRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *SearchNearbyRequest) GetRegionCode() string {
	if x != nil {
		return x.RegionCode
	}
	return ""
}

func (x *SearchNearbyRequest) GetIncludedTypes() []string {
	if x != nil {
		return x.IncludedTypes
	}
	return nil
}

func (x *SearchNearbyRequest) GetExcludedTypes() []string {
	if x != nil {
		return x.ExcludedTypes
	}
	return nil
}

func (x *SearchNearbyRequest) GetIncludedPrimaryTypes() []string {
	if x != nil {
		return x.IncludedPrimaryTypes
	}
	return nil
}

func (x *SearchNearbyRequest) GetExcludedPrimaryTypes() []string {
	if x != nil {
		return x.ExcludedPrimaryTypes
	}
	return nil
}

func (x *SearchNearbyRequest) GetMaxResultCount() int32 {
	if x != nil {
		return x.MaxResultCount
	}
	return 0
}

func (x *SearchNearbyRequest) GetLocationRestriction() *SearchNearbyRequest_LocationRestriction {
	if x != nil {
		return x.LocationRestriction
	}
	return nil
}

func (x *SearchNearbyRequest) GetRankPreference() SearchNearbyRequest_RankPreference {
	if x != nil {
		return x.RankPreference
	}
	return SearchNearbyRequest_RANK_PREFERENCE_UNSPECIFIED
}

func (x *SearchNearbyRequest) GetRoutingParameters() *RoutingParameters {
	if x != nil {
		return x.RoutingParameters
	}
	return nil
}

// Response proto for Search Nearby.
type SearchNearbyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of places that meets user's requirements like places
	// types, number of places and specific location restriction.
	Places []*Place `protobuf:"bytes,1,rep,name=places,proto3" json:"places,omitempty"`
	// A list of routing summaries where each entry associates to the
	// corresponding place in the same index in the `places` field. If the routing
	// summary is not available for one of the places, it will contain an empty
	// entry. This list should have as many entries as the list of places if
	// requested.
	RoutingSummaries []*RoutingSummary `protobuf:"bytes,2,rep,name=routing_summaries,json=routingSummaries,proto3" json:"routing_summaries,omitempty"`
}

func (x *SearchNearbyResponse) Reset() {
	*x = SearchNearbyResponse{}
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchNearbyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchNearbyResponse) ProtoMessage() {}

func (x *SearchNearbyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchNearbyResponse.ProtoReflect.Descriptor instead.
func (*SearchNearbyResponse) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{2}
}

func (x *SearchNearbyResponse) GetPlaces() []*Place {
	if x != nil {
		return x.Places
	}
	return nil
}

func (x *SearchNearbyResponse) GetRoutingSummaries() []*RoutingSummary {
	if x != nil {
		return x.RoutingSummaries
	}
	return nil
}

// Request proto for SearchText.
type SearchTextRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The text query for textual search.
	TextQuery string `protobuf:"bytes,1,opt,name=text_query,json=textQuery,proto3" json:"text_query,omitempty"`
	// Place details will be displayed with the preferred language if available.
	// If the language code is unspecified or unrecognized, place details of any
	// language may be returned, with a preference for English if such details
	// exist.
	//
	// Current list of supported languages:
	// https://developers.google.com/maps/faq#languagesupport.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The Unicode country/region code (CLDR) of the location where the
	// request is coming from. This parameter is used to display the place
	// details, like region-specific place name, if available. The parameter can
	// affect results based on applicable law.
	//
	// For more information, see
	// https://www.unicode.org/cldr/charts/latest/supplemental/territory_language_information.html.
	//
	// Note that 3-digit region codes are not currently supported.
	RegionCode string `protobuf:"bytes,3,opt,name=region_code,json=regionCode,proto3" json:"region_code,omitempty"`
	// How results will be ranked in the response.
	RankPreference SearchTextRequest_RankPreference `protobuf:"varint,4,opt,name=rank_preference,json=rankPreference,proto3,enum=google.maps.places.v1.SearchTextRequest_RankPreference" json:"rank_preference,omitempty"`
	// The requested place type. Full list of types supported:
	// https://developers.google.com/maps/documentation/places/web-service/place-types.
	// Only support one included type.
	IncludedType string `protobuf:"bytes,6,opt,name=included_type,json=includedType,proto3" json:"included_type,omitempty"`
	// Used to restrict the search to places that are currently open.  The default
	// is false.
	OpenNow bool `protobuf:"varint,7,opt,name=open_now,json=openNow,proto3" json:"open_now,omitempty"`
	// Filter out results whose average user rating is strictly less than this
	// limit. A valid value must be a float between 0 and 5 (inclusively) at a
	// 0.5 cadence i.e. [0, 0.5, 1.0, ... , 5.0] inclusively. The input rating
	// will round up to the nearest 0.5(ceiling). For instance, a rating of 0.6
	// will eliminate all results with a less than 1.0 rating.
	MinRating float64 `protobuf:"fixed64,9,opt,name=min_rating,json=minRating,proto3" json:"min_rating,omitempty"`
	// Maximum number of results to return. It must be between 1 and 20,
	// inclusively. The default is 20.  If the number is unset, it falls back to
	// the upper limit. If the number is set to negative or exceeds the upper
	// limit, an INVALID_ARGUMENT error is returned.
	MaxResultCount int32 `protobuf:"varint,10,opt,name=max_result_count,json=maxResultCount,proto3" json:"max_result_count,omitempty"`
	// Used to restrict the search to places that are marked as certain price
	// levels. Users can choose any combinations of price levels. Default to
	// select all price levels.
	PriceLevels []PriceLevel `protobuf:"varint,11,rep,packed,name=price_levels,json=priceLevels,proto3,enum=google.maps.places.v1.PriceLevel" json:"price_levels,omitempty"`
	// Used to set strict type filtering for included_type. If set to true, only
	// results of the same type will be returned. Default to false.
	StrictTypeFiltering bool `protobuf:"varint,12,opt,name=strict_type_filtering,json=strictTypeFiltering,proto3" json:"strict_type_filtering,omitempty"`
	// The region to search. This location serves as a bias which means results
	// around given location might be returned. Cannot be set along with
	// location_restriction.
	LocationBias *SearchTextRequest_LocationBias `protobuf:"bytes,13,opt,name=location_bias,json=locationBias,proto3" json:"location_bias,omitempty"`
	// The region to search. This location serves as a restriction which means
	// results outside given location will not be returned. Cannot be set along
	// with location_bias.
	LocationRestriction *SearchTextRequest_LocationRestriction `protobuf:"bytes,14,opt,name=location_restriction,json=locationRestriction,proto3" json:"location_restriction,omitempty"`
	// Optional. Set the searchable EV options of a place search request.
	EvOptions *SearchTextRequest_EVOptions `protobuf:"bytes,15,opt,name=ev_options,json=evOptions,proto3" json:"ev_options,omitempty"`
	// Optional. Additional parameters for routing to results.
	RoutingParameters *RoutingParameters `protobuf:"bytes,16,opt,name=routing_parameters,json=routingParameters,proto3" json:"routing_parameters,omitempty"`
	// Optional. Additional parameters proto for searching along a route.
	SearchAlongRouteParameters *SearchTextRequest_SearchAlongRouteParameters `protobuf:"bytes,17,opt,name=search_along_route_parameters,json=searchAlongRouteParameters,proto3" json:"search_along_route_parameters,omitempty"`
	// Optional. Include pure service area businesses if the field is set to true.
	// Pure service area business is a business that visits or delivers to
	// customers directly but does not serve customers at their business address.
	// For example, businesses like cleaning services or plumbers. Those
	// businesses do not have a physical address or location on Google Maps.
	// Places will not return fields including `location`, `plus_code`, and other
	// location related fields for these businesses.
	IncludePureServiceAreaBusinesses bool `protobuf:"varint,20,opt,name=include_pure_service_area_businesses,json=includePureServiceAreaBusinesses,proto3" json:"include_pure_service_area_businesses,omitempty"`
}

func (x *SearchTextRequest) Reset() {
	*x = SearchTextRequest{}
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchTextRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchTextRequest) ProtoMessage() {}

func (x *SearchTextRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchTextRequest.ProtoReflect.Descriptor instead.
func (*SearchTextRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{3}
}

func (x *SearchTextRequest) GetTextQuery() string {
	if x != nil {
		return x.TextQuery
	}
	return ""
}

func (x *SearchTextRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *SearchTextRequest) GetRegionCode() string {
	if x != nil {
		return x.RegionCode
	}
	return ""
}

func (x *SearchTextRequest) GetRankPreference() SearchTextRequest_RankPreference {
	if x != nil {
		return x.RankPreference
	}
	return SearchTextRequest_RANK_PREFERENCE_UNSPECIFIED
}

func (x *SearchTextRequest) GetIncludedType() string {
	if x != nil {
		return x.IncludedType
	}
	return ""
}

func (x *SearchTextRequest) GetOpenNow() bool {
	if x != nil {
		return x.OpenNow
	}
	return false
}

func (x *SearchTextRequest) GetMinRating() float64 {
	if x != nil {
		return x.MinRating
	}
	return 0
}

func (x *SearchTextRequest) GetMaxResultCount() int32 {
	if x != nil {
		return x.MaxResultCount
	}
	return 0
}

func (x *SearchTextRequest) GetPriceLevels() []PriceLevel {
	if x != nil {
		return x.PriceLevels
	}
	return nil
}

func (x *SearchTextRequest) GetStrictTypeFiltering() bool {
	if x != nil {
		return x.StrictTypeFiltering
	}
	return false
}

func (x *SearchTextRequest) GetLocationBias() *SearchTextRequest_LocationBias {
	if x != nil {
		return x.LocationBias
	}
	return nil
}

func (x *SearchTextRequest) GetLocationRestriction() *SearchTextRequest_LocationRestriction {
	if x != nil {
		return x.LocationRestriction
	}
	return nil
}

func (x *SearchTextRequest) GetEvOptions() *SearchTextRequest_EVOptions {
	if x != nil {
		return x.EvOptions
	}
	return nil
}

func (x *SearchTextRequest) GetRoutingParameters() *RoutingParameters {
	if x != nil {
		return x.RoutingParameters
	}
	return nil
}

func (x *SearchTextRequest) GetSearchAlongRouteParameters() *SearchTextRequest_SearchAlongRouteParameters {
	if x != nil {
		return x.SearchAlongRouteParameters
	}
	return nil
}

func (x *SearchTextRequest) GetIncludePureServiceAreaBusinesses() bool {
	if x != nil {
		return x.IncludePureServiceAreaBusinesses
	}
	return false
}

// Response proto for SearchText.
type SearchTextResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of places that meet the user's text search criteria.
	Places []*Place `protobuf:"bytes,1,rep,name=places,proto3" json:"places,omitempty"`
	// A list of routing summaries where each entry associates to the
	// corresponding place in the same index in the `places` field. If the routing
	// summary is not available for one of the places, it will contain an empty
	// entry. This list will have as many entries as the list of places if
	// requested.
	RoutingSummaries []*RoutingSummary `protobuf:"bytes,2,rep,name=routing_summaries,json=routingSummaries,proto3" json:"routing_summaries,omitempty"`
	// Experimental: See
	// https://developers.google.com/maps/documentation/places/web-service/experimental/places-generative
	// for more details.
	//
	// A list of contextual contents where each entry associates to the
	// corresponding place in the same index in the places field. The contents
	// that are relevant to the `text_query` in the request are preferred. If the
	// contextual content is not available for one of the places, it will return
	// non-contextual content. It will be empty only when the content is
	// unavailable for this place. This list will have as many entries as the
	// list of places if requested.
	ContextualContents []*ContextualContent `protobuf:"bytes,3,rep,name=contextual_contents,json=contextualContents,proto3" json:"contextual_contents,omitempty"`
}

func (x *SearchTextResponse) Reset() {
	*x = SearchTextResponse{}
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchTextResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchTextResponse) ProtoMessage() {}

func (x *SearchTextResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchTextResponse.ProtoReflect.Descriptor instead.
func (*SearchTextResponse) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{4}
}

func (x *SearchTextResponse) GetPlaces() []*Place {
	if x != nil {
		return x.Places
	}
	return nil
}

func (x *SearchTextResponse) GetRoutingSummaries() []*RoutingSummary {
	if x != nil {
		return x.RoutingSummaries
	}
	return nil
}

func (x *SearchTextResponse) GetContextualContents() []*ContextualContent {
	if x != nil {
		return x.ContextualContents
	}
	return nil
}

// Request for fetching a photo of a place using a photo resource name.
type GetPhotoMediaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of a photo media in the format:
	// `places/{place_id}/photos/{photo_reference}/media`.
	//
	// The resource name of a photo as returned in a Place object's `photos.name`
	// field comes with the format
	// `places/{place_id}/photos/{photo_reference}`. You need to append `/media`
	// at the end of the photo resource to get the photo media resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Specifies the maximum desired width, in pixels, of the image. If
	// the image is smaller than the values specified, the original image will be
	// returned. If the image is larger in either dimension, it will be scaled to
	// match the smaller of the two dimensions, restricted to its original aspect
	// ratio. Both the max_height_px and max_width_px properties accept an integer
	// between 1 and 4800, inclusively. If the value is not within the allowed
	// range, an INVALID_ARGUMENT error will be returned.
	//
	// At least one of max_height_px or max_width_px needs to be specified. If
	// neither max_height_px nor max_width_px is specified, an INVALID_ARGUMENT
	// error will be returned.
	MaxWidthPx int32 `protobuf:"varint,2,opt,name=max_width_px,json=maxWidthPx,proto3" json:"max_width_px,omitempty"`
	// Optional. Specifies the maximum desired height, in pixels, of the image. If
	// the image is smaller than the values specified, the original image will be
	// returned. If the image is larger in either dimension, it will be scaled to
	// match the smaller of the two dimensions, restricted to its original aspect
	// ratio. Both the max_height_px and max_width_px properties accept an integer
	// between 1 and 4800, inclusively. If the value is not within the allowed
	// range, an INVALID_ARGUMENT error will be returned.
	//
	// At least one of max_height_px or max_width_px needs to be specified. If
	// neither max_height_px nor max_width_px is specified, an INVALID_ARGUMENT
	// error will be returned.
	MaxHeightPx int32 `protobuf:"varint,3,opt,name=max_height_px,json=maxHeightPx,proto3" json:"max_height_px,omitempty"`
	// Optional. If set, skip the default HTTP redirect behavior and render a text
	// format (for example, in JSON format for HTTP use case) response. If not
	// set, an HTTP redirect will be issued to redirect the call to the image
	// media. This option is ignored for non-HTTP requests.
	SkipHttpRedirect bool `protobuf:"varint,4,opt,name=skip_http_redirect,json=skipHttpRedirect,proto3" json:"skip_http_redirect,omitempty"`
}

func (x *GetPhotoMediaRequest) Reset() {
	*x = GetPhotoMediaRequest{}
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPhotoMediaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPhotoMediaRequest) ProtoMessage() {}

func (x *GetPhotoMediaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPhotoMediaRequest.ProtoReflect.Descriptor instead.
func (*GetPhotoMediaRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{5}
}

func (x *GetPhotoMediaRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetPhotoMediaRequest) GetMaxWidthPx() int32 {
	if x != nil {
		return x.MaxWidthPx
	}
	return 0
}

func (x *GetPhotoMediaRequest) GetMaxHeightPx() int32 {
	if x != nil {
		return x.MaxHeightPx
	}
	return 0
}

func (x *GetPhotoMediaRequest) GetSkipHttpRedirect() bool {
	if x != nil {
		return x.SkipHttpRedirect
	}
	return false
}

// A photo media from Places API.
type PhotoMedia struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of a photo media in the format:
	// `places/{place_id}/photos/{photo_reference}/media`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A short-lived uri that can be used to render the photo.
	PhotoUri string `protobuf:"bytes,2,opt,name=photo_uri,json=photoUri,proto3" json:"photo_uri,omitempty"`
}

func (x *PhotoMedia) Reset() {
	*x = PhotoMedia{}
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PhotoMedia) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PhotoMedia) ProtoMessage() {}

func (x *PhotoMedia) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PhotoMedia.ProtoReflect.Descriptor instead.
func (*PhotoMedia) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{6}
}

func (x *PhotoMedia) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PhotoMedia) GetPhotoUri() string {
	if x != nil {
		return x.PhotoUri
	}
	return ""
}

// Request for fetching a Place based on its resource name, which is a string in
// the `places/{place_id}` format.
type GetPlaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of a place, in the `places/{place_id}` format.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Place details will be displayed with the preferred language if
	// available.
	//
	// Current list of supported languages:
	// https://developers.google.com/maps/faq#languagesupport.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The Unicode country/region code (CLDR) of the location where the
	// request is coming from. This parameter is used to display the place
	// details, like region-specific place name, if available. The parameter can
	// affect results based on applicable law.
	// For more information, see
	// https://www.unicode.org/cldr/charts/latest/supplemental/territory_language_information.html.
	//
	// Note that 3-digit region codes are not currently supported.
	RegionCode string `protobuf:"bytes,3,opt,name=region_code,json=regionCode,proto3" json:"region_code,omitempty"`
	// Optional. A string which identifies an Autocomplete session for billing
	// purposes. Must be a URL and filename safe base64 string with at most 36
	// ASCII characters in length. Otherwise an INVALID_ARGUMENT error is
	// returned.
	//
	// The session begins when the user starts typing a query, and concludes when
	// they select a place and a call to Place Details or Address Validation is
	// made. Each session can have multiple queries, followed by one Place Details
	// or Address Validation request. The credentials used for each request within
	// a session must belong to the same Google Cloud Console project. Once a
	// session has concluded, the token is no longer valid; your app must generate
	// a fresh token for each session. If the `session_token` parameter is
	// omitted, or if you reuse a session token, the session is charged as if no
	// session token was provided (each request is billed separately).
	//
	// We recommend the following guidelines:
	//
	//   - Use session tokens for all Place Autocomplete calls.
	//   - Generate a fresh token for each session. Using a version 4 UUID is
	//     recommended.
	//   - Ensure that the credentials used for all Place Autocomplete, Place
	//     Details, and Address Validation requests within a session belong to the
	//     same Cloud Console project.
	//   - Be sure to pass a unique session token for each new session. Using the
	//     same token for more than one session will result in each request being
	//     billed individually.
	SessionToken string `protobuf:"bytes,4,opt,name=session_token,json=sessionToken,proto3" json:"session_token,omitempty"`
}

func (x *GetPlaceRequest) Reset() {
	*x = GetPlaceRequest{}
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPlaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPlaceRequest) ProtoMessage() {}

func (x *GetPlaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPlaceRequest.ProtoReflect.Descriptor instead.
func (*GetPlaceRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{7}
}

func (x *GetPlaceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetPlaceRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *GetPlaceRequest) GetRegionCode() string {
	if x != nil {
		return x.RegionCode
	}
	return ""
}

func (x *GetPlaceRequest) GetSessionToken() string {
	if x != nil {
		return x.SessionToken
	}
	return ""
}

// Request proto for AutocompletePlaces.
type AutocompletePlacesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The text string on which to search.
	Input string `protobuf:"bytes,1,opt,name=input,proto3" json:"input,omitempty"`
	// Optional. Bias results to a specified location.
	//
	// At most one of `location_bias` or `location_restriction` should be set. If
	// neither are set, the results will be biased by IP address, meaning the IP
	// address will be mapped to an imprecise location and used as a biasing
	// signal.
	LocationBias *AutocompletePlacesRequest_LocationBias `protobuf:"bytes,2,opt,name=location_bias,json=locationBias,proto3" json:"location_bias,omitempty"`
	// Optional. Restrict results to a specified location.
	//
	// At most one of `location_bias` or `location_restriction` should be set. If
	// neither are set, the results will be biased by IP address, meaning the IP
	// address will be mapped to an imprecise location and used as a biasing
	// signal.
	LocationRestriction *AutocompletePlacesRequest_LocationRestriction `protobuf:"bytes,3,opt,name=location_restriction,json=locationRestriction,proto3" json:"location_restriction,omitempty"`
	// Optional. Included primary Place type (for example, "restaurant" or
	// "gas_station") in Place Types
	// (https://developers.google.com/maps/documentation/places/web-service/place-types),
	// or only `(regions)`, or only `(cities)`. A Place is only returned if its
	// primary type is included in this list. Up to 5 values can be specified. If
	// no types are specified, all Place types are returned.
	IncludedPrimaryTypes []string `protobuf:"bytes,4,rep,name=included_primary_types,json=includedPrimaryTypes,proto3" json:"included_primary_types,omitempty"`
	// Optional. Only include results in the specified regions, specified as up to
	// 15 CLDR two-character region codes. An empty set will not restrict the
	// results. If both `location_restriction` and `included_region_codes` are
	// set, the results will be located in the area of intersection.
	IncludedRegionCodes []string `protobuf:"bytes,5,rep,name=included_region_codes,json=includedRegionCodes,proto3" json:"included_region_codes,omitempty"`
	// Optional. The language in which to return results. Defaults to en-US. The
	// results may be in mixed languages if the language used in `input` is
	// different from `language_code` or if the returned Place does not have a
	// translation from the local language to `language_code`.
	LanguageCode string `protobuf:"bytes,6,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The region code, specified as a CLDR two-character region code.
	// This affects address formatting, result ranking, and may influence what
	// results are returned. This does not restrict results to the specified
	// region. To restrict results to a region, use `region_code_restriction`.
	RegionCode string `protobuf:"bytes,7,opt,name=region_code,json=regionCode,proto3" json:"region_code,omitempty"`
	// Optional. The origin point from which to calculate geodesic distance to the
	// destination (returned as `distance_meters`). If this value is omitted,
	// geodesic distance will not be returned.
	Origin *latlng.LatLng `protobuf:"bytes,8,opt,name=origin,proto3" json:"origin,omitempty"`
	// Optional. A zero-based Unicode character offset of `input` indicating the
	// cursor position in `input`. The cursor position may influence what
	// predictions are returned.
	//
	// If empty, defaults to the length of `input`.
	InputOffset int32 `protobuf:"varint,9,opt,name=input_offset,json=inputOffset,proto3" json:"input_offset,omitempty"`
	// Optional. If true, the response will include both Place and query
	// predictions. Otherwise the response will only return Place predictions.
	IncludeQueryPredictions bool `protobuf:"varint,10,opt,name=include_query_predictions,json=includeQueryPredictions,proto3" json:"include_query_predictions,omitempty"`
	// Optional. A string which identifies an Autocomplete session for billing
	// purposes. Must be a URL and filename safe base64 string with at most 36
	// ASCII characters in length. Otherwise an INVALID_ARGUMENT error is
	// returned.
	//
	// The session begins when the user starts typing a query, and concludes when
	// they select a place and a call to Place Details or Address Validation is
	// made. Each session can have multiple queries, followed by one Place Details
	// or Address Validation request. The credentials used for each request within
	// a session must belong to the same Google Cloud Console project. Once a
	// session has concluded, the token is no longer valid; your app must generate
	// a fresh token for each session. If the `session_token` parameter is
	// omitted, or if you reuse a session token, the session is charged as if no
	// session token was provided (each request is billed separately).
	//
	// We recommend the following guidelines:
	//
	//   - Use session tokens for all Place Autocomplete calls.
	//   - Generate a fresh token for each session. Using a version 4 UUID is
	//     recommended.
	//   - Ensure that the credentials used for all Place Autocomplete, Place
	//     Details, and Address Validation requests within a session belong to the
	//     same Cloud Console project.
	//   - Be sure to pass a unique session token for each new session. Using the
	//     same token for more than one session will result in each request being
	//     billed individually.
	SessionToken string `protobuf:"bytes,11,opt,name=session_token,json=sessionToken,proto3" json:"session_token,omitempty"`
	// Optional. Include pure service area businesses if the field is set to true.
	// Pure service area business is a business that visits or delivers to
	// customers directly but does not serve customers at their business address.
	// For example, businesses like cleaning services or plumbers. Those
	// businesses do not have a physical address or location on Google Maps.
	// Places will not return fields including `location`, `plus_code`, and other
	// location related fields for these businesses.
	IncludePureServiceAreaBusinesses bool `protobuf:"varint,12,opt,name=include_pure_service_area_businesses,json=includePureServiceAreaBusinesses,proto3" json:"include_pure_service_area_businesses,omitempty"`
}

func (x *AutocompletePlacesRequest) Reset() {
	*x = AutocompletePlacesRequest{}
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutocompletePlacesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutocompletePlacesRequest) ProtoMessage() {}

func (x *AutocompletePlacesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutocompletePlacesRequest.ProtoReflect.Descriptor instead.
func (*AutocompletePlacesRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{8}
}

func (x *AutocompletePlacesRequest) GetInput() string {
	if x != nil {
		return x.Input
	}
	return ""
}

func (x *AutocompletePlacesRequest) GetLocationBias() *AutocompletePlacesRequest_LocationBias {
	if x != nil {
		return x.LocationBias
	}
	return nil
}

func (x *AutocompletePlacesRequest) GetLocationRestriction() *AutocompletePlacesRequest_LocationRestriction {
	if x != nil {
		return x.LocationRestriction
	}
	return nil
}

func (x *AutocompletePlacesRequest) GetIncludedPrimaryTypes() []string {
	if x != nil {
		return x.IncludedPrimaryTypes
	}
	return nil
}

func (x *AutocompletePlacesRequest) GetIncludedRegionCodes() []string {
	if x != nil {
		return x.IncludedRegionCodes
	}
	return nil
}

func (x *AutocompletePlacesRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *AutocompletePlacesRequest) GetRegionCode() string {
	if x != nil {
		return x.RegionCode
	}
	return ""
}

func (x *AutocompletePlacesRequest) GetOrigin() *latlng.LatLng {
	if x != nil {
		return x.Origin
	}
	return nil
}

func (x *AutocompletePlacesRequest) GetInputOffset() int32 {
	if x != nil {
		return x.InputOffset
	}
	return 0
}

func (x *AutocompletePlacesRequest) GetIncludeQueryPredictions() bool {
	if x != nil {
		return x.IncludeQueryPredictions
	}
	return false
}

func (x *AutocompletePlacesRequest) GetSessionToken() string {
	if x != nil {
		return x.SessionToken
	}
	return ""
}

func (x *AutocompletePlacesRequest) GetIncludePureServiceAreaBusinesses() bool {
	if x != nil {
		return x.IncludePureServiceAreaBusinesses
	}
	return false
}

// Response proto for AutocompletePlaces.
type AutocompletePlacesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains a list of suggestions, ordered in descending order of relevance.
	Suggestions []*AutocompletePlacesResponse_Suggestion `protobuf:"bytes,1,rep,name=suggestions,proto3" json:"suggestions,omitempty"`
}

func (x *AutocompletePlacesResponse) Reset() {
	*x = AutocompletePlacesResponse{}
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutocompletePlacesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutocompletePlacesResponse) ProtoMessage() {}

func (x *AutocompletePlacesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutocompletePlacesResponse.ProtoReflect.Descriptor instead.
func (*AutocompletePlacesResponse) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{9}
}

func (x *AutocompletePlacesResponse) GetSuggestions() []*AutocompletePlacesResponse_Suggestion {
	if x != nil {
		return x.Suggestions
	}
	return nil
}

// The region to search.
type SearchNearbyRequest_LocationRestriction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Type:
	//
	//	*SearchNearbyRequest_LocationRestriction_Circle
	Type isSearchNearbyRequest_LocationRestriction_Type `protobuf_oneof:"type"`
}

func (x *SearchNearbyRequest_LocationRestriction) Reset() {
	*x = SearchNearbyRequest_LocationRestriction{}
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchNearbyRequest_LocationRestriction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchNearbyRequest_LocationRestriction) ProtoMessage() {}

func (x *SearchNearbyRequest_LocationRestriction) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchNearbyRequest_LocationRestriction.ProtoReflect.Descriptor instead.
func (*SearchNearbyRequest_LocationRestriction) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{1, 0}
}

func (m *SearchNearbyRequest_LocationRestriction) GetType() isSearchNearbyRequest_LocationRestriction_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *SearchNearbyRequest_LocationRestriction) GetCircle() *Circle {
	if x, ok := x.GetType().(*SearchNearbyRequest_LocationRestriction_Circle); ok {
		return x.Circle
	}
	return nil
}

type isSearchNearbyRequest_LocationRestriction_Type interface {
	isSearchNearbyRequest_LocationRestriction_Type()
}

type SearchNearbyRequest_LocationRestriction_Circle struct {
	// A circle defined by center point and radius.
	Circle *Circle `protobuf:"bytes,2,opt,name=circle,proto3,oneof"`
}

func (*SearchNearbyRequest_LocationRestriction_Circle) isSearchNearbyRequest_LocationRestriction_Type() {
}

// The region to search. This location serves as a bias which means results
// around given location might be returned.
type SearchTextRequest_LocationBias struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Type:
	//
	//	*SearchTextRequest_LocationBias_Rectangle
	//	*SearchTextRequest_LocationBias_Circle
	Type isSearchTextRequest_LocationBias_Type `protobuf_oneof:"type"`
}

func (x *SearchTextRequest_LocationBias) Reset() {
	*x = SearchTextRequest_LocationBias{}
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchTextRequest_LocationBias) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchTextRequest_LocationBias) ProtoMessage() {}

func (x *SearchTextRequest_LocationBias) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchTextRequest_LocationBias.ProtoReflect.Descriptor instead.
func (*SearchTextRequest_LocationBias) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{3, 0}
}

func (m *SearchTextRequest_LocationBias) GetType() isSearchTextRequest_LocationBias_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *SearchTextRequest_LocationBias) GetRectangle() *viewport.Viewport {
	if x, ok := x.GetType().(*SearchTextRequest_LocationBias_Rectangle); ok {
		return x.Rectangle
	}
	return nil
}

func (x *SearchTextRequest_LocationBias) GetCircle() *Circle {
	if x, ok := x.GetType().(*SearchTextRequest_LocationBias_Circle); ok {
		return x.Circle
	}
	return nil
}

type isSearchTextRequest_LocationBias_Type interface {
	isSearchTextRequest_LocationBias_Type()
}

type SearchTextRequest_LocationBias_Rectangle struct {
	// A rectangle box defined by northeast and southwest corner.
	// `rectangle.high()` must be the northeast point of the rectangle
	// viewport. `rectangle.low()` must be the southwest point of the
	// rectangle viewport. `rectangle.low().latitude()` cannot be greater than
	// `rectangle.high().latitude()`. This will result in an empty latitude
	// range. A rectangle viewport cannot be wider than 180 degrees.
	Rectangle *viewport.Viewport `protobuf:"bytes,1,opt,name=rectangle,proto3,oneof"`
}

type SearchTextRequest_LocationBias_Circle struct {
	// A circle defined by center point and radius.
	Circle *Circle `protobuf:"bytes,2,opt,name=circle,proto3,oneof"`
}

func (*SearchTextRequest_LocationBias_Rectangle) isSearchTextRequest_LocationBias_Type() {}

func (*SearchTextRequest_LocationBias_Circle) isSearchTextRequest_LocationBias_Type() {}

// The region to search. This location serves as a restriction which means
// results outside given location will not be returned.
type SearchTextRequest_LocationRestriction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Type:
	//
	//	*SearchTextRequest_LocationRestriction_Rectangle
	Type isSearchTextRequest_LocationRestriction_Type `protobuf_oneof:"type"`
}

func (x *SearchTextRequest_LocationRestriction) Reset() {
	*x = SearchTextRequest_LocationRestriction{}
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchTextRequest_LocationRestriction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchTextRequest_LocationRestriction) ProtoMessage() {}

func (x *SearchTextRequest_LocationRestriction) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchTextRequest_LocationRestriction.ProtoReflect.Descriptor instead.
func (*SearchTextRequest_LocationRestriction) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{3, 1}
}

func (m *SearchTextRequest_LocationRestriction) GetType() isSearchTextRequest_LocationRestriction_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *SearchTextRequest_LocationRestriction) GetRectangle() *viewport.Viewport {
	if x, ok := x.GetType().(*SearchTextRequest_LocationRestriction_Rectangle); ok {
		return x.Rectangle
	}
	return nil
}

type isSearchTextRequest_LocationRestriction_Type interface {
	isSearchTextRequest_LocationRestriction_Type()
}

type SearchTextRequest_LocationRestriction_Rectangle struct {
	// A rectangle box defined by northeast and southwest corner.
	// `rectangle.high()` must be the northeast point of the rectangle
	// viewport. `rectangle.low()` must be the southwest point of the
	// rectangle viewport. `rectangle.low().latitude()` cannot be greater than
	// `rectangle.high().latitude()`. This will result in an empty latitude
	// range. A rectangle viewport cannot be wider than 180 degrees.
	Rectangle *viewport.Viewport `protobuf:"bytes,1,opt,name=rectangle,proto3,oneof"`
}

func (*SearchTextRequest_LocationRestriction_Rectangle) isSearchTextRequest_LocationRestriction_Type() {
}

// Searchable EV options of a place search request.
type SearchTextRequest_EVOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Minimum required charging rate in kilowatts. A place with a
	// charging rate less than the specified rate is filtered out.
	MinimumChargingRateKw float64 `protobuf:"fixed64,1,opt,name=minimum_charging_rate_kw,json=minimumChargingRateKw,proto3" json:"minimum_charging_rate_kw,omitempty"`
	// Optional. The list of preferred EV connector types. A place that does not
	// support any of the listed connector types is filtered out.
	ConnectorTypes []EVConnectorType `protobuf:"varint,2,rep,packed,name=connector_types,json=connectorTypes,proto3,enum=google.maps.places.v1.EVConnectorType" json:"connector_types,omitempty"`
}

func (x *SearchTextRequest_EVOptions) Reset() {
	*x = SearchTextRequest_EVOptions{}
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchTextRequest_EVOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchTextRequest_EVOptions) ProtoMessage() {}

func (x *SearchTextRequest_EVOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchTextRequest_EVOptions.ProtoReflect.Descriptor instead.
func (*SearchTextRequest_EVOptions) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{3, 2}
}

func (x *SearchTextRequest_EVOptions) GetMinimumChargingRateKw() float64 {
	if x != nil {
		return x.MinimumChargingRateKw
	}
	return 0
}

func (x *SearchTextRequest_EVOptions) GetConnectorTypes() []EVConnectorType {
	if x != nil {
		return x.ConnectorTypes
	}
	return nil
}

// Specifies a precalculated polyline from the [Routes
// API](https://developers.google.com/maps/documentation/routes) defining the
// route to search. Searching along a route is similar to using the
// `locationBias` or `locationRestriction` request option to bias the search
// results. However, while the `locationBias` and `locationRestriction`
// options let you specify a region to bias the search results, this option
// lets you bias the results along a trip route.
//
// Results are not guaranteed to be along the route provided, but rather are
// ranked within the search area defined by the polyline and, optionally, by
// the `locationBias` or `locationRestriction` based on minimal detour times
// from origin to destination. The results might be along an alternate route,
// especially if the provided polyline does not define an optimal route from
// origin to destination.
type SearchTextRequest_SearchAlongRouteParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The route polyline.
	Polyline *Polyline `protobuf:"bytes,1,opt,name=polyline,proto3" json:"polyline,omitempty"`
}

func (x *SearchTextRequest_SearchAlongRouteParameters) Reset() {
	*x = SearchTextRequest_SearchAlongRouteParameters{}
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchTextRequest_SearchAlongRouteParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchTextRequest_SearchAlongRouteParameters) ProtoMessage() {}

func (x *SearchTextRequest_SearchAlongRouteParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchTextRequest_SearchAlongRouteParameters.ProtoReflect.Descriptor instead.
func (*SearchTextRequest_SearchAlongRouteParameters) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{3, 3}
}

func (x *SearchTextRequest_SearchAlongRouteParameters) GetPolyline() *Polyline {
	if x != nil {
		return x.Polyline
	}
	return nil
}

// The region to search. The results may be biased around the specified
// region.
type AutocompletePlacesRequest_LocationBias struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Type:
	//
	//	*AutocompletePlacesRequest_LocationBias_Rectangle
	//	*AutocompletePlacesRequest_LocationBias_Circle
	Type isAutocompletePlacesRequest_LocationBias_Type `protobuf_oneof:"type"`
}

func (x *AutocompletePlacesRequest_LocationBias) Reset() {
	*x = AutocompletePlacesRequest_LocationBias{}
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutocompletePlacesRequest_LocationBias) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutocompletePlacesRequest_LocationBias) ProtoMessage() {}

func (x *AutocompletePlacesRequest_LocationBias) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutocompletePlacesRequest_LocationBias.ProtoReflect.Descriptor instead.
func (*AutocompletePlacesRequest_LocationBias) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{8, 0}
}

func (m *AutocompletePlacesRequest_LocationBias) GetType() isAutocompletePlacesRequest_LocationBias_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *AutocompletePlacesRequest_LocationBias) GetRectangle() *viewport.Viewport {
	if x, ok := x.GetType().(*AutocompletePlacesRequest_LocationBias_Rectangle); ok {
		return x.Rectangle
	}
	return nil
}

func (x *AutocompletePlacesRequest_LocationBias) GetCircle() *Circle {
	if x, ok := x.GetType().(*AutocompletePlacesRequest_LocationBias_Circle); ok {
		return x.Circle
	}
	return nil
}

type isAutocompletePlacesRequest_LocationBias_Type interface {
	isAutocompletePlacesRequest_LocationBias_Type()
}

type AutocompletePlacesRequest_LocationBias_Rectangle struct {
	// A viewport defined by a northeast and a southwest corner.
	Rectangle *viewport.Viewport `protobuf:"bytes,1,opt,name=rectangle,proto3,oneof"`
}

type AutocompletePlacesRequest_LocationBias_Circle struct {
	// A circle defined by a center point and radius.
	Circle *Circle `protobuf:"bytes,2,opt,name=circle,proto3,oneof"`
}

func (*AutocompletePlacesRequest_LocationBias_Rectangle) isAutocompletePlacesRequest_LocationBias_Type() {
}

func (*AutocompletePlacesRequest_LocationBias_Circle) isAutocompletePlacesRequest_LocationBias_Type() {
}

// The region to search. The results will be restricted to the specified
// region.
type AutocompletePlacesRequest_LocationRestriction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Type:
	//
	//	*AutocompletePlacesRequest_LocationRestriction_Rectangle
	//	*AutocompletePlacesRequest_LocationRestriction_Circle
	Type isAutocompletePlacesRequest_LocationRestriction_Type `protobuf_oneof:"type"`
}

func (x *AutocompletePlacesRequest_LocationRestriction) Reset() {
	*x = AutocompletePlacesRequest_LocationRestriction{}
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutocompletePlacesRequest_LocationRestriction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutocompletePlacesRequest_LocationRestriction) ProtoMessage() {}

func (x *AutocompletePlacesRequest_LocationRestriction) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutocompletePlacesRequest_LocationRestriction.ProtoReflect.Descriptor instead.
func (*AutocompletePlacesRequest_LocationRestriction) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{8, 1}
}

func (m *AutocompletePlacesRequest_LocationRestriction) GetType() isAutocompletePlacesRequest_LocationRestriction_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *AutocompletePlacesRequest_LocationRestriction) GetRectangle() *viewport.Viewport {
	if x, ok := x.GetType().(*AutocompletePlacesRequest_LocationRestriction_Rectangle); ok {
		return x.Rectangle
	}
	return nil
}

func (x *AutocompletePlacesRequest_LocationRestriction) GetCircle() *Circle {
	if x, ok := x.GetType().(*AutocompletePlacesRequest_LocationRestriction_Circle); ok {
		return x.Circle
	}
	return nil
}

type isAutocompletePlacesRequest_LocationRestriction_Type interface {
	isAutocompletePlacesRequest_LocationRestriction_Type()
}

type AutocompletePlacesRequest_LocationRestriction_Rectangle struct {
	// A viewport defined by a northeast and a southwest corner.
	Rectangle *viewport.Viewport `protobuf:"bytes,1,opt,name=rectangle,proto3,oneof"`
}

type AutocompletePlacesRequest_LocationRestriction_Circle struct {
	// A circle defined by a center point and radius.
	Circle *Circle `protobuf:"bytes,2,opt,name=circle,proto3,oneof"`
}

func (*AutocompletePlacesRequest_LocationRestriction_Rectangle) isAutocompletePlacesRequest_LocationRestriction_Type() {
}

func (*AutocompletePlacesRequest_LocationRestriction_Circle) isAutocompletePlacesRequest_LocationRestriction_Type() {
}

// An Autocomplete suggestion result.
type AutocompletePlacesResponse_Suggestion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Kind:
	//
	//	*AutocompletePlacesResponse_Suggestion_PlacePrediction_
	//	*AutocompletePlacesResponse_Suggestion_QueryPrediction_
	Kind isAutocompletePlacesResponse_Suggestion_Kind `protobuf_oneof:"kind"`
}

func (x *AutocompletePlacesResponse_Suggestion) Reset() {
	*x = AutocompletePlacesResponse_Suggestion{}
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutocompletePlacesResponse_Suggestion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutocompletePlacesResponse_Suggestion) ProtoMessage() {}

func (x *AutocompletePlacesResponse_Suggestion) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutocompletePlacesResponse_Suggestion.ProtoReflect.Descriptor instead.
func (*AutocompletePlacesResponse_Suggestion) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{9, 0}
}

func (m *AutocompletePlacesResponse_Suggestion) GetKind() isAutocompletePlacesResponse_Suggestion_Kind {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (x *AutocompletePlacesResponse_Suggestion) GetPlacePrediction() *AutocompletePlacesResponse_Suggestion_PlacePrediction {
	if x, ok := x.GetKind().(*AutocompletePlacesResponse_Suggestion_PlacePrediction_); ok {
		return x.PlacePrediction
	}
	return nil
}

func (x *AutocompletePlacesResponse_Suggestion) GetQueryPrediction() *AutocompletePlacesResponse_Suggestion_QueryPrediction {
	if x, ok := x.GetKind().(*AutocompletePlacesResponse_Suggestion_QueryPrediction_); ok {
		return x.QueryPrediction
	}
	return nil
}

type isAutocompletePlacesResponse_Suggestion_Kind interface {
	isAutocompletePlacesResponse_Suggestion_Kind()
}

type AutocompletePlacesResponse_Suggestion_PlacePrediction_ struct {
	// A prediction for a Place.
	PlacePrediction *AutocompletePlacesResponse_Suggestion_PlacePrediction `protobuf:"bytes,1,opt,name=place_prediction,json=placePrediction,proto3,oneof"`
}

type AutocompletePlacesResponse_Suggestion_QueryPrediction_ struct {
	// A prediction for a query.
	QueryPrediction *AutocompletePlacesResponse_Suggestion_QueryPrediction `protobuf:"bytes,2,opt,name=query_prediction,json=queryPrediction,proto3,oneof"`
}

func (*AutocompletePlacesResponse_Suggestion_PlacePrediction_) isAutocompletePlacesResponse_Suggestion_Kind() {
}

func (*AutocompletePlacesResponse_Suggestion_QueryPrediction_) isAutocompletePlacesResponse_Suggestion_Kind() {
}

// Identifies a substring within a given text.
type AutocompletePlacesResponse_Suggestion_StringRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Zero-based offset of the first Unicode character of the string
	// (inclusive).
	StartOffset int32 `protobuf:"varint,1,opt,name=start_offset,json=startOffset,proto3" json:"start_offset,omitempty"`
	// Zero-based offset of the last Unicode character (exclusive).
	EndOffset int32 `protobuf:"varint,2,opt,name=end_offset,json=endOffset,proto3" json:"end_offset,omitempty"`
}

func (x *AutocompletePlacesResponse_Suggestion_StringRange) Reset() {
	*x = AutocompletePlacesResponse_Suggestion_StringRange{}
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutocompletePlacesResponse_Suggestion_StringRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutocompletePlacesResponse_Suggestion_StringRange) ProtoMessage() {}

func (x *AutocompletePlacesResponse_Suggestion_StringRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutocompletePlacesResponse_Suggestion_StringRange.ProtoReflect.Descriptor instead.
func (*AutocompletePlacesResponse_Suggestion_StringRange) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{9, 0, 0}
}

func (x *AutocompletePlacesResponse_Suggestion_StringRange) GetStartOffset() int32 {
	if x != nil {
		return x.StartOffset
	}
	return 0
}

func (x *AutocompletePlacesResponse_Suggestion_StringRange) GetEndOffset() int32 {
	if x != nil {
		return x.EndOffset
	}
	return 0
}

// Text representing a Place or query prediction. The text may be used as is
// or formatted.
type AutocompletePlacesResponse_Suggestion_FormattableText struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Text that may be used as is or formatted with `matches`.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// A list of string ranges identifying where the input request matched in
	// `text`. The ranges can be used to format specific parts of `text`. The
	// substrings may not be exact matches of `input` if the matching was
	// determined by criteria other than string matching (for example, spell
	// corrections or transliterations).
	//
	// These values are Unicode character offsets of `text`. The ranges are
	// guaranteed to be ordered in increasing offset values.
	Matches []*AutocompletePlacesResponse_Suggestion_StringRange `protobuf:"bytes,2,rep,name=matches,proto3" json:"matches,omitempty"`
}

func (x *AutocompletePlacesResponse_Suggestion_FormattableText) Reset() {
	*x = AutocompletePlacesResponse_Suggestion_FormattableText{}
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutocompletePlacesResponse_Suggestion_FormattableText) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutocompletePlacesResponse_Suggestion_FormattableText) ProtoMessage() {}

func (x *AutocompletePlacesResponse_Suggestion_FormattableText) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutocompletePlacesResponse_Suggestion_FormattableText.ProtoReflect.Descriptor instead.
func (*AutocompletePlacesResponse_Suggestion_FormattableText) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{9, 0, 1}
}

func (x *AutocompletePlacesResponse_Suggestion_FormattableText) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *AutocompletePlacesResponse_Suggestion_FormattableText) GetMatches() []*AutocompletePlacesResponse_Suggestion_StringRange {
	if x != nil {
		return x.Matches
	}
	return nil
}

// Contains a breakdown of a Place or query prediction into main text
// and secondary text.
//
// For Place predictions, the main text contains the specific name of the
// Place. For query predictions, the main text contains the query.
//
// The secondary text contains additional disambiguating features (such as a
// city or region) to further identify the Place or refine the query.
type AutocompletePlacesResponse_Suggestion_StructuredFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Represents the name of the Place or query.
	MainText *AutocompletePlacesResponse_Suggestion_FormattableText `protobuf:"bytes,1,opt,name=main_text,json=mainText,proto3" json:"main_text,omitempty"`
	// Represents additional disambiguating features (such as a city or
	// region) to further identify the Place or refine the query.
	SecondaryText *AutocompletePlacesResponse_Suggestion_FormattableText `protobuf:"bytes,2,opt,name=secondary_text,json=secondaryText,proto3" json:"secondary_text,omitempty"`
}

func (x *AutocompletePlacesResponse_Suggestion_StructuredFormat) Reset() {
	*x = AutocompletePlacesResponse_Suggestion_StructuredFormat{}
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutocompletePlacesResponse_Suggestion_StructuredFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutocompletePlacesResponse_Suggestion_StructuredFormat) ProtoMessage() {}

func (x *AutocompletePlacesResponse_Suggestion_StructuredFormat) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutocompletePlacesResponse_Suggestion_StructuredFormat.ProtoReflect.Descriptor instead.
func (*AutocompletePlacesResponse_Suggestion_StructuredFormat) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{9, 0, 2}
}

func (x *AutocompletePlacesResponse_Suggestion_StructuredFormat) GetMainText() *AutocompletePlacesResponse_Suggestion_FormattableText {
	if x != nil {
		return x.MainText
	}
	return nil
}

func (x *AutocompletePlacesResponse_Suggestion_StructuredFormat) GetSecondaryText() *AutocompletePlacesResponse_Suggestion_FormattableText {
	if x != nil {
		return x.SecondaryText
	}
	return nil
}

// Prediction results for a Place Autocomplete prediction.
type AutocompletePlacesResponse_Suggestion_PlacePrediction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the suggested Place. This name can be used in
	// other APIs that accept Place names.
	Place string `protobuf:"bytes,1,opt,name=place,proto3" json:"place,omitempty"`
	// The unique identifier of the suggested Place. This identifier can be
	// used in other APIs that accept Place IDs.
	PlaceId string `protobuf:"bytes,2,opt,name=place_id,json=placeId,proto3" json:"place_id,omitempty"`
	// Contains the human-readable name for the returned result. For
	// establishment results, this is usually the business name and address.
	//
	// `text` is recommended for developers who wish to show a single UI
	// element. Developers who wish to show two separate, but related, UI
	// elements may want to use `structured_format` instead. They are two
	// different ways to represent a Place prediction. Users should not try to
	// parse `structured_format` into `text` or vice versa.
	//
	// This text may be different from the `display_name` returned by
	// GetPlace.
	//
	// May be in mixed languages if the request `input` and `language_code`
	// are in different languages or if the Place does not have a translation
	// from the local language to `language_code`.
	Text *AutocompletePlacesResponse_Suggestion_FormattableText `protobuf:"bytes,3,opt,name=text,proto3" json:"text,omitempty"`
	// A breakdown of the Place prediction into main text containing the name
	// of the Place and secondary text containing additional disambiguating
	// features (such as a city or region).
	//
	// `structured_format` is recommended for developers who wish to show two
	// separate, but related, UI elements. Developers who wish to show a
	// single UI element may want to use `text` instead. They are two
	// different ways to represent a Place prediction. Users should not try to
	// parse `structured_format` into `text` or vice versa.
	StructuredFormat *AutocompletePlacesResponse_Suggestion_StructuredFormat `protobuf:"bytes,4,opt,name=structured_format,json=structuredFormat,proto3" json:"structured_format,omitempty"`
	// List of types that apply to this Place from Table A or Table B in
	// https://developers.google.com/maps/documentation/places/web-service/place-types.
	//
	// A type is a categorization of a Place. Places with shared types will
	// share similar characteristics.
	Types []string `protobuf:"bytes,5,rep,name=types,proto3" json:"types,omitempty"`
	// The length of the geodesic in meters from `origin` if `origin` is
	// specified. Certain predictions such as routes may not populate this
	// field.
	DistanceMeters int32 `protobuf:"varint,6,opt,name=distance_meters,json=distanceMeters,proto3" json:"distance_meters,omitempty"`
}

func (x *AutocompletePlacesResponse_Suggestion_PlacePrediction) Reset() {
	*x = AutocompletePlacesResponse_Suggestion_PlacePrediction{}
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutocompletePlacesResponse_Suggestion_PlacePrediction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutocompletePlacesResponse_Suggestion_PlacePrediction) ProtoMessage() {}

func (x *AutocompletePlacesResponse_Suggestion_PlacePrediction) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutocompletePlacesResponse_Suggestion_PlacePrediction.ProtoReflect.Descriptor instead.
func (*AutocompletePlacesResponse_Suggestion_PlacePrediction) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{9, 0, 3}
}

func (x *AutocompletePlacesResponse_Suggestion_PlacePrediction) GetPlace() string {
	if x != nil {
		return x.Place
	}
	return ""
}

func (x *AutocompletePlacesResponse_Suggestion_PlacePrediction) GetPlaceId() string {
	if x != nil {
		return x.PlaceId
	}
	return ""
}

func (x *AutocompletePlacesResponse_Suggestion_PlacePrediction) GetText() *AutocompletePlacesResponse_Suggestion_FormattableText {
	if x != nil {
		return x.Text
	}
	return nil
}

func (x *AutocompletePlacesResponse_Suggestion_PlacePrediction) GetStructuredFormat() *AutocompletePlacesResponse_Suggestion_StructuredFormat {
	if x != nil {
		return x.StructuredFormat
	}
	return nil
}

func (x *AutocompletePlacesResponse_Suggestion_PlacePrediction) GetTypes() []string {
	if x != nil {
		return x.Types
	}
	return nil
}

func (x *AutocompletePlacesResponse_Suggestion_PlacePrediction) GetDistanceMeters() int32 {
	if x != nil {
		return x.DistanceMeters
	}
	return 0
}

// Prediction results for a Query Autocomplete prediction.
type AutocompletePlacesResponse_Suggestion_QueryPrediction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The predicted text. This text does not represent a Place, but rather a
	// text query that could be used in a search endpoint (for example,
	// Text Search).
	//
	// `text` is recommended for developers who wish to show a single UI
	// element. Developers who wish to show two separate, but related, UI
	// elements may want to use `structured_format` instead. They are two
	// different ways to represent a query prediction. Users should not try to
	// parse `structured_format` into `text` or vice versa.
	//
	// May be in mixed languages if the request `input` and `language_code`
	// are in different languages or if part of the query does not have a
	// translation from the local language to `language_code`.
	Text *AutocompletePlacesResponse_Suggestion_FormattableText `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// A breakdown of the query prediction into main text containing the query
	// and secondary text containing additional disambiguating features (such
	// as a city or region).
	//
	// `structured_format` is recommended for developers who wish to show two
	// separate, but related, UI elements. Developers who wish to show a
	// single UI element may want to use `text` instead. They are two
	// different ways to represent a query prediction. Users should not try to
	// parse `structured_format` into `text` or vice versa.
	StructuredFormat *AutocompletePlacesResponse_Suggestion_StructuredFormat `protobuf:"bytes,2,opt,name=structured_format,json=structuredFormat,proto3" json:"structured_format,omitempty"`
}

func (x *AutocompletePlacesResponse_Suggestion_QueryPrediction) Reset() {
	*x = AutocompletePlacesResponse_Suggestion_QueryPrediction{}
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutocompletePlacesResponse_Suggestion_QueryPrediction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutocompletePlacesResponse_Suggestion_QueryPrediction) ProtoMessage() {}

func (x *AutocompletePlacesResponse_Suggestion_QueryPrediction) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutocompletePlacesResponse_Suggestion_QueryPrediction.ProtoReflect.Descriptor instead.
func (*AutocompletePlacesResponse_Suggestion_QueryPrediction) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{9, 0, 4}
}

func (x *AutocompletePlacesResponse_Suggestion_QueryPrediction) GetText() *AutocompletePlacesResponse_Suggestion_FormattableText {
	if x != nil {
		return x.Text
	}
	return nil
}

func (x *AutocompletePlacesResponse_Suggestion_QueryPrediction) GetStructuredFormat() *AutocompletePlacesResponse_Suggestion_StructuredFormat {
	if x != nil {
		return x.StructuredFormat
	}
	return nil
}

var File_google_maps_places_v1_places_service_proto protoreflect.FileDescriptor

var file_google_maps_places_v1_places_service_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x15, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x67,
	0x65, 0x6f, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x76, 0x69, 0x65, 0x77, 0x70, 0x6f, 0x72, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d,
	0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x75, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d,
	0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x76,
	0x5f, 0x63, 0x68, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x67, 0x65, 0x6f, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61,
	0x70, 0x73, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f,
	0x70, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2f,
	0x76, 0x31, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2f,
	0x76, 0x31, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f,
	0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6c,
	0x61, 0x74, 0x6c, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc1, 0x02, 0x0a, 0x11,
	0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x12, 0x30, 0x0a, 0x06, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6f, 0x72, 0x69,
	0x67, 0x69, 0x6e, 0x12, 0x47, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x53, 0x0a, 0x0f,
	0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d,
	0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0e, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x73, 0x12, 0x5c, 0x0a, 0x12, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x72, 0x6f,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22,
	0xa2, 0x06, 0x0a, 0x13, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4e, 0x65, 0x61, 0x72, 0x62, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x1f, 0x0a, 0x0b,
	0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x25, 0x0a,
	0x0e, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x54,
	0x79, 0x70, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x65, 0x78,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x69,
	0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x69, 0x6e, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x64, 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x12, 0x34, 0x0a, 0x16, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72,
	0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x14, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x50, 0x72, 0x69, 0x6d, 0x61,
	0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x28, 0x0a, 0x10, 0x6d, 0x61, 0x78, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x76, 0x0a, 0x14, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4e, 0x65,
	0x61, 0x72, 0x62, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x62, 0x0a, 0x0f, 0x72, 0x61, 0x6e,
	0x6b, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73,
	0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x4e, 0x65, 0x61, 0x72, 0x62, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x52,
	0x61, 0x6e, 0x6b, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0e, 0x72,
	0x61, 0x6e, 0x6b, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x5c, 0x0a,
	0x12, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x1a, 0x56, 0x0a, 0x13, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x37, 0x0a, 0x06, 0x63, 0x69, 0x72, 0x63, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73,
	0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x69, 0x72, 0x63, 0x6c,
	0x65, 0x48, 0x00, 0x52, 0x06, 0x63, 0x69, 0x72, 0x63, 0x6c, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x22, 0x4f, 0x0a, 0x0e, 0x52, 0x61, 0x6e, 0x6b, 0x50, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x52, 0x41, 0x4e, 0x4b, 0x5f, 0x50, 0x52,
	0x45, 0x46, 0x45, 0x52, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e,
	0x43, 0x45, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x4f, 0x50, 0x55, 0x4c, 0x41, 0x52, 0x49,
	0x54, 0x59, 0x10, 0x02, 0x22, 0xa0, 0x01, 0x0a, 0x14, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4e,
	0x65, 0x61, 0x72, 0x62, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x34, 0x0a,
	0x06, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x52, 0x06, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x73, 0x12, 0x52, 0x0a, 0x11, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x73,
	0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x10, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x22, 0x81, 0x0d, 0x0a, 0x11, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a,
	0x0a, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x74, 0x65, 0x78, 0x74, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x67,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x60, 0x0a, 0x0f, 0x72, 0x61, 0x6e, 0x6b, 0x5f,
	0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54,
	0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x52, 0x61, 0x6e, 0x6b, 0x50,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0e, 0x72, 0x61, 0x6e, 0x6b, 0x50,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19,
	0x0a, 0x08, 0x6f, 0x70, 0x65, 0x6e, 0x5f, 0x6e, 0x6f, 0x77, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x07, 0x6f, 0x70, 0x65, 0x6e, 0x4e, 0x6f, 0x77, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x69, 0x6e,
	0x5f, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x01, 0x52, 0x09, 0x6d,
	0x69, 0x6e, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x28, 0x0a, 0x10, 0x6d, 0x61, 0x78, 0x5f,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x44, 0x0a, 0x0c, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x6c, 0x65, 0x76, 0x65,
	0x6c, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x0b, 0x70, 0x72, 0x69,
	0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x73, 0x74, 0x72, 0x69,
	0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x5a, 0x0a, 0x0d,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x62, 0x69, 0x61, 0x73, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70,
	0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x69, 0x61, 0x73, 0x52, 0x0c, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x69, 0x61, 0x73, 0x12, 0x6f, 0x0a, 0x14, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x0a, 0x65, 0x76, 0x5f,
	0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x65, 0x78, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x45, 0x56, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x65, 0x76, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x5c, 0x0a, 0x12, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x72, 0x6f,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12,
	0x8b, 0x01, 0x0a, 0x1d, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x61, 0x6c, 0x6f, 0x6e, 0x67,
	0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6f, 0x6e, 0x67, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x1a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6f, 0x6e, 0x67, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x53, 0x0a,
	0x24, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x70, 0x75, 0x72, 0x65, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x72, 0x65, 0x61, 0x5f, 0x62, 0x75, 0x73, 0x69, 0x6e,
	0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x14, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x20, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x50, 0x75, 0x72, 0x65, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x41, 0x72, 0x65, 0x61, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73,
	0x65, 0x73, 0x1a, 0x8a, 0x01, 0x0a, 0x0c, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x69, 0x61, 0x73, 0x12, 0x39, 0x0a, 0x09, 0x72, 0x65, 0x63, 0x74, 0x61, 0x6e, 0x67, 0x6c, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x65, 0x6f, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x56, 0x69, 0x65, 0x77, 0x70, 0x6f, 0x72,
	0x74, 0x48, 0x00, 0x52, 0x09, 0x72, 0x65, 0x63, 0x74, 0x61, 0x6e, 0x67, 0x6c, 0x65, 0x12, 0x37,
	0x0a, 0x06, 0x63, 0x69, 0x72, 0x63, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x69, 0x72, 0x63, 0x6c, 0x65, 0x48, 0x00, 0x52,
	0x06, 0x63, 0x69, 0x72, 0x63, 0x6c, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x1a,
	0x58, 0x0a, 0x13, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x74, 0x72,
	0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x09, 0x72, 0x65, 0x63, 0x74, 0x61, 0x6e,
	0x67, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6f, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x56, 0x69, 0x65, 0x77,
	0x70, 0x6f, 0x72, 0x74, 0x48, 0x00, 0x52, 0x09, 0x72, 0x65, 0x63, 0x74, 0x61, 0x6e, 0x67, 0x6c,
	0x65, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x1a, 0x9f, 0x01, 0x0a, 0x09, 0x45, 0x56,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3c, 0x0a, 0x18, 0x6d, 0x69, 0x6e, 0x69, 0x6d,
	0x75, 0x6d, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x61, 0x74, 0x65,
	0x5f, 0x6b, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15,
	0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x43, 0x68, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x67, 0x52,
	0x61, 0x74, 0x65, 0x4b, 0x77, 0x12, 0x54, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x56, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x1a, 0x5e, 0x0a, 0x1a, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6f, 0x6e, 0x67, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x40, 0x0a, 0x08, 0x70, 0x6f, 0x6c,
	0x79, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x08, 0x70, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x22, 0x4e, 0x0a, 0x0e, 0x52,
	0x61, 0x6e, 0x6b, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x1f, 0x0a,
	0x1b, 0x52, 0x41, 0x4e, 0x4b, 0x5f, 0x50, 0x52, 0x45, 0x46, 0x45, 0x52, 0x45, 0x4e, 0x43, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c,
	0x0a, 0x08, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09,
	0x52, 0x45, 0x4c, 0x45, 0x56, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x02, 0x22, 0xf9, 0x01, 0x0a, 0x12,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x34, 0x0a, 0x06, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73,
	0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65,
	0x52, 0x06, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x12, 0x52, 0x0a, 0x11, 0x72, 0x6f, 0x75, 0x74,
	0x69, 0x6e, 0x67, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70,
	0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74,
	0x69, 0x6e, 0x67, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x10, 0x72, 0x6f, 0x75, 0x74,
	0x69, 0x6e, 0x67, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x12, 0x59, 0x0a, 0x13,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x75, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x75, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x75, 0x61, 0x6c, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x22, 0xd7, 0x01, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x50,
	0x68, 0x6f, 0x74, 0x6f, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x68,
	0x6f, 0x74, 0x6f, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25,
	0x0a, 0x0c, 0x6d, 0x61, 0x78, 0x5f, 0x77, 0x69, 0x64, 0x74, 0x68, 0x5f, 0x70, 0x78, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x57, 0x69,
	0x64, 0x74, 0x68, 0x50, 0x78, 0x12, 0x27, 0x0a, 0x0d, 0x6d, 0x61, 0x78, 0x5f, 0x68, 0x65, 0x69,
	0x67, 0x68, 0x74, 0x5f, 0x70, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x6d, 0x61, 0x78, 0x48, 0x65, 0x69, 0x67, 0x68, 0x74, 0x50, 0x78, 0x12, 0x31,
	0x0a, 0x12, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x72, 0x65, 0x64, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x10, 0x73, 0x6b, 0x69, 0x70, 0x48, 0x74, 0x74, 0x70, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x22, 0xaf, 0x01, 0x0a, 0x0a, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x4d, 0x65, 0x64, 0x69, 0x61,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x55, 0x72,
	0x69, 0x3a, 0x70, 0xea, 0x41, 0x6d, 0x0a, 0x20, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x68,
	0x6f, 0x74, 0x6f, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x12, 0x30, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73,
	0x2f, 0x7b, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x70, 0x68, 0x6f, 0x74,
	0x6f, 0x73, 0x2f, 0x7b, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x2a, 0x0b, 0x70, 0x68, 0x6f, 0x74,
	0x6f, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x73, 0x32, 0x0a, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x4d, 0x65,
	0x64, 0x69, 0x61, 0x22, 0xc4, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x50, 0x6c, 0x61, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x72, 0x65,
	0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65,
	0x12, 0x28, 0x0a, 0x0d, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9c, 0x08, 0x0a, 0x19, 0x41,
	0x75, 0x74, 0x6f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x63, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x12, 0x67, 0x0a, 0x0d, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x62, 0x69, 0x61, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x50,
	0x6c, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x69, 0x61, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x69, 0x61, 0x73, 0x12, 0x7c, 0x0a, 0x14,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x50,
	0x6c, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x16, 0x69, 0x6e,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x14, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x37, 0x0a, 0x15, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x64, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x05,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x69, 0x6e, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x64, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x28,
	0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x72, 0x65, 0x67, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0a, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x30,
	0x0a, 0x06, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74,
	0x4c, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e,
	0x12, 0x26, 0x0a, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x3f, 0x0a, 0x19, 0x69, 0x6e, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x17, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x53, 0x0a, 0x24, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x70,
	0x75, 0x72, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x72, 0x65, 0x61,
	0x5f, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x20, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x50,
	0x75, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x72, 0x65, 0x61, 0x42, 0x75,
	0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x65, 0x73, 0x1a, 0x8a, 0x01, 0x0a, 0x0c, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x69, 0x61, 0x73, 0x12, 0x39, 0x0a, 0x09, 0x72, 0x65, 0x63,
	0x74, 0x61, 0x6e, 0x67, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6f, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x56,
	0x69, 0x65, 0x77, 0x70, 0x6f, 0x72, 0x74, 0x48, 0x00, 0x52, 0x09, 0x72, 0x65, 0x63, 0x74, 0x61,
	0x6e, 0x67, 0x6c, 0x65, 0x12, 0x37, 0x0a, 0x06, 0x63, 0x69, 0x72, 0x63, 0x6c, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61,
	0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x69, 0x72,
	0x63, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x06, 0x63, 0x69, 0x72, 0x63, 0x6c, 0x65, 0x42, 0x06, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x1a, 0x91, 0x01, 0x0a, 0x13, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a,
	0x09, 0x72, 0x65, 0x63, 0x74, 0x61, 0x6e, 0x67, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6f, 0x2e, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x56, 0x69, 0x65, 0x77, 0x70, 0x6f, 0x72, 0x74, 0x48, 0x00, 0x52, 0x09, 0x72,
	0x65, 0x63, 0x74, 0x61, 0x6e, 0x67, 0x6c, 0x65, 0x12, 0x37, 0x0a, 0x06, 0x63, 0x69, 0x72, 0x63,
	0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x69, 0x72, 0x63, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x06, 0x63, 0x69, 0x72, 0x63, 0x6c,
	0x65, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0xd1, 0x0b, 0x0a, 0x1a, 0x41, 0x75,
	0x74, 0x6f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5e, 0x0a, 0x0b, 0x73, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
	0x74, 0x65, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x73, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0xd2, 0x0a, 0x0a, 0x0a, 0x53, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x79, 0x0a, 0x10, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x63, 0x6f,
	0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x50, 0x6c, 0x61, 0x63, 0x65, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x0f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x79, 0x0a, 0x10, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74,
	0x65, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0f, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x4f, 0x0a,
	0x0b, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x21, 0x0a, 0x0c,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12,
	0x1d, 0x0a, 0x0a, 0x65, 0x6e, 0x64, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x1a, 0x89,
	0x01, 0x0a, 0x0f, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x65,
	0x78, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x62, 0x0a, 0x07, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x75, 0x74, 0x6f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x63,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x61, 0x6e, 0x67,
	0x65, 0x52, 0x07, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x1a, 0xf2, 0x01, 0x0a, 0x10, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12,
	0x69, 0x0a, 0x09, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73,
	0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x63,
	0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x65, 0x78, 0x74,
	0x52, 0x08, 0x6d, 0x61, 0x69, 0x6e, 0x54, 0x65, 0x78, 0x74, 0x12, 0x73, 0x0a, 0x0e, 0x73, 0x65,
	0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73,
	0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x63,
	0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x65, 0x78, 0x74,
	0x52, 0x0d, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x54, 0x65, 0x78, 0x74, 0x1a,
	0x81, 0x03, 0x0a, 0x0f, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x36, 0x0a, 0x05, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x20, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x6c, 0x61, 0x63, 0x65, 0x52, 0x05, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x49, 0x64, 0x12, 0x60, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61,
	0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74,
	0x6f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x65,
	0x78, 0x74, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x7a, 0x0a, 0x11, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70,
	0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f,
	0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x46, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x52, 0x10, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x46, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x05, 0x74, 0x79, 0x70, 0x65, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x64, 0x69,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0e, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x1a, 0xef, 0x01, 0x0a, 0x0f, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x60, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d,
	0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75,
	0x74, 0x6f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x54,
	0x65, 0x78, 0x74, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x7a, 0x0a, 0x11, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61,
	0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74,
	0x6f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x46, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x52, 0x10, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x46,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x06, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x32, 0x92, 0x06,
	0x0a, 0x06, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x12, 0x8b, 0x01, 0x0a, 0x0c, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x4e, 0x65, 0x61, 0x72, 0x62, 0x79, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4e, 0x65, 0x61, 0x72, 0x62, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d,
	0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x4e, 0x65, 0x61, 0x72, 0x62, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x22, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1c, 0x3a, 0x01, 0x2a, 0x22, 0x17, 0x2f,
	0x76, 0x31, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x4e, 0x65, 0x61, 0x72, 0x62, 0x79, 0x12, 0x83, 0x01, 0x0a, 0x0a, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x54, 0x65, 0x78, 0x74, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d,
	0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x65,
	0x78, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x20, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x1a, 0x3a, 0x01, 0x2a, 0x22, 0x15, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x65, 0x78, 0x74, 0x12, 0x92, 0x01, 0x0a,
	0x0d, 0x47, 0x65, 0x74, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x12, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x4d,
	0x65, 0x64, 0x69, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x22, 0x31,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x24, 0x12, 0x22, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x64, 0x69, 0x61,
	0x7d, 0x12, 0x74, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x12, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d,
	0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c,
	0x61, 0x63, 0x65, 0x22, 0x22, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x15, 0x12, 0x13, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x9d, 0x01, 0x0a, 0x12, 0x41, 0x75, 0x74, 0x6f,
	0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x12, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x63, 0x6f, 0x6d, 0x70, 0x6c,
	0x65, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x63, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x22, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1c, 0x3a, 0x01, 0x2a, 0x22, 0x17,
	0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x3a, 0x61, 0x75, 0x74, 0x6f, 0x63,
	0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x1a, 0x49, 0xca, 0x41, 0x15, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x42, 0xa3, 0x01, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x42, 0x12, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x37, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6d, 0x61, 0x70, 0x73,
	0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x73, 0x70, 0x62, 0x3b, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x70, 0x62, 0xa2,
	0x02, 0x06, 0x47, 0x4d, 0x50, 0x53, 0x56, 0x31, 0xaa, 0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x4d, 0x61, 0x70, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x56, 0x31,
	0xca, 0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x4d, 0x61, 0x70, 0x73, 0x5c, 0x50,
	0x6c, 0x61, 0x63, 0x65, 0x73, 0x5c, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_maps_places_v1_places_service_proto_rawDescOnce sync.Once
	file_google_maps_places_v1_places_service_proto_rawDescData = file_google_maps_places_v1_places_service_proto_rawDesc
)

func file_google_maps_places_v1_places_service_proto_rawDescGZIP() []byte {
	file_google_maps_places_v1_places_service_proto_rawDescOnce.Do(func() {
		file_google_maps_places_v1_places_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_maps_places_v1_places_service_proto_rawDescData)
	})
	return file_google_maps_places_v1_places_service_proto_rawDescData
}

var file_google_maps_places_v1_places_service_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_maps_places_v1_places_service_proto_msgTypes = make([]protoimpl.MessageInfo, 23)
var file_google_maps_places_v1_places_service_proto_goTypes = []any{
	(SearchNearbyRequest_RankPreference)(0),                        // 0: google.maps.places.v1.SearchNearbyRequest.RankPreference
	(SearchTextRequest_RankPreference)(0),                          // 1: google.maps.places.v1.SearchTextRequest.RankPreference
	(*RoutingParameters)(nil),                                      // 2: google.maps.places.v1.RoutingParameters
	(*SearchNearbyRequest)(nil),                                    // 3: google.maps.places.v1.SearchNearbyRequest
	(*SearchNearbyResponse)(nil),                                   // 4: google.maps.places.v1.SearchNearbyResponse
	(*SearchTextRequest)(nil),                                      // 5: google.maps.places.v1.SearchTextRequest
	(*SearchTextResponse)(nil),                                     // 6: google.maps.places.v1.SearchTextResponse
	(*GetPhotoMediaRequest)(nil),                                   // 7: google.maps.places.v1.GetPhotoMediaRequest
	(*PhotoMedia)(nil),                                             // 8: google.maps.places.v1.PhotoMedia
	(*GetPlaceRequest)(nil),                                        // 9: google.maps.places.v1.GetPlaceRequest
	(*AutocompletePlacesRequest)(nil),                              // 10: google.maps.places.v1.AutocompletePlacesRequest
	(*AutocompletePlacesResponse)(nil),                             // 11: google.maps.places.v1.AutocompletePlacesResponse
	(*SearchNearbyRequest_LocationRestriction)(nil),                // 12: google.maps.places.v1.SearchNearbyRequest.LocationRestriction
	(*SearchTextRequest_LocationBias)(nil),                         // 13: google.maps.places.v1.SearchTextRequest.LocationBias
	(*SearchTextRequest_LocationRestriction)(nil),                  // 14: google.maps.places.v1.SearchTextRequest.LocationRestriction
	(*SearchTextRequest_EVOptions)(nil),                            // 15: google.maps.places.v1.SearchTextRequest.EVOptions
	(*SearchTextRequest_SearchAlongRouteParameters)(nil),           // 16: google.maps.places.v1.SearchTextRequest.SearchAlongRouteParameters
	(*AutocompletePlacesRequest_LocationBias)(nil),                 // 17: google.maps.places.v1.AutocompletePlacesRequest.LocationBias
	(*AutocompletePlacesRequest_LocationRestriction)(nil),          // 18: google.maps.places.v1.AutocompletePlacesRequest.LocationRestriction
	(*AutocompletePlacesResponse_Suggestion)(nil),                  // 19: google.maps.places.v1.AutocompletePlacesResponse.Suggestion
	(*AutocompletePlacesResponse_Suggestion_StringRange)(nil),      // 20: google.maps.places.v1.AutocompletePlacesResponse.Suggestion.StringRange
	(*AutocompletePlacesResponse_Suggestion_FormattableText)(nil),  // 21: google.maps.places.v1.AutocompletePlacesResponse.Suggestion.FormattableText
	(*AutocompletePlacesResponse_Suggestion_StructuredFormat)(nil), // 22: google.maps.places.v1.AutocompletePlacesResponse.Suggestion.StructuredFormat
	(*AutocompletePlacesResponse_Suggestion_PlacePrediction)(nil),  // 23: google.maps.places.v1.AutocompletePlacesResponse.Suggestion.PlacePrediction
	(*AutocompletePlacesResponse_Suggestion_QueryPrediction)(nil),  // 24: google.maps.places.v1.AutocompletePlacesResponse.Suggestion.QueryPrediction
	(*latlng.LatLng)(nil),                                          // 25: google.type.LatLng
	(TravelMode)(0),                                                // 26: google.maps.places.v1.TravelMode
	(*RouteModifiers)(nil),                                         // 27: google.maps.places.v1.RouteModifiers
	(RoutingPreference)(0),                                         // 28: google.maps.places.v1.RoutingPreference
	(*Place)(nil),                                                  // 29: google.maps.places.v1.Place
	(*RoutingSummary)(nil),                                         // 30: google.maps.places.v1.RoutingSummary
	(PriceLevel)(0),                                                // 31: google.maps.places.v1.PriceLevel
	(*ContextualContent)(nil),                                      // 32: google.maps.places.v1.ContextualContent
	(*Circle)(nil),                                                 // 33: google.maps.places.v1.Circle
	(*viewport.Viewport)(nil),                                      // 34: google.geo.type.Viewport
	(EVConnectorType)(0),                                           // 35: google.maps.places.v1.EVConnectorType
	(*Polyline)(nil),                                               // 36: google.maps.places.v1.Polyline
}
var file_google_maps_places_v1_places_service_proto_depIdxs = []int32{
	25, // 0: google.maps.places.v1.RoutingParameters.origin:type_name -> google.type.LatLng
	26, // 1: google.maps.places.v1.RoutingParameters.travel_mode:type_name -> google.maps.places.v1.TravelMode
	27, // 2: google.maps.places.v1.RoutingParameters.route_modifiers:type_name -> google.maps.places.v1.RouteModifiers
	28, // 3: google.maps.places.v1.RoutingParameters.routing_preference:type_name -> google.maps.places.v1.RoutingPreference
	12, // 4: google.maps.places.v1.SearchNearbyRequest.location_restriction:type_name -> google.maps.places.v1.SearchNearbyRequest.LocationRestriction
	0,  // 5: google.maps.places.v1.SearchNearbyRequest.rank_preference:type_name -> google.maps.places.v1.SearchNearbyRequest.RankPreference
	2,  // 6: google.maps.places.v1.SearchNearbyRequest.routing_parameters:type_name -> google.maps.places.v1.RoutingParameters
	29, // 7: google.maps.places.v1.SearchNearbyResponse.places:type_name -> google.maps.places.v1.Place
	30, // 8: google.maps.places.v1.SearchNearbyResponse.routing_summaries:type_name -> google.maps.places.v1.RoutingSummary
	1,  // 9: google.maps.places.v1.SearchTextRequest.rank_preference:type_name -> google.maps.places.v1.SearchTextRequest.RankPreference
	31, // 10: google.maps.places.v1.SearchTextRequest.price_levels:type_name -> google.maps.places.v1.PriceLevel
	13, // 11: google.maps.places.v1.SearchTextRequest.location_bias:type_name -> google.maps.places.v1.SearchTextRequest.LocationBias
	14, // 12: google.maps.places.v1.SearchTextRequest.location_restriction:type_name -> google.maps.places.v1.SearchTextRequest.LocationRestriction
	15, // 13: google.maps.places.v1.SearchTextRequest.ev_options:type_name -> google.maps.places.v1.SearchTextRequest.EVOptions
	2,  // 14: google.maps.places.v1.SearchTextRequest.routing_parameters:type_name -> google.maps.places.v1.RoutingParameters
	16, // 15: google.maps.places.v1.SearchTextRequest.search_along_route_parameters:type_name -> google.maps.places.v1.SearchTextRequest.SearchAlongRouteParameters
	29, // 16: google.maps.places.v1.SearchTextResponse.places:type_name -> google.maps.places.v1.Place
	30, // 17: google.maps.places.v1.SearchTextResponse.routing_summaries:type_name -> google.maps.places.v1.RoutingSummary
	32, // 18: google.maps.places.v1.SearchTextResponse.contextual_contents:type_name -> google.maps.places.v1.ContextualContent
	17, // 19: google.maps.places.v1.AutocompletePlacesRequest.location_bias:type_name -> google.maps.places.v1.AutocompletePlacesRequest.LocationBias
	18, // 20: google.maps.places.v1.AutocompletePlacesRequest.location_restriction:type_name -> google.maps.places.v1.AutocompletePlacesRequest.LocationRestriction
	25, // 21: google.maps.places.v1.AutocompletePlacesRequest.origin:type_name -> google.type.LatLng
	19, // 22: google.maps.places.v1.AutocompletePlacesResponse.suggestions:type_name -> google.maps.places.v1.AutocompletePlacesResponse.Suggestion
	33, // 23: google.maps.places.v1.SearchNearbyRequest.LocationRestriction.circle:type_name -> google.maps.places.v1.Circle
	34, // 24: google.maps.places.v1.SearchTextRequest.LocationBias.rectangle:type_name -> google.geo.type.Viewport
	33, // 25: google.maps.places.v1.SearchTextRequest.LocationBias.circle:type_name -> google.maps.places.v1.Circle
	34, // 26: google.maps.places.v1.SearchTextRequest.LocationRestriction.rectangle:type_name -> google.geo.type.Viewport
	35, // 27: google.maps.places.v1.SearchTextRequest.EVOptions.connector_types:type_name -> google.maps.places.v1.EVConnectorType
	36, // 28: google.maps.places.v1.SearchTextRequest.SearchAlongRouteParameters.polyline:type_name -> google.maps.places.v1.Polyline
	34, // 29: google.maps.places.v1.AutocompletePlacesRequest.LocationBias.rectangle:type_name -> google.geo.type.Viewport
	33, // 30: google.maps.places.v1.AutocompletePlacesRequest.LocationBias.circle:type_name -> google.maps.places.v1.Circle
	34, // 31: google.maps.places.v1.AutocompletePlacesRequest.LocationRestriction.rectangle:type_name -> google.geo.type.Viewport
	33, // 32: google.maps.places.v1.AutocompletePlacesRequest.LocationRestriction.circle:type_name -> google.maps.places.v1.Circle
	23, // 33: google.maps.places.v1.AutocompletePlacesResponse.Suggestion.place_prediction:type_name -> google.maps.places.v1.AutocompletePlacesResponse.Suggestion.PlacePrediction
	24, // 34: google.maps.places.v1.AutocompletePlacesResponse.Suggestion.query_prediction:type_name -> google.maps.places.v1.AutocompletePlacesResponse.Suggestion.QueryPrediction
	20, // 35: google.maps.places.v1.AutocompletePlacesResponse.Suggestion.FormattableText.matches:type_name -> google.maps.places.v1.AutocompletePlacesResponse.Suggestion.StringRange
	21, // 36: google.maps.places.v1.AutocompletePlacesResponse.Suggestion.StructuredFormat.main_text:type_name -> google.maps.places.v1.AutocompletePlacesResponse.Suggestion.FormattableText
	21, // 37: google.maps.places.v1.AutocompletePlacesResponse.Suggestion.StructuredFormat.secondary_text:type_name -> google.maps.places.v1.AutocompletePlacesResponse.Suggestion.FormattableText
	21, // 38: google.maps.places.v1.AutocompletePlacesResponse.Suggestion.PlacePrediction.text:type_name -> google.maps.places.v1.AutocompletePlacesResponse.Suggestion.FormattableText
	22, // 39: google.maps.places.v1.AutocompletePlacesResponse.Suggestion.PlacePrediction.structured_format:type_name -> google.maps.places.v1.AutocompletePlacesResponse.Suggestion.StructuredFormat
	21, // 40: google.maps.places.v1.AutocompletePlacesResponse.Suggestion.QueryPrediction.text:type_name -> google.maps.places.v1.AutocompletePlacesResponse.Suggestion.FormattableText
	22, // 41: google.maps.places.v1.AutocompletePlacesResponse.Suggestion.QueryPrediction.structured_format:type_name -> google.maps.places.v1.AutocompletePlacesResponse.Suggestion.StructuredFormat
	3,  // 42: google.maps.places.v1.Places.SearchNearby:input_type -> google.maps.places.v1.SearchNearbyRequest
	5,  // 43: google.maps.places.v1.Places.SearchText:input_type -> google.maps.places.v1.SearchTextRequest
	7,  // 44: google.maps.places.v1.Places.GetPhotoMedia:input_type -> google.maps.places.v1.GetPhotoMediaRequest
	9,  // 45: google.maps.places.v1.Places.GetPlace:input_type -> google.maps.places.v1.GetPlaceRequest
	10, // 46: google.maps.places.v1.Places.AutocompletePlaces:input_type -> google.maps.places.v1.AutocompletePlacesRequest
	4,  // 47: google.maps.places.v1.Places.SearchNearby:output_type -> google.maps.places.v1.SearchNearbyResponse
	6,  // 48: google.maps.places.v1.Places.SearchText:output_type -> google.maps.places.v1.SearchTextResponse
	8,  // 49: google.maps.places.v1.Places.GetPhotoMedia:output_type -> google.maps.places.v1.PhotoMedia
	29, // 50: google.maps.places.v1.Places.GetPlace:output_type -> google.maps.places.v1.Place
	11, // 51: google.maps.places.v1.Places.AutocompletePlaces:output_type -> google.maps.places.v1.AutocompletePlacesResponse
	47, // [47:52] is the sub-list for method output_type
	42, // [42:47] is the sub-list for method input_type
	42, // [42:42] is the sub-list for extension type_name
	42, // [42:42] is the sub-list for extension extendee
	0,  // [0:42] is the sub-list for field type_name
}

func init() { file_google_maps_places_v1_places_service_proto_init() }
func file_google_maps_places_v1_places_service_proto_init() {
	if File_google_maps_places_v1_places_service_proto != nil {
		return
	}
	file_google_maps_places_v1_contextual_content_proto_init()
	file_google_maps_places_v1_ev_charging_proto_init()
	file_google_maps_places_v1_geometry_proto_init()
	file_google_maps_places_v1_place_proto_init()
	file_google_maps_places_v1_polyline_proto_init()
	file_google_maps_places_v1_route_modifiers_proto_init()
	file_google_maps_places_v1_routing_preference_proto_init()
	file_google_maps_places_v1_routing_summary_proto_init()
	file_google_maps_places_v1_travel_mode_proto_init()
	file_google_maps_places_v1_places_service_proto_msgTypes[10].OneofWrappers = []any{
		(*SearchNearbyRequest_LocationRestriction_Circle)(nil),
	}
	file_google_maps_places_v1_places_service_proto_msgTypes[11].OneofWrappers = []any{
		(*SearchTextRequest_LocationBias_Rectangle)(nil),
		(*SearchTextRequest_LocationBias_Circle)(nil),
	}
	file_google_maps_places_v1_places_service_proto_msgTypes[12].OneofWrappers = []any{
		(*SearchTextRequest_LocationRestriction_Rectangle)(nil),
	}
	file_google_maps_places_v1_places_service_proto_msgTypes[15].OneofWrappers = []any{
		(*AutocompletePlacesRequest_LocationBias_Rectangle)(nil),
		(*AutocompletePlacesRequest_LocationBias_Circle)(nil),
	}
	file_google_maps_places_v1_places_service_proto_msgTypes[16].OneofWrappers = []any{
		(*AutocompletePlacesRequest_LocationRestriction_Rectangle)(nil),
		(*AutocompletePlacesRequest_LocationRestriction_Circle)(nil),
	}
	file_google_maps_places_v1_places_service_proto_msgTypes[17].OneofWrappers = []any{
		(*AutocompletePlacesResponse_Suggestion_PlacePrediction_)(nil),
		(*AutocompletePlacesResponse_Suggestion_QueryPrediction_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_maps_places_v1_places_service_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_maps_places_v1_places_service_proto_goTypes,
		DependencyIndexes: file_google_maps_places_v1_places_service_proto_depIdxs,
		EnumInfos:         file_google_maps_places_v1_places_service_proto_enumTypes,
		MessageInfos:      file_google_maps_places_v1_places_service_proto_msgTypes,
	}.Build()
	File_google_maps_places_v1_places_service_proto = out.File
	file_google_maps_places_v1_places_service_proto_rawDesc = nil
	file_google_maps_places_v1_places_service_proto_goTypes = nil
	file_google_maps_places_v1_places_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// PlacesClient is the client API for Places service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PlacesClient interface {
	// Search for places near locations.
	SearchNearby(ctx context.Context, in *SearchNearbyRequest, opts ...grpc.CallOption) (*SearchNearbyResponse, error)
	// Text query based place search.
	SearchText(ctx context.Context, in *SearchTextRequest, opts ...grpc.CallOption) (*SearchTextResponse, error)
	// Get a photo media with a photo reference string.
	GetPhotoMedia(ctx context.Context, in *GetPhotoMediaRequest, opts ...grpc.CallOption) (*PhotoMedia, error)
	// Get the details of a place based on its resource name, which is a string
	// in the `places/{place_id}` format.
	GetPlace(ctx context.Context, in *GetPlaceRequest, opts ...grpc.CallOption) (*Place, error)
	// Returns predictions for the given input.
	AutocompletePlaces(ctx context.Context, in *AutocompletePlacesRequest, opts ...grpc.CallOption) (*AutocompletePlacesResponse, error)
}

type placesClient struct {
	cc grpc.ClientConnInterface
}

func NewPlacesClient(cc grpc.ClientConnInterface) PlacesClient {
	return &placesClient{cc}
}

func (c *placesClient) SearchNearby(ctx context.Context, in *SearchNearbyRequest, opts ...grpc.CallOption) (*SearchNearbyResponse, error) {
	out := new(SearchNearbyResponse)
	err := c.cc.Invoke(ctx, "/google.maps.places.v1.Places/SearchNearby", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *placesClient) SearchText(ctx context.Context, in *SearchTextRequest, opts ...grpc.CallOption) (*SearchTextResponse, error) {
	out := new(SearchTextResponse)
	err := c.cc.Invoke(ctx, "/google.maps.places.v1.Places/SearchText", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *placesClient) GetPhotoMedia(ctx context.Context, in *GetPhotoMediaRequest, opts ...grpc.CallOption) (*PhotoMedia, error) {
	out := new(PhotoMedia)
	err := c.cc.Invoke(ctx, "/google.maps.places.v1.Places/GetPhotoMedia", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *placesClient) GetPlace(ctx context.Context, in *GetPlaceRequest, opts ...grpc.CallOption) (*Place, error) {
	out := new(Place)
	err := c.cc.Invoke(ctx, "/google.maps.places.v1.Places/GetPlace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *placesClient) AutocompletePlaces(ctx context.Context, in *AutocompletePlacesRequest, opts ...grpc.CallOption) (*AutocompletePlacesResponse, error) {
	out := new(AutocompletePlacesResponse)
	err := c.cc.Invoke(ctx, "/google.maps.places.v1.Places/AutocompletePlaces", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PlacesServer is the server API for Places service.
type PlacesServer interface {
	// Search for places near locations.
	SearchNearby(context.Context, *SearchNearbyRequest) (*SearchNearbyResponse, error)
	// Text query based place search.
	SearchText(context.Context, *SearchTextRequest) (*SearchTextResponse, error)
	// Get a photo media with a photo reference string.
	GetPhotoMedia(context.Context, *GetPhotoMediaRequest) (*PhotoMedia, error)
	// Get the details of a place based on its resource name, which is a string
	// in the `places/{place_id}` format.
	GetPlace(context.Context, *GetPlaceRequest) (*Place, error)
	// Returns predictions for the given input.
	AutocompletePlaces(context.Context, *AutocompletePlacesRequest) (*AutocompletePlacesResponse, error)
}

// UnimplementedPlacesServer can be embedded to have forward compatible implementations.
type UnimplementedPlacesServer struct {
}

func (*UnimplementedPlacesServer) SearchNearby(context.Context, *SearchNearbyRequest) (*SearchNearbyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchNearby not implemented")
}
func (*UnimplementedPlacesServer) SearchText(context.Context, *SearchTextRequest) (*SearchTextResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchText not implemented")
}
func (*UnimplementedPlacesServer) GetPhotoMedia(context.Context, *GetPhotoMediaRequest) (*PhotoMedia, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPhotoMedia not implemented")
}
func (*UnimplementedPlacesServer) GetPlace(context.Context, *GetPlaceRequest) (*Place, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPlace not implemented")
}
func (*UnimplementedPlacesServer) AutocompletePlaces(context.Context, *AutocompletePlacesRequest) (*AutocompletePlacesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AutocompletePlaces not implemented")
}

func RegisterPlacesServer(s *grpc.Server, srv PlacesServer) {
	s.RegisterService(&_Places_serviceDesc, srv)
}

func _Places_SearchNearby_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchNearbyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlacesServer).SearchNearby(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.maps.places.v1.Places/SearchNearby",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlacesServer).SearchNearby(ctx, req.(*SearchNearbyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Places_SearchText_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchTextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlacesServer).SearchText(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.maps.places.v1.Places/SearchText",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlacesServer).SearchText(ctx, req.(*SearchTextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Places_GetPhotoMedia_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPhotoMediaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlacesServer).GetPhotoMedia(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.maps.places.v1.Places/GetPhotoMedia",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlacesServer).GetPhotoMedia(ctx, req.(*GetPhotoMediaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Places_GetPlace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPlaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlacesServer).GetPlace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.maps.places.v1.Places/GetPlace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlacesServer).GetPlace(ctx, req.(*GetPlaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Places_AutocompletePlaces_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AutocompletePlacesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlacesServer).AutocompletePlaces(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.maps.places.v1.Places/AutocompletePlaces",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlacesServer).AutocompletePlaces(ctx, req.(*AutocompletePlacesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Places_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.maps.places.v1.Places",
	HandlerType: (*PlacesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SearchNearby",
			Handler:    _Places_SearchNearby_Handler,
		},
		{
			MethodName: "SearchText",
			Handler:    _Places_SearchText_Handler,
		},
		{
			MethodName: "GetPhotoMedia",
			Handler:    _Places_GetPhotoMedia_Handler,
		},
		{
			MethodName: "GetPlace",
			Handler:    _Places_GetPlace_Handler,
		},
		{
			MethodName: "AutocompletePlaces",
			Handler:    _Places_AutocompletePlaces_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/maps/places/v1/places_service.proto",
}
