// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/maps/areainsights/v1/area_insights_service.proto

package areainsightspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	latlng "google.golang.org/genproto/googleapis/type/latlng"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Supported insights.
type Insight int32

const (
	// Not Specified.
	Insight_INSIGHT_UNSPECIFIED Insight = 0
	// Count insight.
	//
	// When this insight is specified ComputeInsights returns the number of
	// places that match the specified filter criteria.
	//
	// Example request:
	// ```
	//
	//	{
	//	  "insights": ["INSIGHT_COUNT"],
	//	  "filter": {
	//	    "locationFilter": {
	//	      "region": {
	//	        "place": "places/ChIJPV4oX_65j4ARVW8IJ6IJUYs"
	//	      }
	//	    },
	//	    "typeFilter": {
	//	      "includedTypes": ["restaurant"]
	//	    },
	//	    "operatingStatus": ["OPERATING_STATUS_OPERATIONAL"],
	//	    "priceLevels": [
	//	      "PRICE_LEVEL_FREE",
	//	      "PRICE_LEVEL_INEXPENSIVE"
	//	    ],
	//	    "ratingFilter": {
	//	      "minRating": 4.0
	//	    }
	//	  }
	//	}
	//
	// ```
	//
	// Example response:
	// ```
	//
	//	{
	//	  "count": 1234
	//	}
	//
	// ```
	Insight_INSIGHT_COUNT Insight = 1
	// Return Places
	//
	// When this insight is specified ComputeInsights returns places IDs
	// that match the specified filter criteria.
	//
	// Example request:
	// ```
	//
	//	{
	//	  "insights": ["INSIGHT_PLACES"],
	//	  "filter": {
	//	    "locationFilter": {
	//	      "region": {
	//	        "place": "places/ChIJPV4oX_65j4ARVW8IJ6IJUYs"
	//	      }
	//	    },
	//	    "typeFilter": {
	//	      "includedTypes": ["restaurant"]
	//	    },
	//	    "operatingStatus": ["OPERATING_STATUS_OPERATIONAL"],
	//	    "priceLevels": [
	//	      "PRICE_LEVEL_FREE",
	//	      "PRICE_LEVEL_INEXPENSIVE"
	//	    ],
	//	    "ratingFilter": {
	//	      "minRating": 4.0
	//	    }
	//	  }
	//	}
	//
	// ```
	//
	// Example response:
	// ```
	//
	//	{
	//	  "placeInsights": [
	//	    {"place": "places/ABC"},
	//	    {"place": "places/PQR"},
	//	    {"place": "places/XYZ"}
	//	  ]
	//	}
	//
	// ```
	Insight_INSIGHT_PLACES Insight = 2
)

// Enum value maps for Insight.
var (
	Insight_name = map[int32]string{
		0: "INSIGHT_UNSPECIFIED",
		1: "INSIGHT_COUNT",
		2: "INSIGHT_PLACES",
	}
	Insight_value = map[string]int32{
		"INSIGHT_UNSPECIFIED": 0,
		"INSIGHT_COUNT":       1,
		"INSIGHT_PLACES":      2,
	}
)

func (x Insight) Enum() *Insight {
	p := new(Insight)
	*p = x
	return p
}

func (x Insight) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Insight) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_areainsights_v1_area_insights_service_proto_enumTypes[0].Descriptor()
}

func (Insight) Type() protoreflect.EnumType {
	return &file_google_maps_areainsights_v1_area_insights_service_proto_enumTypes[0]
}

func (x Insight) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Insight.Descriptor instead.
func (Insight) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_areainsights_v1_area_insights_service_proto_rawDescGZIP(), []int{0}
}

// Operating status of the place.
type OperatingStatus int32

const (
	// Not specified. This value should not be used.
	OperatingStatus_OPERATING_STATUS_UNSPECIFIED OperatingStatus = 0
	// The place is operational and its open during its defined hours.
	OperatingStatus_OPERATING_STATUS_OPERATIONAL OperatingStatus = 1
	// The Place is no longer in business.
	OperatingStatus_OPERATING_STATUS_PERMANENTLY_CLOSED OperatingStatus = 3
	// The place is temporarily closed and expected to reopen in the future.
	OperatingStatus_OPERATING_STATUS_TEMPORARILY_CLOSED OperatingStatus = 4
)

// Enum value maps for OperatingStatus.
var (
	OperatingStatus_name = map[int32]string{
		0: "OPERATING_STATUS_UNSPECIFIED",
		1: "OPERATING_STATUS_OPERATIONAL",
		3: "OPERATING_STATUS_PERMANENTLY_CLOSED",
		4: "OPERATING_STATUS_TEMPORARILY_CLOSED",
	}
	OperatingStatus_value = map[string]int32{
		"OPERATING_STATUS_UNSPECIFIED":        0,
		"OPERATING_STATUS_OPERATIONAL":        1,
		"OPERATING_STATUS_PERMANENTLY_CLOSED": 3,
		"OPERATING_STATUS_TEMPORARILY_CLOSED": 4,
	}
)

func (x OperatingStatus) Enum() *OperatingStatus {
	p := new(OperatingStatus)
	*p = x
	return p
}

func (x OperatingStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OperatingStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_areainsights_v1_area_insights_service_proto_enumTypes[1].Descriptor()
}

func (OperatingStatus) Type() protoreflect.EnumType {
	return &file_google_maps_areainsights_v1_area_insights_service_proto_enumTypes[1]
}

func (x OperatingStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OperatingStatus.Descriptor instead.
func (OperatingStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_areainsights_v1_area_insights_service_proto_rawDescGZIP(), []int{1}
}

// Price level of the place.
type PriceLevel int32

const (
	// Not specified. This value should not be used.
	PriceLevel_PRICE_LEVEL_UNSPECIFIED PriceLevel = 0
	// Place provides free services.
	PriceLevel_PRICE_LEVEL_FREE PriceLevel = 1
	// Place provides inexpensive services.
	PriceLevel_PRICE_LEVEL_INEXPENSIVE PriceLevel = 2
	// Place provides moderately priced services.
	PriceLevel_PRICE_LEVEL_MODERATE PriceLevel = 3
	// Place provides expensive services.
	PriceLevel_PRICE_LEVEL_EXPENSIVE PriceLevel = 4
	// Place provides very expensive services.
	PriceLevel_PRICE_LEVEL_VERY_EXPENSIVE PriceLevel = 5
)

// Enum value maps for PriceLevel.
var (
	PriceLevel_name = map[int32]string{
		0: "PRICE_LEVEL_UNSPECIFIED",
		1: "PRICE_LEVEL_FREE",
		2: "PRICE_LEVEL_INEXPENSIVE",
		3: "PRICE_LEVEL_MODERATE",
		4: "PRICE_LEVEL_EXPENSIVE",
		5: "PRICE_LEVEL_VERY_EXPENSIVE",
	}
	PriceLevel_value = map[string]int32{
		"PRICE_LEVEL_UNSPECIFIED":    0,
		"PRICE_LEVEL_FREE":           1,
		"PRICE_LEVEL_INEXPENSIVE":    2,
		"PRICE_LEVEL_MODERATE":       3,
		"PRICE_LEVEL_EXPENSIVE":      4,
		"PRICE_LEVEL_VERY_EXPENSIVE": 5,
	}
)

func (x PriceLevel) Enum() *PriceLevel {
	p := new(PriceLevel)
	*p = x
	return p
}

func (x PriceLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PriceLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_areainsights_v1_area_insights_service_proto_enumTypes[2].Descriptor()
}

func (PriceLevel) Type() protoreflect.EnumType {
	return &file_google_maps_areainsights_v1_area_insights_service_proto_enumTypes[2]
}

func (x PriceLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PriceLevel.Descriptor instead.
func (PriceLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_areainsights_v1_area_insights_service_proto_rawDescGZIP(), []int{2}
}

// Request for the ComputeInsights RPC.
type ComputeInsightsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Insights to compute. Currently only INSIGHT_COUNT and
	// INSIGHT_PLACES are supported.
	Insights []Insight `protobuf:"varint,4,rep,packed,name=insights,proto3,enum=google.maps.areainsights.v1.Insight" json:"insights,omitempty"`
	// Required. Insight filter.
	Filter *Filter `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ComputeInsightsRequest) Reset() {
	*x = ComputeInsightsRequest{}
	mi := &file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ComputeInsightsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeInsightsRequest) ProtoMessage() {}

func (x *ComputeInsightsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeInsightsRequest.ProtoReflect.Descriptor instead.
func (*ComputeInsightsRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_areainsights_v1_area_insights_service_proto_rawDescGZIP(), []int{0}
}

func (x *ComputeInsightsRequest) GetInsights() []Insight {
	if x != nil {
		return x.Insights
	}
	return nil
}

func (x *ComputeInsightsRequest) GetFilter() *Filter {
	if x != nil {
		return x.Filter
	}
	return nil
}

// Response for the ComputeInsights RPC.
type ComputeInsightsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Result for Insights.INSIGHT_COUNT.
	Count *int64 `protobuf:"varint,1,opt,name=count,proto3,oneof" json:"count,omitempty"`
	// Result for Insights.INSIGHT_PLACES.
	PlaceInsights []*PlaceInsight `protobuf:"bytes,5,rep,name=place_insights,json=placeInsights,proto3" json:"place_insights,omitempty"`
}

func (x *ComputeInsightsResponse) Reset() {
	*x = ComputeInsightsResponse{}
	mi := &file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ComputeInsightsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeInsightsResponse) ProtoMessage() {}

func (x *ComputeInsightsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeInsightsResponse.ProtoReflect.Descriptor instead.
func (*ComputeInsightsResponse) Descriptor() ([]byte, []int) {
	return file_google_maps_areainsights_v1_area_insights_service_proto_rawDescGZIP(), []int{1}
}

func (x *ComputeInsightsResponse) GetCount() int64 {
	if x != nil && x.Count != nil {
		return *x.Count
	}
	return 0
}

func (x *ComputeInsightsResponse) GetPlaceInsights() []*PlaceInsight {
	if x != nil {
		return x.PlaceInsights
	}
	return nil
}

// Holds information about a place
type PlaceInsight struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the place. This resource name can be used to
	// retrieve details about the place using the [Places
	// API](https://developers.google.com/maps/documentation/places/web-service/reference/rest/v1/places/get).
	Place string `protobuf:"bytes,1,opt,name=place,proto3" json:"place,omitempty"`
}

func (x *PlaceInsight) Reset() {
	*x = PlaceInsight{}
	mi := &file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlaceInsight) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlaceInsight) ProtoMessage() {}

func (x *PlaceInsight) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlaceInsight.ProtoReflect.Descriptor instead.
func (*PlaceInsight) Descriptor() ([]byte, []int) {
	return file_google_maps_areainsights_v1_area_insights_service_proto_rawDescGZIP(), []int{2}
}

func (x *PlaceInsight) GetPlace() string {
	if x != nil {
		return x.Place
	}
	return ""
}

// Filters for the ComputeInsights RPC.
type Filter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Restricts results to places which are located in the area
	// specified by location filters.
	LocationFilter *LocationFilter `protobuf:"bytes,1,opt,name=location_filter,json=locationFilter,proto3" json:"location_filter,omitempty"`
	// Required. Place type filters.
	TypeFilter *TypeFilter `protobuf:"bytes,2,opt,name=type_filter,json=typeFilter,proto3" json:"type_filter,omitempty"`
	// Optional. Restricts results to places whose operating status is included on
	// this list. If operating_status is not set, OPERATING_STATUS_OPERATIONAL is
	// used as default.
	OperatingStatus []OperatingStatus `protobuf:"varint,3,rep,packed,name=operating_status,json=operatingStatus,proto3,enum=google.maps.areainsights.v1.OperatingStatus" json:"operating_status,omitempty"`
	// Optional. Restricts results to places whose price level is included on this
	// list. If `price_levels` is not set, all price levels are included in the
	// results.
	PriceLevels []PriceLevel `protobuf:"varint,4,rep,packed,name=price_levels,json=priceLevels,proto3,enum=google.maps.areainsights.v1.PriceLevel" json:"price_levels,omitempty"`
	// Optional. Restricts results to places whose average user ratings are in the
	// range specified by rating_filter. If rating_filter is not set, all ratings
	// are included in the result.
	RatingFilter *RatingFilter `protobuf:"bytes,5,opt,name=rating_filter,json=ratingFilter,proto3" json:"rating_filter,omitempty"`
}

func (x *Filter) Reset() {
	*x = Filter{}
	mi := &file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Filter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Filter) ProtoMessage() {}

func (x *Filter) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Filter.ProtoReflect.Descriptor instead.
func (*Filter) Descriptor() ([]byte, []int) {
	return file_google_maps_areainsights_v1_area_insights_service_proto_rawDescGZIP(), []int{3}
}

func (x *Filter) GetLocationFilter() *LocationFilter {
	if x != nil {
		return x.LocationFilter
	}
	return nil
}

func (x *Filter) GetTypeFilter() *TypeFilter {
	if x != nil {
		return x.TypeFilter
	}
	return nil
}

func (x *Filter) GetOperatingStatus() []OperatingStatus {
	if x != nil {
		return x.OperatingStatus
	}
	return nil
}

func (x *Filter) GetPriceLevels() []PriceLevel {
	if x != nil {
		return x.PriceLevels
	}
	return nil
}

func (x *Filter) GetRatingFilter() *RatingFilter {
	if x != nil {
		return x.RatingFilter
	}
	return nil
}

// Location filters.
//
// Specifies the area of interest for the insight.
type LocationFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// One of the following must be specified.
	//
	// Types that are assignable to Area:
	//
	//	*LocationFilter_Circle_
	//	*LocationFilter_Region_
	//	*LocationFilter_CustomArea_
	Area isLocationFilter_Area `protobuf_oneof:"area"`
}

func (x *LocationFilter) Reset() {
	*x = LocationFilter{}
	mi := &file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LocationFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocationFilter) ProtoMessage() {}

func (x *LocationFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocationFilter.ProtoReflect.Descriptor instead.
func (*LocationFilter) Descriptor() ([]byte, []int) {
	return file_google_maps_areainsights_v1_area_insights_service_proto_rawDescGZIP(), []int{4}
}

func (m *LocationFilter) GetArea() isLocationFilter_Area {
	if m != nil {
		return m.Area
	}
	return nil
}

func (x *LocationFilter) GetCircle() *LocationFilter_Circle {
	if x, ok := x.GetArea().(*LocationFilter_Circle_); ok {
		return x.Circle
	}
	return nil
}

func (x *LocationFilter) GetRegion() *LocationFilter_Region {
	if x, ok := x.GetArea().(*LocationFilter_Region_); ok {
		return x.Region
	}
	return nil
}

func (x *LocationFilter) GetCustomArea() *LocationFilter_CustomArea {
	if x, ok := x.GetArea().(*LocationFilter_CustomArea_); ok {
		return x.CustomArea
	}
	return nil
}

type isLocationFilter_Area interface {
	isLocationFilter_Area()
}

type LocationFilter_Circle_ struct {
	// Area as a circle.
	Circle *LocationFilter_Circle `protobuf:"bytes,1,opt,name=circle,proto3,oneof"`
}

type LocationFilter_Region_ struct {
	// Area as region.
	Region *LocationFilter_Region `protobuf:"bytes,2,opt,name=region,proto3,oneof"`
}

type LocationFilter_CustomArea_ struct {
	// Custom area specified by a polygon.
	CustomArea *LocationFilter_CustomArea `protobuf:"bytes,3,opt,name=custom_area,json=customArea,proto3,oneof"`
}

func (*LocationFilter_Circle_) isLocationFilter_Area() {}

func (*LocationFilter_Region_) isLocationFilter_Area() {}

func (*LocationFilter_CustomArea_) isLocationFilter_Area() {}

// Place type filters.
//
// Only Place types from
// [Table
// a](https://developers.google.com/maps/documentation/places/web-service/place-types#table-a)
// are supported.
//
// A place can only have a single primary type associated with it. For example,
// the primary type might be "mexican_restaurant" or "steak_house". Use
// included_primary_types and excluded_primary_types to filter the results on a
// place's primary type.
//
// A place can also have multiple type values associated with it. For example a
// restaurant might have the following types: "seafood_restaurant",
// "restaurant", "food", "point_of_interest", "establishment". Use
// included_types and excluded_types to filter the results on the list of types
// associated with a place.
//
// If a search is specified with multiple type restrictions, only places that
// satisfy all of the restrictions are returned. For example, if you specify
// {"included_types": ["restaurant"], "excluded_primary_types":
// ["steak_house"]}, the returned places provide "restaurant" related services
// but do not operate primarily as a "steak_house".
//
// If there are any conflicting types, i.e. a type appears in both
// included_types and excluded_types types or included_primary_types and
// excluded_primary_types, an INVALID_ARGUMENT error is returned.
//
// One of included_types or included_primary_types must be set.
type TypeFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Included Place types.
	IncludedTypes []string `protobuf:"bytes,1,rep,name=included_types,json=includedTypes,proto3" json:"included_types,omitempty"`
	// Optional. Excluded Place types.
	ExcludedTypes []string `protobuf:"bytes,2,rep,name=excluded_types,json=excludedTypes,proto3" json:"excluded_types,omitempty"`
	// Optional. Included primary Place types.
	IncludedPrimaryTypes []string `protobuf:"bytes,3,rep,name=included_primary_types,json=includedPrimaryTypes,proto3" json:"included_primary_types,omitempty"`
	// Optional. Excluded primary Place types.
	ExcludedPrimaryTypes []string `protobuf:"bytes,4,rep,name=excluded_primary_types,json=excludedPrimaryTypes,proto3" json:"excluded_primary_types,omitempty"`
}

func (x *TypeFilter) Reset() {
	*x = TypeFilter{}
	mi := &file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TypeFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TypeFilter) ProtoMessage() {}

func (x *TypeFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TypeFilter.ProtoReflect.Descriptor instead.
func (*TypeFilter) Descriptor() ([]byte, []int) {
	return file_google_maps_areainsights_v1_area_insights_service_proto_rawDescGZIP(), []int{5}
}

func (x *TypeFilter) GetIncludedTypes() []string {
	if x != nil {
		return x.IncludedTypes
	}
	return nil
}

func (x *TypeFilter) GetExcludedTypes() []string {
	if x != nil {
		return x.ExcludedTypes
	}
	return nil
}

func (x *TypeFilter) GetIncludedPrimaryTypes() []string {
	if x != nil {
		return x.IncludedPrimaryTypes
	}
	return nil
}

func (x *TypeFilter) GetExcludedPrimaryTypes() []string {
	if x != nil {
		return x.ExcludedPrimaryTypes
	}
	return nil
}

// Average user rating filters.
type RatingFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Restricts results to places whose average user rating is greater
	// than or equal to min_rating. Values must be between 1.0 and 5.0.
	MinRating *float32 `protobuf:"fixed32,5,opt,name=min_rating,json=minRating,proto3,oneof" json:"min_rating,omitempty"`
	// Optional. Restricts results to places whose average user rating is strictly
	// less than or equal to max_rating. Values must be between 1.0 and 5.0.
	MaxRating *float32 `protobuf:"fixed32,6,opt,name=max_rating,json=maxRating,proto3,oneof" json:"max_rating,omitempty"`
}

func (x *RatingFilter) Reset() {
	*x = RatingFilter{}
	mi := &file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RatingFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RatingFilter) ProtoMessage() {}

func (x *RatingFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RatingFilter.ProtoReflect.Descriptor instead.
func (*RatingFilter) Descriptor() ([]byte, []int) {
	return file_google_maps_areainsights_v1_area_insights_service_proto_rawDescGZIP(), []int{6}
}

func (x *RatingFilter) GetMinRating() float32 {
	if x != nil && x.MinRating != nil {
		return *x.MinRating
	}
	return 0
}

func (x *RatingFilter) GetMaxRating() float32 {
	if x != nil && x.MaxRating != nil {
		return *x.MaxRating
	}
	return 0
}

// A circle is defined by a center point and radius in meters.
type LocationFilter_Circle struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The center of the circle.
	//
	// Types that are assignable to Center:
	//
	//	*LocationFilter_Circle_LatLng
	//	*LocationFilter_Circle_Place
	Center isLocationFilter_Circle_Center `protobuf_oneof:"center"`
	// Optional. The radius of the circle in meters
	Radius int32 `protobuf:"varint,3,opt,name=radius,proto3" json:"radius,omitempty"`
}

func (x *LocationFilter_Circle) Reset() {
	*x = LocationFilter_Circle{}
	mi := &file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LocationFilter_Circle) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocationFilter_Circle) ProtoMessage() {}

func (x *LocationFilter_Circle) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocationFilter_Circle.ProtoReflect.Descriptor instead.
func (*LocationFilter_Circle) Descriptor() ([]byte, []int) {
	return file_google_maps_areainsights_v1_area_insights_service_proto_rawDescGZIP(), []int{4, 0}
}

func (m *LocationFilter_Circle) GetCenter() isLocationFilter_Circle_Center {
	if m != nil {
		return m.Center
	}
	return nil
}

func (x *LocationFilter_Circle) GetLatLng() *latlng.LatLng {
	if x, ok := x.GetCenter().(*LocationFilter_Circle_LatLng); ok {
		return x.LatLng
	}
	return nil
}

func (x *LocationFilter_Circle) GetPlace() string {
	if x, ok := x.GetCenter().(*LocationFilter_Circle_Place); ok {
		return x.Place
	}
	return ""
}

func (x *LocationFilter_Circle) GetRadius() int32 {
	if x != nil {
		return x.Radius
	}
	return 0
}

type isLocationFilter_Circle_Center interface {
	isLocationFilter_Circle_Center()
}

type LocationFilter_Circle_LatLng struct {
	// The latitude and longitude of the center of the circle.
	LatLng *latlng.LatLng `protobuf:"bytes,1,opt,name=lat_lng,json=latLng,proto3,oneof"`
}

type LocationFilter_Circle_Place struct {
	// **Format:**  Must be in the format `places/PLACE_ID`, where `PLACE_ID`
	// is the unique identifier of a place. For example:
	// `places/ChIJgUbEo8cfqokR5lP9_Wh_DaM`.
	Place string `protobuf:"bytes,2,opt,name=place,proto3,oneof"`
}

func (*LocationFilter_Circle_LatLng) isLocationFilter_Circle_Center() {}

func (*LocationFilter_Circle_Place) isLocationFilter_Circle_Center() {}

// A region is a geographic boundary such as: cities, postal codes, counties,
// states, etc.
type LocationFilter_Region struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines a geographic region. Only one type of region (e.g. place) can
	// specified at a time.
	//
	// Types that are assignable to Region:
	//
	//	*LocationFilter_Region_Place
	Region isLocationFilter_Region_Region `protobuf_oneof:"region"`
}

func (x *LocationFilter_Region) Reset() {
	*x = LocationFilter_Region{}
	mi := &file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LocationFilter_Region) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocationFilter_Region) ProtoMessage() {}

func (x *LocationFilter_Region) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocationFilter_Region.ProtoReflect.Descriptor instead.
func (*LocationFilter_Region) Descriptor() ([]byte, []int) {
	return file_google_maps_areainsights_v1_area_insights_service_proto_rawDescGZIP(), []int{4, 1}
}

func (m *LocationFilter_Region) GetRegion() isLocationFilter_Region_Region {
	if m != nil {
		return m.Region
	}
	return nil
}

func (x *LocationFilter_Region) GetPlace() string {
	if x, ok := x.GetRegion().(*LocationFilter_Region_Place); ok {
		return x.Place
	}
	return ""
}

type isLocationFilter_Region_Region interface {
	isLocationFilter_Region_Region()
}

type LocationFilter_Region_Place struct {
	// The unique identifier of a specific geographic region.
	Place string `protobuf:"bytes,1,opt,name=place,proto3,oneof"`
}

func (*LocationFilter_Region_Place) isLocationFilter_Region_Region() {}

// Custom Area.
type LocationFilter_CustomArea struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The custom area represented as a polygon
	Polygon *LocationFilter_CustomArea_Polygon `protobuf:"bytes,1,opt,name=polygon,proto3" json:"polygon,omitempty"`
}

func (x *LocationFilter_CustomArea) Reset() {
	*x = LocationFilter_CustomArea{}
	mi := &file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LocationFilter_CustomArea) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocationFilter_CustomArea) ProtoMessage() {}

func (x *LocationFilter_CustomArea) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocationFilter_CustomArea.ProtoReflect.Descriptor instead.
func (*LocationFilter_CustomArea) Descriptor() ([]byte, []int) {
	return file_google_maps_areainsights_v1_area_insights_service_proto_rawDescGZIP(), []int{4, 2}
}

func (x *LocationFilter_CustomArea) GetPolygon() *LocationFilter_CustomArea_Polygon {
	if x != nil {
		return x.Polygon
	}
	return nil
}

// A polygon is represented by a series of connected coordinates in an
// counterclockwise ordered sequence. The coordinates form a closed loop and
// define a filled region. The first and last coordinates are equivalent,
// and they must contain identical values. The format is a simplified
// version of GeoJSON polygons (we only support one counterclockwise
// exterior ring).
type LocationFilter_CustomArea_Polygon struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The coordinates that define the polygon.
	Coordinates []*latlng.LatLng `protobuf:"bytes,1,rep,name=coordinates,proto3" json:"coordinates,omitempty"`
}

func (x *LocationFilter_CustomArea_Polygon) Reset() {
	*x = LocationFilter_CustomArea_Polygon{}
	mi := &file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LocationFilter_CustomArea_Polygon) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocationFilter_CustomArea_Polygon) ProtoMessage() {}

func (x *LocationFilter_CustomArea_Polygon) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocationFilter_CustomArea_Polygon.ProtoReflect.Descriptor instead.
func (*LocationFilter_CustomArea_Polygon) Descriptor() ([]byte, []int) {
	return file_google_maps_areainsights_v1_area_insights_service_proto_rawDescGZIP(), []int{4, 2, 0}
}

func (x *LocationFilter_CustomArea_Polygon) GetCoordinates() []*latlng.LatLng {
	if x != nil {
		return x.Coordinates
	}
	return nil
}

var File_google_maps_areainsights_v1_area_insights_service_proto protoreflect.FileDescriptor

var file_google_maps_areainsights_v1_area_insights_service_proto_rawDesc = []byte{
	0x0a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x61, 0x72,
	0x65, 0x61, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x72,
	0x65, 0x61, 0x5f, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x5f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61, 0x72, 0x65, 0x61, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6c, 0x61, 0x74, 0x6c, 0x6e, 0x67, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xa1, 0x01, 0x0a, 0x16, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x49,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45,
	0x0a, 0x08, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61,
	0x72, 0x65, 0x61, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x12, 0x40, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d,
	0x61, 0x70, 0x73, 0x2e, 0x61, 0x72, 0x65, 0x61, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x90, 0x01, 0x0a, 0x17, 0x43, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x48, 0x00, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x50,
	0x0a, 0x0e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61, 0x72, 0x65, 0x61, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x52, 0x0d, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x42, 0x08, 0x0a, 0x06, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x46, 0x0a, 0x0c, 0x50, 0x6c,
	0x61, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x12, 0x36, 0x0a, 0x05, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x20, 0xfa, 0x41, 0x1d, 0x0a, 0x1b,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x52, 0x05, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x22, 0xb6, 0x03, 0x0a, 0x06, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x59, 0x0a,
	0x0f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61, 0x72, 0x65, 0x61, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x4d, 0x0a, 0x0b, 0x74, 0x79, 0x70, 0x65,
	0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61, 0x72, 0x65, 0x61,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x79, 0x70, 0x65,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x74, 0x79, 0x70,
	0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x5c, 0x0a, 0x10, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e,
	0x61, 0x72, 0x65, 0x61, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x4f, 0x0a, 0x0c, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x6c,
	0x65, 0x76, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61, 0x72, 0x65, 0x61, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x4c,
	0x65, 0x76, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x70, 0x72, 0x69, 0x63, 0x65,
	0x4c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x12, 0x53, 0x0a, 0x0d, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61, 0x72, 0x65, 0x61,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x61, 0x74, 0x69,
	0x6e, 0x67, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x72,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xae, 0x05, 0x0a, 0x0e,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x4c,
	0x0a, 0x06, 0x63, 0x69, 0x72, 0x63, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61, 0x72, 0x65,
	0x61, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x43, 0x69, 0x72, 0x63,
	0x6c, 0x65, 0x48, 0x00, 0x52, 0x06, 0x63, 0x69, 0x72, 0x63, 0x6c, 0x65, 0x12, 0x4c, 0x0a, 0x06,
	0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61, 0x72, 0x65, 0x61, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x48, 0x00, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x59, 0x0a, 0x0b, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x61, 0x72, 0x65, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61, 0x72,
	0x65, 0x61, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x41, 0x72, 0x65, 0x61, 0x48, 0x00, 0x52, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x41, 0x72, 0x65, 0x61, 0x1a, 0x99, 0x01, 0x0a, 0x06, 0x43, 0x69, 0x72, 0x63, 0x6c, 0x65,
	0x12, 0x2e, 0x0a, 0x07, 0x6c, 0x61, 0x74, 0x5f, 0x6c, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x48, 0x00, 0x52, 0x06, 0x6c, 0x61, 0x74, 0x4c, 0x6e, 0x67,
	0x12, 0x38, 0x0a, 0x05, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x20, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x63,
	0x65, 0x48, 0x00, 0x52, 0x05, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x72, 0x61,
	0x64, 0x69, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x72, 0x61, 0x64, 0x69, 0x75, 0x73, 0x42, 0x08, 0x0a, 0x06, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x1a, 0x4c, 0x0a, 0x06, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x38, 0x0a, 0x05, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x20, 0xfa, 0x41, 0x1d, 0x0a,
	0x1b, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x48, 0x00, 0x52, 0x05,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x1a,
	0xb2, 0x01, 0x0a, 0x0a, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41, 0x72, 0x65, 0x61, 0x12, 0x5d,
	0x0a, 0x07, 0x70, 0x6f, 0x6c, 0x79, 0x67, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61, 0x72,
	0x65, 0x61, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x41, 0x72, 0x65, 0x61, 0x2e, 0x50, 0x6f, 0x6c, 0x79, 0x67, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x70, 0x6f, 0x6c, 0x79, 0x67, 0x6f, 0x6e, 0x1a, 0x45, 0x0a,
	0x07, 0x50, 0x6f, 0x6c, 0x79, 0x67, 0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x0b, 0x63, 0x6f, 0x6f, 0x72,
	0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74, 0x4c,
	0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x63, 0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e,
	0x61, 0x74, 0x65, 0x73, 0x42, 0x06, 0x0a, 0x04, 0x61, 0x72, 0x65, 0x61, 0x22, 0xda, 0x01, 0x0a,
	0x0a, 0x54, 0x79, 0x70, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x2a, 0x0a, 0x0e, 0x69,
	0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64,
	0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x2a, 0x0a, 0x0e, 0x65, 0x78, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x12, 0x39, 0x0a, 0x16, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f,
	0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64,
	0x65, 0x64, 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x39,
	0x0a, 0x16, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x69, 0x6d, 0x61,
	0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x14, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x50, 0x72, 0x69,
	0x6d, 0x61, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x22, 0x7e, 0x0a, 0x0c, 0x52, 0x61, 0x74,
	0x69, 0x6e, 0x67, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x27, 0x0a, 0x0a, 0x6d, 0x69, 0x6e,
	0x5f, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x00, 0x52, 0x09, 0x6d, 0x69, 0x6e, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x88,
	0x01, 0x01, 0x12, 0x27, 0x0a, 0x0a, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x09, 0x6d,
	0x61, 0x78, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f,
	0x6d, 0x69, 0x6e, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x6d,
	0x61, 0x78, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x2a, 0x49, 0x0a, 0x07, 0x49, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x12, 0x17, 0x0a, 0x13, 0x49, 0x4e, 0x53, 0x49, 0x47, 0x48, 0x54, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a,
	0x0d, 0x49, 0x4e, 0x53, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x10, 0x01,
	0x12, 0x12, 0x0a, 0x0e, 0x49, 0x4e, 0x53, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x50, 0x4c, 0x41, 0x43,
	0x45, 0x53, 0x10, 0x02, 0x2a, 0xa7, 0x01, 0x0a, 0x0f, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x20, 0x0a, 0x1c, 0x4f, 0x50, 0x45, 0x52,
	0x41, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x20, 0x0a, 0x1c, 0x4f, 0x50,
	0x45, 0x52, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x4f,
	0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x27, 0x0a, 0x23,
	0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53,
	0x5f, 0x50, 0x45, 0x52, 0x4d, 0x41, 0x4e, 0x45, 0x4e, 0x54, 0x4c, 0x59, 0x5f, 0x43, 0x4c, 0x4f,
	0x53, 0x45, 0x44, 0x10, 0x03, 0x12, 0x27, 0x0a, 0x23, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49,
	0x4e, 0x47, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x54, 0x45, 0x4d, 0x50, 0x4f, 0x52,
	0x41, 0x52, 0x49, 0x4c, 0x59, 0x5f, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x44, 0x10, 0x04, 0x2a, 0xb1,
	0x01, 0x0a, 0x0a, 0x50, 0x72, 0x69, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x1b, 0x0a,
	0x17, 0x50, 0x52, 0x49, 0x43, 0x45, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x50, 0x52,
	0x49, 0x43, 0x45, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x46, 0x52, 0x45, 0x45, 0x10, 0x01,
	0x12, 0x1b, 0x0a, 0x17, 0x50, 0x52, 0x49, 0x43, 0x45, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f,
	0x49, 0x4e, 0x45, 0x58, 0x50, 0x45, 0x4e, 0x53, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x18, 0x0a,
	0x14, 0x50, 0x52, 0x49, 0x43, 0x45, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x4d, 0x4f, 0x44,
	0x45, 0x52, 0x41, 0x54, 0x45, 0x10, 0x03, 0x12, 0x19, 0x0a, 0x15, 0x50, 0x52, 0x49, 0x43, 0x45,
	0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x45, 0x58, 0x50, 0x45, 0x4e, 0x53, 0x49, 0x56, 0x45,
	0x10, 0x04, 0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x52, 0x49, 0x43, 0x45, 0x5f, 0x4c, 0x45, 0x56, 0x45,
	0x4c, 0x5f, 0x56, 0x45, 0x52, 0x59, 0x5f, 0x45, 0x58, 0x50, 0x45, 0x4e, 0x53, 0x49, 0x56, 0x45,
	0x10, 0x05, 0x32, 0xfe, 0x01, 0x0a, 0x0c, 0x41, 0x72, 0x65, 0x61, 0x49, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x12, 0x9c, 0x01, 0x0a, 0x0f, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x49,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61, 0x72, 0x65, 0x61, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61, 0x72, 0x65, 0x61, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x65, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x1e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x18, 0x3a, 0x01, 0x2a, 0x22, 0x13, 0x2f,
	0x76, 0x31, 0x3a, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x1a, 0x4f, 0xca, 0x41, 0x1b, 0x61, 0x72, 0x65, 0x61, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x42, 0xfd, 0x01, 0xea, 0x41, 0x30, 0x0a, 0x1b, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x12, 0x11, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x7b,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61, 0x72, 0x65, 0x61, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x18, 0x41, 0x72, 0x65, 0x61,
	0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x49, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6d, 0x61, 0x70, 0x73,
	0x2f, 0x61, 0x72, 0x65, 0x61, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x2f, 0x61, 0x72, 0x65, 0x61, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x70, 0x62, 0x3b, 0x61, 0x72, 0x65, 0x61, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x70,
	0x62, 0xa2, 0x02, 0x03, 0x4d, 0x41, 0x49, 0xaa, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x4d, 0x61, 0x70, 0x73, 0x2e, 0x41, 0x72, 0x65, 0x61, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x4d,
	0x61, 0x70, 0x73, 0x5c, 0x41, 0x72, 0x65, 0x61, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x5c, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_maps_areainsights_v1_area_insights_service_proto_rawDescOnce sync.Once
	file_google_maps_areainsights_v1_area_insights_service_proto_rawDescData = file_google_maps_areainsights_v1_area_insights_service_proto_rawDesc
)

func file_google_maps_areainsights_v1_area_insights_service_proto_rawDescGZIP() []byte {
	file_google_maps_areainsights_v1_area_insights_service_proto_rawDescOnce.Do(func() {
		file_google_maps_areainsights_v1_area_insights_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_maps_areainsights_v1_area_insights_service_proto_rawDescData)
	})
	return file_google_maps_areainsights_v1_area_insights_service_proto_rawDescData
}

var file_google_maps_areainsights_v1_area_insights_service_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_maps_areainsights_v1_area_insights_service_proto_goTypes = []any{
	(Insight)(0),                              // 0: google.maps.areainsights.v1.Insight
	(OperatingStatus)(0),                      // 1: google.maps.areainsights.v1.OperatingStatus
	(PriceLevel)(0),                           // 2: google.maps.areainsights.v1.PriceLevel
	(*ComputeInsightsRequest)(nil),            // 3: google.maps.areainsights.v1.ComputeInsightsRequest
	(*ComputeInsightsResponse)(nil),           // 4: google.maps.areainsights.v1.ComputeInsightsResponse
	(*PlaceInsight)(nil),                      // 5: google.maps.areainsights.v1.PlaceInsight
	(*Filter)(nil),                            // 6: google.maps.areainsights.v1.Filter
	(*LocationFilter)(nil),                    // 7: google.maps.areainsights.v1.LocationFilter
	(*TypeFilter)(nil),                        // 8: google.maps.areainsights.v1.TypeFilter
	(*RatingFilter)(nil),                      // 9: google.maps.areainsights.v1.RatingFilter
	(*LocationFilter_Circle)(nil),             // 10: google.maps.areainsights.v1.LocationFilter.Circle
	(*LocationFilter_Region)(nil),             // 11: google.maps.areainsights.v1.LocationFilter.Region
	(*LocationFilter_CustomArea)(nil),         // 12: google.maps.areainsights.v1.LocationFilter.CustomArea
	(*LocationFilter_CustomArea_Polygon)(nil), // 13: google.maps.areainsights.v1.LocationFilter.CustomArea.Polygon
	(*latlng.LatLng)(nil),                     // 14: google.type.LatLng
}
var file_google_maps_areainsights_v1_area_insights_service_proto_depIdxs = []int32{
	0,  // 0: google.maps.areainsights.v1.ComputeInsightsRequest.insights:type_name -> google.maps.areainsights.v1.Insight
	6,  // 1: google.maps.areainsights.v1.ComputeInsightsRequest.filter:type_name -> google.maps.areainsights.v1.Filter
	5,  // 2: google.maps.areainsights.v1.ComputeInsightsResponse.place_insights:type_name -> google.maps.areainsights.v1.PlaceInsight
	7,  // 3: google.maps.areainsights.v1.Filter.location_filter:type_name -> google.maps.areainsights.v1.LocationFilter
	8,  // 4: google.maps.areainsights.v1.Filter.type_filter:type_name -> google.maps.areainsights.v1.TypeFilter
	1,  // 5: google.maps.areainsights.v1.Filter.operating_status:type_name -> google.maps.areainsights.v1.OperatingStatus
	2,  // 6: google.maps.areainsights.v1.Filter.price_levels:type_name -> google.maps.areainsights.v1.PriceLevel
	9,  // 7: google.maps.areainsights.v1.Filter.rating_filter:type_name -> google.maps.areainsights.v1.RatingFilter
	10, // 8: google.maps.areainsights.v1.LocationFilter.circle:type_name -> google.maps.areainsights.v1.LocationFilter.Circle
	11, // 9: google.maps.areainsights.v1.LocationFilter.region:type_name -> google.maps.areainsights.v1.LocationFilter.Region
	12, // 10: google.maps.areainsights.v1.LocationFilter.custom_area:type_name -> google.maps.areainsights.v1.LocationFilter.CustomArea
	14, // 11: google.maps.areainsights.v1.LocationFilter.Circle.lat_lng:type_name -> google.type.LatLng
	13, // 12: google.maps.areainsights.v1.LocationFilter.CustomArea.polygon:type_name -> google.maps.areainsights.v1.LocationFilter.CustomArea.Polygon
	14, // 13: google.maps.areainsights.v1.LocationFilter.CustomArea.Polygon.coordinates:type_name -> google.type.LatLng
	3,  // 14: google.maps.areainsights.v1.AreaInsights.ComputeInsights:input_type -> google.maps.areainsights.v1.ComputeInsightsRequest
	4,  // 15: google.maps.areainsights.v1.AreaInsights.ComputeInsights:output_type -> google.maps.areainsights.v1.ComputeInsightsResponse
	15, // [15:16] is the sub-list for method output_type
	14, // [14:15] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_google_maps_areainsights_v1_area_insights_service_proto_init() }
func file_google_maps_areainsights_v1_area_insights_service_proto_init() {
	if File_google_maps_areainsights_v1_area_insights_service_proto != nil {
		return
	}
	file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes[1].OneofWrappers = []any{}
	file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes[4].OneofWrappers = []any{
		(*LocationFilter_Circle_)(nil),
		(*LocationFilter_Region_)(nil),
		(*LocationFilter_CustomArea_)(nil),
	}
	file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes[6].OneofWrappers = []any{}
	file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes[7].OneofWrappers = []any{
		(*LocationFilter_Circle_LatLng)(nil),
		(*LocationFilter_Circle_Place)(nil),
	}
	file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes[8].OneofWrappers = []any{
		(*LocationFilter_Region_Place)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_maps_areainsights_v1_area_insights_service_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_maps_areainsights_v1_area_insights_service_proto_goTypes,
		DependencyIndexes: file_google_maps_areainsights_v1_area_insights_service_proto_depIdxs,
		EnumInfos:         file_google_maps_areainsights_v1_area_insights_service_proto_enumTypes,
		MessageInfos:      file_google_maps_areainsights_v1_area_insights_service_proto_msgTypes,
	}.Build()
	File_google_maps_areainsights_v1_area_insights_service_proto = out.File
	file_google_maps_areainsights_v1_area_insights_service_proto_rawDesc = nil
	file_google_maps_areainsights_v1_area_insights_service_proto_goTypes = nil
	file_google_maps_areainsights_v1_area_insights_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AreaInsightsClient is the client API for AreaInsights service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AreaInsightsClient interface {
	// This method lets you retrieve insights about areas using a variety of
	// filter such as: area, place type, operating status, price level
	// and ratings. Currently "count" and "places" insights are supported. With
	// "count" insights you can answer questions such as "How many restaurant are
	// located in California that are operational, are inexpensive and have an
	// average rating of at least 4 stars" (see `insight` enum for more details).
	// With "places" insights, you can determine which places match the
	// requested filter. Clients can then use those place resource names to fetch
	// more details about each individual place using the Places API.
	ComputeInsights(ctx context.Context, in *ComputeInsightsRequest, opts ...grpc.CallOption) (*ComputeInsightsResponse, error)
}

type areaInsightsClient struct {
	cc grpc.ClientConnInterface
}

func NewAreaInsightsClient(cc grpc.ClientConnInterface) AreaInsightsClient {
	return &areaInsightsClient{cc}
}

func (c *areaInsightsClient) ComputeInsights(ctx context.Context, in *ComputeInsightsRequest, opts ...grpc.CallOption) (*ComputeInsightsResponse, error) {
	out := new(ComputeInsightsResponse)
	err := c.cc.Invoke(ctx, "/google.maps.areainsights.v1.AreaInsights/ComputeInsights", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AreaInsightsServer is the server API for AreaInsights service.
type AreaInsightsServer interface {
	// This method lets you retrieve insights about areas using a variety of
	// filter such as: area, place type, operating status, price level
	// and ratings. Currently "count" and "places" insights are supported. With
	// "count" insights you can answer questions such as "How many restaurant are
	// located in California that are operational, are inexpensive and have an
	// average rating of at least 4 stars" (see `insight` enum for more details).
	// With "places" insights, you can determine which places match the
	// requested filter. Clients can then use those place resource names to fetch
	// more details about each individual place using the Places API.
	ComputeInsights(context.Context, *ComputeInsightsRequest) (*ComputeInsightsResponse, error)
}

// UnimplementedAreaInsightsServer can be embedded to have forward compatible implementations.
type UnimplementedAreaInsightsServer struct {
}

func (*UnimplementedAreaInsightsServer) ComputeInsights(context.Context, *ComputeInsightsRequest) (*ComputeInsightsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ComputeInsights not implemented")
}

func RegisterAreaInsightsServer(s *grpc.Server, srv AreaInsightsServer) {
	s.RegisterService(&_AreaInsights_serviceDesc, srv)
}

func _AreaInsights_ComputeInsights_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ComputeInsightsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AreaInsightsServer).ComputeInsights(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.maps.areainsights.v1.AreaInsights/ComputeInsights",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AreaInsightsServer).ComputeInsights(ctx, req.(*ComputeInsightsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AreaInsights_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.maps.areainsights.v1.AreaInsights",
	HandlerType: (*AreaInsightsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ComputeInsights",
			Handler:    _AreaInsights_ComputeInsights_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/maps/areainsights/v1/area_insights_service.proto",
}
