// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.23.2
// source: google/cloud/lifesciences/v2beta/workflows.proto

package lifesciencespb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	code "google.golang.org/genproto/googleapis/rpc/code"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The arguments to the `RunPipeline` method. The requesting user must have
// the `iam.serviceAccounts.actAs` permission for the Cloud Life Sciences
// service account or the request will fail.
type RunPipelineRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The project and location that this request should be executed against.
	Parent string `protobuf:"bytes,4,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The description of the pipeline to run.
	Pipeline *Pipeline `protobuf:"bytes,1,opt,name=pipeline,proto3" json:"pipeline,omitempty"`
	// User-defined labels to associate with the returned operation. These
	// labels are not propagated to any Google Cloud Platform resources used by
	// the operation, and can be modified at any time.
	//
	// To associate labels with resources created while executing the operation,
	// see the appropriate resource message (for example, `VirtualMachine`).
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The name of an existing Pub/Sub topic.  The server will publish
	// messages to this topic whenever the status of the operation changes.
	// The Life Sciences Service Agent account must have publisher permissions to
	// the specified topic or notifications will not be sent.
	PubSubTopic string `protobuf:"bytes,3,opt,name=pub_sub_topic,json=pubSubTopic,proto3" json:"pub_sub_topic,omitempty"`
}

func (x *RunPipelineRequest) Reset() {
	*x = RunPipelineRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunPipelineRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunPipelineRequest) ProtoMessage() {}

func (x *RunPipelineRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunPipelineRequest.ProtoReflect.Descriptor instead.
func (*RunPipelineRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{0}
}

func (x *RunPipelineRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *RunPipelineRequest) GetPipeline() *Pipeline {
	if x != nil {
		return x.Pipeline
	}
	return nil
}

func (x *RunPipelineRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *RunPipelineRequest) GetPubSubTopic() string {
	if x != nil {
		return x.PubSubTopic
	}
	return ""
}

// The response to the RunPipeline method, returned in the operation's result
// field on success.
type RunPipelineResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RunPipelineResponse) Reset() {
	*x = RunPipelineResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunPipelineResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunPipelineResponse) ProtoMessage() {}

func (x *RunPipelineResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunPipelineResponse.ProtoReflect.Descriptor instead.
func (*RunPipelineResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{1}
}

// Specifies a series of actions to execute, expressed as Docker containers.
type Pipeline struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of actions to execute, in the order they are specified.
	Actions []*Action `protobuf:"bytes,1,rep,name=actions,proto3" json:"actions,omitempty"`
	// The resources required for execution.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// The environment to pass into every action. Each action can also specify
	// additional environment variables but cannot delete an entry from this map
	// (though they can overwrite it with a different value).
	Environment map[string]string `protobuf:"bytes,3,rep,name=environment,proto3" json:"environment,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The encrypted environment to pass into every action. Each action can also
	// specify its own encrypted environment.
	//
	// The secret must decrypt to a JSON-encoded dictionary where key-value pairs
	// serve as environment variable names and their values. The decoded
	// environment variables can overwrite the values specified by the
	// `environment` field.
	EncryptedEnvironment *Secret `protobuf:"bytes,5,opt,name=encrypted_environment,json=encryptedEnvironment,proto3" json:"encrypted_environment,omitempty"`
	// The maximum amount of time to give the pipeline to complete.  This includes
	// the time spent waiting for a worker to be allocated.  If the pipeline fails
	// to complete before the timeout, it will be cancelled and the error code
	// will be set to DEADLINE_EXCEEDED.
	//
	// If unspecified, it will default to 7 days.
	Timeout *durationpb.Duration `protobuf:"bytes,4,opt,name=timeout,proto3" json:"timeout,omitempty"`
}

func (x *Pipeline) Reset() {
	*x = Pipeline{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Pipeline) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Pipeline) ProtoMessage() {}

func (x *Pipeline) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Pipeline.ProtoReflect.Descriptor instead.
func (*Pipeline) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{2}
}

func (x *Pipeline) GetActions() []*Action {
	if x != nil {
		return x.Actions
	}
	return nil
}

func (x *Pipeline) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Pipeline) GetEnvironment() map[string]string {
	if x != nil {
		return x.Environment
	}
	return nil
}

func (x *Pipeline) GetEncryptedEnvironment() *Secret {
	if x != nil {
		return x.EncryptedEnvironment
	}
	return nil
}

func (x *Pipeline) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

// Specifies a single action that runs a Docker container.
type Action struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An optional name for the container. The container hostname will be set to
	// this name, making it useful for inter-container communication. The name
	// must contain only upper and lowercase alphanumeric characters and hyphens
	// and cannot start with a hyphen.
	ContainerName string `protobuf:"bytes,1,opt,name=container_name,json=containerName,proto3" json:"container_name,omitempty"`
	// Required. The URI to pull the container image from. Note that all images
	// referenced by actions in the pipeline are pulled before the first action
	// runs. If multiple actions reference the same image, it is only pulled once,
	// ensuring that the same image is used for all actions in a single pipeline.
	//
	// The image URI can be either a complete host and image specification (e.g.,
	// quay.io/biocontainers/samtools), a library and image name (e.g.,
	// google/cloud-sdk) or a bare image name ('bash') to pull from the default
	// library.  No schema is required in any of these cases.
	//
	// If the specified image is not public, the service account specified for
	// the Virtual Machine must have access to pull the images from GCR, or
	// appropriate credentials must be specified in the
	// [google.cloud.lifesciences.v2beta.Action.credentials][google.cloud.lifesciences.v2beta.Action.credentials]
	// field.
	ImageUri string `protobuf:"bytes,2,opt,name=image_uri,json=imageUri,proto3" json:"image_uri,omitempty"`
	// If specified, overrides the `CMD` specified in the container. If the
	// container also has an `ENTRYPOINT` the values are used as entrypoint
	// arguments. Otherwise, they are used as a command and arguments to run
	// inside the container.
	Commands []string `protobuf:"bytes,3,rep,name=commands,proto3" json:"commands,omitempty"`
	// If specified, overrides the `ENTRYPOINT` specified in the container.
	Entrypoint string `protobuf:"bytes,4,opt,name=entrypoint,proto3" json:"entrypoint,omitempty"`
	// The environment to pass into the container. This environment is merged
	// with values specified in the
	// [google.cloud.lifesciences.v2beta.Pipeline][google.cloud.lifesciences.v2beta.Pipeline]
	// message, overwriting any duplicate values.
	//
	// In addition to the values passed here, a few other values are
	// automatically injected into the environment. These cannot be hidden or
	// overwritten.
	//
	// `GOOGLE_PIPELINE_FAILED` will be set to "1" if the pipeline failed
	// because an action has exited with a non-zero status (and did not have the
	// `IGNORE_EXIT_STATUS` flag set). This can be used to determine if additional
	// debug or logging actions should execute.
	//
	// `GOOGLE_LAST_EXIT_STATUS` will be set to the exit status of the last
	// non-background action that executed. This can be used by workflow engine
	// authors to determine whether an individual action has succeeded or failed.
	Environment map[string]string `protobuf:"bytes,5,rep,name=environment,proto3" json:"environment,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The encrypted environment to pass into the container. This environment is
	// merged with values specified in the
	// [google.cloud.lifesciences.v2beta.Pipeline][google.cloud.lifesciences.v2beta.Pipeline]
	// message, overwriting any duplicate values.
	//
	// The secret must decrypt to a JSON-encoded dictionary where key-value pairs
	// serve as environment variable names and their values. The decoded
	// environment variables can overwrite the values specified by the
	// `environment` field.
	EncryptedEnvironment *Secret `protobuf:"bytes,21,opt,name=encrypted_environment,json=encryptedEnvironment,proto3" json:"encrypted_environment,omitempty"`
	// An optional identifier for a PID namespace to run the action inside.
	// Multiple actions should use the same string to share a namespace.  If
	// unspecified, a separate isolated namespace is used.
	PidNamespace string `protobuf:"bytes,6,opt,name=pid_namespace,json=pidNamespace,proto3" json:"pid_namespace,omitempty"`
	// A map of containers to host port mappings for this container. If the
	// container already specifies exposed ports, use the
	// `PUBLISH_EXPOSED_PORTS` flag instead.
	//
	// The host port number must be less than 65536. If it is zero, an unused
	// random port is assigned. To determine the resulting port number, consult
	// the `ContainerStartedEvent` in the operation metadata.
	PortMappings map[int32]int32 `protobuf:"bytes,8,rep,name=port_mappings,json=portMappings,proto3" json:"port_mappings,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// A list of mounts to make available to the action.
	//
	// In addition to the values specified here, every action has a special
	// virtual disk mounted under `/google` that contains log files and other
	// operational components.
	//
	// <ul>
	//   <li><code>/google/logs</code> All logs written during the pipeline
	//   execution.</li>
	//   <li><code>/google/logs/output</code> The combined standard output and
	//   standard error of all actions run as part of the pipeline
	//   execution.</li>
	//   <li><code>/google/logs/action/*/stdout</code> The complete contents of
	//   each individual action's standard output.</li>
	//   <li><code>/google/logs/action/*/stderr</code> The complete contents of
	//   each individual action's standard error output.</li>
	// </ul>
	Mounts []*Mount `protobuf:"bytes,9,rep,name=mounts,proto3" json:"mounts,omitempty"`
	// Labels to associate with the action. This field is provided to assist
	// workflow engine authors in identifying actions (for example, to indicate
	// what sort of action they perform, such as localization or debugging).
	// They are returned in the operation metadata, but are otherwise ignored.
	Labels map[string]string `protobuf:"bytes,10,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// If the specified image is hosted on a private registry other than Google
	// Container Registry, the credentials required to pull the image must be
	// specified here as an encrypted secret.
	//
	// The secret must decrypt to a JSON-encoded dictionary containing both
	// `username` and `password` keys.
	Credentials *Secret `protobuf:"bytes,11,opt,name=credentials,proto3" json:"credentials,omitempty"`
	// The maximum amount of time to give the action to complete. If the action
	// fails to complete before the timeout, it will be terminated and the exit
	// status will be non-zero. The pipeline will continue or terminate based
	// on the rules defined by the `ALWAYS_RUN` and `IGNORE_EXIT_STATUS` flags.
	Timeout *durationpb.Duration `protobuf:"bytes,12,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// Normally, a non-zero exit status causes the pipeline to fail. This flag
	// allows execution of other actions to continue instead.
	IgnoreExitStatus bool `protobuf:"varint,13,opt,name=ignore_exit_status,json=ignoreExitStatus,proto3" json:"ignore_exit_status,omitempty"`
	// This flag allows an action to continue running in the background while
	// executing subsequent actions. This is useful to provide services to
	// other actions (or to provide debugging support tools like SSH servers).
	RunInBackground bool `protobuf:"varint,14,opt,name=run_in_background,json=runInBackground,proto3" json:"run_in_background,omitempty"`
	// By default, after an action fails, no further actions are run. This flag
	// indicates that this action must be run even if the pipeline has already
	// failed. This is useful for actions that copy output files off of the VM
	// or for debugging. Note that no actions will be run if image prefetching
	// fails.
	AlwaysRun bool `protobuf:"varint,15,opt,name=always_run,json=alwaysRun,proto3" json:"always_run,omitempty"`
	// Enable access to the FUSE device for this action. Filesystems can then
	// be mounted into disks shared with other actions. The other actions do
	// not need the `enable_fuse` flag to access the mounted filesystem.
	//
	// This has the effect of causing the container to be executed with
	// `CAP_SYS_ADMIN` and exposes `/dev/fuse` to the container, so use it only
	// for containers you trust.
	EnableFuse bool `protobuf:"varint,16,opt,name=enable_fuse,json=enableFuse,proto3" json:"enable_fuse,omitempty"`
	// Exposes all ports specified by `EXPOSE` statements in the container. To
	// discover the host side port numbers, consult the `ACTION_STARTED` event
	// in the operation metadata.
	PublishExposedPorts bool `protobuf:"varint,17,opt,name=publish_exposed_ports,json=publishExposedPorts,proto3" json:"publish_exposed_ports,omitempty"`
	// All container images are typically downloaded before any actions are
	// executed. This helps prevent typos in URIs or issues like lack of disk
	// space from wasting large amounts of compute resources.
	//
	// If set, this flag prevents the worker from downloading the image until
	// just before the action is executed.
	DisableImagePrefetch bool `protobuf:"varint,18,opt,name=disable_image_prefetch,json=disableImagePrefetch,proto3" json:"disable_image_prefetch,omitempty"`
	// A small portion of the container's standard error stream is typically
	// captured and returned inside the `ContainerStoppedEvent`. Setting this
	// flag disables this functionality.
	DisableStandardErrorCapture bool `protobuf:"varint,19,opt,name=disable_standard_error_capture,json=disableStandardErrorCapture,proto3" json:"disable_standard_error_capture,omitempty"`
	// Prevents the container from accessing the external network.
	BlockExternalNetwork bool `protobuf:"varint,20,opt,name=block_external_network,json=blockExternalNetwork,proto3" json:"block_external_network,omitempty"`
}

func (x *Action) Reset() {
	*x = Action{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action) ProtoMessage() {}

func (x *Action) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action.ProtoReflect.Descriptor instead.
func (*Action) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{3}
}

func (x *Action) GetContainerName() string {
	if x != nil {
		return x.ContainerName
	}
	return ""
}

func (x *Action) GetImageUri() string {
	if x != nil {
		return x.ImageUri
	}
	return ""
}

func (x *Action) GetCommands() []string {
	if x != nil {
		return x.Commands
	}
	return nil
}

func (x *Action) GetEntrypoint() string {
	if x != nil {
		return x.Entrypoint
	}
	return ""
}

func (x *Action) GetEnvironment() map[string]string {
	if x != nil {
		return x.Environment
	}
	return nil
}

func (x *Action) GetEncryptedEnvironment() *Secret {
	if x != nil {
		return x.EncryptedEnvironment
	}
	return nil
}

func (x *Action) GetPidNamespace() string {
	if x != nil {
		return x.PidNamespace
	}
	return ""
}

func (x *Action) GetPortMappings() map[int32]int32 {
	if x != nil {
		return x.PortMappings
	}
	return nil
}

func (x *Action) GetMounts() []*Mount {
	if x != nil {
		return x.Mounts
	}
	return nil
}

func (x *Action) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Action) GetCredentials() *Secret {
	if x != nil {
		return x.Credentials
	}
	return nil
}

func (x *Action) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *Action) GetIgnoreExitStatus() bool {
	if x != nil {
		return x.IgnoreExitStatus
	}
	return false
}

func (x *Action) GetRunInBackground() bool {
	if x != nil {
		return x.RunInBackground
	}
	return false
}

func (x *Action) GetAlwaysRun() bool {
	if x != nil {
		return x.AlwaysRun
	}
	return false
}

func (x *Action) GetEnableFuse() bool {
	if x != nil {
		return x.EnableFuse
	}
	return false
}

func (x *Action) GetPublishExposedPorts() bool {
	if x != nil {
		return x.PublishExposedPorts
	}
	return false
}

func (x *Action) GetDisableImagePrefetch() bool {
	if x != nil {
		return x.DisableImagePrefetch
	}
	return false
}

func (x *Action) GetDisableStandardErrorCapture() bool {
	if x != nil {
		return x.DisableStandardErrorCapture
	}
	return false
}

func (x *Action) GetBlockExternalNetwork() bool {
	if x != nil {
		return x.BlockExternalNetwork
	}
	return false
}

// Holds encrypted information that is only decrypted and stored in RAM
// by the worker VM when running the pipeline.
type Secret struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the Cloud KMS key that will be used to decrypt the secret
	// value. The VM service account must have the required permissions and
	// authentication scopes to invoke the `decrypt` method on the specified key.
	KeyName string `protobuf:"bytes,1,opt,name=key_name,json=keyName,proto3" json:"key_name,omitempty"`
	// The value of the cipherText response from the `encrypt` method. This field
	// is intentionally unaudited.
	CipherText string `protobuf:"bytes,2,opt,name=cipher_text,json=cipherText,proto3" json:"cipher_text,omitempty"`
}

func (x *Secret) Reset() {
	*x = Secret{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Secret) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Secret) ProtoMessage() {}

func (x *Secret) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Secret.ProtoReflect.Descriptor instead.
func (*Secret) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{4}
}

func (x *Secret) GetKeyName() string {
	if x != nil {
		return x.KeyName
	}
	return ""
}

func (x *Secret) GetCipherText() string {
	if x != nil {
		return x.CipherText
	}
	return ""
}

// Carries information about a particular disk mount inside a container.
type Mount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the disk to mount, as specified in the resources section.
	Disk string `protobuf:"bytes,1,opt,name=disk,proto3" json:"disk,omitempty"`
	// The path to mount the disk inside the container.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	// If true, the disk is mounted read-only inside the container.
	ReadOnly bool `protobuf:"varint,3,opt,name=read_only,json=readOnly,proto3" json:"read_only,omitempty"`
}

func (x *Mount) Reset() {
	*x = Mount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mount) ProtoMessage() {}

func (x *Mount) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mount.ProtoReflect.Descriptor instead.
func (*Mount) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{5}
}

func (x *Mount) GetDisk() string {
	if x != nil {
		return x.Disk
	}
	return ""
}

func (x *Mount) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *Mount) GetReadOnly() bool {
	if x != nil {
		return x.ReadOnly
	}
	return false
}

// The system resources for the pipeline run.
//
// At least one zone or region must be specified or the pipeline run will fail.
type Resources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of regions allowed for VM allocation. If set, the `zones` field
	// must not be set.
	Regions []string `protobuf:"bytes,2,rep,name=regions,proto3" json:"regions,omitempty"`
	// The list of zones allowed for VM allocation. If set, the `regions` field
	// must not be set.
	Zones []string `protobuf:"bytes,3,rep,name=zones,proto3" json:"zones,omitempty"`
	// The virtual machine specification.
	VirtualMachine *VirtualMachine `protobuf:"bytes,4,opt,name=virtual_machine,json=virtualMachine,proto3" json:"virtual_machine,omitempty"`
}

func (x *Resources) Reset() {
	*x = Resources{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Resources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resources) ProtoMessage() {}

func (x *Resources) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resources.ProtoReflect.Descriptor instead.
func (*Resources) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{6}
}

func (x *Resources) GetRegions() []string {
	if x != nil {
		return x.Regions
	}
	return nil
}

func (x *Resources) GetZones() []string {
	if x != nil {
		return x.Zones
	}
	return nil
}

func (x *Resources) GetVirtualMachine() *VirtualMachine {
	if x != nil {
		return x.VirtualMachine
	}
	return nil
}

// Carries information about a Compute Engine VM resource.
type VirtualMachine struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The machine type of the virtual machine to create. Must be the
	// short name of a standard machine type (such as "n1-standard-1") or a custom
	// machine type (such as "custom-1-4096", where "1" indicates the number of
	// vCPUs and "4096" indicates the memory in MB). See [Creating an instance
	// with a custom machine
	// type](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create)
	// for more specifications on creating a custom machine type.
	MachineType string `protobuf:"bytes,1,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// If true, allocate a preemptible VM.
	Preemptible bool `protobuf:"varint,2,opt,name=preemptible,proto3" json:"preemptible,omitempty"`
	// Optional set of labels to apply to the VM and any attached disk resources.
	// These labels must adhere to the [name and value
	// restrictions](https://cloud.google.com/compute/docs/labeling-resources) on
	// VM labels imposed by Compute Engine.
	//
	// Labels keys with the prefix 'google-' are reserved for use by Google.
	//
	// Labels applied at creation time to the VM. Applied on a best-effort basis
	// to attached disk resources shortly after VM creation.
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The list of disks to create and attach to the VM.
	//
	// Specify either the `volumes[]` field or the `disks[]` field, but not both.
	Disks []*Disk `protobuf:"bytes,4,rep,name=disks,proto3" json:"disks,omitempty"`
	// The VM network configuration.
	Network *Network `protobuf:"bytes,5,opt,name=network,proto3" json:"network,omitempty"`
	// The list of accelerators to attach to the VM.
	Accelerators []*Accelerator `protobuf:"bytes,6,rep,name=accelerators,proto3" json:"accelerators,omitempty"`
	// The service account to install on the VM. This account does not need
	// any permissions other than those required by the pipeline.
	ServiceAccount *ServiceAccount `protobuf:"bytes,7,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// The size of the boot disk, in GB. The boot disk must be large
	// enough to accommodate all of the Docker images from each action in the
	// pipeline at the same time. If not specified, a small but reasonable
	// default value is used.
	BootDiskSizeGb int32 `protobuf:"varint,8,opt,name=boot_disk_size_gb,json=bootDiskSizeGb,proto3" json:"boot_disk_size_gb,omitempty"`
	// The CPU platform to request. An instance based on a newer platform can be
	// allocated, but never one with fewer capabilities. The value of this
	// parameter must be a valid Compute Engine CPU platform name (such as "Intel
	// Skylake"). This parameter is only useful for carefully optimized work
	// loads where the CPU platform has a significant impact.
	//
	// For more information about the effect of this parameter, see
	// https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
	CpuPlatform string `protobuf:"bytes,9,opt,name=cpu_platform,json=cpuPlatform,proto3" json:"cpu_platform,omitempty"`
	// The host operating system image to use.
	//
	// Currently, only Container-Optimized OS images can be used.
	//
	// The default value is `projects/cos-cloud/global/images/family/cos-stable`,
	// which selects the latest stable release of Container-Optimized OS.
	//
	// This option is provided to allow testing against the beta release of the
	// operating system to ensure that the new version does not interact
	// negatively with production pipelines.
	//
	// To test a pipeline against the beta release of Container-Optimized OS,
	// use the value `projects/cos-cloud/global/images/family/cos-beta`.
	BootImage string `protobuf:"bytes,10,opt,name=boot_image,json=bootImage,proto3" json:"boot_image,omitempty"`
	// The NVIDIA driver version to use when attaching an NVIDIA GPU accelerator.
	// The version specified here must be compatible with the GPU libraries
	// contained in the container being executed, and must be one of the drivers
	// hosted in the `nvidia-drivers-us-public` bucket on Google Cloud Storage.
	//
	// Deprecated: Marked as deprecated in google/cloud/lifesciences/v2beta/workflows.proto.
	NvidiaDriverVersion string `protobuf:"bytes,11,opt,name=nvidia_driver_version,json=nvidiaDriverVersion,proto3" json:"nvidia_driver_version,omitempty"`
	// Whether Stackdriver monitoring should be enabled on the VM.
	EnableStackdriverMonitoring bool `protobuf:"varint,12,opt,name=enable_stackdriver_monitoring,json=enableStackdriverMonitoring,proto3" json:"enable_stackdriver_monitoring,omitempty"`
	// The Compute Engine Disk Images to use as a Docker cache. The disks will be
	// mounted into the Docker folder in a way that the images present in the
	// cache will not need to be pulled. The digests of the cached images must
	// match those of the tags used or the latest version will still be pulled.
	// The root directory of the ext4 image must contain `image` and `overlay2`
	// directories copied from the Docker directory of a VM where the desired
	// Docker images have already been pulled. Any images pulled that are not
	// cached will be stored on the first cache disk instead of the boot disk.
	// Only a single image is supported.
	DockerCacheImages []string `protobuf:"bytes,13,rep,name=docker_cache_images,json=dockerCacheImages,proto3" json:"docker_cache_images,omitempty"`
	// The list of disks and other storage to create or attach to the VM.
	//
	// Specify either the `volumes[]` field or the `disks[]` field, but not both.
	Volumes []*Volume `protobuf:"bytes,14,rep,name=volumes,proto3" json:"volumes,omitempty"`
	// If specified, the VM will only be allocated inside the matching
	// reservation. It will fail if the VM parameters don't match the reservation.
	Reservation string `protobuf:"bytes,15,opt,name=reservation,proto3" json:"reservation,omitempty"`
}

func (x *VirtualMachine) Reset() {
	*x = VirtualMachine{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VirtualMachine) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VirtualMachine) ProtoMessage() {}

func (x *VirtualMachine) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VirtualMachine.ProtoReflect.Descriptor instead.
func (*VirtualMachine) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{7}
}

func (x *VirtualMachine) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *VirtualMachine) GetPreemptible() bool {
	if x != nil {
		return x.Preemptible
	}
	return false
}

func (x *VirtualMachine) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *VirtualMachine) GetDisks() []*Disk {
	if x != nil {
		return x.Disks
	}
	return nil
}

func (x *VirtualMachine) GetNetwork() *Network {
	if x != nil {
		return x.Network
	}
	return nil
}

func (x *VirtualMachine) GetAccelerators() []*Accelerator {
	if x != nil {
		return x.Accelerators
	}
	return nil
}

func (x *VirtualMachine) GetServiceAccount() *ServiceAccount {
	if x != nil {
		return x.ServiceAccount
	}
	return nil
}

func (x *VirtualMachine) GetBootDiskSizeGb() int32 {
	if x != nil {
		return x.BootDiskSizeGb
	}
	return 0
}

func (x *VirtualMachine) GetCpuPlatform() string {
	if x != nil {
		return x.CpuPlatform
	}
	return ""
}

func (x *VirtualMachine) GetBootImage() string {
	if x != nil {
		return x.BootImage
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/lifesciences/v2beta/workflows.proto.
func (x *VirtualMachine) GetNvidiaDriverVersion() string {
	if x != nil {
		return x.NvidiaDriverVersion
	}
	return ""
}

func (x *VirtualMachine) GetEnableStackdriverMonitoring() bool {
	if x != nil {
		return x.EnableStackdriverMonitoring
	}
	return false
}

func (x *VirtualMachine) GetDockerCacheImages() []string {
	if x != nil {
		return x.DockerCacheImages
	}
	return nil
}

func (x *VirtualMachine) GetVolumes() []*Volume {
	if x != nil {
		return x.Volumes
	}
	return nil
}

func (x *VirtualMachine) GetReservation() string {
	if x != nil {
		return x.Reservation
	}
	return ""
}

// Carries information about a Google Cloud service account.
type ServiceAccount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Email address of the service account. If not specified, the default
	// Compute Engine service account for the project will be used.
	Email string `protobuf:"bytes,1,opt,name=email,proto3" json:"email,omitempty"`
	// List of scopes to be enabled for this service account on the VM, in
	// addition to the cloud-platform API scope that will be added by default.
	Scopes []string `protobuf:"bytes,2,rep,name=scopes,proto3" json:"scopes,omitempty"`
}

func (x *ServiceAccount) Reset() {
	*x = ServiceAccount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceAccount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceAccount) ProtoMessage() {}

func (x *ServiceAccount) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceAccount.ProtoReflect.Descriptor instead.
func (*ServiceAccount) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{8}
}

func (x *ServiceAccount) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

func (x *ServiceAccount) GetScopes() []string {
	if x != nil {
		return x.Scopes
	}
	return nil
}

// Carries information about an accelerator that can be attached to a VM.
type Accelerator struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The accelerator type string (for example, "nvidia-tesla-k80").
	//
	// Only NVIDIA GPU accelerators are currently supported. If an NVIDIA GPU is
	// attached, the required runtime libraries will be made available to all
	// containers under `/usr/local/nvidia`. The driver version to install must
	// be specified using the NVIDIA driver version parameter on the virtual
	// machine specification. Note that attaching a GPU increases the worker VM
	// startup time by a few minutes.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// How many accelerators of this type to attach.
	Count int64 `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *Accelerator) Reset() {
	*x = Accelerator{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Accelerator) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Accelerator) ProtoMessage() {}

func (x *Accelerator) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Accelerator.ProtoReflect.Descriptor instead.
func (*Accelerator) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{9}
}

func (x *Accelerator) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Accelerator) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

// VM networking options.
type Network struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The network name to attach the VM's network interface to. The value will
	// be prefixed with `global/networks/` unless it contains a `/`, in which
	// case it is assumed to be a fully specified network resource URL.
	//
	// If unspecified, the global default network is used.
	Network string `protobuf:"bytes,1,opt,name=network,proto3" json:"network,omitempty"`
	// If set to true, do not attach a public IP address to the VM. Note that
	// without a public IP address, additional configuration is required to
	// allow the VM to access Google services.
	//
	// See https://cloud.google.com/vpc/docs/configure-private-google-access
	// for more information.
	UsePrivateAddress bool `protobuf:"varint,2,opt,name=use_private_address,json=usePrivateAddress,proto3" json:"use_private_address,omitempty"`
	// If the specified network is configured for custom subnet creation, the
	// name of the subnetwork to attach the instance to must be specified here.
	//
	// The value is prefixed with `regions/*/subnetworks/` unless it contains a
	// `/`, in which case it is assumed to be a fully specified subnetwork
	// resource URL.
	//
	// If the `*` character appears in the value, it is replaced with the region
	// that the virtual machine has been allocated in.
	Subnetwork string `protobuf:"bytes,3,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
}

func (x *Network) Reset() {
	*x = Network{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Network) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Network) ProtoMessage() {}

func (x *Network) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Network.ProtoReflect.Descriptor instead.
func (*Network) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{10}
}

func (x *Network) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *Network) GetUsePrivateAddress() bool {
	if x != nil {
		return x.UsePrivateAddress
	}
	return false
}

func (x *Network) GetSubnetwork() string {
	if x != nil {
		return x.Subnetwork
	}
	return ""
}

// Carries information about a disk that can be attached to a VM.
//
// See https://cloud.google.com/compute/docs/disks/performance for more
// information about disk type, size, and performance considerations.
//
// Specify either [`Volume`][google.cloud.lifesciences.v2beta.Volume] or
// [`Disk`][google.cloud.lifesciences.v2beta.Disk], but not both.
type Disk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A user-supplied name for the disk. Used when mounting the disk into
	// actions. The name must contain only upper and lowercase alphanumeric
	// characters and hyphens and cannot start with a hyphen.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The size, in GB, of the disk to attach. If the size is not
	// specified, a default is chosen to ensure reasonable I/O performance.
	//
	// If the disk type is specified as `local-ssd`, multiple local drives are
	// automatically combined to provide the requested size. Note, however, that
	// each physical SSD is 375GB in size, and no more than 8 drives can be
	// attached to a single instance.
	SizeGb int32 `protobuf:"varint,2,opt,name=size_gb,json=sizeGb,proto3" json:"size_gb,omitempty"`
	// The Compute Engine disk type. If unspecified, `pd-standard` is used.
	Type string `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	// An optional image to put on the disk before attaching it to the VM.
	SourceImage string `protobuf:"bytes,4,opt,name=source_image,json=sourceImage,proto3" json:"source_image,omitempty"`
}

func (x *Disk) Reset() {
	*x = Disk{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Disk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Disk) ProtoMessage() {}

func (x *Disk) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Disk.ProtoReflect.Descriptor instead.
func (*Disk) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{11}
}

func (x *Disk) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Disk) GetSizeGb() int32 {
	if x != nil {
		return x.SizeGb
	}
	return 0
}

func (x *Disk) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Disk) GetSourceImage() string {
	if x != nil {
		return x.SourceImage
	}
	return ""
}

// Carries information about storage that can be attached to a VM.
//
// Specify either [`Volume`][google.cloud.lifesciences.v2beta.Volume] or
// [`Disk`][google.cloud.lifesciences.v2beta.Disk], but not both.
type Volume struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A user-supplied name for the volume. Used when mounting the volume into
	// [`Actions`][google.cloud.lifesciences.v2beta.Action]. The name must contain
	// only upper and lowercase alphanumeric characters and hyphens and cannot
	// start with a hyphen.
	Volume string `protobuf:"bytes,1,opt,name=volume,proto3" json:"volume,omitempty"`
	// Types that are assignable to Storage:
	//	*Volume_PersistentDisk
	//	*Volume_ExistingDisk
	//	*Volume_NfsMount
	Storage isVolume_Storage `protobuf_oneof:"storage"`
}

func (x *Volume) Reset() {
	*x = Volume{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Volume) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Volume) ProtoMessage() {}

func (x *Volume) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Volume.ProtoReflect.Descriptor instead.
func (*Volume) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{12}
}

func (x *Volume) GetVolume() string {
	if x != nil {
		return x.Volume
	}
	return ""
}

func (m *Volume) GetStorage() isVolume_Storage {
	if m != nil {
		return m.Storage
	}
	return nil
}

func (x *Volume) GetPersistentDisk() *PersistentDisk {
	if x, ok := x.GetStorage().(*Volume_PersistentDisk); ok {
		return x.PersistentDisk
	}
	return nil
}

func (x *Volume) GetExistingDisk() *ExistingDisk {
	if x, ok := x.GetStorage().(*Volume_ExistingDisk); ok {
		return x.ExistingDisk
	}
	return nil
}

func (x *Volume) GetNfsMount() *NFSMount {
	if x, ok := x.GetStorage().(*Volume_NfsMount); ok {
		return x.NfsMount
	}
	return nil
}

type isVolume_Storage interface {
	isVolume_Storage()
}

type Volume_PersistentDisk struct {
	// Configuration for a persistent disk.
	PersistentDisk *PersistentDisk `protobuf:"bytes,2,opt,name=persistent_disk,json=persistentDisk,proto3,oneof"`
}

type Volume_ExistingDisk struct {
	// Configuration for a existing disk.
	ExistingDisk *ExistingDisk `protobuf:"bytes,3,opt,name=existing_disk,json=existingDisk,proto3,oneof"`
}

type Volume_NfsMount struct {
	// Configuration for an NFS mount.
	NfsMount *NFSMount `protobuf:"bytes,4,opt,name=nfs_mount,json=nfsMount,proto3,oneof"`
}

func (*Volume_PersistentDisk) isVolume_Storage() {}

func (*Volume_ExistingDisk) isVolume_Storage() {}

func (*Volume_NfsMount) isVolume_Storage() {}

// Configuration for a persistent disk to be attached to the VM.
//
// See https://cloud.google.com/compute/docs/disks/performance for more
// information about disk type, size, and performance considerations.
type PersistentDisk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The size, in GB, of the disk to attach. If the size is not
	// specified, a default is chosen to ensure reasonable I/O performance.
	//
	// If the disk type is specified as `local-ssd`, multiple local drives are
	// automatically combined to provide the requested size. Note, however, that
	// each physical SSD is 375GB in size, and no more than 8 drives can be
	// attached to a single instance.
	SizeGb int32 `protobuf:"varint,1,opt,name=size_gb,json=sizeGb,proto3" json:"size_gb,omitempty"`
	// The Compute Engine disk type. If unspecified, `pd-standard` is used.
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// An image to put on the disk before attaching it to the VM.
	SourceImage string `protobuf:"bytes,3,opt,name=source_image,json=sourceImage,proto3" json:"source_image,omitempty"`
}

func (x *PersistentDisk) Reset() {
	*x = PersistentDisk{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PersistentDisk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PersistentDisk) ProtoMessage() {}

func (x *PersistentDisk) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PersistentDisk.ProtoReflect.Descriptor instead.
func (*PersistentDisk) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{13}
}

func (x *PersistentDisk) GetSizeGb() int32 {
	if x != nil {
		return x.SizeGb
	}
	return 0
}

func (x *PersistentDisk) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *PersistentDisk) GetSourceImage() string {
	if x != nil {
		return x.SourceImage
	}
	return ""
}

// Configuration for an existing disk to be attached to the VM.
type ExistingDisk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If `disk` contains slashes, the Cloud Life Sciences API assumes that it is
	// a complete URL for the disk.  If `disk` does not contain slashes, the Cloud
	// Life Sciences API assumes that the disk is a zonal disk and a URL will be
	// generated of the form `zones/<zone>/disks/<disk>`, where `<zone>` is the
	// zone in which the instance is allocated. The disk must be ext4 formatted.
	//
	// If all `Mount` references to this disk have the `read_only` flag set to
	// true, the disk will be attached in `read-only` mode and can be shared with
	// other instances. Otherwise, the disk will be available for writing but
	// cannot be shared.
	Disk string `protobuf:"bytes,1,opt,name=disk,proto3" json:"disk,omitempty"`
}

func (x *ExistingDisk) Reset() {
	*x = ExistingDisk{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExistingDisk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExistingDisk) ProtoMessage() {}

func (x *ExistingDisk) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExistingDisk.ProtoReflect.Descriptor instead.
func (*ExistingDisk) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{14}
}

func (x *ExistingDisk) GetDisk() string {
	if x != nil {
		return x.Disk
	}
	return ""
}

// Configuration for an `NFSMount` to be attached to the VM.
type NFSMount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A target NFS mount. The target must be specified as `address:/mount".
	Target string `protobuf:"bytes,1,opt,name=target,proto3" json:"target,omitempty"`
}

func (x *NFSMount) Reset() {
	*x = NFSMount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NFSMount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NFSMount) ProtoMessage() {}

func (x *NFSMount) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NFSMount.ProtoReflect.Descriptor instead.
func (*NFSMount) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{15}
}

func (x *NFSMount) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

// Carries information about the pipeline execution that is returned
// in the long running operation's metadata field.
type Metadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The pipeline this operation represents.
	Pipeline *Pipeline `protobuf:"bytes,1,opt,name=pipeline,proto3" json:"pipeline,omitempty"`
	// The user-defined labels associated with this operation.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The list of events that have happened so far during the execution of this
	// operation.
	Events []*Event `protobuf:"bytes,3,rep,name=events,proto3" json:"events,omitempty"`
	// The time at which the operation was created by the API.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The first time at which resources were allocated to execute the pipeline.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time at which execution was completed and resources were cleaned up.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The name of the Cloud Pub/Sub topic where notifications of operation status
	// changes are sent.
	PubSubTopic string `protobuf:"bytes,7,opt,name=pub_sub_topic,json=pubSubTopic,proto3" json:"pub_sub_topic,omitempty"`
}

func (x *Metadata) Reset() {
	*x = Metadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Metadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Metadata) ProtoMessage() {}

func (x *Metadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Metadata.ProtoReflect.Descriptor instead.
func (*Metadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{16}
}

func (x *Metadata) GetPipeline() *Pipeline {
	if x != nil {
		return x.Pipeline
	}
	return nil
}

func (x *Metadata) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Metadata) GetEvents() []*Event {
	if x != nil {
		return x.Events
	}
	return nil
}

func (x *Metadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Metadata) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Metadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Metadata) GetPubSubTopic() string {
	if x != nil {
		return x.PubSubTopic
	}
	return ""
}

// Carries information about events that occur during pipeline execution.
type Event struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time at which the event occurred.
	Timestamp *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// A human-readable description of the event. Note that these strings can
	// change at any time without notice. Any application logic must use the
	// information in the `details` field.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Machine-readable details about the event.
	//
	// Types that are assignable to Details:
	//	*Event_Delayed
	//	*Event_WorkerAssigned
	//	*Event_WorkerReleased
	//	*Event_PullStarted
	//	*Event_PullStopped
	//	*Event_ContainerStarted
	//	*Event_ContainerStopped
	//	*Event_ContainerKilled
	//	*Event_UnexpectedExitStatus
	//	*Event_Failed
	Details isEvent_Details `protobuf_oneof:"details"`
}

func (x *Event) Reset() {
	*x = Event{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Event) ProtoMessage() {}

func (x *Event) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Event.ProtoReflect.Descriptor instead.
func (*Event) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{17}
}

func (x *Event) GetTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

func (x *Event) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (m *Event) GetDetails() isEvent_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (x *Event) GetDelayed() *DelayedEvent {
	if x, ok := x.GetDetails().(*Event_Delayed); ok {
		return x.Delayed
	}
	return nil
}

func (x *Event) GetWorkerAssigned() *WorkerAssignedEvent {
	if x, ok := x.GetDetails().(*Event_WorkerAssigned); ok {
		return x.WorkerAssigned
	}
	return nil
}

func (x *Event) GetWorkerReleased() *WorkerReleasedEvent {
	if x, ok := x.GetDetails().(*Event_WorkerReleased); ok {
		return x.WorkerReleased
	}
	return nil
}

func (x *Event) GetPullStarted() *PullStartedEvent {
	if x, ok := x.GetDetails().(*Event_PullStarted); ok {
		return x.PullStarted
	}
	return nil
}

func (x *Event) GetPullStopped() *PullStoppedEvent {
	if x, ok := x.GetDetails().(*Event_PullStopped); ok {
		return x.PullStopped
	}
	return nil
}

func (x *Event) GetContainerStarted() *ContainerStartedEvent {
	if x, ok := x.GetDetails().(*Event_ContainerStarted); ok {
		return x.ContainerStarted
	}
	return nil
}

func (x *Event) GetContainerStopped() *ContainerStoppedEvent {
	if x, ok := x.GetDetails().(*Event_ContainerStopped); ok {
		return x.ContainerStopped
	}
	return nil
}

func (x *Event) GetContainerKilled() *ContainerKilledEvent {
	if x, ok := x.GetDetails().(*Event_ContainerKilled); ok {
		return x.ContainerKilled
	}
	return nil
}

func (x *Event) GetUnexpectedExitStatus() *UnexpectedExitStatusEvent {
	if x, ok := x.GetDetails().(*Event_UnexpectedExitStatus); ok {
		return x.UnexpectedExitStatus
	}
	return nil
}

func (x *Event) GetFailed() *FailedEvent {
	if x, ok := x.GetDetails().(*Event_Failed); ok {
		return x.Failed
	}
	return nil
}

type isEvent_Details interface {
	isEvent_Details()
}

type Event_Delayed struct {
	// See
	// [google.cloud.lifesciences.v2beta.DelayedEvent][google.cloud.lifesciences.v2beta.DelayedEvent].
	Delayed *DelayedEvent `protobuf:"bytes,17,opt,name=delayed,proto3,oneof"`
}

type Event_WorkerAssigned struct {
	// See
	// [google.cloud.lifesciences.v2beta.WorkerAssignedEvent][google.cloud.lifesciences.v2beta.WorkerAssignedEvent].
	WorkerAssigned *WorkerAssignedEvent `protobuf:"bytes,18,opt,name=worker_assigned,json=workerAssigned,proto3,oneof"`
}

type Event_WorkerReleased struct {
	// See
	// [google.cloud.lifesciences.v2beta.WorkerReleasedEvent][google.cloud.lifesciences.v2beta.WorkerReleasedEvent].
	WorkerReleased *WorkerReleasedEvent `protobuf:"bytes,19,opt,name=worker_released,json=workerReleased,proto3,oneof"`
}

type Event_PullStarted struct {
	// See
	// [google.cloud.lifesciences.v2beta.PullStartedEvent][google.cloud.lifesciences.v2beta.PullStartedEvent].
	PullStarted *PullStartedEvent `protobuf:"bytes,20,opt,name=pull_started,json=pullStarted,proto3,oneof"`
}

type Event_PullStopped struct {
	// See
	// [google.cloud.lifesciences.v2beta.PullStoppedEvent][google.cloud.lifesciences.v2beta.PullStoppedEvent].
	PullStopped *PullStoppedEvent `protobuf:"bytes,21,opt,name=pull_stopped,json=pullStopped,proto3,oneof"`
}

type Event_ContainerStarted struct {
	// See
	// [google.cloud.lifesciences.v2beta.ContainerStartedEvent][google.cloud.lifesciences.v2beta.ContainerStartedEvent].
	ContainerStarted *ContainerStartedEvent `protobuf:"bytes,22,opt,name=container_started,json=containerStarted,proto3,oneof"`
}

type Event_ContainerStopped struct {
	// See
	// [google.cloud.lifesciences.v2beta.ContainerStoppedEvent][google.cloud.lifesciences.v2beta.ContainerStoppedEvent].
	ContainerStopped *ContainerStoppedEvent `protobuf:"bytes,23,opt,name=container_stopped,json=containerStopped,proto3,oneof"`
}

type Event_ContainerKilled struct {
	// See
	// [google.cloud.lifesciences.v2beta.ContainerKilledEvent][google.cloud.lifesciences.v2beta.ContainerKilledEvent].
	ContainerKilled *ContainerKilledEvent `protobuf:"bytes,24,opt,name=container_killed,json=containerKilled,proto3,oneof"`
}

type Event_UnexpectedExitStatus struct {
	// See
	// [google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent][google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent].
	UnexpectedExitStatus *UnexpectedExitStatusEvent `protobuf:"bytes,25,opt,name=unexpected_exit_status,json=unexpectedExitStatus,proto3,oneof"`
}

type Event_Failed struct {
	// See
	// [google.cloud.lifesciences.v2beta.FailedEvent][google.cloud.lifesciences.v2beta.FailedEvent].
	Failed *FailedEvent `protobuf:"bytes,26,opt,name=failed,proto3,oneof"`
}

func (*Event_Delayed) isEvent_Details() {}

func (*Event_WorkerAssigned) isEvent_Details() {}

func (*Event_WorkerReleased) isEvent_Details() {}

func (*Event_PullStarted) isEvent_Details() {}

func (*Event_PullStopped) isEvent_Details() {}

func (*Event_ContainerStarted) isEvent_Details() {}

func (*Event_ContainerStopped) isEvent_Details() {}

func (*Event_ContainerKilled) isEvent_Details() {}

func (*Event_UnexpectedExitStatus) isEvent_Details() {}

func (*Event_Failed) isEvent_Details() {}

// An event generated whenever a resource limitation or transient error
// delays execution of a pipeline that was otherwise ready to run.
type DelayedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A textual description of the cause of the delay. The string can change
	// without notice because it is often generated by another service (such as
	// Compute Engine).
	Cause string `protobuf:"bytes,1,opt,name=cause,proto3" json:"cause,omitempty"`
	// If the delay was caused by a resource shortage, this field lists the
	// Compute Engine metrics that are preventing this operation from running
	// (for example, `CPUS` or `INSTANCES`). If the particular metric is not
	// known, a single `UNKNOWN` metric will be present.
	Metrics []string `protobuf:"bytes,2,rep,name=metrics,proto3" json:"metrics,omitempty"`
}

func (x *DelayedEvent) Reset() {
	*x = DelayedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DelayedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DelayedEvent) ProtoMessage() {}

func (x *DelayedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DelayedEvent.ProtoReflect.Descriptor instead.
func (*DelayedEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{18}
}

func (x *DelayedEvent) GetCause() string {
	if x != nil {
		return x.Cause
	}
	return ""
}

func (x *DelayedEvent) GetMetrics() []string {
	if x != nil {
		return x.Metrics
	}
	return nil
}

// An event generated after a worker VM has been assigned to run the
// pipeline.
type WorkerAssignedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The zone the worker is running in.
	Zone string `protobuf:"bytes,1,opt,name=zone,proto3" json:"zone,omitempty"`
	// The worker's instance name.
	Instance string `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
	// The machine type that was assigned for the worker.
	MachineType string `protobuf:"bytes,3,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
}

func (x *WorkerAssignedEvent) Reset() {
	*x = WorkerAssignedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkerAssignedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerAssignedEvent) ProtoMessage() {}

func (x *WorkerAssignedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerAssignedEvent.ProtoReflect.Descriptor instead.
func (*WorkerAssignedEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{19}
}

func (x *WorkerAssignedEvent) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *WorkerAssignedEvent) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *WorkerAssignedEvent) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

// An event generated when the worker VM that was assigned to the pipeline
// has been released (deleted).
type WorkerReleasedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The zone the worker was running in.
	Zone string `protobuf:"bytes,1,opt,name=zone,proto3" json:"zone,omitempty"`
	// The worker's instance name.
	Instance string `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *WorkerReleasedEvent) Reset() {
	*x = WorkerReleasedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkerReleasedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerReleasedEvent) ProtoMessage() {}

func (x *WorkerReleasedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerReleasedEvent.ProtoReflect.Descriptor instead.
func (*WorkerReleasedEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{20}
}

func (x *WorkerReleasedEvent) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *WorkerReleasedEvent) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

// An event generated when the worker starts pulling an image.
type PullStartedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URI of the image that was pulled.
	ImageUri string `protobuf:"bytes,1,opt,name=image_uri,json=imageUri,proto3" json:"image_uri,omitempty"`
}

func (x *PullStartedEvent) Reset() {
	*x = PullStartedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PullStartedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PullStartedEvent) ProtoMessage() {}

func (x *PullStartedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PullStartedEvent.ProtoReflect.Descriptor instead.
func (*PullStartedEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{21}
}

func (x *PullStartedEvent) GetImageUri() string {
	if x != nil {
		return x.ImageUri
	}
	return ""
}

// An event generated when the worker stops pulling an image.
type PullStoppedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URI of the image that was pulled.
	ImageUri string `protobuf:"bytes,1,opt,name=image_uri,json=imageUri,proto3" json:"image_uri,omitempty"`
}

func (x *PullStoppedEvent) Reset() {
	*x = PullStoppedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PullStoppedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PullStoppedEvent) ProtoMessage() {}

func (x *PullStoppedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PullStoppedEvent.ProtoReflect.Descriptor instead.
func (*PullStoppedEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{22}
}

func (x *PullStoppedEvent) GetImageUri() string {
	if x != nil {
		return x.ImageUri
	}
	return ""
}

// An event generated when a container starts.
type ContainerStartedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The numeric ID of the action that started this container.
	ActionId int32 `protobuf:"varint,1,opt,name=action_id,json=actionId,proto3" json:"action_id,omitempty"`
	// The container-to-host port mappings installed for this container. This
	// set will contain any ports exposed using the `PUBLISH_EXPOSED_PORTS` flag
	// as well as any specified in the `Action` definition.
	PortMappings map[int32]int32 `protobuf:"bytes,2,rep,name=port_mappings,json=portMappings,proto3" json:"port_mappings,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// The public IP address that can be used to connect to the container. This
	// field is only populated when at least one port mapping is present. If the
	// instance was created with a private address, this field will be empty even
	// if port mappings exist.
	IpAddress string `protobuf:"bytes,3,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
}

func (x *ContainerStartedEvent) Reset() {
	*x = ContainerStartedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContainerStartedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerStartedEvent) ProtoMessage() {}

func (x *ContainerStartedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerStartedEvent.ProtoReflect.Descriptor instead.
func (*ContainerStartedEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{23}
}

func (x *ContainerStartedEvent) GetActionId() int32 {
	if x != nil {
		return x.ActionId
	}
	return 0
}

func (x *ContainerStartedEvent) GetPortMappings() map[int32]int32 {
	if x != nil {
		return x.PortMappings
	}
	return nil
}

func (x *ContainerStartedEvent) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

// An event generated when a container exits.
type ContainerStoppedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The numeric ID of the action that started this container.
	ActionId int32 `protobuf:"varint,1,opt,name=action_id,json=actionId,proto3" json:"action_id,omitempty"`
	// The exit status of the container.
	ExitStatus int32 `protobuf:"varint,2,opt,name=exit_status,json=exitStatus,proto3" json:"exit_status,omitempty"`
	// The tail end of any content written to standard error by the container.
	// If the content emits large amounts of debugging noise or contains
	// sensitive information, you can prevent the content from being printed by
	// setting the `DISABLE_STANDARD_ERROR_CAPTURE` flag.
	//
	// Note that only a small amount of the end of the stream is captured here.
	// The entire stream is stored in the `/google/logs` directory mounted into
	// each action, and can be copied off the machine as described elsewhere.
	Stderr string `protobuf:"bytes,3,opt,name=stderr,proto3" json:"stderr,omitempty"`
}

func (x *ContainerStoppedEvent) Reset() {
	*x = ContainerStoppedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContainerStoppedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerStoppedEvent) ProtoMessage() {}

func (x *ContainerStoppedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerStoppedEvent.ProtoReflect.Descriptor instead.
func (*ContainerStoppedEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{24}
}

func (x *ContainerStoppedEvent) GetActionId() int32 {
	if x != nil {
		return x.ActionId
	}
	return 0
}

func (x *ContainerStoppedEvent) GetExitStatus() int32 {
	if x != nil {
		return x.ExitStatus
	}
	return 0
}

func (x *ContainerStoppedEvent) GetStderr() string {
	if x != nil {
		return x.Stderr
	}
	return ""
}

// An event generated when the execution of a container results in a
// non-zero exit status that was not otherwise ignored. Execution will
// continue, but only actions that are flagged as `ALWAYS_RUN` will be
// executed. Other actions will be skipped.
type UnexpectedExitStatusEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The numeric ID of the action that started the container.
	ActionId int32 `protobuf:"varint,1,opt,name=action_id,json=actionId,proto3" json:"action_id,omitempty"`
	// The exit status of the container.
	ExitStatus int32 `protobuf:"varint,2,opt,name=exit_status,json=exitStatus,proto3" json:"exit_status,omitempty"`
}

func (x *UnexpectedExitStatusEvent) Reset() {
	*x = UnexpectedExitStatusEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnexpectedExitStatusEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnexpectedExitStatusEvent) ProtoMessage() {}

func (x *UnexpectedExitStatusEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnexpectedExitStatusEvent.ProtoReflect.Descriptor instead.
func (*UnexpectedExitStatusEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{25}
}

func (x *UnexpectedExitStatusEvent) GetActionId() int32 {
	if x != nil {
		return x.ActionId
	}
	return 0
}

func (x *UnexpectedExitStatusEvent) GetExitStatus() int32 {
	if x != nil {
		return x.ExitStatus
	}
	return 0
}

// An event generated when a container is forcibly terminated by the
// worker. Currently, this only occurs when the container outlives the
// timeout specified by the user.
type ContainerKilledEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The numeric ID of the action that started the container.
	ActionId int32 `protobuf:"varint,1,opt,name=action_id,json=actionId,proto3" json:"action_id,omitempty"`
}

func (x *ContainerKilledEvent) Reset() {
	*x = ContainerKilledEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContainerKilledEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerKilledEvent) ProtoMessage() {}

func (x *ContainerKilledEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerKilledEvent.ProtoReflect.Descriptor instead.
func (*ContainerKilledEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{26}
}

func (x *ContainerKilledEvent) GetActionId() int32 {
	if x != nil {
		return x.ActionId
	}
	return 0
}

// An event generated when the execution of a pipeline has failed. Note
// that other events can continue to occur after this event.
type FailedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Google standard error code that best describes this failure.
	Code code.Code `protobuf:"varint,1,opt,name=code,proto3,enum=google.rpc.Code" json:"code,omitempty"`
	// The human-readable description of the cause of the failure.
	Cause string `protobuf:"bytes,2,opt,name=cause,proto3" json:"cause,omitempty"`
}

func (x *FailedEvent) Reset() {
	*x = FailedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FailedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FailedEvent) ProtoMessage() {}

func (x *FailedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FailedEvent.ProtoReflect.Descriptor instead.
func (*FailedEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP(), []int{27}
}

func (x *FailedEvent) GetCode() code.Code {
	if x != nil {
		return x.Code
	}
	return code.Code(0)
}

func (x *FailedEvent) GetCause() string {
	if x != nil {
		return x.Cause
	}
	return ""
}

var File_google_cloud_lifesciences_v2beta_workflows_proto protoreflect.FileDescriptor

var file_google_cloud_lifesciences_v2beta_workflows_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6c,
	0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x63,
	0x6f, 0x64, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb2, 0x02, 0x0a, 0x12, 0x52, 0x75,
	0x6e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4b, 0x0a, 0x08, 0x70, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65, 0x73, 0x63,
	0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x70, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x58, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65,
	0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x75, 0x6e, 0x50, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12,
	0x22, 0x0a, 0x0d, 0x70, 0x75, 0x62, 0x5f, 0x73, 0x75, 0x62, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x75, 0x62, 0x53, 0x75, 0x62, 0x54, 0x6f,
	0x70, 0x69, 0x63, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x15,
	0x0a, 0x13, 0x52, 0x75, 0x6e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xcc, 0x03, 0x0a, 0x08, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x12, 0x42, 0x0a, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x49, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69,
	0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x12, 0x5d, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63,
	0x65, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x5d, 0x0a, 0x15, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x6e,
	0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c,
	0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x14, 0x65, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x65, 0x64, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x33, 0x0a, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x74, 0x69, 0x6d,
	0x65, 0x6f, 0x75, 0x74, 0x1a, 0x3e, 0x0a, 0x10, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x9a, 0x0a, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x55, 0x72, 0x69, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x12, 0x5b, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69,
	0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x5d, 0x0a, 0x15, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x5f, 0x65,
	0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x14, 0x65, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x65, 0x64, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x23, 0x0a, 0x0d, 0x70, 0x69, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x69, 0x64, 0x4e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x5f, 0x0a, 0x0d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6d, 0x61,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65,
	0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x6f, 0x72, 0x74, 0x4d, 0x61, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0c, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x61,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3f, 0x0a, 0x06, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63,
	0x65, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x52,
	0x06, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x4c, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x4a, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x61, 0x6c, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65, 0x73, 0x63,
	0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x52, 0x0b, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c,
	0x73, 0x12, 0x33, 0x0a, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x74,
	0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x2c, 0x0a, 0x12, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65,
	0x5f, 0x65, 0x78, 0x69, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x10, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x45, 0x78, 0x69, 0x74, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x72, 0x75, 0x6e, 0x5f, 0x69, 0x6e, 0x5f, 0x62,
	0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0f, 0x72, 0x75, 0x6e, 0x49, 0x6e, 0x42, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64,
	0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x6c, 0x77, 0x61, 0x79, 0x73, 0x5f, 0x72, 0x75, 0x6e, 0x18, 0x0f,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x61, 0x6c, 0x77, 0x61, 0x79, 0x73, 0x52, 0x75, 0x6e, 0x12,
	0x1f, 0x0a, 0x0b, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x66, 0x75, 0x73, 0x65, 0x18, 0x10,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x75, 0x73, 0x65,
	0x12, 0x32, 0x0a, 0x15, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x5f, 0x65, 0x78, 0x70, 0x6f,
	0x73, 0x65, 0x64, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x13, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x45, 0x78, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x50,
	0x6f, 0x72, 0x74, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x74, 0x63, 0x68, 0x18, 0x12,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x50, 0x72, 0x65, 0x66, 0x65, 0x74, 0x63, 0x68, 0x12, 0x43, 0x0a, 0x1e, 0x64, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x5f, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x61, 0x70, 0x74, 0x75, 0x72, 0x65, 0x18, 0x13, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x1b, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x6e, 0x64,
	0x61, 0x72, 0x64, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x61, 0x70, 0x74, 0x75, 0x72, 0x65, 0x12,
	0x34, 0x0a, 0x16, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x14, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x14, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x1a, 0x3e, 0x0a, 0x10, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3f, 0x0a, 0x11, 0x50, 0x6f, 0x72, 0x74, 0x4d, 0x61, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0x44, 0x0a, 0x06, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x6b,
	0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6b,
	0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72,
	0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x69, 0x70,
	0x68, 0x65, 0x72, 0x54, 0x65, 0x78, 0x74, 0x22, 0x4c, 0x0a, 0x05, 0x4d, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x12, 0x0a, 0x04, 0x64, 0x69, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x64, 0x69, 0x73, 0x6b, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64,
	0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x72, 0x65, 0x61,
	0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x96, 0x01, 0x0a, 0x09, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x14, 0x0a,
	0x05, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x7a, 0x6f,
	0x6e, 0x65, 0x73, 0x12, 0x59, 0x0a, 0x0f, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x5f, 0x6d,
	0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65,
	0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x52, 0x0e,
	0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x22, 0x9b,
	0x07, 0x0a, 0x0e, 0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e,
	0x65, 0x12, 0x26, 0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6d, 0x61,
	0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x70, 0x72, 0x65,
	0x65, 0x6d, 0x70, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b,
	0x70, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x12, 0x54, 0x0a, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65, 0x73,
	0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x56,
	0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x2e, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x12, 0x3c, 0x0a, 0x05, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x52, 0x05, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x12,
	0x43, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x12, 0x51, 0x0a, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65, 0x73, 0x63,
	0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x63,
	0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x6c,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x59, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x29, 0x0a, 0x11, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x62,
	0x6f, 0x6f, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x21, 0x0a,
	0x0c, 0x63, 0x70, 0x75, 0x5f, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x70, 0x75, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x12, 0x1d, 0x0a, 0x0a, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x62, 0x6f, 0x6f, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12,
	0x36, 0x0a, 0x15, 0x6e, 0x76, 0x69, 0x64, 0x69, 0x61, 0x5f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x13, 0x6e, 0x76, 0x69, 0x64, 0x69, 0x61, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x1d, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x5f, 0x6d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1b,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x64, 0x72, 0x69, 0x76, 0x65,
	0x72, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x2e, 0x0a, 0x13, 0x64,
	0x6f, 0x63, 0x6b, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x64, 0x6f, 0x63, 0x6b, 0x65, 0x72,
	0x43, 0x61, 0x63, 0x68, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x12, 0x42, 0x0a, 0x07, 0x76,
	0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65,
	0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x07, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x12,
	0x20, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0f,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x3e, 0x0a, 0x0e,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x14,
	0x0a, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65,
	0x6d, 0x61, 0x69, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x22, 0x37, 0x0a, 0x0b,
	0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x14, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x73, 0x0a, 0x07, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x12, 0x18, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x2e, 0x0a, 0x13, 0x75, 0x73,
	0x65, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x75, 0x73, 0x65, 0x50, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x75,
	0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x22, 0x6a, 0x0a, 0x04, 0x44, 0x69,
	0x73, 0x6b, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67,
	0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x73, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12,
	0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x6d,
	0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x22, 0xaa, 0x02, 0x0a, 0x06, 0x56, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x12, 0x16, 0x0a, 0x06, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x12, 0x5b, 0x0a, 0x0f, 0x70, 0x65, 0x72,
	0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74,
	0x44, 0x69, 0x73, 0x6b, 0x48, 0x00, 0x52, 0x0e, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65,
	0x6e, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x12, 0x55, 0x0a, 0x0d, 0x65, 0x78, 0x69, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x69, 0x66,
	0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x45, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x44, 0x69, 0x73, 0x6b, 0x48, 0x00, 0x52,
	0x0c, 0x65, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x44, 0x69, 0x73, 0x6b, 0x12, 0x49, 0x0a,
	0x09, 0x6e, 0x66, 0x73, 0x5f, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x4e, 0x46, 0x53, 0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x08,
	0x6e, 0x66, 0x73, 0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x09, 0x0a, 0x07, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x22, 0x60, 0x0a, 0x0e, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e,
	0x74, 0x44, 0x69, 0x73, 0x6b, 0x12, 0x17, 0x0a, 0x07, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x73, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x12,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x22, 0x22, 0x0a, 0x0c, 0x45, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x44, 0x69, 0x73, 0x6b, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x69, 0x73, 0x6b, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x64, 0x69, 0x73, 0x6b, 0x22, 0x22, 0x0a, 0x08, 0x4e, 0x46, 0x53,
	0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0xf1, 0x03,
	0x0a, 0x08, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x46, 0x0a, 0x08, 0x70, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65,
	0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x08, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x12, 0x4e, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x3f, 0x0a, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65,
	0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0d, 0x70, 0x75, 0x62, 0x5f, 0x73, 0x75, 0x62, 0x5f, 0x74, 0x6f,
	0x70, 0x69, 0x63, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x75, 0x62, 0x53, 0x75,
	0x62, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0xa3, 0x08, 0x0a, 0x05, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x38, 0x0a, 0x09, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4a, 0x0a, 0x07, 0x64, 0x65, 0x6c, 0x61, 0x79,
	0x65, 0x64, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65,
	0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x61,
	0x79, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x07, 0x64, 0x65, 0x6c, 0x61,
	0x79, 0x65, 0x64, 0x12, 0x60, 0x0a, 0x0f, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x61, 0x73,
	0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65,
	0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x41, 0x73, 0x73,
	0x69, 0x67, 0x6e, 0x65, 0x64, 0x12, 0x60, 0x0a, 0x0f, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f,
	0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x64, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x69,
	0x66, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x64,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x52,
	0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x64, 0x12, 0x57, 0x0a, 0x0c, 0x70, 0x75, 0x6c, 0x6c, 0x5f,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x69, 0x66,
	0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x50, 0x75, 0x6c, 0x6c, 0x53, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x48, 0x00, 0x52, 0x0b, 0x70, 0x75, 0x6c, 0x6c, 0x53, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64,
	0x12, 0x57, 0x0a, 0x0c, 0x70, 0x75, 0x6c, 0x6c, 0x5f, 0x73, 0x74, 0x6f, 0x70, 0x70, 0x65, 0x64,
	0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63,
	0x65, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x75, 0x6c, 0x6c, 0x53, 0x74,
	0x6f, 0x70, 0x70, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x70, 0x75,
	0x6c, 0x6c, 0x53, 0x74, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x12, 0x66, 0x0a, 0x11, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x18, 0x16,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x53, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52,
	0x10, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x72, 0x74, 0x65,
	0x64, 0x12, 0x66, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x73,
	0x74, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65,
	0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x6f, 0x70, 0x70, 0x65, 0x64,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x53, 0x74, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x12, 0x63, 0x0a, 0x10, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x6b, 0x69, 0x6c, 0x6c, 0x65, 0x64, 0x18, 0x18, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x4b, 0x69, 0x6c, 0x6c, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0f, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x4b, 0x69, 0x6c, 0x6c, 0x65, 0x64, 0x12, 0x73,
	0x0a, 0x16, 0x75, 0x6e, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x78, 0x69,
	0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x69,
	0x66, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x55, 0x6e, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x45, 0x78, 0x69, 0x74,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x14, 0x75,
	0x6e, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x45, 0x78, 0x69, 0x74, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x47, 0x0a, 0x06, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x18, 0x1a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x48, 0x00, 0x52, 0x06, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x42, 0x09, 0x0a, 0x07,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x3e, 0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x61, 0x79,
	0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x61, 0x75, 0x73, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x63, 0x61, 0x75, 0x73, 0x65, 0x12, 0x18, 0x0a,
	0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x22, 0x68, 0x0a, 0x13, 0x57, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x7a, 0x6f,
	0x6e, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x21,
	0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x22, 0x45, 0x0a, 0x13, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x52, 0x65, 0x6c, 0x65, 0x61,
	0x73, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x1a, 0x0a, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x2f, 0x0a, 0x10, 0x50, 0x75, 0x6c, 0x6c,
	0x53, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x55, 0x72, 0x69, 0x22, 0x2f, 0x0a, 0x10, 0x50, 0x75, 0x6c,
	0x6c, 0x53, 0x74, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x55, 0x72, 0x69, 0x22, 0x84, 0x02, 0x0a, 0x15, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x12, 0x6e, 0x0a, 0x0d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65,
	0x6e, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x2e, 0x50, 0x6f, 0x72, 0x74, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x0c, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x1a, 0x3f, 0x0a, 0x11, 0x50, 0x6f, 0x72, 0x74, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0x6d, 0x0a, 0x15, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74,
	0x6f, 0x70, 0x70, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x78, 0x69, 0x74, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x65, 0x78,
	0x69, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x64, 0x65,
	0x72, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x74, 0x64, 0x65, 0x72, 0x72,
	0x22, 0x59, 0x0a, 0x19, 0x55, 0x6e, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x45, 0x78,
	0x69, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x78,
	0x69, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0a, 0x65, 0x78, 0x69, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x33, 0x0a, 0x14, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x4b, 0x69, 0x6c, 0x6c, 0x65, 0x64, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x22, 0x49, 0x0a, 0x0b, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12,
	0x24, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x52,
	0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x61, 0x75, 0x73, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x63, 0x61, 0x75, 0x73, 0x65, 0x32, 0xb2, 0x02, 0x0a, 0x16,
	0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x56, 0x32, 0x42, 0x65, 0x74, 0x61, 0x12, 0xc6, 0x01, 0x0a, 0x0b, 0x52, 0x75, 0x6e, 0x50, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63,
	0x65, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x75, 0x6e, 0x50, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x62, 0xca, 0x41, 0x1f,
	0x0a, 0x13, 0x52, 0x75, 0x6e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x08, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x3a, 0x01, 0x2a, 0x22, 0x35, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x3a, 0x72, 0x75, 0x6e, 0x1a,
	0x4f, 0xca, 0x41, 0x1b, 0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2,
	0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x42, 0xf5, 0x01, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63,
	0x65, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x42, 0x0e, 0x57, 0x6f, 0x72, 0x6b, 0x66,
	0x6c, 0x6f, 0x77, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x48, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f,
	0x2f, 0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65,
	0x6e, 0x63, 0x65, 0x73, 0x70, 0x62, 0x3b, 0x6c, 0x69, 0x66, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x70, 0x62, 0xa2, 0x02, 0x04, 0x43, 0x4c, 0x53, 0x57, 0xaa, 0x02, 0x20, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4c, 0x69, 0x66, 0x65,
	0x53, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x56, 0x32, 0x42, 0x65, 0x74, 0x61, 0xca,
	0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4c,
	0x69, 0x66, 0x65, 0x53, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x5c, 0x56, 0x32, 0x62, 0x65,
	0x74, 0x61, 0xea, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x4c, 0x69, 0x66, 0x65, 0x53, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73,
	0x3a, 0x3a, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescOnce sync.Once
	file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescData = file_google_cloud_lifesciences_v2beta_workflows_proto_rawDesc
)

func file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescGZIP() []byte {
	file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescOnce.Do(func() {
		file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescData)
	})
	return file_google_cloud_lifesciences_v2beta_workflows_proto_rawDescData
}

var file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes = make([]protoimpl.MessageInfo, 36)
var file_google_cloud_lifesciences_v2beta_workflows_proto_goTypes = []interface{}{
	(*RunPipelineRequest)(nil),        // 0: google.cloud.lifesciences.v2beta.RunPipelineRequest
	(*RunPipelineResponse)(nil),       // 1: google.cloud.lifesciences.v2beta.RunPipelineResponse
	(*Pipeline)(nil),                  // 2: google.cloud.lifesciences.v2beta.Pipeline
	(*Action)(nil),                    // 3: google.cloud.lifesciences.v2beta.Action
	(*Secret)(nil),                    // 4: google.cloud.lifesciences.v2beta.Secret
	(*Mount)(nil),                     // 5: google.cloud.lifesciences.v2beta.Mount
	(*Resources)(nil),                 // 6: google.cloud.lifesciences.v2beta.Resources
	(*VirtualMachine)(nil),            // 7: google.cloud.lifesciences.v2beta.VirtualMachine
	(*ServiceAccount)(nil),            // 8: google.cloud.lifesciences.v2beta.ServiceAccount
	(*Accelerator)(nil),               // 9: google.cloud.lifesciences.v2beta.Accelerator
	(*Network)(nil),                   // 10: google.cloud.lifesciences.v2beta.Network
	(*Disk)(nil),                      // 11: google.cloud.lifesciences.v2beta.Disk
	(*Volume)(nil),                    // 12: google.cloud.lifesciences.v2beta.Volume
	(*PersistentDisk)(nil),            // 13: google.cloud.lifesciences.v2beta.PersistentDisk
	(*ExistingDisk)(nil),              // 14: google.cloud.lifesciences.v2beta.ExistingDisk
	(*NFSMount)(nil),                  // 15: google.cloud.lifesciences.v2beta.NFSMount
	(*Metadata)(nil),                  // 16: google.cloud.lifesciences.v2beta.Metadata
	(*Event)(nil),                     // 17: google.cloud.lifesciences.v2beta.Event
	(*DelayedEvent)(nil),              // 18: google.cloud.lifesciences.v2beta.DelayedEvent
	(*WorkerAssignedEvent)(nil),       // 19: google.cloud.lifesciences.v2beta.WorkerAssignedEvent
	(*WorkerReleasedEvent)(nil),       // 20: google.cloud.lifesciences.v2beta.WorkerReleasedEvent
	(*PullStartedEvent)(nil),          // 21: google.cloud.lifesciences.v2beta.PullStartedEvent
	(*PullStoppedEvent)(nil),          // 22: google.cloud.lifesciences.v2beta.PullStoppedEvent
	(*ContainerStartedEvent)(nil),     // 23: google.cloud.lifesciences.v2beta.ContainerStartedEvent
	(*ContainerStoppedEvent)(nil),     // 24: google.cloud.lifesciences.v2beta.ContainerStoppedEvent
	(*UnexpectedExitStatusEvent)(nil), // 25: google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent
	(*ContainerKilledEvent)(nil),      // 26: google.cloud.lifesciences.v2beta.ContainerKilledEvent
	(*FailedEvent)(nil),               // 27: google.cloud.lifesciences.v2beta.FailedEvent
	nil,                               // 28: google.cloud.lifesciences.v2beta.RunPipelineRequest.LabelsEntry
	nil,                               // 29: google.cloud.lifesciences.v2beta.Pipeline.EnvironmentEntry
	nil,                               // 30: google.cloud.lifesciences.v2beta.Action.EnvironmentEntry
	nil,                               // 31: google.cloud.lifesciences.v2beta.Action.PortMappingsEntry
	nil,                               // 32: google.cloud.lifesciences.v2beta.Action.LabelsEntry
	nil,                               // 33: google.cloud.lifesciences.v2beta.VirtualMachine.LabelsEntry
	nil,                               // 34: google.cloud.lifesciences.v2beta.Metadata.LabelsEntry
	nil,                               // 35: google.cloud.lifesciences.v2beta.ContainerStartedEvent.PortMappingsEntry
	(*durationpb.Duration)(nil),       // 36: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),     // 37: google.protobuf.Timestamp
	(code.Code)(0),                    // 38: google.rpc.Code
	(*longrunningpb.Operation)(nil),   // 39: google.longrunning.Operation
}
var file_google_cloud_lifesciences_v2beta_workflows_proto_depIdxs = []int32{
	2,  // 0: google.cloud.lifesciences.v2beta.RunPipelineRequest.pipeline:type_name -> google.cloud.lifesciences.v2beta.Pipeline
	28, // 1: google.cloud.lifesciences.v2beta.RunPipelineRequest.labels:type_name -> google.cloud.lifesciences.v2beta.RunPipelineRequest.LabelsEntry
	3,  // 2: google.cloud.lifesciences.v2beta.Pipeline.actions:type_name -> google.cloud.lifesciences.v2beta.Action
	6,  // 3: google.cloud.lifesciences.v2beta.Pipeline.resources:type_name -> google.cloud.lifesciences.v2beta.Resources
	29, // 4: google.cloud.lifesciences.v2beta.Pipeline.environment:type_name -> google.cloud.lifesciences.v2beta.Pipeline.EnvironmentEntry
	4,  // 5: google.cloud.lifesciences.v2beta.Pipeline.encrypted_environment:type_name -> google.cloud.lifesciences.v2beta.Secret
	36, // 6: google.cloud.lifesciences.v2beta.Pipeline.timeout:type_name -> google.protobuf.Duration
	30, // 7: google.cloud.lifesciences.v2beta.Action.environment:type_name -> google.cloud.lifesciences.v2beta.Action.EnvironmentEntry
	4,  // 8: google.cloud.lifesciences.v2beta.Action.encrypted_environment:type_name -> google.cloud.lifesciences.v2beta.Secret
	31, // 9: google.cloud.lifesciences.v2beta.Action.port_mappings:type_name -> google.cloud.lifesciences.v2beta.Action.PortMappingsEntry
	5,  // 10: google.cloud.lifesciences.v2beta.Action.mounts:type_name -> google.cloud.lifesciences.v2beta.Mount
	32, // 11: google.cloud.lifesciences.v2beta.Action.labels:type_name -> google.cloud.lifesciences.v2beta.Action.LabelsEntry
	4,  // 12: google.cloud.lifesciences.v2beta.Action.credentials:type_name -> google.cloud.lifesciences.v2beta.Secret
	36, // 13: google.cloud.lifesciences.v2beta.Action.timeout:type_name -> google.protobuf.Duration
	7,  // 14: google.cloud.lifesciences.v2beta.Resources.virtual_machine:type_name -> google.cloud.lifesciences.v2beta.VirtualMachine
	33, // 15: google.cloud.lifesciences.v2beta.VirtualMachine.labels:type_name -> google.cloud.lifesciences.v2beta.VirtualMachine.LabelsEntry
	11, // 16: google.cloud.lifesciences.v2beta.VirtualMachine.disks:type_name -> google.cloud.lifesciences.v2beta.Disk
	10, // 17: google.cloud.lifesciences.v2beta.VirtualMachine.network:type_name -> google.cloud.lifesciences.v2beta.Network
	9,  // 18: google.cloud.lifesciences.v2beta.VirtualMachine.accelerators:type_name -> google.cloud.lifesciences.v2beta.Accelerator
	8,  // 19: google.cloud.lifesciences.v2beta.VirtualMachine.service_account:type_name -> google.cloud.lifesciences.v2beta.ServiceAccount
	12, // 20: google.cloud.lifesciences.v2beta.VirtualMachine.volumes:type_name -> google.cloud.lifesciences.v2beta.Volume
	13, // 21: google.cloud.lifesciences.v2beta.Volume.persistent_disk:type_name -> google.cloud.lifesciences.v2beta.PersistentDisk
	14, // 22: google.cloud.lifesciences.v2beta.Volume.existing_disk:type_name -> google.cloud.lifesciences.v2beta.ExistingDisk
	15, // 23: google.cloud.lifesciences.v2beta.Volume.nfs_mount:type_name -> google.cloud.lifesciences.v2beta.NFSMount
	2,  // 24: google.cloud.lifesciences.v2beta.Metadata.pipeline:type_name -> google.cloud.lifesciences.v2beta.Pipeline
	34, // 25: google.cloud.lifesciences.v2beta.Metadata.labels:type_name -> google.cloud.lifesciences.v2beta.Metadata.LabelsEntry
	17, // 26: google.cloud.lifesciences.v2beta.Metadata.events:type_name -> google.cloud.lifesciences.v2beta.Event
	37, // 27: google.cloud.lifesciences.v2beta.Metadata.create_time:type_name -> google.protobuf.Timestamp
	37, // 28: google.cloud.lifesciences.v2beta.Metadata.start_time:type_name -> google.protobuf.Timestamp
	37, // 29: google.cloud.lifesciences.v2beta.Metadata.end_time:type_name -> google.protobuf.Timestamp
	37, // 30: google.cloud.lifesciences.v2beta.Event.timestamp:type_name -> google.protobuf.Timestamp
	18, // 31: google.cloud.lifesciences.v2beta.Event.delayed:type_name -> google.cloud.lifesciences.v2beta.DelayedEvent
	19, // 32: google.cloud.lifesciences.v2beta.Event.worker_assigned:type_name -> google.cloud.lifesciences.v2beta.WorkerAssignedEvent
	20, // 33: google.cloud.lifesciences.v2beta.Event.worker_released:type_name -> google.cloud.lifesciences.v2beta.WorkerReleasedEvent
	21, // 34: google.cloud.lifesciences.v2beta.Event.pull_started:type_name -> google.cloud.lifesciences.v2beta.PullStartedEvent
	22, // 35: google.cloud.lifesciences.v2beta.Event.pull_stopped:type_name -> google.cloud.lifesciences.v2beta.PullStoppedEvent
	23, // 36: google.cloud.lifesciences.v2beta.Event.container_started:type_name -> google.cloud.lifesciences.v2beta.ContainerStartedEvent
	24, // 37: google.cloud.lifesciences.v2beta.Event.container_stopped:type_name -> google.cloud.lifesciences.v2beta.ContainerStoppedEvent
	26, // 38: google.cloud.lifesciences.v2beta.Event.container_killed:type_name -> google.cloud.lifesciences.v2beta.ContainerKilledEvent
	25, // 39: google.cloud.lifesciences.v2beta.Event.unexpected_exit_status:type_name -> google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent
	27, // 40: google.cloud.lifesciences.v2beta.Event.failed:type_name -> google.cloud.lifesciences.v2beta.FailedEvent
	35, // 41: google.cloud.lifesciences.v2beta.ContainerStartedEvent.port_mappings:type_name -> google.cloud.lifesciences.v2beta.ContainerStartedEvent.PortMappingsEntry
	38, // 42: google.cloud.lifesciences.v2beta.FailedEvent.code:type_name -> google.rpc.Code
	0,  // 43: google.cloud.lifesciences.v2beta.WorkflowsServiceV2Beta.RunPipeline:input_type -> google.cloud.lifesciences.v2beta.RunPipelineRequest
	39, // 44: google.cloud.lifesciences.v2beta.WorkflowsServiceV2Beta.RunPipeline:output_type -> google.longrunning.Operation
	44, // [44:45] is the sub-list for method output_type
	43, // [43:44] is the sub-list for method input_type
	43, // [43:43] is the sub-list for extension type_name
	43, // [43:43] is the sub-list for extension extendee
	0,  // [0:43] is the sub-list for field type_name
}

func init() { file_google_cloud_lifesciences_v2beta_workflows_proto_init() }
func file_google_cloud_lifesciences_v2beta_workflows_proto_init() {
	if File_google_cloud_lifesciences_v2beta_workflows_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunPipelineRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunPipelineResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Pipeline); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Secret); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Mount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Resources); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VirtualMachine); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceAccount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Accelerator); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Network); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Disk); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Volume); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PersistentDisk); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExistingDisk); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NFSMount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Metadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Event); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DelayedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkerAssignedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkerReleasedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PullStartedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PullStoppedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContainerStartedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContainerStoppedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UnexpectedExitStatusEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContainerKilledEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FailedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*Volume_PersistentDisk)(nil),
		(*Volume_ExistingDisk)(nil),
		(*Volume_NfsMount)(nil),
	}
	file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes[17].OneofWrappers = []interface{}{
		(*Event_Delayed)(nil),
		(*Event_WorkerAssigned)(nil),
		(*Event_WorkerReleased)(nil),
		(*Event_PullStarted)(nil),
		(*Event_PullStopped)(nil),
		(*Event_ContainerStarted)(nil),
		(*Event_ContainerStopped)(nil),
		(*Event_ContainerKilled)(nil),
		(*Event_UnexpectedExitStatus)(nil),
		(*Event_Failed)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_lifesciences_v2beta_workflows_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   36,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_lifesciences_v2beta_workflows_proto_goTypes,
		DependencyIndexes: file_google_cloud_lifesciences_v2beta_workflows_proto_depIdxs,
		MessageInfos:      file_google_cloud_lifesciences_v2beta_workflows_proto_msgTypes,
	}.Build()
	File_google_cloud_lifesciences_v2beta_workflows_proto = out.File
	file_google_cloud_lifesciences_v2beta_workflows_proto_rawDesc = nil
	file_google_cloud_lifesciences_v2beta_workflows_proto_goTypes = nil
	file_google_cloud_lifesciences_v2beta_workflows_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// WorkflowsServiceV2BetaClient is the client API for WorkflowsServiceV2Beta service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type WorkflowsServiceV2BetaClient interface {
	// Runs a pipeline.  The returned Operation's [metadata]
	// [google.longrunning.Operation.metadata] field will contain a
	// [google.cloud.lifesciences.v2beta.Metadata][google.cloud.lifesciences.v2beta.Metadata]
	// object describing the status of the pipeline execution. The
	// [response][google.longrunning.Operation.response] field will contain a
	// [google.cloud.lifesciences.v2beta.RunPipelineResponse][google.cloud.lifesciences.v2beta.RunPipelineResponse]
	// object if the pipeline completes successfully.
	//
	// **Note:** Before you can use this method, the *Life Sciences Service Agent*
	// must have access to your project. This is done automatically when the
	// Cloud Life Sciences API is first enabled, but if you delete this permission
	// you must disable and re-enable the API to grant the Life Sciences
	// Service Agent the required permissions.
	// Authorization requires the following [Google
	// IAM](https://cloud.google.com/iam/) permission:
	//
	// * `lifesciences.workflows.run`
	RunPipeline(ctx context.Context, in *RunPipelineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type workflowsServiceV2BetaClient struct {
	cc grpc.ClientConnInterface
}

func NewWorkflowsServiceV2BetaClient(cc grpc.ClientConnInterface) WorkflowsServiceV2BetaClient {
	return &workflowsServiceV2BetaClient{cc}
}

func (c *workflowsServiceV2BetaClient) RunPipeline(ctx context.Context, in *RunPipelineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.lifesciences.v2beta.WorkflowsServiceV2Beta/RunPipeline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// WorkflowsServiceV2BetaServer is the server API for WorkflowsServiceV2Beta service.
type WorkflowsServiceV2BetaServer interface {
	// Runs a pipeline.  The returned Operation's [metadata]
	// [google.longrunning.Operation.metadata] field will contain a
	// [google.cloud.lifesciences.v2beta.Metadata][google.cloud.lifesciences.v2beta.Metadata]
	// object describing the status of the pipeline execution. The
	// [response][google.longrunning.Operation.response] field will contain a
	// [google.cloud.lifesciences.v2beta.RunPipelineResponse][google.cloud.lifesciences.v2beta.RunPipelineResponse]
	// object if the pipeline completes successfully.
	//
	// **Note:** Before you can use this method, the *Life Sciences Service Agent*
	// must have access to your project. This is done automatically when the
	// Cloud Life Sciences API is first enabled, but if you delete this permission
	// you must disable and re-enable the API to grant the Life Sciences
	// Service Agent the required permissions.
	// Authorization requires the following [Google
	// IAM](https://cloud.google.com/iam/) permission:
	//
	// * `lifesciences.workflows.run`
	RunPipeline(context.Context, *RunPipelineRequest) (*longrunningpb.Operation, error)
}

// UnimplementedWorkflowsServiceV2BetaServer can be embedded to have forward compatible implementations.
type UnimplementedWorkflowsServiceV2BetaServer struct {
}

func (*UnimplementedWorkflowsServiceV2BetaServer) RunPipeline(context.Context, *RunPipelineRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunPipeline not implemented")
}

func RegisterWorkflowsServiceV2BetaServer(s *grpc.Server, srv WorkflowsServiceV2BetaServer) {
	s.RegisterService(&_WorkflowsServiceV2Beta_serviceDesc, srv)
}

func _WorkflowsServiceV2Beta_RunPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkflowsServiceV2BetaServer).RunPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.lifesciences.v2beta.WorkflowsServiceV2Beta/RunPipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkflowsServiceV2BetaServer).RunPipeline(ctx, req.(*RunPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _WorkflowsServiceV2Beta_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.lifesciences.v2beta.WorkflowsServiceV2Beta",
	HandlerType: (*WorkflowsServiceV2BetaServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RunPipeline",
			Handler:    _WorkflowsServiceV2Beta_RunPipeline_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/lifesciences/v2beta/workflows.proto",
}
