// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package gkemulticloud

import (
	"context"
	"fmt"
	"math"
	"net/url"
	"time"

	gkemulticloudpb "cloud.google.com/go/gkemulticloud/apiv1/gkemulticloudpb"
	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/proto"
)

var newAttachedClustersClientHook clientHook

// AttachedClustersCallOptions contains the retry settings for each method of AttachedClustersClient.
type AttachedClustersCallOptions struct {
	CreateAttachedCluster                  []gax.CallOption
	UpdateAttachedCluster                  []gax.CallOption
	ImportAttachedCluster                  []gax.CallOption
	GetAttachedCluster                     []gax.CallOption
	ListAttachedClusters                   []gax.CallOption
	DeleteAttachedCluster                  []gax.CallOption
	GetAttachedServerConfig                []gax.CallOption
	GenerateAttachedClusterInstallManifest []gax.CallOption
	CancelOperation                        []gax.CallOption
	DeleteOperation                        []gax.CallOption
	GetOperation                           []gax.CallOption
	ListOperations                         []gax.CallOption
}

func defaultAttachedClustersGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("gkemulticloud.googleapis.com:443"),
		internaloption.WithDefaultMTLSEndpoint("gkemulticloud.mtls.googleapis.com:443"),
		internaloption.WithDefaultAudience("https://gkemulticloud.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultAttachedClustersCallOptions() *AttachedClustersCallOptions {
	return &AttachedClustersCallOptions{
		CreateAttachedCluster: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateAttachedCluster: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ImportAttachedCluster: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetAttachedCluster: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListAttachedClusters: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteAttachedCluster: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetAttachedServerConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GenerateAttachedClusterInstallManifest: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CancelOperation: []gax.CallOption{},
		DeleteOperation: []gax.CallOption{},
		GetOperation:    []gax.CallOption{},
		ListOperations:  []gax.CallOption{},
	}
}

// internalAttachedClustersClient is an interface that defines the methods available from Anthos Multi-Cloud API.
type internalAttachedClustersClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	CreateAttachedCluster(context.Context, *gkemulticloudpb.CreateAttachedClusterRequest, ...gax.CallOption) (*CreateAttachedClusterOperation, error)
	CreateAttachedClusterOperation(name string) *CreateAttachedClusterOperation
	UpdateAttachedCluster(context.Context, *gkemulticloudpb.UpdateAttachedClusterRequest, ...gax.CallOption) (*UpdateAttachedClusterOperation, error)
	UpdateAttachedClusterOperation(name string) *UpdateAttachedClusterOperation
	ImportAttachedCluster(context.Context, *gkemulticloudpb.ImportAttachedClusterRequest, ...gax.CallOption) (*ImportAttachedClusterOperation, error)
	ImportAttachedClusterOperation(name string) *ImportAttachedClusterOperation
	GetAttachedCluster(context.Context, *gkemulticloudpb.GetAttachedClusterRequest, ...gax.CallOption) (*gkemulticloudpb.AttachedCluster, error)
	ListAttachedClusters(context.Context, *gkemulticloudpb.ListAttachedClustersRequest, ...gax.CallOption) *AttachedClusterIterator
	DeleteAttachedCluster(context.Context, *gkemulticloudpb.DeleteAttachedClusterRequest, ...gax.CallOption) (*DeleteAttachedClusterOperation, error)
	DeleteAttachedClusterOperation(name string) *DeleteAttachedClusterOperation
	GetAttachedServerConfig(context.Context, *gkemulticloudpb.GetAttachedServerConfigRequest, ...gax.CallOption) (*gkemulticloudpb.AttachedServerConfig, error)
	GenerateAttachedClusterInstallManifest(context.Context, *gkemulticloudpb.GenerateAttachedClusterInstallManifestRequest, ...gax.CallOption) (*gkemulticloudpb.GenerateAttachedClusterInstallManifestResponse, error)
	CancelOperation(context.Context, *longrunningpb.CancelOperationRequest, ...gax.CallOption) error
	DeleteOperation(context.Context, *longrunningpb.DeleteOperationRequest, ...gax.CallOption) error
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
	ListOperations(context.Context, *longrunningpb.ListOperationsRequest, ...gax.CallOption) *OperationIterator
}

// AttachedClustersClient is a client for interacting with Anthos Multi-Cloud API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// The AttachedClusters API provides a single centrally managed service
// to register and manage Anthos attached clusters that run on customer’s owned
// infrastructure.
type AttachedClustersClient struct {
	// The internal transport-dependent client.
	internalClient internalAttachedClustersClient

	// The call options for this service.
	CallOptions *AttachedClustersCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *AttachedClustersClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *AttachedClustersClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *AttachedClustersClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// CreateAttachedCluster creates a new
// AttachedCluster resource
// on a given Google Cloud Platform project and region.
//
// If successful, the response contains a newly created
// Operation resource that can be
// described to track the status of the operation.
func (c *AttachedClustersClient) CreateAttachedCluster(ctx context.Context, req *gkemulticloudpb.CreateAttachedClusterRequest, opts ...gax.CallOption) (*CreateAttachedClusterOperation, error) {
	return c.internalClient.CreateAttachedCluster(ctx, req, opts...)
}

// CreateAttachedClusterOperation returns a new CreateAttachedClusterOperation from a given name.
// The name must be that of a previously created CreateAttachedClusterOperation, possibly from a different process.
func (c *AttachedClustersClient) CreateAttachedClusterOperation(name string) *CreateAttachedClusterOperation {
	return c.internalClient.CreateAttachedClusterOperation(name)
}

// UpdateAttachedCluster updates an
// AttachedCluster.
func (c *AttachedClustersClient) UpdateAttachedCluster(ctx context.Context, req *gkemulticloudpb.UpdateAttachedClusterRequest, opts ...gax.CallOption) (*UpdateAttachedClusterOperation, error) {
	return c.internalClient.UpdateAttachedCluster(ctx, req, opts...)
}

// UpdateAttachedClusterOperation returns a new UpdateAttachedClusterOperation from a given name.
// The name must be that of a previously created UpdateAttachedClusterOperation, possibly from a different process.
func (c *AttachedClustersClient) UpdateAttachedClusterOperation(name string) *UpdateAttachedClusterOperation {
	return c.internalClient.UpdateAttachedClusterOperation(name)
}

// ImportAttachedCluster imports creates a new
// AttachedCluster resource
// by importing an existing Fleet Membership resource.
//
// Attached Clusters created before the introduction of the Anthos Multi-Cloud
// API can be imported through this method.
//
// If successful, the response contains a newly created
// Operation resource that can be
// described to track the status of the operation.
func (c *AttachedClustersClient) ImportAttachedCluster(ctx context.Context, req *gkemulticloudpb.ImportAttachedClusterRequest, opts ...gax.CallOption) (*ImportAttachedClusterOperation, error) {
	return c.internalClient.ImportAttachedCluster(ctx, req, opts...)
}

// ImportAttachedClusterOperation returns a new ImportAttachedClusterOperation from a given name.
// The name must be that of a previously created ImportAttachedClusterOperation, possibly from a different process.
func (c *AttachedClustersClient) ImportAttachedClusterOperation(name string) *ImportAttachedClusterOperation {
	return c.internalClient.ImportAttachedClusterOperation(name)
}

// GetAttachedCluster describes a specific
// AttachedCluster resource.
func (c *AttachedClustersClient) GetAttachedCluster(ctx context.Context, req *gkemulticloudpb.GetAttachedClusterRequest, opts ...gax.CallOption) (*gkemulticloudpb.AttachedCluster, error) {
	return c.internalClient.GetAttachedCluster(ctx, req, opts...)
}

// ListAttachedClusters lists all AttachedCluster
// resources on a given Google Cloud project and region.
func (c *AttachedClustersClient) ListAttachedClusters(ctx context.Context, req *gkemulticloudpb.ListAttachedClustersRequest, opts ...gax.CallOption) *AttachedClusterIterator {
	return c.internalClient.ListAttachedClusters(ctx, req, opts...)
}

// DeleteAttachedCluster deletes a specific
// AttachedCluster resource.
//
// If successful, the response contains a newly created
// Operation resource that can be
// described to track the status of the operation.
func (c *AttachedClustersClient) DeleteAttachedCluster(ctx context.Context, req *gkemulticloudpb.DeleteAttachedClusterRequest, opts ...gax.CallOption) (*DeleteAttachedClusterOperation, error) {
	return c.internalClient.DeleteAttachedCluster(ctx, req, opts...)
}

// DeleteAttachedClusterOperation returns a new DeleteAttachedClusterOperation from a given name.
// The name must be that of a previously created DeleteAttachedClusterOperation, possibly from a different process.
func (c *AttachedClustersClient) DeleteAttachedClusterOperation(name string) *DeleteAttachedClusterOperation {
	return c.internalClient.DeleteAttachedClusterOperation(name)
}

// GetAttachedServerConfig returns information, such as supported Kubernetes versions, on a given
// Google Cloud location.
func (c *AttachedClustersClient) GetAttachedServerConfig(ctx context.Context, req *gkemulticloudpb.GetAttachedServerConfigRequest, opts ...gax.CallOption) (*gkemulticloudpb.AttachedServerConfig, error) {
	return c.internalClient.GetAttachedServerConfig(ctx, req, opts...)
}

// GenerateAttachedClusterInstallManifest generates the install manifest to be installed on the target cluster.
func (c *AttachedClustersClient) GenerateAttachedClusterInstallManifest(ctx context.Context, req *gkemulticloudpb.GenerateAttachedClusterInstallManifestRequest, opts ...gax.CallOption) (*gkemulticloudpb.GenerateAttachedClusterInstallManifestResponse, error) {
	return c.internalClient.GenerateAttachedClusterInstallManifest(ctx, req, opts...)
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *AttachedClustersClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.CancelOperation(ctx, req, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *AttachedClustersClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteOperation(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *AttachedClustersClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *AttachedClustersClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	return c.internalClient.ListOperations(ctx, req, opts...)
}

// attachedClustersGRPCClient is a client for interacting with Anthos Multi-Cloud API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type attachedClustersGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing AttachedClustersClient
	CallOptions **AttachedClustersCallOptions

	// The gRPC API client.
	attachedClustersClient gkemulticloudpb.AttachedClustersClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string
}

// NewAttachedClustersClient creates a new attached clusters client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// The AttachedClusters API provides a single centrally managed service
// to register and manage Anthos attached clusters that run on customer’s owned
// infrastructure.
func NewAttachedClustersClient(ctx context.Context, opts ...option.ClientOption) (*AttachedClustersClient, error) {
	clientOpts := defaultAttachedClustersGRPCClientOptions()
	if newAttachedClustersClientHook != nil {
		hookOpts, err := newAttachedClustersClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := AttachedClustersClient{CallOptions: defaultAttachedClustersCallOptions()}

	c := &attachedClustersGRPCClient{
		connPool:               connPool,
		attachedClustersClient: gkemulticloudpb.NewAttachedClustersClient(connPool),
		CallOptions:            &client.CallOptions,
		operationsClient:       longrunningpb.NewOperationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *attachedClustersGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *attachedClustersGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{"x-goog-api-client", gax.XGoogHeader(kv...)}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *attachedClustersGRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *attachedClustersGRPCClient) CreateAttachedCluster(ctx context.Context, req *gkemulticloudpb.CreateAttachedClusterRequest, opts ...gax.CallOption) (*CreateAttachedClusterOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateAttachedCluster[0:len((*c.CallOptions).CreateAttachedCluster):len((*c.CallOptions).CreateAttachedCluster)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.attachedClustersClient.CreateAttachedCluster(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateAttachedClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *attachedClustersGRPCClient) UpdateAttachedCluster(ctx context.Context, req *gkemulticloudpb.UpdateAttachedClusterRequest, opts ...gax.CallOption) (*UpdateAttachedClusterOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "attached_cluster.name", url.QueryEscape(req.GetAttachedCluster().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateAttachedCluster[0:len((*c.CallOptions).UpdateAttachedCluster):len((*c.CallOptions).UpdateAttachedCluster)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.attachedClustersClient.UpdateAttachedCluster(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateAttachedClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *attachedClustersGRPCClient) ImportAttachedCluster(ctx context.Context, req *gkemulticloudpb.ImportAttachedClusterRequest, opts ...gax.CallOption) (*ImportAttachedClusterOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ImportAttachedCluster[0:len((*c.CallOptions).ImportAttachedCluster):len((*c.CallOptions).ImportAttachedCluster)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.attachedClustersClient.ImportAttachedCluster(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ImportAttachedClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *attachedClustersGRPCClient) GetAttachedCluster(ctx context.Context, req *gkemulticloudpb.GetAttachedClusterRequest, opts ...gax.CallOption) (*gkemulticloudpb.AttachedCluster, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetAttachedCluster[0:len((*c.CallOptions).GetAttachedCluster):len((*c.CallOptions).GetAttachedCluster)], opts...)
	var resp *gkemulticloudpb.AttachedCluster
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.attachedClustersClient.GetAttachedCluster(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *attachedClustersGRPCClient) ListAttachedClusters(ctx context.Context, req *gkemulticloudpb.ListAttachedClustersRequest, opts ...gax.CallOption) *AttachedClusterIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListAttachedClusters[0:len((*c.CallOptions).ListAttachedClusters):len((*c.CallOptions).ListAttachedClusters)], opts...)
	it := &AttachedClusterIterator{}
	req = proto.Clone(req).(*gkemulticloudpb.ListAttachedClustersRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*gkemulticloudpb.AttachedCluster, string, error) {
		resp := &gkemulticloudpb.ListAttachedClustersResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.attachedClustersClient.ListAttachedClusters(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetAttachedClusters(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *attachedClustersGRPCClient) DeleteAttachedCluster(ctx context.Context, req *gkemulticloudpb.DeleteAttachedClusterRequest, opts ...gax.CallOption) (*DeleteAttachedClusterOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteAttachedCluster[0:len((*c.CallOptions).DeleteAttachedCluster):len((*c.CallOptions).DeleteAttachedCluster)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.attachedClustersClient.DeleteAttachedCluster(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteAttachedClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *attachedClustersGRPCClient) GetAttachedServerConfig(ctx context.Context, req *gkemulticloudpb.GetAttachedServerConfigRequest, opts ...gax.CallOption) (*gkemulticloudpb.AttachedServerConfig, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetAttachedServerConfig[0:len((*c.CallOptions).GetAttachedServerConfig):len((*c.CallOptions).GetAttachedServerConfig)], opts...)
	var resp *gkemulticloudpb.AttachedServerConfig
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.attachedClustersClient.GetAttachedServerConfig(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *attachedClustersGRPCClient) GenerateAttachedClusterInstallManifest(ctx context.Context, req *gkemulticloudpb.GenerateAttachedClusterInstallManifestRequest, opts ...gax.CallOption) (*gkemulticloudpb.GenerateAttachedClusterInstallManifestResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GenerateAttachedClusterInstallManifest[0:len((*c.CallOptions).GenerateAttachedClusterInstallManifest):len((*c.CallOptions).GenerateAttachedClusterInstallManifest)], opts...)
	var resp *gkemulticloudpb.GenerateAttachedClusterInstallManifestResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.attachedClustersClient.GenerateAttachedClusterInstallManifest(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *attachedClustersGRPCClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CancelOperation[0:len((*c.CallOptions).CancelOperation):len((*c.CallOptions).CancelOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.operationsClient.CancelOperation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *attachedClustersGRPCClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteOperation[0:len((*c.CallOptions).DeleteOperation):len((*c.CallOptions).DeleteOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.operationsClient.DeleteOperation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *attachedClustersGRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.operationsClient.GetOperation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *attachedClustersGRPCClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListOperations[0:len((*c.CallOptions).ListOperations):len((*c.CallOptions).ListOperations)], opts...)
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.operationsClient.ListOperations(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateAttachedClusterOperation manages a long-running operation from CreateAttachedCluster.
type CreateAttachedClusterOperation struct {
	lro *longrunning.Operation
}

// CreateAttachedClusterOperation returns a new CreateAttachedClusterOperation from a given name.
// The name must be that of a previously created CreateAttachedClusterOperation, possibly from a different process.
func (c *attachedClustersGRPCClient) CreateAttachedClusterOperation(name string) *CreateAttachedClusterOperation {
	return &CreateAttachedClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateAttachedClusterOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*gkemulticloudpb.AttachedCluster, error) {
	var resp gkemulticloudpb.AttachedCluster
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateAttachedClusterOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*gkemulticloudpb.AttachedCluster, error) {
	var resp gkemulticloudpb.AttachedCluster
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateAttachedClusterOperation) Metadata() (*gkemulticloudpb.OperationMetadata, error) {
	var meta gkemulticloudpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateAttachedClusterOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateAttachedClusterOperation) Name() string {
	return op.lro.Name()
}

// DeleteAttachedClusterOperation manages a long-running operation from DeleteAttachedCluster.
type DeleteAttachedClusterOperation struct {
	lro *longrunning.Operation
}

// DeleteAttachedClusterOperation returns a new DeleteAttachedClusterOperation from a given name.
// The name must be that of a previously created DeleteAttachedClusterOperation, possibly from a different process.
func (c *attachedClustersGRPCClient) DeleteAttachedClusterOperation(name string) *DeleteAttachedClusterOperation {
	return &DeleteAttachedClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteAttachedClusterOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteAttachedClusterOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteAttachedClusterOperation) Metadata() (*gkemulticloudpb.OperationMetadata, error) {
	var meta gkemulticloudpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteAttachedClusterOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteAttachedClusterOperation) Name() string {
	return op.lro.Name()
}

// ImportAttachedClusterOperation manages a long-running operation from ImportAttachedCluster.
type ImportAttachedClusterOperation struct {
	lro *longrunning.Operation
}

// ImportAttachedClusterOperation returns a new ImportAttachedClusterOperation from a given name.
// The name must be that of a previously created ImportAttachedClusterOperation, possibly from a different process.
func (c *attachedClustersGRPCClient) ImportAttachedClusterOperation(name string) *ImportAttachedClusterOperation {
	return &ImportAttachedClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *ImportAttachedClusterOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*gkemulticloudpb.AttachedCluster, error) {
	var resp gkemulticloudpb.AttachedCluster
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *ImportAttachedClusterOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*gkemulticloudpb.AttachedCluster, error) {
	var resp gkemulticloudpb.AttachedCluster
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *ImportAttachedClusterOperation) Metadata() (*gkemulticloudpb.OperationMetadata, error) {
	var meta gkemulticloudpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *ImportAttachedClusterOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *ImportAttachedClusterOperation) Name() string {
	return op.lro.Name()
}

// UpdateAttachedClusterOperation manages a long-running operation from UpdateAttachedCluster.
type UpdateAttachedClusterOperation struct {
	lro *longrunning.Operation
}

// UpdateAttachedClusterOperation returns a new UpdateAttachedClusterOperation from a given name.
// The name must be that of a previously created UpdateAttachedClusterOperation, possibly from a different process.
func (c *attachedClustersGRPCClient) UpdateAttachedClusterOperation(name string) *UpdateAttachedClusterOperation {
	return &UpdateAttachedClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *UpdateAttachedClusterOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*gkemulticloudpb.AttachedCluster, error) {
	var resp gkemulticloudpb.AttachedCluster
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *UpdateAttachedClusterOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*gkemulticloudpb.AttachedCluster, error) {
	var resp gkemulticloudpb.AttachedCluster
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *UpdateAttachedClusterOperation) Metadata() (*gkemulticloudpb.OperationMetadata, error) {
	var meta gkemulticloudpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *UpdateAttachedClusterOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *UpdateAttachedClusterOperation) Name() string {
	return op.lro.Name()
}

// AttachedClusterIterator manages a stream of *gkemulticloudpb.AttachedCluster.
type AttachedClusterIterator struct {
	items    []*gkemulticloudpb.AttachedCluster
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*gkemulticloudpb.AttachedCluster, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *AttachedClusterIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *AttachedClusterIterator) Next() (*gkemulticloudpb.AttachedCluster, error) {
	var item *gkemulticloudpb.AttachedCluster
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *AttachedClusterIterator) bufLen() int {
	return len(it.items)
}

func (it *AttachedClusterIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// OperationIterator manages a stream of *longrunningpb.Operation.
type OperationIterator struct {
	items    []*longrunningpb.Operation
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*longrunningpb.Operation, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *OperationIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *OperationIterator) Next() (*longrunningpb.Operation, error) {
	var item *longrunningpb.Operation
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *OperationIterator) bufLen() int {
	return len(it.items)
}

func (it *OperationIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}
