// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/dialogflow/cx/v3beta1/session.proto

package cxpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	latlng "google.golang.org/genproto/googleapis/type/latlng"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents thumbs up/down rating provided by user about a response.
type AnswerFeedback_Rating int32

const (
	// Rating not specified.
	AnswerFeedback_RATING_UNSPECIFIED AnswerFeedback_Rating = 0
	// Thumbs up feedback from user.
	AnswerFeedback_THUMBS_UP AnswerFeedback_Rating = 1
	// Thumbs down feedback from user.
	AnswerFeedback_THUMBS_DOWN AnswerFeedback_Rating = 2
)

// Enum value maps for AnswerFeedback_Rating.
var (
	AnswerFeedback_Rating_name = map[int32]string{
		0: "RATING_UNSPECIFIED",
		1: "THUMBS_UP",
		2: "THUMBS_DOWN",
	}
	AnswerFeedback_Rating_value = map[string]int32{
		"RATING_UNSPECIFIED": 0,
		"THUMBS_UP":          1,
		"THUMBS_DOWN":        2,
	}
)

func (x AnswerFeedback_Rating) Enum() *AnswerFeedback_Rating {
	p := new(AnswerFeedback_Rating)
	*p = x
	return p
}

func (x AnswerFeedback_Rating) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AnswerFeedback_Rating) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_enumTypes[0].Descriptor()
}

func (AnswerFeedback_Rating) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_session_proto_enumTypes[0]
}

func (x AnswerFeedback_Rating) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AnswerFeedback_Rating.Descriptor instead.
func (AnswerFeedback_Rating) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{0, 0}
}

// Represents different DetectIntentResponse types.
type DetectIntentResponse_ResponseType int32

const (
	// Not specified. This should never happen.
	DetectIntentResponse_RESPONSE_TYPE_UNSPECIFIED DetectIntentResponse_ResponseType = 0
	// Partial response. e.g. Aggregated responses in a Fulfillment that enables
	// `return_partial_response` can be returned as partial response.
	// WARNING: partial response is not eligible for barge-in.
	DetectIntentResponse_PARTIAL DetectIntentResponse_ResponseType = 1
	// Final response.
	DetectIntentResponse_FINAL DetectIntentResponse_ResponseType = 2
)

// Enum value maps for DetectIntentResponse_ResponseType.
var (
	DetectIntentResponse_ResponseType_name = map[int32]string{
		0: "RESPONSE_TYPE_UNSPECIFIED",
		1: "PARTIAL",
		2: "FINAL",
	}
	DetectIntentResponse_ResponseType_value = map[string]int32{
		"RESPONSE_TYPE_UNSPECIFIED": 0,
		"PARTIAL":                   1,
		"FINAL":                     2,
	}
)

func (x DetectIntentResponse_ResponseType) Enum() *DetectIntentResponse_ResponseType {
	p := new(DetectIntentResponse_ResponseType)
	*p = x
	return p
}

func (x DetectIntentResponse_ResponseType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DetectIntentResponse_ResponseType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_enumTypes[1].Descriptor()
}

func (DetectIntentResponse_ResponseType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_session_proto_enumTypes[1]
}

func (x DetectIntentResponse_ResponseType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DetectIntentResponse_ResponseType.Descriptor instead.
func (DetectIntentResponse_ResponseType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{3, 0}
}

// Type of the response message.
type StreamingRecognitionResult_MessageType int32

const (
	// Not specified. Should never be used.
	StreamingRecognitionResult_MESSAGE_TYPE_UNSPECIFIED StreamingRecognitionResult_MessageType = 0
	// Message contains a (possibly partial) transcript.
	StreamingRecognitionResult_TRANSCRIPT StreamingRecognitionResult_MessageType = 1
	// This event indicates that the server has detected the end of the user's
	// speech utterance and expects no additional speech. Therefore, the server
	// will not process additional audio (although it may subsequently return
	// additional results). The client should stop sending additional audio
	// data, half-close the gRPC connection, and wait for any additional results
	// until the server closes the gRPC connection. This message is only sent if
	// [`single_utterance`][google.cloud.dialogflow.cx.v3beta1.InputAudioConfig.single_utterance]
	// was set to `true`, and is not used otherwise.
	StreamingRecognitionResult_END_OF_SINGLE_UTTERANCE StreamingRecognitionResult_MessageType = 2
)

// Enum value maps for StreamingRecognitionResult_MessageType.
var (
	StreamingRecognitionResult_MessageType_name = map[int32]string{
		0: "MESSAGE_TYPE_UNSPECIFIED",
		1: "TRANSCRIPT",
		2: "END_OF_SINGLE_UTTERANCE",
	}
	StreamingRecognitionResult_MessageType_value = map[string]int32{
		"MESSAGE_TYPE_UNSPECIFIED": 0,
		"TRANSCRIPT":               1,
		"END_OF_SINGLE_UTTERANCE":  2,
	}
)

func (x StreamingRecognitionResult_MessageType) Enum() *StreamingRecognitionResult_MessageType {
	p := new(StreamingRecognitionResult_MessageType)
	*p = x
	return p
}

func (x StreamingRecognitionResult_MessageType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StreamingRecognitionResult_MessageType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_enumTypes[2].Descriptor()
}

func (StreamingRecognitionResult_MessageType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_session_proto_enumTypes[2]
}

func (x StreamingRecognitionResult_MessageType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StreamingRecognitionResult_MessageType.Descriptor instead.
func (StreamingRecognitionResult_MessageType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{7, 0}
}

// Type of a Match.
type Match_MatchType int32

const (
	// Not specified. Should never be used.
	Match_MATCH_TYPE_UNSPECIFIED Match_MatchType = 0
	// The query was matched to an intent.
	Match_INTENT Match_MatchType = 1
	// The query directly triggered an intent.
	Match_DIRECT_INTENT Match_MatchType = 2
	// The query was used for parameter filling.
	Match_PARAMETER_FILLING Match_MatchType = 3
	// No match was found for the query.
	Match_NO_MATCH Match_MatchType = 4
	// Indicates an empty query.
	Match_NO_INPUT Match_MatchType = 5
	// The query directly triggered an event.
	Match_EVENT Match_MatchType = 6
	// The query was matched to a Knowledge Connector answer.
	Match_KNOWLEDGE_CONNECTOR Match_MatchType = 8
	// The query was handled by a
	// [`Playbook`][google.cloud.dialogflow.cx.v3beta1.Playbook].
	Match_PLAYBOOK Match_MatchType = 9
)

// Enum value maps for Match_MatchType.
var (
	Match_MatchType_name = map[int32]string{
		0: "MATCH_TYPE_UNSPECIFIED",
		1: "INTENT",
		2: "DIRECT_INTENT",
		3: "PARAMETER_FILLING",
		4: "NO_MATCH",
		5: "NO_INPUT",
		6: "EVENT",
		8: "KNOWLEDGE_CONNECTOR",
		9: "PLAYBOOK",
	}
	Match_MatchType_value = map[string]int32{
		"MATCH_TYPE_UNSPECIFIED": 0,
		"INTENT":                 1,
		"DIRECT_INTENT":          2,
		"PARAMETER_FILLING":      3,
		"NO_MATCH":               4,
		"NO_INPUT":               5,
		"EVENT":                  6,
		"KNOWLEDGE_CONNECTOR":    8,
		"PLAYBOOK":               9,
	}
)

func (x Match_MatchType) Enum() *Match_MatchType {
	p := new(Match_MatchType)
	*p = x
	return p
}

func (x Match_MatchType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Match_MatchType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_enumTypes[3].Descriptor()
}

func (Match_MatchType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_session_proto_enumTypes[3]
}

func (x Match_MatchType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Match_MatchType.Descriptor instead.
func (Match_MatchType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{21, 0}
}

// Stores information about feedback provided by users about a response.
type AnswerFeedback struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Rating from user for the specific Dialogflow response.
	Rating AnswerFeedback_Rating `protobuf:"varint,1,opt,name=rating,proto3,enum=google.cloud.dialogflow.cx.v3beta1.AnswerFeedback_Rating" json:"rating,omitempty"`
	// Optional. In case of thumbs down rating provided, users can optionally
	// provide context about the rating.
	RatingReason *AnswerFeedback_RatingReason `protobuf:"bytes,2,opt,name=rating_reason,json=ratingReason,proto3" json:"rating_reason,omitempty"`
	// Optional. Custom rating from the user about the provided answer, with
	// maximum length of 1024 characters. For example, client could use a
	// customized JSON object to indicate the rating.
	CustomRating string `protobuf:"bytes,3,opt,name=custom_rating,json=customRating,proto3" json:"custom_rating,omitempty"`
}

func (x *AnswerFeedback) Reset() {
	*x = AnswerFeedback{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnswerFeedback) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnswerFeedback) ProtoMessage() {}

func (x *AnswerFeedback) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnswerFeedback.ProtoReflect.Descriptor instead.
func (*AnswerFeedback) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{0}
}

func (x *AnswerFeedback) GetRating() AnswerFeedback_Rating {
	if x != nil {
		return x.Rating
	}
	return AnswerFeedback_RATING_UNSPECIFIED
}

func (x *AnswerFeedback) GetRatingReason() *AnswerFeedback_RatingReason {
	if x != nil {
		return x.RatingReason
	}
	return nil
}

func (x *AnswerFeedback) GetCustomRating() string {
	if x != nil {
		return x.CustomRating
	}
	return ""
}

// The request to set the feedback for a bot answer.
type SubmitAnswerFeedbackRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the session the feedback was sent to.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Required. ID of the response to update its feedback. This is the same as
	// DetectIntentResponse.response_id.
	ResponseId string `protobuf:"bytes,2,opt,name=response_id,json=responseId,proto3" json:"response_id,omitempty"`
	// Required. Feedback provided for a bot answer.
	AnswerFeedback *AnswerFeedback `protobuf:"bytes,3,opt,name=answer_feedback,json=answerFeedback,proto3" json:"answer_feedback,omitempty"`
	// Optional. The mask to control which fields to update. If the mask is not
	// present, all fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *SubmitAnswerFeedbackRequest) Reset() {
	*x = SubmitAnswerFeedbackRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubmitAnswerFeedbackRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubmitAnswerFeedbackRequest) ProtoMessage() {}

func (x *SubmitAnswerFeedbackRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubmitAnswerFeedbackRequest.ProtoReflect.Descriptor instead.
func (*SubmitAnswerFeedbackRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{1}
}

func (x *SubmitAnswerFeedbackRequest) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (x *SubmitAnswerFeedbackRequest) GetResponseId() string {
	if x != nil {
		return x.ResponseId
	}
	return ""
}

func (x *SubmitAnswerFeedbackRequest) GetAnswerFeedback() *AnswerFeedback {
	if x != nil {
		return x.AnswerFeedback
	}
	return nil
}

func (x *SubmitAnswerFeedbackRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request to detect user's intent.
type DetectIntentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the session this query is sent to.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/sessions/<Session ID>` or `projects/<Project ID>/locations/<Location
	// ID>/agents/<Agent ID>/environments/<Environment ID>/sessions/<Session ID>`.
	// If `Environment ID` is not specified, we assume default 'draft'
	// environment.
	// It's up to the API caller to choose an appropriate `Session ID`. It can be
	// a random number or some type of session identifiers (preferably hashed).
	// The length of the `Session ID` must not exceed 36 characters.
	//
	// For more information, see the [sessions
	// guide](https://cloud.google.com/dialogflow/cx/docs/concept/session).
	//
	// Note: Always use agent versions for production traffic.
	// See [Versions and
	// environments](https://cloud.google.com/dialogflow/cx/docs/concept/version).
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// The parameters of this query.
	QueryParams *QueryParameters `protobuf:"bytes,2,opt,name=query_params,json=queryParams,proto3" json:"query_params,omitempty"`
	// Required. The input specification.
	QueryInput *QueryInput `protobuf:"bytes,3,opt,name=query_input,json=queryInput,proto3" json:"query_input,omitempty"`
	// Instructs the speech synthesizer how to generate the output audio.
	OutputAudioConfig *OutputAudioConfig `protobuf:"bytes,4,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
}

func (x *DetectIntentRequest) Reset() {
	*x = DetectIntentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DetectIntentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DetectIntentRequest) ProtoMessage() {}

func (x *DetectIntentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DetectIntentRequest.ProtoReflect.Descriptor instead.
func (*DetectIntentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{2}
}

func (x *DetectIntentRequest) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (x *DetectIntentRequest) GetQueryParams() *QueryParameters {
	if x != nil {
		return x.QueryParams
	}
	return nil
}

func (x *DetectIntentRequest) GetQueryInput() *QueryInput {
	if x != nil {
		return x.QueryInput
	}
	return nil
}

func (x *DetectIntentRequest) GetOutputAudioConfig() *OutputAudioConfig {
	if x != nil {
		return x.OutputAudioConfig
	}
	return nil
}

// The message returned from the DetectIntent method.
type DetectIntentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The unique identifier of the response. It can be used to
	// locate a response in the training example set or for reporting issues.
	ResponseId string `protobuf:"bytes,1,opt,name=response_id,json=responseId,proto3" json:"response_id,omitempty"`
	// The result of the conversational query.
	QueryResult *QueryResult `protobuf:"bytes,2,opt,name=query_result,json=queryResult,proto3" json:"query_result,omitempty"`
	// The audio data bytes encoded as specified in the request.
	// Note: The output audio is generated based on the values of default platform
	// text responses found in the
	// [`query_result.response_messages`][google.cloud.dialogflow.cx.v3beta1.QueryResult.response_messages]
	// field. If multiple default text responses exist, they will be concatenated
	// when generating audio. If no default platform text responses exist, the
	// generated audio content will be empty.
	//
	// In some scenarios, multiple output audio fields may be present in the
	// response structure. In these cases, only the top-most-level audio output
	// has content.
	OutputAudio []byte `protobuf:"bytes,4,opt,name=output_audio,json=outputAudio,proto3" json:"output_audio,omitempty"`
	// The config used by the speech synthesizer to generate the output audio.
	OutputAudioConfig *OutputAudioConfig `protobuf:"bytes,5,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
	// Response type.
	ResponseType DetectIntentResponse_ResponseType `protobuf:"varint,6,opt,name=response_type,json=responseType,proto3,enum=google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse_ResponseType" json:"response_type,omitempty"`
	// Indicates whether the partial response can be cancelled when a later
	// response arrives. e.g. if the agent specified some music as partial
	// response, it can be cancelled.
	AllowCancellation bool `protobuf:"varint,7,opt,name=allow_cancellation,json=allowCancellation,proto3" json:"allow_cancellation,omitempty"`
}

func (x *DetectIntentResponse) Reset() {
	*x = DetectIntentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DetectIntentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DetectIntentResponse) ProtoMessage() {}

func (x *DetectIntentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DetectIntentResponse.ProtoReflect.Descriptor instead.
func (*DetectIntentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{3}
}

func (x *DetectIntentResponse) GetResponseId() string {
	if x != nil {
		return x.ResponseId
	}
	return ""
}

func (x *DetectIntentResponse) GetQueryResult() *QueryResult {
	if x != nil {
		return x.QueryResult
	}
	return nil
}

func (x *DetectIntentResponse) GetOutputAudio() []byte {
	if x != nil {
		return x.OutputAudio
	}
	return nil
}

func (x *DetectIntentResponse) GetOutputAudioConfig() *OutputAudioConfig {
	if x != nil {
		return x.OutputAudioConfig
	}
	return nil
}

func (x *DetectIntentResponse) GetResponseType() DetectIntentResponse_ResponseType {
	if x != nil {
		return x.ResponseType
	}
	return DetectIntentResponse_RESPONSE_TYPE_UNSPECIFIED
}

func (x *DetectIntentResponse) GetAllowCancellation() bool {
	if x != nil {
		return x.AllowCancellation
	}
	return false
}

// The top-level message sent by the client to the
// [Sessions.StreamingDetectIntent][google.cloud.dialogflow.cx.v3beta1.Sessions.StreamingDetectIntent]
// method.
//
// Multiple request messages should be sent in order:
//
//  1. The first message must contain
//     [session][google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentRequest.session],
//     [query_input][google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentRequest.query_input]
//     plus optionally
//     [query_params][google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentRequest.query_params].
//     If the client wants to receive an audio response, it should also contain
//     [output_audio_config][google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentRequest.output_audio_config].
//
// 2.  If
// [query_input][google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentRequest.query_input]
// was set to
//
//	[query_input.audio.config][google.cloud.dialogflow.cx.v3beta1.AudioInput.config],
//	all subsequent messages must contain
//	[query_input.audio.audio][google.cloud.dialogflow.cx.v3beta1.AudioInput.audio]
//	to continue with Speech recognition. If you decide to rather detect an
//	intent from text input after you already started Speech recognition,
//	please send a message with
//	[query_input.text][google.cloud.dialogflow.cx.v3beta1.QueryInput.text].
//
//	However, note that:
//
//	* Dialogflow will bill you for the audio duration so far.
//	* Dialogflow discards all Speech recognition results in favor of the
//	  input text.
//	* Dialogflow will use the language code from the first message.
//
// After you sent all input, you must half-close or abort the request stream.
type StreamingDetectIntentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the session this query is sent to.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/sessions/<Session ID>` or `projects/<Project ID>/locations/<Location
	// ID>/agents/<Agent ID>/environments/<Environment ID>/sessions/<Session ID>`.
	// If `Environment ID` is not specified, we assume default 'draft'
	// environment.
	// It's up to the API caller to choose an appropriate `Session ID`. It can be
	// a random number or some type of session identifiers (preferably hashed).
	// The length of the `Session ID` must not exceed 36 characters.
	// Note: session must be set in the first request.
	//
	// For more information, see the [sessions
	// guide](https://cloud.google.com/dialogflow/cx/docs/concept/session).
	//
	// Note: Always use agent versions for production traffic.
	// See [Versions and
	// environments](https://cloud.google.com/dialogflow/cx/docs/concept/version).
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// The parameters of this query.
	QueryParams *QueryParameters `protobuf:"bytes,2,opt,name=query_params,json=queryParams,proto3" json:"query_params,omitempty"`
	// Required. The input specification.
	QueryInput *QueryInput `protobuf:"bytes,3,opt,name=query_input,json=queryInput,proto3" json:"query_input,omitempty"`
	// Instructs the speech synthesizer how to generate the output audio.
	OutputAudioConfig *OutputAudioConfig `protobuf:"bytes,4,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
	// Enable partial detect intent response. If this flag is not enabled,
	// response stream still contains only one final `DetectIntentResponse` even
	// if some `Fulfillment`s in the agent have been configured to return partial
	// responses.
	EnablePartialResponse bool `protobuf:"varint,5,opt,name=enable_partial_response,json=enablePartialResponse,proto3" json:"enable_partial_response,omitempty"`
	// If true, `StreamingDetectIntentResponse.debugging_info` will get populated.
	EnableDebuggingInfo bool `protobuf:"varint,8,opt,name=enable_debugging_info,json=enableDebuggingInfo,proto3" json:"enable_debugging_info,omitempty"`
}

func (x *StreamingDetectIntentRequest) Reset() {
	*x = StreamingDetectIntentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamingDetectIntentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingDetectIntentRequest) ProtoMessage() {}

func (x *StreamingDetectIntentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingDetectIntentRequest.ProtoReflect.Descriptor instead.
func (*StreamingDetectIntentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{4}
}

func (x *StreamingDetectIntentRequest) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (x *StreamingDetectIntentRequest) GetQueryParams() *QueryParameters {
	if x != nil {
		return x.QueryParams
	}
	return nil
}

func (x *StreamingDetectIntentRequest) GetQueryInput() *QueryInput {
	if x != nil {
		return x.QueryInput
	}
	return nil
}

func (x *StreamingDetectIntentRequest) GetOutputAudioConfig() *OutputAudioConfig {
	if x != nil {
		return x.OutputAudioConfig
	}
	return nil
}

func (x *StreamingDetectIntentRequest) GetEnablePartialResponse() bool {
	if x != nil {
		return x.EnablePartialResponse
	}
	return false
}

func (x *StreamingDetectIntentRequest) GetEnableDebuggingInfo() bool {
	if x != nil {
		return x.EnableDebuggingInfo
	}
	return false
}

// Cloud conversation info for easier debugging.
// It will get populated in `StreamingDetectIntentResponse` or
// `StreamingAnalyzeContentResponse` when the flag `enable_debugging_info` is
// set to true in corresponding requests.
type CloudConversationDebuggingInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of input audio data chunks in streaming requests.
	AudioDataChunks int32 `protobuf:"varint,1,opt,name=audio_data_chunks,json=audioDataChunks,proto3" json:"audio_data_chunks,omitempty"`
	// Time offset of the end of speech utterance relative to the
	// beginning of the first audio chunk.
	ResultEndTimeOffset *durationpb.Duration `protobuf:"bytes,2,opt,name=result_end_time_offset,json=resultEndTimeOffset,proto3" json:"result_end_time_offset,omitempty"`
	// Duration of first audio chunk.
	FirstAudioDuration *durationpb.Duration `protobuf:"bytes,3,opt,name=first_audio_duration,json=firstAudioDuration,proto3" json:"first_audio_duration,omitempty"`
	// Whether client used single utterance mode.
	SingleUtterance bool `protobuf:"varint,5,opt,name=single_utterance,json=singleUtterance,proto3" json:"single_utterance,omitempty"`
	// Time offsets of the speech partial results relative to the beginning of
	// the stream.
	SpeechPartialResultsEndTimes []*durationpb.Duration `protobuf:"bytes,6,rep,name=speech_partial_results_end_times,json=speechPartialResultsEndTimes,proto3" json:"speech_partial_results_end_times,omitempty"`
	// Time offsets of the speech final results (is_final=true) relative to the
	// beginning of the stream.
	SpeechFinalResultsEndTimes []*durationpb.Duration `protobuf:"bytes,7,rep,name=speech_final_results_end_times,json=speechFinalResultsEndTimes,proto3" json:"speech_final_results_end_times,omitempty"`
	// Total number of partial responses.
	PartialResponses int32 `protobuf:"varint,8,opt,name=partial_responses,json=partialResponses,proto3" json:"partial_responses,omitempty"`
	// Time offset of Speaker ID stream close time relative to the Speech stream
	// close time in milliseconds. Only meaningful for conversations involving
	// passive verification.
	SpeakerIdPassiveLatencyMsOffset int32 `protobuf:"varint,9,opt,name=speaker_id_passive_latency_ms_offset,json=speakerIdPassiveLatencyMsOffset,proto3" json:"speaker_id_passive_latency_ms_offset,omitempty"`
	// Whether a barge-in event is triggered in this request.
	BargeinEventTriggered bool `protobuf:"varint,10,opt,name=bargein_event_triggered,json=bargeinEventTriggered,proto3" json:"bargein_event_triggered,omitempty"`
	// Whether speech uses single utterance mode.
	SpeechSingleUtterance bool `protobuf:"varint,11,opt,name=speech_single_utterance,json=speechSingleUtterance,proto3" json:"speech_single_utterance,omitempty"`
	// Time offsets of the DTMF partial results relative to the beginning of
	// the stream.
	DtmfPartialResultsTimes []*durationpb.Duration `protobuf:"bytes,12,rep,name=dtmf_partial_results_times,json=dtmfPartialResultsTimes,proto3" json:"dtmf_partial_results_times,omitempty"`
	// Time offsets of the DTMF final results relative to the beginning of
	// the stream.
	DtmfFinalResultsTimes []*durationpb.Duration `protobuf:"bytes,13,rep,name=dtmf_final_results_times,json=dtmfFinalResultsTimes,proto3" json:"dtmf_final_results_times,omitempty"`
	// Time offset of the end-of-single-utterance signal relative to the
	// beginning of the stream.
	SingleUtteranceEndTimeOffset *durationpb.Duration `protobuf:"bytes,14,opt,name=single_utterance_end_time_offset,json=singleUtteranceEndTimeOffset,proto3" json:"single_utterance_end_time_offset,omitempty"`
	// No speech timeout settings for the stream.
	NoSpeechTimeout *durationpb.Duration `protobuf:"bytes,15,opt,name=no_speech_timeout,json=noSpeechTimeout,proto3" json:"no_speech_timeout,omitempty"`
	// Speech endpointing timeout settings for the stream.
	EndpointingTimeout *durationpb.Duration `protobuf:"bytes,19,opt,name=endpointing_timeout,json=endpointingTimeout,proto3" json:"endpointing_timeout,omitempty"`
	// Whether the streaming terminates with an injected text query.
	IsInputText bool `protobuf:"varint,16,opt,name=is_input_text,json=isInputText,proto3" json:"is_input_text,omitempty"`
	// Client half close time in terms of input audio duration.
	ClientHalfCloseTimeOffset *durationpb.Duration `protobuf:"bytes,17,opt,name=client_half_close_time_offset,json=clientHalfCloseTimeOffset,proto3" json:"client_half_close_time_offset,omitempty"`
	// Client half close time in terms of API streaming duration.
	ClientHalfCloseStreamingTimeOffset *durationpb.Duration `protobuf:"bytes,18,opt,name=client_half_close_streaming_time_offset,json=clientHalfCloseStreamingTimeOffset,proto3" json:"client_half_close_streaming_time_offset,omitempty"`
}

func (x *CloudConversationDebuggingInfo) Reset() {
	*x = CloudConversationDebuggingInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudConversationDebuggingInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudConversationDebuggingInfo) ProtoMessage() {}

func (x *CloudConversationDebuggingInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudConversationDebuggingInfo.ProtoReflect.Descriptor instead.
func (*CloudConversationDebuggingInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{5}
}

func (x *CloudConversationDebuggingInfo) GetAudioDataChunks() int32 {
	if x != nil {
		return x.AudioDataChunks
	}
	return 0
}

func (x *CloudConversationDebuggingInfo) GetResultEndTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.ResultEndTimeOffset
	}
	return nil
}

func (x *CloudConversationDebuggingInfo) GetFirstAudioDuration() *durationpb.Duration {
	if x != nil {
		return x.FirstAudioDuration
	}
	return nil
}

func (x *CloudConversationDebuggingInfo) GetSingleUtterance() bool {
	if x != nil {
		return x.SingleUtterance
	}
	return false
}

func (x *CloudConversationDebuggingInfo) GetSpeechPartialResultsEndTimes() []*durationpb.Duration {
	if x != nil {
		return x.SpeechPartialResultsEndTimes
	}
	return nil
}

func (x *CloudConversationDebuggingInfo) GetSpeechFinalResultsEndTimes() []*durationpb.Duration {
	if x != nil {
		return x.SpeechFinalResultsEndTimes
	}
	return nil
}

func (x *CloudConversationDebuggingInfo) GetPartialResponses() int32 {
	if x != nil {
		return x.PartialResponses
	}
	return 0
}

func (x *CloudConversationDebuggingInfo) GetSpeakerIdPassiveLatencyMsOffset() int32 {
	if x != nil {
		return x.SpeakerIdPassiveLatencyMsOffset
	}
	return 0
}

func (x *CloudConversationDebuggingInfo) GetBargeinEventTriggered() bool {
	if x != nil {
		return x.BargeinEventTriggered
	}
	return false
}

func (x *CloudConversationDebuggingInfo) GetSpeechSingleUtterance() bool {
	if x != nil {
		return x.SpeechSingleUtterance
	}
	return false
}

func (x *CloudConversationDebuggingInfo) GetDtmfPartialResultsTimes() []*durationpb.Duration {
	if x != nil {
		return x.DtmfPartialResultsTimes
	}
	return nil
}

func (x *CloudConversationDebuggingInfo) GetDtmfFinalResultsTimes() []*durationpb.Duration {
	if x != nil {
		return x.DtmfFinalResultsTimes
	}
	return nil
}

func (x *CloudConversationDebuggingInfo) GetSingleUtteranceEndTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.SingleUtteranceEndTimeOffset
	}
	return nil
}

func (x *CloudConversationDebuggingInfo) GetNoSpeechTimeout() *durationpb.Duration {
	if x != nil {
		return x.NoSpeechTimeout
	}
	return nil
}

func (x *CloudConversationDebuggingInfo) GetEndpointingTimeout() *durationpb.Duration {
	if x != nil {
		return x.EndpointingTimeout
	}
	return nil
}

func (x *CloudConversationDebuggingInfo) GetIsInputText() bool {
	if x != nil {
		return x.IsInputText
	}
	return false
}

func (x *CloudConversationDebuggingInfo) GetClientHalfCloseTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.ClientHalfCloseTimeOffset
	}
	return nil
}

func (x *CloudConversationDebuggingInfo) GetClientHalfCloseStreamingTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.ClientHalfCloseStreamingTimeOffset
	}
	return nil
}

// The top-level message returned from the
// [StreamingDetectIntent][google.cloud.dialogflow.cx.v3beta1.Sessions.StreamingDetectIntent]
// method.
//
// Multiple response messages (N) can be returned in order.
//
// The first (N-1) responses set either the `recognition_result` or
// `detect_intent_response` field, depending on the request:
//
//   - If the `StreamingDetectIntentRequest.query_input.audio` field was
//     set, and the `StreamingDetectIntentRequest.enable_partial_response`
//     field was false, the `recognition_result` field is populated for each
//     of the (N-1) responses.
//     See the
//     [StreamingRecognitionResult][google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult]
//     message for details about the result message sequence.
//
//   - If the `StreamingDetectIntentRequest.enable_partial_response` field was
//     true, the `detect_intent_response` field is populated for each
//     of the (N-1) responses, where 1 <= N <= 4.
//     These responses set the
//     [DetectIntentResponse.response_type][google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.response_type]
//     field to `PARTIAL`.
//
// For the final Nth response message, the `detect_intent_response` is fully
// populated, and
// [DetectIntentResponse.response_type][google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.response_type]
// is set to `FINAL`.
type StreamingDetectIntentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The output response.
	//
	// Types that are assignable to Response:
	//
	//	*StreamingDetectIntentResponse_RecognitionResult
	//	*StreamingDetectIntentResponse_DetectIntentResponse
	Response isStreamingDetectIntentResponse_Response `protobuf_oneof:"response"`
	// Debugging info that would get populated when
	// `StreamingDetectIntentRequest.enable_debugging_info` is set to true.
	DebuggingInfo *CloudConversationDebuggingInfo `protobuf:"bytes,4,opt,name=debugging_info,json=debuggingInfo,proto3" json:"debugging_info,omitempty"`
}

func (x *StreamingDetectIntentResponse) Reset() {
	*x = StreamingDetectIntentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamingDetectIntentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingDetectIntentResponse) ProtoMessage() {}

func (x *StreamingDetectIntentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingDetectIntentResponse.ProtoReflect.Descriptor instead.
func (*StreamingDetectIntentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{6}
}

func (m *StreamingDetectIntentResponse) GetResponse() isStreamingDetectIntentResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (x *StreamingDetectIntentResponse) GetRecognitionResult() *StreamingRecognitionResult {
	if x, ok := x.GetResponse().(*StreamingDetectIntentResponse_RecognitionResult); ok {
		return x.RecognitionResult
	}
	return nil
}

func (x *StreamingDetectIntentResponse) GetDetectIntentResponse() *DetectIntentResponse {
	if x, ok := x.GetResponse().(*StreamingDetectIntentResponse_DetectIntentResponse); ok {
		return x.DetectIntentResponse
	}
	return nil
}

func (x *StreamingDetectIntentResponse) GetDebuggingInfo() *CloudConversationDebuggingInfo {
	if x != nil {
		return x.DebuggingInfo
	}
	return nil
}

type isStreamingDetectIntentResponse_Response interface {
	isStreamingDetectIntentResponse_Response()
}

type StreamingDetectIntentResponse_RecognitionResult struct {
	// The result of speech recognition.
	RecognitionResult *StreamingRecognitionResult `protobuf:"bytes,1,opt,name=recognition_result,json=recognitionResult,proto3,oneof"`
}

type StreamingDetectIntentResponse_DetectIntentResponse struct {
	// The response from detect intent.
	DetectIntentResponse *DetectIntentResponse `protobuf:"bytes,2,opt,name=detect_intent_response,json=detectIntentResponse,proto3,oneof"`
}

func (*StreamingDetectIntentResponse_RecognitionResult) isStreamingDetectIntentResponse_Response() {}

func (*StreamingDetectIntentResponse_DetectIntentResponse) isStreamingDetectIntentResponse_Response() {
}

// Contains a speech recognition result corresponding to a portion of the audio
// that is currently being processed or an indication that this is the end
// of the single requested utterance.
//
// While end-user audio is being processed, Dialogflow sends a series of
// results. Each result may contain a `transcript` value. A transcript
// represents a portion of the utterance. While the recognizer is processing
// audio, transcript values may be interim values or finalized values.
// Once a transcript is finalized, the `is_final` value is set to true and
// processing continues for the next transcript.
//
// If `StreamingDetectIntentRequest.query_input.audio.config.single_utterance`
// was true, and the recognizer has completed processing audio,
// the `message_type` value is set to `END_OF_SINGLE_UTTERANCE and the
// following (last) result contains the last finalized transcript.
//
// The complete end-user utterance is determined by concatenating the
// finalized transcript values received for the series of results.
//
// In the following example, single utterance is enabled. In the case where
// single utterance is not enabled, result 7 would not occur.
//
// ```
// Num | transcript              | message_type            | is_final
// --- | ----------------------- | ----------------------- | --------
// 1   | "tube"                  | TRANSCRIPT              | false
// 2   | "to be a"               | TRANSCRIPT              | false
// 3   | "to be"                 | TRANSCRIPT              | false
// 4   | "to be or not to be"    | TRANSCRIPT              | true
// 5   | "that's"                | TRANSCRIPT              | false
// 6   | "that is                | TRANSCRIPT              | false
// 7   | unset                   | END_OF_SINGLE_UTTERANCE | unset
// 8   | " that is the question" | TRANSCRIPT              | true
// ```
//
// Concatenating the finalized transcripts with `is_final` set to true,
// the complete utterance becomes "to be or not to be that is the question".
type StreamingRecognitionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the result message.
	MessageType StreamingRecognitionResult_MessageType `protobuf:"varint,1,opt,name=message_type,json=messageType,proto3,enum=google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult_MessageType" json:"message_type,omitempty"`
	// Transcript text representing the words that the user spoke.
	// Populated if and only if `message_type` = `TRANSCRIPT`.
	Transcript string `protobuf:"bytes,2,opt,name=transcript,proto3" json:"transcript,omitempty"`
	// If `false`, the `StreamingRecognitionResult` represents an
	// interim result that may change. If `true`, the recognizer will not return
	// any further hypotheses about this piece of the audio. May only be populated
	// for `message_type` = `TRANSCRIPT`.
	IsFinal bool `protobuf:"varint,3,opt,name=is_final,json=isFinal,proto3" json:"is_final,omitempty"`
	// The Speech confidence between 0.0 and 1.0 for the current portion of audio.
	// A higher number indicates an estimated greater likelihood that the
	// recognized words are correct. The default of 0.0 is a sentinel value
	// indicating that confidence was not set.
	//
	// This field is typically only provided if `is_final` is true and you should
	// not rely on it being accurate or even set.
	Confidence float32 `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// An estimate of the likelihood that the speech recognizer will
	// not change its guess about this interim recognition result:
	//   - If the value is unspecified or 0.0, Dialogflow didn't compute the
	//     stability. In particular, Dialogflow will only provide stability for
	//     `TRANSCRIPT` results with `is_final = false`.
	//   - Otherwise, the value is in (0.0, 1.0] where 0.0 means completely
	//     unstable and 1.0 means completely stable.
	Stability float32 `protobuf:"fixed32,6,opt,name=stability,proto3" json:"stability,omitempty"`
	// Word-specific information for the words recognized by Speech in
	// [transcript][google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult.transcript].
	// Populated if and only if `message_type` = `TRANSCRIPT` and
	// [InputAudioConfig.enable_word_info] is set.
	SpeechWordInfo []*SpeechWordInfo `protobuf:"bytes,7,rep,name=speech_word_info,json=speechWordInfo,proto3" json:"speech_word_info,omitempty"`
	// Time offset of the end of this Speech recognition result relative to the
	// beginning of the audio. Only populated for `message_type` =
	// `TRANSCRIPT`.
	SpeechEndOffset *durationpb.Duration `protobuf:"bytes,8,opt,name=speech_end_offset,json=speechEndOffset,proto3" json:"speech_end_offset,omitempty"`
	// Detected language code for the transcript.
	LanguageCode string `protobuf:"bytes,10,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *StreamingRecognitionResult) Reset() {
	*x = StreamingRecognitionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamingRecognitionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingRecognitionResult) ProtoMessage() {}

func (x *StreamingRecognitionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingRecognitionResult.ProtoReflect.Descriptor instead.
func (*StreamingRecognitionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{7}
}

func (x *StreamingRecognitionResult) GetMessageType() StreamingRecognitionResult_MessageType {
	if x != nil {
		return x.MessageType
	}
	return StreamingRecognitionResult_MESSAGE_TYPE_UNSPECIFIED
}

func (x *StreamingRecognitionResult) GetTranscript() string {
	if x != nil {
		return x.Transcript
	}
	return ""
}

func (x *StreamingRecognitionResult) GetIsFinal() bool {
	if x != nil {
		return x.IsFinal
	}
	return false
}

func (x *StreamingRecognitionResult) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *StreamingRecognitionResult) GetStability() float32 {
	if x != nil {
		return x.Stability
	}
	return 0
}

func (x *StreamingRecognitionResult) GetSpeechWordInfo() []*SpeechWordInfo {
	if x != nil {
		return x.SpeechWordInfo
	}
	return nil
}

func (x *StreamingRecognitionResult) GetSpeechEndOffset() *durationpb.Duration {
	if x != nil {
		return x.SpeechEndOffset
	}
	return nil
}

func (x *StreamingRecognitionResult) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Represents the parameters of a conversational query.
type QueryParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time zone of this conversational query from the [time zone
	// database](https://www.iana.org/time-zones), e.g., America/New_York,
	// Europe/Paris. If not provided, the time zone specified in the agent is
	// used.
	TimeZone string `protobuf:"bytes,1,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// The geo location of this conversational query.
	GeoLocation *latlng.LatLng `protobuf:"bytes,2,opt,name=geo_location,json=geoLocation,proto3" json:"geo_location,omitempty"`
	// Additional session entity types to replace or extend developer entity types
	// with. The entity synonyms apply to all languages and persist for the
	// session of this query.
	SessionEntityTypes []*SessionEntityType `protobuf:"bytes,3,rep,name=session_entity_types,json=sessionEntityTypes,proto3" json:"session_entity_types,omitempty"`
	// This field can be used to pass custom data into the webhook associated with
	// the agent. Arbitrary JSON objects are supported.
	// Some integrations that query a Dialogflow agent may provide additional
	// information in the payload.
	// In particular, for the Dialogflow Phone Gateway integration, this field has
	// the form:
	// ```
	//
	//	{
	//	 "telephony": {
	//	   "caller_id": "+18558363987"
	//	 }
	//	}
	//
	// ```
	Payload *structpb.Struct `protobuf:"bytes,4,opt,name=payload,proto3" json:"payload,omitempty"`
	// Additional parameters to be put into [session
	// parameters][SessionInfo.parameters]. To remove a
	// parameter from the session, clients should explicitly set the parameter
	// value to null.
	//
	// You can reference the session parameters in the agent with the following
	// format: $session.params.parameter-id.
	//
	// Depending on your protocol or client library language, this is a
	// map, associative array, symbol table, dictionary, or JSON object
	// composed of a collection of (MapKey, MapValue) pairs:
	//
	// * MapKey type: string
	// * MapKey value: parameter name
	// * MapValue type: If parameter's entity type is a composite entity then use
	// map, otherwise, depending on the parameter value type, it could be one of
	// string, number, boolean, null, list or map.
	// * MapValue value: If parameter's entity type is a composite entity then use
	// map from composite entity property names to property values, otherwise,
	// use parameter value.
	Parameters *structpb.Struct `protobuf:"bytes,5,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// The unique identifier of the
	// [page][google.cloud.dialogflow.cx.v3beta1.Page] to override the [current
	// page][QueryResult.current_page] in the session.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/flows/<Flow ID>/pages/<Page ID>`.
	//
	// If `current_page` is specified, the previous state of the session will be
	// ignored by Dialogflow, including the [previous
	// page][QueryResult.current_page] and the [previous session
	// parameters][QueryResult.parameters].
	// In most cases,
	// [current_page][google.cloud.dialogflow.cx.v3beta1.QueryParameters.current_page]
	// and
	// [parameters][google.cloud.dialogflow.cx.v3beta1.QueryParameters.parameters]
	// should be configured together to direct a session to a specific state.
	CurrentPage string `protobuf:"bytes,6,opt,name=current_page,json=currentPage,proto3" json:"current_page,omitempty"`
	// Whether to disable webhook calls for this request.
	DisableWebhook bool `protobuf:"varint,7,opt,name=disable_webhook,json=disableWebhook,proto3" json:"disable_webhook,omitempty"`
	// Configures whether sentiment analysis should be performed. If not
	// provided, sentiment analysis is not performed.
	AnalyzeQueryTextSentiment bool `protobuf:"varint,8,opt,name=analyze_query_text_sentiment,json=analyzeQueryTextSentiment,proto3" json:"analyze_query_text_sentiment,omitempty"`
	// This field can be used to pass HTTP headers for a webhook
	// call. These headers will be sent to webhook along with the headers that
	// have been configured through Dialogflow web console. The headers defined
	// within this field will overwrite the headers configured through Dialogflow
	// console if there is a conflict. Header names are case-insensitive.
	// Google's specified headers are not allowed. Including: "Host",
	// "Content-Length", "Connection", "From", "User-Agent", "Accept-Encoding",
	// "If-Modified-Since", "If-None-Match", "X-Forwarded-For", etc.
	WebhookHeaders map[string]string `protobuf:"bytes,10,rep,name=webhook_headers,json=webhookHeaders,proto3" json:"webhook_headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A list of flow versions to override for the request.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/flows/<Flow ID>/versions/<Version ID>`.
	//
	// If version 1 of flow X is included in this list, the traffic of
	// flow X will go through version 1 regardless of the version configuration in
	// the environment. Each flow can have at most one version specified in this
	// list.
	FlowVersions []string `protobuf:"bytes,14,rep,name=flow_versions,json=flowVersions,proto3" json:"flow_versions,omitempty"`
	// Optional. Start the session with the specified
	// [playbook][google.cloud.dialogflow.cx.v3beta1.Playbook]. You can only
	// specify the playbook at the beginning of the session. Otherwise, an error
	// will be thrown.
	//
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/playbooks/<Playbook ID>`.
	CurrentPlaybook string `protobuf:"bytes,19,opt,name=current_playbook,json=currentPlaybook,proto3" json:"current_playbook,omitempty"`
	// Optional. Use the specified LLM model settings for processing the request.
	LlmModelSettings *LlmModelSettings `protobuf:"bytes,21,opt,name=llm_model_settings,json=llmModelSettings,proto3" json:"llm_model_settings,omitempty"`
	// The channel which this query is for.
	//
	// If specified, only the
	// [ResponseMessage][google.cloud.dialogflow.cx.v3beta1.ResponseMessage]
	// associated with the channel will be returned. If no
	// [ResponseMessage][google.cloud.dialogflow.cx.v3beta1.ResponseMessage] is
	// associated with the channel, it falls back to the
	// [ResponseMessage][google.cloud.dialogflow.cx.v3beta1.ResponseMessage] with
	// unspecified channel.
	//
	// If unspecified, the
	// [ResponseMessage][google.cloud.dialogflow.cx.v3beta1.ResponseMessage] with
	// unspecified channel will be returned.
	Channel string `protobuf:"bytes,15,opt,name=channel,proto3" json:"channel,omitempty"`
	// Optional. Configure lifetime of the Dialogflow session.
	// By default, a Dialogflow session remains active and its data is stored for
	// 30 minutes after the last request is sent for the session.
	// This value should be no longer than 1 day.
	SessionTtl *durationpb.Duration `protobuf:"bytes,16,opt,name=session_ttl,json=sessionTtl,proto3" json:"session_ttl,omitempty"`
	// Optional. Information about the end-user to improve the relevance and
	// accuracy of generative answers.
	//
	// This will be interpreted and used by a language model, so, for good
	// results, the data should be self-descriptive, and in a simple structure.
	//
	// Example:
	//
	// ```json
	//
	//	{
	//	  "subscription plan": "Business Premium Plus",
	//	  "devices owned": [
	//	    {"model": "Google Pixel 7"},
	//	    {"model": "Google Pixel Tablet"}
	//	  ]
	//	}
	//
	// ```
	EndUserMetadata *structpb.Struct `protobuf:"bytes,18,opt,name=end_user_metadata,json=endUserMetadata,proto3" json:"end_user_metadata,omitempty"`
	// Optional. Search configuration for UCS search queries.
	SearchConfig *SearchConfig `protobuf:"bytes,20,opt,name=search_config,json=searchConfig,proto3" json:"search_config,omitempty"`
	// Optional. If set to true and data stores are involved in serving the
	// request then
	// DetectIntentResponse.query_result.data_store_connection_signals
	// will be filled with data that can help evaluations.
	PopulateDataStoreConnectionSignals bool `protobuf:"varint,25,opt,name=populate_data_store_connection_signals,json=populateDataStoreConnectionSignals,proto3" json:"populate_data_store_connection_signals,omitempty"`
}

func (x *QueryParameters) Reset() {
	*x = QueryParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryParameters) ProtoMessage() {}

func (x *QueryParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryParameters.ProtoReflect.Descriptor instead.
func (*QueryParameters) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{8}
}

func (x *QueryParameters) GetTimeZone() string {
	if x != nil {
		return x.TimeZone
	}
	return ""
}

func (x *QueryParameters) GetGeoLocation() *latlng.LatLng {
	if x != nil {
		return x.GeoLocation
	}
	return nil
}

func (x *QueryParameters) GetSessionEntityTypes() []*SessionEntityType {
	if x != nil {
		return x.SessionEntityTypes
	}
	return nil
}

func (x *QueryParameters) GetPayload() *structpb.Struct {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *QueryParameters) GetParameters() *structpb.Struct {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *QueryParameters) GetCurrentPage() string {
	if x != nil {
		return x.CurrentPage
	}
	return ""
}

func (x *QueryParameters) GetDisableWebhook() bool {
	if x != nil {
		return x.DisableWebhook
	}
	return false
}

func (x *QueryParameters) GetAnalyzeQueryTextSentiment() bool {
	if x != nil {
		return x.AnalyzeQueryTextSentiment
	}
	return false
}

func (x *QueryParameters) GetWebhookHeaders() map[string]string {
	if x != nil {
		return x.WebhookHeaders
	}
	return nil
}

func (x *QueryParameters) GetFlowVersions() []string {
	if x != nil {
		return x.FlowVersions
	}
	return nil
}

func (x *QueryParameters) GetCurrentPlaybook() string {
	if x != nil {
		return x.CurrentPlaybook
	}
	return ""
}

func (x *QueryParameters) GetLlmModelSettings() *LlmModelSettings {
	if x != nil {
		return x.LlmModelSettings
	}
	return nil
}

func (x *QueryParameters) GetChannel() string {
	if x != nil {
		return x.Channel
	}
	return ""
}

func (x *QueryParameters) GetSessionTtl() *durationpb.Duration {
	if x != nil {
		return x.SessionTtl
	}
	return nil
}

func (x *QueryParameters) GetEndUserMetadata() *structpb.Struct {
	if x != nil {
		return x.EndUserMetadata
	}
	return nil
}

func (x *QueryParameters) GetSearchConfig() *SearchConfig {
	if x != nil {
		return x.SearchConfig
	}
	return nil
}

func (x *QueryParameters) GetPopulateDataStoreConnectionSignals() bool {
	if x != nil {
		return x.PopulateDataStoreConnectionSignals
	}
	return false
}

// Search configuration for UCS search queries.
type SearchConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Boosting configuration for the datastores.
	BoostSpecs []*BoostSpecs `protobuf:"bytes,1,rep,name=boost_specs,json=boostSpecs,proto3" json:"boost_specs,omitempty"`
	// Optional. Filter configuration for the datastores.
	FilterSpecs []*FilterSpecs `protobuf:"bytes,2,rep,name=filter_specs,json=filterSpecs,proto3" json:"filter_specs,omitempty"`
}

func (x *SearchConfig) Reset() {
	*x = SearchConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchConfig) ProtoMessage() {}

func (x *SearchConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchConfig.ProtoReflect.Descriptor instead.
func (*SearchConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{9}
}

func (x *SearchConfig) GetBoostSpecs() []*BoostSpecs {
	if x != nil {
		return x.BoostSpecs
	}
	return nil
}

func (x *SearchConfig) GetFilterSpecs() []*FilterSpecs {
	if x != nil {
		return x.FilterSpecs
	}
	return nil
}

// Boost specification to boost certain documents.
// A copy of google.cloud.discoveryengine.v1main.BoostSpec, field documentation
// is available at
// https://cloud.google.com/generative-ai-app-builder/docs/reference/rest/v1alpha/BoostSpec
type BoostSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Condition boost specifications. If a document matches multiple
	// conditions in the specifictions, boost scores from these specifications are
	// all applied and combined in a non-linear way. Maximum number of
	// specifications is 20.
	ConditionBoostSpecs []*BoostSpec_ConditionBoostSpec `protobuf:"bytes,1,rep,name=condition_boost_specs,json=conditionBoostSpecs,proto3" json:"condition_boost_specs,omitempty"`
}

func (x *BoostSpec) Reset() {
	*x = BoostSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoostSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoostSpec) ProtoMessage() {}

func (x *BoostSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoostSpec.ProtoReflect.Descriptor instead.
func (*BoostSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{10}
}

func (x *BoostSpec) GetConditionBoostSpecs() []*BoostSpec_ConditionBoostSpec {
	if x != nil {
		return x.ConditionBoostSpecs
	}
	return nil
}

// Boost specifications for data stores.
type BoostSpecs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Data Stores where the boosting configuration is applied. The full
	// names of the referenced data stores. Formats:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`
	// `projects/{project}/locations/{location}/dataStores/{data_store}
	DataStores []string `protobuf:"bytes,1,rep,name=data_stores,json=dataStores,proto3" json:"data_stores,omitempty"`
	// Optional. A list of boosting specifications.
	Spec []*BoostSpec `protobuf:"bytes,2,rep,name=spec,proto3" json:"spec,omitempty"`
}

func (x *BoostSpecs) Reset() {
	*x = BoostSpecs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoostSpecs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoostSpecs) ProtoMessage() {}

func (x *BoostSpecs) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoostSpecs.ProtoReflect.Descriptor instead.
func (*BoostSpecs) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{11}
}

func (x *BoostSpecs) GetDataStores() []string {
	if x != nil {
		return x.DataStores
	}
	return nil
}

func (x *BoostSpecs) GetSpec() []*BoostSpec {
	if x != nil {
		return x.Spec
	}
	return nil
}

// Filter specifications for data stores.
type FilterSpecs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Data Stores where the boosting configuration is applied. The full
	// names of the referenced data stores. Formats:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`
	// `projects/{project}/locations/{location}/dataStores/{data_store}
	DataStores []string `protobuf:"bytes,1,rep,name=data_stores,json=dataStores,proto3" json:"data_stores,omitempty"`
	// Optional. The filter expression to be applied.
	// Expression syntax is documented at
	// https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata#filter-expression-syntax
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *FilterSpecs) Reset() {
	*x = FilterSpecs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FilterSpecs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilterSpecs) ProtoMessage() {}

func (x *FilterSpecs) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilterSpecs.ProtoReflect.Descriptor instead.
func (*FilterSpecs) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{12}
}

func (x *FilterSpecs) GetDataStores() []string {
	if x != nil {
		return x.DataStores
	}
	return nil
}

func (x *FilterSpecs) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Represents the query input. It can contain one of:
//
// 1. A conversational query in the form of text.
//
// 2. An intent query that specifies which intent to trigger.
//
// 3. Natural language speech audio to be processed.
//
// 4. An event to be triggered.
//
// 5. DTMF digits to invoke an intent and fill in parameter value.
//
// 6. The results of a tool executed by the client.
type QueryInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The input specification.
	//
	// Types that are assignable to Input:
	//
	//	*QueryInput_Text
	//	*QueryInput_Intent
	//	*QueryInput_Audio
	//	*QueryInput_Event
	//	*QueryInput_Dtmf
	//	*QueryInput_ToolCallResult
	Input isQueryInput_Input `protobuf_oneof:"input"`
	// Required. The language of the input. See [Language
	// Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
	// for a list of the currently supported language codes. Note that queries in
	// the same session do not necessarily need to specify the same language.
	LanguageCode string `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *QueryInput) Reset() {
	*x = QueryInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryInput) ProtoMessage() {}

func (x *QueryInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryInput.ProtoReflect.Descriptor instead.
func (*QueryInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{13}
}

func (m *QueryInput) GetInput() isQueryInput_Input {
	if m != nil {
		return m.Input
	}
	return nil
}

func (x *QueryInput) GetText() *TextInput {
	if x, ok := x.GetInput().(*QueryInput_Text); ok {
		return x.Text
	}
	return nil
}

func (x *QueryInput) GetIntent() *IntentInput {
	if x, ok := x.GetInput().(*QueryInput_Intent); ok {
		return x.Intent
	}
	return nil
}

func (x *QueryInput) GetAudio() *AudioInput {
	if x, ok := x.GetInput().(*QueryInput_Audio); ok {
		return x.Audio
	}
	return nil
}

func (x *QueryInput) GetEvent() *EventInput {
	if x, ok := x.GetInput().(*QueryInput_Event); ok {
		return x.Event
	}
	return nil
}

func (x *QueryInput) GetDtmf() *DtmfInput {
	if x, ok := x.GetInput().(*QueryInput_Dtmf); ok {
		return x.Dtmf
	}
	return nil
}

func (x *QueryInput) GetToolCallResult() *ToolCallResult {
	if x, ok := x.GetInput().(*QueryInput_ToolCallResult); ok {
		return x.ToolCallResult
	}
	return nil
}

func (x *QueryInput) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

type isQueryInput_Input interface {
	isQueryInput_Input()
}

type QueryInput_Text struct {
	// The natural language text to be processed.
	Text *TextInput `protobuf:"bytes,2,opt,name=text,proto3,oneof"`
}

type QueryInput_Intent struct {
	// The intent to be triggered.
	Intent *IntentInput `protobuf:"bytes,3,opt,name=intent,proto3,oneof"`
}

type QueryInput_Audio struct {
	// The natural language speech audio to be processed.
	Audio *AudioInput `protobuf:"bytes,5,opt,name=audio,proto3,oneof"`
}

type QueryInput_Event struct {
	// The event to be triggered.
	Event *EventInput `protobuf:"bytes,6,opt,name=event,proto3,oneof"`
}

type QueryInput_Dtmf struct {
	// The DTMF event to be handled.
	Dtmf *DtmfInput `protobuf:"bytes,7,opt,name=dtmf,proto3,oneof"`
}

type QueryInput_ToolCallResult struct {
	// The results of a tool executed by the client.
	ToolCallResult *ToolCallResult `protobuf:"bytes,11,opt,name=tool_call_result,json=toolCallResult,proto3,oneof"`
}

func (*QueryInput_Text) isQueryInput_Input() {}

func (*QueryInput_Intent) isQueryInput_Input() {}

func (*QueryInput_Audio) isQueryInput_Input() {}

func (*QueryInput_Event) isQueryInput_Input() {}

func (*QueryInput_Dtmf) isQueryInput_Input() {}

func (*QueryInput_ToolCallResult) isQueryInput_Input() {}

// Represents the information of a query if handled by generative agent
// resources.
type GenerativeInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The stack of [playbooks][google.cloud.dialogflow.cx.v3beta1.Playbook] that
	// the conversation has currently entered, with the most recent one on the
	// top.
	CurrentPlaybooks []string `protobuf:"bytes,1,rep,name=current_playbooks,json=currentPlaybooks,proto3" json:"current_playbooks,omitempty"`
	// The actions performed by the generative playbook for the current agent
	// response.
	ActionTracingInfo *Example `protobuf:"bytes,2,opt,name=action_tracing_info,json=actionTracingInfo,proto3" json:"action_tracing_info,omitempty"`
}

func (x *GenerativeInfo) Reset() {
	*x = GenerativeInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerativeInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerativeInfo) ProtoMessage() {}

func (x *GenerativeInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerativeInfo.ProtoReflect.Descriptor instead.
func (*GenerativeInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{14}
}

func (x *GenerativeInfo) GetCurrentPlaybooks() []string {
	if x != nil {
		return x.CurrentPlaybooks
	}
	return nil
}

func (x *GenerativeInfo) GetActionTracingInfo() *Example {
	if x != nil {
		return x.ActionTracingInfo
	}
	return nil
}

// Represents the result of a conversational query.
type QueryResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The original conversational query.
	//
	// Types that are assignable to Query:
	//
	//	*QueryResult_Text
	//	*QueryResult_TriggerIntent
	//	*QueryResult_Transcript
	//	*QueryResult_TriggerEvent
	//	*QueryResult_Dtmf
	Query isQueryResult_Query `protobuf_oneof:"query"`
	// The language that was triggered during intent detection.
	// See [Language
	// Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
	// for a list of the currently supported language codes.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The collected [session
	// parameters][google.cloud.dialogflow.cx.v3beta1.SessionInfo.parameters].
	//
	// Depending on your protocol or client library language, this is a
	// map, associative array, symbol table, dictionary, or JSON object
	// composed of a collection of (MapKey, MapValue) pairs:
	//
	// * MapKey type: string
	// * MapKey value: parameter name
	// * MapValue type: If parameter's entity type is a composite entity then use
	// map, otherwise, depending on the parameter value type, it could be one of
	// string, number, boolean, null, list or map.
	// * MapValue value: If parameter's entity type is a composite entity then use
	// map from composite entity property names to property values, otherwise,
	// use parameter value.
	Parameters *structpb.Struct `protobuf:"bytes,3,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// The list of rich messages returned to the client. Responses vary from
	// simple text messages to more sophisticated, structured payloads used
	// to drive complex logic.
	ResponseMessages []*ResponseMessage `protobuf:"bytes,4,rep,name=response_messages,json=responseMessages,proto3" json:"response_messages,omitempty"`
	// The list of webhook ids in the order of call sequence.
	WebhookIds []string `protobuf:"bytes,25,rep,name=webhook_ids,json=webhookIds,proto3" json:"webhook_ids,omitempty"`
	// The list of webhook display names in the order of call sequence.
	WebhookDisplayNames []string `protobuf:"bytes,26,rep,name=webhook_display_names,json=webhookDisplayNames,proto3" json:"webhook_display_names,omitempty"`
	// The list of webhook latencies in the order of call sequence.
	WebhookLatencies []*durationpb.Duration `protobuf:"bytes,27,rep,name=webhook_latencies,json=webhookLatencies,proto3" json:"webhook_latencies,omitempty"`
	// The list of webhook tags in the order of call sequence.
	WebhookTags []string `protobuf:"bytes,29,rep,name=webhook_tags,json=webhookTags,proto3" json:"webhook_tags,omitempty"`
	// The list of webhook call status in the order of call sequence.
	WebhookStatuses []*status.Status `protobuf:"bytes,13,rep,name=webhook_statuses,json=webhookStatuses,proto3" json:"webhook_statuses,omitempty"`
	// The list of webhook payload in
	// [WebhookResponse.payload][google.cloud.dialogflow.cx.v3beta1.WebhookResponse.payload],
	// in the order of call sequence. If some webhook call fails or doesn't return
	// any payload, an empty `Struct` would be used instead.
	WebhookPayloads []*structpb.Struct `protobuf:"bytes,6,rep,name=webhook_payloads,json=webhookPayloads,proto3" json:"webhook_payloads,omitempty"`
	// The current [Page][google.cloud.dialogflow.cx.v3beta1.Page]. Some, not all
	// fields are filled in this message, including but not limited to `name` and
	// `display_name`.
	CurrentPage *Page `protobuf:"bytes,7,opt,name=current_page,json=currentPage,proto3" json:"current_page,omitempty"`
	// The current [Flow][google.cloud.dialogflow.cx.v3beta1.Flow]. Some, not all
	// fields are filled in this message, including but not limited to `name` and
	// `display_name`.
	CurrentFlow *Flow `protobuf:"bytes,31,opt,name=current_flow,json=currentFlow,proto3" json:"current_flow,omitempty"`
	// The [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] that matched the
	// conversational query. Some, not all fields are filled in this message,
	// including but not limited to: `name` and `display_name`. This field is
	// deprecated, please use
	// [QueryResult.match][google.cloud.dialogflow.cx.v3beta1.QueryResult.match]
	// instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/dialogflow/cx/v3beta1/session.proto.
	Intent *Intent `protobuf:"bytes,8,opt,name=intent,proto3" json:"intent,omitempty"`
	// The intent detection confidence. Values range from 0.0 (completely
	// uncertain) to 1.0 (completely certain).
	// This value is for informational purpose only and is only used to
	// help match the best intent within the classification threshold.
	// This value may change for the same end-user expression at any time due to a
	// model retraining or change in implementation.
	// This field is deprecated, please use
	// [QueryResult.match][google.cloud.dialogflow.cx.v3beta1.QueryResult.match]
	// instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/dialogflow/cx/v3beta1/session.proto.
	IntentDetectionConfidence float32 `protobuf:"fixed32,9,opt,name=intent_detection_confidence,json=intentDetectionConfidence,proto3" json:"intent_detection_confidence,omitempty"`
	// Intent match result, could be an intent or an event.
	Match *Match `protobuf:"bytes,15,opt,name=match,proto3" json:"match,omitempty"`
	// The free-form diagnostic info. For example, this field could contain
	// webhook call latency. The fields of this data can change without notice,
	// so you should not write code that depends on its structure.
	//
	// One of the fields is called "Alternative Matched Intents", which may
	// aid with debugging. The following describes these intent results:
	//
	//   - The list is empty if no intent was matched to end-user input.
	//   - Only intents that are referenced in the currently active flow are
	//     included.
	//   - The matched intent is included.
	//   - Other intents that could have matched end-user input, but did not match
	//     because they are referenced by intent routes that are out of
	//     [scope](https://cloud.google.com/dialogflow/cx/docs/concept/handler#scope),
	//     are included.
	//   - Other intents referenced by intent routes in scope that matched end-user
	//     input, but had a lower confidence score.
	DiagnosticInfo *structpb.Struct `protobuf:"bytes,10,opt,name=diagnostic_info,json=diagnosticInfo,proto3" json:"diagnostic_info,omitempty"`
	// The information of a query if handled by generative agent resources.
	GenerativeInfo *GenerativeInfo `protobuf:"bytes,33,opt,name=generative_info,json=generativeInfo,proto3" json:"generative_info,omitempty"`
	// The sentiment analyss result, which depends on
	// [`analyze_query_text_sentiment`]
	// [google.cloud.dialogflow.cx.v3beta1.QueryParameters.analyze_query_text_sentiment],
	// specified in the request.
	SentimentAnalysisResult *SentimentAnalysisResult `protobuf:"bytes,17,opt,name=sentiment_analysis_result,json=sentimentAnalysisResult,proto3" json:"sentiment_analysis_result,omitempty"`
	// Returns the current advanced settings including IVR settings. Even though
	// the operations configured by these settings are performed by Dialogflow,
	// the client may need to perform special logic at the moment. For example, if
	// Dialogflow exports audio to Google Cloud Storage, then the client may need
	// to wait for the resulting object to appear in the bucket before proceeding.
	AdvancedSettings *AdvancedSettings `protobuf:"bytes,21,opt,name=advanced_settings,json=advancedSettings,proto3" json:"advanced_settings,omitempty"`
	// Indicates whether the Thumbs up/Thumbs down rating controls are need to be
	// shown for the response in the Dialogflow Messenger widget.
	AllowAnswerFeedback bool `protobuf:"varint,32,opt,name=allow_answer_feedback,json=allowAnswerFeedback,proto3" json:"allow_answer_feedback,omitempty"`
	// Optional. Data store connection feature output signals.
	// Filled only when data stores are involved in serving the query and
	// DetectIntentRequest.populate data_store_connection_quality_signals is set
	// to true in the request.
	DataStoreConnectionSignals *DataStoreConnectionSignals `protobuf:"bytes,35,opt,name=data_store_connection_signals,json=dataStoreConnectionSignals,proto3" json:"data_store_connection_signals,omitempty"`
}

func (x *QueryResult) Reset() {
	*x = QueryResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryResult) ProtoMessage() {}

func (x *QueryResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryResult.ProtoReflect.Descriptor instead.
func (*QueryResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{15}
}

func (m *QueryResult) GetQuery() isQueryResult_Query {
	if m != nil {
		return m.Query
	}
	return nil
}

func (x *QueryResult) GetText() string {
	if x, ok := x.GetQuery().(*QueryResult_Text); ok {
		return x.Text
	}
	return ""
}

func (x *QueryResult) GetTriggerIntent() string {
	if x, ok := x.GetQuery().(*QueryResult_TriggerIntent); ok {
		return x.TriggerIntent
	}
	return ""
}

func (x *QueryResult) GetTranscript() string {
	if x, ok := x.GetQuery().(*QueryResult_Transcript); ok {
		return x.Transcript
	}
	return ""
}

func (x *QueryResult) GetTriggerEvent() string {
	if x, ok := x.GetQuery().(*QueryResult_TriggerEvent); ok {
		return x.TriggerEvent
	}
	return ""
}

func (x *QueryResult) GetDtmf() *DtmfInput {
	if x, ok := x.GetQuery().(*QueryResult_Dtmf); ok {
		return x.Dtmf
	}
	return nil
}

func (x *QueryResult) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *QueryResult) GetParameters() *structpb.Struct {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *QueryResult) GetResponseMessages() []*ResponseMessage {
	if x != nil {
		return x.ResponseMessages
	}
	return nil
}

func (x *QueryResult) GetWebhookIds() []string {
	if x != nil {
		return x.WebhookIds
	}
	return nil
}

func (x *QueryResult) GetWebhookDisplayNames() []string {
	if x != nil {
		return x.WebhookDisplayNames
	}
	return nil
}

func (x *QueryResult) GetWebhookLatencies() []*durationpb.Duration {
	if x != nil {
		return x.WebhookLatencies
	}
	return nil
}

func (x *QueryResult) GetWebhookTags() []string {
	if x != nil {
		return x.WebhookTags
	}
	return nil
}

func (x *QueryResult) GetWebhookStatuses() []*status.Status {
	if x != nil {
		return x.WebhookStatuses
	}
	return nil
}

func (x *QueryResult) GetWebhookPayloads() []*structpb.Struct {
	if x != nil {
		return x.WebhookPayloads
	}
	return nil
}

func (x *QueryResult) GetCurrentPage() *Page {
	if x != nil {
		return x.CurrentPage
	}
	return nil
}

func (x *QueryResult) GetCurrentFlow() *Flow {
	if x != nil {
		return x.CurrentFlow
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/dialogflow/cx/v3beta1/session.proto.
func (x *QueryResult) GetIntent() *Intent {
	if x != nil {
		return x.Intent
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/dialogflow/cx/v3beta1/session.proto.
func (x *QueryResult) GetIntentDetectionConfidence() float32 {
	if x != nil {
		return x.IntentDetectionConfidence
	}
	return 0
}

func (x *QueryResult) GetMatch() *Match {
	if x != nil {
		return x.Match
	}
	return nil
}

func (x *QueryResult) GetDiagnosticInfo() *structpb.Struct {
	if x != nil {
		return x.DiagnosticInfo
	}
	return nil
}

func (x *QueryResult) GetGenerativeInfo() *GenerativeInfo {
	if x != nil {
		return x.GenerativeInfo
	}
	return nil
}

func (x *QueryResult) GetSentimentAnalysisResult() *SentimentAnalysisResult {
	if x != nil {
		return x.SentimentAnalysisResult
	}
	return nil
}

func (x *QueryResult) GetAdvancedSettings() *AdvancedSettings {
	if x != nil {
		return x.AdvancedSettings
	}
	return nil
}

func (x *QueryResult) GetAllowAnswerFeedback() bool {
	if x != nil {
		return x.AllowAnswerFeedback
	}
	return false
}

func (x *QueryResult) GetDataStoreConnectionSignals() *DataStoreConnectionSignals {
	if x != nil {
		return x.DataStoreConnectionSignals
	}
	return nil
}

type isQueryResult_Query interface {
	isQueryResult_Query()
}

type QueryResult_Text struct {
	// If [natural language text][google.cloud.dialogflow.cx.v3beta1.TextInput]
	// was provided as input, this field will contain a copy of the text.
	Text string `protobuf:"bytes,1,opt,name=text,proto3,oneof"`
}

type QueryResult_TriggerIntent struct {
	// If an [intent][google.cloud.dialogflow.cx.v3beta1.IntentInput] was
	// provided as input, this field will contain a copy of the intent
	// identifier. Format: `projects/<Project ID>/locations/<Location
	// ID>/agents/<Agent ID>/intents/<Intent ID>`.
	TriggerIntent string `protobuf:"bytes,11,opt,name=trigger_intent,json=triggerIntent,proto3,oneof"`
}

type QueryResult_Transcript struct {
	// If [natural language speech
	// audio][google.cloud.dialogflow.cx.v3beta1.AudioInput] was provided as
	// input, this field will contain the transcript for the audio.
	Transcript string `protobuf:"bytes,12,opt,name=transcript,proto3,oneof"`
}

type QueryResult_TriggerEvent struct {
	// If an [event][google.cloud.dialogflow.cx.v3beta1.EventInput] was provided
	// as input, this field will contain the name of the event.
	TriggerEvent string `protobuf:"bytes,14,opt,name=trigger_event,json=triggerEvent,proto3,oneof"`
}

type QueryResult_Dtmf struct {
	// If a [DTMF][google.cloud.dialogflow.cx.v3beta1.DtmfInput] was provided as
	// input, this field will contain a copy of the
	// [DtmfInput][google.cloud.dialogflow.cx.v3beta1.DtmfInput].
	Dtmf *DtmfInput `protobuf:"bytes,23,opt,name=dtmf,proto3,oneof"`
}

func (*QueryResult_Text) isQueryResult_Query() {}

func (*QueryResult_TriggerIntent) isQueryResult_Query() {}

func (*QueryResult_Transcript) isQueryResult_Query() {}

func (*QueryResult_TriggerEvent) isQueryResult_Query() {}

func (*QueryResult_Dtmf) isQueryResult_Query() {}

// Represents the natural language text to be processed.
type TextInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The UTF-8 encoded natural language text to be processed.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
}

func (x *TextInput) Reset() {
	*x = TextInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextInput) ProtoMessage() {}

func (x *TextInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextInput.ProtoReflect.Descriptor instead.
func (*TextInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{16}
}

func (x *TextInput) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

// Represents the intent to trigger programmatically rather than as a result of
// natural language processing.
type IntentInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The unique identifier of the intent.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/intents/<Intent ID>`.
	Intent string `protobuf:"bytes,1,opt,name=intent,proto3" json:"intent,omitempty"`
}

func (x *IntentInput) Reset() {
	*x = IntentInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntentInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntentInput) ProtoMessage() {}

func (x *IntentInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntentInput.ProtoReflect.Descriptor instead.
func (*IntentInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{17}
}

func (x *IntentInput) GetIntent() string {
	if x != nil {
		return x.Intent
	}
	return ""
}

// Represents the natural speech audio to be processed.
type AudioInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Instructs the speech recognizer how to process the speech audio.
	Config *InputAudioConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// The natural language speech audio to be processed.
	// A single request can contain up to 2 minutes of speech audio data.
	// The [transcribed
	// text][google.cloud.dialogflow.cx.v3beta1.QueryResult.transcript] cannot
	// contain more than 256 bytes.
	//
	// For non-streaming audio detect intent, both `config` and `audio` must be
	// provided.
	// For streaming audio detect intent, `config` must be provided in
	// the first request and `audio` must be provided in all following requests.
	Audio []byte `protobuf:"bytes,2,opt,name=audio,proto3" json:"audio,omitempty"`
}

func (x *AudioInput) Reset() {
	*x = AudioInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AudioInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudioInput) ProtoMessage() {}

func (x *AudioInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudioInput.ProtoReflect.Descriptor instead.
func (*AudioInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{18}
}

func (x *AudioInput) GetConfig() *InputAudioConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *AudioInput) GetAudio() []byte {
	if x != nil {
		return x.Audio
	}
	return nil
}

// Represents the event to trigger.
type EventInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the event.
	Event string `protobuf:"bytes,1,opt,name=event,proto3" json:"event,omitempty"`
}

func (x *EventInput) Reset() {
	*x = EventInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventInput) ProtoMessage() {}

func (x *EventInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventInput.ProtoReflect.Descriptor instead.
func (*EventInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{19}
}

func (x *EventInput) GetEvent() string {
	if x != nil {
		return x.Event
	}
	return ""
}

// Represents the input for dtmf event.
type DtmfInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The dtmf digits.
	Digits string `protobuf:"bytes,1,opt,name=digits,proto3" json:"digits,omitempty"`
	// The finish digit (if any).
	FinishDigit string `protobuf:"bytes,2,opt,name=finish_digit,json=finishDigit,proto3" json:"finish_digit,omitempty"`
}

func (x *DtmfInput) Reset() {
	*x = DtmfInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DtmfInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DtmfInput) ProtoMessage() {}

func (x *DtmfInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DtmfInput.ProtoReflect.Descriptor instead.
func (*DtmfInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{20}
}

func (x *DtmfInput) GetDigits() string {
	if x != nil {
		return x.Digits
	}
	return ""
}

func (x *DtmfInput) GetFinishDigit() string {
	if x != nil {
		return x.FinishDigit
	}
	return ""
}

// Represents one match result of [MatchIntent][].
type Match struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] that matched the
	// query. Some, not all fields are filled in this message, including but not
	// limited to: `name` and `display_name`. Only filled for
	// [`INTENT`][google.cloud.dialogflow.cx.v3beta1.Match.MatchType] match type.
	Intent *Intent `protobuf:"bytes,1,opt,name=intent,proto3" json:"intent,omitempty"`
	// The event that matched the query. Filled for
	// [`EVENT`][google.cloud.dialogflow.cx.v3beta1.Match.MatchType],
	// [`NO_MATCH`][google.cloud.dialogflow.cx.v3beta1.Match.MatchType] and
	// [`NO_INPUT`][google.cloud.dialogflow.cx.v3beta1.Match.MatchType] match
	// types.
	Event string `protobuf:"bytes,6,opt,name=event,proto3" json:"event,omitempty"`
	// The collection of parameters extracted from the query.
	//
	// Depending on your protocol or client library language, this is a
	// map, associative array, symbol table, dictionary, or JSON object
	// composed of a collection of (MapKey, MapValue) pairs:
	//
	// * MapKey type: string
	// * MapKey value: parameter name
	// * MapValue type: If parameter's entity type is a composite entity then use
	// map, otherwise, depending on the parameter value type, it could be one of
	// string, number, boolean, null, list or map.
	// * MapValue value: If parameter's entity type is a composite entity then use
	// map from composite entity property names to property values, otherwise,
	// use parameter value.
	Parameters *structpb.Struct `protobuf:"bytes,2,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// Final text input which was matched during MatchIntent. This value can be
	// different from original input sent in request because of spelling
	// correction or other processing.
	ResolvedInput string `protobuf:"bytes,3,opt,name=resolved_input,json=resolvedInput,proto3" json:"resolved_input,omitempty"`
	// Type of this [Match][google.cloud.dialogflow.cx.v3beta1.Match].
	MatchType Match_MatchType `protobuf:"varint,4,opt,name=match_type,json=matchType,proto3,enum=google.cloud.dialogflow.cx.v3beta1.Match_MatchType" json:"match_type,omitempty"`
	// The confidence of this match. Values range from 0.0 (completely uncertain)
	// to 1.0 (completely certain).
	// This value is for informational purpose only and is only used to help match
	// the best intent within the classification threshold. This value may change
	// for the same end-user expression at any time due to a model retraining or
	// change in implementation.
	Confidence float32 `protobuf:"fixed32,5,opt,name=confidence,proto3" json:"confidence,omitempty"`
}

func (x *Match) Reset() {
	*x = Match{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Match) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Match) ProtoMessage() {}

func (x *Match) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Match.ProtoReflect.Descriptor instead.
func (*Match) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{21}
}

func (x *Match) GetIntent() *Intent {
	if x != nil {
		return x.Intent
	}
	return nil
}

func (x *Match) GetEvent() string {
	if x != nil {
		return x.Event
	}
	return ""
}

func (x *Match) GetParameters() *structpb.Struct {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *Match) GetResolvedInput() string {
	if x != nil {
		return x.ResolvedInput
	}
	return ""
}

func (x *Match) GetMatchType() Match_MatchType {
	if x != nil {
		return x.MatchType
	}
	return Match_MATCH_TYPE_UNSPECIFIED
}

func (x *Match) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

// Request of [MatchIntent][].
type MatchIntentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the session this query is sent to.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/sessions/<Session ID>` or `projects/<Project ID>/locations/<Location
	// ID>/agents/<Agent ID>/environments/<Environment ID>/sessions/<Session ID>`.
	// If `Environment ID` is not specified, we assume default 'draft'
	// environment.
	// It's up to the API caller to choose an appropriate `Session ID`. It can be
	// a random number or some type of session identifiers (preferably hashed).
	// The length of the `Session ID` must not exceed 36 characters.
	//
	// For more information, see the [sessions
	// guide](https://cloud.google.com/dialogflow/cx/docs/concept/session).
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// The parameters of this query.
	QueryParams *QueryParameters `protobuf:"bytes,2,opt,name=query_params,json=queryParams,proto3" json:"query_params,omitempty"`
	// Required. The input specification.
	QueryInput *QueryInput `protobuf:"bytes,3,opt,name=query_input,json=queryInput,proto3" json:"query_input,omitempty"`
	// Persist session parameter changes from `query_params`.
	PersistParameterChanges bool `protobuf:"varint,5,opt,name=persist_parameter_changes,json=persistParameterChanges,proto3" json:"persist_parameter_changes,omitempty"`
}

func (x *MatchIntentRequest) Reset() {
	*x = MatchIntentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MatchIntentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MatchIntentRequest) ProtoMessage() {}

func (x *MatchIntentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MatchIntentRequest.ProtoReflect.Descriptor instead.
func (*MatchIntentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{22}
}

func (x *MatchIntentRequest) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (x *MatchIntentRequest) GetQueryParams() *QueryParameters {
	if x != nil {
		return x.QueryParams
	}
	return nil
}

func (x *MatchIntentRequest) GetQueryInput() *QueryInput {
	if x != nil {
		return x.QueryInput
	}
	return nil
}

func (x *MatchIntentRequest) GetPersistParameterChanges() bool {
	if x != nil {
		return x.PersistParameterChanges
	}
	return false
}

// Response of [MatchIntent][].
type MatchIntentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The original conversational query.
	//
	// Types that are assignable to Query:
	//
	//	*MatchIntentResponse_Text
	//	*MatchIntentResponse_TriggerIntent
	//	*MatchIntentResponse_Transcript
	//	*MatchIntentResponse_TriggerEvent
	Query isMatchIntentResponse_Query `protobuf_oneof:"query"`
	// Match results, if more than one, ordered descendingly by the confidence
	// we have that the particular intent matches the query.
	Matches []*Match `protobuf:"bytes,4,rep,name=matches,proto3" json:"matches,omitempty"`
	// The current [Page][google.cloud.dialogflow.cx.v3beta1.Page]. Some, not all
	// fields are filled in this message, including but not limited to `name` and
	// `display_name`.
	CurrentPage *Page `protobuf:"bytes,5,opt,name=current_page,json=currentPage,proto3" json:"current_page,omitempty"`
}

func (x *MatchIntentResponse) Reset() {
	*x = MatchIntentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MatchIntentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MatchIntentResponse) ProtoMessage() {}

func (x *MatchIntentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MatchIntentResponse.ProtoReflect.Descriptor instead.
func (*MatchIntentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{23}
}

func (m *MatchIntentResponse) GetQuery() isMatchIntentResponse_Query {
	if m != nil {
		return m.Query
	}
	return nil
}

func (x *MatchIntentResponse) GetText() string {
	if x, ok := x.GetQuery().(*MatchIntentResponse_Text); ok {
		return x.Text
	}
	return ""
}

func (x *MatchIntentResponse) GetTriggerIntent() string {
	if x, ok := x.GetQuery().(*MatchIntentResponse_TriggerIntent); ok {
		return x.TriggerIntent
	}
	return ""
}

func (x *MatchIntentResponse) GetTranscript() string {
	if x, ok := x.GetQuery().(*MatchIntentResponse_Transcript); ok {
		return x.Transcript
	}
	return ""
}

func (x *MatchIntentResponse) GetTriggerEvent() string {
	if x, ok := x.GetQuery().(*MatchIntentResponse_TriggerEvent); ok {
		return x.TriggerEvent
	}
	return ""
}

func (x *MatchIntentResponse) GetMatches() []*Match {
	if x != nil {
		return x.Matches
	}
	return nil
}

func (x *MatchIntentResponse) GetCurrentPage() *Page {
	if x != nil {
		return x.CurrentPage
	}
	return nil
}

type isMatchIntentResponse_Query interface {
	isMatchIntentResponse_Query()
}

type MatchIntentResponse_Text struct {
	// If [natural language text][google.cloud.dialogflow.cx.v3beta1.TextInput]
	// was provided as input, this field will contain a copy of the text.
	Text string `protobuf:"bytes,1,opt,name=text,proto3,oneof"`
}

type MatchIntentResponse_TriggerIntent struct {
	// If an [intent][google.cloud.dialogflow.cx.v3beta1.IntentInput] was
	// provided as input, this field will contain a copy of the intent
	// identifier. Format: `projects/<Project ID>/locations/<Location
	// ID>/agents/<Agent ID>/intents/<Intent ID>`.
	TriggerIntent string `protobuf:"bytes,2,opt,name=trigger_intent,json=triggerIntent,proto3,oneof"`
}

type MatchIntentResponse_Transcript struct {
	// If [natural language speech
	// audio][google.cloud.dialogflow.cx.v3beta1.AudioInput] was provided as
	// input, this field will contain the transcript for the audio.
	Transcript string `protobuf:"bytes,3,opt,name=transcript,proto3,oneof"`
}

type MatchIntentResponse_TriggerEvent struct {
	// If an [event][google.cloud.dialogflow.cx.v3beta1.EventInput] was provided
	// as input, this field will contain a copy of the event name.
	TriggerEvent string `protobuf:"bytes,6,opt,name=trigger_event,json=triggerEvent,proto3,oneof"`
}

func (*MatchIntentResponse_Text) isMatchIntentResponse_Query() {}

func (*MatchIntentResponse_TriggerIntent) isMatchIntentResponse_Query() {}

func (*MatchIntentResponse_Transcript) isMatchIntentResponse_Query() {}

func (*MatchIntentResponse_TriggerEvent) isMatchIntentResponse_Query() {}

// Request of [FulfillIntent][]
type FulfillIntentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Must be same as the corresponding MatchIntent request, otherwise the
	// behavior is undefined.
	MatchIntentRequest *MatchIntentRequest `protobuf:"bytes,1,opt,name=match_intent_request,json=matchIntentRequest,proto3" json:"match_intent_request,omitempty"`
	// The matched intent/event to fulfill.
	Match *Match `protobuf:"bytes,2,opt,name=match,proto3" json:"match,omitempty"`
	// Instructs the speech synthesizer how to generate output audio.
	OutputAudioConfig *OutputAudioConfig `protobuf:"bytes,3,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
}

func (x *FulfillIntentRequest) Reset() {
	*x = FulfillIntentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FulfillIntentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FulfillIntentRequest) ProtoMessage() {}

func (x *FulfillIntentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FulfillIntentRequest.ProtoReflect.Descriptor instead.
func (*FulfillIntentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{24}
}

func (x *FulfillIntentRequest) GetMatchIntentRequest() *MatchIntentRequest {
	if x != nil {
		return x.MatchIntentRequest
	}
	return nil
}

func (x *FulfillIntentRequest) GetMatch() *Match {
	if x != nil {
		return x.Match
	}
	return nil
}

func (x *FulfillIntentRequest) GetOutputAudioConfig() *OutputAudioConfig {
	if x != nil {
		return x.OutputAudioConfig
	}
	return nil
}

// Response of [FulfillIntent][]
type FulfillIntentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The unique identifier of the response. It can be used to
	// locate a response in the training example set or for reporting issues.
	ResponseId string `protobuf:"bytes,1,opt,name=response_id,json=responseId,proto3" json:"response_id,omitempty"`
	// The result of the conversational query.
	QueryResult *QueryResult `protobuf:"bytes,2,opt,name=query_result,json=queryResult,proto3" json:"query_result,omitempty"`
	// The audio data bytes encoded as specified in the request.
	// Note: The output audio is generated based on the values of default platform
	// text responses found in the
	// [`query_result.response_messages`][google.cloud.dialogflow.cx.v3beta1.QueryResult.response_messages]
	// field. If multiple default text responses exist, they will be concatenated
	// when generating audio. If no default platform text responses exist, the
	// generated audio content will be empty.
	//
	// In some scenarios, multiple output audio fields may be present in the
	// response structure. In these cases, only the top-most-level audio output
	// has content.
	OutputAudio []byte `protobuf:"bytes,3,opt,name=output_audio,json=outputAudio,proto3" json:"output_audio,omitempty"`
	// The config used by the speech synthesizer to generate the output audio.
	OutputAudioConfig *OutputAudioConfig `protobuf:"bytes,4,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
}

func (x *FulfillIntentResponse) Reset() {
	*x = FulfillIntentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FulfillIntentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FulfillIntentResponse) ProtoMessage() {}

func (x *FulfillIntentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FulfillIntentResponse.ProtoReflect.Descriptor instead.
func (*FulfillIntentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{25}
}

func (x *FulfillIntentResponse) GetResponseId() string {
	if x != nil {
		return x.ResponseId
	}
	return ""
}

func (x *FulfillIntentResponse) GetQueryResult() *QueryResult {
	if x != nil {
		return x.QueryResult
	}
	return nil
}

func (x *FulfillIntentResponse) GetOutputAudio() []byte {
	if x != nil {
		return x.OutputAudio
	}
	return nil
}

func (x *FulfillIntentResponse) GetOutputAudioConfig() *OutputAudioConfig {
	if x != nil {
		return x.OutputAudioConfig
	}
	return nil
}

// The result of sentiment analysis. Sentiment analysis inspects user input
// and identifies the prevailing subjective opinion, especially to determine a
// user's attitude as positive, negative, or neutral.
type SentimentAnalysisResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sentiment score between -1.0 (negative sentiment) and 1.0 (positive
	// sentiment).
	Score float32 `protobuf:"fixed32,1,opt,name=score,proto3" json:"score,omitempty"`
	// A non-negative number in the [0, +inf) range, which represents the absolute
	// magnitude of sentiment, regardless of score (positive or negative).
	Magnitude float32 `protobuf:"fixed32,2,opt,name=magnitude,proto3" json:"magnitude,omitempty"`
}

func (x *SentimentAnalysisResult) Reset() {
	*x = SentimentAnalysisResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SentimentAnalysisResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SentimentAnalysisResult) ProtoMessage() {}

func (x *SentimentAnalysisResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SentimentAnalysisResult.ProtoReflect.Descriptor instead.
func (*SentimentAnalysisResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{26}
}

func (x *SentimentAnalysisResult) GetScore() float32 {
	if x != nil {
		return x.Score
	}
	return 0
}

func (x *SentimentAnalysisResult) GetMagnitude() float32 {
	if x != nil {
		return x.Magnitude
	}
	return 0
}

// Stores extra information about why users provided thumbs down rating.
type AnswerFeedback_RatingReason struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Custom reason labels for thumbs down rating provided by the
	// user. The maximum number of labels allowed is 10 and the maximum length
	// of a single label is 128 characters.
	ReasonLabels []string `protobuf:"bytes,3,rep,name=reason_labels,json=reasonLabels,proto3" json:"reason_labels,omitempty"`
	// Optional. Additional feedback about the rating.
	// This field can be populated without choosing a predefined `reason`.
	Feedback string `protobuf:"bytes,2,opt,name=feedback,proto3" json:"feedback,omitempty"`
}

func (x *AnswerFeedback_RatingReason) Reset() {
	*x = AnswerFeedback_RatingReason{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnswerFeedback_RatingReason) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnswerFeedback_RatingReason) ProtoMessage() {}

func (x *AnswerFeedback_RatingReason) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnswerFeedback_RatingReason.ProtoReflect.Descriptor instead.
func (*AnswerFeedback_RatingReason) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{0, 0}
}

func (x *AnswerFeedback_RatingReason) GetReasonLabels() []string {
	if x != nil {
		return x.ReasonLabels
	}
	return nil
}

func (x *AnswerFeedback_RatingReason) GetFeedback() string {
	if x != nil {
		return x.Feedback
	}
	return ""
}

// Boost applies to documents which match a condition.
type BoostSpec_ConditionBoostSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. An expression which specifies a boost condition. The syntax and
	// supported fields are the same as a filter expression.
	// Examples:
	//
	// * To boost documents with document ID "doc_1" or "doc_2", and
	// color
	//
	//	"Red" or "Blue":
	//	  * (id: ANY("doc_1", "doc_2")) AND (color: ANY("Red","Blue"))
	Condition string `protobuf:"bytes,1,opt,name=condition,proto3" json:"condition,omitempty"`
	// Optional. Strength of the condition boost, which should be in [-1, 1].
	// Negative boost means demotion. Default is 0.0.
	//
	// Setting to 1.0 gives the document a big promotion. However, it does not
	// necessarily mean that the boosted document will be the top result at
	// all times, nor that other documents will be excluded. Results could
	// still be shown even when none of them matches the condition. And
	// results that are significantly more relevant to the search query can
	// still trump your heavily favored but irrelevant documents.
	//
	// Setting to -1.0 gives the document a big demotion. However, results
	// that are deeply relevant might still be shown. The document will have
	// an upstream battle to get a fairly high ranking, but it is not blocked
	// out completely.
	//
	// Setting to 0.0 means no boost applied. The boosting condition is
	// ignored.
	Boost float32 `protobuf:"fixed32,2,opt,name=boost,proto3" json:"boost,omitempty"`
}

func (x *BoostSpec_ConditionBoostSpec) Reset() {
	*x = BoostSpec_ConditionBoostSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoostSpec_ConditionBoostSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoostSpec_ConditionBoostSpec) ProtoMessage() {}

func (x *BoostSpec_ConditionBoostSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoostSpec_ConditionBoostSpec.ProtoReflect.Descriptor instead.
func (*BoostSpec_ConditionBoostSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{10, 0}
}

func (x *BoostSpec_ConditionBoostSpec) GetCondition() string {
	if x != nil {
		return x.Condition
	}
	return ""
}

func (x *BoostSpec_ConditionBoostSpec) GetBoost() float32 {
	if x != nil {
		return x.Boost
	}
	return 0
}

var File_google_cloud_dialogflow_cx_v3beta1_session_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x64,
	0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63,
	0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x70, 0x61, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x39, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f,
	0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78,
	0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x63, 0x61,
	0x6c, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6c,
	0x61, 0x74, 0x6c, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x9a, 0x03, 0x0a, 0x0e,
	0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x12, 0x56,
	0x0a, 0x06, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61,
	0x63, 0x6b, 0x2e, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x69, 0x0a, 0x0d, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63,
	0x6b, 0x2e, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0c, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x72, 0x61, 0x74, 0x69,
	0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x1a, 0x59, 0x0a, 0x0c, 0x52,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x72,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x1f, 0x0a, 0x08, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x66, 0x65,
	0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x22, 0x40, 0x0a, 0x06, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x12, 0x16, 0x0a, 0x12, 0x52, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x54, 0x48, 0x55, 0x4d,
	0x42, 0x53, 0x5f, 0x55, 0x50, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x54, 0x48, 0x55, 0x4d, 0x42,
	0x53, 0x5f, 0x44, 0x4f, 0x57, 0x4e, 0x10, 0x02, 0x22, 0xac, 0x02, 0x0a, 0x1b, 0x53, 0x75, 0x62,
	0x6d, 0x69, 0x74, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63,
	0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x23, 0x0a, 0x21, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a,
	0x0b, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x49, 0x64, 0x12, 0x60, 0x0a, 0x0f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x66, 0x65,
	0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x46, 0x65, 0x65,
	0x64, 0x62, 0x61, 0x63, 0x6b, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xef, 0x02, 0x0a, 0x13, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x43, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52,
	0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x54, 0x0a, 0x0b,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x12, 0x65, 0x0a, 0x13, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x75, 0x64,
	0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75,
	0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xf7, 0x03, 0x0a, 0x14, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x49, 0x64, 0x12, 0x52, 0x0a, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x0b, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x12, 0x65, 0x0a, 0x13, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x6a, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x0c, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2d, 0x0a,
	0x12, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x45, 0x0a, 0x0c,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19,
	0x52, 0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50,
	0x41, 0x52, 0x54, 0x49, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x46, 0x49, 0x4e, 0x41,
	0x4c, 0x10, 0x02, 0x22, 0xe1, 0x03, 0x0a, 0x1c, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e,
	0x67, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x52, 0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x54,
	0x0a, 0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x12, 0x65, 0x0a, 0x13, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x61,
	0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64,
	0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x36, 0x0a, 0x17, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x32, 0x0a, 0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x65,
	0x62, 0x75, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x13, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x65, 0x62, 0x75, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0xd5, 0x0a, 0x0a, 0x1e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x62,
	0x75, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2a, 0x0a, 0x11, 0x61, 0x75,
	0x64, 0x69, 0x6f, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x44, 0x61, 0x74, 0x61,
	0x43, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x12, 0x4e, 0x0a, 0x16, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x13, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65,
	0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x4b, 0x0a, 0x14, 0x66, 0x69, 0x72, 0x73, 0x74, 0x5f,
	0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x12, 0x66, 0x69, 0x72, 0x73, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x29, 0x0a, 0x10, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x75, 0x74,
	0x74, 0x65, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x73,
	0x69, 0x6e, 0x67, 0x6c, 0x65, 0x55, 0x74, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x61,
	0x0a, 0x20, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x1c, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x61, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x12, 0x5d, 0x0a, 0x1e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x66, 0x69, 0x6e, 0x61,
	0x6c, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x1a, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x46, 0x69, 0x6e, 0x61,
	0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x12, 0x2b, 0x0a, 0x11, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x12, 0x4d, 0x0a,
	0x24, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x5f, 0x70, 0x61, 0x73, 0x73,
	0x69, 0x76, 0x65, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x6d, 0x73, 0x5f, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x1f, 0x73, 0x70, 0x65,
	0x61, 0x6b, 0x65, 0x72, 0x49, 0x64, 0x50, 0x61, 0x73, 0x73, 0x69, 0x76, 0x65, 0x4c, 0x61, 0x74,
	0x65, 0x6e, 0x63, 0x79, 0x4d, 0x73, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x36, 0x0a, 0x17,
	0x62, 0x61, 0x72, 0x67, 0x65, 0x69, 0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x65, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x62,
	0x61, 0x72, 0x67, 0x65, 0x69, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x72, 0x69, 0x67, 0x67,
	0x65, 0x72, 0x65, 0x64, 0x12, 0x36, 0x0a, 0x17, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x73,
	0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x75, 0x74, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x53, 0x69, 0x6e,
	0x67, 0x6c, 0x65, 0x55, 0x74, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x56, 0x0a, 0x1a,
	0x64, 0x74, 0x6d, 0x66, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x17, 0x64, 0x74, 0x6d,
	0x66, 0x50, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x12, 0x52, 0x0a, 0x18, 0x64, 0x74, 0x6d, 0x66, 0x5f, 0x66, 0x69, 0x6e,
	0x61, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x15, 0x64, 0x74, 0x6d, 0x66, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x12, 0x61, 0x0a, 0x20, 0x73, 0x69, 0x6e, 0x67,
	0x6c, 0x65, 0x5f, 0x75, 0x74, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x65, 0x6e, 0x64,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x1c, 0x73,
	0x69, 0x6e, 0x67, 0x6c, 0x65, 0x55, 0x74, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x45, 0x6e,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x45, 0x0a, 0x11, 0x6e,
	0x6f, 0x5f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74,
	0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0f, 0x6e, 0x6f, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x54, 0x69, 0x6d, 0x65, 0x6f,
	0x75, 0x74, 0x12, 0x4a, 0x0a, 0x13, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x69, 0x6e,
	0x67, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x69, 0x6e, 0x67, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x22,
	0x0a, 0x0d, 0x69, 0x73, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18,
	0x10, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x69, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x54, 0x65,
	0x78, 0x74, 0x12, 0x5b, 0x0a, 0x1d, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x68, 0x61, 0x6c,
	0x66, 0x5f, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66,
	0x73, 0x65, 0x74, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x19, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6c, 0x66,
	0x43, 0x6c, 0x6f, 0x73, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12,
	0x6e, 0x0a, 0x27, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x68, 0x61, 0x6c, 0x66, 0x5f, 0x63,
	0x6c, 0x6f, 0x73, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x22, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x48, 0x61, 0x6c, 0x66, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x69, 0x6e, 0x67, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22,
	0xf9, 0x02, 0x0a, 0x1d, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x6f, 0x0a, 0x12, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63, 0x6f,
	0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52,
	0x11, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x70, 0x0a, 0x16, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x14,
	0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x69, 0x0a, 0x0e, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x65, 0x62, 0x75, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x0d, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x42,
	0x0a, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xa8, 0x04, 0x0a, 0x1a,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x6d, 0x0a, 0x0c, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52,
	0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x69, 0x73, 0x5f,
	0x66, 0x69, 0x6e, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x69, 0x73, 0x46,
	0x69, 0x6e, 0x61, 0x6c, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e,
	0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64,
	0x65, 0x6e, 0x63, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x74, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x02, 0x52, 0x09, 0x73, 0x74, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x12, 0x5c, 0x0a, 0x10, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x77, 0x6f, 0x72,
	0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x57, 0x6f, 0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x0e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x57, 0x6f, 0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x45, 0x0a, 0x11, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x45, 0x6e,
	0x64, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x58, 0x0a, 0x0b,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x4d,
	0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x54, 0x52, 0x41,
	0x4e, 0x53, 0x43, 0x52, 0x49, 0x50, 0x54, 0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x45, 0x4e, 0x44,
	0x5f, 0x4f, 0x46, 0x5f, 0x53, 0x49, 0x4e, 0x47, 0x4c, 0x45, 0x5f, 0x55, 0x54, 0x54, 0x45, 0x52,
	0x41, 0x4e, 0x43, 0x45, 0x10, 0x02, 0x22, 0x89, 0x0a, 0x0a, 0x0f, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x69,
	0x6d, 0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74,
	0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x36, 0x0a, 0x0c, 0x67, 0x65, 0x6f, 0x5f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74, 0x4c,
	0x6e, 0x67, 0x52, 0x0b, 0x67, 0x65, 0x6f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x67, 0x0a, 0x14, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x12, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x31, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x37, 0x0a, 0x0a, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x12, 0x46, 0x0a, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xfa, 0x41, 0x20, 0x0a,
	0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x67, 0x65, 0x52,
	0x0b, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x67, 0x65, 0x12, 0x27, 0x0a, 0x0f,
	0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x57, 0x65,
	0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x12, 0x3f, 0x0a, 0x1c, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x65, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x19, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x7a, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54, 0x65, 0x78, 0x74, 0x53, 0x65, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x70, 0x0a, 0x0f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f,
	0x6b, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x2e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0e, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f,
	0x6b, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x4b, 0x0a, 0x0d, 0x66, 0x6c, 0x6f, 0x77,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x66, 0x6c, 0x6f, 0x77, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x55, 0x0a, 0x10, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74,
	0x5f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2a, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x0f, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x12, 0x67, 0x0a, 0x12,
	0x6c, 0x6c, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x6c,
	0x6d, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x10, 0x6c, 0x6c, 0x6d, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12,
	0x3f, 0x0a, 0x0b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x74, 0x6c, 0x18, 0x10,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x74, 0x6c,
	0x12, 0x48, 0x0a, 0x11, 0x65, 0x6e, 0x64, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x65, 0x6e, 0x64, 0x55, 0x73,
	0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5a, 0x0a, 0x0d, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x14, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x57, 0x0a, 0x26, 0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61,
	0x74, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73,
	0x18, 0x19, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x22, 0x70, 0x6f, 0x70,
	0x75, 0x6c, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x1a,
	0x41, 0x0a, 0x13, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0xbd, 0x01, 0x0a, 0x0c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x54, 0x0a, 0x0b, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x6f,
	0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x62,
	0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x73, 0x12, 0x57, 0x0a, 0x0c, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x73,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65,
	0x63, 0x73, 0x22, 0xda, 0x01, 0x0a, 0x09, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x79, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x62, 0x6f,
	0x6f, 0x73, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x43,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65,
	0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x73, 0x1a, 0x52, 0x0a, 0x12, 0x43,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65,
	0x63, 0x12, 0x21, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x05, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x22,
	0xa7, 0x01, 0x0a, 0x0a, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x73, 0x12, 0x51,
	0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x73, 0x12, 0x46, 0x0a, 0x04, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x04, 0x73, 0x70, 0x65, 0x63, 0x22, 0x7d, 0x0a, 0x0b, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x73, 0x12, 0x51, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x30, 0xe0,
	0x41, 0x01, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52,
	0x0a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0x1b, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x84, 0x04, 0x0a, 0x0a, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x49, 0x0a, 0x06,
	0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52,
	0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x46, 0x0a, 0x05, 0x61, 0x75, 0x64, 0x69, 0x6f,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x64, 0x69,
	0x6f, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x05, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x12,
	0x46, 0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00,
	0x52, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x64, 0x74, 0x6d, 0x66, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x74, 0x6d, 0x66, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x04, 0x64, 0x74, 0x6d, 0x66, 0x12, 0x5e, 0x0a, 0x10,
	0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c,
	0x43, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x74, 0x6f,
	0x6f, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x28, 0x0a, 0x0d,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x22,
	0x9a, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x2b, 0x0a, 0x11, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x6c,
	0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x12,
	0x5b, 0x0a, 0x13, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x69, 0x6e,
	0x67, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x11, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0xac, 0x0d, 0x0a,
	0x0b, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x14, 0x0a, 0x04,
	0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x74, 0x65,
	0x78, 0x74, 0x12, 0x4e, 0x0a, 0x0e, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xfa, 0x41, 0x22, 0x0a,
	0x20, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x48, 0x00, 0x52, 0x0d, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x49, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x12, 0x20, 0x0a, 0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x12, 0x25, 0x0a, 0x0d, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x74,
	0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x64,
	0x74, 0x6d, 0x66, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44,
	0x74, 0x6d, 0x66, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x04, 0x64, 0x74, 0x6d, 0x66,
	0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x37, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x60,
	0x0a, 0x11, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x10,
	0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73,
	0x12, 0x1f, 0x0a, 0x0b, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x69, 0x64, 0x73, 0x18,
	0x19, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x49, 0x64,
	0x73, 0x12, 0x32, 0x0a, 0x15, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x1a, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x13, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x46, 0x0a, 0x11, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b,
	0x5f, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x1b, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x77, 0x65, 0x62,
	0x68, 0x6f, 0x6f, 0x6b, 0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0x21, 0x0a,
	0x0c, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x1d, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0b, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x61, 0x67, 0x73,
	0x12, 0x3d, 0x0a, 0x10, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x65, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0f,
	0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x12,
	0x42, 0x0a, 0x10, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x52, 0x0f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x73, 0x12, 0x4b, 0x0a, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50,
	0x61, 0x67, 0x65, 0x52, 0x0b, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x12, 0x4b, 0x0a, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x6c, 0x6f, 0x77,
	0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x6c, 0x6f, 0x77,
	0x52, 0x0b, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x46, 0x6c, 0x6f, 0x77, 0x12, 0x46, 0x0a,
	0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x02, 0x18, 0x01, 0x52, 0x06, 0x69,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x42, 0x0a, 0x1b, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f,
	0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64,
	0x65, 0x6e, 0x63, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x02, 0x42, 0x02, 0x18, 0x01, 0x52, 0x19,
	0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x3f, 0x0a, 0x05, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x52, 0x05, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x40, 0x0a, 0x0f, 0x64, 0x69,
	0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0e, 0x64, 0x69,
	0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x5b, 0x0a, 0x0f,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18,
	0x21, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0e, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x77, 0x0a, 0x19, 0x73, 0x65, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x17, 0x73, 0x65, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x61, 0x0a, 0x11, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x10, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x61,
	0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x18, 0x20,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x41, 0x6e, 0x73, 0x77, 0x65,
	0x72, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x12, 0x86, 0x01, 0x0a, 0x1d, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x18, 0x23, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x69, 0x67, 0x6e, 0x61,
	0x6c, 0x73, 0x42, 0x07, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x22, 0x24, 0x0a, 0x09, 0x54,
	0x65, 0x78, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x65, 0x78,
	0x74, 0x22, 0x4f, 0x0a, 0x0b, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x12, 0x40, 0x0a, 0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x69, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x22, 0x75, 0x0a, 0x0a, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x12, 0x51, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x14, 0x0a, 0x05, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x05, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x22, 0x22, 0x0a, 0x0a, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x46, 0x0a,
	0x09, 0x44, 0x74, 0x6d, 0x66, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x69,
	0x67, 0x69, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x69, 0x67, 0x69,
	0x74, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x5f, 0x64, 0x69, 0x67,
	0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68,
	0x44, 0x69, 0x67, 0x69, 0x74, 0x22, 0xe3, 0x03, 0x0a, 0x05, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12,
	0x42, 0x0a, 0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x69, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x37, 0x0a, 0x0a, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x5f, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x6f,
	0x6c, 0x76, 0x65, 0x64, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x52, 0x0a, 0x0a, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x09, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a,
	0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xab, 0x01,
	0x0a, 0x09, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x4d,
	0x41, 0x54, 0x43, 0x48, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x49, 0x4e, 0x54, 0x45, 0x4e,
	0x54, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x5f, 0x49, 0x4e,
	0x54, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x41, 0x52, 0x41, 0x4d, 0x45,
	0x54, 0x45, 0x52, 0x5f, 0x46, 0x49, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a,
	0x08, 0x4e, 0x4f, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x4e,
	0x4f, 0x5f, 0x49, 0x4e, 0x50, 0x55, 0x54, 0x10, 0x05, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x56, 0x45,
	0x4e, 0x54, 0x10, 0x06, 0x12, 0x17, 0x0a, 0x13, 0x4b, 0x4e, 0x4f, 0x57, 0x4c, 0x45, 0x44, 0x47,
	0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x4f, 0x52, 0x10, 0x08, 0x12, 0x0c, 0x0a,
	0x08, 0x50, 0x4c, 0x41, 0x59, 0x42, 0x4f, 0x4f, 0x4b, 0x10, 0x09, 0x22, 0xc3, 0x02, 0x0a, 0x12,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x43, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x52, 0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12,
	0x54, 0x0a, 0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x3a, 0x0a, 0x19, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74,
	0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x17, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73,
	0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x73, 0x22, 0xdf, 0x02, 0x0a, 0x13, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x14, 0x0a, 0x04, 0x74, 0x65, 0x78,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12,
	0x4e, 0x0a, 0x0e, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x48, 0x00,
	0x52, 0x0d, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12,
	0x20, 0x0a, 0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x12, 0x25, 0x0a, 0x0d, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x74, 0x72, 0x69, 0x67,
	0x67, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x43, 0x0a, 0x07, 0x6d, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x52, 0x07, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x12, 0x4b, 0x0a,
	0x0c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x52, 0x0b, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x67, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x22, 0xa8, 0x02, 0x0a, 0x14, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x49,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x68, 0x0a, 0x14,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x52, 0x12, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x05, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x52, 0x05, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x65, 0x0a, 0x13, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x96,
	0x02, 0x0a, 0x15, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x49, 0x64, 0x12, 0x52, 0x0a, 0x0c, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x52, 0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x21, 0x0a,
	0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x0b, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f,
	0x12, 0x65, 0x0a, 0x13, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69,
	0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x4d, 0x0a, 0x17, 0x53, 0x65, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x02, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x6d, 0x61, 0x67, 0x6e,
	0x69, 0x74, 0x75, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x09, 0x6d, 0x61, 0x67,
	0x6e, 0x69, 0x74, 0x75, 0x64, 0x65, 0x32, 0xe3, 0x0e, 0x0a, 0x08, 0x53, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0xba, 0x02, 0x0a, 0x0c, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xb6, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xaf,
	0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x5e, 0x3a, 0x01, 0x2a, 0x22, 0x59, 0x2f, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x76,
	0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x22, 0x4a, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x12, 0xe9, 0x02, 0x0a, 0x1b, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0xd4, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xcd, 0x01, 0x3a, 0x01, 0x2a,
	0x5a, 0x6d, 0x3a, 0x01, 0x2a, 0x22, 0x68, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x69, 0x6e, 0x67, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22,
	0x59, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x30, 0x01, 0x12, 0xa2, 0x01, 0x0a,
	0x15, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x28, 0x01, 0x30,
	0x01, 0x12, 0xb5, 0x02, 0x0a, 0x0b, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0xb4, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xad, 0x01, 0x3a, 0x01, 0x2a, 0x5a,
	0x5d, 0x3a, 0x01, 0x2a, 0x22, 0x58, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0x49,
	0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0xe9, 0x02, 0x0a, 0x0d, 0x46, 0x75,
	0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x75, 0x6c, 0x66, 0x69,
	0x6c, 0x6c, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0xe2, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xdb, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x74, 0x3a,
	0x01, 0x2a, 0x22, 0x6f, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72,
	0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x49, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x22, 0x60, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x49,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0xea, 0x01, 0x0a, 0x14, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x74,
	0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x12, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72,
	0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x46, 0x65, 0x65, 0x64, 0x62,
	0x61, 0x63, 0x6b, 0x22, 0x5d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x57, 0x3a, 0x01, 0x2a, 0x22, 0x52,
	0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x75,
	0x62, 0x6d, 0x69, 0x74, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61,
	0x63, 0x6b, 0x1a, 0x78, 0xca, 0x41, 0x19, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x59, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x42, 0xe7, 0x04, 0xea,
	0x41, 0xd4, 0x01, 0x0a, 0x21, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x49, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x7d, 0x12, 0x64, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x7b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0xea, 0x41, 0xc5, 0x01, 0x0a, 0x28, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x3f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x7d, 0x12, 0x58, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6c,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x7d,
	0x0a, 0x26, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x0c, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x36, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x78, 0x70, 0x62, 0x3b, 0x63, 0x78, 0x70, 0x62,
	0xf8, 0x01, 0x01, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x43, 0x78, 0x2e, 0x56, 0x33, 0x42, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x26,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x3a, 0x3a, 0x43, 0x58, 0x3a, 0x3a, 0x56,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescData = file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDesc
)

func file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescData
}

var file_google_cloud_dialogflow_cx_v3beta1_session_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes = make([]protoimpl.MessageInfo, 30)
var file_google_cloud_dialogflow_cx_v3beta1_session_proto_goTypes = []any{
	(AnswerFeedback_Rating)(0),                  // 0: google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Rating
	(DetectIntentResponse_ResponseType)(0),      // 1: google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.ResponseType
	(StreamingRecognitionResult_MessageType)(0), // 2: google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult.MessageType
	(Match_MatchType)(0),                        // 3: google.cloud.dialogflow.cx.v3beta1.Match.MatchType
	(*AnswerFeedback)(nil),                      // 4: google.cloud.dialogflow.cx.v3beta1.AnswerFeedback
	(*SubmitAnswerFeedbackRequest)(nil),         // 5: google.cloud.dialogflow.cx.v3beta1.SubmitAnswerFeedbackRequest
	(*DetectIntentRequest)(nil),                 // 6: google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest
	(*DetectIntentResponse)(nil),                // 7: google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse
	(*StreamingDetectIntentRequest)(nil),        // 8: google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentRequest
	(*CloudConversationDebuggingInfo)(nil),      // 9: google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo
	(*StreamingDetectIntentResponse)(nil),       // 10: google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse
	(*StreamingRecognitionResult)(nil),          // 11: google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult
	(*QueryParameters)(nil),                     // 12: google.cloud.dialogflow.cx.v3beta1.QueryParameters
	(*SearchConfig)(nil),                        // 13: google.cloud.dialogflow.cx.v3beta1.SearchConfig
	(*BoostSpec)(nil),                           // 14: google.cloud.dialogflow.cx.v3beta1.BoostSpec
	(*BoostSpecs)(nil),                          // 15: google.cloud.dialogflow.cx.v3beta1.BoostSpecs
	(*FilterSpecs)(nil),                         // 16: google.cloud.dialogflow.cx.v3beta1.FilterSpecs
	(*QueryInput)(nil),                          // 17: google.cloud.dialogflow.cx.v3beta1.QueryInput
	(*GenerativeInfo)(nil),                      // 18: google.cloud.dialogflow.cx.v3beta1.GenerativeInfo
	(*QueryResult)(nil),                         // 19: google.cloud.dialogflow.cx.v3beta1.QueryResult
	(*TextInput)(nil),                           // 20: google.cloud.dialogflow.cx.v3beta1.TextInput
	(*IntentInput)(nil),                         // 21: google.cloud.dialogflow.cx.v3beta1.IntentInput
	(*AudioInput)(nil),                          // 22: google.cloud.dialogflow.cx.v3beta1.AudioInput
	(*EventInput)(nil),                          // 23: google.cloud.dialogflow.cx.v3beta1.EventInput
	(*DtmfInput)(nil),                           // 24: google.cloud.dialogflow.cx.v3beta1.DtmfInput
	(*Match)(nil),                               // 25: google.cloud.dialogflow.cx.v3beta1.Match
	(*MatchIntentRequest)(nil),                  // 26: google.cloud.dialogflow.cx.v3beta1.MatchIntentRequest
	(*MatchIntentResponse)(nil),                 // 27: google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse
	(*FulfillIntentRequest)(nil),                // 28: google.cloud.dialogflow.cx.v3beta1.FulfillIntentRequest
	(*FulfillIntentResponse)(nil),               // 29: google.cloud.dialogflow.cx.v3beta1.FulfillIntentResponse
	(*SentimentAnalysisResult)(nil),             // 30: google.cloud.dialogflow.cx.v3beta1.SentimentAnalysisResult
	(*AnswerFeedback_RatingReason)(nil),         // 31: google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason
	nil,                                         // 32: google.cloud.dialogflow.cx.v3beta1.QueryParameters.WebhookHeadersEntry
	(*BoostSpec_ConditionBoostSpec)(nil),        // 33: google.cloud.dialogflow.cx.v3beta1.BoostSpec.ConditionBoostSpec
	(*fieldmaskpb.FieldMask)(nil),               // 34: google.protobuf.FieldMask
	(*OutputAudioConfig)(nil),                   // 35: google.cloud.dialogflow.cx.v3beta1.OutputAudioConfig
	(*durationpb.Duration)(nil),                 // 36: google.protobuf.Duration
	(*SpeechWordInfo)(nil),                      // 37: google.cloud.dialogflow.cx.v3beta1.SpeechWordInfo
	(*latlng.LatLng)(nil),                       // 38: google.type.LatLng
	(*SessionEntityType)(nil),                   // 39: google.cloud.dialogflow.cx.v3beta1.SessionEntityType
	(*structpb.Struct)(nil),                     // 40: google.protobuf.Struct
	(*LlmModelSettings)(nil),                    // 41: google.cloud.dialogflow.cx.v3beta1.LlmModelSettings
	(*ToolCallResult)(nil),                      // 42: google.cloud.dialogflow.cx.v3beta1.ToolCallResult
	(*Example)(nil),                             // 43: google.cloud.dialogflow.cx.v3beta1.Example
	(*ResponseMessage)(nil),                     // 44: google.cloud.dialogflow.cx.v3beta1.ResponseMessage
	(*status.Status)(nil),                       // 45: google.rpc.Status
	(*Page)(nil),                                // 46: google.cloud.dialogflow.cx.v3beta1.Page
	(*Flow)(nil),                                // 47: google.cloud.dialogflow.cx.v3beta1.Flow
	(*Intent)(nil),                              // 48: google.cloud.dialogflow.cx.v3beta1.Intent
	(*AdvancedSettings)(nil),                    // 49: google.cloud.dialogflow.cx.v3beta1.AdvancedSettings
	(*DataStoreConnectionSignals)(nil),          // 50: google.cloud.dialogflow.cx.v3beta1.DataStoreConnectionSignals
	(*InputAudioConfig)(nil),                    // 51: google.cloud.dialogflow.cx.v3beta1.InputAudioConfig
}
var file_google_cloud_dialogflow_cx_v3beta1_session_proto_depIdxs = []int32{
	0,  // 0: google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.rating:type_name -> google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Rating
	31, // 1: google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.rating_reason:type_name -> google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.RatingReason
	4,  // 2: google.cloud.dialogflow.cx.v3beta1.SubmitAnswerFeedbackRequest.answer_feedback:type_name -> google.cloud.dialogflow.cx.v3beta1.AnswerFeedback
	34, // 3: google.cloud.dialogflow.cx.v3beta1.SubmitAnswerFeedbackRequest.update_mask:type_name -> google.protobuf.FieldMask
	12, // 4: google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest.query_params:type_name -> google.cloud.dialogflow.cx.v3beta1.QueryParameters
	17, // 5: google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest.query_input:type_name -> google.cloud.dialogflow.cx.v3beta1.QueryInput
	35, // 6: google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest.output_audio_config:type_name -> google.cloud.dialogflow.cx.v3beta1.OutputAudioConfig
	19, // 7: google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.query_result:type_name -> google.cloud.dialogflow.cx.v3beta1.QueryResult
	35, // 8: google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.output_audio_config:type_name -> google.cloud.dialogflow.cx.v3beta1.OutputAudioConfig
	1,  // 9: google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.response_type:type_name -> google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.ResponseType
	12, // 10: google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentRequest.query_params:type_name -> google.cloud.dialogflow.cx.v3beta1.QueryParameters
	17, // 11: google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentRequest.query_input:type_name -> google.cloud.dialogflow.cx.v3beta1.QueryInput
	35, // 12: google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentRequest.output_audio_config:type_name -> google.cloud.dialogflow.cx.v3beta1.OutputAudioConfig
	36, // 13: google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo.result_end_time_offset:type_name -> google.protobuf.Duration
	36, // 14: google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo.first_audio_duration:type_name -> google.protobuf.Duration
	36, // 15: google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo.speech_partial_results_end_times:type_name -> google.protobuf.Duration
	36, // 16: google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo.speech_final_results_end_times:type_name -> google.protobuf.Duration
	36, // 17: google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo.dtmf_partial_results_times:type_name -> google.protobuf.Duration
	36, // 18: google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo.dtmf_final_results_times:type_name -> google.protobuf.Duration
	36, // 19: google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo.single_utterance_end_time_offset:type_name -> google.protobuf.Duration
	36, // 20: google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo.no_speech_timeout:type_name -> google.protobuf.Duration
	36, // 21: google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo.endpointing_timeout:type_name -> google.protobuf.Duration
	36, // 22: google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo.client_half_close_time_offset:type_name -> google.protobuf.Duration
	36, // 23: google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo.client_half_close_streaming_time_offset:type_name -> google.protobuf.Duration
	11, // 24: google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse.recognition_result:type_name -> google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult
	7,  // 25: google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse.detect_intent_response:type_name -> google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse
	9,  // 26: google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse.debugging_info:type_name -> google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo
	2,  // 27: google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult.message_type:type_name -> google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult.MessageType
	37, // 28: google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult.speech_word_info:type_name -> google.cloud.dialogflow.cx.v3beta1.SpeechWordInfo
	36, // 29: google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult.speech_end_offset:type_name -> google.protobuf.Duration
	38, // 30: google.cloud.dialogflow.cx.v3beta1.QueryParameters.geo_location:type_name -> google.type.LatLng
	39, // 31: google.cloud.dialogflow.cx.v3beta1.QueryParameters.session_entity_types:type_name -> google.cloud.dialogflow.cx.v3beta1.SessionEntityType
	40, // 32: google.cloud.dialogflow.cx.v3beta1.QueryParameters.payload:type_name -> google.protobuf.Struct
	40, // 33: google.cloud.dialogflow.cx.v3beta1.QueryParameters.parameters:type_name -> google.protobuf.Struct
	32, // 34: google.cloud.dialogflow.cx.v3beta1.QueryParameters.webhook_headers:type_name -> google.cloud.dialogflow.cx.v3beta1.QueryParameters.WebhookHeadersEntry
	41, // 35: google.cloud.dialogflow.cx.v3beta1.QueryParameters.llm_model_settings:type_name -> google.cloud.dialogflow.cx.v3beta1.LlmModelSettings
	36, // 36: google.cloud.dialogflow.cx.v3beta1.QueryParameters.session_ttl:type_name -> google.protobuf.Duration
	40, // 37: google.cloud.dialogflow.cx.v3beta1.QueryParameters.end_user_metadata:type_name -> google.protobuf.Struct
	13, // 38: google.cloud.dialogflow.cx.v3beta1.QueryParameters.search_config:type_name -> google.cloud.dialogflow.cx.v3beta1.SearchConfig
	15, // 39: google.cloud.dialogflow.cx.v3beta1.SearchConfig.boost_specs:type_name -> google.cloud.dialogflow.cx.v3beta1.BoostSpecs
	16, // 40: google.cloud.dialogflow.cx.v3beta1.SearchConfig.filter_specs:type_name -> google.cloud.dialogflow.cx.v3beta1.FilterSpecs
	33, // 41: google.cloud.dialogflow.cx.v3beta1.BoostSpec.condition_boost_specs:type_name -> google.cloud.dialogflow.cx.v3beta1.BoostSpec.ConditionBoostSpec
	14, // 42: google.cloud.dialogflow.cx.v3beta1.BoostSpecs.spec:type_name -> google.cloud.dialogflow.cx.v3beta1.BoostSpec
	20, // 43: google.cloud.dialogflow.cx.v3beta1.QueryInput.text:type_name -> google.cloud.dialogflow.cx.v3beta1.TextInput
	21, // 44: google.cloud.dialogflow.cx.v3beta1.QueryInput.intent:type_name -> google.cloud.dialogflow.cx.v3beta1.IntentInput
	22, // 45: google.cloud.dialogflow.cx.v3beta1.QueryInput.audio:type_name -> google.cloud.dialogflow.cx.v3beta1.AudioInput
	23, // 46: google.cloud.dialogflow.cx.v3beta1.QueryInput.event:type_name -> google.cloud.dialogflow.cx.v3beta1.EventInput
	24, // 47: google.cloud.dialogflow.cx.v3beta1.QueryInput.dtmf:type_name -> google.cloud.dialogflow.cx.v3beta1.DtmfInput
	42, // 48: google.cloud.dialogflow.cx.v3beta1.QueryInput.tool_call_result:type_name -> google.cloud.dialogflow.cx.v3beta1.ToolCallResult
	43, // 49: google.cloud.dialogflow.cx.v3beta1.GenerativeInfo.action_tracing_info:type_name -> google.cloud.dialogflow.cx.v3beta1.Example
	24, // 50: google.cloud.dialogflow.cx.v3beta1.QueryResult.dtmf:type_name -> google.cloud.dialogflow.cx.v3beta1.DtmfInput
	40, // 51: google.cloud.dialogflow.cx.v3beta1.QueryResult.parameters:type_name -> google.protobuf.Struct
	44, // 52: google.cloud.dialogflow.cx.v3beta1.QueryResult.response_messages:type_name -> google.cloud.dialogflow.cx.v3beta1.ResponseMessage
	36, // 53: google.cloud.dialogflow.cx.v3beta1.QueryResult.webhook_latencies:type_name -> google.protobuf.Duration
	45, // 54: google.cloud.dialogflow.cx.v3beta1.QueryResult.webhook_statuses:type_name -> google.rpc.Status
	40, // 55: google.cloud.dialogflow.cx.v3beta1.QueryResult.webhook_payloads:type_name -> google.protobuf.Struct
	46, // 56: google.cloud.dialogflow.cx.v3beta1.QueryResult.current_page:type_name -> google.cloud.dialogflow.cx.v3beta1.Page
	47, // 57: google.cloud.dialogflow.cx.v3beta1.QueryResult.current_flow:type_name -> google.cloud.dialogflow.cx.v3beta1.Flow
	48, // 58: google.cloud.dialogflow.cx.v3beta1.QueryResult.intent:type_name -> google.cloud.dialogflow.cx.v3beta1.Intent
	25, // 59: google.cloud.dialogflow.cx.v3beta1.QueryResult.match:type_name -> google.cloud.dialogflow.cx.v3beta1.Match
	40, // 60: google.cloud.dialogflow.cx.v3beta1.QueryResult.diagnostic_info:type_name -> google.protobuf.Struct
	18, // 61: google.cloud.dialogflow.cx.v3beta1.QueryResult.generative_info:type_name -> google.cloud.dialogflow.cx.v3beta1.GenerativeInfo
	30, // 62: google.cloud.dialogflow.cx.v3beta1.QueryResult.sentiment_analysis_result:type_name -> google.cloud.dialogflow.cx.v3beta1.SentimentAnalysisResult
	49, // 63: google.cloud.dialogflow.cx.v3beta1.QueryResult.advanced_settings:type_name -> google.cloud.dialogflow.cx.v3beta1.AdvancedSettings
	50, // 64: google.cloud.dialogflow.cx.v3beta1.QueryResult.data_store_connection_signals:type_name -> google.cloud.dialogflow.cx.v3beta1.DataStoreConnectionSignals
	51, // 65: google.cloud.dialogflow.cx.v3beta1.AudioInput.config:type_name -> google.cloud.dialogflow.cx.v3beta1.InputAudioConfig
	48, // 66: google.cloud.dialogflow.cx.v3beta1.Match.intent:type_name -> google.cloud.dialogflow.cx.v3beta1.Intent
	40, // 67: google.cloud.dialogflow.cx.v3beta1.Match.parameters:type_name -> google.protobuf.Struct
	3,  // 68: google.cloud.dialogflow.cx.v3beta1.Match.match_type:type_name -> google.cloud.dialogflow.cx.v3beta1.Match.MatchType
	12, // 69: google.cloud.dialogflow.cx.v3beta1.MatchIntentRequest.query_params:type_name -> google.cloud.dialogflow.cx.v3beta1.QueryParameters
	17, // 70: google.cloud.dialogflow.cx.v3beta1.MatchIntentRequest.query_input:type_name -> google.cloud.dialogflow.cx.v3beta1.QueryInput
	25, // 71: google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse.matches:type_name -> google.cloud.dialogflow.cx.v3beta1.Match
	46, // 72: google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse.current_page:type_name -> google.cloud.dialogflow.cx.v3beta1.Page
	26, // 73: google.cloud.dialogflow.cx.v3beta1.FulfillIntentRequest.match_intent_request:type_name -> google.cloud.dialogflow.cx.v3beta1.MatchIntentRequest
	25, // 74: google.cloud.dialogflow.cx.v3beta1.FulfillIntentRequest.match:type_name -> google.cloud.dialogflow.cx.v3beta1.Match
	35, // 75: google.cloud.dialogflow.cx.v3beta1.FulfillIntentRequest.output_audio_config:type_name -> google.cloud.dialogflow.cx.v3beta1.OutputAudioConfig
	19, // 76: google.cloud.dialogflow.cx.v3beta1.FulfillIntentResponse.query_result:type_name -> google.cloud.dialogflow.cx.v3beta1.QueryResult
	35, // 77: google.cloud.dialogflow.cx.v3beta1.FulfillIntentResponse.output_audio_config:type_name -> google.cloud.dialogflow.cx.v3beta1.OutputAudioConfig
	6,  // 78: google.cloud.dialogflow.cx.v3beta1.Sessions.DetectIntent:input_type -> google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest
	6,  // 79: google.cloud.dialogflow.cx.v3beta1.Sessions.ServerStreamingDetectIntent:input_type -> google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest
	8,  // 80: google.cloud.dialogflow.cx.v3beta1.Sessions.StreamingDetectIntent:input_type -> google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentRequest
	26, // 81: google.cloud.dialogflow.cx.v3beta1.Sessions.MatchIntent:input_type -> google.cloud.dialogflow.cx.v3beta1.MatchIntentRequest
	28, // 82: google.cloud.dialogflow.cx.v3beta1.Sessions.FulfillIntent:input_type -> google.cloud.dialogflow.cx.v3beta1.FulfillIntentRequest
	5,  // 83: google.cloud.dialogflow.cx.v3beta1.Sessions.SubmitAnswerFeedback:input_type -> google.cloud.dialogflow.cx.v3beta1.SubmitAnswerFeedbackRequest
	7,  // 84: google.cloud.dialogflow.cx.v3beta1.Sessions.DetectIntent:output_type -> google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse
	7,  // 85: google.cloud.dialogflow.cx.v3beta1.Sessions.ServerStreamingDetectIntent:output_type -> google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse
	10, // 86: google.cloud.dialogflow.cx.v3beta1.Sessions.StreamingDetectIntent:output_type -> google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse
	27, // 87: google.cloud.dialogflow.cx.v3beta1.Sessions.MatchIntent:output_type -> google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse
	29, // 88: google.cloud.dialogflow.cx.v3beta1.Sessions.FulfillIntent:output_type -> google.cloud.dialogflow.cx.v3beta1.FulfillIntentResponse
	4,  // 89: google.cloud.dialogflow.cx.v3beta1.Sessions.SubmitAnswerFeedback:output_type -> google.cloud.dialogflow.cx.v3beta1.AnswerFeedback
	84, // [84:90] is the sub-list for method output_type
	78, // [78:84] is the sub-list for method input_type
	78, // [78:78] is the sub-list for extension type_name
	78, // [78:78] is the sub-list for extension extendee
	0,  // [0:78] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_cx_v3beta1_session_proto_init() }
func file_google_cloud_dialogflow_cx_v3beta1_session_proto_init() {
	if File_google_cloud_dialogflow_cx_v3beta1_session_proto != nil {
		return
	}
	file_google_cloud_dialogflow_cx_v3beta1_advanced_settings_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_audio_config_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_data_store_connection_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_example_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_flow_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_intent_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_page_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_response_message_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_session_entity_type_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_tool_call_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*AnswerFeedback); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*SubmitAnswerFeedbackRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*DetectIntentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*DetectIntentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*StreamingDetectIntentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*CloudConversationDebuggingInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*StreamingDetectIntentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*StreamingRecognitionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*QueryParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*SearchConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*BoostSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*BoostSpecs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*FilterSpecs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*QueryInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*GenerativeInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*QueryResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[16].Exporter = func(v any, i int) any {
			switch v := v.(*TextInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[17].Exporter = func(v any, i int) any {
			switch v := v.(*IntentInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[18].Exporter = func(v any, i int) any {
			switch v := v.(*AudioInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[19].Exporter = func(v any, i int) any {
			switch v := v.(*EventInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[20].Exporter = func(v any, i int) any {
			switch v := v.(*DtmfInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[21].Exporter = func(v any, i int) any {
			switch v := v.(*Match); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[22].Exporter = func(v any, i int) any {
			switch v := v.(*MatchIntentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[23].Exporter = func(v any, i int) any {
			switch v := v.(*MatchIntentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[24].Exporter = func(v any, i int) any {
			switch v := v.(*FulfillIntentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[25].Exporter = func(v any, i int) any {
			switch v := v.(*FulfillIntentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[26].Exporter = func(v any, i int) any {
			switch v := v.(*SentimentAnalysisResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[27].Exporter = func(v any, i int) any {
			switch v := v.(*AnswerFeedback_RatingReason); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[29].Exporter = func(v any, i int) any {
			switch v := v.(*BoostSpec_ConditionBoostSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[6].OneofWrappers = []any{
		(*StreamingDetectIntentResponse_RecognitionResult)(nil),
		(*StreamingDetectIntentResponse_DetectIntentResponse)(nil),
	}
	file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[13].OneofWrappers = []any{
		(*QueryInput_Text)(nil),
		(*QueryInput_Intent)(nil),
		(*QueryInput_Audio)(nil),
		(*QueryInput_Event)(nil),
		(*QueryInput_Dtmf)(nil),
		(*QueryInput_ToolCallResult)(nil),
	}
	file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[15].OneofWrappers = []any{
		(*QueryResult_Text)(nil),
		(*QueryResult_TriggerIntent)(nil),
		(*QueryResult_Transcript)(nil),
		(*QueryResult_TriggerEvent)(nil),
		(*QueryResult_Dtmf)(nil),
	}
	file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[23].OneofWrappers = []any{
		(*MatchIntentResponse_Text)(nil),
		(*MatchIntentResponse_TriggerIntent)(nil),
		(*MatchIntentResponse_Transcript)(nil),
		(*MatchIntentResponse_TriggerEvent)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   30,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_cx_v3beta1_session_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_cx_v3beta1_session_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_cx_v3beta1_session_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_cx_v3beta1_session_proto = out.File
	file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDesc = nil
	file_google_cloud_dialogflow_cx_v3beta1_session_proto_goTypes = nil
	file_google_cloud_dialogflow_cx_v3beta1_session_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SessionsClient is the client API for Sessions service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SessionsClient interface {
	// Processes a natural language query and returns structured, actionable data
	// as a result. This method is not idempotent, because it may cause session
	// entity types to be updated, which in turn might affect results of future
	// queries.
	//
	// Note: Always use agent versions for production traffic.
	// See [Versions and
	// environments](https://cloud.google.com/dialogflow/cx/docs/concept/version).
	DetectIntent(ctx context.Context, in *DetectIntentRequest, opts ...grpc.CallOption) (*DetectIntentResponse, error)
	// Processes a natural language query and returns structured, actionable data
	// as a result through server-side streaming. Server-side streaming allows
	// Dialogflow to send [partial
	// responses](https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#partial-response)
	// earlier in a single request.
	ServerStreamingDetectIntent(ctx context.Context, in *DetectIntentRequest, opts ...grpc.CallOption) (Sessions_ServerStreamingDetectIntentClient, error)
	// Processes a natural language query in audio format in a streaming fashion
	// and returns structured, actionable data as a result. This method is only
	// available via the gRPC API (not REST).
	//
	// Note: Always use agent versions for production traffic.
	// See [Versions and
	// environments](https://cloud.google.com/dialogflow/cx/docs/concept/version).
	StreamingDetectIntent(ctx context.Context, opts ...grpc.CallOption) (Sessions_StreamingDetectIntentClient, error)
	// Returns preliminary intent match results, doesn't change the session
	// status.
	MatchIntent(ctx context.Context, in *MatchIntentRequest, opts ...grpc.CallOption) (*MatchIntentResponse, error)
	// Fulfills a matched intent returned by
	// [MatchIntent][google.cloud.dialogflow.cx.v3beta1.Sessions.MatchIntent].
	// Must be called after
	// [MatchIntent][google.cloud.dialogflow.cx.v3beta1.Sessions.MatchIntent],
	// with input from
	// [MatchIntentResponse][google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse].
	// Otherwise, the behavior is undefined.
	FulfillIntent(ctx context.Context, in *FulfillIntentRequest, opts ...grpc.CallOption) (*FulfillIntentResponse, error)
	// Updates the feedback received from the user for a single turn of the bot
	// response.
	SubmitAnswerFeedback(ctx context.Context, in *SubmitAnswerFeedbackRequest, opts ...grpc.CallOption) (*AnswerFeedback, error)
}

type sessionsClient struct {
	cc grpc.ClientConnInterface
}

func NewSessionsClient(cc grpc.ClientConnInterface) SessionsClient {
	return &sessionsClient{cc}
}

func (c *sessionsClient) DetectIntent(ctx context.Context, in *DetectIntentRequest, opts ...grpc.CallOption) (*DetectIntentResponse, error) {
	out := new(DetectIntentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Sessions/DetectIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionsClient) ServerStreamingDetectIntent(ctx context.Context, in *DetectIntentRequest, opts ...grpc.CallOption) (Sessions_ServerStreamingDetectIntentClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Sessions_serviceDesc.Streams[0], "/google.cloud.dialogflow.cx.v3beta1.Sessions/ServerStreamingDetectIntent", opts...)
	if err != nil {
		return nil, err
	}
	x := &sessionsServerStreamingDetectIntentClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Sessions_ServerStreamingDetectIntentClient interface {
	Recv() (*DetectIntentResponse, error)
	grpc.ClientStream
}

type sessionsServerStreamingDetectIntentClient struct {
	grpc.ClientStream
}

func (x *sessionsServerStreamingDetectIntentClient) Recv() (*DetectIntentResponse, error) {
	m := new(DetectIntentResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *sessionsClient) StreamingDetectIntent(ctx context.Context, opts ...grpc.CallOption) (Sessions_StreamingDetectIntentClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Sessions_serviceDesc.Streams[1], "/google.cloud.dialogflow.cx.v3beta1.Sessions/StreamingDetectIntent", opts...)
	if err != nil {
		return nil, err
	}
	x := &sessionsStreamingDetectIntentClient{stream}
	return x, nil
}

type Sessions_StreamingDetectIntentClient interface {
	Send(*StreamingDetectIntentRequest) error
	Recv() (*StreamingDetectIntentResponse, error)
	grpc.ClientStream
}

type sessionsStreamingDetectIntentClient struct {
	grpc.ClientStream
}

func (x *sessionsStreamingDetectIntentClient) Send(m *StreamingDetectIntentRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *sessionsStreamingDetectIntentClient) Recv() (*StreamingDetectIntentResponse, error) {
	m := new(StreamingDetectIntentResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *sessionsClient) MatchIntent(ctx context.Context, in *MatchIntentRequest, opts ...grpc.CallOption) (*MatchIntentResponse, error) {
	out := new(MatchIntentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Sessions/MatchIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionsClient) FulfillIntent(ctx context.Context, in *FulfillIntentRequest, opts ...grpc.CallOption) (*FulfillIntentResponse, error) {
	out := new(FulfillIntentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Sessions/FulfillIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionsClient) SubmitAnswerFeedback(ctx context.Context, in *SubmitAnswerFeedbackRequest, opts ...grpc.CallOption) (*AnswerFeedback, error) {
	out := new(AnswerFeedback)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Sessions/SubmitAnswerFeedback", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SessionsServer is the server API for Sessions service.
type SessionsServer interface {
	// Processes a natural language query and returns structured, actionable data
	// as a result. This method is not idempotent, because it may cause session
	// entity types to be updated, which in turn might affect results of future
	// queries.
	//
	// Note: Always use agent versions for production traffic.
	// See [Versions and
	// environments](https://cloud.google.com/dialogflow/cx/docs/concept/version).
	DetectIntent(context.Context, *DetectIntentRequest) (*DetectIntentResponse, error)
	// Processes a natural language query and returns structured, actionable data
	// as a result through server-side streaming. Server-side streaming allows
	// Dialogflow to send [partial
	// responses](https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#partial-response)
	// earlier in a single request.
	ServerStreamingDetectIntent(*DetectIntentRequest, Sessions_ServerStreamingDetectIntentServer) error
	// Processes a natural language query in audio format in a streaming fashion
	// and returns structured, actionable data as a result. This method is only
	// available via the gRPC API (not REST).
	//
	// Note: Always use agent versions for production traffic.
	// See [Versions and
	// environments](https://cloud.google.com/dialogflow/cx/docs/concept/version).
	StreamingDetectIntent(Sessions_StreamingDetectIntentServer) error
	// Returns preliminary intent match results, doesn't change the session
	// status.
	MatchIntent(context.Context, *MatchIntentRequest) (*MatchIntentResponse, error)
	// Fulfills a matched intent returned by
	// [MatchIntent][google.cloud.dialogflow.cx.v3beta1.Sessions.MatchIntent].
	// Must be called after
	// [MatchIntent][google.cloud.dialogflow.cx.v3beta1.Sessions.MatchIntent],
	// with input from
	// [MatchIntentResponse][google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse].
	// Otherwise, the behavior is undefined.
	FulfillIntent(context.Context, *FulfillIntentRequest) (*FulfillIntentResponse, error)
	// Updates the feedback received from the user for a single turn of the bot
	// response.
	SubmitAnswerFeedback(context.Context, *SubmitAnswerFeedbackRequest) (*AnswerFeedback, error)
}

// UnimplementedSessionsServer can be embedded to have forward compatible implementations.
type UnimplementedSessionsServer struct {
}

func (*UnimplementedSessionsServer) DetectIntent(context.Context, *DetectIntentRequest) (*DetectIntentResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DetectIntent not implemented")
}
func (*UnimplementedSessionsServer) ServerStreamingDetectIntent(*DetectIntentRequest, Sessions_ServerStreamingDetectIntentServer) error {
	return status1.Errorf(codes.Unimplemented, "method ServerStreamingDetectIntent not implemented")
}
func (*UnimplementedSessionsServer) StreamingDetectIntent(Sessions_StreamingDetectIntentServer) error {
	return status1.Errorf(codes.Unimplemented, "method StreamingDetectIntent not implemented")
}
func (*UnimplementedSessionsServer) MatchIntent(context.Context, *MatchIntentRequest) (*MatchIntentResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MatchIntent not implemented")
}
func (*UnimplementedSessionsServer) FulfillIntent(context.Context, *FulfillIntentRequest) (*FulfillIntentResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method FulfillIntent not implemented")
}
func (*UnimplementedSessionsServer) SubmitAnswerFeedback(context.Context, *SubmitAnswerFeedbackRequest) (*AnswerFeedback, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SubmitAnswerFeedback not implemented")
}

func RegisterSessionsServer(s *grpc.Server, srv SessionsServer) {
	s.RegisterService(&_Sessions_serviceDesc, srv)
}

func _Sessions_DetectIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetectIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionsServer).DetectIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Sessions/DetectIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionsServer).DetectIntent(ctx, req.(*DetectIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Sessions_ServerStreamingDetectIntent_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(DetectIntentRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(SessionsServer).ServerStreamingDetectIntent(m, &sessionsServerStreamingDetectIntentServer{stream})
}

type Sessions_ServerStreamingDetectIntentServer interface {
	Send(*DetectIntentResponse) error
	grpc.ServerStream
}

type sessionsServerStreamingDetectIntentServer struct {
	grpc.ServerStream
}

func (x *sessionsServerStreamingDetectIntentServer) Send(m *DetectIntentResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Sessions_StreamingDetectIntent_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SessionsServer).StreamingDetectIntent(&sessionsStreamingDetectIntentServer{stream})
}

type Sessions_StreamingDetectIntentServer interface {
	Send(*StreamingDetectIntentResponse) error
	Recv() (*StreamingDetectIntentRequest, error)
	grpc.ServerStream
}

type sessionsStreamingDetectIntentServer struct {
	grpc.ServerStream
}

func (x *sessionsStreamingDetectIntentServer) Send(m *StreamingDetectIntentResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *sessionsStreamingDetectIntentServer) Recv() (*StreamingDetectIntentRequest, error) {
	m := new(StreamingDetectIntentRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Sessions_MatchIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MatchIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionsServer).MatchIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Sessions/MatchIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionsServer).MatchIntent(ctx, req.(*MatchIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Sessions_FulfillIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FulfillIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionsServer).FulfillIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Sessions/FulfillIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionsServer).FulfillIntent(ctx, req.(*FulfillIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Sessions_SubmitAnswerFeedback_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SubmitAnswerFeedbackRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionsServer).SubmitAnswerFeedback(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Sessions/SubmitAnswerFeedback",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionsServer).SubmitAnswerFeedback(ctx, req.(*SubmitAnswerFeedbackRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Sessions_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3beta1.Sessions",
	HandlerType: (*SessionsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DetectIntent",
			Handler:    _Sessions_DetectIntent_Handler,
		},
		{
			MethodName: "MatchIntent",
			Handler:    _Sessions_MatchIntent_Handler,
		},
		{
			MethodName: "FulfillIntent",
			Handler:    _Sessions_FulfillIntent_Handler,
		},
		{
			MethodName: "SubmitAnswerFeedback",
			Handler:    _Sessions_SubmitAnswerFeedback_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ServerStreamingDetectIntent",
			Handler:       _Sessions_ServerStreamingDetectIntent_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "StreamingDetectIntent",
			Handler:       _Sessions_StreamingDetectIntent_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/dialogflow/cx/v3beta1/session.proto",
}
