// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v4.25.3
// source: google/cloud/dialogflow/v2/conversation_model.proto

package dialogflowpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// State of the model.
type ConversationModel_State int32

const (
	// Should not be used, an un-set enum has this value by default.
	ConversationModel_STATE_UNSPECIFIED ConversationModel_State = 0
	// Model being created.
	ConversationModel_CREATING ConversationModel_State = 1
	// Model is not deployed but ready to deploy.
	ConversationModel_UNDEPLOYED ConversationModel_State = 2
	// Model is deploying.
	ConversationModel_DEPLOYING ConversationModel_State = 3
	// Model is deployed and ready to use.
	ConversationModel_DEPLOYED ConversationModel_State = 4
	// Model is undeploying.
	ConversationModel_UNDEPLOYING ConversationModel_State = 5
	// Model is deleting.
	ConversationModel_DELETING ConversationModel_State = 6
	// Model is in error state. Not ready to deploy and use.
	ConversationModel_FAILED ConversationModel_State = 7
	// Model is being created but the training has not started,
	// The model may remain in this state until there is enough capacity to
	// start training.
	ConversationModel_PENDING ConversationModel_State = 8
)

// Enum value maps for ConversationModel_State.
var (
	ConversationModel_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "UNDEPLOYED",
		3: "DEPLOYING",
		4: "DEPLOYED",
		5: "UNDEPLOYING",
		6: "DELETING",
		7: "FAILED",
		8: "PENDING",
	}
	ConversationModel_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"UNDEPLOYED":        2,
		"DEPLOYING":         3,
		"DEPLOYED":          4,
		"UNDEPLOYING":       5,
		"DELETING":          6,
		"FAILED":            7,
		"PENDING":           8,
	}
)

func (x ConversationModel_State) Enum() *ConversationModel_State {
	p := new(ConversationModel_State)
	*p = x
	return p
}

func (x ConversationModel_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConversationModel_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_enumTypes[0].Descriptor()
}

func (ConversationModel_State) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_conversation_model_proto_enumTypes[0]
}

func (x ConversationModel_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConversationModel_State.Descriptor instead.
func (ConversationModel_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{0, 0}
}

// Model type.
type ConversationModel_ModelType int32

const (
	// ModelType unspecified.
	ConversationModel_MODEL_TYPE_UNSPECIFIED ConversationModel_ModelType = 0
	// ModelType smart reply dual encoder model.
	ConversationModel_SMART_REPLY_DUAL_ENCODER_MODEL ConversationModel_ModelType = 2
	// ModelType smart reply bert model.
	ConversationModel_SMART_REPLY_BERT_MODEL ConversationModel_ModelType = 6
)

// Enum value maps for ConversationModel_ModelType.
var (
	ConversationModel_ModelType_name = map[int32]string{
		0: "MODEL_TYPE_UNSPECIFIED",
		2: "SMART_REPLY_DUAL_ENCODER_MODEL",
		6: "SMART_REPLY_BERT_MODEL",
	}
	ConversationModel_ModelType_value = map[string]int32{
		"MODEL_TYPE_UNSPECIFIED":         0,
		"SMART_REPLY_DUAL_ENCODER_MODEL": 2,
		"SMART_REPLY_BERT_MODEL":         6,
	}
)

func (x ConversationModel_ModelType) Enum() *ConversationModel_ModelType {
	p := new(ConversationModel_ModelType)
	*p = x
	return p
}

func (x ConversationModel_ModelType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConversationModel_ModelType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_enumTypes[1].Descriptor()
}

func (ConversationModel_ModelType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_conversation_model_proto_enumTypes[1]
}

func (x ConversationModel_ModelType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConversationModel_ModelType.Descriptor instead.
func (ConversationModel_ModelType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{0, 1}
}

// State of CreateConversationModel operation.
type CreateConversationModelOperationMetadata_State int32

const (
	// Invalid.
	CreateConversationModelOperationMetadata_STATE_UNSPECIFIED CreateConversationModelOperationMetadata_State = 0
	// Request is submitted, but training has not started yet.
	// The model may remain in this state until there is enough capacity to
	// start training.
	CreateConversationModelOperationMetadata_PENDING CreateConversationModelOperationMetadata_State = 1
	// The training has succeeded.
	CreateConversationModelOperationMetadata_SUCCEEDED CreateConversationModelOperationMetadata_State = 2
	// The training has succeeded.
	CreateConversationModelOperationMetadata_FAILED CreateConversationModelOperationMetadata_State = 3
	// The training has been cancelled.
	CreateConversationModelOperationMetadata_CANCELLED CreateConversationModelOperationMetadata_State = 4
	// The training is in cancelling state.
	CreateConversationModelOperationMetadata_CANCELLING CreateConversationModelOperationMetadata_State = 5
	// Custom model is training.
	CreateConversationModelOperationMetadata_TRAINING CreateConversationModelOperationMetadata_State = 6
)

// Enum value maps for CreateConversationModelOperationMetadata_State.
var (
	CreateConversationModelOperationMetadata_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "SUCCEEDED",
		3: "FAILED",
		4: "CANCELLED",
		5: "CANCELLING",
		6: "TRAINING",
	}
	CreateConversationModelOperationMetadata_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"SUCCEEDED":         2,
		"FAILED":            3,
		"CANCELLED":         4,
		"CANCELLING":        5,
		"TRAINING":          6,
	}
)

func (x CreateConversationModelOperationMetadata_State) Enum() *CreateConversationModelOperationMetadata_State {
	p := new(CreateConversationModelOperationMetadata_State)
	*p = x
	return p
}

func (x CreateConversationModelOperationMetadata_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CreateConversationModelOperationMetadata_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_enumTypes[2].Descriptor()
}

func (CreateConversationModelOperationMetadata_State) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_conversation_model_proto_enumTypes[2]
}

func (x CreateConversationModelOperationMetadata_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CreateConversationModelOperationMetadata_State.Descriptor instead.
func (CreateConversationModelOperationMetadata_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{18, 0}
}

// State of CreateConversationModel operation.
type CreateConversationModelEvaluationOperationMetadata_State int32

const (
	// Operation status not specified.
	CreateConversationModelEvaluationOperationMetadata_STATE_UNSPECIFIED CreateConversationModelEvaluationOperationMetadata_State = 0
	// The operation is being prepared.
	CreateConversationModelEvaluationOperationMetadata_INITIALIZING CreateConversationModelEvaluationOperationMetadata_State = 1
	// The operation is running.
	CreateConversationModelEvaluationOperationMetadata_RUNNING CreateConversationModelEvaluationOperationMetadata_State = 2
	// The operation is cancelled.
	CreateConversationModelEvaluationOperationMetadata_CANCELLED CreateConversationModelEvaluationOperationMetadata_State = 3
	// The operation has succeeded.
	CreateConversationModelEvaluationOperationMetadata_SUCCEEDED CreateConversationModelEvaluationOperationMetadata_State = 4
	// The operation has failed.
	CreateConversationModelEvaluationOperationMetadata_FAILED CreateConversationModelEvaluationOperationMetadata_State = 5
)

// Enum value maps for CreateConversationModelEvaluationOperationMetadata_State.
var (
	CreateConversationModelEvaluationOperationMetadata_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "INITIALIZING",
		2: "RUNNING",
		3: "CANCELLED",
		4: "SUCCEEDED",
		5: "FAILED",
	}
	CreateConversationModelEvaluationOperationMetadata_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"INITIALIZING":      1,
		"RUNNING":           2,
		"CANCELLED":         3,
		"SUCCEEDED":         4,
		"FAILED":            5,
	}
)

func (x CreateConversationModelEvaluationOperationMetadata_State) Enum() *CreateConversationModelEvaluationOperationMetadata_State {
	p := new(CreateConversationModelEvaluationOperationMetadata_State)
	*p = x
	return p
}

func (x CreateConversationModelEvaluationOperationMetadata_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CreateConversationModelEvaluationOperationMetadata_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_enumTypes[3].Descriptor()
}

func (CreateConversationModelEvaluationOperationMetadata_State) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_conversation_model_proto_enumTypes[3]
}

func (x CreateConversationModelEvaluationOperationMetadata_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CreateConversationModelEvaluationOperationMetadata_State.Descriptor instead.
func (CreateConversationModelEvaluationOperationMetadata_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{22, 0}
}

// Represents a conversation model.
type ConversationModel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ConversationModel resource name. Format:
	// `projects/<Project ID>/conversationModels/<Conversation Model ID>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the model. At most 64 bytes long.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. Creation time of this model.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Required. Datasets used to create model.
	Datasets []*InputDataset `protobuf:"bytes,4,rep,name=datasets,proto3" json:"datasets,omitempty"`
	// Output only. State of the model. A model can only serve prediction requests
	// after it gets deployed.
	State ConversationModel_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.dialogflow.v2.ConversationModel_State" json:"state,omitempty"`
	// Language code for the conversation model. If not specified, the language
	// is en-US. Language at ConversationModel should be set for all non en-us
	// languages.
	// This should be a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
	// language tag. Example: "en-US".
	LanguageCode string `protobuf:"bytes,19,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Required.
	// The model metadata that is specific to the problem type.
	// Must match the metadata type of the dataset used to train the model.
	//
	// Types that are assignable to ModelMetadata:
	//
	//	*ConversationModel_ArticleSuggestionModelMetadata
	//	*ConversationModel_SmartReplyModelMetadata
	ModelMetadata isConversationModel_ModelMetadata `protobuf_oneof:"model_metadata"`
}

func (x *ConversationModel) Reset() {
	*x = ConversationModel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConversationModel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationModel) ProtoMessage() {}

func (x *ConversationModel) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationModel.ProtoReflect.Descriptor instead.
func (*ConversationModel) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{0}
}

func (x *ConversationModel) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ConversationModel) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ConversationModel) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ConversationModel) GetDatasets() []*InputDataset {
	if x != nil {
		return x.Datasets
	}
	return nil
}

func (x *ConversationModel) GetState() ConversationModel_State {
	if x != nil {
		return x.State
	}
	return ConversationModel_STATE_UNSPECIFIED
}

func (x *ConversationModel) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (m *ConversationModel) GetModelMetadata() isConversationModel_ModelMetadata {
	if m != nil {
		return m.ModelMetadata
	}
	return nil
}

func (x *ConversationModel) GetArticleSuggestionModelMetadata() *ArticleSuggestionModelMetadata {
	if x, ok := x.GetModelMetadata().(*ConversationModel_ArticleSuggestionModelMetadata); ok {
		return x.ArticleSuggestionModelMetadata
	}
	return nil
}

func (x *ConversationModel) GetSmartReplyModelMetadata() *SmartReplyModelMetadata {
	if x, ok := x.GetModelMetadata().(*ConversationModel_SmartReplyModelMetadata); ok {
		return x.SmartReplyModelMetadata
	}
	return nil
}

type isConversationModel_ModelMetadata interface {
	isConversationModel_ModelMetadata()
}

type ConversationModel_ArticleSuggestionModelMetadata struct {
	// Metadata for article suggestion models.
	ArticleSuggestionModelMetadata *ArticleSuggestionModelMetadata `protobuf:"bytes,8,opt,name=article_suggestion_model_metadata,json=articleSuggestionModelMetadata,proto3,oneof"`
}

type ConversationModel_SmartReplyModelMetadata struct {
	// Metadata for smart reply models.
	SmartReplyModelMetadata *SmartReplyModelMetadata `protobuf:"bytes,9,opt,name=smart_reply_model_metadata,json=smartReplyModelMetadata,proto3,oneof"`
}

func (*ConversationModel_ArticleSuggestionModelMetadata) isConversationModel_ModelMetadata() {}

func (*ConversationModel_SmartReplyModelMetadata) isConversationModel_ModelMetadata() {}

// Represents evaluation result of a conversation model.
type ConversationModelEvaluation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the evaluation. Format:
	// `projects/<Project ID>/conversationModels/<Conversation Model
	// ID>/evaluations/<Evaluation ID>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The display name of the model evaluation. At most 64 bytes long.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. The configuration of the evaluation task.
	EvaluationConfig *EvaluationConfig `protobuf:"bytes,6,opt,name=evaluation_config,json=evaluationConfig,proto3" json:"evaluation_config,omitempty"`
	// Output only. Creation time of this model.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Metrics details.
	//
	// Types that are assignable to Metrics:
	//
	//	*ConversationModelEvaluation_SmartReplyMetrics
	Metrics isConversationModelEvaluation_Metrics `protobuf_oneof:"metrics"`
	// Output only. Human eval template in csv format.
	// It tooks real-world conversations provided through input dataset, generates
	// example suggestions for customer to verify quality of the model.
	// For Smart Reply, the generated csv file contains columns of
	// Context, (Suggestions,Q1,Q2)*3, Actual reply.
	// Context contains at most 10 latest messages in the conversation prior to
	// the current suggestion.
	// Q1: "Would you send it as the next message of agent?"
	// Evaluated based on whether the suggest is appropriate to be sent by
	// agent in current context.
	// Q2: "Does the suggestion move the conversation closer to resolution?"
	// Evaluated based on whether the suggestion provide solutions, or answers
	// customer's question or collect information from customer to resolve the
	// customer's issue.
	// Actual reply column contains the actual agent reply sent in the context.
	RawHumanEvalTemplateCsv string `protobuf:"bytes,8,opt,name=raw_human_eval_template_csv,json=rawHumanEvalTemplateCsv,proto3" json:"raw_human_eval_template_csv,omitempty"`
}

func (x *ConversationModelEvaluation) Reset() {
	*x = ConversationModelEvaluation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConversationModelEvaluation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationModelEvaluation) ProtoMessage() {}

func (x *ConversationModelEvaluation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationModelEvaluation.ProtoReflect.Descriptor instead.
func (*ConversationModelEvaluation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{1}
}

func (x *ConversationModelEvaluation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ConversationModelEvaluation) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ConversationModelEvaluation) GetEvaluationConfig() *EvaluationConfig {
	if x != nil {
		return x.EvaluationConfig
	}
	return nil
}

func (x *ConversationModelEvaluation) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (m *ConversationModelEvaluation) GetMetrics() isConversationModelEvaluation_Metrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (x *ConversationModelEvaluation) GetSmartReplyMetrics() *SmartReplyMetrics {
	if x, ok := x.GetMetrics().(*ConversationModelEvaluation_SmartReplyMetrics); ok {
		return x.SmartReplyMetrics
	}
	return nil
}

func (x *ConversationModelEvaluation) GetRawHumanEvalTemplateCsv() string {
	if x != nil {
		return x.RawHumanEvalTemplateCsv
	}
	return ""
}

type isConversationModelEvaluation_Metrics interface {
	isConversationModelEvaluation_Metrics()
}

type ConversationModelEvaluation_SmartReplyMetrics struct {
	// Output only. Only available when model is for smart reply.
	SmartReplyMetrics *SmartReplyMetrics `protobuf:"bytes,5,opt,name=smart_reply_metrics,json=smartReplyMetrics,proto3,oneof"`
}

func (*ConversationModelEvaluation_SmartReplyMetrics) isConversationModelEvaluation_Metrics() {}

// The configuration for model evaluation.
type EvaluationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Datasets used for evaluation.
	Datasets []*InputDataset `protobuf:"bytes,3,rep,name=datasets,proto3" json:"datasets,omitempty"`
	// Specific configurations for different models in order to do evaluation.
	//
	// Types that are assignable to ModelSpecificConfig:
	//
	//	*EvaluationConfig_SmartReplyConfig_
	//	*EvaluationConfig_SmartComposeConfig_
	ModelSpecificConfig isEvaluationConfig_ModelSpecificConfig `protobuf_oneof:"model_specific_config"`
}

func (x *EvaluationConfig) Reset() {
	*x = EvaluationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EvaluationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EvaluationConfig) ProtoMessage() {}

func (x *EvaluationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EvaluationConfig.ProtoReflect.Descriptor instead.
func (*EvaluationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{2}
}

func (x *EvaluationConfig) GetDatasets() []*InputDataset {
	if x != nil {
		return x.Datasets
	}
	return nil
}

func (m *EvaluationConfig) GetModelSpecificConfig() isEvaluationConfig_ModelSpecificConfig {
	if m != nil {
		return m.ModelSpecificConfig
	}
	return nil
}

func (x *EvaluationConfig) GetSmartReplyConfig() *EvaluationConfig_SmartReplyConfig {
	if x, ok := x.GetModelSpecificConfig().(*EvaluationConfig_SmartReplyConfig_); ok {
		return x.SmartReplyConfig
	}
	return nil
}

func (x *EvaluationConfig) GetSmartComposeConfig() *EvaluationConfig_SmartComposeConfig {
	if x, ok := x.GetModelSpecificConfig().(*EvaluationConfig_SmartComposeConfig_); ok {
		return x.SmartComposeConfig
	}
	return nil
}

type isEvaluationConfig_ModelSpecificConfig interface {
	isEvaluationConfig_ModelSpecificConfig()
}

type EvaluationConfig_SmartReplyConfig_ struct {
	// Configuration for smart reply model evalution.
	SmartReplyConfig *EvaluationConfig_SmartReplyConfig `protobuf:"bytes,2,opt,name=smart_reply_config,json=smartReplyConfig,proto3,oneof"`
}

type EvaluationConfig_SmartComposeConfig_ struct {
	// Configuration for smart compose model evalution.
	SmartComposeConfig *EvaluationConfig_SmartComposeConfig `protobuf:"bytes,4,opt,name=smart_compose_config,json=smartComposeConfig,proto3,oneof"`
}

func (*EvaluationConfig_SmartReplyConfig_) isEvaluationConfig_ModelSpecificConfig() {}

func (*EvaluationConfig_SmartComposeConfig_) isEvaluationConfig_ModelSpecificConfig() {}

// InputDataset used to create model or do evaluation.
// NextID:5
type InputDataset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ConversationDataset resource name. Format:
	// `projects/<Project ID>/locations/<Location
	// ID>/conversationDatasets/<Conversation Dataset ID>`
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
}

func (x *InputDataset) Reset() {
	*x = InputDataset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InputDataset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InputDataset) ProtoMessage() {}

func (x *InputDataset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InputDataset.ProtoReflect.Descriptor instead.
func (*InputDataset) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{3}
}

func (x *InputDataset) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

// Metadata for article suggestion models.
type ArticleSuggestionModelMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Type of the article suggestion model. If not provided, model_type
	// is used.
	TrainingModelType ConversationModel_ModelType `protobuf:"varint,3,opt,name=training_model_type,json=trainingModelType,proto3,enum=google.cloud.dialogflow.v2.ConversationModel_ModelType" json:"training_model_type,omitempty"`
}

func (x *ArticleSuggestionModelMetadata) Reset() {
	*x = ArticleSuggestionModelMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArticleSuggestionModelMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArticleSuggestionModelMetadata) ProtoMessage() {}

func (x *ArticleSuggestionModelMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArticleSuggestionModelMetadata.ProtoReflect.Descriptor instead.
func (*ArticleSuggestionModelMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{4}
}

func (x *ArticleSuggestionModelMetadata) GetTrainingModelType() ConversationModel_ModelType {
	if x != nil {
		return x.TrainingModelType
	}
	return ConversationModel_MODEL_TYPE_UNSPECIFIED
}

// Metadata for smart reply models.
type SmartReplyModelMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Type of the smart reply model. If not provided, model_type is
	// used.
	TrainingModelType ConversationModel_ModelType `protobuf:"varint,6,opt,name=training_model_type,json=trainingModelType,proto3,enum=google.cloud.dialogflow.v2.ConversationModel_ModelType" json:"training_model_type,omitempty"`
}

func (x *SmartReplyModelMetadata) Reset() {
	*x = SmartReplyModelMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SmartReplyModelMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SmartReplyModelMetadata) ProtoMessage() {}

func (x *SmartReplyModelMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SmartReplyModelMetadata.ProtoReflect.Descriptor instead.
func (*SmartReplyModelMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{5}
}

func (x *SmartReplyModelMetadata) GetTrainingModelType() ConversationModel_ModelType {
	if x != nil {
		return x.TrainingModelType
	}
	return ConversationModel_MODEL_TYPE_UNSPECIFIED
}

// The evaluation metrics for smart reply model.
type SmartReplyMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Percentage of target participant messages in the evaluation dataset for
	// which similar messages have appeared at least once in the allowlist. Should
	// be [0, 1].
	AllowlistCoverage float32 `protobuf:"fixed32,1,opt,name=allowlist_coverage,json=allowlistCoverage,proto3" json:"allowlist_coverage,omitempty"`
	// Metrics of top n smart replies, sorted by [TopNMetric.n][].
	TopNMetrics []*SmartReplyMetrics_TopNMetrics `protobuf:"bytes,2,rep,name=top_n_metrics,json=topNMetrics,proto3" json:"top_n_metrics,omitempty"`
	// Total number of conversations used to generate this metric.
	ConversationCount int64 `protobuf:"varint,3,opt,name=conversation_count,json=conversationCount,proto3" json:"conversation_count,omitempty"`
}

func (x *SmartReplyMetrics) Reset() {
	*x = SmartReplyMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SmartReplyMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SmartReplyMetrics) ProtoMessage() {}

func (x *SmartReplyMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SmartReplyMetrics.ProtoReflect.Descriptor instead.
func (*SmartReplyMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{6}
}

func (x *SmartReplyMetrics) GetAllowlistCoverage() float32 {
	if x != nil {
		return x.AllowlistCoverage
	}
	return 0
}

func (x *SmartReplyMetrics) GetTopNMetrics() []*SmartReplyMetrics_TopNMetrics {
	if x != nil {
		return x.TopNMetrics
	}
	return nil
}

func (x *SmartReplyMetrics) GetConversationCount() int64 {
	if x != nil {
		return x.ConversationCount
	}
	return 0
}

// The request message for
// [ConversationModels.CreateConversationModel][google.cloud.dialogflow.v2.ConversationModels.CreateConversationModel]
type CreateConversationModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The project to create conversation model for. Format:
	// `projects/<Project ID>`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The conversation model to create.
	ConversationModel *ConversationModel `protobuf:"bytes,2,opt,name=conversation_model,json=conversationModel,proto3" json:"conversation_model,omitempty"`
}

func (x *CreateConversationModelRequest) Reset() {
	*x = CreateConversationModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateConversationModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConversationModelRequest) ProtoMessage() {}

func (x *CreateConversationModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConversationModelRequest.ProtoReflect.Descriptor instead.
func (*CreateConversationModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{7}
}

func (x *CreateConversationModelRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateConversationModelRequest) GetConversationModel() *ConversationModel {
	if x != nil {
		return x.ConversationModel
	}
	return nil
}

// The request message for
// [ConversationModels.GetConversationModel][google.cloud.dialogflow.v2.ConversationModels.GetConversationModel]
type GetConversationModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The conversation model to retrieve. Format:
	// `projects/<Project ID>/conversationModels/<Conversation Model ID>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetConversationModelRequest) Reset() {
	*x = GetConversationModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConversationModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversationModelRequest) ProtoMessage() {}

func (x *GetConversationModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversationModelRequest.ProtoReflect.Descriptor instead.
func (*GetConversationModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{8}
}

func (x *GetConversationModelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [ConversationModels.ListConversationModels][google.cloud.dialogflow.v2.ConversationModels.ListConversationModels]
type ListConversationModelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project to list all conversation models for.
	// Format: `projects/<Project ID>`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of conversation models to return in a single
	// page. By default 100 and at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListConversationModelsRequest) Reset() {
	*x = ListConversationModelsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConversationModelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversationModelsRequest) ProtoMessage() {}

func (x *ListConversationModelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversationModelsRequest.ProtoReflect.Descriptor instead.
func (*ListConversationModelsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{9}
}

func (x *ListConversationModelsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConversationModelsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConversationModelsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for
// [ConversationModels.ListConversationModels][google.cloud.dialogflow.v2.ConversationModels.ListConversationModels]
type ListConversationModelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of models to return.
	ConversationModels []*ConversationModel `protobuf:"bytes,1,rep,name=conversation_models,json=conversationModels,proto3" json:"conversation_models,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListConversationModelsResponse) Reset() {
	*x = ListConversationModelsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConversationModelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversationModelsResponse) ProtoMessage() {}

func (x *ListConversationModelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversationModelsResponse.ProtoReflect.Descriptor instead.
func (*ListConversationModelsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{10}
}

func (x *ListConversationModelsResponse) GetConversationModels() []*ConversationModel {
	if x != nil {
		return x.ConversationModels
	}
	return nil
}

func (x *ListConversationModelsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for
// [ConversationModels.DeleteConversationModel][google.cloud.dialogflow.v2.ConversationModels.DeleteConversationModel]
type DeleteConversationModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The conversation model to delete. Format:
	// `projects/<Project ID>/conversationModels/<Conversation Model ID>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteConversationModelRequest) Reset() {
	*x = DeleteConversationModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteConversationModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteConversationModelRequest) ProtoMessage() {}

func (x *DeleteConversationModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteConversationModelRequest.ProtoReflect.Descriptor instead.
func (*DeleteConversationModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{11}
}

func (x *DeleteConversationModelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [ConversationModels.DeployConversationModel][google.cloud.dialogflow.v2.ConversationModels.DeployConversationModel]
type DeployConversationModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The conversation model to deploy. Format:
	// `projects/<Project ID>/conversationModels/<Conversation Model ID>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeployConversationModelRequest) Reset() {
	*x = DeployConversationModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployConversationModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployConversationModelRequest) ProtoMessage() {}

func (x *DeployConversationModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployConversationModelRequest.ProtoReflect.Descriptor instead.
func (*DeployConversationModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{12}
}

func (x *DeployConversationModelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [ConversationModels.UndeployConversationModel][google.cloud.dialogflow.v2.ConversationModels.UndeployConversationModel]
type UndeployConversationModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The conversation model to undeploy. Format:
	// `projects/<Project ID>/conversationModels/<Conversation Model ID>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *UndeployConversationModelRequest) Reset() {
	*x = UndeployConversationModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeployConversationModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeployConversationModelRequest) ProtoMessage() {}

func (x *UndeployConversationModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeployConversationModelRequest.ProtoReflect.Descriptor instead.
func (*UndeployConversationModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{13}
}

func (x *UndeployConversationModelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [ConversationModels.GetConversationModelEvaluation][google.cloud.dialogflow.v2.ConversationModels.GetConversationModelEvaluation]
type GetConversationModelEvaluationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The conversation model evaluation resource name. Format:
	// `projects/<Project ID>/conversationModels/<Conversation Model
	// ID>/evaluations/<Evaluation ID>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetConversationModelEvaluationRequest) Reset() {
	*x = GetConversationModelEvaluationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConversationModelEvaluationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversationModelEvaluationRequest) ProtoMessage() {}

func (x *GetConversationModelEvaluationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversationModelEvaluationRequest.ProtoReflect.Descriptor instead.
func (*GetConversationModelEvaluationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{14}
}

func (x *GetConversationModelEvaluationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [ConversationModels.ListConversationModelEvaluations][google.cloud.dialogflow.v2.ConversationModels.ListConversationModelEvaluations]
type ListConversationModelEvaluationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The conversation model resource name. Format:
	// `projects/<Project ID>/conversationModels/<Conversation Model ID>`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of evaluations to return in a
	// single page. By default 100 and at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListConversationModelEvaluationsRequest) Reset() {
	*x = ListConversationModelEvaluationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConversationModelEvaluationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversationModelEvaluationsRequest) ProtoMessage() {}

func (x *ListConversationModelEvaluationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversationModelEvaluationsRequest.ProtoReflect.Descriptor instead.
func (*ListConversationModelEvaluationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{15}
}

func (x *ListConversationModelEvaluationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConversationModelEvaluationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConversationModelEvaluationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for
// [ConversationModels.ListConversationModelEvaluations][google.cloud.dialogflow.v2.ConversationModels.ListConversationModelEvaluations]
type ListConversationModelEvaluationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of evaluations to return.
	ConversationModelEvaluations []*ConversationModelEvaluation `protobuf:"bytes,1,rep,name=conversation_model_evaluations,json=conversationModelEvaluations,proto3" json:"conversation_model_evaluations,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListConversationModelEvaluationsResponse) Reset() {
	*x = ListConversationModelEvaluationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConversationModelEvaluationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversationModelEvaluationsResponse) ProtoMessage() {}

func (x *ListConversationModelEvaluationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversationModelEvaluationsResponse.ProtoReflect.Descriptor instead.
func (*ListConversationModelEvaluationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{16}
}

func (x *ListConversationModelEvaluationsResponse) GetConversationModelEvaluations() []*ConversationModelEvaluation {
	if x != nil {
		return x.ConversationModelEvaluations
	}
	return nil
}

func (x *ListConversationModelEvaluationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for
// [ConversationModels.CreateConversationModelEvaluation][google.cloud.dialogflow.v2.ConversationModels.CreateConversationModelEvaluation]
type CreateConversationModelEvaluationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The conversation model resource name. Format:
	// `projects/<Project ID>/locations/<Location
	// ID>/conversationModels/<Conversation Model ID>`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The conversation model evaluation to be created.
	ConversationModelEvaluation *ConversationModelEvaluation `protobuf:"bytes,2,opt,name=conversation_model_evaluation,json=conversationModelEvaluation,proto3" json:"conversation_model_evaluation,omitempty"`
}

func (x *CreateConversationModelEvaluationRequest) Reset() {
	*x = CreateConversationModelEvaluationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateConversationModelEvaluationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConversationModelEvaluationRequest) ProtoMessage() {}

func (x *CreateConversationModelEvaluationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConversationModelEvaluationRequest.ProtoReflect.Descriptor instead.
func (*CreateConversationModelEvaluationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{17}
}

func (x *CreateConversationModelEvaluationRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateConversationModelEvaluationRequest) GetConversationModelEvaluation() *ConversationModelEvaluation {
	if x != nil {
		return x.ConversationModelEvaluation
	}
	return nil
}

// Metadata for a
// [ConversationModels.CreateConversationModel][google.cloud.dialogflow.v2.ConversationModels.CreateConversationModel]
// operation.
type CreateConversationModelOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the conversation model. Format:
	// `projects/<Project ID>/conversationModels/<Conversation Model Id>`
	ConversationModel string `protobuf:"bytes,1,opt,name=conversation_model,json=conversationModel,proto3" json:"conversation_model,omitempty"`
	// State of CreateConversationModel operation.
	State CreateConversationModelOperationMetadata_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.dialogflow.v2.CreateConversationModelOperationMetadata_State" json:"state,omitempty"`
	// Timestamp when the request to create conversation model is submitted. The
	// time is measured on server side.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *CreateConversationModelOperationMetadata) Reset() {
	*x = CreateConversationModelOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateConversationModelOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConversationModelOperationMetadata) ProtoMessage() {}

func (x *CreateConversationModelOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConversationModelOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateConversationModelOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{18}
}

func (x *CreateConversationModelOperationMetadata) GetConversationModel() string {
	if x != nil {
		return x.ConversationModel
	}
	return ""
}

func (x *CreateConversationModelOperationMetadata) GetState() CreateConversationModelOperationMetadata_State {
	if x != nil {
		return x.State
	}
	return CreateConversationModelOperationMetadata_STATE_UNSPECIFIED
}

func (x *CreateConversationModelOperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Metadata for a
// [ConversationModels.DeployConversationModel][google.cloud.dialogflow.v2.ConversationModels.DeployConversationModel]
// operation.
type DeployConversationModelOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the conversation model. Format:
	// `projects/<Project ID>/conversationModels/<Conversation Model Id>`
	ConversationModel string `protobuf:"bytes,1,opt,name=conversation_model,json=conversationModel,proto3" json:"conversation_model,omitempty"`
	// Timestamp when request to deploy conversation model was submitted. The time
	// is measured on server side.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *DeployConversationModelOperationMetadata) Reset() {
	*x = DeployConversationModelOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployConversationModelOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployConversationModelOperationMetadata) ProtoMessage() {}

func (x *DeployConversationModelOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployConversationModelOperationMetadata.ProtoReflect.Descriptor instead.
func (*DeployConversationModelOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{19}
}

func (x *DeployConversationModelOperationMetadata) GetConversationModel() string {
	if x != nil {
		return x.ConversationModel
	}
	return ""
}

func (x *DeployConversationModelOperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Metadata for a
// [ConversationModels.UndeployConversationModel][google.cloud.dialogflow.v2.ConversationModels.UndeployConversationModel]
// operation.
type UndeployConversationModelOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the conversation model. Format:
	// `projects/<Project ID>/conversationModels/<Conversation Model Id>`
	ConversationModel string `protobuf:"bytes,1,opt,name=conversation_model,json=conversationModel,proto3" json:"conversation_model,omitempty"`
	// Timestamp when the request to undeploy conversation model was submitted.
	// The time is measured on server side.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *UndeployConversationModelOperationMetadata) Reset() {
	*x = UndeployConversationModelOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeployConversationModelOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeployConversationModelOperationMetadata) ProtoMessage() {}

func (x *UndeployConversationModelOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeployConversationModelOperationMetadata.ProtoReflect.Descriptor instead.
func (*UndeployConversationModelOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{20}
}

func (x *UndeployConversationModelOperationMetadata) GetConversationModel() string {
	if x != nil {
		return x.ConversationModel
	}
	return ""
}

func (x *UndeployConversationModelOperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Metadata for a
// [ConversationModels.DeleteConversationModel][google.cloud.dialogflow.v2.ConversationModels.DeleteConversationModel]
// operation.
type DeleteConversationModelOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the conversation model. Format:
	// `projects/<Project ID>/conversationModels/<Conversation Model Id>`
	ConversationModel string `protobuf:"bytes,1,opt,name=conversation_model,json=conversationModel,proto3" json:"conversation_model,omitempty"`
	// Timestamp when delete conversation model request was created. The time is
	// measured on server side.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *DeleteConversationModelOperationMetadata) Reset() {
	*x = DeleteConversationModelOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteConversationModelOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteConversationModelOperationMetadata) ProtoMessage() {}

func (x *DeleteConversationModelOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteConversationModelOperationMetadata.ProtoReflect.Descriptor instead.
func (*DeleteConversationModelOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{21}
}

func (x *DeleteConversationModelOperationMetadata) GetConversationModel() string {
	if x != nil {
		return x.ConversationModel
	}
	return ""
}

func (x *DeleteConversationModelOperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Metadata for a
// [ConversationModels.CreateConversationModelEvaluation][google.cloud.dialogflow.v2.ConversationModels.CreateConversationModelEvaluation]
// operation.
type CreateConversationModelEvaluationOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the conversation model. Format:
	// `projects/<Project ID>/locations/<Location
	// ID>/conversationModels/<Conversation Model Id>/evaluations/<Evaluation Id>`
	ConversationModelEvaluation string `protobuf:"bytes,1,opt,name=conversation_model_evaluation,json=conversationModelEvaluation,proto3" json:"conversation_model_evaluation,omitempty"`
	// The resource name of the conversation model. Format:
	// `projects/<Project ID>/locations/<Location
	// ID>/conversationModels/<Conversation Model Id>`
	ConversationModel string `protobuf:"bytes,4,opt,name=conversation_model,json=conversationModel,proto3" json:"conversation_model,omitempty"`
	// State of CreateConversationModel operation.
	State CreateConversationModelEvaluationOperationMetadata_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.dialogflow.v2.CreateConversationModelEvaluationOperationMetadata_State" json:"state,omitempty"`
	// Timestamp when the request to create conversation model was submitted. The
	// time is measured on server side.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *CreateConversationModelEvaluationOperationMetadata) Reset() {
	*x = CreateConversationModelEvaluationOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateConversationModelEvaluationOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConversationModelEvaluationOperationMetadata) ProtoMessage() {}

func (x *CreateConversationModelEvaluationOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConversationModelEvaluationOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateConversationModelEvaluationOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{22}
}

func (x *CreateConversationModelEvaluationOperationMetadata) GetConversationModelEvaluation() string {
	if x != nil {
		return x.ConversationModelEvaluation
	}
	return ""
}

func (x *CreateConversationModelEvaluationOperationMetadata) GetConversationModel() string {
	if x != nil {
		return x.ConversationModel
	}
	return ""
}

func (x *CreateConversationModelEvaluationOperationMetadata) GetState() CreateConversationModelEvaluationOperationMetadata_State {
	if x != nil {
		return x.State
	}
	return CreateConversationModelEvaluationOperationMetadata_STATE_UNSPECIFIED
}

func (x *CreateConversationModelEvaluationOperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Smart reply specific configuration for evaluation job.
type EvaluationConfig_SmartReplyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The allowlist document resource name.
	// Format: `projects/<Project ID>/knowledgeBases/<Knowledge Base
	// ID>/documents/<Document ID>`. Only used for smart reply model.
	AllowlistDocument string `protobuf:"bytes,1,opt,name=allowlist_document,json=allowlistDocument,proto3" json:"allowlist_document,omitempty"`
	// Required. The model to be evaluated can return multiple results with
	// confidence score on each query. These results will be sorted by the
	// descending order of the scores and we only keep the first
	// max_result_count results as the final results to evaluate.
	MaxResultCount int32 `protobuf:"varint,2,opt,name=max_result_count,json=maxResultCount,proto3" json:"max_result_count,omitempty"`
}

func (x *EvaluationConfig_SmartReplyConfig) Reset() {
	*x = EvaluationConfig_SmartReplyConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EvaluationConfig_SmartReplyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EvaluationConfig_SmartReplyConfig) ProtoMessage() {}

func (x *EvaluationConfig_SmartReplyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EvaluationConfig_SmartReplyConfig.ProtoReflect.Descriptor instead.
func (*EvaluationConfig_SmartReplyConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{2, 0}
}

func (x *EvaluationConfig_SmartReplyConfig) GetAllowlistDocument() string {
	if x != nil {
		return x.AllowlistDocument
	}
	return ""
}

func (x *EvaluationConfig_SmartReplyConfig) GetMaxResultCount() int32 {
	if x != nil {
		return x.MaxResultCount
	}
	return 0
}

// Smart compose specific configuration for evaluation job.
type EvaluationConfig_SmartComposeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The allowlist document resource name.
	// Format: `projects/<Project ID>/knowledgeBases/<Knowledge Base
	// ID>/documents/<Document ID>`. Only used for smart compose model.
	AllowlistDocument string `protobuf:"bytes,1,opt,name=allowlist_document,json=allowlistDocument,proto3" json:"allowlist_document,omitempty"`
	// Required. The model to be evaluated can return multiple results with
	// confidence score on each query. These results will be sorted by the
	// descending order of the scores and we only keep the first
	// max_result_count results as the final results to evaluate.
	MaxResultCount int32 `protobuf:"varint,2,opt,name=max_result_count,json=maxResultCount,proto3" json:"max_result_count,omitempty"`
}

func (x *EvaluationConfig_SmartComposeConfig) Reset() {
	*x = EvaluationConfig_SmartComposeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EvaluationConfig_SmartComposeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EvaluationConfig_SmartComposeConfig) ProtoMessage() {}

func (x *EvaluationConfig_SmartComposeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EvaluationConfig_SmartComposeConfig.ProtoReflect.Descriptor instead.
func (*EvaluationConfig_SmartComposeConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{2, 1}
}

func (x *EvaluationConfig_SmartComposeConfig) GetAllowlistDocument() string {
	if x != nil {
		return x.AllowlistDocument
	}
	return ""
}

func (x *EvaluationConfig_SmartComposeConfig) GetMaxResultCount() int32 {
	if x != nil {
		return x.MaxResultCount
	}
	return 0
}

// Evaluation metrics when retrieving `n` smart replies with the model.
type SmartReplyMetrics_TopNMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of retrieved smart replies. For example, when `n` is 3, this
	// evaluation contains metrics for when Dialogflow retrieves 3 smart replies
	// with the model.
	N int32 `protobuf:"varint,1,opt,name=n,proto3" json:"n,omitempty"`
	// Defined as `number of queries whose top n smart replies have at least one
	// similar (token match similarity above the defined threshold) reply as the
	// real reply` divided by `number of queries with at least one smart reply`.
	// Value ranges from 0.0 to 1.0 inclusive.
	Recall float32 `protobuf:"fixed32,2,opt,name=recall,proto3" json:"recall,omitempty"`
}

func (x *SmartReplyMetrics_TopNMetrics) Reset() {
	*x = SmartReplyMetrics_TopNMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SmartReplyMetrics_TopNMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SmartReplyMetrics_TopNMetrics) ProtoMessage() {}

func (x *SmartReplyMetrics_TopNMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SmartReplyMetrics_TopNMetrics.ProtoReflect.Descriptor instead.
func (*SmartReplyMetrics_TopNMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP(), []int{6, 0}
}

func (x *SmartReplyMetrics_TopNMetrics) GetN() int32 {
	if x != nil {
		return x.N
	}
	return 0
}

func (x *SmartReplyMetrics_TopNMetrics) GetRecall() float32 {
	if x != nil {
		return x.Recall
	}
	return 0
}

var File_google_cloud_dialogflow_v2_conversation_model_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_v2_conversation_model_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x9f, 0x08, 0x0a, 0x11, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x08, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x12, 0x4e, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x87, 0x01, 0x0a, 0x21,
	0x61, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x5f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x53, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x1e, 0x61, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x53, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x72, 0x0a, 0x1a, 0x73, 0x6d, 0x61, 0x72, 0x74, 0x5f, 0x72,
	0x65, 0x70, 0x6c, 0x79, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x6d, 0x61, 0x72, 0x74, 0x52, 0x65, 0x70, 0x6c,
	0x79, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00,
	0x52, 0x17, 0x73, 0x6d, 0x61, 0x72, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x91, 0x01, 0x0a, 0x05, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52,
	0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x55, 0x4e, 0x44, 0x45,
	0x50, 0x4c, 0x4f, 0x59, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x44, 0x45, 0x50, 0x4c,
	0x4f, 0x59, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x50, 0x4c, 0x4f,
	0x59, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x44, 0x45, 0x50, 0x4c, 0x4f,
	0x59, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x06, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x07,
	0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x08, 0x22, 0x67, 0x0a,
	0x09, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x4d, 0x4f,
	0x44, 0x45, 0x4c, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x22, 0x0a, 0x1e, 0x53, 0x4d, 0x41, 0x52, 0x54, 0x5f,
	0x52, 0x45, 0x50, 0x4c, 0x59, 0x5f, 0x44, 0x55, 0x41, 0x4c, 0x5f, 0x45, 0x4e, 0x43, 0x4f, 0x44,
	0x45, 0x52, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x10, 0x02, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x4d,
	0x41, 0x52, 0x54, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x59, 0x5f, 0x42, 0x45, 0x52, 0x54, 0x5f, 0x4d,
	0x4f, 0x44, 0x45, 0x4c, 0x10, 0x06, 0x3a, 0xbe, 0x01, 0xea, 0x41, 0xba, 0x01, 0x0a, 0x2b, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x4f, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x7d, 0x12, 0x3a, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x7d, 0x42, 0x10, 0x0a, 0x0e, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xac, 0x05, 0x0a, 0x1b, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45,
	0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x5e, 0x0a, 0x11, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x76,
	0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x10, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x64, 0x0a, 0x13, 0x73, 0x6d, 0x61, 0x72, 0x74,
	0x5f, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x53, 0x6d, 0x61, 0x72, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x11, 0x73, 0x6d, 0x61, 0x72,
	0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x41, 0x0a,
	0x1b, 0x72, 0x61, 0x77, 0x5f, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x65, 0x76, 0x61, 0x6c, 0x5f,
	0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x73, 0x76, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x72, 0x61, 0x77, 0x48, 0x75, 0x6d, 0x61,
	0x6e, 0x45, 0x76, 0x61, 0x6c, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x43, 0x73, 0x76,
	0x3a, 0xfa, 0x01, 0xea, 0x41, 0xf6, 0x01, 0x0a, 0x35, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x53,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x7d, 0x2f, 0x65, 0x76, 0x61, 0x6c, 0x75,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x12, 0x68, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f,
	0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x7d, 0x2f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x42, 0x09, 0x0a,
	0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x22, 0x94, 0x05, 0x0a, 0x10, 0x45, 0x76, 0x61,
	0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x49, 0x0a,
	0x08, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x12, 0x6d, 0x0a, 0x12, 0x73, 0x6d, 0x61, 0x72,
	0x74, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x53, 0x6d, 0x61, 0x72, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x10, 0x73, 0x6d, 0x61, 0x72, 0x74, 0x52, 0x65, 0x70, 0x6c,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x73, 0x0a, 0x14, 0x73, 0x6d, 0x61, 0x72, 0x74,
	0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x53, 0x6d, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x12, 0x73, 0x6d, 0x61, 0x72, 0x74, 0x43,
	0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x99, 0x01, 0x0a,
	0x10, 0x53, 0x6d, 0x61, 0x72, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x56, 0x0a, 0x12, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xfa,
	0x41, 0x24, 0x0a, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x6c, 0x69, 0x73,
	0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2d, 0x0a, 0x10, 0x6d, 0x61, 0x78,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x9b, 0x01, 0x0a, 0x12, 0x53, 0x6d, 0x61,
	0x72, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x56, 0x0a, 0x12, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xfa, 0x41, 0x24,
	0x0a, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x6c, 0x69, 0x73, 0x74, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2d, 0x0a, 0x10, 0x6d, 0x61, 0x78, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x17, 0x0a, 0x15, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f,
	0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22,
	0x5f, 0x0a, 0x0c, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12,
	0x4f, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x22, 0x8e, 0x01, 0x0a, 0x1e, 0x41, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x53, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x6c, 0x0a, 0x13, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x54, 0x79, 0x70,
	0x65, 0x22, 0x87, 0x01, 0x0a, 0x17, 0x53, 0x6d, 0x61, 0x72, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x6c, 0x0a,
	0x13, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x54,
	0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69,
	0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x22, 0x85, 0x02, 0x0a, 0x11,
	0x53, 0x6d, 0x61, 0x72, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x12, 0x2d, 0x0a, 0x12, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x11, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x6c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65,
	0x12, 0x5d, 0x0a, 0x0d, 0x74, 0x6f, 0x70, 0x5f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x6d, 0x61, 0x72, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x54, 0x6f, 0x70, 0x4e, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x52, 0x0b, 0x74, 0x6f, 0x70, 0x4e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12,
	0x2d, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x33,
	0x0a, 0x0b, 0x54, 0x6f, 0x70, 0x4e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x0c, 0x0a,
	0x01, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x01, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x72,
	0x65, 0x63, 0x61, 0x6c, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x06, 0x72, 0x65, 0x63,
	0x61, 0x6c, 0x6c, 0x22, 0x9b, 0x01, 0x0a, 0x1e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x61,
	0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x22, 0x36, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x82, 0x01, 0x0a, 0x1d, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa8,
	0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x5e, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x12, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x39, 0x0a, 0x1e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x39, 0x0a, 0x1e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x3b, 0x0a, 0x20, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x40, 0x0a, 0x25,
	0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x8c,
	0x01, 0x0a, 0x27, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xd1, 0x01,
	0x0a, 0x28, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x7d, 0x0a, 0x1e, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x5f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x1c, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76,
	0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x84, 0x02, 0x0a, 0x28, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61,
	0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x55,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3d,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x37, 0x12, 0x35, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x80, 0x01, 0x0a, 0x1d, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x65, 0x76, 0x61,
	0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c,
	0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x1b, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76,
	0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xed, 0x02, 0x0a, 0x28, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x12, 0x60, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x22, 0x73, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01,
	0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x02, 0x12,
	0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x43,
	0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x41,
	0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08, 0x54, 0x52,
	0x41, 0x49, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x06, 0x22, 0x96, 0x01, 0x0a, 0x28, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x22, 0x98, 0x01, 0x0a, 0x2a, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12,
	0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x96, 0x01, 0x0a,
	0x28, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xb9, 0x03, 0x0a, 0x32, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x42, 0x0a, 0x1d,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x5f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x1b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12,
	0x6a, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x54,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x67, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x49, 0x4e, 0x49, 0x54,
	0x49, 0x41, 0x4c, 0x49, 0x5a, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55,
	0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45,
	0x4c, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45,
	0x44, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10,
	0x05, 0x32, 0xfe, 0x16, 0x0a, 0x12, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x12, 0xe8, 0x02, 0x0a, 0x17, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xf1, 0x01, 0xca, 0x41, 0x3d, 0x0a, 0x11, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x28, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x19, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x8e, 0x01, 0x3a, 0x12, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5a, 0x4c, 0x3a, 0x12, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x22,
	0x36, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x22, 0x2a, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x73, 0x12, 0xf3, 0x01, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x22, 0x73, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x66, 0x5a, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x2a, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x86, 0x02, 0x0a, 0x16, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x75, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x66, 0x5a, 0x38, 0x12, 0x36,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x12, 0x2a, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x73, 0x12, 0xae, 0x02, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb7, 0x01, 0xca, 0x41, 0x41, 0x0a,
	0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x28, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x66, 0x5a, 0x38, 0x2a,
	0x36, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x2a, 0x2a, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xbb, 0x02, 0x0a, 0x17, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc4, 0x01, 0xca, 0x41, 0x41,
	0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x28, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x7a, 0x3a, 0x01, 0x2a, 0x5a, 0x42, 0x3a, 0x01, 0x2a, 0x22,
	0x3d, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x22, 0x31,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x12, 0xc5, 0x02, 0x0a, 0x19, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x6e, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xca, 0x01, 0xca,
	0x41, 0x43, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x2a, 0x55, 0x6e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x7e, 0x3a, 0x01, 0x2a, 0x5a, 0x44,
	0x3a, 0x01, 0x2a, 0x22, 0x3f, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x75, 0x6e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x22, 0x33, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x75, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x12, 0xaf, 0x02, 0x0a, 0x1e, 0x47, 0x65,
	0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76,
	0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76,
	0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x90, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x82, 0x01, 0x5a, 0x46, 0x12, 0x44, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73,
	0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0x38, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x61,
	0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc2, 0x02, 0x0a, 0x20,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x92, 0x01, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x82, 0x01, 0x5a, 0x46,
	0x12, 0x44, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x76, 0x61, 0x6c, 0x75,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x38, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0xd5, 0x02, 0x0a, 0x21, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c,
	0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xca, 0x01, 0xca, 0x41,
	0x51, 0x0a, 0x1b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x32,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x24, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x65,
	0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x3a,
	0x01, 0x2a, 0x22, 0x44, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x76, 0x61,
	0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x78, 0xca, 0x41, 0x19, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x59, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x42, 0x9f, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x42, 0x16, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x70, 0x62, 0x3b, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x70, 0x62, 0xf8,
	0x01, 0x01, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescData = file_google_cloud_dialogflow_v2_conversation_model_proto_rawDesc
)

func file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_v2_conversation_model_proto_rawDescData
}

var file_google_cloud_dialogflow_v2_conversation_model_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes = make([]protoimpl.MessageInfo, 26)
var file_google_cloud_dialogflow_v2_conversation_model_proto_goTypes = []interface{}{
	(ConversationModel_State)(0),                                  // 0: google.cloud.dialogflow.v2.ConversationModel.State
	(ConversationModel_ModelType)(0),                              // 1: google.cloud.dialogflow.v2.ConversationModel.ModelType
	(CreateConversationModelOperationMetadata_State)(0),           // 2: google.cloud.dialogflow.v2.CreateConversationModelOperationMetadata.State
	(CreateConversationModelEvaluationOperationMetadata_State)(0), // 3: google.cloud.dialogflow.v2.CreateConversationModelEvaluationOperationMetadata.State
	(*ConversationModel)(nil),                                     // 4: google.cloud.dialogflow.v2.ConversationModel
	(*ConversationModelEvaluation)(nil),                           // 5: google.cloud.dialogflow.v2.ConversationModelEvaluation
	(*EvaluationConfig)(nil),                                      // 6: google.cloud.dialogflow.v2.EvaluationConfig
	(*InputDataset)(nil),                                          // 7: google.cloud.dialogflow.v2.InputDataset
	(*ArticleSuggestionModelMetadata)(nil),                        // 8: google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata
	(*SmartReplyModelMetadata)(nil),                               // 9: google.cloud.dialogflow.v2.SmartReplyModelMetadata
	(*SmartReplyMetrics)(nil),                                     // 10: google.cloud.dialogflow.v2.SmartReplyMetrics
	(*CreateConversationModelRequest)(nil),                        // 11: google.cloud.dialogflow.v2.CreateConversationModelRequest
	(*GetConversationModelRequest)(nil),                           // 12: google.cloud.dialogflow.v2.GetConversationModelRequest
	(*ListConversationModelsRequest)(nil),                         // 13: google.cloud.dialogflow.v2.ListConversationModelsRequest
	(*ListConversationModelsResponse)(nil),                        // 14: google.cloud.dialogflow.v2.ListConversationModelsResponse
	(*DeleteConversationModelRequest)(nil),                        // 15: google.cloud.dialogflow.v2.DeleteConversationModelRequest
	(*DeployConversationModelRequest)(nil),                        // 16: google.cloud.dialogflow.v2.DeployConversationModelRequest
	(*UndeployConversationModelRequest)(nil),                      // 17: google.cloud.dialogflow.v2.UndeployConversationModelRequest
	(*GetConversationModelEvaluationRequest)(nil),                 // 18: google.cloud.dialogflow.v2.GetConversationModelEvaluationRequest
	(*ListConversationModelEvaluationsRequest)(nil),               // 19: google.cloud.dialogflow.v2.ListConversationModelEvaluationsRequest
	(*ListConversationModelEvaluationsResponse)(nil),              // 20: google.cloud.dialogflow.v2.ListConversationModelEvaluationsResponse
	(*CreateConversationModelEvaluationRequest)(nil),              // 21: google.cloud.dialogflow.v2.CreateConversationModelEvaluationRequest
	(*CreateConversationModelOperationMetadata)(nil),              // 22: google.cloud.dialogflow.v2.CreateConversationModelOperationMetadata
	(*DeployConversationModelOperationMetadata)(nil),              // 23: google.cloud.dialogflow.v2.DeployConversationModelOperationMetadata
	(*UndeployConversationModelOperationMetadata)(nil),            // 24: google.cloud.dialogflow.v2.UndeployConversationModelOperationMetadata
	(*DeleteConversationModelOperationMetadata)(nil),              // 25: google.cloud.dialogflow.v2.DeleteConversationModelOperationMetadata
	(*CreateConversationModelEvaluationOperationMetadata)(nil),    // 26: google.cloud.dialogflow.v2.CreateConversationModelEvaluationOperationMetadata
	(*EvaluationConfig_SmartReplyConfig)(nil),                     // 27: google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig
	(*EvaluationConfig_SmartComposeConfig)(nil),                   // 28: google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig
	(*SmartReplyMetrics_TopNMetrics)(nil),                         // 29: google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics
	(*timestamppb.Timestamp)(nil),                                 // 30: google.protobuf.Timestamp
	(*longrunningpb.Operation)(nil),                               // 31: google.longrunning.Operation
}
var file_google_cloud_dialogflow_v2_conversation_model_proto_depIdxs = []int32{
	30, // 0: google.cloud.dialogflow.v2.ConversationModel.create_time:type_name -> google.protobuf.Timestamp
	7,  // 1: google.cloud.dialogflow.v2.ConversationModel.datasets:type_name -> google.cloud.dialogflow.v2.InputDataset
	0,  // 2: google.cloud.dialogflow.v2.ConversationModel.state:type_name -> google.cloud.dialogflow.v2.ConversationModel.State
	8,  // 3: google.cloud.dialogflow.v2.ConversationModel.article_suggestion_model_metadata:type_name -> google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata
	9,  // 4: google.cloud.dialogflow.v2.ConversationModel.smart_reply_model_metadata:type_name -> google.cloud.dialogflow.v2.SmartReplyModelMetadata
	6,  // 5: google.cloud.dialogflow.v2.ConversationModelEvaluation.evaluation_config:type_name -> google.cloud.dialogflow.v2.EvaluationConfig
	30, // 6: google.cloud.dialogflow.v2.ConversationModelEvaluation.create_time:type_name -> google.protobuf.Timestamp
	10, // 7: google.cloud.dialogflow.v2.ConversationModelEvaluation.smart_reply_metrics:type_name -> google.cloud.dialogflow.v2.SmartReplyMetrics
	7,  // 8: google.cloud.dialogflow.v2.EvaluationConfig.datasets:type_name -> google.cloud.dialogflow.v2.InputDataset
	27, // 9: google.cloud.dialogflow.v2.EvaluationConfig.smart_reply_config:type_name -> google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig
	28, // 10: google.cloud.dialogflow.v2.EvaluationConfig.smart_compose_config:type_name -> google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig
	1,  // 11: google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata.training_model_type:type_name -> google.cloud.dialogflow.v2.ConversationModel.ModelType
	1,  // 12: google.cloud.dialogflow.v2.SmartReplyModelMetadata.training_model_type:type_name -> google.cloud.dialogflow.v2.ConversationModel.ModelType
	29, // 13: google.cloud.dialogflow.v2.SmartReplyMetrics.top_n_metrics:type_name -> google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics
	4,  // 14: google.cloud.dialogflow.v2.CreateConversationModelRequest.conversation_model:type_name -> google.cloud.dialogflow.v2.ConversationModel
	4,  // 15: google.cloud.dialogflow.v2.ListConversationModelsResponse.conversation_models:type_name -> google.cloud.dialogflow.v2.ConversationModel
	5,  // 16: google.cloud.dialogflow.v2.ListConversationModelEvaluationsResponse.conversation_model_evaluations:type_name -> google.cloud.dialogflow.v2.ConversationModelEvaluation
	5,  // 17: google.cloud.dialogflow.v2.CreateConversationModelEvaluationRequest.conversation_model_evaluation:type_name -> google.cloud.dialogflow.v2.ConversationModelEvaluation
	2,  // 18: google.cloud.dialogflow.v2.CreateConversationModelOperationMetadata.state:type_name -> google.cloud.dialogflow.v2.CreateConversationModelOperationMetadata.State
	30, // 19: google.cloud.dialogflow.v2.CreateConversationModelOperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	30, // 20: google.cloud.dialogflow.v2.DeployConversationModelOperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	30, // 21: google.cloud.dialogflow.v2.UndeployConversationModelOperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	30, // 22: google.cloud.dialogflow.v2.DeleteConversationModelOperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	3,  // 23: google.cloud.dialogflow.v2.CreateConversationModelEvaluationOperationMetadata.state:type_name -> google.cloud.dialogflow.v2.CreateConversationModelEvaluationOperationMetadata.State
	30, // 24: google.cloud.dialogflow.v2.CreateConversationModelEvaluationOperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	11, // 25: google.cloud.dialogflow.v2.ConversationModels.CreateConversationModel:input_type -> google.cloud.dialogflow.v2.CreateConversationModelRequest
	12, // 26: google.cloud.dialogflow.v2.ConversationModels.GetConversationModel:input_type -> google.cloud.dialogflow.v2.GetConversationModelRequest
	13, // 27: google.cloud.dialogflow.v2.ConversationModels.ListConversationModels:input_type -> google.cloud.dialogflow.v2.ListConversationModelsRequest
	15, // 28: google.cloud.dialogflow.v2.ConversationModels.DeleteConversationModel:input_type -> google.cloud.dialogflow.v2.DeleteConversationModelRequest
	16, // 29: google.cloud.dialogflow.v2.ConversationModels.DeployConversationModel:input_type -> google.cloud.dialogflow.v2.DeployConversationModelRequest
	17, // 30: google.cloud.dialogflow.v2.ConversationModels.UndeployConversationModel:input_type -> google.cloud.dialogflow.v2.UndeployConversationModelRequest
	18, // 31: google.cloud.dialogflow.v2.ConversationModels.GetConversationModelEvaluation:input_type -> google.cloud.dialogflow.v2.GetConversationModelEvaluationRequest
	19, // 32: google.cloud.dialogflow.v2.ConversationModels.ListConversationModelEvaluations:input_type -> google.cloud.dialogflow.v2.ListConversationModelEvaluationsRequest
	21, // 33: google.cloud.dialogflow.v2.ConversationModels.CreateConversationModelEvaluation:input_type -> google.cloud.dialogflow.v2.CreateConversationModelEvaluationRequest
	31, // 34: google.cloud.dialogflow.v2.ConversationModels.CreateConversationModel:output_type -> google.longrunning.Operation
	4,  // 35: google.cloud.dialogflow.v2.ConversationModels.GetConversationModel:output_type -> google.cloud.dialogflow.v2.ConversationModel
	14, // 36: google.cloud.dialogflow.v2.ConversationModels.ListConversationModels:output_type -> google.cloud.dialogflow.v2.ListConversationModelsResponse
	31, // 37: google.cloud.dialogflow.v2.ConversationModels.DeleteConversationModel:output_type -> google.longrunning.Operation
	31, // 38: google.cloud.dialogflow.v2.ConversationModels.DeployConversationModel:output_type -> google.longrunning.Operation
	31, // 39: google.cloud.dialogflow.v2.ConversationModels.UndeployConversationModel:output_type -> google.longrunning.Operation
	5,  // 40: google.cloud.dialogflow.v2.ConversationModels.GetConversationModelEvaluation:output_type -> google.cloud.dialogflow.v2.ConversationModelEvaluation
	20, // 41: google.cloud.dialogflow.v2.ConversationModels.ListConversationModelEvaluations:output_type -> google.cloud.dialogflow.v2.ListConversationModelEvaluationsResponse
	31, // 42: google.cloud.dialogflow.v2.ConversationModels.CreateConversationModelEvaluation:output_type -> google.longrunning.Operation
	34, // [34:43] is the sub-list for method output_type
	25, // [25:34] is the sub-list for method input_type
	25, // [25:25] is the sub-list for extension type_name
	25, // [25:25] is the sub-list for extension extendee
	0,  // [0:25] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_v2_conversation_model_proto_init() }
func file_google_cloud_dialogflow_v2_conversation_model_proto_init() {
	if File_google_cloud_dialogflow_v2_conversation_model_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConversationModel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConversationModelEvaluation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EvaluationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InputDataset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArticleSuggestionModelMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SmartReplyModelMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SmartReplyMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateConversationModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetConversationModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConversationModelsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConversationModelsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteConversationModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployConversationModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeployConversationModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetConversationModelEvaluationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConversationModelEvaluationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConversationModelEvaluationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateConversationModelEvaluationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateConversationModelOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployConversationModelOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeployConversationModelOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteConversationModelOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateConversationModelEvaluationOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EvaluationConfig_SmartReplyConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EvaluationConfig_SmartComposeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SmartReplyMetrics_TopNMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*ConversationModel_ArticleSuggestionModelMetadata)(nil),
		(*ConversationModel_SmartReplyModelMetadata)(nil),
	}
	file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*ConversationModelEvaluation_SmartReplyMetrics)(nil),
	}
	file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*EvaluationConfig_SmartReplyConfig_)(nil),
		(*EvaluationConfig_SmartComposeConfig_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_v2_conversation_model_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   26,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_v2_conversation_model_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_v2_conversation_model_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_v2_conversation_model_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_v2_conversation_model_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_v2_conversation_model_proto = out.File
	file_google_cloud_dialogflow_v2_conversation_model_proto_rawDesc = nil
	file_google_cloud_dialogflow_v2_conversation_model_proto_goTypes = nil
	file_google_cloud_dialogflow_v2_conversation_model_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ConversationModelsClient is the client API for ConversationModels service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ConversationModelsClient interface {
	// Creates a model.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [CreateConversationModelOperationMetadata][google.cloud.dialogflow.v2.CreateConversationModelOperationMetadata]
	// - `response`:
	// [ConversationModel][google.cloud.dialogflow.v2.ConversationModel]
	CreateConversationModel(ctx context.Context, in *CreateConversationModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets conversation model.
	GetConversationModel(ctx context.Context, in *GetConversationModelRequest, opts ...grpc.CallOption) (*ConversationModel, error)
	// Lists conversation models.
	ListConversationModels(ctx context.Context, in *ListConversationModelsRequest, opts ...grpc.CallOption) (*ListConversationModelsResponse, error)
	// Deletes a model.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [DeleteConversationModelOperationMetadata][google.cloud.dialogflow.v2.DeleteConversationModelOperationMetadata]
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	DeleteConversationModel(ctx context.Context, in *DeleteConversationModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deploys a model. If a model is already deployed, deploying it
	// has no effect. A model can only serve prediction requests after it gets
	// deployed. For article suggestion, custom model will not be used unless
	// it is deployed.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [DeployConversationModelOperationMetadata][google.cloud.dialogflow.v2.DeployConversationModelOperationMetadata]
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	DeployConversationModel(ctx context.Context, in *DeployConversationModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Undeploys a model. If the model is not deployed this method has no effect.
	// If the model is currently being used:
	//   - For article suggestion, article suggestion will fallback to the default
	//     model if model is undeployed.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [UndeployConversationModelOperationMetadata][google.cloud.dialogflow.v2.UndeployConversationModelOperationMetadata]
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	UndeployConversationModel(ctx context.Context, in *UndeployConversationModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets an evaluation of conversation model.
	GetConversationModelEvaluation(ctx context.Context, in *GetConversationModelEvaluationRequest, opts ...grpc.CallOption) (*ConversationModelEvaluation, error)
	// Lists evaluations of a conversation model.
	ListConversationModelEvaluations(ctx context.Context, in *ListConversationModelEvaluationsRequest, opts ...grpc.CallOption) (*ListConversationModelEvaluationsResponse, error)
	// Creates evaluation of a conversation model.
	CreateConversationModelEvaluation(ctx context.Context, in *CreateConversationModelEvaluationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type conversationModelsClient struct {
	cc grpc.ClientConnInterface
}

func NewConversationModelsClient(cc grpc.ClientConnInterface) ConversationModelsClient {
	return &conversationModelsClient{cc}
}

func (c *conversationModelsClient) CreateConversationModel(ctx context.Context, in *CreateConversationModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.ConversationModels/CreateConversationModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationModelsClient) GetConversationModel(ctx context.Context, in *GetConversationModelRequest, opts ...grpc.CallOption) (*ConversationModel, error) {
	out := new(ConversationModel)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.ConversationModels/GetConversationModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationModelsClient) ListConversationModels(ctx context.Context, in *ListConversationModelsRequest, opts ...grpc.CallOption) (*ListConversationModelsResponse, error) {
	out := new(ListConversationModelsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.ConversationModels/ListConversationModels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationModelsClient) DeleteConversationModel(ctx context.Context, in *DeleteConversationModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.ConversationModels/DeleteConversationModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationModelsClient) DeployConversationModel(ctx context.Context, in *DeployConversationModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.ConversationModels/DeployConversationModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationModelsClient) UndeployConversationModel(ctx context.Context, in *UndeployConversationModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.ConversationModels/UndeployConversationModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationModelsClient) GetConversationModelEvaluation(ctx context.Context, in *GetConversationModelEvaluationRequest, opts ...grpc.CallOption) (*ConversationModelEvaluation, error) {
	out := new(ConversationModelEvaluation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.ConversationModels/GetConversationModelEvaluation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationModelsClient) ListConversationModelEvaluations(ctx context.Context, in *ListConversationModelEvaluationsRequest, opts ...grpc.CallOption) (*ListConversationModelEvaluationsResponse, error) {
	out := new(ListConversationModelEvaluationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.ConversationModels/ListConversationModelEvaluations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationModelsClient) CreateConversationModelEvaluation(ctx context.Context, in *CreateConversationModelEvaluationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.ConversationModels/CreateConversationModelEvaluation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConversationModelsServer is the server API for ConversationModels service.
type ConversationModelsServer interface {
	// Creates a model.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [CreateConversationModelOperationMetadata][google.cloud.dialogflow.v2.CreateConversationModelOperationMetadata]
	// - `response`:
	// [ConversationModel][google.cloud.dialogflow.v2.ConversationModel]
	CreateConversationModel(context.Context, *CreateConversationModelRequest) (*longrunningpb.Operation, error)
	// Gets conversation model.
	GetConversationModel(context.Context, *GetConversationModelRequest) (*ConversationModel, error)
	// Lists conversation models.
	ListConversationModels(context.Context, *ListConversationModelsRequest) (*ListConversationModelsResponse, error)
	// Deletes a model.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [DeleteConversationModelOperationMetadata][google.cloud.dialogflow.v2.DeleteConversationModelOperationMetadata]
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	DeleteConversationModel(context.Context, *DeleteConversationModelRequest) (*longrunningpb.Operation, error)
	// Deploys a model. If a model is already deployed, deploying it
	// has no effect. A model can only serve prediction requests after it gets
	// deployed. For article suggestion, custom model will not be used unless
	// it is deployed.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [DeployConversationModelOperationMetadata][google.cloud.dialogflow.v2.DeployConversationModelOperationMetadata]
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	DeployConversationModel(context.Context, *DeployConversationModelRequest) (*longrunningpb.Operation, error)
	// Undeploys a model. If the model is not deployed this method has no effect.
	// If the model is currently being used:
	//   - For article suggestion, article suggestion will fallback to the default
	//     model if model is undeployed.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [UndeployConversationModelOperationMetadata][google.cloud.dialogflow.v2.UndeployConversationModelOperationMetadata]
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	UndeployConversationModel(context.Context, *UndeployConversationModelRequest) (*longrunningpb.Operation, error)
	// Gets an evaluation of conversation model.
	GetConversationModelEvaluation(context.Context, *GetConversationModelEvaluationRequest) (*ConversationModelEvaluation, error)
	// Lists evaluations of a conversation model.
	ListConversationModelEvaluations(context.Context, *ListConversationModelEvaluationsRequest) (*ListConversationModelEvaluationsResponse, error)
	// Creates evaluation of a conversation model.
	CreateConversationModelEvaluation(context.Context, *CreateConversationModelEvaluationRequest) (*longrunningpb.Operation, error)
}

// UnimplementedConversationModelsServer can be embedded to have forward compatible implementations.
type UnimplementedConversationModelsServer struct {
}

func (*UnimplementedConversationModelsServer) CreateConversationModel(context.Context, *CreateConversationModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConversationModel not implemented")
}
func (*UnimplementedConversationModelsServer) GetConversationModel(context.Context, *GetConversationModelRequest) (*ConversationModel, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversationModel not implemented")
}
func (*UnimplementedConversationModelsServer) ListConversationModels(context.Context, *ListConversationModelsRequest) (*ListConversationModelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConversationModels not implemented")
}
func (*UnimplementedConversationModelsServer) DeleteConversationModel(context.Context, *DeleteConversationModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConversationModel not implemented")
}
func (*UnimplementedConversationModelsServer) DeployConversationModel(context.Context, *DeployConversationModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeployConversationModel not implemented")
}
func (*UnimplementedConversationModelsServer) UndeployConversationModel(context.Context, *UndeployConversationModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeployConversationModel not implemented")
}
func (*UnimplementedConversationModelsServer) GetConversationModelEvaluation(context.Context, *GetConversationModelEvaluationRequest) (*ConversationModelEvaluation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversationModelEvaluation not implemented")
}
func (*UnimplementedConversationModelsServer) ListConversationModelEvaluations(context.Context, *ListConversationModelEvaluationsRequest) (*ListConversationModelEvaluationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConversationModelEvaluations not implemented")
}
func (*UnimplementedConversationModelsServer) CreateConversationModelEvaluation(context.Context, *CreateConversationModelEvaluationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConversationModelEvaluation not implemented")
}

func RegisterConversationModelsServer(s *grpc.Server, srv ConversationModelsServer) {
	s.RegisterService(&_ConversationModels_serviceDesc, srv)
}

func _ConversationModels_CreateConversationModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConversationModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationModelsServer).CreateConversationModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.ConversationModels/CreateConversationModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationModelsServer).CreateConversationModel(ctx, req.(*CreateConversationModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationModels_GetConversationModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversationModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationModelsServer).GetConversationModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.ConversationModels/GetConversationModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationModelsServer).GetConversationModel(ctx, req.(*GetConversationModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationModels_ListConversationModels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConversationModelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationModelsServer).ListConversationModels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.ConversationModels/ListConversationModels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationModelsServer).ListConversationModels(ctx, req.(*ListConversationModelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationModels_DeleteConversationModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConversationModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationModelsServer).DeleteConversationModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.ConversationModels/DeleteConversationModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationModelsServer).DeleteConversationModel(ctx, req.(*DeleteConversationModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationModels_DeployConversationModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeployConversationModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationModelsServer).DeployConversationModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.ConversationModels/DeployConversationModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationModelsServer).DeployConversationModel(ctx, req.(*DeployConversationModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationModels_UndeployConversationModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeployConversationModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationModelsServer).UndeployConversationModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.ConversationModels/UndeployConversationModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationModelsServer).UndeployConversationModel(ctx, req.(*UndeployConversationModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationModels_GetConversationModelEvaluation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversationModelEvaluationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationModelsServer).GetConversationModelEvaluation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.ConversationModels/GetConversationModelEvaluation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationModelsServer).GetConversationModelEvaluation(ctx, req.(*GetConversationModelEvaluationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationModels_ListConversationModelEvaluations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConversationModelEvaluationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationModelsServer).ListConversationModelEvaluations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.ConversationModels/ListConversationModelEvaluations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationModelsServer).ListConversationModelEvaluations(ctx, req.(*ListConversationModelEvaluationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationModels_CreateConversationModelEvaluation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConversationModelEvaluationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationModelsServer).CreateConversationModelEvaluation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.ConversationModels/CreateConversationModelEvaluation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationModelsServer).CreateConversationModelEvaluation(ctx, req.(*CreateConversationModelEvaluationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ConversationModels_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2.ConversationModels",
	HandlerType: (*ConversationModelsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateConversationModel",
			Handler:    _ConversationModels_CreateConversationModel_Handler,
		},
		{
			MethodName: "GetConversationModel",
			Handler:    _ConversationModels_GetConversationModel_Handler,
		},
		{
			MethodName: "ListConversationModels",
			Handler:    _ConversationModels_ListConversationModels_Handler,
		},
		{
			MethodName: "DeleteConversationModel",
			Handler:    _ConversationModels_DeleteConversationModel_Handler,
		},
		{
			MethodName: "DeployConversationModel",
			Handler:    _ConversationModels_DeployConversationModel_Handler,
		},
		{
			MethodName: "UndeployConversationModel",
			Handler:    _ConversationModels_UndeployConversationModel_Handler,
		},
		{
			MethodName: "GetConversationModelEvaluation",
			Handler:    _ConversationModels_GetConversationModelEvaluation_Handler,
		},
		{
			MethodName: "ListConversationModelEvaluations",
			Handler:    _ConversationModels_ListConversationModelEvaluations_Handler,
		},
		{
			MethodName: "CreateConversationModelEvaluation",
			Handler:    _ConversationModels_CreateConversationModelEvaluation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2/conversation_model.proto",
}
