// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/cx/v3/environment.proto

package cxpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Environments_ListEnvironments_FullMethodName          = "/google.cloud.dialogflow.cx.v3.Environments/ListEnvironments"
	Environments_GetEnvironment_FullMethodName            = "/google.cloud.dialogflow.cx.v3.Environments/GetEnvironment"
	Environments_CreateEnvironment_FullMethodName         = "/google.cloud.dialogflow.cx.v3.Environments/CreateEnvironment"
	Environments_UpdateEnvironment_FullMethodName         = "/google.cloud.dialogflow.cx.v3.Environments/UpdateEnvironment"
	Environments_DeleteEnvironment_FullMethodName         = "/google.cloud.dialogflow.cx.v3.Environments/DeleteEnvironment"
	Environments_LookupEnvironmentHistory_FullMethodName  = "/google.cloud.dialogflow.cx.v3.Environments/LookupEnvironmentHistory"
	Environments_RunContinuousTest_FullMethodName         = "/google.cloud.dialogflow.cx.v3.Environments/RunContinuousTest"
	Environments_ListContinuousTestResults_FullMethodName = "/google.cloud.dialogflow.cx.v3.Environments/ListContinuousTestResults"
	Environments_DeployFlow_FullMethodName                = "/google.cloud.dialogflow.cx.v3.Environments/DeployFlow"
)

// EnvironmentsClient is the client API for Environments service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type EnvironmentsClient interface {
	// Returns the list of all environments in the specified
	// [Agent][google.cloud.dialogflow.cx.v3.Agent].
	ListEnvironments(ctx context.Context, in *ListEnvironmentsRequest, opts ...grpc.CallOption) (*ListEnvironmentsResponse, error)
	// Retrieves the specified
	// [Environment][google.cloud.dialogflow.cx.v3.Environment].
	GetEnvironment(ctx context.Context, in *GetEnvironmentRequest, opts ...grpc.CallOption) (*Environment, error)
	// Creates an [Environment][google.cloud.dialogflow.cx.v3.Environment] in the
	// specified [Agent][google.cloud.dialogflow.cx.v3.Agent].
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`: [Environment][google.cloud.dialogflow.cx.v3.Environment]
	CreateEnvironment(ctx context.Context, in *CreateEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the specified
	// [Environment][google.cloud.dialogflow.cx.v3.Environment].
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`: [Environment][google.cloud.dialogflow.cx.v3.Environment]
	UpdateEnvironment(ctx context.Context, in *UpdateEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes the specified
	// [Environment][google.cloud.dialogflow.cx.v3.Environment].
	DeleteEnvironment(ctx context.Context, in *DeleteEnvironmentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Looks up the history of the specified
	// [Environment][google.cloud.dialogflow.cx.v3.Environment].
	LookupEnvironmentHistory(ctx context.Context, in *LookupEnvironmentHistoryRequest, opts ...grpc.CallOption) (*LookupEnvironmentHistoryResponse, error)
	// Kicks off a continuous test under the specified
	// [Environment][google.cloud.dialogflow.cx.v3.Environment].
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [RunContinuousTestMetadata][google.cloud.dialogflow.cx.v3.RunContinuousTestMetadata]
	// - `response`:
	// [RunContinuousTestResponse][google.cloud.dialogflow.cx.v3.RunContinuousTestResponse]
	RunContinuousTest(ctx context.Context, in *RunContinuousTestRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Fetches a list of continuous test results for a given environment.
	ListContinuousTestResults(ctx context.Context, in *ListContinuousTestResultsRequest, opts ...grpc.CallOption) (*ListContinuousTestResultsResponse, error)
	// Deploys a flow to the specified
	// [Environment][google.cloud.dialogflow.cx.v3.Environment].
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [DeployFlowMetadata][google.cloud.dialogflow.cx.v3.DeployFlowMetadata]
	// - `response`:
	// [DeployFlowResponse][google.cloud.dialogflow.cx.v3.DeployFlowResponse]
	DeployFlow(ctx context.Context, in *DeployFlowRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type environmentsClient struct {
	cc grpc.ClientConnInterface
}

func NewEnvironmentsClient(cc grpc.ClientConnInterface) EnvironmentsClient {
	return &environmentsClient{cc}
}

func (c *environmentsClient) ListEnvironments(ctx context.Context, in *ListEnvironmentsRequest, opts ...grpc.CallOption) (*ListEnvironmentsResponse, error) {
	out := new(ListEnvironmentsResponse)
	err := c.cc.Invoke(ctx, Environments_ListEnvironments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) GetEnvironment(ctx context.Context, in *GetEnvironmentRequest, opts ...grpc.CallOption) (*Environment, error) {
	out := new(Environment)
	err := c.cc.Invoke(ctx, Environments_GetEnvironment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) CreateEnvironment(ctx context.Context, in *CreateEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Environments_CreateEnvironment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) UpdateEnvironment(ctx context.Context, in *UpdateEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Environments_UpdateEnvironment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) DeleteEnvironment(ctx context.Context, in *DeleteEnvironmentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Environments_DeleteEnvironment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) LookupEnvironmentHistory(ctx context.Context, in *LookupEnvironmentHistoryRequest, opts ...grpc.CallOption) (*LookupEnvironmentHistoryResponse, error) {
	out := new(LookupEnvironmentHistoryResponse)
	err := c.cc.Invoke(ctx, Environments_LookupEnvironmentHistory_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) RunContinuousTest(ctx context.Context, in *RunContinuousTestRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Environments_RunContinuousTest_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) ListContinuousTestResults(ctx context.Context, in *ListContinuousTestResultsRequest, opts ...grpc.CallOption) (*ListContinuousTestResultsResponse, error) {
	out := new(ListContinuousTestResultsResponse)
	err := c.cc.Invoke(ctx, Environments_ListContinuousTestResults_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) DeployFlow(ctx context.Context, in *DeployFlowRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Environments_DeployFlow_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EnvironmentsServer is the server API for Environments service.
// All implementations should embed UnimplementedEnvironmentsServer
// for forward compatibility
type EnvironmentsServer interface {
	// Returns the list of all environments in the specified
	// [Agent][google.cloud.dialogflow.cx.v3.Agent].
	ListEnvironments(context.Context, *ListEnvironmentsRequest) (*ListEnvironmentsResponse, error)
	// Retrieves the specified
	// [Environment][google.cloud.dialogflow.cx.v3.Environment].
	GetEnvironment(context.Context, *GetEnvironmentRequest) (*Environment, error)
	// Creates an [Environment][google.cloud.dialogflow.cx.v3.Environment] in the
	// specified [Agent][google.cloud.dialogflow.cx.v3.Agent].
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`: [Environment][google.cloud.dialogflow.cx.v3.Environment]
	CreateEnvironment(context.Context, *CreateEnvironmentRequest) (*longrunningpb.Operation, error)
	// Updates the specified
	// [Environment][google.cloud.dialogflow.cx.v3.Environment].
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`: [Environment][google.cloud.dialogflow.cx.v3.Environment]
	UpdateEnvironment(context.Context, *UpdateEnvironmentRequest) (*longrunningpb.Operation, error)
	// Deletes the specified
	// [Environment][google.cloud.dialogflow.cx.v3.Environment].
	DeleteEnvironment(context.Context, *DeleteEnvironmentRequest) (*emptypb.Empty, error)
	// Looks up the history of the specified
	// [Environment][google.cloud.dialogflow.cx.v3.Environment].
	LookupEnvironmentHistory(context.Context, *LookupEnvironmentHistoryRequest) (*LookupEnvironmentHistoryResponse, error)
	// Kicks off a continuous test under the specified
	// [Environment][google.cloud.dialogflow.cx.v3.Environment].
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [RunContinuousTestMetadata][google.cloud.dialogflow.cx.v3.RunContinuousTestMetadata]
	// - `response`:
	// [RunContinuousTestResponse][google.cloud.dialogflow.cx.v3.RunContinuousTestResponse]
	RunContinuousTest(context.Context, *RunContinuousTestRequest) (*longrunningpb.Operation, error)
	// Fetches a list of continuous test results for a given environment.
	ListContinuousTestResults(context.Context, *ListContinuousTestResultsRequest) (*ListContinuousTestResultsResponse, error)
	// Deploys a flow to the specified
	// [Environment][google.cloud.dialogflow.cx.v3.Environment].
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [DeployFlowMetadata][google.cloud.dialogflow.cx.v3.DeployFlowMetadata]
	// - `response`:
	// [DeployFlowResponse][google.cloud.dialogflow.cx.v3.DeployFlowResponse]
	DeployFlow(context.Context, *DeployFlowRequest) (*longrunningpb.Operation, error)
}

// UnimplementedEnvironmentsServer should be embedded to have forward compatible implementations.
type UnimplementedEnvironmentsServer struct {
}

func (UnimplementedEnvironmentsServer) ListEnvironments(context.Context, *ListEnvironmentsRequest) (*ListEnvironmentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEnvironments not implemented")
}
func (UnimplementedEnvironmentsServer) GetEnvironment(context.Context, *GetEnvironmentRequest) (*Environment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEnvironment not implemented")
}
func (UnimplementedEnvironmentsServer) CreateEnvironment(context.Context, *CreateEnvironmentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEnvironment not implemented")
}
func (UnimplementedEnvironmentsServer) UpdateEnvironment(context.Context, *UpdateEnvironmentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEnvironment not implemented")
}
func (UnimplementedEnvironmentsServer) DeleteEnvironment(context.Context, *DeleteEnvironmentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEnvironment not implemented")
}
func (UnimplementedEnvironmentsServer) LookupEnvironmentHistory(context.Context, *LookupEnvironmentHistoryRequest) (*LookupEnvironmentHistoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LookupEnvironmentHistory not implemented")
}
func (UnimplementedEnvironmentsServer) RunContinuousTest(context.Context, *RunContinuousTestRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunContinuousTest not implemented")
}
func (UnimplementedEnvironmentsServer) ListContinuousTestResults(context.Context, *ListContinuousTestResultsRequest) (*ListContinuousTestResultsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListContinuousTestResults not implemented")
}
func (UnimplementedEnvironmentsServer) DeployFlow(context.Context, *DeployFlowRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeployFlow not implemented")
}

// UnsafeEnvironmentsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to EnvironmentsServer will
// result in compilation errors.
type UnsafeEnvironmentsServer interface {
	mustEmbedUnimplementedEnvironmentsServer()
}

func RegisterEnvironmentsServer(s grpc.ServiceRegistrar, srv EnvironmentsServer) {
	s.RegisterService(&Environments_ServiceDesc, srv)
}

func _Environments_ListEnvironments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEnvironmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).ListEnvironments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_ListEnvironments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).ListEnvironments(ctx, req.(*ListEnvironmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_GetEnvironment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEnvironmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).GetEnvironment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_GetEnvironment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).GetEnvironment(ctx, req.(*GetEnvironmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_CreateEnvironment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEnvironmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).CreateEnvironment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_CreateEnvironment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).CreateEnvironment(ctx, req.(*CreateEnvironmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_UpdateEnvironment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEnvironmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).UpdateEnvironment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_UpdateEnvironment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).UpdateEnvironment(ctx, req.(*UpdateEnvironmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_DeleteEnvironment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEnvironmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).DeleteEnvironment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_DeleteEnvironment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).DeleteEnvironment(ctx, req.(*DeleteEnvironmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_LookupEnvironmentHistory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupEnvironmentHistoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).LookupEnvironmentHistory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_LookupEnvironmentHistory_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).LookupEnvironmentHistory(ctx, req.(*LookupEnvironmentHistoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_RunContinuousTest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunContinuousTestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).RunContinuousTest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_RunContinuousTest_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).RunContinuousTest(ctx, req.(*RunContinuousTestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_ListContinuousTestResults_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListContinuousTestResultsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).ListContinuousTestResults(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_ListContinuousTestResults_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).ListContinuousTestResults(ctx, req.(*ListContinuousTestResultsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_DeployFlow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeployFlowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).DeployFlow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_DeployFlow_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).DeployFlow(ctx, req.(*DeployFlowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Environments_ServiceDesc is the grpc.ServiceDesc for Environments service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Environments_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3.Environments",
	HandlerType: (*EnvironmentsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListEnvironments",
			Handler:    _Environments_ListEnvironments_Handler,
		},
		{
			MethodName: "GetEnvironment",
			Handler:    _Environments_GetEnvironment_Handler,
		},
		{
			MethodName: "CreateEnvironment",
			Handler:    _Environments_CreateEnvironment_Handler,
		},
		{
			MethodName: "UpdateEnvironment",
			Handler:    _Environments_UpdateEnvironment_Handler,
		},
		{
			MethodName: "DeleteEnvironment",
			Handler:    _Environments_DeleteEnvironment_Handler,
		},
		{
			MethodName: "LookupEnvironmentHistory",
			Handler:    _Environments_LookupEnvironmentHistory_Handler,
		},
		{
			MethodName: "RunContinuousTest",
			Handler:    _Environments_RunContinuousTest_Handler,
		},
		{
			MethodName: "ListContinuousTestResults",
			Handler:    _Environments_ListContinuousTestResults_Handler,
		},
		{
			MethodName: "DeployFlow",
			Handler:    _Environments_DeployFlow_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3/environment.proto",
}
