// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/dataplex/v1/logs.proto

package dataplexpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of the event.
type DiscoveryEvent_EventType int32

const (
	// An unspecified event type.
	DiscoveryEvent_EVENT_TYPE_UNSPECIFIED DiscoveryEvent_EventType = 0
	// An event representing discovery configuration in effect.
	DiscoveryEvent_CONFIG DiscoveryEvent_EventType = 1
	// An event representing a metadata entity being created.
	DiscoveryEvent_ENTITY_CREATED DiscoveryEvent_EventType = 2
	// An event representing a metadata entity being updated.
	DiscoveryEvent_ENTITY_UPDATED DiscoveryEvent_EventType = 3
	// An event representing a metadata entity being deleted.
	DiscoveryEvent_ENTITY_DELETED DiscoveryEvent_EventType = 4
	// An event representing a partition being created.
	DiscoveryEvent_PARTITION_CREATED DiscoveryEvent_EventType = 5
	// An event representing a partition being updated.
	DiscoveryEvent_PARTITION_UPDATED DiscoveryEvent_EventType = 6
	// An event representing a partition being deleted.
	DiscoveryEvent_PARTITION_DELETED DiscoveryEvent_EventType = 7
)

// Enum value maps for DiscoveryEvent_EventType.
var (
	DiscoveryEvent_EventType_name = map[int32]string{
		0: "EVENT_TYPE_UNSPECIFIED",
		1: "CONFIG",
		2: "ENTITY_CREATED",
		3: "ENTITY_UPDATED",
		4: "ENTITY_DELETED",
		5: "PARTITION_CREATED",
		6: "PARTITION_UPDATED",
		7: "PARTITION_DELETED",
	}
	DiscoveryEvent_EventType_value = map[string]int32{
		"EVENT_TYPE_UNSPECIFIED": 0,
		"CONFIG":                 1,
		"ENTITY_CREATED":         2,
		"ENTITY_UPDATED":         3,
		"ENTITY_DELETED":         4,
		"PARTITION_CREATED":      5,
		"PARTITION_UPDATED":      6,
		"PARTITION_DELETED":      7,
	}
)

func (x DiscoveryEvent_EventType) Enum() *DiscoveryEvent_EventType {
	p := new(DiscoveryEvent_EventType)
	*p = x
	return p
}

func (x DiscoveryEvent_EventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DiscoveryEvent_EventType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_logs_proto_enumTypes[0].Descriptor()
}

func (DiscoveryEvent_EventType) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_logs_proto_enumTypes[0]
}

func (x DiscoveryEvent_EventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DiscoveryEvent_EventType.Descriptor instead.
func (DiscoveryEvent_EventType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{0, 0}
}

// The type of the entity.
type DiscoveryEvent_EntityType int32

const (
	// An unspecified event type.
	DiscoveryEvent_ENTITY_TYPE_UNSPECIFIED DiscoveryEvent_EntityType = 0
	// Entities representing structured data.
	DiscoveryEvent_TABLE DiscoveryEvent_EntityType = 1
	// Entities representing unstructured data.
	DiscoveryEvent_FILESET DiscoveryEvent_EntityType = 2
)

// Enum value maps for DiscoveryEvent_EntityType.
var (
	DiscoveryEvent_EntityType_name = map[int32]string{
		0: "ENTITY_TYPE_UNSPECIFIED",
		1: "TABLE",
		2: "FILESET",
	}
	DiscoveryEvent_EntityType_value = map[string]int32{
		"ENTITY_TYPE_UNSPECIFIED": 0,
		"TABLE":                   1,
		"FILESET":                 2,
	}
)

func (x DiscoveryEvent_EntityType) Enum() *DiscoveryEvent_EntityType {
	p := new(DiscoveryEvent_EntityType)
	*p = x
	return p
}

func (x DiscoveryEvent_EntityType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DiscoveryEvent_EntityType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_logs_proto_enumTypes[1].Descriptor()
}

func (DiscoveryEvent_EntityType) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_logs_proto_enumTypes[1]
}

func (x DiscoveryEvent_EntityType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DiscoveryEvent_EntityType.Descriptor instead.
func (DiscoveryEvent_EntityType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{0, 1}
}

// The type of the job.
type JobEvent_Type int32

const (
	// Unspecified job type.
	JobEvent_TYPE_UNSPECIFIED JobEvent_Type = 0
	// Spark jobs.
	JobEvent_SPARK JobEvent_Type = 1
	// Notebook jobs.
	JobEvent_NOTEBOOK JobEvent_Type = 2
)

// Enum value maps for JobEvent_Type.
var (
	JobEvent_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "SPARK",
		2: "NOTEBOOK",
	}
	JobEvent_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"SPARK":            1,
		"NOTEBOOK":         2,
	}
)

func (x JobEvent_Type) Enum() *JobEvent_Type {
	p := new(JobEvent_Type)
	*p = x
	return p
}

func (x JobEvent_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JobEvent_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_logs_proto_enumTypes[2].Descriptor()
}

func (JobEvent_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_logs_proto_enumTypes[2]
}

func (x JobEvent_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JobEvent_Type.Descriptor instead.
func (JobEvent_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{1, 0}
}

// The completion status of the job.
type JobEvent_State int32

const (
	// Unspecified job state.
	JobEvent_STATE_UNSPECIFIED JobEvent_State = 0
	// Job successfully completed.
	JobEvent_SUCCEEDED JobEvent_State = 1
	// Job was unsuccessful.
	JobEvent_FAILED JobEvent_State = 2
	// Job was cancelled by the user.
	JobEvent_CANCELLED JobEvent_State = 3
	// Job was cancelled or aborted via the service executing the job.
	JobEvent_ABORTED JobEvent_State = 4
)

// Enum value maps for JobEvent_State.
var (
	JobEvent_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "SUCCEEDED",
		2: "FAILED",
		3: "CANCELLED",
		4: "ABORTED",
	}
	JobEvent_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"SUCCEEDED":         1,
		"FAILED":            2,
		"CANCELLED":         3,
		"ABORTED":           4,
	}
)

func (x JobEvent_State) Enum() *JobEvent_State {
	p := new(JobEvent_State)
	*p = x
	return p
}

func (x JobEvent_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JobEvent_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_logs_proto_enumTypes[3].Descriptor()
}

func (JobEvent_State) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_logs_proto_enumTypes[3]
}

func (x JobEvent_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JobEvent_State.Descriptor instead.
func (JobEvent_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{1, 1}
}

// The service used to execute the job.
type JobEvent_Service int32

const (
	// Unspecified service.
	JobEvent_SERVICE_UNSPECIFIED JobEvent_Service = 0
	// Cloud Dataproc.
	JobEvent_DATAPROC JobEvent_Service = 1
)

// Enum value maps for JobEvent_Service.
var (
	JobEvent_Service_name = map[int32]string{
		0: "SERVICE_UNSPECIFIED",
		1: "DATAPROC",
	}
	JobEvent_Service_value = map[string]int32{
		"SERVICE_UNSPECIFIED": 0,
		"DATAPROC":            1,
	}
)

func (x JobEvent_Service) Enum() *JobEvent_Service {
	p := new(JobEvent_Service)
	*p = x
	return p
}

func (x JobEvent_Service) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JobEvent_Service) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_logs_proto_enumTypes[4].Descriptor()
}

func (JobEvent_Service) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_logs_proto_enumTypes[4]
}

func (x JobEvent_Service) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JobEvent_Service.Descriptor instead.
func (JobEvent_Service) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{1, 2}
}

// Job Execution trigger.
type JobEvent_ExecutionTrigger int32

const (
	// The job execution trigger is unspecified.
	JobEvent_EXECUTION_TRIGGER_UNSPECIFIED JobEvent_ExecutionTrigger = 0
	// The job was triggered by Dataplex based on trigger spec from task
	// definition.
	JobEvent_TASK_CONFIG JobEvent_ExecutionTrigger = 1
	// The job was triggered by the explicit call of Task API.
	JobEvent_RUN_REQUEST JobEvent_ExecutionTrigger = 2
)

// Enum value maps for JobEvent_ExecutionTrigger.
var (
	JobEvent_ExecutionTrigger_name = map[int32]string{
		0: "EXECUTION_TRIGGER_UNSPECIFIED",
		1: "TASK_CONFIG",
		2: "RUN_REQUEST",
	}
	JobEvent_ExecutionTrigger_value = map[string]int32{
		"EXECUTION_TRIGGER_UNSPECIFIED": 0,
		"TASK_CONFIG":                   1,
		"RUN_REQUEST":                   2,
	}
)

func (x JobEvent_ExecutionTrigger) Enum() *JobEvent_ExecutionTrigger {
	p := new(JobEvent_ExecutionTrigger)
	*p = x
	return p
}

func (x JobEvent_ExecutionTrigger) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JobEvent_ExecutionTrigger) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_logs_proto_enumTypes[5].Descriptor()
}

func (JobEvent_ExecutionTrigger) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_logs_proto_enumTypes[5]
}

func (x JobEvent_ExecutionTrigger) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JobEvent_ExecutionTrigger.Descriptor instead.
func (JobEvent_ExecutionTrigger) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{1, 3}
}

// The type of the event.
type SessionEvent_EventType int32

const (
	// An unspecified event type.
	SessionEvent_EVENT_TYPE_UNSPECIFIED SessionEvent_EventType = 0
	// Event when the session is assigned to a user.
	SessionEvent_START SessionEvent_EventType = 1
	// Event for stop of a session.
	SessionEvent_STOP SessionEvent_EventType = 2
	// Query events in the session.
	SessionEvent_QUERY SessionEvent_EventType = 3
	// Event for creation of a cluster. It is not yet assigned to a user.
	// This comes before START in the sequence
	SessionEvent_CREATE SessionEvent_EventType = 4
)

// Enum value maps for SessionEvent_EventType.
var (
	SessionEvent_EventType_name = map[int32]string{
		0: "EVENT_TYPE_UNSPECIFIED",
		1: "START",
		2: "STOP",
		3: "QUERY",
		4: "CREATE",
	}
	SessionEvent_EventType_value = map[string]int32{
		"EVENT_TYPE_UNSPECIFIED": 0,
		"START":                  1,
		"STOP":                   2,
		"QUERY":                  3,
		"CREATE":                 4,
	}
)

func (x SessionEvent_EventType) Enum() *SessionEvent_EventType {
	p := new(SessionEvent_EventType)
	*p = x
	return p
}

func (x SessionEvent_EventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SessionEvent_EventType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_logs_proto_enumTypes[6].Descriptor()
}

func (SessionEvent_EventType) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_logs_proto_enumTypes[6]
}

func (x SessionEvent_EventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SessionEvent_EventType.Descriptor instead.
func (SessionEvent_EventType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{2, 0}
}

// Query Execution engine.
type SessionEvent_QueryDetail_Engine int32

const (
	// An unspecified Engine type.
	SessionEvent_QueryDetail_ENGINE_UNSPECIFIED SessionEvent_QueryDetail_Engine = 0
	// Spark-sql engine is specified in Query.
	SessionEvent_QueryDetail_SPARK_SQL SessionEvent_QueryDetail_Engine = 1
	// BigQuery engine is specified in Query.
	SessionEvent_QueryDetail_BIGQUERY SessionEvent_QueryDetail_Engine = 2
)

// Enum value maps for SessionEvent_QueryDetail_Engine.
var (
	SessionEvent_QueryDetail_Engine_name = map[int32]string{
		0: "ENGINE_UNSPECIFIED",
		1: "SPARK_SQL",
		2: "BIGQUERY",
	}
	SessionEvent_QueryDetail_Engine_value = map[string]int32{
		"ENGINE_UNSPECIFIED": 0,
		"SPARK_SQL":          1,
		"BIGQUERY":           2,
	}
)

func (x SessionEvent_QueryDetail_Engine) Enum() *SessionEvent_QueryDetail_Engine {
	p := new(SessionEvent_QueryDetail_Engine)
	*p = x
	return p
}

func (x SessionEvent_QueryDetail_Engine) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SessionEvent_QueryDetail_Engine) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_logs_proto_enumTypes[7].Descriptor()
}

func (SessionEvent_QueryDetail_Engine) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_logs_proto_enumTypes[7]
}

func (x SessionEvent_QueryDetail_Engine) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SessionEvent_QueryDetail_Engine.Descriptor instead.
func (SessionEvent_QueryDetail_Engine) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{2, 0, 0}
}

// Type of governance log event.
type GovernanceEvent_EventType int32

const (
	// An unspecified event type.
	GovernanceEvent_EVENT_TYPE_UNSPECIFIED GovernanceEvent_EventType = 0
	// Resource IAM policy update event.
	GovernanceEvent_RESOURCE_IAM_POLICY_UPDATE GovernanceEvent_EventType = 1
	// BigQuery table create event.
	GovernanceEvent_BIGQUERY_TABLE_CREATE GovernanceEvent_EventType = 2
	// BigQuery table update event.
	GovernanceEvent_BIGQUERY_TABLE_UPDATE GovernanceEvent_EventType = 3
	// BigQuery table delete event.
	GovernanceEvent_BIGQUERY_TABLE_DELETE GovernanceEvent_EventType = 4
	// BigQuery connection create event.
	GovernanceEvent_BIGQUERY_CONNECTION_CREATE GovernanceEvent_EventType = 5
	// BigQuery connection update event.
	GovernanceEvent_BIGQUERY_CONNECTION_UPDATE GovernanceEvent_EventType = 6
	// BigQuery connection delete event.
	GovernanceEvent_BIGQUERY_CONNECTION_DELETE GovernanceEvent_EventType = 7
	// BigQuery taxonomy created.
	GovernanceEvent_BIGQUERY_TAXONOMY_CREATE GovernanceEvent_EventType = 10
	// BigQuery policy tag created.
	GovernanceEvent_BIGQUERY_POLICY_TAG_CREATE GovernanceEvent_EventType = 11
	// BigQuery policy tag deleted.
	GovernanceEvent_BIGQUERY_POLICY_TAG_DELETE GovernanceEvent_EventType = 12
	// BigQuery set iam policy for policy tag.
	GovernanceEvent_BIGQUERY_POLICY_TAG_SET_IAM_POLICY GovernanceEvent_EventType = 13
	// Access policy update event.
	GovernanceEvent_ACCESS_POLICY_UPDATE GovernanceEvent_EventType = 14
	// Number of resources matched with particular Query.
	GovernanceEvent_GOVERNANCE_RULE_MATCHED_RESOURCES GovernanceEvent_EventType = 15
	// Rule processing exceeds the allowed limit.
	GovernanceEvent_GOVERNANCE_RULE_SEARCH_LIMIT_EXCEEDS GovernanceEvent_EventType = 16
	// Rule processing errors.
	GovernanceEvent_GOVERNANCE_RULE_ERRORS GovernanceEvent_EventType = 17
	// Governance rule processing Event.
	GovernanceEvent_GOVERNANCE_RULE_PROCESSING GovernanceEvent_EventType = 18
)

// Enum value maps for GovernanceEvent_EventType.
var (
	GovernanceEvent_EventType_name = map[int32]string{
		0:  "EVENT_TYPE_UNSPECIFIED",
		1:  "RESOURCE_IAM_POLICY_UPDATE",
		2:  "BIGQUERY_TABLE_CREATE",
		3:  "BIGQUERY_TABLE_UPDATE",
		4:  "BIGQUERY_TABLE_DELETE",
		5:  "BIGQUERY_CONNECTION_CREATE",
		6:  "BIGQUERY_CONNECTION_UPDATE",
		7:  "BIGQUERY_CONNECTION_DELETE",
		10: "BIGQUERY_TAXONOMY_CREATE",
		11: "BIGQUERY_POLICY_TAG_CREATE",
		12: "BIGQUERY_POLICY_TAG_DELETE",
		13: "BIGQUERY_POLICY_TAG_SET_IAM_POLICY",
		14: "ACCESS_POLICY_UPDATE",
		15: "GOVERNANCE_RULE_MATCHED_RESOURCES",
		16: "GOVERNANCE_RULE_SEARCH_LIMIT_EXCEEDS",
		17: "GOVERNANCE_RULE_ERRORS",
		18: "GOVERNANCE_RULE_PROCESSING",
	}
	GovernanceEvent_EventType_value = map[string]int32{
		"EVENT_TYPE_UNSPECIFIED":               0,
		"RESOURCE_IAM_POLICY_UPDATE":           1,
		"BIGQUERY_TABLE_CREATE":                2,
		"BIGQUERY_TABLE_UPDATE":                3,
		"BIGQUERY_TABLE_DELETE":                4,
		"BIGQUERY_CONNECTION_CREATE":           5,
		"BIGQUERY_CONNECTION_UPDATE":           6,
		"BIGQUERY_CONNECTION_DELETE":           7,
		"BIGQUERY_TAXONOMY_CREATE":             10,
		"BIGQUERY_POLICY_TAG_CREATE":           11,
		"BIGQUERY_POLICY_TAG_DELETE":           12,
		"BIGQUERY_POLICY_TAG_SET_IAM_POLICY":   13,
		"ACCESS_POLICY_UPDATE":                 14,
		"GOVERNANCE_RULE_MATCHED_RESOURCES":    15,
		"GOVERNANCE_RULE_SEARCH_LIMIT_EXCEEDS": 16,
		"GOVERNANCE_RULE_ERRORS":               17,
		"GOVERNANCE_RULE_PROCESSING":           18,
	}
)

func (x GovernanceEvent_EventType) Enum() *GovernanceEvent_EventType {
	p := new(GovernanceEvent_EventType)
	*p = x
	return p
}

func (x GovernanceEvent_EventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GovernanceEvent_EventType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_logs_proto_enumTypes[8].Descriptor()
}

func (GovernanceEvent_EventType) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_logs_proto_enumTypes[8]
}

func (x GovernanceEvent_EventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GovernanceEvent_EventType.Descriptor instead.
func (GovernanceEvent_EventType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{3, 0}
}

// Type of entity.
type GovernanceEvent_Entity_EntityType int32

const (
	// An unspecified Entity type.
	GovernanceEvent_Entity_ENTITY_TYPE_UNSPECIFIED GovernanceEvent_Entity_EntityType = 0
	// Table entity type.
	GovernanceEvent_Entity_TABLE GovernanceEvent_Entity_EntityType = 1
	// Fileset entity type.
	GovernanceEvent_Entity_FILESET GovernanceEvent_Entity_EntityType = 2
)

// Enum value maps for GovernanceEvent_Entity_EntityType.
var (
	GovernanceEvent_Entity_EntityType_name = map[int32]string{
		0: "ENTITY_TYPE_UNSPECIFIED",
		1: "TABLE",
		2: "FILESET",
	}
	GovernanceEvent_Entity_EntityType_value = map[string]int32{
		"ENTITY_TYPE_UNSPECIFIED": 0,
		"TABLE":                   1,
		"FILESET":                 2,
	}
)

func (x GovernanceEvent_Entity_EntityType) Enum() *GovernanceEvent_Entity_EntityType {
	p := new(GovernanceEvent_Entity_EntityType)
	*p = x
	return p
}

func (x GovernanceEvent_Entity_EntityType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GovernanceEvent_Entity_EntityType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_logs_proto_enumTypes[9].Descriptor()
}

func (GovernanceEvent_Entity_EntityType) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_logs_proto_enumTypes[9]
}

func (x GovernanceEvent_Entity_EntityType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GovernanceEvent_Entity_EntityType.Descriptor instead.
func (GovernanceEvent_Entity_EntityType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{3, 0, 0}
}

// The type of the data scan.
type DataScanEvent_ScanType int32

const (
	// An unspecified data scan type.
	DataScanEvent_SCAN_TYPE_UNSPECIFIED DataScanEvent_ScanType = 0
	// Data scan for data profile.
	DataScanEvent_DATA_PROFILE DataScanEvent_ScanType = 1
	// Data scan for data quality.
	DataScanEvent_DATA_QUALITY DataScanEvent_ScanType = 2
)

// Enum value maps for DataScanEvent_ScanType.
var (
	DataScanEvent_ScanType_name = map[int32]string{
		0: "SCAN_TYPE_UNSPECIFIED",
		1: "DATA_PROFILE",
		2: "DATA_QUALITY",
	}
	DataScanEvent_ScanType_value = map[string]int32{
		"SCAN_TYPE_UNSPECIFIED": 0,
		"DATA_PROFILE":          1,
		"DATA_QUALITY":          2,
	}
)

func (x DataScanEvent_ScanType) Enum() *DataScanEvent_ScanType {
	p := new(DataScanEvent_ScanType)
	*p = x
	return p
}

func (x DataScanEvent_ScanType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataScanEvent_ScanType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_logs_proto_enumTypes[10].Descriptor()
}

func (DataScanEvent_ScanType) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_logs_proto_enumTypes[10]
}

func (x DataScanEvent_ScanType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataScanEvent_ScanType.Descriptor instead.
func (DataScanEvent_ScanType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{4, 0}
}

// The job state of the data scan.
type DataScanEvent_State int32

const (
	// Unspecified job state.
	DataScanEvent_STATE_UNSPECIFIED DataScanEvent_State = 0
	// Data scan job started.
	DataScanEvent_STARTED DataScanEvent_State = 1
	// Data scan job successfully completed.
	DataScanEvent_SUCCEEDED DataScanEvent_State = 2
	// Data scan job was unsuccessful.
	DataScanEvent_FAILED DataScanEvent_State = 3
	// Data scan job was cancelled.
	DataScanEvent_CANCELLED DataScanEvent_State = 4
	// Data scan job was createed.
	DataScanEvent_CREATED DataScanEvent_State = 5
)

// Enum value maps for DataScanEvent_State.
var (
	DataScanEvent_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "STARTED",
		2: "SUCCEEDED",
		3: "FAILED",
		4: "CANCELLED",
		5: "CREATED",
	}
	DataScanEvent_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"STARTED":           1,
		"SUCCEEDED":         2,
		"FAILED":            3,
		"CANCELLED":         4,
		"CREATED":           5,
	}
)

func (x DataScanEvent_State) Enum() *DataScanEvent_State {
	p := new(DataScanEvent_State)
	*p = x
	return p
}

func (x DataScanEvent_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataScanEvent_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_logs_proto_enumTypes[11].Descriptor()
}

func (DataScanEvent_State) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_logs_proto_enumTypes[11]
}

func (x DataScanEvent_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataScanEvent_State.Descriptor instead.
func (DataScanEvent_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{4, 1}
}

// The trigger type for the data scan.
type DataScanEvent_Trigger int32

const (
	// An unspecified trigger type.
	DataScanEvent_TRIGGER_UNSPECIFIED DataScanEvent_Trigger = 0
	// Data scan triggers on demand.
	DataScanEvent_ON_DEMAND DataScanEvent_Trigger = 1
	// Data scan triggers as per schedule.
	DataScanEvent_SCHEDULE DataScanEvent_Trigger = 2
)

// Enum value maps for DataScanEvent_Trigger.
var (
	DataScanEvent_Trigger_name = map[int32]string{
		0: "TRIGGER_UNSPECIFIED",
		1: "ON_DEMAND",
		2: "SCHEDULE",
	}
	DataScanEvent_Trigger_value = map[string]int32{
		"TRIGGER_UNSPECIFIED": 0,
		"ON_DEMAND":           1,
		"SCHEDULE":            2,
	}
)

func (x DataScanEvent_Trigger) Enum() *DataScanEvent_Trigger {
	p := new(DataScanEvent_Trigger)
	*p = x
	return p
}

func (x DataScanEvent_Trigger) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataScanEvent_Trigger) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_logs_proto_enumTypes[12].Descriptor()
}

func (DataScanEvent_Trigger) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_logs_proto_enumTypes[12]
}

func (x DataScanEvent_Trigger) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataScanEvent_Trigger.Descriptor instead.
func (DataScanEvent_Trigger) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{4, 2}
}

// The scope of job for the data scan.
type DataScanEvent_Scope int32

const (
	// An unspecified scope type.
	DataScanEvent_SCOPE_UNSPECIFIED DataScanEvent_Scope = 0
	// Data scan runs on all of the data.
	DataScanEvent_FULL DataScanEvent_Scope = 1
	// Data scan runs on incremental data.
	DataScanEvent_INCREMENTAL DataScanEvent_Scope = 2
)

// Enum value maps for DataScanEvent_Scope.
var (
	DataScanEvent_Scope_name = map[int32]string{
		0: "SCOPE_UNSPECIFIED",
		1: "FULL",
		2: "INCREMENTAL",
	}
	DataScanEvent_Scope_value = map[string]int32{
		"SCOPE_UNSPECIFIED": 0,
		"FULL":              1,
		"INCREMENTAL":       2,
	}
)

func (x DataScanEvent_Scope) Enum() *DataScanEvent_Scope {
	p := new(DataScanEvent_Scope)
	*p = x
	return p
}

func (x DataScanEvent_Scope) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataScanEvent_Scope) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_logs_proto_enumTypes[13].Descriptor()
}

func (DataScanEvent_Scope) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_logs_proto_enumTypes[13]
}

func (x DataScanEvent_Scope) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataScanEvent_Scope.Descriptor instead.
func (DataScanEvent_Scope) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{4, 3}
}

// Execution state for the exporting.
type DataScanEvent_PostScanActionsResult_BigQueryExportResult_State int32

const (
	// The exporting state is unspecified.
	DataScanEvent_PostScanActionsResult_BigQueryExportResult_STATE_UNSPECIFIED DataScanEvent_PostScanActionsResult_BigQueryExportResult_State = 0
	// The exporting completed successfully.
	DataScanEvent_PostScanActionsResult_BigQueryExportResult_SUCCEEDED DataScanEvent_PostScanActionsResult_BigQueryExportResult_State = 1
	// The exporting is no longer running due to an error.
	DataScanEvent_PostScanActionsResult_BigQueryExportResult_FAILED DataScanEvent_PostScanActionsResult_BigQueryExportResult_State = 2
	// The exporting is skipped due to no valid scan result to export
	// (usually caused by scan failed).
	DataScanEvent_PostScanActionsResult_BigQueryExportResult_SKIPPED DataScanEvent_PostScanActionsResult_BigQueryExportResult_State = 3
)

// Enum value maps for DataScanEvent_PostScanActionsResult_BigQueryExportResult_State.
var (
	DataScanEvent_PostScanActionsResult_BigQueryExportResult_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "SUCCEEDED",
		2: "FAILED",
		3: "SKIPPED",
	}
	DataScanEvent_PostScanActionsResult_BigQueryExportResult_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"SUCCEEDED":         1,
		"FAILED":            2,
		"SKIPPED":           3,
	}
)

func (x DataScanEvent_PostScanActionsResult_BigQueryExportResult_State) Enum() *DataScanEvent_PostScanActionsResult_BigQueryExportResult_State {
	p := new(DataScanEvent_PostScanActionsResult_BigQueryExportResult_State)
	*p = x
	return p
}

func (x DataScanEvent_PostScanActionsResult_BigQueryExportResult_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataScanEvent_PostScanActionsResult_BigQueryExportResult_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_logs_proto_enumTypes[14].Descriptor()
}

func (DataScanEvent_PostScanActionsResult_BigQueryExportResult_State) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_logs_proto_enumTypes[14]
}

func (x DataScanEvent_PostScanActionsResult_BigQueryExportResult_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataScanEvent_PostScanActionsResult_BigQueryExportResult_State.Descriptor instead.
func (DataScanEvent_PostScanActionsResult_BigQueryExportResult_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{4, 4, 0, 0}
}

// The type of the data quality rule.
type DataQualityScanRuleResult_RuleType int32

const (
	// An unspecified rule type.
	DataQualityScanRuleResult_RULE_TYPE_UNSPECIFIED DataQualityScanRuleResult_RuleType = 0
	// See
	// [DataQualityRule.NonNullExpectation][google.cloud.dataplex.v1.DataQualityRule.NonNullExpectation].
	DataQualityScanRuleResult_NON_NULL_EXPECTATION DataQualityScanRuleResult_RuleType = 1
	// See
	// [DataQualityRule.RangeExpectation][google.cloud.dataplex.v1.DataQualityRule.RangeExpectation].
	DataQualityScanRuleResult_RANGE_EXPECTATION DataQualityScanRuleResult_RuleType = 2
	// See
	// [DataQualityRule.RegexExpectation][google.cloud.dataplex.v1.DataQualityRule.RegexExpectation].
	DataQualityScanRuleResult_REGEX_EXPECTATION DataQualityScanRuleResult_RuleType = 3
	// See
	// [DataQualityRule.RowConditionExpectation][google.cloud.dataplex.v1.DataQualityRule.RowConditionExpectation].
	DataQualityScanRuleResult_ROW_CONDITION_EXPECTATION DataQualityScanRuleResult_RuleType = 4
	// See
	// [DataQualityRule.SetExpectation][google.cloud.dataplex.v1.DataQualityRule.SetExpectation].
	DataQualityScanRuleResult_SET_EXPECTATION DataQualityScanRuleResult_RuleType = 5
	// See
	// [DataQualityRule.StatisticRangeExpectation][google.cloud.dataplex.v1.DataQualityRule.StatisticRangeExpectation].
	DataQualityScanRuleResult_STATISTIC_RANGE_EXPECTATION DataQualityScanRuleResult_RuleType = 6
	// See
	// [DataQualityRule.TableConditionExpectation][google.cloud.dataplex.v1.DataQualityRule.TableConditionExpectation].
	DataQualityScanRuleResult_TABLE_CONDITION_EXPECTATION DataQualityScanRuleResult_RuleType = 7
	// See
	// [DataQualityRule.UniquenessExpectation][google.cloud.dataplex.v1.DataQualityRule.UniquenessExpectation].
	DataQualityScanRuleResult_UNIQUENESS_EXPECTATION DataQualityScanRuleResult_RuleType = 8
	// See
	// [DataQualityRule.SqlAssertion][google.cloud.dataplex.v1.DataQualityRule.SqlAssertion].
	DataQualityScanRuleResult_SQL_ASSERTION DataQualityScanRuleResult_RuleType = 9
)

// Enum value maps for DataQualityScanRuleResult_RuleType.
var (
	DataQualityScanRuleResult_RuleType_name = map[int32]string{
		0: "RULE_TYPE_UNSPECIFIED",
		1: "NON_NULL_EXPECTATION",
		2: "RANGE_EXPECTATION",
		3: "REGEX_EXPECTATION",
		4: "ROW_CONDITION_EXPECTATION",
		5: "SET_EXPECTATION",
		6: "STATISTIC_RANGE_EXPECTATION",
		7: "TABLE_CONDITION_EXPECTATION",
		8: "UNIQUENESS_EXPECTATION",
		9: "SQL_ASSERTION",
	}
	DataQualityScanRuleResult_RuleType_value = map[string]int32{
		"RULE_TYPE_UNSPECIFIED":       0,
		"NON_NULL_EXPECTATION":        1,
		"RANGE_EXPECTATION":           2,
		"REGEX_EXPECTATION":           3,
		"ROW_CONDITION_EXPECTATION":   4,
		"SET_EXPECTATION":             5,
		"STATISTIC_RANGE_EXPECTATION": 6,
		"TABLE_CONDITION_EXPECTATION": 7,
		"UNIQUENESS_EXPECTATION":      8,
		"SQL_ASSERTION":               9,
	}
)

func (x DataQualityScanRuleResult_RuleType) Enum() *DataQualityScanRuleResult_RuleType {
	p := new(DataQualityScanRuleResult_RuleType)
	*p = x
	return p
}

func (x DataQualityScanRuleResult_RuleType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataQualityScanRuleResult_RuleType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_logs_proto_enumTypes[15].Descriptor()
}

func (DataQualityScanRuleResult_RuleType) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_logs_proto_enumTypes[15]
}

func (x DataQualityScanRuleResult_RuleType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataQualityScanRuleResult_RuleType.Descriptor instead.
func (DataQualityScanRuleResult_RuleType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{5, 0}
}

// The evaluation type of the data quality rule.
type DataQualityScanRuleResult_EvaluationType int32

const (
	// An unspecified evaluation type.
	DataQualityScanRuleResult_EVALUATION_TYPE_UNSPECIFIED DataQualityScanRuleResult_EvaluationType = 0
	// The rule evaluation is done at per row level.
	DataQualityScanRuleResult_PER_ROW DataQualityScanRuleResult_EvaluationType = 1
	// The rule evaluation is done for an aggregate of rows.
	DataQualityScanRuleResult_AGGREGATE DataQualityScanRuleResult_EvaluationType = 2
)

// Enum value maps for DataQualityScanRuleResult_EvaluationType.
var (
	DataQualityScanRuleResult_EvaluationType_name = map[int32]string{
		0: "EVALUATION_TYPE_UNSPECIFIED",
		1: "PER_ROW",
		2: "AGGREGATE",
	}
	DataQualityScanRuleResult_EvaluationType_value = map[string]int32{
		"EVALUATION_TYPE_UNSPECIFIED": 0,
		"PER_ROW":                     1,
		"AGGREGATE":                   2,
	}
)

func (x DataQualityScanRuleResult_EvaluationType) Enum() *DataQualityScanRuleResult_EvaluationType {
	p := new(DataQualityScanRuleResult_EvaluationType)
	*p = x
	return p
}

func (x DataQualityScanRuleResult_EvaluationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataQualityScanRuleResult_EvaluationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_logs_proto_enumTypes[16].Descriptor()
}

func (DataQualityScanRuleResult_EvaluationType) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_logs_proto_enumTypes[16]
}

func (x DataQualityScanRuleResult_EvaluationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataQualityScanRuleResult_EvaluationType.Descriptor instead.
func (DataQualityScanRuleResult_EvaluationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{5, 1}
}

// Whether the data quality rule passed or failed.
type DataQualityScanRuleResult_Result int32

const (
	// An unspecified result.
	DataQualityScanRuleResult_RESULT_UNSPECIFIED DataQualityScanRuleResult_Result = 0
	// The data quality rule passed.
	DataQualityScanRuleResult_PASSED DataQualityScanRuleResult_Result = 1
	// The data quality rule failed.
	DataQualityScanRuleResult_FAILED DataQualityScanRuleResult_Result = 2
)

// Enum value maps for DataQualityScanRuleResult_Result.
var (
	DataQualityScanRuleResult_Result_name = map[int32]string{
		0: "RESULT_UNSPECIFIED",
		1: "PASSED",
		2: "FAILED",
	}
	DataQualityScanRuleResult_Result_value = map[string]int32{
		"RESULT_UNSPECIFIED": 0,
		"PASSED":             1,
		"FAILED":             2,
	}
)

func (x DataQualityScanRuleResult_Result) Enum() *DataQualityScanRuleResult_Result {
	p := new(DataQualityScanRuleResult_Result)
	*p = x
	return p
}

func (x DataQualityScanRuleResult_Result) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataQualityScanRuleResult_Result) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_logs_proto_enumTypes[17].Descriptor()
}

func (DataQualityScanRuleResult_Result) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_logs_proto_enumTypes[17]
}

func (x DataQualityScanRuleResult_Result) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataQualityScanRuleResult_Result.Descriptor instead.
func (DataQualityScanRuleResult_Result) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{5, 2}
}

// The payload associated with Discovery data processing.
type DiscoveryEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The log message.
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	// The id of the associated lake.
	LakeId string `protobuf:"bytes,2,opt,name=lake_id,json=lakeId,proto3" json:"lake_id,omitempty"`
	// The id of the associated zone.
	ZoneId string `protobuf:"bytes,3,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// The id of the associated asset.
	AssetId string `protobuf:"bytes,4,opt,name=asset_id,json=assetId,proto3" json:"asset_id,omitempty"`
	// The data location associated with the event.
	DataLocation string `protobuf:"bytes,5,opt,name=data_location,json=dataLocation,proto3" json:"data_location,omitempty"`
	// The type of the event being logged.
	Type DiscoveryEvent_EventType `protobuf:"varint,10,opt,name=type,proto3,enum=google.cloud.dataplex.v1.DiscoveryEvent_EventType" json:"type,omitempty"`
	// Additional details about the event.
	//
	// Types that are assignable to Details:
	//
	//	*DiscoveryEvent_Config
	//	*DiscoveryEvent_Entity
	//	*DiscoveryEvent_Partition
	//	*DiscoveryEvent_Action
	Details isDiscoveryEvent_Details `protobuf_oneof:"details"`
}

func (x *DiscoveryEvent) Reset() {
	*x = DiscoveryEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiscoveryEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoveryEvent) ProtoMessage() {}

func (x *DiscoveryEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoveryEvent.ProtoReflect.Descriptor instead.
func (*DiscoveryEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{0}
}

func (x *DiscoveryEvent) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *DiscoveryEvent) GetLakeId() string {
	if x != nil {
		return x.LakeId
	}
	return ""
}

func (x *DiscoveryEvent) GetZoneId() string {
	if x != nil {
		return x.ZoneId
	}
	return ""
}

func (x *DiscoveryEvent) GetAssetId() string {
	if x != nil {
		return x.AssetId
	}
	return ""
}

func (x *DiscoveryEvent) GetDataLocation() string {
	if x != nil {
		return x.DataLocation
	}
	return ""
}

func (x *DiscoveryEvent) GetType() DiscoveryEvent_EventType {
	if x != nil {
		return x.Type
	}
	return DiscoveryEvent_EVENT_TYPE_UNSPECIFIED
}

func (m *DiscoveryEvent) GetDetails() isDiscoveryEvent_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (x *DiscoveryEvent) GetConfig() *DiscoveryEvent_ConfigDetails {
	if x, ok := x.GetDetails().(*DiscoveryEvent_Config); ok {
		return x.Config
	}
	return nil
}

func (x *DiscoveryEvent) GetEntity() *DiscoveryEvent_EntityDetails {
	if x, ok := x.GetDetails().(*DiscoveryEvent_Entity); ok {
		return x.Entity
	}
	return nil
}

func (x *DiscoveryEvent) GetPartition() *DiscoveryEvent_PartitionDetails {
	if x, ok := x.GetDetails().(*DiscoveryEvent_Partition); ok {
		return x.Partition
	}
	return nil
}

func (x *DiscoveryEvent) GetAction() *DiscoveryEvent_ActionDetails {
	if x, ok := x.GetDetails().(*DiscoveryEvent_Action); ok {
		return x.Action
	}
	return nil
}

type isDiscoveryEvent_Details interface {
	isDiscoveryEvent_Details()
}

type DiscoveryEvent_Config struct {
	// Details about discovery configuration in effect.
	Config *DiscoveryEvent_ConfigDetails `protobuf:"bytes,20,opt,name=config,proto3,oneof"`
}

type DiscoveryEvent_Entity struct {
	// Details about the entity associated with the event.
	Entity *DiscoveryEvent_EntityDetails `protobuf:"bytes,21,opt,name=entity,proto3,oneof"`
}

type DiscoveryEvent_Partition struct {
	// Details about the partition associated with the event.
	Partition *DiscoveryEvent_PartitionDetails `protobuf:"bytes,22,opt,name=partition,proto3,oneof"`
}

type DiscoveryEvent_Action struct {
	// Details about the action associated with the event.
	Action *DiscoveryEvent_ActionDetails `protobuf:"bytes,23,opt,name=action,proto3,oneof"`
}

func (*DiscoveryEvent_Config) isDiscoveryEvent_Details() {}

func (*DiscoveryEvent_Entity) isDiscoveryEvent_Details() {}

func (*DiscoveryEvent_Partition) isDiscoveryEvent_Details() {}

func (*DiscoveryEvent_Action) isDiscoveryEvent_Details() {}

// The payload associated with Job logs that contains events describing jobs
// that have run within a Lake.
type JobEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The log message.
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	// The unique id identifying the job.
	JobId string `protobuf:"bytes,2,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// The time when the job started running.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time when the job ended running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The job state on completion.
	State JobEvent_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.dataplex.v1.JobEvent_State" json:"state,omitempty"`
	// The number of retries.
	Retries int32 `protobuf:"varint,6,opt,name=retries,proto3" json:"retries,omitempty"`
	// The type of the job.
	Type JobEvent_Type `protobuf:"varint,7,opt,name=type,proto3,enum=google.cloud.dataplex.v1.JobEvent_Type" json:"type,omitempty"`
	// The service used to execute the job.
	Service JobEvent_Service `protobuf:"varint,8,opt,name=service,proto3,enum=google.cloud.dataplex.v1.JobEvent_Service" json:"service,omitempty"`
	// The reference to the job within the service.
	ServiceJob string `protobuf:"bytes,9,opt,name=service_job,json=serviceJob,proto3" json:"service_job,omitempty"`
	// Job execution trigger.
	ExecutionTrigger JobEvent_ExecutionTrigger `protobuf:"varint,11,opt,name=execution_trigger,json=executionTrigger,proto3,enum=google.cloud.dataplex.v1.JobEvent_ExecutionTrigger" json:"execution_trigger,omitempty"`
}

func (x *JobEvent) Reset() {
	*x = JobEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobEvent) ProtoMessage() {}

func (x *JobEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobEvent.ProtoReflect.Descriptor instead.
func (*JobEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{1}
}

func (x *JobEvent) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *JobEvent) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

func (x *JobEvent) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *JobEvent) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *JobEvent) GetState() JobEvent_State {
	if x != nil {
		return x.State
	}
	return JobEvent_STATE_UNSPECIFIED
}

func (x *JobEvent) GetRetries() int32 {
	if x != nil {
		return x.Retries
	}
	return 0
}

func (x *JobEvent) GetType() JobEvent_Type {
	if x != nil {
		return x.Type
	}
	return JobEvent_TYPE_UNSPECIFIED
}

func (x *JobEvent) GetService() JobEvent_Service {
	if x != nil {
		return x.Service
	}
	return JobEvent_SERVICE_UNSPECIFIED
}

func (x *JobEvent) GetServiceJob() string {
	if x != nil {
		return x.ServiceJob
	}
	return ""
}

func (x *JobEvent) GetExecutionTrigger() JobEvent_ExecutionTrigger {
	if x != nil {
		return x.ExecutionTrigger
	}
	return JobEvent_EXECUTION_TRIGGER_UNSPECIFIED
}

// These messages contain information about sessions within an environment.
// The monitored resource is 'Environment'.
type SessionEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The log message.
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	// The information about the user that created the session. It will be the
	// email address of the user.
	UserId string `protobuf:"bytes,2,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// Unique identifier for the session.
	SessionId string `protobuf:"bytes,3,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
	// The type of the event.
	Type SessionEvent_EventType `protobuf:"varint,4,opt,name=type,proto3,enum=google.cloud.dataplex.v1.SessionEvent_EventType" json:"type,omitempty"`
	// Additional information about the Query metadata.
	//
	// Types that are assignable to Detail:
	//
	//	*SessionEvent_Query
	Detail isSessionEvent_Detail `protobuf_oneof:"detail"`
	// The status of the event.
	EventSucceeded bool `protobuf:"varint,6,opt,name=event_succeeded,json=eventSucceeded,proto3" json:"event_succeeded,omitempty"`
	// If the session is associated with an environment with fast startup enabled,
	// and was created before being assigned to a user.
	FastStartupEnabled bool `protobuf:"varint,7,opt,name=fast_startup_enabled,json=fastStartupEnabled,proto3" json:"fast_startup_enabled,omitempty"`
	// The idle duration of a warm pooled session before it is assigned to user.
	UnassignedDuration *durationpb.Duration `protobuf:"bytes,8,opt,name=unassigned_duration,json=unassignedDuration,proto3" json:"unassigned_duration,omitempty"`
}

func (x *SessionEvent) Reset() {
	*x = SessionEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SessionEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionEvent) ProtoMessage() {}

func (x *SessionEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionEvent.ProtoReflect.Descriptor instead.
func (*SessionEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{2}
}

func (x *SessionEvent) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *SessionEvent) GetUserId() string {
	if x != nil {
		return x.UserId
	}
	return ""
}

func (x *SessionEvent) GetSessionId() string {
	if x != nil {
		return x.SessionId
	}
	return ""
}

func (x *SessionEvent) GetType() SessionEvent_EventType {
	if x != nil {
		return x.Type
	}
	return SessionEvent_EVENT_TYPE_UNSPECIFIED
}

func (m *SessionEvent) GetDetail() isSessionEvent_Detail {
	if m != nil {
		return m.Detail
	}
	return nil
}

func (x *SessionEvent) GetQuery() *SessionEvent_QueryDetail {
	if x, ok := x.GetDetail().(*SessionEvent_Query); ok {
		return x.Query
	}
	return nil
}

func (x *SessionEvent) GetEventSucceeded() bool {
	if x != nil {
		return x.EventSucceeded
	}
	return false
}

func (x *SessionEvent) GetFastStartupEnabled() bool {
	if x != nil {
		return x.FastStartupEnabled
	}
	return false
}

func (x *SessionEvent) GetUnassignedDuration() *durationpb.Duration {
	if x != nil {
		return x.UnassignedDuration
	}
	return nil
}

type isSessionEvent_Detail interface {
	isSessionEvent_Detail()
}

type SessionEvent_Query struct {
	// The execution details of the query.
	Query *SessionEvent_QueryDetail `protobuf:"bytes,5,opt,name=query,proto3,oneof"`
}

func (*SessionEvent_Query) isSessionEvent_Detail() {}

// Payload associated with Governance related log events.
type GovernanceEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The log message.
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	// The type of the event.
	EventType GovernanceEvent_EventType `protobuf:"varint,2,opt,name=event_type,json=eventType,proto3,enum=google.cloud.dataplex.v1.GovernanceEvent_EventType" json:"event_type,omitempty"`
	// Entity resource information if the log event is associated with a
	// specific entity.
	Entity *GovernanceEvent_Entity `protobuf:"bytes,3,opt,name=entity,proto3,oneof" json:"entity,omitempty"`
}

func (x *GovernanceEvent) Reset() {
	*x = GovernanceEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GovernanceEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GovernanceEvent) ProtoMessage() {}

func (x *GovernanceEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GovernanceEvent.ProtoReflect.Descriptor instead.
func (*GovernanceEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{3}
}

func (x *GovernanceEvent) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *GovernanceEvent) GetEventType() GovernanceEvent_EventType {
	if x != nil {
		return x.EventType
	}
	return GovernanceEvent_EVENT_TYPE_UNSPECIFIED
}

func (x *GovernanceEvent) GetEntity() *GovernanceEvent_Entity {
	if x != nil {
		return x.Entity
	}
	return nil
}

// These messages contain information about the execution of a datascan.
// The monitored resource is 'DataScan'
// Next ID: 13
type DataScanEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The data source of the data scan
	DataSource string `protobuf:"bytes,1,opt,name=data_source,json=dataSource,proto3" json:"data_source,omitempty"`
	// The identifier of the specific data scan job this log entry is for.
	JobId string `protobuf:"bytes,2,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// The time when the data scan job was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The time when the data scan job started to run.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time when the data scan job finished.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The type of the data scan.
	Type DataScanEvent_ScanType `protobuf:"varint,5,opt,name=type,proto3,enum=google.cloud.dataplex.v1.DataScanEvent_ScanType" json:"type,omitempty"`
	// The status of the data scan job.
	State DataScanEvent_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.dataplex.v1.DataScanEvent_State" json:"state,omitempty"`
	// The message describing the data scan job event.
	Message string `protobuf:"bytes,7,opt,name=message,proto3" json:"message,omitempty"`
	// A version identifier of the spec which was used to execute this job.
	SpecVersion string `protobuf:"bytes,8,opt,name=spec_version,json=specVersion,proto3" json:"spec_version,omitempty"`
	// The trigger type of the data scan job.
	Trigger DataScanEvent_Trigger `protobuf:"varint,9,opt,name=trigger,proto3,enum=google.cloud.dataplex.v1.DataScanEvent_Trigger" json:"trigger,omitempty"`
	// The scope of the data scan (e.g. full, incremental).
	Scope DataScanEvent_Scope `protobuf:"varint,10,opt,name=scope,proto3,enum=google.cloud.dataplex.v1.DataScanEvent_Scope" json:"scope,omitempty"`
	// The result of the data scan job.
	//
	// Types that are assignable to Result:
	//
	//	*DataScanEvent_DataProfile
	//	*DataScanEvent_DataQuality
	Result isDataScanEvent_Result `protobuf_oneof:"result"`
	// The applied configs in the data scan job.
	//
	// Types that are assignable to AppliedConfigs:
	//
	//	*DataScanEvent_DataProfileConfigs
	//	*DataScanEvent_DataQualityConfigs
	AppliedConfigs isDataScanEvent_AppliedConfigs `protobuf_oneof:"appliedConfigs"`
	// The result of post scan actions.
	PostScanActionsResult *DataScanEvent_PostScanActionsResult `protobuf:"bytes,11,opt,name=post_scan_actions_result,json=postScanActionsResult,proto3" json:"post_scan_actions_result,omitempty"`
}

func (x *DataScanEvent) Reset() {
	*x = DataScanEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataScanEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataScanEvent) ProtoMessage() {}

func (x *DataScanEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataScanEvent.ProtoReflect.Descriptor instead.
func (*DataScanEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{4}
}

func (x *DataScanEvent) GetDataSource() string {
	if x != nil {
		return x.DataSource
	}
	return ""
}

func (x *DataScanEvent) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

func (x *DataScanEvent) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DataScanEvent) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *DataScanEvent) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *DataScanEvent) GetType() DataScanEvent_ScanType {
	if x != nil {
		return x.Type
	}
	return DataScanEvent_SCAN_TYPE_UNSPECIFIED
}

func (x *DataScanEvent) GetState() DataScanEvent_State {
	if x != nil {
		return x.State
	}
	return DataScanEvent_STATE_UNSPECIFIED
}

func (x *DataScanEvent) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *DataScanEvent) GetSpecVersion() string {
	if x != nil {
		return x.SpecVersion
	}
	return ""
}

func (x *DataScanEvent) GetTrigger() DataScanEvent_Trigger {
	if x != nil {
		return x.Trigger
	}
	return DataScanEvent_TRIGGER_UNSPECIFIED
}

func (x *DataScanEvent) GetScope() DataScanEvent_Scope {
	if x != nil {
		return x.Scope
	}
	return DataScanEvent_SCOPE_UNSPECIFIED
}

func (m *DataScanEvent) GetResult() isDataScanEvent_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *DataScanEvent) GetDataProfile() *DataScanEvent_DataProfileResult {
	if x, ok := x.GetResult().(*DataScanEvent_DataProfile); ok {
		return x.DataProfile
	}
	return nil
}

func (x *DataScanEvent) GetDataQuality() *DataScanEvent_DataQualityResult {
	if x, ok := x.GetResult().(*DataScanEvent_DataQuality); ok {
		return x.DataQuality
	}
	return nil
}

func (m *DataScanEvent) GetAppliedConfigs() isDataScanEvent_AppliedConfigs {
	if m != nil {
		return m.AppliedConfigs
	}
	return nil
}

func (x *DataScanEvent) GetDataProfileConfigs() *DataScanEvent_DataProfileAppliedConfigs {
	if x, ok := x.GetAppliedConfigs().(*DataScanEvent_DataProfileConfigs); ok {
		return x.DataProfileConfigs
	}
	return nil
}

func (x *DataScanEvent) GetDataQualityConfigs() *DataScanEvent_DataQualityAppliedConfigs {
	if x, ok := x.GetAppliedConfigs().(*DataScanEvent_DataQualityConfigs); ok {
		return x.DataQualityConfigs
	}
	return nil
}

func (x *DataScanEvent) GetPostScanActionsResult() *DataScanEvent_PostScanActionsResult {
	if x != nil {
		return x.PostScanActionsResult
	}
	return nil
}

type isDataScanEvent_Result interface {
	isDataScanEvent_Result()
}

type DataScanEvent_DataProfile struct {
	// Data profile result for data profile type data scan.
	DataProfile *DataScanEvent_DataProfileResult `protobuf:"bytes,101,opt,name=data_profile,json=dataProfile,proto3,oneof"`
}

type DataScanEvent_DataQuality struct {
	// Data quality result for data quality type data scan.
	DataQuality *DataScanEvent_DataQualityResult `protobuf:"bytes,102,opt,name=data_quality,json=dataQuality,proto3,oneof"`
}

func (*DataScanEvent_DataProfile) isDataScanEvent_Result() {}

func (*DataScanEvent_DataQuality) isDataScanEvent_Result() {}

type isDataScanEvent_AppliedConfigs interface {
	isDataScanEvent_AppliedConfigs()
}

type DataScanEvent_DataProfileConfigs struct {
	// Applied configs for data profile type data scan.
	DataProfileConfigs *DataScanEvent_DataProfileAppliedConfigs `protobuf:"bytes,201,opt,name=data_profile_configs,json=dataProfileConfigs,proto3,oneof"`
}

type DataScanEvent_DataQualityConfigs struct {
	// Applied configs for data quality type data scan.
	DataQualityConfigs *DataScanEvent_DataQualityAppliedConfigs `protobuf:"bytes,202,opt,name=data_quality_configs,json=dataQualityConfigs,proto3,oneof"`
}

func (*DataScanEvent_DataProfileConfigs) isDataScanEvent_AppliedConfigs() {}

func (*DataScanEvent_DataQualityConfigs) isDataScanEvent_AppliedConfigs() {}

// Information about the result of a data quality rule for data quality scan.
// The monitored resource is 'DataScan'.
type DataQualityScanRuleResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier of the specific data scan job this log entry is for.
	JobId string `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// The data source of the data scan (e.g. BigQuery table name).
	DataSource string `protobuf:"bytes,2,opt,name=data_source,json=dataSource,proto3" json:"data_source,omitempty"`
	// The column which this rule is evaluated against.
	Column string `protobuf:"bytes,3,opt,name=column,proto3" json:"column,omitempty"`
	// The name of the data quality rule.
	RuleName string `protobuf:"bytes,4,opt,name=rule_name,json=ruleName,proto3" json:"rule_name,omitempty"`
	// The type of the data quality rule.
	RuleType DataQualityScanRuleResult_RuleType `protobuf:"varint,5,opt,name=rule_type,json=ruleType,proto3,enum=google.cloud.dataplex.v1.DataQualityScanRuleResult_RuleType" json:"rule_type,omitempty"`
	// The evaluation type of the data quality rule.
	EvalutionType DataQualityScanRuleResult_EvaluationType `protobuf:"varint,6,opt,name=evalution_type,json=evalutionType,proto3,enum=google.cloud.dataplex.v1.DataQualityScanRuleResult_EvaluationType" json:"evalution_type,omitempty"`
	// The dimension of the data quality rule.
	RuleDimension string `protobuf:"bytes,7,opt,name=rule_dimension,json=ruleDimension,proto3" json:"rule_dimension,omitempty"`
	// The passing threshold ([0.0, 100.0]) of the data quality rule.
	ThresholdPercent float64 `protobuf:"fixed64,8,opt,name=threshold_percent,json=thresholdPercent,proto3" json:"threshold_percent,omitempty"`
	// The result of the data quality rule.
	Result DataQualityScanRuleResult_Result `protobuf:"varint,9,opt,name=result,proto3,enum=google.cloud.dataplex.v1.DataQualityScanRuleResult_Result" json:"result,omitempty"`
	// The number of rows evaluated against the data quality rule.
	// This field is only valid for rules of PER_ROW evaluation type.
	EvaluatedRowCount int64 `protobuf:"varint,10,opt,name=evaluated_row_count,json=evaluatedRowCount,proto3" json:"evaluated_row_count,omitempty"`
	// The number of rows which passed a rule evaluation.
	// This field is only valid for rules of PER_ROW evaluation type.
	PassedRowCount int64 `protobuf:"varint,11,opt,name=passed_row_count,json=passedRowCount,proto3" json:"passed_row_count,omitempty"`
	// The number of rows with null values in the specified column.
	NullRowCount int64 `protobuf:"varint,12,opt,name=null_row_count,json=nullRowCount,proto3" json:"null_row_count,omitempty"`
	// The number of rows returned by the SQL statement in a SQL assertion rule.
	// This field is only valid for SQL assertion rules.
	AssertionRowCount int64 `protobuf:"varint,13,opt,name=assertion_row_count,json=assertionRowCount,proto3" json:"assertion_row_count,omitempty"`
}

func (x *DataQualityScanRuleResult) Reset() {
	*x = DataQualityScanRuleResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataQualityScanRuleResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityScanRuleResult) ProtoMessage() {}

func (x *DataQualityScanRuleResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityScanRuleResult.ProtoReflect.Descriptor instead.
func (*DataQualityScanRuleResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{5}
}

func (x *DataQualityScanRuleResult) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

func (x *DataQualityScanRuleResult) GetDataSource() string {
	if x != nil {
		return x.DataSource
	}
	return ""
}

func (x *DataQualityScanRuleResult) GetColumn() string {
	if x != nil {
		return x.Column
	}
	return ""
}

func (x *DataQualityScanRuleResult) GetRuleName() string {
	if x != nil {
		return x.RuleName
	}
	return ""
}

func (x *DataQualityScanRuleResult) GetRuleType() DataQualityScanRuleResult_RuleType {
	if x != nil {
		return x.RuleType
	}
	return DataQualityScanRuleResult_RULE_TYPE_UNSPECIFIED
}

func (x *DataQualityScanRuleResult) GetEvalutionType() DataQualityScanRuleResult_EvaluationType {
	if x != nil {
		return x.EvalutionType
	}
	return DataQualityScanRuleResult_EVALUATION_TYPE_UNSPECIFIED
}

func (x *DataQualityScanRuleResult) GetRuleDimension() string {
	if x != nil {
		return x.RuleDimension
	}
	return ""
}

func (x *DataQualityScanRuleResult) GetThresholdPercent() float64 {
	if x != nil {
		return x.ThresholdPercent
	}
	return 0
}

func (x *DataQualityScanRuleResult) GetResult() DataQualityScanRuleResult_Result {
	if x != nil {
		return x.Result
	}
	return DataQualityScanRuleResult_RESULT_UNSPECIFIED
}

func (x *DataQualityScanRuleResult) GetEvaluatedRowCount() int64 {
	if x != nil {
		return x.EvaluatedRowCount
	}
	return 0
}

func (x *DataQualityScanRuleResult) GetPassedRowCount() int64 {
	if x != nil {
		return x.PassedRowCount
	}
	return 0
}

func (x *DataQualityScanRuleResult) GetNullRowCount() int64 {
	if x != nil {
		return x.NullRowCount
	}
	return 0
}

func (x *DataQualityScanRuleResult) GetAssertionRowCount() int64 {
	if x != nil {
		return x.AssertionRowCount
	}
	return 0
}

// Details about configuration events.
type DiscoveryEvent_ConfigDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of discovery configuration parameters in effect.
	// The keys are the field paths within DiscoverySpec.
	// Eg. includePatterns, excludePatterns, csvOptions.disableTypeInference,
	// etc.
	Parameters map[string]string `protobuf:"bytes,1,rep,name=parameters,proto3" json:"parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *DiscoveryEvent_ConfigDetails) Reset() {
	*x = DiscoveryEvent_ConfigDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiscoveryEvent_ConfigDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoveryEvent_ConfigDetails) ProtoMessage() {}

func (x *DiscoveryEvent_ConfigDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoveryEvent_ConfigDetails.ProtoReflect.Descriptor instead.
func (*DiscoveryEvent_ConfigDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{0, 0}
}

func (x *DiscoveryEvent_ConfigDetails) GetParameters() map[string]string {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// Details about the entity.
type DiscoveryEvent_EntityDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the entity resource.
	// The name is the fully-qualified resource name.
	Entity string `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// The type of the entity resource.
	Type DiscoveryEvent_EntityType `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.dataplex.v1.DiscoveryEvent_EntityType" json:"type,omitempty"`
}

func (x *DiscoveryEvent_EntityDetails) Reset() {
	*x = DiscoveryEvent_EntityDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiscoveryEvent_EntityDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoveryEvent_EntityDetails) ProtoMessage() {}

func (x *DiscoveryEvent_EntityDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoveryEvent_EntityDetails.ProtoReflect.Descriptor instead.
func (*DiscoveryEvent_EntityDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{0, 1}
}

func (x *DiscoveryEvent_EntityDetails) GetEntity() string {
	if x != nil {
		return x.Entity
	}
	return ""
}

func (x *DiscoveryEvent_EntityDetails) GetType() DiscoveryEvent_EntityType {
	if x != nil {
		return x.Type
	}
	return DiscoveryEvent_ENTITY_TYPE_UNSPECIFIED
}

// Details about the partition.
type DiscoveryEvent_PartitionDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name to the partition resource.
	// The name is the fully-qualified resource name.
	Partition string `protobuf:"bytes,1,opt,name=partition,proto3" json:"partition,omitempty"`
	// The name to the containing entity resource.
	// The name is the fully-qualified resource name.
	Entity string `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// The type of the containing entity resource.
	Type DiscoveryEvent_EntityType `protobuf:"varint,3,opt,name=type,proto3,enum=google.cloud.dataplex.v1.DiscoveryEvent_EntityType" json:"type,omitempty"`
	// The locations of the data items (e.g., a Cloud Storage objects) sampled
	// for metadata inference.
	SampledDataLocations []string `protobuf:"bytes,4,rep,name=sampled_data_locations,json=sampledDataLocations,proto3" json:"sampled_data_locations,omitempty"`
}

func (x *DiscoveryEvent_PartitionDetails) Reset() {
	*x = DiscoveryEvent_PartitionDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiscoveryEvent_PartitionDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoveryEvent_PartitionDetails) ProtoMessage() {}

func (x *DiscoveryEvent_PartitionDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoveryEvent_PartitionDetails.ProtoReflect.Descriptor instead.
func (*DiscoveryEvent_PartitionDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{0, 2}
}

func (x *DiscoveryEvent_PartitionDetails) GetPartition() string {
	if x != nil {
		return x.Partition
	}
	return ""
}

func (x *DiscoveryEvent_PartitionDetails) GetEntity() string {
	if x != nil {
		return x.Entity
	}
	return ""
}

func (x *DiscoveryEvent_PartitionDetails) GetType() DiscoveryEvent_EntityType {
	if x != nil {
		return x.Type
	}
	return DiscoveryEvent_ENTITY_TYPE_UNSPECIFIED
}

func (x *DiscoveryEvent_PartitionDetails) GetSampledDataLocations() []string {
	if x != nil {
		return x.SampledDataLocations
	}
	return nil
}

// Details about the action.
type DiscoveryEvent_ActionDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of action.
	// Eg. IncompatibleDataSchema, InvalidDataFormat
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *DiscoveryEvent_ActionDetails) Reset() {
	*x = DiscoveryEvent_ActionDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiscoveryEvent_ActionDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoveryEvent_ActionDetails) ProtoMessage() {}

func (x *DiscoveryEvent_ActionDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoveryEvent_ActionDetails.ProtoReflect.Descriptor instead.
func (*DiscoveryEvent_ActionDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{0, 3}
}

func (x *DiscoveryEvent_ActionDetails) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

// Execution details of the query.
type SessionEvent_QueryDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique Query id identifying the query.
	QueryId string `protobuf:"bytes,1,opt,name=query_id,json=queryId,proto3" json:"query_id,omitempty"`
	// The query text executed.
	QueryText string `protobuf:"bytes,2,opt,name=query_text,json=queryText,proto3" json:"query_text,omitempty"`
	// Query Execution engine.
	Engine SessionEvent_QueryDetail_Engine `protobuf:"varint,3,opt,name=engine,proto3,enum=google.cloud.dataplex.v1.SessionEvent_QueryDetail_Engine" json:"engine,omitempty"`
	// Time taken for execution of the query.
	Duration *durationpb.Duration `protobuf:"bytes,4,opt,name=duration,proto3" json:"duration,omitempty"`
	// The size of results the query produced.
	ResultSizeBytes int64 `protobuf:"varint,5,opt,name=result_size_bytes,json=resultSizeBytes,proto3" json:"result_size_bytes,omitempty"`
	// The data processed by the query.
	DataProcessedBytes int64 `protobuf:"varint,6,opt,name=data_processed_bytes,json=dataProcessedBytes,proto3" json:"data_processed_bytes,omitempty"`
}

func (x *SessionEvent_QueryDetail) Reset() {
	*x = SessionEvent_QueryDetail{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SessionEvent_QueryDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionEvent_QueryDetail) ProtoMessage() {}

func (x *SessionEvent_QueryDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionEvent_QueryDetail.ProtoReflect.Descriptor instead.
func (*SessionEvent_QueryDetail) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{2, 0}
}

func (x *SessionEvent_QueryDetail) GetQueryId() string {
	if x != nil {
		return x.QueryId
	}
	return ""
}

func (x *SessionEvent_QueryDetail) GetQueryText() string {
	if x != nil {
		return x.QueryText
	}
	return ""
}

func (x *SessionEvent_QueryDetail) GetEngine() SessionEvent_QueryDetail_Engine {
	if x != nil {
		return x.Engine
	}
	return SessionEvent_QueryDetail_ENGINE_UNSPECIFIED
}

func (x *SessionEvent_QueryDetail) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *SessionEvent_QueryDetail) GetResultSizeBytes() int64 {
	if x != nil {
		return x.ResultSizeBytes
	}
	return 0
}

func (x *SessionEvent_QueryDetail) GetDataProcessedBytes() int64 {
	if x != nil {
		return x.DataProcessedBytes
	}
	return 0
}

// Information about Entity resource that the log event is associated with.
type GovernanceEvent_Entity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Entity resource the log event is associated with.
	// Format:
	// `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}`
	Entity string `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// Type of entity.
	EntityType GovernanceEvent_Entity_EntityType `protobuf:"varint,2,opt,name=entity_type,json=entityType,proto3,enum=google.cloud.dataplex.v1.GovernanceEvent_Entity_EntityType" json:"entity_type,omitempty"`
}

func (x *GovernanceEvent_Entity) Reset() {
	*x = GovernanceEvent_Entity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GovernanceEvent_Entity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GovernanceEvent_Entity) ProtoMessage() {}

func (x *GovernanceEvent_Entity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GovernanceEvent_Entity.ProtoReflect.Descriptor instead.
func (*GovernanceEvent_Entity) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{3, 0}
}

func (x *GovernanceEvent_Entity) GetEntity() string {
	if x != nil {
		return x.Entity
	}
	return ""
}

func (x *GovernanceEvent_Entity) GetEntityType() GovernanceEvent_Entity_EntityType {
	if x != nil {
		return x.EntityType
	}
	return GovernanceEvent_Entity_ENTITY_TYPE_UNSPECIFIED
}

// Data profile result for data scan job.
type DataScanEvent_DataProfileResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The count of rows processed in the data scan job.
	RowCount int64 `protobuf:"varint,1,opt,name=row_count,json=rowCount,proto3" json:"row_count,omitempty"`
}

func (x *DataScanEvent_DataProfileResult) Reset() {
	*x = DataScanEvent_DataProfileResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataScanEvent_DataProfileResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataScanEvent_DataProfileResult) ProtoMessage() {}

func (x *DataScanEvent_DataProfileResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataScanEvent_DataProfileResult.ProtoReflect.Descriptor instead.
func (*DataScanEvent_DataProfileResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{4, 0}
}

func (x *DataScanEvent_DataProfileResult) GetRowCount() int64 {
	if x != nil {
		return x.RowCount
	}
	return 0
}

// Data quality result for data scan job.
type DataScanEvent_DataQualityResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The count of rows processed in the data scan job.
	RowCount int64 `protobuf:"varint,1,opt,name=row_count,json=rowCount,proto3" json:"row_count,omitempty"`
	// Whether the data quality result was `pass` or not.
	Passed bool `protobuf:"varint,2,opt,name=passed,proto3" json:"passed,omitempty"`
	// The result of each dimension for data quality result.
	// The key of the map is the name of the dimension.
	// The value is the bool value depicting whether the dimension result was
	// `pass` or not.
	DimensionPassed map[string]bool `protobuf:"bytes,3,rep,name=dimension_passed,json=dimensionPassed,proto3" json:"dimension_passed,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// The table-level data quality score for the data scan job.
	//
	// The data quality score ranges between [0, 100] (up to two decimal
	// points).
	Score float32 `protobuf:"fixed32,4,opt,name=score,proto3" json:"score,omitempty"`
	// The score of each dimension for data quality result.
	// The key of the map is the name of the dimension.
	// The value is the data quality score for the dimension.
	//
	// The score ranges between [0, 100] (up to two decimal
	// points).
	DimensionScore map[string]float32 `protobuf:"bytes,5,rep,name=dimension_score,json=dimensionScore,proto3" json:"dimension_score,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"fixed32,2,opt,name=value,proto3"`
	// The score of each column scanned in the data scan job.
	// The key of the map is the name of the column.
	// The value is the data quality score for the column.
	//
	// The score ranges between [0, 100] (up to two decimal
	// points).
	ColumnScore map[string]float32 `protobuf:"bytes,6,rep,name=column_score,json=columnScore,proto3" json:"column_score,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"fixed32,2,opt,name=value,proto3"`
}

func (x *DataScanEvent_DataQualityResult) Reset() {
	*x = DataScanEvent_DataQualityResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataScanEvent_DataQualityResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataScanEvent_DataQualityResult) ProtoMessage() {}

func (x *DataScanEvent_DataQualityResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataScanEvent_DataQualityResult.ProtoReflect.Descriptor instead.
func (*DataScanEvent_DataQualityResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{4, 1}
}

func (x *DataScanEvent_DataQualityResult) GetRowCount() int64 {
	if x != nil {
		return x.RowCount
	}
	return 0
}

func (x *DataScanEvent_DataQualityResult) GetPassed() bool {
	if x != nil {
		return x.Passed
	}
	return false
}

func (x *DataScanEvent_DataQualityResult) GetDimensionPassed() map[string]bool {
	if x != nil {
		return x.DimensionPassed
	}
	return nil
}

func (x *DataScanEvent_DataQualityResult) GetScore() float32 {
	if x != nil {
		return x.Score
	}
	return 0
}

func (x *DataScanEvent_DataQualityResult) GetDimensionScore() map[string]float32 {
	if x != nil {
		return x.DimensionScore
	}
	return nil
}

func (x *DataScanEvent_DataQualityResult) GetColumnScore() map[string]float32 {
	if x != nil {
		return x.ColumnScore
	}
	return nil
}

// Applied configs for data profile type data scan job.
type DataScanEvent_DataProfileAppliedConfigs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The percentage of the records selected from the dataset for DataScan.
	//
	// * Value ranges between 0.0 and 100.0.
	// * Value 0.0 or 100.0 imply that sampling was not applied.
	SamplingPercent float32 `protobuf:"fixed32,1,opt,name=sampling_percent,json=samplingPercent,proto3" json:"sampling_percent,omitempty"`
	// Boolean indicating whether a row filter was applied in the DataScan job.
	RowFilterApplied bool `protobuf:"varint,2,opt,name=row_filter_applied,json=rowFilterApplied,proto3" json:"row_filter_applied,omitempty"`
	// Boolean indicating whether a column filter was applied in the DataScan
	// job.
	ColumnFilterApplied bool `protobuf:"varint,3,opt,name=column_filter_applied,json=columnFilterApplied,proto3" json:"column_filter_applied,omitempty"`
}

func (x *DataScanEvent_DataProfileAppliedConfigs) Reset() {
	*x = DataScanEvent_DataProfileAppliedConfigs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataScanEvent_DataProfileAppliedConfigs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataScanEvent_DataProfileAppliedConfigs) ProtoMessage() {}

func (x *DataScanEvent_DataProfileAppliedConfigs) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataScanEvent_DataProfileAppliedConfigs.ProtoReflect.Descriptor instead.
func (*DataScanEvent_DataProfileAppliedConfigs) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{4, 2}
}

func (x *DataScanEvent_DataProfileAppliedConfigs) GetSamplingPercent() float32 {
	if x != nil {
		return x.SamplingPercent
	}
	return 0
}

func (x *DataScanEvent_DataProfileAppliedConfigs) GetRowFilterApplied() bool {
	if x != nil {
		return x.RowFilterApplied
	}
	return false
}

func (x *DataScanEvent_DataProfileAppliedConfigs) GetColumnFilterApplied() bool {
	if x != nil {
		return x.ColumnFilterApplied
	}
	return false
}

// Applied configs for data quality type data scan job.
type DataScanEvent_DataQualityAppliedConfigs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The percentage of the records selected from the dataset for DataScan.
	//
	// * Value ranges between 0.0 and 100.0.
	// * Value 0.0 or 100.0 imply that sampling was not applied.
	SamplingPercent float32 `protobuf:"fixed32,1,opt,name=sampling_percent,json=samplingPercent,proto3" json:"sampling_percent,omitempty"`
	// Boolean indicating whether a row filter was applied in the DataScan job.
	RowFilterApplied bool `protobuf:"varint,2,opt,name=row_filter_applied,json=rowFilterApplied,proto3" json:"row_filter_applied,omitempty"`
}

func (x *DataScanEvent_DataQualityAppliedConfigs) Reset() {
	*x = DataScanEvent_DataQualityAppliedConfigs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataScanEvent_DataQualityAppliedConfigs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataScanEvent_DataQualityAppliedConfigs) ProtoMessage() {}

func (x *DataScanEvent_DataQualityAppliedConfigs) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataScanEvent_DataQualityAppliedConfigs.ProtoReflect.Descriptor instead.
func (*DataScanEvent_DataQualityAppliedConfigs) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{4, 3}
}

func (x *DataScanEvent_DataQualityAppliedConfigs) GetSamplingPercent() float32 {
	if x != nil {
		return x.SamplingPercent
	}
	return 0
}

func (x *DataScanEvent_DataQualityAppliedConfigs) GetRowFilterApplied() bool {
	if x != nil {
		return x.RowFilterApplied
	}
	return false
}

// Post scan actions result for data scan job.
type DataScanEvent_PostScanActionsResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The result of BigQuery export post scan action.
	BigqueryExportResult *DataScanEvent_PostScanActionsResult_BigQueryExportResult `protobuf:"bytes,1,opt,name=bigquery_export_result,json=bigqueryExportResult,proto3" json:"bigquery_export_result,omitempty"`
}

func (x *DataScanEvent_PostScanActionsResult) Reset() {
	*x = DataScanEvent_PostScanActionsResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataScanEvent_PostScanActionsResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataScanEvent_PostScanActionsResult) ProtoMessage() {}

func (x *DataScanEvent_PostScanActionsResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataScanEvent_PostScanActionsResult.ProtoReflect.Descriptor instead.
func (*DataScanEvent_PostScanActionsResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{4, 4}
}

func (x *DataScanEvent_PostScanActionsResult) GetBigqueryExportResult() *DataScanEvent_PostScanActionsResult_BigQueryExportResult {
	if x != nil {
		return x.BigqueryExportResult
	}
	return nil
}

// The result of BigQuery export post scan action.
type DataScanEvent_PostScanActionsResult_BigQueryExportResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Execution state for the BigQuery exporting.
	State DataScanEvent_PostScanActionsResult_BigQueryExportResult_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.dataplex.v1.DataScanEvent_PostScanActionsResult_BigQueryExportResult_State" json:"state,omitempty"`
	// Additional information about the BigQuery exporting.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *DataScanEvent_PostScanActionsResult_BigQueryExportResult) Reset() {
	*x = DataScanEvent_PostScanActionsResult_BigQueryExportResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataScanEvent_PostScanActionsResult_BigQueryExportResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataScanEvent_PostScanActionsResult_BigQueryExportResult) ProtoMessage() {}

func (x *DataScanEvent_PostScanActionsResult_BigQueryExportResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataScanEvent_PostScanActionsResult_BigQueryExportResult.ProtoReflect.Descriptor instead.
func (*DataScanEvent_PostScanActionsResult_BigQueryExportResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{4, 4, 0}
}

func (x *DataScanEvent_PostScanActionsResult_BigQueryExportResult) GetState() DataScanEvent_PostScanActionsResult_BigQueryExportResult_State {
	if x != nil {
		return x.State
	}
	return DataScanEvent_PostScanActionsResult_BigQueryExportResult_STATE_UNSPECIFIED
}

func (x *DataScanEvent_PostScanActionsResult_BigQueryExportResult) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

var File_google_cloud_dataplex_v1_logs_proto protoreflect.FileDescriptor

var file_google_cloud_dataplex_v1_logs_proto_rawDesc = []byte{
	0x0a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x6f, 0x67, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd4, 0x0a, 0x0a,
	0x0e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12,
	0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x6c, 0x61, 0x6b,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6c, 0x61, 0x6b, 0x65,
	0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x7a, 0x6f, 0x6e, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x7a, 0x6f, 0x6e, 0x65, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x64,
	0x61, 0x74, 0x61, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x12, 0x50, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x14, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x06, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x50, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18,
	0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52,
	0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x59, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x17, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x06, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xb6, 0x01, 0x0a, 0x0d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x66, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x1a, 0x3d,
	0x0a, 0x0f, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x70, 0x0a,
	0x0d, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x16,
	0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x47, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x1a,
	0xc7, 0x01, 0x0a, 0x10, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x47, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x12, 0x34, 0x0a, 0x16, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x64, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x14, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x23, 0x0a, 0x0d, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0xb4,
	0x01, 0x0a, 0x09, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16,
	0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x4f, 0x4e, 0x46,
	0x49, 0x47, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x43,
	0x52, 0x45, 0x41, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x45, 0x4e, 0x54, 0x49,
	0x54, 0x59, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x44, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e,
	0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x04,
	0x12, 0x15, 0x0a, 0x11, 0x50, 0x41, 0x52, 0x54, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x52,
	0x45, 0x41, 0x54, 0x45, 0x44, 0x10, 0x05, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x41, 0x52, 0x54, 0x49,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x44, 0x10, 0x06, 0x12, 0x15,
	0x0a, 0x11, 0x50, 0x41, 0x52, 0x54, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4c, 0x45,
	0x54, 0x45, 0x44, 0x10, 0x07, 0x22, 0x41, 0x0a, 0x0a, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x09, 0x0a, 0x05, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x46,
	0x49, 0x4c, 0x45, 0x53, 0x45, 0x54, 0x10, 0x02, 0x42, 0x09, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x22, 0xa6, 0x06, 0x0a, 0x08, 0x4a, 0x6f, 0x62, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x15, 0x0a, 0x06, 0x6a, 0x6f,
	0x62, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49,
	0x64, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f,
	0x62, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x3b, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x44, 0x0a, 0x07, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4a, 0x6f,
	0x62, 0x12, 0x60, 0x0a, 0x11, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74,
	0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65,
	0x72, 0x52, 0x10, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x72, 0x69, 0x67,
	0x67, 0x65, 0x72, 0x22, 0x35, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x09, 0x0a, 0x05, 0x53, 0x50, 0x41, 0x52, 0x4b, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08,
	0x4e, 0x4f, 0x54, 0x45, 0x42, 0x4f, 0x4f, 0x4b, 0x10, 0x02, 0x22, 0x55, 0x0a, 0x05, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55,
	0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49,
	0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c,
	0x45, 0x44, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x41, 0x42, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10,
	0x04, 0x22, 0x30, 0x0a, 0x07, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x13,
	0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x41, 0x54, 0x41, 0x50, 0x52, 0x4f,
	0x43, 0x10, 0x01, 0x22, 0x57, 0x0a, 0x10, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x21, 0x0a, 0x1d, 0x45, 0x58, 0x45, 0x43, 0x55,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x52, 0x49, 0x47, 0x47, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x54, 0x41,
	0x53, 0x4b, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x52,
	0x55, 0x4e, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x10, 0x02, 0x22, 0xe9, 0x06, 0x0a,
	0x0c, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x18, 0x0a,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x75, 0x73, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12,
	0x44, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x4a, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x48, 0x00, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x12, 0x27, 0x0a, 0x0f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x75, 0x63, 0x63, 0x65,
	0x65, 0x64, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x53, 0x75, 0x63, 0x63, 0x65, 0x65, 0x64, 0x65, 0x64, 0x12, 0x30, 0x0a, 0x14, 0x66, 0x61,
	0x73, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x75, 0x70, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x66, 0x61, 0x73, 0x74, 0x53, 0x74,
	0x61, 0x72, 0x74, 0x75, 0x70, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x4a, 0x0a, 0x13,
	0x75, 0x6e, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x75, 0x6e, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xee, 0x02, 0x0a, 0x0b, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x19, 0x0a, 0x08, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x65, 0x78,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x71, 0x75, 0x65, 0x72, 0x79, 0x54, 0x65,
	0x78, 0x74, 0x12, 0x51, 0x0a, 0x06, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x06, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x11,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65,
	0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x53,
	0x69, 0x7a, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x12, 0x64, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x22, 0x3d, 0x0a, 0x06, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x12, 0x16, 0x0a, 0x12, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09,
	0x53, 0x50, 0x41, 0x52, 0x4b, 0x5f, 0x53, 0x51, 0x4c, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x42,
	0x49, 0x47, 0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x02, 0x22, 0x53, 0x0a, 0x09, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x53, 0x54, 0x41, 0x52, 0x54, 0x10, 0x01, 0x12, 0x08, 0x0a,
	0x04, 0x53, 0x54, 0x4f, 0x50, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x51, 0x55, 0x45, 0x52, 0x59,
	0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x10, 0x04, 0x42, 0x08,
	0x0a, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x22, 0xea, 0x07, 0x0a, 0x0f, 0x47, 0x6f, 0x76,
	0x65, 0x72, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x18, 0x0a, 0x07,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x52, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4d, 0x0a, 0x06, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x06,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x88, 0x01, 0x01, 0x1a, 0xe6, 0x01, 0x0a, 0x06, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x12, 0x3b, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x12, 0x5c, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x22,
	0x41, 0x0a, 0x0a, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a,
	0x17, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x54, 0x41,
	0x42, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x46, 0x49, 0x4c, 0x45, 0x53, 0x45, 0x54,
	0x10, 0x02, 0x22, 0xa5, 0x04, 0x0a, 0x09, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x1a, 0x0a, 0x16, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1e, 0x0a, 0x1a,
	0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x49, 0x41, 0x4d, 0x5f, 0x50, 0x4f, 0x4c,
	0x49, 0x43, 0x59, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15,
	0x42, 0x49, 0x47, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x43,
	0x52, 0x45, 0x41, 0x54, 0x45, 0x10, 0x02, 0x12, 0x19, 0x0a, 0x15, 0x42, 0x49, 0x47, 0x51, 0x55,
	0x45, 0x52, 0x59, 0x5f, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45,
	0x10, 0x03, 0x12, 0x19, 0x0a, 0x15, 0x42, 0x49, 0x47, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x54,
	0x41, 0x42, 0x4c, 0x45, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x04, 0x12, 0x1e, 0x0a,
	0x1a, 0x42, 0x49, 0x47, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x10, 0x05, 0x12, 0x1e, 0x0a,
	0x1a, 0x42, 0x49, 0x47, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x06, 0x12, 0x1e, 0x0a,
	0x1a, 0x42, 0x49, 0x47, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x07, 0x12, 0x1c, 0x0a,
	0x18, 0x42, 0x49, 0x47, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x54, 0x41, 0x58, 0x4f, 0x4e, 0x4f,
	0x4d, 0x59, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x10, 0x0a, 0x12, 0x1e, 0x0a, 0x1a, 0x42,
	0x49, 0x47, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x54,
	0x41, 0x47, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x10, 0x0b, 0x12, 0x1e, 0x0a, 0x1a, 0x42,
	0x49, 0x47, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x54,
	0x41, 0x47, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x0c, 0x12, 0x26, 0x0a, 0x22, 0x42,
	0x49, 0x47, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x54,
	0x41, 0x47, 0x5f, 0x53, 0x45, 0x54, 0x5f, 0x49, 0x41, 0x4d, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43,
	0x59, 0x10, 0x0d, 0x12, 0x18, 0x0a, 0x14, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x50, 0x4f,
	0x4c, 0x49, 0x43, 0x59, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x0e, 0x12, 0x25, 0x0a,
	0x21, 0x47, 0x4f, 0x56, 0x45, 0x52, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x52, 0x55, 0x4c, 0x45,
	0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43,
	0x45, 0x53, 0x10, 0x0f, 0x12, 0x28, 0x0a, 0x24, 0x47, 0x4f, 0x56, 0x45, 0x52, 0x4e, 0x41, 0x4e,
	0x43, 0x45, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x5f, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x4c,
	0x49, 0x4d, 0x49, 0x54, 0x5f, 0x45, 0x58, 0x43, 0x45, 0x45, 0x44, 0x53, 0x10, 0x10, 0x12, 0x1a,
	0x0a, 0x16, 0x47, 0x4f, 0x56, 0x45, 0x52, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x52, 0x55, 0x4c,
	0x45, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x53, 0x10, 0x11, 0x12, 0x1e, 0x0a, 0x1a, 0x47, 0x4f,
	0x56, 0x45, 0x52, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x5f, 0x50, 0x52,
	0x4f, 0x43, 0x45, 0x53, 0x53, 0x49, 0x4e, 0x47, 0x10, 0x12, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x22, 0xaa, 0x16, 0x0a, 0x0d, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63,
	0x61, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x64, 0x61,
	0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x15, 0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49, 0x64, 0x12,
	0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x0a,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x44,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x63, 0x61, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x12, 0x43, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x70, 0x65, 0x63, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x07, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65,
	0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x2e, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x07, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65,
	0x72, 0x12, 0x43, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x63, 0x61, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x52,
	0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x5e, 0x0a, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x5e, 0x0a, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x71,
	0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x66, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x51,
	0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x76, 0x0a, 0x14, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0xc9,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x65,
	0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x48, 0x01, 0x52, 0x12, 0x64, 0x61, 0x74, 0x61,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x76,
	0x0a, 0x14, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0xca, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61,
	0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69,
	0x74, 0x79, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x48, 0x01, 0x52, 0x12, 0x64, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x76, 0x0a, 0x18, 0x70, 0x6f, 0x73, 0x74, 0x5f, 0x73,
	0x63, 0x61, 0x6e, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x53, 0x63, 0x61, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x15, 0x70, 0x6f, 0x73, 0x74, 0x53, 0x63, 0x61,
	0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x1a, 0x30,
	0x0a, 0x11, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x72, 0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x1a, 0x87, 0x05, 0x0a, 0x11, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x72, 0x6f, 0x77, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x73, 0x73, 0x65, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x06, 0x70, 0x61, 0x73, 0x73, 0x65, 0x64, 0x12, 0x79, 0x0a, 0x10, 0x64,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x65, 0x64, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x73, 0x73, 0x65, 0x64,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x50, 0x61, 0x73, 0x73, 0x65, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x76, 0x0a, 0x0f,
	0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x0e, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53,
	0x63, 0x6f, 0x72, 0x65, 0x12, 0x6d, 0x0a, 0x0c, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x73,
	0x63, 0x6f, 0x72, 0x65, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x53, 0x63, 0x6f, 0x72,
	0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x53, 0x63,
	0x6f, 0x72, 0x65, 0x1a, 0x42, 0x0a, 0x14, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x50, 0x61, 0x73, 0x73, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x41, 0x0a, 0x13, 0x44, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3e, 0x0a, 0x10, 0x43, 0x6f,
	0x6c, 0x75, 0x6d, 0x6e, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0xa8, 0x01, 0x0a, 0x19, 0x44,
	0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x65,
	0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x73, 0x61, 0x6d, 0x70,
	0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x02, 0x52, 0x0f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e, 0x67, 0x50, 0x65, 0x72, 0x63,
	0x65, 0x6e, 0x74, 0x12, 0x2c, 0x0a, 0x12, 0x72, 0x6f, 0x77, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x10, 0x72, 0x6f, 0x77, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x65,
	0x64, 0x12, 0x32, 0x0a, 0x15, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x13, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x65, 0x64, 0x1a, 0x74, 0x0a, 0x19, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61,
	0x6c, 0x69, 0x74, 0x79, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x70,
	0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0f, 0x73, 0x61,
	0x6d, 0x70, 0x6c, 0x69, 0x6e, 0x67, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12, 0x2c, 0x0a,
	0x12, 0x72, 0x6f, 0x77, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x72, 0x6f, 0x77, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x1a, 0x8d, 0x03, 0x0a, 0x15,
	0x50, 0x6f, 0x73, 0x74, 0x53, 0x63, 0x61, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x88, 0x01, 0x0a, 0x16, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e,
	0x50, 0x6f, 0x73, 0x74, 0x53, 0x63, 0x61, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x14, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x1a, 0xe8, 0x01, 0x0a, 0x14, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x6e, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x58, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x53, 0x63, 0x61, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x22, 0x46, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44,
	0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0b,
	0x0a, 0x07, 0x53, 0x4b, 0x49, 0x50, 0x50, 0x45, 0x44, 0x10, 0x03, 0x22, 0x49, 0x0a, 0x08, 0x53,
	0x63, 0x61, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x53, 0x43, 0x41, 0x4e, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x50, 0x52, 0x4f, 0x46, 0x49,
	0x4c, 0x45, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x51, 0x55, 0x41,
	0x4c, 0x49, 0x54, 0x59, 0x10, 0x02, 0x22, 0x62, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x41, 0x52, 0x54, 0x45,
	0x44, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44,
	0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0d,
	0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0b, 0x0a,
	0x07, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44, 0x10, 0x05, 0x22, 0x3f, 0x0a, 0x07, 0x54, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x17, 0x0a, 0x13, 0x54, 0x52, 0x49, 0x47, 0x47, 0x45, 0x52,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d,
	0x0a, 0x09, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4d, 0x41, 0x4e, 0x44, 0x10, 0x01, 0x12, 0x0c, 0x0a,
	0x08, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x10, 0x02, 0x22, 0x39, 0x0a, 0x05, 0x53,
	0x63, 0x6f, 0x70, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x43, 0x4f, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x46,
	0x55, 0x4c, 0x4c, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x43, 0x52, 0x45, 0x4d, 0x45,
	0x4e, 0x54, 0x41, 0x4c, 0x10, 0x02, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x42, 0x10, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x22, 0xc4, 0x08, 0x0a, 0x19, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69,
	0x74, 0x79, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x12, 0x15, 0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x64, 0x61,
	0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6f, 0x6c, 0x75,
	0x6d, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x12, 0x1b, 0x0a, 0x09, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x75, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x59, 0x0a,
	0x09, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x52, 0x75, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08,
	0x72, 0x75, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x69, 0x0a, 0x0e, 0x65, 0x76, 0x61, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x0d, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x64, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x75, 0x6c,
	0x65, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x0a, 0x11, 0x74, 0x68,
	0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x01, 0x52, 0x10, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64,
	0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12, 0x52, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x63,
	0x61, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x2e, 0x0a, 0x13, 0x65,
	0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x65, 0x64, 0x52, 0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x10, 0x70,
	0x61, 0x73, 0x73, 0x65, 0x64, 0x5f, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x70, 0x61, 0x73, 0x73, 0x65, 0x64, 0x52, 0x6f, 0x77,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x24, 0x0a, 0x0e, 0x6e, 0x75, 0x6c, 0x6c, 0x5f, 0x72, 0x6f,
	0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x6e,
	0x75, 0x6c, 0x6c, 0x52, 0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x13, 0x61,
	0x73, 0x73, 0x65, 0x72, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x61, 0x73, 0x73, 0x65, 0x72, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x92, 0x02, 0x0a, 0x08,
	0x52, 0x75, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x52, 0x55, 0x4c, 0x45,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x4e, 0x4f, 0x4e, 0x5f, 0x4e, 0x55, 0x4c, 0x4c, 0x5f,
	0x45, 0x58, 0x50, 0x45, 0x43, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x15, 0x0a,
	0x11, 0x52, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x45, 0x58, 0x50, 0x45, 0x43, 0x54, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x52, 0x45, 0x47, 0x45, 0x58, 0x5f, 0x45, 0x58,
	0x50, 0x45, 0x43, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x12, 0x1d, 0x0a, 0x19, 0x52,
	0x4f, 0x57, 0x5f, 0x43, 0x4f, 0x4e, 0x44, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x58, 0x50,
	0x45, 0x43, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x45,
	0x54, 0x5f, 0x45, 0x58, 0x50, 0x45, 0x43, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x05, 0x12,
	0x1f, 0x0a, 0x1b, 0x53, 0x54, 0x41, 0x54, 0x49, 0x53, 0x54, 0x49, 0x43, 0x5f, 0x52, 0x41, 0x4e,
	0x47, 0x45, 0x5f, 0x45, 0x58, 0x50, 0x45, 0x43, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x06,
	0x12, 0x1f, 0x0a, 0x1b, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x44, 0x49, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x58, 0x50, 0x45, 0x43, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x07, 0x12, 0x1a, 0x0a, 0x16, 0x55, 0x4e, 0x49, 0x51, 0x55, 0x45, 0x4e, 0x45, 0x53, 0x53, 0x5f,
	0x45, 0x58, 0x50, 0x45, 0x43, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x08, 0x12, 0x11, 0x0a,
	0x0d, 0x53, 0x51, 0x4c, 0x5f, 0x41, 0x53, 0x53, 0x45, 0x52, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x09,
	0x22, 0x4d, 0x0a, 0x0e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x45, 0x56, 0x41, 0x4c, 0x55, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x52, 0x5f, 0x52, 0x4f, 0x57, 0x10, 0x01,
	0x12, 0x0d, 0x0a, 0x09, 0x41, 0x47, 0x47, 0x52, 0x45, 0x47, 0x41, 0x54, 0x45, 0x10, 0x02, 0x22,
	0x38, 0x0a, 0x06, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x53,
	0x55, 0x4c, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x41, 0x53, 0x53, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a,
	0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x42, 0x65, 0x0a, 0x1c, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x42, 0x09, 0x4c, 0x6f, 0x67, 0x73, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x70, 0x62,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dataplex_v1_logs_proto_rawDescOnce sync.Once
	file_google_cloud_dataplex_v1_logs_proto_rawDescData = file_google_cloud_dataplex_v1_logs_proto_rawDesc
)

func file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP() []byte {
	file_google_cloud_dataplex_v1_logs_proto_rawDescOnce.Do(func() {
		file_google_cloud_dataplex_v1_logs_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dataplex_v1_logs_proto_rawDescData)
	})
	return file_google_cloud_dataplex_v1_logs_proto_rawDescData
}

var file_google_cloud_dataplex_v1_logs_proto_enumTypes = make([]protoimpl.EnumInfo, 18)
var file_google_cloud_dataplex_v1_logs_proto_msgTypes = make([]protoimpl.MessageInfo, 22)
var file_google_cloud_dataplex_v1_logs_proto_goTypes = []any{
	(DiscoveryEvent_EventType)(0),          // 0: google.cloud.dataplex.v1.DiscoveryEvent.EventType
	(DiscoveryEvent_EntityType)(0),         // 1: google.cloud.dataplex.v1.DiscoveryEvent.EntityType
	(JobEvent_Type)(0),                     // 2: google.cloud.dataplex.v1.JobEvent.Type
	(JobEvent_State)(0),                    // 3: google.cloud.dataplex.v1.JobEvent.State
	(JobEvent_Service)(0),                  // 4: google.cloud.dataplex.v1.JobEvent.Service
	(JobEvent_ExecutionTrigger)(0),         // 5: google.cloud.dataplex.v1.JobEvent.ExecutionTrigger
	(SessionEvent_EventType)(0),            // 6: google.cloud.dataplex.v1.SessionEvent.EventType
	(SessionEvent_QueryDetail_Engine)(0),   // 7: google.cloud.dataplex.v1.SessionEvent.QueryDetail.Engine
	(GovernanceEvent_EventType)(0),         // 8: google.cloud.dataplex.v1.GovernanceEvent.EventType
	(GovernanceEvent_Entity_EntityType)(0), // 9: google.cloud.dataplex.v1.GovernanceEvent.Entity.EntityType
	(DataScanEvent_ScanType)(0),            // 10: google.cloud.dataplex.v1.DataScanEvent.ScanType
	(DataScanEvent_State)(0),               // 11: google.cloud.dataplex.v1.DataScanEvent.State
	(DataScanEvent_Trigger)(0),             // 12: google.cloud.dataplex.v1.DataScanEvent.Trigger
	(DataScanEvent_Scope)(0),               // 13: google.cloud.dataplex.v1.DataScanEvent.Scope
	(DataScanEvent_PostScanActionsResult_BigQueryExportResult_State)(0), // 14: google.cloud.dataplex.v1.DataScanEvent.PostScanActionsResult.BigQueryExportResult.State
	(DataQualityScanRuleResult_RuleType)(0),                             // 15: google.cloud.dataplex.v1.DataQualityScanRuleResult.RuleType
	(DataQualityScanRuleResult_EvaluationType)(0),                       // 16: google.cloud.dataplex.v1.DataQualityScanRuleResult.EvaluationType
	(DataQualityScanRuleResult_Result)(0),                               // 17: google.cloud.dataplex.v1.DataQualityScanRuleResult.Result
	(*DiscoveryEvent)(nil),                                              // 18: google.cloud.dataplex.v1.DiscoveryEvent
	(*JobEvent)(nil),                                                    // 19: google.cloud.dataplex.v1.JobEvent
	(*SessionEvent)(nil),                                                // 20: google.cloud.dataplex.v1.SessionEvent
	(*GovernanceEvent)(nil),                                             // 21: google.cloud.dataplex.v1.GovernanceEvent
	(*DataScanEvent)(nil),                                               // 22: google.cloud.dataplex.v1.DataScanEvent
	(*DataQualityScanRuleResult)(nil),                                   // 23: google.cloud.dataplex.v1.DataQualityScanRuleResult
	(*DiscoveryEvent_ConfigDetails)(nil),                                // 24: google.cloud.dataplex.v1.DiscoveryEvent.ConfigDetails
	(*DiscoveryEvent_EntityDetails)(nil),                                // 25: google.cloud.dataplex.v1.DiscoveryEvent.EntityDetails
	(*DiscoveryEvent_PartitionDetails)(nil),                             // 26: google.cloud.dataplex.v1.DiscoveryEvent.PartitionDetails
	(*DiscoveryEvent_ActionDetails)(nil),                                // 27: google.cloud.dataplex.v1.DiscoveryEvent.ActionDetails
	nil,                                                                 // 28: google.cloud.dataplex.v1.DiscoveryEvent.ConfigDetails.ParametersEntry
	(*SessionEvent_QueryDetail)(nil),                                    // 29: google.cloud.dataplex.v1.SessionEvent.QueryDetail
	(*GovernanceEvent_Entity)(nil),                                      // 30: google.cloud.dataplex.v1.GovernanceEvent.Entity
	(*DataScanEvent_DataProfileResult)(nil),                             // 31: google.cloud.dataplex.v1.DataScanEvent.DataProfileResult
	(*DataScanEvent_DataQualityResult)(nil),                             // 32: google.cloud.dataplex.v1.DataScanEvent.DataQualityResult
	(*DataScanEvent_DataProfileAppliedConfigs)(nil),                     // 33: google.cloud.dataplex.v1.DataScanEvent.DataProfileAppliedConfigs
	(*DataScanEvent_DataQualityAppliedConfigs)(nil),                     // 34: google.cloud.dataplex.v1.DataScanEvent.DataQualityAppliedConfigs
	(*DataScanEvent_PostScanActionsResult)(nil),                         // 35: google.cloud.dataplex.v1.DataScanEvent.PostScanActionsResult
	nil, // 36: google.cloud.dataplex.v1.DataScanEvent.DataQualityResult.DimensionPassedEntry
	nil, // 37: google.cloud.dataplex.v1.DataScanEvent.DataQualityResult.DimensionScoreEntry
	nil, // 38: google.cloud.dataplex.v1.DataScanEvent.DataQualityResult.ColumnScoreEntry
	(*DataScanEvent_PostScanActionsResult_BigQueryExportResult)(nil), // 39: google.cloud.dataplex.v1.DataScanEvent.PostScanActionsResult.BigQueryExportResult
	(*timestamppb.Timestamp)(nil),                                    // 40: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),                                      // 41: google.protobuf.Duration
}
var file_google_cloud_dataplex_v1_logs_proto_depIdxs = []int32{
	0,  // 0: google.cloud.dataplex.v1.DiscoveryEvent.type:type_name -> google.cloud.dataplex.v1.DiscoveryEvent.EventType
	24, // 1: google.cloud.dataplex.v1.DiscoveryEvent.config:type_name -> google.cloud.dataplex.v1.DiscoveryEvent.ConfigDetails
	25, // 2: google.cloud.dataplex.v1.DiscoveryEvent.entity:type_name -> google.cloud.dataplex.v1.DiscoveryEvent.EntityDetails
	26, // 3: google.cloud.dataplex.v1.DiscoveryEvent.partition:type_name -> google.cloud.dataplex.v1.DiscoveryEvent.PartitionDetails
	27, // 4: google.cloud.dataplex.v1.DiscoveryEvent.action:type_name -> google.cloud.dataplex.v1.DiscoveryEvent.ActionDetails
	40, // 5: google.cloud.dataplex.v1.JobEvent.start_time:type_name -> google.protobuf.Timestamp
	40, // 6: google.cloud.dataplex.v1.JobEvent.end_time:type_name -> google.protobuf.Timestamp
	3,  // 7: google.cloud.dataplex.v1.JobEvent.state:type_name -> google.cloud.dataplex.v1.JobEvent.State
	2,  // 8: google.cloud.dataplex.v1.JobEvent.type:type_name -> google.cloud.dataplex.v1.JobEvent.Type
	4,  // 9: google.cloud.dataplex.v1.JobEvent.service:type_name -> google.cloud.dataplex.v1.JobEvent.Service
	5,  // 10: google.cloud.dataplex.v1.JobEvent.execution_trigger:type_name -> google.cloud.dataplex.v1.JobEvent.ExecutionTrigger
	6,  // 11: google.cloud.dataplex.v1.SessionEvent.type:type_name -> google.cloud.dataplex.v1.SessionEvent.EventType
	29, // 12: google.cloud.dataplex.v1.SessionEvent.query:type_name -> google.cloud.dataplex.v1.SessionEvent.QueryDetail
	41, // 13: google.cloud.dataplex.v1.SessionEvent.unassigned_duration:type_name -> google.protobuf.Duration
	8,  // 14: google.cloud.dataplex.v1.GovernanceEvent.event_type:type_name -> google.cloud.dataplex.v1.GovernanceEvent.EventType
	30, // 15: google.cloud.dataplex.v1.GovernanceEvent.entity:type_name -> google.cloud.dataplex.v1.GovernanceEvent.Entity
	40, // 16: google.cloud.dataplex.v1.DataScanEvent.create_time:type_name -> google.protobuf.Timestamp
	40, // 17: google.cloud.dataplex.v1.DataScanEvent.start_time:type_name -> google.protobuf.Timestamp
	40, // 18: google.cloud.dataplex.v1.DataScanEvent.end_time:type_name -> google.protobuf.Timestamp
	10, // 19: google.cloud.dataplex.v1.DataScanEvent.type:type_name -> google.cloud.dataplex.v1.DataScanEvent.ScanType
	11, // 20: google.cloud.dataplex.v1.DataScanEvent.state:type_name -> google.cloud.dataplex.v1.DataScanEvent.State
	12, // 21: google.cloud.dataplex.v1.DataScanEvent.trigger:type_name -> google.cloud.dataplex.v1.DataScanEvent.Trigger
	13, // 22: google.cloud.dataplex.v1.DataScanEvent.scope:type_name -> google.cloud.dataplex.v1.DataScanEvent.Scope
	31, // 23: google.cloud.dataplex.v1.DataScanEvent.data_profile:type_name -> google.cloud.dataplex.v1.DataScanEvent.DataProfileResult
	32, // 24: google.cloud.dataplex.v1.DataScanEvent.data_quality:type_name -> google.cloud.dataplex.v1.DataScanEvent.DataQualityResult
	33, // 25: google.cloud.dataplex.v1.DataScanEvent.data_profile_configs:type_name -> google.cloud.dataplex.v1.DataScanEvent.DataProfileAppliedConfigs
	34, // 26: google.cloud.dataplex.v1.DataScanEvent.data_quality_configs:type_name -> google.cloud.dataplex.v1.DataScanEvent.DataQualityAppliedConfigs
	35, // 27: google.cloud.dataplex.v1.DataScanEvent.post_scan_actions_result:type_name -> google.cloud.dataplex.v1.DataScanEvent.PostScanActionsResult
	15, // 28: google.cloud.dataplex.v1.DataQualityScanRuleResult.rule_type:type_name -> google.cloud.dataplex.v1.DataQualityScanRuleResult.RuleType
	16, // 29: google.cloud.dataplex.v1.DataQualityScanRuleResult.evalution_type:type_name -> google.cloud.dataplex.v1.DataQualityScanRuleResult.EvaluationType
	17, // 30: google.cloud.dataplex.v1.DataQualityScanRuleResult.result:type_name -> google.cloud.dataplex.v1.DataQualityScanRuleResult.Result
	28, // 31: google.cloud.dataplex.v1.DiscoveryEvent.ConfigDetails.parameters:type_name -> google.cloud.dataplex.v1.DiscoveryEvent.ConfigDetails.ParametersEntry
	1,  // 32: google.cloud.dataplex.v1.DiscoveryEvent.EntityDetails.type:type_name -> google.cloud.dataplex.v1.DiscoveryEvent.EntityType
	1,  // 33: google.cloud.dataplex.v1.DiscoveryEvent.PartitionDetails.type:type_name -> google.cloud.dataplex.v1.DiscoveryEvent.EntityType
	7,  // 34: google.cloud.dataplex.v1.SessionEvent.QueryDetail.engine:type_name -> google.cloud.dataplex.v1.SessionEvent.QueryDetail.Engine
	41, // 35: google.cloud.dataplex.v1.SessionEvent.QueryDetail.duration:type_name -> google.protobuf.Duration
	9,  // 36: google.cloud.dataplex.v1.GovernanceEvent.Entity.entity_type:type_name -> google.cloud.dataplex.v1.GovernanceEvent.Entity.EntityType
	36, // 37: google.cloud.dataplex.v1.DataScanEvent.DataQualityResult.dimension_passed:type_name -> google.cloud.dataplex.v1.DataScanEvent.DataQualityResult.DimensionPassedEntry
	37, // 38: google.cloud.dataplex.v1.DataScanEvent.DataQualityResult.dimension_score:type_name -> google.cloud.dataplex.v1.DataScanEvent.DataQualityResult.DimensionScoreEntry
	38, // 39: google.cloud.dataplex.v1.DataScanEvent.DataQualityResult.column_score:type_name -> google.cloud.dataplex.v1.DataScanEvent.DataQualityResult.ColumnScoreEntry
	39, // 40: google.cloud.dataplex.v1.DataScanEvent.PostScanActionsResult.bigquery_export_result:type_name -> google.cloud.dataplex.v1.DataScanEvent.PostScanActionsResult.BigQueryExportResult
	14, // 41: google.cloud.dataplex.v1.DataScanEvent.PostScanActionsResult.BigQueryExportResult.state:type_name -> google.cloud.dataplex.v1.DataScanEvent.PostScanActionsResult.BigQueryExportResult.State
	42, // [42:42] is the sub-list for method output_type
	42, // [42:42] is the sub-list for method input_type
	42, // [42:42] is the sub-list for extension type_name
	42, // [42:42] is the sub-list for extension extendee
	0,  // [0:42] is the sub-list for field type_name
}

func init() { file_google_cloud_dataplex_v1_logs_proto_init() }
func file_google_cloud_dataplex_v1_logs_proto_init() {
	if File_google_cloud_dataplex_v1_logs_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dataplex_v1_logs_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*DiscoveryEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_logs_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*JobEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_logs_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*SessionEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_logs_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*GovernanceEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_logs_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*DataScanEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_logs_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*DataQualityScanRuleResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_logs_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*DiscoveryEvent_ConfigDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_logs_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*DiscoveryEvent_EntityDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_logs_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*DiscoveryEvent_PartitionDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_logs_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*DiscoveryEvent_ActionDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_logs_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*SessionEvent_QueryDetail); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_logs_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*GovernanceEvent_Entity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_logs_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*DataScanEvent_DataProfileResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_logs_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*DataScanEvent_DataQualityResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_logs_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*DataScanEvent_DataProfileAppliedConfigs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_logs_proto_msgTypes[16].Exporter = func(v any, i int) any {
			switch v := v.(*DataScanEvent_DataQualityAppliedConfigs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_logs_proto_msgTypes[17].Exporter = func(v any, i int) any {
			switch v := v.(*DataScanEvent_PostScanActionsResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_logs_proto_msgTypes[21].Exporter = func(v any, i int) any {
			switch v := v.(*DataScanEvent_PostScanActionsResult_BigQueryExportResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dataplex_v1_logs_proto_msgTypes[0].OneofWrappers = []any{
		(*DiscoveryEvent_Config)(nil),
		(*DiscoveryEvent_Entity)(nil),
		(*DiscoveryEvent_Partition)(nil),
		(*DiscoveryEvent_Action)(nil),
	}
	file_google_cloud_dataplex_v1_logs_proto_msgTypes[2].OneofWrappers = []any{
		(*SessionEvent_Query)(nil),
	}
	file_google_cloud_dataplex_v1_logs_proto_msgTypes[3].OneofWrappers = []any{}
	file_google_cloud_dataplex_v1_logs_proto_msgTypes[4].OneofWrappers = []any{
		(*DataScanEvent_DataProfile)(nil),
		(*DataScanEvent_DataQuality)(nil),
		(*DataScanEvent_DataProfileConfigs)(nil),
		(*DataScanEvent_DataQualityConfigs)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dataplex_v1_logs_proto_rawDesc,
			NumEnums:      18,
			NumMessages:   22,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_dataplex_v1_logs_proto_goTypes,
		DependencyIndexes: file_google_cloud_dataplex_v1_logs_proto_depIdxs,
		EnumInfos:         file_google_cloud_dataplex_v1_logs_proto_enumTypes,
		MessageInfos:      file_google_cloud_dataplex_v1_logs_proto_msgTypes,
	}.Build()
	File_google_cloud_dataplex_v1_logs_proto = out.File
	file_google_cloud_dataplex_v1_logs_proto_rawDesc = nil
	file_google_cloud_dataplex_v1_logs_proto_goTypes = nil
	file_google_cloud_dataplex_v1_logs_proto_depIdxs = nil
}
