// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.23.2
// source: google/cloud/batch/v1/job.proto

package batchpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The destination (if any) for logs.
type LogsPolicy_Destination int32

const (
	// Logs are not preserved.
	LogsPolicy_DESTINATION_UNSPECIFIED LogsPolicy_Destination = 0
	// Logs are streamed to Cloud Logging.
	LogsPolicy_CLOUD_LOGGING LogsPolicy_Destination = 1
	// Logs are saved to a file path.
	LogsPolicy_PATH LogsPolicy_Destination = 2
)

// Enum value maps for LogsPolicy_Destination.
var (
	LogsPolicy_Destination_name = map[int32]string{
		0: "DESTINATION_UNSPECIFIED",
		1: "CLOUD_LOGGING",
		2: "PATH",
	}
	LogsPolicy_Destination_value = map[string]int32{
		"DESTINATION_UNSPECIFIED": 0,
		"CLOUD_LOGGING":           1,
		"PATH":                    2,
	}
)

func (x LogsPolicy_Destination) Enum() *LogsPolicy_Destination {
	p := new(LogsPolicy_Destination)
	*p = x
	return p
}

func (x LogsPolicy_Destination) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LogsPolicy_Destination) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_batch_v1_job_proto_enumTypes[0].Descriptor()
}

func (LogsPolicy_Destination) Type() protoreflect.EnumType {
	return &file_google_cloud_batch_v1_job_proto_enumTypes[0]
}

func (x LogsPolicy_Destination) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LogsPolicy_Destination.Descriptor instead.
func (LogsPolicy_Destination) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1_job_proto_rawDescGZIP(), []int{1, 0}
}

// Valid Job states.
type JobStatus_State int32

const (
	// Job state unspecified.
	JobStatus_STATE_UNSPECIFIED JobStatus_State = 0
	// Job is admitted (validated and persisted) and waiting for resources.
	JobStatus_QUEUED JobStatus_State = 1
	// Job is scheduled to run as soon as resource allocation is ready.
	// The resource allocation may happen at a later time but with a high
	// chance to succeed.
	JobStatus_SCHEDULED JobStatus_State = 2
	// Resource allocation has been successful. At least one Task in the Job is
	// RUNNING.
	JobStatus_RUNNING JobStatus_State = 3
	// All Tasks in the Job have finished successfully.
	JobStatus_SUCCEEDED JobStatus_State = 4
	// At least one Task in the Job has failed.
	JobStatus_FAILED JobStatus_State = 5
	// The Job will be deleted, but has not been deleted yet. Typically this is
	// because resources used by the Job are still being cleaned up.
	JobStatus_DELETION_IN_PROGRESS JobStatus_State = 6
)

// Enum value maps for JobStatus_State.
var (
	JobStatus_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "QUEUED",
		2: "SCHEDULED",
		3: "RUNNING",
		4: "SUCCEEDED",
		5: "FAILED",
		6: "DELETION_IN_PROGRESS",
	}
	JobStatus_State_value = map[string]int32{
		"STATE_UNSPECIFIED":    0,
		"QUEUED":               1,
		"SCHEDULED":            2,
		"RUNNING":              3,
		"SUCCEEDED":            4,
		"FAILED":               5,
		"DELETION_IN_PROGRESS": 6,
	}
)

func (x JobStatus_State) Enum() *JobStatus_State {
	p := new(JobStatus_State)
	*p = x
	return p
}

func (x JobStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JobStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_batch_v1_job_proto_enumTypes[1].Descriptor()
}

func (JobStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_batch_v1_job_proto_enumTypes[1]
}

func (x JobStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JobStatus_State.Descriptor instead.
func (JobStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1_job_proto_rawDescGZIP(), []int{2, 0}
}

// The message type.
type JobNotification_Type int32

const (
	// Unspecified.
	JobNotification_TYPE_UNSPECIFIED JobNotification_Type = 0
	// Notify users that the job state has changed.
	JobNotification_JOB_STATE_CHANGED JobNotification_Type = 1
	// Notify users that the task state has changed.
	JobNotification_TASK_STATE_CHANGED JobNotification_Type = 2
)

// Enum value maps for JobNotification_Type.
var (
	JobNotification_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "JOB_STATE_CHANGED",
		2: "TASK_STATE_CHANGED",
	}
	JobNotification_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":   0,
		"JOB_STATE_CHANGED":  1,
		"TASK_STATE_CHANGED": 2,
	}
)

func (x JobNotification_Type) Enum() *JobNotification_Type {
	p := new(JobNotification_Type)
	*p = x
	return p
}

func (x JobNotification_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JobNotification_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_batch_v1_job_proto_enumTypes[2].Descriptor()
}

func (JobNotification_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_batch_v1_job_proto_enumTypes[2]
}

func (x JobNotification_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JobNotification_Type.Descriptor instead.
func (JobNotification_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1_job_proto_rawDescGZIP(), []int{3, 0}
}

// Compute Engine VM instance provisioning model.
type AllocationPolicy_ProvisioningModel int32

const (
	// Unspecified.
	AllocationPolicy_PROVISIONING_MODEL_UNSPECIFIED AllocationPolicy_ProvisioningModel = 0
	// Standard VM.
	AllocationPolicy_STANDARD AllocationPolicy_ProvisioningModel = 1
	// SPOT VM.
	AllocationPolicy_SPOT AllocationPolicy_ProvisioningModel = 2
	// Preemptible VM (PVM).
	//
	// Above SPOT VM is the preferable model for preemptible VM instances: the
	// old preemptible VM model (indicated by this field) is the older model,
	// and has been migrated to use the SPOT model as the underlying technology.
	// This old model will still be supported.
	AllocationPolicy_PREEMPTIBLE AllocationPolicy_ProvisioningModel = 3
)

// Enum value maps for AllocationPolicy_ProvisioningModel.
var (
	AllocationPolicy_ProvisioningModel_name = map[int32]string{
		0: "PROVISIONING_MODEL_UNSPECIFIED",
		1: "STANDARD",
		2: "SPOT",
		3: "PREEMPTIBLE",
	}
	AllocationPolicy_ProvisioningModel_value = map[string]int32{
		"PROVISIONING_MODEL_UNSPECIFIED": 0,
		"STANDARD":                       1,
		"SPOT":                           2,
		"PREEMPTIBLE":                    3,
	}
)

func (x AllocationPolicy_ProvisioningModel) Enum() *AllocationPolicy_ProvisioningModel {
	p := new(AllocationPolicy_ProvisioningModel)
	*p = x
	return p
}

func (x AllocationPolicy_ProvisioningModel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AllocationPolicy_ProvisioningModel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_batch_v1_job_proto_enumTypes[3].Descriptor()
}

func (AllocationPolicy_ProvisioningModel) Type() protoreflect.EnumType {
	return &file_google_cloud_batch_v1_job_proto_enumTypes[3]
}

func (x AllocationPolicy_ProvisioningModel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AllocationPolicy_ProvisioningModel.Descriptor instead.
func (AllocationPolicy_ProvisioningModel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1_job_proto_rawDescGZIP(), []int{4, 0}
}

// How Tasks in the TaskGroup should be scheduled relative to each other.
type TaskGroup_SchedulingPolicy int32

const (
	// Unspecified.
	TaskGroup_SCHEDULING_POLICY_UNSPECIFIED TaskGroup_SchedulingPolicy = 0
	// Run Tasks as soon as resources are available.
	//
	// Tasks might be executed in parallel depending on parallelism and
	// task_count values.
	TaskGroup_AS_SOON_AS_POSSIBLE TaskGroup_SchedulingPolicy = 1
	// Run Tasks sequentially with increased task index.
	TaskGroup_IN_ORDER TaskGroup_SchedulingPolicy = 2
)

// Enum value maps for TaskGroup_SchedulingPolicy.
var (
	TaskGroup_SchedulingPolicy_name = map[int32]string{
		0: "SCHEDULING_POLICY_UNSPECIFIED",
		1: "AS_SOON_AS_POSSIBLE",
		2: "IN_ORDER",
	}
	TaskGroup_SchedulingPolicy_value = map[string]int32{
		"SCHEDULING_POLICY_UNSPECIFIED": 0,
		"AS_SOON_AS_POSSIBLE":           1,
		"IN_ORDER":                      2,
	}
)

func (x TaskGroup_SchedulingPolicy) Enum() *TaskGroup_SchedulingPolicy {
	p := new(TaskGroup_SchedulingPolicy)
	*p = x
	return p
}

func (x TaskGroup_SchedulingPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TaskGroup_SchedulingPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_batch_v1_job_proto_enumTypes[4].Descriptor()
}

func (TaskGroup_SchedulingPolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_batch_v1_job_proto_enumTypes[4]
}

func (x TaskGroup_SchedulingPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TaskGroup_SchedulingPolicy.Descriptor instead.
func (TaskGroup_SchedulingPolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1_job_proto_rawDescGZIP(), []int{5, 0}
}

// The Cloud Batch Job description.
type Job struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Job name.
	// For example: "projects/123456/locations/us-central1/jobs/job01".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. A system generated unique ID (in UUID4 format) for the Job.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Priority of the Job.
	// The valid value range is [0, 100). Default value is 0.
	// Higher value indicates higher priority.
	// A job with higher priority value is more likely to run earlier if all other
	// requirements are satisfied.
	Priority int64 `protobuf:"varint,3,opt,name=priority,proto3" json:"priority,omitempty"`
	// Required. TaskGroups in the Job. Only one TaskGroup is supported now.
	TaskGroups []*TaskGroup `protobuf:"bytes,4,rep,name=task_groups,json=taskGroups,proto3" json:"task_groups,omitempty"`
	// Compute resource allocation for all TaskGroups in the Job.
	AllocationPolicy *AllocationPolicy `protobuf:"bytes,7,opt,name=allocation_policy,json=allocationPolicy,proto3" json:"allocation_policy,omitempty"`
	// Labels for the Job. Labels could be user provided or system generated.
	// For example,
	// "labels": {
	//    "department": "finance",
	//    "environment": "test"
	//  }
	// You can assign up to 64 labels.  [Google Compute Engine label
	// restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions)
	// apply.
	// Label names that start with "goog-" or "google-" are reserved.
	Labels map[string]string `protobuf:"bytes,8,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Job status. It is read only for users.
	Status *JobStatus `protobuf:"bytes,9,opt,name=status,proto3" json:"status,omitempty"`
	// Output only. When the Job was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last time the Job was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Log preservation policy for the Job.
	LogsPolicy *LogsPolicy `protobuf:"bytes,13,opt,name=logs_policy,json=logsPolicy,proto3" json:"logs_policy,omitempty"`
	// Notification configurations.
	Notifications []*JobNotification `protobuf:"bytes,14,rep,name=notifications,proto3" json:"notifications,omitempty"`
}

func (x *Job) Reset() {
	*x = Job{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1_job_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Job) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Job) ProtoMessage() {}

func (x *Job) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1_job_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Job.ProtoReflect.Descriptor instead.
func (*Job) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1_job_proto_rawDescGZIP(), []int{0}
}

func (x *Job) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Job) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Job) GetPriority() int64 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *Job) GetTaskGroups() []*TaskGroup {
	if x != nil {
		return x.TaskGroups
	}
	return nil
}

func (x *Job) GetAllocationPolicy() *AllocationPolicy {
	if x != nil {
		return x.AllocationPolicy
	}
	return nil
}

func (x *Job) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Job) GetStatus() *JobStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *Job) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Job) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Job) GetLogsPolicy() *LogsPolicy {
	if x != nil {
		return x.LogsPolicy
	}
	return nil
}

func (x *Job) GetNotifications() []*JobNotification {
	if x != nil {
		return x.Notifications
	}
	return nil
}

// LogsPolicy describes how outputs from a Job's Tasks (stdout/stderr) will be
// preserved.
type LogsPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Where logs should be saved.
	Destination LogsPolicy_Destination `protobuf:"varint,1,opt,name=destination,proto3,enum=google.cloud.batch.v1.LogsPolicy_Destination" json:"destination,omitempty"`
	// The path to which logs are saved when the destination = PATH. This can be a
	// local file path on the VM, or under the mount point of a Persistent Disk or
	// Filestore, or a Cloud Storage path.
	LogsPath string `protobuf:"bytes,2,opt,name=logs_path,json=logsPath,proto3" json:"logs_path,omitempty"`
}

func (x *LogsPolicy) Reset() {
	*x = LogsPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1_job_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LogsPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogsPolicy) ProtoMessage() {}

func (x *LogsPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1_job_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogsPolicy.ProtoReflect.Descriptor instead.
func (*LogsPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1_job_proto_rawDescGZIP(), []int{1}
}

func (x *LogsPolicy) GetDestination() LogsPolicy_Destination {
	if x != nil {
		return x.Destination
	}
	return LogsPolicy_DESTINATION_UNSPECIFIED
}

func (x *LogsPolicy) GetLogsPath() string {
	if x != nil {
		return x.LogsPath
	}
	return ""
}

// Job status.
type JobStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Job state
	State JobStatus_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.batch.v1.JobStatus_State" json:"state,omitempty"`
	// Job status events
	StatusEvents []*StatusEvent `protobuf:"bytes,2,rep,name=status_events,json=statusEvents,proto3" json:"status_events,omitempty"`
	// Aggregated task status for each TaskGroup in the Job.
	// The map key is TaskGroup ID.
	TaskGroups map[string]*JobStatus_TaskGroupStatus `protobuf:"bytes,4,rep,name=task_groups,json=taskGroups,proto3" json:"task_groups,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The duration of time that the Job spent in status RUNNING.
	RunDuration *durationpb.Duration `protobuf:"bytes,5,opt,name=run_duration,json=runDuration,proto3" json:"run_duration,omitempty"`
}

func (x *JobStatus) Reset() {
	*x = JobStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1_job_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobStatus) ProtoMessage() {}

func (x *JobStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1_job_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobStatus.ProtoReflect.Descriptor instead.
func (*JobStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1_job_proto_rawDescGZIP(), []int{2}
}

func (x *JobStatus) GetState() JobStatus_State {
	if x != nil {
		return x.State
	}
	return JobStatus_STATE_UNSPECIFIED
}

func (x *JobStatus) GetStatusEvents() []*StatusEvent {
	if x != nil {
		return x.StatusEvents
	}
	return nil
}

func (x *JobStatus) GetTaskGroups() map[string]*JobStatus_TaskGroupStatus {
	if x != nil {
		return x.TaskGroups
	}
	return nil
}

func (x *JobStatus) GetRunDuration() *durationpb.Duration {
	if x != nil {
		return x.RunDuration
	}
	return nil
}

// Notification configurations.
type JobNotification struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Pub/Sub topic where notifications like the job state changes
	// will be published. The topic must exist in the same project as
	// the job and billings will be charged to this project.
	// If not specified, no Pub/Sub messages will be sent.
	// Topic format: `projects/{project}/topics/{topic}`.
	PubsubTopic string `protobuf:"bytes,1,opt,name=pubsub_topic,json=pubsubTopic,proto3" json:"pubsub_topic,omitempty"`
	// The attribute requirements of messages to be sent to this Pub/Sub topic.
	// Without this field, no message will be sent.
	Message *JobNotification_Message `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *JobNotification) Reset() {
	*x = JobNotification{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1_job_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobNotification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobNotification) ProtoMessage() {}

func (x *JobNotification) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1_job_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobNotification.ProtoReflect.Descriptor instead.
func (*JobNotification) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1_job_proto_rawDescGZIP(), []int{3}
}

func (x *JobNotification) GetPubsubTopic() string {
	if x != nil {
		return x.PubsubTopic
	}
	return ""
}

func (x *JobNotification) GetMessage() *JobNotification_Message {
	if x != nil {
		return x.Message
	}
	return nil
}

// A Job's resource allocation policy describes when, where, and how compute
// resources should be allocated for the Job.
type AllocationPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Location where compute resources should be allocated for the Job.
	Location *AllocationPolicy_LocationPolicy `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// Describe instances that can be created by this AllocationPolicy.
	// Only instances[0] is supported now.
	Instances []*AllocationPolicy_InstancePolicyOrTemplate `protobuf:"bytes,8,rep,name=instances,proto3" json:"instances,omitempty"`
	// Service account that VMs will run as.
	ServiceAccount *ServiceAccount `protobuf:"bytes,9,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Labels applied to all VM instances and other resources
	// created by AllocationPolicy.
	// Labels could be user provided or system generated.
	// You can assign up to 64 labels. [Google Compute Engine label
	// restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions)
	// apply.
	// Label names that start with "goog-" or "google-" are reserved.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The network policy.
	Network *AllocationPolicy_NetworkPolicy `protobuf:"bytes,7,opt,name=network,proto3" json:"network,omitempty"`
	// The placement policy.
	Placement *AllocationPolicy_PlacementPolicy `protobuf:"bytes,10,opt,name=placement,proto3" json:"placement,omitempty"`
}

func (x *AllocationPolicy) Reset() {
	*x = AllocationPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1_job_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationPolicy) ProtoMessage() {}

func (x *AllocationPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1_job_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationPolicy.ProtoReflect.Descriptor instead.
func (*AllocationPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1_job_proto_rawDescGZIP(), []int{4}
}

func (x *AllocationPolicy) GetLocation() *AllocationPolicy_LocationPolicy {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *AllocationPolicy) GetInstances() []*AllocationPolicy_InstancePolicyOrTemplate {
	if x != nil {
		return x.Instances
	}
	return nil
}

func (x *AllocationPolicy) GetServiceAccount() *ServiceAccount {
	if x != nil {
		return x.ServiceAccount
	}
	return nil
}

func (x *AllocationPolicy) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *AllocationPolicy) GetNetwork() *AllocationPolicy_NetworkPolicy {
	if x != nil {
		return x.Network
	}
	return nil
}

func (x *AllocationPolicy) GetPlacement() *AllocationPolicy_PlacementPolicy {
	if x != nil {
		return x.Placement
	}
	return nil
}

// A TaskGroup defines one or more Tasks that all share the same TaskSpec.
type TaskGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. TaskGroup name.
	// The system generates this field based on parent Job name.
	// For example:
	// "projects/123456/locations/us-west1/jobs/job01/taskGroups/group01".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Tasks in the group share the same task spec.
	TaskSpec *TaskSpec `protobuf:"bytes,3,opt,name=task_spec,json=taskSpec,proto3" json:"task_spec,omitempty"`
	// Number of Tasks in the TaskGroup.
	// Default is 1.
	TaskCount int64 `protobuf:"varint,4,opt,name=task_count,json=taskCount,proto3" json:"task_count,omitempty"`
	// Max number of tasks that can run in parallel.
	// Default to min(task_count, parallel tasks per job limit).
	// See: [Job Limits](https://cloud.google.com/batch/quotas#job_limits).
	// Field parallelism must be 1 if the scheduling_policy is IN_ORDER.
	Parallelism int64 `protobuf:"varint,5,opt,name=parallelism,proto3" json:"parallelism,omitempty"`
	// Scheduling policy for Tasks in the TaskGroup.
	// The default value is AS_SOON_AS_POSSIBLE.
	SchedulingPolicy TaskGroup_SchedulingPolicy `protobuf:"varint,6,opt,name=scheduling_policy,json=schedulingPolicy,proto3,enum=google.cloud.batch.v1.TaskGroup_SchedulingPolicy" json:"scheduling_policy,omitempty"`
	// An array of environment variable mappings, which are passed to Tasks with
	// matching indices. If task_environments is used then task_count should
	// not be specified in the request (and will be ignored). Task count will be
	// the length of task_environments.
	//
	// Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
	// addition to any environment variables set in task_environments, specifying
	// the number of Tasks in the Task's parent TaskGroup, and the specific Task's
	// index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
	TaskEnvironments []*Environment `protobuf:"bytes,9,rep,name=task_environments,json=taskEnvironments,proto3" json:"task_environments,omitempty"`
	// Max number of tasks that can be run on a VM at the same time.
	// If not specified, the system will decide a value based on available
	// compute resources on a VM and task requirements.
	TaskCountPerNode int64 `protobuf:"varint,10,opt,name=task_count_per_node,json=taskCountPerNode,proto3" json:"task_count_per_node,omitempty"`
	// When true, Batch will populate a file with a list of all VMs assigned to
	// the TaskGroup and set the BATCH_HOSTS_FILE environment variable to the path
	// of that file. Defaults to false.
	RequireHostsFile bool `protobuf:"varint,11,opt,name=require_hosts_file,json=requireHostsFile,proto3" json:"require_hosts_file,omitempty"`
	// When true, Batch will configure SSH to allow passwordless login between
	// VMs running the Batch tasks in the same TaskGroup.
	PermissiveSsh bool `protobuf:"varint,12,opt,name=permissive_ssh,json=permissiveSsh,proto3" json:"permissive_ssh,omitempty"`
}

func (x *TaskGroup) Reset() {
	*x = TaskGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1_job_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TaskGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TaskGroup) ProtoMessage() {}

func (x *TaskGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1_job_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TaskGroup.ProtoReflect.Descriptor instead.
func (*TaskGroup) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1_job_proto_rawDescGZIP(), []int{5}
}

func (x *TaskGroup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TaskGroup) GetTaskSpec() *TaskSpec {
	if x != nil {
		return x.TaskSpec
	}
	return nil
}

func (x *TaskGroup) GetTaskCount() int64 {
	if x != nil {
		return x.TaskCount
	}
	return 0
}

func (x *TaskGroup) GetParallelism() int64 {
	if x != nil {
		return x.Parallelism
	}
	return 0
}

func (x *TaskGroup) GetSchedulingPolicy() TaskGroup_SchedulingPolicy {
	if x != nil {
		return x.SchedulingPolicy
	}
	return TaskGroup_SCHEDULING_POLICY_UNSPECIFIED
}

func (x *TaskGroup) GetTaskEnvironments() []*Environment {
	if x != nil {
		return x.TaskEnvironments
	}
	return nil
}

func (x *TaskGroup) GetTaskCountPerNode() int64 {
	if x != nil {
		return x.TaskCountPerNode
	}
	return 0
}

func (x *TaskGroup) GetRequireHostsFile() bool {
	if x != nil {
		return x.RequireHostsFile
	}
	return false
}

func (x *TaskGroup) GetPermissiveSsh() bool {
	if x != nil {
		return x.PermissiveSsh
	}
	return false
}

// Carries information about a Google Cloud service account.
type ServiceAccount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Email address of the service account. If not specified, the default
	// Compute Engine service account for the project will be used. If instance
	// template is being used, the service account has to be specified in the
	// instance template and it has to match the email field here.
	Email string `protobuf:"bytes,1,opt,name=email,proto3" json:"email,omitempty"`
	// List of scopes to be enabled for this service account on the VM, in
	// addition to the cloud-platform API scope that will be added by default.
	Scopes []string `protobuf:"bytes,2,rep,name=scopes,proto3" json:"scopes,omitempty"`
}

func (x *ServiceAccount) Reset() {
	*x = ServiceAccount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1_job_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceAccount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceAccount) ProtoMessage() {}

func (x *ServiceAccount) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1_job_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceAccount.ProtoReflect.Descriptor instead.
func (*ServiceAccount) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1_job_proto_rawDescGZIP(), []int{6}
}

func (x *ServiceAccount) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

func (x *ServiceAccount) GetScopes() []string {
	if x != nil {
		return x.Scopes
	}
	return nil
}

// VM instance status.
type JobStatus_InstanceStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Compute Engine machine type.
	MachineType string `protobuf:"bytes,1,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// The VM instance provisioning model.
	ProvisioningModel AllocationPolicy_ProvisioningModel `protobuf:"varint,2,opt,name=provisioning_model,json=provisioningModel,proto3,enum=google.cloud.batch.v1.AllocationPolicy_ProvisioningModel" json:"provisioning_model,omitempty"`
	// The max number of tasks can be assigned to this instance type.
	TaskPack int64 `protobuf:"varint,3,opt,name=task_pack,json=taskPack,proto3" json:"task_pack,omitempty"`
	// The VM boot disk.
	BootDisk *AllocationPolicy_Disk `protobuf:"bytes,4,opt,name=boot_disk,json=bootDisk,proto3" json:"boot_disk,omitempty"`
}

func (x *JobStatus_InstanceStatus) Reset() {
	*x = JobStatus_InstanceStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1_job_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobStatus_InstanceStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobStatus_InstanceStatus) ProtoMessage() {}

func (x *JobStatus_InstanceStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1_job_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobStatus_InstanceStatus.ProtoReflect.Descriptor instead.
func (*JobStatus_InstanceStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1_job_proto_rawDescGZIP(), []int{2, 0}
}

func (x *JobStatus_InstanceStatus) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *JobStatus_InstanceStatus) GetProvisioningModel() AllocationPolicy_ProvisioningModel {
	if x != nil {
		return x.ProvisioningModel
	}
	return AllocationPolicy_PROVISIONING_MODEL_UNSPECIFIED
}

func (x *JobStatus_InstanceStatus) GetTaskPack() int64 {
	if x != nil {
		return x.TaskPack
	}
	return 0
}

func (x *JobStatus_InstanceStatus) GetBootDisk() *AllocationPolicy_Disk {
	if x != nil {
		return x.BootDisk
	}
	return nil
}

// Aggregated task status for a TaskGroup.
type JobStatus_TaskGroupStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Count of task in each state in the TaskGroup.
	// The map key is task state name.
	Counts map[string]int64 `protobuf:"bytes,1,rep,name=counts,proto3" json:"counts,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// Status of instances allocated for the TaskGroup.
	Instances []*JobStatus_InstanceStatus `protobuf:"bytes,2,rep,name=instances,proto3" json:"instances,omitempty"`
}

func (x *JobStatus_TaskGroupStatus) Reset() {
	*x = JobStatus_TaskGroupStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1_job_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobStatus_TaskGroupStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobStatus_TaskGroupStatus) ProtoMessage() {}

func (x *JobStatus_TaskGroupStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1_job_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobStatus_TaskGroupStatus.ProtoReflect.Descriptor instead.
func (*JobStatus_TaskGroupStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1_job_proto_rawDescGZIP(), []int{2, 1}
}

func (x *JobStatus_TaskGroupStatus) GetCounts() map[string]int64 {
	if x != nil {
		return x.Counts
	}
	return nil
}

func (x *JobStatus_TaskGroupStatus) GetInstances() []*JobStatus_InstanceStatus {
	if x != nil {
		return x.Instances
	}
	return nil
}

// Message details.
// Describe the conditions under which messages will be sent.
// If no attribute is defined, no message will be sent by default.
// One message should specify either the job or the task level attributes,
// but not both. For example,
// job level: JOB_STATE_CHANGED and/or a specified new_job_state;
// task level: TASK_STATE_CHANGED and/or a specified new_task_state.
type JobNotification_Message struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The message type.
	Type JobNotification_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.batch.v1.JobNotification_Type" json:"type,omitempty"`
	// The new job state.
	NewJobState JobStatus_State `protobuf:"varint,2,opt,name=new_job_state,json=newJobState,proto3,enum=google.cloud.batch.v1.JobStatus_State" json:"new_job_state,omitempty"`
	// The new task state.
	NewTaskState TaskStatus_State `protobuf:"varint,3,opt,name=new_task_state,json=newTaskState,proto3,enum=google.cloud.batch.v1.TaskStatus_State" json:"new_task_state,omitempty"`
}

func (x *JobNotification_Message) Reset() {
	*x = JobNotification_Message{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1_job_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobNotification_Message) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobNotification_Message) ProtoMessage() {}

func (x *JobNotification_Message) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1_job_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobNotification_Message.ProtoReflect.Descriptor instead.
func (*JobNotification_Message) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1_job_proto_rawDescGZIP(), []int{3, 0}
}

func (x *JobNotification_Message) GetType() JobNotification_Type {
	if x != nil {
		return x.Type
	}
	return JobNotification_TYPE_UNSPECIFIED
}

func (x *JobNotification_Message) GetNewJobState() JobStatus_State {
	if x != nil {
		return x.NewJobState
	}
	return JobStatus_STATE_UNSPECIFIED
}

func (x *JobNotification_Message) GetNewTaskState() TaskStatus_State {
	if x != nil {
		return x.NewTaskState
	}
	return TaskStatus_STATE_UNSPECIFIED
}

type AllocationPolicy_LocationPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of allowed location names represented by internal URLs.
	//
	// Each location can be a region or a zone.
	// Only one region or multiple zones in one region is supported now.
	// For example,
	// ["regions/us-central1"] allow VMs in any zones in region us-central1.
	// ["zones/us-central1-a", "zones/us-central1-c"] only allow VMs
	// in zones us-central1-a and us-central1-c.
	//
	// All locations end up in different regions would cause errors.
	// For example,
	// ["regions/us-central1", "zones/us-central1-a", "zones/us-central1-b",
	// "zones/us-west1-a"] contains 2 regions "us-central1" and
	// "us-west1". An error is expected in this case.
	AllowedLocations []string `protobuf:"bytes,1,rep,name=allowed_locations,json=allowedLocations,proto3" json:"allowed_locations,omitempty"`
}

func (x *AllocationPolicy_LocationPolicy) Reset() {
	*x = AllocationPolicy_LocationPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1_job_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationPolicy_LocationPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationPolicy_LocationPolicy) ProtoMessage() {}

func (x *AllocationPolicy_LocationPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1_job_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationPolicy_LocationPolicy.ProtoReflect.Descriptor instead.
func (*AllocationPolicy_LocationPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1_job_proto_rawDescGZIP(), []int{4, 0}
}

func (x *AllocationPolicy_LocationPolicy) GetAllowedLocations() []string {
	if x != nil {
		return x.AllowedLocations
	}
	return nil
}

// A new persistent disk or a local ssd.
// A VM can only have one local SSD setting but multiple local SSD partitions.
// See https://cloud.google.com/compute/docs/disks#pdspecs and
// https://cloud.google.com/compute/docs/disks#localssds.
type AllocationPolicy_Disk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A data source from which a PD will be created.
	//
	// Types that are assignable to DataSource:
	//	*AllocationPolicy_Disk_Image
	//	*AllocationPolicy_Disk_Snapshot
	DataSource isAllocationPolicy_Disk_DataSource `protobuf_oneof:"data_source"`
	// Disk type as shown in `gcloud compute disk-types list`.
	// For example, local SSD uses type "local-ssd".
	// Persistent disks and boot disks use "pd-balanced", "pd-extreme", "pd-ssd"
	// or "pd-standard".
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Disk size in GB.
	//
	// **Non-Boot Disk**:
	// If the `type` specifies a persistent disk, this field
	// is ignored if `data_source` is set as `image` or `snapshot`.
	// If the `type` specifies a local SSD, this field should be a multiple of
	// 375 GB, otherwise, the final size will be the next greater multiple of
	// 375 GB.
	//
	// **Boot Disk**:
	// Batch will calculate the boot disk size based on source
	// image and task requirements if you do not speicify the size.
	// If both this field and the `boot_disk_mib` field in task spec's
	// `compute_resource` are defined, Batch will only honor this field.
	// Also, this field should be no smaller than the source disk's
	// size when the `data_source` is set as `snapshot` or `image`.
	// For example, if you set an image as the `data_source` field and the
	// image's default disk size 30 GB, you can only use this field to make the
	// disk larger or equal to 30 GB.
	SizeGb int64 `protobuf:"varint,2,opt,name=size_gb,json=sizeGb,proto3" json:"size_gb,omitempty"`
	// Local SSDs are available through both "SCSI" and "NVMe" interfaces.
	// If not indicated, "NVMe" will be the default one for local ssds.
	// This field is ignored for persistent disks as the interface is chosen
	// automatically. See
	// https://cloud.google.com/compute/docs/disks/persistent-disks#choose_an_interface.
	DiskInterface string `protobuf:"bytes,6,opt,name=disk_interface,json=diskInterface,proto3" json:"disk_interface,omitempty"`
}

func (x *AllocationPolicy_Disk) Reset() {
	*x = AllocationPolicy_Disk{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1_job_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationPolicy_Disk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationPolicy_Disk) ProtoMessage() {}

func (x *AllocationPolicy_Disk) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1_job_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationPolicy_Disk.ProtoReflect.Descriptor instead.
func (*AllocationPolicy_Disk) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1_job_proto_rawDescGZIP(), []int{4, 1}
}

func (m *AllocationPolicy_Disk) GetDataSource() isAllocationPolicy_Disk_DataSource {
	if m != nil {
		return m.DataSource
	}
	return nil
}

func (x *AllocationPolicy_Disk) GetImage() string {
	if x, ok := x.GetDataSource().(*AllocationPolicy_Disk_Image); ok {
		return x.Image
	}
	return ""
}

func (x *AllocationPolicy_Disk) GetSnapshot() string {
	if x, ok := x.GetDataSource().(*AllocationPolicy_Disk_Snapshot); ok {
		return x.Snapshot
	}
	return ""
}

func (x *AllocationPolicy_Disk) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *AllocationPolicy_Disk) GetSizeGb() int64 {
	if x != nil {
		return x.SizeGb
	}
	return 0
}

func (x *AllocationPolicy_Disk) GetDiskInterface() string {
	if x != nil {
		return x.DiskInterface
	}
	return ""
}

type isAllocationPolicy_Disk_DataSource interface {
	isAllocationPolicy_Disk_DataSource()
}

type AllocationPolicy_Disk_Image struct {
	// URL for a VM image to use as the data source for this disk.
	// For example, the following are all valid URLs:
	//
	// * Specify the image by its family name:
	// projects/{project}/global/images/family/{image_family}
	// * Specify the image version:
	// projects/{project}/global/images/{image_version}
	//
	// You can also use Batch customized image in short names.
	// The following image values are supported for a boot disk:
	//
	// * `batch-debian`: use Batch Debian images.
	// * `batch-centos`: use Batch CentOS images.
	// * `batch-cos`: use Batch Container-Optimized images.
	// * `batch-hpc-centos`: use Batch HPC CentOS images.
	// * `batch-hpc-rocky`: use Batch HPC Rocky Linux images.
	Image string `protobuf:"bytes,4,opt,name=image,proto3,oneof"`
}

type AllocationPolicy_Disk_Snapshot struct {
	// Name of a snapshot used as the data source.
	// Snapshot is not supported as boot disk now.
	Snapshot string `protobuf:"bytes,5,opt,name=snapshot,proto3,oneof"`
}

func (*AllocationPolicy_Disk_Image) isAllocationPolicy_Disk_DataSource() {}

func (*AllocationPolicy_Disk_Snapshot) isAllocationPolicy_Disk_DataSource() {}

// A new or an existing persistent disk (PD) or a local ssd attached to a VM
// instance.
type AllocationPolicy_AttachedDisk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Attached:
	//	*AllocationPolicy_AttachedDisk_NewDisk
	//	*AllocationPolicy_AttachedDisk_ExistingDisk
	Attached isAllocationPolicy_AttachedDisk_Attached `protobuf_oneof:"attached"`
	// Device name that the guest operating system will see.
	// It is used by Runnable.volumes field to mount disks. So please specify
	// the device_name if you want Batch to help mount the disk, and it should
	// match the device_name field in volumes.
	DeviceName string `protobuf:"bytes,3,opt,name=device_name,json=deviceName,proto3" json:"device_name,omitempty"`
}

func (x *AllocationPolicy_AttachedDisk) Reset() {
	*x = AllocationPolicy_AttachedDisk{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1_job_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationPolicy_AttachedDisk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationPolicy_AttachedDisk) ProtoMessage() {}

func (x *AllocationPolicy_AttachedDisk) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1_job_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationPolicy_AttachedDisk.ProtoReflect.Descriptor instead.
func (*AllocationPolicy_AttachedDisk) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1_job_proto_rawDescGZIP(), []int{4, 2}
}

func (m *AllocationPolicy_AttachedDisk) GetAttached() isAllocationPolicy_AttachedDisk_Attached {
	if m != nil {
		return m.Attached
	}
	return nil
}

func (x *AllocationPolicy_AttachedDisk) GetNewDisk() *AllocationPolicy_Disk {
	if x, ok := x.GetAttached().(*AllocationPolicy_AttachedDisk_NewDisk); ok {
		return x.NewDisk
	}
	return nil
}

func (x *AllocationPolicy_AttachedDisk) GetExistingDisk() string {
	if x, ok := x.GetAttached().(*AllocationPolicy_AttachedDisk_ExistingDisk); ok {
		return x.ExistingDisk
	}
	return ""
}

func (x *AllocationPolicy_AttachedDisk) GetDeviceName() string {
	if x != nil {
		return x.DeviceName
	}
	return ""
}

type isAllocationPolicy_AttachedDisk_Attached interface {
	isAllocationPolicy_AttachedDisk_Attached()
}

type AllocationPolicy_AttachedDisk_NewDisk struct {
	NewDisk *AllocationPolicy_Disk `protobuf:"bytes,1,opt,name=new_disk,json=newDisk,proto3,oneof"`
}

type AllocationPolicy_AttachedDisk_ExistingDisk struct {
	// Name of an existing PD.
	ExistingDisk string `protobuf:"bytes,2,opt,name=existing_disk,json=existingDisk,proto3,oneof"`
}

func (*AllocationPolicy_AttachedDisk_NewDisk) isAllocationPolicy_AttachedDisk_Attached() {}

func (*AllocationPolicy_AttachedDisk_ExistingDisk) isAllocationPolicy_AttachedDisk_Attached() {}

// Accelerator describes Compute Engine accelerators to be attached to the VM.
type AllocationPolicy_Accelerator struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The accelerator type. For example, "nvidia-tesla-t4".
	// See `gcloud compute accelerator-types list`.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// The number of accelerators of this type.
	Count int64 `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
	// Deprecated: please use instances[0].install_gpu_drivers instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/batch/v1/job.proto.
	InstallGpuDrivers bool `protobuf:"varint,3,opt,name=install_gpu_drivers,json=installGpuDrivers,proto3" json:"install_gpu_drivers,omitempty"`
	// Optional. The NVIDIA GPU driver version that should be installed for this
	// type.
	//
	// You can define the specific driver version such as "470.103.01",
	// following the driver version requirements in
	// https://cloud.google.com/compute/docs/gpus/install-drivers-gpu#minimum-driver.
	// Batch will install the specific accelerator driver if qualified.
	DriverVersion string `protobuf:"bytes,4,opt,name=driver_version,json=driverVersion,proto3" json:"driver_version,omitempty"`
}

func (x *AllocationPolicy_Accelerator) Reset() {
	*x = AllocationPolicy_Accelerator{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1_job_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationPolicy_Accelerator) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationPolicy_Accelerator) ProtoMessage() {}

func (x *AllocationPolicy_Accelerator) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1_job_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationPolicy_Accelerator.ProtoReflect.Descriptor instead.
func (*AllocationPolicy_Accelerator) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1_job_proto_rawDescGZIP(), []int{4, 3}
}

func (x *AllocationPolicy_Accelerator) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *AllocationPolicy_Accelerator) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

// Deprecated: Marked as deprecated in google/cloud/batch/v1/job.proto.
func (x *AllocationPolicy_Accelerator) GetInstallGpuDrivers() bool {
	if x != nil {
		return x.InstallGpuDrivers
	}
	return false
}

func (x *AllocationPolicy_Accelerator) GetDriverVersion() string {
	if x != nil {
		return x.DriverVersion
	}
	return ""
}

// InstancePolicy describes an instance type and resources attached to each VM
// created by this InstancePolicy.
type AllocationPolicy_InstancePolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Compute Engine machine type.
	MachineType string `protobuf:"bytes,2,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// The minimum CPU platform.
	// See
	// https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
	MinCpuPlatform string `protobuf:"bytes,3,opt,name=min_cpu_platform,json=minCpuPlatform,proto3" json:"min_cpu_platform,omitempty"`
	// The provisioning model.
	ProvisioningModel AllocationPolicy_ProvisioningModel `protobuf:"varint,4,opt,name=provisioning_model,json=provisioningModel,proto3,enum=google.cloud.batch.v1.AllocationPolicy_ProvisioningModel" json:"provisioning_model,omitempty"`
	// The accelerators attached to each VM instance.
	Accelerators []*AllocationPolicy_Accelerator `protobuf:"bytes,5,rep,name=accelerators,proto3" json:"accelerators,omitempty"`
	// Boot disk to be created and attached to each VM by this InstancePolicy.
	// Boot disk will be deleted when the VM is deleted.
	// Batch API now only supports booting from image.
	BootDisk *AllocationPolicy_Disk `protobuf:"bytes,8,opt,name=boot_disk,json=bootDisk,proto3" json:"boot_disk,omitempty"`
	// Non-boot disks to be attached for each VM created by this InstancePolicy.
	// New disks will be deleted when the VM is deleted.
	// A non-boot disk is a disk that can be of a device with a
	// file system or a raw storage drive that is not ready for data
	// storage and accessing.
	Disks []*AllocationPolicy_AttachedDisk `protobuf:"bytes,6,rep,name=disks,proto3" json:"disks,omitempty"`
	// Optional. If specified, VMs will consume only the specified reservation.
	// If not specified (default), VMs will consume any applicable reservation.
	Reservation string `protobuf:"bytes,7,opt,name=reservation,proto3" json:"reservation,omitempty"`
}

func (x *AllocationPolicy_InstancePolicy) Reset() {
	*x = AllocationPolicy_InstancePolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1_job_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationPolicy_InstancePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationPolicy_InstancePolicy) ProtoMessage() {}

func (x *AllocationPolicy_InstancePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1_job_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationPolicy_InstancePolicy.ProtoReflect.Descriptor instead.
func (*AllocationPolicy_InstancePolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1_job_proto_rawDescGZIP(), []int{4, 4}
}

func (x *AllocationPolicy_InstancePolicy) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *AllocationPolicy_InstancePolicy) GetMinCpuPlatform() string {
	if x != nil {
		return x.MinCpuPlatform
	}
	return ""
}

func (x *AllocationPolicy_InstancePolicy) GetProvisioningModel() AllocationPolicy_ProvisioningModel {
	if x != nil {
		return x.ProvisioningModel
	}
	return AllocationPolicy_PROVISIONING_MODEL_UNSPECIFIED
}

func (x *AllocationPolicy_InstancePolicy) GetAccelerators() []*AllocationPolicy_Accelerator {
	if x != nil {
		return x.Accelerators
	}
	return nil
}

func (x *AllocationPolicy_InstancePolicy) GetBootDisk() *AllocationPolicy_Disk {
	if x != nil {
		return x.BootDisk
	}
	return nil
}

func (x *AllocationPolicy_InstancePolicy) GetDisks() []*AllocationPolicy_AttachedDisk {
	if x != nil {
		return x.Disks
	}
	return nil
}

func (x *AllocationPolicy_InstancePolicy) GetReservation() string {
	if x != nil {
		return x.Reservation
	}
	return ""
}

// InstancePolicyOrTemplate lets you define the type of resources to use for
// this job either with an InstancePolicy or an instance template.
// If undefined, Batch picks the type of VM to use and doesn't include
// optional VM resources such as GPUs and extra disks.
type AllocationPolicy_InstancePolicyOrTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to PolicyTemplate:
	//	*AllocationPolicy_InstancePolicyOrTemplate_Policy
	//	*AllocationPolicy_InstancePolicyOrTemplate_InstanceTemplate
	PolicyTemplate isAllocationPolicy_InstancePolicyOrTemplate_PolicyTemplate `protobuf_oneof:"policy_template"`
	// Set this field true if users want Batch to help fetch drivers from a
	// third party location and install them for GPUs specified in
	// policy.accelerators or instance_template on their behalf. Default is
	// false.
	//
	// For Container-Optimized Image cases, Batch will install the
	// accelerator driver following milestones of
	// https://cloud.google.com/container-optimized-os/docs/release-notes. For
	// non Container-Optimized Image cases, following
	// https://github.com/GoogleCloudPlatform/compute-gpu-installation/blob/main/linux/install_gpu_driver.py.
	InstallGpuDrivers bool `protobuf:"varint,3,opt,name=install_gpu_drivers,json=installGpuDrivers,proto3" json:"install_gpu_drivers,omitempty"`
}

func (x *AllocationPolicy_InstancePolicyOrTemplate) Reset() {
	*x = AllocationPolicy_InstancePolicyOrTemplate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1_job_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationPolicy_InstancePolicyOrTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationPolicy_InstancePolicyOrTemplate) ProtoMessage() {}

func (x *AllocationPolicy_InstancePolicyOrTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1_job_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationPolicy_InstancePolicyOrTemplate.ProtoReflect.Descriptor instead.
func (*AllocationPolicy_InstancePolicyOrTemplate) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1_job_proto_rawDescGZIP(), []int{4, 5}
}

func (m *AllocationPolicy_InstancePolicyOrTemplate) GetPolicyTemplate() isAllocationPolicy_InstancePolicyOrTemplate_PolicyTemplate {
	if m != nil {
		return m.PolicyTemplate
	}
	return nil
}

func (x *AllocationPolicy_InstancePolicyOrTemplate) GetPolicy() *AllocationPolicy_InstancePolicy {
	if x, ok := x.GetPolicyTemplate().(*AllocationPolicy_InstancePolicyOrTemplate_Policy); ok {
		return x.Policy
	}
	return nil
}

func (x *AllocationPolicy_InstancePolicyOrTemplate) GetInstanceTemplate() string {
	if x, ok := x.GetPolicyTemplate().(*AllocationPolicy_InstancePolicyOrTemplate_InstanceTemplate); ok {
		return x.InstanceTemplate
	}
	return ""
}

func (x *AllocationPolicy_InstancePolicyOrTemplate) GetInstallGpuDrivers() bool {
	if x != nil {
		return x.InstallGpuDrivers
	}
	return false
}

type isAllocationPolicy_InstancePolicyOrTemplate_PolicyTemplate interface {
	isAllocationPolicy_InstancePolicyOrTemplate_PolicyTemplate()
}

type AllocationPolicy_InstancePolicyOrTemplate_Policy struct {
	// InstancePolicy.
	Policy *AllocationPolicy_InstancePolicy `protobuf:"bytes,1,opt,name=policy,proto3,oneof"`
}

type AllocationPolicy_InstancePolicyOrTemplate_InstanceTemplate struct {
	// Name of an instance template used to create VMs.
	// Named the field as 'instance_template' instead of 'template' to avoid
	// c++ keyword conflict.
	InstanceTemplate string `protobuf:"bytes,2,opt,name=instance_template,json=instanceTemplate,proto3,oneof"`
}

func (*AllocationPolicy_InstancePolicyOrTemplate_Policy) isAllocationPolicy_InstancePolicyOrTemplate_PolicyTemplate() {
}

func (*AllocationPolicy_InstancePolicyOrTemplate_InstanceTemplate) isAllocationPolicy_InstancePolicyOrTemplate_PolicyTemplate() {
}

// A network interface.
type AllocationPolicy_NetworkInterface struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URL of an existing network resource.
	// You can specify the network as a full or partial URL.
	//
	// For example, the following are all valid URLs:
	//
	// * https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
	// * projects/{project}/global/networks/{network}
	// * global/networks/{network}
	Network string `protobuf:"bytes,1,opt,name=network,proto3" json:"network,omitempty"`
	// The URL of an existing subnetwork resource in the network.
	// You can specify the subnetwork as a full or partial URL.
	//
	// For example, the following are all valid URLs:
	//
	// * https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetwork}
	// * projects/{project}/regions/{region}/subnetworks/{subnetwork}
	// * regions/{region}/subnetworks/{subnetwork}
	Subnetwork string `protobuf:"bytes,2,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
	// Default is false (with an external IP address). Required if
	// no external public IP address is attached to the VM. If no external
	// public IP address, additional configuration is required to allow the VM
	// to access Google Services. See
	// https://cloud.google.com/vpc/docs/configure-private-google-access and
	// https://cloud.google.com/nat/docs/gce-example#create-nat for more
	// information.
	NoExternalIpAddress bool `protobuf:"varint,3,opt,name=no_external_ip_address,json=noExternalIpAddress,proto3" json:"no_external_ip_address,omitempty"`
}

func (x *AllocationPolicy_NetworkInterface) Reset() {
	*x = AllocationPolicy_NetworkInterface{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1_job_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationPolicy_NetworkInterface) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationPolicy_NetworkInterface) ProtoMessage() {}

func (x *AllocationPolicy_NetworkInterface) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1_job_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationPolicy_NetworkInterface.ProtoReflect.Descriptor instead.
func (*AllocationPolicy_NetworkInterface) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1_job_proto_rawDescGZIP(), []int{4, 6}
}

func (x *AllocationPolicy_NetworkInterface) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *AllocationPolicy_NetworkInterface) GetSubnetwork() string {
	if x != nil {
		return x.Subnetwork
	}
	return ""
}

func (x *AllocationPolicy_NetworkInterface) GetNoExternalIpAddress() bool {
	if x != nil {
		return x.NoExternalIpAddress
	}
	return false
}

// NetworkPolicy describes VM instance network configurations.
type AllocationPolicy_NetworkPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Network configurations.
	NetworkInterfaces []*AllocationPolicy_NetworkInterface `protobuf:"bytes,1,rep,name=network_interfaces,json=networkInterfaces,proto3" json:"network_interfaces,omitempty"`
}

func (x *AllocationPolicy_NetworkPolicy) Reset() {
	*x = AllocationPolicy_NetworkPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1_job_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationPolicy_NetworkPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationPolicy_NetworkPolicy) ProtoMessage() {}

func (x *AllocationPolicy_NetworkPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1_job_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationPolicy_NetworkPolicy.ProtoReflect.Descriptor instead.
func (*AllocationPolicy_NetworkPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1_job_proto_rawDescGZIP(), []int{4, 7}
}

func (x *AllocationPolicy_NetworkPolicy) GetNetworkInterfaces() []*AllocationPolicy_NetworkInterface {
	if x != nil {
		return x.NetworkInterfaces
	}
	return nil
}

// PlacementPolicy describes a group placement policy for the VMs controlled
// by this AllocationPolicy.
type AllocationPolicy_PlacementPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// UNSPECIFIED vs. COLLOCATED (default UNSPECIFIED). Use COLLOCATED when you
	// want VMs to be located close to each other for low network latency
	// between the VMs. No placement policy will be generated when collocation
	// is UNSPECIFIED.
	Collocation string `protobuf:"bytes,1,opt,name=collocation,proto3" json:"collocation,omitempty"`
	// When specified, causes the job to fail if more than max_distance logical
	// switches are required between VMs. Batch uses the most compact possible
	// placement of VMs even when max_distance is not specified. An explicit
	// max_distance makes that level of compactness a strict requirement.
	// Not yet implemented
	MaxDistance int64 `protobuf:"varint,2,opt,name=max_distance,json=maxDistance,proto3" json:"max_distance,omitempty"`
}

func (x *AllocationPolicy_PlacementPolicy) Reset() {
	*x = AllocationPolicy_PlacementPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1_job_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationPolicy_PlacementPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationPolicy_PlacementPolicy) ProtoMessage() {}

func (x *AllocationPolicy_PlacementPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1_job_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationPolicy_PlacementPolicy.ProtoReflect.Descriptor instead.
func (*AllocationPolicy_PlacementPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1_job_proto_rawDescGZIP(), []int{4, 8}
}

func (x *AllocationPolicy_PlacementPolicy) GetCollocation() string {
	if x != nil {
		return x.Collocation
	}
	return ""
}

func (x *AllocationPolicy_PlacementPolicy) GetMaxDistance() int64 {
	if x != nil {
		return x.MaxDistance
	}
	return 0
}

var File_google_cloud_batch_v1_job_proto protoreflect.FileDescriptor

var file_google_cloud_batch_v1_job_proto_rawDesc = []byte{
	0x0a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x6a, 0x6f, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x61, 0x73, 0x6b,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x92, 0x06, 0x0a, 0x03, 0x4a, 0x6f, 0x62, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12,
	0x1a, 0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x46, 0x0a, 0x0b, 0x74,
	0x61, 0x73, 0x6b, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x74, 0x61, 0x73, 0x6b, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x12, 0x54, 0x0a, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61,
	0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x10, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x3e, 0x0a, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76,
	0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x3d, 0x0a, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76,
	0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x0b,
	0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x73, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x52, 0x0a, 0x6c, 0x6f, 0x67, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x4c, 0x0a, 0x0d, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e,
	0x4a, 0x6f, 0x62, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0d, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x39,
	0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x51, 0xea, 0x41, 0x4e, 0x0a, 0x18,
	0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x12, 0x32, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x6a, 0x6f, 0x62, 0x7d, 0x22, 0xc3, 0x01, 0x0a,
	0x0a, 0x4c, 0x6f, 0x67, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x4f, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x73, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x09,
	0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x6c, 0x6f, 0x67, 0x73, 0x50, 0x61, 0x74, 0x68, 0x22, 0x47, 0x0a, 0x0b, 0x44, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x17, 0x44, 0x45, 0x53, 0x54,
	0x49, 0x4e, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x4c,
	0x4f, 0x47, 0x47, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x50, 0x41, 0x54, 0x48,
	0x10, 0x02, 0x22, 0x8d, 0x08, 0x0a, 0x09, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x3c, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x47,
	0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x51, 0x0a, 0x0b, 0x74, 0x61, 0x73, 0x6b, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63,
	0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x54,
	0x61, 0x73, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a,
	0x74, 0x61, 0x73, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x3c, 0x0a, 0x0c, 0x72, 0x75,
	0x6e, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x72, 0x75, 0x6e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x85, 0x02, 0x0a, 0x0e, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x6d,
	0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x68,
	0x0a, 0x12, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x11, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x61, 0x73, 0x6b,
	0x5f, 0x70, 0x61, 0x63, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x74, 0x61, 0x73,
	0x6b, 0x50, 0x61, 0x63, 0x6b, 0x12, 0x49, 0x0a, 0x09, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69,
	0x73, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x52, 0x08, 0x62, 0x6f, 0x6f, 0x74, 0x44, 0x69, 0x73, 0x6b,
	0x1a, 0xf1, 0x01, 0x0a, 0x0f, 0x54, 0x61, 0x73, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x54, 0x0a, 0x06, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x06, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x4d, 0x0a, 0x09, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x09,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x1a, 0x6f, 0x0a, 0x0f, 0x54, 0x61, 0x73, 0x6b, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x46, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31,
	0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x7b, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15,
	0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x51, 0x55, 0x45, 0x55, 0x45, 0x44, 0x10,
	0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x44, 0x10, 0x02,
	0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0d, 0x0a,
	0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06,
	0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12, 0x18, 0x0a, 0x14, 0x44, 0x45, 0x4c, 0x45,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53,
	0x10, 0x06, 0x22, 0xb3, 0x03, 0x0a, 0x0f, 0x4a, 0x6f, 0x62, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62,
	0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x75,
	0x62, 0x73, 0x75, 0x62, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x48, 0x0a, 0x07, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x1a, 0xe5, 0x01, 0x0a, 0x07, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12,
	0x3f, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x12, 0x4a, 0x0a, 0x0d, 0x6e, 0x65, 0x77, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e,
	0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52,
	0x0b, 0x6e, 0x65, 0x77, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4d, 0x0a, 0x0e,
	0x6e, 0x65, 0x77, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73,
	0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0c, 0x6e,
	0x65, 0x77, 0x54, 0x61, 0x73, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22, 0x4b, 0x0a, 0x04, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x4a, 0x4f, 0x42,
	0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x44, 0x10, 0x01,
	0x12, 0x16, 0x0a, 0x12, 0x54, 0x41, 0x53, 0x4b, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x43,
	0x48, 0x41, 0x4e, 0x47, 0x45, 0x44, 0x10, 0x02, 0x22, 0xeb, 0x11, 0x0a, 0x10, 0x41, 0x6c, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x52, 0x0a,
	0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x5e, 0x0a, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x08,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4f, 0x72, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x12, 0x4e, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x4b, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x4f,
	0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12,
	0x55, 0x0a, 0x09, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x50, 0x6c, 0x61, 0x63,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x09, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x1a, 0x3d, 0x0a, 0x0e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x2b, 0x0a, 0x11, 0x61, 0x6c, 0x6c, 0x6f,
	0x77, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x10, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x9f, 0x01, 0x0a, 0x04, 0x44, 0x69, 0x73, 0x6b, 0x12, 0x16,
	0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52,
	0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x1c, 0x0a, 0x08, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x08, 0x73, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x73, 0x69, 0x7a, 0x65,
	0x5f, 0x67, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x73, 0x69, 0x7a, 0x65, 0x47,
	0x62, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66,
	0x61, 0x63, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x64, 0x69, 0x73, 0x6b, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x1a, 0xad, 0x01, 0x0a, 0x0c, 0x41, 0x74, 0x74, 0x61,
	0x63, 0x68, 0x65, 0x64, 0x44, 0x69, 0x73, 0x6b, 0x12, 0x49, 0x0a, 0x08, 0x6e, 0x65, 0x77, 0x5f,
	0x64, 0x69, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x48, 0x00, 0x52, 0x07, 0x6e, 0x65, 0x77, 0x44,
	0x69, 0x73, 0x6b, 0x12, 0x25, 0x0a, 0x0d, 0x65, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x5f,
	0x64, 0x69, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x65, 0x78,
	0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x44, 0x69, 0x73, 0x6b, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x42, 0x0a, 0x0a, 0x08, 0x61,
	0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x1a, 0x97, 0x01, 0x0a, 0x0b, 0x41, 0x63, 0x63, 0x65,
	0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x32, 0x0a, 0x13, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x5f, 0x67, 0x70, 0x75,
	0x5f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x47, 0x70, 0x75, 0x44, 0x72,
	0x69, 0x76, 0x65, 0x72, 0x73, 0x12, 0x2a, 0x0a, 0x0e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0d, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x1a, 0xde, 0x03, 0x0a, 0x0e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68,
	0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x6d, 0x69, 0x6e, 0x5f, 0x63,
	0x70, 0x75, 0x5f, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x6d, 0x69, 0x6e, 0x43, 0x70, 0x75, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x12, 0x68, 0x0a, 0x12, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e,
	0x67, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x11, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x57, 0x0a, 0x0c, 0x61,
	0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x6c,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x73, 0x12, 0x49, 0x0a, 0x09, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x73,
	0x6b, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x2e, 0x44, 0x69, 0x73, 0x6b, 0x52, 0x08, 0x62, 0x6f, 0x6f, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x12,
	0x4a, 0x0a, 0x05, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61,
	0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64,
	0x44, 0x69, 0x73, 0x6b, 0x52, 0x05, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x72,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x1a, 0xde, 0x01, 0x0a, 0x18, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4f, 0x72, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12,
	0x50, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x48, 0x00, 0x52, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x2d, 0x0a, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x10,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x12, 0x2e, 0x0a, 0x13, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x5f, 0x67, 0x70, 0x75, 0x5f,
	0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x47, 0x70, 0x75, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x73,
	0x42, 0x11, 0x0a, 0x0f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x1a, 0x81, 0x01, 0x0a, 0x10, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x12, 0x33, 0x0a, 0x16, 0x6e, 0x6f, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x5f, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x13, 0x6e, 0x6f, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70,
	0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x1a, 0x78, 0x0a, 0x0d, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x67, 0x0a, 0x12, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x52, 0x11,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65,
	0x73, 0x1a, 0x56, 0x0a, 0x0f, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x20, 0x0a, 0x0b, 0x63, 0x6f, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6c, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x61, 0x78, 0x5f, 0x64, 0x69,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x6d, 0x61,
	0x78, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x60, 0x0a, 0x11, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x22, 0x0a, 0x1e, 0x50, 0x52, 0x4f,
	0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a,
	0x08, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x53,
	0x50, 0x4f, 0x54, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x52, 0x45, 0x45, 0x4d, 0x50, 0x54,
	0x49, 0x42, 0x4c, 0x45, 0x10, 0x03, 0x22, 0xac, 0x05, 0x0a, 0x09, 0x54, 0x61, 0x73, 0x6b, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x41, 0x0a,
	0x09, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x53, 0x70, 0x65,
	0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x74, 0x61, 0x73, 0x6b, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x61, 0x73, 0x6b, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x20, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x69, 0x73, 0x6d, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x69, 0x73,
	0x6d, 0x12, 0x5e, 0x0a, 0x11, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x5f,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63,
	0x68, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x53,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52,
	0x10, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x4f, 0x0a, 0x11, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63,
	0x68, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x10, 0x74, 0x61, 0x73, 0x6b, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x12, 0x2d, 0x0a, 0x13, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x10, 0x74, 0x61, 0x73, 0x6b, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x50, 0x65, 0x72, 0x4e, 0x6f, 0x64,
	0x65, 0x12, 0x2c, 0x0a, 0x12, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x5f, 0x68, 0x6f, 0x73,
	0x74, 0x73, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x72,
	0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x48, 0x6f, 0x73, 0x74, 0x73, 0x46, 0x69, 0x6c, 0x65, 0x12,
	0x25, 0x0a, 0x0e, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x73,
	0x68, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x76, 0x65, 0x53, 0x73, 0x68, 0x22, 0x5c, 0x0a, 0x10, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x21, 0x0a, 0x1d, 0x53, 0x43,
	0x48, 0x45, 0x44, 0x55, 0x4c, 0x49, 0x4e, 0x47, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a,
	0x13, 0x41, 0x53, 0x5f, 0x53, 0x4f, 0x4f, 0x4e, 0x5f, 0x41, 0x53, 0x5f, 0x50, 0x4f, 0x53, 0x53,
	0x49, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x4e, 0x5f, 0x4f, 0x52, 0x44,
	0x45, 0x52, 0x10, 0x02, 0x3a, 0x6f, 0xea, 0x41, 0x6c, 0x0a, 0x1e, 0x62, 0x61, 0x74, 0x63, 0x68,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x54, 0x61, 0x73, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x4a, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x6a, 0x6f, 0x62, 0x7d, 0x2f, 0x74, 0x61,
	0x73, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x7d, 0x22, 0x3e, 0x0a, 0x0e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x16, 0x0a,
	0x06, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x73,
	0x63, 0x6f, 0x70, 0x65, 0x73, 0x42, 0xa9, 0x01, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68,
	0x2e, 0x76, 0x31, 0x42, 0x08, 0x4a, 0x6f, 0x62, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x2f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x70, 0x62, 0x3b, 0x62, 0x61, 0x74, 0x63, 0x68, 0x70, 0x62,
	0xa2, 0x02, 0x03, 0x47, 0x43, 0x42, 0xaa, 0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x56, 0x31, 0xca, 0x02,
	0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x42, 0x61, 0x74, 0x63, 0x68, 0x3a, 0x3a, 0x56,
	0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_batch_v1_job_proto_rawDescOnce sync.Once
	file_google_cloud_batch_v1_job_proto_rawDescData = file_google_cloud_batch_v1_job_proto_rawDesc
)

func file_google_cloud_batch_v1_job_proto_rawDescGZIP() []byte {
	file_google_cloud_batch_v1_job_proto_rawDescOnce.Do(func() {
		file_google_cloud_batch_v1_job_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_batch_v1_job_proto_rawDescData)
	})
	return file_google_cloud_batch_v1_job_proto_rawDescData
}

var file_google_cloud_batch_v1_job_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_batch_v1_job_proto_msgTypes = make([]protoimpl.MessageInfo, 23)
var file_google_cloud_batch_v1_job_proto_goTypes = []interface{}{
	(LogsPolicy_Destination)(0),                       // 0: google.cloud.batch.v1.LogsPolicy.Destination
	(JobStatus_State)(0),                              // 1: google.cloud.batch.v1.JobStatus.State
	(JobNotification_Type)(0),                         // 2: google.cloud.batch.v1.JobNotification.Type
	(AllocationPolicy_ProvisioningModel)(0),           // 3: google.cloud.batch.v1.AllocationPolicy.ProvisioningModel
	(TaskGroup_SchedulingPolicy)(0),                   // 4: google.cloud.batch.v1.TaskGroup.SchedulingPolicy
	(*Job)(nil),                                       // 5: google.cloud.batch.v1.Job
	(*LogsPolicy)(nil),                                // 6: google.cloud.batch.v1.LogsPolicy
	(*JobStatus)(nil),                                 // 7: google.cloud.batch.v1.JobStatus
	(*JobNotification)(nil),                           // 8: google.cloud.batch.v1.JobNotification
	(*AllocationPolicy)(nil),                          // 9: google.cloud.batch.v1.AllocationPolicy
	(*TaskGroup)(nil),                                 // 10: google.cloud.batch.v1.TaskGroup
	(*ServiceAccount)(nil),                            // 11: google.cloud.batch.v1.ServiceAccount
	nil,                                               // 12: google.cloud.batch.v1.Job.LabelsEntry
	(*JobStatus_InstanceStatus)(nil),                  // 13: google.cloud.batch.v1.JobStatus.InstanceStatus
	(*JobStatus_TaskGroupStatus)(nil),                 // 14: google.cloud.batch.v1.JobStatus.TaskGroupStatus
	nil,                                               // 15: google.cloud.batch.v1.JobStatus.TaskGroupsEntry
	nil,                                               // 16: google.cloud.batch.v1.JobStatus.TaskGroupStatus.CountsEntry
	(*JobNotification_Message)(nil),                   // 17: google.cloud.batch.v1.JobNotification.Message
	(*AllocationPolicy_LocationPolicy)(nil),           // 18: google.cloud.batch.v1.AllocationPolicy.LocationPolicy
	(*AllocationPolicy_Disk)(nil),                     // 19: google.cloud.batch.v1.AllocationPolicy.Disk
	(*AllocationPolicy_AttachedDisk)(nil),             // 20: google.cloud.batch.v1.AllocationPolicy.AttachedDisk
	(*AllocationPolicy_Accelerator)(nil),              // 21: google.cloud.batch.v1.AllocationPolicy.Accelerator
	(*AllocationPolicy_InstancePolicy)(nil),           // 22: google.cloud.batch.v1.AllocationPolicy.InstancePolicy
	(*AllocationPolicy_InstancePolicyOrTemplate)(nil), // 23: google.cloud.batch.v1.AllocationPolicy.InstancePolicyOrTemplate
	(*AllocationPolicy_NetworkInterface)(nil),         // 24: google.cloud.batch.v1.AllocationPolicy.NetworkInterface
	(*AllocationPolicy_NetworkPolicy)(nil),            // 25: google.cloud.batch.v1.AllocationPolicy.NetworkPolicy
	(*AllocationPolicy_PlacementPolicy)(nil),          // 26: google.cloud.batch.v1.AllocationPolicy.PlacementPolicy
	nil,                                               // 27: google.cloud.batch.v1.AllocationPolicy.LabelsEntry
	(*timestamppb.Timestamp)(nil),                     // 28: google.protobuf.Timestamp
	(*StatusEvent)(nil),                               // 29: google.cloud.batch.v1.StatusEvent
	(*durationpb.Duration)(nil),                       // 30: google.protobuf.Duration
	(*TaskSpec)(nil),                                  // 31: google.cloud.batch.v1.TaskSpec
	(*Environment)(nil),                               // 32: google.cloud.batch.v1.Environment
	(TaskStatus_State)(0),                             // 33: google.cloud.batch.v1.TaskStatus.State
}
var file_google_cloud_batch_v1_job_proto_depIdxs = []int32{
	10, // 0: google.cloud.batch.v1.Job.task_groups:type_name -> google.cloud.batch.v1.TaskGroup
	9,  // 1: google.cloud.batch.v1.Job.allocation_policy:type_name -> google.cloud.batch.v1.AllocationPolicy
	12, // 2: google.cloud.batch.v1.Job.labels:type_name -> google.cloud.batch.v1.Job.LabelsEntry
	7,  // 3: google.cloud.batch.v1.Job.status:type_name -> google.cloud.batch.v1.JobStatus
	28, // 4: google.cloud.batch.v1.Job.create_time:type_name -> google.protobuf.Timestamp
	28, // 5: google.cloud.batch.v1.Job.update_time:type_name -> google.protobuf.Timestamp
	6,  // 6: google.cloud.batch.v1.Job.logs_policy:type_name -> google.cloud.batch.v1.LogsPolicy
	8,  // 7: google.cloud.batch.v1.Job.notifications:type_name -> google.cloud.batch.v1.JobNotification
	0,  // 8: google.cloud.batch.v1.LogsPolicy.destination:type_name -> google.cloud.batch.v1.LogsPolicy.Destination
	1,  // 9: google.cloud.batch.v1.JobStatus.state:type_name -> google.cloud.batch.v1.JobStatus.State
	29, // 10: google.cloud.batch.v1.JobStatus.status_events:type_name -> google.cloud.batch.v1.StatusEvent
	15, // 11: google.cloud.batch.v1.JobStatus.task_groups:type_name -> google.cloud.batch.v1.JobStatus.TaskGroupsEntry
	30, // 12: google.cloud.batch.v1.JobStatus.run_duration:type_name -> google.protobuf.Duration
	17, // 13: google.cloud.batch.v1.JobNotification.message:type_name -> google.cloud.batch.v1.JobNotification.Message
	18, // 14: google.cloud.batch.v1.AllocationPolicy.location:type_name -> google.cloud.batch.v1.AllocationPolicy.LocationPolicy
	23, // 15: google.cloud.batch.v1.AllocationPolicy.instances:type_name -> google.cloud.batch.v1.AllocationPolicy.InstancePolicyOrTemplate
	11, // 16: google.cloud.batch.v1.AllocationPolicy.service_account:type_name -> google.cloud.batch.v1.ServiceAccount
	27, // 17: google.cloud.batch.v1.AllocationPolicy.labels:type_name -> google.cloud.batch.v1.AllocationPolicy.LabelsEntry
	25, // 18: google.cloud.batch.v1.AllocationPolicy.network:type_name -> google.cloud.batch.v1.AllocationPolicy.NetworkPolicy
	26, // 19: google.cloud.batch.v1.AllocationPolicy.placement:type_name -> google.cloud.batch.v1.AllocationPolicy.PlacementPolicy
	31, // 20: google.cloud.batch.v1.TaskGroup.task_spec:type_name -> google.cloud.batch.v1.TaskSpec
	4,  // 21: google.cloud.batch.v1.TaskGroup.scheduling_policy:type_name -> google.cloud.batch.v1.TaskGroup.SchedulingPolicy
	32, // 22: google.cloud.batch.v1.TaskGroup.task_environments:type_name -> google.cloud.batch.v1.Environment
	3,  // 23: google.cloud.batch.v1.JobStatus.InstanceStatus.provisioning_model:type_name -> google.cloud.batch.v1.AllocationPolicy.ProvisioningModel
	19, // 24: google.cloud.batch.v1.JobStatus.InstanceStatus.boot_disk:type_name -> google.cloud.batch.v1.AllocationPolicy.Disk
	16, // 25: google.cloud.batch.v1.JobStatus.TaskGroupStatus.counts:type_name -> google.cloud.batch.v1.JobStatus.TaskGroupStatus.CountsEntry
	13, // 26: google.cloud.batch.v1.JobStatus.TaskGroupStatus.instances:type_name -> google.cloud.batch.v1.JobStatus.InstanceStatus
	14, // 27: google.cloud.batch.v1.JobStatus.TaskGroupsEntry.value:type_name -> google.cloud.batch.v1.JobStatus.TaskGroupStatus
	2,  // 28: google.cloud.batch.v1.JobNotification.Message.type:type_name -> google.cloud.batch.v1.JobNotification.Type
	1,  // 29: google.cloud.batch.v1.JobNotification.Message.new_job_state:type_name -> google.cloud.batch.v1.JobStatus.State
	33, // 30: google.cloud.batch.v1.JobNotification.Message.new_task_state:type_name -> google.cloud.batch.v1.TaskStatus.State
	19, // 31: google.cloud.batch.v1.AllocationPolicy.AttachedDisk.new_disk:type_name -> google.cloud.batch.v1.AllocationPolicy.Disk
	3,  // 32: google.cloud.batch.v1.AllocationPolicy.InstancePolicy.provisioning_model:type_name -> google.cloud.batch.v1.AllocationPolicy.ProvisioningModel
	21, // 33: google.cloud.batch.v1.AllocationPolicy.InstancePolicy.accelerators:type_name -> google.cloud.batch.v1.AllocationPolicy.Accelerator
	19, // 34: google.cloud.batch.v1.AllocationPolicy.InstancePolicy.boot_disk:type_name -> google.cloud.batch.v1.AllocationPolicy.Disk
	20, // 35: google.cloud.batch.v1.AllocationPolicy.InstancePolicy.disks:type_name -> google.cloud.batch.v1.AllocationPolicy.AttachedDisk
	22, // 36: google.cloud.batch.v1.AllocationPolicy.InstancePolicyOrTemplate.policy:type_name -> google.cloud.batch.v1.AllocationPolicy.InstancePolicy
	24, // 37: google.cloud.batch.v1.AllocationPolicy.NetworkPolicy.network_interfaces:type_name -> google.cloud.batch.v1.AllocationPolicy.NetworkInterface
	38, // [38:38] is the sub-list for method output_type
	38, // [38:38] is the sub-list for method input_type
	38, // [38:38] is the sub-list for extension type_name
	38, // [38:38] is the sub-list for extension extendee
	0,  // [0:38] is the sub-list for field type_name
}

func init() { file_google_cloud_batch_v1_job_proto_init() }
func file_google_cloud_batch_v1_job_proto_init() {
	if File_google_cloud_batch_v1_job_proto != nil {
		return
	}
	file_google_cloud_batch_v1_task_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_batch_v1_job_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Job); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1_job_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LogsPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1_job_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1_job_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobNotification); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1_job_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1_job_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TaskGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1_job_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceAccount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1_job_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobStatus_InstanceStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1_job_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobStatus_TaskGroupStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1_job_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobNotification_Message); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1_job_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationPolicy_LocationPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1_job_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationPolicy_Disk); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1_job_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationPolicy_AttachedDisk); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1_job_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationPolicy_Accelerator); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1_job_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationPolicy_InstancePolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1_job_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationPolicy_InstancePolicyOrTemplate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1_job_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationPolicy_NetworkInterface); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1_job_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationPolicy_NetworkPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1_job_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationPolicy_PlacementPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_batch_v1_job_proto_msgTypes[14].OneofWrappers = []interface{}{
		(*AllocationPolicy_Disk_Image)(nil),
		(*AllocationPolicy_Disk_Snapshot)(nil),
	}
	file_google_cloud_batch_v1_job_proto_msgTypes[15].OneofWrappers = []interface{}{
		(*AllocationPolicy_AttachedDisk_NewDisk)(nil),
		(*AllocationPolicy_AttachedDisk_ExistingDisk)(nil),
	}
	file_google_cloud_batch_v1_job_proto_msgTypes[18].OneofWrappers = []interface{}{
		(*AllocationPolicy_InstancePolicyOrTemplate_Policy)(nil),
		(*AllocationPolicy_InstancePolicyOrTemplate_InstanceTemplate)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_batch_v1_job_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_batch_v1_job_proto_goTypes,
		DependencyIndexes: file_google_cloud_batch_v1_job_proto_depIdxs,
		EnumInfos:         file_google_cloud_batch_v1_job_proto_enumTypes,
		MessageInfos:      file_google_cloud_batch_v1_job_proto_msgTypes,
	}.Build()
	File_google_cloud_batch_v1_job_proto = out.File
	file_google_cloud_batch_v1_job_proto_rawDesc = nil
	file_google_cloud_batch_v1_job_proto_goTypes = nil
	file_google_cloud_batch_v1_job_proto_depIdxs = nil
}
