// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1/deployment_resource_pool_service.proto

package aiplatformpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	DeploymentResourcePoolService_CreateDeploymentResourcePool_FullMethodName = "/google.cloud.aiplatform.v1.DeploymentResourcePoolService/CreateDeploymentResourcePool"
	DeploymentResourcePoolService_GetDeploymentResourcePool_FullMethodName    = "/google.cloud.aiplatform.v1.DeploymentResourcePoolService/GetDeploymentResourcePool"
	DeploymentResourcePoolService_ListDeploymentResourcePools_FullMethodName  = "/google.cloud.aiplatform.v1.DeploymentResourcePoolService/ListDeploymentResourcePools"
	DeploymentResourcePoolService_UpdateDeploymentResourcePool_FullMethodName = "/google.cloud.aiplatform.v1.DeploymentResourcePoolService/UpdateDeploymentResourcePool"
	DeploymentResourcePoolService_DeleteDeploymentResourcePool_FullMethodName = "/google.cloud.aiplatform.v1.DeploymentResourcePoolService/DeleteDeploymentResourcePool"
	DeploymentResourcePoolService_QueryDeployedModels_FullMethodName          = "/google.cloud.aiplatform.v1.DeploymentResourcePoolService/QueryDeployedModels"
)

// DeploymentResourcePoolServiceClient is the client API for DeploymentResourcePoolService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DeploymentResourcePoolServiceClient interface {
	// Create a DeploymentResourcePool.
	CreateDeploymentResourcePool(ctx context.Context, in *CreateDeploymentResourcePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Get a DeploymentResourcePool.
	GetDeploymentResourcePool(ctx context.Context, in *GetDeploymentResourcePoolRequest, opts ...grpc.CallOption) (*DeploymentResourcePool, error)
	// List DeploymentResourcePools in a location.
	ListDeploymentResourcePools(ctx context.Context, in *ListDeploymentResourcePoolsRequest, opts ...grpc.CallOption) (*ListDeploymentResourcePoolsResponse, error)
	// Update a DeploymentResourcePool.
	UpdateDeploymentResourcePool(ctx context.Context, in *UpdateDeploymentResourcePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Delete a DeploymentResourcePool.
	DeleteDeploymentResourcePool(ctx context.Context, in *DeleteDeploymentResourcePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// List DeployedModels that have been deployed on this DeploymentResourcePool.
	QueryDeployedModels(ctx context.Context, in *QueryDeployedModelsRequest, opts ...grpc.CallOption) (*QueryDeployedModelsResponse, error)
}

type deploymentResourcePoolServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDeploymentResourcePoolServiceClient(cc grpc.ClientConnInterface) DeploymentResourcePoolServiceClient {
	return &deploymentResourcePoolServiceClient{cc}
}

func (c *deploymentResourcePoolServiceClient) CreateDeploymentResourcePool(ctx context.Context, in *CreateDeploymentResourcePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DeploymentResourcePoolService_CreateDeploymentResourcePool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deploymentResourcePoolServiceClient) GetDeploymentResourcePool(ctx context.Context, in *GetDeploymentResourcePoolRequest, opts ...grpc.CallOption) (*DeploymentResourcePool, error) {
	out := new(DeploymentResourcePool)
	err := c.cc.Invoke(ctx, DeploymentResourcePoolService_GetDeploymentResourcePool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deploymentResourcePoolServiceClient) ListDeploymentResourcePools(ctx context.Context, in *ListDeploymentResourcePoolsRequest, opts ...grpc.CallOption) (*ListDeploymentResourcePoolsResponse, error) {
	out := new(ListDeploymentResourcePoolsResponse)
	err := c.cc.Invoke(ctx, DeploymentResourcePoolService_ListDeploymentResourcePools_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deploymentResourcePoolServiceClient) UpdateDeploymentResourcePool(ctx context.Context, in *UpdateDeploymentResourcePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DeploymentResourcePoolService_UpdateDeploymentResourcePool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deploymentResourcePoolServiceClient) DeleteDeploymentResourcePool(ctx context.Context, in *DeleteDeploymentResourcePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DeploymentResourcePoolService_DeleteDeploymentResourcePool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deploymentResourcePoolServiceClient) QueryDeployedModels(ctx context.Context, in *QueryDeployedModelsRequest, opts ...grpc.CallOption) (*QueryDeployedModelsResponse, error) {
	out := new(QueryDeployedModelsResponse)
	err := c.cc.Invoke(ctx, DeploymentResourcePoolService_QueryDeployedModels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DeploymentResourcePoolServiceServer is the server API for DeploymentResourcePoolService service.
// All implementations should embed UnimplementedDeploymentResourcePoolServiceServer
// for forward compatibility
type DeploymentResourcePoolServiceServer interface {
	// Create a DeploymentResourcePool.
	CreateDeploymentResourcePool(context.Context, *CreateDeploymentResourcePoolRequest) (*longrunningpb.Operation, error)
	// Get a DeploymentResourcePool.
	GetDeploymentResourcePool(context.Context, *GetDeploymentResourcePoolRequest) (*DeploymentResourcePool, error)
	// List DeploymentResourcePools in a location.
	ListDeploymentResourcePools(context.Context, *ListDeploymentResourcePoolsRequest) (*ListDeploymentResourcePoolsResponse, error)
	// Update a DeploymentResourcePool.
	UpdateDeploymentResourcePool(context.Context, *UpdateDeploymentResourcePoolRequest) (*longrunningpb.Operation, error)
	// Delete a DeploymentResourcePool.
	DeleteDeploymentResourcePool(context.Context, *DeleteDeploymentResourcePoolRequest) (*longrunningpb.Operation, error)
	// List DeployedModels that have been deployed on this DeploymentResourcePool.
	QueryDeployedModels(context.Context, *QueryDeployedModelsRequest) (*QueryDeployedModelsResponse, error)
}

// UnimplementedDeploymentResourcePoolServiceServer should be embedded to have forward compatible implementations.
type UnimplementedDeploymentResourcePoolServiceServer struct {
}

func (UnimplementedDeploymentResourcePoolServiceServer) CreateDeploymentResourcePool(context.Context, *CreateDeploymentResourcePoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDeploymentResourcePool not implemented")
}
func (UnimplementedDeploymentResourcePoolServiceServer) GetDeploymentResourcePool(context.Context, *GetDeploymentResourcePoolRequest) (*DeploymentResourcePool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDeploymentResourcePool not implemented")
}
func (UnimplementedDeploymentResourcePoolServiceServer) ListDeploymentResourcePools(context.Context, *ListDeploymentResourcePoolsRequest) (*ListDeploymentResourcePoolsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeploymentResourcePools not implemented")
}
func (UnimplementedDeploymentResourcePoolServiceServer) UpdateDeploymentResourcePool(context.Context, *UpdateDeploymentResourcePoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDeploymentResourcePool not implemented")
}
func (UnimplementedDeploymentResourcePoolServiceServer) DeleteDeploymentResourcePool(context.Context, *DeleteDeploymentResourcePoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDeploymentResourcePool not implemented")
}
func (UnimplementedDeploymentResourcePoolServiceServer) QueryDeployedModels(context.Context, *QueryDeployedModelsRequest) (*QueryDeployedModelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryDeployedModels not implemented")
}

// UnsafeDeploymentResourcePoolServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DeploymentResourcePoolServiceServer will
// result in compilation errors.
type UnsafeDeploymentResourcePoolServiceServer interface {
	mustEmbedUnimplementedDeploymentResourcePoolServiceServer()
}

func RegisterDeploymentResourcePoolServiceServer(s grpc.ServiceRegistrar, srv DeploymentResourcePoolServiceServer) {
	s.RegisterService(&DeploymentResourcePoolService_ServiceDesc, srv)
}

func _DeploymentResourcePoolService_CreateDeploymentResourcePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDeploymentResourcePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeploymentResourcePoolServiceServer).CreateDeploymentResourcePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeploymentResourcePoolService_CreateDeploymentResourcePool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeploymentResourcePoolServiceServer).CreateDeploymentResourcePool(ctx, req.(*CreateDeploymentResourcePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeploymentResourcePoolService_GetDeploymentResourcePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeploymentResourcePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeploymentResourcePoolServiceServer).GetDeploymentResourcePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeploymentResourcePoolService_GetDeploymentResourcePool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeploymentResourcePoolServiceServer).GetDeploymentResourcePool(ctx, req.(*GetDeploymentResourcePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeploymentResourcePoolService_ListDeploymentResourcePools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeploymentResourcePoolsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeploymentResourcePoolServiceServer).ListDeploymentResourcePools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeploymentResourcePoolService_ListDeploymentResourcePools_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeploymentResourcePoolServiceServer).ListDeploymentResourcePools(ctx, req.(*ListDeploymentResourcePoolsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeploymentResourcePoolService_UpdateDeploymentResourcePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDeploymentResourcePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeploymentResourcePoolServiceServer).UpdateDeploymentResourcePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeploymentResourcePoolService_UpdateDeploymentResourcePool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeploymentResourcePoolServiceServer).UpdateDeploymentResourcePool(ctx, req.(*UpdateDeploymentResourcePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeploymentResourcePoolService_DeleteDeploymentResourcePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDeploymentResourcePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeploymentResourcePoolServiceServer).DeleteDeploymentResourcePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeploymentResourcePoolService_DeleteDeploymentResourcePool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeploymentResourcePoolServiceServer).DeleteDeploymentResourcePool(ctx, req.(*DeleteDeploymentResourcePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeploymentResourcePoolService_QueryDeployedModels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryDeployedModelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeploymentResourcePoolServiceServer).QueryDeployedModels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeploymentResourcePoolService_QueryDeployedModels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeploymentResourcePoolServiceServer).QueryDeployedModels(ctx, req.(*QueryDeployedModelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DeploymentResourcePoolService_ServiceDesc is the grpc.ServiceDesc for DeploymentResourcePoolService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DeploymentResourcePoolService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1.DeploymentResourcePoolService",
	HandlerType: (*DeploymentResourcePoolServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateDeploymentResourcePool",
			Handler:    _DeploymentResourcePoolService_CreateDeploymentResourcePool_Handler,
		},
		{
			MethodName: "GetDeploymentResourcePool",
			Handler:    _DeploymentResourcePoolService_GetDeploymentResourcePool_Handler,
		},
		{
			MethodName: "ListDeploymentResourcePools",
			Handler:    _DeploymentResourcePoolService_ListDeploymentResourcePools_Handler,
		},
		{
			MethodName: "UpdateDeploymentResourcePool",
			Handler:    _DeploymentResourcePoolService_UpdateDeploymentResourcePool_Handler,
		},
		{
			MethodName: "DeleteDeploymentResourcePool",
			Handler:    _DeploymentResourcePoolService_DeleteDeploymentResourcePool_Handler,
		},
		{
			MethodName: "QueryDeployedModels",
			Handler:    _DeploymentResourcePoolService_QueryDeployedModels_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1/deployment_resource_pool_service.proto",
}
