// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1beta1/model_service.proto

package aiplatformpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ModelService_UploadModel_FullMethodName                      = "/google.cloud.aiplatform.v1beta1.ModelService/UploadModel"
	ModelService_GetModel_FullMethodName                         = "/google.cloud.aiplatform.v1beta1.ModelService/GetModel"
	ModelService_ListModels_FullMethodName                       = "/google.cloud.aiplatform.v1beta1.ModelService/ListModels"
	ModelService_ListModelVersions_FullMethodName                = "/google.cloud.aiplatform.v1beta1.ModelService/ListModelVersions"
	ModelService_ListModelVersionCheckpoints_FullMethodName      = "/google.cloud.aiplatform.v1beta1.ModelService/ListModelVersionCheckpoints"
	ModelService_UpdateModel_FullMethodName                      = "/google.cloud.aiplatform.v1beta1.ModelService/UpdateModel"
	ModelService_UpdateExplanationDataset_FullMethodName         = "/google.cloud.aiplatform.v1beta1.ModelService/UpdateExplanationDataset"
	ModelService_DeleteModel_FullMethodName                      = "/google.cloud.aiplatform.v1beta1.ModelService/DeleteModel"
	ModelService_DeleteModelVersion_FullMethodName               = "/google.cloud.aiplatform.v1beta1.ModelService/DeleteModelVersion"
	ModelService_MergeVersionAliases_FullMethodName              = "/google.cloud.aiplatform.v1beta1.ModelService/MergeVersionAliases"
	ModelService_ExportModel_FullMethodName                      = "/google.cloud.aiplatform.v1beta1.ModelService/ExportModel"
	ModelService_CopyModel_FullMethodName                        = "/google.cloud.aiplatform.v1beta1.ModelService/CopyModel"
	ModelService_ImportModelEvaluation_FullMethodName            = "/google.cloud.aiplatform.v1beta1.ModelService/ImportModelEvaluation"
	ModelService_BatchImportModelEvaluationSlices_FullMethodName = "/google.cloud.aiplatform.v1beta1.ModelService/BatchImportModelEvaluationSlices"
	ModelService_BatchImportEvaluatedAnnotations_FullMethodName  = "/google.cloud.aiplatform.v1beta1.ModelService/BatchImportEvaluatedAnnotations"
	ModelService_GetModelEvaluation_FullMethodName               = "/google.cloud.aiplatform.v1beta1.ModelService/GetModelEvaluation"
	ModelService_ListModelEvaluations_FullMethodName             = "/google.cloud.aiplatform.v1beta1.ModelService/ListModelEvaluations"
	ModelService_GetModelEvaluationSlice_FullMethodName          = "/google.cloud.aiplatform.v1beta1.ModelService/GetModelEvaluationSlice"
	ModelService_ListModelEvaluationSlices_FullMethodName        = "/google.cloud.aiplatform.v1beta1.ModelService/ListModelEvaluationSlices"
)

// ModelServiceClient is the client API for ModelService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ModelServiceClient interface {
	// Uploads a Model artifact into Vertex AI.
	UploadModel(ctx context.Context, in *UploadModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a Model.
	GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Lists Models in a Location.
	ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error)
	// Lists versions of the specified model.
	ListModelVersions(ctx context.Context, in *ListModelVersionsRequest, opts ...grpc.CallOption) (*ListModelVersionsResponse, error)
	// Lists checkpoints of the specified model version.
	ListModelVersionCheckpoints(ctx context.Context, in *ListModelVersionCheckpointsRequest, opts ...grpc.CallOption) (*ListModelVersionCheckpointsResponse, error)
	// Updates a Model.
	UpdateModel(ctx context.Context, in *UpdateModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Incrementally update the dataset used for an examples model.
	UpdateExplanationDataset(ctx context.Context, in *UpdateExplanationDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a Model.
	//
	// A model cannot be deleted if any
	// [Endpoint][google.cloud.aiplatform.v1beta1.Endpoint] resource has a
	// [DeployedModel][google.cloud.aiplatform.v1beta1.DeployedModel] based on the
	// model in its
	// [deployed_models][google.cloud.aiplatform.v1beta1.Endpoint.deployed_models]
	// field.
	DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a Model version.
	//
	// Model version can only be deleted if there are no
	// [DeployedModels][google.cloud.aiplatform.v1beta1.DeployedModel] created
	// from it. Deleting the only version in the Model is not allowed. Use
	// [DeleteModel][google.cloud.aiplatform.v1beta1.ModelService.DeleteModel] for
	// deleting the Model instead.
	DeleteModelVersion(ctx context.Context, in *DeleteModelVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Merges a set of aliases for a Model version.
	MergeVersionAliases(ctx context.Context, in *MergeVersionAliasesRequest, opts ...grpc.CallOption) (*Model, error)
	// Exports a trained, exportable Model to a location specified by the
	// user. A Model is considered to be exportable if it has at least one
	// [supported export
	// format][google.cloud.aiplatform.v1beta1.Model.supported_export_formats].
	ExportModel(ctx context.Context, in *ExportModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Copies an already existing Vertex AI Model into the specified Location.
	// The source Model must exist in the same Project.
	// When copying custom Models, the users themselves are responsible for
	// [Model.metadata][google.cloud.aiplatform.v1beta1.Model.metadata] content to
	// be region-agnostic, as well as making sure that any resources (e.g. files)
	// it depends on remain accessible.
	CopyModel(ctx context.Context, in *CopyModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Imports an externally generated ModelEvaluation.
	ImportModelEvaluation(ctx context.Context, in *ImportModelEvaluationRequest, opts ...grpc.CallOption) (*ModelEvaluation, error)
	// Imports a list of externally generated ModelEvaluationSlice.
	BatchImportModelEvaluationSlices(ctx context.Context, in *BatchImportModelEvaluationSlicesRequest, opts ...grpc.CallOption) (*BatchImportModelEvaluationSlicesResponse, error)
	// Imports a list of externally generated EvaluatedAnnotations.
	BatchImportEvaluatedAnnotations(ctx context.Context, in *BatchImportEvaluatedAnnotationsRequest, opts ...grpc.CallOption) (*BatchImportEvaluatedAnnotationsResponse, error)
	// Gets a ModelEvaluation.
	GetModelEvaluation(ctx context.Context, in *GetModelEvaluationRequest, opts ...grpc.CallOption) (*ModelEvaluation, error)
	// Lists ModelEvaluations in a Model.
	ListModelEvaluations(ctx context.Context, in *ListModelEvaluationsRequest, opts ...grpc.CallOption) (*ListModelEvaluationsResponse, error)
	// Gets a ModelEvaluationSlice.
	GetModelEvaluationSlice(ctx context.Context, in *GetModelEvaluationSliceRequest, opts ...grpc.CallOption) (*ModelEvaluationSlice, error)
	// Lists ModelEvaluationSlices in a ModelEvaluation.
	ListModelEvaluationSlices(ctx context.Context, in *ListModelEvaluationSlicesRequest, opts ...grpc.CallOption) (*ListModelEvaluationSlicesResponse, error)
}

type modelServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewModelServiceClient(cc grpc.ClientConnInterface) ModelServiceClient {
	return &modelServiceClient{cc}
}

func (c *modelServiceClient) UploadModel(ctx context.Context, in *UploadModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ModelService_UploadModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, ModelService_GetModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error) {
	out := new(ListModelsResponse)
	err := c.cc.Invoke(ctx, ModelService_ListModels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) ListModelVersions(ctx context.Context, in *ListModelVersionsRequest, opts ...grpc.CallOption) (*ListModelVersionsResponse, error) {
	out := new(ListModelVersionsResponse)
	err := c.cc.Invoke(ctx, ModelService_ListModelVersions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) ListModelVersionCheckpoints(ctx context.Context, in *ListModelVersionCheckpointsRequest, opts ...grpc.CallOption) (*ListModelVersionCheckpointsResponse, error) {
	out := new(ListModelVersionCheckpointsResponse)
	err := c.cc.Invoke(ctx, ModelService_ListModelVersionCheckpoints_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) UpdateModel(ctx context.Context, in *UpdateModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, ModelService_UpdateModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) UpdateExplanationDataset(ctx context.Context, in *UpdateExplanationDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ModelService_UpdateExplanationDataset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ModelService_DeleteModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) DeleteModelVersion(ctx context.Context, in *DeleteModelVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ModelService_DeleteModelVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) MergeVersionAliases(ctx context.Context, in *MergeVersionAliasesRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, ModelService_MergeVersionAliases_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) ExportModel(ctx context.Context, in *ExportModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ModelService_ExportModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) CopyModel(ctx context.Context, in *CopyModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ModelService_CopyModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) ImportModelEvaluation(ctx context.Context, in *ImportModelEvaluationRequest, opts ...grpc.CallOption) (*ModelEvaluation, error) {
	out := new(ModelEvaluation)
	err := c.cc.Invoke(ctx, ModelService_ImportModelEvaluation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) BatchImportModelEvaluationSlices(ctx context.Context, in *BatchImportModelEvaluationSlicesRequest, opts ...grpc.CallOption) (*BatchImportModelEvaluationSlicesResponse, error) {
	out := new(BatchImportModelEvaluationSlicesResponse)
	err := c.cc.Invoke(ctx, ModelService_BatchImportModelEvaluationSlices_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) BatchImportEvaluatedAnnotations(ctx context.Context, in *BatchImportEvaluatedAnnotationsRequest, opts ...grpc.CallOption) (*BatchImportEvaluatedAnnotationsResponse, error) {
	out := new(BatchImportEvaluatedAnnotationsResponse)
	err := c.cc.Invoke(ctx, ModelService_BatchImportEvaluatedAnnotations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) GetModelEvaluation(ctx context.Context, in *GetModelEvaluationRequest, opts ...grpc.CallOption) (*ModelEvaluation, error) {
	out := new(ModelEvaluation)
	err := c.cc.Invoke(ctx, ModelService_GetModelEvaluation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) ListModelEvaluations(ctx context.Context, in *ListModelEvaluationsRequest, opts ...grpc.CallOption) (*ListModelEvaluationsResponse, error) {
	out := new(ListModelEvaluationsResponse)
	err := c.cc.Invoke(ctx, ModelService_ListModelEvaluations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) GetModelEvaluationSlice(ctx context.Context, in *GetModelEvaluationSliceRequest, opts ...grpc.CallOption) (*ModelEvaluationSlice, error) {
	out := new(ModelEvaluationSlice)
	err := c.cc.Invoke(ctx, ModelService_GetModelEvaluationSlice_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) ListModelEvaluationSlices(ctx context.Context, in *ListModelEvaluationSlicesRequest, opts ...grpc.CallOption) (*ListModelEvaluationSlicesResponse, error) {
	out := new(ListModelEvaluationSlicesResponse)
	err := c.cc.Invoke(ctx, ModelService_ListModelEvaluationSlices_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ModelServiceServer is the server API for ModelService service.
// All implementations should embed UnimplementedModelServiceServer
// for forward compatibility
type ModelServiceServer interface {
	// Uploads a Model artifact into Vertex AI.
	UploadModel(context.Context, *UploadModelRequest) (*longrunningpb.Operation, error)
	// Gets a Model.
	GetModel(context.Context, *GetModelRequest) (*Model, error)
	// Lists Models in a Location.
	ListModels(context.Context, *ListModelsRequest) (*ListModelsResponse, error)
	// Lists versions of the specified model.
	ListModelVersions(context.Context, *ListModelVersionsRequest) (*ListModelVersionsResponse, error)
	// Lists checkpoints of the specified model version.
	ListModelVersionCheckpoints(context.Context, *ListModelVersionCheckpointsRequest) (*ListModelVersionCheckpointsResponse, error)
	// Updates a Model.
	UpdateModel(context.Context, *UpdateModelRequest) (*Model, error)
	// Incrementally update the dataset used for an examples model.
	UpdateExplanationDataset(context.Context, *UpdateExplanationDatasetRequest) (*longrunningpb.Operation, error)
	// Deletes a Model.
	//
	// A model cannot be deleted if any
	// [Endpoint][google.cloud.aiplatform.v1beta1.Endpoint] resource has a
	// [DeployedModel][google.cloud.aiplatform.v1beta1.DeployedModel] based on the
	// model in its
	// [deployed_models][google.cloud.aiplatform.v1beta1.Endpoint.deployed_models]
	// field.
	DeleteModel(context.Context, *DeleteModelRequest) (*longrunningpb.Operation, error)
	// Deletes a Model version.
	//
	// Model version can only be deleted if there are no
	// [DeployedModels][google.cloud.aiplatform.v1beta1.DeployedModel] created
	// from it. Deleting the only version in the Model is not allowed. Use
	// [DeleteModel][google.cloud.aiplatform.v1beta1.ModelService.DeleteModel] for
	// deleting the Model instead.
	DeleteModelVersion(context.Context, *DeleteModelVersionRequest) (*longrunningpb.Operation, error)
	// Merges a set of aliases for a Model version.
	MergeVersionAliases(context.Context, *MergeVersionAliasesRequest) (*Model, error)
	// Exports a trained, exportable Model to a location specified by the
	// user. A Model is considered to be exportable if it has at least one
	// [supported export
	// format][google.cloud.aiplatform.v1beta1.Model.supported_export_formats].
	ExportModel(context.Context, *ExportModelRequest) (*longrunningpb.Operation, error)
	// Copies an already existing Vertex AI Model into the specified Location.
	// The source Model must exist in the same Project.
	// When copying custom Models, the users themselves are responsible for
	// [Model.metadata][google.cloud.aiplatform.v1beta1.Model.metadata] content to
	// be region-agnostic, as well as making sure that any resources (e.g. files)
	// it depends on remain accessible.
	CopyModel(context.Context, *CopyModelRequest) (*longrunningpb.Operation, error)
	// Imports an externally generated ModelEvaluation.
	ImportModelEvaluation(context.Context, *ImportModelEvaluationRequest) (*ModelEvaluation, error)
	// Imports a list of externally generated ModelEvaluationSlice.
	BatchImportModelEvaluationSlices(context.Context, *BatchImportModelEvaluationSlicesRequest) (*BatchImportModelEvaluationSlicesResponse, error)
	// Imports a list of externally generated EvaluatedAnnotations.
	BatchImportEvaluatedAnnotations(context.Context, *BatchImportEvaluatedAnnotationsRequest) (*BatchImportEvaluatedAnnotationsResponse, error)
	// Gets a ModelEvaluation.
	GetModelEvaluation(context.Context, *GetModelEvaluationRequest) (*ModelEvaluation, error)
	// Lists ModelEvaluations in a Model.
	ListModelEvaluations(context.Context, *ListModelEvaluationsRequest) (*ListModelEvaluationsResponse, error)
	// Gets a ModelEvaluationSlice.
	GetModelEvaluationSlice(context.Context, *GetModelEvaluationSliceRequest) (*ModelEvaluationSlice, error)
	// Lists ModelEvaluationSlices in a ModelEvaluation.
	ListModelEvaluationSlices(context.Context, *ListModelEvaluationSlicesRequest) (*ListModelEvaluationSlicesResponse, error)
}

// UnimplementedModelServiceServer should be embedded to have forward compatible implementations.
type UnimplementedModelServiceServer struct {
}

func (UnimplementedModelServiceServer) UploadModel(context.Context, *UploadModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UploadModel not implemented")
}
func (UnimplementedModelServiceServer) GetModel(context.Context, *GetModelRequest) (*Model, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetModel not implemented")
}
func (UnimplementedModelServiceServer) ListModels(context.Context, *ListModelsRequest) (*ListModelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListModels not implemented")
}
func (UnimplementedModelServiceServer) ListModelVersions(context.Context, *ListModelVersionsRequest) (*ListModelVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListModelVersions not implemented")
}
func (UnimplementedModelServiceServer) ListModelVersionCheckpoints(context.Context, *ListModelVersionCheckpointsRequest) (*ListModelVersionCheckpointsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListModelVersionCheckpoints not implemented")
}
func (UnimplementedModelServiceServer) UpdateModel(context.Context, *UpdateModelRequest) (*Model, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateModel not implemented")
}
func (UnimplementedModelServiceServer) UpdateExplanationDataset(context.Context, *UpdateExplanationDatasetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateExplanationDataset not implemented")
}
func (UnimplementedModelServiceServer) DeleteModel(context.Context, *DeleteModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteModel not implemented")
}
func (UnimplementedModelServiceServer) DeleteModelVersion(context.Context, *DeleteModelVersionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteModelVersion not implemented")
}
func (UnimplementedModelServiceServer) MergeVersionAliases(context.Context, *MergeVersionAliasesRequest) (*Model, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MergeVersionAliases not implemented")
}
func (UnimplementedModelServiceServer) ExportModel(context.Context, *ExportModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportModel not implemented")
}
func (UnimplementedModelServiceServer) CopyModel(context.Context, *CopyModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CopyModel not implemented")
}
func (UnimplementedModelServiceServer) ImportModelEvaluation(context.Context, *ImportModelEvaluationRequest) (*ModelEvaluation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportModelEvaluation not implemented")
}
func (UnimplementedModelServiceServer) BatchImportModelEvaluationSlices(context.Context, *BatchImportModelEvaluationSlicesRequest) (*BatchImportModelEvaluationSlicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchImportModelEvaluationSlices not implemented")
}
func (UnimplementedModelServiceServer) BatchImportEvaluatedAnnotations(context.Context, *BatchImportEvaluatedAnnotationsRequest) (*BatchImportEvaluatedAnnotationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchImportEvaluatedAnnotations not implemented")
}
func (UnimplementedModelServiceServer) GetModelEvaluation(context.Context, *GetModelEvaluationRequest) (*ModelEvaluation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetModelEvaluation not implemented")
}
func (UnimplementedModelServiceServer) ListModelEvaluations(context.Context, *ListModelEvaluationsRequest) (*ListModelEvaluationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListModelEvaluations not implemented")
}
func (UnimplementedModelServiceServer) GetModelEvaluationSlice(context.Context, *GetModelEvaluationSliceRequest) (*ModelEvaluationSlice, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetModelEvaluationSlice not implemented")
}
func (UnimplementedModelServiceServer) ListModelEvaluationSlices(context.Context, *ListModelEvaluationSlicesRequest) (*ListModelEvaluationSlicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListModelEvaluationSlices not implemented")
}

// UnsafeModelServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ModelServiceServer will
// result in compilation errors.
type UnsafeModelServiceServer interface {
	mustEmbedUnimplementedModelServiceServer()
}

func RegisterModelServiceServer(s grpc.ServiceRegistrar, srv ModelServiceServer) {
	s.RegisterService(&ModelService_ServiceDesc, srv)
}

func _ModelService_UploadModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UploadModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).UploadModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_UploadModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).UploadModel(ctx, req.(*UploadModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_GetModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).GetModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_GetModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).GetModel(ctx, req.(*GetModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_ListModels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).ListModels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_ListModels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).ListModels(ctx, req.(*ListModelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_ListModelVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).ListModelVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_ListModelVersions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).ListModelVersions(ctx, req.(*ListModelVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_ListModelVersionCheckpoints_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelVersionCheckpointsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).ListModelVersionCheckpoints(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_ListModelVersionCheckpoints_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).ListModelVersionCheckpoints(ctx, req.(*ListModelVersionCheckpointsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_UpdateModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).UpdateModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_UpdateModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).UpdateModel(ctx, req.(*UpdateModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_UpdateExplanationDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateExplanationDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).UpdateExplanationDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_UpdateExplanationDataset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).UpdateExplanationDataset(ctx, req.(*UpdateExplanationDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_DeleteModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).DeleteModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_DeleteModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).DeleteModel(ctx, req.(*DeleteModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_DeleteModelVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteModelVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).DeleteModelVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_DeleteModelVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).DeleteModelVersion(ctx, req.(*DeleteModelVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_MergeVersionAliases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MergeVersionAliasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).MergeVersionAliases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_MergeVersionAliases_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).MergeVersionAliases(ctx, req.(*MergeVersionAliasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_ExportModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).ExportModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_ExportModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).ExportModel(ctx, req.(*ExportModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_CopyModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CopyModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).CopyModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_CopyModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).CopyModel(ctx, req.(*CopyModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_ImportModelEvaluation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportModelEvaluationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).ImportModelEvaluation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_ImportModelEvaluation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).ImportModelEvaluation(ctx, req.(*ImportModelEvaluationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_BatchImportModelEvaluationSlices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchImportModelEvaluationSlicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).BatchImportModelEvaluationSlices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_BatchImportModelEvaluationSlices_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).BatchImportModelEvaluationSlices(ctx, req.(*BatchImportModelEvaluationSlicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_BatchImportEvaluatedAnnotations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchImportEvaluatedAnnotationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).BatchImportEvaluatedAnnotations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_BatchImportEvaluatedAnnotations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).BatchImportEvaluatedAnnotations(ctx, req.(*BatchImportEvaluatedAnnotationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_GetModelEvaluation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetModelEvaluationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).GetModelEvaluation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_GetModelEvaluation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).GetModelEvaluation(ctx, req.(*GetModelEvaluationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_ListModelEvaluations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelEvaluationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).ListModelEvaluations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_ListModelEvaluations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).ListModelEvaluations(ctx, req.(*ListModelEvaluationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_GetModelEvaluationSlice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetModelEvaluationSliceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).GetModelEvaluationSlice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_GetModelEvaluationSlice_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).GetModelEvaluationSlice(ctx, req.(*GetModelEvaluationSliceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_ListModelEvaluationSlices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelEvaluationSlicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).ListModelEvaluationSlices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_ListModelEvaluationSlices_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).ListModelEvaluationSlices(ctx, req.(*ListModelEvaluationSlicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ModelService_ServiceDesc is the grpc.ServiceDesc for ModelService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ModelService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.ModelService",
	HandlerType: (*ModelServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "UploadModel",
			Handler:    _ModelService_UploadModel_Handler,
		},
		{
			MethodName: "GetModel",
			Handler:    _ModelService_GetModel_Handler,
		},
		{
			MethodName: "ListModels",
			Handler:    _ModelService_ListModels_Handler,
		},
		{
			MethodName: "ListModelVersions",
			Handler:    _ModelService_ListModelVersions_Handler,
		},
		{
			MethodName: "ListModelVersionCheckpoints",
			Handler:    _ModelService_ListModelVersionCheckpoints_Handler,
		},
		{
			MethodName: "UpdateModel",
			Handler:    _ModelService_UpdateModel_Handler,
		},
		{
			MethodName: "UpdateExplanationDataset",
			Handler:    _ModelService_UpdateExplanationDataset_Handler,
		},
		{
			MethodName: "DeleteModel",
			Handler:    _ModelService_DeleteModel_Handler,
		},
		{
			MethodName: "DeleteModelVersion",
			Handler:    _ModelService_DeleteModelVersion_Handler,
		},
		{
			MethodName: "MergeVersionAliases",
			Handler:    _ModelService_MergeVersionAliases_Handler,
		},
		{
			MethodName: "ExportModel",
			Handler:    _ModelService_ExportModel_Handler,
		},
		{
			MethodName: "CopyModel",
			Handler:    _ModelService_CopyModel_Handler,
		},
		{
			MethodName: "ImportModelEvaluation",
			Handler:    _ModelService_ImportModelEvaluation_Handler,
		},
		{
			MethodName: "BatchImportModelEvaluationSlices",
			Handler:    _ModelService_BatchImportModelEvaluationSlices_Handler,
		},
		{
			MethodName: "BatchImportEvaluatedAnnotations",
			Handler:    _ModelService_BatchImportEvaluatedAnnotations_Handler,
		},
		{
			MethodName: "GetModelEvaluation",
			Handler:    _ModelService_GetModelEvaluation_Handler,
		},
		{
			MethodName: "ListModelEvaluations",
			Handler:    _ModelService_ListModelEvaluations_Handler,
		},
		{
			MethodName: "GetModelEvaluationSlice",
			Handler:    _ModelService_GetModelEvaluationSlice_Handler,
		},
		{
			MethodName: "ListModelEvaluationSlices",
			Handler:    _ModelService_ListModelEvaluationSlices_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1beta1/model_service.proto",
}
